# System.Runtime.Intrinsics.Arm

``` diff
 namespace System.Runtime.Intrinsics.Arm {
     [CLSCompliantAttribute(false)]
     [RequiresPreviewFeaturesAttribute("Sve is in preview. Debugger scenario is not supported.")]
     public abstract class Sve : AdvSimd {
+        public static Vector<double> AbsoluteCompareGreaterThan(Vector<double> left, Vector<double> right);
+        public static Vector<float> AbsoluteCompareGreaterThan(Vector<float> left, Vector<float> right);
+        public static Vector<double> AbsoluteCompareGreaterThanOrEqual(Vector<double> left, Vector<double> right);
+        public static Vector<float> AbsoluteCompareGreaterThanOrEqual(Vector<float> left, Vector<float> right);
+        public static Vector<double> AbsoluteCompareLessThan(Vector<double> left, Vector<double> right);
+        public static Vector<float> AbsoluteCompareLessThan(Vector<float> left, Vector<float> right);
+        public static Vector<double> AbsoluteCompareLessThanOrEqual(Vector<double> left, Vector<double> right);
+        public static Vector<float> AbsoluteCompareLessThanOrEqual(Vector<float> left, Vector<float> right);
+        public static Vector<double> AddRotateComplex(Vector<double> left, Vector<double> right, [ConstantExpectedAttribute(Min=0, Max=(byte)1)] byte rotation);
+        public static Vector<float> AddRotateComplex(Vector<float> left, Vector<float> right, [ConstantExpectedAttribute(Min=0, Max=(byte)1)] byte rotation);
+        public static Vector<double> AddSequentialAcross(Vector<double> initial, Vector<double> value);
+        public static Vector<float> AddSequentialAcross(Vector<float> initial, Vector<float> value);
+        public static Vector<byte> CompareEqual(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> CompareEqual(Vector<double> left, Vector<double> right);
+        public static Vector<short> CompareEqual(Vector<short> left, Vector<short> right);
+        public static Vector<short> CompareEqual(Vector<short> left, Vector<long> right);
+        public static Vector<int> CompareEqual(Vector<int> left, Vector<int> right);
+        public static Vector<int> CompareEqual(Vector<int> left, Vector<long> right);
+        public static Vector<long> CompareEqual(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CompareEqual(Vector<sbyte> left, Vector<long> right);
+        public static Vector<sbyte> CompareEqual(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> CompareEqual(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> CompareEqual(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> CompareEqual(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> CompareEqual(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> CompareGreaterThan(Vector<byte> left, Vector<byte> right);
+        public static Vector<byte> CompareGreaterThan(Vector<byte> left, Vector<ulong> right);
+        public static Vector<double> CompareGreaterThan(Vector<double> left, Vector<double> right);
+        public static Vector<short> CompareGreaterThan(Vector<short> left, Vector<short> right);
+        public static Vector<short> CompareGreaterThan(Vector<short> left, Vector<long> right);
+        public static Vector<int> CompareGreaterThan(Vector<int> left, Vector<int> right);
+        public static Vector<int> CompareGreaterThan(Vector<int> left, Vector<long> right);
+        public static Vector<long> CompareGreaterThan(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CompareGreaterThan(Vector<sbyte> left, Vector<long> right);
+        public static Vector<sbyte> CompareGreaterThan(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> CompareGreaterThan(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> CompareGreaterThan(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<ushort> CompareGreaterThan(Vector<ushort> left, Vector<ulong> right);
+        public static Vector<uint> CompareGreaterThan(Vector<uint> left, Vector<uint> right);
+        public static Vector<uint> CompareGreaterThan(Vector<uint> left, Vector<ulong> right);
+        public static Vector<ulong> CompareGreaterThan(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> CompareGreaterThanOrEqual(Vector<byte> left, Vector<byte> right);
+        public static Vector<byte> CompareGreaterThanOrEqual(Vector<byte> left, Vector<ulong> right);
+        public static Vector<double> CompareGreaterThanOrEqual(Vector<double> left, Vector<double> right);
+        public static Vector<short> CompareGreaterThanOrEqual(Vector<short> left, Vector<short> right);
+        public static Vector<short> CompareGreaterThanOrEqual(Vector<short> left, Vector<long> right);
+        public static Vector<int> CompareGreaterThanOrEqual(Vector<int> left, Vector<int> right);
+        public static Vector<int> CompareGreaterThanOrEqual(Vector<int> left, Vector<long> right);
+        public static Vector<long> CompareGreaterThanOrEqual(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CompareGreaterThanOrEqual(Vector<sbyte> left, Vector<long> right);
+        public static Vector<sbyte> CompareGreaterThanOrEqual(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> CompareGreaterThanOrEqual(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> CompareGreaterThanOrEqual(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<ushort> CompareGreaterThanOrEqual(Vector<ushort> left, Vector<ulong> right);
+        public static Vector<uint> CompareGreaterThanOrEqual(Vector<uint> left, Vector<uint> right);
+        public static Vector<uint> CompareGreaterThanOrEqual(Vector<uint> left, Vector<ulong> right);
+        public static Vector<ulong> CompareGreaterThanOrEqual(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> CompareLessThan(Vector<byte> left, Vector<byte> right);
+        public static Vector<byte> CompareLessThan(Vector<byte> left, Vector<ulong> right);
+        public static Vector<double> CompareLessThan(Vector<double> left, Vector<double> right);
+        public static Vector<short> CompareLessThan(Vector<short> left, Vector<short> right);
+        public static Vector<short> CompareLessThan(Vector<short> left, Vector<long> right);
+        public static Vector<int> CompareLessThan(Vector<int> left, Vector<int> right);
+        public static Vector<int> CompareLessThan(Vector<int> left, Vector<long> right);
+        public static Vector<long> CompareLessThan(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CompareLessThan(Vector<sbyte> left, Vector<long> right);
+        public static Vector<sbyte> CompareLessThan(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> CompareLessThan(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> CompareLessThan(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<ushort> CompareLessThan(Vector<ushort> left, Vector<ulong> right);
+        public static Vector<uint> CompareLessThan(Vector<uint> left, Vector<uint> right);
+        public static Vector<uint> CompareLessThan(Vector<uint> left, Vector<ulong> right);
+        public static Vector<ulong> CompareLessThan(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> CompareLessThanOrEqual(Vector<byte> left, Vector<byte> right);
+        public static Vector<byte> CompareLessThanOrEqual(Vector<byte> left, Vector<ulong> right);
+        public static Vector<double> CompareLessThanOrEqual(Vector<double> left, Vector<double> right);
+        public static Vector<short> CompareLessThanOrEqual(Vector<short> left, Vector<short> right);
+        public static Vector<short> CompareLessThanOrEqual(Vector<short> left, Vector<long> right);
+        public static Vector<int> CompareLessThanOrEqual(Vector<int> left, Vector<int> right);
+        public static Vector<int> CompareLessThanOrEqual(Vector<int> left, Vector<long> right);
+        public static Vector<long> CompareLessThanOrEqual(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CompareLessThanOrEqual(Vector<sbyte> left, Vector<long> right);
+        public static Vector<sbyte> CompareLessThanOrEqual(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> CompareLessThanOrEqual(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> CompareLessThanOrEqual(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<ushort> CompareLessThanOrEqual(Vector<ushort> left, Vector<ulong> right);
+        public static Vector<uint> CompareLessThanOrEqual(Vector<uint> left, Vector<uint> right);
+        public static Vector<uint> CompareLessThanOrEqual(Vector<uint> left, Vector<ulong> right);
+        public static Vector<ulong> CompareLessThanOrEqual(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> CompareNotEqualTo(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> CompareNotEqualTo(Vector<double> left, Vector<double> right);
+        public static Vector<short> CompareNotEqualTo(Vector<short> left, Vector<short> right);
+        public static Vector<short> CompareNotEqualTo(Vector<short> left, Vector<long> right);
+        public static Vector<int> CompareNotEqualTo(Vector<int> left, Vector<int> right);
+        public static Vector<int> CompareNotEqualTo(Vector<int> left, Vector<long> right);
+        public static Vector<long> CompareNotEqualTo(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CompareNotEqualTo(Vector<sbyte> left, Vector<long> right);
+        public static Vector<sbyte> CompareNotEqualTo(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> CompareNotEqualTo(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> CompareNotEqualTo(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> CompareNotEqualTo(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> CompareNotEqualTo(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<double> CompareUnordered(Vector<double> left, Vector<double> right);
+        public static Vector<float> CompareUnordered(Vector<float> left, Vector<float> right);
+        public static byte ConditionalExtractAfterLastActiveElement(Vector<byte> mask, byte defaultValues, Vector<byte> data);
+        public static Vector<byte> ConditionalExtractAfterLastActiveElement(Vector<byte> mask, Vector<byte> defaultValue, Vector<byte> data);
+        public static double ConditionalExtractAfterLastActiveElement(Vector<double> mask, double defaultValues, Vector<double> data);
+        public static Vector<double> ConditionalExtractAfterLastActiveElement(Vector<double> mask, Vector<double> defaultValue, Vector<double> data);
+        public static short ConditionalExtractAfterLastActiveElement(Vector<short> mask, short defaultValues, Vector<short> data);
+        public static Vector<short> ConditionalExtractAfterLastActiveElement(Vector<short> mask, Vector<short> defaultValue, Vector<short> data);
+        public static int ConditionalExtractAfterLastActiveElement(Vector<int> mask, int defaultValues, Vector<int> data);
+        public static Vector<int> ConditionalExtractAfterLastActiveElement(Vector<int> mask, Vector<int> defaultValue, Vector<int> data);
+        public static long ConditionalExtractAfterLastActiveElement(Vector<long> mask, long defaultValues, Vector<long> data);
+        public static Vector<long> ConditionalExtractAfterLastActiveElement(Vector<long> mask, Vector<long> defaultValue, Vector<long> data);
+        public static Vector<sbyte> ConditionalExtractAfterLastActiveElement(Vector<sbyte> mask, Vector<sbyte> defaultValue, Vector<sbyte> data);
+        public static sbyte ConditionalExtractAfterLastActiveElement(Vector<sbyte> mask, sbyte defaultValues, Vector<sbyte> data);
+        public static Vector<float> ConditionalExtractAfterLastActiveElement(Vector<float> mask, Vector<float> defaultValue, Vector<float> data);
+        public static float ConditionalExtractAfterLastActiveElement(Vector<float> mask, float defaultValues, Vector<float> data);
+        public static Vector<ushort> ConditionalExtractAfterLastActiveElement(Vector<ushort> mask, Vector<ushort> defaultValue, Vector<ushort> data);
+        public static ushort ConditionalExtractAfterLastActiveElement(Vector<ushort> mask, ushort defaultValues, Vector<ushort> data);
+        public static Vector<uint> ConditionalExtractAfterLastActiveElement(Vector<uint> mask, Vector<uint> defaultValue, Vector<uint> data);
+        public static uint ConditionalExtractAfterLastActiveElement(Vector<uint> mask, uint defaultValues, Vector<uint> data);
+        public static Vector<ulong> ConditionalExtractAfterLastActiveElement(Vector<ulong> mask, Vector<ulong> defaultValue, Vector<ulong> data);
+        public static ulong ConditionalExtractAfterLastActiveElement(Vector<ulong> mask, ulong defaultValues, Vector<ulong> data);
+        public static Vector<byte> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<byte> mask, Vector<byte> defaultScalar, Vector<byte> data);
+        public static Vector<double> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<double> mask, Vector<double> defaultScalar, Vector<double> data);
+        public static Vector<short> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<short> mask, Vector<short> defaultScalar, Vector<short> data);
+        public static Vector<int> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<int> mask, Vector<int> defaultScalar, Vector<int> data);
+        public static Vector<long> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<long> mask, Vector<long> defaultScalar, Vector<long> data);
+        public static Vector<sbyte> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<sbyte> mask, Vector<sbyte> defaultScalar, Vector<sbyte> data);
+        public static Vector<float> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<float> mask, Vector<float> defaultScalar, Vector<float> data);
+        public static Vector<ushort> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<ushort> mask, Vector<ushort> defaultScalar, Vector<ushort> data);
+        public static Vector<uint> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<uint> mask, Vector<uint> defaultScalar, Vector<uint> data);
+        public static Vector<ulong> ConditionalExtractAfterLastActiveElementAndReplicate(Vector<ulong> mask, Vector<ulong> defaultScalar, Vector<ulong> data);
+        public static byte ConditionalExtractLastActiveElement(Vector<byte> mask, byte defaultValues, Vector<byte> data);
+        public static Vector<byte> ConditionalExtractLastActiveElement(Vector<byte> mask, Vector<byte> defaultValue, Vector<byte> data);
+        public static double ConditionalExtractLastActiveElement(Vector<double> mask, double defaultValues, Vector<double> data);
+        public static Vector<double> ConditionalExtractLastActiveElement(Vector<double> mask, Vector<double> defaultValue, Vector<double> data);
+        public static short ConditionalExtractLastActiveElement(Vector<short> mask, short defaultValues, Vector<short> data);
+        public static Vector<short> ConditionalExtractLastActiveElement(Vector<short> mask, Vector<short> defaultValue, Vector<short> data);
+        public static int ConditionalExtractLastActiveElement(Vector<int> mask, int defaultValues, Vector<int> data);
+        public static Vector<int> ConditionalExtractLastActiveElement(Vector<int> mask, Vector<int> defaultValue, Vector<int> data);
+        public static long ConditionalExtractLastActiveElement(Vector<long> mask, long defaultValues, Vector<long> data);
+        public static Vector<long> ConditionalExtractLastActiveElement(Vector<long> mask, Vector<long> defaultValue, Vector<long> data);
+        public static Vector<sbyte> ConditionalExtractLastActiveElement(Vector<sbyte> mask, Vector<sbyte> defaultValue, Vector<sbyte> data);
+        public static sbyte ConditionalExtractLastActiveElement(Vector<sbyte> mask, sbyte defaultValues, Vector<sbyte> data);
+        public static Vector<float> ConditionalExtractLastActiveElement(Vector<float> mask, Vector<float> defaultValue, Vector<float> data);
+        public static float ConditionalExtractLastActiveElement(Vector<float> mask, float defaultValues, Vector<float> data);
+        public static Vector<ushort> ConditionalExtractLastActiveElement(Vector<ushort> mask, Vector<ushort> defaultValue, Vector<ushort> data);
+        public static ushort ConditionalExtractLastActiveElement(Vector<ushort> mask, ushort defaultValues, Vector<ushort> data);
+        public static Vector<uint> ConditionalExtractLastActiveElement(Vector<uint> mask, Vector<uint> defaultValue, Vector<uint> data);
+        public static uint ConditionalExtractLastActiveElement(Vector<uint> mask, uint defaultValues, Vector<uint> data);
+        public static Vector<ulong> ConditionalExtractLastActiveElement(Vector<ulong> mask, Vector<ulong> defaultValue, Vector<ulong> data);
+        public static ulong ConditionalExtractLastActiveElement(Vector<ulong> mask, ulong defaultValues, Vector<ulong> data);
+        public static Vector<byte> ConditionalExtractLastActiveElementAndReplicate(Vector<byte> mask, Vector<byte> fallback, Vector<byte> data);
+        public static Vector<double> ConditionalExtractLastActiveElementAndReplicate(Vector<double> mask, Vector<double> fallback, Vector<double> data);
+        public static Vector<short> ConditionalExtractLastActiveElementAndReplicate(Vector<short> mask, Vector<short> fallback, Vector<short> data);
+        public static Vector<int> ConditionalExtractLastActiveElementAndReplicate(Vector<int> mask, Vector<int> fallback, Vector<int> data);
+        public static Vector<long> ConditionalExtractLastActiveElementAndReplicate(Vector<long> mask, Vector<long> fallback, Vector<long> data);
+        public static Vector<sbyte> ConditionalExtractLastActiveElementAndReplicate(Vector<sbyte> mask, Vector<sbyte> fallback, Vector<sbyte> data);
+        public static Vector<float> ConditionalExtractLastActiveElementAndReplicate(Vector<float> mask, Vector<float> fallback, Vector<float> data);
+        public static Vector<ushort> ConditionalExtractLastActiveElementAndReplicate(Vector<ushort> mask, Vector<ushort> fallback, Vector<ushort> data);
+        public static Vector<uint> ConditionalExtractLastActiveElementAndReplicate(Vector<uint> mask, Vector<uint> fallback, Vector<uint> data);
+        public static Vector<ulong> ConditionalExtractLastActiveElementAndReplicate(Vector<ulong> mask, Vector<ulong> fallback, Vector<ulong> data);
+        public static Vector<double> ConvertToDouble(Vector<int> value);
+        public static Vector<double> ConvertToDouble(Vector<long> value);
+        public static Vector<double> ConvertToDouble(Vector<float> value);
+        public static Vector<double> ConvertToDouble(Vector<uint> value);
+        public static Vector<double> ConvertToDouble(Vector<ulong> value);
+        public static Vector<long> ConvertToInt64(Vector<double> value);
+        public static Vector<long> ConvertToInt64(Vector<float> value);
+        public static Vector<float> ConvertToSingle(Vector<double> value);
+        public static Vector<float> ConvertToSingle(Vector<int> value);
+        public static Vector<float> ConvertToSingle(Vector<long> value);
+        public static Vector<float> ConvertToSingle(Vector<uint> value);
+        public static Vector<float> ConvertToSingle(Vector<ulong> value);
+        public static Vector<ulong> ConvertToUInt64(Vector<double> value);
+        public static Vector<ulong> ConvertToUInt64(Vector<float> value);
+        public static Vector<byte> CreateBreakAfterMask(Vector<byte> mask, Vector<byte> srcMask);
+        public static Vector<short> CreateBreakAfterMask(Vector<short> mask, Vector<short> srcMask);
+        public static Vector<int> CreateBreakAfterMask(Vector<int> mask, Vector<int> srcMask);
+        public static Vector<long> CreateBreakAfterMask(Vector<long> mask, Vector<long> srcMask);
+        public static Vector<sbyte> CreateBreakAfterMask(Vector<sbyte> mask, Vector<sbyte> srcMask);
+        public static Vector<ushort> CreateBreakAfterMask(Vector<ushort> mask, Vector<ushort> srcMask);
+        public static Vector<uint> CreateBreakAfterMask(Vector<uint> mask, Vector<uint> srcMask);
+        public static Vector<ulong> CreateBreakAfterMask(Vector<ulong> mask, Vector<ulong> srcMask);
+        public static Vector<byte> CreateBreakAfterPropagateMask(Vector<byte> mask, Vector<byte> left, Vector<byte> right);
+        public static Vector<short> CreateBreakAfterPropagateMask(Vector<short> mask, Vector<short> left, Vector<short> right);
+        public static Vector<int> CreateBreakAfterPropagateMask(Vector<int> mask, Vector<int> left, Vector<int> right);
+        public static Vector<long> CreateBreakAfterPropagateMask(Vector<long> mask, Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CreateBreakAfterPropagateMask(Vector<sbyte> mask, Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> CreateBreakAfterPropagateMask(Vector<ushort> mask, Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> CreateBreakAfterPropagateMask(Vector<uint> mask, Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> CreateBreakAfterPropagateMask(Vector<ulong> mask, Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> CreateBreakBeforeMask(Vector<byte> mask, Vector<byte> srcMask);
+        public static Vector<short> CreateBreakBeforeMask(Vector<short> mask, Vector<short> srcMask);
+        public static Vector<int> CreateBreakBeforeMask(Vector<int> mask, Vector<int> srcMask);
+        public static Vector<long> CreateBreakBeforeMask(Vector<long> mask, Vector<long> srcMask);
+        public static Vector<sbyte> CreateBreakBeforeMask(Vector<sbyte> mask, Vector<sbyte> srcMask);
+        public static Vector<ushort> CreateBreakBeforeMask(Vector<ushort> mask, Vector<ushort> srcMask);
+        public static Vector<uint> CreateBreakBeforeMask(Vector<uint> mask, Vector<uint> srcMask);
+        public static Vector<ulong> CreateBreakBeforeMask(Vector<ulong> mask, Vector<ulong> srcMask);
+        public static Vector<byte> CreateBreakBeforePropagateMask(Vector<byte> mask, Vector<byte> left, Vector<byte> right);
+        public static Vector<short> CreateBreakBeforePropagateMask(Vector<short> mask, Vector<short> left, Vector<short> right);
+        public static Vector<int> CreateBreakBeforePropagateMask(Vector<int> mask, Vector<int> left, Vector<int> right);
+        public static Vector<long> CreateBreakBeforePropagateMask(Vector<long> mask, Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> CreateBreakBeforePropagateMask(Vector<sbyte> mask, Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> CreateBreakBeforePropagateMask(Vector<ushort> mask, Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> CreateBreakBeforePropagateMask(Vector<uint> mask, Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> CreateBreakBeforePropagateMask(Vector<ulong> mask, Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> CreateBreakPropagateMask(Vector<byte> totalMask, Vector<byte> fromMask);
+        public static Vector<short> CreateBreakPropagateMask(Vector<short> totalMask, Vector<short> fromMask);
+        public static Vector<int> CreateBreakPropagateMask(Vector<int> totalMask, Vector<int> fromMask);
+        public static Vector<long> CreateBreakPropagateMask(Vector<long> totalMask, Vector<long> fromMask);
+        public static Vector<sbyte> CreateBreakPropagateMask(Vector<sbyte> totalMask, Vector<sbyte> fromMask);
+        public static Vector<ushort> CreateBreakPropagateMask(Vector<ushort> totalMask, Vector<ushort> fromMask);
+        public static Vector<uint> CreateBreakPropagateMask(Vector<uint> totalMask, Vector<uint> fromMask);
+        public static Vector<ulong> CreateBreakPropagateMask(Vector<ulong> totalMask, Vector<ulong> fromMask);
+        public static Vector<byte> CreateMaskForFirstActiveElement(Vector<byte> mask, Vector<byte> srcMask);
+        public static Vector<short> CreateMaskForFirstActiveElement(Vector<short> mask, Vector<short> srcMask);
+        public static Vector<int> CreateMaskForFirstActiveElement(Vector<int> mask, Vector<int> srcMask);
+        public static Vector<long> CreateMaskForFirstActiveElement(Vector<long> mask, Vector<long> srcMask);
+        public static Vector<sbyte> CreateMaskForFirstActiveElement(Vector<sbyte> mask, Vector<sbyte> srcMask);
+        public static Vector<ushort> CreateMaskForFirstActiveElement(Vector<ushort> mask, Vector<ushort> srcMask);
+        public static Vector<uint> CreateMaskForFirstActiveElement(Vector<uint> mask, Vector<uint> srcMask);
+        public static Vector<ulong> CreateMaskForFirstActiveElement(Vector<ulong> mask, Vector<ulong> srcMask);
+        public static Vector<byte> CreateMaskForNextActiveElement(Vector<byte> mask, Vector<byte> srcMask);
+        public static Vector<ushort> CreateMaskForNextActiveElement(Vector<ushort> mask, Vector<ushort> srcMask);
+        public static Vector<uint> CreateMaskForNextActiveElement(Vector<uint> mask, Vector<uint> srcMask);
+        public static Vector<ulong> CreateMaskForNextActiveElement(Vector<ulong> mask, Vector<ulong> srcMask);
+        public static Vector<byte> DuplicateSelectedScalarToVector(Vector<byte> data, [ConstantExpectedAttribute(Min=0, Max=(byte)63)] byte index);
+        public static Vector<double> DuplicateSelectedScalarToVector(Vector<double> data, [ConstantExpectedAttribute(Min=0, Max=(byte)7)] byte index);
+        public static Vector<short> DuplicateSelectedScalarToVector(Vector<short> data, [ConstantExpectedAttribute(Min=0, Max=(byte)31)] byte index);
+        public static Vector<int> DuplicateSelectedScalarToVector(Vector<int> data, [ConstantExpectedAttribute(Min=0, Max=(byte)15)] byte index);
+        public static Vector<long> DuplicateSelectedScalarToVector(Vector<long> data, [ConstantExpectedAttribute(Min=0, Max=(byte)7)] byte index);
+        public static Vector<sbyte> DuplicateSelectedScalarToVector(Vector<sbyte> data, [ConstantExpectedAttribute(Min=0, Max=(byte)63)] byte index);
+        public static Vector<float> DuplicateSelectedScalarToVector(Vector<float> data, [ConstantExpectedAttribute(Min=0, Max=(byte)15)] byte index);
+        public static Vector<ushort> DuplicateSelectedScalarToVector(Vector<ushort> data, [ConstantExpectedAttribute(Min=0, Max=(byte)31)] byte index);
+        public static Vector<uint> DuplicateSelectedScalarToVector(Vector<uint> data, [ConstantExpectedAttribute(Min=0, Max=(byte)15)] byte index);
+        public static Vector<ulong> DuplicateSelectedScalarToVector(Vector<ulong> data, [ConstantExpectedAttribute(Min=0, Max=(byte)7)] byte index);
+        public static Vector<byte> ExtractVector(Vector<byte> upper, Vector<byte> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<double> ExtractVector(Vector<double> upper, Vector<double> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<short> ExtractVector(Vector<short> upper, Vector<short> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<int> ExtractVector(Vector<int> upper, Vector<int> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<long> ExtractVector(Vector<long> upper, Vector<long> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<sbyte> ExtractVector(Vector<sbyte> upper, Vector<sbyte> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<float> ExtractVector(Vector<float> upper, Vector<float> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<ushort> ExtractVector(Vector<ushort> upper, Vector<ushort> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<uint> ExtractVector(Vector<uint> upper, Vector<uint> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<ulong> ExtractVector(Vector<ulong> upper, Vector<ulong> lower, [ConstantExpectedAttribute] byte index);
+        public static Vector<float> FloatingPointExponentialAccelerator(Vector<uint> value);
+        public static Vector<double> FloatingPointExponentialAccelerator(Vector<ulong> value);
+        public static void GatherPrefetch16Bit(Vector<short> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch16Bit(Vector<short> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<short> mask, void* address, Vector<int> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<short> mask, void* address, Vector<long> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<short> mask, void* address, Vector<uint> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<short> mask, void* address, Vector<ulong> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch16Bit(Vector<ushort> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch16Bit(Vector<ushort> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<ushort> mask, void* address, Vector<int> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<ushort> mask, void* address, Vector<long> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<ushort> mask, void* address, Vector<uint> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch16Bit(Vector<ushort> mask, void* address, Vector<ulong> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch32Bit(Vector<int> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch32Bit(Vector<int> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<int> mask, void* address, Vector<int> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<int> mask, void* address, Vector<long> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<int> mask, void* address, Vector<uint> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<int> mask, void* address, Vector<ulong> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch32Bit(Vector<uint> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch32Bit(Vector<uint> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<uint> mask, void* address, Vector<int> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<uint> mask, void* address, Vector<long> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<uint> mask, void* address, Vector<uint> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch32Bit(Vector<uint> mask, void* address, Vector<ulong> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch64Bit(Vector<long> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch64Bit(Vector<long> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<long> mask, void* address, Vector<int> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<long> mask, void* address, Vector<long> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<long> mask, void* address, Vector<uint> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<long> mask, void* address, Vector<ulong> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch64Bit(Vector<ulong> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch64Bit(Vector<ulong> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<ulong> mask, void* address, Vector<int> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<ulong> mask, void* address, Vector<long> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<ulong> mask, void* address, Vector<uint> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch64Bit(Vector<ulong> mask, void* address, Vector<ulong> indices, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch8Bit(Vector<byte> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch8Bit(Vector<byte> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<byte> mask, void* address, Vector<int> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<byte> mask, void* address, Vector<long> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<byte> mask, void* address, Vector<uint> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<byte> mask, void* address, Vector<ulong> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch8Bit(Vector<sbyte> mask, Vector<uint> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static void GatherPrefetch8Bit(Vector<sbyte> mask, Vector<ulong> addresses, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<sbyte> mask, void* address, Vector<int> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<sbyte> mask, void* address, Vector<long> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<sbyte> mask, void* address, Vector<uint> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public unsafe static void GatherPrefetch8Bit(Vector<sbyte> mask, void* address, Vector<ulong> offsets, [ConstantExpectedAttribute] SvePrefetchType prefetchType);
+        public static Vector<byte> InsertIntoShiftedVector(Vector<byte> left, byte right);
+        public static Vector<double> InsertIntoShiftedVector(Vector<double> left, double right);
+        public static Vector<short> InsertIntoShiftedVector(Vector<short> left, short right);
+        public static Vector<int> InsertIntoShiftedVector(Vector<int> left, int right);
+        public static Vector<long> InsertIntoShiftedVector(Vector<long> left, long right);
+        public static Vector<sbyte> InsertIntoShiftedVector(Vector<sbyte> left, sbyte right);
+        public static Vector<float> InsertIntoShiftedVector(Vector<float> left, float right);
+        public static Vector<ushort> InsertIntoShiftedVector(Vector<ushort> left, ushort right);
+        public static Vector<uint> InsertIntoShiftedVector(Vector<uint> left, uint right);
+        public static Vector<ulong> InsertIntoShiftedVector(Vector<ulong> left, ulong right);
+        public static Vector<double> MultiplyAddRotateComplex(Vector<double> addend, Vector<double> left, Vector<double> right, [ConstantExpectedAttribute(Min=0, Max=(byte)3)] byte rotation);
+        public static Vector<float> MultiplyAddRotateComplex(Vector<float> addend, Vector<float> left, Vector<float> right, [ConstantExpectedAttribute(Min=0, Max=(byte)3)] byte rotation);
+        public static Vector<float> MultiplyAddRotateComplexBySelectedScalar(Vector<float> addend, Vector<float> left, Vector<float> right, [ConstantExpectedAttribute(Min=0, Max=(byte)1)] byte rightIndex, [ConstantExpectedAttribute(Min=0, Max=(byte)3)] byte rotation);
+        public static Vector<byte> Not(Vector<byte> value);
+        public static Vector<short> Not(Vector<short> value);
+        public static Vector<int> Not(Vector<int> value);
+        public static Vector<long> Not(Vector<long> value);
+        public static Vector<sbyte> Not(Vector<sbyte> value);
+        public static Vector<ushort> Not(Vector<ushort> value);
+        public static Vector<uint> Not(Vector<uint> value);
+        public static Vector<ulong> Not(Vector<ulong> value);
+        public static Vector<double> ReciprocalEstimate(Vector<double> value);
+        public static Vector<float> ReciprocalEstimate(Vector<float> value);
+        public static Vector<double> ReciprocalExponent(Vector<double> value);
+        public static Vector<float> ReciprocalExponent(Vector<float> value);
+        public static Vector<double> ReciprocalSqrtEstimate(Vector<double> value);
+        public static Vector<float> ReciprocalSqrtEstimate(Vector<float> value);
+        public static Vector<double> ReciprocalSqrtStep(Vector<double> left, Vector<double> right);
+        public static Vector<float> ReciprocalSqrtStep(Vector<float> left, Vector<float> right);
+        public static Vector<double> ReciprocalStep(Vector<double> left, Vector<double> right);
+        public static Vector<float> ReciprocalStep(Vector<float> left, Vector<float> right);
+        public static Vector<byte> ReverseBits(Vector<byte> value);
+        public static Vector<short> ReverseBits(Vector<short> value);
+        public static Vector<int> ReverseBits(Vector<int> value);
+        public static Vector<long> ReverseBits(Vector<long> value);
+        public static Vector<sbyte> ReverseBits(Vector<sbyte> value);
+        public static Vector<ushort> ReverseBits(Vector<ushort> value);
+        public static Vector<uint> ReverseBits(Vector<uint> value);
+        public static Vector<ulong> ReverseBits(Vector<ulong> value);
+        public static Vector<double> Scale(Vector<double> left, Vector<long> right);
+        public static Vector<float> Scale(Vector<float> left, Vector<int> right);
+        public unsafe static void Scatter(Vector<double> mask, double* address, Vector<long> indicies, Vector<double> data);
+        public unsafe static void Scatter(Vector<double> mask, double* address, Vector<ulong> indicies, Vector<double> data);
+        public static void Scatter(Vector<double> mask, Vector<ulong> addresses, Vector<double> data);
+        public unsafe static void Scatter(Vector<int> mask, int* address, Vector<int> indicies, Vector<int> data);
+        public unsafe static void Scatter(Vector<int> mask, int* address, Vector<uint> indicies, Vector<int> data);
+        public unsafe static void Scatter(Vector<long> mask, long* address, Vector<long> indicies, Vector<long> data);
+        public unsafe static void Scatter(Vector<long> mask, long* address, Vector<ulong> indicies, Vector<long> data);
+        public static void Scatter(Vector<long> mask, Vector<ulong> addresses, Vector<long> data);
+        public unsafe static void Scatter(Vector<float> mask, float* address, Vector<int> indicies, Vector<float> data);
+        public unsafe static void Scatter(Vector<float> mask, float* address, Vector<uint> indicies, Vector<float> data);
+        public unsafe static void Scatter(Vector<uint> mask, uint* address, Vector<int> indicies, Vector<uint> data);
+        public unsafe static void Scatter(Vector<uint> mask, uint* address, Vector<uint> indicies, Vector<uint> data);
+        public static void Scatter(Vector<ulong> mask, Vector<ulong> addresses, Vector<ulong> data);
+        public unsafe static void Scatter(Vector<ulong> mask, ulong* address, Vector<long> indicies, Vector<ulong> data);
+        public unsafe static void Scatter(Vector<ulong> mask, ulong* address, Vector<ulong> indicies, Vector<ulong> data);
+        public static void Scatter16BitNarrowing(Vector<long> mask, Vector<ulong> addresses, Vector<long> data);
+        public static void Scatter16BitNarrowing(Vector<ulong> mask, Vector<ulong> addresses, Vector<ulong> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<int> mask, short* address, Vector<int> offsets, Vector<int> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<int> mask, short* address, Vector<uint> offsets, Vector<int> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<long> mask, short* address, Vector<long> offsets, Vector<long> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<long> mask, short* address, Vector<ulong> offsets, Vector<long> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<uint> mask, ushort* address, Vector<int> offsets, Vector<uint> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<uint> mask, ushort* address, Vector<uint> offsets, Vector<uint> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<ulong> mask, ushort* address, Vector<long> offsets, Vector<ulong> data);
+        public unsafe static void Scatter16BitWithByteOffsetsNarrowing(Vector<ulong> mask, ushort* address, Vector<ulong> offsets, Vector<ulong> data);
+        public static void Scatter32BitNarrowing(Vector<long> mask, Vector<ulong> addresses, Vector<long> data);
+        public static void Scatter32BitNarrowing(Vector<ulong> mask, Vector<ulong> addresses, Vector<ulong> data);
+        public unsafe static void Scatter32BitWithByteOffsetsNarrowing(Vector<long> mask, int* address, Vector<long> offsets, Vector<long> data);
+        public unsafe static void Scatter32BitWithByteOffsetsNarrowing(Vector<long> mask, int* address, Vector<ulong> offsets, Vector<long> data);
+        public unsafe static void Scatter32BitWithByteOffsetsNarrowing(Vector<ulong> mask, uint* address, Vector<long> offsets, Vector<ulong> data);
+        public unsafe static void Scatter32BitWithByteOffsetsNarrowing(Vector<ulong> mask, uint* address, Vector<ulong> offsets, Vector<ulong> data);
+        public static void Scatter8BitNarrowing(Vector<long> mask, Vector<ulong> addresses, Vector<long> data);
+        public static void Scatter8BitNarrowing(Vector<ulong> mask, Vector<ulong> addresses, Vector<ulong> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<int> mask, sbyte* address, Vector<int> offsets, Vector<int> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<int> mask, sbyte* address, Vector<uint> offsets, Vector<int> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<long> mask, sbyte* address, Vector<long> offsets, Vector<long> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<long> mask, sbyte* address, Vector<ulong> offsets, Vector<long> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<uint> mask, byte* address, Vector<int> offsets, Vector<uint> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<uint> mask, byte* address, Vector<uint> offsets, Vector<uint> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<ulong> mask, byte* address, Vector<long> offsets, Vector<ulong> data);
+        public unsafe static void Scatter8BitWithByteOffsetsNarrowing(Vector<ulong> mask, byte* address, Vector<ulong> offsets, Vector<ulong> data);
+        public static Vector<byte> ShiftLeftLogical(Vector<byte> left, Vector<byte> right);
+        public static Vector<byte> ShiftLeftLogical(Vector<byte> left, Vector<ulong> right);
+        public static Vector<short> ShiftLeftLogical(Vector<short> left, Vector<ushort> right);
+        public static Vector<short> ShiftLeftLogical(Vector<short> left, Vector<ulong> right);
+        public static Vector<int> ShiftLeftLogical(Vector<int> left, Vector<uint> right);
+        public static Vector<int> ShiftLeftLogical(Vector<int> left, Vector<ulong> right);
+        public static Vector<long> ShiftLeftLogical(Vector<long> left, Vector<ulong> right);
+        public static Vector<sbyte> ShiftLeftLogical(Vector<sbyte> left, Vector<byte> right);
+        public static Vector<sbyte> ShiftLeftLogical(Vector<sbyte> left, Vector<ulong> right);
+        public static Vector<ushort> ShiftLeftLogical(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<ushort> ShiftLeftLogical(Vector<ushort> left, Vector<ulong> right);
+        public static Vector<uint> ShiftLeftLogical(Vector<uint> left, Vector<uint> right);
+        public static Vector<uint> ShiftLeftLogical(Vector<uint> left, Vector<ulong> right);
+        public static Vector<ulong> ShiftLeftLogical(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<short> ShiftRightArithmetic(Vector<short> left, Vector<ushort> right);
+        public static Vector<short> ShiftRightArithmetic(Vector<short> left, Vector<ulong> right);
+        public static Vector<int> ShiftRightArithmetic(Vector<int> left, Vector<uint> right);
+        public static Vector<int> ShiftRightArithmetic(Vector<int> left, Vector<ulong> right);
+        public static Vector<long> ShiftRightArithmetic(Vector<long> left, Vector<ulong> right);
+        public static Vector<sbyte> ShiftRightArithmetic(Vector<sbyte> left, Vector<byte> right);
+        public static Vector<sbyte> ShiftRightArithmetic(Vector<sbyte> left, Vector<ulong> right);
+        public static Vector<short> ShiftRightArithmeticForDivide(Vector<short> value, [ConstantExpectedAttribute(Min=1, Max=(byte)16)] byte control);
+        public static Vector<int> ShiftRightArithmeticForDivide(Vector<int> value, [ConstantExpectedAttribute(Min=1, Max=(byte)32)] byte control);
+        public static Vector<long> ShiftRightArithmeticForDivide(Vector<long> value, [ConstantExpectedAttribute(Min=1, Max=(byte)64)] byte control);
+        public static Vector<sbyte> ShiftRightArithmeticForDivide(Vector<sbyte> value, [ConstantExpectedAttribute(Min=1, Max=(byte)8)] byte control);
+        public static Vector<byte> ShiftRightLogical(Vector<byte> left, Vector<byte> right);
+        public static Vector<byte> ShiftRightLogical(Vector<byte> left, Vector<ulong> right);
+        public static Vector<ushort> ShiftRightLogical(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<ushort> ShiftRightLogical(Vector<ushort> left, Vector<ulong> right);
+        public static Vector<uint> ShiftRightLogical(Vector<uint> left, Vector<uint> right);
+        public static Vector<uint> ShiftRightLogical(Vector<uint> left, Vector<ulong> right);
+        public static Vector<ulong> ShiftRightLogical(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> Splice(Vector<byte> mask, Vector<byte> left, Vector<byte> right);
+        public static Vector<double> Splice(Vector<double> mask, Vector<double> left, Vector<double> right);
+        public static Vector<short> Splice(Vector<short> mask, Vector<short> left, Vector<short> right);
+        public static Vector<int> Splice(Vector<int> mask, Vector<int> left, Vector<int> right);
+        public static Vector<long> Splice(Vector<long> mask, Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Splice(Vector<sbyte> mask, Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> Splice(Vector<float> mask, Vector<float> left, Vector<float> right);
+        public static Vector<ushort> Splice(Vector<ushort> mask, Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Splice(Vector<uint> mask, Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Splice(Vector<ulong> mask, Vector<ulong> left, Vector<ulong> right);
+        public static Vector<double> Sqrt(Vector<double> value);
+        public static Vector<float> Sqrt(Vector<float> value);
+        public static bool TestAnyTrue(Vector<byte> mask, Vector<byte> srcMask);
+        public static bool TestAnyTrue(Vector<short> mask, Vector<short> srcMask);
+        public static bool TestAnyTrue(Vector<int> mask, Vector<int> srcMask);
+        public static bool TestAnyTrue(Vector<long> mask, Vector<long> srcMask);
+        public static bool TestAnyTrue(Vector<sbyte> mask, Vector<sbyte> srcMask);
+        public static bool TestAnyTrue(Vector<ushort> mask, Vector<ushort> srcMask);
+        public static bool TestAnyTrue(Vector<uint> mask, Vector<uint> srcMask);
+        public static bool TestAnyTrue(Vector<ulong> mask, Vector<ulong> srcMask);
+        public static bool TestFirstTrue(Vector<byte> mask, Vector<byte> srcMask);
+        public static bool TestFirstTrue(Vector<short> mask, Vector<short> srcMask);
+        public static bool TestFirstTrue(Vector<int> mask, Vector<int> srcMask);
+        public static bool TestFirstTrue(Vector<long> mask, Vector<long> srcMask);
+        public static bool TestFirstTrue(Vector<sbyte> mask, Vector<sbyte> srcMask);
+        public static bool TestFirstTrue(Vector<ushort> mask, Vector<ushort> srcMask);
+        public static bool TestFirstTrue(Vector<uint> mask, Vector<uint> srcMask);
+        public static bool TestFirstTrue(Vector<ulong> mask, Vector<ulong> srcMask);
+        public static bool TestLastTrue(Vector<byte> mask, Vector<byte> srcMask);
+        public static bool TestLastTrue(Vector<short> mask, Vector<short> srcMask);
+        public static bool TestLastTrue(Vector<int> mask, Vector<int> srcMask);
+        public static bool TestLastTrue(Vector<long> mask, Vector<long> srcMask);
+        public static bool TestLastTrue(Vector<sbyte> mask, Vector<sbyte> srcMask);
+        public static bool TestLastTrue(Vector<ushort> mask, Vector<ushort> srcMask);
+        public static bool TestLastTrue(Vector<uint> mask, Vector<uint> srcMask);
+        public static bool TestLastTrue(Vector<ulong> mask, Vector<ulong> srcMask);
+        public static Vector<double> TrigonometricMultiplyAddCoefficient(Vector<double> left, Vector<double> right, [ConstantExpectedAttribute(Min=0, Max=(byte)7)] byte control);
+        public static Vector<float> TrigonometricMultiplyAddCoefficient(Vector<float> left, Vector<float> right, [ConstantExpectedAttribute(Min=0, Max=(byte)7)] byte control);
+        public static Vector<double> TrigonometricSelectCoefficient(Vector<double> value, Vector<ulong> selector);
+        public static Vector<float> TrigonometricSelectCoefficient(Vector<float> value, Vector<uint> selector);
+        public static Vector<double> TrigonometricStartingValue(Vector<double> value, Vector<ulong> sign);
+        public static Vector<float> TrigonometricStartingValue(Vector<float> value, Vector<uint> sign);
+        public static Vector<byte> VectorTableLookup(Vector<byte> data, Vector<byte> indices);
+        public static Vector<double> VectorTableLookup(Vector<double> data, Vector<ulong> indices);
+        public static Vector<short> VectorTableLookup(Vector<short> data, Vector<ushort> indices);
+        public static Vector<int> VectorTableLookup(Vector<int> data, Vector<uint> indices);
+        public static Vector<long> VectorTableLookup(Vector<long> data, Vector<ulong> indices);
+        public static Vector<sbyte> VectorTableLookup(Vector<sbyte> data, Vector<byte> indices);
+        public static Vector<float> VectorTableLookup(Vector<float> data, Vector<uint> indices);
+        public static Vector<ushort> VectorTableLookup(Vector<ushort> data, Vector<ushort> indices);
+        public static Vector<uint> VectorTableLookup(Vector<uint> data, Vector<uint> indices);
+        public static Vector<ulong> VectorTableLookup(Vector<ulong> data, Vector<ulong> indices);
     }
 }
```

