# System.Runtime.Intrinsics

``` diff
 namespace System.Runtime.Intrinsics {
     public static class Vector128 {
+        public static Vector128<T> Clamp<T>(Vector128<T> value, Vector128<T> min, Vector128<T> max);
+        public static Vector128<T> ClampNative<T>(Vector128<T> value, Vector128<T> min, Vector128<T> max);
+        public static Vector128<T> CopySign<T>(Vector128<T> value, Vector128<T> sign);
+        public static Vector128<double> Cos(Vector128<double> vector);
+        public static Vector128<float> Cos(Vector128<float> vector);
+        public static Vector128<double> DegreesToRadians(Vector128<double> degrees);
+        public static Vector128<float> DegreesToRadians(Vector128<float> degrees);
+        public static Vector128<double> Hypot(Vector128<double> x, Vector128<double> y);
+        public static Vector128<float> Hypot(Vector128<float> x, Vector128<float> y);
+        public static Vector128<T> IsNaN<T>(Vector128<T> vector);
+        public static Vector128<T> IsNegative<T>(Vector128<T> vector);
+        public static Vector128<T> IsPositive<T>(Vector128<T> vector);
+        public static Vector128<T> IsPositiveInfinity<T>(Vector128<T> vector);
+        public static Vector128<T> IsZero<T>(Vector128<T> vector);
+        public static Vector128<double> Lerp(Vector128<double> x, Vector128<double> y, Vector128<double> amount);
+        public static Vector128<float> Lerp(Vector128<float> x, Vector128<float> y, Vector128<float> amount);
+        public static Vector128<T> MaxMagnitude<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> MaxMagnitudeNumber<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> MaxNative<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> MaxNumber<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> MinMagnitude<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> MinMagnitudeNumber<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> MinNative<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> MinNumber<T>(Vector128<T> left, Vector128<T> right);
+        public static Vector128<double> RadiansToDegrees(Vector128<double> radians);
+        public static Vector128<float> RadiansToDegrees(Vector128<float> radians);
+        public static Vector128<double> Round(Vector128<double> vector);
+        public static Vector128<double> Round(Vector128<double> vector, MidpointRounding mode);
+        public static Vector128<float> Round(Vector128<float> vector);
+        public static Vector128<float> Round(Vector128<float> vector, MidpointRounding mode);
+        public static Vector128<double> Sin(Vector128<double> vector);
+        public static Vector128<float> Sin(Vector128<float> vector);
+        public static (Vector128<double> Sin, Vector128<double> Cos) SinCos(Vector128<double> vector);
+        public static (Vector128<float> Sin, Vector128<float> Cos) SinCos(Vector128<float> vector);
+        public static Vector128<double> Truncate(Vector128<double> vector);
+        public static Vector128<float> Truncate(Vector128<float> vector);
     }
     public static class Vector256 {
+        public static Vector256<T> Clamp<T>(Vector256<T> value, Vector256<T> min, Vector256<T> max);
+        public static Vector256<T> ClampNative<T>(Vector256<T> value, Vector256<T> min, Vector256<T> max);
+        public static Vector256<T> CopySign<T>(Vector256<T> value, Vector256<T> sign);
+        public static Vector256<double> Cos(Vector256<double> vector);
+        public static Vector256<float> Cos(Vector256<float> vector);
+        public static Vector256<double> DegreesToRadians(Vector256<double> degrees);
+        public static Vector256<float> DegreesToRadians(Vector256<float> degrees);
+        public static Vector256<double> Hypot(Vector256<double> x, Vector256<double> y);
+        public static Vector256<float> Hypot(Vector256<float> x, Vector256<float> y);
+        public static Vector256<T> IsNaN<T>(Vector256<T> vector);
+        public static Vector256<T> IsNegative<T>(Vector256<T> vector);
+        public static Vector256<T> IsPositive<T>(Vector256<T> vector);
+        public static Vector256<T> IsPositiveInfinity<T>(Vector256<T> vector);
+        public static Vector256<T> IsZero<T>(Vector256<T> vector);
+        public static Vector256<double> Lerp(Vector256<double> x, Vector256<double> y, Vector256<double> amount);
+        public static Vector256<float> Lerp(Vector256<float> x, Vector256<float> y, Vector256<float> amount);
+        public static Vector256<T> MaxMagnitude<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> MaxMagnitudeNumber<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> MaxNative<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> MaxNumber<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> MinMagnitude<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> MinMagnitudeNumber<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> MinNative<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> MinNumber<T>(Vector256<T> left, Vector256<T> right);
+        public static Vector256<double> RadiansToDegrees(Vector256<double> radians);
+        public static Vector256<float> RadiansToDegrees(Vector256<float> radians);
+        public static Vector256<double> Round(Vector256<double> vector);
+        public static Vector256<double> Round(Vector256<double> vector, MidpointRounding mode);
+        public static Vector256<float> Round(Vector256<float> vector);
+        public static Vector256<float> Round(Vector256<float> vector, MidpointRounding mode);
+        public static Vector256<double> Sin(Vector256<double> vector);
+        public static Vector256<float> Sin(Vector256<float> vector);
+        public static (Vector256<double> Sin, Vector256<double> Cos) SinCos(Vector256<double> vector);
+        public static (Vector256<float> Sin, Vector256<float> Cos) SinCos(Vector256<float> vector);
+        public static Vector256<double> Truncate(Vector256<double> vector);
+        public static Vector256<float> Truncate(Vector256<float> vector);
     }
     public static class Vector512 {
+        public static Vector512<T> Clamp<T>(Vector512<T> value, Vector512<T> min, Vector512<T> max);
+        public static Vector512<T> ClampNative<T>(Vector512<T> value, Vector512<T> min, Vector512<T> max);
+        public static Vector512<T> CopySign<T>(Vector512<T> value, Vector512<T> sign);
+        public static Vector512<double> Cos(Vector512<double> vector);
+        public static Vector512<float> Cos(Vector512<float> vector);
+        public static Vector512<double> DegreesToRadians(Vector512<double> degrees);
+        public static Vector512<float> DegreesToRadians(Vector512<float> degrees);
+        public static Vector512<double> Hypot(Vector512<double> x, Vector512<double> y);
+        public static Vector512<float> Hypot(Vector512<float> x, Vector512<float> y);
+        public static Vector512<T> IsNaN<T>(Vector512<T> vector);
+        public static Vector512<T> IsNegative<T>(Vector512<T> vector);
+        public static Vector512<T> IsPositive<T>(Vector512<T> vector);
+        public static Vector512<T> IsPositiveInfinity<T>(Vector512<T> vector);
+        public static Vector512<T> IsZero<T>(Vector512<T> vector);
+        public static Vector512<double> Lerp(Vector512<double> x, Vector512<double> y, Vector512<double> amount);
+        public static Vector512<float> Lerp(Vector512<float> x, Vector512<float> y, Vector512<float> amount);
+        public static Vector512<T> MaxMagnitude<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<T> MaxMagnitudeNumber<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<T> MaxNative<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<T> MaxNumber<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<T> MinMagnitude<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<T> MinMagnitudeNumber<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<T> MinNative<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<T> MinNumber<T>(Vector512<T> left, Vector512<T> right);
+        public static Vector512<double> RadiansToDegrees(Vector512<double> radians);
+        public static Vector512<float> RadiansToDegrees(Vector512<float> radians);
+        public static Vector512<double> Round(Vector512<double> vector);
+        public static Vector512<double> Round(Vector512<double> vector, MidpointRounding mode);
+        public static Vector512<float> Round(Vector512<float> vector);
+        public static Vector512<float> Round(Vector512<float> vector, MidpointRounding mode);
+        public static Vector512<double> Sin(Vector512<double> vector);
+        public static Vector512<float> Sin(Vector512<float> vector);
+        public static (Vector512<double> Sin, Vector512<double> Cos) SinCos(Vector512<double> vector);
+        public static (Vector512<float> Sin, Vector512<float> Cos) SinCos(Vector512<float> vector);
+        public static Vector512<double> Truncate(Vector512<double> vector);
+        public static Vector512<float> Truncate(Vector512<float> vector);
     }
     public static class Vector64 {
+        public static Vector64<T> Clamp<T>(Vector64<T> value, Vector64<T> min, Vector64<T> max);
+        public static Vector64<T> ClampNative<T>(Vector64<T> value, Vector64<T> min, Vector64<T> max);
+        public static Vector64<T> CopySign<T>(Vector64<T> value, Vector64<T> sign);
+        public static Vector64<double> Cos(Vector64<double> vector);
+        public static Vector64<float> Cos(Vector64<float> vector);
+        public static Vector64<double> DegreesToRadians(Vector64<double> degrees);
+        public static Vector64<float> DegreesToRadians(Vector64<float> degrees);
+        public static Vector64<double> Hypot(Vector64<double> x, Vector64<double> y);
+        public static Vector64<float> Hypot(Vector64<float> x, Vector64<float> y);
+        public static Vector64<T> IsNaN<T>(Vector64<T> vector);
+        public static Vector64<T> IsNegative<T>(Vector64<T> vector);
+        public static Vector64<T> IsPositive<T>(Vector64<T> vector);
+        public static Vector64<T> IsPositiveInfinity<T>(Vector64<T> vector);
+        public static Vector64<T> IsZero<T>(Vector64<T> vector);
+        public static Vector64<double> Lerp(Vector64<double> x, Vector64<double> y, Vector64<double> amount);
+        public static Vector64<float> Lerp(Vector64<float> x, Vector64<float> y, Vector64<float> amount);
+        public static Vector64<T> MaxMagnitude<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> MaxMagnitudeNumber<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> MaxNative<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> MaxNumber<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> MinMagnitude<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> MinMagnitudeNumber<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> MinNative<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> MinNumber<T>(Vector64<T> left, Vector64<T> right);
+        public static Vector64<double> RadiansToDegrees(Vector64<double> radians);
+        public static Vector64<float> RadiansToDegrees(Vector64<float> radians);
+        public static Vector64<double> Round(Vector64<double> vector);
+        public static Vector64<double> Round(Vector64<double> vector, MidpointRounding mode);
+        public static Vector64<float> Round(Vector64<float> vector);
+        public static Vector64<float> Round(Vector64<float> vector, MidpointRounding mode);
+        public static Vector64<double> Sin(Vector64<double> vector);
+        public static Vector64<float> Sin(Vector64<float> vector);
+        public static (Vector64<double> Sin, Vector64<double> Cos) SinCos(Vector64<double> vector);
+        public static (Vector64<float> Sin, Vector64<float> Cos) SinCos(Vector64<float> vector);
+        public static Vector64<double> Truncate(Vector64<double> vector);
+        public static Vector64<float> Truncate(Vector64<float> vector);
     }
 }
```

