# System.Security.Cryptography.X509Certificates

``` diff
 namespace System.Security.Cryptography.X509Certificates {
+    public sealed class Pkcs12LoaderLimits {
+        public Pkcs12LoaderLimits();
+        public Pkcs12LoaderLimits(Pkcs12LoaderLimits copyFrom);
+        public static Pkcs12LoaderLimits DangerousNoLimits { get; }
+        public static Pkcs12LoaderLimits Defaults { get; }
+        public bool IgnoreEncryptedAuthSafes { get; set; }
+        public bool IgnorePrivateKeys { get; set; }
+        public int? IndividualKdfIterationLimit { get; set; }
+        public bool IsReadOnly { get; }
+        public int? MacIterationLimit { get; set; }
+        public int? MaxCertificates { get; set; }
+        public int? MaxKeys { get; set; }
+        public bool PreserveCertificateAlias { get; set; }
+        public bool PreserveKeyName { get; set; }
+        public bool PreserveStorageProvider { get; set; }
+        public bool PreserveUnknownAttributes { get; set; }
+        public int? TotalKdfIterationLimit { get; set; }
+        public void MakeReadOnly();
+    }
+    public sealed class Pkcs12LoadLimitExceededException : CryptographicException {
+        public Pkcs12LoadLimitExceededException(string propertyName);
+    }
     public class X509Certificate : IDeserializationCallback, IDisposable, ISerializable {
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate();
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate();
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(byte[] data);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] data);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(byte[] rawData, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(byte[] rawData, string? password);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, string? password);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(string fileName);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(string fileName, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(string fileName, string? password);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, string? password);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public static X509Certificate CreateFromCertFile(string filename);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate CreateFromCertFile(string filename);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public static X509Certificate CreateFromSignedFile(string filename);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static X509Certificate CreateFromSignedFile(string filename);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public virtual void Import(byte[] rawData);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void Import(byte[] rawData);
-        [CLSCompliantAttribute(false)]
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public virtual void Import(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void Import(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public virtual void Import(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void Import(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public virtual void Import(string fileName);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void Import(string fileName);
-        [CLSCompliantAttribute(false)]
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public virtual void Import(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void Import(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public virtual void Import(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void Import(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
     }
     public class X509Certificate2 : X509Certificate {
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2();
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2();
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(byte[] rawData);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(byte[] rawData, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(byte[] rawData, string? password);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, string? password);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(ReadOnlySpan<byte> rawData);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(ReadOnlySpan<byte> rawData);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(string fileName);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(string fileName, SecureString? password);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, SecureString? password);
-        [CLSCompliantAttribute(false)]
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(string fileName, string? password);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, string? password);
-        [UnsupportedOSPlatformAttribute("browser")]
-        public X509Certificate2(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        public X509Certificate2(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public override void Import(byte[] rawData);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void Import(byte[] rawData);
-        [CLSCompliantAttribute(false)]
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public override void Import(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void Import(byte[] rawData, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public override void Import(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void Import(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public override void Import(string fileName);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void Import(string fileName);
-        [CLSCompliantAttribute(false)]
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public override void Import(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void Import(string fileName, SecureString? password, X509KeyStorageFlags keyStorageFlags);
-        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use the appropriate constructor to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        public override void Import(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
+        [ObsoleteAttribute("X509Certificate and X509Certificate2 are immutable. Use X509CertificateLoader to create a new certificate.", DiagnosticId="SYSLIB0026", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void Import(string fileName, string? password, X509KeyStorageFlags keyStorageFlags);
     }
     public class X509Certificate2Collection : X509CertificateCollection, IEnumerable, IEnumerable<X509Certificate2> {
-        public void Import(byte[] rawData);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(byte[] rawData);
-        public void Import(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(byte[] rawData, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        public void Import(ReadOnlySpan<byte> rawData);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(ReadOnlySpan<byte> rawData);
-        public void Import(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(ReadOnlySpan<byte> rawData, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        public void Import(ReadOnlySpan<byte> rawData, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(ReadOnlySpan<byte> rawData, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        public void Import(string fileName);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(string fileName);
-        public void Import(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(string fileName, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
-        public void Import(string fileName, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
+        [ObsoleteAttribute("Loading certificate data through the constructor or Import is obsolete. Use X509CertificateLoader instead to load certificates.", DiagnosticId="SYSLIB0057", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void Import(string fileName, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet);
     }
+    [UnsupportedOSPlatformAttribute("browser")]
+    public static class X509CertificateLoader {
+        public static X509Certificate2 LoadCertificate(byte[] data);
+        public static X509Certificate2 LoadCertificate(ReadOnlySpan<byte> data);
+        public static X509Certificate2 LoadCertificateFromFile(string path);
+        public static X509Certificate2 LoadPkcs12(byte[] data, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+        public static X509Certificate2 LoadPkcs12(ReadOnlySpan<byte> data, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+        public static X509Certificate2Collection LoadPkcs12Collection(byte[] data, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+        public static X509Certificate2Collection LoadPkcs12Collection(ReadOnlySpan<byte> data, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+        public static X509Certificate2Collection LoadPkcs12CollectionFromFile(string path, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+        public static X509Certificate2Collection LoadPkcs12CollectionFromFile(string path, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+        public static X509Certificate2 LoadPkcs12FromFile(string path, ReadOnlySpan<char> password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+        public static X509Certificate2 LoadPkcs12FromFile(string path, string? password, X509KeyStorageFlags keyStorageFlags = X509KeyStorageFlags.DefaultKeySet, Pkcs12LoaderLimits? loaderLimits = null);
+    }
 }
```

