# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
+    [SupportedOSPlatformAttribute("ios13.0")]
+    [SupportedOSPlatformAttribute("maccatalyst")]
+    [SupportedOSPlatformAttribute("tvos13.0")]
     [UnsupportedOSPlatformAttribute("browser")]
     [UnsupportedOSPlatformAttribute("ios")]
     [UnsupportedOSPlatformAttribute("tvos")]
     public sealed class AesGcm : IDisposable
+    [SupportedOSPlatformAttribute("ios13.0")]
+    [SupportedOSPlatformAttribute("maccatalyst")]
+    [SupportedOSPlatformAttribute("tvos13.0")]
     [UnsupportedOSPlatformAttribute("browser")]
     [UnsupportedOSPlatformAttribute("ios")]
     [UnsupportedOSPlatformAttribute("tvos")]
     public sealed class ChaCha20Poly1305 : IDisposable
     [FlagsAttribute]
     public enum CngKeyCreationOptions {
+        PreferVbs = 65536,
+        RequireVbs = 131072,
+        UsePerBootKey = 262144,
     }
     public sealed class SafeEvpPKeyHandle : SafeHandle {
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static SafeEvpPKeyHandle OpenKeyFromProvider(string providerName, string keyUri);
     }
 }
```

