# System.Text.Json

``` diff
 namespace System.Text.Json {
     public readonly struct JsonElement {
+        public static bool DeepEquals(JsonElement element1, JsonElement element2);
     }
     public struct JsonReaderOptions {
+        public bool AllowMultipleValues { get; set; }
     }
     public static class JsonSerializer {
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static IAsyncEnumerable<TValue?> DeserializeAsyncEnumerable<TValue>(Stream utf8Json, bool topLevelValues, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static IAsyncEnumerable<TValue?> DeserializeAsyncEnumerable<TValue>(Stream utf8Json, JsonTypeInfo<TValue> jsonTypeInfo, bool topLevelValues, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

