# System

``` diff
 namespace System {
     public static class Environment {
+        [SupportedOSPlatformAttribute("maccatalyst")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static Environment.ProcessCpuUsage CpuUsage { get; }
+        public readonly struct ProcessCpuUsage {
+            public TimeSpan PrivilegedTime { get; }
+            public TimeSpan TotalTime { get; }
+            public TimeSpan UserTime { get; }
+        }
     }
     public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable, IParsable<Guid>, ISpanFormattable, ISpanParsable<Guid>, IUtf8SpanFormattable {
+        public static Guid AllBitsSet { get; }
+        public int Variant { get; }
+        public int Version { get; }
+        public static Guid CreateVersion7();
+        public static Guid CreateVersion7(DateTimeOffset timestamp);
     }
     public static class MemoryExtensions {
+        public static MemoryExtensions.SpanSplitEnumerator<T> Split<T>(this ReadOnlySpan<T> source, ReadOnlySpan<T> separator) where T : IEquatable<T>;
+        public static MemoryExtensions.SpanSplitEnumerator<T> Split<T>(this ReadOnlySpan<T> source, T separator) where T : IEquatable<T>;
+        public static MemoryExtensions.SpanSplitEnumerator<T> SplitAny<T>(this ReadOnlySpan<T> source, SearchValues<T> separators) where T : IEquatable<T>;
+        public static MemoryExtensions.SpanSplitEnumerator<T> SplitAny<T>(this ReadOnlySpan<T> source, [ParamCollectionAttribute, UnscopedRefAttribute] ReadOnlySpan<T> separators) where T : IEquatable<T>;
+        public ref struct SpanSplitEnumerator<T> where T : IEquatable<T> {
+            public Range Current { get; }
+            public MemoryExtensions.SpanSplitEnumerator<T> GetEnumerator();
+            public bool MoveNext();
+        }
     }
     public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, IParsable<TimeSpan>, ISpanFormattable, ISpanParsable<TimeSpan>, IUtf8SpanFormattable {
+        public const int HoursPerDay = 24;
+        public const long MicrosecondsPerDay = (long)86400000000;
+        public const long MicrosecondsPerHour = (long)3600000000;
+        public const long MicrosecondsPerMillisecond = (long)1000;
+        public const long MicrosecondsPerMinute = (long)60000000;
+        public const long MicrosecondsPerSecond = (long)1000000;
+        public const long MillisecondsPerDay = (long)86400000;
+        public const long MillisecondsPerHour = (long)3600000;
+        public const long MillisecondsPerMinute = (long)60000;
+        public const long MillisecondsPerSecond = (long)1000;
+        public const long MinutesPerDay = (long)1440;
+        public const long MinutesPerHour = (long)60;
+        public const long SecondsPerDay = (long)86400;
+        public const long SecondsPerHour = (long)3600;
+        public const long SecondsPerMinute = (long)60;
     }
 }
```

