# System.Windows

``` diff
 namespace System.Windows {
     public class Application : DispatcherObject, IQueryAmbient {
+        [ExperimentalAttribute("WPF0001")]
+        [TypeConverterAttribute(typeof(ThemeModeConverter))]
+        public ThemeMode ThemeMode { get; set; }
     }
-    [XamlSetMarkupExtensionAttribute("ReceiveMarkupExtension")]
-    [XamlSetTypeConverterAttribute("ReceiveTypeConverter")]
-    public class Setter : SetterBase, ISupportInitialize
+    [ContentPropertyAttribute("Value")]
+    [XamlSetMarkupExtensionAttribute("ReceiveMarkupExtension")]
+    [XamlSetTypeConverterAttribute("ReceiveTypeConverter")]
+    public class Setter : SetterBase, ISupportInitialize
     public static class SystemColors {
+        public static Color AccentColor { get; }
+        public static SolidColorBrush AccentColorBrush { get; }
+        public static ResourceKey AccentColorBrushKey { get; }
+        public static Color AccentColorDark1 { get; }
+        public static SolidColorBrush AccentColorDark1Brush { get; }
+        public static ResourceKey AccentColorDark1BrushKey { get; }
+        public static ResourceKey AccentColorDark1Key { get; }
+        public static Color AccentColorDark2 { get; }
+        public static SolidColorBrush AccentColorDark2Brush { get; }
+        public static ResourceKey AccentColorDark2BrushKey { get; }
+        public static ResourceKey AccentColorDark2Key { get; }
+        public static Color AccentColorDark3 { get; }
+        public static SolidColorBrush AccentColorDark3Brush { get; }
+        public static ResourceKey AccentColorDark3BrushKey { get; }
+        public static ResourceKey AccentColorDark3Key { get; }
+        public static ResourceKey AccentColorKey { get; }
+        public static Color AccentColorLight1 { get; }
+        public static SolidColorBrush AccentColorLight1Brush { get; }
+        public static ResourceKey AccentColorLight1BrushKey { get; }
+        public static ResourceKey AccentColorLight1Key { get; }
+        public static Color AccentColorLight2 { get; }
+        public static SolidColorBrush AccentColorLight2Brush { get; }
+        public static ResourceKey AccentColorLight2BrushKey { get; }
+        public static ResourceKey AccentColorLight2Key { get; }
+        public static Color AccentColorLight3 { get; }
+        public static SolidColorBrush AccentColorLight3Brush { get; }
+        public static ResourceKey AccentColorLight3BrushKey { get; }
+        public static ResourceKey AccentColorLight3Key { get; }
     }
+    [ExperimentalAttribute("WPF0001")]
+    public readonly struct ThemeMode : IEquatable<ThemeMode> {
+        public ThemeMode(string value);
+        public static ThemeMode Dark { get; }
+        public static ThemeMode Light { get; }
+        public static ThemeMode None { get; }
+        public static ThemeMode System { get; }
+        public string Value { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ThemeMode other);
+        public override int GetHashCode();
+        public static bool operator ==(ThemeMode left, ThemeMode right);
+        public static bool operator !=(ThemeMode left, ThemeMode right);
+        public override string ToString();
+    }
+    [ExperimentalAttribute("WPF0001")]
+    public class ThemeModeConverter : TypeConverter {
+        public ThemeModeConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext typeDescriptorContext, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext typeDescriptorContext, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext typeDescriptorContext, CultureInfo cultureInfo, object source);
+        public override object ConvertTo(ITypeDescriptorContext typeDescriptorContext, CultureInfo cultureInfo, object value, Type destinationType);
+    }
     [LocalizabilityAttribute(LocalizationCategory.Ignore)]
     public class Window : ContentControl {
+        [ExperimentalAttribute("WPF0001")]
+        [TypeConverterAttribute(typeof(ThemeModeConverter))]
+        public ThemeMode ThemeMode { get; set; }
     }
 }
```

