# System.IO.Compression

``` diff
 namespace System.IO.Compression {
+    public sealed class BrotliCompressionOptions {
+        public BrotliCompressionOptions();
+        public int Quality { get; set; }
+    }
     public sealed class BrotliStream : Stream {
+        public BrotliStream(Stream stream, BrotliCompressionOptions compressionOptions, bool leaveOpen = false);
     }
     public class DeflateStream : Stream {
+        public DeflateStream(Stream stream, ZLibCompressionOptions compressionOptions, bool leaveOpen = false);
     }
     public class GZipStream : Stream {
+        public GZipStream(Stream stream, ZLibCompressionOptions compressionOptions, bool leaveOpen = false);
     }
+    public sealed class ZLibCompressionOptions {
+        public ZLibCompressionOptions();
+        public int CompressionLevel { get; set; }
+        public ZLibCompressionStrategy CompressionStrategy { get; set; }
+    }
+    public enum ZLibCompressionStrategy {
+        Default = 0,
+        Filtered = 1,
+        Fixed = 4,
+        HuffmanOnly = 2,
+        RunLengthEncoding = 3,
+    }
     public sealed class ZLibStream : Stream {
+        public ZLibStream(Stream stream, ZLibCompressionOptions compressionOptions, bool leaveOpen = false);
     }
 }
```

