# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     public sealed class Application {
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public static SystemColorMode ColorMode { get; }
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public static bool IsDarkModeEnabled { get; }
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public static SystemColorMode SystemColorMode { get; }
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public static void SetColorMode(SystemColorMode systemColorMode);
     }
     [DefaultEventAttribute("Click")]
     [DefaultPropertyAttribute("Text")]
     [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ControlCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle<HWND>, IKeyboardToolTip, IOleControl.Interface, IOleInPlaceActiveObject.Interface, IOleInPlaceObject.Interface, IOleObject.Interface, IOleWindow.Interface, IPersist.Interface, IPersistPropertyBag.Interface, IPersistStorage.Interface, IPersistStreamInit.Interface, IQuickActivate.Interface, ISupportOleDropSource, ISynchronizeInvoke, IViewObject.Interface, IViewObject2.Interface, IWin32Window {
+        public Task InvokeAsync(Action callback, CancellationToken cancellationToken = default(CancellationToken));
+        public Task InvokeAsync(Func<CancellationToken, ValueTask> callback, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<T> InvokeAsync<T>(Func<CancellationToken, ValueTask<T>> callback, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<T> InvokeAsync<T>(Func<T> callback, CancellationToken cancellationToken = default(CancellationToken));
     }
     [FlagsAttribute]
     public enum ControlStyles {
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        ApplyThemingImplicitly = 524288,
     }
     [DefaultEventAttribute("Load")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.FormDocumentDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(IRootDesigner))]
     [DesignerCategoryAttribute("Form")]
     [InitializationEventAttribute("Load")]
     [ToolboxItemAttribute(false)]
     [ToolboxItemFilterAttribute("System.Windows.Forms.Control.TopLevel")]
     public class Form : ContainerControl {
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatWindowStyle")]
+        [SRDescriptionAttribute("FormBorderColorDescr")]
+        public Color FormBorderColor { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatWindowStyle")]
+        [SRDescriptionAttribute("FormCaptionBackColorDescr")]
+        public Color FormCaptionBackColor { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatWindowStyle")]
+        [SRDescriptionAttribute("FormCaptionTextColorDescr")]
+        public Color FormCaptionTextColor { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(FormCornerPreference.Default)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatWindowStyle")]
+        [SRDescriptionAttribute("FormCornerPreferenceDescr")]
+        public FormCornerPreference FormCornerPreference { get; set; }
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("FormBorderColorChangedDescr")]
+        public event EventHandler FormBorderColorChanged;
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("FormCaptionBackColorChangedDescr")]
+        public event EventHandler FormCaptionBackColorChanged;
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("FormCaptionTextColorChangedDescr")]
+        public event EventHandler FormCaptionTextColorChanged;
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("FormCornerPreferenceChangedDescr")]
+        public event EventHandler FormCornerPreferenceChanged;
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        protected virtual void OnFormBorderColorChanged(EventArgs e);
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        protected virtual void OnFormCaptionBackColorChanged(EventArgs e);
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        protected virtual void OnFormCaptionTextColorChanged(EventArgs e);
+        [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        protected virtual void OnFormCornerPreferenceChanged(EventArgs e);
+        [ExperimentalAttribute("WFO5002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public Task ShowAsync(IWin32Window? owner = null);
+        [ExperimentalAttribute("WFO5002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public Task<DialogResult> ShowDialogAsync();
+        [ExperimentalAttribute("WFO5002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public Task<DialogResult> ShowDialogAsync(IWin32Window owner);
     }
+    [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+    public enum FormCornerPreference {
+        Default = 0,
+        DoNotRound = 1,
+        Round = 2,
+        RoundSmall = 3,
+    }
     [DefaultBindingPropertyAttribute("Value")]
     [DefaultPropertyAttribute("Value")]
     [SRDescriptionAttribute("DescriptionProgressBar")]
     public class ProgressBar : Control {
+        protected override void OnCreateControl();
     }
+    [ExperimentalAttribute("WFO5001", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+    public enum SystemColorMode {
+        Classic = 0,
+        Dark = 2,
+        System = 1,
+    }
     public class TaskDialog : IWin32Window {
+        [ExperimentalAttribute("WFO5002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public static Task<TaskDialogButton> ShowDialogAsync(IntPtr hwndOwner, TaskDialogPage page, TaskDialogStartupLocation startupLocation = TaskDialogStartupLocation.CenterOwner);
+        [ExperimentalAttribute("WFO5002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public static Task<TaskDialogButton> ShowDialogAsync(IWin32Window owner, TaskDialogPage page, TaskDialogStartupLocation startupLocation = TaskDialogStartupLocation.CenterOwner);
+        [ExperimentalAttribute("WFO5002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public static Task<TaskDialogButton> ShowDialogAsync(TaskDialogPage page, TaskDialogStartupLocation startupLocation = TaskDialogStartupLocation.CenterScreen);
     }
 }
```

