# .NET 9 RC 2 Binaries

.NET 9 RC 2 installers and binaries can be downloaded for the following product versions:

- `.NET 9.0.0 RC 2`
- `.NET SDK 9.0.100-rc.2.24474.11`

See [README.md](README.md) for .NET 9 release notes and discussions.

The latest .NET releases are always listed at [.NET Releases](../../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
9.0.100-rc.2.24474.11
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 9.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

.NET 9 is compatible with  [Visual Studio 17.12 latest preview](https://visualstudio.microsoft.com). Users will have to [download](https://dotnet.microsoft.com/download/dotnet/9.0) and install the .NET 9 runtime/SDK standalone. Visual Studio for Mac is currently not supported for .NET 9.0 Preview releases.

## Notable changes

### Microsoft Security Advisory CVE-2024-38229 | .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in  .NET 8.0 and .NET 9.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in ASP.NET when closing an HTTP/3 stream while application code is writing to the response body, a race condition may lead to use-after-free.

Note: HTTP/3 is experimental in .NET 6.0. If you are on .NET 6.0 and using HTTP/3, please upgrade to .NET 8.0.10. .NET 6.0 will not receive a security patch for this vulnerability.

### Microsoft Security Advisory CVE-2024-43483 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in  System.Security.Cryptography.Cose, System.IO.Packaging, System.Runtime.Caching. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

System.Security.Cryptography.Cose, System.IO.Packaging, System.Runtime.Caching may be exposed to a hostile input which may lead them to be susceptible to hash flooding attacks resulting in denial of service.

### Microsoft Security Advisory CVE-2024-43484 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in System.IO.Packaging. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

The System.IO.Packaging library may allow untrusted inputs to influence algorithmically complex operations, leading to denial of service.

### Microsoft Security Advisory CVE-2024-43485 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in System.Text.Json 6.0.x and 8.0.x. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

In System.Text.Json 6.0.x and 8.0.x, applications which deserialize input to a model with an `[ExtensionData]` property can be vulnerable to an algorithmic complexity attack resulting in Denial of Service.

## Feedback

Your feedback is important and appreciated. We've created an issue at https://aka.ms/dotnet/9/rc2 for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
FSharp.Compiler.Service.43 | 9.100-preview.24466.6
Microsoft.Net.Sdk.Compilers.Toolset | 9.0.100-rc.2.24474.11
Microsoft.DotNet.Common.ProjectTemplates.9.0 | 9.0.100-rc.2.24474.11
Microsoft.DotNet.ApiCompat.Tool | 9.0.100-rc.2.24474.11
Microsoft.DotNet.ApiCompat.Task | 9.0.100-rc.2.24474.11
Microsoft.NET.Build.Containers | 9.0.100-rc.2.24474.11
Microsoft.DotNet.Common.ItemTemplates | 9.0.100-rc.2.24474.11
FSharp.Core | 9.0.100-beta.24466.6
Microsoft.TemplateEngine.Core | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Authoring.CLI | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Authoring.Tasks | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.TemplateLocalizer.Core | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Utils | 9.0.100-rc.2.24466.6
Microsoft.TemplateSearch.Common | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Edge | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Authoring.Templates | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Abstractions | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Core.Contracts | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.IDE | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 9.0.100-rc.2.24466.6
Microsoft.TemplateEngine.Samples | 9.0.100-rc.2.24466.6
dotnet-ilverify | 9.0.0-rc.2.24473.5
Microsoft.Bcl.AsyncInterfaces | 9.0.0-rc.2.24473.5
Microsoft.Bcl.Numerics | 9.0.0-rc.2.24473.5
Microsoft.Bcl.Memory | 9.0.0-rc.2.24473.5
Microsoft.Bcl.Cryptography | 9.0.0-rc.2.24473.5
Microsoft.Bcl.TimeProvider | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Caching.Memory | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.Json | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.UserSecrets | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.Xml | 9.0.0-rc.2.24473.5
Microsoft.Extensions.DependencyInjection | 9.0.0-rc.2.24473.5
Microsoft.Extensions.DependencyInjection.Abstractions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Http | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging.Console | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.iOS.Sample.Mono | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.osx-x64 | 9.0.0-rc.2.24473.5
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.linux-musl-x64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-x64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.osx-x64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
System.DirectoryServices | 9.0.0-rc.2.24473.5
System.DirectoryServices.Protocols | 9.0.0-rc.2.24473.5
System.Formats.Cbor | 9.0.0-rc.2.24473.5
System.Formats.Asn1 | 9.0.0-rc.2.24473.5
System.Formats.Nrbf | 9.0.0-rc.2.24473.5
System.Reflection.Context | 9.0.0-rc.2.24473.5
System.Runtime.Serialization.Schema | 9.0.0-rc.2.24473.5
System.Reflection.MetadataLoadContext | 9.0.0-rc.2.24473.5
System.Text.Encodings.Web | 9.0.0-rc.2.24473.5
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.maccatalyst-arm64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.osx-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.win-x64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
System.ComponentModel.Composition | 9.0.0-rc.2.24473.5
System.Composition.AttributedModel | 9.0.0-rc.2.24473.5
System.ComponentModel.Composition.Registration | 9.0.0-rc.2.24473.5
System.Composition | 9.0.0-rc.2.24473.5
System.IO.Packaging | 9.0.0-rc.2.24473.5
System.IO.Ports | 9.0.0-rc.2.24473.5
System.Management | 9.0.0-rc.2.24473.5
System.Net.Http.WinHttpHandler | 9.0.0-rc.2.24473.5
System.Numerics.Tensors | 9.0.0-rc.2.24473.5
System.Reflection.Metadata | 9.0.0-rc.2.24473.5
System.Security.Cryptography.Xml | 9.0.0-rc.2.24473.5
System.Security.Permissions | 9.0.0-rc.2.24473.5
System.ServiceModel.Syndication | 9.0.0-rc.2.24473.5
System.Text.Encoding.CodePages | 9.0.0-rc.2.24473.5
System.Speech | 9.0.0-rc.2.24473.5
System.Threading.Channels | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Templates.net9.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Templates.net9.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Sdk.WebAssembly.Pack | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.win-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.osx-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.osx-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.win-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-x64 | 9.0.0-rc.2.24473.5
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.linux-bionic-x64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
System.Composition.Convention | 9.0.0-rc.2.24473.5
System.Composition.Hosting | 9.0.0-rc.2.24473.5
System.Composition.Runtime | 9.0.0-rc.2.24473.5
System.Configuration.ConfigurationManager | 9.0.0-rc.2.24473.5
System.Diagnostics.PerformanceCounter | 9.0.0-rc.2.24473.5
System.DirectoryServices.AccountManagement | 9.0.0-rc.2.24473.5
System.Net.Http.Json | 9.0.0-rc.2.24473.5
System.Threading.Tasks.Dataflow | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.win-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.osx-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.XmlSerializer.Generator | 9.0.0-rc.2.24473.5
runtime.android-arm64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.android-x64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-x64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
System.Diagnostics.DiagnosticSource | 9.0.0-rc.2.24473.5
System.IO.Pipelines | 9.0.0-rc.2.24473.5
System.Net.ServerSentEvents | 9.0.0-rc.2.24473.5
System.Security.Cryptography.Cose | 9.0.0-rc.2.24473.5
System.Security.Cryptography.Pkcs | 9.0.0-rc.2.24473.5
System.ServiceProcess.ServiceController | 9.0.0-rc.2.24473.5
System.Text.Json | 9.0.0-rc.2.24473.5
System.Threading.AccessControl | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.Binder | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.CommandLine | 9.0.0-rc.2.24473.5
Microsoft.Extensions.DependencyInjection.Specification.Tests | 9.0.0-rc.2.24473.5
Microsoft.Extensions.DependencyModel | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Diagnostics | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Diagnostics.Abstractions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.FileProviders.Abstractions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.FileProviders.Physical | 9.0.0-rc.2.24473.5
Microsoft.Extensions.FileProviders.Composite | 9.0.0-rc.2.24473.5
Microsoft.Extensions.FileSystemGlobbing | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Hosting.Systemd | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Hosting | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging.EventLog | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging.EventSource | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging.TraceSource | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Options.DataAnnotations | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.win-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.win-x64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.win-x86.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.win-x86.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
System.Collections.Immutable | 9.0.0-rc.2.24473.5
System.Composition.TypedParts | 9.0.0-rc.2.24473.5
System.Data.Odbc | 9.0.0-rc.2.24473.5
System.Data.OleDb | 9.0.0-rc.2.24473.5
System.IO.Hashing | 9.0.0-rc.2.24473.5
System.Runtime.Caching | 9.0.0-rc.2.24473.5
System.Security.Cryptography.ProtectedData | 9.0.0-rc.2.24473.5
System.Windows.Extensions | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-musl-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 9.0.0-rc.2.24473.5
System.CodeDom | 9.0.0-rc.2.24473.5
Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
Microsoft.ILVerification | 9.0.0-rc.2.24473.5
Microsoft.NET.ILLink.Tasks | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoTargets.Sdk | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Sdk | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Templates.net9 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Templates.net9.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.win-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.win-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-musl-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 9.0.0-rc.2.24473.5
runtime.linux-arm.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.linux-arm.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
Microsoft.Win32.Registry.AccessControl | 9.0.0-rc.2.24473.5
runtime.android-x86.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-arm64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-bionic-arm64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.osx-arm64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.win-x64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.win-x86.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.win-arm64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
System.Threading.RateLimiting | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.Win32.SystemEvents | 9.0.0-rc.2.24473.5
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.linux-arm.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
runtime.osx-arm64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.osx-x64.Microsoft.NETCore.ILAsm | 9.0.0-rc.2.24473.5
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
System.Diagnostics.EventLog | 9.0.0-rc.2.24473.5
System.Memory.Data | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.EnvironmentVariables | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.FileExtensions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.Ini | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Hosting.Abstractions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Hosting.WindowsServices | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging.Abstractions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging.Configuration | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.Android.Sample.Mono | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.wasm.Sample.Mono | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NET.Sdk.IL | 9.0.0-rc.2.24473.5
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.linux-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.win-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-musl-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-musl-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.win-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Ref | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
Microsoft.NETCore.ILDAsm | 9.0.0-rc.2.24473.5
runtime.android-arm.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
runtime.maccatalyst-x64.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
System.Resources.Extensions | 9.0.0-rc.2.24473.5
System.Runtime.Serialization.Formatters | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Caching.Abstractions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Configuration.Abstractions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Logging.Debug | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Options | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Options.ConfigurationExtensions | 9.0.0-rc.2.24473.5
Microsoft.Extensions.Primitives | 9.0.0-rc.2.24473.5
Microsoft.NET.WebAssembly.Threading | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.osx-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Crossgen2.linux-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-bionic-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Host.linux-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.linux-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.NativeAOT.win-x86 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x64 | 9.0.0-rc.2.24473.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-rc.2.24473.5
runtime.linux-musl-arm.runtime.native.System.IO.Ports | 9.0.0-rc.2.24473.5
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.linux-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.linux-musl-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.win-arm64.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Python.win-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.win-x64.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.linux-musl-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.linux-musl-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.linux-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.osx-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.win-x64.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Python.win-arm64.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.win-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.linux-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.linux-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.osx-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.osx-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.linux-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.linux-musl-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.linux-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Python.osx-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Python.win-x64.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-rc.2.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-rc.2 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.win-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.win-arm64.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Python.win-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.linux-musl-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.linux-musl-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.win-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.osx-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.win-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Sdk.win-x64.Msi.x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.win-arm64.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-rc.2.Msi.arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-rc.2.Msi.x86 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.win-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.osx-x64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Node.osx-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Python.osx-arm64 | 9.0.0-rc.2.24468.8
Microsoft.NET.Runtime.Emscripten.3.1.56.Cache.win-arm64 | 9.0.0-rc.2.24468.8
Microsoft.Extensions.Features | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Http.Polly | 9.0.0-rc.2.24474.3
Microsoft.Extensions.FileProviders.Embedded | 9.0.0-rc.2.24474.3
Microsoft.Extensions.WebEncoders | 9.0.0-rc.2.24474.3
Microsoft.JSInterop | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.linux-arm | 9.0.0-rc.2.24474.3
AspNetCoreRuntime.9.0.x64 | 9.0.0-rc-2-24474-3
Microsoft.AspNetCore.App.Runtime.linux-x64 | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.win-arm64 | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.ConcurrencyLimiter | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Cryptography.Internal | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Connections.Abstractions | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.DataProtection | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.DataProtection.Abstractions | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.DataProtection.Extensions | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Grpc.JsonTranscoding | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Grpc.Swagger | 0.9.0-rc.2.24474.3
Microsoft.AspNetCore.Http.Connections.Client | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Hosting.WindowsServices | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.HeaderPropagation | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Http.Connections.Common | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Metadata | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.OpenApi | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.WebUtilities | 9.0.0-rc.2.24474.3
Microsoft.Extensions.ApiDescription.Server | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 9.0.0-rc.2.24474.3
Microsoft.Extensions.ObjectPool | 9.0.0-rc.2.24474.3
Microsoft.JSInterop.WebAssembly | 9.0.0-rc.2.24474.3
Microsoft.Net.Http.Headers | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.osx-x64 | 9.0.0-rc.2.24474.3
dotnet-sql-cache | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Ref | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.WebAssembly.Server | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Identity.UI | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.Common | 9.0.0-rc.2.24474.3
Microsoft.dotnet-openapi | 9.0.0-rc.2.24474.3
Microsoft.DotNet.Web.Client.ItemTemplates | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.AzureAppServicesIntegration | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.Analyzers | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.Authorization | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.Web | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.WebView | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.JsonPatch | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.MiddlewareAnalysis | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Mvc.Testing | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Owin | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.Client | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.Client.Core | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.Protocols.Json | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.Specification.Tests | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SpaServices.Extensions | 9.0.0-rc.2.24474.3
Microsoft.Authentication.WebAssembly.Msal | 9.0.0-rc.2.24474.3
Microsoft.Extensions.ApiDescription.Client | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Configuration.KeyPerFile | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Identity.Core | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Logging.AzureAppServices | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Localization | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Localization.Abstractions | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 9.0.0-rc.2.24474.3
AspNetCoreRuntime.9.0.x86 | 9.0.0-rc-2-24474-3
Microsoft.AspNetCore.App.Runtime.win-x86 | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Cryptography.KeyDerivation | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.App.Runtime.win-x64 | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.Facebook | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.Certificate | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.JwtBearer | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.Google | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authorization | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.Negotiate | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.OpenIdConnect | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.Twitter | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Authentication.WsFederation | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 9.0.0-rc-2-24474-3
Microsoft.AspNetCore.Components.Forms | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.CustomElements | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.QuickGrid | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.Components.WebAssembly | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.SpaProxy | 9.0.0-rc.2.24474.3
Microsoft.AspNetCore.TestHost | 9.0.0-rc.2.24474.3
Microsoft.DotNet.Web.ProjectTemplates.9.0 | 9.0.0-rc.2.24474.3
Microsoft.DotNet.Web.ItemTemplates.9.0 | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Identity.Stores | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Caching.StackExchangeRedis | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Caching.SqlServer | 9.0.0-rc.2.24474.3
Microsoft.Extensions.Diagnostics.HealthChecks | 9.0.0-rc.2.24474.3
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 9.0.0-rc.2.24474.4
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 9.0.0-rc.2.24474.4
Microsoft.WindowsDesktop.App.Ref | 9.0.0-rc.2.24474.4
Microsoft.Windows.Compatibility | 9.0.0-rc.2.24474.4
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 9.0.0-rc.2.24474.4
System.Drawing.Common | 9.0.0-rc.2.24474.1
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.24454.1
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.24454.1
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.24454.1
Microsoft.CodeAnalysis.NetAnalyzers | 9.0.0-preview.24454.1
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.24454.1
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.24454.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.24454.1
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.24454.1
Text.Analyzers | 3.11.0-beta1.24454.1
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.24454.1
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.24454.1
dotnet-ef | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Relational | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Sqlite | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Tools | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Sqlite.Core | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Templates | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Tasks | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.InMemory | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Proxies | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Specification.Tests | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 9.0.0-rc.2.24474.1
Microsoft.Data.Sqlite.Core | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Design | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Cosmos | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 9.0.0-rc.2.24474.1
Microsoft.Data.Sqlite | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Abstractions | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Analyzers | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.SqlServer | 9.0.0-rc.2.24474.1
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 9.0.0-rc.2.24474.1

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 9.0.0-rc.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-rc.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-rc.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: ../../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-9-rc-2
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-9-rc-2/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef9-rc-2/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-rc2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-rc2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-rc2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-rc2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A9.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A9.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A9.0.1xx
[linux-packages]: ../../install-linux.md

[//]: # ( Runtime 9.0.0-rc.2.24473.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a0fea09f-b78f-4381-be80-3bb7c363f010/7dbd31bdfde0fd28038f9feb5c24de4e/dotnet-runtime-9.0.0-rc.2.24473.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59fcedfa-70be-4166-ad7a-aa724c8d0754/56ab42fd18b3ec36eca8e9a52398032a/dotnet-runtime-9.0.0-rc.2.24473.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ae9bcc8-f0c6-4e58-ae9e-1a97ad4176e7/97a25ba8dd8535ed125d0c3773a8f64b/dotnet-runtime-9.0.0-rc.2.24473.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5868a65-9c13-4020-8f22-afbd6ce09d13/7a342e4798cebc6cba90a6569e9dbec0/dotnet-runtime-9.0.0-rc.2.24473.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9e2009e-5bab-4a62-88e1-ae5e3ed4e0a0/617b2bf0e8292164424e71c342ed8d13/dotnet-runtime-9.0.0-rc.2.24473.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69beb740-ba0e-4a0b-a82a-737c61cb75cb/eff5e94b382efcdcd2a80278e04edb92/dotnet-runtime-9.0.0-rc.2.24473.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/999d2168-46c6-466d-a305-f968e8026616/582cebc362a0ec4c8afcb22bd35c573b/dotnet-runtime-9.0.0-rc.2.24473.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb30091f-cc2e-489f-a8ae-87a08a9d220d/7ce11a740f6d5641c514fe68b2cb2dd2/dotnet-runtime-9.0.0-rc.2.24473.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5ff31639-be1e-437b-b448-dfa11291ccdf/6e271fd741ac91c7beffd6cbcae285e5/dotnet-runtime-9.0.0-rc.2.24473.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b9385375-2ccd-4e9f-9e4a-8d7f6d58c3d3/00e123163e6bfaae9119c5fb355f0d53/dotnet-runtime-9.0.0-rc.2.24473.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/27640c4b-41d3-4cd4-a11e-70e0feb29504/3bfc756fac4edf66f058126f3a6cf49d/dotnet-runtime-9.0.0-rc.2.24473.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bb286ecd-ae9e-4938-ab23-fcda7a10c89d/14770e7df2cca094cba4c55a8f49f499/dotnet-runtime-9.0.0-rc.2.24473.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/19f3f64f-4734-44d8-aa2b-aba6f2940bfe/405c15d5bd31713faaddf9cd9e8d4fc0/dotnet-runtime-9.0.0-rc.2.24473.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/433ad885-2fc1-4387-9413-d017eb9fb11c/db7a7e5df34d1bea2d25a0a34a6c12c4/dotnet-runtime-9.0.0-rc.2.24473.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/508704e7-25d0-4df6-864a-f070091a7a6b/45ec71800b5b829815ba861e1f510e2c/dotnet-runtime-9.0.0-rc.2.24473.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d192fd75-02a6-47cb-a734-295d2f70624a/26500396a3603ae5e159855e13f9582b/dotnet-runtime-9.0.0-rc.2.24473.5-win-x86.zip

[//]: # ( WindowsDesktop 9.0.0-rc.2.24474.4)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/6da33b87-daa8-4855-a348-fea6f05e38e0/31bc1017385dbc17b53f0a5d9c07a38e/windowsdesktop-runtime-9.0.0-rc.2.24474.4-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/06e5689c-c4ba-41c8-9595-c5ff65d176a0/ae5e7d82fbcb1787c32e280d52f8dc2e/windowsdesktop-runtime-9.0.0-rc.2.24474.4-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/30d1fcdb-8bf1-4b6e-ad06-f66ed68017bf/20abf38df849587b0a2de99a31f5c1c8/windowsdesktop-runtime-9.0.0-rc.2.24474.4-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e0bd3746-e35e-47f3-9304-e34b645539f6/512af162a45ed217f2967f7dd696b1a3/windowsdesktop-runtime-9.0.0-rc.2.24474.4-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f6a4c462-a2a6-4488-9448-574b659c31e5/7eb8840cb5e42e0fd41a57964fe3472c/windowsdesktop-runtime-9.0.0-rc.2.24474.4-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a1d7354f-de3c-4e29-9861-9caa37d72fec/41af54ea14130ce6025bd647ef0eb74f/windowsdesktop-runtime-9.0.0-rc.2.24474.4-win-x86.zip

[//]: # ( ASP 9.0.0-rc.2.24474.3)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb68e2f8-fc3e-42ae-85f6-ba2bf4bc8ecb/524d5256a3798a7795837d7b104fb927/aspnetcore-runtime-9.0.0-rc.2.24474.3-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/687495c2-a3a5-4cf5-98e3-2adfef55a1e4/ef59f43e13c7107ab17e59c276da2485/aspnetcore-runtime-9.0.0-rc.2.24474.3-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc4a32ff-51a4-44af-9f7e-fec219ed91b6/4ef16e8019a45a760fc00569cb979ccd/aspnetcore-runtime-9.0.0-rc.2.24474.3-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8548303d-93c5-4846-87ad-af4c79877a26/6e3dc8573f2cd923959bdc39c8d37eb4/aspnetcore-runtime-9.0.0-rc.2.24474.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee8ef896-6330-4f7f-86ad-172d67793e08/fdbe8aa1eb6fe38e8ad3fe471495d388/aspnetcore-runtime-9.0.0-rc.2.24474.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f75b68ca-9e93-468c-925d-3ce85f8a4d0f/3a31e60149a0ca0f9e8d7c05666cfcba/aspnetcore-runtime-9.0.0-rc.2.24474.3-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ffcfb0e-3d17-4b00-8bf2-db75b095252c/5bd0a672caf63b32b39b92c0677a2a4f/aspnetcore-runtime-9.0.0-rc.2.24474.3-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7a757e46-1c68-449e-8b1c-64293c30242d/aa10955edc95ab4419bbad34f8e4899a/aspnetcore-runtime-9.0.0-rc.2.24474.3-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/88a1c08b-ac1a-48d7-b0b6-29717a38d482/a0e70586c7e36ca115d5c1f00d6b68a4/aspnetcore-runtime-9.0.0-rc.2.24474.3-win-arm64.exe
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bd6d5b35-e94d-4291-9b9f-8a9970e08346/1269b69928f4fa1158c3570a8c5d957d/aspnetcore-runtime-9.0.0-rc.2.24474.3-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a6506b9a-1839-476a-91c1-61ea79144b45/4158c6a3ba3eeccbaed806abcfad7d07/aspnetcore-runtime-9.0.0-rc.2.24474.3-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a8cc652d-ed75-4cd6-9962-979857b90ec0/f966c69fbdb3ac127baa94e2a7141d2b/aspnetcore-runtime-9.0.0-rc.2.24474.3-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a5f93dba-813b-45e5-8c8b-62ed494214b7/a28cec13a364ca326827bcb97211bd66/aspnetcore-runtime-9.0.0-rc.2.24474.3-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/71f3df11-d883-4c21-9e41-62539b970583/4b07e65f1f12d51bbb18569897f78d5a/aspnetcore-runtime-9.0.0-rc.2.24474.3-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61fcb638-a068-4ff9-8efb-72defbee4739/b4f0aba681a2d3b47efcb35ebf42e57f/aspnetcore-runtime-composite-9.0.0-rc.2.24474.3-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48b30377-ff5e-47b3-b4cf-e42c5122324f/26c15647c2ccf058230b8341feac53ab/aspnetcore-runtime-composite-9.0.0-rc.2.24474.3-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e2f40fc-1392-4636-98eb-3c75ec8e60cd/06b885eda138d35175511fa51ce387fe/aspnetcore-runtime-composite-9.0.0-rc.2.24474.3-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61185e82-3ed1-4f3d-9a2e-8653249f090c/8db3913d8bf7c4244f894de244bf8bbc/aspnetcore-runtime-composite-9.0.0-rc.2.24474.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38974c30-d6ea-4dfb-a619-e29b18cc8910/b6404f477a049504207570cd2230ecf5/aspnetcore-runtime-composite-9.0.0-rc.2.24474.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ee59ccc-f3ba-453d-9186-60714c2b199c/b9cd51934396f1cdb0106365381b9d88/aspnetcore-runtime-composite-9.0.0-rc.2.24474.3-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/680964e9-9a8f-48b8-a1d4-c67ee809e5ba/7eec74d77d93ffa51eee2117aea60876/dotnet-hosting-9.0.0-rc.2.24474.3-win.exe

[//]: # ( SDK 9.0.100-rc.2.24474.11)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ba992713-4a38-4b45-9c24-8222f2ba01d7/e8746f2e70e0f06e3d9282c6d43bce65/dotnet-sdk-9.0.100-rc.2.24474.11-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/817f5589-0347-4254-b19a-67c30d9ce4f8/3dfe6b98927c4003fc004a1a32132a76/dotnet-sdk-9.0.100-rc.2.24474.11-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce9a6b41-d58d-4def-bf4d-2ff6a022c846/321706c736aaf0391a642d5d1e4d3e1b/dotnet-sdk-9.0.100-rc.2.24474.11-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/add40efa-8de0-4fb8-9ac1-bed94c85caae/30527cbdf0f429eb778ab03f2fadf896/dotnet-sdk-9.0.100-rc.2.24474.11-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e1ed970-6da9-42aa-840c-784c63c3a1af/4bb5d67f6983d22667d4d198d6e72ffd/dotnet-sdk-9.0.100-rc.2.24474.11-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/202e929a-e985-4eab-a78a-d7159fc204e4/0c85219d441cd3bbffd4fb65b7e36fe5/dotnet-sdk-9.0.100-rc.2.24474.11-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2d099a55-d6f5-43f8-bf05-fe90f023554d/03b79d057c06c1ae0855c8e8c5696680/dotnet-sdk-9.0.100-rc.2.24474.11-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90c92374-0f9d-457b-a612-13cef4db7507/fc5ff8876123abfcde954906215ed1d0/dotnet-sdk-9.0.100-rc.2.24474.11-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/71285611-e6d6-4758-8a5b-fec2b48fa25b/4aaf5fe8828150531679788c418a5920/dotnet-sdk-9.0.100-rc.2.24474.11-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33f4f5cb-7423-4930-8e4b-d96f1fd088a9/87d414df2c160713cdaeec06c62cf6a9/dotnet-sdk-9.0.100-rc.2.24474.11-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e282a46b-bc82-4385-85a1-5960b2640f70/a40e95d4db7b72a3d5940569a8bb2d59/dotnet-sdk-9.0.100-rc.2.24474.11-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f8db4312-d81d-4b4f-bcd7-5d8bea4b8d4b/1fbd8938f5e322bb64b88d17802a9023/dotnet-sdk-9.0.100-rc.2.24474.11-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/084bfbb9-6197-49d9-ae9c-ad3825534f37/e1a071d344c9b24849f8034f7ce72aa6/dotnet-sdk-9.0.100-rc.2.24474.11-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/af6bbccc-1d18-4bcb-aa3a-ce76f864f977/8ecffe6494804fb6c6be93488c58eef6/dotnet-sdk-9.0.100-rc.2.24474.11-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d052307a-2d94-4192-935c-b6586e7077d2/3e3dfc72d4bf97bf2d6281ef250114d2/dotnet-sdk-9.0.100-rc.2.24474.11-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f34a8c71-c150-41d7-a233-e5d35338970f/a58a721a06c0f167a4d81efe0d270b92/dotnet-sdk-9.0.100-rc.2.24474.11-win-x86.zip
