# .NET Core 1.1.10

.NET Core 1.1.10 comprises:

* .NET Core Runtime 1.1.10
* .NET Core SDK 1.1.11

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/1.1/1.1.10.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>1</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| Debian 8  | - | [x64][dotnet-dev-debian-x64.tar.gz] | - | [x64][dotnet-debian-x64.tar.gz]  | - |
| Debian 9  | - | [x64][dotnet-dev-debian.9-x64.tar.gz] | - | [x64][dotnet-debian.9-x64.tar.gz]  | - |
| Fedora 27   | -                                                | [x64][dotnet-dev-fedora.27-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.27-x64.tar.gz] | - |
| Fedora 28   | -                                                | [x64][dotnet-dev-fedora.28-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.28-x64.tar.gz] | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz]       | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz] | - |
| Ubuntu 18.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.18.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.18.04-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.11
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.1.10
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## Windows Server Hosting

If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the Windows (Server Hosting) installer and run the following command from an Administrator command prompt:

[DotNetCore.1.0.13_1.1.10-WindowsHosting.exe][DotNetCore-WindowsHosting.exe]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/1.1/1.1.10.md

[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/373f14c7-c48f-4812-aacd-36d0a264679c/44e2497391796c22f2123e763e288c0b/coreclr-1.1.10-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/aaddf89a-b6b9-425b-85f0-ca6777d82960/e8f560ab2700dc7a36e8ceaff71f0f1b/corefx-1.1.10-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/f02b2b5c-35f9-4c7f-b1af-d701bceeb18a/adcd583ab241afac1aef59bf13a4a683/core-setup-1.1.10-symbols.zip
[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcd0be0c-bcd7-44ba-a2b9-81a311a3cdb3/b0ca72ea9b995994d6e54ac242928ede/dotnet-centos-x64.1.1.10.tar.gz
[dotnet-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1fe343e6-f55f-4b70-a3c8-1c9439a7c905/07dcc830b9ed0a2c2feead85a5209b92/dotnet-debian.9-x64.1.1.10.tar.gz
[dotnet-debian-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8543193c-3c50-4709-90d6-632e3c37ae2b/c8919995f8eda0b236d91459b3ab4f4b/dotnet-debian-x64.1.1.10.tar.gz
[dotnet-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24786c9f-d752-4d7d-9891-b4500507281f/147128999e7bb01117796de87c542516/dotnet-fedora.27-x64.1.1.10.tar.gz
[dotnet-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a5c06c72-a6c1-4624-8ab6-ce2d5ec78e6a/6afd58fbd5aee8d97f3340f94eeecad0/dotnet-fedora.28-x64.1.1.10.tar.gz
[dotnet-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c36cfeaa-2310-4b15-84eb-634e39cc67c4/f409e955512078bfd4424b44dbc6c05b/dotnet-opensuse.42.3-x64.1.1.10.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/196e2703-a697-4eef-b647-36430cd66b47/6d490df0fe97b97a118302b8ea7a29db/dotnet-osx-x64.1.1.10.pkg
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6e2e0f4-36e4-4f02-bc9a-18554377cb1a/6024c1292306c11fbf879293329dec42/dotnet-osx-x64.1.1.10.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/950bcacb-cd3b-40bd-8a21-e22fc25f850c/935f5844d8af2132e71c4a1a88dee0d0/dotnet-rhel-x64.1.1.10.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d8ce8f5-173b-471f-bf83-6d21b6f7924c/7e7b983ed52f1f0eb937bffb8d3ab1e2/dotnet-ubuntu.16.04-x64.1.1.10.tar.gz
[dotnet-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b25b5650-0cb8-4699-a347-48d73650da0b/920966211e9bb1907232bbda1faa895a/dotnet-ubuntu.18.04-x64.1.1.10.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e436ca0b-f286-4d5a-b07d-41855d4c1e83/f169eac4a2b1449055cc804a345f1413/dotnet-ubuntu-x64.1.1.10.tar.gz
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f2c70fc3-d08f-41d0-80cd-851530acb391/6f5c6c2715f92c4aa3c45616c0419125/dotnet-win-x64.1.1.10.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b67f7b6-3178-4405-98fa-529a0ee63ec7/e422f43e67412f1b2619dc297cd4da6a/dotnet-win-x64.1.1.10.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/69d04e62-57d7-481e-9441-3b45ac73cf3b/040505f07aba828c022ed9cf43488dd5/dotnet-win-x86.1.1.10.exe
[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2424cd3a-e84d-4e0b-bebf-57e0e52185ce/52b1b575a2dfb1731ede85fd4d3b7fcf/dotnet-win-x86.1.1.10.zip

[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/15a05546-15df-488f-adcf-0e77e86dbefb/1f902e78cfea6209c387adce764a88bc/dotnet-dev-osx-x64.1.1.11.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3c23a7aa-eecd-461b-ad45-979c4c684917/1b464bd34c763e664f7eed6006889d87/dotnet-dev-osx-x64.1.1.11.pkg
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/db408c7b-ef37-4374-b33b-a5b286adaa53/be0f0df977501c4df71ac3f04b9ce35e/dotnet-dev-win-x86.1.1.11.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9386d3bc-6799-4cc5-8288-c807674c72ed/b585db316f0d1c4cad749c247ef21b59/dotnet-dev-win-x86.1.1.11.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a298f85a-bc4c-4019-842e-021e397e3437/5c95727dfe79b600834291a8983b9507/dotnet-dev-win-x64.1.1.11.zip
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/baf5a5a7-68d6-4cf1-afdf-47968b5f91e7/05e6dfe191607ef6135a34215464f600/dotnet-dev-win-x64.1.1.11.exe
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/116bc57f-a6d6-474f-aca7-58c18fe0fac4/aa324344fc9c36623fb4a7c7e5bece0c/dotnet-dev-centos-x64.1.1.11.tar.gz
[dotnet-dev-debian-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ef84426-c1d0-4e3b-86a4-7fce48baecb8/a47dbe0cd3bc1eefdabbf9354f60004b/dotnet-dev-debian-x64.1.1.11.tar.gz
[dotnet-dev-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5c87053-99b4-4c91-af5b-69a1c0e2c91e/ab8882f283fb7206d0f1ee965faa4288/dotnet-dev-debian.9-x64.1.1.11.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98eb7365-0ca8-4e29-b455-b165e583d0de/3a1da729266cb9b885f6747b376a0f7c/dotnet-dev-fedora.27-x64.1.1.11.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3e55604-5a36-412d-ada3-9a46bba55fd0/473cb6db3926c04b7598d750f1d30731/dotnet-dev-fedora.28-x64.1.1.11.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b5e416e-1359-4638-b1f3-e0ac378d3550/13ee9ae8dd5bdd11a11abe1934542920/dotnet-dev-opensuse.42.3-x64.1.1.11.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0957a2b-cac6-44d8-b1cc-0dad4420c825/8dc69e33f8cf44152fdf173d3bf0b746/dotnet-dev-ubuntu-x64.1.1.11.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9f432a7-11fd-48a8-adef-fa95bc24a9ad/85a7293b69d07d5ed678ea21f6082539/dotnet-dev-ubuntu.16.04-x64.1.1.11.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aeac042a-cfef-4064-b914-7419f13c20ae/be14353986c2fbb2259064bcd2cc522a/dotnet-dev-ubuntu.18.04-x64.1.1.11.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e461be2e-e14f-4a78-b987-351da98fb9ab/dc2c11f04a967d3d5c15a9a47b2d9fcc/dotnet-dev-rhel-x64.1.1.11.tar.gz

[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/b84d0334-d56b-47b3-9da4-c48a553ce286/5079d35485214be3fbd72a4fdf21a655/dotnetcore.1.0.13_1.1.10-windowshosting.exe

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.10-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.11-sdk-sha.txt

[linux-install]: https://dotnet.microsoft.com/download/dotnet/1.1
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md
