# .NET Core 1.1.8

.NET Core 1.1.8 is comprised of:

* .NET Core Runtime 1.1.8
* .NET Core SDK 1.1.9

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: |
| Windows                 | [32-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-win-x86.1.1.9.exe) / [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-win-x64.1.1.9.exe)  | [32-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-win-x86.1.1.9.zip) / [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-win-x64.1.1.9.zip) | [32-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-win-x86.1.1.8.exe) / [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-win-x64.1.1.8.exe) | [32-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-win-x86.1.1.8.zip) / [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-win-x64.1.1.8.zip) |
| macOS                   | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-osx-x64.1.1.9.pkg)  | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-osx-x64.1.1.9.tar.gz)                          | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-osx-x64.1.1.8.pkg) | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-osx-x64.1.1.8.tar.gz) |
| CentOS 7.1              | -                                                         | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-centos-x64.1.1.9.tar.gz)                          | - | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-centos-x64.1.1.8.tar.gz) |
| Debian 8                | -                                                         | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-debian-x64.1.1.9.tar.gz)                          | - | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-debian-x64.1.1.8.tar.gz) |
| Ubuntu 14.04            |[64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-sdk-ubuntu-x64.1.1.9.deb)   | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-ubuntu-x64.1.1.9.tar.gz)                          |[64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-sharedframework-ubuntu-x64.1.1.8.deb) | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-ubuntu-x64.1.1.8.tar.gz) |
| Ubuntu 16.04            |[64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-sdk-ubuntu.16.04-x64.1.1.9.deb)   | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-ubuntu.16.04-x64.1.1.9.tar.gz)                          |[64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-sharedframework-ubuntu.16.04-x64.1.1.8.deb) | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-ubuntu.16.04-x64.1.1.8.tar.gz) |
| Fedora 24               | -                                                         | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-fedora.24-x64.1.1.9.tar.gz)                          | - | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-rhel-x64.1.1.8.tar.gz) |
| RHEL 7                  | -                                                         | [64-bit](https://download.microsoft.com/download/4/0/2/4022CFC7-5061-4762-B9BA-48B35632572D/dotnet-dev-rhel-x64.1.1.9.tar.gz)                          | - | [64-bit](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/dotnet-rhel-x64.1.1.8.tar.gz) |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.8-sdk-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.9-SDK-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/corefx-1.1.8-symbols.zip)
* [Runtime](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/coreclr-1.1.8-symbols.zip)

## Docker

Images for .NET Core 1.1.8 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).

## Installing .NET Core on Linux

### Ubuntu and Debian based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Ubuntu 16.04 and Linux Mint 18

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-xenial-prod xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
```

#### Ubuntu 14.04 and Linux Mint 17

```bash
curl https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.gpg
sudo mv microsoft.gpg /etc/apt/trusted.gpg.d/microsoft.gpg
sudo sh -c 'echo "deb [arch=amd64] https://packages.microsoft.com/repos/microsoft-ubuntu-trusty-prod trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
```

#### Update package cache and install .NET Core

```bash
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.9
```

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`. This is a change from previous versions of .NET Core.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## Windows Server Hosting

If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the Windows (Server Hosting) installer and run the following command from an Administrator command prompt:

[DotNetCore.1.0.11_1.1.8-WindowsHosting.exe](https://download.microsoft.com/download/1/B/8/1B80E25B-316E-4DFB-9707-DB758681F175/DotNetCore.1.0.11_1.1.8-WindowsHosting.exe)
