# .NET Core SDK 2.1.201

This release contains the previously released [.NET Core 2.0.7 Runtime](2.0.7-download.md) and ASP.NET Core 2.0.8:


|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: |
| Windows | [32-bit](https://download.microsoft.com/download/C/7/D/C7DCA2DE-7163-45D1-A05A-5112DAF51445/dotnet-sdk-2.1.201-win-x86.exe) / [64-bit](https://download.microsoft.com/download/C/7/D/C7DCA2DE-7163-45D1-A05A-5112DAF51445/dotnet-sdk-2.1.201-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/C/7/D/C7DCA2DE-7163-45D1-A05A-5112DAF51445/dotnet-sdk-2.1.201-win-x86.zip) / [64-bit](https://download.microsoft.com/download/C/7/D/C7DCA2DE-7163-45D1-A05A-5112DAF51445/dotnet-sdk-2.1.201-win-x64.zip) | [32-bit](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/dotnet-runtime-2.0.7-win-x86.exe) / [64-bit](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/dotnet-runtime-2.0.7-win-x64.exe) | [32-bit](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/dotnet-runtime-2.0.7-win-x86.zip) / [64-bit](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/dotnet-runtime-2.0.7-win-x64.zip) |
| macOS   | [64-bit](https://download.microsoft.com/download/C/7/D/C7DCA2DE-7163-45D1-A05A-5112DAF51445/dotnet-sdk-2.1.201-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/C/7/D/C7DCA2DE-7163-45D1-A05A-5112DAF51445/dotnet-sdk-2.1.201-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/dotnet-runtime-2.0.7-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/dotnet-runtime-2.0.7-osx-x64.tar.gz)   |
| Linux * | See installations steps below                         | [64-bit](https://download.microsoft.com/download/C/7/D/C7DCA2DE-7163-45D1-A05A-5112DAF51445/dotnet-sdk-2.1.201-linux-x64.tar.gz)     | -                                                                  | [64-bit](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/dotnet-runtime-2.0.7-linux-x64.tar.gz) |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.7-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.201-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/E/F/7/EF7302FE-4F84-4529-9E3A-893450F76501/corefx-2.0.8-symbols.zip)
* [Runtime](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/coreclr-2.0.7-symbols.zip)
* [core-setup](https://download.microsoft.com/download/A/9/F/A9F8872C-48B2-41DB-8AAD-D5908D988592/core-setup-2.0.7-symbols.zip)

## Docker

Images for .NET Core 2.0.7 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).

## Installing .NET Core on Linux

Instructions for installing using your package manager can be found on the [.NET Core](https://learn.microsoft.com/dotnet/core/install/linux) docs.

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.0.7` using your package manager.

## Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linux systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:
[DotNetCore.2.0.8-WindowsHosting.exe](https://download.microsoft.com/download/E/F/7/EF7302FE-4F84-4529-9E3A-893450F76501/DotNetCore.2.0.8-WindowsHosting.exe)
This will install the ASP.NET Core Module for IIS

### Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `dotnet-hosting-2.0.8` using your package manager.
This will also install the .NET Core Runtime and other required packages.

### ASP.NET Runtime Core Package Store

The Runtime Package Store is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the Runtime Package Store separately, the following can be used.

* [AspNetCore.2.0.7.RuntimePackageStore_x64.exe](https://download.microsoft.com/download/E/F/7/EF7302FE-4F84-4529-9E3A-893450F76501/AspNetCore.2.0.8.RuntimePackageStore_x64.exe)
* [AspNetCore.2.0.7.RuntimePackageStore_x86.exe](https://download.microsoft.com/download/E/F/7/EF7302FE-4F84-4529-9E3A-893450F76501/AspNetCore.2.0.8.RuntimePackageStore_x86.exe)

On Linux systems install `aspnetcore-store-2.0.7` using your package manager. This will install both the ASP.NET Core and .NET Core runtime components.
