# .NET Releases

The .NET team releases new major versions of .NET annually, each November. Releases are either Long Term Support (LTS) or Standard Term Support (STS), and transition from full support through to end-of-life on a defined schedule, per [.NET release policies][policies]. .NET releases are [supported by Microsoft](microsoft-support.md) on [multiple operating systems](os-lifecycle-policy.md) and hardware architectures.

All .NET versions can be downloaded from the [.NET Website](https://dotnet.microsoft.com/download/dotnet), [Linux Package Managers](https://learn.microsoft.com/dotnet/core/install/linux), and the [Microsoft Artifact Registry](https://mcr.microsoft.com/catalog?search=dotnet/).

## Supported releases

The following table lists supported releases.

|  Version  | Release Date | Support | Latest Patch Version | End of Support |
| :-- | :-- | :-- | :-- | :-- |
| [.NET 8](release-notes/8.0/README.md) | [November 14, 2023](https://devblogs.microsoft.com/dotnet/announcing-dotnet-8/) | [LTS][policies] | [8.0.10][8.0.10] | November 10, 2026 |
| [.NET 6](release-notes/6.0/README.md) | [November 8, 2021](https://devblogs.microsoft.com/dotnet/announcing-net-6/) | [LTS][policies] | [6.0.35][6.0.35]  | November 12, 2024 |

[8.0.10]: release-notes/8.0/8.0.10/8.0.10.md
[6.0.35]: release-notes/6.0/6.0.35/6.0.35.md

## RC releases

The following table lists unsupported rc releases.

|  Version  | Release Date | Support | Latest Patch Version | End of Support |
| :-- | :-- | :-- | :-- | :-- |
| [.NET 9](release-notes/9.0/README.md) | November 12, 2024 | [STS][policies] | [9.0.0-rc.2][9.0.0-rc.2] | May 12, 2026 |

[9.0.0-rc.2]: release-notes/9.0/preview/rc2/9.0.0-rc.2.md

## End-of-life releases

The following table lists end-of-life releases.

|  Version  |  Release Date | Support | Final Patch Version | End of Support |
| :-- | :-- | :-- | :-- | :-- |
| [.NET 7](release-notes/7.0/README.md) | [November 8, 2022](https://devblogs.microsoft.com/dotnet/announcing-dotnet-7/) | [STS][policies] | [7.0.20][7.0.20] |[May 14, 2024](https://devblogs.microsoft.com/dotnet/dotnet-7-end-of-support/) |
| [.NET 5](release-notes/5.0/README.md) | [November 10, 2020](https://devblogs.microsoft.com/dotnet/announcing-net-5-0/) | [STS][policies] | [5.0.17][5.0.17] | [May 10, 2022](https://devblogs.microsoft.com/dotnet/dotnet-5-end-of-support-update/) |
| [.NET Core 3.1](release-notes/3.1/README.md) | [December 3, 2019](https://devblogs.microsoft.com/dotnet/announcing-net-core-3-1/) | [LTS][policies] | [3.1.32][3.1.32] | [December 13, 2022](https://devblogs.microsoft.com/dotnet/net-core-3-1-will-reach-end-of-support-on-december-13-2022/) |
| [.NET Core 3.0](release-notes/3.0/README.md) | [September 23, 2019](https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0/) |  [STS][policies] | [3.0.3][3.0.3] | [March 3, 2020](https://devblogs.microsoft.com/dotnet/net-core-3-0-end-of-life/) |
| [.NET Core 2.2](release-notes/2.2/README.md) | [December 4th, 2018](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-2/) | [STS][policies] | [2.2.8][2.2.8] | [December 23, 2019](https://devblogs.microsoft.com/dotnet/net-core-2-2-will-reach-end-of-life-on-december-23-2019/) |
| [.NET Core 2.1](release-notes/2.1/README.md) | [May 30, 2018](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-1/) | [LTS][policies] | [2.1.30][2.1.30] | [August 21, 2021](https://devblogs.microsoft.com/dotnet/net-core-2-1-will-reach-end-of-support-on-august-21-2021/) |
| [.NET Core 2.0](release-notes/2.0/README.md) | [August 14th, 2017](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-0/) | [STS][policies] | [2.0.9][2.0.9] | [October 1, 2018](https://devblogs.microsoft.com/dotnet/net-core-2-0-will-reach-end-of-life-on-september-1-2018/) |
| [.NET Core 1.1](release-notes/1.1/README.md) | [November 16th, 2016](https://devblogs.microsoft.com/dotnet/announcing-net-core-1-1/) | [LTS][policies] | [1.1.13][1.1.13] | [June 27, 2019](https://devblogs.microsoft.com/dotnet/net-core-1-0-and-1-1-will-reach-end-of-life-on-june-27-2019/) |
| [.NET Core 1.0](release-notes/1.0/README.md) | [June 27th, 2016](https://devblogs.microsoft.com/dotnet/announcing-net-core-1-0/) | [LTS][policies] | [1.0.16][1.0.16] | [June 27, 2019](https://devblogs.microsoft.com/dotnet/net-core-1-0-and-1-1-will-reach-end-of-life-on-june-27-2019/) |

[7.0.20]: release-notes/7.0/7.0.20/7.0.20.md
[5.0.17]: release-notes/5.0/5.0.17/5.0.17.md
[3.1.32]: release-notes/3.1/3.1.32/3.1.32.md
[3.0.3]: release-notes/3.0/3.0.3/3.0.3.md
[2.2.8]: release-notes/2.2/2.2.8/2.2.8.md
[2.1.30]: release-notes/2.1/2.1.30/2.1.30.md
[2.0.9]: release-notes/2.0/2.0.9.md
[1.1.13]: release-notes/1.1/1.1.13/1.1.13.md
[1.0.16]: release-notes/1.0/1.0.16/1.0.16.md
[policies]: release-policies.md
