# .NET Support

.NET binaries, packages, and container images are provided and supported by organizations that participate in the .NET community, [build .NET from source](https://github.com/dotnet/dotnet), and offer regularly updated assets to their users. These organizations work together to enable developers to be productive and safe on Linux, macOS, and Windows.

## Policies

.NET is supported per the following policies:

* [.NET releases](releases.md)
* [.NET release policies](release-policies.md)
* [.NET supported operating system lifecycle](os-lifecycle-policy.md)

## Community support

Community support is available on GitHub, such as at [dotnet/core](https://github.com/dotnet/core) and [.NET repos](./Documentation/core-repos.md).

Community builds are available for [FreeBSD](https://wiki.freebsd.org/.NET), [Linux](linux.md), and [macOS](https://formulae.brew.sh/cask/dotnet-sdk)

### Compatible derivatives

There are many [Linux distributions](https://en.wikipedia.org/wiki/List_of_Linux_distributions). Compatible derivatives of a [supported distribution](./os-lifecycle-policy.md) will typically be supported at the same level.

The following derivatives are supported, for example:

* RHEL-family: AlmaLinux, CentOS Stream, Oracle Linux, and Rocky Linux.
* Ubuntu family: Linux Mint

## Commercial support

Commercial support is provided by the following companies.

### Canonical

Canonical supports .NET on Ubuntu, per the following.

* .NET 6 is supported in Ubuntu 22.04+
* .NET 8 is supported in Ubuntu 22.04+.

### Microsoft

Microsoft provides [stable builds](https://dotnet.microsoft.com/download) and [commercial support](https://support.serviceshub.microsoft.com/supportforbusiness/onboarding) for .NET on [multiple operating systems](os-lifecycle-policy.md), per [.NET support policy](https://dotnet.microsoft.com/platform/support/policy).

.NET container images are provided for a more limited set of [operating system versions](https://github.com/dotnet/dotnet-docker/blob/main/documentation/supported-platforms.md).

### Red Hat

Red Hat supports .NET on Red Hat Enterprise Linux, per [.NET life cycle policy](https://access.redhat.com/support/policy/updates/net-core).
