#
# spec file for package logrotate
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


Name:           logrotate
Version:        3.18.1
Release:        150400.3.10.1
Summary:        Cron service for rotating, compressing, mailing and removing system log files
License:        GPL-2.0-or-later
Group:          System/Base
URL:            https://github.com/logrotate/logrotate
Source0:        https://github.com/%{name}/%{name}/releases/download/%{version}/%{name}-%{version}.tar.xz
# SUSE specific logrotate configurations
Source1:        logrotate.wtmp
Source2:        logrotate.default
Source10:       https://github.com/%{name}/%{name}/releases/download/%{version}/%{name}-%{version}.tar.xz.asc
Source100:      %{name}-rpmlintrc
Patch0:         logrotate-3.13.0-systemd_add_home_env.patch
# PATCH FIX (bsc#1199652, CVE-2022-1348) insecure permissions for state file creation
Patch1:         logrotate-CVE-2022-1348.patch
# PATCH FIX UPSTREAM (bsc#1199652, CVE-2022-1348) insecure permissions for state file creation
# follow up patch for CVE: https://github.com/logrotate/logrotate/pull/446
Patch2:         logrotate-CVE-2022-1348-follow-up.patch
# PATCH FIX UPSTREAM (bsc#1192449) Core-dump handing with SUID binaries
# - https://github.com/logrotate/logrotate/pull/427
# - https://github.com/logrotate/logrotate/pull/431
Patch3:         logrotate-enforce-stricter-parsing.patch
Patch4:         logrotate-enforce-stricter-parsing-extra-tests.patch
Patch5:         logrotate-dont_warn_on_size=_syntax.patch.patch
# Patch for PED-10366: backport ignoreduplicates config option
Patch6:		logrotate-ignore-duplicates.patch

BuildRequires:  acl
BuildRequires:  libacl-devel
BuildRequires:  automake
BuildRequires:  pkgconfig
BuildRequires:  pkgconfig(libselinux)
BuildRequires:  pkgconfig(popt)
BuildRequires:  pkgconfig(systemd) >= 197
Requires:       %{_bindir}/xz
%{?systemd_ordering}

%description
The logrotate utility does automatic rotation, compression, mailing and removal
of log files. Logrotate can be set to handle a log file daily, weekly, monthly,
or when the log file reaches a certain size. Normally, logrotate runs as a
daily cron job.

It manages plain files only and is not involved in systemd's journal rotation.

%prep
%autosetup -p1

%build
autoreconf -fi

%configure \
    --disable-silent-rules \
    --with-state-file-path=%{_localstatedir}/lib/misc/logrotate.status \
    --disable-werror
%make_build

%check
# Make all test cases executable to avoid them failing (new
# tests may be introduced by patches, like CVE-2022-1348)
chmod +x test/*.sh

%make_build check

%install
%make_install
mkdir -p %{buildroot}%{_sysconfdir}/logrotate.d
install -m 644 %{SOURCE1} %{buildroot}%{_sysconfdir}/logrotate.d/wtmp
install -m 644 %{SOURCE2} %{buildroot}%{_sysconfdir}/logrotate.conf
install -D -m 0644 examples/%{name}.service %{buildroot}%{_unitdir}/%{name}.service
install -D -m 0644 examples/%{name}.timer %{buildroot}%{_unitdir}/%{name}.timer
ln -s service %{buildroot}%{_sbindir}/rc%{name}

%pre
#only the timer can be enabled/disabled/masked !
%service_add_pre %{name}.service %{name}.timer

%post
%{remove_and_set MAX_DAYS_FOR_LOG_FILES}
# Move /var/lib/logrotate.status
if [ -f %{_localstatedir}/lib/logrotate.status -a ! -f %{_localstatedir}/lib/misc/logrotate.status ]; then
  mv %{_localstatedir}/lib/logrotate.status %{_localstatedir}/lib/misc/logrotate.status ||:
fi

%service_add_post %{name}.service %{name}.timer

%preun
%service_del_preun %{name}.service %{name}.timer

%postun
%service_del_postun %{name}.service %{name}.timer

%files
%license COPYING
%doc ChangeLog.md README.md
%{_sbindir}/logrotate
%{_sbindir}/rc%{name}
%{_mandir}/man8/logrotate.8%{?ext_man}
%{_mandir}/man5/logrotate.conf.5%{?ext_man}
%config %{_sysconfdir}/logrotate.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/wtmp
%{_unitdir}/%{name}.service
%{_unitdir}/%{name}.timer

%changelog
* Wed Sep 11 2024 angel.yankov@suse.com
- Backport 'ignoreduplicates' configuration flag (jsc#PED-10366)
  * Added patch logrotate-ignore-duplicates.patch
  * Allows log processing with duplicate logfile matches
* Wed Jun 15 2022 david.anes@suse.com
- Security fix: (bsc#1192449) related to (bsc#1191281, CVE-2021-3864)
  * enforce stricter parsing to avoid CVE-2021-3864
  * Added patch logrotate-enforce-stricter-parsing.patch
  * Added patch logrotate-enforce-stricter-parsing-extra-tests.patch
* Tue Jun  7 2022 manfred.h@gmx.net
- Fix "logrotate emits unintended warning: keyword size not properly
  separated, found 0x3d" (bsc#1200278, bsc#1200802):
  * Added patch logrotate-dont_warn_on_size=_syntax.patch
* Thu May 19 2022 david.anes@suse.com
- Security fix: (bsc#1199652, CVE-2022-1348)
  * insecure permissions for state file creation
  * Added patch logrotate-CVE-2022-1348.patch
  * Added patch logrotate-CVE-2022-1348-follow-up.patch
* Thu May 27 2021 dmueller@suse.com
- update to 3.18.1:
  * fix memory leaks on error-handling paths
  * make `renamecopy` and `copytruncate` override each other
  * improve error handling in the parser of configuration files
  * improve user experience for non-privileged users of logrotate
* Wed Feb  3 2021 pmonreal@suse.com
- Update to 3.18.0:
  * Allow UIDs and GIDs to be specified numerically
  * Add support for Zstandard compressed files
  * Make delaycompress not to fail with rotate 0
* Tue Jul 28 2020 pmonreal@suse.com
- Update to 3.17.0:
  * lock state file to prevent parallel execution of logrotate
  * add '.bak' extension to default taboo list
  * allow to pass a home-relative path to 'include'
  * 'switch_user_permanently': skip switchback check if switched to root
  * logrotate.service: enable 'ProtectClock' to restrict setting of clock
  * delete old logs hit by 'maxage' regardless of 'dateext'
* Wed Apr 15 2020 kukuk@suse.com
- Require /usr/bin/xz instead of xz to make it working with busybox
* Mon Mar  2 2020 tchvatal@suse.com
- Update to 3.16.0 bsc#1160281:
  * fix compilation with gcc-10, which defaults to -fno-common (#288)
  * reduce number of open() operations on state file (#282)
  * validate user/group given to the su directive early (#276)
  * add hardening options to systemd unit file in examples (#274, #291)
  * fix crash of logrotate on invalid configuration with include (#271)
  * fix heap buffer overflow on too long logfile extension (#270)
* Wed Jan  8 2020 tchvatal@suse.com
- Update to 3.15.1:
  * use correct create mode in examples/btmp (#257)
  * fix several bugs found by fuzzing (#254)
  * do not abort globbing on a broken symlink (#251)
  * rearrange logrotate.8 man page to improve readability (#248)
  * encourage admins to use the su directive in logrotate.8 man page (#236)
* Thu Jan  2 2020 kukuk@suse.de
- Use systemd_ordering instead of systemd_requires
* Thu Apr  4 2019 pmonrealgonzalez@suse.com
- Version update to 3.15.0:
  * timer unit: change trigger fuzz from 12h to 1h
  * service unit: only run if /var/log is mounted
  * preserve fractional part of timestamps when compressing
  * re-indent source code using spaces only
  * minage: avoid rounding issue while comparing the amount of seconds
  * never remove old log files if rotate -1 is specified
  * return non-zero exit status if a config file contains an error
  * make copytruncate work with rotate 0
  * warn user if both size and the time interval options are used
  * pass rotated log file name as the 2nd argument of the postrotate
    script when sharedscript is not enabled
  * rename logrotate-default to logrotate.conf
- Added asc file.
* Thu Sep 13 2018 tchvatal@suse.com
- Rebase the logrotate-3.13.0-systemd_add_home_env.patch to be
  unified patch again
* Mon Sep 10 2018 jengelh@inai.de
- Use noun phrase. Trim filler wording from description.
  Add a note that it is unrelated to journald.
* Fri Sep  7 2018 liedke@rz.uni-mannheim.de
- Version update to 3.14.0:
  * make configure show support status for SELinux and ACL at the end
  * make logrotate build again on FreeBSD
  * move wtmp and btmp definitions from logrotate.conf to
    separate configuration files in logrotate.d
  * print a warning about logrotate doing nothing when -d is used
  * do not reject executable config files
  * add hardening options to logrotate.service in examples
  * fix spurious compressor failure when using su and compress
  * keep logrotate version in .tarball-version in release tarballs
  * introduce the hourago configuration directive
  * ignore empty patterns in tabooext to avoid exclusion of everything
  * properly report skipped test cases instead of pretending success
* Thu Jun  7 2018 kstreitova@suse.com
- Add "Environment=HOME=/root" to logrotate.service file in order
  to allow mariadb to rotate its logs when the database has a root
  password defined [bsc#1093617]
- Added patch:
  * logrotate-3.13.0-systemd_add_home_env.patch
* Tue Apr  3 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Fri Jan  5 2018 pmonrealgonzalez@suse.com
- Version update to 3.13.0:
  * make distribution tarballs report logrotate version properly
  * make (un)compress work even if stdin and/or stdout are closed (#154)
  * remove -s from DEFAULT_MAIL_COMMAND and improve its documenation (#152)
  * uncompress logs before mailing them even if delaycompress is enabled (#151)
  * handle unlink of a non-existing log file as a warning only (#144)
  * include compile-time options in the output of logrotate --version (#145)
  * make logrotate --version print to stdout instead of stderr (#145)
  * flush write buffers before syncing state file (#148)
  * specify (un)compress utility explicitly in tests (#137)
  * enable running tests in parallel (#132)
  * explicitly map root UID/GID to 0 on Cygwin (#133)
  * add .dpkg-bak and .dpkg-del to default tabooext list (#134)
* Fri Jul  7 2017 tchvatal@suse.com
- Version update to 3.12.3:
  * Fixed accident removal of rotated files with dateext. (#118)
  * Line comments inside globs in config files are now skipped. (#109)
  * logrotate now recovers from a corrupted state file. (#45)
  * createolddir now creates old directory as unprivileged user. (#114)
  * weekly rotations are now predictable and configurable. (#93)
  * Errors in config files are no longer treated as fatal errors. (#81)
  * configure --with-default-mail-command specifies default mail command. (#100)
  * Fixed heap buffer overflow when parsing crafted config file. (#33)
  * build fixes related to -Werror (#119) and -Werror=format= (#108)
  * configure --enable-werror now controls use of the -Werror flag (#123)
  * copy and copytruncate directives now work together again
  * unlink() is no longer preceded by open() unless shred is enabled (#124)
  * compress and uncompress now take commands from $PATH, too (#122)
- By default disable werror while building
* Fri Jul  7 2017 tchvatal@suse.com
- Remove aaa_base compat setting that is from 2003, we do not
  support such migration anymore
* Wed Dec 28 2016 tchvatal@suse.com
- Version update to 3.11.0:
  * Merges from distribution patchsets and small fixes around
- Remove all patches merged upstream:
  * logrotate-addextension.patch
  * logrotate-autoext.patch
  * logrotate-conf.patch
  * logrotate-fix-test62_with_bash-4.4.patch
  * logrotate-manpage_config_clarification.patch
  * logrotate-var-lib-misc.patch
  * logrotate-3.7.8-suse.patch
* Mon Nov 21 2016 tchvatal@suse.com
- Fix post scriptlet condition bnc#1011120
* Sat Nov 12 2016 kukuk@suse.de
- Move logrotate.status to /var/lib/misc following FHS/LSB and
  making implementing read-only root filesystem much easier.
  [FATE#322036]
- Add patch:
  * logrotate-var-lib-misc.patch
* Wed Oct  5 2016 tchvatal@suse.com
- Version update to 3.10.0 fate#322037:
  * Update url to point to github
- Remove upstreamed patch:
  * logrotate-3.7.8-mess_err.patch
- Rebase patches:
  * logrotate-3.7.8-suse.patch
  * logrotate-addextension.patch
  * logrotate-autoext.patch
  * logrotate-fix-test62_with_bash-4.4.patch
* Mon Oct  3 2016 dimstar@opensuse.org
- Add logrotate-fix-test62_with_bash-4.4.patch: Fix the test suite
  when running with bash 4.4 (gh#logrotate/logrotate#66).
* Mon Jun 22 2015 kstreitova@suse.com
- update to 3.9.1
  * 3.9.1
  - Fix off-by-one error which can lead to crash when copytruncate
    is used.
  * 3.9.0
  - Fix crash when using long dateformat. [nmerdan]
  - Add support for %%H dateformat. [czchen]
  - Fix regression introduced in 3.8.9 when when rotating multiple
    logs when one of them is missing.
  - In the debug mode, do not skip the code-path which handles the
    case when the last rotation does not exist. [Sergey Vidishev]
  - Show more precise description when "log does not need rotating".
  - Add new -l option to log verbose output to file. The file is
    overwritten on every logrotate execution.
  - Allow rotation of sparse files with copytruncate.
  * update logrotate-addextension.patch
- use spec-cleaner
- remove unused PreReq tags
* Tue May 19 2015 crrodriguez@opensuse.org
- Enable Persistent timer since we are now in systemd 219.
* Fri Feb 20 2015 p.drouand@gmail.com
- Update to version 3.8.9
  * Add new directive "createolddir" and "nocreateolddir". These directives
    can be used to create the directory specified by olddir with particular
  "mode", "owner" and "group".
  * Continue with rotation even when first log from logset is removed
  during the rotation.
  * Fix crash on BSD systems introduced in 3.8.8 caused by different qsort_r
  function. Function qsort is now used instead.
  * Fix potential buffer overflow in usage of strncat function.
  * Fix compilation with musl-libc.
  * Add experimental 'renamecopy' directive to allow 'olddir' on different
    physical device. See the "man logrotate" for more information.
- Remove logrotate-fail_if_ENOENT_and_nomissingok.patch; merged on
  upstream release
- Updated patches
  * logrotate-3.7.8-addextension.patch > logrotate-addextension.patch
  * logrotate-3.7.8-autoext.patch > logrotate-autoext.patch
  * logrotate-3.7.8-conf.patch > logrotate-conf.patch
  * logrotate-manpage_config_clarification.patch
- Remove redunant %%clean section
* Thu Jun 26 2014 vcizek@suse.com
- temporarily remove the 'Persistent' option from logrotate.timer
  * our current systemd doesn't support it yet (bnc#884338)
* Thu Apr  3 2014 crrodriguez@opensuse.org
- Also, avoid logrotate unit activation when the system is
  on battery power.
* Thu Apr  3 2014 crrodriguez@opensuse.org
- BuildRequire systemd 197 or later.
* Wed Apr  2 2014 crrodriguez@opensuse.org
- Migrate from cron to systemd timer units, this is overall
  the most important package to migrate since it is one
  of the very few base components that hard-require cron.
* Tue Apr  1 2014 vcizek@suse.com
- return error when nomissingok is specified and the log path
  doesn't exist (bnc#871217)
  * added logrotate-fail_if_ENOENT_and_nomissingok.patch
* Thu Nov  7 2013 sweet_f_a@gmx.de
- enable acl support to preserve ACLs during rotation
* Thu Nov  7 2013 sweet_f_a@gmx.de
- update to 3.8.7, fix bnc#849436
- Changelog 3.8.7:
  * Fixed --force/-f option handling together with "size" directive
    (3.8.5 regression).
  * Use "logrotate_tmp_t" context for SELinux tests and if this
    context does not exist, skip SELinux related tests.
- Changelog 3.8.6
  * Fixed memory corruption caused by rotation directory which
    does not exist with "sharedscripts" together with "prerotate"
    script.
* Tue Aug 20 2013 vcizek@suse.com
- install COPYING file (bnc#817870)
* Thu Aug  1 2013 vcizek@suse.com
- mention in the manpage that = is an allowed separator in the
  config file (bnc#831072)
  * added logrotate-manpage_config_clarification.patch
* Thu Jul 25 2013 vcizek@suse.com
- update to 3.8.5
  * dropped logrotate-3.7.9-compressoptions.patch (upstream)
  * refreshed other patches
  Changelog:
  - Improved rotation during daylight saving time and between timezone
    changes.
  - Fixed ACL setting problem caused by ext3 erroneously reporting ENOSYS
    instead of ENOSUP.
  - Do not continue with rotation if state file is corrupted.
  - Make logrotate.status creation atomic.
  - Allow "hourly" rotation. See manpage for more information.
  - Use "/bin/echo" in tests. Fixes tests execution in Dash.
  - Do no try to parse config files bigger than 16MB.
  - Improved manpage consistency and formatting.
  - Fix race condition between acl_set_fd() and fchmod().
  - Added --version command line option
  - Disable ACL tests if logrotate is not compiled WITH_ACL support or if
    ACLs are not supported by the system running tests
  - Disable SELinux tests if logrotate is not compiled WITH_SELINUX support
    or if SELinux is not supported by the system running tests
  - Fixed bug which prevented skipping particular log file config
    if the config contained errors.
  - Fixed skipping of configs containing firstaction/lastaction scripts
    with '}' character in case of error before these scripts.
  - Support also 'K' unit for *size directives.
  - Added preremove option to let admin to do something with the old logs
    before they are removed by logrotate.
  - Fixed possible loop in tabooext parsing.
  - Move code to set SELinux context before compressLogFile calls to create
    compressed log files with the proper context.
  - Call prerotate/postrotate script only for really rotated files in
    nosharedscripts mode (as stated in man page).
  - Fixed setting "size" bigger than 4GB on 32bit architectures
  - Do not overwrite mode set by "create" option when using ACL. "create"
    directive is now not mixed up with ACLs. If you use "create" in config
    file and log file has some ACLs set, ACLs are not kept and are
    overwritten by the mode set in "create" directive.
  - Mode argument in "create" directive can be omitted. Only owner and group
    is set in this case. Check man page for more info.
  - show error and ignore config if '{' is not present after log files
    declaration
  - support whitespaces in compressoptions directive
  - support for tilde expansion in config files
  - 'su' directive does not affect script execution - scripts
    are executed as a root if 'su' directive is present
  - fixed mail sending for 'mailfirst', 'dateext' and 'delaycompress'
    combination
  - do not use gzip/gunzip from /usr/local on Solaris
  - add O_NOFOLLOW when opening files as safeguard against symlink tricks.
    Symlinks rotation is now officially unsupported. It didn't work
    as expected in the past anyway.
  - do not run external programs with uid != euid
  - fixed potential bad-free when ACL is used
  - Do not include alloca.h on NetBSD, since alloca() is declared in
    stdlib.h there
* Tue Apr 16 2013 mmeister@suse.com
- Added url as source.
  Please see http://en.opensuse.org/SourceUrls
* Fri Sep 30 2011 uli@suse.com
- cross-build fix: use %%__cc macro
* Wed Sep  7 2011 vcizek@suse.com
- update to 3.8.1
- dropped CVE patches as they were merged to upstream
- changelog
  - fixed 1 memory leak in prerotateSingleLog
  - do not redirect logrotate errors to /dev/null in cron script
  - fixed "size" directive parsing
  - handle situation when acl_get_fd is supported, but acl_set_fd is not
  - added "maxsize" directive (see man page)
  - added "dateyesterday" option (see man page)
  - fixed crash when config file had exactly 4096*N bytes
  - added WITH_ACL make option to link against -lacl and preserve ACLs
    during rotation
  - added "su" option to define user/group for rotation. Logrotate now
    skips directories which are world writable or writable by group
    which is not "root" unless "su" directive is used.
  - fixed CVE-2011-1098: race condition by creation of new files
  - fixed possible shell injection when using "shred" directive (CVE-2011-1154)
  - fixed escaping of file names within 'write state' action (CVE-2011-1155)
  - better 'size' directive description
  - fixed possible buffer-overflow when reading config files
* Wed Sep  7 2011 vcizek@suse.com
- allow whitespace separated options in compressoptions (bnc#711780)
* Mon Jul 25 2011 jengelh@medozas.de
- Change compression scheme to xz
* Tue May 10 2011 puzel@novell.com
- add logrotate-CVE-2011-1098.patch (bnc#677336)
- add logrotate-shred-CVE-2011-1154.patch (bnc#679661)
- add logrotate-CVE-2011-1155.patch (bnc#679662)
- use spec-cleaner
* Thu Nov 18 2010 lnussel@suse.de
- also rotate /var/log/btmp
* Tue Sep 14 2010 puzel@novell.com
- use proper syslog facility/priority in logrotate cron
  script (bnc#636236)
* Tue Aug 17 2010 puzel@novell.com
- update to logrotate-3.7.9
  - don't copy config files on the stack -- mmap them instead
    (fixes segfaults with too large/invalid config files)
  - symlinked conf file man page as requested by Fedora guidelines
  - added rotating (copying) non-writable, readable files
  - fixed missingok problem with globs
  - fixed bug when log files could be removed even there was
    some error in rotation process.
  - allow setting size greater than 4.2GB in configuration file
  - pass currently rotated file to postrotate/prerotate script
    in nosharedscripts mode
  - added new TabooExts: ".disabled", ".dpkg-old", ".dpkg-dist",
    ".dpkg-new", ".cfsaved", ".ucf-old", ".ucf-dist", ".ucf-new"
  - Don't change utime atime/mtime when compressing files
  - Better *rotate scripts parser.
  - Allow 'include' directive in log file definitions
- merge logrotate-3.7.8-cron-check-for-another-instance.patch into
  logrotate-3.7.8-suse.patch
- add logrotate-rpmlintrc: suppress false-positive rpmlint warning
* Sun Dec 20 2009 jengelh@medozas.de
- enable parallel build
* Fri Mar  6 2009 puzel@suse.cz
- update to 3.7.8
  - do not exit on status file errors
  - limit config file inclusion nesting
  - use hashes for status file handling
  - dateformat to allow unixtime
  - manual page corrections
- drop hashes patch (upstream)
* Wed Dec 10 2008 schwab@suse.de
- Fix compresscmd default.
* Tue Oct 21 2008 puzel@suse.cz
- logrotate-3.7.7-hashes.patch (bnc#415072)
* Tue Sep 30 2008 puzel@suse.cz
- use chekcproc in logrotate.cron script instead of pgrep (bnc#426162)
* Wed Sep  3 2008 puzel@suse.cz
- update to 3.7.7
  - dateformat
  - fix possible buffer overflows in strings handling
  - change logInfo handling
  - fix compile warnings
  - tabooext honor wildcards
  - fix selinux support with dateext
  - various minor bugfixes
- removed logrotate-3.7.5-errorHandling.patch, logrotate-3.7.5-shred.patch,
  logrotate-3.7.5-cfengine.patch, logrotate-3.7.5-date.patch,
  logrotate-3.7.5-logfn.patch
  - merged to upstream
* Mon Aug 25 2008 prusnak@suse.cz
- enabled SELinux support [Fate#303662]
* Wed Aug 20 2008 puzel@suse.cz
- added logrotate-3.7.5-cron-check-for-another-instance.patch
  - cronjob exits immediately if there is another logrotate instance
    running
  - fixes (bnc#415072)
* Thu Aug 14 2008 puzel@suse.cz
- fix rpmlint warnings:
  - make test moved to %%check section
  - require cron
* Thu Jan 31 2008 ro@suse.de
- log error if target file already exists
  (upgrade from MESS_DEBUG to MESS_ERROR)
* Wed Oct 31 2007 ro@suse.de
- added bzip2 as dependency since it's used as default compressor
  (#334555)
* Thu Aug 16 2007 ro@suse.de
- update to 3.7.5 with some bugfixes containing:
  - 251040 config option size not handled correctly
- added the current fedora patchkit which adds shred support
* Mon Aug  7 2006 ro@suse.de
- try adding new option "addextension" which provides what
  some users expected the old "extension" keyword to do
* Wed Jun 21 2006 ro@suse.de
- update to 3.7.4
  - adds the "minsize" option
- clean up comments in sample logrotate.conf (#183440)
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 11 2006 ro@suse.de
- fixed segfault in autoext patch (#142021)
* Fri Dec  9 2005 ro@suse.de
- updated to 3.7.3
- removed upstreamed patches
- added autoext patch for determining file extension
  from used compression program
* Tue Oct 18 2005 ro@suse.de
- update to upstream patchkit
* Tue Oct 11 2005 ro@suse.de
- update to 3.7.2 and some upstream patches
* Mon Oct 10 2005 ro@suse.de
- fix else case in maxage patch (thanks to pvrabec)
* Tue Jul 26 2005 ro@suse.de
- added noTMPDIR and selinux patches
* Thu May 19 2005 ro@suse.de
- update to 3.7.1
* Wed Apr 20 2005 ro@suse.de
- cron-script: give some more details when things fail
* Mon Sep  6 2004 ro@suse.de
- changed patch sequence, simple ones first
- added one-liner fix from cvs
- fix mail call
- fix uninitialized variable when mailing out first rotation
- fix number of logs kept with dateext
* Thu Mar 25 2004 ro@suse.de
- adapted logger path (#36947)
* Mon Feb 23 2004 ro@suse.de
- update to version 3.7
* Fri Oct 17 2003 ro@suse.de
- don't build as root
- use defattr
* Mon Oct 13 2003 ro@suse.de
- updated to 3.6.10 and ported patches
* Thu Jun 12 2003 kukuk@suse.de
- /etc/logrotate.d is part of filesystem
* Thu Jan 23 2003 ro@suse.de
- update to 3.6.6 (some tmpfile fixes, new options supported)
- remove system-config /etc/logrotate.d/aaa_base and all code
  messing with it (all logrotate configs have been moved to
  their respective packages)
- add /etc/logrotate.d/wtmp
* Wed Jan 22 2003 ro@suse.de
- remove mgetty logfiles
* Mon Jan 20 2003 ro@suse.de
- remove i4l logfiles
* Wed Jan 15 2003 ro@suse.de
- removed xdm logfile from main config (in XFree86 now)
* Wed Jan 15 2003 ro@suse.de
- removed more files from main config and moved to their packages
* Sun Nov 10 2002 ro@suse.de
- fix deprecated multiline string literals
* Mon Oct 14 2002 ro@suse.de
- remove postgresql logfile from config on update (#20860)
* Mon Oct 14 2002 ro@suse.de
- moved syslog logrotation config to syslogd package
* Mon Sep 23 2002 ro@suse.de
- mark logrotate.del as missingok
* Mon Sep  9 2002 ro@suse.de
- remove handling of /var/account/pacct (moved to acct package)
* Fri Aug 16 2002 ro@suse.de
- dropped insserv from prereq (not used)
* Mon Aug  5 2002 kukuk@suse.de
- Add rm and mv to PreRequires
* Tue Jul 30 2002 ro@suse.de
- fixed typo in specfile
- added comment in config-file about bzip2 usage
* Mon Jul 29 2002 ro@suse.de
- removed fetchmail logrotate entry (#17279)
* Mon Jul 29 2002 ro@suse.de
- removed apache,smail,perforce,abuild components
- remove old entries also from logrotate.d/aaa_base on update
* Mon Jul 29 2002 ro@suse.de
- squid components removed (done in squid package now) (#17278)
* Fri Jul 19 2002 gd@suse.de
- fixed samba log paths
* Fri Jul 12 2002 kukuk@suse.de
- Fix post-install script for the case that there is no rc.config
* Mon Jun 24 2002 ro@suse.de
- fixed squid log paths (#16557)
* Wed May  8 2002 ro@suse.de
- uucp-logfiles are handled by own config
* Mon Mar 18 2002 ro@suse.de
- don't rotate any file for /var/log/news.*
* Thu Feb 28 2002 ro@suse.de
- don't overwrite logfiles with dateext if run more than once
  a day (partial solution for #13202)
* Mon Feb 25 2002 ro@suse.de
- install etc_logfiles as 644
* Mon Feb 18 2002 ro@suse.de
- removed yast from logrotate.d
* Sat Feb 16 2002 ro@suse.de
- removed postgresql logfile (handled by package)
* Sun Jan  6 2002 ro@suse.de
- take wtmp out of default config
* Fri Dec 14 2001 ro@suse.de
- really remove old variable from rc.config
* Wed Dec 12 2001 ro@suse.de
- mark files in /etc/logrotate.d as noreplace
* Tue Dec 11 2001 ro@suse.de
- implement maxage if dateext is not used
- uncompress log for mail if maillast is used
* Mon Dec 10 2001 ro@suse.de
- added etc_logfiles as reminder to sources
- moved convert script into postinstall and try to find
  old etc/logfiles and use etc_logfiles as fallback
- added yast and syslog to /etc/logrotate.d as config files
* Mon Dec 10 2001 ro@suse.de
- added maxage extension
* Thu Dec  6 2001 ro@suse.de
- split patches for purpose
* Tue Dec  4 2001 ro@suse.de
- archiving option changed to "dateext" and
  works completely transparent otherwise
* Tue Nov 27 2001 ro@suse.de
- added multiple rotation criteria can be selected at one time
- added/completed implementation for days (max days)
* Mon Nov 26 2001 ro@suse.de
- added archiving option
- added script to convert /etc/logfiles
* Tue Nov 13 2001 ro@suse.de
- initial package for SuSE Linux (version 3.5.9)
