#
# spec file for package kbd
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir /var/adm/fillup-templates
%endif

%define legacy_folders amiga,atari,i386,include,mac,ppc,sun

Name:           kbd
Version:        2.4.0
Release:        150400.5.9.1
Summary:        Keyboard and Font Utilities
# git: git://git.altlinux.org/people/legion/packages/kbd.git
License:        GPL-2.0-or-later
Group:          System/Console
URL:            http://kbd-project.org/
# repack_kbd.sh on https://www.kernel.org/pub/linux/utils/kbd/kbd-%%{version}.tar.xz
Source:         %{name}-%{version}-repack.tar.xz
Source1:        kbd_fonts.tar.bz2
Source2:        suse-add.tar.bz2
Source3:        README.SUSE
Source4:        vlock.pamd
Source8:        sysconfig.console
Source9:        sysconfig.keyboard
Source11:       fbtest.c
Source12:       fbtest.8
Source15:       cz-map.patch
Source20:       kbdsettings
Source21:       kbdsettings.service
Source22:       numlockbios.c
Source42:       convert-kbd-mac.sed
Source43:       repack_kbd.sh
Source44:       xml2lst.pl
Source45:       genmap4systemd.sh
Patch0:         kbd-1.15.2-prtscr_no_sigquit.patch
# PATCH-FIX-UPSTREAM
Patch1:         0001-libkfont-Initialize-kfont_context-options.patch
Patch2:         kbd-1.15.2-unicode_scripts.patch
Patch3:         kbd-1.15.2-docu-X11R6-xorg.patch
Patch4:         kbd-1.15.2-sv-latin1-keycode10.patch
Patch6:         kbd-1.15.2-dumpkeys-C-opt.patch
Patch9:         kbd-2.0.2-comment-typo-qwerty.patch
Patch10:        kbd-2.0.2-doshell-reference.patch
Patch11:        kbd-2.0.2-euro-unicode.patch
Patch12:        kbd-2.0.2-fix-bashisms.patch
# adds xkb and legacy keymaps subdirs to loadkyes search path
# (openSUSE FATE#318355, sle FATE#318426)
Patch13:        kbd-1.15.5-loadkeys-search-path.patch
# PATCH-FEATURE-OPENSUSE kbdsettings-nox86.patch sbrabec@suse.cz -- Disable "bios" option for NumLock settings on non x86 platforms.
Patch14:        kbdsettings-nox86.patch
# PATCH-FIX-SLE kbd-unicode-fxxx.patch sbrabec@suse.com bsc1085432 -- Do not cause error on UNICODE characters >= 0xF000 (e. g. ligature fi)
Patch15:        kbd-unicode-fxxx.patch
# PATCH-FIX-UPSTREAM kbd-ignore-working-directory-1.patch sbrabec@suse.com bsc1237230 -- Don't search for resources in the current directory.
Patch16:        kbd-ignore-working-directory-1.patch
# PATCH-FIX-UPSTREAM kbd-ignore-working-directory-2.patch sbrabec@suse.com bsc1237230 -- Don't search for resources in the current directory.
Patch17:        kbd-ignore-working-directory-2.patch
# PATCH-FIX-UPSTREAM kbd-ignore-working-directory-3.patch sbrabec@suse.com bsc1237230 -- Don't search for resources in the current directory.
Patch18:        kbd-ignore-working-directory-3.patch
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  bison
BuildRequires:  check-devel
BuildRequires:  console-setup
BuildRequires:  fdupes
BuildRequires:  flex
BuildRequires:  gcc >= 4.6
BuildRequires:  libtool
BuildRequires:  pam-devel
BuildRequires:  pkgconfig
BuildRequires:  suse-module-tools
BuildRequires:  xkeyboard-config
BuildRequires:  xz
# Temporarily require -legacy
Requires:       %{name}-legacy = %{version}-%{release}
Requires(post): coreutils
Requires(postun):coreutils
Requires(pre):  %fillup_prereq
Provides:       vlock = 2.2.3
Obsoletes:      vlock <= 2.2.3

%description
Load and save keyboard mappings. This is needed if you are not using
the US keyboard map. This package also contains utilities for changing
your console fonts. If you install this package, YaST includes an extra
menu to allow you to choose between the different fonts. This package
also includes fonts from the kbd_fonts.tar.gz package (by Paul
Gortmaker) on Sunsite.

%package legacy
Summary:        Legacy data for kbd package
Group:          System/Console
BuildArch:      noarch

%description legacy
The %{name}-legacy package contains original keymaps for kbd package.
Please note that %{name}-legacy is not helpful without kbd.

%define kbd %{_datadir}/kbd

%prep
%setup -q -a 1 -a 2 -n kbd-%{version}

cp -fp %{SOURCE8} .
cp -fp %{SOURCE9} .
cp -fp %{SOURCE44} .
cp -fp %{SOURCE45} .
cp -fp %{SOURCE20} .
cp -fp %{SOURCE21} .
cp -fp %{SOURCE22} .
%patch0 -p1
%patch1 -p1
%patch2
%patch3
%patch4 -p1
%patch6
%patch9
%patch10
%patch11
%patch12 -p1
%patch13 -p1
%ifnarch %{ix86} x86_64
%patch14 -p0
%endif
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1

%build
for i in `find data/keymaps/mac -type f` ; do
sed -i -f %{SOURCE42} $i
done
# workaround ambiguous keymap names
pushd data/keymaps/i386
	# bnc#48301
	test -f qwerty/se-latin1.map || cp qwerty/sv-latin1.map qwerty/se-latin1.map
	# bnc#435121
	test -f olpc/es-olpc.map || mv olpc/es.map olpc/es-olpc.map
	# Rename conflicting keymaps, as Fedora do
	#test -f dvorak/no.map || mv dvorak/no.map dvorak/no-dvorak.map
	test -f fgGIod/trf.map || mv fgGIod/trf.map fgGIod/trf-fgGIod.map
	test -f olpc/pt.map || mv olpc/pt.map olpc/pt-olpc.map
	test -f qwerty/cz.map || mv qwerty/cz.map qwerty/cz-qwerty.map
popd
./autogen.sh
%configure \
	--disable-silent-rules \
	--datadir=%{kbd} \
	--enable-nls \
	--localedir=%{_datadir}/locale \
	--enable-optional-progs \
	--disable-static
make %{?_smp_mflags}
gcc %{optflags} -o fbtest      $RPM_SOURCE_DIR/fbtest.c
%ifarch %{ix86} x86_64
gcc %{optflags} -o numlockbios $RPM_SOURCE_DIR/numlockbios.c
%endif
# fix lat2-16.psfu (bnc#340579)
font=data/consolefonts/lat2a-16.psfu
./src/psfxtable -i $font -it  data/unimaps/lat2u.uni \
	-o t.psfu
mv t.psfu $font
make %{?_smp_mflags}

%install
mkdir -p %{buildroot}%{_sbindir}
DOC=%{buildroot}%{_defaultdocdir}/kbd
KBD=%{kbd}
K=%{buildroot}$KBD
mkdir -p $K/consolefonts
# First install the fonts from the vfont package
# (allowing kbd to overwrite some of them)
mkdir -p $DOC/fonts
install -m 644 fonts/README $DOC/fonts/README.fonts
install -m 644 fonts/vfont-4.36/README $DOC/fonts/README.vfont-4.36
install -m 644 fonts/vfont-5.10/README $DOC/fonts/README.vfont-5.10
install -m 644 fonts/vfont-5.10/SCRIPT $DOC/fonts/SCRIPT.vfont-5.10
rm -f fonts/vfont-5.10/SCRIPT fonts/*/README
install -m 644 fonts/*/* $K/consolefonts/
# Now call kbd install
echo "# Now call kbd install DESTDIR=%{buildroot} DATA_DIR=%{kbd} MAN_DIR=%{_mandir}"
make DESTDIR=%{buildroot} DATA_DIR=%{kbd} MAN_DIR=%{_mandir} install
# ln -s iso01-12x22.psfu $K/consolefonts/suse12x22.psfu
install -m 644 data/consolefonts/README* $DOC/fonts/
mkdir -p $DOC/doc/
install -m 644 docs/doc/keysyms.h.info docs/doc/kbd.FAQ.txt docs/doc/kbd.FAQ*.html docs/doc/README* docs/doc/TODO $DOC/doc/
install -m 644 docs/doc/as400.kbd docs/doc/console.docs docs/doc/repeat/set_kbd_repeat-2 $DOC/doc/
echo "See %{_datadir}/i18/charmaps for a description of char maps" >$DOC/doc/README.charmaps
install -m 644 ChangeLog CREDITS README $DOC/
install -m 644 %{SOURCE3} $DOC/
rm -f $K/consolefonts/README* $K/consolefonts/ERRORS.gz
if ls $K/consolefonts/Agafari-* > /dev/null 2>&1; then
  echo "";
  echo "ERROR: Ethiopian Agafari fonts are for noncommercial distribution only."
  echo "please run repack_kbd.sh";
  echo "";
  exit 1
fi
ln -sf us.map.gz $K/keymaps/i386/qwerty/khmer.map.gz
ln -sf us.map.gz $K/keymaps/i386/qwerty/korean.map.gz
ln -sf us.map.gz $K/keymaps/i386/qwerty/ara.map.gz
ln -sf us.map.gz $K/keymaps/i386/qwerty/arabic.map.gz
ln -sf us.map.gz $K/keymaps/i386/qwerty/ir.map.gz
ln -sf us.map.gz $K/keymaps/i386/qwerty/chinese.map.gz
ln -sf us.map.gz $K/keymaps/i386/qwerty/taiwanese.map.gz
ln -sf sr-cy.map.gz $K/keymaps/i386/qwerty/sr-latin.map.gz
# Compatability links; don't know what the first three are good for.
# The others are for yast/langselection and should be removed as soon as
# yast knows about it.
#ln -sf de-latin1-nodeadkeys.map.gz \
#  $K/keymaps/i386/qwertz/de-lat1-nd.map.gz
#ln -sf ru1.map.gz $K/keymaps/i386/qwerty/russian.map.gz
#ln -sf sg-latin1-lk450.map.gz \
#  $K/keymaps/i386/qwertz/sg-l1-lk450.map.gz
# The next two links are for yast-language choise; should be obsolete
# with the next yast version (on 6.1)
#ln -sf lat1-16.psfu.gz $K/consolefonts/lat1u-16.psf.gz
#ln -sf lat2-16.psfu.gz $K/consolefonts/lat2u-16.psf.gz
#
# This is for stupid default font search
rm -f $K/consolefonts/default8x16.gz
ln -sf default8x16.psfu.gz $K/consolefonts/default8x16.gz
#
rm -f $K/keymaps/i386/qwerty/*~ $K/keymaps/i386/qwerty/*,v
#
# this is until the Cyr* font are not part of the package
rm -f $K/consolefonts/Cyr_a8x14.gz
ln -sf Cyr_a8x14.psfu.gz $K/consolefonts/Cyr_a8x14.gz
rm -f $K/consolefonts/Cyr_a8x16.gz
ln -sf Cyr_a8x16.psfu.gz $K/consolefonts/Cyr_a8x16.gz
rm -f $K/consolefonts/Cyr_a8x8.gz
ln -sf Cyr_a8x8.psfu.gz $K/consolefonts/Cyr_a8x8.gz
#
find $K -name \*.orig | xargs -r rm -vf
# add some missing maps to mac and remap french board
(
cd $K/keymaps/mac/all
pwd
#ln -s mac-fr-latin1.map.gz mac-fr_CH-latin1.map.gz
#ln -s mac-fr-latin1.map.gz mac-fr.map.gz
for i in \
	mac-es.map.gz \
	mac-it.map.gz \
	mac-pt-latin1.map.gz \
	mac-br-abnt2.map.gz \
	mac-gr.map.gz \
	mac-dk-latin1.map.gz \
	mac-no-latin1.map.gz \
	mac-fi-latin1.map.gz \
	mac-cz-us-qwertz.map.gz \
	mac-hu.map.gz \
	mac-Pl02.map.gz \
	mac-ru1.map.gz \
	mac-jp106.map.gz
do test -f $i || ln -sv mac-us.map.gz $i
done
)
FILLUP_DIR=%{buildroot}%{_fillupdir}
mkdir -p $FILLUP_DIR
install -m 644 sysconfig.console $FILLUP_DIR/sysconfig.console
install -m 644 sysconfig.keyboard $FILLUP_DIR/sysconfig.keyboard
%ifnarch %{ix86} x86_64
   rm -f %{buildroot}%{_mandir}/man8/resizecons.8*
%endif
%ifarch %{sparc} m68k
rm -f %{buildroot}%{_mandir}/man8/getkeycodes.8*
rm -f %{buildroot}%{_mandir}/man8/setkeycodes.8*
%endif
install -m 755 fbtest      %{buildroot}%{_sbindir}
%ifarch %{ix86} x86_64
install -d %{buildroot}%{_libexecdir}/%{name}
install -m 755 numlockbios %{buildroot}%{_libexecdir}/%{name}
%endif
%if %{defined _distconfdir}
rm -rf %{buildroot}%{_sysconfdir}/pam.d
install -d %{buildroot}%{_distconfdir}/pam.d
install -m 644 %{SOURCE4} %{buildroot}%{_distconfdir}/pam.d/vlock
%else
install -m 644 %{SOURCE4} %{buildroot}%{_sysconfdir}/pam.d/vlock
%endif
install -m 644 %{SOURCE12} %{buildroot}%{_mandir}/man8/
%if !0%{?usrmerged}
mkdir -p %{buildroot}/bin
mkdir -p %{buildroot}/sbin
ln -s %{_bindir}/chvt %{buildroot}/bin
ln -s %{_bindir}/clrunimap %{buildroot}/bin
ln -s %{_bindir}/deallocvt %{buildroot}/bin
ln -s %{_bindir}/dumpkeys %{buildroot}/bin
ln -s %{_bindir}/fgconsole %{buildroot}/bin
ln -s %{_bindir}/getunimap %{buildroot}/bin
ln -s %{_bindir}/kbd_mode %{buildroot}/bin
ln -s %{_bindir}/kbdinfo %{buildroot}/bin
ln -s %{_bindir}/kbdrate %{buildroot}/bin
ln -s %{_bindir}/loadkeys %{buildroot}/bin
ln -s %{_bindir}/loadunimap %{buildroot}/bin
ln -s %{_bindir}/mapscrn %{buildroot}/bin
ln -s %{_bindir}/openvt %{buildroot}/bin
ln -s %{_bindir}/outpsfheader %{buildroot}/bin
ln -s %{_bindir}/psfaddtable %{buildroot}/bin
ln -s %{_bindir}/psfgettable %{buildroot}/bin
ln -s %{_bindir}/psfstriptable %{buildroot}/bin
ln -s %{_bindir}/psfxtable %{buildroot}/bin
ln -s %{_bindir}/screendump %{buildroot}/bin
ln -s %{_bindir}/setfont %{buildroot}/bin
ln -s %{_bindir}/setleds %{buildroot}/bin
ln -s %{_bindir}/setlogcons %{buildroot}/bin
ln -s %{_bindir}/setmetamode %{buildroot}/bin
ln -s %{_bindir}/setpalette %{buildroot}/bin
ln -s %{_bindir}/setvesablank %{buildroot}/bin
ln -s %{_bindir}/setvtrgb %{buildroot}/bin
ln -s %{_bindir}/showconsolefont %{buildroot}/bin
ln -s %{_bindir}/showkey %{buildroot}/bin
ln -s %{_bindir}/spawn_console %{buildroot}/bin
ln -s %{_bindir}/spawn_login %{buildroot}/bin
ln -s %{_bindir}/unicode_start %{buildroot}/bin
ln -s %{_bindir}/unicode_stop %{buildroot}/bin
ln -s %{_sbindir}/fbtest %{buildroot}/sbin
%ifnarch %{sparc} m68k
ln -s %{_bindir}/getkeycodes %{buildroot}/bin
ln -s %{_bindir}/setkeycodes %{buildroot}/bin
%endif
%ifarch %{ix86} x86_64
ln -s %{_bindir}/resizecons %{buildroot}/bin
%endif
%endif

# Make sure Perl has a locale where uc/lc works for unicode codepoints
# see e.g. https://perldoc.perl.org/perldiag.html#Wide-character-(U%2b%25X)-in-%25s
export LC_ALL=C.utf-8
# Convert X keyboard layouts to console keymaps
mkdir -p %{buildroot}%{kbd}/keymaps/xkb
perl xml2lst.pl < %{_datadir}/X11/xkb/rules/base.xml > layouts-variants.lst
while read line; do
  XKBLAYOUT=`echo "$line" | cut -d " " -f 1`
  echo "$XKBLAYOUT" >> layouts-list.lst
  XKBVARIANT=`echo "$line" | cut -d " " -f 2`
  ckbcomp "$XKBLAYOUT" "$XKBVARIANT" > /tmp/"$XKBLAYOUT"-"$XKBVARIANT".map
  # skip converted layouts which cannot input ASCII (rh#1031848)
  grep -q "U+0041" /tmp/"$XKBLAYOUT"-"$XKBVARIANT".map && \
    gzip -cn9 /tmp/"$XKBLAYOUT"-"$XKBVARIANT".map > %{buildroot}%{kbd}/keymaps/xkb/"$XKBLAYOUT"-"$XKBVARIANT".map.gz
  rm /tmp/"$XKBLAYOUT"-"$XKBVARIANT".map
done < layouts-variants.lst

# Convert X keyboard layouts (plain, no variant)
cat layouts-list.lst | sort -u >> layouts-list-uniq.lst
while read line; do
  ckbcomp "$line" > /tmp/"$line".map
  grep -q "U+0041" /tmp/"$line".map && \
    gzip -cn9 /tmp/"$line".map > %{buildroot}%{kbd}/keymaps/xkb/"$line".map.gz
  rm /tmp/"$line".map
done < layouts-list-uniq.lst

# Rename the converted default fi (kotoistus) layout (rh#1117891)
mv %{buildroot}%{kbd}/keymaps/xkb/fi.map.gz %{buildroot}%{kbd}/keymaps/xkb/fi-kotoistus.map.gz

# Fix converted cz layout - add compose rules (rh#1181581)
gunzip %{buildroot}%{kbd}/keymaps/xkb/cz.map.gz
patch %{buildroot}%{kbd}/keymaps/xkb/cz.map < %{SOURCE15}
gzip -n9 %{buildroot}%{kbd}/keymaps/xkb/cz.map

# Generate entries for systemd's /usr/share/systemd/kbd-model-map
mkdir -p  %{buildroot}%{_datadir}/systemd
sh ./genmap4systemd.sh %{buildroot}%{kbd}/keymaps/xkb \
  > %{buildroot}%{_datadir}/systemd/kbd-model-map.xkb-generated

install -m0755 kbdsettings %{buildroot}%{_sbindir}/
install -d %{buildroot}%{_prefix}/lib/systemd/system
install -m0644 kbdsettings.service %{buildroot}%{_prefix}/lib/systemd/system

%fdupes -s %{buildroot}%{_datadir}

%find_lang %{name}

%pre
%{service_add_pre kbdsettings.service}
# move outdated pam.d/*.rpmsave files away
test -f /etc/pam.d/vlock.rpmsave && mv -v /etc/pam.d/vlock.rpmsave /etc/pam.d/vlock.rpmsave.old ||:

%post
%{fillup_only -n console}
%{fillup_only -n keyboard}
# Variables deleted before Leap 15 and SLE 15
%{remove_and_set -n keyboard KEYTABLE COMPOSETABLE}
%ifnarch %{ix86} x86_64
# "bios" was accepted but ingnored on non-x86 platforms up to Leap 42.* and SLE 12.*
sed -i 's/^KBD_NUMLOCK="bios"/KBD_NUMLOCK="no"/' /etc/sysconfig/keyboard
%endif
%{service_add_post kbdsettings.service}
%{?regenerate_initrd_post}

%preun
%{service_del_preun kbdsettings.service}

%postun
%{service_del_postun kbdsettings.service}
%{?regenerate_initrd_post}

%posttrans
%{?regenerate_initrd_posttrans}
# Migration to /usr/etc.
test -f /etc/pam.d/vlock.rpmsave && mv -v /etc/pam.d/vlock.rpmsave /etc/pam.d/vlock ||:

%files -f %{name}.lang
#config(noreplace) /etc/sysconfig/console
%license LICENSE
%doc %{_defaultdocdir}/kbd
#doc CHANGES README CREDITS
%{_fillupdir}/sysconfig.console
%{_fillupdir}/sysconfig.keyboard
%{kbd}
%exclude %{kbd}/keymaps/{%{legacy_folders}}
%if !0%{?usrmerged}
/sbin/fbtest
/bin/chvt
/bin/openvt
/bin/deallocvt
/bin/dumpkeys
%ifnarch %{sparc} m68k
/bin/getkeycodes
/bin/setkeycodes
%endif
/bin/fgconsole
/bin/kbd_mode
/bin/kbdinfo
/bin/loadkeys
/bin/loadunimap
/bin/mapscrn
/bin/psfaddtable
/bin/psfgettable
/bin/psfstriptable
/bin/psfxtable
%ifarch %{ix86} x86_64
/bin/resizecons
%endif
/bin/setfont
/bin/setleds
/bin/setmetamode
/bin/setvtrgb
/bin/showconsolefont
/bin/showkey
/bin/unicode_start
/bin/unicode_stop
/bin/kbdrate
/bin/clrunimap
/bin/getunimap
/bin/outpsfheader
/bin/screendump
/bin/setlogcons
/bin/setpalette
/bin/setvesablank
/bin/spawn_console
/bin/spawn_login
%endif
%{_sbindir}/fbtest
%{_bindir}/chvt
%{_bindir}/openvt
%{_bindir}/deallocvt
%{_bindir}/dumpkeys
%ifnarch %{sparc} m68k
%{_bindir}/getkeycodes
%{_bindir}/setkeycodes
%endif
%{_bindir}/fgconsole
%{_bindir}/kbd_mode
%{_bindir}/kbdinfo
%{_bindir}/loadkeys
%{_bindir}/loadunimap
%{_bindir}/mapscrn
%{_bindir}/psfaddtable
%{_bindir}/psfgettable
%{_bindir}/psfstriptable
%{_bindir}/psfxtable
%ifarch %{ix86} x86_64
%{_bindir}/resizecons
%endif
%{_bindir}/setfont
%{_bindir}/setleds
%{_bindir}/setmetamode
%{_bindir}/setvtrgb
%{_bindir}/showconsolefont
%{_bindir}/showkey
%{_bindir}/unicode_start
%{_bindir}/unicode_stop
%{_bindir}/kbdrate
%{_bindir}/clrunimap
%{_bindir}/getunimap
%{_bindir}/outpsfheader
%{_bindir}/screendump
%{_bindir}/setlogcons
%{_bindir}/setpalette
%{_bindir}/setvesablank
%{_bindir}/spawn_console
%{_bindir}/spawn_login
%{_bindir}/vlock
%ifarch %{ix86} x86_64
%dir %{_libexecdir}/%{name}
%{_libexecdir}/%{name}/numlockbios
%endif
%{_mandir}/man1/*
%{_mandir}/man5/keymaps.5%{ext_man}
%ifnarch %{sparc} m68k
%{_mandir}/man8/getkeycodes.8%{ext_man}
%{_mandir}/man8/setkeycodes.8%{ext_man}
%endif
%{_mandir}/man8/showconsolefont.8%{ext_man}
%{_mandir}/man8/loadunimap.8%{ext_man}
%{_mandir}/man8/mapscrn.8%{ext_man}
%ifarch %{ix86} x86_64
%{_mandir}/man8/resizecons.8%{ext_man}
%endif
%{_mandir}/man8/setfont.8%{ext_man}
%{_mandir}/man8/fbtest.8%{ext_man}
%{_mandir}/man8/kbdrate.8%{ext_man}
%{_mandir}/man8/clrunimap.8%{ext_man}
%{_mandir}/man8/getunimap.8%{ext_man}
%{_mandir}/man8/mk_modmap.8%{ext_man}
%{_mandir}/man8/setlogcons.8%{ext_man}
%{_mandir}/man8/setvesablank.8%{ext_man}
%{_mandir}/man8/setvtrgb.8%{ext_man}
%{_mandir}/man8/vcstime.8%{ext_man}
%if %{defined _distconfdir}
%{_distconfdir}/pam.d/vlock
%else
%config(noreplace) %{_sysconfdir}/pam.d/vlock
%endif
%dir %{_datadir}/systemd
%{_prefix}/lib/systemd/system/kbdsettings.service
%{_datadir}/systemd/kbd-model-map.xkb-generated
%{_sbindir}/kbdsettings

%files legacy
%{kbd}/keymaps/{%{legacy_folders}}

%changelog
* Sun Apr 20 2025 sbrabec@suse.com
- Don't search for resources in the current directory. It can cause
  unwanted side effects or even infinite loop (bsc#1237230,
  kbd-ignore-working-directory-1.patch,
  kbd-ignore-working-directory-2.patch,
  kbd-ignore-working-directory-3.patch).
* Thu Apr 27 2023 fbui@suse.com
- Add 'ara' vc keymap (bsc#1210702)
  'ara' is slightly better than 'arabic' as it matches the name of its x11
  layout counterpart. Keep 'arabic' for backward compatibility sake.
* Mon Feb 21 2022 fvogt@suse.com
- Fix build without %%_distconfdir (see bsc#1195679)
* Mon Jan 17 2022 fvogt@suse.com
- Add patch to fix random doubling of font sizes (bsc#1194698):
  * 0001-libkfont-Initialize-kfont_context-options.patch
* Fri Jul 23 2021 kukuk@suse.com
- Only run kbdsettings.service if /etc/sysconfig/keyboard exists.
  Necessary for image based installations without admin made changes.
* Wed Jun  2 2021 christophe@krop.fr
- Update the installed license file.
  COPYING is a symlink to LICENSE. Let's use this file directly.
* Fri Dec 18 2020 jslaby@suse.cz
- Update to version 2.4.0:
  * po: Update cs and sr translations (from translationproject.org)
  * libkfont: Use only KDFONTOP
  * Added support for a few derivatives of neo
  * Fix use-after-free of pipe_cmd
  * Update solar24x32 font
  * vlock's pam config added to destination directory
  * Update sun12x22.psfu
  * libkeymap: unify non/unicode accent_table generation
  * libkeymap: note about --unicode use
  * libkeymap: remove last ushort
  * fi.map: use newly added deadkeys
  * Do not install internal library
  * Additional deadkeys
- Remove kbd-1.15.2-setfont-no-cruft.patch
  The old ioctls were finally dropped.
* Fri Oct 16 2020 lnussel@suse.de
- prepare usrmerge (boo#1029961)
* Fri Sep 25 2020 dimstar@opensuse.org
- Do not package libtswrap.so.0: it's only used by the test suite
  in a LD_PRELOAD fashion.
* Thu Sep 24 2020 sbrabec@suse.com
- Update to version 2.3.0:
  * Added libkfont library (internal yet).
  * Added Canadian Multilingual Standard keyboard map.
  * Added us1 that maps Right Alt to AltGr and Shift+Tab to
    Alt+Tab.
  * The dead_macron is used instead of macron in fi.map.
  * Added retries when switching to the console (chvt, openvt).
  * Added option -d to double size of font (setfont).
  * Added long options, help messages.
  * Added solar24x32 font.
  * Updated eurlatgr font.
  * Fixed problems with formatting man pages.
  * Fixed search path error (boo#1176854).
- Refresh partially upstreamed kbd-1.15.2-dumpkeys-C-opt.patch
- Drop upstreamed libkeymap-Fix-mk_mapname-for-the-plain-map.patch
- Refresh kbd-1.15.2-setfont-no-cruft.patch and
  kbd-1.15.5-loadkeys-search-path.patch
* Tue Sep 22 2020 guillaume.gardet@opensuse.org
- Refresh patch to fix build on non-x86 architecture broken
  by previous commit:
  * kbdsettings-nox86.patch
* Thu Sep 17 2020 sbrabec@suse.com
- Make kbdsettings working in both bash and dash (boo#1175040).
* Thu Sep 17 2020 sbrabec@suse.com
- Fix kbd-1.15.5-loadkeys-search-path.patch to prefer xkb keymaps
  (boo#1176302).
* Thu Aug 20 2020 jslaby@suse.com
- add libkeymap-Fix-mk_mapname-for-the-plain-map.patch
* Tue Apr 21 2020 lnussel@suse.de
- drop broken kbd command as well as guess_encoding (boo#1170067)
- don't use subdirectory for legacy keymaps (boo#1166423)
- use fdupes
* Tue Mar  3 2020 sbrabec@suse.com
- Update to version 2.2.0:
  * setfont: Add option -d to double size of font.
  * kbd_mode: Add -f option and deny dangerous mode switches
    without it.
  * Data files updates.
  * Fix gcc warnings and error with gcc-10 (boo#1160273).
  * Other fixes.
  * For a full list of changes see:
    https://git.kernel.org/pub/scm/linux/kernel/git/legion/kbd.git/log/
- Update home page.
- Refresh patches: kbd-1.15.2-dumpkeys-C-opt.patch,
  kbd-1.15.2-setfont-no-cruft.patch,
  kbd-1.15.5-loadkeys-search-path.patch.
* Thu Jan  9 2020 stefan.bruens@rwth-aachen.de
- Use a UTF-8 capable locale, otherwise ckbcomp will not not able
  to do proper uppercase/lowercase conversions.
- Rebase cz-map.patch after UTF-8 changes.
- Skip compression/decompression of maps which are about to be
  discarded later (~30%%). Avoid zgrep, which is a shell script
  spawning grep and gunzip for each input file.
* Thu Dec  5 2019 kukuk@suse.de
- Move pam.d/vlock to /usr/etc
* Thu Sep 19 2019 mvidner@suse.com
- Allow YaST to select Iranian (Persian, Farsi) keyboard layout
  (bsc#1092920)
* Thu Aug  2 2018 schwab@suse.de
- fbtest.c: include <sys/sysmacros.h> for major/minor
* Thu May 24 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Thu Apr  5 2018 sbrabec@suse.com
- Disable characters >=U+F000. These do not work properly
  (bsc#1085432#c15, kbd-unicode-fxxx.patch).
* Thu Mar 15 2018 sbrabec@suse.com
- Do not cause error on UNICODE characters >= 0xF000 (e. g.
  ligature fi) (bsc#1085432, kbd-unicode-fxxx.patch).
* Fri Jan 12 2018 sbrabec@suse.com
- Move initial NumLock handling from systemd back to kbd:
  * Add kbdsettings service written by Thomas Blume (boo#1010880,
    kbdsettings, kbdsettings.service, numlockbios.c,
    update sysconfig.console and sysconfig.keyboard).
  * Exclude numlockbios support for non x86 platforms
    (kbdsettings-nox86.patch).
- Drop references to KEYTABLE and COMPOSETABLE (boo#1010880#c32,
  boo#1010880#c54,  sysconfig.keyboard.del, README.SUSE,
  drop kbd.fillup).
- Fix paths in kbd.pl.
* Wed Dec  6 2017 fbui@suse.com
- Drop from some fill-up templates, a couple of sysconfig variables no
  more read by systemd (fate#319454)
  So the relevant settings can be defined in only one place.
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Fri Oct 13 2017 sbrabec@suse.com
- Add vlock.pamd PAM file (bsc#1056449#c8).
- Clean spec file.
* Fri Sep 22 2017 sbrabec@suse.com
- Version update to 2.0.4:
  * translation updates
  * support for U+202F
  * minor fixes and code cleanup
  * minor improvements and more characters support
- Enable vlock (bsc#1056449, FATE#261).
* Sun Apr 30 2017 bwiedemann@suse.com
- call gzip -n to make build fully reproducible
* Thu Mar 23 2017 zaitor@opensuse.org
- Revert dropping of kdb-legacy Requires: There are still packages
  and installation flows that needs this to be present
  (boo#1027379).
* Sun Feb 12 2017 zaitor@opensuse.org
- Drop kdb-legacy Requires: No longer needed, and was always meant
  to be temporary.
* Tue Jul 12 2016 tchvatal@suse.com
- Version update to 2.0.3:
  * Various small updates
- Obsolete merged patch:
  * kbd-1.15.5-br-abnt2-slash-question.patch
- Quickly run over with spec-cleaner
- Remove arch check for alpha and other unused platforms
- Drop kbd.fillup.nonpc as it should not be needed nowdays
* Wed Jun 15 2016 marceloatie@gmail.com
- Fix data/keymaps/i386/querty/br-abnt2.map
  (boo#984958, kbd-1.15.5-br-abnt2-slash-question.patch)
* Thu Dec 10 2015 tiwai@suse.de
- Fix missing dependency on coreutils for initrd macros (boo#958562)
- Call missing initrd macro at postun (boo#958562)
* Fri Aug 21 2015 opensuse.lietuviu.kalba@gmail.com
- Rename conflicting legacy keymaps:
  * dvorak/no.map -> dvorak/no-dvorak.map
  * fgGIod/trf.map -> fgGIod/trf-fgGIod.map
  * olpc/pt.map -> olpc/pt-olpc.map
  * qwerty/cz.map -> qwerty/cz-qwerty.map
- i386/qwerty/sr-latin links to sr-cy
- add compose rules to cz layout (rh#1181581)
* Mon Aug 10 2015 sndirsch@suse.com
- genmap4systemd.sh: use 'abnt2' model for 'br' layouts, 'jp106'
  model for 'jp' layouts and 'microsoftpro' for anything else
  (instead of 'pc105' before) (FATE#318426)
* Tue Jul 21 2015 sndirsch@suse.com
- added genmap4systemd.sh tool, which generates entries for
  systemd's /usr/share/systemd/kbd-model-map table from
  xkeyboard-config converted keymaps; entries are written to
  /usr/share/systemd/kbd-model-map.xkb-generated, so these can
  easily be added to /usr/share/systemd/kbd-model-map by systemd
  package (FATE#318426)
* Fri Jul 17 2015 sndirsch@suse.com
- Include xkb layouts from xkeyboard-config converted to console
  keymaps, (FATE#318426)
  * Rename Finnish xkb converted layout
  * Add xkb and legacy keymaps subdirs to loadkyes search path
    (kbd-1.15.5-loadkeys-search-path.patch), remove symlinks,
    Don't convert layouts that can't input ASCII,
  * Original keymaps moved to legacy dir, created symlinks to xkb
    keymaps
* Thu Apr  2 2015 crrodriguez@opensuse.org
- For the previos change to wok, we need to buildrequire
  suse-module-tools to get the initrd rpm macros.
* Sat Mar 28 2015 crrodriguez@opensuse.org
- Regenerate the initrd if this package changes as it is
  included there for early console setup.
* Tue Feb 10 2015 tchvatal@suse.com
- Convert changelog to utf8
* Sat Nov 29 2014 ledest@gmail.com
- fix bashisms in scripts
- add patches:
  * kbd-2.0.2-fix-bashisms.patch
- update patches:
  * kbd-1.15.2-unicode_scripts.patch
* Thu Sep 25 2014 pgajdos@suse.com
- euro{,1,2}.map now produces correct unicode for Euro sign
  [bnc#360993]
- added patches:
  * kbd-2.0.2-euro-unicode.patch
* Thu Sep 18 2014 pgajdos@suse.com
- port dumpkeys-C-opt.patch
- modified patches:
  * kbd-1.15.2-dumpkeys-C-opt.patch
* Fri Sep 12 2014 pgajdos@suse.com
- kbd-2.0.2-doshell-reference.patch:
  drop doshell reference from openvt.1 man page [bnc#675317]
* Thu Sep  4 2014 jw@owncloud.com
- added /usr/bin/kbd, a simple userfriedly keymap switcher.
  From https://github.com/jnweiger/kbd-wrapper
* Fri Aug 22 2014 pgajdos@suse.com
- drop kbd-1.15.2-chvt-userwait.patch [bnc#830805] (internal)
  (--userwait seems to not be used anywhere)
* Fri Aug 22 2014 pgajdos@suse.com
- remove testutf8 stub (2009: testutf8 will be soon removed completely,
  it's kept only not to break /etc/profile currently)
* Fri Aug 22 2014 pgajdos@suse.com
- Update to version 2.0.2:
    libkeymap: fix kmap on big-endian machines
    Add functions to get the total number of elements
    Add functions to convert ksyms
    eurlatgr - new Linux console font
    Hide syms array
    Add information about the total number of elements
    Add function to obtain items from the diacritical table
    Change the API for working with the diacritical table
    Change API for working with list of functions
    Add functions to check diacr/func existance
    Add pancyrillic font
    po: Update translations (from translationproject.org)
    vlock: implement PAM account and password management
    vlock: rename ERROR_TIMEOUT macro to LONG_DELAY
    vlock: introduce short delays after non-fatal PAM errors
    Added Latvian keymap
  (changelog taken from
  http://lists.altlinux.org/pipermail/kbd/2014-July/000476.html)
- add kbd-2.0.2-comment-typo-qwerty.patch [bnc#825385]
* Wed Aug 20 2014 pgajdos@suse.com
- SuSE -> SUSE [bnc#889035]
* Thu Jul 24 2014 dimstar@opensuse.org
- No longer recommend fbset: the package does no longer exist in
  openSUSE since late 2013.
* Sun Nov  3 2013 dap.darkness@gmail.com
- Update to version 2.0.1:
  * Disable arch-specific tests.
  * Fix regression in processing alt_is_meta keyword.
  * Rename Bepo keymaps:
    dvorak-fr-bepo.map -> fr-bepo-latin9.map
    dvorak-fr-bepo-utf8.map -> fr-bepo.map.
- Deleted kbd-1.15.2-dumpkeys-ppc.patch as obsolete:
  http://lists.opensuse.org/opensuse-factory/2013-08/msg00347.html
- gcc 4.6+ became required to prevent compilling error:
  "expected declaration specifiers or '...' before 'va_list'".
* Mon Aug 19 2013 dap.darkness@gmail.com
- Update to version 2.0.0:
  * Add bepo keyboard layout;
  * Add libkeymap;
  * The loadkeys and dumpkeys always use the libkeymap.
- Updated patches because of docs moved:
  * kbd-1.15.2-chvt-userwait.patch
  * kbd-1.15.2-docu-X11R6-xorg.patch
- Disabled patches because of dumpkeys rewritten:
  * kbd-1.15.2-dumpkeys-C-opt.patch
  * kbd-1.15.2-dumpkeys-ppc.patch
* Thu Apr  4 2013 meissner@suse.com
- disable vlock build, which is in vlock package.
* Thu Apr  4 2013 crrodriguez@opensuse.org
- Remove sysvinit support, init scripts from this package
  are masked by systemd and only serve for confusion.
* Wed Apr  3 2013 sbrabec@suse.cz
- sysconfig.keyboard: Updated description of KBD_NUMLOCK
  (bnc#746595#c74).
* Wed Dec  5 2012 dap.darkness@gmail.com
- Update to version 1.15.5:
  * Fix msgstr in es.po and update translations.
  * Update changelog and increase version (1.15.5wip).
  * po: Update vi.po from translationproject.org.
  * Fix various vlock build errors.
  * Fix loadkeys.analyze lex handling.
  * Ignore config.cache files.
- Applied into upstream kbd-1.15.3-po-es.patch was deleted.
* Mon Dec  3 2012 dap.darkness@gmail.com
- Update to version 1.15.4:
  * vlock: New utility which locks one or more virtual consoles.
  * loadkeys: Change the handling of -C option.
  * loadkeys: Fix -d option.
  * Add dvorak-es keymap.
  * Add dvorak-uk keymap (Joe MacMahon).
  * Add dvorak-sv-a1 and dvorak-sv-a5 keymaps.
  * Add ruwin_alt_sh-UTF-8 keymap (Dmitriy Perlow).
- kbd-1.15.3-po-es.patch was fixed.
- Applied into upstream patches were deleted.
- Fixed up via spec-cleaner.
- Clean-section was removed.
- Macro warnings were fixed via '%%' deleting.
* Fri Apr 20 2012 rschweikert@suse.com
- Place binaries into /usr tree (UsrMerge project)
* Tue Dec 20 2011 sbrabec@suse.cz
- Enable resizecons on x86_64 (bnc#737631).
* Wed Nov 30 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Wed Oct  5 2011 lnussel@suse.de
- fix loadkeys -C option (bnc#720486)
* Fri Sep 30 2011 uli@suse.com
- cross-build fix: use %%__cc, %%configure macros
- configure: explicitly set bindir
* Wed Sep 14 2011 sbrabec@suse.cz
- Update to version 1.15.3:
  * kbdinfo: New utility to obtain information about console.
  * setvtrgb: New utility to set the virtual terminal RGB colors.
  * loadkeys: Add LOADKEYS_KEYMAP_PATH env variable.
  * loadkeys: Fix some memory leaks.
  * loadkeys: Do not set prefer_unicode for iso-8859-1.
  * loadkeys -a: Switch to ASCII mode.
  * loadkeys: Fix "compose as usual" for Unicode diacritics.
  * Add dvorak-ru keymap.
  * Add LatGrkCyr fonts.
* Mon Mar 21 2011 werner@suse.de
- If /usr is located in a separate partition, the locale command fails.
- Ignore /var/run/keymap in sinlge user mode otherwise key mapping
  could be wrong if booted cold into sinlge user mode
* Thu Feb 17 2011 werner@suse.de
- Tag boot script as interactive as systemd uses it
* Wed Jan 12 2011 lnussel@suse.de
- use /etc/defkeymap.name if possible to avoid find call
- move some code that is only needed for start to actual start section
  (bnc#463801)
- Fixed symlink vulnerability of the init script
  (bnc#663898, CVE-2011-0460).
* Tue Sep  7 2010 anicka@suse.cz
- build optional binaries (bnc#637453)
* Mon Sep  6 2010 anicka@suse.cz
- update to 1.15.2
  * Use automake to build translations.
  * loadkeys -u: Switch to Unicode mode, if necessary
  * Never handle plain ASCII characters as Unicode
  * Enable UNUMBERs in compose definitions
  * Use automake.
  * Add --enable-strip configure option.
  * unicode_start: Without any arguments utility will only set
    unicode mode.
  * Add qwerty/cz.map keymap.
- remove upstreamed and obsolete patches (-remove-kbio, -Makefile,
  - 2d01989f, -no-strip)
- retain original behavior of unicode_start script
- remove manpages for programs that are not installed
* Thu May 27 2010 sndirsch@suse.de
- added dummy keyboard mappings for chinese/taiwanese (bnc #603950)
* Mon Mar 29 2010 anicka@suse.cz
- add lt.std map (bnc#569554)
* Fri Feb 19 2010 anicka@suse.cz
- respect KBD_TTY="" set in sysconfig (bnc#405658)
* Tue Feb 16 2010 vuntz@opensuse.org
- Add kbd-1.12-chvt-userwait.patch, taken from Gentoo to add a
  - -userwait option to chvt. This can be used to avoid situation
  where chvt can hang forever waiting for the vt switch: the wait
  is done in userspace, and has a timeout of 5 seconds. (bnc#575123)
* Thu Feb  4 2010 jengelh@medozas.de
- remove inclusion of kbio.h on SPARC, this has been removed
  in the kernel
* Sun Jan 10 2010 jw@novell.com
- added guess_encoding, an old script of mine, that tests
  if a tty is in utf8 mode or not.
  (Also helpful with text files in unknown encoding.)
* Mon Nov  2 2009 mmarek@suse.cz
- do not include '.' in the repacked tarball (bnc#544975).
* Thu Oct  1 2009 mmarek@suse.cz
- Add real Tajik keymap.
- remove slovak keymaps from suse-add.tar.bz2 that are already
  upstream.
* Fri Sep  4 2009 mmarek@suse.cz
- added symlink tj.map.gz -> ruwin_alt-UTF-8.map.gz until there is
  a real Tajik map.
* Tue May 19 2009 mmarek@suse.cz
- remove testutf8 (replace with a script that returns 2 in any
  terminal), it's a hack that has a number of problems (bnc#436378,
  bnc#334889). Users who don't want utf8 should adjust their locale
  setting accordingly.
* Tue May 19 2009 mmarek@suse.cz
- do not load any usb drivers, udev takes care of this (bnc#482316).
* Mon Nov 10 2008 mmarek@suse.cz
- rename Spanish keymap for olpc to es-olpc to avoid ambiguity
  (bnc#435121)
* Tue Nov  4 2008 sndirsch@suse.de
- added arabic console keyboard link ( arabic -> us ) (bnc #441432)
* Tue Oct 14 2008 mmarek@suse.cz
- fix case when multiple keymaps are found (bnc#259694)
- allow to specify a path such as 'i386/es.map.gz' in KEYTABLE
* Mon Sep 29 2008 mmarek@suse.cz
- fixed lat2a-16.psfu (bnc#340579)
* Tue Sep  9 2008 mmarek@suse.cz
- really use $RPM_OPT_FLAGS
* Thu Sep  4 2008 mmarek@suse.cz
- modified rckbd according to suggestions by Jiri Bohac
  (bnc#367801#c17)
  - first call setfont and then loadkeys, to make dead characters
    work
  - don't call dumpkeys | loadkeys --unicode
* Wed Aug 20 2008 mmarek@suse.cz
- updated to 1.14.1
  * Programs
  - unicode_{start,stop}: To run loadkeys is allowed only to
    root.
  - mapscrn: Add '.acm' suffix for compatibility with
    console-tools
  - fix findfile so that it does not find directories
  - kbdrate: fix for sparc
  * Keymaps:
  - Add Norwegian dvorak keymap.
  - Add turkish F (trf) keyboard map.
  - Fix turkish Q (trq) keyboard map (Ozgur Murat Homurlu).
  - Move qwerty/cz.map -> qwertz/cz.map.
  - include/*euro.map: Change 'currency' to 'euro' symbol.
  - Add OLPC (One Laptop Per Child) keymaps
  - Add more romanian keymaps (Vitezslav Crhonek)
  - Add another ukrainian keymap
  - Add Belarusian (Belarus) keymaps
  - Add Kazakh keymap
  - Add Kyrgyz keymap
  - Add Bashkir (Russia) keymap
  - Add Tatar keymaps
  - Add more russian keymaps
  * Fonts:
  - Add unicode fonts (UniCyrExt_8x16.psf, UniCyr_8x14.psf,
    UniCyr_8x16.psf, UniCyr_8x8.psf)
  - Add Lat2-Terminus16 font
  - Fix sun12x22 font unicode mapping table (Vitezslav Crhonek)
  * translation updates
- dropped upstreamed patches:
  kbd-1.12-Meta-Tab.diff
  kbd-1.12-be-nice-to-kdm.diff
  kbd-1.12-cz-us-qwertz.diff
  kbd-1.12-dumpkeys-full.diff
  kbd-1.12-handle-small-table.diff
  kbd-1.12-happy-abuild.diff
  kbd-1.12-kbd_mode.diff
  kbd-1.12-loadkeys-C-opt.diff
  kbd-1.12-loadkeys-repstdout.diff
  kbd-1.12-mac-de.diff
  kbd-1.12-mac-dk.diff
  kbd-1.12-nohang-kbdrate2.diff
  kbd-1.12-nounicode-nontty.diff
  kbd-1.12-setfont-fpclose.diff
  kbd-1.12-showconsolefont-info.diff
  kbd-1.12-swiss.diff
  kbd-1.12.diff
  piofont_debug.diff
- dropped bnc147581_jp106.diff because it was not needed
  (bnc#147581)
* Mon Aug 18 2008 mrueckert@suse.de
- remove outdated options in the fillup_and_insserv call
* Mon Aug 18 2008 werner@suse.de
- Fix LSB header of kbd init script
* Wed Jun  4 2008 werner@suse.de
- Add "-C" option also to dumpkeys to make kbd init script work on
  /dev/console and /dev/tty even within e.g. xterm (bnc#337238)
* Mon May 19 2008 jw@suse.de
- added ru1_win-utf.map fixing bnc#337238
* Wed May  7 2008 werner@suse.de
- Add description of option -i of showconsolefont (bnc#385200)
- Make showconsolefont option -i work together with option -C
- Add fbtest program and fbtest manual page
* Mon May  5 2008 jw@suse.de
- added fix for bnc#164378 from werner.
* Fri Apr 25 2008 jw@suse.de
- experimental patch for bnc#147581 added.
* Fri Mar 21 2008 sndirsch@suse.de
- kbd.init: MAY_TTY should be tty6 (Bug #302010)
* Thu Feb 21 2008 crrodriguez@suse.de
- use find_lang macro
* Mon Dec  3 2007 jw@suse.de
- fixed bugzilla #153179 by adding new versions of sk-qwertz.map
  and sk-qwerty.map from lmichnovic to suse-add.tar.bz2
- Thus partially obsoleting kbd-1.12-prtscr_no_sigquit.diff and
  kbd-1.12-Meta-Tab.diff
* Tue Aug 21 2007 jw@suse.de
- cleaned up setfont according to bugzilla #302010
* Thu Aug 16 2007 jw@suse.de
- fixed fix of bugzilla #300076
  (fillup_and_insserv is too ugly)
* Tue Aug 14 2007 jw@suse.de
- fixed /etc/sysconfig/keyboard, bugzilla #300076
* Tue Jul 17 2007 jw@suse.de
- fixed sv-latin1.map, bugzilla #280988
* Thu Jun 21 2007 dmueller@suse.de
- update 'el' localisation
* Mon Jun 18 2007 jw@suse.de
- sleep 3 removed. bugzilla #284348
* Sat Jun 16 2007 coolo@suse.de
- as discussed with jw and werner kbd does not need to run before
  xdm
* Fri May 11 2007 olh@suse.de
- do not run setfont on ps3 because it permanently blanks the screen
* Thu Mar 29 2007 coolo@suse.de
- BuildRequire flex and bison
* Wed Feb  7 2007 ro@suse.de
- do not build as root
* Mon Oct 23 2006 olh@suse.de
- update mac-de []|{} mapping to match the X11 and MacOS mapping
* Fri Aug 11 2006 jw@suse.de
- mention both /usr/share/X11 and /usr/X11R6/lib/X11 in docu.
* Wed Jul 26 2006 jw@suse.de
- added showconsolefont-info.diff,
  partial fix for #164378
* Wed Jun 21 2006 jw@suse.de
- added some pclose(), fixing (#88501)
* Tue Jun  6 2006 jw@suse.de
- $MAGIC should have been $CONSOLE_MAGIC (#181612)
* Wed May 31 2006 jw@suse.de
- added consolefonts/cp850-full-* (#179528)
  derived from cp850 via setfont; loadunimap cp850; setfont -O
* Tue Apr 25 2006 jw@suse.de
- added keymaps/i386/qwerty/cn-latin1.map (#158951)
* Sun Apr  2 2006 olh@suse.de
- make Alt/Option key and Command/Apple key consistent with X11
  in the mac-* keymaps: flip them
* Mon Mar 20 2006 ms@suse.de
- added korean console keyboard link ( korean -> us ) (#87443)
* Tue Feb  7 2006 ms@suse.de
- added khmer console keyboard link ( khmer -> us )
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Fri Jan 13 2006 schwab@suse.de
- Don't strip binaries.
* Sun Oct  2 2005 schwab@suse.de
- Remove useless distinction between different machines when finding the
  keymap.
* Mon Aug 15 2005 jw@suse.de
- mac: fixed support for pc style keymaps
  bugzilla#98363
* Thu Aug  4 2005 jw@suse.de
- sourcing /etc/profile.d/lang.sh for new dynamic language config
* Tue Jul 12 2005 jw@suse.de
- removed Agafari fonts from source tar ball.
  bugzilla#95915
* Thu Jul  7 2005 jw@suse.de
- revamped uninitialized.diff into happy-abuild.diff
  added declarations, added RPM_OPT_FLAGS where it was still missing.
* Mon May 23 2005 jw@suse.de
- removing noncommercial Agafari fonts during install.
* Tue May 17 2005 jw@suse.de
- used uninitialized fixed.
* Fri May 13 2005 jw@suse.de
- convert-kbd-mac.sed: changed 58 from 100 to 125, to enable altgr
  thanks to olh.
* Thu Mar 31 2005 jw@suse.de
- avoid probing of all /dev/$tty on *iseries*, as it causes
  - ENODEV errors. #74394
* Mon Mar 14 2005 jw@suse.de
- new init script logic: earlykbd + kbd should now behave
  as werner designed it (using /var/run/keymap as lock).
  Fixes #65246, #71722, #72409 and possibly #65970
* Tue Mar  8 2005 jw@suse.de
- magic printing second try.
  Better diagnostics to tackle #65246
* Fri Mar  4 2005 jw@suse.de
- less obstrusive magic printing from kbd.init [fixes #65119]
- loadkeys, setfont: neither annoy X-Servers nor print
  bogus error messages [fixes #63713, and possibly #65246]
* Tue Dec 14 2004 coolo@suse.de
- adding an early boot script to load the cache created by last
  boot.
* Mon Oct 25 2004 jw@suse.de
- new cz-lat2-us.map added, fixing #46829
* Thu Sep 30 2004 jw@suse.de
- #45972 fixed: missing usbhid module added.
- #46113 workaround: wrong write to /proc/sys/kernel/hotplug removed.
- debug printf for unreproducable PIO_FONT error added.
* Wed Sep  8 2004 werner@suse.de
- Faster boot: skip setleds if nothing is switched on and skip
  not needed virtual consoles
* Mon Sep  6 2004 werner@suse.de
- More speed for the boot script by checking the vt's only once
* Wed Mar 31 2004 jw@suse.de
- Bugzilla #37619: force-reload was missing in kbd.init
* Tue Mar 30 2004 mfabian@suse.de, werner@suse.de
- Bugzilla #37367: add option "-C device" to kbd_mode and
  change /etc/init.d/kbd script to be able to set the mode for
  all console. Previously it worked only on the first console
  (/dev/tty1).
* Tue Mar 30 2004 jw@suse.de
- iso09.f16n.psf from toganm@dinamizm.com added.
  That fixes bugzilla #37247
* Wed Mar  3 2004 ro@suse.de
- fix typo in kbd rcscript
* Fri Feb 27 2004 jw@suse.de
- upgrade to 1.12
  * updated getkeycodes, showkey for Linux 2.6 (fixing #33978)
  * maps updated: is-latin1.map, is-latin1-us.map, bg-cp1251.map,
    bg_bds-cp1251.map, bg_pho-cp1251.map, bg_bds-utf8.map,
    bg_pho-utf8.map, nl.map
  * renamed bg.map to bg-cp855.map
  * fonts: greek-polytonic.psfu
  * translations updated: pl.po, ro.po, cs.po, es.po, gr.po, es.po,
    nl.po, el.po, pl.po
  * new options: -C, openvt -e,
  * docu updates.
- fixed #33301, swedish map renamed
* Sat Nov  8 2003 olh@suse.de
- add convert-kbd-mac.sed to convert mac maps to 2.6 linuxkeycodes
  load usb drivers unconditionally in runlevel S
* Thu Oct 30 2003 schwab@suse.de
- /etc/init.d/kbd: usbdevfs has been renamed to usbfs, use /proc/bus/usb
  instead.
* Fri Oct 17 2003 kukuk@suse.de
- Really delete wrong manual pages
* Fri Oct 17 2003 kukuk@suse.de
- Fix filelist for SPARC
* Wed Oct  1 2003 garloff@suse.de
- #31927: kbdrate was not called due to wrong path. Fixed.
- unicode_start: Collapse to one setfont call (as in initscript).
* Fri Sep 19 2003 garloff@suse.de
- #31153: kbd_mode -a/-u is not good under X11. Skip unicode_start/
  stop dir non-tty devices.
- Collapse setfont calls for font, unimap and screenmap into one.
  Otherwise the font is overridden with default8x16 again.
* Tue Sep 16 2003 garloff@suse.de
- Fix bug #30097: When switching from cz-us-qwertz to us, y and
  z could be confused.
* Tue Sep 16 2003 garloff@suse.de
- Add compose table compose.utf8 that uses symbolic names and thus
  works regardless of encoding. Most useful for UTF-8.
- Fix bug #28481: We were writing the activation string to a read-
  only fd.
* Thu Sep 11 2003 mfabian@suse.de
- Bugzilla #30411: redirect "plus before udiaeresis ignored" and
  similar warnings of "loadkeys --unicode" in Unicode_start
  to /dev/null.
- Bugzilla #30496: don't write file to remember the keyboard
  map to /.kbd/.keymap_sv.
- add program "testutf8" by Gerd Knorr <kraxel@suse.de> to be able
  to check whether a terminal is in UTF-8 mode or not.
* Mon Sep  8 2003 mfabian@suse.de
- Bugzilla #28720: "kbd_mode", "setfont", and "fgconsole" have
  moved from /usr/bin/ -> /bin. Therefore, /etc/init.d/kbd
  stopped working correctly (I thought I had fixed #28720 before
  but because these binaries moved it broke again).
* Sun Sep  7 2003 mfabian@suse.de
- save the old keymap in "unicode_start" and reload it in
  "unicode_stop" because "dumpkeys | loadkeys --unicode" cannot
  be reverted.
* Tue Sep  2 2003 mmj@suse.de
- Add sysconfig metadata [#28855]
* Thu Jul 31 2003 kukuk@suse.de
- serial was renamed to setserial [Bug #28353]
* Thu Jul 31 2003 garloff@suse.de
- Fix dumpkeys fix [#28339].
* Thu Jul 31 2003 garloff@suse.de
- Fix various DESTDIR ... related Makefile headaches
- Port patches to 1.08, all binaries have been moved to /bin
- Tentative fix for dumpkeys, using the large NR_KEYS from 2.6
  kernel but running on 2.4 [#28339]
- Use RPM_OPT_FLAGS (with -Os appended)
* Wed Jul 30 2003 garloff@suse.de
- Update to kbd-1.08:
  * loadkeys: fix for bison 1.50
  * Makefile cleanups
  * Patch to not map PrtScr to Ctrl-\ (but only Ctrl-PrtScr) merged
  * fi-latin1/9.map changed
  * bg-cp1251.map, il-heb.map, sr-cy.map, fr-latin9.map
- Update to kbd-1.07:
  * showfont -> showconsolefont rename (clash with X)
  * loadkeys fixes: addfunc(), relative symlinks
  * getfd: Try devfs names as well
  * manpgae for fgconsole
  * cyr-sun16.psfu
  * swedish: rename to se-latin1.map to sv-latin1.map
  * cp1251_to_uni, koi8-r_to_uni, koi8-u_to_uni.trans
  * se-fi-* for Northern Sami
  * nl3.map -> nl.map
* Fri Jun  6 2003 mfabian@suse.de
- fix Bugzilla #27141: add the necessary commands to setup the
  Linux consoles for Unicode or non-Unicode respectively
  to /etc/init.d/kbd, similar to what is done in
  /usr/sbin/{unicode_start,unicode_stop}.
- remove installed but unpackaged file resizecons.8.gz
* Tue Mar 11 2003 garloff@suse.de
- Add sysconfig metadata to sysconfig/console as well [Bug #22625]
* Sat Mar  8 2003 kukuk@suse.de
- Don't reset the status, so that final result does not only
  report the status of the last command [Bug #19823]
* Thu Feb 20 2003 mmj@suse.de
- Add sysconfig metadata [#22625]
* Tue Feb 18 2003 kukuk@suse.de
- Don't set KBD_RATE and KBD_DELAY per default
* Sat Dec  7 2002 garloff@suse.de
- Add compose.latin1.cedilla which is a variant which maps accented
  c to cedilla. [Bug #21008]
- Use alarm(5) to limit waiting for (potentially non-existing) kbd
  controller instead of loop (with machine-dependent timeout).
  [Bug #22167]
* Fri Nov  8 2002 schwab@suse.de
- Fix mac-de-latin1 keymap.
- Fix misaligned columns in full table dump.
- Don't clobber keycode 0 where it is valid.
* Mon Oct  7 2002 garloff@suse.de
- Don't write "Loading <file>" to stdout when --mktable is used.
  [Bug #19952]
- Use larger timeout waiting for keyboard controller.
* Wed Sep 18 2002 fehr@suse.de
- add updated keymaps us-acentos.map and br-abnt2.map provided
  by miura@conectiva.com.br to suse-add.tar.bz2 (Bug #19791)
* Mon Aug 26 2002 sndirsch@suse.de
- remember NumLock BIOS state in /var/run/numlock-on; required
  later for $HOME/.xinitrc (Bug #18248)
* Sat Aug 24 2002 olh@suse.de
- do the symlinks really in mac/all
* Mon Aug 19 2002 garloff@suse.de
- Add %%insserv_prereq and %%fillup_prereq (bug #17892)
* Thu Aug 15 2002 olh@suse.de
- fix some keys with kbd-1.06-mac-dk.diff
  do the symlinks in mac/all instead of mac/
* Sun Aug  4 2002 olh@suse.de
- merge boot.setup into rckbd (#16476)
* Fri Jul 26 2002 garloff@suse.de
- Don't wait infinitely long for bit 1 of port 0x64 being 0.
  Blocker #17248.
- Make loadkeys report successful keytable load to stdout instead
  of stderr. Bug #17168.
* Wed Jul 24 2002 olh@suse.de
- do not run boot.setup on iSeries by accident, kbdrate is bad
* Fri Jul 19 2002 olh@suse.de
- kbdrate does only work on PC style hardware, hangs on USB and ADB
* Thu Jul 11 2002 garloff@suse.de
- Removed dangling link to www.claudio.ch (bug #16933)
* Fri Jul  5 2002 kukuk@suse.de
- Use %%ix86 macro
* Thu Jul  4 2002 uli@suse.de
- search for x86-64 keymaps in i386
* Mon Jun 17 2002 sndirsch@suse.de
- sysconfig.keyboard: set KBD_NUMLOCK to "bios" (Bug #16594)
* Fri Jun 14 2002 olh@suse.de
- no loadkezs, sane systems have <TAB>
* Fri Jun 14 2002 sndirsch@suse.de
- boot.setup: handle Numlock depending on BIOS setting
  if KBD_NUMLOCK is set to "bios"
- sysconfig.keyboard: added "bios" to KBD_NUMLOCK description
* Mon Jun 10 2002 garloff@suse.de
- Convert some missing maps.
* Fri Jun  7 2002 garloff@suse.de
- Convert Shift Tab to Meta_Tab. (#16512)
* Thu Jun  6 2002 garloff@suse.de
- Add KBD_DISABLE_CAPS_LOCK feature.
* Thu Jun  6 2002 garloff@suse.de
- Add kbd rate and delay report (#16050).
- Move fbset to X-SuSE-Should-Start.
* Sun Mar 17 2002 garloff@suse.de
- Fixed all i386 keymaps with 99(PtrScr) = Control_backslash
  to VoidSymbol (but keeping the old meaning with Control)
  Fixes bug #8380.
* Sun Mar 17 2002 garloff@suse.de
- Changed init script to accept a keymap that is specified by
  absolute path. (Bug #14997)
* Sun Mar 17 2002 garloff@suse.de
- Add some missing third (AltGr) functions to the number keys
  for fr_CH/de_CH-latin and sg-latin1. (Adresses bug #9368)
* Tue Mar 12 2002 olh@suse.de
- load usb keyboard in runlevel s and 1 (#14253)
* Mon Mar  4 2002 garloff@suse.de
- Add Rumanian keyboard layout (ro-latin2.map) donated by
  Manfred Pohler. (#13008)
* Fri Mar  1 2002 ro@suse.de
- force activation of boot.setup using "Y"
* Mon Feb 18 2002 ro@suse.de
- don't clobber return code with test
* Thu Feb 14 2002 garloff@suse.de
- Revert chvt change by default, as it causes too much flickering
  of the screen. It can be manually enabled though. (#12151)
* Tue Feb 12 2002 ro@suse.de
- added missing "fi" in boot.setup
* Tue Feb 12 2002 schwab@suse.de
- Fix uses of chvt in init script.
* Fri Feb  8 2002 ro@suse.de
- return (not implemented) for stop and (unknown) for status
  in boot.setup
* Fri Feb  8 2002 garloff@suse.de
- Split /etc/sysconfig/console into keyboard and console.
* Fri Feb  8 2002 garloff@suse.de
- Move keyboard data to /usr/share (it's not arch dependant)
- Try to make setting console fonts work with non-SuSE kernels
  by using chvt. (bug #12151)
* Fri Feb  8 2002 garloff@suse.de
- Remove duplicated data, rename conflicting
- Don't map PrtScr to Control_backslash (SIGQUIT) by default,
  Control PrtScr will still produce it. (bug #8380)
- Remove test for "none" ifr unicode and screenmaps ("none" can be
  different from not calling setfont)
- Handle empty KEYTABLE (fixes bug #12976)
- Clarified comments for the various CONSOLE settings
* Fri Feb  8 2002 garloff@suse.de
- kbd-1.06:
  * Lots of our patches got merged :-)
  * Fonts added
  * lat7u.uni -> iso07u.uni, added lat7.uni
  * Scancode docs removed, see
    http://www.win.tue.nl/~aeb/linux/kbd/scancodes.html
  * various minor corrections
* Wed Feb  6 2002 werner@suse.de
- Add KBD_SCRLOCK variable to make it possible to enable this
- Move setleds from /usr/bin to /sbin and set compatiblity symlink
  (mainly for infra red keyboards)
* Sat Jan 12 2002 garloff@suse.de
- Move COMPOSETASBLE to /etc/sysconfig/console, where all the other
  console and keyboard related settings are.
* Wed Jan  9 2002 ro@suse.de
- fixed typo in boot.setup
* Tue Jan  8 2002 ro@suse.de
- moved COMPOSETABLE to /etc/sysconfig/keyboard (#12736)
* Wed Dec 12 2001 ro@suse.de
- moved rc.config.d -> sysconfig
* Tue Dec 11 2001 schwab@suse.de
- Fix boot script for last change.
* Wed Dec  5 2001 ro@suse.de
- renamed rc.config.d.kbd to rc.config.d.console
- fixed bug for ppc
* Wed Dec  5 2001 ro@suse.de
- moved KBD related variables from aaa_base to here
- moved boot.setup from aaa_base to here
- use fillup_and_insserv macro
* Fri Nov 30 2001 olh@suse.de
- handle the ppc64 in machine detection
* Mon Sep 17 2001 garloff@suse.de
- Add loadkezs->loadkeys symlink (#10752)
* Fri Aug 31 2001 olh@suse.de
- no keyboard on iSeries available
* Wed Aug 29 2001 olh@suse.de
- allow querty/us.map.gz as KEYTABLE, fix mac-dk map
* Wed Aug  8 2001 olh@suse.de
- handle ppc64 in KBDLIB path as i386
* Mon Aug  6 2001 kukuk@suse.de
- Fix comment about init script location [Bug #9494]
* Sat Jul 21 2001 olh@suse.de
- update search path for mac keymaps
* Tue Jul 17 2001 garloff@suse.de
- changed return value of status to 3 if not running. Fixes
  bug #9052.
* Wed Jul 11 2001 bjacke@suse.de
- switch , to . on number block for {de,fr}_CH keymaps
* Sun Jun 17 2001 schwab@suse.de
- setfont: output activation string on selected console, not stdout.
* Fri May 11 2001 garloff@suse.de
- Remove compose combinations from compose.latin1.add that have
  been merged into the official compose.latin1.
* Fri May 11 2001 garloff@suse.de
- bzip2 sources.
* Fri May 11 2001 garloff@suse.de
- Apply fixes to kbd iint script from Werner Fink:
  * Dump keymap to /etc/defkeymap after the compose table has been
    loaded. Do it whenever it changed.
  * In runlevels N, S, 1, we might not have /usr available.
    Don't issue tons of "failed" messages but be happy with
    defkeymap.
* Tue May  8 2001 garloff@suse.de
- Remove redundant sun keymaps from suse-add.
- Especially remove sunkeymap which reintroduces a fixed bug to kbd
- Remove second .map from sunt4-no-latin1.map.map
* Tue May  8 2001 garloff@suse.de
- On request of Andries (aeb): Removed the Shift-Ctrl mapping
  of Compose but instead put it on Ctrl-.
- Added compose.ctrlperiod to achieve this.
* Sun May  6 2001 garloff@suse.de
- Remove double fontwidth assignment (cosmetical)
- Add fbset to init script prerequisites
* Wed May  2 2001 garloff@suse.de
- Fix bug #7474: (defkeymap)
  keycode 97 = Control Compose is wrong. Use shift keycode ...
- Make Shift-Ctrl and Ctrl-Shift behave the same
- bzip2 the suse_add sources instead of gzip
* Wed Apr 25 2001 garloff@suse.de
- Corrections to the file list:
  * Install fg_console
  * Install unicode_start/stop plus manpages
  * Don't install resizecons/manpage on non-i386 archs
* Tue Apr 24 2001 garloff@suse.de
- correct y <-> z in mac-de_CH has erroneously been removed from
  last patch. Corrected.
* Tue Apr 24 2001 garloff@suse.de
- Use KBD_TTY to determine which consoles need to be manipulated,
  not non-functional /dev/tty[1-24].
* Mon Apr 23 2001 garloff@suse.de
- Add some sun keymaps from console-data to suse_add. (#6109)
- Add original sun12x22.psfu and suse12x22 under its true name.
* Mon Apr 23 2001 garloff@suse.de
- Finalized merging with 1.05: SuSE patch shrinked from 116k to
  9k :-)
- fillup now defaults to clear the compose table in case one is
  loaded and gives some more examples.
- Set font on all consoles /dev/tty[1-24] (bugzilla #5812)
- install kbd_fonts before kbd, so the latter has the possibility
  to overwrite/update the fonts from the kbd_fonts pack
* Sun Apr 22 2001 bjacke@suse.de
- correct y <-> z in mac-de_CH
- add mac_dvorak keymap
- move de_CH from qwerty to qwertz
* Fri Apr 20 2001 garloff@suse.de
- Update to kbd-1.0.5 which incorporates the patches from olh and
  me.
* Thu Mar 15 2001 ro@suse.de
- create directory sbin in buildroot
* Sun Dec 17 2000 garloff@suse.de
- Fix lat5 fonts
- ShiftCtrl now leaves the Ctrl scancodes untouched and just
  changes the ShiftCtrl meaning to Compose.
* Wed Dec 13 2000 olh@suse.de
- use runlevel S and mount proc with -n
* Fri Dec  8 2000 schwab@suse.de
- Use extended compose table also on ia64.
- Fix typos.
* Thu Dec  7 2000 werner@suse.de
- Add begin and end mark of LSB header
- Move chvt, openvt, deallocvt to /bin and set link bak to /usr/bin
* Wed Dec  6 2000 garloff@suse.de
- Argh: loadkeys does not merge the compose table; just the key
  definitions. Make compose.latin1.add include compose.latin1 and
  update docu accordingly to account for this.
* Wed Dec  6 2000 garloff@suse.de
- Also include the mapping of the compose key in the COMPOSEMAP
  variable and offer winkeys and shiftctrl. Default on i386 and
  alpha.
- Update README.SuSE to document this.
- This together with the changes from Dec 4 should address the
  problems with some keytables (bug #4275).
* Tue Dec  5 2000 olh@suse.de
- add mac-fr_CH.map
* Mon Dec  4 2000 garloff@suse.de
- New startup script: Separate KEYMAP from COMPOSE maps. Add new
  rc.config variable COMPOSEMAP to allow setting of compose combi-
  nations defaulting to "latin1 latin1.add"
- Disable the formerly patched in inclusion of compose maps in
  the keymaps, as we have a proper separation now.
* Mon Dec  4 2000 garloff@suse.de
- Add de_CH ("schwyzerdütsch") keymap.
- Initialize consoles 1-24 (instead of 1-6) with CONSOLE_MAGIC
  (Bugzilla #4468)
* Tue Nov 28 2000 kukuk@suse.de
- New initscript in /etc/init.d
* Fri Oct 20 2000 kukuk@suse.de
- Fix filelist on SPARC
* Thu Oct  5 2000 olh@suse.de
- remove mac-de2-ext.map, obsolete
* Thu Oct  5 2000 olh@suse.de
- check for /proc/cpuinfo before mounting proc
* Tue Sep 12 2000 olh@suse.de
- mount proc on ppc, needed for runlevel S
* Tue Aug 22 2000 olh@suse.de
- update spec file and use only one dif, add mac-pt map, fix maps
* Sat Aug  5 2000 garloff@suse.de
- Only include kbdrate in kbd package, if it's not already in util
  If not, install it in /sbin, just like util did before.
- Remove the README files and ERRORS from /usr/lib/kbd/consolefonts
* Fri Aug  4 2000 kukuk@suse.de
- Add support for PS/2 keyboards and serial console on SPARC
* Tue Aug  1 2000 garloff@suse.de
- Update to version 1.03wip adding support for a PSF format and
  UTF8, including sequences.
- Apply old patches; split in mac keytables and general patch
- Add support for fonts wider than 8 pixels
- Map compose key (W*n95 Menu Key and Shift-RightCtrl) and include
  additional compose combinations for i386 us and de keymaps
- Add suse12x22.psf font to suse-add.tar.gz and remove fonts, map,
  transtables that are already included in 1.03wip.
- Add %%clean section to spec file
- Install more docu and move font specific docu to a subdir
- Add README.SuSE
* Mon Jul  3 2000 olh@suse.de
- merge keymaps from 6.4 for mac, be,it,de_CH,fi,dk
* Tue Jun  6 2000 olh@suse.de
- fix mac specific links to nonexistant maps,
  add mac/include to search path
* Wed May 31 2000 werner@suse.de
- Import script code from boot.setup which is kbd specific
- User new rc.status shell functions
- Move S20kbd to S10kbd (after nfs import init)
* Thu May 25 2000 olh@suse.de
- update us-map, get rid of misnamed maps
  use includes for mac-*
* Mon May  8 2000 wede@suse.de
- suse-add: Lithuanian console fonts and mappings added:
    /usr/lib/kbd/consolefonts/lat7.psf.gz
    /usr/lib/kbd/consolefonts/lt-brim-8x14.psfu.gz
    /usr/lib/kbd/consoletrans/lt-brim.uni
- kbd.spec: use of %%{_defaultdocdir}
* Sun Apr 30 2000 olh@suse.de
- update mac-fr.map
* Wed Apr  5 2000 olh@suse.de
- fix link to french mac map
* Tue Mar 28 2000 olh@suse.de
- use Buildroot
  add some dummy maps for mac
* Mon Mar 20 2000 kukuk@suse.de
- suse-add: Add more sun keymaps
* Thu Mar 16 2000 schwab@suse.de
- kbd.rc: Use i386 keymaps also on ia64 and alpha.
* Tue Feb 29 2000 werner@suse.de
- Close first part of bug #592
  * Search with shell tools not with find
  * Dump /etc/defkeymap.map if not exists
  * Use /etc/defkeymap.map as a fallback if no keymap is found
- Move loadkeys from /usr/bin/ to /bin/ and set a symbolic link
  for backward compatibility
- Add openvt to the file list
* Sun Feb 27 2000 kukuk@suse.de
- Move /usr/man -> /usr/share/man
* Thu Dec  9 1999 olh@suse.de
- Added i386 keys to mac-de.map, @|\~
  make Symlink mac -> ppc relative
* Thu Nov 11 1999 kukuk@suse.de
- kbd.rc: Add support for SPARC.
* Tue Sep 28 1999 ml@suse.de
- Added symlink keymaps/ppc -> keymaps/mac in specfile.
  Added lat9-[12,14,16].psfu consolefonts to suse_add.tar.gz
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Thu Jul  1 1999 ro@suse.de
- don't try to write /var/run/keymap if mounted ro (closing bug 20)
* Fri Jun 18 1999 uli@suse.de
- cleaned up patch
* Wed Jun 16 1999 uli@suse.de
- patched de-latin1.map to allow usage of Euro symbol with
  lat0-* console fonts
* Mon Jun  7 1999 uli@suse.de
- added br-abnt.map and us-acentos.map to suse-addon
* Mon Apr 12 1999 ml@suse.de
- added lt.baltic.map to suse-addon
* Sun Apr 11 1999 ml@suse.de
- added a patch for correct KOI8-U (Ukrainian) support
- added screenmap for baltic to suse-addon
* Tue Apr  6 1999 ml@suse.de
- added a patch harald könig for us.map
* Mon Apr  5 1999 ml@suse.de
-switch to version 0.99; main change of package: gettext for nls-support
-changes for us: removes the patches for sk-qwertz and sk-qwerty map
  and the map br-abnt2.map (included now)
-added /usr/share/locale/*/LC_MESSAGES/kbd.mo to the %%files-section
  of the specfile for nls-support
* Thu Mar 11 1999 ml@suse.de
- Changed to kbd-0.97
- lat2u.uni -> now included -> removed from suse-diff
- Pl02.map included into suse-addons and removed from diff
- Same for br-abnt2.map
- added ru3/4 map to suse-addon
- renamed the suse-iso07-extensions to lat7u.*
- removed #mkdir -p $DOC; #mv $K/consolefonts/README* $DOC/ "
  from specfile; now already included in kbd-0.97-makefile
- added ./configure --datadir (which will be best?)
- european default now lat1-16.psfu -> mantel & fehr
- added Cyr_a*.psf* to suse-addons, removed old Cyr-files and set links
- added cyralt.uni
- patched sk-qwertz and sk-qwerty map
* Mon Feb  1 1999 ro@suse.de
- resizecons is not built on alpha
* Mon Jan 18 1999 ml@suse.de
- added finally iso07.uni (missed it on Fri Jan  8 10:28:24 MET 1999)
  To do this, two mv-commands in the spec-file have been added, that move
  iso.07.uni to iso07.uni.old and the new one to iso07.uni
* Wed Jan 13 1999 ml@suse.de
- added latin2u.scrnmap
- added sk-qwertz.map
* Fri Jan  8 1999 ml@suse.de
-  added lat2u-16.psf and lat2u.uni
* Fri Jan  8 1999 rolf@suse.de
- added the following keymaps: br-abnt2, Pl02, sk-qwerty
- added the new version of iso07 fonts with SuSE extensions including
  unicode map file
* Sun Dec 13 1998 bs@suse.de
- removed /var/adm/setup/setup.fontconfig
* Sat Dec  5 1998 bs@suse.de
- let start script say, that a "keymap" is loaded.
* Thu Nov 26 1998 bs@suse.de
- made startup script a little bit smoother (let loadkeys not print
  a long path).
* Thu Nov 19 1998 bs@suse.de
- fixed second find call.
* Tue Nov 17 1998 bs@suse.de
- moved loadkeys to /usr/bin again (the kbd package does not work without
  a mounted /usr)
- created /sbin/init.d/kbd
- removed Makefile.Linux - was not used anymore :(
* Thu Oct 29 1998 ro@suse.de
- output "Loading $KEYMAP" to stdout (not stderr)
* Tue Sep 22 1998 ro@suse.de
- update to 0.96a
- for glibc define _GNU_SOURCE where getopt is used
* Mon Oct 20 1997 ro@suse.de
- ready for autobuild
* Tue Jun  3 1997 bs@suse.de
- removed man page console.4.gz (included in ldpman)
* Sun Apr 13 1997 florian@suse.de
- update to new version 0.93
- mv documentation to /usr/doc
