#
# spec file for package timezone
#
# Copyright (c) 2024 SUSE LLC
# Copyright (c) 2024 Andreas Stieger <Andreas.Stieger@gmx.de>
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%global AREA    Etc
%global ZONE    UTC
Name:           timezone
Version:        2025b
Release:        150600.91.6.2
Summary:        Time Zone Descriptions
License:        BSD-3-Clause AND SUSE-Public-Domain
Group:          System/Base
URL:            https://www.iana.org/time-zones
Source:         https://www.iana.org/time-zones/repository/releases/tzdata%{version}.tar.gz
Source1:        https://www.iana.org/time-zones/repository/releases/tzcode%{version}.tar.gz
Source2:        https://www.iana.org/time-zones/repository/releases/tzdata%{version}.tar.gz.asc
Source3:        https://www.iana.org/time-zones/repository/releases/tzcode%{version}.tar.gz.asc
Source4:        timezone.keyring
Source5:        %{name}.changes
Patch0:         tzdata-china.diff
Patch3:         iso3166-uk.diff
Patch4:         timezone-2018f-bsc1112310.patch
Patch5:         fat.patch
# PATCH-FIX-SLE revert-systemv-deprecation.patch -- From Debian sources. Fixes testsuite failures in other packages such as postgresql
Patch6:         revert-systemv-deprecation.patch
# PATCH-FIX-SLE revert-philippines-historical-data.patch -- Fixes testsuite failures in other packages such as postgresql
Patch7:         revert-philippines-historical-data.patch

%description
These are configuration files that describe available time zones. You
can select an appropriate time zone for your system with YaST.

%prep
%autosetup -p1 -c -a1
sed -ri 's@%{_prefix}/local%{_sysconfdir}/zoneinfo@%{_datadir}/zoneinfo@g' *.[1358]
touch version

%build
unset ${!LC_*}
LANG=POSIX
LC_ALL=POSIX
AREA=%{AREA}
ZONE=%{ZONE}
export AREA LANG LC_ALL ZONE
%make_build TZDIR=%{_datadir}/zoneinfo CC="gcc" CFLAGS="%{optflags} -DHAVE_GETTEXT=1 -DTZDEFAULT='\"%{_sysconfdir}/localtime\"' -DTM_GMTOFF=tm_gmtoff -DTM_ZONE=tm_zone -Dlint" AWK=awk BUGEMAIL="opensuse-support@opensuse.org" KSHELL=/bin/sh
%make_build TZDIR=zoneinfo AWK=awk zones
# Generate posixrules
./zic -b fat -y ./yearistype -d zoneinfo -p %{AREA}/%{ZONE}

%install
mkdir -p %{buildroot}%{_datadir}/zoneinfo
cp -a zoneinfo %{buildroot}%{_datadir}/zoneinfo/posix
cp -al %{buildroot}%{_datadir}/zoneinfo/posix/. %{buildroot}%{_datadir}/zoneinfo
cp -a zoneinfo-leaps %{buildroot}%{_datadir}/zoneinfo/right
mkdir -p %{buildroot}%{_sysconfdir}
rm -f  %{buildroot}%{_sysconfdir}/localtime
rm -f  %{buildroot}%{_datadir}/zoneinfo/posixrules
%if 0%{?suse_version} >= 1230
ln -sf %{_datadir}/zoneinfo/%{AREA}/%{ZONE} %{buildroot}%{_sysconfdir}/localtime
%else
cp -fp %{buildroot}%{_datadir}/zoneinfo/%{AREA}/%{ZONE} %{buildroot}%{_sysconfdir}/localtime
%endif
ln -sf %{_sysconfdir}/localtime      %{buildroot}%{_datadir}/zoneinfo/posixrules
install -m 644 iso3166.tab %{buildroot}%{_datadir}/zoneinfo/iso3166.tab
install -m 644 zone.tab    %{buildroot}%{_datadir}/zoneinfo/zone.tab
install -m 644 zone1970.tab %{buildroot}%{_datadir}/zoneinfo/zone1970.tab
install -m 644 tzdata.zi %{buildroot}%{_datadir}/zoneinfo/tzdata.zi
install -D -m 755 tzselect %{buildroot}%{_bindir}/tzselect
install -D -m 755 zdump    %{buildroot}%{_sbindir}/zdump
install -D -m 755 zic      %{buildroot}%{_sbindir}/zic
install -m 644 -t %{buildroot}%{_datadir}/zoneinfo/ leapseconds leapseconds.awk leap-seconds.list

%files
%license LICENSE
%verify(not link md5 size mtime) %config(missingok,noreplace) %{_sysconfdir}/localtime
%{_datadir}/zoneinfo
%{_bindir}/tzselect
%{_sbindir}/zdump
%{_sbindir}/zic

%changelog
* Thu Apr  3 2025 antonio.teixeira@suse.com
- Update to 2025b:
  * New zone for Aysén Region in Chile (America/Coyhaique) which
    moves from -04/-03 to -03
- Refresh patches
  * revert-philippines-historical-data.patch
  * tzdata-china.diff
* Mon Feb 24 2025 antonio.teixeira@suse.com
- Update to 2025a:
  * Paraguay adopts permanent -03 starting spring 2024
  * Improve pre-1991 data for the Philippines
  * Etc/Unknown is now reserved
- Update to 2024b:
  * Improve historical data for Mexico, Mongolia, and Portugal.
  * System V names are now obsolescent.
  * The main data form now uses %%z.
  * The code now conforms to RFC 8536 for early timestamps.
  * Support POSIX.1-2024, which removes asctime_r and ctime_r.
  * Assume POSIX.2-1992 or later for shell scripts.
  * SUPPORT_C89 now defaults to 1.
- Add revert-philippines-historical-data.patch, revert-systemv-deprecation.patch
  * Fixes testsuite failures for other packages
* Thu Mar 21 2024 martin.schreiner@suse.com
- Unify SLE-15-SP6 and Factory packages (PED#8158).
  This is still related to bsc#1213470. We're applying this fix for
  SLE-15-SP6 too.  This changelog entry is meant to bring over the SLE
  information, so the same package can be used for both code streams.
- This patch has long been removed on Factory but was never mentioned
  explicitly, it was related to ticket bsc#1202310, a minor update to
  reflect Chile's DST change back in 2022.
  * bsc1202310.patch
* Mon Mar 18 2024 lnussel@suse.com
- Use /bin/sh for tzselect. Used to require bash for the 'select'
  builtin but has a fallback meanwhile so no need for explicit bash
  anymore.
* Thu Mar 14 2024 martin.schreiner@suse.com
- Drop the timezone-java (bsc#1213470).
  After thorough consideration of possible problems that arise from
  having a timezone package specifically for the Java ecosystem,
  Fridrich Strba and I have decided to drop the package altogether.
  Doing so means the JDK will use its built-in timezone data that is
  updated quarterly, when refreshed JDK versions are released.
  While this does mean there could be situations where there is a bit
  of a mismatch between the 'timezone' package's data, and the data
  that is used by JDK, in practice the difference will be minimal and
  short-lived.
  So we've established this to be the best course of action.
- Remove _multibuild, not longer required.
* Thu Feb  1 2024 andreas.stieger@gmx.de
- Update to 2024a:
  * Kazakhstan unifies on UTC+5 beginning 2024-03-01
  * Palestine springs forward a week later after Ramadan
  * zic no longer pretends to support indefinite-past DST
  * localtime no longer mishandles Ciudad Juárez in 2422
* Wed Dec 27 2023 dmueller@suse.com
- update to 2023d:
  * Ittoqqortoormiit, Greenland changes time zones on
    2024-03-31.
  * Vostok, Antarctica changed time zones on 2023-12-18.
  * Casey, Antarctica changed time zones five times since
    2020.
  * Code and data fixes for Palestine timestamps starting in
    2072.
  * A new data file zonenow.tab for timestamps starting now.
  * Fix predictions for DST transitions in Palestine in
    2072-2075, correcting a typo introduced in 2023a.
  * Vostok, Antarctica changed to +05 on 2023-12-18.  It had
    been at +07 (not +06) for years.
  * Change data for Casey, Antarctica to agree with
    timeanddate.com, by adding five time zone changes since 2020.
    Casey is now at +08 instead of +11.
  * Much of Greenland, represented by America/Nuuk, changed
    its standard time from -03 to -02 on 2023-03-25, not on
    2023-10-28.
  * localtime.c no longer mishandles TZif files that contain
    a single transition into a DST regime.  Previously,
    it incorrectly assumed DST was in effect before the transition
    too.
  * tzselect no longer creates temporary files.
  * tzselect no longer mishandles the following:
  * Spaces and most other special characters in BUGEMAIL,
    PACKAGE, TZDIR, and VERSION.
  * TZ strings when using mawk 1.4.3, which mishandles
    regular expressions of the form /X{2,}/.
  * ISO 6709 coordinates when using an awk that lacks the
    GNU extension of newlines in -v option-arguments.
  * Non UTF-8 locales when using an iconv command that
    lacks the GNU //TRANSLIT extension.
  * zic no longer mishandles data for Palestine after the
    year 2075.
* Wed Mar 29 2023 andreas.stieger@gmx.de
- timezone update 2023c:
  * Reverts changes for 2023 Lebanon DST change to 2023a data
* Fri Mar 24 2023 andreas.stieger@gmx.de
- timezone update 2023b:
  * In 2023 Lebanon springs forward April 20/21 not March 25/26
* Thu Mar 23 2023 danilo.spinella@suse.com
- timezone update 2023a:
  * Egypt now uses DST again, from April through October.
  * This year Morocco springs forward April 23, not April 30.
  * Palestine delays the start of DST this year.
  * Much of Greenland still uses DST from 2024 on.
  * America/Yellowknife now links to America/Edmonton.
  * tzselect can now use current time to help infer timezone.
  * The code now defaults to C99 or later.
- Refresh tzdata-china.diff
- Remove upstreamed patch gcc13-fix.patch
* Tue Mar  7 2023 mliska@suse.cz
- Add gcc13-fix.patch upsteam patch for GCC 13 compiler.
* Tue Jan 24 2023 badshah400@gmail.com
- Install leapseconds data to %%{_datadir}/zoneinfo/; this is now
  required by some scientific applications.
* Wed Nov 30 2022 andreas.stieger@gmx.de
- timezone update 2022g:
  * In the Mexican state of Chihuahua, the border strip near the US
    will change to agree with nearby US locations on 2022-11-30.
    The strip's western part, represented by Ciudad Juárez, switches
    from -06 all year to -07/-06 with US DST rules, like El Paso, TX.
    The eastern part, represented by Ojinaga, will observe US DST next
    year, like Presidio, TX.
    A new Zone America/Ciudad_Juarez splits from America/Ojinaga.
  * Much of Greenland, represented by America/Nuuk, stops observing
    winter time after March 2023, so its daylight saving time becomes
    standard time.
  * Changes for pre-1996 northern Canada
  * Update to past DST transition in Colombia (1993), Singapore
    (1981)
  * timegm is now supported by default
* Sat Oct 29 2022 andreas.stieger@gmx.de
- timezone update 2022f:
  * Mexico will no longer observe DST except near the US border
  * Chihuahua moves to year-round -06 on 2022-10-30
  * Fiji no longer observes DST
  * Move links to 'backward'
  * In vanguard form, GMT is now a Zone and Etc/GMT a link
  * zic now supports links to links, and vanguard form uses this
  * Simplify four Ontario zones
  * Fix a Y2438 bug when reading TZif data
  * Enable 64-bit time_t on 32-bit glibc platforms
  * Omit large-file support when no longer needed
  * In C code, use some C23 features if available
  * Remove no-longer-needed workaround for Qt bug 53071
* Tue Oct 11 2022 andreas.stieger@gmx.de
- timezone update 2022e:
  * Jordan and Syria switch from +02/+03 with DST to year-round +03
* Sun Sep 25 2022 andreas.stieger@gmx.de
- timezone update 2022d:
  * Palestine transitions are now Saturdays at 02:00
  * Simplify three Ukraine zones into one
* Tue Aug 16 2022 andreas.stieger@gmx.de
- timezone update 2022c:
  * Work around awk bug
  * Improve tzselect on intercontinental Zones
* Thu Aug 11 2022 andreas.stieger@gmx.de
- timezone update 2022b:
  * Chile's DST is delayed by a week in September 2022 boo#1202324
  * Iran no longer observes DST after 2022
  * Rename Europe/Kiev to Europe/Kyiv
  * New zic -R option
  * Vanguard form now uses %%z
  * Finish moving duplicate-since-1970 zones to 'backzone'
* Wed Jun  8 2022 dmueller@suse.com
- switch to _multibuild
- refresh keyring, enable keyring validation
* Tue Apr 12 2022 fstrba@suse.com
- Add --add-exports for java versions that support it.
  * Fixes build in factory, since this is compulsory for jdk17+
* Thu Mar 17 2022 andreas.stieger@gmx.de
- timezone update 2022a:
  * Palestine will spring forward on 2022-03-27, not -03-26*
  * zdump -v now outputs better failure indications
  * Bug fixes for code that reads corrupted TZif data
* Fri Oct 22 2021 andreas.stieger@gmx.de
- timezone update 2021e:
  * Palestine will fall back 10-29 (not 10-30) at 01:00
* Sat Oct 16 2021 andreas.stieger@gmx.de
- timezone update 2021d:
  * Fiji suspends DST for the 2021/2022 season
  * 'zic -r' marks unspecified timestamps with "-00"
* Sat Oct  2 2021 andreas.stieger@gmx.de
- timezone update 2021c:
  * Revert almost all of 2021b's changes to the 'backward' file
  * Fix a bug in 'zic -b fat' that caused old timestamps to be
    mishandled in 32-bit-only readers
* Mon Sep 27 2021 info@paolostivanin.com
- timezone update 2021b:
  * Jordan now starts DST on February's last Thursday.
  * Samoa no longer observes DST.
  * Move some backward-compatibility links to 'backward'.
  * Rename Pacific/Enderbury to Pacific/Kanton.
  * Correct many pre-1993 transitions in Malawi, Portugal, etc.
  * zic now creates each output file or link atomically.
  * zic -L no longer omits the POSIX TZ string in its output.
  * zic fixes for truncation and leap second table expiration.
  * zic now follows POSIX for TZ strings using all-year DST.
  * Fix some localtime crashes and bugs in obscure cases.
  * zdump -v now outputs more-useful boundary cases.
  * tzfile.5 better matches a draft successor to RFC 8536.
* Thu Jul  8 2021 mmachova@suse.com
- Install tzdata.zi (bsc#1188127)
* Mon Jan 25 2021 mmachova@suse.com
- timezone update 2021a (bsc#1177460)
  * South Sudan changes from +03 to +02 on 2021-02-01 at 00:00.
* Tue Dec 29 2020 mmachova@suse.com
- timezone update 2020f (bsc#1177460)
  * 'make rearguard_tarballs' no longer generates a bad rearguard.zi,
    fixing a 2020e bug.
* Wed Dec 23 2020 mmachova@suse.com
- timezone update 2020e (bsc#1177460)
  * Volgograd switches to Moscow time on 2020-12-27 at 02:00.
* Fri Oct 30 2020 mcalabkova@suse.com
- Add fat.patch to generate "fat" timezone files (was default before 2020b)
  bsc#1178346
* Fri Oct 23 2020 andreas.stieger@gmx.de
- Adjust timezone-java.spec.in to avoid build failures when running
  pre_checkin.sh
* Thu Oct 22 2020 mcalabkova@suse.com
- timezone update 2020d
  * Palestine ends DST earlier than predicted, on 2020-10-24.
* Mon Oct 19 2020 mcalabkova@suse.com
- timezone update 2020c
  * Fiji starts DST later than usual, on 2020-12-20.
* Thu Oct  8 2020 mcalabkova@suse.com
- timezone update 2020b (bsc#1177460)
  * Revised predictions for Morocco's changes starting in 2023.
  * Canada's Yukon changes to -07 on 2020-11-01, not 2020-03-08.
  * Macquarie Island has stayed in sync with Tasmania since 2011.
  * Casey, Antarctica is at +08 in winter and +11 in summer.
  * zic no longer supports -y, nor the TYPE field of Rules.
- Rebased timezone-2018f-bsc1112310.patch
* Thu Sep 24 2020 dimstar@opensuse.org
- Fixup tzdata-china.diff: zone.tab and zone1970.tab MUST be tab
  delimited (boo#1176927).
* Sat Sep 12 2020 i@marguerite.su
- modify tzdata-china.diff
  * systemd now reads zone1970.tab
  * link Asia/Shanghai to Asia/Beijing is enough and more precise
* Fri Jun  5 2020 mcalabkova@suse.com
- timezone modifies a file below /usr/share (boo#1172521)
* Mon May 25 2020 mcalabkova@suse.com
- zdump --version reported "unknown" (boo#1172055)
* Fri Apr 24 2020 mcalabkova@suse.com
- timezone update 2020a (bsc#1169582)
  * Morocco springs forward on 2020-05-31, not 2020-05-24.
  * Canada's Yukon advanced to -07 year-round on 2020-03-08.
  * America/Nuuk renamed from America/Godthab.
  * zic now supports expiration dates for leap second lists.
* Thu Sep 12 2019 mcalabkova@suse.com
- timezone update 2019c (bsc#1150451)
  * Fiji observes DST from 2019-11-10 to 2020-01-12.
  * Norfolk Island starts observing Australian-style DST.
* Tue Jul  2 2019 mcalabkova@suse.com
- timezone update 2019b (bsc#1140016):
  * Brazil no longer observes DST.
  * 'zic -b slim' outputs smaller TZif files.
  * Palestine's 2019 spring-forward transition was on 03-29, not 03-30.
  * Add info about the Crimea situation in zone1970.tab and zone.tab.
* Tue Mar 26 2019 mcalabkova@suse.com
- timezone update 2019a:
  * Palestine "springs forward" on 2019-03-30 instead of 2019-03-23
  * Metlakatla "fell back" to rejoin Alaska Time on 2019-01-20 at
    02:00
  * Israel observed DST in 1980 (08-02/09-13) and 1984 (05-05/08-25)
  * zic now has an -r option to limit the time range of output data
* Mon Dec 31 2018 astieger@suse.com
- timezone update 2018i:
  * São Tomé and Príncipe switches from +01 to +00 on 2019-01-01
* Sun Dec 30 2018 astieger@suse.com
- timezone update 2018h (bsc#1120402):
  * Qyzylorda, Kazakhstan moved from +06 to +05 on 2018-12-21
  * New zone Asia/Qostanay because Qostanay, Kazakhstan didn't move
  * Metlakatla, Alaska observes PST this winter only
  * Guess Morocco will continue to adjust clocks around Ramadan
  * Add predictions for Iran from 2038 through 2090
* Sat Oct 27 2018 astieger@suse.com
- timezone update 2018g:
  * Morocco switches to permanent +01 on 2018-10-27 (bsc#1113554)
  * code fixes for zic on 32 bit
* Thu Oct 18 2018 astieger@suse.com
- Avoid build failures of timezone-java with javazic SLE/Leap 15
  by using an alternative notation for a 1948-1951 DST transition
  in Japan. add timezone-2018f-bsc1112310.patch, fixes boo#1112310
* Thu Oct 18 2018 astieger@suse.com
- timezone update 2018f:
  * Volgograd moves from +03 to +04 on 2018-10-28.
  * Fiji ends DST 2019-01-13, not 2019-01-20.
  * Most of Chile changes DST dates, effective 2019-04-06
    (bsc#1104700)
  * Corrections to past timestamps of DST transitions
  * Use "PST" and "PDT" for Philippine time
  * minor code changes to zic handling of the TZif format
  * documentation updates
* Tue May 22 2018 astieger@suse.com
- in SLE 15 / Leap 15.0 yast2-country stopped setting TIMEZONE in
  /etc/sysconfig/clock and called systemd timedatectl instead.
  No longer set /etc/localtime on timezone package updates to
  avoid setting an incorrect timezone. bsc#1093392
* Fri May  4 2018 astieger@suse.com
- timezone update 2018e:
  * North Korea switches back from +0830 to +09 on 2018-05-05.
  * Ireland's standard time is in the summer, with negative DST
    offset to standard time used in Winter (bsc#1073299)
* Sat Mar 24 2018 astieger@suse.com
- timezone update 2018d (bsc#1086729):
  * In 2018, Palestine starts DST on March 24, not March 31
  * Casey Station in Antarctica changed from +11 to +08 on
    2018-03-11 at 04:00
  * corrections for historical transitions
* Fri Jan 19 2018 astieger@suse.com
- timezone update 2018c:
  * São Tomé and Príncipe switched from +00 to +01 on 2018-01-01
  * Southern Brazil's DST will now start on November's first Sunday
    (bsc#1073275)
  * New zic option -t to specify the time zone file if TZ is unset
* Mon Oct 23 2017 astieger@suse.com
- timezone update 2017c (bsc#1064571):
  * Northern Cyprus switches from +03 to +02/+03 on 2017-10-29
  * Fiji ends DST 2018-01-14, not 2018-01-21
  * Namibia switches from +01/+02 to +02 on 2018-04-01
  * Sudan switches from +03 to +02 on 2017-11-01
  * Tonga likely switches from +13/+14 to +13 on 2017-11-05
  * Turks & Caicos switches from -04 to -05/-04 on 2018-11-04
  * corrections to past DST transitions
  * Move oversized Canada/East-Saskatchewan to 'backward' file
  * zic and the reference runtime now reject multiple leap seconds
    within 28 days of each other, or leap seconds before the Epoch
* Sat Oct  7 2017 jengelh@inai.de
- Replace old RPM constructs by new equivalents.
  Remove redundant %%clean section.
* Fri Oct  6 2017 fstrba@suse.com
- Require simply java, since with the new version of javazic, it
  is possible to generate the timezone information using any java
  version
* Sat Sep 16 2017 fstrba@suse.com
- Do not require java-bootstrap, since it does not exist any more;
  use java < 1.8 instead
* Wed Mar 22 2017 astieger@suse.com
- timezone update 2017b:
  * Haiti resumed observance of DST in 2017 (bsc#1030417)
  * Liberia changed from -004430 to +00 on 1972-01-07, not 1972-05-01.
  * Use "MMT" to abbreviate Liberia's time zone before 1972, as
    "-004430" is one byte over the POSIX limit
* Wed Mar  1 2017 astieger@suse.com
- timezone update 2017a:
  * Mongolia no longer observes DST bsc#1024676
  * Chile's Region of Magallanes moves from -04/-03 to -03
    year-round starting 2017-05-13 23:00, split from
    America/Santiago creating a new zone America/Punta_Arenas
    Also affects Antarctica/Palmer. bsc#1024677
  * Fixes to historical time stamps: Spain, Ecuador, Atyrau, Oral
  * Switch to numeric, or commonly used time zone abbreviations
  * zic no longer mishandles some transitions in January 2038
  * date and strftime now cause %%z to generate "-0000" instead of
    "+0000" when the UT offset is zero and the time zone
    abbreviation begins with "-".
* Thu Nov 24 2016 astieger@suse.com
- timezone update 2016j [bsc#1011797]:
  * Saratov, Russia switches from +03 to +04 on 2016-12-04 at 02:00.
    (new zone Europe/Saratov split from Europe/Volgograd)
  * 1994-1999 corrections for Kazakhstan, with new zone Asia/Atyrau
  * Asia/Gaza and Asia/Hebron now use "EEST", not "EET", to denote
    summer time before 1948.  The old use of "EET" was a typo.
* Thu Nov  3 2016 astieger@suse.com
- timezone update 2016i:
  * Pacific/Tongatapu begins DST on 2016-11-06 at 02:00, ending on
    2017-01-15 at 03:00. [bsc#1007725]
  * Northern Cyprus is now +03 year round, causing a split in Cyprus
    time zones starting 2016-10-30 at 04:00.  This creates a zone
    Asia/Famagusta [bsc#1007726]
  * Antarctica/Casey switched from +08 to +11 on 2016-10-22
  * Corrections to pre-1975 timestamps in Italy
* Fri Oct 21 2016 astieger@suse.com
- timezone update 2016h:
  * Asia/Gaza and Asia/Hebron end DST on 2016-10-29 at 01:00, not
    2016-10-21 at 00:00.
  * Adjust 1986-1990, 1994 Turkey DST transistions
  * Asia/Colombo now uses numeric time zone abbreviations
  * drop timezone-2016g-absolute-TZDEFAULT.patch, upstream
* Thu Oct  6 2016 astieger@suse.com
- timezone update 2016g:
  * Turkey will remain on UTC+03 after 2016-10-30 bsc#997830
  * New leap second 2016-12-31 23:59:60 UTC
    Remove 0001-Positive-leap-second-on-2016-12-31.patch
  * Corrections for past DST transitions
  * Antarcica and nautical time zones now use numeric time zone
    abbreviations instead of obsolete alphanumeric ones
  * Renamed Asia/Rangoon to Asia/Yangon
  * The following change was previously patched in the package
    and is now upstream:
    + If the installed localtime and/or posixrules files are
    symbolic links, zic now keeps them symbolic links when
    updating them, for compatibility with platforms like
    openSUSE where other programs configure these files as
    symlinks.
    + zic now avoids hard linking to symbolic links, avoids
    some unnecessary mkdir and stat system calls, and uses
    shorter file names internally.
    + Drop the patches:
    tzcode-link.diff
    tzcode-revert-01-8c9cb9580.patch
    tzcode-revert-02-301f794f3.patch
    tzcode-revert-03-39fd078a6.patch
    tzcode-symlink.patch
    tzcode-zic.diff
    tzcode-fromname.patch
    + Upstream changes did not account for TZDEFAULT being an
    absolute path. Prevent broken symlinks (bsc#1003324),
    add timezone-2016g-absolute-TZDEFAULT.patch
  * zdump has a new -i option to generate transitions in a
    more-compact but still human-readable format. (experimental)
* Mon Aug  8 2016 astieger@suse.com
- A positive leap second will be added at the end of 2016-12-31
  (bsc#988184) 0001-Positive-leap-second-on-2016-12-31.patch
* Tue Aug  2 2016 astieger@suse.com
- add new signing key which is now available. Next release will
  revert to previous key.
* Tue Jul  5 2016 astieger@suse.com
- timezone update 2016f:
  * Egypt (Africa/Cairo) DST change 2016-07-07 cancelled boo#987720
  * Asia/Novosibirsk switches from +06 to +07 on 2016-07-24 02:00
  * Asia/Novokuznetsk and Asia/Novosibirsk now use numeric time
    zone abbreviations instead of invented ones.
  * Europe/Minsk's 1992-03-29 spring-forward transition was at
    02:00 not 00:00.
- new upstream signing key not available, dropping
* Tue Jun 14 2016 astieger@suse.com
- timezone update 2016e:
  * Africa/Cairo observes DST in 2016 from July 7 to the end of
    October (boo#982833)
  * Changes affecting past timestamps in arctic and antarctic
    locations while uninhabited
  * Adjust Asia/Baku's 1992 DST transition
  * zic now outputs a dummy transition at time 2**31 - 1 in zones
    whose POSIX-style TZ strings contain a '<', working around Qt
    bug 53071
* Mon Apr 18 2016 astieger@suse.com
- timezone update 2016d
  * Venezuela (America/Caracas) switches from -0430 to -04 on
    2016-05-01 at 02:30 [boo#975875]
  * Asia/Magadan switches from +10 to +11 on 2016-04-24 at 02:00.
  * New zone Asia/Tomsk, split off from Asia/Novosibirsk. It covers
    Tomsk Oblast, Russia, which switches from +06 to +07 on
    2016-05-29 at 02:00
  * Changes for past time zones (corrections and new Europe/Kirov)
  * Corrections to historical time in Kazakhstan from 1991
    through 2005.
* Wed Mar 23 2016 astieger@suse.com
- timezone update 2016c [boo#972433]
  * Azerbaijan no longer observes DST (Asia/Baku)
  * Chile reverts from permanent to seasonal DST.
  * Correct past timestamps for Europe/Kaliningrad, Europe/Vilnius,
    Europe/Volgograd 1989-1991
* Thu Mar 17 2016 lchiquitto@suse.com
- timezone update 2016b [boo#971377]
  * New zones Europe/Astrakhan and Europe/Ulyanovsk for Astrakhan
    and Ulyanovsk Oblasts, Russia, both of which will switch from
    +03 to +04 on 2016-03-27 at 02:00 local time.
  * New zone Asia/Barnaul for Altai Krai and Altai Republic, Russia,
    which will switch from +06 to +07 on the same date and local time.
  * Asia/Sakhalin moves from +10 to +11 on 2016-03-27 at 02:00.
  * As a trial of a new system that needs less information to be made
    up, the new zones use numeric time zone abbreviations like "+04"
    instead of invented abbreviations like "ASTT".
  * Haiti will not observe DST in 2016.
  * Palestine's spring-forward transition on 2016-03-26 is at 01:00,
    not 00:00.
  * tzselect's diagnostics and checking, and checktab.awk's checking,
    have been improved.
  * tzselect now tests Julian-date TZ settings more accurately.
    (Thanks to J William Piggott.)
- tzcode-revert-01-8c9cb9580.patch, tzcode-revert-02-301f794f3.patch,
  tzcode-revert-03-39fd078a6.patch: Revert some porting fixes specific
  to MS-Windows that rewrites parts of zic touched by our patches.
* Thu Jan 28 2016 astieger@suse.com
- timezone update 2016a [boo#963921]
  * America/Cayman will not observe DTS this year
  * Asia/Chita switches from +0800 to +0900 on 2016-03-27 at 02:00.
  * Asia/Tehran now has DST predictions for the year 2038 and later
  * America/Metlakatla switched from PST all year to AKST/AKDT on
    2015-11-01 at 02:00.
  * America/Santa_Isabel has been removed, and replaced with a
    backward compatibility link to America/Tijuana.
  * Asia/Karachi's two transition times in 2002 were off by a minute.
* Fri Oct  2 2015 astieger@suse.com
- timezone update 2015g
  * Turkey's 2015 fall-back transition is scheduled for Nov. 8,
    not Oct. 25 [boo#948227]
  * Adjustments for upcoming changes in Norfolk, Fiji, Fort Nelson
  * New zone America/Fort_Nelson.
  * localtime no longer mishandles America/Anchorage after 2037.
  * On hosts with signed 32-bit time_t, localtime no longer
    mishandles Pacific/Fiji after 2038-01-16 14:00 UTC.
* Fri Aug 14 2015 astieger@suse.com
- timezone update 2015f [boo#941249]
  * North Korea switches to +0830 on 2015-08-15, abbreviation
    remains "KST".
  * Uruguay no longer observes DST.
  * Moldova starts and ends DST at 00:00 UTC, not at 01:00 UTC.
- unfuzz tzcode-symlink.patch and tzcode-link.diff
* Sun Jun 14 2015 astieger@suse.com
- timezone update 2015e [boo#934654]
  * Morocco will suspend DST from 2015-06-14 03:00 through
    2015-07-19 02:00, not 06-13 and 07-18 as guessed.
  * Assume Cayman Islands will observe DST starting next year,
    using US rules.
  * The file 'iso3166.tab' now uses UTF-8
  * When displaying data, tzselect converts it to the current
    locale's encoding if the iconv command works.
  * tzselect no longer mishandles Dominica, fixing a bug introduced
    in Release 2014f.
  * zic -l no longer fails when compiled with
  - DTZDEFAULT=\"/etc/localtime\", regression from 2014f.
    Dropping upstreamed tzcode-zic-empty-comp.diff
* Tue May 19 2015 lchiquitto@suse.com
- tzcode-zic-empty-comp.diff: Replaced by more sophisticated fix
  from upstream
* Mon May 18 2015 lchiquitto@suse.com
- tzcode-zic-empty-comp.diff: Fix check for empty components in
  absolute path
* Thu May 14 2015 lchiquitto@suse.com
- Fix post-install script to overwrite the temporary file when
  attempting to create /etc/localtime as a hard link [bsc#928841]
* Thu May 14 2015 lchiquitto@suse.com
- timezone update 2015d [bsc#928584, bsc#928246]
  * Egypt announced it is off DST indefinitely
  * zic has some minor performance improvements
- tzcode-fromname.patch, tzcode-link.diff, tzcode-symlink.patch,
  tzcode-zic.diff, tzdata-china.diff: Rebase
* Tue Apr 21 2015 crrodriguez@opensuse.org
- Revert initrd generation updates, they add a new build cycle.
* Tue Apr 14 2015 astieger@suse.com
- timezone update 2015c [boo#927029]
  * correct Egypt 2015 DST transition from April 24 to April 30
  * Changes affecting past time stamps and historic DST changes
  * time zones turned into links where this affects UTC offsets
    in pre-1970 time stamps only: America/Montreal
* Thu Apr  2 2015 crrodriguez@opensuse.org
- BuildRequire suse-module-tools otherwise initrd macros
  are never defined.
* Sat Mar 28 2015 crrodriguez@opensuse.org
- we should regenerate the initrd when the timezone
  package is updated, as the timezone selected by the user
  plus UTC is nowadays required by SUSE-specific "warpclock"
  dracut module.
* Sat Mar 21 2015 astieger@suse.com
- timezone update 2015b [boo#923493]
- Changes to time zones:
  * Mongolia DST observance 2015
  * Palestine DST dates 2015 and 2015
  * correct 1982 zone shift in Pacific/Easter, regression in 2015a
  * More pre-1970 zones have been turned into links, when they
    differed from existing zones only for older time stamps:
    America/Antigua, America/Cayman, Pacific/Midway,
    Pacific/Saipan.
  * Correct the 1992-2010 DST abbreviation in Volgograd from "MSK"
    to "MSD".
- Changes to code:
  * Fix integer overflow bug in reference 'mktime' implementation.
  * Allow -Dtime_tz=time_t compilations, and allow -Dtime_tz=...
    libraries to be used in the same executable as standard-library
    time_t functions.
* Fri Jan 30 2015 andreas.stieger@gmx.de
- timezone update 2015a
  * New positive leap second 2015-06-30 23:59:60 UTC as per IERS
    Bulletin C 49 [boo#914676]
  * Mexico state Quintana Roo (America/Cancun) shift from Central
    Time with DST to Eastern Time without DST on 2015-02-01 02:00.
  * Chile (America/Santiago) will retain old DST as standard time
    from April, also Pacific/Easter, and Antarctica/Palmer
  * Changes affecting past timestamps (Iceland 1837 through 1939)
  * Some more zones have been turned into links (pre-1970)
- remove leap-second-2015.patch
* Mon Jan 26 2015 dmueller@suse.com
- add leap-second-2015.patch (bnc#914676)
* Thu Nov 20 2014 fstrba@suse.com
- make timezone-java compatible with Java8
  * Add generation of tzdb.dat used by Java8 and Java9
  * Require tzdb package to be able to generate this database
  * Build using java-bootstrap 1.7 used in openSUSE:Factory to
    bootstrap java-1_7_0-openjdk
  * Add virtual provider tzdata-java8 in order to be able to
    require it for java-1_8_0-openjdk
* Tue Nov 11 2014 andreas.stieger@gmx.de
- timezone update 2014j [boo#904824]
  + Turks & Caicos' switch from US eastern time to UTC-4 year-round
    moved from 2014-11-02 at 02:00 to 2015-11-01 at 02:00.
  + Corrects pre-1989 time stamps for Asia/Seoul and Asia/Pyongyang
  + Time zones turned into links when they differed from existing
    zones only for pre-1970 time stamps:
    Africa/Addis_Ababa, Africa/Asmara, Africa/Dar_es_Salaam,
    Africa/Djibouti, Africa/Kampala, Africa/Mogadishu,
    Indian/Antananarivo, Indian/Comoro, and Indian/Mayotte.
* Wed Oct 22 2014 lchiquitto@suse.com
- update to 2014i [bsc#902276]:
  * Pacific/Fiji will observe DST from 2014-11-02 02:00 to
    2015-01-18 03:00.
  * A new Zone Pacific/Bougainville, for the part of Papua New
    Guinea that plans to switch from UTC+10 to UTC+11 on
    2014-12-28 at 02:00.
  * Some changes in time zone abbreviations and affecting past
    time stamps.
  * Some fixes for minor bugs.
* Fri Sep 26 2014 andreas.stieger@gmx.de
- update to 2014h [bnc#898747]:
  * Changes to past time stamps corrections
  * Some more zones have been turned into links
  * zdump -V and -v now output gmtoff= values on all platforms
  * The tz library's localtime and mktime functions now set tzname
    to a value appropriate for the requested time stamp, and zdump
    now uses this on platforms not defining TM_ZONE, fixing a 2014g
    regression.
  * The tz library no longer sets tzname if localtime or mktime
    fails.
  * zdump -c no longer mishandles transitions near year boundaries.
  * An access to uninitalized data has been fixed.
  * When THREAD_SAFE is defined, the code ports to the C11 memory
    model.
  * A memory leak has been fixed if ALL_STATE and THREAD_SAFE are
    defined and two threads race to initialize data used by
    gmtime-like functions
  * Documentation improvements zdump's gmtoff=N, isdst=D, -c's
- verify source signatures
* Wed Sep  3 2014 lchiquitto@suse.com
- update to 2014g (bnc#894862):
  * Turks & Caicos are switching from US eastern time to UTC-4
    year-round, modeled as a switch from EST/EDT to AST on
    2014-11-02 at 02:00.
  * Many past time stamps were changed for correctness.
  * Many performance enhancements and fixes in the time zone
    manipulation utilities.
- iso3166-uk.diff, tzcode-fromname.patch, tzcode-zic.diff,
  tzdata-china.diff: refresh.
- tzcode-symlink.patch: rebase.
* Wed Sep  3 2014 lchiquitto@suse.com
- update to 2014f (bnc#890921, bnc#892843):
  * Russia will subtract an hour from most of its time zones on
    2014-10-26 at 02:00 local time.
  * Many time zone abbreviations were adjusted or fixed.
  * Many past time stamps were changed for correctness.
  * A new file 'zone1970.tab' was added. The new file's extended
    format allows multiple country codes per zone. New applications
    should use the new file.
  * Some fixes in 'localtime', 'zic', 'mktime' and 'yearistype'.
* Fri Jun 13 2014 lchiquitto@suse.com
- update to 2014e (bnc#882684):
  * Egypt's 2014 Ramadan-based transitions are June 26 and July 31
    at 24:00. Similarly, Morocco's are June 28 at 03:00 and August
    2 at 02:00.
* Fri Jun 13 2014 lchiquitto@suse.com
- update to 2014d:
  * zic no longer generates files containing time stamps before
    the Big Bang. This works around GNOME bug 730332.
- tzcode-revert-low-valued.patch: remove, no longer needed.
* Fri May 23 2014 lchiquitto@suse.de
- tzcode-revert-low-valued.patch: revert 'zic' patch to improve
  handling of low-valued time stamps as it breaks applications that
  read the binary files directly (bnc#879680, bnc#879512, bnc#879073)
* Tue May 13 2014 lchiquitto@suse.com
- update to 2014c (bnc#877535):
  * Egypt observes DST starting 2014-05-15 at 24:00
* Wed Mar 26 2014 lchiquitto@suse.com
- update to 2014b (bnc#870375):
  * Crimea switches to Moscow time on 2014-03-30 at 02:00 local time
  * New entry for Troll station, Antarctica
* Thu Mar 20 2014 meissner@suse.com
- solar87,solar88,solar89 were removed, remove them from
  java build.
* Mon Mar 10 2014 lchiquitto@suse.com
- update to 2014a:
  * Turkey begins DST on 2014-03-31, not 03-30
  * Misc changes affecting past time stamps
  * An uninitialized-storage bug in 'localtime' has been fixed
* Mon Feb 10 2014 dmueller@suse.com
- install /etc/localtime as symlink to UTC by default
* Mon Oct 28 2013 dmueller@suse.com
- update to 2013h:
  * Lybia has switched back to UTC+2
  * Western Sahara uses Morocco's DST rules
  * Acre sitches from UTC-4 to UTC-5 on Nov. 10th
* Mon Oct 14 2013 werner@suse.de
- Add patch tzcode-fromname.patch to correct path expansion for
  local time link (bnc#845530)
- Modify tzcode-link.diff to fit with tzcode-fromname.patch
- Modify tzcode-symlink.patch to fit with tzcode-fromname.patch
  and to avoid broken posixrules if /etc/localtime is a symlink
* Wed Oct  2 2013 lchiquitto@suse.com
- tzcode-link.diff: refresh patch to apply correctly on older
  versions of the distribution.
* Tue Oct  1 2013 crrodriguez@opensuse.org
- v2013g
- changes for Morocco, Asia/Tehran
* Thu Sep 26 2013 crrodriguez@opensuse.org
- v2013f
- Tocantins will very likely not observe DST starting this spring.
- Jordan will likely stay at UTC+3 indefinitely
- Palestine will fall back at 00:00, not 01:00
- see NEWS for extra detail.
* Sat Sep 21 2013 crrodriguez@opensuse.org
- Update to 2013e:
    This year Fiji will start DST on October 27, not October 20.
    Use WIB/WITA/WIT rather than WIT/CIT/EIT for alphabetic Indonesian
    time zone abbreviations since 1932
    Use ART (UTC-3, standard time), rather than WARST (also UTC-3, but
    daylight saving time) for San Luis, Argentina since 2009.
  * Changes affecting Godthab time stamps after 2037 if version mismatch
  * Changes affecting time stamps before 1970
  * Changes affecting time zone abbreviations before 1970
  * The 'leapseconds' file is now generated automatically from a
    new file 'leap-seconds.list', which is a copy of
    <ftp://time.nist.gov/pub/leap-seconds.list>.
    A new source file 'leapseconds.awk' implements this.
    The goal is simplification of the future maintenance of 'leapseconds'.
* Mon Jul  8 2013 dmueller@suse.com
- restrict symlink change to systemd distros
* Mon Jul  8 2013 dmueller@suse.com
- update to 2013d:
  * Morocco's midsummer transitions this year are July 7 and August 10,
    not July 9 and August 8.  (Thanks to Andrew Paprocki.)
  * Israel now falls back on the last Sunday of October.
* Mon Apr 29 2013 crrodriguez@opensuse.org
- /etc/localtime must be a symlink to /usr/share/zoneinfo/$TIMEZONE
  so systemd-timedated and its command line tool timedatectl
  can work correctly. Yast already does the right thing.
* Sat Apr 20 2013 crrodriguez@opensuse.org
- tzcode & tzdata 2013c, updates for Australia, Palestine,
  Paraguay.
* Sun Mar 10 2013 crrodriguez@opensuse.org
- tzcode and tzdata 2013a
  - Change affecting binary data format:
  * The zone offset at the end of version-2-format zone files is now
  allowed to be 24:00, as per POSIX.1-2008.  (Thanks to Arthor David Olson.)
- Changes affecting current and future time stamps:
  * Chile's 2013 rules, and we guess rules for 2014 and later, will be
    the same as 2012, namely Apr Sun>=23 03:00 UTC to Sep Sun>=2 04:00 UTC.
  * New Zones Asia/Khandyga, Asia/Ust-Nera, Europe/Busingen.
* Fri Feb  1 2013 schwab@linux-m68k.org
- Define TM_GMTOFF and TM_ZONE like glibc did (bnc#807624)
* Tue Nov 13 2012 dmueller@suse.com
- update to 2012j:
  * Libya moved to CET this weekend, but with DST planned next year
* Mon Nov  5 2012 dmueller@suse.com
- update to 2012i:
  * Cuba switches DST on November 4th
- tzcode-ksh.diff: Obsolete, upstream uses bash now by default
* Sat Oct 27 2012 dmueller@suse.com
- update to 2012h (bnc#787005):
  * Samoa fall 2012 and later
  * Palestine fall 2012
  * Bahia no longer has DST
  * Tocantins has DST
  * Israel has new DST rules next year
  * Jordan stays on DST this winter
* Sat Sep 15 2012 frank.lichtenheld@sophos.com
- Update Url from the glibc page (which doesn't talk
  about timezone data at all (anymore?)) to the IANA
  page which is much more informative.
* Thu Sep 13 2012 dmueller@suse.com
- cleanup stale rpmnew / symlink of posixrules to /etc/localtime (bnc#762210)
- remove %%config part on posixrules symlink, it is not a config file
- update to 2012f (bnc#780276):
  * Fiji DST is October 21st 2012 -> January 20th, 2013
* Mon Aug 20 2012 fcrozat@suse.com
- Add tzcode-symlink.patch: use a symlink to create /etc/localtime
  (bnc#773491)
- Do not apply tzcode-link.diff on openSUSE >= 12.2 (bnc#773491).
* Mon Aug  6 2012 dmueller@suse.com
- update to 2012e:
  * Pacific/Fakaofo: Tokelau is UTC+13, not UTC+14
* Tue Jul 24 2012 dmueller@suse.com
- update to 2012d (bnc#771369):
  * Morocco DST is interrupted during Ramadan 2012
  (July 20th- August 19th)
* Mon Apr  2 2012 dmueller@suse.de
- update to 2012c:
  * Morocco DST starts late April 2012
  * Changes for Gaza, Hebron and Syria (for 2012)
  * Haiti now follows US/Canada rules regarding DST
* Thu Mar 29 2012 dmueller@suse.de
- adjust license to spdx.org format (bnc#752642)
* Sat Mar  3 2012 dmueller@suse.de
- update to 2012b (bnc#748550):
  * Cuba has delayed start of DST by 3 weeks
  (now starts April 1 rather than March 11
  * Chile 2011/2012 and 2012/2013 summer time date adjustments.
  * Falkland Islands onto permanent summer time (we're assuming for the
    foreseeable future, though 2012 is all we're fairly certain of.)
  * Armenia has abolished Summer Time.
  * Tokelau jumped the International Date Line back last December
    (just the same as their near neighbour, Samoa).
  * America/Creston is a new zone for a small area of British Columbia
  * There will be a leapsecod 2012-06-30 23:59:60 UTC.
* Sat Nov  5 2011 dmueller@suse.de
- update to 2011n:
  * Cuba (America/Havana) has extended summer time to end on Nov 13
  * Europe/Tiraspol decided not to split from the rest of Moldova, hence
  that zone has been removed
  * Fiji end of summer time was moved fromrward from Feb 26 to Jan 22
* Tue Oct 25 2011 dmueller@suse.de
- fix build failure of timezone-java
* Tue Oct 25 2011 dmueller@suse.de
- apply patches also for timezone-java
- add patch to fix Tiraspol split
* Mon Oct 24 2011 dmueller@suse.de
- update to 2011m (bnc#726162):
  * All Ukrainian timezones are going back to winter time
    on Oct 30th, 2011
  * Adding Tiraspol to the zone.tab
  * America/Bahia switched to DST on Oct 16th, 2011
* Fri Oct 14 2011 dmueller@suse.de
- update to 2011l:
  * West Bank ended DST 2011-09-30 already
  * Fiji enters DST on October 23th 2011
* Sun Oct  2 2011 dmueller@suse.de
- update to 2011k:
  * Palestine suspends DST during Ramadan in 2011;
    Gaza and Hebron split in 2011, leading to a new
    Asia/Hebron zone (thanks to Steffen Thorsen and
    Alexander Krivenshev).
  * Belarus adopts permanent DST in 2011
    (thanks to Yauhen Kharuzhy, Alexander Bokovoy,
    Alexander Krivenyshev, and Kirill A. Shutemov).
  * Ukraine adopts permanent DST in 2011
  * "Russia" rules changed to reflect end of use in 2010.
  * "FET" used as abbreviation for Belarus, Ukraine,
    and western Russia (thanks to Paul Eggert).
* Tue Sep 13 2011 dmueller@suse.de
- update to 2011j:
  * Fix past timezones for Kenya, Uganda, and Tanzani
  * Samoa uses DST in 2011-2012 starting on September 24th 3am
* Sun Sep  4 2011 dmueller@suse.de
- update to 2011i:
  * Add Africa/Juba (South Sudan) zone
  * Samoa skips over 2011-12-30
  * Use KALT as abbreviation for Europe/Kalinigrad from spring
    2011 forward
  * Newfoundland changes time of day for DST start and end
    to 2:00 a.m. starting fall 2011 and forward
  * Change America/Resolute use of EST to 2006-2007 only
  * iso3166.tab Add SS (South Sudan) entry.
  * zone.tab Change America/Resolute entry to Central Standard Time.
* Mon Jun 27 2011 dmueller@suse.de
- update to 2011h (bnc#684181):
  * Russia is abolishing daylight saving time.
  * iso3166 code for America/Curacao changed from AN to CW
* Tue May  3 2011 dmueller@suse.de
- update to 2011g (bnc#691414):
  * Egypt on longer has daylight saving time
  * Falkland islands on a trial basis do not observe DST anymore
* Fri Apr  1 2011 dmueller@suse.de
- update to 2011e:
  * Southamerica/Chile: Delay DST until May 7th
  * Southafrica/Morocco: Updates
* Mon Mar 14 2011 dmueller@suse.de
- update to 2011d:
  * Pacific/Apia: Move DST from April 3rd to April 2nd
  * Europe/Istanbul: Move DST from March 27th to 28th
  * America/Cuba: DST starts on March 20th
* Sat Mar 12 2011 dmueller@suse.de
- update to 2011c:
  * northamerica  Replace Juneau with Juneau, Sitka, and Metlakatla.
  * southamerica  Delay end of DST in 2011 until first Sunday in April.
* Tue Feb 15 2011 dmueller@suse.de
- update to 2011b:
  * updates for australasia and northamerica
* Tue Nov  2 2010 dmueller@suse.de
- update to 2010o:
  * fix Pacific/Apia and Austalasia/Fiji
* Tue Oct  5 2010 dmueller@suse.de
- update to 2010m:
  * fix historic data of Antarctica/Vostok
* Tue Sep 21 2010 dmueller@suse.de
- change execlp into execl
* Wed Aug 25 2010 ro@suse.de
- add missing sentinel to tzcode-link.diff
* Tue Aug 24 2010 pbaudis@suse.cz
- Make zic -l do a copy when hardlinking fails (e.g. because /usr
  being on a separate partition) [bnc#607532]
* Thu Aug 19 2010 ro@suse.de
- un-fuzz patches to fix build
* Wed Aug 18 2010 pbaudis@suse.cz
- update tzdata to 2010l
  * DST changes: Africa/Cairo, Africa/Casablanca, Asia/Gaza,
    America/Argentina/San_Luis
  * New zones: America/Bahia_Banderas
  * Historical changes: Asia/Taipei, Europe/Helsinki
  * Spelling changes: Pacific/Chuuk, Pacific/Pohnpei
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Tue Apr  6 2010 pbaudis@suse.cz
- update tzdata to 2010h:
  * DST changes: Asia/Dhaka (again...), Asia/Karachi, Asia/Gaza,
    Asia/Damascus, Pacific/Apia, Africa/Tunis
  * GMT offset changes: Europe/Samara, Asia/Kamchatka, Asia/Anadyr
  * Various Antarctica timezone changes
* Thu Mar 18 2010 pbaudis@suse.cz
- cleanup; changes since 2009u are:
  * DST changes: Asia/Dhaka (yet again), Pacific/Fiji, Pacific/Apia,
    America/Santiago, Pacific/Easter, America/Asuncion
  * New zones: America/Matamoros, America/Ojinaga, America/Santa_Isabel
* Sun Mar 14 2010 crrodriguez@opensuse.org
- Update to 2010e, including Chile's emergency DST changes
- Update code to 2010c - mostly just cleanups
* Tue Jan  5 2010 pbaudis@suse.cz
- update tzdata to 2009u:
  * DST changes: Asia/Damascus, Asia/Dhaka, Pacific/Fiji
  * GMT offset changes: some bases in Antartica
  * New zones: Asia/Novokuznetsk
  * Historical changes: Asia/Hong_Kong
- typo fix in Asia/Dhaka Jun 2009 transition rule
* Tue Dec  8 2009 jengelh@medozas.de
- enable parallel building
* Tue Nov  3 2009 coolo@novell.com
- updated patches to apply with fuzz=0
* Mon Oct 26 2009 pbaudis@suse.cz
- update data to 2009p - Argentina switch to DST
* Fri Oct 23 2009 pbaudis@suse.cz
- update data to 2009o:
  * DST changes: Asia/Karachi, Asia/Dhaka
- Apply a patch for changes in Argentina DST: Argentina is not
  switching to DST, except America/Argentina/SanLuis; version number
  modified to 2009oa to reflect the extra patch.
* Mon Sep 14 2009 pbaudis@suse.cz
- The abbreviation definition of GB should be United Kingdom instead
  of Britain (UK) [bnc#519410]
* Tue Sep  8 2009 pbaudis@suse.cz
- update data to 2009m:
  * DST changes: Africa/Cairo, Indian/Mauritius, Asia/Dhaka,
    Asia/Karachi, Asia/Gaza, Pacific/Apia
  * Fix bad DST information since 2002: Asia/Amman
- update code to 2009k:
  * zic tried to generate wrong POSIX tz string in a pathological case
* Wed Aug 26 2009 mls@suse.de
- make patch0 usage consistent
* Tue Apr 21 2009 werner@suse.de
- Use Unversial time zone for posixrules
- Use mktemp from coreutiles for temporary file
* Thu Mar 26 2009 pbaudis@suse.cz
- update to 2009d:
  * DST changes: Africa/Casablanca, Africa/Tunis, Asia/Damascus,
    America/Argentina/San_Luis
* Tue Feb 24 2009 schwab@suse.de
- Don't copy directory into itself.
* Mon Feb 23 2009 dmueller@suse.de
- update to 2009b:
  * leapseconds: updated to reflect no mid-2009 leap second
  * zic.c: fix fence-post error (fixes corrupt timezone
  database)
* Tue Feb  3 2009 dmueller@suse.de
- update to 2009a:
  * asia
    change Katmandu to Kathmandu
  * backward
    provide Katmandu link
  * europe
    correct Swiss rules
  * northamerica
    clearer definition of Cuban transitions (no binary change)
    Resolute changes abbreviation (but not time) twice a year
* Wed Dec  3 2008 dmueller@suse.de
- update to 2008i:
  * South America Updates (corrections to Argentina DST rules)
  * US zone reordering and recommenting
* Wed Oct 15 2008 pbaudis@suse.cz
- Add coreutils to the prerequisites [bnc#420365]
* Mon Oct 13 2008 pbaudis@suse.cz
- update to 2008h: Fix DST for Indian/Mauritius and Asia/Damascus
* Thu Oct  9 2008 dmueller@suse.de
- update to 2008g:
  * Pakistan, Mauritius, Gaza, Argentina, Brazil, Mongolia,
    Morocco, Cuba, Chile
* Mon Sep 29 2008 mvyskocil@suse.cz
- Moved the timezone-java to separate specfile (adrian's request for better
  bootstrapping of SUSE)
* Wed Sep 10 2008 mvyskocil@suse.cz
- Remove a rht renaming hack, because is not necessary in SUSE's build system
  and move the javazic to a new package
- Use a gcc-gij as a default java implementation
- Use a %%setup macro instead of tar -xf
- Use javazi as a destination directory for java zone info files.
* Fri Sep  5 2008 mvyskocil@suse.cz
- Add new java subpackage (necessary for openjdk)
* Tue Jun  3 2008 pbaudis@suse.cz
- Update to version 2008c (Marocco, Mongolia, Pakistan DST changes)
  [bnc#396308]
* Wed Apr  2 2008 pbaudis@suse.cz
- Update to version 2008b (esp. Chile, Cuba, Iraq, Syria DST changes)
  [bnc#368760]
* Fri Jan 25 2008 pbaudis@suse.cz
- Update to version 2007k (esp. Argentina DST change) [#350489]
* Wed Jan 16 2008 schwab@suse.de
- Use RPM_OPT_FLAGS.
* Thu Dec  6 2007 pbaudis@suse.cz
- Update to version 2007j (esp. Venezuela time shift)
* Sun Oct  7 2007 pbaudis@suse.cz
- Update to version 2007h
* Sat Sep  8 2007 pbaudis@suse.cz
- Fix %%post script to work in patch RPMs as well
* Tue Aug 21 2007 pbaudis@suse.cz
- Update to version 2007g
* Wed Aug  8 2007 pbaudis@suse.cz
- Fix %%post if /etc/localtime doesn't exist yet
* Fri Aug  3 2007 pbaudis@suse.cz
- Split timezone package to a separate physical package
* Fri Jul 27 2007 aj@suse.de
- Use fdupes to reduce timezone data size.
* Fri Jul 13 2007 schwab@suse.de
- Update to head of glibc-2.6 branch.
- Fix update on ppc.
* Thu Jun 28 2007 matz@suse.de
- Add a provide for "rtld(GNU_HASH)".
* Sun Jun 17 2007 schwab@suse.de
- Fix section selection in crt objects.
* Thu Jun  7 2007 pbaudis@suse.cz
- Backport fix for crashing printf() of some invalid ldouble values
* Wed May 30 2007 pbaudis@suse.cz
- Added few fixes from 2.6 CVS before 2.6.1 gets released
* Fri May 18 2007 pbaudis@suse.cz
- Update glibc to version 2.6
- Update tzdata to version 2007f
* Fri May  4 2007 schwab@suse.de
- Update build checks.
* Fri Apr 20 2007 dmueller@suse.de
- only keep symtab for libpthread*
* Thu Apr 19 2007 pbaudis@suse.cz
- Fix strtod() exponent limit calculations [#230909]
- Fix random nscd crashes under very heavy passwd/group queries
  load [#192391]
- Add some enums from CVS to sys/personality.h [#253710]
- Fix pthread_atfork()-induced hangs in threaded programs [#256237]
- Fix llrintl() on ppc64 [#241183]
- Fix makecontext() segfault [#249780]
- Fix potential dladdr() breakage [#241464]
- Fix some races in client programs with nscd garbage collection [#252138]
* Fri Mar 30 2007 pbaudis@suse.cz
- Update localtime during timezone update [#239888]
* Sun Mar 25 2007 olh@suse.de
- temporary disable powerpc cputuned libs to reduce turnaround time
* Fri Feb  9 2007 pbaudis@suse.cz
- Update to the latest upstream timezone data [#231833]
* Fri Feb  2 2007 schwab@suse.de
- Remove -ffortify.
* Thu Feb  1 2007 schwab@suse.de
- Remove -fstack-protector.
* Mon Jan 29 2007 sbrabec@suse.cz
- Removed references to /opt/gnome.
* Thu Jan 25 2007 olh@suse.de
- link power4 to ppc970, link power6 to power6x
- Update the powerpc cpu-tuned environment to v0.05
* Mon Jan 22 2007 schwab@suse.de
- Update ppc build check.
* Fri Nov 24 2006 pbaudis@suse.cz
- Fix for Brazilian and Wester Australia timezone DSTs [#213375,#223196]
* Thu Nov 16 2006 pbaudis@suse.cz
- Disable power6 optimization for 10.2, not all pieces are there
  [#219962]
* Wed Oct 25 2006 pbaudis@suse.cz
- Change ld.so madvise() call to posix_fadvise()
- Fix mallopt(M_MXFAST,0) behaviour [#198760]
- Update the powerpc cpu-tuned environment to v0.04 [#215117]
* Sun Oct 22 2006 pbaudis@suse.cz
- Update the powerpc cpu-tuned environment to v0.03 [#212549]
- Improve glibc powerpc optimization [#212548,#212580,#214282]
* Tue Oct 17 2006 mls@suse.de
- add ldconfig-old-cache patch to speed up ldconfig
* Sat Oct 14 2006 olh@suse.de
- dont use uninitialized (and wrong) variable in glibc-2.4.90-bdirect.diff
  [#212470]
* Thu Oct 12 2006 pbaudis@suse.cz
- Update to the latest 2.5 CVS
- More friendly -Bdirect behaviour in case of missing libraries
- Fix 2.4.90-nscd patch wrt. new gcc
* Mon Oct  2 2006 aj@suse.de
- Fix warnings in testsuite (patch from CVS).
* Fri Sep 29 2006 pbaudis@suse.cz
- Update to 2.5 CVS - official release (only minimal changes in CVS
  since the last update)
- Fix a thinko in the -Bdirect patch
* Fri Sep 29 2006 dmueller@suse.de
- fix devel requires
* Fri Sep 29 2006 pbaudis@suse.cz
- Make the dynamic linker support direct bindings (Michael Meeks'
  Solaris-like -Bdirect with minor changes by me)
- Split the kernel headers to a new package (linux-kernel-headers)
* Wed Sep 27 2006 schwab@suse.de
- Fix broken assertion [#208189].
* Tue Sep 26 2006 pbaudis@suse.cz
- Fix mistake when removing some patches
* Mon Sep 25 2006 pbaudis@suse.cz
- Update to current CVS
* Sat Sep 23 2006 pbaudis@suse.cz
- Fix 64bit-cleanliness gcc warnings
* Thu Sep 21 2006 pbaudis@suse.cz
- Add /usr/lib{,64}/Xaw3d to /etc/ld.so.conf (by schwab@suse.de,
  from original STABLE) [#205169]
- Fix chown() instead of lchown() called in fchownat() emulation
  [#201751]
- Fix glob() overflowing stack when producing massive number of
  matches [#190458]
- Update to current CVS
* Wed Sep 20 2006 pbaudis@suse.cz
- Fix cut'n'paste error in a last-minute change
* Wed Sep 20 2006 pbaudis@suse.cz
- Update to current CVS
- Fix powerpc-cpu tarball extension
- Move crypt-blowfish to a patch so that quilt works on the tree
* Sat Sep  2 2006 schwab@suse.de
- Use asm-powerpc for ppc and ppc64.
- Fix chroot check in glibc_post_upgrade.
* Sun Aug 27 2006 pbaudis@suse.cz
- Update to current CVS, should fix false positive heap overflow
  trigger from malloc() causing gcc to hang [#201724]
* Wed Aug 23 2006 pbaudis@suse.cz
- Update the powerpc cpu-tuned environment to v0.02 [#199274]
- Update to current CVS
- Drop pthread_mutexattr_getprioceiling() out of range fix
* Thu Aug 10 2006 pbaudis@suse.cz
  Ported from STABLE:
- Remove libc5 reference from /etc/ld.so.conf, shlibs5 is no longer
  supported [#181947]
- Fix name of a dummy ia64 header from offsets.h to asm-offsets.h
  [#191394]
* Sun Jul 30 2006 pbaudis@suse.cz
- Update to current CVS snapshot (highlight: support for .gnu.hash
  fast linking support)
* Wed Jul 12 2006 pbaudis@suse.cz
- pthread_mutexattr_getprioceiling() was returning prioceiling out
  of range [#182782]
* Wed Jul 12 2006 pbaudis@suse.cz
- Fix the HTML documentation missing an index [#190585]
* Sat Jun 24 2006 kukuk@suse.de
- Update to current CVS snapshot
- Update to kernel-headers 2.6.17
- Remove HZ define (sysconf(_SC_CLK_TCK) instead)
* Tue Jun 13 2006 kukuk@suse.de
- Update to current CVS snapshot
* Tue May  2 2006 pbaudis@suse.cz
- Fix bad memset() size in NTPL code [#159184]
* Tue May  2 2006 kukuk@suse.de
- asm-powerpc/page.h: Don't move #ifdef __KERNEL__ [#171010]
- bits/mman.h: Fix value of MADV_REMOVE [#170734]
* Mon Apr 24 2006 kukuk@suse.de
- Fix china timezone mess [#163674]
- Don't include linux/stddef.h [#167964]
* Tue Apr 18 2006 schwab@suse.de
- Sanitize <asm-powerpc/sigcontext.h>.
* Thu Apr 13 2006 kukuk@suse.de
- Add /usr/include/linux/taskstats.h [#141936]
* Tue Apr 11 2006 kukuk@suse.de
- nptl/init.c (sigcancel_handler): Compare with correct PID even
  if the thread is in the middle of a fork call.
  (sighandler_setxid): Likewise.
* Sun Apr  9 2006 ihno@suse.de
- S390 fix for startupcode. Part of it was not PIC.
* Fri Apr  7 2006 kukuk@suse.de
- Don't hardcode syscall numbers at our own
* Tue Apr  4 2006 schwab@suse.de
- Fix readlink declaration.
* Mon Apr  3 2006 kukuk@suse.de
- Update from CVS:
  - nscd bug fixes
  - Match return value of readlink to what POSIX says
  - Fix NIS+ checks for NULL pointer
* Sun Apr  2 2006 dmueller@suse.de
- Fix clients crash if nscd is unresponsive (glibc-#2501)
- Fix fd leak in nscd daemon (glibc-#2498)
* Sat Apr  1 2006 schwab@suse.de
- Fix <sys/procfs.h> on ppc64.
* Fri Mar 31 2006 schwab@suse.de
- Extend last change also to ppc64.
* Sun Mar 26 2006 schwab@suse.de
- Terminate FDE before clone syscall.
* Fri Mar 24 2006 ro@suse.de
- kernel-headers: asm-powerpc: define PAGE_MASK in page.h
* Mon Mar 20 2006 kukuk@suse.de
- Update to final 2.6.16 kernel headers
- Update to current CVS:
  - Don't use TLS before setting it up.
  - Fix rounding of long doubles on ppc64.
  - Correct usage of cfi_offset on ppc/ppc64.
  - Fix memory leak in dlopen.
* Tue Mar 14 2006 schwab@suse.de
- Update fnmatch patch.
* Fri Mar 10 2006 kukuk@suse.de
- Disable unshare() syscall (request of kernel developer)
* Fri Mar 10 2006 kukuk@suse.de
- Don't include linux/interrupt.h from linux/rtc.h
- Revert last change to linux/input.h, disable struct
- Update to current CVS (nptl/ia64 fix)
* Thu Mar  9 2006 kukuk@suse.de
- Fix linux/input.h for userspace inclusion
* Wed Mar  8 2006 kukuk@suse.de
- Update kernel headers to 2.6.16-rc5
* Mon Mar  6 2006 kukuk@suse.de
- Update to 2.4 CVS
  - official release
  - Fix free on ppc [#155374]
  - Various sysconf() fixes
* Sat Mar  4 2006 kukuk@suse.de
- Update to CVS
  - ldconfig/prelink fixes
* Fri Mar  3 2006 aj@suse.de
- Do not leave hyphens in defines in create_biarch_asm.sh (Bug 154998).
* Fri Mar  3 2006 kukuk@suse.de
- Update to CVS
  - Fix ftw test suite failures
  - Fix alignment of malloc for long double
* Thu Mar  2 2006 kukuk@suse.de
- Update to 2.3.91 CVS
  - Fix 6arg syscall on s390x
  - memccpy fix on IA64
* Wed Mar  1 2006 kukuk@suse.de
- Update to CVS
  - New linkat interface
  - Update from tzdata2006b
  - Define MADV_DONTFORK and MADV_DOFORK.
  - Add robust mutex to NPTL
* Thu Feb 23 2006 kukuk@suse.de
- Reenable power optimized code again [#142839]
* Sun Feb 12 2006 kukuk@suse.de
- Disable power optimized code
* Thu Feb  9 2006 kukuk@suse.de
- Update to CVS
  - Add unshare prototype
  - Add memory barrier on i386/NPTL
* Wed Feb  8 2006 kukuk@suse.de
- Remove glibc-2.4-ppc-dl-procinfo-20060111.diff [#142839]
* Mon Feb  6 2006 kukuk@suse.de
- Update to current CVS
- Fix alternate locale search path patch [#147685]
* Thu Feb  2 2006 kukuk@suse.de
- Update to current CVS
* Mon Jan 30 2006 schwab@suse.de
- Fix the fix.
* Sat Jan 28 2006 kukuk@suse.de
- Fix seg.fault in __atfct_seterrno if called from futimesat()
- Apply patches for CPU-Tuned Environment on Power [#142839]
* Fri Jan 27 2006 kukuk@suse.de
- Cleanup ld.so.conf
* Thu Jan 26 2006 kukuk@suse.de
- Add alternate directory for translations [#144073]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Mon Jan 23 2006 kukuk@suse.de
- Update to CVS
- Fix build_locales
* Sat Jan 21 2006 kukuk@suse.de
- Update to CVS
- Fix inclusion of sys/poll.h with _GNU_SOURCE defined
* Fri Jan 20 2006 kukuk@suse.de
- Update to CVS
* Sun Jan 15 2006 kukuk@suse.de
- Update to CVS (fix long double configure check)
* Sun Jan 15 2006 schwab@suse.de
- Readd <fmtmsg.h>, <ucontext.h>, <sys/ucontext.h>.
* Sun Jan 15 2006 schwab@suse.de
- Readd <alloca.h>.
* Sat Jan 14 2006 kukuk@suse.de
- Update to current CVS (long double support)
* Fri Jan 13 2006 aj@suse.de
- Fix x86-64 w_exp to not use extra plt.
* Thu Jan 12 2006 kukuk@suse.de
- Fix asm-s390/setup.h for userspace inclusion
- nsswitch.conf: Add nis to netgroup and automount entry
- Fix sys/procfs.h for ppc64
* Mon Jan  9 2006 kukuk@suse.de
- Update to current CVS (fix for pthread.h with -std=c99)
- Define PAGE_SIZE on POWER
- Don't include linux/sched.h in asm-power/elf.h
* Sun Jan  8 2006 kukuk@suse.de
- Fix linux/acct.h for userland inclusion
* Sun Jan  8 2006 kukuk@suse.de
- Update to current CVS
- Remove CHILD_MAX from kernel-headers
- Copy subdirectories of asm-power, too.
- Remove da_DK@euro (does not exist)
* Sat Jan  7 2006 kukuk@suse.de
- Fix ext2 kernel headers
- Update to current CVS
* Fri Jan  6 2006 kukuk@suse.de
- Update to kernel headers 2.6.15
* Thu Jan  5 2006 kukuk@suse.de
- Update crypt_blowfish to version 1.0
- Update to current CVS
- Adjust nscd patches
* Tue Jan  3 2006 aj@suse.de
- Update to current CVS to fix pthread.h on 64-bit systems for C++.
* Tue Jan  3 2006 aj@suse.de
- Enable string patch again.
- Update to current CVS.
* Wed Dec 21 2005 kukuk@suse.de
- Update to current CVS
- Fix ldconfig
* Sat Dec 17 2005 kukuk@suse.de
- Remove /usr/lib/zoneinfo
- Add /etc/localtime to filelist
- Update to current CVS
- Fix glibc #1978: statvfs does not know about current filesystems
- Fix wrong error return code of time() on x86
- Remove nscd_nischeck
- Remove audit from nfb
- Remove LinuxThreads
* Wed Dec 14 2005 kukuk@suse.de
- Update to current CVS
- Remove nscd_nischeck
- Remove audit from nfb
* Mon Dec  5 2005 kukuk@suse.de
- Update to current CVS
- Disable SELinux
* Thu Nov 24 2005 kukuk@suse.de
- Remove obsolete patches:
  - glibc-2.3.asprintf-error_handling.diff
  - glibc-2.3.90-missing-string_h.diff
* Wed Nov 23 2005 kukuk@suse.de
- Update to current CVS
- Don't install in parallel
* Fri Nov 18 2005 kukuk@suse.de
- Update to current CVS to fix compiling with new binutils
* Wed Nov 16 2005 kukuk@suse.de
- Update to current CVS
* Sat Nov  5 2005 kukuk@suse.de
- Update to current CVS
- Disable linuxthreads on POWER and Itanium
- Fix kernel-headers for userland inclusion
* Wed Nov  2 2005 kukuk@suse.de
- Update to current CVS
- Update to kernel-headers 2.6.14
* Tue Oct 18 2005 kukuk@suse.de
- Update to current CVS
* Sat Oct  1 2005 schwab@suse.de
- Update libm ULPs.
- Fix limit in getcwd.
* Thu Sep 15 2005 kukuk@suse.de
- Update to current CVS
- Update to final 2.6.13 kernel headers
- Adjust bindresvport.blacklist patch to check already ports >= 512
* Fri Aug 26 2005 kukuk@suse.de
- Update to current CVS
- init.d/nscd: Remove -S support (was removed from nscd)
* Fri Aug 19 2005 schwab@suse.de
- Fix comment.
* Fri Aug 19 2005 matz@suse.de
- Change .note.SuSE format [#105825].
* Fri Aug 19 2005 kukuk@suse.de
- Update to current CVS
- Move all obsolete libraries into own subpackage and document
  them as obsolete
* Fri Aug  5 2005 schwab@suse.de
- -mno-tls-direct-seg-refs is x86-only
* Tue Aug  2 2005 kukuk@suse.de
- Update to 2.3.x CVS branch
- Compile with -mno-tls-direct-seg-refs
* Fri Jul 29 2005 kukuk@suse.de
- Update to current CVS head
* Wed Jul 27 2005 schwab@suse.de
- Update libm ULPs for ia64.
- Add linuxthreads stack guard support for ia64.
* Sat Jul 23 2005 kukuk@suse.de
- Update to current CVS head (adds bits/wchar2.h)
- Move LinuxThreads version to obsolete/linuxthreads
* Thu Jul 21 2005 kukuk@suse.de
- Update to current CVS head
* Fri Jul 15 2005 schwab@suse.de
- Fix file list.
* Fri Jul 15 2005 aj@suse.de
- Fix amd64 string routines and math routines.
* Fri Jul 15 2005 kukuk@suse.de
- Use old LinuxThreads only for runtime and remove static version
  and headers
- Update to current CVS head
- Remove own texi2html
* Mon Jul 11 2005 kukuk@suse.de
- Install generic stdio-lock.h header file
* Sat Jul  9 2005 kukuk@suse.de
- Temporary disable AMD64 string optimization
* Wed Jul  6 2005 kukuk@suse.de
- Build and install ja_JP.SHIFT_JISX0213 locale [Bug #84030]
* Mon Jul  4 2005 kukuk@suse.de
- nss_compat: Preserve original return value [Bug #95033]
- Cleanup old Obsoletes/Requires
* Mon Jun 27 2005 kukuk@suse.de
- Update to current gilbc CVS snapshot
* Thu Jun 23 2005 kukuk@suse.de
- Update to current glibc CVS snapshot
- Adjust nscd patch
- Enable SELinux/audit support for nscd
- Update .note.SuSE version
* Mon Jun 20 2005 kukuk@suse.de
- Update to final 2.6.12 kernel headers
- Update to current glibc CVS snapshot
* Thu Jun 16 2005 kukuk@suse.de
- Update linux/audit.h header
- Update to current CVS snapshot
* Mon Jun 13 2005 kukuk@suse.de
- Don't terminate strings twice in nis/netgroup code.
- netinet/if_tr.h: don't include kernel headers.
* Wed Jun  8 2005 kukuk@suse.de
- Update to kernel-headers 2.6.12-rc6
- Fix build on s390 and s390x
* Wed Jun  8 2005 matz@suse.de
- Don't strip .symtab from libpthread.so.0 (and other libs).
  Fixes debugging of threaded programs (#81253).
* Mon Jun  6 2005 kukuk@suse.de
- Update to current CVS head
- Update to kernel-headers 2.6.12-rc5
* Thu May 26 2005 schwab@suse.de
- No longer build loadlocale.c with -fno-unit-at-a-time.
* Tue May 24 2005 kukuk@suse.de
- Update to current CVS head, obsoletes:
  - glibc-2.3.90-libm.diff
  - glibc-2.3.90-i386-sysdep.diff
  - warn.diff
  - dl-osinfo.diff
  Adjusted:
  - glibc-2.3.90-bindresvport.blacklist.diff
* Sat May 21 2005 schwab@suse.de
- Fix missing include.
* Tue May 17 2005 schwab@suse.de
- Fix warning.
* Fri Apr 29 2005 kukuk@suse.de
- Update to latest CVS snapshost
* Sat Apr 23 2005 kukuk@suse.de
- Fix all the archs using wrong FLAGS
* Sat Apr 23 2005 kukuk@suse.de
- Remove -D_FORTIFY_SOURCE from RPM_OPT_FLAGS
* Fri Apr 22 2005 kukuk@suse.de
- Update to current CVS
* Fri Apr 22 2005 kukuk@suse.de
- Check if nice value does not conflict with test suite
* Tue Apr 19 2005 mls@suse.de
- resolv: trigger re-read of /etc/resolv.conf for all threads if
  a change is detected
- nscd: support a negative timeout of zero, used by hosts cache
* Mon Apr 18 2005 meissner@suse.de
- Enable fortify possibility even for GCC 4.0, we apply
  the necessary patch to the SUSE GCC 4.0.
* Sat Apr 16 2005 aj@suse.de
- Apply amd64 string diff again.
* Tue Apr 12 2005 kukuk@suse.de
- Update kernel-headers to 2.6.10
- Update to current CVS snapshot
* Wed Apr  6 2005 schwab@suse.de
- Cleanup neededforbuild.
* Tue Apr  5 2005 aj@suse.de
- Add gettext-devel to neededforbuild.
* Tue Apr  5 2005 aj@suse.de
- Do not build on xen machines.
- Adjust libm ULPs for PowerPC.
* Fri Apr  1 2005 kukuk@suse.de
- Update to current CVS snapshot
* Tue Mar 29 2005 kukuk@suse.de
- Update to current CVS snapshot
- Fix compiler warnings on ix86
* Mon Mar 28 2005 kukuk@suse.de
- Update to current CVS snapshot
- Disable Noversion Patch on i386 temporary
* Fri Mar 18 2005 ro@suse.de
- check-build.sh: require 2.6.11 on x86,x86_64 for build
* Thu Mar 17 2005 mls@suse.de
- nscd: enable hosts cache
- nscd: also watch /etc/resolv.conf
- nscd: check files every 3 seconds
- nscd: deal correctly with missing files
* Tue Mar 15 2005 kukuk@suse.de
- Update to current CVS snapshot.
* Sat Feb 12 2005 schwab@suse.de
- Remove const from __pthread_internal_tsd_address.
* Fri Feb 11 2005 schwab@suse.de
- Update to current CVS.
- Link glibc_post_upgrade against new libc.
- Fix build error with gcc4.
* Wed Feb  9 2005 kukuk@suse.de
- Update to current CVS
- Fix bindresvport blacklist handling.
- Increase buffer in tst-cancel17 to match new kernel buffer size
  [#50277]
- Enable LinuxThreads again
- Remove ia64-audit patch (is upstream)
* Mon Feb  7 2005 aj@suse.de
- Add patch to allow compilation with gcc4.
* Mon Jan 31 2005 schwab@suse.de
- Readd support for LD_AUDIT on ia64.
* Mon Jan 31 2005 kukuk@suse.de
- Add memory clobber to string inline assemblies on s390 [#50284].
* Mon Jan 31 2005 kukuk@suse.de
- Fix filelist on i686 if we build NPTL only version
* Mon Jan 31 2005 aj@suse.de
- Generate new ULPs file for i386 needed by GCC 4.
* Sun Jan 30 2005 kukuk@suse.de
- Include own copy of texi2html
- Add glibc_pst_upgrade program (based on version from FC3)
- Update to current CVS
* Thu Jan 27 2005 kukuk@suse.de
- Re-add patch for timezone/zic.c (got lost with last merge)
* Wed Jan 26 2005 kukuk@suse.de
- Update timezone data to 2005c release (fixes zdump crash on
  64bit architectures)
* Sat Jan 22 2005 schwab@suse.de
- Add basic (incomplete) support for LD_AUDIT on ia64.
* Fri Jan 21 2005 kukuk@suse.de
- Enable patch for [Bug #49833]
- Allow to build NPTL only glibc
- Update to CVS from Jan 16, 2005, containing:
- Fix execlp argument in SunRPC code [glibc #681]
- Fix errno return values for futimes [glibc #633]
- Update FPU function on PPC/PPC64 [Bug #49764]
* Mon Jan 17 2005 aj@suse.de
- Enable amd64 string patch again after fixing failing hunks.
- Handle missing cpuid better for amd64 string functions. [#49803]
* Sat Jan 15 2005 aj@suse.de
- Fix amd64 string patch to use correct datatype.
* Fri Jan 14 2005 kukuk@suse.de
- Fix memory corruption in getgrouplist function [Bug #49833]
* Tue Jan 11 2005 kukuk@suse.de
- Enable all LinuxThreads tests again
- Finalize getconf -a patch (make it compatible with Solaris)
- Rewrite getconf manual page and mention new option
- Merge GB18030 patches into one.
* Thu Dec 30 2004 kukuk@suse.de
- Merge kernel-headers.remove-SO_BSDCOMPAT.diff with
  kernel-headers.SuSE.diff
- Revert nscd paths on old SuSE Linux distributions
* Wed Dec 29 2004 kukuk@suse.de
- Update to glibc 2.3.90 CVS branch
- Remove alarm-round.patch (merged upstream)
* Thu Dec  9 2004 kukuk@suse.de
- Update to current CVS
- Move nscd persistent database files back to /var/run/nscd
* Mon Dec  6 2004 kukuk@suse.de
- Update to current CVS
- Fix more kernel headers for userland inclusion
* Fri Nov 26 2004 ro@suse.de
- kernel-headers.diff: define __force in compiler.h
* Thu Nov 25 2004 schwab@suse.de
- Add Intel libm update.
* Thu Nov 25 2004 kukuk@suse.de
- Update to current glibc CVS
- Update kernel headers to 2.6.9
* Thu Nov 18 2004 kukuk@suse.de
- Update to current glibc CVS
* Mon Nov 15 2004 kukuk@suse.de
- Update to current glibc CVS
* Mon Nov  8 2004 kukuk@suse.de
- Blacklist port 921 (lwresd) for usage by bindresvport()
- Update to current glibc CVS
- Add /var/run/nscd/* files as ghost entries
* Mon Oct 18 2004 aj@suse.de
- Don't use special fdim functions for x86-64 since those give
  wrong results for fdim (inf,inf).
- Fix ppc64 rebuild issue with ppc32 system [#47325].
* Wed Oct 13 2004 kukuk@suse.de
- Fix symlink librt.so -> tls/librt.so.1
- Backout last glob changes
- Disable nptl as default for linking
* Tue Oct 12 2004 kukuk@suse.de
- Install kernel-headers after merging linuxthreads/NPTL headers
* Tue Oct 12 2004 kukuk@suse.de
- Update to current CVS snapshot
* Mon Oct 11 2004 kukuk@suse.de
- Make NPTL default for linking
* Fri Oct  1 2004 kukuk@suse.de
- Update to current CVS snapshot
- Add workaround for linuxthreads/without-__threads bug
- Remove KDE/ldconfig workaround
- Set SuSE ABI note to 9.3
* Sun Sep 26 2004 kukuk@suse.de
- Add lib/nptl/librt.so symlink to tls/librt.so.1
- Update to current CVS
* Sat Sep 25 2004 kukuk@suse.de
- Implement mq support for rtkaio and enable it again
* Fri Sep 24 2004 kukuk@suse.de
- Add zh_SG.UTF-8 [Bug #46024]
* Thu Sep 23 2004 kukuk@suse.de
- Sync sys/mount.h and linux/fs.h
* Wed Sep 22 2004 kukuk@suse.de
- Make mdns support configurable in /etc/host.conf
* Mon Sep 20 2004 kukuk@suse.de
- Fix invalidating of nscd caches and getaddrinfo()
* Fri Sep 17 2004 kukuk@suse.de
- Update to current CVS (nscd and glob.h fixes)
* Thu Sep 16 2004 kukuk@suse.de
- Fix getaddrinfo/nscd support
* Wed Sep 15 2004 kukuk@suse.de
- Update to current CVS, remove merged patches
* Sun Sep 12 2004 kukuk@suse.de
- Update to CVS: Fix nscd crash if one service is disabled
- glob.h: Add workaround for invalid prototypes
- nss_compat: Check that buffer is larger than 0 bytes
* Fri Sep 10 2004 kukuk@suse.de
- Update to CVS: Fix cdefs.h for C++ usage
* Fri Sep 10 2004 kukuk@suse.de
- Add lwres to hosts search order in nsswitch.conf
- Update to current CVS
- Use new nscd paths for socket/pid file
- Enable NPTL on i586
- Add --print-all option to getconf
* Thu Sep  2 2004 kukuk@suse.de
- Fix NPTL header files on x86-64 for 32bit compilation
- Apply various fixes from CVS
- Remove pre-Install for -devel package (no longer necessary)
* Wed Aug 25 2004 kukuk@suse.de
- Don't compile in eval.c
* Mon Aug 23 2004 kukuk@suse.de
- Update to current CVS:
  - Use CVS version for last fix.
  - Add malloc sanity checks for double free.
* Fri Aug 20 2004 schwab@suse.de
- Fix cancellable syscalls in librt w/ linuxthreads.
* Fri Aug 20 2004 kukuk@suse.de
- Update to current CVS [#43993]
* Thu Aug 19 2004 schwab@suse.de
- Better fix for asm-ia64/gcc_intrin.h.
* Wed Aug 18 2004 kukuk@suse.de
- Update to current CVS
- Workaround linux/ixjuser.h problem not including compiler.h
- Workaround linux/capi.h problem not including compiler.h
* Tue Aug 17 2004 schwab@suse.de
- Fix asm-ia64/gcc_intrin.h.
* Tue Aug 17 2004 kukuk@suse.de
- Workaround broken linux/crc-ccitt.h for usage from glibc [#43884]
* Mon Aug 16 2004 kukuk@suse.de
- Update to current CVS version and update to
  kernel-headers 2.6.8.1 to fix NPTL deadlock problems
- Disable linuxthreads/tst-clock1, does not work on i586 and lower
* Fri Aug 13 2004 kukuk@suse.de
- Update to current CVS version
- Cleanup/adjust all patches
* Thu Jun 17 2004 kukuk@suse.de
- Fix sched_setaffinity return/errno code in error case [#42124]
* Wed Jun 16 2004 meissner@suse.de
- Updated altivec set/get/swapcontext patch to fix
  more problems on altivec capable machines [#42039].
- glibc is also able to build on -pmac64 kernels.
* Mon Jun 14 2004 kukuk@suse.de
- Add fixes from CVS:
  - sysconf return value fixes
  - nscd host caching deadlock
  - backtrace for s390/s390x/ia64 static linked binaries
* Mon Jun 14 2004 kukuk@suse.de
- Increase listen backlog in RPC code [#41955]
* Wed Jun  9 2004 meissner@suse.de
- Fixed typos in powerpc* *context functions to not destroy the r19
  register and save the v19 register correctly. [#41790]
* Sat Jun  5 2004 aj@suse.de
- Fix makecontext with more than 6 arguments on x86-64 [#40546].
* Mon May 24 2004 kukuk@suse.de
- Update to kernel-headers 2.6.6
- Update to current glibc CVS
- Disable rtkaio temporary
* Sun May 23 2004 kukuk@suse.de
- Fix pthread_cond_wait on not ix86 and x86-64 architectures
* Thu May 20 2004 kukuk@suse.de
- Add PPC64 kernel header file fixes [#40831,#40870]
* Wed May 19 2004 kukuk@suse.de
- Add additional NPTL fixes from CVS
* Tue May 18 2004 schwab@suse.de
- Fix mapping of DSOs with holes.
* Fri May 14 2004 schwab@suse.de
- Fix rounding in alarm [#40552].
* Wed May 12 2004 schwab@suse.de
- Fix uninitialized array in regexp compiler [#40009].
* Tue May 11 2004 kukuk@suse.de
- Apply lot of fixes from current CVS
- Fix alignment of stack for makecontext on x86-64 [Bug #39413]
- Make XTABS identical to TABDLY on PPC
* Wed May  5 2004 kukuk@suse.de
- Add some header fixes to match POSIX
* Tue May  4 2004 meissner@suse.de
- Fix INLINE_SYSCALL on ppc and ppc64 (see #38399)
* Mon May  3 2004 kukuk@suse.de
- Port --mlock option for ld.so from UL1 [Bug #39569]
* Tue Apr 20 2004 kukuk@suse.de
- Add execstack fix for s390
* Mon Apr 19 2004 kukuk@suse.de
- Update to current CVS version (fix problems with new binutils
  and gcc)
* Mon Apr 19 2004 kukuk@suse.de
- Add pthread_getattr_np and syslog fixes from CVS
- Update gb18030 and big5hkscs gconv modules [Bug #39080]
* Sat Apr 17 2004 schwab@suse.de
- Pacify autobuild.
* Thu Apr 15 2004 kukuk@suse.de
- Add /etc/ld.so.conf.d/*.conf to /etc/ld.so.conf
- Disable FUTEX_REQUEUE support in NPTL library [Bug #38882]
* Wed Apr 14 2004 schwab@suse.de
- Remove /usr/i386-linux from ld.so.conf,
* Wed Apr 14 2004 kukuk@suse.de
- Fix linux/compiler.h for glibc inclusion
- Really fix ffsl on s390x
* Fri Apr  9 2004 schwab@suse.de
- Fix syntax error in memcmp.
* Fri Apr  9 2004 kukuk@suse.de
- Update from CVS: linuxthread debug fixes
- Fix INLINE_SYSCALL on x86-64 and ia64 (fixes #38399)
- Fix ffsl weak alias on s390x
- Update to 2.6.5 kernel headers
* Wed Apr  7 2004 meissner@suse.de
- forward umount to umount2 on ppc64 because umount syscall
  does not exist
* Mon Apr  5 2004 kukuk@suse.de
- Sync with current CVS (which is nearly identical with most of
  our latest patches)
* Fri Apr  2 2004 kukuk@suse.de
- Make fstatvfs64 working on 32bit architectures
- Add fwrite LFS fix from aj
- Add powerpc fixes from CVS
- Fix wrong errno code for shm_unlink [Bug #38013]
* Wed Mar 31 2004 kukuk@suse.de
- Add three fixes from CVS:
  - Call __nptl_deallocate_tsd for main thread, too
  - setgroups: optimizations for huge number of groups
  - initgroups: Limit the initial allocation to 64 entries
* Tue Mar 30 2004 kukuk@suse.de
- Add IUTF8 to bits/termios.h [Bug #34725]
- *affinitiy.c: Prepend GLIBC_ to version names
* Sat Mar 27 2004 kukuk@suse.de
- Fix wrong return value of getXXbyYY_r in case key was not
  found [Bug #37181]
- Fix typo in dl-open
- Don't set errno in NSS NIS module if group was not found
* Fri Mar 26 2004 aj@suse.de
- Add pow10/pow10f aliases for AMD64.
* Thu Mar 25 2004 kukuk@suse.de
- Update to latest CVS snapshot
* Sat Mar 20 2004 aj@suse.de
- Fix further problems with sched_[sg]etaffinity calls.
* Fri Mar 19 2004 aj@suse.de
- Fix sched_setaffinity compile problem.
* Fri Mar 19 2004 kukuk@suse.de
- Remove conflict with special aaa_base version (rpm will handle
  this with file conflict)
* Fri Mar 19 2004 kukuk@suse.de
- Add SuSE abi note
- Add madvise patch
- Update to current CVS
* Wed Mar 17 2004 kukuk@suse.de
- Use official NPTL version fix
- Add LD_DEBUG=statistic for x86-64
- Fix two JB_SIZE redefinitions on PPC
- Add two fixes for execstack
* Mon Mar 15 2004 kukuk@suse.de
- Require kernel 2.6.4 for glibc/NPTL
- Remove siginfo_t/si_band patch (needs to be fixed in kernel)
- Update linuxthreads_db and nptl_db
- Add libidn fixes from CVS
* Sat Mar 13 2004 kukuk@suse.de
- Adjust filelist (remove libcidn.a and libcidn_p.a)
* Sat Mar 13 2004 kukuk@suse.de
- Update to current CVS (merge of patches)
- Fix siginfo_t/si_band [Bug #34330]
* Thu Mar 11 2004 mls@suse.de
- Add mdns support to resolver library
* Thu Mar 11 2004 kukuk@suse.de
- Update kernel headers to 2.6.4
- Update to current glibc CVS
* Wed Mar 10 2004 bg@suse.de
- Update hppa patches.
* Mon Mar  8 2004 kukuk@suse.de
- Fix vDSO on IA64
* Mon Mar  8 2004 kukuk@suse.de
- Update from glibc CVS:
  - Add libidn
  - Lot of dynamic loader changes
* Thu Mar  4 2004 kukuk@suse.de
- Update from glibc CVS:
  - Fix posix_fadvise vs. posix_fadvise64
* Tue Mar  2 2004 kukuk@suse.de
- Fix PPC kernel header files
- Update from glibc CVS
  - NPTL fixes
  - nscd fixes
* Tue Mar  2 2004 schwab@suse.de
- Fix ppc32 to always use stat64 syscall.
* Sat Feb 28 2004 kukuk@suse.de
- Update from glibc CVS:
  - Fix compiler warnings
  - NPTL: Don't use CLONE_STOPPED
  - Revert vDSO changes
* Fri Feb 27 2004 kukuk@suse.de
- Update from glibc CVS:
  - Real NGROUP_MAX fix
  - Lot of NPTL fixes
  - clock_settime fix
- Add no_NO back (required by OpenI18N spec and [Bug #34745])
* Thu Feb 26 2004 kukuk@suse.de
- Workaround broken NGROUP_MAX function
* Thu Feb 26 2004 kukuk@suse.de
- Add insserv PreRequires for nscd
- Update from CVS: NPTL and getaddrinfo memory leak fixes,
  Get NGROUP_MAX from /proc filesystem
* Sat Feb 21 2004 kukuk@suse.de
- Update from CVS: IA64 relo fix, lot of PPC fixes
- Fix linux/mod_devicetable.h for userland inclusion
- Enable NPTL on Alpha
* Fri Feb 20 2004 schwab@suse.de
- Fix pthread_barrier_wait.
* Thu Feb 19 2004 kukuk@suse.de
- Update from CVS: More NPTL fixes
- nscd.init: Cleanups
* Wed Feb 18 2004 kukuk@suse.de
- Kernel Headers: Fix asm-ppc/unaliged.h, asm-ppc/types.h and
  asm-ppc/bitops.h for userland inclusion.
* Wed Feb 18 2004 bg@suse.de
- Update hppa patches for current glibc
- Add workaround for ICE in hppa
* Tue Feb 17 2004 kukuk@suse.de
- Update from CVS:
  - PPC nptl compatiblity fix
  - NSCD patches merged
  - ld.so.preload: Igreno missing files
  - getaddrinfo: Fix problem with IPv6 addresses
* Tue Feb 17 2004 aj@suse.de
- Fix string optimizations init code on AMD64.
* Sat Feb 14 2004 kukuk@suse.de
- Update from CVS (for NPTL fixes and new PPC longjmp)
- Fix nscd deadlock with kernel 2.6 [Bug #34507]
* Fri Feb 13 2004 aj@suse.de
- Add more string/memory optimizations for AMD64.
* Thu Feb 12 2004 kukuk@suse.de
- Fix regex bug with invalid UTF-8 strings
* Thu Feb 12 2004 aj@suse.de
- Add more string optimizations for AMD64.
* Wed Feb 11 2004 kukuk@suse.de
- Update to current CVS snapshot
- Fix _IOC_TYPECHECK on s390/s390x/parisc
- Compile rtkaio only with NPTL
- Remove glibcbug (was dropped since glibc uses bugzilla now)
- Disable parallel build on s390x
* Tue Feb 10 2004 schwab@suse.de
- Work around invalid use of kernel headers in some packages.
* Fri Feb  6 2004 kukuk@suse.de
- Add kernel stat fix for PPC
- Add fix for off-by-one error in regex code
* Thu Feb  5 2004 kukuk@suse.de
- Update kernel header files to 2.6.2
* Tue Feb  3 2004 bg@suse.de
- Update hppa patch
* Tue Feb  3 2004 kukuk@suse.de
- Fix ypclnt speedup patch
- Update to current CVS snapshot
* Mon Jan 26 2004 kukuk@suse.de
- Update to current CVS snapshot
* Wed Jan 21 2004 aj@suse.de
- Do not run in parallel on s390.
* Mon Jan 19 2004 ro@suse.de
- really fix linux/percpu.h to compile in userland
* Fri Jan 16 2004 kukuk@suse.de
- Update version.h to 2.6.1
- Fix linux/percpu.h to compile in userland
- Update to current CVS snapshot
- Revert nscd path changes
* Wed Jan 14 2004 kukuk@suse.de
- Update to Kernel Headers 2.6.1
- Update to current CVS snapshot
- Don't ignore make check on IA64 any longer
* Sat Jan 10 2004 schwab@suse.de
- Locale no_NO has been renamed to nb_NO.
* Fri Jan  9 2004 kukuk@suse.de
- Temporary ignore make check on IA64 and PPC
  (known kernel/compiler bugs)
* Thu Jan  8 2004 stepan@suse.de
- fix v4l2 headers
* Wed Jan  7 2004 kukuk@suse.de
- Update to glibc CVS from 20040107
- Remove manual pages which are now part of man-pages
* Thu Dec 18 2003 kukuk@suse.de
- Update to glibc CVS from 20031218
- Update ot final 2.6.0 kernel headers
- Fix syntax error in spec file
- Update HPPA patch
* Mon Dec 15 2003 kukuk@suse.de
- Update to glibc CVS from 20031215
* Fri Dec 12 2003 kukuk@suse.de
- Update to glibc CVS from 20031212
- disable rtkaio (does not work with kernel 2.6 yet)
* Fri Dec  5 2003 kukuk@suse.de
- Update to glibc 2.3.3 CVS
- Make an extra sub package for nscd
* Thu Nov 27 2003 kukuk@suse.de
- Update to glibc CVS from 20031127
- Add nsswitch.conf (moved from aaa_base)
- Add ld.so.conf (moved from aaa_base) [Bug #33277]
- Fix ceil on AMD64
* Fri Nov 21 2003 kukuk@suse.de
- Update to glibc CVS from 20031121
- Obsolete epoll (glibc-devel contains now this header files)
* Wed Nov 19 2003 kukuk@suse.de
- Add patch so that ld.so supports linuxthreads and nptl
- PPC64 requires kernel 2.4.21
- Update to glibc CVS from 20031119
* Fri Nov 14 2003 bg@suse.de
- Add hppa patches for current glibc.
* Fri Nov 14 2003 kukuk@suse.de
- Update to glibc CVS from 20031114
- Remove PPC64 symbol version patch
* Thu Nov 13 2003 schwab@suse.de
- Fix last change covering libNoVersion.
* Mon Nov 10 2003 schwab@suse.de
- Specfile cleanup.
* Thu Nov  6 2003 kukuk@suse.de
- Update to glibc CVS from 20031106
* Wed Nov  5 2003 uli@suse.de
- added a number of ARM fixes (glibc-2.3.2-armformat.patch,
  glibc-armisa.patch, glibc-sjlj.patch)
* Mon Oct 27 2003 kukuk@suse.de
- Update to glibc CVS from 20031027
- kernel headers: update to 2.6.0-test9
- nptl: Use -fno-unit-at-a-time on AMD64, too
* Thu Oct 23 2003 kukuk@suse.de
- Update to current CVS version
* Wed Oct 22 2003 kukuk@suse.de
- nptl: Fix prototype in configure script
- nptl: Use -fno-unit-at-a-time
- locale: Add nb_NO
* Fri Oct 17 2003 kukuk@suse.de
- Increase timeout for make check on overloaded architectures
* Thu Oct 16 2003 kukuk@suse.de
- Fix building as normal user
* Wed Oct 15 2003 kukuk@suse.de
- Fix putpwent/putgrent
- Make build as normal user
* Tue Oct 14 2003 kukuk@suse.de
- Update to glibc CVS from 20031014
* Tue Oct 14 2003 aj@suse.de
- Fix w_acosf for AMD64.
* Tue Oct 14 2003 kukuk@suse.de
- Fix asm-sparc/kbio.h to compile kbdrate/X11
* Mon Oct 13 2003 kukuk@suse.de
- Update to kernel header files from 2.6.0-test7
* Fri Oct 10 2003 schwab@suse.de
- Fix misnamed syscalls.
* Tue Oct  7 2003 kukuk@suse.de
- Update to glibc CVS from 20031007
* Fri Oct  3 2003 kukuk@suse.de
- Update to glibc CVS from 20031003
- Fix kernel ioctl header files for PPC/PPC64
- Removed dl-reloc.c fix, merged upstream
* Wed Oct  1 2003 kukuk@suse.de
- Update to glibc cvs from 20031001
- Remove sysmacros.h fix, merged upstream
- Add dl-reloc.c fix for compiler warnings
* Mon Sep 29 2003 kukuk@suse.de
- Update kernel-headers to 2.6.0-test6
- Fix sysmacros.h to compile with -ansi
* Sat Sep 27 2003 kukuk@suse.de
- Update to glibc CVS from 20030927
- Remove SO_BSDCOMPAT (obsoleted by kernel)
- Make _IOC_TYPECHECK useable for userland programs
* Fri Sep 26 2003 kukuk@suse.de
- Remove obsolete patches
- Update to crypt_blowfish 0.4.5
* Fri Sep 26 2003 kukuk@suse.de
- Update to glibc CVS from 20030926
- Update to nptl 0.60
* Sat Sep 20 2003 kukuk@suse.de
- Update to glibc CVS from 20030920
- Update to nptl 0.59
* Wed Sep 17 2003 kukuk@suse.de
- Disable TLS for i586 glibc [Bug #31034]
* Tue Sep 16 2003 kukuk@suse.de
- Remove db1.85
* Mon Sep 15 2003 kukuk@suse.de
- Update to glibc CVS from 20030915
* Mon Sep 15 2003 kukuk@suse.de
- Update to kernel 2.6.0-test5 header files
* Sat Sep 13 2003 kukuk@suse.de
- Add librtkaio, a librt using kernel aio
* Thu Sep 11 2003 kukuk@suse.de
- Update to current CVS
- Remove patches which are merged in CVS
- Update to nptl-0.58
- Remove _POSIX_VERSION hack
* Thu Sep 11 2003 kukuk@suse.de
- version.h: Fix comment how to compile kernel modules
* Wed Sep 10 2003 aj@suse.de
- Install en_US.ISO-8859-15 under this name [#30373].
* Tue Sep  9 2003 aj@suse.de
- Fix last patch.
* Mon Sep  8 2003 aj@suse.de
- Fix setting up of user signal handler in linuxthreads on x86_64.
* Fri Sep  5 2003 kukuk@suse.de
- Add dl-tls.c to fix out of memory with static TLS errors
* Wed Sep  3 2003 kukuk@suse.de
- Update glibc-linuxthreads
- Set _POSIX_VERSION back to 199209
* Mon Sep  1 2003 kukuk@suse.de
- Fix typo in nss_compat patch
* Mon Sep  1 2003 kukuk@suse.de
- Add opendir fix for usage with NPTL
- Fix getspnam/getspent in nss_compat [Bug #29689]
- Set _POSIX2_VERSION back to 199209
* Wed Aug 27 2003 kukuk@suse.de
- Update to current CVS version
* Mon Aug 25 2003 kukuk@suse.de
- Update to current CVS version
* Mon Aug 18 2003 aj@suse.de
- increase stack size for linuxthreads/set-context.
* Mon Aug 18 2003 aj@suse.de
- Fix mathinline.h for i386 to compile under C++ without warnings.
* Sun Aug 17 2003 ro@suse.de
- kernel-headers.dif: don't include device.h from videodev.h
* Fri Aug 15 2003 kukuk@suse.de
- Update to current cvs (fixes assert usage in C++ source code)
* Thu Aug 14 2003 kukuk@suse.de
- Initialize fp->_mode for glibc 2.0 compatibility [Bug #28386]
- On i686, include glibc with and without floating stack enabled
- Update to current cvs
- Update to nptl 0.56
* Thu Jul 31 2003 kukuk@suse.de
- Reenable new quota.h
* Wed Jul 30 2003 kukuk@suse.de
- Update to current cvs
- Update kernel headers to 2.6.0-test2
- Disable sys/quota.h update
- Enable TLS on AMD64 again
* Mon Jul 28 2003 kukuk@suse.de
- Update to current cvs
- Disable TLS on AMD64 temporary
- Update sys/quota.h to match new kernel implementation
* Fri Jul 25 2003 kukuk@suse.de
- Update to current cvs
- Update kernel headers to 2.6.0-test1
- Update to nptl 0.55
- Change minimal symbol version on PPC64 back to 2.2.5
* Wed Jul 23 2003 meissner@suse.de
- Fixed systemcall clobber lists for asm-ppc/unistd.h (by just
  merging over the asm-ppc64 things).
* Wed Jul 23 2003 aj@suse.de
- Handle in ldconfig konqueror.so and other similar KDE hacks that fail without
  rpath.
- Fix bugs exposed by unit-at-a-time option.
* Fri Jul 18 2003 aj@suse.de
- Fix compilation with unit-at-a-time enabled compiler.
- Enlarge stack for tst-setcontext test.
* Mon Jun 30 2003 kukuk@suse.de
- Update to current CVS (includes if_arp.h and nss_compat changes)
- Update to nptl 0.50
- Kernel header fixes for userland inclusion
* Wed Jun 25 2003 kukuk@suse.de
- Update to current CVS
- Add target host and CVS checkout to glibc version printout
- Adjust fnmatch fix
- Update kernel headers to 2.5.73
* Tue Jun 24 2003 kukuk@suse.de
- Fix typos in syscalls.list on Alpha
* Mon Jun 23 2003 kukuk@suse.de
- fix typo in linuxthreads on SPARC
- Update to current CVS
- Update to nptl 0.48
* Thu Jun 19 2003 kukuk@suse.de
- Disable nss_compat patch again
* Wed Jun 18 2003 kukuk@suse.de
- Fix reading of locale.alias file
- Update to current CVS snapshot
- Update to nptl 0.47
- Some kernel header file fixes for PPC64/IA64
- Update nss_compat patch
* Thu Jun 12 2003 kukuk@suse.de
- Update to current CVS snapshot
- Finish patch for printing linker warning
* Wed Jun 11 2003 kukuk@suse.de
- Update to nptl 0.45
- Update to current CVS snapshot
- Add patch to print linker warning, if a static binary calls
  functions using NSS
* Tue Jun 10 2003 kukuk@suse.de
- Use %%find_lang macro and cleanup glibc-locale filelist
* Thu Jun  5 2003 kukuk@suse.de
- Complete mathinline.h fixes
* Thu Jun  5 2003 kukuk@suse.de
- linux/compiler.h: Define all inline variants to __inline__
* Wed Jun  4 2003 kukuk@suse.de
- Update to current glibc CVS snapshot
- Update to nptl 0.43
- More kernel header fixes
- Make --no-archive default for localedef
* Tue May 27 2003 kukuk@suse.de
- Update to current glibc CVS snapshot
- Update to nptl 0.40
- Disable nss_compat patch
- Update to kernel headers from 2.5.70
* Fri May 23 2003 kukuk@suse.de
- Update to current glibc CVS snapshot
- Add patches to make nss_compat work with every service
* Mon May 19 2003 kukuk@suse.de
- Update to current glibc CVS snapshot
- Add patch for better binary compatibility (errno, h_errno)
* Fri May 16 2003 kukuk@suse.de
- Update to current glibc CVS snapshot
- Update to nptl 0.39
- Add URL tag
- asm-i386/byteorder.h: fix asm vs. __asm__
* Wed May 14 2003 schwab@suse.de
- Fix missing syscall numbers on ia64.
* Wed May 14 2003 kukuk@suse.de
- More kernel headers fixes for i386, ia64, ppc and s390
* Mon May 12 2003 kukuk@suse.de
- Update to current glibc CVS snapshot
- Fix lot of more kernel headers
- Adjust netinet/igmp.h patch
- Copy linux/version.h in place before compiling glibc
* Fri May  9 2003 kukuk@suse.de
- Fix bits/stdio.h
- Fix lot of kernel headers to work in userspace
- Fix netinet/igmp.h
- Enable TLS on PPC
* Wed May  7 2003 kukuk@suse.de
- Update CVS snapshot
- Enable TLS on IA64
- Update to nptl 0.37
- Update kernel-headers to 2.5.69
* Thu Apr 24 2003 ro@suse.de
- fix install_info --delete call and move from preun to postun
* Fri Apr 11 2003 aj@suse.de
- Do not build locales in parallel.
* Tue Apr  8 2003 kukuk@suse.de
- Disable TLS for PPC
* Mon Apr  7 2003 kukuk@suse.de
- Update CVS snapshot
* Sat Apr  5 2003 kukuk@suse.de
- Disable TLS for ia64
- Update to nptl 0.34
- Update to CVS snapshot
* Fri Apr  4 2003 kukuk@suse.de
- Remove libNoVersion from filelist on alpha
- Add nptl docu
* Fri Apr  4 2003 kukuk@suse.de
- Update to nptl 0.33
- Run ldconfig after installation
- Update to CVS snapshot
* Sat Mar 29 2003 kukuk@suse.de
- Update to CVS snapshot
- Add USAGI patches for kernel-headers
- Add nptl on i686
- Enable --with-tls
- Implement NI_NUMSERICSCOPE for getnameinfo
- Implement AI_V4MAPPED/AI_ALL for getaddrinfo
- Implement AI_ADDRCONFIG for getaddrinfo
- Add USAGI patch for kernel headers
* Mon Mar 24 2003 schwab@suse.de
- Sanitize <asm-ia64/pal.h>.
* Mon Mar 17 2003 aj@suse.de
- Fix tst-aio7 testcase and enable it again.
- Enable %%fs for x86-64.
- Install en_US.ISO-8859-15 for libstdc++.
- Fix bits/syscalls.h for x86-64.
* Thu Mar 13 2003 kukuk@suse.de
- Revert tcgetattr change [Bug #25173/#25174]
* Tue Mar  4 2003 aj@suse.de
- Fix <tgmath.h> lround/lrint functions.
* Sat Mar  1 2003 aj@suse.de
- Update to 2.3.2 release.
* Wed Feb 26 2003 kukuk@suse.de
- Update to current cvs snapshot (fixes OOo and mysql problems)
* Mon Feb 24 2003 kukuk@suse.de
- Disable aio7 test on s390(x), too.
* Mon Feb 24 2003 kukuk@suse.de
- Update to current cvs snapshot (post 2.3.2-pre1)
- Remove glibc-2.3-ppc32-textrel.patch, is included in CVS
- Remove libc23-ppc64-cvshead20021210.patch
* Thu Feb 20 2003 kukuk@suse.de
- Update to current cvs snapshot
- Remove glibc-2.3-ppc64-vfork-20030214.patch, seems to be
  included already.
* Wed Feb 19 2003 olh@suse.de
- add glibc-2.3-ppc32-textrel.patch
    glibc-2.3-ppc64-vfork-20030214.patch
* Fri Feb 14 2003 kukuk@suse.de
- Extend getent to print all IP addresses of one host
* Thu Feb 13 2003 kukuk@suse.de
- Update to current snapshot
* Wed Feb 12 2003 kukuk@suse.de
- Update to current snapshot (contains official fix for #23513)
* Tue Feb 11 2003 kukuk@suse.de
- Update to current snapshot
- Fix corruption of internal data in gethostbyname2 [Bug #23513]
* Sun Feb  9 2003 aj@suse.de
- Fix cancellation of system calls on x86-64.
* Sat Feb  8 2003 kukuk@suse.de
- Fix wrong logic in dynamic resolv.conf patch
* Fri Feb  7 2003 kukuk@suse.de
- Fix access of _res symbol in multithreaded programs
- Add "dynamic resolv.conf" patch to libnss_dns, too.
- Remove obsolete db2 manual pages
- Update to current snapshot (fixes [Bug #23363])
* Thu Feb  6 2003 kukuk@suse.de
- Update to current snapshot
- Use install-info for info pages
* Tue Feb  4 2003 schwab@suse.de
- Fix regexp parsing.
* Mon Feb  3 2003 meissner@suse.de
- Merged a unistd.h gcc3.3 compliance patch from Franz Sirl for
  ppc and ppc64 kernel headers.
* Fri Jan 31 2003 schwab@suse.de
- Fix building on s390[x].
* Fri Jan 31 2003 kukuk@suse.de
- Update to current glibc cvs
* Thu Jan 30 2003 aj@suse.de
- Fix one build problem on sparc.
- Fix asm-x86_64/mtrr.h.
* Wed Jan 29 2003 kukuk@suse.de
- Update to current glibc cvs
- Fix libm-ulps for x86-64 and ia64
* Thu Jan 23 2003 schwab@suse.de
- Fix use of DT_FINI_ARRAY.
- Temporarily disable tst-aio7 test on ia64.
* Tue Jan 14 2003 schwab@suse.de
- Fix ia64 for non-tls build.
* Tue Jan 14 2003 aj@suse.de
- Package libpthread_nonshared.a.
* Mon Jan 13 2003 kukuk@suse.de
- Add fixed version of x86-64-linuxthreads-disable-fs.diff
- Readd parts of libm-x86-64.diff
- Update to current cvs snapshot
- Add fix for errno compatibility
- Add s390(x) vfork fixes
* Sun Jan 12 2003 kukuk@suse.de
- Update to current cvs snapshot
* Fri Jan  3 2003 bg@suse.de
- removed obsolete patch for hppa
* Fri Dec 20 2002 kukuk@suse.de
- Update to current cvs snapshot
- Obsoletes glibc-2.3-setjmp-ppc64.diff
- Obsoletes build-alpha.diff
- Obsoletes libm-x86-64.diff
- Disable activate-spinlocks.diff temporary
- Disable x86-64-linuxthreads-disable-fs.diff (breaks compilation)
* Tue Dec 17 2002 olh@suse.de
- remove glibc-2.2.5-ppc64-bits-socket_h.diff
  add glibc-2.3-setjmp-ppc64.diff
  add libc23-ppc64-cvshead20021210.patch
  dont run configure in subshell, it can fail and rpm cant catch it
* Fri Dec 13 2002 schwab@suse.de
- Add more ia64 syscalls.
* Fri Dec  6 2002 olh@suse.de
- build also the locals parallel
  do not fail with parallel calculation on lowmem systems
* Tue Dec  3 2002 aj@suse.de
- Build parallel on x86-64.
- Activate fast spinlocks in malloc for x86 and x86-64.
- Integrate new math library from AMD for x86-64.
* Fri Nov 29 2002 bg@suse.de
- Fix build on hppa.
* Thu Nov 28 2002 aj@suse.de
- Fix build on alpha.
* Thu Nov 28 2002 aj@suse.de
- Update to CVS version from 2002-11-28.
- Do not use %%fs for threads for now on x86-64.
- Fix fnmatch bug with multibyte strings.
* Tue Nov 12 2002 bg@suse.de
- Updated hppa patches
* Thu Nov  7 2002 kukuk@suse.de
- getaddrinfo(): get host information for AF_INET and AF_INET6 only
  from the same service [Bug #21237]
* Thu Nov  7 2002 bg@suse.de
- Fix build of linuxthreads for hppa
* Tue Nov  5 2002 bg@suse.de
- Use current kernel-headers for parisc
- Add support for hppa
* Tue Nov  5 2002 kukuk@suse.de
- Update to current CVS snapshot
* Tue Oct 22 2002 schwab@suse.de
- Fix ia64 syscall numbers.
* Mon Oct 21 2002 schwab@suse.de
- Fix alignment in locale-archive.
* Mon Oct 21 2002 kukuk@suse.de
- Update to glibc 2.3.1 cvs 20021021
- Remove nss_dns6 patch
* Tue Oct 15 2002 kukuk@suse.de
- Update to glibc 2.3.1 cvs 20021015
* Wed Oct  2 2002 kukuk@suse.de
- Update to glibc 2.3 cvs 20021002
- Update crypt_blowfish to 0.4.4 (manual page fix, hppa fix)
* Wed Sep 25 2002 mls@suse.de
- build with -finline-limit=2000 on mips/armv4l
* Tue Sep 17 2002 schwab@suse.de
- Add new ia64 syscall numbers.
* Mon Sep 16 2002 meissner@suse.de
- Added AIO syscall numbers for ppc/ppc64, so libaio does not need them.
- Aligned powerpc bits/sem.h to be the same as the other 64bit
  archs, keeping the 32bit layout.
- Added the faster ppc32 memset.S from glibc HEAD on request of IBM.
* Thu Sep 12 2002 meissner@suse.de
- ppc/ppc64: added more biarch things to the SystemV IPC headers
  which are needed to get 64bit ipc / IPC_STAT to work.
* Mon Sep  9 2002 bk@suse.de
- s390x-biarch: use correct wordsize.h(move to main 32/64 directory)
- s390x: requires 64-bit kernel
* Mon Sep  9 2002 kukuk@suse.de
- Increase minimum value of MAXPACKET in libnss_dns, too
* Mon Sep  9 2002 uli@suse.de
- all architectures are created equal, but some are more equal
  than others; increased DB_FILE_ID_LEN in DB2 to 24 on x86-64,
  ia64, s390x and ppc64 to fit 64 bit __ino_t type
* Fri Sep  6 2002 mls@suse.de
- fix squeeze bug in db-1.85: set dirty flag after page modification
* Fri Sep  6 2002 kukuk@suse.de
- Increase minimum value of MAXPACKET
* Mon Sep  2 2002 kukuk@suse.de
- Fix asm header files for sparc/sparc64
* Fri Aug 30 2002 aj@suse.de
- Revert linuxthreads for x86-64 for now.
* Wed Aug 28 2002 aj@suse.de
- Add optimized math routines for x86-64.
* Tue Aug 27 2002 olh@suse.de
- BuildFlags="$(echo $RPM_OPT_FLAGS | sed 's#-mminimal-toc##')"
* Mon Aug 26 2002 olh@suse.de
- add ppc64_glibc_2.2.5_sunrpc-fix.patch
  * sysdeps/unix/sysv/linux/powerpc/bits/socket.h: New file that adds
  __powerpc64__ specific fields and adjust size/alignment for 64-bit.
* Fri Aug 23 2002 aj@suse.de
- Use floating stacks for x86-64.
- Add LICENSE file.
- Fix profiling code on x86-64.
- Add strcspn, strpbrk and strspn optimizations for x86-64.
- Fix makecontext for x86-64.
* Thu Aug 15 2002 aj@suse.de
- Use biarch headers already for building so that bits/syscalls.h is
  build correctly.
- Fix bits/syscalls.h for x86-64.
- Remove *xattr patches.
* Thu Aug  8 2002 kukuk@suse.de
- Update to current cvs (calloc variable overflow fixed)
- Apply fix for calloc fix
- Add *xattr system calls and error number
* Tue Aug  6 2002 kukuk@suse.de
- Update to current cvs (IPv6 fixes)
* Mon Aug  5 2002 aj@suse.de
- Implement *context functions for x86-64.
* Sat Aug  3 2002 kukuk@suse.de
- Update kernel-headers to version 2.4.19
- Add PreRequires "filesystem".
* Thu Aug  1 2002 bk@suse.de
- added s390-may2002.diff with some chunks from may2002 drop
- give make check a second chance on s390(x), but fail if not(race)
* Tue Jul 30 2002 kukuk@suse.de
- sunrpc/xdr_array.c: Check for variable overflow
- Ignore failed make check on s390(x)
* Tue Jul 30 2002 aj@suse.de
- Add optimisations for x86-64.
* Mon Jul 29 2002 kukuk@suse.de
- Don't allocate/free category name in setlocale() unnecessarily
  (for IBM Java [Bug #17065]).
* Tue Jul 23 2002 kukuk@suse.de
- Update to current glibc cvs (pread/pwrite fixes)
- Remove extra de.po, is in official tarball now.
* Sat Jul 20 2002 aj@suse.de
- Fix profiling for x86-64.
* Fri Jul 19 2002 meissner@suse.de
- Fixed the PPC64 patch, several superflous files removed.
- Reenabled make check for ppc64.
* Wed Jul 17 2002 kukuk@suse.de
- Update to current glibc cvs
- Fix kernel headers for s390/s390x
- Move some binaries/shell scripts and manual pages to the
  correct subpackage
* Tue Jul 16 2002 meissner@suse.de
- Merged latest PowerPC patch from IBM.
  * Lots of ppc64 related fixes.
  * Start of biarch support.
  * Changed struct stat in 64bit ABI.
* Fri Jul 12 2002 aj@suse.de
- Add biarch patch for s390 and s390x.
* Mon Jul  8 2002 aj@suse.de
- Add some optimized x86-64 math routines and a fixed lgammal
  implementation.
- Testsuite on x86-64 should pass now.
- Run ldconfig in postinstall.
- Fix memleak in catgets.
* Sat Jul  6 2002 kukuk@suse.de
- Fix typo in create_biarch_asm.sh (asm-sparc path)
* Thu Jul  4 2002 kukuk@suse.de
- Fix typo in manpages/Makefile
- Fix filelist (on some archs ld-linux.so.2 was missing)
* Thu Jul  4 2002 kukuk@suse.de
- Revert mktime patch (check for year < 70)
- Replace ifarch i386 with ix86
- Add patch for arm
- Include pt_chown again
* Wed Jul  3 2002 kukuk@suse.de
- Add more new manual pages
- Fix spec file (renaming of ld-*, creating of include/asm header
  files)
- Update to current CVS version
- Fix kernel-headers for x86-64 (don't overwrite patched version)
- Rename Equador -> Ecuador [Bug #16648]
- Add hint about security problem of host caching with nscd to
  config file.
* Tue Jun 25 2002 aj@suse.de
- Fix dl-machine.h for x86-64 to compile with new binutils.
- Fix mtrr.h header for x86-64.
- Do not package pt_chown.
* Tue Jun 18 2002 sf@suse.de
- reverted changes from Tue Jun 11 10:04:55 CEST 2002
  (took the kernel-headers from before, readded patch9)
- add new archive with kernel-headers for x86_64
- add autofs patch
* Mon Jun 17 2002 bk@suse.de
- remove s390* from the list of archs that ignore check fail
* Thu Jun 13 2002 uli@suse.de
- fixed typos in spec
* Thu Jun 13 2002 schwab@suse.de
- Fix ssize_t and __ipc_pid_t for ppc64.
* Wed Jun 12 2002 uli@suse.de
- fix errlist.c for ARM as well
* Tue Jun 11 2002 sf@suse.de
- made new kernel-header archive from kernel-source
- added asm-ppc64 to kernel-headers
- removed patch9 as it is obsoleted by the new kernel-headers
* Fri Jun  7 2002 olh@suse.de
- update asm-ppc64/ioctls.h, missing TIOCGDEV
* Thu Jun  6 2002 olh@suse.de
- fix glibc-ppc64 patch
* Thu Jun  6 2002 olh@suse.de
- update ppc64_glibc_ldconfig.diff
* Thu Jun  6 2002 ke@suse.de
- Update de.po from
  http://www.iro.umontreal.ca/contrib/po/teams/PO/de/libc-2.2.5.de.po.
- Use only translated entries to make the testsuite happy; call
  msgattrib on de.po and hu.po [# 16438].
* Mon Jun  3 2002 aj@suse.de
- Clean up generation of asm includes for bi-arch systems.
- Enable profiling for x86-64.
* Mon Jun  3 2002 kukuk@suse.de
- Add fix for weak declaration "_old_sys_nerr"
- Remove already disabled alpha patch
- Update to current CVS
* Sat Jun  1 2002 olh@suse.de
- fix stat for real, wrong size for st_nlink
* Wed May 29 2002 olh@suse.de
- add ppc64_glibc_2.2.5-types.diff, fixes stat()
* Wed May 29 2002 olh@suse.de
- add ppc64_glibc_ldconfig.diff for elf32/elf64 coexistance
* Thu May 23 2002 aj@suse.de
- Rename __thread to fix problems with GCC 3.2.
* Mon May 20 2002 olh@suse.de
- add ppc64 kernel headers
  add create_ppc_asm.sh
  update ppc64 patch, use /lib64/ld64.so.1
  move generic syscalls.list to ppc64/32
  set/getrlimit GLIBC2.0 is ppc32 only
  use parallel make on ppc and ppc64
  do not chroot as user
  cleanup nested ifarch for dynamic linker
* Wed May 15 2002 aj@suse.de
- Fix building of linuxthreads with current GCC.
* Mon May 13 2002 olh@suse.de
- fix ppc64 RTLDLIST ld64.so rewrite
* Sat May 11 2002 schwab@suse.de
- Add div/mod compatibility functions for ia64.
* Fri May 10 2002 olh@suse.de
- add ppc64 support
* Thu May  9 2002 aj@suse.de
- Add sys/io.h for x86-64.
* Mon May  6 2002 ihno@suse.de
- corrected memory calculation for parallel build
* Fri May  3 2002 kukuk@suse.de
- Add fix to compile math.h on SPARC with g++
* Thu May  2 2002 kukuk@suse.de
- Update to current CVS 2.2 branch
- Add x86-64 fix for crti.o and /usr/lib64 with libpthread
* Fri Apr 26 2002 kukuk@suse.de
- define sqrtl alias for PowerPC
* Mon Apr 22 2002 aj@suse.de
- Fix vfork for x86-64.
- Fix handling of ld.so.cache for x86-64.
* Thu Apr 18 2002 aj@suse.de
- Allow testsuite to fail for x86-64.
- Add ULPs for x86-64.
* Wed Apr 17 2002 kukuk@suse.de
- Update to current snapshot (mktime and dl fixes)
- Update hu.po
- Do not build a profiled glibc for x86-64
* Fri Apr 12 2002 kukuk@suse.de
- Update to current snapshot (fix SPARC compile)
- Revert do-lookup.h patch on Alpha (does not work here)
* Wed Apr 10 2002 aj@suse.de
- Fix linuxthreads for x86-64.
* Wed Apr 10 2002 aj@suse.de
- Add x86-64.diff to fix glob64.
* Wed Apr 10 2002 kukuk@suse.de
- Update kernel-headers to 2.4.19pre4 (with x86-64 support)
- Update glibc to current cvs snapshot
- Allow old currencies (before EUR)
* Tue Apr  2 2002 aj@suse.de
- Update ULPs.
* Thu Mar 21 2002 kukuk@suse.de
- Create html pages after installation of info pages [Bug #15283]
* Tue Mar 12 2002 kukuk@suse.de
- Add db1 fix if blocksize is not ^2
* Sat Mar  2 2002 kukuk@suse.de
- Add fix for format string bug
* Sat Mar  2 2002 kukuk@suse.de
- Fix return value of nice wrapper
* Fri Mar  1 2002 kukuk@suse.de
- Add fix for corrupt ut_line
- Add fix for current gcc 3.1
- Add patch for nice return values
* Thu Feb 28 2002 kukuk@suse.de
- Add fix for rtime, swscanf and ia64
* Mon Feb 18 2002 kukuk@suse.de
- When a dlopened module references a weak symbol from another
  dlopened module (loaded with RTLD_GLOBAL) no dependency was
  generated for this fact, so the second module was unloaded even
  if the first one was still around.
* Sun Feb 17 2002 kukuk@suse.de
- Add pthread/signal bugfix [Bug #13280]
- Fix directory file list (don't include /usr/include)
* Thu Feb 14 2002 kukuk@suse.de
- Use defattr in spec file to avoid problems with not existing
  UIDs and rpm.
* Thu Feb 14 2002 aj@suse.de
- Update ULPs for GCC 3.1.
* Wed Feb 13 2002 kukuk@suse.de
- Apply db1 patch from mls@suse.de to fix rpm problems
* Tue Feb 12 2002 ro@suse.de
- fix owner/group for kernel headers
* Mon Feb 11 2002 kukuk@suse.de
- Add another solution for the glob problem
* Thu Feb  7 2002 kukuk@suse.de
- Add fix for glob (glob should not call globfree)
- Add fix for innetgr
* Wed Feb  6 2002 kukuk@suse.de
- Use correct BuildRoot
* Wed Feb  6 2002 kukuk@suse.de
- Update hu.po
* Wed Feb  6 2002 kukuk@suse.de
- Set LC_CTYPE for error messages in localedef [Bug #12878]
* Mon Feb  4 2002 kukuk@suse.de
- Add fixes from CVS: dynamic loader, readv and writev seg.fault
  and various architecture fixes for alpha and mips
- Don't compile with -g on Alpha
- Add fix for possible endless loop fix
* Fri Feb  1 2002 bk@suse.de
- merged s390x lib64 patch and spec file changes
* Wed Jan 23 2002 kukuk@suse.de
- Split glibc into glibc and glibc-locale
- Create more UTF8 locale
* Mon Jan 21 2002 kukuk@suse.de
- Update to official glibc 2.2.5
* Wed Jan 16 2002 kukuk@suse.de
- Remove /var/adm/setup/setup.timeconfig
* Wed Jan 16 2002 kukuk@suse.de
- Apply S390 fix
* Wed Jan  9 2002 kukuk@suse.de
- Update to glibc 2.2.5pre1
* Tue Jan  8 2002 egmont@suselinux.hu
- Added partial Hungarian translation
* Tue Jan  8 2002 kukuk@suse.de
- Add patch to pass math tests with gcc 3.x
- Update to current CVS version
* Thu Jan  3 2002 kukuk@suse.de
- Update kernel header files to 2.4.17
* Tue Jan  1 2002 kukuk@suse.de
- Update current CVS version, add final fixes for LSB test suite
* Tue Dec 18 2001 poeml@suse.de
- Install ja_JP.SJIS locale.
* Sat Dec 15 2001 schwab@suse.de
- Fix missing declaration of md5_uintptr.
* Fri Dec 14 2001 kukuk@suse.de
- Update to correct CVS branch
* Thu Dec 13 2001 kukuk@suse.de
- Update to current CVS
- Increase PATH_MAX to 4096 (including the leading zero)
- Clear pointer if asprintf fails
- pthread_key_delete should not contact thread manager before it
  is created.
* Tue Dec 11 2001 kukuk@suse.de
- Fix prelink patch
* Tue Dec 11 2001 kukuk@suse.de
- Add fixes for LSB.os test suite (ftw, grantpt and ftok)
- Update to current CVS
- Add prelink patch
* Fri Dec  7 2001 kukuk@suse.de
- Merge with current CVS
- Add blowfish crypt
* Fri Nov 23 2001 uli@suse.de
- added armv4l arch to spec
- added arm kernel headers
- added trivial fix for dl-machine.h from CVS (see arm.dif)
* Thu Nov 15 2001 adrian@suse.de
- add mips architecture to spec file
- apply further mips fixes for ld
- activate %%clean again
* Sun Nov 11 2001 kukuk@suse.de
- Fix lost permissions of shell script on SPARC
* Thu Nov  8 2001 kukuk@suse.de
- Add 32bit UID fixes
* Thu Nov  8 2001 kukuk@suse.de
- More fixes for asm-ia64 header files
* Thu Nov  8 2001 kukuk@suse.de
- Fix asm-i386/processor.h (don't align struct)
- Fix asm-ia64/bitops.h (define CMPXCHG_BUGCHECK)
- Correct version number in version.h
* Wed Nov  7 2001 uli@suse.de
- fixed sys/io.h, sysmacros.h for icc
* Tue Nov  6 2001 kukuk@suse.de
- Update kernel-headers to 2.4.14
* Thu Nov  1 2001 kukuk@suse.de
- Use again old rules to generate html files
* Sun Oct 21 2001 schwab@suse.de
- Fix inttypes.h for C++.
* Fri Oct 19 2001 aj@suse.de
- Fix typo in inttypes.h that presents compilation by non-GCC compilers.
* Tue Oct 16 2001 aj@suse.de
- Update elf.h to include x86-64 defines since those are needed
  by some other tools.
* Fri Sep 28 2001 schwab@suse.de
- Readd patch from 2001-09-10 with corrections.
- Add compatibility patch for GCC 3.  This allows to build glibc
  with GCC 3.
- Require that make check succeeds on ia64.
* Thu Sep 13 2001 aj@suse.de
- Add a better version of the threads-fork patch that fixes some
  more places where interrupts can occur and does this a bit cleaner.
* Tue Sep 11 2001 aj@suse.de
- Remove patch from 2001-09-10 since it breaks the dynamic linker.
* Tue Sep 11 2001 aj@suse.de
- Fix bug in linuxthreads where manager and threads could
  get out of synch due to an interrupted read call.
* Mon Sep 10 2001 schwab@suse.de
- Fix handling of dependent dynamic objects for dlopen/dlclose.
* Sat Sep  8 2001 kukuk@suse.de
- Don't create gconv cache (else iconv --list seg.faults)
* Tue Aug 28 2001 aj@suse.de
- Improve dynamic linker to relocate dynamic objects faster.  This
  implies a small cache for symbol lookups and handling the ld -z combreloc
  feature if binaries are linked this way.
* Fri Aug 24 2001 kukuk@suse.de
- Add fix for handling of %%l[] in vfscanf
- ldconfig removes stale links now
- Remove susehelp config files, now in susehelp itself
* Wed Aug 22 2001 aj@suse.de
- Update s390 patch from IBM.
* Fri Aug 17 2001 kukuk@suse.de
- Adjust dns6 patch for 2.2.4
- Fix spec file (include lost libnss_dns6.so)
- Fix versionnumber in version.h [Bug #9759]
- Update kernel-header to 2.4.9
* Thu Aug 16 2001 aj@suse.de
- Update to 2.2.4 final.  Add s390-ucontext patch.
* Fri Aug 10 2001 aj@suse.de
- Update to current glibc version.  Do not use the hardlink program
  for compatification since localedef will do this itself now.
  Create gconv cache.
* Wed Aug  1 2001 aj@suse.de
- Add patch for zic to create copy of the timezone instead
  of a symbolic link so that the file exists even if /usr is not
  mounted.
  Use i486 instead of i386 as default architecture for i386.
* Sat Jul 28 2001 kukuk@suse.de
- Fix problem with linux/spinlock.h
* Fri Jul 27 2001 kukuk@suse.de
- Update kernel-header files to 2.4.7
* Thu Jul 26 2001 froh@suse.de
- add fix for failing tst-setcontext on s390
* Wed Jul 25 2001 aj@suse.de
- Add patch to fix loading of dynamic libs in static programs for PPC.
* Fri Jul 20 2001 kukuk@suse.de
- Update to current CVS snapshot
- Disable tst-regex and test-lfs
* Fri Jul  6 2001 kukuk@suse.de
- Add da_DK@euro and da_DK.UTF-8
* Thu Jul  5 2001 kukuk@suse.de
- Update to current CVS snapshot
- Remove obsolete cvs patch
- Fix DNS/IPv6 patch
- Hardlink equal locale files
* Fri Jun 22 2001 olh@suse.de
- add glibc-2.2.3-ppc_dlmachine.diff to fix binutils make check
* Tue Jun 19 2001 aj@suse.de
- Fix profiling on PowerPC.
* Tue Jun 19 2001 bk@suse.de
- added s390x support to spec file
* Fri Jun 15 2001 schwab@suse.de
- Fixup asm-ia64/atomic.h for user-space inclusion.
* Tue Jun 12 2001 aj@suse.de
- Fix testsuite for sparc.
* Mon Jun 11 2001 aj@suse.de
- Fix testsuite for powerpc and S390, build again on alpha.
* Tue May 22 2001 kukuk@suse.de
- Update to current CVS snapshot
- Rmove support for PF_LOCAL from getaddrinfo [Bug #8469]
* Sun May 13 2001 kukuk@suse.de
- Don't use absolute paths in pre-install-section
* Fri May  4 2001 kukuk@suse.de
- Add special version.h which fails on compiling kernel modules
* Sat Apr 28 2001 kukuk@suse.de
- Update to glibc 2.2.3, kernel-headers-2.4.4
* Tue Apr 24 2001 schwab@suse.de
- Fix feenableexcept on ia64.
* Tue Apr 24 2001 aj@suse.de
- Install some more UTF-8 locales, fix tr_TR locale.
* Thu Apr 12 2001 kukuk@suse.de
- Include our own texi2html
* Wed Apr 11 2001 kukuk@suse.de
- Add fixes from SuSE kernel header files
- Add patch to reload /etc/resolv.conf if there was changes
- Add glibc.conf for susehelp (glibc-html pages)
* Mon Apr  9 2001 schwab@suse.de
- Fix ld.so for kernel 2.4.3 on ia64.
* Thu Apr  5 2001 kukuk@suse.de
- Add more fixes from CVS
* Tue Apr  3 2001 kukuk@suse.de
- Fix isdn header files from kernel-headers
* Fri Mar 30 2001 kukuk@suse.de
- Update kernel header files to 2.4.3
* Fri Mar 30 2001 kukuk@suse.de
- Merge s390 patches
- Fix rcmd_af() (allow PF_UNSPEC)
* Fri Mar 30 2001 aj@suse.de
- Add some small fixes, fix spec file for removal of man-pages.
* Thu Mar 29 2001 kukuk@suse.de
- Don't provide kernel_headers any longer
- Remove some man-pages which are now official in the man-pages
  package
* Thu Mar 29 2001 aj@suse.de
- Fix shmfs recognition.
* Wed Mar 28 2001 ro@suse.de
- added db-splitmask fix from mls (hopefully work around bug in db1)
* Wed Mar 28 2001 aj@suse.de
- Fix s390 to not generate wrong relocations, work around compiler
  error.
* Wed Mar 21 2001 kukuk@suse.de
- glibc-devel obsoletes and provides linclude
* Tue Mar 20 2001 kukuk@suse.de
- Add strtok and other fixes from CVS
- Add yp_all fix
* Tue Mar 13 2001 kukuk@suse.de
- Add more s390 string.h fixes
* Mon Mar 12 2001 aj@suse.de
- Add fixes for s390, don't run testsuite on s390 for now.
* Fri Mar  9 2001 kukuk@suse.de
- Fix linux/init.h header file
* Fri Mar  9 2001 aj@suse.de
- Handle new EM_S390 value.
* Fri Mar  9 2001 kukuk@suse.de
- kernel-heaer fixes to build on Alpha
* Thu Mar  8 2001 ro@suse.de
- update kernel-headers to 2.4.2
* Thu Mar  8 2001 ro@suse.de
- kernel-header fixes to build on s390
* Thu Feb 22 2001 schwab@suse.de
- More kernel header fixes for IA64.
* Tue Feb 20 2001 kukuk@suse.de
- Remove optimisation not supported on all plattforms
* Mon Feb 19 2001 kukuk@suse.de
- Fix Optimization of glibc build
- Add Optimization for alphaev6 and sparcv9
* Sat Feb 17 2001 kukuk@suse.de
- Update to glibc 2.2.2 from CVS
* Thu Feb 15 2001 kukuk@suse.de
- kernel header fixes for SPARC and IA64
* Tue Feb 13 2001 kukuk@suse.de
- Make optimization for i686 work
- Add manual page for ldd
* Mon Feb 12 2001 kukuk@suse.de
- Fix more kernel headers
* Thu Feb  8 2001 kukuk@suse.de
- Fix more kernel-headers
* Wed Feb  7 2001 kukuk@suse.de
- Delete links in pre install section for glibc-devel
* Wed Feb  7 2001 kukuk@suse.de
- Fix kernel-header includes
* Tue Feb  6 2001 kukuk@suse.de
- Fix creating of /usr/include/asm on SPARC
- Add more CVS patches
* Mon Feb  5 2001 kukuk@suse.de
- Add some patches from CVS
- Include our own kernel header files
* Mon Jan 22 2001 aj@suse.de
- Add elf patch to fix problems on ia64 and ppc with _dl_pagesize.
* Mon Jan 22 2001 aj@suse.de
- Fix mmap64 on powerpc.
* Tue Jan 16 2001 aj@suse.de
- Fix sunrpc-udp.diff, add mman.h fix for powerpc.
* Wed Jan 10 2001 aj@suse.de
- Add sunrpc-udp.diff to fix UDP timeouts with Linux 2.4 kernel.
* Tue Jan  9 2001 aj@suse.de
- Add glibc-2.2.secure.diff to close some security holes.
* Wed Jan  3 2001 schwab@suse.de
- Fix strtol and friends on 64 bit platforms.
- Use 8192 as default pagesize on ia64.
- Scan AUX vector also in statically linked programs.
* Wed Jan  3 2001 aj@suse.de
- Build some UTF-8 locales using a patch from Markus Kuhn.
* Wed Dec 13 2000 aj@suse.de
- Add compatibility patch for IPv6 and Linux 2.2.
* Wed Dec 13 2000 schwab@suse.de
- Update ia64 patch.
* Sat Dec  9 2000 kukuk@suse.de
- Fix resolver bug
* Fri Dec  1 2000 kukuk@suse.de
- Add bug fixes for setlocale and strncat
- strip gconv modules
* Fri Nov 24 2000 kukuk@suse.de
- Fix typo in spec file
* Thu Nov 23 2000 kukuk@suse.de
- Add hack for POWER3
* Wed Nov 22 2000 kukuk@suse.de
- Add strncat bugfix for S/390
* Tue Nov 21 2000 kukuk@suse.de
- Don't bulid 32bit compat packages
* Mon Nov 20 2000 schwab@suse.de
- Remove use of getpagesize syscall on ia64.
- Follow DT_INIT/DT_FINI change in compiler.
* Sun Nov 19 2000 kukuk@suse.de
- Minor specfile fixes
* Thu Nov 16 2000 kukuk@suse.de
- Add lot of more bug fixes
* Tue Nov 14 2000 kukuk@suse.de
- Add bugfix for static linked binaries/ld.so.cache from aj@suse.de
* Mon Nov 13 2000 aj@suse.de
- Fix noversion.diff and spec file.
* Sat Nov 11 2000 kukuk@suse.de
- Fix nssv1 on PowerPC
- no libNoVersion on SPARC
* Fri Nov 10 2000 kukuk@suse.de
- Disable make check on PowerPC and Alpha
* Fri Nov 10 2000 kukuk@suse.de
- Update to final glibc 2.2
* Fri Nov  3 2000 kukuk@suse.de
- Update to glibc-2.2-20001103 (glibc-2.1.97)
- Don't install libNoVersion on PowerPC
- Rename nssv1 -> glibc-nssv1
- Rename libd -> glibc-profile, move libg.a to libc
- Rename libcinfo -> glibc-info
- Rename libchtml -> glibc-html
- Rename localedb -> glibc-i18ndata
- Rename libc -> glibc-devel
- Rename shlibs -> glibc
* Sat Oct 28 2000 kukuk@suse.de
- Update to glibc-2.2-20001028
- Enable more checks
* Fri Oct 27 2000 aj@suse.de
- Fix NoVersion patch
* Wed Oct 25 2000 kukuk@suse.de
- Update to glibc-2.2-20001025
* Sun Oct 22 2000 kukuk@suse.de
- Update to glibc 2.2-20001021
- Update glibc-db to 2.1.95
- Update ia64 patch
* Fri Oct 20 2000 kukuk@suse.de
- Update to glibc 2.2-20001020
- Add s390 spec file changes
* Tue Oct 10 2000 schwab@suse.de
- Update to glibc 2.2-20001009.
- Fix TRAMPOLINE_TEMPLATE for ia64.
* Sun Oct  1 2000 schwab@suse.de
- Export more ia64 specific symbols.
* Tue Sep 26 2000 kukuk@suse.de
- Update to glibc 2.2-20000926
* Mon Sep 25 2000 kukuk@suse.de
- Update to glibc 2.2-20000925 snapshot
* Thu Sep 14 2000 schwab@suse.de
- Update ia64 patch.
* Fri Sep  8 2000 bk@suse.de
- added glibc-2.1.3-db2-s390.tar.gz from developerworks (db2 fix)
* Wed Sep  6 2000 fober@suse.de
- merge s390-7.0 with STABLE:
  - upgraded to glibc-linuxthreads-2.1.3.1-s390.diff from 2.1.3
  - added new changes from IBM s390 codedrop
  - removed glibc-dlopen-2.1.3-s390.diff which is
    incorporated in glibc-linuxthreads-2.1.3.1-s390.diff now
* Tue Sep  5 2000 kukuk@suse.de
- Add glibc-2.1.security.dif
* Fri Sep  1 2000 olh@suse.de
- add glibc-2.1-ppc_lfs.dif, enables (hopefully) lfs on ppc
* Wed Aug 30 2000 olh@suse.de
- remove sysdeps/powerpc/memset.S on ppc for POWER3
* Mon Aug 28 2000 olh@suse.de
- add glibc-2.1.sgi_fam.dif
- remove sysdeps/rs6000/memcopy.h on ppc for POWER3
* Mon Aug 21 2000 garloff@suse.de
- Fix race on cond_wait WRT owner of mutex (from olh@suse.de)
* Tue Jul 25 2000 kukuk@suse.de
- Add mmap fix for PowerPC
* Tue Jul 11 2000 kukuk@suse.de
- Remove "mutex is owned by current thread" bugfix for IBMs jdk
* Mon Jun 26 2000 schwab@suse.de
- Update ia64 patch.
* Tue Jun 20 2000 kukuk@suse.de
- Move html docu in extra package
- Update ia64 patch
* Wed May 31 2000 kukuk@suse.de
- Remove LICENSE file, it's the same as COPYING.LIB
- Add libc docu as html
* Sun May 28 2000 kukuk@suse.de
- Fix ldconfig on PPC and IA64
* Sat May 27 2000 kukuk@suse.de
- Merge new ldconfig fixes
* Fri May 26 2000 kukuk@suse.de
- Update ia64 patch
* Fri May 26 2000 kukuk@suse.de
- Fix (f)truncate64 and xdr_uint8_t
* Wed May 24 2000 kukuk@suse.de
- Fix ldconfig.8 manual page
* Thu May 18 2000 bk@suse.de
- added s390 dlopen fix
* Tue May 16 2000 bk@suse.de
- updated s390 patches to match IBM_codedrop_2000_05_15
* Fri May 12 2000 kukuk@suse.de
- Fix netinet/in.h IPv6 compare
* Fri May 12 2000 schwab@suse.de
- Update ia64 patches.
* Fri May 12 2000 kukuk@suse.de
- Don't apply LFS patch
* Tue May  9 2000 kukuk@suse.de
- Add LFS patches
* Mon May  8 2000 kukuk@suse.de
- Add lot of bug fixes from CVS
* Tue Apr 25 2000 kukuk@suse.de
- Fix nscd/getgrnam bug
* Thu Apr 20 2000 kukuk@suse.de
- Remove /var/mail -> /var/spool/mail patch
- Update nscd.conf.5 manual page
* Wed Apr 12 2000 kukuk@suse.de
- Add nscd patch from Chris Wing
* Wed Apr 12 2000 kukuk@suse.de
- Add ldconfig fix from aj@suse.de
* Wed Apr 12 2000 schwab@suse.de
- More ia64 patches.
- Use libc.so.0, libm.so.0, ld-linux-ia64.so.1 on ia64.
* Mon Apr 10 2000 kukuk@suse.de
- Support asm-sparc64 and asm-sparc on SPARC
* Mon Apr 10 2000 kukuk@suse.de
- Create /etc/ld.so.cache always with permissions 0644
- Update ia64 patches
* Thu Apr  6 2000 schwab@suse.de
- Fix dynamic linker bug in ia64.
- Add ia64 spinlocks for db2.
* Tue Apr  4 2000 schwab@suse.de
- New IA64 patches.
- Fix ldconfig -p.
* Mon Apr  3 2000 bk@suse.de
- s390 team added s390 patches
* Wed Mar 22 2000 kukuk@suse.de
- Fix last SPARC patch
* Tue Mar 21 2000 kukuk@suse.de
- Add SPARC patches
- Add IA64 patches
* Wed Mar 15 2000 kukuk@suse.de
- Remove personality call (problematic on Alpha)
- Fix typo in localeconv
- alpha/ioperm.c> Add entry for "Nautilus".
* Tue Mar  7 2000 kukuk@suse.de
- Add locale SIGSEGV fix
- Fix getdate bug
* Fri Feb 25 2000 kukuk@suse.de
- Update to final glibc 2.1.3 + fix for bigendian machines
* Thu Feb 24 2000 kukuk@suse.de
- Update to current glibc cvs snapshot
- Add libnss_dns6.so.2, which makes IPv4 and IPv6 lookups.
  Old libnss_dns.so.2 will only make IPv4 lookups.
* Tue Feb 22 2000 kukuk@suse.de
- Update to current glibc cvs snapshot (2.1.3pre4)
* Sat Feb  5 2000 kukuk@suse.de
- Add missing defines for SPARC bits/termios.h
* Thu Feb  3 2000 kukuk@suse.de
- Add regex patch from Andreas Schwab
* Wed Feb  2 2000 kukuk@suse.de
- Add ldconfig fix
- Update to current glibc cvs snapshot
- Fix sys/io.h on Intel (C++)
* Mon Jan 24 2000 kukuk@suse.de
- Fix duplicate setrlimit
* Mon Jan 24 2000 kukuk@suse.de
- Update to current glibc cvs snapshot
* Wed Jan 19 2000 kukuk@suse.de
- Update to current glibc cvs snapshot
* Sat Jan 15 2000 ro@suse.de
-fixed ppc db2-patch
* Fri Jan 14 2000 kukuk@suse.de
- Add patches for Intel and PPC
* Thu Jan 13 2000 kukuk@suse.de
- Add patch for SPARC
* Thu Jan 13 2000 kukuk@suse.de
- Move info pages to /usr/share/info
* Mon Jan 10 2000 kukuk@suse.de
- Add ipv6 patches for getent
* Mon Jan 10 2000 kukuk@suse.de
- Move manual pages for applications and config files into
  shlibs package
- Update to current glibc 2.1.3 snapshot
* Fri Dec 17 1999 kukuk@suse.de
- Add new ldconfig patches
- Add aio patch
- Add fix for bits/string2.h
* Wed Dec 15 1999 kukuk@suse.de
- add ldconfig.8
* Wed Dec 15 1999 kukuk@suse.de
- Update to current glibc 2.1.3 snapshot
- Fix get/setrlimit problems
* Thu Dec  9 1999 kukuk@suse.de
- Update to current glibc 2.1.3 snapshot
- Add new ldconfig
* Sun Dec  5 1999 kukuk@suse.de
- Disable make check for SPARC (kernel bug)
- Add setrlimit patches
- Update to current glibc 2.1.3 snapshot
* Fri Nov 26 1999 kukuk@suse.de
- Update to current glibc 2.1.3 snapshot.
* Tue Oct 26 1999 kukuk@suse.de
- Add fix for correct accounting of needed bytes (gethnamaddr.c)
- Remove not exported, public names from internal md5 functions
* Mon Oct 25 1999 kukuk@suse.de
- Add fix for missing nexttowardl aliase
* Tue Oct 19 1999 kukuk@suse.de
- Add security fix for iruserok
* Sat Oct 16 1999 kukuk@suse.de
- Build libNoVersion.so.1 on every platform
* Mon Oct 11 1999 kukuk@suse.de
- Add linuxthreads/signals.c fix from Andreas Schwab
- Remove dangling symlink (Bug #544)
- Add more bug fixes
* Fri Oct  8 1999 kukuk@suse.de
- Add timezone update
* Fri Oct  8 1999 kukuk@suse.de
- Add NIS+ shadow parser fix
* Thu Oct  7 1999 kukuk@suse.de
- Update to official glibc 2.1.2, add important fixes
- Update nscd, add manual pages for it
* Mon Sep 20 1999 ro@suse.de
- libc: added requires kernel_headers
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Mon Sep  6 1999 kukuk@suse.de
- Update to current glibc 2.1.2 cvs snapshot
- Remove use auf automake in spec file
* Fri Sep  3 1999 kukuk@suse.de
- Update to current glibc 2.1.2 cvs snapshot
- Use RPM macros for configure
* Wed Aug 25 1999 kukuk@suse.de
- Update to current glibc 2.1.2 cvs snapshot
* Thu Aug 19 1999 kukuk@suse.de
- Add PowerPC patches from Uli Hecht
- Cleanup of SPEC file
- Create a profiling version
* Sat Aug 14 1999 kukuk@suse.de
- disable nscd hosts caching by default
- Apply patch from HJL for broken gethostbyname_r in libnss_dns
* Fri Jul 16 1999 kukuk@suse.de
- Add header fix for autoconf/g++
- Move pt_chown and gconv modules from libc to shlibs
* Wed Jul 14 1999 kukuk@suse.de
- Remove /etc/localtime from filelist
* Mon Jul 12 1999 kukuk@suse.de
- Add more bug fixes from cvs
- Add ld.so bug fix from Andreas Schwab
* Thu Jul  8 1999 kukuk@suse.de
- configure for i386-unknown-linux
* Wed Jul  7 1999 kukuk@suse.de
- Remove alpha patch, it's now in glibc 2.1.2 cvs
- Add more bug fixes from cvs
- Remove malloc patch (breaks StarOffice)
* Tue Jul  6 1999 kukuk@suse.de
- Add openpty patch from Andreas Schwab
  (openpty now works if /dev/pts is not mounted)
* Fri Jul  2 1999 kukuk@suse.de
- Remove warning von zic about symlinks.
* Mon Jun 28 1999 kukuk@suse.de
- Remove ndbm links, now in gdbm
* Fri Jun 25 1999 kukuk@suse.de
- Add a lot of more fixes
- Add nscd fixes and enable nscd on alpha
* Mon Jun 14 1999 kukuk@suse.de
- Add nss_dns and fget* fixes.
- Add nscd patches for NIS+
* Thu Jun 10 1999 kukuk@suse.de
- Fix daemon() for MT programs
- Add libio fixes
* Fri May 28 1999 kukuk@suse.de
- Add fix for docu
- Disable nscd for alpha again
* Wed May 26 1999 kukuk@suse.de
- Update to version 2.1.1
* Mon May 17 1999 kukuk@suse.de
- Update to snapshot from 16.5.1999
- Add manpages
- Add __setfpucw to libNoVersion (intel)
- Add COPYING and COPYING.LIB
* Fri May  7 1999 kukuk@suse.de
- Update to snapshot from 6.5.1999
- Add NoVersion patches from RedHat for miscompiled glibc 2.0 apps
- Add patch for Alpha RX164
- Add workaround for nscd on Alpha
* Wed Apr 28 1999 kukuk@suse.de
- Remove latest fnmatch patches from Uli Drepper
* Tue Apr 27 1999 kukuk@suse.de
- update to cvs version of Apr 26 1999
- fix pmap_set/pmap_unset for DHCP clients
- Rename libdb1.so.2[.1] to libdb.so.2[.1] since we don't create
  the symbolic links.
* Tue Apr 20 1999 kukuk@suse.de
- update to cvs version of Apr 20 1999
- remove sunrpc.diff
- fix nssv1 package
- only include nscd on intel
- install /etc/nscd.conf
* Mon Apr 12 1999 kukuk@suse.de
- update to cvs version of Apr 11 1999
- Fix paths in paths.h
- install linuxthreads man pages and documentation
- Add sunrpc patch for Alpha and security fixes
- added links for el_GR and ru_RU.KOI8-R in usr/share/locale
* Wed Mar 31 1999 bs@suse.de
- don't use lx_hack for build
* Tue Mar 16 1999 ro@suse.de
- libc.texinfo: changed to build with stable texinfo version
* Mon Mar 15 1999 ro@suse.de
- update to 2.1.1 (cvs of Mar 15 1999)
- update nssv1 to 2.0.2
* Sat Feb 20 1999 ro@suse.de
- fixed specfile (lddlibc4 not built on alpha)
* Sat Feb 20 1999 ro@suse.de
- fixed specfile ...
* Sat Feb 20 1999 ro@suse.de
- added automake to neededforbuild
* Sat Feb 20 1999 ro@suse.de
- added nss-v1 modules (to keep old rpm happy with file owners)
* Fri Feb 19 1999 ro@suse.de
- update to cvs-version of 1999/02/18
* Fri Sep 25 1998 ro@suse.de
- fixed specfile
* Fri Sep 25 1998 ro@suse.de
- update: use cvs-version of 980925
  edited db/Makefile to ignore messed up target-dependency
* Mon Sep 21 1998 ro@suse.de
- update: use cvs-version of 980921
* Mon Sep 14 1998 ro@suse.de
- update: use today's cvs-version
* Wed Sep  2 1998 ro@suse.de
- build for 586 since egcs generates code for 686 that does NOT run
  on 586 !!! (eg strtok)
* Fri Aug 21 1998 ro@suse.de
- updated to cvs-version 20.8.98
  added gettext as neededforbuild (so configure shuts up)
  glibc-linuxthreads is contained in main archive now
* Tue Jun 16 1998 ro@suse.de
- added symlink usr/include/X11
* Thu May 28 1998 ro@suse.de
- added symlinks to linux include files
* Thu May 28 1998 bs@suse.de
- moved ".so" Links to package libc.
* Wed May 27 1998 bs@suse.de
- changed version do `date`
* Wed May 27 1998 ro@suse.de
- created specfile to build libc, shlibs, libd, libcinfo
    localedb, timezone,
- former libc renamed to libc5.
