#
# spec file for package pam-config
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           pam-config
Version:        1.1
Release:        150600.16.8.1
Summary:        Modify common PAM configuration files
License:        GPL-2.0-only
Group:          System/Management
URL:            https://github.com/SUSE/pam-config
Source:         %{name}-%{version}.tar.xz
Patch1:         pam-config-remove-bad-access-call.patch
Patch2:         pam-config-fix-pam_keyinit-options.patch
Patch3:         pam-config-add-systemd_home-support.patch
Patch4:         pam-config-fix-pam_gnome_keyring.patch
Patch5:         pam-config-change-check-for-existence-of-modules.patch
Patch6:         remove-pam_env-from-auth-stack.patch
PreReq:         pam >= 1.3.0

%description
pam-config is a command line utility to maintain the common PAM
configuration files included by most PAM application configuration
files. It can be used to configure a system for different network or
hardware based authentication schemes. pam-config can also
add/adjust/remove other PAM modules and their options.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%build
%configure
make %{?_smp_mflags}

%install
%make_install
mkdir -p %{buildroot}/%{_sysconfdir}/pam.d
for i in account auth password session ; do
  touch %{buildroot}/%{_sysconfdir}/pam.d/common-$i-pc
done
%find_lang pam-config

%post
if [ ! -f %{_sysconfdir}/pam.d/common-auth-pc ] ; then
  pam-config --debug --create --force
else
  pam-config --debug --update ||:
fi

%postun
if [ $1 = 0 ]; then
  # Deinstall
  dir=%{_sysconfdir}/security
  for conf in pam_unix2.conf pam_pwcheck.conf ; do
    if [ -f $dir/$conf.pam-config-backup -a ! -f $dir/$conf ]; then
      mv -v $dir/$conf.pam-config-backup $dir/$conf
    fi
  done
  dir=%{_sysconfdir}/pam.d
  for pamd in common-account common-auth common-password common-session ; do
    if [ -f $dir/$pamd.pam-config-backup -a -L $dir/$pamd ]; then
      rm -v $dir/$pamd && mv -v $dir/$pamd.pam-config-backup $dir/$pamd
    fi
    # common-*-pc are ghost, so we have to move them away...
    if [ -f $dir/$pamd-pc ]; then
      mv -v $dir/$pamd-pc $dir/$pamd-pc.bak
    fi
  done
fi

%triggerpostun -- pam-modules
[ $2 = 0 ] || exit 0
pam-config --debug --update ||:

%files -f pam-config.lang
%license COPYING
%{_sbindir}/pam-config
%{_mandir}/man8/pam-config.8*
%ghost %config %{_sysconfdir}/pam.d/common-account-pc
%ghost %config %{_sysconfdir}/pam.d/common-auth-pc
%ghost %config %{_sysconfdir}/pam.d/common-password-pc
%ghost %config %{_sysconfdir}/pam.d/common-session-pc

%changelog
* Fri May 16 2025 valentin.lefebvre@suse.com
- Stop adding pam_env in AUTH stack, and be sure to put this module at the
  really end of the SESSION stack.
  [bsc#1243226, CVE-2025-6018, remove-pam_env-from-auth-stack.patch]
* Tue Aug 27 2024 valentin.lefebvre@suse.com
- Change check for existence of modules.
  If we have a biarch architecture, we check that the 64bit
  PAM module is there and report an error if not. For the 32bit
  variant, we only issue a warning.
  [pam-config-change-check-for-existence-of-modules.patch, bsc#1227216]
* Tue Feb 20 2024 valentin.lefebvre@suse.com
- Fix pam_gnome_keyring module for AUTH.
  [pam-config-fix-pam_gnome_keyring.patch, bsc#1219767]
* Mon Oct 16 2023 valentin.lefebvre@suse.com
- Add pam_systemd_home module for the version 254 of systemd
  [pam-config-add-systemd_home-support.patch, bsc#1216318]
* Wed Jun  9 2021 josef.moellers@suse.com
- Add "revoke" to the option list for pam_keyinit
  (Remove some leftover debugs while we're at it)
  [pam-config-fix-pam_keyinit-options.patch]
* Wed Jun  9 2021 josef.moellers@suse.com
- prior to writing an service-specific config file, the main function
  calls access() on the destination file in /etc/pam.d.
  This will fail and no config file will be written when the original
  config file was installed in /usr/etc/pam.d.
  A similar problem exists when creating the new service file:
  create_service_file() wants to give the new service file the same
  user, group and mode as the old one, but the old one may not exist.
  In that case, set these to 0(root), 0(root), and 0644.
  [pam-config-remove-bad-access-call.patch, bsc#1187091]
* Tue Jul 16 2019 kukuk@suse.de
- Update to version 1.1:
  - enhance comments in common-*-pc files
* Tue Mar 26 2019 kukuk@suse.de
- Update to version 1.0:
  - Add search in different locations for config files
  - Add support for pam_mktemp [bsc#1123878]
* Mon Dec 10 2018 kukuk@suse.de
- Update to version 0.96:
  * Add missing pam_cracklib options [bsc#1114835]
* Wed Apr 11 2018 kukuk@suse.de
- Add triggerun script: update config if pam-modules is removed
  [bsc#1088863]
* Fri Feb 23 2018 kukuk@suse.com
- Use %%license instead of %%doc [bsc#1082318]
* Thu Feb 22 2018 kukuk@suse.de
- Update to version 0.95:
  - fix migration from pam_unix2/pam_pwcheck to pam_unix/pam_cracklib
* Mon Jan 15 2018 kukuk@suse.de
- Update to version 0.94: add support for keyinit [bsc#1045886]
* Fri Oct 20 2017 kukuk@suse.de
- Update to version 0.93: Teach pam_cracklib module about
  enforce_for_root [bnc#929079, FATE#312643].
* Wed Aug  9 2017 kukuk@suse.de
- Update to version 0.92
  - add pam_kwallet5 support
  - move pam_systemd before pam_krb5 [bsc#1014995]
  - obsoletes gcc7-Add-break-to-a-case-label.patch
* Mon Jan  9 2017 mliska@suse.cz
- Add gcc7-Add-break-to-a-case-label.patch: fix new warning reported
  by GCC7.
* Thu Jun 23 2016 kukuk@suse.de
- Update to version 0.91
  - Adjust for Linux-PAM 1.3.0
  - Automatically replace obsolete PAM modules no longer installed
  - Extend error messages
* Fri Apr  1 2016 kukuk@suse.de
- Update to version 0.89
  - Includes pam_google_authenticator.patch
  - Better check for dual-arch PAM stack
* Sat Dec 13 2014 ledest@gmail.com
- fix bashism in postun script
* Wed Nov 12 2014 kukuk@suse.de
- Added pam_google_authenticator.patch: support google authentiator
  [bnc#888149]
* Thu Sep 25 2014 kukuk@suse.de
- Update to pam-config 0.88
  - Add pam_ecryptfs to password section [bnc#895096]
* Wed Apr  2 2014 kukuk@suse.de
- Update to pam-config 0.87
  - Add support for pam_access.so
- Rervert last change, it will break manually adjusted config
  files as documented
* Mon Mar 17 2014 speilicke@suse.com
- "pam-config --debug --update" in the %%post section fails if any
  /etc/pam.d/common-$TYPE file is not a symlink to /etc/pam.d/common-$TYPE-pc.
  Fix that by adding '--force'. This is mainly an update issue since
  fresh configs are created appropriatly
* Thu Feb  7 2013 kukuk@suse.de
- Remove last change regarding sha512, is now solved directly by
  pam_unix.so.
* Mon Feb  4 2013 kukuk@suse.de
- Add sha512 and shadow to pam_unix.so when creating common-passwd-pc
  by default, did somehow got lost [bnc#801970]
* Mon Nov 12 2012 kukuk@suse.de
- Use --create --force for new installation
- Update to pam-config 0.84
  - Add pam_env per default
  - Don't print wrong error messages
* Tue Sep 25 2012 kukuk@suse.de
- Update to pam-config 0.83:
  - Fix stacking of pam_unix
  - Add new pam_unix options
* Thu Sep 20 2012 kukuk@suse.de
- Use pam_unix and pam_cracklib as default on fresh installations.
* Tue Aug 14 2012 vcizek@suse.com
- make pam_ssh a sufficient auth module (bnc#730851)
* Tue Aug  7 2012 kukuk@suse.de
- Update to pam-config 0.81:
  - pam_ssh: fix try_first_pass bug fixed [bnc#773560]
  - pam_ecryptfs: fix order, still does not work with
    krb5 [bnc#740110]
* Tue Apr  3 2012 kukuk@suse.de
- Add support for pam_ecryptfs [bnc#752851]
* Wed Dec  7 2011 jengelh@medozas.de
- Remove redundant/unwanted tags/section (cf. specfile guidelines)
- Use %%_smp_mflags for parallel building
* Fri Dec  2 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Wed Aug 17 2011 fcrozat@suse.com
- Add pam_systemd.patch: Add pam_systemd support
* Tue May 10 2011 kukuk@suse.de
- Version 0.79
  * Make pam_lastlog optional [bnc#686034].
  * Document that if symlinks don't point to *-pc files config is
    ignored [FATE#310739].
* Wed Oct 13 2010 kukuk@suse.de
- Version 0.78
  * Add pam_fprintd support [bnc#644168]
  * Move pam_env at the end of session stack
* Tue Aug 31 2010 kukuk@suse.de
- Version 0.77
  * Fix check for lib64 [bnc#635098]
  * Add pam_sss support
* Wed Aug 25 2010 kukuk@suse.de
- Version 0.76
  * Add pam_fprint (patch from ro@suse.de)
* Wed Aug 11 2010 kukuk@suse.de
- Version 0.75
  * Update translations
  * Add pam_exec support
  * Rewrite pam_make rules to use pam_exec
* Tue Jun 29 2010 kukuk@suse.de
- Version 0.74
  * Fix typo in warning
  * Update translations
* Tue Dec  8 2009 jengelh@medozas.de
- enable parallel building
* Tue Dec  1 2009 mc@suse.de
- Version 0.73
  * Add support for pam_passwdqc
  * Print warning if cracklib-minlen <= 5 is used (bnc#539053)
* Wed Jul 29 2009 mc@novell.com
- Version 0.72
  * src/mod_pam_gnome_keyring.c: enable use_authtok and support
    new option only_if. (bnc#523379)
* Fri May  8 2009 mc@suse.de
- Version 0.71
  * re-add lost query option [bnc#501341]
* Thu Apr 30 2009 kukuk@suse.de
- Version 0.70
  * Fix try_first_pass handling for pam_ssh [bnc#499711]
* Wed Mar 25 2009 kukuk@suse.de
- Version 0.69
  * Add --verify option.
  * pam_cracklib is now default instead of pam_pwcheck
    [FATE#305468].
* Mon Dec  1 2008 mc@suse.de
- Version 0.68
  * fix linking; accept relative links (bnc#450019)
  * fix some testcases
  * Update translations.
* Fri Nov 21 2008 kukuk@suse.de
- Version 0.67
  * Update translations.
  * Add type option for pam_pwhistory.
* Mon Nov 10 2008 mc@suse.de
- No options in AUTH section for gnome-keyring (bnc#43189)
* Fri Nov  7 2008 mc@suse.de
- Version 0.66
  * delete option, if argument is 0 (bnc#442552)
  * Add support for pam_gnome_keyring [bnc#440448].
  * Implement nullok for single services, too [bnc#440437].
* Wed Nov  5 2008 mc@suse.de
- Version 0.65
  * fix error at option parsing.(bnc#440436)
  * update translations.
* Wed Oct 22 2008 mc@suse.de
- configure pam_selinux with open and close option
* Tue Oct 21 2008 mc@suse.de
- Version 0.64
  - Add support for pam_selinux
* Tue Oct 14 2008 kukuk@suse.de
- Version 0.63
  - Add support for pam_pwhistory
* Tue Oct  7 2008 mc@suse.de
- Version 0.62
- add support for pam_fp
* Mon Oct  6 2008 mc@suse.de
- Version 0.61
  * print correct error message if sanity check fails
  * fix the loose of values in case of some string options.
    (bnc#414447)
* Thu Sep  4 2008 kukuk@suse.de
- Version 0.60
  * Generate manual page from internal data
  * Remove obsolete pam_pwcheck options
* Fri Aug 29 2008 mc@suse.de
- Version 0.59
  * skip unix password change for uid > 999 in case of krb5 is used.
  * set LANG=C when running checks
  * Update translations.
* Fri Aug 22 2008 mc@suse.de
- Version 0.58
  * return correct query result in case of
  - -ldap vs. --ldap-account_only
* Mon Jul 28 2008 sschober@suse.de
- Version 0.57
  * fix pam_mount: use "optional" in session stack [bnc#409541]
* Mon Jul 14 2008 kukuk@suse.de
- Version 0.56
  * Add is_enabled to pam_csync
* Thu Jul 10 2008 kukuk@suse.de
- Version 0.55
  * Add pam_csync support [FATE#303805]
* Mon Jun 30 2008 kukuk@suse.de
- Version 0.54
  * Add pam_ssh support (to start ssh-agent, not for authentication)
* Fri May 23 2008 kukuk@suse.de
- Version 0.53
  * Better debug messages on writing config files
  * Fix handling of backup files
  (both found when debugging [bnc#392950])
  * Update translations
* Tue Apr  1 2008 mc@suse.de
- Version 0.52
  * fix missing pam_localuser (bnc#371558)
  * update localization files
* Mon Mar 10 2008 mc@suse.de
- Version 0.51
  - adapt krb5 support to new pam_krb5 version
* Wed Feb 13 2008 kukuk@suse.de
- Version 0.50
  - Add pam_time and pam_group support
  - Rewrite option handling
* Fri Nov 23 2007 mc@suse.de
- Version 0.27
  - Move write_config after sanitize_check calles
* Wed Nov 14 2007 mc@suse.de
- Version 0.26
  - Add support for ldap-account_only
* Tue Nov 13 2007 mc@suse.de
- Version 0.25
  - Do not check for installed pam-module on
    delete request [#337369].
  - fix missconfiguration of pam_krb5 [#335521]
* Thu Oct 25 2007 sschober@suse.de
- Version 0.24:
  - Bug fixing [#328519]
  - integrated testsuite
* Tue Aug 14 2007 sschober@suse.de
- Version 0.23:
  - Bug fixing
  - Support for pam_thinkfinger [#300201] [Fate#301952]
* Tue Aug 14 2007 sschober@suse.de
- Version 0.22:
  - Bug fixing
  - Support for pam_ck_connector [#297559]
* Fri Jul 27 2007 kukuk@suse.de
- Version 0.21:
  - Add translations
  - Bug fixing
  - Add pam_cryptpass
* Fri Jul  6 2007 kukuk@suse.de
- Version 0.20:
  - Rewrite internal interface
  - Add pam_unix and pam_mount
* Wed Jun 27 2007 kukuk@suse.de
- Version 0.16:
  - Add support for pam_lastlog and pam_loginuid
* Mon Jan 29 2007 kukuk@suse.de
- Version 0.15:
  - Fix -d handling of minlen option of pam_pwcheck
* Fri Jan 26 2007 kukuk@suse.de
- Version 0.14:
  - Add --krb5_ignore_unknown_principals option
  - Add --pam_pwcheck-no_minlen option [bnc#227395]
* Wed Oct 25 2006 kukuk@suse.de
- Version 0.13:
  - Add pam_capability support
  - pam_apparmor should only be optional [Fate#300510]
* Wed Sep 20 2006 kukuk@suse.de
- Fix debug flag handling for pam_cracklib/pam_pwcheck
* Thu Sep 14 2006 kukuk@suse.de
- Version 0.11:
  - Changes to account stack with krb5 and ldap
  - Add support for pam_umask.so
* Thu Aug 31 2006 kukuk@suse.de
- Version 0.10:
  - Fix first install if pam-modules was updated before
  - Document missing options in manual page
* Fri Aug 25 2006 kukuk@suse.de
- Version 0.9:
  - Add pam_winbind support
  - Rename pam_krb5afs to pam_krb5 if we find it
  - Support minimum_uid for pam_krb5
* Fri Aug 25 2006 kukuk@suse.de
- Add LUM support and no_obscure_checks to pam_pwcheck (0.8)
* Thu Aug 24 2006 kukuk@suse.de
- Version 0.7:
  - Add support for pam_cracklib.
  - Add support for pam_apparmor.
  - Fix stacking of pam_unix2 with pam_ldap.
* Wed Aug 23 2006 kukuk@suse.de
- Fix stacking of modules, add query option for YaST2 (version 0.6)
* Tue Aug 22 2006 kukuk@suse.de
- Bug fixes, add --update option (version 0.5)
* Tue Aug 22 2006 kukuk@suse.de
- Add support for ccreds and pkcs11 (version 0.4)
* Mon Aug 21 2006 kukuk@suse.de
- Add support for ldap and krb5 (version 0.3)
* Mon Aug 21 2006 kukuk@suse.de
- Add documentation (version 0.2)
* Sun Aug 20 2006 kukuk@suse.de
- Initial release
