#
# spec file for package krb5
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir %{_localstatedir}/adm/fillup-templates
%endif
Name:           krb5
Version:        1.20.1
Release:        150600.11.14.1
Summary:        MIT Kerberos5 implementation
License:        MIT
URL:            https://kerberos.org/dist/
Source0:        https://kerberos.org/dist/krb5/1.20/krb5-%{version}.tar.gz
Source1:        https://kerberos.org/dist/krb5/1.20/krb5-%{version}.tar.gz.asc
Source2:        krb5.keyring
Source3:        vendor-files.tar.bz2
Source4:        baselibs.conf
Source5:        krb5-rpmlintrc
Source6:        ksu-pam.d
Source7:        krb5.tmpfiles
Patch1:         0001-ksu-pam-integration.patch
Patch2:         0002-krb5-1.9-manpaths.patch
Patch3:         0003-Adjust-build-configuration.patch
Patch4:         0004-krb5-1.6.3-gssapi_improve_errormessages.patch
Patch5:         0005-krb5-1.6.3-ktutil-manpage.patch
Patch6:         0006-krb5-1.12-api.patch
Patch7:         0007-SELinux-integration.patch
Patch8:         0008-krb5-1.9-debuginfo.patch
Patch9:         0009-Ensure-array-count-consistency-in-kadm5-RPC.patch
Patch10:        0010-Fix-three-memory-leaks.patch
Patch11:        0011-Fix-vulnerabilities-in-GSS-message-token-handling.patch
Patch12:        0012-Allow-KRB5KDF-in-FIPS-mode.patch
Patch13:        0013-Prevent-overflow-when-calculating-ulog-block-size.patch
Patch14:        0014-man-Remove-references-to-LMDB-backend.patch
Patch15:        0015-CVE-2025-3576.patch
BuildRequires:  autoconf
BuildRequires:  bison
BuildRequires:  cyrus-sasl-devel
BuildRequires:  keyutils
BuildRequires:  keyutils-devel
BuildRequires:  openldap2-devel
BuildRequires:  pam-devel
BuildRequires:  pkgconfig
BuildRequires:  pkgconfig(com_err)
BuildRequires:  pkgconfig(libselinux)
BuildRequires:  pkgconfig(libssl)
BuildRequires:  pkgconfig(libverto)
BuildRequires:  pkgconfig(ncurses)
BuildRequires:  pkgconfig(ss)
BuildRequires:  pkgconfig(systemd)
%if 0%{?suse_version} >= 1550 || 0%{?sle_version} >= 150400
BuildRequires:  crypto-policies
Requires:       crypto-policies
%endif
# bug437293
%ifarch ppc64
Obsoletes:      krb5-64bit
%endif
Conflicts:      krb5-mini
Obsoletes:      krb5-plugin-preauth-pkinit-nss

%description
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of clear text passwords.

%package client
Summary:        Client programs of the MIT Kerberos5 implementation
Conflicts:      krb5-mini

%description client
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of cleartext passwords. This package includes some required
client programs, like kinit, kadmin, ...

%package server
Summary:        Server program of the MIT Kerberos5 implementation
Requires:       cron
Requires:       libverto-libev1
Requires:       logrotate
Requires:       perl-Date-Calc
Requires(post): %fillup_prereq
%{?systemd_requires}

%description server
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of cleartext passwords. This package includes the kdc, kadmind
and more.

%package plugin-kdb-ldap
Summary:        LDAP database plugin for MIT Kerberos5
Requires:       krb5-server = %{version}

%description plugin-kdb-ldap
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of clear text passwords. This package contains the LDAP
database plugin.

%package plugin-preauth-pkinit
Summary:        PKINIT preauthentication plugin for MIT Kerberos5

%description plugin-preauth-pkinit
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of cleartext passwords. This package includes a PKINIT plugin.

%package plugin-preauth-otp
Summary:        OTP preauthentication plugin for MIT Kerberos5

%description plugin-preauth-otp
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of cleartext passwords. This package includes a OTP plugin.

%package plugin-preauth-spake
Summary:        SPAKE preauthentication plugin for MIT Kerberos5

%description plugin-preauth-spake
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of cleartext passwords. This package includes a SPAKE plugin.

%package doc
Summary:        Documentation for the MIT Kerberos5 implementation

%description doc
Kerberos V5 is a trusted-third-party network authentication
system,which can improve network security by eliminating the
insecurepractice of clear text passwords. This package includes
extended documentation for MIT Kerberos.

%package devel
Summary:        Development files for MIT Kerberos5
Requires:       %{name} = %{version}
Requires:       keyutils-devel
Requires:       pkgconfig(com_err)
Requires:       pkgconfig(libverto)
Requires:       pkgconfig(ss)
# bug437293
%ifarch ppc64
Obsoletes:      krb5-devel-64bit
%endif
Conflicts:      krb5-mini-devel

%description devel
Kerberos V5 is a trusted-third-party network authentication system,
which can improve network security by eliminating the insecure
practice of cleartext passwords. This package includes Libraries and
Include Files for Development

%define srcRoot krb5-%{version}
%define vendorFiles %{_builddir}/%{srcRoot}/vendor-files/
%define krb5docdir  %{_defaultdocdir}/krb5

%prep
%setup -q -n %{srcRoot}
%setup -q -a 3 -T -D -n %{srcRoot}
%autopatch -p1

%build
# needs to be re-generated
rm -f src/lib/krb5/krb/deltat.c
cd src
autoreconf -fi
DEFCCNAME=DIR:/run/user/%%{uid}/krb5cc; export DEFCCNAME
%configure \
        CFLAGS="%{optflags} -I%{_includedir}/et -fno-strict-aliasing -D_GNU_SOURCE -fPIC $(getconf LFS_CFLAGS)" \
        CPPFLAGS="-I%{_includedir}/et " \
        SS_LIB="-lss" \
	--prefix=/usr/lib/mit \
	--sysconfdir=%{_sysconfdir} \
	--mandir=%{_mandir} \
	--infodir=%{_infodir} \
	--libexecdir=/usr/lib/mit/sbin \
	--bindir=%{_prefix}/lib/mit/bin \
	--sbindir=%{_prefix}/lib/mit/sbin \
	--datadir=%{_prefix}/lib/mit/share \
	--libdir=%{_libdir} \
	--includedir=%{_includedir} \
	--localstatedir=%{_localstatedir}/lib/kerberos \
	--localedir=%{_datadir}/locale \
	--enable-shared \
	--disable-static \
	--enable-dns-for-realm \
	--disable-rpath \
	--with-ldap \
	--with-pam \
	--enable-pkinit \
	--with-crypto-impl=openssl \
	--with-selinux \
	--with-system-et \
	--with-system-ss \
	--with-system-verto

%make_build

# Copy kadmin manual page into kadmin.local's due to the split between client and server package
cp man/kadmin.man man/kadmin.local.8

%install
mkdir -p %{buildroot}/%{_localstatedir}/log/krb5
%make_install -C src
# Munge krb5-config yet again.  This is totally wrong for 64-bit, but chunks
# of the buildconf patch already conspire to strip out /usr/<anything> from the
# list of link flags, and it helps prevent file conflicts on multilib systems.
sed -r -i -e 's|^libdir=%{_prefix}/lib(64)?$|libdir=%{_prefix}/lib|g' %{buildroot}%{_prefix}/lib/mit/bin/krb5-config

# And again. krb5-config does not distinguish between libdir, includedir,
# just exec_prefix. Libraries and headers not installed under /usr/lib/mit
# prefix (bsc#1174079).
sed -r -i -e 's|^prefix=%{_prefix}/lib/mit$|prefix=/usr|g' %{buildroot}%{_prefix}/lib/mit/bin/krb5-config
sed -r -i -e 's|^exec_prefix=\$\{prefix\}$|exec_prefix=%{_prefix}/lib/mit|g' %{buildroot}%{_prefix}/lib/mit/bin/krb5-config

# install autoconf macro
mkdir -p %{buildroot}/%{_datadir}/aclocal
install -m 644 src/util/ac_check_krb5.m4 %{buildroot}%{_datadir}/aclocal/
# install sample config files
# I'll probably do something about this later on
mkdir -p %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_sysconfdir}/krb5.conf.d
mkdir -p %{buildroot}%{_sysconfdir}/profile.d/
mkdir -p %{buildroot}%{_localstatedir}/log/krb5
# create plugin directories
mkdir -p %{buildroot}/%{_libdir}/krb5/plugins/kdb
mkdir -p %{buildroot}/%{_libdir}/krb5/plugins/preauth
mkdir -p %{buildroot}/%{_libdir}/krb5/plugins/libkrb5
mkdir -p %{buildroot}/%{_libdir}/krb5/plugins/tls
install -m 644 %{vendorFiles}/krb5.conf %{buildroot}%{_sysconfdir}
install -m 644 %{vendorFiles}/krb5.csh.profile %{buildroot}%{_sysconfdir}/profile.d/krb5.csh
install -m 644 %{vendorFiles}/krb5.sh.profile %{buildroot}%{_sysconfdir}/profile.d/krb5.sh

# Do not write directly to /var/lib/kerberos anymore as it breaks transactional
# updates. Use systemd-tmpfiles to copy the files there when it doesn't exist
install -d -m 0755 %{buildroot}%{_tmpfilesdir}
install -m 644 %{SOURCE7} %{buildroot}%{_tmpfilesdir}/krb5.conf
mkdir -p %{buildroot}/%{_datadir}/kerberos/krb5kdc
# Where per-user keytabs live by default.
mkdir -p %{buildroot}/%{_datadir}/kerberos/krb5/user
install -m 600 %{vendorFiles}/kdc.conf %{buildroot}%{_datadir}/kerberos/krb5kdc/
install -m 600 %{vendorFiles}/kadm5.acl %{buildroot}%{_datadir}/kerberos/krb5kdc/
install -m 600 %{vendorFiles}/kadm5.dict %{buildroot}%{_datadir}/kerberos/krb5kdc/

%if 0%{?suse_version} >= 1550 || 0%{?sle_version} >= 150400
# Default include on this directory
ln -sv %{_sysconfdir}/crypto-policies/back-ends/krb5.config %{buildroot}%{_sysconfdir}/krb5.conf.d/crypto-policies
%endif

# all libs must have permissions 0755
for lib in `find %{buildroot}/%{_libdir}/ -type f -name "*.so*"`
do
  chmod 0755 ${lib}
done
# and binaries too
chmod 0755 %{buildroot}%{_prefix}/lib/mit/bin/ksu
# install systemd files
%if 0%{?suse_version} >= 1210
mkdir -p %{buildroot}%{_unitdir}
install -m 644 %{vendorFiles}/kadmind.service %{buildroot}%{_unitdir}
install -m 644 %{vendorFiles}/krb5kdc.service %{buildroot}%{_unitdir}
install -m 644 %{vendorFiles}/kpropd.service %{buildroot}%{_unitdir}
%else
# install init scripts
mkdir -p %{buildroot}%{_sysconfdir}/init.d
install -m 755 %{vendorFiles}/kadmind.init %{buildroot}%{_sysconfdir}/init.d/kadmind
install -m 755 %{vendorFiles}/krb5kdc.init %{buildroot}%{_sysconfdir}/init.d/krb5kdc
install -m 755 %{vendorFiles}/kpropd.init  %{buildroot}%{_sysconfdir}/init.d/kpropd
%endif
# install sysconfig templates
mkdir -p %{buildroot}/%{_fillupdir}
install -m 644 %{vendorFiles}/sysconfig.kadmind %{buildroot}/%{_fillupdir}/
install -m 644 %{vendorFiles}/sysconfig.krb5kdc %{buildroot}/%{_fillupdir}/
# install logrotate files
mkdir -p %{buildroot}%{_sysconfdir}/logrotate.d
install -m 644 %{vendorFiles}/krb5-server.logrotate %{buildroot}%{_sysconfdir}/logrotate.d/krb5-server
find . -type f -name '*.ps' -exec gzip -9 {} +
# create rc* links
mkdir -p %{buildroot}%{_bindir}/
mkdir -p %{buildroot}%{_sbindir}/
ln -s service %{buildroot}%{_sbindir}/rckadmind
ln -s service %{buildroot}%{_sbindir}/rckrb5kdc
ln -s service %{buildroot}%{_sbindir}/rckpropd
# create links for kinit and klist, because of the java ones
ln -sf ../../usr/lib/mit/bin/kinit   %{buildroot}%{_bindir}/kinit
ln -sf ../../usr/lib/mit/bin/klist   %{buildroot}%{_bindir}/klist
# install doc
install -d -m 755 %{buildroot}/%{krb5docdir}
install -m 644 %{_builddir}/%{srcRoot}/README %{buildroot}/%{krb5docdir}/README
install -d -m 755 %{buildroot}/%{_datadir}/kerberos/ldap
install -m 644 %{_builddir}/%{srcRoot}/src/plugins/kdb/ldap/libkdb_ldap/kerberos.schema %{buildroot}/%{_datadir}/kerberos/ldap/kerberos.schema
install -m 644 %{_builddir}/%{srcRoot}/src/plugins/kdb/ldap/libkdb_ldap/kerberos.ldif %{buildroot}/%{_datadir}/kerberos/ldap/kerberos.ldif
# link pam-config for su to ksu
mkdir -p %{buildroot}%{_sysconfdir}/pam.d/
install -m 644 %{SOURCE6} %{buildroot}%{_sysconfdir}/pam.d/ksu

# cleanup
rm -f  %{buildroot}%{_mandir}/man1/tmac.doc*
rm -f  %{_mandir}/man1/tmac.doc* html/.doctrees/environment.pickle
rm -rf %{buildroot}%{_prefix}/lib/mit/share/examples
# manually remove test plugin since configure doesn't support disabling it at build time
rm -f %{buildroot}/%{_libdir}/krb5/plugins/preauth/test.so

%if "%{_lto_cflags}" != ""
# Don't add the lto flags to the public link flags.
sed -i "s/%{_lto_cflags}//" %{buildroot}%{_prefix}/lib/mit/bin/krb5-config
%endif

%find_lang mit-krb5

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%preun server
%service_del_preun krb5kdc.service kadmind.service kpropd.service

%postun server
%service_del_postun krb5kdc.service kadmind.service kpropd.service

%post server
%service_add_post krb5kdc.service kadmind.service kpropd.service
%tmpfiles_create krb5.conf
%{fillup_only -n kadmind}
%{fillup_only -n krb5kdc}
%{fillup_only -n kpropd}

%pre server
%service_add_pre krb5kdc.service kadmind.service kpropd.service

%post plugin-kdb-ldap -p /sbin/ldconfig
%postun plugin-kdb-ldap -p /sbin/ldconfig

%files devel
%dir %{_prefix}/lib/mit
%dir %{_prefix}/lib/mit/bin
%dir %{_prefix}/lib/mit/sbin
# XXX %dir %{_prefix}/lib/mit/share
%dir %{_datadir}/aclocal
%{_libdir}/libgssrpc.so
%{_libdir}/libk5crypto.so
%{_libdir}/libkadm5clnt_mit.so
%{_libdir}/libkadm5clnt.so
%{_libdir}/libkadm5srv_mit.so
%{_libdir}/libkadm5srv.so
%{_libdir}/libkdb5.so
%{_libdir}/libkrb5.so
%{_libdir}/libkrb5support.so
%{_libdir}/libkrad.so
%{_libdir}/pkgconfig/gssrpc.pc
%{_libdir}/pkgconfig/kadm-client.pc
%{_libdir}/pkgconfig/kadm-server.pc
%{_libdir}/pkgconfig/kdb.pc
%{_libdir}/pkgconfig/krb5-gssapi.pc
%{_libdir}/pkgconfig/krb5.pc
%{_libdir}/pkgconfig/mit-krb5-gssapi.pc
%{_libdir}/pkgconfig/mit-krb5.pc
%{_includedir}/*
%{_prefix}/lib/mit/bin/krb5-config
%{_prefix}/lib/mit/sbin/krb5-send-pr
%{_mandir}/man1/krb5-config.1%{?ext_man}
%{_datadir}/aclocal/ac_check_krb5.m4

%files -f mit-krb5.lang
%dir %{krb5docdir}
# add plugin directories
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/kdb
%dir %{_libdir}/krb5/plugins/preauth
%dir %{_libdir}/krb5/plugins/libkrb5
%dir %{_libdir}/krb5/plugins/tls
# add log directory
%attr(0700,root,root) %dir %{_localstatedir}/log/krb5
%doc %{krb5docdir}/README
%attr(0644,root,root) %config(noreplace) %{_sysconfdir}/krb5.conf
%dir %{_sysconfdir}/krb5.conf.d
%attr(0644,root,root) %config /etc/profile.d/krb5*
%if 0%{?suse_version} >= 1550 || 0%{?sle_version} >= 150400
%config(noreplace,missingok) %{_sysconfdir}/krb5.conf.d/crypto-policies
%endif
%{_libdir}/libgssapi_krb5.*
%{_libdir}/libgssrpc.so.*
%{_libdir}/libk5crypto.so.*
%{_libdir}/libkadm5clnt_mit.so.*
%{_libdir}/libkadm5srv_mit.so.*
%{_libdir}/libkdb5.so.*
%{_libdir}/libkrb5.so.*
%{_libdir}/libkrb5support.so.*
%{_libdir}/libkrad.so.*
%{_libdir}/krb5/plugins/tls/*.so

%files server
%attr(0700,root,root) %dir %{_localstatedir}/log/krb5
%config(noreplace) %{_sysconfdir}/logrotate.d/krb5-server
%{_unitdir}/kadmind.service
%{_unitdir}/krb5kdc.service
%{_unitdir}/kpropd.service
%{_tmpfilesdir}/krb5.conf
%dir %{krb5docdir}
%dir %{_prefix}/lib/mit
%dir %{_prefix}/lib/mit/sbin
%dir %{_datadir}/kerberos/
%dir %{_datadir}/kerberos/krb5kdc
%dir %{_datadir}/kerberos/krb5
%dir %{_datadir}/kerberos/krb5/user
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/kdb
%dir %{_libdir}/krb5/plugins/tls
%attr(0600,root,root) %config(noreplace) %{_datadir}/kerberos/krb5kdc/kdc.conf
%attr(0600,root,root) %config(noreplace) %{_datadir}/kerberos/krb5kdc/kadm5.acl
%attr(0600,root,root) %config(noreplace) %{_datadir}/kerberos/krb5kdc/kadm5.dict
%ghost %dir %{_sharedstatedir}/kerberos/
%ghost %dir %{_sharedstatedir}/kerberos/krb5kdc
%ghost %dir %{_sharedstatedir}/kerberos/krb5
%ghost %dir %{_sharedstatedir}/kerberos/krb5/user
%ghost %attr(0600,root,root) %config(noreplace) %{_sharedstatedir}/kerberos/krb5kdc/kdc.conf
%ghost %attr(0600,root,root) %config(noreplace) %{_sharedstatedir}/kerberos/krb5kdc/kadm5.acl
%ghost %attr(0600,root,root) %config(noreplace) %{_sharedstatedir}/kerberos/krb5kdc/kadm5.dict
%{_fillupdir}/sysconfig.*
%{_sbindir}/rc*
%{_prefix}/lib/mit/sbin/kadmin.local
%{_prefix}/lib/mit/sbin/kadmind
%{_prefix}/lib/mit/sbin/kpropd
%{_prefix}/lib/mit/sbin/kproplog
%{_prefix}/lib/mit/sbin/kprop
%{_prefix}/lib/mit/sbin/kdb5_util
%{_prefix}/lib/mit/sbin/krb5kdc
%{_prefix}/lib/mit/sbin/gss-server
%{_prefix}/lib/mit/sbin/sim_server
%{_prefix}/lib/mit/sbin/sserver
%{_prefix}/lib/mit/sbin/uuserver
%{_libdir}/krb5/plugins/kdb/db2.so
%{_mandir}/man5/kdc.conf.5%{?ext_man}
%{_mandir}/man5/kadm5.acl.5%{?ext_man}
%{_mandir}/man8/kadmind.8%{?ext_man}
%{_mandir}/man8/kadmin.local.8%{?ext_man}
%{_mandir}/man8/kpropd.8%{?ext_man}
%{_mandir}/man8/kprop.8%{?ext_man}
%{_mandir}/man8/kproplog.8%{?ext_man}
%{_mandir}/man8/kdb5_util.8%{?ext_man}
%{_mandir}/man8/krb5kdc.8%{?ext_man}
%{_mandir}/man8/sserver.8%{?ext_man}

%files client
%attr(0644,root,root) %config(noreplace) %{_sysconfdir}/pam.d/ksu
%{_prefix}/lib/mit/bin/kvno
%{_prefix}/lib/mit/bin/kinit
%{_prefix}/lib/mit/bin/kdestroy
%{_prefix}/lib/mit/bin/kpasswd
%{_prefix}/lib/mit/bin/klist
%{_prefix}/lib/mit/bin/kadmin
%{_prefix}/lib/mit/bin/ktutil
%{_prefix}/lib/mit/bin/k5srvutil
%{_prefix}/lib/mit/bin/gss-client
%{_prefix}/lib/mit/bin/ksu
%{_prefix}/lib/mit/bin/sclient
%{_prefix}/lib/mit/bin/sim_client
%{_prefix}/lib/mit/bin/uuclient
%{_prefix}/lib/mit/bin/kswitch
%{_bindir}/kinit
%{_bindir}/klist
%{_mandir}/man1/kvno.1%{?ext_man}
%{_mandir}/man1/kinit.1%{?ext_man}
%{_mandir}/man1/kdestroy.1%{?ext_man}
%{_mandir}/man1/kpasswd.1%{?ext_man}
%{_mandir}/man1/klist.1%{?ext_man}
%{_mandir}/man1/kadmin.1%{?ext_man}
%{_mandir}/man1/ktutil.1%{?ext_man}
%{_mandir}/man1/k5srvutil.1%{?ext_man}
%{_mandir}/man1/kswitch.1%{?ext_man}
%{_mandir}/man5/krb5.conf.5%{?ext_man}
%{_mandir}/man5/.k5login.5%{?ext_man}
%{_mandir}/man5/.k5identity.5%{?ext_man}
%{_mandir}/man5/k5identity.5%{?ext_man}
%{_mandir}/man5/k5login.5%{?ext_man}
%{_mandir}/man1/ksu.1%{?ext_man}
%{_mandir}/man1/sclient.1%{?ext_man}
%{_mandir}/man7/kerberos.7%{?ext_man}

%files plugin-kdb-ldap
%dir %{_prefix}/lib/mit/sbin/
%{_prefix}/lib/mit/sbin/kdb5_ldap_util
%dir %{_datadir}/kerberos
%dir %{_datadir}/kerberos/ldap
%config %{_datadir}/kerberos/ldap/kerberos.schema
%config %{_datadir}/kerberos/ldap/kerberos.ldif
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/kdb
%{_libdir}/krb5/plugins/kdb/kldap.so
%{_libdir}/libkdb_ldap*
%{_mandir}/man8/kdb5_ldap_util.8%{?ext_man}

%files plugin-preauth-pkinit
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/preauth
%{_libdir}/krb5/plugins/preauth/pkinit.so

%files plugin-preauth-otp
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/preauth
%{_libdir}/krb5/plugins/preauth/otp.so

%files plugin-preauth-spake
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/preauth
%{_libdir}/krb5/plugins/preauth/spake.so

%changelog
* Tue Sep  2 2025 nopower@suse.com
- Remove des3-cbc-sha1 and arcfour-hmac-md5 from permitted
  enctypes unless new special options "allow_des3" or "allow_rc4"
  are set; (CVE-2025-3576); (bsc#1241219).
- Add patch 0015-CVE-2025-3576.patch
* Mon May  5 2025 scabrero@suse.de
- Remove references to the LMDB backend in the kdc.conf manpage;
  (bsc#1242060);
* Thu Jan 30 2025 scabrero@suse.de
- Prevent overflow when calculating ulog block size. An authenticated
  attacker can cause kadmind to write beyond the end of the mapped
  region for the iprop log file, likely causing a process crash;
  (CVE-2025-24528); (bsc#1236619).
- Add patch 0013-Prevent-overflow-when-calculating-ulog-block-size.patch
* Wed Jan 22 2025 scabrero@suse.de
- Add crypto-policies support; (jsc#PED-12018)
  * The default krb5.conf has been updated to include config
    snippets in the krb5.conf.d directory, where crypto-policies
    drops its.
- Allow to use KRB5KDF in FIPS mode; (jsc#PED-12018); Add patch
  0012-Allow-KRB5KDF-in-FIPS-mode.patch
  * This key derivation function is used by AES256-CTS-HMAC-SHA1-96
    and AES128-CTS-HMAC-SHA1-96 encryption types, used by Active
    directory. If these encryption types are allowed or not in
    FIPS mode is enforced now by the FIPS:AD-SUPPORT subpolicy.
* Mon Jul  1 2024 scabrero@suse.de
- Fix vulnerabilities in GSS message token handling, add patch
  0011-Fix-vulnerabilities-in-GSS-message-token-handling.patch
  * CVE-2024-37370, bsc#1227186
  * CVE-2024-37371, bsc#1227187
* Fri Mar 22 2024 scabrero@suse.de
- Fix memory leaks, add patch 0010-Fix-three-memory-leaks.patch
  * CVE-2024-26458, bsc#1220770
  * CVE-2024-26461, bsc#1220771
  * CVE-2024-26462, bsc#1220772
* Tue Nov 28 2023 scabrero@suse.de
- Update patch 0007-SELinux-integration.patch for SELinux 3.5
* Tue Sep 12 2023 scabrero@suse.de
- Avoid KDC spoofing vulnerability, enable verify_ap_req_nofail in
  krb5.conf; (jsc#PED-6213);
* Tue Aug  8 2023 scabrero@suse.de
- Ensure array count consistency in kadm5 RPC; (bsc#1214054);
  (CVE-2023-36054);
- Added patches:
  * 0009-Ensure-array-count-consistency-in-kadm5-RPC.patch
* Tue Dec 13 2022 scabrero@suse.de
- Update to 1.20.1; (bsc#1205126); (CVE-2022-42898);
  * Fix integer overflows in PAC parsing [CVE-2022-42898].
  * Fix null deref in KDC when decoding invalid NDR.
  * Fix memory leak in OTP kdcpreauth module.
  * Fix PKCS11 module path search.
- update to 1.20.0:
  * Added a "disable_pac" realm relation to suppress adding PAC authdata
    to tickets, for realms which do not need to support S4U requests.
  * Most credential cache types will use atomic replacement when a cache
    is reinitialized using kinit or refreshed from the client keytab.
  * kprop can now propagate databases with a dump size larger than 4GB,
    if both the client and server are upgraded.
  * kprop can now work over NATs that change the destination IP address,
    if the client is upgraded.
  * Updated the KDB interface.  The sign_authdata() method is replaced
    with the issue_pac() method, allowing KDB modules to add logon info
    and other buffers to the PAC issued by the KDC.
  * Host-based initiator names are better supported in the GSS krb5
    mechanism.
  * Replaced AD-SIGNEDPATH authdata with minimal PACs.
  * To avoid spurious replay errors, password change requests will not
    be attempted over UDP until the attempt over TCP fails.
  * PKINIT will sign its CMS messages with SHA-256 instead of SHA-1.
  * Updated all code using OpenSSL to be compatible with OpenSSL 3.
  * Reorganized the libk5crypto build system to allow the OpenSSL
    back-end to pull in material from the builtin back-end depending on
    the OpenSSL version.
  * Simplified the PRNG logic to always use the platform PRNG.
  * Converted the remaining Tcl tests to Python.
- update to 1.19.3 (bsc#1189929, CVE-2021-37750):
  * Fix a denial of service attack against the KDC [CVE-2021-37750].
  * Fix KDC null deref on TGS inner body null server
  * Fix conformance issue in GSSAPI tests
- Resolve "Credential cache directory /run/user/0/krb5cc does not
  exist while opening default credentials cache" by using a kernel
  keyring instead of a dir cache; (bsc#1109830);
- Added hardening to systemd services; (bsc#1181400);
- Drop 0009-Fix-KDC-null-deref-on-TGS-inner-body-null-server.patch,
  fixed in release 1.20.0
- Drop 0010-Fix-integer-overflows-in-PAC-parsing.patch,
  fixed in release 1.20.1
* Mon Nov  7 2022 nopower@suse.com
- Fix integer overflows in PAC parsing; (CVE-2022-42898);
  (bso#15203), (bsc#1205126).
- Added patches:
  * 0010-Fix-integer-overflows-in-PAC-parsing.patch
* Fri Sep 17 2021 scabrero@suse.de
- Update to 1.19.2
  * Fix a denial of service attack against the KDC encrypted challenge
    code; (CVE-2021-36222);
  * Fix a memory leak when gss_inquire_cred() is called without a
    credential handle.
- Changes from 1.19.1
  * Fix a linking issue with Samba.
  * Better support multiple pkinit_identities values by checking whether
    certificates can be loaded for each value.
- Changes from 1.19
  Administrator experience
  * When a client keytab is present, the GSSAPI krb5 mech will refresh
    credentials even if the current credentials were acquired manually.
  * It is now harder to accidentally delete the K/M entry from a KDB.
  Developer experience
  * gss_acquire_cred_from() now supports the "password" and "verify"
    options, allowing credentials to be acquired via password and
    verified using a keytab key.
  * When an application accepts a GSS security context, the new
    GSS_C_CHANNEL_BOUND_FLAG will be set if the initiator and acceptor
    both provided matching channel bindings.
  * Added the GSS_KRB5_NT_X509_CERT name type, allowing S4U2Self requests
    to identify the desired client principal by certificate.
  * PKINIT certauth modules can now cause the hw-authent flag to be set
    in issued tickets.
  * The krb5_init_creds_step() API will now issue the same password
    expiration warnings as krb5_get_init_creds_password().
  Protocol evolution
  * Added client and KDC support for Microsoft's Resource-Based Constrained
    Delegation, which allows cross-realm S4U2Proxy requests. A third-party
    database module is required for KDC support.
  * kadmin/admin is now the preferred server principal name for kadmin
    connections, and the host-based form is no longer created by default.
    The client will still try the host-based form as a fallback.
  * Added client and server support for Microsoft's KERB_AP_OPTIONS_CBT
    extension, which causes channel bindings to be required for the
    initiator if the acceptor provided them. The client will send this
    option if the client_aware_gss_bindings profile option is set.
  User experience
  * kinit will now issue a warning if the des3-cbc-sha1 encryption type is
    used in the reply. This encryption type will be deprecated and removed
    in future releases.
  * Added kvno flags --out-cache, --no-store, and --cached-only
    (inspired by Heimdal's kgetcred).
- Changes from 1.18.3
  * Fix a denial of service vulnerability when decoding Kerberos
    protocol messages; (CVE-2020-28196); (bsc#1178512);
  * Fix a locking issue with the LMDB KDB module which could cause
    KDC and kadmind processes to lose access to the database.
  * Fix an assertion failure when libgssapi_krb5 is repeatedly loaded
    and unloaded while libkrb5support remains loaded.
- Changes from 1.18.2
  * Fix a SPNEGO regression where an acceptor using the default credential
    would improperly filter mechanisms, causing a negotiation failure.
  * Fix a bug where the KDC would fail to issue tickets if the local krbtgt
    principal's first key has a single-DES enctype.
  * Add stub functions to allow old versions of OpenSSL libcrypto to link
    against libkrb5.
  * Fix a NegoEx bug where the client name and delegated credential might
    not be reported.
- Changes from 1.18.1
  * Fix a crash when qualifying short hostnames when the system has
    no primary DNS domain.
  * Fix a regression when an application imports "service@" as a GSS
    host-based name for its acceptor credential handle.
  * Fix KDC enforcement of auth indicators when they are modified by
    the KDB module.
  * Fix removal of require_auth string attributes when the LDAP KDB
    module is used.
  * Fix a compile error when building with musl libc on Linux.
  * Fix a compile error when building with gcc 4.x.
  * Change the KDC constrained delegation precedence order for consistency
    with Windows KDCs.
- Changes from 1.18
  Administrator experience:
  * Remove support for single-DES encryption types.
  * Change the replay cache format to be more efficient and robust.
    Replay cache filenames using the new format end with ".rcache2"
    by default.
  * setuid programs will automatically ignore environment variables
    that normally affect krb5 API functions, even if the caller does
    not use krb5_init_secure_context().
  * Add an "enforce_ok_as_delegate" krb5.conf relation to disable
    credential forwarding during GSSAPI authentication unless the KDC
    sets the ok-as-delegate bit in the service ticket.
  * Use the permitted_enctypes krb5.conf setting as the default value
    for default_tkt_enctypes and default_tgs_enctypes.
  Developer experience:
  * Implement krb5_cc_remove_cred() for all credential cache types.
  * Add the krb5_pac_get_client_info() API to get the client account
    name from a PAC.
  Protocol evolution:
  * Add KDC support for S4U2Self requests where the user is identified
    by X.509 certificate. (Requires support for certificate lookup from
    a third-party KDB module.)
  * Remove support for an old ("draft 9") variant of PKINIT.
  * Add support for Microsoft NegoEx. (Requires one or more third-party
    GSS modules implementing NegoEx mechanisms.)
  User experience:
  * Add support for "dns_canonicalize_hostname=fallback", causing
    host-based principal names to be tried first without DNS
    canonicalization, and again with DNS canonicalization if the
    un-canonicalized server is not found.
  * Expand single-component hostnames in host-based principal names
    when DNS canonicalization is not used, adding the system's first DNS
    search path as a suffix. Add a "qualify_shortname" krb5.conf relation
    to override this suffix or disable expansion.
  * Honor the transited-policy-checked ticket flag on application servers,
    eliminating the requirement to configure capaths on servers in some
    scenarios.
  Code quality:
  * The libkrb5 serialization code (used to export and import krb5 GSS
    security contexts) has been simplified and made type-safe.
  * The libkrb5 code for creating KRB-PRIV, KRB-SAFE, and KRB-CRED
    messages has been revised to conform to current coding practices.
  * The test suite has been modified to work with macOS System Integrity
    Protection enabled.
  * The test suite incorporates soft-pkcs11 so that PKINIT PKCS11 support
    can always be tested.
- Changes from 1.17.1
  * Fix a bug preventing "addprinc -randkey -kvno" from working in kadmin.
  * Fix a bug preventing time skew correction from working when a KCM
    credential cache is used.
- Changes from 1.17:
  Administrator experience:
  * A new Kerberos database module using the Lightning Memory-Mapped
    Database library (LMDB) has been added.  The LMDB KDB module should
    be more performant and more robust than the DB2 module, and may
    become the default module for new databases in a future release.
  * "kdb5_util dump" will no longer dump policy entries when specific
    principal names are requested.
  Developer experience:
  * The new krb5_get_etype_info() API can be used to retrieve enctype,
    salt, and string-to-key parameters from the KDC for a client
    principal.
  * The new GSS_KRB5_NT_ENTERPRISE_NAME name type allows enterprise
    principal names to be used with GSS-API functions.
  * KDC and kadmind modules which call com_err() will now write to the
    log file in a format more consistent with other log messages.
  * Programs which use large numbers of memory credential caches should
    perform better.
  Protocol evolution:
  * The SPAKE pre-authentication mechanism is now supported.  This
    mechanism protects against password dictionary attacks without
    requiring any additional infrastructure such as certificates.  SPAKE
    is enabled by default on clients, but must be manually enabled on
    the KDC for this release.
  * PKINIT freshness tokens are now supported.  Freshness tokens can
    protect against scenarios where an attacker uses temporary access to
    a smart card to generate authentication requests for the future.
  * Password change operations now prefer TCP over UDP, to avoid
    spurious error messages about replays when a response packet is
    dropped.
  * The KDC now supports cross-realm S4U2Self requests when used with a
    third-party KDB module such as Samba's.  The client code for
    cross-realm S4U2Self requests is also now more robust
    (CVE-2018-20217).
  User experience:
  * The new ktutil addent -f flag can be used to fetch salt information
    from the KDC for password-based keys.
  * The new kdestroy -p option can be used to destroy a credential cache
    within a collection by client principal name.
  * The Kerberos man page has been restored, and documents the
    environment variables that affect programs using the Kerberos
    library.
  Code quality:
  * Python test scripts now use Python 3.
  * Python test scripts now display markers in verbose output, making it
    easier to find where a failure occurred within the scripts.
  * The Windows build system has been simplified and updated to work
    with more recent versions of Visual Studio.  A large volume of
    unused Windows-specific code has been removed.  Visual Studio 2013
    or later is now required.
- Replace old $RPM_* shell vars
- Removal of SuSEfirewall2 service since SuSEfirewall2 has been replaced
  by firewalld
- Remove cruft to support distributions older than SLE 12
- Use macros where applicable
- Switch to pkgconfig style dependencies
- Use %%_tmpfilesdir instead of the wrong %%_libexecdir/tmpfiles.d
  notation: libexecdir is likely changing away from /usr/lib to
  /usr/libexec
- Build with full Cyrus SASL support. Negotiating SASL credentials with
  an EXTERNAL bind mechanism requires interaction. Kerberos provides its
  own interaction function that skips all interaction, thus preventing the
  mechanism from working.
- Removed patches:
  * 0007-krb5-1.12-ksu-path.patch
  * 0010-Add-recursion-limit-for-ASN.1-indefinite-lengths.patch
  * 0011-Fix-KDC-null-deref-on-bad-encrypted-challenge.patch
- Renamed patches:
  * 0001-krb5-1.12-pam.patch => 0001-ksu-pam-integration.patch
  * 0003-krb5-1.12-buildconf.patch => 0003-Adjust-build-configuration.patch
  * 0008-krb5-1.12-selinux-label.patch => 0007-SELinux-integration.patch
  * 0009-krb5-1.9-debuginfo.patch => 0008-krb5-1.9-debuginfo.patch
  * 0012-Fix-KDC-null-deref-on-TGS-inner-body-null-server.patch =>
    0009-Fix-KDC-null-deref-on-TGS-inner-body-null-server.patch
* Mon Aug 30 2021 scabrero@suse.de
- Fix KDC null pointer dereference via a FAST inner body that
  lacks a server field; (CVE-2021-37750); (bsc#1189929);
- Added patches:
  * 0012-Fix-KDC-null-deref-on-TGS-inner-body-null-server.patch
* Mon Jul 26 2021 scabrero@suse.de
- Fix KDC null deref on bad encrypted challenge; (CVE-2021-36222);
  (bsc#1188571);
- Added patches:
  * 0011-Fix-KDC-null-deref-on-bad-encrypted-challenge.patch
* Thu Apr 22 2021 scabrero@suse.de
- Use /run instead of /var/run for daemon PID files; (bsc#1185163);
* Mon Nov  9 2020 scabrero@suse.de
- Add recursion limit for ASN.1 indefinite lengths; (CVE-2020-28196);
  (bsc#1178512);
- Added patches:
  * 0010-Add-recursion-limit-for-ASN.1-indefinite-lengths.patch
* Mon Jul 27 2020 scabrero@suse.de
- Fix prefix reported by krb5-config, libraries and headers are not
  installed under /usr/lib/mit prefix. (bsc#1174079)
* Mon Jun  8 2020 scabrero@suse.de
- Update logrotate script, call systemd to reload the services
  instead of init-scripts. (boo#1169357)
* Mon Aug  5 2019 scabrero@suse.de
- Integrate pam_keyinit pam module, ksu-pam.d; (bsc#1081947);
  (bsc#1144047);
* Tue May  7 2019 scabrero@suse.de
- Move LDAP schema files from /usr/share/doc/packages/krb5 to
  /usr/share/kerberos/ldap; (bsc#1134217);
* Wed Jan 30 2019 scabrero@suse.de
- Upgrade to 1.16.3
  * Fix a regression in the MEMORY credential cache type which could cause
    client programs to crash.
  * MEMORY credential caches will not be listed in the global collection,
    with the exception of the default credential cache if it is of type MEMORY.
  * Remove an incorrect assertion in the KDC which could be used to cause
    a crash [CVE-2018-20217].
  * Fix bugs with concurrent use of MEMORY ccache handles.
  * Fix a KDC crash when falling back between multiple OTP tokens configured
    for a principal entry.
  * Fix memory bugs when gss_add_cred() is used to create a new credential,
    and fix a bug where it ignores the desired_name.
  * Fix the behavior of gss_inquire_cred_by_mech() when the credential does
    not contain an element of the requested mechanism.
  * Make cross-realm S4U2Self requests work on the client when no
    default_realm is configured.
  * Add a kerberos(7) man page containing documentation of the environment
    variables that affect Kerberos programs.
- Use systemd-tmpfiles to create files under /var/lib/kerberos, required
  by transactional updates; (bsc#1100126);
- Rename patches:
  * krb5-1.12-pam.patch => 0001-krb5-1.12-pam.patch
  * krb5-1.9-manpaths.dif => 0002-krb5-1.9-manpaths.patch
  * krb5-1.12-buildconf.patch => 0003-krb5-1.12-buildconf.patch
  * krb5-1.6.3-gssapi_improve_errormessages.dif to
    0004-krb5-1.6.3-gssapi_improve_errormessages.patch
  * krb5-1.6.3-ktutil-manpage.dif => 0005-krb5-1.6.3-ktutil-manpage.patch
  * krb5-1.12-api.patch => 0006-krb5-1.12-api.patch
  * krb5-1.12-ksu-path.patch => 0007-krb5-1.12-ksu-path.patch
  * krb5-1.12-selinux-label.patch =>  0008-krb5-1.12-selinux-label.patch
  * krb5-1.9-debuginfo.patch => 0009-krb5-1.9-debuginfo.patch
* Tue Oct  9 2018 jmcdonough@suse.com
- Upgrade to 1.16.1
  * kdc client cert matching on client principal entry
  * Allow ktutil addent command to ignore key version and use
    non-default salt string.
  * add kpropd pidfile support
  * enable "encrypted_challenge_indicator" realm option on tickets
    obtained using FAST encrypted challenge pre-authentication.
  * dates through 2106 accepted
  * KDC support for trivially renewable tickets
  * stop caching referral and alternate cross-realm TGTs to prevent
    duplicate credential cache entries
* Mon Jun 18 2018 mcepl@suse.com
- BSC#1021402 move %%{_libdir}/krb5/plugins/tls/k5tls.so to krb5 package
  so it is avaiable for krb5-client as well.
* Fri May  4 2018 michael@stroeder.com
- Upgrade to 1.15.3
  * Fix flaws in LDAP DN checking, including a null dereference KDC
    crash which could be triggered by kadmin clients with administrative
    privileges [CVE-2018-5729, CVE-2018-5730].
  * Fix a KDC PKINIT memory leak.
  * Fix a small KDC memory leak on transited or authdata errors when
    processing TGS requests.
  * Fix a null dereference when the KDC sends a large TGS reply.
  * Fix "kdestroy -A" with the KCM credential cache type.
  * Fix the handling of capaths "." values.
  * Fix handling of repeated subsection specifications in profile files
    (such as when multiple included files specify relations in the same
    subsection).
* Wed Apr 25 2018 luizluca@gmail.com
- Added support for /etc/krb5.conf.d/ for configuration snippets
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Mon Nov  6 2017 hguo@suse.com
- Remove build dependency doxygen, python-Cheetah, python-Sphinx,
  python-libxml2, python-lxml, most of which are python 2 programs.
  Consequently remove -doc subpackage. Users are encouraged to use
  online documentation. (bsc#1066461)
* Mon Oct  2 2017 jengelh@inai.de
- Update package descriptions.
* Mon Sep 25 2017 michael@stroeder.com
- Upgrade to 1.15.2
  * Fix a KDC denial of service vulnerability caused by unset status
    strings [CVE-2017-11368]
  * Preserve GSS contexts on init/accept failure [CVE-2017-11462]
  * Fix kadm5 setkey operation with LDAP KDB module
  * Use a ten-second timeout after successful connection for HTTPS KDC
    requests, as we do for TCP requests
  * Fix client null dereference when KDC offers encrypted challenge
    without FAST
  * Ignore dotfiles when processing profile includedir directive
  * Improve documentation
* Fri Aug 18 2017 hguo@suse.com
- Set "rdns" and "dns_canonicalize_hostname" to false in krb5.conf
  in order to improve client security in handling service principle
  names. (bsc#1054028)
* Fri Aug 11 2017 hguo@suse.com
- Prevent kadmind.service startup failure caused by absence of
  LDAP service. (bsc#903543)
* Tue Jun  6 2017 hguo@suse.com
- There is no change made about the package itself, this is only
  copying over some changelog texts from SLE package:
- bug#918595 owned by varkoly@suse.com: VUL-0: CVE-2014-5355
  krb5: denial of service in krb5_read_message
- bug#912002 owned by varkoly@suse.com: VUL-0
  CVE-2014-5352, CVE-2014-9421, CVE-2014-9422, CVE-2014-9423:
  krb5: Vulnerabilities in kadmind, libgssrpc, gss_process_context_token
- bug#910458 owned by varkoly@suse.com: VUL-1
  CVE-2014-5354: krb5: NULL pointer dereference when using keyless entries
- bug#928978 owned by varkoly@suse.com: VUL-0
  CVE-2015-2694: krb5: issues in OTP and PKINIT kdcpreauth modules leading
  to requires_preauth bypass
- bug#910457 owned by varkoly@suse.com: VUL-1
  CVE-2014-5353: krb5: NULL pointer dereference when using a ticket policy
  name as a password policy name
- bug#991088 owned by hguo@suse.com: VUL-1
  CVE-2016-3120: krb5: S4U2Self KDC crash when anon is restricted
- bug#992853 owned by hguo@suse.com: krb5: bogus prerequires
- [fate#320326](https://fate.suse.com/320326)
- bug#982313 owned by pgajdos@suse.com: Doxygen unable to resolve reference
  from \cite
* Thu Apr  6 2017 kukuk@suse.de
- Remove wrong PreRequires from krb5
* Thu Mar  9 2017 michael@stroeder.com
- use HTTPS project and source URLs
* Thu Mar  9 2017 meissner@suse.com
- use source urls.
- krb5.keyring: Added Greg Hudson
* Sat Mar  4 2017 michael@stroeder.com
- removed obsolete krb5-1.15-fix_kdb_free_principal_e_data.patch
- Upgrade to 1.15.1
  * Allow KDB modules to determine how the e_data field of principal
    fields is freed
  * Fix udp_preference_limit when the KDC location is configured with
    SRV records
  * Fix KDC and kadmind startup on some IPv4-only systems
  * Fix the processing of PKINIT certificate matching rules which have
    two components and no explicit relation
  * Improve documentation
* Fri Jan 27 2017 bwiedemann@suse.com
- remove useless environment.pickle to make build-compare happy
* Thu Jan 19 2017 asn@cryptomilk.org
- Introduce patch
  krb5-1.15-fix_kdb_free_principal_e_data.patch
  to fix freeing of e_data in the kdb principal
* Sat Dec  3 2016 michael@stroeder.com
- Upgrade to 1.15
- obsoleted Patch7 (krb5-1.7-doublelog.patch) fixed in 1.12.2
- obsoleted patch to src/util/gss-kernel-lib/Makefile.in since
  file is not available in upstream source anymore
- obsoleted Patch15 (krb5-fix_interposer.patch) fixed in 1.15
- Upgrade from 1.14.4 to 1.15 - major changes:
  Administrator experience:
  * Add support to kadmin for remote extraction of current keys without
    changing them (requires a special kadmin permission that is excluded
    from the wildcard permission), with the exception of highly
    protected keys.
  * Add a lockdown_keys principal attribute to prevent retrieval of the
    principal's keys (old or new) via the kadmin protocol.  In newly
    created databases, this attribute is set on the krbtgt and kadmin
    principals.
  * Restore recursive dump capability for DB2 back end, so sites can
    more easily recover from database corruption resulting from power
    failure events.
  * Add DNS auto-discovery of KDC and kpasswd servers from URI records,
  in addition to SRV records.  URI records can convey TCP and UDP
  servers and master KDC status in a single DNS lookup, and can also
  point to HTTPS proxy servers.
  * Add support for password history to the LDAP back end.
  * Add support for principal renaming to the LDAP back end.
  * Use the getrandom system call on supported Linux kernels to avoid
    blocking problems when getting entropy from the operating system.
  * In the PKINIT client, use the correct DigestInfo encoding for PKCS
    [#1] signatures, so that some especially strict smart cards will work.
  Code quality:
  * Clean up numerous compilation warnings.
  * Remove various infrequently built modules, including some preauth
    modules that were not built by default.
  Developer experience:
  * Add support for building with OpenSSL 1.1.
  * Use SHA-256 instead of MD5 for (non-cryptographic) hashing of
    authenticators in the replay cache.  This helps sites that must
    build with FIPS 140 conformant libraries that lack MD5.
  Protocol evolution:
  * Add support for the AES-SHA2 enctypes, which allows sites to conform
    to Suite B crypto requirements.
- Upgrade from 1.14.3 to 1.14.4 - major changes:
  * Fix some rare btree data corruption bugs
  * Fix numerous minor memory leaks
  * Improve portability (Linux-ppc64el, FreeBSD)
  * Improve some error messages
  * Improve documentation
* Mon Nov 14 2016 christof.hanke@rzg.mpg.de
- add pam configuration file required for ksu
  just use a copy of "su" one from Tumbleweed
* Fri Jul 22 2016 michael@stroeder.com
- Upgrade from 1.14.2 to 1.14.3:
  * Improve some error messages
  * Improve documentation
  * Allow a principal with nonexistent policy to bypass the minimum
    password lifetime check, consistent with other aspects of
    nonexistent policies
  * Fix a rare KDC denial of service vulnerability when anonymous client
    principals are restricted to obtaining TGTs only [CVE-2016-3120]
* Sat Jul  2 2016 idonmez@suse.com
- Remove comments breaking post scripts.
* Thu Jun 30 2016 fcrozat@suse.com
- Do no use systemd_requires macros in main package, it adds
  unneeded dependencies which pulls systemd into minimal chroot.
- Only call %%insserv_prereq when building for pre-systemd
  distributions.
- Optimise some %%post/%%postun when only /sbin/ldconfig is called.
* Tue May 10 2016 hguo@suse.com
- Remove source file ccapi/common/win/OldCC/autolock.hxx
  that is not needed and does not carry an acceptable license.
  (bsc#968111)
* Thu Apr 28 2016 michael@stroeder.com
- removed obsolete patches:
  * 0107-Fix-LDAP-null-deref-on-empty-arg-CVE-2016-3119.patch
  * krb5-mechglue_inqure_attrs.patch
- Upgrade from 1.14.1 to 1.14.2:
  * Fix a moderate-severity vulnerability in the LDAP KDC back end that
    could be exploited by a privileged kadmin user [CVE-2016-3119]
  * Improve documentation
  * Fix some interactions with GSSAPI interposer mechanisms
* Fri Apr  1 2016 hguo@suse.com
- Upgrade from 1.14 to 1.14.1:
  * Remove expired patches:
    0104-Verify-decoded-kadmin-C-strings-CVE-2015-8629.patch
    0105-Fix-leaks-in-kadmin-server-stubs-CVE-2015-8631.patch
    0106-Check-for-null-kadm5-policy-name-CVE-2015-8630.patch
    krbdev.mit.edu-8301.patch
  * Replace source archives:
    krb5-1.14.tar.gz ->
    krb5-1.14.1.tar.gz
    krb5-1.14.tar.gz.asc ->
    krb5-1.14.1.tar.gz.asc
  * Adjust line numbers in:
    krb5-fix_interposer.patch
* Wed Mar 23 2016 hguo@suse.com
- Introduce patch
  0107-Fix-LDAP-null-deref-on-empty-arg-CVE-2016-3119.patch
  to fix CVE-2016-3119 (bsc#971942)
* Thu Feb 11 2016 hguo@suse.com
- Remove krb5-mini pieces from spec file.
  Hence remove pre_checkin.sh
- Remove expired macros and other minor clean-ups in spec file.
* Tue Feb  2 2016 hguo@suse.com
- Fix CVE-2015-8629: krb5: xdr_nullstring() doesn't check for terminating null character
  with patch 0104-Verify-decoded-kadmin-C-strings-CVE-2015-8629.patch
  (bsc#963968)
- Fix CVE-2015-8631: krb5: Memory leak caused by supplying a null principal name in request
  with patch 0105-Fix-leaks-in-kadmin-server-stubs-CVE-2015-8631.patch
  (bsc#963975)
- Fix CVE-2015-8630: krb5: krb5 doesn't check for null policy when KADM5_POLICY is set in the mask
  with patch 0106-Check-for-null-kadm5-policy-name-CVE-2015-8630.patch
  (bsc#963964)
* Mon Jan 11 2016 idonmez@suse.com
- Add two patches from Fedora, fixing two crashes:
  * krb5-fix_interposer.patch
  * krb5-mechglue_inqure_attrs.patch
* Tue Dec  8 2015 michael@stroeder.com
- Update to 1.14
- dropped krb5-kvno-230379.patch
- added krbdev.mit.edu-8301.patch fixing wrong function call
  Major changes in 1.14 (2015-11-20)
  Administrator experience:
  * Add a new kdb5_util tabdump command to provide reporting-friendly
  tabular dump formats (tab-separated or CSV) for the KDC database.
  Unlike the normal dump format, each output table has a fixed number
  of fields.  Some tables include human-readable forms of data that
  are opaque in ordinary dump files.  This format is also suitable for
  importing into relational databases for complex queries.
  * Add support to kadmin and kadmin.local for specifying a single
  command line following any global options, where the command
  arguments are split by the shell--for example, "kadmin getprinc
  principalname".  Commands issued this way do not prompt for
  confirmation or display warning messages, and exit with non-zero
  status if the operation fails.
  * Accept the same principal flag names in kadmin as we do for the
  default_principal_flags kdc.conf variable, and vice versa.  Also
  accept flag specifiers in the form that kadmin prints, as well as
  hexadecimal numbers.
  * Remove the triple-DES and RC4 encryption types from the default
  value of supported_enctypes, which determines the default key and
  salt types for new password-derived keys.  By default, keys will
  only created only for AES128 and AES256.  This mitigates some types
  of password guessing attacks.
  * Add support for directory names in the KRB5_CONFIG and
  KRB5_KDC_PROFILE environment variables.
  * Add support for authentication indicators, which are ticket
  annotations to indicate the strength of the initial authentication.
  Add support for the "require_auth" string attribute, which can be
  set on server principal entries to require an indicator when
  authenticating to the server.
  * Add support for key version numbers larger than 255 in keytab files,
  and for version numbers up to 65535 in KDC databases.
  * Transmit only one ETYPE-INFO and/or ETYPE-INFO2 entry from the KDC
  during pre-authentication, corresponding to the client's most
  preferred encryption type.
  * Add support for server name identification (SNI) when proxying KDC
  requests over HTTPS.
  * Add support for the err_fmt profile parameter, which can be used to
  generate custom-formatted error messages.
  Code quality:
  * Fix memory aliasing issues in SPNEGO and IAKERB mechanisms that
  could cause server crashes. [CVE-2015-2695] [CVE-2015-2696]
  [CVE-2015-2698]
  * Fix build_principal memory bug that could cause a KDC
  crash. [CVE-2015-2697]
  Developer experience:
  * Change gss_acquire_cred_with_password() to acquire credentials into
  a private memory credential cache.  Applications can use
  gss_store_cred() to make the resulting credentials visible to other
  processes.
  * Change gss_acquire_cred() and SPNEGO not to acquire credentials for
  IAKERB or for non-standard variants of the krb5 mechanism OID unless
  explicitly requested.  (SPNEGO will still accept the Microsoft
  variant of the krb5 mechanism OID during negotiation.)
  * Change gss_accept_sec_context() not to accept tokens for IAKERB or
  for non-standard variants of the krb5 mechanism OID unless an
  acceptor credential is acquired for those mechanisms.
  * Change gss_acquire_cred() to immediately resolve credentials if the
  time_rec parameter is not NULL, so that a correct expiration time
  can be returned.  Normally credential resolution is delayed until
  the target name is known.
  * Add krb5_prepend_error_message() and krb5_wrap_error_message() APIs,
  which can be used by plugin modules or applications to add prefixes
  to existing detailed error messages.
  * Add krb5_c_prfplus() and krb5_c_derive_prfplus() APIs, which
  implement the RFC 6113 PRF+ operation and key derivation using PRF+.
  * Add support for pre-authentication mechanisms which use multiple
  round trips, using the the KDC_ERR_MORE_PREAUTH_DATA_REQUIRED error
  code.  Add get_cookie() and set_cookie() callbacks to the kdcpreauth
  interface; these callbacks can be used to save marshalled state
  information in an encrypted cookie for the next request.
  * Add a client_key() callback to the kdcpreauth interface to retrieve
  the chosen client key, corresponding to the ETYPE-INFO2 entry sent
  by the KDC.
  * Add an add_auth_indicator() callback to the kdcpreauth interface,
  allowing pre-authentication modules to assert authentication
  indicators.
  * Add support for the GSS_KRB5_CRED_NO_CI_FLAGS_X cred option to
  suppress sending the confidentiality and integrity flags in GSS
  initiator tokens unless they are requested by the caller.  These
  flags control the negotiated SASL security layer for the Microsoft
  GSS-SPNEGO SASL mechanism.
  * Make the FILE credential cache implementation less prone to
  corruption issues in multi-threaded programs, especially on
  platforms with support for open file description locks.
  Performance:
  * On slave KDCs, poll the master KDC immediately after processing a
  full resync, and do not require two full resyncs after the master
  KDC's log file is reset.
  User experience:
  * Make gss_accept_sec_context() accept tickets near their expiration
  but within clock skew tolerances, rather than rejecting them
  immediately after the server's view of the ticket expiration time.
* Mon Dec  7 2015 michael@stroeder.com
- Update to 1.13.3
- removed patches for security fixes now in upstream source:
  0100-Fix-build_principal-memory-bug-CVE-2015-2697.patch
  0101-Fix-IAKERB-context-aliasing-bugs-CVE-2015-2696.patch
  0102-Fix-SPNEGO-context-aliasing-bugs-CVE-2015-2695.patch
  0103-Fix-IAKERB-context-export-import-CVE-2015-2698.patch
  Major changes in 1.13.3 (2015-12-04)
  This is a bug fix release.  The krb5-1.13 release series is in
  maintenance, and for new deployments, installers should prefer the
  krb5-1.14 release series or later.
  * Fix memory aliasing issues in SPNEGO and IAKERB mechanisms that
  could cause server crashes. [CVE-2015-2695] [CVE-2015-2696]
  [CVE-2015-2698]
  * Fix build_principal memory bug that could cause a KDC
  crash. [CVE-2015-2697]
  * Allow an iprop slave to receive full resyncs from KDCs running
  krb5-1.10 or earlier.
* Tue Nov 10 2015 hguo@suse.com
- Apply patch 0103-Fix-IAKERB-context-export-import-CVE-2015-2698.patch
  to fix a memory corruption regression introduced by resolution of
  CVE-2015-2698. bsc#954204
* Wed Oct 28 2015 hguo@suse.com
- Make kadmin.local man page available without having to install krb5-client. bsc#948011
- Apply patch 0100-Fix-build_principal-memory-bug-CVE-2015-2697.patch
  to fix build_principal memory bug [CVE-2015-2697] bsc#952190
- Apply patch 0101-Fix-IAKERB-context-aliasing-bugs-CVE-2015-2696.patch
  to fix IAKERB context aliasing bugs [CVE-2015-2696] bsc#952189
- Apply patch 0102-Fix-SPNEGO-context-aliasing-bugs-CVE-2015-2695.patch
  to fix SPNEGO context aliasing bugs [CVE-2015-2695] bsc#952188
* Mon Jun  1 2015 hguo@suse.com
- Let server depend on libev (module of libverto). This was the
  preferred implementation before the seperation of libverto from krb.
* Thu May 28 2015 dimstar@opensuse.org
- Drop libverto and libverto-libev Requires from the -server
  package: those package names don't exist and the shared libs
  are pulled in automatically.
* Wed May 27 2015 dimstar@opensuse.org
- Unconditionally buildrequire libverto-devel: krb5-mini also
  depends on it.
* Fri May 22 2015 meissner@suse.com
- pre_checkin.sh aligned changes between krb5/krb5-mini
- added krb5.keyring
* Tue May 12 2015 michael@stroeder.com
- update to krb5 1.13.2
- DES transition
  ==============
  The Data Encryption Standard (DES) is widely recognized as weak.  The
  krb5-1.7 release contains measures to encourage sites to migrate away
- From using single-DES cryptosystems.  Among these is a configuration
  variable that enables "weak" enctypes, which defaults to "false"
  beginning with krb5-1.8.
  Major changes in 1.13.2 (2015-05-08)
  This is a bug fix release.
  * Fix a minor vulnerability in krb5_read_message, which is primarily
  used in the BSD-derived kcmd suite of applications.  [CVE-2014-5355]
  * Fix a bypass of requires_preauth in KDCs that have PKINIT enabled.
  [CVE-2015-2694]
  * Fix some issues with the LDAP KDC database back end.
  * Fix an iteration-related memory leak in the DB2 KDC database back
  end.
  * Fix issues with some less-used kadm5.acl functionality.
  * Improve documentation.
* Thu Apr 23 2015 hguo@suse.com
- Use externally built libverto
* Wed Feb 18 2015 michael@stroeder.com
- update to krb5 1.13.1
  Major changes in 1.13.1 (2015-02-11)
  This is a bug fix release.
  * Fix multiple vulnerabilities in the LDAP KDC back end.
  [CVE-2014-5354] [CVE-2014-5353]
  * Fix multiple kadmind vulnerabilities, some of which are based in the
  gssrpc library. [CVE-2014-5352 CVE-2014-5352 CVE-2014-9421
  CVE-2014-9422 CVE-2014-9423]
* Tue Jan  6 2015 mlin@suse.com
- Update to krb5 1.13
  * Add support for accessing KDCs via an HTTPS proxy server using the
    MS-KKDCP protocol.
  * Add support for hierarchical incremental propagation, where slaves
    can act as intermediates between an upstream master and other downstream
    slaves.
  * Add support for configuring GSS mechanisms using /etc/gss/mech.d/*.conf
    files in addition to /etc/gss/mech.
  * Add support to the LDAP KDB module for binding to the LDAP server using
    SASL.
  * The KDC listens for TCP connections by default.
  * Fix a minor key disclosure vulnerability where using the "keepold" option
    to the kadmin randkey operation could return the old keys. [CVE-2014-5351]
  * Add client support for the Kerberos Cache Manager protocol. If the host
    is running a Heimdal kcm daemon, caches served by the daemon can be
    accessed with the KCM: cache type.
  * When built on OS X 10.7 and higher, use "KCM:" as the default cache type,
    unless overridden by command-line options or krb5-config values.
  * Add support for doing unlocked database dumps for the DB2 KDC back end,
    which would allow the KDC and kadmind to continue accessing the database
    during lengthy database dumps.
- Removed patches, useless or upstreamed
  * krb5-1.9-kprop-mktemp.patch
  * krb5-1.10-ksu-access.patch
  * krb5-1.12-doxygen.patch
  * bnc#897874-CVE-2014-5351.diff
  * krb5-1.13-work-around-replay-cache-creation-race.patch
  * krb5-1.10-kpasswd_tcp.patch
- Refreshed patches
  * krb5-1.12-pam.patch
  * krb5-1.12-selinux-label.patch
  * krb5-1.7-doublelog.patch
* Thu Sep 25 2014 ddiss@suse.com
- Work around replay cache creation race; (bnc#898439).
  krb5-1.13-work-around-replay-cache-creation-race.patch
* Tue Sep 23 2014 varkoly@suse.com
-  bnc#897874 CVE-2014-5351: krb5: current keys returned when randomizing the keys for a service principal
- added patches:
  * bnc#897874-CVE-2014-5351.diff
* Sat Aug 30 2014 andreas.stieger@gmx.de
- krb5 5.12.2:
  * Work around a gcc optimizer bug that could cause DB2 KDC
    database operations to spin in an infinite loop
  * Fix a backward compatibility problem with the LDAP KDB schema
    that could prevent krb5-1.11 and later from decoding entries
    created by krb5-1.6.
  * Avoid an infinite loop under some circumstances when the GSS
    mechglue loads a dynamic mechanism.
  * Fix krb5kdc argument parsing so "-w" and "-r" options work
    togetherreliably.
- Vulnerability fixes previously fixed in package via patches:
  * Handle certain invalid RFC 1964 GSS tokens correctly to avoid
    invalid memory reference vulnerabilities.  [CVE-2014-4341
    CVE-2014-4342]
  * Fix memory management vulnerabilities in GSSAPI SPNEGO.
    [CVE-2014-4343 CVE-2014-4344]
  * Fix buffer overflow vulnerability in LDAP KDB back end.
    [CVE-2014-4345]
- updated patches:
  * krb5-1.7-doublelog.patch for context change
  * krb5-1.6.3-ktutil-manpage.dif, same
- removed patches, in upstream:
  * krb5-master-keyring-kdcsync.patch
  * krb5-1.12-CVE-2014-4341-CVE-2014-4342.patch
  * krb5-1.12-CVE-2014-4343-Fix-double-free-in-SPNEGO.patch
  * krb5-1.12-CVE-2014-4344-Fix-null-deref-in-SPNEGO-acceptor.patch
  * krb5-1.12-CVE-2014-4345-buffer-overrun-in-kadmind-with-LDAP-backend.patch
- Fix build with doxygen 1.8.8 - adding krb5-1.12-doxygen.patch
  from upstream
* Fri Aug  8 2014 ckornacker@suse.com
- buffer overrun in kadmind with LDAP backend
  CVE-2014-4345 (bnc#891082)
  krb5-1.12-CVE-2014-4345-buffer-overrun-in-kadmind-with-LDAP-backend.patch
* Mon Jul 28 2014 ckornacker@suse.com
- Fix double-free in SPNEGO [CVE-2014-4343] (bnc#888697)
  krb5-1.12-CVE-2014-4343-Fix-double-free-in-SPNEGO.patch
  Fix null deref in SPNEGO acceptor [CVE-2014-4344]
  krb5-1.12-CVE-2014-4344-Fix-null-deref-in-SPNEGO-acceptor.patch
* Sat Jul 19 2014 p.drouand@gmail.com
- Do not depend of insserv if systemd is used
* Thu Jul 10 2014 ckornacker@suse.com
- denial of service flaws when handling RFC 1964 tokens (bnc#886016)
  krb5-1.12-CVE-2014-4341-CVE-2014-4342.patch
- start krb5kdc after slapd (bnc#886102)
* Fri Jun  6 2014 ckornacker@suse.com
- obsolete krb5-plugin-preauth-pkinit-nss (bnc#881674)
  similar functionality is provided by krb5-plugin-preauth-pkinit
* Tue Feb 18 2014 ckornacker@suse.com
- don't deliver SysV init files to systemd distributions
* Tue Jan 21 2014 ckornacker@suse.com
- update to version 1.12.1
  * Make KDC log service principal names more consistently during
    some error conditions, instead of "<unknown server>"
  * Fix several bugs related to building AES-NI support on less
    common configurations
  * Fix several bugs related to keyring credential caches
- upstream obsoletes:
  krb5-1.12-copy_context.patch
  krb5-1.12-enable-NX.patch
  krb5-1.12-pic-aes-ni.patch
  krb5-master-no-malloc0.patch
  krb5-master-ignore-empty-unnecessary-final-token.patch
  krb5-master-gss_oid_leak.patch
  krb5-master-keytab_close.patch
  krb5-master-spnego_error_messages.patch
- Fix Get time offsets for all keyring ccaches
  krb5-master-keyring-kdcsync.patch (RT#7820)
* Mon Jan 13 2014 ckornacker@suse.com
- update to version 1.12
  * Add GSSAPI extensions for constructing MIC tokens using IOV lists
  * Add a FAST OTP preauthentication module for the KDC which uses
    RADIUS to validate OTP token values.
  * The AES-based encryption types will use AES-NI instructions
    when possible for improved performance.
- revert dependency on libcom_err-mini-devel since it's not yet
  available
- update and rebase patches
  * krb5-1.10-buildconf.patch -> krb5-1.12-buildconf.patch
  * krb5-1.11-pam.patch -> krb5-1.12-pam.patch
  * krb5-1.11-selinux-label.patch -> krb5-1.12-selinux-label.patch
  * krb5-1.8-api.patch -> krb5-1.12-api.patch
  * krb5-1.9-ksu-path.patch -> krb5-1.12-ksu-path.patch
  * krb5-1.9-debuginfo.patch
  * krb5-1.9-kprop-mktemp.patch
  * krb5-kvno-230379.patch
- added upstream patches
  - Fix krb5_copy_context
  * krb5-1.12-copy_context.patch
  - Mark AESNI files as not needing executable stacks
  * krb5-1.12-enable-NX.patch
  * krb5-1.12-pic-aes-ni.patch
  - Fix memory leak in SPNEGO initiator
  * krb5-master-gss_oid_leak.patch
  - Fix SPNEGO one-hop interop against old IIS
  * krb5-master-ignore-empty-unnecessary-final-token.patch
  - Fix GSS krb5 acceptor acquire_cred error handling
  * krb5-master-keytab_close.patch
  - Avoid malloc(0) in SPNEGO get_input_token
  * krb5-master-no-malloc0.patch
  - Test SPNEGO error message in t_s4u.py
  * krb5-master-spnego_error_messages.patch
* Tue Dec 10 2013 nfbrown@suse.com
- Reduce build dependencies for krb5-mini by removing
  doxygen and changing libcom_err-devel to
  libcom_err-mini-devel
- Small fix to pre_checkin.sh so krb5-mini.spec is correct.
* Fri Nov 15 2013 ckornacker@suse.com
- update to version 1.11.4
  - Fix a KDC null pointer dereference [CVE-2013-1417] that could
    affect realms with an uncommon configuration.
  - Fix a KDC null pointer dereference [CVE-2013-1418] that could
    affect KDCs that serve multiple realms.
  - Fix a number of bugs related to KDC master key rollover.
* Mon Jun 24 2013 mc@suse.com
- install and enable systemd service files also in -mini package
* Fri Jun 21 2013 crrodriguez@opensuse.org
- remove fstack-protector-all from CFLAGS, just use the
  lighter/fast version already present in %%optflags
- Use LFS_CFLAGS to build in 32 bit archs.
* Sun Jun  9 2013 mc@suse.com
- update to version 1.11.3
  - Fix a UDP ping-pong vulnerability in the kpasswd
    (password changing) service. [CVE-2002-2443]
  - Improve interoperability with some Windows native PKINIT clients.
- install translation files
- remove outdated configure options
* Tue May 28 2013 mc@suse.com
- cleanup systemd files (remove syslog.target)
* Fri May  3 2013 mc@suse.de
- let krb5-mini conflict with all main packages
* Thu May  2 2013 mc@suse.de
- add conflicts between krb5-mini and krb5-server
* Sun Apr 28 2013 mc@suse.de
- update to version 1.11.2
  * Incremental propagation could erroneously act as if a slave's
    database were current after the slave received a full dump
    that failed to load.
  * gss_import_sec_context incorrectly set internal state that
    identifies whether an imported context is from an interposer
    mechanism or from the underlying mechanism.
- upstream fix obsolete krb5-lookup_etypes-leak.patch
* Thu Apr  4 2013 mc@suse.de
- add conflicts between krb5-mini-devel and krb5-devel
* Tue Apr  2 2013 mc@suse.de
- add conflicts between krb5-mini and krb5 and krb5-client
* Wed Mar 27 2013 mc@suse.de
- enable selinux and set openssl as crypto implementation
* Fri Mar 22 2013 mc@suse.de
- fix path to executables in service files
  (bnc#810926)
* Fri Mar 15 2013 mc@suse.de
- update to version 1.11.1
  * Improve ASN.1 support code, making it table-driven for
    decoding as well as encoding
  * Refactor parts of KDC
  * Documentation consolidation
  * build docs in the main package
  * bugfixing
- changes of patches:
  * bug-806715-CVE-2013-1415-fix-PKINIT-null-pointer-deref.dif:
    upstream
  * bug-807556-CVE-2012-1016-fix-PKINIT-null-pointer-deref2.dif:
    upstream
  * krb5-1.10-gcc47.patch: upstream
  * krb5-1.10-selinux-label.patch replaced by
    krb5-1.11-selinux-label.patch
  * krb5-1.10-spin-loop.patch: upstream
  * krb5-1.3.5-perlfix.dif: the tool was removed from upstream
  * krb5-1.8-pam.patch replaced by
    krb5-1.11-pam.patch
* Wed Mar  6 2013 mc@suse.de
- fix PKINIT null pointer deref in pkinit_check_kdc_pkid()
  CVE-2012-1016 (bnc#807556)
  bug-807556-CVE-2012-1016-fix-PKINIT-null-pointer-deref2.dif
* Mon Mar  4 2013 mc@suse.de
- fix PKINIT null pointer deref
  CVE-2013-1415 (bnc#806715)
  bug-806715-CVE-2013-1415-fix-PKINIT-null-pointer-deref.dif
* Fri Jan 25 2013 mc@suse.de
- package missing file (bnc#794784)
* Tue Jan 22 2013 lchiquitto@suse.com
- krb5-1.10-spin-loop.patch: fix spin-loop bug in k5_sendto_kdc
  (bnc#793336)
* Tue Oct 16 2012 coolo@suse.com
- revert the -p usage in %%postun to fix SLE build
* Tue Oct 16 2012 coolo@suse.com
- buildrequire systemd by pkgconfig provide to get systemd-mini
* Sat Oct 13 2012 coolo@suse.com
- do not require systemd in krb5-mini
* Fri Oct  5 2012 mc@suse.de
- add systemd service files for kadmind, krb5kdc and kpropd
- add sysconfig templates for kadmind and krb5kdc
* Wed Jun 13 2012 coolo@suse.com
- fix %%files section for krb5-mini
* Thu Jun  7 2012 mc@suse.de
- fix gcc47 issues
* Wed Jun  6 2012 mc@suse.de
- update to version 1.10.2
  obsolte patches:
  * krb5-1.7-nodeplibs.patch
  * krb5-1.9.1-ai_addrconfig.patch
  * krb5-1.9.1-ai_addrconfig2.patch
  * krb5-1.9.1-sendto_poll.patch
  * krb5-1.9-canonicalize-fallback.patch
  * krb5-1.9-paren.patch
  * krb5-klist_s.patch
  * krb5-pkinit-cms2.patch
  * krb5-trunk-chpw-err.patch
  * krb5-trunk-gss_delete_sec.patch
  * krb5-trunk-kadmin-oldproto.patch
  * krb5-1.9-MITKRB5-SA-2011-006.dif
  * krb5-1.9-gss_display_status-iakerb.patch
  * krb5-1.9.1-sendto_poll2.patch
  * krb5-1.9.1-sendto_poll3.patch
  * krb5-1.9-MITKRB5-SA-2011-007.dif
- Fix an interop issue with Windows Server 2008 R2 Read-Only Domain
  Controllers.
- Update a workaround for a glibc bug that would cause DNS PTR queries
  to occur even when rdns = false.
- Fix a kadmind denial of service issue (null pointer dereference),
  which could only be triggered by an administrator with the "create"
  privilege.  [CVE-2012-1013]
- Fix access controls for KDB string attributes [CVE-2012-1012]
- Make the ASN.1 encoding of key version numbers interoperate with
  Windows Read-Only Domain Controllers
- Avoid generating spurious password expiry warnings in cases where
  the KDC sends an account expiry time without a password expiry time
- Make PKINIT work with FAST in the client library.
- Add the DIR credential cache type, which can hold a collection of
  credential caches.
- Enhance kinit, klist, and kdestroy to support credential cache
  collections if the cache type supports it.
- Add the kswitch command, which changes the selected default cache
  within a collection.
- Add heuristic support for choosing client credentials based on
  the service realm.
- Add support for $HOME/.k5identity, which allows credential
  choice based on configured rules.
* Sun Feb 26 2012 stefan.bruens@rwth-aachen.de
- add autoconf macro to devel subpackage
* Tue Jan 31 2012 meissner@suse.de
- fix license in krb5-mini
* Tue Dec 20 2011 coolo@suse.com
- add autoconf as buildrequire to avoid implicit dependency
* Tue Dec 20 2011 coolo@suse.com
- remove call to suse_update_config, very old work around
* Mon Nov 21 2011 mc@suse.de
- fix KDC null pointer dereference in TGS handling
  (MITKRB5-SA-2011-007, bnc#730393)
  CVE-2011-1530
* Mon Nov 21 2011 mc@suse.de
- fix KDC HA feature introduced with implementing KDC poll
  (RT#6951, bnc#731648)
* Fri Nov 18 2011 rhafer@suse.de
- fix minor error messages for the IAKERB GSSAPI mechanism
  (see: http://krbdev.mit.edu/rt/Ticket/Display.html?id=7020)
* Mon Oct 17 2011 mc@suse.de
- fix kdc remote denial of service
  (MITKRB5-SA-2011-006, bnc#719393)
  CVE-2011-1527, CVE-2011-1528, CVE-2011-1529
* Tue Aug 23 2011 mc@suse.de
- use --without-pam to build krb5-mini
* Sun Aug 21 2011 mc@novell.com
- add patches from Fedora and upstream
- fix init scripts (bnc#689006)
* Fri Aug 19 2011 mc@novell.com
- update to version 1.9.1
  * obsolete patches:
    MITKRB5-SA-2010-007-1.8.dif
    krb5-1.8-MITKRB5-SA-2010-006.dif
    krb5-1.8-MITKRB5-SA-2011-001.dif
    krb5-1.8-MITKRB5-SA-2011-002.dif
    krb5-1.8-MITKRB5-SA-2011-003.dif
    krb5-1.8-MITKRB5-SA-2011-004.dif
    krb5-1.4.3-enospc.dif
  * replace krb5-1.6.1-compile_pie.dif
* Thu Apr 14 2011 mc@suse.de
- fix kadmind invalid pointer free()
  (MITKRB5-SA-2011-004, bnc#687469)
  CVE-2011-0285
* Tue Mar  1 2011 mc@suse.de
- Fix vulnerability to a double-free condition in KDC daemon
  (MITKRB5-SA-2011-003, bnc#671717)
  CVE-2011-0284
* Wed Jan 19 2011 mc@suse.de
- Fix kpropd denial of service
  (MITKRB5-SA-2011-001, bnc#662665)
  CVE-2010-4022
- Fix KDC denial of service attacks with LDAP back end
  (MITKRB5-SA-2011-002, bnc#663619)
  CVE-2011-0281, CVE-2011-0282
* Wed Dec  1 2010 mc@suse.de
- Fix multiple checksum handling vulnerabilities
  (MITKRB5-SA-2010-007, bnc#650650)
  CVE-2010-1324
  * krb5 GSS-API applications may accept unkeyed checksums
  * krb5 application services may accept unkeyed PAC checksums
  * krb5 KDC may accept low-entropy KrbFastArmoredReq checksums
  CVE-2010-1323
  * krb5 clients may accept unkeyed SAM-2 challenge checksums
  * krb5 may accept KRB-SAFE checksums with low-entropy derived keys
  CVE-2010-4020
  * krb5 may accept authdata checksums with low-entropy derived keys
  CVE-2010-4021
  * krb5 KDC may issue unrequested tickets due to KrbFastReq forgery
* Thu Oct 28 2010 mc@suse.de
- fix csh profile (bnc#649856)
* Fri Oct 22 2010 mc@suse.de
- update to krb5-1.8.3
  * remove patches which are now upstrem
  - krb5-1.7-MITKRB5-SA-2010-004.dif
  - krb5-1.8.1-gssapi-error-table.dif
  - krb5-MITKRB5-SA-2010-005.dif
* Fri Oct 22 2010 mc@suse.de
- change environment variable PATH directly for csh
  (bnc#642080)
* Mon Sep 27 2010 mc@suse.de
- fix a dereference of an uninitialized pointer while processing
  authorization data.
  CVE-2010-1322, MITKRB5-SA-2010-006 (bnc#640990)
* Mon Jun 21 2010 lchiquitto@novell.com
- add correct error table when initializing gss-krb5 (bnc#606584,
  bnc#608295)
* Wed May 19 2010 mc@suse.de
- fix GSS-API library null pointer dereference
  CVE-2010-1321, MITKRB5-SA-2010-005 (bnc#596826)
* Wed Apr 14 2010 mc@suse.de
- fix a double free vulnerability in the KDC
  CVE-2010-1320, MITKRB5-SA-2010-004 (bnc#596002)
* Fri Apr  9 2010 mc@suse.de
- update to version 1.8.1
  * include krb5-1.8-POST.dif
  * include MITKRB5-SA-2010-002
* Tue Apr  6 2010 mc@suse.de
- update krb5-1.8-POST.dif
* Tue Mar 23 2010 mc@suse.de
- fix a bug where an unauthenticated remote attacker could cause
  a GSS-API application including the Kerberos administration
  daemon (kadmind) to crash.
  CVE-2010-0628, MITKRB5-SA-2010-002 (bnc#582557)
* Tue Mar 23 2010 mc@suse.de
- add post 1.8 fixes
  * Add IPv6 support to changepw.c
  * fix two problems in kadm5_get_principal mask handling
  * Ignore improperly encoded signedpath AD elements
  * handle NT_SRV_INST in service principal referrals
  * dereference options while checking
    KRB5_GET_INIT_CREDS_OPT_CHG_PWD_PRMPT
  * Fix the kpasswd fallback from the ccache principal name
  * Document the ticket_lifetime libdefaults setting
  * Change KRB5_AUTHDATA_SIGNTICKET from 142 to 512
* Thu Mar  4 2010 mc@suse.de
- update to version 1.8
  * Increase code quality
  * Move toward improved KDB interface
  * Investigate and remedy repeatedly-reported performance
    bottlenecks.
  * Reduce DNS dependence by implementing an interface that allows
    client library to track whether a KDC supports service
    principal referrals.
  * Disable DES by default
  * Account lockout for repeated login failures
  * Bridge layer to allow Heimdal HDB modules to act as KDB
    backend modules
  * FAST enhancements
  * Microsoft Services for User (S4U) compatibility
  * Anonymous PKINIT
- fix KDC denial of service
  CVE-2010-0283, MITKRB5-SA-2010-001 (bnc#571781)
- fix KDC denial of service in cross-realm referral processing
  CVE-2009-3295, MITKRB5-SA-2009-003 (bnc#561347)
- fix integer underflow in AES and RC4 decryption
  CVE-2009-4212, MITKRB5-SA-2009-004 (bnc#561351)
- moved krb5 applications (telnet, ftp, rlogin, ...) to krb5-appl
* Mon Dec 14 2009 jengelh@medozas.de
- add baselibs.conf as a source
* Fri Nov 13 2009 mc@suse.de
- enhance '$PATH' only if the directories are available
  and not empty (bnc#544949)
* Sun Jul 12 2009 coolo@novell.com
- readd lost baselibs.conf
* Wed Jun  3 2009 mc@suse.de
- update to final 1.7 release
* Wed May 13 2009 mc@suse.de
- update to version 1.7 Beta2
  * Incremental propagation support for the KDC database.
  * Flexible Authentication Secure Tunneling (FAST), a preauthentiation
    framework that can protect the AS exchange from dictionary attack.
  * Implement client and KDC support for GSS_C_DELEG_POLICY_FLAG, which
    allows a GSS application to request credential delegation only if
    permitted by KDC policy.
  * Fix CVE-2009-0844, CVE-2009-0845, CVE-2009-0846, CVE-2009-0847 --
    various vulnerabilities in SPNEGO and ASN.1 code.
* Mon Feb 16 2009 mc@suse.de
- update to pre 1.7 version
  * Remove support for version 4 of the Kerberos protocol (krb4).
  * New libdefaults configuration variable "allow_weak_crypto".
  * Client library now follows client principal referrals, for
    compatibility with Windows.
  * KDC can issue realm referrals for service principals based on domain
    names.
  * Encryption algorithm negotiation (RFC 4537).
  * In the replay cache, use a hash over the complete ciphertext to
    avoid false-positive replay indications.
  * Microsoft GSS_WrapEX, implemented using the gss_iov API, which is
    similar to the equivalent SSPI functionality.
  * DCE RPC, including three-leg GSS context setup and unencapsulated
    GSS tokens.
  * NTLM recognition support in GSS-API, to facilitate dropping in an
    NTLM implementation.
  * KDC support for principal aliases, if the back end supports them.
  * Microsoft set/change password (RFC 3244) protocol in kadmind.
  * Master key rollover support.
* Wed Jan 14 2009 olh@suse.de
- obsolete also old heimdal-lib-XXbit and heimdal-devel-XXbit
* Thu Dec 11 2008 mc@suse.de
- do not query IPv6 addresses if no IPv6 address exists on this host
  [bnc#449143]
* Wed Dec 10 2008 olh@suse.de
- use Obsoletes: -XXbit only for ppc64 to help solver during distupgrade
  (bnc#437293)
* Thu Oct 30 2008 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Fri Sep 26 2008 mc@suse.de
- in case we use ldap as database backend, ldap should be
  started before krb5kdc
* Mon Jul 28 2008 mc@suse.de
- add new fixes to post 1.6.3 patch
  * fix mem leak in krb5_gss_accept_sec_context()
  * keep minor_status
  * kadm5_decrypt_key: A ktype of -1 is documented as meaning
    "to be ignored"
  * Reject socket fds > FD_SETSIZE
* Fri Jul 25 2008 mc@suse.de
- add patches from SVN post 1.6.3
  * krb5_string_to_keysalts: Fix an infinite loop
  * fix some mutex issues
  * better recovery from corrupt rcache files
  * some more small fixes
* Wed Jun 18 2008 mc@suse.de
- add case-insensitive.dif (FATE#300771)
- minor fixes for ktutil man page
- reduce rpmlint warnings
* Wed May 14 2008 mc@suse.de
- Fall back to TCP on kdc-unresolvable/unreachable errors.
- restore valid sequence number before generating requests
  (fix changing passwords in mixed ipv4/ipv6 enviroments)
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Wed Apr  9 2008 mc@suse.de
- modify krb5-config to not output rpath and cflags in --libs
  (bnc#378270)
* Fri Mar 14 2008 mc@suse.de
- fix two security bugs:
  * MITKRB5-SA-2008-001(CVE-2008-0062, CVE-2008-0063)
    fix double free [bnc#361373]
  * MITKRB5-SA-2008-002(CVE-2008-0947, CVE-2008-0948)
    Memory corruption while too many open file descriptors
    [bnc#363151]
- change default config file. Comment out the examples.
* Fri Dec 14 2007 mc@suse.de
- fix several security bugs:
  * CVE-2007-5894 apparent uninit length
  * CVE-2007-5902 integer overflow
  * CVE-2007-5971 free of non-heap pointer and double-free
  * CVE-2007-5972 double fclose()
  [#346745, #346748, #346746, #346749, #346747]
* Tue Dec  4 2007 mc@suse.de
- improve GSSAPI error messages
* Tue Nov  6 2007 mc@suse.de
- add coreutils to PreReq
* Tue Oct 23 2007 mc@suse.de
- update to krb5 version 1.6.3
  * fix CVE-2007-3999, CVE-2007-4743 svc_auth_gss.c buffer overflow
  * fix CVE-2007-4000 modify_policy vulnerability
  * Add PKINIT support
- remove patches which are upstream now
- enhance init scripts and xinetd profiles
* Fri Sep 14 2007 mc@suse.de
- update krb5-1.6.2-post.dif
  * If a KDC returns KDC_ERR_SVC_UNAVAILABLE, it appears that
    that the client library will not failover to the next KDC.
    [#310540]
* Tue Sep 11 2007 mc@suse.de
- update krb5-1.6.2-post.dif
  * new -S sname option for kvno
  * read_entropy_from_device on partial read will not fill buffer
  * Bail out if encoded "ticket" doesn't decode correctly.
  * patch for referrals loop
* Thu Sep  6 2007 mc@suse.de
- fix a problem with the originally published patch
  for MITKRB5-SA-2007-006 - CVE-2007-3999
  [#302377]
* Wed Sep  5 2007 mc@suse.de
- fix execute arbitrary code
  (MITKRB5-SA-2007-006 - CVE-2007-3999,2007-4000)
  [#302377]
* Tue Aug  7 2007 mc@suse.de
- add krb5-1.6.2-post.dif
  * during the referrals loop, check to see if the
    session key enctype of a returned credential for the final
    service is among the enctypes explicitly selected by the
    application, and retry with old_use_conf_ktypes if it is not.
  * If mkstemp() is available, the new ccache file gets created but
    the subsequent open(O_CREAT|O_EXCL) call fails because the file
    was already created by mkstemp(). Apply patch from Apple to keep
    the file descriptor open.
* Thu Jul 12 2007 mc@suse.de
- update to version 1.6.2
- remove krb5-1.6.1-post.dif all fixes are included in this release
* Thu Jul  5 2007 mc@suse.de
- change requires to libcom_err-devel
* Mon Jul  2 2007 mc@suse.de
- update krb5-1.6.1-post.dif
  * fix leak in krb5_walk_realm_tree
  * rd_req_decoded needs to deal with referral realms
  * fix buffer overflow in kadmind
    (MITKRB5-SA-2007-005 - CVE-2007-2798)
    [#278689]
  * fix kadmind code execution bug
    (MITKRB5-SA-2007-004 - CVE-2007-2442 - CVE-2007-2443)
    [#271191]
* Thu Jun 14 2007 mc@suse.de
- fix unstripped-binary-or-object rpmlint warning
* Mon Jun 11 2007 sschober@suse.de
- fixing rpmlint warnings and errors:
  * merged logrotate scripts kadmin and krb5kdc into a single file
    krb5-server.
  * moved heimdal2mit-DumpConvert.pl and simple_convert_krb5conf.pl
    from /usr/share/doc/packages/krb5 to /usr/lib/mit/helper.
    adapted krb5.spec and README.ConvertHeimdalMIT accordingly.
  * added surpression filter for
    "devel-file-in-non-devel-package /usr/lib/libgssapi_krb5.so"
    (see [#147912]).
  * set default runlevel of init scripts in chkconfig line to 3 and
    5
* Wed May  9 2007 mc@suse.de
- fix uninitialized salt length
- add extra check for keytab file
* Thu May  3 2007 mc@suse.de
- adding krb5-1.6.1-post.dif
  * fix segfault in krb5_get_init_creds_password
  * remove debug output in ftp client
  * profile stores empty string values without double quotes
* Mon Apr 23 2007 mc@suse.de
- update to final 1.6.1 version
* Wed Apr 18 2007 mc@suse.de
- add plugin directories to main package
* Mon Apr 16 2007 mc@suse.de
- update to version 1.6.1 Beta1
- remove obsolete patches
  (krb5-1.6-post.dif, krb5-1.6-patchlevel.dif)
- rework compile_pie patch
* Wed Apr 11 2007 mc@suse.de
- update krb5-1.6-post.dif
  * fix kadmind stack overflow in krb5_klog_syslog
    (MITKRB5-SA-2007-002 - CVE-2007-0957)
    [#253548]
  * fix double free attack in the RPC library
    (MITKRB5-SA-2007-003 - CVE-2007-1216)
    [#252487]
  * fix krb5 telnetd login injection
    (MIT-SA-2007-001 - CVE-2007-0956)
    [#247765]
* Thu Mar 29 2007 mc@suse.de
- add ncurses-devel and bison to BuildRequires
- rework some patches
* Mon Mar  5 2007 mc@suse.de
- move SuSEFirewall service definitions to
  /etc/sysconfig/SuSEfirewall2.d/services
* Thu Feb 22 2007 mc@suse.de
- add firewall definition to krb5-server, FATE #300687
* Mon Feb 19 2007 mc@suse.de
- update krb5-1.6-post.dif
- move some applications into the right package
* Fri Feb  9 2007 mc@suse.de
- update krb5-1.6-post.dif
* Mon Jan 29 2007 mc@suse.de
- krb5-1.6-fix-passwd-tcp.dif and krb5-1.6-fix-sendto_kdc-memset.dif
  are now upstream. Remove patches.
- fix leak in krb5_kt_resolve and krb5_kt_wresolve
* Tue Jan 23 2007 mc@suse.de
- fix "local variable used before set" in ftp.c
  [#237684]
* Mon Jan 22 2007 mc@suse.de
- krb5-devel should require keyutils-devel
* Mon Jan 22 2007 mc@suse.de
- update to version 1.6
  * Major changes in 1.6 include
  * Partial client implementation to handle server name referrals.
  * Pre-authentication plug-in framework, donated by Red Hat.
  * LDAP KDB plug-in, donated by Novell.
- remove obsolete patches
* Wed Jan 10 2007 mc@suse.de
- fix for
    kadmind (via RPC library) calls uninitialized function pointer
    (CVE-2006-6143)(Bug #225990)
    krb5-1.5-MITKRB5-SA-2006-002-fix-code-exec.dif
- fix for
    kadmind (via GSS-API mechglue) frees uninitialized pointers
    (CVE-2006-6144)(Bug #225992)
    krb5-1.5-MITKRB5-SA-2006-003-fix-free-of-uninitialized-pointer.dif
* Tue Jan  2 2007 mc@suse.de
- Fix Requires in krb5-devel
  [Bug #231008]
* Mon Nov  6 2006 mc@suse.de
- fix "local variable used before set" [#217692]
- fix strncat warning
* Fri Oct 27 2006 mc@suse.de
- add a default kadm5.dict file
- require $network on daemon start
* Wed Sep 13 2006 mc@suse.de
- fix function call with too few arguments [#203837]
* Thu Aug 24 2006 mc@suse.de
- update to version 1.5.1
- remove obsolete patches which are now included upstream
  * krb5-1.4.3-MITKRB5-SA-2006-001-setuid-return-checks.dif
  * trunk-fix-uninitialized-vars.dif
* Fri Aug 11 2006 mc@suse.de
- krb5 setuid return check fixes
  krb5-1.4.3-MITKRB5-SA-2006-001-setuid-return-checks.dif
  [#182351]
* Mon Aug  7 2006 mc@suse.de
- remove update-messages
* Mon Jul 24 2006 mc@suse.de
- add check for krb5_prop in services to kpropd init script.
  [#192446]
* Mon Jul  3 2006 mc@suse.de
- update to version 1.5
  * KDB abstraction layer, donated by Novell.
  * plug-in architecture, allowing for extension modules to be
    loaded at run-time.
  * multi-mechanism GSS-API implementation ("mechglue"),
    donated by Sun Microsystems
  * Simple and Protected GSS-API negotiation mechanism ("SPNEGO")
    implementation, donated by Sun Microsystems
- remove obsolete patches and add some new
* Fri May 26 2006 ro@suse.de
- libcom is not in e2fsck-devel but in its own package now, change
  Requires accordingly.
* Mon Mar 27 2006 mc@suse.de
- add all daemons to %%stop_on_removal and %%restart_on_update
- add reload to kpropd init script
- add force-reload to all init scripts
* Mon Mar 13 2006 mc@suse.de
- add libgssapi_krb5.so link to main package [#147912]
* Fri Feb  3 2006 mc@suse.de
- fix logging section for kadmind in convert script
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Fri Jan 13 2006 mc@suse.de
- change the logging defaults
* Wed Jan 11 2006 mc@suse.de
- add tools and README for heimdal => MIT update
* Mon Jan  9 2006 mc@suse.de
- fix build problems, define _GNU_SOURCE
  (krb5-1.4.3-set_gnu_source.dif )
* Tue Jan  3 2006 mc@suse.de
- added "make %%{?jobs:-j%%jobs}"
* Fri Nov 18 2005 mc@suse.de
- update to version 1.4.3
  * some memmory leaks fixed
  * fix for "AS_REP padata has wrong enctype"
  * fix for "AS_REP padata missing PA-ETYPE-INFO"
  * ... and more
* Wed Nov  2 2005 dmueller@suse.de
- don't build as root
* Tue Oct 11 2005 mc@suse.de
- update to version 1.4.2
- remove some obsolet patches
* Mon Aug  8 2005 mc@suse.de
- build with --disable-static
* Thu Aug  4 2005 ro@suse.de
- remove devel-static subpackage
* Thu Jun 30 2005 mc@suse.de
- better patch for princ_comp problem
* Mon Jun 27 2005 mc@suse.de
- update to version 1.4.1
- remove obsolet patches
  - krb5-1.4-gcc4.dif
  - krb5-1.4-reduce-namespace-polution.dif
  - krb5-1.4-VUL-0-telnet.dif
* Thu Jun 23 2005 mc@suse.de
- fixed krb5 KDC heap corruption by random free
  [#80574, CAN-2005-1174, MITKRB5-SA-2005-002]
- fixed krb5 double free()
  [#86768, CAN-2005-1689, MITKRB5-SA-2005-003]
- fix krb5 NULL pointer reference while comparing principals
  [#91600]
* Fri Jun 17 2005 mc@suse.de
- fix uninitialized variables
- compile with -fPIE/ link with -pie
* Wed Apr 20 2005 mc@suse.de
- fixed wrong xinetd files [#77149]
* Fri Apr  8 2005 mt@suse.de
- removed krb5-1.4-fix-error_tables.dif patch obsoleted
  by libcom_err locking patches
* Thu Apr  7 2005 mc@suse.de
- fixed missing descriptions in init files
  [#76164, #76165, #76166, #76169]
* Wed Mar 30 2005 mc@suse.de
- enhance $PATH via /etc/profile.d/ [#74018]
- remove the "links to important programs"
* Fri Mar 18 2005 mc@suse.de
- fixed not running converter script [#72854]
* Thu Mar 17 2005 mc@suse.de
- Fix CAN-2005-0469: Multiple Telnet Client slc_add_reply() Buffer
    Overflow
- Fix CAN-2005-0468: Multiple Telnet Client env_opt_add() Buffer
    Overflow
  [#73618]
* Wed Mar 16 2005 mc@suse.de
- fixed wrong PreReqs [#73020]
* Tue Mar 15 2005 mc@suse.de
- add a simple krb5.conf converter [#72854]
* Mon Mar 14 2005 mc@suse.de
- fixed: rckrb5kdc restart gives wrong status with non-running service
  [#72446]
* Thu Mar 10 2005 mc@suse.de
- add requires: e2fsprogs-devel to krb5-devel package [#71732]
* Fri Feb 25 2005 mc@suse.de
- fix double free [#66534]
  krb5-1.4-fix-error_tables.dif
* Fri Feb 11 2005 mc@suse.de
- change mode for shared libraries to 755
* Fri Feb  4 2005 mc@suse.de
- remove spx.c from tarball because of legal risk
- add README.Source which tell the user about this
  action.
- add a check for spx.c in the spec-file
- use rich-text for update-messages [#50250]
* Tue Feb  1 2005 mc@suse.de
- add krb5-1.4-reduce-namespace-polution.dif
  reduce namespace polution in gssapi.h [#50356]
* Fri Jan 28 2005 mc@suse.de
- update to version 1.4
- Add implementation of the RPCSEC_GSS authentication flavor to the
  RPC library.
- Thread safety for krb5 libraries.
- Merged Athena telnetd changes for creating a new option for
  requiring encryption.
- The kadmind4 backwards-compatibility admin server and the v5passwdd
  backwards-compatibility password-changing server have been removed.
- Yarrow code now uses AES.
- Merged Athena changes to allow ftpd to require encrypted passwords.
- Incorporate gss_krb5_set_allowable_enctypes() and
  gss_krb5_export_lucid_sec_context(), which are needed for NFSv4.
- remove obsolet patches
* Mon Jan 17 2005 mc@suse.de
- add proofreaded update-messages
* Fri Jan 14 2005 mc@suse.de
- remove Conflicts: and add Provides:
- add some insserv stuff
* Thu Jan 13 2005 mc@suse.de
- move vendor files to vendor-files.tar.bz2
- add obsoletes: heimdal
- add %%pre and %%post sections to detect update
  from heimdal and backup invalid configuration files
- add update-messages for heimdal update
* Mon Jan 10 2005 mc@suse.de
- update to version 1.3.6
- fix for: heap buffer overflow in libkadm5srv
  [CAN-2004-1189 / MITKRB5-SA-2004-004]
* Tue Dec 14 2004 mc@suse.de
- build doc subpackage in an own specfile
- removed unnecessary neededforbuild requirements
* Wed Nov 24 2004 coolo@suse.de
- fix build with gcc 4
* Mon Nov 15 2004 mc@suse.de
- added Conflicts with heimdal*
- rename some manpages to avoid conflicts
* Thu Nov  4 2004 mc@suse.de
- new init scripts
- fix logrotate scripts
- add some 64Bit fixes
- add default krb5.conf, kdc.conf and kadm5.acl
* Wed Nov  3 2004 mc@suse.de
- add e2fsprogs to NFB
- use system-et and system-ss
- fix includes of com_err.h
* Thu Oct 28 2004 mc@suse.de
- Initital checkin
