/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.healthchecks;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x Web handler on which you register health check procedure. It computes the outcome status (`UP` or `DOWN`)
 * . When the handler process a HTTP request, it computes the global outcome and build a HTTP response as follows:
 * <p>
 * <ul>
 * <li>204 - status is `UP` but no procedures installed (no payload)</li>
 * <li>200 - status is `UP`, the payload contains the result of the installed procedures</li>
 * <li>503 - status is `DOWN`, the payload contains the result of the installed procedures</li>
 * <li>500 - status is `DOWN`, the payload contains the result of the installed procedures, one of the
 * procedure has failed</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.healthchecks.HealthCheckHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.healthchecks.HealthCheckHandler.class)
public class HealthCheckHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HealthCheckHandler that = (HealthCheckHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HealthCheckHandler> __TYPE_ARG = new TypeArg<>(    obj -> new HealthCheckHandler((io.vertx.ext.healthchecks.HealthCheckHandler) obj),
    HealthCheckHandler::getDelegate
  );

  private final io.vertx.ext.healthchecks.HealthCheckHandler delegate;
  
  public HealthCheckHandler(io.vertx.ext.healthchecks.HealthCheckHandler delegate) {
    this.delegate = delegate;
  }

  public HealthCheckHandler(Object delegate) {
    this.delegate = (io.vertx.ext.healthchecks.HealthCheckHandler)delegate;
  }

  public io.vertx.ext.healthchecks.HealthCheckHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler}.
   * This function creates a new instance of {@link io.vertx.reactivex.ext.healthchecks.HealthChecks}.
   * @param vertx the Vert.x instance, must not be <code>null</code>
   * @param provider the Authentication provider used to authenticate the HTTP request
   * @return the created instance
   */
  public static io.vertx.reactivex.ext.healthchecks.HealthCheckHandler create(io.vertx.reactivex.core.Vertx vertx, io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider provider) { 
    io.vertx.reactivex.ext.healthchecks.HealthCheckHandler ret = io.vertx.reactivex.ext.healthchecks.HealthCheckHandler.newInstance((io.vertx.ext.healthchecks.HealthCheckHandler)io.vertx.ext.healthchecks.HealthCheckHandler.create(vertx.getDelegate(), provider.getDelegate()));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler}.
   * This function creates a new instance of {@link io.vertx.reactivex.ext.healthchecks.HealthChecks}.
   * @param vertx the Vert.x instance, must not be <code>null</code>
   * @return the created instance
   */
  public static io.vertx.reactivex.ext.healthchecks.HealthCheckHandler create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.healthchecks.HealthCheckHandler ret = io.vertx.reactivex.ext.healthchecks.HealthCheckHandler.newInstance((io.vertx.ext.healthchecks.HealthCheckHandler)io.vertx.ext.healthchecks.HealthCheckHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler}.
   * @param hc the health checks object to use, must not be <code>null</code>
   * @param provider 
   * @return the created instance
   */
  public static io.vertx.reactivex.ext.healthchecks.HealthCheckHandler createWithHealthChecks(io.vertx.reactivex.ext.healthchecks.HealthChecks hc, io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider provider) { 
    io.vertx.reactivex.ext.healthchecks.HealthCheckHandler ret = io.vertx.reactivex.ext.healthchecks.HealthCheckHandler.newInstance((io.vertx.ext.healthchecks.HealthCheckHandler)io.vertx.ext.healthchecks.HealthCheckHandler.createWithHealthChecks(hc.getDelegate(), provider.getDelegate()));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler}.
   * @param hc the health checks object to use
   * @return the created instance
   */
  public static io.vertx.reactivex.ext.healthchecks.HealthCheckHandler createWithHealthChecks(io.vertx.reactivex.ext.healthchecks.HealthChecks hc) { 
    io.vertx.reactivex.ext.healthchecks.HealthCheckHandler ret = io.vertx.reactivex.ext.healthchecks.HealthCheckHandler.newInstance((io.vertx.ext.healthchecks.HealthCheckHandler)io.vertx.ext.healthchecks.HealthCheckHandler.createWithHealthChecks(hc.getDelegate()));
    return ret;
  }

  /**
   * Registers a health check procedure.
   * <p>
   * The procedure is a  taking a  of {@link io.vertx.ext.healthchecks.Status} as parameter. Procedures are
   * asynchronous, and <strong>must</strong> complete or fail the given . If the future object is
   * failed, the procedure outcome is considered as `DOWN`. If the future is completed without any object, the
   * procedure outcome is considered as `UP`. If the future is completed with a (not-null) {@link io.vertx.ext.healthchecks.Status}, the
   * procedure outcome is the received status.
   * <p>
   * This method uses a 1s timeout. To configure the timeout use {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler#register}.
   * @param name the name of the procedure, must not be <code>null</code> or empty
   * @param procedure the procedure, must not be <code>null</code>
   * @return the current {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler}
   */
  public io.vertx.reactivex.ext.healthchecks.HealthCheckHandler register(java.lang.String name, io.vertx.core.Handler<io.vertx.reactivex.core.Promise<io.vertx.ext.healthchecks.Status>> procedure) { 
    delegate.register(name, new Handler<io.vertx.core.Promise<io.vertx.ext.healthchecks.Status>>() {
      public void handle(io.vertx.core.Promise<io.vertx.ext.healthchecks.Status> event) {
        procedure.handle(io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Registers a health check procedure.
   * <p>
   * The procedure is a  taking a  of {@link io.vertx.ext.healthchecks.Status} as parameter. Procedures are
   * asynchronous, and <strong>must</strong> complete or fail the given . If the future object is
   * failed, the procedure outcome is considered as `DOWN`. If the future is completed without any object, the
   * procedure outcome is considered as `UP`. If the future is completed with a (not-null) {@link io.vertx.ext.healthchecks.Status}, the
   * procedure outcome is the received status.
   * @param name the name of the procedure, must not be <code>null</code> or empty
   * @param timeout the procedure timeout
   * @param procedure the procedure, must not be <code>null</code>
   * @return the current {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler}
   */
  public io.vertx.reactivex.ext.healthchecks.HealthCheckHandler register(java.lang.String name, long timeout, io.vertx.core.Handler<io.vertx.reactivex.core.Promise<io.vertx.ext.healthchecks.Status>> procedure) { 
    delegate.register(name, timeout, new Handler<io.vertx.core.Promise<io.vertx.ext.healthchecks.Status>>() {
      public void handle(io.vertx.core.Promise<io.vertx.ext.healthchecks.Status> event) {
        procedure.handle(io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Unregisters a procedure.
   * @param name the name of the procedure
   * @return the current {@link io.vertx.reactivex.ext.healthchecks.HealthCheckHandler}
   */
  public io.vertx.reactivex.ext.healthchecks.HealthCheckHandler unregister(java.lang.String name) { 
    delegate.unregister(name);
    return this;
  }

  public static HealthCheckHandler newInstance(io.vertx.ext.healthchecks.HealthCheckHandler arg) {
    return arg != null ? new HealthCheckHandler(arg) : null;
  }

}
