/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.templ.freemarker;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template engine that uses the FreeMarker library.
 * The {@link io.vertx.reactivex.ext.web.common.template.TemplateEngine#unwrap} shall return an object of class {@link freemarker.template.Configuration}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine.class)
public class FreeMarkerTemplateEngine extends io.vertx.reactivex.ext.web.common.template.TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FreeMarkerTemplateEngine that = (FreeMarkerTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FreeMarkerTemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new FreeMarkerTemplateEngine((io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine) obj),
    FreeMarkerTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine delegate;
  
  public FreeMarkerTemplateEngine(io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public FreeMarkerTemplateEngine(Object delegate) {
    super((io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine)delegate);
    this.delegate = (io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine)delegate;
  }

  public io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.freemarker.FreeMarkerTemplateEngine create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.templ.freemarker.FreeMarkerTemplateEngine ret = io.vertx.reactivex.ext.web.templ.freemarker.FreeMarkerTemplateEngine.newInstance((io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine)io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @param extension 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.freemarker.FreeMarkerTemplateEngine create(io.vertx.reactivex.core.Vertx vertx, java.lang.String extension) { 
    io.vertx.reactivex.ext.web.templ.freemarker.FreeMarkerTemplateEngine ret = io.vertx.reactivex.ext.web.templ.freemarker.FreeMarkerTemplateEngine.newInstance((io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine)io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine.create(vertx.getDelegate(), extension));
    return ret;
  }

  /**
   * Default template extension
   */
  public static final java.lang.String DEFAULT_TEMPLATE_EXTENSION = io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
  public static FreeMarkerTemplateEngine newInstance(io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine arg) {
    return arg != null ? new FreeMarkerTemplateEngine(arg) : null;
  }

}
