#
# spec file for package cifs-utils
#
# Copyright (c) 2022 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%if %{undefined _pamdir}
  %define _pamdir /%{_lib}/security
%endif

Name:           cifs-utils
Version:        6.15
Release:        150400.3.18.1
Summary:        Utilities for doing and managing mounts of the Linux CIFS filesystem
License:        GPL-3.0-or-later
Group:          System/Filesystems
URL:            http://www.samba.org/linux-cifs/cifs-utils/
# origin   git://git.samba.org/cifs-utils.git
# for-next https://github.com/piastry/cifs-utils.git
Source:         https://ftp.samba.org/pub/linux-cifs/%{name}/%{name}-%{version}.tar.bz2
Source5:        https://ftp.samba.org/pub/linux-cifs/%{name}/%{name}-%{version}.tar.bz2.asc
# http://ftp.samba.org/pub/linux-cifs/cifs-utils/cifs-utils-pubkey_70F3B981.asc
Source6:        cifs-utils.keyring
Source100:      README.cifstab.migration
Source1:        cifs.init

Patch1:          fix-sbin-install-error.patch
Patch2:          0001-setcifsacl-fix-memory-allocation-for-struct-cifs_ace.patch
Patch3:          0001-cifs.upcall-fix-UAF-in-get_cachename_from_process_en.patch
Patch4:          0001-cifs-utils-Skip-TGT-check-if-valid-service-ticket-is.patch
Patch5:          0001-CIFS.upcall-to-accomodate-new-namespace-mount-opt.patch
Patch6:          0001-cifs-utils-avoid-using-mktemp-when-updating-mtab.patch
Patch7:          0001-cifs-utils-add-documentation-for-upcall_target.patch
Patch8:          0001-cifs.upcall-fix-memory-leaks-in-check_service_ticket.patch
Patch9:          0001-cifs.upcall-correctly-treat-UPTARGET_UNSPECIFIED-as-.patch
Patch10:         0001-mount.cifs-retry-mount-on-EINPROGRESS.patch

# Both SSSD and cifs-utils provide an idmap plugin for cifs.ko
# /etc/cifs-utils/idmap-plugin should be a symlink to one of the 2 idmap plugins
# * cifs-utils one is the default (priority 20)
# * installing SSSD should NOT switch to SSSD plugin (priority 10)
%define cifs_idmap_plugin       %{_sysconfdir}/cifs-utils/idmap-plugin
%define cifs_idmap_lib          %{_libdir}/cifs-utils/idmapwb.so
%define cifs_idmap_name         cifs-idmap-plugin
%define cifs_idmap_priority     20
BuildRequires:  update-alternatives
Requires(post): update-alternatives
Requires(preun):update-alternatives

# cifs-utils 6.8 switched to python for man page generation
# we need to require either py2 or py3 package
# some products do not have a py2/py3 versions
%if 0%{?suse_version} >= 1500
BuildRequires:  python3-docutils
%else
BuildRequires:  python-docutils
%endif

%if 0%{?suse_version} >= 1221
%define systemd 1
%else
%define systemd 0
%endif

%if 0%{?suse_version} < 1221
PreReq:         insserv %{?fillup_prereq}
%endif
%define         initdir %{_sysconfdir}/init.d
Provides:       cifs-mount = %{version}
Obsoletes:      cifs-mount < %{version}
%if 0%{?suse_version} > 1140
BuildRequires:  autoconf
%endif
BuildRequires:  automake
BuildRequires:  keyutils-devel
BuildRequires:  krb5-devel
%if 0%{?suse_version} > 1120
BuildRequires:  libcap-ng-devel
%else
BuildRequires:  libcap-devel
%endif
BuildRequires:  libtalloc-devel
%if 0%{?suse_version} > 1110
BuildRequires:  fdupes
%endif
BuildRequires:  pam-devel
BuildRequires:  pkg-config
BuildRequires:  pkgconfig(wbclient)
Requires:       keyutils
%if ! %{defined _rundir}
%define _rundir %{_localstatedir}/run
%endif

%description
The cifs-utils package consist of utilities for doing and managing mounts of
the Linux CIFS filesystem.

%package devel
Summary:        Files needed for building plugins for cifs-utils
Group:          Development/Libraries/C and C++

%description devel
The SMB/CIFS protocol is a standard file sharing protocol widely deployed
on Microsoft Windows machines. This package contains the header file
necessary for building ID mapping plugins for cifs-utils.

%package -n pam_cifscreds
Summary:        PAM module to manage NTLM credentials in kernel keyring
Group:          System/Libraries

%description -n pam_cifscreds
The pam_cifscreds PAM module is a tool for automatically adding
credentials (username and password) for the purpose of establishing
sessions in multiuser mounts.

When a cifs filesystem is mounted with the "multiuser" option, and does
not use krb5 authentication, it needs to be able to get the credentials
for each user from somewhere. The pam_cifscreds module can be used to
provide these credentials to the kernel automatically at login.

%prep
%setup -q
cp -a ${RPM_SOURCE_DIR}/README.cifstab.migration .
pyscripts="smb2-quota smbinfo"
for i in $pyscripts; do
    if [ -e $i ]; then
        sed -i 's,^#!/usr/bin/env python.*$,#!/usr/bin/python3,' $i
    fi
done

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1

%build
export CFLAGS="%{optflags} -D_GNU_SOURCE -fpie"
export LDFLAGS="-pie"
autoreconf -i
%if 0%{?usrmerged}
export ROOTSBINDIR="%{_sbindir}"
%endif
%configure \
	--with-pamdir=%{_pamdir}
make %{?_smp_mflags}

%install
%if ! %{systemd}
mkdir -p %{buildroot}/%{_sysconfdir}/init.d
%endif

%make_install
mkdir -p %{buildroot}%{_sysconfdir}/request-key.d
install -m 644 -p contrib/request-key.d/cifs.idmap.conf %{buildroot}%{_sysconfdir}/request-key.d
install -m 644 -p contrib/request-key.d/cifs.spnego.conf %{buildroot}%{_sysconfdir}/request-key.d
%if 0%{?suse_version} > 1221
mkdir -p \
	%{buildroot}/%{_sysconfdir}/sysconfig/network/if-{down,up}.d \
	%{buildroot}/%{_sysconfdir}/samba \
	%{buildroot}/%{_sbindir} \
	%{buildroot}/%{_rundir}

%if ! %{systemd}
install -m 0755 -p ${RPM_SOURCE_DIR}/cifs.init %{buildroot}/%{_sysconfdir}/init.d/cifs
ln -s service %{buildroot}/%{_sbindir}/rccifs
%endif

# dummy target for cifs-idmap-plugin
mkdir -p %{buildroot}%{_sysconfdir}/alternatives %{buildroot}%{_sysconfdir}/cifs-utils
ln -s -f %{_sysconfdir}/alternatives/%{cifs_idmap_name} %{buildroot}%{cifs_idmap_plugin}

touch %{buildroot}/%{_sysconfdir}/sysconfig/network/if-{down,up}.d/${script} \
	%{buildroot}%{_rundir}/cifs
%endif
# Hardlink duplicate files
%if 0%{?suse_version} > 1110
%fdupes %{buildroot}
%endif

%post
# install cifs-utils cifs-idmap plugin using alternatives system
update-alternatives --install %{cifs_idmap_plugin} %{cifs_idmap_name} %{cifs_idmap_lib} %{cifs_idmap_priority}

%postun
if [ ! -f %{cifs_idmap_lib} ] ; then
   update-alternatives --remove %{cifs_idmap_name} %{cifs_idmap_lib}
fi

%files
%if 0%{?usrmerged}
%{_sbindir}/mount.cifs
%{_sbindir}/mount.smb3
%else
/sbin/mount.cifs
/sbin/mount.smb3
%endif
%{_bindir}/getcifsacl
%{_bindir}/setcifsacl
%{_sbindir}/cifs.idmap
%{_mandir}/man1/getcifsacl.1%{ext_man}
%{_mandir}/man1/setcifsacl.1%{ext_man}
%{_mandir}/man8/cifs.idmap.8%{ext_man}
%{_bindir}/cifscreds
%{_sbindir}/cifs.upcall
%{_bindir}/smbinfo
%{_bindir}/smb2-quota
%{_mandir}/man1/cifscreds.1%{ext_man}
%{_mandir}/man1/smbinfo.1%{ext_man}
%{_mandir}/man1/smb2-quota.1%{ext_man}
%{_mandir}/man8/cifs.upcall.8%{ext_man}
%{_mandir}/man8/mount.cifs.8%{ext_man}
%{_mandir}/man8/mount.smb3.8%{ext_man}

# request keys
%dir %{_sysconfdir}/request-key.d
%config(noreplace) %{_sysconfdir}/request-key.d/cifs.idmap.conf
%config(noreplace) %{_sysconfdir}/request-key.d/cifs.spnego.conf

# idmap plugin
%dir %_sysconfdir/cifs-utils
%{cifs_idmap_plugin}
%dir %_libdir/cifs-utils
%{cifs_idmap_lib}
%ghost %_sysconfdir/alternatives/%{cifs_idmap_name}
%{_mandir}/man8/idmapwb.8%{ext_man}

%if 0%{?suse_version} > 1221
%if ! %{systemd}
%attr(0754,root,root) %config %{_sysconfdir}/init.d/cifs
%{_sbindir}/rccifs
%endif
%dir %{_sysconfdir}/samba
%ghost %{_rundir}/cifs
%endif
%doc README.cifstab.migration

%files devel
%{_includedir}/cifsidmap.h

%files -n pam_cifscreds
/%{_pamdir}/pam_cifscreds.so
%{_mandir}/man8/pam_cifscreds.8%{ext_man}

%changelog
* Tue Oct 14 2025 henrique.carvalho@suse.com
- Add patches:
  * 0001-cifs-utils-Skip-TGT-check-if-valid-service-ticket-is.patch (bsc#1248816)
  * 0001-setcifsacl-fix-memory-allocation-for-struct-cifs_ace.patch
  * 0001-cifs.upcall-fix-UAF-in-get_cachename_from_process_en.patch
  * 0001-cifs-utils-avoid-using-mktemp-when-updating-mtab.patch
  * 0001-cifs-utils-add-documentation-for-upcall_target.patch
  * 0001-cifs.upcall-fix-memory-leaks-in-check_service_ticket.patch
* Mon Jun 16 2025 henrique.carvalho@suse.com
- Add patches:
  * 0001-cifs.upcall-correctly-treat-UPTARGET_UNSPECIFIED-as-.patch
  (bsc#1243488)
  * 0001-mount.cifs-retry-mount-on-EINPROGRESS.patch
* Mon Apr 14 2025 henrique.carvalho@suse.com
- CVE-2025-2312: cifs-utils: cifs.upcall makes an upcall to the wrong
  namespace in containerized environments while trying to get Kerberos
  credentials (bsc#1239680)
  * add New-mount-option-for-cifs.upcall-namespace-reso.patch
* Tue May 17 2022 rpm@fthiessen.de
- Update to version 6.15
  * CVE-2022-27239: mount.cifs: fix length check for ip option parsing
    Previous check was true whatever the length of the input string was,
    leading to a buffer overflow in the subsequent strcpy call (bsc#1197216).
  * mount.cifs: fix verbose messages on option parsing (bsc#1198976, CVE-2022-29869)
* Mon Jan 17 2022 ematsumiya@suse.de
- Update cifs-utils.spec:
  * Remove unused
    !BuildIgnore: samba-client
    BuildRequires: libwbclient-devel
* Mon Jan 17 2022 ematsumiya@suse.de
- Update to cifs-utils 6.14
  * smbinfo is enhanced with capability to display alternate data streams
  * setcifsacl is improved to optionally reorder ACEs in preferred order
  * cifs.upcall regression in kerberos mount is fixed
  * remove cifs-utils-6.13.tar.bz2
  * remove cifs-utils-6.13.tar.bz2.asc
  * add    cifs-utils-6.14.tar.bz2
  * add    cifs-utils-6.14.tar.bz2.asc
- Drop upstream fixed patches:
  * 0001-cifs.upcall-fix-regression-in-kerberos-mount.patch
* Fri May 14 2021 rpm@fthiessen.de
- Update to cifs-utils 6.13
  * Fixes CVE-2021-20208, cifs.upcall kerberos auth leak in container
  * remove cifs-utils-6.12.tar.bz2
  * remove cifs-utils-6.12.tar.bz2.asc
  * add    cifs-utils-6.13.tar.bz2
  * add    cifs-utils-6.13.tar.bz2.asc
- Drop upstream fixed patches:
  * 0001-cifs.upcall-try-to-use-container-ipc-uts-net-pid-mnt.patch
* Fri Apr 23 2021 aaptel@suse.com
- cifs.upcall: fix regression in kerberos mount; (bsc#1184815).
  * add 0001-cifs.upcall-fix-regression-in-kerberos-mount.patch
* Tue Mar  9 2021 palcantara@suse.de
- CVE-2021-20208: cifs-utils: cifs.upcall kerberos auth leak in
  container; (bsc#1183239); CVE-2021-20208.
  * add 0001-cifs.upcall-try-to-use-container-ipc-uts-net-pid-mnt.patch
* Tue Feb 23 2021 aaptel@suse.com
- Update to cifs-utils 6.12
  * remove cifs-utils-6.11.tar.bz2
  * remove cifs-utils-6.11.tar.bz2.asc
  * add    cifs-utils-6.12.tar.bz2
  * add    cifs-utils-6.12.tar.bz2.asc
- Remove backports already in 6.12
  * remove 0001-cifs-utils-Respect-DESTDIR-when-installing-smb3-stuf.patch
  * remove 0002-cifs-utils-fix-probabilistic-compiling-error.patch
- Refresh Makefile.am install fix
  * modify fix-sbin-install-error.patch
- Hardcode python3 interpreter in shebang of smbinfo instead of
  /usr/bin/env to let rpm runtime dependency detect it.
* Thu Jan 14 2021 lnussel@suse.de
- use new %%_pamdir macro to avoid hardcoding pam module path
* Fri Dec 11 2020 aaptel@suse.com
- Update to cifs-utils 6.11
  * remove cifs-utils-6.9.tar.bz2
  * remove cifs-utils-6.9.tar.bz2.asc
  * add    cifs-utils-6.11.tar.bz2
  * add    cifs-utils-6.11.tar.bz2.asc
- Remove backports already in 6.11
  * remove 0001-smbinfo-Improve-help-usage-and-add-h-option.patch
  * remove 0002-smbinfo-Add-bash-completion-support-for-smbinfo.patch
  * remove 0003-getcifsacl-Add-support-to-accept-more-paths.patch
  * remove 0004-getcifsacl-Fix-usage-message-to-include-multiple-fil.patch
  * remove 0005-smbinfo-add-GETCOMPRESSION-support.patch
  * remove 0006-getcifsacl-Add-support-for-R-recursive-option.patch
  * remove 0007-smbinfo-add-bash-completion-support-for-getcompressi.patch
  * remove 0008-mount.cifs.c-fix-memory-leaks-in-main-func.patch
  * remove 0009-Zero-fill-the-allocated-memory-for-new-struct-cifs_n.patch
  * remove 0010-Zero-fill-the-allocated-memory-for-a-new-ACE.patch
  * remove 0011-fix-doublefree.patch
  * remove 0012-mount.cifs-Fix-invalid-free.patch
  * remove 0013-CVE-2020-14342-mount.cifs-fix-shell-command-injectio.patch
- Add fixes for autoconf and make install issues
  * add    fix-sbin-install-error.patch
  * add    0001-cifs-utils-Respect-DESTDIR-when-installing-smb3-stuf.patch
  * add    0002-cifs-utils-fix-probabilistic-compiling-error.patch
- Hardcode python3 interpreter in shebang of smb2-quota instead of
  /usr/bin/env to let rpm runtime dependency detect it.
* Tue Nov 17 2020 lnussel@suse.de
- prepare usrmerge (boo#1029961)
* Tue Aug 11 2020 aaptel@suse.com
- Make cifs-idmap plugin (idmapwb.so) use update-alternatives
  mechanism to be able to switch between cifs-utils and sssd;
  (bsc#1182682).
* Mon Aug 10 2020 aaptel@suse.com
- CVE-2020-14342: Shell command injection vulnerability in mount.cifs;
  (bsc#1174477); (bso#14442); CVE-2020-14342.
  * add 0013-CVE-2020-14342-mount.cifs-fix-shell-command-injectio.patch
* Wed Apr  8 2020 aaptel@suse.com
- rst2man has been moved to python3-docutils in SLE12+, update
  BuildRequires check to reflect that
* Wed Oct  2 2019 palcantara@suse.de
- Fix invalid free in mount.cifs; (bsc#1152930).
  * add 0012-mount.cifs-Fix-invalid-free.patch
* Mon Sep  9 2019 aaptel@suse.com
- Fix double-free in mount.cifs; (bsc#1149164).
  * add 0011-fix-doublefree.patch
* Thu Aug 15 2019 aaptel@suse.com
- Update to cifs-utils 6.9; (bsc#1132087); (bsc#1136031).
  * adds fixes for Azure
  * new smbinfo utility
  * remove cifs-utils-6.8.tar.bz2
  * remove cifs-utils-6.8.tar.bz2.asc
  * add cifs-utils-6.9.tar.bz2
  * add cifs-utils-6.9.tar.bz2.asc
  * add 0001-smbinfo-Improve-help-usage-and-add-h-option.patch
  * add 0002-smbinfo-Add-bash-completion-support-for-smbinfo.patch
  * add 0003-getcifsacl-Add-support-to-accept-more-paths.patch
  * add 0004-getcifsacl-Fix-usage-message-to-include-multiple-fil.patch
  * add 0005-smbinfo-add-GETCOMPRESSION-support.patch
  * add 0006-getcifsacl-Add-support-for-R-recursive-option.patch
  * add 0007-smbinfo-add-bash-completion-support-for-getcompressi.patch
  * add 0008-mount.cifs.c-fix-memory-leaks-in-main-func.patch
  * add 0009-Zero-fill-the-allocated-memory-for-new-struct-cifs_n.patch
  * add 0010-Zero-fill-the-allocated-memory-for-a-new-ACE.patch
- Remove backports that are already in 6.9; (fate#325270); (bsc#1130528);
  * remove 0001-docs-cleanup-rst-formating.patch
  * remove 0002-mount.cifs.rst-document-new-no-handlecache-mount-opt.patch
  * remove 0003-manpage-update-mount.cifs-manpage-with-info-about-rd.patch
  * remove 0004-checkopts-add-python-script-to-cross-check-mount-opt.patch
  * remove 0005-mount.cifs.rst-document-missing-options-correct-wron.patch
  * remove 0006-cifs-utils-support-rst2man-3.patch
  * remove 0007-checkopts-report-duplicated-options-in-man-page.patch
  * remove 0008-mount.cifs.rst-more-cleanups.patch
  * remove 0009-mount.cifs.rst-document-vers-3-mount-option.patch
  * remove 0010-mount.cifs.rst-document-vers-3.02-mount-option.patch
  * remove allow-dns-resolver-key-to-expire.patch
  * remove suse-document-new-vers-default-SMB2.1.patch
- Remove dependency workaround regarding python2/python3
* Tue Mar 12 2019 palcantara@suse.de
- Fix dependency failure on SLE15 regarding python2/python3.
* Thu Feb 14 2019 aaptel@suse.com
- Allow cached DNS entry to expire; (fate#325270).
  * add allow-dns-resolver-key-to-expire.patch
* Tue Feb 12 2019 aaptel@suse.com
- Document new SMB2.1+ defaults; (bsc#1130528).
  * be more verbose on mount errors, especially with EHOSTDOWN which
    is often returned on SMB version issues.
  * add suse-document-new-vers-default-SMB2.1.patch
* Mon Feb 11 2019 dmulder@suse.com
- Fix python dependency stalemate by requiring python3 version of
  samba-libs.
* Mon Sep 10 2018 aaptel@suse.com
- Update to cifs-utils 6.8.
  + document more mount options
  + man pages now generated from RST files
  + add python-docutils build dependency
  + update keyring to check tarball signature
  + remove 0001-manpage-correct-typos-and-spelling-mistakes.patch
  + remove 0002-mount.cifs-document-SMBv3.1.1-and-new-seal-option.patch
- Add typo corrections, better doc and configure fixes from upstream
  + add 0001-docs-cleanup-rst-formating.patch
  + add 0002-mount.cifs.rst-document-new-no-handlecache-mount-opt.patch
  + add 0003-manpage-update-mount.cifs-manpage-with-info-about-rd.patch
  + add 0004-checkopts-add-python-script-to-cross-check-mount-opt.patch
  + add 0005-mount.cifs.rst-document-missing-options-correct-wron.patch
  + add 0006-cifs-utils-support-rst2man-3.patch
  + add 0007-checkopts-report-duplicated-options-in-man-page.patch
  + add 0008-mount.cifs.rst-more-cleanups.patch
  + add 0009-mount.cifs.rst-document-vers-3-mount-option.patch
  + add 0010-mount.cifs.rst-document-vers-3.02-mount-option.patch
- Cleanup spec file
  * assume SUSE vendor and SLE >= 11
* Tue Mar  6 2018 schwab@suse.de
- Update BuildIgnore to break build cycle samba-client <-> cifs-utils
* Sun Feb 18 2018 avindra@opensuse.org
- update to 6.7:
  * mount.cifs cleanups
- includes 6.6:
  * cleanup/overhaul of cifs.upcall krb5 credcache handling
- partial cleanup with spec-cleaner
* Thu Apr 27 2017 aaptel@suse.com
- Document SMB3+ and new seal option; (fate#322075).
  + add patch 0001-manpage-correct-typos-and-spelling-mistakes.patch
  + add patch 0002-mount.cifs-document-SMBv3.1.1-and-new-seal-option.patch
* Tue Mar  7 2017 aaptel@suse.com
- Get rid of init script on everything based off SLE12+ (bsc#1025471).
* Thu Feb  2 2017 aaptel@suse.com
- Use https urls.
* Mon Feb 22 2016 lmuelle@suse.com
- Don't ignore libldb, libtalloc, libtevent, and samba-client-libs at build
  time; (bsc#966174).
* Mon Feb 22 2016 lmuelle@suse.com
- Update to cifs-utils 6.5.
  + mount.cifs: ignore x- mount options
  + minor build fixes; obsoletes include_paths.h_for__PATH_MOUNTED.patch
  + minor manpage fix
* Thu Sep 10 2015 lmuelle@suse.com
- Ignore samba-client-libs at build-time on post-22 Fedora systems.
* Mon Jul  6 2015 lmuelle@suse.com
- Add include_paths.h_for__PATH_MOUNTED.patch
* Wed Dec  3 2014 bwiedemann@suse.com
- Use rccifs -> service symlink for proper status (bnc#908023).
* Tue Oct 28 2014 lmuelle@suse.com
- Remove dependency on gpg-offline as signature checking is implemented in the
  source validator.
* Tue Oct 28 2014 lmuelle@suse.com
- Add README.cifstab.migration to document the cifstab removal; (bnc#902947).
* Mon Oct 13 2014 lmuelle@suse.com
- Fix broken rccifs symbolic link.
* Mon Oct 13 2014 lmuelle@suse.com
- Remove dead code associated with cifstab file which is no longer used.
* Sun Aug 31 2014 ddiss@suse.com
- Remove mkinitrd files and spec file logic. Dracut offers cifs support via
  the corresponding module; (bnc#893575).
* Tue Aug 19 2014 lmuelle@suse.com
- Remove cifstab file; obsoleted by the more generic cifs credentials feature.
* Mon Jul 28 2014 lmuelle@suse.com
- Update to cifs-utils 6.4.
  + allow PAM directory to be configurable
  - Make_the_PAM_security_directory_configurable_at_compile_time.patch
  + better determination of default keytab file
  + better cifscreds error handling
  + uppercase devicename when retrying mount
* Wed Jun 18 2014 lmuelle@suse.com
- BuildIgnore libldb, libtevent, and samba4-libs to prevent a package conflict
  on CentOS, Fedora, and RHEL systems.
* Thu May  8 2014 ro@suse.de
- use _rundir macro
* Thu Mar 20 2014 lmuelle@suse.com
- Update to cifs-utils 6.3.
  + fixes for various bugs turned up by Coverity
  + clean unused cruft out of upcall binary
  + add new pam_cifscreds PAM module for establishing NTLM creds on login
    which BuildRequires the pam-devel package
- Make the PAM security directory configurable at compile time; (bso#10513).
  + Make_the_PAM_security_directory_configurable_at_compile_time.patch
* Wed Oct  9 2013 lmuelle@suse.com
- Verify source tar ball gpg signature.
* Tue Oct  8 2013 lmuelle@suse.com
- Update to cifs-utils 6.2.
  + setcifsacl can now work without a plugin
  + systemd-ask-password is found using $PATH now
  + cifs.upcall now works with KEYRING: credcaches
- Update to cifs-utils 6.1.
  + minor bugfixes
  + allow cifs.upcall to use dedicated keytab
- Update to cifs-utils 6.0.
  + minor bugfixes and documentation updates
  + support for NFS-style device names removed
* Thu Mar 21 2013 mmeister@suse.com
- Added url as source.
  Please see http://en.opensuse.org/SourceUrls
* Tue Feb 26 2013 lmuelle@suse.com
- Add cifstab named configuration file to post-12.2 systems; (bnc#804822);
  (bnc#821889).
- Really use of the existing cifs init script; (bnc#697218).
* Thu Feb 21 2013 lmuelle@suse.com
- Remove superfluous restart or stop of the cifs service; (bnc#804822).
* Wed Jan 23 2013 lmuelle@suse.com
- Set parsed_info->got_user when a cred file supplies a username;
  (bnc#800018).
* Wed Jan 16 2013 lmuelle@suse.com
- Update to cifs-utils 5.9.
  + new plugin architecture for the ID mapping tools
  + DOMAIN\username@password format for username= arguments is removed
  + full RELRO (vs. partial) is now enabled on all binaries
* Wed Nov 21 2012 crrodriguez@opensuse.org
- Version 5.8
  * NFS-style device names are being deprecated in 6.0.
  * Many bugs in cifs.idmap, getcifsacl and setcifsacl have been fixed.
* Wed Aug  8 2012 lmuelle@suse.com
- Update to cifs-utils 5.6.
  + -Werror has been removed by default from CFLAGS
  + PIE and RELRO are enabled by default at build time
  + better integration with systemd by allowing the use of
    /bin/systemd-ask-password if available
  + better checks and warnings from cifscreds when used in environments that
    do not have a session keyring
- No longer initialize oldfsgid inside acquire_mountpoint() of mount.cifs.c as
  - Werror got removed.
* Tue Jun 12 2012 lmuelle@suse.com
- mount.cifs: initialize oldfsgid to surpress a warning while building for
  RHEL 4 or CentOS 5.
* Tue Jun 12 2012 lmuelle@suse.com
- mount.cifs: set rc to 0 in libcap toggle_dac_capability
* Fri Jun  1 2012 lmuelle@suse.com
- BuildRequire libwbclient-devel for CentOS, Fedora, and RHEL builds too.
* Fri Jun  1 2012 lmuelle@suse.com
- Do not call autoreconf while build.
* Fri Jun  1 2012 lmuelle@suse.com
- BuildIgnore libtalloc to prevent a package conflict on Fedora systems.
* Thu May 31 2012 lmuelle@suse.com
- BuildRequire libtalloc-devel unconditionally.
* Wed May 30 2012 lmuelle@suse.com
- Update to cifs-utils 5.5.
  + mount.cifs: don't pass credentials= option to the kernel
  + doc: update mailing list
  + mount.cifs: don't send a mandatory ver= option to the kernel
  + mount.cifs: remove smb2 multicall binary code
  + doc: remove old XML sources for mount.cifs.8 and cifs.upcall.8
  + mount.cifs: unused variables
* Wed May 16 2012 lmuelle@suse.com
- BuildRequire libtalloc2-devel instead of libtalloc-devel for post 12.1
  systems.
* Thu Apr 19 2012 lmuelle@suse.com
- Don't package get-, setcifsacl, and cifs.idmap for Mandriva pre-201100.
* Thu Apr 19 2012 lmuelle@suse.com
- Don't care at all what the real uid is when we call toggle_dac_capability().
* Thu Apr 19 2012 lmuelle@suse.com
- Make use of the stored return code in toggle_dac_capability() of mount.cifs.
* Thu Apr 19 2012 lmuelle@suse.com
- Declare krb5_auth_con_set_req_cksumtype if the prototype does not exist.
- Initialize bkupuid and bkupgid.
* Thu Apr 19 2012 lmuelle@suse.com
- BuildRequire pkg-config for post-10.2 systems and else pkgconfig.
* Thu Apr 19 2012 lmuelle@suse.com
- mount.cifs: fix up some -D_FORTIFY_SOURCE=2 warnings
* Thu Apr 19 2012 lmuelle@suse.com
- Update to cifs-utils 5.4.
  + the "rootsbindir" can now be specified at configure time
  + mount.cifs now supports the -s option by passing "sloppy" to the
    kernel in the options string
  + cifs.upcall now properly respects the domain_realm section in krb5.conf
  + unprivileged users can no longer mount onto dirs into which they
    can't chdir (fixes CVE-2012-1586)
* Mon Feb  6 2012 dlovasko@suse.com
- Added position independent flags to compilation and linking (-fpie/-pie);
  (bnc#743133).
* Thu Feb  2 2012 lmuelle@suse.de
- BuildRequire autoconf to avoid implicit dependency for post-11.4 systems.
- BuildRequire keyutils-devel for post-10.2 systems.
- BuildRequire libcap-ng-devel for post-11.2 systems.
- BuildRequire libwbclient-devel for post-10.2 systems.
- BuildRequire samba-winbind-devel for CentOS, Fedora, and RHEL systems.
- Add getcifsacl, setcifsacl, cifs.idmap, and cifs.upcall binaries and man
  pages to the filelist.
* Wed Feb  1 2012 lmuelle@suse.de
- Update to cifs-utils 5.3.
  + admins can now tell cifs.upcall to use an alternate krb5.conf file
  + on remount, mount.cifs no longer adds a duplicate mtab entry
  + the cifscreds utility has seen a major overhaul to allow for multiuser
    mounts without krb5 auth
- Update to cifs-utils 5.2.
  + cifs.idmap can now map uid/gid to SID in addition to the other way around
  + getcifsacl/setcifsacl are now installed by default in /usr/bin instead of
    /usr/sbin. The manpages are now in section 1.
  + cifs.upcall has a new scheme for picking the SPN on krb5 mounts. The
    hostname is now always lowercased. If we fail to get a ticket using an
    unqualified name, it now attempts to guess the domain name.
  + A lot of manpage updates, additions and corrections
- Update to cifs-utils 5.1.
  + fix for a minor security issue that can corrupt the mtab
  + new getcifsacl/setcifsacl tools that allow you to fetch and set raw
    Windows ACLs via an xattr.
  + a lot of manpage patches
- Update to cifs-utils 5.0.
  + mount.cifs always uses the original device string to ensure that umounts
    by unprivileged users are not problematic
  + there is a new cifs.idmap program for handling idmapping upcalls
  + a lot of manpage patches
* Wed Dec 21 2011 coolo@suse.com
- remove call to suse_update_config (very old work around)
* Thu Dec  1 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Sat Sep 17 2011 jengelh@medozas.de
- Remove redundant tags/sections from specfile
* Wed Jun 22 2011 sjayaraman@suse.de
- modify cifs init script to use /var/run instead of /var/lock/subsys for
  state file; (bnc#697218).
* Tue Mar  8 2011 sjayaraman@suse.de
- Update to cifs-utils 4.9.
  + mount.cifs: don't try to alter mtab if it's a symlink.
  + mount.cifs: fix possible use of uninitialized variable.
  + mount.cifs: reacquire CAP_DAC_READ_SEARCH before calling mount(2).
  + mount.cifs: fix handling of scopeid in resolve_host.
- Update to cifs-utils 4.8.1.
  + fix mis-generated autoconf files.
- Update to cifs-utils 4.8.
  + mount.cifs: manpage: add entry for "actimeo" option.
  + cifs-utils: rewrite hardcoded paths in manpages.
  + cifs-utils: fixes for manpage pathname replacement scheme.
  + cifs.upcall: fix memory and call krb5_auth_con_free().
  + cifs.upcall: use krb5_auth_con_set_req_cksumtype() and pass a GSSAPI
    checksum; (bso#7890).
  + manpage: change port option description.
  + cifs.upcall: add 'l' to getopt_long string.
  + cifs.upcall: fix crash when trying to free uninitialized var.
  + cifs.upcall: consolidate find_krb5_cc calls.
  + cifs.upcall: clean up key description decoding routine.
  + cifs.upcall: add keytab support for unattended mounts.
  + mount.cifs: add cruid= mount option.
- Update to cifs-utils 4.7.
  + manpage: add mount.cifs manpage entry for "multiuser" option.
  + mount.cifs: reinstate ip= as an override for address resolution.
  + mount.cifs: use monotonic time for timeouts.
  + cifs-utils: infrastructure for stashing passwords in keyring.
  + cifs-utils: moving resolve_host into separate file.
* Fri Jan 14 2011 lmuelle@suse.de
- Move the cifs init script nfs dependencies from Required to Should.
* Tue Dec  7 2010 toganm@opensuse.org
- corrected #bnc 641513 by adding /sbin/mkinitrd_setup in %%postun.
* Mon Aug  2 2010 sjayaraman@suse.de
- Update to cifs-utils 4.6.
  + adds documentation for the fsc option.
  + mount.cifs deals with the _netdev, mand, and nomand options correctly now.
  + changes how mount.cifs handles the MS_MANDLOCK flag.
  + makes cifs.upcall prefer the creduid= upcall option to uid=
* Wed Jul  7 2010 sjayaraman@suse.de
- mount.cifs: fix parsing of "cred=" option; (bnc#618877); (bnc#620856);
  (bnc#621525); (bnc#623763); (bnc#627243).
* Mon May 24 2010 sjayaraman@suse.de
- Update to cifs-utils 4.5.
  + strip leading delimiter off of prefixpath option in mount.cifs.
  + remove magic number for max_username in parse_options.
  + turn into a multicall binary for smb2.
  + fix uninitialized variable in cred parsing error path.
  + cleanup mount.cifs option parsing.
* Wed May  5 2010 lmuelle@suse.de
- BuildRequire libkeyutils-devel on Mandriva systems.
* Tue May  4 2010 sjayaraman@suse.de
- Update to cifs-utils 4.4.
  + fix a segfault that could occur when parsing the address list.
  + fix autoconf/automake problem that could cause compilation to fail.
  + acquire required capabilities before a couple of operations.
  + ensure passwords are not left in memory.
  + cleanup of credential file parsing.
* Tue Apr 13 2010 lmuelle@suse.de
- automake: don't use @foo@ constructs in Makefile.am.
* Tue Apr 13 2010 lmuelle@suse.de
- autoconf: define CAPNG_LDADD even when it's not set.
* Fri Apr  9 2010 lmuelle@suse.de
- Update to cifs-utils 4.3.
  + credential files accept parameter names consistent with mount options.
  + some problems with linking are fixed.
  + libcap-ng is used if it's available.
  + the capability bounding set is zeroed out for greater security.
  + CAP_DAC_OVERRIDE is only enabled when updating the mtab.
* Mon Apr  5 2010 sjayaraman@suse.de
- Update to cifs-utils 4.2.
  + significant overhaul of mount.cifs to make it setuid root safe.
  + mount.cifs now does privilege separation.
  + re-enable mount.cifs setuid usage.
  + make mount.cifs use libcap if available to prune its capability set.
  + guard mount.cifs against signals by unprivileged users.
  + mount.cifs is more careful about signal handling during mtab updates.
  + cifs.upcall fixes to make it work with the heimdal kerberos
    implementation.
* Thu Mar 25 2010 lmuelle@suse.de
- Update to cif-utils 4.1.
  + fix ver= option passed to the kernel
  + fix error handling when duplicating options string
  + make check_mountpoint a noop for non-legacy builds
  + remove uuid option
  + remove bogus rsize/wsize options
  + check for NULL addr pointer before handling scopeid
* Mon Mar 22 2010 lmuelle@suse.de
- Add %%version dependency to Provides and Obsoletes.
* Sun Mar 14 2010 lmuelle@suse.de
- Update to cif-utils 4.0.
- Create cifs-utils package which is independent from Samba.
* Mon Mar  8 2010 lmuelle@suse.de
- Update to 3.5.1.
  + Fix security flaw on Linux platforms if built with libcap support allowing
    file system access even when permissions should have denied it;
    CVE-2010-0728; (bso#7222).
* Mon Mar  8 2010 rhafer@novell.com
- Fixed libldb.so link in libldb-devel.
* Fri Mar  5 2010 hhetter@novell.com
- Fix argc handling in net_share, making the command "net share"
  work again; (bso#7203); (bnc#584253).
* Mon Mar  1 2010 lmuelle@suse.de
- Update to 3.5.0.
  + Fix duplicate sam and unix accounts; (bso#7145).
  + Keep the the correct negotiate_flags on the cli->dc structure; (bso#7160).
  + Avoid calling cli_alloc_mid twice in cli_smb_req_iov_send; (bso#7166).
  + Fix 'net ads dns' usage calls; (bso#7181).
  + Fix uninitialized variable in wkssvc_enumerateusers; (bso#7182).
* Wed Feb 24 2010 lmuelle@suse.de
- Update to 3.4.6.
  + Change parameter "wide links" to default to "no"; it's also incompatible
    with "unix extensions"; (bso#7104); (bnc#577868).
  + Fix printing with 64 bit clients (bso#6888).
  + Fix core dump on 64 bit Linux (bso#7063).
  + Fix failing of smbd to respond to a read or a write caused by Linux
    asynchronous IO (aio) (bso#7067).
  + Fix string buffer overflow causing heap corruption in smbd (bso#7096).
  + Fix bogus ip address in SWAT; (bso#5885).
  + Fix vfs_full_audit; (bso#6557).
  + Use the first "uid" value; (bso#6157).
  + Fix large paged search with DirX LDAP servers; (bso#6981).
  + Fix crash bug in 'cifs.upcall'; (bso#6868).
  + Add cross option to samba_cv_linux_getgrouplist_ok; (bso#7047).
  + Fix DFS on AIX (maybe others); (bso#7052).
  + Fix pdb_search crash as non-root user; (bso#7068).
  + Fix unlocking of accounts from ldap; (bso#7072).
  + Fix vfs_expand_msdfs; (bso#7081).
  + Fix results of 'smbclient -L' with a large browse list; (bso#7098).
  + Normalize "Changing password for" msg IDs and STRs; (bso#7102).
  + Fix malformed require_membership_of_sid; (bso#7106).
  + Fix reading of large browselist; (bso#7122).
  + "mangling method = hash" can crash storing a name containing a '.';
    (bso#7154).
  + Valgrind Conditional jump or move depends on uninitialised value(s) error
    when "mangling method = hash"; (bso#7155).
  + Fix listing of printjobs in Windows 7; (bso#7130).
  + Spoolss getprinterdriver2 level 101 marshalling is bad; (bso#7136).
  + Make idmap cache persistent for "ldapsam:trusted".
  + Also fill the memcache with sid<->id mappings in ldapsam_sid_to_id() not
    only the persistent idmap cache.
  + Shortcut uid_to_sid when "ldapsam:trusted = yes".
  + Make pdb_copy_sam_account also copy the group sid.
  + Shortcut gid_to_sid when "ldapsam:trusted = yes".
  + Speed up pdb_get_group_sid().
  + Try to build the full unix_pw structure with ldapsam:trusted support.
  + Optimize ldapsam_alias_memberships() and cache ldap searches.
* Fri Feb 19 2010 lmuelle@suse.de
- Update to 3.5.0rc3.
  + Change parameter "wide links" to default to "no"; it's also incompatible
    with "unix extensions"; (bso#7104); (bnc#577868).
  + Fix vfs_full_audit; (bso#6557).
  + Fix crash bug in 'cifs.upcall'; (bso#6868).
  + Fix duplicate initializer in the rmdir module; (bso#6876).
  + Fix printing with 64 bit clients; (bso#6888).
  + Add cross option to samba_cv_linux_getgrouplist_ok; (bso#7047).
  + Fix core dump on Ubuntu 8.04 64 bit; (bso#7063).
  + Fix failing of smbd to respond to a read or a write caused by Linux
    asynchronous IO (aio); (bso#7067).
  + Fix 'smbget' error status; (bso#7069).
  + Fix build of 'smbfilter'; (bso#7071).
  + Fix unlocking of accounts from ldap; (bso#7072).
  + Cliconnect gets realm wrong with trusted domains; (bso#7079).
  + Fix vfs_expand_msdfs; (bso#7081).
  + Fix storing of create time on directories in an EA in new create time
    code; (bso#7084).
  + Fix an early release of the global lock that can cause data corruption in
    libtdb; (bso#7085).
  + Fix string buffer overflow causing heap corruption in smbd; (bso#7096).
  + Fix results of 'smbclient -L' with a large browse list; (bso#7098).
  + Normalize "Changing password for" msg IDs and STRs; (bso#7102).
  + Fix malformed require_membership_of_sid; (bso#7106).
  + Add pdb_ldap performance fixes; (bso#7116).
  + Change ldap filter to what really was intended; (bso#7116).
  + Add new "nmbd bind explicit broadcast" parameter; (bso#7118).
  + Fix nmbd problems with socket address; (bso#7118).
  + Support large browselist; (bso#7119).
  + Fix reading of large browselist; (bso#7122).
  + Fix listing of printjobs in  Windows 7; (bso#7130).
  + Owner of file not available with Kerberos; (bso#7139).
  + Fix IPv4/IPv6 problems; (bso#7140).
  + Fix get_acl_blob in the acl_tdb VFS module; (bso#7148).
  + "mangling method = hash" can crash storing a name containing a '.';
    (bso#7154).
  + Valgrind Conditional jump or move depends on uninitialised value(s) error
    when "mangling method = hash"; (bso#7155).
  + Fix some wrong newlines in de translation strings.
* Tue Feb  9 2010 lmuelle@suse.de
- Take extra care that a mount point of mount.cifs isn't changed during mount
  and don't allow it to be run as setuid root program; CVE-2010-0787;
  (bso#6853); (bnc#550002).
* Tue Feb  9 2010 lmuelle@suse.de
- Check in mount.cifs for invalid characters in device name and mountpoint;
  CVE-2010-0547; (brc#562156); (bnc#577925).
* Tue Feb  9 2010 boyang@suse.de
- Don't invalidate cache for uninitialized domains; (bnc#538923).
* Tue Feb  9 2010 boyang@suse.de
- Signals are processed twice in child; (bnc#538923).
* Mon Feb  8 2010 jmcdonough@suse.de
- Allow forced pw change even with min pw age; (bnc#561894).
* Mon Feb  8 2010 lmuelle@suse.de
- Change parameter "wide links" to default to "no"; it's also incompatible
  with "unix extensions"; (bso#7104); (bnc#577868).
* Sun Feb  7 2010 boyang@suse.de
- Fix enumerate domain local groups for primary domain; (bnc#573813).
* Sun Feb  7 2010 boyang@suse.de
- Fix malformed require_membership_of_sid; (bnc#525123); (bso#7106).
* Fri Feb  5 2010 lmuelle@suse.de
- Normalize "Changing password for" msg IDs and STRs; (bnc#499233).
* Thu Feb  4 2010 rhafer@novell.com
- Build libtevent and libldb and put them into separate subpackages.
* Tue Jan 26 2010 lmuelle@suse.de
- Update to 3.5.0rc2.
  + The Using Samba HTML book has been removed.
  + 'net', 'smbclient' and libsmbclient can use logon credentials cached by
    Winbind; (bso#7062).
  + New vfs_scannedonly module has been added; (bso#7028).
  + Check password history before increasing "badPasswordCount"; (bso#4347).
  + Fix changing of ACLs on writable file with "dos filemode=yes"; (bso#5202).
  + Restore Samba 3.0.x behavior and use the first "uid" value in pdb_ldap;
    (bso#6157).
  + Fix deletion of an object whose parent folder does not have delete rights
    fails even if the delete right is set on the object in vfs_acl_xattr and
    vfs_acl_tdb; (bso#6876).
  + Fix large paged search with DirX LDAP servers; (bso#6981).
  + Fix a segfault in winbindd_dual_ccache_ntlm_auth(); (bso#7027).
  + Disable sanity check in NetShareEnum for better compatibility with
    Windows; (bso#7029).
  + Fix SMBrmdir error message when deleting a directory fails; (bso#7033).
  + Fix segfault in vfs_cap; (bso#7034).
  + Fix 'net rpc getsid' in hardened Windows environments; (bso#7036).
  + Fix a Winbind segfault in "trusted_domains"; (bso#7037).
  + Complete and improve some German translation of 'net'; (bso#7039).
  + Fix compile error with WITH_DNS_UPDATE. Update .po files; (bso#7039).
  + Fix crash bug in libsmbclient; (bso#7043).
  + Fix bad (non memory copying) interfaces in smbc_setXXXX calls; (bso#7045).
  + Fix libsmbclient crash against OpenSolaris CIFS server; (bso#7046).
  + Lock down some srvsvc calls according to what w2k3 seems to do.
* Tue Jan 19 2010 lmuelle@suse.de
- Update to 3.4.5.
  + Fix memory leak in smbd (bug #7020).
  + Fix changing of ACLs on writable files with "dos filemode=yes"
    (bug #5202).
  + BUG 6642: Fix opening the quota magic file.
  + BUG 6919: Fix remote quota management.
  + BUG 7034: Fix internal error caused by vfs_cap.
  + BUG 7036: Fix 'net rpc getsid' in hardened Windows environments.
  + BUG 7043: Fix crash bug in "SMBC_parse_path".
  + BUG 7045: Fix bad (non memory copying) interfaces in smbc_setXXXX calls.
  + BUG 7046: Fix a crash in libsmbclient used against the OpenSolaris CIFS
    server.
* Tue Jan 12 2010 lmuelle@suse.de
- Free unused memory after a packet got processed; (bso#7020).
* Fri Jan  8 2010 boyang@suse.de
- Add timeout to rpc call to prevent infinite loop when network is
  down; (bnc#538923).
* Thu Jan  7 2010 lmuelle@suse.de
- Update to 3.5.0rc1.
  + BUG 6837: Fix "Too many open files" when trying to access large number of
    files with Windows 7.
  + BUG 6939: Fix long filenames when "mangling method" is set to "hash".
  + BUG 6991: Create symbol links to shared libraries.
  + BUG 6992: make test for getgrouplist cacheable.
  + BUG 7014: Fix Winbind crash when retrieving empty group members.
  + BUG 7020: Fix smbd using 2G memory.
  + Ensure dos_mode can return FILE_ATTRIBUTE_NORMAL, then filter the returned
    attributes by protocol level.
  + Vector correctly through reply_openerror() (which uses the same logic).
  + Fix bugs with the full Windows ACL support.
  + Add a few missing gettext calls to the 'net' command.
  + Fix up a share type translation and translate some more strings in 'net'.
  + Allow to call "pdbedit -N description -u user" without specifiyng "-r".
  + Add spoolss_DriverInfo7.
  + Fix rpcclient after setprinter IDL fixes.
  + Use generated krb5.conf in 'net ads testjoin'.
  + Add some German translations for the 'net' command.
  + Update mount.cifs man page with nounix option.
  + Fix _samr_GetAliasMembership for results with 0 rids.
  + Fix an error case in cli_negprot.
  + Add a lower-cost alternative to wbinfo -t: wbinfo --ping-dc.
  + Restore correct timeouts for SMB requests.
  + Fix a 64-bit error in libsmb.
  + Replace IS_DOMAIN_OFFLINE by a function in Winbind.
  + Simplify/cleanup Winbind code.
  + Fix write behind memory block in libtalloc.
  + Fix result check for getaddrinfo().
  + Add tsocket_address_bsd_sockaddr() and tsocket_address_bsd_from_sockaddr()
    to tsocket.
  + Always set tdb->tracefd to -1 to be safe on goto fail in libtdb.
  + Add TDB_DISALLOW_NESTING and make TDB_ALLOW_NESTING the default behavior.
  + Fix standalone 'make installdocs'.
  + Output %%p as unsigned in snprintf replacement.
  + New attempt at TDB transaction nesting allow/disallow.
  + Remove swig stuff from libtdb.
  + Reset tdb->fd to -1 in tdb_close() in libtdb.
  + Change the way mksysms work in libtalloc.
  + Also build and install tdb manpages from standalone tdb.
  + Fix infinite loop in NCACN_IP_TCP as there is no timeout.
  + Make winbindd_cache.c aware of domain offline to avoid unnecessary backend
    query.
  + List trusted domains from wcache when domain is offline.
* Thu Jan  7 2010 lmuelle@suse.de
- Update to 3.4.4.
  + Fix interdomain trust relationships with Win2008R2 (bug #6697).
  + Fix Winbind crashes when queried from nss (bug #6889).
  + Fix Winbind crash when retrieving empty group members (bug #7014).
  + Fix "UID range full" error in Winbind (bug #6901).
  + Fix multiple LDAP servers in "idmap backend" and "idmap alloc
    backend" (bug #6910).
  + BUG 4832: Fix iconv checks.
  + BUG 6338: Do not always display "none" in 'net rpc trustdom list'.
  + BUG 6851: Add pdbedit --kickoff-time/-K to set the user's kickoff time.
  + BUG 6828: Fix infinite timeout when byte lock held outside of samba.
  + BUG 6837: Fix "Too many open files" message when trying to access a large
    number of files with Windows 7.
  + BUG 6841: Fix "map acl inherit = yes".
  + BUG 6850: Fix shadow copy display on Windows 7.
  + BUG 6867: Fix listing of directories with a lot of files.
  + BUG 6868: Support building with Heimdal we well as with MIT.
  + BUG 6875: Fix DOS attributes on OS/2 clients.
  + BUG 6880: Fix listing of workgroup servers in libsmbclient.
  + BUG 6898: Samba duplicates file content on appending.
  + BUG 6918: Fix krb5 build problem on Ubuntu karmic.
  + BUG 6929: Fix build with recent heimdal.
  + BUG 6939: Fix long filenames with "mangling method = hash".
  + BUG 6967: Fix 'net ads join' with OU.
  + BUG 6981: Fix paged search with DirX LDAP server.
  + BUG 6982: Remove erroneous out of memory error path in lookup_sid.
  + BUG 6997: Fix _samr_GetAliasMembership for results with 0 rids.
  + BUG 7005: Fix "mangle method = hash" truncates files with dot "."
    character.
  + Fix the build of the winbind krb5 locator plugin.
  + Fix enumprinter key client and server.
* Wed Jan  6 2010 lmuelle@suse.de
- Readjust the _libdir/cups/backend/smb sym link only on uninstall of the
  samba-krb-printing package; (bnc#568603).
* Fri Jan  1 2010 lars@samba.org
- Add BuildRequires to fam-devel; (bnc#564260).
* Wed Dec 30 2009 jmcdonough@suse.de
- Prevent winbind crash; (bso#7014); (bnc#566119).
* Mon Dec 21 2009 sjayaraman@suse.de
- Fix processing of open modes in POSIX open; (bnc#530683).
* Thu Dec 17 2009 jengelh@medozas.de
- Add baselibs.conf as a source.
* Tue Dec 15 2009 lmuelle@suse.de
- Update to 3.5.0pre2.
  + BUG 2350: Add LDAP Alias Dereferencing support.
  + BUG 6288: SWAT adds a second share when changing parameters of an existing
    share.
  + BUG 6435: Fix minor memory corruption.
  + BUG 6710: Only install the cifs.upcall man page if CIFSUPCALL_PROGS was
    set while configure.
  + BUG 6802: A created folder does not properly inherit permissions from
    parent in vfs_acl_xattr.
  + BUG 6837: "Too many open files" when trying to access large number of
    files from Windows 7.
  + BUG 6860: Fix shared library build on QNX.
  + BUG 6879: Fix crash in Winbind.
  + BUG 6929: Fix build with recent heimdal.
  + BUG 6938 : No hook exists to check creation rights when using acl_xattr
    module.
  + BUG 6967: Prevent glibc error on 'net ads join'.
  + Fix vfs_acl_xattr which was failing to call the NEXT connect function.
  + Restructure the ACL code.
  + Refactor reply_rmdir to use handle based code.
  + Fix the build when no external talloc and tdb are installed.
  + Fix detection of CTDB headers on systems without system-libtalloc.
  + Fix several printing issues.
  + Fix the build on Mac OS X 10.6.2.
  + Fix net and rpcclient after setprinterdataex changes.
  + Add full support for level 8 printer drivers.
  + Add more spoolss architectures to IDL.
  + Fix enumprinter key client and server.
  + Fix crash in EnumPrinterDataEx.
  + Prefer posix_fallocate for doing "strict allocate".
  + Restore "fake directory create times" as a share parameter.
  + Fix explicit stat64 support.
  + Add support for NetWkstaGetInfo 101 and 102.
  + Add rpcclient wkssvc_enumerateusers.
  + De-deprecate "write cache size" to prevent its removal without a proper
    alternative.
  + Allow more than 1000 users in BUILTIN\Users.
  + Complete support for NetWkstaGetInfo/NetWkstaEnumUsers.
  + Fix the build of the example VFS modules.
  + Fix crash in free_file_list().
  + Give the user a chance to change password when password will expire soon.
* Wed Dec  9 2009 lmuelle@suse.de
- Store the smbfs service state if enabled and restore it for cifs while
  upgrade on post-11.2 systems.
* Wed Dec  9 2009 lmuelle@suse.de
- Prevent cifstab from being overwritten while upgrade on post-11.2 systems.
* Wed Dec  9 2009 boyang@suse.de
- Give the user a chance to change password when password will expire soon;
  (FATE#302414).
* Tue Dec  8 2009 lmuelle@suse.de
- Rename smbfs init script to cifs for post-11.2 systems.
* Tue Dec  8 2009 jmcdonough@suse.de
- Allow Windows 7 to connection to samba domain controllers and
  member servers; (bnc#551811); (bso#6099); (bso#6100); (bso#6680).
* Fri Dec  4 2009 jmcdonough@suse.de
- Error on joining windows domain (invalid pointer); (bso#6967);
  (bnc#553622).
* Thu Dec  3 2009 lmuelle@suse.de
- Add PreReq /usr/sbin/groupadd to the winbind package; (bnc#559165).
- Simplify the winbind package %%pre script and suppress stdout only.
* Thu Nov 26 2009 lmuelle@suse.de
- Update to 3.5.0pre1
  + Add support for full Windows timestamp resolution.
  + Experimental implementation of SMB2.
  + Add encryption support for connections to a CUPS server.
  + Major windbind asynchronous refactoring.
- Remove using_samba from the doc package.
- Increase major version of libtalloc to 2.
* Thu Nov 19 2009 boyang@suse.de
- Fix kerberos refresh chain; (bnc#546162); (bso#6872).
* Fri Nov  6 2009 lmuelle@suse.de
- Hardlink duplicate files on post-11.1 systems.
* Fri Nov  6 2009 lmuelle@suse.de
- Add BuildArch noarch to samba-doc on post-11.1 systems.
* Tue Nov  3 2009 boyang@suse.de
- Use full 16byte session key in make_user_info_netlogon_interactive();
  (bnc#551811).
* Thu Oct 29 2009 lmuelle@suse.de
- Update to 3.4.3.
  + Fix trust relationships to windows 2008 (2008 r2) (bug #6711).
  + Fix file corruption using smbclient with NT4 server (bug #6606).
  + Fix Windows 7 share access (which defaults to NTLMv2) (bug #6680).
  + BUG 4675: mount.cifs: Do not attempt to update /etc/mtab if it is a
    symbolic link.
  + BUG 6529: Offline files conflict with Vista and Office 2003.
  + BUG 6532: Fix domain enumeration if master browser has space in name.
  + BUG 6606: Fix file corruption using smbclient with NT4 server.
  + BUG 6690: Fix wrong error check in profile.
  + BUG 6703: Allow smbstatus as non-root.
  + BUG 6704: Fix syntax error in avahi configure test.
  + BUG 6707: Fix an occasional segfault in config file parsing.
  + BUG 6710: Adjust regex to match variable names including underscores.
  + BUG 6711: Fix trust relationships to windows 2008 (2008 r2).
  + BUG 6726: SIVAL should have been an SVAL.
  + BUG 6728: BSD needs sys/sysctl.h included to build properly.
  + BUG 6731: Fix reading beyond the end of a named stream in xattr_streams.
  + BUG 6735: Don't overwrite password in pam_winbind, subsequent pam modules
    might use the old password and new password.
  + BUG 6764: Fix timeval calculation.
  + BUG 6765: Add a "hidden" parameter "share:fake_fscaps".
  + BUG 6769: Fix symlink unlink.
  + BUG 6772: Allow outstanding_aio_calls to be decremented.
  + BUG 6774: smbd crashes if "aio write behind" is set.
  + BUG 6776: Fix core dump caused by running overlapping Byte Lock test.
  + BUG 6781: Fix renaming subfolders in Explorer view.
  + BUG 6791: Fix linking order in cifs.upcall.
  + BUG 6793: Fix Winbind crash with "INTERNAL ERROR: Signal 6".
  + BUG 6793: Fix segfault in winbindd_pam_auth.
  + BUG 6796: Deleting an event context on shutdown can cause smbd to crash.
  + BUG 6797: Fix a memleak in libwbclient.
  + BUG 6804: Fix hpux compiler issue.
  + BUG 6805: Correctly handle aio_error() and errno.
  + BUG 6807: Fix a segfault in "net rpc trustdom list" for long domain names.
  + BUG 6810: Add support for finding alternate credcaches to cifs.upcall.
  + BUG 6811: Fix reference to freed memory in pam_winbind.
  + BUG 6815: Fix Windows 2008 R2 SPNEGO negTokenTarg parsing failure.
  + BUG 6824: Fix avahi activation.
  + BUG 6826: Don't fail authentication when one or some group of
    require-membership-of is invalid.
  + BUG 6828: Fix infinite timeout when byte lock held outside of Samba.
  + BUG 6829: Fix displaying of multibyte characters in smbclient.
  + BUG 6840: Fix crash in pam_winbind.
  + Fix an uninitialized variable.
  + Only ever handle one event after a select call.
  + Conditional install of the cifs.upcall man page.
  + Fix warning occuring when building the manpages.
* Fri Oct 23 2009 lmuelle@suse.de
- Let smbclient show special characters properly; (bso#6829); (bnc#544204).
* Fri Oct 23 2009 boyang@suse.de
- Don't fail authentication when one or some group of require-membership-of
  is invalid; (bnc#525123); (bso#6826).
* Fri Oct 16 2009 jmcdonough@suse.de
- Allow winbind to ignore certain domains; (bnc#539506).
* Thu Oct  8 2009 lmuelle@suse.de
- Update to 3.4.2.
  + Fix unresolved home path; CVE-2009-2813; (bso#6763); (bnc#539517).
  + Fix potential denial of service; CVE-2009-2906; (bso#6768); (bnc#543115).
  + Fix potential mount.cifs password leaks; CVE-2009-2948; (bnc#542150).
* Wed Sep 30 2009 jmcdonough@suse.de
- Fix potential denial of service; CVE-2009-2906; (bnc#543115).
* Fri Sep 25 2009 jmcdonough@suse.de
- Fix potential mount.cifs password leaks; CVE-2009-2948; (bnc#542150).
* Wed Sep 23 2009 jmcdonough@suse.de
- Fix unresolved home path; CVE-2009-2813; (bnc#539517).
* Mon Sep 21 2009 boyang@suse.de
- Don't overwrite password in pam_winbind; (bnc#515444).
* Mon Sep 14 2009 chris@computersalat.de
- mods for winbind (when used with squid - ntlm_auth)
  o winbind adds group 'winbind'
  o permission 0750,root,winbind LOCKDIR/winbindd_privileged
* Thu Sep 10 2009 lmuelle@suse.de
- Merge two fixes from 3.2.8 and 3.3.1.
  + Adjust regex to match variable names including underscores.
  + Conditional install of the cifs.upcall man page.
* Wed Sep  9 2009 lmuelle@suse.de
- Remove supplements from baselibs.conf while %%clean for pre-11.1 systems;
  (bnc#520579).
* Wed Sep  9 2009 lmuelle@suse.de
- Update to 3.4.1.
  + Fix authentication on member servers without Winbind (bug #6650).
  + Nautilus fails to copy files from an SMB share (bug #6649).
  + Fix connections of Win98 clients (bug #6551).
  + Fix interdomain trusts with Windows 2008 R2 DCs (bug #6697).
  + Fix Winbind authentication issue (bug #6646).
  + BUG 5879: Update LDAP schema for Netscape DS 5.
  + BUG 5886: Fix password change propagation with ldapsam.
  + BUG 6105: Make linking of cifs.upcall and rpcclient --as-needed safe.
  + BUG 6222: Default to DRSUAPI replication for net rpc vampire keytab.
  + BUG 6437: Make open_udp_socket() IPv6 clean.
  + BUG 6496: MS-DFS cannot follow multibyte char link name in libsmbclient.
  + BUG 6506: Smbd server doesn't set EAs when a file is overwritten in
    NT_TRANSACT_CREATE.
  + BUG 6532: Fix the build with external talloc.
  + BUG 6538: Cancel all locks that are made before the first failure.
  + BUG 6560: Fix lookupname.
  + BUG 6564: SetPrinter fails (panics) as non root.
  + BUG 6568: Fix _spoolss_GetPrintProcessorDirectory() implementation.
  + BUG 6585: Fix unqualified "net join".
  + BUG 6593: Correctly implement SMB_INFO_STANDARD setfileinfo.
  + BUG 6601: Avoid global fd limits.
  + BUG 6607: Fix crash bug in spoolss_addprinterex_level_2.
  + BUG 6611: Fix a valgrind error in chain_reply.
  + BUG 6615: Fix browsing of DFS when using kerberos in libsmbclient.
  + BUG 6627: Raise the timeout for lsa_Lookup*() calls from 10 to 35 seconds.
  + BUG 6650: Fix authentication on member servers without Winbind.
  + BUG 6651: Fix smbd SIGSEGV when breaking oplocks.
  + BUG 6655: Fix 'smbcontrol smbd ping'.
  + BUG 6620: Fix a bug in renames of directories.
  + BUG 6664: Fix truncation of the session key.
  + BUG 6673: Fix 'smbpasswd' with "unix password sync = yes".
  + BUG 6680: Fix authentication failure from Windows 7 when domain joined.
  + BUG 6688: Fix crash in 'net usershare list'.
  + BUG 6693: Check we read off the complete event from inotify.
  + BUG 6700: Use dns domain name when needing to guess server principal.
* Thu Aug 13 2009 boyang@suse.de
- Update to 3.2.14.
  + Fix SAMR access checks (e.g. bugs #6089 and #6112).
  + Fix 'force user' (bug #6291).
  + Improve Win7 support (bug #6099).
  + Fix posix ACLs when setting an ACL without explicit ACE for the
    owner (bug #2346).
  + BUG 6387: Fix Winbind crash when multiple IDmappings exist in the
    LDAP directory.
  + BUG 6509: Use gid (not uid) cache in fetch_gid_from_cache().
  + BUG 6628: 'smbpasswd -a' uses algorithmic rid base with
    'passdb backend = tdbsam'.
  + BUG 6089: Fix SAMR access checks.
  + BUG 6112: Fix SAMR access checks.
  + BUG 6279: Fix Winbind crash.
  + BUG 6291: Fix 'force user'.
  + BUG 6099: Try to fix domain join of Win7 Beta.
  + BUG 6386: Groupdb mapping fix.
  + BUG 6421: Fix POSIX read-only open on read-only shares.
  + BUG 6476: Fix more smbd-zombies in memory.
  + BUG 6488: acl_group_override() call in posix acls references an
    uninitialized variable.
  + BUG 6504: Fix SAMR server for Winbind access.
  + BUG 6520: Fix time stamps.
  + BUG 6301: Fix samr_ConnectVersion enum which is 32bit not 16bit.
  + BUG 6340: Don't segfault when cleartext trustdom pwd could not be
    retrieved.
  + BUG 6372: Fix usermanager only displaying 1024 groups and aliases.
  + BUG 6465: Fix enum_aliasmem in ldb branch.
  + BUG 6484: Fix searching for users while adding them to groups via
    Windows usermanager.
  + BUG 2346: Fix posix ACLs when setting an ACL without explicit ACE for the
    owner.
  + BUG 6526: Let parent_dirname() correctly return toplevel filenames.
  + BUG 6627: Raise the timeout for lsa_Lookup*() calls from 10 to 35 seconds.
  + BUG 5798: Preserve CFLAGS info in configure.
  + BUG 6382: Case insensitive access to DFS links broken.
  + BUG 6481: Don't require "Modify property" perms to unjoin.
  + BUG 6628: 'smbpasswd -a' uses algorithmic rid base with
    'passdb backend = tdbsam'.
  + BUG 6560: Lookupname failed, cannot find domain when attempt to change
    password.
  + Prevent creation of keys containing the '/' character.
  + Fix join of Windows 7 RC to a Samba3 DC.
  + Fix bug in processing of open modes in POSIX open.
  + Fix the negotiate flags.
  + Protect netlogon_creds_server_step() against NULL creds.
  + Also handle DirX return codes.
  + Fix a crash bug if we timeout in net rpc trustdom list.
  + Add '--request-timeout' option to 'net'.
  + Fix a race condition in Winbind leading to a panic.
  + Add workaround for MS KB932762.
  + 5945: Fix out of memory error with Winbind idmap.
  + Avoid duplicate ACEs.
  + Fix profile ACLs in some corner cases.
  + Zero an uninitialized array.
* Wed Aug 12 2009 boyang@suse.de
- Unable to browse DFS when using kerberos in libsmbclient; (bnc#528271);
  (bso#6615).
* Mon Aug 10 2009 boyang@suse.de
- check in .po files for pam_winbind; (bnc#499233); (bso#6602).
* Thu Aug  6 2009 hhetter@suse.de
- Add ntp and network-remotefs as Should-Start dependency to the winbind init
  script; (bnc#515629).
* Thu Aug  6 2009 lmuelle@suse.de
- Update to 3.0.36.
  + Fix Winbind crash on 'getent group' (bug #5906).
  + Excel save operation corrupts file ACLs (bug #4308).
  + Prevent segmentation fault on joining a very long domain name.
  + BUG 4308: Excel save operation corrupts file ACLs.
  + BUG 4370: Clean-up entries in /etc/mtab after unmount.
  + BUG 4640: Fix guest mounts in mount-cifs.
  + BUG 5906: Fix Winbind crash on 'getent group'.
  + BUG 6066: netinet/ip.h present but cannot be compiled on Solaris.
  + BUG 6099: In order to allow Win7 to connect to a Samba NT style.
  + BUG 6279: Fix Winbind crash.
    PDC we set the flags before we know if it's an error or not.
  + BUG 6085: Fix build of vfs_default.
  + BUG 6098: When the DNS server is invalid, the ads_find_dc() does not work
    correctly.
  + Fix logic error in try_chown.
  + Correctly use chroot().
  + Fix bug in processing of open modes in POSIX open.
  + Don't install the cifs.upcall binary twice.
  + Fix mount.cifs handling of -V option.
  + Prevent segmentation fault on joining a very long domain name.
  + Don't try and delete a default ACL from a file.
  + Add workaround for MS KB932762.
  + Add fakemount (-f) and nomtab (-n) flags to mount.cifs.
  + Fix a crash during name resolution when log level >= 10
    and libc segfaults if printf is passed NULL for a "%%s" arg.
* Sat Aug  1 2009 lmuelle@suse.de
- Use a conditional suse_version macro in front of the SUSE_ASNEEDED export.
* Mon Jul 27 2009 boyang@suse.de
- lookupname failed, cannot find domain when attempt to change password;
  (bnc#520645); (bso#6560).
* Thu Jul 16 2009 lmuelle@suse.de
- Don't link with --as-needed flag on post-11.1 systems.
* Tue Jul 14 2009 lmuelle@suse.de
- Stop the smbfs service if an interface goes down; (bnc#517768).
* Wed Jul  8 2009 lmuelle@suse.de
- Disable build of static libraries on post-11.1 systems; (bnc#509945).
* Wed Jul  8 2009 jmcdonough@suse.de
- Fix missing zlibs for cifs.upcall and test_shlibs.
* Fri Jul  3 2009 lmuelle@suse.de
- Update to 3.4.0.
  + BUG 6431: Local groups from 3.0 setups no longer found.
  + BUG 6459: Fix build of pam_smbpass on some distributions.
  + BUG 6481: 'net ads leave' needs to try account deletion, NetUnjoinDomain
    not.
  + BUG 6497: Fix calling of 'test' in configure.
  + BUG 6498: Add workaround for MS KB932762.
  + BUG 6499: Fix building of pam_smbpass.
  + BUG 6509: Use gid (not uid) cache in fetch_gid_from_cache().
  + BUG 6512: Fix support for enumerating user forms.
  + BUG 6514: Improve error message in 'net' when smb.conf is not available.
  + BUG 6520: Fix time stamps when "unix extensions = yes".
  + BUG 6521: Fix building tevent_ntstatus without config.h.
  + BUG 6526: Fix notifies in the share root directory.
  + BUG 6531: Fix pid file name.
* Thu Jul  2 2009 lmuelle@suse.de
- Package /etc/samba/smbpasswd as %%ghost on post-11.1 systems.
* Tue Jun 30 2009 jmcdonough@suse.de
- Fix net ads leave; (bnc#511695).
* Thu Jun 25 2009 sbrabec@suse.cz
- Supplement pam-32bit/pam-64bit in baselibs.conf (bnc#354164).
- Supplement glibc-32bit/glibc-64bit in baselibs.conf (bnc#354164).
* Wed Jun 24 2009 lmuelle@suse.de
- Update to 3.2.13, 3.3.6.
  + In Samba 3.2.0 to 3.2.12 (inclusive), the smbclient commands dealing with
    file names treat user input as a format string to asprintf.  With a
    maliciously crafted file name smbclient can be made to execute code
    triggered by the server; CVE-2009-1886; (bnc#513360); (bso#6478).
* Wed Jun 24 2009 lmuelle@suse.de
- Update to 3.0.35.
  + In Samba 3.0.31 to 3.3.5 (inclusive), an uninitialized read of a
    data value can potentially affect access control when "dos filemode"
    is set to "yes"; CVE-2009-1888; (bnc#515479).
* Tue Jun 23 2009 jmcdonough@suse.de
- Uninitialized read of a data value; CVE-2009-1888 (bnc#515479).
* Fri Jun 19 2009 lmuelle@suse.de
- Update to 3.4.0rc1.
  + BUG 4699: Remove pidfile on clean shutdown.
  + BUG 5456: Fix "net ads testjoin".
  + BUG 6081: Make it possible to change machine account sids.
  + BUG 6253: Use correct value for password expiry calculation in
    pam_winbind.
  + BUG 6297: Owner of sticky directory cannot delete files created by others.
  + BUG 6305: Correctly prompt for a password when a username was given.
  + BUG 6328: Add support for multiple rights to
    "net sam rights grant/revoke".
  + BUG 6333: Consolidate create/delete account paths in pdbedit.
  + BUG 6449: 'net rap user add' crashes without -C option.
  + BUG 6451: net/libnetapi user rename using wrong access bits.
  + BUG 6458: Fix uninitialized variable in local_password_change().
  + BUG 6465: Fix enumeration of empty aliases.
  + BUG 6476: Fix smbd-zombies in memory when using [x]inetd.
  + BUG 6487: Add missing DFS call in trans2 mkdir call.
  + BUG 6488: acl_group_override() call in posix acls references an
    uninitialized variable.
  + Improve pam_winbind documentation.
- Install a vendor copy of samba-common.dhcp as dhcpcd-hook-samba-functions.
* Thu Jun 18 2009 boyang@suse.de
- Samba 3.2.0 - 3.2.12 smbclient commands dealing with file names treat user
  input as a format string to asprintf; CVE-2009-1886; (bnc#513360).
* Wed Jun 17 2009 boyang@suse.de
- Fix a bad memleak in vfs_full_audit; (bnc#510035).
* Tue Jun 16 2009 lmuelle@suse.de
- Update to 3.3.5.
  + Fix SAMR and LSA checks (bug #6089, #6289)
  + Fix posix acls when setting an ACL without explicit ACE for the
    owner (bug #2346).
  + Fix joining of Win7 into Samba domain (bug #6099).
  + Fix joining of Win2000 SP4 clients (bug #6301).
  + BUG 2346: Fix posix acls when setting an ACL without explicit ACE for the
    owner.
  + BUG 5832: Fix build on RHEL when ccache is not available.
  + BUG 5853: Add keyutils-devel to build requires to fix build on RHEL.
  + BUG 5897: Fix shutdown script example in the smb.conf manpage.
  + BUG 6089: Revert the extra SAMR and LSA checks.
  + BUG 6099: Fix joining of Win7 into Samba domain.
  + BUG 6157: Fix handling of multi-value attribute "uid".
  + BUG 6289: Revert the extra SAMR and LSA checks.
  + BUG 6297: Owner of sticky directory cannot delete files created by others.
  + BUG 6301: Fix joining of Win2000 SP4 clients.
  + BUG 6309: Support remote unjoining of Windows 2003 or greater.
  + BUG 6315: smbd crashes doing vfs_full_audit on IPC$ close event.
  + BUG 6320: Handle registry config source in file_list.
  + BUG 6330: Fix DFS on AIX.
  + BUG 6336: Fix 'net groupmap set' segfault.
  + BUG 6361: Make --rcfile work in smbget.
  + BUG 6365: Re-Add the "dropbox" functionality with -wx rights on a
    directory.
  + BUG 6372: Fix usermanager only displaying 1024 groups and aliases.
  + BUG 6382: Fix case insensitive access to DFS links.
  + BUG 6415: Filter out of range mappings in default idmap config in
    idmap_tdb.
  + BUG 6416: Filter out of range mappings in default idmap config in
    idmap_tdb2.
  + BUG 6417: Filter out of range mappings in default idmap config in
    idmap_ldap.
  + BUG 6441: Fix the compile with --enable-dnssd.
  + BUG 6449: 'net rap user add' crashes without -C option.
  + BUG 6465: Fix enumeration of empty aliases (ldb backend).
  + Prevent infinite include nesting.
  + Mark registry shares without path unavailable.
  + Also handle DirX return codes.
  + Fix Coverity ID 897.
  + Do not crash in ctdbd_traverse if ctdbd is not around.
  + Fix a race condition in winbind leading to a panic.
  + Some man pam_winbind improvements.
  + Zero an uninitialized array.
* Tue Jun 16 2009 lmuelle@suse.de
- Update to 3.2.12.
  + Fix SAMR and LSA checks (bug #6089, #6289)
  + Fix posix acls when setting an ACL without explicit ACE for the
    owner (bug #2346).
  + Fix "force user" (bug #6291).
  + Fix Winbind crash (bug #6279).
  + Fix joining of Win7 into Samba domain (bug #6099).
  + BUG 2346: Fix posix acls when setting an ACL without explicit ACE for the
    owner.
  + BUG 5798: CFLAGS info lost in configure.
  + BUG 5832: Fix build on RHEL when ccache is not available.
  + BUG 5835: Add keyutils-devel to build requires.
  + BUG 5945: Fix out of memory error with Winbind idmap.
  + BUG 6089: Revert the extra SAMR and LSA checks.
  + BUG 6099: Fix joining of Win7 into Samba domain.
  + BUG 6279: Fix Winbind crash.
  + BUG 6289: Revert the extra SAMR and LSA checks.
  + BUG 6291: Fix "force user".
  + BUG 6301: Fix samr_ConnectVersion enum which is 32bit not 16bit.
  + BUG 6372: Fix usermanager only displaying 1024 groups and aliases.
  + BUG 6386: Groupdb mapping fix.
  + BUG 6382: Fix case insensitive access to DFS links.
  + BUG 6465: Fix enumeration of empty aliases (ldb backend).
  + Prevent creation of keys containing the '/' character.
  + Fix bug in processing of open modes in POSIX open.
  + Protect netlogon_creds_server_step() against NULL creds.
  + Also handle DirX return codes.
  + Fix a race condition in winbind leading to a panic.
  + Fix a crash bug if we timeout in net rpc trustdom list.
  + Fix profile acls in some corner cases.
* Fri Jun 12 2009 lmuelle@suse.de
- Default with passdb backend to smbpasswd for SUSE products older than 11.2.
* Fri Jun 12 2009 lmuelle@suse.de
- Explicitly use 'tdbsam' as passdb backend in the default smb.conf file.
* Mon Jun  8 2009 lmuelle@suse.de
- Update to 3.4.0pre2.
  + The default passdb backend has been changed to 'tdbsam'!
  + Samba4 and Samba3 sources are included in the tarball.
  + Changed the way smbd handles untrusted domain names given during user
    authentication.
  + Various fixes including printer change notificiation for Samba spoolss
    print servers.
  + The remaining hand-marshalled DCE/RPC services (ntsvcs, svcctl, eventlog
    and spoolss) were replaced by autogenerated code based on PIDL.
  + Samba3 and Samba4 do now share a common tevent library.
  + The code has been cleaned up and the major basic interfaces are shared
    with Samba4 now.
  + An asynchronous API has been added.
  + Made parameter syntax of the net command more consistent.
  + BUG 2346: Fix posix ACLs when setting an ACL without explicit ACE for the
    owner.
  + BUG 4271: testparm should not print includes.
  + BUG 4831: Don't call openlog() or closelog() from pam_smbpass.
  + BUG 5681: Do not limit the number of network interfaces.
  + BUG 5859: Fix renaming of samr objects failed due to samr setuserinfo
    access checks.
  + BUG 6099: Fix NETLOGON credential chain.
  + BUG 6136: New AFS syscall conventions.
  + BUG 6157: Fix handling of multi-value attribute "uid".
  + BUG 6253: Use correct value for password expiry calculation.
  + BUG 6291: Fix 'force user'.
  + BUG 6292: Update config.guess from gnu.org.
  + BUG 6302: Give the VFS a chance to read from 0-byte files.
  + BUG 6309: Support remote unjoining of Windows 2003 or greater.
  + BUG 6313: ldapsam_update_sam_account() crashes while doing talloc_free on
    malloced memory.
  + BUG 6315: Fix smbd crashes when doing vfs_full_audit on IPC$ close event.
  + BUG 6320: Handle registry config source in file_list.
  + BUG 6330: Fix DFS on AIX.
  + BUG 6336: Fix segfault in 'net groupmap set'.
  + BUG 6340: Don't segfault when cleartext trustdom pwd could not be
    retrieved.
  + BUG 6357: Use Samba default command line arguments in 'net'.
  + BUG 6359: smbclient -L does not list workgroup for hosts with both IPv4
    and IPv6 addresses
  + BUG 6361: Make --rcfile work in smbget.
  + BUG 6371: Unsuccessful 'net conf setparm' leaves empty share.
  + BUG 6372: usermanager only displaying 1024 groups and aliases.
  + BUG 6387: Fix a crash bug in idmap_ldap_unixids_to_sids.
  + BUG 6415: Filter out of range mappings in default idmap config
    (idmap_tdb).
  + BUG 6416: Filter out of range mappings in default idmap config
    (idmap_tdb2).
  + BUG 6417: Filter out of range mappings in default idmap config
    (idmap_ldap).
  + Change the way smbd handles untrusted domain names given during user
    authentication.
  + Replace the hand-marshalled DCE/RPC services ntsvcs, svcctl, eventlog and
    spoolss by autogenerated code based on PIDL.
  + Fix several printing issues and improve support for printer change
    notificiations.
  + Add 'net eventlog'.
  + Add asynchronous API.
  + Make Samba3 and Samba4 share a tevent library.
  + Add two new parameters to control how we verify kerberos tickets.
  + Add 'net rpc service' subcommands 'create' and 'delete'.
  + Fix the core of the SAMR access functions.
  + Fix SAMR server for winbindd access.
  + Add dbwrap_tool - a tdb tool that is CTDB-aware.
  + Hide "config backend" from swat.
  + Fix linking with --disable-shared-libs.
  + Fix issue with missing entries when enumerating directories.
  + Map NULL domains to our global sam name.
  + Fix driver upload for Xerox 4110 PS printer driver.
  + Add "net dom renamecomputer" to rename machines in a domain.
  + Inspect the correct computername string before enabling/disabling the
    change button in netdomjoin-gui.
  + Fix join prompt dialog test in netdomjoin-gui.
  + Only gray out labels when not root and not connecting to remote
    machines (netdomjoin-gui).
  + Allow to switch between workgroups/domains with the same name
    (netdomjoin-gui).
  + Add NetShutdownInit and NetShutdownAbort.
  + Fix samr access checks.
  + Add a security model to LSA.
  + Also handle DirX return codes.
  + Do not crash in ctdbd_traverse if ctdbd is not around.
  + Fix Coverity ID 897.
  + Fix a race condition in vfs_aio_fork with gpfs share modes.
  + Fix bug disclosed by lock8 torture test.
  + Fix a race condition in winbind leading to a panic.
  + Detect tight loop in tdb_find().
  + Fix chained sesssetupAndX/tconn messages.
  + Fix strict locking with chained reads.
  + Fix two bugs in sendfile.
  + Fix memory leak.
  + Fix file descriptor leak.
  + Fallback to the legacy sid_to_(uid|gid) instead of returning NULL.
  + Always allocate memory in dptr_ReadDirName.
  + Fix 'net' crash during domain join.
  + Zero an uninitialized array.
  + Allow child processes to exit gracefully if we are out of fds.
* Thu Jun  4 2009 sjayaraman@suse.de
- Enable cifs.upcall on versions newer than SUSE 10.0.
* Thu Jun  4 2009 sjayaraman@suse.de
- Add BuildRequires to keyutils-devel.
* Thu Jun  4 2009 sjayaraman@suse.de
- Remove redundant Requires to keyutils-libs for cifs-mount.
* Wed May 27 2009 jmcdonough@suse.de
- Detect tight loop in tdb_find(); (bnc#450974).
* Mon May 18 2009 jmcdonough@suse.de
- Fix lp printing with kerberos; (bnc#476913).
* Sat May  9 2009 lmuelle@suse.de
- Add BuildRequires to ctdb-devel for systems newer than SUSE 10.0 and all
  other build targets.
* Thu Apr 30 2009 lmuelle@suse.de
- Update to 3.4.0pre1.
  + Samba4 and Samba3 sources are included in the tarball
  + Changed the way smbd handles untrusted domain names given during user
    authentication.
  + Various fixes including printer change notificiation for Samba spoolss
    print servers.
  + The remaining hand-marshalled DCE/RPC services (ntsvcs, svcctl, eventlog
    and spoolss) were replaced by autogenerated code based on PIDL.
  + Samba3 and Samba4 do now share a common tevent library.
  + The code has been cleaned up and the major basic interfaces are shared
    with Samba4 now.
  + An asynchronous API has been added.
  + Change the way smbd handles untrusted domain names given during user
    authentication.
  + Replace the hand-marshalled DCE/RPC services ntsvcs, svcctl, eventlog and
    spoolss by autogenerated code based on PIDL.
  + Fix several printing issues and improve support for printer change
    notificiations.
  + Add 'net eventlog'.
  + Add asynchronous API.
  + Make Samba3 and Samba4 share a tevent library.
  + Add two new parameters to control how we verify kerberos tickets.
  + Add 'net rpc service' subcommands 'create' and 'delete'.
  + Make merged build possible.
  + Move common libraries to the shared lib/ directory.
* Thu Apr 30 2009 lmuelle@suse.de
- Update to 3.3.4.
  + Fix domain logins for WinXP clients pre SP3 (bug #6263).
  + Fix samr_OpenDomain access checks (bug #6089).
  + Fix usrmgr.exe creating a user (bug #6243).
  + BUG 6089: Fix samr_OpenDomain access checks.
  + BUG 6254: Fix IPv6 PUT/GET errors to an SMB server (3.3) with
    "msdfs root" set to "yes".
  + BUG 6279: Fix Winbind crash.
  + BUG 5329: Add "net rpc service delete/create".
  + BUG 6238: Make sure wbcLogoffUserParams are properly initialized before
    freed.
  + BUG 6263: Fix domain logins for WinXP clients pre SP3.
  + BUG 6286: Call init function for builtin idmap modules before probing for
  them as shared modules.
  + BUG 6243: Fix usrmgr.exe creating a user.
  + net conf: Save share name as given, not as lower case only.
  + Prevent creation of registry keys containing the '/' character.
  + Allow pdbedit to change a user rid/sid.
  + When doing a cli_ulogoff don't invalidate the cnum, invalidate the vuid.
  + Don't access a freed structure when logging off and re-using a vuid.
  + Try to to fix password_expired flag handling.
  + Make sure to grey out change fields in the netdomjoin-gui when not
    running as root.
  + Don't look up local user for remote changes, even when root.
  + Use procid_str in debug messages for better cluster-debuggability.
  + Use cluster-aware procid_is_me instead of comparing pids.
  + Fix smbd crash for close_on_completion.
  + Fix a memleak in an unlikely error path in change_notify_create().
  + Do not use the file system GET_REAL_FILENAME for mangled names.
  + Fix a crash bug if we timeout in net rpc trustdom list.
  + Add '--request-timeout' option to net.
  + In net_conf_import, start a transaction when importing a single share.
  + Fix writing of roaming profiles with "profile acls" set to "yes".
* Fri Apr 17 2009 lmuelle@suse.de
- Update to 3.2.11.
  + Fix domain logins for WinXP clients pre SP3 (bug #6263).
  + Fix samr_OpenDomain access checks (bug #6089).
  + Fix smbd crash for close_on_completion.
  + BUG 6089: Fix samr_OpenDomain access checks.
  + BUG 6205: Correct sample smb.conf share configuration.
  + BUG 6254: Fix IPv6 PUT/GET errors to an SMB server (3.3) with
    "msdfs root" set to "yes".
  + BUG 6263: Fix domain logins for WinXP clients pre SP3.
  + Allow pdbedit to change a user rid/sid.
  + When doing a cli_ulogoff don't invalidate the cnum, invalidate the vuid.
  + Fix resume command typo for "printing = vlp".
  + Fix smbd crash for close_on_completion.
  + Fix a memleak in an unlikely error path in change_notify_create().
  + Don't look up local user for remote changes, even when root.
* Fri Apr 17 2009 jmcdonough@suse.de
- Don't lookup local user for remote password changes; (bnc#493507).
* Thu Apr  2 2009 lmuelle@suse.de
- Update to 3.3.3.
  + Migrating from 3.0.x to 3.3.x can fail to update passdb.tdb
    correctly (bug #6195).
  + Fix serving of files with colons to CIFS/VFS client (bug #6196).
  + Fix "map readonly" (bug #6186).
  + BUG 6195: Don't let smbd child processes panic.
  + Add backend_requires_messaging() method to libsmbconf.
  + Add methods is_writeable() and wrapper smbconf_is_writeable() to libsmbconf.
  + Fall back to file backend when no valid backend was found.
  + Fix a memleak in dbwrap_rbt.
  + Provide transaction_start|commit|cancel fns for the registry tdb.
  + Speed up "net conf drop".
  + Speed up "net conf import".
  + Add transactions to the libsmbconf API.
  + Reduce memory usage of "net conf import".
  + Registry cleanup.
  + Fix handling of SAMBA_VERSION_VENDOR_PATCH.
  + Fix build of pam_winbind.so with static linking.
  + Tidy up some convert_string_internal error cases.
  + BUG 6224: nmbd waits 5 minutes at startup before checking if it needs to
    run elections.
  + Allow DFS client paths to work when POSIX pathnames have been selected.
  + Try and fix the build farm RAW-STREAMS errors.
  + Ensure files starting with multiple dots are hidden.
  + BUG 6102: NetQueryDisplayInformation could return wrong information.
  + BUG 6193: Avoid messing with sync_context in libnet_samsync_delta().
  + Fix notify_printer_status_byname.
  + Fix Coverity IDs 722, 762, 774, 775, 776.
  + Fix build on old Heimdal based systems.
  + Fix compile warning.
  + Use parentheses in if condition to make negation clear.
  + Add dirsort module.
  + BUG 6147: Fix detection of the GNU ld version.
  + BUG 6097: Fix smbd segfault.
  + BUG 6130: Don't crash in winbindd_rpc lookup_groupmem() on unmapped
    members.
  + BUG 6139: Add missing whitespace in mount.cifs error message.
  + Fix a malloc/talloc mismatch when cli_initialise() fails.
  + Fix a valgrind error.
  + Speed up "net conf list".
  + Add sorted subkey cache.
  + Use StrCaseCmp in the dirsort module.
  + Document the dirsort module.
  + Disable dns_sd by default.
  + Add avahi detection to configure.
  + Add event avahi binding.
  + Use avahi to register _smb._tcp in smbd.
  + Fix two memleaks in the encryption code.
  + Fix a scary "fill_share_mode_lock failed" message.
  + BUG 6228: Fix SMBC_open_ctx failure due to path resolve failure doesn't set
    errno.
  + Don't use reserved words in smbconftort.
  + Fix smb signing for fragmented trans/trans2/nttrans requests.
  + Parse_packet can return NULL which is then dereferenced in
    match_mailslot_name.
  + Format the header check for netinet/ip.h more nicely.
  + Missing break in conversion function prevents tdb password database
    update.
* Wed Apr  1 2009 jmcdonough@suse.de
- Update to 3.2.10.
  + BUG #6195: Don't let smbd child processes panic.
* Wed Apr  1 2009 jmcdonough@suse.de
- BUG 6195: Fix crash on passdb conversion.
* Tue Mar 31 2009 jmcdonough@suse.de
- Update to 3.2.9.
  + BUG 5920: The length of the memcpy was calculated wrong.
  + BUG 6097: Fix smbd segfault.
  + BUG 6098: Fix ads_find_dc() with "security = domain" when the DNS
    server is invalid.
  + BUG 6099: Samba returns incurrate capabilities list.
  + BUG 6100: Implement _netr_LogonGetCapabilities() with
    NT_STATUS_NOT_IMPLEMENTED.
  + BUG 6102: NetQueryDisplayInformation could return wrong information.
  + BUG 6130: Fix crash in winbindd_rpc lookup_groupmem() on unmapped
    members.
  + BUG 6133: Cannot delete non-ACL files on NFSv4 ACL filesystem.
  + BUG 6161: smbclient corrupts source path in tar mode.
  + BUG 6193: Avoid messing with sync_context in fetch_database_to_ldif().
  + BUG 6196: Unable to serve files with colons to Linux CIFS/VFS client.
  + BUG 6224: nmbd waits 5 minutes before checking to run elections.
  + BUG 6228: Fix SMBC_open_ctx failure when path failure doesn't set errno.
  + Numerous Coverity fixes
  + Fix double free caused by incorrect talloc_steal usage.
  + Backport delete semantics of alternate data streams on a file truncate.
  + Allow set attributes on a stream fnum to redirect to the base filename.
  + Fix use of streams modules with CIFSFS client.
  + Fix more POSIX path lstat calls.
  + Allow DFS client paths to work with POSIX pathnames.
  + Ensure files starting with multiple dots are hidden.
  + Fix guest auth when Winbind is running.
  + Fix memleak in get_remote_printer_publishing_data().
  + cifs mount fix for handling -V parameter.
  + Fix guest mounts.
  + Clean-up entries in /etc/mtab after unmount.
  + Add fakemount (-f) and nomtab (-n) flags to mount.cifs.
  + Enable total anonymization in vfs_smb_traffic_analyzer.
  + Don't try and delete a default ACL from a file.
  + Fix remotely adding a share via MMC.
  + Fix resume handle for _samr_EnumDomainGroups.
  + Fix a buffer handling bug when adding lots of registry keys.
  + Fix a O(n^2) algorithm in regdb_fetch_keys().
  + Fix a valgrind error / segfault in dns_register_smbd().
  + Don't log NDR_PRINT_DEBUG at level 0, this always ends up in syslog.
  + Fix a malloc/talloc mismatch when cli_initialise() fails.
  + Fix two memleaks in the encryption code.
  + Fix "fill_share_mode_lock failed" message.
  + Add S-1-22-X-Y sids to the local token.
  + Fix smb signing for fragmented trans/trans2/nttrans requests.
  + Don't miss an absolute pathname as a kerberos keytab path.
  + Have nmbd check all available interfaces for WINS before failing.
  + Initialize the id_map status in idmap_ldap to avoid surprise.
* Sun Mar 15 2009 lmuelle@suse.de
- Obsolete change from 2008-03-05 by removing the needless examples cleanup.
* Sat Mar 14 2009 lmuelle@suse.de
- Update to 3.3.2.
  + Fix "force group" (bug #6155).
  + Fix saving of files on Samba share using MS Office 2007 (bug #6160).
  + Fix guest authentication in setups with "security = share" and "guest ok =
    yes" when Winbind is running.
  + Fix corruptions of source path in tar mode of smbclient (bug #6161).
  + BUG 6082: Fix renaming and deleting of directories using Windows clients.
  + BUG 6154: Make ZFS honor admin users.
  + BUG 6155: Fix "force group".
  + BUG 6160: Fix saving of files on Samba share using MS Office 2007.
  + BUG 6161: Fix corruptions of source path in tar mode of smbclient.
  + Fix some NetBSD warnings.
  + Fix bug in processing of open modes in POSIX open.
  + Fix use of streams modules with CIFSFS client.
  + Ensure ACL modules work with POSIX paths.
  + Use fsp->posix_open in preference if we have it.
  + Fix more POSIX path lstat calls.
  + Fix a bug in message handling for the change notify code.
  + Fix guest authentication in setups with "security = share" and "guest ok =
    yes" when Winbind is running.
  + BUG 4640: Fix guest mounts in mount.cifs.
  + Fix displaying the version string properly when no other parameters passed
    in in mount.cifs.
  + Prefer gssapi header files from subdirectory.
  + BUG 6176: winbindd -n should disable the winbind idmap cache.
  + Add a vfs_preopen module to hide fs latencies.
  + Don't log NDR_PRINT_DEBUG at level 0, this always ends up in syslog.
  + Fix a valgrind error / segfault in dns_register_smbd().
  + Fix build on SLES8.
  + Decremented by 1 for ntcancel requests.
  + Fix creation of core files.
  + Fix first mapping of uids/gids in Winbind.
  + Initialize the id_map status in idmap_ldap to avoid surprise.
  + Fix initialization of idmap status.
* Tue Mar 10 2009 lmuelle@suse.de
- Only call '%%find_lang pam_winbind' in the samba spec file, not samba-doc.
* Thu Mar  5 2009 ro@suse.de
- Ignore return value from subshell to fix build.
* Wed Feb 25 2009 boyang@suse.de
- Make libsmbclient work with DFS, backported from 3.3; (bnc#475995).
* Tue Feb 24 2009 lmuelle@suse.de
- Update to 3.3.1.
  + Fix net ads join when "ldap ssl = start tls" (bug #6073).
  + Fix renaming/deleting of files using Windows clients (bug #6082).
  + Fix renaming/deleting a "not matching/resolving" symlink (bug #6090).
  + Fix remotely adding a share via the Windows MMC.
  + BUG 6082: Fix renaming/deleting of files using Windows clients.
  + BUG 6069: Fix build with too many arguments.
  + BUG 6090: Fix renaming/deleting a "not matching/resolving" symlink.
  + BUG 6099: Try to fix domain join of Win7 Beta.
  + BUG 6117: Fix core dump of pdbedit -a.
  + BUG 6133: Fix deletion of non-ACL files on Solaris/ZFS/NFSv4 ACL
    filesystem.
  + Fix Coverity IDs 115, 116, 117, 602.
  + Fix warning (bad handler prototype).
  + Unify the detection of the timespec code in configure.in, and the
    application of it in time.c.
  + Correctly use chroot().
  + Parameterize in local.h the MAX_RPC_DATA_SIZE, and ensure that "offered"
    read from the rpc packet in spoolss is under that size.
  + Backport the semantics of when to delete alternate data streams on a file
    truncate.
  + Fix printf warnings.
  + BUG 6073: Prevent ads_connect() from using SSL unless explicitly
    requested.
  + Fix 'getent passwd' to allocate new uids.
  + Fix 'getent group' to allocate new gids.
  + Remove check for sharename being a username in 'net conf addshare'.
  + Fix Coverity ID 848.
  + Remove unused ENUM_HND from 'net'.
  + Fix getform command asprintf return code in rpcclient.
  + Fix memleak in get_remote_printer_publishing_data().
  + Remove duplicate prototypes for generated rpc server functions.
  + Enable total anonymization in vfs_smb_traffic_analyzer.
  + Fix build with external dns_sd libraries.
  + Fix configure check "sub-second timestamps without struct timespec".
  + Use correct BSD evironment variable.
  + Don't try and delete a default ACL from a file.
  + BUG 5798: CFLAGS info lost in configure.
  + Fix Coverity IDs 740, 742, 744, 745, 876, 879, 880.
  + Fix remotely adding a share via the Windows MMC.
  + Avoid valgrind errors.
  + Fix 'net rpc join' for users with the SeMachineAccountPrivilege.
  + Fix resume handle for _samr_EnumDomainGroups.
  + Fix a buffer handling bug when adding lots of registry keys.
  + Fix a O(n^2) algorithm in regdb_fetch_keys().
  + Initialize rc to 0 in main in mount.cifs.
  + BUG 6069: Add a fstatvfs function for libsmbclient.
  + Eliminate compiler warnings.
  + Don't miss an absolute pathname as a kerberos keytab path.
  + BUG 6100: Implement _netr_LogonGetCapabilities() with
    NT_STATUS_NOT_IMPLEMENTED.
  + Make Samba work with older ctdb versions.
  + Add S-1-22-X-Y sids to the local token.
  + Conditional install of the cifs.upcall man page.
  + Adjust regex to match variable names including underscores.
  + BUG 4370: Clean-up entries in /etc/mtab after unmount.
  + Add fakemount (-f) and nomtab (-n) flags to mount.cifs.
  + Fix a crash during name resolution.
  + Fix "assignment discards qualifiers from pointer target type" warnings.
  + Fix SMB_VFS_RECVFILE/SENDFILE macros.
  + Change "ldap ssl:ads" parameter to "ldap ssl ads".
  + Add manpages for vfs_acl_xattr and vfs_acl_tdb.
  + Fix double free caused by incorrect talloc_steal usage.
  + Build ldbrename.
  + Make nmbd check all available interfaces for WINS before failing.
  + Fix compilation of vfs_default on systems that do not support utimes().
  + BUG 5920: Fix the calculation of the memcpy length.
  + BUG 6098: Fix ads_find_dc() in setups with "security = domain".
  + Make libsmbclient work with DFS.
* Mon Feb 23 2009 hhetter@suse.de
- Define init_samba_module in all samba-vscan modules; (bnc#469218).
* Sat Feb 21 2009 lmuelle@suse.de
- Add GPLv3 header to all init scripts; (bnc#459766).
* Tue Feb 10 2009 boyang@suse.de
- Backport of the clean event context after fork and krb5 refresh chain
  fixes; (bnc#415026).
* Mon Feb  9 2009 jmcdonough@suse.de
- Revert accidental partial strict allocate upstream commit
* Sun Feb  8 2009 jmcdonough@suse.de
- Update to 3.2.8.
  + Fix and streamline join and DC detection
  + BUG 4308: Excel save operation corrupts file ACLs.
  + BUG 5933: Fix incrementing/decrementing num_validated_vuids.
  + BUG 5953: Fix smbclient crashes.
  + BUG 5953: Make cli_send_smb_direct_writeX use writev.
  + BUG 5965: Fix creation of the first share using SWAT.
  + BUG 5969: Optimize smbclient put command.
  + BUG 5979: Fix level 2 oplocks.
  + BUG 5980: Fix race condition when granting level2 oplocks
  + BUG 5986: Fix renaming of streams.
  + BUG 5990: Strict allocate should be checked before ftruncate.
  + BUG 6000: Avoid bashism in perfcount.init.
  + BUG 6009: Setting "min receivefile size = 1" breaks writes.
  + BUG 6014: mget shouldn't segfault without arguments.
  + BUG 6016: Alternate Data Streams / Extended Attributes seem to conflict.
  + BUG 6017: Fix magic scripts.
  + BUG 6021: smbclient du command does not recuse properly.
  + BUG 6030: Add missing <th> header in Status page.
  + BUG 6035: Fix possible race between fcntl F_SETLKW and alarm delivery.
  + BUG 6040: Calling Samba print server with an aliased DNS-name fails.
  + BUG 6058: Use 'make distclean' instead of 'make clean' in build_docs.
  + Fix "allow trusted domain" so it disables trusted domains.
  + Fix error code when smbclient puts a file over an existing directory.
  + Don't return 0 on error in smbcacls - bad for scripts.
  + Determine case sensitivity based on file system attributes.
  + Add vfs_fileid manpage.
  + Adjust regex to match variable names including underscores.
  + Fix stream marshalling to return the correct streaminfo status.
  + Fix a delete on close divergence from Windows.
  + Allow renames of streams via NTRENAME and fix stream error codes.
  + Fix a segfault if ? is there but the options are NULL.
  + Avoid flooding of syslog with failing pam_putenv messages.
  + Document default of the printing config variable.
  + Change default value for "ldap ssl" to "start tls".
  + Check if Unix account exists before asking for the password in smbpasswd.
  + Add manpage for vfs_shadow_copy2.
  + Clean event context after child is forked.
  + Refresh sequence number as soon as possible.
  + Don't set child->requests to NULL in parent after fork.
  + Clean event context after fork and fix krb5 refresh chain.
  + Fix null pointer refrence in event context.
  + Don't send message to any other child in child process.
  + Fix bug in get_dc_name_via_netlogon(), null pointer refrence.
* Tue Feb  3 2009 jmcdonough@suse.de
- Backport 3.2.8 fixes.
  + cups leaks and crashes
  + various winbind child handling fixes
  + join fixes
  + ACL fixes for Excel
  + allow usrmgr with non-root
* Mon Feb  2 2009 lmuelle@suse.de
- Replace cifs.upcall Makefile patches by the upstream version.
* Wed Jan 28 2009 lmuelle@suse.de
- Only add ccache to BuildRequires if it is used.
* Tue Jan 27 2009 lmuelle@suse.de
- Update to 3.3.0.
  + The passdb tdbsam version has been raised.
  + Splitting of library directory into library directory and separate modules
    directory.
  + The default value of "ldap ssl" has been changed to "start tls".
  + Extended Cluster support.
  + New experimental VFS modules "vfs_acl_xattr" and "vfs_acl_tdb" to store
    NTFS ACLs on Samba file servers.
  + Simplified idmap configuration.
  + New idmap backends "adex" and "hash".
  + Added new parameter "winbind reconnect delay".
  + Added support for user and group aliasing.
  + Added support for multiple domains to idmap_ad.
  + The destination "all" of smbcontrol does now affect all running daemons
    including nmbd and winbindd.
  + New 'net rpc vampire keytab' and 'net rpc vampire ldif' commands.
  + The 'net' utility can now use kerberos for joining and authentication.
  + The 'wbinfo' utility can now add, modify and remove identity mapping
    entries.
  + NetApi library implements various new calls for User- and Group Account
    Management.
  + libsmbclient does now determine case sensitivity based on file system
    attributes.
* Fri Jan 23 2009 anschneider@suse.de
- Replace all chkconfig calls with rc_active calls to improve performance
  during boot.
* Fri Jan 23 2009 anschneider@suse.de
- Add SuSEfirewall2 service config file to allow samba browsing on
  post-10.2 systems; (bnc#460902).
* Tue Jan 20 2009 lmuelle@suse.de
- Update to 3.0.34.
  + Fix update of machine account passwords.
  + Fix SMB signing issue on Windows Vista with MS Hotfix KB955302.
  + Fix Winbind crashes.
  + Correctly detect if the current dc is the closest one.
  + Add saf_join_store() function to memorize the dc used at join time.  This
    avoids problems caused by replication delays shortly after domain joins.
  + Fix write list in setups using "security = share".
* Wed Jan  7 2009 olh@suse.de
- Obsolete old -XXbit packages; (bnc#437293).
* Mon Jan  5 2009 lmuelle@suse.de
- Update to 3.2.7.
  + Samba 3.2.0 to 3.2.6 can potentially give root filesystem access
    to older versions of smbclient; CVE-2009-0022; (bnc#460764).
* Sat Dec 27 2008 jmcdonough@suse.de
- Samba 3.2.0 to 3.2.6 can potentially give root filesystem access
  to older versions of smbclient; CVE-2009-0022; (bnc#460764).
* Thu Dec 25 2008 boyang@suse.de
- Fix nmbstatus dipslay when workgroup parameter is given; (bnc#459785).
* Thu Dec 25 2008 boyang@suse.de
- Fix Mounting failure when there is white spaces in service; (bnc#460793).
* Mon Dec 15 2008 anschneider@suse.de
- Update to 3.3.0rc2.
  + Splitting of library directory into library directory and separate
  modules directory.
  + Extended Cluster support.
  + Simplified idmap configuration.
  + New idmap backends "adex" and "hash".
  + Added new parameter "winbind reconnect delay".
  + Added support for user and group aliasing.
  + Added support for multiple domains to idmap_ad.
  + The destination "all" of smbcontrol does now affect all running
  daemons including nmbd and winbindd.
  + New 'net rpc vampire keytab' and 'net rpc vampire ldif' commands.
  + The 'net' utility can now use kerberos for joining and authentication.
  + The 'wbinfo' utility can now add, modify and remove identity mapping entries.
  + NetApi library implements various new calls for User- and Group
  Account Management.
* Fri Dec 12 2008 lmuelle@suse.de
- Fix all remaining conditional macro calls; (bnc#456469).
* Fri Dec 12 2008 anschneider@suse.de
- Add IPv6 support for mount.cifs.
* Wed Dec 10 2008 lmuelle@suse.de
- Update to 3.2.6.
  + Fix potential segfault in vfs_tsmsm.
  + Don't list the domain twice when expanding internal aliases.
  + Fix the output of "getent group" when "winbind use default domain = yes"
    with "security = ads".
  + Add domain prefix to username in lookup_groupmem().
  + Prevent negative GM/ cache entries due to broken connections.
  + Fix crash in sync_eventlog_params().
  + Fix timeouts when calling 'getgrent'.
  + BUG 1254: Fix "write list" in setups using "security = share".
  + BUG 5080: Fix access to cups-printers with cups 1.3.4.
  + BUG 5737: Fix Winbind crash in an unusual failure mode.
  + BUG 5783: Fix FindFirst where search pattern equals the mangled filename.
  + BUG 5790: Fix returning of STATUS_OBJECT_NAME_NOT_FOUND on set file
    disposition.
  + BUG 5797: Fix moving of readonly files.
  + BUG 5814: Fix Winbind crash bug while doing "rescan_trusted_domain".
  + BUG 5818: Sort ACEs in smbcacl output properly and honor inheritance.
  + BUG 5825: Fix account locking with LDAP backend.
  + BUG 5826: Fix truncated filenames when accessing old servers.
  + BUG 5889: Fix "delete veto files = no".
  + BUG 5891: Fix smbd crash when viewing the eventlog exported by "eventlog
    list".
  + BUG 5900: Fix vfs_readonly.
  + BUG 5903: Fix vfs_streams_xattr breaking contents of files.
  + BUG 5904: Fix libnss_wins causing SIGABRT while servicing getaddrinfo()
    request.
  + BUG 5914: Fix build failure: redefinition of struct name_list.
  + BUG 5937: Fix filenames with "*" char hiding other files.
  + BUG 5953: Fix smbclient crashes.
  + Fix rename_open_files.
  + Restructure VFS SMB traffic analyzer VFS module.
  + Correctly fix smbclient to terminate on eof from server.
  + Unify access checks for lsa server functions.
  + Remove the requirement for ldap call made as root.
  + Cope with MAXIMUM_ALLOWED_ACCESS requests when opening handles.
  + Fix net rpc vampire, based on an *amazing* piece of debugging work by
    "Cooper S. Blake" <the_analogkid@yahoo.com>.
  + Fix Coverity IDs 456, 574, 592, 606 and 607.
  + Fix net rpc vampire.
  + Use the same prerequisite for DDNS update as Windows XP.
  + Make "lwinet ads dns register" honor the "interfaces" parameter.
  + Fix extended DN parse error when AD object does not have a SID.
  + BUG 5888: Fix PNP_GetHwProfInfo().
  + BUG 5957: Do not abort rename process on valid rename script.
  + BUG 5898: Fix 'net rpc shutdown'.
  + Fix duplicate installation of cifs.upcall.
  + Fix _srvsvc_NetShareAdd segfault.
  + Ensure consistency when reporting password complexity.
  + Fix _lsa_GetUserName.
  + Fix access check in _samr_QuerySecurity().
  + _samr_DeleteUser needs to wipe out the user_handle on success.
  + NetGroupEnum_r needs to handle servers with no groups.
  + Search for gpfs functions in both libgpfs_gpl.so an libgpfs.so.
  + BUG 5908: Fix internal change notify on shared directory.
  + BUG 5135 and 5446: Prevent calling POSIX ACL vfs methods on zfs share.
  + BUG 5929: Fix building of vfs_prealloc with option --with-cluster-support
    and GPFS.
  + Add new VFS module to analyze SMB traffic
  + BUG 5928: Fix 'testparm --version'.
  + Have uppercase_string return success on NULL pointer in mount.cifs.
  + Make mount.cifs return codes match the return codes for /bin/mount.
  + Use lock/unlock_mtab scheme from util-linux-ng mount prog in mount.cifs.
  + BUG 5778: Check if strlcpy and strlcat are already defined.
  + BUG 5840: Fix segfault in "rpcclient lsaaddacctrights".
  + BUG 5860: Fix nasty error message for overlong strings in safe_strcpy.
  + Fix a potential NULL deref in found by the IBM Checker.
  + Fix an uninitialized variable found by the IBM Checker.
  + Fix an unlikely memleak found by the IBM Checker.
  + Fix some missing error handlings.
  + Add workaround for domain joins using a netbios name which is different
    from the hostname.
  + Fix crash bug when freeing a non-malloc'ed buffer if the client sends a
    non-encrypted packet with the crypto state set.
  + Fix trans2findfirst for the large directory optimization.
  + Fix checking for presence of cups-devel and correct cups-devel test for
    HAVE_IPRINT.
  + BUG 5805: Don't close stdout when calling setup_logging multiple times.
  + Fix setting of trust password using 'net rpc trustdom add'.
  + Fix several issues in vfs_streams_xattr and vfs_stream_depot.
  + Return an error instead of crashing when no realm is given (trigerred by
    "net ads info -S 127.8.7.6" (where 127.8.7.6 doesn't exist) and
  "disable netbios = yes").
  + Fix the new vfs_smb_traffic_analyzer build for static links.
  + BUG 5901: Fix default for streams_depot location.
  + Fix several build warnings.
  + Delete the krb5 ccname variable from the PAM environment if set.
  + Fix circular dependency error with autoconf 2.6.3.
  + Add @CIFSUPCALL_PROGS@ to "all" target so cifs.upcall gets built at
    compile time rather than install time.
  + BUG 5906: Fix Winbind crash when calling 'getent group'.
  + Fix logging to syslog.
  + Allow SYSLOG_FACILITY to be modified with a new configure option called
  - -with-syslog-facility.
  + BUG 5909: Fix MS-DFS on Vista clients.
  + BUG 5944: Fix starting of nmbd with "socket address" set to "".
  + Fix segfault on startup with trusted domains.
  + Re-add "winbind:ignore domains" parameter.
  + Avoid freeing fsp twice when opening new_file fails (Debian #431696).
* Wed Dec 10 2008 anschneider@suse.de
- Fix the conditional macro to start smbfs by default; (bnc#456469).
* Wed Dec  3 2008 anschneider@suse.de
- Readd libsmbclient to baselibs.conf for pre 11.0 distributions.
* Wed Dec  3 2008 anschneider@suse.de
- Use %%__install macro to install files with the right permissions
  instead of cp.
* Mon Dec  1 2008 anschneider@suse.de
- Update to 3.3.0rc1.
  + Splitting of library directory into library directory and separate
  modules directory.
  + Extended Cluster support.
  + Simplified idmap configuration.
  + New idmap backends "adex" and "hash".
  + Added new parameter "winbind reconnect delay".
  + Added support for user and group aliasing.
  + The destination "all" of smbcontrol does now affect all running
  daemons including nmbd and winbindd.
  + New 'net rpc vampire keytab' and 'net rpc vampire ldif' commands.
  + The 'net' utility can now use kerberos for joining and authentication.
  + The 'wbinfo' utility can now add, modify and remove identity mapping
  entries.
  + NetApi library implements various new calls for User- and Group
  Account Management.
- Added German translation for pam_winbind.
* Mon Dec  1 2008 boyang@suse.de
- Remove patch for bnc#336854, which doesn't exist in 3.2.x or higher.
* Sun Nov 30 2008 lmuelle@suse.de
- Use %%{NET_CFGDIR} define instead of a fixed path to the network conf.
* Sat Nov 29 2008 lmuelle@suse.de
- Update to 3.2.5.
  + Samba 3.0.29 to 3.2.4 can potentially leak arbitrary memory contents to
    malicious clients; CVE-2008-4314; (bnc#446971).
* Thu Nov 27 2008 ro@suse.de
- Update baselibs.conf.
* Thu Nov 27 2008 anschneider@suse.de
- Fix circular dependency error with autoconf 2.6.3.
* Thu Nov 27 2008 anschneider@suse.de
- Fix the dhcp hook script and support CODE11; (bnc#442335).
* Thu Nov 27 2008 anschneider@suse.de
- Fix perl v5.10 warnings in nmbstatus; (bnc#448225).
* Wed Nov 26 2008 sjayaraman@suse.de
- Include the missing spec file change mentioned the previous commit.
* Tue Nov 25 2008 sjayaraman@suse.de
- Make cifs-mount depend on keyutils, keyutils-libs packages as they
  are required to support dfs and kerberos; (bnc#432494).
* Thu Nov 20 2008 lmuelle@suse.de
- Fix the offset checks in the trans routines; CVE-2008-4314; (bnc#446971).
* Thu Nov 20 2008 hhetter@suse.de
- Change the runlevel description for winbindd to use
  "Microsoft Windows" instead of "NT"; (bnc#446154).
* Tue Nov 11 2008 boyang@suse.de
- Directory/Filenames get truncated when 3.2.0 client acesses old server;
  (bnc#432471).
* Thu Nov  6 2008 anschneider@suse.de
- Add SuSEfirewall2 services config file to open Netbios and Samba ports on
  post-10.2 systems; (bnc#247344).
* Wed Oct 29 2008 anschneider@suse.de
- Remove unrecognized configure options.
* Fri Oct 24 2008 anschneider@suse.de
- Fix the pam_winbind build.
* Tue Oct 21 2008 anschneider@suse.de
- Delete the krb5 ccname variable from the PAM environment if set.
* Thu Oct 16 2008 anschneider@suse.de
- Move the nss_info modules to the samba-winbind package.
* Thu Oct 16 2008 anschneider@suse.de
- Activate the idmap backends "adex" and "hash".
* Thu Oct 16 2008 anschneider@suse.de
- Add version branding for CODE 11.
* Wed Oct 15 2008 anschneider@suse.de
- Restart smbfs even with the traditional network setup; (bnc#425058).
* Fri Oct  3 2008 lmuelle@suse.de
- Only call the stop_on_removal, restart_on_update, or insserv_cleanup macro
  if available.
* Fri Oct  3 2008 lmuelle@suse.de
- Only call the fillup_and_insserv or fillup_only macro if available.
* Fri Oct  3 2008 lmuelle@suse.de
- Use package names instead of macros for cp, mkdir, mv, rm, and grep or
  instead of the full path to the binary for ln, find and xargs.
* Thu Oct  2 2008 lmuelle@suse.de
- Introduce NET_CFGDIR to fit the needs for a differing location of the
  network configuration per vendor.
* Thu Oct  2 2008 lmuelle@suse.de
- Use path macros for cp, mkdir, mv, rm, and grep.
* Thu Oct  2 2008 lmuelle@suse.de
- Only use SUSE rpm macros and SuSEconfig.permissions if available.
* Thu Oct  2 2008 lmuelle@suse.de
- Update to 3.3.0pre2.
  + BUG 5729: Explicitly allow "-valid".
  + BUG 5737: Fix winbindd crash in an unusual failure mode.
  + BUG 5751: Fix showing of ACLs on DFS in (lib)smbclient.
  + BUG 5762: Fix opening of mangled directory name (resulted 'is a stream
    name').
  + BUG 5783: Fix FindFirst where search pattern == mangled filename.
  + BUG 5790: Fix returning of STATUS_OBJECT_NAME_NOT_FOUND on set file
    disposition.
  + BUG 5797: Fix moving of readonly files.
  + Fix crashes when looking up a non-existant uid.
  + Fix getting/setting of NT ACLs on a file.
  + Fix the wcache_invalidate_samlogon calls.
  + Clarify usage of "force create mode".
  + Get smbd to look (read-only) into the winbindd cache for uid/gid <--> sid
    mappings.
  + Write times code update.
  + Add experimental version of VFS module acl_xattr.
  + Fix rename_open_files.
  + Make SMB traffic analyzer VFS module more efficient.
  + Fix segfault when calling nss_get_info() with a NULL ads structure.
  + Add support for name aliasing in Winbind.
  + Add the idmap/nss-info provider from Likewise Open.
  + Allow an admin to define the "uid" attribute for a RFC2307 user object in
    AD to be the username alias.
  + Add new idmap backend "adex" to support RFC2307 enabled AD forests.
  + Add new idmap backend "hash".
  + Fix build warnings.
  + Cleanup of DC enumeration in get_dcs().
  + BUG 5710: Fix changing of machine account passwords.
  + BUG 5784: Fix pam_winbind build issue on Solaris.
  + Fix invalid sid copy (hit when enumerating sibling domains) in Winbind.
  + Fix double installation of cifs.upcall.
  + Add change-user-password command to wbinfo.
  + Fix segfault in _srvsvc_NetShareAdd.
  + BUG 5736: Fix Winbind crash bug with trusted domains.
  + Correct the netsamlogon_clear_cached_user function.
  + Add new VFS module to analyze SMB traffic to record write and read
    operations on the Samba server.
  + Fix build warnings in cifs.upcall.
  + BUG 5707: Do proper error handling if the socket is closed.
  + BUG 5778: Don't define 'strlcat' and 'strlcpy' if it's already defined.
  + Fix Coverity IDs 587 and 589.
  + Increase the default positive idmap cache time to a week.
  + Fix calculation of useable_space for trans2 and nttrans replies.
  + Add mapping of generic bits when setting an NFSv4 ACL.
  + Some write time fixes.
  + Add new parameter "cups connection timeout".
  + Fix enumeration of nested group memberships in Winbind.  This affected
    only setups using "security = ads".
  + Fix cut and paste error in quota code.
  + Fix display of POSIX ACLs.
  + Fix permissions of group_mapping.ldb (CVE-2008-3789).
  + Avoid a race condition in glibc between AIO and setresuid().
  + Add missing become root for AIO operations.
  + Fix an errno handling bug that could lead to an infinite loop.
  + Fix logic of tsmsm_sendfile().
  + Fix handling of arbitrary new PAC types.
  + Fix segfault on startup with trusted domains.
  + Fix segfault on the CTDB destructor code.
  + Re-add "winbind:ignore domains".
  + BUG 5609: Remove configure option "--with-libdir" and add
    "--with-modulesdir".
  + Extend "net rpc vampire keytab" to support differential replication and
    storing of kerberos keys.
  + Rework internal logic of registry tdb code.
  + Freeze autogenerated prototype headers (good bye "make proto").
  + Add new "winbind reconnect delay" parameter.
  + Make the change to smbcontrol for "all" to mean broadcast, and "smbd" to
    mean the main smb daemon.
  + Allow an admin to define the "uid" attribute for a RFC2307 user object in
    AD to be the username alias.
  + Add "net rpc vampire keytab" and "net rpc vampire ldif".
  + Rework of the Winbind idmap backend.
* Wed Oct  1 2008 lmuelle@suse.de
- Define PAM_AUTHTOK_RECOVERY_ERR when not available on older Linux products.
* Mon Sep 29 2008 lmuelle@suse.de
- Adopt samba-vscan to build after the change to the bool type define.
* Mon Sep 22 2008 lmuelle@suse.de
- Build cifs.upcall for CentOS 5, Fedora 8 and RHEL 5 and newer too.
* Sat Sep 20 2008 lmuelle@suse.de
- Call mkinitrd_setup during %%post and %%postun for post-9.2 systems only.
* Thu Sep 18 2008 anschneider@suse.de
- Create a link to the html manpages so that they can be accesses in swat;
  (bnc#426182).
* Tue Sep  9 2008 jmcdonough@suse.de
- "Password last set" timestamp update from admin pw change; (bnc#420407).
* Wed Sep  3 2008 hare@suse.de
- Call mkinitrd_setup during %%post and %%postun for package cifs-mount;
  (bnc#413709).
* Wed Aug 27 2008 lmuelle@suse.de
- Update to 3.3.0pre1.
  + Splitting of library directory into library directory and separate modules
    directory.
  + Extended Cluster support.
  + Simplyfied idmap configuration.
  + Added new parameter "winbind reconnect delay".
  + The destination "all" of smbcontrol does now affect all running daemons
    including nmbd and winbindd.
  + New 'net rpc vampire keytab' and 'net rpc vampire ldif' commands.
* Tue Aug 19 2008 lmuelle@suse.de
- Update to 3.2.2.
  + BUG 5592: Fix creation and installation of shared libraries.
  + Fix replacement of random seed generator.
  + Fix a race condition in idmap_tdb2_allocate_id().
  + Fix unix_convert() for "*" after changing map_nt_error_from_unix().
  + Make sure to always set errno on error path in OpenDir.
  + BUG 5675: Fix smbspool program assuming Kerberos authentication by
    mistake.
  + BUG 5686: Fix segfaults in libsmbclient.
  + BUG 5692: Fix coredump in full_audit.so.
  + BUG 5696: Fix "force group" in setups using Winbind.
  + Rename cifs.spnego to cifs.upcall.
  + Fix segfault in cifs.upcall when it is called without any arguments.
  + Fix coverity ID 594 (resource leak on error path).
  + Fix assigning of primary group memberships when authenticating via
    Winbind.
  + BUG #5617: Fix freezing Windows Explorer on WinXP while browsing Samba
    shares.
  + Include stdlib.h to get a prototype for free().
  + Solve an IBM XL C/C++ compiler error encountered in get_exit_code()
    auth_errors array initialization in client/smbspool.c.
  + Use NGROUPS_MAX instead of 32 for the max group value in
    rep_initgroups().
  + Add add c++ guard to netapi.
  + Fix compile warning in cifs.upcall.
  + Add "dns_resolver" key type to cifs.upcall.
  + BUG 5688: Fix orphaned LPQ processes if socket address is invalid.
  + BUG 5684: Fix removal of dead records in tdb files.
  + Fix coverity IDs 595, 596.
  + Fix smb_len calculation for chained requests.
  + Fix output of test status.
  + Fix smbclient connections to older servers.
  + Fix a fd leak when trying to regain contact to a domain controller in
    Winbind.
  + Fix permissions on ctdb databases.
  + Fix passing back success when a function had in fact failed in two
    places.
- Add --enable-static to the configure options to get the statical libraries
  installed by the install Makefile target.
- Add --with-cifsupcall to build the cifs.upcall binary for post 10.2 systems.
* Thu Aug 14 2008 lmuelle@suse.de
- Set Required- and Should-Stop in the init info part of all init scripts.
* Thu Aug 14 2008 jmcdonough@suse.de
- Fix libsmbclient to older servers; (bnc#402776).
* Tue Aug  5 2008 lmuelle@suse.de
- Update to 3.2.1.
  + BUG 5594: Fix "make test" by adding and using a new testparm switch
    "--skip-logic-checks".
  + Fix creation of libaddns.a, libsmbclient.a and libsharemodes.a.
  + Update the section about net conf in the net(8) manpage.
  + Improve processing of registry shares.
  + Fix listing of registry shares with testparm.
  + Fix several build issues.
  + BUG 5578: Fix error from strlcat.
  + BUG 5613: Fix flushing of smb.conf when creating a new share using SWAT.
  + Ensure consistent use of pdb_get_nt_passwd instead of
    pdb_get_lanman_passwd.
  + Remove worrying warning message when safe_strcpy tries to copy a pseaudo
    interface name that's too long.
  + Canonicalize servername in the printer functions to remove leading '\\'
    characters.
  + Fix option processing in smbcacls - add POPT_COMMON_CONNECTION.
  + Fix bug creating files using DOS clients with mixed case files.
  + Fix uninitialized variable.
  + BUG 5616: Fix session keys also in rpccli_netr_LogonSamLogonEx wrapper.
  + BUG 5570: Fix bogus error message during AD domain join.
  + Fix trusted domain handling in Winbindd.
  + Fix build warning.
  + BUG 5202: Fix setting of ACEs for users/groups with write access in setups
    with 'dos filemode = yes'.
  + Re-activate 'acl group control' parameter and make it only apply to owning
    group.
  + Make ntimes function more like POSIX and allow NULL arg.
  + BUG 5512: Fix alignment problems on sparc.
  + BUG 5616: Fix share connections in setups with
    "server signing = mandatory" or SMB signing set on the client side.
  + Fix a race condition in Winbind leading to a crash.
  + Fix a segfault in base64_encode_data_blob.
  + Fix some uninitialized variable references via ndr_print.
  + Fix error message if trying to join with a non-privileged user.
  + Fix setups using "include = registry" without [global] settings in the
    registry.
  + Fix "net sam rights" on domain member servers.
  + Add documentation for the vfs streams modules.
  + Cleanup some duplicate code by passing the password to the wbinfo_auth*
    functions.
  + Allow SID with 0 in subauthority to be converted properly.
  + Set sin[6]_family instead of ss_family in in[6]_addr_to_sockaddr_storage.
  + Fix realpath() check so that it doesn't generate a core() when it fails.
  + Fix overwriting of winbind logfiles.
  + Fix "vfs_full_audit.c: name table not in sync with vfs.h" panic.
  + Add broadcasting of the debug message to all winbindd children.
  + BUG 5635: Fix updating of printer queues.
  + Release still reachable memory if the smbclient context is freed.
  + Remove trailing withespace from wbinfo -m which breaks gdm auth.
  + BUG 5540: Fix "set primary group script" user option substitution.
  + Fix regression in Winbindd offline mode.
  + Allow authentication and memory credential refresh after password
    change from gdm/xdm.
  + Allow %%u parameters for print job username.
* Tue Jul 29 2008 anschneider@suse.de
- Fix a race condition in winbind leading to a crash; (bnc#406623).
* Mon Jul 28 2008 anschneider@suse.de
- Use the configure option to enable debugging. This fixes the creation
  of the debuginfo and debugsource package.
* Sun Jul 27 2008 anschneider@suse.de
- Fix emptying the printing queue; (bnc#411493).
* Fri Jul 25 2008 anschneider@suse.de
- Remove trailing withespace from wbinfo -m which breaks gdm auth.
* Thu Jul 24 2008 anschneider@suse.de
- Add a recommendation to the samba and samba-winbind package to install
  logrotate for openSUSE 11.0 and later.
* Wed Jul 23 2008 hare@suse.de
- Include mkinitrd scriptlets.
* Mon Jul 21 2008 boyang@suse.de
- Allow %%u parameters for print job username - use advanced sub; (bnc#374389).
* Thu Jul 17 2008 lmuelle@suse.de
- Update to 3.0.31.
  + BUG 5504: Fix SIGTERM handling in Winbind children so that they do not
    remove the unix domain socket used to field client requests.
  + Split the winbindd_passdb backend into a 'builtin' and a 'sam' backend.
  + When allocating client buffers for large read/write - make sure we take
    account of the large read/write SMB headers as well as the buffer space.
  + Memory leak fixes in DC location code.
  + BUG 5533: Winbindd fails to cope correctly with a workgroup name
    containing a '.'
  + BUG 5555: Don't return NT_STATUS_PASSWORD_MUST_CHANGE error on machine
    account logon.
  + BUG 5551: smbd recursing back into winbindd from a winbindd call.
  + Fix usage message for "net rpc trustdom add".
  + Ensure consistent use of pdb_get_nt_passwd instead of pdb_get_lanman_passwd.
  + BUG 5578: Bad (non-Samba) use of strlcat gives error.
  + Canonicalize servername in the printer functions to remove leading '\\'
    characters.
  + Documentation build fixes.
  + [DOCS] Fix use of smbconfoption in samba.entities.
  + Return NULL in sitename_fetch() if gencache_init() fails.
  + Use machine account and machine password from our domain when contacting
    trusted domains.
  + SPNEGO SPN fix when contacting trusted domains.
  + BUG 5285: Fix libcap header mismatch.
  + Fix joining NT4 domains.
  + Don't let winbind getgroups crash when we have no gids in the token.
  + Fallback to level 24 pwd set while joining.
  + Fix joining w2k domains in "security = ads".
  + Fix pam_sm_chauthtok for storing modified cached creds.
  + BUG 5202: Re-activate "acl group control" parameter and make it only apply
    to owning group.
  + BUG 5531: Fix conversion of ns units when converting from nttime to
    timespec.
  + BUG 4974: Map NT_STATUS_OBJECT_PATH_NOT_FOUND to ENOENT in libsmbclient.
  + Fix a segfault in base64_encode_data_blob.
  + AIX build fixes.
  + ENODATA is not defined in freeBSD 4.6.2.
  + Don't reset password last set time just because the expired flag is set to
    0.
  + Fix usage message for 'net idmap dump'.
  + Miscellaneous man page fixes.
  + BUG 4203: Samba3-HOWTO: Add improvements/fixes submitted by Pete Boyd.
  + Fixes to man pages.
  + Add tdb file documentation.
  + Ensure that winbindd trusted domain children keep primary domain online
    status up to date.
  + Update cached creds during password change.
  + Ensure that Winbind always uses set_domain_offline() to mark a domain
    offline.
  + Allow authentication and memory credential refresh after password change
    from gdm/xdm.
  + Memory leak fixes.
* Tue Jul  8 2008 boyang@suse.de
- Allow authentication and memory credential refresh after password change
  from gdm/xdm; [bnc#395578].
* Fri Jul  4 2008 lmuelle@suse.de
- Add SMB_VFS_OP_RECVFILE to vfs_op_names to get it in sync with vfs.h.
* Wed Jul  2 2008 lmuelle@suse.de
- Call the libsmbclient testsuite from the %%check instead of the %%build
  script.
* Wed Jul  2 2008 boyang@suse.de
- Use machine account and machine password from our domain when
  contacting trusted domains; [bnc#404667].
* Tue Jul  1 2008 anschneider@suse.de
- Add a %%check section move the test of the PAM modules to this section
  and add more tests.
* Tue Jul  1 2008 anschneider@suse.de
- Add a recommendation to the samba and samba-winbind package to install
  cron for openSUSE 11.0 and later.
* Tue Jul  1 2008 anschneider@suse.de
- Use a variable for syslog and add missing $remote_fs dependency for
  Require-Start in the init information of the init scripts.
* Tue Jul  1 2008 lmuelle@suse.de
- Update to 3.2.0.
  + Support for establishing interdomain trust relationships with Windows
    2008.
  + All changes from the pre and rc releases as noted in here earlier.
* Tue Jul  1 2008 lmuelle@suse.de
- Move header files from the devel sub package to lib*-devel.
* Mon Jun 30 2008 schwab@suse.de
- Work around bad use of autoconf interna.
* Mon Jun 30 2008 anschneider@suse.de
- Build Samba with debug symbols to get working debuginfo packages.
* Thu Jun 26 2008 lmuelle@suse.de
- Add /etc/openldap to the file list and not only the schema directory.
* Wed Jun 25 2008 anschneider@suse.de
- Improve samba-winbindd and dhcpcd-hook-samba interface scripts for faster
  booting; [fate#304967], [fate#304965].
* Wed Jun 18 2008 anschneider@suse.de
- Move sysconfig variable DHCLIENT_MODIFY_SMB_CONF from Other to
  'Network/DHCP/DHCP client'; [bnc#400467].
* Wed Jun 11 2008 boyang@suse.de
- pam_winbind: Update cached creds during password change; [bnc#395578].
* Tue Jun 10 2008 lmuelle@suse.de
- Update to 3.2.0rc2.
  + BUG 5504: Fix behaviour of winbindd children receiving a SIGTERM.
  + BUG 5489: Split the winbindd_passdb backend into a 'builtin' and a 'sam'.
  + Make sure we take account of the large read/write SMB headers as well as
    the buffer space when allocating cli buffers for large read/write.
  + Fix tag as a goto target we were not reinitializing the array counts.
  + BUG 5451: Fix for using the correct machine domain when looking up trust
    credentials in our tdb.
  + Fix spnego SPN when contacting trusted domains.
  + BUG 5285: Fix libcap header mismatch.
  + Fix pam_sm_chauthtok for storing modified cached creds.
  + Fix joining issue in setups with "config backend = registry".
  + BUG 4544: Add new parameter 'ldap connection timeout' to prevent waiting
    for TCP connection timeouts if no LDAP server is available.
  + BUG 5502: Fix security=server.
  + Fix coverity IDs 552, 553, 570, 571, 572.
  + Shrink ldbtools.
  + Fix reset of password last set time just because the expired flag is set
    to 0.
  + Remove support for symbol versioning in shared libraries.
  + Fix autogen for autoconf 2.62.
  + BUG 5515: Fix empty input fields in SWAT.
  + BUG 5516: Fix saving of the config file in SWAT.
  + Fix winbindd trusted domain child not keeping primary domain online status
    up to date.
* Tue Jun 10 2008 boyang@suse.de
- pam_winbind: fix pam_sm_chauthtok for storing modified cached creds;
  [bnc#395578].
* Mon Jun  9 2008 jmcdonough@suse.de
- Don't reset "password last set time" when unlocking an autolocked
  account; [bnc#382111].
* Fri Jun  6 2008 jmcdonough@suse.de
- Fix winbind sigterm handling and make init script send sighup to
  all child winbind processes; [bnc#382027].
* Thu Jun  5 2008 boyang@suse.de
- Fix bug with winbindd trusted domain child not keeping primary domain
  online status up to date, merge to trunk from reversion 1801; [bnc#373560].
* Fri May 30 2008 jmcdonough@suse.de
- Make winbind children reopen logs on SIGHUP; [bnc#382027].
* Fri May 30 2008 lmuelle@suse.de
- Set only CONFIGDIR and LIBDIR while make everything and install.  No longer
  set CONFIGFILE, DRIVERFILE, LMHOSTSFILE, and SMB_PASSWD_FILE; [bnc#395877].
* Wed May 28 2008 lmuelle@suse.de
- Update to 3.0.30.
  + Fix for CVE-2008-1105.
  + Remove man pages for ldb tools not included in Samba 3.0.
* Wed May 28 2008 lmuelle@suse.de
- Fix vulnerability that allows for the execution of arbitrary code in smbd;
  CVE-2008-1105; SA30228; [#391168].
* Tue May 27 2008 coolo@suse.de
- Follow the rename of libtdb0 in baselibs.conf.
* Fri May 23 2008 lmuelle@suse.de
- Rename sub package libtdb0 to libtdb1.
* Fri May 23 2008 lmuelle@suse.de
- Update to 3.2.0rc1.
  + Move the posix pending close functionality down into the VFS layer.
  + Fix activation of registry globals in loadparm.
  + BUG 5452: Fix smbclient put.
  + BUG 5434: Ensure the loaded password doesn't contain the '\n' at the end.
  + BUG 5456: Fix missing echo if we ^C at the prompt.
  + BUG 5464: Fix timeout in winbindd.
  + Fix returning a directory value for a QPATHINFO on a msdfs link with a
    non-dfs path.
  + Use more error-prone form of testing dm_destroy_session() return code.
  + BUG 5453: Fix winbindd and smbd crash when dsgetdcname is used.
  + BUG 5465: Fix joining with createcomputer=ou1/ou2/ou3.
  + BUG 5461: Fix issue with Citrix on Samba DCs with more than 900 groups.
  + Fix wins null pointer crash in nss_wins module.
  + Fix lm session key length in _netr_LogonSamLogon.
  + Add -f switch for DsGetDCName() example and be more verbose on output.
  + BUG 5429: Clarify log msgs re: failure to create
    BUILTIN\{Administrators,Users}
  + Fix the DNS Update option of "net ads join".
  + BUG 5184: Add Missing HAVE_UPDWTMPX check before using updwtmpx().
  + Recognize and allow longer UA keys in winbindd_cache.
  + BUG 5436: Fix signing problem in the client with transs requests.
  + Fix a valgrind bug in the new [ug]id2sid cache.
  + Fix Coverity IDs 565 and 222.
  + Fix dfs_Enum: In form_junctions, correctly check for malloc failure.
  + Add support for symbol versioning in shared libraries (can be disabled with
  - -disable-sysmbol-versioning).
  + Add new function wbcLibraryDetails() to libwbclient.
  + Cleanup size_t return values in convert_string_allocate.
  + Fix Kerberos support for CUPS 1.3 in smbspool.
  + Fix printing with Vista.
  + Fix deletion of files when they're in use by other drivers.
* Fri May 23 2008 lmuelle@suse.de
- Update to 3.0.29.
  + Fix a crash in tdb_wrap_log().
  + BUG 5267: Fix for nmbd termination problems when no interfaces found.
  + BUG 5326: OS/2 servers give strange "high word" replies for print jobs.
  + Remove MS-DFS check that required the target host be ourself.
  + BUG 5372: Fix high CPU usage of cupsd on large print servers by using more
    efficient CUPS queries in smbd.
  + BUG 5095: Fix the enforcement of the "Manage Documents" access right.
  + BUG 5460: Fix MS-DFS referral problem in server code.
  + Fix bug in Winbind that caused the parent to ignore dead children.
  + BUG 4235: Improve compliance to the Squid helper protocol.  Original patch
    from Pawel Worach <pawel.worach@gmail.com>.
  + Prevent cycle in Wibind's list of children when reaping dead processes.
  + BUG 5419: Fix memory leak in ads_do_search_all_args() (merge from v3-2).
  + Fix winbind NETLOGON credential chain on a samba dc for w2k8 trusts.
  + Fix client connections and negotiation with Windows 2008 DCs in member
    server code.
  + Add NT_STATUS_DOWNGRADE_DETECTED error code (merge from v3-2).
  + BUG 5430: Fix pam_winbind.so on Solaris (requires -lsocket).
  + Re-add samr getdispinfoindex parsing which got lost in the glue commit.
  + BUG 5461: Implement a very basic _samr_GetDisplayEnumerationIndex().
    Corrects interop problem between Citrix PM and a Samba DC.
  + BUG 3840: Fix smbclient connecting to NetApp filers when using whitespace
    in the user's password.
  + BUG 4901: Fix behavior of "ldap passwd sync = only".
  + BUG 5317: Fix debug output from domain_client_validate().
  + BUG 5338: Fix format string bug in rpcclient.
  + Ensure that "wbinfo -a trusted\\user%%password" works correctly on a Samba
    DC with trusts.
  + BUG 5336: Fix SetUsetrInfo(level 25) to update the pwdLastSet attribute.
  + BUG 5350: Fallback to anonymous sessions if not trust password could be
    obtained on Samba DCs and member servers.
  + Fix signing problem in the client with trans requests.
  + Enable winbind child processes to do something with signals, in particular
    closing and reopening logs on SIGHUP.
  + Add implementation of machine-authenticated connection to netlogon pipe
    used when connecting to win2k and newer domain controllers.
  + Fix trusted users on a DC that uses the old idmap syntax.
  + Only have Winbind cache domain password policies that were successfully
    retrieved.
  + Fix alignment bug when marshalling printer data replies.
  + Fix DeleteDriverDriverEx() checks to prevent removing in use files.
* Sat May 17 2008 lmuelle@suse.de
- Expand baselibs.conf to match pre SUSE 11.0 products.
* Fri May 16 2008 lmuelle@suse.de
- Remove obsoletes and provides <package>3 for all packages and systems.
* Fri May 16 2008 lmuelle@suse.de
- Cleanup the use of the suse_version macro to achieve consistent defaults.
* Fri May 16 2008 lmuelle@suse.de
- Set CODEPAGEDIR while make to fit the install location.
* Fri May 16 2008 hhetter@suse.de
- Prevent errors during the cache validation when ua keys reach a size larger
  than 1024; [bnc#372558].
* Wed May 14 2008 lmuelle@suse.de
- Package man page files independent of the used compression method (gz,lzma).
* Wed May 14 2008 lmuelle@suse.de
- Rewrite spec file to build packages for Fedora, Redhat, CentOS, and Mandriva
  in the OBS too.
* Wed May 14 2008 anschneider@suse.de
- Add a script to restart smbfs if NetworkMangaer gets an IP address;
  [bnc#373075].
* Tue May 13 2008 lmuelle@suse.de
- Remove all references to the obsoleted samba-pdb package.
* Fri May  9 2008 lmuelle@suse.de
- Compose the BuildRequires in a more flexible way to fit the openSUSE build
  service (OBS) requirements to support different operating system targets.
* Mon Apr 28 2008 lmuelle@suse.de
- Use _libdir macro instead of a local define of LIBDIR.
* Mon Apr 28 2008 lmuelle@suse.de
- Remove PreReq /sbin/ldconfig from the libtdb-devel package.
* Sat Apr 26 2008 lmuelle@suse.de
- Install the shared libraries with the same name as used as soname.
* Fri Apr 25 2008 lmuelle@suse.de
- Update to 3.2.0pre3.
  + Use of IDL generated parsing layer for several DCE/RPC interfaces.
  + Removal of the 1024 byte limit on pathnames and 256 byte limit on filename
    components to honor the MAX_PATH setting from the host OS.
  + Introduction of a registry based configuration system.
  + Improved CIFS Unix Extensions support.
  + Experimental support for file serving clusters.
  + Support for IPv6 in the server, and client tools and libraries.
  + Support for storing alternate data streams in xattrs.
  + Encrypted SMB transport in client tools and libraries, and server.
  + Support for Vista clients authenticating via Kerberos.
  + Full support for Windows 2003 cross-forest, transitive trusts and one-way
    domain trusts.
  + Support for userPrincipalName logons via pam_winbind and NSS lookups.
  + Expansion of nested domain groups via NSS calls.
  + Support for Active Directory LDAP Signing policy.
  + New LGPL Winbind client library (libwbclient.so).
  + New NetApi library for domain join related queries (libnetapi.so) and
    example GTK+ Domain join gui.
  + New client and server support for remotely joining and unjoining Domains.
  + Support for joining into Windows 2008 domains.
  + New ldb backend for local group mapping tables
  + Raised level of security defaults for authentication operations.
  + Inclusion of an HTML version of the 3rd edition of "Using Samba" from
    O'Reilly Publishing.
* Fri Apr 25 2008 lmuelle@suse.de
- Add libtalloc1, libtdb0, and libwbclient0 to baselibs.conf.
* Fri Apr 25 2008 lmuelle@suse.de
- Remove obsoletes and provides samba3 for post 10.3 systems.
* Fri Apr 25 2008 lmuelle@suse.de
- Let libsmbsharemodes-devel require libsmbsharemodes0 for post 10.3 systems.
* Wed Apr 23 2008 lmuelle@suse.de
- Rename the libsmbsharemodes package to libsmbsharemodes0 to follow the
  shared library packaging policy for post 10.3 systems.
* Tue Apr 22 2008 jmcdonough@suse.de
- Update kdc dns-only lookup patch to IPv6.
* Thu Apr 17 2008 lmuelle@suse.de
- Move mount.cifs and umount.cifs from /sbin/ to /usr/sbin/ and create sym
  links in /sbin/; [bnc#380693].
* Thu Apr 17 2008 anschneider@suse.de
- Enable the build of vfs_cacheprime and vfs_readahead modules.
* Mon Apr 14 2008 lmuelle@suse.de
- Update to 3.2.0pre2.
  + Add library for access to the registry configuration data.
  + BUG 5023: Separate NFS4 and POSIX ACL code in file access checks.
  + BUG 4308: Fix Excel save operation ACL bug.
  + BUG 4801: Correctly implement LSA lookup levels for LookupNames.
  + Add new option "debug class" to control printing of the debug class.
  + Enable building of the zfsacl and notify_fam vfs modules.
  + BUG 5083: Fix memleak in solarisacl module.
  + BUG 5063: Fix build on RHEL5.
  + New smb.conf parameter "config backend = registry" to enable registry only
    configuration.
  + Added support for IPv6 client and server connections.
  + Remove unused utilities: smbctool and rpctorture.
  + Fix service principal detection to match Windows Vista
    (based on work from Andreas Schneider).
  + Encrypted SMB transport in client tools and libraries, and server.
  + Added support for an SMB_CONF_PATH environment variable containing the
    path to smb.conf.
  + Various fixes to ntlm_auth.
  + Correctly handle mixed-case hostnames in NTLMv2 authentication.
  + Add Winbind client library.
  + Enhance client and server remote registry access.
  + Add client calls for remotely joining a computer to a domain (including
    calls from "net dom" command).
  + Add libnetapi.so library for joining domains including sample GTK+ app.
  + Fixes for Vista SP1 Kerberos authdata handling to only pickup the PAC.
  + Various fixes for DsGetDcName and conversion to IDL based structures.
  + Add ads_get_joinable_ous() to libads to get list of joinable ous.
  + Add get_logon_hours_from_pdb() to comply with new IDL based structures.
  + Migration of the entire client and server DCE/RPC code to IDL based
    structures and autogenerated code for DSSETUP, LSA, SAMR and NETLOGON.
  + Started migration of client and server DCE/RPC code to IDL based
    structures and autogenerated code for NTSSVC, SVCCTL and EVENTLOG.
  + Use IDL and autogenerated code for samlogoncache and Kerberos PAC
    handling.
  + Add remote join/unjoin server-side implementation.
  + Import the Linux red-black tree implementation.
  + Support for storing xattrs in tdb files.
  + Support for storing alternate data streams in xattrs.
  + Implement a generic in-memory cache based on rb-trees.
  + Speed up the smbclient "get" command.
  + Add the aio_fork module.
  + Modified libsmbclient API for more easily maintaining ABI compatibility
    while adding new features to libsmbclient.
  + Refactor Winbind internal parent-child interface tables to achieve better
    unit testing support.
  + Networking fixes to the libreplace library.
  + Add support for DNS Service Discovery.  Based on work from Rishi
    Srivatsavai <rishisv@gmail.com>.
  + Don't restart winbind if a corrupted tdb is found during initialization.
  + Add share parameter "administrative share".
  + Improve error messages of net subcommands.
  + Add 'net rap file user'.
  + Change LDAP search filter to find machine accounts which are not located
    in the user suffix.
  + Remove smbmount.
  + BUG 5073: Allow "delete readonly = yes" to correctly override deletion of
    a file.
  + Register the smb service with mDNS if mDNS is supported.
  + Add smbclient support for basic mDNS browsing.
  + Fix padding between Winbind 32bit/64bit client library in the request/
    response structures.
  + Added a syncops VFS module for file systems which do not guarantee
    meta-data operations are immediately committed to disk in stable form.
  + Additional portability support for building shared libraries.
  + Get Samba version or capability information from Windows user space.
- Add new sub packages libnetapi0, libnetapi-devel, libtalloc1,
  libtalloc-devel, libtdb0, libtdb-devel, libwbclient0, libwbclient-devel.
* Mon Apr 14 2008 anschneider@suse.de
- Fix build with glibc 2.8.
* Thu Apr 10 2008 ro@suse.de
- Added baselibs.conf file to build xxbit packages for multilib support for
  post 10.3 systems.
* Thu Apr 10 2008 boyang@suse.de
- Only cache password policy results that worked, otherwise we cannot login
  until the cache expires even if a connection to a DC has been restored;
  [bnc#373552].
* Tue Apr  1 2008 mkoenig@suse.de
- Remove dir /usr/share/omc/svcinfo.d as it is provided now by filesystem.
* Tue Mar 11 2008 lmuelle@suse.de
- Prevent tdb lock call getting interrupted by sig alarm; [bnc#364200].
* Mon Mar 10 2008 lmuelle@suse.de
- Update to 3.0.28a.
  + Failure to join Windows 2008 domains.
  + Windows Vista (including SP1 RC) interop issues.
* Tue Mar  4 2008 lmuelle@suse.de
- Rename the libsmbclient package to libsmbclient0 to follow the shared
  library packaging policy and remove provides libsmbclient3 for post 10.3
  systems.
* Fri Feb 22 2008 anschneider@suse.de
- Add variable to define if a share should be an administrative share;
  [bnc#358841].
* Mon Feb 18 2008 jjaimon@novell.com
- Fix patch errors with dcerpc and idmap_global; [bnc#280452].
* Thu Feb  7 2008 jmcd@suse.de
- Fix safe_strcpy error caused by duplicate domain name fix;
  [bnc#356025].
* Thu Feb  7 2008 anschneider@suse.de
- Fix two memleaks if num_validated_vuids exceeds its maximum;
  [bnc#349581].
* Fri Jan 25 2008 jmcdonough@suse.de
- Fix ACL inheritance; [bnc#351570].
* Wed Jan 23 2008 anschneider@suse.de
- Fix a gcc 4.3 buffer overflow warning.
* Wed Jan  9 2008 boyang@novell.com
- Remove duplicate domain name prepend when user SID is in winbindd cache;
  [#336854].
* Tue Jan  8 2008 anschneider@suse.de
- Prevent winbindd from segfaulting due to corrupted cache tdb on flushing
  caches; [#340332].
* Thu Dec 20 2007 anschneider@suse.de
- Fix kerberos authentication with Vista; [#350032].
* Wed Dec 12 2007 jmcdonough@suse.de
- Update to 3.0.28.
  + Fix send_mailslot overflow: CVE-2007-6015; [#343702].
* Wed Nov 28 2007 jmcdonough@suse.de
- Additional cases and problems caused by fix for CVE-2007-4572;
  [#337823].
* Mon Nov 26 2007 jmcdonough@suse.de
- Fix send_mailslot overflow: CVE-2007-6015; [#343702].
* Fri Nov 23 2007 hhetter@suse.de
- Added default printing system information to README.vendor;
  [#113759].
* Fri Nov 16 2007 lmuelle@suse.de
- Add missing define of AI_ADDRCONFIG for systems with older glibc versions.
* Thu Nov 15 2007 lmuelle@suse.de
- Update to 3.0.27.
  + Stack buffer overflow in nmbd's logon request processing; CVE-2007-4572;
  [#326261].
  + Remote code execution in Samba's WINS server daemon (nmbd) whe
    processing name registration followed name query requests; CVE-2007-5398;
  [#337823].
* Thu Nov 15 2007 anschneider@suse.de
- Change the spec file to get debug packages again.
* Wed Nov 14 2007 jmcdonough@suse.de
- Additional case for overflow: CVE-2007-4572; [#326261].
* Thu Nov  8 2007 jmcdonough@suse.de
- Fix process_logon_packet overflow; CVE-2007-4572; [#326261].
* Wed Nov  7 2007 jmcdonough@suse.de
- Fix reply_netbios_packet vulnerability; CVE-2007-5398; [#337823].
* Tue Oct 30 2007 jmcdonough@suse.de
- Fix missing getpwent mutex unlock; [#329796], [#331754], [#336854].
* Tue Oct 30 2007 jmcdonough@suse.de
- Fix the alignment of 32 and 64-bit winbind requests; [#331754].
* Fri Oct 12 2007 lmuelle@suse.de
- Add dmapi-devel and xfsprogs-devel to the BuildRequires for post 10.0
  systems; [#289599], fate [#302668].
* Tue Oct  9 2007 anschneider@suse.de
- Fix possible segfault in winbind which could be caused by uninitialized
  variables; [#253862c223].
* Fri Oct  5 2007 jmcdonough@suse.de
- Use FQDN in KDC DNS lookup; [#295284].
* Wed Oct  3 2007 lmuelle@suse.de
- Update to 3.2.0pre1.
  + Use of IDL generated parsing layer for several DCE/RPC interfaces.
  + Removal of the 1024 byte limit on pathnames and 256 byte limit on filename
    components to honor the MAX_PATH setting from the host OS.
  + Introduction of a registry based configuration system.
  + Improved CIFS Unix Extensions support.
  + Experimental support for file serving clusters.
  + Full support for Windows 2003 cross-forest, transitive trusts and one-way
    domain trusts
  + Support for userPrincipalName logons via pam_winbind and NSS lookups.
  + Support in pam_winbind for logging on using the userPrincipalName.
  + Expansion of nested domain groups via NSS calls.
  + Support for Active Directory LDAP Signing policy.
  + New ldb backend for local group mapping tables
  + Raised level of security defaults for authentication operations.
  + Inclusion of an HTLM version of the 3rd edition of "Using Samba" from
    O'Reilly Publishing.
- Update samba-vscan to 0.3.6c-beta5.
- Disable dcerpc-funnel and idmap_ad-Global_Catalog as both currently don't
  apply to Samba 3.2.
* Wed Oct  3 2007 jmcdonough@suse.de
- Make nss_winbind thread-safe; [#293907, #329796].
* Wed Oct  3 2007 jmcdonough@suse.de
- Perform KDC lookup using DNS only; [#295284].
* Wed Sep 26 2007 anschneider@suse.de
- Handle smb child crash; [#294895].
* Tue Sep 25 2007 lmuelle@suse.de
- Add a global lock inside nss_winbind as workaround; [#293907].
* Thu Sep 20 2007 lmuelle@suse.de
- Merge ranged retrieval optimization to winbindd.
* Wed Sep 19 2007 lmuelle@suse.de
- Update to 3.0.26a.
  + Memory leaks in Winbind's IDMap manager.
- Update to 3.0.26.
  + Incorrect primary group assignment for domain users using the rfc2307 or
    sfu winbind nss info plugin; CVE-2007-4138; [#307623].
* Fri Sep  7 2007 lmuelle@suse.de
- Fix two memleaks in idmap_cache.c; bso [#4917].
- Correct failure of libsmbclient against a version of Windows.
- Make read_sock return the total number of bytes read instead.
- Fix error in enum_dom_groups.
- Fix logic error in timeout of blocking lock processing.
- Add parameter "directory name cache size".
- Fix use of pwrite in tdb code.
* Thu Aug 30 2007 lmuelle@suse.de
- Also ensure to initialize ip_srv_site and count_site even if we are not on
  site; [#230963#c124].
- Use an off site DC if we're not online and talking to the KDC of our domain;
  [#230963#c106].
* Wed Aug 22 2007 anschneider@suse.de
- Fix a bug where samba writes the wrong default value of max_passwd_expire to
  an LDAP server; [#298469].
* Tue Aug 21 2007 lmuelle@suse.de
- Fix if statements where we still expected cli_connect() to return BOOL.
* Tue Aug 21 2007 lmuelle@suse.de
- Update to 3.0.25c.
  + File sharing with Widows 9x clients.
  + Winbind running out of file descriptors due to stalled child processes.
  + MS-DFS inter-operability issues.
* Tue Jul 24 2007 anschneider@suse.de
- Update the cache tdb validation patch which improves the backup handling
  trying to end up with a useable cache tdb. This applies mostly to the
  situation that disk space is short; [#256166c82].
* Thu Jul 19 2007 anschneider@suse.de
- Update the cache tdb validation patch to support backup and corrupted
  file handling; [#256166c77].
* Wed Jul 11 2007 anschneider@suse.de
- Fix a bug that causes smbd to 'hang' intermittently; [#289599].
* Tue Jul 10 2007 lmuelle@suse.de
- Fix event based krb5 ticket refreshing in winbindd.
* Fri Jul  6 2007 lmuelle@suse.de
- Limit the LDAP expression in lookup_usergroups_member() to security groups;
  [253862c209].
* Fri Jul  6 2007 lmuelle@suse.de
- Don't reset the num_names counter in lookup_groupmem(); [253862c198].
* Wed Jul  4 2007 anschneider@suse.de
- Make the days before the password expiry warning appears configurable in
  pam_winbind.conf; [#287871].
* Tue Jul  3 2007 schwab@suse.de
- Don't link shared libraries of vscan with -pie.
* Fri Jun 29 2007 lmuelle@suse.de
- Increase LOOKUP_SIDS_HUNK_SIZE for rpccli_lsa_lookup_sids_all() from 1000 to
  20480; [#253862c175].
* Wed Jun 27 2007 lmuelle@suse.de
- Update to 3.0.25b.
  + Offline caching of files with Windows XP/Vista clients.
  + Improper cleanup of expired or invalid byte range locks on files.
  + Crashes is idmap_ldap and idmap_rid.
* Sat Jun 23 2007 lmuelle@suse.de
- Fix reply when no dfs share is configured.
- Fix the DFS code to work with Vista clients; [#286937].
* Fri Jun 22 2007 lmuelle@suse.de
- Migrate old if-up/down scripts to new names on update; [#283706, #285187].
* Tue Jun 19 2007 anschneider@suse.de
- Introduced prefix numbering of if-up/down scripts that they get executed in
  the right order; [#283706, #285187].
* Tue Jun 19 2007 anschneider@suse.de
- Restart nscd on winbind update to load the new libnss_winbind.so.2 library.
  This will not resolve every problem with nss modules; [#174589c88].
* Mon Jun 18 2007 anschneider@suse.de
- Fix winbind segfaults with idmap_rid; bso [#4624].
* Thu Jun  7 2007 lmuelle@suse.de
- Add missed 'c' character to the list of valid ones in escape_shell_string();
  [#273611].
* Fri Jun  1 2007 lmuelle@suse.de
- Let lookup_groupmem() only resolve not yet cached SIDs; [#253862c106].
* Thu May 31 2007 lmuelle@suse.de
- Remove superfluous requires to samba from the devel package.
* Wed May 30 2007 lmuelle@suse.de
- Ensure the returned structure size from _samr_query_dispinfo() is smaller
  than the total size; [#203833].
* Sat May 26 2007 lmuelle@suse.de
- Remove 'unset CONFIGURE_OPTIONS' in front of the configure call to vscan.
- Install header files with 0644 instead of 0755 permissions.
- Enable build of the python package.
* Fri May 25 2007 anschneider@suse.de
- Branch a samba-devel package for post 10.2 systems.
- Install .a library files with 0644 instead of 0755 permissions.
* Fri May 25 2007 lmuelle@suse.de
- Update to 3.0.25a.
  + Missing supplementary Unix group membership when using "force·group".
  + Premature expiration of domain user passwords when using a·Samba domain
    controller.
  + Failure to open the Windows object picker against a server configured to
    use "security = domain".
  + Authentication failures when using security = server.
* Thu May 24 2007 lmuelle@suse.de
- Add %%dir /usr/share/samba to the client package.
- Remove samba-classic{,-client}, samba-ldap{,-client}, sambaxp{,-client}, and
  smbclnt from Provides and Obsoletes of the main or client package.
* Thu May 24 2007 stbinner@suse.de
- Add /sbin/ldconfig to %%post and %%postun of libsmbsharemode.
* Wed May 23 2007 lmuelle@suse.de
- Update samba-vscan to 0.3.6c-beta4.
* Wed May 23 2007 anschneider@suse.de
- In some cases PRS_ALLOC_MEM was called with zero count; [#273613];
  bso [#4637].
* Wed May 23 2007 hhetter@suse.de
- Enhance the patch to the ads version of lookup_groupmem(); [#253862c89].
* Mon May 21 2007 lmuelle@suse.de
- Don't use current_user to prep the security ctx in change_to_user();
  [#273613].
* Mon May 21 2007 lmuelle@suse.de
- Prevent winbindd segfaulting due to corrupted cache tdb; [#256166].
* Sat May 19 2007 lmuelle@suse.de
- Use WORKGROUP instead of TUX-NET as default workgroup setting in smb.conf.
* Fri May 18 2007 lmuelle@suse.de
- No longer check in the pre package scripts if swat or winbindd of version
  2.2 are updated; [#273160].
* Mon May 14 2007 lmuelle@suse.de
- Update to 3.0.25.
  + Significant improvements in the winbind off-line logon support.
  + Support for secure DDNS updates as part of the 'net ads join'·process.
  + Rewritten IdMap interface which allows for TTL based caching and·per
    domain backends.
  + New plug-in interface for the "winbind nss info" parameter.
  + New file change notify subsystem which is able to make use of·inotify on
    Linux.
  + Support for passing Windows security descriptors to a VFS·plug-in allowing
    for multiple Unix ACL implements to running side·by side on the Same
    server.
  + Improved compatibility with Windows Vista clients including·improved read
    performance with Linux servers.
  + Man pages for IdMap and VFS plug-ins.
  + Security Fixes CVE-2007-2444, CVE-2007-2446, and CVE-2007-2447.
- Disable build of the python package.
* Fri May 11 2007 lmuelle@suse.de
- Fix heap overflows to prevent remote code execution; CVE-2007-2446;
  [#273613].
- Fix remote command injection vulnerability; CVE-2007-2447; [#273611].
* Tue May  8 2007 lmuelle@suse.de
- Remove obsolete samba-pdb package and required packages from BuildRequires
  for post 10.2 systems.
* Mon May  7 2007 lmuelle@suse.de
- Remove X-UnitedLinux- prefix from init scripts for post 9.0 systems.
* Mon May  7 2007 lmuelle@suse.de
- Remove requires on release from devel packages.
* Thu May  3 2007 lmuelle@suse.de
- Reduces the number of queries made to the DC in the ads version of
  lookup_groupmem(); [#253862].
* Thu May  3 2007 lmuelle@suse.de
- Allow winbindd to take local shortcut on secondary DCs in case dce funnel
  directory is set; [#266853].
* Wed May  2 2007 lmuelle@suse.de
- Really remove Should-Start smb in smbfs init script; [#242918].
* Wed Apr 25 2007 lmuelle@suse.de
- Disable 'msdfs root' by default again; [#268004].
* Fri Apr 20 2007 lmuelle@suse.de
- Build libsmbsharemodes and create libsmbsharemodes and corresponding devel
  package; [#264623].
* Fri Apr 20 2007 lmuelle@suse.de
- Let idmap_ad search in the Global Catalog in case dce funnel directory is
  set; [#266049].
* Tue Apr 17 2007 lmuelle@suse.de
- Allow share names with a lengths greater than 32 chars; bso [#4512].
* Tue Apr 17 2007 lmuelle@suse.de
- Check the euid and call become_root() to get write access to dump a core.
* Tue Apr 17 2007 lmuelle@suse.de
- Add pwdutils BuildRequires for post 10.2 systems.
* Mon Apr 16 2007 lmuelle@suse.de
- Do not restart winbindd under any if-up circumstances; [#227942].
* Fri Apr 13 2007 lmuelle@suse.de
- Replace unneeded become_root_uid_only() by refactored become_root();
  CVE-2007-2444; [#262090].
* Tue Apr  3 2007 lmuelle@suse.de
- Add repository version and branch to the spec file via
  build-source-timestamp mechanism.
* Tue Apr  3 2007 lmuelle@suse.de
- Allow applications to set the share mode while opening a file using
  libsmbclient; bso [#3684]; [#203737].
* Thu Mar 29 2007 lmuelle@suse.de
- Fix for fd leak on error path in winbindd; bso [#3204], [#258737].
* Mon Mar 26 2007 rguenther@suse.de
- Add gdbm-devel BuildRequires for post 10.2 systems.
* Mon Mar 26 2007 lmuelle@suse.de
- Remove setlocale(LC_ALL, "C") calls; bso [#2926], [#247728].
* Sat Mar 17 2007 lmuelle@suse.de
- Fix segfault and memleak in wb_lookup_rids(); bso [#4434].
* Mon Mar  5 2007 lmuelle@suse.de
- Fixes a known bottleneck under very high load situations; [#247984].
* Mon Feb 26 2007 gd@suse.de
- Avoid passdb builtin group membership calls in the DCERPC funnel patch;
  [#248556].
* Fri Feb 23 2007 lmuelle@suse.de
- Allow pre 3.0.23 multi passdb backend configurations to work with
  post 3.0.22 by using the first backend only; [#245167].
* Thu Feb 22 2007 gd@suse.de
- Prevent nscd crash in NSS winbind initgroups(); [#237719].
- Fix pam_winbind cached login for samba/NT4 domains; bso [#4225].
- Various pam_winbind fixes; bso [#4094, #4288].
- Fix DCERPC funnel patch; [#245278].
- Fix vista and share level security.
- Fix vista variable expansion; bso [#4093].
- Fix vista DFS support; bso [#4356].
- Fix vista backup tool; bso [#4361].
- Fix vista deletion on shares; bso [#4188].
- Fix vista spoolss problems.
* Tue Feb 13 2007 gd@suse.de
- Fix crash bug in rpc_pipe_bind(); [#244892].
* Fri Feb  9 2007 lmuelle@suse.de
- Enable DCERPC funnel patch.
* Fri Feb  9 2007 gd@suse.de
- Fix accumulation of expired LDAP connections when winbind in ads mode;
  bso [#4009].
* Wed Feb  7 2007 gd@suse.de
- Fix all lp_dce_funnel_directory() callers; [#242833].
* Wed Feb  7 2007 lmuelle@suse.de
- Disable broken DCERPC funnel patch; [#242833].
* Mon Feb  5 2007 lmuelle@suse.de
- Update to 3.0.24.
  + Potential Denial of Service bug in smbd; CVE-2007-0452; [#240265].
* Thu Feb  1 2007 lmuelle@suse.de
- Fix logic error in the deferred open code; CVE-2007-0452; [#240265].
* Thu Feb  1 2007 gd@suse.de
- Avoid winbind event handler for internal domains.
* Tue Jan 30 2007 gd@suse.de
- Fix smbcontrol winbind offline; [#223418].
- Fail on offline pwd change attempts; [#223501].
- Register check_dom_handler when coming from offline mode.
- Fix pam_winbind passwd changes in online mode.
- Call set_domain_online in init_domain_list().
- Winbind cleanup after failure and fix crash bug.
- Don't register check domain handler for all trusts.
- Add separate logfile for dc-connect wb child.
- Only write custom krb5 conf for own domain.
- Move check domain handler to fork_domain_child.
* Fri Jan 26 2007 gd@suse.de
- Fix pam_winbind text string typo; [#238496].
- Support sites without DCs (automatic site coverage); [#219793].
- Fix invalid krb5 cred cache deletion; [#227782].
- Fix invalid warning in the PAM session close;
- Fix DC queries for all DCs; [#230963].
- Fix sitename usage depending on realm; [#195354].
* Wed Jan 24 2007 gd@suse.de
- Add DCERPC funnel patch; fate [#300768].
* Mon Jan 22 2007 gd@suse.de
- Fix pam password change with w2k DCs; [#237281].
* Thu Jan 18 2007 lmuelle@suse.de
- Check from the init script for SAMBA_<daemonname>_ENV variable expected to
  be set in /etc/sysconfig/samba to export a particular environment variable
  before starting a daemon.  See section 'Setup a particular environment for
  a Samba daemon' from the README file how this feature is to use.
* Mon Jan 15 2007 lmuelle@suse.de
- Remove %%config tag from /usr/share/omc/svcinfo.d/*.xml files.
* Thu Jan 11 2007 gd@suse.de
- Fix pam_winbind grace offline logins; [#223501].
- Fix password expiry message; [#231583].
* Thu Jan 11 2007 lmuelle@suse.de
- Move XML service description documents; fate [#301712].
* Wed Jan 10 2007 lmuelle@suse.de
- Disable smbmnt, smbmount, and smbumount for systems newer than 10.1.
* Tue Jan  9 2007 lmuelle@suse.de
- Add XML service description documents; fate [#301712].
* Thu Jan  4 2007 lmuelle@suse.de
- Move tdb utils to the client package.
* Thu Dec 14 2006 jeallison@novell.com
- Fix crash caused by deleting a message dispatch
  handler from inside the handler itself; [#221709].
* Fri Dec  8 2006 jeallison@novell.com
- Fix delays in winbindd access when on a non-home
  network; [#222595].
* Wed Nov 22 2006 jeallison@novell.com
- Fix client-side smb signing; [#222951].
- Fix imcomplete merge for firefox NTLM handling; [#198255].
* Mon Nov 20 2006 lmuelle@suse.de
- Add IA64 and x64 printer drivers directory.
* Thu Nov 16 2006 lmuelle@suse.de
- Update to 3.0.23d.
  + Stability fixes for winbindd.
* Fri Nov  3 2006 gd@suse.de
- Fix ldapsmb group and unicode issues; [#143417, #216606].
- Fix net ads account management; [#217046].
- Fix libnscd usage in passdb; [#217363].
- Add the "mega patch"
  + Add site support for winbind; [#195354], fate [#300909].
  + Add site support for net; [#211281], fate [#300909].
  + Fix winbind krb5 ticket handling from offline; [#178028].
  + Fix "net ads leave"; [#196771].
  + Fix winbind username case handling; [#184902].
  + Fix winbind name canonicalisation; [#210174].
  + Fix winbind online/offline handling; [#196859].
  + Add NTLM cached credential handling for firefox; [#198255],
    fate [#300973].
  + Fix winbind groupmembership handling; [#211324].
  + Fix winbind site-support handling on reconnect; [#195354].
  + Fix winbind child initialization and online/offline handling;
    [#196859].
  + Fix winbind cached credential storage; [#185053].
  + Fix winbind long login delays; [#184450].
  + Fix winbind crash for new AD user; [#208454].
* Thu Oct 26 2006 gd@suse.de
- Fix pam_winbind overriding syslog settings; [#201756].
- Fix profilepath pam_set_data for other PAM modules; [#215707].
* Mon Oct 23 2006 gd@suse.de
- Fix timeout handling for winbindd (samr, netlogon).
- Fix gencache access; [#209409, #211281].
- Fix libsmbclient accessing NetApp; bso [#4018].
- Fix error handling in ads printer code; [#209409].
- Fix passwd pam segfault; [#211719].
- Fix crash in winbind async child.
- Fix winbind failure mode for trusted domains.
* Fri Oct 20 2006 jeallison@novell.com
- Add realm to username if missing in net ads join; [#211706].
* Thu Oct 19 2006 lmuelle@suse.de
- Move the LOCKDIR to the client sub package.
* Thu Oct 12 2006 lmuelle@suse.de
- Activate the libaddns.
* Thu Sep 28 2006 lmuelle@suse.de
- Add version of the package subversion to Samba vendor version suffix.
* Fri Sep  1 2006 lmuelle@suse.de
- Update to 3.0.23c.
  + Authentication failures in pam_winbind when the AD domain
    policy is set to not expire passwords.
  + Authorization failures when using smb.conf options such
    as "valid users" with the smbpasswd passdb backend.
* Thu Aug 24 2006 jeallison@novell.com
- Fix time value reporting in libsmbclient; [#195285].
* Tue Aug 15 2006 ro@suse.de
- Remove update-messages.
* Tue Aug  8 2006 jeallison@novell.com
- Store and restore NT hashes as string compatible values; [#185053].
* Tue Aug  8 2006 jeallison@novell.com
- Added winbindd null sid fix; [#185053].
* Tue Aug  8 2006 lmuelle@suse.de
- Update to 3.0.23b.
  + Ambiguity with unqualified names in smb.conf parameters
    such as "force user" and "valid users".
  + Errors in 'net ads join' caused by bad IP address in the list
    of domain controllers.
  + SMB signing errors in the client and server code.
  + Domain join failures when using smbpasswd on a Samba PDC.
* Wed Jul 26 2006 lmuelle@suse.de
- Fix from Alison Winters of SGI to build even if make_vscan is 0.
* Sat Jul 22 2006 lmuelle@suse.de
- Update to 3.0.23a.
  + Failure to strip the domain name from groups when 'winbind
    use default domain = yes'
  + Bad token creation of local users on member servers not
    running winbindd.
  + Failure to add users or groups to ACLs using the Windows
    object picker.
  + Failure in file serving code when 'kernel oplocks = yes'.
  + New "createupn" option to "net ads join"
  + Rewritten Kerberos keytab generation when 'use kerberos
    keytab = yes'
* Tue Jul 18 2006 lmuelle@suse.de
- Replace vendor-files/tools/dlopen.sh by test_pam_modules make rule.
* Tue Jul 18 2006 lmuelle@suse.de
- Fix pam config file parsing in pam_winbind; bso [#3916].
* Mon Jul 10 2006 lmuelle@suse.de
- Update to 3.0.23.
  + Improved 'make test'
  + New offline mode in winbindd.
  + New Kerberos support for pam_winbind.so.
  + New handling of unmapped users and groups.
  + New non-root share management tools.
  + Improved support for local and BUILTIN groups.
* Fri Jul  7 2006 gd@suse.de
- Prevent potential crash in winbindd's credential cache handling;
  [#184450].
* Thu Jul  6 2006 lmuelle@suse.de
- Fix memory exhaustion DoS; CVE-2006-3403; [#190468].
* Sun Jul  2 2006 jeallison@novell.com
- Fix the munlock call, samba.org svn rev r16755 from Volker.
* Fri Jun 30 2006 jeallison@novell.com
- Change the kerberos principal for LDAP authentication to
  netbios-name$@realm from host/name@realm; [#184450].
* Tue Jun 27 2006 lmuelle@suse.de
- Ensure to link all required libraries to libnss_wins; [#184306].
* Sat Jun 24 2006 lmuelle@suse.de
- Update to 3.0.23rc3.
  + Warnings from the Klocwork code analyzer.
  + Various portability bugs on AIX, Solaris, and True64.
  + Authorization problems when managing services.
  + Problems joining Windows clients to a Samba/LDAP domain.
* Wed Jun 21 2006 jeallison@novell.com
- Change log level of debug message to avaoid flodded nmbd log; [#157623].
* Mon Jun 19 2006 lmuelle@suse.de
- Add 'usershare allow guests = Yes' to the default config; [#144787].
* Fri Jun 16 2006 schwab@suse.de
- Fix syntax error in configure script.
* Thu Jun 15 2006 gd@suse.de
- Add CHANGEPW kpasswd fallback to TCP; [#184945].
* Tue Jun 13 2006 lmuelle@suse.de
- Update to 3.0.23rc2.
  + Winbindd & Samba PDC integration issues.
  + Join problems from Windows clients in a Samba domain.
  + Winbind & AD trust failures.
* Fri Jun  9 2006 lmuelle@suse.de
- Remove VFS examples; [#182117].
* Fri Jun  9 2006 gd@suse.de
- Honour 'sn' attribute for eDir; [#176799].
* Thu Jun  8 2006 lmuelle@suse.de
- Adapt smbclient fix to smbtree to enable long share names; [#175999].
- Make smbclient -L use RPC to list shares, fall back to RAP; [#171311].
* Wed Jun  7 2006 gd@suse.de
- Re-add in-forest domain trusts; [bso #3823].
* Thu Jun  1 2006 lmuelle@suse.de
- Remove SO_SNDBUF and SO_RCVBUF from socket options example; [#165723].
* Wed May 31 2006 gd@suse.de
- Add wbinfo --own-domain; [#167344].
- Fix usability of pam_winbind on a Samba PDC; [bso #3800].
* Tue May 30 2006 lmuelle@suse.de
- Remove intrusive affinity patches for winbindd.
* Sat May 27 2006 jeallison@novell.com
- Merge Volker's winbindd crash fix for half-opened connections
  in winbindd_cm.c (sessionsetup succeeded but tconX failed).
* Thu May 25 2006 lmuelle@suse.de
- Update to 3.0.23rc1.
  + Winbind IDMAP integration with RFC2307 schema objects supported by Windows
    2003 R2.
  + Rewritten 'net ads join' to mimic Windows XP without requiring
    administrative rights to join a domain.
* Mon May 22 2006 lmuelle@suse.de
- Optimize lookup of user's group memberships via ExtendedDn LDAP control;
  [#168100].
- Restart winbind if the hostname is modified by the DHCP client; [#169260].
- Set the groups membership first whilst we're still root and use execve()
  instead of execv() in get_printing_ticket; [#177114].
- Add samba-krb-printing sub package with get_printing_ticket wrapper binary;
  [#149698].
* Tue May 16 2006 gd@suse.de
- Prevent passwords beeing swapped to disc; [#174834].
- Remove length limit from winbind cache cleanup function; [#175737].
- Fix NDS_ldapsam memory leak.
- Only add password to linked list when necessary.
- Don't try cached credentials when changing passwords.
- Cleanup winbind linked list of credential caches.
- Use the index objectCategory attribute in AD LDAP requests.
- Adjust AD time difference when validating tickets.
- Add password change warning for passwords beeing too young.
- Remove experimental Heimdal KCM support.
* Mon May  8 2006 lmuelle@suse.de
- Added "usershare allow guests" global parameter; [#144787].
* Thu May  4 2006 gd@suse.de
- Return domain name in samrquerydominfo 5; [#172756].
* Tue May  2 2006 gd@suse.de
- Fix unauthorized access when logging in with pam_winbind; [#156385].
* Thu Apr 27 2006 lmuelle@suse.de
- Don't ever set O_SYNC on open unless "strict sync = yes"; [#165431].
* Mon Apr 24 2006 gd@suse.de
- Correct fix to exit from "net" with an inproper configuration; [#163227],
  [#182749].
- Robustness fixes for winbind; [#167952].
- Fix build of own iniparser copy.
* Sun Apr 23 2006 lmuelle@suse.de
- Update to 3.0.23pre1.
* Sat Apr 15 2006 lmuelle@suse.de
- Exit from the net command with an error if Samba is not configured for the
  required role; [#163227].
- Add portability issue fixes between 32-bit winbind clients and a 64-bit
  winbindd server.
- Install pam_winbind.conf to /etc/security and add it with %%config(noreplace)
  to the samba-winbind sub package.
- Add fix to the vscan antivir module to circumvent longer startup times of
  the antivir scanner process.
* Wed Apr 12 2006 gd@suse.de
- Use iniparser for pam_winbind.
* Mon Apr  3 2006 lmuelle@suse.de
- Allow testparm to dump a paramatrical option.
- Update to 3.0.22; CVE-2006-1059; [#161778].
* Fri Mar 31 2006 gd@suse.de
- Don't assume account objectclass for eDir; [#160169].
* Wed Mar 29 2006 gd@suse.de
- Only send CLDAP request to an connect AD DC; [#159684].
- Invalidate krb5 credential cache when pam_auth has failed; [#161018].
* Tue Mar 28 2006 lmuelle@suse.de
- Enhance comment for the 'cups options = raw' line; [#160720].
* Thu Mar 23 2006 gd@suse.de
- Align pam_winbind patch with upstream version.
* Tue Mar 21 2006 jeallison@novell.com
- Fix oplock logic bug under heavy load; [#159626].
* Mon Mar 20 2006 gd@suse.de
- Flush nscd cache also on winbindd startup; [#137793].
- Remove paranoia check for empty acct_flags to support NT4 and older Samba 3
  DCs; [#149477].
- Skip superfluous keytab-iteration; [#154951].
- Avoid fallback to samlogon after password failure; [#158717].
- Fix empty domain name in NSS calls; [#154954].
* Wed Mar 15 2006 lmuelle@suse.de
- Call make proto instead of pch for pre 10.0 systems.
- Use 0750 as default permissions for /var/log/samba as the log files are
  created with 0644.
- Add libnscd-devel to BuildRequires for post 9.1 systems.
* Tue Mar 14 2006 jeallison@novell.com
- Fix Coverity bug missing return on error case in usershare code.
  Samba.org svn rev 14019.
* Mon Mar 13 2006 gd@suse.de
- Correctly flush nscd caches when winbindd comes (back) online; [#137793].
- Fix ldapsmb handling of quoted strings in smb.conf; [#153756].
* Thu Mar  9 2006 gd@suse.de
- Fix LDAP replication sleep handling for search requests; [#118378].
* Tue Mar  7 2006 lmuelle@suse.de
- Use dlopen.sh to test that every module we just built can actually be loaded
  by a minimal PAM-aware application.
- Link pam_smbpass with the required object files; bso [#3565].
* Wed Mar  1 2006 lmuelle@suse.de
- Fix case where a non existing tdb let smbpasswd -a core dump.
- Use make everything only to build the same result.
- Call proto_exists before we create the precompiled headers (pch).
- Set LC_ALL, LC_CTYPE, and LANG from /etc/sysconfig/language before we start
  smbd and unset it afterwards; [#105322].
- Fix message handling with smbcontrol; [#153699].
- Build and install mount.cifs and umount.cifs as part of the main Makefile.
- Define 'symbols' heimdal if we build on a system older than 9.1.  Else the
  heimdal specific patches are not applied.
- Start nmbd in /etc/sysconfig/network/scripts/samba-winbindd if the service
  is enabled before we switch winbindd online.
* Fri Feb 24 2006 lmuelle@suse.de
- Only use absolute paths for the targets of sym links.
- Add a comment to the smbusers file that we are not using it in our default
  configuration; [#153370].
- Update to final 3.0.21c.
- Properly shutdown winbindd with invalid configuration; [#153074].
- Never overwrite the acct_flags in rpccli_netlogon_sam_network_logon;
  [#149477].
- Fix usage of DESTDIR while calling make install; bso [#3282].
- Allow to rename workstations in a Samba Domain; [#140877], bso [#2331].
- Honour workgroup when parsing smb-uris correctly; [#152821].
- Simplify fillup_and_insserv call in the %%post of the client package for post
  10.0 systems.
- Fix net usershare info core dump; [#150870].
- Reorder Prereq lines and add missing binaries.
- Run /sbin/ldconfig from %%post and %%postun if the package contains a lib;
  also replace any %%run_ldconfig by /sbin/ldconfig; add PreReq /sbin/ldconfig.
* Mon Feb 20 2006 lmuelle@suse.de
- Update to 3.0.21c from svn.Samba.org SAMBA_3_0_RELEASE tree.
* Thu Feb 16 2006 lmuelle@suse.de
- Replace swat-welcome.diff by the upstream version; [#63160], bso [#2278].
- Replace pdbedit-pw-stdin.diff by the upstream version; bso [#1386].
- Add winbind offline config template; fate [#300457].
- Enhance return codes of net usershare; [#150870].
- Don't let lp_load() overwrite configuration settings; [#149682].
- Fix winbindd getpwnam behaviour for pam_winbind; [#149021].
- Replace nss-soname.diff by the upstream version; bso [#3381].
- Move libnss_wins into the client package.
- Fix pam_winbind Kerberos/NTLM fallback; [#149477].
- Update eDirectory LDAP schema for account policies; [#149470].
- Fix login password expiry handling in pam_winbind; [#149462].
* Tue Feb 14 2006 gd@suse.de
- Send correct workstation name to prevent NT_STATUS_INVALID_WORKSTATION
  beeing returned in samlogon; [#148645], [#161051].
* Wed Feb  8 2006 aj@suse.de
- Remove openafs requirement.
* Mon Feb  6 2006 lmuelle@suse.de
- Add Requires kerberos devel package to libsmbclient-devel; [#148579].
- Add Requires of the main lib packages to the libsmbclient and libmsrps devel
  packages.
- Add missing documentation to testparm man page..
* Mon Feb  6 2006 lmuelle@suse.de
- Remove /var/spool/samba from the filelist.
- No longer ignore NetworkManager controlled interfaces in dhcpcd-hook-samba.
- No longer call netbios_setup() if we source dhcpcd-hook-samba-functions.
* Thu Feb  2 2006 lmuelle@suse.de
- Add missing \ to the dhcpcd-hook-samba-functions.
- Change password character to '*' in NSS replies.
- Fix online/offline message handling for winbindd.
- Only do anything while calling the helper script samba-winbindd if "winbind
  offline logon" is "Yes".
- Starting nmbd with helper script samba-winbindd if we are going online and
  service nmb is activated.
- Package network interface scripts as %%ghost and only create the sym links on
  the initial install.
- Update to final 3.0.21b.
- Always use a local copy of guards (patches/tools/guards) instead of
  depending to the quilt package at build time.
- Install any section of the default smb.conf as separate file packaged in
  /usr/share/samba/templates/default-* into the client package.
- Append product version string to SAMBA_VERSION_VENDOR_SUFFIX.
- Add new feature to allow winbindd online offline state to be controlled by
  smbcontrol; [#147249].
- Add -k switch to tdbdump to dump the data of a single key; [#133453].
* Thu Jan 26 2006 lmuelle@suse.de
- Add --all-domains switch to wbinfo.
- Update to 3.0.21b from svn.Samba.org SAMBA_3_0_RELEASE tree.
- Add script to trigger winbindd on- or offline mode.
- By default only allow to share directories owned by the user; [#144787].
- Add more verbose error message if usershares aren't activated; [#145299].
- Remove /var/lib/samba/usershares/ from the filelist; [#144013].
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Fri Jan 20 2006 lmuelle@suse.de
- Add %%w macro to be replaced by the winbind separator.
- Add a desktop smb.conf as template to the client package.
- Run SuSEconfig --module permissions if the package is not installed with
  YaST and we have a /etc/permissions.d/samba-usershares file.
- Add /etc/permissions.d/samba-usershares as %%ghost to the filelist.
- Set %%verify(not group mode), root:users and 01700 as default for the default
  usershare path, /var/lib/samba/usershares/.
- It turns out krb5_kt_get_entry() on MIT does an implicit open/read/close and
  blows away an open keytab handle - so make sure we use a new handle;  bso
  [#3421].
- Ensure net usershare add uses an absolute path; [#143777].
- Use stderr for error messages of the net command.
- Ensure to rewind rem_backend if we have to workaround an old configuration.
  Else winbindd might seg fault.
- Fix crash bug in the idmap winbindd child.
- Add PAM conversation for disallowed password change.
* Sat Jan 14 2006 lmuelle@suse.de
- Remove idmap_ prefix from any idmap backend config setting; bso [#3264].
- Add net usershare command to manipulate user shares from trunk of samba.org.
- Align suse/samba3-pam_winbind patch with trunk of samba.org.
- Fix segfault in "net rpc vampire|samdump"; bso [#3390].
* Mon Jan  9 2006 jeallison@novell.com
- Don't assume owning sticky bit directory means write access allowed;
  bso [#3348].
* Wed Jan  4 2006 lmuelle@suse.de
- Create the precompiled headers with exactly the same flags as the
  binaries.
- Allow to rename machine accounts.  Fixed crash against eDirectory;
  [#140877].
* Tue Jan  3 2006 lmuelle@suse.de
- Add 'winbind refresh tickets' parameter; [#140962].
* Sun Jan  1 2006 lmuelle@suse.de
- Update to 3.0.21a; bso [#3349].
* Wed Dec 21 2005 lmuelle@suse.de
- Update to 3.0.21.
* Mon Dec 19 2005 gd@suse.de
- Add extended pam_winbind work from trunk.
* Wed Dec 14 2005 lmuelle@suse.de
- Return NT_STATUS_ACCOUNT_DISABLED if eDirectory returns
  LDAP_UNWILLING_TO_PERFORM; [#138491].
* Sun Dec  4 2005 lmuelle@suse.de
- Package libmsrpc files separate.
- Revert libsmbclient package renaming.
- Update to 3.0.21rc2.
* Tue Nov 29 2005 lmuelle@suse.de
- Ensure to be root while calling pdb_search_destroy(); else we don't have
  enough permissions to do the last paged LDAP search.
* Wed Nov 23 2005 lmuelle@suse.de
- Store "sambaLogonHours" in GMT and display them in localtime; bso [#3187]
- Update to ldapsmb 1.34.
- Cache the results more agressivly to stop multiple LDAP searches; bnc
  [#134082].
- Allow anonymous printing to Microsoft Windows 2000 and XP systems via
  unauthenticated ntlmssp session setup, bnc [#106335].
* Mon Nov 21 2005 lmuelle@suse.de
- Improve performance when enumerating users from a LDAP database; bnc
  [#134082].
* Fri Nov 18 2005 lmuelle@suse.de
- Add fix for quota on ext[23], reiserfs.
* Thu Nov 17 2005 lmuelle@suse.de
- Create a separate Samba documentation package to build it as noarch for post
  10.0 systems.
* Sun Nov 13 2005 lmuelle@suse.de
- Update to 3.0.21rc1.
* Wed Nov  9 2005 lmuelle@suse.de
- Add samba.org post 3.0.20b fixes.
  + Ensure printjob deletion.
  + Fix setting of quotas on Linux.
  + Clear request structure before used by wbinfo; bso [#3201].
  + Added new parameter 'map readonly = [yes|no|permissions]'; bnc [#134188].
  + Fix acl evaluation bug.
  + Don't count open pipes in the num_files_open on a connection.
* Fri Oct 28 2005 lmuelle@suse.de
- Speed up load of the configuration file with a large number of share
  definitions; bnc [#129341], bso [#1117].
* Sun Oct 16 2005 lmuelle@suse.de
- Update patch for mount.cifs to work with named uid/ gid; [#120601].
* Fri Oct 14 2005 lmuelle@suse.de
- Use upstream fix to supress LDAP build warnings with OpenLDAP 2.3.7 or
  higher and to build with openssl 0.9.8a or higher.
- Allow mount.cifs also to work with uid/ gid names; [#120601].
* Thu Oct 13 2005 lmuelle@suse.de
- Disable smbwrapper support for all architectures.
- Update to 3.0.20b
  + winbindd crash with alt_names; bso [#3068]
  + denied write on a share in read/write mode; bso [#3088]
  + read-only share files are always seen as read-only
  + quota support; bso [#3070]
* Sun Oct  9 2005 schwab@suse.de
- Make syscall wrapper stuff compilable.
* Fri Sep 30 2005 lmuelle@suse.de
- Update to 3.0.20a.
* Mon Sep 26 2005 ro@suse.de
- fix some implicit function declarations in getdate.
* Mon Sep 19 2005 lmuelle@suse.de
- Add iprint support; [#113346].
- Update to samba-vscan 0.3.6b.
- Add more samba.org post 3.0.20 fixes.
  + RegCreateKeyEx() Failures
  + Usrmgr.exe and Groups
  + net rpc shutdown
  + DOS applications
- Disable build of smbwrapper for ia64.
* Mon Sep 12 2005 gd@suse.de
- Fix x86_64 crash bugs
  + security descriptor upgrade in print tdbs [#106751, samba.org #3084]
  + winbindd resolving group membership [samba.org #3082]
* Mon Aug 29 2005 lmuelle@suse.de
- Add samba.org post 3.0.20 fixes.
  + Fix password history for eDirectory
  + fix enumerated group name
  + other minor fixes
* Sat Aug 20 2005 lmuelle@suse.de
- Update to 3.0.20.
* Thu Aug 18 2005 lmuelle@suse.de
- Fix assembling of the filepath in vscan-icap; [#105582].
- Fix typo in vscan-mcdaemon; [#102372].
* Tue Aug  9 2005 lmuelle@suse.de
- Update to 3.0.20rc2.
* Tue Aug  9 2005 lmuelle@suse.de
- Enable vscan filetype support for post 9.0 systems as SLES 9 SP 2 provides
  a file package built with -fPIC; [#102372].
* Wed Aug  3 2005 lmuelle@suse.de
- Update to ldapsmb 1.33.
- Create precompiled headers on post 9.3 systems.
* Fri Jul 29 2005 lmuelle@suse.de
- Update to 3.0.20rc1.
- Fail build if a patch doesn't apply.
* Wed Jul 20 2005 lmuelle@suse.de
- Use guards of the quilt package to apply all patches.
- Add shared module idmap_ad.
- Update to ldapsmb 1.32.
* Wed Jul 13 2005 lmuelle@suse.de
- Update to 3.0.20pre2.
* Tue Jun 28 2005 lmuelle@suse.de
- Update to 3.0.20pre1.
* Mon Jun 20 2005 lmuelle@suse.de
- Add more post 3.0.14a fixes; bugzilla.Samba.org [#2729, #2698].
- Add hint to documentation about the permissions of umount.cifs; [#85813].
* Tue May 10 2005 lmuelle@suse.de
- Add more post 3.0.14a fixes.
- Update umount.cifs to the current version.
* Tue Apr 26 2005 lmuelle@suse.de
- Add umount.cifs binary.
* Fri Apr 22 2005 lmuelle@suse.de
- Fix potential buffer overflow in torture.
- Change Requires ... = %%{version} to >= ... %%{version} to allow installation
  of an subpackage from the original media after a version update was
  available and installed by online update.  Kept Requires samba = %%{version}
  for samba-vscan [#80230].
* Wed Apr 20 2005 lmuelle@suse.de
- Add missing /usr/sbin/groupadd to PreReq of the main package.
* Tue Apr 19 2005 lmuelle@suse.de
- Remove 'dos filetimes = Yes' from smb.conf as it now is the default.
* Tue Apr 19 2005 ro@suse.de
- try to make testsuite build with gcc-4
* Fri Apr 15 2005 lmuelle@suse.de
- Update to version 3.0.14a.
- Fix net share migrate and report in the case of the top level share
  directory ACL.
* Tue Apr 12 2005 lmuelle@suse.de
- Update to version 3.0.14.
* Fri Apr  8 2005 lmuelle@suse.de
- Update samba-vscan to version 0.3.6.
- Set 'dos filetimes = Yes' in smb.conf for all shares where other users than
  the owning user might have write access to Microsoft Excel files.
* Thu Mar 24 2005 lmuelle@suse.de
- Update to version 3.0.13; fix Samba to POSIX draft ACL mapping [#74373];
  bugzilla.Samba.org [#2521].
* Mon Mar 21 2005 lmuelle@suse.de
- Fix copy/delete files from Microsoft Windows 98 explorer; [#74102];
  bugzilla.Samba.org [#2501].
* Fri Mar 18 2005 lmuelle@suse.de
- Update to version 3.0.12.
* Sun Mar 13 2005 lmuelle@suse.de
- Ensure to package smbfstab with limited access permissions.
- Add additional Provides and Obsoletes and add %%version-%%release to the
  Provides tags.
* Fri Feb 25 2005 lmuelle@suse.de
- Disable com_err patch for post 9.2 products.
- Use NO_BRP_STRIP_DEBUG="true" in the %%install section if make_devel is set.
- Call mkversion.sh to add VENDOR_SUFFIX to version.h
* Mon Feb  7 2005 ro@suse.de
- use kerberos-devel-packages in neededforbuild (again)
* Fri Feb  4 2005 lmuelle@suse.de
- Update to 3.0.11.
- Create extra package, cifs-mount for the mount.cifs for post 9.2 products;
  [#45324].
- Replace SWAT welcome.html sym link post and pre script workaround by a SWAT
  fix; [#48160]; bugzilla.Samba.org [#2278].
* Fri Jan 21 2005 lmuelle@suse.de
- Enusre to free memory used for response and language in the print_cups code;
  [#49999]; bugzilla.Samba.org [#2270].
* Thu Jan 20 2005 lmuelle@suse.de
- Fix order of evaluation in the bitmap code; Samba.org svn revision 4120;
  [#49476,#49514,#49947].
* Fri Jan 14 2005 ro@suse.de
- fix typo in specfile
* Wed Dec 22 2004 lmuelle@suse.de
- Fix open_any_socket_out on request of Volker Lendecke; bugzilla.Samba.org
  [#2180]; [#49480].
* Thu Dec 16 2004 lmuelle@suse.de
- Update to version 3.0.10; CAN-2004-1154; [#49119].
* Wed Dec 15 2004 lmuelle@suse.de
- Set IDMAP_RID_SUPPORT_TRUSTED_DOMAINS to 1 in sam/idmap_rid.c and add
  Samba.org svn revision 4216; [#49250].
- Disable none working pdf share; [#49221].
- Don't remove statically defined printers in remove_stale_printers();
  bugzilla.Samba.org [#2091]; [#49221].
* Tue Dec 14 2004 lmuelle@suse.de
- Add more changes from Vince Brimhall <vbrimhall at Novell dot com> to the
  eDirectory integration patches; [#48821].
* Mon Dec 13 2004 lmuelle@suse.de
- Fix remote exploitation of an integer overflow vulnerability in the smbd
  daemon; will be addressed in 3.0.10 upstream; CAN-2004-1154; [#49119].
- Add workaround for samba-vscan if TMPDIR env is set; [#49041].
- Add more changes from Vince Brimhall <vbrimhall at Novell dot com> to the
  eDirectory integration patches; rename the passdb backend file to pdb_nds;
  [#48821].
- Remove patch to avoid inclusion of linux/audit.h as it - even for post 9.1
  products - is superfluous; bugzilla.Samba.org [#2061].
* Tue Nov 30 2004 lmuelle@suse.de
- Add -O to CFLAGS only for pre 9.2 products; [#44167], bugzilla.Samba.org
  [#1631].
- Ensure to include /usr/lib/cups/backend only in post 9.0 products.
* Fri Nov 19 2004 lmuelle@suse.de
- Only avoid inclusion of linux/audit.h for post 9.1 products.
- Fix also max fd count for the select() call in nmbd and wrepld.
- Add more post 3.0.9 fixes.
* Fri Nov 19 2004 lmuelle@suse.de
- Add missing ldapsmb man page.
- Add AntiVir module to samba-vscan.
- Fix fixed PID file name if multiple Samba daemons are used; [#48237].
- Add fixes to nds_ldap.c and nds-pdb_ldap.c.diff from Vince Brimhall
  <vbrimhall at Novell dot com>.
- Use common* PAM configuration only for post 9.2 products.
- Update to version 3.0.9.
* Mon Nov 15 2004 lmuelle@suse.de
- Add max fd count for select call in smbd/server.c.
* Mon Nov 15 2004 kukuk@suse.de
- Use common-* PAM configuration.
* Fri Nov 12 2004 lmuelle@suse.de
- Remove check for uid and gib mapping from winbind init script as winbind
  nowadays works fine as a proxy only.
- Add -t 10 to all killproc calls in the init scripts; [#47227].
- Fix output of smbstatus to make the man page; fix -L, -p, & -S and the -u
  <username> functionality.
- Move doc subpackage %%preun to %%postun and change sym link only if first arg
  is less than 1 as only this situation is a deinstallation case.
* Thu Nov 11 2004 lmuelle@suse.de
- Fix seg fault in lanman printing code.
- Fix testparm reporting for the passwd program string.
- Add welcome.html also as %%ghost to the samba-doc package and remove rm from
  %%preun as this breaks the uninstall of samba-doc; [#48160].
- Protect all welcome-* files in the %%pre section of samba-doc to not get
  deleteted.  welcome-en-no-samba-doc.html of the samba package was accidently
  removed.
* Thu Nov 11 2004 lmuelle@suse.de
- Update Samba docs to version 3.0.8; [#48137].
- Use a 32 instead of a 64 byte case-exact string in the samba-nds.schema
  for the sambaPasswordHistory object; [#48134].
- Use samba-nds.schema of examples/LDAP/samba-nds.schema as it is now part of
  the main line and mark it as %%config in the filelist.
- Remove admin from default smbusers mapping file; [#48111].
- Add post 3.0.8 fixes.
- Remove rest of old net RPC printer migration patch as the problem is solved
  different in 3.0.8.
- Fix undefined reference to `secrets_*' in libsmbclient; [#48082].
- Enable testsuite for libsmbclient.
- Fix domain/ workgroup bug for multibyte names in nmbstatus; [#38309].
- Remove superfluous rm in the preun of the samba package.
* Mon Nov  8 2004 lmuelle@suse.de
- Update to version 3.0.8; CAN-2004-0930; [#48019].
- Fix roundup problem for non-Windows clients; CAN-2004-0882 [#46203].
- Use upstream version of the HTML index file; [#48041].
* Wed Nov  3 2004 lmuelle@suse.de
- Add samba-nds.schema to /usr/share/samba/LDAP, [#47894].
* Tue Nov  2 2004 lmuelle@suse.de
- Remove incomplete account expiry feature.
- Remove broken clockskew fix on request of the author.
* Thu Oct 28 2004 lmuelle@suse.de
- Add printername and queue update patch, bugzilla.Samba.org [#1519].
- Add account and password expire feature mainly for migration.
- Add bad password count and logon count while migration.
- Use define for common %%setup options and set it to -q.
- Fix several serious compiler warnings in smbd/lanman.c.
* Fri Oct 22 2004 adrian@suse.de
- make it possible to build the package as user
* Thu Oct 21 2004 mc@suse.de
- disable samba3-account_pol_ldap.diff; breaks libsmbclient
* Tue Oct 19 2004 lmuelle@suse.de
- Add showacls option to smbclient.
* Mon Oct 18 2004 mc@suse.de
- Update pdb_ldap.c.diff from Vince Brimhall <vbrimhall at Novell dot com>.
* Fri Oct 15 2004 lmuelle@suse.de
- Update eDirectory patch from Vince Brimhall <vbrimhall at Novell dot com>.
* Thu Oct 14 2004 lmuelle@suse.de
- Add information to the default smb.conf that the full version is only
  available if samba-doc is installed, [#43953].
- Move samba.reg to the vendor-files tar ball.
- Use $syslog for Required-Start in the smbfs init script, [#37618].
- Add eDirectory patch from Vince Brimhall <vbrimhall at Novell dot com>.
- Add alias migration code from Volker Lendecke <vl at Sernet do DE>.
- Add account policy migration to LDAP code from Guenther Deschner <gd at
  Samba dot org>.
* Mon Oct 11 2004 lmuelle@suse.de
- Fix recursive ls in smbclient.  Fix by Josef Zlomek.
* Wed Oct  6 2004 lmuelle@suse.de
- Fix job check of smbfs init script.
- Use 0754 permissions for all init scripts.
* Thu Sep 23 2004 lmuelle@suse.de
- Fix smbfs init script for case where we wait for mount or umount to succeed,
  [#45778].
* Tue Sep 21 2004 lmuelle@suse.de
- User 0775 and root:ntadmin for drivers and 0770 and root:users for profiles
  directory as with the Samba 2.2 packages.
- Add groupadd ntadmin to %%pre of the main package, [#45719].
- Modify NetBIOS Datagram Distributor extensions patch to protect records
  which are marked as permanent.
* Thu Sep 16 2004 lmuelle@suse.de
- Enable krb5_cc_close() in libsmb/clikrb5 to avoid memleak of winbindd.
- Remove obsolet part from vendor README.
- Call mount only one time in the smbfs init script.
- Add additional information to the samba-vscan INSTALL file.
* Mon Sep 13 2004 lmuelle@suse.de
- Update to version 3.0.7, CAN-2004-0807, CAN-2004-0808, [#44883].
- Restructure vendor-files tar ball.
- Use -dPARANOIDSAFER as option to gs in smbprngenpdf.
- Move all 'inherit permissions' to 'inherit acls' in the default smb.conf.
- Enhance libtool --mode patch for examples/pdb/ as suggested by Andreas
  Schwab <schwab at suse dot de>.
- Add %%{?jobs:-j%%jobs} to most make calls as suggested by Stephan Kulow <coolo
  at suse dot de>
* Fri Sep  3 2004 lmuelle@suse.de
- Remove letters from the version string of autoconf and autoheader.
- Add --mode=MODE to libtool calls.
- Add logrotate settings for nmbd and smbd only on systems newer than 8.1.
* Wed Sep  1 2004 lmuelle@suse.de
- Disable filetype support in vscan for version older than 9.2 where file was
  built without -fPIC.
- Use new update message mechanism, [#44359].
- Disable profile information gathering.  This is the Samba default.
- Check in %%pre of the doc package if there are still directories and files in
  swat/help and remove them to allow cpio to create sym links here, [#44564].
- Check in dhcpcd-hook-samba if the interface is configured for BOOTPROTO
  dhcp and exit gracefully if not.
* Fri Aug 27 2004 lmuelle@suse.de
- Fix check for DHCLIENT_MODIFY_SMB_CONF, add copyright to and remove 'set -e'
  from dhcpcd-hook script.
- Remove swat/help/* and replace it with sym links to the samba-doc package.
- Add VENDOR suffix to mount.cifs.
- Add NetBIOS Datagram Distributor extensions provided by Brian Landy <landy
  at alumni dot caltech dot edu>.  See http://www.landy.cx/ or the comments in
  the patch.
- Add more post 3.0.6 fixes.
* Thu Aug 26 2004 lmuelle@suse.de
- Use try-restart in nmb init script when called with force-reload.
- Add DHCP support for wins server and netbios scope setting.
* Tue Aug 24 2004 lmuelle@suse.de
- Update to version 3.0.6, [#43737, #43773].
- Update samba-vscan to version 0.3.5, [#43853].
- Update net RPC printer migrate patch from Günther Deschner.
- Add several post 3.0.6 fixes.
- Use -O instead of default -O2 for CFLAGS to avoid potential miscompilation,
  [#44167]; bugzilla.Samba.org [#1631].
* Thu Jul 22 2004 lmuelle@suse.de
- Update to version 3.0.5.  CAN-2004-0600 and CAN-2004-0686.
- Add net RPC printer migrate patch from Günther Deschner.
- Add RPM release to the vendor suffix in the version header file.
* Tue Jun 22 2004 lmuelle@suse.de
- Fix premature optimization in unix_convert() [#42332]; bugzilla.Samba.org
  [#1345].
* Wed Jun 16 2004 lmuelle@suse.de
- Convert spec file to UTF-8 to produce mail with content type UTF-8 if we
  create one in the %%pre or %%post section.
* Tue Jun 15 2004 lmuelle@suse.de
- Create a mail if we update from Samba 2.2 and used LDAP as SAM before
  [#42055].
- Move /var/log/samba and /var/run/samba to the client package [#42018].
* Fri Jun 11 2004 lmuelle@suse.de
- Ensure that we always use tdb_open_log() instead of tdb_open_ex() [#41929].
- Fix afs syscall patch.  Already tested and added upstream.
- Add some information about the commented example configuration file to the
  README.
- Add an inative [netlogon] share to the example configuration.
* Wed Jun  2 2004 ro@suse.de
- avoid inclusion of linux/audit.h
* Tue Jun  1 2004 lmuelle@suse.de
- Add CIFS support to smbfs init script [#41486].
- Use stderr for important messages in the init scripts.
- Remove empty Samba named configuration.
- Add hu translation to Samba.desktop file.
* Mon May 31 2004 lmuelle@suse.de
- Move smb.conf existence test in all init scripts to the start case [#41430].
- Add WHATSNEW and README to the htmldocs file.
- Use samba.css in htmldocs.html and manpages.html.
- Add X-DOC-* lines to enable search index creation and some translations to
  the Samba.desktop file.
* Sun May 30 2004 lmuelle@suse.de
- Remove backtrace file from vendor-files as our version it's now in upstream.
- Add Samba.desktop file for SuSEhelp system to the doc package.
- Move smbpasswd, smbcontrol binaries and man pages to the client package.
- Move README to the client package.
- Add additional information to the README.
* Sun May 30 2004 lmuelle@suse.de
- Split winbind and wrepl logrotate from main package [#41433].
- Skip test for smb.conf file in case of stop in nmb, smb, winbind, and wrepl
  init scripts [#41430].
- Move sym link /usr/share/samba/swat/using_samba to the doc package [#41429].
- Return always with success from smbfs init script in case of stop [#41428].
- Don't add /etc/samba/*.tdb files to file list.
- Enable patch to build examples-vfs with -fPIC for all architectures.
* Fri May 28 2004 lmuelle@suse.de
- Add profiles share with setting to suppress popup of a desktop.ini file to
  the default smb.conf.
* Thu May 27 2004 lmuelle@suse.de
- Enable logon drive, path, and home in the way Standard Server 8 does and add
  'username map' setting to default smb.conf.
- Use /var/log/samba/ as a secure directory for the smb-print script [#36676].
- Readd -t|--password-from-stdin option to pdbedit [#41182];
  bugzilla.Samba.org [#1386].
- Fix winbind in case schannel verifier does not include the nonce [#41100];
  bugzilla.Samba.org [#1315].
- Fix 'write list' option in case of security is better than share [#41101];
  bugzilla.Samba.org [#1319].
- Touch smbd pid file in the init script while reload if the daemon runs.
  This allows probe to return a value not equal reload.
- Add upstream changes to the 'printcap cache time' feature.  Thie requires to
  set 'printcap cache time = 750' in our default smb.conf as the upstream
  default is 0 which disables the feature.
* Wed May 19 2004 ro@suse.de
- fix some gcc warnings (py_spoolss_drivers.c: argument sequence)
* Thu May 13 2004 lmuelle@suse.de
- Add patch to fix clock skew of winbind in ADS security.  For details see
  bugzilla.Samba.org [#1208].
- Add patch to fix printing to the IP address of the server.
- Remove TDB files from below /var/lib/samba/ from filelist.
- Update to version 3.0.4.  Fix password change broken by Microsoft hotfix
  MS04-011 [#40087].
- Add libsmbclient fix from Stephan Kulow <coolo at suse dot de>.  For details
  see bugzilla.samba.org [#429].
- Add 'printcap cache time' option to remove stale and add new printers
  [#21846].  See also bugzilla.Samba.org [#1259].  By this we no longer have
  to wait for the CUPS dameon in the init script.
- Disable 'interfaces' and 'bind interfaces only' by default [#39491].
- Use right path to smb.conf in smbpasswd file and add some hints.
* Thu Apr 29 2004 lmuelle@suse.de
- Add quotactl support patch from Stefan Metzmacher <metze at samba dot org>
  [#39666]
- Replace suse_ver macro by real version string.
* Thu Apr 29 2004 lmuelle@suse.de
- Update to version 3.0.3.
- Adopt missing patches from 2.2.8a.
- Move LDAP schema to samba-client package.
- Add prerequires to samba package.
- Add missing stop_on_removal macros
- Add /var/lib/samba/browse.dat to the file list.
- Add /var/lib/samba/printing directory to the file list.
- Remove printingCupsOptions and expired_service_tickets diff; use upstream
  version instead; they are now part of the printingAndManyOtherFixes diff.
- Enhance waiting for cupsd function in the smb init script
  * only check with lpstat every two seconds
  * remember start time in seconds and calculate the waiting time in relation
    to this; this is important if a configured CUPS server is unreachable.
  In this case we now really wait only 30 seconds and not 30 times of the
  lpstat timeout.
  * Thanks to Bjoern Jacke <bjoern at j3e dot de> for the patch.
* Mon Apr 19 2004 lmuelle@suse.de
- fix ldapsmb script
- add expired service tickets patch from Guenther Deschner <gd at suse dot de>
* Thu Apr 15 2004 lmuelle@suse.de
- add 'cups options = raw' to the default smb.conf, [#28176]
- fix typo and use signal USR2 in write-status case of init script
* Mon Apr  5 2004 lmuelle@suse.de
- add patch from Alexander Bokovoy <ab@samba.org> to fix smbmount, [#37871]
- only create notify message on first installation
* Sat Apr  3 2004 lmuelle@suse.de
- readd /var/lock/samba/{drivers,netlogon,profiles}
- add more TDB files as %%ghost %%config(noreplace) to the file list
- enhance default configuration file, [#38024]
* Wed Mar 31 2004 lmuelle@suse.de
- add restart_on_update macros for nmb, smb and winbind
- fix path to smb-print.log, [#36676]
- move smbpasswd, pdbedit and testparm binaries and man pages to the client
  package
- add cracklib-devel to BuildRequires
- add several TDB files as %%ghost %%config(noreplace) to the file list
- add backtrace script to examples/scripts
- fix smbadduser paths
- move /etc/xinetd.d/samba to /etc/xinetd.d/swat
* Mon Mar 22 2004 lmuelle@suse.de
- add 'printing cups options' feature; this allows us to print with option
  'raw' without enabeling raw printing in the cups.conf, [#20218]
- add big patch collected from the CVS; [#36602]
- add sambaxp and sambaxp-client to the provides and obsoletes tag
- spec file cleanup
* Tue Feb 24 2004 gd@suse.de
- readd nmbstatus, mkntpwd, ldap-schema and cups-smb-backend
* Sun Feb 22 2004 gd@suse.de
- disable build of utils-package
* Wed Feb 18 2004 gd@suse.de
- update to 3.0.2a
- removed last references of docbook package
- moved cifsmount into client package
- added pgsql-backend
- cleaned up neededforbuild
- build as root
- fixed dependencies
- smb init-script should check for defaults
- winbind init-script should warn for required params
* Wed Feb 18 2004 coolo@suse.de
- readding my fix for libsmbclient. without it surfing windows
  networks is pure luck ;(
* Mon Feb 16 2004 adrian@suse.de
- register samba and swat via slp.reg.d
* Wed Feb 11 2004 kukuk@suse.de
- Remove self Conflicts
* Sun Feb  1 2004 gd@suse.de
- update to 3.0.2rc2
* Sun Jan 25 2004 adrian@suse.de
- rename package back to "samba"
- fix build
- add %%defattr
- clean up Provides/Obsoletes
- add Provides/Obsoletes for libsmbclient3
* Sun Jan 25 2004 gd@suse.de
- removed extra docbook-package
* Sun Jan 25 2004 gd@suse.de
- initial package of samba3. based on the work of Lars Mueller
  <lmuelle-at-suse.de>.
* Sun Jan 18 2004 meissner@suse.de
- Added -fPIC to libmksd build.
* Thu Jan 15 2004 kukuk@suse.de
- added pam-devel to neededforbuild
* Fri Oct 17 2003 kukuk@suse.de
- Remove unused des from neededforbuild
* Mon Sep 15 2003 kukuk@suse.de
- Add requires to libsmbclient-devel [Bug #30718]
* Fri Sep  5 2003 kukuk@suse.de
- Move /var/log/samba and /var/run/samba to samba-client [#30027]
* Thu Aug 28 2003 lmuelle@suse.de
- call sbin/SuSEconfig --module samba and not directly the script in the %%post
  section
* Tue Aug 26 2003 lmuelle@suse.de
- add patch from Ademar de Souza Reis Jr. <ademar at conectiva dot com dot br>
  for smbclient to get a working -TI option, #27353
* Thu Aug 21 2003 lmuelle@suse.de
- add nss-soname patch from Andreas Schwab, #28248
- add stop_on_removal and restart_on_update macros to preun and postun section
* Tue Jul 29 2003 lmuelle@suse.de
- point getSambaOptions to the right location of the source file
- fix handling of uninitialized variable in nmbstatus
* Mon Jul 28 2003 lmuelle@suse.de
- add Urban Widmark <urban at teststation dot com> patches for smbmount; this
  includes LFS, unicode, escape character, and 32 bit uid suppprt, #18472
- add nmbstatus utility
- add schannel feature from Volker Lendecke <Volker.Lendecke at SerNet dot DE>
- move winbind init script and rc sysm link to the client package
- remove superfluous linkvfs patch
- activate root = administrator admin in smbusers by default
- add smbprngenpdf
- add configure option --with-sendfile-support
- autocreate samba.opts.ini while build
* Mon Jun 23 2003 lmuelle@suse.de
- add /usr/lib/cups/backend/smb to the samba-client package
- unify init scripts; add one space at the end to all echos
* Wed Jun  4 2003 lmuelle@suse.de
- fix pointer cast on 64bit big endian architecture in winbind_nss.c, #27220
- add new sysconfig tags
* Wed May 14 2003 ro@suse.de
- run autoreconf / fix build with latest libtool
* Thu May  8 2003 lmuelle@suse.de
- remove %%ghost from sym linked files
* Mon Apr 28 2003 lmuelle@suse.de
- cleanup %%post script part which takes care of old configuration location
* Sun Apr 20 2003 lmuelle@suse.de
- remove tdbtorture from package on request of the Samba team
- update to version 2.2.8a
* Mon Mar 17 2003 lmuelle@suse.de
- readd map to guest = Bad User to smb.conf
* Fri Mar 14 2003 lmuelle@suse.de
- move samba LDAP schema to the client package
- add product suffix to README and smb.conf files of documentation
- mark sym links from /var/lib/samba/bin/ as %%ghost
* Thu Mar 13 2003 lmuelle@suse.de
- add security patch for the client side, #25140
- remove check for existence of sysconfig and smb.conf from smbfs init script
* Wed Mar 12 2003 lmuelle@suse.de
- add security patch from SuSE Security Team, #25140
- cleanup init scripts try-restart part
* Mon Mar 10 2003 lmuelle@suse.de
- add fix to samba-nds.schema provided by Jochen Schaefer <jschaef@SuSE.de>
- add fixes for winbind caching and uid handling , smbpasswd, smbd and TDB
  handling
* Sun Mar  9 2003 kukuk@suse.de
- Use getent in smbadduser
* Fri Mar  7 2003 ro@suse.de
- remove mminimal-toc from CFLAGS (ppc64)
* Thu Mar  6 2003 kukuk@suse.de
- Add xinetd config file [Bug #24682]
* Thu Mar  6 2003 kukuk@suse.de
- Remove cyrus-sasl from neededforbuild
* Mon Mar  3 2003 lmuelle@suse.de
- add header files to samba package for squid, #24235
- remove rc_reset from status part of nmb init script
* Mon Feb 24 2003 lmuelle@suse.de
- update samba-vscan to version 0.3.2a
* Tue Feb 18 2003 lmuelle@suse.de
- add separate binaries to PreReq
- add /bin/grep to PreReq of the client package
- move README to client package and inform about the new doc package, #23838
- fix %%post in case of update
- fix nmb init script, #23854
* Mon Feb 17 2003 lmuelle@suse.de
- add appropriate suffix to example smb.conf of documentation
- add example to auto mount or umount CD drive to smb.conf
- add -s ${SMB_CONF} to all startproc calls in init scripts
* Fri Feb 14 2003 lmuelle@suse.de
- call SuSEconfig -module samba if packages with binaries are installed via rpm
- only insserv nmb depending on an active smb service, if we update from a
  version before SuSE Linux 8.1
- add meta data to sysconfig file
- add appropriate suffix to README
- update samba-vscan to version 0.3.2
- split libsmbclient and libsmbclient-devel package from samba-client
- add msdfsproxy and ldaprebind patches from Guenther Deschner <gd@suse.de>
* Wed Jan 29 2003 kukuk@suse.de
- Remove samba-doc requires from samba-client
* Wed Jan 15 2003 ro@suse.de
- use fPIC in samba-vscan
* Wed Jan 15 2003 ro@suse.de
- use sasl2
* Wed Jan 15 2003 ro@suse.de
- added logrotate config
- added patch to work around glibc defining st_atime as macro
* Fri Dec 13 2002 ro@suse.de
- updated neededforbuild
* Thu Dec 12 2002 lmuelle@suse.de
- update samba to version 2.2.7a
- update samba-vscan to version 0.3.1
- move tdb tools to client package
- move smbldap-tools from examples/LDAP to a new package
- move samba.schema to /etc/openldap/schema
* Fri Nov 22 2002 lmuelle@suse.de
- fix some broken literals in samba-svan and nettime
- split documentation to samba-doc subpackage
- move provides smbfs to samba-client package
* Wed Nov 20 2002 lmuelle@suse.de
- update samba to version 2.2.7; this includes the security fix for the
  broken password length handling
- update samba-vscan to version 0.3.0
- remove superfluous aclocal, autoconf and libtoolize calls
* Fri Nov  8 2002 lmuelle@suse.de
- use rc_exit, not exit at the end of the smbfs init script, #21641
* Wed Nov  6 2002 lmuelle@suse.de
- remove check and Required-Start for nmb in smbfs init script, #20793
  move nmb from Required-Start to X-UnitedLinux-Should-Start
  add section about smbfs and nmb service to README.SuSE
- add fix for s390 interface handling, #15717
* Tue Nov  5 2002 lmuelle@suse.de
- add security fix for wrong passwd len handling
* Fri Oct 18 2002 lmuelle@suse.de
- update to version 2.2.6
* Thu Oct 17 2002 lmuelle@suse.de
- generate version suffix UL or SuSE as required from Samba team
* Wed Oct 16 2002 lmuelle@suse.de
- add improved ACL mapping patch, #19494
- remove check_nmbd and rc_reset from smb init script status part, #20921
- also remove check_nmbd from winbind and smbfs init scripts
* Tue Oct  8 2002 lmuelle@suse.de
- add improved ACL mapping patch, #19494
- set syslog = 0, log level = 1 in smb.conf, #20411
- switch to RFC 3330 conform example IP addresses in smb.conf
- remove character set and client code page from smb.conf, #20378
* Thu Sep 26 2002 ro@suse.de
- remove hang in smbfs init script (#20204)
* Wed Sep 25 2002 agruen@suse.de
- WinNT compatibility fix in the improved ACL mapping
* Mon Sep 23 2002 lmuelle@suse.de
- add ACL mapping fixes from Andreas Gruenbacher <agruen@suse.de>
- put SAM related binaries in extra subdirectories
- set TMPDIR to /var/tmp in smb init script
- create classic and ldap sudirectories for the binaries to get usual
  process names
- remove runlevel 2 from Default-Start of smbfs; add nmb to Required-Start
- warn if nmbd is not running while start of smb, smbfs and winbind
- drop rcsamba
* Thu Sep 12 2002 lmuelle@suse.de
- add missing user information if nmbd is reloaded
- add root to write list of print$ in default smb.conf
* Wed Sep 11 2002 lmuelle@suse.de
- add check for ready cupsd if CUPS is active and Samba using CUPS as
  printing system
- remove ACL fixes, #19494
* Wed Sep 11 2002 lmuelle@suse.de
- add winbind to X-UnitedLinux-Should-Start of smb init script
* Tue Sep 10 2002 lmuelle@suse.de
- intergrate ACL fixes from Andreas Gruenbacher <agruen@suse.de>
- split smb in two (smb and nmb) init scripts
- fix Required-Start of smb and winbind init script
- include most parts of two mostly printing related pre 2.2.6 patches
* Mon Sep  9 2002 lmuelle@suse.de
- check existence of brlock and locking tdb, #18978
- include tdbdump, tdbtest, tdbtool, tdbtorture
- change smb and winbind init script, #18784
* Mon Sep  2 2002 lmuelle@suse.de
- let SuSEconfig.samba use correct lib subdirectory, #18730
- include printing patch for 2.2.5 from Samba team
- let smb and winbind init script also recognize daemons started before
  an update of the package; workaround for #18784
- include netttime program, #6508
* Fri Aug 30 2002 lmuelle@suse.de
- replace wrong, left variable in %%post of samba by filename
* Wed Aug 28 2002 lmuelle@suse.de
- make reload of smbfs init script equal to restart
- remove Should-Start smb in smbfs init script
- create ntadmin group in %%pre of samba
- adjust permission and ownership of /var/lib/samba/drivers
* Wed Aug 21 2002 lmuelle@suse.de
- fix start of smbfs init script; introduce /etc/samba/smbfstab, #7146
- reinclude lost pdbedit and man page, now part of the client package
- move cupsd to Should-Start in smb, also smb and remove $remote_fs from
  Required-Start in smbfs init script
- rename sysconfig.samba-samba-client to sysconfig.samba-client and use
  fillup_only with -ans due to usage in a subpackage
- force LDAP protocol version 3 during connection establishment
* Tue Aug 20 2002 lmuelle@suse.de
- add missing PreReq to samba and samba-client, #17979, #17980
- fix status of smbfs init script, #9092
* Mon Aug 19 2002 lmuelle@suse.de
- fix path to temp file in %%post of samba
- fix %%post of samba-client, rename sysconfig.samba to
  sysconfig.samba-samba-client
* Mon Aug 19 2002 lmuelle@suse.de
- drop the split in classic and ldap version; introduce etc/sysconfig/samba
  and SuSEconfig.samba instead to get the appropriate binaries, #17691
* Fri Jul 26 2002 gd@suse.de
- fixed /usr/share/samba in %%files
- moved libsmbclient libraries to samba-client
* Fri Jul 19 2002 gd@suse.de
- added rediffed start_tls-fix from cvs
- enabled challenge-response-auth for winbind
- removed all references to rc.config
- made cups default printing system for SuSE Linux 8.1
* Thu Jul 18 2002 link@suse.de
- updated to samba-vscan-0.2.5d
  - - bugfix for F-Prot Daemon and ScannerDaemon
  - - added a sanity check for "grepping" the virus name from
    the output of ScannerDaemon and F-Prot Daemon
  - - init message has been changed when module is loaded
  - - added Makefile fix for x86-64 by Ulricht Hecht
* Tue Jul 16 2002 uli@suse.de
- link PIC objects into examples/VFS stuff (fixes x86-64)
* Tue Jul 16 2002 kukuk@suse.de
- Don't use macros for Version:
* Mon Jul 15 2002 gd@suse.de
- update to version 2.2.5 (mainly done by Lars Mueller <lmuelle@suse.de>)
- added samba-vscan 0.2.5a as subpackage
- link against acl and attr library
- added winbind-init script, rewrote smb-init script
- updates, clean-ups in smb.conf and more examples
- added patch for pdbedit to handle script based LDAP account creation
  and make deletion of only SAM LDAP entries possible and added a -b option
  for pdbedit to allow stdin password changes (patch by lmuelle@suse.de)
- fixed smbadduser script patch (bug #15562)
- split the samba-package into a classic and a ldap-version:
  thus you need in either case samba/samba-client, then you choose
  between samba-classic/samba-classic-client for the common smbpasswd-backend
  or samba-ldap/samba-ldap-client to support the ldapsam-backend.
- added README.SuSE
- added link to make using_samba accessible from swat
- no sgid for printer-drivers-dir
* Fri Jun 14 2002 meissner@suse.de
- rerun auto* tools, use -mminimal-toc on ppc64.
* Fri Mar  8 2002 kukuk@suse.de
- Add libsmbclient.so.0 and /usr/share/samba to filelist
* Thu Feb 14 2002 adrian@suse.de
- install needed header file for libsmbclient.so
* Sun Feb 10 2002 kukuk@suse.de
- Don't test for -fpic if PICFLAG is already set
* Thu Feb  7 2002 lmuelle@suse.de
- Update to 2.2.3a, minor bugfix release
* Thu Feb  7 2002 lmuelle@suse.de
- Update to 2.2.3
- Fix smbsh library search path
- Removed 'kernel oplocks = No' from smb.conf; default is yes
- Include pam_smbpass, syslog, utmp, and winbind support
- Include libsmbclient
- Include findsmb
* Tue Jan  8 2002 egmont@suselinux.hu
- Cosmetical changes in init scripts
* Thu Dec 20 2001 ro@suse.de
- removed START_SMB and added insserv_macros
* Sat Sep 22 2001 lmuelle@suse.de
- Shorten output and tunig of old configuration files handling
  - Include SID and secrets files to old configuration files handling
  - Move netlogon and profiles directories to /var/lib/samba
  - Move smbpasswd binary and man page to samba-client package
  - Introduce additional sym link from /etc/init.d/smb to rcsamba due to
  too many typos and cleaner systematic
  - Add character set = ISO8859-15 and client code page = 850 to smb.conf
  in the global section to enable correct UNIX <-> DOS character
  mapping for west European languages
  - Change create mask of home section to 0640, directory mask to 0750;
  change create mask of printers section to 0600 in smb.conf
  - Move path of printers section to /var/tmp
* Fri Aug 24 2001 lmuelle@suse.de
- Move all configuration files to /etc/samba
- Move data bases to /var/lib/samba; important, cause boot script
  cleans up /var/lock/samba
- Move pid files to /var/run/samba
- Link against cups library
- Use build root
- Rename subpackage smbclnt to samba-client
- Move /usr/share/doc/packages/samba to package samba-client
- Move /usr/lib/samba/scripts to /usr/share/samba/scripts
- Move /usr/lib/samba/codepages to /usr/share/samba/codepages
- Move /usr/lib/samba/swat to /usr/share/samba/swat
- Move /usr/lib/samba/VFS/* to /usr/lib/samba
- Remove smb.conf from package samba, kept in samba-client
- Remove redundant html documentation of man pages
- Remove superfluous install and uninstall scripts
- Add example configuration file /etc/samba/smbusers
- Update to 2.2.1a: fixes bug with too strict name handling while adding
  a machine into a domain
- Update to 2.2.1: add pam password changing and pam restrictions code;
  printer driver management improvements (delete driver); fix for Samba
  running on top of Linux VFAT ftruncate bug
* Tue Aug 14 2001 ro@suse.de
- Don't use absolute paths to PAM modules in PAM config files
* Tue Jun 26 2001 ro@suse.de
- re-added the libtoolize to make it build
* Tue Jun 26 2001 lmuelle@suse.de
- Update to 2.2.0a fixes remote file create/ append bug. This may
  only happen by '%%m' macro usage for the 'log file' command.
- spec and dif cleanup
- Include VFS module support.
* Wed Jun 13 2001 ro@suse.de
- fix to build with new autoconf
* Wed May 30 2001 ro@suse.de
- config-dist.sh: accept any kernel version on s390
* Thu May 10 2001 bodammer@suse.de
- initscript fix: don't start smbd in runlevel 2 [bug #8046]
- some additional files included to doc (COPYING, README, ..)
* Wed May  9 2001 uli@suse.de
- bzipped tarball
* Tue May  8 2001 schwab@suse.de
- Don't use _syscallX.
* Mon Apr 30 2001 ro@suse.de
- added config-dist.sh to build only on 2.4 machines
  (samba configure seems braindead enough to check
  the running kernel)
* Mon Apr 30 2001 ro@suse.de
- removed kerberos support: does not work as expected
* Tue Apr 24 2001 lemsi@suse.de
- for 7.2 we have added some kerbereos 5 support
* Tue Apr 24 2001 lemsi@suse.de
- new version samba 2.2
- new spec file with more functions for configure
- libnss_winbind.so support for /etc/nsswich.conf
* Wed Apr 18 2001 lemsi@suse.de
- new security fixes and version 2.0.8 for 6.3, 6.4, 7.0, 7.1
* Tue Apr 17 2001 lemsi@suse.de
- new rcsmb script
- include security fixes
* Fri Mar  9 2001 ro@suse.de
- don't mess with os_install_post
* Thu Feb 22 2001 ro@suse.de
- added readline/readline-devel to neededforbuild (split from bash)
* Wed Feb  7 2001 schwab@suse.de
- Fix LFS support in client.
* Mon Feb  5 2001 schwab@suse.de
- Compile with -D_GNU_SOURCE and -D_LARGEFILE64_SOURCE to get missing
  declarations.
- Include <sys/types.h> when checking for ino64_t.
- Include <crypt.h> for crypt declaration.
* Wed Jan 31 2001 lemsi@suse.de
- added codepages in smbclnt-subpackage
- changed german coments to english coments
* Wed Jan  3 2001 lemsi@suse.de
- changed in the share section the path /cd to /cdrom
- added smb.conf to the smbclnt-subpackage
* Tue Nov 28 2000 kukuk@suse.de
- Fix init scripts and move them to /etc/init.d
- Fix post/postun section for subpackages
* Fri Nov 24 2000 bodammer@suse.de
- rcscript update
* Mon Aug 28 2000 choeger@suse.de
- changed $* to "$@" in mount.smbfs to make it also
  possible to mount shares with spaces
* Mon Jul 31 2000 choeger@suse.de
- improvement for rcsmb
- fix for spec-file to compile with NIS netgroups
* Thu Jul 20 2000 choeger@suse.de
- added smbfs initscript that has been removed
  by an error
* Tue Jul 11 2000 choeger@suse.de
- split package into client and server parts
  client package name: smbclnt
* Wed Apr 26 2000 choeger@suse.de
- new version, 2.0.7
* Thu Apr  6 2000 ro@suse.de
- removed pam,cracklib from neededforbuild: build handles this
* Wed Apr  5 2000 bk@suse.de
- s390 team added config.{sub,guess} update macro for s390
* Mon Mar 27 2000 choeger@suse.de
- fixed bug in specfile
  the multilined configure call missed a "\" :-(
* Thu Mar  9 2000 choeger@suse.de
- fixed typo in specfile
* Wed Mar  1 2000 choeger@suse.de
- added %%{_mandir}
* Tue Feb  8 2000 choeger@suse.de
- removed /sbin/init.d/smbfs because it is no longer needed
* Mon Jan  3 2000 choeger@suse.de
- bugfix for ipc.c
  to make roaming profiles work again.
* Tue Nov 30 1999 choeger@suse.de
- changed kernel oplocks = off to
  kernel oplocks = false
* Tue Nov 16 1999 choeger@suse.de
- added kernel oplocks = off in smb.conf
* Fri Nov 12 1999 choeger@suse.de
- new version, 2.0.6
* Fri Nov  5 1999 choeger@suse.de
- Fix for the smbmount lost-connection problem
  _seems_ to work...
* Fri Oct 29 1999 choeger@suse.de
- removed comment sign in /etc/inetd.conf for swat
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Tue Aug 10 1999 fehr@suse.de
- set execute permissions for mksmbpasswd.sh and changesmbpasswd.sh
* Thu Jul 29 1999 fehr@suse.de
- fixed typo in /sbin/init.d/smbfs
* Thu Jul 22 1999 fehr@suse.de
- changed to new version 2.0.5a
* Wed Jul 21 1999 fehr@suse.de
- changed to new version 2.0.5
* Tue Jul 20 1999 fehr@suse.de
- install /sbin/init.d/smbfs
- changed to new version 2.0.5pre4
* Mon Jul 19 1999 fehr@suse.de
- add /sbin/init.d/smbfs
- changed to new version 2.0.5pre3
* Fri Jul  2 1999 fehr@suse.de
- removed "umount -a -t smbfs" from start sscript
* Tue Jun 22 1999 kukuk@suse.de
- 2.0.4b changed default values, enable PAM again
* Fri Jun 18 1999 kukuk@suse.de
- changed to new version 2.0.4b
* Mon Jun 14 1999 kukuk@suse.de
- Enable PAM, add samba.pamd
* Mon May  3 1999 fehr@suse.de
- add umount -a -t smbfs to shutdown sequence of samba
* Thu Mar 11 1999 ro@suse.de
- smbmount: define NR_OPEN to 1024 if undefined (GLIBC-2.1)
* Wed Mar 10 1999 choeger@suse.de
- some enhancements for smb.conf
* Wed Mar 10 1999 choeger@suse.de
- new version 2.0.3 and smbmount now seems to work
* Tue Mar  9 1999 ro@suse.de
- use samba-2.0.2 for STABLE
- use smbfs-2.1 with kernel 2.2.2
* Sun Feb 28 1999 ro@suse.de
- for glibc-2.1 strncat uses strcat for one subcase, so don't
  redefine strcat to "ERROR" for glibc-2.1
* Mon Feb 15 1999 fehr@suse.de
- fix for umount problem from Volker
* Tue Feb  9 1999 fehr@suse.de
- changed to version 2.0.2 of samba
* Fri Jan 15 1999 bs@suse.de
- replaced /sbin/init.d/smb with newer style version (again)
* Fri Jan 15 1999 fehr@suse.de
- switched to new version 2.0.0
* Wed Jan 13 1999 bs@suse.de
- fixed entry in inetd.conf
* Wed Jan 13 1999 bs@suse.de
- replaced /sbin/init.d/smb with newer style version
* Mon Jan 11 1999 vl@suse.de
- make 2.0.0beta5 package of samba
* Mon Aug 24 1998 vl@suse.de
- changed to version 1.9.18p10
* Mon Jun 29 1998 vl@suse.de
- changed to version 1.9.18p8
* Mon Apr 20 1998 vl@suse.de
- changed to version 1.9.18p4
* Thu Feb 19 1998 vl@suse.de
- changed to version 1.9.18p3
* Tue Feb  3 1998 vl@suse.de
- changed to version 1.9.18p2
- fixed some problems in spec-file, some files were missing :-(
- fixed smbfs-2.0.2/Makefile.Linux
* Tue Jan 13 1998 vl@suse.de
- changed to version 1.9.18p1
* Fri Jan  9 1998 vl@suse.de
- changed to version 1.9.18
* Tue Dec  2 1997 bs@suse.de
- disable samba by default in /etc/rc.config
* Mon Oct  6 1997 fehr@suse.de
- package prepared for automatic building
* Mon Sep 29 1997 fehr@suse.de
- updated to version 1.9.17p2 due to security hole.
* Wed Jul 16 1997 fehr@suse.de
- add fillup-template for rc.config and install it in doinst.sh
* Fri Jun 27 1997 bs@suse.de
- update to smbfs-2.0.2, due to security hole.
* Tue Jun 17 1997 fehr@suse.de
- changed init-skript to recognize entry START_SMB of rc.config
* Mon Jun  2 1997 vl@suse.de
- update to version 1.9.16p11
- Starting Samba from /sbin/init.d, not from inetd.conf
* Sun Feb  2 1997 vl@suse.de
- update to version 1.9.16p10
- Adapted /etc/smb.conf.sample to 4.4.1 manual
* Thu Jan  2 1997 florian@suse.de
- update to version 1.9.16p9
- configuration file is now /etc/smb.conf
- smbd and nmbd are now in /usr/sbin
- added start-script /sbin/init.d/smb and entry in /etc/rc.config
* Thu Jan  2 1997 florian@suse.de
- Update auf neue Version 1.9.16p6.
