#
# spec file for package cpupower
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define maindir tools/power/cpupower
%define tsdir tools/power/x86/turbostat
%define pbdir tools/power/x86/x86_energy_perf_policy
%define ssdir tools/power/x86/intel-speed-select
%define krl_chlg %(rpm -q --changelog kernel-source |head -n2)
%define krl_cmt  %(rpm -q --changelog kernel-source |grep -m1 "^- commit [0-9a-f]*")
# Use this as version when things are in mainline kernel
%define version %(rpm -q --qf '%%{VERSION}' kernel-source)
%define release %(rpm -q --qf '%%{RELEASE}' kernel-source)
Name:           cpupower
Version:        %{version}
Release:        150600.4.6.6
Summary:        Tools to determine and set CPU Power related Settings
License:        GPL-2.0-only
Group:          System/Base
URL:            https://git.kernel.org/cgit/linux/kernel/git/rafael/linux-pm.git
Patch1:         cpupower_fix_library_so_name.patch
Patch3:         cpupower_exclude_kernel_Makefile.patch
Patch6:         amd_do_not_show_amount_of_boost_states_if_zero.patch
BuildRequires:  gettext-tools
BuildRequires:  kernel-source
BuildRequires:  libcap-devel
BuildRequires:  libnl-devel
BuildRequires:  pciutils
BuildRequires:  pciutils-devel

%description
This tool accesses the Linux kernel's processor power subsystems
like CPU frequency switching (cpufreq) or CPU sleep states (cpuidle).
Kernel changelog:
%krl_chlg
...
%krl_cmt

%package -n libcpupower1
Summary:        Processor power related C-library
Group:          System/Libraries

%description -n libcpupower1
Contains libcpupower which offers easy functions to access
processor frequency, processor idle, processor power hierarchy
and other CPU power consumption related information.

%package devel
Summary:        Include files for libcpupower
Group:          Development/Languages/C and C++
Requires:       libcpupower1 = %{version}

%description devel
Include files for C/C++ development with libcpupower.

%package bench
Summary:        CPU frequency micro benchmark
Group:          System/Benchmark

%description bench
This benchmark helps to test the condition of a given kernel cpufreq
governor (e.g. ondemand, userspace, conservative) and the cpufreq HW driver
(e.g. powernow-k8, acpi-cpufreq, ...).
For that purpose, it compares the performance governor to a configured
powersave module.

%package bash-completion
Summary:        Bash completion for cpupower
Group:          System/Shells
Requires:       %{name}
Requires:       bash-completion
Supplements:    (%{name} and bash-completion)
BuildArch:      noarch

%description bash-completion
bash command line completion support for cpupower.

%package rebuild
Summary:        Empty package to ensure rebuilding cpupower in OBS
Group:          System/Monitoring
%requires_eq    kernel-source

%description rebuild
This is empty package that ensures cpupower is rebuilt every time
kernel-default is rebuilt in OBS.

There is no reason to install this package.

%lang_package

%prep
# copy necessary files from kernel-source since we need to modify them
(cd %{_prefix}/src/linux ; tar -cf - COPYING CREDITS README tools include scripts Kbuild Makefile arch/*/{include,lib,Makefile} lib) | tar -xf -
chmod +x tools/power/cpupower/utils/version-gen.sh
%patch1 -p1
cd %{maindir}
%patch3 -p1
%patch6 -p1

%build
CONF="PACKAGE_BUGREPORT=https://bugs.opensuse.org mandir=%{_mandir} libdir=%{_libdir} CPUFRQ_BENCH=true"
export CFLAGS="%{optflags} -fcommon"
%make_build -C %{maindir} $CONF

%ifarch %{ix86} x86_64
%make_build -C %{tsdir}
%make_build -C %{pbdir}
%make_build -C %{ssdir}
%endif

%install
CONF="PACKAGE_BUGREPORT=https://bugs.opensuse.org mandir=%{_mandir} libdir=%{_libdir} CPUFRQ_BENCH=true DESTDIR=%{buildroot} sbindir=%{_sbindir} docdir=%{_docdir}/%{name} confdir=%{_sysconfdir}"
%make_install -C %{maindir} $CONF

%ifarch %{ix86} x86_64
%make_install -C %{tsdir}
%make_install -C %{pbdir}
%make_install -C %{ssdir}
%endif

# copy to examples doc dir to avoid complains from the build
# system about an executable in the doc dir.
mkdir -p %{buildroot}/%{_docdir}/%{name}/examples
mv %{buildroot}//%{_docdir}/%{name}/cpufreq-bench_script.sh %{buildroot}/%{_docdir}/%{name}/examples

%find_lang %{name}

%ldconfig_scriptlets -n libcpupower1

%files
%{_mandir}/man1/cpupower*%{?ext_man}
%{_bindir}/cpupower
%ifarch %{ix86} x86_64
%{_mandir}/man8/turbostat*%{?ext_man}
%{_bindir}/turbostat
%{_mandir}/man8/x86_energy_perf_policy*%{?ext_man}
%{_bindir}/x86_energy_perf_policy
%{_bindir}/intel-speed-select
%endif

%files bench
%config %{_sysconfdir}/cpufreq-bench.conf
%{_sbindir}/cpufreq-bench
%{_bindir}/cpufreq-bench_plot.sh
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/examples
%{_docdir}/%{name}/examples/cpufreq-bench_script.sh
%{_docdir}/%{name}/README-BENCH

%files -n libcpupower1
%{_libdir}/libcpupower*.so.*

%files devel
%{_includedir}/*.h
%{_libdir}/libcpu*.so

%files bash-completion
%dir %{_datadir}/bash-completion
%dir %{_datadir}/bash-completion/completions
%{_datadir}/bash-completion/completions/cpupower

%files lang -f %{name}.lang

%files rebuild
%license COPYING

%changelog
* Mon Jul 21 2025 trenn@suse.de
- Show the first 2 lines of kernel-source sources we build against
  in the package description.
  Also show the latest git hash commit ID there to be able to track
  the exact sources the package has been built against.
  This is essential to be able to determine the exact
  sources (from kernel-source) the tools are built against.
* Fri Mar  7 2025 trenn@suse.de
- For latest changelog entries, please look up the changelog of
  a kernel-FLAVOR or kernel-source with the exact same version and
  release build number.
  rpm -q --changelog kernel-source |grep "turbostat\|intel-speed-select|cpupower"
* Wed Mar 13 2024 trenn@suse.de
- Source version of cpupower tools from kernel sources:
  cpupower #6feb1a9641197ee630bf43b5c34ea1d9f8b4a0aa
  turbostat 2023.11.07 #b8337e6a780dad9505f9d44da07c0a5c52fa0a04
  intel-speed-select 1.18 #a590ed62269a049a72484ce617fe2f34e2da66cf
* Mon Nov 20 2023 trenn@suse.de
- Fix library file version: libcpupower.so.0.0.1 -> libcpupower.so.1.0.1
  (bsc#1217044)
  A cpupower_fix_library_so_name.patch
* Wed Nov 15 2023 bjorn.lie@gmail.com
- Rename libcpupower0 to libcpupower1 following changes in SONAME.
- Use ldconfig_scriptlets macro for post(un) handling.
* Sun Mar  5 2023 trenn@suse.de
- Add wildcard for powercap.h since powercap patches have reached mainline
- Build bash-completion noarch
* Fri Oct 21 2022 dimstar@opensuse.org
- clean up sources: drop rapl_monitor.patch and
  cpupower_rapl.patch.
* Fri Oct  7 2022 gmbr3@opensuse.org
- Move bash-completion to subpackage so it isn't installed when
  not needed
* Tue Jul  5 2022 trenn@suse.de
- Remove powercap capabilities to patch againt latest kernel sources
  - > still keep the patches, will be removed after trying to get this
    mainline
- Add netlink (libnl-devel) requires
* Fri Apr  8 2022 dmueller@suse.com
- add rebuild subpackage to trigger rebuild on kernel updates
* Fri Feb 18 2022 gmbr3@opensuse.org
- Change to building the package from kernel-source based on
  how the perf package works
- Removed patches:
  * turbostat_makefile_fix_asm_header.patch
  * remove_bits_h.patch
  * x86_perf_makefile_fix_asm_header.patch
- Remove all tarballs and git script
- Use %%lang_package
- Correct ix86 to %%ix86
* Mon Jul 19 2021 trenn@suse.de
- Update (jsc#SLE-18392, jsc#SLE-18906, jsc#SLE-18393, jsc#SLE-18410):
  * turbostat          to    21.05.04
  * intel speed select to    1.10
  * cpupower           to    5.14-rcX (kernel sources state)
- Already upstream and included in the update:
  D intel-speed-select_remove_DATE_TIME.patch
- SLE patches for jsc#SLE-17797 dropped (in fact never been applied to factory),
  due to inclusion in upstream version:
  cpupower-Add-CPUPOWER_CAP_AMD_HW_PSTATE-cpuid-caps-flag.patch
  cpupower-Condense-pstate-enabled-bit-checks-in-decode_pstates.patch
  cpupower-Update-family-checks-when-decoding-HW-pstates.patch
  cpupower-Remove-family-arg-to-decode_pstates.patch
  cpupower-Correct-macro-name-for-CPB-caps-flag.patch
  cpupower-Update-msr_pstate-union-struct-naming.patch
  cpupower-Add-cpuid-cap-flag-for-MSR_AMD_HWCR-support.patch
  cpupower-Remove-unused-pscur-variable.patch
* Thu Nov 12 2020 trenn@suse.de
- Add AMD Fam 19h support (bsc#1177394)
- Update turbostat to latest version 20.09.30 including:
  * jsc#SLE-13412, jsc#SLE-13174 (rocket lake support)
  * jsc#SLE-13448 (Alder Lake support)
  * jsc#SLE-13348, jsc#SLE-13171 (Sapphire Rapid support)
  * Support AMD Fam 19h
- Touched patches:
  Deleted mainline integrated patches:
  D    Correction-to-manpage-of-cpupower.patch
  D    cpupower-Revert-library-ABI-changes-from-commit-ae2917093fb60bdc1ed3e.patch
  Patches refreshed:
  M    rapl_monitor.patch
  M    turbostat_makefile_fix_asm_header.patch
* Thu Oct 15 2020 trenn@suse.de
- Update intel-speed-select to version 1.6 (jsc#SLE-13334)
* Wed Jun 17 2020 info@paolostivanin.com
- Add -fcommon to allow building against GCC10
* Tue May 19 2020 trenn@suse.de
- Update to latest:
  turbostat 20.03.20
  intel-speed-select 1.3  (bsc#1171810)
  verions
- Adjust needed kernel and userspace requirements in:
  cpupower_export_tarball_from_git.sh
  and
  BuildRequires: libcap-devel
  A remove_bits_h.patch
* Thu Mar  5 2020 trenn@suse.de
- Do not show 0 boost states if boost states are supported, but could
  not be read from PCI registers.
  bsc#1165712, bsc#1164983
  A amd_do_not_show_amount_of_boost_states_if_zero.patch
* Thu Jan 30 2020 trenn@suse.de
- Add mainline patch with proper patch header and filename:
  D libcpupower_fix_api_cpufreq_get_frequencies_breakage.patch
  A cpupower-Revert-library-ABI-changes-from-commit-ae2917093fb60bdc1ed3e.patch
- Fix manpage (bsc#1162142)
  A Correction-to-manpage-of-cpupower.patch
* Thu Nov 28 2019 trenn@suse.de
- Update intel-speed-select to latest 5.5-rc1 kernel version
  latest mainline commit:
  commit b3abfd778bf1dbdd
- Update cpupower to latest 5.5-rc1 kernel version
  latest mainline commit:
  commit 4611a4fb0cce3
  Fixes aperf/mperf monitoring on latest AMD Rome CPUs (bsc#1152967)
- Fix library API breakage (bsc#1154240)
  A libcpupower_fix_api_cpufreq_get_frequencies_breakage.patch
* Tue Oct 29 2019 trenn@suse.de
- Update turbostat to latest version 19.08.31
* Wed Jul 17 2019 trenn@suse.de
- Add intel-speed-select tool (jsc#SLE-5364)
  A intel-speed-select-1.0.tar.bz2
  A intel-speed-select_remove_DATE_TIME.patch
- Fix missing governors when running cpupower frequency-info (bsc#1117709)
  M rapl_monitor.patch
* Wed Jun  5 2019 trenn@suse.de
- jira#5244 Turbostat for Ice Lake
- Remove very old cpufrequtils provides and requires (predecessor)
- Update libcpupower description
- Sidenote about fate#321274 - This feature is on the kernel side
  and got wrongly mentioned in cpupower in a released product.
* Mon Apr  8 2019 trenn@suse.de
- Update to latest kernel HEAD sources
  (5.1-rc4, 15ade5d2e7775667cf191cf2f94327a4889f8b9d)
  Patches included mainline:
  D cpupower_fix_compilation_and_sysfs_read_file_mess.patch
  D cpupower_bash-completion_for_cpupower_tool.patch
  Adjusted patches:
  M turbostat_makefile_fix_asm_header.patch
  M x86_perf_makefile_fix_asm_header.patch
  M rapl_monitor.patch
  M cpupower_rapl.patch
* Thu Dec  6 2018 jengelh@inai.de
- Description updates.
* Thu Dec  6 2018 idonmez@suse.com
- Run spec-cleaner
- Don't disable as-needed, it works now.
* Tue Dec  4 2018 trenn@suse.de
- Add bash completion for cpupower command (from mainline submit)
  A cpupower_bash-completion_for_cpupower_tool.patch
* Tue Oct 16 2018 trenn@suse.de
- Fix static compilation and sysfs_read_file mess
  A cpupower_fix_compilation_and_sysfs_read_file_mess.patch
* Mon Oct  1 2018 trenn@suse.de
- Updating to latest 4.19(-rc6) kernel sources
  Turbostat is increased to version 18.07.27 by this
  Patches which got deleted because they are now mainline:
  D    turbostat_decode_MSR_IA32_MISC_ENABLE_only_on_Intel.patch
  D    turbostat_fix_man_perm.patch
  D    x86_perf_fix_man_permissions.patch
* Thu Jan 11 2018 trenn@suse.de
- Update cpupower to latest kernel version (version name 4.15, but
  checked out against latest kernel tag 4.15-rc7. There will not
  be important changes any more, maybe a fix).
- cpu online/offline fixes
- This is the first cpupower package (with updated version) which
  includes x86_energy_perf_policy binary.
  This is important for later package dependencies, namely tuned.
  A cpupower_exclude_kernel_Makefile.patch
* Tue Jan  9 2018 trenn@suse.de
- Add x86_energy_perf_bias tool
  This is a tool which is, same as turbostat, located in kernel sources here:
  tools/power/x86/
  A x86_energy_perf_policy-17.05.11.tar.bz2
  A x86_perf_fix_man_permissions.patch
  A x86_perf_makefile_fix_asm_header.patch
* Fri Oct 20 2017 trenn@suse.de
  fate#321274
- Provide rapl domain info (cpupower powercap-info cmd)
  * Add: cpupower_rapl.patch
- Provide rapl power monitoring
  * Add: rapl_monitor.patch
* Fri Oct  6 2017 josef.moellers@suse.com
- Added missing references.
  [bsc#1041332,bsc#996052,bsc#976983]
* Thu Oct  5 2017 jengelh@inai.de
- Rectify RPM groups. Replace old $RPM_ shell variables by macros.
  Apply consistent styling to macros.
* Thu Oct  5 2017 josef.moellers@suse.com
- Enter decode_misc_enable_msr() only if genuine_intel.
  [bsc#1048546,
  turbostat_decode_MSR_IA32_MISC_ENABLE_only_on_Intel.patch]
* Wed May  3 2017 trenn@suse.de
- Update to latest mainline sources
- turbostat changed versioning scheme (we now have version 17.04.12)
* Wed Mar 22 2017 trenn@suse.de
- Update cpupower and turbostat to latest kernel v4.10 sources
  D library_cleanup.patch
- Change .c file header file modification, modify in Makefile instead:
  D turbostat_set_asm_header_fixed.patch
  A turbostat_makefile_fix_asm_header.patch
- fate #320908: KBL: Turbostat for KBL H/S & U/Y
- fate #321191: [KNL] turbostat reports to report corect MSR_TURBO_RATIO_LIMIT
  information
- fate #321193: [KNL] turbostat should report correct cpu clock values for
  Knights Landing
- fate #321285: turbostat support for Skylake-SP server
- fate #321286: turbostat support for Harrisonville (Denverton SoC)
- fate #321925: [HPC, KNM, kernel] turbostat support
* Thu Apr 28 2016 trenn@suse.de
- Update turbostat to version 4.12
- Update cpupower to latest sources
- Let turbostat only build against a local msr-index.h
  Also add the msr-index.h export to the tarball from git repo script
  * Delete make_header_file_passable_from_outside.patch
* Wed Apr 20 2016 trenn@suse.de
- Add cpuidle functions to public libcpupower
  * Add library_cleanup.patch
* Tue Jan 26 2016 trenn@suse.de
- Move from kernel version to turbostat internal version for turbostat
- Add latest turbostat sources (latest git commit: 30f05309bde492)
- Adds Skylake, Broadwell and Knights Landing support for turbostat
  (fate#319798, fate#319183, fate#319516)
* Wed Jan  6 2016 jdelvare@suse.com
- Drop dead link.
- Fix Obsoletes statement, cpufrequtils package versions were
  greater than cpupower package versions so we must obsolete all
  versions of cpufrequtils.
* Wed Jan 28 2015 trenn@suse.de
- Make sources also build against 13.1 and older by providing
  asm-index.h which is included in linux-glibc-devel in newer
  distributions
  * Add turbostat_set_asm_header_fixed.patch
* Wed Jan 28 2015 trenn@suse.de
- Update cpupower and turbostat to latest git kernel HEAD version
  this currently is 3.19-rc6, but it is expected that there are no
  changes anymore and the version gets named 3.19 already.
  The patches are already included mainline and get removed from osc:
    cpupower_disable_by_latency.patch
    add_idle_manpages_in_Makefile.patch
    cpupower-always_try_to_load_msr_driver_as_root.patch
    cpupower-return_zero_on_success.patch
    cpupower-remove_mc_scheduler_bits.patch
* Wed Aug 13 2014 trenn@suse.de
- Fix cpupower_export_tarball_from_git.sh script and make sure msr-index.h
  is included in the turbostat tarball.
* Tue Aug 12 2014 trenn@suse.de
- Update turbostat to latest 3.17 kernel version (in fact it is 3.16-rc7)
  This fixes bnc#891523
* Tue Apr  1 2014 trenn@suse.de
- Do return 0 if cpupower info -b is called instead of the perf bias value
  which is already printed to stdout.
  Add cpupower-return_zero_on_success.patch
- Remove mc and smt scheduler knobs. These do not exist anymore in latest
  kernels for quite a while now.
  Add cpupower-remove_mc_scheduler_bits.patch
* Mon Mar 31 2014 trenn@suse.de
- If root, try to load msr driver on x86 if /dev/cpu/0/msr is not avail
  Add cpupower-always_try_to_load_msr_driver_as_root.patch
* Fri Mar 28 2014 trenn@suse.de
- Update to latest turbostat version (git 2d6e532279ddf30188d5fbd)
  bnc#866862, bnc#869071, bnc#869809
- Adjust MSR include path
  add make_header_file_passable_from_outside.patch
* Fri Mar 28 2014 trenn@suse.de
- Fix Makefile: Install latest cpupower-idle-* manpages
  Add add_idle_manpages_in_Makefile.patch
* Fri Mar 14 2014 trenn@suse.de
- Introduce idle state disable-by-latency and enable-all
  Part of fate#316611
  Add cpupower_disable_by_latency.patch
* Fri Feb 14 2014 trenn@suse.de
- turbostat is an x86 (in fact an Intel) only tool
  exclude it for other archs to fix building of the package there again
* Fri Jan 31 2014 trenn@suse.de
- Update cpupower to latest kernel version (3.13-rc7, rc7 missed out,
  there won't be any changes in cpupower anymore and obs does not like
  - rc7 in version tag.
- All patches are now included mainline, therefore:
  Drop cpupower_make_get_idlestate_count_unsigned.patch
  Drop cpupower_disable_cstates.patch
  Drop introduce_cpupower_idle_set.patch
  Drop cpupower-haswell_support.patch
  Drop cpupower_hsw_special.patch
- Add turbostat utility (fate#315666):
  Add turbostat-3.13.tar.bz2
  Add turbostat_fix_man_perm.patch
* Mon Jul  1 2013 trenn@suse.de
- Add disable C-state capability and support for latest Haswell CPUs
* Fri May 31 2013 varkoly@suse.com
- Fix spec to avoid conflict with cpufrequtils-devel
* Wed Feb 13 2013 trenn@suse.de
- Add Haswell support
* Wed Jan 23 2013 trenn@suse.de
- Update to kernel version 3.7
  * IvyBridge support integrated
* Tue Nov 13 2012 trenn@suse.de
- Rename SandyBridge monitor to IvyBridge if CPU is an IvyBridge
* Tue Nov 13 2012 trenn@suse.de
- Add ivy bridge processor (EP and EX) support
* Tue May  8 2012 trenn@suse.de
- Update to latest 3.4.rc6 kernel based version
* Wed Dec 21 2011 aj@suse.de
- Add cpupower_export_tarball_from_git.sh as source file.
* Tue Dec 20 2011 trenn@suse.de
- Add idle-info manpage
- Fix two bugs: memleak in idle-info and wrong idle state count
* Thu Dec 15 2011 trenn@suse.de
- Update to 3.2-rc5 version (not much changed, includes the
  use-manpage-on-help patch -> removed it)
- Change licence from GPL-2.0+ to GPL-2.0 to fit the kernel
  licence where sources are coming from
- Provide a tiny script to quickly export and tar sources from
  the git repo
* Thu Dec 15 2011 coolo@suse.com
- fix license to be in spdx.org format
* Sat Sep 17 2011 jengelh@medozas.de
- Remove redundant tags/sections from specfile
- Use %%_smp_mflags for parallel build
* Thu Aug 25 2011 trenn@suse.de
- Use manpages for help commands
* Mon May  2 2011 trenn@suse.de
- cpupower-bench obsoletes cpufrequtils-bench
* Thu Apr 21 2011 trenn@suse.de
- Initial commit of tools/power/cpupower directory from
  linux-next kernel repository
