/* Generated By:JJTree&JavaCC: Do not edit this line. StandardParser.java */
package org.apache.velocity.runtime.parser;
import org.apache.velocity.runtime.parser.node.*;


import java.io.*;
import java.util.*;
import org.apache.velocity.Template;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.*;
import org.apache.velocity.runtime.parser.node.*;
import org.apache.velocity.runtime.directive.*;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.RuntimeConstants;
import static org.apache.velocity.runtime.RuntimeConstants.SpaceGobbling;

import org.slf4j.Logger;

/**
 * This class is responsible for parsing a Velocity
 * template. This class was generated by JavaCC using
 * the JJTree extension to produce an Abstract
 * Syntax Tree (AST) of the template.
 *
 * Please look at the Parser.jjt file which is
 * what controls the generation of this class.
 *
 * @author <a href="mailto:jvanzyl@apache.org">Jason van Zyl</a>
 * @author <a href="mailto:geirm@optonline.net">Geir Magnusson Jr.</a>
 * @author <a href="hps@intermeta.de">Henning P. Schmiedehausen</a>
 * @version $Id$
*/
public class StandardParser implements/*@bgen(jjtree)*/ StandardParserTreeConstants,Parser, StandardParserConstants {/*@bgen(jjtree)*/
  protected JJTStandardParserState jjtree = new JJTStandardParserState();/**
     * Parser debugging flag.
     * When debug is active, javacc Parser will contain (among other things)
     * a trace_call() method. So we use the presence of this method to
     * initialize our flag.
     */
    private static boolean debugParser;
    static
    {
        try
        {
            StandardParser.class.getDeclaredMethod("trace_call", String.class);
            debugParser = true;
        }
        catch(NoSuchMethodException nsfe)
        {
            debugParser = false;
        }
    }

    /**
     * Our own trace method. Use sparsingly in production, since each
     * and every call will introduce an execution branch and slow down parsing.
     */
    public static void trace(String message)
    {
        if (debugParser) System.out.println(message);
    }

    /**
     * Keep track of defined macros, used for escape processing
     */
    private Map macroNames = new HashMap();

    /**
     * Current template we are parsing.  Passed to us in parse()
     */
    public Template currentTemplate = null;

    /**
     * Set to true if the property
     * RuntimeConstants.RUNTIME_REFERENCES_STRICT_ESCAPE is set to true
     */
    public boolean strictEscape = false;

    /**
     * Set to true if the propoerty
     * RuntimeConstants.PARSER_HYPHEN_ALLOWED is set to true
     */
    public boolean hyphenAllowedInIdentifiers = false;

    VelocityCharStream velcharstream = null;

    private RuntimeServices rsvc = null;

    @Override
    public RuntimeServices getRuntimeServices()
    {
        return rsvc;
    }

    private Logger log = null;

    /**
     * This constructor was added to allow the re-use of parsers.
     * The normal constructor takes a single argument which
     * an InputStream. This simply creates a re-usable parser
     * object, we satisfy the requirement of an InputStream
     * by using a newline character as an input stream.
     */
    public StandardParser( RuntimeServices rs)
    {
        /*
         * need to call the CTOR first thing.
         */

        this(   new VelocityCharStream(
                new ByteArrayInputStream("\u005cn".getBytes()), 1, 1 ));

        /*
         * then initialize logger
         */

         log = rs.getLog("parser");


        /*
         * now setup a VCS for later use
         */
        velcharstream = new VelocityCharStream(
                new ByteArrayInputStream("\u005cn".getBytes()), 1, 1 );


        strictEscape =
            rs.getBoolean(RuntimeConstants.RUNTIME_REFERENCES_STRICT_ESCAPE, false);

        hyphenAllowedInIdentifiers =
            rs.getBoolean(RuntimeConstants.PARSER_HYPHEN_ALLOWED, false);

        /*
         *  and save the RuntimeServices
         */
        rsvc = rs;

        /*
         * then initialize customizable characters
         */
         dollar   = '$';
         hash     = '#';
         at       = '@';
         asterisk = '*';
    }

    /**
     * This was also added to allow parsers to be
     * re-usable. Normal JavaCC use entails passing an
     * input stream to the constructor and the parsing
     * process is carried out once. We want to be able
     * to re-use parsers: we do this by adding this
     * method and re-initializing the lexer with
     * the new stream that we want parsed.
     */
    @Override
    public SimpleNode parse( Reader reader, Template template )
        throws ParseException
    {
        SimpleNode sn = null;

        currentTemplate = template;

        try
        {
            token_source.clearStateVars();

            /*
             *  reinitialize the VelocityCharStream
             *  with the new reader
             */
            velcharstream.ReInit( reader, 1, 1 );

            /*
             * now reinit the Parser with this CharStream
             */
            ReInit( velcharstream  );

            /*
             *  do that voodoo...
             */
            sn = process();
        }
        catch (MacroParseException mee)
        {
            /*
             *  thrown by the Macro class when something is amiss in the
             *  Macro specification
             */
            log.error("{}: {}", template.getName(), mee.getMessage(), mee);
            throw mee;
        }
        catch (ParseException pe)
        {
            log.error("{}: {}", currentTemplate.getName(), pe.getMessage());
            throw new TemplateParseException (pe.currentToken,
                                pe.expectedTokenSequences, pe.tokenImage, currentTemplate.getName());
                }
        catch (TokenMgrError tme)
        {
            throw new ParseException("Lexical error: " + tme.toString());
        }
        catch (Exception e)
        {
            String msg = template.getName() + ": " + e.getMessage();
            log.error(msg, e);
            throw new VelocityException(msg, e, getRuntimeServices().getLogContext().getStackTrace());
        }

        currentTemplate = null;

        return sn;
    }

    /**
     *  This method gets a Directive from the directives Hashtable
     */
    @Override
    public Directive getDirective(String directive)
    {
        return (Directive) rsvc.getDirective(directive);
    }

    /**
     *  This method finds out of the directive exists in the directives Map.
     */
    @Override
    public boolean isDirective(String directive)
    {
        return rsvc.getDirective(directive) != null;
    }


    /**
     * Produces a processed output for an escaped control or
     * pluggable directive
     */
    private String escapedDirective( String strImage )
    {
        int iLast = strImage.lastIndexOf("\u005c\u005c");

        String strDirective = strImage.substring(iLast + 1);

        boolean bRecognizedDirective = false;

        // we don't have to call substring method all the time in this method
        String dirTag = strDirective.substring(1);
        if (dirTag.charAt(0) == '{')
        {
            dirTag = dirTag.substring(1, dirTag.length() - 1);
        }

        /*
         *  If this is a predefined derective or if we detect
         *  a macro definition (this is aproximate at best) then
         *  we absorb the forward slash.  If in strict reference
         *  mode then we always absord the forward slash regardless
         *  if the derective is defined or not.
         */

        if (strictEscape
             || isDirective(dirTag)
             || macroNames.containsKey(dirTag)
             || rsvc.isVelocimacro(dirTag, currentTemplate))
        {
            bRecognizedDirective = true;
        }
        else
        {
            /* order for speed? */

            if ( dirTag.equals("if")
                || dirTag.equals("end")
                || dirTag.equals("set")
                || dirTag.equals("else")
                || dirTag.equals("elseif")
            )
            {
                bRecognizedDirective = true;
            }
        }

        /*
         *  if so, make the proper prefix string (let the escapes do their thing..)
         *  otherwise, just return what it is..
         */

        if (bRecognizedDirective)
            return ( strImage.substring(0,iLast/2) + strDirective);
        else
            return ( strImage );
    }

    /**
     * Check whether there is a left parenthesis with leading optional
     * whitespaces. This method is used in the semantic look ahead of
     * Directive method. This is done in code instead of as a production
     * for simplicity and efficiency.
     */
    private boolean isLeftParenthesis()
    {
        char c;
        int no = 0;
        try {
            while(true)
            {
                /**
                 * Read a character
                 */
                c = velcharstream.readChar();
                no++;
                if (c == '(')
                {
                    return true;
                }
                /**
                 * if not a white space return
                 */
                else if (c != ' ' && c != '\u005cn' && c != '\u005cr' && c != '\u005ct')
                {
                    return false;
                }
            }
        }
        catch(IOException e)
        {
        }
        finally
        {
            /**
             * Backup the stream to the initial state
             */
            velcharstream.backup(no);
        }
        return false;
    }

    /**
     * Check whether there is a right parenthesis with leading optional
     * whitespaces. This method is used in the semantic look ahead of
     * Directive method. This is done in code instead of as a production
     * for simplicity and efficiency.
     */
    private boolean isRightParenthesis()
    {
        char c;
        int no = -1;
        try {
            while(true)
            {
                /**
                 * Read a character
                 */
                 if (no == -1)
                 {
                     switch (getToken(1).kind)
                     {
                        case RPAREN:
                            return true;
                        case WHITESPACE:
                        case NEWLINE:
                            no = 0;
                            break;
                        default:
                            return false;
                     }
                 }
                c = velcharstream.readChar();
                no++;
                if (c == ')')
                {
                    return true;
                }
                /**
                 * if not a white space return
                 */
                else if (c != ' ' && c != '\u005cn' && c != '\u005cr' && c != '\u005ct')
                {
                    return false;
                }
            }
        }
        catch(IOException e)
        {
        }
        finally
        {
            /**
             * Backup the stream to the initial state
             */
            if (no > 0) velcharstream.backup(no);
        }
        return false;
    }

    /**
     * We use this method in a lookahead to determine if we are in a macro
     * default value assignment.  The standard lookahead is not smart enough.
     * here we look for the equals after the reference.
     */
    private boolean isAssignment()
    {
       // Basically if the last character read was not '$' then false
       if (token_source.getCurrentLexicalState() != REFERENCE) return false;

       char c = ' ';
       int backup = 0;
       try
       {
           // Read through any white space
           while(Character.isWhitespace(c))
           {
                c = velcharstream.readChar();
                backup++;
           }

           // This is what we are ultimately looking for
           if (c != '=') return false;
       }
       catch (IOException e)
       {
       }
       finally
       {
           velcharstream.backup(backup);
       }

       return true;
    }

    @Override
    public Template getCurrentTemplate()
    {
        return currentTemplate;
    }

    @Override
    public void resetCurrentTemplate()
    {
        currentTemplate = null;
    }

    @Override
    public char dollar()
    {
        return dollar;
    }

    @Override
    public char hash()
    {
        return hash;
    }

    @Override
    public char at()
    {
        return at;
    }

    @Override
    public char asterisk()
    {
        return asterisk;
    }

    private char dollar = '$';
    private char hash = '#';
    private char at = '@';
    private char asterisk = '*';

/**
 * This method is what starts the whole parsing
 * process. After the parsing is complete and
 * the template has been turned into an AST,
 * this method returns the root of AST which
 * can subsequently be traversed by a visitor
 * which implements the ParserVisitor interface
 * which is generated automatically by JavaCC
 */
  final public SimpleNode process() throws ParseException {
 /*@bgen(jjtree) process */
    ASTprocess jjtn000 = new ASTprocess(this, JJTPROCESS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);boolean afterNewline = true;
    try {
      label_1:
      while (true) {
        if (getToken(1).kind != EOF) {
          ;
        } else {
          break label_1;
        }
        afterNewline = Statement(afterNewline);
      }
      jj_consume_token(0);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * These are the types of statements that
 * are acceptable in Velocity templates.
 */
  final public boolean Statement(boolean afterNewline) throws ParseException {
    if (getToken(1).kind == IF_DIRECTIVE || afterNewline && getToken(1).kind == WHITESPACE && getToken(2).kind == IF_DIRECTIVE) {
      afterNewline = IfStatement(afterNewline);
                                                                                                                                                                                       {if (true) return afterNewline;}
    } else if (jj_2_1(2)) {
      Reference();
                               {if (true) return false;}
    } else if (jj_2_2(2)) {
      afterNewline = Comment();
                                            {if (true) return afterNewline;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXTBLOCK:
        Textblock();
                  {if (true) return false;}
        break;
      default:
        jj_la1[1] = jj_gen;
        if (getToken(1).kind == SET_DIRECTIVE || afterNewline && getToken(1).kind == WHITESPACE && getToken(2).kind == SET_DIRECTIVE) {
          afterNewline = SetDirective(afterNewline);
                                                                                                                                                                                          {if (true) return afterNewline;}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ESCAPE_DIRECTIVE:
            EscapedDirective();
                         {if (true) return false;}
            break;
          case DOUBLE_ESCAPE:
            Escape();
               {if (true) return false;}
            break;
          default:
            jj_la1[2] = jj_gen;
            if (getToken(1).kind == WORD || getToken(1).kind == BRACKETED_WORD || afterNewline && getToken(1).kind == WHITESPACE && ( getToken(2).kind == WORD || getToken(2).kind == BRACKETED_WORD )) {
              afterNewline = Directive(afterNewline);
                                                                                                                                                                                                                                                     {if (true) return afterNewline;}
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LONE_SYMBOL:
              case PIPE:
              case LPAREN:
              case RPAREN:
              case STRING_LITERAL:
              case INTEGER_LITERAL:
              case FLOATING_POINT_LITERAL:
              case DOT:
              case LCURLY:
              case RCURLY:
              case ESCAPE:
              case TEXT:
              case EMPTY_INDEX:
                afterNewline = Text();
                            {if (true) return afterNewline;}
                break;
              case NEWLINE:
      ASTText jjtn001 = new ASTText(this, JJTTEXT);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
                try {
                  jj_consume_token(NEWLINE);
                } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
                }
                        {if (true) return true;}
                break;
              case INLINE_TEXT:
      ASTText jjtn002 = new ASTText(this, JJTTEXT);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
                try {
                  jj_consume_token(INLINE_TEXT);
                        afterNewline = false;
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case TEXT:
                    jj_consume_token(TEXT);
                                                              afterNewline = true;
                    break;
                  default:
                    jj_la1[0] = jj_gen;
                    ;
                  }
                } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, true);
      }
                }
                                                                                                 {if (true) return afterNewline;}
                break;
              case WHITESPACE:
      ASTText jjtn003 = new ASTText(this, JJTTEXT);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
                try {
                  jj_consume_token(WHITESPACE);
                } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, true);
      }
                }
                           {if (true) return false;}
                break;
              case SUFFIX:
      ASTText jjtn004 = new ASTText(this, JJTTEXT);
      boolean jjtc004 = true;
      jjtree.openNodeScope(jjtn004);
                try {
                  jj_consume_token(SUFFIX);
                } finally {
      if (jjtc004) {
        jjtree.closeNodeScope(jjtn004, true);
      }
                }
                       {if (true) return true;}
                break;
              default:
                jj_la1[3] = jj_gen;
                if (jj_2_3(2)) {
                  EndingZeroWidthWhitespace();
                                               {if (true) return afterNewline;}
                } else {
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case LOGICAL_OR_2:
      ASTText jjtn005 = new ASTText(this, JJTTEXT);
      boolean jjtc005 = true;
      jjtree.openNodeScope(jjtn005);
                    try {
                      jj_consume_token(LOGICAL_OR_2);
                    } finally {
      if (jjtc005) {
        jjtree.closeNodeScope(jjtn005, true);
      }
                    }
                             {if (true) return afterNewline;}
                    break;
                  case ZERO_WIDTH_WHITESPACE:
      ASTText jjtn006 = new ASTText(this, JJTTEXT);
      boolean jjtc006 = true;
      jjtree.openNodeScope(jjtn006);
                    try {
                      jj_consume_token(ZERO_WIDTH_WHITESPACE);
                    } finally {
      if (jjtc006) {
        jjtree.closeNodeScope(jjtn006, true);
      }
                    }
                                      afterNewline = !afterNewline; {if (true) return false;}
                    break;
                  default:
                    jj_la1[4] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                }
              }
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void EndingZeroWidthWhitespace() throws ParseException {
    jj_consume_token(ZERO_WIDTH_WHITESPACE);
    jj_consume_token(0);

  }

/**
 *  used to separate the notion of a valid directive that has been
 *  escaped, versus something that looks like a directive and
 *  is just schmoo.  This is important to do as a separate production
 *  that creates a node, because we want this, in either case, to stop
 *  the further parsing of the Directive() tree.
 */
  final public void EscapedDirective() throws ParseException {
                           /*@bgen(jjtree) EscapedDirective */
  ASTEscapedDirective jjtn000 = new ASTEscapedDirective(this, JJTESCAPEDDIRECTIVE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
        Token t = null;
      t = jj_consume_token(ESCAPE_DIRECTIVE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         *  churn and burn..
         */
        t.image = escapedDirective( t.image );
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *  Used to catch and process escape sequences in grammatical constructs
 *  as escapes outside of VTL are just characters.  Right now we have both
 *  this and the EscapeDirective() construction because in the EscapeDirective()
 *  case, we want to suck in the #&lt;directive&gt; and here we don't.  We just want
 *  the escapes to render correctly
 */
  final public void Escape() throws ParseException {
                 /*@bgen(jjtree) Escape */
  ASTEscape jjtn000 = new ASTEscape(this, JJTESCAPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
        Token t = null;
        int count = 0;
        boolean control = false;
      label_2:
      while (true) {
        t = jj_consume_token(DOUBLE_ESCAPE);
        count++;
        if (jj_2_4(2)) {
          ;
        } else {
          break label_2;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         * first, check to see if we have a control directive
         */
        switch(t.next.kind ) {
            case IF_DIRECTIVE :
            case ELSE :
            case ELSEIF :
            case END :
                control = true;
                break;
        }

        /*
         * if that failed, lets lookahead to see if we matched a PD or a VM
         */
        String nTag = t.next.image.substring(1);
        if (strictEscape
            || isDirective(nTag)
            || macroNames.containsKey(nTag)
            || rsvc.isVelocimacro(nTag, currentTemplate))
        {
            control = true;
        }

        jjtn000.val = "";

        for( int i = 0; i < count; i++)
            jjtn000.val += ( control ? "\u005c\u005c" : "\u005c\u005c\u005c\u005c");
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public boolean Comment() throws ParseException {
                     /*@bgen(jjtree) Comment */
  ASTComment jjtn000 = new ASTComment(this, JJTCOMMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_LINE_COMMENT_START:
        jj_consume_token(SINGLE_LINE_COMMENT_START);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLE_LINE_COMMENT:
          jj_consume_token(SINGLE_LINE_COMMENT);
          break;
        default:
          jj_la1[5] = jj_gen;
          ;
        }
                                                                  jjtree.closeNodeScope(jjtn000, true);
                                                                  jjtc000 = false;
                                                                  {if (true) return true;}
        break;
      case MULTI_LINE_COMMENT:
        jj_consume_token(MULTI_LINE_COMMENT);
                           jjtree.closeNodeScope(jjtn000, true);
                           jjtc000 = false;
                           {if (true) return false;}
        break;
      case FORMAL_COMMENT:
        jj_consume_token(FORMAL_COMMENT);
                       jjtree.closeNodeScope(jjtn000, true);
                       jjtc000 = false;
                       {if (true) return false;}
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public void Textblock() throws ParseException {
                    /*@bgen(jjtree) Textblock */
  ASTTextblock jjtn000 = new ASTTextblock(this, JJTTEXTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TEXTBLOCK);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void FloatingPointLiteral() throws ParseException {
                               /*@bgen(jjtree) FloatingPointLiteral */
  ASTFloatingPointLiteral jjtn000 = new ASTFloatingPointLiteral(this, JJTFLOATINGPOINTLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FLOATING_POINT_LITERAL);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void IntegerLiteral() throws ParseException {
                         /*@bgen(jjtree) IntegerLiteral */
  ASTIntegerLiteral jjtn000 = new ASTIntegerLiteral(this, JJTINTEGERLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(INTEGER_LITERAL);
    } finally {
       if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
       }
    }
  }

  final public void StringLiteral() throws ParseException {
                        /*@bgen(jjtree) StringLiteral */
  ASTStringLiteral jjtn000 = new ASTStringLiteral(this, JJTSTRINGLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(STRING_LITERAL);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 * This method corresponds to variable
 * references in Velocity templates.
 * The following are examples of variable
 * references that may be found in a
 * template:
 *
 * $foo
 * $bar
 *
 */
  final public void Identifier() throws ParseException {
                     /*@bgen(jjtree) Identifier */
  ASTIdentifier jjtn000 = new ASTIdentifier(this, JJTIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      case OLD_IDENTIFIER:
        jj_consume_token(OLD_IDENTIFIER);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Word() throws ParseException {
               /*@bgen(jjtree) Word */
  ASTWord jjtn000 = new ASTWord(this, JJTWORD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(WORD);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *   Supports the arguments for the Pluggable Directives
 */
  final public int DirectiveArg() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case OLD_IDENTIFIER:
    case LCURLY:
      Reference();
        {if (true) return ParserTreeConstants.JJTREFERENCE;}
      break;
    case WORD:
      Word();
        {if (true) return ParserTreeConstants.JJTWORD;}
      break;
    case STRING_LITERAL:
      StringLiteral();
        {if (true) return ParserTreeConstants.JJTSTRINGLITERAL;}
      break;
    case INTEGER_LITERAL:
      IntegerLiteral();
        {if (true) return ParserTreeConstants.JJTINTEGERLITERAL;}
      break;
    default:
      jj_la1[8] = jj_gen;
      if (jj_2_5(2147483647)) {
        IntegerRange();
        {if (true) return ParserTreeConstants.JJTINTEGERRANGE;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FLOATING_POINT_LITERAL:
          FloatingPointLiteral();
        {if (true) return ParserTreeConstants.JJTFLOATINGPOINTLITERAL;}
          break;
        case LEFT_CURLEY:
          Map();
        {if (true) return ParserTreeConstants.JJTMAP;}
          break;
        case LBRACKET:
          ObjectArray();
        {if (true) return ParserTreeConstants.JJTOBJECTARRAY;}
          break;
        case TRUE:
          True();
        {if (true) return ParserTreeConstants.JJTTRUE;}
          break;
        case FALSE:
          False();
        {if (true) return ParserTreeConstants.JJTFALSE;}
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void DirectiveAssign() throws ParseException {
                          /*@bgen(jjtree) DirectiveAssign */
  ASTDirectiveAssign jjtn000 = new ASTDirectiveAssign(this, JJTDIRECTIVEASSIGN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Reference();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *   Supports the Pluggable Directives
 *     #foo( arg+ )
 * @return true if ends with a newline
 */
  final public boolean Directive(boolean afterNewline) throws ParseException {
 /*@bgen(jjtree) Directive */
    ASTDirective jjtn000 = new ASTDirective(this, JJTDIRECTIVE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token id = null, t = null, u = null, end = null, _else = null;
    int argType;
    int argPos = 0;
    Directive d;
    int directiveType;
    boolean isVM = false;
    boolean isMacro = false;
    ArrayList argtypes = new ArrayList(4);
    String blockPrefix = "";
    ASTBlock block = null, elseBlock = null;
    boolean hasParentheses = false;
    boolean newlineAtStart = afterNewline;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        t = jj_consume_token(WHITESPACE);
          // only possible if not after new line
          jjtn000.setPrefix(t.image);
          t = null;
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        id = jj_consume_token(WORD);
        break;
      case BRACKETED_WORD:
        id = jj_consume_token(BRACKETED_WORD);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        String directiveName;
        int p = id.image.lastIndexOf(hash);
        if (id.kind == StandardParserConstants.BRACKETED_WORD)
        {
            directiveName = id.image.substring(p + 2, id.image.length() - 1);
        }
        else
        {
            directiveName = id.image.substring(p + 1);
        }

        d = getDirective(directiveName);

        /*
         *  Velocimacro support : if the directive is macro directive
         *   then set the flag so after the block parsing, we add the VM
         *   right then. (So available if used w/in the current template )
         */

        if (directiveName.equals("macro"))
        {
             isMacro = true;
        }

        /*
         * set the directive name from here.  No reason for the thing to know
         * about parser tokens
         */

        jjtn000.setDirectiveName(directiveName);

        if ( d == null)
        {
            if( directiveName.charAt(0) == at )
            {
                // block macro call of type: #@foobar($arg1 $arg2) astBody #end
                directiveType = Directive.BLOCK;
            }
            else
            {
                /*
                 *  if null, then not a real directive, but maybe a Velocimacro
                 */
                isVM = rsvc.isVelocimacro(directiveName, currentTemplate);

                directiveType = Directive.LINE;
            }
        }
        else
        {
            directiveType = d.getType();
        }

        /*
         *  now, switch us out of PRE_DIRECTIVE
         */

        token_source.switchTo(DIRECTIVE);
        argPos = 0;
      if (isLeftParenthesis()) {
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:
            ;
            break;
          default:
            jj_la1[12] = jj_gen;
            break label_3;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
            jj_consume_token(WHITESPACE);
            break;
          case NEWLINE:
            jj_consume_token(NEWLINE);
            break;
          default:
            jj_la1[13] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(LPAREN);
        label_4:
        while (true) {
          if (!isRightParenthesis()) {
            ;
          } else {
            break label_4;
          }
          label_5:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case WHITESPACE:
            case NEWLINE:
              ;
              break;
            default:
              jj_la1[14] = jj_gen;
              break label_5;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case WHITESPACE:
              jj_consume_token(WHITESPACE);
              break;
            case NEWLINE:
              jj_consume_token(NEWLINE);
              break;
            default:
              jj_la1[15] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
            label_6:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case WHITESPACE:
              case NEWLINE:
                ;
                break;
              default:
                jj_la1[16] = jj_gen;
                break label_6;
              }
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case WHITESPACE:
                jj_consume_token(WHITESPACE);
                break;
              case NEWLINE:
                jj_consume_token(NEWLINE);
                break;
              default:
                jj_la1[17] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            break;
          default:
            jj_la1[18] = jj_gen;
            ;
          }
          if (jj_2_6(1)) {
            if (isMacro && isAssignment()) {
              DirectiveAssign();
              label_7:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case WHITESPACE:
                case NEWLINE:
                  ;
                  break;
                default:
                  jj_la1[19] = jj_gen;
                  break label_7;
                }
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case WHITESPACE:
                  jj_consume_token(WHITESPACE);
                  break;
                case NEWLINE:
                  jj_consume_token(NEWLINE);
                  break;
                default:
                  jj_la1[20] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
              jj_consume_token(EQUALS);
              label_8:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case WHITESPACE:
                case NEWLINE:
                  ;
                  break;
                default:
                  jj_la1[21] = jj_gen;
                  break label_8;
                }
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case WHITESPACE:
                  jj_consume_token(WHITESPACE);
                  break;
                case NEWLINE:
                  jj_consume_token(NEWLINE);
                  break;
                default:
                  jj_la1[22] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
                  argtypes.add(ParserTreeConstants.JJTDIRECTIVEASSIGN);
            } else {
              ;
            }
            if (!isRightParenthesis()) {

            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            argType = DirectiveArg();
                  argtypes.add(argType);
                  if (d == null && argType == ParserTreeConstants.JJTWORD)
                  {
                      if (isVM)
                      {
                          {if (true) throw new MacroParseException("Invalid argument "
                              + (argPos+1) + " in macro call " + id.image, currentTemplate.getName(), id);}
                      }
                  }
                  argPos++;
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SINGLE_LINE_COMMENT_START:
                if (!isMacro)
                {
                    // We only allow line comments in macro definitions for now
                    {if (true) throw new MacroParseException("A Line comment is not allowed in " + id.image
                        + " arguments", currentTemplate.getName(), id);}
                }
              jj_consume_token(SINGLE_LINE_COMMENT_START);
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SINGLE_LINE_COMMENT:
                jj_consume_token(SINGLE_LINE_COMMENT);
                break;
              default:
                jj_la1[23] = jj_gen;
                ;
              }
              break;
            default:
              jj_la1[24] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:
            ;
            break;
          default:
            jj_la1[25] = jj_gen;
            break label_9;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
            jj_consume_token(WHITESPACE);
            break;
          case NEWLINE:
            jj_consume_token(NEWLINE);
            break;
          default:
            jj_la1[26] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(RPAREN);
          hasParentheses = true;
      } else {
          token_source.stateStackPop();
      }
      afterNewline = false;
      if (jj_2_7(2) && (directiveType != Directive.LINE || newlineAtStart && rsvc.getSpaceGobbling() != SpaceGobbling.BC || rsvc.getSpaceGobbling() == SpaceGobbling.BC && hasParentheses || d != null && (d instanceof Include || d instanceof Parse))) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          t = jj_consume_token(WHITESPACE);
          break;
        default:
          jj_la1[27] = jj_gen;
          ;
        }
        u = jj_consume_token(NEWLINE);
          afterNewline = true;
          if (directiveType == Directive.LINE)
          {
              jjtn000.setPostfix(t == null ? u.image : t.image + u.image);
          }
          else
          {
              blockPrefix = (t == null ? u.image : t.image + u.image);
          }
          t = u = null;
      } else {
        ;
      }
        if (d != null)
        {
            d.checkArgs(argtypes, id, currentTemplate.getName());
        }
        if (directiveType  == Directive.LINE)
        {
            {if (true) return afterNewline;}
        }
        ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
        boolean jjtc001 = true;
        jjtree.openNodeScope(jjtn001);
      try {
        label_10:
        while (true) {
          if (getToken(1).kind != END && getToken(1).kind != ELSE && ( !afterNewline || getToken(1).kind != WHITESPACE || getToken(2).kind != END && getToken(2).kind != ELSE )) {
            ;
          } else {
            break label_10;
          }
          afterNewline = Statement(afterNewline);
        }
          jjtree.closeNodeScope(jjtn001, true);
          jjtc001 = false;
            block = jjtn001;
            block.setPrefix(blockPrefix);
            blockPrefix = "";
      } catch (Throwable jjte001) {
        if (jjtc001) {
          jjtree.clearNodeScope(jjtn001);
          jjtc001 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte001 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte001;}
        }
        if (jjte001 instanceof ParseException) {
          {if (true) throw (ParseException)jjte001;}
        }
        {if (true) throw (Error)jjte001;}
      } finally {
        if (jjtc001) {
          jjtree.closeNodeScope(jjtn001, true);
        }
      }
      if (jj_2_8(1) && (afterNewline)) {
        t = jj_consume_token(WHITESPACE);
          block.setPostfix(t.image);
          t = null;
      } else {
        ;
      }
      if (d != null && (d instanceof Foreach) && getToken(1).kind == ELSE) {
        _else = jj_consume_token(ELSE);
            ASTBlock jjtn002 = new ASTBlock(this, JJTBLOCK);
            boolean jjtc002 = true;
            jjtree.openNodeScope(jjtn002);
        try {
          if (jj_2_9(2)) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case WHITESPACE:
              t = jj_consume_token(WHITESPACE);
              break;
            default:
              jj_la1[28] = jj_gen;
              ;
            }
            u = jj_consume_token(NEWLINE);
                  jjtn002.setPrefix(t == null ? u.image : t.image + u.image);
                  t = u = null;
                  afterNewline = true;
          } else {
            ;
          }
          label_11:
          while (true) {
            if (getToken(1).kind != END && (!afterNewline || getToken(1).kind != WHITESPACE || getToken(2).kind != END)) {
              ;
            } else {
              break label_11;
            }
            afterNewline = Statement(afterNewline);
          }
              jjtree.closeNodeScope(jjtn002, true);
              jjtc002 = false;
                elseBlock = jjtn002;
        } catch (Throwable jjte002) {
            if (jjtc002) {
              jjtree.clearNodeScope(jjtn002);
              jjtc002 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte002 instanceof RuntimeException) {
              {if (true) throw (RuntimeException)jjte002;}
            }
            if (jjte002 instanceof ParseException) {
              {if (true) throw (ParseException)jjte002;}
            }
            {if (true) throw (Error)jjte002;}
        } finally {
            if (jjtc002) {
              jjtree.closeNodeScope(jjtn002, true);
            }
        }
              int pos = _else.image.lastIndexOf(hash);
              if (pos > 0)
              {
                  block.setMorePostfix(_else.image.substring(0, pos));
              }
              block = elseBlock;
      } else {
        ;
      }
      if (jj_2_10(1) && (afterNewline)) {
        t = jj_consume_token(WHITESPACE);
          block.setPostfix(t.image);
          t = null;
          afterNewline = false;
      } else {
        ;
      }
      end = jj_consume_token(END);
        afterNewline = false;
      if (jj_2_11(2) && (newlineAtStart || rsvc.getSpaceGobbling() == SpaceGobbling.BC)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          t = jj_consume_token(WHITESPACE);
          break;
        default:
          jj_la1[29] = jj_gen;
          ;
        }
        u = jj_consume_token(NEWLINE);
            jjtn000.setPostfix(t == null ? u.image : t.image + u.image);
            t = u = null;
            afterNewline = true;
      } else {
        ;
      }
          int pos = end.image.lastIndexOf(hash);
          if (pos > 0)
          {
              block.setMorePostfix(end.image.substring(0, pos));
          }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         *  VM : if we are processing a #macro directive, we need to
         *     process the block.  In truth, I can just register the name
         *     and do the work later when init-ing.  That would work
         *     as long as things were always defined before use.  This way
         *     we don't have to worry about forward references and such...
         */
        if (isMacro)
        {
            // Add the macro name so that we can peform escape processing
            // on defined macros
            String macroName = jjtn000.jjtGetChild(0).getFirstToken().image;
            macroNames.put(macroName, macroName);
        }
        if (d != null)
        {
            d.checkArgs(argtypes, id, currentTemplate.getName());
        }
        /*
         *  VM : end
         */
        {if (true) return afterNewline;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * for creating a map in a #set
 *
 *  #set($foo = {$foo : $bar, $blargh : $thingy})
 */
  final public void Map() throws ParseException {
              /*@bgen(jjtree) Map */
  ASTMap jjtn000 = new ASTMap(this, JJTMAP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LEFT_CURLEY);
      if (jj_2_12(2)) {
        Parameter();
        jj_consume_token(COLON);
        Parameter();
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[30] = jj_gen;
            break label_12;
          }
          jj_consume_token(COMMA);
          Parameter();
          jj_consume_token(COLON);
          Parameter();
        }
      } else {
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:
            ;
            break;
          default:
            jj_la1[31] = jj_gen;
            break label_13;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
            jj_consume_token(WHITESPACE);
            break;
          case NEWLINE:
            jj_consume_token(NEWLINE);
            break;
          default:
            jj_la1[32] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHT_CURLEY:
        jj_consume_token(RIGHT_CURLEY);
        break;
      case RCURLY:
        jj_consume_token(RCURLY);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void ObjectArray() throws ParseException {
                      /*@bgen(jjtree) ObjectArray */
  ASTObjectArray jjtn000 = new ASTObjectArray(this, JJTOBJECTARRAY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
      case LEFT_CURLEY:
      case WHITESPACE:
      case NEWLINE:
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case IDENTIFIER:
      case OLD_IDENTIFIER:
      case LCURLY:
        Parameter();
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[34] = jj_gen;
            break label_14;
          }
          jj_consume_token(COMMA);
          Parameter();
        }
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *  supports the [n..m] vector generator for use in
 *  the #foreach() to generate measured ranges w/o
 *  needing explicit support from the app/servlet
 */
  final public void IntegerRange() throws ParseException {
                       /*@bgen(jjtree) IntegerRange */
  ASTIntegerRange jjtn000 = new ASTIntegerRange(this, JJTINTEGERRANGE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACKET);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_15;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[37] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case OLD_IDENTIFIER:
      case LCURLY:
        Reference();
        break;
      case INTEGER_LITERAL:
        IntegerLiteral();
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_16;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[40] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(DOUBLEDOT);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_17;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[42] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case OLD_IDENTIFIER:
      case LCURLY:
        Reference();
        break;
      case INTEGER_LITERAL:
        IntegerLiteral();
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_18;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACKET);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 * A Simplified parameter more suitable for an index position: $foo[$index]
 */
  final public void IndexParameter() throws ParseException {
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_19;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    Expression();
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_20;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * This method has yet to be fully implemented
 * but will allow arbitrarily nested method
 * calls
 */
  final public void Parameter() throws ParseException {
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[50] = jj_gen;
        break label_21;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      StringLiteral();
      break;
    case INTEGER_LITERAL:
      IntegerLiteral();
      break;
    default:
      jj_la1[52] = jj_gen;
      if (jj_2_13(2147483647)) {
        IntegerRange();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LEFT_CURLEY:
          Map();
          break;
        case LBRACKET:
          ObjectArray();
          break;
        case TRUE:
          True();
          break;
        case FALSE:
          False();
          break;
        case IDENTIFIER:
        case OLD_IDENTIFIER:
        case LCURLY:
          Reference();
          break;
        case FLOATING_POINT_LITERAL:
          FloatingPointLiteral();
          break;
        default:
          jj_la1[53] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_22;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * This method has yet to be fully implemented
 * but will allow arbitrarily nested method
 * calls
 */
  final public void Method() throws ParseException {
                 /*@bgen(jjtree) Method */
  ASTMethod jjtn000 = new ASTMethod(this, JJTMETHOD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Identifier();
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
      case LEFT_CURLEY:
      case LPAREN:
      case WHITESPACE:
      case NEWLINE:
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case MINUS:
      case LOGICAL_NOT:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case IDENTIFIER:
      case OLD_IDENTIFIER:
      case LCURLY:
        Expression();
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[56] = jj_gen;
            break label_23;
          }
          jj_consume_token(COMMA);
          Expression();
        }
        break;
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      jj_consume_token(REFMOD2_RPAREN);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void Index() throws ParseException {
                /*@bgen(jjtree) Index */
  ASTIndex jjtn000 = new ASTIndex(this, JJTINDEX);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(INDEX_LBRACKET);
      IndexParameter();
      jj_consume_token(INDEX_RBRACKET);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void Reference() throws ParseException {
                    /*@bgen(jjtree) Reference */
  ASTReference jjtn000 = new ASTReference(this, JJTREFERENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case OLD_IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          jj_consume_token(IDENTIFIER);
          break;
        case OLD_IDENTIFIER:
          jj_consume_token(OLD_IDENTIFIER);
          break;
        default:
          jj_la1[58] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_24:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INDEX_LBRACKET:
            ;
            break;
          default:
            jj_la1[59] = jj_gen;
            break label_24;
          }
          Index();
        }
        label_25:
        while (true) {
          if (jj_2_14(2)) {
            ;
          } else {
            break label_25;
          }
          jj_consume_token(DOT);
          if (jj_2_15(3)) {
            Method();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case IDENTIFIER:
            case OLD_IDENTIFIER:
              Identifier();
              break;
            default:
              jj_la1[60] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          label_26:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INDEX_LBRACKET:
              ;
              break;
            default:
              jj_la1[61] = jj_gen;
              break label_26;
            }
            Index();
          }
        }
        break;
      case LCURLY:
        jj_consume_token(LCURLY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          jj_consume_token(IDENTIFIER);
          break;
        case OLD_IDENTIFIER:
          jj_consume_token(OLD_IDENTIFIER);
          break;
        default:
          jj_la1[62] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INDEX_LBRACKET:
            ;
            break;
          default:
            jj_la1[63] = jj_gen;
            break label_27;
          }
          Index();
        }
        label_28:
        while (true) {
          if (jj_2_16(2)) {
            ;
          } else {
            break label_28;
          }
          jj_consume_token(DOT);
          if (jj_2_17(3)) {
            Method();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case IDENTIFIER:
            case OLD_IDENTIFIER:
              Identifier();
              break;
            default:
              jj_la1[64] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          label_29:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INDEX_LBRACKET:
              ;
              break;
            default:
              jj_la1[65] = jj_gen;
              break label_29;
            }
            Index();
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PIPE:
          jj_consume_token(PIPE);
          Expression();
          break;
        default:
          jj_la1[66] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RCURLY:
          jj_consume_token(RCURLY);
          break;
        case RIGHT_CURLEY:
          jj_consume_token(RIGHT_CURLEY);
          break;
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
        if (jjtc000) {
          jjtree.clearNodeScope(jjtn000);
          jjtc000 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte000 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte000;}
        }
        if (jjte000 instanceof ParseException) {
          {if (true) throw (ParseException)jjte000;}
        }
        {if (true) throw (Error)jjte000;}
    } finally {
        if (jjtc000) {
          jjtree.closeNodeScope(jjtn000, true);
        }
    }
  }

  final public void True() throws ParseException {
               /*@bgen(jjtree) True */
  ASTTrue jjtn000 = new ASTTrue(this, JJTTRUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TRUE);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void False() throws ParseException {
                /*@bgen(jjtree) False */
  ASTFalse jjtn000 = new ASTFalse(this, JJTFALSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FALSE);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 * This method is responsible for allowing
 * all non-grammar text to pass through
 * unscathed.
 * @return true if last read token was a newline
 */
  final public boolean Text() throws ParseException {
 /*@bgen(jjtree) Text */
    ASTText jjtn000 = new ASTText(this, JJTTEXT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXT:
        jj_consume_token(TEXT);
             jjtree.closeNodeScope(jjtn000, true);
             jjtc000 = false;
             {if (true) return true;}
        break;
      case DOT:
        jj_consume_token(DOT);
             jjtree.closeNodeScope(jjtn000, true);
             jjtc000 = false;
             {if (true) return false;}
        break;
      case RPAREN:
        jj_consume_token(RPAREN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                {if (true) return false;}
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                {if (true) return false;}
        break;
      case INTEGER_LITERAL:
        jj_consume_token(INTEGER_LITERAL);
                         jjtree.closeNodeScope(jjtn000, true);
                         jjtc000 = false;
                         {if (true) return false;}
        break;
      case FLOATING_POINT_LITERAL:
        jj_consume_token(FLOATING_POINT_LITERAL);
                                jjtree.closeNodeScope(jjtn000, true);
                                jjtc000 = false;
                                {if (true) return false;}
        break;
      case STRING_LITERAL:
        jj_consume_token(STRING_LITERAL);
                        jjtree.closeNodeScope(jjtn000, true);
                        jjtc000 = false;
                        {if (true) return false;}
        break;
      case ESCAPE:
        jj_consume_token(ESCAPE);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                {if (true) return false;}
        break;
      case LCURLY:
        jj_consume_token(LCURLY);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                {if (true) return false;}
        break;
      case RCURLY:
        jj_consume_token(RCURLY);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                {if (true) return false;}
        break;
      case EMPTY_INDEX:
        jj_consume_token(EMPTY_INDEX);
                     jjtree.closeNodeScope(jjtn000, true);
                     jjtc000 = false;
                     {if (true) return false;}
        break;
      case PIPE:
        jj_consume_token(PIPE);
              jjtree.closeNodeScope(jjtn000, true);
              jjtc000 = false;
              {if (true) return false;}
        break;
      case LONE_SYMBOL:
        t = jj_consume_token(LONE_SYMBOL);
       jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
         /* Drop the ending zero-width whitespace */
         t.image = t.image.substring(0, t.image.length() - 1); {if (true) return false;}
        break;
      default:
        jj_la1[69] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/* -----------------------------------------------------------------------
 *
 *  Defined Directive Syntax
 *
 * ----------------------------------------------------------------------*/
  final public boolean IfStatement(boolean afterNewline) throws ParseException {
 /*@bgen(jjtree) IfStatement */
    ASTIfStatement jjtn000 = new ASTIfStatement(this, JJTIFSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t = null, u = null, end = null;
    ASTBlock lastBlock = null;
    boolean newlineAtStart = afterNewline;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        t = jj_consume_token(WHITESPACE);
            // only possible if not after new line
            jjtn000.setPrefix(t.image);
            t = null;
        break;
      default:
        jj_la1[70] = jj_gen;
        ;
      }
      jj_consume_token(IF_DIRECTIVE);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[71] = jj_gen;
          break label_30;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[72] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      try {
        if (jj_2_18(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
            t = jj_consume_token(WHITESPACE);
            break;
          default:
            jj_la1[73] = jj_gen;
            ;
          }
          u = jj_consume_token(NEWLINE);
            jjtn001.setPrefix(t == null ? u.image : t.image + u.image);
            t = u = null;
            afterNewline = true;
        } else {
          ;
        }
        label_31:
        while (true) {
          if ((getToken(1).kind != ELSEIF && getToken(1).kind != ELSE && getToken(1).kind != END) &&
                        (!afterNewline || getToken(1).kind != WHITESPACE || (getToken(2).kind != ELSEIF && getToken(2).kind != ELSE && getToken(2).kind != END))) {
            ;
          } else {
            break label_31;
          }
          afterNewline = Statement(afterNewline);
        }
          jjtree.closeNodeScope(jjtn001, true);
          jjtc001 = false;
            lastBlock = jjtn001;
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
      }
      if (getToken(1).kind == ELSEIF || (afterNewline && getToken(1).kind == WHITESPACE && getToken(2).kind == ELSEIF)) {
        label_32:
        while (true) {
          lastBlock = ElseIfStatement(lastBlock, afterNewline);
                                                                                                                                                                                              afterNewline = lastBlock.endsWithNewline;
          if (getToken(1).kind == ELSEIF || (afterNewline && getToken(1).kind == WHITESPACE && getToken(2).kind == ELSEIF)) {
            ;
          } else {
            break label_32;
          }
        }
      } else {
        ;
      }
      if (getToken(1).kind == ELSE || (afterNewline && getToken(1).kind == WHITESPACE && getToken(2).kind == ELSE)) {
        lastBlock = ElseStatement(lastBlock, afterNewline);
                                                                                                                                                                                     afterNewline = lastBlock.endsWithNewline;
      } else {
        ;
      }
      if (jj_2_19(1) && (afterNewline)) {
        t = jj_consume_token(WHITESPACE);
            lastBlock.setPostfix(t.image);
            t = null;
      } else {
        ;
      }
      end = jj_consume_token(END);
      afterNewline = false;
      if (jj_2_20(2) && (newlineAtStart || rsvc.getSpaceGobbling() == SpaceGobbling.BC)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          t = jj_consume_token(WHITESPACE);
          break;
        default:
          jj_la1[74] = jj_gen;
          ;
        }
        u = jj_consume_token(NEWLINE);
             jjtn000.setPostfix(t == null ? u.image : t.image + u.image);
             afterNewline = true;
      } else {
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        int pos = end.image.lastIndexOf(hash);
        if (pos > 0)
        {
            lastBlock.setMorePostfix(end.image.substring(0, pos));
        }
        {if (true) return afterNewline;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public ASTBlock ElseStatement(ASTBlock previousBlock, boolean afterNewline) throws ParseException {
 /*@bgen(jjtree) ElseStatement */
    ASTElseStatement jjtn000 = new ASTElseStatement(this, JJTELSESTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t = null, u = null, _else = null;
    ASTBlock block = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        t = jj_consume_token(WHITESPACE);
         previousBlock.setPostfix(t.image);
         t = null;
        break;
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      _else = jj_consume_token(ELSE);
     ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        if (jj_2_21(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
            t = jj_consume_token(WHITESPACE);
            break;
          default:
            jj_la1[76] = jj_gen;
            ;
          }
          u = jj_consume_token(NEWLINE);
           jjtn001.setPrefix(t == null ? u.image : t.image + u.image);
           t = u = null;
           afterNewline = true;
        } else {
          ;
        }
        label_33:
        while (true) {
          if (getToken(1).kind != END && (!afterNewline || getToken(1).kind != WHITESPACE || getToken(2).kind != END)) {
            ;
          } else {
            break label_33;
          }
          afterNewline = Statement(afterNewline);
        }
       jjtree.closeNodeScope(jjtn001, true);
       jjtc001 = false;
         block = jjtn001;
         block.endsWithNewline = afterNewline;
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        int pos = _else.image.lastIndexOf(hash);
        if (pos > 0)
        {
            previousBlock.setMorePostfix(_else.image.substring(0, pos));
        }
        {if (true) return block;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  final public ASTBlock ElseIfStatement(ASTBlock previousBlock, boolean afterNewline) throws ParseException {
 /*@bgen(jjtree) ElseIfStatement */
    ASTElseIfStatement jjtn000 = new ASTElseIfStatement(this, JJTELSEIFSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t = null, u = null, elseif = null;
    ASTBlock block = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        t = jj_consume_token(WHITESPACE);
        previousBlock.setPostfix(t.image);
        t = null;
        break;
      default:
        jj_la1[77] = jj_gen;
        ;
      }
      elseif = jj_consume_token(ELSEIF);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[78] = jj_gen;
          break label_34;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[79] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
    ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
      try {
        if (jj_2_22(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
            t = jj_consume_token(WHITESPACE);
            break;
          default:
            jj_la1[80] = jj_gen;
            ;
          }
          u = jj_consume_token(NEWLINE);
          jjtn001.setPrefix(t == null ? u.image : t.image + u.image);
          t = u = null;
          afterNewline = true;
        } else {
          ;
        }
        label_35:
        while (true) {
          if ((getToken(1).kind != ELSEIF && getToken(1).kind != ELSE && getToken(1).kind != END) && (!afterNewline || getToken(1).kind != WHITESPACE || (getToken(2).kind != ELSEIF && getToken(2).kind != ELSE && getToken(2).kind != END))) {
            ;
          } else {
            break label_35;
          }
          afterNewline = Statement(afterNewline);
        }
      jjtree.closeNodeScope(jjtn001, true);
      jjtc001 = false;
        block = jjtn001;
        block.endsWithNewline = afterNewline;
      } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof ParseException) {
      {if (true) throw (ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
      } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true);
    }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
      int pos = elseif.image.lastIndexOf(hash);
      if (pos > 0)
      {
          previousBlock.setMorePostfix(elseif.image.substring(0, pos));
      }
      {if (true) return block;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

/**
 *  Currently support both types of set :
 *   #set( expr )
 *   #set expr
 */
  final public boolean SetDirective(boolean afterNewline) throws ParseException {
 /*@bgen(jjtree) SetDirective */
    ASTSetDirective jjtn000 = new ASTSetDirective(this, JJTSETDIRECTIVE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t = null, u = null;
    boolean endsWithNewline = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        t = jj_consume_token(WHITESPACE);
            // only possible after new line
            jjtn000.setPrefix(t.image);
            t = null;
        break;
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      jj_consume_token(SET_DIRECTIVE);
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[82] = jj_gen;
          break label_36;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[83] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      Reference();
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:
          ;
          break;
        default:
          jj_la1[84] = jj_gen;
          break label_37;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        case NEWLINE:
          jj_consume_token(NEWLINE);
          break;
        default:
          jj_la1[85] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(EQUALS);
      Expression();
      jj_consume_token(RPAREN);
        /*
         * ensure that inSet is false.  Leads to some amusing bugs...
         */

        token_source.setInSet(false);
      if (jj_2_23(2) && (afterNewline || rsvc.getSpaceGobbling() == SpaceGobbling.BC)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          t = jj_consume_token(WHITESPACE);
          break;
        default:
          jj_la1[86] = jj_gen;
          ;
        }
        u = jj_consume_token(NEWLINE);
             jjtn000.setPostfix(t == null ? u.image : t.image + u.image);
             endsWithNewline = true;
      } else {
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        {if (true) return endsWithNewline;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/* -----------------------------------------------------------------------
 *
 *  Expression Syntax
 *
 * ----------------------------------------------------------------------*/
  final public void Expression() throws ParseException {
                     /*@bgen(jjtree) Expression */
  ASTExpression jjtn000 = new ASTExpression(this, JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ConditionalOrExpression();
    } catch (Throwable jjte000) {
  if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
  }
    }
  }

  final public void Assignment() throws ParseException {
                                    /*@bgen(jjtree) #Assignment( 2) */
  ASTAssignment jjtn000 = new ASTAssignment(this, JJTASSIGNMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      PrimaryExpression();
      jj_consume_token(EQUALS);
      Expression();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000,  2);
      }
    }
  }

  final public void ConditionalOrExpression() throws ParseException {
    ConditionalAndExpression();
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_OR_2:
      case LOGICAL_OR:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_38;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_OR:
        jj_consume_token(LOGICAL_OR);
        break;
      case LOGICAL_OR_2:
        jj_consume_token(LOGICAL_OR_2);
        break;
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                         ASTOrNode jjtn001 = new ASTOrNode(this, JJTORNODE);
                                         boolean jjtc001 = true;
                                         jjtree.openNodeScope(jjtn001);
      try {
        ConditionalAndExpression();
      } catch (Throwable jjte001) {
                                         if (jjtc001) {
                                           jjtree.clearNodeScope(jjtn001);
                                           jjtc001 = false;
                                         } else {
                                           jjtree.popNode();
                                         }
                                         if (jjte001 instanceof RuntimeException) {
                                           {if (true) throw (RuntimeException)jjte001;}
                                         }
                                         if (jjte001 instanceof ParseException) {
                                           {if (true) throw (ParseException)jjte001;}
                                         }
                                         {if (true) throw (Error)jjte001;}
      } finally {
                                         if (jjtc001) {
                                           jjtree.closeNodeScope(jjtn001,  2);
                                         }
      }
    }
  }

  final public void ConditionalAndExpression() throws ParseException {
    EqualityExpression();
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_AND:
        ;
        break;
      default:
        jj_la1[89] = jj_gen;
        break label_39;
      }
      jj_consume_token(LOGICAL_AND);
                    ASTAndNode jjtn001 = new ASTAndNode(this, JJTANDNODE);
                    boolean jjtc001 = true;
                    jjtree.openNodeScope(jjtn001);
      try {
        EqualityExpression();
      } catch (Throwable jjte001) {
                    if (jjtc001) {
                      jjtree.clearNodeScope(jjtn001);
                      jjtc001 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte001 instanceof RuntimeException) {
                      {if (true) throw (RuntimeException)jjte001;}
                    }
                    if (jjte001 instanceof ParseException) {
                      {if (true) throw (ParseException)jjte001;}
                    }
                    {if (true) throw (Error)jjte001;}
      } finally {
                    if (jjtc001) {
                      jjtree.closeNodeScope(jjtn001,  2);
                    }
      }
    }
  }

  final public void EqualityExpression() throws ParseException {
    RelationalExpression();
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_EQUALS:
      case LOGICAL_NOT_EQUALS:
        ;
        break;
      default:
        jj_la1[90] = jj_gen;
        break label_40;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_EQUALS:
        jj_consume_token(LOGICAL_EQUALS);
                          ASTEQNode jjtn001 = new ASTEQNode(this, JJTEQNODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
        try {
          RelationalExpression();
        } catch (Throwable jjte001) {
                          if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte001;}
                          }
                          if (jjte001 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte001;}
                          }
                          {if (true) throw (Error)jjte001;}
        } finally {
                          if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001,  2);
                          }
        }
        break;
      case LOGICAL_NOT_EQUALS:
        jj_consume_token(LOGICAL_NOT_EQUALS);
                              ASTNENode jjtn002 = new ASTNENode(this, JJTNENODE);
                              boolean jjtc002 = true;
                              jjtree.openNodeScope(jjtn002);
        try {
          RelationalExpression();
        } catch (Throwable jjte002) {
                              if (jjtc002) {
                                jjtree.clearNodeScope(jjtn002);
                                jjtc002 = false;
                              } else {
                                jjtree.popNode();
                              }
                              if (jjte002 instanceof RuntimeException) {
                                {if (true) throw (RuntimeException)jjte002;}
                              }
                              if (jjte002 instanceof ParseException) {
                                {if (true) throw (ParseException)jjte002;}
                              }
                              {if (true) throw (Error)jjte002;}
        } finally {
                              if (jjtc002) {
                                jjtree.closeNodeScope(jjtn002,  2);
                              }
        }
        break;
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void RelationalExpression() throws ParseException {
    AdditiveExpression();
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_LT:
      case LOGICAL_LE:
      case LOGICAL_GT:
      case LOGICAL_GE:
        ;
        break;
      default:
        jj_la1[92] = jj_gen;
        break label_41;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_LT:
        jj_consume_token(LOGICAL_LT);
                        ASTLTNode jjtn001 = new ASTLTNode(this, JJTLTNODE);
                        boolean jjtc001 = true;
                        jjtree.openNodeScope(jjtn001);
        try {
          AdditiveExpression();
        } catch (Throwable jjte001) {
                        if (jjtc001) {
                          jjtree.clearNodeScope(jjtn001);
                          jjtc001 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte001 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte001;}
                        }
                        if (jjte001 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte001;}
                        }
                        {if (true) throw (Error)jjte001;}
        } finally {
                        if (jjtc001) {
                          jjtree.closeNodeScope(jjtn001,  2);
                        }
        }
        break;
      case LOGICAL_GT:
        jj_consume_token(LOGICAL_GT);
                        ASTGTNode jjtn002 = new ASTGTNode(this, JJTGTNODE);
                        boolean jjtc002 = true;
                        jjtree.openNodeScope(jjtn002);
        try {
          AdditiveExpression();
        } catch (Throwable jjte002) {
                        if (jjtc002) {
                          jjtree.clearNodeScope(jjtn002);
                          jjtc002 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte002 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte002;}
                        }
                        if (jjte002 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte002;}
                        }
                        {if (true) throw (Error)jjte002;}
        } finally {
                        if (jjtc002) {
                          jjtree.closeNodeScope(jjtn002,  2);
                        }
        }
        break;
      case LOGICAL_LE:
        jj_consume_token(LOGICAL_LE);
                        ASTLENode jjtn003 = new ASTLENode(this, JJTLENODE);
                        boolean jjtc003 = true;
                        jjtree.openNodeScope(jjtn003);
        try {
          AdditiveExpression();
        } catch (Throwable jjte003) {
                        if (jjtc003) {
                          jjtree.clearNodeScope(jjtn003);
                          jjtc003 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte003 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte003;}
                        }
                        if (jjte003 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte003;}
                        }
                        {if (true) throw (Error)jjte003;}
        } finally {
                        if (jjtc003) {
                          jjtree.closeNodeScope(jjtn003,  2);
                        }
        }
        break;
      case LOGICAL_GE:
        jj_consume_token(LOGICAL_GE);
                        ASTGENode jjtn004 = new ASTGENode(this, JJTGENODE);
                        boolean jjtc004 = true;
                        jjtree.openNodeScope(jjtn004);
        try {
          AdditiveExpression();
        } catch (Throwable jjte004) {
                        if (jjtc004) {
                          jjtree.clearNodeScope(jjtn004);
                          jjtc004 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte004 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte004;}
                        }
                        if (jjte004 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte004;}
                        }
                        {if (true) throw (Error)jjte004;}
        } finally {
                        if (jjtc004) {
                          jjtree.closeNodeScope(jjtn004,  2);
                        }
        }
        break;
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void AdditiveExpression() throws ParseException {
    MultiplicativeExpression();
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case PLUS:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_42;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
                  ASTAddNode jjtn001 = new ASTAddNode(this, JJTADDNODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte001) {
                  if (jjtc001) {
                    jjtree.clearNodeScope(jjtn001);
                    jjtc001 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte001 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte001;}
                  }
                  if (jjte001 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte001;}
                  }
                  {if (true) throw (Error)jjte001;}
        } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001,  2);
                  }
        }
        break;
      case MINUS:
        jj_consume_token(MINUS);
                  ASTSubtractNode jjtn002 = new ASTSubtractNode(this, JJTSUBTRACTNODE);
                  boolean jjtc002 = true;
                  jjtree.openNodeScope(jjtn002);
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte002) {
                  if (jjtc002) {
                    jjtree.clearNodeScope(jjtn002);
                    jjtc002 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte002 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte002;}
                  }
                  if (jjte002 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte002;}
                  }
                  {if (true) throw (Error)jjte002;}
        } finally {
                  if (jjtc002) {
                    jjtree.closeNodeScope(jjtn002,  2);
                  }
        }
        break;
      default:
        jj_la1[95] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
    UnaryExpression();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULUS:
        ;
        break;
      default:
        jj_la1[96] = jj_gen;
        break label_43;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        jj_consume_token(MULTIPLY);
                          ASTMulNode jjtn001 = new ASTMulNode(this, JJTMULNODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
        try {
          UnaryExpression();
        } catch (Throwable jjte001) {
                          if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte001;}
                          }
                          if (jjte001 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte001;}
                          }
                          {if (true) throw (Error)jjte001;}
        } finally {
                          if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001,  2);
                          }
        }
        break;
      case DIVIDE:
        jj_consume_token(DIVIDE);
                        ASTDivNode jjtn002 = new ASTDivNode(this, JJTDIVNODE);
                        boolean jjtc002 = true;
                        jjtree.openNodeScope(jjtn002);
        try {
          UnaryExpression();
        } catch (Throwable jjte002) {
                        if (jjtc002) {
                          jjtree.clearNodeScope(jjtn002);
                          jjtc002 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte002 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte002;}
                        }
                        if (jjte002 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte002;}
                        }
                        {if (true) throw (Error)jjte002;}
        } finally {
                        if (jjtc002) {
                          jjtree.closeNodeScope(jjtn002,  2);
                        }
        }
        break;
      case MODULUS:
        jj_consume_token(MODULUS);
                         ASTModNode jjtn003 = new ASTModNode(this, JJTMODNODE);
                         boolean jjtc003 = true;
                         jjtree.openNodeScope(jjtn003);
        try {
          UnaryExpression();
        } catch (Throwable jjte003) {
                         if (jjtc003) {
                           jjtree.clearNodeScope(jjtn003);
                           jjtc003 = false;
                         } else {
                           jjtree.popNode();
                         }
                         if (jjte003 instanceof RuntimeException) {
                           {if (true) throw (RuntimeException)jjte003;}
                         }
                         if (jjte003 instanceof ParseException) {
                           {if (true) throw (ParseException)jjte003;}
                         }
                         {if (true) throw (Error)jjte003;}
        } finally {
                         if (jjtc003) {
                           jjtree.closeNodeScope(jjtn003,  2);
                         }
        }
        break;
      default:
        jj_la1[97] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void UnaryExpression() throws ParseException {
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[98] = jj_gen;
        break label_44;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOGICAL_NOT:
      jj_consume_token(LOGICAL_NOT);
                           ASTNotNode jjtn001 = new ASTNotNode(this, JJTNOTNODE);
                           boolean jjtc001 = true;
                           jjtree.openNodeScope(jjtn001);
      try {
        UnaryExpression();
      } catch (Throwable jjte001) {
                           if (jjtc001) {
                             jjtree.clearNodeScope(jjtn001);
                             jjtc001 = false;
                           } else {
                             jjtree.popNode();
                           }
                           if (jjte001 instanceof RuntimeException) {
                             {if (true) throw (RuntimeException)jjte001;}
                           }
                           if (jjte001 instanceof ParseException) {
                             {if (true) throw (ParseException)jjte001;}
                           }
                           {if (true) throw (Error)jjte001;}
      } finally {
                           if (jjtc001) {
                             jjtree.closeNodeScope(jjtn001,  1);
                           }
      }
      break;
    case MINUS:
      jj_consume_token(MINUS);
                   ASTNegateNode jjtn002 = new ASTNegateNode(this, JJTNEGATENODE);
                   boolean jjtc002 = true;
                   jjtree.openNodeScope(jjtn002);
      try {
        PrimaryExpression();
      } catch (Throwable jjte002) {
                   if (jjtc002) {
                     jjtree.clearNodeScope(jjtn002);
                     jjtc002 = false;
                   } else {
                     jjtree.popNode();
                   }
                   if (jjte002 instanceof RuntimeException) {
                     {if (true) throw (RuntimeException)jjte002;}
                   }
                   if (jjte002 instanceof ParseException) {
                     {if (true) throw (ParseException)jjte002;}
                   }
                   {if (true) throw (Error)jjte002;}
      } finally {
                   if (jjtc002) {
                     jjtree.closeNodeScope(jjtn002,  1);
                   }
      }
      break;
    case LBRACKET:
    case LEFT_CURLEY:
    case LPAREN:
    case WHITESPACE:
    case NEWLINE:
    case STRING_LITERAL:
    case TRUE:
    case FALSE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case IDENTIFIER:
    case OLD_IDENTIFIER:
    case LCURLY:
      PrimaryExpression();
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PrimaryExpression() throws ParseException {
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[101] = jj_gen;
        break label_45;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      StringLiteral();
      break;
    case IDENTIFIER:
    case OLD_IDENTIFIER:
    case LCURLY:
      Reference();
      break;
    case INTEGER_LITERAL:
      IntegerLiteral();
      break;
    default:
      jj_la1[103] = jj_gen;
      if (jj_2_24(2147483647)) {
        IntegerRange();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FLOATING_POINT_LITERAL:
          FloatingPointLiteral();
          break;
        case LEFT_CURLEY:
          Map();
          break;
        case LBRACKET:
          ObjectArray();
          break;
        case TRUE:
          True();
          break;
        case FALSE:
          False();
          break;
        case LPAREN:
          jj_consume_token(LPAREN);
          Expression();
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[105] = jj_gen;
        break label_46;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_3_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_scan_token(WHITESPACE)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !isRightParenthesis();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_55()) return true;
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_scan_token(PIPE)) return true;
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_119()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_118()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_108()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_128()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_110()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_16()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_111()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_99()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(INDEX_LBRACKET)) return true;
    if (jj_3R_122()) return true;
    if (jj_scan_token(INDEX_RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_58()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_61()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DOUBLEDOT)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_3R_97()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_98()) jj_scanpos = xsp;
    if (jj_scan_token(REFMOD2_RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_166() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_65()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_68()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DOUBLEDOT)) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_108()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_50()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_53()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DOUBLEDOT)) return true;
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_86()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_57()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_149() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_153()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_164()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_scan_token(LOGICAL_NOT)) return true;
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_124()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_108()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_125()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_112() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_142() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(MODULUS)) return true;
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_142()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_146() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(MULTIPLY)) return true;
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_171()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_112()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_165()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DOUBLEDOT)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_166()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_169()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_136()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_146()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) return true;
    }
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(WORD)) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_137()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_116()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_scan_token(LOGICAL_GE)) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_scan_token(LOGICAL_LE)) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) return true;
    }
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_scan_token(LOGICAL_GT)) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_scan_token(LOGICAL_LT)) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_120() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_115() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_120()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_57()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_170()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_130()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_133()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_scan_token(LOGICAL_NOT_EQUALS)) return true;
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(LEFT_CURLEY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) return true;
    }
    return false;
  }

  private boolean jj_3R_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_scan_token(LOGICAL_EQUALS)) return true;
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_127()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_131()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_scan_token(LOGICAL_AND)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_123()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_129()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_126() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) return true;
    }
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_121()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_126()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(SINGLE_LINE_COMMENT_START)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(26)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(FORMAL_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(MULTI_LINE_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(WHITESPACE)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(DOUBLE_ESCAPE)) return true;
    return false;
  }

  private boolean jj_3_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_scan_token(WHITESPACE)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(ZERO_WIDTH_WHITESPACE)) return true;
    if (jj_scan_token(0)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) jj_scanpos = xsp;
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public StandardParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[107];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x20000000,0x20000,0xc022,0x14,0x4000000,0x1a000000,0x0,0x0,0x1080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x4000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x2000,0x200,0x1080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1080,0x0,0x0,0x200,0x5080,0x0,0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x20,0x2000,0x0,0xc022,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5080,0x0,0x0,0x0,0x5080,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0xc00000f,0x0,0x0,0x0,0x0,0x84000008,0x8000030,0x1,0x80000000,0x3,0x3,0x3,0x3,0x3,0x3,0x0,0x3,0x3,0x3,0x3,0x0,0x0,0x3,0x3,0x1,0x1,0x1,0x0,0x3,0x3,0x0,0x0,0xc00003b,0x3,0x3,0x4000000,0x3,0x3,0x3,0x3,0x4000000,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x4000008,0x8000030,0x3,0x3,0x0,0xc08007b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000008,0x1,0x3,0x3,0x1,0x1,0x1,0x1,0x1,0x3,0x3,0x1,0x1,0x3,0x3,0x3,0x3,0x1,0x1000,0x1000,0x800,0x60000,0x60000,0x1e000,0x1e000,0xc0,0xc0,0x700,0x700,0x3,0x3,0xc08007b,0x3,0x3,0x4000008,0x8000030,0x3,0x3,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x4000,0x0,0x1000,0x1e380,0x0,0x0,0x0,0x48,0x148,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x148,0x0,0x0,0x148,0x0,0x0,0x0,0x0,0x148,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x148,0x0,0x0,0x0,0x148,0x48,0x0,0x48,0x0,0x48,0x0,0x48,0x0,0x0,0x200,0x148,0x16380,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x148,0x0,0x0,0x148,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[24];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public StandardParser(CharStream stream) {
    token_source = new StandardParserTokenManager(this, stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 107; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_lookingAhead = false;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 107; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public StandardParser(StandardParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 107; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(StandardParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 107; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[81];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 107; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 81; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 24; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
