#
# spec file for package suse-build-key
#
# Copyright (c) 2017 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#
# needspubkeyforbuild

%bcond_with     build_key_include_prjkey

Name:           suse-build-key
BuildRequires:  gpg
Url:		https://www.suse.com/support/security/keys/
Provides:       build-key
Requires:       gpg
AutoReqProv:    off
Summary:        The public gpg key for rpm package signature verification
License:        GPL-2.0+
Group:          System/Packages
Version:        12.0
Release:        150000.8.61.2

#pub   rsa4096/0xF74F09BC3FA1D6CE 2023-01-19 [SC] [expires: 2029-03-05]
#      Key fingerprint = 7F00 9157 B127 B994 D5CF  BE76 F74F 09BC 3FA1 D6CE
#uid                             SUSE Package Signing Key <build@suse.de>
# 4096bit RSA signing key for SLE 15, used since SP6
Source5:	gpg-pubkey-3fa1d6ce-67c856ee.asc

# pub  2048R/39DB7C82 2013-01-31 SuSE Package Signing Key <build@suse.de>
# The main package signing key.
Source0:        gpg-pubkey-39db7c82-66c5d91a.asc

# pub  2048R/50A3DD1C 2013-01-14 SuSE Package Signing Key (reserve key) <build@suse.de>
# Fallback key if main key gets lost.
Source1:        gpg-pubkey-50a3dd1c-50f35137.asc
# pub   rsa4096/0xA1BFC02BD588DC46 2023-01-19 [SC] [expires: 2033-01-16]
#      Key fingerprint = B56E 5601 41D8 F654 2DFF  3BF9 A1BF C02B D588 DC46
# uid                             SUSE Package Signing Key (reserve key) <build@suse.de>
# Fallback key if main key gets lost.
Source10:	gpg-pubkey-d588dc46-63c939db.asc

# pub  1024R/307E3D54 2006-03-21 SuSE Package Signing Key <build@suse.de>
# SLES 11 key.
Source2:        suse-sle11-key.asc

#pub   rsa2048/0x8EFE1BC4D4ADE9C3 2017-12-11 [SC] [expires: 2027-12-09]
#     Key fingerprint = 0EE9 CA43 0050 9E29 17A0  54ED 8EFE 1BC4 D4AD E9C3
# container key used by Container TUF style signing.
Source3:	build-container-d4ade9c3-5a2e9669.asc
Source4:	build-container-d4ade9c3-5a2e9669.pem

#pub   rsa4096/0x100CEB438FD6C337 2023-01-19 [SC] [expires: 2027-01-18]
#      Key fingerprint = 2BFA 4649 1A1C FFA8 31EF  C4B6 100C EB43 8FD6 C337
#uid                             SUSE Linux Container Signing Key <build-container@suse.de>
# container signingkey for registry.suse.com, 4096 bit RSA / 2023 variant.
Source6:	build-container-8fd6c337-63c94b45.asc
Source7:        build-container-8fd6c337-63c94b45.pem

#pub   rsa4096/0x1D441A8CC0ACC782 2023-01-19 [SC] [expires: 2027-01-18]
#      Key fingerprint = BDA8 1B26 D46C 7B46 129F  391D 1D44 1A8C C0AC C782
#uid                             SUSE PTF Container Signing Key <support-container@suse.com>
# 4096 bit PTF containersigning key.
Source8:	suse_ptf_containerkey_2023.pem
Source9:	suse_ptf_containerkey_2023.asc

# SLE16 / SL Micro 6 Keys
#pub   rsa4096/0xFEC28EAF09D9EA69 2023-05-10 [SC] [expires: 2029-08-01]
#      Key fingerprint = 1C59 D66F CD52 563A 1693  3DBC FEC2 8EAF 09D9 EA69
#uid                             SUSE 16 Package Signing Key <build-suse16@suse.de>
Source11:       gpg-pubkey-09d9ea69-68595a8c.asc
# reserve key
#pub   rsa4096/0xC7B81E4373F03759 2022-04-29 [SC] [expires: 2032-04-26]
#      Key fingerprint = 5056 7568 F292 0FF1 65B2  5FB2 C7B8 1E43 73F0 3759
#uid                             ALP Package Signing Key (reserve key) <build-alp@suse.de>
Source12:       gpg-pubkey-73f03759-626bd414.asc


#pub   rsa2048/0x9F2528FDB76EB97A 2018-04-24 [SC] [expires: 2026-02-24]
#      Key fingerprint = 9109 9832 523C C4EF 9741  F3A5 9F25 28FD B76E B97A
#uid                             SUSE PTF Container Signing Key <support-container@suse.com>
Source96:	suse_ptf_containerkey.asc
# pub  1024D/B37B98A9 2005-05-11 SUSE PTF Signing Key <support@suse.com>
# SUSE supplied PTF (program temporary fixes) are signed by this key.
# supplied to be not imported by default
Source97:       suse_ptf_key_old.asc
#pub   rsa2048/0x46DFA05C6F5DA62B 2022-02-25 [SC] [expires: 2029-03-05]
#      Key fingerprint = 1604 494D 38DA 2FA7 AA26  97AE 46DF A05C 6F5D A62B
#uid                             SUSE PTF Signing Key <support@suse.com>
Source98:       suse_ptf_key.asc

#pub   rsa4096/0x09461C70AF5425F7 2023-01-19 [SC] [expires: 2029-03-05]
#      Key fingerprint = 6D6C 8072 BF35 2152 3062  D823 0946 1C70 AF54 25F7
#uid                             SUSE PTF Signing Key <support@suse.com>
#
# new 4096bit RSA PTF signing key
Source95:	suse_ptf_key_2023.asc

#pub   rsa4096/0xB205E69BAB2FD922 2020-03-10 [SC] [expires: 2024-02-24]
#      Key fingerprint = 2BAB 445F B9B4 F0D3 30E4  7CB0 B205 E69B AB2F D922
#uid                             SUSE Security Team <security@suse.de>
#uid                             SUSE Security Team <security@suse.com>
#sub   rsa4096/0xA679ED66FD417627 2020-03-10 [E] [expires: 2024-02-24]
Source99:       security_at_suse_de.asc

Source100:      dumpsigs
Source101:	import-suse-build-key
Source102:	suse-build-key-import.service
Source103:	suse-build-key-import.timer

Source1000:	key2rpmname

BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildArch:      noarch
%define keydir  %{_prefix}/lib/rpm/gnupg/keys
%define containerkeydir  %{_prefix}/share/container-keys/
%define pemcontainerkeydir  %{_prefix}/share/pki/containers/
PreReq:         sh-utils gpg fileutils mktemp
BuildRequires:	systemd-rpm-macros


# obsoletes old SLE11 build key, as it is 1024 bit only
Obsoletes:	gpg-pubkey-b37b98a9
# fixme: next release obsolete old PTF key.

%description
This package contains the gpg keys that are used to sign the
SUSE rpm packages. The keys installed here are not actually
used by directly, but need to be imported to the RPM database first.

rpm/zypper use only the keys in the RPM database.

The package also contains the Container signing keys in GPG and in X.509
PEM format for use by Docker Notary and Sigstore/Cosign.

%prep
%setup -qcT

%build
cp %SOURCE2 .
cp %SOURCE8 .
cp %SOURCE9 .
cp %SOURCE95 .
cp %SOURCE96 .
cp %SOURCE97 .
cp %SOURCE98 .
cp %SOURCE99 .

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{keydir}

%if %{with build_key_include_prjkey}
if [ -e "%_sourcedir/_pubkey" ]; then
    name="$(bash %{SOURCE1000} %_sourcedir/_pubkey).asc"
    if [ ! -e "%_sourcedir/$name" ]; then
        install -D -m 644 %_sourcedir/_pubkey %{buildroot}%keydir/"$name"
    fi
fi
%endif

for i in %sources; do
    case "$i" in
        */gpg-pubkey-*.asc|*/*ptf_key.asc|*/*ptf_key_2023.asc)
        install -m 644 "$i" $RPM_BUILD_ROOT%{keydir}
        ;;
    esac
done
install -m 755 %{SOURCE100} $RPM_BUILD_ROOT/usr/lib/rpm/gnupg

install -d -m 755 $RPM_BUILD_ROOT%{containerkeydir}/
install -c -m 644 %{SOURCE3} $RPM_BUILD_ROOT%{containerkeydir}/suse-container-key-old.asc
install -c -m 644 %{SOURCE6} $RPM_BUILD_ROOT%{containerkeydir}/suse-container-key.asc
# keep it there too for compat
install -c -m 644 %{SOURCE4} $RPM_BUILD_ROOT%{containerkeydir}/suse-container-key-old.pem
install -c -m 644 %{SOURCE7} $RPM_BUILD_ROOT%{containerkeydir}/suse-container-key.pem
install -d -m 755 $RPM_BUILD_ROOT%{pemcontainerkeydir}/
install -c -m 644 %{SOURCE4} $RPM_BUILD_ROOT%{pemcontainerkeydir}/suse-container-key-old.pem
install -c -m 644 %{SOURCE7} $RPM_BUILD_ROOT%{pemcontainerkeydir}/suse-container-key.pem

# not working well, as some customers have no-exec /var
#
# install -d -m 755 %{buildroot}/var/adm/update-scripts/
# install -m 755 %{SOURCE101} $RPM_BUILD_ROOT/var/adm/update-scripts/%{name}-%{version}-%{release}-import-suse-build-key.sh
mkdir -p $RPM_BUILD_ROOT/usr/bin/
mkdir -p $RPM_BUILD_ROOT/var/lib/suse-build-key
install -m 755 %{SOURCE101} $RPM_BUILD_ROOT/usr/bin/import-suse-build-key
mkdir -p $RPM_BUILD_ROOT/%_unitdir
install -m 644 %{SOURCE102} $RPM_BUILD_ROOT/%_unitdir
install -m 644 %{SOURCE103} $RPM_BUILD_ROOT/%_unitdir

%post
touch /var/lib/%{name}/imported
%service_add_post suse-build-key-import.service suse-build-key-import.timer
test -x /usr/bin/systemctl && systemctl enable suse-build-key-import.timer && systemctl start suse-build-key-import.timer || true

%pre
%service_add_pre suse-build-key-import.service suse-build-key-import.timer

%preun
%service_del_preun suse-build-key-import.service suse-build-key-import.timer

%postun
%service_del_postun suse-build-key-import.service suse-build-key-import.timer


%files
%defattr(644,root,root)
%doc security_at_suse_de.asc suse_ptf_key.asc suse_ptf_containerkey.asc suse_ptf_containerkey_2023.asc suse_ptf_containerkey_2023.pem suse-sle11-key.asc suse_ptf_key_old.asc
%attr(755,root,root) %dir %{_prefix}/lib/rpm/gnupg
%attr(755,root,root) %dir %{keydir}
%attr(755,root,root) %dir %{containerkeydir}
%attr(755,root,root) %dir /usr/share/pki/
%attr(755,root,root) %dir %{pemcontainerkeydir}
%attr(755,root,root) %{_prefix}/lib/rpm/gnupg/dumpsigs
%{keydir}/gpg-pubkey-50a3dd1c-50f35137.asc
%{keydir}/gpg-pubkey-39db7c82-66c5d91a.asc
%{keydir}/gpg-pubkey-3fa1d6ce-67c856ee.asc
%{keydir}/gpg-pubkey-d588dc46-63c939db.asc
%{keydir}/gpg-pubkey-09d9ea69-68595a8c.asc
%{keydir}/gpg-pubkey-73f03759-626bd414.asc
%{keydir}/suse_ptf_key.asc
%{keydir}/suse_ptf_key_2023.asc
%{containerkeydir}/suse-container-key.asc
%{containerkeydir}/suse-container-key.pem
%{containerkeydir}/suse-container-key-old.asc
%{containerkeydir}/suse-container-key-old.pem
%{pemcontainerkeydir}/suse-container-key.pem
%{pemcontainerkeydir}/suse-container-key-old.pem
# /var/adm/update-scripts/%{name}-%{version}-%{release}-import-suse-build-key.sh
%attr(755,root,root) %_bindir/import-suse-build-key
%dir /var/lib/%{name}
%ghost /var/lib/%{name}/imported
%_unitdir/suse-build-key-import.service
%_unitdir/suse-build-key-import.timer

%changelog
* Fri Jul 11 2025 meissner@suse.com
- adjust UID (name + email) of SLES16 signing key with official
  names. (bsc#1245223)
* Wed Mar  5 2025 meissner@suse.com
- changed keys to use SHA256 UIDs instead of SHA1. (bsc#1237294
  bsc#1236779 jsc#PED-12321)
  - gpg-pubkey-3fa1d6ce-67c856ee.asc to gpg-pubkey-09d9ea69-67c857f3.asc
  - gpg-pubkey-09d9ea69-645b99ce.asc to gpg-pubkey-3fa1d6ce-63c9481c.asc
  - suse_ptf_key_2023.asc, suse_ptf_key.asc: adjusted
* Wed Aug 21 2024 meissner@suse.com
- extended 2048 bit SUSE SLE 12, 15 GA-SP5 key until 2028. (bsc#1229339)
  - gpg-pubkey-39db7c82-5f68629b.asc
  + gpg-pubkey-39db7c82-66c5d91a.asc
* Tue Jul 30 2024 eugenio.paolantonio@suse.com
- ensure key2rpmname is called using bash.
* Fri Jul 19 2024 meissner@suse.com
- make the per-project inclusion optional, default off.
* Thu Jul 18 2024 meissner@suse.com
- Also include the GPG key from the current build project
  to allow Staging testing without production keys. (bsc#1231829)
* Fri Jul 12 2024 meissner@suse.com
- added missing ; in shell script (bsc#1227681)
* Mon Jul  8 2024 meissner@suse.com
- Added new keys of the SLE Micro 6.0 / SLES 16 series, and auto import
  them. (bsc#1227429)
  gpg-pubkey-09d9ea69-645b99ce.asc: Main SLE Micro 6/SLES 16 key
  gpg-pubkey-73f03759-626bd414.asc: Backup SLE Micro 6/SLES 16 key.
* Fri Feb  9 2024 meissner@suse.com
- Switch container key to be default RSA 4096bit. (jsc#PED-2777)
* Sun Jan 28 2024 meissner@suse.com
- run rpm commands in import script only when libzypp is not
  active. bsc#1219189 bsc#1219123
* Sun Jan 28 2024 meissner@suse.com
- run import script also in %%posttrans section, but only when
  libzypp is not active. bsc#1219189 bsc#1219123
* Thu Nov 16 2023 meissner@suse.com
- replace libzypp-post-script based installation with a systemd timer
  and service.
  - suse-build-key-import.service
  - suse-build-key-import.timer
* Fri Sep  8 2023 meissner@suse.com
- add and run a import-suse-build-key scripts, this will be ran
  after installation with libzypp based installers. (jsc#PED-2777)
* Tue Feb  7 2023 meissner@suse.com
- Establish multiple new 4096 RSA keys that we will switch
  to mid of 2023. (jsc#PED-2777)
  - gpg-pubkey-3fa1d6ce-63c9481c.asc: new 4096 RSA signing key for SLE (RPM+repos).
  - gpg-pubkey-d588dc46-63c939db.asc: new 4096 RSA reserver key for SLE (RPM+repos).
  - suse_ptf_key_4096.asc: new 4096 RSA signing key for PTF RPMs.
  - build-container-8fd6c337-63c94b45.asc/build-container-8fd6c337-63c94b45.pem:
    new RSA 4096 key for the SUSE registry registry.suse.com, installed as
    suse-container-key-2023.pem and suse-container-key-2023.asc
  - suse_ptf_containerkey_2023.asc suse_ptf_containerkey_2023.pem:
    New PTF container signing key for registry.suse.com/ptf/ space.
* Tue Oct 25 2022 meissner@suse.com
- added /usr/share/pki/containers directory for container pem keys
  (cosign/sigstore style), put our PEM key there too (bsc#1204706)
* Thu Apr 21 2022 meissner@suse.com
- still ship the old ptf key (was not added to documentation by mistake).
  (bsc#1198504)
* Thu Mar 24 2022 meissner@suse.com
- No longer install 1024bit keys by default. (bsc#1197293)
  - SLE11 key moved to documentation
  - old PTF (pre March 2022) moved to documentation only
* Thu Feb 17 2022 meissner@suse.com
- extended expiry of SUSE PTF key, move it to suse_ptf_key_old.asc
- added new SUSE PTF key with RSA2048 bit as suse_ptf_key.asc (bsc#1196494)
- extended expiry of SUSE SLES11 key (bsc#1194845)
- added SUSE Contaner signing key in PEM format for use e.g. by cosign.
- SUSE security key replaced with 2022 edition (E-Mail usage only). (bsc#1196495)
* Mon Sep 21 2020 meissner@suse.com
- suse build key extended (bsc#1176759)
  gpg-pubkey-39db7c82-5847eb1f.asc -> gpg-pubkey-39db7c82-5f68629b.asc
* Thu Aug 13 2020 meissner@suse.com
- actually the container key is different from the build signing
  key. (PM-1845 bsc#1170347)
* Thu Apr 23 2020 meissner@suse.com
- add a /usr/share/container-keys/ directory for GPG based Container
  verification.
- Add the SUSE build key as "suse-container-key.asc". (PM-1845 bsc#1170347)
* Wed Mar 11 2020 meissner@suse.com
- created a new security@suse.de communication key (bsc#1166334)
* Tue Nov 13 2018 meissner@suse.com
- include ptf key in the key directory to avoid it being
  stripped via %%doc stripping. (bsc#1044232)
* Wed Mar 28 2018 meissner@suse.com
- created a new security@suse.de communication key. (bsc#1082022)
- extended the PTF key and the SLE10 build@suse.de key. (bsc#1085512)
* Wed Dec  7 2016 meissner@suse.com
- extend the build@suse.de product key. (bsc#1014151)
  pub  2048R/39DB7C82 2013-01-31 [expires: 2020-12-06]
  uid                            SuSE Package Signing Key <build@suse.de>
* Tue Nov 29 2016 ro@suse.de
- use dumpsigs script from openSUSE to merge code
* Thu Oct  2 2014 meissner@suse.com
- renamed security_at_suse_de.asc to security_at_suse_de_old.asc
- security_at_suse_de.asc: new 4096 bit RSA key.
  pub  4096R/317CD502 2014-10-02 SUSE Security Team <security@suse.de>
  bnc#899509
* Fri Aug 29 2014 meissner@suse.com
- Went to new method again.
  - suse-build-key.gpg blob dropped
  - ship seperate files
* Mon Feb 10 2014 meissner@suse.com
- create suse-build-key.gpg during build.
- Remove old keys from keyring. (fate#314767)
  Keys currently inside the RPM trusted keyring:
  - pub  2048R/39DB7C82 SuSE Package Signing Key <build@suse.de>
  - pub  2048R/50A3DD1C SuSE Package Signing Key (reserve key) <build@suse.de>
- Various keys are moved to the documentation area
  (/usr/share/doc/packages/suse-build-key)
  - build-at-suse-sle11.asc: the old SUSE Linux Enterprise 11 key.
    if SUSE Linux Enterprise 11 packages need to be verified on
    a SUSE Linux Enterprise 12 system.
  - suse_ptf_key.asc: The suse ptf key. For verification of provided PTFs.
  - security_at_suse_de.asc: Use only for email encryption and
    verification purposes when contacting our security contact address
    security@suse.de
* Mon Jan 13 2014 meissner@suse.com
- reverted to contain the fullkeyring build SLE12 Alpha.
- also list the old sle11 build@suse.de key temporary
* Thu Jan  9 2014 meissner@suse.com
- Merged over logic from openSUSE-build-key.
- Got rid of default importing into roots keyring.
- Removed some old keys.
- Clarify that security@suse.de is a email only key
- PTF key is supplied also as %%doc, to not be default
  imported.
- Keys currently inside:
  - pub  2048R/39DB7C82 SuSE Package Signing Key <build@suse.de>
  - pub  2048R/50A3DD1C SuSE Package Signing Key (reserve key) <build@suse.de>
  - pub  1024D/B37B98A9 SUSE PTF Signing Key <support@suse.com>
  - pub  2048R/3D25D3D9 SuSE Security Team <security@suse.de>
* Thu Jan 31 2013 ro@suse.de
- added future signing key for SLES (fate#314767) (bnc#801055)
  using 2048 bit rsa key
* Mon Jan 14 2013 ro@suse.de
- added reserve key for SLES (fate#312896)
  50A3DD1C SuSE Package Signing Key (reserve key) <build@suse.de>
  valid until (2017-01-13)
* Sun Oct 21 2012 ro@suse.de
- export keys to single files in /usr/lib/rpm/gnupg/keys
* Mon Dec 12 2011 ro@suse.de
- reduced key list. remaining keys:
  307E3D54 SuSE Package Signing Key <build@suse.de>
  3D25D3D9 SuSE Security Team <security@suse.de>
  9C800ACA SuSE Package Signing Key <build@suse.de>
  B37B98A9 SUSE PTF Signing Key <support@suse.com>
* Fri Jan 28 2011 ro@suse.de
- if we have to set $HOME, we also have to export the variable
  (bnc#665912)
* Tue May  4 2010 ro@suse.de
- updated keys: (bnc#600157,bnc#599167)
  - 307E3D54 build@suse.de "SuSE Package Signing Key" (2014-05-03)
  - 9C800ACA build@suse.de "SuSE Package Signing Key" (2014-05-03)
  - B37B98A9 support@suse.com "SUSE PTF Signing Key" (2014-05-03)
  - 7E2E3B05 novell-provo-build@novell.com "Novell Provo Build"
    (2014-05-06)
- added keys:
  - 1D061A62 support@novell.com
    "build@novell.com (Novell Linux Products)" (2014-05-06)
* Fri Oct 31 2008 ro@suse.de
- added ptf key, expiring 2010-07-02
* Mon Jun  2 2008 ro@suse.de
- update keys again: for collaboration with rpm, the current
  self-signature needs to be the first signature found in a key
* Mon May  5 2008 ro@suse.de
- updated keys
  9C800ACA,8495160C,307E3D54: extend expiration by 2 years
  until 2010-05-05
  7E2E3B05: extend expiration by 2 years until 2010-05-24
* Mon Mar 19 2007 rguenther@suse.de
- merge suse-build-key keyring to roots gpg pubring
* Mon May 29 2006 ro@suse.de
- added new official provo dsa autobuild key ID 7E2E3B05
* Fri May 19 2006 ro@suse.de
- removed unused provo autobuild key
- added new official provo autobuild key ID A1912208
* Thu Apr 20 2006 ro@suse.de
- add dumpsigs script here to have _one_ place for the script
* Fri Mar 31 2006 ro@suse.de
- added build@suse.de rsa key ID 307E3D54
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Tue Oct 18 2005 ro@suse.de
- use correct provo autobuild key
* Tue Oct 18 2005 ro@suse.de
- added provo autobuild signing key (#128128)
- removed jds key
* Fri May 27 2005 mls@suse.de
- added mktemp to PreReqs [#86177]
* Thu Apr 28 2005 ro@suse.de
- added JDS public key (15c17deb)
* Tue Jan 25 2005 ro@suse.de
- added OES public key (0dfb3188)
* Tue Jun 22 2004 ro@suse.de
- updated build key (expiration changed to 2008-06-21) (#42326)
* Tue Feb 24 2004 hmacht@suse.de
- building as non-root
* Tue Sep  9 2003 ro@suse.de
- ignore return code from first gpg calls
* Tue Sep  9 2003 draht@suse.de
- call gpg twice without any arguments for proper initialization
  inside postinstall
* Tue Sep  9 2003 draht@suse.de
- use temp file instead of pipe due to resource race between two
  instances of gpg in %%post.
* Thu Sep  5 2002 draht@suse.de
- package now installs key from package-owned file into the rpm
  pubring in %%post to allow other key packages to add their keys.
* Tue Aug 20 2002 mmj@suse.de
- Correct PreReq
* Fri Jul 26 2002 kukuk@suse.de
- Change Provides from suse-build-key to build-key
* Wed Feb 20 2002 draht@suse.de
- directory permission problem: 644 -> 755.
* Mon Feb 18 2002 ro@suse.de
- moved to /usr/lib/rpm/gnupg/pubring.pgp
  rpm needs a directory as gpg_path and will use pubring.gpg
  in that directory
* Wed Feb 13 2002 draht@suse.de
- initial package. Contains
  - pub  2048R/3D25D3D9 1999-03-06 SuSE Security Team <security@suse.de>
  - pub  1024D/9C800ACA 2000-10-19 SuSE Package Signing Key <build@suse.de>
  - sub  2048g/8495160C 2000-10-19 [expires: 2006-02-12]
