#
# spec file for package polkit
#
# Copyright (c) 2022 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define _polkit_rulesdir %{_datadir}/polkit-1/rules.d
%define glib_br_version  2.30.0
%define run_tests        1

Name:           polkit
Version:        121
Release:        150500.3.6.1
Summary:        PolicyKit Authorization Framework
License:        LGPL-2.1-or-later
Group:          System/Libraries
URL:            https://www.freedesktop.org/wiki/Software/polkit/
Source0:        https://www.freedesktop.org/software/polkit/releases/%{name}-%{version}.tar.gz
Source1:        https://www.freedesktop.org/software/polkit/releases/%{name}-%{version}.tar.gz.sign
Source2:        %{name}.keyring
Source3:        system-user-polkitd.conf
Source99:       baselibs.conf

# Upstream First - Policy:
# Never add any patches to this package without the upstream commit id
# in the patch. Any patches added here without a very good reason to make
# an exception will be silently removed with the next version update.

# PATCH-FIX-OPENSUSE polkit-no-wheel-group.patch vuntz@opensuse.org -- In openSUSE, there's no special meaning for the wheel group, so we shouldn't allow it to be admin
Patch0:         polkit-no-wheel-group.patch
# PATCH-FIX-OPENSUSE polkit-gettext.patch lnussel@suse.de -- allow fallback to gettext for polkit action translations
# polkit-use-gettext-as-fallback.patch
Patch1:         polkit-gettext.patch
# PATCH-FIX-OPENSUSE polkit-keyinit.patch meissner@ -- bsc#1144053 Please add "pam_keyinit.so" to the /etc/pam.d/polkit-1 configuration file
Patch3:         polkit-keyinit.patch
# PATCH-FIX-UPSTREAM polkit-fix-pam-prefix.patch luc14n0@opensuse.org -- Make
# intended use of pam_prefix meson option rather than hard-coded path
Patch5:         polkit-fix-pam-prefix.patch
# PATCH-FIX-UPSTREAM 0001-Nested-.policy-files-cause-xml-parsing-overflow-lead.patch meissner@ -- 1246472 VUL-0: CVE-2025-7519 polkit: XML policy file with a large number of nested elements may lead to out-of-bounds write 
Patch6:         0001-Nested-.policy-files-cause-xml-parsing-overflow-lead.patch


BuildRequires:  gcc-c++
BuildRequires:  gettext
BuildRequires:  gtk-doc
BuildRequires:  libexpat-devel
BuildRequires:  meson >= 0.50
BuildRequires:  pam-devel
BuildRequires:  pkgconfig
BuildRequires:  systemd-rpm-macros
BuildRequires:  sysuser-tools
BuildRequires:  pkgconfig(duktape) >= 2.2.0
BuildRequires:  pkgconfig(gio-unix-2.0) >= %{glib_br_version}
BuildRequires:  pkgconfig(glib-2.0) >= %{glib_br_version}
BuildRequires:  pkgconfig(gmodule-2.0) >= %{glib_br_version}
BuildRequires:  pkgconfig(gobject-introspection-1.0) >= 0.6.2
BuildRequires:  pkgconfig(libsystemd)
BuildRequires:  pkgconfig(systemd)
%if 0%{?run_tests}
#################################################################
# python3-dbus-python and python3-python-dbusmock are needed for
# test-polkitbackendjsauthority test:
BuildRequires:  python3-dbus-python
BuildRequires:  python3-python-dbusmock
#################################################################
%endif
# gtk-doc drags indirectyly ruby in for one of the helpers. This in turn causes a build cycle.
#!BuildIgnore:  ruby

Requires:       dbus-1
Requires:       libpolkit-agent-1-0 = %{version}-%{release}
Requires:       libpolkit-gobject-1-0 = %{version}-%{release}
Requires(post): permissions
%sysusers_requires
%systemd_ordering

%description
PolicyKit is a toolkit for defining and handling authorizations.
It is used for allowing unprivileged processes to speak to privileged
processes.

%package devel
Summary:        Development files for PolicyKit
Group:          Development/Libraries/C and C++
Requires:       %{name} = %{version}-%{release}
Requires:       libpolkit-agent-1-0 = %{version}
Requires:       libpolkit-gobject-1-0 = %{version}
Requires:       pkgconfig
Requires:       typelib-1_0-Polkit-1_0 = %{version}

%description devel
Development files for PolicyKit Authorization Framework.

%package -n pkexec
Summary:        Pkexec component of polkit
Group:          System/Libraries
Requires:       %{name} = %{version}-%{release}
Requires(post): permissions
Provides:       polkit:/usr/bin/pkexec

%description -n pkexec
This package contains the pkexec setuid root binary part of polkit.

%package doc
Summary:        Development documentation for PolicyKit
Group:          Development/Libraries/C and C++
BuildArch:      noarch

%description doc
Development documentation for PolicyKit Authorization Framework.

%package -n libpolkit-agent-1-0
Summary:        PolicyKit Authorization Framework -- Agent Library
Group:          System/Libraries
Requires:       %{name} >= %{version}
Provides:       libpolkit0 = %{version}-%{release}
Obsoletes:      libpolkit0 < %{version}-%{release}

%description -n libpolkit-agent-1-0
PolicyKit is a toolkit for defining and handling authorizations.
It is used for allowing unprivileged processes to speak to privileged
processes.

This package contains the agent library only.

%package -n libpolkit-gobject-1-0
Summary:        PolicyKit Authorization Framework -- GObject Library
Group:          System/Libraries
Requires:       %{name} >= %{version}
Provides:       libpolkit0 = %{version}-%{release}
Obsoletes:      libpolkit0 < %{version}-%{release}

%description -n libpolkit-gobject-1-0
PolicyKit is a toolkit for defining and handling authorizations.
It is used for allowing unprivileged processes to speak to privileged
processes.

This package contains the gobject library only.

%package -n typelib-1_0-Polkit-1_0
Summary:        PolicyKit Authorization Framework -- Introspection bindings
Group:          System/Libraries

%description -n typelib-1_0-Polkit-1_0
PolicyKit is a toolkit for defining and handling authorizations.
It is used for allowing unprivileged processes to speak to privileged
processes.

This package provides the GObject Introspection bindings for PolicyKit.

%prep
%autosetup -p1 -n polkit-v.%{version}

%build
%meson                                     \
    -D session_tracking=libsystemd-login   \
    -D systemdsystemunitdir="%{_unitdir}"  \
    -D os_type=suse                        \
    -D pam_module_dir="%{_pam_moduledir}"  \
    -D pam_prefix="%{_pam_vendordir}"      \
    -D examples=true                       \
    -D tests=true                          \
    -D gtk_doc=true                        \
    -D man=true                            \
    -D js_engine=duktape                   \
    %{nil}
%meson_build
%sysusers_generate_pre %{SOURCE3} polkit system-user-polkitd.conf

%if 0%{?run_tests}
%check
%meson_test
%endif

%install
%meson_install
%find_lang polkit-1

# create $HOME for polkit user
install -d %{buildroot}%{_localstatedir}/lib/polkit

# We use /usr/share as prefix for the rules.d directory
mv %{buildroot}%{_sysconfdir}/polkit-1/rules.d/50-default.rules \
   %{buildroot}%{_polkit_rulesdir}/50-default.rules

# Install the polkitd user creation file:
mkdir -p %{buildroot}%{_sysusersdir}
install -m0644 %{SOURCE3} %{buildroot}%{_sysusersdir}/

%pre -f polkit.pre
%service_add_pre polkit.service

%preun
%service_del_preun polkit.service

%postun
%service_del_postun polkit.service

%post -n pkexec
%set_permissions %{_bindir}/pkexec

%post
%set_permissions %{_libdir}/polkit-1/polkit-agent-helper-1
%service_add_post polkit.service

%verifyscript -n pkexec
%verify_permissions -e %{_bindir}/pkexec

%verifyscript
%verify_permissions -e %{_libdir}/polkit-1/polkit-agent-helper-1

%post -n libpolkit-agent-1-0 -p /sbin/ldconfig
%postun -n libpolkit-agent-1-0 -p /sbin/ldconfig
%post -n libpolkit-gobject-1-0 -p /sbin/ldconfig
%postun -n libpolkit-gobject-1-0 -p /sbin/ldconfig

%files -n libpolkit-agent-1-0
%{_libdir}/libpolkit-agent-1.so.*

%files -n libpolkit-gobject-1-0
%{_libdir}/libpolkit-gobject-1.so.*

%files -n typelib-1_0-Polkit-1_0
%{_libdir}/girepository-1.0/Polkit-1.0.typelib
%{_libdir}/girepository-1.0/PolkitAgent-1.0.typelib

%files -f polkit-1.lang
%doc NEWS.md README.md
%license COPYING

%{_mandir}/man1/pkaction.1%{?ext_man}
%{_mandir}/man1/pkcheck.1%{?ext_man}
%{_mandir}/man1/pkttyagent.1%{?ext_man}
%{_mandir}/man8/polkitd.8%{?ext_man}
%{_mandir}/man8/polkit.8%{?ext_man}
%dir %{_datadir}/dbus-1
%dir %{_datadir}/dbus-1/system-services
%{_datadir}/dbus-1/system-services/org.freedesktop.PolicyKit1.service
%dir %{_datadir}/dbus-1/system.d
%{_datadir}/dbus-1/system.d/org.freedesktop.PolicyKit1.conf
%dir %{_datadir}/polkit-1
%{_datadir}/polkit-1/policyconfig-1.dtd
%dir %{_datadir}/polkit-1/actions
%{_datadir}/polkit-1/actions/org.freedesktop.policykit.policy
%attr(0750,root,polkitd) %dir %{_polkit_rulesdir}
%attr(0640,root,polkitd) %{_polkit_rulesdir}/50-default.rules
%{_pam_vendordir}/polkit-1
%dir %{_sysconfdir}/polkit-1
%attr(0750,root,polkitd) %dir %{_sysconfdir}/polkit-1/rules.d
%{_bindir}/pkaction
%{_bindir}/pkcheck
%{_bindir}/pkttyagent
%dir %{_prefix}/lib/polkit-1
%{_prefix}/lib/polkit-1/polkitd
%verify(not mode) %attr(4755,root,root) %{_prefix}/lib/polkit-1/polkit-agent-helper-1
# $HOME for polkit user
%dir %{_localstatedir}/lib/polkit
%{_sysusersdir}/system-user-polkitd.conf
%{_unitdir}/polkit.service

%files devel
%{_libdir}/libpolkit-agent-1.so
%{_libdir}/libpolkit-gobject-1.so
%{_libdir}/pkgconfig/polkit-agent-1.pc
%{_libdir}/pkgconfig/polkit-gobject-1.pc
%{_includedir}/polkit-1/
%{_bindir}/pk-example-frobnicate
%{_datadir}/gir-1.0/*.gir
%{_datadir}/polkit-1/actions/org.freedesktop.policykit.examples.pkexec.policy
%{_datadir}/gettext/its/polkit.its
%{_datadir}/gettext/its/polkit.loc

%files -n pkexec
%{_mandir}/man1/pkexec.1%{?ext_man}
%verify(not mode) %attr(4755,root,root) %{_bindir}/pkexec

%files doc
%doc %{_datadir}/gtk-doc/html/polkit-1/

%changelog
* Tue Jul 15 2025 meissner@suse.com
- CVE-2025-7519: Fixed that a XML policy file with a large number of
  nested elements may lead to out-of-bounds write (bsc#1246472)
  added 0001-Nested-.policy-files-cause-xml-parsing-overflow-lead.patch
* Wed Mar 29 2023 jsegitz@suse.com
- Change permissions for rules folders (bsc#1209282)
* Thu Sep 15 2022 meissner@suse.com
- obsolete libpolkit0 also from baselibs.
* Tue Aug  9 2022 luc14n0@opensuse.org
- Update to version 121:
  + Addition of duktape as a JS engine backend.
  + Other small fixes and improvements. For more details, visit:
    gitlab.freedesktop.org/polkit/polkit/-/blob/121/NEWS.md
  + Updated translations.
- Drop merged-upstream patches:
  + CVE-2021-4034-pkexec-fix.patch;
  + 0001-CVE-2021-4115-GHSL-2021-077-fix.patch;
  + duktape-support.patch;
  + pkexec.patch.
- Replace Intltool with Gettext as a build requirement following
  the migration from last release (0.120).
- Add Meson as a build requirement while dropping Libtool and
  replace all Autotools macros with Meson ones. And pass the
  following options to Meson: session_tracking=libsystemd-login;
  systemdsystemunitdir=%%{_unitdir}; os_type=suse;
  pam_module_dir=%%{_pam_moduledir}; pam_prefix=%%{_pam_vendordir};
  examples=true; tests=true; gtk_doc=true; man=true and
  js_engine=duktape.
- Drop no longer needed Libtool as a build requirement, following
  Autotools replacement.
- Add explicit pkgconfig module build requirements for glib-2.0 and
  gobject-2.0 that are searched by the build scripts. They were
  already being pulled by their siblings [pkgconfig(gio-2.0) and
  pkgconfig(gio-unix-2.0)].
- Drop conditional macro, which was wrapping "BuildArch: noarch"
  for the doc subpackage, based on long gone EOLed (open)SUSE
  release (11.2).
- Add missing 'Requires(post): permissions' for the pkexec
  subpackage.
- Add python3-dbus-python and python3-python-dbusmock as build
  requirements in order to run test in the check section.
- Add polkit-fix-pam-prefix.patch to use the value of pam_prefix
  Meson option, like it was designed to, rather than hard-coded
  path for pam configuration files.
- Remove unneeded executable bit from 50-default.rules file.
* Mon Aug  8 2022 kukuk@suse.com
- Use %%_pam_vendordir
* Wed Aug  3 2022 meissner@suse.com
- add split-provides for polkit:/usr/bin/pkexec. (bsc#1202070)
* Mon Jul 18 2022 meissner@suse.com
- split out pkexec into seperate package to make system hardening
  easier (to avoid installing it jsc#PED-132 jsc#PED-148).
* Tue Feb 22 2022 meissner@suse.com
- Fixed denial of service via file descriptor leak (bsc#1195542 CVE-2021-4115)
  0001-CVE-2021-4115-GHSL-2021-077-fix.patch
* Wed Jan 26 2022 fvogt@suse.com
- Switch from mozjs to duktape:
  * Add duktape-support.patch
* Tue Jan 25 2022 meissner@suse.com
- Fixed pkexec Local Privilege Escalation aka pwnkit (CVE-2021-4034 bsc#1194568)
  CVE-2021-4034-pkexec-fix.patch
* Mon Dec  6 2021 dmueller@suse.com
- update to 0.120:
  * transition from Intltool to gettext
  * several tarball, meson and pipeline fixups
  * Portuguese translation
  * Romanian translation
  * meson build system added
  * CVE-2021-3560 mitigation
  * properties in text listener
  * typos fixups
  * Update Hungarian translation
- drop CVE-2021-3560.patch  (upstream)
* Wed Oct 20 2021 meissner@suse.com
- fork libpolkit0 package into libpolkit-agent-1-0 and libpolkit-gobject-1-0
  as mandated. bsc#1191781
* Sun Jul 18 2021 gmbr3@opensuse.org
- Change to using systemd-sysusers
- Remove unneeded shadow dependency, no longer required due to
  systemd-sysusers
- Fix 50-default.rules file-parent-ownership-mismatch warning
- Remove --with-pic, no effect with --disable-static
* Wed Jul  7 2021 Stefan Schubert <schubi@suse.com
- Move /etc/polkit-1/rules.d/50-default.rules to
  /usr/share/polkit-1/rules.d/50-default.rules. The first location
  is only for admin changes.
* Thu May 27 2021 meissner@suse.com
- CVE-2021-3560: fixed a local privilege escalation using polkit_system_bus_name_get_creds_sync()
  (bsc#1186497)
  CVE-2021-3560.patch
* Thu Mar 11 2021 kukuk@suse.com
- Move /etc/dbus-1/system.d to /usr/share/dbus-1/system.d, the
  first location is only for admin changes
- Move pam configuration to /usr/etc/pam.d
* Tue Dec 29 2020 matthias.gerstner@suse.com
- also set libprivdir during build, otherwhise systemd and D-Bus service files
  contain the wrong path and we'll get runtime errors.
* Fri Oct 23 2020 bjorn.lie@gmail.com
- Update to version 0.118:
  + Updated dependency to mozjs78.
  + Tarball fixes.
- Replace pkgconfig(mozjs-68) for pkgconfig(mozjs-78)
  BuildRequires following upstreams port.
* Fri Jul 31 2020 bjorn.lie@gmail.com
- Update to version 0.117:
  + Activated Gitlab CI.
  + Updated dependency to mozjs68.
  + Memory management fixes.
  + Updated translations.
- Replace pkgconfig(mozjs-60) for pkgconfig(mozjs-68)
  BuildRequires following upstreams port.
* Fri Nov 29 2019 bjorn.lie@gmail.com
- Fix usage of libexecdir instead of prefix/lib where applicable.
* Tue Oct  8 2019 meissner@suse.com
- polkit-keyinit.patch: add pam_keyinit to the polkit configuration (bsc#1144053)
* Wed May 29 2019 bjorn.lie@gmail.com
- Update to version 0.116:
  + Leaking zombie child processes.
  + Possible resource leak found by static analyzer.
  + Output messages tuneup.
  + Sanity fixes.
  + pkttyagent tty echo disabled on SIGINT.
  + HACKING: add link to Code of Conduct.
  + polkitbackend: comment typos fix.
  + configure.ac: fix detection of systemd with cgroups v2.
  + CVE-2018-19788 High UIDs overflow fix.
  + CVE-2019-6133 Slowfork vulnerability fix.
  + Allow unset process-uid.
  + Port the JS authority to mozjs-60.
  + Use JS_EncodeStringToUTF8.
  + Updated translations.
- Replace pkgconfig(mozjs-52) with pkgconfig(mozjs-60)
  BuildRequires following upstreams changes.
- Drop patches fixed upstream:
  + polkit-fix-possible-resource-leak.patch
  + polkit-fix-leaking-zombie-child-processes.patch
  + polkit-CVE-2018-19788.patch
- Refresh patches with quilt.
* Fri May 10 2019 dimstar@opensuse.org
- Use systemd_ordering instead of systemd_requires: strictly
  speaking, polkit does not require systemd to be present. Just
  that when we install on a system with systemd (e.g outside
  containers) we would want systemd to be present before
  installing polkit. Help also reduce a cycle without special hacks
  in systemd.spec.
* Fri Apr 26 2019 mvetter@suse.com
- bsc#1130588: Require shadow instead of old pwdutils
- User proper Requires(pre)/Requires(post) for permissions and
  shadow
* Thu Dec 20 2018 meissner@suse.com
- polkit-CVE-2018-19788.patch: Fixed handling of UIDs over MAX_UINT
  (bsc#1118277 CVE-2018-19788)
* Fri Aug 17 2018 bjorn.lie@gmail.com
- Add polkit-fix-possible-resource-leak.patch: Fix possible
  resource leak found by static analyzer.
- Add polkit-fix-leaking-zombie-child-processes.patch: polkitd: fix
  zombie not reaped when js spawned process timed out (fdo#106021).
* Wed Jul 11 2018 meissner@suse.com
- Update to version 0.115:
  - Fix CVE-2018-1116: Trusting client-supplied UID (bsc#1099031)
  - jsauthority: pass "%%s" format string to remaining report function
    (obsoletes polkit-jsauthority-pass-format-string.patch)
* Mon Apr  9 2018 bjorn.lie@gmail.com
- Update to version 0.114:
  + Port to mozjs 52, the latest version of the firefox JavaScript
    engine.
  + Add gettext support for policy files.
  + Fixes for various memory leaks.
  + Updated translations.
- Update keyring with Ray Strode <halfline@gmail.com> public key.
- Drop with_systemd define and all conditionals and
  polkit-no-systemd.patch and ConsoleKit BuildRequires, we only
  support systemd now.
- Drop upstream fixed polkit-itstools.patch.
- Rebase pkexec.patch with quilt.
- Add gcc-c++ and pkgconfig(mozjs-52) BuildRequires: New
  dependencies.
- Drop conditional pkgconfig(mozjs-17.0) and pkgconfig(mozjs185):
  no longer supported.
- Drop autoconf and automake BuildRequires: They are implicit via
  libtool BuildRequires.
- Replace glib2-devel and gobject-introspection-devel with their
  pkgconfig counterparts: pkgconfig(gio-unix-2.0),
  pkgconfig(gmodule-2.0) and pkgconfig(gobject-introspection-1.0).
- Add polkit-jsauthority-pass-format-string.patch: jsauthority:
  pass "%%s" format string to remaining report function, patch from
  upstream git, adding missed commit (bgo#105865).
- Drop polkit-revert-session-magic.patch: Upstream systemd bug is
  since a long time fixed (gh#systemd#58) (boo#954139).
* Thu Mar  1 2018 schwab@suse.de
- pkexec.patch: pkexec: allow --version and --help even if not setuid
* Wed Feb 28 2018 dimstar@opensuse.org
- Modernize spec-file by calling spec-cleaner
* Tue Aug 15 2017 dimstar@opensuse.org
- Add polkit-itstools.patch: Add gettext support for .policy files.
* Tue Jun 13 2017 lnussel@suse.de
- Use gettext as fallback to get potential distro translations for
  polkit actions. Similar mechnism as used for desktop file
  translations. That way it's possible to use weblate to add
  additional translations that are not provided by upstream
  (polkit-gettext.patch).
* Wed Jun  8 2016 fbui@suse.com
- Use pkgconfig() instead of requiring systemd package names directly.
* Tue Jun  7 2016 fbui@suse.com
- systemd.pc is shipped by systemd main package (bsc#983167)
  Strangely polkit wants systemd.pc to detect that the target system
  is running systemd even if its configured to build systemd support...
* Thu Nov 26 2015 meissner@suse.com
- polkit-revert-session-magic.patch: revert a session detection change
  that could lead to sessions not being detected as active due to
  a systemd bug. bsc#954139
* Thu Aug  6 2015 antoine.belvire@laposte.net
- Update to 0.113:
  * Fix CVE-2015-4625
  * Fix CVE-2015-3256
  * Fix CVE-2015-3255
  * Fix CVE-2015-3218
  * On systemd-213 and later, the “active” state is shared across
    all sessions of an user, instead of being tracked separately
  * pkexec: when not given a program to execute, runs the users’
    shell by default
- Remove polkit-no-kded-leak.patch (upstreamed)
* Mon Jan 12 2015 tchvatal@suse.com
- Try to fix kded leaking due to powerdevil exposing this issue in
  polkit: (bsc#912889)
  * polkit-no-kded-leak.patch
* Tue Dec  9 2014 meissner@suse.com
- Added gpg signature and keyring with David Zeuthen and Miloslav Trmac
  ids.
* Fri Sep 27 2013 toms@opensuse.org
- Fixed URL
* Thu Sep 19 2013 hrvoje.senjan@gmail.com
- Update to 0.112
  + polkitunixprocess: Deprecate racy APIs
  + pkcheck: Support --process=pid,start-time,uid syntax too
    (CVE-2013-4288)
  + Use GOnce for interface type registration
  + Add czech translation po file to distribution
  + Update the czech once more with newest pot file
* Fri Jul  5 2013 dimstar@opensuse.org
- On openSUSE 13.1+, switch from mozjs185 to mozjs-17.0 by:
  + Conditionally BuildRequire pkgconfig(mozjs-17.0).
- Drop libmozjs185-1_0 Recommends: the library is actually required
  and auto-detected as such by rpm (from 0.111 changes: "The
  JavaScript interpreter is now mandatory").
* Fri Jun 14 2013 hrvoje.senjan@gmail.com
- Update to 0.111
  + Both js185 and mozjs17 versions of SpiderMonkey are supported
  + The JavaScript interpreter is now mandatory
  + Fixed various memory leaks
  + Respect SUID_CFLAGS and SUID_LDFLAGS
  + Set process environment from pam_getenvlist()
  + Fix the build with automake 1.13
- Drop polkit-suid_flags.patch and automake-113.patch, those
  patches are included in this release
* Thu Apr 11 2013 hrvoje.senjan@gmail.com
- Add automake-113.patch, fixes build with automake-1.13
* Mon Feb 18 2013 gber@opensuse.org
- Recommend libmozjs185-1_0 which is dlopen'ed and required for JS
  rules
* Mon Jan 14 2013 hrvoje.senjan@gmail.com
- Update to 0.110
  + Set XAUTHORITY environment variable if is unset
  + Use mutex and condition variables properly
  + Build fixes.
- Changes from version 0.109:
  + Include gmodule-2.0 to avoid linker errors
  + Don't require libmozjs185 devel packages for polkit rules
    to work
- Drop polkit-link-gmodule.patch and polkit-libmozjs.patch, those
  are merged upstream
* Wed Jan  9 2013 saschpe@suse.de
- Only mark the following files as %%config, not %%config(noreplace):
  + %%{_sysconfdir}/dbus-1/system.d/org.freedesktop.PolicyKit1.conf
  + %%{_sysconfdir}/pam.d/polkit-1
  + %%{_sysconfdir}/polkit-1/rules.d/50-default.rules
  PolicyKit's own config files should only be changed for good reason
  and we want to prefer openSUSE's defaults (you still get an .rpmsafe
  file)
* Mon Dec 10 2012 dimstar@opensuse.org
- Add polkit-libmozjs.patch: dlopen libmozjs185.so.1.0 instead of
  libmozjs185.so, which is packaged in the -devel package
  (bnc#793562)
* Thu Nov 15 2012 dimstar@opensuse.org
- Update to version 0.108:
  + PolkitAgent: Avoid crashing if initializing the server object
    fails
  + Fall back to authenticating as uid 0 if the list of admin
    identities is empty
  + Dynamically load libmozjs185.so and cope with it not being
    available
  + docs: mention the audience for authorization rules
  + build: Fix .gir generation for parallel make
- Only conditionally Require ConsoleKit when with_systemd is 0:
  systemd support obsoletes ConsoleKit.
- Add polkit-link-gmodule.patch: Link against gmodule-2.0.
- Change libpolkit0 to require polkit >= %%version instead of the
  exact version. This will ease upgrade problems should there ever
  be a soname bump of libpolkit0.
* Wed Nov 14 2012 dimstar@opensuse.org
- Enable systemd inetegration (change with_systemd to 1): As an
  agreed target for 12.3, systemd integration will be enabled.
* Thu Nov  8 2012 aj@suse.de
- Add pwdutils to prereq for groupadd and useradd.
* Thu Sep 27 2012 vuntz@opensuse.org
- Add polkit-no-systemd.patch: this patch, only applied when not
  building systemd support, removes the systemd service reference
  from the dbus .service file. This is needed as the systemd
  .service file does not get installed in that case and dbus gets
  confused because it expects it.
- Make %%{_datadir}/polkit-1/rules.d and
  %%{_sysconfdir}/polkit-1/rules.d owned by user polkitd, as those
  directories have 0700 as permissions.
- Those two changes should fix polkit so it can start.
  Fix bnc#782395.
* Tue Sep 25 2012 vuntz@opensuse.org
- Use %%{_localstatedir}/lib/polkit for $HOME of polkit user,
  instead of %%{_libexecdir}/polkit-1. The directory is manually
  created in %%install.
* Fri Sep 14 2012 vuntz@opensuse.org
- Update to version 0.107:
  + Try harder to look up the right localization
  + Introduce a polkit.Result enumeration for authorization rules
  + pkexec: add support for argv1 annotation and mention
    shebang-wrappers
  + doc: update guidance on situations where there is no polkit
    authority
- Changes from version 0.106:
  + Major change: switch from .pkla files (keyfile-format) to
    .rules files (JavaScript)
  + Nuke polkitbackend library, localauthority backend and
    extension system
  + Run polkitd as an unprivileged user
  + Add a systemd .service file
  + Several other code changes.
  + Updated documentation.
- Changes from version 0.105:
  + Add pkttyagent(1) helper
  + Make it possible to influence agent registration with an a{sv}
    parameter
  + Several other code changes.
- Add pkgconfig(mozjs185) BuildRequires: new dependency for the
  authority backend.
- Rebase polkit-no-wheel-group.patch: the admin configuration is
  now in a .rules file.
- Rebase polkit-suid_flags.patch.
- Explicitly pass --enable-libsystemd-login or
  - -disable-libsystemd-login, depending on whether we build systemd
  support.
- Add a %%pre script to create the polkitd group and user, as
  polkitd now run as an unprivileged user.
* Wed Aug 22 2012 meissner@suse.com
- also use -z now for binary hardening
* Wed Jun 13 2012 vuntz@opensuse.org
- Package /etc/polkit-1/localauthority and its subdirectories. They
  were forgotten because they were empty, but people might need
  them to put .pkla files.
* Fri Feb 24 2012 vuntz@opensuse.org
- Change the way we pass -fpie/-pie:
  + Drop polkit-pie.patch: this was not upstreamable.
  + Add polkit-suid_flags.patch: respect SUID_CFLAGS/SUID_LDFLAGS
    when building the suid binaries (pkexec and
    polkit-agent-helper-1).
  + Add autoconf, automake and libtool BuildRequires, and call
    autoreconf, for the new patch.
  + Set SUID_CFLAGS to -fPIE and SUID_LDFLAGS to -pie in %%build.
  + Pass --with-pic to configure instead of changing CFLAGS to
    contain -fPIC.
* Tue Feb  7 2012 dlovasko@suse.com
- fixed bnc#743145 - added -fpie/-pie flags to compilation and linking of polkit-agent-helper and pkexec
* Mon Jan  9 2012 vuntz@opensuse.org
- Split typelib file into typelib-1_0-Polkit-1_0 subpackage.
- Add typelib-1_0-Polkit-1_0 Requires to devel subpackage.
- Add explicit libpolkit0 Requires to devel subpackage: it was
  missing before.
- Remove explicit glib2-devel Requires from devel subpackage: it
  will automatically be added the pkgconfig() way.
- Improve summary of libpolkit0 subpackage.
* Wed Jan  4 2012 crrodriguez@opensuse.org
- A quick test reveals that the systemd backend does not
  integrate very well with packages yet, revert.
* Wed Jan  4 2012 crrodriguez@opensuse.org
- Previous update missed systemd-devel in buildrequires
  without it no systemd support is built
* Wed Jan  4 2012 vuntz@opensuse.org
- Update to version 0.104:
  + Add optional systemd support
  + Add netgroup support (fdo#43610)
  + Add unit tests (fdo#43608)
- Changes from version 0.103:
  + Mistype in DBus object: PoliycKit1 -> PolicyKit1
  + Add support for the org.freedesktop.policykit.imply annotation
  + Add --no-debug option and use this for D-Bus activation
  + Add org.freedesktop.policykit.owner annotation (fdo#41025)
  + Default to AdminIdentities=unix-group:wheel for local authority
- Drop patches that were taken from upstream:
  + 0001-Add-support-for-the-org.freedesktop.policykit.imply-a.diff
  + 0002-Add-no-debug-option-and-use-this-for-D-Bus-activation.diff
  + 0003-Bug-41025-Add-org.freedesktop.policykit.owner-annotat.diff
- Add polkit-no-wheel-group.patch: do not allow the wheel group as
  admin identity, and revert to only accept the root user for this.
* Wed Nov  2 2011 lnussel@suse.de
- pick some patches from git to add support for
  org.freedesktop.policykit.imply, disable debug spam and allow
  unprivileged users to query authorizations (bnc#698250)
* Fri Sep  2 2011 vuntz@opensuse.org
- Update to version 0.102:
  + pkexec:
  - fdo#38769: Support running X11 apps
  - Avoid time-of-check-to-time-of-use problems with parent
    process
  + Fix backend crash if a .policy file does not specify <message>
  + Fix multi-line pam prompt handling
  + Don't show diagnostic messages intended for the administrator
    to the end user
  + PolkitUnixProcess:
  - Clarify that the real uid is returned, not the effective one
  - Record the uid of the process
  + Backend: Use polkit_unix_process_get_uid() to get the owner of
    a process
  + Introspection fixes:
  - Add --c-include to the gir files
  - Specify exported pkg-config files in GIRs
  + Build fix.
- Drop polkit-CVE-2011-1485-1.patch, polkit-CVE-2011-1485-2.patch,
  polkit-CVE-2011-1485-3.patch, polkit-CVE-2011-1485-4.patch: fixed
  upstream.
- Remove service usage, following the new consensus on Factory
  packaging.
* Wed Aug 10 2011 dimstar@opensuse.org
- BuildIgnore ruby, which is being dragged in via indirect
  dependencies by gtk-doc for one of the helpers, which we do not
  need during the build of polkit. Not dragging ruby in resolves a
  build-cycle.
* Thu May  5 2011 vuntz@opensuse.org
- Use %%set_permissions instead of deprecated %%run_permissions in
  %%post.
- Add permissions PreReq, which was missing before.
* Tue Apr 26 2011 kay.sievers@novell.com
- use LGPLv2.1+ in spec file
* Tue Apr 26 2011 kay.sievers@novell.com
- stat race condition (CVE-2011-1485) (bnc#688788)
* Wed Apr  6 2011 fcrozat@novell.com
- Remove PolkitAgent-1.0.typelib from main package, it is in
  library package.
* Wed Mar  9 2011 coolo@novell.com
- update to 0.101:
  * tons of bug fixes, see NEWS
* Wed Nov 10 2010 coolo@novell.com
- fix file list
* Thu Sep 16 2010 vuntz@opensuse.org
- Update to version 0.99:
  + Remove duplicate definitions of enumeration types
  + Fix (correct) GCC warning about possibly-uninitialized variable
  + Fix another GCC uninitialized variable warning
  + fdo#29816: Install polkitagentenumtypes.h
- Drop polkit-install-missing-header.patch: fixed upstream.
* Thu Aug 26 2010 vuntz@opensuse.org
- Update to version 0.98:
  + Fix scanning of unix-process subjects
  + Add textual authentication agent and use it in pkexec(1)
  + Fix ConsoleKit interaction bug
  + pkexec: add --disable-internal-agent option
  + pkcheck: add --enable-internal-agent option
  + Fix wording in pkexec(1) man page
  + Various doc cleanups
- Changes from version 0.97:
  + Port to GDBus
  + Add shadow authentication support
  + Remove Lock Down functionality
  + fdo#26982: pkexec information disclosure vulnerability
  + Make polkitd accept --replace and gracefully handle SIGINT
  + Implement polkit_temporary_authorization_new_for_gvariant()
  + Make NameOwnerChanged a private impl detail of the interactive
    authority
  + Add a GPermission implementation
  + PolkitAuthority: Implement failable initialization
  + PolkitAuthority: Add g_return_if_fail() checks
  + Add g_return_if_fail() to all public API entry points
  + Use polkit_authority_get_sync() instead of deprecated
    polkit_authority_get
  + PolkitBackend: Don't export unneeded convenience API
  + Update GI annotations
  + Don't dist org.freedesktop.ConsoleKit.xml.
  + Properly reference headers
  + fdo#29051: Configuration reload on every query
- Drop pkexec-information-disclosure.patch: fixed upstream.
- Add polkit-install-missing-header.patch to install a header that
  should get installed.
- Remove eggdbus-devel BuildRequires.
- Build with introspection support: add gobject-introspection
  BuildRequires and pass --enable-introspection to configure.
- Fix groups of all packages to be valid groups.
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Fri Apr  9 2010 kay.sievers@novell.com
- fix pkexec information disclosure
  (fdo#26982, CVE-2010-0750, bnc#593959)
* Mon Jan 18 2010 dmueller@suse.de
- add baselibs.conf
* Mon Jan 18 2010 kay.sievers@novell.com
- new upstream release 0.96
  - Bug 25367 — Also read local authority configuration data from /etc
  - Run the open_session part of the PAM stack in pkexec(1)
  - Bug 25594 – System logging
  - Properly handle return value from getpwnam_r()
  - Fix error message when no authentication agent is available
  - Make pkexec(1) validate environment variables
  - Make pkexec(1) use the syslogging facilities
  - Save original cwd in pkexec(1) since it will change during the life-time
  - Complain on stderr, not stdout
  - Don't log authorization checks
* Wed Jan  6 2010 dmueller@suse.de
- update to 0.95:
  The major change this release is that the lockdown feature has
  been cleaned up in a way so it isn't specific to the local
  authority. See the NEWS files for more details.
* Wed Dec 16 2009 jengelh@medozas.de
- Package documentation as noarch
* Wed Aug 19 2009 vuntz@novell.com
- Add Requires on polkit to libpolkit0: all applications using
  libpolkit0 will really need polkit to be installed to work
  properly.
* Thu Aug 13 2009 kay.sievers@novell.com
- new upstream release 0.94
  - Allow unprivileged callers to check authorizations
  - Don't spawn man(1) from a setuid program
  - Add polkit.retains_authorization_after_challenge to authz result
  - Ensure all fds except stdin/stdout/stderr are closed after exec(2)
  - Be more careful when determining process start time
  - Remove temporary authorization when the subject it applies to vanishes
  - Generate GI gir and typelibs for libpolkit-gobject-1
- drop patches which are in the release now
- disable introspection
* Tue Aug 11 2009 kay.sievers@novell.com
- add upstream patches:
  polkit-close-stdfds.patch
  polkit-no-man-spawn.patch
  polkit-proc-stat-parse-fix.patch
- drop rpmlint patch
* Thu Aug  6 2009 meissner@suse.de
- check for the right binary in verify_permisisons
* Thu Jul 30 2009 coolo@novell.com
- disable suid bit for now to get software build on top
- split out libraries to follow shared library policy
* Tue Jul 21 2009 kay.sievers@novell.com
- update to version 0.93
* Sun Jul 19 2009 kay.sievers@novell.com
- initial import of polkit 0.92
