#
# spec file for package systemd-presets-branding-SLE
#
# Copyright (c) 2017 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%define generic_name systemd-presets-branding

Name:           %{generic_name}-SLE
Version:        15.1
Release:        150600.35.3.1
Summary:        Systemd default presets for SUSE Linux Enterprise
License:        ISC
Group:          System/Base
Source1:        default-SLE.preset
BuildRequires:  systemd
#!BuildIgnore:  systemd-presets-branding
# FIXME: use proper Requires(pre/post/preun/...)
# For the stuff that the systemd_preset_pre macro does.
BuildRequires:  systemd-presets-common-SUSE
Requires(pre):  systemd-presets-common-SUSE
PreReq:         coreutils
Provides:       %{generic_name} = %{version}
Supplements:    packageand(systemd:branding-SLE)
Conflicts:      otherproviders(%{generic_name})
BuildArch:      noarch

Requires(post): bash
Requires(pre):  bash

%description
Default presets for systemd on openSUSE distribution.

%prep
%setup -q -T -c

%build

%install
mkdir -p %{buildroot}%{_prefix}/lib/%{generic_name}
mkdir -p %{buildroot}%{_prefix}/lib/systemd/system-preset
# everything that must be enabled only in SLE
install -m644 %{SOURCE1}  %{buildroot}%{_prefix}/lib/systemd/system-preset/90-default-SLE.preset


%pre
# On initial installation, branding-preset-states does not yet exist,
# which is why we also check for the file to be present/executable
if [ $1 -gt 1 -a -x %{_prefix}/lib/%{generic_name}/branding-preset-states ] ; then
        #
        # Save the old state so we can detect which package have its
        # default changed later.
        #
        # Note: the old version of the script is used here.
        #
        %{_prefix}/lib/%{generic_name}/branding-preset-states save
elif [ $1 -eq 1 ]; then
  touch /run/rpm-%{name}-preset-all
fi

%post
if [ $1 -gt 1 -a -x %{_prefix}/lib/%{generic_name}/branding-preset-states ] ; then
        #
        # Now that the updated presets are installed, find the ones
        # that have been changed and apply "systemct preset" on them.
        #
        %{_prefix}/lib/%{generic_name}/branding-preset-states apply-changes
fi

%posttrans
if [ -f /run/rpm-%{name}-preset-all ]; then
  # Enable all services, which were installed before systemd
  # Don't disable services, since this would disable the
  # complete network stack.
  systemctl preset-all --preset-mode=enable-only
fi
rm -f /run/rpm-%{name}-preset-all

%files
%dir %{_prefix}/lib/systemd
%dir %{_prefix}/lib/systemd/system-preset/
%{_prefix}/lib/systemd/system-preset/90-default-SLE.preset

%changelog
* Wed Jul 30 2025 pgajdos@suse.com
- enable sysstat_collect.timer and sysstat_summary.timer [bsc#1244553]
  and [bsc#1246835]
- modified sources
  %% default-SLE.preset
* Mon May  6 2024 wolfgang.frisch@suse.com
- Enable sysctl-logger (jsc#PED-5024)
* Wed Sep 13 2023 jfehlig@suse.com
- Enable the various libvirt modular daemons (jsc#PED-6303)
* Thu May  5 2022 fschnizlein@suse.com
- Enable suseconnect-keepalive.timer for SUSEConnect (jsc#SLE-23312)
* Fri Apr 16 2021 fvogt@suse.com
- Don't enable btrfsmaintenance-refresh.service, btrfsmaintenance is
  managed by systemd-presets-common-SUSE instead (boo#1165780)
* Fri May  8 2020 matthias.gerstner@suse.com
  Cleanup of outdated autostart services (bsc#1171656):
- Remove acpid.service. acpid is only available on SLE via openSUSE
  backports.  In openSUSE acpid.service is *not* autostarted. I see no
  reason why it should be on SLE.
- Remove spamassassin.timer. This timer never seems to have existed.
  Instead spamassassin ships a "sa-update.timer". But it is not
  default-enabled and nobody ever complained about this.
- Remove snapd.apparmor.service: This service was proactively added a year
  ago, but snapd didn't even make it into openSUSE yet. There's no reason
  to keep this entry unless snapd actually enters SLE which is not
  foreseeable.
* Thu Mar 14 2019 jsegitz@suse.com
- Removed ixpdimm-monitor.service and readonly-root.service
  (bsc#1129270)
- Added snapd.apparmor.service (bsc#1129435)
* Fri Feb 15 2019 varkoly@suse.com
- spamassassin: migrate from cron to systemd timers (bsc#1115411)
  enable spamassassin.timer by default
* Mon Dec 10 2018 rtorreromarijnissen@suse.com
- enable unbound-anchor.timer to replace old cronjob (bsc#1115417)
* Fri Sep 14 2018 meissner@suse.com
- enable cpi.service for s390x (bsc#1106365)
* Wed Aug 29 2018 meissner@suse.com
- split out the common parts to systemd-presets-common-SUSE.
  (FATE#326424)
* Mon Feb  5 2018 kukuk@suse.de
- Enable backup-rpmdb.timer, backup-sysconfig.timer and
  check-battery.timer, previously cron.daily jobs.
* Mon Jan 29 2018 zren@suse.com
- Enable lvm2-monitor.service by default (bsc#1072492)
- Enable lvm2-lvmpolld.socket by default (bsc#1074211)
* Tue Jan  2 2018 sbrabec@suse.com
- Enable new kbdsettings.service (boo#1010880).
* Mon Jan  1 2018 wr@rosenauer.org
- enable pcscd socket activation by default to support smartcards
  out of the box (boo#1063983)
* Tue Dec 12 2017 kukuk@suse.de
- Don't disable services with preset-all in %%posttrans, the network
  is special and would be disabled.
* Mon Dec 11 2017 kukuk@suse.de
- If we do a fresh installation, call systemctl preset-all in the
  %%posttrans section. Some services need to be installed before
  systemd or do not strictly require systemd, so systemd would only
  be installed after them and the systemd units of this package
  never enabled.
- Enable klog.service and rsyslog.service by default, currently
  they enable themself always in post install section.
- Sync default-SUSE.preset with systemd-presets-branding-openSUSE
* Mon Dec 11 2017 kukuk@suse.de
- Add branding-preset-states script
* Fri Nov  3 2017 olaf@aepfle.de
- Remove SLE12 specific uuidd handling in %%pre section
* Fri Nov  3 2017 olaf@aepfle.de
- Move common entries into default-SUSE.preset (bsc#1060676)
* Tue Oct 17 2017 olaf@aepfle.de
- Sort entries with :'<,'>!sort -t ' ' -k 2 (bsc#1060676)
* Thu Aug 24 2017 meissner@suse.com
- enable oracle.service. orarun would do it anywhere in their
  package. (bsc#1052634)
* Tue Jun 20 2017 kukuk@suse.de
- Enable ca-certificates to run on boot and on demand to create
  database in /var/lib/ca-certificates
* Tue Apr 11 2017 behlert@suse.de
- replace systemd macros with new scripts
* Fri Mar 17 2017 sbrabec@suse.com
- Remove superfluous uuidd.service. uuidd.socket is sufficient
  (bsc#1012850#c8).
* Tue Feb 21 2017 zren@suse.com
- Enable socket/service(s) for lvm2 (bsc#1011053)
* Fri Feb 10 2017 fbui@suse.com
- Enable by default uuidd shipped by util-linux (bsc#1012850)
  util-linux was previously shipping a preset file enabling uuidd by
  default. This is now done here as other packages are not supposed to
  ship their own preset rules.
  Also increase the package version so util-linux can conflict with
  the previous versions and hence will be updated *after* the new
  version of the presets package is. This is important otherwise if
  util-linux removed its preset file first, then the presets package
  would believe a new change in the presets and you enable again
  uuidd.
* Tue Jan 24 2017 dimstar@opensuse.org
- Enable the issue-generator.service by default: /etc/issue is in
  progress of no longer being a static file, but being generated by
  a service, which allows for much more flexible content (think
  ssh key fingerprint or similar).
* Tue Nov 29 2016 meissner@suse.com
- added snapper-cleanup.timer and snapper-timeline.timer (bsc#1011891)
* Tue Jun 14 2016 ken@suse.com
- enable vmblock-fuse service for VMWare by default (bsc#986277)
* Tue May 31 2016 meissner@suse.com
- prerequire coreutils for mkdir and touch to be present (bsc#982337)
* Mon May  9 2016 trenn@suse.de
- Do not start mcelog service based on an udev (/dev/mcelog) rule
  (bsc#976781), but enable it automatically at install time.
* Fri May  6 2016 meissner@suse.com
- enable ixpdimm-monitor.service (bsc#978270)
* Thu Mar 31 2016 fbui@suse.com
- Previous commit forgot to remove %%systemd_requires
* Thu Mar 31 2016 fbui@suse.com
- Do not explicitly require systemd package. This package is already
  required by systemd and must be installed before it.
  systemctl is only needed in %%posttrans which should be available at
  this step.
  However the whole preset rpm macro thing looks really strange and
  quite ugly. This should be revisited.
* Thu Mar 31 2016 fbui@suse.com
- Don't reload daemon in %%post and %%postun: there's no point.
  - on package installation or upgrade, no services can be enabled or
    disabled at the %%post stage since it can happen only in
    %%posttrans.
  - on package removal (not upgrade) which can't realistically happen,
    systemd should not be present anymore.
* Thu Mar 24 2016 meissner@suse.com
- enable getty@.service multiplexer and remote-fs.service (bsc#972489)
* Mon Mar 14 2016 jfehlig@suse.com
- Add virtlogd.socket to default presets (bsc#971054)
* Wed Dec 16 2015 eich@suse.com
- Add display-manager.service to defaults presets (boo#958880).
* Mon Oct  5 2015 meissner@suse.com
- enable rollback.service, FATE#319118 / bsc#948824
* Fri Sep 18 2015 sbrabec@suse.com
- Change uuidd activation hack to reflect systemd-rpm-macros change
  (boo#946216#c6).
* Wed Sep 16 2015 meissner@suse.com
- enable opal_errd.service (ppc64 specific) (bsc#945390)
* Fri Sep 11 2015 meissner@suse.com
- enable the sapconf.service (one shot) (bsc#944761)
* Thu Aug 27 2015 sbrabec@suse.com
- Add %%systemd_preset_pre and %%systemd_preset_posttrans (one shot
  preset makes possible to fix boo#921075, FATE#318949 and
  FATE#317727 and all future requests to change service default).
- Enable fstrim.timer and disable fstrim.service. TRIM should be
  performed once a week and not on every boot (FATE#317727).
- Enable smartd by default (bnc#921075).
- Add hack to perform one shot preset on SLE12 Update -> SLE12 SP1
  migration (bnc#900935#c46, FATE#318949).
- Bump version to 12.1.
* Wed Jul 15 2015 jkeil@suse.de
- Enable updatedb timer for mlocate package
  * Replaces cron.daily script
* Wed Jul 15 2015 jkeil@suse.de
- Enable timer for periodic password & group file integrity verification
* Wed Jul 15 2015 olaf@aepfle.de
- Remove xendomains.service from systemd preset file because it
  conflicts with libvirt-guests.service (bnc#937371)
  Its up to the admin to run systemctl enable xendomains.service
* Wed Apr  1 2015 crrodriguez@opensuse.org
- Native systemd unit apparmor.service need to be enabled
  by default.
* Tue Jan 13 2015 olaf@aepfle.de
- enable xencommons and xendomains (bnc#897352)
* Thu Nov 20 2014 gber@opensuse.org
- enable storage-fixup.service by default due to conversion
* Tue Sep 23 2014 meissner@suse.com
- enable the btrfsmaintenance-refresh.service that generates
  cron snippets from /etc/sysconfig/btrfsmaintenance that
  do auto-balancing etc. bnc#897948
* Tue Jul  1 2014 meissner@suse.com
- enable the cio_ignore.server for s390x (bnc#885245)
* Thu Jun 26 2014 glin@suse.com
- enable wpa_supplicant.service (bnc#860885 comment#20)
* Fri Jun 13 2014 meissner@suse.com
- enable rtas_errd.service by default (bnc#882450)
* Thu May 29 2014 lwang@suse.com
- enable lvm2-lvmetad.socket (bnc#878473)
* Wed May 14 2014 meissner@suse.com
- enable 3 IPR device / Power specific tools (bnc#877576)
* Wed Apr 16 2014 meissner@suse.com
- enable vmtoolsd service for VMWare by default (bnc#873935 bnc#870737)
* Fri Apr 11 2014 meissner@suse.com
- enabled irqbalance service by default bnc#870619
* Fri Apr 11 2014 meissner@suse.com
- enable auditd by default. bnc#872066
* Wed Apr  2 2014 crrodriguez@opensuse.org
- Enable the logrotate.timer that replaces the cron-based
  activation by default.
* Mon Mar 31 2014 meissner@suse.com
- remove cups.service autostart bnc#870425
* Thu Mar 27 2014 meissner@suse.com
- enable haveged by default (as previously in SLE11) bnc#870385 /
  FATE#312210
* Tue Mar 18 2014 tbehrens@suse.com
- enable readonly-root.service (as previously also enabled in SLE11)
  bnc#868998
* Fri Feb 21 2014 meissner@suse.com
- enable libvirtd.service (as previously also enabled in SLE11)
  bnc#863552
* Wed Feb 12 2014 meissner@suse.com
- bump version to match product
- use ISC license as suggested.
* Wed Feb 12 2014 meissner@suse.com
- do not own entire /usr/lib/systemd, this is wrong.
- list systemd directories as %%dir
* Sun Feb  2 2014 ohering@suse.de
- Own entire /usr/lib/systemd
* Sat Feb  1 2014 ohering@suse.de
- Revert last change for hyper-v.rpm
  Both daemons are started on demand via udev rules.
* Wed Dec 18 2013 ohering@suse.de
- Enable hv_kvp_daemon and hv_vss_daemon from hyper-v pkg
* Thu Oct 17 2013 lduncan@suse.com
- Enable iscsid socket and iscsi service by default when
  installed (bnc#827654).
* Wed Jul 31 2013 fcrozat@suse.com
- Enable ModemManager.service is enabled when installed (it will be
  dbus-activated by NM).
* Thu Jul 25 2013 fcrozat@suse.com
- Rename main default file to 90-default-openSUSE.preset and move
  the "disable everything" part to a separate file
  "99-default-disable.preset". This allows fine tuning with
  additional files, if needed (same as Fedora).
* Fri May  3 2013 meissner@suse.com
- as we have multiversion kernels enabled by default, we also
  need to enable purge-kernels by default (bnc#818317).
* Fri Feb 22 2013 mt@suse.com
- Do not unconditionally enable NetworkManager service as this
  breaks running /etc/init.d/network on update (bnc#803058).
* Wed Oct 17 2012 fcrozat@suse.com
- Change location of presets with latest systemd.
* Tue Sep 11 2012 aj@suse.de
- Add nscd service (bnc#778981).
* Wed Jul  4 2012 fcrozat@suse.com
- Add cups units (service, path and socket) (bnc#769346).
* Mon Dec 12 2011 fcrozat@suse.com
- Add postfix (bnc#727403).
* Wed Oct 26 2011 lnussel@suse.de
- don't enable sysstat by default (bnc#725791)
* Mon Oct 17 2011 fcrozat@suse.com
- Add sysstat.service (bnc#723858).
* Sun Oct 16 2011 coolo@suse.com
- buildignore branding for systemd to avoid bootstrap cycle
* Fri Oct  7 2011 fcrozat@suse.com
- Add Yast2 FirstBoot and Second Stage.
* Thu Sep 29 2011 fcrozat@suse.com
- Don't enable avahi-dnsconfd.service after all.
* Thu Sep 29 2011 fcrozat@suse.com
- Enable avahi-daemon.service and avahi-dnsconfd.service
* Thu Sep 29 2011 fcrozat@suse.com
- Enable cron.service
* Mon Sep 26 2011 fcrozat@suse.com
- Initial package
