#
# spec file for package boost
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%define ver 1.66.0
%define file_version 1_66_0
%define docs_version 1.56.0
%define short_version 1_56
%define lib_appendix 1_66_0
%bcond_with    build_docs
%bcond_without package_pdf
%bcond_without build_quickbook
%bcond_with    boost_devel
%define my_docdir %{_docdir}/boost-%{version}

%if "base" == "base"
%define build_base 1
%define name_suffix -base
%else
%define build_base 0
%define name_suffix %nil
%endif

# Build with OpenMPI
%if 0%{?suse_version} >= 1330
  # OpenMPI >= 2 is not available on ppc64be
  %ifarch ppc64
    %define mpi_implem openmpi
  %else
    %define mpi_implem openmpi2
  %endif
%else
  # Keep OpenMPI1 for older releases where OpenMPI2 is not available
  %define mpi_implem openmpi
%endif

%ifarch ia64 hppa
%bcond_with  build_mpi
%else
%bcond_without build_mpi
%endif

%bcond_without python3
%bcond_without python2

# Python NumPy library is only available on Leap 42.1 OpenSUSE onward
# and is not availble in SLE
%if 0%{?suse_version} >= 1330 || 0%{?is_opensuse}
%bcond_without python_numpy
%else
%bcond_with python_numpy
%endif

# context hasn't been ported to most architectures yet
%ifarch %ix86 x86_64 %arm aarch64 mips ppc ppc64 ppc64le
%bcond_without build_context
%else
%bcond_with build_context
%endif

# needs newer *default* GCC to compile runtime
%if %{with build_context} && 0%{?suse_version} > 1320
%bcond_without boost_fiber
%else
%bcond_with boost_fiber
%endif

Name:           boost%name_suffix
%define package_name boost_1_66
Version:        1.66.0
Release:        150200.12.7.1
Summary:        Boost C++ Libraries
License:        BSL-1.0
Group:          Development/Libraries/C and C++
Url:            http://www.boost.org
Source0:        http://downloads.sourceforge.net/project/boost/boost/%{version}/boost_%{file_version}.tar.bz2
Source1:        boost-rpmlintrc
Source3:        http://downloads.sourceforge.net/project/boost/boost-docs/%{docs_version}/boost_%{short_version}_pdf.tar.bz2
Source4:        existing_extra_docs
#Source5:        NEWS
Source10:       exception.objdump
Source11:       __init__.py
Source100:      baselibs.conf
Source101:      symbol_diff.sh
Source102:      README.boost-devel
Patch1:         boost-thread.patch
Patch2:         boost-no_type_punning.patch
Patch3:         boost-no_segfault_in_Regex_filter.patch
Patch4:         boost-pool_check_overflow.patch
Patch5:         boost-strict_aliasing.patch
Patch6:         boost-use_std_xml_catalog.patch
Patch7:         boost-rpmoptflags-only.patch
Patch9:         boost-aarch64-flags.patch
Patch10:        boost-disable-pch-on-aarch64.patch
Patch13:        boost-visibility.patch
Patch14:        boost-1.57.0-python-libpython_dep.patch
Patch15:        boost-1.57.0-python-abi_letters.patch
Patch16:        boost-1.55.0-python-test-PyImport_AppendInittab.patch
Patch17:        python_mpi.patch
Patch18:        dynamic_linking.patch
Patch20:        python_library_name.patch
Patch21:        python_numpy_retfunc.patch
Patch22:        libreoffice_compat_backports.patch
Patch23:        variant.patch
Patch24:        boost-zlib.patch
BuildRequires:  fdupes
BuildRequires:  libbz2-devel
BuildRequires:  libexpat-devel
BuildRequires:  libicu-devel
BuildRequires:  zlib-devel
%if %{with boost_fiber}
BuildRequires:  gcc-c++ > 5
%else
BuildRequires:  gcc-c++
%endif
%if ! %build_base
BuildRequires:  dos2unix
%if %{with python2}
BuildRequires:  python2-devel
%if %{with python_numpy}
BuildRequires:  python2-numpy-devel
%endif # numpy2
%endif # python2
%if %{with python3}
BuildRequires:  python3-devel
%if %{with python_numpy}
BuildRequires:  python3-numpy-devel
%endif # numpy3
%endif # python3
%if %{with build_mpi}
BuildRequires:  %{mpi_implem}-devel
%endif
%if %{with build_docs}
BuildRequires:  docbook
BuildRequires:  docbook-xsl-stylesheets
BuildRequires:  doxygen
BuildRequires:  libxslt-tools
BuildRequires:  texlive-latex
%endif
%endif # ! build_base
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
Boost provides free peer-reviewed portable C++ source libraries. The
emphasis is on libraries that work well with the C++ Standard Library.
One goal is to establish "existing practice" and provide reference
implementations so that the Boost libraries are suitable for eventual
standardization. Some of the libraries have already been proposed for
inclusion in the C++ Standards Committee's upcoming C++ Standard
Library Technical Report.

Although Boost was begun by members of the C++ Standards Committee
Library Working Group, membership has expanded to include nearly two
thousand members of the C++ community at large.

# %%if %%build_base
%package     -n libboost_headers%{lib_appendix}-devel
Summary:        Development headers for Boost
Group:          Development/Libraries/C and C++
Requires:       boost-license%{lib_appendix}
Requires:       libstdc++-devel
Provides:       libboost_headers-devel = %{version}
%if %{without boost_devel}
Provides:       boost-devel = %{version}
%endif
Conflicts:      otherproviders(libboost_headers-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_headers%{lib_appendix}-devel
A collection of header-only libraries for Boost.

%package     -n boost-license%{lib_appendix}
Summary:        Boost License
Group:          Development/Libraries/C and C++
Provides:       boost-license = %{version}-%{release}
%if 0%{?suse_version} >= 1120
BuildArch:      noarch
%endif

%description -n boost-license%{lib_appendix}
This package contains the license boost is provided under.

%if %{with boost_devel}
%package -n     %{package_name}-devel
Summary:        Development package for Boost C++
Group:          Development/Libraries/C and C++
Requires:       libboost_atomic%{lib_appendix}-devel
Requires:       libboost_chrono%{lib_appendix}-devel
Requires:       libboost_container%{lib_appendix}-devel
%if %{with build_context}
Requires:       libboost_context%{lib_appendix}-devel
Requires:       libboost_coroutine%{lib_appendix}-devel
%endif
Requires:       libboost_date_time%{lib_appendix}-devel
%if %{with boost_fiber}
Requires:       libboost_fiber%{lib_appendix}-devel
%endif
Requires:       libboost_filesystem%{lib_appendix}-devel
Requires:       libboost_graph%{lib_appendix}-devel
Requires:       libboost_iostreams%{lib_appendix}-devel
Requires:       libboost_locale%{lib_appendix}-devel
Requires:       libboost_log%{lib_appendix}-devel
Requires:       libboost_math%{lib_appendix}-devel
%if %{with build_mpi}
Requires:       libboost_graph_parallel%{lib_appendix}-devel
Requires:       libboost_mpi%{lib_appendix}-devel
%endif
Requires:       libboost_program_options%{lib_appendix}-devel
%if %{with python2}
Requires:       libboost_python-py2_7-%{lib_appendix}-devel
%endif
%if %{with python3}
Requires:       libboost_python-py3-%{lib_appendix}-devel
%endif
Requires:       libboost_random%{lib_appendix}-devel
Requires:       libboost_regex%{lib_appendix}-devel
Requires:       libboost_serialization%{lib_appendix}-devel
Requires:       libboost_signals%{lib_appendix}-devel
Requires:       libboost_system%{lib_appendix}-devel
Requires:       libboost_test%{lib_appendix}-devel
Requires:       libboost_thread%{lib_appendix}-devel
Requires:       libboost_timer%{lib_appendix}-devel
Requires:       libboost_type_erasure%{lib_appendix}-devel
Requires:       libboost_wave%{lib_appendix}-devel
Requires:       libstdc++-devel
Provides:       boost-devel = %version
Conflicts:      otherproviders(boost-devel)

%description -n %{package_name}-devel
This package contains all that is needed to develop/compile
applications that use the Boost C++ libraries. For documentation see
the documentation packages (html, man or pdf).
%endif # with boost_devel

%package     -n %{package_name}-jam
Summary:        A Boost Make Replacement
Group:          Development/Tools/Building
Provides:       boost-jam
Conflicts:      otherproviders(boost-jam)

%description -n %{package_name}-jam
Boost Jam is a build tool based on FTJam, which in turn is based on
Perforce Jam. It contains significant improvements made to facilitate
its use in the Boost Build System.

%package      -n %{package_name}-doc-html
Summary:        HTML documentation for the Boost C++ Libraries
Group:          Development/Libraries/C and C++
%if 0%{?suse_version} >= 1120
BuildArch:      noarch
%endif

%description  -n %{package_name}-doc-html
This package contains the documentation of the boost dynamic libraries
in HTML format.

%if %{with build_docs}
%package        doc-man
Summary:        Man documentation for the Boost C++ Libraries
Group:          Development/Libraries/C and C++
%if 0%{?suse_version} >= 1120
BuildArch:      noarch
%endif

%description    doc-man
This package contains the documentation of the boost dynamic libraries
as man pages.
%endif

%if %{with package_pdf}
%package      -n %{package_name}-doc-pdf
Summary:        PDF documentation for the Boost C++ Libraries
Group:          Development/Libraries/C and C++
%if 0%{?suse_version} >= 1120
BuildArch:      noarch
%endif

%description  -n %{package_name}-doc-pdf
This package contains the documentation of the boost dynamic libraries
in PDF format.
%endif

%package     -n libboost_atomic%{lib_appendix}
Summary:        Boost.Atomic runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_atomic%{lib_appendix}
Run-Time support for Boost.Atomic, a library that provides atomic data types
and operations on these data types, as well as memory ordering constraints
required for coordinating multiple threads through atomic variables.

%package     -n libboost_atomic%{lib_appendix}-devel
Summary:        Development headers for Boost.Atomic
Group:          Development/Libraries/C and C++
Requires:       libboost_atomic%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libstdc++-devel
Provides:       libboost_atomic-devel = %{version}
Conflicts:      otherproviders(libboost_atomic-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_atomic%{lib_appendix}-devel
Development support for Boost.Atomic, a library that provides atomic
data types and operations on these data types, as well as memory
ordering constraints required for coordinating multiple threads through
atomic variables.

%package     -n libboost_container%{lib_appendix}
Summary:        Boost.Container runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_container%{lib_appendix}
This package contains the Boost.Container runtime library.

%package     -n libboost_container%{lib_appendix}-devel
Summary:        Development headers for Boost.Container
Group:          Development/Libraries/C and C++
Requires:       libboost_container%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libstdc++-devel
Provides:       libboost_container-devel = %{version}
Conflicts:      otherproviders(libboost_container-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_container%{lib_appendix}-devel
Development header files and libraries for Boost.Container.
Boost.Container library implements several well-known containers,
including STL containers. The aim of the library is to offers advanced
features not present in standard containers or to offer the latest
standard draft features for compilers that don't comply with the latest
C++ standard.

%package     -n libboost_context%{lib_appendix}
Summary:        Boost.Context runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_context%{lib_appendix}
Runtime support for Boost.Context, a library that providing cooperative
multitasking support.

%package     -n libboost_context%{lib_appendix}-devel
Summary:        Development headers for Boost.Context
Group:          Development/Libraries/C and C++
Requires:       libboost_context%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libstdc++-devel
Provides:       libboost_context-devel = %{version}
Conflicts:      otherproviders(libboost_context-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_context%{lib_appendix}-devel
Development headers and libraries for Boost.Context, a library that
providing cooperative multitasking support.

%package     -n libboost_coroutine%{lib_appendix}
Summary:        Boost::Coroutine runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_coroutine%{lib_appendix}
This package contains the Boost Coroutine runtime library.

%package     -n libboost_coroutine%{lib_appendix}-devel
Summary:        Development headers for Boost.Coroutine
Group:          Development/Libraries/C and C++
Requires:       libboost_context%{lib_appendix}-devel = %{version}
Requires:       libboost_coroutine%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libstdc++-devel
Provides:       libboost_coroutine-devel = %{version}
Conflicts:      otherproviders(libboost_coroutine-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_coroutine%{lib_appendix}-devel
This package provides headers for Boost.Coroutine libraries.
Boost.Coroutine2 provides templates for generalized subroutines which
allow suspending and resuming execution at certain locations.

%package     -n libboost_date_time%{lib_appendix}
Summary:        Boost.DateTime runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_date_time%{lib_appendix}
This package contains the Boost Date.DateTime runtime libraries.

%package     -n libboost_date_time%{lib_appendix}-devel
Summary:        Development headers for Boost.DateTime library
Group:          Development/Libraries/C and C++
Requires:       libboost_date_time%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Recommends:     libboost_serialization%{lib_appendix}-devel = %{version}
Requires:       libstdc++-devel
Provides:       libboost_date_time-devel = %{version}
Conflicts:      otherproviders(libboost_date_time-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_date_time%{lib_appendix}-devel
This package contains development header files and libraries for
Boost.DateTime library.

%package     -n libboost_fiber%{lib_appendix}
Summary:        Boost.Fiber runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_fiber%{lib_appendix}
This package contains Boost.Fiber runtime library.

%package     -n libboost_fiber%{lib_appendix}-devel
Summary:        Development headers for Boost.Fiber library
Group:          Development/Libraries/C and C++
Requires:       libboost_context%{lib_appendix}-devel = %{version}
Requires:       libboost_fiber%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libstdc++-devel
Provides:       libboost_fiber-devel = %{version}
Conflicts:      otherproviders(libboost_fiber-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_fiber%{lib_appendix}-devel
This package contains development header files and libraries for
Boost.Fiber library. Boost.Fiber is a cooperative multi-tasking
userland threading library.

%package     -n libboost_filesystem%{lib_appendix}
Summary:        Boost.Filesystem Runtime Libraries
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_filesystem%{lib_appendix}
This package contains the Boost.Filesystem library.

%package     -n libboost_filesystem%{lib_appendix}-devel
Summary:        Development headers for Boost.Filesystem library
Group:          Development/Libraries/C and C++
Requires:       libboost_filesystem%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_system%{lib_appendix}-devel = %{version}
Requires:       libstdc++-devel
Provides:       libboost_filesystem-devel = %{version}
Conflicts:      otherproviders(libboost_filesystem-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_filesystem%{lib_appendix}-devel
Development headers for Boost.Filesystem library, a library providing
facilities to manipulate files and directories, and the paths that
identify them.

%package     -n libboost_graph%{lib_appendix}
Summary:        Boost.Graph runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_graph%{lib_appendix}
This package contains the Boost.Graph runtime library.

%package     -n libboost_graph%{lib_appendix}-devel
Summary:        Development headers for Boost.Graph library
Group:          Development/Libraries/C and C++
Requires:       libboost_graph%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
## FIXME:!!!! need better list of requirements here
Requires:       libstdc++-devel
Provides:       libboost_graph-devel = %{version}
Conflicts:      otherproviders(libboost_graph-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_graph%{lib_appendix}-devel
Development headers for Boost.Graph library. The BGL algorithms consist
of a core set of algorithm patterns and a larger set of graph
algorithms. The core algorithm patterns are Breadth First Search, Depth
First Search, and Uniform Cost Search.


%package     -n libboost_iostreams%{lib_appendix}
Summary:        Boost.IOStreams Runtime Libraries
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_iostreams%{lib_appendix}
This package contains the Boost.IOStreams Runtime libraries.

%package     -n libboost_iostreams%{lib_appendix}-devel
Summary:        Development headers for Boost.IOStreans library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_iostreams%{lib_appendix} = %{version}
Provides:       libboost_iostreams-devel = %{version}
Conflicts:      otherproviders(libboost_iostreams-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_iostreams%{lib_appendix}-devel
Boost.IOStreams provides a framework for defining streams, stream
buffers and IO filters

%package     -n libboost_log%{lib_appendix}
Summary:        Boost.Log runtime Run-Time library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_log%{lib_appendix}
This package contains runtime library for Boost.Log.

%package     -n libboost_log%{lib_appendix}-devel
Summary:        Development headers for Boost.Log library
Group:          Development/Libraries/C and C++
Requires:       libboost_date_time%{lib_appendix}-devel = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_log%{lib_appendix} = %{version}
Requires:       libboost_system%{lib_appendix} = %{version}
Requires:       libboost_thread%{lib_appendix} = %{version}
Provides:       libboost_log-devel = %{version}
Conflicts:      otherproviders(libboost_log-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_log%{lib_appendix}-devel
Development headers for Boost.Log library which aims to make logging
significantly easier for the application developer. It provides a wide
range of out-of-the-box tools along with public interfaces for extending
the library.

%package     -n libboost_math%{lib_appendix}
Summary:        Boost.Math runtime libraries
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_math%{lib_appendix}
This package contains the Boost.Math Runtime libraries.

%package     -n libboost_math%{lib_appendix}-devel
Summary:        Development headers for Boost.Math libraries
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_math%{lib_appendix} = %{version}
Provides:       libboost_math-devel = %{version}
Conflicts:      otherproviders(libboost_math-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_math%{lib_appendix}-devel
Development headers for Boost.Math* boost libraries.

%if %{with build_mpi}
%package     -n libboost_mpi%{lib_appendix}
Summary:        Boost.MPI runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_mpi%{lib_appendix}
This package contains the Boost.MPI runtime library.

%package     -n libboost_mpi%{lib_appendix}-devel
Summary:        Development headers for Boost.MPI library
Group:          Development/Libraries/C and C++
Requires:       libboost_graph%{lib_appendix}-devel
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
%if %{with python2}
Requires:       libboost_python-py2_7-%{lib_appendix}-devel
%endif
%if %{with python3}
Requires:       libboost_python-py3-%{lib_appendix}-devel
%endif
Requires:       %{mpi_implem}-devel
Requires:       libboost_mpi%{lib_appendix} = %{version}
Requires:       libboost_serialization%{lib_appendix}-devel
Provides:       libboost_mpi-devel = %{version}
Conflicts:      otherproviders(libboost_mpi-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_mpi%{lib_appendix}-devel
Development headers for Boost.MPI boost library

%package     -n libboost_graph_parallel%{lib_appendix}
Summary:        Boost.Graph.Distributed runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_graph_parallel%{lib_appendix}
This package contains the Boost.Graph parallel runtime library

%package     -n libboost_graph_parallel%{lib_appendix}-devel
Summary:        Development headers for Boost.Graph parallel library
Group:          Development/Libraries/C and C++
Requires:       libboost_graph_parallel%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_mpi%{lib_appendix}-devel = %{version}
Provides:       libboost_graph_parallel-devel = %{version}
Conflicts:      otherproviders(libboost_graph_parallel-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_graph_parallel%{lib_appendix}-devel
Development headers for Boost.Graph parallel boost library.

%if %{with python2}
%package     -n libboost_mpi_python-py2_7-%{lib_appendix}
Summary:        Boost.MPI Python serialization library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_mpi_python-py2_7-%{lib_appendix}
This package contains the Boost.MPI Python 2.7 serialization library

%package     -n libboost_mpi_python-py2_7-%{lib_appendix}-devel
Summary:        Development library for Boost.MPI Python 2.7 serialization
Group:          Development/Libraries/C and C++
Requires:       libboost_mpi%{lib_appendix}-devel = %{version}
Requires:       libboost_mpi_python-py2_7-%{lib_appendix} = %{version}
Requires:       libboost_python-py2_7-%{lib_appendix} = %{version}
Provides:       libboost_mpi_python-devel = %{version}
Conflicts:      otherproviders(libboost_mpi_python-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_mpi_python-py2_7-%{lib_appendix}-devel
This package contains the Boost.MPI development library for Python 2.7
serialization interface.


%package     -n python2-boost_parallel_mpi%{lib_appendix}
Summary:        Python 2.7 bindings for Boost.Parallel.MPI library
Group:          Development/Languages/Python
Provides:       python-boost_parallel_mpi = %{version}
Provides:       python-boost_parallel_mpi%{lib_appendix} = %{version}
Conflicts:      otherproviders(python-boost_parallel_mpi)

%description -n python2-boost_parallel_mpi%{lib_appendix}
This package contains the Boost.Parallel.MPI bindings for Python 2.7

%endif # python2

%if %{with python3}

%package     -n libboost_mpi_python-py3-%{lib_appendix}
Summary:        Boost.MPI Python 3.x serialization library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_mpi_python-py3-%{lib_appendix}
This package contains the Boost.MPI Python 3.x serialization
inteface.

%package     -n libboost_mpi_python-py3-%{lib_appendix}-devel
Summary:        Development library for Boost.MPI Python 3.x serialization
Group:          Development/Libraries/C and C++
Requires:       libboost_mpi%{lib_appendix}-devel = %{version}
Requires:       libboost_mpi_python-py3-%{lib_appendix} = %{version}
Requires:       libboost_python-py3-%{lib_appendix} = %{version}
Provides:       libboost_mpi_python3-devel = %{version}
Conflicts:      otherproviders(libboost_mpi_python3-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_mpi_python-py3-%{lib_appendix}-devel
This package contains the Boost.MPI development library for Python 3.x
serialization interface

%package     -n python3-boost_parallel_mpi%{lib_appendix}
Summary:        Python 3.x bindings for Boost.Parallel.MPI library
Group:          Development/Languages/Python
Provides:       python3-boost_parallel_mpi = %{version}
Conflicts:      otherproviders(python3-boost_parallel_mpi)

%description -n python3-boost_parallel_mpi%{lib_appendix}
This package contains the Boost.Parallel.MPI bindings for Python 3.x

%endif  # python3
%endif  # mpi

%package    -n libboost_test%{lib_appendix}
Summary:        Boost.Test runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_test%{lib_appendix}
This package contains the BoosttTest runtime library.

%package     -n libboost_test%{lib_appendix}-devel
Summary:        Development headers for Boost.Test library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_test%{lib_appendix} = %{version}
Provides:       libboost_test-devel = %{version}
Conflicts:      otherproviders(libboost_test-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_test%{lib_appendix}-devel
Development headers for Boost.Test library. Boost.Test supports for
simple program testing, full unit testing, and for program execution
monitoring.

%package     -n libboost_program_options%{lib_appendix}
Summary:        Boost.ProgramOptions runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_program_options%{lib_appendix}
This package contains the Boost.ProgramOptions runtime library.

%package     -n libboost_program_options%{lib_appendix}-devel
Summary:        Development headers for Boost.ProgramOptions library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_program_options%{lib_appendix} = %{version}
Provides:       libboost_program_options-devel = %{version}
Conflicts:      otherproviders(libboost_program_options-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_program_options%{lib_appendix}-devel
This package contains development headers for Boost.ProgramOptions
library.

%if %{with python2}
%package     -n libboost_python-py2_7-%{lib_appendix}
Summary:        Boost.Python runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_python-py2_7-%{lib_appendix}
This package contains the Boost::Python runtime library for default
version of python.

%package     -n libboost_python-py2_7-%{lib_appendix}-devel
Summary:        Development headers for Boost.Python library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_python-py2_7-%{lib_appendix} = %{version}
Provides:       libboost_python-devel = %{version}
Conflicts:      otherproviders(libboost_python-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_python-py2_7-%{lib_appendix}-devel
Development headers for Boost::Python library for the default version of
python.

%if %{with python_numpy}
%package     -n libboost_numpy-py2_7-%{lib_appendix}
Summary:        Boost.Python.NumPy runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_numpy-py2_7-%{lib_appendix}
This package contains the Boost::Python::NumPy runtime library for default
version of python.

%package     -n libboost_numpy-py2_7-%{lib_appendix}-devel
Summary:        Development headers for Boost.Python.NumPy library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_numpy-py2_7-%{lib_appendix} = %{version}
Provides:       libboost_numpy-devel = %{version}
Conflicts:      otherproviders(libboost_numpy-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_numpy-py2_7-%{lib_appendix}-devel
Development headers for Boost::Python::NumPy library for the default version of
python.
%endif # with numpy
%endif # with python2

%if %{with python3}
%package     -n libboost_python-py3-%{lib_appendix}
Summary:        Boost.Python runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description    -n libboost_python-py3-%{lib_appendix}
This package contains the Boost.Python runtime libraries for python3
bindings.

%package     -n libboost_python-py3-%{lib_appendix}-devel
Summary:        Development headers for Boost.Python library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_python-py3-%{lib_appendix} = %{version}
Provides:       libboost_python3-devel = %{version}
Conflicts:      otherproviders(libboost_python3-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_python-py3-%{lib_appendix}-devel
Development headers for Boost.Python library. This package contains
library for python3 development for boost.

%if %{with python_numpy}
%package     -n libboost_numpy-py3-%{lib_appendix}
Summary:        Boost.Python.NumPy runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description    -n libboost_numpy-py3-%{lib_appendix}
This package contains the Boost.Python.NumPy runtime libraries for python3
bindings.

%package     -n libboost_numpy-py3-%{lib_appendix}-devel
Summary:        Development headers for Boost.Python.NumPy library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_numpy-py3-%{lib_appendix} = %{version}
Provides:       libboost_numpy3-devel = %{version}
Conflicts:      otherproviders(libboost_numpy3-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_numpy-py3-%{lib_appendix}-devel
Development headers for Boost.Python.NumPy library. This package contains
library for python3 development for boost.
%endif  # with numpy

%endif  # with python3

%package     -n libboost_serialization%{lib_appendix}
Summary:        Boost.Serialization runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_serialization%{lib_appendix}
This package contains the Boost.Serialization runtime library.

%package     -n libboost_serialization%{lib_appendix}-devel
Summary:        Development headers for Boost.Serialization library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_serialization%{lib_appendix} = %{version}
Provides:       libboost_serialization-devel = %{version}
Conflicts:      otherproviders(libboost_serialization-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_serialization%{lib_appendix}-devel
This package contains development headers for Boost.Serialization
library.

%package     -n libboost_signals%{lib_appendix}
Summary:        Boost.Signals runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_signals%{lib_appendix}
This package contains the Boost::Signals Runtime library.

%package     -n libboost_signals%{lib_appendix}-devel
Summary:        Development headers for Boost.Signals library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_signals%{lib_appendix} = %{version}
Provides:       libboost_signals-devel = %{version}
Conflicts:      otherproviders(libboost_signals-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_signals%{lib_appendix}-devel
This package contains development headers for Boost.Signals library.
Boost.Signals is deprecated in favour of Boost.Signals2, a header-only
library and part of libboost_headers-devel.

%package     -n libboost_stacktrace%{lib_appendix}
Summary:        Boost.Stacktrace runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_stacktrace%{lib_appendix}
This package contains the Boost.Stacktrace runtime library.

%package     -n libboost_stacktrace%{lib_appendix}-devel
Summary:        Development headers for Boost.Stacktrace library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_stacktrace%{lib_appendix} = %{version}
Provides:       libboost_stacktrace-devel = %{version}
Conflicts:      otherproviders(libboost_stacktrace-devel)

%description -n libboost_stacktrace%{lib_appendix}-devel
This package contains development headers for Boost.Stacktrace library.
Boost.Stacktrace is a simple C++03 library that provide information
about call sequence in a human-readable form.

%package     -n libboost_system%{lib_appendix}
Summary:        Boost.System runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_system%{lib_appendix}
This package contains the Boost.System runtime library.

%package     -n libboost_system%{lib_appendix}-devel
Summary:        Development headers for Boost.System library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_system%{lib_appendix} = %{version}
Provides:       libboost_system-devel = %{version}
Conflicts:      otherproviders(libboost_system-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_system%{lib_appendix}-devel
This package contains development headers for Boost.System library.

%package     -n libboost_thread%{lib_appendix}
Summary:        Boost.Thread runtime libraries
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_thread%{lib_appendix}
This package contains the Boost.Thread runtime library.

%package     -n libboost_thread%{lib_appendix}-devel
Summary:        Development headers for Boost.Thread library
Group:          Development/Libraries/C and C++
Requires:       libboost_chrono%{lib_appendix}-devel = %{version}
Requires:       libboost_date_time%{lib_appendix}-devel = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_thread%{lib_appendix} = %{version}
Provides:       libboost_thread-devel = %{version}
Conflicts:      otherproviders(libboost_thread-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_thread%{lib_appendix}-devel
This package contains development headers for Boost.Thread library.

%package     -n libboost_wave%{lib_appendix}
Summary:        Boost.Wave runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_wave%{lib_appendix}
This package contains the Boost::Wave runtime library.

%package     -n libboost_wave%{lib_appendix}-devel
Summary:        Development headers for Boost.Wave library
Group:          Development/Libraries/C and C++
Requires:       libboost_filesystem%{lib_appendix}-devel = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_serialization%{lib_appendix}-devel = %{version}
Requires:       libboost_wave%{lib_appendix} = %{version}
Provides:       libboost_wave-devel = %{version}
Conflicts:      otherproviders(libboost_wave-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_wave%{lib_appendix}-devel
This package contains development headers for Boost.Wave library.

%package     -n libboost_regex%{lib_appendix}
Summary:        Boost.Regex runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_regex%{lib_appendix}
This package contains the Boost.Regex runtime library.

%package     -n libboost_regex%{lib_appendix}-devel
Summary:        Development headers for Boost.Regex library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_regex%{lib_appendix} = %{version}
Provides:       libboost_regex-devel = %{version}
Conflicts:      otherproviders(libboost_regex-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_regex%{lib_appendix}-devel
This package contains development headers for Boost.Regex library.

%package     -n libboost_random%{lib_appendix}
Summary:        Boost.Random runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_random%{lib_appendix}
This package contains the Boost.Random runtime library.

%package     -n libboost_random%{lib_appendix}-devel
Summary:        Development headers for Boost.Random library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_random%{lib_appendix} = %{version}
Provides:       libboost_random-devel = %{version}
Conflicts:      otherproviders(libboost_random-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_random%{lib_appendix}-devel
This package contains Boost.Random development headers.

%package     -n libboost_chrono%{lib_appendix}
Summary:        The Boost::Chrono runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_chrono%{lib_appendix}
This package contains the Boost::Chrono runtime library.

%package     -n libboost_chrono%{lib_appendix}-devel
Summary:        Development headers for Boost.Chrono library
Group:          Development/Libraries/C and C++
Requires:       libboost_chrono%{lib_appendix} = %{version}
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Provides:       libboost_chrono-devel = %{version}
Conflicts:      otherproviders(libboost_chrono-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_chrono%{lib_appendix}-devel
This package contains Boost.Chrono development headers.

%package     -n libboost_locale%{lib_appendix}
Summary:        Boost::Locale runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_locale%{lib_appendix}
This package contains Boost::Locale runtime library.

%package     -n libboost_locale%{lib_appendix}-devel
Summary:        Development headers for Boost.Locale library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_locale%{lib_appendix} = %{version}
Provides:       libboost_locale-devel = %{version}
Conflicts:      otherproviders(libboost_locale-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_locale%{lib_appendix}-devel
This package contains development headers for Boost.Locale library.

%package     -n libboost_timer%{lib_appendix}
Summary:        Boost.Timer runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_timer%{lib_appendix}
This package contains Boost.Timer runtime library.

%package     -n libboost_timer%{lib_appendix}-devel
Summary:        Development headers for Boost.Timer library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_system%{lib_appendix}-devel = %{version}
Requires:       libboost_timer%{lib_appendix} = %{version}
Provides:       libboost_timer-devel = %{version}
Conflicts:      otherproviders(libboost_timer-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_timer%{lib_appendix}-devel
This package contains development headers for Boost.Timer library.

%package     -n libboost_type_erasure%{lib_appendix}
Summary:        Boost.TypeErasure runtime library
Group:          System/Libraries
Requires:       boost-license%{lib_appendix}

%description -n libboost_type_erasure%{lib_appendix}
This package contains Boost::TypeErasure runtime library.

%package     -n libboost_type_erasure%{lib_appendix}-devel
Summary:        Development headers for Boost.TypeErasure library
Group:          Development/Libraries/C and C++
PreReq:         libboost_headers%{lib_appendix}-devel = %{version}
Requires:       libboost_type_erasure%{lib_appendix} = %{version}
Provides:       libboost_type_erasure-devel = %{version}
Conflicts:      otherproviders(libboost_type_erasure-devel)
Conflicts:      boost-devel < 1.63

%description -n libboost_type_erasure%{lib_appendix}-devel
This package contains development headers for Boost.TypeErasure library.

%if %{with build_quickbook}
%package -n %{package_name}-quickbook
Summary:        Documentation tool geared towards C++
Group:          Development/Tools/Doc Generators
Requires:       boost-license%{lib_appendix}
Provides:       quickbook = %version
Conflicts:      otherproviders(quickbook)

%description -n %{package_name}-quickbook
QuickBook is a WikiWiki style documentation tool geared towards C++
documentation using simple rules and markup for simple formatting
tasks.
%endif

%prep
%setup -q -n boost_%{lib_appendix} -b 3
#everything in the tarball has the executable flag set ...
find -type f ! \( -name \*.sh -o -name \*.py -o -name \*.pl \) -exec chmod -x {} +
%patch1 -p1
%patch2
%patch3
%patch4
%patch5
%patch6 -p1
%patch7
%patch9 -p1
%patch10 -p1
%patch13
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

%build
find . -type f -exec chmod u+w {} +

# General case
cat << EOF >user-config.jam
import os ;
local RPM_OPT_FLAGS = [ os.environ RPM_OPT_FLAGS ] ;
using gcc : : : <compileflags>\$(RPM_OPT_FLAGS) ;
project user-config ;
EOF

%if %build_base
cat << \EOF >.build
export LIBRARIES_FLAGS="--without-mpi --without-python"
%if ! %{with build_context}
# coroutine depends on context
LIBRARIES_FLAGS+=" --without-context --without-coroutine"
%endif

%if ! %{with boost_fiber}
LIBRARIES_FLAGS+=" --without-fiber"
%endif
EOF

%else # ! build_base

# Since boost build system is broken and incable of handling multiple python versions,
# we need to build boost piece by piece. First time to build all the non-python bits,
# then we build MPI and/or PYTHON modules for two python versions we need.
# MPI builds a python module.
cat << \EOF >.build
export PY_LIBRARIES_FLAGS="--with-python"
%if %{with build_mpi}
PY_LIBRARIES_FLAGS+=" --with-mpi"
%endif

# Dummy entry to make sure we don't build everything
export LIBRARIES_FLAGS="--with-system"

# Dummy entry replaced with real libraries, if we build something
%if %{with build_mpi}
LIBRARIES_FLAGS=" --with-graph_parallel"
%endif

EOF

%if %{with build_mpi}
# Set PATH, MANPATH and LD_LIBRARY_PATH for mpi
. %{_libdir}/mpi/gcc/%{mpi_implem}/bin/mpivars.sh
%endif

# Need specific Boost Jam config files.
#   1. one all "normal" libraries
#   2. one for each python version for for python/mpi libraries
#      use staging directories for MPI/PYTHON combinations.

# General case
cat << EOF >user-config.jam
alias boost_python_alias : : <library>/boost/python//boost_python ;
EOF
%endif # ! build_base

# bootstrap b2
./bootstrap.sh \
    --prefix=%{_prefix} --exec-prefix=%{_bindir} \
    --libdir=%{_libdir} --includedir=%{_includedir} \
    --with-toolset=gcc

# Read shared build instructions
. ./.build

%if ! %build_base

# Build boost base PYTHON and MPI, installed in python staging
cp user-config.jam user-config-py.jam
cat << EOF >> user-config-py.jam
using python 
     : %{py_ver}
     : %{_bindir}/python2
     : %{_includedir}/python%{py_ver}
     : %{_libdir}/python%{py_ver}
     :
     :
     ;
%if %{with build_mpi}
using mpi ;
%endif
EOF

%if %{with python2}
./b2 -d+2 -q --user-config=./user-config-py.jam \
    --build-type=minimal --build-dir=./python-build \
    --python-buildid=py2.7 \
    --stagedir=./python-stage %{?_smp_mflags} \
    $PY_LIBRARIES_FLAGS \
    threading=multi link=shared runtime-link=shared stage
%endif # with python2

# Build boost python3 and MPI, installed in python3 staging
%if %{with python3}
cp user-config.jam user-config-py3.jam
# sed -i -e 's#//boost_python#//boost_python3#' ./user-config-py3.jam
%{?!py3_abiflags: %define py3_abiflags m}
%{?!python3_version: %define python3_version %py3_ver }

cat << EOF >> user-config-py3.jam
using python
	: %{python3_version}
	: %{_bindir}/python3
	: %{_includedir}/python%{python3_version}%{py3_abiflags}
	:
	:
	: .%{py3_soflags}
	: %{py3_abiflags}
	;
%if %{with build_mpi}
using mpi ;
%endif
EOF

./b2 -d+2 -q --user-config=./user-config-py3.jam \
    --build-type=minimal --build-dir=./python3-build \
    --python-buildid=py3 \
    --stagedir=./python3-stage %{?_smp_mflags} \
    $PY_LIBRARIES_FLAGS \
    threading=multi link=shared runtime-link=shared stage
%endif # python3

%if %{with build_docs}
cat << EOF >>user-config.jam
using xsltproc ;

using boostbook
    : %{_datadir}/xml/docbook/stylesheet/nwalsh/current
    : %{_datadir}/xml/docbook/schema/dtd/4.2
    ;

using doxygen ;
EOF
%endif

# needed to get graph_parallel built
%if %{with build_mpi}
echo 'using mpi ;' >> ./user-config.jam
%endif

%endif # ! build_base

# This is run for both mini and non-mini build
./b2 -d+2 -q --user-config=./user-config.jam \
    --build-type=minimal --build-dir=./build \
    --stagedir=./stage %{?_smp_mflags} \
    $LIBRARIES_FLAGS \
    threading=multi link=shared runtime-link=shared stage

%if ! %build_base

# Verify that all symbols built in different stages are interchangeable.
# Can't be too careful!
cp %{SOURCE101} .
chmod +x symbol_diff.sh
%if %{with python3}
./symbol_diff.sh python3-stage/lib/libboost_mpi.so           stage/lib/libboost_mpi.so
./symbol_diff.sh python3-stage/lib/libboost_serialization.so stage/lib/libboost_serialization.so
%endif
%if %{with python2}
./symbol_diff.sh python-stage/lib/libboost_serialization.so  stage/lib/libboost_serialization.so
./symbol_diff.sh python-stage/lib/libboost_mpi.so            stage/lib/libboost_mpi.so
%endif
#./symbol_diff.sh python-stage/lib/libboost_serialization.so  stage/lib/libboost_serialization.so
#./symbol_diff.sh python-stage/lib/libboost_mpi.so            stage/lib/libboost_mpi.so

# Build documentation
%if %{with build_quickbook}
pushd tools/quickbook
../../b2 --user-config=../../user-config.jam --v2 dist-bin %{?_smp_mflags}
popd
%endif

%if %{with build_docs}
cd doc
./b2 --user-config=../user-config.jam --v2 man %{?_smp_mflags}
%endif

%endif # ! build_base

%install

# Read shared build instructions
. ./.build

%if ! %build_base

%if %{with build_mpi}
# Set PATH, MANPATH and LD_LIBRARY_PATH for mpi
. %{_libdir}/mpi/gcc/%{mpi_implem}/bin/mpivars.sh
%endif

%if %{with python3}
./b2 -d+2 -q --user-config=./user-config-py3.jam \
    --build-type=minimal --build-dir=./python3-build \
    --python-buildid=py3 \
    --prefix=%{buildroot}%{_prefix} --exec-prefix=%{buildroot}%{_bindir} \
    --libdir=%{buildroot}%{_libdir} --includedir=%{buildroot}%{_includedir} \
    --stagedir=./python3-stage %{?_smp_mflags} \
    $PY_LIBRARIES_FLAGS \
    threading=multi link=shared runtime-link=shared install
%endif

%if %{with python2}
./b2 -d+2 -q --user-config=./user-config-py.jam \
    --build-type=minimal --build-dir=./python-build \
    --python-buildid=py2.7 \
    --prefix=%{buildroot}%{_prefix} --exec-prefix=%{buildroot}%{_bindir} \
    --libdir=%{buildroot}%{_libdir} --includedir=%{buildroot}%{_includedir} \
    --stagedir=./python-stage %{?_smp_mflags} \
    $PY_LIBRARIES_FLAGS \
    threading=multi link=shared runtime-link=shared install
%endif

%endif # ! build_base

# Generic install
./b2 -d+2 -q \
     --build-type=minimal --build-dir=./build --stagedir=./stage \
     --prefix=%{buildroot}%{_prefix} --exec-prefix=%{buildroot}%{_bindir} \
     --libdir=%{buildroot}%{_libdir} --includedir=%{buildroot}%{_includedir} \
     --user-config=./user-config.jam \
     $LIBRARIES_FLAGS \
     threading=multi link=shared runtime-link=shared install

# No python dependencies in the main tree

! $(ldd %{buildroot}%{_libdir}/*.so* | grep python\\.)

%if ! %build_base
%if %{with python2}
ln -s libboost_mpi_python-py2_7.so %{buildroot}%{_libdir}/libboost_mpi_python.so
ln -s libboost_python-py2_7.so     %{buildroot}%{_libdir}/libboost_python.so
%endif

%if %{with python3}
! $(ldd %{buildroot}%{_libdir}/*.so* | grep python3-\\.)
ln -s libboost_python-py3.so       %{buildroot}%{_libdir}/libboost_python3.so
%endif

# Move Python libraries over to proper places
%if %{with python2}
mkdir -p %{buildroot}%{python2_sitearch}/boost/parallel/mpi/
mv %{buildroot}/%{_libdir}/mpi.so %{buildroot}%{python2_sitearch}/boost/parallel/mpi/
install -m 0644 libs/mpi/build/__init__.py %{buildroot}%{python2_sitearch}/boost/parallel/mpi/
install -m 0644 %{SOURCE11} %{buildroot}%{python2_sitearch}/boost/parallel
install -m 0644 %{SOURCE11} %{buildroot}%{python2_sitearch}/boost
%endif

%if %{with python3}
mkdir -p %{buildroot}%{python3_sitearch}/boost/parallel/mpi/
mv %{buildroot}/%{_libdir}/mpi.*so %{buildroot}%{python3_sitearch}/boost/parallel/mpi/mpi.%{py3_soflags}.so
install -m 0644 libs/mpi/build/__init__.py %{buildroot}%{python3_sitearch}/boost/parallel/mpi/
install -m 0644 %{SOURCE11} %{buildroot}%{python3_sitearch}/boost/parallel
install -m 0644 %{SOURCE11} %{buildroot}%{python3_sitearch}/boost
%endif

#install doc files
mkdir -p %{buildroot}%{my_docdir}
%if %{with boost_devel}
install -m 0644 %{SOURCE102} %{buildroot}%{my_docdir}
%endif
find libs/ -name \*.htm\* -o -name \*.css -o -name \*.js | xargs dos2unix
find . -name \*.htm\* -o -name \*.gif -o -name \*.css -o -name \*.jpg -o -name \*.png -o -name \*.ico | \
	tar --files-from=%{SOURCE4} -cf - --files-from=- | tar -C %{buildroot}%{my_docdir} -xf -
rm -rf %{buildroot}%{my_docdir}/boost
#ln -s %%{_includedir}/boost %%{buildroot}%%{my_docdir}
#ln -s ../LICENSE_1_0.txt %%{buildroot}%%{my_docdir}/libs
find %{buildroot}%{my_docdir} -name \*.py -exec chmod -x {} +
chmod -x ../boost_%{short_version}_pdf/*.pdf

%if %{with build_quickbook}
mkdir -p %{buildroot}%{_bindir}
install -m 0755 dist/bin/quickbook %{buildroot}%{_bindir}/quickbook
%endif

%endif # ! build_base

%if %build_base
mkdir -p %{buildroot}%{_bindir}
install -m 755 bjam %{buildroot}%{_bindir}
ln -s bjam %{buildroot}%{_bindir}/jam

# Remove exception library, but only if the symbols are not
# actually used. For now, the only symbol that is linked is
# should never be used as it's only available on Windows. So,
# verify that here.
objdump -Ctj .text -Ctj .text %{buildroot}%{_libdir}/libboost_exception.so | \
  grep '^[0-9a-f]\+[[:space:]]\+g[[:space:]]\+F' | \
  sed -e 's#[0-9a-f]\+[[:space:]]\+g[[:space:]]\+F[[:space:]]\+\.text[[:space:]]\+[0-9a-f]\+[[:space:]]\+##' | \
  diff %{SOURCE10} - || echo "WARNING: libexception symbol change?"
rm %{buildroot}%{_libdir}/libboost_exception.so
rm %{buildroot}%{_libdir}/libboost_exception.so.%{version}

%fdupes %{buildroot}%{_includedir}/boost
mkdir -p %{buildroot}%{my_docdir}
%else  # ! build_base
rm -r %{buildroot}%{_includedir}/boost
rm %{buildroot}%{_libdir}/libboost_serialization*
rmdir --ignore-fail-on-non-empty %{buildroot}%{_libdir}
%fdupes %{buildroot}%{my_docdir}
%endif

%if %build_base
%post -n libboost_atomic%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_container%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_context%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_coroutine%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_date_time%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_fiber%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_filesystem%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_iostreams%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_log%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_test%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_program_options%{lib_appendix} -p /sbin/ldconfig

%post -n libboost_regex%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_serialization%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_signals%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_thread%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_type_erasure%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_math%{lib_appendix} -p /sbin/ldconfig

%post -n libboost_graph%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_stacktrace%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_system%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_wave%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_random%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_chrono%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_locale%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_timer%{lib_appendix} -p /sbin/ldconfig

%else  # ! build_base

%if %{with python2}
%post -n libboost_python-py2_7-%{lib_appendix} -p /sbin/ldconfig
%if %{with python_numpy}
%post -n libboost_numpy-py2_7-%{lib_appendix} -p /sbin/ldconfig
%endif
%endif

%if %{with python3}
%post -n libboost_python-py3-%{lib_appendix} -p /sbin/ldconfig
%if %{with python_numpy}
%post -n libboost_numpy-py3-%{lib_appendix} -p /sbin/ldconfig
%endif
%endif

%if %{with build_mpi}
%post -n libboost_mpi%{lib_appendix} -p /sbin/ldconfig
%post -n libboost_graph_parallel%{lib_appendix} -p /sbin/ldconfig
%if %{with python2}
%post -n libboost_mpi_python-py2_7-%{lib_appendix} -p /sbin/ldconfig
%endif
%if %{with python3}
%post -n libboost_mpi_python-py3-%{lib_appendix} -p /sbin/ldconfig
%endif
%endif

%endif # ! build_base

%if %build_base
%postun -n libboost_atomic%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_container%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_context%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_coroutine%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_date_time%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_fiber%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_filesystem%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_iostreams%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_log%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_test%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_program_options%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_regex%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_serialization%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_signals%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_thread%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_type_erasure%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_math%{lib_appendix} -p /sbin/ldconfig

%postun -n libboost_graph%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_stacktrace%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_system%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_wave%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_random%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_chrono%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_locale%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_timer%{lib_appendix} -p /sbin/ldconfig

%else # ! build_base

%if %{with python2}
%postun -n libboost_python-py2_7-%{lib_appendix} -p /sbin/ldconfig
%if %{with python_numpy}
%postun -n libboost_numpy-py2_7-%{lib_appendix} -p /sbin/ldconfig
%endif
%endif

%if %{with python3}
%postun -n libboost_python-py3-%{lib_appendix} -p /sbin/ldconfig
%if %{with python_numpy}
%postun -n libboost_numpy-py3-%{lib_appendix} -p /sbin/ldconfig
%endif
%endif

%if %{with build_mpi}
%postun -n libboost_mpi%{lib_appendix} -p /sbin/ldconfig
%postun -n libboost_graph_parallel%{lib_appendix} -p /sbin/ldconfig
%if %{with python2}
%postun -n libboost_mpi_python-py2_7-%{lib_appendix} -p /sbin/ldconfig
%endif
%if %{with python3}
%postun -n libboost_mpi_python-py3-%{lib_appendix} -p /sbin/ldconfig
%endif
%endif

%endif # build_base

%if %{build_base}
%files -n %{package_name}-jam
%defattr(-, root, root, -)
%{_bindir}/bjam
%{_bindir}/jam

%files -n libboost_atomic%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_atomic.so.%{version}

%files -n libboost_atomic%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_atomic.so

%files -n libboost_container%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_container.so.%{version}

%files -n libboost_container%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_container.so

%if %{with build_context}

%files -n libboost_context%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_context.so.%{version}

%files -n libboost_context%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_context.so

%files -n libboost_coroutine%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_coroutine.so.%{version}

%files -n libboost_coroutine%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_coroutine.so

%endif # if with build_context

%files -n libboost_date_time%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_date_time.so.%{version}

%files -n libboost_date_time%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_date_time.so

%if %{with boost_fiber}

%files -n libboost_fiber%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_fiber.so.%{version}

%files -n libboost_fiber%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_fiber.so

%endif # with boost_fiber

%files -n libboost_filesystem%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_filesystem.so.%{version}

%files -n libboost_filesystem%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_filesystem.so

%files -n libboost_graph%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_graph.so.%{version}

%files -n libboost_graph%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_graph.so

%files -n libboost_iostreams%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_iostreams.so.%{version}

%files -n libboost_iostreams%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_iostreams.so

%files -n libboost_log%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_log.so.%{version}
%{_libdir}/libboost_log_setup.so.%{version}

%files -n libboost_log%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_log.so
%{_libdir}/libboost_log_setup.so

%files -n libboost_math%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_math_c99f.so.%{version}
%{_libdir}/libboost_math_c99l.so.%{version}
%{_libdir}/libboost_math_c99.so.%{version}
%{_libdir}/libboost_math_tr1f.so.%{version}
%{_libdir}/libboost_math_tr1l.so.%{version}
%{_libdir}/libboost_math_tr1.so.%{version}

%files -n libboost_math%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_math_c99f.so
%{_libdir}/libboost_math_c99l.so
%{_libdir}/libboost_math_c99.so
%{_libdir}/libboost_math_tr1f.so
%{_libdir}/libboost_math_tr1l.so
%{_libdir}/libboost_math_tr1.so

%files -n libboost_test%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_prg_exec_monitor.so.%{version}
%{_libdir}/libboost_test_exec_monitor.so.%{version}
%{_libdir}/libboost_unit_test_framework.so.%{version}

%files -n libboost_test%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_prg_exec_monitor.so
%{_libdir}/libboost_test_exec_monitor.so
%{_libdir}/libboost_unit_test_framework.so

%files -n libboost_program_options%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_program_options.so.%{version}

%files -n libboost_program_options%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_program_options.so
%endif # build_base

%if ! %build_base

%if %{with build_mpi}
%files -n libboost_mpi%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_mpi.so.%{version}

%files -n libboost_mpi%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_mpi.so

%files -n libboost_graph_parallel%{lib_appendix}
%defattr(-,root,root)
%{_libdir}/libboost_graph_parallel.so.%{version}

%files -n libboost_graph_parallel%{lib_appendix}-devel
%defattr(-,root,root)
%{_libdir}/libboost_graph_parallel.so

%if %{with python2}
%files -n libboost_mpi_python-py2_7-%{lib_appendix}
%defattr(-,root,root)
%{_libdir}/libboost_mpi_python-py2_7.so.%{version}

%files -n libboost_mpi_python-py2_7-%{lib_appendix}-devel
%defattr(-,root,root)
%{_libdir}/libboost_mpi_python-py2_7.so
%{_libdir}/libboost_mpi_python.so

%files -n python2-boost_parallel_mpi%{lib_appendix}
%defattr(-, root, root, -)
%dir %{python2_sitearch}/boost
%dir %{python2_sitearch}/boost/parallel
%dir %{python2_sitearch}/boost/parallel/mpi
%{python2_sitearch}/boost/__init__.py
%{python2_sitearch}/boost/parallel/__init__.py
%{python2_sitearch}/boost/parallel/mpi/__init__.py
%{python2_sitearch}/boost/parallel/mpi/mpi.so
%endif # with python2

%if %{with python3}
%files -n libboost_mpi_python-py3-%{lib_appendix}
%defattr(-,root,root)
%{_libdir}/libboost_mpi_python-py3.so.%{version}

%files -n libboost_mpi_python-py3-%{lib_appendix}-devel
%defattr(-,root,root)
%{_libdir}/libboost_mpi_python-py3.so

%files -n python3-boost_parallel_mpi%{lib_appendix}
%defattr(-, root, root, -)
%dir %{python3_sitearch}/boost
%dir %{python3_sitearch}/boost/parallel
%dir %{python3_sitearch}/boost/parallel/mpi
%{python3_sitearch}/boost/__init__.py
%{python3_sitearch}/boost/parallel/__init__.py
%{python3_sitearch}/boost/parallel/mpi/__init__.py
%{python3_sitearch}/boost/parallel/mpi/mpi.%{py3_soflags}.so

%endif # with python3
%endif # with build_mpi

%if %{with python2}
%files -n libboost_python-py2_7-%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_python-py2_7.so.%{version}

%files -n libboost_python-py2_7-%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_python.so
%{_libdir}/libboost_python-py2_7.so

%if %{with python_numpy}
%files -n libboost_numpy-py2_7-%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_numpy-py2_7.so.%{version}

%files -n libboost_numpy-py2_7-%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_numpy-py2_7.so

%endif # with numpy
%endif # with python2

%if %{with python3}
%files -n libboost_python-py3-%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_python-py3.so.%{version}

%files -n libboost_python-py3-%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_python3.so
%{_libdir}/libboost_python-py3.so

%if %{with python_numpy}
%files -n libboost_numpy-py3-%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_numpy-py3.so.%{version}

%files -n libboost_numpy-py3-%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_numpy-py3.so

%endif  # with numpy
%endif  # with python3
%endif  # ! build_base

%if %build_base
%files -n libboost_serialization%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_serialization.so.%{version}
%{_libdir}/libboost_wserialization.so.%{version}

%files -n libboost_serialization%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_serialization.so
%{_libdir}/libboost_wserialization.so

%files -n libboost_signals%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_signals.so.%{version}

%files -n libboost_signals%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_signals.so

%files -n libboost_stacktrace%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_stacktrace_addr2line.so.%{version}
%{_libdir}/libboost_stacktrace_basic.so.%{version}
%{_libdir}/libboost_stacktrace_noop.so.%{version}

%files -n libboost_stacktrace%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_stacktrace_addr2line.so
%{_libdir}/libboost_stacktrace_basic.so
%{_libdir}/libboost_stacktrace_noop.so

%files -n libboost_system%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_system.so.%{version}

%files -n libboost_system%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_system.so

%files -n libboost_thread%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_thread.so.%{version}

%files -n libboost_thread%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_thread.so

%files -n libboost_wave%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_wave.so.%{version}

%files -n libboost_wave%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_wave.so

%files -n libboost_regex%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_regex.so.%{version}

%files -n libboost_regex%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_regex.so

%files -n libboost_random%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_random.so.%{version}

%files -n libboost_random%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_random.so

%files -n libboost_chrono%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_chrono.so.%{version}

%files -n libboost_chrono%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_chrono.so

%files -n libboost_locale%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_locale.so.%{version}

%files -n libboost_locale%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_locale.so

%files -n libboost_timer%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_timer.so.%{version}

%files -n libboost_timer%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_timer.so

%files -n libboost_type_erasure%{lib_appendix}
%defattr(-, root, root, -)
%{_libdir}/libboost_type_erasure.so.%{version}

%files -n libboost_type_erasure%{lib_appendix}-devel
%defattr(-, root, root, -)
%{_libdir}/libboost_type_erasure.so
%endif # if build_base

%if ! %build_base
%if %{with boost_devel}
%files -n %{package_name}-devel
%defattr(-, root, root, -)
%dir %{my_docdir}
%{my_docdir}/README.boost-devel
%endif

%files -n %{package_name}-doc-html
%defattr(-, root, root, -)
%dir %{my_docdir}
%doc %{my_docdir}/*
# %%exclude %%{my_docdir}/LICENSE_1_0.txt
%if %{with boost_devel}
%exclude %{my_docdir}/README.boost-devel
%endif

%if %{with build_docs}
%files doc-man
%defattr(-, root, root, -)
%doc %{_mandir}/man3/*.3.gz
%doc %{_mandir}/man7/*.7.gz
%doc %{_mandir}/man9/*.9.gz
%endif

%if %{with package_pdf}
%files -n %{package_name}-doc-pdf
%defattr(-, root, root, -)
%doc ../boost_%{short_version}_pdf/*.pdf
%endif

%if %{with build_quickbook}
%files -n %{package_name}-quickbook
%defattr(-, root, root, -)
%{_bindir}/quickbook
%endif
%endif # ! build_base

%if %build_base
%files -n libboost_headers%{lib_appendix}-devel
%defattr(-, root, root, -)
%dir %{_includedir}/boost
%{_includedir}/boost/*

%files -n boost-license%{lib_appendix}
%defattr(-, root, root, -)
%license LICENSE_1_0.txt

%endif

%changelog
* Mon Jul  7 2025 aschnell@suse.com
- CVE-2016-9840: fixed out-of-bounds pointer arithmetic in zlib in beast
  (bsc#1245936)
  - adds patch boost-zlib.patch
* Mon Jan 10 2022 adam.majer@suse.de
- variant.patch: backport fix allowing perfect forwarding in
  apply_visitor. Also fix wrong usage of boost::move (bsc#1194522)
* Thu Mar 19 2020 adam.majer@suse.de
- libreoffice_compat_backports.patch: add a backport of
  Boost.Optional::has_value() for LibreOffice
* Wed Apr  4 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Fri Jan 19 2018 adam.majer@suse.de
- Multibuild requires versioned Name: tag and doesn't seem to do
  this automatically. (bnc#1076640)
* Mon Dec 18 2017 adam.majer@suse.de
- Update to version 1.66.0
  + Beast: new portable HTTP, WebSocket and network operations
    using Boost.Asio. Header-only library.
  + Callable Traits: new library and successor to
    Boost.FunctionTypes. Header-only library.
  + Mp11: new metaprogramming library
  + Asio:
  * implemented interface changes to reflect the Networking TS
    (N4656)
  * functions and classes that have been superseded by
    Networking TS functionality have been deprecated.
  * added support for customized handler tracking
  * removed previously deprecated functions
  + Atomic: improved compatibility with GCC 7. 128-bit operations
    on x86_64 no longer require linking with compiled library.
  + DateTime: Fixed an integral overflow that could cause incorrect
    results when adding or subtracting many years from a date.
  + Format: New format specifiers added and volatile arguments
    can not be safely used with operator%%
  + Fusion:
  * fix compile error with std::array
  * remove circular preprocessor include
  + PolyCollection: backported to GCC 4.8 and 4.9 with some
    limitations
  + Uuid: added RTF-4122 namespaces in boost::uuids::ns
  + for complete changelog, see
    http://www.boost.org/users/history/version_1_66_0.html
- refreshed patches: boost-rpmoptflags-only.patch
* Wed Nov 29 2017 adam.majer@suse.de
- re-enable Python 2 by default. It's still conditional, but
  remains enabled by default. This can be disabled in project
  config.
* Tue Oct 24 2017 jmatejek@suse.com
- build Python 2 conditionally
* Tue Oct 10 2017 adam.majer@suse.de
- Use multibuild setup - build no-dependency libraries in the
  base package and build the rest of the compiled libraries in
  the main variant. This should speed up bootstrapping.
- boost-devel not built by default anymore.
- libboost_headers-devel now provides boost-devel for legacy
  dependencies. If you need compiled boost libraries depend on
  the current compiled devel subpackage.
- run %%fdupes only on the header files and documentation
- drop build dependencies on gcc-fortran, chrpath.
* Mon Oct  9 2017 nmoreychaisemartin@suse.com
- Setup MPI environment prior to building boost.
- Switch to OpenMPI2 as OpenMPI1 is becoming deprecated.
* Wed Sep 20 2017 adam.majer@suse.de
- New upstream version 1.65.1
  + config, fiber - Return a continuation from functions executed
    by resume_with.
  + stacktrace - Change preprocessor file extensions to work with
    the installation system.
- Changes in version 1.65.0
  + stacktrace - new library providing call sequence in human
    readable format.
  + polycollection - new library providing fast containers of
    polymorphic objects, from Joaquín M López Muñoz.
  + For full list of changes, see
    http://www.boost.org/users/history/version_1_65_1.html
- 1d862615.patch: upstreamed and removed
- gcc_path.patch: obsolete, tr1 module is removed
- mpi_upstream.patch: upstreamed and removed
- boost-1.57.0-python-abi_letters.patch: refreshed
- python_library_name.patch: refreshed and reverted upstream
  changes to mpi/build/Jamfile as we are building python2 and
  python3 versions of MPI separately.
- baselibs.conf
  + add libboost_stracktrace
  + update to version 1.65.1
* Tue May  9 2017 adam.majer@suse.de
- 1d862615.patch: Fix regression caused by refactoring of
  serialization code (bnc#1038083)
* Mon May  8 2017 adam.majer@suse.de
- make python-numpy optional build dependency
- fix building of mpi python3 plugin
* Thu Apr 20 2017 adam.majer@suse.de
- New upstream version 1.64.0
  + process - new library providing cross platform methods to
  - create child processes
  - setup stream for child processes
  - sync and async communication streams with children
  - sync and async wait
  - process termination
  + geometry library had some breaking changes,
  - ublas_transformer is renamed to matrix_transformer
  - explicit modifier is added to constructors of rtree
    index::dynamic_* parameters
  - strategy::area::huiller replaced by strategy::area::spherical
  + context library updates
  - deprecated API:execution-context
  - fixed bad assembly for fcontext on ppc64/sysv/elf
  + Updated libraries: any, atomic, config, container, context,
    conversion, core, coroutine2, fiber, hash, interprocess,
    intrusive, lexicalcast, math, multi-index containers,
    multiprecision, predef, program options, regex, smart pointers,
    test ,typeindex, typetraits, unordered, variant
  + for details, see
    http://www.boost.org/users/history/version_1_64_0.html
- Build PyNumpy module
  + add build requires on python-numpy
- test_lowcase.patch: upstreamed
- refreshed patches: boost-strict_aliasing.patch, gcc_path.patch,
  python_mpi.patch
- mpi_upstream.patch: pending upstream fixes to OpenMPI build
- python_library_name.patch: we are building python versions in
  different stagings so drop library renames.
- python_numpy_retfunc.patch: rpmlint fixes
* Fri Feb 10 2017 jmatejek@suse.com
- update python macros
* Fri Feb  3 2017 adam.majer@suse.de
- baselibs.conf: (re)add python 2.7 and 3.x libraries
* Wed Jan 25 2017 adam.majer@suse.de
- Fix dependency typos.
* Tue Jan 17 2017 adam.majer@suse.de
- test_lowcase.patch: downcase Boost::Test usage of uppercase
  variables. VERSION was clashing with GNU Autotools define
  resulting in compilation errors of various packages.
- recombine headers from various devel subpackages under the
  libboost_headers-devel package. Not all usage of headers that
  have compiled parts pull in their associated compiled symbols.
- general cleanup of the spec file from old, commented stuffs
* Sun Jan 15 2017 adam.majer@suse.de
- remove non-existent dependency in the boost mpi python package
* Wed Jan  4 2017 adam.majer@suse.de
- update to version 1.63.0
  * updated libraries: atomic, container, context, fiber,
    fusion, geometry, hash, interprocess, intrusive, lexical cast,
    log, metaparse, move, optional, phoenix, python, test,
    typeindex, units, unordered
  * see http://www.boost.org/users/history/version_1_63_0.html
    for complete list of changes
- refresh patches
  * boost-1.55.0-python-test-PyImport_AppendInittab.patch
  * boost-strict_aliasing.patch, and enable -fno-strict-aliasing
    for python module
- baselibs.conf:
  * add libboost_locale
  * rename python to include new soname
- remove python-2059618.patch, not needed
- make build condition --without buil_mpi work
- allow building without python3 bindings, for SLE11SP4
- remove versioned build dependency on libicu-devel, apparently
  not needed.
- split out the boost-devel package into individudal compiled
  libraries and their -devel subpackages and libboost_headers-devel
  package for header-only libraries.
- remove all the -mt.so symlinks, probably not needed anymore.
- ship MPI python bindings for both Python 2.7 and 3.x
  * add python_mpi.patch to allow proper compiled library loading
- dynamic_linking.patch: first attempt to remove static library
  generation during build process.
* Tue Nov  8 2016 adam.majer@suse.de
- Revert upstream change that set default python version and
  ignored user configuration.
  python-2059618.patch (boo#1006584)
* Thu Nov  3 2016 jengelh@inai.de
- Rectify groups and description
* Fri Sep 30 2016 adam.majer@suse.de
- package boost-jam
- add missing ldconfig for libboost_type_erasure
- fix EOL encoding for documentation files
* Thu Sep 29 2016 adam.majer@suse.de
- update to version 1.62.0
  * new library: fiber: framework for userland-threads/fibers
  * new library: QVM: library for working with quaternions,
    vectors and matrices of static size
  * see http://www.boost.org/users/history/version_1_62_0.html
    for complete changelog
- remove boost-fix_include_config.patch - upstreamed
- gcc_path.patch - fix GCC search paths (bnc#996917)
  Boost assumes /usr/include/c++/x.y.z/ existence for GCC 4.x
  onward while our version of GCC only has /usr/include/c++/x.y
  for 4.x GCC and /usr/include/c++/x/ for 5.x onward.
- migrate to using %%bcond_ instead of hardcoding macros
  for different Boost features
- better way to limit max number of compilation units than
  by reading /proc/meminfo and guesstimating.
* Thu Aug 18 2016 mvetter@suse.com
- Fix boo#994378, boo#994381, boo#994382 boo#994383:
  Fix build issues when optional_fwd.hpp is used before
  including boost/config.hpp
- Add boost-fix_include_config.patch from
  gh#boostorg/optional#19
* Fri Aug 12 2016 adrian@suse.de
- build it from "boost.spec", but create versioned "boost-1_61-devel"
  packages
* Fri Jun 17 2016 adrian@suse.de
- build quickbook also in versioned package
* Tue Jun 14 2016 adrian@suse.de
- update to version 1.61.0
  Details on http://www.boost.org/users/history/version_1_61_0.html
  Obsolete patches:
  * boost-1.59-test-fenv.patch
  * boost-deprecated-type_traits.patch
* Tue Jun 14 2016 adrian@suse.de
- rename package to boost-1_60 to allow multiple versions
* Tue Mar 29 2016 dmitry_r@opensuse.org
- Fix build on systems with GCC4
* Sun Feb 14 2016 egeorget@openmailbox.org
- Added libboost_python3 to the dependency macro.
  * boost-devel will now correctly requires libboost_python3.
* Mon Jan 18 2016 idonmez@suse.com
- Add boost-deprecated-type_traits.patch to fix deprecated
  type_traits usage in boost/graph/adjacency_matrix.hpp header.
* Mon Jan  4 2016 idonmez@suse.com
- Add the following patches from Fedora to fix underlinking in
  boost::python code
  * boost-1.57.0-python-abi_letters.patch
  * boost-1.57.0-python-libpython_dep.patch
  * boost-1.55.0-python-test-PyImport_AppendInittab.patch
* Wed Dec 23 2015 fstrba@suse.com
- Updated to version 1.60.0
  * New library: VMD.
  * Updated libraries: Atomic, Chrono, Container, Context, Core,
    Filesystem, Flyweight, Fusion, Interprocess, Intrusive, Lexical
    Cast, Locale, log, Move, Multi-index Containers, odeint,
    Optional, Predef, Test, Thread, UUID
  * See http://www.boost.org/users/history/version_1_60_0.html for
    complete changelog.
- Modified patch:
  * boost-disable-pch-on-aarch64.patch
  - rediff to a new context
- Removed patch:
  * boost-1.59-python-make_setter.patch
  - integrated upstream
- Add libboost_type_erasure subpackage
* Sun Dec 13 2015 egeorget@openmailbox.org
- Add support to Boost:Python3 (boo#951902)
  * New library: python3
* Tue Dec  8 2015 pth@suse.de
- Add boost-visibility.patch to make members of basic_xml_grammar<char>
  visible (boo#958150).
- Fix redefinition of _docdir.
* Thu Nov 26 2015 schwab@suse.de
- coroutine2 depends on context, disable it if context is not built
* Fri Oct 23 2015 idonmez@suse.com
- Updated to version 1.59.0:
  * New libraries: Convert, Coroutine2
  * Updated Libraries: Container, Context, Coroutine, Fusion,
    Geometry, Interprocess, Intrusive, Lexical Cast, Log, Move,
    Multi-index Containers, Predef, Program Options, Property Tree,
    Boost.Test v3, TypeIndex, Variant
  * See http://www.boost.org/users/history/version_1_59_0.html for
    complete changelog.
- context now builds on aarch64
- Import two patches from Fedora: boost-1.59-python-make_setter.patch,
  boost-1.59-test-fenv.patch
- Drop 0001-Fix-exec_file-for-Python-3-3.4.patch,
  0002-Fix-a-regression-with-non-constexpr-types.patch,
  boost-uuid-comparison.patch, boost-unrecognized-option.patch.
  Fixed upstream.
* Thu Jun 11 2015 idonmez@suse.com
- Remove unneeded dependency on xorg-x11-devel
* Thu May 21 2015 schwab@suse.de
- boost-unrecognized-option.patch: remove unrecognized option -m32
* Sat May  9 2015 dmueller@suse.com
- update to 1.58.0:
  boost docs remain at 1.56 since upstream hasn't updated yet
  * New Libraries: Endian, Sort.
  * Updated Libraries: Asio, Chrono, Container, Context, Conversion,
  DateTime, Flyweight, Function, Functional/Factory, Fusion, Geometry,
  Hash, Interprocess, Intrusive, Lexical Cast, Log, Math, Move,
  Multi-index Containers, Multiprecision, Optional, Phoenix,
  Predef, Random, Thread, TypeErasure, TypeIndex, Units,
  Unordered, Variant.
  See http://www.boost.org/users/history/version_1_58_0.html
- add 0001-Fix-exec_file-for-Python-3-3.4.patch ,
  0002-Fix-a-regression-with-non-constexpr-types.patch: Fixes regressions
  in 1.58
- drop bjam-alignment.patch, boost-gcc5.patch: Already fixed upstream
  differently
- add boost-rpmoptflags-only.patch: Build only with optflags
- add boost-aarch64-flags.patch: Avoid using -m64
- add boost-uuid-comparison.patch: Fix regression in UUID operator<
- add boost-disable-pch-on-aarch64.patch: Disable pch on math library
  to avoid compiler segfault
* Mon Mar  9 2015 rneuhauser@suse.cz
- Add quickbook subpackage
* Mon Feb 23 2015 rguenther@suse.com
- Use $RPM_OPT_FLAGS for building, force use of the GCC toolset.
  Be more verbose and fail building with the first error.
- Add boost-gcc5.patch to use -std=c++11 when building the coroutines
  module which fixes build with GCC 5.
* Fri Dec  5 2014 dimstar@opensuse.org
- Revert the python3 building: it resulted in BOTH libboost_python
  libraries to be using python 3 instructions, resulting in
  failures of all Py2 related packages.
* Thu Oct  2 2014 michael.hamann@kit.edu
- Added boost_python3 for boost 1.56.0, config based on
  https://projects.archlinux.org/svntogit/packages.git/tree/trunk/PKGBUILD?h=packages/boost
* Sat Sep 27 2014 dmitry_r@opensuse.org
- Update documentation tarball (source was changed)
- Fix aarch64 build
* Thu Aug 14 2014 dmitry_r@opensuse.org
- Update to version 1.56.0. Major changes since 1.54.0:
  New libraries:
  * Predef: This library defines a set of compiler, architecture,
    operating system, library, and other version numbers from the
    information it can gather of C, C++, Objective C, and Objective
    C++ predefined macros or those defined in generally available
    headers, from Rene Rivera.
  * Align: Memory alignment functions, allocators, and adaptors.
  * Type_Index: Runtime/Compile time copyable type info.
  For a detailed descriptions see:
  http://www.boost.org/users/history/version_1_56_0.html
  http://www.boost.org/users/history/version_1_55_0.html
- Rebase boost-thread.patch
- Rabase boost-use_std_xml_catalog.patch
- Rebase bjam-alignment.patch
- Remove obsolete boost-glibc-2.18.patch
- Remove obsolete boost-1.54-001-coroutine.patch
- Remove obsolete boost-1.54-002-date-time.patch
- Remove obsolete boost-1.54-003-log.patch
- Remove obsolete boost-1.54-change85160.patch
- Remove obsolete boost-1.54.0-thread-link_atomic.patch
- Remove obsolete boost-ppc64-abiv2-context.patch
- Remove obsolete boost-ppc64-abiv2-coroutine.patch
- Remove outdated man pages boost_1_54_man.tar.bz2
* Wed Jul 30 2014 coolo@suse.com
- add baselibs.conf as source
* Tue Jul 22 2014 fcrozat@suse.com
- Ensure there is enough disk space available for build.
* Tue Jul 22 2014 fcrozat@suse.com
- use only JOBS=2 to avoid gcc being killed with OOM when memory is
  between 4G and 7G.
* Tue Apr 29 2014 dvaleev@suse.com
- ppc64 ABIv2 support
- enable build_context for ppc64le
- added patches:
  * boost-ppc64-abiv2-context.patch
  * boost-ppc64-abiv2-coroutine.patch
* Sat Apr 19 2014 schwab@suse.de
- Fix quoting while creating shared build instructions
- Properly configure library list
- bjam-alignment.patch: fix alignment check in bjam
* Tue Apr  1 2014 coolo@suse.com
- buildignore python, python-base is enough
* Tue Mar 11 2014 Rene.vanPaassen@gmail.com
- further improved the use of supplied b2 / bootstrap.sh,
  include user-config.jam, and remove superfluous python
  and gcc instructions from user-config.jam
* Mon Mar 10 2014 Rene.vanPaassen@gmail.com
- fix problem with executable .pdf in doc by correcting
  permissions after install (%%attr with a dir failed on
  sled/sles)
- add dependency on zlib-devel and libbz2-devel and use the
  supplied bootstrap.sh script in building. This adds
  on-the-fly compression to boost-iostreams
* Thu Feb 27 2014 coolo@suse.com
- remove broken python module mpi.so
- trying to make the build more reliable:
  * use -fno-var-tracking in cxxflags as recommended by richi
  * disable parallel build on low memory
* Sat Feb  8 2014 pth@suse.de
- Add post and postun sections for libboost_graph_parallel.
* Fri Feb  7 2014 ro@suse.de
- add boost-1.54.0-thread-link_atomic.patch fixing upstream issue
  https://svn.boost.org/trac/boost/ticket/9041
  (fixes compilation failure of snapper on various platforms)
* Wed Feb  5 2014 ro@suse.de
- enable build_mpi on s390/s390x
* Tue Jan  7 2014 schwab@suse.de
- Disable coroutine library together with context
* Sat Jan  4 2014 coolo@suse.com
- fix build of libzypp - patch from boost's track
- added patches:
  * boost-1.54-change85160.patch
* Tue Nov 26 2013 tbehrens@suse.com
- Add boost-pool_check_overflow.patch: Prevent possible overflow when
  calculating the amount to malloc (bnc#765443).
  Fix from https://svn.boost.org/trac/boost/ticket/6701
* Sun Oct 20 2013 jengelh@inai.de
- Split libboost_graph so that the MPI components are not forced
* Wed Sep 18 2013 dap.darkness@gmail.com
- Update to 1.54.0. Major changes since 1.53.0:
  New libraries:
  * Log: Logging library, from Andrey Semashev.
  * TTI: Type Traits Introspection library, from Edward Diener.
  * Type Erasure: Runtime polymorphism based on concepts.
  For a detailed descriptions see
  http://www.boost.org/users/history/version_1_54_0.html
- Update broken patch:
  * boost-use_std_xml_catalog.patch
- Delete merged patch:
  * boost-fix_ppc64_asm.patch
- Add post-release fix patches:
  * boost-1.54-001-coroutine.patch
  * boost-1.54-002-date-time.patch
  * boost-1.54-003-log.patch
- build_pdf define was deleted as unused;
  package_pdf was refactored.
- _constraints was added to request more memory to build.
* Sun Aug 18 2013 tchvatal@suse.com
- Fix build with updated glibc:
  * boost-glibc-2.18.patch - taken from upstream scm
* Sat Jun  8 2013 schwab@suse.de
- Build context library only on supported architectures
- Reenable mpi on aarch64
- Avoid duplication between %%build and %%install
* Wed Apr  3 2013 pth@suse.de
- Apply upstream patch that fixes the ppc64 code in boost::context
  (boost#8374): boost-fix_ppc64_asm.patch
* Fri Mar 22 2013 idonmez@suse.com
- Rename manpages to avoid conflict with other packages
* Thu Mar 21 2013 mmeister@suse.com
- Added url as source.
  Please see http://en.opensuse.org/SourceUrls
* Sat Mar 16 2013 dap.darkness@gmail.com
- Update to 1.53.0. Major changes since 1.49.0:
  New libraries:
  * Algorithm:  A collection of useful generic algorithms.
  * Context:  Context switching library.
  * Functional/OverloadedFunction: Overload different functions.
  * LocalFunction: Program functions locally, within other functions.
  * Utility/IdentityType: Wrap types within round parenthesis.
  For a detailed descriptions see
  http://www.boost.org/users/history/version_1_50_0.html
  http://www.boost.org/users/history/version_1_51_0.html
  http://www.boost.org/users/history/version_1_52_0.html
- Delete unneeded patches:
  * boost-chrono_add_function_return.patch
  * boost-fix_documentation.patch
  * boost-time_utc.patch
* Wed Feb 27 2013 dmueller@suse.com
- build without openmpi on aarch64 for now
* Wed Jan 23 2013 BSipos@rkf-eng.com
- Require package for ICU having same minimum version that the build requires.
- Avoid obsoleting older versions of boost documentation to allow multiple boost package versions in same environment.
* Thu Jan 17 2013 opensuse@dstoecker.de
- use bzip2 instead of xz to support older SUSE releases
* Thu Sep  6 2012 cfarrell@suse.com
- license update: BSL-1.0
  Boost Software License 1.0 is available in SPDX format on
  http://www.spdx.org/licenses as BSL-1.0
* Thu Aug  2 2012 aj@suse.de
- Add patch from upstream to use TIME_UTC_ instead of TIME_UTC since
  the later is part of ISO C11.
* Fri May 18 2012 aj@suse.de
- Fix timer post script, it used the comment as content.
* Fri May 11 2012 coolo@suse.com
- fixing the previous fix
* Wed May  9 2012 coolo@suse.com
- fixing baselibs.conf after version bump
* Sat Mar 17 2012 jengelh@medozas.de
- Adjust Require for new libxslt-tools
* Tue Mar 13 2012 pth@suse.de
- Update to 1.49.0. Major changes since 1.46.1:
  New libraries:
  * Heap.
  * Container
  * Locale
  * Move
  * Chrono
  * Geometry
  * Phoenix
  * Ratio
  For a detailed descriptions see
  http://www.boost.org/users/history/version_1_47_0.html
  http://www.boost.org/users/history/version_1_48_0.html
  http://www.boost.org/users/history/version_1_49_0.html
- Rebuilt the man documentation with gcc 4.5 as the current gcc
  segfaults when building quickbook.
- Package PDF documentation independent of whether we build it
  ourselves.
- Fix missing function return in Boost::Chrono's process_cpu_clocks.hpp
* Mon Feb 13 2012 coolo@suse.com
- patch license to follow spdx.org standard
* Tue Dec  6 2011 aj@suse.de
- Do not package NEWS and LICENSE twice.
* Fri Nov 25 2011 jengelh@medozas.de
- Remove redundant/unwanted tags/section (cf. specfile guidelines)
* Thu Nov 24 2011 nadvornik@suse.com
- dropped visit_each patch (bnc#714373)
* Mon Oct  3 2011 dmueller@suse.de
- disable openmpi on %%%%arm
* Tue Apr 19 2011 ro@suse.de
- update baselibs.conf
* Mon Mar 21 2011 idoenmez@novell.com
- Fix attribute handling problem in spirit library,
  See http://comments.gmane.org/gmane.comp.parsers.spirit.general/22073
* Mon Mar 21 2011 pth@suse.de
- Prefix bug numbers.
* Fri Mar 18 2011 pth@suse.de
- Make packaging of the pdf documentation configurable.
* Fri Mar 18 2011 pth@suse.de
- Update to 1.46.1, a bugfix release:
  • Asio:
  - EV_ONESHOT seems to cause problems on some versions of Mac OS X, with
    the io_service destructor getting stuck inside the close() system call.
    Changed the kqueue backend to use EV_CLEAR instead (boost#5021).
  - Fixed compile failures with some versions of g++ due to the use of
    anonymous enums (boost#4883).
  - Fixed a bug on kqueue-based platforms, where some system calls that
    repeatedly fail with EWOULDBLOCK are not correctly re-registered with
    kqueue.
  - Changed asio::streambuf to ensure that its internal pointers are
    updated correctly after the data has been modified using std::streambuf
    member functions.
  - Fixed a bug that prevented the linger socket option from working on
    platforms other than Windows.
  For the rest see NEWS or the boost web site http://www.boost.org
* Wed Mar 16 2011 pth@suse.de
- Remove comment chars from doc-pdf description.
* Mon Mar 14 2011 pth@suse.de
- Use xz to compress tarballs.
- Generate new man pages tarball.
- Update pdf tarball.
- Update to 1.46:
  New Libraries
    Icl: Interval Container Library, interval sets and maps and
    aggregation of associated values, from Joachim Faulhaber.
  For the rest of the changes see NEWS in the package documentation
  directory or see http://www.boost.org/users/news/version_1_46_0 .
* Thu Nov 25 2010 pth@suse.de
- Remove the boost specific autoconf macros now that we have the
  complete autoconf archive packaged (bnc#655747).
- Move the lib64 patch over to autoconf-archive.
* Mon Oct 25 2010 jslaby@novell.com
- take care of random library (build 32bit on x86_64 and
  require it in boost-devel)
* Wed Sep 29 2010 coolo@novell.com
- fix baselibs.conf
* Fri Sep  3 2010 pth@suse.de
- Shorten the list of update items.
- Fix typo in spec.
* Thu Aug 26 2010 pth@suse.de
- Redo the lib64 patch for the boost autoconf macros so that
  lib64 is used on all archs that need it.
- Remove the ICU patch.
* Thu Aug 26 2010 pth@suse.de
- Update to 1.44.0:
  New Libraries:
  * Meta State Machine: High-performance expressive UML2 finite
    state machines
  * Polygon: Booleans/clipping, resizing/offsetting and more for
    planar polygons with integral coordinates
  Updated Libraries:
  * Accumulators:
  * Asio:
  * Foreach:
  * Fusion:
  * Hash:
  * Math:
  * MPL:
  * Multi-index Containers:
  * Proto:
  * Regex:
  * Thread:
  * Type Traits:
  * uBLAS:
  * Utility:
  * Uuid:
  * Config:
  * Xpressive:
  * Filesystem:
    o This release contains both version 2 and version 3 of the
    library.  Version 3 is a major upgrade that will break some
    existing user code, so version 2 is the default.  Users are
    encouraged to migrate to version 3.  See 'Version 2' and
    'Version 3' for more information.
  * Iostreams:
    o Several fixes for file descriptors class, including a
    breaking change to the constructors and open methods for
    file_descriptor, file_descriptor_source and
    file_descriptor_sink.  See the documentation for details.
    The old methods are still available if you define
    BOOST_IOSTREAMS_USE_DEPRECATED
  * Spirit: Spirit V2.4, see the 'What's New' section for details.
  * System:
    o Change system_category and generic_category to functions, to
    conform to the C++0x FCD.  This change may cause compile
    errors some user code; the fix is add "()" to references to
    system_category and generic_category, so that they become
    function calls.
  * Wave: See the Changelog for details.
  Major Changes in 1.43.0:
  New Libraries
  * Functional/factory: Function objects for dynamic and by-value
    construction
  * Functional/forward: Function object adapters to address the
    forwarding problem
  For a complete list of changes see
  http://www.boost.org/users/news/version_1_43_0 and
  http://www.boost.org/users/news/version_1_44_0.
* Fri Jul  9 2010 pth@suse.de
- Rename patch to be identical to the one checked in for 11.3.
  The patch adds an explicite specialization to the call to prevent
  unwanted temporary instantiations.
* Fri Jul  9 2010 lnussel@suse.de
- fix bug that shows with gcc 4.5 (bnc#621140)
* Wed Jun 16 2010 pth@suse.de
- Noarch sub packages only doable from 11.2 on up.
* Thu Jun 10 2010 wittemar@googlemail.com
- build 32bit-packages
* Mon May 24 2010 bg@novell.com
- disable long double support for hppa
* Thu May 20 2010 bg@novell.com
- openmpi does not build on hppa
* Thu Apr 29 2010 pth@novell.com
- Move provides/obsoletes for boost-license to the right section
  (bnc#544958).
* Mon Apr 26 2010 pth@novell.com
- Delete unneeded patches.
* Wed Apr 14 2010 pth@suse.de
- Readd those patches that are still needed.
- Try to fix an aliasing bug in function_base.hpp
- Build man pages locally and only include them as a tarball.
- Split documentation in in format specific packages.
* Sat Apr  3 2010 freespacer@gmx.de
- update to 1.42.0:
  New Libraries
  * Uuid: A universally unique identifier, from Andy Tompkins.
  Updated Libraries (see README for details)
  * Asio:
  * Circular Buffer:
  * Fusion:
  * Graph:
  * Integer:
  * Iostreams:
  * Program.Options:
  * PropertyMap:
  * Proto:
  * Regex:
  * Spirit:
  * Unordered:
  * Xpressive:
- update to 1.41.0:
  New Libraries
  * Property Tree: A tree data structure especially suited to storing
    configuration data, from Marcin Kalicinski and Sebastian Redl.
  Updated Libraries (see README for details)
  * DateTime:
  * Filesystem:
  * Iostreams:
  * Math:
  * Multi-index Containers:
  * Proto:
  * Regex:
  * Spirit:
  * System:
  * Thread:
  * Unordered:
  * Utility:
  * Wave:
  * Xpressive:
- update to 1.40.0:
  Updated Libraries (see README for details)
  * Accumulators:
  * Asio:
  * Circular Buffer:
  * Foreach:
  * Function:
  * Fusion:
  * Graph:
  * Hash:
  * Interprocess:
  * Intrusive:
  * MPL:
  * Program.Options:
  * Property Map:
  * Proto:
  * Random:
  * Serialization:
  * Unordered:
  * Xpressive:
- removed patches no longer needed
* Wed Jan  6 2010 jengelh@medozas.de
- documentation change needed to be done in boost.spec.in
  (not boost.spec)
- openmpi change was missing too; add it now
* Tue Dec 15 2009 jengelh@medozas.de
- add baselibs for SPARC
- add baselibs.conf as a source
- deactivate use of openmpi on SPARC, as compat-dapl is not
  available
- package documentation as noarch
* Mon Oct 19 2009 pth@suse.de
- Provide/Obsolete boost-license (bnc#544958)
* Thu Aug  6 2009 pth@suse.de
- Add a fix from boost bugtracker that fixes the hash resizing
  (boost#54376)
- Add a test for cancelling deadline timers from the same changeset.
* Tue Aug  4 2009 pth@suse.de
- Readd the patch to fix the misplaced ifdef in
  template_function.hpp:move_assign.
* Tue Jul 28 2009 coolo@novell.com
- update to 1.39.0:
  New Libraries
  * Signals2: Managed signals & slots callback implementation (thread-safe version 2),
    from Frank Mori Hess.
  Updated Libraries (see README for details)
  * Asio:
  * Flyweight:
  * Foreach:
  * Hash:
  * Interprocess:
  * Intrusive:
  * Program.Options:
  * Proto:
  * PtrContainer:
  * Range:
  * Unordered:
  * Xpressive:
- removed patches no longer needed (hoping the best for ppc asm)
* Thu Apr 16 2009 crrodriguez@suse.de
- as agreed with maintainer, get rid of static libraries
* Thu Apr 16 2009 ro@suse.de
- buildfix: fix typo in specfile
* Mon Mar 16 2009 pth@suse.de
- Don't rely on system default mpi implementation being set. This
  fixes building boost on systems before openSUSE 11.0.
* Tue Mar  3 2009 pth@suse.de
- Fix misplaced ifdef in template_function.hpp:move_assign. Fixes
  building software that defines BOOST_NO_EXCEPTION (bnc#479659).
* Wed Feb 25 2009 pth@suse.de
- Fix packaging of the documentation.
* Sun Feb 22 2009 pth@suse.de
- Fix the line in the spec that copies the documentation.
* Fri Feb 20 2009 pth@suse.de
- Put the license in a versioned package. This allows installing
  libraries in parallel (bnc#477603).
* Fri Feb 13 2009 pth@suse.de
- Fix spec file (remove patches).
* Wed Feb 11 2009 pth@suse.de
- Add boost autoconf macros from the autoconf archive to the
  - devel package.
- Update to 1.38.0:
  New Libraries
  * Flyweight:
    o Design pattern to manage large quantities of highly redundant
    objects, from Joaquín M López Muñoz.
  * ScopeExit:
    o Execute arbitrary code at scope exit, from Alexander Nasonov.
  * Swap:
    o Enhanced generic swap function, from Joseph Gauterin.
  Updated Libraries
  * Accumulators:
    o Add rolling_sum, rolling_count and rolling_mean accumulators.
  * Any:
    o Use a by-value argument for operator= (#2311).
  * Asio:
    o Improved compatibility with some Windows firewall software.
    o Ensured arguments to windows::overlapped_ptr::complete() are
    correctly passed to the completion handler (#2614).
    o Drop back to using a pipe for notification if eventfd is not
    available at runtime on Linux (#2683).
    o Various minor bug and documentation fixes (#2534, #2541,
    [#2607], #2617, #2619)
  * Config:
    o Add new macros BOOST_NO_STD_UNORDERED and
    BOOST_NO_INITIALIZER_LISTS.
    o Added Codegear compiler support.
    o Added Dragonfly to the BSD family of configs.
    o Recognise latest compilers from MS and Intel.
  * Date_Time:
    o Added support for formatting and reading time durations longer
    than 24 hours with new formatter: %%0.
    o Removed the testfrmwk.hpp file from the public include directory.
    o Fixed several bugs and compile errors.
    o For full details see the change history
  * Exception:
    o Improved and more customizable diagnostic_information output.
  * Filesystem:
    o Fix native(name) test failures on POSIX-like systems.
    o Several bugfixes (#2543, #2224, #2531, #1840, #2542).
  * Graph:
    o Added a new algorithms for Travelling Salesman Problem
    approximation (metric_tsp_approx) and resource-constrained
    Shortest Paths (r_c_shortest_paths).
    o Support for named vertices in adjacency_list.
    o A number of bugfixes ( #416, #1622, #1700, #2209, #2392,
    [#2460], and #2550)
  * Hash:
    o boost/functional/detail/container_fwd.hpp has been moved to
    boost/detail/container_fwd.hpp.  The current location is
    deprecated.
    o For more detail, see the library changelog.
  * Interprocess:
    o Updated documentation to show rvalue-references functions
    instead of emulation functions.
    o More non-copyable classes are now movable.
    o Move-constructor and assignments now leave moved object in
    default-constructed state instead of just swapping contents.
    o Several bugfixes (#2391, #2431, #1390, #2570, #2528).
  * Intrusive:
    o New treap-based containers: treap, treap_set, treap_multiset.
    o Corrected compilation bug for Windows-based 64 bit compilers.
    o Corrected exception-safety bugs in container constructors.
    o Updated documentation to show rvalue-references functions
    instead of emulation functions.
  * Lexical Cast:
    o Changed to work without RTTI when BOOST_NO_TYPEID is defined
    (#1220).
  * Math:
    o Added Johan Råde's optimised floating point classification routines.
    o Fixed code so that it compiles in GCC's -pedantic mode (bug report #1451).
  * Multi-index Containers:
    o Some redundant type definitions have been deprecated. Consult the
    library release notes for further information.
  * Proto:
    o Fix problem with SFINAE of binary operators (Bug 2407).
    o Fix proto::call transform for callable transforms with >3 arguments.
    o result_of::value changed behavior for array-by-value terminals.
    o unpack_expr requires only Forward Sequences rather than Random Access
    Sequences.
    o Deprecate legacy undocumented BOOST_PROTO_DEFINE_(VARARG_)FUNCTION_TEMPLATE
    macros.
    o Add BOOST_PROTO_REPEAT and BOOST_PROTO_LOCAL_ITERATE macros to help with
    repetitive code generation
    o Support for nullary expressions with tag types other than
    proto::tag::terminal
    o Allow 0- and 1-argument variants of proto::or_ and proto::and_
  * Regex:
    o Breaking change: empty expressions, and empty alternatives are
    now allowed when using the Perl regular expression syntax.
    This change has been added for Perl compatibility, when the
    new syntax_option_type no_empty_expressions is set then the
    old behaviour is preserved and empty expressions are
    prohibited.  This is issue #1081.
    o Added support for Perl style ${n} expressions in format strings
    (issue #2556).
    o Added support for accessing the location of sub-expressions
    within the regular expression string (issue #2269).
    o Fixed compiler compatibility issues #2244, #2514, and #2458.
  * Thread:
    o No longer catches unhandled exceptions in threads as this debuggers
    couldn't identify the cause of unhandled exceptions in threads. An
    unhandled exception will still cause the application to terminate.
  * TR1:
    o Added support for the TR1 math functions and the unordered
    containers.
  * Type Traits:
    o Added support for Codegear intrinsics.
    o Minor tweaks to warning suppression and alignment_of code.
  * Unordered:
    o Use boost::swap.
    o Use a larger prime number list for selecting the number of buckets.
    o Use aligned storage to store the types.
    o Add support for C++0x initializer lists where they're available.
    o For more detail, see the library changelog.
  * Xpressive:
    o basic_regex gets nested syntax_option_flags and value_type typedef,
    for compatibility with std::basic_regex
    o Ported to Proto v4; Proto v2 at boost/xpressive/proto has been
    removed.
    o regex_error inherits from boost::exception
  Other Changes
  * Experimental support for building Boost with CMake has been introduced in
    this version. For more details see the wiki, Discussion is taking place
    on the Boost-cmake mailing list.
  * Fixed subversion properties for several files. Most notably, unix shell
    scripts should always have unix line endings, even in the windows
    packages.
* Fri Jan  9 2009 pth@suse.de
- Apply patch in boost.spec.in
* Thu Jan  8 2009 pth@suse.de
- Actually use the patch.
* Wed Jan  7 2009 pth@suse.de
- Initialize all data passed in the syscall to keep valgrind
  happy (bnc#461372).
* Thu Dec 11 2008 ro@suse.de
- fix baselibs.conf (no requirement for boost-xxbit)
  (bnc#457699)
* Thu Nov 27 2008 ro@suse.de
- update baselibs.conf
- package mpi.so only in mpi package, not in devel
* Wed Nov 19 2008 jjolly@suse.de
- Made the use of the mpi-selector conditional for mpi-enabled
  platforms.
* Tue Nov 11 2008 ro@suse.de
- SLE-11 uses PPC64 instead of PPC, adapt baselibs.conf
* Fri Oct 31 2008 pth@suse.de
- Fix the bug that made boost.monitor mix up uid and pib and
  also make boost.monitor not special-case SIGCLD (bnc#439805)
- Fix generation of default extension in boost.filesystem.
- Make boost recommend library subpackages instead of requiring
  them to allow removal of unwanted libraries after update.
- Run mkspec explicitely in a shell so that mkspec.sh doesn't
  need to be executable.
- Disable deletion of full-name symlinks in boost.spec.in.
- Make boost-devel directly require all library subpackages.
- boost.rpm isn't needed, even for updates, so don't build it and
  remove the README file needeed only for this package.
- Make debug package require all library subpackages.
- Add pre_checkin.sh to ensure that boost.spec is regenerated
  at check-in time.
- Make boost.build use sane library names. Only the multi-threaded
  libraries are built and these have no -mt in their name.
  Symlinks for convenience are spupplied.
- Use -fno-strict-aliasing only for boost.python, where it's needed.
- Don't use configure and make (only convenience wrappers) but
  call bjam directly.
* Mon Oct 27 2008 ro@suse.de
- do not remove full-name symlinks for shared libs
* Thu Oct 23 2008 pth@suse.de
- Use a script and a Makefile to generate boost.spec.
- Pull in all libraries on update.
- Modify README to apply to both openSUSE and SLE.
* Thu Oct 23 2008 ro@suse.de
- fix regexp for short symlinks
- hook all mpi related parts to build_mpi macro
- disable build_mpi on ia64 s390 s390x for the moment
* Fri Oct 17 2008 pth@suse.de
- Using a rpm macros in package name doesn't work with autobuild.
* Wed Oct 15 2008 pth@suse.de
- Fix naming of library packages to match the horribly broken
  sonames of the boost libraries.
- Add post/postun for all library packages.
- Stop rpmlint warning about explicit library dependencies
  needed to pull in all library subpackages during updates.
* Tue Oct 14 2008 pth@suse.de
- Fix build failure (README not in build directory).
* Tue Sep  2 2008 pth@suse.de
- Split off runtime libraries into their own packages.
- Update to 1.36.0:
  New Libraries
  * Accumulators: Framework for incremental calculation, and
    collection of statistical accumulators.
  * Exception: A library for transporting of arbitrary data in
    exception objects, and transporting of exceptions
    between threads.
  * Units: Zero-overhead dimensional analysis and unit/quantity
    manipulation and conversion.
  * Unordered: Unordered associative containers.
  Updated Libraries
  * Asio:
    o Added support for serial ports.
    o Added support for UNIX domain sockets.
    o Added support for raw sockets and ICMP.
    o Added wrappers for POSIX stream-oriented file descriptors
    (excluding regular files).
    o Added support for reactor-style operations using a new
    null_buffers type.
    o Added an iterator type for bytewise traversal of buffer
    sequences.
    o Added new read_until() and async_read_until() overloads that
    take a user-defined function object for locating message
    boundaries.
    o Added an experimental two-lock queue (enabled by defining
    BOOST_ASIO_ENABLE_TWO_LOCK_QUEUE) that may provide better
    io_service scalability across many processors.
    o Various fixes, performance improvements, and more complete
    coverage of the custom memory allocation support.
  * Assign:list_of() (and its variants) now has overloaded comparison
    operators. This allows you to write test code such as
    BOOST_CHECK_EQUAL(my_container,list_of(2)(3)(4)(5));.
  * Foreach:BOOST_FOREACH macro for easily iterating over the elements
    of a sequence.
    o New BOOST_REVERSE_FOREACH macro for iterating over a sequence
    in reverse.
  * Function:
    o Improved allocator support.
  * Hash: Minor updates and fixes, for more info see the change log.
  * Interprocess:
    o Added anonymous shared memory for UNIX systems.
    o Fixed missing move semantics on managed memory classes.
    o Added copy_on_write and open_read_only options for shared
    memory and mapped file managed classes.
    o shared_ptr is movable and supports aliasing.
  * Intrusive:
    o Added linear<> and cache_last<> options to singly linked lists.
    o Added optimize_multikey<> option to unordered container hooks.
    o Optimized unordered containers when store_hash option is used
    in the hook.
    o Implementation changed to avoid explicit use of try-catch
    blocks and be compilable with exceptions disabled.
  * Math:
    o Added new non-central Chi-Square, Beta, F and T distributions.
    o Added Exponential Integral and Zeta special functions.
    o Added Rounding, Truncation, and Unit-in-the-last-place
    functions.
    o Added support for compile time powers of a runtime base.
    o Added a few SSE2 based optimisations for the Lanczos
    approximations.
  * MPI:
    o Added support for non-blocking operations in Python
    o Added support for graph topologies.
  * Multi-index Containers: Minor additions and maintenance fixes.
    Consult the library release notes for
    further information.
  * PtrContainer: Support for a few more containers, and addition
    of insert iterators. For details see upgrading
    details.
  * Spirit: Integrated the "Classic" Spirit V1.8.x code base with
    Spirit V2, "The New Generation". See Change Log.
  * Thread:
    o New generic lock and try_lock functions for locking multiple
    mutexes at once.
    o Rvalue reference support for move semantics where the
    compilers supports it.
    o A few bugs fixed and missing functions added (including
    the serious win32 condition variable bug).
    o scoped_try_lock types are now backwards-compatible with
    Boost 1.34.0 and previous releases.
    o Support for passing function arguments to the thread
    function by supplying additional arguments to the thread
    constructor.
    o Backwards-compatibility overloads added for timed_lock and
    timed_wait functions to allow use of xtime for timeouts.
  * Wave:
    o Wave V2.0 is a new major release introducing some breaking
    API changes, preventing it to be used with Boost versions
    earlier than V1.36.0. Mainly, the API and hook interface
    have been streamlined for more consistency.
    o Fixed a couple of bugs, improved regression test system to
    include testing of the preporcessing hooks interface
    (for details see: Changelog).
  * Xpressive:
    o Regular expressions that can be written as strings or as
    expression templates, and that can refer to each other and
    themselves recursively with the power of context-free
    grammars.
    o skip() for specifying which parts of the input sequence
    to ignore when matching it against a regex.
    o regex_replace() accepts formatter objects and formatter
    expressions in addition to format strings.
    o Range-based regex_replace() algorithm.
    o Fix crash when semantic actions are placed in look-aheads,
    look-behinds or independent sub-expressions.
* Mon Jun 23 2008 pth@suse.de
- Qualify name to avoid clash (bnc#401964)
* Fri Jun 20 2008 schwab@suse.de
- Fix ppc atomic ops.
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Mon Jan 28 2008 schwab@suse.de
- Remove obsolete patch again.
* Fri Jan 18 2008 pth@suse.de
- Fix CVE-2008-0171 and CVE-2008-0171 (bugzilla #353180)
- Qualify special_values_parser (bugzilla #353897)
* Thu Jan 17 2008 schwab@suse.de
- Remove obsolete patch.
* Mon Jan 14 2008 pth@suse.de
- Move 1.34.1 from BS to Autobuild
- Add patch for critical bug in Boost.Function.
- Include C headers where necessary.
- Make the tests for ULONG_MAX more readable 64.
* Wed Oct 24 2007 rguenther@suse.de
- Use -fpermissive in addition to -O2 for building.
- Add patch to enable building wave with GCC 4.3.
* Mon Aug 20 2007 pth@suse.de
- Only use fdupes from 10.3 onwards.
* Sat Aug 11 2007 aj@suse.de
- Fix spec file to build again.
* Thu Aug  9 2007 pth@suse.de
- Add man pages (made for 1.33.1).
- Package html documentation differently.
- Check all links and add missing files that do exist.
- Use %%%%fdupes
- Add patch by rschiele@gmail.com to pass compiler flags into
  Boost.build.
- Update to 1.34.1 and use .spec file from bkoz@redhat.com as
  a basis.
  Changes 1.33.1 -> 1.34.0:
  New Libraries:
  * Foreach Library: BOOST_FOREACH macro for easily iterating over
    the elements of a sequence,
  * Statechart Library: Arbitrarily complex finite state machines
    can be implemented in easily readable and
    maintainable C++ code,
  * TR1 Library: An implementation of the C++ Technical Report on Standard
    Library Extensions, from John Maddock. This library does
    not itself implement the TR1 components, rather it's a
    thin wrapper that will include your standard library's
    TR1 implementation (if it has one), otherwise it will
    include the Boost Library equivalents, and import them
    into namespace std::tr1. Highlights include: Reference
    Wrappers, Smart Pointers, result_of, Function Object
    Binders, Polymorphic function wrappers, Type Traits,
    Random Number Generators and Distributions, Tuples, Fixed
    Size Array, Hash Function Objects, Regular Expressions,
    and Complex Number Additional Algorithms.
  * Typeof Library: Typeof operator emulation, from Arkadiy Vertleyb
    and Peder Holt.
  * Xpressive Library: Regular expressions that can be written as strings
    or as expression templates, and that can refer to
    each other and themselves recursively with the
    power of context-free grammars, from Eric Niebler.
    Updated Libraries:
  * Assign Library:
    o Support for ptr_map<key,T> via the new function ptr_map_insert()
    o Support for initialization of Pointer Containers when the
    containers hold pointers to an abstract base class.
  * Date_time library:
    o Support for new US/Canada timezone rules and other bug fixes.
    See Change History for details.
  * Filesystem Library: Major upgrade in preparation for submission to the
    C++ Standards Committee for TR2. Changes include:
    o Internationalization, provided by class templates basic_path,
    basic_filesystem_error, basic_directory_iterator, and
    basic_directory_entry.
    o Simplification of the path interface by eliminating special
    constructors to identify native formats.
    o Rationalization of predicate function design, including the
    addition of several new functions.
    o Clearer specification by reference to POSIX, the ISO/IEEE Single
    Unix Standard, with provisions for Windows and other operating
    systems.
    o Preservation of existing user code whenever possible.
    o More efficient directory iteration.
    o Addition of a recursive directory iterator.
  * Function Library: Boost.Function now implements a small buffer
    optimization, which can drastically improve the
    performance when copying or constructing
    Boost.Function objects storing small function
    objects. For instance, bind(&X:foo, &x, _1, _2)
    requires no heap allocation when placed into a
    Boost.Function object.
  * Functional/Hash Library
    o Use declarations for standard classes, so that the library
    doesn't need to include all of their headers
    o Deprecated the <boost/functional/hash/*.hpp> headers.
    o Add support for the BOOST_HASH_NO_EXTENSIONS macro, which
    disables the extensions to TR1
    o Minor improvements to the hash functions for floating point numbers.
  * Graph Library:
    o edmonds_maximum_cardinality_matching,
    o lengauer_tarjan_dominator_tree,
    o compressed_sparse_row_graph,
    o sorted_erdos_renyi_iterator,
    o biconnected_components now supports a visitor and named
    parameters,
    o adjacency_matrix now models the Bidirectional Graph concept.
    o dijkstra_shortest_paths now calls vis.initialize_vertex for each
    vertex during initialization.
    o Note: the name of the compiled library for the GraphViz reader has
    changed to boost_graph (from bgl-viz) to match Boost conventions.
    o See the complete revision history for more information.
  * MultiArray Library: Boost.MultiArray now by default provides
    range-checking for operator[]. Range checking can
    be disabled by defining the macro
    BOOST_DISABLE_ASSERTS before including
    multi_array.hpp. A bug in multi_array::resize()
    related to storage orders was fixed.
  * Multi-index Containers Library:
    o New random access indices.
    o Non key-based indices feature new rearrange facilities.
    o This version also includes a number of optimizations and usage
    improvements. For a complete list of changes, see the library
    release notes.
  * Optional Library:
    o boost::none_t and boost::none now added to Optional's
    documentation
    o Relational operators now directly support arguments of type
    'T' and 'none_t'
    o operator->() now also works with reference types.
    o Helper functions make_optional(val), make_optional(cond,val)
    and get_optional_value_or(opt,alternative_value) added.
    o Constructor taking a boolean condition (as well as a value)
    added.
    o Member function get_value_or(alternative_value) added.
    o Incompatbility bug with mpl::apply<> fixed.
    o Converting assignment bug with uninitialized lvalues fixed.
  * Parameter Library:
    o Every ArgumentPack is now a valid MPL Forward Sequence.
    o Support for unnamed arguments (those whose keyword is
    deduced from their types) is added.
    o Support for named and unnamed template arguments is added.
    o New overload generation macros solve the forwarding problem
    directly.
    o See also the Python library changes, below.
  * Pointer Container Library:
    o Support for serialization via Boost.Serialization.
    o Exceptions can be disabled by defining the macro
    BOOST_PTR_CONTAINER_NO_EXCEPTIONS before including any header.
    This macro is defined by default if BOOST_NO_EXCEPTIONS is defined.
    o Additional std::auto_ptr<T> overloads added s.t. one can also
    pass std::auto_ptr<T> instead of only T* arguments to member
    functions.
    o transfer() now has weaker requirements s.t. one can transfer
    objects from ptr_container<Derived> to ptr_container<Base>,
  * Python Library:
    o Boost.Python now automatically appends C++ signatures to
    docstrings. The new docstring_options.hpp header is available to
    control the content of docstrings.
    o stl_input_iterator, for turning a Python iterable object into an
    STL input iterator, from Eric Niebler.
    o Support for void* conversions is added.
    o Integrated support for wrapping C++ functions built with the
    parameter library; keyword names are automatically known to
    docsstrings.
    o Enhancements to the API for better embedding support
    (boost::python::import(), boost::python::exec(), and
    boost::python::exec_file()).
  * Signals Library: More improvements to signal invocation performance.
  * Smart Pointers Library:
    o Allocator support as proposed in N1851 (162 Kb PDF).
    o pointer_cast and pointer_to_other utilities to allow
    pointer-independent code,
  * String Algorithm Library:
    o lexicographical_compare
    o join
    o New comparison predicates is_less, is_not_greater.
    o Negative indexes support (like Perl) in various algorihtms
    (*_head/tail, *_nth).
  * Wave Library:
    o Wave now correctly recognizes pp-number tokens as mandated by
    the C++ Standard, which are converted to C++ tokens right before
    they are returned from the library.
    o Several new preprocessing hooks have been added. For a complete
    description please refer to the related documentation page: The
    Context Policy.
    o Shared library (dll) support has been added for the generated
    Wave libraries.
    o The overall error handling has been improved. It is now possible
    to recover and continue after an error or a warning was issued.
    o Support for optional comment and/or full whitespace
    preservation in the generated output stream has been added.
    o The Wave library now performs automatic include guard
    detection to avoid accessing header files more than once, if
    appropriate.
    o Full interactive mode has been added to the Wave tool. Now the
    Wave tool can be used just like Python or Perl for instance to
    interactively try out your BOOST_PP macros. Additionally it is
    now possible to load and save the current state of an
    interactive session (macro tables et.al.).
    o The overall performance has been improved by upto 40-60%%,
    depending on the concrete files to process.
    o Support for new pragmas has been added allowing to control
    certain library features from inside the preprocessed sources
    (partial output redirection, control of generated whitespace
    and #line directives).
    o Optional support for #pragma message "..." has been added.
    o This version also includes a number of bug fixes and usage
    improvements. For a complete list of changes, see the
    libraries change log.
  Fixes in 1.34.1:
  * Fixes for build on IBM pSeries for AIX and Linux
  * gcc-4.2 atomicity.h location fixed
  * [iostreams] zlib_compressor memory leaks in 1.34.0
  * filtering ostream problem... pushing zlib_compressor works in 1_33,
    dies in 1_34
  * [doc] The "Getting Started" page mentions incorrect library names
  * [filesystem] missing documentation or bad links
  * add missing docs for boost.python API enhancements.
  * Entire iostreams library outdated in 1.34.0
  * numeric_limits specializations in limits.hpp are incorrect
  * Updated ICU support in Boost.Regex
  * Make boost.python compatible with python 2.5
  * ::boost::detail::empty_base improved
  * Fix failing uild of libs/python/example/quickstart.
  * Fix problems when building Python modules on boost 1.34.0
  * Patches to allow boost 1.34.0 to compile with stricter warning
    checking under mac OS and gcc
  * Unable to compile Python example, tutorial, or quickstart with
    Boost 1_34_0
  * Improper overflow handling in shortest paths algorithms
  * Multiple include paths for Python
  * Add documentation for the iter_find/split algorithms
  * regex_token_iterator crashes
  * regex_error exception when quantifying some non-capturing groups
  * read_write_mutex docs don't clearly specify that the functionality
    is not present
- Remove patches not needed anymore.
- Replace file dupes by symlinks.
- Add rpmlintrc to suppress rpmlint warnings for things that won't be
  changed.
* Sun Jul 15 2007 schwab@suse.de
- Fix reference to atomicity.h.
* Sat Mar 24 2007 aj@suse.de
- Add libbz2-devel to BuildRequires.
* Fri Sep 22 2006 pth@suse.de
- Apply patch from community to build with Python 2.5
* Fri Jul 14 2006 sf@suse.de
- fixed wrong usage of visit_each() (Bug #192116 )
* Thu Jul 13 2006 sf@suse.de
- fixed link creation to libboost_thread.so, using %%_lib instead
  of lib
* Mon Jun 19 2006 jw@suse.de
- added a libboost_thread.so as a symlink to libboost_thread-mt.so
* Tue Apr  4 2006 pth@suse.de
- Add libboost_wave.a to file list
* Tue Apr  4 2006 pth@suse.de
- Use explicit file names instead of wildcards to detect libraries
  that weren't built.
* Wed Feb  8 2006 schwab@suse.de
- Fix broken assembler constraints [#148429].
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 18 2006 schwab@suse.de
- Don't strip binaries.
* Wed Dec  7 2005 pth@suse.de
- Fix cases of type-punning in boost::python
- Compile without -fno-strict-aliasing again.
- Remove unnecessary type attributes in forward declarations.
* Tue Dec  6 2005 pth@suse.de
- Update to 1.33.1.
- Fix use of uninitialized variable.
- Compile with -fno-strict-aliasing.
- Update NEWS file
* Thu Aug 25 2005 pth@suse.de
- Incorporate fixes that are bound to be in 1.33.1
- Build boost.regex with unicode support.
* Fri Aug 19 2005 pth@suse.de
- Add a NEWS file.
* Thu Aug 18 2005 pth@suse.de
- Update to 1.33.0 with 5 new libraries. See NEWS for specifics.
- Fix use of uninitialized class member (matz@suse.de)
- Compile with -O2 instead of -O3
- Make build process use %%optflags
* Thu Mar 10 2005 pth@suse.de
- Update to 1.32.0
* Fri May  7 2004 pth@suse.de
- Add convenience symlinks (#38491)
* Sun Apr 25 2004 coolo@suse.de
- build with several jobs
* Fri Mar  5 2004 pth@suse.de
- Update to 1.31.0.
- Make building boost work on Linux platforms where gcc does not
  define _REENTRANT when passed -pthread. Patch was done by
  Robert Schiele.
* Sat Jan 10 2004 adrian@suse.de
- add %%run_ldconfig
* Wed Aug 20 2003 pthomas@suse.de
- Update to 1.30.2, a bugfix release
* Wed Jul 23 2003 pthomas@suse.de
- Initial package, based on the work by Robert Schiele.
- Fix building with Python 2.3
