#
# spec file for package zypper.spec
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


Name:           zypper
Version:        1.14.94
Release:        150600.10.52.1
Source:         %{name}-%{version}.tar.bz2
Source1:        %{name}-rpmlintrc
URL:            https://github.com/openSUSE/zypper
BuildRequires:  augeas-devel >= 1.10.0
%if 0%{?suse_version} > 1325
BuildRequires:  libboost_headers-devel
%else
BuildRequires:  boost-devel >= 1.33.1
%endif
BuildRequires:  cmake >= 3.10
BuildRequires:  gcc-c++ >= 7
BuildRequires:  gettext-devel >= 0.15
BuildRequires:  libzypp-devel >= 17.37.12
BuildRequires:  readline-devel >= 5.1
BuildRequires:  libxml2-devel

# required for documentation
BuildRequires:  rubygem(asciidoctor)

# TUI library which is built and shipped with libzypp-devel
BuildRequires:  libzypp-tui-devel >= 1

Summary:        Command line software manager using libzypp
License:        GPL-2.0-or-later
Group:          System/Packages

Provides:       y2pmsh
Obsoletes:      y2pmsh
Provides:       zypper(auto-agree-with-product-licenses)
Provides:       zypper(oldpackage)
Provides:       zypper(updatestack-only)
Provides:       zypper(purge-kernels)
Provides:       zypper(include-all-archs)
%if 0%{?suse_version}
Requires:       libaugeas0 >= 1.10.0
%requires_ge    libzypp
Recommends:     logrotate
Recommends:     zypper-log
%else
Requires:       augeas >= 1.10.0
%endif


%description
Zypper is a command line tool for managing software. It can be used to add
package repositories, search for packages, install, remove, or update packages,
install patches, hardware drivers, verify dependencies, and more.

Zypper can be used interactively or non-interactively by user, from scripts,
or front-ends.

%package log
Summary:        CLI for accessing the zypper logfile
Group:          System/Packages
Requires:       %{_bindir}/awk
Requires:       %{_bindir}/grep
Requires:       /bin/bash
BuildArch:      noarch

%description log
CLI for accessing the zypper logfile

%package aptitude
Summary:        aptitude compatibility with zypper
Group:          System/Packages
Requires:       perl
Requires:       zypper
BuildArch:      noarch

%description aptitude
provides compatibility to Debian's aptitude command using zypper

%package needs-restarting
Summary:        needs-restarting compatibility with zypper
Group:          System/Packages
Requires:       zypper
BuildArch:      noarch
%if 0%{?suse_version}
Supplements:    zypper
%endif

%description needs-restarting
provides compatibility to YUM needs-restarting command using zypper

%prep
%autosetup -p1

%build
mkdir -p build
cd build

CMAKE_FLAGS=

%if 0%{?suse_version} == 1500 && 0%{?sle_version} && 0%{?sle_version} <= 150100
  # Fixed in 1.14.34: Do not allow the abbreviation of cli arguments (bsc#1164543)
  # On SLE15/Leap 15.0 and 15.1 we will stay bug-compatible and accept the
  # abbreviations in order not to break tools. In 15.2 they must be fixed.
  CMAKE_FLAGS="$CMAKE_FLAGS -DLEGACY_ENABLE_LONGOPT_ABBREV=1"
%endif

export CFLAGS="%{optflags}"
export CXXFLAGS="%{optflags}"
export LDFLAGS="-Wl,--as-needed -fpie %{optflags}"

cmake $CMAKE_FLAGS \
      -DCMAKE_INSTALL_PREFIX=%{_prefix} \
      -DSYSCONFDIR=%{_sysconfdir} \
      -DMANDIR=%{_mandir} \
      -DCMAKE_VERBOSE_MAKEFILE=TRUE \
      -DCMAKE_BUILD_TYPE=RelWithDebInfo \
      -DENABLE_BUILD_TESTS=ON \
      ..

#gettextize -f
%make_build

%check
cd build/tests
ctest --output-on-failure .

%install
cd build
%make_install

mkdir -p %{buildroot}%{_prefix}/lib/zypper
mkdir -p %{buildroot}%{_prefix}/lib/zypper/commands

# yzpper symlink
ln -s zypper %{buildroot}%{_bindir}/yzpper

# Create filelist with translations
cd ..
%find_lang zypper
install -d -m755 %{buildroot}%{_var}/log
touch %{buildroot}%{_var}/log/zypper.log

%if %{defined _distconfdir}
# Move logratate files form /etc/logrotate.d to /usr/etc/logrotate.d
mkdir -p %{buildroot}/%{_distconfdir}/logrotate.d
mv %{buildroot}/%{_sysconfdir}/logrotate.d/zypper.lr %{buildroot}%{_distconfdir}/logrotate.d
mv %{buildroot}/%{_sysconfdir}/logrotate.d/zypp-refresh.lr %{buildroot}%{_distconfdir}/logrotate.d
%endif

%if %{defined _distconfdir}
%pre
# Prepare for migration to /usr/etc; save any old .rpmsave
for i in logrotate.d/zypper.lr logrotate.d/zypp-refresh.lr; do
   test -f %{_sysconfdir}/${i}.rpmsave && mv -v %{_sysconfdir}/${i}.rpmsave %{_sysconfdir}/${i}.rpmsave.old ||:
done
%endif

%if %{defined _distconfdir}
%posttrans
# Migration to /usr/etc, restore just created .rpmsave
for i in logrotate.d/zypper.lr logrotate.d/zypp-refresh.lr; do
   test -f %{_sysconfdir}/${i}.rpmsave && mv -v %{_sysconfdir}/${i}.rpmsave %{_sysconfdir}/${i} ||:
done
%endif

%files -f zypper.lang
%if 0%{?suse_version} >= 1500
%license COPYING
%endif
%config(noreplace) %{_sysconfdir}/zypp/zypper.conf
%if %{defined _distconfdir}
%{_distconfdir}/logrotate.d/zypper.lr
%{_distconfdir}/logrotate.d/zypp-refresh.lr
%else
%config(noreplace) %{_sysconfdir}/logrotate.d/zypper.lr
%config(noreplace) %{_sysconfdir}/logrotate.d/zypp-refresh.lr
%endif
%{_datadir}/bash-completion/completions/zypper
%{_bindir}/zypper
%{_bindir}/yzpper
%{_bindir}/installation_sources
%{_sbindir}/zypp-refresh
%dir %{_datadir}/zypper
%{_datadir}/zypper/zypper.aug
%dir %{_datadir}/zypper/xml
%{_datadir}/zypper/xml/xmlout.rnc
%{_prefix}/lib/zypper
%{_mandir}/man8/zypper.8%{?ext_man}
%{_mandir}/man8/zypp-refresh.8%{?ext_man}
%doc %dir %{_docdir}/zypper
%doc %{_docdir}/zypper/HACKING
# declare ownership of the log file but prevent
# it from being erased by rpm -e
%ghost %config(noreplace) %attr (640,root,root) %{_var}/log/zypper.log

%files log
%{_sbindir}/zypper-log
%{_mandir}/man8/zypper-log.8%{?ext_man}

%files aptitude
%{_bindir}/aptitude
%{_bindir}/apt-get
%{_bindir}/apt
%dir %{_sysconfdir}/zypp/apt-packagemap.d/
%config(noreplace) %{_sysconfdir}/zypp/apt-packagemap.d/*

%files needs-restarting
%{_bindir}/needs-restarting
%{_mandir}/man1/needs-restarting.1%{?ext_man}

%changelog
* Tue Sep 23 2025 ma@suse.de
- Fixed `bash-completion`: `zypper refresh` now ignores
  repository priority lines.
- Changes to support building against restructured libzypp in
  stack build (bsc#1230267)
- version 1.14.94
* Fri Jul 18 2025 ma@suse.de
- Fix addrepo to handle explicit --check and --no-check requests
  (bsc#1246466)
- Accept "show" as alias for "info" (bsc#1245985)
- version 1.14.93
* Fri Jul  4 2025 ma@suse.de
- sh: Reset solver options after command (bsc#1245496)
- Explicitly selecting DownloadAsNeeded also selects the
  classic_rpmtrans backend.
- version 1.14.92
* Wed Jun 18 2025 ma@suse.de
- BuildRequires:  libzypp-devel >= 17.37.6.
  Enhancements regarding mirror handling during repo refresh. Adapt
  to libzypp API changes. (bsc#1230267)
- version 1.14.91
* Thu May 22 2025 ma@suse.de
- BuildRequires:  libzypp-devel >= 17.37.0.
- Use libzypp improvements for preload and mirror handling.
- xmlout.rnc: Update repo-element (bsc#1241463)
  Add the "metalink" attribute and reflect that the "url" elements
  list may in fact be empty, if no baseurls are defined in the
  .repo files.
- man: update --allow-unsigned-rpm description.
  Explain how to achieve the same for packages provided by
  repositories.
- version 1.14.90
* Wed Apr 30 2025 ma@suse.de
- Updated translations (bsc#1230267)
- version 1.14.89
* Thu Mar 13 2025 ma@suse.de
- Do not double encode URL strings passed on the commandline
  (bsc#1237587)
  URLs passed on the commandline must have their special chars
  encoded already. We just want to check and encode forgotten
  unsafe chars like a blank. A '%%' however must not be encoded
  again.
- version 1.14.88
* Fri Feb 28 2025 ma@suse.de
- Package preloader that concurrently downloads files. It's not yet
  enabled per default. To enable the preview set ZYPP_CURL2=1 and
  ZYPP_PCK_PRELOAD=1 in the environment. (#104)
- BuildRequires:  libzypp-devel >= 17.36.4.
- version 1.14.87
* Fri Feb 28 2025 ma@suse.de
- refresh: add --include-all-archs (fixes #598)
  Future multi-arch repos may allow to download only those metadata
  which refer to packages actually compatible with the systems
  architecture. Some tools however want zypp to provide the full
  metadata of a repository without filtering incompatible
  architectures.
- info,search: add option to search and list Enhances
  (bsc#1237949)
- version 1.14.86
* Thu Feb 27 2025 ma@suse.de
- Annonunce --root in commands not launching a Target
  (bsc#1237044)
- BuildRequires:  libzypp-devel >= 17.36.3.
- version 1.14.85
* Wed Feb 12 2025 ma@suse.de
- Let zypper dup fail in case of (temporarily) unaccessible repos
  (bsc#1228434, bsc#1236939, fixes #446)
- version 1.14.84
* Mon Feb 10 2025 ma@suse.de
- New system-architecture command (bsc#1236384)
  Prints the detected system architecture.
- version 1.14.83
* Mon Feb 10 2025 ma@suse.de
- requires: libzypp >= 17.36.0.
- Change versioncmp command to return exit code according to the
  comparison result (#593)
- version 1.14.82
* Wed Jan 22 2025 ma@suse.de
- lr: show the repositories keep-packages flag (bsc#1232458)
  It is shown in the  details view or by using -k,--keep-packages.
  In addition libyzpp supports to enforce keeping downloaded
  packages of all repos within a package cache by creating a
  '.keep_packages' file there.
- version 1.14.81
* Fri Jan 17 2025 ma@suse.de
- Try to refresh update repos first to have updated GPG keys on
  the fly (bsc#1234752)
  An update repo may contain a prolonged GPG key for the GA repo.
  Refreshing the update repo first updates a trusted key on the fly
  and avoids a 'key has expired' warning being issued when
  refreshing the GA repo.
- Refresh: restore legacy behavior and suppress Exception
  reporting as non-root (bsc#1235636)
- version 1.14.80
* Wed Jan  8 2025 ma@suse.de
- info: Allow to query a specific version (jsc#PED-11268)
  To query for a specific version simply append "-<version>" or
  "-<version>-<release>" to the "<name>" pattern. Note that the
  edition part must always match exactly.
- version 1.14.79
* Tue Nov 12 2024 ma@suse.de
- Don't try to download missing raw metadata if cache is not
  writable (bsc#1225451)
- man: Update 'search' command description.
  Hint to "se -v" showing the matches within the packages metadata.
  Explain that search strings starting with a "/" will implicitly
  look into the filelist as well. Otherfise an explicit "-f" is
  needed.
- version 1.14.78
* Fri Sep  6 2024 ma@suse.de
- API refactoring. Prevent zypper from using now private libzypp
  symbols (bsc#1230267)
- BuildRequires:  libzypp-devel >= 17.35.10.
- Fix wrong numbers used in CommitSummary skipped/failed messages.
- version 1.14.77
* Tue Jul  2 2024 ma@suse.de
- Show rpm install size before installing (bsc#1224771)
  If filesystem snapshots are taken before the installation (e.g.
  by snapper) no disk space is freed by removing old packages. In
  this case the install size of all packages is a hint how much
  additional disk space is needed by the new packages static
  content.
- version 1.14.76
* Tue Jul  2 2024 ma@suse.de
- Fix readline setup to handle Ctrl-C and Ctrl-D corrrectly
  (bsc#1227205)
- version 1.14.75
* Wed Jun 26 2024 ma@suse.de
- Let_readline_abort_on_Ctrl-C (bsc#1226493)
- packages: add '--system' to show @System packages (bsc#222971)
- version 1.14.74
* Fri May  3 2024 ma@suse.de
- Fixed check for outdated repo metadata as non-root user
  (bsc#1222086)
- BuildRequires:  libzypp-devel >= 17.33.0.
- Delay zypp lock until command options are parsed (bsc#1223766)
- version 1.14.73
* Mon Apr 29 2024 ma@suse.de
- Unify message format(fixes #485)
- version 1.14.72
* Wed Apr 24 2024 dmueller@suse.com
- switch cmake build type to RelWithDebInfo
- modernize spec file (remove Authors section, use proper macros,
  remove redundant clean section, don't mark man pages as doc)
- switch to -O2 -fvisibility=hidden -fpie:
  * PIC is not needed as no shared lib is built
  * fstack-protector-strong is default on modern dists and would
    be downgraded by fstack-protector
  * default visibility hidden allows better optimisation
  * O2 is reducing inlining bloat
  - > 18%% reduced binary size
* Mon Apr 22 2024 dmueller@suse.com
- remove procps requires (was only for ZMD which is dropped)
  (jsc#PED-8153)
* Mon Apr 15 2024 ma@suse.de
- Do not try to refresh repo metadata as non-root user
  (bsc#1222086)
  Instead show refresh stats and hint how to update them.
- man: Explain how to protect orphaned packages by collecting
  them in a plaindir repo.
- packages: Add --autoinstalled and --userinstalled options to
  list them.
- Don't print 'reboot required' message if download-only or
  dry-run (fixes #529)
  Instead point out that a reboot would be required if the option
  was not used.
- Resepect zypper.conf option `showAlias` search commands
  (bsc#1221963)
  Repository::asUserString (or Repository::label) respects the
  zypper.conf option, while name/alias return the property.
- version 1.14.71
* Mon Mar 25 2024 ma@suse.de
- dup: New option --remove-orphaned to remove all orphaned
  packages in dup (bsc#1221525)
- version 1.14.70
* Fri Mar 22 2024 ma@suse.de
- info,summary: Support VendorSupportOption flag
  VendorSupportSuperseded (jsc#OBS-301, jsc#PED-8014)
- BuildRequires:  libzypp-devel >= 17.32.0.
  API cleanup and changes for VendorSupportSuperseded.
- Show active dry-run/download-only at the commit propmpt.
- patch: Add --skip-not-applicable-patches option (closes #514)
- Fix printing detailed solver problem description.
  The problem description() is one rule out possibly many in
  completeProblemInfo() the solver has chosen to represent the
  problem. So either description or completeProblemInfo should be
  printed, but not both.
- Fix bash-completion to work with right adjusted numbers in the
  1st column too (closes #505)
- Set libzypp shutdown request signal on Ctrl+C (fixes #522)
- lr REPO: In the detailed view show all baseurls not just the
  first one (bsc#1218171)
- version 1.14.69
* Thu Dec 14 2023 ma@suse.de
- Fix search/info commands ignoring --ignore-unknown (bsc#1217593)
  The switch makes search commands return 0 rather than 104 for
  empty search results.
- version 1.14.68
* Fri Dec  8 2023 ma@suse.de
- patch: Make sure reboot-needed is remembered until next boot
  (bsc#1217873)
- version 1.14.67
* Thu Oct 12 2023 ma@suse.de
- Return 104 also if info suggests near matches (fixes #504)
- Rephrase upgrade message for openSUSE Tumbleweed (bsc#1212422)
- Fix typo (fixes #484)
- version 1.14.66
* Thu Sep 21 2023 ma@suse.de
- Fix some typos and spelling errors found by Lintian (fixes #501)
- Prefer unaliased `grep` to avoid unexpected/wrong completions.
  (#503)
- commit: Insert a headline to separate output of different rpm
  scripts (bsc#1041742)
- Fix typo in changes file.
- version 1.14.65
* Tue Sep  5 2023 ma@suse.de
- Fix name of the bash completion script (bsc#1215007)
  In 1.14.63 the location of the bash completion script was changed
  to /usr/share/bash-completion/completions/. But the patch failed
  to also rename the completion script. The original script name
  zypper.sh is not recognized at the new location.
- Update notes about failing signature checks (bsc#1214395)
  It might be a transient issue if the server is in the midst of
  receiving new data. Retry after a few minutes might work.
- Improve the SIGINT handler to be signal safe (bsc#1214292)
  This patch updates the SIGINT handling strategy to be signal
  safe. Meaning the signal handler will do not much more than
  setting a flag, which we are going to check in the normal program
  flow as much as possible.
- version 1.14.64
* Wed Aug 16 2023 ma@suse.de
- Changed location of bash completion script (bsc#1213854).
  This changes the location of zypper.sh bash completion script
  from /usr/share/bash-completion/completions/.
- version 1.14.63
* Fri Jul 28 2023 ma@suse.de
- man: revised explanation of --force-resolution (bsc#1213557)
  Point out that the option not only allows to remove packages but
  may also violate any other active policy if there is no other way
  to resolve the job.
- Print summary hint if policies were violated due to
  - -force-resolution (bsc#1213557)
- BuildRequires:  libzypp-devel >= 17.31.16 (for zypp-tui)
- version 1.14.62
* Thu Jun 15 2023 ma@suse.de
- targetos: Add an error note if XPath:/product/register/target
  is not defined in /etc/products.d/baseproduct (bsc#1211261)
- targetos: Update help and man page (bsc#1211261)
- version 1.14.61
* Fri Mar 31 2023 ma@suse.de
- Fix selecting installed patterns from picklist (bsc#1209406)
- man: better explanation of --priority (fixes #480)
- version 1.14.60
* Sat Dec 24 2022 ma@suse.de
- BuildRequires:  libzypp-devel >= 17.31.7.
- Provide "removeptf" command (bsc#1203249)
  A remove command which prefers replacing dependant packages to
  removing them as well.
  A PTF is typically removed as soon as the fix it provides is
  applied to the latest official update of the dependant packages.
  But you don't want the dependant packages to be removed together
  with the PTF, which is what the remove command would do. The
  removeptf command however will aim to replace the dependant
  packages by their official update versions.
- patterns: Avoid dispylaing superfluous @System entries
  (bsc#1205570)
- version 1.14.59
* Mon Nov  7 2022 ma@suse.de
- Update man page and explain '.no_auto_prune' (bsc#1204956)
- Allow to (re)add a service with the same URL (bsc#1203715)
- Explain outdatedness of repos (fixes #463)
- BuildRequires:  libzypp-devel >= 17.31.5
- version 1.14.58
* Wed Oct  5 2022 ma@suse.de
- BuildRequires:  libzypp-devel >= 17.31.2.
- Fix --[no]-allow-vendor-change feedback in install command
  (bsc#1201972)
- version 1.14.57
* Fri Sep  2 2022 ma@suse.de
- UsrEtc: Store logrotate files in %%{_distconfdir} if defined
  (fixes #441, fixes #444)
- Remove unneeded code to compute the PPP status.
  Since libzypp 17.23.0 the PPP status is auto established. No
  extra solver run is needed.
- Make sure 'up' respects solver related CLI options (bsc#1201972)
- Fix tests to use locale "C.UTF-8" rather than "en_US".
- Fix man page (fixes #451)
- version 1.14.56
* Wed Jul 20 2022 ma@suse.de
- lr: Allow shortening the Name column if table is wider than the
  terminal (bsc#1201638)
- Don't accepts install/remove modifier without argument
  (bsc#1201576)
- zypper-download: Set correct ExitInfoCode when failing to
  resolve argument.
- zypper-download: Handle unresolvable arguments as error.
  This commit changes zypper-download such that it behaves more
  consistent to zypper-install when an argument can't be resolved.
- version 1.14.55
* Tue Jul  5 2022 ma@suse.de
- Fix building with GCC 13 (fixes #448)
- Put signing key supplying repository name in quotes.
- version 1.14.54
* Wed Jun 15 2022 ma@suse.de
- Basic JobReport for "cmdout/monitor".
- versioncmp: if verbose, also print the edition 'parts' which are
  compared.
- Make sure MediaAccess is closed on exception (bsc#1194550)
- Display plus-content hint conditionally (fixes #433)
- Honor the NO_COLOR environment variable when auto-detecting
  whether to use color (fixes #432)
- Define table columns which should be sorted natural [case
  insensitive] (fixes #391, closes #396, fixes #424)
- lr/ls: Use highlight color on name and alias as well.
- version 1.14.53
* Thu Feb 24 2022 ma@suse.de
- info: print the packages upstream URL if available (fixes #426)
- info: Fix SEGV with not installed PTFs (bsc#1196317)
- Don't prevent less restrictive umasks (bsc#1195999)
- version 1.14.52
* Thu Dec 23 2021 ma@suse.de
- Singletrans: handle fatal and non-fatal script errors properly.
- Add SingleTransReportReceiver.
- Immediately write out additional rpm output.
- BuildRequires:  libzypp-devel >= 17.29.0.
  Need SingleTransReport and immediate rpm script output reports.
- version 1.14.51
* Mon Oct 18 2021 ma@suse.de
- Fix compiler warning.
- zypper.conf: New option whether to collect subcommands found in
  $PATH (fixes #379)
  +[subcommand] i
  +
  +##  Whether to look for subcommands in $PATH
  +##
  +## If a subcommand is not found in the zypper_execdir, the wrapper
  +## will look in the rest of your $PATH for it. Thus, it's possible
  +## to write local zypper extensions that don't live in system space.
  +## See section SUBCOMMANDS in the zypper manpage.
  +##
  +## Valid values: boolean
  +## Default value: yes
  +##
  +# seachSubcommandInPath = yes.
- help subcommand: show path of command found in $PATH.
- version 1.14.50
* Fri Sep  3 2021 ma@suse.de
- Avoid calling 'su' to detect a too restrictive sudo user umask
  (bsc#1186602)
- Fix typo in German translation (fixes #395)
- BuildRequires:  libzypp-devel >= 17.28.3.
- version 1.14.49
* Wed Jul 28 2021 ma@suse.de
- Support new reports for singletrans rpm commit.
- BuildRequires:  libzypp-devel >= 17.27.1.
  For lock/query comments.
- Prompt: choose exact match if prompt options are not prefix
  free (bsc#1188156)
- Install summary: Show new and removed packages closer to the
  prompt (fixes #403)
  These packages are usually more interesting than the updated
  ones. In case of doubt less scrolling is needed to see them.
- Add need reboot/restart hint to XML install summary
  (bsc#1188435)
- Add comment option for lock command (fixes #388).
- version 1.14.48
* Thu Jul  1 2021 ma@suse.de
- Quick fix obs:// platform guessing for Leap (bsc#1187425)
- man: point out more clearly that patches update affected
  packages to the latest version (bsc#1187466)
- version 1.14.47
* Thu Jun 10 2021 ma@suse.de
- Link all executables with -pie (bsc#1186447)
- Tag PTF packages in the status column (bsc#1186503)
  Like retracted packages, a program temporary fix must be
  explicitly selected and will otherwise not be considered in
  dependency resolution.
- BuildRequires:  libzypp-devel >= 17.26.1.
- version 1.14.46
* Wed Jun  2 2021 ma@suse.de
- Add hints to 'trust GPG key' prompt.
- Add report when receiving new package signing keys from a
  trusted repo (bsc#1184326)
- Added translation using Weblate (Kabyle)
- version 1.14.45
* Fri Apr 30 2021 ma@suse.de
- Rephrase needs-rebooting help and messages.
  Try to point out that the need to reboot was not necessarily
  triggered by the current transaction.
- man page: Recommend the needs-rebooting command to test whether
  a system reboot is suggested.
- patch: Let a patch's reboot-needed flag overrule included packages
  (bsc#1183268)
- Quickfix setting "openSUSE_Tumbleweed" as default platform for
  "MicroOS" (bsc#1153687)
  This fixes the guessed platform for "obs://<project>/" URLs.
- Protect against strict/relaxed user umask via sudo (bsc#1183589)
- zypper-log: protect against thread name indicators in a log.
- xml summary: add solvables repository alias (bsc#1182372)
- version 1.14.44
* Wed Feb 24 2021 ma@suse.de
- doc: give more details about creating versioned package locks
  (bsc#1181622)
- man: Document synonymously used patch categories (bsc#1179847)
- version 1.14.43
* Tue Jan 12 2021 ma@suse.de
- Fix source-download commnds help (bsc#1180663)
- man: Recommend to use the --non-interactive global option
  rather than the command option -y (bsc#1179816)
- Extend apt packagemap (fixes #366)
- --quitet: Fix install summary to write nothing if there's
  nothing todo (bsc#1180077)
- Prefer /run over /var/run.
- version 1.14.42
* Fri Nov 27 2020 ma@suse.de
- Avoid translated text in xml attributes ( fixes #361 )
- BuildRequires:  libzypp-devel >= 17.25.3.
  Adapt to new LoadTestcase API.
- version 1.14.41
* Fri Sep 25 2020 ma@suse.de
- info: Assume descriptions starting with '<p>' are richtext
  (bsc#935885)
- version 1.14.40
* Fri Sep 18 2020 ma@suse.de
- Use new testcase API in libzypp.
- BuildRequires:  libzypp-devel >= 17.25.0.
- help: prevent 'whatis' from writing to stderr (bsc#1176712)
- wp: point out that command is aliased to a search command and
  searches case-insensitive (jsc#SLE-16271)
- version 1.14.39
* Fri Aug 28 2020 ma@suse.de
- Directly list subcommands in 'zypper help' (bsc#1165424)
- man: enhance description of the global package cache (bsc#1175592)
- Remove extern C block wrapping augeas.h as it breaks the build
  on Arch Linux.
- Point out that plaindir repos do not follow symlinks (bsc#1174561)
- Fix help command for list-patches
- man: Point out that plain rpm packages are not downloaded to the
  global package cache (bsc#1173273)
- version 1.14.38
* Mon Jun 15 2020 bzeller@suse.de
- Print switch abbrev warning to stderr (bsc#1172925)
- Fix typo in man page (bsc#1169947)
- version 1.14.37
* Mon Apr 13 2020 ma@suse.de
- Reformat manpages to workaround asciidoctor shortcomings
  (bsc#1154803, bsc#1167122, bsc#1168990)
- Remove undocumented rug legacy stuff.
- Remove 'using namespace std;' (bsc#1166610)
- patch table: Add 'Since' column if history data are available
  (jsc#SLE-5116)
- version 1.14.36
* Fri Mar 20 2020 ma@suse.de
- Tag 'retracted' patch status in info and list-patches (jsc#SLE-8770)
- Tag 'R'etracted items in search tabes status columns (jsc#SLE-8770)
- Relax 'Do not allow the abbreviation of cli arguments' in
  legacy distibutions (bsc#1164543)
- Correctly detect ambigous switch abbreviations (bsc#1165573)
- zypper-aptitude: don't supplement zypper.
  supplementing zypper means zypper-aptitude gets installed by
  default and pulls in perl. Neither is desired on small systems.
- BuildRequires:  libzypp-devel >= 17.23.2.
- version 1.14.35
* Fri Feb 21 2020 ma@suse.de
- Do not allow the abbreviation of cli arguments (bsc#1164543)
- accoring to according in all translation files.
- Always show exception history if available.
- Use default package cache location for temporary repos (bsc#1130873)
- version 1.14.34
* Thu Nov 28 2019 ma@suse.de
- Introduce purge-kernels command (bsc#1155198)
  Adds a new zypper command to cleanup all obsolete kernels as
  configured by the user.
- Request root privs for zypper addlocale and removelocale.
- Load only target resolvables for removelocale.
- Load only target resolvables for zypper rm (bsc#1157377)
- Fix broken search by filelist (bsc#1135114 )
- zypper-log: Replace python by a bash script (fixes#304,
  fixes#306, bsc#1156158)
- locales: do not sort out requested locales which are not
  available (bsc#1155678)
- list_patches_by_issue: rewrite table output and add xml output
  (bsc#1154805)
  Prevent listing duplicate matches in tables. XML result is
  provided within the new <list-patches-byissue> element.
- list-patches: XML add patch <issue-date> and <issue-list>
  (bsc#1154805)
- Fix zypper lp --cve/bugzilla/issue options (bsc#1155298)
- Always execute commit when adding/removing locales (fixes
  bsc#1155205)
- man page: fix description of --table-style,-s (bsc#1154804)
- Provide reverse search in zypper (fixes #214)
  This patch adds a new set of switches to zypper to support
  searching reverse dependencies for a package or a set of packages.
- BuildRequires:  libzypp-devel >= 17.16.1.
- version 1.14.33
* Wed Oct 23 2019 ma@suse.de
- Add extended solver options to list-updates.
  Since the update command supports tweaking the solver via CLI
  options the list-updates command should allow the same
  (bsc#1153351)
- version 1.14.32
* Tue Oct 22 2019 ma@suse.de
- --solver-focus: Set the solvers general attitude when resolving
  a job (bsc#1146415)
- Add --repo switch to download (jira#SLE-9171)
- manpage: Improve description of $releasever and --releasever
  usecases (bsc#1149511)
- Ask only once if multiple packages share the same license text
  (bsc#1145554)
- Allow selection by capability if --force switch is used
  (fixes #289)
- BuildRequires:  libzypp-devel >= 17.15.0
- version 1.14.31
* Fri Aug 30 2019 ma@suse.de
- Ignore SIGPIPE while STDOUT/STDERR are OK (bsc#1145521)
- Dump stacktrace on SIGPIPE (bsc#1145521)
- info: The requested info must be shown in QUIET mode (fixes #287)
- version 1.14.30
* Wed Aug  7 2019 ma@suse.de
- Fix local/remote url classification.
- Rephrase file conflict check summary (bsc#1140039)
- Fix bash completions option detection (bsc#1049825)
- BuildRequires:  libzypp-devel >= 17.14.0
- version 1.14.29
* Tue Jun 11 2019 ma@suse.de
- man: split '--with[out]' like options to ease searching.
- Unhide 'ps' command in help
- Add option to show more conflict information
- Rephrased `zypper ps` hint (bsc#859480)
- Fix repo refresh not returning 106-ZYPPER_EXIT_INF_REPOS_SKIPPED
  if --root is used (bsc#1134226)
- Fix unknown package handling in zypper install (fixes bsc#1127608)
- Fix the package build failure with CMake 3.14.
- Re-show progress bar after pressing retry upon install error
  (bsc#1131113)
- version 1.14.28
* Wed Apr  3 2019 christophe@krop.fr
- Fix build with CMake >= 3.14
  Starting with CMake 3.14, EXCLUDE_FROM_ALL now spreads from
  directories to targets. 'make -C someSubdir' when 'someSubdir'
  uses the 'EXCLUDE_FROM_ALL' keyword does nothing.
- Remove unneeded CMake commands.
* Thu Mar 21 2019 ma@suse.de
- Add Requires: libaugeas0 >= 1.10.0 (fixes #265)
- bash-completion: add package completion for addlock (bsc#1047962)
- bash-completion: fix incorrect detection of command names (bsc#1049826)
- version 1.14.27
* Mon Feb 25 2019 ma@suse.de
- Offer to change the 'runSearchPackages' config option at the prompt
  (bsc#1119373, FATE#325599)
- Prompt: provide a 'yes/no/always/never' prompt.
- Prompt: support "#NUM" as answer to select the NUMth option...
- Augeas: enable writing back changed option values (to ~/.zypper.conf)
- removelocale: fix segfault
- Move needs-restarting command to subpackage (fixes #254)
- Allow empty string as argument (bsc#1125415)
- Provide a way to delete cache for volatile repositories (bsc#1053177)
- Adapt to boost-1.69 requiring explicit casts tribool->bool (fixes #255)
- Show support status in info if not unknown (bsc#764147)
- version 1.14.26
* Mon Feb 11 2019 ma@suse.de
- Fix installing plain rpm files with `zypper in` (bsc#1124897)
- Show only required info in the summary in quiet mode (bsc#993025)
- version 1.14.25
* Thu Feb  7 2019 ma@suse.de
- Stay with legacy behavior and return ZYPPER_EXIT_INF_REBOOT_NEEDED
  only for patches. We don't extend this return code to packages,
  although they may also carry the 'reboot-needed' attribute. The
  preferred way to test whether the system needs to be rebooted is
  `zypper needs-rebooting`. (openSUSE/zypper#237)
- Skip repository on error (bsc#1123967)
- Adapt testcase as repeated options lo longer throw (bsc#1123865)
- version 1.14.24
* Thu Jan 31 2019 ma@suse.de
- New commands for locale management: locales addlocale removelocale
  Inspect and manipulate the systems `requested locales`, aka. the
  languages software packages should try support by installing
  translations, dictionaries and tools, as far as they are available.
- Don't throw, just warn if options are repeated (bsc#1123865)
- Fix detection whether stdout is a tty (happened too late)
- Fix broken --plus-content switch (fixes bsc#1123681)
- Fix broken --replacefiles switch (fixes bsc#1123137)
- Extend zypper source-install (fixes bsc#663358)
- Fix inconsistent results for search (bsc#1119873)
- Show reboot hint in zypper ps and summary (fixes bnc#1120263)
- version 1.14.23
* Fri Jan 18 2019 ma@suse.de
- Improve handling of partially locked packages (bsc#1113296)
- Fix wrong default values in help text (bsc#1121611)
- BuildRequires:  libzypp-devel >= 17.11.0
- version 1.14.22
* Wed Jan 16 2019 ma@suse.de
- Fixed broken argument parsing for --reposd-dir (bsc#1122062)
- version 1.14.21
* Tue Jan  8 2019 ma@suse.de
- Fix wrong zypp::indeterminate use (bsc#1120463)
- version 1.14.20
* Tue Dec 18 2018 ma@suse.de
- CLI parser: fix broken initialization enforcing 'select by name'
  (bsc#1119820)
- zypper.conf: [commit] autoAgreeWithLicenses {=false} (fixes #220)
- locks: Fix printing of versioned locks (bsc#1112911)
- locks: create and write versioned locks correctly (bsc#1112911)
- patch: --with update may implicitly assume --with-optional
  (bsc#1102261)
- version 1.14.19
* Tue Dec 11 2018 ma@suse.de
- no-recommends: Nevertheless consider resolver namespaces (hardware,
  language,..supporting packages) (FATE#325513)
- BuildRequires:  libzypp-devel >= 17.10.2
- version 1.14.18
* Wed Nov 28 2018 ma@suse.de
- Optionally run "zypper search-packages" after "search" (FATE#325599)
- zypper.conf: Add [search]runSearchPackages config variable.
- BuildRequires:  libzypp-devel >= 17.10.0
- version 1.14.17
* Wed Nov 14 2018 ma@suse.de
- Don't iterate twice on --no-cd (bsc#1111319)
- zypper-log: Make it Python 3 compatible
- man: mention /etc/zypp/needreboot config file (fate#326451, fixes #140)
- BuildRequires:  libzypp-devel >= 17.9.0 (provides needreboot file)
- version 1.14.16
* Mon Oct 29 2018 ma@suse.de
- Add `needs-restarting` shell script and manpage (fate#326451)
- Add zypper needs-rebooting command (fate#326451)
- version 1.14.15
* Fri Oct 12 2018 ma@suse.de
- BuildRequires:  libzypp-devel >= 17.8.0 (for fate#326451)
- Introduce new zypper command framefork. Migrated commands so far:
  addlock addrepo addservice clean cleanlocks modifyrepo modifyservice
  ps refresh refresh-services removelock removerepo removeservice
  renamerepo repos services
- version 1.14.14
* Tue Oct  9 2018 ma@suse.de
- MediaChangeReport: fix https URLs causing 2 prompts on error
  (bsc#1110542)
- version 1.14.13
* Thu Sep 27 2018 ma@suse.de
- Always warn if no repos are defined, but don't return
  ZYPPER_EXIT_NO_REPOS(6) in install commands (bsc#1109893)
- Switch global help format and fix bash-completion
- version 1.14.12
* Wed Sep 19 2018 ma@suse.de
- Allow repo commands on transactional-server (bsc#1108999)
- BuildRequires:  libzypp-devel >= 17.7.0 (dropped type application)
- Unite askUserToAccept*Key report callback (fixes #196)
- version 1.14.11
* Thu Sep  6 2018 ma@suse.de
- Always set error status if any nr of unknown repositories are
  passed to lr and ref (bsc#1093103)
- version 1.14.10
* Thu Aug 30 2018 ma@suse.de
- Notify user about unsupported rpm V3 keys in an old rpm database
  (bsc#1096217)
- man: Remove links to missing metadata section (fixes #140)
- Detect read only filesystem on system modifying operations
  (fixes #199)
- Use %%license (bsc#1082318)
- Handle repo aliases containing multiple ':' in the PackageArgs
  parser (bsc #1041178)
- BuildRequires:  libzypp-devel >= 17.6.3
- version 1.14.9
* Fri Aug  3 2018 ma@suse.de
- Support listing gpgkey URLs in repo files (bsc#1088037)
- Check for root privileges in zypper verify and si (bsc#1058515)
- XML <install-summary> attribute `packages-to-change` added
  (bsc#1102429)
- Add expert (allow-*) options to all installer commands
  (bsc#428822)
- Sort search results by multiple columns (bsc#1066215)
- man: Strengthen that `--config FILE' affects zypper.conf,
  not zypp.conf (bsc#1100028)
- BuildRequires:  libzypp-devel >= 17.6.0
- version 1.14.8
* Mon Jul  9 2018 ma@suse.de
- Set error status if repositories passed to lr and ref are not
  known (BSC #1093103)
- Do not override table style in search (fixes #171)
- Fix out of bound read in MbsIterator (fixes #167)
- Add --supplements switch to search and info (fixes #184)
- Add setter functions for zypp cache related config values to
  ZConfig (fixes #180)
- BuildRequires: libzypp-devel >= 17.3.2
- version 1.14.7
* Mon May 28 2018 ma@suse.de
- Fix broken display of detailed query results
- Fix broken search for items with a dash (bsc#907538, bsc#1043166,
  bsc#1070770)
- fix translation error (fixes #178)
- Disable repository operations when searching installed packages
  (bsc#1084525)
- Prevent nested calls to exit() if aborted by a signal (bsc#1092413)
- ansi.h: Prevent ESC sequence strings from going out of scope
  (bsc#1092413)
- version 1.14.6
* Thu Apr 26 2018 ma@suse.de
- search: Hint the user to the 'search-packages' subcommand, if the
  distribution provides it (bsc#1089994)
- clean: Don't report an error, if no repo is to be cleaned
  (bsc#1089504)
- Add --installroot flag (fixes #157)
- version 1.14.5
* Tue Mar 13 2018 ma@suse.de
- Fix translated format strings (bsc#1082711)
- Protect code against broken translations (bsc#1082711)
- Fix broken translated format strings
- BuildRequires:  libzypp-devel >= 17.2.2
- Deprecate the use of asciidoc for new releases
- Introduce --allow-unsigned-rpm switch to install (bsc#1055533)
- version 1.14.4
* Thu Mar  1 2018 bzeller@suse.de
- Auto complete available repositories with the --from switch
- Fix: zypper bash completion expands non-existing options (bsc#1049825)
- Fix template to compile (fixes #146)
- version 1.14.3
* Mon Feb  5 2018 ma@suse.de
- do not recommend cron (bsc#1079334)
- version 1.14.2
* Thu Nov 30 2017 ma@suse.de
- Avoid writing ANSI Escape sequences on a dumb terminal (bsc#1055315)
- version 1.14.1
* Thu Nov 23 2017 ma@suse.de
- Update manpage regarding custom repository variable fixes
  (bsc#1057640, bsc#1067605)
- Version 1.14.x for CODE-15, 1.13.x. is continued on SuSE-SLE-12-SP2-Branch
- version 1.14.0
* Fri Nov 17 2017 bwiedemann@suse.com
- Add apt alias for compat with new debian package management
* Thu Oct  5 2017 ma@suse.de
- Add summary hint if product is better updated by a different
  command. This is mainly used by rolling distributions like Tumbleweed
  to remind their users to use 'zypper dup' to update (not zypper up or
  patch). (bsc#1061384)
- version 1.13.37
* Fri Sep 22 2017 ma@suse.de
- Unify '(add|modify)(repo|service)' property related arguments.
  Fixed 'add' commands supporting to set only a subset of properties.
  Introduced '-f/-F' as preferred short option for --[no-]refresh
  in all four commands. (bsc#661410, bsc#1053671)
- version 1.13.36
* Thu Sep 14 2017 ma@suse.de
- Fix missing package names in installation report (bsc#1058695,
  fixes #134)
- version 1.13.35
* Mon Sep 11 2017 ma@suse.de
- Summary: Differ between unsupported and packages with unknown
  support status  (bsc#1057634)
- Use HTTPS by default for repository URLs derived from obs://
- version 1.13.34
* Thu Sep  7 2017 ma@suse.de
- Return '107' if some rpm %%post configuration script failed
  (bsc#1047233)
- version 1.13.33
* Fri Aug 25 2017 ma@suse.de
- GPG key: Also show a gpg keys subkeys (bsc#1008325)
- libzypp-devel >= 16.15.4
- version 1.13.32
* Fri Aug 11 2017 ma@suse.de
- Improve signature check callback messages
  (bsc#1045735, CVE-2017-9269)
- man: Explain new gpgcheck options
- add/modify repo: Add options to tune the GPG check settings
  (bsc#1045735, CVE-2017-9269)
- BuildRequires:  libzypp-devel >= 16.15.3
- version 1.13.31
* Mon Jul 17 2017 ma@suse.de
- Adapt download callback to report and handle unsigned packages
  (bsc#1038984, CVE-2017-7436)
- BuildRequires:  libzypp-devel >= 16.15.0
- version 1.13.30
* Wed Jul 12 2017 ma@suse.de
- dwnldProgress: Report missing/optional files as 'not found' rather
  than 'error' (bsc#1047785)
- Emphasize that it depends on PackageKit how fast it will respond
  to a 'quit' request sent if PK blocks package management.
- man: Mention support for custom repository variables defined in
  /etc/zypp/vars.d (openSUSE/libzypp#68)
- BuildRequires:  libzypp-devel >= 16.13.1
- version 1.13.29
* Thu Jun  1 2017 ma@suse.de
- Accept --auto-agree-with-product-licenses from SUSEconnect (bsc#1037783)
- version 1.13.28
* Fri May 12 2017 ma@suse.de
- Unknown command: add hint about possibly missing plugin package
  (bsc#1037254)
- Search: tag packages installed by user request as 'i+'
- set non-zero exit code if modifying a service fails.
- BuildRequires:  libzypp-devel >= 16.11.0
- version 1.13.27
* Thu May 11 2017 ma@suse.de
- download: fix crash when non-package types are passed as argument
  (bsc#1037210)
- Use a common definition for common solver options (bsc#1017486)
- BuildRequires:  libzypp-devel >= 16.10.0
- version 1.13.26
* Thu Apr 27 2017 ma@suse.de
- Fix translation shortcut error (bsc#1035344)
- version 1.13.25
* Mon Apr 24 2017 ma@suse.de
- patch: add --with-update to install also plain package updates.
  This is basically the same as running 'zypper update' afterwards.
  (FATE#320653)
- BuildRequires:  libzypp-devel >= 16.8.0
- Fix TODOs in zypper manpage (bsc#1032259)
- Remove legacy vendor equivalence between 'suse' and 'opensuse'
  (bsc#1030686)
- version 1.13.24
* Fri Apr 21 2017 ma@suse.de
- Fix crash when exiting after pressing CTRL-C quickly twice or more
  (bsc#1032279)
- Use private temporary repos for --plus-repo (bsc#1032632,bsc#1017267)
- Use private temporary repos to collect rpms passed on the command
  line (bsc#1032632)
- Allow --plus-content to temporarily enable repos by alias/number
- refresh: recognize --plus-content repos (FATE#319486)
- BuildRequires:  libzypp-devel >= 16.7.0
- version 1.13.23
* Tue Apr  4 2017 ma@suse.de
- man: describe supported SSL related URL options (bsc#1032152)
- version 1.13.22
* Fri Mar 17 2017 ma@suse.de
- Don't show installed system packages if list command is restricted
  to repos (bsc#1028492)
- Indicate presence of additional prompt options not mentioned in the
  prompt string.
- version 1.13.21
* Mon Mar 13 2017 ma@suse.de
- Info: Improve srcpackage info (FATE#321104)
- Make temporary repos invisible for other zypp instances (bsc#1017267)
- man: remove (non-working) email addresses from author section (bsc#1028003)
- aptitude: simulate is non-interactive (boo#1028119)
- version 1.13.20
* Wed Feb 22 2017 ma@suse.de
- Try to exit gracefully after SIGPIPE (bsc#926844)
- BuildRequires:  libzypp-devel >= 16.4.3
- version 1.13.19
* Fri Feb 17 2017 adam.majer@suse.de
- use individual libboost-*-devel packages instead of boost-devel
* Fri Feb 17 2017 ma@suse.de
- dup: add -y command option as alias for --non-interactive global
  option to be conssistent with other install commands (bsc#1018873)
- version 1.13.18
* Thu Feb 16 2017 ma@suse.de
- Translation: updated .pot file
- Improve srcpackage info (FATE#321104)
- version 1.13.17
* Thu Feb 16 2017 ma@suse.de
- Improve package info. Show binary packages built from a source
  package and for packages the source package it was built from.
  If no specific type is requested and no package matches, show
  non-package matches if available. (FATE#321104)
- version 1.13.17
* Tue Feb 14 2017 ma@suse.de
- Fix invalid xml in gpg key info output(bsc#1024909)
- BuildRequires:  libzypp-devel >= 16.4.2
- version 1.13.16
* Thu Jan 12 2017 ma@suse.de
- Fix --help output breaking tab completion (bsc#983021)
- version 1.13.15
* Tue Nov 22 2016 ma@suse.de
- Properly escape patch script output in xml mode (bsc#1010712)
- version 1.13.14
* Mon Oct 31 2016 ma@suse.de
- lr: show repo priority summary
- Fix german translations (bsc#975777, bsc#975794)
- Do not warn about processes using deleted files
  when using --root (bsc#731333)
- version 1.13.13
* Thu Oct  6 2016 ma@suse.de
- addrepo: show repo priority summary (issue #82)
- Color repo priority values
- version 1.13.12
* Tue Sep 20 2016 ma@suse.de
- aptitude: handle --version (fixes #99)
- version 1.13.11
* Fri Sep  9 2016 ma@suse.de
- products --xmlfwd: Literally forward the XML tags found in a
  product file (FATE#320699)
- BuildRequires:  libzypp-devel >= 16.2.3
- man: enhance install/uninstall section
- version 1.13.10
* Wed Aug 10 2016 ma@suse.de
- --no-recommends: don't make an attempt to show recommends/suggests
  as we know there are none (bsc#958161)
- remove dead code
- version 1.13.9
* Wed Aug 10 2016 ma@suse.de
- locks: add parsable XML output (bsc#985390)
- version 1.13.8
* Tue Jul 26 2016 ma@suse.de
- fixup! info: fix --repo also listing all matching installed
  packages (bsc#981743). Muliple commandline arguments cause
  items to be listed nultiple times.
* Tue Jul 26 2016 ma@suse.de
- Prefer option --not-installed-only over the
  misleading --uninstalled-only (bsc#972997)
- version 1.13.7
* Mon Jul 25 2016 ma@suse.de
- info: fix --repo also listing all matching installed packages
  (bsc#981743)
- version 1.13.6
* Thu Jul 21 2016 ma@suse.de
- Differ between products without end-of-life data and those where
  EOL is not yet known (FATE#320699)
- BuildRequires:  libzypp-devel >= 16.2.1
- version 1.13.5
* Fri Jul 15 2016 ma@suse.de
- Update Translations (bsc#968588)
- version 1.13.4
* Mon Jun 27 2016 ma@suse.de
- info: Take care data are in sync with those printed in patch
  related tables. (FATE#320447)
- BuildRequires:  libzypp-devel >= 16.1.0
- Remove dangling wiki link (bsc#986095)
- Patch info: render data the same style as other patch related
  commands do (FATE#320447)
- man: Mention known limitations when searching with --file-list
  (bsc#982379)
- doc: Mention that "zypper mr -n" needs an argument (bsc#984901)
- changes: add reference to bsc#893833
- version 1.13.3
* Sun Jun  5 2016 ma@suse.de
- pchk,lp,patch: Do not install optional patches by default
  (FATE#320447)
- BuildRequires:  libzypp-devel >= 16.0.1
- Notify user if unknown category/severity strings are used on the
  CLI
- Do not require --ignore-unknown in non interactive remove-command
  (bsc#980263)
- version 1.13.2
* Fri May 13 2016 ma@suse.de
- Prepare cmake to maintain the .pot and .po files in git. Add
  initial .po file set derived from tarballs. Translations are now
  maintained via Weblate.
- Fix install/remove commands to be case sensitive (bsc#940477)
- Fix testing for '-- download*' options (bsc#956480)
- Unify code acquiring the zypp lock (bnc#969107)
- Rephrase note if 'lsof' is not installed (bsc#974438)
- search: fix empty search result message (bsc#972999)
- versioncmp: don't check for zypp lock (bsc#970575)
- BuildRequires:  libzypp-devel >= 15.22.1
- version 1.13.1
* Wed Apr 27 2016 ma@suse.de
- Update sle-zypper-po.tar.bz2 (bsc#972768)
* Wed Apr 27 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Apr 17 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Mar 31 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Mar 13 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Mar  9 2016 ma@suse.de
- Bump minor version; 1.12 is continued on SuSE-SLE-12-SP1-Branch
- version 1.13.0
* Wed Mar  9 2016 ma@suse.de
- man: Rephrase unclear explanation of --non-interactive (bsc#969186)
- man: add missing --non-interactive-include-reboot-patches option
- version 1.12.36
* Sun Mar  6 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Mar  3 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 28 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Feb 26 2016 ma@suse.de
- man: Enhance description of Download-and-install mode options
  (bsc#968254)
- version 1.12.35
* Wed Feb 24 2016 ma@suse.de
- Return 106-ZYPPER_EXIT_INF_REPOS_SKIPPED if repos were skipped due
  to a failing refresh (bsc#968006)
- Fix repo import to honor enable and autorefresh flags (bsc#967673)
- fix addlock man page header (boo#966760)
- version 1.12.34
* Thu Feb 18 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Feb 15 2016 ma@suse.de
- products: fix wrong repository shown for installed products
- Fix spec file to use the correct translation set (bnc#948924)
- Fix typos in  man page (bsc#953214)
- version 1.12.33
* Thu Feb 11 2016 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Feb 11 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb  7 2016 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Feb  7 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb  4 2016 ma@suse.de
- Fail if tty is bad or at EOF when reading user input (bsc#965027)
- installSrcPackage: trigger progress callback (bsc#580902)
- version 1.12.32
* Thu Feb  4 2016 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Feb  4 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Feb  2 2016 ma@suse.de
- Don't load repos when removing packages (bsc#606220)
- version 1.12.31
* Sun Jan 31 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan 28 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jan 27 2016 ma@suse.de
- Propagate repo refresh errors even if main action succeeded
  (bsc#961719)
- Fix misaligned TAB stops in colored prompts (bsc#948566)
- version 1.12.30
* Sun Jan 24 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan 21 2016 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Jan 21 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jan 20 2016 ma@suse.de
- Enhance guessing of 'obs://' URLs on openSUSE Leap (bnc#959804)
- Print repository content 'keywords' in repo details
- BuildRequires:  libzypp-devel >= 15.20.1
- version 1.12.29
* Thu Jan 14 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan  7 2016 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec 24 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Dec 23 2015 ma@suse.de
- ref: don't return 0 if repos were skipped (bsc#959564)
- Fix '-y' command option as alias for --non-interactive global
  option (bsc#957862)
- si: Mention location rpm installs source packages to in command
  help and man page (bsc#710541)
- man: explain difference between 'dup' and 'dup --from'
- man: Explain meaning of 'System Packages' and '@System' shown in
  search results (bsc#953458)
- BuildRequires:  libzypp-devel >= 15.19.8
- version 1.12.28
* Sun Dec 20 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Dec 20 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec 17 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec 10 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec  3 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Dec  3 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Nov 27 2015 ma@suse.de
- lu/lp: fix different data returned in xml and text output
  (bsc#793424, bsc#893833)
- lp: Indicate patches requiring a restart of the package manager itself.
  Enhance 'lp -a' Status column.
- pchk: also report needed but locked patches
- download: fixed claiming an error after successful run (bsc#956480)
- Fix tab-completion if zypper is defined as an alias (bsc#955615)
- version 1.12.27
* Thu Nov 26 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Nov 22 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Nov 19 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Nov 19 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Nov 16 2015 ma@suse.de
- createPot: Fix plural form detection (bsc#955053)
- version 1.12.26
* Sun Nov 15 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Nov 12 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Nov  8 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Nov  8 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Nov  6 2015 ma@suse.de
- Fix #83 incomplete bash completion for --type
- Fix typo (bsc#953214)
- Fix miss aligned output when LANG=C (bsc#951707)
- Provide --priority option on addrepo command.
- add/modifyrepo: Support '--priority 0' to restore the default
  repo priority.
- Fixed Japanese translations (bsc#949196)
- version 1.12.25
* Fri Nov  6 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Nov  5 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Nov  5 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Nov  3 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Tue Nov  3 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Oct 26 2015 ma@suse.de
- Add -x shorthand for --match-exact (fixes #64)
- version 1.12.24
* Thu Oct 22 2015 ma@suse.de
- Use a uniform translation set for SLE and openSUSE (bnc#948924)
- Issue 'volatile change' warning when modifying a plugin service
  repo (bnc#951339)
- Fix missaligned output due to changed mbrtowc return value in
  glibc-2.22 (bnc#950869)
- version 1.12.23
* Sun Oct 18 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct 15 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Oct 15 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Oct 14 2015 ma@suse.de
- locks -s: show solvables repositories (bnc#949957)
- version 1.12.22
* Mon Oct 12 2015 ma@suse.de
- fix spec file
- version 1.12.21
* Sun Oct 11 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Oct 11 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct  8 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Oct  8 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Oct  7 2015 ma@suse.de
- fix suse_version test (bsc#949046)
- version 1.12.20
* Wed Oct  7 2015 ma@suse.de
- Show locked packages in summary of patch, up and dup command
  (FATE#318299)
- search: Append 'l' to a locked items status tag (FATE#318299)
- list locks: new command options --matches and --solvables
  to see the resolvables matched by each lock defintion
  (FATE#318299)
- Table: fix details layout to handle multibyte strings correctly
- Rug-compatible mode is no longer available.
- Give ZYPPER_EXIT_ERR_COMMIT priority over ZYPPER_EXIT_ON_SIGNAL
  (bsc#946750, FATE#319467)
- BuildRequires:  libzypp-devel >= 15.19.1
- version 1.12.19
* Thu Oct  1 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Oct  1 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Sep 29 2015 ma@suse.de
- Return ZYPPER_EXIT_ERR_COMMIT if an error occurred during commit
  (bsc#946750, FATE#319467)
- Do not return 0 if a commit was not performed (bsc#946750,
  FATE#319467)
- BuildRequires:  libzypp-devel >= 15.18.0
- version 1.12.18
* Sun Sep 27 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 24 2015 ma@suse.de
- zypper.conf: new option commit/psCheckAccessDeleted to avoid 'lsof'
  call after commit. On some systems 'lsof' seems to perform very
  slow, and the check takes up to several minutes. Due to this it's
  possible to disable the automatic check after each commit. Explicit
  calls to 'zypper ps' are not affected by this option. (bsc#945169)
- zypper.conf: deprecate defining 'installRecommends'; better follow
  the systemwide default in zypp.conf.
- version 1.12.17
* Thu Sep 24 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Sep 24 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Sep 21 2015 ma@suse.de
- ps: add options --short/--print to retrieve services which may
  need to be restarted (FATE#318827)
- fix reserved identifier violation (fixes #79)
- BuildRequires:  libzypp-devel >= 15.17.0
- version 1.12.16
* Thu Sep 17 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Sep 17 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep 13 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Sep 13 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 10 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Sep 10 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Sep  9 2015 ma@suse.de
- patch-check --updatestack-only: Check only for patches which
  affect the package management itself (FATE#319407)
- version 1.12.15
* Tue Sep  8 2015 ma@suse.de
- patch --updatestack-only: Install only patches which affect the
  package management itself (FATE#319407)
- version 1.12.14
* Sun Sep  6 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Sep  6 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep  3 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Sep  1 2015 ma@suse.de
- man: mention new zypp.conf solver.dupAllow* config options
  (FATE#319128)
- add apt-get alias for aptitude
- BuildRequires:  libzypp-devel >= 15.14.0
- version 1.12.13
* Sun Aug 30 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug 27 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Aug 23 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug 20 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Aug 16 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Aug 14 2015 ma@suse.de
- lp: Let '--issue=string' also look for matches in IssueType
  (bnc#941309)
- version 1.12.12
* Thu Aug 13 2015 ma@suse.de
- Support caching of service metadata (FATE#318136)
- BuildRequires:  libzypp-devel >= 15.13.0
- version 1.12.11
* Thu Aug 13 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Aug 10 2015 ma@suse.de
- Adapt to libzypp changes due to FATE#318778
- BuildRequires:  libzypp-devel >= 15.11.0
- version 1.12.10
* Sun Aug  9 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug  6 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Aug  2 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jul 30 2015 ma@suse.de
- Update zypper-po.tar.bz2
- version 1.12.9
* Tue Jul 28 2015 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Tue Jul 28 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Jul 27 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jul 16 2015 ma@suse.de
- Show installed packages in Summary when --no-build-deps is used
  for source-install (fixes #75) (bnc#937770)
* Thu Jul  9 2015 ma@suse.de
- Options to allow vendor locking for zypper dup (FATE#319128)
- version 1.12.8
* Fri Jul  3 2015 ma@suse.de
- summary: show patches requiring reboot (FATE#317872)
- patch: add column showing required interactive actions
  (required reboot, license or message to be confirmed )
- patch: highlight security and critical iptches in tables
- info: arguments explicitly specifying 'kind:name' overrule '-t kind'
- version 1.12.7
* Tue Jun 30 2015 ma@suse.de
- patch: add option to list/install by --severity (FATE#318760)
- version 1.12.6
* Thu Jun 18 2015 ma@suse.de
- Add git-like subcommand support for zypper.
  Zypper subcommands are standalone executables that live in the
  zypper exec dir or are available in your $PATH (see zypper(8)).
- Typos fixed (fixes #74)
- version 1.12.5
* Thu Jun 18 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jun 14 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Jun 12 2015 ma@suse.de
- Use 'openSUSE_$releasever' as default OBS platform (bnc#796689)
- Clarify comment in zypper.conf (bnc#820693)
- Fix format of sizes in output (bnc#897301)
- version 1.12.4
* Thu Jun 11 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jun  7 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jun  4 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jun  3 2015 ma@suse.de
- Tab completion for package names in install+remove+update
  commands (bnc#928650)
- Adapt enterprise product detection (bnc#933277)
- removerepo: Warn user that deleting a service repo is a volatile
  change (bnc#929990)
- version 1.12.3
* Sun May 31 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May 28 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May 24 2015 ma@suse.de
- man: add section about GPG checks
- repos/services: Show GPG Check status
- Handle pkgGpgCheck callback (fate#314603)
- BuildRequires:  libzypp-devel >= 15.3.0
- download: fix wrong total (=0) counter in download message
- download: actually abort on user request.
- Clarify 'zypper lp --date' description (bnc#929593)
- Allow to overlay the default translation set.
- version 1.12.2
* Sun May 24 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May 21 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May 14 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May 10 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Tue May  5 2015 ma@suse.de
- man: clarify zypper download description (fixes #68)
- fix table sort (bnc#832519)
- aptitude: install all package name mappings
- aptitude: re-order rules
- aptitude: apply fedora rules to centos and redhat
- aptitude: require zypper
- aptitude: add os-specific package-maps
- aptitude: add os_is function
- aptitude: add generic python package mapping
- only use ANSI codes on terminals (bnc#925678)
- Don't use color in XML mode.
- version 1.12.1
* Thu Apr 23 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Apr 19 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr 16 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr  9 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Apr  5 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr  2 2015 ma@suse.de
- Fix prompt returning undefined default value after wrong input (bnc#925696)
- aptitude: add some package name mappings
- aptitude: add debian package name mapping mechanism
- aptitude: handle more apt-get operations
- aptitude: ignore --option params
- man: fix typo (bnc#923800)
- Bump minor version for Factory, 1.11 is continued on SuSE-SLE-12-Branch
- version 1.12.0
* Thu Apr  2 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Mar 29 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Mar 26 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Mar 22 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Mar 19 2015 ma@suse.de
- suppress MediaChangeReport while testing multiple baseurls (bnc#899510)
- allow repo:package to reinstall from a different repo (bnc#725867)
- fix wrong description of --force-resolution defaults
- version 1.11.24
* Thu Mar 12 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Mar 11 2015 ma@suse.de
- patch: A date limit must ignore newer patch candidates (bnc#919709)
- modify repo: Notify about volatile changes to service repos (bnc#916254)
- ps: Change column header from 'Login' to 'User' (bnc#915461)
- man: add missing patch --date option
- man: mention $releasever_major/minor repo variables
- man: Update repo variable substitution (default and alternate values)
- version 1.11.23
* Sun Mar  8 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Mar  5 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb 26 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 22 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb 19 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 15 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb 12 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb  8 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb  5 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb  1 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan 29 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jan 25 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Jan 23 2015 ma@suse.de
- repos(lr): Fix wrong exit status using the --xmlout option (bnc#914258)
- version 1.11.22
* Fri Jan 23 2015 ma@suse.de
- Refresh plugin services on 'lr' 'ls -r' and 'ref' (bnc#893294)(FATE#318117)
  Repositories provided by a plugin service (SUSE Manager) must always
  be (auto-)refreshed to reflect server side changes immediately.
- zypper.conf: new color/pkglistHighlightAttribute (bnc#914284)
  Tune the color atrribute used for package list highlighting.
- version 1.11.21
* Thu Jan 22 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jan 18 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jan 14 2015 ma@suse.de
- New global option --releasever: Set the value of the $releasever
  variable in all .repo files. This can be used to switch to new
  distribution repositories when performing a distribution upgrade.
  (bnc#911658)
- BuildRequires:  libzypp-devel >= 14.34.0
- Clarify legacy warning (bnc#911335)
- version 1.11.20
* Sun Jan 11 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan  8 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jan  7 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan  1 2015 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Dec 21 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Dec 19 2014 ma@suse.de
- info: show new product:registerflavor attribute (bnc#896224)
- version 1.11.19
* Thu Dec 18 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Dec 17 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Dec 17 2014 ma@suse.de
- Enhance 'Digest verification failed' message (FATE#315008)
- Enhance message text when skipping repos due to an error (bnc#909244)
- zypper.conf: fix wrong default mentioned in comment
- zypper-log(8): Update man page
- version 1.11.18
* Thu Dec 11 2014 ma@suse.de
- Add --[no-]color global option
- Fix additional spaces in zypper output and
  new colorization code (bnc#908345)
- properly reset auto-retry counter (bnc#906549)
- man: improve patch description (bnc#904737)
- version 1.11.17
* Tue Nov 11 2014 ma@suse.de
- Warn about repositories with 'gpgcheck=0' (bnc#848054)
- search: fix --verbose implies --details
- Enhance 'Digest verification failed' dialog (FATE#315008)
- Summary: quote names including spaces (bnc#903675)
- version 1.11.16
* Mon Nov  3 2014 ma@suse.de
- Provide missing man pages (fixes #51)
- Create man pages from asciidoc (fixes #53)
- Warn if legacy CLI options are used (bnc#899781)
- version 1.11.15
* Thu Oct 16 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Oct 13 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Oct 12 2014 ma@suse.de
- Update zypper-po.tar.bz2 (bnc#899603)
* Fri Oct 10 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct  9 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Oct  5 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep 28 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 25 2014 ma@suse.de
- Trigger appdata plugin when system repos have changed (bnc#866257)
- SLE-12 (suse_version 1315) uses it's own translations set (bnc#897176)
- version 1.11.14
* Sun Sep 21 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 18 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Sep  5 2014 ma@suse.de
- Adapt to new zypp api (bnc#892579)
- version 1.11.13
* Thu Sep  4 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Aug 29 2014 ma@suse.de
- download: use $XDG_CACHE_HOME/zypp/packages for non-root user
  (bnc#891515)
- download --dry-run: list packages we would download
- Accept -f,--force option with refresh-services(refs)
- version 1.11.12
* Sun Aug 24 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug 21 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Aug 18 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Jul 25 2014 ma@suse.de
- Rephrase 'verify' help text (bnc#885499)
- version 1.11.11
* Mon Jul 14 2014 ma@suse.de
- refresh-services: add option --restore-status to undo user
  modifications applied to service repositories
- drop rug compatibility in manpage docs and help output
  (FATE#317708)
- version 1.11.10
* Fri Jul 11 2014 ma@suse.de
- Enable --plus-content option (FATE#316287)
- Add symlink yzpper -> zypper (bnc#885655)
- version 1.11.9
* Wed Jun 11 2014 ma@suse.de
- Show patch severity (bnc#881373,FATE#312633)
- Add '--details' to show the detailed installation summary (bnc#721823)
- version 1.11.8
* Wed May 14 2014 ma@suse.de
- Notify about cached packages in download progess
- Adjust download size by already cached packages in summary
- Don't suggest 'zypper ps' after commit if --download-only
- version 1.11.7
* Thu May  8 2014 ma@suse.de
- Notify user about expiring trusted keys; show trusted keys in
  verbose mode.
- Enable --with-interactive for update too (bnc#827953)
- Highlight missing update repos in product info
- version 1.11.6
* Sun May  4 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May  1 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Apr 29 2014 ma@suse.de
- download: fix xml output when already cached
- version 1.11.5
* Tue Apr 15 2014 ma@suse.de
- Add 'download' command (Fate#317077)
- version 1.11.4
* Sun Apr 13 2014 ma@suse.de
- more duplicate short options fixes
- Fix typo in manpage
- version 1.11.3
* Fri Apr 11 2014 ma@suse.de
- packages: Remove conflicting short options (-r repo/recommends)
- version 1.11.2
* Fri Apr  4 2014 ma@suse.de
- info product: show CPEid and report enabled/missing update repos
- Warn if /etc/products.d/baseproduct symlink is missing.
- version 1.11.1
* Thu Mar 20 2014 ma@suse.de
- Add summary messages for application (bnc#869439)
- Rephrase some 'zypper ps' related messages (bnc#866300)
- Message about uninstallable patters is obsolete (bnc#869616)
- version 1.11.0
* Tue Mar 18 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 23 2014 ma@suse.de
- Don't include suggested packages in pattern content, as we can't
  handle them (bnc#857671)
- Fix computation of pattern status (bnc#864412)
- fix wrong processing of translated plural forms (bnc#756195)
- Fix result list of 'packages' command (bnc#864198)
- version 1.10.8
* Fri Feb 14 2014 ma@suse.de
- Print Content Ids of required update repos in product info (Fate#316160)
- Update man page
- version 1.10.7
* Tue Feb 11 2014 ma@suse.de
- Show Product::endOfLife attribute in product info (Fate#316172)
- Fix missing description tags and escaping in XML output.
- Remove license text from test data (bnc#862471)
- Add info command options to print dependencies.
- version 1.10.6
* Sun Feb  2 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan 30 2014 ma@suse.de
- Fix eating all memory if stdout is not a tty.
- version 1.10.5
* Thu Jan 30 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jan 29 2014 ma@suse.de
- Don't treat missing packages due to download mode as error in
  fileconflict check.
- Add --replacefiles option to resolve file conflicts (bnc#673720)
- version 1.10.4
* Sun Jan 26 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Jan 24 2014 ma@suse.de
- Add fileconflicts report (bnc#673720)
- version 1.10.3
* Thu Jan 23 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Jan 20 2014 ma@suse.de
- Zypper must refresh CD/DVD if no raw metadata are present. (bnc#859160)
- Don't read metadata from CD/DVD repo if --no-check was used (bnc#859160)
- Fix filelist search to match full paths instead of basenames only (bnc#859211)
- Fix missing priority in RepoInfo::dumpAsXML (bnc#855845)
- Rephrase 'Disabling repository...' message (bnc#856809)
- Hint to SDB and openSUSE release notes
- Add note that openSUSE only supports "zypper dup" one release at a time.
- Fix grof .TP commands in manpage (bnc#854784)
- Fix detailed printing of query matches (bnc#853167)
- version 1.10.2
* Thu Jan 16 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jan 12 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan  9 2014 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Nov 21 2013 ma@suse.de
- Embed item count in summary output (bnc#756195)
- Fix callback handling if media download error is ignored.
- Fix detection of multiversion packages in transaction summary (bnc#844373)
- Improve prompt with more options hidden behind '?' (bnc#844373)
- Improve computation of unneeded packages
- Fix message typo (bnc#845619)
- version 1.10.1
* Sun Oct 13 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct 10 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Oct  7 2013 ma@suse.de
- Avoid duplicated product entries (bnc#841473)
- Bump  version for Factory
  13.1 is continued on SuSE-Code-13_1-Branch
- version 1.10.0
* Sun Oct  6 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct  3 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Sep 30 2013 ma@suse.de
- Suppress duplicate "No package matching" messages (bnc#725872)
- Fix 'zypper --root sh' creating the zypp lockfile outside chroot (bnc#575096)
- Fix exception thrown if no config file exists, that's no error.
- correct command help for search option --suggests
- add --orphaned, --suggested, --recommended, --unneeded to 'zypper packages'
- Fix inappropriate message about not installed recommend package (bnc#826973)
- version 1.9.2
* Sun Sep 29 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 26 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep 22 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 19 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep 15 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 12 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep  8 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep  5 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep  1 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug 29 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug 22 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Aug 18 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug 15 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Aug 11 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug  8 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Aug  4 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug  1 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jul 28 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jul 11 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jul  4 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jun 30 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jun 19 2013 ma@suse.de
- Set default zypper.log mode to 0640 (bnc#825490)
- version 1.9.1
* Sun May 26 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May 23 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May 19 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May 12 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May  9 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Fri May  3 2013 ma@suse.de
- Add -E, --show-enabled-only option to list repos/services command
  (FATE#314994)
- version 1.9.0
* Thu May  2 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Apr 28 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr 18 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr 11 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Apr  5 2013 ma@suse.de
- Added new option 'download-only' to source-install (bnc #640403)
- Show the right product in summary (bnc#811997)
- version 1.8.14
* Thu Apr  4 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Mar 26 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Mar 26 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Mar 19 2013 ma@suse.de
- disable repo permanently if required by user
- also search in file list when searching for a path name in
  provides (bnc #798290)
- add option --verbose to search command (show details about matches)
- enable substrings and wildcards for 'info' (bnc #741758)
- add search for provides, requires, conflicts, suggests and obsoletes,
  search for capabilities
- version 1.8.13
* Sun Mar 10 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Mar  4 2013 ma@suse.de
- Fix 'zypper lu' also listing products (bnc#779740)
- Fix -x printing edition values for arch-old (bnc#793809)
- version 1.8.12
* Sun Mar  3 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb 28 2013 ma@suse.de
- fix zypper disregarding zypp.conf cache path settings (bnc#806568)
- Allow re-install with different arch upon explicit request (bnc#804219)
- version 1.8.11
* Thu Feb 28 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 24 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb 21 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 17 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb 14 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 10 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb  7 2013 ma@suse.de
- zypper commandline args must not silently overrule locks
  (bnc#742633,bnc#788863)
- version 1.8.10
* Thu Feb  7 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Feb  4 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jan 30 2013 ma@suse.de
- Add '--oldpackage' to allow rollback without malicious --force
  (bnc#795076)
- Add missing --recommends to verify command (bnc#722551)
- version 1.8.9
* Fri Jan 18 2013 ma@suse.de
- Add source-download command (fate#313445)
- Fixing permissions is obsolete since zypper refresh wrapper has
  been dropped (bnc#764119)
- Fix excess whitespace in install counter (bnc#674572)
- version 1.8.8
* Thu Jan 17 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jan 13 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan 10 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan  3 2013 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec 27 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec 20 2012 ma@suse.de
- Fix install counter (bnc#793285)
- Add an "--ignore-unknown" global option to zypper.
- Show installation progress (bnc #779427)
- version 1.8.7
* Thu Dec 20 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Dec 16 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Dec  9 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec  6 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Nov 22 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Nov 18 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Nov 15 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Nov 13 2012 ma@suse.de
- Add global '--userdata' option to allow defining transaction ids (fate#312521)
- BuildRequire libzypp supporting userdata transaction ids.
- Fix 'whatprovides' output (bnc#787318)
- version 1.8.6
* Thu Nov  1 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Oct 28 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct 25 2012 ma@suse.de
- Fix source-install to accept package names and lookup their
  source package (bnc#785832)
- version 1.8.5
* Wed Oct 24 2012 ma@suse.de
- return dedicated error code if libzypp is locked (bnc #772353)
- Don't ask for license agreement for openSUSE (bnc #780659)
- add patch/list-patches option --category to man
- Fix zypper output if stdout is not a tty (bnc#779716)
- version 1.8.4
* Thu Oct 18 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 27 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep 23 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 20 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep 16 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Sep 12 2012 ma@suse.de
- Use edition style on table columns in color mode
- Reload target before executing a new command in 'zypper shell'
  (bnc #767880)
- version 1.8.3
* Tue Sep 11 2012 ma@suse.de
- show reason for not installed recommended packages (bnc #698766)
- version 1.8.2
* Mon Sep 10 2012 ma@suse.de
- Rephrase misleading sections about zypp.conf and zypper.conf
  (bnc#777323)
- Enable zypper-log reading lzma (.xz) compressed logs.
- properly encode data in XML output (bnc#773641)
- version 1.8.1
* Sun Sep  9 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug 30 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug  2 2012 ma@suse.de
- Bump version for Factory
  1.7.x is continued on SuSE-Code-12_2-Branch
- version 1.8.0
* Thu Aug  2 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jul 29 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jul 19 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jul 12 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jul  5 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jul  1 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jun 28 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Jun 25 2012 ma@suse.de
- Fix spacing bug in progress bar (bnc#674572)
- consider dual width fonts in output (bnc#766443)
- Don't treat patches with licensed packages as interactive if
  - -auto-agree-with-licenses is used (bnc#730824)
- version 1.7.3
* Sun Jun 24 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jun 14 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jun 10 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jun  7 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jun  3 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May 31 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May 27 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May 24 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May 20 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu May 17 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May 13 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun May  6 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Apr 29 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr 26 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Apr 24 2012 ma@suse.de
- More fixes for multibyte string output (bnc#735016)
- version 1.7.2
* Sun Apr 22 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr 19 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Apr 18 2012 ma@suse.de
- Some progress bar fixes
- Fix eating terminal lines (bnc#735016)
* Mon Apr 16 2012 ma@suse.de
- Let zypper remove lock follow addlock with respect to args and behavior (bnc#751976)
- Typo (bnc#756192)
- Improve source package related messages upon install and remove (bnc#755239)
- Pass --root to libzypp early so lockfile is created chroot (bnc#575096)
- Do not acquire a zypp lock for 'zypper ps' (bnc#703598)
- Show note about possibly incomplete 'zypper ps' if not run as root (bnc#710872)
- version 1.7.1
* Sun Apr 15 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr 12 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Apr 10 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Apr  8 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Apr  5 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Mar  1 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Feb 26 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb 23 2012 ma@suse.de
- Fix augeas lense enforcing a non empty anonymous section (bnc#748144)
* Thu Feb  9 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Feb  2 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jan 29 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jan 22 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Jan 15 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jan 12 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jan 11 2012 ma@suse.de
- Fix man page --cache-dir description. (bnc#738677)
* Tue Jan 10 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Jan 10 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Jan 10 2012 ma@suse.de
- Return nonzero (104 - INF_CAP_NOT_FOUND) when query matches no
  package (bnc#719690)
* Mon Jan  9 2012 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Dec 22 2011 ma@suse.de
- Remove setuid root binary /usr/sbin/zypp-refresh-wrapper (bnc#724832)
* Wed Dec 21 2011 ma@suse.de
- Fix zypp.conf lens (bnc#687530)
- New subpackage zypper-aptitude
- version 1.7.0
* Mon Dec 19 2011 ma@suse.de
- Update manpage to give some repo URI examples (bnc#680630)
* Tue Dec  6 2011 ma@suse.de
- Print patch summary (bnc#733167)
- zypper-log: fix regex to match hostnames with embeded '-' too.
- version 1.6.18
* Thu Dec  1 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Nov 30 2011 ma@suse.de
- Eat trailing whitespace in zypper.conf (bnc#687530)
- Fix some static initializer issues
* Sun Nov 27 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Nov 22 2011 dheidler@suse.de
- zypper-log: fixed bnc#732065:
  Don't truncate output, when writing to pipe
- version 1.6.17
* Sun Nov 20 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Nov 17 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Mon Nov 14 2011 ma@suse.de
- Never evaluate package support status on openSUSE (bnc#715057)
* Sun Nov 13 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Nov 10 2011 ma@suse.de
- Relax parsing obs:// urls (bnc#713521)
* Sun Nov  6 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Nov  4 2011 ma@suse.de
- zypper-log: fix regex and on the fly support searching yast logs too
* Thu Nov  3 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Oct 30 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct 27 2011 dheidler@suse.de
- Change zypper-log arch to noarch
* Thu Oct 27 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct 20 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Oct 16 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct 13 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Oct  9 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Oct  6 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 29 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep 18 2011 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Sep 18 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep 15 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Sep 13 2011 ma@suse.de
- Fix 'zypper info's report of package support status (bnc#651614)
- version 1.6.16
* Sun Sep 11 2011 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Sep 11 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep  8 2011 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Sep  8 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Sep  4 2011 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Sun Sep  4 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Sep  1 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Aug 30 2011 ma@suse.de
- Restore default behavior for newly create repos to have gpg checks
  enabled. This was accidentally disabled in 1.6.2. (bnc#714910,
  bnc#524787)
- version 1.6.15
* Thu Aug 25 2011 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Mon Aug 22 2011 ma@suse.de
- Update sle-zypper-po.tar.bz2
* Thu Aug 18 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Aug 14 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Sun Aug  7 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Aug  4 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Fri Jul 22 2011 ma@suse.de
- Fix missing include header.
* Thu Jul 21 2011 ma@suse.de
- Fix 'zypper search' xml output (bnc#687529)
- version 1.6.14
* Tue Jul 19 2011 dheidler@suse.de
- zypper-log: require python2.6 and argparse insted of 2.7
    on suse < 11.4
- zypper-log: fix dependencies for other distros
* Wed Jul 13 2011 dheidler@suse.de
- zypper-log: view better error msg when logfile doesn't exist
* Thu Jul  7 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Thu Jun 30 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Tue Jun 28 2011 dheidler@suse.de
- better error msg for date format missmatch in zypper-log
- 1.6.13
* Tue Jun 28 2011 dheidler@suse.de
- enable date option also for PID-Query in zypper-log
- check date syntax in zypper-log
- 1.6.12
* Mon Jun 27 2011 dheidler@suse.de
- Catch Broken-PIPE Exception in zypper-log
- 1.6.11
* Sun Jun 19 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jun 15 2011 dheidler@suse.de
- Add zypper-log tool (cli to access zypper logfile)
* Thu Jun  9 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jun  8 2011 ma@suse.de
- Update zypper-po.tar.bz2
* Wed Jun  8 2011 ma@suse.de
- Adapt to changed ZYppCommitResult api.
* Mon Jun  6 2011 dheidler@suse.de
- fix crashing zypper when there are double config entries
  in zypper.conf (bnc#614646)
- 1.6.10
* Tue May 31 2011 ma@suse.de
- No longer use deprecated ZYppCommitResult methods.
- 1.6.9
* Tue May 31 2011 ma@suse.de
- Correctly print exception history (bnc#655402)
* Mon May 30 2011 dheidler@suse.de
- use the tag-based patch-interactive interface of libzypp
- 1.6.8
* Wed May 25 2011 dheidler@suse.de
- rename an option
  old: --reboot-not-interact
  new: --non-interactive-include-reboot-patches
- 1.6.7
* Tue May 24 2011 dheidler@suse.de
- add option --reboot-not-interact (bnc#665853)
- allow installation of paches wich require a reboot
  non-interactively
- 1.6.6
* Thu May 19 2011 dheidler@suse.de
- don't install prompt.h - use "zypper --promptids" instead
  (bnc#637352)
- 1.6.5
* Wed May 18 2011 dheidler@suse.de
- print warning when searching in disabled repo (bnc#661976)
- 1.6.4
* Fri May 13 2011 ma@suse.de
- fix get_installed_providers by capability not to use selectables
  (bnc#693576)
- 1.6.3
* Thu May  5 2011 dheidler@suse.de
- add option to set/change gpgcheck flag for repos (bnc#524787)
- 1.6.2
* Tue Apr 26 2011 dheidler@suse.de
- suppress success message, when adding lock failed (bnc#539159)
- 1.6.1
* Mon Apr 18 2011 dmacvicar@suse.de
- fate#312127 list patches until certain date only
* Fri Apr 15 2011 ma@suse.de
- Fix list-patches/updates xml output to include architecture and
  patch status information (bnc#687529)
- Fix search xml output to actually write xml. (bnc#687529)
- 1.5.8
* Tue Apr 12 2011 dheidler@suse.de
- use old repo cache when refresh failed for non-root users
  (see bnc#683509)
- 1.5.7
* Mon Apr 11 2011 dheidler@suse.de
- detect terminal linebreak when printing status (bnc#304282)
- 1.5.6
* Thu Apr  7 2011 dheidler@suse.de
- zypper patch/lp category filter (fate#310085)
- 1.5.5
* Fri Mar 18 2011 dmacvicar@suse.de
- zypper -n display license interactively (bnc#660001)
  Patch by Bernhard Wiedemann <bwiedemann@suse.de>
- 1.5.4
* Mon Jan 17 2011 ma@suse.de
- Don't perform automatic service refresh if non-root user.
* Fri Jan 14 2011 ma@suse.de
- Report service plugin excetions during refresh, but continue.
* Thu Dec 23 2010 dheidler@suse.de
- view mirrorlist-url when there is no baseurl set (in the repo-file)
- 1.5.3
* Mon Dec  6 2010 dheidler@suse.de
- Try not to fail, when there is no baseurl (bnc#650920)
- 1.5.2
* Tue Nov 30 2010 jkupec@suse.cz
- do not autorefresh services if --no-refresh is given
- load target before refreshing services
* Tue Nov 23 2010 ma@suse.de
- Print error message if 'zypper ps' fails. (bnc #655402)
* Mon Nov  8 2010 jkupec@suse.cz
- modifyrepo: exit with error if repo not found (bnc #650822)
* Sun Oct 31 2010 jkupec@suse.cz
- Fixed multiversion packages incorrectly shown in "not updated"
  list (bnc #629197).
* Sat Oct 30 2010 jkupec@suse.cz
- Summary: fixed not shown "not updated" list when there were no
  installable updates when doing 'zypper up' (bnc #594282)
* Fri Oct 29 2010 jkupec@suse.cz
- Clear keyboard buffer before showing the prompt message
  to avoid unwanted <enter> hits (bnc #649248)
* Mon Oct 25 2010 jkupec@suse.cz
- Tell about download-only switched on (bnc #648606)
* Wed Oct 20 2010 jkupec@suse.cz
- zypper in --force plainpkgname (no repo,EVRA) to request install
  of the highest version regardless of vendor/deps/locks.
  (bnc #483426)
- 1.5.1
* Tue Oct 19 2010 jkupec@suse.cz
- Proper hint for forcing downgrade of a package (bnc #620377)
* Tue Oct 19 2010 jkupec@suse.cz
- Summary: ignore arch changes in the "not installed updates" list
  (bnc #646410)
* Mon Oct 18 2010 jkupec@suse.cz
- Make repository list data (repos/lr) configurable (bnc #543510)
- Also load the solv file when refreshing to ensure it was created
  with proper version of satsolver-tools (bnc #456718)
* Mon Oct 18 2010 jkupec@suse.cz
- Fixed 'patch --skip-interactive' (bnc #647214)
* Fri Oct 15 2010 jkupec@suse.cz
- Auto-refresh services before loading repos.
* Thu Oct 14 2010 jkupec@suse.cz
- Make sure package gets installed from given .rpm file, not
  repository (bnc #524280)
- Better message in case non-root tries to access
  /etc/zypp/credentials.d to get credentials for authenticated URL
  (bnc #448736)
* Tue Oct 12 2010 jkupec@suse.cz
- Skip locked patches in 'patch' and 'list-patches' (bnc #420606)
- Added Status to 'lp --issues' table
* Mon Oct 11 2010 jkupec@suse.cz
- Do not report changing to equivalent vendors as a vendor change
  (bnc #605380)
- In install summary, show version for packages which have multiple
  versions installed (bnc #644820)
- 1.5.0
* Wed Oct  6 2010 jkupec@suse.cz
- Use original user package string when reporting problems
  (bnc #642051)
* Mon Sep 20 2010 jkupec@suse.cz
- Fixed unrecognized patchname-with-version (bnc #640399)
* Thu Sep  9 2010 jkupec@suse.cz
- Fixed zypper.conf parsing: allow white space before key=value.
* Fri Aug 13 2010 dmacvicar@suse.de
- add -lrt to build on Fedora
* Tue Jul 27 2010 ma@suse.de
- Fix evaluation of package specs containing edition or arch.
  (bnc#624320)
- 1.4.7
* Fri Jul 23 2010 jkupec@suse.cz
- Fixed wiki links in the man page (bnc #623860)
* Thu Jul 15 2010 jkupec@suse.cz
- Use getpass() from stduni.h instead of our own function.
  Fixes bnc #619196
- updated translations
- 1.4.6
* Tue Jul 13 2010 jkupec@suse.cz
- Show support level in package info when running on SLE
  (bnc #599154)
* Fri Jul  2 2010 ma@suse.de
- Let zypper manpage be found via `apropos`. (bnc#613198)
* Thu Jun 10 2010 jkupec@suse.cz
- Enabled obs:// URI in addrepo (bnc #423098).
- updated translations
- 1.4.5
* Mon May 17 2010 jkupec@suse.cz
- --clean-deps added to 'remove' command. The otion tells the
  solver to remove any packages that become unneeded after removing
  a packages that depended on them.
  - -no-clean-deps also added, to override zypp.conf's
  solver.cleandepsOnRemove setting.
- Check for running pkgkit only if acquiring of zypp lock actually
  fails (bnc #580513)
- Use --cache-dir as base for other --*-cache-dir options.
  - -pkg-cache-dir and --solv-cache-dir added
- If name-version is auto-split, don't try caps (bnc #600471)
- updated translations
- 1.4.4
* Tue May 11 2010 ma@suse.de
- Show gpg keys creation and expire dates when asking to trust.
* Thu May  6 2010 jkupec@suse.cz
- Fixed empty 'not updated' lists (bnc #600134).
- 1.4.3
* Mon May  3 2010 ma@suse.de
- Don't suggest "zypper ps" after update, if zypper itself is the only
  process with deleted files open.
* Wed Apr 28 2010 ma@suse.de
- Fix 'zypper ps' not printing the first file twice. (bnc#599265)
* Wed Apr 28 2010 ma@suse.de
- Fix segv when printing solver feedback. (bnc#600236)
* Mon Apr 26 2010 jkupec@suse.cz
- Fixed ignored --download-* options (bnc #598268).
* Mon Apr 19 2010 jkupec@suse.cz
- Package selection code rewritten. Enabled unified package
  arguments ([+/-]repo:type:nameOPversion.arch) for in/up/rm
  commands.
- 1.4.2
* Thu Apr  1 2010 jkupec@suse.cz
- Merged rpm .spec file cleanup (Pavol Rusnák)
- Fixed crash if no available packages found in repos (bnc #591760)
- 1.4.1
* Fri Mar 26 2010 jkupec@suse.cz
- --label added to 'targetos' command (bnc #586303)
* Tue Mar 23 2010 jkupec@suse.cz
- Fixed "removed locks:" message not translated (bnc #581332)
* Tue Mar 23 2010 jkupec@suse.cz
- Fixed 'lp --issues' and 'patch --cve #' (bnc #589640)
* Thu Mar 18 2010 jkupec@suse.cz
- Showing full product name in summary, license text, and products
  table (bnc #589333)
* Wed Mar 17 2010 jkupec@suse.cz
- Reporting why specified selectable can't be updated
  in 'zypper in packages' or 'zypper up packages' (bnc #522223)
  In case of 'zypper up' the summary also shows a list of packages
  that have update candidates, but will not get upgraded.
- 1.4.0
* Wed Mar  3 2010 jkupec@suse.cz
- Ignoring trailing slash when matching repos by URL (bnc #585082)
* Tue Mar  2 2010 jkupec@suse.cz
- Checking for running PackageKit. If it's running zypper offers
  to suggest to it to quit (bnc#580513).
* Mon Mar  1 2010 jkupec@suse.cz
- Show installed packages only from specified repos when
  'zypper [-i|-u] -r repo' is used (bnc#467106)
- 1.2.21
* Thu Feb 25 2010 jkupec@suse.cz
- Added a few forgotten strings for translation (bnc #581332)
* Thu Feb 25 2010 ma@suse.de
- Fix SEGV in Summary::writeResolvableList
- 1.2.20
* Tue Feb 23 2010 jkupec@suse.cz
- Avoid a newline in 'zypper --quiet list-patches' (bnc #523573)
* Tue Feb 23 2010 jkupec@suse.cz
- Showing packages that need additional customer contract
  separately in the installation summary (bnc #581926 c#6)
* Mon Feb 22 2010 jkupec@suse.cz
- Avoiding confirmation of unchanged license on upgrade
  (bnc #394396)
- 1.2.19
* Sun Feb 21 2010 jkupec@suse.cz
- clean --all: clean also garbage and zypper cache (bnc #467693)
- 1.2.18
* Fri Feb 19 2010 jkupec@suse.cz
- Fixed broken --type (bnc #580571)
* Wed Feb 10 2010 ma@suse.de
- Fix 'zypper products' failing to list installed products under
  certain conditions (bnc #578721)
- Fix SEGV if $HOME or $PWD are unset in the environment (bnc #578684)
- 1.2.17
* Mon Feb  8 2010 jkupec@suse.cz
- Replaced .po files in source tree by tarballs.
- updated translations + SLE11-SP1 translations added
- 1.2.16
* Wed Feb  3 2010 jkupec@suse.cz
- Exit if missing required option argument.
- Start using Capability::guessPackageSpec to parse package
  arguments.
- man page updated (bnc #576080)
- 1.2.15
* Sat Jan 30 2010 jkupec@suse.cz
- Fixed ignored .arch when specifying packages as name.arch
  (bnc #561294)
* Wed Jan 27 2010 jkupec@suse.cz
- Setting --root correctly when working with lock (reported by Uwe)
* Wed Jan 27 2010 jkupec@suse.cz
- Correctly abbreviate strings with non-ascii characters in tables
  (bnc #393723)
* Thu Jan  7 2010 jkupec@suse.cz
- Avoid overwriting progress lines with other messages
  (bnc #495977)
* Wed Jan  6 2010 jkupec@suse.cz
- Fixed --no-force-resolution help text (bnc #535816)
* Wed Dec  9 2009 jkupec@suse.cz
- zypper.conf: main.showAlias option added to choose between
  alias and name for showing repos
* Tue Dec  8 2009 jkupec@suse.cz
- search, pt: hide patterns flagged user invisible (bnc #538152)
* Fri Dec  4 2009 jkupec@suse.cz
- Report invalid alias exception from libzypp (bnc #473834)
- 1.2.14
* Fri Dec  4 2009 jkupec@suse.cz
- Match repositories also by name wherever repository is expected
  (bnc #462697).
* Thu Dec  3 2009 jkupec@suse.cz
- Show truely all updates when --all is used (bnc #557557)
- 1.2.13
* Wed Dec  2 2009 jkupec@suse.cz
- new prompt options for media errors:
  * cd/dvd: 'e' to eject selected drive (bnc #279045)
  * https: 's' to disable SSL CA check (bnc #223512)
* Fri Nov 27 2009 jkupec@suse.cz
- solver.forceResolutionCommands added to zypper.conf to
  configure commands in which forceResolve solver option
  should be set (bnc #549940)
- --download-* aliases added for --download <mode> option values
- 1.2.12
* Fri Nov 20 2009 jkupec@suse.cz
- --download option added to in, up, dup, ve, and patch commands
  to set the package download mode ad-hoc. Available download
  modes: only, in-advance, in-heaps, as-needed.
- Show update notifications after installation (fate #301175)
- 1.2.11
* Fri Nov 20 2009 jkupec@suse.cz
- dist-upgrade: warn about muliple repos and show hint. This
  is a temporary solution to fate #305553.
* Thu Nov 19 2009 jkupec@suse.cz
- Show recommended and suggested packages in summary (fate #303493)
* Tue Nov 10 2009 jkupec@suse.cz
- --gpg-auto-import-keys global option added (fate #307087)
* Tue Nov 10 2009 jkupec@suse.cz
- --with-interactive option added to 'patch' command (bnc #497711)
* Fri Nov  6 2009 ma@suse.de
- Fix zypper to use up-to-date RepoInfos. (bnc #544432)
- 1.2.10
* Fri Nov  6 2009 jkupec@suse.cz
- fixed wrong package counting during installation (bnc #545295)
* Fri Nov  6 2009 ma@suse.de
- al/rl: Support 'kind:name' notation if -t is not given. Also required
  to remove a specific lock as rl does not yet support -t. (bnc 551956)
* Wed Nov  4 2009 jkupec@suse.cz
- updated translations
* Tue Nov  3 2009 ma@suse.de
- Fix typo in man page. (bnc #552265)
* Mon Nov  2 2009 ma@suse.de
- Prevent clipping lines when output is redirected. (bnc #551744)
- 1.2.9
* Fri Oct 30 2009 ma@suse.de
- Fix 'zypper in --from' selecting the wrong packages. (bnc #548392)
- 1.2.8
* Fri Oct 23 2009 ma@suse.de
- Fix 'dup --from' not to perform a complete distupgrade. (bnc #549490)
- Require at least libzypp version used at buildtime. (bnc #549205)
- 1.2.7
* Fri Oct 23 2009 jkupec@suse.cz
- Fixed unintentional hiding of the 'p' install summary option
  (bnc #549183)
* Wed Oct 21 2009 ma@suse.de
- Fix abort on 'zypper lu -a'. (bnc #548752)
- 1.2.6
* Mon Oct 12 2009 jkupec@suse.cz
- 'zypper lr' now shows details about repos specified as arguments.
- Added '--from' to 'zypper dup' to do the upgrade from
  specified repos only.
- Translations updated
- 1.2.5
* Tue Sep 29 2009 jkupec@suse.cz
- Fixed wrong update candidate selection (bnc #539360)
- Translations updated
* Wed Sep 23 2009 jkupec@suse.cz
- Fixed troubleshooting wiki link (bnc #533606)
* Mon Sep 21 2009 jkupec@suse.cz
- 'zypper ps' added to list processes using deleted files
  (fate #300763). This is instead of showing the list after each
  commit.
* Fri Sep 18 2009 ma@suse.de
- Remove connection to dead zypp::ScanDBReport.
* Wed Sep 16 2009 ma@suse.de
- Fix zyppers installRecommends option not following the zypp.conf
  setting. (bnc #539579)
* Thu Sep 10 2009 jkupec@suse.cz
- Fixed wrong table column width computation causing excessive
  output (bnc #534795)
* Thu Sep  3 2009 jkupec@suse.cz
- Showing running processes using files deleted by recent package
  upgrade/downgrade or removal (fate #300763).
* Thu Aug 27 2009 mvidner@suse.cz
- 1.2.3, by popular demand
* Mon Jul 27 2009 jkupec@suse.cz
- Fixed installing rpms with epoch (bnc #404048)
* Mon Jul 27 2009 jkupec@suse.cz
- --download-only option added for in, up, patch, dup, and ve
  command (fate #302159)
* Thu Jul 16 2009 jkupec@suse.cz
- list-updates: show also current installed version (bnc #466599)
- 1.2.2
* Wed Jul 15 2009 jkupec@suse.cz
- Manage updates for bugzilla and CVE issues (fate #305503).
  Following options added to lu and patch commands:
  * list-updates: --bugzilla, --cve, --issues, --all
  * patch: --bugzilla, --cve options added
  See 'man zypper' for more details.
* Thu Jul  9 2009 jkupec@suse.cz
- Enable use of name-version.arch all together (bnc #519312).
- Improved description in .spec file
- Show verbose summary when -v is used (bnc #517171).
  If -v is used, version are shown, if -vv is used, all the package
  details are shown in the installation summary.
* Wed Jul  8 2009 ma@suse.de
- Remove references to deprecated UpgradeStatistics.
* Mon Jun 29 2009 jkupec@suse.cz
- Updated translations.
- 1.2.1
* Mon Jun 29 2009 jkupec@suse.cz
- now 'list-patches' does not hide other updates if software
  management updates (which are to be installed before any other)
  are available. (bnc #503068)
- fixed a bug in selection of updates in 'zypper patch'
  (bnc #498814)
* Tue Jun 23 2009 jkupec@suse.cz
- Handle multiple versions of the same package in summary
  (bnc #389128).
* Mon Jun  8 2009 jkupec@suse.cz
- some code cleanup and fixes
- show arch & repo in 'products'
- 1.2.0
* Thu Jun  4 2009 ma@suse.de
- Adapt to libzypp-6.8.0 api changes.
* Fri May 22 2009 jkupec@suse.cz
- Fixed some help issues (bnc #505938)
* Sun Apr 26 2009 jkupec@suse.cz
- config file handling improved, --config option added to load
  custom config files instead of the default ones.
  Override priority order with --config (highest to lowest):
  * CLI options
  * --config custom/zypper.conf
  * zypp.conf
* Sat Apr 25 2009 jkupec@suse.cz
- Highlighting package count numbers in the summary.
* Wed Apr 15 2009 jkupec@suse.cz
- Fixed requesting of perl symbols in 'install'. E.g.
  zypper install 'perl(MIME::Lite)' (bnc #433679)
- Corrected list of repo priority in 'repos' and 'services' command
  (bnc #436688) (Susanne Oberhauser <froh@novell.com>)
* Thu Apr  2 2009 jkupec@suse.cz
- configuration file support added. Global settings go to
  /etc/zypp/zypper.conf, user's to $HOME/.zypper.conf.
  Override priority order (highest to lowest):
  * CLI options
  * --config custom/zypper.conf
  * $HOME/.zypper.conf
  * /etc/zypp/zypper.conf
  * zypp.conf
- configurable colorized output added
- improved installation summary (bnc #389128). Allows to view
  version, arch, repo, vendor; view the summary in pager,
  shows installed package counts
- xmloutput now writes also old version and old arch in summary
  (bnc #331060)
- zypper.conf: solver/installRecommends option added, along with
  - -recommends option for in, up, patch, ve, and dup commands
  to override zypper.conf setting. If not used, libzypp's setting
  is used. (bnc #478144)
* Wed Mar 18 2009 jkupec@suse.cz
- show dialog's default option in parentheses instead
  of capitalizing it.
* Thu Mar 12 2009 jkupec@suse.cz
- turn off colors by default (to be configurable in zypper.conf)
  (bnc #483349)
- 1.1.1
* Wed Mar 11 2009 jkupec@suse.cz
- --requires and --recommends added to info command
  (Marcus Hüwe <suse-tux@gmx.de>)
* Tue Mar 10 2009 jkupec@suse.cz
- Fixed noarch->anyarch and vice-versa update via 'zypper up foo'
  (bnc #483179).
- Fixed list-updates showing not-yet-installed packages
  (bnc #483910).
- 1.1.0
* Fri Mar  6 2009 jkupec@suse.cz
- Introduced colors.
- Removed some forgotten control chars from non-terminal output
  (bnc #440822).
- Fixed FindReadline to find shared lib, not static.
- Bash completion: allow spaces in repository aliases
  (werner@suse.de) (bnc #474361)
* Tue Feb 24 2009 ma@suse.de
- Let 'zypper clean' keep the raw metadata cache of CD/DVD based
  repositories. We'd need the CD/DVD again to recreate the data.
  If this is actually desired, explicitly remove an recreate the
  CD/DVD based repository. (bnc #476429).
* Sun Feb 15 2009 jkupec@suse.cz
- Writing additional rpm output after installing/removing packages
  (bnc #369450)
- Added ability to change URI in medium error dialog. Dialog help
  texts added.
* Thu Feb 12 2009 jkupec@suse.cz
- Bash completion: added completion of global options and
  locks for removelock command (jreidinger)
* Thu Feb 12 2009 jkupec@suse.cz
- Fixed localization and xml output of a/r/i prompt with timeout.
* Wed Feb 11 2009 jkupec@suse.cz
- Bash completion improved, allows completion after command
  shorthands, multiple options, option shorthands, repository
  aliases. (jreidinger)
- Avoiding reading of input in a/r/i prompt with timeout in
  non-interactive mode (bnc #469872)
* Tue Jan 27 2009 jkupec@suse.cz
- Adapted authetication callback for non-curl URLs (bnc #460970)
* Thu Jan 15 2009 jkupec@suse.cz
- fixed typo (bnc #447594)
* Wed Jan 14 2009 jkupec@suse.cz
- check for SLE platform on runtime using base product name
  instead of compile time (adapted fate #305057)
* Wed Jan 14 2009 jkupec@suse.cz
- modifyrepo - accept multiple arguments
* Mon Jan 12 2009 jkupec@suse.cz
- some text and man page corrections
* Mon Jan 12 2009 jkupec@suse.cz
- fixed list-patches/patch inconsistency in determining needed
  patches (bnc #464458)
* Tue Dec 16 2008 jkupec@suse.cz
- translations update
- 1.0.3
* Thu Dec 11 2008 jkupec@suse.cz
- fixed typo (bnc #458248)
- r11924
* Fri Dec  5 2008 jkupec@suse.cz
- man page update (fixes also bnc #450857)
* Mon Dec  1 2008 jkupec@suse.cz
- fixed handling of source-install -d and -D options (bnc #428131)
- r11843
* Fri Nov 28 2008 jkupec@suse.cz
- translations update
- 1.0.2
* Mon Nov 24 2008 jkupec@suse.cz
- fixed segfault in 'info' when looking for package to show
  (bnc #448247)
- r11795
- 1.0.1
* Mon Nov 24 2008 jkupec@suse.cz
- fixed generation of solver testcases for verify and dist-upgrade
- r11789
* Wed Nov 19 2008 jkupec@suse.cz
- encode user-supplied URL strings before using them in the Url object
  (bnc #446395, bnc #444267)
- r11722
* Tue Nov 18 2008 jkupec@suse.cz
- select packages to show in 'info' like the install/update command
  does (bnc #437854) (r11701)
- translations update
- 1.0.0
* Mon Nov 17 2008 jkupec@suse.cz
- avoid removing of installed local rpms (bnc #445504)
- r11689
* Sun Nov  9 2008 jkupec@suse.cz
- exit immediately after ctrl+c in prompt (bnc #417997)
- r11643
* Fri Nov  7 2008 jkupec@suse.cz
- fixed listing updates in xml (bnc #441485)
- r11625
* Thu Oct 30 2008 jkupec@suse.cz
- --from added to install command to mark packages for installation
  (by glob/name) from specified repos
- --entire-catalog option for rug compatibility
  (does 'zypper in --from repo '*') (bnc #439806) (r11552)
- translations update
- 0.12.12
* Thu Oct 30 2008 jkupec@suse.cz
- fixed pager process (for viewing licenses) handling (bnc #439786)
- r11543
* Wed Oct 29 2008 jkupec@suse.cz
- fix reporting of unknown options in a short options bunch
  argument (e.g. -asdf) (bnc #299375)
- r11531
* Tue Oct 28 2008 jkupec@suse.cz
- fixed se -s to show multiple installed version of the same
  package
- r11523
* Tue Oct 28 2008 jkupec@suse.cz
- translations update
- r11519
* Mon Oct 27 2008 jkupec@suse.cz
- translations update
- r11515
- 0.12.11
* Mon Oct 27 2008 jkupec@suse.cz
- use /dev/tty for input, instead of stdin
- do not return default value in prompts, if user input
  is expected and EOF received (bnc #436963)
- r11509
* Mon Oct 27 2008 jkupec@suse.cz
- force installation by capability if name.arch is specified
  (bnc #305445)
- complain if installing by --name and arch is specified
- r11506
* Mon Oct 27 2008 jkupec@suse.cz
- --no-cd global option added to ignore CD/DVD repositories
  (bnc #336211)
- --no-remote global option added to ignore remote (downloading)
  repositories
- r11503
* Sun Oct 26 2008 jkupec@suse.cz
- 'rm -t patch' now tells the user that patches can't get
  uninstalled (bnc #402640). The same for patterns, untill pattern
  removal is defined and implemented.
- r11491
* Thu Oct 23 2008 jkupec@suse.cz
- more appropriate 'accept key' dialog (bnc #436794)
- r11460
* Wed Oct 22 2008 jkupec@suse.cz
- fixed unexpected exception when checking if refresh is needed
  after a failed rpm download (bnc #436299)
- r11449
* Tue Oct 14 2008 jkupec@suse.cz
- catch exceptions from initialization of callbacks, show an error
  message and return ZYPPER_EXIT_ERR_BUG (bnc #435198)
- r11346
- 0.12.10
* Tue Oct 14 2008 jkupec@suse.cz
- lazy-initialize the RepoManager
- services and targetos commands now use the readonly hack
  (bnc #435184)
- r11343
* Tue Oct 14 2008 jkupec@suse.cz
- translations updated
- 0.12.9
* Thu Oct  9 2008 jkupec@suse.cz
- added 'productline' attribute to product info XML (bnc #433415)
- deprecated 'type' replaced by 'isbase' boolean attribute in
  product info XML
- r11291
* Tue Oct  7 2008 jkupec@suse.cz
- new translations added
- 0.12.8
* Sun Oct  5 2008 jkupec@suse.cz
- fixed reinstall (zypper in -f foo) (bnc #421588)
- r11245
* Sun Oct  5 2008 jkupec@suse.cz
- update: correctly check if an update is available (bnc #422141)
- r11242
* Fri Oct  3 2008 jkupec@suse.cz
- install: correctly check if an update is available (bnc #427105)
- r11240
* Fri Oct  3 2008 jkupec@suse.cz
- 'ping' command added to simulate rug ping (bnc #430756)
- r11236
* Thu Oct  2 2008 jkupec@suse.cz
- exit if package not found and in non-interactive mode
  (bnc #403216)
- r11226
* Tue Sep 30 2008 jkupec@suse.cz
- addservice: probe for repository/service type if in rug-compatible
  mode (bnc #429620) r11216
- typo in the help text (bnc #430814) r11215
* Mon Sep 29 2008 jkupec@suse.cz
- show in 'lu' what will 'up' actually propose to install
- new --all/-a option for 'lu' to show the original raw list of
  packages for which newer versions exist.
  (bnc #395480) r11197
- translations update
- 0.12.7
* Mon Sep 29 2008 jkupec@suse.cz
- proper error message if the repository type can't be determined
  on refresh (bnc #389690)
- r11195
* Sun Sep 28 2008 jkupec@suse.cz
- 'update' and 'list-updates' now defaults to '-t package'
- patch/list-patches commands added to install/list patches
  (bnc #395480)
- r11191
* Thu Sep 25 2008 jkupec@suse.cz
- sort packages by name in the install summary (bnc #389128)
- r11167
- 0.12.6
* Thu Sep 25 2008 jkupec@suse.cz
- repository information added to GPG key dialogs (bnc #370223)
- r11165
* Thu Sep 25 2008 jkupec@suse.cz
- minimized RepoManager initializaiton, reduced logging drastically
- r11162
* Thu Sep 25 2008 jkupec@suse.cz
- adapt to libzypp's keyring changes, trust and import dialogs
  merged to one (bnc #366467)
- r11162
* Fri Sep 19 2008 jkupec@suse.cz
- 'versioncmp' now uses zypp::Edition::compare() by default and
  match() if --match option is used.
* Fri Sep 19 2008 jkupec@suse.cz
- 'licenses' command added (fate #303703)
- r11108
* Fri Sep 19 2008 jkupec@suse.cz
- don't allow to change alias of a repo belonging to service
- refresh-services: don't refresh non-service repositories by default
- refresh-services: --no-repos/-R replaced by --with-repos/-r
- r11103
* Mon Sep 15 2008 jkupec@suse.cz
- fixed --loose-auth and --loose-query for removerepo and
  removeservice
- r11066
* Sun Sep 14 2008 jkupec@suse.cz
- modifyservice --{ar,rr,cl}-to-{enable,disable} options added
  (fate #304915)
- modifyservice can now modify also non-service repos
- r11061
* Fri Sep 12 2008 jkupec@suse.cz
- modifyservice command added (fate #304915)
- r11055
- 0.12.5
* Fri Sep 12 2008 jkupec@suse.cz
- --xmlout for products, patterns, and product-info
- fixed patterns to respect --{un,}installed-only options
- r11032
- 0.12.4
* Fri Sep 12 2008 jkupec@suse.cz
- --type handling for addservice added
- r11027
* Fri Sep 12 2008 jkupec@suse.cz
- print a hint to run 'zypper verify' (after install) on ignored
  failed package download (fate #303527)
- r11025
* Wed Sep 10 2008 jkupec@suse.cz
- services --with-repos added (also XML)
- r11006
* Tue Sep  9 2008 jkupec@suse.cz
- adapted to new installed status handling of products
- r10974
- 0.12.3
* Mon Sep  8 2008 jkupec@suse.cz
- targetos command added
- versioncmp command added
- r10963
* Mon Sep  8 2008 jkupec@suse.cz
- Product Flavor added to product-info output
- r10961
* Mon Sep  8 2008 jkupec@suse.cz
- XML output added for 'ls'
- fixed to add only repositories matching the target distribution
  when refreshing services
- r10920, r10935, r10941
* Tue Aug 19 2008 dmacvicar@suse.de
- confirm unsupported packages in SLE
  (fate#305057)
* Mon Aug 18 2008 dmacvicar@suse.de
- warn if repostory seems to be outdated
  (fate#301904)
- 0.12.2
* Sat Aug  2 2008 jkupec@suse.cz
- service handling improved, ls, rs, refs now allow to specify
  services by #, alias, or URI as in repos
- 'ls' and 'refs' corrected to work with proper service list
  (repo index services + non-index repos not belonging to any
  service)
- r10731
- 0.12.1
* Tue Jul 29 2008 jkupec@suse.cz
- say Retrieving instead of Downloading when getting files
  (bnc #412851)
- r10689
* Tue Jul 29 2008 jkupec@suse.cz
- addrepo --refresh/-f added to enable autorefresh upon adding the
  repo (bnc #406006)
- r10686
* Mon Jul 28 2008 jkupec@suse.cz
- fixed some stupid and some clever bugs in seach (bnc #411339, bnc
  [#410008], bnc #406163, bnc #407588)
- r10682
* Mon Jul 28 2008 jkupec@suse.cz
- installation by name (-n or -f) made case-insensitive
  (bnc #412496)
- r10675
* Mon Jul 28 2008 jkupec@suse.cz
- zypp-refresh: refresh only repositories with autorefresh enabled
  (bnc #410791) r10673
- initial implementation of repository service handling
  (fate #304915) r10670
* Mon Jul 21 2008 jkupec@suse.cz
- don't mark mutliple patch solvables with the same name for
  installation (bnc #400895)
- r10623
* Thu Jul 17 2008 ma@suse.de
- Remove obsolete references to Script/Message/Atom
* Fri Jul 11 2008 jkupec@suse.cz
- fixed too much progress output when installing/removing
  (bnc #404783)
- zypp-refresh.lr added
- some code cleanup, man page update
- r10536
- 0.12.0
* Thu Jul 10 2008 ma@suse.de
- If zypp is locked, the text provided by ZYppFactoryException. It
  contains pid and name of the locking application. (bnc #280537)
- r10533
* Wed Jul  9 2008 jkupec@suse.cz
- fix setting of solver flags for dist-upgrade (bnc #406959)
- r10529
* Thu Jun 26 2008 jkupec@suse.cz
- zypp-refresh-wrapper: don't close stderr (#398530)
- r10471
* Wed Jun 25 2008 jkupec@suse.cz
- 'xu' removed, replaced by
  zypper --xmlout install -t package -t patch. r10470
- source tree cleanup. r10454-10456
* Fri Jun 20 2008 jkupec@suse.cz
- adapted to new patch message and script handling (#401220)
- r10424
* Thu Jun 19 2008 jkupec@suse.cz
- zypp-refresh: don't accept files with GPG problems (bnc #398530),
  report an error instead. r10400
- zypp-checkpatches utility removed (zypp-refresh + zypper is a
  replacement) r10399
- man page updated
* Mon Jun 16 2008 jkupec@suse.cz
- fixed typo in texts (bnc #389087)
- r10352
* Thu Jun 12 2008 jreidinger@suse.cz
- support multiple arguments to add/remove lock (bnc #398844)
- enable specify repository for add/remove lock
- read only locks file, apply is not needed
- doesn't initialize pool for add repo (bnc #398839)
- r10370
* Thu Jun  5 2008 jkupec@suse.cz
- fix installation of patches/patterns/products (bnc #395326)
- r10384
* Wed Jun  4 2008 jkupec@suse.cz
- count packages correctly on error (bnc #397037)
- r10341
* Tue Jun  3 2008 jkupec@suse.cz
- repo priority allowed to be > 99
- r10329
* Mon Jun  2 2008 jkupec@suse.cz
- --debug-solver for inr and ve (bnc #396353)
- r10309
* Fri May 30 2008 jkupec@suse.cz
- zypper up <foo> to defaults to -t package (bnc #385990)
- r10288
* Fri May 30 2008 jreidinger@suse.cz
- show help messages when show license in pager (bnc #394394)
- r10284
* Mon May 26 2008 jkupec@suse.cz
- fixed layout of tables when the text contains special characters
  (bnc #393723)
- translations updated
- r10223
- 0.11.5
* Sun May 25 2008 jkupec@suse.cz
- ignore recommends of installed packages (bnc #389694)
- new command 'install-new-recommends' to install these recommends
- r10214
* Sat May 24 2008 jkupec@suse.cz
- basic overall install progress (bnc #240588)
- r10212
* Thu May 22 2008 jkupec@suse.cz
- fixed addrepo -n (bnc #393579)
- translations update
- r10187
- 0.11.4
* Tue May 20 2008 dmacvicar@suse.de
- fix zypper looping when arguments are parsed as
  capabilities. (bnc#391644)
* Tue May 20 2008 jkupec@suse.cz
- display patch updates in --xmlout (bnc #390769) (r10162)
- show correct patch list (r10164)
* Tue May 20 2008 jkupec@suse.cz
- info: show correct available version (bnc #386703)
- info: look for exact package name matches, not substrings
  (bnc #392723)
- r10160
* Tue May 20 2008 jreidinger@suse.cz
- exit if bad arguments is passed to whatprovides (bnc #391576).
- r10152
* Fri May 16 2008 jreidinger@suse.cz
- correctly report when libzypp cannot lock due to error instead of
  allready existing lock. (bnc#300103)
- r10120
* Thu May 15 2008 jreidinger@suse.cz
- support for symlink named rug - autoenable rug compatibility
- r10106
* Thu May 15 2008 jreidinger@suse.cz
- fix input after showing in pager (bnc #390027)
- r10102
* Tue May 13 2008 jreidinger@suse.cz
- user needn't to be root to operate on specified --root dir
- r10059
- 0.11.3
* Mon May 12 2008 jkupec@suse.cz
- fixed --uninstalled-only in search
- r10053
* Mon May 12 2008 jkupec@suse.cz
- fixed rpm removal error reporting (bnc #388810)
- r10046
* Mon May 12 2008 jkupec@suse.cz
- bash completion fixes by m4r3k: adapted to new command help; fall
  back to path completion if there's nothing else to complete
- r10043
* Sun May 11 2008 jkupec@suse.cz
- fixed update -t {patch,patter,product} (bnc #388201)
- fixed patch-check
- r10037
* Fri May  9 2008 jkupec@suse.cz
- set proper exit status after installation/removal failed (bnc #381203)
- r10021
* Fri May  9 2008 jreidinger@suse.cz
- fix writing files outside specified root (bnc#388265)
- r10019
* Fri May  9 2008 jreidinger@suse.cz
- implement cleaning locks (bnc#385967)
- r10016
* Fri May  9 2008 jreidinger@suse.cz
- add removelock with name (bnc#385966)
- r10006
* Wed May  7 2008 jkupec@suse.cz
- modifyrepo cleanup: --name added, -R is now used for
  - -no-refresh, -a is now used for --all, deprecated warning added
  for --enable-autorefresh and --disable-autorefresh options.
- addrepo: use -C for --no-check to be consistent with other
  boolean options
- one more update of texts due to several bugs
- r9970:9975
* Mon May  5 2008 jkupec@suse.cz
- search: reenable multiple search strings,--match-words, wildcards
- r9947
* Fri May  2 2008 jreidinger@suse.cz
- implement keep-packages option to ar and mr
- Implement mr filter by local, remote or protocol specific
  repositories and all option (no filter).
- r9935
* Wed Apr 30 2008 jkupec@suse.cz
- abbreviate package summary in the search to fit screen width
- r9915
- 0.11.2
* Tue Apr 29 2008 jkupec@suse.cz
- basic cleanup upon SIGINT and SIGTERM (will remove
  temporary repos) (bnc #340505)
- r9893
* Tue Apr 29 2008 jreidinger@suse.cz
- show license in pager (bnc #260883)
- r9882
* Tue Apr 29 2008 jreidinger@suse.cz
- provide better info for allready installed capabilities.
  (bnc #384412)
- r9876
* Mon Apr 28 2008 jkupec@suse.cz
- translations update
- 0.11.1
* Mon Apr 28 2008 jkupec@suse.cz
- fixed status of patches/patters/products
- r9866
* Mon Apr 28 2008 jkupec@suse.cz
- fixed update (bnc #381908)
- r9862
* Mon Apr 28 2008 jkupec@suse.cz
- fixed --force (bnc #383982)
- r9856
* Sun Apr 27 2008 jkupec@suse.cz
- fixed malformed repo metadata download progress output
  (bnc #377834)
- unify progress report output (bnc #304277)
- fix incorrect status 'done' report on error (bnc #377995)
- r9848
* Sun Apr 27 2008 jkupec@suse.cz
- show also vendor changes in the install summary (bnc #381772)
- the lists in the summary don't have to be mutually exclusive
  only upgrade/downgrade/install/remove/reinstall lists must be.
  The vendor/arch change lists then contains packages from the
  above.
- r9841
* Sat Apr 26 2008 jkupec@suse.cz
- added support for prompt help
- added help for Continue? [y/n/p/?] prompt (bnc #381137)
- r9837
* Sat Apr 26 2008 jkupec@suse.cz
- add 'p' option to the Continue? prompt to restart the solver with
  force-resolution = false. The option will be shown only if there
  are any packages to remove when install command was used with
  force-resolution == true (bnc #381137)
- no-recommends always true for 'remove'
- r9834
* Fri Apr 25 2008 jkupec@suse.cz
- some fixes in the help texts (bnc #383089)
- r9831
* Fri Apr 25 2008 jkupec@suse.cz
- in 'search -s', show the system packages only if no counterpart
  can be found in the repositories (bnc #383182)
- r9829
* Fri Apr 25 2008 jreidinger@suse.cz
- add richtext support also in license confirmation
- r9823
* Tue Apr 22 2008 jkupec@suse.cz
- bash-completion: rename variable conflicting with yast
  (bnc #382097)
- r9793
* Tue Apr 22 2008 jreidinger@suse.cz
- suppress escape sequences and excessive output when writing to
  a file or pipe rather than a terminal (bnc #336333)
- r9786
* Tue Apr 22 2008 jreidinger@suse.cz
- add richtext support to zypper info (bnc #224677).
- r9767
* Mon Apr 21 2008 jkupec@suse.cz
- texts cleanup, translations update
* Mon Apr 21 2008 jkupec@suse.cz
- rug's list-resolvables added (hardcoded list of resolvable types)
  (fate #302148)
- r9748
* Mon Apr 21 2008 jkupec@suse.cz
- show architecture changes in the install summary (bnc #381772)
- show upgrades/downgrades with changed arch in the install summary
  (bnc  #381772)
* Mon Apr 21 2008 jkupec@suse.cz
- allow correct translation of install summary (bnc #310896)
- texts cleanup
* Mon Apr 21 2008 jkupec@suse.cz
- use isSatisfied() to determine installed status of PPP
  (bnc #381295)
- show search result groupped by name-kind (bnc #348676)
- show summary, don't show repo (bnc #348676)
- --details option added to show solvable list, columns rearranged
* Sun Apr 20 2008 jkupec@suse.cz
- some text corrections (bnc #381385, bnc #381366)
* Sun Apr 20 2008 jkupec@suse.cz
- fixed install foo-bar-version-release (bnc #381694)
- r9728
* Fri Apr 18 2008 jkupec@suse.cz
- allow to force repository per-package using:
  zypper install <repo_alias>:packagename (fate #302919)
- r9707
* Fri Apr 18 2008 jkupec@suse.cz
- 'mount' command added (rug compatibility alias for
  'zypper addrepo -t plaindir <localpath>') (fate #302148)
- --name option added to addrepo command to be able to set repo
  name
- 'service-types' command (rug compatibility) - lists available
  service types (hardcoded) (fate #302148)
- clean-cache, cc, you-clean-cache, yc 'clean' command aliases for
  rug (fate #302148)
- r9700
* Fri Apr 18 2008 jreidinger@suse.cz
- add warning if as only one parameter is not specified repo file.
  (bnc #380322)
- r9695
* Thu Apr 17 2008 jreidinger@suse.cz
- fix multiple remove same repository
- r9681
* Wed Apr 16 2008 jkupec@suse.cz
- fixed installed status column in zypper search (bnc #375161)
- 'packages' command added (fate #302148)
- r9669
* Wed Apr 16 2008 jkupec@suse.cz
- changed ar --nocheck to --no-check to be consistent
- r9660
* Tue Apr 15 2008 jkupec@suse.cz
- options added to 'zypper repos' to list URI, priority, type
  and to sort by name, alias, URI and priority (bnc #364391)
- r9656
* Tue Apr 15 2008 jkupec@suse.cz
- don't look for rpm if path starts with '/' and does not end with
  .rpm (bnc #337007)
- r9651
* Tue Apr 15 2008 jreidinger@suse.cz
- bash completion - if no option can be completed, return to
  default behaviour.
- r9646
* Tue Apr 15 2008 jkupec@suse.cz
- make translator comments visible
- r9641
* Tue Apr 15 2008 jreidinger@suse.cz
- remove redundant -f in the man page (bnc #379889)
- r9633
* Tue Apr 15 2008 jkupec@suse.cz
- some texts cleanup (bnc #379235)
- r9629
- 0.11.0
* Mon Apr 14 2008 jkupec@suse.cz
- use --force-resolution and --no-force-resolution instead of
  - -force-resolution <on|off>
- r9627
* Mon Apr 14 2008 jkupec@suse.cz
- --no-recommends added to install, update, dist-upgrade and verify
  to suppress installation of recommended packages
- r9623
* Mon Apr 14 2008 jkupec@suse.cz
- pattern content with Dependency (Recommended/Suggested) column added
  for pattern-info (fate #301930)
- r9620
* Mon Apr 14 2008 jkupec@suse.cz
- 'patterns' command added (fate #302148)
- 'patches' now take repos as arguments (fate #302148)
- r9617
* Mon Apr 14 2008 jkupec@suse.cz
- package lock management commands added (addlock, removelock, and
  locks) (fate #120118, fate #302148)
- r9612
* Mon Apr 14 2008 jkupec@suse.cz
- added Recommends: logrotate cron bash-completion (bnc #379553)
* Mon Apr 14 2008 jkupec@suse.cz
- allow wildcards in install (fate #302193, fate #302148)
- fall back to --capability if package not found by name
  (fate #302919)
- r9597
* Sun Apr 13 2008 jkupec@suse.cz
- allow zypper install foo-bar-version-release
  (fate #302919, fate #302148)
- allow white space when specifying version with operators in
  install/remove commands (fate #302919)
- r9595
* Sun Apr 13 2008 jkupec@suse.cz
- allow update of individual packages + support wildcards
  (bnc #345458, bnc #284725, and abuse of fate #302511 :O)
- 'update foo' treat command arguments as repos in rug-compatible
  mode (fate #302148)
- 'update': dummy --download-only and --category options for now
  (fate #302148)
- r9590
* Sun Apr 13 2008 jkupec@suse.cz
- always check if the repo is up-to-date on explicit refresh
  request (zypper ref)
- r9576
* Sat Apr 12 2008 jkupec@suse.cz
- say 'foo already installed' or 'foo not found' when installing or
  removing by injecting solver requirements/conflicts (bnc #379195)
- r9572
* Sat Apr 12 2008 jkupec@suse.cz
- allow to install and remove package in one command by prepending
  package name by + or ~ modifiers (for install) and - or ! (for
  uninstall). fate #302148, bnc #230342
- allow install foo<op<version>> without having to use --capability
  (fate #302919)
- r9569
* Tue Apr  8 2008 jreidinger@suse.cz
- give better hint if zypper cannot download file from out of date
  repository. (bnc #377137).
- r9454
* Fri Apr  4 2008 jreidinger@suse.cz
- fix escaping characters for shell and for local files
- r9381
* Sun Mar 30 2008 jkupec@suse.cz
- --priority option added to the modifyrepo command to set repository
  priority (bnc #369827)
- r9311
- 0.10.5
* Sat Mar 29 2008 jkupec@suse.cz
- 'verify' command added (fate #301178)
- r9305
* Fri Mar 28 2008 jkupec@suse.cz
- fixed crashing in help when zypp not initialized (bnc #372696)
- r9296
* Thu Mar 27 2008 jreidinger@suse.cz
- same default for adding by URL & alias and by repo file.
- Drop support for no-refresh parameter during addrepo.
- r9282
* Thu Mar 27 2008 jkupec@suse.cz
- fixed dependency problem prompt (bnc #372711), options now
  also available for translation
- r9280
* Tue Mar 25 2008 jkupec@suse.cz
- fixed dependency problems not shown in non-interactive mode
  (bnc #373125)
- r9269
* Tue Mar 25 2008 jreidinger@suse.cz
- add end of line to add repository output (bnc #373196)
- r9261
* Fri Mar 21 2008 jreidinger@suse.cz
- add new call for abort/request/ignore question with timeout
- in media request callback add this call for temporary network
  problems, and first three run have retry as default and then
  abort is default (bnc #328822)
- r9248
* Thu Mar 20 2008 jreidinger@suse.cz
- precise information why not update repository (bnc #307249)
- r9235
* Wed Mar 19 2008 jkupec@suse.cz
- provide feedback when downloading metadata (bnc #300903)
- r9198
* Tue Mar 18 2008 jreidinger@suse.cz
- add abort/retry/ignore option when download fail (bnc #340345)
- r9190
* Fri Mar 14 2008 jkupec@suse.cz
- use default answers to prompts on enter. Default answer options
  will be shown uppercase.
- don't offer to skip or retry in the prompt if there is only one
  dependency problem (bnc #369608)
- r9161
- 0.10.4
* Fri Mar 14 2008 jreidinger@suse.cz
- --check and --nocheck options added to the addrepo command
  (bnc #309612)
- r9143
* Tue Mar 11 2008 jreidinger@suse.cz
- say exactly what did modifyrepo change (bnc #327580)
- r9091
* Mon Mar 10 2008 jkupec@suse.cz
- show download rate for http/ftp downloads (bnc #227903)
- r9077
* Mon Mar 10 2008 jkupec@suse.cz
- zypper clean is now able to clean also normal meta-data caches
  (the .solv files)
- r9070
* Fri Mar  7 2008 jkupec@suse.cz
- fixed crashing when searching with no search terms (bnc #366487)
- r9055
- 0.10.3
* Fri Mar  7 2008 jreidinger@suse.cz
- addrepo now allows to use a .repo file URI as an argument
  (bnc #240018)
- r9047
* Fri Mar  7 2008 jreidinger@suse.cz
- allow write repo as number or URL -repo and for repo-manipulating
  commands (bnc #298312)
- allow multiple repos in removerepo command (bnc #244440)
- r9044
* Thu Mar  6 2008 jkupec@suse.cz
- bash completion script added (thanx to Marek Stopka)
- r9035
* Thu Mar  6 2008 jkupec@suse.cz
- don't show download progress of the media file if not vebose
  (bnc #330614)
- r9026
* Tue Mar  4 2008 jkupec@suse.cz
- appropriate error message for problems with rpm database during
  reading installed packages or after installation (bnc #364370)
- say 'no space will be freed/used' instead of '0 will be freed'
  (bnc #309112)
* Fri Feb 29 2008 jkupec@suse.cz
- --xmlout for repos, install, update, dist-upgrade, remove,
  list-updates, refresh, and *repo command complete (fate #302595)
- install prompt.h to /usr/include/zypper and xmlout.rnc to
  /usr/share/zypper/xml
- r8970
- 0.10.2
* Fri Feb 29 2008 jkupec@suse.cz
- xml encode the repo url and alias in update xml (bnc #337424,
  bnc #342701)
* Thu Feb 28 2008 jkupec@suse.cz
- fixed solver solution detail text indentation (bnc #358871)
- better solver prompt text (bnc #365236)
* Sat Feb 23 2008 dmacvicar@suse.de
- default autorefresh to disabled like every other package
  management tool
* Fri Feb 22 2008 jkupec@suse.cz
- --xmlout almost done (special command result output missing)
- fixed --quiet (#359188)
- 0.10.1
* Fri Feb 22 2008 visnov@suse.cz
- After generating testcase, also show the location in the message
* Fri Feb 22 2008 ma@suse.de
- Fixed typo in help text (bnc #363804)
- revision 8862
* Thu Feb 21 2008 jkupec@suse.cz
- xmlout - added support for <prompt> and <download> (bnc #345870)
- r8846
* Sun Feb 17 2008 dmacvicar@suse.de
- add support for installing build dependencies from
  source package (w.i.p) (bnc #348685)
* Fri Feb 15 2008 jkupec@suse.cz
- --xmlout added (still work in progress)
- 0.10.0
* Fri Feb 15 2008 visnov@suse.de
- implemented clean command
* Wed Feb 13 2008 coolo@suse.de
- increase version number to mark satsolver branch
* Tue Feb 12 2008 jkupec@suse.cz
- ar and mr command options made consistent (bnc #356132,
  bnc #356135)
- fixed conflicting search -c, --case-sensitive is -C now
  (bnc #358021)
- fixed 'zypper --help' (bnc #358850)
* Mon Feb  4 2008 jkupec@suse.cz
- new exit code 104 ZYPPER_EXIT_INF_CAP_NOT_FOUND (bnc #358326)
- r8451
* Fri Feb  1 2008 jkupec@suse.cz
- --no-refresh global option added (bnc #356741)
- fixed renaming to an existing alias (bnc #228216)
- r8436
- 0.9.6
* Thu Jan 31 2008 jkupec@suse.cz
- fixed zypper help shell (bnc #357262)
- r8419
* Thu Jan 17 2008 jkupec@suse.cz
- --dry-run for in, rm, up, and dup (bnc #350736)
- r8306:8311
* Mon Jan 14 2008 jkupec@suse.cz
- ability to install plain RPM files whose locations are specified
  in the install command arguments (FATE #302151, bug #230223).
- r8261:8274
- 0.9.5
* Wed Jan  9 2008 jkupec@suse.cz
- support # and URI as well as alias in --repo (#298312)
- multiple --repo allowed now in all commands supporting the option
- --repo for refresh (less surprises for users)
- r8249:8250
* Fri Jan  4 2008 jkupec@suse.cz
- new global options: --plus-repo, --disable-repositories,
  - -disable-system-resolvables (#224886)
- r8195
* Tue Dec 11 2007 jkupec@suse.cz
- product and pattern (#266896) support added to the info command
- product-info and pattern-info command aliases added for rug
  compatibility
- added Vendor to the info output
- r8107
- 0.9.4
* Sun Dec  9 2007 jkupec@suse.cz
- --type added for the 'info' command
- 'quit' command help added
- r8084
* Sun Dec  9 2007 jkupec@suse.cz
- fixed the install command in the shell (#345004)
- r8080
* Sun Dec  9 2007 jkupec@suse.cz
- fixed addrepo command (#346797)
- show help by default if no option or command was specified (#346507)
- show help if --help is specified :O)
- r8077
* Wed Dec  5 2007 jkupec@suse.cz
- reset user selections after install/remove in the zypper shell
  (#288740)
- r8028
- forgotten changelog for 0.9.3 r8008 - sync pool after commit when
  in shell (re-read installed resolvables)
* Tue Dec  4 2007 jkupec@suse.cz
- removed some unnecessary boost dependencies (dmueller) (#344941)
- fixed crashing if couldn't acquire ZYpp lock
* Mon Dec  3 2007 jkupec@suse.cz
- new defaults for the force-resolution solver mode:
  'on' by default in the interactive mode,
  'off' by default in the non-interactive.
  'on' is the default for rug-compatible mode (even non-interact.).
  And finally, if the --force-resolve <on|off> is specified, it
  takes preference.
- r8011
- 0.9.3
* Fri Nov 30 2007 jkupec@suse.cz
- avoiding unwanted translation of zypper keywords (#343335)
- r7994
* Fri Nov 30 2007 jkupec@suse.cz
- fixed some unsufficient permission exceptions for non-root
  (#344938)
- r7988
* Tue Nov 27 2007 jkupec@suse.cz
- fixed help invocation (#337406)
- r7944
* Tue Nov 27 2007 jkupec@suse.cz
- fixed some more issues with gcc 4.3
- some code refactoring
* Mon Nov 19 2007 tgoettlicher@suse.de
- preserve lang in zypp-checkpatches-wrapper (#333882)
- r7864
* Mon Nov 12 2007 jkupec@suse.cz
- dist-upgrade added (experimental) FATE #302460
- r7786
- 0.9.2
* Fri Nov  9 2007 jkupec@suse.cz
- made force-resolution solver mode off by default
  (but still on when running in the rug compatibility mode)
- --force-resolution option added to in, rm, and up commands
  to control the setting (#337370)
- r7773
* Tue Oct 30 2007 jkupec@suse.cz
- supress progress output when --quiet (#335305, #336333)
- r7703
* Mon Oct 29 2007 jkupec@suse.cz
- (s)kip option added to the dependency problem resolution prompt
- r7689
* Fri Oct 26 2007 jkupec@suse.cz
- --root now adapts also repos.d and cache dirs
- require an absolute path for --root (#335609)
- proper return value for help
- r7662
- 0.9.1
* Fri Oct 26 2007 jkupec@suse.cz
- when --skip-interactive is specified, skip also patches having a
  license to confirm, even if they are not marked as interactive
  (#236360)
- r7646
* Tue Oct 23 2007 jkupec@suse.cz
- --reposd-dir, --cache-dir, and --raw-cache-dir global options
  added
- r7608
* Mon Oct  8 2007 jkupec@suse.cz
- fixed compilation with gcc 4.3
- r7468
- 0.9.0
* Mon Oct  8 2007 jkupec@suse.cz
- missing -y option added to the update command (rug-compatibility)
  (#331632)
- r7465
* Sat Oct  6 2007 jkupec@suse.cz
- correctly translate the command list (help text) (#327487)
- r7460
* Sat Oct  6 2007 jkupec@suse.cz
- don't check if to refresh cd/dvd repos even on user request
  unless forced
- r7449
* Tue Oct  2 2007 mvidner@suse.cz
- Fixed misalignment in localized tables (#328918).
* Tue Sep 25 2007 jkupec@suse.cz
- report malformed URLs correctly in zypper addrepo (#325660)
- make compiler happy about /* withing comments
- r7374
* Fri Sep 21 2007 jkupec@suse.cz
- fix zypper refresh exit status (#326694)
- translations update
- r7333
- 0.8.23
* Thu Sep 20 2007 jkupec@suse.cz
- gcc build requires decreased to gcc 4.1
* Wed Sep 19 2007 aschnell@suse.de
- close file-descriptors > 2 in zypp-checkpatches-wrapper (bug
  [#325556])
* Tue Sep 18 2007 aschnell@suse.de
- call setgid and umask and check file-descriptors 0, 1 and 2 in
  zypp-checkpatches-wrapper (bug #325556)
* Tue Sep 18 2007 dmacvicar@suse.de
- fix (#309267) reinstalling already installed resolvables
  (adds --force option)
- 0.8.22
* Mon Sep 17 2007 jkupec@suse.cz
- translations update
- r7273
* Fri Sep 14 2007 jkupec@suse.cz
- don't warn about reboot or restart if the action has been cancelled
  (#257520)
- translations update
- r7250
- 0.8.20
* Thu Sep 13 2007 dmacvicar@suse.de
- Show reason of commit error (#308511)
- 0.8.20
* Wed Sep 12 2007 jkupec@suse.cz
- translations update
* Wed Sep 12 2007 jkupec@suse.cz
- display localized resolvable kind in various texts
* Wed Sep 12 2007 jkupec@suse.cz
- displaying the file download progress during commit phase
  (installation) by default (#309043)
- make package selection by name (--name) the default for
  install/remove commands (due to many bug reports)
- --capability added to install/remove commands to select packages
  by capability
- r7205
* Tue Sep 11 2007 jkupec@suse.cz
- always display name instead of alias (except for the renamerepo
  command, which works with alias) (#308669)
- don't display the number of problems if only one found (#304283)
- translations update
- r7194
* Tue Sep 11 2007 jkupec@suse.cz
- translations update
- man page update
- r7174
* Mon Sep 10 2007 jkupec@suse.cz
- report too many arguments (#307639)
- r7164
* Mon Sep  3 2007 jkupec@suse.cz
- fix broken compiler flags (schwab)
- r7099
- 0.8.19
* Mon Sep  3 2007 jkupec@suse.cz
- authentication prompt implemented (#190609)
- LOCK documention added to man page (mvidner)
- r7093
* Mon Sep  3 2007 jkupec@suse.cz
- removing rpm message improved (#307132)
- r7086
* Mon Sep  3 2007 kkaempf@suse.de
- make (r)etry (c)ancel answer case-insensitive (#307122)
* Fri Aug 31 2007 jkupec@suse.cz
- fixed error message of zypper ar -r (#306667)
- r7055
* Fri Aug 31 2007 kkaempf@suse.de
- dont prompt for solutions if none are available.
- dont duplicate dependency problems in output.
- indent details by 2 blanks, resolver indents further details
  by 4 blanks.
- provide additional details for problems (#306240)
- don't prompt user for every dependency (#304325)
- don't clutter the log with pool lists.
- r 7054
* Thu Aug 30 2007 jkupec@suse.cz
- suppressing excessive output of media errors
- prompting for media change only for changeable media
- adapted to libzypp 3.21.0 (#294481)
- r7043
- 0.8.18
* Wed Aug 29 2007 jkupec@suse.cz
- proper fix for y/n translation (#304650)
- r6965
* Wed Aug 29 2007 jkupec@suse.cz
- expect MediaException during commit (#305113)
- r6964
* Tue Aug 28 2007 jkupec@suse.cz
- displaying repo name instead of alias where appropriate (#304659)
- don't display URI by default (#230335)
- r6947
* Tue Aug 28 2007 kkaempf@suse.de
- Don't search disabled repos, override with --repo (#304653)
- r 6945
* Tue Aug 28 2007 dmacvicar@suse.de
- (#302379) allows to skip packages and abort
* Tue Aug 28 2007 mvidner@suse.cz
- "help foo" now works like "foo --help" (by Dominique Leuenberger, #299818).
* Tue Aug 28 2007 kkaempf@suse.de
- support "-r" (limit to repo) on search (#305384)
- rev 6937
- version 0.8.17
* Tue Aug 28 2007 kkaempf@suse.de
- allow for multiple types when searching, default to '-t package'.
  check architecture on search output,
    different arch is always 'uninstalled'.
  don't show 'atoms' in 'zypper up' output.
  (#300569)
- rev 6933
* Tue Aug 28 2007 dmacvicar@suse.de
- a init target at refresh to have keys available
  (#304672)
- rev 6928
* Mon Aug 27 2007 jkupec@suse.cz
- translations update
- mark [y/n] for translation (#304650)
- r6894
* Fri Aug 24 2007 mvidner@suse.cz
- Help now works in the shell (by Dominique Leuenberger, #299818).
* Thu Aug 23 2007 mvidner@suse.cz
- Shell stopped working at all; fixed (#301666).
* Thu Aug 23 2007 mvidner@suse.cz
- Re-enabled the read-only lock for service-list (#302152).
- Corrected cache paths in the man page (#302662).
- 0.8.16
* Tue Aug 21 2007 dmacvicar@suse.de
- fix invalid capability creation (#301690)
- 0.8.15
* Tue Aug 21 2007 tgoettlicher@suse.de
- unification and clean up of XML output
- r6787
* Mon Aug 20 2007 mls@suse.de
- fixed changelog ordering
* Mon Aug 20 2007 kkaempf@suse.de
- fix first column (i/v) of 'search' output
- r6759
- 0.8.14
* Mon Aug 20 2007 kkaempf@suse.de
- adapt to unified query API of libzypp-3.18.x
- r6756
* Fri Aug 17 2007 jkupec@suse.cz
- text update from proof-reading
- some output clean-up
- r6746
- 0.8.13
* Fri Aug 17 2007 kkaempf@suse.de
- implement --type and --match-exact options for cache search
- fix repository and kind in output
  requires libzypp >= 3.17.0
- r6737
* Thu Aug 16 2007 kkaempf@suse.de
- initial implementation of cache search
  requires libzypp >= 3.16.0
- r6722, version 0.8.12
* Thu Aug 16 2007 jkupec@suse.cz
- more comprehensive message after adding a repository
- disabling autorefresh for CD and refreshing right after adding with
  zypper addrepo (part of #292417)
- install summary formatting bug (no new line and indent)
- more improved error reporting
- r6704
* Wed Aug 15 2007 jkupec@suse.cz
- providing correct capability for installing a resolvable(#298322)
  fixed for real this time
- r6686
- 0.8.11
* Tue Aug 14 2007 jkupec@suse.cz
- zypper repos --export <FILE|-> added for exporting definitions of
  repositories into a single repo file (FATE #301744)
- improved zypper install command description in the man (#284725)
- r6650
* Tue Aug 14 2007 jkupec@suse.cz
- forgotten --catalog alias for --repo option added for rug
  compatibility (support fo repo numbers as --repo argument still
  pending)
- r6645
* Tue Aug 14 2007 tgoettlicher@suse.de
- fixed missing </stream> tag in xml output
- r6635
* Mon Aug 13 2007 jkupec@suse.cz
- providing correct capability for installing a resolvable(#298322)
- fixed spaces in a message (#299620)
- r6638
* Mon Aug 13 2007 tgoettlicher@suse.de
- removed restart message from xml (#298942)
- r6626
* Sun Aug 12 2007 jkupec@suse.cz
- user-friendly install summary (FATE #302152) - try also verbose
  output (-v)
- r6621
- 0.8.10
* Fri Aug 10 2007 dmacvicar@suse.de
- apply persistant locks on establish
- require libzypp 3.14.0
* Fri Aug 10 2007 jkupec@suse.cz
- improved error reporting of repository operations (#298506)
- r6564
* Thu Aug  9 2007 jkupec@suse.cz
- Logging of zypper version added.
- '-n' shorthand added for --non-interactive
- r6539
* Wed Aug  8 2007 jkupec@suse.cz
- fixed -y option support (did not switch to non-interactive mode)
- r6521
* Tue Aug  7 2007 tgoettlicher@suse.de
- added status "no-update-repositories" to xml output when no update
  repos are defined (#fate 300635)
- r6510
* Tue Aug  7 2007 jkupec@suse.cz
- fixed zypper to complain when given an invalid answer in y/n prompt
  (#232250) plus made the answer translatable.
- r6507
* Mon Aug  6 2007 jkupec@suse.cz
- changed zypper source-install to take more arguments at once
- changed the versioned capability to be expected as
  NAME[OP<EDITION>] (without spaces) for in/rm commands
- r6498
- 0.8.9
* Mon Aug  6 2007 jkupec@suse.cz
- removed provides/obsoletes rug (#294224)
- r6491
- 0.8.8
* Mon Aug  6 2007 jkupec@suse.cz
- preliminary support for installation of source packages
  (FATE #301171), without possibility to specify version to install
  and to install its dependencies along
- r6489
* Sun Aug  5 2007 jkupec@suse.cz
- translations added/updated
- r6478
* Sat Aug  4 2007 jkupec@suse.cz
- new refresh options added: --force, --force-build, --force-download,
  - -build-only, --download-only
- r6476
* Sat Aug  4 2007 jkupec@suse.cz
- zypper refresh now takes aliases or repo numbers that should be
  refreshed as arguments.
- zypper repos output fixed to show proper repo numbers (#296779)
- r6473
* Fri Aug  3 2007 dmacvicar@suse.de
- zypper uses tribool internally. So autorefresh and enabled now
  have this order of preference:
  cmd line value
  .repo file
  zypp default
- 0.8.7
* Fri Aug  3 2007 dmacvicar@suse.de
- better error handling. remove duplicated libzypp code.
  Let libzypp probe the urls for us.
* Fri Aug  3 2007 tgoettlicher@suse.de
- removed installnotify from xml output
- r6433
* Fri Aug  3 2007 tgoettlicher@suse.de
- renamed resolvabletype to kind in xml output
- r6413
* Fri Aug  3 2007 tgoettlicher@suse.de
- added xml output for some messages
- 6411
* Thu Aug  2 2007 dmacvicar@suse.de
- added xml output in terse mode
- r6406
* Thu Aug  2 2007 tgoettlicher@suse.de
- added xml error message to zypp-checkpatches-wrapper
- r6395
* Wed Aug  1 2007 jkupec@suse.cz
- --repo re-implemented to restrict operation to the specified
  repository (FATE #302160, #302158)
- r6365
* Wed Aug  1 2007 tgoettlicher@suse.de
- added --non-interactive --terse to zypp-checkpatches-wrapper
- added to machine_readable to zypper-callbacks
- r6359
* Wed Aug  1 2007 tgoettlicher@suse.de
- option xu only shows affect-package-manager patches when available
  because they have top priority
- added installnotify message to xml
- r6356
* Tue Jul 31 2007 jkupec@suse.cz
- fixed typo in the help (#295980)
- r6327
* Tue Jul 31 2007 schubi@suse.de
- Removed keepExtra parameter in resolvePool; Bug 294727
- r6323
* Tue Jul 31 2007 jkupec@suse.cz
- --debug-solver added for generating solver test case
- r6319
* Mon Jul 30 2007 jkupec@suse.czi
- new translations added
- r6307
- 0.8.6
* Mon Jul 30 2007 jkupec@suse.cz
- Cleaned up RepoInfo tribools (adapted to libzypp 3.13.1)
- r6306
* Mon Jul 30 2007 jkupec@suse.cz
- fixed proper error message if a repo is invalid (#294483,#294488)
- r6298
* Mon Jul 30 2007 jkupec@suse.cz
- output functions for progress reporting now take ostream as argument
- made some progress displayed by default. This will need more tuning.
- missing files added to .spec file
- r6285
- 0.8.5
* Mon Jul 30 2007 jkupec@suse.cz
- Rug's --no-confirm option changed to work as --non-interactive
- moved --no-confirm from help texts and man page to COMPATIBILITY
  WITH RUG section of the man page
- r6278
* Fri Jul 27 2007 mvidner@suse.cz
- Implemented capabilities for installing and removing, allowing to
  install by provided tags and files (F#301956) or a specific
  version (F#302186): zypper in 'clamav = 0.90-0.1'; zypper rm
  /bin/vi; zypper in libcurl.so.3; zypper in 'perl(Time::ParseDate)'
- Added --name,-n to install and remove to use the old selection
  method in case the new one does not work.
- r6274
- 0.8.4
* Thu Jul 26 2007 jkupec@suse.cz
- output clean-up (#216042)
- fixed typo (#293797)
- r6256
* Thu Jul 26 2007 kkaempf@suse.de
- implement '--best-effort' for upgrade (experimental)
- r6235
* Thu Jul 26 2007 jkupec@suse.cz
- cmake added to build dependencies
- added versions to build deps
- r6229
* Thu Jul 26 2007 tgoettlicher@suse.de
- moved --machine-readable option to --terse
- r6221
* Thu Jul 26 2007 jkupec@suse.cz
- fixed non-interactive mode for media change request (#294685)
- r6220
* Wed Jul 25 2007 kkaempf@suse.de
- implement '--best-effort' for "list updates"
  adapt output columns appropriately (in best-effort mode, zypper
  does not know the repository, version, or architecture since the
  dependency solver will determine it later.)
- make "list update" output handling more robust
- r6216
* Wed Jul 25 2007 kkaempf@suse.de
- add "--from-repo" option to "list updates" and "update" to limit
  updates to a specific repository.
- improve help of (-t <resolvable type>) by explicitly listing
  possible types.
- r6213
* Wed Jul 25 2007 tgoettlicher@suse.de
- minor changes in machine_readable option
- r6208
* Wed Jul 25 2007 tgoettlicher@suse.de
- minor changes in machine_readable option
- r6201.
* Tue Jul 24 2007 mvidner@suse.cz
- Fixed zypper --version (broken when switching to cmake).
* Mon Jul 23 2007 tgoettlicher@suse.de
- Added --machine-readable to install command
- r6160
* Mon Jul 23 2007 tgoettlicher@suse.de
- Adapted zypp-checkpatches-wrapper for use with "zypper -q xu"
- r6158.
* Mon Jul 23 2007 tgoettlicher@suse.de
- Added "xml-updates" to help command
- r6153
* Thu Jul 19 2007 jkupec@suse.cz
- some texts clean-up for first translation round
- updated libzypp build-dep version
- r6091
- 0.8.3
* Thu Jul 19 2007 tgoettlicher@suse.de
- renamed command "xml-updates-patches" to "xml-updates"
- added license information to xml output
- r6085
* Wed Jul 18 2007 jkupec@suse.cz
- --auto-agree-with-licenses option added (#216649)
- r6080
* Wed Jul 18 2007 tgoettlicher@suse.de
- add "xml-updates-patches" command to zypper that creates
  output like zypp-checkpatches
- r6078
* Wed Jul 18 2007 jkupec@suse.cz
- man page update, COMPATIBILITY WITH RUG section added
- renamed command 'listrepos' to just 'repos'
- s/service/repository
- remove repository by URL reimplemented
- --loose-auth and --loose-query added for removerepo command
  (#292362)
- keyring callbacks improved and prepared for non-interactive and
  no-gpg-checks mode (#216649)
- no-gpg-checks global option added. (FATE #301998)
- show repo in the repo list as disabled only if enabled() == false
  (tribool bug)
- r6066
* Thu Jul 12 2007 jkupec@suse.cz
- s/source/repository in zypper texts, help page will follow
- display a non-root error message for commands which require root
- callbacks improved
- r5984
- 0.8.2
* Mon Jul  9 2007 jkupec@suse.cz
- modifyrepo command added (alias service-modify, sm, mr).
  The command is able to enable/disable repo and enable/disable
  auto-refresh for it.
- r5928
- 0.8.1
* Thu Jul  5 2007 jkupec@suse.cz
- --silent global option added. Use cout_n for normal program
  output which should be suppressed by --silent option.
- some output clean-up (still work to do)
- r5899
* Tue Jul  3 2007 jkupec@suse.cz
- Adapted to refactored libzypp repository management
- fixed consistency of <required> and [optional] arguments
- improved update command description
- changed sa, sr descriptions + some other minor changes
- made help texts consistent
- r5871
- 0.8.0
* Tue Jun 19 2007 mvidner@suse.cz
- Fixed an endless loop in Abort/Retry/Ignore (#269263).
* Sat Jun 16 2007 jkupec@suse.cz
- switched building from autotools to cmake
- replaced zmart occurances with zypper
- r5711
* Mon Jun  4 2007 jkupec@suse.cz
- fixed changed log file path also in zypper.lr
- r5669
* Mon Jun  4 2007 jkupec@suse.cz
- moved zypper log from /var/log/YaST2 to /var/log
- declared ownership of the log file by zypper package
- r5667
- 0.7.2
* Thu Apr 26 2007 jkupec@suse.cz
- Show a user readable message when check-patches
  can't acquire the lock. (#227073) (Merged from
  SuSE-Linux-10_2-Branch r4814)
- r5451
* Thu Feb 22 2007 mvidner@suse.cz
- Use the read-only hacek for service-list (#247001).
* Tue Feb 13 2007 mvidner@suse.cz
- Shrunk zypp-checkpatches (#224886).
* Tue Feb 13 2007 mvidner@suse.cz
- Do not allow to commit with unresolved dependency problems;
  resolve them interactively (#242736).
- 0.7.1
* Mon Feb  5 2007 mvidner@suse.cz
- Shell: added command line editing with history (#232374);
  exit on EOF (#230211, #235709).
- 0.7.0
* Fri Feb  2 2007 jkupec@suse.cz
- Non-interactive mode turns on --skip-interactive as well
  (part of fix #224216)
- r4964
* Thu Feb  1 2007 jkupec@suse.cz
- Merged revisions 4943-4944,4946-4958 via svnmerge from
  SuSE-Linux-10_2-Branch. Changelog follows:
- Hungarian translation added.
- Slovak translation added.
- enabled DownloadResolvableReportReceiver::problem() callback
  (#224216)
- global non-iteractive mode added (needed due to bug #224216 and
  no-confirm option of install and update commands).
- POTFILES.in updated
- r4959
* Thu Feb  1 2007 mvidner@suse.cz
- Added global option --root to operate on a different directory
  (#238165, F#301963).
* Wed Jan 31 2007 jkupec@suse.cz
- locale support added (merged from 10.2/SP1 branch)
- r4941
* Fri Jan 12 2007 jkupec@suse.cz
- Texts corrected based on feedback from proof-reading.
- r4852
* Thu Jan 11 2007 jkupec@suse.cz
- more texts marked for translation
- r4848
* Tue Jan  9 2007 mvidner@suse.cz
- Fixed building on SLE10-SP1.
* Mon Dec 18 2006 jkupec@suse.cz
- fixed uncaught checksum exception (#224216)
- 0.6.14
* Fri Dec  1 2006 jkupec@suse.cz
- fixed error output when trying to install an already installed
  package (#224129)
- fixed missing target resolvables in search (#224673)
* Fri Dec  1 2006 mvidner@suse.cz
- installation_sources: fixed to be compatible even with
  /opt/kde3/bin/kde_add_yast_source.sh (#223795).
- zypp-checkpatches does not need -lboost_program_options (#224764)
* Thu Nov 30 2006 jkupec@suse.cz
- Added explicit dependency on procps package.
* Mon Nov 20 2006 mvidner@suse.cz
- Respect "update --skip-interactive" (#221476).
- list-updates: warn if we are listing only patches affecting the
  package manager and there are also others.
- 0.6.13
* Mon Nov 20 2006 mvidner@suse.cz
- update -t package: keep the same architecture (#222140).
- 0.6.12
* Wed Nov 15 2006 mvidner@suse.cz
- Resurrected /usr/bin/installation_sources, as a shell wrapper for
  zypper (#163737).
- 0.6.11
* Wed Nov 15 2006 mvidner@suse.cz
- service-add: added options --type (especially for Plaindir,
  [#174369]), --disabled, and --no-refresh.
- 0.6.10
* Mon Nov 13 2006 mvidner@suse.cz
- Fixed service-rename leaving the old name around.
- 0.6.9
* Mon Nov 13 2006 jkupec@suse.cz
- license confirmation upon installation/update added
- 0.6.8
* Fri Nov 10 2006 jkupec@suse.cz
- solve_and_commit() changed to return informative exit codes if
  a reboot or package manager restart is needed after
  installation/removal of patches requiring such actions.
- 0.6.7
* Fri Nov 10 2006 mvidner@suse.cz
- Do not obsolete y2pmsh.rpm yet.
* Thu Nov  9 2006 mvidner@suse.cz
- Fixed option parsing broken by unterminated option lists in 0.6.4
  (for example install -t was thinking -t stood for --terse).
- If "install"ing more resolvables at a time, don't commit one by one.
- 0.6.6
* Wed Nov  8 2006 jkupec@suse.cz
- Several exit codes defined for use in scripts.
* Wed Nov  8 2006 mvidner@suse.cz
- Call dump_pool more often for better debugging.
- 0.6.5
* Tue Nov  7 2006 jkupec@suse.cz
- --help option added for each command
- help texts added
- unkown command on 'zypper --help' fixed
- defaulting to package in rug compatibility for search command
- Bundle column replaced by Type in non-compatible mode
- 0.6.4
* Mon Nov  6 2006 jkupec@suse.cz
- Unknown command message added (#216211)
- 0.6.3
* Mon Nov  6 2006 mvidner@suse.cz
- Made it build on SL10.1
- 0.6.2
* Mon Nov  6 2006 mvidner@suse.cz
- Warn that we do not sync with ZMD (#217028).
- 0.6.1
* Sun Nov  5 2006 mvidner@suse.cz
- Implemented single package mode for update and list-updates,
  made it the default in rug-compatible mode.
- Added logrotate support (#216911).
- Added callbacks for script execution.
- 0.6.0
* Sat Nov  4 2006 mvidner@suse.cz
- Ported zypper (except zypp-checkpatches) to libzypp-1.x.x.
- Show patch messages.
- Callbacks: fixed more warnings about unused variables.
- Fixed zypper --version.
* Fri Nov  3 2006 mvidner@suse.cz
- log to /var/log/YaST2/zypper.log (for save_y2logs too).
- Added dump_pool in "zypper patches"
* Thu Nov  2 2006 mvidner@suse.cz
- Automatically retry installing with nodeps or force, nicer problem
  display, no more "3, 0 Invalid object" (#216042).
- Do not parse metadata of disabled sources *blush* (#217297).
- Display all "Parsing patch..." on one line.
- Shell would try to repeat the install command over and over,
  fixed.
* Thu Nov  2 2006 dmacvicar@suse.de
- zypp-checkpatches fixes:
  dont use sourcemanager to restore sources,
  Restore sources one by one,
  skip CD/DVD and disabled sources,
  allow success with still reporting errors,
  new xml format 0.4 , applet coming
- 0.5.3
- r4474
* Wed Nov  1 2006 mvidner@suse.cz
- Added a manual page zypper(8) (#216028).
- do not unnecessarily link zypper with boost_program_options.
- fixed documentation directories
- 0.5.2, r4462
* Wed Nov  1 2006 jkupec@suse.cz
- -y, --no-confirm option implemented for install, remove,
  and update command (#216649).
- -r, --rug-compatibility global option introduced - for cases where
  there may be scripts used to parsing rug output
- patch-info implemented
- refresh implemented
- service-list says Enabled and Refresh instead of [x]*
* Wed Nov  1 2006 mvidner@suse.cz
- First try of zypper "shell" command.
* Tue Oct 31 2006 mvidner@suse.cz
- Fixed endless loop if stdin not available (#216210).
- Better messages (#216033):
  replaced "Adding resolvables" by "Parsing metadata";
  replaced "Not found" by "package 'foo' not found";
  removed "Problems: (none)";
  removed "Continue?" if there is nothing to install/remove.
* Sun Oct 29 2006 ro@suse.de
- add missing return value
- also use RPM_OPT_FLAGS for C source
* Fri Oct 27 2006 jkupec@suse.cz
- FIXED --uninstalled-only does't exclude installed resolvables
- FIXED search for all resolvables displays installed packages
  twice
- FIXED source (catalog) information missing for installed packages
- added rug's 'v' status
- 0.5.1
* Wed Oct 25 2006 mvidner@suse.cz
- Split the package from libzypp.rpm
- 0.5.0
