#
# spec file for package ethtool
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

# ---------------------------------------------------------------------------
# Contents of this package is exported from git repository; please submit
# your changes via https://gitlab.suse.de/mkubecek/ethtool-source or
# gitlab@gitlab.suse.de:mkubecek/ethtool-source.git rather than to IBS.
# ---------------------------------------------------------------------------

Name:           ethtool
Version:        6.4
Release:        150600.7.3.2
Summary:        Utility for examining and tuning Ethernet-based network interfaces
License:        GPL-2.0-only
Group:          Productivity/Networking/Diagnostic
URL:            https://www.kernel.org/pub/software/network/ethtool/

#Git-Clone:	git://git.kernel.org/pub/scm/network/ethtool/ethtool
Source:         https://www.kernel.org/pub/software/network/ethtool/%{name}-%{version}.tar.xz
Source2:        https://www.kernel.org/pub/software/network/ethtool/%{name}-%{version}.tar.sign
Source3:        %{name}.keyring
Source11:       patches.tar.xz
Source12:       series.conf
Source13:       guards
Source14:       apply-patches
BuildRequires:  pkgconfig(libmnl)


%description
Ethtool is a small utility for examining and tuning ethernet-based
network interfaces.  See the man page for more details.

%prep
%setup -q -a 11
chmod a+rx %{SOURCE13} %{SOURCE14}
%{SOURCE13} <%{SOURCE12} | %{SOURCE14} && rm -rf patches

%build
export CFLAGS="%optflags -Wall -Wextra -Wstrict-prototypes -Wformat-security -Wpointer-arith"
%configure
make %{?_smp_mflags}

%install
make install DESTDIR="%buildroot"

%files
%defattr(-,root,root)
%{_sbindir}/ethtool
%dir %{_datadir}/bash-completion
%dir %{_datadir}/bash-completion/completions
%{_datadir}/bash-completion/completions/ethtool
%{_mandir}/man8/ethtool.8*
%license COPYING
%doc AUTHORS NEWS

%changelog
* Mon May 20 2024 mkubecek@suse.cz
- upgrade to upstream version 6.4 (jsc#PED-5946 jsc#PED-8451)
  * for full list of changes between 5.14 and 6.4 see upstream
    changelog (file NEWS)
- cosmetic changes in specfile
- add post-6.4 upstream follow-up fixes (bsc#1224590)
  * netlink-Allow-nl_sset-return-EOPNOTSUPP-to-fallback-.patch
  * rxclass-fix-a-bug-in-rmgr-when-searching-for-empty-s.patch
  * Add-missing-header-files-for-source-distribution.patch
  * ethtool-Fix-SFF-8472-transceiver-module-identificati.patch
  * netlink-fix-typo-in-coalesce_reply_cb.patch
- fix SFP module diagnostic information (bsc#1222079)
  * ethtool-Fix-SFF-8472-transceiver-module-identificati.patch
* Fri Nov  5 2021 mkubecek@suse.cz
- upgrade to upstream version 5.14 (jsc#SLE-17360, jsc#SLE-19267)
  * upstream 5.9 -> 5.10
  - Feature: infrastructure for JSON output
  - Feature: separate FLAGS in -h output
  - Feature: use policy dumps to check flags support
  - Feature: show pause stats (-a)
  - Feature: pretty printing of policy dumps
  - Feature: improve error message when SFP module is missing
  - Fix: use after free in netlink_run_handler()
  - Fix: leaked instances of struct nl_socket
  - Fix: improve compatibility between netlink and ioctl (-s)
  * upstream 5.10 -> 5.12
  - Feature: support lanes count (no option and -s)
  - Fix: fix help message for master-slave parameter (-s)
  - Fix: better error message for master-slave in ioctl code path
  - Fix: get rid of compiler warnings in "make check"
  * upstream 5.12 -> 5.13
  - Feature: netlink handler for FEC (--show-fec and --set-fec)
  - Feature: FEC stats support (--show-fec)
  - Feature: standard based stats support (-S)
  - Feature: netlink handler for module EEPROM dump (-m)
  - Feature: page, bank and i2c selection in module dump (-m)
  * upstream 5.13 -> 5.14
  - Feature: do not silently ignore --json if unsupported
  - Feature: support new message types in pretty print
  * drop mainline backports contained in v5.14
    ethtool-Improve-compatibility-between-netlink-and-io.patch
    netlink-do-not-send-messages-and-process-replies-in-.patch
    netlink-fix-leaked-instances-of-struct-nl_socket.patch
    netlink-fix-use-after-free-in-netlink_run_handler.patch
* Tue Nov 10 2020 mkubecek@suse.cz
- backport post-5.9 fixes (bsc#1178633)
  * netlink-fix-use-after-free-in-netlink_run_handler.patch
  * netlink-fix-leaked-instances-of-struct-nl_socket.patch
  * netlink-do-not-send-messages-and-process-replies-in-.patch
  * ethtool-Improve-compatibility-between-netlink-and-io.patch
* Tue Nov 10 2020 mkubecek@suse.cz
- upgrade to upstream version 5.9 (jsc#SLE-15156, bsc#1178633)
- ethtool.spec:
  * minor cleanups from Factory package
  * drop compiler warnings suppression which is no longer needed
  * replace "-W" compiler option with preferred form "-Wextra"
- ethtool.keyring: add new upstream maintainer's key
* Wed Nov  6 2019 mkubecek@suse.cz
- upgrade to upstream version 5.3 (jsc#SLE-7328)
  * drop mainline backports contained in v5.3
    Revert-ethtool-Add-DMA-Coalescing-support.patch
    ethtool-Support-for-FEC-encoding-control.patch
    ethtool-add-support-for-extra-RSS-contexts-and-RSS-s.patch
    ethtool-better-syntax-for-combinations-of-FEC-modes.patch
    ethtool-copy.h-sync-with-net-next-2.patch
    ethtool-copy.h-sync-with-net-next.patch
    ethtool-correct-VF-index-values-for-the-ring_cookie-.patch
    ethtool-correct-display-of-VF-when-showing-vf-queue-.patch
    ethtool-don-t-fall-back-to-grxfhindir-when-context-w.patch
    ethtool-fix-MFLCN-register-dump-for-82599-and-newer.patch
    ethtool-fix-stack-clash-in-do_get_phy_tunable-and-do.patch
    ethtool-show-VF-and-queue-in-the-help-for-N.patch
    ethtool-support-combinations-of-FEC-modes.patch
    ethtool.8-Document-RSS-context-control-and-RSS-filte.patch
  * provide bash completion
- minor specfile cleanup
* Mon Oct 22 2018 mkubecek@suse.cz
- add support for FEC parameters (fate#326122 bsc#1105557):
  ethtool-Support-for-FEC-encoding-control.patch
  ethtool-support-combinations-of-FEC-modes.patch
  ethtool-better-syntax-for-combinations-of-FEC-modes.patch
* Mon Oct 22 2018 mkubecek@suse.cz
- add support for RSS contexts (fate#326122 bsc#1105557):
  ethtool-copy.h-sync-with-net-next-2.patch
  ethtool-add-support-for-extra-RSS-contexts-and-RSS-s.patch
  ethtool.8-Document-RSS-context-control-and-RSS-filte.patch
  ethtool-don-t-fall-back-to-grxfhindir-when-context-w.patch
* Mon Oct 22 2018 mkubecek@suse.cz
- fix stack clash for PHY tunables (bsc#1092037):
  ethtool-fix-stack-clash-in-do_get_phy_tunable-and-do.patch
- sync UAPI header copies with SLE15 kernel:
  Revert-ethtool-Add-DMA-Coalescing-support.patch
  ethtool-copy.h-sync-with-net-next.patch
* Thu Apr  5 2018 mkubecek@suse.cz
- add warning that changes should be submitted via git (i.e. not
  directly to IBS) to the specfile
- drop BuildRoot (no longer needed in SLE15)
- drop BuildRequire for xz (no longer needed in SLE15)
* Thu Apr  5 2018 mkubecek@suse.cz
- use %%license rather than %%doc for license file (bsc#1082318)
* Thu Apr  5 2018 mkubecek@suse.cz
- add backported post-4.13 upstream fixes (bsc#1088294):
  ethtool-fix-MFLCN-register-dump-for-82599-and-newer.patch
  ethtool-correct-display-of-VF-when-showing-vf-queue-.patch
  ethtool-show-VF-and-queue-in-the-help-for-N.patch
  ethtool-correct-VF-index-values-for-the-ring_cookie-.patch
* Mon Oct 30 2017 mkubecek@suse.cz
- Update to new upstream release 4.13
  * Feature: add support for HWTSTAMP_FILTER_NTP_ALL
  * Feature: Add DMA Coalescing support
  * Feature: Remove UDP Fragmentation Offload error prints
  * Feature: stmmac: Add DMA HW Feature Register
  * Fix: Do not return error code if no changes were attempted.
  * Fix: Fix formatting of advertise bitmask
  * Fix: fix the rx vs tx mixup in set channel message
* Tue Jun  6 2017 mkubecek@suse.cz
- Update to new upstream release 4.11
  * Feature: Support for configurable RSS hash function
  * Feature: support queue and VF fields for rxclass filters
  * Feature: Add support for 2500baseT/5000baseT link modes
  * Fix: Fix SFF 8079 cable technology bit parsing
  * Fix: sync help output for -x/-X with man page
* Thu Mar 30 2017 mkubecek@suse.cz
- Update to new upstream release 4.10
  * Fix: Fix the "advertise" parameter logic.
  * Feature: Implement ETHTOOL_PHY_GTUNABLE/ETHTOOL_PHY_STUNABLE and PHY downshift
  * Feature: add register dump support for fjes driver (-d option)
- add keyring with John Linville's key for tarball verification
* Tue Oct 11 2016 mkubecek@suse.cz
- Update to new upstream release 4.8
  * Feature: QSFP Plus/QSFP28 Diagnostics Information Support
  * Feature: Enhancing link mode bits to support 25G/50G/100G
  * Feature: add support for 1000BaseX and missing 10G link mode
  * Fixes: address Coverity issues 1363118 - 1363125
* Mon Jul  4 2016 mkubecek@suse.cz
- Update to new upstream release 4.6
  * Feature: Support register dump on Intel X550 NICs (-d option)
  * Fix: Correct some reported register offsets on Intel 10GbE NICs
    (-d option)
  * Feature: Add IPv6 support to NFC (-n, -N, -u and -U options)
  * Feature: Add support for ETHTOOL_xLINKSETTINGS ioctls (no
    option and -s option)
  * Feature: Use netlink socket when AF_INET not available
* Tue Mar 15 2016 mkubecek@suse.cz
- Update to new upstream release 4.5
  * Fix: Heap corruption when dumping registers from a file
    (-d option)
  * Fix: Stricter input validation for EEPROM setting (-E option)
  * Feature: Add PHY statistics support (--phy-statistics option)
  * Feature: Support setting default Rx flow indirection table
    (-X option)
  * Doc: Properly indent sub-options in man page
  * address build issues (mostly compiler warnings)
* Fri Oct  9 2015 mkubecek@suse.cz
- Update to new upstream release 4.2
  * Feature: Support soldered-on modules in module EEPROM dump
    (-m option)
  * Feature: Add register dump support for VMware vmxnet3
    (-d option)
  * Feature: Update register dump support for IBM EMAC (-d option)
    (requires Linux 4.3 or a future stable update to 4.1 or 4.2)
  * Doc: Fix typo in man page
* Mon Jun  1 2015 mkubecek@suse.cz
- Update to new upstream release 4.0
  * Fix: Formatting of RX flow hash indirection table when size not
    divisible by 8 (-x option)
  * Fix: Add missing Advertised speeds (no option and -s option)
  * Feature: Add support to get expansion ROM version (-i option)
  * Feature: Include SFP serial number and date in EEPROM dump
    (-m option)
* Sun Jan 11 2015 jengelh@inai.de
- Update to new upstream release 3.18
  * Fix: Lookup of SFP Tx bias in SFF-8472 module diagnostics
  (-m option)
- Drop usrmerge compat symlinks
* Tue Nov 18 2014 jengelh@inai.de
- Update to new upstream release 3.16
  * Support for configurable RSS hash key (-x/-X options)
  * Add register dump support for Altera Triple Speed Ethernet
  (-d option)
  * Report Backplane as a supported port
- Remove unused call to %%gpg_verify (the macro expands to nothing);
  source validation handled by osc.
* Thu Feb  6 2014 puzel@suse.com
- Drop ethtool-display-switch-port-attributes.patch (failed
  upstream acceptance and has to be reworked)
* Thu Dec  5 2013 puzel@suse.com
- Add '-q' command line option to display switch port attributes
  (bnc#853637, fate#315293)
- added patches:
  * ethtool-display-switch-port-attributes.patch
* Sun Nov 24 2013 p.drouand@gmail.com
- Update to version 3.12.1
  * Fix: Memory corruption when applying external calibration to
  SFF-8472 module diagnostics (-m option)
  * Feature: Add Intel 82599 and x540 DCB registers to dump
  (-d option)
- Changes from 3.12
  * Fix: Remove alternate method to check for VLAN tag offload on Linux
  < 2.6.37 (-k/-K options)
  * Fix: Hide state of VLAN tag offload and LRO if the kernel is too old
  for us to reliably detect them (-k option)
  * Feature: Add register dump support for Solarflare SFC9100 family
  (-d option)
- Changes from 3.11
  * Feature: Update Realtek chip list for register dump to match
  r8169 driver in Linux 3.11 (-d option)
  * Feature: Add ixgbevf support for register dump (-d option)
  * Feature: Filter ixgbe register dump according to the specific chip
  (-d option)
* Thu Jul  4 2013 jengelh@inai.de
- Update to new upstream release 3.10
  * Displaying of support for 10000BASE-KR link mode was implemented.
  * Support for new versions of ixgbe register dump was added.
  * The private flags print output was beautified.
- More robust make install call
- Optional signature verification
* Mon Apr 22 2013 puzel@suse.com
- Update to new upstream release 3.8
  * Feature: Allow setting destination MAC address in L3/L4 flow
    spec rules (-N/-U option)
  * Fix: Show full 64 bits of user-data (-n/-u option)
  * Fix: Add version check for et131x regs (-d option)
  * Doc: Improve description of -f, -t, -s, -N/-U, -W options in
    man page
  * Fix: Restore 20000baseKR2 cap display (no options)
* Mon Dec 17 2012 puzel@suse.com
- Update to new upstream release 3.7
  * Fix: Gracefully handle failure of register pretty-printer (-d
    option)
  * Feature: Add support for et131x registers (-d option)
  * Feature: Basic optical diagnostics for SFF-8472 modules (-m
    option)
* Mon Oct  8 2012 puzel@suse.com
- Update to new upstream release 3.6
  * Feature: Allow setting MDI-X state (-s option)
  * Fix: Preserve pause advertising bits when setting speed and
    duplex with autoneg on (-s option)
  * Fix: Don't call ioctl to set EEE parameters if they are the
    same as the current parameters (--set-eee option)
* Mon Aug  6 2012 puzel@suse.com
- Update to new upstream release 3.5
  * Display support for 1000BASE-KX and 10GBASE-KX4 link modes
  * Energy-Efficient Ethernet (EEE) configuration
    (--show-eee and --set-eee options)
  * Display support for 40G link modes
  * Fix: Don't trust drivers to null-terminate strings
* Sat Jun 16 2012 jengelh@inai.de
- Update to new upstream release 3.4.1
  * This release adds reporting of driver features ("-i")
  * reporting of supported pause frame modes and of 20G link modes
  * firmware dumps ("-w" and "-W")
  * external loopback tests ("-t")
  * reporting and configuring the number of channels/queues
  ("-l" and "-L") and time stamping capabilities ("-T")
  * reporting of pause frame autonegotiation results ("-a")
  * support for querying and setting all generic net device features
  ("-k" and "-K") and private flags
  * dumping of plugin module EEPROM ("-m")
* Wed May 16 2012 andreas.stieger@gmx.de
- Add xz build requirement to fix build for openSUSE 11.4
* Mon Feb 27 2012 puzel@suse.com
- update to ethtool-3.2
  * Feature: Add support for querying and setting private flags
    (--show-priv-flags, --set-priv-flags options)
  * Feature: Omit zero values in Solarflare register tables (-d
    option)
  * Feature: Allow driver to select RX NFC rule location (-U
    option)
  * Fix: Correct register dump offsets for Intel 82575 chipsets
    (-d option)
* Wed Feb  8 2012 rschweikert@suse.com
- keep binary in /usr tree (UsrMerge project)
* Tue Dec 13 2011 puzel@suse.com
- update to ethtool-3.1
  * Fix: Show all non-zero registers for tg3 (-d option)
  * Feature: Add support for external loopback test (-t option)
  * Fix: Show correct flow control registers for Intel 82599 (-d option)
  * Feature: Add support for reporting and configuring numbers of
    channels/queues (-l and -L options)
  * Feature: Report pause frame autonegotiation result (-a option)
  * Doc: Change device name metavariable from 'ethX' to 'devname'
  * Doc: Fix various layout problems
  * Cleanup: Reorganise and add test cases for argument parsing
  * Fix: Strictly check for extraneous or missing arguments; in
    particular, fail if the device name is missing
* Wed Dec  7 2011 cfarrell@suse.com
- license update: GPL-2.0
  sfc.c and stmmac.c have GPL-2.0 licenses
* Fri Dec  2 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Sun Sep 18 2011 jengelh@medozas.de
- Remove redundant/obsolete tags/sections from specfile
  (cf. packaging guidelines)
* Mon Aug  8 2011 puzel@novell.com
- update to ethtool-3.0
  * Feature: Report supported pause frame modes
  * Feature: Support firmware dump (-w and -W options)
  * Feature: Report advertised and supported 20G link modes
  * Feature: Add an 'l4data' option for ip4 filters (-U option)
  * Fix: Correct swapped h_source and h_dest fields for ether
    filters (-U option)
  * Fix: Set ip_ver field correctly for ip4 filters (-U option)
  * Fix: Correct parameter validation for -e and -E options; in
    particular, treat the 'magic' value as unsigned
  * Feature: Report some driver features (-i option)
  * Doc: Remove misleading 'Auto' advertising mask from manual page
  * Doc: Improve table formatting on manual page, using tbl
  * Doc: Remove initial blank page in printed manual page
  * Doc: Fix line-wrapping of options
  * Feature: Add support for ESP as a separate protocol from AH
    (-n, -N, -u and -U options)
  * Cleanup: Remove support for showing RX n-tuple settings
    (-u option), which was never implemented correctly in the kernel
  * Feature: Add support for RX network flow classifier (NFC)
    (-u and -U options)
  * Feature: Add support for e1000 M88 PHY registers (-d option)
  * Cleanup: Change bug-address to netdev
- use spec-cleaner
* Tue Mar 15 2011 bphilips@novell.com
- Update to ethtool-2.6.38
  * Doc: Fix spelling and spacing in online help
  * Doc: Update date, version and web site reference in manual page
  * Doc: Fix spelling, capitalisation, consistency and style in
    manual page
  * Doc: Generalise some references to network devices rather than
    Ethernet devices
  * Fix: Don't silently ignore speed/duplex when autoneg is on
  * Fix: Report an error (rather than full usage information) if
    given an unrecognised option
  * Feature: Add --version option
* Thu Nov 18 2010 puzel@novell.com
- update to ethtool-2.6.36
  * Fix: RX n-tuple masks and documentation
  * Feature: Ethernet-level RX n-tuple filtering and 'clear' action
  * Feature: stmmac register dump support
  * Feature: get permanent address (-P) option
  * Feature: VLAN acceleration control
  * Feature: sfc register dump support
  * Feature: improve cmd line parsing of ints, IPv4 addresses
  * Feature: support ethtool named flags, messaging types
  * Feature: minor man page fixes
  * Feature: control RX flow hash indirection
* Tue Jul 27 2010 puzel@novell.com
- update to ethtool-2.6.34
  * Feature: Support n-tuple filter programming
  * Feature: Support rx hashing, v2 (targetted for 2.6.35)
  * Feature: Add names of newer Marvell chips
  * new release numbering scheme, based
    on the latest upstream kernel interface supported.
  * Fix: several man page corrections
  * Feature: rx flow hash configuration
  * Feature: report 10000baseT support, where available
  * Feature: report MDI-X status, pause auto-neg, link partner
    adverts
  * Feature: support additional port types
  * Feature: support arbitrary speeds, faster than 65535 Mb
  * Feature: large and generic receive offload (LRO, GRO) support
  * Feature: option to flash firmware image from specified file
  * Feature: support for block writing of EEPROMs
  * Feature: marvell register dump update
  * Feature: at76c50x-usb, e1000e, igb, ixgbe, r8169 register
    dump support
  * Cleanup: remove support for RX hashing by port
  * Doc: Explicitly ship GPLv2 license
- drop all patches (fixed upstream)
* Mon Jul 12 2010 puzel@novell.com
- add get-set-gro-settings.patch (bnc#616263)
* Fri Jan  8 2010 jengelh@medozas.de
- enable parallel build
* Tue Dec  1 2009 mseben@novell.com
- add speed-parse.patch : fix parse of 10Gbe option (bnc#557016)
- add cmd-speed-display-all.patch Display all NIC speeds [FATE#305494]
* Tue Nov  4 2008 hvogel@suse.de
- Add support for LRO (Large Receive Offload) [bnc#440003]
* Fri Sep 12 2008 bphilips@suse.de
- Add support for larger speed field to do greater than 65535Mb/s devices
* Wed Dec 19 2007 mskibbe@suse.de
- Bug 285472 - network script does not work for /usr over NFS
* Fri Jul 27 2007 mskibbe@suse.de
- update to version 6 which includes:
  o updates for a lot of NICs
  o preparing for 10G NICs
  o a log Bugfixes
* Thu Apr 12 2007 lnussel@suse.de
- remove superfluous buffer overflow check patch
* Wed Sep  6 2006 mskibbe@suse.de
- fix bug #202756 - No Buffer Overflow check in Ethtool
* Mon Sep  4 2006 mskibbe@suse.de
- update to version 5 which includes:
  o Security: Avoid potential buffer overflow
  o Feature: GSO support
  o Feature: skge register dump
* Thu Aug 31 2006 mskibbe@suse.de
- update to version 4 which
  o includes UFO support
  o support long options
  o includes e1000, pcnet32, tg3 updates
  o added PPC4xx EMAC support
  o Use hexdump instead of single values for register dump
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Sat Jan 29 2005 hvogel@suse.de
- update to version 3
* Mon Aug 23 2004 mmj@suse.de
- Update to ethtool-2 which includes all our patches
* Thu Jun 24 2004 meissner@suse.de
- Added pcnet32 register dumping LTC#9592/SUSE#42408.
* Mon May 24 2004 meissner@suse.de
- return error value from test option LTC#7166/SUSE#40960.
* Sun Jan 11 2004 adrian@suse.de
- build as user
* Tue Aug 26 2003 pthomas@suse.de
- Upgraded to 1.8
* Tue Aug 26 2003 pthomas@suse.de
- Remove the bogus rejection of devices whose names that do not begin
  with either 'eth' or 'usb'.
* Mon Jun  2 2003 pthomas@suse.de
- Add support for AMD-8111.
* Fri Feb  7 2003 meissner@suse.de
- Upgraded to current CVS, which has some e1000 fixes needed by IBM.
* Thu Feb  6 2003 meissner@suse.de
- Upgraded to 1.7:
* Mon Jun 24 2002 pthomas@suse.de
- Initial package creation.
- Fix most gcc warnings.
