#
# spec file for package nftables
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

# configure subpackage rewriter for the python3XX-nftables bindings
%define python_subpackage_only 1
# check py/src/nftable.py:NFTABLES_VERSION
%define pyversion 0.1

%define skip_python2 1
%{?sle15allpythons}

Name:           nftables
Version:        0.9.8
Release:        150400.6.3.1
Summary:        Userspace utility to access the nf_tables packet filter
License:        GPL-2.0-only
Group:          Productivity/Networking/Security
URL:            https://netfilter.org/projects/nftables/

#Git-Clone:	git://git.netfilter.org/nftables
Source:         http://ftp.netfilter.org/pub/nftables/nftables-%version.tar.bz2
Source2:        http://ftp.netfilter.org/pub/nftables/nftables-%version.tar.bz2.sig
Source3:        %name.keyring
Patch1:         0001-cache-check-for-NULL-chain-in-cache_init.patch
Patch2:         0001-evaluate-reject-support-ethernet-as-L2-protocol-for-.patch
BuildRequires:  asciidoc
BuildRequires:  bison
BuildRequires:  fdupes
BuildRequires:  flex
BuildRequires:  gmp-devel
BuildRequires:  %{python_module pip}
BuildRequires:  %{python_module setuptools}
BuildRequires:  %{python_module wheel}
BuildRequires:  python-rpm-macros
BuildRequires:  pkg-config >= 0.21
BuildRequires:  readline-devel
BuildRequires:  pkgconfig(jansson)
BuildRequires:  pkgconfig(libmnl) >= 1.0.4
BuildRequires:  pkgconfig(libnftnl) >= 1.1.9
BuildRequires:  pkgconfig(xtables) >= 1.6.1
%python_subpackages

%description
nf_tables is a firewalling mechanism in the Linux kernel, running
independently of and parallel to ip_tables, ip6_tables,
arp_tables and ebtables. nftables is the corresponsing userspace
frontend.

The nftables frontend features support for sets and dictionaries of arbitrary
types, meta data types, atomic incremental and full ruleset updates, and,
similar to iptables, support for different protocols, access to connection
tracking and NAT and logging.

%package -n libnftables1
Summary:        nftables firewalling command interface
Group:          System/Libraries

%description -n libnftables1
libnftables is the nftables command line interface placed into a
library.

%package devel
Summary:        Development files for the nftables command line interface
Group:          Development/Libraries/C and C++
Requires:       libnftables1 = %version

%description devel
libnftables is the nftables command line interface placed into a
library.

This package contains the header files for the library.

%package -n python-nftables
Summary:        Python interface for nftables
Group:          Development/Languages/Python
BuildArch:      noarch

%description -n python-nftables
A Python module for nftables.

%prep
%autosetup -p1
# remove unused shebang
sed -i '1{/bin/d}' py/nftables.py

%build
mkdir bin
ln -s "%_bindir/docbook-to-man" bin/docbook2x-man
export PATH="$PATH:$PWD/bin"
mkdir obj
pushd obj/
%define _configure ../configure
%configure --disable-silent-rules --disable-static --docdir="%_docdir/%name" \
	--includedir="%_includedir/%name" --with-json \
	--enable-python --with-python-bin="$(which python3)"
%make_build
popd
pushd py
%pyproject_wheel
popd

%install
b="%buildroot"
%make_install -C obj
pushd py
%pyproject_install
%python_expand %fdupes %buildroot/%{$python_sitelib}
popd
rm -f "%buildroot/%_libdir"/*.la
mkdir -p "$b/%_docdir/%name/examples"
mv "$b/%_sysconfdir/nftables"/* "$b/%_docdir/%name/examples/"

%post   -n libnftables1 -p /sbin/ldconfig
%postun -n libnftables1 -p /sbin/ldconfig

%files
%license COPYING
%_sbindir/nft
%_mandir/man5/*.5*
%_mandir/man8/nft*
%_docdir/%name/

%files -n libnftables1
%_libdir/libnftables.so.1*

%files devel
%_includedir/%name/
%_libdir/libnftables.so
%_libdir/pkgconfig/*.pc
%_mandir/man3/*.3*

%files %{python_files nftables}
%{python_sitelib}/nftables*

%changelog
* Tue Jan 30 2024 matthias.gerstner@suse.com
- port python-single-spec logic from Factory package to allow shipment of
  python311 modules as well (bsc#1219253).
* Tue Apr 25 2023 matthias.gerstner@suse.com
- add 0001-evaluate-reject-support-ethernet-as-L2-protocol-for-.patch: this
  fixes a crash in nftables if layer2 reject rules are processed (e.g.
  Ethernet MAC address based reject rich rule in firewalld, bsc#1210773).
* Mon May  2 2022 matthias.gerstner@suse.com
- add 0001-cache-check-for-NULL-chain-in-cache_init.patch: this fixes rare
  crashes that could occur e.g. in firewalld (bsc#1197606).
* Fri Jan 15 2021 jengelh@inai.de
- Update to release 0.9.8
  * Complete support for matching ICMP header content fields.
  * Added raw tcp option match support.
  * Added ability to check for the presence of any tcp option.
  * Support for rejecting traffic from the ingress chain.
* Tue Oct 27 2020 jengelh@inai.de
- Update to release 0.9.7
  * Support for implicit chains
  * Support for ingress inet chains
  * Support for reject from prerouting chain
  * Support for --terse option in json
  * Support for the reset command with json
* Tue Jun 16 2020 jengelh@inai.de
- Update to release 0.9.6
  * Fix two ASAN runtime errors
* Sat Jun  6 2020 jengelh@inai.de
- Update to release 0.9.5
  * Support for set counters.
  * Support for restoring set element counters via nft -f.
  * Counter support for flowtables.
  * typeof concatenations support for sets.
  * Support for concatenated ranges in anonymous sets.
  * Allow to reject packets with 802.1q from the bridge family.
  * Support for matching on the conntrack ID.
- Drop anonset-crashfix.patch (upstream solved differently)
* Thu May  7 2020 jengelh@inai.de
- Add anonset-crashfix.patch [boo#1171321]
* Wed Apr  1 2020 jengelh@inai.de
- Update to release 0.9.4
  * Add a helper for concat expression handling.
  * Add "typeof" build/parse/print support.
* Mon Dec  9 2019 jengelh@inai.de
- Add json, python [boo#1158723]
* Tue Dec  3 2019 jengelh@inai.de
- Update to release 0.9.3
  * meta: Introduce new conditions "time", "day" and "hour".
  * src: add ability to set/get secmarks to/from connection.
  * flowtable: add support for named flowtable listing.
  * flowtable: add support for delete command by handle.
  * json: add support for element deletion.
  * Add `-T` as the short option for `--numeric-time`.
  * meta: add ibrpvid and ibrvproto support
* Mon Aug 19 2019 jengelh@inai.de
- Update to new upstream release 0.9.2
  * Transport header port matching, e.g. "th dport 53"
  * Support for matching on IPv4 options
  * Support for synproxy
* Sat Jan 19 2019 stefan.bruens@rwth-aachen.de
- Remove unused dblatex BuildRequires, only needed for the optional
  and disabled PDF generation (same contents as shipped manpage).
* Sat Jun  9 2018 jengelh@inai.de
- Update to new upstream release 0.9.0
  * Support to check if packet matches an existing socket.
  * Support to limit number of active connections by arbitrary
    criteria, such as ip addresses, networks, conntrack zones or
    any combination thereof.
  * Added support for "audit" logging.
* Fri May 11 2018 jengelh@inai.de
- Update to new upstream release 0.8.5
  * support to add/insert a rule at a given index position
  * meter statement now supports a configureable upper max size
  * timeouts for sets can now be specified in milliseconds
  * re-add iptables-like empty skeleton rulesets
* Wed May  2 2018 jengelh@inai.de
- Update to new upstream release 0.8.4
  * Support to match IPv6 segment routing headers.
  * New "meta ibrname" and "meta obrname" arguments to match the
    name of the logical bridge a packet is passing through.
    These new names replace the old (misnamed) "ibriport"/"obriport".
  * `nft -a` will now show handle identifier for all objects,
    including tables and chains.
  * nft can now delete objects by their handle number.
  * Support to update maps from the ruleset (packet path).
  * the "--echo" option now prints handle id for tables and
    object too.
  * `nft -f -` will now read from standard input
  * Support for flow tables, cf. man page or
    https://lwn.net/Articles/738214/ .
* Sat Mar  3 2018 jengelh@inai.de
- Update to new upstream release 0.8.3
  * raw payload support to match headers that do not yet have
    received a mnemonic.
* Sat Feb  3 2018 jengelh@inai.de
- Update to new upstream release 0.8.2
  * add secpath support
* Tue Jan 16 2018 jengelh@inai.de
- Update to new upstream release 0.8.1
  * This release deprecates the "flow table" syntax in favor
    of "meter".
* Fri Oct 13 2017 jengelh@inai.de
- Update to new upstream release 0.8
  * This release contains new features available up to the
    (upcoming) Linux 4.14 kernel release:
  * Support for stateful objects, these objects are uniquely
    identified by a user-defined name, you can refer to them from
    rules, and there is a well established interface to operate
    with them.
  * Sort set elements when listing them, from lower to largest.
  * TCP option matching and mangling support. This includes TCP
    maximum segment size mangling.
  * Add new "-s" option for listings without stateful information.
  * Add new -c/--check option for nft, to tests if your ruleset
    loads fine, into the kernel, this is a dry run mode.
  * Connection tracking helper support.
  * Add --echo option, to print the handle that the kernel
    allocates to uniquely identify rules.
  * Conntrack zone support
  * Symmetric hash support
  * Add support to include directories from nft natives scripts,
    files are loaded in alphanumerical order.
  * Allow to check if IPv6 extension header or TCP option exists
    or is missing.
  * Extend quota support to display used bytes.
  * Add ct average matching, to match average bytes per packet a
    connection has transferred so far, to map the existing
    feature available in the iptables connbytes match.
  * Allow to flush maps and flow tables.
  * Allow to embed set definition into an existing set.
  * Conntrack event filtering support via rule.
* Tue Dec 20 2016 jengelh@inai.de
- Update to new upstream release 0.7
  * Add new fib expression, which can be used to obtain the
    output interface from the route table based on either source
    or destination address of a packet.
  * Support hashing of any arbitrary key combination, eg.
  * Add number generation support. Useful for round-robin packet
    mark setting.
  * Add quota support, eg.
  * Introduce routing expression, for routing related data with
    support for nexthop
  * Notrack support, to explicitly skip connection tracking for
    matching packets.
  * Support to set non-byte bound packet header fields, including
    checksum adjustment.
  * Add 'create set' and 'create element' commands.
  * Allow to use variable reference for set element definitions.
  * Allow to use variable definitions from element commands.
  * Add support to flush set. You can use this new command to
    remove all existing elements in a set.
  * Inverted set lookups.
  * Honor absolute and relative paths via include file, where:
  * Support log flags, to enable logging TCP sequence and options.
  * tc classid parser support, eg.
  * Allow numeric connlabels, so if connlabel still works with
    undefined labels.
* Thu Jun  2 2016 jengelh@inai.de
- Update to new upstream release 0.6
  * Rules may be replaced now
  * Flow table support (requires Linux >= 4.3)
  * Support for tracing
  * Ratelimiting now supports units like bytes/second.
  * Matchinv VLAN IDs, DSCP/ECN, ICMP RtAdv & RtSol
* Thu Sep 17 2015 jengelh@inai.de
- Update to new upstream release 0.5
  * Support combinations of two or more selectors to build a tuple
  * Timeout support for sets
  * Dormant flag for tables
  * Default chain policy specifiable on creation
* Sat May 23 2015 mrueckert@suse.de
- set the url to the project page
- pass --disable-silent-rules to configure to allow gcc post build
  check to work
* Tue Dec 16 2014 jengelh@inai.de
- Update to new upstream release 0.4
  * Since Linux 3.18: support for global ruleset operations
  * Since 3.17: full logging support for all the families,
  including nfnetlink_log
  * 3.16: automatic selection of the optimal set implementation
  * 3.14: reject support for ip, ip6 and inet
  * 3.18: reject support for bridge, and reject icmpx abstraction
  * 3.18: masquerade support
  * 3.19: redirect support
  * Extend meta to support pkttype, cpu and devgroup matching.
* Fri Jun 27 2014 jengelh@inai.de
- Update to new upstream release 0.3
  * More compact syntax for the queue action
  * Match input and output bridge interface name through "meta
  ibriport" and "meta obriport"
  * netlink event monitor, to monitor ruleset events, set changes, etc.
  * New transaction infrastructure - fully atomic updates for all
  object available in the upcoming 3.16.
* Mon Jan 13 2014 jengelh@inai.de
- Initial package for build.opensuse.org
