#
# spec file for package libzypp
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

# Switched to single_rpmtrans as default install backed.
# SUSE distros stay with classic_rpmtrans as default.
# Code16: Want's to switch to single_rpmtrans as default
#         (level of enablement is handled in the code)
%if 0%{?suse_version} && 0%{?suse_version} < 1600
%bcond_without classic_rpmtrans_as_default
%else
%bcond_with classic_rpmtrans_as_default
%endif

# In Code16 libsolv moved the static libs from -devel to -devel-static.
# Those are needed while cmake -DSUSE enforces linking libsolv statically.
%if 0%{?suse_version} >= 1600
%define libsolv_devel_package libsolv-devel-static
%else
%define libsolv_devel_package libsolv-devel
%endif

%if 0%{?suse_version} > 1500 || 0%{?sle_version} >= 150400 || (0%{?is_opensuse} && 0%{?sle_version} >= 150100)
%bcond_without zchunk
%else
%bcond_with zchunk
%endif

# libsolvs external references might require us to link against zstd, bz2, xz
%if 0%{?sle_version} >= 150000 || 0%{?suse_version} >= 1500
%bcond_without zstd
%else
%bcond_with zstd
%endif
%if 0%{?sle_version} >= 120300 || 0%{?suse_version} >= 1330 || !0%{?suse_version}
%bcond_without bz2
%bcond_without xz
%else
%bcond_with bz2
%bcond_with xz
%endif

%bcond_without mediabackend_tests

# older libsigc versions have a bug that causes a segfault
# when clearing connections during signal emission
# see https://bugzilla.gnome.org/show_bug.cgi?id=784550
%if 0%{?sle_version} < 150200
%bcond_without sigc_block_workaround
%else
%bcond_with sigc_block_workaround
%endif


%if 0%{?suse_version} > 1500 || 0%{?sle_version} >= 150600
%bcond_without visibility_hidden
%else
%bcond_with visibility_hidden
%endif

Name:           libzypp
Version:        17.37.18
Release:        150600.3.82.1
License:        GPL-2.0-or-later
URL:            https://github.com/openSUSE/libzypp
Summary:        Library for package, patch, pattern and product management
Group:          System/Packages
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Source:         %{name}-%{version}.tar.bz2
Source1:        %{name}-rpmlintrc
Provides:       yast2-packagemanager
Obsoletes:      yast2-packagemanager

# bsc#1227793:  python zypp-plugin < 0.6.4 rejects stomp headers including a '-'
Conflicts:      python2-zypp-plugin < 0.6.4
Conflicts:      python3-zypp-plugin < 0.6.4
# API refactoring. Prevent zypper from using (now) private symbols
Conflicts:      zypper < 1.14.91

# Features we provide (update doc/autoinclude/FeatureTest.doc):
Provides:       libzypp(plugin) = 0.1
Provides:       libzypp(plugin:appdata) = 0
Provides:       libzypp(plugin:commit) = 1
Provides:       libzypp(plugin:services) = 1
Provides:       libzypp(plugin:system) = 1
Provides:       libzypp(plugin:urlresolver) = 0
Provides:       libzypp(plugin:repoverification) = 0
Provides:       libzypp(repovarexpand) = 1.1

%if 0%{?suse_version}
Recommends:     logrotate
# lsof is used for 'zypper ps':
Recommends:     lsof
%endif
BuildRequires:  cmake >= 3.17
BuildRequires:  pkgconfig(openssl)
BuildRequires:  pkgconfig(libudev)
%if 0%{?suse_version} >= 1330
BuildRequires:  libboost_headers-devel
BuildRequires:  libboost_program_options-devel
BuildRequires:  libboost_test-devel
BuildRequires:  libboost_thread-devel
%else
BuildRequires:  boost-devel
%endif
BuildRequires:  dejagnu
BuildRequires:  doxygen
BuildRequires:  texlive-latex
BuildRequires:  texlive-xcolor
BuildRequires:  texlive-newunicodechar
BuildRequires:  texlive-dvips
BuildRequires:  ghostscript
BuildRequires:  gcc-c++ >= 7
BuildRequires:  gettext-devel
BuildRequires:  graphviz
BuildRequires:  libxml2-devel
BuildRequires:  yaml-cpp-devel

# we are loading libproxy dynamically, however we have
# a failsafe unit test that links against libproxy to make
# sure the API did not change
BuildRequires:  libproxy-devel

#keep the libproxy runtime requires for old releases
%if 0%{?suse_version} && 0%{?suse_version} <= 1500 && 0%{?sle_version} <= 150500
Requires: libproxy1
%endif

%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:  pkgconfig
%else
BuildRequires:  pkg-config
%endif

BuildRequires:  %{libsolv_devel_package} >= 0.7.34
%if 0%{?suse_version} > 1500 || 0%{?sle_version} >= 150600
BuildRequires:  libsolv-tools-base >= 0.7.29
%requires_eq    libsolv-tools-base
%else
BuildRequires:  libsolv-tools
%requires_eq    libsolv-tools
%endif

BuildRequires:  glib2-devel
BuildRequires:  libsigc++2-devel
BuildRequires:  readline-devel >= 5.1

# required for testsuite
%if %{with mediabackend_tests}
BuildRequires:  nginx
BuildRequires:	vsftpd
BuildRequires:	squid
%endif

Requires:       rpm
BuildRequires:  rpm

%if 0%{?suse_version}
BuildRequires:  rpm-devel > 4.4
%endif

%if 0%{?fedora_version} || 0%{?rhel_version} >= 600 || 0%{?centos_version} >= 600
BuildRequires:  popt-devel
BuildRequires:  rpm-devel > 4.4
%endif

%if 0%{?mandriva_version}
BuildRequires:  librpm-devel > 4.4
%endif

%if 0%{?suse_version}
BuildRequires:  libgpgme-devel
#testsuite
%if %{with mediabackend_tests}
BuildRequires:  FastCGI-devel
%endif
%else
BuildRequires:  gpgme-devel
#testsuite
%if %{with mediabackend_tests}
BuildRequires:	fcgi-devel
%endif
%endif

%define min_curl_version 7.19.4
BuildRequires:  libcurl-devel >= %{min_curl_version}
%if 0%{?suse_version}
# Code11+
Requires:       libcurl4   >= %{min_curl_version}
%else
# Other distros (Fedora)
Requires:       libcurl   >= %{min_curl_version}
%endif

# required for documentation
%if 0%{?suse_version} >= 1330
BuildRequires:  rubygem(asciidoctor)
%else
BuildRequires:  asciidoc
BuildRequires:  libxslt-tools
%endif

%if %{with zchunk}
BuildRequires:  libzck-devel
%endif

%if %{with zstd}
BuildRequires:  libzstd-devel
%endif

%if %{with bz2}
%if 0%{?suse_version}
BuildRequires:  libbz2-devel
%else
BuildRequires:  bzip2-devel
%endif
%endif

%if %{with xz}
BuildRequires:  xz-devel
%endif

%description
libzypp is the package management library that powers applications
like YaST, zypper and the openSUSE/SLE implementation of PackageKit.

libzypp provides functionality for a package manager:

  * An API for package repository management, supporting most common
    repository metadata formats and signed repositories.
  * An API for solving packages, products, patterns and patches
    (installation, removal, update and distribution upgrade
    operations) dependencies, with additional features like locking.
  * An API for commiting the transaction to the system over a rpm
    target. Supporting deltarpm calculation, media changing and
    installation order calculation.
  * An API for browsing available and installed software, with some
    facilities for programs with an user interface.

%package devel
Summary:        Header files for libzypp, a library for package management
Group:          Development/Libraries/C and C++
Provides:       yast2-packagemanager-devel
Obsoletes:      yast2-packagemanager-devel
Provides:       libzypp-tui-devel = 1
%if 0%{?suse_version} >= 1330
Requires:       libboost_headers-devel
Requires:       libboost_program_options-devel
Requires:       libboost_test-devel
Requires:       libboost_thread-devel
%else
Requires:       boost-devel
%endif
Requires:       bzip2
Requires:       glibc-devel
Requires:       libstdc++-devel
Requires:       libxml2-devel
Requires:       libzypp = %{version}
Requires:       pkgconfig(openssl)
Requires:       popt-devel
Requires:       rpm-devel > 4.4
Requires:       zlib-devel
Requires:       systemd-devel
%if 0%{?suse_version}
# Code11+
Requires:       libcurl-devel >= %{min_curl_version}
%else
# Other distros (Fedora)
Requires:       libcurl-devel >= %{min_curl_version}
%endif
%if 0%{?suse_version}
%requires_ge    %{libsolv_devel_package}
%else
Requires:       %{libsolv_devel_package}
%endif

%description devel
Development files for libzypp, a library for package, patch, pattern
and product management.

%package devel-doc
Summary:        Developer documentation for libzypp
Group:          Documentation/HTML

%description devel-doc
Developer documentation for libzypp.

%prep
%autosetup -p1

%build
mkdir build
cd build

export CFLAGS="%{optflags}"
export CXXFLAGS="%{optflags}"

CMAKE_FLAGS=
%if 0%{?fedora} || 0%{?rhel} >= 6
CMAKE_FLAGS="-DFEDORA=1"
%endif
%if 0%{?mageia}
CMAKE_FLAGS="-DMAGEIA=1"
%endif
%if 0%{?suse_version}
CMAKE_FLAGS="-DSUSE=1"
%endif

EXTRA_CMAKE_OPTIONS=
%if 0%{?suse_version}
EXTRA_CMAKE_OPTIONS="${EXTRA_CMAKE_OPTIONS} -DLIBZYPP_CODESTREAM=0%{?suse_version}:0%{?sle_version}:0%{?is_opensuse}"

%if 0%{?suse_version} <= 1500 && 0%{?sle_version} <= 150600
EXTRA_CMAKE_OPTIONS="${EXTRA_CMAKE_OPTIONS} -DLIBZYPP_CONFIG_USE_DELTARPM_BY_DEFAULT=1"
%endif

%if 0%{?suse_version} < 1600
EXTRA_CMAKE_OPTIONS="${EXTRA_CMAKE_OPTIONS} -DLIBZYPP_CONFIG_USE_LEGACY_CURL_BACKEND_BY_DEFAULT=1"
EXTRA_CMAKE_OPTIONS="${EXTRA_CMAKE_OPTIONS} -DLIBZYPP_CONFIG_USE_SERIAL_PACKAGE_DOWNLOAD_BY_DEFAULT=1"
%endif

%endif

cmake .. $CMAKE_FLAGS \
      -DCMAKE_INSTALL_PREFIX=%{_prefix} \
      -DDOC_INSTALL_DIR=%{_docdir} \
      -DLIB=%{_lib} \
      -DCMAKE_BUILD_TYPE=Release \
      -DCMAKE_SKIP_RPATH=1 \
      -DCMAKE_INSTALL_LIBEXECDIR=%{_libexecdir} \
      %{?with_visibility_hidden:-DENABLE_VISIBILITY_HIDDEN=1} \
      %{?with_zchunk:-DENABLE_ZCHUNK_COMPRESSION=1} \
      %{?with_zstd:-DENABLE_ZSTD_COMPRESSION=1} \
      %{?with_sigc_block_workaround:-DENABLE_SIGC_BLOCK_WORKAROUND=1} \
      %{!?with_mediabackend_tests:-DDISABLE_MEDIABACKEND_TESTS=1} \
      %{?with_classic_rpmtrans_as_default:-DLIBZYPP_CONFIG_USE_CLASSIC_RPMTRANS_BY_DEFAULT=1} \
      ${EXTRA_CMAKE_OPTIONS}

make %{?_smp_mflags} VERBOSE=1

%install
cd build
%make_install
%if 0%{?fedora_version} || 0%{?rhel_version} >= 600 || 0%{?centos_version} >= 600
ln -s %{_sysconfdir}/yum.repos.d %{buildroot}/%{_sysconfdir}/zypp/repos.d
%else
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/repos.d
%endif
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/services.d
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/systemCheck.d
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/vars.d
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/vendors.d
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/multiversion.d
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/needreboot.d
mkdir -p %{buildroot}/%{_sysconfdir}/zypp/credentials.d
mkdir -p %{buildroot}/%{_prefix}/lib/zypp
mkdir -p %{buildroot}/%{_prefix}/lib/zypp/plugins
mkdir -p %{buildroot}/%{_prefix}/lib/zypp/plugins/appdata
mkdir -p %{buildroot}/%{_prefix}/lib/zypp/plugins/commit
mkdir -p %{buildroot}/%{_prefix}/lib/zypp/plugins/services
mkdir -p %{buildroot}/%{_prefix}/lib/zypp/plugins/system
mkdir -p %{buildroot}/%{_prefix}/lib/zypp/plugins/urlresolver
mkdir -p %{buildroot}/%{_var}/lib/zypp
mkdir -p %{buildroot}/%{_var}/log/zypp
mkdir -p %{buildroot}/%{_var}/cache/zypp

cd ..

# Create filelist with translations
%{find_lang} zypp

%if %{defined _distconfdir}
# Move logratate files form /etc/logrotate.d to /usr/etc/logrotate.d
mkdir -p %{buildroot}/%{_distconfdir}/logrotate.d
mv %{buildroot}/%{_sysconfdir}/logrotate.d/zypp-history.lr %{buildroot}%{_distconfdir}/logrotate.d
%endif

%check
pushd build
LD_LIBRARY_PATH="$(pwd)/../zypp:$LD_LIBRARY_PATH" ctest --output-on-failure .
popd

%if %{defined _distconfdir}
%pre
# Prepare for migration to /usr/etc; save any old .rpmsave
for i in logrotate.d/zypp-history.lr; do
   test -f %{_sysconfdir}/${i}.rpmsave && mv -v %{_sysconfdir}/${i}.rpmsave %{_sysconfdir}/${i}.rpmsave.old ||:
done
%endif

%if %{defined _distconfdir}
%posttrans
# Migration to /usr/etc, restore just created .rpmsave
for i in logrotate.d/zypp-history.lr; do
   test -f %{_sysconfdir}/${i}.rpmsave && mv -v %{_sysconfdir}/${i}.rpmsave %{_sysconfdir}/${i} ||:
done
%endif

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -f zypp.lang
%defattr(-,root,root)
%if 0%{?suse_version} >= 1500
%license COPYING
%endif
%dir               %{_sysconfdir}/zypp
%if 0%{?fedora_version} || 0%{?rhel_version} >= 600 || 0%{?centos_version} >= 600
%{_sysconfdir}/zypp/repos.d
%else
%dir               %{_sysconfdir}/zypp/repos.d
%endif
%dir               %{_sysconfdir}/zypp/services.d
%dir               %{_sysconfdir}/zypp/systemCheck.d
%dir               %{_sysconfdir}/zypp/vars.d
%dir               %{_sysconfdir}/zypp/vendors.d
%dir               %{_sysconfdir}/zypp/multiversion.d
%config(noreplace) %{_sysconfdir}/zypp/needreboot
%dir               %{_sysconfdir}/zypp/needreboot.d
%dir               %{_sysconfdir}/zypp/credentials.d
%config(noreplace) %{_sysconfdir}/zypp/zypp.conf
%config(noreplace) %{_sysconfdir}/zypp/systemCheck
%if %{defined _distconfdir}
%{_distconfdir}/logrotate.d/zypp-history.lr
%else
%config(noreplace) %{_sysconfdir}/logrotate.d/zypp-history.lr
%endif
%dir               %{_var}/lib/zypp
%if "%{_libexecdir}" != "%{_prefix}/lib"
%dir               %{_libexecdir}/zypp
%endif
%dir %attr(750,root,root) %{_var}/log/zypp
%dir               %{_var}/cache/zypp
%{_prefix}/lib/zypp
%{_datadir}/zypp
%{_bindir}/*
%{_libexecdir}/zypp/zypp-rpm
%{_libdir}/libzypp*so.*
%doc %{_mandir}/man1/*.1.*
%doc %{_mandir}/man5/*.5.*

%files devel
%defattr(-,root,root)
%{_libdir}/cmake/Zypp
%{_libdir}/libzypp.so
%{_libdir}/libzypp-tui.a
%{_includedir}/zypp
%{_includedir}/zypp-core
%{_includedir}/zypp-media
%{_includedir}/zypp-curl
%{_includedir}/zypp-tui
%{_includedir}/zypp-common
%{_libdir}/pkgconfig/libzypp.pc

%files devel-doc
%defattr(-,root,root)
%{_docdir}/%{name}

%changelog
* Tue Sep 23 2025 ma@suse.de
- runposttrans: strip root prefix from tmppath (bsc#1250343)
- fixup! Make ld.so ignore the subarch packages during install
  (bsc#1246912)
- version 17.37.18 (35)
* Mon Aug 11 2025 ma@suse.de
- Make ld.so ignore the subarch packages during install
  (bsc#1246912)
- version 17.37.17 (35)
* Thu Aug  7 2025 ma@suse.de
- Fix evaluation of libproxy results (bsc#1247690)
- Replace URL variables inside mirrorlist/metalink files
  (fixes #667)
- version 17.37.16 (35)
* Thu Jul 31 2025 ma@suse.de
- Append RepoInfo::path() to the mirror URLs in Preloader
  (bsc#1247054)
- version 17.37.15 (35)
* Wed Jul 23 2025 ma@suse.de
- During installation indicate the backend being used (bsc#1246038)
  If some package actually needs to know, it should test for
  ZYPP_CLASSIC_RPMTRANS being set in the environment.
  Otherwise the transaction is driven by librpm.
- version 17.37.14 (35)
* Tue Jul 22 2025 ma@suse.de
- Workaround 'rpm -vv' leaving scriptlets /var/tmp (bsc#1218459)
- Verbose log libproxy results if PX_DEBUG=1 is set.
- BuildRequires:  cmake >= 3.17.
- version 17.37.13 (35)
* Thu Jul 17 2025 ma@suse.de
- Allow explicit request to probe an added repo's URL
  (bsc#1246466)
- Fix tests with -DISABLE_MEDIABACKEND_TESTS=1 (fixes #661)
- version 17.37.12 (35)
* Mon Jul 14 2025 ma@suse.de
- Add runtime check for a broken rpm-4.18.0 --runpostrans
  (bsc#1246149)
- Add regression test for bsc#1245220 and some other filesize
  related tests.
- version 17.37.11 (35)
* Mon Jul  7 2025 ma@suse.de
- BuildRequires: %%{libsolv_devel_package} >= 0.7.34 (bsc#1243486)
  Newer rpm versions no longer allow a ':' in rpm package names or
  obsoletes. So injecting an
    Obsoletes: product:oldproductname < oldproductversion
  into the -release package to indicate a product rename is no longer
  possible.
  Since libsolv-0.7.34 you can and should use:
    Provides: product-obsoletes(oldproductname) < oldproductversion
  in the -release package. libsolv will then inject the appropriate
  Obsoletes into the Product.
- version 17.37.10 (35)
* Fri Jul  4 2025 ma@suse.de
- Ignore DeltaRpm download errors (bsc#1245672)
  DeltaRpms are in fact optional resources. In case of a failure
  the full rpm is downloaded.
- Improve fix for incorrect filesize handling (bsc#1245220)
- version 17.37.9 (35)
* Wed Jul  2 2025 ma@suse.de
- Do not trigger download data exceeded errors on HTTP non data
  responses (bsc#1245220)
  In some cases a HTTP 401 or 407 did trigger a "filesize exceeded"
  error, because the response payload size was compared against the
  expected filesize. This patch adds some checks if the response
  code is in the success range and only then takes expected
  filesize into account. Otherwise the response content-length is
  used or a fallback of 2Mb if no content-length is known.
- version 17.37.8 (35)
* Wed Jul  2 2025 ma@suse.de
- Fix SEGV in MediaDISK handler (bsc#1245452)
- Explicitly selecting DownloadAsNeeded also selects the
  classic_rpmtrans backend.
  DownloadAsNeeded can not be combined with the rpm singletrans
  installer backend because a rpm transaction requires all package
  headers to be available the the beginning of the transaction. So
  explicitly selecting this mode also turns on the classic_rpmtrans
  backend.
- Fix evaluation of libproxy results (bsc#1244710)
- version 17.37.7 (35)
* Wed Jun 18 2025 ma@suse.de
- Enhancements regarding mirror handling during repo refresh.
  Added  means to disable the use of mirrors when downloading
  security relevant files. Requires updaing zypper to 1.14.91.
- Fix autotestcase writer if ZYPP_FULLLOG=1 (bsc#1244042)
  If ZYPP_FULLLOG=1 a solver testcase to
  "/var/log/YaST2/autoTestcase" should be written for each solver
  run. There was no testcase written for the very first solver run.
  This is now fixed.
- Pass $1==2 to %%posttrans script if it's an update (bsc#1243279)
- version 17.37.6 (35)
* Fri Jun  6 2025 ma@suse.de
- Fix credential handling in HEAD requests (bsc#1244105)
- version 17.37.5 (35)
* Wed Jun  4 2025 ma@suse.de
- RepoInfo: use pathNameSetTrailingSlash (fixes #643)
- Fix wrong userdata parameter type when running zypp with debug
  verbosity (bsc#1239012)
- version 17.37.4 (35)
* Mon Jun  2 2025 ma@suse.de
- Do not warn about no mirrors if mirrorlist was switched on
  automatically. (bsc#1243901)
- Relax permission of cached packages to 0644 & ~umask
  (bsc#1243887)
- version 17.37.3 (35)
* Tue May 27 2025 ma@suse.de
- Add a note to service maintained .repo file entries (fixes #638)
- Support using %%{url} variable in a RIS service's repo section.
- version 17.37.2 (35)
* Fri May 23 2025 ma@suse.de
- Use a cookie file to validate mirrorlist cache.
  This patch extends the mirrorlist code to use a cookie file to
  validate the contents of the cache against the source URL, making
  sure that we do not accidentially use a old cache when the
  mirrorlist url was changed. For example when migrating a system
  from one release to the next where the same repo alias might just
  have a different URL.
- Let Service define and update gpgkey, mirrorlist and metalink.
- Preserve a mirrorlist file in the raw cache during refresh.
- version 17.37.1 (35)
* Thu May 22 2025 ma@suse.de
- Code16: Enable curl2 backend and parallel package download by
  default. In Code15 it's optional.
  Environment variables ZYPP_CURL2=<0|1> and ZYPP_PCK_PRELOAD=<0|1>
  can be used to turn the features on or off.
- Make gpgKeyUrl the default source for gpg keys.
  When refreshing zypp now primarily uses gpgKeyUrl information
  from the repo files and only falls back to a automatically
  generated key Url if a gpgKeyUrl was not specified.
- Introduce mirrors into the Media backends (bsc#1240132)
- Drop MediaMultiCurl backend.
- Throttle progress updates when preloading packages (bsc#1239543)
- Check if request is in valid state in CURL callbacks (fixes
  openSUSE/zypper#605)
- spec/CMake: add conditional build
  '--with[out] classic_rpmtrans_as_default'.
  classic_rpmtrans is the current builtin default for SUSE,
  otherwise it's single_rpmtrans.
  The `enable_preview_single_rpmtrans_as_default_for_zypper` switch
  was removed from the spec file.  Accordingly the CMake option
  ENABLE_PREVIEW_SINGLE_RPMTRANS_AS_DEFAULT_FOR_ZYPPER was removed.
- version 17.37.0 (35)
* Wed Apr 30 2025 ma@suse.de
- fixed build with boost 1.88.
- XmlReader: Fix detection of bad input streams (fixes #635)
  libxml2 2.14 potentially reads the complete stream, so it may
  have the 'eof' bit set. Which is not 'good' but also not 'bad'.
- rpm: Fix detection of %%triggerscript starts (bsc#1222044)
- RepoindexFileReader: add more <repo> related attributes a
  service may set.
  Add optional attributes gpgcheck, repo_gpgcheck, pkg_gpgcheck,
  keeppackages, gpgkey, mirrorlist, and metalink with the same
  semantic as in a .repo file.
- version 17.36.7 (35)
* Thu Apr  3 2025 ma@suse.de
- Drop workaround for broken rpm-4.18 in Code16 (bsc#1237172)
- BuildRequires:  %%{libsolv_devel_package} >= 0.7.32.
  Code16 moved static libs to libsolv-devel-static.
- Drop usage of SHA1 hash algorithm because it will become
  unavailable in FIPS mode (bsc#1240529)
- Fix zypp.conf dupAllowVendorChange to reflect the correct
  default (false).
  The default was true in Code12 (libzypp-16.x) and changed to
  false with Code15 (libzypp-17.x). Unfortunately this was done by
  shipping a modified zypp.conf file rather than fixing the code.
- zypp.conf: Add `lock_timeout` ($ZYPP_LOCK_TIMEOUT) (bsc#1239809)
- version 17.36.6 (35)
* Mon Mar 17 2025 ma@suse.de
- Fix computation of RepStatus if Repo URLs change.
- Fix lost double slash when appending to an absolute FTP url
  (bsc#1238315)
  Ftp actually differs between absolute and relative URL paths.
  Absolute path names begin with a double slash encoded as '/%%2F'.
  This must be preserved when manipulating the path.
- version 17.36.5 (35)
* Fri Feb 28 2025 ma@suse.de
- Add a transaction package preloader (fixes openSUSE/zypper#104)
  This patch adds a preloader that concurrently downloads files
  during a transaction commit. It's not yet enabled per default.
  To enable the preview set ZYPP_CURL2=1 and ZYPP_PCK_PRELOAD=1
  in the environment.
- RpmPkgSigCheck_test: Exchange the test package signingkey
  (fixes #622)
- Exclude MediaCurl tests if DISABLE_MEDIABACKEND_TESTS (fixes #626)
- Strip a mediahandler tag from baseUrl querystrings.
- version 17.36.4 (35)
* Thu Feb 27 2025 ma@suse.de
- Disable zypp.conf:download.use_deltarpm by default (fixes #620)
  Measurements show that you don't benefit from using deltarpms
  unless your network connection is very slow. That's why most
  distributions even stop offering deltarpms. The default remains
  unchanged on SUSE-15.6 and older.
- Make sure repo variables are evaluated in the right context
  (bsc#1237044)
- Introducing MediaCurl2 a alternative HTTP backend.
  This patch adds MediaCurl2 as a testbed for experimenting with a
  more simple way to download files. Set ZYPP_CURL2=1 in the
  environment to use it.
- version 17.36.3 (35)
* Fri Feb 21 2025 ma@suse.de
- Filesystem usrmerge must not be done in singletrans mode
  (bsc#1236481, bsc#1189788)
  Commit will amend the backend in case the transaction would
  perform a filesystem usrmerge.
- Workaround bsc#1216091 on Code16.
- version 17.36.2 (35)
* Wed Feb 12 2025 ma@suse.de
- Don't issue deprecated warnings if -DNDEBUG is set (bsc#1236983)
  Released libyui packages compile with -Werror=deprecated-declarations
  so we can't add deprecated warnings without breaking them.
- make gcc15 happy (fixes #613)
- version 17.36.1 (35)
* Mon Feb 10 2025 ma@suse.de
- Drop zypp-CheckAccessDeleted in favor of 'zypper ps'.
- Fix Repoverification plugin not being executed (fixes #614)
- Refresh: Fetch the master index file before key and signature
  (bsc#1236820)
- Allow libzypp to compile with C++20.
- Deprecate RepoReports we do not trigger.
- version 17.36.0 (35)
* Wed Jan 22 2025 ma@suse.de
- Create '.keep_packages' in the package cache dir to enforce
  keeping downloaded packages of all repos cahed there (bsc#1232458)
- version 17.35.19 (35)
* Mon Jan 20 2025 ma@suse.de
- Fix missing UID checks in repomanager workflow (fixes #603)
- version 17.35.18 (35)
* Mon Jan 20 2025 ma@suse.de
- Move cmake config files to LIB_INSTALL_DIR/cmake/Zypp (fixes #28)
- Fix 'zypper ps' when running in incus container (bsc#1229106)
  Should apply to lxc and lxd containers as well.
- Re-enable 'rpm --runposttrans' usage for chrooted systems
  (bsc#1216091)
- version 17.35.17 (35)
* Wed Dec 18 2024 ma@suse.de
- Url: queryparams without value should not have a trailing "=".
- version 17.35.16 (35)
* Mon Dec  9 2024 ma@suse.de
- Url query part: `=` is a safe char in value (bsc#1234304)
- RpmDb: Recognize rpmdb.sqlite as database file (#593)
- Fix typo (fixes #592)
- cmake: check location of fcgi header and adjust include
  accordingly. On Debian and derivatives the fcgi headers
  are not stored in a fastcgi/ subdirectory.(#590)
- version 17.35.15 (35)
* Fri Nov 15 2024 ma@suse.de
- The 20MB download limit must not apply to non-metadata files like
  package URLs provided via the CLI (bsc#1233393).
- version 17.35.14 (35)
* Tue Nov 12 2024 ma@suse.de
- BuildCache: Don't try to retrieve missing raw metadata if no
  permission to write the cache (bsc#1225451)
- RepoManager: throw RepoNoPermissionException if the user has no
  permission to update(write) the caches (bsc#1225451)
- version 17.35.13 (35)
* Wed Oct  9 2024 ma@suse.de
- PluginFrame: Send unescaped colons in header values
  (bsc#1231043)
  According to the STOMP protocol it would be correct to escape a
  colon in a header-value, but it breaks plugin receivers which do
  not expect this. The first colon separates header-name from
  header-value, so escaping in the header-value is not needed
  anyway.
  Escaping in the header-value affects especially the urlresolver
  plugins. The input URL is passed in a header, but sent back as
  raw data in the frames body. If the plugin receiver does not
  correctly unescape the URL we may get back a "https\c//" which is
  not usable.
- Do not ignore return value of std::remove_if in MediaSyncFacade
  (fixes #579)
- Fix hang in curl code with no network connection (bsc#1230912)
- version 17.35.12 (35)
* Thu Sep 12 2024 ma@suse.de
- Deprecate librpmDb::db_const_iterator default ctor (bsc#1230267)
  It's preferred to explicitly tell the root directory of the
  system whose database you want to query.
- version 17.35.11 (35)
* Fri Sep  6 2024 ma@suse.de
- API refactoring. Prevent zypper from using now private libzypp
  symbols (bsc#1230267)
- Conflicts: zypper <= 1.14.76
- version 17.35.10 (35)
* Mon Aug  5 2024 ma@suse.de
- single_rpmtrans: fix installation of .src.rpms (bsc#1228647)
- version 17.35.9 (35)
* Fri Aug  2 2024 ma@suse.de
- Make sure not to statically linked installed tools (bsc#1228787)
- version 17.35.8 (35)
* Thu Aug  1 2024 ma@suse.de
- MediaPluginType must be resolved to a valid MediaHandler
  (bsc#1228208)
- version 17.35.7 (35)
* Tue Jul 30 2024 ma@suse.de
- Export CredentialManager for legacy YAST versions (bsc#1228420)
- version 17.35.6 (35)
* Tue Jul 30 2024 ma@suse.de
- Export asSolvable for YAST (bsc#1228420)
- Fix 4 typos in zypp.conf.
- version 17.35.5 (35)
* Tue Jul 23 2024 ma@suse.de
- Fix typo in the geoip update pipeline (bsc#1228206)
- Export RepoVariablesStringReplacer for yast2 (bsc#1228138)
- version 17.35.4 (35)
* Mon Jul 15 2024 ma@suse.de
- Translation: updated .pot file.
- Conflict with python zypp-plugin < 0.6.4 (bsc#1227793)
  Older zypp-plugins reject stomp headers including a '-'. Like the
  'content-length' header we may send.
- Fix int overflow in Provider (fixes #559)
  This patch fixes an issue in safe_strtonum which caused
  timestamps to overflow in the Provider message parser.
- Fix error reporting on repoindex.xml parse error (bsc#1227625)
- version 17.35.3 (35)
* Tue Jul  9 2024 ma@suse.de
- Keep UrlResolverPlugin API public (fixes #560)
- Blacklist /snap executables for 'zypper ps' (bsc#1226014)
- Fix handling of buddies when applying locks (bsc#1225267)
  Buddy pairs (like -release package and product) internally share
  the same status object. When applying locks from query results
  the locked bit must be set if either item is locked.
- version 17.35.2 (35)
* Tue Jul  2 2024 ma@suse.de
- Install zypp/APIConfig.h legacy include (fixes #557)
- version 17.35.1 (35)
* Fri Jun 28 2024 ma@suse.de
- Update soname due to RepoManager refactoring and cleanup.
- version 17.35.0 (35)
* Mon Jun 24 2024 ma@suse.de
- Workaround broken libsolv-tools-base requirements (fixes
  openSUSE/zypper#551)
- Strip ssl_clientkey from repo urls (bsc#1226030)
- Remove protobuf build dependency.
- Lazily attach medium during refresh workflows (bsc#1223094)
- Refactor RepoManager and add Service workflows.
- version 17.34.2 (34)
* Fri May 31 2024 ma@suse.de
- zypp-tui: Make sure translated texts use the correct textdomain
  (fixes #551)
- Skip libproxy1 requires for tumbleweed.
- version 17.34.1 (34)
* Tue May 14 2024 dmueller@suse.com
- don't require libproxy1 on tumbleweed, it is optional now
* Tue May 14 2024 bzeller@suse.de
- version 17.34.0 (34)
- Fix versioning scheme
* Mon May 13 2024 bzeller@suse.de
- version 17.33.4 (35)
* Thu May  9 2024 dmueller@suse.com
- add one more missing export for libyui-qt-pkg
* Wed May  8 2024 bzeller@suse.de
- Revert eintrSafeCall behavior to setting errno to 0.
- version 17.33.3 (34)
* Mon May  6 2024 dmueller@suse.com
- fix up requires_eq usage for libsolv-tools-base
- add one more missing export for PackageKit
- version 17.33.2
* Fri May  3 2024 ma@suse.de
- version 17.33.1 (33)
* Fri May  3 2024 dmueller@suse.com
- switch to reduced size libsolv-tools-base (jsc#PED-8153)
* Fri May  3 2024 ma@suse.de
- Fixed check for outdated repo metadata as non-root user
  (bsc#1222086)
- Add ZYPP_API for exported functions and switch to
  visibility=hidden (jsc#PED-8153)
- Dynamically resolve libproxy (jsc#PED-8153)
- version 17.33.0 (33)
* Mon Apr 29 2024 ma@suse.de
- Fix download from gpgkey URL (bsc#1223430, fixes openSUSE/zypper#546)
- version 17.32.6 (32)
* Fri Apr 19 2024 ma@suse.de
- Don't try to refresh volatile media as long as raw metadata are
  present (bsc#1223094)
- version 17.32.5 (32)
* Wed Apr 17 2024 ma@suse.de
- Fix creation of sibling cache dirs with too restrictive mode
  (bsc#1222398)
  Some install workflows in YAST may lead to too restrictive (0700)
  raw cache directories in case of newly created repos. Later
  commands running with user privileges may not be able to access
  these repos.
- version 17.32.4 (32)
* Thu Apr 11 2024 ma@suse.de
- Update RepoStatus fromCookieFile according to the files mtime
  (bsc#1222086)
- TmpFile: Don't call chmod if makeSibling failed.
- version 17.32.3 (32)
* Tue Apr  2 2024 ma@suse.de
- Fixup New VendorSupportOption flag VendorSupportSuperseded
  (jsc#OBS-301, jsc#PED-8014)
  Fixed the name of the keyword to "support_superseded" as it was
  agreed on in jsc#OBS-301.
- version 17.32.2 (32)
* Thu Mar 28 2024 ma@suse.de
- Add resolver option 'removeUnneeded' to file weak remove jobs
  for unneeded packages (bsc#1175678)
- version 17.32.1 (32)
* Fri Mar 22 2024 ma@suse.de
- Add resolver option 'removeOrphaned' for distupgrade
  (bsc#1221525)
- New VendorSupportOption flag VendorSupportSuperseded
  (jsc#OBS-301, jsc#PED-8014)
- Tests: fix vsftpd.conf where SUSE and Fedora use different
  defaults (fixes #522)
- Add default stripe minimum (#529)
- Don't expose std::optional where YAST/PK explicitly use c++11.
- Digest: Avoid using the deprecated OPENSSL_config.
- version 17.32.0 (32)
* Tue Feb 20 2024 ma@suse.de
- ProblemSolution::skipsPatchesOnly overload to handout the
  patches.
- Remove https->http redirection exceptions for
  download.opensuse.org.
- version 17.31.32 (22)
* Wed Feb  7 2024 ma@suse.de
- tui: allow to access the underlying ostream of out::Info.
- Add MLSep: Helper to produce not-NL-terminated multi line
  output.
- version 17.31.31 (22)
* Tue Feb  6 2024 ma@suse.de
- applydeltaprm: Create target directory if it does not exist
  (bsc#1219442)
- Add ProblemSolution::skipsPatchesOnly (for openSUSE/zypper#514)
- Fix problems with EINTR in ExternalDataSource::getline (fixes
  bsc#1215698)
- version 17.31.30 (22)
* Tue Jan 23 2024 ma@suse.de
- CheckAccessDeleted: fix running_in_container detection
  (bsc#1218782)
- Detect CURLOPT_REDIR_PROTOCOLS_STR availability at runtime
  (bsc#1218831)
- Make Wakeup class EINTR safe.
- Add a way to cancel media operations on shutdown
  (openSUSE/zypper#522)
  This patch adds a mechanism to signal libzypp that a shutdown was
  requested, usually when CTRL+C was pressed by the user. Currently
  only the media backend will utilize this, but can be extended to
  all code paths that use g_poll() to wait for events.
- Manually poll fds for curl in MediaCurl.
  Using curl_easy_perform does not give us the required control on
  when we want to cancel a download. Switching to the MultiCurl
  implementation with a external poll() event loop will give us
  much more freedom and helps us to improve our Ctrl+C handling.
- Move reusable curl poll code to curlhelper.h.
- version 17.31.29 (22)
* Tue Jan  9 2024 ma@suse.de
- Fix to build with libxml 2.12.x (fixes #505)
- version 17.31.28 (22)
* Fri Dec 22 2023 ma@suse.de
- CheckAccessDeleted: fix 'running in container' filter
  (bsc#1218291)
- version 17.31.27 (22)
* Thu Dec 21 2023 ma@suse.de
- Call zypp commit plugins during transactional update (fixes #506)
- Add support for loongarch64 (fixes #504)
- Teach MediaMultiCurl to download HTTP Multibyte ranges.
- Teach zsync downloads to MultiCurl.
- Expand RepoVars in URLs downloading a .repo file (bsc#1212160)
  Convenient and helps documentation as it may refer to a single
  command for a bunch of distributions. Like e.g. "zypper ar
  'https://server.my/$releasever/my.repo'".
- version 17.31.26 (22)
* Thu Dec 14 2023 ma@suse.de
- Fix build issue with zchunk build flags (fixes #500)
- version 17.31.25 (22)
* Thu Dec 14 2023 ma@suse.de
- Open rpmdb just once during execution of %%posttrans scripts
  (bsc#1216412)
- Avoid using select() since it does not support fd numbers >
  1024 (fixes #447)
- tools/DownloadFiles: use standard zypp progress bar (fixes #489)
- Revert "Color download progress bar" (fixes #475)
  Cyan is already used for the output of RPM scriptlets. Avoid this
  colorific collision between download progress bar and scriptlet
  output.
- Fix ProgressBar's calculation of the printed tag position (fixes #494)
- Switch zypp::Digest to Openssl 3.0 Provider API (fixes #144)
- Fix usage of deprecated CURL features (fixes #486)
- version 17.31.24 (22)
* Wed Oct 25 2023 ma@suse.de
- Stop using boost version 1 timer library (fixes #489,
  bsc#1215294)
- version 17.31.23 (22)
* Thu Oct 12 2023 ma@suse.de
- Preliminary disable 'rpm --runposttrans' usage for chrooted
  systems (bsc#1216091)
  This limits the %%transfiletrigger(postun|in) support in the
  default installer if --root is used (as described in bsc#1041742).
  The chrooted execution of the scripts in 'rpm --runposttrans'
  broke in rpm-4.18. It's expected to be fixed in rpm-4.19.
  Then we'll enable the feature again.
- fix comment typo on zypp.conf (boo#1215979)
- version 17.31.22 (22)
* Thu Sep 21 2023 ma@suse.de
- Attempt to delay %%transfiletrigger(postun|in) execution if rpm
  supports it (bsc#1041742)
  Decide during installation whether rpm is capable of delayed
  %%posttrans %%transfiletrigger(postun|in) execution or whether we
  can just handle the packages %%posttrans. On TW a delayed
  %%transfiletrigger handling is possible since rpm-4.17.
- Make sure the old target is deleted before a new one is created
  (bsc#1203760)
- version 17.31.21 (22)
* Thu Aug 24 2023 ma@suse.de
- Fixup changes for 17.31.16. Remove faulty reference to a bug
  actually fixed in 2019.
- version 17.31.20 (22)
* Wed Aug 16 2023 ma@suse.de
- Fix zypp-tui/output/Out.h to build with clang.
- Fix zypp/Arch.h for clang (fixes #478)
  Clang seems to have issues with picking the overload in
  std::men_fn if there is a static overload of a member function.
  We need to explicitely specify the correct type of the function
  pointer. To make sure this would not break compiling a
  application with clang that builds against libzypp this patch
  works around the problem.
- version 17.31.19 (22)
* Fri Aug  4 2023 ma@suse.de
- SINGLE_RPMTRANS: Respect ZYPP_READONLY_HACK when checking the
  zypp-rpm lock (fixes openSUSE/openSUSE-repos#29)
- version 17.31.18 (22)
* Fri Jul 28 2023 ma@suse.de
- Fix wrong filesize exceeded dl abort in zyppng::Downloader
  (bsc#1213673)
  In some cases when downloading very small files we can run into
  issues when the URL is protected by credentials.
- version 17.31.17 (22)
* Mon Jul 24 2023 ma@suse.de
- Fix negative ZYPP_LOCK_TIMEOUT not waiting forever (bsc#1213231)
- Don't cleanup orphaned dirs if read-only mode was promised
  (bsc#1210740)
- version 17.31.16 (22)
* Wed Jun 28 2023 ma@suse.de
- Fix build against protobuf >= 22 (fixes #465, closes #466)
  Port away from protobuf_generate_cpp. Upstream protobuf does not
  export protobuf_generate_cpp by default anymore.
  Use protobuf_generate instead, which is also available on older
  versions.
- Remove SUSE < SLE11 constructs (fixes #464).
- version 17.31.15 (22)
* Thu Jun 15 2023 ma@suse.de
- build: honor libproxy.pc's includedir (bsc#1212222)
- Curl: trim all custom headers (bsc#1212187)
  HTTP/2 RFC 9113 forbids fields ending with a space. So we make
  sure all custom headers are trimmed. This also includes headers
  returned by URL-Resolver plugins.
- version 17.31.14 (22)
* Mon Jun 12 2023 ma@suse.de
- curl: Trim user agent string (bsc#1212187)
  HTTP/2 RFC 9113 forbids fields ending with a space. Violation
  results in curl error: 92: HTTP/2 PROTOCOL_ERROR.
- version 17.31.13 (22)
* Mon Jun  5 2023 ma@suse.de
- Do not unconditionally release a medium if provideFile failed
  (bsc#1211661)
- libzypp.spec.cmake: remove duplicate file listing.
- version 17.31.12 (22)
* Fri Apr 28 2023 ma@suse.de
- MediaCurl: Fix endless loop if wrong credentials are stored in
  credentials.cat (bsc#1210870)
  Since libzypp-17.31.7 wrong credentials stored in credentials.cat
  may lead to an endless loop. Rather than asking for the right
  credentials, the stored ones are used again and again.
- zypp.conf: Introduce 'download.connect_timeout' [60 sec.]
  (bsc#1208329)
  Maximum time in seconds that you allow the connection phase to
  the server to take. This only limits the connection phase, it has
  no impact once it has connected. (see also CURLOPT_CONNECTTIMEOUT)
- commit: Try to provide /dev fs if not present (fixes #444)
- fix build with boost 1.82.
- version 17.31.11 (22)
* Mon Apr 24 2023 aschnell@suse.com
- fix build with boost 1.82
* Thu Apr 13 2023 ma@suse.de
- BuildRequires: libsolv-devel >= 0.7.24 for x86_64_v[234]
  support.
- version 17.31.10 (22)
* Fri Mar 31 2023 ma@suse.de
- Workround bsc#1195633 while libsolv <= 0.7.23 is used.
- Fix potential endless loop in new ZYPP_MEDIANETWORK.
- ZYPP_METALINK_DEBUG=1: Log URL and priority of the mirrors
  parsed from a metalink file.
- multicurl: propagate ssl settings stored in repo url
  (boo#1127591)
  Closes #335.
- Teach MediaNetwork to retry on HTTP2 errors.
- fix CapDetail to return Rel::NONE if an EXPRESSION is used as a
  NAMED cap.
- Capability: support parsing richdeps from string.
- defaultLoadSystem: default to LS_NOREFRESH if not root.
- Detect x86_64_v[234]: Fix LZCNT bit used in detection (fixes
  [#439])
  Merges rpm-software-management/rpm#2412: The bit for LZCNT is in
  CPUID 0x80000001, not 1.
- Detect x86_64_v[234] architecture levels (fixes #439)
- Support x86_64_v[234] architecture levels (for #439)
- version 17.31.9 (22)
* Mon Feb 13 2023 ma@suse.de
- ProgressData: enforce reporting the INIT||END state
  (bsc#1206949)
- ps: fix service detection on newer Tumbleweed systems
  (bsc#1205636)
- version 17.31.8 (22)
* Sat Dec 24 2022 ma@suse.de
- Hint to "zypper removeptf" to remove PTFs.
- Removing a PTF without enabled repos should always fail
  (bsc#1203248)
  Without enabled repos, the dependent PTF-packages would be
  removed (not replaced!) as well. To remove a PTF "zypper install
  - - -PTF" or a dedicated "zypper removeptf PTF" should be used.
  This will update the installed PTF packages to theit latest
  version.
- version 17.31.7 (22)
* Fri Nov 25 2022 ma@suse.de
- Avoid calling getsockopt when we know the info already.
  This patch hopefully fixes logging on WSL, getsockopt seems to
  not be fully supported but the code required it when accepting
  new socket connections. (for bsc#1178233)
- Enhance yaml-cpp detection (fixes #428)
- No need to redirect 'history.logfile=/dev/null' into the target.
- MultiCurl: Make sure to reset the progress function when
  falling back.
- version 17.31.6 (22)
* Mon Nov  7 2022 ma@suse.de
- Create '.no_auto_prune' in the package cache dir to prevent auto
  cleanup of orphaned repositories (bsc#1204956)
- properly reset range requests (bsc#1204548)
- version 17.31.5 (22)
* Mon Oct 17 2022 ma@suse.de
- Do not clean up MediaSetAccess before using the geoip file
  (fixes #424)
- version 17.31.4 (22)
* Fri Oct 14 2022 ma@suse.de
- Improve download of optional files (fixes #416)
- Do not use geoip rewrites if the repo has explicit country
  settings.
- Implement geoIP feature for zypp.
  This patch adds a feature to rewrite request URLs to the repo
  servers by querying a geoIP file from download.opensuse.org. This
  file can return a redirection target depending on the clients IP
  adress, this way we can directly contact a local mirror of d.o.o
  instead. The redir target stays valid for 24hrs.
  This feature can be disabled in zypp.conf by setting
  'download.use_geoip_mirror = false'.
- Use a dynamic fallback for BLKSIZE in downloads.
  When not receiving a blocklist via metalink file from the server
  MediaMultiCurl used to fallback to a fixed, relatively small
  BLKSIZE. This patch changes the fallback into a dynamic value
  based on the filesize using a similar metric as the MirrorCache
  implementation on the server side.
- Skip media.1/media download for http repo status calc.
  This patch allows zypp to skip a extra media.1/media download to
  calculate if a repository needs to be refreshed. This
  optimisation only takes place if the repo does specify only
  downloading base urls.
- version 17.31.3 (22)
* Wed Oct  5 2022 ma@suse.de
- Resolver: Fix missing --[no]-recommends initialization in
  update (fixes #openSUSE/zypper#459, bsc#1201972)
- Log ONLY_NAMESPACE_RECOMMENDED because this is what corresponds
  to --[no]-recommends.
- version 17.31.2 (22)
* Fri Sep  2 2022 ma@suse.de
- UsrEtc: Store logrotate files in %%{_distconfdir} if defined
  (fixes #402)
- Log backtrace on SIGABRT too.
- Need to explicitly enable building experimental code. Otherwise
  an old Notcurses++ package which happens to be present in the
  buildenv breaks the build (fixes #412).
- Work around libyui/libyui#78 on code 15.4 and older.
- Stop using std::*ary_function; deprecated and removed in c++17.
- Don't expose header files which use types not available in
  c++11.  In 15.3 and older, YAST and PK compile with -std=c++11.
- Remove no longer needed %%post code (bsc#1203649)
- Enable zck support for SLE15-SP4 and newer. On Leap it is enabled
  since 15.1 (bsc#1189282)
- version 17.31.1 (22)
* Tue Jul 19 2022 ma@suse.de
- Add PoolItem::statusReinit to reset the status it's initial
  state in the ResPool (might help bsc#1199895)
  This may either be 'KEEP_STATE bySOLVER' or 'LOCKED byUSER' if
  the PoolItem matched a hard lock defined in /etc/zypp/locks.
- Fix building with GCC 13 on i586 (fixes #407, fixes #396)
- Be prepared to receive exceptions from curl_easy_cleanup
  (bsc#1201092)
- Don't auto-flag kernel-firmware as 'reboot-needed' (bsc#1200993)
- Remove Medianetwork and dependend code.
  This commit removes the MediaNetwork tech preview and all related
  code. First reason for this is that MediaNetwork was just meant
  as a way to test the new CURL based downloader and second: since
  the Provide API is going to completely replace the current media
  backend it would be extra work to ensure that changes on the
  Downloader do not break MediaNetwork.
- version 17.31.0 (22)
* Tue Jul  5 2022 ma@suse.de
- Fix building with GCC 12.x release (#396)
- version 17.30.3 (22)
* Wed Jun 15 2022 ma@suse.de
- appdata plugin: Pass path to the repodata/ directory inside the
  cache (bsc#1197684)
- zypp-rpm: flush rpm script output buffer before sending
  endOfScriptTag.
- version 17.30.2 (22)
* Mon May 30 2022 ma@suse.de
- PluginRepoverification: initial version hooked into
  repo::Downloader and repo refresh.
- Immediately start monitoring the download.transfer_timeout.
  Do not wait until the first data arrived. (bsc#1199042)
- singletrans: no dry-run commit if doing just download-only.
- Work around cases where sat repo.start points to an invalid
  solvable.  May happen if (wrong arch) solvables were removed
  at the  beginning of the repo.
- fix misplaced #endif SINGLE_RPMTRANS_AS_DEFAULT_FOR_ZYPPER
  (fixes #388)
- version 17.30.1 (22)
* Fri Mar 25 2022 ma@suse.de
- ZConfig: Update solver settings if target changes (bsc#1196368)
- version 17.30.0 (22)
* Mon Mar 21 2022 ma@suse.de
- Fix possible hang in singletrans mode (bsc#1197134)
- Do 2 retries if mount is still busy.
- version 17.29.7 (22)
* Mon Mar 14 2022 ma@suse.de
- Fix package signature check (bsc#1184501)
  Pay attention that header and payload are secured by a valid
  signature and report more detailed which signature is missing.
- Retry umount if device is busy (bsc#1196061, closes #381)
  A previously released ISO image may need a bit more time to
  release it's loop device. So we wait a bit and retry.
- Fix serializing/deserializing type mismatch in zypp-rpm
  protocol (bsc#1196925)
- Fix handling of ISO media in releaseAll (bsc#1196061)
- Hint on common ptf resolver conflicts (bsc#1194848)
- version 17.29.6 (22)
* Thu Feb 24 2022 ma@suse.de
- Hint on ptf<>patch resolver conflicts (bsc#1194848)
- version 17.29.5 (22)
* Tue Feb  8 2022 ma@suse.de
- Fix handling of redirected command in-/output (bsc#1195326)
  This fixes delays at the end of zypper operations, where
  zypper unintentionally waits for appdata plugin scripts to
  complete.
- version 17.29.4 (22)
* Tue Feb  1 2022 ma@suse.de
- Public header files on older distros must use c++11
  (bsc#1194597)
- Fix exception handling when reading or writing credentials
  (bsc#1194898)
- version 17.29.3 (22)
* Thu Jan 20 2022 ma@suse.de
- Fix Legacy include (bsc#1194597)
- version 17.29.2 (22)
* Mon Jan 10 2022 ma@suse.de
- Fix broken install path for parser compat headers (fixes #372,
  bsc#1194597)
- RepoManager: remember exec errors in exception history
  (bsc#1193007)
- version 17.29.1 (22)
* Thu Dec 23 2021 ma@suse.de
- Use the default zypp.conf settings if no zypp.conf exists
  (bsc#1193488)
- Fix wrong encoding of iso: URL components (bsc#954813)
- Handle armv8l as armv7hl compatible userland.
- Introduce zypp-curl a sublibrary for CURL related code.
- zypp-rpm: Increase rpm loglevel if ZYPP_RPM_DEBUG is set.
- Save all signatures associated with a public key in its
  PublicKeyData.
- version 17.29.0 (22)
* Thu Nov 11 2021 ma@suse.de
- Disable logger in the child after fork (bsc#1192436)
- version 17.28.8 (22)
* Thu Nov  4 2021 ma@suse.de
- Check log writer before accessing it (fixes #355, bsc#1192337)
- Save locks: Update an existing locks changed comment string.
- Allow uname-r format in purge kernels keepspec (fixes
  openSUSE/zypper#418)
- version 17.28.7 (22)
* Mon Oct 18 2021 ma@suse.de
- Zypper should keep cached files if transaction is aborted
  (bsc#1190356)
  Singletrans mode currently does not keep files around if the
  transaction is aborted. This patch fixes the problem.
- Require a minimum number of mirrors for multicurl (bsc#1191609)
- Use procfs to detect nr of open fd's if rlimit is too high
  (bsc#1191324)
  Especially in a VM iterating over all possible fd's to close open
  ones right before a exec() slows down zypper unnecessarily. This
  patch uses /proc/self/fd to iterate over open fd's in case rlimit
  is above 1024.
- po: Fix some lost '%%' signs in positional args (bsc#1191370)
- RepoManager: Don't probe for plaindir repo if URL schema is
  plugin: (bsc#1191286)
- version 17.28.6 (22)
* Mon Oct  4 2021 ma@suse.de
- Downloader does not respect checkExistsOnly flag (bsc#1190712)
  A missing check causes zyppng::Downloader to always download full
  files even if the checkExistsOnly flag is set. This patch adds
  the missing logic.
- Fix kernel-*-livepatch removal in purge-kernels (bsc#1190815)
  The kernel-*-livepatch packages are supposed to serve as a stable
  handle for the ephemeral kernel livepatch packages. See
  FATE#320268 for details. As part of the kernel live patching
  ecosystem, kernel-*-livepatch packages should not block the
  purge-kernels step.
- version 17.28.5 (22)
* Fri Sep 17 2021 ma@suse.de
- Make sure to keep states alives while transitioning
  (bsc#1190199)
- May set techpreview variables for testing in /etc/zypp/zypp.conf.
  If environment variables are unhandy one may enable the desired
  techpreview in zypp.conf as well:
    [main]
    techpreview.ZYPP_SINGLE_RPMTRANS=1
    techpreview.ZYPP_MEDIANETWORK=1
- version 17.28.4 (22)
* Fri Sep  3 2021 ma@suse.de
- CMake/spec: Add option to force SINGLE_RPMTRANS as default for
  zypper (fixes #340)
- Make sure singleTrans is zypper-only for now.
- Do not double check signatures and keys (bsc#1190059)
- version 17.28.3 (22)
* Tue Aug 31 2021 ma@suse.de
- Workaround Bug 1189788: Don't allow ZYPP_SINGLE_RPMTRANS=1 on a
  not UsrMerged Tumbleweed system.
- version 17.28.2 (22)
* Mon Aug 23 2021 ma@suse.de
- Fix crashes in logging code when shutting down (bsc#1189031)
- version 17.28.1 (22)
* Mon Jul 26 2021 ma@suse.de
- Rephrase vendor conflict message in case 2 packages are
  involved (bsc#1187760)
  This covers the case where not the packages itself would change
  its vendor, but replaces a package from a different vendor.
- Fix solver jobs for PTFs (bsc#1186503)
- spec: switch to pkgconfig(openssl)
- Show key fpr from signature when signature check fails
  (bsc#1187224)
  Rpm by default only shows the short key ID when checking the
  signature of a package fails. This patch reads the signatures
  from the RPM headers and replaces she short IDs with the key
  fingerprints fetched from the signatures.
- Implement alternative single transaction commit strategy.
  This patch adds a experimental commit strategy that runs all
  operations in a single rpm transaction, speeding up the execution
  a lot.
- Use ZYPP_MEDIANETWORK=1 to enable the experimental new media
  backend.
- Implement zchunk download, refactor Downloader backend.
- Fix purge-kernels fails with kernels from Kernel:HEAD
  (bsc#1187738)
  There recently was a change in the kernel package naming scheme
  in regards to rc kernels. Since kernel upstream uses characters
  in the version that are not allowed in rpm versions a "-rc" was
  previously replaced with ".rc" which broke sorting by version, to
  fix this issue it was replaced with "~rc", which unfortunately
  broke the purge-kernels logic. This patch makes sure purge-kernel
  does apply the same conversion.
- version 17.28.0 (22)
* Thu Jun 10 2021 ma@suse.de
- Enhance XML output of repo GPG options (fixes openSUSE/zypper#390)
  In addition to the effective values, add optional attributes
  showing the raw values actually present in the .repo file.
  (raw_gpgcheck, raw_repo_gpgcheck, raw_pkg_gpgcheck)
- Link all executables with -pie (bsc#1186447)
- Ship an empty /etc/zypp/needreboot per default (fixes #311, jsc#PM-2645)
  If packages want to trigger the reboot-needed hiint upon installation
  they may provide 'installhint(reboot-needed)'.
  Builtin packages triggering the hint without the provides are
  only kernel and kernel-firmware related.
- Add Solvable::isBlacklisted as superset of retracted and ptf
  packages (bsc#1186503)
- Fix segv if ZYPP_FULLOG is set (fixes #317)
- version 17.27.0 (22)
* Tue Jun  1 2021 ma@suse.de
- Work around download.o.o broken https redirects.
- Allow trusted repos to add additional signing keys (bsc#1184326)
  Repositories signed with a trusted gpg key may import additional
  package signing keys. This is needed if different keys were used
  to sign the the packages shipped by the repository.
- MediaCurl: Fix logging of redirects.
- Use 15.3 resolver problem and solution texts on all distros.
- $ZYPP_LOCK_TIMEOUT: Let negative values wait forever for the
  zypp lock (bsc#1184399)
  Helps boot time services like 'zypper purge-kernels' to wait for
  the zypp lock until other services using zypper have completed.
- Fix purge-kernels is broken in Leap 15.3 (bsc#1185325)
  Leap 15.3 introduces a new kernel package called
  kernel-flavour-extra, which contain kmp's. Currently kmp's are
  detected by name ".*-kmp(-.*)?" but this does not work which
  those new packages. This patch fixes the problem by checking
  packages for kmod(*) and ksym(*) provides and only falls back to
  name checking if the package in question does not provide one of
  those.
- Introduce zypp-runpurge, a tool to run purge-kernels on
  testcases.
- version 17.26.0 (22)
* Wed Apr 28 2021 ma@suse.de
- Properly handle permission denied when providing optional files
  (bsc#1185239)
- Fix service detection with cgroupv2 (bsc#1184997)
- version 17.25.10 (22)
* Thu Apr 22 2021 ma@suse.de
- Add missing includes for GCC 11 (bsc#1181874)
- Fix unsafe usage of static in media verifier.
- Solver: Avoid segfault if no system is loaded (bsc#1183628)
- MediaVerifier: Relax media set verification in case of a single
  not-volatile medium (bsc#1180851)
- Do no cleanup in custom cache dirs (bsc#1182936)
- ZConfig: let pubkeyCachePath follow repoCachePath.
- version 17.25.9 (22)
* Wed Feb 24 2021 ma@suse.de
- Try to provide a mounted /proc in --root installs (bsc#1181328)
  Some systemd tools require /proc to be mounted and fail if it's
  not there.
- Enable release packages to request a releaxed suse/opensuse
  vendorcheck in dup when migrating. (bsc#1182629)
- version 17.25.8 (22)
* Wed Feb 17 2021 ma@suse.de
- Patch: Identify well-known category names (bsc#1179847)
  This allows to use the RH and SUSE patch categrory names
  synonymously:
  (recommendedi = bugfix) and (optional = feature = enhancement).
- Add missing includes for GCC 11 compatibility. (bsc#1181874)
- Fix %%posttrans script execution (fixes #265)
  The scripts are execuable. No need to call them through 'sh -c'.
- Commit: Fix rpmdb compat symlink in case rpm got removed.
- Repo: Allow multiple baseurls specified on one line (fixes #285)
- Regex: Fix memory leak and undefined behavior.
- Add rpm buildrequires for test suite (fixes #279)
- Use rpmdb2solv new -D switch to tell the location ob the
  rpmdatabase to use.
- BuildRequires:  libsolv-devel >= 0.7.17.
- version 17.25.7 (22)
* Tue Jan 12 2021 ma@suse.de
- Rephrase solver problem descriptions (jsc#SLE-8482)
- Adapt to changed gpg2/libgpgme behavior (bsc#1180721)
- Multicurl backend breaks with with unknown filesize (fixes #277)
- version 17.25.6 (22)
* Fri Dec 11 2020 ma@suse.de
- Fix lsof monitoring (bsc#1179909)
- version 17.25.5 (22)
* Thu Dec  3 2020 ma@suse.de
- Prevent librpmDb iterator from accidentally creating an empty
  rpmdb in / (repoened bsc#1178910)
- Fix update of gpg keys with elongated expire date (bsc#1179222)
- needreboot: remove udev from the list (bsc#1179083)
- Prefer /run over /var/run.
- version 17.25.4 (22)
* Fri Nov 27 2020 ma@suse.de
- RepoManager: Carefully tidy up the caches. Remove non-directory
  entries. (bsc#1178966)
- RpmDb: If no database exists use the _dbpath configured in rpm.
  Still makes sure a compat symlink at /var/lib/rpm exists in case
  the configures _dbpath is elsewhere. (bsc#1178910)
- Url: Hide known password entries when writing the query part
  (bsc#1050625 bsc#1177583, CVE-2017-9271)
- adapt testcase to change introduced by libsolv#402.
- RepoManager: Force refresh if repo url has changed (bsc#1174016)
- RepoInfo: ignore legacy type= in a .repo file and let RepoManager
  probe (bsc#1177427, Fixes openSUSE/zypper#357).
- version 17.25.3 (22)
* Wed Oct  7 2020 ma@suse.de
- Bump version to force rebuild against a fixed libsolv.
  (bsc#1177238, bsc#1177275)
- version 17.25.2 (22)
* Fri Sep 25 2020 ma@suse.de
- Fix bsc#1176902: When kernel-rt has been installed, the
  purge-kernels service fails during boot.
- Use package name provides as group key in purge-kernel
  (bsc#1176740 bsc#1176192)
  kernel-default-base has new packaging, where the kernel uname -r
  does not reflect the full package version anymore. This patch
  adds additional logic to use the most generic/shortest edition
  each package provides with %%{packagename}=<version> to group the
  kernel packages instead of the rpm versions.
  This also changes how the keep-spec for specific versions is
  applied, instead of matching the package versions, each of the
  package name provides will be matched.
- version 17.25.1 (22)
* Fri Sep 18 2020 ma@suse.de
- RepoInfo: Return the type of the local metadata cache as
  fallback (bsc#1176435)
- VendorAttr: Fix broken "suse,opensuse" equivalence handling.
  Enhance API and testcases. (bsc#1174918)
- Update docs regarding 'opensuse' namepace matching.
- New solver testcase format.
- Link against libzsd to close libsolvs open references
  (as we link statically)
- BuildRequires:  libsolv-devel >= 0.7.15.
- version 17.25.0 (22)
* Fri Aug 28 2020 ma@suse.de
- VendorAttr: Const-correct API and let Target provide its
  settings (bsc#1174918)
- Support buildnr with commit hash in purge-kernels (bsc#1175342)
  This adds special behaviour for when a kernel version has the
  rebuild counter before the kernel commit hash.
- Improve Italian traslation of the "breaking dependencies"
  message (bsc#1173529)
- Make sure reading from lsof does not block forever (bsc#1174240)
- Just collect details for the signatures found (fixes #229)
- version 17.24.2 (22)
* Thu Jul 16 2020 ma@suse.de
- Fix bsc#1174011 auth=basic ignored in some cases (bsc#1174011)
  Proactively send credentials if the URL specifes '?auth=basic'
  and a username.
- ZYPP_MEDIA_CURL_DEBUG: Strip credentials in header log (bsc#1174011)
- version 17.24.1 (22)
* Tue Jul 14 2020 ma@suse.de
- Completey rework the purge-kernels algorithm (fix bsc#1173106)
  The new code is closer to the original perl script, grouping the
  packages by name before applying the keep spec.
- Set ZYPP_RPM_DEBUG=1 to capture verbose rpm command output
  (implements #228)
- version 17.24.0 (22)
* Fri Jun 26 2020 ma@suse.de
- Fix core dump with corrupted history file (bsc#1170801)
- version 17.23.8 (22)
* Tue Jun 23 2020 ma@suse.de
- Enable zchunk metadata download if libsolv supports it.
- version 17.23.7 (22)
* Thu Jun  4 2020 ma@suse.de
- Revert "Enable zchunk on SLE-15-SP2".
- version 17.23.6 (22)
* Wed May 27 2020 ma@suse.de
- Enable zchunk on SLE-15-SP2.
- Older kernel-devel packages are not properly purged (bsc#1171224)
- doc: enhance service plugin example.
- version 17.23.5 (22)
* Thu Apr  9 2020 ma@suse.de
- Get retracted patch status from updateinfo data (jsc#SLE-8770)
  libsolv injects the indicator provides into packages only.
- remove 'using namespace std;' (bsc#1166610, fixes #218)
- Online doc: add 'Hardware (modalias) dependencies' page
  (fixes #216)
- version 17.23.4 (22)
* Wed Mar 25 2020 ma@suse.de
- Add HistoryLogReader actionFilter to parse only specific
  HistoryActionIDs.
- version 17.23.3 (22)
* Fri Mar 20 2020 ma@suse.de
- RepoVariables: Add safe guard in case the caller does not own a
  zypp instance.
- Enable c++17. Define libyzpp CXX_STANDARD in ZyppCommon.cmake.
- version 17.23.2 (22)
* Mon Mar  2 2020 ma@suse.de
- Fix package status computation regarding unneeded, orphaned, recommended
  and suggested packages (broken in 17.23.0) (bsc#1165476)
- version 17.23.1 (22)
* Fri Feb 21 2020 ma@suse.de
- Log patch status changes to history (jsc#SLE-5116)
- Allow to disable all WebServer dependent tests when building. OBS
  wants to be able to get rid of the nginx/FastCGI-devel build
  requirement. Use 'rpmbuild --without mediabackend_tests' or
  'cmake -DDISABLE_MEDIABACKEND_TESTS=1'.
- version 17.23.0 (22)
* Fri Feb  7 2020 ma@suse.de
- update translations
- Replace mongoose/webrick with nginx in test suite.
  This patch makes use of nginx to replace the current WebServer
  mongoose implementation. Also adds support for registering
  callback functions for certain URL requests via FCGI, making it
  possible to mock HTTP responses and test more complex HTTP setups.
- boost: Fix deprecated auto_unit_test.hpp includes.
- Disable zchunk on Leap-15.0 and SLE15-* while there is no libzck.
- Fix decision whether to download ZCHUNK files.
  libzypp and libsolv must both be able to read the format.
- version 17.22.1 (22)
* Thu Jan 23 2020 ma@suse.de
- yum::Downloader: Prefer zchunk compressed metadata if libvsolv
  supports it.
- BuildRequires:  libsolv-devel >= 0.7.11.
- version 17.22.0 (22)
* Mon Jan 20 2020 ma@suse.de
- Selectable: Fix highestAvailableVersionObj if only retracted
  packages are available. Avoid using retracted items as candidate
  (jsc#SLE-8770)
- version 17.21.0 (20)
* Thu Dec 19 2019 ma@suse.de
- BuildRequires:  libsolv-devel >= 0.7.10.
- RpmDb: Become rpmdb backend independent (jsc#SLE-7272)
- RpmDb: Close API offering a custom rpmdb path
  It's actually not needed and for this to work also libsolv needs
  to support it. You can sill use a librpmDb::db_const_iterator to
  access a database at a custom location (ro).
- Remove legacy rpmV3database conversion code.
- version 17.20.0 (20)
* Wed Dec 11 2019 ma@suse.de
- MediaCurl: assert cookie file has mode 0600 (bsc#1158763, CVE-2019-18900)
- version 17.19.0 (12)
* Mon Dec  9 2019 ma@suse.de
- dup: fix removing orphaned packages dropped by to-be-installed
  products (bsc#1155819)
- version 17.18.1 (12)
* Thu Dec  5 2019 ma@suse.de
- Resolver: add solution actions for SOLVER_SOLUTION_BLACK
  (retracted/PTF)
- Solvable: add isRetracted and isPtf attributes.
- version 17.18.0 (12)
* Thu Nov 28 2019 ma@suse.de
- Introduce PurgeKernels class (bsc#1155198)
  Adds libzypp API to mark all obsolete kernels according to the
  existing purge-kernel script rules.
- Add solver jobs for retracted packages and ptfs.
  Support for ptf packages and retract ed patches.
- Do not enforce 'en' being in RequestedLocales (bsc#1155678)
  If the user decides to have a system without explicit language
  support he may do so.
- Pass correct posttrans script argument (fixes #190)
- BuildRequires:  libsolv-devel >= 0.7.8.
- version 17.17.0 (12)
* Tue Oct 29 2019 ma@suse.de
- Expose new libsolv API via C++ counterparts
  (openSUSE/zypper#214)
- BuildRequires:  libsolv-devel >= 0.7.7
- version 17.16.0 (12)
* Fri Oct 18 2019 ma@suse.de
- Fix empty metalink downloads if filesize is unknown (bsc#1153557)
- Recognize riscv64 as architecture
- Fix installation of new header file (fixes #185)
- zypp.conf: Introduce `solver.focus` to define the resolvers general
  attitude when resolving jobs. (bsc#1146415)
- New container detection algorithm for zypper ps (bsc#1146947)
- version 17.15.0 (12)
* Thu Sep 26 2019 ma@suse.de
- Revert "Use CURL_HTTP_VERSION_2TLS if available" (bsc#1146027)
- doc: add service example using variables
- Fix build with rpm >= 4.15 (fixes #172)
- version 17.14.1 (12)
* Mon Aug  5 2019 ma@suse.de
- PublicKey::algoName: supply key algorithm and length
- version 17.14.0 (12)
* Thu Jul 25 2019 ma@suse.de
- MediaCurl: Fix leaking filedescriptors (bsc#1116995)
- commit: Run file conflict check on dry-run (best with download-only)
  (bsc#1140039)
- commit: do not remove orphan products if the .prod file is owned by
  a package (bsc#1139795)
- version 17.13.0 (12)
* Tue May 28 2019 ma@suse.de
- Drop unused InterProcessMutex class and test
- Drop unused WebpinResult class and test
- Give posttrans script a parameter of 0 (issue #168)
- Use CURL_HTTP_VERSION_2TLS if available (fixes #141)
- version 17.12.0 (12)
* Thu Apr  4 2019 ma@suse.de
- Enhance scanning /sys for modaliases (bsc#1130161)
- version 17.11.4 (9)
* Tue Apr  2 2019 ma@suse.de
- Prevent SEGV if the application sets an empty TextLocale (bsc#1127026)
* Mon Apr  1 2019 christophe@krop.fr
- Fix build with CMake >= 3.14.0:
  Starting with CMake 3.14, EXCLUDE_FROM_ALL now spreads from
  directories to targets. 'make -C someSubdir' when 'someSubdir'
  uses the 'EXCLUDE_FROM_ALL' keyword does nothing. (gh/libzypp#libzypp#165)
* Thu Mar 21 2019 ma@suse.de
- KeyManager: Work around bsc#1127220 [libgpgme] no error upon
  incomplete import due to signal received.
- MediaCurl: add hint to check SCC for an expired regcode on
  http error 403 (bsc#965786)
- version 17.11.3 (9)
* Mon Feb 25 2019 ma@suse.de
- Correctly handle exceptions when verifying the medium (bsc#1065022)
- Only write type field when probing (bsc#1114908)
- Don't blame user on TargetAbortedException (bsc#978193)
- version 17.11.2 (9)
* Thu Jan 31 2019 ma@suse.de
- CheckAccessDeleted: Suppress reporting `/memfd:` pseudo files
  (bsc#1123843)
- MediaCurl: improve reporting https->http redirection errors
- Prevent SEGV if the application sets an empty TextLocale
- Url: don't force printing an empty authority if the schema does not
  allow authority at all
- Try to the missing rpmDB compat symlink in case the rpm package got
  deleted (bsc#1122471)
- version 17.11.1 (9)
* Fri Jan 11 2019 ma@suse.de
- PoolItemBest: Optionally prefer not locked packages (for bsc#1113296)
- ui::Selectable: add `hasLocks` to indicate a partially locked
  item (for bsc#1113296)
- version 17.11.0 (9)
* Tue Dec 18 2018 ma@suse.de
- Simplify complex locks so zypper can display them (bsc#1112911)
- version 17.10.3 (9)
* Mon Dec 10 2018 ma@suse.de
- commit: set `SYSTEMD_OFFLINE=1` during chrooted commits (bsc#1118758)
- no-recommends: Nevertheless consider resolver namespaces (hardware,
  language,..supporting packages) (FATE#325513)
- BuildRequires:  libsolv-devel >= 0.7.2
  (SOLVER_FLAG_ONLY_NAMESPACE_RECOMMENDED)
- Remove world-readable bit from /var/log/zypp (bsc#1099019)
- version 17.10.2 (9)
* Wed Nov 28 2018 ma@suse.de
- Adapt to changes in upcoming Boost 1.69.0
- Do not fail service-refresh on a empty repoindex.xml (bnc#1116840)
- version 17.10.1 (9)
* Mon Nov 26 2018 ma@suse.de
- str: recognize 'always' and 'never' as valid boolean strings
- Fix needreboot code to use SolvableSpec parser (fate#326451)
- SolvableSpec: Define a set of Solvables by ident and provides
- version 17.10.0 (9)
* Wed Nov 14 2018 ma@suse.de
- Provide needreboot config files in /etc/zypp (fate#326451, fixes #140)
- Need to fix soname due to libsolv ABI changes (bsc#1115341)
- version 17.9.0 (9)
* Mon Oct 29 2018 ma@suse.de
- Adapt to changed type names in libsolv-0.7
- Package needreboot file (fate#326451)
- Fix definitions of gettext macros (fixes #135)
- version 17.8.1 (2)
* Fri Oct 12 2018 ma@suse.de
- Add infrastructure to flag specific packages to trigger a
  reboot needed hint (fate#326451)
- Adapt to libsolv: Drop support for REPOKEY_TYPE_U32
- Resolver: add setInr to request solving namespaces
- ResolverNamespace: add No/AllResolverNamespaces constants
- version 17.8.0 (2)
* Mon Oct  1 2018 ma@suse.de
- Fix blocking wait for finished child process (bsc#1109877)
- version 17.7.2 (2)
* Fri Sep 28 2018 ma@suse.de
- Fix conversion of string and glob to regex when compiling queries
  (bsc#1099982, bsc#939392, bsc#556664)
- version 17.7.1 (2)
* Fri Sep  7 2018 ma@suse.de
- Drop type application due to poor metadata support (bsc#1100095,
  bsc#1104415)
- version 17.7.0 (2)
* Thu Sep  6 2018 ma@suse.de
- Automatically fetch repository signing key from gpgkey url
  (bsc#1088037)
- lsof: use '-K i' if lsof supports it (bsc#1099847,bsc#1036304)
- version 17.6.4 (2)
* Thu Aug 30 2018 ma@suse.de
- Check for not imported keys after multi key import from rpmdb
  (bsc#1096217)
- version 17.6.3 (2)
* Tue Aug 21 2018 ma@suse.de
- fixup! Add filesize check for downloads with known size (bsc#408814)
  Fix detetction of metalink downloads and prevent aborting if
  a metalink file is larger than the expected data file.
- version 17.6.2 (2)
* Fri Aug 17 2018 ma@suse.de
- Adapt to changes in libgpgme11-11.1.0 breaking the signature
  verification (bsc#1100427)
- Use %%license (bsc#1082318)
- BuildRequires:  libsolv-devel >= 0.6.35 (for bsc#1100095)
- changes: add CVE numbers
- version 17.6.1 (2)
* Fri Aug  3 2018 ma@suse.de
- RepoInfo::provideKey: add report telling where we look for missing
  keys.
- Support listing gpgkey URLs in repo files (bsc#1088037)
- Add new report to request user approval for importing a package key
- Handle http error 502 Bad Gateway in curl backend (bsc #1070851)
  (fixes openSUSE/zypper#177)
- Add filesize check for downloads with known size (bsc#408814)
- Removed superfluous space in translation (bsc#1102019)
- version 17.6.0 (2)
* Thu Jul 19 2018 ma@suse.de
- Prevent the system from sleeping during a commit
  (fixes openSUSE/zypper#135)
- RepoManager: Explicitly request repo2solv to generate application
  pseudo packages.
- version 17.5.2 (2)
* Wed Jul 18 2018 ma@suse.de
- libzypp-devel should not require cmake (bsc#1101349)
- Avoid zombies from ExternalProgram
- Update ApiConfig
- fix typo
- version 17.5.1 (2)
* Mon Jul  9 2018 ma@suse.de
- HardLocksFile: Prevent against empty commit without Target having
  been been loaded (bsc#1096803)
- lsof: use '-K i' if lsof supports it (bsc#1099847)
- PackageProvider: Validate deta rpms before caching (bsc#1091624,
  bsc#1088705, CVE-2018-7685)
- PackageProvider: Validate downloaded rpm package signatures
  before caching (bsc#1091624, bsc#1088705, CVE-2018-7685)
- version 17.5.0 (2)
* Mon Jun 25 2018 ma@suse.de
- Flags: make it std=c++14 ready
- Replace 'redhat-release' with generic 'system-release' (#120)
- Ignore /var, /tmp and /proc in zypper ps (bsc#1096617)
- Show GPGME version in log
- version 17.4.0 (2)
* Thu Apr 26 2018 ma@suse.de
- Avoid zombie tar processes (bsc#1076192)
- Replace the terminology 'uninstallable' with 'not installable'
  (bsc#1029392)
- version 17.3.1 (2)
* Mon Apr  9 2018 ma@suse.de
- Show progressbar when running posttrans scripts
- Execute service plugin script chrooted to the RepoManagers root
  (bsc#1080693)
- Make sure the product file comes from /etc/products.d for the
  fallback product search (bsc#1086602)
- Introduce ZConfig::repoManagerRoot to support having diverging
  target and repomanager root paths
- Rename `stderr` as it can be a macro (fixes #102)
- version 17.3.0 (2)
* Tue Mar 13 2018 ma@suse.de
- Protect code against broken translations (bsc#1082711)
- Fix broken translated format strings
- Deprecate the use of asciidoc for new releases
- version 17.2.2 (2)
* Wed Mar  7 2018 ma@suse.de
- PoolQuery::addDependency add overload to define an individual
  Match::Mode (bsc#1043166)
- version 17.2.1 (2)
* Thu Mar  1 2018 bzeller@suse.de
- Add /var/lib/gdm to CheckAccessDeleted blacklist (bsc#1079991)
- Use gpgme instead of calling gpg2 binary directly
- Fix leak in Digest.cc (bsc#1075978)
- version 17.2.0 (2)
* Tue Feb 20 2018 ma@suse.de
- RpmDb::checkPackage: fix parsing localized rpm output (bsc#1076415)
- Replace libexpat with libxml
- Fix libzypp tests failing with `-Wp,-D_GLIBCXX_ASSERTIONS`
  compiler flag (fixes #84)
- BuildRequire gpg2 as testcases need it (fixes #84)
- version 17.1.3 (0)
* Fri Feb  2 2018 ma@suse.de
- Fix crash when installing broken rpm packages (bsc#1078284)
- Testcase: Minor fix writing update testcases
- version 17.1.2 (0)
* Mon Jan 15 2018 ma@suse.de
- Adapt rpm package verification to changes in rpm-4.14 (bsc#1076018)
- version 17.1.1 (0)
* Thu Jan  4 2018 ma@suse.de
- plugin: don't reject header values containing a ':' (bsc#1074687)
- Locks: Don't store duplicate locks (bsc#969569)
- version 17.1.0 (0)
* Wed Dec  6 2017 ma@suse.de
- Fix default for solver.allowNameChange (bsc#1071466)
- version 17.0.5 (0)
* Mon Dec  4 2017 ma@suse.de
- Stop BuildRequire dropped boost-devel (bsc#1062782)
- version 17.0.4 (0)
* Tue Nov 28 2017 ma@suse.de
- When importing multiple keys, export the individual keys
  ascii armored for import into the rpmdb (bsc#1069381)
- version 17.0.3 (0)
* Thu Nov 23 2017 ma@suse.de
- Don't filter procs with a different mnt namespace (bsc#1068708)
- Support repo variables in an URIs host:port component
  (bsc#1057640, bsc#1067605)
- version 17.0.2 (0)
* Fri Nov 10 2017 ma@suse.de
- Solvable: fix inconsistent retrieval of mediaNr (bsc#1065677)
- version 17.0.1 (0)
* Tue Nov  7 2017 ma@suse.de
- Locale: Fix possible segfault (bsc#1064999)
- RpmDb: Remove excess keys in the zypp keyring when exporting keys only
  (bsc#1064380)
- KeyRing: Fix deleted keys not removed from rpmdb too (bsc#1064380)
- Flag gpg keycache dirty when adding/removing keys (bsc#1064380)
- Version 17.x for CODE-15, 16.x. is continued on SuSE-SLE-12-SP2-Branch
- version 17.0.0 (0)
* Thu Oct 12 2017 ma@suse.de
- Fix media handling in presence of a repo path prefix (bsc#1062561)
- version 16.17.3 (0)
* Wed Oct 11 2017 ma@suse.de
- Fix RepoProvideFile ignoring a repo path prefix (bsc#1062561)
- version 16.17.2 (0)
* Fri Sep 22 2017 ma@suse.de
- Default to 'solver.dupAllowVendorChange = false' on SLE15
  (FATE#323478)
- Remove unused legacy notify-message script (bsc#1058783)
- version 16.17.1 (0)
* Fri Sep  8 2017 ma@suse.de
- Support multiple product licenses in repomd (FATE#322276)
- version 16.17.0 (0)
* Thu Sep  7 2017 ma@suse.de
- Propagate 'rpm --import' errors (bsc#1057188)
- Fix typos in zypp.conf
- version 16.16.0 (0)
* Mon Aug 28 2017 ma@suse.de
- Add testcase to compile (bsc#1055920)
- version 16.15.6 (0)
* Fri Aug 25 2017 ma@suse.de
- Adapt to work with GnuPG 2.1.23 (bsc#1054088)
- version 16.15.5 (0)
* Fri Aug 25 2017 ma@suse.de
- verifyFileSignature: Support signing with subkeys (bsc#1008325)
- PublicKey: Scan and provide subkey information.
- Enhance sort order for media.1/products (bsc#1054671)
- Drop detection and support for rpm-4.4 (fixes #77)
- version 16.15.4 (0)
* Fri Aug 11 2017 ma@suse.de
- RepoInfo: add enum GpgCheck for convenient gpgcheck mode handling
  (bsc#1045735)
- Fix repo/pkg checks to follow explicitly defined gpgcheck in a
  .repo file
- version 16.15.3 (0)
* Fri Jul 21 2017 ma@suse.de
- Weaken fix for bsc#1038984 if 'gpgcheck=0' in libzypp-16.15.x only.
  This will allow some already released products to adapt to the
  behavioral changes introduced by fixing bsc#1038984, while systems
  with a default configuration (gpgcheck=1) already benefit from
  the fix in libzypp-16.15.x. For details see section
  'Signature checking' in /etc/zypp/zypp.conf.
- Fix gpg-pubkey release (creation time) computation (bsc#1036659)
- update lsof blacklist (bsc#1046417)
- version 16.15.2 (0)
* Tue Jul 18 2017 ma@suse.de
- Be sure bad packages do not stay in the cache
  (bsc#1045735, CVE-2017-9269)
- version 16.15.1 (0)
* Mon Jul 17 2017 ma@suse.de
- PackageProvider: enforce a signed package if pkgGpgCheckIsMandatory
- Add RpmDb::checkPackageSignature to report unsigned packages
- Fix repo gpg check workflows, mainly for unsigned repos and packages
  (bsc#1045735, bsc#1038984, CVE-2017-7435, CVE-2017-7436, CVE-2017-9269)
- version 16.15.0 (0)
* Wed Jul 12 2017 ma@suse.de
- repo refresh: Re-probe if the repository type changes (bsc#1048315)
- MediaCurl: Propagate proper error code to DownloadProgressReport
  (bsc#1047785)
- Allow to trigger an appdata refresh unconditionally (bsc#1009745)
- Support custom repo variables defined in /etc/zypp/vars.d (fixes #68)
- rename: handle EXDEV error on OverlayFS
- version 16.14.0 (0)
* Fri Jun 30 2017 ma@suse.de
- Adapt loop mounting of iso images (bsc#1038132, bsc#1033236)
- Adjust zypp.conf for openSUSE Tumbleweed (bsc#1031756)
- Change arch variable names conflicting with compiler macros (fixes #70)
- Fix potential crash if repo has no baseurl (bnc#1043218)
- version 16.13.0 (0)
* Wed May 31 2017 ma@suse.de
- Testcase: add missing solver flags (bsc#1041889)
- version 16.12.0 (0)
* Fri May 12 2017 ma@suse.de
- add identIsAutoInstalled convenience methods
- make gcc6 happy
- version 16.11.0 (0)
* Thu May 11 2017 ma@suse.de
- Use a common workflow for downloading packages and srcpackages.
  This includes a common way of handling and reposrting gpg signature
  and checks. (bsc#1037210)
- PackageProvider: as well support downloading SrcPackage (for bsc#1037210)
- version 16.10.0 (0)
* Thu Apr 27 2017 ma@suse.de
- PoolQuery: Treat explicit queries for 'kind:name' correctly
  (bsc#1035729)
- version 16.9.0 (0)
* Fri Apr 21 2017 ma@suse.de
- Add API to control resolver job to update all packages (FATE#320653)
- Remove legacy vendor equivalence between 'suse' and 'opensuse'
  (bsc#1030686)
- version 16.8.0 (0)
* Fri Apr 21 2017 ma@suse.de
- RepoInfo: Allow temporary repos to control their metadata
  directories (bsc#1032632)
- Arch: add armv5tl
- version 16.7.0 (0)
* Thu Mar 30 2017 ma@suse.de
- Recognize license tarball in rpmmd repos (FATE#316159)
- Fix media verification to properly propagate media access errors
  (bsc#1031093)
- version 16.6.1 (0)
* Mon Mar 27 2017 ma@suse.de
- Fix invalidation of PoolItems if Pool IDs are reused (bsc#1028661)
- version 16.6.0 (0)
* Mon Mar 27 2017 ma@suse.de
- Fix X-libcurl-Empty-Header-Workaround (bsc#1030919)
- version 16.5.2 (0)
* Tue Mar 21 2017 ma@suse.de
- MediaCurl: Treat http response 410(Gone) like 404(Not Found)
  (bsc#1030136)
- version 16.5.1 (0)
* Thu Mar 16 2017 ma@suse.de
- Support multi-volume repomd repositories (FATE#320544)
- MediaCurl: ZYPP_MEDIA_CURL_IPRESOLVE=<4|6> to force name resolution
  to IPv4/IPv6 only (fixes openSUSE/zypper#49)
- Add support for openssl >= 1.1
- version 16.5.0 (0)
* Mon Feb 20 2017 ma@suse.de
- PublicKey: Create tmpdirs inside ZYpp::tmpPath (bsc#926844)
- Don't create AnonymousUniqueId in chroot (bsc#1024741)
- version 16.4.3 (0)
* Tue Feb 14 2017 ma@suse.de
- dumpAsXmlOnL: xml escape node content (bsc#1024909)
- version 16.4.2 (0)
* Fri Feb  3 2017 ma@suse.de
- MediaMultiCurl: Trigger aliveCallback when downloading metalink
  files (bsc#1021291)
- version 16.4.1 (0)
* Thu Jan 26 2017 ma@suse.de
- Add API for updating the AutoInstalled db
- MediaCD: Fix mountpoint creation after failing udf mount (bsc#1022046)
- fix misleading indentation (fixes #65)
- Fix compilation error reported by GCC7 (#63).
- Prefer calling "repo2solv" rather than "repo2solv.sh"
- version 16.4.0 (0)
* Wed Dec 14 2016 ma@suse.de
- Don't raise FileCheckException if user accepted a package with wrong
  digest (bsc#1014265)
- Also provide the exception history when requesting a media failed
  (bsc#1010952)
- version 16.3.2 (0)
* Tue Oct 11 2016 ma@suse.de
- Let 'dup --from' leave an updateTestcase-<DATE> in /var/log (bsc#1004096)
- version 16.3.1 (0)
* Tue Oct 11 2016 ma@suse.de
- RepoInfo: Allow parsing multiple gpgkey= URLs (bsc#1003748)
- version 16.3.0 (0)
* Tue Sep 20 2016 ma@suse.de
- guessPackageSpec: Don't break globbing (fixes openSUSE/zypper#97)
- version 16.2.5 (0)
* Thu Sep 15 2016 ma@suse.de
- RepoFileReader: fix parsing of multiline url entries (bsc#964932)
- Allow repo type 'rpm' as alias for 'rpm-md' (fixes openSUSE/zypper#100)
- version 16.2.4 (0)
* Fri Sep  9 2016 ma@suse.de
- xmlout::Node:  Allow adding nore attributes while the start node
  is not closed (FATE#320699)
- Fixes broken XML output introduced by an unwanted change in 16.2.2
  (bsc#998344)
- version 16.2.3 (0)
* Wed Aug 10 2016 ma@suse.de
- Report numeric curl error if code is unrecognized (bsc#992302)
- multicurl: propagate proxy settings stored in repo url (bsc#933839)
- version 16.2.2 (0)
* Thu Jul 21 2016 ma@suse.de
- Rebuild .solv-files not matching the parsers LIBSOLV_TOOLVERSION
- BuildRequires:  libsolv-devel >= 0.6.23
- version 16.2.1 (0)
* Mon Jul 18 2016 ma@suse.de
- Product: Offer tri-state hasEndOfLife details (FATE#320699)
- version 16.2.0 (0)
* Thu Jul 14 2016 ma@suse.de
- use more user friendly command names for "zypper ps" (bsc#980541)
- version 16.1.3 (0)
* Thu Jul 14 2016 ma@suse.de
- Don't do media number substitution on URLs of medium #1 (bsc#798470)
- version 16.1.2 (0)
* Tue Jul  5 2016 ma@suse.de
- Fix Shrink pool if all repos are removed (bsc#899755, bsc#987573)
- version 16.1.1 (0)
* Fri Jun 24 2016 ma@suse.de
- API enahncements for zypper (FATE#320447)
- version 16.1.0 (0)
* Tue Jun 21 2016 ma@suse.de
- Filter duplicate resolver solutions (bsc#985674)
- zypp.conf: Add download.media_mountdir: Path where media are
  preferably mounted or downloaded (FATE#319462)
- version 16.0.5 (0)
* Wed Jun 15 2016 ma@suse.de
- Fix bug in removeRepository which may keep an empty .repo file
  rather than deleting it (bsc#984494)
- version 16.0.4 (0)
* Mon Jun 13 2016 ma@suse.de
- Shrink pool if all repos are removed (bnc#899755)
- Avoid direct BuildRequire on libudev-devel (#60)
- version 16.0.3 (0)
* Tue Jun  7 2016 ma@suse.de
- Allow PackageKit to drop the zypp lock (bnc#899755)
- Avoid superfluous rebuilding of indices when solving
- version 16.0.2 (0)
* Sun Jun  5 2016 ma@suse.de
- po: upadte makefiles
- DefaultIntegral: provide asString (for FATE#320447)
- version 16.0.1 (0)
* Fri May 13 2016 ma@suse.de
- Prepare cmake to maintain the .pot and .po files in git. Add
  initial .po file set derived from tarballs. Translations are now
  maintained via Weblate.
- Provide 'libzypp(plugin:services) = 1' after fixing bsc#933760
- Bump major version for Factory, 15.x is continued on SuSE-SLE-12-SP1-Branch
- version 16.0.0 (0)
* Thu Apr 28 2016 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Thu Apr 28 2016 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Mon Apr 25 2016 ma@suse.de
- Fix credential file parser losing entries with known URL but
  different user name (bsc#933760)
- RepoManager: allow extraction of multiple baseurls for service
  repos (bsc#964932)
- addRepository: fix to use the correct history file for logging
- specfile: add /etc/zypp/credentials.d to the file list
- version 15.22.0 (19)
* Mon Apr 18 2016 ma@suse.de
- RepoindexFileReader: fix service metadata TTL default value (bsc#967828)
- version 15.21.7 (19)
* Fri Apr 15 2016 ma@suse.de
- DiskUsageCounter: Limit estimated waste per file (bsc#974275)
- version 15.21.6 (19)
* Fri Mar 18 2016 ma@suse.de
- Use PluginExecutor for commit- and system-hooks (bnc#971637)
- BuildRequires:  libsolv-devel >= 0.6.19 (bnc#971018)
- version 15.21.5 (19)
* Sun Mar 13 2016 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Mar 10 2016 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Mar  1 2016 ma@suse.de
- media: Send stats header to download.opensuse.org only (bsc#955801)
- fix build-compare (#57, #58)
- version 15.21.4 (19)
* Thu Feb 18 2016 ma@suse.de
- yum::Downloader: Download only wanted 'susedata.LANG' files
  (FATE#320518)
- version 15.21.3 (19)
* Thu Feb  4 2016 ma@suse.de
- installSrcPackage: trigger progress callback (bsc#580902)
- version 15.21.2 (19)
* Thu Feb  4 2016 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Jan 29 2016 ma@suse.de
- Don't buildrequire graphviz-gnome (bsc#964150)
- Unwanted btrfs subvolumes must be filtered by device (not fsid)
  (fixes #54)
- version 15.21.1 (19)
* Thu Jan 21 2016 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Jan 20 2016 ma@suse.de
- Filter unwanted btrfs subvolumes (fixes #54, closes #55, bnc#949945)
- RepoInfo: Provide access to repo content keywords
- Build with boost-1.60.0
- version 15.21.0 (19)
* Thu Jan 14 2016 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jan  7 2016 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Dec 24 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Dec 11 2015 ma@suse.de
- ResPoolProxy: make begin/end pairs Iterable
- String: Format and FormatNAC classes based on boost::format
- DefaultIntegral: provide initial value
- More specific exception message if GPG binary is missing (bsc#637791)
- version 15.20.0 (19)
* Thu Dec 10 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Dec  3 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Nov 22 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Nov 19 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Thu Nov 19 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Nov 16 2015 ma@suse.de
- createPot: Fix plural form detection (bsc#955053)
- version 15.19.7 (19)
* Thu Nov 12 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Nov  8 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Nov  6 2015 ma@suse.de
- Add testcase for uncached repo-variables.
- Fixed Japanese translations (bsc#949196)
- version 15.19.6 (19)
* Fri Nov  6 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Thu Nov  5 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Thu Nov  5 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Nov  3 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Tue Nov  3 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Oct 23 2015 ma@suse.de
- Fix broken product: <-> -release package relation (bnc#951782)
- version 15.19.5 (19)
* Thu Oct 22 2015 ma@suse.de
- Use a uniform translation set for SLE and openSUSE (bnc#948924)
- fix Plugin-services not updating repo GPGCheck settings (bnc#951402)
- version 15.19.4 (19)
* Sun Oct 18 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Oct 15 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Oct 14 2015 ma@suse.de
- make Solvable::asUserString more readable (bnc#949957)
- version 15.19.3 (19)
* Sun Oct 11 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Oct  8 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Oct  7 2015 ma@suse.de
- fix suse_version test (bsc#949046)
- version 15.19.2 (19)
* Wed Oct  7 2015 ma@suse.de
- Locks: fix using namespaces (for FATE#318299)
- version 15.19.1 (19)
* Mon Oct  5 2015 ma@suse.de
- fix reserved identifier violation (fixes #51)
- solver: speed up collecting pool data to build the job queue
- doc: short abstract about 'Code 12 Application Metadata'
- version 15.19.0 (19)
* Tue Sep 29 2015 ma@suse.de
- solver verify: multiversion property needs to be assigned to
  installed items too.
- ZYppCommitResult: add attemptToModify to indicate an attempt to
  actually install/remove was made (bsc#946750, FATE#319467)
- version 15.18.0 (14)
* Mon Sep 28 2015 ma@suse.de
- SetTracker: fix computation of change sets (bsc#946898)
- version 15.17.2 (14)
* Fri Sep 25 2015 ma@suse.de
- Pattern: support dynamic computation of pattern visibility (bsc#900769)
- Avoid URL rewrite if probing local cache directories (bsc#946129)
- version 15.17.1 (14)
* Mon Sep 21 2015 ma@suse.de
- Dummy (FATE#318827) to make Sles-changelog-checker stop whining.
- version 15.17.0 (14)
* Mon Sep 21 2015 ma@suse.de
- Glob: fix reserved identifier violation
- version 15.16.2 (14)
* Tue Sep 15 2015 ma@suse.de
- CheckAccessDeleted: Identify services by systemd cgroup (FATE#318827)
- version 15.16.1 (14)
* Mon Sep 14 2015 ma@suse.de
- Reload multiversion setting from the target zypp.conf (bnc#906096)
- version 15.16.0 (14)
* Sun Sep 13 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Sun Sep 13 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep 10 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Fri Sep  4 2015 ma@suse.de
- Don't cache repo releasever (bnc#943563)
- Selectable: allow setPickStatus for non-multiversion packages
  (bnc#943870)
- ResPoolProxy: add ScopedSaveState
- version 15.15.0 (14)
* Tue Sep  1 2015 ma@suse.de
- zypp.conf: add solver.dupAllow{Downgrade,NameChange,ArchChange,
  VendorChange} default options for tuning distribution upgrades.
- Remove obsolete method (bsc#941398) (fixes #50)
- fix invalid XML (bnc#942518)
- version 15.14.0 (14)
* Sun Aug 30 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug 27 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Thu Aug 20 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Aug 16 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug 13 2015 ma@suse.de
- Support caching of service metadata. A TTL for the service
  metadata may be provided in the repoindex.xml itself. The
  default is 'no caching'. (FATE#318136)
- Fix setting dup_allow* solver options (bnc#941463)
- Don't make zypper encode {} around repo vars (bnc#941453)
- version 15.13.0 (11)
* Thu Aug 13 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Aug 11 2015 ma@suse.de
- History: Add 'command' tag showing who triggered the commit.
  The corresponding HistoryLogData class for parsing is
  HistoryLogDataStampCommand. Available data are the commandline
  executed, user@hostname and userdata/transactionID. (FATE#312298)
- Add convenience comparison PoolItem<>ResObject::constPtr
- Fixes for SWIG 2.x
- version 15.12.0 (11)
* Mon Aug 10 2015 ma@suse.de
- Make multiversion an individual solvables property (FATE#318778)
- SolvableType: common api to access solvable properties
- Support for MIPS architectures
- version 15.11.0 (11)
* Sun Aug  9 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Aug  2 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 30 2015 ma@suse.de
- Resolver: Track changed requested locales and adjust installed
  packages accordingly. (part of FATE#318099)
- Testcase: Store autoinstalled packages
- Locale: Make it IdString based
- Get rid of std::tr1:: hashes
- Flags: Fix to work with 'enum class'
- Hide away resolver internals
- version 15.10.0 (10)
* Thu Jul 30 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Jul 28 2015 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Mon Jul 27 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Jul 26 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 16 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Jul 12 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul  9 2015 ma@suse.de
- Resolver allow tuning DUP mode solver flags (FATE#319128)
- version 15.9.0 (5)
* Fri Jul  3 2015 ma@suse.de
- Flags<Enum>: add stringify
- add asString for Patch::InteractiveFlag
- version 15.8.0 (5)
* Thu Jul  2 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Jul  1 2015 ma@suse.de
- add asString for Patch::Category
- version 15.7.0 (5)
* Mon Jun 29 2015 ma@suse.de
- Fix lost pathname when importing repo keys (bnc#936373)
- Disable code swig does not understand
- version 15.6.0 (5)
* Sat Jun 27 2015 ma@suse.de
- Patch: fixup testing Category and Severity flags (FATE#318760)
- version 15.5.0 (5)
* Fri Jun 12 2015 ma@suse.de
- Add details to the default signature verification problem report
- PathInfo: Avoid ExternalProgram in clean_dir
- call rpmdb2solv without executing user-supplied scripts (bnc#926853)
- version 15.4.1 (3)
* Thu Jun 11 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jun  4 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Jun  3 2015 ma@suse.de
- Enhance solv.idx file handling to support zypper bash completion
- Fix SSL client certificate authentication via URL option
  ssl_clientcert/ssl_clientkey (bnc#932393)
- version 15.4.0 (3)
* Thu May 28 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun May 24 2015 ma@suse.de
- Downloader: Accept unsigned repository if pkgGpgCheck is ON.
- FindFileConflicts: avoid nested exception on user abort (bnc#931601)
- Support for *.check files in the systemCheck.d directory (#45)
- version 15.3.0 (3)
* Sun May 24 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Mon May 18 2015 ma@suse.de
- zypp.conf: Add config values for gpgcheck, repo_gpgcheck
  and pkg_gpgcheck. The default behavior 'gpgcheck=On' will
  automatically turn on the gpg signature check for packages
  downloaded from repository with unsigned metadata. If the
  repo metadata are signed, a faster comparison via checksums
  is done. By explicitly setting repo_gpgcheck or pkg_gpgcheck
  you can enforce the signature check of repository metadata
  or downloaded packages to be always performed. Those defaults
  can be overwritten per repository. (FATE#314603)
- version 15.2.0 (2)
* Wed May 13 2015 ma@suse.de
- Write solv.idx to speed up bash tab completion (bnc#928650)
- version 15.1.3 (1)
* Fri May  8 2015 ma@suse.de
- gcc5 fixes
- Fix repo alias containing ']' not handled correctly (bnc#929528)
- Fix SEGV when dumping rpm header with epoch (bnc#929483)
- version 15.1.2 (1)
* Mon Apr 27 2015 ma@suse.de
- PubliKey: fix reference to temporary data
- version 15.1.1 (1)
* Thu Apr 23 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Apr 22 2015 ma@suse.de
- ZYpp: Changed ZYpp::Ptr to be a shared_ptr;
  a precondition for fixing bnc-899755
- rpmmd: support 'metalink=' in .repo (for zypper#63)
- RepoMirrorList: ignore comments and malformed urls in mirrorlist
- PathInfo: remove minor/major conflicting with GNU libc macros
  DiskUsageCounter: remove ctors taking 'magic' bool flags
  ZyppCallbacks: remove unused PatchDownload callbacks
- version 15.1.0 (1)
* Thu Apr  2 2015 ma@suse.de
- POODLE: libzypp should only talk TLS (bnc#903405)
- Bump major version for Factory, 14.x is continued on SuSE-SLE-12-Branch
- version 15.0.0 (0)
* Thu Apr  2 2015 ma@suse.de
- Fixes to build with gcc5
- RepoProvideFile: Suppress MediaChangeReport while testing
  multiple baseurls (bnc#899510)
- version 14.38.1 (30)
* Thu Mar 19 2015 ma@suse.de
- Suppress MediaChangeReport while testing multiple baseurls (bnc#899510)
- version 14.38.0 (30)
* Mon Mar 16 2015 ma@suse.de
- add support for SHA224/384/512
- version 14.37.1 (30)
* Wed Mar 11 2015 ma@suse.de
- New RepoVarExpand: Functor expanding repo variables in a
  string . Supports bash style default ${v:-w}' and alternate ${v:+w}
  values (FATE#318354)
- Easy.h: Use __typeof__ rather than typeof in header
- Support repo variable replacement in service url
- Support repo variable replacement in gpg url
- Gettext.h: Fallback to ::gettext if accidentally included
  outside libzypp
- version 14.37.0 (30)
* Sun Feb 22 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Feb 19 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Feb 15 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Feb 12 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Feb  9 2015 ma@suse.de
- Don't execute scripts in /tmp or /var/tmp, as they could be
  mounted noexec for security reasons (bnc#915928)
- zypp/PublicKey.cc: Use GPG_BINARY from KeyRing
- Support $releasever_major/$releasever_minor repo variables
  (FATE#318354)
- version 14.36.0 (30)
* Sun Feb  8 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Feb  5 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Feb  1 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jan 29 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jan 22 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Jan 21 2015 ma@suse.de
- PathInfo: Deprecate major/minor in favor of new devMajor/devMinor.
  The old names clash with GNU libc macros.
- version 14.35.0 (30)
* Sun Jan 18 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jan 15 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Jan 12 2015 ma@suse.de
- Properly propagate repo variables in service refresh.
- Let $ZYPP_REPO_RELEASEVER overwrite $releasever in .repo files
  (bnc#911658)
- Call pool_set_rootdir to properly check for file conflicts.
- Use xgettext --boost to support boost-format (%%N%%)
- version 14.34.0 (30)
* Sun Jan 11 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jan  8 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jan  1 2015 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Dec 21 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Dec 19 2014 ma@suse.de
- Parse and offer productRegisterFlavor attribute (bnc#896224)
- version 14.33.0 (30)
* Thu Dec 18 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Dec 17 2014 ma@suse.de
- Improve conflict message for locked packages (bnc#828631)
- Fix broken de-escaping in str::splitEscaped (bnc#909772)
- cleanup loging
- version 14.32.2 (30)
* Fri Dec 12 2014 ma@suse.de
- CheckAccessDeleted: Filter PIDs running in a container (bnc#909143)
- version 14.32.1 (30)
* Wed Dec 10 2014 ma@suse.de
- suppress informal license (no need to accept) upon update (bnc#908976)
- version 14.32.0 (30)
* Mon Dec  8 2014 ma@suse.de
- Adapt to gpg-2.1 (bnc#908135)
- rpm: do not obsolete yast2-packagemanager-devel by libzypp-devel-doc
- replaceAll: fix endless loop on empty search string
- version 14.31.0 (30)
* Thu Nov 27 2014 dimstar@opensuse.org
- Do not provide/obsolete yast2-packagemanager-devel by the -doc
  package: the -devel package already does that.
- Minor .spec cleanup (remove Authors section).
* Tue Nov 11 2014 ma@suse.de
- Call rpm with '--noglob' (bnc#892431)
- Downloader: unify workflow downloading a (signed) master index file
- Fix iostream includes (fixes #34)
- Explicitly call libsolv:pool_setdisttype (fixes #36)
- version 14.30.2 (30)
* Sun Nov  9 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Nov  2 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Oct 27 2014 ma@suse.de
- doc: add hint to code 12 pattern packages
- MediaCurl: Fix URL path concatenation (bnc#901590)
- Move doxygen html doc to libzypp-devel-doc (bnc#901691)
- Remove non-breaking spaces from changes file
- Control lifetime of downloaded mirrorlist
- version 14.30.1 (30)
* Thu Oct 16 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Oct 15 2014 ma@suse.de
- Store baseurls in list as order expresses preference
- Support parsing multiple baseurls from a repo file (bnc#899510)
- Fix handling local mirrorlist= files in .repo (bnc#899510)
- Provide missing man pages (fixes #33)
- Enable building autodocs, translations and test per default on debian
- Fix several typos in output messages and comments (fixes #29)
- Make the include dir path configurable (fixes #27)
- version 14.30.0 (30)
* Fri Oct 10 2014 ma@suse.de
- Update zypp-po.tar.bz2 (bnc#899603)
* Thu Oct  9 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Oct  5 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Sep 28 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep 25 2014 ma@suse.de
- Trigger appdata plugin when system repos have changed (bnc#866257)
- Protect against race when destructing globals
- BuildRequire libsolv-tools as libsolv-devel no longer does
- version 14.29.4 (29)
* Thu Sep 25 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Sep 23 2014 ma@suse.de
- Fix computation of userinstalled items (bnc#897404)
- version 14.29.3 (29)
* Tue Sep 23 2014 ma@suse.de
- Adapt to API changes in rpm.4.12
- SLE-12 (suse_version 1315) uses it's own translations set
  (bnc#897176)
- version 14.29.2 (29)
* Sun Sep 21 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep 18 2014 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Thu Sep 18 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep 18 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Sep 17 2014 ma@suse.de
- adjust BuildRequires
- version 14.29.1 (29)
* Tue Sep 16 2014 ma@suse.de
- DiskUsageCounter: Set growonly on detetcted snapshotting btrfs
  partitions (bnc#896176)
- DiskUsageCounter: Allow MountPoint to store fstype
- DiskUsageCounter: Support setting 'growonly' partition hint
  (bnc#896176)
- version 14.29.0 (29)
* Fri Sep  5 2014 ma@suse.de
- Make Repository::isUpdateRepo also check for being referenced
  by products (bnc#892579)
- Report repositories skipped as nonroot due to insufficient
  permission (bnc#893260)
- version 14.28.0 (28)
* Thu Sep  4 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Aug 29 2014 ma@suse.de
- PackageProvider: consider toplevel cache if --root or --pkg-cachedir
  is used.
- Cleanup orpahned cache dirs only at zypp.conf default locations
  (bnc#891515)
- Remove orphaned package caches on refresh (bnc#888919)
- version 14.27.2 (27)
* Sun Aug 24 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Aug 18 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 31 2014 ma@suse.de
- Fix gpg key creation/modification date computation to properly
  update trusted keys stored in the rpm database.
- version 14.27.1 (27)
* Mon Jul 28 2014 mls@suse.de
- reverted last commit to make yast2-pkg-bindings build again
* Fri Jul 25 2014 ma@suse.de
- JobReport: extend callback to allow passing UserData
- hardlinkCopy must not fail if proc/sys/fs/protected_hardlink is on
- adapt to changed boost::error_category throw specifier
- version 14.27.0 (27)
* Fri Jul 18 2014 ma@suse.de
- Execute install scripts with cwd==/ (bnc#886764)
- fix wrong '//' when extending URLs with an empty path (bnc#885254)
- version 14.26.1 (26)
* Mon Jul 14 2014 ma@suse.de
- refreshService: add option to force repo status reset
- Strip local filenames and args from URL.
- version 14.26.0 (26)
* Fri Jul 11 2014 ma@suse.de
- Support RepoInfo content keywords (FATE#316287)
- fix parsing repomd.xml twice
- version 14.25.0 (23)
* Wed Jun 11 2014 ma@suse.de
- Patch: add isCategory/isSeverity convenience
- If available provide info in ServiceException
- version 14.24.0 (23)
* Wed Jun  4 2014 ma@suse.de
- Cleanup orphanded service repos on the fly (bnc#649846)
- Service refresh must not attempt to modify plugin services
- version 14.23.0 (23)
* Wed May 28 2014 ma@suse.de
- Fix service methods to throw ServiceException, not RepoException.
- version 14.22.0 (22)
* Tue May 27 2014 ma@suse.de
- Let ServiceRefresh en-/disable repos with respect to previous state
  and user modifications.
- RepoindexFileReader: support variable substitution
- Parse optional autorefresh attribute from repoindex.xml
- version 14.21.0 (20)
* Wed May 14 2014 ma@suse.de
- Add DownloadResolvableReport::infoInCache
- Adjust transfer timeout settings (bnc#877405)
- Fix computation of update candidate (bnc#834858)
- version 14.20.0 (20)
* Thu May  8 2014 ma@suse.de
- KeyRingReport: New infoVerify callback showing the trusted key
  that will be used for verification.
- version 14.19.0 (19)
* Sun May  4 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May  1 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Apr 28 2014 ma@suse.de
- Derive initial AutoInstalled file from history
- Target: maintain AutoInstalled database file
- version 14.18.0 (17)
* Tue Apr 15 2014 ma@suse.de
- Factor out CommitPackageCache for standalone usage. (Fate#317077)
- version 14.17.5 (17)
* Fri Apr 11 2014 ma@suse.de
- history: log %%posttrans errors and output
- adapt to libsolv cannges
- version 14.17.4 (17)
* Fri Apr  4 2014 ma@suse.de
- Log warning if baseproduct symlink is dangling or missing
- version 14.17.3 (17)
* Thu Apr  3 2014 ma@suse.de
- RepoManager: Fix RepoStatus computation and refresh of PLAINDIR repos.
- Recreate solv file caches if content may change even if raw metadata
  are unchanged (here: new pattern, product and application data).
- version 14.17.2 (17)
* Wed Apr  2 2014 ma@suse.de
- CpeId: Basic functionality incl. matching
- New SetRelationMixin
- version 14.17.1 (17)
* Mon Mar 31 2014 ma@suse.de
- Use dummy licenses in test data (bnc#862471)
- Install zypp-NameReqPrv helper for evaluating testcases.
- version 14.17.0 (17)
* Tue Mar 18 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Feb 26 2014 ma@suse.de
- Ignore failed-eject-exception on media change (bnc#865705)
- version 14.16.1 (16)
* Tue Feb 25 2014 ma@suse.de
- Remove duplicate code detecting known kinds and move it to
  ResKind::explicitBuiltin.
- version 14.16.0 (16)
* Sun Feb 23 2014 ma@suse.de
- Optionally exclude suggested packages from pattern content (bnc#857671)
- Fix pattern content for auto-pattens (bnc#864087)
- Don't report missing filelists for non-packages (bnc#864314)
- adapt to new rpm weak dependency tags
- version 14.15.0 (15)
* Fri Feb 14 2014 ma@suse.de
- Provide ContentIdentifier of required update repositories in Product
  (Fate#316160)
- Support CpeId in Repository and Product attributes (Fate#316160)
- Add API for retrieving repository ContentRevision and ContentIdentifier
  (Fate#316160)
- version 14.14.0 (14)
* Thu Feb 13 2014 ma@suse.de
- Adjust solver defaults to changed soft lock handling (bnc#863275)
- Avoid confusing solver decisions by not storing soft locks (bnc#863275)
- version 14.13.0 (13)
* Tue Feb 11 2014 ma@suse.de
- Add Product::endOfLife attribute (Fate#316172)
- Let Product::shortName fallback to name.
- Remove license text from test data (bnc#862471)
- version 14.12.0 (12)
* Sun Feb  2 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Jan 31 2014 ma@suse.de
- Introduce new solvable kind: Application (as provided by appdata.xml)
- version 14.11.0 (7)
* Fri Jan 31 2014 ma@suse.de
- String helper for printing indented text.
- Offer translated names for dependency types.
- version 14.10.0 (7)
* Thu Jan 30 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Jan 29 2014 ma@suse.de
- No fileconflict check if DownloadOnly.
- version 14.9.0 (7)
* Sat Jan 25 2014 ma@suse.de
- Collect and execute %%posttrans scripts delayed (Fate#313506)
- BuildRequire libsolv implementing (Fate#309385)
- version 14.8.0 (7)
* Fri Jan 24 2014 ma@suse.de
- Patterns are no longer pseudo installed (Fate#309385)
- version 14.7.0 (7)
* Fri Jan 24 2014 ma@suse.de
- Check for file conflicts in commit (bnc#673720)
- Add asUserSting: human readable (translated) string representation
- Add file conflict detection during commit (bnc#673720)
- Add Transaction::installedResult
- version 14.6.0 (6)
* Mon Jan 20 2014 ma@suse.de
- Fix cleanup code removing the @System solv file. (bnc#853065)
- Fix missing priority in RepoInfo::dumpAsXML (bnc#855845)
- version 14.5.0 (4)
* Tue Jan 14 2014 ma@suse.de
- Improve ProgressData reporting.
- Allow xml::escape directly dumping to a stream.
- Add support for repo authentication using SSL client certificates
  (bnc#683914)
- Enhance Queue to perform COW
- fix documentation
- version 14.4.0 (4)
* Thu Jan  9 2014 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Dec 13 2013 ma@suse.de
- Polish DiskUsageCounter
- Add Bitmap type (aka sat::Map)
- Remove obsolete DiskUsage class
- version 14.3.0 (3)
* Thu Dec 12 2013 ma@suse.de
- Fix disk usage computation for single packages (bnc#852943)
- version 14.2.1 (2)
* Wed Dec  4 2013 jreidinger@suse.com
- Drop package-manager script as it is already deprecated and
  packagekit usage in desktop invalidates it. If someone really
  need it, then place it to proper top level package which can
  decide what GUI is proper for given task.
* Wed Nov 20 2013 ma@suse.de
- Extend commit plugin to send the transaction list (Fate#316203)
- Add base/Json.h: JSON encoder for e.g. sending data to plugins
- Re-evaluate dropped packages list on upgrade, even if product
  remains unchanged (bnc#849251).
- Add ppc64le architecture
- Add m68k architecture
- version 14.2.0 (2)
* Fri Oct 25 2013 ma@suse.de
- Always properly initialize pool storage (bnc#846565)
- version 14.1.1 (0)
* Thu Oct 17 2013 ma@suse.de
- Add Package isCached and cachedLocation methods
- fixed PluginFrame::hasKey
- version 14.1.0 (0)
* Thu Oct 10 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Oct  6 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Oct  3 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Oct  2 2013 ma@suse.de
- fix handling symlinks in export pathname on NFSv4 (bnc#804544)
- Bump major version for Factory
  13.1 is continued on SuSE-Code-13_1-Branch
- version 14.0.0 (0)
* Sun Sep 29 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Sep 22 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Sep 18 2013 ma@suse.de
- Allow multiversionSpec manipulation in ZConfig
- Fix string hexdecoding
- Avoid parsing gpg subkeys but still parse multiple keys
- version 13.7.0 (6)
* Sun Sep 15 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep 12 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep  5 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Sep  2 2013 ma@suse.de
- Avoid parsing gpg subkeys
- Use explicit operator bool in TmpPath
- Must keep legacy rpm level flag (bnc#838039)
- version 13.6.0 (6)
* Sun Sep  1 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug 29 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Aug 27 2013 ma@suse.de
- remove deprecated methods
- fix key expiry date parsing (bnc#828672)
- Provide additional keys data in case the ASCII armored blob
  containes multiple keys
- No rpmdb key import in readony mode (bnc#828672)
- Fix rpmdb key import/export (bnc#828672)
- Reduce amount of gpg calls when importing/exporting keys.
- Add public accessible PublicKeyData/PublicKeyScanner classes
- fix ASCII armored PublicKey parsing (bnc#828672)
- fix typo (bnc#761985)
- Fix multiversion update candidate to respect an installed objects
  arch and vendor (bnc#820444)
- fix logfile truncation introduced by previous fix for (bnc#825490)
- Swig can't handle move constructor
- Workaround bnc#819354 by executing rpm in /. (bnc#827609)
- Try to detect Arch_ppc64p7 (requires glibc-2.16: getauxval)
- Fix file probing via tftp:// (bnc#803316)
- Add armv7hl to armv6hl compat to be in sync with libsolv.
- Support for armv6hl
- version 13.5.0 (5)
* Thu Aug 22 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Aug 18 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug 15 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug  8 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Aug  4 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug  1 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 25 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 18 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Jul 14 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 11 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Jun 21 2013 ma@suse.de
- Fix testcases failing if local pathnames contain umlauts
- Pathname: add move constructor and fix assign
- Set logfile permission upon file creation only (bnc#825490)
- Add arch ppc64p7
- version 13.4.0 (4)
* Tue Jun 11 2013 ma@suse.de
- Speedup scanning for modaliases (bnc#824110)
- version 13.3.0 (2)
* Sun May 26 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May 23 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May 16 2013 ma@suse.de
- Remove deprecated old stuff (aria2 support,
  old InstallOrder, old History parser)
- version 13.2.0 (2)
* Thu May 16 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun May 12 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May  9 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May  2 2013 ma@suse.de
- Discourage using SafeBool in favor of explicit operator bool
- version 13.1.0 (1)
* Mon Apr 29 2013 ma@suse.de
- Testsuite: Workaround boost::thread being not header only since
  boost-1.50 (boost ticket 7085)
- Adaptions to smart_pointer changes in boost-1.53; mainly introduce
  explicit operator bool; constructible and comparable with nullptr_t.
- Bump major version for Factory
  12.x is continued on SuSE-Code-12_3-Branch
- version 13.0.0 (0)
* Sun Apr 28 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Apr  5 2013 ma@suse.de
- added new fuction zypp::ZYpp::provideSrcPackage
- Treat opensuse-education as separate vendor (bnc#812608)
- AArch64 support
- version 12.11.0 (0)
* Wed Mar 27 2013 ma@suse.de
- added tftp-support (bnc#803316)
- version 12.10.1 (0)
* Tue Mar 26 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Mar 21 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Mar 10 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Mar  7 2013 ma@suse.de
- Adapt to libsolv dataiterator fixes
  (returning random data in some cases)
- Require and adapt to changes in libsolv-0.3.0
- version 12.10.0 (0)
* Thu Mar  7 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Mar  3 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Feb 27 2013 ma@suse.de
- Rephrase error message if 'lsof' is not installed (bnc#694427)
- version 12.9.0 (0)
* Fri Feb 15 2013 ma@suse.de
- Handle dangling update script symlinks in instsys. (bnc#803751)
- version 12.8.1 (0)
* Thu Feb 14 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Feb  7 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Feb  4 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Jan 22 2013 ma@suse.de
- make multicurl suppress progress reports for the metalink download
- work around libcurl bug that sometimes gives us old values in the
  progress callback
- version 12.8.0 (0)
* Fri Jan 18 2013 ma@suse.de
- Reduce logging
- MediaMultiCurl: throw AbortRequestException if aborted by user
- version 12.7.0 (0)
* Sun Jan 13 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Jan  6 2013 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Dec 27 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Dec 17 2012 ma@suse.de
- Add NamedValue<_Tp>: Simple value<>name mapping supporting aliases
- Enable zypper to remove zypp locks without evaluating the
  query (bnc#792901)
- Configure curl to "not fix the BEAST attack" (bnc#779177)
- version 12.6.0 (0)
* Sun Dec 16 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Dec  3 2012 ma@suse.de
- HistoryLogReader: new HistoryLogData based API for parsing the new
  history file entries (fate#312521)
  The old HistoryItem based API is deprecated but will
  still be available for a while if you compile with
  - DWITH_DEPRECATED_HISTORYITEM_API.
- Write userdata string to history log (fate#312521)
- Add HistoryLogReader testcases
- Adapt to libsolv 'medianr'-changes
- version 12.5.0 (0)
* Thu Nov 22 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Nov 18 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Nov 13 2012 ma@suse.de
- Forward userdata string to commit plugins in BEGINPLUGIN (fate#312521)
- Extend ZConfig to store a user defined string value (fate#312521)
- Add SIGSEGV handler trying to log a stack trace
- Add zypp::dumpBacktrace to dump current stack trace to a stream.
- Use gettext plural handling (bnc#784666)
- version 12.4.0 (0)
* Sun Nov  4 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Oct 24 2012 ma@suse.de
- Add simple sysconfig::write (bnc#766598)
- For installed products also filelists when trying to find the buddy
  (bnc#784900)
- Provide information whether product license needs to be accepted.
- version 12.3.0 (0)
* Thu Oct 18 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Oct  7 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Oct  1 2012 ma@suse.de
- Enable multiversion kernel and set multiversion.kernels in
  /etc/zypp/zypp.conf to keep the latest, latest-1 and the running.
- Fix typo (bnc#782801)
- Relax evaluation of patch category tags (case insensitive)
* Sun Sep 30 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Sep 16 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Sep 12 2012 ma@suse.de
- Add str::commonPrefix
- version 12.2.0 (0)
* Sun Sep  9 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Sep  5 2012 gs@suse.de
- Provide Target::reload()
- version 12.1.0 (0)
* Sun Aug 26 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug 23 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Aug 19 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug 16 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Aug 10 2012 ma@suse.de
- Implement $ZYPP_LOCK_TIMEOUT: number of seconds to wait for a
  zypplock becoming available (bnc#772965)
- Unify update-scripts with same content(md5sum) (bnc#773575)
- version 12.0.1 (0)
* Thu Aug  9 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug  2 2012 ma@suse.de
- set $ZYPP_IS_RUNNING during commit
- Bump major version for Factory
  11.x is continued on SuSE-Code-12_2-Branch
- version 12.0.0 (0)
* Thu Aug  2 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Aug  1 2012 ma@suse.de
- Fixed typo (bnc#773467)
- Erase any old repo instance from pool when (re)loading from cache
- filter zero sized devices in disk usage counter(bnc#769819)
- fix isSoftLocked computation
- fix possibly reporting timeout as "aborted by user" (bnc#665327)
- do not fork the uuidgen program, use kernel interface instead
- remove obsolete hicolor-icon-theme BuildRequires
- version 11.7.0 (6)
* Sun Jul 29 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 19 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Jul  1 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jun 28 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Jun 25 2012 ma@suse.de
- zypp.conf:servicesdir is ignored (bnc#765528)
- allow libcurl to take proxy from environment iff proxy is not
  configured or disallowed (bnc#745404)
- version 11.6.3 (6)
* Sun Jun 24 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jun 14 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Jun  8 2012 ma@suse.de
- Adjust weaklock fix
* Fri Jun  8 2012 ma@suse.de
- Fix processing of weak locks (bnc#749418, bnc#765164)
- [valgrind] don't dereference if we may be past the end of the repositories.
- add armv7hl workaround for Adrian
- version 11.6.2 (6)
* Sun Jun  3 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May 31 2012 dmacvicar@suse.com
- fix an invalid read revealed by valgrind in
  RepositoryIterator::increment()
* Sun May 20 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May 17 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun May 13 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Tue May  8 2012 ma@suse.de
- Use ld version script to hide symbols outside zypp namespace (bnc#755324)
- remove base/Deprecated.h (macros now in APIConfig.h)
- Disribute Easy.h in APIConfig.h
- Add APIConfig.h providing ZYPP_API and ZYPP_LOCAL macros
- version 11.6.0 (6)
* Fri May  4 2012 ma@suse.de
- build with gcc-4.7 (bnc#755324)
- version 11.5.0 (5)
* Wed Apr 25 2012 ma@suse.de
- Fix lost device info when mounting CD/DVD
* Sun Apr 22 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Apr 19 2012 ma@suse.de
- Always consider (block) devices passed as url option (bnc#755815)
* Thu Apr 19 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Apr 18 2012 ma@suse.de
- Fix install progress hopping back and forth
- Try to create a missing destination dir before switching to tmp
  space (bnc#755239)
* Mon Apr 16 2012 ma@suse.de
- ResStatus: add 'unneeded' bit (determined by solver)
- Force using gcc-4.6 until it builds with 4.7
- Support multiversion definitions being read from files in /etc/zypp/multiversion.d.
- Workaround doxygen SEGV and accept incomplete docs (until bnc#755402 is fixed)
- Rename zypp::sat::AttrMatcher to zypp::StrMatcher (base/StrMatcher.h)
- Support (source)package download by non-root user (bnc#755239)
- Delay construction of ZYppGlobalLock until its actually needed (bnc#575096)
- Fix buddy handling in solver results
- Simplify Selectable::multiversionInstall
- Don't cache defaultCandidate as it depends on solver::allowVendorChange flag (bnc#754286)
- version 11.4.0 (4)
* Tue Apr 10 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Apr  8 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Apr  5 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Mar 26 2012 ma@suse.de
- Cleanup orphaned media attach points (bnc#751221)
- Show max support status if package is in multiple repos (bnc#735841)
- Parse proxy user/pass from url (bnc#752497)
- Add CMake option to disable libproxy usage and disable it on SLE. (bnc#752500)
- version 11.3.0 (1)
* Thu Mar 15 2012 ma@suse.de
- Add API for patch severity (bnc#733723, FATE#312633)
- version 11.2.0 (1)
* Tue Mar 13 2012 ma@suse.de
- Force libproxy into using "/etc/sysconfig/proxy" if it exists (bnc#679322)
- Apply soft locks by name and not per package (bnc#749418)
- version 11.1.1 (1)
* Fri Feb  3 2012 ma@suse.de
- Add Fetcher support for CHECKSUMS file (replaceing SHA1SUMS) (bnc#744302)
- Build with -fvisibility-inlines-hidden
- CheckAccessDeleted: avoid duplicate entries for the same PID (bnc#716972)
- Correctly use user:pass directly embedded in a proxy url (bnc#740764)
- new sat::Map - Libsolv (bit)Map wrapper.
- always set splitprovides to true now that libsolv handles them better
- version 11.1.0 (1)
* Thu Feb  2 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Jan 29 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Jan 22 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Jan 10 2012 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Dec 23 2011 ma@suse.de
- Adapt Repository iteration to libsolv changes.
- Add sat::Pool tests
- Fix Flags<> api to be more consistent and add testcase.
- Set min_curl_version 7.19.4 (bnc#735284)
- Doc: add some words about 'Solver - Vendor protection'
- version 11.0.0 (0)
* Thu Dec  1 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Nov 28 2011 ma@suse.de
- Fix and optimize Pathname ctor and provide testcases (bnc#721128)
- Open all file descriptors with O_CLOEXEC to avoid leaks and races
- Some improvements to the services documentation
- Fix RW_pointer comparison with underlying smart pointer type.
- version 10.3.5 (3)
* Sun Nov 27 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Nov 17 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Nov 11 2011 ma@suse.de
- Try to find and use some CD/DVD device even if HAL/UDEV detection
  fails (bnc#724807)
- Static initialization problem fixes (by Harald Fernengel)
- version 10.3.4 (3)
* Mon Nov  7 2011 ma@suse.de
- Don't use proxy if disabled (bnc#696805)
- version 10.3.3 (3)
* Mon Nov  7 2011 dimstar@opensuse.org
- Add pkg-config BuildRequires: We fail to detect libproxy due to
  the missing pkg-config. Additionally, we have a .pc file
  ourselfes, which we do not get the provides for [bnc#696805]
* Thu Nov  3 2011 ma@suse.de
- Let RepoInfo::keepPackages properly default to FALSE (bnc#727385)
- version 10.3.2 (3)
* Thu Nov  3 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Oct 30 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Oct 27 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Oct 24 2011 ma@suse.de
- Explicitly include textLocale in package translation download
* Mon Oct 24 2011 ma@suse.de
- Update libversion info (due to ABI change in 10.2.0 (bnc#725407)
- version 10.3.1 (3)
* Sun Oct 23 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Oct 21 2011 ma@suse.de
- Add zypp.conf option repo.refresh.locales: A list of locales for
  which translated package descriptions should be downloaded if
  available.
- Explixitly set CURLOPT_PROXYAUTH
- version 10.3.0 (1)
* Tue Oct 18 2011 ma@suse.de
- Add arch armv7tnhl and armv7thl
- Fix RepoVariablesReplacer to compute substitution values on demand only
- PathInfo::hardlinkCopy: fix handling cross-device links
- version 10.2.0 (1)
* Sun Oct 16 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Oct 13 2011 ma@suse.de
- Must not differ between type nfs and nfs4 when checking the mount
  table (bnc#710269)
- version 10.1.1 (1)
* Thu Oct 13 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Oct 11 2011 ma@suse.de
- Switch to using libsolv instead of satsolver
- version 10.1.0 (1)
* Sun Oct  9 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Oct  6 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Sep 20 2011 ma@suse.de
- Bump major version for Factory; 9.x is continued on SLE-11-SP2-Branch
- version 10.0.0 (0)
* Tue Sep 13 2011 ma@suse.de
- Enhance Selectable API
- version 9.11.0 (8)
* Sun Sep 11 2011 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Sun Sep 11 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep  8 2011 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Thu Sep  8 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Sep  7 2011 ma@suse.de
- Explicitly require rpm.
- version 9.10.2 (8)
* Sun Sep  4 2011 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Sun Sep  4 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Sep  1 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Aug 29 2011 ma@suse.de
- Extend mount entry comparison fix (bnc#710269)
- version 9.10.2 (8)
* Thu Aug 25 2011 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Mon Aug 22 2011 ma@suse.de
- Update sle-zypp-po.tar.bz2
* Sun Aug 14 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Aug  7 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Aug  5 2011 ma@suse.de
- Attempt to fix smb mount entry comparison (bnc#710269)
- version 9.10.1 (8)
* Thu Aug  4 2011 ma@suse.de
- Allow to turn Resolvers upgrade mode on and off (bnc#709480)
- Fix reading of integer arrays from rpm headers (bnc#709716)
- version 9.10.0 (8)
* Thu Aug  4 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jul 28 2011 ma@suse.de
- Evaluate CURLINFO_CONDITION_UNMET on zero sized successful transfers,
  if compiled against libcurl-7.19.4 or above. (bnc#692260)
- version 9.9.2 (8)
* Mon Jul 25 2011 ma@suse.de
- Always read /proc/mounts when looking for mounted media (bnc#705893)
- version 9.9.1 (8)
* Fri Jul 22 2011 ma@suse.de
- MediaUserAuth: Do not expose libcurl header files.
- version 9.9.0 (8)
* Mon Jul 18 2011 ma@suse.de
- More initialize parser structure fixes. (bnc#705181)
- version 9.8.7 (8)
* Fri Jul 15 2011 ma@suse.de
- Check for /etc/sysconfig/storage changes before solving (bnc#702365)
- version 9.8.6 (8)
* Fri Jul 15 2011 ma@suse.de
- Properly initialize parser structures (bnc#705181)
- version 9.8.5 (8)
* Thu Jul  7 2011 ma@suse.de
- Fix tests for available libcurl version.
- version 9.8.4 (8)
* Thu Jul  7 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Jul  4 2011 ma@suse.de
- Make fix for bnc#702576 more robust.
- Enhance fix for bnc#699435. Return an error if download in advance
  failed to provide all packages, so zypper does not silently quit.
- version 9.8.3 (8)
* Thu Jun 30 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Jun 29 2011 ma@suse.de
- Always compute transaction from pool (bnc#702576)
- version 9.8.2 (8)
* Tue Jun 28 2011 ma@suse.de
- Add feature provides for supported plugins.
* Tue Jun 21 2011 dmacvicar@suse.de
- Add configuration template for automatic kernel
  purge (feature#312018) to zypp.conf
* Tue Jun 14 2011 ma@suse.de
- Fix download loop to skip non-install actions. (bnc#699435)
- version 9.8.1 (8)
* Sun Jun 12 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Jun  9 2011 ma@suse.de
- Fix missing return value.
* Wed Jun  8 2011 ma@suse.de
- Simplify ZYppCommitResult by using filtered Transaction::action_iterator.
- version 9.8.0 (8)
* Tue Jun  7 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Jun  7 2011 ma@suse.de
- Fix transaction ORDER_BY_MEDIANR.
- version 9.7.0 (5)
* Fri Jun  3 2011 ma@suse.de
- Basic commit plugins implemented. They may be used to implement pre/post
  commit actions like taking file system snapshots (fate#303699)
- version 9.6.0 (5)
* Tue May 31 2011 ma@suse.de
- Do commit based on sat::Transaction.
- version 9.5.0 (5)
* Tue May 31 2011 ma@suse.de
- Assert rpm database directory is created before rpmtsInitDB is
  called (bnc#697115)
* Tue May 31 2011 dheidler@suse.de
- fix var definition order in PackageProvider
- fix operator~ return datatype for flags (ctor is explicit)
- add method interactiveFlags to Patch describing what makes it
  interactive
- version 9.4.0 (3)
* Tue May 31 2011 ma@suse.de
- Recommend 'lsof' (for zypper ps) (bnc#694427, bnc#684466)
* Mon May 30 2011 dheidler@suse.de
- Switch patch interactive-check to flags
- version 9.3.0 (3)
* Sun May 29 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Fri May 27 2011 ma@suse.de
- fix specfile to handle sles translations if available
* Fri May 27 2011 ma@suse.de
- Avoid using #elifdef directive.
* Thu May 26 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Wed May 25 2011 ma@suse.de
- Add a fallback gnome-packagekit updater in package-manager (bnc#667504)
- Backport changelog entries from SLE11-SP1 branch. Bugs mentioned here
  were either fixed without bnc# or do not apply to this branch. This is
  to make the changelog checker happy:
  - Set proper defaults for service repos (bnc#673943)
* Tue May 24 2011 dheidler@suse.de
- add option ignore_reboot_flag to Patch::interactive (bnc#665853)
- version 9.2.0 (2)
* Mon May 23 2011 dheidler@suse.de
- respect patch content license when determinating interactive status
- version 9.1.2 (1)
* Mon May 23 2011 ma@suse.de
- More rpm-4.9 fixes
- Disable rpm V3toV4 conversion while not working with rpm 4.9
* Sun May 22 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Fri May 20 2011 ma@suse.de
- Fix for rpm-4.9
- version 9.1.1 (1)
* Fri May 20 2011 ma@suse.de
- Disable use if rpm-4.4 legacy interface (dropped in 4.9) (bnc#691089)
- Fix poolquery handling repo restrictions correctly. (bnc#661976)
- version 9.1.0 (1)
* Wed May 18 2011 dmacvicar@suse.de
- Allow MediaCD to build against HAL or nothing
  if udev is not present
* Mon May 16 2011 dmacvicar@suse.de
- forward port all changes to make it build in Code10
* Mon May 16 2011 dmacvicar@suse.de
- make -Werror=format-security optional and used only if
  supported
* Sun May 15 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu May 12 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Fri May  6 2011 dheidler@suse.de
- delete old metadata temp directories
- version 9.0.3 (0)
* Wed Apr 27 2011 dheidler@suse.de
- fix max_concurrent_connections option in MultiCurl (bnc#596089)
- version 9.0.2 (0)
* Sun Apr 17 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Apr 12 2011 dheidler@suse.de
- check for permissions before writing (fixes bnc#683509)
- version 9.0.1 (0)
* Tue Apr  5 2011 ma@suse.de
- Switch ResPoolProxy to use multimap in order to allow iteration
  of all Selectables of all kinds.
- Add upper/lower_bound iteration to MapKVIterator.
- Add stream output for multimap/set.
- version 9.0.0 (0)
* Mon Apr  4 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Apr  4 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Apr  4 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Mar 10 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Sun Mar  6 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Feb 16 2011 dmacvicar@suse.de
- Do not look for $releasever 's value if there is no variable
  in the url: parses product file again and again
- version 8.12.2 (10)
* Thu Feb 10 2011 ma@suse.de
- Remove package-manager.desktop file (bnc#329635)
- version 8.12.1 (10)
* Tue Jan 25 2011 ma@suse.de
- Apply patch introducing armv7nhl:armv7hl
* Tue Jan 18 2011 dmacvicar@suse.de
- allow for Repo Index Services to set the enabled state of
  repositories from the server side.
- Fix priority not being set on reading service indexes
- version 8.12.0 (10)
* Fri Jan 14 2011 ma@suse.de
- Add new ServicePlugin Exceptions.
* Thu Jan 13 2011 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Dec 23 2010 dheidler@suse.de
- add method to check if there are manually configured urls
- version 8.11.0 (10)
* Thu Dec 23 2010 dheidler@suse.de
- create cache directory, if it doesn't exist
  when saving mirrorlist
- version 8.10.6 (10)
* Wed Dec 22 2010 dheidler@suse.de
- moved keepPackages code to RepoInfo::Impl
- version 8.10.5 (10)
* Tue Dec 21 2010 dheidler@suse.de
- Fix caching of mirrorlist files
- version 8.10.4 (10)
* Thu Dec 16 2010 ma@suse.de
- Do not export keyring if rpmdb is initialised, but target isn't
  (bnc#659494)
- version 8.10.3 (10)
* Fri Dec 10 2010 dheidler@suse.de
- Catch RPM-Exeption when instaling the Distribution (bnc#658714)
- version 8.10.2 (10)
* Wed Dec  8 2010 dheidler@suse.de
- fix retrieval of distributionVersion if target is not initialized
- MultiCurl: make sure the server responds with "partial content",
  fixes corrupt downloads if the metalink file contains no checksums
- version 8.10.1 (10)
* Wed Dec  1 2010 dheidler@suse.de
- Added ReplacerVar caching in RepoInfo
- Automaticly remove empty mirrorlist-files
- version 8.10.0 (10)
* Tue Nov 30 2010 dheidler@suse.de
- Added MirrorList caching
- version 8.9.0 (7)
* Mon Nov 29 2010 ma@suse.de
- Icons for libzypp should go into desktop-data. (bnc#329635)
- version 8.8.2 (7)
* Wed Nov 24 2010 ma@suse.de
- Properly handle FTP response 550. (bnc#645747)
- version 8.8.1 (7)
* Fri Nov 19 2010 mls@suse.de
- fix access of freed memory in MultiCurl (bnc#654600)
* Sun Nov  7 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Nov  3 2010 dheidler@suse.de
- added metalink support
- version 8.8.0 (7)
* Thu Oct 21 2010 ma@suse.de
- Feed the ProvideFilePolicy progress callback in addition to any
  connected media::DownloadProgressReport (bnc#545106)
- version 8.7.1 (7)
* Wed Oct 13 2010 dheidler@suse.de
- Make MetaLinkParser accept InputStreams
- Make MetaLinkParser accept Pathnames insted of strings
- Fix MetaLinkv4 hash parsing
- Add MetaLinkParser test
- version 8.7.0 (7)
* Mon Oct 11 2010 ma@suse.de
- Use timeouts in plugin script communication.
- Fix ExternalProgram to correctly remember exit status.
- version 8.6.0 (5)
* Sun Oct 10 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Oct  8 2010 dmacvicar@novell.com
- fix services not being linked to their file after being
  saved
* Thu Oct  7 2010 jkupec@suse.cz
- Don't use aria2c for FTP (bnc #641328)
* Wed Oct  6 2010 dmacvicar@novell.com
- implementation for url resolver plugins
- version 8.5.0 (5)
* Wed Oct  6 2010 dheidler@suse.de
- Use DownloadInHeaps as default, when there is nothing configured
  and when the target root is set to "/". (bnc#591476)
- version 8.4.0 (4)
* Tue Sep 28 2010 dheidler@suse.de
- fixed replacing releasever (for fedora systems) - (bnc#637470)
- version 8.3.0 (0)
* Fri Sep 24 2010 mls@suse.de
- fix metalink4 parsing [bnc#641484]
* Thu Sep 23 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Sep 20 2010 dmacvicar@novell.com
- Allow per repository proxy settings like yum does.
  Including setting it to _none_ overriding the
  system proxy.
  Patch from Zhang, Qiang <qiang.z.zhang@intel.com>
- version 8.2.1 (0)
* Fri Sep 10 2010 dheidler@suse.de
- fixed replacing basearch (for fedora systems) - (bnc#637473)
- version 8.2.0 (0)
* Fri Sep 10 2010 ma@suse.de
- Report download failures in commit result (bnc#431854)
- Fix Solvable::onSystemByUser returning true for uninstalled solvables.
- version 8.1.3 (0)
* Tue Aug 31 2010 ma@suse.de
- Fix download-only not to omit source packages (bnc#635596)
- version 8.1.2 (0)
* Thu Aug 26 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Aug 13 2010 dmacvicar@novell.com
- fix basearch url variable
- use the right release package name on fedora
* Tue Aug 10 2010 ma@suse.de
- MediaDISK: Use blkid to verify disk volumes. (bnc#623226)
- version 8.1.1 (0)
* Sun Aug  8 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Thu Aug  5 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Aug  3 2010 ma@suse.de
- Fix memory leaks.
* Mon Aug  2 2010 ma@suse.de
- Enhance PoolItem interface to assist patch classification. (bnc#627316)
- version 8.1.0 (0)
* Tue Jul 27 2010 ma@suse.de
- Fix bug in PoolQuery::addDependency
- Disable MediaAria and enable MultiCurl as default http/ftp backend.
  MultiCurl implements MetaLink and Zsync support using libcurl. In
  case of trouble set ZYPP_MULTICURL=0 in the envirionment to disable
  the new backend.
- version 8.0.1 (0)
* Mon Jul 26 2010 ma@suse.de
- Bump heads major version after 11.3 branched away.
- version 8.0.0 (0)
* Thu Jul 22 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Wed Jul  7 2010 ma@suse.de
- Add PoolQuery for name, edition AND architecture in one go. (bnc#614362)
- version 7.8.0 (6)
* Mon Jul  5 2010 ma@suse.de
- Fix requirement to /usr/bin/uuidgen (bnc#613304)
* Sun Jul  4 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Tue Jun 29 2010 ma@suse.de
- Fix CURLOPT_MAX_RECV_SPEED_LARGE expecting a curl_off_t argument.
* Tue Jun 29 2010 ma@suse.de
- Respect zypp.conf policy settings when solving for update.
* Fri Jun 25 2010 ma@suse.de
- Don't bloat logfile by logging install progess values.
* Thu Jun 10 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Mon Jun  7 2010 ma@suse.de
- Add missing Date constant declarations.
- version 7.7.5 (6)
* Mon Jun  7 2010 ma@suse.de
- Prevent against daemons launched in rpm %%post, that do not close
  their filedescriptors. Original fix was accidentally reverted.
  (bnc#174548)
- version 7.7.4 (6)
* Sun Jun  6 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Fri Jun  4 2010 ma@suse.de
- Fix default evaluation of recommendations of installed
  packages (bnc#605490)
- version 7.7.3 (6)
* Thu Jun  3 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Fri May 21 2010 ma@suse.de
- Fix broken IdStringType comparison (bnc#607572)
- version 7.7.2 (6)
* Thu May 20 2010 ma@suse.de
- Fix packages provided via delta rpm being placed in
  the wrong package cache (bnc#607583)
- version 7.7.1 (6)
* Thu May 20 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Tue May 18 2010 ma@suse.de
- Fix arch detection on sprac (bug #566291)
- Arch: add sparc64v and sparcv9v and armv7l
- RepoManager: refresh repo if last refresh is in the future (bnc#593617)
- version 7.6.1 (6)
* Mon May 17 2010 ma@suse.de
- Fix package-manager-su to support LXDE (Andrea Florio) (bnc#582235)
- Cleanup spec file (Pavol Rusnak)
- version 7.6.0 (6)
* Sun May 16 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Wed May 12 2010 ma@suse.de
- Add methods to evaluate gpg geys expiration dates.
- Export all rpmDb keys to the zypp trusted keyring in one go.
- version 7.6.0 (6)
* Wed May 12 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Sun May  9 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Sat May  8 2010 ma@suse.de
- Update zypp-po.tar.bz2
* Fri May  7 2010 ma@suse.de
- Update zypp-po.tar.bz2 (Revision: 54959)
* Wed May  5 2010 ma@suse.de
- Update zypp-po.tar.bz2 (Revision: 54959)
* Tue May  4 2010 ma@suse.de
- Update translations.
* Mon May  3 2010 ma@suse.de
- Improve solver.cleandepsOnRemove result by evaluating the install
  history to find packages installed on behalf of a user request (not
  auto added by the solver).
- version 7.5.0 (5)
* Sat May  1 2010 ma@suse.de
- Update translations.
* Fri Apr 30 2010 ma@suse.de
- Update translations.
* Thu Apr 29 2010 ma@suse.de
- Cleanup when deleting packages. New zypp.conf expert option
  solver.cleandepsOnRemove telling whether the solver should per
  default try to remove packages exclusively required by the ones
  he's asked to delete (default false).
- Resolver::cleandepsOnRemove API to allow applications to change
  the solver option.
- version 7.4.0 (4)
* Thu Apr 29 2010 ma@suse.de
- Update translations.
* Wed Apr 28 2010 ma@suse.de
- Enable splitprovides on update.
* Wed Apr 28 2010 ma@suse.de
- Update translations.
* Tue Apr 27 2010 ma@suse.de
- Selectable: Classify broken but locked patch as isUnwanted (bnc#577118)
- version 7.3.0 (2)
* Tue Apr 27 2010 ma@suse.de
- Use libudev to detect available cd/dvd devices (bnc#590707,fate#308980)
- Fix specfile to BuildRequire libudev-devel.
- version 7.2.0 (2)
* Mon Apr 26 2010 ma@suse.de
- Support URLs and ISOs ending on 'Media1', 'Media2', etc., when
  rewiting the URL to access a specific media number. By now only
  nanmes ending on 'CD' or 'DVD' were supported. (bnc#594850)
* Fri Apr 23 2010 ma@suse.de
- Update translations.
* Wed Apr 21 2010 ma@suse.de
- Update translations.
* Tue Apr 20 2010 ma@suse.de
- /etc/zypp/locks: Allow to specify edition ranges with
  solvable:name and dependencies.
- version 7.1.1 (1)
* Thu Apr 15 2010 ma@suse.de
- Provide name of the lock holder in ZYppFactoryException. (bnc#580513)
- version 7.1.0 (1)
* Wed Apr 14 2010 ma@suse.de
- Using boost-1.42 requires -fno-strict-aliasing (bnc#595545)
- Bump major version for 11.3 development.
- version 7.0.0 (0)
* Tue Apr 13 2010 ma@suse.de
- Fix parsing port from IPv6 URL (bnc#593385)
* Fri Mar 26 2010 ma@suse.de
- Propagate ZConfig::setTextLocale to pool. (bnc#588850)
- version 6.31.3 (31)
* Fri Mar 26 2010 ma@suse.de
- Fix guessing package spec to match package names only. (bnc#590864)
- version 6.31.2 (31)
* Tue Mar 23 2010 ma@suse.de
- Add static Target::distributionLabel to return the baseproducts
  shortName and summary. Mainlu used for the bootloader menu. (bnc #586303)
- version 6.31.1 (31)
* Thu Mar 18 2010 ma@suse.de
- Fix broken bit values in enum VendorSupportOption (bnc#589331)
- version 6.31.0 (31)
* Fri Mar 12 2010 ma@suse.de
- Fix handling of symlinked packages in package cache. (bnc #585409)
- version 6.30.5 (19)
* Tue Feb 23 2010 jkupec@suse.cz
- Avoiding use of 'guest' if 'credentials' is used when moutning
  a CIFS share. This caused 'permission denied' error with certain
  server configurations (bnc #560496).
* Tue Feb 23 2010 ma@suse.de
- Check if a downloaded file actually exists even if aria2c returned 0.
  (bnc #564816)
- version 6.30.3 (19)
* Mon Feb 22 2010 jkupec@suse.cz
- Made CURLE_PARTIAL_FILE an auto-retry error (bnc #471436)
* Mon Feb 22 2010 ma@suse.de
- Turn off cookies when retrieving services repoindex.xml (bnc #573897)
- Consider pending disable requests when removing service repositories. (bnc #572634)
- version 6.30.1 (19)
* Sun Feb 21 2010 jkupec@suse.cz
- RepoManager::cleanCacheDirGarbage added for removing directories
  which do not belong to any of known repos (bnc #467693)
- version 6.30.0 (19)
* Thu Feb 11 2010 ma@suse.de
- On SLE aria2 is not required, so conflict with a too old aria2
  version installed. (bnc #578052)
- version 6.29.5 (19)
* Wed Feb 10 2010 ma@suse.de
- Fix package-manager script wrongly escaping UTF-8 chars in path
  names (bnc #571410)
- version 6.29.4 (19)
* Mon Feb  8 2010 ma@suse.de
- Support an alternate SLE-SP1 translation set.
- version 6.29.3 (19)
* Wed Feb  3 2010 ma@suse.de
- Remember the enabled state of removed service repositories. This
  way we are able to restore service repositories correctly after a
  subscrition expired and gets renewed. (bnc #572634)
- version 6.29.2 (19)
* Thu Jan 28 2010 jkupec@suse.cz
- Abort aria2c download when the progress callback receives 'false'
  (bnc #545106)
* Tue Jan 19 2010 ma@suse.de
- Evaluate SolvAttr::repositoryToolVersion to prevent loading
  outdated solv files. (bnc #570623)
- version 6.29.0 (19)
* Fri Jan 15 2010 jkupec@suse.cz
- Use regex to parse aria2c progress lines (bnc #570917)
- version 6.28.1 (19)
* Thu Jan  7 2010 jkupec@suse.cz
- Set SignatureFileChecker context even if the key is not known
  (bnc #495977)
- version 6.28.0 (19)
* Thu Dec 10 2009 jkupec@suse.cz
- RepoInfoBase::label() added for use in UI messages, plus
  ZConfig::repoLabelIsAlias()
* Tue Dec  8 2009 ma@suse.de
- Fix transaction building in presence of multiversion installable items.
- version 6.27.1 (19)
* Fri Dec  4 2009 ma@suse.de
- Improve multiversion status handling and installation. (fate #305311)
- version 6.27.0 (19)
* Fri Dec  4 2009 jkupec@suse.cz
- Don't allow an alias to start with '.' (bnc #473834)
* Thu Dec  3 2009 ma@suse.de
- PickList and status interface for handling packages which are
  installable in multiple versions. (fate #305311)
- version 6.26.0 (19)
* Wed Dec  2 2009 ma@suse.de
- Add Selectable::highestAvailableVersionObj. Returns the highest
  available package version, ignoring priorities and policies. (bnc #557557)
- version 6.25.0 (19)
* Mon Nov 30 2009 ma@suse.de
- Also parse <product> tag from .prod files <upgrade> section.
- version 6.24.3 (19)
* Fri Nov 27 2009 ma@suse.de
- Fix chroot execution of update scripts. (bnc #558813)
- version 6.24.3 (19)
* Thu Nov 26 2009 jkupec@suse.cz
- Fixed parsing of download speed from aria2c (bnc #537870)
* Wed Nov 25 2009 ma@suse.de
- Add ui::Selecatble interface for picking specific package versions
  to install or delete if multiversion install is on.
- version 6.24.0 (19)
* Fri Nov 20 2009 ma@suse.de
- Parse zypp.conf multiversion option and make the setting available
  in pool and resolver.
- version 6.23.0 (19)
* Mon Nov 16 2009 ma@suse.de
- Specfile fixes to build on sle11-sp1.
- Fix repository probing and building in presence of productdir. (bnc #553712)
- version 6.22.3 (19)
* Thu Nov 12 2009 dmacvicar@suse.de
- Forward port and document already present changes
  from Code11-Branch
  * void SEGV if trying to access data of installed packages, that were
    deleted behind our back (bnc #530595)
  * ProxyInfoSysconfig: take care variables get initialized.
  * Fix parsing of rpm.install.excludedocs option (bnc #518883)
  * Use rpm variables in specfile. (bnc #512466)
  * Fix to compile with -Werror=format-security
  * Fix packageand() in testcase generation
  * Don't link unneeded libraries. (bnc #490895)
  * Fix Patch::categoryEnum.
  * Adapt to changed satsolver API. (bnc #480303)
  * Taking ALL translations for generating GMO files (bnc #458739)
  * Advice users to contact NCC if access to a 'novell.com'
    repository is denied (bnc #464586).
- version 6.22.2 (19)
* Thu Nov 12 2009 ma@suse.de
- Raised the limit of redirections from 3 to 6 (bnc #465532)
- Following redirections also for https (bnc #545722).
- Following https redirections requires at least libcurl4-7.19.4. (bnc #553895)
- Do not report cached packages as being downloaded. (bnc #545295)
- Per default do not collect and report deleted files outside bin and lib
  directories for 'zypper ps'. (bnc #554480)
- version 6.22.1 (19)
* Wed Nov 11 2009 ma@suse.de
- CheckAccessDeleted: Per default do not collect and report deleted files
  that outside bin and lib directories. 'zypper ps' reporting false positive
  seems to confuse. (bnc #554480)
* Wed Nov 11 2009 ma@suse.de
- Following https redirections requires at least libcurl4-7.19.4. (bnc #553895)
* Fri Nov  6 2009 ma@suse.de
- dup: Process drop list only if product actually changes. (bnc #552180)
- Selectable: Consider allowed arch/noarch changes when comuting candiadates.
- version 6.22.0 (19)
* Mon Nov  2 2009 ma@suse.de
- Enhance interface for zypper. (bnc #551956)
- version 6.21.4 (19)
* Mon Nov  2 2009 ma@suse.de
- CIFS/SMB: Support mountoption 'noguest' to prevent passing 'guest' option
  to mount. "cifs://server/share/path?mountoptions=noguest,ro" (bnc #547354)
- version 6.21.3 (19)
* Mon Nov  2 2009 ma@suse.de
- CheckAccessDeleted: Avoid reporting false positive due to insufficient
  permission.
* Mon Nov  2 2009 ma@suse.de
- Don't try to access droplist of dropped products. (bnc #551697)
- version 6.21.2 (19)
* Fri Oct 30 2009 ma@suse.de
- Don't try to use an empty proxy string. (bnc #551314)
- MediaSMB failed to pass the --workgroup option to mount. (bnc #547354)
- version 6.21.1 (19)
* Fri Oct 30 2009 ma@suse.de
- New class PoolItemBest: Find the best candidates e.g. in a PoolQuery
  result. ui::Selectabe enhancements. Both will aid applications to
  install package sets determined by query results. (bnc # 548392)
- Fix upgradeRepo solution to keep obsolete packages. (bnc #550915)
- Updated iso3166-1 country codes (bnc #531350)
- version 6.21.0 (19)
* Tue Oct 27 2009 ma@suse.de
- Add Resolver::upgradingRepo demanded by GUI. (bnc #548551)
- version 6.20.0 (19)
* Thu Oct 22 2009 ma@suse.de
- Fixes to make libzypp-bindings compile.
- version 6.19.3 (19)
* Tue Oct 20 2009 ma@suse.de
- Credentials are passed as commandline options to aria2c, so strip any
  'user@' from the URL. Otherwise aria will use an empty password for
  this URL and authentication will fail. (bnc #544634)
- version 6.19.2 (19)
* Mon Oct 19 2009 ma@suse.de
- Repository::setInfo: Propagate priority changes to the solver to
  avoid reloading the whole repo (bnc #498266).
- version 6.19.1 (19)
* Thu Oct 15 2009 ma@suse.de
- ResStatus: add isOrphaned to test whether a package is not provided
  by any enabled repository. Orphaned packages are usually good candidates
  for cleanup unless the providing repository was intentionally disabled.
- version 6.19.0 (19)
* Thu Oct 15 2009 dmacvicar@suse.de
- aria2: pass credentials in a file instead of the command line
  which is logged.
- aria2: we get the url in the progress if there is no response
  from the server yet, handle that to avoid flooding the log.
- version 6.18.2 (17)
* Thu Oct 15 2009 ma@suse.de
- Performing a dist upgrade the solver may try to delete old and no
  longer provided (dropped) packages, even if they do not cause any
  dependency problem. This behaviour may be trurned off via zypp.conf
  option solver.upgradeRemoveDropedPackages. (bnc #539543)
- New zypp.conf option solver.upgradeRemoveDropedPackages (true).
- Add Product::droplist: List of dropped packages, i.e. packages no
  longer provided by a product.
- version 6.18.1 (17)
* Wed Oct  7 2009 ma@suse.de
- Return update messages via ZYppCommitResult. Support variable
  substitution in notification command. (fate #301175)
- Fix evaluation of no_proxy entries (bnc #543337)
- aria/curl: Fix header data in case the target is
  not initialized when downloading.
- version 6.18.0 (17)
* Thu Sep 24 2009 ma@suse.de
- Add zypp.conf option update.messages.notify: Command to be invoked
  to send update messages. (fate #301175)
- version 6.17.2 (17)
* Tue Sep 22 2009 ma@suse.de
- Add Selectable::updateCandidateObj returning the candidate for
  update, if there is one. The updateCandidate must not violate
  any active solver policy.
- version 6.17.1 (17)
* Fri Sep 18 2009 ma@suse.de
- Make sure rpmReadConfigFiles was called before using librpm (bnc #539603).
- Remove dead rpm database caching code from class RpmDb.
- version 6.17.0 (17)
* Fri Sep 11 2009 ma@km13.de
- New commit.downloadMode option in zypp.conf. Allows to set a
  prefered download policy for commit.
- version 6.16.0 (11)
* Thu Sep 10 2009 ma@suse.de
- Support nfs4 (nfs4://... or nfs://...?type=nfs4) (fate #306451)
- Added Url::schemeIsLocal, schemeIsRemote, schemeIsVolatile and
  schemeIsDownloading.
- version 6.15.0 (11)
* Wed Sep  9 2009 ma@suse.de
- Add Capability::guessPackageSpec; parser also supporting "name-ver-rel.arch"
  formats for building Capabilities(originally "name.arch=ver-rel").
- version 6.14.3 (11)
* Mon Sep  7 2009 ma@suse.de
- Fix resolution to force installation even if dependencies are missing.
  (bnc #531564)
- Rephrase solver resolution to point out if a package will break.
  (bnc #520083)
* Fri Sep  4 2009 ma@suse.de
- Lock rpms architecture only on distupgrade of the running system.
  (bnc #458520)
- version 6.14.2 (11)
* Thu Sep  3 2009 ma@suse.de
- Fix PoolQuery comparison (bnc #528755)
- Fix serialization and restore of predicated PoolQueries.
- version 6.14.0 (11)
* Mon Aug 31 2009 ma@suse.de
- package-manager script: Fall back to package selection if no
  packages are passed on the commandline. (bnc #529137)
* Fri Aug 28 2009 dmacvicar@suse.de
- package-manager script:
  do not fail if kpackagekit is not installed (bnc #529510)
- version 6.13.3 (11)
* Wed Aug 26 2009 ma@suse.de
- Tune CheckAccessDeleted to focus on libraries and executables.
- version 6.13.2 (11)
* Thu Aug  6 2009 ma@suse.de
- Provide class CheckAccessDeleted and command zypp-CheckAccessDeleted
  to check for running processes which access meanwhile deleted files or
  libraries.  This may be used after commit, when trying to figure out
  which services need to be restated. (fate #300763).
- version 6.13.1 (11)
* Mon Aug  3 2009 ma@suse.de
- New Resolver::addUpgradeRepo to perform a dist upgrade restricted to
  certain repositories.
- version 6.13.0 (11)
* Fri Jul 31 2009 ma@suse.de
- Remove confusing newlines in vendor change info (bnc #503859)
- Removing a package lock was not counted as state change (bnc #501850)
- Take solver_allowVendorChange option into account when computing the
  Selectables default candidate.
- version 6.12.0 (11)
* Wed Jul 29 2009 ma@suse.de
- Avoid deadlock after fork and failed exec. (bnc 493152)
- No need to manually detect the location of aria2 binary.
- version 6.11.4 (11)
* Tue Jul 28 2009 jkupec@suse.cz
- Fixed parsing of download rate report (changed in aria2 1.4.0)
  (bnc #513944)
* Mon Jul 27 2009 ma@suse.de
- Create LogControl on demand instead of using a static var. (bnc #525339)
- version 6.11.2 (11)
* Thu Jul 23 2009 ma@km13.de
- New misc::defaultLoadSystem: Convenience to create the ZYpp instance
  and load target and enabled repositories.
* Wed Jul 22 2009 ma@suse.de
- New class InstanceId to build strings to identify/retrieve specific
  Solvables.
- version 6.11.1 (11)
* Mon Jul 20 2009 ma@km13.de
- Add download policies to ZYppCommitPolicy, supporting DownloadOnly
  and DownloadInAdvance. (fate #302159, fate #305624)
- version 6.11.0 (11)
* Thu Jul 16 2009 dmacvicar@suse.de
- add support to the package-manager script to use kpackagekit
  or gnome-packagekit if available, which allows to install local
  rpms with one click from file manager following desktop policies
  and fetching other dependencies if required.
  (fate #306526)
- version 6.10.5 (10)
* Thu Jul 16 2009 ma@suse.de
- New solver.upgradeTestcasesToKeep option in zypp.conf. It tells
  how many dist upgrade solver testcases should be kept on the system.
  Per default just the last two are kept.
- version 6.10.4 (10)
* Wed Jul 15 2009 ma@suse.de
- Don't write a solver testcase when solving for dist upgrade,
  but when actually committing.
- version 6.10.3 (10)
* Wed Jul 15 2009 ma@suse.de
- Add new string Match::Mode STRINGSTART and STRINGEND.
* Wed Jul 15 2009 jkupec@suse.cz
- log redirections when cURL media backend is used (fate #305320).
* Tue Jul 14 2009 ma@suse.de
- Support "product version" detection on systems not using
  /etc/product.d/baseproduct by looking for the first package
  providing ZConfig::distroverpkg (defaults to redhat-release).
- version 6.10.2 (10)
* Fri Jul 10 2009 ma@suse.de
- Adapt to boost_unit_test_framework-1.38.
- version 6.10.1 (10)
* Wed Jul  8 2009 ma@suse.de
- Remove obsolete UpgradeStatistics class from libzypp.
* Tue Jul  7 2009 ma@suse.de
- Fix HistoryLog to initialize on demand.
- version 6.10.0 (10)
* Fri Jul  3 2009 ma@suse.de
- Fix parsing of rpm.install.excludedocs option (bnc #518883)
* Fri Jul  3 2009 ma@suse.de
- When unmounting ISO images, don't mix up exceptions thrown by the
  loop mounted ISO and those thrown by the media containing it.
  (bnc #517856)
* Thu Jul  2 2009 ma@suse.de
- Adapt to satsolvers improved dataiterator handling.
- version 6.9.3 (8)
* Wed Jul  1 2009 ma@suse.de
- Support PoolQuery for sub-structures attributes. (fate #305503)
- version 6.9.2 (8)
* Wed Jul  1 2009 ma@suse.de
- Running as non-root user use a temporary @System solvfile in case the
  global one is outdated and needed refresh. (bnc #517183)
- version 6.9.1 (8)
* Tue Jun 30 2009 ma@suse.de
- Enhance LookupAttr to allow direct query of attributes within
  sub-structures (flexarrays).
* Fri Jun 26 2009 ma@suse.de
- Enhance PoolQueryIterator to allow detailed inspection of attribute
  matches.
- Prefer datadir stored as repo attribute, but fallback searching in
  solvbales (old solv files do this).
- version 6.9.0 (8)
* Tue Jun 23 2009 ma@suse.de
- Allow building libzypp with rpm-5 (experimental)
- version 6.8.3 (8)
* Wed Jun 17 2009 ma@suse.de
- Allow building libzypp without HAL (not recommended). Without HAL
  CD/DVD device detection is limited to /dev/dvd and /dev/cdrom.
- version 6.8.2 (8)
* Fri Jun  5 2009 ma@suse.de
- Fix solver to use IdSting to avoid failing vendor checks.
- version 6.8.1 (8)
* Thu Jun  4 2009 ma@suse.de
- Cleanup and remove deprecated interface methods.
- version 6.8.0 (8)
* Fri May 29 2009 ma@suse.de
- Improve PoolQuery to allow queries on dependencies. (bnc #475682)
- version 6.7.0 (6)
* Thu May 28 2009 ma@suse.de
- New solver.allowVendorChange expert option in zypp.conf.
- version 6.6.0 (6)
* Wed May 20 2009 ma@suse.de
- Fix lost housekeeping data in modifyRepo (bnc #503207)
* Fri May  8 2009 ma@suse.de
- Allow service refresh to change a repositories url (bnc #502157)
* Tue May  5 2009 ma@suse.de
- Detect and compile with rpm 4.7 (bnc #444211)
- version 6.5.2 (5)
* Mon May  4 2009 ma@suse.de
- Improve problem report on broken systemCheck rule (bnc #475144)
* Mon Apr 27 2009 ma@suse.de
- In update repos providing multiple release package versions for
  the same product, link a product to the latest version. (bnc #497696)
* Mon Apr 27 2009 ma@suse.de
- New classes wraping satsolver datamatcher (Match and sat::AttrMatcher)
- Extend LookupAttr to support matching specific string patterns.
- Rewrote PoolQuery::Iterator (adapt to AttrMatcher, fixes and speedup)
- version 6.5.0 (5)
* Thu Apr 16 2009 ma@suse.de
- Soft lock packages deleted on behalf of a user request.
- version 6.4.1 (2)
* Tue Mar 31 2009 ma@suse.de
- New zypp.conf option 'download.media_preference': Hint which media
  to prefer when installing packages (download vs. CD).
- version 6.4.0 (2)
* Thu Mar 12 2009 ma@suse.de
- Add Resolver::setSolveSrcPackages. Per default disable solving
  of source package dependencies. We will later allow enabling
  it per package.
- version 6.3.0 (2)
* Fri Mar  6 2009 dmacvicar@suse.de
- aria2: show the download speed in the right unit
- aria2: show the filename in progress, not the repository
- aria2: don't show done twice
* Thu Mar  5 2009 ma@suse.de
- Remove a lock if the locking process is in zombie state. (bnc #481577)
* Wed Mar  4 2009 jkupec@suse.cz
- zypp.conf: fixed and enabled 'servicesdir'
* Tue Mar  3 2009 dmacvicar@suse.de
- aria2: implement speed indicators (bnc#475506)
- aria2: implement progress indicators correctly (bnc#473846)
- aria2: fix broken pipe when looking for aria2c which caused
    a fallback to curl. (bnc#480930)
- aria2: implement saving and reading mirror stats data in
    /var/cache/zypp/aria2.stats
- aria2: handle failover correctly (bnc#481115)
- aria2: various improvements in error and report  handling
- aria2: curl: reset settings on attach to avoid duplicate
  headers
- version 6.2.1 (2)
* Tue Mar  3 2009 ma@suse.de
- Adapt to changed satsolver API.
* Fri Feb 27 2009 dmacvicar@suse.de
- Make sure Fetcher pass optional files as non-interactive
- Fixes file does not exist error when key/sig does not exist
- version 6.2.0 (2)
* Thu Feb 26 2009 ma@suse.de
- Use correct default for zconfig(solver.checkSystemFile) (bnc# 475144)
* Thu Feb 26 2009 ma@suse.de
- Prevent ResStatus from overriding user locks. (bnc #475230)
* Sun Feb 22 2009 ma@suse.de
- Never refresh repositories from CD/DVD, once they are created. (bnc #476429)
* Sat Feb 21 2009 dmacvicar@suse.de
  Implemented the following options with aria backend:
- download.max_concurrent_connections (default 2)
  download.min_download_speed (default no limit)
  download.max_download_speed (default no limit)
  download.max_silent_tries (default 5)
* Fri Feb 20 2009 dmacvicar@suse.de
- MediaAria2c: allow disabling aria2 using ZYPP_ARIA2C=0.
  Various improvements including file existence checking
  Disable HEAD request if aria2c >= 1.20
  Restrict max connections to 2 for now.
* Wed Feb 18 2009 ma@suse.de
- Neither lose packages with empty name, nor SEGV when processing them. (bnc #470011)
* Wed Feb 18 2009 ma@suse.de
- Compute obsoletes based on names only (not considering provides) (bnc #471023)
* Tue Feb 17 2009 jkupec@suse.cz
- Fixed FTP authentication (bnc #472879)
* Wed Feb 11 2009 ma@suse.de
- Follow IEC and use the binary prefixes (KiB,MiB,GiB) for printing Byte
  counts based on a power of 1024 (formerly just K,M,G). Byte counts based
  on a power of 1000 stay unaffected (kB,MB,GB).
* Mon Feb  9 2009 ma@suse.de
- Fix installation prompting for the wrong CD/DVD. (bnc #472892)
* Tue Feb  3 2009 ma@suse.de
- Send any output from rpm install/delete scripts via callback, so
  applications are able to display it. (bnc #369450)
* Mon Feb  2 2009 ma@suse.de
- Add missing translations (bnc #256289)
* Wed Jan 28 2009 jkupec@suse.cz
- HistoryLogReader added
* Tue Jan 27 2009 ma@suse.de
- Respect content-file DATDIR when downloading packages. (bnc #468612)
* Tue Jan 27 2009 jkupec@suse.cz
- Enabled CredentialManager for MediaSMB (bnc #460970).
- Ignore URL's username, password, and query string in AuthData
  comparator in CredentialManager.
* Mon Jan 26 2009 ma@suse.de
- Let vendor checks per default differ between 'openSUSE Build Service'
  and 'openSUSE' (bnc #467262).
* Fri Jan 23 2009 ma@suse.de
- Fix handling of plaindir repos on mounted devices (e.g. USB) (bnc #464778)
- Fix plaindir checksum computation not to to follow symlinks (bnc #464778)
* Thu Jan 22 2009 ma@suse.de
- Tell satsolver about product buddies (bnc #466565)
* Fri Jan  9 2009 jkupec@suse.cz
- handle HTTP 503 responses as temporary errors (bnc #462545)
* Thu Dec 18 2008 ma@suse.de
- Fixed lost user request to abort during commit. (bnc #388810, bnc #450273)
- revision 11954
- version 5.25.0 (23)
* Thu Dec 18 2008 ma@suse.de
- Add Package::filelist, faster and less memory consuming
  implementation of Package::filenames (now deprecated).
- revision 11949
* Thu Dec 11 2008 ma@suse.de
- Add str::hexencode and str::hexdecode to encode special characters
  in a string as %%XX.
- Hexdecode modalias strings in rpm dependencies because rpm does not
  allow comma, blank and other special chars. (bnc #456695)
- revision 11927
* Thu Dec 11 2008 ma@suse.de
- Catch and report media errors when proving packages. (bnc #457652)
- revision 11926
* Wed Dec 10 2008 ma@suse.de
- Remove obsolete zypp.conf::productsdir and deprecate
  ZConfig::productsPath().
- Monitor /etc/products.d to determine if @system.solv needs to be
  rebuilt. (bnc #457933)
- revision 11923
- version 5.24.7 (23)
* Mon Dec  8 2008 ma@suse.de
- Execute patch scripts chroot to the installed system. (bnc #456795)
- revision 11908
* Mon Dec  8 2008 schubi@suse.de
- Make the solver reset function public (bnc #439373)
- Revision 11904
* Sun Dec  7 2008 coolo@suse.de
- note for coolo: do not trust bash advisory from TPM colleagues
* Fri Dec  5 2008 ma@suse.de
- Fix solvers inappropriate selection as byUSER (bnc 455965)
- revision 11891
- version 5.24.6 (23)
* Thu Dec  4 2008 coolo@suse.de
- fix %%post script to not warn on fresh install
* Mon Dec  1 2008 ma@suse.de
- Fix install order computation losing some installed packages
  pre-requirements. (bnc #439802)
- revision 11845
- version 5.24.5 (23)
* Fri Nov 28 2008 ma@suse.de
- Prune soft locks to prevent installation but not update of
  already installed packages.
- revision 11829
- version 5.24.4 (23)
* Fri Nov 28 2008 schubi@suse.de
- Taking solutions which based on user requirements/conflict
  "by User" solutions (bnc #442718)
- revision 11825
* Fri Nov 28 2008 ma@suse.de
- Take into account the requirements of all obsoleted packages uninstall
  scripts when computing the installation order. (bnc #439802)
- revision 11823
- version 5.24.3 (23)
* Thu Nov 27 2008 dmacvicar@suse.de
- fix maybeUnsuported() method returning wrong result
- add testcase for future coverage
- don't force time based uuid for anonymous id string (bnc #449654)
- RELEASE: 5.24.2 (23)
* Wed Nov 26 2008 ma@suse.de
- Call 'repo2solv -R' (recursive scan) for plaindir repos. (bnc #443350)
- revision 11810
* Wed Nov 26 2008 dmacvicar@suse.de
- SHA1SUMS.key is not imported by zypp as known key (bnc #446188)
- path and url in add_on_products.xml is evaluated wrong
  (bnc #446170)
* Mon Nov 24 2008 schubi@suse.de
- activate locking for doUpdate (bnc #447684)
- revision 11792
- RELEASE: 5.24.1 (23)
* Fri Nov 21 2008 dmacvicar@suse.de
- remove unused updaterepokey, replaced by repo
  product information
* Fri Nov 21 2008 jkupec@suse.cz
- fixed uninitialized value in OnMediaLocation (bnc #447010)
- revision 11770
* Fri Nov 21 2008 ma@suse.de
- Fix retrieval of deltarpm info.
- revision 11764
- version 5.24.0 (23)
* Thu Nov 20 2008 ma@suse.de
- Fix retrieval of Repository attributes like timestamps, keywords
  and product info.
- revision 11760
* Thu Nov 20 2008 ma@suse.de
- Enhance class LookupAttr and add convenience class LookupRepoAttr to
  iterate those solv file attributes which are not acssociated with a
  solvable. E.g. product or deltarpm info.
- revision 11754
* Wed Nov 19 2008 jkupec@suse.cz
- encode user-supplied URL strings before using them in the Url object
  (bnc #446395, bnc #444267)
- revision 11720
* Wed Nov 19 2008 ma@suse.de
- Support loading helix files.
- revision 11719
* Tue Nov 18 2008 ma@suse.de
- Add class filesystem::Glob to find pathnames matching a pattern
  by using ::glob.
- revision 11708
* Thu Nov 13 2008 schubi@suse.de
- Taking care for ppc64 while distupgrade (bnc #443685)
- revision 11670
* Wed Nov 12 2008 ma@suse.de
- Add Capability ctor from Arch and Name: (Arch_i386, "name") or
  (Arch_i386, "name == 1.0").
- revision 11669
* Wed Nov 12 2008 ma@suse.de
- Take care to always reset CURLOPT_TIMECONDITION to prevent incomplete
  downloads. (bnc #444109)
- revision 11656
- version 5.23.0 (23)
* Wed Nov 12 2008 ma@suse.de
- Check for modaliases below /sys (bnc #430179)
- revision 11653
* Tue Nov 11 2008 ma@suse.de
- Avoid superfluous file copying and gpg invocation in keyring handling.
- revision 11650
* Tue Nov 11 2008 ma@suse.de
- Prevent fetcher from processing the same index file twice. (bnc #443644)
- revision 11648
- version 5.22.0 (21)
* Sat Nov  8 2008 ma@suse.de
- Fix retrieval of patch contents and references attributes. (bnc #442200)
- revision 11641
- version 5.21.0 (21)
* Fri Nov  7 2008 ma@suse.de
- Add CheckSum::asString.
- revision 11634
* Fri Nov  7 2008 ma@suse.de
- revision 11631
- version 5.20.0 (20)
* Thu Nov  6 2008 dmacvicar@suse.de
- re-add the flavor to the http header now using a flavor
  cache that is updated on every target load.
  Target::dstributionFlavor provides access to this cache
  in case you need the last used flavor without loading
  the target.
* Thu Nov  6 2008 schubi@suse.de
- added flag: ignorealreadyrecommended to the testcases (bnc #432136)
- revsion 11539
* Thu Nov  6 2008 schubi@suse.de
- Adding rule rpm-arch for installed rpm package in order to avoid
  unneeded architecture change. (bnc #441004)
- revision 11585
* Tue Nov  4 2008 jkupec@suse.cz
- handle MediaTimeoutException also in MediaSetAccess::provideFile()
  (bnc #439983)
- revision 11568
* Mon Nov  3 2008 dmacvicar@suse.de
- merge contributions by Jon Nelson, the patches resolve
  the following issues:
- disable the "Pragma: nocache" header which is automatically
  used by curl.
  re-enables the use of a caching http proxy (like squid or others)
  and corrects (bnc #326208)
- don't generate an If-Modified-Since header if we don't have a
  previous file to work with
- don't generate a Proxy-Authenticate header if one is not called
  for.
* Fri Oct 31 2008 ma@suse.de
- Do not save solver locks (by APPL_HIGH).
- revision 11558
* Fri Oct 31 2008 dmacvicar@suse.de
- fetcher.setOptions( Fetcher::AutoAddIndexes ) allows
  for automatic signed index discovery.
- enqueueDir with checksum checking s now enqueueDigestedDir
* Thu Oct 30 2008 schubi@suse.de
- solutions: keep/lock will be done by APPL_HIGH. So they will not be
  saved in the lockfiles
- "keep obsolete" will be handled with lock by APPL_HIGH (bnc #439134)
- revision  11549
* Wed Oct 29 2008 jkupec@suse.cz
- throw a MediaTimeoutException also on http 504 (gateway timeout)
  (bnc #425035)
- revision 11535
* Wed Oct 29 2008 ma@suse.de
- Add 'sh4' architectures.
- revision 11534
* Tue Oct 28 2008 dmacvicar@suse.de
- don't free the header before curl_perform as curl does not
  copy it. (bnc#439532)
* Tue Oct 28 2008 ma@suse.de
- Add 'arm' architectures.
- revision 11525
* Tue Oct 28 2008 schubi@suse.de
- regarding "keep obsolete" in the solutions (bnc #439134)
- revision 11517
* Mon Oct 27 2008 dmacvicar@suse.de
- fix broken aria2c command line (bnc#438971)
* Sun Oct 26 2008 coolo@suse.de
- adding svn r11488 to fix compile of PackageKit
* Fri Oct 24 2008 ma@suse.de
- Remove error prone methods from OnMediaLocation API to prevent
  accidental missuse. (bnc #437328)
- revision 11487
- version 5.19.0 (19)
* Fri Oct 24 2008 ma@suse.de
- Provide the /etc/products.d enties filename as Product::referenceFilename.
  Use it to remove orphan products. (bnc #432932)
- Fix media exception handling in commit (bnc #395704)
- revision 11485
- version 5.18.0 (17)
* Fri Oct 24 2008 schubi@suse.de
- Taking "unlock" instead of setTransact(false) in the solutions (bnc #436923)
- revision 11468
- version 5.17.0 (17)
* Wed Oct 22 2008 ma@suse.de
- For retrieving a product license fall back to license.tar.gz. (bnc #372386)
- revision 11447
* Wed Oct 22 2008 dmacvicar@suse.de
- move anonymous unique id to a private http header
  X-ZYpp-AnonymousUniqueId (bnc#431571 )
* Wed Oct 22 2008 ma@suse.de
- Adapt to satsolver-0.12 API.
- Add Locale:: bestMatch to find the best match within a set of
  available Locales.
- revision 11441
* Mon Oct 20 2008 ma@suse.de
- RepoInfo: Add methods to handle repository licenses. (bnc #372386)
- revision 11419
* Mon Oct 20 2008 ma@suse.de
- Adapt to changed satsolver dataiterator API.
- revision 11418
* Fri Oct 17 2008 ma@suse.de
- Secure download of license file on repo refresh (bnc #372386)
- revision 11398
* Fri Oct 17 2008 ma@suse.de
- Call 'repo2solv.sh -o' instead of using output redirection. (bnc #420046)
- revision 11397
* Thu Oct 16 2008 jkupec@suse.cz
- repository license methods added to RepoManager (bnc #372386)
- revision 11377
* Thu Oct 16 2008 dmacvicar@suse.de
- don't take into account stat information when looking
  for remote SHA1SUMS (part of bnc#409927)
* Wed Oct 15 2008 jkupec@suse.cz
- MediaSetAccess::provideOptionalFile() added
- revision 11369
* Wed Oct 15 2008 jkupec@suse.cz
- version 5.16.1 (16)
* Tue Oct 14 2008 jkupec@suse.cz
- don't initialize servicesTargetDistro via global ZYpp instance in
  RepoManagerOptions() constructor (bnc #435184)
- revision 11342
* Mon Oct 13 2008 jkupec@suse.cz
- repository probing: check for other types of repo even on
  MediaException, throw only if all fail (bnc #335906)
- revision 11332
* Mon Oct 13 2008 ma@suse.de
- Adapt to satsolver changes.
- revision 11331
- version 5.16.0 (16)
* Mon Oct 13 2008 ma@suse.de
- Fix reading delta rpm checksum from solv file.
- revision 11313
* Mon Oct 13 2008 ma@suse.de
- Fix package-manager script to properly quote arguments. (bnc #30903)
- revision 11311
* Mon Oct 13 2008 schubi@suse.de
- regarding orphaned resolvables
- removed old distupgrade algorithm
- revision 11307
* Sun Oct 12 2008 jkupec@suse.cz
- handle ftp response 530 (login failed) like http 403
  (bnc #433537)
- revision 11305
* Thu Oct  9 2008 ma@suse.de
- Adapt to satsolvers 'big solv data change'.
- revision 11294
* Thu Oct  9 2008 schubi@suse.de
- Taking the right solution actions for locked resolvables (bnc #400840)
- revision 11289
* Thu Oct  9 2008 ma@suse.de
- Add required copy-ctor and assignment operator to WhatProvides.
  (bnc #433087)
- revision 11276
* Wed Oct  8 2008 jkupec@suse.cz
- detect and use unused loop device for mounting ISO images
  (bnc #428009)
- revision 11262
- version 5.15.1 (13)
* Wed Oct  8 2008 jkupec@suse.cz
- fixed segfault when saving the probed repo type in
  RepoManager::refreshMetadata() (bnc #431963)
- revision 11261
* Wed Oct  8 2008 dmacvicar@suse.de
- improve log message (bnc#429114)
* Wed Oct  8 2008 lslezak@suse.cz
- disk usage - ignore /proc filesystem (bnc#418783)
- revision 11258
* Tue Oct  7 2008 ma@suse.de
- Fixed detection of loopback mounted iso-files. The mtab entry does
  not necessarily mention the iso-file. (bnc #432504)
- revision 11252
- version 5.15.0 (13)
* Thu Oct  2 2008 ma@suse.de
- Add zypp.conf option 'download.use_deltarpmr.always' to enable using
  delta rpms even if the package is available on a local source.
  (Axel C. Frinke)
- revision 11235
- version 5.14.0 (13)
* Thu Oct  2 2008 ma@suse.de
- Add product attribute: PRODUCTLINE.
- revision 11234
* Thu Oct  2 2008 ma@suse.de
- Do not consider self provided requirements whan computing the
  installation order.
- revision 11231
* Wed Oct  1 2008 ma@suse.de
- Rephrase missleading error message. (bnc #431229)
- revision 11222
* Tue Sep 30 2008 ma@suse.de
- Allow computation of disk usage per solvable.
- revision 11218
* Mon Sep 29 2008 dmacvicar@suse.de
- Merge aria2c Media handler code from Google SOC 2008
  (Gerard Farras)
- Only activated by making env var ZYPP_ARIA=1
* Mon Sep 29 2008 jkupec@suse.cz
- history: tell which package failed before logging rpm output or
  error message (bnc #430585)
- no localization for history log comments
- revision 11202
* Mon Sep 29 2008 ma@suse.de
- Fix zypp::WhatProvides::empty returning inverse result.
- revision 11200
- version 5.13.1 (13)
* Sat Sep 27 2008 jkupec@suse.cz
- fixed endless loop when CredentialManager returns bad password
- CredentialManager now correctly updates password of existing
  credentials
- revision 11187
* Fri Sep 26 2008 ma@suse.de
- Fix computation of Product::flavor.
- Add Product::productLine. A vendor specific string denoting the
  product line.
- revision 11182
- version 5.13.0 (13)
* Fri Sep 26 2008 jkupec@suse.cz
- save user credentials after asking for them
- revision 11181
* Thu Sep 25 2008 jkupec@suse.cz
- ZConfig::credentialsGlobal{File,Dir}() added
  (/etc/zypp/credentials.{cat,d})
- revision 11176
* Thu Sep 25 2008 jkupec@suse.cz
- Target::setInstallationLogfile() removed from zypp/Target.h
- revision 11171
* Thu Sep 25 2008 ma@suse.de
- Remove obsolete zypp-query-pool binary. zypper provides all
  the information one needs.
- revision 11160
* Wed Sep 24 2008 jkupec@suse.cz
- HistoryLog added and used to log package installs/removes and
  repository adds, removes, url and alias changes into
  history.logfile (/var/log/zypp/history) (fate #110205)
- str::escape(string, char) added
- revision 11150
- version 5.12.1 (12)
* Tue Sep 23 2008 jkupec@suse.cz
- CredentialManager: look for credentials with
  wanted_url.startsWith(stored_url)
- RepoManager: don't pass service credentials down to repos if
  their urls are not based on service's url.
- revision 11134
* Mon Sep 22 2008 ma@suse.de
- Remove superfluous PRODUCT_REFERENCES attribute.
- revision 11127
* Mon Sep 22 2008 ma@suse.de
- Add Url::hasCredentialsInAuthority test for username or password
  being encoded in the authority component. I.e. user:pass@host.
- Handle repos to be disabled disable in service refresh.
- revision 11126
* Mon Sep 22 2008 jkupec@suse.cz
- provided context to keyring callbacks (bnc #370223)
- merged trust & import callbacks (bnc #366467)
  (don't worry, still allows to trust && !import)
- revision 11113
* Fri Sep 19 2008 ma@suse.de
- Moved DefaultAcceptBits enum to class KeyRing (formerly KeyRingReort).
- revision 11102
* Thu Sep 18 2008 ma@suse.de
- Use service alias as namespace for it's repositories aliases.
- revision 11097
- version 5.11.0 (11)
* Thu Sep 18 2008 jkupec@suse.cz
- pass service's credentials down to repos
- support ?credentials=filepath in URL to specify credentials
- revision 11092
* Thu Sep 18 2008 ma@suse.de
- Add Product::isTargetDistribution to identify the systems installed
  baseproduct. This should replace tests for Product::type is "base".
- revision 11089
* Wed Sep 17 2008 jkupec@suse.cz
- save user credentials when adding repos/services with URLs containing
  the credentials (bnc #425462)
- revision 11085
* Wed Sep 17 2008 ma@suse.de
- Adapt to rpms new way of quoting whitespace in pathnames.(bnc #426924)
- revision 11082
* Tue Sep 16 2008 ma@suse.de
- Service handling fixes. Added ServiceException.
- revision 11077
* Mon Sep 15 2008 ma@suse.de
- Fix building of transaltions.
- revision 11064
* Sun Sep 14 2008 jkupec@suse.cz
- ServiceInfo.clearReposTo{Enable,Disable}() methods added
- revision 11060
* Fri Sep 12 2008 ma@suse.de
- Create new Service repos in disbaled sate.
- revision 11056
- version 5.10.0 (10)
* Fri Sep 12 2008 ma@suse.de
- Make registerTarget and registerRelease abvailable for installed
  product. Required for registration.
- revision 11043
* Fri Sep 12 2008 ma@suse.de
- Add url lists query to Product interface. A generic query and
  convenience methods to query urls for "releasenotes", "register",
  "updateurls", "extraurls",  "optionalurls" and "smolt" (bnc #413444)
- revision 11029
* Fri Sep 12 2008 jkupec@suse.cz
- ServiceType and ServiceInfo::type() added (contains only RIS for
  now), service type probing added.
- Avoiding the use of 'path' for services (appending
  the repoindex.xml's 'path' to the baseurl of created repos)
- renamed ServiceInfo::*catalog*() methods to *repo*() methods
- revision 11022
* Thu Sep 11 2008 dmacvicar@suse.de
- add Repostiroy::updateKeys and
  Repository::providesUpdatesForKey(string) for repo and
  product matching
- Provide Repository::isUpdateRepo
* Thu Sep 11 2008 ma@suse.de
- Fix evaluation of vendor support flags.
- Adapt retrieval of registration data (targetDistribution,
  targetDistributionRelease and targetDistributionFlavor).
- revision 11013
* Wed Sep 10 2008 ma@suse.de
- Follow gpgcheck tag in .repo file and do no check if disabled.
- revision 11010
- version 5.9.0 (8)
* Wed Sep 10 2008 jkupec@suse.cz
- added dumpAsXMLOn(stream,string) to ServiceInfo to print services
  with content (repos)
- revision 11004
* Wed Sep 10 2008 ma@suse.de
- Remove obsolete product attributes.
- Store less packages in /var/lib/zypp/SoftLocks (bnc #418050)
- revision 11001
* Wed Sep 10 2008 ma@suse.de
- Provide product::updaterepoKey: Update repository indicator string.
- revision 11000
* Tue Sep  9 2008 dmacvicar@suse.de
- provide context about the repository (name/alias) if available when
  checking signatures (bnc#370223)
- 5.8.0
* Tue Sep  9 2008 ma@suse.de
- Add ServiceInfo interface to define a set of catalogs (repository
  aliases) to be enabled on next refresh.
- revision 10970
* Tue Sep  9 2008 ma@suse.de
- Fix reading of Traget::targetDistribution.
- Allow to configure default answers in signature verification workflow.
- revision 10968
* Mon Sep  8 2008 jkupec@suse.cz
- CredentialManager added to manage stored credentials
- MediaCurl adapted to use CredentialManager to read credentials
- revision 10958
* Fri Sep  5 2008 jkupec@suse.cz
- operator ==, !=, < definition moved to RepoInfoBase from
  the derived classes
- fixed RepoInfo::dumpAsIniOn() to not print 'type' if it is unknown
  (bnc #407515)
- {Repo,Service}Info::dumpAsXMLOn(ostream) added
- RepoInfo::dumpRepoOn() deprecated in favor of dumpAsIniOn()
- use shared_ptr instead of itrusive for {Repo,Service}Info
- revision 10931:10942
* Thu Sep  4 2008 jkupec@suse.cz
- RepoInfo{,Base} setters made void
- revision 10931
* Wed Sep  3 2008 jkupec@suse.cz
- skip repositories with non-matching target distro when reading
  repoindex
- revision 10926
* Tue Sep  2 2008 schubi@suse.de
- Enabled distupgrade of the SAT solver. In order to use the old
  distupgrade you can set the environment variable ZYPP_NO_SAT_UPDATE.
  This variable will can be used until the old distupgrade mechanism will
  be removed from libzypp. Have a look to above changelogs.
- revision 10911
- version 5.7.0 (5)
* Tue Aug 19 2008 dmacvicar@suse.de
- add Package::maybeUnsupported to remove duplicated
  code in clients dealing with Package::vendorSupport
* Tue Aug 19 2008 schubi@suse.de
- Reset transaction only if this solvable has no buddy (bnc #417799)
  e.g. do not reset Products cause the concerning release package
  could not already be installed.
- revision 10883
- version 5.6.1 (5)
* Mon Aug 18 2008 dmacvicar@suse.de
- don't report "may be outdated" for @System repo.
* Fri Aug 15 2008 ma@suse.de
- Add Target::targetDistribution. Returns "distribution-arch" of
  the installed base product. Used for registration and Service
  refresh. (for Fate #304915)
- revision 10877
- version 5.6.0 (5)
* Fri Aug 15 2008 ma@suse.de
- Add method Product::replacedProducts to identify installed
  Products that would be replaced by installing a new Product.
  (for Fate #301997)
- revision 10876
* Fri Aug 15 2008 ma@suse.de
- Fixes to Selectable doing staus manipulation on non-USER level.
- revision 10873
* Fri Aug 15 2008 ma@suse.de
- Add method ZYpp::getTarget that returns the Target or a NULL pointer,
  if it is not yet initialized. This is to avoid try/catch blocks just
  to test whether the Target is initialized. (bnc #417556)
- Add method Target::assertRootPrefix. Pass a pathname and get back the
  path prefixed with the tragets root, unless it already had that prefix.
- revision 10870
* Thu Aug 14 2008 schubi@suse.de
- Regarding error messages for Products correctly (FATE #304502)
- rev 10863
* Thu Aug 14 2008 ma@suse.de
- Let Selectable default to USER level.
- revision 10850
- version 5.5.1 (5)
* Wed Aug 13 2008 ma@suse.de
- Change Selectable API to support doing staus manipulation on
  non-USER level.
- revision 10847
- version 5.5.0 (5)
* Wed Aug 13 2008 dmacvicar@suse.de
- support sat solver API for searching files
* Wed Aug 13 2008 ma@suse.de
- Add ResPool::reposFind to get repositories by alias.
- revision 10835
* Tue Aug 12 2008 ma@suse.de
- Advise rpmdb2solv to parse the product database.
- revision 10824
- version 5.4.0 (4)
* Tue Aug 12 2008 ma@suse.de
- Offer a simpler, fate based status manipulation in ui::Selectable.
  This is easier to handle, as the ui::Status always distinguishes
  wheter an object is installed or not.
- revision 10814
* Mon Aug 11 2008 ma@suse.de
- Propagate default rpm install flags from zypp.conf via ZConfig and
  ZYppCommitPolicy down to the installer. (FATE #302952)
- revision 10813
* Mon Aug 11 2008 ma@suse.de
- Add base::Flags (like qt's QFlags) a type-safe way of storing
  OR-combinations of enum values.
- revision 10811
* Fri Aug  8 2008 ma@suse.de
- Add static ui::Selectable::get methods as convenient ctor
  substitute.
- revision 10806
* Fri Aug  8 2008 ma@suse.de
- Adapt zypp-query-pool to new product handling.
- revision 10803
* Fri Aug  8 2008 ma@suse.de
- Don't pass epoch to 'rpm -e', it does not support it.
- revision 10800
* Fri Aug  8 2008 ma@suse.de
- Adapt to new product handling. Products are no longer pseudo
  installed objects verified by the solver, but actually installed.
  Thus removed satisfiedProduct iterator, fixed Selctables.
- Removed class ProductInfo as we keep Product.
- revision 10797
* Thu Aug  7 2008 dmacvicar@suse.de
- implement relogin suggested support (fate#304889)
* Wed Aug  6 2008 ma@suse.de
- Detect correct download path even if repository type
  is not set. (bnc #386386)
- revision 10768
* Wed Aug  6 2008 ma@suse.de
- Cleanup, mostly by removing, unused parser code and related classes.
- revision 10765
* Wed Aug  6 2008 ma@suse.de
- Don't let exception escape MediaSetAccess dtor (bnc #415017)
- revision 10763
* Mon Aug  4 2008 ma@suse.de
- Add new product attributes (flavor,referencePackage).
- Add PoolItem buddies, i.e. two PoolItems sharing the same status
  object. This is used to keep the product resolvable and the
  package providing the product metadata in sync.
- revision 10742
* Sat Aug  2 2008 jkupec@suse.cz
- support an optional url attribute in repoindex.xml's <repo>
- revision 10729
* Thu Jul 31 2008 ma@suse.de
- New class ProductInfo to provide product related metadata that
  might be associated with a package. This will replace the Product
  resolvable.
- revision 10715
* Thu Jul 31 2008 dmacvicar@suse.de
- generate a unique anonymous unique string per target
  and add it to the agent string for better statistics
* Thu Jul 31 2008 ma@suse.de
- Follow solver policy and make repository priority the highest
  key, when ordering packages. Then architecture, and edition last.
- revision 10710
* Wed Jul 30 2008 ma@suse.de
- /var/lib/zypp and /var/cache/zypp should be owned by libzypp
  (bnc #412094)
- revision 10702
* Wed Jul 30 2008 jkupec@suse.cz
- Service renamed to ServiceInfo
- RepoInfoBase added; RepoInfo and ServiceInfo now derive from it
- revision 10695
* Tue Jul 29 2008 jkupec@suse.cz
- fixed yum repos to work with non '/' base url post fix
  (bnc #341617)
- revision 10662
* Mon Jul 28 2008 ma@suse.de
- Fixed SolvIterMixin::Selectable_iterator eating some solvables
  (bnc #411339)
- revision 10680
* Fri Jul 25 2008 ma@suse.de
- Several changes to make libzypp-bindings compile using the original
  header files and no private copies. (bnc #391831)
- revision 10668
- version 5.3.0
* Wed Jul 23 2008 jkupec@suse.cz
- Service::enabled() added
- revision 10657
* Tue Jul 22 2008 jkupec@suse.cz
- Removed FRESHENS dependency type
- revision 10643
* Thu Jul 17 2008 schubi@suse.de
- Allow parallel installation of packages which have been defined
  in zypp.conf (parameter "multiversion") Fate #302050
- Additional check for broken system.
  (defined in zypp.conv: solver.checkSystemFile)
- revision 10600
* Wed Jul 16 2008 ma@suse.de
- Add ui::Selectable::isNeeded to indicate patch relevance (bnc #409150)
- revision 10596
* Wed Jul 16 2008 ma@suse.de
- Remove Atom, Script, Message and other obsolete classes.
- revision 10592
* Mon Jul 14 2008 ma@suse.de
- Also report the name of the locking process in ZYppFactoryException
  (bnc #280537)
- revision 10572
* Mon Jul 14 2008 schubi@suse.de
- corrected logging of solver settings
- regard locking while doUpdate (bnc #405427)
- revision 10564
* Sat Jul 12 2008 jkupec@suse.cz
- make curl use the right transfer mode
  (CURLOPT_PROXY_TRANSFER_MODE) when proxy is used (bnc #306272)
- revision 10559
* Sat Jul 12 2008 jkupec@suse.cz
- reuse existing disk mounts (applied Marius' patch) (bnc #208222)
- revision 10557
* Wed Jul  9 2008 ma@suse.de
- Provide Package::url() if available in solv file. (bnc #402434)
- A missing cookie file must not be treated as an error. Simply
  rebuild the cache (bnc #405867)
- Add 22x22 and 24x24 icons (bnc #329635)
- revision 10528
* Mon Jul  7 2008 schubi@suse.de
- Do not update an already updated package (bnc #400422)
- revision 10504
* Fri Jul  4 2008 ma@suse.de
- Also check if the fingerprint matches before importing updated keys.
  (bnc #393160)
- revision 10500
* Mon Jun 30 2008 dmacvicar@suse.de
- forward port add message attribute to patches.
- port import newer keys if a trusted key is updated
- (bnc#393160)
- version 5.0.2
* Mon Jun 30 2008 ma@suse.de
- Fix permanent duplication of gpg keys in the rpm database. Also
  retrieve correct creation and expire dates. (bnc #401259)
- Invoke gpg with --homdir, otherwise command fails if executed
  within a wrapper. (bnc #401259)
- revision 10487
* Thu Jun 26 2008 schubi@suse.de
- version 5.0.1
- revision 10464
* Thu Jun 19 2008 ma@suse.de
- Handle new patch messages and scripts in commit. Provide callbacks
  to display the patch messages and give visual feedback on script
  execution. (bnc #401220)
- revision 10411
* Thu Jun 19 2008 ma@suse.de
- Fix wrong parenthesis causing bug 399320
- version
- revision
* Tue Jun 10 2008 jreidinger@suse.cz
- improve performance of gsub
- change replace_all to replaceAll (same name convency)
- add tests for gsub and replaceAll
- revision 10366
* Fri Jun  6 2008 ma@suse.de
- Handle application/x-redhat-package-manager in package-manager.desktop
  (bnc #391183)
- revision 10361
* Thu Jun  5 2008 jkupec@suse.cz
- X-SuSE-ControlCenter-System category added
  to package-manager.desktop (bnc #302324)
- revision 10353
* Wed Jun  4 2008 ma@suse.de
- Fix crash when requesting disk usage without a target loaded. (bnc #396755)
- revision 10340
* Wed Jun  4 2008 ma@suse.de
- Fix memory corruption in curl media handler (bnc #396979)
- revision 10338
* Tue Jun  3 2008 ma@suse.de
- Take care satsolver recognizes 'Capability( "srcpackage:zypper" )'
  as 'source package named zypper'. So these capabilities can be used
  together with sat::Whatprovides or in resolver requests. (bnc #369893)
- revision 10335
* Tue Jun  3 2008 jreidinger@suse.cz
- allow aborting progress during removing packages. (bnc #389238)
- revision 10331
* Mon Jun  2 2008 schubi@suse.de
- New option for ignoring Obsoletes. This is used for installing more than
  one pacakges with the same name but different versions.
  Often used by kernel.
- r 10299
* Sun Jun  1 2008 - ma@suse.de
- Revert inappropriate Selectable cleanup. Fix Selectable
  status computation. Unmaintained packages were wrongly
  reported as unsinstalled. (bnc #394630)
- version 5.0.0 (4.x continued in SuSE-Linux-11_0-Branch)
- revision 10295
* Fri May 30 2008 tgoettlicher@suse.de
- fixed typo
* Wed May 28 2008 ma@suse.de
- Reenable diskusage calculation (bnc #395051)
- version 4.25.1
- revision 10273
* Wed May 28 2008 jkupec@suse.cz
- RepoManager::packagesPath(RepoInfo) added (bnc #394728)
- revision 10271
* Wed May 28 2008 jkupec@suse.cz
- RepoInfo: don't overwrite flags that have already been set externally
  (bnc #394728)
- revision 10256
* Wed May 28 2008 ma@suse.de
- Create missing directories when saving config files. (bnc #395026)
- Fix undefined behaviour in RepoManager.
- revision 10255
* Wed May 28 2008 schubi@suse.de
- SOLVER_ERASE_SOLVABLE_NAME: As we do not know, if this request has come
  from resolvePool or resolveQueue we will have to take care for both
  cases. (bnc#393969)
- r 10252
* Tue May 27 2008 coolo@suse.de
- compile with RPM_OPT_FLAGS
* Mon May 26 2008 jkupec@suse.cz
- old2new locks file converter script added to %%post (jredinger)
- r 10227
* Mon May 26 2008 schubi@suse.de
- Do not regard packages with the same name while upgrading obsoleted
  packages (bnc#394367)
- r 10219
* Sat May 24 2008 dmacvicar@suse.de
- revert commit don't check for existence of keys,
  to avoid a non needed HEAD request. (related bnc#381280)
  as it creates popup error callbacks due to the 404's in
  the keys. Leave however the OnMediaLocation::optional()
  API to look for another fix strategy.
* Fri May 23 2008 dmacvicar@suse.de
- define path for messages and scripts and document
  them in zypp.conf
* Fri May 23 2008 schubi@suse.de
- Added IgnoreAlreadyRecommended flag. So recomments/suggest will
  be ignored for already INSTALLED packages (bnc #389694)
- r 10202
* Fri May 23 2008 schubi@suse.de
- Packages which obsoletes and do NOT required other installed
  packages will be installed if no other packages obsolete the installed package too.
- r 10196
* Thu May 22 2008 dmacvicar@suse.de
- fix filelist for installed packages (bnc#392544)
- fix changelog retrieval for installed packages
* Wed May 21 2008 dmacvicar@suse.de
- deprecate Repository::name() and use alias() to
  be consistent. Related to (bnc#383553)
- don't check for existence of keys, to avoid a non needed
  HEAD request. (helps bnc#381280)
- 4.25.0
* Wed May 21 2008 schubi@suse.de
- added onlyRequires in the testcase (bnc #389184)
* Tue May 20 2008 jreidinger@suse.cz
- allow installation and refreshing from repository with alias that
  contains ' or " (bnc #392426)
- r10158
* Mon May 19 2008 jkupec@suse.cz
- delta rpm support reenabled
- r10150
* Mon May 19 2008 schubi@suse.de
- Resetting Delete Details in ResStatus correctly (bnc #391785)
- r 10145
* Mon May 19 2008 dmacvicar@suse.de
- when setting status to non installed for uninstalled packages
  set the user transaction so they go to soft locks.
  (related to bnc#389739 )
* Fri May 16 2008 schubi@suse.de
- Added new calls : isInstalledBy (const PoolItem item);
    installs (const PoolItem item);
- r 10125
- 4.23.0
* Fri May 16 2008 jreidinger@suse.cz
- don't run merge in save when toAdd/Remove queue is empty
- throw when locks cannot load its file
- r10124
* Fri May 16 2008 jreidinger@suse.cz
- throw more describing exception when repo probing failed
  (bnc #389690)
- revision 10118
* Thu May 15 2008 jreidinger@suse.cz
- allow call only merge old locks and newly added/removed without
  saving it to file
- -revision 10104
* Tue May 13 2008 dmacvicar@suse.de
- report non packages as keep installed if satisfied to the
  user interace (Selectables)
- 4.21.3
* Tue May 13 2008 jkupec@suse.cz
- create /etc/zypp/products.d on install
* Mon May 12 2008 jkupec@suse.cz
- /etc/zypp/products.d added to file list (bnc #385868)
- revision 10049
- version 4.21.2
* Mon May 12 2008 jkupec@suse.cz
- call RemoveResolvableReport::problem() before finish() on error
  (bnc #388810)
- revision 10045
* Sat May 10 2008 coolo@suse.de
- fix file list
* Fri May  9 2008 ma@suse.de
- Product now retrieves all attributes from the solv file.
- version 4.21.1
- revision 10031
* Fri May  9 2008 ma@suse.de
- Add zypp.conf option configdir (/etc/zypp) and arrange
  all config files and directories to follow {configdir}
  per default.
- Fix zypp-query-pool to print satisfied products and additional
  products defined in {configdir}/products.d for registration.
  (bnc #385868)
- version 4.21.0
- revision 10029
* Fri May  9 2008 jreidinger@suse.cz
- implement remove duplicate entries in lock file (bnc#385967)
* Fri May  9 2008 ma@suse.de
- Speedup rpmdb2solv by reusing an existing solv file.
- version 4.20.1
- revision 10012
* Thu May  8 2008 ma@suse.de
- Fix failed package download due to unkown repository type (bnc #386386)
- revision 9995
* Thu May  8 2008 ma@suse.de
- Support optional root argument to RepoManagerOptions, to prefix all
  path names taken from ZConfig. (bnc #388265)
- version 4.20.0
- revision 9993
* Thu May  8 2008 schubi@suse.de
- new solution action for removing requirements/conflicts (bnc #387631)
- revision 9988
* Thu May  8 2008 ma@suse.de
- Provide enumerated patch category 'Patch::categoryEnum()' (bnc #159100)
- revision 9984
* Wed May  7 2008 schubi@suse.de
- DistUpgrade: searching for providers -> regarding name onl
- r 9977
* Tue May  6 2008 dmacvicar@suse.de
- add flag --registrable (-r) to query pool to avoid
  using system as a filter
- 4.19.1
* Tue May  6 2008 coolo@suse.de
- return values in non-void functions
* Mon May  5 2008 jkupec@suse.cz
- support multiple search strings in PoolQuery (ORed)
- revision 9945
* Mon May  5 2008 schubi@suse.de
- Switch off the upgrade mode of the
  SAT solver cause the packages have already been evaluated by
  the distupgrade machanism of libzypp. (bnc #386375)
- rev 9943
* Fri May  2 2008 jreidinger@suse.cz
- release file after copy to cache as soon as possible.
  (bnc #381311)
- r9940
* Fri May  2 2008 schubi@suse.de
- Bugfix: keep states by user has been removed it the
  package has not been installed BUT has been recommended by another package.
  (bnc #385832)
- rev 9938
* Fri May  2 2008 jreidinger@suse.cz
- add isLocal function to Url which say if scheme is local or
  internet.
- r9932
* Fri May  2 2008 jreidinger@suse.cz
- cache decision for repository depend on his url.
- http,ftp and smb cache packages.
- revision 9929
* Thu May  1 2008 ma@suse.de
- Load and maintain persistent hard locks stored in /etc/zypp/locks.
  Locks are loaded together with the target, and changes are writen
  back on commit. zypp.conf option locksfile.apply can be used to turn
  this feature on or off. (FATE #120352)
- version 4.18.0
- revision 9927
* Wed Apr 30 2008 ma@suse.de
- Add zypp.conf option solvfilesdir: Path where the repo solv files
  are created. Default value: {cachedir}/solv.
- Target and repositories now save their solvfiles below {solvfilesdir}
  in directories named after the repositories alias.
- version 4.18.0
- revision 9913
* Wed Apr 30 2008 jkupec@suse.cz
- fixed filesystem::expandlink(Pathname) (bnc #368477)
- r9906
* Tue Apr 29 2008 schubi@suse.de
- cleanup in return values of doUpgrade and doUpdate
- r9886
- 4.17.0
* Mon Apr 28 2008 jkupec@suse.cz
- check for valid pool in begin(), improve the code (bnc #384337)
- r9872
- 4.16.0
* Mon Apr 28 2008 mvidner@suse.cz
- Updated package-manager-su from xdg-utils-1.0.2-48 (bnc#339549).
* Mon Apr 28 2008 schubi@suse.de
- added translations
* Mon Apr 28 2008 jkupec@suse.cz
- ostream operator<<(ostream,TriBool) added
- r9833
* Fri Apr 25 2008 ma@suse.de
- Prevent target::unload from creating a system repo in order
  to unload it. (bnc 382297)
- version 4.15.2
- revision 9822
* Fri Apr 25 2008 ma@suse.de
- Prevent deselected or deleted items from being re-selected due to
  recommends (aka. persistent soft locks). Unlike hard locked, those
  items will be automatically selected if required. The list of soft
  locked items is stored in /var/lib/zypp/SoftLocks.
- version 4.15.1
- revision 9818
* Wed Apr 23 2008 ma@suse.de
- Remove obsolete AdditionalCapabilities interface from ResPool.
  Forward sat::Pool::RepositoryIterator. There's no more need to
  maintain an extra Repository list in ResPool.
- revision 9806
* Wed Apr 23 2008 ma@suse.de
- Support dependencies requiring a specific architecture:
  "name[.arch] [op edition]". See class Capability for details
  about how to construct dependencies. (bnc #305445)
- version 4.15.0
- revision 9805
* Tue Apr 22 2008 dmacvicar@suse.de
- patch attributes and deprecate old ones
- 4.14.0
* Tue Apr 22 2008 jreidinger@suse.cz
- change locks api -
- make more functions const
- replace add/remove by selectable to add/remove by ident or name and kind
- rename iterator to const_iterator to avoid confusion
- revision 9781
* Tue Apr 22 2008 schubi@suse.de
- Do architecture changes while "dup" in the external distribution
  upgrade ONLY. bnc #382274
- Added "ignore" to the solutions
- Added "self-conflicts" to the solution
- added new solver mechanism "resolveQueue"
- Bugfix broken/satisfied products
- rev 9776
* Tue Apr 22 2008 ma@suse.de
- Added Pattern::core returning the packages required by a pattern.
  (see also Pattern::depends and Pattern::contents).
- revision 9771
* Mon Apr 21 2008 ma@suse.de
- Added Target::release(), returning the targets distribution
  release string.
- revision 9761
* Sat Apr 19 2008 ma@suse.de
- per default abort if package installation fails. (bnc #381203)
- version 4.13.3
- revision 9725
* Fri Apr 18 2008 dmacvicar@suse.de
- add ZYpp and curl version to http agent string
  (bnc #381280)
* Thu Apr 17 2008 ma@suse.de
- Fixed pools package index wrongly including source packages. (bnc #380283)
- version 4.13.2
- revision 9683
* Wed Apr 16 2008 ma@suse.de
- Disable fast creation of @System.solv. It may produce wrong results
  e.g. after a rebuilddb.
- version 4.13.1
- revision 9666
* Wed Apr 16 2008 ma@suse.de
- initializeTarget now takes an additional option, telling whether to
  rebuild an existing rpm database before using it. Default is false.
  (bnc #308352)
- version 4.13.0
- revision 9664
* Tue Apr 15 2008 jreidinger@suse.cz
- save do nothing if no locks added/removed
- fix bug with multiple save lock
- don't save same query multiple times
- improve tests
- revision 9644
* Tue Apr 15 2008 schubi@suse.de
- added new translations
- activate zypp-query-pool
- Revision 9637
- 4.12.1
* Tue Apr 15 2008 jkupec@suse.cz
- Locks API cleaned-up, iterator added, light read() added
- PoolQuery::attribute(SolvAttr) getter added
- revision 9609
* Mon Apr 14 2008 dmacvicar@suse.de
- reenable zypp-query-pool
- 4.11.1
* Mon Apr 14 2008 ma@suse.de
- Enable evaluation of hardware dependencies.
- Enable evaluation of filesystem dependencies.
- revision 9605
* Sun Apr 13 2008 jkupec@suse.cz
- RawMetadataRefreshPolicy: CheckIfNeededIgnoreDelay added
  needed for explicit refresh request
- revision 9574
* Fri Apr 11 2008 ma@suse.de
- Install ResPoolProxy index to speedup Solvable to Selectable
  conversion.
- version 4.11.0
- revision 9558
* Fri Apr 11 2008 kkaempf@suse.de
- Implement update scripts installed by packages. After every
  package install /var/adm/update-scripts is scanned for the first
  file starting with "<name>-<version>.<release>-", which is then
  executed.
- revision 9547
* Fri Apr 11 2008 ma@suse.de
- Fix SolvIterMixin to avioid multiple visits of the same Selectable.
- Add Resolvable::poolItem() providing access to the corresponding
  PoolItem. API to query isRelevant/isSatisfied/isBroken was moved
  to PoolItem.
- Add ResPool::satisfiedProductsBegin/End iterator over all products
  whose dependencies are satisfied. This reflects the status determined
  by the last solver run. (#368104)
- revision 9535
* Fri Apr 11 2008 jreidinger@suse.cz
- switch to new locks api
- revision 9524
* Wed Apr  9 2008 ma@suse.de
- Enable ui::Selectable lookup by Solvable/PoolItem in ResPoolProxy.
- Add SolvIterMixin: Base class providing PoolItem_iterator and
  Selectable_iterator iterator types based on a Solvable iterator.
- Enhanced WhatProvides and SolvableSet to PoolItem_iterator to offer
  PoolItem_iterator and Selectable_iterator.
- Add Solvable::SplitIdent: Helper class that splits an identifier
  into kind and name.
- Provide methods Pattern::contents returning a collection of packages
  associated with the pattern/patch.
- revision 9496
* Tue Apr  8 2008 jreidinger@suse.cz
- add comparing to PoolQuery
- revision 9466
* Tue Apr  8 2008 jreidinger@suse.cz
- move RepoInfo to universal RepoException. This can enable more verbose output - for frontend. (helps with bnc #377137)
- revision 9452
* Tue Apr  8 2008 jreidinger@suse.cz
- initial implementation of new locks (FATE #120118 and #120352)
- revision 9442
* Mon Apr  7 2008 dmacvicar@suse.de
- selectable API updates and changes
- 4.10.0
* Fri Apr  4 2008 jreidinger@suse.cz
- add split with respect to escaped delimeters and also for quotes
- revision 9373
* Thu Apr  3 2008 ma@suse.de
- Fixed some missing package and source package attributes.
- revision 9348
* Thu Apr  3 2008 ma@suse.de
- Allow to store a media label in MediaSetAccess. This label is
  passed to a media change requests to describe which CD is
  requested.  (bnc #330094)
- Fixed some missing package and source package attributes.
- revision 9347
* Wed Apr  2 2008 schubi@suse.de
- Moved poolItem.status().isSatisfied(),.... to poolItem.isSatisfied()
- Removed establish state in ResStatus
- revision 9337
- version 4.7.0
* Wed Apr  2 2008 ma@suse.de
- Add PoolItem::isSatisfied()/isBroken() to test whether
  the items requirements are met.
- revision 9334
* Tue Apr  1 2008 ma@suse.de
- Extend sat::WhatProvides allows one to query for possible providers
  of a collection of capabilies. E.g. all providers of a packages
  requirements.
- Fixed retrieval of translated texts from .solv files, provided the
  solv file contains them.
- revision 9328
* Tue Apr  1 2008 jreidinger@suse.cz
- initial implementation of serialize/recovery PoolQuery
  (needed by FATE #120118)
- revision 9325
* Wed Mar 26 2008 ma@suse.de
- Allow prioritizing repos by adding a line 'priority=N' to the
  .repo file. Where N is an integer number from 1 (highest prio)
  to 99 (least and default). (bnc #369827, fate #302872)
- version 4.6.1
- revision 9276
* Mon Mar 24 2008 coolo@suse.de
- support plaindir again (at least the most important parts)
* Fri Mar 21 2008 jreidinger@suse.cz
- Throwing special exception MediaBadCAException in case of SSL
  certificate validation failure.(bnc #223512)
- revision 9250
* Fri Mar 21 2008 jreidinger@suse.cz
- add new error IO_SOFT to media request callback for temporary
  connection problem. (bnc #328822)
- add new media exception timeout when somethink fail due to exceed
  timeout
- mediacurl throw timeout exception when timeouted
- revision 9246
* Thu Mar 20 2008 jreidinger@suse.cz
- return more information from checking if metadata need refresh,
  so user can get better info. (bnc #307249)
- revision 9231
* Tue Mar 18 2008 ma@suse.de
- class sat::LocaleSupport: Convenience methods to manage support
  for language specific packages.
- revision 9197
* Tue Mar 18 2008 jkupec@suse.cz
- removed obsolete capability handling stuff (ma)
- version 4.5.0
* Tue Mar 18 2008 jreidinger@suse.cz
- Don't mask skip and abort exception in Fetcher
- revision 9188
* Tue Mar 18 2008 jreidinger@suse.cz
- action is correctly set in mediaRequest callback
- revision 9186
* Mon Mar 17 2008 ma@suse.de
- Fix SEGV in commit (bnc# 371137)
- version 4.4.3
- revision 9174
* Fri Mar 14 2008 ma@suse.de
- version 4.4.2
* Fri Mar 14 2008 dmacvicar@suse.de
- look for openssl in cmake, actually we build require it
- explicitly link against openssl and crypto, required to
  compile in all platforms/distros.
* Fri Mar 14 2008 jreidinger@suse.cz
- Save repo type during refresh if type is NONE (f.e. lazy probing).
- revision 9153
* Fri Mar 14 2008 jreidinger@suse.cz
- replace gpg escaped semicolon with real semicolon (bnc #355434)
- revision 9151
* Fri Mar 14 2008 jreidinger@suse.cz
- make strings from RpmDb and Keyring exceptions translatable
- revision 9146
* Thu Mar 13 2008 dmacvicar@suse.de
- fix retrieving keys (bnc #368099)
- version 4.4.1
* Thu Mar 13 2008 jreidinger@suse.cz
- enable frontend to rewrite add_probe settings.(bnc #309612)
- Correct adding repo without type to lazy probing.
- revision 9135
* Thu Mar 13 2008 jreidinger@suse.cz
- get better message if something fail when trying run rpm
  (bnc #344584)
- revision 9133
* Thu Mar 13 2008 ma@suse.de
- Add ExternalProgram::execError and ExternalProgram::command
  to improve error reporting.
- revision 9112
* Thu Mar 13 2008 jkupec@suse.cz
- release all media before requesting another (bnc #336881)
- revision 9110
* Thu Mar 13 2008 jkupec@suse.cz
- getDetectedDevices added (fate #120298)
- revision 9108
* Wed Mar 12 2008 jkupec@suse.cz
- media backend release() methods changed to take string & instead
  of bool (needed for FATE #120298)
- media label, detected device list and current device arguments
  added to the requestMedia callback
- version 4.4.0
* Wed Mar 12 2008 coolo@suse.de
- fix for bnc#369543
* Mon Mar 10 2008 jkupec@suse.cz
- provide download rate info (average and curent) in the
  media::DownloadProgressReport for ftp/http (bnc #168935)
- r9074
* Mon Mar 10 2008 jkupec@suse.cz
- cleanCache(): clean also .cookie files
- cleanTargetCache() added
- use escaped_alias() in rawcache_path_for_repoinfo() and
  packagescache_path_for_repoinfo()
- r9068
* Fri Mar  7 2008 jkupec@suse.cz
- fixed location of RPMs in subdirs when parsing plaindir repo
  recursively (bnc #368218)
- revision 9060
* Thu Mar  6 2008 ma@suse.de
- Do not filter any installed solvables.
- revision 9031
- version 4.3.2
* Wed Mar  5 2008 ma@suse.de
- Try to rebuild broken solv files in Target::load.
- revision 9015
* Tue Mar  4 2008 ma@suse.de
- Try to rebuild broken solv files in RepoManager::loadFromCache.
- Fix RepoStatus::operator&& and RepoStatus testsuite.
- revision 9008
* Tue Mar  4 2008 schubi@suse.de
- improved problem description while a vendor change
- improved problem description if a requirement cannot be fulfilled. Bug #358560
- revision 9002
* Tue Mar  4 2008 ma@suse.de
- Save and restore requested locales on target load/commit.
- revision 8999
* Mon Mar  3 2008 schubi@suse.de
- (Update) Prevent reinstallation of installed packages.
- revision 8984
* Sun Mar  2 2008 coolo@suse.de
- refresh metadata if there is no cache to unbreak compat with
  kiwi (that relied on "zypper sa <url> <alias>" to create a repo
  that "zypper in" could work on)
* Sun Mar  2 2008 coolo@suse.de
- create cache directory before calling rpmdb2solv (in an empty
  chroot)
- version 4.3.1
* Thu Feb 28 2008 jkupec@suse.cz
- special exception message if server returns 403 response
  (forbidden) (port from SP2)
- MediaException messages marked for translation
* Wed Feb 27 2008 dmacvicar@suse.de
- make sure we have target cache on target initialize
- version 4.3.0
* Tue Feb 26 2008 lslezak@suse.cz
- DiskUsageCounter.cc - ignore "vfat", "fat", "ntfs" and "ntfs-3g"
  file systems (#333166)
- rev. 8915
* Tue Feb 26 2008 ma@suse.de
- Fixed Capabilites iterator exposing prereq marker.
- revision 8914
* Tue Feb 26 2008 schubi@suse.de
- postinstall script fixed
- version 4.2.10
* Mon Feb 25 2008 schubi@suse.de
- Testcases regards modaliases, rpmlib, ... correctly
- Revision 8904
* Mon Feb 25 2008 ma@suse.de
- Remove obsolete sql database. (bnc#363224)
- revision 8898
* Fri Feb 22 2008 ma@suse.de
- Take care target uses --root when creating solv files (bnc #363789)
- revision 8881
* Fri Feb 22 2008 schubi@suse.de
- Unmaintained packages which does not fit to the updated system
  (broken dependencies) will be deleted.
- revision 8867
* Fri Feb 22 2008 coolo@suse.de
- let libzypp-devel require libsatsolver-devel
* Wed Feb 20 2008 ma@suse.de
- Cleanup unused /var/lib/zypp/cache in migrate_sources (#305160)
- revision 8833
* Tue Feb 19 2008 jkupec@suse.cz
- media: fixed DownloadProgressReport.finish() url argument in
  doGetFileCopy()
- revision 8815
* Tue Feb 19 2008 dmacvicar@suse.de
- hardlink when possible to optimize data transfer
  and space across caches.
- version 4.2.8
* Tue Feb 19 2008 coolo@suse.de
- added some locale support to sat::Solvable
- version 4.2.7
* Mon Feb 18 2008 dmacvicar@suse.de
- handle error messages better in doesFileExist too which is
  used during probing. (bnc #362608)
* Sun Feb 17 2008 dmacvicar@suse.de
- Fetcher::reset() should not reset cache directories.
  (bnc #348050)
- version 4.2.6
* Sat Feb 16 2008 dmacvicar@suse.de
- Use CURLOPT_NOBODY instead of a CURLOPT_RANGE of 1 byte
  for http and https, but this time set CURLOPT_HTTPGET back to 1
  so it actually works. This makes Media::doesFileExist
  efficient for http and https.
  (related to bnc #348050)
- version 4.2.5
* Fri Feb 15 2008 coolo@suse.de
- using .solv files only now (fate #303018)
- revision 8699
* Tue Feb 12 2008 coolo@suse.de
- fix architectures on distupgrade
* Fri Feb  8 2008 coolo@suse.de
- fixes from trunk merged
* Fri Feb  1 2008 jkupec@suse.cz
- fixed renaming a repo to an existing one (bnc #228216)
- revision 8431
* Sun Jan 27 2008 coolo@suse.de
- fix changelog
* Thu Jan 24 2008 jkupec@suse.cz
- read .curlrc more robustly to obtain user-proxy (#330351)
- revision 8368
* Fri Jan 18 2008 coolo@suse.de
- always buildrequire openssl-devel
- replacing strange utf-8 chars in changelog
- revision 8317
* Thu Jan 17 2008 jkupec@suse.cz
- Saner NFS timeo default (#350309)
- revision 8314
* Thu Jan 17 2008 kkaempf@suse.de
- support 'patterns.pat' and 'patterns.pat.gz' to read all
  patterns in one go.
- rev 8309
* Tue Jan 15 2008 lslezak@suse.cz
- added RpmDb::removePubkey(), call it from
  KeyRing::Impl::deleteKey() - remove the GPG key from RPM when it
  is removed from the trusted keyring
- revision 8288
* Mon Jan 14 2008 schubi@suse.de
- Textchanges
- reduced logging in SAT-solver
- ordering solutions
- version 4.1.8
- revision 8276
* Thu Jan 10 2008 schubi@suse.de
- Enabled SAT solver via default. (removed ZYPP_SAT_SOLVER)
  ZYPP_RC_SOLVER=1 will enable the old RedCapet solver
- Revision 8255
- Version 4.1.7
* Wed Jan  2 2008 jkupec@suse.cz
- Pathname zypp::filesystem::expandlink(const Pathname &) added
- if the provided file is a symlink, expand it (#274651) (this
  probably won't work for schemes other than file/dir and cd/dvd)
- revision 8179
* Tue Dec 18 2007 aschnell@suse.de
- fixed password handling in URLs (bug #347273)
- revision 8118
* Mon Dec 17 2007 ma@suse.de
- Fixed default text locale detection not to use static variables. (#346872)
- version 4.1.6
- revision 8116
* Mon Dec 10 2007 ma@suse.de
- Log more details about zypp lock owner. (#294094)
- revision 8088
* Fri Dec  7 2007 ma@suse.de
- Remove runtime dependency for libboost_filesystem (#345773)
- version 4.1.5
- revision 8061
* Fri Nov 30 2007 schubi@suse.de
- Enable SAT solver via environment variable ZYPP_SAT_SOLVER.
  e.g.: ZYPP_SAT_SOLVER=1 zypper install foo
- version 4.1.4
- revision 7998
* Wed Nov 28 2007 aschnell@suse.de
- make IniParser more strict (bug #306697)
* Mon Nov 26 2007 ma@suse.de
- Fix missing packages in patch content list. (#340896)
- revision 7925
* Fri Nov 16 2007 coolo@suse.de
- fix build
* Wed Nov 14 2007 ma@suse.de
- Output date strings in UTF-8. (#339423)
- revision 7807
* Tue Nov 13 2007 schubi@suse.de
- fixes for new gcc
- version 4.1.3
- r7788
* Mon Nov  5 2007 ma@suse.de
- Don't mark failed patch scripts as installed. (#327523)
- version 4.1.2
- revision 7744
* Wed Oct 31 2007 dmueller@suse.de
- update rpmlint suppression
* Fri Oct 26 2007 aschnell@suse.de
- fixed retrieval of epoch from rpmdb (bug #246680)
* Thu Oct 25 2007 aschnell@suse.de
- allow non-existing "packages" file in susetags parser (bug
  [#309235])
* Fri Oct 12 2007 ma@suse.de
- SMBIOS DMI modalias matching added (#333152)
- revision 7494
* Sat Oct  6 2007 jkupec@suse.cz
- do not download the same file multiple times in one attach session
  (#307098), r7456
- special cdrom detection code for SCSI / Virtual CDROMs on iSeries
  removed - should be correctly detected by HAL now
  (#167629, #163971), r7452
- version 4.1.1
* Fri Oct  5 2007 aschnell@suse.de
- filter architecture in plaindir parser (bug #330791)
* Thu Oct  4 2007 ma@suse.de
- Throw constructing malformed checksums. (#189096)
- revision 7441
* Thu Oct  4 2007 mvidner@suse.cz
- Renamed templates back because proper qualification makes it work
  too.
- 4.1.0
* Thu Oct  4 2007 aschnell@suse.de
- only look for repositories in file ending ".repo" (bug #294779)
* Wed Oct  3 2007 mvidner@suse.cz
- Fixed compilation errors with GCC 4.3 by adding missing includes
  and renaming templates: MaxBits to MaxBitsT, Mask to MaskT,
  Compare<Edition> to CompareEd.
- r7426
* Mon Oct  1 2007 ma@suse.de
- Incorporated patch from Michael Matz to speedup cache reading.
- revision 7413
* Fri Sep 28 2007 schubi@suse.de
- Resolvertestcase:
  - log Repository info
  - set keep state in the testcase
  - handle vendor
- r 4707
* Thu Sep 27 2007 ma@suse.de
- Fixed pattern parser SEGV on broken pattern files. (#328546)
- revision 7402
* Wed Sep 26 2007 schubi@suse.de
- QueuItemRequire: Filter out all provider which have worser architecture,
  are NOT noarch and have not the same name as the requirement. The
  last one is needed for updating packages via patch/atoms.
  Bug 328081
- Revert changes of r 7340
- r 7386
* Tue Sep 25 2007 ma@suse.de
- Add missing '--install' parameter in desktop file. (#308640)
- version 4.0.0
- revision 7369
* Tue Sep 25 2007 jkupec@suse.cz
- release all attached media before attempting to eject (#293428)
- fixed parsing of --proxy-user parameter of .curlrc (#309139)
- revision 7352
- version 3.26.0
* Mon Sep 24 2007 dmacvicar@suse.de
- provide a way to retrieve the metadata path. Used for
  installation, which incorrectly creates a repository in
  cache without adding it first, so metadata path is not
  set and therefore it is not possible to setup a media
  verifier on installation. Part of fix for (#293428)
- 3.25.0
* Mon Sep 24 2007 schubi@suse.de
- If more than one resolvables provide a requirements and have different
  architecture take thatone with the best architecture. (Not regarding the
  name). Bug: Branching too much while an installation of a multi-arch-DVD
- r 7340
- version 3.24.8
* Fri Sep 21 2007 schubi@suse.de
- Checking the queue if an item will be deleted. If yes, the requirements
  are not needed anymore. Bug 326384
- version 3.24.7
- r 7329
* Thu Sep 20 2007 jkupec@suse.cz
- don't probe the repository type upon saving if disabled (#326769)
- version 3.24.6
- revision 7319
* Thu Sep 20 2007 ma@suse.de
- Avoid calling rpm repeatedly in case of an error. This is fault-prone,
  esp. if the error occurred executing the packages post-install script.
- version 3.24.5
- revision 7317
* Thu Sep 20 2007 ma@suse.de
- If a package is deselected by user, apply this soft lock to all
  available versions of this package.
- version 3.24.4
- revision 7316
* Wed Sep 19 2007 schubi@suse.de
- Update: Do not set an item to installation if there has been already set
  one for installation which has the same NVA. Bug  326286
- version 3.24.3
- r 7311
* Wed Sep 19 2007 ma@suse.de
- Enable package cache during commit. (#326249)
- revision 7309
* Tue Sep 18 2007 schubi@suse.de
- Do not regarding requirements for packages which will be deleted in the
  same solver run. Bug 310618
- r 7292
- version 3.24.2
* Mon Sep 17 2007 jkupec@suse.cz
- don't download filelists.xml.gz (#307105)
- version 3.24.1
- revision 7269
* Mon Sep 17 2007 ma@suse.de
- Improve estimated diskusage while there is no valid
  solver result. (#325617)
- revision 7266
* Mon Sep 17 2007 schubi@suse.de
-Bugfix in vendor change of a required resolvable (Correct error message)
  Bug 310455
- r 7262
* Mon Sep 17 2007 lslezak@suse.cz
- fixed DU parsing in inst-sys (#308659)
- revision 7256
* Fri Sep 14 2007 ma@suse.de
- Enable using patch and delta rpms. (#309124)
- version 3.24.0
- revision 7253
* Thu Sep 13 2007 ma@suse.de
- On update do not delete unmaintained non-SuSE packages.
- version 3.23.2
- revision 7239
* Thu Sep 13 2007 lslezak@suse.cz
- ZYppImpl::getPartitions() - don't return the current partitioning
  when the partitioning hasn't been set - fixes DU parsing in
  inst-sys (#308659)
* Thu Sep 13 2007 dmacvicar@suse.de
- Throw specific exceptions during commit (#308511)
- 3.23.1
* Wed Sep 12 2007 ma@suse.de
- Various disk space calculation fixes. Susetags, plaindir and rpmdb
  now provide more detailed disk usage information.
  Yum metadata don't, so we book the package size to '/'. (#308362)
- version 3.23.0
- revision 7225
* Wed Sep 12 2007 schubi@suse.de
- Regarding keep state while recycle old valid solver results. Bug 286889
- r 7209
* Wed Sep 12 2007 jkupec@suse.cz
- report 100%% progress on finishing RPM removal (bug #309431)
- revision 7200
* Tue Sep 11 2007 schubi@suse.de
- Update: rename language packages --> take that package which fits to the
  selected language Bug 308098
- r 7919
* Tue Sep 11 2007 dmacvicar@suse.de
- restore deltas and patch rpms from the cache (#309124)
- 3.22.8
* Tue Sep 11 2007 ma@suse.de
- Don't fail if a product is deleted multiple times (e.g. due to
  obsoletes and an explicit deleted request). (#308746)
- version 3.22.7
- revision 7184
* Tue Sep 11 2007 jkupec@suse.cz
- SYSCONFDIR variable added for modifying /etc
* Tue Sep 11 2007 schubi@suse.de
- uninstallable resolvable -->suggested solution: delete; Bug 308164
- r 7177
* Mon Sep 10 2007 schubi@suse.de
- new translations added
- r 7166
- version 3.22.6
* Mon Sep 10 2007 lslezak@suse.cz
- fixed disk usage counting of updated packages (#308362)
* Mon Sep 10 2007 schubi@suse.de
- Splitting packages: Take the package with the best
  architecture,edition ONLY; Bug 308591
- r 7160
* Mon Sep 10 2007 lslezak@suse.cz
- properly report fallback disk usage size (in kB instead of bytes)
  when disk usage is not known (YUM repos) (#308475)
* Fri Sep  7 2007 ma@suse.de
- Install a sample /etc/zypp.conf. (#306615)
- Fixed missing soversion symlink in package.
- version 3.22.5
- revision 7150
* Fri Sep  7 2007 schubi@suse.de
- RequirementIsMet: return true only if ALL Atoms are NOT incomplete; Bug
  308252
- r 7143
* Thu Sep  6 2007 schubi@suse.de
- Error: Select two candidate with the same name while update.
  Solution: If there is a candidate which is already selected for installation -->
  take thatone #308082
- r 7132
* Thu Sep  6 2007 ma@suse.de
- Work arround installed patterns providing an empty vendor string. (#307743)
- Let the solver treat vendor suse and opensuse as equivalent.
- version 3.22.4
* Thu Sep  6 2007 schubi@suse.de
- Checking item before evaluating the concerning vendor. bug #307941
- r 7119
* Thu Sep  6 2007 dmacvicar@suse.de
- Fix for bug #307163 - empty package descriptions
  a.k.a shared tag not 100%% implemented
- r 7117
- version 3.22.3
* Wed Sep  5 2007 schubi@suse.de
- logging "reverse" NEEDED_BY in the detail description of solver
  problems.
- improved error message if a requiremnt is not fulfilled Bug 307743
- Add "ignore" option to the solution if a requirement is not fulfilled
  Bug 304276
- revision 7113
* Wed Sep  5 2007 jkupec@suse.cz
- fixed the order of operands of susetags local metadata status
  computation which caused the YaST repositories to always get
  refreshed (part of bug #304310)
- revision 7107
- version 3.22.2
* Tue Sep  4 2007 schubi@suse.de
- comparing vendor with VendorAttr::equivalent
- revision 7103
* Mon Sep  3 2007 schwab@suse.de
- Use $RPM_OPT_FLAGS.
* Mon Sep  3 2007 ma@suse.de
- Reset transact bits when switching status from
  "update" to "protected" (#246976)
- version 3.22.1
- revision 7094
* Mon Sep  3 2007 schubi@suse.de
- new translations added
- rev 7083
* Fri Aug 31 2007 ma@suse.de
- Added ability to switch off use of patch and delta rpms via zypp.conf (#305864)
  [main]
  download.use_patchrpm = no
  download.use_deltarpm = no
- version 3.22.0
- revision 7069
* Fri Aug 31 2007 ma@suse.de
- On demand translate patch requirements into a list of atoms.
  Required by the UI to display packages acssociated with a patch.
  (#300612)
- version 3.21.1
- revision 7065
* Fri Aug 31 2007 kkaempf@suse.de
- enrich ResolverInfo with the reason if a user-initiated request
  fails (#304325, #306240)
- r 7051
* Thu Aug 30 2007 jkupec@suse.cz
- added missing implementation of LogControl::setLineFormater()
  (lslezak)
- version 3.21.0
- revision 7041
* Thu Aug 30 2007 jkupec@suse.cz
- enable changing url in requestMedia callback (#294481)
- revision 7037
* Thu Aug 30 2007 ma@suse.de
- Filter readonly mount points in DiskUsageCounter (#297405)
- revision 7030
* Thu Aug 30 2007 jkupec@suse.cz
- remember the cause of the RepoException when refreshing metadata
  (#301022)
- r7023
* Thu Aug 30 2007 ma@suse.de
- Safe fix for bug #299680.
- version 3.20.1
- revision 7026
* Thu Aug 30 2007 schubi@suse.de
- Bugfix: If a requirement has been fulfilled by more than one language
  resolvables only thatone will be taken which fits to the selected
  language.
- r 7018
* Thu Aug 30 2007 jkupec@suse.cz
- correct error code for media errors in MediaCurl::doGetFileCopy()
  affects only zypper error output, does not affect YaST
- r7013
* Wed Aug 29 2007 jkupec@suse.cz
- reverted blocking of requestMedia from r6271 (#301710)
- r6999
* Wed Aug 29 2007 kkaempf@suse.de
- prevent progress report in destructor (#299680)
- r6998
* Wed Aug 29 2007 jkupec@suse.cz
- treat non-filelists.xml <file> entries as file provides capabilities
  in YUM parser (#304701)
- r6992
* Wed Aug 29 2007 kkaempf@suse.de
- the media.1/media uniquely identifies a 'susetags' repo, not
  the content file (#304200)
* Wed Aug 29 2007 jkupec@suse.cz
- fixed locale dir (#304649)
- r6984
* Wed Aug 29 2007 kkaempf@suse.de
- don't treat normal package license as "license to confirm"
  (#305906)
* Wed Aug 29 2007 ma@suse.de
- Fixed fix for #293039. Segfault due to uninitialzed data.
- version 3.19.3
- revision 6980
* Wed Aug 29 2007 schubi@suse.de
- reduced too much verbosed ResolverContext logging; Bug 303971
- r 6977
* Wed Aug 29 2007 ma@suse.de
- Fixed PlainDir repositories to provide real disk usage data. For
  repomd and others that do not provide any detailed disk usage info,
  assume the packgage size is required below "/". Peviously they were
  treated as being empy.
- version 3.19.2
- revision 6972
* Wed Aug 29 2007 schubi@suse.de
- Add a new solver solution in the case of running in a timeout:
  ProblemSolutionDoubleTimeout.h
  [#]Bug 302496
- revision 6970
* Wed Aug 29 2007 dmacvicar@suse.de
- bug in fix for (#292986)
* Tue Aug 28 2007 dmacvicar@suse.de
- (#297001) - libzypp: can't skip broken packages
- re enable importing zypp keyring from rpm.(#302379)
- 3.19.1
* Tue Aug 28 2007 kkaempf@suse.de
- rename ResolvableQuery::iterateResolvablesByKindsAndStrings
  to ResolvableQuery::iterateResolvablesByKindsAndStringsAndRepos
  in order to support query-by-repo (#305384)
- fix iterateResolvablesByKindsAndStringsAndRepos to take any
  number of kinds, names, or repos (#305347)
- remove ResolvableQuery::iterateResolvablesByKind, not needed
- version 3.19.0
- rev 6935
* Tue Aug 28 2007 dmacvicar@suse.de
- real fix for reading signature ids. (#390535).
- delete metadata when removing repo (#301037).
* Mon Aug 27 2007 dmacvicar@suse.de
- following behaviour for setPartitions
  - if they are not set, they are detected
  - if they are set, that value is used.
  - if value set or detected is empty, all disk usage
    information is read. Otherwise just values in those
    mount points.
    Should work for installation as long as detectPartitions
    is empty at installation.(#293039)
* Mon Aug 27 2007 kkaempf@suse.de
- Add ZConfig::overrideSystemArchitecture() to override zypp arch
  from external, e.g. for the testcases
- Honor ZYPP_CONF environment variable to override the buit-in
  /etc/zypp/zypp.conf
- Check architecture at handout() to prevent NULL ptr reference.
- Bug 301286
- rev 6908
* Mon Aug 27 2007 schubi@suse.de
-The solver generate an establish call for all
  resolvables which has filesystemcaps if there is not a valid result from a
  former solver run available. This covers:
  * Initial solver run
  * Changing of filesystem whithin a workflow, cause the solver results will
  be reset if the filesystem dependencies have been changed
  Bug 271912
- r 6901
* Sun Aug 26 2007 kkaempf@suse.de
- pass location to plaindir package (#303751)
- Add name of file in question to checksum/signature related
  exceptions.
- pass basename of file to verifyFileSignatureWorkflow (instead of
  empty string).
- filter out incompatible architectures when parsing sustags
  repos (first half of #301286)
- r 6882
* Fri Aug 24 2007 dmacvicar@suse.de
- don't run source migration if yast is running in
  intsys mode (#297136)
- signature and checksum verification fixes. Still pending
  problem ZYpp getting no output from gpg when running from zypper.
  (#302059)
* Thu Aug 23 2007 schubi@suse.de
- Do not strip resolvables which have the same name but different kind
  (ResolverInfo*)
- Flag info NEEDEDBY correctly if it will be used by freshen/supplement
- r 6830
* Wed Aug 22 2007 mvidner@suse.cz
- Do not use "a-z" in regexes. Fixes "Invalid Url scheme 'http'" in
  the Estonian locale (#302525).
* Wed Aug 22 2007 aschnell@suse.de
- added remembering of exception history at various places
* Wed Aug 22 2007 schubi@suse.de
- Bugfixes concerning vendor handling:
- first bug:
  Installed A-1.0(vendor SuSE)
  Available A-2.0(other vendor)
  A will not be regarded as "unmaintained". So it will not be deleted.
- second bug:
  A need B-2.0. B-1.0 is installed but has another vendor. Report a
  proper errmessage.
- Testcase : solution-tests/vendor-test.xml
- r 6812
- 3.18.4
* Tue Aug 21 2007 dmacvicar@suse.de
- ignore HASH key for download (#300982)
* Tue Aug 21 2007 schubi@suse.de
- Added explicitly_requested as parameter in ResolverContext::Uninstall
  Bug 299819
- revision 6794
* Tue Aug 21 2007 dmacvicar@suse.de
- If no mount information is available, parse all DU entries.
- read only hack mode for migrate-sources. We actually do add
  repositories with it, but no harm. (#292986)
- fix some typos in exceptions (#301331)
- 3.18.3
* Mon Aug 20 2007 schubi@suse.de
- Do not regard explicit request in order to recognize updated packages
  correctly. Bug 301676
- Updated translations
- r 6766
- 3.18.2
* Mon Aug 20 2007 mvidner@suse.cz
- package-manager script: Call /sbin/yast2 with full path because of
  gnomesu (#269873).
* Mon Aug 20 2007 dmacvicar@suse.de
- add support for the HASH key. (#300982)
- Use ContentFileParser in Downloader (instead of implementing
  the parser again, it has a reason, Downloader was written first)
- update testcases and data to cover the new HASH key
- 3.18.1
* Mon Aug 20 2007 kkaempf@suse.de
- unify query API for kind and name, summary, description
  (incomplete)
- rev 6761, version 3.18.0
* Fri Aug 17 2007 kkaempf@suse.de
- add iterateResolvablesByKindsAndName
- rev 6735, version 3.17.13
* Fri Aug 17 2007 kkaempf@suse.de
- rename ResolvableQuery::queryByName to iterateResolvablesByName
- fix reading of kind and repository in ResolvableQuery
- add reverse lookups in CacheTypes
- add iterateResolvablesByKind
- rev 6733
* Fri Aug 17 2007 schubi@suse.de
- shorten solver error messages Bug 259894
- rev 6723
* Thu Aug 16 2007 kkaempf@suse.de
- fix ResolvableQuery::query(), add ResolvableQuery::queryByName()
  install zypp/cache header files.
- rev 6719, version 3.16.13
* Thu Aug 16 2007 kkaempf@suse.de
- discard pattern files with incompatbile architecture, both
  for download and for parsing. (#298716)
- rev 6711
* Thu Aug 16 2007 kkaempf@suse.de
- run sqlite asynchronously and add sql index files where
  appropriate, gives 6x performance on certain operations.
  Bumping cache schema version to 1004.
  (#300998)
- rev 6710
* Thu Aug 16 2007 kkaempf@suse.de
- fix String::endsWith (#301038)
- rev 6709
* Thu Aug 16 2007 schubi@suse.de
- added an _explicitly_requested in QueueItemConflict ( as already in
  QueueItemEstablish, QueueItemInstall, QueueItemUninstall ) in order to
  remove the conflicting item without an error message. Bug 299819
- rev 6699
* Thu Aug 16 2007 jkupec@suse.cz
- forgot to set default refresh policy in checkIfToRefreshMetadata
- repo.refresh.delay default set to 10 minutes
- 6693
* Wed Aug 15 2007 schubi@suse.de
- Bugfix while regarding correct vendor in update
- r6677
- version 3.15.0
* Wed Aug 15 2007 jkupec@suse.cz
- repo.refresh.delay=<minutes> (ZConfig, "main" section) support
  added to delay next check & refresh until the specified number of
  minutes has passed from the last check or refresh (FATE #301991).
  Revisions: 6654, 6656, 6666, and 6667.
- filesystem::touch(Pathname) added (r6666)
- RepoManager::touchIndexFile(RepoInfo) added
- RepoManager::checkIfToRefreshMetadata(RepoInfo,Url,policy):
  decision to do the refresh moved to this public method.
- r6667
* Wed Aug 15 2007 schubi@suse.de
- generate a resolver problem if addRequires does not find a resovable
  [#299486]
- rev 6660
* Tue Aug 14 2007 schubi@suse.de
- Prioritized delete request by the user BEFORE delete requests due
  missing dependencies or conflicting dependencies. Bug 298322
- rev 6640
* Fri Aug 10 2007 jkupec@suse.cz
- support also "Plaindir" as valid repo type name (#298622)
- revision 6616
- version 3.14.0
* Fri Aug 10 2007 dmacvicar@suse.de
- fix segfault in Progress reporting
- progress report use name instead of alias (#298035)
- repoinfo returns alias if name is empty
* Fri Aug 10 2007 dmacvicar@suse.de
- merge patch by dmueller to get rid of boost-regex
* Fri Aug 10 2007 dmacvicar@suse.de
- dont create a second CacheStore in the same scope, will lock...
  [#297627]
* Thu Aug  9 2007 jkupec@suse.cz
- fixed some RepoManager exception docs & history
- r6558
* Thu Aug  9 2007 dmacvicar@suse.de
- feature #302135: Graceful update of 3rd party packages
  Automatic upgrading only sees packages from same vendor
  This allows not needed to have those locked.
- Add persistent locks file which allow wildcards. Users
  can lock certain packages adding lines like "kde* < 3.5"
- add applyLocks() to apply persistent locks before solving
* Thu Aug  9 2007 schubi@suse.de
-  recognize changes in the pool (e.g. changing /etc/sysconfig/storage
  [#271912] wq
- Added locking resolvables in the testcases
- rev 6544
* Wed Aug  8 2007 dmacvicar@suse.de
- add migrate-sources to %%post (#292986)
- 3.13.15
* Wed Aug  8 2007 jkupec@suse.cz
- fixed bug with using wrong files from raw metadata cache
  (bug #297611) (duncanmv) (r6501, already released in 3.13.14)
* Wed Aug  8 2007 schubi@suse.de
- fix in "ignore conflicts" if the conflict has been caused by an obsolete
  Bug# 297795
- r 6517
* Tue Aug  7 2007 dmacvicar@suse.de
- implement susetags support for compressed metadata
  and testcases. (feature #301916)
- implement disk usage in cache. For installation requires
  some changes in YaST to setup the ZYpp getPartitions()
  before repos are cached. (bug #293039)
- added testcases for diskusage
- 3.13.14
* Mon Aug  6 2007 jkupec@suse.cz
- fixed YUM parser to properly create source packages
- disabled reading of filelists.xml.gz by default (the data are
  currently not stored anyway)
- revision 6481
- version 3.13.13
* Sat Aug  4 2007 ma@suse.de
- Don't download unwanted translation files (#293740).
- revision 6470
* Fri Aug  3 2007 ma@suse.de
- Fix susetags repo to parse dikusage data (#293039)
- revision 6467
- version 3.13.12
* Fri Aug  3 2007 ma@suse.de
- Add product attribute 'type' (aka 'category' which is now
  deprecated). Adapted sustags and yum parsers to parse and
  provide this value.
- revision 6464
- version 3.13.11
* Fri Aug  3 2007 dmacvicar@suse.de
- fix modalias rel column number
- version 3.13.10
* Fri Aug  3 2007 dmacvicar@suse.de
- Implemented option repo.add.probe to allow probing
  the added repositories
- version 3.13.9
* Fri Aug  3 2007 schubi@suse.de
- Fixed detection of renamed packages while update.
- Added new translations
- rev 6445
* Fri Aug  3 2007 ma@suse.de
- Speed up retrieving MediaNr attribute, as it slows down install
  order calculation. (#297173)
- revision 6442
* Fri Aug  3 2007 dmacvicar@suse.de
- Fixed cache schema upgrade
* Fri Aug  3 2007 ma@suse.de
- Fixed pattern includes and extends attributes.
- revision 6431
- version 3.13.8
* Fri Aug  3 2007 schubi@suse.de
- API for retrieving additional dependencies" solver/detail/Resolver.h
- Handle additional dependencies in the testcases
- Handle system and language dependencies in the testcases correctly.
- r 6418
* Thu Aug  2 2007 ma@suse.de
- Indicate changed pool content if /etc/sysconfig/storage USED_FS_LIST
  has changed. Resolver must discard any cached filesystem dependencies.
  (required for #271912)
- revision 6404
* Thu Aug  2 2007 ma@suse.de
- Indicate changed pool content to the resolver. (required for #271912)
- revision 6398
- version 3.13.7
* Thu Aug  2 2007 schubi@suse.de
- speedup error handling. Do not log ResolveInfo anymore. Set limit of 20
  problems. Bug 280387
- r 6378
- version 3.13.6
* Wed Aug  1 2007 ma@suse.de
- Added interface to install source packages via zypper.
- revision 6373
- version 3.13.5
* Tue Jul 31 2007 ma@suse.de
- Added package attributes Package::sourcePkgName and
  Package::sourcePkgEdition. Name and edition of the source
  rpm this package was built from.
- Added ZYpp::installSrcPackage to install a single source package.
- revision 6353
- version 3.13.4
* Tue Jul 31 2007 ma@suse.de
- Temorary files and directories created by makeSibling use the
  same protection as the original.
- revision 6344
- version 3.13.3
* Tue Jul 31 2007 schubi@suse.de
- Removed keepExtras from resolvePool. This will be handled
  in the solver internally now. #294727
- Checking if item really exists (#295544; ResolverInfoContainer.cc)
- revision 6317
- version 3.13.2
* Mon Jul 30 2007 ma@suse.de
- Remove tribool from RepoInfo's interface.
- revision 6301
- version 3.13.1
* Mon Jul 30 2007 ma@suse.de
- Fixed wrong media number reported by script, message and patch.
- Fixed script API to provide the scripts location on media (if not
  inlined).
- Introduced ScripProvider to make a script available on the local
  disk.
- revision 6288
- version 3.13.0
* Fri Jul 27 2007 jkupec@suse.cz
- don't request media chage if the media is not changeable (like
  e.g. http)
- revision 6271
- version 3.12.1
* Fri Jul 27 2007 dmacvicar@suse.de
- progress ticks for clean cache
- ZConfig: remove default from names.
- re enable reading cache callbacks
- ini parser without boost::regexp
  patch by dmueller (#152447)
* Fri Jul 27 2007 ma@suse.de
- Fixed package to provide the location media number. (#294496)
- revision 6263
* Fri Jul 27 2007 jkupec@suse.cz
- RepoFileReader - ignore empty url keys (baseurl, mirrorlist,
  gpgkey) instead of throwing bad url exception
- revision 6259
* Thu Jul 26 2007 kkaempf@suse.de
- Make clearing of extra dependencies/conflicts configurable when
  resolvePool(). Leave the default as before (clear extras).
  Bug # 294727
- revision 6233
- version 3.12.0
* Thu Jul 26 2007 dmacvicar@suse.de
- /var/lib/zypp/cache -> /var/cache/zypp
  (#292419)
- ini parser without boost::regexp, patch by dmueller
  (#152447)
* Wed Jul 25 2007 ma@suse.de
- Make temp directory configurable  via environment
  variable ZYPPTMPDIR.
- revision 6202
- version 3.11.11
* Tue Jul 24 2007 ma@suse.de
- Fixed bug in smart pointer comparison.
* Mon Jul 23 2007 ma@suse.de
- Fix failing rename of metadata download directories across
  filesystem boundaries.
* Fri Jul 20 2007 ma@suse.de
- Fixed malicious gettext include.
- Make ZConfig a singleton.
- revision 6123
* Thu Jul 19 2007 ma@suse.de
- Fixed repo::provideFile to set a deleter for downloaded files
  (#293004).
- revision 6094
- version 3.11.10
* Thu Jul 19 2007 ma@suse.de
- Query ByRepository now takes as well an alias.
* Wed Jul 18 2007 dmacvicar@suse.de
- fix retrieval of container attributes in cache
  (#292698)
* Wed Jul 18 2007 ma@suse.de
- Port zypp-query-pool (#292404)
- revision 6069
- version 3.11.9
* Wed Jul 18 2007 schubi@suse.de
- added new calls in Resolver.h: addRequire,addConflict
* Wed Jul 18 2007 ma@suse.de
- Fixed IniParser to allow '=' in values (#292669)
- revision 6063
* Wed Jul 18 2007 dmacvicar@suse.de
- allow / in alias (#292628)
* Wed Jul 18 2007 ma@suse.de
- Fixed repo::provideFile to throw on error.
- Fixed ResolvableQuery to use 0 as default for non existing
  numerical values.
- revision 6058
* Tue Jul 17 2007 ma@suse.de
- Fixed OnMediLocation to use safe defaults. Added setLocaltion and
  additional ctor for convenience.
- revision 6047
* Tue Jul 17 2007 schubi@suse.de
- Evalute update canditate:
  Take canditates only which are really installable. Bug 292077
  r 6034
* Mon Jul 16 2007 jkupec@suse.cz
- fixed some tribool bugs in RepoInfo
- revision 6022
* Mon Jul 16 2007 dmacvicar@suse.de
- fix reading of non existant repo
- r6018
- first submission to stable
- fix keywords parsing in susetags parser
- version 3.11.8
* Wed Jul 11 2007 jkupec@suse.cz
- make resolvable query complete exceptionless with the database
- test that packages have some attributes
- disable progress adaptor for now
- revision 5977
- version 3.11.7
* Wed Jul 11 2007 ma@suse.de
- fixed unresolved symbols
- revision 5972
- version 3.11.6
* Wed Jul 11 2007 ma@suse.de
- fixed TranslatedText creating unwanted entries.
- fixed capability processing
- revision 5964
- version 3.11.5
* Tue Jul 10 2007 jkupec@suse.cz
- MediaSetAccess::release() added
- Use attachDesiredMedia in MediaProducts
- Progress reporting improved
- revision 5959
- version 3.11.4
* Tue Jul 10 2007 ma@suse.de
- fixed parsing translated texts.
- added source packages.
- revision 5947
- version 3.11.3
* Tue Jul 10 2007 jkupec@suse.cz
- repo callbacks fixed
- Fixed YUM parser progress reporting
- Added CombinedProgressData
- make RepoImpl::resolvables() load lazy
- MediaProducts added for scanning products file
- Implement cache schema versioning and automatic invalidation of
  cache when schema changes
- revision 5942
- version 3.11.2
* Fri Jul  6 2007 ma@suse.de
- Propagate pools repository_iterator to the UI
- revision 5911
- version 3.11.1
* Thu Jul  5 2007 ma@suse.de
- Package::location is now returns an OnMediaLocation
- archivesize() renamed to downloadSize()
- Allow to iterate all Repositories that contribute
  Resolvables to the Pool.
- MediaSetAccess::provideDir added
- remove useless url check
- add old-api-style wrapper
- Add MediaProducts class
- revision 5892
- version 3.11.0
* Thu Jul  5 2007 schubi@suse.de
- function isInstalledBy/installs
  Added an initial installation flag which shows if the item has been
  triggered for installation, or the dependency is already satisfied.
- Revision 5884
- Version 3.4.0
* Tue Jul  3 2007 jkupec@suse.cz
- removed unused %%{prefix}/lib/zypp from %%files in spec file
- revision 5870
* Tue Jul  3 2007 jkupec@suse.cz
- Old API (SourceManager, metadata parsers) dropped in favor of the
  new refactored ones (RepoManager, RepoParser(s), cache subtree,
  repo subtree).
- Some new API improvements.
- revision 5868
- version 3.10.0 (bumped minor to 10 to indicate refactoring branch)
* Fri Jun 22 2007 schubi@suse.de
- New API calls which provides more information about one
  resolvable after a solverrun:
  isInstalledBy (const PoolItem_Ref item);
  installs (const PoolItem_Ref item);
- Revision 5835
* Thu Jun 21 2007 adrian@suse.de
- fix changelog entry order
* Wed Jun 20 2007 schubi@suse.de
- Ignore conflicting items which are uninstallable
- Create a "needed by" info if a requirement is still fulfilled.
- Allow only one needed_by and needed_by_capability in QueueItemInstall
- Added capability and type (REQUIRE, RECOMMEND,....) to
  ResolverInfoNeededBy
- Evaluate ResolverInfoNeededBy for more information in the error
  messages
- Enlarge detail description in the error messages
- Revision 5807
* Tue Jun 19 2007 ma@suse.de
- Fixes for gcc-4.2
- revision 5786
- version 3.3.1
* Mon Jun 18 2007 mvidner@suse.cz
- fixed so versioning from libtool to cmake
- 3.3.0
* Mon Jun 18 2007 dmacvicar@suse.de
- Use gpg2 instead of gpg for keyring and make
  the package depend on it (#284211)
* Mon Jun 11 2007 schubi@suse.de
- Required kmp packges FOR EACH installed/to_be_installed kernel will be installed.
  New dependency "packageand(foo:bar)" which provides an AND dependency by
  injecting a supplement/freshen.
  e.G. package novell-cluster-services-kmp-smp
  supplements: packageand(kernel-smp:novell-cluster-services-kmp)
  Bug 255011
- Dont check for architecture changes in atoms (#266178)
- Revision 5720
* Wed May 23 2007 ma@suse.de
- Fixed package-manager script (#275847)
- revision 5614
* Wed May 23 2007 schubi@suse.de
- fixed cmake
- version 3.2.2
* Wed May 23 2007 schubi@suse.de
- Reduced logging in order to speedup solving Bug 275100
- revision 5603
- version 3.2.1
* Tue May 15 2007 ma@suse.de
- Fix excess calls to releaseFile. (#274357)
- revision 5545
* Wed May  9 2007 dmacvicar@suse.de
- Fix importing keys into rpm. (#270125)
- r5527
* Wed Apr 18 2007 ma@suse.de
- Support filesystem dependencies to add needed filesystem RPMs
  automatically (Fate 301966).
- revision 5404
- version 3.2.0
* Mon Apr 16 2007 jkupec@suse.cz
- avoiding attaching media where not needed (#263207)
- r5381
* Fri Apr 13 2007 dmacvicar@suse.de
- fix FileCap with attributes
- r5376
* Thu Apr 12 2007 ma@suse.de
- Fixed computation of install order. Take requirements of
  an installed packages uninstall scripts into account, if
  the package is updated. (#258682)
- revision 5349
- version 3.1.1
* Wed Apr 11 2007 ma@suse.de
- Parse and provide package keywords. (Fate 120368)
- revision 5338
- version 3.1.0
* Thu Apr  5 2007 schubi@suse.de
- Upgrade: Do NOT delete packages which have unresolved dependencies -->
  Ask the user. Bug 258322
- revision 5305
- version 3.0.3
* Wed Apr  4 2007 ma@suse.de
- Fix restoring of Sources id root prefix is used. (#238165)
- revision 5299
- version 3.0.2
* Wed Apr  4 2007 jkupec@suse.cz
- MediaManager::attachDesiredMedia() added to support multiple
  (CD/DVD) drives (fate #3974)
- r5296
* Wed Mar 14 2007 schubi@suse.de
- If there is no valid solver result and NOT all resolvables ( other
  architecture) has been regarded, let the user decide making a new
  solver run with ALL available resolvables. Bug 223440
- reducing logging (error -> debug)  bug 252921
- Revision 5219
* Fri Mar  9 2007 ma@suse.de
- Allow configuration of trusted vendors via
  /var/lib/zypp/db/trustedVendors. (#186636)
- revision 5194
- version 3.0.1
* Wed Mar  7 2007 dmacvicar@suse.de
- libzypp-devel -> libzypp requirement is not versioned
  (#251086)
- r5181
* Tue Mar  6 2007 schubi@suse.de
- Using already existing valid solver results for further solver runs.
  (partiell solving)
- r5169
* Fri Mar  2 2007 dmacvicar@suse.de
- fix link order
- r5165
* Tue Feb 27 2007 dmacvicar@suse.de
- merging from 10.2 / SP1
- #247459 ftp probing
  denied == dont exists in ftp
- r5124
* Tue Feb 27 2007 schubi@suse.de
- Merging solver related stuff from SuSE-Linux-10_2-Branch ( till r5111):
- Simultaneouqusly establishing of items which are conflicting eachother is
  useless. So only one will be established. Fixed in QueueItemInstall.cc
  Bug 243595
- Added new upgrade options to fine tune version and patch handling.
  (F301990)
- The context of establishPool will be stored in Resolver and will be
  regarded for the next solver run everytime. So it will be not reset by
  any solver run anymore.
  bug 191810 ( A broken patch will not be installed again)
* Fri Feb 23 2007 jkupec@suse.cz
- adding sotf,timeo=X nfs mount options by default (#235211)
- r5093
* Fri Feb 23 2007 jkupec@suse.cz
- support for HTTP authentication prompt added (#190609)
- fixed problem with empty path in URL
  in MediaCurl::doGetFileCopy()
- r5085
* Mon Feb 12 2007 jkupec@suse.cz
- Merged revisions 4926-4993,4995,4998-5006 via svnmerge from
  SuSE-Linux-10_2-Branch
- verifySystem: Regarding patterns too. Bug 239750 (schubi)
- verifySystem: The result will be set to APPL_HIGH, so it will be not
  reset by a second "normal" solver run. #239281 (schubi)
- yast2 reports invalid URL as 'unknown source type'
  (#209961) (dmacvicar)
- Added freshen language dependency in supplemements too if there is no
  entry in supplements.
  [#240617];IPA fonts are not installed even if select Japanese
  language (schubi)
- Setting allowed authentication methods to "basic,digest" if none
  provided in URL (#243006) (jkupec)
- Stopping after 50 valid solver results. Anymore would be useless. Bug
  243595 (schubi)
- r 5007
* Mon Feb 12 2007 mvidner@suse.cz
- package-manager: use a generic su script from XDG (#235303, #244442)
* Fri Feb  9 2007 jkupec@suse.cz
- Setting allowed authentication methods to "basic,digest" if none
  provided in URL (#243006)
- fixed gettext and rpath problems in configure.ac and Makefile.cvs
  (mvidner)
- r4999
* Wed Feb  7 2007 jkupec@suse.cz
- MediaCurlException::dumpOn() adjusted for ncurses dialogue
  (#222602)
- 4984
* Mon Jan 29 2007 dmacvicar@suse.de
- Merged revisions 4907-4926 from SuSE-Linux-10_2-Branch
- update packages: changing architecture is only valid while an
  system update and NOT while an update via a patch. Last fix does
  not fit for every case.
  Bug 230685
- Patch has selected not the concerning package for update but
  a package which has provided the required dependencies too.
  Algorithmus: If there are exactly two providers which differ in architecture
  prefer the better arch.
  Fix: Regarding NVRA too. ( only if equal )
  Bug 238284
- Download only English and Local translation
  (#208457)
- Added solver parameter:
  tryAllPossibilities: regarding every solver branch ( not only
    branches with e.G. best architectures
  preferHighestVersion: Prefer solver results which have a higher
    version number.
  Bug #238087
- update packages: changing architecture is only valid while an
  system update and NOT while an update via a patch.
  Bug 230685 - x86_64 MozillaFirefox binaries in security update
  repository
  Fix of version 2.11.2 has not worked if the first founded item
  had had another architecture.
- r4927
* Wed Jan 24 2007 lslezak@suse.cz
- added ZYpp::getPartitions() - return the partitinoning
* Wed Jan 24 2007 dmacvicar@suse.de
- Merged revisions 4705-4906 via svnmerge from SuSE-Linux-10_2-Branch
- Corrupt download cannot be skipped
  (#217425 and #224216)
- Enable package read ahead/caching in commit per default to reduce
  interactive media changes. If the environment variable
  ZYPP_COMMIT_NO_PACKAGE_CACHE is set, caching will be disabled. (F100182)
- added parameter not to reset resolver results while calling
  freshen pool Bug: 235761
- Prepare package read ahead/caching of packages in commit. Adatped the
  workflow. Caching details are now hidden inside CommitPackageCache.
  The current implementation still performs no read ahead. (for F100182)
- Skip invalid or broken rpm database entries. (#231211)
- verifySystem: check if the solution is valid after calling freshenPool()
  Bug: 235761
- Added own call for Resolver::verifySystem with additional
  hardware/language check in order to keep binary compatibility
  Fate #301224
- Rpm requires additional quoting of special chars in filenames.
  (#233967)
- Resolver::verifySystem checks for new hardware now by calling
  freshenPool. This is configureable. Fate #301224
- merged texts from proofread
- Don't consider patch/delta rpms if package architecture changes.
  (#231254)
- update packages: changing architecture is only valid while an
  system update and NOT while an update via a patch.
  Bug 230685 - x86_64 MozillaFirefox binaries in security update repository
- verifySystem: Do only regard items which will be on the system after the
  commit. Fate 301178
- feature #301369
  Import listed GPG Keys from an trusted installation source
- fix return call in new xml parser
- Enable system resolvables in Helix parser (Revision 4787)
- deptestomatic:
  Resetting transaction with the correct call;
  bugfix; Added kind in keep state (Revision 4788)
- Wrong behaviour in soft install/uninstall. --> Setting Transact with
  soft (Revision 4789)
- New call added: maySetToBeUninstalledSoft (Revision 4789)
  Both are only functions for the solver (Revision 4789)
- Resetting "by causer" in order to distinguish from state
  "keep by user". ( function setLock in order to remove lock)
  (Revision 4789)
- Better fix for Bug 217574: Checking if the resolveable CAN be deleted soft
  in QueueItemUninstall.cc (Revision 4790)
- Regarding "keep state by user". So avoiding "reselecting" by
  other requirements.
  Give a corresponding problem solution if a resolvable satisfy
  a dependency, but has been set to keep by the user.
  Bug : 222531 (Revision 4791)
- Allow to disable autoprotection of foreign vendor items. Required
  in zmd-backend. (F301735).
- use sqlite-zmd if using > 10.2 in spec. Use the one available
  durin compile.
- Item could has already been selected to soft uninstall (e.G. remove
  pattern which recommend this item ). Do not throw an exception anymore.
  bug#225278
- Added syscontent::Reader: Parse serialized set of ResObjects.
  (for F300729)
- If there has already been selected another item by the solver (e.g. from
  another source) we will take thatone in order to avoid parallel
  installation and there concerning error messages.
  Bug 224698
- In order to handle conflicting resolvable we try to update the
  conflicting item. While evaluating these canditates an already selected
  candidate will not be regarded. So it could be that an older package
  will be selected for update although a newer has already been selected. Revision 4765
- Conflicting items: The resolvable will be obsoleted by another. So it is useless finding an
  update candidate and evaluate additional branches.
- r4907
* Mon Dec  4 2006 mt@suse.de
- Improved realpath() wrapper in media handler class (#222521).
- revision 4758
* Thu Nov 30 2006 ma@suse.de
- version 3.0.0 (2.x.x now in SuSE-Linux-10_2-Branch)
- revision 4713
* Wed Nov 29 2006 dmacvicar@suse.de
- use sqlite-zmd package for the non yet shipped zypp2/ stuff
  because backend uses this sqlite and it is no fun to
  install one and the other to develop (as the -devel packages)
  conflict.
- add cmake support for building zypp/ lib.
  TODO: soinfo, compile testcases, devel, zypp2,docs
  find rpm, curl and others.
- dont serialize interactive, as it is
  calculated now.
  (it was already fixed as we don't reimplement
  the method, but we still serialized, parsed)
- r4709
* Tue Nov 28 2006 ma@suse.de
- fixed Patch::interactive to return true as well, if the patch
  itself has a licence. (#224192)
- revision 4702
- version 2.9.2
* Tue Nov 28 2006 mt@suse.de
- Added search for /sbin/vol_id tool - that is in /lib/udev/vol_id
  on the installation image (#213852).
- revision 4700
* Tue Nov 28 2006 schubi@suse.de
- Avoid duplicate pool entries; Bug 223750; second part of the fix
- r4698
- Version 2.9.1
* Mon Nov 27 2006 schubi@suse.de
- Pool has multi instances of an item in the pool. Reduced this error
  to items which are identically at least. #217574 and #223750
- r4695
* Mon Nov 27 2006 dmacvicar@suse.de
- replace spaces to underscores in product names
- 2.8.7
- r4688
* Mon Nov 27 2006 dmacvicar@suse.de
- Mark some strings for translation (#219783 need it)
- r4682
* Mon Nov 27 2006 mt@suse.de
- Added translations marks to hal, url and mutex exceptions (#23771)
- revision 4680
* Wed Nov 22 2006 dmacvicar@suse.de
- don't make libzypp-devel depend on sqlite-devel as
  headers from zypp2 are not installed yet
- r4663
* Wed Nov 22 2006 ma@suse.de
- Return an error if fork failed. (#204807)
- Make Script execution abortable by user request. (#212949, F100233)
- revision 4660
- version 2.8.6
* Tue Nov 21 2006 mvidner@suse.cz
- Added package-manager wrapper script, with icon and .desktop (#222757).
  (Used by gnome-main-menu)
- version 2.8.5
- r4640
* Tue Nov 21 2006 mt@suse.de
- Fixed target/hal - one more dbus_connection_close found (#216035)
- revision 4636
- version 2.8.4
* Mon Nov 20 2006 schubi@suse.de
- translation added
  rev 4630
  version 2.8.3
* Mon Nov 20 2006 ma@suse.de
- Process obsoletes when installing non-package objects. (#217352)
- revision 4621
- version 2.8.2
* Fri Nov 17 2006 mt@suse.de
- Implemented volume device check using /sbin/vol_id (#213852).
- Revision 4619
* Fri Nov 17 2006 schubi@suse.de
- new translation added
* Fri Nov 17 2006 mt@suse.de
- Implemented an reuse of already existing foreign CD/DVD mount points
  (e.g. automounted) - depends on REUSE_FOREIGN_MOUNTS flag (#220206).
- Added a fallback check of the volume.mount_point HAL property to
  isAutoMountedMedia(); info.hal_mount.created_mount_point seems
  to be not avaliable in newer HAL versions (on 10.2).
- Revision 4615
- Version 2.8.1
* Fri Nov 17 2006 ma@suse.de
- removed unused methods from Patch and PatchImplIf. Provided
  reasonable default implementation for Patch::interactive.
  (#221476).
- revision 4610
- Version 2.8.0
* Thu Nov 16 2006 dmacvicar@suse.de
- Handle media eject failures (#216545)
- r4606
* Wed Nov 15 2006 ma@suse.de
- Reimplemented RpmDb::checkPackage using librpm API instead
  of parsing "rpm --checksig" output. (#163202)
- Version 2.7.4
- revision 4600
* Wed Nov 15 2006 schubi@suse.de
- NEW behaviour of the solver:
  Obsolete virtual provides. E.G.:
  Installed:
  - ----------
  Name:           test-1.0-0
  Name:           moretest-1.0-0
  Provides:       test
  To be installed
  - -----------------
  Name:           nomoretest-1.0-0
  Obsoletes:      test
  Result
  - -------
  test-1.0-0 AND  moretest-1.0-0 will be deleted. In former versions only
  test-1.0-0 had been deleted. Bug 220999
- Translations added
  Version 2.7.3
  rev 4593
* Tue Nov 14 2006 schubi@suse.de
- Bugfix in generating solver testcases:
  - added kind of capabilities in description file
  - removed unneded channel from uninstall in command file
* Mon Nov 13 2006 mt@suse.de
- Try to call /bin/eject utility if the eject-ioctl fails.
- r4568
* Mon Nov 13 2006 dmacvicar@suse.de
- ignore empty capabilities
- r4565
* Fri Nov 10 2006 dmacvicar@suse.de
- make progress strings translatable (#219783)
- r4556
* Tue Nov  7 2006 schubi@suse.de
-  While deleting a selection all concerning recommended
  packages will be deleted too.
  BUT those packages should not be deleted which have been
  set to KEEP by the user. bug 217574
  rev 4526
  VERSION: 2.7.2
* Tue Nov  7 2006 schubi@suse.de
- Makefile in zypp2 fixed
  Revision 4520
* Tue Nov  7 2006 schubi@suse.de
- Translations added
  Revision 4514
  VERSION: 2.7.1
* Mon Nov  6 2006 dmacvicar@suse.de
- Make the parser more strict, rejecting broken sources
  but showing the error line.
  Last fix making the parser relax would break multitag
  descriptions with empty lines, now we check dependencies
  at a higher level. (reference #160607)
- r4501
* Fri Nov  3 2006 schubi@suse.de
- New problem solution added: Unlock ALL resovables in order to speed up
  problem solution. Bug 206453
* Fri Nov  3 2006 schubi@suse.de
- Translations added
* Thu Nov  2 2006 mt@suse.de
- Fixed target/hal - removed dbus_connection_close calls, because
  the connections are shared; unref the ref-counted handle only.
  (#216035)
- r4442
* Thu Nov  2 2006 dmacvicar@suse.de
- skipping unreachable packages won't work
  (#215445)
- r4468
* Wed Oct 25 2006 dmacvicar@suse.de
- (#213793) Target store fails to recreate stored install-time (other
  Date and ByteCount values as well)
- skip comments and blank lines in multilists
  fixes (#214877) - zen-updater is not installed by default
- Automatically fix broken products when reading
  the product database.
  still pending: honour the read-only flag
  Changes to make this possible include
  using read_dir instead of boost directory
  iterator.
* Wed Oct 25 2006 schubi@suse.de
- added new class for generating solver testcases:
  Testcase
* Wed Oct 25 2006 ma@suse.de
- Finalized ui::PatternContents. (F301229)
- version 2.7.0
- revision 4413
* Wed Oct 25 2006 mvidner@suse.cz
- Moved zypper and zypp-checkpatches(-wrapper) to zypper.rpm
- version 2.6.0
* Tue Oct 24 2006 ma@suse.de
- Added ui::PatternContents: Helper class that will compute a patterns
  expanded install_packages set. (UI interface for F301229)
- revision 4387
* Tue Oct 24 2006 mvidner@suse.cz
- removed the last reference to /usr/lib64 to fix the build
* Mon Oct 23 2006 mvidner@suse.cz
- added "zypper info" (jkupec)
- version 2.5.2
* Mon Oct 23 2006 dmacvicar@suse.de
- fix rpm db timestamp
- add extra urls and optional urls to product API
- r4378
* Fri Oct 20 2006 mvidner@suse.cz
- zypper: nicer progress reports, with or without --verbose.
* Fri Oct 20 2006 ma@suse.de
- Fixed reloading of target data after commit. Broken since
  rev 3880.
- version 2.5.1
- revision 4365
* Fri Oct 20 2006 dmacvicar@suse.de
- put query-pool in /usr/lib/zypp and not lib64
- r4363
* Fri Oct 20 2006 dmacvicar@suse.de
- revert keyring changes, causes endless loop (obvious)
- add dist-product information, adapt store
- version 2.5.0
- r4355
* Fri Oct 20 2006 ma@suse.de
- zypp-query-pool: For products show additionally distributionName
  and distributionEdition. (required by #205392)
- revision 4349
* Fri Oct 20 2006 ma@suse.de
- Add accessor for Product distributionName and distributionEdition.
  (required by #205392)
- revision 4347
* Thu Oct 19 2006 dmacvicar@suse.de
- added test case for KeyRing
- fire trustedKeyAdded in all calls to import trusted key
  not only in signature check workflow.
- r4342
* Thu Oct 19 2006 mvidner@suse.cz
- zypper update: implemented minimal version (patches only)
- zypper list-updates: changed default type from package to patch,
  consider patches affecting the package manager separately
* Thu Oct 19 2006 dmacvicar@suse.de
- version 2.4.1
- r4338
* Thu Oct 19 2006 dmacvicar@suse.de
- add zypp-query-pool, so registration doesn't depend on
  libzypp-zmd-backend being installed. Will remove from
  backend when suseregister gets updated.
* Thu Oct 19 2006 schwab@suse.de
- Make sure config.rpath is present.
* Wed Oct 18 2006 mvidner@suse.cz
- zypper search: fixed uninitialized members that made all searches
  exact and case sensitve
* Wed Oct 18 2006 dmacvicar@suse.de
- zypp-checkpatches, write in the right file
- r4328
* Wed Oct 18 2006 schubi@suse.de
- Install resolvables although they are unneeded
  if they have NOT the kind patch/atoms
  Bug 210538 - freshens/supplements does not work with patterns
- r4326
* Tue Oct 17 2006 mvidner@suse.cz
- zypper service-add -r http://example.org/foo.repo (F#300641).
* Tue Oct 17 2006 dmacvicar@suse.de
- zypp-checkpatches:
  save version of the generated xml to
  regenerate it if it changes.
  save a random token in case of error to
  force recreating xml file
- r4321
* Tue Oct 17 2006 dmacvicar@suse.de
- remove permissions for zypp checkpatches from spec
- r4318
* Tue Oct 17 2006 dmacvicar@suse.de
- registration fails because of wrong product data
  (#205392)
  use DISTPRODUCT,DISTVERSION to create the product
  resolvable. have this resolvable provide
  PRODUCT = VERSION
- r4312
* Mon Oct 16 2006 mvidner@suse.cz
- zypper service-add -r ./foo.repo (F#300641).
* Mon Oct 16 2006 jkupec@suse.cz
- zypper: added case-sensitive search, search in descriptions and
  summaries, search by resolvable type, substring and word
  matching, support for wildcards
- Revision 4303
* Mon Oct 16 2006 mvidner@suse.cz
- Prevent the user from sending signals to zypp-checkpatches-wrapper
  (#211286).
* Mon Oct 16 2006 schubi@suse.de
- Dont incomplete an uninstalled resolvable, even not when establishing.
  Incomplete only makes sense for installed resolvables (when they have broken
  deps), for patches (because they are needed) and for atoms (because they are
  used during patch calculation)
  Bug 198379
- Do not branch for packages with the same NVE but different architectures.
  Take the best architecture.
* Fri Oct 13 2006 dmacvicar@suse.de
- implement rename source in sourcemanager
- r4286
* Fri Oct 13 2006 dmacvicar@suse.de
- YaST sources: set alias to product summary if empty
- show alias on logs.
- r4281
* Thu Oct 12 2006 dmacvicar@suse.de
- version 2.4.0 (bin incompat due to callback fixes)
- r4272
* Thu Oct 12 2006 ma@suse.de
- Provide additional solver status information to the UI.
  (#162164,F301272)
- Fixed UI satus computation in presence of multiple available
  candidates.
- revision 4264
- version 2.3.1
* Thu Oct 12 2006 dmacvicar@suse.de
- remove const in MediaChangeReport requestMedia that
  broke cd changing.
- r4262
* Wed Oct 11 2006 mvidner@suse.cz
- zypper: added search (jkupec)
- removed the suid bit from zypp-checkpatches-wrapper so that the
  build passes until permissions.rpm is updated (~#211286).
- r4253
* Tue Oct 10 2006 dmacvicar@suse.de
- Log microseconds if ZYPP_PROFILING env var is enabled.
- r4252
* Mon Oct  9 2006 dmacvicar@suse.de
- YaST sources:
  Factory cannot be set with 'refresh' enabled
  (#204957)
- get rid of some const bool signatures in Source classes
- r4247
* Mon Oct  9 2006 mvidner@suse.cz
- Added zypp-checkpatches and a suid-root zypp-checkpatches-wrapper.
* Fri Oct  6 2006 schubi@suse.de
- select the best solution: prefering the total amount of install/update
  packages BEFORE source preferences. Bug 208784
* Fri Oct  6 2006 dmacvicar@suse.de
- Introduce a method to see if a source supports a
  kind of resolvable at that time, so we can
  init a YUM source like factory but avoid parsing
  it if it contains no patches.
- add TODO
- zypp-checkpatches xml output
- r4235
* Mon Oct  2 2006 mvidner@suse.cz
- added a CLI preview: zypper
- revision 4214
- version 2.2.3
* Mon Oct  2 2006 dmacvicar@suse.de
- FATE #100165:
  Make Content File Aware of Different Architectures
  expand %%a in release notes with architecture
* Fri Sep 29 2006 ma@suse.de
- Extended pattern parser to support includes/extends tags as hint
  for the IO. (F301229)
- revision 4199
- version 2.2.2
* Fri Sep 29 2006 ma@suse.de
- Enabled sending of ScriptResolvableReport.
- Changed ScriptResolvableReport::start to send local path
  of script to be executed.
- revision 4190
- version 2.2.1
* Wed Sep 27 2006 ma@suse.de
- Added ScriptResolvableReport. Callbacks triggered on script
  execution during commit. (F100233)
- revision 4187
- version 2.2.0
* Mon Sep 25 2006 mvidner@suse.cz
- fix: Url::getRegisteredSchemes() would always return nothing
* Fri Sep 22 2006 jkupec@suse.cz
- Made the build dependency on gettext-devel explicit
* Tue Sep 19 2006 jsrain@suse.cz
- adapted multi-media YUM sources according to official YUM
  specification (F300743)
* Mon Sep 18 2006 lslezak@suse.cz
- use RPM_OPT_FLAGS (meissner@suse.de)
* Mon Sep 18 2006 lslezak@suse.cz
- SourceFactory::createFrom() - don't loose url,...
- r4160
* Mon Sep 18 2006 kkaempf@suse.de
- reduce logging in ResolvableImpl.cc
- rev 4157
* Thu Sep 14 2006 schubi@suse.de
- Replaced requirementIsMet by requirementIsInstalledOrUnneeded
  in QueueItemInstall and QueueItemRequire
  Bug 192535/204913
  removed fix:Thu Sep  7 18:31:46 CEST 2006 - schubi@suse.de
* Thu Sep 14 2006 lslezak@suse.cz
- fixed SourceFactory::createFrom() - don't loose alias,
  cachedir,... parameters
* Thu Sep 14 2006 mvidner@suse.cz
- Use RPM Enhances only if detected at configure time, to allow
  compilation with older rpm.
- callback params: use const string & instead of string (dmacvicar)
* Thu Sep  7 2006 schubi@suse.de
- Do not regarding SATISFIED (regarding UNNEEDED) in isPresent if it is
  a package/script/message
  Bug: 192535
* Thu Sep  7 2006 dmacvicar@suse.de
- add Source_Ref::checksum() which in combination with
  timestamp can give an idea of a source change.
- r4106
* Thu Sep  7 2006 mvidner@suse.cz
- Implemented fgzstreambuf::compressed_tell and fXstream::getbuf to
  enable progress reporting on compressed streams.
* Wed Sep  6 2006 dmacvicar@suse.de
- better error propagation
- r4096
* Tue Sep  5 2006 mt@suse.de
- Removed libblkid dependency - the workaround using libblkid to
  check filesystem on XEN vbd mapped devices is obsolete, because
  the info is avaliable via /dev/disk/by-label link now. (#197107)
- revision 4087
* Thu Aug 31 2006 ma@suse.de
- PackageProvider: Fixed broken retry. (#202163)
- revision 4071
* Wed Aug 30 2006 ma@suse.de
- Fixed RpmDb::makePackageFromHeader: Catch NULL Header passed as argument and refuse
  to create a Package from a source package header.
- Added method Pathname::extension: Return all of the characters in name
  after and including the last dot in the last element of name.
- PlaindirImpl: Disable rpm signature verification when scaning a directory for
  rpms. Otherwise we'd need access to the rpm database to get the keys.
- revision 4069
* Wed Aug 30 2006 schubi@suse.de
- Do not regarding SATISFIED/UNNEEDED in isPresent if it is
  a package/script/message
  Bug: 192535
* Wed Aug 30 2006 ma@suse.de
- Speedup computation of number of rpm database entries.
- revision 4058
* Tue Aug 29 2006 schubi@suse.de
- Fixed endless loop in transactResObject
  Bug 198095 - YaST2 Installaler crashes when selecting Gnome pattern to a KDE installation
* Tue Aug 29 2006 dmacvicar@suse.de
- fix some testcases for tar file parser changes
- r4045
* Tue Aug 29 2006 dmacvicar@suse.de
- missing includes
- clean old callbacks
- r4041
* Fri Aug 25 2006 schubi@suse.de
- zyppPattern->install_packages returns SUGGESTED package too.
  Bug 201476
  Revision 4036
* Fri Aug 25 2006 schubi@suse.de
- New behaviour in the solver: try with 'best' package first, try with 'all'
  packages if this fails.
  Bug :Bug 191983
* Fri Aug 25 2006 dmacvicar@suse.de
- libzypp 2.1.0
- bump version due to incompatible callback changes in KeyRing
  Sources
* Thu Aug 24 2006 dmacvicar@suse.de
- new keyring callbacks
- separate trust key from import key
- use PublicKey class instead of params, to be able
  to add more info like photos later (pending #181682)
- update zmart with those callbacks.
- better error handling (Exception types)
- make tmp file names more readable depending on the context
- r4026
* Tue Aug 22 2006 dmacvicar@suse.de
- decouple probing from source creation, using the new
  media test for existence functions.
- r4019
* Tue Aug 22 2006 mt@suse.de
- Fixed getDoesFileExist to reset the transfer range
- Added logging of curl debug messages to the zypp log.
  The env var ZYPP_MEDIA_CURL_DEBUG=1 logs curl infos,
  ZYPP_MEDIA_CURL_DEBUG=2 logs the in/out headers.
- r4018
* Fri Aug 18 2006 kkaempf@suse.de
- remove the /etc/sysconfig/zypp:REWRITE_KERNEL_DEPS = yes check;
  see rev 3810 below. (#190163)
- rev 3998
* Thu Aug 17 2006 dmacvicar@suse.de
- fix uninstalling of atoms (noop)
- r3995
* Wed Aug 16 2006 dmacvicar@suse.de
- Implement initial verson of Media
  doesFileExist, for future source probing.
- r3984
* Tue Aug 15 2006 dmacvicar@suse.de
- more dbus_connection_close fixes
- r3974
* Tue Aug 15 2006 kkaempf@suse.de
- clean up 'incomplete' handling in QueueItemEstablish.
- rev 3973.
* Tue Aug 15 2006 kkaempf@suse.de
- Don't set 'incomplete' for uninstalled patterns or products.
  (#198379)
- rev 3970.
* Mon Aug 14 2006 schubi@suse.de
- Added new API calls:
  setAdditionalProvide
  setAdditionalConflict
  setAdditionalRequire
* Mon Aug 14 2006 dmacvicar@suse.de
- don't link examples to testsuite library.
* Sat Aug 12 2006 schwab@suse.de
- Disable profiling to work around compiler bug.
* Fri Aug 11 2006 dmacvicar@suse.de
- forward port 3924:3939
- Add explicit finish callbacks for subtasks during ProvidePackage
  to avoid UI confusion.
- rev3957
* Fri Aug 11 2006 dmacvicar@suse.de
- Introduce examples/
- fix some svn ignores
- fix compilation. Use: dbus_connection_close
- rev 3943
* Thu Aug 10 2006 dmacvicar@suse.de
- Initial support for plain directory with rpms as source
- r3935
* Tue Aug  8 2006 dmacvicar@suse.de
- Move the target query by kind function to
  a iterator, so we dont make a copy of the restore
  the iterator works loading by demand too
* Mon Aug  7 2006 dmacvicar@suse.de
- rename the new initTarget to initializeTarget,
  leave the old one as is, but deprecate it.
- r3903
* Mon Aug  7 2006 dmacvicar@suse.de
- forward port from SLES10 branch , till 3888
- Prefer to use available DeltaRpm or PatchRpm instead of downloading
  full packages. (#168844)
- rpmdb : Do not use the deprecated POSIX API, but boost::regex
- version 2.0.0
- rev 3893
* Fri Aug  4 2006 dmacvicar@suse.de
- Separate target init from adding resolvables, getting rid of the
  uggly bool flag.
- dont clear the store each time Target::resolvables is called
- Load target resolvables on demand by kind, keep them cached later
- add Target::resolvablesByKind(kind) to allow query specific kind
  without reading all kinds. Used to port TargetProduct, which
  was reading the whole rpm database only to displayy base product
  name in YaST help.
- commit to pkg-bindings and packager will follow.
- jsrain will port more yast stuff, especially inst_source which
  startup time should by reduced by half afterwards.
- rev 3880
* Tue Aug  1 2006 dmacvicar@suse.de
- forward port:
  rev 3786 fix to stalle tmpfiles broke patches.
  SLES was released with this broken. 10.1 has a blocked
  zypp update because this.
  Attempt to fix this. (#192535)
- fix configure.ac sqlite-source build path
- rev 3858
* Fri Jul 21 2006 dmacvicar@suse.de
- link correctly
* Wed Jul 19 2006 dmacvicar@suse.de
- dont link sqlite in the main lib.
- rev 3826
* Tue Jul 18 2006 dmacvicar@suse.de
- susetags: parse product parser regexp only once
- parse yum factory 5 sec. (from 30) faster using
  another string find algorithm
- rev 3824
* Tue Jul 18 2006 dmacvicar@suse.de
- Digest: Don't read the stream character wise but reading blocks,
  as advised by matz profiling.
- r3819
* Mon Jul 17 2006 ma@suse.de
- Add "openSUSE", "ATI Technologies Inc." and "Nvidia" to
  trusted vendors. (#189573)
- revision 3804
* Thu Jul 13 2006 dmacvicar@suse.de
- backport fix for stalle tmpfile (#191311)
- rev 3788
* Wed Jun 28 2006 mt@suse.de
- deactivated media manager code that was disabling the
  automounter (#172419)
- rev 3724
* Mon Jun 26 2006 dmacvicar@suse.de
- fix autorefresh (#186115)
- revision 3708
* Fri Jun 23 2006 ma@suse.de
- forward port from SLE branch
- Set default permission for logfiles to 0640. (#187044)
- revision 3696
* Thu Jun 22 2006 ma@suse.de
- forward port from SLE branch
- Fixed installation of SP or Add-On product switching to media 2
  too early. (#186607)
- revision 3691
* Wed Jun 21 2006 dmacvicar@suse.de
- forward port from SLE branch
- Strip self provides without edition in Resolvable ctor.
  (#186079)
- Source::provideResolvables not implemented in yum source type.
  Product not set for packages that are available from update source
  (#186920)
- Hook modalias() supplements without package to "kernel" (#184840)
- Allow on-demand SourceManager::restore() (#186678)
- Hook modalias() supplements without package to "kernel" (#184840)
- rev 3676
* Mon Jun 19 2006 mt@suse.de
- Fix adding resolving of path names for mount points (#181606)
- rev 3658
* Mon Jun 19 2006 dmacvicar@suse.de
- merge download algorithm and refactoring from branch
  (#181204)
* Thu Jun 15 2006 mvidner@suse.cz
- autodocs: use find+xargs to overcome command length limit,
  do not call doxygen unnecessarily (#185334).
- rev 3645
* Thu Jun 15 2006 kkaempf@suse.de
- Dont use getZYpp in static constructor (#185198)
  Bugfix #178292 was wrong.
- Only warn on incompleting installed resolvables (#185197)
- rev 3644
* Wed Jun 14 2006 kkaempf@suse.de
- Atoms might only be installed via patches (#184714)
- rev 3642
* Wed Jun 14 2006 dmacvicar@suse.de
- fix for the last stall tmpfile (#178292)
- r3637
* Wed Jun 14 2006 mt@suse.de
- Implemented transfer timeout inside of the progress callback.
  The timeout value can be set using timeout url parameter, the
  default transfer timeout is 180 seconds. (#181602)
- Added ssl_verify and ssl_capath url options used in https scheme,
  allowing to change or disable the ssl verify options. (#171622)
- Added fallback on read failures of /etc/mtab to /proc/mounts.
  Improved verbosity in mount and mount check related failure cases,
  incl. /etc/mtab dump. (#181606)
- rev 3623
* Wed Jun 14 2006 kkaempf@suse.de
- combine knownAliases and knownUrls in a single function.
- rev 3616
* Mon Jun 12 2006 kkaempf@suse.de
- honor parallel installs in resolver context (#181103)
- rev 3592
* Mon Jun 12 2006 dmacvicar@suse.de
- right fix for tmpdir initialized in static constructor
- catch around provideJustFile in providePackage
-rev 3654
* Mon Jun 12 2006 dmacvicar@suse.de
- fix #182003 YUM packages without size
- rev 3587
* Mon Jun 12 2006 kkaempf@suse.de
- Allow to restore and remove by Url
- rev 3583
* Mon Jun 12 2006 kkaempf@suse.de
- make atoms parallel installable (#181103)
- rev 3580
* Fri Jun  9 2006 dmacvicar@suse.de
- Allow to restore by alias
- r3568
* Fri Jun  9 2006 mvidner@suse.cz
- Do not fork in a global destructor, perl dislikes it (#182672).
  Fixes hanging ag_ldapserver and yast2-perl-bindings tests.
* Thu Jun  8 2006 ma@suse.de
- Installation: Assert product information is stored to libzypp
  database before reboot. (#181198)
- Version 1.2.0; revision 3553
* Wed Jun  7 2006 visnov@suse.cz
- Synchronize keys with rpm database before
  closing access to it (#182338)
- rev 3533
* Wed Jun  7 2006 mt@suse.de
- Changed to just prefer DVD drives in "dvd:" scheme, instead of
  filter out the non-DVD drives completely. Allows a fallback to
  drives without the dvd HAL property e.g. in VMWare. (#177457)
- rev 3530
* Wed Jun  7 2006 dmacvicar@suse.de
- Merge fix for stalle tmpdir due to cyclic references, using a master
  TmpDir for zypp. (#178292) . There is still 1 tmpdir to fix.
- rev 3521
* Wed Jun  7 2006 dmacvicar@suse.de
- Fixes unneeded file download, and add download callbacks
  (still need yast side) #181204 and #160206
- Fix stalle tmpdir due to cyclic references, using a master
  TmpDir for zypp. # 178292
* Wed Jun  7 2006 ma@suse.de
- fixed memory leak in PersistentStorage (#168690)
- revision 3519
* Tue Jun  6 2006 ma@suse.de
- fixed memory leak in XMLSourceCacheParser (#168690)
- revision 3517
* Fri Jun  2 2006 schubi@suse.de
-latest fi translation added
  Revision 3502
* Thu Jun  1 2006 schubi@suse.de
-All installed resolvables has been set to "satisfied" in
  ResolverContext::unneeded . BUT:
  Patch concerning resolvables have to be set to
  "unneeded" although they are installed. In order
  getting the state "no longer applicable" (Bug 171590)
- rev 3496
* Thu Jun  1 2006 kkaempf@suse.de
- compute status for scripts and messages so their freshens get
  properly honored (aj with postgresql-server)
- rev 3494
* Thu Jun  1 2006 dmacvicar@suse.de
- revert not-used-yet rpmdb timestamp, as
  it broke rpmdb::init(). (#180040)
- rev 3490
* Thu Jun  1 2006 schubi@suse.de
- updating gmo files, if po files has been changed; bug 164449
* Wed May 31 2006 dmacvicar@suse.de
- Dont download twice if starting from 1st time
- fix typo
- rev 3481
* Wed May 31 2006 dmacvicar@suse.de
- set cache dir only if storeMetadata is called as a public method.´
- rev 3475
* Wed May 31 2006 kkaempf@suse.de
- schedule a package for installation if
  - it freshens / supplements something
  - it is not installed yet
  (#178721)
- rev 3473
* Wed May 31 2006 dmacvicar@suse.de
- make susetags also implement download and check first.
- rev 3470
* Tue May 30 2006 dmacvicar@suse.de
- make yum more robust. Never parse from provideFile
  but only from local disk. Make sure the cache
  is consistent before recreating it.
  the code is easier to follow and probably
  faster. checksum and signatures are
  checked on caching not on parsing.
  Required to implement refresh for #154990
- rev 3452
* Wed May 24 2006 dmacvicar@suse.de
- implement timestamp for YUM and SuseTags
- actually use the license to confirm in yum patches
- add prerequires tag in yum optonally to the bad designed
  and nonintuitive pre=1
- rev 3448
* Wed May 24 2006 dmacvicar@suse.de
- dont pass root on init but before.
- implement rpm db modification timestamp
  not used yet
- move Helix source to testsuite out of the solver
  so we can use it for target, storage tests
- add Source_Ref::timestamp(), default to now()
  in order to implement smart sync of sources by zmd
- don't parse desc and summary twice
- fix a segfault with tranlated text
- fix broken size tag introduced in rev 3427
- rev 3446
* Tue May 23 2006 dmacvicar@suse.de
- dont accept corrupt sources, improve logs
* Tue May 23 2006 ma@suse.de
- Added PoolItem_Ref::statusReset. Resets the PoolItem status without
  loosing autoprotection (eg. for foreign vendor). (assists #177469)
- rev 3431
* Tue May 23 2006 jsrain@suse.cz
- added mediaNr() to PatchRpm and DeltaRpm classes
- rev 3430
* Tue May 23 2006 dmacvicar@suse.de
- enable YUM license to confirm.
  needed for #174476
- adapt store to serialize and read all new resobject fields
- use install-time to now() when serializing (#174653)
- rev 3427
* Mon May 22 2006 ma@suse.de
- Do not violate install order when restricting commit to a certain
  mediaNumber. (#170079)
- Version 1.1.0; rev 3423
* Mon May 22 2006 mvidner@suse.cz
- Added SourceManager::findSourceByUrl to overcome alias mismatches
  (#177543).
- rev 3420
* Mon May 22 2006 ma@suse.de
- Order all objects according to prerequirements, not just packages.
  (#173690)
- rev 3419
* Mon May 22 2006 schubi@suse.de
- Added new translation
* Fri May 19 2006 dmacvicar@suse.de
- fix missing homedir option for gpg (#171055)
- rev 3415
* Thu May 18 2006 ma@suse.de
- Prevent against daemons launched in rpm %%post, that do not close
  their filedescriptors. (#174548)
- Version 1.0.1; rev 3413
* Thu May 18 2006 jsrain@suse.cz
- fixed media number of package retrieved as a part of a patch
  (#174841)
- rev 3409
* Thu May 18 2006 dmacvicar@suse.de
- fix missing package descriptions due to filtered packages
  by incompatible architectures. (#159109)
- rev 3404
* Thu May 18 2006 kkaempf@suse.de
- decrease logging in DiskUsageCounter and Modalias (#163186)
- rev 3406
* Thu May 18 2006 ma@suse.de
- Stay backward comapatible.
* Tue May 16 2006 ma@suse.de
- Make basic attributes available through ResObject.
- Let ResObjects which do not require media access during
  commit return ZERO sourceMediaNr (required for #173690)
- Version 1.0.0
- rev 3390
* Tue May 16 2006 kkaempf@suse.de
- reduce logging verbosity (#163186)
- rev 3381
* Tue May 16 2006 schubi@suse.de
- setCandidate accept candidates with compatible architectures too. Not
  only with the same architecture. Bug 172594 - If update package has
  differet arch, UI display is wrong
* Tue May 16 2006 mvidner@suse.cz
- Added Source_Ref::resStoreInitialized.
  If we know that noone has seen the resolvables yet, we can skip
  them too, eg. when deleting a source. (#174840)
- rev 3378
* Mon May 15 2006 kkaempf@suse.de
- Honor freshens as conditionals independant from the installed/
  uninstalled status (#174797)
- rev 3376
* Mon May 15 2006 kkaempf@suse.de
- State modifier "unneeded" is transitive for patches (#171590)
- rev 3375
* Thu May 11 2006 schubi@suse.de
- Do not transact itself (update) in the transactResObject mechanism
  Bug 174290
* Thu May 11 2006 mt@suse.de
- Reenabled improved large file support flags (unintentionally
  removed in rev 1544). Fixes bug #173753.
- Added large file support flags to libzypp.pc file allowing
  consistence checks in the application using features variable
- rev 3366
* Thu May 11 2006 mvidner@suse.cz
- SourceManager: moved source deletion before creation
  so that we can recreate a deleted one (#174295)
- removed dead code dealing with known_caches from SourceManager::store
  (see r3195)
- r3362
* Thu May 11 2006 jsrain@suse.cz
- fixed returning product short name and summary if product read
  from target store (#148625)
- rev 3360
* Wed May 10 2006 jsrain@suse.cz
- set media verifier on redirected medium (#172599)
- rev 3359
* Mon May  8 2006 kkaempf@suse.de
- fix 'transactResKind' to collect best providers by capability
  and to recursively transact items of same kind (#170114)
- rev 3355
* Mon May  8 2006 dmacvicar@suse.de
- serialize the full URL to avoid missing password and other
  url settings (#148108)
- rev 3353
* Fri May  5 2006 mt@suse.de
- Added a 60 sec connect timeout to MediaCurl (#172860)
- rev 3348
* Thu May  4 2006 kkaempf@suse.de
- re-fetch also .asc and .key files before checking signature
  (#172597)
- rev 3350 (3345-10.1)
* Wed May  3 2006 dmacvicar@suse.de
- Fix yum key verification, because a double variable declaration
* Wed May  3 2006 dmacvicar@suse.de
- use --no-default-keyring to avoid creating a
  default gpg dir in / (#171055)
- rev 3335
* Wed May  3 2006 dmacvicar@suse.de
- Fix YUM signature checking, we were passing the key instead of the
  signature.
- When the user trust a key, sync again. Bye to the session trusted
  keys and user being asked all the time. (#171213)
- r3332
* Wed May  3 2006 ma@suse.de
- Cleanup index tables when removing items from pool (#170564).
* Wed May  3 2006 kkaempf@suse.de
- backout rev 3246->3275 of TargetImpl.cc
- add missing testsuite/utils/TestUtils.h
- rev 3330
* Wed May  3 2006 dmacvicar@suse.de
- more fixes for #171062, there were some files still not being
  read from cache.
- r3327
* Tue May  2 2006 dmacvicar@suse.de
- cache keys and signature. Remove lot of duplicated code. (#171062)
- r3320
* Tue May  2 2006 mt@suse.de
- Disabled isUseableAttachPoint check in MediaDIR -- we do not
  mount here anything, so it is OK to use any dir (171351).
- rev 3318
* Tue May  2 2006 kkaempf@suse.de
- parse "license-to-confirm" in primary.xml (#168437)
- rev 3312
* Mon May  1 2006 kkaempf@suse.de
- Don't try to store 'Atom', not needed and the backend store
  rejects them anyways (addtion to #168610)
- rev 3306
* Mon May  1 2006 mt@suse.de
- Improved device check in MediaDISK using libblkid (Bug #158529)
- Allow to provide sysfs path via $SYSFS_PATH in MediaCD.cc and
  added a check if it is a directory
- Added libcurl and libblkid checks to configure.ac
- Added e2fsprogs(-devel) requires to the spec file
- rev 3303
* Sat Apr 29 2006 kkaempf@suse.de
- dont download "other" during key check (#171041)
- rev 3294
* Sat Apr 29 2006 kkaempf@suse.de
- allow parallel installs of atoms (used to fulfill patch require-
  ments, atoms aren't installed anyways) (#170098)
- some testsuite improvements.
- rev 3288
* Fri Apr 28 2006 dmacvicar@suse.de
- get rid of autobuild check when throwing exceptions without throw
  but with a macro, returning a null pointer at the end (never reached).
* Fri Apr 28 2006 ma@suse.de
- Do not violate install order when restricting commit to a certain
  mediaNumber. (#170079)
* Fri Apr 28 2006 dmacvicar@suse.de
- Don't use throw directly!
  use ZYPP_THROW with a Exception class, otherwise package bindings
  will not catch them.
  Should fix crashes when reading broken sources with yast.
- rev 3272
* Fri Apr 28 2006 schubi@suse.de
- Bug 162064 - font packages are not installed for locale, e.g. khmer font not installed after CD1
  revision 3269
* Fri Apr 28 2006 kkaempf@suse.de
- revert bugfix #168906 (fom rev 3219), it filters too many errors.
- further improve on #168840 (from rev 3231), match on name-edition
  when filtering by best arch. (#170098)
- rev 3268
* Fri Apr 28 2006 dmacvicar@suse.de
- #170093 , lot of package descriptions missing
- rev 3263
* Thu Apr 27 2006 dmacvicar@suse.de
- try to fix wrong permissions of /var/lib/zypp created
  by old zypp, only when running as root they are fixed
  (#169094)
- YUM: Verify signatures on factoryInit.
  Dont provide other.xml. Cleanups, better logging.
  When refreshing signed soruces, don't refresh is source
  has not changed.
- YaST sources: don't refresh if media file has not changed.
- Show full url of index files in sources for signature validation
  (mentioned in #170139 comment #3)-
* Thu Apr 27 2006 jsrain@suse.de
- udpated media ID syntax for external scripts (to be consistent
  with packages) (#170247)
- rev 3256
* Thu Apr 27 2006 jsrain@suse.de
- set media ID to 1 if not specified in YUM metadata (#167452)
- rev 3255
* Thu Apr 27 2006 kkaempf@suse.de
- If freshen and supplement are fulfilled, install any kind of
  resolvable if not yet installed (#165746)
- rev 3249
* Wed Apr 26 2006 kkaempf@suse.de
- make downloaded script executable. (#169191)
- rev 3247
* Wed Apr 26 2006 kkaempf@suse.de
- Improve on last fix, compare only compatible archs.
- rev 3233
* Tue Apr 25 2006 kkaempf@suse.de
- Only choose best arch of multiple package atoms with identical
  name (#168840)
- rev 3231
* Tue Apr 25 2006 dmacvicar@suse.de
- pass empty strings to UI as key properties if unknown key
  (#169114)
- rev 3228
* Tue Apr 25 2006 kkaempf@suse.de
- refrain from parsing 'other.xml' (#159316)
- rev 3226
* Tue Apr 25 2006 visnov@suse.cz
- in source refresh, clean up the cache dir if fails
- do not require repomd.xml.asc when creating a cache (#163765)
- rev 3224
* Tue Apr 25 2006 dmacvicar@suse.de
- Check if a file exists before providing it, and just handling the
  exception is not sufficient, because it can release the media.
  it nows get all possible packages.X translations an then
  it selects the candidate from the existing ones (#168654)
- rev 3221
* Tue Apr 25 2006 kkaempf@suse.de
- dont report conflicts if item is neither installed
  nor to-be-installed (#168906)
- rev 3219
* Tue Apr 25 2006 dmacvicar@suse.de
- #168060 , propagate the file description or original
  name to the UI and not the checked filename path,
  which could be a tmp file.
  Requires changes in pkg-manager, and probably zmd-helpers.
- rev 3215
* Mon Apr 24 2006 dmacvicar@suse.de
- /var/lib/zypp/db/languages/* are empty files (##168355)
- r3206
* Mon Apr 24 2006 dmacvicar@suse.de
- All resolvables must honor arch, so Arch_noarch in
  target/store/XMLFilesBackend.cc is wrong (#160792)
- Introduced code to honour shared package descriptions
  (#159109)
- r3204
* Mon Apr 24 2006 jsrain@suse.de
- replace '_' in YUM elements/attributes with '-' (#168762)
- rev 3201
* Mon Apr 24 2006 mt@suse.de
- Fixed iseries workaround - interchanged variables for scsi
  devices, added debug messages about the steps (#163971).
- Added getenv NULL ptr check and verify of the $HOME dir's
  and ~/.curlrc file's ownership (#163203).
- rev 3199
* Mon Apr 24 2006 ma@suse.de
- Use filesystem::TmpDir to create unique and unused Source cache
  directories. (#168051)
* Mon Apr 24 2006 ma@suse.de
- Enable signature checks per default. (#168525)
* Mon Apr 24 2006 visnov@suse.cz
- fix callbacks for providing a single file (#160206)
* Sun Apr 23 2006 kkaempf@suse.de
- If an installed package looses a dependency, the solver tries
  to upgrade it. Limit the upgrade candidates to best arch, best
  edition.
- filter 'other' entries with incompatible arch in yum parser.
- rev 3177
* Fri Apr 21 2006 jsrain@suse.de
- initialize the product category according to source (#168061)
- rev 3172
* Fri Apr 21 2006 mvidner@suse.cz
- delete only one older version of a xml-store resolvable
  (half-baked, but the previous attempt was charred)
* Fri Apr 21 2006 jsrain@suse.de
- moved license_to_confirm to primary.xml
- rev 3170
* Fri Apr 21 2006 ma@suse.de
- Removed deprecated oldstyle commit methods.
* Fri Apr 21 2006 mvidner@suse.cz
- when installing a xml-store resolvable (all except package,
  message, script), delete older versions (#160792).
- read selection edition from the XML store
- rev 3167
* Thu Apr 20 2006 kkaempf@suse.de
- properly clear transaction flag after successful commit
  (see rev 3122, #164365, #167285)
- rev 3157
* Thu Apr 20 2006 kkaempf@suse.de
- recursively soft-uninstall recommended package on real uninstall,
  not on update (#167603)
- rev 3155
* Thu Apr 20 2006 dmacvicar@suse.de
- fix #167605 (importing keys to rpm multiple times due to
  wrong interpretation of rpm gpg versioning.
- add support for reading the rpm keys, with full id and fingerprint
- rev 3153
* Wed Apr 19 2006 kkaempf@suse.de
- don't add duplicate error infos to ResolverContext (#167309)
- rev 3146
* Wed Apr 19 2006 kkaempf@suse.de
- fix Resolver::transactReset() (see rev 3122) (#167285)
- rev 3140
* Wed Apr 19 2006 ma@suse.de
- Introduced $ZYPP_KEYRING_DEFAULT_ACCEPT_ALL. If this environment
  variable is present, all signature checking callbacks will default
  to 'accept', in case no recipient is present.
* Wed Apr 19 2006 dmacvicar@suse.de
- read content file on construction, and make
  provideProduct only insert the already
  read product object into the store (#165826)
  (dmacvicar)
- When the signature is not found, warn the
  user about a unsigned source. When the
  key is not found, do nothing, it can be in the
  keyring already. (#166016) (dmacvicar)
- enable key verification only if
  ZYPP_CHECKSIG env var is set (dmacvicar)
- r1529
* Tue Apr 18 2006 kkaempf@suse.de
- fix bugfix 164365, fix bug 167285
  Actually clear the transcation state instead of locking it
  to 'dont transact'
- rev 3122
* Tue Apr 18 2006 visnov@suse.cz
- revert the signature/digest checking callbacks
- rev 3115
* Tue Apr 18 2006 kkaempf@suse.de
- Bugfix #165670
  - Honor keep requests.
  - Dont flag "locked uninstall" as error if a keep request was
    issued before.
- rev 3114
* Tue Apr 18 2006 kkaempf@suse.de
- rule out locked items during distribution upgrade as early
  as possible. (#165670)
- rev 3110
* Mon Apr 17 2006 kkaempf@suse.de
- Bugfix #166212
  - use APPL_LOW as 'ui initiated, by solver' in transactKind() and
    transactResObject().
  - resetTransaction(APPL_LOW) before resolving
  - enhance transactCaps by using the same algorithm as in
    QueueItemRequire
    (before: transact all requires and recommends by name
    now: transact best requires and recommends by provides)
- rev 3107
* Fri Apr 14 2006 visnov@suse.cz
- new callbacks for failing digest
- rev 3098
* Thu Apr 13 2006 visnov@suse.cz
- ask for file without a checksum (#165125)
* Thu Apr 13 2006 kkaempf@suse.de
- dont install satisfied resolvables (#165843)
- rev 3095
* Thu Apr 13 2006 kkaempf@suse.de
- dont abort on failed "dry_run" (#164583)
- rev 3091
* Thu Apr 13 2006 visnov@suse.cz
- Ask user if signature file does not exist (#163765)
- handle repomd.xml.asc as optional file (#163765)
- rev 3089
* Thu Apr 13 2006 schubi@suse.de
- Bug 164365 - build 906: Deselecting a selection, all packages are still selected
- rev 3087
* Thu Apr 13 2006 kkaempf@suse.de
- Dont do transitive uninstalls on uninstalled or upgraded items.
  (#165798)
- rev 3083
* Wed Apr 12 2006 ma@suse.de
- Added 'rpmNoSignature' to ZYppCommitPolicy (#163862)
* Wed Apr 12 2006 mvidner@suse.cz
- Product::updateUrls: restore it from the XML store;
  fixed content parsing (#163192).
- restore product flags fro the XML store
- rev 3074
* Wed Apr 12 2006 kkaempf@suse.de
- Only consider best arch/version (#165477)
- rev 3069
* Wed Apr 12 2006 ma@suse.de
- No need to parse tags at all if there is no item to store values
  (e.g. data for unwanted arch). Fixed segv trying to store data in
  NULL item. (#165479)
- rev3065
* Tue Apr 11 2006 mt@suse.de
- Improved Url path name "//" vs. "/%%2f" handling; now if the
  url has an authority, "/%%2f" is used for ftp only (#163784)
- rev 3062
* Tue Apr 11 2006 jsrain@suse.de
- fixed storing patch scripts to target store (#159928)
- rev 3058
* Tue Apr 11 2006 kkaempf@suse.de
- if a patch is bad, only skip this patch, not everything
  (#165200)
- rev 3057
* Tue Apr 11 2006 ma@suse.de
- Susetags:Selections: Allow parsing older .sel file formats. (#159851)
- Susetags:Pattern: Fixed parser.
* Tue Apr 11 2006 kkaempf@suse.de
- when uninstalling, only re-establish installed items
  supplementing the to-be-uninstalled one. (variant of #165111)
- rev 3054
* Tue Apr 11 2006 ma@suse.de
- Susetags:Package: Parse and provide ins/delnotify texts.
* Tue Apr 11 2006 kkaempf@suse.de
- when checking freshens/supplements at install, only consider
  best architecture/edition (#164453)
- rev 3051
* Tue Apr 11 2006 kkaempf@suse.de
- when checking for supplements, only consider best arch, best
  edition for installation (#165111)
- rev 3047
* Tue Apr 11 2006 schubi@suse.de
- Bug 165117: build 910: Update: Splitted packages are selected for
  all archs
* Tue Apr 11 2006 visnov@suse.cz
- ask user if a file exists but does not have a checksum (#162797)
- rev 3044
* Mon Apr 10 2006 jsrain@suse.de
- parse time and size elements from delta and patch RPM
- rev 3043
* Mon Apr 10 2006 mt@suse.de
- Added detection of iSeries virtual CD (/dev/iseries/vcd[a-h])
  devices - on powerpc only (#163971)
- rev 3042
* Mon Apr 10 2006 kkaempf@suse.de
- fix endless loop in patches parsing.
- rev 3039
* Mon Apr 10 2006 jsrain@suse.de
- fixed media handling in SuSEtags source (#164879)
- rev 3037
* Mon Apr 10 2006 kkaempf@suse.de
- honor 'dry_run' on package remove (#164732)
- rev 3036
* Mon Apr 10 2006 kkaempf@suse.de
- add files from yum filelist as provides to package (#164731)
- rev 3032
* Mon Apr 10 2006 kkaempf@suse.de
- honor "+Enh:/-Enh:" in packages file (#156513)
* Mon Apr 10 2006 visnov@suse.cz
- fix callback receiver signature to match the callback for removing
  package
* Mon Apr 10 2006 mvidner@suse.cz
- Added Product::updateUrls, from content/UPDATEURLS (#163192).
- rev 3024
* Sat Apr  8 2006 schubi@suse.de
- Bug 164440; Taking wrong architecture while updating obsoletes
  splitted packages
- rev 3022
* Sat Apr  8 2006 kkaempf@suse.de
- allow relative paths with url file:
- dont filter atoms from going into pool, multi-arch patch
  requirements need them. Instead, treat atoms with incompatible
  architecture as unneeded.
- rev 3018
* Fri Apr  7 2006 jsrain@suse.de
- product now provides short name
- rev 3013
* Fri Apr  7 2006 jsrain@suse.de
- read metadata for packages from correct tags in patches (#163220)
- rev 3011
* Fri Apr  7 2006 kkaempf@suse.de
- more detailed resolver error reports (#162994)
- rev 3010
* Fri Apr  7 2006 visnov@suse.cz
- report package download progress (#160966)
- rev 3007
* Fri Apr  7 2006 kkaempf@suse.de
- transact also for languages (#163819)
- rev 3004
* Fri Apr  7 2006 kkaempf@suse.de
- loop through all affected ResObjects in transactResKind (#163819)
- rev 3002
* Fri Apr  7 2006 kkaempf@suse.de
- allow re-installation of non-packages (#162906)
- rev 2998
* Fri Apr  7 2006 mt@suse.de
- Added loop checking for scsi cdroms (/sys/block/srX) in case
  HAL does not provide any drives like on iSeries (#163971).
- rev 2995
* Fri Apr  7 2006 kkaempf@suse.de
- add 'licenceToConfirm()' to Product. (#164375)
* Fri Apr  7 2006 ma@suse.de
- Avoid excessive CD hopping on commit. But still far from
  being perfect. (#159679)
- Fixed Target::commit: Despite dry_run set True, packages
  were depeted.
* Fri Apr  7 2006 visnov@suse.cz
- honour if user decides to skip a package in commit (#156031)
* Thu Apr  6 2006 jsrain@suse.de
- fixed parsing external reference to script in patch (#163221)
- r2981
* Thu Apr  6 2006 dmacvicar@suse.de
- cache and provide content.asc/key optionally. Dont show a
  popup if they dont exists. (dmacvicar)
- Actually abort when verify signature workflow is false. (dmacvicar)
- r2978
* Thu Apr  6 2006 jsrain@suse.de
- fixed setting autorefresh flag for installation sources
* Thu Apr  6 2006 kkaempf@suse.de
- drop patches with incompatible architecture.
- rev 2972
* Thu Apr  6 2006 mt@suse.de
- Added info method to media verifier base and more debug info
- rev 2970
* Wed Apr  5 2006 kkaempf@suse.de
- Dont deny the "/" attach point in MediaDIR, since this is used
  for all "file:" urls, esp. local packages.
- rev 2962
* Wed Apr  5 2006 schubi@suse.de
- Bug 159673 - only one conflict solvable per page
* Wed Apr  5 2006 kkaempf@suse.de
- parse all dependencies of 'packages' file (#163773)
- rev 2957
* Wed Apr  5 2006 dmacvicar@suse.de
- Use the original media descr_dir on refresh for
  suse tags source (#163196)
- r2952
* Wed Apr  5 2006 kkaempf@suse.de
- add Source::setUrl() for zmd backend helper.
- rev 2946
* Wed Apr  5 2006 dmacvicar@suse.de
- implement rpm keyring / zypp tmp keyring two-way syncronization at rpm
  target init. (dmacvicar)
- r2949
* Wed Apr  5 2006 mt@suse.de
- Fixed MediaDISK to use a mount -oro,bind id the disk
  partition is already attached e.g. by the automounter.
  Try to mount it a second time may fail (#163486).
- rev 2944
* Wed Apr  5 2006 kkaempf@suse.de
- honor optional 3rd parameter to "=Loc:" key of packages (#154337)
- rev 2940
* Wed Apr  5 2006 visnov@suse.cz
- only try to create a source of a given type when restoring
  from the persistent store (#162111)
* Wed Apr  5 2006 kkaempf@suse.de
- parse all dependencies for patterns (.pat) files (#160602)
- drop YOUPATH and YOUURL from content file.
- rev 2924
* Wed Apr  5 2006 visnov@suse.cz
- properly initialize autorefresh for non-remote sources (#154990)
- rev 2919
* Tue Apr  4 2006 mt@suse.de
- Added flag to MediaManager::isUseableAttachPoint, whether
  to check against system mount entries or not.
- Disallows one to use the attachpoints of another media handlers
  as source path in MediaDIR.
- rev 2917
* Tue Apr  4 2006 dmacvicar@suse.de
-implement callbacks for when package verification (checksum)
  fails, offer to retry or abort
* Tue Apr  4 2006 dmacvicar@suse.de
- Fix construction of checksum objects when using non-standard
  checksum algorithms
- Fix broken YUM cache
- r2913
* Tue Apr  4 2006 kkaempf@suse.de
- Keep packages with no version upgrade installed during
  distribution upgrade (#162972)
- add 'transactReset()' helper function for UI.
- rev 2908
* Tue Apr  4 2006 dmacvicar@suse.de
- r2906
* Tue Apr  4 2006 ma@suse.de
- Fixed candidate handling in ui::Selectable. (#156589)
* Tue Apr  4 2006 dmacvicar@suse.de
- fix #162984 , gpg hangs because the matching data file
  for the key cannot be find. (dmacvicar)
- Fix restore of YUM source using the same cache dir semantics as
  susetags instead of assuming there is a cache if a cache_dir
  was given. (dmacvicar)
* Tue Apr  4 2006 kkaempf@suse.de
- use DISTPRODUCT/DISTVERSION from content file to generate the
  product name, version, and release.
- rev 2902
* Mon Apr  3 2006 mt@suse.de
- Removed broken forcing of absolute ftp paths added in rev2705 to
  MediaCurl, refined cleanupPathName/setPathName in url (#154197).
- rev 2900
* Mon Apr  3 2006 kkaempf@suse.de
- add Resolver::freshenPool() (#156980)
- rev 2893
* Mon Apr  3 2006 kkaempf@suse.de
- skip incompatible archs in filelist parsing.
- restrict pathes to 'interesting' ones (/bin/, /sbin/, /lib/,
  /lib64/, ...)
- rev 2886
* Sun Apr  2 2006 kkaempf@suse.de
- skip incompatible archs in primary parsing.
- rev 2883
* Sun Apr  2 2006 kkaempf@suse.de
- allow setting of source when parsing local .rpm (#147765)
- rev 2880
* Fri Mar 31 2006 schubi@suse.de
- Do not update packages over other architectures
* Fri Mar 31 2006 sh@suse.de
- Added zypp/ui/UserWantedPackages to support the UI's
  "automatic changes" dialog (bug #152700)
* Fri Mar 31 2006 jsrain@suse.de
- use KeyRing class to validate repomd.xml (#160909)
* Fri Mar 31 2006 dmacvicar@suse.de
- Product resolvables should be readable by normal users.
  (#162474) (dmacvicar)
- implemented keyring and metadata signature verification
  in susetags source
- dont delete the lock if we did not acquire it
- r2847
* Fri Mar 31 2006 mt@suse.de
- Added disabling of the automounter while MediaManager
  init and restoring of the old state on exit (#154326).
- Implemented check if media (CD) is automounted or not
- rev 2840
* Fri Mar 31 2006 mt@suse.de
- Implemented several hal get/set/removeDeviceProperty wrappers
- Improved HalException allows one to fetch HAL/DBUS error componets
- rev 2830
* Fri Mar 31 2006 kkaempf@suse.de
- honor subscription status of catalogs (#162350)
- rev 2827
* Fri Mar 31 2006 mt@suse.de
- Enabled CD eject error reporting exceptions (#154326)
- rev 2822
* Fri Mar 31 2006 kkaempf@suse.de
- support "dry run" (#159467)
- implement "transactResKind" (#161400)
- rev 2817
* Thu Mar 30 2006 jsrain@suse.de
- add checksum for external patches (#159928)
* Thu Mar 30 2006 kkaempf@suse.de
- calculate product architecture (#158198)
* Wed Mar 29 2006 jsrain@suse.de
- fixed checking checksum of YUM metadata, added sha1 vs. sha256
  detection
* Wed Mar 29 2006 ma@suse.de
- Auto protect installed packages from unknown vendor. (#157446)
* Wed Mar 29 2006 visnov@suse.de
- added support for external scripts to metadata (#159928) (jsrain)
- fixed handling of Language resolvables (ma)
- fix leak in rpmdb (dmacvicar)
- added softlock for autoyast (#159466) (ma)
- Fixed exceptions in doGetFileCopy() to show full url
  including the file instead of just the media base url. (mt)
- Provide Language::summary (ma)
- check patterns and selections file exist
  before veryfing them (#161300) (dmacvicar)
- added YUM metadata checksum computation (jsrain)
- added interface to patch of a message (jsrain)
- r2734
* Mon Mar 27 2006 jsrain@suse.de
- added support for external scripts to metadata (#159928)
- r2709
* Sat Mar 25 2006 jsrain@suse.de
- report separate exception when trying to start source cache again to
  suppress incorrect error message in XEN installation
- r2682
* Fri Mar 24 2006 schubi@suse.de
- Implement inter process locking in zypp.
- Added No medium found output
- splitting modaliases in supplements TOO
- parse also the available signing keys
* Fri Mar 24 2006 visnov@suse.cz
- release all media when removing source (#159754) (visnov)
- more testsuites (schubi)
- updated translations (schubi)
- added MediaNotEjectedException (mt)
- rev 2652
* Thu Mar 23 2006 dmacvicar@suse.de
- fix patches descriptions (dmacvicar)
- fix source serialization (dmacvicar)
- metadata for kernel test (schubi)
- Arch tests updated (ma)
- classify NULL Ptr as unique (ma)
- Added host check, because file Url allows it now. (mt)
- prepare modalias fix (#159766) (ma)
- Provide iterator based access to SourceManager data. (ma)
- Fixed "file:" Url scheme config to allow relative paths; (mt)
  RFC1738 says, it may contain a hostname as well...
- revision 2633
* Wed Mar 22 2006 visnov@suse.cz
- pkg-config support (mvidner)
- close all medias when destructing MediaSet (jsrain)
- rev 2622
* Wed Mar 22 2006 dmacvicar@suse.de
- Bug 159976 - build 804: Adding AddOn CD via ftp gives error (dmacvicar)
- Message callback implemented to show patch messages (visnov)
- Bug 159696 (schubi)
- provide transform_iterators to iterate over a maps keys or values (ma)
- added 'bool Arch::empty() const' test for an empty Arch string (ma)
- added script and message installation (jsrain)
- chooses the 'right' kernel now (kkaempf)
- Use noarch if no arch is specified in patches (dmacvicar)
- rev 2611
* Tue Mar 21 2006 mvidner@suse.cz
- Added some debug output including the access id (mt)
- Bug #154326: Enabled FORCE_RELEASE_FOREIGN flag causing
  release with eject=true on attached media, to umount
  other mounts as well. (mt)
- 159483 - solver does not blame missing dependency (schubi)
- Added a variant of MediaHandler::forceRelaseAllMedia (ma)
- Fixed MediaCD::forceEject() to handle DELAYED_VERIFY
  and use forceRelaseAllMedia if FORCE_RELEASE_FOREIGN=1 (ma)
- fixed ZYPP_RETHROW (#156430) (ma)
- patch for #156114 (visnov)
- fixed container.erase loops (ma)
- Fixed to reset desired (cached) flag before the action (mt)
- Removed return in forceRelaseAllMedia (void function) (mt)
- Parse nonexisting architecture to noarch so patches dont get
  filtered by the pool (dmacvicar)
- 159512 - yast2-qt does not show label of to be installed products
  anymore (dmacvicar)
- 159765 - Hidden patterns still visible (dmacvicar)
- Use noarch if no arch is specified. (dmacvicar)
- r2594
* Tue Mar 21 2006 visnov@suse.de
- properly report error for media change callback
- rev 2579
* Tue Mar 21 2006 ma@suse.de
- fixed memory leak in XMLNodeIterator (#157474)
- disabled storing filelist (YUMFileListParser) and changelog (YUMOtherParser)
- Renamed private MediaManager::forceMediaRelease
  function to forceReleaseShared (more exact name)
- Implemented forceRelaseAllMedia() that can be
  used to release also foreign (user) mounts.
- Added use of forceRelaseAllMedia for CD/DVDs
  if FORCE_RELEASE_FOREIGN is 1 (default 0)
- little cleanup of the checkAttached function
- r2578
* Mon Mar 20 2006 mvidner@suse.cz
- don't try to attach without exception handling (#158620)
- fix descriptions, as a new tag Des for selections exists now.
- fix #157683: failure after adding add-on product to install
  sources
- added more files for translation
- resolve-dependencies.cc: establish pool
- parse-metadata.cc: catch bad URL
- set zmdid for atoms
- r2574
* Sun Mar 19 2006 kkaempf@suse.de
- fix testsuite.
- provide edition and architecture for all kinds of yum
  resolvables.
- fix ResStatus output.
- establish atoms correctly.
- treat requires to unneeded resolvables as fulfilled.
- rev 2559
* Sun Mar 19 2006 kkaempf@suse.de
- fix the build
- only consider best architecture/version (#157594)
- prefer providers which supplement/enhance installed or
  to-be-installed packages (fixes the tpctl-kmp issue)
- rev 2546
* Sat Mar 18 2006 kkaempf@suse.de
- provide more filters for pkg-bindings (#158602)
- add SystemResObject to provide system (modalias, hal, ...)
  capabilities.
- handle this during resolving.
- make the modalias and hal capability match the SystemResObject
  by default, thereyby triggering a modalias (resp. hal)
  evaluation.
- xmlstore: decouple target store from YUM schema.
- clean up moving of hal() and modalias() from provides to
  supplements in ResolvableImpl.
- add PatchContents() for UI.
- handle Edition::noedition as empty string.
- r2537
* Wed Mar 15 2006 jsrain@suse.de
- releasing all medias when asking for CD (#156981)
- r2471
* Tue Mar 14 2006 mvidner@suse.cz
- ResStatus::resetTransact must return a value.
- Fixed random build failures in LanguageCode.cc.
  (Rewrote the CodeMaps constructor so that gcc does not
  optimize a 500-statement basic block.)
- Fix constructions of patch objects. Actually insert atoms in atoms
  list. Insert atoms for package even if the package does not exists
  in the source. Fixes #157628 (dmacvicar).
- Fixed license reading from susetags, #151834 (dmacvicar).
- r2468
* Tue Mar 14 2006 mvidner@suse.cz
- added ResStatus::resetTransact (ma)
- bugfix for #156439 (schubi)
- Added Source_Ref::setAlias (#154913).
- Do not assume there is a product file when scanning for products
  (visnov)
- function to disable all sources in the persistent store (visnov)
- dependency errors go to stdout, not stderr; output resolver info
  directly to stderr (kkaempf)
- rev 2464
* Tue Mar 14 2006 kkaempf@suse.de
- fix merging of resolver info (needed for #157684).
- errors are also important in ResolverInfo.
- improve debug output in ResolverContext.
- rev 2455
* Mon Mar 13 2006 jsrain@suse.de
- delete RPMs downloaded via HTTP/FTP after installnig them
  (#157011)
- fixed product registration (reverted autorefresh patch) (#157566)
* Mon Mar 13 2006 kkaempf@suse.de
- if root!="/", always prefer the upgrade candidate (#155472)
- implement license confirmed api for UI.
- prefer architecture over version in distribution upgrade
  (#157501)
- clean up media handling.
- rev 2448
* Sun Mar 12 2006 kkaempf@suse.de
- init Modalias properly.
- fix warnings in testcases.
- rev 2432
* Sat Mar 11 2006 kkaempf@suse.de
- drop libjpeg-devel and sqlite-devel from build requires.
* Sat Mar 11 2006 kkaempf@suse.de
- implement 'modalias()' capability (#157406)
- make dependencies consistent, its 'freshens'.
- cope with user umounts of devices.
- add debug to SourceManager.
- rev 2418
* Fri Mar 10 2006 kkaempf@suse.de
- allow version downgrade during distribution upgrade if the
  newer package is coming from a trusted vendor (#155472)
- implement locale fallback
- 'freshen' -> 'freshens' in schema definitions to make it
  consistent with all other dependency definitions.
- better error reporting for .pat and .sel files.
- rule out packages from dependency resolutions which are
  de-selected by user (#155368)
- use locale fallbacks in package translations.
- refresh source when re-enabling it.
- rev 2406
* Tue Mar  7 2006 kkaempf@suse.de
- split of libzypp-zmd-backend subpackage as a stand-alone
  leaf package.
- encapsulate bool test for Source_Ref better.
- fixed stack overflow (ma).
- make testsuite build again.
- rev 2346
* Tue Mar  7 2006 kkaempf@suse.de
- fixed URL rewriting for CD2 and following (#154762)
- fixed ResPoolProxy diffState (for proper ok/cancel support
  in UI)
- added special exception class for aborting installation
  (#154936)
- only auto-change directories if they end in CDn or DVDn.
- rev 2320.
* Tue Mar  7 2006 kkaempf@suse.de
- silently ignore multiple installs of the same package.
- fix disk usage for installs and uninstalls.
- rev 2308
* Mon Mar  6 2006 kkaempf@suse.de
- zmd-backend: filter out incompatible architectures from
  repository.
- rev 2298
* Mon Mar  6 2006 kkaempf@suse.de
- sync libzypp media data with mtab.
- improve resolver error and solution reports.
- fix source cache reading (#155459).
- default cached sources to enabled (#155459).
- let each source provide public keys.
- rev 2297
* Sun Mar  5 2006 kkaempf@suse.de
- only write by-sovler transactions back (#154976)
- rev 2278
* Sat Mar  4 2006 kkaempf@suse.de
- release last used source at end of commit (#155002)
- rev 2277
* Sat Mar  4 2006 kkaempf@suse.de
- cope with NULL values in zmd catalogs table (#153584)
- set YAST_IS_RUNNING in transact zmd helper (#154820)
- run SuSEconfig after transact zmd helper (#154820)
- add softTransact to honor user vs. soft requirements (#154650)
- honor all build keys provided by a package source.
- add source metadata refresh.
- add progress callbacks to zmd helpers.
- rev 2276
* Thu Mar  2 2006 kkaempf@suse.de
- include .diffs into main source.
- catch exception when ejecting media which was unmounted externally
  (#154697).
- init source in zmd-backend correctly (#154667)
- implement disk usage info for YaST.
- clean up XML schema files.
- catch CPUs identifying as 'i686' but being 'i586'.
- allow definition of preferred attach (mount) point for media.
- make resolver results more readable.
- use language fallbacks if none of multiple language providers
  matches.
- get rid of ignoring wrong arch in resolver, having the wrong
  architecture is prevented by other means.
- prepare for translations in exceptions.
- fix 'abort does not abort'
- implement 'flag' I/O in target cache backend.
- skip incompatibles architectures in packages.<lang>
- rev 2228
* Thu Mar  2 2006 kkaempf@suse.de
- dont even provide src/nosrc from the source.
- rev 2169 + diffs
* Wed Mar  1 2006 kkaempf@suse.de
- Initialize commit result (#154409)
- release media if its wrong (#154326)
- dont copy src/nosrc packages to the pool (#154627)
- reduce XML logging.
- rev 2169 + diffs
* Tue Feb 28 2006 kkaempf@suse.de
- fix path of .po files (#154074).
- parse the correct package.<lang> file (kinda #154074).
- complain about bad "=Sel:" or "=Pat:" lines (#153065).
- reattach all released medias.
- raise exception instead of abort() on XML errors (#154104).
- update translations.
- PathInfo: implemented a copy_dir_content (variant of copy_dir)
  and is_empty_dir utility function
- rev 2169
* Tue Feb 28 2006 kkaempf@suse.de
- check freshens and supplements for packages (#154074).
- only complain about incomplete installed resolvables,
  if they are uninstalled, schedule them for installation.
  (#154074)
- add testcases for locale() provides.
- add lang_country -> lang fallback.
- have locale(parent:...) deps match any provides of 'parent'
  also when uninstalling a package.
- rev 2148
* Tue Feb 28 2006 kkaempf@suse.de
- change the locale(...) separator to ";" (#153791)
- complete "find-files" of zmd-backend.
- rev 2140
* Tue Feb 28 2006 visnov@suse.de
- avoid attaching media when initializing source
- rev 2139
* Mon Feb 27 2006 kkaempf@suse.de
- warn about misspelled 'locale(...)' provides
- add testcases
- rev 2134
* Mon Feb 27 2006 kkaempf@suse.de
- fix the build
- rev 2129
* Mon Feb 27 2006 kkaempf@suse.de
- provide available locales to application (#153583)
- honor 'requestedLocales' (language dependant packages)
- honor release requests for all holders of a device.
- silently re-attach after a forced release.
- solver improvements.
- handle source caches.
- proper logging in zmd backend helpers.
- rev 2127
* Mon Feb 27 2006 kkaempf@suse.de
- upgrade always to best version and arch (#153577)
- reset 'transact' state for obsoleted packages (#153578)
- translation updates
- rev 2113
* Mon Feb 27 2006 kkaempf@suse.de
- add support for 'local' .rpm packages to zmd-backend.
- rev 2101
* Sun Feb 26 2006 kkaempf@suse.de
- fix build of zmd/backend.
- actually fill 'files' table in package-files.
- rev 2094
* Sun Feb 26 2006 kkaempf@suse.de
- improve testcases.
- add 'setPossibleLocales()' to ZYpp, this defines the set
  of possible locales to choose from (#153583)
- provide LanguageImpl and create 'Language' resolvables for
  each 'possible' locale.
- fix YUM parsing of patches, insert 'atoms' to link patches
  with packages.
- replace gzstream/ with own, existing implementation.
- honor locks in solver (#150231)
- sync pool with target after commit() properly (#150565, #153066)
- new zmd helper 'package-files'
- rev 2093
* Thu Feb 23 2006 kkaempf@suse.de
- prevent multiple initializations of the target (#153124)
- implement 'loopback mounted ISO images'
- retain old package sources on upgrade.
- support compressed .xml files in 'repodata' type repositories.
- rev 2025
* Thu Feb 23 2006 kkaempf@suse.de
- parse locale(...) provides and construct correct dependencies.
* Thu Feb 23 2006 kkaempf@suse.de
- always upgrade to candidate (#152760).
- fix typo in package sorting.
- prepare handling of locale provides.
- rev 1995
* Thu Feb 23 2006 kkaempf@suse.de
- sort src/nosrc package to right list during commit.
- revert installtime/buildtime in susetags parser (#152760)
- rev 1990
* Thu Feb 23 2006 kkaempf@suse.de
- reset state after successful commit (#153030)
- run "rpm -e" always with "--nodeps" (#153026)
- provide separate resolvable kind for src packages.
- extend status field for LOCK and LICENSE.
- add sameState()/diffState() for UI.
- provide 'best' candidate for UI.
- set 60 sec timeout for curl access.
- don't cross-compare solver results, takes too much time.
- provide sizes of installed packages.
- extend REQUIRES semantics in content file.
- add "parse-metadata" helper to zmd-backend.
- rev 1987
* Wed Feb 22 2006 kkaempf@suse.de
- provide complete disk usage data (#152761)
- include upgrade flag when copying solver solution
  back to pool (#152717)
- rev 1959
* Wed Feb 22 2006 kkaempf@suse.de
- don't insert incompatible architectures to the pool (#151933)
- don't accept incompatible architectures from a repository
  (#151933)
- separate rpm log (#151431).
- allow extended product requires.
- rev 1954
* Tue Feb 21 2006 kkaempf@suse.de
- provide the XML schema files in the main package. (#152593)
* Tue Feb 21 2006 kkaempf@suse.de
- provide arch compat handling.
- implement data upload to zmd.
- fix source metadata caching on target.
- add 'supplements' dependencies to 'yum' parser.
- provide user agent identification to curl calls.
- move resolver branches (multiple alternatives) back in queue
  (resolve known things first, then the unknown ones).
- clean up 'packages' parser.
- rev 1947
* Tue Feb 21 2006 kkaempf@suse.de
- improve media mount/umount interface
- prepare class ArchCompat for proper architecture ordering
  and compatibility handling.
- add returns to dummy functions in DbAccess.
- rev 1913
* Mon Feb 20 2006 kkaempf@suse.de
- don't explictly delete to-be-upgraded packages.
- finish query-system, resolve-dependencies, and transact for
  libzypp-zmd-backend.
- provide Pattern::category.
- move system architecture to toplevel.
- make target store pathname settable.
- speed up rpmdb reading by properly filtering unwanted file
  provides.
- rev 1905
* Sun Feb 19 2006 kkaempf@suse.de
- new translations.
- proofread texts.
- when comparing solutions, prefer higher versions.
- provide generic 'SafeBool' for bool conversions.
- add PtrTypes testsuites.
- rev 1876
* Fri Feb 17 2006 kkaempf@suse.de
- integrate all diffs
- move Target::commit to toplevel API
- generalize dependency iterators and hash dependency
  information in pool (for speedup)
- add 'supplements' as dependency
- make more pattern attributes available
- drop "smbfs" in favour of "cifs" (#151476)
- add metadata cache to sources (Beta4 bug)
- run "rpm -e"  with name-version-release
- fix update conflicts
- rev 1864
* Thu Feb 16 2006 kkaempf@suse.de
- fix-mediachange.diff: dont skip CD but retry after media change
- cd-eject-button.diff: fix CD url so YaST recognizes it and shows
  'eject' button
- release-forced-eject-no-ptrfix.diff: fix refcounting in ptrs
  so media handle gets actually released and media unmounted.
* Thu Feb 16 2006 kkaempf@suse.de
- implement arch scoring
- prefer better arch (#151427)
- transitive depedencies of weak requirements are non-weak
  (#151446)
- rev 1778 + diff
* Wed Feb 15 2006 kkaempf@suse.de
- ignore self and to-be-updated conflicts (#150844)
- fix enable of target store (for non-packages)
- rev 1778
* Wed Feb 15 2006 kkaempf@suse.de
- fix "cd:" url (#151121)
- provide location() in public Package api
- allow running distribution upgrade in testmode
- extend HAL interface
- rev 1762
* Wed Feb 15 2006 kkaempf@suse.de
- pass normal and locale packages from selections correctly.
- its "baseconf" for base selections.
- Make 'ZYpp' an obvious singleton.
- provide releasenotesUrl.
- dont continue upgrade without target.
- implement 'fake' hal for testing.
- fix package sizes.
- more solver testcases.
- rev 1754
* Tue Feb 14 2006 kkaempf@suse.de
- extend requires of libzypp-devel
- provide package sizes for UI
- provide more UI helpers
- implement Product and related functions
- fix split provides in distribution upgrade
- provide locale information to system
- ask HAL for available devices
- reduce debug information in solver
- filter architectures in source, not in solver
- rev 1743
* Tue Feb 14 2006 visnov@suse.de
- disable another testsuite for now
- fetch the default locale from environment
- support user-defined formatting of log
- rev 1710
* Mon Feb 13 2006 visnov@suse.de
- providing basic product information from susetags source
- public API for preferred language
- implemented redirect of logging (#149001)
- report start/finish of source data parsing (#150211)
- store/restore source aliases properly (#150256)
- disable a lot of debug logging to speed up solver
- properly rewrite URL for CDn directory layouts (#149870)
- rev 1706
* Sun Feb 12 2006 kkaempf@suse.de
- add save/restore state to facilitate UI 'cancel'
- enable target/store
- add 'forceResolve' call and flag to resolver to switch between
  task-oriented ZMD and interactive YaST behaviour.
- Fix resolver problem solution texts.
- improve solver problem solution offerings.
- fix media access handling to better support multiple
  requestors to single media.
- move the media number checking to the source (media requestor)
  which knows how to verify the correct media.
- Fix CD ordering (#149871), adding testcases.
- Move 'PoolItemList' and 'PoolItemSet' typedefs inside classes.
- Add selections to testcases.
- rev 1673
* Sat Feb 11 2006 kukuk@suse.de
- Fix missing return in Source.cc:124
* Fri Feb 10 2006 kkaempf@suse.de
- cope with empty arch field in selections
- enable dummy "enableStorage" function
- rev 1610-branch
* Fri Feb 10 2006 kkaempf@suse.de
- fix random data return in Source.cc
- rev 1610
* Fri Feb 10 2006 kkaempf@suse.de
- adapt zmd-backend to SourceImpl API change
- rev 1608
* Fri Feb 10 2006 kkaempf@suse.de
- fix the packages parser bug. Now all packages are parsed
  including (english) translations.
  source/susetags is back to svn head.
- rev 1600
* Fri Feb 10 2006 kkaempf@suse.de
- fix off-by-one bug in bitfield handling
- revert source/susetags to rev 1411
- rev 1586
* Thu Feb  9 2006 kkaempf@suse.de
- dont prereq-sort non-packages
- rev 1584
* Thu Feb  9 2006 kkaempf@suse.de
- rev 1582
* Thu Feb  9 2006 kkaempf@suse.de
- update to rev 1543
* Thu Feb  9 2006 ro@suse.de
- require hal-devel in libzypp-devel
- re-merge fixes (RPM_OPT_FLAGS)
* Thu Feb  9 2006 kkaempf@suse.de
- make solver behaviour a bit more interactive
- rev 1537
* Wed Feb  8 2006 schwab@suse.de
- Fix syntax error in configure script.
- Use RPM_OPT_FLAGS.
* Wed Feb  8 2006 kkaempf@suse.de
- update for qt ui integration
- rev 1504
* Wed Feb  8 2006 kkaempf@suse.de
- split off libzypp-zmd-backend
- rev 1466
* Wed Feb  8 2006 kkaempf@suse.de
- another update to svn
* Mon Feb  6 2006 kkaempf@suse.de
- finish rpm callbacks
- finish UI API
- fix state change resolver<->pool
- zmd backend stuff
- speed up tag file parsing
- rev 1405
* Mon Feb  6 2006 schubi@suse.de
- disabling failing tests of s390 and ppc
* Mon Feb  6 2006 schubi@suse.de
- Snapshoot rev 1367
* Mon Feb  6 2006 kkaempf@suse.de
- use hashes for pool
- rev 1343
* Fri Feb  3 2006 schubi@suse.de
- removed Obsoletes:    yast2-packagemanager
* Fri Feb  3 2006 schubi@suse.de
- Snapshoot 3 Feb 2005 (11:30)
* Thu Feb  2 2006 schubi@suse.de
- Snapshoot 2 Feb 2005 (14:00)
* Thu Feb  2 2006 schubi@suse.de
- Snapshoot 2 Feb 2005 ( integrating YaST )
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Sat Jan 14 2006 kkaempf@suse.de
- Initial version
