#
# spec file for package ncurses
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%bcond_with     hasheddb
%if 0%{?suse_version} > 1320
%bcond_without  symversion
%else
%bcond_with     symversion
%endif
%bcond_with     memleakck
%bcond_without  onlytinfo

%if %{with onlytinfo}
%global soname_tinfo tinfo
%else
%global soname_tinfo tinfow
%endif

Name:           ncurses
#!BuildIgnore: terminfo
%if %{with hasheddb}
BuildRequires:  db-devel
%endif
BuildRequires:  expect
BuildRequires:  gcc-c++
BuildRequires:  pkg-config
BuildRequires:  screen
%if 0%{?suse_version} > 1130
BuildRequires:  gpm-devel
%else
BuildRequires:  gpm
%endif
%define terminfo() %{_datadir}/%{0}/%{1}
%define tabset()   %{_datadir}/%{0}/%{1}
# bug437293
%ifarch ppc64
Obsoletes:      ncurses-64bit
%endif
#
# Note that this spec files does not only build the ABI version 6
# but also build the ABI version 5 as this is part of the source
# tar ball including the latest upstream fixes for ABI 5.
#
Version:        6.1
Release:        150000.5.30.1
Summary:        Terminal control library
#Git:           http://ncurses.scripts.mit.edu
License:        MIT
Group:          System/Base
Url:            http://www.invisible-island.net/ncurses/ncurses.html
Source0:        ftp://ftp.invisible-island.net/ncurses/ncurses-6.1.tar.gz
Source1:        ncurses-6.1-patches.tar.bz2
Source2:        handle.linux
Source3:        README.devel
Source4:        ncurses-rpmlintrc
# Latest tack can be found at ftp://ftp.invisible-island.net/pub/ncurses/current/
Source5:        ftp://ftp.invisible-island.net/pub/ncurses/current/tack-1.08-20170818.tgz
Source6:        edit.sed
Source7:        baselibs.conf
Patch0:         ncurses-6.1.dif
Patch1:         ncurses-5.9-ibm327x.dif
Patch4:         ncurses-5.7-tack.dif
# PATCH-FIX-UPSTREAM for bsc#1115929
Patch7:         ncurses-5.9-bsc1115929.patch
# PATCH-FIX-UPSTREAM for bsc#1154036, CVE-2019-17594
Patch8:         CVE-2019-17594.patch
# PATCH-FIX-UPSTREAM for bsc#1154037, CVE-2019-17595
Patch9:         CVE-2019-17595.patch
# PATCH-FIX-UPSTREAM for bsc#1198627, CVE-2022-29458
Patch10:        ncurses-bnc1198627.patch
# PATCH-FIX-UPSTREAM for bsc#1190793, CVE-2021-39537
Patch20:        bsc1190793-63ca9e06.patch
# PATCH-FIX-UPSTREAM for boo#1201384
Patch21:        boo1201384.patch
# PATCH-FIX-UPSTREAM for bsc#1218014 -- Fix for CVE-2023-50495
Patch22:        bsc1218014-cve-2023-50495.patch
# PATCH-FIX-UPSTREAM for bsc#1220061 -- Fix for CVE-2023-45918
Patch23:        ncurses-6.1-bsc1220061.patch
# PATCH-FIX-BACKPORT for boo#1229028
Patch24:        ncurses-6.1-boo1229028.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%global         _miscdir    %{_datadir}/misc
%global         _incdir     %{_includedir}
%global         root        %{_tmppath}/%{name}-%{version}-store

%description
As soon as a text application needs to directly control its output to
the screen (if it wants to place the cursor at location (x,y) then
write text), ncurses is used. The panel and the forms libraries are
included in this package. The ncurses libraries support color, special
characters, forms, and panels.

%package -n ncurses-utils
Summary:        Tools using the new curses libraries
License:        MIT
Group:          System/Base
Provides:       ncurses:%{_bindir}/tput

%description -n ncurses-utils
The ncurses based utilities are as follows:

clear -- emits clear-screen for current terminal

tabs -- set tabs on a terminal

toe   -- table of entries utility

tput  -- shell-script access to terminal capabilities.

tset  -- terminal-initialization utility

reset -- terminal initialization utility

%package -n terminfo-base
Summary:        A terminal descriptions database
License:        MIT
Group:          System/Base
Requires:       ncurses >= %{version}
Recommends:     terminfo-screen = %{version}
Provides:       ncurses:%{_datadir}/tabset

%description -n terminfo-base
This is the terminfo basic database, maintained in the ncurses package.
This database is the official successor to the 4.4BSD termcap file and
contains information about any known terminal. The ncurses library
makes use of this database to use terminals correctly.

%package -n terminfo-screen
Summary:        A terminal descriptions database for screen
License:        MIT
Group:          System/Base
Requires:       terminfo-base
Provides:       terminfo:%{_datadir}/terminfo/s/screen.konsole

%description -n terminfo-screen
This package includes some useful entries for the screen utility in the
terminfo database, which might introduce trouble if used over network
connections like ssh or slogin onto systems without those terminfo database
entries.

%package -n terminfo-iterm
Summary:        A terminal descriptions database for iterm
License:        MIT
Group:          System/Base
Requires:       terminfo-base
Provides:       terminfo:%{_datadir}/terminfo/i/iTerm.app

%description -n terminfo-iterm
This package includes some useful entries for the iterm utility in the
terminfo database, which might introduce trouble if used over network
connections like ssh or slogin onto systems without those terminfo database
entries.

%package -n libncurses5
Summary:        Terminal control library
License:        MIT
Group:          System/Libraries
Requires:       terminfo-base
Provides:       ncurses = 5.9
Obsoletes:      ncurses < 5.9
# bug437293
%ifarch ppc64
Obsoletes:      ncurses-64bit
%endif
#

%description -n libncurses5
The ncurses library is used by many terminal applications for
controlling output to the screen and input from the user.

This package contains the library built with the version 5 ABI.

%package -n libncurses6
Summary:        Terminal control library
License:        MIT
Group:          System/Libraries
Requires:       terminfo-base
Provides:       ncurses = %{version}
Recommends:     ncurses-utils = %{version}

%description -n libncurses6 
The ncurses library is used by many terminal applications for
controlling output to the screen and input from the user.

This package contains the library built with the version 6 ABI.

%package -n terminfo
Summary:        A terminal descriptions database
License:        SUSE-Public-Domain
Group:          System/Base
Requires:       terminfo-base = %{version}

%description -n terminfo
This is the terminfo reference database, maintained in the ncurses
package. This database is the official successor to the 4.4BSD termcap
file and contains information about any known terminal. The ncurses
library makes use of this database to use terminals correctly. If you
just use the Linux console, xterm, and VT100, you probably will not
need this database -- a minimal /usr/share/terminfo tree for these
terminals is already included in the terminfo-base package.

%package -n ncurses-devel
Summary:        Development files for the ncurses6 terminal control library
License:        MIT
Group:          Development/Libraries/C and C++
Provides:       ncurses6-devel
Provides:       ncurses:%{_incdir}/ncurses.h
Requires:       %{_bindir}/tack
Requires:       libncurses6 = %{version}-%{release}
Requires:       ncurses = %{version}-%{release}
# bug437293
%ifarch ppc64
Obsoletes:      ncurses-devel-64bit
%endif
#

%description -n ncurses-devel
This package contains the headers needed to build against
the ncurses library in its ABI version 6 form.

%package -n ncurses5-devel
Summary:        Development files for the ncurses5 terminal control library
License:        MIT
Group:          Development/Libraries/C and C++
Provides:       ncurses:%{_incdir}/ncurses5/ncurses.h
Requires:       %{_bindir}/tack
Requires:       libncurses5 = %{version}-%{release}
Requires:       ncurses = %{version}-%{release}
Requires:       ncurses-devel = %{version}-%{release}

%description -n ncurses5-devel
This package contains the headers needed to build against
the ncurses library in its ABI version 5 form.

%package -n tack
Summary:        Terminfo action checker
License:        GPL-2.0-or-later
Group:          Development/Tools/Building
Provides:       ncurses-devel:%{_bindir}/tack
Requires:       ncurses = %{version}-%{release}

%description -n tack
This package contains the tack utility to help to build a new terminfo
entry describing an unknown terminal. It can also be used to test the
correctness of an existing entry, and to develop the correct pad
timings needed to ensure that screen updates do not fall behind the
incoming data stream.

%prep
%setup -q
tar -xjf %{S:1}
set +x
for patch in patches/ncurses*.patch
do
    test -e "$patch" || continue
    echo Apply patch: $patch
    patch -f -T -p1 -s < $patch
done
set -x
rm -rf patches/
find -name '*.orig' -delete
# replace tack from ncurses tarball with the latest version in
# separate tarball
rm -fr tack
tar -xzf %{S:5}
mv tack-* tack
%patch1 -p0 -b .327x
%patch4 -p0 -b .hs
%patch7 -p0 -b .bx
%patch8 -p0 -b .p8
%patch9 -p0 -b .p9
%patch10 -p0 -b .p10
%patch20 -p0 -b .p20
%patch21 -p0 -b .p21
%patch22 -p0 -b .p22
%patch23 -p0 -b .p23
%patch24 -p0 -b .p24
%patch0 -p0 -b .p0

%build
#
# Note that there is a test if the system call poll(2) really works
# on terminal or files.  To make sure that even in OBS the configure
# script has its own terminal we use screen here (could be also tmux).
# 
# Remark: A better solution would be that in OBS a real pty/tty pair
# would be used instead of redirecting stdout/stderr to a log file.
#
%global _configure	screen -D -m ./configure
    SCREENDIR=$(mktemp -d ${PWD}/screen.XXXXXX) || exit 1
    SCREENRC=${SCREENDIR}/ncurses
    export SCREENRC SCREENDIR
    exec 0< /dev/null
    SCREENLOG=${SCREENDIR}/log
    cat > $SCREENRC<<-EOF
	deflogin off
	deflog on
	logfile $SCREENLOG
	logfile flush 1
	logtstamp off
	log on
	setsid on
	scrollback 0
	silence on
	utf8 on
	EOF
    #
    # Used to test out various cflags of the gcc
    #
    cflags ()
    {
	local flag=$1; shift
	local var=$1; shift
	test -n "${flag}" -a -n "${var}" || return
	case "${!var}" in
	*${flag}*) return
	esac
	set -o noclobber
	case "$flag" in
	-Wl,*)
	    if echo 'int main () { return 0; }' | \
	       ${CC:-gcc} -Werror $flag -o /dev/null -xc - > /dev/null 2>&1 ; then
		eval $var=\${$var:+\$$var\ }$flag
	    fi
	    ;;
	*)
	    if ${CC:-gcc} -Werror $flag -S -o /dev/null -xc /dev/null > /dev/null 2>&1 ; then
		eval $var=\${$var:+\$$var\ }$flag
	    fi
	    if ${CXX:-g++} -Werror $flag -S -o /dev/null -xc++ /dev/null > /dev/null 2>&1 ; then
		eval $var=\${$var:+\$$var\ }$flag
	    fi
	esac
	set +o noclobber
    }

    test ! -f /.buildenv || . /.buildenv
       OPATH=$PATH
%ifarch s390x s390
      FALLBK="unknown,dumb,xterm,ibm327x,vt100,vt102,vt220"
%else
      FALLBK="unknown,dumb,xterm,linux,vt100,vt102,vt220"
%endif
	  CC=gcc
	 CXX=g++
    CFLAGS="${RPM_OPT_FLAGS} -pipe -D_REENTRANT"
    if [[ "$BUILD_BASENAME" = debug-* ]] ; then
	CFLAGS="${CFLAGS} -g -DTRACE"
    fi
    cflags -Wl,-O2                  LDFLAGS
    cflags -Wl,-Bsymbolic-functions LDFLAGS
    cflags -Wl,--hash-size=8599     LDFLAGS
    cflags -Wl,--as-needed          LDFLAGS
    CXXFLAGS=$CFLAGS
    test -n "$TERM" || TERM=linux
    mkdir gzip
    cat > gzip/gzip <<-'EOF'
	#!/bin/sh
	exec /usr/bin/gzip -9 ${1+"$@"}
	EOF
    chmod 0755 gzip/gzip
    PATH=$PWD/gzip:$PATH
    export CC CFLAGS CXX CXXFLAGS TERM LDFLAGS
    #
    # Detect 64bit architecures and be sure that we use an
    # unsigned long for chtype to be backward compatible with
    # already existing ncurses applications.  Otherwise we
    # might break existing applications on any update!
    #
    if test $(getconf LONG_BIT) -gt 32 ; then
	WITHCHTYPE="--with-chtype=long"
    else
	WITHCHTYPE=""
	CFLAGS="${CFLAGS} $(getconf LFS_CFLAGS)"
    fi
    #
    # Let's care about people which build ncurses on their own
    # system. That is take care that some configure tests might
    # be exploitable below /tmp ... compare with aclocal.m4
    #
    TMPDIR=$(mktemp -d /tmp/ncurses.XXXXXXXX) || exit 1
    trap 'rm -rf ${TMPDIR}' EXIT
    export TMPDIR
    #
    # getttynam(3) as well as /etc/ttys are not used under Linux
    #
    sed -ri '/^getttynam\s*\\$/d' configure
    #
    # No --enable-term-driver as this had crashed last time
    # in ncurses/tinfo/lib_setup.c due to the fact that
    # _nc_globals.term_driver was a NULL function pointer as
    # this is for the MinGW port!
    #
    # No --enable-tcap-names because we may have to recompile
    # programs or foreign programs won't work
    #
    # No --enable-safe-sprintf because this seems to
    # crash on some architectures
    #
    # No --enable-xmc-glitch because this seems to break yast2
    # on console/konsole (no magic cookie support on those?)
    #
    # No --enable-hard-tabs for users which have disabled
    # the use of tabs
    #
    touch --reference=README config.sub config.guess
    > $SCREENLOG
    tail -q -s 0.5 -f $SCREENLOG & pid=$!
    %configure \
	--without-ada		\
	--without-debug		\
	--without-profile	\
	--without-manpage-tbl	\
	--without-tests		\
	--with-shared		\
	--with-normal		\
	--with-manpage-format=gzip \
	--with-manpage-renames=${PWD}/man/man_db.renames \
	--with-manpage-aliases	\
	--with-ospeed=speed_t	\
%if 0%{?suse_version} > 1310
	--with-gpm=$(readlink %{_libdir}/libgpm.so) \
%else
	--with-gpm		\
%endif
	--with-dlsym		\
	--with-default-terminfo-dir=%{_datadir}/terminfo \
	--with-terminfo-dirs=%{_sysconfdir}/terminfo:%{_datadir}/terminfo \
	--with-xterm-kbs=del	\
	--disable-stripping	\
	--disable-root-environ	\
	--disable-termcap	\
	--disable-overwrite	\
	--disable-rpath		\
	--disable-rpath-hack	\
%if %{with memleakck}
	--disable-leaks		\
%endif
	--disable-xmc-glitch	\
	--enable-symlinks	\
	--enable-big-core	\
	--enable-const		\
	--enable-hashmap	\
	--enable-no-padding	\
	--enable-sigwinch	\
	--enable-colorfgbg	\
	--enable-sp-funcs	\
	--enable-interop	\
	--with-pthread		\
	--enable-reentrant	\
%if 0%{?suse_version} > 1500
	--enable-opaque-curses	\
	--enable-opaque-form	\
	--enable-opaque-menu	\
	--enable-opaque-panel	\
%endif
	--enable-ext-mouse	\
	--enable-widec		\
	--with-termlib=%{soname_tinfo}	\
	--with-ticlib=ticw	\
%if %{with symversion}
	--with-versioned-syms=${PWD}/package/ncursestw.map \
%endif
	--enable-ext-colors	\
	--enable-weak-symbols	\
	--enable-wgetch-events	\
	--enable-pthreads-eintr	\
	--enable-string-hacks	\
	--prefix=%{_prefix}	\
	--exec-prefix=%{_prefix}\
	--libdir=%{_libdir}	\
	--datadir=%{_datadir}	\
	--mandir=%{_mandir}	\
	--includedir=%{_incdir}	\
	"${WITHCHTYPE}" 	\
	--disable-tic-depends	\
	--with-cxx-shared	\
	--with-pc-suffix	\
	--enable-pc-files	\
%if 0%{?_crossbuild}
	--with-fallbacks="$FALLBK" \
%else
	--with-fallbacks=""	\
%endif
%if %{with hasheddb}
	--with-hashed-db	\
%endif
	--with-pkg-config-libdir=%{_libdir}/pkgconfig
    sleep 1
    kill $pid
    #
    #  The configure line used above.  Note that we override
    #  several options later with other configurations.
    #  It has been verified several times that this works.
    #
    c=$(grep '^ *$ *\./configure' config.log)
    make -C c++ etip.h
    make %{?_smp_mflags}
    #
    # Refresh second install path
    #
    rm -rf %{root}
    mkdir  %{root}
%if !0%{?_crossbuild}
    #
    # This is a hack to be able to boot strap libncurses with
    # our preferred fallback.c.  For this we need the appropiate
    # tools list infocmp(1) and tic(1).  The first step was with
    # an empty fallback.c, now we include the latest terminfo
    # of our preferred fallback terminfo list into the final
    # fallback.c.
    #
    mkdir lib/.build
    cp -p progs/tic progs/tic.build
    cp -p progs/infocmp progs/infocmp.build
    cp -p lib/*.so* lib/.build/
    PATH=$PWD/progs:$OPATH
    export PATH
    (cat > ${PWD}/.build_tic)<<-EOF
	export LD_LIBRARY_PATH=$PWD/lib/.build
	export BUILD_TIC=$PWD/progs/tic.build
	export BUILD_INFOCMP=$PWD/progs/infocmp.build
	EOF
    pushd ncurses/
	TERMINFO=$PWD/tmp
	export TERMINFO
	mkdir -p $TERMINFO
	. ${PWD}/../.build_tic
	$BUILD_TIC -I -r -e $FALLBK ../misc/terminfo.src > terminfo.src
	$BUILD_TIC -o $TERMINFO -s terminfo.src
	sh -e ./tinfo/MKfallback.sh $TERMINFO ../misc/terminfo.src $BUILD_TIC ${FALLBK//,/ } > fallback.c
	rm -rf $TERMINFO
	unset  TERMINFO
	cp -p fallback.c ../fallback.c.build
	unset LD_LIBRARY_PATH
    popd
    PATH=$OPATH
    #
    # Now rebuild libncurses and do the rest of this job
    #
    find -name fallback.o -print -delete
    cp fallback.c.build ncurses/fallback.c
    make -C c++ etip.h
    make %{?_smp_mflags}
%else
    (cat > ${PWD}/.build_tic)<<-EOF
	export BUILD_TIC=/usr/bin/tic
	export BUILD_INFOCMP=/usr/bin/infocmp
	EOF
%endif
    # must not use %jobs here (would lead to: ln: ncurses.h already exists)
    find man/ -name '*.[1-8]x.*' -print -delete
    make install DESTDIR=%{root} includedir=%{_incdir} includesubdir=/ncursesw libdir=%{_libdir}
%if %{with onlytinfo}
    # This ensures that we get the libtinfo *with* _nc_read_entry2 symbol as well
    gcc $CFLAGS $LDFLAGS -fPIC -shared -Wl,--auxiliary=libtinfo.so.6,-soname,libtinfow.so.6,-stats,-lc \
	 -Wl,--version-script,ncurses/resulting.map -o %{root}%{_libdir}/libtinfow.so.%{version}
    cp -p %{root}%{_libdir}/libtinfo.so.%{version}  libtinfo.so.%{version}.back
    cp -p %{root}%{_libdir}/libtinfow.so.%{version} libtinfow.so.%{version}.back
%endif
    ln -sf %{_incdir}/ncurses/{curses,ncurses,term,termcap}.h %{root}%{_incdir}
    sh %{S:6} --cflags "-D_GNU_SOURCE -I%{_incdir}/ncursesw" --libs "-lncursesw" \
	--libs "-l%{soname_tinfo}" %{root}%{_bindir}/ncursesw6-config
    mkdir pc
    mv -f %{root}%{_libdir}/pkgconfig/*.pc pc/
    #
    # Some tests
    #
%if 0%{?qemu_user_space_build:1}%{?_crossbuild}
	echo "Skipping tests due to running under QEMU / cross-building"
%else
    #
    # Check for tack program on base of above ncurses
    #
    LD_LIBRARY_PATH=$PWD/lib
    export LD_LIBRARY_PATH PATH
    pushd tack/
	ldd ./tack
    popd
    unset LD_LIBRARY_PATH
%if 0%{?suse_version} > 1500
    #
    # Make the test suite for ncursesw6
    #
    pushd test
	CFLAGS="$CFLAGS -I%{root}%{_incdir}" LDFLAGS="$LDFLAGS -Wl,-rpath-link=%{root}%{_libdir} -L%{root}%{_libdir}" \
	./configure --with-ncursesw --enable-widec --prefix=$PWD
	LD_LIBRARY_PATH=%{root}%{_libdir} \
	make %{?_smp_mflags} TEST_ARGS='-lformw -lmenuw -lpanelw -lncursesw -lticw -l%{soname_tinfo} -Wl,--as-needed'
	make install TEST_ARGS='-lformw -lmenuw -lpanelw -lncursesw -lticw -l%{soname_tinfo} -Wl,--as-needed'
	mv bin binw
	make distclean
    popd
%endif
%endif
    test ! -L tack || rm -f tack
    make clean
    #
    # Now use --without-pthread to disable pthread support (abi == 5).
    #
    > $SCREENLOG
    tail -q -s 0.5 -f $SCREENLOG & pid=$!

    eval screen -D -m ./${c#*./} --with-abi-version=5		\
				    --without-manpages		\
				    --without-progs		\
				    --without-tack		\
				    --without-pthread		\
				    --disable-reentrant		\
				    --disable-opaque-curses	\
				    --disable-opaque-form	\
				    --disable-opaque-menu	\
				    --disable-opaque-panel	\
				    --disable-ext-mouse		\
				    --disable-widec		\
				    --with-termlib=tinfo	\
				    --with-ticlib=tic		\
%if %{with symversion}
				    --with-versioned-syms=${PWD}/package/ncurses.map \
%endif
				    --disable-ext-colors	\
				    --disable-overwrite		\
				    --without-progs
    sleep 1
    kill $pid
%if !0%{?_crossbuild}
    find -name fallback.o -print -delete
    cp fallback.c.build ncurses/fallback.c
%endif
    make -C c++ etip.h
    make %{?_smp_mflags}
    sed -ri 's@^(LDFLAGS=)$@\1-L\\${libdir}@
	     s@^(libdir=).show_libdir@\1%{_libdir}/ncurses5@
	     s@^(includedir=).show_includedir@\1%{_incdir}/ncurses5@' misc/gen-pkgconfig
    # must not use %jobs here (would lead to: ln: ncurses.h already exists)
    make install.libs install.includes DESTDIR=%{root} includedir=%{_incdir}/ncurses5 includesubdir=/ncurses libdir=%{_libdir}/ncurses5
    ln -sf %{_incdir}/ncurses5/ncurses/{curses,ncurses,term}.h %{root}%{_incdir}/ncurses5/
    sh %{S:6} --cflags "-D_GNU_SOURCE -I%{_incdir}/ncurses5/ncurses -I%{_incdir}/ncurses5" --libs "-L%{_libdir}/ncurses5 -lncurses" \
	--libs "-ltinfo" %{root}%{_bindir}/ncurses5-config
    pushd man
	sh ../edit_man.sh normal installing %{root}%{_mandir} . ncurses5-config.1
    popd
    for pc in %{root}%{_libdir}/pkgconfig/*.pc
    do
	test -e "$pc" || break
	base=${pc%%.pc}
	base=${base##*/}
	case "$base" in
	tic) sed -ri 's@^(Requires.private: ).*@\1tinfo5@'   "$pc" ;;
	*)   sed -ri 's@^(Requires.private: ).*@\1ncurses5@' "$pc"
	esac
	mv -f $pc pc/${base}5.pc
    done

    #
    # Now use --disable-widec for narrow character support.
    # The libs with 16 bit wide characters are binary incompatible
    # to the normal 8bit wide character libs.
    #
    make clean
    > $SCREENLOG
    tail -q -s 0.5 -f $SCREENLOG & pid=$!
    eval screen -D -m ./${c#*./} --with-pthread			\
				    --without-manpages		\
				    --without-progs		\
				    --without-tack		\
				    --enable-reentrant		\
				    --enable-opaque-curses	\
				    --enable-opaque-form	\
				    --enable-opaque-menu	\
				    --enable-opaque-panel	\
				    --enable-ext-mouse		\
				    --disable-widec		\
				    --with-termlib=tinfo	\
				    --with-ticlib=tic		\
%if %{with symversion}
				    --with-versioned-syms=${PWD}/package/ncursest.map \
%endif
				    --enable-ext-colors		\
				    --disable-overwrite		\
				    --without-progs
    sleep 1
    kill $pid
%if !0%{?_crossbuild}
    find -name fallback.o -print -delete
    cp fallback.c.build ncurses/fallback.c
%endif
    make -C c++ etip.h
    make %{?_smp_mflags}
    # must not use %jobs here (would lead to: ln: ncurses.h already exists)
    make install.libs install.includes DESTDIR=%{root} includedir=%{_incdir} includesubdir=/ncurses libdir=%{_libdir}
%if %{with onlytinfo}
    # This ensures that we get the libtinfo *with* _nc_read_entry2 symbol as well
    cp -p libtinfo.so.%{version}.back  %{root}%{_libdir}/libtinfo.so.%{version}
    cp -p libtinfow.so.%{version}.back %{root}%{_libdir}/libtinfow.so.%{version}
%endif
    sh %{S:6} --cflags "-D_GNU_SOURCE -I%{_incdir}/ncurses" --libs "-lncurses" \
	--libs "-ltinfo" %{root}%{_bindir}/ncurses6-config
    pushd man
	sh ../edit_man.sh normal installing %{root}%{_mandir} . ncurses6-config.1
    popd
    mv -f %{root}%{_libdir}/pkgconfig/*.pc pc/
    #
    # Some tests
    #
%if 0%{?qemu_user_space_build:1}%{?_crossbuild} || 0%{?suse_version} <= 1500
	echo "Skipping tests due to running under QEMU / cross-building"
%else
    #
    # Make the test suite for ncurses6
    #
    pushd test
	CFLAGS="$CFLAGS -I%{root}%{_incdir}" LDFLAGS="$LDFLAGS -Wl,-rpath-link=%{root}%{_libdir} -L%{root}%{_libdir}" \
	./configure --with-ncurses --disable-widec --prefix=$PWD
	LD_LIBRARY_PATH=%{root}%{_libdir} \
	make %{?_smp_mflags} TEST_ARGS='-lform -lmenu -lpanel -lncurses -ltic -ltinfo -Wl,--as-needed'
	make install TEST_ARGS='-lform -lmenu -lpanel -lncurses -ltic -ltinfo -Wl,--as-needed'
	make distclean
    popd
%endif
    test ! -L tack || rm -f tack
    make clean
    #
    # ABI == 5
    #
    > $SCREENLOG
    tail -q -s 0.5 -f $SCREENLOG & pid=$!

    #
    # Now use --without-pthread to disable pthread support (abi == 5).
    #
    eval screen -D -m ./${c#*./} --with-abi-version=5		\
				    --without-manpages		\
				    --without-progs		\
				    --without-tack		\
				    --without-pthread		\
				    --disable-reentrant		\
				    --disable-opaque-curses	\
				    --disable-opaque-form	\
				    --disable-opaque-menu	\
				    --disable-opaque-panel	\
				    --disable-ext-mouse		\
				    --enable-widec		\
				    --with-termlib=%{soname_tinfo}	\
				    --with-ticlib=ticw		\
%if %{with symversion}
				    --with-versioned-syms=${PWD}/package/ncursesw.map \
%endif
				    --disable-ext-colors	\
				    --disable-overwrite		\
				    --without-progs
    sleep 1
    kill $pid
%if !0%{?_crossbuild}
    find -name fallback.o -print -delete
    cp fallback.c.build ncurses/fallback.c
%endif
    make -C c++ etip.h
    make %{?_smp_mflags}
    sed -ri 's@^(LDFLAGS=)$@\1-L\\${libdir}@
	     s@^(libdir=).show_libdir@\1%{_libdir}/ncurses5@
	     s@^(includedir=).show_includedir@\1%{_incdir}/ncurses5/ncursesw@' misc/gen-pkgconfig
    # must not use %jobs here (would lead to: ln: ncurses.h already exists)
    make install.libs install.includes DESTDIR=%{root} includedir=%{_incdir}/ncurses5 includesubdir=/ncursesw libdir=%{_libdir}/ncurses5
%if %{with onlytinfo}
    gcc $CFLAGS $LDFLAGS -fPIC -shared -Wl,--auxiliary=libtinfo.so.5,-soname,libtinfow.so.5,-stats,-lc \
	-Wl,--version-script,package/ncursesw.map -o %{root}%{_libdir}/libtinfow.so.5.9
%endif
    sh %{S:6} --cflags "-D_GNU_SOURCE -I%{_incdir}/ncurses5/ncursesw -I%{_incdir}/ncurses5" --libs "-L%{_libdir}/ncurses5 -lncursesw" \
	--libs "-l%{soname_tinfo}" %{root}%{_bindir}/ncursesw5-config
    pushd man
	sh ../edit_man.sh normal installing %{root}%{_mandir} . ncursesw5-config.1
    popd
    for pc in %{root}%{_libdir}/pkgconfig/*.pc
    do
	test -e "$pc" || break
	base=${pc%%.pc}
	base=${base##*/}
	case "$base" in
	tinfo) sed -ri 's@(includedir=/usr/include/ncurses5/ncurses)w.*@\1@' "$pc" ;;
	tic)   sed -ri 's@(includedir=/usr/include/ncurses5/ncurses)w.*@\1@' "$pc" ;;
	esac
	case "$base" in
	tic) sed -ri 's@^(Requires.private: ).*@\1tinfo5@'   "$pc" ;;
	*)   sed -ri 's@^(Requires.private: ).*@\1ncurses5@' "$pc"
	esac
	mv -f $pc pc/${base}5.pc
    done

%install
    PATH=$PWD/gzip:$PATH
    (cd %{root}/; tar -cpSf - *)|tar -xpsSf - -C %{buildroot}/
    rm -rf %{root}
    mkdir %{buildroot}/%{_lib}
    for model in libncurses libncursest libncursesw libncursestw libtinfo libtinfow libtic libticw
    do
	for lib in %{buildroot}%{_libdir}/${model}.so.* ; do
	    test   -e "${lib}" || continue
	    mv "${lib}" %{buildroot}/%{_lib}/ || continue
	done
	for lib in %{buildroot}/%{_lib}/${model}.so.6 ; do
	    test -e "${lib}" || continue
	    test -L "${lib}" || continue
	    lib=${lib#%{buildroot}}
	    lnk=%{buildroot}%{_libdir}/${model}.so
	    case "${lib##*/}" in
	    libncursesw*)
		rm -f ${lnk}
		echo '/* GNU ld script */'			>  ${lnk}
		echo "INPUT(${lib} AS_NEEDED(-l%{soname_tinfo} -ldl))"	>> ${lnk}
		;;
	    libncurses*)
		rm -f ${lnk}
		echo '/* GNU ld script */'			>  ${lnk}
		echo "INPUT(${lib} AS_NEEDED(-ltinfo -ldl))"	>> ${lnk}
		;;
	    *)	ln -sf ${lib} %{buildroot}%{_libdir}/${model}.so
	    esac
	done
    done
%if 0
    lnk=%{buildroot}%{_libdir}/libtermcap.so
    echo '/* GNU ld script */'		>  ${lnk}
    echo "INPUT(AS_NEEDED(-ltinfo))"	>> ${lnk}
%endif
    chmod 0755 %{buildroot}/%{_lib}/lib*.so.*
    chmod 0755 %{buildroot}/%{_libdir}/lib*.so.*
    chmod a-x  %{buildroot}/%{_libdir}/lib*.a
    if test -d %{buildroot}%{_libdir}/ncurses5 ; then
	mv %{buildroot}%{_libdir}/ncurses5/*.so.5*   %{buildroot}%{_libdir}/
	for lib in %{buildroot}%{_libdir}/ncurses5/*.so
	do
	    lnk=$lib
	    lib=/%{_lib}/${lib##*/}.5
	    case "${lib##*/}" in
	    libncursesw*)
		rm -f "${lnk}"
		echo '/* GNU ld script */'		>  ${lnk}
		echo "INPUT(${lib} AS_NEEDED(-l%{soname_tinfo}))">> ${lnk} 
		;;
	    libncurses*)
		rm -f "${lnk}"
		echo '/* GNU ld script */'		>  ${lnk}
		echo "INPUT(${lib} AS_NEEDED(-ltinfo))"	>> ${lnk} 
		;;
	    libtinfo*)
		test -L "${lnk}" || continue
		ln -sf ${lib} ${lnk}
		;;
	    *)
		test -L "${lnk}" || continue
		ln -sf ../${lib##*/} ${lnk}
	    esac
	done
	for model in libncurses libncursest libncursesw libncursestw libtinfo libtinfow libtic libticw
	do
	    for lib in %{buildroot}%{_libdir}/${model}.so.* ; do
		test   -e "${lib}" || continue
		mv "${lib}" %{buildroot}/%{_lib}/ || continue
	    done
	    for lib in %{buildroot}/%{_lib}/${model}.so.5 ; do
		test -e "${lib}" || continue
		test -L "${lib}" || continue
		lib=${lib#%{buildroot}}
		lnk=%{buildroot}%{_libdir}/ncurses5/${model}.so
		case "${lib##*/}" in
		libncursesw*)
		    rm -f ${lnk}
		    echo '/* GNU ld script */'		    >  ${lnk}
		    echo 'SEARCH_DIR(%{_libdir}/ncurses5)'  >> ${lnk}
		    echo "INPUT(${lib} AS_NEEDED(-l%{soname_tinfo}))">> ${lnk}
		    ;;
		libncurses*)
		    rm -f ${lnk}
		    echo '/* GNU ld script */'		    >  ${lnk}
		    echo 'SEARCH_DIR(%{_libdir}/ncurses5)'  >> ${lnk}
		    echo "INPUT(${lib} AS_NEEDED(-ltinfo))" >> ${lnk}
		    ;;
		*)  ln -sf ${lib} %{buildroot}%{_libdir}/ncurses5/${model}.so
	    esac
	    done
	done
	chmod 0755 %{buildroot}/%{_lib}/lib*.so.5*
	chmod 0755 %{buildroot}/%{_libdir}/lib*.so.5*
	chmod a-x  %{buildroot}/%{_libdir}/ncurses5/lib*.a
    fi
    test -n "%{buildroot}" || ldconfig -N
    mkdir -p %{buildroot}%{_defaultdocdir}/ncurses
    bzip2 -c misc/terminfo.src > misc/terminfo.src.bz2
    install -m 644 misc/terminfo.src.bz2	%{buildroot}%{_defaultdocdir}/ncurses/
    install -m 644 doc/html/*.html		%{buildroot}%{_defaultdocdir}/ncurses/
    bzip2 doc/ncurses-intro.doc -c > doc/ncurses-intro.txt.bz2
    install -m 644 doc/ncurses-intro.txt.bz2	%{buildroot}%{_defaultdocdir}/ncurses/
    bzip2 doc/hackguide.doc -c > doc/hackguide.txt.bz2
    install -m 644 doc/hackguide.txt.bz2	%{buildroot}%{_defaultdocdir}/ncurses/
    install -m 644 %{S:3}			%{buildroot}%{_defaultdocdir}/ncurses/
    install -m 644 README			%{buildroot}%{_defaultdocdir}/ncurses/
    install -m 644 NEWS				%{buildroot}%{_defaultdocdir}/ncurses/
    mkdir -p %{buildroot}%{_sysconfdir}/terminfo
    mkdir -p %{buildroot}%{_miscdir}
    pushd ncurses/
	. ${PWD}/../.build_tic
	{ echo "# See annotated version in %{_defaultdocdir}/ncurses/terminfo.src.bz2"
	$BUILD_TIC -C -r ../misc/terminfo.src | grep -E -v '^#'; } > termcap
	# Gererate new termcap entries for various linux consoles
	TERMCAP=termcap \
	TERMINFO=%{buildroot}%{_datadir}/terminfo \
	    bash %{SOURCE2}
	install -m 0644 termcap.new %{buildroot}%{_miscdir}/termcap
	unset LD_LIBRARY_PATH
    popd
    if test `%{_bindir}/id -u` = '0' ; then
	chown root:root %{buildroot}%{_miscdir}/termcap
	chmod 0644      %{buildroot}%{_miscdir}/termcap
    fi
    ln -sf %{_miscdir}/termcap %{buildroot}%{_sysconfdir}/termcap
    (cat > default.list) <<-EOF
	%{tabset std}
	%{tabset stdcrt}
	%{tabset vt100}
	%{tabset vt300}
	%{terminfo a/ansi}
	%{terminfo a/arpanet}
	%{terminfo d/dumb}
	%{terminfo d/dialup}
	%{terminfo g/gnome}
	%{terminfo g/gnome-rh72}
	%{terminfo g/gnome-rh80}
	%{terminfo g/gnome-rh90}
	%{terminfo g/gnome-fc5}
	%{terminfo i/ibm327x}
	%{terminfo k/klone+color}
	%{terminfo k/konsole}
	%{terminfo k/konsole-256color}
	%{terminfo k/kvt}
	%{terminfo k/kvt-rh}
	%{terminfo l/linux}
	%{terminfo l/linux-m}
	%{terminfo l/linux-nic}
	%{terminfo m/mlterm}
	%{terminfo n/net}
	%{terminfo n/network}
	%{terminfo n/nxterm}
	%{terminfo p/patch}
	%{terminfo r/rxvt}
	%{terminfo r/rxvt-basic}
	%{terminfo r/rxvt-color}
	%{terminfo r/rxvt-256color}
	%{terminfo r/rxvt-unicode}
	%{terminfo r/rxvt-unicode-256color}
	%{terminfo s/screen+fkeys}
	%{terminfo s/screen}
	%{terminfo s/screen-16color}
	%{terminfo s/screen-256color}
	%{terminfo s/screen-bce}
	%{terminfo s/screen-w}
	%{terminfo s/sun}
	%{terminfo s/switch}
	%{terminfo u/unknown}
	%{terminfo v/vt100}
	%{terminfo v/vt102}
	%{terminfo v/vt220}
	%{terminfo v/vt220-8}
	%{terminfo v/vt220-8bit}
	%{terminfo v/vt320}
	%{terminfo v/vt52}
	%{terminfo v/vte}
	%{terminfo x/xterm}
	%{terminfo x/xterm-color}
	%{terminfo x/xterm-256color}
	%{terminfo x/xterm-basic}
	%{terminfo x/xterm-nic}
	%{terminfo x/xterm-r6}
	EOF
# Better screen support and workaround about missing terminfo entries
# might be help on boo#812067 as well as on boo#935736 but may cause
# boo#940459  (which should be fixed by screen its self!)
    rm -vf  %{buildroot}%{terminfo s/screen.xterm}
    (cat > screen.list) <<-EOF
	%{terminfo s/screen.gnome}
	%{terminfo s/screen.konsole}
	%{terminfo s/screen.linux}
	EOF
    (cat > iterm.list) <<-EOF
	%{terminfo i/iTerm.app}
	%{terminfo i/iTerm2.app}
	%{terminfo i/iterm}
	%{terminfo i/iterm2}
	EOF
    find %{buildroot}%{tabset ""} %{buildroot}%{terminfo ""} \
	\( -type f -or -type l \) | \
	sed "s@^%{buildroot}@@g" | \
	grep -v -F -x -f default.list -f screen.list -f iterm.list \
	> extension.list
    rm -f %{buildroot}%{_prefix}/lib/terminfo
    mv pc/*.pc %{buildroot}%{_libdir}/pkgconfig/

%if 0%{?qemu_user_space_build:1}%{?_crossbuild}
# No test here
%else
%check
LD_LIBRARY_PATH=%{buildroot}/%{_lib}:%{buildroot}%{_libdir}
export LD_LIBRARY_PATH
%if %{with onlytinfo}
nm -D %{buildroot}/%{_lib}/libtinfo.so.%{version} | grep -q _nc_read_entry2
%endif
%if 0%{?suse_version} > 1500
pushd test
    expect -d <<-'EOF'
	set env(TERM) xterm
	set timeout 20
	spawn -noecho "binw/newdemo"
	send -- "x"
	sleep 5
	send -- "x"
	sleep 5
	send -- "x"
	sleep 5
	send -- "q"
	wait -nowait
	EOF
    expect -d <<-'EOF'
	set env(TERM) xterm
	set timeout 20
	spawn -noecho "bin/newdemo"
	send -- "x"
	sleep 5
	send -- "x"
	sleep 5
	send -- "x"
	sleep 5
	send -- "q"
	wait -nowait
	EOF
popd
%endif
%endif

%post   -n libncurses5 -p /sbin/ldconfig

%postun -n libncurses5 -p /sbin/ldconfig

%post   -n libncurses6 -p /sbin/ldconfig

%postun -n libncurses6 -p /sbin/ldconfig

%files -n terminfo-base -f default.list
%defattr(-,root,root)
%{_sysconfdir}/termcap
%config %{_miscdir}/termcap
%dir %{_sysconfdir}/terminfo
%dir %{_datadir}/tabset/
%dir %{_datadir}/terminfo/
%dir %{_datadir}/terminfo/*/

%files -n terminfo-screen -f screen.list
%defattr(-,root,root)
%dir %{_datadir}/terminfo/

%files -n terminfo-iterm -f iterm.list
%defattr(-,root,root)
%dir %{_datadir}/terminfo/

%files -n ncurses-utils
%defattr(-,root,root)
%{_bindir}/clear
%{_bindir}/infocmp
%{_bindir}/reset
%{_bindir}/tabs
%{_bindir}/toe
%{_bindir}/tput
%{_bindir}/tset
%doc %{_mandir}/man1/clear.1.gz
%doc %{_mandir}/man1/infocmp.1.gz
%doc %{_mandir}/man1/reset.1.gz
%doc %{_mandir}/man1/tabs.1.gz
%doc %{_mandir}/man1/toe.1.gz
%doc %{_mandir}/man1/tput.1.gz
%doc %{_mandir}/man1/tset.1.gz
%doc %{_mandir}/man5/*.gz
%doc AUTHORS

%files -n libncurses5
%defattr(-,root,root)
/%{_lib}/lib*.so.5*
%{_libdir}/lib*.so.5*

%files -n libncurses6
%defattr(-,root,root)
/%{_lib}/lib*.so.6*
%{_libdir}/lib*.so.6*

%files -n ncurses-devel
%defattr(-,root,root)
%dir %{_defaultdocdir}/ncurses/
%doc %{_defaultdocdir}/ncurses/*
%{_bindir}/ncurses*6-config
%{_bindir}/captoinfo
%{_bindir}/infotocap
%{_bindir}/tic
%dir %{_incdir}/ncurses/
%dir %{_incdir}/ncursesw/
%{_incdir}/*.h
%{_incdir}/ncurses/*.h
%{_incdir}/ncursesw/*.h
%{_libdir}/lib*.a
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/*[clmosuw\+].pc
%doc %{_mandir}/man1/ncurses*6-config.1.gz
%doc %{_mandir}/man1/captoinfo.1.gz
%doc %{_mandir}/man1/infotocap.1.gz
%doc %{_mandir}/man1/tic.1.gz
%doc %{_mandir}/man3/*.gz
%doc %{_mandir}/man7/*.gz

%files -n ncurses5-devel
%defattr(-,root,root)
%{_bindir}/ncurses*5-config
%dir %{_incdir}/ncurses5/
%dir %{_incdir}/ncurses5/ncurses/
%dir %{_incdir}/ncurses5/ncursesw/
%{_incdir}/ncurses5/*.h
%{_incdir}/ncurses5/ncurses/*.h
%{_incdir}/ncurses5/ncursesw/*.h
%dir %{_libdir}/ncurses5/
%{_libdir}/ncurses5/lib*.a
%{_libdir}/ncurses5/lib*.so
%{_libdir}/pkgconfig/*5.pc
%doc %{_mandir}/man1/ncurses*5-config.1.gz

%files -n tack
%defattr(-,root,root)
%{_bindir}/tack
%doc %{_mandir}/man1/tack.1.gz

%files -f extension.list -n terminfo
%defattr(-,root,root)

%changelog
* Wed Apr  9 2025 werner@suse.de
- Modify patch ncurses-5.9-ibm327x.dif
  * Backport sclp terminfo description entry if for s390 sclp terminal lines
  * Add a further sclp entry for qemu s390 based systems
  * Make use of dumb
* Tue Sep 10 2024 werner@suse.de
- Add patch ncurses-6.1-boo1229028.patch (boo#1229028)
  * Allow that terminal description based on static fallback
    entries can be freed.
* Mon Feb 19 2024 werner@suse.de
- Add patch ncurses-6.1-bsc1220061.patch (bsc#1220061, CVE-2023-45918)
  * Backport from ncurses-6.4-20230615.patch
    improve checks in convert_string() for corrupt terminfo entry
* Wed Dec 13 2023 werner@suse.de
- Add patch bsc1218014-cve-2023-50495.patch
  * Fix CVE-2023-50495: segmentation fault via _nc_wrap_entry()
    (bsc#1218014)
* Tue Dec 12 2023 werner@suse.de
- Add patch boo1201384.patch
  * Do not fully reset serial lines
* Thu Apr 27 2023 werner@suse.de
- Modify patch ncurses-6.1.dif
  * Secure writing terminfo entries by setfs[gu]id in s[gu]id
    (boo#1210434, CVE-2023-29491)
  * Reading is done since 2000/01/17
* Fri Jul 15 2022 werner@suse.de
- Add patch ncurses-bnc1198627.patch
  * Fix bsc#1198627: CVE-2022-29458: ncurses: segfaulting OOB read
* Wed Oct 13 2021 werner@suse.de
- Add patch bsc1190793-63ca9e06.patch to fix bsc#1190793 for
  CVE-2021-39537: ncurses: heap-based buffer overflow in
  _nc_captoinfo in captoinfo.c
* Tue Oct 15 2019 werner@suse.de
- Add patches
  CVE-2019-17594.patch for bsc#1154036 -- CVE-2019-17594: heap-based
    buffer over-read in _nc_find_entry function in tinfo/comp_hash.c
  CVE-2019-17595.patch for bsc#1154037 -- CVE-2019-17595: heap-based
    buffer over-read in fmt_entry function in tinfo/comp_hash.c
* Wed Nov 21 2018 werner@suse.de
- Remove screen.xterm from terminfo data base (boo#1103320) as with
  this screen uses fallback TERM=screen
* Tue Nov 20 2018 werner@suse.de
- Add patch ncurses-5.9-bsc1115929.patch
  * For bug bsc#1115929 port back null pointer checks to catch e.g.
    the crash in _nc_parse_entry(), belongs to CVE-2018-19211
* Wed Mar 21 2018 werner@suse.de
- Change baselibs.conf to avoid mixed version requirements (bsc#1082744)
* Mon Mar 19 2018 werner@suse.de
- Add ncurses patch 6.1-20180317
  + fix a check in infotocap which may not have detected a problem when
    it should have.
  + add a check in tic for the case where setf/setb are given using
    different strings, but provide identical results to setaf/setab.
  + further improve fix for terminfo.5 (patch by Kir Kolyshkin).
  + reorder loop-limit checks in winsnstr() in case the string has no
    terminating null and only the number of characters is used (patch
    by Gyorgy Jeney).
* Thu Mar  8 2018 werner@suse.de
- Avoid opaque libraries for Leap 15 and SLES 15
- No tests on Leap 15 and SLES 15
* Mon Mar  5 2018 werner@suse.de
- Add ncurses patch 6.1-20180303
  + modify TurnOn/TurnOff macros in lib_vidattr.c and lib_vid_attr.c to
    avoid expansion of "CUR" in trace.
  + improve a few lintian warnings in test-packages.
  + modify lib_setup to avoid calling pthread_self() without first
    verifying that the address is valid, i.e., for weak symbols
    (report/patch by Werner Fink).
  + modify generated terminfo.5 to not use "expand" and related width
    on the last column of tables, making layout on wide terminals look
    better (adapted from patch by Kir Kolyshkin).
  + add a category to report_offsets, e.g., "w" for wide-character, "t"
    for threads to make the report more readable.  Reorganized the
    structures reported to make the categories more apparent.
  + simplify some ifdef's for extended-colors.
  + add NCURSES_GLOBALS and NCURSES_PRESCREEN to report_offsets, to show
    how similar the different tinfo configurations are.
- Remove patch ncurses-6.1-weakpthreads.dif now upstream (bsc#1082772)
- Make expect build check less fragile on timing
* Fri Mar  2 2018 werner@suse.de
- Switch back to shared libtinfo only but provide an auxiliary shared
  library libtinfow to avoid a rebuild of third party programs (bsc#1082772)
  + Add sanity check if new 32bit API is included in libtinfo
* Thu Mar  1 2018 werner@suse.de
- Add patch ncurses-6.1-weakpthreads.dif
  + Be aware that libtinfo/libtinfw is also used without libpthread
    (boo#1058509)
- Use expect to run at least two test for normal and wide character
  version of newdemo from test suite
* Mon Feb 26 2018 werner@suse.de
- Add ncurses patch 6.1-20180224
  + modify _nc_resolve_uses2() to detect incompatible types when merging
    a "use=" clause of extended capabilities.  The problem was seen in a
    defective terminfo integrated from simpleterm sources in 20171111,
    compounded by repair in 20180121.
  + correct Ss/Ms interchange in st-0.7 entry (tmux #1264) -TD
  + fix remaining flash capabilities with trailing mandatory delays -TD
  + correct cut/paste in NEWS (report by Sven Joachim).
* Mon Feb 19 2018 werner@suse.de
- Add ncurses patch 6.1-20180217
  + remove incorrect free() from 20170617 changes (report by David Macek).
  + correct type for "U8" in user_caps.5; it is a number not boolean.
  + add a null-pointer check in safe_sprintf.c (report by Steven Noonan).
  + improve fix for Debian #882620 by reusing limit2 variable (report
    Julien Cristau, Sven Joachim).
* Thu Feb 15 2018 werner@suse.de
- Add ncurses patch 6.1-20180210
  + modify misc/Makefile.in to install/uninstall explicit list in case
    the build-directory happens to have no ".pc" files when an uninstall
    is performed (report by Jeffrey Walton).
  + deprecate safe-sprintf, since the vsnprintf function, which does what
    was needed, was standardized long ago.
  + add several development/experimental options to development packages.
  + minor reordering of options in configure script to make the threaded
    and reentrant options distinct from the other extensions which are
    normally enabled.
- Make reentrant libs opaque
* Mon Feb  5 2018 werner@suse.de
- Add ncurses patch 6.1-20180203
  + minor fixes to test/*.h to make them idempotent.
  + add/use test/parse_rgb.h to show how the "RGB" capability works.
  + add a clarification in user_caps.5 regarding "RGB" capability.
  + add extended_slk_color{,_sp} symbols to the appropriate
    package/*.{map,sym} files (report by Sven Joachim, cf: 20170401).
* Tue Jan 30 2018 werner@suse.de
- Add ncurses patch 6.1-20180129
  + update "VERSION" file, used in shared-library naming.
* Tue Jan 30 2018 werner@suse.de
- Correct include path for wide chraracter header files for ABI 6.1
* Mon Jan 29 2018 werner@suse.de
- Update to ncurses 6.1 (patch 20180127)
  + updated release notes
  + amend a warning message from tic which should have flagged misuse
    of "XT" capability in "screen" terminal description.
  > terminfo changes:
  + trim "XT" from screen entry, add comments to explain why it was
    not suitable -TD
  + modify iterm to use xterm+sl-twm building block -TD
  + mark konsole-420pc, konsole-vt100, konsole-xf3x obsolete reflecting
    konsole's removal in 2008 -TD
  + expanded the history section of konsole to explain its flawed
    imitation of xterm's keyboard -TD
  + use xterm+x11mouse in screen.* entries because screen does not yet
    support xterm's 1006 mode -TD
  + add nsterm-build400 for macOS 10.13 -TD
  + add ansi+idc1, use that in ansi+idc adding dch for consistency -TD
  + update vte to vte-2017 -TD
  + add ecma+strikeout to vte-2017 -TD
  + add iterm2-direct -TD
  + updated teraterm, added teraterm-256color -TD
  + add mlterm-direct -TD
  + add descriptions for ANSI building-blocks -TD
- Modify patch ncurses-5.9-ibm327x.dif
- Rename patch ncurses-6.0.dif to new name ncurses-6.1.dif
- Modify patch ncurses-6.1.dif
* Mon Jan 22 2018 werner@suse.de
- Add ncurses patch 20180121 pre-release 6.1
  > terminfo changes:
  + add xterm+noalt, xterm+titlestack, xterm+alt1049, xterm+alt+title
    blocks from xterm #331 -TD
  + add xterm+direct, xterm+indirect, xterm-direct entries from xterm
    [#331] -TD
  + modify xterm+256color and xterm+256setaf to use correct number of
    color pairs, for ncurses 6.1 -TD
  + add rs1 capability to xterm-256color -TD
  + modify xterm-r5, xterm-r6 and xterm-xf86-v32 to use xterm+kbs to
    match xterm #272, reflecting packager's changes -TD
  + remove "boolean" Se, Ss from st-0.7 -TD
  + add konsole-direct and st-direct -TD
  + remove unsupported "Tc" capability from st-0.7; use st-direct if
    direct-colors are wanted -TD
  + add vte-direct -TD
  + add XT, hpa, indn, and vpa to screen, and invis, E3 to tmux (patch by
    Pierre Carru)
  + use xterm+sm+1006 in xterm-new, vte-2014 -TD
  + use xterm+x11mouse in iterm, iterm2, mlterm3 because xterm's 1006
    mode does not work with those programs.  konsole is debatable -TD
  + add "termite" entry (report by Markus Pfeiffer) -TD
  > merge branch begun April 2, 2017 which provides these features:
  + support read/write new binary-format for terminfo which stores
    numeric capabilities as a signed 32-bit integer.  The test programs
    such as picsmap, ncurses were created or updated during 2017 to use
    this feature.
  + the new format is written by the wide-character configuration of
    tic when it finds a numeric capability larger than 32767.
  + other applications such as infocmp built with the wide-character
    ncurses library work as expected.
  + applications built with the "narrow" (8-bit) configuration will
    read the new format, but will limit those extended values to 32767.
  + in either wide/narrow configuration, the structure defined in
    term.h still uses signed 16-bit values.
  + because it is incompatible with the legacy (mid-1980s) binary format,
    a new magic value is provided for the "file" program.
  + the term.5 manual page is updated to describe this new format.
  + the limit on file-size for compiled terminfo is increased in the
    wide-character configuration to 32768.
- Add ncurses patch 20180120
  + build-fix in picsmap.c for stdint.h existence.
  + add --disable-stripping option to configure scripts.
  + modify ncurses-examples to install test-scripts in the data directory.
  + work around tool-breakage in Debian 9 and later by invoking
    gprconfig to specify the C compiler to be used by gnatmake,
    and conditionally suppressing Library_Options line for static
    libraries.
  + bump the compat level for test-packages to 7, i.e., Debian 5.
- Add tack patch 1.08-20170818
* Tue Jan  9 2018 werner@suse.de
- Add ncurses patch 20180106
  + fixes for writing extended color pairs in putwin.
  + modify test/savescreen.c to add test patterns that exercise 88-,
    256-, etc., colors.
  + modify configure option --with-build-cc, adding clang, c89 and c99
    as possible default values.
  + modify ncurses-examples configure script to use pkg-config for the
    extra form/menu/panel libraries, to be more consistent with the
    handling of the curses/ncurses library.
  + modify test-packages for mingw to supply "pc" files.
  + modify gen-pkgconfig.in to list -lpthread as a private library when
    configured to access it via weak symbols.
  + simplify gen-pkgconfig.in, adding -ltinfo without the special linker
    checks because some versions of the linker simply hard-code the
    behavior.
  + update URLs for ncurses website to use https.
  + modify CF_CURSES_LIBS to fill in $cf_nculib_root in case the
    ncurses-examples are built with a system ncurses that lacks the
    standard "curses" symbolic link, as done by SuSE.  The symbol is
    needed to make a followup check for the pthread library work, and
    would be set properly using the options "--with-screen", etc.
  + generate misc/*.pc with "all" rule, as done for "sources" rule
    (report by Jeffrey Walton).
* Mon Jan  8 2018 werner@suse.de
- Add ncurses patch 20171230
  + build-fix for ncurses-examples with Fedora27, adding check for
    reset_color_pairs() -- not yet in Fedora's package.
  + consistently add $CFLAGS to $MK_SHARED_LIB symbol in configure
    script when the latter happens to use the C compiler rather than
    directly using the loader (report by Jeffrey Walton).
  + set ABI for upcoming 6.1 release in "*.map" files.  While there are
    some remaining internals to apply, no ABI-related changes are
    anticipated.
  + add configure --with-config-suffix option to work around filename
    conflict with Redhat packages versus test-packages.
- Add ncurses patch 20171223
  + modify ncurses-examples to quiet const-warnings when building with
    PDCurses.
  + modify toe to not exit if unable to read a terminal description,
    e.g., if there is a permission problem.
  + minor fix for progs/toe.c, using _nc_free_termtype2.
  + assign 0 to pointer in _nc_tgetent_leak() after freeing it. Also
    avoid reusing pointer from previous successful call to tgetent
    if the latest call is unsuccessful (patch by Michael Schroeder,
    OpenSuSE #1070450).
  + minor fix for test/tracemunch, initialize $awaiting variable.
* Fri Dec 22 2017 werner@suse.de
- Disable memory leak checking (boo#1070450)
* Mon Dec 18 2017 werner@suse.de
- Add ncurses patch 20171216
  + repair template in test/package/ncurses-examples.spec (cf: 20171111).
  + improve tic's warning about the number of parameters tparm might use
    for u1-u9 by making a special case for u6.
  + improve curs_attr.3x discussion of color pairs.
* Mon Dec 11 2017 werner@suse.de
- Add ncurses patch 20171209
  + modify misc/ncurses-config.in to make output with --includedir
    consistent with --cflags, i.e., when --disable-overwrite option was
    configured the output should show the subdirectory where headers
    are.
  + modify MKlib_gen.sh to suppress macros when calling an "implemented"
    function in link_test.c
  + updated ftp-url used in test-packages, etc.
  + modify order of -pie/-shared options in configure script in case
    LDFLAGS uses "-pie", working around a defect or limitation in the GNU
    linker (prompted by patch by Yogesh Prasad, forwarded by Jay Shah).
  + add entry in man_db.renames for user_caps.5
* Mon Nov 27 2017 werner@suse.de
- Add ncurses patch 20171125
  + modify MKlib_gen.sh to avoid tracing result from getstr/getnstr
    before initialized.
  + add "-a" aspect-ratio option to picsmap.
  + add configure check for default path of rgb.txt, used in picsmap.
  + modify _nc_write_entry() to truncate too-long filename (report by
    Hosein Askari, Debian #882620).
  + build-fix for ncurses-examples with NetBSD curses:
    + it lacks the use_env() function.
    + it lacks libpanel; a recent change used the wrong ifdef symbol.
  + add a macro for is_linetouched() and adjust the function's return
    value to make it possible for most applications to check for an
    error-return (report by Midolikawa H).
  + additional manpage cleanup.
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
* Mon Nov 20 2017 werner@suse.de
- Add ncurses patch 20171118
  + add a note to curs_addch.3x on portability.
  + add a note to curs_pad.3x on the origin and portability of pads.
  + improve manpage description of getattrs (report by Midolikawa H).
  + improve manpage macros (prompted by discussion in Debian #880551.
  + reviewed test-programs using KEY_RESIZE, made fixes to test/worm.c
  + add a "-d" option to picsmap for default-colors.
  + modify old terminology entry and a few other terminal emulators to
    account for xon -TD
  + correct sgr string for tmux, which used screen's "standout" code
    rather than the standard code (patch by Roman Kagan)
  + correct sgr/sgr0 strings in a few other cases reported by tic, making
    those correspond to the non-sgr settings where they differ, but
    otherwise use ECMA-48 consistently:
    jaixterm, aixterm, att5420_2, att4424, att500, decansi, d410-7b,
    dm80, hpterm, emu-220, hp2, iTerm2.app, mterm-ansi, ncrvt100an,
    st-0.7, vi603, vwmterm -TD
  + build-fix for diagnostics warning in lib_mouse.c for pre-5.0 versions
    of gcc which did not recognize the diagnostic "push" pragma (patch by
    Vassili Courzakis).
* Mon Nov 13 2017 werner@suse.de
- Add ncurses patch 20171111
  + add "op" to xterm+256setaf -TD
  + reviewed terminology 1.0.0 -TD
  + reviewed st 0.7 -TD
  + suppress debug-package for ncurses-examples rpm build.
* Mon Nov  6 2017 werner@suse.de
- Add ncurses patch 20171104
  + check for interrupt in color-pair initialization of dots_curses.c,
    dots_xcurses.c
  + add z/Z zoom feature to test/ncurses.c C/c screens.
  + add '<' and '>' commands to test/ncurses.c S/s screens, to better
    test off-by-ones in the overlap/copywin functions.
* Sun Oct 29 2017 werner@suse.de
- Add ncurses patch 20171028
  + improve man/curs_inwstr.3x, correct end-logic for lib_inwstr.c
    (report by Midolikawa H).
  + fix typo in a few places for "improvements" (patch by Sven Joachim).
  + clear the other half of a double-width character on which a line
    drawing character is drawn.
  + make test/ncurses.c "s" test easier to understand which subtests are
    available; add a "S" wide-character overlap test-screen.
  + modify test/ncurses.c C/c tests to allow for extended color pairs.
  + add endwin() call in error-returns from test/ncurses.c omitted in
    recent redesign of its menu (cf: 20170923).
  + improve install of hashed-db by removing the ".db" file as done for
    directory-tree terminal databases.
  + repair a few overlooked items in include/ncurses_defs from recent
    port/refactoring of test-programs (cf: 20170909).
  + add test/padview.c, to compare pads with direct updates in view.c
* Sun Oct 22 2017 werner@suse.de
- Add ncurses patch 20171021
  + modify test/view.c to expand tabs using the ncurses library rather
    than in the test-program.
  + remove very old SIGWINCH example in test/view.c, just use KEY_RESIZE.
  + add -T, -e, -f -m options to "dots" test-programs.
  + fix a few typos in usage-messages for test-programs.
* Mon Oct 16 2017 werner@suse.de
- Add ncurses patch 20171014
  + minor cleanup to test/view.c:
    + eliminate "-n" option by simply reading the whole file.
    + implement page up/down commands.
  + add check in tput for init/reset operands to ensure those use a
    terminal.
  + improve manual pages which discuss chtype, cchar_t types and the
    attribute values which can be stored in those types.
  + correct array-index when parsing "-T" command-line option in tabs
    program.
  + modify demo_new_pair.c to pass extended pairs to setcchar().
  + add test/dots_xcurses.c to illustrate a different approach used for
    extended colors which can be contrasted with dots_curses.c.
  + add a check in tic to note when a description uses non-mandatory
    delays without xon_xoff.  This is not an error, but some descriptions
    for a terminal emulator may use the combination incorrectly.
* Mon Oct  9 2017 werner@suse.de
- Add ncurses patch 20171007
  + modify "-T" option of clear and tput to call use_tioctl() to obtain
    the operating system's notion of the screensize if possible.
  + review/repair some exit-codes for tput, making usage-message exit
    with 2 rather than 1, and a failure to open terminal 4+errno.
  + amend check in tput, tabs and clear to allow those to use the
    database-only features in cron if a -T option gives a suitable
    terminal name (report by Lauri Tirkkonen).
  + correct an ifdef in test/ncurses.c for systems with soft-keys but
    not slk_color().
  + regenerate man-html documentation.
* Wed Oct  4 2017 werner@suse.de
- Add ncurses patch 20170930
  + fix a symbol conflict that made ncurses.c C/c menu not work with
    Solaris xpg4 curses.
  + add refresh() call to dots_mvcur.c, needed to use mvcur() with
    Solaris xpg4 curses after calling newterm().
  + minor fixes for configure script from work on ncurses-examples and
    tin.
  + improve animation in test/xmas.c by adding a time-delay in blinkit().
  + modify several test programs to reflect that ncurses honors existing
    signal handlers in initscr(), while other implementations do not.
  + modify bs.c to make it easier to quit.
  + change ncurses-examples to use attr_t vs chtype to follow X/Open
    documentation more closely since Solaris xpg4-curses uses different
    values for WA_xxx vs A_xxx that rely on attr_t being an unsigned
    short.  Tru64 aka OSF1, HPUX, AIX did as ncurses does, equating the
    two sets.
* Mon Sep 25 2017 werner@suse.de
- Add ncurses patch 20170923
  + modify menu for test/ncurses.c to fit on 24-line screen.
  + build-fix for configure --with-caps=uwin
  + add options to test_arrays.c, for selecting termcap vs terminfo, etc.
* Mon Sep 18 2017 werner@suse.de
- Add ncurses patch 20170916
  + minor fix to test/filter.c to avoid clearing the command in one case.
  + modify filter() to discard clr_eos if back_color_erase is set.
* Mon Sep 18 2017 werner@suse.de
- Do not remove ticw.pc as well as tinfow.pc for wide character
  ncurses ABI 6 (boo#1056171)
* Mon Sep 11 2017 werner@suse.de
- Add ncurses patch 20170827
  + fix a bug in repeat_char logic (cf: 20170729, report by Chris Clayton).
- Add ncurses patch 20170902
  + amend change for endwin-state for better consistency with the older
    logic (report/patch by Jeb Rosen, cf: 20170722).
  + modify check in fmt_entry() to handle a cancelled reset string
    (Debian #873746).  Make similar fixes in other parts of dump_entry.c
    and tput.c
- Add ncurses patch 20170909
  + improve wide-character implementation of myADDNSTR() in frm_driver.c,
    which was inconsistent with the normal implementation.
  + save/restore cursor position in Undo_Justification(), matching
    behavior of Buffer_To_Window() (report by Leon Winter).
  + modify test/knight to provide the "slow" solution for small screens
    using "R", noting that Warnsdorf's method is easily done with "a".
  + modify several test-programs which call use_default_colors() to
    consistently do this only if "-d" option is given.
  + additional changes to test with non-standard variants of curses:
    + modify a loop limit in firework.c to work around absense of limit
    checks in some libraries.
    + fill the last row of a window with "?" in firstlast if waddch does
    not return ERR on the lower-right corner.
  + add checks in test/configure for some functions not in 4.3BSD curses.
  + fix a regression in test/configure (cf: 20170826).
- Split off terminfo-iterm to avoid conflict with package libiterm1
* Sun Aug 27 2017 werner@suse.de
- Add ncurses patch 20170826
  + fixes for "iterm2" (report by Leonardo Brondani Schenkel) -TD
  + corrected a warning from tic about keys which are the same, to skip
    over missing/cancelled values.
  + add check in tic for unnecessary use of "2" to denote a shifted
    special key.
  + improve checks in trim_sgr0, comp_parse.c and parse_entry.c, for
    cancelled string capabilities.
  + add check in _nc_parse_entry() for invalid entry name, setting the
    name to "invalid" to avoid problems storing entries.
  + add/improve checks in tic's parser to address invalid input
    + add a check in comp_scan.c to handle the special case where a
    nontext file ending with a NUL rather than newline is given to tic
    as input (Redhat #1484274).
    + allow for cancelled capabilities in _nc_save_str (Redhat #1484276).
    + add validity checks for "use=" target in _nc_parse_entry (Redhat
    [#1484284]).
    + check for invalid strings in postprocess_termcap (Redhat #1484285)
    + reset secondary pointers on EOF in next_char() (Redhat #1484287).
    + guard _nc_safe_strcpy() and _nc_safe_strcat() against calls using
    cancelled strings (Redhat #1484291).
  + correct typo in curs_memleaks.3x (Sven Joachim).
  + improve test/configure checks for some curses variants not based on
    X/Open Curses.
  + add options for test/configure to disable checks for form, menu and
    panel libraries.
* Mon Aug 21 2017 werner@suse.de
- Add ncurses patch 20170819
  + update "iterm" entry -TD
  + add "iterm2" entry (report by Leonardo Brondani Schenkel) -TD
  + regenerate llib-* files.
  + regenerate HTML manpages.
  + improve picsmap test-program:
    + reduce memory used for tsearch
    + add report in log file showing cumulative color coverage.
  + add -x option to clear/tput to make the E3 extension optional
    (cf: 20130622).
  + add options -T and -V to clear command for compatibility with tput.
  + add usage message to clear command (Debian #371855).
  + improve usage messages for tset and tput.
  + minor fixes to "RDGB" extension and reset_color_pairs().
* Mon Aug 14 2017 werner@suse.de
- Add ncurses patch 20170812
  + improve description of -R option in infocmp manual page (report by
    Stephane Chazelas).
  + add reset_color_pairs() function.
  + add user_caps.5 manual page to document the terminfo extensions used
    by ncurses.
  + improve build scripts, using SIGQUIT vs SIGTRAP; add other configure
    script fixes from work on xterm, lynx and tack.
  + modify install-rule for ncurses-examples to put the data files in
    /usr/share/ncurses-examples
  + improve tracemunch, by changing address-parameters of add_wch(),
    color_content() and pair_content() to dummy parameters.
  + minor optimization to _nc_change_pair, to return quickly when the
    current screen is marked for clearing.
  + in-progress changes to improve performance of test/picsmap.c for
    loading image files.
  + modify allocation for SCREEN's color-pair table to start small, grow
    on demand up to the existing limit.
  + add "RGB" extension capability for direct-color support, use this to
    improve color_content().
  + improve picsmap test-program:
    + if no palette file is needed, attempt to load one based on $TERM,
    checking first in the current directory, then by adding ".dat"
    suffix, and finally in the data-directory, e.g.,
    /usr/share/ncurses-examples
    + add "-l" option for logging
    + add "-d" option for debugging
    + add "-s" option for stepping automatically through list of images,
    with time delay.
    + use tsearch to improve time for loading color table for images.
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
* Mon Jul 31 2017 werner@suse.de
- Add ncurses patch 20170729
  + update interix entry using tack and SFU on Windows 7 Ultimate -TD
  + use ^? for kdch1 in interix (reported by Jonathan de Boyne Pollard)
  + add "rep" to xterm-new, available since 1997/01/26 -TD
  + move SGR 24 and 27 from vte-2014 to vte-2012 (request by Alain
    Williams) -TD
  + add a check in newline_forces_scroll() in case a program moves the
    cursor outside scrolling margins (report by Robert King).
  + improve _nc_tparm_analyze, using that to extend the checks made by
    tic for reporting inconsistencies between the expected number of
    parameters for a capability and the actual.
  + amend handling of repeat_char capability in EmitRange (adapted from
    report/patch by Dick Wesseling):
    + translate the character to the alternate character set when the
    alternate character set is enabled.
    + do not use repeat_char for characters past 255.
  + document "_nc_free_tinfo" in manual page, because it could be used in
    tack for memory-leak checking.
  + add "--without-tack" configure option to refine "--with-progs"
    configure option.  Normally tack is no longer built in-tree, but
    a few packagers combine it during the build.  If term_entry.h is
    installed, there is no advantage to in-tree builds.
  + adjust configure-script to define HAVE_CURSES_DATA_BOOLNAMES symbol
    needed for tack 1.08 when built in-tree.  Rather than relying upon
    internal "_nc_" functions, tack now uses the boolean, number and
    string capability name-arrays provided by ncurses and SVr4 Unix
    curses.  It still uses term_entry.h for the definitions of the
    extended capability arrays.
  + add an overlooked null-pointer check in mvcur changes from 20170722
- Modify patch ncurses-5.7-tack.dif and ncurses-6.0.dif to get
  position independent executables as well
* Mon Jul 24 2017 werner@suse.de
- Add ncurses patch 20170722
  + improve test-packages for ncurses-examples and AdaCurses for lintian
  + modify logic for endwin-state to be able to detect the case where
    the screen was never initialized, using that to trigger a flush of
    ncurses' buffer for mvcur, e.g., in test/dots_mvcur.c for the
    term-driver configuration.
  + add dependency upon ncurses_cfg.h to a few other internal header
    files to allow each to be compiled separately.
  + add dependency upon ncurses_cfg.h to tic's header-files; any program
    using tic-library will have to supply this file.  Legacy tack
    versions supply this file; ongoing tack development has dropped the
    dependency upon tic-library and new releases will not be affected.
* Tue Jul 18 2017 werner@suse.de
- Fix build by removing workaround in patch ncurses-5.7-tack.dif
  which was required since patch 20170415 but had become obsolete
  with patch 20170715
* Mon Jul 17 2017 werner@suse.de
- Add ncurses patch 20170715
  + modify command-line parameters for "convert" used in picsmap to work
    with ImageMagick 6.8 and newer.
  + fix build-problem with tack and ABI-5 (Debian #868328).
  + repair termcap-format from tic/infocmp broken in 20170701 fixes
    (Debian #868266).
  + reformat terminfo.src with 20170513 updates.
  + improve test-packages to address lintian warnings.
* Mon Jul 10 2017 werner@suse.de
- Add ncurses patch 20170708
  + add a note to tic manual page about -W versus -f options.
  + correct a limit-check in fixes from 20170701 (report by Sven Joachim).
- This also for bug bsc#1047964 and bug bsc#1047965
* Mon Jul  3 2017 werner@suse.de
- Add ncurses patch 20170701 (bsc#1046853, bsc#1046858)
  + modify update_getenv() in db_iterator.c to ensure that environment
    variables which are not initially set will be checked later if an
    application happens to set them (patch by Guillaume Maudoux).
  + remove initialization-check for calling napms() in the term-driver
    configuration; none is needed.
  + add help-screen to test/test_getstr.c and test/test_get_wstr.c
  + improve compatibility between different configurations of new_prescr,
    fixing a case with threaded code and term-driver where c++/demo did
    not work (cf: 20160213).
  + the fixes for Redhat #1464685 obscured a problem subsequently
    reported in Redhat #1464687; the given test-case was no longer
    reproducible.  Testing without the fixes for the earlier reports
    showed a problem with buffer overflow in dump_entry.c, which is
    addressed by reducing the use of a fixed-size buffer.
  + add/improve checks in tic's parser to address invalid input
    (Redhat #1464684, #1464685, #1464686, #1464691).
    + alloc_entry.c, add a check for a null-pointer.
    + parse_entry.c, add several checks for valid pointers as well as
    one check to ensure that a single character on a line is not
    treated as the 2-character termcap short-name.
  + fix a memory leak in delscreen() (report by Bai Junq).
  + improve tracemunch, showing thread identifiers as names.
  + fix a use-after-free in NCursesMenu::~NCursesMenu()
  + further amend incorrect calls for memory-leaks from 20170617 changes
    (report by Allen Hewes).
* Sun Jun 25 2017 werner@suse.de
- Add ncurses patch 20170624
  + modify c++/etip.h.in to accommodate deprecation of throw() and
    throws() in c++17 (prompted by patch by Romain Geissler).
  + remove some incorrect calls for memory-leaks from 20170617 changes
    (report by Allen Hewes).
  + add test-programs for termattrs and term_attrs.
  + modify _nc_outc_wrapper to use the standard output if the screen was
    not initialized, rather than returning an error.
  + improve checks for low-level terminfo functions when the terminal
    has not been initialized (Redhat #1345963).
  + modify make_hash to allow building with address-sanitizer,
    assuming that --disable-leaks is configured.
  + amend changes for number_format() in 20170506 to avoid undefined
    behavior when shifting (patch by Emanuele Giaquinta).
* Wed Jun 21 2017 werner@suse.de
- Add ncurses patch 20170617
  + fill in some places where TERMTYPE2 vs TERMTYPE was not used
    (report by Allen Hewes).
  + use ExitTerminfo() internally in error-exits for ncurses' setupterm
    to help with leak checking.
  + use ExitProgram() in error-exit from initscr() to help with leak
    checking.
  + review test-programs, adding checks for cases where the terminal
    cannot be initialized.
* Mon Jun 12 2017 werner@suse.de
- Add ncurses patch 20170610
  + add option "-xp" to picsmap.c, to use init_extended_pair().
  + make simple performance fixes for picsmap.c
  + improve aspect ratio of images read from "convert" in picsmap.c
- Add ncurses patch 20170603
  + add option to picsmap to use color-palette files, e.g., for mapping
    to xterm-256color.
  + move the data in SCREEN used for the alloc_pair() function to the
    end, to restore compatibility between ncurses/ncursesw libtinfo
    (report/patch by Miroslav Lichvar).
  + add build-time utility "report_offsets" to help show when the various
    configurations of tinfo library are compatible or not.
- Remove patch ncurses-6.0-crashw.patch as a temporary as now part
  of patch level 20170603
* Tue May 30 2017 werner@suse.de
- Add patch ncurses-6.0-crashw.patch as a temporary fix which will
  become part of next patch level: solve binary incompatiblity of
  libtinfow and libtinfo
* Mon May 29 2017 werner@suse.de
- Add ncurses patch 20170527
  + improved test/picsmap.c:
  + lookup named colors for xpm files in rgb.txt
  + accept blanks in color-keys for xpm files.
  + if neither xbm/xpm work, try "convert", which may be available.
* Wed May 24 2017 werner@suse.de
- Fix ncursesw6-config and ncursesw5-config scripts to return -ltinfow
  as well as the pkg-config files do
* Mon May 22 2017 werner@suse.de
- Add ncurses patch 20170520
  + modify test/picsmap.c to read xpm files.
  + modify package/debian/* to create documentation packages, so the
    related files can be checked with lintian.
  + fix some typos in manpages (report/patch by Sven Joachim).
* Mon May 15 2017 werner@suse.de
- Add ncurses patch 20170513
  + add test/picsmap.c to fill in some testing issues not met by dots.
    The initial version reads X bitmap (".xbm") files.
  + repair logic which forces a repaint where a color-pair's content is
    changed (cf: 20170311).
  + improve tracemunch, showing screenXX pointers as names.
* Fri May 12 2017 werner@suse.de
- Better screen support and workaround about missing terminfo entries
  might be help on boo#812067 as well as on boo#935736 but may cause
  boo#940459  (which should be fixed by screen its self!)
- New package terminfo-screen which includes some useful but troubling
  terminfo database entries for screen.
* Wed May 10 2017 werner@suse.de
- Disable the usage of getttynam(3) as under Linux this is not used
* Tue May  9 2017 werner@suse.de
- Add ncurses patch 20170506
  + modify tic/infocmp display of numeric values to use hexadecimal when
    they are "close" to a power of two, making the result more readable.
  + improve discussion of portability in curs_mouse.3x
  + change line-length for generated html/manpages to 78 columns from 65.
  + improve discussion of line-drawing characters in curs_add_wch.3x
    (prompted by discussion with Lorinczy Zsigmond).
  + cleanup formatting of hackguide.html and ncurses-intro.html
  + add examples for WACS_D_PLUS and WACS_T_PLUS to test/ncurses.c
* Tue May  2 2017 werner@suse.de
- Add ncurses patch 20170429
  + corrected a case where $with_gpm was set to "maybe" after CF_WITH_GPM,
    overlooked in 20160528 fixes (report by Alexandre Bury).
  + improve a couple of test-program's help-messages.
  + corrected loop in rain.c from 20170415 changes.
  + modify winnstr and winchnstr to return error if the output pointer is
    null, as well as adding a null pointer check of the window pointer
    for better compatibility with other implementations.
  + improve discussion of NetBSD curses in scr_dump.5
  + modify LIMIT_TYPED macro in new_pair.h to avoid changing sign of the
    value to be limited (reports by Darby Payne, Rob Boudreau).
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
* Mon Apr 24 2017 werner@suse.de
- Also split libtic into normal and wide version libticw as those
  libraries are linked with libtinfo respectively libtinfow
- The tack tool does require the old _nc_read_entry()
* Mon Apr 24 2017 werner@suse.de
- Add ncurses patch 20170422
  + build-fix for termcap-configuration (report by Chi-Hsuan Yen).
  + improve terminfo manual page discussion of control- and graphics-
    characters.
  + remove tic warning about "^?" in string capabilities, which was
    marked as an extension (cf: 20000610, 20110820); however all Unix
    implementations support this and X/Open Curses does not address it.
    On the other hand, termcap never did support this feature.
  + correct missing comma-separator between string capabilities in
    icl6402 and m2-nam -TD
  + restore rmir/smir in ansi+idc to better match original ansiterm+idc,
    add alias ansiterm (report by Robert King).
  + amend an old check for ambiguous use of "ma" in terminfo versus
    a termcap use, if the capability is cancelled to treat it as number.
  + correct a case in _nc_captoinfo() which read "%%%%" and emitted "%%".
  + modify sscanf calls in _nc_infotocap() for patterns "%%{number}%%+%%c"
    and "%%'char'%%+%%c" to check that the final character is really 'c',
    avoiding a case in icl6404 which cannot be converted to termcap.
  + in _nc_infotocap(), add a check to ensure that terminfo "^?" is not
    written to termcap, because the BSDs did not implement that.
  + in _nc_tic_expand() and _nc_infotocap(), improve string-length check
    when deciding whether to use "^X" or "\xxx" format for control
    characters, to make the output of tic/infocmp more predictable.
  + limit termcap "%%d" width to 2 digits on input, and use "%%2" in
    preference to "%%02" on output.
  + correct terminfo/termcap conversion of "%%02" and "%%03" into "%%2" and
    "%%3"; the result repeated the last character.
  + add man/scr_dump.5 to document screen-dump format.
- Add ncurses patch 20170415
  + modify several test programs to use new popup_msgs, adapted from
    help-screen used in test/edit_field.c
  + drop two symbols obsoleted in 2004: _nc_check_termtype, and
    _nc_resolve_uses
  + fix some old copyright dates (cf: 20031025).
  + build-fixes for test/savescreen.c to work with AIX and HPUX.
  + minor fix to configure script, adding a backslash/continuation.
  + extend TERMINAL structure for ABI 6 to store numbers internally as
    integers rather than short, by adding new data for this purpose.
  + more fixes for minor memory-leaks in test-programs.
* Thu Apr 13 2017 werner@suse.de
- With one of the latest update patches libtinfo now has become
  splitted into a normal and wide character version (boo#1033198)
* Mon Apr 10 2017 werner@suse.de
- Add ncurses patch 20170408
  + change logic in wins_nwstr() to avoid addressing data past the output
    of mbstowcs().
  + correct a call to setcchar() in Data_Entry_w() from 20131207 changes.
  + fix minor memory-leaks in test-programs.
  + further improve ifdef in term_entry.h for internal definitions not
    used by tack.
* Mon Apr  3 2017 werner@suse.de
- Add ncurses patch 20170401
  + minor fixes for vt100+4bsd, e.g., delay in sgr for consistency -TD
  + add smso for env230, to match sgr -TD
  + remove p7/protect from sgr in fbterm -TD
  + drop setf/setb from fbterm; setaf/setab are enough -TD
  + make xterm-pcolor sgr consistent with other capabilities -TD
  + add rmxx/smxx ECMA-48 strikeout extension to tmux and xterm-basic
    (discussion with Nicholas Marriott)
  + add test-programs sp_tinfo and extended_color
  + modify no-leaks code for lib_cur_term.c to account for the tgetent()
    cache.
  + modify setupterm() to save original tty-modes so that erasechar()
    works as expected.  Also modify _nc_setupscreen() to avoid redundant
    calls to get original tty-modes.
  + modify set_curterm() to update ttytype[] data used by longname().
  + modify wattr_set() and wattr_get() to return ERR if win-parameter is
    null, as documented.
  + improve cast used for null-pointer checks in header macros, to
    reduce compiler warnings.
  + modify several functions, using the reserved "opts" parameter to pass
    color- and pair-values larger than 16-bits:
    + getcchar(), setcchar(), slk_attr_set(), vid_puts(), wattr_get(),
    wattr_set(), wchgat(), wcolor_set().
    + Other functions call these with the corresponding altered behavior,
    including chgat(), mvchgat(), mvwchgat(), slk_color_on(),
    slk_color_off(), vid_attr().
  + add new functions for manipulating color- and pair-values larger
    than 16-bits.  These are extended_color_content(),
    extended_pair_content(), extended_slk_color(), init_extended_color(),
    init_extended_pair(), and the corresponding sp-funcs.
* Sun Mar 26 2017 werner@suse.de
- Add ncurses patch 20170325
  + fix a memory leak in the window-list when creating multiple screens
    (reports by Andres Martinelli, Debian #783486).
  + reviewed calls from link_test.c, added a few more null-pointer
    checks.
  + add a null-pointer check in ungetmouse, in case mousemask was not
    called (report by "Kau").
  + updated curs_sp_funcs.3x for new functions.
* Mon Mar 20 2017 werner@suse.de
- Add ncurses patch 20170318
  + change TERMINAL structure in term.h to make it opaque.  Some
    applications misuse its members, e.g., directly modifying it
    rather than using def_prog_mode().
  + modify utility headers such as tic.h to make it clearer which are
    externals that are used by tack.
  + improve curs_slk.3x in particular its discussion of portability.
  + fix cut/paste in legacy_encoding.3x
  + add prototype for find_pair() to new_pair.3x (report by Branden
    Robinson).
  + fix a couple of broken links in generated man-html documentation.
  + regenerate man-html documentation.
- Add tack patch 1.07.20170318
  * init.c:
    use def_prog_mode() to eliminate two internal details from ncurses
  * edit.c, tack.h: accommodate opaque TERMINAL structure in ncurses
  * tack.h: update copyright to match version
  * config.sub: 2017-02-07
  * config.guess: 2017-03-05
* Mon Mar 13 2017 werner@suse.de
- Add ncurses patch 20170311
  + modify vt100 rs2 string to reset vt52 mode and scrolling regions
    (report/analysis by Robert King) -TD
  + add vt100+4bsd building block, use that for older terminals rather
    than "vt100" which is now mostly used as a building block for
    terminal emulators -TD
  + correct a few spelling errors in terminfo.src comments -TD
  + add fbterm -TD
  + fix a typo in ncurses.c test_attr legend (patch by Petr Vanek).
  + changed internal colorpair_t to a struct, eliminating an internal
    8-bit limit on colors
  + add ncurses/new_pair.h
  + add ncurses/base/new_pair.c with alloc_pair(), find_pair() and
    free_pair() functions
  + add test/demo_new_pair.c
- Add ncurses patch 20170304
  + improve terminfo manual description of terminfo syntax.
  + clarify the use of wint_t vs wchar_t in curs_get_wstr.3x
  + improve description of endwin() in manual.
  + modify setcchar() and getcchar() to treat negative color-pair as an
    error.
  + fix a typo in include/hashed_db.h (Andre Sa).
* Thu Mar  2 2017 werner@suse.de
- Add ncurses patch 20170225
  + fixes for CF_CC_ENV_FLAGS (report by Ross Burton).
* Mon Feb 20 2017 werner@suse.de
- Add ncurses patch 20170218
  + fix several formatting issues with manual pages.
  + correct read of terminfo entry in which all strings are absent or
    explicitly cancelled.  Before this fix, the result was that all were
    treated as only absent.
  + modify infocmp to suppress mixture of absent/cancelled capabilities
    that would only show as "NULL, NULL", unless the -q option is used,
    e.g., to show "-, @" or "@, -".
* Mon Feb 13 2017 werner@suse.de
- Add ncurses patch 20170212
  + build-fixes for PGI compilers (report by Adam J. Stewart)
    + accept whitespace in sed expression for generating expanded.c
    + modify configure check that g++ compiler warnings are not used.
    + add configure check for -fPIC option needed for shared libraries.
  + let configure --disable-ext-funcs override the default for the
  - -enable-sp-funcs option.
  + mark some structs in form/menu/panel libraries as potentially opaque
    without modifying API/ABI.
  + add configure option --enable-opaque-curses for ncurses library and
    similar options for the other libraries.
* Mon Feb  6 2017 werner@suse.de
- Add ncurses patch 20170204
  + trim newlines, tabs and escaped newlines from terminfo "paths" passed
    to db-iterator.
  + ignore zero-length files in db-iterator; these are useful for
    instance to suppress "$HOME/.terminfo" when not wanted.
  + amended "b64:" encoder to work with the terminfo reader.
  + modify terminfo reader to accept "b64:" format using RFC-3548 in
    as well as RFC-4648 url/filename-safe format.
  + modify terminfo reader to accept "hex:" format as generated by
    "infocmp -0qQ1" (cf: 20150905).
  + adjust authors comment to reflect drop below 1%% for SV.
* Fri Feb  3 2017 jengelh@inai.de
- Drop authors block from description and ship AUTHORS intead.
- Replace canned summaries and descriptions by
  package-specific ones.
- Replace |xargs rm by simpler -delete. Use modern tar options.
* Fri Feb  3 2017 werner@suse.de
- Use gzip shell script as GZIP envornment variable becomes obsolescent
- Split of ncurses5-devel from ncurses-devel
- Now ncurses-devel also provides ncurses6-devel
- Also ncurses5-devel requires libncurses5 (boo#1023296)
  packages which want to be build with ncurses5-devel may require
  pkgconfig(ncurses5) or pkgconfig(ncursesw5) or
  /usr/bin/ncurses5-config or /usr/bin/ncursesw5-config
* Mon Jan 30 2017 werner@suse.de
- Add ncurses patch 20170128
  + minor comment-fixes to help automate links to bug-urls -TD
  + add dvtm, dvtm-256color -TD
  + add settings corresponding to xterm-keys option to tmux entry to
    reflect upcoming change to make that option "on" by default
    (patch by Nicholas Marriott).
  + uncancel Ms in tmux entry (Harry Gindi, Nicholas Marriott).
  + add dumb-emacs-ansi -TD
* Sun Jan 22 2017 werner@suse.de
- Add ncurses patch 20170121
  + improve discussion of early history of tput program.
  + incorporate A_COLOR mask into COLOR_PAIR(), in case user application
    provides an out-of-range pair number (report by Elijah Stone).
  + clarify description in tput manual page regarding support for
    termcap names (prompted by FreeBSD #214709).
  + remove a restriction in tput's support for termcap names which
    omitted capabilities normally not shown in termcap translations
    (cf: 990123).
  + modify configure script for clang as used on FreeBSD, to work around
    clang's differences in exit codes vs gcc.
* Thu Jan 19 2017 werner@suse.de
- Remove -L option on screen call dues API change, now we depend
  on environment variables only.
* Mon Jan 16 2017 werner@suse.de
- Add ncurses patch 20170114
  + improve discussion of early history of tset/reset programs.
  + clarify in manual pages that the optional verbose option level is
    available only when ncurses is configured for tracing.
  + amend change from 20161231 to avoid writing traces to the standard
    error after initializing the trace feature using the environment
    variable.
* Mon Jan  9 2017 werner@suse.de
- Add ncurses patch 20170107
  + amend changes for tput to reset tty modes to "sane" if the program
    is run as "reset", like tset.  Likewise, ensure that tset sends
    either reset- or init-strings.
  + improve manual page descriptions of tput init/reset and tset/reset,
    to make it easier to see how they are similar and different.
  + move a static result from key_name() to _nc_globals
  + modify _nc_get_screensize to allow for use_env() and use_tioctl()
    state to be per-screen when sp-funcs are configured, better matching
    the behavior when using the term-driver configuration.
  + improve cross-references in manual pages for often used functions
  + move SCREEN field for use_tioctl() data before the ncursesw fields,
    and limit that to the sp-funcs configuration to improve termlib
    compatibility (cf:  20120714).
  + correct order of initialization for traces in use_env() and
    use_tioctl() versus first trace calls.
  - Add ncurses patch 20161231
  + fix errata for ncurses-howto (report by Damien Ruscoe).
  + fix a few places in configure/build scripts where DESTDIR and rpath
    were combined (report by Thomas Klausner).
  + merge current st description (report by Harry Gindi) -TD
  + modify flash capability for linux and wyse entries to put the delay
    between the reverse/normal escapes rather than after -TD
  + modify program tabs to pass the actual tty file descriptor to
    setupterm rather than the standard output, making padding work
    consistently.
  + explain in clear's manual page that it writes to stdout.
  + add special case for verbose debugging traces of command-line
    utilities which write to stderr (cf: 20161126).
  + remove a trace with literal escapes from skip_DECSCNM(), added in
    20161203.
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
- Add ncurses patch 20161224
  + correct parmeters for copywin call in _nc_Synchronize_Attributes()
    (patch by Leon Winter).
  + improve color-handling section in terminfo manual page (prompted by
    patch by Mihail Konev).
  + modify programs clear, tput and tset to pass the actual tty file
    descriptor to setupterm rather than the standard output, making
    padding work.
* Mon Dec 19 2016 werner@suse.de
- Add ncurses patch 20161217
  + add tput-colorcube demo script.
  + add -r and -s options to tput-initc demo, to match usage in xterm.
  + flush the standard output in _nc_flush for the case where SP is zero,
    e.g., when called via putp.  This fixes a scenario where "tput flash"
    did not work after changes in 20130112.
* Mon Dec 12 2016 werner@suse.de
- Add ncurses patch 20161210
  + add configure script option --disable-wattr-macros for use in cases
    where one wants to use the same headers for ncurses5/ncurses6
    development, by suppressing the wattr* macros which differ due to
    the introduction of extended colors (prompted by comments in
    Debian #230990, Redhat #1270534).
  + add test/tput-initc to demonstrate tput used to initialize palette
    from a data file.
  + modify test/xterm*.dat to use the newer color4/color12 values.
* Mon Dec  5 2016 werner@suse.de
- Add ncurses patch 20161203
  + improve discussion of field validation in form_driver.3x manual page.
  + update curs_trace.3x manual page.
* Mon Nov 28 2016 werner@suse.de
- Add ncurses patch 20161126
  + modify linux-16color to not mask dim, standout or reverse with the
    ncv capability -TD
  + add 0.1sec mandatory delay to flash capabilities using the VT100
    reverse-video control -TD
  + omit selection of ISO-8859-1 for G0 in enacs capability from linux2.6
    entry, to avoid conflict with the user-defined mapping.  The reset
    feature will use ISO-8859-1 in any case (Mikulas Patocka).
  + improve check in tic for delays by also warning about beep/flash
    when a delay is not embedded, or if those use the VT100 reverse
    video escape without using a delay.
  + minor fix for syntax-check of delays from 20161119 changes.
  + modify trace() to avoid overwriting existing file (report by Maor
    Shwartz).
* Mon Nov 21 2016 werner@suse.de
- Add ncurses patch 20161112
  + improve -W option in tic/infocmp:
    + correct order of size-adjustments in wrapped lines
    + if -f option splits line, do not further split it with -W
    + begin a new line when adding "use=" after a wrapped line
- Add ncurses patch 20161119
  + add check in tic for some syntax errors of delays, as well as use of
    proportional delays for non-line capabilities.
  + document history of the clear program and the E3 extension, prompted
    by various discussions including
    http://unix.stackexchange.com/questions/87469/clearing-the-old-scrollback-buffer
* Mon Nov  7 2016 werner@suse.de
- Add ncurses patch 20161105
  + fix typo in man/terminfo.tail (Alain Williams).
  + correct program-name in adacurses6-config.1 manual page.
- Add ncurses patch 20161029
  + add new function "unfocus_current_field" (Leon Winter)
* Thu Oct 27 2016 werner@suse.de
- Drop patch ncurses-5.9-environment.dif as YaST2 ncurses GUI does
  not need it anymore and as well as it causes bug bsc#1000662
* Mon Oct 24 2016 werner@suse.de
- Add ncurses patch 20161022
  + modify tset -w (and tput reset) to update the program's copy of the
    screensize if it was already set in the system, to improve tabstop
    setting which relies upon knowing the actual screensize.
  + add functionality of tset -w to tput, like the "-c" feature this is
    not optional in tput.
  + add "clear" as a possible link/alias to tput.
  + improve tput's check for being called as "init" or "reset" to allow
    for transformed names.
  + split-out the "clear" function from progs/clear.c, share with
    tput to get the same behavior, e.g., the E3 extension.
* Mon Oct 17 2016 werner@suse.de
- Add ncurses patch 20161015
  + amend internal use of tputs to consistently use the number of lines
    affected, e.g., for insert/delete character operations.  While
    merging terminfo source early in 1995, several descriptions used the
    "*" proportional delay for these operations, prompting a change in
    doupdate.
  + regenerate llib-* files.
  + regenerate HTML manpages.
  + fix several formatting issues with manual pages.
* Thu Oct 13 2016 werner@suse.de
- Add ncurses patch 20161008
  + adjust size in infocmp/tic to work with strlcpy.
  + fix configure script to record when strlcat is found on OpenBSD.
  + build-fix for "recent" OpenBSD vs baudrate.
* Tue Oct  4 2016 werner@suse.de
- Add ncurses patch 20161001
  + add -W option to tic/infocmp to force long strings to wrap.  This is
    in addition to the -w option which attempts to fit capabilities into
    a given line-length.
  + add linux-m1 minitel entries (patch by Alexandre Montaron).
  + correct rs2 string for vt100-nam -TD
- Re-enable block cursor on virtual console
* Mon Sep 26 2016 werner@suse.de
- Add ncurses patch 20160924
  + modify _nc_tic_expand to escape comma if it immediately follows a
    percent sign, to work with minitel change.
  + updated minitel and viewdata descriptions (Alexandre Montaron).
* Mon Sep 19 2016 werner@suse.de
- Add ncurses patch 20160917
  + build-fix for gnat6, which unhelpfully attempts to compile C files.
  + fix typo in 20160910 changes (Debian #837892, patch by Sven Joachim).
* Mon Sep 12 2016 werner@suse.de
- Add ncurses patch 20160910
  + trim dead code ifdef'd with HIDE_EINTR since 970830 (discussion with
    Leon Winter).
  + trim some obsolete/incorrect wording about EINTR from wgetch manual
    page (patch by Leon Winter).
  + really correct 20100515 change (patch by Rich Coe).
  + add "--enable-string-hacks" option to test/configure
  + completed string-hacks for "sprintf", etc., including test-programs.
  + make "--enable-string-hacks" work with Debian by checking for the
    "bsd" library and its associated "<bsd/string.h>" header.
- Add ncurses patch 20160903
  + correct 20100515 change for weak signals versus sigprocmask (report
    by Rich Coe).
  + modify misc/Makefile.in to work around OpenBSD "make" which unlike
    all other versions of "make" does not recognize continuation lines
    of comments.
  + amend the last change to CF_C_ENV_FLAGS to move only the
    preprocessor, optimization and warning flags to CPPFLAGS and CFLAGS,
    leaving the residue in CC.  That happens to work for gcc's various
    "model" options, but may require tuning for other compilers (report
    by Sven Joachim).
- Add ncurses patch 20160827
  + add "v" menu entry to test/ncurses.c to show baudrate and other
    values.
  + add "newer" baudrate symbols from Linux and FreeBSD to progs/tset.c,
    lib_baudrate.c
  + modify CF_XOPEN_SOURCE macro:
    + add "uclinux" to case for "linux" (patch by Yann E. Morin)
    + modify _GNU_SOURCE for cygwin headers, tested with cygwin 2.3, 2.5
    (patch by Corinna Vinschen, from changes to tin).
  + improve CF_CC_ENV_FLAGS macro to allow for compiler wrappers such
    as "ccache" (report by Enrico Scholz).
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
- Add ncurses patch 20160820
  + update tput manual page to reflect changes to manipulate terminal
    modes by sharing functions with tset.
  + add the terminal-mode parts of "reset" (aka tset) to the "tput reset"
    command, making the two almost the same except for window-size.
  + adapt logic used in dialog "--keep-tite" option for test/filter.c as
    "-a" option.  When set, test/filter attempts to suppress the
    alternate screen.
  + correct a typo in interix entry -TD
- Drop patch ncurses-6.0-signal.dif as now upstream
* Mon Sep  5 2016 rcoe@wi.rr.com
- Add patch ncurses-6.0-signal.dif for bnc#995148:
    + redfine sigprocmask macro
    + wrap sigprocmask to call system sigprocmask instead of self
* Mon Aug 15 2016 werner@suse.de
- Add ncurses patch 20160813
  + add a dependency upon generated-sources in Ada95/src/Makefile.in to
    handle a case of "configure && make install".
  + trim trailing blanks from include/Caps*, to work around a problem
    in sed (Debian #818067).
* Mon Aug  8 2016 werner@suse.de
- Add ncurses patch 20160806
  + improve CF_GNU_SOURCE configure macro to optionally define
    _DEFAULT_SOURCE work around a nuisance in recent glibc releases.
  + move the terminfo-specific parts of tput's "reset" function into
    the shared reset_cmd.c, making the two forms of reset use the same
    strings.
  + split-out the terminal initialization functions from tset as
    progs/reset_cmd.c, as part of changes to merge the reset-feature
    with tput.
* Mon Aug  1 2016 werner@suse.de
- Add ncurses patch 20160730
  + change tset's initialization to allow it to get settings from the
    standard input as well as /dev/tty, to be more effective when
    output or error are redirected.
  + improve discussion of history and portability for tset/reset/tput
    manual pages.
- Add ncurses patch 20160723
  + improve error message from tset/reset when both stderr/stdout are
    redirected to a file or pipe.
  + improve organization of curs_attr.3x, curs_color.3x
- Add ncurses patch 20160709
  + work around Debian's antique/unmaintained version of mawk when
    building link_test.
  + improve test/list_keys.c, showing ncurses's convention of modifiers
    for special keys, based on xterm.
* Thu Jul  7 2016 werner@suse.de
- Add ncurses patch 20160702
  + improve test/list_keys.c, using $TERM if no parameters areg given.
- Add ncurses patch 20160625
  + build-fixes for ncurses "test_progs" rule.
  + amend change to CF_CC_ENV_FLAGS in 20160521 to make multilib build
    work (report by Sven Joachim).
- Add ncurses patch 20160618
  + build-fixes for ncurses-examples with NetBSD curses.
  + improve test/list_keys.c, fixing column-widths and sorting the list
    to make it more readable.
* Mon Jun 13 2016 werner@suse.de
- Add ncurses patch 20160611
  + revise fix for Debian #805618 (report by Vlado Potisk, cf: 20151128).
  + modify test/ncurses.c a/A screens to make exiting on an escape
    character depend on the start of keypad and timeout modes, to allow
    better testing of function-keys.
  + modify rs1 for xterm-16color, xterm-88color and xterm-256color to
    reset palette using "oc" string as in linux -TD
  + use ANSI reply for u8 in xterm-new, to reflect vt220-style responses
    that could be returned -TD
  + added a few capabilities fixed in recent vte -TD
* Mon Jun  6 2016 werner@suse.de
- Add ncurses patch 20160528
  + further workaround for PIE/PIC breakage which causes gpm to not link.
  + fix most cppcheck warnings, mostly style, in ncurses library.
- Add ncurses patch 20160604
  + correct logic for -f option in test/demo_terminfo.c
  + add test/list_keys.c
* Tue May 24 2016 werner@suse.de
- Add ncurses patch 20160521
  + improved manual page description of tset/reset versus window-size.
  + fixes to work with a slightly broken compiler configuration which
    cannot compile "Hello World!" without adding compiler options
    (report by Ola x Nilsson):
    + pass appropriate compiler options to the CF_PROG_CC_C_O macro.
    + when separating compiler and options in CF_CC_ENV_FLAGS, ensure
    that all options are split-off into CFLAGS or CPPFLAGS
    + restore some -I options removed in 20140726 because they appeared
    to be redundant.  In fact, they are needed for a compiler that
    cannot combine -c and -o options.
* Tue May 17 2016 werner@suse.de
- Add ncurses patch 20160514
  + regenerate HTML manpages.
  + improve manual pages for wgetch and wget_wch to point out that they
    might return values without names in curses.h (Debian #822426).
  + make linux3.0 entry the default linux entry (Debian #823658) -TD
  + modify linux2.6 entry to improve line-drawing so that the linux3.0
    entry can be used in non-UTF-8 mode -TD
  + document return value of use_extended_names (report by Mike Gran).
- Modify patch ncurses-6.0.dif
* Tue May 10 2016 werner@suse.de
- Add ncurses patch 20160507
  + amend change to _nc_do_color to restore the early return for the
    special case used in _nc_screen_wrap (report by Dick Streefland,
    cf: 20151017).
  + modify test/ncurses.c:
    + check return-value of putwin
    + correct ifdef which made the 'g' test's legend not reflect changes
    to keypad- and scroll-modes.
  + correct return-value of extended putwin (report by Mike Gran).
* Tue Apr 26 2016 werner@suse.de
- Add ncurses patch 20160423
  + modify test/ncurses.c 'd' edit-color menu to optionally read xterm
    color palette directly from terminal, as well as handling KEY_RESIZE
    and screen-repainting with control/L and control/R.
  + add 'oc' capability to xterm+256color, allowing palette reset for
    xterm -TD
* Mon Apr 18 2016 werner@suse.de
- Add ncurses patch 20160416
  + add workaround in configure script for inept transition to PIE vs
    PIC builds documented in
    https://fedoraproject.org/wiki/Changes/Harden_All_Packages
  + add "reset" to list of programs whose names might change in manpages
    due to program-transformation configure options.
  + drop long-obsolete "-n" option from tset.
- Add ncurses patch 20160409
  + modify test/blue.c to use Unicode values for card-glyphs when
    available, as well as improving the check for CP437 and CP850.
- Add ncurses patch 20160402
  + regenerate HTML manpages.
  + improve manual pages for utilities with respect to POSIX versus
    X/Open Curses.
- Add ncurses patch 20160326
  + regenerate HTML manpages.
  + improve test/demo_menus.c, allowing mouse-click on the menu-headers
    to switch the active menu.  This requires a new extension option
    O_MOUSE_MENU to tell the menu driver to put mouse events which do not
    apply to the active menu back into the queue so that the application
    can handle the event.
- Add ncurses patch 20160319
  + improve description of tgoto parameters (report by Steffen Nurpmeso).
  + amend workaround for Solaris line-drawing to restore a special case
    that maps Unicode line-drawing characters into the acsc string for
    non-Unicode locales (Debian #816888).
- Add ncurses patch 20160312
  + modified test/filter.c to illustrate an alternative to getnstr, that
    polls for input while updating a clock on the right margin as well
    as responding to window size-changes.
- Add ncurses patch 20160305
  + omit a redefinition of "inline" when traces are enabled, since this
    does not work with gcc 5.3.x MinGW cross-compiling (cf: 20150912).
* Thu Feb 25 2016 werner@suse.de
- Add ncurses patch 20160220
  + modify test/configure script to check for pthread dependency of
    ncursest or ncursestw library when building ncurses examples, e.g.,
    in case weak symbols are used.
  + modify configure macro for shared-library rules to use -Wl,-rpath
    rather than -rpath to work around a bug in scons (FreeBSD #178732,
    cf: 20061021).
  + double-width multibyte characters were not counted properly in
    winsnstr and wins_nwstr (report/example by Eric Pruitt).
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
* Mon Feb 15 2016 werner@suse.de
- Add ncurses patch 20160213
  + amend fix for _nc_ripoffline from 20091031 to make test/ditto.c work
    in threaded configuration.
  + move _nc_tracebits, _tracedump and _tracemouse to curses.priv.h,
    since they are not part of the suggested ABI6.
* Tue Feb  9 2016 werner@suse.de
- Add ncurses patch 20160206
  + define WIN32_LEAN_AND_MEAN for MinGW port, making builds faster.
  + modify test/ditto.c to allow $XTERM_PROG environment variable to
    override "xterm" as the name of the program to run in the threaded
    configuration.
* Fri Feb  5 2016 werner@suse.de
- Add ncurses patch 20160130
  + improve formatting of man/curs_refresh.3x and man/tset.1 manpages
  + regenerate HTML manpages using newer man2html to eliminate some
    unwanted blank lines.
- Add ncurses patch 20160123
  + ifdef'd header-file definition of mouse_trafo() with NCURSES_NOMACROS
    (report by Corey Minyard).
  + fix some strict compiler-warnings in traces.
- Add ncurses patch 20160116
  + tidy up comments about hardcoded 256color palette (report by
    Leonardo Brondani Schenkel) -TD
  + add putty-noapp entry, and amend putty entry to use application mode
    for better consistency with xterm (report by Leonardo Brondani
    Schenkel) -TD
  + modify _nc_viscbuf2() and _tracecchar_t2() to trace wide-characters
    as a whole rather than their multibyte equivalents.
  + minor fix in wadd_wchnstr() to ensure that each cell has nonzero
    width.
  + move PUTC_INIT calls next to wcrtomb calls, to avoid carry-over of
    error status when processing Unicode values which are not mapped.
* Fri Jan  8 2016 werner@suse.de
- Add ncurses patch 20160102
  + modify ncurses c/C color test-screens to take advantage of wide
    screens, reducing the number of lines used for 88- and 256-colors.
  + minor refinement to check versus ncv to ignore two parameters of
    SGR 38 and 48 when those come from color-capabilities.
- Add ncurses patch 20151226
  + add check in tic for use of bold, etc., video attributes in the
    color capabilities, accounting whether the feature is listed in ncv.
  + add check in tic for conflict between ritm, rmso, rmul versus sgr0.
- Add ncurses patch 20151219
  + add a paragraph to curs_getch.3x discussing key naming (discussion
    with James Crippen).
  + amend workaround for Solaris vs line-drawing to take the configure
    check into account.
  + add a configure check for wcwidth() versus the ncurses line-drawing
    characters, to use in special-casing systems such as Solaris.
- Add ncurses patch 20151212
  + improve CF_XOPEN_CURSES macro used in test/configure, to define as
    needed NCURSES_WIDECHAR for platforms where _XOPEN_SOURCE_EXTENDED
    does not work.  Also modified the test program to ensure that if
    building with ncurses, that the cchar_t type is checked, since that
    normally is since 20111030 ifdef'd depending on this test.
  + improve 20121222 workaround for broken acs, letting Solaris "work"
    in spite of its m.isconfigured wcwidth which marks all of the line
    drawing characters as double-width.
- Add ncurses patch 20151205
  + update form_cursor.3x, form_post.3x, menu_attributes.3x to list
    function names in NAME section (patch by Jason McIntyre).
  + minor fixes to manpage NAME/SYNOPSIS sections to consistently use
    rule that either all functions which are prototyped in SYNOPSIS are
    listed in the NAME section, or the manual-page name is the sole item
    listed in the NAME section.  The latter is used to reduce clutter,
    e.g., for the top-level library manual pages as well as for certain
    feature-pages such as SP-funcs and threading (prompted by patches by
    Jason McIntyre).
* Mon Nov 30 2015 werner@suse.de
- Add ncurses patch 20151128
  + add missing assignment in lib_getch.c to make notimeout() work
    (Debian #805618).
  + add 't' toggle for notimeout() function in test/ncurses.c a/A screens
  + add viewdata terminal description (Alexandre Montaron).
  + fix a case in tic/infocmp for formatting capabilities where a
    backslash at the end of a string was mishandled.
  + fix some typos in curs_inopts.3x (Benno Schulenberg).
* Mon Nov 23 2015 werner@suse.de
- Add ncurses patch 20151121
  + fix some inconsistencies in the pccon* entries -TD
  + add bold to pccon+sgr+acs and pccon-base (Tati Chevron).
  + add keys f12-f124 to pccon+keys (Tati Chevron).
  + add test/test_sgr.c program to exercise all combinations of sgr.
* Tue Nov 10 2015 werner@suse.de
- Add ncurses patch 20151107
  + modify tset's assignment to TERM in its output to reflect the name by
    which the terminal description is found, rather than the primary
    name.  That was an unnecessary part from the initial conversion of
    tset from termcap to terminfo.  The termcap program in 4.3BSD did
    this to avoid using the short 2-character name (report by Rich
    Burridge).
  + minor fix to configure script to ensure that rules for resulting.map
    are only generated when needed (cf: 20151101).
  + modify configure script to handle the case where tic-library is
    renamed, but the --with-debug option is used by itself without
    normal or shared libraries (prompted by comment in Debian #803482).
- Add ncurses patch 20151101
  + amend change for pkg-config which allows build of pc-files when no
    valid pkg-config library directory was configured to suppress the
    actual install if it is not overridden to a valid directory at
    install time (cf: 20150822).
  + modify editing script which generates resulting.map to work with the
    clang configuration on recent FreeBSD, which gives an error on an
    empty "local" section.
  + fix a spurious "(Part)" message in test/ncurses.c b/B tests due
    to incorrect attribute-masking.
- Add ncurses patch 20151024
  + modify MKexpanded.c to update the expansion of a temporary filename
    to "expanded.c", for use in trace statements.
  + modify layout of b/B tests in test/ncurses.c to allow for additional
    annotation on the right margin; some terminals with partial support
    did not display well.
  + fix typo in curs_attr.3x (patch by Sven Joachim).
  + fix typo in INSTALL (patch by Tomas Cech).
  + improve configure check for setting WILDCARD_SYMS variable; on ppc64
    the variable is in the Data section rather than Text (patch by Michel
    Normand).
  + using configure option "--without-fallbacks" incorrectly caused
    FALLBACK_LIST to be set to "no" (patch by Tomas Cech).
  + updated minitel entries to fix kel problem with emacs, and add
    minitel1b-nb (Alexandre Montaron).
  + reviewed/updated nsterm entry Terminal.app in OSX -TD
  + replace some dead URLs in comments with equivalents from the
    Internet Archive -TD
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
- Add ncurses patch 20151017
  + modify ncurses/Makefile.in to sort keys.list in POSIX locale
    (Debian #801864, patch by Esa Peuha).
  + remove an early-return from _nc_do_color, which can interfere with
    data needed by bkgd when ncurses is configured with extended colors
    (patch by Denis Tikhomirov).
  > fixes for OS/2 (patches by KO Myung-Hun)
  + use button instead of kbuf[0] in EMX-specific part of lib_mouse.c
  + support building with libtool on OS/2
  + use stdc++ on OS/2 kLIBC
  + clear cf_XOPEN_SOURCE on OS/2
- Remove patch ncurses-6.0-wildcard_for_ppc64.patch as this change is
  now upstream with patch set 20151024
* Sat Oct 31 2015 sleep_walker@opensuse.org
- remove hunk from ncurses-6.0.dif modifying configure.in
  according to NEWS (20110924) it is not used anymore
- drop ncurses-5.9-overwrite.dif as not neededd
  (WITH_OVERWRITE=$with_overwrite is in configure already twice anyway)
- drop ncurses-6.0-avoid-line-markers.dif as not needed
  (see ncurses/base/MKlib_gen.sh 69-84)
* Mon Oct 12 2015 werner@suse.de
-Add ncurses patch 20151010
  + add configure check for openpty to test/configure script, for ditto.
  + minor fixes to test/view.c in investigating Debian #790847.
  + update autoconf patch to 2.52.20150926, incorporates a fix for Cdk.
  + add workaround for breakage of POSIX makefiles by recent binutils
  change.
  + improve check for working poll() by using posix_openpt() as a
  fallback in case there is no valid terminal on the standard input
  (prompted by discussion on bug-ncurses mailing list, Debian #676461).
-Add ncurses patch 20150926
  + change makefile rule for removing resulting.map to distclean rather
  than clean.
  + add /lib/terminfo to terminfo-dirs in ".deb" test-package.
  + add note on portability of resizeterm and wresize to manual pages.
- Add ncurses patch 20150919
  + clarify in resizeterm.3x how KEY_RESIZE is pushed onto the input
  stream.
  + clarify in curs_getch.3x that the keypad mode affects ability to
  read KEY_MOUSE codes, but does not affect KEY_RESIZE.
  + add overlooked build-fix needed with Cygwin for separate Ada95
  configure script, cf: 20150606 (report by Nicolas Boulenguez)
* Thu Oct  8 2015 werner@suse.de
- Sedate the inflexible factory-auto checks
* Wed Oct  7 2015 sleep_walker@opensuse.org
- remove macro defined system-wide already
- remove special handling of patch which is no longer present
- move tack replacement code to one spot under comment
- remove duplicate parameters for configure
- fix position of libgpm.so
* Wed Oct  7 2015 werner@suse.de
- Simplify bootstrapping of libtinfo and its fallback.c
* Tue Oct  6 2015 werner@suse.de
- Add some comments what is done in the spec file as well as
  do some modernisation, concretion, and clarification
* Fri Sep 25 2015 normand@linux.vnet.ibm.com
- New patch to avoid ppc64 build error, related to bnc#946048
  ncurses-6.0-wildcard_for_ppc64.patch
* Mon Sep 14 2015 werner@suse.de
- Add ncurses patch 20150912
  + fixes for configure/build using clang on OSX (prompted by report by
    William Gallafent).
    + do not redefine "inline" in ncurses_cfg.h; this was originally to
    solve a problem with gcc/g++, but is aggravated by clang's misuse
    of symbols to pretend it is gcc.
    + add braces to configure script to prevent unwanted add of
    "-lstdc++" to the CXXLIBS symbol.
    + improve/update test-program used for checking existence of stdc++
    library.
    + if $CXXLIBS is set, the linkage test uses that in addition to $LIBS
* Mon Sep  7 2015 werner@suse.de
- Add ncurses patch 20150905
  + add note in curs_addch.3x about line-drawing when it depends upon
    UTF-8.
  + add tic -q option for consistency with infocmp, use it to suppress
    all comments from the "tic -I" output.
  + modify infocmp -q option to suppress the "Reconstructed from"
    header.
  + add infocmp/tic -Q option, which allows one to dump the compiled
    form of the terminal entry, in hexadecimal or base64.
* Mon Aug 31 2015 werner@suse.de
- Add ncurses patch 20150822
  + sort options in usage message for infocmp, to make it simpler to
    see unused letters.
  + update usage message for tic, adding "-0" option.
  + documented differences in ESCDELAY versus AIX's implementation.
  + fix some compiler warnings from ports.
  + modify --with-pkg-config-libdir option to make it possible to install
    ".pc" files even if pkg-config is not found (adapted by patch by
    Joshua Root).
* Mon Aug 17 2015 werner@suse.de
- Add ncurses patch 20150815
  + disallow "no" as a possible value for "--with-shlib-version" option,
    overlooked in cleanup-changes for 20000708 (report by Tommy Alex).
  + update release notes in INSTALL.
  + regenerate llib-* files to help with review for release notes.
- Modify patch ncurses-5.9-overwrite.dif
* Fri Aug 14 2015 werner@suse.de
- Add ncurses patch 20150810
  + workaround for Debian #65617, which was fixed in mawk's upstream
    releases in 2009 (report by Sven Joachim).  See
    http://invisible-island.net/mawk/CHANGES.html#t20090727
- Move infocmp from devel to utils package for ruby readline implementation
* Wed Aug 12 2015 werner@suse.de
- Update to official ncurses 6.0
  + based on the patch 20150808
- Port and rename several patches
  ncurses-5.9-avoid-line-markers.dif becomes ncurses-6.0-avoid-line-markers.dif
  ncurses-5.9.dif becomes ncurses-6.0.dif
- Add ncurses patch 20150808
  + build-fix for Ada95 on older platforms without stdint.h
  + build-fix for Solaris, whose /bin/sh and /usr/bin/sed are non-POSIX.
  + update release announcement, summarizing more than 800 changes across
    more than 200 snapshots.
  + minor fixes to manpages, etc., to simplify linking from announcement
    page.
* Tue Jul 28 2015 werner@suse.de
- Add ncurses patch 20150725
  + updated llib-* files.
  + build-fixes for ncurses library "test_progs" rule.
  + use alternate workaround for gcc 5.x feature (adapted from patch by
    Mikhail Peselnik).
  + add status line to tmux via xterm+sl (patch by Nicholas Marriott).
  + fixes for st 0.5 from testing with tack -TD
  + review/improve several manual pages to break up wall-of-text:
    curs_add_wch.3x, curs_attr.3x, curs_bkgd.3x, curs_bkgrnd.3x,
    curs_getcchar.3x, curs_getch.3x, curs_kernel.3x, curs_mouse.3x,
    curs_outopts.3x, curs_overlay.3x, curs_pad.3x, curs_termattrs.3x
    curs_trace.3x, and curs_window.3x
* Mon Jul 27 2015 werner@suse.de
- Rework fixing the pkg-config files
* Mon Jul 20 2015 werner@suse.de
- Add ncurses patch 20150719
  + correct an old logic error for %%A and %%O in tparm (report by "zreed").
  + improve documentation for signal handlers by adding section in the
    curs_initscr.3x page.
  + modify logic in make_keys.c to not assume anything about the size
    of strnames and strfnames variables, since those may be functions
    in the thread- or broken-linker configurations (problem found by
    Coverity).
  + modify test/configure script to check for pthreads configuration,
    e.g., ncursestw library.
* Mon Jul 13 2015 werner@suse.de
- Add ncurses patch 20150711 pre-release
  + modify scripts to build/use test-packages for the pthreads
    configuration of ncurses6.
  + add references to ttytype and termcap symbols in demo_terminfo.c and
    demo_termcap.c to ensure that when building ncursest.map, etc., that
    the corresponding names such as _nc_ttytype are added to the list of
    versioned symbols (report by Werner Fink)
  + fix regression from 20150704 (report/patch by Werner Fink).
* Mon Jul  6 2015 werner@suse.de
- Add ncurses patch 20150606 pre-release
  + make ABI 6 the default by updates to dist.mk and VERSION, with the
    intention that the existing ABI 5 should build as before using the
    "--with-abi=5" option.
  + regenerate ada- and man-html documentation.
  + minor fixes to color- and util-manpages.
  + fix a regression in Ada95/gen/Makefile.in, to handle special case of
    Cygwin, which uses the broken-linker feature.
  + amend fix for CF_NCURSES_CONFIG used in test/configure to assume that
    ncurses package scripts work when present for cross-compiling, as the
    lessor of two evils (cf: 20150530).
  + add check in configure script to disallow conflicting options
    "--with-termlib" and "--enable-term-driver".
  + move defaults for "--disable-lp64" and "--with-versioned-syms" into
    CF_ABI_DEFAULTS macro.
- Add ncurses patch 20150613
  + fix overflow warning for OSX with lib_baudrate.c (cf: 20010630).
  + modify script used to generate map/sym files to mark 5.9.20150530 as
    the last "5.9" version, and regenerated the files.  That makes the
    files not use ".current" for the post-5.9 symbols.  This also
    corrects the label for _nc_sigprocmask used in when weak symbols are
    configured for the ncursest/ncursestw libraries (prompted by
    discussion with Sven Joachim).
  + fix typo in NEWS (report by Sven Joachim).
- Add ncurses patch 20150627
  + modify configure script to remove deprecated ABI 5 symbols when
    building ABI 6.
  + add symbols _nc_Default_Field, _nc_Default_Form, _nc_has_mouse to
    map-files, but marked as deprecated so that they can easily be
    suppressed from ABI 6 builds (Debian #788610).
  + comment-out "screen.xterm" entry, and inherit screen.xterm-256color
    from xterm-new (report by Richard Birkett) -TD
  + modify read_entry.c to set the error-return to -1 if no terminal
    databases were found, as documented for setupterm.
  + add test_setupterm.c to demonstrate normal/error returns from the
    setupterm and restartterm functions.
  + amend cleanup change from 20110813 which removed redundant definition
    of ret_error, etc., from tinfo_driver.c, to account for the fact that
    it should return a bool rather than int (report/analysis by Johannes
    Schindelin).
- Add ncurses patch 20150704
  + fix a few problems reported by Coverity.
  + fix comparison against "/usr/include" in misc/gen-pkgconfig.in
    (report by Daiki Ueno, Debian #790548, cf:  20141213).
- Add tack patch 1.07.20150606
  + Able to handle ncurses6 in configure
* Mon Jun  1 2015 werner@suse.de
- Add ncurses patch 20150530
  + change private type for Event_Mask in Ada95 binding to work when
    mmask_t is set to 32-bits.
  + remove spurious "%%;" from st entry (report by Daniel Pitts) -TD
  + add vte-2014, update vte to use that -TD
  + modify tic and infocmp to "move" a diagnostic for tparm strings that
    have a syntax error to tic's "-c" option (report by Daniel Pitts).
  + fix two problems with configure script macros (Debian #786436,
    cf: 20150425, cf: 20100529).
- Add ncurses patch 20150523
  + add 'P' menu item to test/ncurses.c, to show pad in color.
  + improve discussion in curs_color.3x about color rendering (prompted
    by comment on Stack Overflow forum):
  + remove screen-bce.mlterm, since mlterm does not do "bce" -TD
  + add several screen.XXX entries to support the respective variations
    for 256 colors -TD
  + add putty+fnkeys* building-block entries -TD
  + add smkx/rmkx to capabilities analyzed with infocmp "-i" option.
* Mon May 18 2015 werner@suse.de
- Add ncurses patch 20150516
  + amend change to ".pc" files to only use the extra loader flags which
    may have rpath options (report by Sven Joachim, cf: 20150502).
  + change versioning for dpkg's in test-packages for Ada95 and
    ncurses-examples for consistency with Debian, to work with package
    updates.
  + regenerate html manpages.
  + clarify handling of carriage return in waddch manual page; it was
    discussed only in the portability section (prompted by comment on
    Stack Overflow forum):
* Mon May 11 2015 werner@suse.de
- Add ncurses patch 20150509
  + add test-packages for cross-compiling ncurses-examples using the
    MinGW test-packages.  These are only the Debian packages; RPM later.
  + cleanup format of debian/copyright files
  + add pc-files to the MinGW cross-compiling test-packages.
  + correct a couple of places in gen-pkgconfig.in to handle renaming of
    the tinfo library.
* Mon May  4 2015 werner@suse.de
- Add ncurses patch 20150502
  + modify the configure script to allow different default values
    for ABI 5 versus ABI 6.
  + add wgetch-events to test-packages.
  + add a note on how to build ncurses-examples to test/README.
  + fix a memory leak in delscreen (report by Daniel Kahn Gillmor,
    Debian #783486) -TD
  + remove unnecessary ';' from E3 capabilities -TD
  + add tmux entry, derived from screen (patch by Nicholas Marriott).
  + split-out recent change to nsterm-bce as nsterm-build326, and add
    nsterm-build342 to reflect changes with successive releases of OSX
    (discussion with Leonardo B Schenkel)
  + add xon, ich1, il1 to ibm3161 (patch by Stephen Powell, Debian
    [#783806])
  + add sample "magic" file, to document ext-putwin.
  + modify gen-pkgconfig.in to add explicit -ltinfo, etc., to the
    generated ".pc" file when ld option "--as-needed" is used, or when
    ncurses and tinfo are installed without using rpath (prompted by
    discussion with Sylvain Bertrand).
  + modify test-package for ncurses6 to omit rpath feature when installed
    in /usr.
  + add OSX's "*.dSYM" to clean-rules in makefiles.
  + make extra-suffix work for OSX configuration, e.g., for shared
    libraries.
  + modify Ada95/configure script to work with pkg-config
  + move test-package for ncurses6 to /usr, since filename-conflicts have
    been eliminated.
  + corrected build rules for Ada95/gen/generate; it does not depend on
    the ncurses library aside from headers.
  + reviewed man pages, fixed a few other spelling errors.
  + fix a typo in curs_util.3x (Sven Joachim).
  + use extra-suffix in some overlooked shared library dependencies
    found by 20150425 changes for test-packages.
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
* Mon Apr 27 2015 werner@suse.de
- Add ncurses patch 20150425
  + expanded description of tgetstr's area pointer in manual page
    (report by Todd M Lewis).
  + in-progress changes to modify test-packages to use ncursesw6 rather
    than ncursesw, with updated configure scripts.
  + modify CF_NCURSES_CONFIG in Ada95- and test-configure scripts to
    check for ".pc" files via pkg-config, but add a linkage check since
    frequently pkg-config configurations are broken.
  + modify misc/gen-pkgconfig.in to include EXTRA_LDFLAGS, e.g., for the
    rpath option.
  + add 'dim' capability to screen entry (report by Leonardo B Schenkel)
  + add several key definitions to nsterm-bce to match preconfigured
    keys, e.g., with OSX 10.9 and 10.10 (report by Leonardo B Schenkel)
  + fix repeated "extra-suffix" in ncurses-config.in (cf: 20150418).
  + improve term_variables manual page, adding section on the terminfo
    long-name symbols which are defined in the term.h header.
  + fix bug in lib_tracebits.c introduced in const-fixes (cf: 20150404).
* Mon Apr 13 2015 werner@suse.de
- Add ncurses patch 20150404
  + improve description of start_color() in the manual.
  + modify several files in ncurses- and progs-directories to allow
    const data used in internal tables to be put by the linker into the
    readonly text segment.
- Add ncurses patch 20150329
  + correct cut/paste error for "--enable-ext-putwin" that made it the
    same as "--enable-ext-colors" (report by Roumen Petrov)
- Add ncurses patch 20150328
  + add "-f" option to test/savescreen.c to help with testing/debugging
    the extended putwin/getwin.
  + add logic for writing/reading combining characters in the extended
    putwin/getwin.
  + add "--enable-ext-putwin" configure option to turn on the extended
    putwin/getwin.
* Mon Mar  9 2015 werner@suse.de
- Add ncurses patch 20150307
  + document limitations of getwin in manual page (prompted by discussion
    with John S Urban).
  + extend test/savescreen.c to demonstrate that color pair values
    and graphic characters can be restored using getwin.
* Tue Mar  3 2015 werner@suse.de
- Add ncurses patch 20150228
  + modify win_driver.c to eliminate the constructor, to make it more
    usable in an application which may/may not need the console window
    (report by Grady Martin).
* Fri Feb 27 2015 werner@suse.de
- Add ncurses patch 20150221
  + capture define's related to -D_XOPEN_SOURCE from the configure check
    and add those to the *-config and *.pc files, to simplify use for
    the wide-character libraries.
  + modify ncurses.spec to accommodate Fedora21's location of pkg-config
    directory.
  + correct sense of "--disable-lib-suffixes" configure option (report
    by Nicolas Boos, cf: 20140426).
* Mon Feb 16 2015 werner@suse.de
- Add ncurses patch 20150214
  + regenerate html manpages using improved man2html from work on xterm.
  + regenerated ".map" and ".sym" files using improved script, accounting
    for the "--enable-weak-symbols" configure option (report by Werner
    Fink).
* Mon Jan 26 2015 werner@suse.de
- Add ncurses patch 20150124
  + add configure check to determine if "local: _*;" can be used in the
    ".map" files to selectively omit symbols beginning with "_".  On at
    least recent FreeBSD, the wildcard applies to all "_" symbols.
  + remove obsolete/conflicting rule for ncurses.map from
    ncurses/Makefile.in (cf:  20130706).
- Apply symbol versioning only for SUSE version greater that 1320
* Wed Jan 21 2015 werner@suse.de
- Now with symbol version control
* Wed Jan 21 2015 werner@suse.de
- Add ncurses patch 20150117
  + improve description in INSTALL of the --with-versioned-syms option.
  + add combination of --with-hashed-db and --with-ticlib to
    configurations for ".map" files (report by Werner Fink).
* Wed Jan 21 2015 rguenther@suse.com
- Add ncurses-5.9-avoid-line-markers.dif to pass -P to the preprocessor
  when generating lib_gen.c to avoid breaking the parsing with AWK
  of the preprocessor output of GCC 4.9 and up.
* Mon Jan 12 2015 werner@suse.de
- Add ncurses patch 20150110
  + add a step to generating ".map" files, to declare any remaining
    symbols beginning with "_" as local, at the last version node.
  + improve configure checks for pkg-config, addressing a variant found
    with FreeBSD ports.
  + modify win_driver.c to provide characters for special keys, like
    ansi.sys, when keypad mode is off, rather than returning nothing at
    all (discussion with Eli Zaretskii).
  + add "broken_linker" and "hashed-db" configure options to combinations
    use for generating the ".map" and ".sym" files.
  + avoid using "ld" directly when creating shared library, to simplify
    cross-compiles.  Also drop "-Bsharable" option from shared-library
    rules for FreeBSD and DragonFly (FreeBSD #196592).
  + fix a memory leak in form library Free_RegularExpression_Type()
    (report by Pavel Balaev).
* Wed Jan  7 2015 werner@suse.de
- Add ncurses patch 20150103
  + modify_nc_flush() to retry if interrupted (patch by Stian Skjelstad).
  + change map files to make _nc_freeall a global, since it may be used
    via the Ada95 binding when checking for memory leaks.
  + improve sed script used in 20141220 to account for wide-, threaded-
    variations in ABI 6.
- Add ncurses patch 20141227
  + regenerate ".map" files, using step overlooked in 20141213 to use
    the same patch-dates across each file to match ncurses.map (report by
    Sven Joachim).
- Add ncurses patch 20141221
  + fix an incorrect variable assignment in 20141220 changes (report by
    Sven Joachim).
- Add ncurses patch 20141220
  + updated Ada95/configure with macro changes from 20141213
  + tie configure options --with-abi-version and --with-versioned-syms
    together, so that ABI 6 libraries have distinct symbol versions from
    the ABI 5 libraries.
  + replace obsolete/nonworking link to man2html with current one,
    regenerate html-manpages.
* Tue Dec 16 2014 werner@suse.de
- Add ncurses patch 20141206
  + updated ".map" files so that each symbol that may be shared across
    the different library configurations has the same label.  Some
    review is needed to ensure these are really compatible.
  + modify MKlib_gen.sh to work around change in development version of
    gcc introduced here:
    https://gcc.gnu.org/ml/gcc-patches/2014-06/msg02185.html
    https://gcc.gnu.org/ml/gcc-patches/2014-07/msg00236.html
    (reports by Marcus Shawcroft, Maohui Lei).
  + improved configure macro CF_SUBDIR_PATH, from lynx changes.
- Add ncurses patch 20141213
  + modify misc/gen-pkgconfig.in to add -I option for include-directory
    when using both --prefix and --disable-overwrite (report by Misty
    De Meo).
  + add configure option --with-pc-suffix to allow minor renaming of
    ".pc" files and the corresponding library.  Use this in the test
    package for ncurses6.
  + modify configure script so that if pkg-config is not installed, it
    is still possible to install ".pc" files (report by Misty De Meo).
  + updated ".sym" files, removing symbols which are marked as "local"
    in the corresponding ".map" files.
  + updated ".map" files to reflect move of comp_captab and comp_hash
    from tic-library to tinfo-library in 20090711 (report by Sven
    Joachim).
- Add ncurses patch 20141129
  + improved ".map" files by generating them with a script that builds
    ncurses with several related configurations and merges the results.
    A further refinement is planned, to make the tic- and tinfo-library
    symbols use the same versions across each of the four configurations
    which are represented (reports by Sven Joachim, Werner Fink).
* Mon Nov 17 2014 werner@suse.de
- Do not use new symbol versioning as some common symbols are missed
- Add ncurses patch 20141115
  + improve description of limits for color values and color pairs in
    curs_color.3x (prompted by patch by Tim van der Molen).
  + add VERSION file, using first field in that to record the ABI version
    used for configure --with-libtool --disable-libtool-version
  + add configure options for applying the ".map" and ".sym" files to
    the ncurses, form, menu and panel libraries.
  + add ".map" and ".sym" files to show exported symbols, e.g., for
    symbol-versioning.
- Add ncurses patch 20141101
  + improve strict compiler-warnings by adding a cast in TRACE_RETURN
    and making a new TRACE_RETURN1 macro for cases where the cast does
    not apply.
* Mon Oct 20 2014 werner@suse.de
- Add ncurses patch 20141018
  + reviewed terminology 0.6.1, add function key definitions.  None of
    the vt100-compatibility issues were improved -TD
  + improve infocmp conversion of extended capabilities to termcap by
    correcting the limit check against parametrized[], as well as filling
    in a check if the string happens to have parameters, e.g., "xm"
    in recent changes.
  + add check for zero/negative dimensions for resizeterm and resize_term
    (report by Mike Gran).
* Mon Oct 13 2014 werner@suse.de
- Add ncurses patch 20141011
  + add experimental support for xterm's 1005 mouse mode, to use in a
    demonstration of its limitations.
  + add experimental support for "%%u" format to terminfo.
  + modify test/ncurses.c to also show position reports in 'a' test.
  + minor formatting fixes to _nc_trace_mmask_t, make this function
    exported to help with debugging mouse changes.
  + improve behavior of wheel-mice for xterm protocol, noting that there
    are only button-presses for buttons "4" and "5", so there is no need
    to wait to combine events into double-clicks (report/analysis by
    Greg Field).
  + provide examples xterm-1005 and xterm-1006 terminfo entries -TD
  + implement decoder for xterm SGR 1006 mouse mode.
- Adapt patch ncurses-5.9.dif
* Tue Sep 30 2014 werner@suse.de
- Add upstream patch 20140927
  + implement curs_set in win_driver.c
  + implement flash in win_driver.c
  + fix an infinite loop in win_driver.c if the command-window loses
    focus.
  + improve the non-buffered mode, i.e., NCURSES_CONSOLE2, of
    win_driver.c by temporarily changing the buffer-size to match the
    window-size to eliminate the scrollback.  Also enforce a minimum
    screen-size of 24x80 in the non-buffered mode.
  + modify generated misc/Makefile to suppress install.data from the
    dependencies if the --disable-db-install option is used, compensating
    for the top-level makefile changes used to add ncurses*-config in the
    20140920 changes (report by Steven Honeyman).
* Tue Sep 23 2014 werner@suse.de
- Add ncurses patch 20140920
  + add ncurses*-config to bin-directory of sample package-scripts.
  + add check to ensure that getopt is available; this is a problem in
    some older cross-compiler environments.
  + expanded on the description of --disable-overwrite in INSTALL
    (prompted by reports by Joakim Tjernlund, Thomas Klausner).
    See Gentoo #522586 and NetBSD #49200 for examples.
    which relates to the clarified guidelines.
  + remove special logic from CF_INCLUDE_DIRS which adds the directory
    for the --includedir from the build (report by Joakim Tjernlund).
  + add case for Unixware to CF_XOPEN_SOURCE, from lynx changes.
  + update config.sub from http://git.savannah.gnu.org/cgit/config.git
* Mon Sep 15 2014 werner@suse.de
- Add ncurses patch 20140913
  + add a configure check to ignore some of the plethora of non-working
    C++ cross-compilers.
  + build-fixes for Ada95 with gnat 4.9
* Mon Sep  1 2014 werner@suse.de
- Add ncurses patch 20140831
  + modify test/demo_termcap.c and test/demo_terminfo.c to make their
    options more directly comparable, and add "-i" option to specify
    a terminal description filename to parse for names to lookup.
* Mon Aug 25 2014 werner@suse.de
- Make pkgconfig files work for all current versions that is
  abi 5, abi wide 5, abi 6, and abi wide 6
- Change patch ncurses-5.9.dif to enable gen-pkgconfig to do this
* Mon Aug 25 2014 werner@suse.de
- Add ncurses patch 20140823
  + fix special case where double-width character overwrites a single-
    width character in the first column (report by Egmont Koblinger,
    cf: 20050813).
* Fri Aug 22 2014 mmarek@suse.cz
- Install pkg-config files into %%_libdir
* Fri Aug 22 2014 mmarek@suse.cz
- Install pkg-config files
* Mon Aug 18 2014 werner@suse.de
- Add ncurses patch 20140816
  + fix colors in ncurses 'b' test which did not work after changing
    it to put the test-strings in subwindows (cf: 20140705).
  + merge redundant SEE-ALSO sections in form and menu manpages.
- Add ncurses patch 20140809
  + modify declarations for user-data pointers in C++ binding to use
    reinterpret_cast to facilitate converting typed pointers to void*
    in user's application (patch by Adam Jiang).
  + regenerated html manpages.
  + add note regarding cause and effect for TERM in ncurses manpage,
    having noted clueless verbiage in Terminal.app's "help" file
    which reverses cause/effect.
  + remove special fallback definition for NCURSES_ATTR_T, since macros
    have resolved type-mismatches using casts (cf: 970412).
  + fixes for win_driver.c:
    + handle repainting on endwin/refresh combination.
    + implement beep().
    + minor cleanup.
- Add ncurses patch 20140802
  + minor portability fixes for MinGW:
    + ensure WINVER is defined in makefiles rather than using headers
    + add check for gnatprep "-T" option
    + work around bug introduced by gcc 4.8.1 in MinGW which breaks
    "trace" feature:
    http://stackoverflow.com/questions/20877689/gcc-4-8-1-minggw-d-option-does-not-work-as-usual
  + fix most compiler warnings for Cygwin ncurses-examples.
  + restore "redundant" -I options in test/Makefile.in, since they are
    typically needed when building the derived ncurses-examples package
    (cf: 20140726).
* Mon Jul 28 2014 werner@suse.de
- Add ncurses patch 20140726
  + eliminate some redundant -I options used for building libraries, and
    ensure that ${srcdir} is added to the include-options (prompted by
    discussion with Paul Gilmartin).
  + modify configure script to work with Minix3.2
  + add form library extension O_DYNAMIC_JUSTIFY option which can be
    used to override the different treatment of justification for static
    versus dynamic fields (adapted from patch by Leon Winter).
  + add a null pointer check in test/edit_field.c (report/analysis by
    Leon Winter, cf: 20130608).
* Mon Jul 14 2014 werner@suse.de
- Add ncurses patch 20140712
  + correct Charable() macro check for A_ALTCHARSET in wide-characters.
  + build-fix for position-debug code in tty_update.c, to work with or
    without sp-funcs.
- Add ncurses patch 20140705
  + add w/W toggle to ncurses.c 'B' test, to demonstrate permutation of
    video-attributes and colors with double-width character strings.
* Mon Jun 30 2014 werner@suse.de
- Add ncurses patch 20140629
  + correct check in win_driver.c for saving screen contents, e.g., when
    NCURSES_CONSOLE2 is set (cf: 20140503).
  + reorganize b/B menu items in ncurses.c, putting the test-strings into
    subwindows.  This is needed for a planned change to use Unicode
    fullwidth characters in the test-screens.
  + correct update to form status for _NEWTOP, broken by fixes for
    compiler warnings (patch by Leon Winter, cf: 20120616).
* Tue Jun 24 2014 werner@suse.de
- Remove the iterm link to iTerm.app terminal entry as there is already
  an iterm entry from an other package
- Add ncurses patch 20140621
  + change shared-library suffix for AIX 5 and 6 to ".so", avoiding
    conflict with the static library (report by Ben Lentz).
  + document RPATH_LIST in INSTALLATION file, as part of workarounds for
    upgrading an ncurses library using the "--with-shared" option.
  + modify test/ncurses.c c/C tests to cycle through subsets of the
    total number of colors, to better illustrate 8/16/88/256-colors by
    providing directly comparable screens.
  + add test/dots_curses.c, for comparison with the low-level examples.
* Mon Jun 16 2014 werner@suse.de
- Add ncurses patch 20140614
  + fix dereference before null check found by Coverity in tic.c
    (cf: 20140524).
  + fix sign-extension bug in read_entry.c which prevented "toe" from
    reading empty "screen+italics" entry.
  + modify sgr for screen.xterm-new to support dim capability -TD
  + add dim capability to nsterm+7 -TD
  + cancel dim capability for iterm -TD
  + add dim, invis capabilities to vte-2012 -TD
  + add sitm/ritm to konsole-base and mlterm3 -TD
- Add ncurses patch 20140609
  > fix regression in screen terminfo entries (reports by Christian
    Ebert, Gabriele Balducci) -TD
  + revert the change to screen; see notes for why this did not work -TD
  + cancel sitm/ritm for entries which extend "screen", to work around
    screen's hardcoded behavior for SGR 3 -TD
- Add ncurses patch 20140607
  + separate masking for sgr in vidputs from sitm/ritm, which do not
    overlap with sgr functionality.
  + remove unneeded -i option from adacurses-config; put -a in the -I
    option for consistency (patch by Pascal Pignard).
  + update xterm-new to patch #305 -TD
  + change format of test-scripts for Debian Ada95 and ncurses-examples
    packages to quilted to work around Debian #700177 (cf: 20130907).
  + build fix for form_driver_w.c as part of ncurses-examples package for
    older ncurses than 20131207.
  + add Hello World example to adacurses-config manpage.
  + remove unused --enable-pc-files option from Ada95/configure.
  + add --disable-gnat-projects option for testing.
  + revert changes to Ada95 project-files configuration (cf: 20140524).
  + corrected usage message in adacurses-config.
* Mon May 26 2014 werner@suse.de
- Add ncurses patch 20140524
  + fix typo in ncurses manpage for the NCURSES_NO_MAGIC_COOKIE
    environment variable.
  + improve discussion of input-echoing in curs_getch.3x
  + clarify discussion in curs_addch.3x of wrapping.
  + modify parametrized.h to make fln non-padded.
  + correct several entries which had termcap-style padding used in
    terminfo: adm21, aj510, alto-h19, att605-pc, x820 -TD
  + correct syntax for padding in some entries: dg211, h19 -TD
  + correct ti924-8 which had confused padding versus octal escapes -TD
  + correct padding in sbi entry -TD
  + fix an old bug in the termcap emulation; "%%i" was ignored in tparm()
    because the parameters to be incremented were already on the internal
    stack (report by Corinna Vinschen).
  + modify tic's "-c" option to take into account the "-C" option to
    activate additional checks which compare the results from running
    tparm() on the terminfo expressions versus the translated termcap
    expressions.
  + modify tic to allow it to read from FIFOs (report by Matthieu Fronton,
    cf: 20120324).
  > patches by Nicolas Boulenguez:
  + explicit dereferences to suppress some style warnings.
  + when c_varargs_to_ada.c includes its header, use double quotes
    instead of <>.
  + samples/ncurses2-util.adb:  removed unused with clause.  The warning
    was removed by an obsolete pragma.
  + replaced Unreferenced pragmas with Warnings (Off).  The latter,
    available with older GNATs, needs no configure test.  This also
    replaces 3 untested Unreferenced pragmas.
  + simplified To_C usage in trace handling.  Using two parameters allows
    some basic formatting, and avoids a warning about security with some
    compiler flags.
  + for generated Ada sources, replace many snippets with one pure
    package.
  + removed C_Chtype and its conversions.
  + removed C_AttrType and its conversions.
  + removed conversions between int, Item_Option_Set, Menu_Option_Set.
  + removed int, Field_Option_Set, Item_Option_Set conversions.
  + removed C_TraceType, Attribute_Option_Set conversions.
  + replaced C.int with direct use of Eti_Error, now enumerated.  As it
    was used in a case statement, values were tested by the Ada compiler
    to be consecutive anyway.
  + src/Makefile.in: remove duplicate stanza
    only consider using a project for shared libraries.
- Add tack patch 1.07.20130713
  * init.c: typo
  * fun.c, scan.c: fix warnings from clang 3.3 --analyze
  * init.c: add error check to setupterm call; ncurses does in fact
    allow hardcopy and generic terminal descriptions (Debian #716377).
* Mon May 12 2014 werner@suse.de
- Add ncurses patch 20140510
  + cleanup recently introduced compiler warnings for MingW port.
  + workaround for ${MAKEFLAGS} configure check versus GNU make 4.0,
    which introduces more than one gratuitous incompatibility.
* Mon May  5 2014 werner@suse.de
-  Add ncurses patch 20140503
  + add vt520ansi terminfo entry (patch by Mike Gran)
  + further improve MinGW support for the scenario where there is an
    ANSI-escapes handler such as ansicon running in the console window
    (patch by Juergen Pfeifer).
* Mon Apr 28 2014 werner@suse.de
- Add ncurses patch 20140426
  + add --disable-lib-suffixes option (adapted from patch by Juergen
    Pfeifer).
  + merge some changes from Juergen Pfeifer's work with MSYS2, to
    simplify later merging:
    + use NC_ISATTY() macro for isatty() in library
    + add _nc_mingw_isatty() and related functions to windows-driver
    + rename terminal driver entrypoints to simplify grep's
  + remove a check in the sp-funcs flavor of newterm() which allowed only
    the first call to newterm() to succeed (report by Thomas Beierlein,
    cf: 20090927).
- Add ncurses patch 20140419
  + update config.guess, config.sub from
    http://git.savannah.gnu.org/cgit/config.git
* Mon Apr 14 2014 werner@suse.de
- Add ncurses patch 20140412
  + modify configure script:
    + drop the -no-gcc option from Intel compiler, from lynx changes.
    + extend the --with-hashed-db configure option to simplify building
    with different versions of Berkeley database using FreeBSD ports.
  + improve initialization for MinGW port (patch by Juergen Pfeifer):
* Mon Mar 31 2014 werner@suse.de
- Add ncurses patch 20140329
  + add check in tic for mismatch between ccc and initp/initc
  + cancel ccc in putty-256color and konsole-256color for consistency
    with the cancelled initc capability (patch by Sven Zuhlsdorf).
  + add xterm+256setaf building block for various terminals which only
    get the 256-color feature half-implemented -TD
  + updated "st" entry (leaving the 0.1.1 version as "simpleterm") to
    0.4.1 -TD
* Thu Mar 27 2014 werner@suse.de
- Make sure that libgpm is always loaded dynamically
* Wed Mar 26 2014 werner@suse.de
- Add ncurses patch 20140323
  + fix typo in "mlterm" entry (report by Gabriele Balducci) -TD
- Add ncurses patch 20140322
  + use types from <stdint.h> in sample build-scripts for chtype, etc.
  + modify configure script and curses.h.in to allow the types specified
    using --with-chtype and related options to be defined in <stdint.h>
  + add terminology entry -TD
  + add mlterm3 entry, use that as "mlterm" -TD
  + inherit mlterm-256color from mlterm -TD
* Tue Mar 18 2014 werner@suse.de
- Add ncurses patch 20140315
  + modify _nc_New_TopRow_and_CurrentItem() to ensure that the menu's
    top-row is adjusted as needed to ensure that the current item is
    on the screen (patch by Johann Klammer).
  + add wgetdelay() to retrieve _delay member of WINDOW if it happens to
    be opaque, e.g., in the pthread configuration (prompted by patch by
    Soren Brinkmann).
* Wed Mar 12 2014 werner@suse.de
- Add ncurses patch 20140308
  + modify ifdef in read_entry.c to handle the case where
    NCURSES_USE_DATABASE is not defined (patch by Xin Li).
  + add cast in form_driver_w() to fix ARM build (patch by Xin Li).
  + add logic to win_driver.c to save/restore screen contents when not
    allocating a console-buffer (cf: 20140215).
* Mon Mar  3 2014 werner@suse.de
- Add ncurses patch 20140301
  + clarify error-returns from newwin (report by Ruslan Nabioullin).
- Add ncurses patch 20140222
  + fix some compiler warnings in win_driver.c
  + updated notes for wsvt25 based on tack and vttest -TD
  + add teken entry to show actual properties of FreeBSD's "xterm"
    console -TD
- Add ncurses patch 20140215
  + in-progress changes to win_driver.c to implement output without
    allocating a console-buffer.  This uses a pre-existing environment
    variable NCGDB used by Juergen Pfeifer for debugging (prompted by
    discussion with Erwin Waterlander regarding Console2, which hangs
    when reading in an allocated console-buffer).
  + add -t option to gdc.c, and modify to accept "S" to step through the
    scrolling-stages.
  + regenerate NCURSES-Programming-HOWTO.html to fix some of the broken
    html emitted by docbook.
- Add ncurses patch 20140209
  + modify CF_XOPEN_SOURCE macro to omit followup check to determine if
    _XOPEN_SOURCE can/should be defined.  g++ 4.7.2 built on Solaris 10
    has some header breakage due to its own predefinition of this symbol
    (report by Jean-Pierre Flori, Sage #15796).
* Mon Feb  3 2014 werner@suse.de
- Add ncurses patch 20140201
  + add/use symbol NCURSES_PAIRS_T like NCURSES_COLOR_T, to illustrate
    which "short" types are for color pairs and which are color values.
  + fix build for s390x, by correcting field bit offsets in generated
    representation clauses when int=32 long=64 and endian=big, or at
    least on s390x (patch by Nicolas Boulenguez).
  + minor cleanup change to test/form_driver_w.c (patch by Gaute Hope).
- Add ncurses patch 20140125
  + remove unnecessary ifdef's in Ada95/gen/gen.c, which reportedly do
    not work as is with gcc 4.8 due to fixes using chtype cast made for
    new compiler warnings by gcc 4.8 in 20130824 (Debian #735753, patch
    by Nicolas Boulenguez).
* Tue Jan 28 2014 werner@suse.de
- Add patch ncurses-5.9-ibm327x.dif to make ibm327x not a generic
  terminal type but a more dumb one (bnc#859214)
* Mon Jan 20 2014 werner@suse.de
- Add ncurses patch 20140118
  + apply includesubdir variable which was introduced in 20130805 to
    gen-pkgconfig.in (Debian #735782).
- Correct spec file irarch to make S390(x) fallback terminal types
  working on S390(x) (bnc#859214)
* Tue Dec 17 2013 werner@suse.de
- Add ncurses patch 20131214
  + modify configure-script/ifdef's to allow OLD_TTY feature to be
    suppressed if the type of ospeed is configured using the option
  - -with-ospeed to not be a short.  By default, it is a short for
    termcap-compatibility (adapted from suggestion by Christian
    Weisgerber).
  + correct a typo in _nc_baudrate() (patch by Christian Weisgerber,
    cf: 20061230).
  + fix a few -Wlogical-op warnings.
  + updated llib-l* files.
* Tue Dec 10 2013 werner@suse.de
- Add ncurses patch 20131207
  + add form_driver_w() entrypoint to wide-character forms library,
    as well as test program form_driver_w (adapted from patch by
    Gaute Hope).
* Fri Nov 29 2013 werner@suse.de
- Add ncurses patch 20131123
  + minor fix for CF_GCC_WARNINGS to special-case options which are not
  recognized by clang.
- Add ncurses patch 20131116
  + add special case to configure script to move _XOPEN_SOURCE_EXTENDED
    definition from CPPFLAGS to CFLAGS if it happens to be needed for
    Solaris, because g++ errors with that definition (report by
    Jean-Pierre Flori, Sage #15268).
  + correct logic in infocmp's -i option which was intended to ignore
    strings which correspond to function-keys as candidates for piecing
    together initialization- or reset-strings.  The problem dates to
    1.9.7a, but was overlooked until changes in -Wlogical-op warnings for
    gcc 4.8 (report by David Binderman).
  + updated CF_GCC_WARNINGS to documented options for gcc 4.9.0, adding
    checks for -Wextra, -Wignored-qualifiers and -Wlogical-op
  + updated CF_GCC_WARNINGS to documented options for gcc 4.9.0, moving
    checks for -Wextra and -Wdeclaration-after-statement into the macro,
    and adding checks for -Wignored-qualifiers, -Wlogical-op and -Wvarargs
  + updated CF_CURSES_UNCTRL_H and CF_SHARED_OPTS macros from ongoing
    work on cdk.
- Add ncurses patch 20131110
  + minor cleanup of terminfo.tail
* Fri Nov 29 2013 werner@suse.de
- On S390(x) use other fallback terminal types, that is have the
  ibm327x and vt220 available even if no terminfo-base is installed.
* Wed Nov  6 2013 werner@suse.de
- Add ncurses patch 20131102
  + use TS extension to describe xterm's title-escapes -TD
  + modify terminator and nsterm-s to use xterm+sl-twm building block -TD
  + simplify pfkey expression in ansi.sys -TD
* Tue Oct 29 2013 werner@suse.de
- Make it build even with new tar command
- Add ncurses patch 20131027
  + correct/simplify ifdef's for cur_term versus broken-linker and
    reentrant options (report by Jean-Pierre Flori, cf: 20090530).
  + modify release/version combinations in test build-scripts to make
    them more consistent with other packages.
- Add ncurses patch 20131019
  + add nc_mingw.h to installed headers for MinGW port; needed for
    compiling ncurses-examples.
  + add rpm-script for testing cross-compile of ncurses-examples.
- Add ncurses patch 20131014
  + fix new typo in CF_ADA_INCLUDE_DIRS macro (report by Roumen Petrov).
- Add ncurses patch 20131012
  + fix a few compiler warnings in progs and test.
  + minor fix to package/debian-mingw/rules, do not strip dll's.
  + minor fixes to configure script for empty $prefix, e.g., when doing
    cross-compiles to MinGW.
  + add script for building test-packages of binaries cross-compiled to
    MinGW using NSIS.
- Add ncurses patch 20131005
  + minor fixes for ncurses-example package and makefile.
  + add scripts for test-builds of cross-compiler packages for ncurses6
    to MinGW.
- Add ncurses patch 20130928
  + some build-fixes for ncurses-examples with NetBSD-6.0 curses, though
    it lacks some common functions such as use_env() which is not yet
    addressed.
  + build-fix and some compiler warning fixes for ncurses-examples with
    OpenBSD 5.3
  + fix a possible null-pointer reference in a trace message from newterm.
  + quiet a few warnings from NetBSD 6.0 namespace pollution by
    nonstandard popcount() function in standard strings.h header.
  + ignore g++ 4.2.1 warnings for "-Weffc++" in c++/cursesmain.cc
  + fix a few overlooked places for --enable-string-hacks option.
* Mon Sep 30 2013 werner@suse.de
- Add ncurses patch 20130928
  + fix a possible null-pointer reference in a trace message from newterm.
  + ignore g++ 4.2.1 warnings for "-Weffc++" in c++/cursesmain.cc
  + fix a few overlooked places for --enable-string-hacks option.
- Add ncurses patch 20130921
  + fix typo in curs_attr.3x (patch by Sven Joachim, cf: 20130831).
  + build-fix for --with-shared option for DragonFly and FreeBSD (report
    by Rong-En Fan, cf: 20130727).
- Add ncurses patch 20130907
  + revert change to two of the dpkg format files, to work with dpkg
    before/after Debian #700177.
  + fix gcc -Wconversion warning in wattr_get() macro.
  + add msys and msysdll to known host/configuration types (patch by
    Alexey Pavlov).
  + modify CF_RPATH_HACK configure macro to not rely upon "-u" option
    of sort, improving portability.
- Add ncurses patch 20130831
  + modify test/ncurses.c b/B tests to display lines only for the
    attributes which a given terminal supports, to make room for an
    italics test.
  + completed ncv table in terminfo.tail; it did not list the wide
    character codes listed in X/Open Curses issue 7.
  + add A_ITALIC extension (prompted by discussion with Egmont Koblinger).
- Add ncurses patch 20130824
  + fix some gcc 4.8 -Wconversion warnings.
  + change format of dpkg test-scripts to quilted to work around bug
    introduced by Debian #700177.
  + discard cached keyname() values if meta() is changed after a value
    was cached using (report by Kurban Mallachiev).
- Add ncurses patch 20130816
  + add checks in tic to warn about terminals which lack cursor
    addressing, capabilities or having those, are marked as hard_copy or
    generic_type.
  + use --without-progs in mingw-ncurses rpm.
  + split out _nc_init_termtype() from alloc_entry.c to use in MinGW
    port when tic and other programs are not needed.
- Add ncurses patch 20130805
  + add --disable-db-install configure option, to simplify building
    cross-compile support packages.
* Mon Aug  5 2013 werner@suse.de
- Add ncurses patch 20130805
  + minor fixes to the --disable-overwrite logic, to ensure that the
    configured $(includedir) is not cancelled by the mingwxx-filesystem
    rpm macros.
  + add --disable-db-install configure option, to simplify building
    cross-compile support packages.
- Add ncurses patch 20130727
  + improve configure macros from ongoing work on cdk, dialog, xterm:
    + CF_ADD_LIB_AFTER - fix a problem with -Wl options
    + CF_RPATH_HACK - add missing result-message
    + CF_SHARED_OPTS - modify to use $rel_builddir in cygwin and mingw
    dll symbols (which can be overridden) rather than explicit "../".
    + CF_SHARED_OPTS - modify NetBSD and DragonFly symbols to use ${CC}
    rather than ${LD} to improve rpath support.
    + CF_SHARED_OPTS - add a symbol to denote the temporary files that
    are created by the macro, to simplify clean-rules.
    + CF_X_ATHENA - trim extra libraries to work with -Wl,--as-needed
  + fix a regression in hashed-database support for NetBSD, which uses
    the key-size differently from other implementations (cf: 20121229).
- Add ncurses patch 20130720
  + further improvements for setupterm manpage, clarifying the
    initialization of cur_term.
- Add ncurses patch 20130713
  + improve manpages for initscr and setupterm.
  + minor compiler-warning fixes
- Add ncurses patch 20130706
  + add fallback defs for <inttypes.h> and <stdint.h> (cf: 20120225).
  + add check for size of wchar_t, use that to suppress a chunk of
    wcwidth.h in MinGW port.
  + quiet linker warnings for MinGW cross-compile with dll's using the
  - -enable-auto-import flag.
  + add ncurses.map rule to ncurses/Makefile to help diagnose symbol
    table issues.
- Add ncurses patch 20130622
  + modify the clear program to take into account the E3 extended
    capability to clear the terminal's scrollback buffer (patch by
    Miroslav Lichvar, Redhat #815790).
  + clarify in resizeterm manpage that LINES and COLS are updated.
  + updated ansi example in terminfo.tail, correct misordered example
    of sgr.
  + fix other doclifter warnings for manpages
  + remove unnecessary ".ta" in terminfo.tail, add missing ".fi"
    (patch by Eric Raymond).
- Add ncurses patch 20130615
  + minor changes to some configure macros to make them more reusable.
  + fixes for tabs program (prompted by report by Nick Andrik):
    + corrected logic in command-line parsing of -a and -c predefined
    tab-lists options.
    + allow "-0" and "-8" options to be combined with others, e.g.,"-0d".
    + make warning messages more consistent with the other utilities by
    not printing the full pathname of the program.
    + add -V option for consistency with other utilities.
  + fix off-by-one in columns for tabs program when processing an option
    such as "-5" (patch by Nick Andrik).
- Add ncurses patch 20130608
  + add to test/demo_forms.c examples of using the menu-hooks as well
    as showing how the menu item user-data can be used to pass a callback
    function pointer.
  + add test/dots_termcap.c
  + remove setupterm call from test/demo_termcap.c
  + build-fix if --disable-ext-funcs configure option is used.
  + modified test/edit_field.c and test/demo_forms.c to move the lengths
    into a user-data structure, keeping the original string for later
    expansion to free-format input/out demo.
  + modified test/demo_forms.c to load data from file.
  + added note to clarify Terminal.app's non-emulation of the various
    terminal types listed in the preferences dialog -TD
  + fix regression in error-reporting in lib_setup.c (Debian #711134,
    cf: 20121117).
  + build-fix for a case where --enable-broken_linker and
  - -enable-reentrant options are combined (report by George R Goffe).
- Add ncurses patch 20130525
  + modify mvcur() to distinguish between internal use by the ncurses
    library, and external callers, preventing it from reading the content
    of the screen which is only nonblank when curses calls have updated
    it.  This makes test/dots_mvcur.c avoid painting colored cells in
    the left margin of the display.
  + minor fix to test/dots_mvcur.c
  + move configured symbols USE_DATABASE and USE_TERMCAP to term.h as
    NCURSES_USE_DATABASE and NCURSES_USE_TERMCAP to allow consistent
    use of these symbols in term_entry.h
- Add ncurses patch 20130518
  + corrected ifdefs in test/testcurs.c to allow comparison of mouse
    interface versus pdcurses (cf: 20130316).
  + add pow() to configure-check for math library, needed since
    20121208 for test/hanoi (Debian #708056).
  + regenerated html manpages.
  + update doctype used for html documentation.
* Fri Jun 21 2013 werner@suse.de
- Add some more terminfo entries to terminfo-base (bnc#826171)
* Mon May 13 2013 werner@suse.de
- Make LD_LIBRARY_PATH include %%_lib to make sure use and test the
  fresh build libraries
* Mon May 13 2013 werner@suse.de
- Add ncurses patch 20130511
  + move nsterm-related entries out of "obsolete" section to more
    plausible "ansi consoles" -TD
  + additional cleanup of table-of-contents by reordering -TD
  + revise fix for check for 8-bit value in _nc_insert_ch(); prior fix
    prevented inserts when video attributes were attached to the data
    (cf: 20121215) (Redhat #959534).
- Add ncurses patch 20130504
  + fixes for issues found by Coverity:
    + correct FNKEY() macro in progs/dump_entry.c, allowing kf11-kf63 to
    display when infocmp's -R option is used for HP or AIX subsets.
    + fix dead-code issue with test/movewindow.c
    + improve limited-checking in _nc_read_termtype().
- Add ncurses patch 20130427
  + fix clang 3.2 warning in progs/dump_entry.c
  + drop AC_TYPE_SIGNAL check; ncurses relies on c89 and later.
- Add ncurses patch 20130413
  + add MinGW to cases where ncurses installs by default into /usr
    (prompted by discussion with Daniel Silva Ferreira).
  + add -D option to infocmp's usage-message (patch by Miroslav Lichvar).
  + add a missing 'int' type for main function in configure check for
    type of bool variable, to work with clang 3.2 (report by Dmitri
    Gribenko).
  + improve configure check for static_cast, to work with clang 3.2
    (report by Dmitri Gribenko).
  + re-order rule for demo.o and macros defining header dependencies in
    c++/Makefile.in to accommodate gmake (report by Dmitri Gribenko).
- Add ncurses patch 20130406
  + improve parameter checking in copywin().
  + modify configure script to work around OS X's "libtool" program, to
    choose glibtool instead.  At the same time, chance the autoconf macro
    to look for a "tool" rather than a "prog", to help with potential use
    in cross-compiling.
  + separate the rpath usage for c++ library from demo program
    (Redhat #911540)
  + update/correct header-dependencies in c++ makefile (report by Werner
    Fink).
  + add --with-cxx-shared to dpkg-script, as done for rpm-script.
* Tue Mar 26 2013 werner@suse.de
- Add ncurses patch 20130324
  + build-fix for libtool configuration (reports by Daniel Silva Ferreira
    and Roumen Petrov).
- Add ncurses patch 20130323
  + build-fix for OS X, to handle changes for --with-cxx-shared feature
    (report by Christian Ebert).
  + change initialization for vt220, similar entries for consistency
    with cursor-key strings (NetBSD #47674) -TD
  + further improvements to linux-16color (Benjamin Sittler)
- Add ncurses patch 20130316
  + additional fix for tic.c, to allocate missing buffer space.
  + eliminate configure-script warnings for gen-pkgconfig.in
  + correct typo in sgr string for sun-color,
    add bold for consistency with sgr,
    change smso for consistency with sgr -TD
  + correct typo in sgr string for terminator -TD
  + add blink to the attributes masked by ncv in linux-16color (report
    by Benjamin Sittler)
  + improve warning message from post-load checking for missing "%%?"
    operator by tic/infocmp by showing the entry name and capability.
  + minor formatting improvement to tic/infocmp -f option to ensure
    line split after "%%;".
  + amend scripting for --with-cxx-shared option to handle the debug
    library "libncurses++_g.a" (report by Sven Joachim).
- Add ncurses patch 20130309
  + amend change to toe.c for reading from /dev/zero, to ensure that
    there is a buffer for the temporary filename (cf: 20120324).
  + regenerated html manpages.
  + fix typo in terminfo.head (report by Sven Joachim, cf: 20130302).
  + updated some autoconf macros:
    + CF_ACVERSION_CHECK, from byacc 1.9 20130304
    + CF_INTEL_COMPILER, CF_XOPEN_SOURCE from luit 2.0-20130217
  + add configure option --with-cxx-shared to permit building
    libncurses++ as a shared library when using g++, e.g., the same
    limitations as libtool but better integrated with the usual build
    configuration (Redhat 911540).
  + modify MKkey_defs.sh to filter out build-path which was unnecessarily
    shown in curses.h (Debian #689131).
- Add ncurses patch 20130302
  + add section to terminfo manpage discussing user-defined capabilities.
  + update manpage description of NCURSES_NO_SETBUF, explaining why it
    is obsolete.
  + add a check in waddch_nosync() to ensure that tab characters are
    treated as control characters; some broken locales claim they are
    printable.
  + add some traces to the Windows console driver.
  + initialize a temporary array in _nc_mbtowc, needed for some cases
    of raw input in MinGW port.
- Make it build even with shared libncurses++ and its demo test program
* Mon Feb 18 2013 werner@suse.de
- Add ncurses patch 20130126
  + further fixes to mvcur to pass callback function (cf: 20130112),
    needed to make test/dots_mvcur work.
  + reduce calls to SetConsoleActiveScreenBuffer in win_driver.c, to
    help reduce flicker.
  + modify configure script to omit "+b" from linker options for very
    old HP-UX systems (report by Dennis Grevenstein)
  + add HP-UX workaround for missing EILSEQ on old HP-UX systems (patch
    by Dennis Grevenstein).
  + restore memmove/strdup support for antique systems (request by
    Dennis Grevenstein).
  + change %%l behavior in tparm to push the string length onto the stack
    rather than saving the formatted length into the output buffer
    (report by Roy Marples, cf: 980620).
- Add ncurses patch 20130202
  + correct initialization in knight.c which let it occasionally make
    an incorrect move (cf: 20001028).
  + improve documentation of the terminfo/termcap search path.
- Add ncurses patch 20130209
  + modify test/configure script to make it simpler to override names
    of curses-related libraries, to help with linking with pdcurses in
    mingw environment.
  + if the --with-terminfo-dirs configure option is not used, there is
    no corresponding compiled-in value for that.  Fill in "no default
    value" for that part of the manpage substitution.
- Add ncurses patch 20130216
  + modify test/testcurs.c to work with mouse for ncurses as it does for
    pdcurses.
  + modify test/knight.c to work with mouse for pdcurses as it does for
    ncurses.
  + modify internal recursion in wgetch() which handles cooked mode to
    check if the call to wgetnstr() returned an error.  This can happen
    when both nocbreak() and nodelay() are set, for instance (report by
    Nils Christopher Brause) (cf: 960418).
  + fixes for issues found by Coverity:
    + add a check for valid position in ClearToEOS()
    + fix in lib_twait.c when --enable-wgetch-events is used, pointer
    use after free.
    + improve a limit-check in make_hash.c
    + fix a memory leak in hashed_db.c
- Add ncurses patch 20130218
  + correct ifdef on change to lib_twait.c (report by  Werner Fink).
  + update config.guess, config.sub
- Use screen to emulate a terminal to enable the configure script to
  use poll(2) system call on stderr file descriptor
* Mon Jan 21 2013 werner@suse.de
- Add ncurses patch 5.9.20130119
  + fixes for issues found by Coverity:
    + fix memory leak in safe_sprintf.c
    + add check for return-value in tty_update.c
    + correct initialization for -s option in test/view.c
    + add check for numeric overflow in lib_instr.c
    + improve error-checking in copywin
  + add advice in infocmp manpage for termcap users (Debian #698469).
  + add "-y" option to test/demo_termcap and test/demo_terminfo to
    demonstrate behavior with/without extended capabilities.
  + updated termcap manpage to document legacy termcap behavior for
    matching capability names.
  + modify name-comparison for tgetstr, etc., to accommodate legacy
    applications as well as to improve compatbility with BSD 4.2
    termcap implementations (Debian #698299) (cf: 980725).
* Wed Jan 16 2013 werner@suse.de
- Add ncurses patch 5.9.20130112
  + correct prototype in manpage for vid_puts.
  + drop ncurses/tty/tty_display.h, ncurses/tty/tty_input.h, since they
    are unused in the current driver model.
  + modify mvcur to use stdout except when called within the ncurses
    library.
  + modify vidattr and vid_attr to use stdout as documented in manpage.
  + amend changes made to buffering in 20120825 so that the low-level
    putp() call uses stdout rather than ncurses' internal buffering.
    The putp_sp() call does the same, for consistency (Redhat #892674).
- Add ncurses patch 5.9.20130105
  + add "-s" option to test/view.c to allow it to start in single-step
    mode, reducing size of trace files when it is used for debugging
    MinGW changes.
  + revert part of 20121222 change to tinfo_driver.c
  + add experimental logic in win_driver.c to improve optimization of
    screen updates.  This does not yet work with double-width characters,
    so it is ifdef'd out for the moment (prompted by report by Erwin
    Waterlander regarding screen flicker).
- Add ncurses patch 5.9.20121229
  + fix coverity warnings regarding copying into fixed-size buffers.
  + add throw-declarations in the c++ binding per Coverity warning.
  + minor changes to new-items for consistent reference to bug-report
    numbers.
- Add ncurses patch 5.9.20121222
  + add *.dSYM directories to clean-rule in ncurses directory makefile,
    for Mac OS builds.
  + add a configure check for gcc option -no-cpp-precomp, which is not
    available in all Mac OS X configurations (report by Andras Salamon,
    cf: 20011208).
  + improve 20021221 workaround for broken acs, handling a case where
    that ACS_xxx character is not in the acsc string but there is a known
    wide-character which can be used.
* Mon Dec 17 2012 werner@suse.de
- Add ncurses patch 5.9.20121215
  + fix several warnings from clang 3.1 --analyze, includes correcting
    a null-pointer check in _nc_mvcur_resume.
  + correct display of double-width characters with MinGW port (report
    by Erwin Waterlander).
  + replace MinGW's wcrtomb(), fixing a problem with _nc_viscbuf
  + correct check for 8-bit value in _nc_insert_ch().
  + remove dead code in progs/tset.c, test/linedata.h
  + add null-pointer checks in lib_tracemse.c, panel.priv.h, and some
    test-programs.
- Add ncurses patch 5.9.20121208
  + modify test/knight.c to show the number of choices possible for
    each position in automove option, e.g., to allow user to follow
    Warnsdorff's rule to solve the puzzle.
  + remove a few redundant checks.
  + check return value from remove/unlink in tic.
  + fix a null dereference in c++/cursesw.cc
  + fix two instances of uninitialized variables when configuring for the
    terminal driver.
  + correct scope of variable used in SetSafeOutcWrapper macro.
  + set umask when calling mkstemp in tic.
  + initialize wbkgrndset() temporary variable when extended-colors are
    used.
- Add ncurses patch 5.9.20121201
  + also replace MinGW's wctomb(), fixing a problem with setcchar().
- Add ncurses patch 5.9.20121124
  + correct order of color initialization versus display in some of the
    test-programs, e.g., test_addstr.c
- Add tack patch 1.07.20120916
  * tack.c: ensure that $TERM is set and is not too large
  * edit.c: build-fix for g++
  * color.c:
    corrected check for ncv (no_color_video), which did not handle
    the case when all video attributes should work.
  * color.c:
    add/use init_palette() and reset_palette() to restore the 0-7
    ANSI colors to sane values after running the change-colors tests.
  * charset.c: add a test for "eslok" capability
* Mon Nov 19 2012 werner@suse.de
- Add ncurses patch 5.9.20121117
  > fixes based on Coverity report:
  + add missing braces around FreeAndNull in two places.
  + various fixes in test/ncurses.c
  + improve limit-checks in tinfo/make_hash.c, tinfo/read_entry.c
  + correct malloc size in progs/infocmp.c
  + guard against negative array indices in test/knight.c
  + fix off-by-one limit check in test/color_name.h
  + add null-pointer check in progs/tabs.c, test/bs.c, test/demo_forms.c,
    test/inchs.c
  + fix memory-leak in tinfo/lib_setup.c, progs/toe.c,
    test/clip_printw.c, test/demo_menus.c
  + delete unused windows in test/chgat.c, test/clip_printw.c,
    test/insdelln.c, test/newdemo.c on error-return.
- Add ncurses patch 5.9.20121110
  + modify configure macro CF_INCLUDE_DIRS to put $CPPFLAGS after the
    local -I include options in case someone has set conflicting -I
    options in $CPPFLAGS (prompted by patch for ncurses/Makefile.in by
    Vassili Courzakis).
  + modify the ncurses*-config scripts to eliminate relative paths from
    the RPATH_LIST variable, e.g., "../lib" as used in installing shared
    libraries or executables.
* Mon Nov  5 2012 werner@suse.de
- Add ncurses patch 5.9.20121026
  + improve malloc/realloc checking (prompted by discussion in Redhat
    [#866989]).
  + add ncurses test-program as "ncurses6" to the rpm- and dpkg-scripts.
  + updated configure macros CF_GCC_VERSION and CF_WITH_PATHLIST.  The
    first corrects pattern used for Mac OS X's customization of gcc.
- Add ncurses patch 5.9.20121102
  + realign manual pages and fix a long-ago error in curs_addstr.3x
    which said that a -1 length parameter would only write as much
    as fit onto one line (report by Reuben Thomas).
  + remove obsolete fallback _nc_memmove() for memmove()/bcopy().
  + remove obsolete fallback _nc_strdup() for strdup().
  + cancel any debug-rpm in package/ncurses.spec
  + reviewed vte-2012, reverted most of the change since it was incorrect
    based on testing with tack -TD
  + un-cancel the initc in vte-256color, since this was implemented
    starting with version 0.20 in 2009 -TD
* Wed Oct 17 2012 werner@suse.de
- Add ncurses patch 5.9.20121013
  + add vte-2012, gnome-2012, making these the defaults for vte/gnome
- Add ncurses patch 5.9.20121017
  + fix change to _nc_scroll_optimize(), which incorrectly freed memory
* Mon Oct  8 2012 werner@suse.de
- Add ncurses patch 5.9.20121006
  + improve CF_GCC_VERSION to work around Debian's customization of gcc
  - -version message.
  + improve configure macros as done in byacc:
    + drop 2.13 compatibility; use 2.52.xxxx version only since EMX port
    has used that for a while.
    + add 3rd parameter to AC_DEFINE's to allow autoheader to run, i.e.,
    for experimental use.
    + remove unused configure macros.
  + modify configure script and makefiles to quiet new autoconf warning
    for LIBS_TO_MAKE variable.
  + modify configure script to show $PATH_SEPARATOR variable.
  + update config.guess, config.sub
- Add ncurses patch 5.9.20120922
  + modify setupterm to set its copy of TERM to "unknown" if configured
    for the terminal driver and TERM was null or empty.
  + modify treatment of TERM variable for MinGW port to allow explicit
    use of the windows console driver by checking if $TERM is set to
    "#win32con" or an abbreviation of that.
  + undo recent change to fallback definition of vsscanf() to
* Mon Sep 17 2012 werner@suse.de
- Add ncurses patch 5.9.20120908
  + add test-screens to test/ncurses to show 256-characters at a time,
    to help with mingw port.
- Add ncurses patch 5.9.20120903
  + simplify varargs logic in lib_printw.c; va_copy is no longer needed
    there.
  + modifications for mingw port to make wide-character display usable.
- Add ncurses patch 5.9.20120902
  + regenerate configure script (report by Sven Joachim, cf: 20120901).
- Add ncurses patch 5.9.20120901
  + add a null-pointer check in _nc_flush (cf: 20120825).
  + fix a case in _nc_scroll_optimize() where the _oldnums_list array
    might not be allocated.
  + improve comparisons in configure.in for unset shell variables.
- Add ncurses patch 5.9.20120826
  + increase size of ncurses' output-buffer, in case of very small
    initial screen-sizes.
  + fix evaluation of TERMINFO and TERMINFO_DIRS default values as needed
    after changes to use --datarootdir (reports by Gabriele Balducci,
    Roumen Petrov).
- Add ncurses patch 5.9.20120825
  + change output buffering scheme, using buffer maintained by ncurses
    rather than stdio, to avoid problems with SIGTSTP handling (report
    by Brian Bloniarz).
- Add ncurses patch 5.9.20120811
  + update autoconf patch to 2.52.20120811, adding --datarootdir
    (prompted by discussion with Erwin Waterlander).
  + improve description of --enable-reentrant option in README and the
    INSTALL file.
  + add nsterm-256color, make this the default nsterm -TD
  + remove bw from nsterm-bce, per testing with tack -TD
- Add ncurses patch 5.9.20120804
  + update test/configure, adding check for tinfo library.
  + improve limit-checks for the getch fifo (report by Werner Fink).
  + fix a remaining mismatch between $with_echo and the symbols updated
    by CF_DISABLE_ECHO affecting parameters for mk-2nd.awk (report by
    Sven Joachim, cf:  20120317).
  + modify followup check for pkg-config's library directory in the
  - -enable-pc-files option to validate syntax (report by Sven Joachim,
    cf: 20110716).
* Tue Jul 31 2012 werner@suse.de
- Add ncurses patch 5.9.20120728
  + correct path for ncurses_mingw.h in include/headers, in case build
    is done outside source-tree (patch by Roumen Petrov).
  + modify some older xterm entries to align with xterm source -TD
  + separate "xterm-old" alias from "xterm-r6" -TD
  + add E3 extended capability to xterm-basic and putty -TD
  + parenthesize parameters of other macros in curses.h -TD
  + parenthesize parameter of COLOR_PAIR and PAIR_NUMBER in curses.h
  in case it happens to be a comma-expression, etc. (patch by Nick
  Black).
- Add ncurses patch 5.9.20120721
  + improved form_request_by_name() and menu_request_by_name().
  + eliminate two fixed-size buffers in toe.c
  + extend use_tioctl() to have expected behavior when use_env(FALSE) and
    use_tioctl(TRUE) are called.
  + modify ncurses test-program, adding -E and -T options to demonstrate
    use_env() versus use_tioctl().
- Add NEWS and README to installed package documentation ((bnc#772916)
* Thu Jul 26 2012 werner@suse.de
- Change order of listes authors into the order of relative
  contributions made (bnc#772916)
- Add tabs description to description of ncurses-utils (bnc#772916)
* Fri Jul 20 2012 werner@suse.de
- Add ncurses patch 5.9.20120714 (bnc#769788)
  + add use_tioctl() function (adapted from patch by Werner Fink,
  Novell #769788):
- Set the default for use_tioctl() to TRUE and add a note in the
  manual page for this.
* Mon Jul  9 2012 werner@suse.de
- Add ncurses patch 5.9.20120707 (bnc#769788)
  + add ncurses_mingw.h to installed headers (prompted by patch by
    Juergen Pfeifer).
  + clarify return-codes from wgetch() in response to SIGWINCH (prompted
    by Novell #769788).
  + modify resizeterm() to always push a KEY_RESIZE onto the fifo, even
    if screensize is unchanged.  Modify _nc_update_screensize() to push a
    KEY_RESIZE if there was a SIGWINCH, even if it does not call
    resizeterm().  These changes eliminate the case where a SIGWINCH is
    received, but ERR returned from wgetch or wgetnstr because the screen
    dimensions did not change (Novell #769788).
* Tue Jun 26 2012 werner@suse.de
- Add ncurses patch 5.9.20120622
  + add -d, -e and -q options to test/demo_terminfo and test/demo_termcap
  + fix caching of environment variables in database-iterator (patch by
    Philippe Troin, Redhat #831366).
- Add ncurses patch 5.9.20120616
  + add configure check to distinguish clang from gcc to eliminate
    warnings about unused command-line parameters when compiler warnings
    are enabled.
  + improve behavior when updating terminfo entries which are hardlinked
    by allowing for the possibility that an alias has been repurposed to
    a new primary name.
  + fix some strict compiler warnings based on package scripts.
  + further fixes for configure check for working poll (Debian #676461).
- Add ncurses patch 5.9.20120608
  + fix an uninitialized variable in -c/-n logic for infocmp changes
    (cf: 20120526).
- Add ncurses patch 5.9.20120602
  + add kdch1 aka "Remove" to vt220 and vt220-8 entries -TD
  + add kdch1, etc., to qvt108 -TD
  + add dl1/il1 to some entries based on dl/il values -TD
  + add dl to simpleterm -TD
  + add consistency-checks in tic for insert-line vs delete-line
    controls, and insert/delete-char keys
  + correct no-leaks logic in infocmp when doing comparisons, fixing
    duplicate free of entries given via the command-line, and freeing
    entries loaded from the last-but-one of files specified on the
    command-line.
  + add kdch1 to wsvt25 entry from NetBSD CVS (reported by David Lord,
    analysis by Martin Husemann).
  + add cnorm/civis to wsvt25 entry from NetBSD CVS (report/analysis by
    Onno van der Linden).
* Wed May 30 2012 werner@suse.de
- Add ncurses patch 5.9.20120526
  + extend -c and -n options of infocmp to allow comparing more than two
    entries.
  + correct check in infocmp for number of terminal names when more than
    two are given.
  + correct typo in curs_threads.3x (report by Yanhui Shen on
    freebsd-hackers mailing list).
- Add ncurses patch 5.9.20120512
  + corrected 'op' for bterm (report by Samuel Thibault) -TD
  + modify test/background.c to demonstrate a background character
    holding a colored ACS_HLINE.  The behavior differs from SVr4 due to
    the thick- and double-line extension (cf: 20091003).
  + modify handling of acs characters in PutAttrChar to avoid mapping an
    unmapped character to a space with A_ALTCHARSET set.
  + rewrite vt520 entry based on vt420 -TD
- Add ncurses patch 5.9.20120505
  + remove p6 (bold) from opus3n1+ for consistency -TD
  + remove acs stuff from env230 per clues in Ingres termcap -TD
  + modify env230 sgr/sgr0 to match other capabilities -TD
  + modify smacs/rmacs in bq300-8 to match sgr/sgr0 -TD
  + make sgr for dku7202 agree with other caps -TD
  + make sgr for ibmpc agree with other caps -TD
  + make sgr for tek4107 agree with other caps -TD
  + make sgr for ndr9500 agree with other caps -TD
  + make sgr for sco-ansi agree with other caps -TD
  + make sgr for d410 agree with other caps -TD
  + make sgr for d210 agree with other caps -TD
  + make sgr for d470c, d470c-7b agree with other caps -TD
  + remove redundant AC_DEFINE for NDEBUG versus Makefile definition.
  + fix a back-link in _nc_delink_entry(), which is needed if ncurses is
    configured with --enable-termcap and --disable-getcap.
- Add ncurses patch 5.9.20120428
  + fix some inconsistencies between vt320/vt420, e.g., cnorm/civis -TD
  + add eslok flag to dec+sl -TD
  + dec+sl applies to vt320 and up -TD
  + drop wsl width from xterm+sl -TD
  + reuse xterm+sl in putty and nsca-m -TD
  + add ansi+tabs to vt520 -TD
  + add ansi+enq to vt220-vt520 -TD
  + fix a compiler warning in example in ncurses-intro.doc (Paul Waring).
  + added paragraph in keyname manpage telling how extended capabilities
    are interpreted as key definitions.
  + modify tic's check of conflicting key definitions to include extended
    capability strings in addition to the existing check on predefined
    keys.
- Add ncurses patch 5.9.20120421
  + improve cleanup of temporary files in tic using atexit().
  + add msgr to vt420, similar DEC vtXXX entries -TD
  + add several missing vt420 capabilities from vt220 -TD
  + factor out ansi+pp from several entries -TD
  + change xterm+sl and xterm+sl-twm to include only the status-line
    capabilities and not "use=xterm", making them more generally useful
    as building-blocks -TD
  + add dec+sl building block, as example -TD
- Add ncurses patch 5.9.20120414
  + add consistency check in tic for screen's "XT" capability.
  + add section in terminfo.src summarizing the user-defined capabilities
    used in that file -TD
- Add ncurses patch 5.9.20120407
  + fix an inconsistency between tic/infocmp "-x" option; tic omits all
    non-standard capabilities, while infocmp was ignoring only the user
    definable capabilities.
  + improve special case in tic parsing of description to allow it to be
    followed by terminfo capabilities.  Previously the description had to
    be the last field on an input line to allow tic to distinguish
    between termcap and terminfo format while still allowing commas to be
    embedded in the description.
  + correct variable name in gen_edit.sh which broke configurability of
    the --with-xterm-kbs option.
  + revert 2011-07-16 change to "linux" alias, return to "linux2.2" -TD
  + further amend 20110910 change, providing for configure-script
    override of the "linux" terminfo entry to install and changing the
    default for that to "linux2.2" (Debian #665959).
- Add ncurses patch 5.9.20120331
  + update Ada95/configure to use CF_DISABLE_ECHO (cf: 20120317).
  + correct order of use-clauses in st-256color -TD
  + modify configure script to look for gnatgcc if the Ada95 binding
    is built, in preference to the default gcc/cc (suggested by
    Nicolas Boulenguez).
  + modify configure script to ensure that the same -On option used for
    the C compiler in CFLAGS is used for ADAFLAGS rather than simply
    using -O3 (suggested by Nicolas Boulenguez)
- Add ncurses patch 5.9.20120324
  + amend an old fix so that next_char() exits properly for empty files,
    e.g., from reading /dev/null (cf: 20080804).
  + modify tic so that it can read from the standard input, or from
    a character device.  Because tic uses seek's, this requires writing
    the data to a temporary file first (prompted by remark by Sven
    Joachim) (cf: 20000923).
- Add ncurses patch 5.9.20120317
  + correct a check made in lib_napms.c, so that terminfo applications
    can again use napms() (cf: 20110604).
  + add a note in tic.h regarding required casts for ABSENT_BOOLEAN
    (cf: 20040327).
  + correct scripting for --disable-echo option in test/configure.
  + amend check for missing c++ compiler to work when no error is
    reported, and no variables set (cf: 20021206).
  + add/use configure macro CF_DISABLE_ECHO.
* Mon Mar 12 2012 werner@suse.de
- Add check_build script to avoid to stumble on gcc exception 32
* Mon Mar 12 2012 werner@suse.de
- Add ncurses patch 5.9.20120310
  + fix some strict compiler warnings for abi6 and 64-bits.
  + use begin_va_copy/end_va_copy macros in lib_printw.c (cf: 20120303).
  + improve a limit-check in infocmp.c (Werner Fink)
* Mon Mar  5 2012 werner@suse.de
- Add tack patch 1.07.20120303
  + fix many compilerv warnings
  + update auto configure
  + update copyright date
  + Update configure-script and makefile template to work with this
    post-5.9 change, allowing build of tack within the ncurses
    source-tree 20110924.  The change is prompted by review of
    OpenSUSE package by Werner Fink, using a patch from the rpm
    source file: ncurses-5.9-tack-tinfo.dif (2011-11-18)
* Mon Mar  5 2012 werner@suse.de
- Add ncurses patch 5.9.20120303
  + minor tidying of terminfo.tail, clarify reason for limitation
    regarding mapping of \0 to \200
  + minor improvement to _nc_copy_termtype(), using memcpy to replace
    loops.
  + fix no-leaks checking in test/demo_termcap.c to account for multiple
    calls to setupterm().
  + modified the libgpm change to show previous load as a problem in the
    debug-trace.
  > merge some patches from OpenSUSE rpm (Werner Fink):
  + ncurses-5.7-printw.dif, fixes for varargs handling in lib_printw.c
  + ncurses-5.7-gpm.dif, do not dlopen libgpm if already loaded by
    runtime linker
  + ncurses-5.6-fallback.dif, do not free arrays and strings from static
    fallback entries
* Thu Mar  1 2012 werner@suse.de
- Add ncurses patch 5.9.20120228
  + fix breakage in tic/infocmp from 20120225 (report by Werner Fink).
* Mon Feb 27 2012 werner@suse.de
- Add ncurses patch 5.9.20120225
  + modify configure script to allow creating dll's for MinGW when
    cross-compiling.
  + add --enable-string-hacks option to control whether strlcat and
    strlcpy may be used.  The same issue applies to OpenBSD's warnings
    about snprintf, noting that this function is weakly standardized.
  + add configure checks for strlcat, strlcpy and snprintf, to help
    reduce bogus warnings with OpenBSD builds.
  + build-fix for OpenBSD 4.9 to supply consistent intptr_t declaration
    (cf:20111231)
  + update config.guess, config.sub
* Tue Feb 14 2012 werner@suse.de
- Add ncurses patch 5.9.20120211
  + make sgr for xterm-pcolor agree with other caps -TD
  + make sgr for att5425 agree with other caps -TD
  + make sgr for att630 agree with other caps -TD
  + make sgr for linux entries agree with other caps -TD
  + make sgr for tvi9065 agree with other caps -TD
  + make sgr for ncr260vt200an agree with other caps -TD
  + make sgr for ncr160vt100pp agree with other caps -TD
  + make sgr for ncr260vt300an agree with other caps -TD
  + make sgr for aaa-60-dec-rv, aaa+dec agree with other caps -TD
  + make sgr for cygwin, cygwinDBG agree with other caps -TD
  + add configure option --with-xterm-kbs to simplify configuration for
    Linux versus most other systems.
* Mon Feb  6 2012 werner@suse.de
- Add ncurses patch 5.9.20120204
  + improved tic -D option, avoid making target directory and provide
    better diagnostics.
* Mon Jan 30 2012 werner@suse.de
- Add ncurses patch 5.9.20120128
  + add mach-gnu (Debian #614316, patch by Samuel Thibault)
  + add mach-gnu-color, tweaks to mach-gnu terminfo -TD
  + make sgr for sun-color agree with smso -TD
  + make sgr for prism9 agree with other caps -TD
  + make sgr for icl6404 agree with other caps -TD
  + make sgr for ofcons agree with other caps -TD
  + make sgr for att5410v1, att4415, att620 agree with other caps -TD
  + make sgr for aaa-unk, aaa-rv agree with other caps -TD
  + make sgr for avt-ns agree with other caps -TD
  + amend fix intended to separate fixups for acsc to allow "tic -cv" to
    give verbose warnings (cf:  20110730).
  + modify misc/gen-edit.sh to make the location of the tabset directory
    consistent with misc/Makefile.in, i.., using ${datadir}/tabset
    (Debian #653435, patch by Sven Joachim).
- Add ncurses patch 5.9.20120121
  + add --with-lib-prefix option to allow configuring for old/new flavors
  of OS/2 EMX.
  + modify check for gnat version to allow for year, as used in FreeBSD
  port.
  + modify check_existence() in db_iterator.c to simply check if the
  path is a directory or file, according to the need.  Checking for
  directory size also gives no usable result with OS/2 (cf: 20120107).
  + support OS/2 kLIBC (patch by KO Myung-Han).
* Mon Jan 16 2012 werner@suse.de
- Add ncurses patch 5.9.20120114
  * several improvements to test/movewindow.c (prompted by discussion on
  Linux Mint forum):
- Add ncurses patch 5.9.20120107
  * various improvments for MinGW (Juergen Pfeifer):
- Add ncurses patch 5.9.20111231
  * modify toe's report when -a and -s options are combined, to add
  a column showing which entries belong to a given database.
  * add -s option to toe, to sort its output.
  * modify progs/toe.c, simplifying use of db-iterator results to use
  caching improvements from 20111001 and 20111126.
  * correct generation of pc-files when ticlib or termlib options are
  given to rename the corresponding tic- or tinfo-libraries (report
  by Sven Joachim).
- Add ncurses patch 5.9.20111224
  * document a portability issue with tput, i.e., that scripts which work
  with ncurses may fail in other implementations that do no parameter
  analysis.
  * add putty-sco entry -TD
- Add ncurses patch 5.9.20111217
  * review/fix places in manpages where --program-prefix configure option
  was not being used.
  * add -D option to infocmp, to show the database locations that it
  could use.
  * fix build for the special case where term-driver, ticlib and termlib
  are all enabled.  The terminal driver depends on a few features in
  the base ncurses library, so tic's dependencies include both ncurses
  and termlib.
  * fix build work for term-driver when --enable-wgetch-events option is
  enabled.
  * use <stdint.h> types to fix some questionable casts to void*.
- Add ncurses patch 5.9.20111210
  * modify configure script to check if thread library provides
  pthread_mutexattr_settype(), e.g., not provided by Solaris 2.6
  * modify configure script to suppress check to define _XOPEN_SOURCE
  for IRIX64, since its header files have a conflict versus
  _SGI_SOURCE.
  * modify configure script to add ".pc" files for tic- and
  tinfo-libraries, which were omitted in recent change (cf: 20111126).
  * fix inconsistent checks on $PKG_CONFIG variable in configure script.
* Tue Dec 20 2011 coolo@suse.com
- remove call to suse_update_config (very old work around)
* Mon Dec  5 2011 werner@suse.de
- Add ncurses patch 5.9.20111203
  * modify configure-check for etip.h dependencies, supplying a temporary
  copy of ncurses_dll.h since it is a generated file (prompted by
  Debian #646977).
  * modify CF_CPP_PARAM_INIT "main" function to work with current C++.
* Mon Nov 28 2011 werner@suse.de
- Add ncurses patch 5.9.20111126
  * correct database iterator's check for duplicate entries
  (cf: 20111001).
  * modify database iterator to ignore $TERMCAP when it is not an
  absolute pathname.
  * add -D option to tic, to show the database locations that it could
  use.
  * improve description of database locations in tic manpage.
  * modify the configure script to generate a list of the ".pc" files to
  generate, rather than deriving the list from the libraries which have
  been built (patch by Mike Frysinger).
  * use AC_CHECK_TOOLS in preference to AC_PATH_PROGS when searching for
  ncurses*-config, e.g., in Ada95/configure and test/configure (adapted
  from patch by Mike Frysinger).
* Thu Nov 24 2011 werner@suse.de
- Avoid linker script libterminfo.so as bash configure can not
  handle this
* Thu Nov 24 2011 werner@suse.de
- Use linker scripts to amke sure that libtinfo will be found
  even if -ltinfo is missed on the linker command line
* Tue Nov 22 2011 werner@suse.de
- Add ncurses patch 5.9.20111119
  * remove obsolete/conflicting fallback definition for _POSIX_SOURCE
  from curses.priv.h, fixing a regression with IRIX64 and Tru64
  (cf: 20110416)
  * modify _nc_tic_dir() to ensure that its return-value is nonnull,
  i.e., the database iterator was not initialized.  This case is needed
  to when tic is translating to termcap, rather than loading the
  database (cf:  20111001).
* Fri Nov 18 2011 werner@suse.de
- Update to tack 1.07-20110626
- Enlarge hash size for run time linker
- Enforce bind references to global function symbols to the
  definition within libncurses and libtinfo
* Thu Nov 17 2011 werner@suse.de
- Add ncurses patch 5.9.20111112
  * add pccon entries for OpenBSD console (Alexei Malinin).
  * build-fix for OpenBSD 4.9 with gcc 4.2.1, setting _XOPEN_SOURCE to
  600 to work around inconsistent ifdef'ing of wcstof between C and
  C++ header files.
  * modify capconvert script to accept more than exact match on "xterm",
  e.g., the "xterm-*" variants, to exclude from the conversion (patch
  by Robert Millan).
  * fix a typo misc/Makefile.in, used in uninstalling pc-files.
- Add ncurses patch 5.9.20111030
  * modify make_db_path() to allow creating "terminfo.db" in the same
  directory as an existing "terminfo" directory.  This fixes a case
  where switching between hashed/filesystem databases would cause the
  new hashed database to be installed in the next best location -
  root's home directory.
  * add variable cf_cv_prog_gnat_correct to those passed to
  config.status, fixing a problem with Ada95 builds (cf: 20111022).
  * change feature test from _XPG5 to _XOPEN_SOURCE in two places, to
  accommodate broken implementations for _XPG6.
  * eliminate usage of NULL symbol from etip.h, to reduce header
  interdependencies.
  * add configure check to decide when to add _XOPEN_SOURCE define to
  compiler options, i.e., for Solaris 10 and later (cf: 20100403).
  This is a workaround for gcc 4.6, which fails to build the c++
  binding if that symbol is defined by the application, due to
  incorrectly combining the corresponding feature test macros
  (report by Peter Kruse).
- Add ncurses patch 5.9.20111022
  * correct logic for discarding mouse events, retaining the partial
  events used to build up click, double-click, etc, until needed
  (cf: 20110917).
  * fix configure script to avoid creating unused Ada95 makefile when
  gnat does not work.
  * cleanup width-related gcc 3.4.3 warnings for 64-bit platform, for the
  internal functions of libncurses.  The external interface of courses
  uses bool, which still produces these warnings.
- Add ncurses patch 5.9.20111015
  * improve description of --disable-tic-depends option to make it
  clear that it may be useful whether or not the --with-termlib
  option is also given (report by Sven Joachim).
  * amend termcap equivalent for set_pglen_inch to use the X/Open
  "YI" rather than the obsolete Solaris 2.5 "sL" (cf: 990109).
  * improve manpage for tgetent differences from termcap library.
- Add ncurses patch 5.9.20111008
  * moved static data from db_iterator.c to lib_data.c
  * modify db_iterator.c for memory-leak checking, fix one leak.
  * modify misc/gen-pkgconfig.in to use Requires.private for the parts
  of ncurses rather than Requires, as well as Libs.private for the
  other library dependencies (prompted by Debian #644728).
- Add ncurses patch 5.9.20111001
  * modify tic "-K" option to only set the strict-flag rather than force
  source-output.  That allows the same flag to control the parser for
  input and output of termcap source.
  * modify _nc_getent() to ignore backslash at the end of a comment line,
  making it consistent with ncurses' parser.
  * restore a special-case check for directory needed to make termcap
  text files load as if they were databases (cf: 20110924).
  * modify tic's resolution/collision checking to attempt to remove the
  conflicting alias from the second entry in the pair, which is
  normally following in the source file.  Also improved the warning
  message to make it simpler to see which alias is the problem.
  * improve performance of the database iterator by caching search-list.
- Add ncurses patch 5.9.20110925
  * add a missing "else" in changes to _nc_read_tic_entry().
- Add ncurses patch 5.9.20110924
  * modify _nc_read_tic_entry() so that hashed-database is checked before
  filesystem.
  * updated CF_CURSES_LIBS check in test/configure script.
  * modify configure script and makefiles to split TIC_ARGS and
  TINFO_ARGS into pieces corresponding to LDFLAGS and LIBS variables,
  to help separate searches for tic- and tinfo-libraries (patch by Nick
  Alcock aka "Nix").
  * build-fix for lib_mouse.c changes (ch: 20110917).
- Add ncurses patch 5.9.20110917
  * fix compiler warning for clang 2.9
  * improve merging of mouse events (integrated patch by Damien
  Guibouret).
  * correct mask-check used in lib_mouse for wheel mouse buttons 4/5
  (patch by Damien Guibouret).
- Add ncurses patch 5.9.20110910
  * modify misc/gen_edit.sh to select a "linux" entry which works with
  the current kernel rather than assuming it is always "linux3.0"
  (cf: 20110716).
  * revert a change to getmouse() which had the undesirable side-effect
  of suppressing button-release events (report by Damien Guibouret,
  cf: 20100102).
  * add xterm+kbs fragment from xterm #272 -TD
  * add configure option --with-pkg-config-libdir to provide control over
  the actual directory into which pc-files are installed, do not use
  the pkg-config environment variables (discussion with Frederic L W
  Meunier).
  * add link to mailing-list archive in announce.html.in, as done in
  FAQ (prompted by question by Andrius Bentkus).
  * improve manpage install by adjusting the "#include" examples to
  show the ncurses-subdirectory used when --disable-overwrite option
  is used.
  * install an alias for "curses" to the ncurses manpage, tied to the
  - -with-curses-h configure option (suggested by Reuben Thomas).
- Add ncurses patch 5.9.20110903
  * propagate error-returns from wresize, i.e., the internal
  increase_size and decrease_size functions through resize_term (report
  by Tim van der Molen, cf:  20020713).
  * fix typo in tset manpage (patch by Sven Joachim).
- Add ncurses patch 5.9.20110820
  * add a check to ensure that termcap files which might have "^?" do
  not use the terminfo interpretation as "\177".
  * minor cleanup of X-terminal emulator section of terminfo.src -TD
  * add terminator entry -TD
  * add simpleterm entry -TD
  * improve wattr_get macros by ensuring that if the window pointer is
  null, then the attribute and color values returned will be zero
  (cf: 20110528).
- Add ncurses patch 5.9.20110813
  * add substitution for $RPATH_LIST to misc/ncurses-config.in
  * improve performance of tic with hashed-database by caching the
  database connection, using atexit() to cleanup.
  * modify treatment of 2-character aliases at the beginning of termcap
  entries so they are not counted in use-resolution, since these are
  guaranteed to be unique.  Also ignore these aliases when reporting
  the primary name of the entry (cf: 20040501)
  * double-check gn (generic) flag in terminal descriptions to
  accommodate old/buggy termcap databases which misused that feature.
  * minor fixes to _nc_tgetent(), ensure buffer is initialized even on
  error-return.
- Add ncurses patch 5.9.20110807
  * improve rpath fix from 20110730 by ensuring that the new $RPATH_LIST
  variable is defined in the makefiles which use it.
  * build-fix for DragonFlyBSD's pkgsrc in test/configure script.
  * build-fixes for NetBSD 5.1 with termcap support enabled.
  * corrected k9 in dg460-ansi, add other features based on manuals -TD
  * improve trimming of whitespace at the end of terminfo/termcap output
  from tic/infocmp.
  * when writing termcap source, ensure that colons in the description
  field are translated to a non-delimiter, i.e., "=".
  * add "-0" option to tic/infocmp, to make the termcap/terminfo source
  use a single line.
  * add a null-pointer check when handling the $CC variable.
- Add ncurses patch 5.9.20110730
  * modify configure script and makefiles in c++ and progs to allow the
  directory used for rpath option to be overridden, e.g., to work
  around updates to the variables used by tic during an install.
  * add -K option to tic/infocmp, to provide stricter BSD-compatibility
  for termcap output.
  * add _nc_strict_bsd variable in tic library which controls the
  "strict" BSD termcap compatibility from 20110723, plus these
  features:
  * allow escapes such as "\8" and "\9" when reading termcap
  * disallow "\a", "\e", "\l", "\s" and "\:" escapes when reading
    termcap files, passing through "a", "e", etc.
  * expand "\:" as "\072" on output.
  * modify _nc_get_token() to reset the token's string value in case
  there is a string-typed token lacking the "=" marker.
  * fix a few memory leaks in _nc_tgetent.
  * fix a few places where reading from a termcap file could refer to
  freed memory.
  * add an overflow check when converting terminfo/termcap numeric
  values, since terminfo stores those in a short, and they must be
  positive.
  * correct internal variables used for translating to termcap "%%>"
  feature, and translating from termcap %%B to terminfo, needed by
  tctest (cf: 19991211).
  * amend a minor fix to acsc when loading a termcap file to separate it
  from warnings needed for tic (cf: 20040710)
  * modify logic in _nc_read_entry() and _nc_read_tic_entry() to allow
  a termcap file to be handled via TERMINFO_DIRS.
  * modify _nc_infotocap() to include non-mandatory padding when
  translating to termcap.
  * modify _nc_read_termcap_entry(), passing a flag in the case where
  getcap is used, to reduce interactive warning messages.
- Add ncurses patch 5.9.20110723
  * add a check in start_color() to limit color-pairs to 256 when
  extended colors are not supported (patch by David Benjamin).
  * modify setcchar to omit no-longer-needed OR'ing of color pair in
  the SetAttr() macro (patch by David Benjamin).
  * add kich1 to sun terminfo entry (Yuri Pankov)
  * use bold rather than reverse for smso in sun-color terminfo entry
  (Yuri Pankov).
  * improve generation of termcap using tic/infocmp -C option, e.g.,
  to correspond with 4.2BSD (prompted by discussion with Yuri Pankov
  regarding Schilling's test program):
  * translate %%02 and %%03 to %%2 and %%3 respectively.
  * suppress string capabilities which use %%s, not supported by tgoto
  * use \040 rather than \s
  * expand null characters as \200 rather than \0
  * modify configure script to support shared libraries for DragonFlyBSD.
- Add ncurses patch 5.9.20110716
  * replace an assert() in _nc_Free_Argument() with a regular null
  pointer check (report/analysis by Franjo Ivancic).
  * modify configure --enable-pc-files option to take into account the
  PKG_CONFIG_PATH variable (report by Frederic L W Meunier).
  * add/use xterm+tmux chunk from xterm #271 -TD
  * resync xterm-new entry from xterm #271 -TD
  * add E3 extended capability to linux-basic (Miroslav Lichvar)
  * add linux2.2, linux2.6, linux3.0 entries to give context for E3 -TD
  * add SI/SO change to linux2.6 entry (Debian #515609) -TD
  * fix inconsistent tabset path in pcmw (Todd C. Miller).
  * remove a backslash which continued comment, obscuring altos3
  definition with OpenBSD toolset (Nicholas Marriott).
- Add ncurses patch 5.9.20110702
  * add workaround from xterm #271 changes to ensure that compiler flags
  are not used in the $CC variable.
  * improve support for shared libraries, tested with AIX 5.3, 6.1 and
  7.1 with both gcc 4.2.4 and cc.
  * modify configure checks for AIX to include release 7.x
  * add loader flags/libraries to libtool options so that dynamic loading
  works properly, adapted from ncurses-5.7-ldflags-with-libtool.patch
  at gentoo prefix repository (patch by Michael Haubenwallner).
- Add ncurses patch 5.9.20110626
  * move include of nc_termios.h out of term_entry.h, since the latter
  is installed, e.g., for tack while the former is not (report by
  Sven Joachim).
- Add ncurses patch 5.9.20110625
  * improve cleanup() function in lib_tstp.c, using _exit() rather than
  exit() and checking for SIGTERM rather than SIGQUIT (prompted by
  comments forwarded by Nicholas Marriott).
  * reduce name pollution from term.h, moving fallback #define's for
  tcgetattr(), etc., to new private header nc_termios.h (report by
  Sergio NNX).
  * two minor fixes for tracing (patch by Vassili Courzakis).
  * improve trace initialization by starting it in use_env() and
  ripoffline().
  * review old email, add details for some changelog entries.
- Add ncurses patch 5.9.20110611
  * update minix entry to minix 3.2 (Thomas Cort).
  * fix a strict compiler warning in change to wattr_get (cf: 20110528).
- Add ncurses patch 5.9.20110604
  * fixes for MirBSD port:
  * set default prefix to /usr.
  * add support for shared libraries in configure script.
  * use S_ISREG and S_ISDIR consistently, with fallback definitions.
  * add a few more checks based on ncurses/link_test.
  * modify MKlib_gen.sh to handle sp-funcs renaming of NCURSES_OUTC type.
- Add ncurses patch 5.9.20110528
  * add case to CF_SHARED_OPTS for Interix (patch by Markus Duft).
  * used ncurses/link_test to check for behavior when the terminal has
  not been initialized and when an application passes null pointers
  to the library.  Added checks to cover this (prompted by Redhat
  [#707344]).
  * modify MKlib_gen.sh to make its main() function call each function
  with zero parameters, to help find inconsistent checking for null
  pointers, etc.
- Add ncurses patch 5.9.20110521
  * fix warnings from clang 2.7 "--analyze"
- Add ncurses patch 5.9.20110514
  * compiler-warning fixes in panel and progs.
  * modify CF_PKG_CONFIG macro, from changes to tin -TD
  * modify CF_CURSES_FUNCS configure macro, used in test directory
  configure script:
  * work around (non-optimizer) bug in gcc 4.2.1 which caused
    test-expression to be omitted from executable.
  * force the linker to see a link-time expression of a symbol, to
    help work around weak-symbol issues.
- Add ncurses patch 5.9.20110507
  * update discussion of MKfallback.sh script in INSTALL; normally the
  script is used automatically via the configured makefiles.  However
  there are still occasions when it might be used directly by packagers
  (report by Gunter Schaffler).
  * modify misc/ncurses-config.in to omit the "-L" option from the
  "--libs" output if the library directory is /usr/lib.
  * change order of tests for curses.h versus ncurses.h headers in the
  configure scripts for Ada95 and test-directories, to look for
  ncurses.h, from fixes to tin -TD
  * modify ncurses/tinfo/access.c to account for Tandem's root uid
  (report by Joachim Schmitz).
- Add ncurses patch 5.9.20110430
  * modify rules in Ada95/src/Makefile.in to ensure that the PIC option
  is not used when building a static library (report by Nicolas
  Boulenguez):
  * Ada95 build-fix for big-endian architectures such as sparc.  This
  undoes one of the fixes from 20110319, which added an "Unused" member
  to representation clauses, replacing that with pragmas to suppress
  warnings about unused bits (patch by Nicolas Boulenguez):
- Add ncurses patch 5.9.20110423
  * add check in test/configure for use_window, use_screen.
  * add configure-checks for getopt's variables, which may be declared
  as different types on some Unix systems.
  * add check in test/configure for some legacy curses types of the
  function pointer passed to tputs().
  * modify init_pair() to accept -1's for color value after
  assume_default_colors() has been called (Debian #337905).
  * modify test/background.c, adding commmand-line options to demonstrate
  assume_default_colors() and use_default_colors().
- Add ncurses patch 5.9.20110416
  * modify configure script/source-code to only define _POSIX_SOURCE if
  the checks for sigaction and/or termios fail, and if _POSIX_C_SOURCE
  and _XOPEN_SOURCE are undefined (report by Valentin Ochs).
  * update config.guess, config.sub
- Add ncurses patch 5.9.20110409
  * fixes to build c++ binding with clang 3.0 (patch by Alexander
  Kolesen).
  * add check for unctrl.h in test/configure, to work around breakage in
  some ncurses packages.
  * add "--disable-widec" option to test/configure script.
  * add "--with-curses-colr" and "--with-curses-5lib" options to the
  test/configure script to address testing with very old machines.
* Thu Nov 17 2011 werner@suse.de
- Update to ncurses 5.9
  * various build-fixes for the rpm/dpkg scripts.
  * add "--enable-rpath-link" option to Ada95/configure, to allow
  packages to suppress the rpath feature which is normally used for
  the in-tree build of sample programs.
  * corrected definition of libdir variable in Ada95/src/Makefile.in,
  needed for rpm script.
  * add "--with-shared" option to Ada95/configure script, to allow
  making the C-language parts of the binding use appropriate compiler
  options if building a shared library with gnat.
  * portability fixes for Ada95 binding
  * update test/configure macros CF_CURSES_LIBS, CF_XOPEN_SOURCE and
  CF_X_ATHENA_LIBS.
  * add configure check to determine if gnat's project feature supports
  libraries, i.e., collections of .ali files.
  * make all dereferences in Ada95 samples explicit.
  * fix typo in comment in lib_add_wch.c (patch by Petr Pavlu).
  * add configure check for, ifdef's for math.h which is in a separate
  package on Solaris and potentially not installed (report by Petr
  Pavlu).
  * fixes for Ada95 binding
  * change order of -I options from ncurses*-config script when the
  - -disable-overwrite option was used, so that the subdirectory include
  is listed first.
  * modify the make-tar.sh scripts to add a MANIFEST and NEWS file.
  * modify configure script to provide value for HTML_DIR in
  Ada95/gen/Makefile.in, which depends on whether the Ada95 binding is
  distributed separately (report by Nicolas Boulenguez).
  * modify configure script to add -g and/or -O3 to ADAFLAGS if the
  CFLAGS for the build has these options.
  * amend change from 20070324, to not add 1 to the result of getmaxx
  and getmaxy in the Ada binding (report by Nicolas Boulenguez for
  thread in comp.lang.ada).
  * build-fix Ada95/samples for gnat 4.5
  * spelling fixes for Ada95/samples/explain.txt
  * fixes for Ada95 binding
* Wed Nov 16 2011 werner@suse.de
- Split libncurses(w) into libncurses(w)+libtinfo to be able to
  link python against wide libncursesw and libreadline which is
  linked with libtinfo only (bnc#729226)
* Fri Sep 30 2011 uli@suse.com
- cross-build fixes: use %%configure macro, use host's tic/tack
  for build, don't ldd tack
* Thu Sep 29 2011 dmueller@suse.de
- fix build under qemu for the ARM port
* Tue Mar  8 2011 werner@suse.de
- Add ncurses patch 5.8.20110307
  * revert changes to limit-checks from 20110122 (Debian #616711).
  * corrected a minor sign error in a field of Low_Level_Field_Type, to
  conform to form.h.
  * replaced C_Int by Curses_Bool as return type for some callbacks, see
  fieldtype(3FORM).
* Mon Mar  7 2011 werner@suse.de
- Add ncurses patch 5.8.20110305
  * fix an off-by-one error in _nc_slk_initialize() from 20100605 fixes
  for compiler warnings (report by Nicolas Boulenguez).
* Thu Mar  3 2011 werner@suse.de
- Update to ncurses 5.8
  * change open() in _nc_read_file_entry() to fopen() for consistency
  with write_file().
  * modify misc/run_tic.in to create parent directory, in case this is
  a new install of hashed database.
  * add cons25-debian entry (patch by Brian M Carlson, Debian #607662).
  * add xterm-utf8 entry as a demo of the U8 feature -TD
  * add U8 feature to denote entries for terminal emulators which do not
  support VT100 SI/SO when processing UTF-8 encoding -TD
  * improve the NCURSES_NO_UTF8_ACS feature by adding a check for an
  extended terminfo capability U8 (prompted by mailing list
  discussion).
  * correct limit-checks in derwin().
  * fix a missing "weak" declaration for pthread_kill (patch by Nicholas Alcock).
  * improve documentation of KEY_ENTER in curs_getch.3x manpage (prompted
  by discussion with Kevin Martin).
  * document thick- and double-line symbols in curs_add_wch.3x manpage.
  * document WACS_xxx constants in curs_add_wch.3x manpage.
  * fix typo in man/default_colors.3x (patch by Tim van der Molen).
  * fix remaining strict compiler warnings in ncurses library ABI=5,
  except those dealing with function pointers, etc.
  * modify nc_tparm.h, adding guards against repeated inclusion, and
  allowing TPARM_ARG to be overridden.
  * suppress ncv in screen entry, allowing underline (patch by Alejandro R Sedeno).
  * also suppress ncv in konsole-base -TD
  * fixes in wins_nwstr() and related functions to ensure that special
  characters, i.e., control characters are handled properly with the
  wide-character configuration.
  * correct a comparison in wins_nwstr() (Redhat #661506).
  * correct help-messages in some of the test-programs, which still
  referred to quitting with 'q'.
  * add special case to _nc_infotocap() to recognize the setaf/setab
  strings from xterm+256color and xterm+88color, and provide a reduced
  version which works with termcap.
  * fix typo in rmso for tek4106 entry -Goran Weinholt
  * repurpose "gnome" terminfo entries as "vte", retaining "gnome" items
  for compatibility, but generally deprecating those since the VTE
  library is what actually defines the behavior of "gnome", etc.,
  since 2003 -TD
  * correct parsing of relative tab-stops in tabs program (report by
  Philip Ganchev).
  * adjust configure script so that "t" is not added to library suffix
  when weak-symbols are used, allowing the pthread configuration to
  more closely match the non-thread naming (report by Werner Fink).
  * modify configure check for tic program, used for fallbacks, to a
  warning if not found.  This makes it simpler to use additonal
  scripts to bootstrap the fallbacks code using tic from the build
  tree (report by Werner Fink).
* Tue Dec 21 2010 werner@suse.de
- Change rxvt-unicode terminfo entry (Thanks darix)
* Tue Oct 12 2010 werner@suse.de
- Enforce the correct libraries for tic to generate the fallback.c
* Tue Oct 12 2010 werner@suse.de
- Avoid libncursest6 by re-enabling weak symbol for pthread_kill()
- Fix broken manual page terminfo(5) by disabling tbl during install
- Add ncurses*-config manual pages to file list of devel package
* Mon Oct 11 2010 werner@suse.de
- Update to test version 5.7.20101009 (bnc#644831 and bnc#540571)
  * correct comparison used for setting 16-colors in linux-16color
    entry (Novell #644831) -TD
  * improve linux-16color entry, using "dim" for color-8 which makes it
    gray rather than black like color-0 -TD
  * add checks in tic for inconsistent cursor-movement controls, and for
    inconsistent printer-controls.
  * fill in no-parameter forms of cursor-movement where a parameterized
    form is available -TD
  * fill in missing cursor controls where the form of the controls is
    ANSI -TD
  * fix inconsistent punctuation in form_variables manpage (patch by
    Sven Joachim).
  * add parameterized cursor-controls to linux-basic (report by Dae) -TD
  * add "XT" capability to entries for terminals that support both
    xterm-style mouse- and title-controls, for "screen" which
    special-cases TERM beginning with "xterm" or "rxvt" -TD
  * add configure check for pthread_kill(), needed for some old
    platforms.
  * modify nsterm, xnuppc and tek4115 to make sgr/sgr0 consistent -TD
  * add check in terminfo source-reader to provide more informative
    message when someone attempts to run tic on a compiled terminal
    description (prompted by Debian #593920).
  * note in infotocap and captoinfo manpages that they read terminal
    descriptions from text-files (Debian #593920).
  * improve acsc string for vt52, show arrow keys (patch by Benjamin
    Sittler).
  * correct a typo in mk-1st.awk (patch by Gabriele Balducci)
    (cf: 20100724)
  * document tabs "-0" and "-8" options in manpage.
  * add a check in tic for missing set_tab if clear_all_tabs given.
  * add mlterm+256color entry, for mlterm 3.0.0 -TD
  * fix configure script for combining --with-pthread
    and --enable-weak-symbols options.
  * add configure option --enable-pthreads-eintr to control whether the
    new EINTR feature is enabled.
  * modify logic in pthread configuration to allow EINTR to interrupt
    a read operation in wgetch() (Novell #540571, patch by Werner Fink).
  * modify _nc_capcmp() to work with cancelled strings.
  * correct translation of "^" in _nc_infotocap(), used to transform
    terminfo to termcap strings
  * simplify logic in _nc_get_screensize() to make it easier to see how
    environment variables may override system- and terminfo-values
    (prompted by discussion with Igor Bujna).
  * add check if Gpm_Open() returns a -2, e.g., for "xterm".  This is
    normally suppressed but can be overridden using $NCURSES_GPM_TERMS.
    Ensure that Gpm_Close() is called in this case.
  * use va_copy() in _nc_printf_string() to avoid conflicting use of
    va_list value in _nc_printf_length() (report by Wim Lewis).
  * add several screen-bce.XXX entries -TD
  * update mrxvt terminfo entry -TD
  * modify win_driver.c to support mouse single-clicks.
  * correct name for termlib in ncurses*-config, e.g., if it is renamed
    to provide a single file for ncurses/ncursesw libraries (patch by
    Miroslav Lichvar).
  * for term-driver configuration, ensure that the driver pointer is
    initialized in setupterm so that terminfo/termcap programs work.
  * amend fix for Debian #542031 to ensure that wattrset() returns only
    OK or ERR, rather than the attribute value (report by Miroslav
    Lichvar).
  * reorder WINDOWLIST to put WINDOW data after SCREEN pointer, making
    _nc_screen_of() compatible between normal/wide libraries again (patch
    by Miroslav Lichvar)
  * modify win_driver.c to initialize TERMINAL struct so that programs
    such as test/lrtest.c and test/ncurses.c which test string
    capabilities can run.
* Tue Sep  7 2010 aj@suse.de
- BuildRequire gpm-devel
* Wed Jul 14 2010 werner@suse.de
- List authors in contribution order
* Fri Jul  2 2010 jengelh@medozas.de
- Use %%_smp_mflags
* Fri May  7 2010 werner@suse.de
- Ad workaround to enforce that the terminal rading thread will
  interrupted by SIGWINCH (bnc#540571)
* Fri Jan 15 2010 werner@suse.de
- Disable experimetal term-driver API as this crash on NULL
  pointer function _nc_globals.term_driver
* Tue Jan 12 2010 werner@suse.de
- Update to test version 5.7.20100109
  * add tiparm(), based on review of X/Open Curses Issue 7.
  * minor improvement to tic's checking of similar SGR's to allow for the
    most common case of SGR 0.
  * modify getmouse() to act as its documentation implied, returning on
    each call the preceding event until none are left.  When no more
    events remain, it will return ERR.
  * add bterm terminfo entry, based on bogl 0.1.18 -TD
  * minor fix to rxvt+pcfkeys terminfo entry -TD
  * update minix terminfo entry -TD
  * add bw (auto-left-margin) to nsterm* entries (Benjamin Sittler)
  * correct transfer of multicolumn characters in multirow
    field_buffer(), which stopped at the end of the first row due to
    filling of unused entries in a cchar_t array with nulls.
  * updated nsterm* entries (Benjamin Sittler, Emanuele Giaquinta)
  * modify _nc_viscbuf2() and _tracecchar_t2() to show wide-character nulls.
  * fix case where progs/tput is used while sp-funcs is configure; this
    requires save/restore of out-character function from _nc_prescreen
    rather than the SCREEN structure (report by Charles Wilson).
  * limit hashing for termcap-names to 2-characters (Ubuntu #481740).
  * fix a regression in _nc_ripoffline which made test/ncurses.c not show
    soft-keys, broken in 20090927 merging.
  * update nsterm entries (patch by Benjamin C W Sittler, prompted by
    discussion with Fabian Groffen in GenToo #206201).
  * add test/xterm-256color.dat
  * modify _nc_wgetch() to check for a -1 in the fifo, e.g., after a
    SIGWINCH, and discard that value, to avoid confusing application
    (patch by Eygene Ryabinkin, FreeBSD bin/136223).
  * modify handling of $PKG_CONFIG_LIBDIR to use only the first item in
    a possibly colon-separated list (Debian #550716).
  * fix a sign-extension bug in unget_wch() (report by Mike Gran).
  * remove unnecessary kcan assignment to ^C from putty (Sven Joachim)
  * add ccc and initc capabilities to xterm-16color -TD
  * add linux-16color
  * correct initc capability of linux-c-nc end-of-range
  * completed integrating "sp-funcs" by Juergen Pfeifer in ncurses
    library (some work remains for forms library).
  * fix typo s/is_timeout/is_notimeout/ which made "man is_notimeout" not work.
  * add null-pointer checks to other opaque-functions.
  * add is_pad() and is_subwin() functions for opaque access to WINDOW
    (discussion with Mark Dickinson).
  * correct merge to lib_newterm.c, which broke when sp-funcs was enabled.
  * build-fix for building outside source-tree (report by Sven Joachim).
  * fix Debian lintian warning for man/tabs.1 by making section number
    agree with file-suffix (report by Sven Joachim).
  * workaround for bug in g++ 4.1-4.4 warnings for wattrset() macro on
    amd64 (Debian #542031).
  * modify wgetch() to ensure it checks SIGWINCH when it gets an error
    in non-blocking mode (patch by Clemens Ladisch).
  * fix configure script option --with-database, which was coded as an
    enable-type switch.
  * modify lib_addch.c to compensate for removal of wide-character test
    from unctrl() in 20090704 (Debian #539735).
  * modify _nc_find_type_entry() to use hashing.
  * modify length returned by getcchar() to count the trailing null
    which is documented in X/Open (cf: 20020427).
  * improve performance of tigetstr, etc., by using hashing code from tic.
  * minor fixes for memory-leak checking.
  * remove wide-character checks from unctrl() (patch by Clemens Ladisch).
  * revise wadd_wch() and wecho_wchar() to eliminate dependency on unctrl().
  * update llib-lncurses[wt] to use sp-funcs.
  * move definition for NCURSES_WRAPPED_VAR back to ncurses_dll.h, to
    make includes of term.h without curses.h work (report by "Nix").
  * fix a regression in lib_tputs.c, from ongoing merges.
  * fix an infinite recursion when adding a legacy-coding 8-bit value
    using insch() (report by Clemens Ladisch).
  * work around antique BSD game's manipulation of stdscr, etc., versus
    SCREEN's copy of the pointer (Debian #528411).
  * add a cast to wattrset macro to avoid compiler warning when comparing
    its result against ERR (adapted from patch by Matt Kraii, Debian #528374).
  * add vwmterm terminfo entry (patch by Bryan Christ).
  * build fix for _nc_free_and_exit() change in 20090418 (report by Christian Ebert).
  * extend ansi.sys pfkey capability from kf1-kf10 to kf1-kf48, moving
    function key definitions from emx-base for consistency -TD
  * improve install-rules for pc-files (patch by Miroslav Lichvar).
  * make it work with $DESTDIR
  * modify init_pair() to allow caller to create extra color pairs beyond
    the color_pairs limit, which use default colors (request by Emanuele Giaquinta).
  * fix typo "==" where "=" is needed in ncurses-config.in and
    gen-pkgconfig.in files (Debian #512161).
  * add screen.Eterm terminfo entry (GenToo #124887) -TD
  * add case for FreeMINT to configure macro CF_XOPEN_SOURCE (patch from
    GenToo #250454).
  * add check in mouse-driver to disable connection if GPM returns a
    zero, indicating that the connection is closed (Debian #506717,
    adapted from patch by Samuel Thibault).
  * turn on _XOPEN_CURSES definition in curses.h
  * add eterm-color entry (report by Vincent Lefevre) -TD
  * add a manpage to discuss memory leaks.
  * add teraterm4.59 terminfo entry, use that as primary teraterm entry, rename
    original to teraterm2.3 -TD
  * update "gnome" terminfo to 2.22.3 -TD
  * update "konsole" terminfo to 1.6.6, needs today's fix for tic -TD
  * add "aterm" terminfo -TD
  * add "linux2.6.26" terminfo -TD
  * add logic to tic for cancelling strings in user-defined capabilities,
    overlooked til now.
  * add configure option --disable-tic-depends to make explicit whether
    tic library depends on ncurses/ncursesw library, amends change from
    20080823 (prompted by Debian #501421).
  * add environment variable NCURSES_GPM_TERMS to allow override to use
    GPM on terminals other than "linux", etc.
  * disable GPM mouse support when $TERM does not happen to contain
    "linux", since Gpm_Open() no longer limits its assertion to terminals
    that it might handle, e.g., within "screen" in xterm.
  * fix bug in mouse code for GPM from 20080920 changes (reported in
    Debian #500103, also Miroslav Lichvar).
  * fix a memory leak when failure to connect to GPM.
  * correct check for notimeout() in wgetch() (report on linux.redhat
    newsgroup by FurtiveBertie).
  * corrected fix for --enable-weak-symbols (report by Frederic L W Meunier).
  * add configure check for awk programs unable to handle big-strings,
    use that to improve the default for --enable-big-strings option.
  * makefile-fixes for --enable-weak-symbols (report by Frederic L W Meunier).
  * consistently use NCURSES_BOOL in lib_gen.c
  * filter #line's from lib_gen.c
  * use pthread_mutexattr_init() for initializing pthread_mutexattr_t,
    makes threaded code work on HPUX 11.23
  * fix a bug in demo_menus in freeing menus (cf: 20080804).
  * modify configure script for the case where tic library is used (and
    possibly renamed) to remove its dependency upon ncurses/ncursew
    library (patch by Dr Werner Fink).
  * add Eterm-256color, Eterm-88color and rxvt-88color (prompted by
    Debian #495815) -TD
  * add configure option --enable-weak-symbols to turn on new feature.
  * add configure-check for availability of weak symbols.
  * modify linkage with pthread library to use weak symbols so that
    applications not linked to that library will not use the mutexes,
    etc.  This relies on gcc, and may be platform-specific (patch by Dr Werner Fink).
  * add note to INSTALL to document limitation of renaming of tic library
    using the --with-ticlib configure option (report by Dr Werner Fink).
  * document (in manpage) why tputs does not detect I/O errors (prompted
    by comments by Samuel Thibault).
* Sat Dec 12 2009 jengelh@medozas.de
- add baselibs.conf as a source
* Sun Dec  6 2009 jengelh@medozas.de
- enable parallel building
* Sat Nov 14 2009 pbaudis@suse.cz
- Add doc/terminfo.src.bz2 reference to /etc/termcap
- Update patches to apply with fuzz 0
* Wed Jan  7 2009 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Fri Nov 14 2008 werner@suse.de
- Do not free arrays and strings from static fallback entries (bnc#443683)
* Thu Sep  4 2008 werner@suse.de
- Correct order of include paths in ncurses6 case
* Mon Sep  1 2008 werner@suse.de
- Provide also termcap.h in /usr/include
* Thu Aug 28 2008 ro@suse.de
- require libncurses5 _and_ libncurses6 from ncurses-devel
  (avoid having a version with only static libs in the
  build environment to prevent static linking fallback)
* Mon Aug 18 2008 werner@suse.de
- Use include directories more restrictive that is
  * /usr/include/ncurses/*.h for standard version
  * /usr/include/ncursesw/*.h for wide version
  * /usr/include/ncurses6/ncurses/*.h for ABI 6.0 standard version
  * /usr/include/ncurses6/ncursesw/*.h for ABI 6.0 wide version
- Make thread support using weak symbols that is be thread safe
  only for applications using the libpthread.
* Thu Aug 14 2008 werner@suse.de
- Update to test version 5.6.20080804
  * fix memory leaks in test/demo_menus
  * build-fixes for gcc 4.3.1
  * use NCURSES_MOUSE_MASK() in definition of BUTTON_RELEASE(), etc., to
    make those work properly with the "--enable-ext-mouse" configuration
    (cf: 20050205).
  * improve mlterm and mlterm+pcfkeys terminfo entries -TD
  * add null-pointer checks for cur_term in baudrate() and
    def_shell_mode(), def_prog_mode()
  * fix some memory leaks in delscreen() and wide acs.
  * modify test/ditto.c to illustrate multi-threaded use_screen().
  * finish changes to wgetch(), making it switch as needed to the
    window's actual screen when calling wrefresh() and wgetnstr().  That
    allows wgetch() to get used concurrently in different threads with
    some minor restrictions, e.g., the application should not delete a
    window which is being used in a wgetch().
  * simplify mutex's, combining the window- and screen-mutex's.
  * modify wgetch() to use the screen which corresponds to its window
    parameter rather than relying on SP; some dependent functions still
    use SP internally.
  * factor out most use of SP in lib_mouse.c, using parameter.
  * modify _nc_keypad() to make it switch temporarily as needed to the
    screen which must be updated.
  * wrap cur_term variable to help make _nc_keymap() thread-safe, and
    always set the screen's copy of this variable in set_curterm().
  * restore curs_set() state after endwin()/refresh() (report/patch
    Miroslav Lichvar)
  * corrected manpage description of setcchar()
  * fix for adding a non-spacing character at the beginning of a line
  * modify screen.* terminfo entries using new screen+fkeys to fix
    overridden keys in screen.rxvt (Debian #478094) -TD
  * simplify some loops with macros each_screen(), each_window() and
    each_ripoff().
  * fix typo in form.3x
  * add screen.rxvt terminfo entry -TD
  * modify tic -f option to format spaces as \s to prevent them from
    being lost when that is read back in unformatted strings.
  * add locks for copywin(), dupwin(), overlap(), overlay() on their
    window parameters.
  * add locks for initscr() and newterm() on updates to the SCREEN
    pointer.
  * finish table in curs_thread.3x manpage.
* Wed May  7 2008 coolo@suse.de
- we need to obsolete ncurses 5.6 too, it's 10.3's version
* Tue Apr 22 2008 werner@suse.de
- Split ncurses into two separate packages ncurses-utils and
  terminfo-base to get the resolvers happy (bnc#381293)
* Sat Apr 19 2008 ro@suse.de
- update baselibs.conf
* Fri Apr 11 2008 werner@suse.de
- Do not dlopen libgpm if already loaded by runtime linker
* Thu Apr 10 2008 lrupp@suse.de
- rename ncurses to libncurses5 in baselibs.conf
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Thu Apr 10 2008 werner@suse.de
- Small change to make the cflags work in ncurses{w,t,tw}-config
* Wed Apr  9 2008 werner@suse.de
- Update to test version 5.6.20080405 with the ABI of the upcoming
  verion 6.0. This includes already the patch for coverity report.
* Tue Apr  8 2008 werner@suse.de
- New sub package libncurses5 including the shared libraries and
  the required terminfo and termset data files.
* Mon Dec 10 2007 werner@suse.de
- Avoid endless loop in case of including the wrapper header
* Wed Dec  5 2007 werner@suse.de
- Add compatibility header files (bug #337412)
* Mon Oct 29 2007 pth@suse.de
- Fix configure so that ncurses-config doesn't erroneously
  report ncurses.h to reside in /usr/include/ncurses (#337412).
* Wed Sep  5 2007 werner@suse.de
- Move libncursesw to /lib or /lib64 (bug #307353)
* Fri May 25 2007 dmueller@suse.de
- add %%post/un to call ldconfig
* Tue May 15 2007 dmueller@suse.de
- move documentation to -devel package and bzip text files
* Tue Mar 20 2007 rguenther@suse.de
- Remove unused ed BuildRequires.
* Mon Mar 19 2007 rguenther@suse.de
- Make gpm support via libdl and gpm BuildRequires explicit.
* Wed Jan 31 2007 werner@suse.de
- Update to 5.6-20070128
- Split of tack a its own sub package to be able to specify the
  different licenses of ncurses and tack (bug #231835)
* Fri Nov 17 2006 werner@suse.de
- Revert broken change for rxvt from patchlevel 20051015 (#221259)
* Wed Nov 15 2006 werner@suse.de
- Disable experimental xmc-glitch (magic cookie support) for now
  because it breaks YaST2 on console/konsole (bug #199256)
* Wed Aug  2 2006 rguenther@suse.de
- Removed not required BuildRequires on sharutils.
* Mon Jul 31 2006 schwab@suse.de
- Don't make stack executable.
- Remove executable bit from archives.
* Thu May 18 2006 werner@suse.de
- Update to 5.5-20060513
- Add rxvt-unicode terminfo entry
* Sun Apr  9 2006 werner@suse.de
- Removed enacs from xterm terminfo entry, the reason is that it
  would break non latin encodings and the xterm does not need it
  (See comment #11 of bug #163715).
* Sat Apr  8 2006 werner@suse.de
- Enable the script to get better termcap entries for arious linux
  console types (bug #163715)
* Fri Apr  7 2006 werner@suse.de
- Add enacs capability to xterm terminfo entry (bug #163715)
- Also add a script to get better termcap entries for
  various linux console types, currently unused (bug#163715)
* Wed Mar  1 2006 werner@suse.de
- Add screen terminfo entry for 256 colors (bug #136684)
* Thu Feb 23 2006 werner@suse.de
- On 64 bit architectures: be backward compatible and use
  unsigned long for chtype (bug #151283)
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Tue Jan 10 2006 ro@suse.de
- create empty va_list instead of using NULL (not portable)
* Sat Dec 17 2005 kukuk@suse.de
- Remove /usr/lib/terminfo symlink
* Mon Oct 17 2005 werner@suse.de
- New version new bug, fix doubled man alias for tack (bug #127783)
* Thu Oct 13 2005 werner@suse.de
- Switch to ncurses version 5.5
- Re-enable curses.h to support both wide and normal characters
* Tue Jul 26 2005 werner@suse.de
- Move terminfo entry of mlterm to mlterm 2.9.2, add cvvis, and
  add it to the default terminfo entries of ncurses.
* Fri Jul 22 2005 werner@suse.de
- Update to patch level 20050716
* Tue Mar  1 2005 schwab@suse.de
- Fix return value of tigetflag.
* Thu Feb 24 2005 werner@suse.de
- Re-add the ESC[?1c to the civis for linux terminal (bug #65481)
* Thu Sep 16 2004 werner@suse.de
- Add attributes only on first byte of a wide character (#45479)
* Fri Sep 10 2004 werner@suse.de
- Make the wide fix smart
* Thu Sep  9 2004 werner@suse.de
- Re-enable wide fix for none wide terminals
* Fri Apr 23 2004 werner@suse.de
- Fix crash due called weak symbol without check
* Mon Apr  5 2004 werner@suse.de
- Be sure that EINTR from signal is correctly delivered to the
  reading thread. Use weak symbols to get it work even if not
  (p)threaded (bug #37273).
* Fri Apr  2 2004 werner@suse.de
- Use weak symbol pthread_setmask instead of sigprocmask if
  called by (p)threaded programs like yast2 (bug #37273).
* Thu Feb 19 2004 werner@suse.de
- Switch to official version of 5.4
* Wed Jan 28 2004 werner@suse.de
- Fix ACSC list of kterm e.g. for alsamixer
* Fri Jan 16 2004 werner@suse.de
- Update to 5.3-2004011 aka 5.4
- Strike nasty bug in wide version: now none UTF-8 graphic
  characters are usable in any locale again.
- Enable TRACE for debugging builds
* Mon Nov 24 2003 kukuk@suse.de
- Build as non-root
- Compile with no-execstack
* Tue Jul 29 2003 aj@suse.de
- Fix for changed chown behaviour.
* Mon Feb 24 2003 werner@suse.de
- Fix for ACS handling: YaST uses always correct fonts with UTF-8
* Tue Feb 11 2003 werner@suse.de
- Set TERM if not set, should help to build ncurses on all hosts
* Mon Feb 10 2003 werner@suse.de
- Update to patch level 20030201 due fix of mem leaks
* Thu Jan 30 2003 werner@suse.de
- Fix dynamic file listing for terminfo: also include sym links
* Wed Jan 22 2003 werner@suse.de
- Fix va handling in printw, disable experimental safe sprintf
  builtin (bug #22987)
* Thu Jan  9 2003 werner@suse.de
- Update to ncurses 5.3 patchlevel 20030105
- Make spec file more handy with automatic file list generation
* Tue Sep 17 2002 ro@suse.de
- removed bogus self-provides
* Wed Aug 14 2002 mls@suse.de
- updated screen terminfo entry, added screen-bce and screen-s
* Fri Aug  9 2002 kukuk@suse.de
- ncurses-devel should require ncurses [Bug #17543]
* Tue Aug  6 2002 werner@suse.de
- Switch to XTerm for XFree86[tm] 4.2.0 (bug #15002)
* Wed Jul 31 2002 meissner@suse.de
- disabled -funroll-loops since it triggers a compiler bug on PPC.
* Thu Jul 18 2002 kukuk@suse.de
- Remove old /usr/lib compatibility links
* Mon Jul 15 2002 werner@suse.de
- Remove ich1 from xterm entry (bug #7857) hopefully most modern
  programs uses ncurses
- Add kcbt key for YaST
- remove ncurses 4.2
- Enable ncurses 5.2 with wide character support
* Fri Jun 14 2002 olh@suse.de
- do not build ncurses 4.2 on ppc64, it appears in Requires later
* Wed May 22 2002 olh@suse.de
- do not package libncurses.4 on ppc64, allow build as non-root
* Sat May 11 2002 schwab@suse.de
- Remove ia64 compiler workarounds.
* Wed Apr 17 2002 kukuk@suse.de
- Disable old ncurses libraries on x86_64
* Thu Feb 21 2002 werner@suse.de
- Fix cat&paste error of patch level 20010922
* Mon Feb 11 2002 ro@suse.de
- tar option for bz2 is "j"
* Wed Feb  6 2002 coolo@suse.de
- s390x is 64 bit too
* Fri Nov 23 2001 uli@suse.de
- fixed to build on ARM
* Sun Nov 11 2001 schwab@suse.de
- Fix last change, use vsscanf instead of vscanf.
* Fri Nov  9 2001 stepan@suse.de
- fix ncurses 4.2 on gcc3 distributions.
* Thu Oct  4 2001 werner@suse.de
- Update to ncurses 5.2 patch level 20011001
* Wed Jun  6 2001 bk@suse.de
- fix to compile on s390x (cursesw.cc)
* Tue May  8 2001 mfabian@suse.de
- bzip2 sources
* Wed Apr 11 2001 schwab@suse.de
- Reenable c++ bindings on ia64, instead use -O0 for c++.
* Thu Mar 22 2001 ro@suse.de
- added split aliases as provides
* Tue Mar 20 2001 schwab@suse.de
- Don't build c++ bindings and remove -funroll-loops on ia64 to work
  around compiler bug.
* Fri Mar 16 2001 ro@suse.de
- fix to compile on s390 (cursesw.cc)
* Mon Feb 19 2001 ro@suse.de
- fixed to compile on gcc-2.96 (include string.h)
* Fri Feb 16 2001 werner@suse.de
- We don't need include string.h more than once
- Update to patch 20010210
* Thu Feb 15 2001 stepan@suse.de
- add some includes to compile with newer gcc versions.
* Fri Dec 22 2000 werner@suse.de
- After a reset xterm should answer ^? on backarrow key
* Thu Dec  7 2000 werner@suse.de
- Add vt102 to fallback terminal descriptions
- Add xterm-basic only to ncurses
* Tue Nov 14 2000 werner@suse.de
- Try to solve boot straping without installed ncurses-devel
- Use newest terminfo sources for builtin fallback
- Re-enable ncurses-5.0-to-4.2-panel.patch for ncurses 4.2
- Move /usr/lib/lib*.so to ncurses-devel
* Mon Nov 13 2000 werner@suse.de
- Update to ncurses 5.2
- Fix replacement of marks within manual pages
- Set type of ospeed to speed_t
- Put development tools, headers and static libs into
  their own package ncurses-devel.
* Thu Oct 26 2000 kukuk@suse.de
- Rename sharutil to sharutils
* Sun Oct 15 2000 schwab@suse.de
- Fix libncurses.so link.
* Tue Oct 10 2000 werner@suse.de
- Update to 5.1 due to the better handling of string termination
  of terminfo entries (security, strcpy patch therefore).
* Fri Oct  6 2000 werner@suse.de
- Move strncpy to strlcpy which appends the terminating NUL
  character.
* Mon Oct  2 2000 werner@suse.de
- Use strncpy and strncat in lib_mvcur.c instead of the trustful
  strcpy and strcat.
* Sun Oct  1 2000 kukuk@suse.de
- Fix for compiling with new g++ on ia64
* Sun Oct  1 2000 kukuk@suse.de
- Don't use run_cmd.sh to create fallback.c
- Don't build compat ncurses 4.2 on new platforms
- Use rpm 3.0.5 macros for 32/64bit support
* Mon Sep  4 2000 werner@suse.de
- Correct documentation path
* Fri Jul  7 2000 werner@suse.de
- Make update mechanism compatible with rpm, yast and yast2
* Wed Jun 28 2000 werner@suse.de
- Better update mechanism (verified with 6.2, 6.3, 6.4, and 7.0)
- Update to patch level 20000624 due some bug fixes included there
- Fix due bug in lib_screen.c (causes SIGSEGV)
* Mon May 22 2000 werner@suse.de
- Use new macros to avoid removing files via symbolic linked
  directory which was a real directory. I use here not only
  %%ghost but also %%config(missingok) to avoid the buggy
  order of executing %%post install script. (There is no
  %%post remove script).
* Wed May 17 2000 werner@suse.de
- One fix more
* Tue May 16 2000 werner@suse.de
- Fix the post install script: usr/lib/tabset may empty
* Mon Apr  3 2000 bk@suse.de
- added workaround for bad %%{suse_update_config -f} handling on i386
  message was: suse_update_config: invalid option --
* Sat Apr  1 2000 bk@suse.de
- updated %%suse_update_config call for s390
* Fri Mar  3 2000 schwab@suse.de
- Fix for ia64.
- Update config.{guess,sub} from automake
* Thu Mar  2 2000 werner@suse.de
- Add patch for resize of subwindows relative to their parents
  (required for YaST2)
* Mon Feb 28 2000 werner@suse.de
- Add patch 20000226 which makes 20000219 work perfect
* Fri Feb 25 2000 werner@suse.de
- Add patch 20000219 which should help on setting default fg/bg
  off the most applications
* Fri Feb 18 2000 werner@suse.de
- Add patches 20000115, 20000122, 20000205, and 20000212
  * hopefully this fixes some coloring kludges
- Make $VENDOR work for all Linux architectures
- Fix kvt/gnome entries for SuSE
* Tue Feb 15 2000 schwab@suse.de
- Update config.{guess,sub} to latest version.
* Thu Feb  3 2000 ro@suse.de
- use "-O1" for ncurses-4.2 on alpha
* Thu Jan 20 2000 ro@suse.de
- don't build ncurses-4.2/c++/demo
* Tue Jan 18 2000 werner@suse.de
- Workaround for all system which uses _SYS_VA_LIST_H (e.g. PPC)
* Mon Jan 17 2000 werner@suse.de
- Hey here we are: libncurses 5.0
  * Use patches 19991030 upto 20000108
  * Make arch-suse-linux work
  * Use real intrinsic fallback term entries
  * Use setfsuid and setfsgid for suid programs (linux issue only)
  * Use our xterm standard (should be changed for xterm-4.0)
  * Add/update some common term entries
- Hold shared libncurses 4.2 libraries for backward compatibility
  and older programs
- Use /usr/share/man/
* Fri Oct 29 1999 werner@suse.de
- Remove buggy bool patch, sizeof the type bool should the same in
  C++ and C on any architecture.  This because libncurses is used
  by both type of C++ and C programs. Let configure do its job.
* Fri Oct 15 1999 werner@suse.de
- Last minor checks
- Move /usr/lib/terminfo/, /usr/lib/tabset/ to /usr/share/terminfo/,
  /usr/share/tabset/ and set a compatibility link.
- Check security fix, seems to work.
* Thu Oct 14 1999 werner@suse.de
- Port some patches from debian mainly security issues
- Use newer terminfo.src
- Move some common terminfo entries from terminfo packages
  to main packages ncurses
* Wed Oct 13 1999 werner@suse.de
- Add panel patch from ncurses 5.0
- Remove kbs=\177 for some terminals like some xterm types and
  vt100 to hold it compatible with other UNICES
- Update our xterm settings (with kbs=\177 and kdch1=\E[3~)
- Update the settings for xterm v4.0 but leave default on
  our old version which are compatible
- Add some dumb terminal type like switch, patch, net,
  network, arpanet, and dialup
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Thu Mar 25 1999 ro@suse.de
- changed permissions (a+x) for libform,menu,panel
* Mon Mar 22 1999 florian@suse.de
- add compatibility link from /usr/share/{tabset,terminfo}
* Sat Sep  5 1998 ro@suse.de
- fixed neededforbuild
* Wed Jun  3 1998 florian@suse.de
- use major 4 for glibc2
* Wed Mar 11 1998 werner@suse.de
- Defines a xterm-xf86suse entry
  * use xterm-xf86-v33 with changes
- Use xterm-xf86suse for xterm
* Mon Mar  9 1998 bs@suse.de
- set executable bit to libncurses.so.3.0.*
* Mon Mar  2 1998 florian@suse.de
- update to ncurses 4.2
- use xterm for XFree86 3.3 and not 3.2...
* Mon Mar  2 1998 florian@suse.de
- mark /etc/termcap as %%config
* Fri Feb 20 1998 werner@suse.de
- redone fixes as to previous version
* Tue Feb 17 1998 florian@suse.de
- update to ncurses 4.2-beta1
* Thu Jan 29 1998 werner@suse.de
- add some settings for:
  * TERM=linux (cvvis and sgr0 added)
  * TERM=xterm (kf21 (shift F11) and kf22 (shift F12) added)
  * TERM=rxvt  (keypad keys correct defined, mc5 and mc4 added
  for printing, smacs and rmacs repaired, sgr added)
* Tue Nov 11 1997 ro@suse.de
- terminfo builds from same specfile
* Fri Oct 17 1997 ro@suse.de
- removed old lib 1.9.7a
  ready for autobuild
* Tue May 27 1997 florian@suse.de
- handle wrong TERM-settings for tput
- change xterm-entry in terminfo source file
* Tue May 20 1997 florian@suse.de
- update to version 4.1
* Wed Apr 30 1997 florian@suse.de
- mv /lib/libncurses.so.1.9* /usr/lib/
* Sun Apr 13 1997 florian@suse.de
- update to new version 970412
* Thu Jan  2 1997 werner@suse.de
- Anpassung von terminfo an das XTerm app-defaults
  - Einige Fixes in der Intialisierung und Handling
    von Escape-Sequenzen des xterms aus XFree86[tm]-3.2
* Thu Jan  2 1997 florian@suse.de
- update to version 961102
* Thu Jan  2 1997 florian@suse.de
- Update auf die neuste ncurses-Version.
- 'xterm' ist fuer XFree86 3.1.2G.  Falls jemand noch ein altes XFree86
  benutzen will, sollte man 'xterm-base' verwenden.
- Falls es Probleme gibt, kann man anstatt /lib/libncurses.so.1.9.9g
  auch /lib/libncurses.so.1.9.9e verwenden. (g-Version einfach umbenennen
  und ldconfig starten.) Dann sollte man aber keine Programme mehr
  kompilieren...
