#
# spec file for package pam
#
# Copyright (c) 2018 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


#
%define enable_selinux 1
#
%{load:%{_sourcedir}/macros.pam}
#
Name:           pam
Url:            http://www.linux-pam.org/
BuildRequires:  audit-devel
BuildRequires:  bison
BuildRequires:  cracklib-devel
BuildRequires:  flex
%if 0%{?suse_version} > 1320
BuildRequires:  pkgconfig(libnsl)
BuildRequires:  pkgconfig(libtirpc)
%endif
%if %{enable_selinux}
BuildRequires:  libselinux-devel
%endif
%define libpam_so_version 0.84.2
%define libpam_misc_so_version 0.82.1
%define libpamc_so_version 0.82.1
#
Version:        1.3.0
Release:        150000.6.86.1
Summary:        A Security Tool that Provides Authentication for Applications
License:        GPL-2.0+ or BSD-3-Clause
Group:          System/Libraries
PreReq:         permissions
%if 0%{?suse_version} >= 1330
Requires(pre):  group(shadow)
Requires(pre):  user(root)
%endif

#DL-URL:	https://fedorahosted.org/releases/l/i/linux-pam/
Source:         Linux-PAM-%{version}.tar.bz2
Source1:        Linux-PAM-%{version}-docs.tar.bz2
Source2:        securetty
Source3:        other.pamd
Source4:        common-auth.pamd
Source5:        common-account.pamd
Source6:        common-password.pamd
Source7:        common-session.pamd
Source8:        etc.environment
Source9:        baselibs.conf
Source10:       unix2_chkpwd.c
Source11:       unix2_chkpwd.8
Source12:       macros.pam
Source13:       pam.tmpfiles
Patch0:         fix-man-links.dif
Patch3:         encryption_method_nis.diff
Patch4:         pam-hostnames-in-access_conf.patch
Patch5:         pam-fix-config-order-in-manpage.patch
Patch6:         use-correct-IP-address.patch
Patch8:         pam-xauth_ownership.patch
Patch9:         pam-bsc1178727-initialize-daysleft.patch
Patch10:        pam-bsc1177858-dont-free-environment-string.patch
Patch11:        pam-pam_cracklib-add-usersubstr.patch
Patch12:        pam-bsc1181443-make-nofile-unlimited-mean-nr_open.patch
Patch13:        bsc1184358-prevent-LOCAL-from-being-resolved.patch
Patch14:        pam-sle20638-add-pam_faillock.patch
Patch15:        pam-bsc1197024-free-addrinfo-before-return.patch
Patch16:        pam-bsc1197794-do-not-include-obsolete-header-files.patch
Patch17:        pam-ped1712-pam_motd-directory-feature.patch
Patch18:        pam-bsc1217000-pam_lastlog-check-localtime_r-return-value.patch
Patch19:        pam-bsc1218475-pam_namespace-O_DIRECTORY-flag.patch
Patch20:        pam-bsc1194818-cursor-escape.patch
Patch21:        pam_unix-allow-empty-passwords-with-non-empty-hashes.patch
Patch22:        pam_env-change-the-default-to-not-read-the-user-env.patch
Patch23:        pam_inline-introduce-pam_asprintf-pam_snprintf-and-p.patch
Patch24:        pam_namespace-fix-potential-privilege-escalation.patch
Patch25:        pam_namespace-add-flags-to-indicate-path-safety.patch
Patch26:        pam_namespace-secure_opendir-do-not-look-at-the-grou.patch
Patch27:        libpam-introduce-secure-memory-erasure-helpers.patch
Patch28:        pam_modutil_get-overwrite-password-at-free.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
# Remove with next version update:
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool

%description
PAM (Pluggable Authentication Modules) is a system security tool that
allows system administrators to set authentication policies without
having to recompile programs that do authentication.

%package extra
Summary:        PAM module to authenticate against a separate database
Group:          System/Libraries%description
BuildRequires:  libdb-4_8-devel
BuildRequires:  pam-devel

%description extra
PAM (Pluggable Authentication Modules) is a system security tool that
allows system administrators to set authentication policies without
having to recompile programs that do authentication.

This package contains useful extra modules eg pam_userdb which is
used to verify a username/password pair against values stored in
a Berkeley DB database.



%package doc
Summary:        Documentation for Pluggable Authentication Modules
Group:          Documentation/HTML
%if 0%{?suse_version} >= 1140
BuildArch:      noarch
%endif

%description doc
PAM (Pluggable Authentication Modules) is a system security tool that
allows system administrators to set authentication policies without
having to recompile programs that do authentication.

This package contains the documentation.



%package devel
Summary:        Include Files and Libraries for PAM-Development
Group:          Development/Libraries/C and C++
Requires:       glibc-devel
Requires:       pam = %{version}

%description devel
PAM (Pluggable Authentication Modules) is a system security tool which
allows system administrators to set authentication policy without
having to recompile programs which do authentication.

This package contains header files and static libraries used for
building both PAM-aware applications and modules for use with PAM.

%prep
%setup -q -n Linux-PAM-%{version} -b 1
%patch0 -p1
%patch3 -p0
%patch4 -p0
%patch5 -p1
%patch6 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1

%build
autoreconf -fiv
export CFLAGS="%optflags -DNDEBUG"
%configure \
	--sbindir=/sbin \
	--includedir=%_includedir/security \
	--docdir=%{_docdir}/pam \
	--htmldir=%{_docdir}/pam/html \
	--pdfdir=%{_docdir}/pam/pdf \
        --libdir=/%{_lib} \
	--enable-isadir=../..%{_pam_moduledir} \
        --enable-securedir=%{_pam_moduledir}
make %{?_smp_mflags}
# These two files are introduced through a patch so they do not
# get the required execute permission.
chmod 750 build-aux/test-driver modules/pam_faillock/tst-pam_faillock
%__cc -fwhole-program -fpie -pie -D_FILE_OFFSET_BITS=64 -D_GNU_SOURCE %{optflags} -I$RPM_BUILD_DIR/Linux-PAM-%{version}/libpam/include %{SOURCE10} -o $RPM_BUILD_DIR/unix2_chkpwd -L$RPM_BUILD_DIR/Linux-PAM-%{version}/libpam/.libs/ -lpam

%check
make %{?_smp_mflags} check

%install
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
mkdir -p $RPM_BUILD_ROOT/usr/include/security
mkdir -p $RPM_BUILD_ROOT%{_pam_moduledir}
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p -m 755 $RPM_BUILD_ROOT%{_libdir}
make DESTDIR=$RPM_BUILD_ROOT install
/sbin/ldconfig -n $RPM_BUILD_ROOT/%{_lib}
# Install documentation
make -C doc install DESTDIR=$RPM_BUILD_ROOT
# install /etc/environment
install -m 644 %{SOURCE8} $RPM_BUILD_ROOT/etc/environment
# install securetty
install -m 644 %{SOURCE2} $RPM_BUILD_ROOT/etc
# install tmpfiles
install -Dm0644 %{SOURCE13} %{buildroot}%{_tmpfilesdir}/pam.conf
%ifarch s390 s390x
echo "ttyS0" >> $RPM_BUILD_ROOT/etc/securetty
echo "ttyS1" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc0" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc1" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc2" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc3" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc4" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc5" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc6" >> $RPM_BUILD_ROOT/etc/securetty
echo "hvc7" >> $RPM_BUILD_ROOT/etc/securetty
echo "sclp_line0" >> $RPM_BUILD_ROOT/etc/securetty
echo "ttysclp0" >> $RPM_BUILD_ROOT/etc/securetty
%endif
# install other.pamd and common-*.pamd
install -m 644 %{SOURCE3} $RPM_BUILD_ROOT/etc/pam.d/other
install -m 644 %{SOURCE4} $RPM_BUILD_ROOT/etc/pam.d/common-auth
install -m 644 %{SOURCE5} $RPM_BUILD_ROOT/etc/pam.d/common-account
install -m 644 %{SOURCE6} $RPM_BUILD_ROOT/etc/pam.d/common-password
install -m 644 %{SOURCE7} $RPM_BUILD_ROOT/etc/pam.d/common-session
rm $RPM_BUILD_ROOT/%{_lib}/libpam.so
ln -sf ../../%{_lib}/libpam.so.%{libpam_so_version} $RPM_BUILD_ROOT%{_libdir}/libpam.so
rm $RPM_BUILD_ROOT/%{_lib}/libpamc.so
ln -sf ../../%{_lib}/libpamc.so.%{libpamc_so_version} $RPM_BUILD_ROOT%{_libdir}/libpamc.so
rm $RPM_BUILD_ROOT/%{_lib}/libpam_misc.so
ln -sf ../../%{_lib}/libpam_misc.so.%{libpam_misc_so_version} $RPM_BUILD_ROOT%{_libdir}/libpam_misc.so
#
# Remove crap
#
rm -rf $RPM_BUILD_ROOT/%{_lib}/*.la $RPM_BUILD_ROOT%{_pam_moduledir}/*.la
for x in pam_unix_auth pam_unix_acct pam_unix_passwd pam_unix_session; do
  ln -f $RPM_BUILD_ROOT%{_pam_moduledir}/pam_unix.so $RPM_BUILD_ROOT%{_pam_moduledir}/$x.so
done
#
# Install READMEs of PAM modules
#
DOC=$RPM_BUILD_ROOT%{_defaultdocdir}/pam
mkdir -p $DOC/modules
(
  cd modules;
  for i in pam_*/README ; do
    cp -fpv ${i} $DOC/modules/README.`dirname ${i}`
  done
)
#
# pam_tally is deprecated since ages
#
rm -f $RPM_BUILD_ROOT%{_pam_moduledir}/pam_tally.so
rm -f $RPM_BUILD_ROOT/sbin/pam_tally
rm -f $RPM_BUILD_ROOT%{_mandir}/man8/pam_tally.8*
rm -f $RPM_BUILD_ROOT%{_defaultdocdir}/pam/modules/README.pam_tally
# Install unix2_chkpwd
install -m 755 $RPM_BUILD_DIR/unix2_chkpwd $RPM_BUILD_ROOT/sbin/
install -m 644 $RPM_SOURCE_DIR/unix2_chkpwd.8 $RPM_BUILD_ROOT%{_mandir}/man8/
# rpm macros
install -D -m 644 %{SOURCE12} %{buildroot}%{_rpmmacrodir}/macros.pam
# Create filelist with translatins
%{find_lang} Linux-PAM

%verifyscript
%verify_permissions -e /sbin/unix_chkpwd
%verify_permissions -e /sbin/unix2_chkpwd

%post
/sbin/ldconfig
%set_permissions /sbin/unix_chkpwd
%set_permissions /sbin/unix2_chkpwd
%tmpfiles_create %{_tmpfilesdir}/pam.conf

%postun -p /sbin/ldconfig

%files -f Linux-PAM.lang
%defattr(-,root,root)
%dir %{_sysconfdir}/pam.d
%dir %{_sysconfdir}/security
%dir %{_sysconfdir}/security/limits.d
%dir %{_defaultdocdir}/pam
%config(noreplace) %{_sysconfdir}/pam.d/other
%config(noreplace) %{_sysconfdir}/pam.d/common-*
%config(noreplace) %{_sysconfdir}/securetty
%config(noreplace) %{_sysconfdir}/environment
%config(noreplace) %{_sysconfdir}/security/access.conf
%config(noreplace) %{_sysconfdir}/security/group.conf
%config(noreplace) %{_sysconfdir}/security/limits.conf
%config(noreplace) %{_sysconfdir}/security/pam_env.conf
%if %{enable_selinux}
%config(noreplace) %{_sysconfdir}/security/sepermit.conf
%endif
%config(noreplace) %{_sysconfdir}/security/time.conf
%config(noreplace) %{_sysconfdir}/security/namespace.conf
%config(noreplace) %{_sysconfdir}/security/namespace.init
%config(noreplace) %{_sysconfdir}/security/faillock.conf
%doc NEWS
%license COPYING
%doc %{_mandir}/man5/environment.5*
%doc %{_mandir}/man5/*.conf.5*
%doc %{_mandir}/man5/pam.d.5*
%dir %{_mandir}/man8
%doc %{_mandir}/man8/pam.8.gz
%doc %{_mandir}/man8/pam_access.8.gz
%doc %{_mandir}/man8/pam_cracklib.8.gz
%doc %{_mandir}/man8/pam_debug.8.gz
%doc %{_mandir}/man8/pam_deny.8.gz
%doc %{_mandir}/man8/pam_echo.8.gz
%doc %{_mandir}/man8/pam_env.8.gz
%doc %{_mandir}/man8/pam_exec.8.gz
%doc %{_mandir}/man8/pam_faildelay.8.gz
%doc %{_mandir}/man8/pam_faillock.8.gz
%doc %{_mandir}/man8/faillock.8.gz
%doc %{_mandir}/man8/pam_filter.8.gz
%doc %{_mandir}/man8/pam_ftp.8.gz
%doc %{_mandir}/man8/pam_group.8.gz
%doc %{_mandir}/man8/pam_issue.8.gz
%doc %{_mandir}/man8/pam_keyinit.8.gz
%doc %{_mandir}/man8/pam_lastlog.8.gz
%doc %{_mandir}/man8/pam_limits.8.gz
%doc %{_mandir}/man8/pam_listfile.8.gz
%doc %{_mandir}/man8/pam_localuser.8.gz
%doc %{_mandir}/man8/pam_loginuid.8.gz
%doc %{_mandir}/man8/pam_mail.8.gz
%doc %{_mandir}/man8/pam_mkhomedir.8.gz
%doc %{_mandir}/man8/pam_motd.8.gz
%doc %{_mandir}/man8/pam_namespace.8.gz
%doc %{_mandir}/man8/pam_nologin.8.gz
%doc %{_mandir}/man8/pam_permit.8.gz
%doc %{_mandir}/man8/pam_pwhistory.8.gz
%doc %{_mandir}/man8/pam_rhosts.8.gz
%doc %{_mandir}/man8/pam_rootok.8.gz
%doc %{_mandir}/man8/pam_securetty.8.gz
%doc %{_mandir}/man8/pam_selinux.8.gz
%doc %{_mandir}/man8/pam_sepermit.8.gz
%doc %{_mandir}/man8/pam_shells.8.gz
%doc %{_mandir}/man8/pam_succeed_if.8.gz
%doc %{_mandir}/man8/pam_tally2.8.gz
%doc %{_mandir}/man8/pam_time.8.gz
%doc %{_mandir}/man8/pam_timestamp.8.gz
%doc %{_mandir}/man8/pam_timestamp_check.8.gz
%doc %{_mandir}/man8/pam_tty_audit.8.gz
%doc %{_mandir}/man8/pam_umask.8.gz
%doc %{_mandir}/man8/pam_unix.8.gz
%doc %{_mandir}/man8/pam_warn.8.gz
%doc %{_mandir}/man8/pam_wheel.8.gz
%doc %{_mandir}/man8/pam_xauth.8.gz
%doc %{_mandir}/man8/PAM.8.gz
%doc %{_mandir}/man8/mkhomedir_helper.8.gz
%doc %{_mandir}/man8/unix2_chkpwd.8.gz
%doc %{_mandir}/man8/unix_chkpwd.8.gz
%doc %{_mandir}/man8/unix_update.8.gz
/%{_lib}/libpam.so.0
/%{_lib}/libpam.so.%{libpam_so_version}
/%{_lib}/libpamc.so.0
/%{_lib}/libpamc.so.%{libpamc_so_version}
/%{_lib}/libpam_misc.so.0
/%{_lib}/libpam_misc.so.%{libpam_misc_so_version}
%dir %{_pam_moduledir}
%{_pam_moduledir}/pam_access.so
%{_pam_moduledir}/pam_cracklib.so
%{_pam_moduledir}/pam_debug.so
%{_pam_moduledir}/pam_deny.so
%{_pam_moduledir}/pam_echo.so
%{_pam_moduledir}/pam_env.so
%{_pam_moduledir}/pam_exec.so
%{_pam_moduledir}/pam_faildelay.so
%{_pam_moduledir}/pam_faillock.so
%{_pam_moduledir}/pam_filter.so
%dir %{_pam_moduledir}/pam_filter
%{_pam_moduledir}//pam_filter/upperLOWER
%{_pam_moduledir}/pam_ftp.so
%{_pam_moduledir}/pam_group.so
%{_pam_moduledir}/pam_issue.so
%{_pam_moduledir}/pam_keyinit.so
%{_pam_moduledir}/pam_lastlog.so
%{_pam_moduledir}/pam_limits.so
%{_pam_moduledir}/pam_listfile.so
%{_pam_moduledir}/pam_localuser.so
%{_pam_moduledir}/pam_loginuid.so
%{_pam_moduledir}/pam_mail.so
%{_pam_moduledir}/pam_mkhomedir.so
%{_pam_moduledir}/pam_motd.so
%{_pam_moduledir}/pam_namespace.so
%{_pam_moduledir}/pam_nologin.so
%{_pam_moduledir}/pam_permit.so
%{_pam_moduledir}/pam_pwhistory.so
%{_pam_moduledir}/pam_rhosts.so
%{_pam_moduledir}/pam_rootok.so
%{_pam_moduledir}/pam_securetty.so
%if %{enable_selinux}
%{_pam_moduledir}/pam_selinux.so
%{_pam_moduledir}/pam_sepermit.so
%endif
%{_pam_moduledir}/pam_shells.so
%{_pam_moduledir}/pam_stress.so
%{_pam_moduledir}/pam_succeed_if.so
%{_pam_moduledir}/pam_tally2.so
%{_pam_moduledir}/pam_time.so
%{_pam_moduledir}/pam_timestamp.so
%{_pam_moduledir}/pam_tty_audit.so
%{_pam_moduledir}/pam_umask.so
%{_pam_moduledir}/pam_unix.so
%{_pam_moduledir}/pam_unix_acct.so
%{_pam_moduledir}/pam_unix_auth.so
%{_pam_moduledir}/pam_unix_passwd.so
%{_pam_moduledir}/pam_unix_session.so
%{_pam_moduledir}/pam_warn.so
%{_pam_moduledir}/pam_wheel.so
%{_pam_moduledir}/pam_xauth.so
/sbin/mkhomedir_helper
/sbin/faillock
/sbin/pam_tally2
/sbin/pam_timestamp_check
%verify(not mode) %attr(4755,root,shadow) /sbin/unix_chkpwd
%verify(not mode) %attr(4755,root,shadow) /sbin/unix2_chkpwd
%attr(0700,root,root) /sbin/unix_update
%{_tmpfilesdir}/pam.conf

%files extra
%defattr(-,root,root,755)
%attr(755,root,root) %{_pam_moduledir}/pam_userdb.so
%attr(644,root,root) %doc %{_mandir}/man8/pam_userdb.8.gz

%files doc
%defattr(644,root,root,755)
%dir %{_defaultdocdir}/pam
%doc %{_defaultdocdir}/pam/html
%doc %{_defaultdocdir}/pam/modules
%doc %{_defaultdocdir}/pam/pdf
%doc %{_defaultdocdir}/pam/*.txt

%files devel
%defattr(644,root,root,755)
%dir /usr/include/security
%doc %{_mandir}/man3/pam*
%doc %{_mandir}/man3/misc_conv.3*
%{_includedir}/security/*.h
%{_libdir}/libpam.so
%{_libdir}/libpamc.so
%{_libdir}/libpam_misc.so
%{_rpmmacrodir}/macros.pam

%changelog
* Mon Aug 18 2025 valentin.lefebvre@suse.com
- Make sure that the buffer containing encrypted passwords get's erased
  bedore free.
- Replace to previous CVE fix which led to CPU performance issues.
  [bsc#1246221, CVE-2024-10041,
  + libpam-introduce-secure-memory-erasure-helpers.patch
  + pam_modutil_get-overwrite-password-at-free.patch
  - passverify-always-run-the-helper-to-obtain-shadow_pwd.patch]
* Thu Jun 12 2025 valentin.lefebvre@suse.com
- pam_namespace: convert functions that may operate on a user-controlled path
  to operate on file descriptors instead of absolute path. And keep the
  bind-mount protection from protect_mount() as a defense in depthmeasure.
  [bsc#1244509
  pam_inline-introduce-pam_asprintf-pam_snprintf-and-p.patch,
  pam_namespace-fix-potential-privilege-escalation.patch,
  pam_namespace-add-flags-to-indicate-path-safety.patch,
  pam_namespace-secure_opendir-do-not-look-at-the-grou.patch]
- pam_namespace-fix-potential-privilege-escalation.patch adapted and includes
  changes from upstream commits: ds6242a, bc856cd.
  * pam_namespace fix logic in return value handling
  * pam_namespace move functions around
* Fri May 16 2025 valentin.lefebvre@suse.com
- pam_env: Change the default to not read the user .pam_environment file
  [bsc#1243226, CVE-2025-6018,
  pam_env-change-the-default-to-not-read-the-user-env.patch]
* Fri Dec  6 2024 valentin.lefebvre@suse.com
- pam_unix/passverify: (get_account_info) [!HELPER_COMPILE]: Always return
  PAM_UNIX_RUN_HELPER instead of trying to obtain the shadow password file
  entry.
  [passverify-always-run-the-helper-to-obtain-shadow_pwd.patch, bsc#1232234,
  CVE-2024-10041]
- Do not reject the user with a hash assuming it's non-empty.
  [pam_unix-allow-empty-passwords-with-non-empty-hashes.patch]
* Mon Jul 22 2024 sbrabec@suse.com
- Prevent cursor escape from the login prompt [bsc#1194818]
  * Added: pam-bsc1194818-cursor-escape.patch
* Mon Jan  8 2024 valentin.lefebvre@suse.com
- Add missing O_DIRECTORY flag in `protect_dir()` for pam_namespace module.
  [bsc#1218475, pam-bsc1218475-pam_namespace-O_DIRECTORY-flag.patch]
* Fri Dec 29 2023 tabraham@suse.com
- pam_lastlog: check localtime_r() return value (bsc#1217000)
  * Added: pam-bsc1217000-pam_lastlog-check-localtime_r-return-value.patch
* Wed Sep  7 2022 valentin.lefebvre@suse.com
- Update pam_motd to the most current version. This fixes various issues
  and adds support for mot.d directories [jsc#PED-1712].
  * Added: pam-ped1712-pam_motd-directory-feature.patch
* Fri Apr  1 2022 josef.moellers@suse.com
- Do not include obsolete libselinux header files flask.h and
  av_permissions.h.
  [bsc#1197794, pam-bsc1197794-do-not-include-obsolete-header-files.patch]
* Wed Mar 16 2022 josef.moellers@suse.com
- Between allocating the variable "ai" and free'ing them, there are
  two "return NO" were we don't free this variable. This patch
  inserts freaddrinfo() calls before the "return NO;"s.
  [bsc#1197024, pam-bsc1197024-free-addrinfo-before-return.patch]
* Thu Feb 24 2022 josef.moellers@suse.com
- Define _pam_vendordir as "/%%{_sysconfdir}/pam.d"
  The variable is needed by systemd and others.
  [bsc#1196093, macros.pam]
* Thu Oct 21 2021 josef.moellers@suse.com
- Corrected a bad directive file which resulted in
  the "securetty" file to be installed as "macros.pam".
  [pam.spec]
* Thu Oct 14 2021 josef.moellers@suse.com
- Added tmpfiles for pam to set up directory for pam_faillock.
  [pam.conf]
* Wed Oct  6 2021 josef.moellers@suse.com
- Corrected macros.pam entry for %%_pam_moduledir
  Cleanup in pam.spec:
  * Replaced all references to ${_lib}/security in pam.spec by
  %%{_pam_moduledir}
  * Removed definition of (unused) "amdir".
* Wed Sep  1 2021 josef.moellers@suse.com
- Added new file macros.pam on request of systemd.
  [bsc#1190052, macros.pam]
* Wed Aug 25 2021 josef.moellers@suse.com
- Added pam_faillock to the set of modules.
  [jsc#sle-20638, pam-sle20638-add-pam_faillock.patch]
* Tue May 11 2021 josef.moellers@suse.com
- In the 32-bit compatibility package for 64-bit architectures,
  require "systemd-32bit" to be also installed as it contains
  pam_systemd.so for 32 bit applications.
  [bsc#1185562, baselibs.conf]
* Tue Apr  6 2021 josef.moellers@suse.com
- If "LOCAL" is configured in access.conf, and a login attempt from
  a remote host is made, pam_access tries to resolve "LOCAL" as
  a hostname and logs a failure.
  Checking explicitly for "LOCAL" and rejecting access in this case
  resolves this issue.
  [bsc#1184358, bsc1184358-prevent-LOCAL-from-being-resolved.patch]
* Wed Mar 10 2021 josef.moellers@suse.com
- pam_limits: "unlimited" is not a legitimate value for "nofile"
  (see setrlimit(2)). So, when "nofile" is set to one of the
  "unlimited" values, it is set to the contents of
  "/proc/sys/fs/nr_open" instead.
  Also changed the manpage of pam_limits to express this.
  [bsc#1181443, pam-bsc1181443-make-nofile-unlimited-mean-nr_open.patch]
* Mon Feb  8 2021 josef.moellers@suse.com
- Add a definition for pamdir to pam.spec
  So that a proper contents of macros.pam can be constructed.
  [pam.spec]
* Fri Jan 15 2021 josef.moellers@suse.com
- Create macros.pam with definition of %%_pamdir so packages which
  are commonly shared between Factory and SLE can use this macro
  [pam.spec]
* Thu Nov 19 2020 josef.moellers@suse.com
- pam_cracklib: added code to check whether the password contains
  a substring of of the user's name of at least <N> characters length
  in some form.
  This is enabled by the new parameter "usersubstr=<N>"
  See https://github.com/libpwquality/libpwquality/commit/bfef79dbe6aa525e9557bf4b0a61e6dde12749c4
  [jsc#SLE-16719, jsc#SLE-16720, pam-pam_cracklib-add-usersubstr.patch]
* Wed Nov 18 2020 josef.moellers@suse.com
- pam_xauth.c: do not free() a string which has been (successfully)
  passed to putenv().
  [bsc#1177858, pam-bsc1177858-dont-free-environment-string.patch]
* Fri Nov 13 2020 josef.moellers@suse.com
- Initialize pam_unix pam_sm_acct_mgmt() local variable "daysleft"
  to avoid spurious (and misleading)
    Warning: your password will expire in ... days.
  fixed upstream with commit db6b293046a
  [bsc#1178727, pam-bsc1178727-initialize-daysleft.patch]
* Thu Oct 15 2020 josef.moellers@suse.com
- /usr/bin/xauth chokes on the old user's $HOME being on an NFS
  file system. Run /usr/bin/xauth using the old user's uid/gid
  Patch courtesy of Dr. Werner Fink.
  [bsc#1174593, pam-xauth_ownership.patch]
* Fri Mar 20 2020 josef.moellers@suse.com
- Moved pam_userdb to a separate package pam-extra.
  [bsc#1166510, pam.spec]
* Fri Mar 13 2020 meissner@suse.com
- disable libdb usage and pam_userdb again, as this causes some license
  conflicts. (bsc#1166510)
* Fri Feb 21 2020 josef.moellers@suse.com
- Add libdb as build-time dependency to enable pam_userdb module.
  Enable pam_userdb.so
  [jsc#sle-7258, bsc#1164562, pam.spec]
* Mon Nov 19 2018 josef.moellers@suse.com
- When comparing an incoming IP address with an entry in
  access.conf that only specified a single host (ie no netmask),
  the incoming IP address was used rather than the IP address from
  access.conf, effectively comparing the incoming address with
  itself.  (Also fixed a small typo while I was at it)
  [bsc#1115640, use-correct-IP-address.patch, CVE-2018-17953]
* Thu Oct 11 2018 josef.moellers@suse.com
- Remove limits for nproc from /etc/security/limits.conf
  ie remove pam-limit-nproc.patch
  [bsc#1110700, pam-limit-nproc.patch]
* Thu May  3 2018 josef.moellers@suse.com
- pam_umask.8 needed to be patched as well.
  [bsc#1089884, pam-fix-config-order-in-manpage.patch]
* Wed May  2 2018 josef.moellers@suse.com
- Changed order of configuration files to reflect actual code.
  [bsc#1089884, pam-fix-config-order-in-manpage.patch]
* Thu Feb 22 2018 fvogt@suse.com
- Use %%license (boo#1082318)
* Thu Oct 12 2017 schwab@suse.de
- Prerequire group(shadow), user(root)
* Fri Jan 27 2017 josef.moellers@suse.com
- Allow symbolic hostnames in access.conf file.
  [pam-hostnames-in-access_conf.patch, boo#1019866]
* Thu Dec  8 2016 josef.moellers@suse.com
- Increased nproc limits for non-privileged users to 4069/16384.
  Removed limits for "root".
  [pam-limit-nproc.patch, bsc#1012494, bsc#1013706]
* Sun Jul 31 2016 develop7@develop7.info
- pam-limit-nproc.patch: increased process limit to help
  Chrome/Chromuim users with really lots of tabs. New limit gets
  closer to UserTasksMax parameter in logind.conf
* Thu Jul 28 2016 kukuk@suse.de
- Add doc directory to filelist.
* Mon May  2 2016 kukuk@suse.de
- Remove obsolete README.pam_tally [bsc#977973]
* Thu Apr 28 2016 kukuk@suse.de
- Update Linux-PAM to version 1.3.0
- Rediff encryption_method_nis.diff
- Link pam_unix against libtirpc and external libnsl to enable
  IPv6 support.
* Thu Apr 14 2016 kukuk@suse.de
- Add /sbin/unix2_chkpwd (moved from pam-modules)
* Mon Apr 11 2016 kukuk@suse.de
- Remove (since accepted upstream):
  - 0001-Remove-YP-dependencies-from-pam_access-they-were-nev.patch
  - 0002-Remove-enable-static-modules-option-and-support-from.patch
  - 0003-fix-nis-checks.patch
  - 0004-PAM_EXTERN-isn-t-needed-anymore-but-don-t-remove-it-.patch
  - 0005-Use-TI-RPC-functions-if-we-compile-and-link-against-.patch
* Fri Apr  1 2016 kukuk@suse.de
- Add 0005-Use-TI-RPC-functions-if-we-compile-and-link-against-.patch
  - Replace IPv4 only functions
* Fri Apr  1 2016 kukuk@suse.de
- Fix typo in common-account.pamd [bnc#959439]
* Tue Mar 29 2016 kukuk@suse.de
- Add 0004-PAM_EXTERN-isn-t-needed-anymore-but-don-t-remove-it-.patch
  - readd PAM_EXTERN for external PAM modules
* Wed Mar 23 2016 kukuk@suse.de
- Add 0001-Remove-YP-dependencies-from-pam_access-they-were-nev.patch
- Add 0002-Remove-enable-static-modules-option-and-support-from.patch
- Add 0003-fix-nis-checks.patch
* Sat Jul 25 2015 joschibrauchle@gmx.de
- Add folder /etc/security/limits.d as mentioned in 'man pam_limits'
* Fri Jun 26 2015 kukuk@suse.de
- Update to version 1.2.1
  - security update for CVE-2015-3238
* Mon Apr 27 2015 kukuk@suse.de
- Update to version 1.2.0
  - obsoletes Linux-PAM-git-20150109.diff
* Fri Jan  9 2015 kukuk@suse.de
- Re-add lost patch encryption_method_nis.diff [bnc#906660]
* Fri Jan  9 2015 kukuk@suse.de
- Update to current git:
  - Linux-PAM-git-20150109.diff replaces Linux-PAM-git-20140127.diff
  - obsoletes pam_loginuid-log_write_errors.diff
  - obsoletes pam_xauth-sigpipe.diff
  - obsoletes bug-870433_pam_timestamp-fix-directory-traversal.patch
* Fri Jan  9 2015 bwiedemann@suse.com
- increase process limit to 1200 to help chromium users with many tabs
* Tue May  6 2014 bwiedemann@suse.com
- limit number of processes to 700 to harden against fork-bombs
  Add pam-limit-nproc.patch
* Wed Apr  9 2014 ckornacker@suse.com
- Fix CVE-2014-2583: pam_timestamp path injection (bnc#870433)
  bug-870433_pam_timestamp-fix-directory-traversal.patch
* Tue Apr  1 2014 ckornacker@suse.com
- adding sclp_line0/ttysclp0 to /etc/securetty on s390 (bnc#869664)
* Mon Jan 27 2014 kukuk@suse.de
- Add pam_loginuid-log_write_errors.diff: log significant loginuid
  write errors
- pam_xauth-sigpipe.diff: avoid potential SIGPIPE when writing to
  xauth process
* Mon Jan 27 2014 kukuk@suse.de
- Update to current git (Linux-PAM-git-20140127.diff), which
  obsoletes pam_loginuid-part1.diff, pam_loginuid-part2.diff and
  Linux-PAM-git-20140109.diff.
  - Fix gratuitous use of strdup and x_strdup
  - pam_xauth: log fatal errors preventing xauth process execution
  - pam_loginuid: cleanup loginuid buffer initialization
  - libpam_misc: fix an inconsistency in handling memory allocation errors
  - pam_limits: fix utmp->ut_user handling
  - pam_mkhomedir: check and create home directory for the same user
  - pam_limits: detect and ignore stale utmp entries
- Disable pam_userdb (remove db-devel from build requires)
* Fri Jan 10 2014 kukuk@suse.com
- Add pam_loginuid-part1.diff: Ignore missing /proc/self/loginuid
- Add pam_loginuid-part2.diff: Workaround to run pam_loginuid inside lxc
* Thu Jan  9 2014 kukuk@suse.de
- Update to current git (Linux-PAM-git-20140109.diff, which
  replaces pam_unix.diff and encryption_method_nis.diff)
  - pam_access: fix debug level logging
  - pam_warn: log flags passed to the module
  - pam_securetty: check return value of fgets
  - pam_lastlog: fix format string
  - pam_loginuid: If the correct loginuid is already set, skip writing it
* Fri Nov 29 2013 schwab@linux-m68k.org
- common-session.pamd: add missing newline
* Thu Nov 28 2013 kukuk@suse.de
- Remove libtrpc support to solve dependency/build cycles, plain
  glibc is enough for now.
* Tue Nov 12 2013 kukuk@suse.de
- Add encryption_method_nis.diff:
  - implement pam_unix2 functionality to use another hash for
    NIS passwords.
* Fri Nov  8 2013 kukuk@suse.de
- Add pam_unix.diff:
  - fix if /etc/login.defs uses DES
  - ask always for old password if a NIS password will be changed
* Sat Sep 28 2013 mc@suse.com
- fix manpages links (bnc#842872) [fix-man-links.dif]
* Fri Sep 20 2013 hrvoje.senjan@gmail.com
- Explicitly add pam_systemd.so to list of modules in
  common-session.pamd (bnc#812462)
* Fri Sep 20 2013 kukuk@suse.de
- Update to official release 1.1.8 (1.1.7 + git-20130916.diff)
- Remove needless pam_tally-deprecated.diff patch
* Mon Sep 16 2013 kukuk@suse.de
- Replace fix-compiler-warnings.diff with current git snapshot
  (git-20130916.diff) for pam_unix.so:
  - fix glibc warnings
  - fix syntax error in SELinux code
  - fix crash at login
* Thu Sep 12 2013 kukuk@suse.de
- Remove pam_unix-login.defs.diff, not needed anymore
* Thu Sep 12 2013 kukuk@suse.de
- Update to version 1.1.7 (bugfix release)
  - Drop missing-DESTDIR.diff and pam-fix-includes.patch
  - fix-compiler-warnings.diff: fix unchecked setuid return code
* Tue Aug  6 2013 mc@suse.de
- adding hvc0-hvc7 to /etc/securetty on s390 (bnc#718516)
* Mon May 27 2013 kukuk@suse.de
- Fix typo in common-password [bnc#821526]
* Fri Apr 26 2013 mmeister@suse.com
- Added libtool as BuildRequire, and autoreconf -i option to fix
  build with new automake
* Tue Feb  5 2013 kukuk@suse.de
- Update pam_unix-login.defs.diff patch to the final upstream
  version.
* Tue Feb  5 2013 kukuk@suse.de
- Adjust URL
- Add set_permission macro and PreReq
- Read default encryption method from /etc/login.defs
  (pam_unix-login.defs.diff)
* Fri Jan 25 2013 kukuk@suse.com
- Remove deprecated pam_tally.so module, it's too buggy and can
  destroy config and log files.
* Mon Nov 12 2012 kukuk@suse.de
- Sync common-*.pamd config with pam-config (use pam_unix.so as
  default).
* Wed Sep 19 2012 kukuk@suse.de
- Fix building in Factory (add patch missing-DESTDIR.diff)
* Fri Sep 14 2012 kukuk@suse.de
- Update to Linux-PAM 1.1.6
  - Update translations
  - pam_cracklib: Add more checks for weak passwords
  - pam_lastlog: Never lock out root
  - Lot of bug fixes and smaller enhancements
* Thu Jun 21 2012 aj@suse.de
- Include correct headers for getrlimit (add patch pam-fix-includes.patch).
* Mon Apr 23 2012 jengelh@medozas.de
- Update homepage URL in specfile
* Sat Mar  3 2012 jengelh@medozas.de
- Update to new upstream release 1.1.5
  * pam_env: Fix CVE-2011-3148: correctly count leading whitespace
  when parsing environment file in pam_env
  * Fix CVE-2011-3149: when overflowing, exit with PAM_BUF_ERR in
  pam_env
  * pam_access: Add hostname resolution cache
* Tue Oct 25 2011 mc@suse.de
- pam_tally2: remove invalid options from manpage (bnc#726071)
- fix possible overflow and DOS in pam_env (bnc#724480)
  CVE-2011-3148, CVE-2011-3149
* Mon Jun 27 2011 kukuk@suse.de
- Update to version 1.1.4
  * pam_securetty: Honour console= kernel option, add noconsole option
  * pam_limits: Add %%group syntax, drop change_uid option, add set_all option
  * Lot of small bug fixes
  * Add support for libtirpc
- Build against libtirpc
* Thu May 26 2011 cfarrell@novell.com
- license update: GPL-2.0+ or BSD-3-Clause
  Updating to spdx.org/licenses syntax as legal-auto for some reason did
  not accept the previous spec file license
* Wed May 25 2011 kukuk@suse.de
- Remove libxcrypt-devel from BuildRequires
* Wed Feb 23 2011 vcizek@novell.com
- bnc#673826 rework
  * manpage is left intact, as it was
  * correct parsing of "quiet" option
* Wed Feb 23 2011 vcizek@novell.com
- fix for bnc#673826 (pam_listfile)
  * removed unnecessary logging when listfile is missing and quiet
  option is specified
  * manpage is also updated, to reflect that all option
  require values
* Thu Oct 28 2010 kukuk@suse.de
- Update to Linux-PAM 1.1.3
  - fixes CVE-2010-3853, CVE-2010-3431, CVE-2010-3430
  - pam_unix: Add minlen option, change default from 6 to 0
* Tue Aug 31 2010 kukuk@suse.de
- Update to Linux-PAM 1.1.2
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Mon May 10 2010 kukuk@suse.de
- Update to current CVS version (pam_rootok: Add support for
  chauthtok and acct_mgmt, [bnc#533249])
* Thu Mar 11 2010 kukuk@suse.de
- Install correct documentation
* Wed Dec 16 2009 kukuk@suse.de
- Update to Linux-PAM 1.1.1 (bug fix release)
* Sat Dec 12 2009 jengelh@medozas.de
- add baselibs.conf as a source
* Wed Dec  9 2009 jengelh@medozas.de
- enable parallel building
* Fri Jun 26 2009 kukuk@suse.de
- Add fixes from CVS
* Wed Jun 24 2009 kukuk@suse.de
- Update to final version 1.1.0 (spelling fixes)
* Tue May  5 2009 kukuk@suse.de
- Update to version 1.0.92:
  * Update translations
  * pam_succeed_if: Use provided username
  * pam_mkhomedir: Fix handling of options
* Fri Apr  3 2009 rguenther@suse.de
- Remove cracklib-dict-full and pwdutils BuildRequires again.
* Fri Mar 27 2009 kukuk@suse.de
- Update to version 1.0.91 aka 1.1 Beta2:
  * Changes in the behavior of the password stack. Results of
    PRELIM_CHECK are not used for the final run.
  * Redefine LOCAL keyword of pam_access configuration file
  * Add support for try_first_pass and use_first_pass to
    pam_cracklib
  * New password quality tests in pam_cracklib
  * Add support for passing PAM_AUTHTOK to stdin of helpers from
    pam_exec
  * New options for pam_lastlog to show last failed login attempt and
    to disable lastlog update
  * New pam_pwhistory module to store last used passwords
  * New pam_tally2 module similar to pam_tally with wordsize independent
    tally data format, obsoletes pam_tally
  * Make libpam not log missing module if its type is prepended with '-'
  * New pam_timestamp module for authentication based on recent successful
    login.
  * Add blowfish support to pam_unix.
  * Add support for user specific environment file to pam_env.
  * Add pam_get_authtok to libpam as Linux-PAM extension.
* Wed Feb 11 2009 ro@suse.de
- use sr@latin instead of sr@Latn
* Thu Feb  5 2009 kukuk@suse.de
- Log failures of setrlimit in pam_limits [bnc#448314]
- Fix using of requisite in password stack [bnc#470337]
* Tue Jan 20 2009 kukuk@suse.de
- Regenerate documentation [bnc#448314]
* Wed Dec 10 2008 olh@suse.de
- use Obsoletes: -XXbit only for ppc64 to help solver during distupgrade
  (bnc#437293)
* Thu Dec  4 2008 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Thu Nov 27 2008 mc@suse.de
- enhance the man page for limits.conf (bnc#448314)
* Mon Nov 24 2008 kukuk@suse.de
- pam_time: fix parsing if '|' is used [bdo#326407]
* Wed Nov 19 2008 kukuk@suse.de
- pam_xauth: update last patch
- pam_pwhistory: add missing type option
* Tue Nov  4 2008 mc@suse.de
- pam_xauth: put XAUTHLOCALHOSTNAME into new enviroment
  (bnc#441314)
* Fri Oct 17 2008 kukuk@suse.de
- Add pam_tally2
- Regenerate Documentation
* Sat Oct 11 2008 kukuk@suse.de
- Enhance pam_lastlog with status output
- Add pam_pwhistory as tech preview
* Fri Sep 26 2008 kukuk@suse.de
- pam_tally: fix fd leak
- pam_mail: fix "quiet" option
* Fri Aug 29 2008 kukuk@suse.de
- Update to version 1.0.2 (fix SELinux regression)
- enhance pam_tally [FATE#303753]
- Backport fixes from CVS
* Wed Aug 20 2008 prusnak@suse.cz
- enabled SELinux support [Fate#303662]
* Wed Apr 16 2008 kukuk@suse.de
- Update to version 1.0.1:
  - Fixes regression in pam_set_item().
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Fri Apr  4 2008 kukuk@suse.de
- Remove devfs lines from securetty [bnc#372241]
* Thu Apr  3 2008 kukuk@suse.de
- Update to version 1.0.0:
  - Official first "stable" release
  - bug fixes
  - translation updates
* Fri Feb 15 2008 kukuk@suse.de
- Update to version 0.99.10.0:
  - New substack directive in config file syntax
  - New module pam_tty_audit.so for enabling and disabling tty
    auditing
  - New PAM items PAM_XDISPLAY and PAM_XAUTHDATA
  - Improved functionality of pam_namespace.so module (method flags,
    namespace.d configuration directory, new options).
  - Finaly removed deprecated pam_rhosts_auth module.
* Wed Oct 10 2007 kukuk@suse.de
- Update to version 0.99.9.0:
  - misc_conv no longer blocks SIGINT; applications that don't want
    user-interruptable prompts should block SIGINT themselves
  - Merge fixes from Debian
  - Fix parser for pam_group and pam_time
* Wed Jul 18 2007 kukuk@suse.de
- Update to version 0.99.8.1:
  - Fix regression in pam_audit
* Fri Jul  6 2007 kukuk@suse.de
- Update to version 0.99.8.0:
  - Add translations for ar, ca, da, ru, sv and zu.
  - Update hungarian translation.
  - Add support for limits.d directory to pam_limits.
  - Add minclass option to pam_cracklib
  - Add new group syntax to pam_access
* Thu Apr 19 2007 mc@suse.de
- move the documentation into a seperate package (pam-doc)
  [partly fixes Bug #265733]
* Mon Mar 26 2007 rguenther@suse.de
- add flex and bison BuildRequires
* Wed Jan 24 2007 mc@suse.de
- add %%verify_permissions for /sbin/unix_chkpwd
  [#237625]
* Tue Jan 23 2007 kukuk@suse.de
- Update to Version 0.99.7.1 (security fix)
* Wed Jan 17 2007 kukuk@suse.de
- Update to Version 0.99.7.0
  * Add manual page for pam_unix.so.
  * Add pam_faildelay module to set pam_fail_delay() value.
  * Fix possible seg.fault in libpam/pam_set_data().
  * Cleanup of configure options.
  * Update hungarian translation, fix german translation.
* Wed Jan 17 2007 lnussel@suse.de
- install unix_chkpwd setuid root instead of setgid shadow (#216816)
* Tue Oct 24 2006 kukuk@suse.de
- pam_unix.so/unix_chkpwd: teach about blowfish [#213929]
- pam_namespace.so: Fix two possible buffer overflow
- link against libxcrypt
* Sat Oct  7 2006 kukuk@suse.de
- Update hungarian translation [#210091]
* Tue Sep 19 2006 kukuk@suse.de
- Don't remove pam_unix.so
- Use cracklib again (goes lost with one of the last cleanups)
* Thu Sep 14 2006 kukuk@suse.de
- Add pam_umask.so to common-session [Fate#3621]
* Wed Sep  6 2006 kukuk@suse.de
- Update to Linux-PAM 0.99.6.3 (merges all patches)
* Wed Aug 30 2006 kukuk@suse.de
- Update to Linux-PAM 0.99.6.2 (incorporate last change)
- Add pam_loginuid and fixes from CVS [Fate#300486]
* Wed Aug 23 2006 kukuk@suse.de
- Fix seg.fault in pam_cracklib if retyped password is empty
* Tue Aug 22 2006 kukuk@suse.de
- Remove use_first_pass from pam_unix2.so in password section
* Fri Aug 11 2006 kukuk@suse.de
- Update to Linux-PAM 0.99.6.1 (big documentation update)
* Fri Jul 28 2006 kukuk@suse.de
- Add missing namespace.init script
* Thu Jul 27 2006 kukuk@suse.de
- Reenable audit subsystem [Fate#300486]
* Wed Jun 28 2006 kukuk@suse.de
- Update to Linux-PAM 0.99.5.0 (more manual pages, three new PAM
  modules: pam_keyinit, pam_namespace, pam_rhosts)
* Mon Jun 12 2006 kukuk@suse.de
- Update to current CVS (lot of new manual pages and docu)
* Tue May 30 2006 kukuk@suse.de
- Update to Linux-PAM 0.99.4.0 (merge all patches and translations)
* Wed May 24 2006 kukuk@suse.de
- Fix problems found by Coverity
* Wed May 17 2006 schwab@suse.de
- Don't strip binaries.
* Fri May  5 2006 kukuk@suse.de
- Fix pam_tally LFS support [#172492]
* Fri Apr 21 2006 kukuk@suse.de
- Update fr.po and pl.po
* Tue Apr 11 2006 kukuk@suse.de
- Update km.po
* Tue Apr  4 2006 kukuk@suse.de
- Remove obsolete pam-laus from the system
* Mon Mar 27 2006 kukuk@suse.de
- Update translations for pt, pl, fr, fi and cs
- Add translation for uk
* Tue Mar 21 2006 kukuk@suse.de
- Update hu.po
* Tue Mar 21 2006 kukuk@suse.de
- Add translation for tr
* Mon Mar 13 2006 kukuk@suse.de
- Fix order of NULL checks in pam_get_user
- Fix comment in pam_lastlog for translators to be visible in
  pot file
- Docu update, remove pam_selinux docu
* Thu Mar  2 2006 kukuk@suse.de
- Update km translation
* Thu Feb 23 2006 kukuk@suse.de
- pam_lastlog:
  - Initialize correct struct member [SF#1427401]
  - Mark strftime fmt string for translation [SF#1428269]
* Sun Feb 19 2006 kukuk@suse.de
- Update more manual pages
* Sat Feb 18 2006 ro@suse.de
- really disable audit if header file not present
* Tue Feb 14 2006 kukuk@suse.de
- Update fi.po
- Add km.po
- Update pl.po
* Mon Feb 13 2006 kukuk@suse.de
- Update with better manual pages
* Thu Feb  9 2006 kukuk@suse.de
- Add translation for nl, update pt translation
* Fri Jan 27 2006 kukuk@suse.de
- Move devel manual pages to -devel package
- Mark PAM config files as noreplace
- Mark /etc/securetty as noreplace
- Run ldconfig
- Fix libdb/ndbm compat detection with gdbm
- Adjust german translation
- Add all services to pam_listfile
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Fri Jan 13 2006 kukuk@suse.de
- Update to Linux-PAM 0.99.3.0 release candiate tar balls
  (new translations)
* Mon Jan  9 2006 kukuk@suse.de
- Fix NULL handling for LSB-pam test suite [#141240]
* Sun Jan  8 2006 kukuk@suse.de
- Fix usage of PAM_AUTHTOK_RECOVER_ERR vs. PAM_AUTHTOK_RECOVERY_ERR
* Fri Jan  6 2006 kukuk@suse.de
- NULL is allowed as thirs argument for pam_get_item [#141240]
* Wed Dec 21 2005 kukuk@suse.de
- Add fixes from CVS
* Thu Dec 15 2005 kukuk@suse.de
- Fix pam_lastlog: don't report error on first login
* Tue Dec 13 2005 kukuk@suse.de
- Update to 0.99.2.1
* Fri Dec  9 2005 kukuk@suse.de
- Add /etc/environment to avoid warnings in syslog
* Mon Dec  5 2005 kukuk@suse.de
- disable SELinux
* Wed Nov 23 2005 kukuk@suse.de
- Update getlogin() fix to final one
* Mon Nov 21 2005 kukuk@suse.de
- Fix PAM getlogin() implementation
* Mon Nov 21 2005 kukuk@suse.de
- Update to official 0.99.2.0 release
* Tue Nov  8 2005 kukuk@suse.de
- Update to new snapshot
* Mon Oct 10 2005 kukuk@suse.de
- Enable original pam_wheel module
* Tue Sep 27 2005 kukuk@suse.de
- Update to current CVS
- Compile libpam_misc with -fno-strict-aliasing
* Mon Sep 19 2005 kukuk@suse.de
- Update to current CVS
- Fix compiling of pammodutil with -fPIC
* Sun Sep 18 2005 kukuk@suse.de
- Update to current CVS
* Tue Aug 23 2005 kukuk@suse.de
- Update to new snapshot (Major version is back to 0)
* Fri Aug 19 2005 kukuk@suse.de
- Update to Linux-PAM 0.99.0.3 snapshot
* Mon Jul 11 2005 kukuk@suse.de
- Add pam_umask
* Mon Jul  4 2005 kukuk@suse.de
- Update to current CVS snapshot
* Thu Jun 23 2005 kukuk@suse.de
- Update to current CVS snapshot
- Add pam_loginuid
* Thu Jun  9 2005 kukuk@suse.de
- Update to current CVS snapshot
* Mon Jun  6 2005 kukuk@suse.de
- Don't reset priority [#81690]
- Fix creating of symlinks
* Fri May 20 2005 kukuk@suse.de
- Update to current CVS snapshot
- Real fix for [#82687] (don't include kernel header files)
* Thu May 12 2005 schubi@suse.de
- Bug 82687 - pam_client.h redefines __u8 and __u32
* Fri Apr 29 2005 kukuk@suse.de
- Apply lot of fixes from CVS (including SELinux support)
* Fri Apr  1 2005 kukuk@suse.de
- Update to final 0.79 release
* Mon Mar 14 2005 kukuk@suse.de
- Apply patch for pam_xauth to preserve DISPLAY variable [#66885]
* Mon Jan 24 2005 kukuk@suse.de
- Compile with large file support
* Mon Jan 24 2005 schubi@suse.de
- Made patch of latest CVS tree
- Removed patch pam_handler.diff ( included in CVS now )
- moved Linux-PAM-0.78.dif to pam_group_time.diff
* Wed Jan  5 2005 kukuk@suse.de
- Fix seg.fault, if a PAM config line is incomplete
* Thu Nov 18 2004 kukuk@suse.de
- Update to final 0.78
* Mon Nov  8 2004 kukuk@suse.de
- Add pam_env.so to common-auth
- Add pam_limit.so to common-session
* Wed Oct 13 2004 kukuk@suse.de
- Update to 0.78-Beta1
* Wed Sep 22 2004 kukuk@suse.de
- Create pam.d/common-{auth,account,password,session} and include
  them in pam.d/other
- Update to current CVS version of upcoming 0.78 release
* Mon Aug 23 2004 kukuk@suse.de
- Update "code cleanup" patch
- Disable reading of /etc/environment in pam_env.so per default
* Thu Aug 19 2004 kukuk@suse.de
- Reenable a "fixed" version of "code cleanup" patch
- Use pam_wheel from pam-modules package
* Wed Aug 18 2004 kukuk@suse.de
- Disable "code cleanup" patch (no more comments about security
  fixes)
* Fri Aug 13 2004 kukuk@suse.de
- Apply big "code cleanup" patch [Bug #39673]
* Fri Mar 12 2004 kukuk@suse.de
- pam_wheel: Use original getlogin again, PAM internal does not
  work without application help [Bug #35682]
* Sun Jan 18 2004 meissner@suse.de
- We no longer have pam in the buildsystem, so we
  need some buildroot magic flags for the dlopen tests.
* Thu Jan 15 2004 kukuk@suse.de
- Cleanup neededforbuild
* Fri Dec  5 2003 kukuk@suse.de
- Add manual pages from SLES8
* Fri Nov 28 2003 kukuk@suse.de
- Fix installing manual pages of modules
- Remove pthread check (db is now linked against pthread)
* Thu Nov 27 2003 kukuk@suse.de
- Merge with current CVS
- Apply bug fixes from bugtracking system
- Build as normal user
* Fri Nov 21 2003 kukuk@suse.de
- Compile with noexecstack
* Thu Nov  6 2003 kukuk@suse.de
- Fix pam_securetty CVS patch
* Wed Oct 29 2003 kukuk@suse.de
- Sync with current CVS version
* Thu Oct  2 2003 kukuk@suse.de
- Add patch to implement "include" statement in pamd files
* Wed Sep 10 2003 uli@suse.de
- added ttyS1 (VT220) to securetty on s390* (bug #29239)
* Mon Jul 28 2003 kukuk@suse.de
- Apply lot of fixes for various problems
* Tue Jun 10 2003 kukuk@suse.de
- Fix getlogin handling in pam_wheel.so
* Tue May 27 2003 ro@suse.de
- added cracklib-devel to neededforbuild
* Thu Feb 13 2003 kukuk@suse.de
- Update pam_localuser and pam_xauth.
* Wed Nov 13 2002 kukuk@suse.de
- Update to Linux-PAM 0.77 (minor bug fixes and enhancemants)
* Mon Nov 11 2002 ro@suse.de
- changed neededforbuild <sp> to <opensp>
* Sat Sep 14 2002 ro@suse.de
- changed securetty / use extra file
* Fri Sep 13 2002 bk@suse.de
- 390: standard console (4,64)/ttyS0 ->only ttyS0 in /etc/securetty
* Tue Aug 27 2002 kukuk@suse.de
- Call password checking helper from pam_unix.so whenever the
  passwd field is invalid.
* Sat Aug 24 2002 kukuk@suse.de
- Don't build ps and pdf documentation
* Fri Aug  9 2002 kukuk@suse.de
- pam-devel requires pam [Bug #17543]
* Wed Jul 17 2002 kukuk@suse.de
- Remove explicit requires
* Wed Jul 10 2002 kukuk@suse.de
- Update to Linux-PAM 0.76
- Remove reentrant patch for original PAM modules (needs to be
  rewritten for new PAM version)
- Add docu in PDF format
* Thu Jul  4 2002 kukuk@suse.de
- Fix build on different partitions
* Tue Apr 16 2002 mmj@suse.de
- Fix to not own /usr/shar/man/man3
* Wed Mar 13 2002 kukuk@suse.de
- Add /usr/include/security to pam-devel filelist
* Mon Feb 11 2002 ro@suse.de
- tar option for bz2 is "j"
* Fri Jan 25 2002 kukuk@suse.de
- Fix last pam_securetty patch
* Thu Jan 24 2002 kukuk@suse.de
- Use reentrant getpwnam functions for most modules
- Fix unresolved symbols in pam_access and pam_userdb
* Sun Jan 20 2002 kukuk@suse.de
- libpam_misc: Don't handle Ctrl-D as error.
* Wed Jan 16 2002 kukuk@suse.de
- Remove SuSEconfig.pam
- Update pam_localuser and pam_xauth
- Add new READMEs about blowfish and cracklib
* Mon Nov 12 2001 kukuk@suse.de
- Remove pam_unix.so (is part of pam-modules)
* Fri Nov  9 2001 kukuk@suse.de
- Move extra PAM modules to separate package
- Require pam-modules package
* Fri Aug 24 2001 kukuk@suse.de
- Move susehelp config file to susehelp package
* Mon Aug 13 2001 ro@suse.de
- changed neededforbuild <sp_libs> to <sp-devel>
* Tue Aug  7 2001 kukuk@suse.de
- Fixes wrong symlink handling of pam_homecheck [Bug #3905]
* Wed Jul 11 2001 kukuk@suse.de
- Sync pam_homecheck and pam_unix2 fixes from 7.2
- Always ask for the old password if it is expired
* Sat May  5 2001 kukuk@suse.de
- Cleanup Patches, make tar archive from extra pam modules
* Fri May  4 2001 kukuk@suse.de
- Use LOG_NOTICE for trace option [Bug #7673]
* Thu Apr 12 2001 kukuk@suse.de
- Linux-PAM: link pam_access against libnsl
- Add pam.conf for susehelp/pam html docu
* Tue Apr 10 2001 kukuk@suse.de
- Linux-PAM: Update to version 0.75
* Tue Apr  3 2001 kukuk@suse.de
- Linux-PAM: link libpam_misc against libpam [Bug #6890]
* Thu Mar  8 2001 kukuk@suse.de
- Linux-PAM: Fix manual pages (.so reference)
- pam_pwcheck: fix Makefile
* Tue Mar  6 2001 kukuk@suse.de
- Update for Linux-PAM 0.74
- Drop pwdb subpackage
* Tue Feb 13 2001 kukuk@suse.de
- pam_unix2: Create temp files with permission 0600
* Tue Feb  6 2001 ro@suse.de
- pam_issue.c: include time.h to make it compile
* Fri Jan  5 2001 kukuk@suse.de
- Don't print error message about failed initialization from
  pam_limits with kernel 2.2 [Bug #5198]
* Thu Jan  4 2001 kukuk@suse.de
- Adjust docu for pam_limits
* Sun Dec 17 2000 kukuk@suse.de
- Adjust docu for pam_pwcheck
* Thu Dec  7 2000 kukuk@suse.de
- Add fix for pam_limits from 0.73
* Thu Oct 26 2000 kukuk@suse.de
- Add db-devel to need for build
* Fri Oct 20 2000 kukuk@suse.de
- Don't link PAM modules against old libpam library
* Wed Oct 18 2000 kukuk@suse.de
- Create new "devel" subpackage
* Thu Oct 12 2000 kukuk@suse.de
- Add SuSEconfig.pam
* Tue Oct  3 2000 kukuk@suse.de
- Fix problems with new gcc and glibc 2.2 header files
* Wed Sep 13 2000 kukuk@suse.de
- Fix problem with passwords longer then PASS_MAX_LEN
* Wed Sep  6 2000 kukuk@suse.de
- Add missing PAM modules to filelist
- Fix seg.fault in pam_pwcheck [BUG #3894]
- Clean spec file
* Fri Jun 23 2000 kukuk@suse.de
- Lot of bug fixes in pam_unix2 and pam_pwcheck
- compress postscript docu
* Mon May 15 2000 kukuk@suse.de
- Move docu to /usr/share/doc/pam
- Fix some bugs in pam_unix2 and pam_pwcheck
* Tue Apr 25 2000 kukuk@suse.de
- Add pam_homecheck Module
* Tue Apr 25 2000 kukuk@suse.de
- Add devfs devices to /etc/securetty
* Wed Mar  1 2000 kukuk@suse.de
- Fix handling of changing passwords to empty one
* Tue Feb 22 2000 kukuk@suse.de
- Set correct attr for unix_chkpwd and pwdb_chkpwd
* Tue Feb 15 2000 kukuk@suse.de
- Update pam_pwcheck
- Update pam_unix2
* Mon Feb  7 2000 kukuk@suse.de
- pwdb: Update to 0.61
* Thu Jan 27 2000 kukuk@suse.de
- Add config files and README for md5 passwords
- Update pam_pwcheck
- Update pam_unix2
* Thu Jan 13 2000 kukuk@suse.de
- Update pam_unix2
- New: pam_pwcheck
- Update to Linux-PAM 0.72
* Wed Oct 13 1999 kukuk@suse.de
- pam_pwdb: Add security fixes from RedHat
* Mon Oct 11 1999 kukuk@suse.de
- Update to Linux-PAM 0.70
- Update to pwdb-0.60
- Fix more pam_unix2 shadow bugs
* Fri Oct  8 1999 kukuk@suse.de
- Add more PAM fixes
- Implement Password changing request (sp_lstchg == 0)
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Sat Sep 11 1999 kukuk@suse.de
- Add pam_wheel to file list
- pam_wheel: Minor fixes
- pam_unix2: root is allowed to change passwords with wrong
    password aging information
* Mon Aug 30 1999 kukuk@suse.de
- pam_unix2: Fix typo
* Thu Aug 19 1999 kukuk@suse.de
- Linux-PAM: Update to version 0.69
* Fri Jul 16 1999 kukuk@suse.de
- pam_unix2: Root is allowed to use the old password again.
* Tue Jul 13 1999 kukuk@suse.de
- pam_unix2: Allow root to set an empty password.
* Sat Jul 10 1999 kukuk@suse.de
- Add HP-UX password aging to pam_unix2.
* Wed Jul  7 1999 kukuk@suse.de
- Don't install .cvsignore files
- Make sure, /etc/shadow has the correct rights
* Tue Jul  6 1999 kukuk@suse.de
- Update to Linux-PAM 0.68
* Wed Jun 30 1999 kukuk@suse.de
- pam_unix2: more bug fixes
* Tue Jun 29 1999 kukuk@suse.de
- pam_unix2: Fix "inactive" password
* Mon Jun 28 1999 kukuk@suse.de
- pam_warn: Add missing functions
- other.pamd: Update
- Add more doku
* Thu Jun 24 1999 kukuk@suse.de
- Add securetty config file
- Fix Debian pam_env patch
* Mon Jun 21 1999 kukuk@suse.de
- Update to Linux-PAM 0.67
- Add Debian pam_env patch
* Thu Jun 17 1999 kukuk@suse.de
- pam_ftp malloc (core dump) fix
* Tue Jun 15 1999 kukuk@suse.de
- pam_unix2 fixes
* Mon Jun  7 1999 kukuk@suse.de
- First PAM package: pam 0.66, pwdb 0.57 and pam_unix2
