#
# spec file for package net-tools
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           net-tools
Version:        2.0+git20170221.479bb4a
Release:        150000.5.13.1
Summary:        Important Programs for Networking
License:        GPL-2.0-or-later
Group:          Productivity/Networking/Other
Url:            https://sourceforge.net/projects/net-tools/
# Repacked by the service file from git
Source:         %{name}-%{version}.tar.xz
# PATCH-FEATURE-SUSE: set configure values to our liking as we do not need
# everything here
Patch0:         net-tools-configure.patch
# Git formatted patches described in each patch
Patch1:         0001-Add-ether-wake-binary.patch
Patch3:         0003-Add-support-for-EiB-in-interface.c.patch
Patch5:         0005-Add-support-for-interface-rename-in-nameif.patch
Patch7:         0007-Introduce-T-notrim-option-in-netstat.patch
# PATCH-FIX-SECURITY net-tools-CVE-2025-46836.patch bsc1243581 sbrabec@suse.com -- Perform bound checks when parsing interface labels in /proc/net/dev.
Patch8:         net-tools-CVE-2025-46836.patch
# PATCH-FIX-UPSTREAM net-tools-CVE-2025-46836-regression.patch bsc1243581 sbrabec@suse.com -- Fix regression introduced by net-tools-CVE-2025-46836.patch.
Patch9:         net-tools-CVE-2025-46836-regression.patch
# PATCH-FIX-UPSTREAM net-tools-CVE-2025-46836-error-reporting.patch bsc1243581 sbrabec@suse.com -- Provide more readable error for interface name size checking.
Patch10:        net-tools-CVE-2025-46836-error-reporting.patch
# PATCH-FIX-SECURITY net-tools-parse_hex-stack-overflow.patch bsc1248410 sbrabec@suse.com -- Fix stack buffer overflow in parse_hex.
Patch11:        net-tools-parse_hex-stack-overflow.patch
# PATCH-FIX-SECURITY net-tools-proc_gen_fmt-buffer-overflow.patch bsc1248410 sbrabec@suse.com -- Fix stack-based buffer overflow in proc_gen_fmt.
Patch12:        net-tools-proc_gen_fmt-buffer-overflow.patch
# PATCH-FIX-SECURITY net-tools-ifconfig-avoid-unsafe-memcpy.patch bsc1248410 sbrabec@suse.com -- Avoid unsafe memcpy in ifconfig.
Patch13:        net-tools-ifconfig-avoid-unsafe-memcpy.patch
# PATCH-FIX-SECURITY net-tools-ax25+netrom-overflow-1.patch bsc1248410 sbrabec@suse.com -- Prevent overflow in ax25 and netrom.
Patch14:        net-tools-ax25+netrom-overflow-1.patch
# PATCH-FIX-SECURITY net-tools-ax25+netrom-overflow-2.patch bsc1248410 sbrabec@suse.com -- Prevent overflow in ax25 and netrom.
Patch15:        net-tools-ax25+netrom-overflow-2.patch
# PATCH-FIX-UPSTREAM net-tools-ifconfig-long-name-warning.patch bsc1248410 sbrabec@suse.com -- Allow to enter long interface names again.
Patch16:        net-tools-ifconfig-long-name-warning.patch
BuildRequires:  help2man
Requires:       hostname
Recommends:     %{name}-lang = %{version}
Recommends:     traceroute >= 2.0.0
Provides:       net_tool = %{version}
Obsoletes:      net_tool < %{version}

%description
This package contains programs for network administration and maintenance.
Most of the utilities formerly contained in this package (netstat, arp,
ifconfig, rarp, route) are obsoleted by the tools from iproute2 package (ip, ss)
and have been moved to net-tools-deprecated.


%package deprecated
Summary:        Deprecated Networking Utilities
Group:          Productivity/Networking/Other
Recommends:     %{name}-lang = %{version}

%description deprecated
This package contains the deprecated network utilities arp, ifconfig, netstat and route,
which have been replaced by tools from the iproute2 package:
  * arp -> ip [-r] neigh
  * ifconfig -> ip a
  * netstat -> ss [-r]
  * route -> ip r

%lang_package

%prep
%setup -q
%autopatch -p1

%build
export CFLAGS="%{optflags}"
make %{?_smp_mflags} config
make %{?_smp_mflags}

%install
%make_install BINDIR=%{_bindir} SBINDIR=%{_sbindir}

# remove rarp as it is not usefull with our kernel
rm -fv %{buildroot}/usr/*bin/rarp
rm -fv %{buildroot}/%{_mandir}/man*/rarp.*
rm -fv %{buildroot}/%{_mandir}/*/man*/rarp.*
# Fix manpage locations
mv %{buildroot}/%{_mandir}/de_DE %{buildroot}/%{_mandir}/de
mv %{buildroot}/%{_mandir}/fr_FR %{buildroot}/%{_mandir}/fr
# Generate missing manpages
for tool in iptunnel ipmaddr; do
  t="%{buildroot}/%{_mandir}/man8/${tool}.8"
  help2man -s8 "%{buildroot}%{_sbindir}/${tool}" --no-discard-stderr >"${t}"
done
# generate bin/sbin compat symlinks
mkdir -p %{buildroot}/sbin
mkdir -p %{buildroot}/bin
for i in ether-wake nameif plipconfig slattach arp ipmaddr iptunnel; do
ln -s %{_sbindir}/$i %{buildroot}/sbin/$i
done
for i in netstat ifconfig route; do
ln -s %{_bindir}/$i %{buildroot}/bin/$i
done
%find_lang %{name} --all-name

%files
%defattr(-,root,root)
%license COPYING
%doc README ABOUT-NLS
%{_sbindir}/ether-wake
/sbin/ether-wake
%{_sbindir}/nameif
/sbin/nameif
%{_sbindir}/plipconfig
/sbin/plipconfig
%{_sbindir}/slattach
/sbin/slattach
%{_mandir}/de/man5/ethers.5%{ext_man}
%{_mandir}/de/man8/plipconfig.8%{ext_man}
%{_mandir}/de/man8/slattach.8%{ext_man}
%{_mandir}/fr/man5/ethers.5%{ext_man}
%{_mandir}/fr/man8/plipconfig.8%{ext_man}
%{_mandir}/fr/man8/slattach.8%{ext_man}
%{_mandir}/man5/ethers.5%{ext_man}
%{_mandir}/man8/ether-wake.8%{ext_man}
%{_mandir}/man8/nameif.8%{ext_man}
%{_mandir}/man8/plipconfig.8%{ext_man}
%{_mandir}/man8/slattach.8%{ext_man}

%files deprecated
%defattr(-,root,root)
%doc COPYING
%{_bindir}/netstat
/bin/netstat
%{_sbindir}/arp
/sbin/arp
%{_bindir}/ifconfig
/bin/ifconfig
%{_sbindir}/ipmaddr
/sbin/ipmaddr
%{_sbindir}/iptunnel
/sbin/iptunnel
%{_bindir}/route
/bin/route
%{_mandir}/de/man8/arp.8%{ext_man}
%{_mandir}/de/man8/ifconfig.8%{ext_man}
%{_mandir}/de/man8/netstat.8%{ext_man}
%{_mandir}/de/man8/route.8%{ext_man}
%{_mandir}/fr/man8/arp.8%{ext_man}
%{_mandir}/fr/man8/ifconfig.8%{ext_man}
%{_mandir}/fr/man8/netstat.8%{ext_man}
%{_mandir}/fr/man8/route.8%{ext_man}
%{_mandir}/man8/arp.8%{ext_man}
%{_mandir}/man8/ifconfig.8%{ext_man}
%{_mandir}/man8/netstat.8%{ext_man}
%{_mandir}/man8/route.8%{ext_man}
%{_mandir}/man8/ipmaddr.8%{ext_man}
%{_mandir}/man8/iptunnel.8%{ext_man}
%{_mandir}/pt_BR/man8/arp.8%{ext_man}
%{_mandir}/pt_BR/man8/ifconfig.8%{ext_man}
%{_mandir}/pt_BR/man8/netstat.8%{ext_man}
%{_mandir}/pt_BR/man8/route.8%{ext_man}

%files lang -f %{name}.lang
%defattr(-,root,root)

%changelog
* Mon Sep  8 2025 sbrabec@suse.com
- Drop 0002-Do-not-warn-about-interface-socket-not-binded.patch. It
  worked around a net-tools-1.60 specific problem, that does not
  happen in net-tools-2.10. It is more harmful than useful, as it
  can hide real problems. (bsc#430864#c15,
  https://github.com/ecki/net-tools/issues/32#issuecomment-3265471116).
* Sat Sep  6 2025 sbrabec@suse.com
- Drop 0004-By-default-do-not-fopen-anything-in-netrom_gr.patch. It
  was net-tools-1.60 specific leak fix and breaks netrom in
  net-tools-2.10 (bnc#544339#c2).
* Thu Aug 28 2025 sbrabec@suse.com
- Drop old Fedora patch 0006-Allow-interface-stacking.patch. It
  provided a fix for CVE-2025-46836 (bsc#142461), but it was fixes
  by the upstream in 2025 in a different way. Revert interferring
  net-tools-CVE-2025-46836.patch back to the upstream version.
- Fix stack buffer overflow in parse_hex (bsc#1248687,
  GHSA-h667-qrp8-gj58, net-tools-parse_hex-stack-overflow.patch).
- Fix stack-based buffer overflow in proc_gen_fmt (bsc#1248687,
  GHSA-w7jq-cmw2-cq59,
  net-tools-proc_gen_fmt-buffer-overflow.patch).
- Avoid unsafe memcpy in ifconfig (bsc#1248687,
  net-tools-ifconfig-avoid-unsafe-memcpy.patch).
- Prevent overflow in ax25 and netrom (bsc#1248687,
  net-tools-ax25+netrom-overflow-1.patch,
  net-tools-ax25+netrom-overflow-2.patch).
- Keep possibility to enter long interface names, even if they are
  not accepted by the kernel, because it was always possible up to
  CVE-2025-46836 fix. But issue a warning about an interface name
  concatenation (bsc#1248410,
  net-tools-ifconfig-long-name-warning.patch).
* Mon Aug 11 2025 sbrabec@suse.com
- Provide more readable error for interface name size checking
  introduced by net-tools-CVE-2025-46836.patch
  (bsc#1243581, net-tools-CVE-2025-46836-error-reporting.patch).
* Mon Aug  4 2025 sbrabec@suse.com
- Fix a regression in net-tools-CVE-2025-46836.patch (bsc#1246608).
* Thu Jul 10 2025 sbrabec@suse.com
- Perform bound checks when parsing interface labels in
  /proc/net/dev (bsc#1243581, CVE-2025-46836, GHSA-pfwf-h6m3-63wf,
  net-tools-CVE-2025-46836.patch,
  net-tools-CVE-2025-46836-regression.patch).
* Tue Mar 27 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Wed Nov 15 2017 vcizek@suse.com
- Update descriptions to better reflect the contents of both packages
  and mention the deprecation of the tools (bsc#1067937)
* Sun Jun 18 2017 tchvatal@suse.com
- Drop netstat xinetd service as we are phasing xinetd out
  There is probably no need to replace it here as netstat was
  deprecated and now users should favor 'ss' command from
  iproute2
* Sun Jun 18 2017 tchvatal@suse.com
- Provide compat symlink to /bin and /sbin to be on safe side
  if someone hardcoded them in scripts (most distros switched
  7 years ago)
* Sat Jun 17 2017 tchvatal@suse.com
- Disable removed binaries for build rather than on install
  * Refresh patch net-tools-configure.patch
- Make sure we respect optflags
- Add patch 0001-Add-ether-wake-binary.patch replacing standalone
  ether-wake code in the archive
- Add patch 0002-Do-not-warn-about-interface-socket-not-binded.patch
  replacing net-tools-1.60-interface_socket.diff
- Add patch 0003-Add-support-for-EiB-in-interface.c.patch enabling
  EiB support in interfaces
- Add patch 0004-By-default-do-not-fopen-anything-in-netrom_gr.patch
  relpacing net-tools-1.60-netrom-fopen.diff
- Add patch 0005-Add-support-for-interface-rename-in-nameif.patch
  replacing nameif-rename.patch
- Add patch 0006-Allow-interface-stacking.patch
  replacing net-tools-1.60-interface_stack.patch
- Add patch 0007-Introduce-T-notrim-option-in-netstat.patch
  replacing net-tools-1.60-dont-trim-foreign-addr6.diff
  and also net-tools-1.60-notrim.diff
- Drop net-tools-1.60-use-gai.patch as it should be upstreamed first
  and it does not apply clearly at all now
* Sat Jun 17 2017 tchvatal@suse.com
- Move binaries to sbindir and bindir respectively
- Switch from generating filelists to actually state them within
  the spec-file, now it is quite readable
- Move ifconfig and route to %%{_bindir} as upstream does
  (and debian/rh/... do too)
* Sat Jun 17 2017 tchvatal@suse.com
- Remove all the manpage altering patches as they are from 2002 and
  older while it changed and touching different languages for
  rebasing is not bright idea, the same applies for translations
  as upstream updated the translations we will pretend their
  strings win
- Switch to git service repacking so we don't have to carry all
  the patches ourselves
- Update to version 2.0+git20170221.479bb4a:
  * slattach/plipconfig: add a config knob to control them
  * Fixed trailing whitespace issue with a and i flags (#7)
  * iptunnel: drop netinet/ip.h include
  * iptunnel: fix building w/older linux headers
  * build: respect standard $(LDLIBS) variable
  * netstat: improve ROSE support
  * AX.25: Rename all references to axattach to kissattach.
  * Update all instances of my email address.
  * Fix conversion of some ROSE addresses.
  * Fix incorrect ARP output
- Merge patch net-tools-1.60-miioff.diff in the main config patch
- Rename net-tools-1.60.dif to net-tools-configure.patch in order
  to reflect what it actually does
- Drop nstrcmp.c as VCS contains newer version
- Drop patches that were either merged upstream or fixed bit differently:
  * manpages.diff
  * net-tools-1.60-arp-unaligned-access.patch
  * net-tools-1.60-compoundstatement.diff
  * net-tools-1.60-cont-buff.patch
  * net-tools-1.60-cs_CZ.bnc715580.diff
  * net-tools-1.60-doc.dif
  * net-tools-1.60-errors.patch
  * net-tools-1.60-fclose.diff
  * net-tools-1.60-fix-header-conflict.patch
  * net-tools-1.60-hostname-ipv6.patch
  * net-tools-1.60-hostname-s.patch
  * net-tools-1.60-hostname-space.patch
  * net-tools-1.60-ifconfig-SIOCSIFNETMASK.diff
  * net-tools-1.60-ifconfig.8.diff
  * net-tools-1.60-ifindex.diff
  * net-tools-1.60-infiniband.diff
  * net-tools-1.60-ipv6-statistics.diff
  * net-tools-1.60-krn26.dif
  * net-tools-1.60-long_to_int.diff
  * net-tools-1.60-multilinestr.diff
  * net-tools-1.60-nameif.diff
  * net-tools-1.60-netstat-ci.diff
  * net-tools-1.60-netstat-output.patch
  * net-tools-1.60-netstat-p.patch
  * net-tools-1.60-netstat.8.diff
  * net-tools-1.60-netstat_retval.diff
  * net-tools-1.60-numericstuff.diff
  * net-tools-1.60-plipconfig-ecode.patch
  * net-tools-1.60-plipconfig-manpage.patch
  * net-tools-1.60-plipconfig-usage.patch
  * net-tools-1.60-printval-conversion.patch
  * net-tools-1.60-sctp-quiet
  * net-tools-1.60-sctp.patch
  * net-tools-1.60-snmp-counter-overflow.patch
  * net-tools-1.60-sockios-SIOCGMIIPHY.diff
  * net-tools-1.60-strictaliasing.diff
  * net-tools-1.60-tcp-recvq-listen.patch
  * netstat-trunc.dif
  * net-tools-1.60-if_tr.diff
  * net-tools-1.60-interface_mtu.diff
* Sat Jun 17 2017 tchvatal@suse.com
- Cleanup a bit with spec-cleaner and remove sle11 conditions
- Drop the patch net-tools-1.60-obsolete.diff
  * If restored it is in the VCS and it silences all the rpm warnings
* Tue Nov  1 2016 giecrilj@stegny.2a.pl
- add COPYING
- net-tools-1.60-use-gai.patch:
  use getaddrinfo instead of gethostbyname
* Mon Oct 17 2016 schwab@suse.de
- net-tools-1.60-fix-header-conflict.patch: use kernel headers to avoid
  conflict with user-space headers
* Tue May 17 2016 pwieczorkiewicz@suse.com
- Add net-tools-1.60-hostname-s.patch:
  This changes the hostname behavior to match other systems and its
  own documentation. Namely, that -s just parses the result of the
  active gethostname() and does not attempt any network/DNS traffic.
  upstream: https://sourceforge.net/p/net-tools/bugs/14/
  commit#452f8e (boo#872264).
* Wed Jun 10 2015 gber@opensuse.org
- Remove hostname, domainname, dnsdomainname and require the
  separate hostname package instead
* Tue May 26 2015 dgutu@suse.com
- Added patches to past change log entry
* Sun Mar 29 2015 jengelh@inai.de
- ipmaddr and iptunnel are obsolete too, move them to subpackage.
  (Superseded by `ip maddr` and `ip tunnel`)
- remove redundant %%clean section
* Thu Apr 10 2014 mmarek@suse.cz
- Move arp, ifconfig, netstat and route to a -deprecated subpackage
  (fate#317196, fate#317197)
- Drop the rarp tool, which has been broken since kernel 2.3
* Thu Jul 25 2013 ms@suse.de
- ported plipconfig patches from SLE base (bnc #831310)
  - net-tools-1.60-plipconfig-ecode.patch
  - net-tools-1.60-plipconfig-manpage.patch
  - net-tools-1.60-plipconfig-usage.patch
* Mon Apr 15 2013 idonmez@suse.com
- Add Source URL, see https://en.opensuse.org/SourceUrls
* Fri Feb  1 2013 crrodriguez@opensuse.org
- Use Recommends insted of requires for traceroute
* Tue Jan 29 2013 crrodriguez@opensuse.org
- Remove obsolete traceroute(8) implementation.
  Modern one is packaged as "traceroute". to fullfil userspace
  requirements, Require the new version explicitly.
  - Fix localized man page installation, the right thing (tm) to
  do is to use find_lang --with-man --all-name instead.
* Sat Jan 26 2013 jslaby@suse.com
- add etherwake
* Sun Oct  7 2012 andreas.stieger@gmx.de
- Kernel 3.6 removes if_strip.h - disable STRIP support in factory
- convert .changes to utf-8 fixing old entry, W: non-utf8-spec-file
* Mon Sep 12 2011 mt@suse.com
- Applied corrections for Czech translation (bnc#715580)
* Tue Feb 15 2011 mt@suse.de
- Fixed netstat to not trim foreign/remote ipv6 addresses when
  the -T option is set (bnc#637490).
* Tue Jul 20 2010 mt@suse.de
- implemented ipv6 support in hostname -[aifsd] (bnc #577070)
* Tue Jan 26 2010 jengelh@medozas.de
- make sure -m64 is passed to the linker in 64-bit mode
* Fri Jan  1 2010 ms@suse.de
- fixed return value of netstat -s call (bnc #566946)
* Wed Dec 16 2009 ms@suse.de
- removed ipchains references in man pages (bnc #561866)
* Tue Nov  3 2009 coolo@novell.com
- updated patches to apply with fuzz=0
* Wed Oct  7 2009 ms@suse.de
- fixed duplicate fopen calls in netrom_gr.c (bnc #544339)
* Mon Sep 14 2009 ms@suse.de
- added support for IPV6 statistics (bnc #537904)
- fixed interface address field length (bnc #537904)
- added support for infiniband IPoIB devices (bnc #537904)
* Wed Aug 12 2009 ms@suse.de
- added -T, --notrim option which prevents the address
  field from being truncated (bnc #530196)
* Thu Aug  6 2009 ms@suse.de
- fixed missing fclose to fopen (bnc #528577)
* Tue Jul  7 2009 ms@suse.de
- disabled net-tools obsolete patch, no way to convince
  people that it would be a good idea (bnc #492665)
* Tue Jul  7 2009 ms@suse.de
- Programs from net-tools have modern equivalents:
  arp      -> ip neigh
  ifconfig -> ip addr/ip link
  ipmaddr  -> ip maddr
  iptunnel -> ip tunnel
  netstat  -> ss
  route    -> ip route
  added patch to print an obsoletes warning on
  stderr (bnc #492665)
* Thu Jun 11 2009 coolo@novell.com
- define we need GNU_SOURCE
* Thu May  7 2009 ms@suse.de
- fixed data type of third argument in printval function.
  Also make sure the printf call in this function uses the
  correct format sequence (bnc #501113)
* Wed Mar 25 2009 ms@suse.de
- increased field length for display of MTU value (bnc #486014)
* Thu Nov 20 2008 ms@suse.de
- don't show af_inet socket warning for netstat -i (bnc #430864)
* Thu Nov  6 2008 ms@suse.de
- really fixed SIOCSIFNETMASK ioctl from being called earlier
  to SIOCSIFADDR (bnc #438983)
* Fri Oct 31 2008 ms@suse.de
- reverted last patch from IBM because it breaks standard
  ifconfig usage as shown in bug (bnc #440580)
* Mon Oct 27 2008 ms@suse.de
- fixed ifconfig SIOCSIFNETMASK ioctl from being called earlier
  to SIOCSIFADDR (bnc #438983)
* Thu Sep 25 2008 ms@suse.de
- really fixed netstat -ci, incomplete patch (bnc #424813)
* Wed Sep 10 2008 ms@suse.de
- fixed netstat -ci which prints the stats only on the first loop
  on subsequent loops it says "no statistics available", even though
  there was network traffic in between (bnc #424813)
* Tue Sep  2 2008 ms@suse.de
- update to traceroute 1.2
* Mon Aug 11 2008 ms@suse.de
- added patch to allow monitoring of accepted connections queue
  length for tcp listening sockets. This will work with
  kernels >= 2.6.18.
* Mon May  5 2008 ms@suse.de
- added hint about option -s and -f to hostname (bnc #386686)
* Thu Mar  6 2008 ms@suse.de
- fixed length of interface field (bnc #367769)
* Tue Mar  4 2008 ms@suse.de
- added obsolete warning for ifconfig into man page (bnc #366477)
* Sun Feb 24 2008 crrodriguez@suse.de
-  use find_lang macro
* Wed Jul 25 2007 ms@suse.de
- fixed locale names (#294148)
* Wed May  2 2007 ms@suse.de
- fixed trailing space for hostname -a and -i (#270314)
* Tue Sep 26 2006 ms@suse.de
- fixed stack overflow when using traceroute -q [n]>=10 (#200508)
* Mon Jul 24 2006 ms@suse.de
- fixed german translation for route -C (#194357)
* Thu Jul 20 2006 ms@suse.de
- replaced static HZ define to dynamic:
  [#]ifndef HZ
  [#]define HZ sysconf(_SC_CLK_TCK)
  [#]endif
* Wed May 24 2006 schwab@suse.de
- Don't strip binaries.
* Wed May 17 2006 ms@suse.de
- added patch from Olaf Kirch. Do not display SCTP sockets
  if /proc/net/sctp/eps couldn't be opened (#159686)
* Tue Mar 21 2006 okir@suse.de
- Display SCTP sockets correctly [#159686 - LTC22492]
* Mon Mar 20 2006 hvogel@suse.de
- fix netstat -p segfault [#159069]
* Mon Feb 20 2006 hvogel@suse.de
- fix netstat output not to bit-wrap [#149563]
* Mon Feb  6 2006 hvogel@suse.de
- add snmp counter overflow patch by ak [#148350]
* Wed Feb  1 2006 hvogel@suse.de
- fix arp causing unaligned access [#146422]
  patch from Arthur D. Kepner
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 11 2006 mmj@suse.de
- Add patch from fedora to avoid stack smashing [#142461]
* Mon Dec 19 2005 mmj@suse.de
- Update to traceroute-1.0.4
* Mon Dec 19 2005 mmj@suse.de
- Update to traceroute-1.0.3
* Fri Dec 16 2005 mmj@suse.de
- Use ICMP6_DST_UNREACH_BEYONDSCOPE instead of
  ICMP6_DST_UNREACH_NOTNEIGHBOR on newer glibc
* Tue Sep 27 2005 mmj@suse.de
- Fix strict aliasing issues
* Mon Aug 29 2005 mmj@suse.de
- Correct netstat.8 [#104487]
* Wed Jul  6 2005 mmj@suse.de
- Fix missing decl in nstrcmp.c
* Mon Jun 20 2005 mmj@suse.de
- compile with -fpie, link with -pie
- don't strip explicitly
* Mon Jun 13 2005 ro@suse.de
- include netinet/if_tr.h instead of linux/if_tr.h
* Wed Jan  5 2005 mmj@suse.de
- Fix --numeric-ports to not imply --numeric [#45609]
* Tue Dec  7 2004 mmj@suse.de
- Include linux/sockios.h to get the right ioctl [#48873]. This bug
  is in mii-tool which is not included anymore, but better not risk
  ever re-adding buggy stuff.
* Thu Dec  2 2004 mmj@suse.de
- Fix nameif segfault [#48749]
* Mon Aug  9 2004 mmj@suse.de
- Remove mii-tool everywhere [#43343]
* Fri Jul 30 2004 fdg@suse.de
- fixed the -ic option without destroying the ifconfig buffer
  regarding to bug #42932
* Mon May 24 2004 meissner@suse.de
- also print unsigned long longs (last patch updated).
* Mon May 24 2004 meissner@suse.de
- Always read 64bit values from /proc/net/dev, so we can
  use 32bit userland to read from 64bit kernel. #40951/LTC#8726
* Fri Mar  5 2004 hare@suse.de
- Fixed return values for non-existing interfaces in nameif.
* Thu Feb 26 2004 hare@suse.de
- Add -r option to nameif to allow renaming of
  interfaces.
* Thu Jan 29 2004 hare@suse.de
- Cool. The last change effectively broke route(1).
  - > replaced return; with break;
* Sun Jan 18 2004 mmj@suse.de
- Fix compound statement calls, and add a missing include
* Wed Oct 15 2003 mmj@suse.de
- Don't build as root
* Mon Oct 13 2003 mmj@suse.de
- Fix 32 vs. 64-bit programming mistakes [#32089]
* Mon Aug 18 2003 mmj@suse.de
- Fix from mmeissner for nstrcmp.c to handle alias interfaces,
  even without standard names. (eth1:1 vs eth1:2, also
  eth1:blubber vs eth1:1) [#28985]
* Mon Jul 14 2003 mmj@suse.de
- Add fix from okir for traceroute -S [#27573]
* Wed Jun 18 2003 ro@suse.de
- added non-en manpage directories to filelist
* Mon May 19 2003 mmj@suse.de
- Use a better and more tested nstrcmp.c [#26950]
* Tue May 13 2003 ro@suse.de
- fix build with 2.5 kernel includes
* Tue May 13 2003 mmj@suse.de
- Package man-pages in several languages
* Wed Mar  5 2003 mmj@suse.de
- Add missing xinetd file [#24676]
* Tue Nov 26 2002 mmj@suse.de
- Fix traceroute 6 segfault [#21975]
* Fri Nov 15 2002 okir@suse.de
- Upgraded to new traceroute to fix #20358
* Mon Nov 11 2002 mmj@suse.de
- Fix multi string literals
* Thu Jul 25 2002 mmj@suse.de
- Added traceroute from Olaf Kirch, which is much more secure and
  also IPv6 capable.
* Tue Apr 16 2002 mmj@suse.de
- Do not pack translated manpages. Should go to other package.
* Mon Mar  4 2002 mmj@suse.de
- unvollsändig -> unvollständig in German locale. [Bug #14371]
* Wed Feb  6 2002 mmj@suse.de
- Removed yp and nis stuff from manpages.
* Sat Aug 25 2001 kukuk@suse.de
- Replace last patch by a newer one from ak@suse.de
* Mon Aug 20 2001 kukuk@suse.de
- Add fix for truncated IP addresses [Bug #9737]
* Wed Apr 25 2001 kukuk@suse.de
- Update to net-tools-1.60:
  * lot of locale fixes
  * IPv6 fixes
  * use secure strcpy
* Tue Apr 17 2001 ro@suse.de
- added provides for net_tool
* Sun Mar  4 2001 bk@suse.de
- Update to 1.59(many fixes and improvements and new program nameif)
- enabled gettext support and added locales
- added ipmaddr and iptunnel tools
- enabled FDDI and HIPPI support
- use optimisation flags
- added international man pages
- spec file changes to make use of wildcards in the filelist
* Fri Oct 20 2000 kukuk@suse.de
- Rename from net_tool to net-tools
* Sun Jun 25 2000 bk@suse.de
- s390: removed not needed files
* Sat Jun  3 2000 kukuk@suse.de
- Update to 1.56
* Thu May 25 2000 kukuk@suse.de
- Update to 1.55 (contains all fixes)
* Thu May 18 2000 kukuk@suse.de
- Add oh2bns patch (bug #2864)
* Wed Feb  9 2000 kukuk@suse.de
- Add ifconfig manual pages from Andi Kleen
* Wed Feb  2 2000 kukuk@suse.de
- Fix PPP initialisation
* Wed Feb  2 2000 kukuk@suse.de
- Update to 1.54, move /usr/man -> /usr/share/man
* Mon Jan  3 2000 kukuk@suse.de
- Enable IPv6 support
- Fix arp/ethers parsing
* Tue Oct 12 1999 garloff@suse.de
- gateways and targets of PtP routes (host flag) are hosts, not
  networks. Change name lookup accordingly.
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Mon Aug 30 1999 kukuk@suse.de
- Update to 1.53, remove ypdomainname and nisdomainname
* Sat Jun 26 1999 kukuk@suse.de
- update from jurix to 1.52
* Tue Mar  9 1999 ro@suse.de
- update to 1.50
- included slattach and its manpage in filelist
* Wed Oct 28 1998 ro@suse.de
- update to 1.46 / removed incorporated changes from .dif
* Sat Sep 19 1998 ro@suse.de
- define _GNU_SOURCE where getopt_long is used
* Tue Sep  1 1998 ro@suse.de
- fixed problems with inluding own ipx.h under glibc
* Wed Jun 24 1998 ro@suse.de
- added include linux/timer.h before including linux/ip_fw.h
* Mon Oct 27 1997 ro@suse.de
- added ADD_LANG in Makefile to avoid error
* Thu Jan  2 1997 florian@suse.de
- new version 1.32-alpha
- mv /sbin/arp /usr/sbin/arp
