#
# spec file for package expat
#
# Copyright (c) 2025 SUSE LLC
# Copyright (c) 2024 Andreas Stieger <Andreas.Stieger@gmx.de>
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%global unversion 2_7_1
%define sover 1
Name:           expat
Version:        2.7.1
Release:        150400.3.31.1
Summary:        XML Parser Toolkit
License:        MIT
Group:          Development/Libraries/C and C++
URL:            https://libexpat.github.io
Source0:        https://github.com/libexpat/libexpat/releases/download/R_%{unversion}/expat-%{version}.tar.xz
Source1:        https://github.com/libexpat/libexpat/releases/download/R_%{unversion}/expat-%{version}.tar.xz.asc
Source2:        baselibs.conf
Source3:        %{name}faq.html
# https://www.gentoo.org/inside-gentoo/developers/index.html#sping
# https://github.com/libexpat/libexpat/issues/537#issuecomment-1003796884
Source4:        https://keyserver.ubuntu.com/pks/lookup?op=get&search=0x3176ef7db2367f1fca4f306b1f9b0e909af37285#/expat.keyring
Patch0:         CVE-2025-59375.patch
BuildRequires:  c++_compiler
BuildRequires:  pkgconfig

%description
Expat is an XML parser library written in C. It is a stream-oriented
parser in which an application registers handlers for things the
parser might find in the XML document (like start tags).

%package -n libexpat%{sover}
Summary:        XML Parser Toolkit
Group:          System/Libraries

%description -n libexpat%{sover}
Expat is an XML parser library written in C. It is a stream-oriented
parser in which an application registers handlers for things the
parser might find in the XML document (like start tags).

%package -n libexpat-devel
Summary:        Development files for expat, an XML parser toolkit
Group:          Development/Libraries/C and C++
Requires:       glibc-devel
Requires:       libexpat%{sover} = %{version}

%description -n libexpat-devel
Expat is an XML parser library written in C. It is a stream-oriented
parser in which an application registers handlers for things the
parser might find in the XML document (like start tags).

This package contains the development headers for the library found
in libexpat.

%prep
%autosetup -p1
cp %{SOURCE3} .

%build
export CFLAGS="%{optflags} -Og"
%configure \
  --disable-silent-rules \
  --docdir="%{_docdir}/%{name}" \
  --disable-static \
  --without-docbook

%make_build

%check
%make_build check

%install
%make_install
find %{buildroot} -type f -name "*.la" -delete -print

%ldconfig_scriptlets -n libexpat%{sover}

%files
%license COPYING
%doc AUTHORS README.md expatfaq.html
%doc doc/reference.html doc/*.css
%doc examples/*.c examples/Makefile.am examples/Makefile.in
%doc changelog
%{_bindir}/xmlwf
%{_mandir}/man1/xmlwf.1%{?ext_man}

%files -n libexpat1
%license COPYING
%{_libdir}/libexpat.so.%{sover}
%{_libdir}/libexpat.so.%{sover}.*

%files -n libexpat-devel
%license COPYING
%{_includedir}/*
%{_libdir}/libexpat.so
%{_libdir}/pkgconfig/expat.pc
%dir %{_libdir}/cmake
%{_libdir}/cmake/expat-%{version}

%changelog
* Mon Sep 29 2025 martin.schreiner@suse.com
- Fix CVE-2025-59375 / bsc#1249584.
- Add patch file:
  * CVE-2025-59375.patch
* Fri Mar 28 2025 pgajdos@suse.com
- version update to 2.7.1
    Bug fixes:
    [#980] #989  Restore event pointer behavior from Expat 2.6.4
    (that the fix to CVE-2024-8176 changed in 2.7.0);
    affected API functions are:
  - XML_GetCurrentByteCount
  - XML_GetCurrentByteIndex
  - XML_GetCurrentColumnNumber
  - XML_GetCurrentLineNumber
  - XML_GetInputContext
    Other changes:
    [#976] #977  Autotools: Integrate files "fuzz/xml_lpm_fuzzer.{cpp,proto}"
    with Automake that were missing from 2.7.0 release tarballs
    [#983] #984  Fix printf format specifiers for 32bit Emscripten
    [#992]  docs: Promote OpenSSF Best Practices self-certification
    [#978]  tests/benchmark: Resolve mistaken double close
    [#986]  Address compiler warnings
    [#990] #993  Version info bumped from 11:1:10 (libexpat*.so.1.10.1)
    to 11:2:10 (libexpat*.so.1.10.2); see https://verbump.de/
    for what these numbers do
    Infrastructure:
    [#982]  CI: Start running Perl XML::Parser integration tests
    [#987]  CI: Enforce Clang Static Analyzer clean code
    [#991]  CI: Re-enable warning clang-analyzer-valist.Uninitialized
    for clang-tidy
    [#981]  CI: Cover compilation with musl
    [#983] #984  CI: Cover compilation with 32bit Emscripten
    [#976] #977  CI: Protect against fuzzer files missing from future
    release archives
* Thu Mar 27 2025 pgajdos@suse.com
- version update to 2.7.0 for SLE-15-SP4
- deleted patches
  - expat-CVE-2022-25235.patch (upstreamed)
  - expat-CVE-2022-25236-relax-fix.patch (upstreamed)
  - expat-CVE-2022-25236.patch (upstreamed)
  - expat-CVE-2022-25313-fix-regression.patch (upstreamed)
  - expat-CVE-2022-25313.patch (upstreamed)
  - expat-CVE-2022-25314.patch (upstreamed)
  - expat-CVE-2022-25315.patch (upstreamed)
  - expat-CVE-2022-40674.patch (upstreamed)
  - expat-CVE-2022-43680.patch (upstreamed)
  - expat-CVE-2023-52425-1.patch (upstreamed)
  - expat-CVE-2023-52425-2.patch (upstreamed)
  - expat-CVE-2023-52425-backport-parser-changes.patch (upstreamed)
  - expat-CVE-2023-52425-fix-tests.patch (upstreamed)
  - expat-CVE-2024-28757.patch (upstreamed)
  - expat-CVE-2024-45490.patch (upstreamed)
  - expat-CVE-2024-45491.patch (upstreamed)
  - expat-CVE-2024-45492.patch (upstreamed)
  - expat-CVE-2024-50602.patch (upstreamed)
* Fri Mar 14 2025 pgajdos@suse.com
- version update to 2.7.0 (CVE-2024-8176 [bsc#1239618])
  * Security fixes:
    [#893] #973  CVE-2024-8176 -- Fix crash from chaining a large number
    of entities caused by stack overflow by resolving use of
    recursion, for all three uses of entities:
  - general entities in character data ("<e>&g1;</e>")
  - general entities in attribute values ("<e k1='&g1;'/>")
  - parameter entities ("%%p1;")
    Known impact is (reliable and easy) denial of service:
    CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H/E:H/RL:O/RC:C
    (Base Score: 7.5, Temporal Score: 7.2)
    Please note that a layer of compression around XML can
    significantly reduce the minimum attack payload size.
  * Other changes:
    [#935] #937  Autotools: Make generated CMake files look for
    libexpat.@SO_MAJOR@.dylib on macOS
    [#925]  Autotools: Sync CMake templates with CMake 3.29
  [#945] #962 #966  CMake: Drop support for CMake <3.13
    [#942]  CMake: Small fuzzing related improvements
    [#921]  docs: Add missing documentation of error code
    XML_ERROR_NOT_STARTED that was introduced with 2.6.4
    [#941]  docs: Document need for C++11 compiler for use from C++
    [#959]  tests/benchmark: Fix a (harmless) TOCTTOU
    [#944]  Windows: Fix installer target location of file xmlwf.xml
    for CMake
    [#953]  Windows: Address warning -Wunknown-warning-option
    about -Wno-pedantic-ms-format from LLVM MinGW
    [#971]  Address Cppcheck warnings
    [#969] #970  Mass-migrate links from http:// to https://
    [#947] #958 ..
    [#974] #975  Document changes since the previous release
    [#974] #975  Version info bumped from 11:0:10 (libexpat*.so.1.10.0)
    to 11:1:10 (libexpat*.so.1.10.1); see https://verbump.de/
    for what these numbers do
* Tue Nov 12 2024 pgajdos@suse.com
- no source changes, just adding jira reference: jsc#SLE-21253
* Thu Nov  7 2024 pgajdos@suse.com
- version update to 2.6.4
  * Security fixes: [bsc#1232601][bsc#1232579]
    [#915]  CVE-2024-50602 -- Fix crash within function XML_ResumeParser
    from a NULL pointer dereference by disallowing function
    XML_StopParser to (stop or) suspend an unstarted parser.
    A new error code XML_ERROR_NOT_STARTED was introduced to
    properly communicate this situation.  // CWE-476 CWE-754
  * Other changes:
    [#903]  CMake: Add alias target "expat::expat"
    [#905]  docs: Document use via CMake >=3.18 with FetchContent
    and SOURCE_SUBDIR and its consequences
    [#902]  tests: Reduce use of global parser instance
    [#904]  tests: Resolve duplicate handler
  [#317] #918  tests: Improve tests on doctype closing (ex CVE-2019-15903)
    [#914]  Fix signedness of format strings
  [#919] #920  Version info bumped from 10:3:9 (libexpat*.so.1.9.3)
    to 11:0:10 (libexpat*.so.1.10.0); see https://verbump.de/
    for what these numbers do
* Thu Sep 26 2024 pgajdos@suse.com
- updated keyring [https://build.suse.de/request/show/345282]
- modified sources
  %% expat.keyring
* Thu Sep  5 2024 david.anes@suse.com
- Update to 2.6.3:
  * Security fixes:
  - CVE-2024-45490, bsc#1229930 -- Calling function XML_ParseBuffer with
    len < 0 without noticing and then calling XML_GetBuffer
    will have XML_ParseBuffer fail to recognize the problem
    and XML_GetBuffer corrupt memory.
    With the fix, XML_ParseBuffer now complains with error
    XML_ERROR_INVALID_ARGUMENT just like sibling XML_Parse
    has been doing since Expat 2.2.1, and now documented.
    Impact is denial of service to potentially artitrary code
    execution.
  - CVE-2024-45491, bsc#1229931 -- Internal function dtdCopy can have an
    integer overflow for nDefaultAtts on 32-bit platforms
    (where UINT_MAX equals SIZE_MAX).
    Impact is denial of service to potentially artitrary code
    execution.
  - CVE-2024-45492, bsc#1229932 -- Internal function nextScaffoldPart can
    have an integer overflow for m_groupSize on 32-bit
    platforms (where UINT_MAX equals SIZE_MAX).
    Impact is denial of service to potentially artitrary code
    execution.
  * Other changes:
  - Autotools: Sync CMake templates with CMake 3.28
  - Autotools: Always provide path to find(1) for portability
  - Autotools: Ensure that the m4 directory always exists.
  - Autotools: Simplify handling of SIZEOF_VOID_P
  - Autotools: Support non-GNU sed
  - Autotools|CMake: Fix main() to main(void)
  - Autotools|CMake: Fix compile tests for HAVE_SYSCALL_GETRANDOM
  - Autotools|CMake: Stop requiring dos2unix
  - CMake: Fix check for symbols size_t and off_t
  - docs|tests: Convert README to Markdown and update
  - Windows: Drop support for Visual Studio <=15.0/2017
  - Drop needless XML_DTD guards around is_param access
  - Fix typo in a code comment
  - Version info bumped from 10:2:9 (libexpat*.so.1.9.2)
    to 10:3:9 (libexpat*.so.1.9.3); see https://verbump.de/
    for what these numbers do
* Wed Mar 13 2024 andreas.stieger@gmx.de
- update to 2.6.2:
  * CVE-2024-28757 -- Prevent billion laughs attacks with isolated
    use of external parsers (boo#1221289)
  * Reject direct parameter entity recursion and avoid the related
    undefined behavior
* Fri Mar  1 2024 andreas.stieger@gmx.de
- update to 2.6.1:
  * Expose billion laughs API with XML_DTD defined and XML_GE
    undefined, regression from 2.6.0
  * Make tests independent of CPU speed, and thus more robust
- drop libxml2-fix-xmlwf.1-handling.patch, upstream
* Tue Feb 20 2024 david.anes@suse.com
- Fix handling of xmlwf.1 to avoid workarounds in specfile:
  * Added libxml2-fix-xmlwf.1-handling.patch
- Call buildconf.sh to avoid (future) issues with expat_config.h.in
* Mon Feb 12 2024 david.anes@suse.com
- Update keyring automatically from keyserver during OBS service run.
- Explicitly use --without-docbook (before it was implicit).
- Include missing files for documentation and examples.
- Add manpage for xmlwf, which is now available in the released tarball.
- Clean the spec file a bit.
- Update to 2.6.0:
  * Security fixes:
  - CVE-2023-52425 (boo#1219559)
  - - Fix quadratic runtime issues with big tokens
    that can cause denial of service, in partial where
    dealing with compressed XML input.  Applications
    that parsed a document in one go -- a single call to
    functions XML_Parse or XML_ParseBuffer -- were not affected.
    The smaller the chunks/buffers you use for parsing
    previously, the bigger the problem prior to the fix.
    Backporters should be careful to no omit parts of
    pull request #789 and to include earlier pull request #771,
    in order to not break the fix.
  - CVE-2023-52426 (boo#1219561)
  - - Fix billion laughs attacks for users
    compiling *without* XML_DTD defined (which is not common).
    Users with XML_DTD defined have been protected since
    Expat >=2.4.0 (and that was CVE-2013-0340 back then).
  * Bug fixes:
  - Fix parse-size-dependent "invalid token" error for
    external entities that start with a byte order mark
  - Fix NULL pointer dereference in setContext via
    XML_ExternalEntityParserCreate for compilation with
    XML_DTD undefined
  - Protect against closing entities out of order
  * Other changes:
  - Improve support for arc4random/arc4random_buf
  - Improve buffer growth in XML_GetBuffer and XML_Parse
  - xmlwf: Support --help and --version
  - xmlwf: Support custom buffer size for XML_GetBuffer and read
  - xmlwf: Improve language and URL clickability in help output
  - examples: Add new example "element_declarations.c"
  - Be stricter about macro XML_CONTEXT_BYTES at build time
  - Make inclusion to expat_config.h consistent
  - Autotools: configure.ac: Support --disable-maintainer-mode
  - Autotools: Sync CMake templates with CMake 3.26
  - Autotools: Make installation of shipped man page doc/xmlwf.1
    independent of docbook2man availability
  - Autotools|CMake: Add missing -DXML_STATIC to pkg-config file
    section "Cflags.private" in order to fix compilation
    against static libexpat using pkg-config on Windows
  - Autotools|CMake: Require a C99 compiler
    (a de-facto requirement already since Expat 2.2.2 of 2017)
  - Autotools|CMake: Fix PACKAGE_BUGREPORT variable
  - Autotools|CMake: Make test suite require a C++11 compiler
  - CMake: Require CMake >=3.5.0
  - CMake: Lowercase off_t and size_t to help a bug in Meson
  - CMake: Sort xmlwf sources alphabetically
  - CMake|Windows: Fix generation of DLL file version info
  - CMake: Build tests/benchmark/benchmark.c as well for
    a build with -DEXPAT_BUILD_TESTS=ON
  - docs: Document the importance of isFinal + adjust tests
    accordingly
  - docs: Improve use of "NULL" and "null"
  - docs: Be specific about version of XML (XML 1.0r4)
    and version of C (C99); (XML 1.0r5 will need a sponsor.)
  - docs: reference.html: Promote function XML_ParseBuffer more
  - docs: reference.html: Add HTML anchors to XML_* macros
  - docs: reference.html: Upgrade to OK.css 1.2.0
  - docs: Fix typos
  - docs|CI: Use HTTPS URLs instead of HTTP at various places
  - Address compiler warnings
  - Address clang-tidy warnings
  - Version info bumped from 9:10:8 (libexpat*.so.1.8.10)
    to 10:0:9 (libexpat*.so.1.9.0); see https://verbump.de/
    for what these numbers do
* Sun Dec 11 2022 andreas.stieger@gmx.de
- add upstream signing key and validate source signature
* Wed Oct 26 2022 david.anes@suse.com
- Update to 2.5.0: (bsc#1204708)
  * Security fixes:
  - CVE-2022-43680 -- Fix heap use-after-free after overeager
    destruction of a shared DTD in function
    XML_ExternalEntityParserCreate in out-of-memory situations.
    Expected impact is denial of service or potentially arbitrary
    code execution.
  * Bug fixes:
  - Fix curruption from undefined entities
  - Fix case when parsing was suspended while processing nested
    entities
  - Stop leaking opening tag bindings after a closing tag mismatch
    error where a parser is reset through XML_ParserReset and then
    reused to parse
  - CMake: Fix generation of pkg-config file
  - MinGW|CMake: Fix static library name
  * Other changes:
  - Protect header expat_config.h from multiple inclusion
  - examples: Make use of XML_GetBuffer and be more consistent
    across examples
  - Address compiler warnings
  - Version info bumped from 9:9:8 to 9:10:8; see
    https://verbump.de/ for what these numbers do
* Tue Sep 20 2022 david.anes@suse.com
- update to 2.4.9: (bsc#1203438)
  * Security fixes:
  - CVE-2022-40674 -- Heap use-after-free vulnerability in
    function doContent. Expected impact is denial of service
    or potentially arbitrary code execution.
  * Bug fixes:
  - MinGW: Fix mis-compilation for -D__USE_MINGW_ANSI_STDIO=0
  - docs: Fix documentation on effect of switch XML_DTD on
    symbol visibility in doc/reference.html
  * Other changes:
  - MinGW: Make fix-xmltest-log.sh drop more Wine bug output
  - Autotools: Sync CMake templates with CMake 3.22
  - CMake: Migrate from use of CMAKE_*_POSTFIX to
    dedicated variables EXPAT_*_POSTFIX to stop affecting
    other projects
  - Windows|CMake: Add missing -DXML_STATIC to test runners
    and fuzzers
  - Windows|CMake: Render .def file from a template to fix
    linking with -DEXPAT_DTD=OFF and/or -DEXPAT_ATTR_INFO=ON
  - MinGW|CMake: Apply MSVC .def file when linking
  - MinGW|CMake: Sync library name with GNU Autotools,
    i.e. produce libexpat-1.dll rather than libexpat.dll
    by default.  Filename libexpat.dll.a is unaffected.
  - MinGW|CMake: Set missing variable CMAKE_RC_COMPILER in
    toolchain file "cmake/mingw-toolchain.cmake" to avoid
    error "windres: Command not found" on e.g. Ubuntu 20.04
  - CMake: Unify inconsistent use of set() and option() in
    context of public build time options to take need for
    set(.. FORCE) in projects using Expat by means of
    add_subdirectory(..) off Expat's users' shoulders
  - Stop exporting API symbols when building a static library
  - Resolve use of deprecated "fgrep" by "grep -F"
  - CMake: Make documentation on variables a bit more consistent
  - CMake: Drop leading whitespace from a #cmakedefine line in
    file expat_config.h.cmake
  - xmlwf: Fix harmless variable mix-up in function nsattcmp
  - Address Cppcheck warnings
  - Address Clang 15 compiler warnings
  - Version info bumped from 9:8:8 to 9:9:8;
    see https://verbump.de/ for what these numbers do
  * Infrastructure:
  - CI: Windows: Start covering MSVC 2022
  - CI: macOS: Migrate off deprecated macOS 10.15
  - CI: Linux: Make migration off deprecated Ubuntu 18.04 work
  - CI: Upgrade Clang from 14 to 15
  - apply-clang-format.sh: Add support for BSD find
  - coverage.sh: Exclude MinGW headers
  - coverage.sh: Fix name collision for -funsigned-char
* Tue Mar 29 2022 david.anes@suse.com
- update to 2.4.8:
  * Other changes:
  - pkg-config: Move "-lm" to section "Libs.private"
  - CMake|MSVC: Fix pkg-config section "Libs"
  - CMake|macOS: Start using linker arguments
    "-compatibility_version <version>" and
    "-current_version <version>" in a way compatible with GNU
    Libtool
  - Version info bumped from 9:7:8 to 9:8:8;
    see https://verbump.de/ for what these numbers do
* Sat Mar  5 2022 david.anes@suse.com
- update to 2.4.7 (bsc#1196784, CVE-2022-25236):
  * Bug fixes:
  - Relax fix to CVE-2022-25236 (introduced with release 2.4.5)
    with regard to all valid URI characters (RFC 3986),
    i.e. the following set (excluding whitespace):
    ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz
    0123456789 %% -._~ :/?#[]@ !$&'()*+,;=
  * Other changes:
  - CMake|Windows: Store Expat version in the DLL
  - Document consequences of namespace separator choices not just
    in doc/reference.html but also in header <expat.h>
  - Document Expat's lack of validation of namespace URIs against
    RFC 3986, and that the XML 1.0r4 specification doesn't
    require Expat to validate namespace URIs, and that Expat
    may do more in that regard in future releases.
    If you find need for strict RFC 3986 URI validation on
    application level today, https://uriparser.github.io/ may
    be of interest.
  - Fix documentation of XML_EndDoctypeDeclHandler in <expat.h>
  - Document that a call to XML_FreeContentModel can be done at
    a later time from outside the element declaration handler
  - Make hardcoded namespace URIs easier to find in code
  - Update documentation on use of XML_POOR_ENTOPY on Solaris
  - tests: Resolve use of macros NAN and INFINITY for GNU G++
    4.8.2 on Solaris.
  - Version info bumped from 9:6:8 to 9:7:8;
    see https://verbump.de/ for what these numbers do
* Sun Feb 20 2022 david.anes@suse.com
- update to 2.4.6 (bsc#1196168, CVE-2022-25313):
  * Bug fixes:
  - Fix a regression introduced by the fix for CVE-2022-25313
    in release 2.4.5 that affects applications that (1)
    call function XML_SetElementDeclHandler and (2) are
    parsing XML that contains nested element declarations
    (e.g. "<!ELEMENT junk ((bar|foo|xyz+), zebra*)>").
  - Version info bumped from 9:5:8 to 9:6:8;
    see https://verbump.de/ for what these numbers do.
* Sat Feb 19 2022 david.anes@suse.com
- update to 2.4.5 (bsc#1196171, bsc#1196169, bsc#1196168,
  bsc#1196026, bsc#1196025):
  * Security fixes:
  - CVE-2022-25235 -- Passing malformed 2- and 3-byte UTF-8
    sequences (e.g. from start tag names) to the XML
    processing application on top of Expat can cause
    arbitrary damage (e.g. code execution) depending
    on how invalid UTF-8 is handled inside the XML
    processor; validation was not their job but Expat's.
    Exploits with code execution are known to exist.
  - CVE-2022-25236 -- Passing (one or more) namespace separator
    characters in "xmlns[:prefix]" attribute values
    made Expat send malformed tag names to the XML
    processor on top of Expat which can cause
    arbitrary damage (e.g. code execution) depending
    on such unexpectable cases are handled inside the XML
    processor; validation was not their job but Expat's.
    Exploits with code execution are known to exist.
  - CVE-2022-25313 -- Fix stack exhaustion in doctype parsing
    that could be triggered by e.g. a 2 megabytes
    file with a large number of opening braces.
    Expected impact is denial of service or potentially
    arbitrary code execution.
  - CVE-2022-25314 -- Fix integer overflow in function copyString;
    only affects the encoding name parameter at parser creation
    time which is often hardcoded (rather than user input),
    takes a value in the gigabytes to trigger, and a 64-bit
    machine.  Expected impact is denial of service.
  - CVE-2022-25315 -- Fix integer overflow in function storeRawNames;
    needs input in the gigabytes and a 64-bit machine.
    Expected impact is denial of service or potentially
    arbitrary code execution.
  * Other changes:
  - Version info bumped from 9:4:8 to 9:5:8;
    see https://verbump.de/ for what these numbers do
* Mon Jan 31 2022 david.anes@suse.com
- update to 2.4.4 (bsc#1195217, bsc#1195054):
  * Security fixes:
  - CVE-2022-23852 -- Fix signed integer overflow
    (undefined behavior) in function XML_GetBuffer
    that is also called by function XML_Parse internally)
    for when XML_CONTEXT_BYTES is defined to >0 (which is both
    common and default).
    Impact is denial of service or more.
  - CVE-2022-23990 -- Fix unsigned integer overflow in function
    doProlog triggered by large content in element type
    declarations when there is an element declaration handler
    present (from a prior call to XML_SetElementDeclHandler).
    Impact is denial of service or more.
  * Bug fixes:
  - xmlwf: Fix a memory leak on output file opening error
  * Other changes:
  - Version info bumped from 9:3:8 to 9:4:8;
    see https://verbump.de/ for what these numbers do
  * Drop unused file valid-xhtml10.png
* Mon Jan 17 2022 dmueller@suse.com
- update to 2.4.3 (bsc#1194251, bsc#1194362, bsc#1194474,
    bsc#1194476, bsc#1194477, bsc#1194478, bsc#1194479, bsc#1194480):
  * CVE-2021-45960 -- Fix issues with left shifts by >=29 places
    resulting in
    a) realloc acting as free
    b) realloc allocating too few bytes
    c) undefined behavior
    depending on architecture and precise value
    for XML documents with >=2^27+1 prefixed attributes
    on a single XML tag a la
    "<r xmlns:a='[..]' a:a123='[..]' [..] />"
    where XML_ParserCreateNS is used to create the parser
    (which needs argument "-n" when running xmlwf).
    Impact is denial of service, or more.
  * CVE-2021-46143 (ZDI-CAN-16157) -- Fix integer overflow
    on variable m_groupSize in function doProlog leading
    to realloc acting as free.
    Impact is denial of service or more.
  * CVE-2022-22822 to CVE-2022-22827 -- Prevent integer overflows
    near memory allocation at multiple places.  Mitre assigned
    a dedicated CVE for each involved internal C function:
  - CVE-2022-22822 for function addBinding
  - CVE-2022-22823 for function build_model
  - CVE-2022-22824 for function defineAttribute
  - CVE-2022-22825 for function lookup
  - CVE-2022-22826 for function nextScaffoldPart
  - CVE-2022-22827 for function storeAtts
    Impact is denial of service or more.
* Mon Dec 27 2021 dmueller@suse.com
- update to 2.4.2:
  * Link againgst libm for function "isnan"
  * Include expat_config.h as early as possible
  * Autotools: Include files with release archives:
  - buildconf.sh
  - fuzz/*.c
  * Autotools: Sync CMake templates
  * docs: Document that function XML_GetBuffer may return NULL
    when asking for a buffer of 0 (zero) bytes size
  * docs: Fix return value docs for both
    XML_SetBillionLaughsAttackProtection* functions
  * Version info bumped from 9:1:8 to 9:2:8
* Mon May 24 2021 pmonreal@suse.com
- Update to 2.4.1:
  * Bug fixes:
  - Autotools: Fix installed header expat_config.h for multilib
    systems; regression introduced in 2.4.0 by pull request #486
  * Other changes:
  - Version info bumped from 9:0:8 to 9:1:8; see
    https://verbump.de/ for what these numbers do
* Mon May 24 2021 pmonreal@suse.com
- Update to 2.4.0: [CVE-2013-0340 "Billion Laughs"]
  * Security fixes:
  - CVE-2013-0340/CWE-776 -- Protect against billion laughs attacks
    (denial-of-service; flavors targeting CPU time or RAM or both,
    leveraging general entities or parameter entities or both)
    by tracking and limiting the input amplification factor
    (<amplification> := (<direct> + <indirect>) / <direct>).
    By conservative default, amplification up to a factor of 100.0
    is tolerated and rejection only starts after 8 MiB of output bytes
    (=<direct> + <indirect>) have been processed.
    The fix adds the following to the API:
  - A new error code XML_ERROR_AMPLIFICATION_LIMIT_BREACH to
    signals this specific condition.
  - Two new API functions ..
  - XML_SetBillionLaughsAttackProtectionMaximumAmplification and
  - XML_SetBillionLaughsAttackProtectionActivationThreshold
    .. to further tighten billion laughs protection parameters
    when desired.  Please see file "doc/reference.html" for details.
    If you ever need to increase the defaults for non-attack XML
    payload, please file a bug report with libexpat.
  - Two new XML_FEATURE_* constants ..
  - that can be queried using the XML_GetFeatureList function, and
  - that are shown in "xmlwf -v" output.
  - Two new environment variable switches ..
  - EXPAT_ACCOUNTING_DEBUG=(0|1|2|3) and
  - EXPAT_ENTITY_DEBUG=(0|1)
    .. for runtime debugging of accounting and entity processing.
    Specific behavior of these values may change in the future.
  - Two new command line arguments "-a FACTOR" and "-b BYTES"
    for xmlwf to further tighten billion laughs protection
    parameters when desired.
    If you ever need to increase the defaults for non-attack XML
    payload, please file a bug report with libexpat.
  * Bug fixes:
  - For (non-default) compilation with -DEXPAT_MIN_SIZE=ON (CMake)
    or CPPFLAGS=-DXML_MIN_SIZE (GNU Autotools): Fix segfault
    for UTF-16 payloads containing CDATA sections.
  - Autotools: Fix generated CMake files for non-64bit and
    non-Linux platforms (e.g. macOS and MinGW in particular)
    that were introduced with release 2.3.0
  * Other changes:
  - xmlwf: Improve help output and the xmlwf man page
  - xmlwf: Improve maintainability through some refactoring
  - xmlwf: Fix man page DocBook validity
  - CMake: Support absolute paths for both CMAKE_INSTALL_LIBDIR
    and CMAKE_INSTALL_INCLUDEDIR
  - CMake: Add support for standard variable BUILD_SHARED_LIBS
  - Unexpose symbol _INTERNAL_trim_to_complete_utf8_characters
  - Resolve macro HAVE_EXPAT_CONFIG_H
  - Delete unused legacy helper file "conftools/PrintPath"
  - doc/reference.html: Fix XHTML validity
  - doc/reference.html: Replace the 90s look by OK.css
  - Version info bumped from 8:0:7 to 9:0:8 due to addition of
    new symbols and error codes; see https://verbump.de/ for
    what these numbers do
* Tue Apr 13 2021 dimstar@opensuse.org
- Do not BuildRequire cmake: expat is part of the distro bootstrap
  cycle and any additional dependency makes the ring larger. In
  this case here, cmake was even only used to own a directory.
* Tue Apr  6 2021 dmueller@suse.com
- update to 2.3.0:
  * When calling XML_ParseBuffer without a prior successful call to
    XML_GetBuffer as a user, no longer trigger undefined behavior
    (by adding an integer to a NULL pointer) but rather return
    XML_STATUS_ERROR and set the error code to (new) code
    XML_ERROR_NO_BUFFER. Found by UBSan (UndefinedBehaviorSanitizer)
    of Clang 11 (but not Clang 9).
  * xmlwf: Exit status 2 was used for both:
  - malformed input files (documented) and
  - invalid command-line arguments (undocumented).
    case of invalid command-line arguments now
    has its own exit status 4, resolving the ambiguity.
  * Other changes
* Sun Oct  4 2020 pmonreal@suse.com
- Update to 2.2.10:
  * Bug fixes:
  - Fix undefined behavior during parsing caused by pointer
    arithmetic with NULL pointers
  - Fix reading uninitialized variable during parsing
  - xmlwf: Add missing check for malloc NULL return
  * Other changes:
  - xmlwf: Document exit codes in xmlwf manpage and exit with code 3
    (rather than code 1) for output errors when used with "-d DIRECTORY"
  - Autotools: Use -Werror while configure tests the compiler for
    supported compile flags to avoid false positives
  - Autotools: Improve handling of user (C|CPP|CXX|LD)FLAGS, e.g.
    ensure that they have the last word over flags added while
    running ./configure
  - CMake: Create libexpatw.{dll,so} and expatw.pc (with emphasis
    on suffix "w") with -DEXPAT_CHAR_TYPE=(ushort|wchar_t)
  - CMake: Detect and deny unsupported build combinations
    involving -DEXPAT_CHAR_TYPE=(ushort|wchar_t)
  - CMake: Install pre-compiled shipped xmlwf.1 manpage in case
    of -DEXPAT_BUILD_DOCS=OFF
  - CMake: Fix use of Expat by means of add_subdirectory
  - CMake: Keep expat target name constant at "expat" (i.e. refrain
    from using the target name to control build artifact filenames)
  - CMake: Expose man page compilation as target "xmlwf-manpage"
  - CMake: Introduce option EXPAT_BUILD_PKGCONFIG to control
    generation of pkg-config file "expat.pc"
  - CMake: Add minimalistic support for building binary packages
    with CMake target "package"; based on CPack
  - CMake: Add option -DEXPAT_OSSFUZZ_BUILD=(ON|OFF) with default
    OFF to build fuzzer code against OSS-Fuzz and related
    environment variable LIB_FUZZING_ENGINE
  - Fix testsuite for -DEXPAT_DTD=OFF and -DEXPAT_NS=OFF
  - Address compiler warnings
  - Address pngcheck warnings with doc/*.png images: Version info
    bumped from 7:11:6 to 7:12:6
* Fri Nov 29 2019 pmonrealgonzalez@suse.com
- Version update to 2.2.9
  * Other changes:
  - examples: Drop executable bits from elements.c
    [#349]  Windows: Change the name of the Windows DLLs from expat*.dll
    to libexpat*.dll once more (regression from 2.2.8, first
    fixed in 1.95.3, issue #61 on SourceForge today,
    was issue #432456 back then); needs a fix due
    case-insensitive file systems on Windows and the fact that
    Perl's XML::Parser::Expat compiles into Expat.dll.
    [#347]  Windows: Only define _CRT_RAND_S if not defined
    Version info bumped from 7:10:6 to 7:11:6
* Mon Sep 16 2019 pmonrealgonzalez@suse.com
- Version update to 2.2.8
  * Security fixes: (CVE-2019-15903, bsc#1149429)
  - CVE-2019-15903 -- Fix heap overflow triggered by XML_GetCurrentLineNumber
    (or XML_GetCurrentColumnNumber), and deny internal entities closing the doctype;
  * Bug fixes:
  - Fix cases where XML_StopParser did not have any effect
    when called from inside of an end element handler
  - xmlwf: Fix exit code for operation without "-d DIRECTORY";
    previously, only "-d DIRECTORY" would give you a proper exit code:
    Now both cases return exit code 2.
  * Other changes:
  - examples: Improve elements.c
  - Autotools: Add argument --enable-xml-attr-info
  - Autotools: Add arguments --with-getrandom --without-getrandom --with-sys-getrandom --without-sys-getrandom
  - Autotools: Fix linking issues with "./configure LD=clang"
  - Autotools: Fix "make run-xmltest" for out-of-source builds
  - CMake: Pull all options from Expat <=2.2.7 into namespace
  - CMake: Add argument -DEXPAT_ATTR_INFO=(ON|OFF), default OFF
  - CMake: Add argument -DEXPAT_LARGE_SIZE=(ON|OFF), default OFF
  - CMake: Add argument -DEXPAT_MIN_SIZE=(ON|OFF), default OFF
  - CMake: Add arguments -DEXPAT_WITH_GETRANDOM=(ON|OFF|AUTO), default AUTO
  - CMake: Add arguments -DEXPAT_WITH_SYS_GETRANDOM=(ON|OFF|AUTO), default AUTO
  - CMake: Install expat_config.h to include directory
  - CMake: Generate and install configuration files for future find_package(expat [..] CONFIG [..])
  - CMake: Now produces a summary of applied configuration
  - CMake: Require C++ compiler only when tests are enabled
  - CMake: Fix compilation for 16bit character types, i.e. ex -DXML_UNICODE=ON (and ex -DXML_UNICODE_WCHAR_T=ON)
  - CMake: Port "make run-xmltest" from GNU Autotools to CMake
  - CMake: Integrate OSS-Fuzz fuzzers, option -DEXPAT_BUILD_FUZZERS=(ON|OFF), default OFF
- Removed patches fixed in the update:
  * expat-CVE-2019-15903.patch
  * expat-CVE-2019-15903-tests.patch
* Wed Sep  4 2019 pmonrealgonzalez@suse.com
- Security fix (CVE-2019-15903, bsc#1149429)
  * Crafted XML input results in heap-based buffer over-read by fooling
    the parser into changing from DTD parsing to document parsing
  * Added patches:
  - expat-CVE-2019-15903.patch
  - expat-CVE-2019-15903-tests.patch
* Tue Jul  2 2019 pmonrealgonzalez@suse.com
- Version update to 2.2.7 (CVE-2018-20843, bsc#1139937)
  * Security fixes:
  - CVE-2018-20843 - Fix extraction of namespace prefixes from
    XML names; XML names with multiple colons could end up in
    the wrong namespace, and take a high amount of RAM and CPU
    resources while processing, opening the door to use for
    denial-of-service attacks
  * Other changes:
  - Autotools/CMake: Utilize -fvisibility=hidden to stop
    exporting non-API symbols
  - Autotools: Add --without-examples and --without-tests
  - Autotools: Modernize configure.ac
  - Autotools: Fix check for -fvisibility=hidden for Clang
  - Autotools: Fix compilation for lack of docbook2x-man
  - CMake: Make libdir of pkgconfig expat.pc support multilib
  - CMake: Build man page in PROJECT_BINARY_DIR not _SOURCE_DIR
  - Remove fallback to bcopy, assume that memmove(3) exists
- Removed expat-2.2.6-fix-make-clean.patch
* Thu Feb  7 2019 bwiedemann@suse.com
- Add expat-2.2.6-fix-make-clean.patch
- Allow profile guided optimization again
* Thu Jan  3 2019 tchvatal@suse.com
- Drop docbook2x dependency, the manpages are generated in
  the upstream archive and this way we break buildcycle
* Tue Sep 11 2018 pmonrealgonzalez@suse.com
- Version update to 2.2.6 Sun August 12 2018
  * Bug fixes:
  - Avoid doing arithmetic with NULL pointers in XML_GetBuffer
  - Fix 2.2.5 regression with suspend-resume while parsing
    a document like '<root/>'
  * Other changes:
  - Autotools: Fix docbook-related configure syntax error
  - Autotools: Avoid grep option `-q` for Solaris
  - Autotools: Support
    ./configure DOCBOOK_TO_MAN="xmlto man --skip-validation"
  - Autotools: Support DOCBOOK_TO_MAN command which produces
    xmlwf.1 rather than XMLWF.1; also covers case insensitive
    file systems
  - Autotools: Drop -rpath option passed to libtool
  - Autotools: Detect and deny SGML docbook2man as ours is XML
  - Autotools/CMake: Support command db2x_docbook2man as well
  - CMake: Introduce option WARNINGS_AS_ERRORS, defaults to OFF
  - CMake: Introduce option MSVC_USE_STATIC_CRT, defaults to OFF
  - CMake: Introduce option XML_UNICODE and XML_UNICODE_WCHAR_T,
    both defaulting to OFF
  - CMake: Prefer check_symbol_exists over check_function_exists
  - CMake: Create the same pkg-config file as with GNU Autotools
  - CMake: Use GNUInstallDirs module to set proper defaults for
    install directories
  - CMake: Utilize expat_config.h.cmake for XML_DEV_URANDOM
  - Address compiler warnings
  - Fix miscellaneous typos
* Thu Nov 16 2017 jengelh@inai.de
- Expand description of expat-devel.
* Thu Nov 16 2017 mpluskal@suse.com
- Do not generate manpages from docbook
- Temporarily disable profiling due to bug in build system
* Wed Nov  8 2017 aavindraa@gmail.com
- Version update to 2.2.5 Tue October 31 2017
  * Bug fixes:
  - If the parser runs out of memory, make sure its internal
    state reflects the memory it actually has, not the memory
    it wanted to have.
  - The default handler wasn't being called when it should for
    a SYSTEM or PUBLIC doctype if an entity declaration handler
    was registered.
  - Fix a case of mistakenly reported parsing success where
    XML_StopParser was called from an element handler
  - Function XML_ErrorString was returning NULL rather than
    a message for code XML_ERROR_INVALID_ARGUMENT
    introduced with release 2.2.1
  * Other changes:
  - Add argument -N adding notation declarations
  - various compiler-specific fixes
  - Improve docbook2x-man detection
- drop expat-docbook.patch
  * fixed in 0f5186c7b8e503c669e332d944712de010b265f3
- switch to github for release tarballs and website
* Thu Oct 26 2017 pmonrealgonzalez@suse.com
- Version update to 2.2.4 Sat August 19 2017
  * Bug fixes:
    [#115]  Fix copying of partial characters for UTF-8 input
  * Other changes:
    [#109]  Fix "make check" for non-x86 architectures that default
    to unsigned type char (-128..127 rather than 0..255)
    [#109]  coverage.sh: Cover -funsigned-char
    Autotools: Introduce --without-xmlwf argument
    [#65]  Autotools: Replace handwritten Makefile with GNU Automake
    [#43]  CMake: Auto-detect high quality entropy extractors, add new
    option USE_libbsd=ON to use arc4random_buf of libbsd
    [#74]  CMake: Add -fno-strict-aliasing only where supported
    [#114]  CMake: Always honor manually set BUILD_* options
    [#114]  CMake: Compile man page if docbook2x-man is available, only
    [#117]  Include file tests/xmltest.log.expected in source tarball
    (required for "make run-xmltest")
    [#111]  Fix some typos in documentation
    Version info bumped from 7:5:6 to 7:6:6
- Release 2.2.3 Wed August 2 2017
  * Bug fixes:
    [#85]  Fix a dangling pointer issue related to realloc
  * Other changes:
    [#91]  Linux: Allow getrandom to fail if nonblocking pool has not
    yet been initialized and read /dev/urandom then, instead.
    This is in line with what recent Python does.
    [#86]  Check that a UTF-16 encoding in an XML declaration has the
    right endianness
  [#4] #5 #7  Recover correctly when some reallocations fail
    Repair "./configure && make" for systems without any
    provider of high quality entropy
    and try reading /dev/urandom on those
    Ensure that user-defined character encodings have converter
    functions when they are needed
    Fix mis-leading description of argument -c in xmlwf.1
    Rely on macro HAVE_ARC4RANDOM_BUF (rather than __CloudABI__)
    for CloudABI
    [#100]  Fix use of SIPHASH_MAIN in siphash.h
    [#23]  Test suite: Fix memory leaks
    Version info bumped from 7:4:6 to 7:5:6
- Release 2.2.2 Wed July 12 2017
  * Security fixes:
    [#43]  Protect against compilation without any source of high
    quality entropy enabled, e.g. with CMake build system;
  * [MOX-006] Fix non-NULL parser parameter validation in XML_Parse;
    resulted in NULL dereference, previously;
  * Bug fixes:
    [#69]  Fix improper use of unsigned long long integer literals
  * Other changes:
    [#73]  Start requiring a C99 compiler
    [#49]  Fix "==" Bashism in configure script
    [#58]  Address compile warnings
    [#68]  Fix "./buildconf.sh && ./configure" for some versions
    of Dash for /bin/sh
    [#72]  CMake: Ease use of Expat in context of a parent project
    with multiple CMakeLists.txt files
    [#72]  CMake: Resolve mistaken executable permissions
    [#76]  Address compile warning with -DNDEBUG (not recommended!)
    [#77]  Address compile warning about macro redefinition
  * Added patch expat-docbook.patch to compile the man pages with
  docbook-to-man
  * Cleaned spec file with spec-cleaner
* Sat Oct  7 2017 jayvdb@gmail.com
- Allow building when do_profiling is undefined
* Tue Jul 11 2017 mpluskal@suse.com
- Build with profiling when possible
* Tue Jul  4 2017 meissner@suse.com
- Version update to 2.2.1 Sat June 17 2017
  - Security fixes:
    CVE-2017-9233 / bsc#1047236 -- External entity infinite loop DoS
    Details: https://libexpat.github.io/doc/cve-2017-9233/
    Commit c4bf96bb51dd2a1b0e185374362ee136fe2c9d7f
  - [MOX-002]      CVE-2016-9063 / bsc#1047240 -- Detect integer overflow;
    (Fixed version of existing downstream patches!)
  - (SF.net) #539  Fix regression from fix to CVE-2016-0718 cutting off
    longer tag names;
    [#25]  More integer overflow detection (function poolGrow);
  - [MOX-002]      Detect overflow from len=INT_MAX call to XML_Parse;
  - [MOX-005] #30  Use high quality entropy for hash initialization:
  * arc4random_buf on BSD, systems with libbsd
    (when configured with --with-libbsd), CloudABI
  * RtlGenRandom on Windows XP / Server 2003 and later
  * getrandom on Linux 3.17+
    In a way, that's still part of CVE-2016-5300.
    https://github.com/libexpat/libexpat/pull/30/commits
  - [MOX-005] For the low quality entropy extraction fallback code,
    the parser instance address can no longer leak,
  - [MOX-003] Prevent use of uninitialised variable; commit
  - [MOX-004] a4dc944f37b664a3ca7199c624a98ee37babdb4b
    Add missing parameter validation to public API functions
    and dedicated error code XML_ERROR_INVALID_ARGUMENT:
  - [MOX-006] * NULL checks; commits
  * Negative length (XML_Parse); commit
  - [MOX-002] 70db8d2538a10f4c022655d6895e4c3e78692e7f
  - [MOX-001] #35  Change hash algorithm to William Ahern's version of SipHash
    to go further with fixing CVE-2012-0876.
    https://github.com/libexpat/libexpat/pull/39/commits
  - Bug fixes:
    [#32] Fix sharing of hash salt across parsers;
    relevant where XML_ExternalEntityParserCreate is called
    prior to XML_Parse, in particular (e.g. FBReader)
    [#28] xmlwf: Auto-disable use of memory-mapping (and parsing
    as a single chunk) for files larger than ~1 GB (2^30 bytes)
    rather than failing with error "out of memory"
    [#3]  Fix double free after malloc failure in DTD code; commit
    7ae9c3d3af433cd4defe95234eae7dc8ed15637f
    [#17] Fix memory leak on parser error for unbound XML attribute
    prefix with new namespaces defined in the same tag;
    found by Google's OSS-Fuzz; commits
    xmlwf on Windows: Add missing calls to CloseHandle
  - New features:
    [#30] Introduced environment switch EXPAT_ENTROPY_DEBUG=1
    for runtime debugging of entropy extraction
    Bump version info from 7:2:6 to 7:3:6
* Mon Jul 18 2016 jengelh@inai.de
- Remove pointless --with-pic (for static only)
* Thu Jul 14 2016 tchvatal@suse.com
- Version update to 2.2.0:
  * Fixes bnc#983215 CVE-2012-6702
  * Fixes bnc#983216 CVE-2016-5300
  * Various cmake and autotools script updates
  * Fix detection of utf8 character boundaries
- Remove all patches merged upstream:
  * expat-2.1.1-avoid_relying_on_undef_behaviour.patch
  * expat-2.1.1-parser_crashes_on_malformed_input.patch
  * expat-alloc-size.patch
  * expat-visibility.patch
* Wed May 18 2016 kstreitova@suse.com
- add expat-2.1.1-avoid_relying_on_undef_behaviour.patch to avoid
  relying on undefined behavior in the original CVE-2015-1283 fix
  [bnc#980391], [bnc#983985], [CVE-2016-4472]
- add expat-2.1.1-parser_crashes_on_malformed_input.patch to fix
  Expat XML parser that mishandles certain kinds of malformed input
  documents [bnc#979441], [CVE-2016-0718]
- use spec-cleaner to clean specfile
* Fri Apr  1 2016 crrodriguez@opensuse.org
- After simplification of expat-visibility.patch, it became
  uneffective as no symbols are getting hidden. add
  - fvisibility=hidden to CFLAGS again.
- expat-alloc-size.patch: fix braino, realloc()-like functions
  should not take __attribute__(malloc)
* Wed Mar 23 2016 idonmez@suse.com
- Update to version 2.1.1
  * Fixes CVE-2015-1283 — Multiple integer overflows in the
    XML_GetBuffer function
  * Fix potential null pointer dereference
  * Symbol XML_SetHashSalt was not exported
  * Output of xmlwf -h was incomplete
  * Document behavior of calling XML_SetHashSalt with salt 0
  * Minor improvements to man page xmlwf(1)
- Simplify expat-visibility.patch, refresh expat-alloc-size.patch
- Drop config-guess-sub-update.patch, fixed upstream.
* Sat Jul 11 2015 mpluskal@suse.com
- Cleanup spec file with spec-cleaner
- Remove old ppc obsoletes/provides
* Tue Mar 26 2013 mmeister@suse.com
- Added url as source.
  Please see http://en.opensuse.org/SourceUrls
* Thu Feb 21 2013 jengelh@inai.de
- Sanitize description of expat (replace it with a more current
  one from the homepage)
* Mon Feb  4 2013 schwab@suse.de
- Update config.guess/sub for aarch64
* Wed Jan 23 2013 pgajdos@suse.com
- fix of fix of [bnc#798644]
- according to upstream changelog:
  - Improved ability to build without the configure-generated
    expat_config.h header.  This is useful for applications
    which embed Expat rather than linking in the library.
  because I am not exactly sure about implication of this, rather use
  - DXML_HAVE_VISIBILITY in CFLAG_VISIBILITY in expat-visibility.patch
* Tue Jan 22 2013 jengelh@inai.de
- Executing autoreconf requires autoconf BuildRequire
* Fri Jan 18 2013 pgajdos@suse.com
- really hide private Xml* symbols [bnc#798644]
  * modified visibility.patch
* Tue Apr 10 2012 tabraham@novell.com
- update to 2.1.0
  - Bug Fixes:
    [#1742315]: Harmful XML_ParserCreateNS suggestion.
    [#2895533]: CVE-2012-1147 - Resource leak in readfilemap.c.
    [#1785430]: Expat build fails on linux-amd64 with gcc version>=4.1 -O3.
    [#1983953], 2517952, 2517962, 2649838:
    Build modifications using autoreconf instead of buildconf.sh.
    [#2815947], #2884086: OBJEXT and EXEEXT support while building.
    [#1990430]: CVE-2009-3720 - Parser crash with special UTF-8 sequences.
    [#2517938]: xmlwf should return non-zero exit status if not well-formed.
    [#2517946]: Wrong statement about XMLDecl in xmlwf.1 and xmlwf.sgml.
    [#2855609]: Dangling positionPtr after error.
    [#2894085]: CVE-2009-3560 - Buffer over-read and crash in big2_toUtf8().
    [#2958794]: CVE-2012-1148 - Memory leak in poolGrow.
    [#2990652]: CMake support.
    [#3010819]: UNEXPECTED_STATE with a trailing "%%" in entity value.
    [#3206497]: Unitialized memory returned from XML_Parse.
    [#3287849]: make check fails on mingw-w64.
    [#3496608]: CVE-2012-0876 - Hash DOS attack.
  - Patches:
    [#1749198]: pkg-config support.
    [#3010222]: Fix for bug #3010819.
    [#3312568]: CMake support.
    [#3446384]: Report byte offsets for attr names and values.
  - New Features / API changes:
  * Added new API member XML_SetHashSalt() that allows setting an
    intial value (salt) for hash calculations. This is part of the
    fix for bug #3496608 to randomize hash parameters.
  * When compiled with XML_ATTR_INFO defined, adds new API member
    XML_GetAttributeInfo() that allows retrieving the byte
    offsets for attribute names and values (patch #3446384).
  * Added CMake build system.  See bug #2990652 and patch #3312568.
  * Added run-benchmark target to Makefile.in - relies on testdata
    module present in the same relative location as in the repository.
* Tue Mar  6 2012 tabraham@novell.com
- update to 2.1.0 beta
  * refreshed expat-visibility.patch
  * removed obsolete expat-CVE-2009-3560.patch
  * removed obsolete expat-CVE-2009-2625.patch
  - hash table DOS attack fix
  - accumulated bug fixes and some changes to the build system
  - new conditional feature to make byte offsets for attributes
    and attribute names available
* Sun Feb 12 2012 crrodriguez@opensuse.org
- Put libraries back to %%{_libdir}, /usr merge project
* Fri Dec  2 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Sun Oct 30 2011 crrodriguez@opensuse.org
- Hide non public symbols reusing existing win32 API export/imports
- annotate malloc/realloc-like functions with attribute alloc_size
  to catch possible misuses in calling code.
* Sun Sep 18 2011 jengelh@medozas.de
- Remove redundant/obsolete tags/sections from specfile
  (cf. packaging guidelines)
- Use %%_smp_mflags for parallel build
- Add libexpat-devel to baselibs
* Fri Feb 25 2011 prusnak@opensuse.org
- fix license (MIT) in spec file
* Fri Jan  8 2010 prusnak@suse.cz
- fix CVE-2009-3560.patch [bnc#566434]
* Sun Dec 13 2009 jengelh@medozas.de
- add baselibs.conf as a source
* Fri Dec  4 2009 prusnak@suse.cz
- fix DoS (CVE-2009-3560.patch) [bnc#558892]
* Thu Oct 29 2009 prusnak@suse.cz
- fix DoS (CVE-2009-2625.patch) [bnc#550664]
* Sun Apr  5 2009 crrodriguez@suse.de
- test suite requires gcc-c++ to compile
* Thu Feb 19 2009 crrodriguez@suse.de
- remove static libraries, shouldnt be needed anymore.
- run make check
* Wed Dec 10 2008 olh@suse.de
- use Obsoletes: -XXbit only for ppc64 to help solver during distupgrade
  (bnc#437293)
* Thu Oct 30 2008 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Sat Jul 28 2007 coolo@suse.de
- fix devel symlink
* Wed Jul 25 2007 prusnak@suse.cz
- move libraries from /usr/lib to /lib [#285472]
- replace deprecated %%run_ldconfig with /sbin/ldconfig
* Thu Jun  7 2007 prusnak@suse.cz
- update to 2.0.1:
  ( from Changes )
  * Fixed bugs #1515266, 1515600: The character data handler's calling
    of XML_StopParser() was not handled properly; if the parser was
    stopped and the handler set to NULL, the parser would segfault.
  * Fixed bug #1690883: Expat failed on EBCDIC systems as it assumed
    some character constants to be ASCII encoded.
  * Minor cleanups of the test harness.
  * Fixed xmlwf bug #1513566: "out of memory" error on file size zero.
  * Fixed outline.c bug #1543233: missing a final XML_ParserFree() call.
  * Fixes and improvements for Windows platform:
    bugs #1409451, #1476160, 1548182, 1602769, 1717322.
  * Build fixes for various platforms:
    HP-UX, Tru64, Solaris 9: patch #1437840, bug #1196180.
    All Unix: #1554618 (refreshed config.sub/config.guess).
    [#1490371], #1613457: support both, DESTDIR and INSTALL_ROOT,
    without relying on GNU-Make specific features.
    [#1647805]: Patched configure.in to work better with Intel compiler.
  * Fixes to Makefile.in to have make check work correctly:
    bugs #1408143, #1535603, #1536684.
  * Added Open Watcom support: patch #1523242.
* Tue Apr 17 2007 prusnak@suse.cz
- split libexpat1 and libexpat-devel subpackages [#260214]
* Thu Oct 19 2006 dmueller@suse.de
- strip .la file
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Thu Jan 12 2006 ro@suse.de
- fixed file list for debuginfo package (do not pack all of libdir)
* Wed Jan 11 2006 mjancar@suse.cz
- update to 2.0.0
* Mon Jan  9 2006 mjancar@suse.cz
- update to 2.0 pre release
* Wed Nov 10 2004 ro@suse.de
- fixed filelist
* Mon Aug  9 2004 tcrhak@suse.cz
- update to 1.95.8
* Thu Feb  5 2004 kukuk@suse.de
- Build as user
* Thu Feb  5 2004 tcrhak@suse.cz
- update to version 1.95.7
* Tue Feb 18 2003 tcrhak@suse.cz
- in expat.h, declare enum XML_Status before using it;
  put into patch "...-header.diff" [bug #23742]
* Mon Feb 17 2003 tcrhak@suse.cz
- updated to version 1.95.6
* Sun Dec 22 2002 tcrhak@suse.cz
- update to version 1.95.5
* Sat Jul 13 2002 tcrhak@suse.cz
- update to version 1.95.4
* Thu Mar 28 2002 tcrhak@suse.cz
- added parameter --target to configure
* Mon Jan 14 2002 rvasice@suse.cz
- use %%{_libdir} and %%{_lib}
* Tue Nov 20 2001 rvasice@suse.cz
- fix URL in spec file
* Wed Aug 15 2001 rvasice@suse.cz
- update to version 1.95.2
- spec file cleanup
- added DESTDIR
* Mon May 14 2001 pblaha@suse.cz
- fixed links for soname of libexpat.so*
* Fri May 11 2001 cihlar@suse.cz
- fixed soname of libexpat.so.1.2
* Fri Jan  5 2001 pblaha@suse.cz
- back on stable version 1.2  added build shared libexpat.so
* Thu Jan  4 2001 pblaha@suse.cz
- update on 1.95.1 on sourgeforge needed for midgard
- new description
* Thu Mar  9 2000 ke@suse.de
- Don't "install" symlinks; use "cp"; reported by bs; proposed fix
  by ro.
- Cleanup the spec file: better Group tag; more accurate files list.
* Tue Nov 23 1999 ke@suse.de
- first SuSE package: version 1.1.
- apply Debian patch to build shared libs.
- build libexpat.a.
