#
# spec file for package ca-certificates-mozilla
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


# ensure p11-kit has the required features on SLE for
# https://bugzilla.suse.com/show_bug.cgi?id=1154871
%if 0%{?suse_version} == 1500
%if 0%{?is_opensuse}
# Leap 15.1
%define p11_kit_min 0.23.2-lp151.4.3.1
%else
# 15GA
%define p11_kit_min 0.23.2-4.5.2
%endif
%else
%if 0%{?suse_version} == 1315 && 0%{?sle_version} > 120300
# 12SP3
%define p11_kit_min 0.20.7-3.3.1
%endif
%endif
#
# Taken from p11-kit, to avoid a build cycle
%define pkidir_static    %{_datadir}/pki
%define trustdir_static  %{pkidir_static}/trust
%define certdir %{trustdir_static}
Name:           ca-certificates-mozilla
# Version number is NSS_BUILTINS_LIBRARY_VERSION in this file:
# http://hg.mozilla.org/projects/nss/file/default/lib/ckfw/builtins/nssckbi.h
Version:        2.74
Release:        150200.41.1
Summary:        CA certificates for OpenSSL
License:        MPL-2.0
Group:          Productivity/Networking/Security
URL:            https://www.mozilla.org
# IMPORTANT: procedure to update certificates:
# - Check the log of the cert file:
#   http://hg.mozilla.org/projects/nss/log/default/lib/ckfw/builtins/certdata.txt
# - download the new certdata.txt
#   wget -O certdata.txt "http://hg.mozilla.org/projects/nss/file/default/lib/ckfw/builtins/certdata.txt"
# - run compareoldnew to show fingerprints of new and changed certificates
# - check the bugs referenced in hg log and compare the checksum
#   to output of compareoldnew
# - Watch out that blacklisted or untrusted certificates are not
#   accidentally included!
Source:         https://hg.mozilla.org/projects/nss/raw-file/default/lib/ckfw/builtins/certdata.txt
Source1:        https://hg.mozilla.org/projects/nss/raw-file/default/lib/ckfw/builtins/nssckbi.h
#Source10:       https://src.fedoraproject.org/rpms/ca-certificates/raw/master/f/certdata2pem.py
Source10:       certdata2pem.py
Source11:       %{name}.COPYING
Source12:       compareoldnew
BuildRequires:  ca-certificates
BuildRequires:  openssl
BuildRequires:  python3-base
# for update-ca-certificates
Requires(post): ca-certificates
Requires(postun): ca-certificates
#
# replaces this package from SLE11 times
Obsoletes:      openssl-certs < %version
BuildArch:      noarch
%if %{defined p11_kit_min}
Conflicts:      p11-kit-tools < %p11_kit_min
%endif

%description
This package contains some CA root certificates for OpenSSL extracted
from MozillaFirefox

%prep
%setup -qcT

mkdir certs
cd certs
cp %{SOURCE0} .
cd ..

install -m 644 %{SOURCE11} COPYING
ver=`sed -ne '/NSS_BUILTINS_LIBRARY_VERSION /s/.*"\(.*\)"/\1/p' < "%{SOURCE1}"`
if [ "%{version}" != "$ver" ]; then
	echo "*** Version number mismatch: spec file should be version $ver"
	false
fi

%build
export LANG=en_US.UTF-8
cd certs
python3 %{SOURCE10}
cd ..
(
  cat <<-EOF
	# This is a bundle of X.509 certificates of public Certificate
	# Authorities.  It was generated from the Mozilla root CA list.
	# These certificates and trust/distrust attributes use the file format accepted
	# by the p11-kit-trust module.
	#
	# Source: nss/lib/ckfw/builtins/certdata.txt
	# Source: nss/lib/ckfw/builtins/nssckbi.h
	#
	# Generated from:
	EOF
   awk '$2 == "NSS_BUILTINS_LIBRARY_VERSION" {print "# " $2 " " $3}' %{SOURCE1}
   echo '#';
   ls -1 certs/*.tmp-p11-kit | sort | xargs cat
) > %{name}.trust.p11-kit

%install
mkdir -p %{buildroot}/%{trustdir_static}
install -m 644 %{name}.trust.p11-kit "%{buildroot}/%{trustdir_static}/%{name}.trust.p11-kit"

%post
update-ca-certificates || true

%postun
update-ca-certificates || true

%posttrans
update-ca-certificates || true

%files
%license COPYING
%{trustdir_static}

%changelog
* Tue Apr  8 2025 meissner@suse.com
- revert the distrusted certs for now. originally these only
  distrust "new issued" certs starting after a certain date,
  while old certs should still work. (bsc#1240343)
- remove-distrusted.patch: removed
* Mon Mar 31 2025 meissner@suse.com
- explit remove distruted certs, as the distrust does not get exported
  correctly and the SSL certs are still trusted. (bsc#1240343)
  - Entrust.net Premium 2048 Secure Server CA
  - Entrust Root Certification Authority
  - AffirmTrust Commercial
  - AffirmTrust Networking
  - AffirmTrust Premium
  - AffirmTrust Premium ECC
  - Entrust Root Certification Authority - G2
  - Entrust Root Certification Authority - EC1
  - GlobalSign Root E46
  - GLOBALTRUST 2020
- remove-distrusted.patch: apply to certdata.txt
* Tue Mar 25 2025 eroca@suse.com
- Fix awk to compare (missing a =) and give the following output:
  [#] NSS_BUILTINS_LIBRARY_VERSION "2.74"
* Tue Mar 25 2025 meissner@suse.com
- pass file argument to awk (bsc#1240009)
* Tue Feb  4 2025 dmueller@suse.com
- update to 2.74 state of Mozilla SSL root CAs:
  Removed:
  * SwissSign Silver CA - G2
  Added:
  * D-TRUST BR Root CA 2 2023
  * D-TRUST EV Root CA 2 2023
* Tue Feb  4 2025 dmueller@suse.com
- remove extensive signature printing in comments of the cert
  bundle
* Thu Jan 23 2025 steven.kowalik@suse.com
- Define two macros to break a build cycle with p11-kit.
* Sun Dec 15 2024 dmueller@suse.com
- Updated to 2.72 state of Mozilla SSL root CAs (bsc#1234798)
  Removed:
  - SecureSign RootCA11
  - Security Communication RootCA3
  Added:
  - TWCA CYBER Root CA
  - TWCA Global Root CA G2
  - SecureSign Root CA12
  - SecureSign Root CA14
  - SecureSign Root CA15
* Mon Jul  8 2024 meissner@suse.com
- Updated to 2.68 state of Mozilla SSL root CAs (bsc#1227525)
  - Added: FIRMAPROFESIONAL CA ROOT-A WEB
  - Distrust: GLOBALTRUST 2020
* Mon Feb 26 2024 meissner@suse.com
- Updated to 2.66 state of Mozilla SSL root CAs (bsc#1220356)
  Added:
  - CommScope Public Trust ECC Root-01
  - CommScope Public Trust ECC Root-02
  - CommScope Public Trust RSA Root-01
  - CommScope Public Trust RSA Root-02
  - D-Trust SBR Root CA 1 2022
  - D-Trust SBR Root CA 2 2022
  - Telekom Security SMIME ECC Root 2021
  - Telekom Security SMIME RSA Root 2023
  - Telekom Security TLS ECC Root 2020
  - Telekom Security TLS RSA Root 2023
  - TrustAsia Global Root CA G3
  - TrustAsia Global Root CA G4
  Removed:
  - Autoridad de Certificacion Firmaprofesional CIF A62634068
  - Chambers of Commerce Root - 2008
  - Global Chambersign Root - 2008
  - Security Communication Root CA
  - Symantec Class 1 Public Primary Certification Authority - G6
  - Symantec Class 2 Public Primary Certification Authority - G6
  - TrustCor ECA-1
  - TrustCor RootCert CA-1
  - TrustCor RootCert CA-2
  - VeriSign Class 1 Public Primary Certification Authority - G3
  - VeriSign Class 2 Public Primary Certification Authority - G3
- remove-trustcor.patch: removed, now upstream
- do a versioned obsoletes of "openssl-certs".
* Mon Feb 26 2024 meissner@suse.com
- use rpm 4.20 compatible patch syntax
* Mon Feb 26 2024 dimstar@opensuse.org
- Use %%patch -P N instead of deprecated %%patchN.
* Wed Aug 16 2023 meissner@suse.com
- readd _multibuild
* Mon Aug 14 2023 meissner@suse.com
- Updated to 2.62 state of Mozilla SSL root CAs (bsc#1214248)
  Added:
  - Atos TrustedRoot Root CA ECC G2 2020
  - Atos TrustedRoot Root CA ECC TLS 2021
  - Atos TrustedRoot Root CA RSA G2 2020
  - Atos TrustedRoot Root CA RSA TLS 2021
  - BJCA Global Root CA1
  - BJCA Global Root CA2
  - LAWtrust Root CA2 (4096)
  - Sectigo Public Email Protection Root E46
  - Sectigo Public Email Protection Root R46
  - Sectigo Public Server Authentication Root E46
  - Sectigo Public Server Authentication Root R46
  - SSL.com Client ECC Root CA 2022
  - SSL.com Client RSA Root CA 2022
  - SSL.com TLS ECC Root CA 2022
  - SSL.com TLS RSA Root CA 2022
  Removed CAs:
  - Chambers of Commerce Root
  - E-Tugra Certification Authority
  - E-Tugra Global Root CA ECC v3
  - E-Tugra Global Root CA RSA v3
  - Hongkong Post Root CA 1
* Thu May  4 2023 dimstar@opensuse.org
- Add _multibuild to define 2nd spec file as additional flavor.
  Eliminates the need for source package links in OBS.
* Thu Dec 22 2022 meissner@suse.com
- Updated to 2.60 state of Mozilla SSL root CAs (bsc#1206622)
  Removed CAs:
  - Global Chambersign Root
  - EC-ACC
  - Network Solutions Certificate Authority
  - Staat der Nederlanden EV Root CA
  - SwissSign Platinum CA - G2
  Added CAs:
  - DIGITALSIGN GLOBAL ROOT ECDSA CA
  - DIGITALSIGN GLOBAL ROOT RSA CA
  - Security Communication ECC RootCA1
  - Security Communication RootCA3
  Changed trust:
  - TrustCor certificates only trusted up to Nov 30 (bsc#1206212)
- Removed CAs (bsc#1206212) as most code does not handle "valid before nov 30 2022"
  and it is not clear how many certs were issued for SSL middleware by TrustCor:
  - TrustCor RootCert CA-1
  - TrustCor RootCert CA-2
  - TrustCor ECA-1
  Patch: remove-trustcor.patch
* Mon Aug 29 2022 meissner@suse.com
- Updated to 2.56 state of Mozilla SSL root CAs (bsc#1202868)
  Added:
  - Certainly Root E1
  - Certainly Root R1
  - DigiCert SMIME ECC P384 Root G5
  - DigiCert SMIME RSA4096 Root G5
  - DigiCert TLS ECC P384 Root G5
  - DigiCert TLS RSA4096 Root G5
  - E-Tugra Global Root CA ECC v3
  - E-Tugra Global Root CA RSA v3
  Removed:
  - Hellenic Academic and Research Institutions RootCA 2011
* Mon May  2 2022 meissner@suse.com
- Updated to 2.54 state of Mozilla SSL root CAs (bsc#1199079)
  Added:
  - Autoridad de Certificacion Firmaprofesional CIF A62634068
  - D-TRUST BR Root CA 1 2020
  - D-TRUST EV Root CA 1 2020
  - GlobalSign ECC Root CA R4
  - GTS Root R1
  - GTS Root R2
  - GTS Root R3
  - GTS Root R4
  - HiPKI Root CA - G1
  - ISRG Root X2
  - Telia Root CA v2
  - vTrus ECC Root CA
  - vTrus Root CA
  Removed:
  - Cybertrust Global Root
  - DST Root CA X3
  - DigiNotar PKIoverheid CA Organisatie - G2
  - GlobalSign ECC Root CA R4
  - GlobalSign Root CA R2
  - GTS Root R1
  - GTS Root R2
  - GTS Root R3
  - GTS Root R4
* Sat Oct  2 2021 meissner@suse.com
- updated to 2.50 state of the Mozilla NSS Certificate store (bsc#1188006)
- Added CAs:
  + HARICA Client ECC Root CA 2021
  + HARICA Client RSA Root CA 2021
  + HARICA TLS ECC Root CA 2021
  + HARICA TLS RSA Root CA 2021
  + TunTrust Root CA
* Fri Sep 24 2021 meissner@suse.com
- remove the DST_Root_CA_X3.pem trust, as it expires september 30th 2021.
  (bsc#1190858)
* Mon Jul  5 2021 meissner@suse.com
- updated to 2.50 state of the Mozilla NSS Certificate store (bsc#1188006)
  Added CAs:
  * AC RAIZ FNMT-RCM SERVIDORES SEGUROS
  * ANF Secure Server Root CA
  * Certum EC-384 CA
  * Certum Trusted Root CA
  * GlobalSign Root E46
  * GlobalSign Root R46
  * GlobalSign Secure Mail Root E45
  * GlobalSign Secure Mail Root R45
  * GLOBALTRUST 2020
  Removed CAs:
  * GeoTrust Primary Certification Authority - G2
  * QuoVadis Root Certification Authority
  * Sonera Class2 CA
  * Trustis FPS Root CA
  * VeriSign Universal Root Certification Authority
* Sun Jul  4 2021 dmueller@suse.com
- fix mozila typo in installed files
* Tue Feb  9 2021 meissner@suse.com
- Updated to 2.46 state of the Mozilla NSS Certificate store (bsc#1181994)
- Added new root CAs:
  - NAVER Global Root Certification Authority
- Removed old root CA:
  - GeoTrust Global CA
  - GeoTrust Primary Certification Authority
  - GeoTrust Primary Certification Authority - G3
  - GeoTrust Universal CA
  - GeoTrust Universal CA 2
  - thawte Primary Root CA
  - thawte Primary Root CA - G2
  - thawte Primary Root CA - G3
  - VeriSign Class 3 Public Primary Certification Authority - G4
  - VeriSign Class 3 Public Primary Certification Authority - G5
* Mon Oct 19 2020 meissner@suse.com
- Updated to 2.44 state of the Mozilla NSS Certificate store (bsc#1177864)
- Removed CAs:
  - EE Certification Centre Root CA
  - Taiwan GRCA
- Added CAs:
  - Trustwave Global Certification Authority
  - Trustwave Global ECC P256 Certification Authority
  - Trustwave Global ECC P384 Certification Authority
* Wed Jul 29 2020 meissner@suse.com
- update to 2.42 state of the Mozilla NSS Certificate store (bsc#1174673)
  Removed CAs:
  - AddTrust External CA Root
  - AddTrust Class 1 CA Root
  - LuxTrust Global Root 2
  - Staat der Nederlanden Root CA - G2
  - Symantec Class 1 Public Primary Certification Authority - G4
  - Symantec Class 2 Public Primary Certification Authority - G4
  - VeriSign Class 3 Public Primary Certification Authority - G3
  Added CAs:
  - certSIGN Root CA G2
  - e-Szigno Root CA 2017
  - Microsoft ECC Root Certificate Authority 2017
  - Microsoft RSA Root Certificate Authority 2017
* Thu Mar 26 2020 meissner@suse.com
- also run update-ca-certificates in %%posttrans
* Tue Jan 14 2020 meissner@suse.com
- update to 2.40 state of the Mozilla NSS Certificate store (bsc#1160160)
- removed:
  - Certplus Class 2 Primary CA
  - Deutsche Telekom Root CA 2
  - CN=Swisscom Root CA 2
  - UTN-USERFirst-Client Authentication and Email
- added:
  - Entrust Root Certification Authority - G4
* Wed Dec 18 2019 lnussel@suse.de
- make sure p11-kit with patches is installed on SLE (boo#1154871)
* Tue Nov 12 2019 lnussel@suse.de
- export correct p11kit trust attributes so Firefox detects built in
  certificates (boo#1154871). Courtesy of Fedora.
* Sun Aug  4 2019 andreas.stieger@gmx.de
- update to 2.34 state of the Mozilla NSS Certificate store (bsc#1144169)
- Removed CAs:
  - Certinomis - Root CA
- includes added root CAs from the 2.32 version:
  - emSign ECC Root CA - C3 (email and server auth)
  - emSign ECC Root CA - G3 (email and server auth)
  - emSign Root CA - C1 (email and server auth)
  - emSign Root CA - G1 (email and server auth)
  - Hongkong Post Root CA 3 (server auth)
* Thu Jan 17 2019 meissner@suse.com
- updated to 2.30 state of the Mozilla NSS Certificate store. (bsc#1121446)
- Removed CAs:
  - AC Raiz Certicamara S.A.
  - Certplus Root CA G1
  - Certplus Root CA G2
  - OpenTrust Root CA G1
  - OpenTrust Root CA G2
  - OpenTrust Root CA G3
  - Visa eCommerce Root
- Added Root CAs:
  - Certigna Root CA (email and server auth)
  - GTS Root R1 (server auth)
  - GTS Root R2 (server auth)
  - GTS Root R3 (server auth)
  - GTS Root R4 (server auth)
  - OISTE WISeKey Global Root GC CA (email and server auth)
  - UCA Extended Validation Root (server auth)
  - UCA Global G2 Root (email and server auth)
* Thu Aug 16 2018 meissner@suse.com
- updated to 2.26 state of the Mozilla NSS Certificate store. (bsc#1104780)
  - removed server auth
  - Certplus Root CA G1
  - Certplus Root CA G2
  - OpenTrust Root CA G1
  - OpenTrust Root CA G2
  - OpenTrust Root CA G3
  - remove CA
  - ComSign CA
  - added new CA
  - GlobalSign
* Fri Jul  6 2018 meissner@suse.com
- Updated to 2.24 state of the Mozilla NSS Certificate store. (bsc#1100415)
- Removed CAs:
  * S-TRUST_Universal_Root_CA:2.16.96.86.197.75.35.64.91.100.212.237.37.218.217.214.30.30.crt
  * TC_TrustCenter_Class_3_CA_II:2.14.74.71.0.1.0.2.229.160.93.214.63.0.81.191.crt
  * TÜRKTRUST_Elektronik_Sertifika_Hizmet_Sağlayıcısı_H5:2.7.0.142.23.254.36.32.129.crt
* Tue Mar 20 2018 kukuk@suse.de
-  Use %%license instead of %%doc [bsc#1082318]
* Thu Jan 25 2018 meissner@suse.com
- Updated to 2.22 state of the Mozilla NSS Certificate store (bsc#1071152,
  bsc#1071390, bsc#1010996)
- Removed CAs:
  * ACEDICOM Root
  * AddTrust Public CA Root
  * AddTrust Qualified CA Root
  * ApplicationCA - Japanese Government
  * CA Disig Root R1
  * CA WoSign ECC Root
  * Certification Authority of WoSign G2
  * Certinomis - Autorité Racine
  * China Internet Network Information Center EV Certificates Root
  * CNNIC ROOT
  * Comodo Secure Certificate Services
  * Comodo Trusted Certificate Services
  * ComSign Secured CA
  * DST ACES CA X6
  * GeoTrust Global CA 2
  * StartCom Certification Authority
  * StartCom Certification Authority
  * StartCom Certification Authority G2
  * Swisscom Root CA 1
  * TÜBİTAK UEKAE Kök Sertifika Hizmet Sağlayıcısı - Sürüm 3
  * TÜRKTRUST Elektronik Sertifika Hizmet Sağlayıcısı
  * TÜRKTRUST Elektronik Sertifika Hizmet Sağlayıcısı H6
  * UTN USERFirst Hardware Root CA
  * UTN USERFirst Object Root CA
  * VeriSign Class 3 Secure Server CA - G2
  * WellsSecure Public Root Certificate Authority
  * Certification Authority of WoSign
  * WoSign China
- Added CAs:
  * D-TRUST Root CA 3 2013
  * GDCA TrustAUTH R5 ROOT
  * SSL.com EV Root Certification Authority ECC
  * SSL.com EV Root Certification Authority RSA R2
  * SSL.com Root Certification Authority ECC
  * SSL.com Root Certification Authority RSA
  * TrustCor RootCert CA-1
  * TrustCor RootCert CA-2
  * TUBITAK Kamu SM SSL Kok Sertifikasi - Surum 1
* Wed Oct 25 2017 jmatejek@suse.com
- convert processing script to Python 3
- ensure a stable conversion of UTF8 hex-encoded certificate names
- ensure a stable ordering of trust/distrust bits in headers
* Tue Jan 24 2017 meissner@suse.com
- updated to 2.11 state of the Mozilla NSS Certificate store.
- removed CAs:
  - Buypass_Class_2_CA_1:2.1.1.crt
    serverAuth
  - EBG_Elektronik_Sertifika_Hizmet_Sağlayıcısı:2.8.76.175.115.66.28.142.116.2.crt
    codeSigning emailProtection serverAuth
  - Equifax_Secure_CA:2.4.53.222.244.207.crt
    emailProtection
  - Equifax_Secure_eBusiness_CA_1:2.1.4.crt
    emailProtection
  - Equifax_Secure_Global_eBusiness_CA:2.1.1.crt
    emailProtection
  - IGC_A:2.5.57.17.69.16.148.crt
    codeSigning emailProtection serverAuth
  - Juur-SK:2.4.59.142.75.252.crt
    codeSigning serverAuth
  - Root_CA_Generalitat_Valenciana:2.4.59.69.229.104.crt
    codeSigning emailProtection serverAuth
  - RSA_Security_2048_v3:2.16.10.1.1.1.0.0.2.124.0.0.0.10.0.0.0.2.crt
    codeSigning emailProtection serverAuth
  - Sonera_Class_1_Root_CA:2.1.36.crt
    emailProtection
  - S-TRUST_Authentication_and_Encryption_Root_CA_2005_PN:2.16.55.25.24.230.83.84.124.26.181.184.203.89.90.219.53.183.crt
    emailProtection
  - Verisign_Class_1_Public_Primary_Certification_Authority:2.16.63.105.30.129.156.240.154.74.243.115.255.185.72.162.228.221.crt
    emailProtection
  - Verisign_Class_2_Public_Primary_Certification_Authority_-_G2:2.17.0.185.47.96.204.136.159.161.122.70.9.184.91.112.108.138.175.crt
    emailProtection
  - Verisign_Class_3_Public_Primary_Certification_Authority:2.16.112.186.228.29.16.217.41.52.182.56.202.123.3.204.186.191.crt
    emailProtection
- added CAs:
  + AC_RAIZ_FNMT-RCM:2.15.93.147.141.48.103.54.200.6.29.26.199.84.132.105.7.crt
    serverAuth
  + Amazon_Root_CA_1:2.19.6.108.159.207.153.191.140.10.57.226.240.120.138.67.230.150.54.91.202.crt
    emailProtection serverAuth
  + Amazon_Root_CA_2:2.19.6.108.159.210.150.53.134.159.10.15.229.134.120.248.91.38.187.138.55.crt
    emailProtection serverAuth
  + Amazon_Root_CA_3:2.19.6.108.159.213.116.151.54.102.63.59.11.154.217.232.158.118.3.242.74.crt
    emailProtection serverAuth
  + Amazon_Root_CA_4:2.19.6.108.159.215.193.187.16.76.41.67.229.113.123.123.44.200.26.193.14.crt
    emailProtection serverAuth
  + Certplus_Root_CA_G1:2.18.17.32.85.131.228.45.62.84.86.133.45.131.55.183.44.220.70.17.crt
    emailProtection serverAuth
  + Certplus_Root_CA_G2:2.18.17.32.217.145.206.174.163.232.197.231.255.233.2.175.207.115.188.85.crt
    emailProtection serverAuth
  + Hellenic_Academic_and_Research_Institutions_ECC_RootCA_2015:2.1.0.crt
    emailProtection serverAuth
  + Hellenic_Academic_and_Research_Institutions_RootCA_2015:2.1.0.crt
    emailProtection serverAuth
  + ISRG_Root_X1:2.17.0.130.16.207.176.210.64.227.89.68.99.224.187.99.130.139.0.crt (bsc#1010996)
    serverAuth
  + LuxTrust_Global_Root_2:2.20.10.126.166.223.75.68.158.218.106.36.133.158.230.184.21.211.22.127.187.177.crt
    serverAuth
  + OpenTrust_Root_CA_G1:2.18.17.32.179.144.85.57.125.127.54.109.100.194.167.159.107.99.142.103.crt
    emailProtection serverAuth
  + OpenTrust_Root_CA_G2:2.18.17.32.161.105.27.191.189.185.189.82.150.143.35.232.72.191.38.17.crt
    emailProtection serverAuth
  + OpenTrust_Root_CA_G3:2.18.17.32.230.248.76.252.36.176.190.5.64.172.218.131.27.52.96.63.crt
    emailProtection serverAuth
  + Symantec_Class_1_Public_Primary_Certification_Authority_-_G4:2.16.33.110.51.165.203.211.136.164.111.41.7.180.39.60.196.216.crt
    emailProtection
  + Symantec_Class_1_Public_Primary_Certification_Authority_-_G6:2.16.36.50.117.242.29.47.210.9.51.247.180.106.202.208.243.152.crt
    emailProtection
  + Symantec_Class_2_Public_Primary_Certification_Authority_-_G4:2.16.52.23.101.18.64.59.183.86.128.45.128.203.121.85.166.30.crt
    emailProtection
  + Symantec_Class_2_Public_Primary_Certification_Authority_-_G6:2.16.100.130.158.252.55.30.116.93.252.151.255.151.200.177.255.65.crt
    emailProtection
- diff-from-upstream-2.7.patch: removed as we should be able to do
  intermediate root chains now with openssl 1.0.2 and also gnutls 3.5
  is able to do so.
* Wed Apr  6 2016 meissner@suse.com
- diff-from-upstream-2.7.patch: restore some important legacy
  CAs, otherwise Pidgin fails to talk to Google Talk for instance.
* Thu Mar 31 2016 meissner@suse.com
- Updated to 2.7 (bsc#973042).
- diff-from-upstream-2.2.patch: removed as openssl 1.0.2 can do
  immediate root CAs.
- Removed server trust from:
  AC Raíz Certicámara S.A.
  ComSign Secured CA
  NetLock Uzleti (Class B) Tanusitvanykiado
  NetLock Business (Class B) Root
  NetLock Expressz (Class C) Tanusitvanykiado
  TC TrustCenter Class 3 CA II
  TURKTRUST Certificate Services Provider Root 1
  TURKTRUST Certificate Services Provider Root 2
  Equifax Secure Global eBusiness CA-1
  Verisign Class 4 Public Primary Certification Authority G3
- enable server trust
  Actalis Authentication Root CA
- Deleted CAs:
  A Trust nQual 03
  Buypass Class 3 CA 1
  CA Disig
  Digital Signature Trust Co Global CA 1
  Digital Signature Trust Co Global CA 3
  E Guven Kok Elektronik Sertifika Hizmet Saglayicisi
  NetLock Expressz (Class C) Tanusitvanykiado
  NetLock Kozjegyzoi (Class A) Tanusitvanykiado
  NetLock Minositett Kozjegyzoi (Class QA) Tanusitvanykiado
  NetLock Uzleti (Class B) Tanusitvanykiado
  SG TRUST SERVICES RACINE
  Staat der Nederlanden Root CA
  TC TrustCenter Class 2 CA II
  TC TrustCenter Universal CA I
  TDC Internet Root CA
  UTN DATACorp SGC Root CA
  Verisign Class 1 Public Primary Certification Authority - G2
  Verisign Class 3 Public Primary Certification Authority
  Verisign Class 3 Public Primary Certification Authority - G2
- New added CAs:
  CA WoSign ECC Root
  Certification Authority of WoSign
  Certification Authority of WoSign G2
  Certinomis - Root CA
  Certum Trusted Network CA 2
  CFCA EV ROOT
  COMODO RSA Certification Authority
  DigiCert Assured ID Root G2
  DigiCert Assured ID Root G3
  DigiCert Global Root G2
  DigiCert Global Root G3
  DigiCert Trusted Root G4
  Entrust Root Certification Authority - EC1
  Entrust Root Certification Authority - G2
  GlobalSign
  GlobalSign
  IdenTrust Commercial Root CA 1
  IdenTrust Public Sector Root CA 1
  OISTE WISeKey Global Root GB CA
  QuoVadis Root CA 1 G3
  QuoVadis Root CA 2 G3
  QuoVadis Root CA 3 G3
  Staat der Nederlanden EV Root CA
  Staat der Nederlanden Root CA - G3
  S-TRUST Universal Root CA
  SZAFIR ROOT CA2
  TÜRKTRUST Elektronik Sertifika Hizmet Sağlayıcısı H5
  TÜRKTRUST Elektronik Sertifika Hizmet Sağlayıcısı H6
  USERTrust ECC Certification Authority
  USERTrust RSA Certification Authority
  沃通根证书
* Wed Jan 14 2015 meissner@suse.com
- diff-from-upstream-2.2.patch:
  Temporary reenable some root ca trusts, as openssl/gnutls
  have trouble using intermediates as root CA.
  - GTE CyberTrust Global Root
  - Thawte Server CA
  - Thawte Premium Server CA
  - ValiCert Class 1 VA
  - ValiCert Class 2 VA
  - RSA Root Certificate 1
  - Entrust.net Secure Server CA
  - America Online Root Certification Authority 1
  - America Online Root Certification Authority 2
* Mon Jan 12 2015 meissner@suse.com
- Updated to 2.2 (bnc#888534)
  - The following CAs were removed:
    + America_Online_Root_Certification_Authority_1
    + America_Online_Root_Certification_Authority_2
    + GTE_CyberTrust_Global_Root
    + Thawte_Premium_Server_CA
    + Thawte_Server_CA
  - The following CAs were added:
    + COMODO_RSA_Certification_Authority
    codeSigning emailProtection serverAuth
    + GlobalSign_ECC_Root_CA_-_R4
    codeSigning emailProtection serverAuth
    + GlobalSign_ECC_Root_CA_-_R5
    codeSigning emailProtection serverAuth
    + USERTrust_ECC_Certification_Authority
    codeSigning emailProtection serverAuth
    + USERTrust_RSA_Certification_Authority
    codeSigning emailProtection serverAuth
    + VeriSign-C3SSA-G2-temporary-intermediate-after-1024bit-removal
  - The following CAs were changed:
    + Equifax_Secure_eBusiness_CA_1
    remote code signing and https trust, leave email trust
    + Verisign_Class_3_Public_Primary_Certification_Authority_-_G2
    only trust emailProtection
* Tue Aug 26 2014 meissner@suse.com
- Updated to 2.1 (bnc#888534)
- The following 1024-bit CA certificates were removed
  - Entrust.net Secure Server Certification Authority
  - ValiCert Class 1 Policy Validation Authority
  - ValiCert Class 2 Policy Validation Authority
  - ValiCert Class 3 Policy Validation Authority
  - TDC Internet Root CA
- The following CA certificates were added:
  - Certification Authority of WoSign
  - CA 沃通根证书
  - DigiCert Assured ID Root G2
  - DigiCert Assured ID Root G3
  - DigiCert Global Root G2
  - DigiCert Global Root G3
  - DigiCert Trusted Root G4
  - QuoVadis Root CA 1 G3
  - QuoVadis Root CA 2 G3
  - QuoVadis Root CA 3 G3
- The Trust Bits were changed for the following CA certificates
  - Class 3 Public Primary Certification Authority
  - Class 3 Public Primary Certification Authority
  - Class 2 Public Primary Certification Authority - G2
  - VeriSign Class 2 Public Primary Certification Authority - G3
  - AC Raíz Certicámara S.A.
  - NetLock Uzleti (Class B) Tanusitvanykiado
  - NetLock Expressz (Class C) Tanusitvanykiado
- certdata-temporary-1024.patch: restore some certificates removed
  from NSS as these are still used for some major sites.
  openssl is not as clever as NSS in selecting the new ones in the
  chain correctly.
* Wed Jun 18 2014 meissner@suse.com
- do not provide openssl-certs, just obsolete it.
* Tue Jun 10 2014 meissner@suse.com
- in sle11 we bumped openssl-certs version to match the NSS version,
  so provide/obsolete the current version.
* Wed Jun  4 2014 lnussel@suse.de
- updated certificates to revision 1.97 (bnc#881241)
  new: "Atos TrustedRoot 2011" (codeSigning emailProtection serverAuth)
  new: "Tugra Certification Authority" (codeSigning serverAuth)
  removed: "Firmaprofesional Root CA"
  removed: "TDC OCES Root CA"
  new: "TeliaSonera Root CA v1" (emailProtection serverAuth)
  new: "T-TeleSec GlobalRoot Class 2" (emailProtection serverAuth)
* Fri Feb 21 2014 meissner@suse.com
- updated certificates to revision 1.96 (bnc#865080)
  new:     ACCVRAIZ1.pem   (Spain) (all trusts)
  new:     SG_TRUST_SERVICES_RACINE.pem (Singapore) (email signing only)
  new:     TWCA_Global_Root_CA.pem (Taiwanese) (all trusts)
  removed: Wells_Fargo_Root_CA.pem
* Mon Dec  9 2013 meissner@suse.com
- Updated to 1.95
  Distrust a sub-ca that issued google.com certificates.
  "Distrusted AC DG Tresor SSL" (bnc#854367)
* Mon Dec  9 2013 lnussel@suse.de
- fix handling of certificates with same name (bnc#854163)
* Tue Oct 29 2013 meissner@suse.com
- Updated to 1.94
  * new: CA_Disig_Root_R1:2.9.0.195.3.154.238.80.144.110.40.crt
    server auth, code signing, email signing
  * new: CA_Disig_Root_R2:2.9.0.146.184.136.219.176.138.193.99.crt
    server auth, code signing, email signing
  * new: China_Internet_Network_Information_Center_EV_Certificates_Root:2.4.72.159.0.1.crt
    server auth
  * changed: Digital_Signature_Trust_Co._Global_CA_1:2.4.54.112.21.150.crt
    removed code signing and server auth abilities
  * changed: Digital_Signature_Trust_Co._Global_CA_3:2.4.54.110.211.206.crt
    removed code signing and server auth abilities
  * new: D-TRUST_Root_Class_3_CA_2_2009:2.3.9.131.243.crt
    server auth
  * new: D-TRUST_Root_Class_3_CA_2_EV_2009:2.3.9.131.244.crt
    server auth
  * removed: Entrust.net_Premium_2048_Secure_Server_CA:2.4.56.99.185.102.crt
  * new:     Entrust.net_Premium_2048_Secure_Server_CA:2.4.56.99.222.248.crt
    I think the missing flags were adjusted.
  * removed: Equifax_Secure_eBusiness_CA_2:2.4.55.112.207.181.crt
  * new: PSCProcert:2.1.11.crt
    server auth, code signing, email signing
  * new: Swisscom_Root_CA_2:2.16.30.158.40.232.72.242.229.239.195.124.74.30.90.24.103.182.crt
    server auth, code signing, email signing
  * new: Swisscom_Root_EV_CA_2:2.17.0.242.250.100.226.116.99.211.141.253.16.29.4.31.118.202.88.crt
    server auth, code signing
  * changed: TC_TrustCenter_Universal_CA_III:2.14.99.37.0.1.0.2.20.141.51.21.2.228.108.244.crt
    removed all abilities
  * new: TURKTRUST_Certificate_Services_Provider_Root_2007:2.1.1.crt
    server auth, code signing
  * changed: TWCA_Root_Certification_Authority:2.1.1.crt
    added code signing ability
- removed temporary Entrust.net_Premium_2048_Secure_Server_CA.p11-kit override.
* Mon Aug 19 2013 lnussel@suse.de
- update Entrust root attributes to new format used by p11-kit
* Wed Jul 24 2013 lnussel@suse.de
- remove superfluous double quotes from certificate names
* Wed Jul 24 2013 lnussel@suse.de
- add fake basic contraints to Entrust root so p11-kit export the cert
  (bnc#829471)
- add nssckbi.h that matches certdata.txt; make sure package has the
  correct version number which is currently 1.93. No actual content
  change in certdata.txt compared to 1.85, it's just that the
  versioning scheme changed.
* Thu Jun 27 2013 lnussel@suse.de
- use certdata2pem.py from Fedora to extract all certs
* Fri Jun 21 2013 lnussel@suse.de
- use correct 'anchors' subdirectory
* Wed Jun 19 2013 lnussel@suse.de
- new location of CA certificate anchors is
  /usr/share/ca-certificates/anchors
* Thu Jan  3 2013 idonmez@suse.com
- update certificates to revision 1.87 (bnc#796628)
  * new "EE Certification Centre Root CA"
  * new "T-TeleSec GlobalRoot Class 3"
  * revoke mis-issued intermediate CAs from TURKTRUST
* Wed Oct 10 2012 meissner@suse.com
- updated certificates to revision 1.85 (bnc#783509)
  * new "Actalis Authentication Root CA"
  * new "Trustis FPS Root CA"
  * new "StartCom Certification Authority"
  * new "StartCom Certification Authority G2"
  * new "Buypass Class 2 Root CA"
  * new "Buypass Class 3 Root CA"
  * updated: "Sonera Class2 CA": remove code-signing
  * updated: "thawte Primary Root CA": added code-signing
  * updated: "Trustis_FPS_Root_CA.pem": added code-signing
  * updated: VeriSign Class 3 Public Primary Certification Authority - G5":
    added code-signing, email-protection
* Thu May  3 2012 lnussel@suse.de
- update certificates to revision 1.83 (bnc#760503)
  * new: EC_ACC.pem
  * new: Hellenic_Academic_and_Research_Institutions_RootCA_2011.pem
  * new: Security_Communication_RootCA2.pem
  * removed: TC_TrustCenter_Germany_Class_2_CA.pem
  * removed: TC_TrustCenter_Germany_Class_3_CA.pem
  * removed: Verisign_Class_1_Public_Primary_Certification_Authority.1.pem
  * removed: Verisign_Class_2_Public_Primary_Certification_Authority.pem
  * removed: Verisign_Class_4_Public_Primary_Certification_Authority_G2.pem
- license change to MPL-2.0
* Fri Jan 13 2012 cfarrell@suse.com
- license update: MPL-1.1 or GPL-2.0+ or LGPL-2.1+
  SPDX format and correct GPL and LGPL tags to include or later
* Thu Jan 12 2012 coolo@suse.com
- change license to be in spdx.org format
* Sat Sep 17 2011 jengelh@medozas.de
- Remove redundant tags/sections from specfile
* Wed Aug 31 2011 lnussel@suse.de
- update certificates to revision 1.76
  * new: Go_Daddy_Root_Certificate_Authority_G2.pem
  * new: Starfield_Root_Certificate_Authority_G2.pem
  * new: Starfield_Services_Root_Certificate_Authority_G2.pem
  * new: AffirmTrust_Commercial.pem
  * new: AffirmTrust_Networking.pem
  * new: AffirmTrust_Premium.pem
  * new: AffirmTrust_Premium_ECC.pem
  * new: Certum_Trusted_Network_CA.pem
  * new: Certinomis_Autorit_Racine.pem
  * new: Root_CA_Generalitat_Valenciana.pem
  * new: A_Trust_nQual_03.pem
  * new: TWCA_Root_Certification_Authority.pem
  * removed: DigiNotar_Root_CA.pem (bnc#714931)
* Mon Jan 31 2011 lnussel@suse.de
- update certificates to revision 1.70
  * new: AddTrust_Qualified_Certificates_Root.pem
  * new: Autoridad_de_Certificacion_Firmaprofesional_CIF_A62634068.pem
  * new: Chambers_of_Commerce_Root_2008.pem
  * new: Global_Chambersign_Root_2008.pem
  * new: Izenpe_com.pem
  * new: TC_TrustCenter_Universal_CA_III.pem
* Mon Sep 27 2010 lnussel@suse.de
- update certificates to revision 1.65
  * new: E_Guven_Kok_Elektronik_Sertifika_Hizmet_Saglayicisi.pem
  * new: GlobalSign_Root_CA_R3.pem
  * new: Microsec_e_Szigno_Root_CA_2009.pem
  * new: Verisign_Class_1_Public_Primary_Certification_Authority.1.pem
  * new: Verisign_Class_3_Public_Primary_Certification_Authority.1.pem
* Fri May 21 2010 lnussel@suse.de
- update certificates to revision 1.64
  * removed "RSA Security 1024 V3" certificate
* Thu Apr  8 2010 lnussel@suse.de
- require ca-certificates also for postun
* Thu Apr  1 2010 lnussel@suse.de
- don't output trusted certs by default as it's not supported by
  gnutls yet and pidgin scans /etc/ssl/certs
* Thu Apr  1 2010 lnussel@suse.de
- update certificates to revision 1.62
* Fri Mar 26 2010 lnussel@suse.de
- extract trustbits as comment as Fedora does
- convert to trusted certificates in spec file instead
* Thu Mar 25 2010 lnussel@suse.de
- rename to ca-certificates-mozilla
- output trusted certificates
- use utf8 in file names
* Tue Feb  2 2010 lnussel@suse.de
- update certificates to revision 1.57
- add script to compare with previous certificates
* Wed Sep 30 2009 lnussel@suse.de
- update certifiates to cvs revision 1.56
- exclude certficates that are not trusted for identifying web sites
* Tue Dec  2 2008 cfarrell@suse.de
- Add openssl-certs.COPYING to fix bnc#441356
* Thu Oct  9 2008 lnussel@suse.de
- use certificates from MozillaFirefox
* Wed Jul  9 2008 mkoenig@suse.de
- split out the CA root certificates from the openssl certs
  subpackage into a package of its own.
