#
# spec file for package javapackages-tools
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%{!?_rpmmacrodir:%global _rpmmacrodir %{_rpmconfigdir}/macros.d}
%global flavor %{nil}
%if "%{flavor}" == "extras"
%bcond_without python
%else
%bcond_with python
%endif
%if %{with python}
%{?!python_module:%define python_module() python3-%{**}}
%define skip_python2 1
Name:           javapackages-tools-%{flavor}
%else
Name:           javapackages-tools
%endif
Version:        6.3.4
Release:        150200.3.15.1
Summary:        Macros and scripts for Java packaging support
License:        BSD-3-Clause
Group:          Development/Languages/Java
URL:            https://github.com/fedora-java/javapackages
Source0:        https://github.com/fedora-java/javapackages/archive/%{version}.tar.gz
#PATCH-FIX-SUSE: SUSE does store jvm related things in libdir - ie /usr/lib64 on 64bits
#                where Fedora use jpackage convention - usr/lib everywhere
Patch0:         suse-use-libdir.patch
#PATCH-FIX-SUSE: allow building without python to reduce depgraph
Patch1:         python-optional.patch
#PATCH-FIX-SUSE: SUSE did not bump epoch of openjdk packages, whereas Fedora did
#               Avoid generating unresolvable requires
Patch2:         suse-no-epoch.patch
#PATCH-FIX-UPSTREAM: removing the backslashes breaks checks with rpm 4.14.1
Patch3:         0001-Revert-jpackage_script-Remove-unneeded-backslashes.patch

BuildRequires:  fdupes
BuildRequires:  perl
BuildRequires:  rpm
BuildRequires:  xmlto
BuildRequires:  rubygem(asciidoctor)
%if %{with python}
BuildRequires:  javapackages-filesystem
%else
Requires:       javapackages-filesystem = %{version}-%{release}
%endif
# Used on too many places
Provides:       jpackage-utils = %{version}
Obsoletes:      %{name}-doc
Obsoletes:      jpackage-utils < %{version}
%if %{with python}
BuildRequires:  %{python_module lxml}
BuildRequires:  %{python_module pytest}
BuildRequires:  %{python_module setuptools}
BuildRequires:  python-rpm-macros
BuildArch:      noarch
%if 0%{?suse_version} >= 1550
# TW: generate subpackages for every python3 flavor
%define python_subpackage_only 1
%python_subpackages
%else
%define python_sitelib %python3_sitelib
%define python_files() -n python3-%{**}
%endif
%endif

%description
This package provides macros and scripts to support Java packaging.

%package -n javapackages-filesystem
Summary:        Java packages filesystem layout
Group:          Development/Languages/Java

%description -n javapackages-filesystem
This package provides some basic directories into which Java packages
install their content.

%if %{with python}
%package -n javapackages-gradle
Summary:        Local mode for Gradle (files)
Group:          Development/Languages/Java
Requires:       javapackages-local = %{version}
Requires:       javapackages-tools = %{version}

%description -n javapackages-gradle
This package contains files needed by local mode for Gradle, which
allows artifact resolution using XMvn resolver.

%package -n javapackages-ivy
Summary:        Local mode for Apache Ivy (files)
Group:          Development/Languages/Java
Requires:       javapackages-local = %{version}
Requires:       javapackages-tools = %{version}

%description -n javapackages-ivy
This package contains files needed by local mode fow Apache Ivy, which
allows artifact resolution using XMvn resolver.

%if 0%{?python_subpackage_only}
%package -n python-javapackages
Summary:        Module for handling various files for Java packaging
Group:          Development/Languages/Java
Requires:       python-lxml
Requires:       python-xml

%description -n python-javapackages
Module for handling, querying and manipulating of various files for Java
packaging in Linux distributions

%else

%package -n python3-javapackages
Summary:        Module for handling various files for Java packaging
Group:          Development/Languages/Java
Requires:       python3-lxml
Requires:       python3-xml
Obsoletes:      python-javapackages < %{version}-%{release}
Provides:       python-javapackages = %{version}-%{release}

%description -n python3-javapackages
Module for handling, querying and manipulating of various files for Java
packaging in Linux distributions
%endif

%package -n javapackages-local
Summary:        Non-essential macros and scripts for Java packaging support
Group:          Development/Languages/Java
Requires:       java-devel
Requires:       javapackages-tools = %{version}
Requires:       python3-javapackages = %{version}

%description -n javapackages-local
This package provides non-essential macros and scripts to support Java packaging.
%endif

%prep
%setup -q -n javapackages-%{version}
%autopatch -p1

# The usr/lib is hardcoded in configuration files too
new_dir=$(echo %{_libdir} | sed 's#/##')
perl -pi -e "s#usr/lib#${new_dir}#g" configs/*.xml

%build
%configure \
%if %{with python}
    --pyinterpreter=%{_bindir}/python3
%else
    --pyinterpreter=%{nil}
%endif
./build
%if %{with python}
pushd python
%python_build
popd
%endif

%install
./install
sed -e 's/.[17]$/&.gz/' -e 's/.py$/&*/' -i files-*

%if %{with python}
pushd python
%python_install
popd
# kill all the common files
files="
%{_bindir}/build-classpath
%{_bindir}/build-classpath-directory
%{_bindir}/build-jar-repository
%{_bindir}/check-binary-files
%{_bindir}/clean-binary-files
%{_bindir}/create-jar-links
%{_bindir}/diff-jars
%{_bindir}/find-jar
%{_bindir}/rebuild-jar-repository
%{_bindir}/shade-jar
%{_sysconfdir}/java/font.properties
%{_sysconfdir}/java/java.conf
%{_sysconfdir}/java/eclipse.conf
%{_datadir}/java-utils/java-functions
%{_datadir}/java-utils/java-wrapper
%{_datadir}/java-utils/scl-enable
%{_rpmmacrodir}/macros.jpackage
%{_rpmmacrodir}/macros.javapackages-filesystem
%{_mandir}/man1/build-classpath.1
%{_mandir}/man1/build-jar-repository.1
%{_mandir}/man1/diff-jars.1
%{_mandir}/man1/rebuild-jar-repository.1
%{_mandir}/man1/shade-jar.1
%{_mandir}/man1/find-jar.1
%{_datadir}/maven-metadata/javapackages-metadata.xml
%{_datadir}/xmvn/configuration.xml
"
for i in $files; do
    rm -rf %{buildroot}/$i
done
%endif

rm -rf %{buildroot}%{_datadir}/fedora-review/

%fdupes %{buildroot}/%{_prefix}

%check
# reference: ./check, but we don't want to check coverage and don't need old nose
(
. ./config.status
for test in test/java-functions/*_test.sh; do
    echo "`basename $test`:"
    sh $test
done
)
%if %{with python}
pushd ./python
%pytest
popd
pushd ./test
%pytest
popd
%endif

%if !%{with python}
%files -f files-tools
%license LICENSE

%files -n javapackages-filesystem -f files-filesystem

%else

%files -n javapackages-local -f files-common -f files-compat -f files-generators
%dir %{_datadir}/java-utils

%files -n javapackages-gradle -f files-gradle
%dir %{_datadir}/gradle-local

%files -n javapackages-ivy -f files-ivy
%dir %{_sysconfdir}/ant.d

%files %{python_files javapackages}
%license LICENSE
%{python_sitelib}/javapackages*
%endif

%changelog
* Fri Oct 11 2024 fstrba@suse.com
- Upgrade to upstream version 6.3.4
  * Changes:
    + A corner case when which is not present
    + Remove dependency on which
    + Simplify after the which -> type -p change
    + jpackage_script: Remove pointless assignment when %%java_home
    is unset
    + Don't require %%java_home for %%java etc.
    + Don't export JAVA_HOME
- Removed patches:
  * do-not-require-which.patch
  * fix-broken-commands.patch
  * remove-pointless-assignment.patch
    + integrated upstream
- Modified patch:
  * python-optional.patch
    + account for changed context
- Added patch:
  * 0001-Revert-jpackage_script-Remove-unneeded-backslashes.patch
    + This change breaks build with rpm 4.14.1
* Wed Oct  9 2024 schwab@suse.de
- remove-pointless-assignment.patch: Remove pointless assignment if
  %%java_home is unset
* Tue Oct  8 2024 fstrba@suse.com
- Added patch:
  * fix-broken-commands.patch
    + fix commands broken after recent removal of the default
    %%%%{java_home} macro
* Mon Oct  7 2024 fstrba@suse.com
- Added patch:
  * do-not-require-which.patch
    + do not fail launching scripts if which is not installed
    (bsc#1231347)
* Fri Oct  4 2024 fstrba@suse.com
- Upgrade to upstream version 6.3.2
  * Changes
    + spec: Update Obsoletes versions
    + Search for JAVACMD under JAVA_HOME only if it's set
    + Obsolete set_jvm and set_jvm_dirs functions
    + Drop unneeded _set_java_home function
    + Remove JAVA_HOME check from check_java_env function
    + Bump codecov/codecov-action from 2.0.2 to 4.6.0
    + Bump actions/setup-python from 4 to 5
    + Bump actions/checkout from 2 to 4
    + Add custom dependabot config
    + Remove the test for JAVA_HOME and error if it is not set
    + java-functions: Remove unneeded local variables
    + Fix build status shield
- Removed patch:
  * 0001-Double-quote-to-avoid-substitution-during-build.patch
    + Fixed differently in this version
* Wed Oct  2 2024 fstrba@suse.com
- Upgrade to upstream version 6.3.1
  * Changes:
    + Allow missing components with abs2rel
    + Fix tests with python 3.4
    + Sync spec file from Fedora
    + Drop default JRE/JDK
    + Fix the use of java-functions in scripts
    + Update RPM spec file
    + Reproducible builds: constant timestamp for pom.properties
    + Test that we don't bomb on <relativePath/>
    + Test variable expansion in artifactId
    + Interpolate properties also in the current artifact
    + Rewrite abs2rel in shell
    + Use asciidoctor instead of asciidoc
    + Fix incompatibility with RPM 4.20
    + Don't define %%topdir macro
    + coverage: use usercustomize
    + Reproducible builds: keep order of aliases and dependencies
    + Reproducible exclusions order in maven metadata
    + Do not bomb on <relativePath/> construct
    + Make maven_depmap order of aliases reproducible
- Removed patches:
  * 0001-Make-maven_depmap-order-of-aliases-reproducible.patch
  * 0002-Do-not-bomb-on-relativePath-construct.patch
  * 0003-Reproducible-exclusions-order-in-maven-metadata.patch
  * 0004-Reproducible-builds-keep-order-of-aliases-and-depend.patch
  * 0005-Interpolate-properties-also-in-the-current-artifact.patch
  * 0006-Test-variable-expansion-in-artifactId.patch
  * 0007-Test-that-we-don-t-bomb-on-relativePath.patch
  * 0008-Reproducible-builds-constant-timestamp-for-pom.prope.patch
    + Integrated in this version
- Added patch:
  * 0001-Double-quote-to-avoid-substitution-during-build.patch
    + Double-quote a macro in macros.jpackages to avoid value
    substitution during the build
* Thu Jul 18 2024 fstrba@suse.com
- Added patch:
  * 0008-Reproducible-builds-constant-timestamp-for-pom.prope.patch
    + use reproducible timestamp when post-processing jar files and
    adding there the pom.properties file.
* Wed Oct  4 2023 fstrba@suse.com
- Added patches:
  * 0005-Interpolate-properties-also-in-the-current-artifact.patch
    + interpolate variables also in current artifactId, groupId and
    version
  * 0006-Test-variable-expansion-in-artifactId.patch
    + test previous changes
  * 0007-Test-that-we-don-t-bomb-on-relativePath.patch
    + test gracious handling of empty <relativePath/> in parent
    reference of a pom file
* Wed Sep 13 2023 fstrba@suse.com
- Added patch:
  * 0004-Reproducible-builds-keep-order-of-aliases-and-depend.patch
    + make the aliases and dependencies lists so that the order is
    kept
* Tue Sep 12 2023 fstrba@suse.com
- Added patch:
  * 0003-Reproducible-exclusions-order-in-maven-metadata.patch
    + sort exclusions in maven metadata
* Tue Sep  5 2023 fstrba@suse.com
- Modified patch:
  * 0001-Make-the-alias-generation-reproducible.patch ->
    0001-Make-maven_depmap-order-of-aliases-reproducible.patch
    + replace by the version of patch integrated by upstream
- Added patch:
  * 0002-Do-not-bomb-on-relativePath-construct.patch
    + integrated patch fixing parent recursion with empty
    <relativePath/> element
* Sat Sep  2 2023 fstrba@suse.com
- Upgrade to upstream version 6.2.0
  * Întegrate our changes from javapackages-6.1.0-maven-depmap.patch
- Removed patch:
  * javapackages-6.1.0-maven-depmap.patch
    + upstreamed
- Added patch:
  * 0001-Make-the-alias-generation-reproducible.patch
    + separate patch for our reproducible changes that was not
    part of the integrated pull request
* Mon Aug 21 2023 fstrba@suse.com
- Modified patch:
  * javapackages-6.1.0-maven-depmap.patch
    + try to make the list of aliases more reproducible
* Sun May 28 2023 fstrba@suse.com
- Enable the tests also for older distributions
- Require python3-xml (python-xml for distributions that use
  versioned modules), since module xml needed by some scripts.
* Thu Jul  7 2022 fstrba@suse.com
- Update to upstream version 6.1.0
  * Release version 6.1.0
  * Introduce common and extra subpackages
  * Update documentation
  * Add lua interpreter to check and GH actions
  * Remove license headers from wrapper scripts
  * Make scripts compatible with rpmlua
  * Add more tests, fix behaviour
  * Implement separate simple class name matching
  * Minor changes
  * Modularize Lua scripts
  * Add Lua scripts for removing annotations
  * Update build status badge in README.md
  * Migrate CI from TravisCI to GitHub Actions
  * Fix running tests without coverage
  * Update ivy-local-classpath
  * Release version 6.0.0
  * Fix extra XML handling of pom_change_dep
  * Add reproducer for #82
  * Respect %%jpb_env RPM macro
  * Add bootstrap metadata to XMvn resolver config
  * Delete run_tests.py
  * Replace nose by pytest
  * [install] Make glob pattern work with Python 3.10
  * Adding ppc64le architecture support on travis-ci
  * Drop deprecated add_maven_depmap macro
  * Drop SCL support
  * Fix provides matching
  * Fix builddep snippet generation
  * [test] Add test for builddep snippet generation
  * Add location of java binary used by the java-1.8.0-openjdk
    (JRE) package so that setting JAVA_HOME will work correctly
  * Use XMvn Javadoc MOJO by default
  * Remove explicit import of Python 3 features
  * Remove dependency on Six compatibility library
  * Fix invalid <skippedPlugins> in XMvn configuration
  * [test] Don't try to kill PID 1 during tests
  * [travis] Drop Python 2 from test matrix
  * Add separate subpackage with RPM generators
  * mvn_build: replace inline shell scriptlet with native python
    code
  * [test] Don't use networking during tests
  * Add apache-rat-plugin to skippedPlugins
  * Skip execution of various Maven plugins
  * Remove Python 3.5 from .travis.yml
  * Make generated javadoc package noarch
- Added patch:
  * javapackages-6.1.0-maven-depmap.patch
    + Bulk patch correspoding to our pull request
    https://github.com/fedora-java/javapackages/pull/92 which
    brings back some of the removed tools that we depend on
    heavily
- Modified patches:
  * python-optional.patch
  * suse-use-libdir.patch
    + Rediff to changed context
- Removed patches:
  * 0001-Let-maven_depmap.py-generate-metadata-with-dependenc.patch
  * 0002-Do-not-try-to-construct-POM-from-maven-coordinate-st.patch
  * 0003-Fix-tests-after-the-recent-maven_depmap.py-changes.patch
    + Already part of the above-mentioned bulk patch
  * 0004-Remove-dependency-on-Six-compatibility-library.patch
    + Upstream patch already integrated in the 6.x code-line
* Sun Jun  5 2022 fstrba@suse.com
- Fix wrong conditioning of the python-six require.
* Fri Jun  3 2022 fstrba@suse.com
- Added patch:
  * 0004-Remove-dependency-on-Six-compatibility-library.patch
    + remove dependency on python-six for newer distributions
* Fri Apr 29 2022 fstrba@suse.com
- Added patches:
  * 0001-Let-maven_depmap.py-generate-metadata-with-dependenc.patch
  * 0002-Do-not-try-to-construct-POM-from-maven-coordinate-st.patch
  * 0003-Fix-tests-after-the-recent-maven_depmap.py-changes.patch
    + Let maven_depmap.py generate metadata with dependencies under
    certain circumstances
* Thu Dec 30 2021 david.anes@suse.com
- Fix typo in suse-use-libdir.patch:
  %%{_libdir}/jvm-commmon -> %%{_libdir}/jvm-common
* Tue Jul 27 2021 fstrba@suse.com
- Do not run tests on SLE12, since python3-test is not accessible
* Thu Mar 25 2021 code@bnavigator.de
- Can't assume non-existence of python38 macros in Leap.
  gh#openSUSE/python-rpm-macros#107
  Test for suse_version instead. Only Tumbleweed has and needs the
  python_subpackage_only support.
* Sat Nov 28 2020 code@bnavigator.de
- Fix typo in spec file sitearch -> sitelib
* Sun Nov 22 2020 code@bnavigator.de
- Fix the python subpackage generation
  gh#openSUSE/python-rpm-macros#79
* Sat Nov 21 2020 code@bnavigator.de
- Support python subpackages for each flavor
  gh#openSUSE/python-rpm-macros#66
- Replace old nose with pytest gh#fedora-java/javapackages#86
* Mon Sep  7 2020 dimstar@opensuse.org
- when building extra flavor, BuildRequire javapackages-filesystem:
  /etc/java is being cleaned out of the filesystems package.
* Thu Jul 16 2020 fstrba@suse.com
- Upgrade to version 5.3.1
- Modified patch:
  * suse-use-libdir.patch
    + rediff to changed context
- Define _rpmmacrodir for distributions that don't have it
* Tue May  5 2020 dimstar@opensuse.org
- Use %%{_rpmmacrodir} instead of %%{_libexecdir}/rpm/macros.d: this
  just happens to overlap in some distros.
* Sat Apr  6 2019 fstrba@suse.com
- Rename gradle-local and ivy-local to javapackages-gradle and
  javapackages-ivy and let them depend only on javapackages-tools
  and javapackages-local. These packages only install files
  produced during the javapackages-tools build. The dependencies
  will be pulled by gradle-local, ivy-local and maven-local
  meta-packages built in a separate spec file.
* Thu Apr  4 2019 fstrba@suse.com
- Split maven-local meta-package out of javapackages-tools spec
  file
* Wed Apr  3 2019 fstrba@suse.com
- Make the ivy-local and maven-local sub-packages depend on the
  right stuff, so that they actually can be used for building
* Mon Mar  4 2019 fstrba@suse.com
- Provide both com.sun:tools and sun.jdk:jconsole that are part of
  standard OpenJDK installation. These provides cannot be generated
  from metadata due to build sequence.
* Tue Nov 27 2018 fstrba@suse.com
- Modified patch:
  * suse-use-libdir.patch
    + fix directories for eclipse.conf too
* Sun Nov 11 2018 fstrba@suse.com
- Make the javapackages-local package depend on java-devel. It is
  used for package building and this avoids each package to require
  java-devel itself.
* Mon Nov  5 2018 fstrba@suse.com
- Replace the occurences of /usr/lib by libdir in configuration
  files too
* Wed Oct 24 2018 fstrba@suse.com
- Update to version 5.3.0
- Modified patch:
  * suse-no-epoch.patch
    + rediff to changed code
- Build the :extras flavour as noarch
* Wed Oct 24 2018 fstrba@suse.com
- Added patch:
  * suse-no-epoch.patch
    + we did not bump epoch of OpenJDK packages in SUSE
    + fix a potential generation of unresolvable requires
    + adapt the tests to not expect the epoch
* Tue Jul 24 2018 tchvatal@suse.com
- Switch to multibuild layout
* Tue Jul 24 2018 tchvatal@suse.com
- Update to version 5.2.0+git20180620.70fa2258:
  * Rename the async kwarg in call_script to wait (reverses the logic)
  * Actually bump version to 5.3.0 snapshot
  * Bump version in VERSION file
  * [man] s/Pacakge/Package/g
  * Fix typos in README
  * Fix configure-base.sh after filesystem macro split
  * Split filesystem macros to separate macro file
  * Introduce javapackages-filesystem package
  * [java-functions] extend ABRT Java agent options
  * change abrt-java-connector upstream URL
  * Remove resolverSettings/prefixes from XMvn config
  * Add macros to allow passing arbitrary options to XMvn
  * [spec] Bump package version to 5.1.0
  * Allow specifying custom repo when calling xmvn-install
- Refresh patches:
  * suse-use-libdir.patch
  * python-optional.patch
* Mon Jan 22 2018 tchvatal@suse.com
- Update to version 5.0.0+git20180104.9367c8f6:
  * [java-functions] Avoid colons in jar names
  * Workaround for SCL enable scripts not working with -e
  * Second argument to pom_xpath_inject is mandatory
  * [mvn_artifact] Provide more helpful error messages
  * Fix traceback on corrupt zipfile
  * [test] Add reproducer for rhbz#1481005
  * [spec] Fix default JRE path
  * [readme] Fix typo
  * Add initial content to README.md (#21)
  * Decouple JAVA_HOME setting from java command alternatives
- Rebase patches:
  * python-optional.patch
  * suse-use-libdir.patch
- Drop merged patch fix-abs2rel.patch
* Wed May 24 2017 tchvatal@suse.com
- Fix typo in suse-use-libdir.patch
* Fri May 19 2017 tchvatal@suse.com
- Fix url to correct one https://github.com/fedora-java/javapackages
* Thu May 18 2017 tchvatal@suse.com
- Split to python and non-python edition for smaller depgraph
- Add patch python-optional.patch
- Fix abs2rel shebang:
  * fix-abs2rel.patch
- Fix Requires on subpackages to point to javapackages-tools proper
* Thu May 18 2017 tchvatal@suse.com
- Update to version 4.7.0+git20170331.ef4057e7:
  * Reimplement abs2rel in Python
  * Don't expand {scl} in macro definitions
  * Install expanded rpmfc attr files
  * [spec] Avoid file conflicts between in SCL
  * Fix macros.d directory ownership
  * Make %%ant macro enable SCL when needed
  * [spec] Fix file conflicts between SCL and non-SCL packages
  * Fix ownership of ivyxmldir
  * [test] Force locale for python processes
  * Don't include timestamp in generated pom.properties
- Remove patch merged by upstream:
  * create_valid_xml_comments.patch
- Remove patch suse-macros-install-location.patch
  * We switch to /usr/lib/ location for macros
- Try to reduce some dependencies bsc#1036025
- Refresh patch suse-use-libdir.patch
* Fri Feb 12 2016 toddrme2178@gmail.com
- Add create_valid_xml_comments.patch
  python-lxml 3.5.0 introduces validation for xml comments, and
  one of the comments created in this package were not valid.
  This patch fixes the problem.  It backported from upstream and
  should be in the next release.
  https://github.com/mizdebsk/javapackages/commit/84211c0ee761e93ee507f5d37e9fc80ec377e89d
* Mon Feb  8 2016 tchvatal@suse.com
- Version update to 4.6.0:
  * various bugfixes for maven tooling
  * introduction to gradle-local package for gradle packaging
* Wed Apr  1 2015 tchvatal@suse.com
- Drop dependency over source-highlight as it causes build cycle
* Tue Mar 31 2015 tchvatal@suse.com
- Try to break buildcycle detected on Factory
* Wed Mar 18 2015 tchvatal@suse.com
- Fix build on SLE11
* Tue Mar 17 2015 tchvatal@suse.com
- Use python-devel instead of pkgconfig to build on sle11
* Tue Mar 17 2015 tchvatal@suse.com
- Add python-javapackages as requirement for main package
* Tue Mar 17 2015 tchvatal@suse.com
- Update requires on python packages to properly have all the needed
  dependencies on runtime
* Tue Mar 17 2015 tchvatal@suse.com
- Install macros to /etc/rpm as we do in SUSE:
  * suse-macros-install-location.patch
- Cleanup with spec-cleaner
* Fri Jan 23 2015 mailaender@opensuse.org
- Drop patches
  * depgen.patch
  * javapackages-2.0.1-fix-bashisms.patch
  * javapackages-2.0.1-java9.patch
  * maven_depmap-no-attribute-exit.patch
- Remove hacky workarounds
- Fix rpmlint errors
- Enable maven-local
- Avoid unsatisfiable dependencies
- Enable unit tests
- Update to version 4.4.0
* Mon Dec  8 2014 fstrba@suse.com
- Added patch:
  * javapackages-2.0.1-java9.patch: create directories for java,
    so that ant build works
- Add virtual provide jpackage-utils-java9 to be able to
  distinguish the presence of java9 compatibility
* Thu Oct 16 2014 ledest@gmail.com
- fix bashisms
- Added patches:
  * javapackages-2.0.1-fix-bashisms.patch
* Mon Mar 10 2014 darin@darins.net
- maven_depmap-no-attribute-exit.patch: SLES patch for ZipFile
  having no attribute '__exit__' which was causing ecj build
  failures
* Thu Mar  6 2014 darin@darins.net
- set correct libxslt package when building for SLES
* Fri Nov  8 2013 aj@ajaissle.de
- BuildRequires xz
- Remove '/etc/java' and '/usr/share/java' from file list (both owned by system)
- Url changed
* Wed Sep 11 2013 schwab@suse.de
- depgen.patch: drain stdin in dependency generator
* Wed Aug 21 2013 mvyskocil@suse.com
- update to 2.0.1
  * Fix creation of artifact aliases, resolves: rhbz#988462
- Update to upstream version 2.0.0
  * Merge functionality of jpackage-utils
  * Provide and obsolete jpackage-utils
  * %%%%add_maven_depmap macro now injects pom.properties to every JAR
  * %%%%add_to_maven_depmap and %%%%update_maven_depmap macros were removed
  * maven2jpp-mapdeps.xsl template has been removed
  * Macros related to installation of icons and desktop files were removed
  * 14 new manual pages were added
  * Documentation specific to JPackage was removed
  * Add BuildRequires: asciidoc, xmlto
  * Add lua to Requires
  * Add python-xml to Requires for xml.dom.minidom
* Fri Jul 12 2013 mvyskocil@suse.com
- make maven-local package build optional to not add unsatisfied
  dependencies to Factory
* Tue Jul  2 2013 mvyskocil@suse.com
- Create javapackages-tools 0.15.0 from fc20
  * Added depmap for tools.jar
  * Added support for versioned autorequires
  * New plugin metadata from Maven Central
  * move to independent package from jpackage-utils
