#
# spec file for package gettext-runtime
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define pacname gettext
%bcond_with mini

Name:           gettext-runtime
Version:        0.21.1
Release:        150600.3.3.2
BuildRequires:  gcc-c++
BuildRequires:  libtool
# To get an updated linkdupes.sh (in case there are new dupes), temproarily enable:
#BuildRequires: fdupes
%if %{without mini}
BuildRequires:  automake
BuildRequires:  glib2-devel
BuildRequires:  libxml2-devel
BuildRequires:  perl-libintl-perl
BuildRequires:  tcl
# bug437293
%ifarch ppc64
Obsoletes:      gettext-64bit
%endif
#
#Rename done for openSUSE 11.0
Provides:       gettext = %{version}
Obsoletes:      gettext < %{version}
Conflicts:      gettext-runtime-mini
Conflicts:      gettext-tools-mini
%else
# to allow a prjconf preference which to take per build
Provides:       gettext-runtime = %{version}
# rpm-build requires gettext-tools, but we will only just be building it
#!BuildIgnore:  gettext-tools
%endif
Summary:        Tools for Native Language Support (NLS)
License:        GPL-3.0-or-later AND LGPL-2.0-or-later
Group:          Development/Tools/Other
URL:            https://www.gnu.org/software/gettext/
Source0:        https://ftp.gnu.org/gnu/gettext/gettext-%{version}.tar.xz
Source1:        https://ftp.gnu.org/gnu/gettext/gettext-%{version}.tar.xz.sig
Source2:        suse-start-po-mode.el
Source3:        gettext-linkdupes.sh
Source4:        baselibs.conf
Source5:        gettext-rpmlintrc
Source6:        gettext-runtime.keyring
Patch0:         gettext-0.12.1-sigfpe.patch
Patch1:         gettext-0.19.3-fix-bashisms.patch
Patch2:         gettext-0.12.1-gettextize.patch
Patch3:         use-acinit-for-libtextstyle.patch
Patch4:         gettext-po-mode.diff
Patch5:         gettext-initialize_vars.patch
# PATCH-FIX-OPENSUSE gettext-dont-test-gnulib.patch -- coolo@suse.de
Patch6:         gettext-dont-test-gnulib.patch
Patch7:         gettext-0.21-jdk17.patch
# PATCH-FIX-UPSTREAM boo#941629 -- pth@suse.com
Patch11:        boo941629-unnessary-rpath-on-standard-path.patch
# PATCH-FIX-SUSE Bug boo#1106843
Patch13:        reproducible.patch
# PATCH-FEATURE bsc#1165138
Patch14:        0001-msgcat-Add-feature-to-use-the-newest-po-file.patch
Patch15:        0002-msgcat-Merge-headers-when-use-first.patch
# PATCH-FEATURE-FIX-SUSE boo#1227316 -- sbrabec@suse.com
Patch16:        0003-Fix-malformed-header-processing.patch

%description
This package contains the intl library as well as tools that ease the
creation and maintenance of message catalogs. It allows you to extract
strings from source code. The supplied Emacs mode (po-mode.el) helps
editing these catalogs (called PO files, for portable object) and
adding translations. A special compiler turns these PO files into
binary catalogs.

%package     -n gettext-tools%{?with_mini:-mini}
Summary:        Tools for Native Language Support (NLS)
License:        LGPL-2.1-or-later
Group:          Development/Tools/Other
Requires:       %{name} = %{version}
Requires:       xz
%if %{without mini}
Requires(post): info
Requires(preun):info
%endif
Provides:       gettext-devel = %{version}
%if %{without mini}
# bug437293
%ifarch ppc64
Obsoletes:      gettext-devel-64bit
%endif
#
Obsoletes:      gettext-devel < %{version}
Conflicts:      gettext-runtime-mini
Conflicts:      gettext-tools-mini
%else
# to allow a prjconf preference which to take per build
Provides:       gettext-tools = %{version}
%endif
# Several tools use bison-runtime text domain:
%if 0%{?suse_version}
Recommends:     bison-lang
%endif

%description -n gettext-tools%{?with_mini:-mini}
This package contains the `intl' library as well as tools that ease the
creation and maintenance of message catalogs. With it you can extract
strings from source code. The supplied Emacs mode (po-mode.el) will aid
in editing these catalogs (called PO files, for portable object) and
add translations. A special compiler will turn these PO files into
binary catalogs.

%package tools-doc
Summary:        HTML documentation and examples for gettext-runtime
License:        GPL-3.0-or-later AND LGPL-2.0-or-later
Group:          Documentation/HTML
BuildArch:      noarch

%description tools-doc
This subpackage contains the HTML version of the gettext documentation
as well as project examples.

%if %{without mini}
%package     -n libtextstyle0
Summary:        Provides textstyling for console output
License:        LGPL-2.1-or-later
Group:          Development/Tools/Other

%description -n libtextstyle0
GNU libtextstyle provides an easy way to add styling to programs that produce output to a console or terminal emulator window.
It does this in a way that allows the end user to customize the styling using the industry standard, namely Cascading Style Sheets (CSS).

%package     -n libtextstyle-devel
Summary:        Devel package for libtextstyle
License:        LGPL-2.1-or-later
Group:          Development/Tools/Other
Requires:       libtextstyle0 = %{version}

%description -n libtextstyle-devel
This package provides headers and static libraries for libtextstyle
%endif

%prep
%setup -q -n %{pacname}-%{version}
%patch0
%patch1 -p1
%patch2
%patch3 -p1
%patch4
%patch5
%patch6 -p1
%patch7 -p1
%patch11 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1

%build
%define _lto_cflags %{nil}
# expect a couple "You should update your `aclocal.m4' by running aclocal."
autoreconf -fiv
export CFLAGS="%{optflags} -pipe -W -Wall -Dgcc_is_lint"
export CXXFLAGS="$CFLAGS -Dgcc_is_lint"
export LDFLAGS="-lm"
%configure --disable-static $OPTS
%if %{with mini}
# Link statically to libtextstyle from libgettextlib.so
export CFLAGS="${CFLAGS} -fPIC"
export CXXFLAGS="${CXXFLAGS} -fPIC"
(cd libtextstyle; %configure --enable-static --disable-shared ${OPTS})
%endif
make %{?_smp_mflags} GMSGFMT=../src/msgfmt V=1
# use texinfo.tex supplied by the system (texinfo)
# make -C gettext-tools/doc gettext.pdf

%install
%define my_docdir %{_defaultdocdir}/%{name}
export LC_CTYPE=ISO-8859-15
%make_install docdir=%{my_docdir}
cp -pr AUTHORS NEWS README*	%{buildroot}/%{my_docdir}
mkdir -p %{buildroot}/usr/share/emacs/site-lisp
install -m 644 %SOURCE2 %{buildroot}/usr/share/emacs/site-lisp
install -m 644 gettext-tools/emacs/po-compat.el %{buildroot}/usr/share/emacs/site-lisp
install -m 644 gettext-tools/emacs/po-mode.el %{buildroot}/usr/share/emacs/site-lisp
install -m 644 gettext-tools/emacs/start-po.el %{buildroot}/usr/share/emacs/site-lisp
#make -C gettext-tools/doc docdir=%%{buildroot}/%%{my_docdir} install-pdf
if [ -e %{buildroot}/%{_libdir}/preloadable_libintl.so ];then
	chmod 755 %{buildroot}/%{_libdir}/preloadable_libintl.so
fi
# fix rpmlint invalid-lc-messages-dir:
rm -rf %{buildroot}/%_datadir/locale/en@{bold,}quot
%{find_lang} gettext-tools
%{find_lang} gettext-runtime
#remove unwanted stuff
rm -f %{buildroot}/usr/share/doc/packages/gettext/README.{mingw,vms,woe32}
rm -f %_datadir/%name/gettext.jar
rm -f %{buildroot}/%_libdir/libtextstyle.la
%if %{with mini}
	rm -f %{buildroot}/usr/include/textstyle.h
	rm -rf %{buildroot}/usr/include/textstyle
	rm -rf %{buildroot}/usr/share/doc/packages/gettext-runtime-mini/libtextstyle_*.html
	rm -f %{buildroot}/%_libdir/libtextstyle.a
	rm  -f %{buildroot}/%{_infodir}/libtextstyle.info
%endif
#find %%{buildroot} -maxdepth 2 -name '*html' -delete
# hardlink the dupes in the documentation:
cd %{buildroot}/%{my_docdir}/examples
sh %{SOURCE3}
# moved to gettext-java and gettext-csharp:
rm -rf *csharp* *java* ../javadoc* ../csharpdoc*
rm -f %{buildroot}%{_defaultdocdir}/%name/README.woe32
rm -f %{buildroot}%{_infodir}/dir
cd %{buildroot}/%{_mandir}/man3
echo ".so man3/dngettext.3" > dcngettext.3
echo ".so man3/dgettext.3" > dcgettext.3

%if %{without mini}
%check
# s390s fails this test,
# Starting test_recursive_lock ...test-lock: pthread_mutex_lock.c:66: __pthread_mutex_lock: Assertion `mutex->__data.__owner == 0' failed.

# These fails randomly, remove them from Makefile
sed -i -e 's/test-areadlink\$(EXEEXT) //g' \
 -e 's/test-readlink\$(EXEEXT) //g' \
 gettext-tools/gnulib-tests/Makefile

make check || {
%ifarch s390x
	echo "got this during mbuild testing on s390x (on both times which make check ran):"
	echo "Starting test_recursive_lock ...test-lock: pthread_mutex_lock.c:66: __pthread_mutex_lock: Assertion mutex->__data.__owner == 0 failed."
	echo "s390x needs kernel/glibc/gcc fix, but let it continue bootstrap for now!"
%else
	echo "make check failed, check it!"
	exit 5
%endif
}
%endif

%post -p /sbin/ldconfig

%postun  -p /sbin/ldconfig

%post -n gettext-tools%{?with_mini:-mini}
%install_info --info-dir=%{_infodir} %{_infodir}/gettext.info.gz
%install_info --info-dir=%{_infodir} %{_infodir}/autosprintf.info.gz

%preun -n gettext-tools%{?with_mini:-mini}
%install_info_delete --info-dir=%{_infodir} %{_infodir}/gettext.info.gz
%install_info_delete --info-dir=%{_infodir} %{_infodir}/autosprintf.info.gz

%if %{without mini}
%post   -n libtextstyle0 -p /sbin/ldconfig
%postun -n libtextstyle0 -p /sbin/ldconfig
%endif

%files -f gettext-runtime.lang
%defattr(-,root,root)
%license COPYING
%dir %_datadir/gettext
%doc %dir %_docdir/%name/
%doc %_docdir/%name/gettext.1.html
%doc %_docdir/%name/ngettext.1.html
%doc %_docdir/%name/envsubst.1.html
%doc %_docdir/%name/*.3.html
%doc %_docdir/%name/AUTHORS
%doc %_docdir/%name/NEWS
%doc %_docdir/%name/README
%doc %_docdir/%name/FAQ.html
%_bindir/gettext
%_bindir/ngettext
%_bindir/envsubst
%_bindir/gettext.sh
%_bindir/msgfmt
%_libdir/libgettextlib-*.so
%_libdir/libgettextsrc-*.so
%_libdir/libasprintf.so.*
%doc %_mandir/man1/gettext.1.gz
%doc %_mandir/man1/ngettext.1.gz
%doc %_mandir/man1/envsubst.1.gz
%doc %_mandir/man1/msgfmt.1.gz
%doc %_mandir/man3/*
%_datadir/gettext/ABOUT-NLS
%dir %_datadir/emacs
%dir %_datadir/emacs/site-lisp
%_datadir/emacs/site-lisp/po-compat.*
%_datadir/emacs/site-lisp/po-mode.*
%_datadir/emacs/site-lisp/start-po.*
%_datadir/emacs/site-lisp/suse-start-po-mode.el

%files -n gettext-tools%{?with_mini:-mini} -f gettext-tools.lang
%defattr(-,root,root)
%_bindir/msg[a-eg-u]*
%_bindir/msgfilter
%_bindir/xgettext
%_bindir/gettextize
%_bindir/autopoint
%_bindir/recode-sr-latin
%doc %_mandir/man1/msg[a-eg-u]*.1.gz
%doc %_mandir/man1/msgfilter.1.gz
%doc %_mandir/man1/xgettext.1.gz
%doc %_mandir/man1/gettextize.1.gz
%doc %_mandir/man1/autopoint.1.gz
%doc %_mandir/man1/recode-sr-latin.1.gz
%doc %_infodir/gettext.info*
%doc %_infodir/autosprintf.info*
%_includedir/gettext-po.h
%_includedir/autosprintf.h
%_libdir/libasprintf.*a
%_libdir/libasprintf.so
%_libdir/libgettextlib.*
%_libdir/libgettextsrc.*
%_libdir/libgettextpo*
%_libdir/preloadable_libintl.so
%_libdir/gettext
%_datadir/%pacname/config.rpath
%_datadir/%pacname/po
%_datadir/%pacname/projects
%_datadir/%pacname/gettext.h
%_datadir/%pacname/msgunfmt.tcl
%_datadir/%pacname/javaversion.class
%_datadir/%pacname/styles
%_datadir/%pacname/archive.dir.tar.xz
%_datadir/aclocal
%dir %{_datadir}/%{pacname}-%{version}
%{_datadir}/%{pacname}-%{version}/its

%files tools-doc
%defattr(-,root,root)
%doc %dir %_docdir/%name/
%doc %_docdir/%name/examples/
%doc %_docdir/%name/auto*.html
%doc %_docdir/%name/gettext_*.html
%doc %_docdir/%name/gettextize*.html
%doc %_docdir/%name/msg*.html
%doc %_docdir/%name/tutorial*.html
%doc %_docdir/%name/xgettext*.html
%doc %_docdir/%name/recode-sr-latin.1.html

%if %{without mini}
%files -n libtextstyle0
%defattr(-,root,root)
%_libdir/libtextstyle.so.*

%files -n libtextstyle-devel
%defattr(-,root,root)
%dir %_includedir/textstyle
%_includedir/textstyle.h
%_includedir/textstyle/stdbool.h
%_includedir/textstyle/version.h
%_includedir/textstyle/woe32dll.h
%_libdir/libtextstyle.so
%doc %_docdir/gettext-runtime%{?with_mini:-mini}/libtextstyle*.html
%doc %_infodir/libtextstyle.info.gz
%endif

%changelog
* Wed Feb 26 2025 sbrabec@suse.com
- Fix crash while handling po files with malformed header and
  process them properly
  (0003-Fix-malformed-header-processing.patch, boo#1227316).
* Thu May  4 2023 fcrozat@suse.com
- Add _multibuild to define additional spec files as additional
  flavors.
  Eliminates the need for source package links in OBS.
* Mon Oct 24 2022 dmueller@suse.com
- update keyring for the last version update
* Sat Oct 15 2022 coolo@suse.com
- Update to Version 0.21.1
  * Runtime behaviour:
  - On AIX, locale names with a script or with an uppercase language are now
    supported.
    For example, sr_Cyrl_RS.UTF-8 is treated like sr_RS.UTF-8@cyrillic, and
    EN_US.UTF-8 is treated like en_US.UTF-8.
  * The base Unicode standard is now updated to 14.0.0.
  * Portability:
  - Building on macOS 11/arm64 is now supported.
  - Building on Linux/powerpc64le with glibc ≥ 2.35 is now supported.
* Fri Apr  8 2022 fstrba@suse.com
- Added patch:
  * gettext-0.21-jdk17.patch
    + Build with java source and target levels 1.8
    + Allows building with JDK17
    + Fixes build in Factory
* Mon Nov 29 2021 mgorse@suse.com
- Remove libcroco from BuildRequires: it is now bundled internally.
* Fri Jan 22 2021 dmueller@suse.com
- fixup libtextstyle autofoo with adding
  use-acinit-for-libtextstyle.patch
* Fri Aug  7 2020 mcalabkova@suse.com
- Add multiple new features (bsc#1165138)
- Add patches:
  * 0001-msgcat-Add-feature-to-use-the-newest-po-file.patch
  * 0002-msgcat-Merge-headers-when-use-first.patch
- Reintroduce autoreconf call
* Tue Jul 28 2020 christian.voegl@suse.com
- Update to 0.21:
  * Programming languages support:
  - Shell:
    o xgettext now recognizes and ignores 'env' invocations and environment
    variable assignments in front of commands.
  - Java:
    o xgettext now recognizes format strings in the Formatter syntax.  They
    are marked as 'java-printf-format' in POT and PO files.
    o xgettext now recognizes text blocks as string literals.
  - JavaScript:
    xgettext parses JSX expressions more reliably.
  - Ruby:
    o xgettext now supports Ruby.
    o 'msgfmt -c' now verifies the syntax of translations of Ruby format
    strings.
  * Improvements for translators:
  - When msgfmt writes a MO file, it now does so in such a way that processes
    that are currently using an older copy of the MO file will not crash.
  * Libtextstyle:
  - Added support for emitting hyperlinks.
  - New API for doing formatted output.
  - The example programs support the NO_COLOR environment variable.
* Tue Jul  7 2020 christian.voegl@suse.com
- Fix boo941629-unnessary-rpath-on-standard-path.patch (boo#941629)
* Sun Apr 26 2020 andreas.stieger@gmx.de
- update to 0.20.2:
  * The programs 'gettext', 'ngettext', when invoked with option -e,
    now expand '\\' and octal escape sequences, instead of
    swallowing them
  * xgettext now recognizes 'gettext' program invocations with the
    '-e' option, such as gettext -e 'some\nstring\n'
  * xgettext now assumes a Python source file is in UTF-8 encoding
    by default, as stated in PEP 3120
  * The value of the 'Icon' property is no longer extracted into
    the POT file by xgettext
* Mon Jan 27 2020 schwab@suse.de
- Don't disable openmp with qemu, the emulation works now
* Wed Jan 15 2020 dimstar@opensuse.org
- Add libtextstyle0 to baselibs.conf: gettext-runtime-32bit has a
  dependency on it, so we also need the library built as -32bit.
* Sat Dec 21 2019 stefan.bruens@rwth-aachen.de
- Add missing Requires: libtextstyle0 in corresponding devel package,
  drop gettext-runtime Requires.
- Skip creation of shared libtextstyle in -mini flavor.
- Statically link to libtextstyle in -mini flavor, fixes
  broken bootstrap of gettext.
* Tue Dec 17 2019 cvoegl@suse.de
- Add -lm to LDFLAGS (boo#1138806)
* Tue Nov 26 2019 cvoegl@suse.de
- Added xz to requires (boo#1141380)
- The previous update to 0.20.1 also fixes (boo#1113719)
* Wed Oct 30 2019 stefan.bruens@rwth-aachen.de
- Remove autoreconf call (not required), and drop the no longer
  required libtool build dependency.
* Fri Aug 23 2019 jengelh@inai.de
- Heed SLPP by placing libtextstyle.so.0 in the right package.
- Drop documentation from libtextstyle0, no one will read it there.
- Drop static library.
- Remove pointless ldconfig calls for libtextstyle-devel.
- Avoid pointless sh invocation of libtextstyle0 scriptlets.
- Avoid unnecessary |xargs rm.
- Remove redundant %%clean section.
* Thu Jun 20 2019 mliska@suse.cz
- Disable LTO (boo#1138806).
* Tue Jun 11 2019 christian.voegl@suse.com
- Updatetd to 0.20.1
  + msgfmt now eliminates the POT-Creation-Date header field from .mo files.
  + update-po target in Makefile.in.in now uses msgmerge --previous.
  + msgmerge now has an option --for-msgfmt, that produces a PO file meant
    for use by msgfmt only.  This option saves processing time, in particular
    by omitting fuzzy matching that is not useful in this situation.
  + The .pot file in a 'po' directory is now erased by "make maintainer-clean".
  + It is now possible to override xgettext options from the po/Makefile.in.in
    through options in XGETTEXT_OPTIONS (declared in po/Makevars).
  + The --intl option of the gettextize program (deprecated since 2010) is
    no longer available. Instead of including the intl sources in your package,
    we suggest making the libintl library an optional prerequisite of your
    package. This will simplify the build system of your package.
  + Accordingly, the Autoconf macro AM_GNU_GETTEXT_INTL_SUBDIR is gone as well.
  + C, C++:
  * xgettext now supports strings in u8"..." syntax, as specified in C11
    and C++11.
  * xgettext now supports 'p'/'P' exponent markers in number tokens, as
    specified in C99 and C++17.
  + C++:
  * xgettext now supports single-quotes in number tokens, as specified in
    C++14.
  + Shell:
  * The programs 'gettext', 'ngettext' now support a --context argument.
  * gettext.sh contains new function eval_pgettext and eval_npgettext
    for producing translations of messages with context.
  + Perl:
  * Native support for context functions (pgettext, dpgettext, dcpgettext,
    npgettext, dnpgettext, dcnpgettext).
  * better detection of question mark and slash as operators (as opposed
    to regular expression delimiters).
  + Scheme:
  * xgettext now parses the syntax for specialized byte vectors (#u8(...),
    [#]vu8(...), etc.) correctly.
  + Pascal:
  * xgettext can now extract strings from .rsj files, produced by the
    Free Pascal compiler version 3.0.0 or newer.
  + Vala:
  * xgettext now parses escape sequences in strings more accurately.
  + JavaScript:
  * xgettext now parses template literals correctly.
- Rebased gettext-dont-test-gnulib.patch
- Removed gettext-needlessly_init_vars.patch (now in upstream)
- Rebased gettext-po-mode.diff
- Removed msgfmt-remove-pot-creation-date.patch (now in upstream)
- Removed msgfmt-reset-msg-length-after-remove.patch (now in upstream)
- Removed parts of reproducible.patch (now in upstream)
* Sat May 25 2019 meissner@suse.com
- reproducible.patch: generate timestamp in .pot files from SOURCE_DATE_EPOCH
  for reproducible builds
* Mon Mar  4 2019 dimstar@opensuse.org
- Only Require(Pre/Post) info in the non-mini variant: as the -mini
  version is only used inside OBS, it is irrelevant if the info
  files are present and registered or not.
* Sat Oct  6 2018 bwiedemann@suse.com
- Add reproducible.patch to override build date (boo#1047218)
* Wed Sep 19 2018 werner@suse.de
- Add patch msgfmt-reset-msg-length-after-remove.patch
  which does reset the length of message string after a line
  has been removed (boo#1106843)
* Thu May 24 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Mon May 14 2018 antoine.belvire@opensuse.org
- Fix %%install_info_delete usage:
  * It has to be performed in %%preun, not %%postun.
  * This fixes warning messages upon package removal.
* Wed Oct 18 2017 jayvdb@gmail.com
- Ignore Recommends: on non-SUSE distributions
- Explicitly remove %%{_infodir}/dir before creating package to
  allow builds on RHEL and derived Linux distributions
* Mon Jul 17 2017 dimstar@opensuse.org
- Ignore rpm-build's dependency on gettext-tools while building
  the -mini variant: before gettext-runtime-mini is built, there is
  no provider of this symbol in a bootstrap cycle.
* Sat Jul  1 2017 dimstar@opensuse.org
- Explicitly call autoreconf, as we have patches touching the build
  system. Implicit calling automake/autoconf works only as long as
  the version on the system is the same as was used to bootstrap
  originally.
* Fri May  5 2017 bwiedemann@suse.com
- Add msgfmt-remove-pot-creation-date.patch
  to enable reproducible builds of packages using gettext-runtime
  such as dfc, e2fsprogs and acl
* Sun Jun 19 2016 astieger@suse.com
- GNU gettext 0.19.8.1:
  * Fix unintentional soname bump
* Sat Jun 11 2016 astieger@suse.com
- GNU gettext 0.19.8:
  * msgfmt now produces little-endian .mo files by default.
  * xml: xgettext and msgfmt now look for .its files in directories
    supplied through the GETTEXTDATADIRS or XDG_DATA_DIRS
    environment variable.
  * JavaScript: xgettext and msgfmt now recognize numbered
    arguments in format strings.
* Fri Apr 22 2016 astieger@suse.com
- drop gettext-runtime-grep-2.24.patch, no longer required for 2.25
* Sun Apr 17 2016 astieger@suse.com
- GNU gettext 0.19.7:
  * can now load custom string extraction rules in XML
    Internationalization Tag Set (ITS) standard
  * the existing XML-based language scanners (Glade, GSettings, and
    AppData) rewritten using ITS
  * Add msgfmt --xml option to merge translations back to the
    original XML document.
* Tue Apr 12 2016 dimstar@opensuse.org
- Add gettext-runtime-grep-2.24.patch: Fix test suite with
  grep 2.24 (https://savannah.gnu.org/bugs/index.php?47674).
* Tue Dec  8 2015 sbrabec@suse.com
- Recommend  bison-lang by gettext-tools, as it is used by them.
* Fri Sep 11 2015 astieger@suse.com
- GNU gettext 0.19.6:
  * Support AppData file format
  * New macro AM_GNU_GETTEXT_REQUIRE_VERSION
  * po/Makefile.in.in can now insert the file $(DOMAIN).pot-header
    to $(DOMAIN).pot, instead of the standard header comments.
  * Fix mishandling of gettext version numbers for minor releases, in
    po-mode.el and gettextize.
  * Fix build with --enable-relocatable.
- remove no longer required gettext-0.19.5.1-gettextize.diff
* Mon Aug 24 2015 i@marguerite.su
- add patch: boo941629-unnessary-rpath-on-standard-path.patch
  * config.rpath from gettext-tools will set rpath for ELF binaries
    not in /usr/lib, even if it's the standard path the linker
    would search anyway.
* Tue Jul 21 2015 mlin@suse.com
- Add gettext-0.19.5.1-gettextize.diff
  * workaround gettextize in gettext 0.19.5.1, see
    http://lists.gnu.org/archive/html/bug-gettext/2015-07/msg00027.html
* Thu Jul 16 2015 astieger@suse.com
- GNU gettext 0.19.5.1:
  * fix build on old platforms where stpcpy and stpncpy is missing
* Fri Jul 10 2015 astieger@suse.com
- GNU gettext 0.19.5:
  * xgettext: feature to perform syntax checks on msgid, via
  - -check option or "xgettext: " commentgs
  * msgfilter, msgexec: new option --newline
  * The base Unicode standard is now updated to 8.0.0.
  * msginit is now capable of generating "Plural-Forms:" from
    Unicode CLDR. Via  GETTEXTCLDRDIR environment variable.
  * Improved Programming languages support
  * drop gettext-check-allocated-size-for-static-segment.patch,
    is upstream
* Tue Mar 10 2015 mlin@suse.com
- Add gettext-check-allocated-size-for-static-segment.patch from upstream
  * Check if the embedded segment size is valid, before adding it to
    the string length. Please see
    http://lists.gnu.org/archive/html/bug-gettext/2015-03/msg00005.html
* Tue Jan 27 2015 andreas.stieger@gmx.de
- GNU gettext 0.19.4:
  * The --keyword option of xgettext now accepts same argument
    number for both singular and plural forms.
  * Programming languages support:
  - C#: xgettext now properly handles Unicode characters encoded
    with surrogate pairs.
  - C/C++: xgettext now recognizes ISO/IEC 9899:2011 string
    literals prefixed by R, u8, u8R, u, uR, U, UR, L, or LR.
  - Shell: xgettext now properly recognizes Bash ANSI-C quoting
    ($'...').
  * Bug fixes:
  - Fix integer overflow when reading certain MO files with
    msgunfmt.
  - Avoid invalid memory access in various cases.  In particular,
    when the same argument number is specified for singular/
    plural arguments, and when checking Lisp and Scheme format
    strings.
* Sun Dec 28 2014 ledest@gmail.com
- fix 'echo -e' in cvs.sh script that may be unsupported in some
  POSIX-complete shells
- add patches:
  * gettext-0.19.3-fix-bashisms.patch
* Fri Oct 17 2014 andreas.stieger@gmx.de
- GNU gettext 0.19.3:
  * Fix xgettext mishandling of octal character escapes in C.
  * Fix autopoint infinite recursion with certain configure.ac.
  * The po/Makevars file has a new field MSGINIT_OPTIONS, that can
    be used to adjust msginit's operation.  This is particularly
    useful for controlling line wrapping behavior together with
    MSGMERGE_OPTIONS and XGETTEXT_OPTIONS.
* Tue Jul 15 2014 pth@suse.de
- Update to 0.19.2:
  * Fix xgettext crash in parsing empty string literals in C and Vala.
  * Autoconf macro trace in autopoint now works again with Autoconf 2.68
    or earlier.  It was a regression in 0.19.
* Tue Jun 10 2014 andreas.stieger@gmx.de
- GNU gettext 0.19.1:
  * Desktop Entry: msgfmt now always reads the po/LINGUAS file
  * Vala:  Bug fix in xgettext handling of "//" in string literals
  * po/Makevars.template now contains the newly added variables
  * msgfmt now treats errors in the PO file header as non-fatal
    In future Gettext versions, msgfmt will treat header errors as
    fatal and terminate the command execution.
- switch to xz tarball
* Tue Jun  3 2014 andreas.stieger@gmx.de
- GNU gettext 0.19:
  - Programming languages support:
  * Desktop Entry:
    xgettext and msgfmt now support .desktop files, used by
    desktop applications, as input and output.
  * GSettings:
    xgettext now supports GSettings schema file format used by
    GNOME applications.
  * JavaScript:
    xgettext now recognizes E4X (ECMA-357) constructs.
  * PHP:
    Single and double quotes around heredoc markers are now
    recognized.
  * Python:
    The acceptable format specifiers in the braced-syntax format
    strings is now limited to the Standard Format Specifiers, to
    reasonably avoid false-positives.
  * Scheme:
    The gettext shorthand form _"abc", used by GIMP script-fu, is
    now recognized by xgettext.
  * C and Vala:
    xgettext now recognizes C99-style Unicode character escapes.
  - The --add-location option of msgattrib, msgcat, msgcomm,
    msgconv, msgen, msgfilter, msggrep, msgmerge, msguniq, and
    xgettext commands now takes an optional argument 'never',
    'full', or 'file', to control the format of "#: ..." comments.
  - msgfmt now has --source option to keep generated .java file
    when running in Java mode.
  - msgattrib now has --empty option that sets msgstr to empty when
    clearing fuzzy flag.
  * msgexec and msgfilter pass the plural information to subprocess
    through the environment variable MSG{EXEC,FILTER}_MSGID_PLURAL
    and MSG{EXEC,FILTER}_PLURAL_FORM.
  * New built-in filters 'quot' and 'boldquot' have been added to
    msgfilter.  These filters convert Latin quotation marks ('...',
    "...") into Unicode quotation marks (for example, U+2018) if
    possible, similar to the sed commands used in po/Rules-quot and
    po/Rules-boldquot.
  * The po/Makevars file has a couple of new options
    PO_DEPENDS_ON_POT and DIST_DEPENDS_ON_UPDATE_PO, that can be
    used to adjust the behavior of updating PO files on demand.
  * xgettext now strips prefixed string before the comment tag.
    This is useful to support C-style comment like this:
    /*
  * TRANSLATORS: first line
  * second line
  * /
  * In this example, the extracted comment does not contain "* " at
    the beginning of each line.
  * libgettextpo library:
  - Memory leak fixes in the PO file parser.
  * Documentation:
  - A complete example showing the use of GNU gettext in a
    GNOME 3 application has been added
* Sun Jan 12 2014 andreas.stieger@gmx.de
- GNU gettext 0.18.3.2:
  * Add missing extern-inline.m4 into archive.
- verify source signature
* Tue Dec 24 2013 coolo@suse.com
- avoid testing gnulib copies - we're not interested in bugs in gnulib
  as we don't use it
* Sun Oct 20 2013 jengelh@inai.de
- Split extra documentation in /usr/share/doc into separate
  subpackage
- Substitute %%_prefix/share => %%_datadir and
  %%_defaultdocdir/%%name => %%_docdir
* Wed Oct  2 2013 coolo@suse.com
- Version 0.18.3.1 including a hotfix for autopoint
  not copying intl library if asked to (fixes build failures in 13.1)
  https://savannah.gnu.org/bugs/?func=detailitem&item_id=39536
* Mon Aug 12 2013 christoph.miebach@web.de
- Version 0.18.3 - July 2013
  * Runtime behaviour:
    On Mac OS X systems, the setlocale() function now properly
    invalidates loaded message catalogs when a locale has been set.
  * Programming languages support:
  - C++:
    The gnu::autosprintf class now provides an assignment
    operator.
  - Glade:
    xgettext now supports GtkBuider file format used by Glade 3.
    xgettext now also extracts contexts (msgctxt) from Glade 2
    and GtkBuider files.
  - JavaScript:
    xgettext now partially supports JavaScript.  Since the
    current JavaScript specification (ECMA-262) does not define
    the standard set of formatting methods nor translation
    functions, the implementation supports only a limited
    set of formatting methods and translation functions commonly
    used in Gjs and other popular JavaScript implemenations and
    libraries.
  - Lua:
    xgettext now supports Lua, using Ľubomír Remák's lua-gettext.
  - Python:
    xgettext and msgfmt's format string checking now recognize
    Python format string in braced syntax (PEP 3101).  xgettext
    now also supports explicit string concatenation with '+' and
    handles platform dependent line terminators (LF/CR/CRLF)
    transparently.
  - Tcl:
    Bug fix in xgettext Unicode escape handling.
  - Vala:
    xgettext now supports Vala.
  * msgattrib now has --previous option to keep previous msgid when
    making messages fuzzy, similar to msgmerge --previous.
  * msgfmt now checks PO file headers more strictly with less
    false-positives.
  * 'gettextize' now checks macro directories specified with
    AC_CONFIG_MACRO_DIRS in configure.ac.
  * Portability:
  - msginit now does not require GNU sed.
  - The Makefile rule for generating en@quot and en@boldquot now
    uses @SED@ variable instead of hard-coded 'sed' command to
    allow users to supply GNU sed.
  * Future backward-incompatibilities:
  - In future Gettext versions, the files installed by
    'gettextize' will require Automake 1.10 or later.  This will
    improve the compatibility of user projects with newer
    Automake versions.
- Remove upstreamed patches:
  gettext-configure.patch
  gettext-fix-tcl-u-escape-sequences.patch
* Tue Jun 25 2013 gber@opensuse.org
- add gettext-fix-tcl-u-escape-sequences.patch in order to fix
  the handling of Tcl \u escape sequences (bnc#826422)
* Wed Jun 19 2013 coolo@suse.com
- move the provides of gettext-devel to gettext-tools-mini too
* Tue Jun 18 2013 coolo@suse.com
- more conflicts between the minis
* Tue Jun 18 2013 coolo@suse.com
- make gettext-runtime conflict with gettext-runtime-mini
* Tue Jun 18 2013 schwab@suse.de
- Add gettext-runtime-mini.spec that reverts to using the included
  library sources
* Sat Jun 15 2013 schwab@linux-m68k.org
- Add glib2-devel libcroco-devel libxml2-devel to build requires to avoid
  using the included copies.
- gettext-configure.patch: Fix syntax in libxml check to avoid spurious
  failure
* Sat Jun  8 2013 christoph.miebach@web.de
- Update to version 0.18.2.1: Version 0.18.2 - December 2012
  + xgettext now understands the block comment syntax of Guile 2.0.
  + libgettextpo library:
  * The initial msgstr of a new message is now "", not NULL.
  * Bug fixes in the functions po_message_is_range,
    po_file_check_all, po_message_check_all.
  + Installation options:
    The configure options --with-xz and --with-bzip2 can be used to
    specify alternate compression methods for the archive used by
    the 'autopoint' program. These options, together with
  - -with-git, allow to trade dependencies against installed
    package size. --with-xz has the highest compression rate,
    followed by --with-git, followed by --with-bzip2.
  + Autoconf macros:
  * The autoconf macros installed by 'gettextize' now work with
    the forthcoming Automake 1.14 and require Autoconf version
    2.60 or newer.
  + Portability:
  * Building on MacOS X 10.7, Cygwin 1.7.10, and newer 64-bit
    mingw is now supported.
- Remove obsolete patches:
  + getext-stdio.in.patch
  + gettext-codecleanup.patch
* Fri May 31 2013 coolo@suse.com
- do not call autoreconf, spares you all the ugly patches:
    gettext-no_silent_rules.patch
    gettext-0.15-docdir.diff
    gettext-autotools.patch
* Wed Mar 27 2013 mmeister@suse.com
- Added url as source.
  Please see http://en.opensuse.org/SourceUrls
* Mon Sep 24 2012 pth@suse.de
- remove silent_rules from AM_INIT_AUTOMAKE to make autoreconf
  succeed on older distributions.
- Rename po-mode.diff to gettext-po-mode.diff
* Thu Sep 13 2012 coolo@suse.com
- replace ; with and in spdx.org license
* Sun Jul 22 2012 aj@suse.de
- Fix build with missing gets declaration (glibc 2.16)
* Mon Jul  2 2012 coolo@suse.com
- do not use obsolete AM_PROG_MKDIR_P
* Thu Jan 12 2012 aj@suse.de
- Disable tests test-readlink and test-areadlink since they
  fail randomly.
* Thu Jan 12 2012 aj@suse.de
- Remove cvs, not used anymore since 0.18.1 in our build.
* Sun Oct  2 2011 dmueller@suse.de
- revert last change - it is not the testsuite that hangs
  but everything. The better workaround is to disable openmp
* Sat Oct  1 2011 coolo@suse.com
- add libtool as buildrequire to make the spec file more reliable
* Sat Oct  1 2011 crrodriguez@opensuse.org
- Test suite hangs in qemu-arm due to bugs in the emulator
  workaround this issue.
* Thu Sep 29 2011 dmueller@suse.de
- fix build
* Thu Sep 29 2011 adrian@suse.de
- disable openmp when qemu is used for building (like on arm)
* Fri Jan  7 2011 meissner@suse.de
- Also add gettext-tools to baselibs.conf, wine-devel now needs
  libgettextpo.
* Tue Dec 21 2010 pth@suse.de
- Update to 0.18.1. Changes since 0.17:
  Version 0.18.1 - June 2010
  * msggrep: A '$' anchor in a regular expression now also matches
    the end of the string, even if it does not end in a newline.
  * Dependencies:
    The libraries and programs are now linked with libunistring if
    this library is already installed.
  * Installation options:
    The configure option --with-cvs is deprecated. The 'autopoint'
    program will now use the 'git' program by default to compress its
    archive.  If the configure option --without-git is specified,
    'autopoint' will not rely on 'git', but will instead rely on a
    locally installed 3 MB large archive.
  Version 0.18 - May 2010
  * PO file format:
    There is a new field 'Language' in the header entry.  It denotes
    the language code (plus optional country code) for the PO file.
    This field can be used by automated tools, such as spell
    checkers. It is expected to be more reliable than looking at the
    file name or at the 'Language-Team' field in the header entry.
    msgmerge, msgcat, msgen have a new option --lang that allows to
    specify this field. Additionally, msgmerge fills in this new
    field by looking at the 'Language-Team' field (if the --lang
    option is not given).
  * xgettext and PO file format:
    For messages with plural forms, programmers can inform the
    translators about the range of possible values of the numeric
    argument, like this:
    /* xgettext: range: 0..15 */
    This information 'range: 0..15' is stored in the PO file as a
    flag attached to the message. Translators can produce better
    translations when they know that the numeric argument is small.
  * Colorized PO files:
    msgattrib, msgcomm, msgconv, msgen, msgfilter, msggrep, msginit,
    msgmerge, msgunfmt, msguniq, xgettext now have options --color
    and --style, like msgcat has since version 0.17.
  * msgmerge is up to 10 times faster when the PO and POT files are
    large. This speedup was contributed by Ralf Wildenhues.
  * msgcmp has a new option -N/--no-fuzzy-matching, like msgmerge has
    since version 0.12.
  * msgfilter now sets environment variables during the invocation of
    the filter, indicating the msgid and location of the messge being
    processed.
  * xgettext now can extract plural forms from Qt 4 programs. The
    recommended xgettext command-line options for this case are:
  - -qt --keyword=tr:1,1t --keyword=tr:1,2c,2t --keyword=tr:1,1,2c,3t
  * xgettext --language=GCC-source now recognizes also the format
    strings used in the Fortran front-end of the GCC compiler, and
    marks them as 'gfc-internal-format'.
  * autopoint can now be used to update several PO directories all
    together.
  * PO mode changes:
  - PO files with plural entries are now correctly handled.
  - Editing a message with previous msgid (in comments) removes these
    comments.  Contributed by Noritada Kobayashi.
  * The po/Makevars file has a new field MSGMERGE_OPTIONS, that can
    be used to adjust msgmerge's operation.
  * The use of the macro AM_GNU_GETTEXT without 'external' argument
    and the --intl option of the gettextize program are deprecated
    and will be removed in the next release. Instead of including
    the intl sources in your package, we suggest making the libintl
    library an (optional) prerequisite of your package.
  * Updated the meaning of 'gcc-internal-format' to match GCC 4.3.
  * Installation options:
    The configure options --without-cvs and --with-git can be used to
    specify whether 'autopoint' will use the 'cvs' program, or the
    'git' program, or none at all. These options allow to trade
    dependencies against installed package size: If --without-cvs is
    specified and --with-git is not specified, 'autopoint' will not
    rely on 'cvs' or 'git', but will instead rely on a locally
    installed a 3 MB large archive.
  * Portability: The msgfilter program now also works on native Woe32
  - platforms. Compiled C# message catalogs now also work with
  - 'mono' versions from 2009
    or newer.
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Fri Mar  5 2010 puzel@novell.com
- remove gettext-tools/gnulib-m4/openmp.m4: fix build with new
  autoconf
* Sun Dec 13 2009 jengelh@medozas.de
- add baselibs.conf as a source
* Tue Dec  8 2009 jengelh@medozas.de
- enable parallel building
* Thu Jul 23 2009 ke@suse.de
- Synch po-mode.el with version from gettext CVS; for details, see the
  beginning of po-mode-cvs-2009-07-23.patch.
* Sat Feb  7 2009 schwab@suse.de
- Rebuild broken info file.
* Tue Jan 13 2009 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Tue Oct 14 2008 kukuk@suse.de
- Never install files in %%check section
- Disable autoconf/libtool tests
* Mon Oct 13 2008 kukuk@suse.de
- Fix autoreconf call
* Sun May 18 2008 pth@suse.de
- Fix segmentation fault in msgmerge (bnc#391372).
- Get rid of %%run_ldconfig
* Wed May  7 2008 coolo@suse.de
- provide gettext-<arch> too
* Tue Apr 29 2008 cthiel@suse.de
- obsolete gettext-<arch> via baselibs.conf
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Tue Jan 22 2008 pth@suse.de
- Define version before using it.
- Fix Provides and Obsoletes for gettext-tools
* Tue Jan 15 2008 pth@suse.de
- Update rpmlintrc.
* Tue Dec  4 2007 pth@suse.de
- Add patch from upstreams to add the missing mode for the open call.
* Fri Nov 23 2007 pth@suse.de
- Reenable msgmerge-compendium-5 now that gcc has been fixed.
- Change Provides/Obsoletes to match guidelines
- Add Comment as to when the rename happened.
* Thu Nov 15 2007 pth@suse.de
- Rename packages: gettext -> gettext-runtime and
    gettext-devel -> gettext->tools
  Packaging closely follows uptream recommendation with a few
  exceptions.
- Initialize variable to shut up gcc.
- Disable msgmerge-compendium-5 for now.
- Update to 0.17:
  * License:
  The gettext related programs and tools are now licensed under the GPL
  version 3, instead of the GPL version 2.
  * PO file format:
  The Project-Id-Version field in the header entry may now already be filled
  in the POT file. In this case, the translators don't need to fill it in.
  xgettext has new options --package-name and --package-version that allow
  to specify the package name and version from a Makefile.
  * Colorized PO files:
  The msgcat program has new options --color and --style that produce a
  colorized PO file output, where keywords, strings, comments, or format
  directives can be highlighted.  See the documentation section
  "Highlighting parts of PO files" for more info.
  * gettextize now has a --po-dir option that allows several PO directories to
  be updated all together.
  * Programming languages support:
  - Contexts (msgctxt) are now also supported for Java and C#.
  - C# with Qt: The support for Qt format strings has been updated for Qt 4.
  - C++ with KDE:
    xgettext has a new option --kde that triggers the recognition and marking
    of KDE 4 format strings.
  * Autoconf macros:
  - A new macro AM_XGETTEXT_OPTION can be used as an alternative to modifying
    po/Makevars.
  * libgettextpo library:
  - New functions are available for querying the list of supported format
    types.
  - The functions po_message_comments and po_message_extracted_comments
    return a multiline string where each line no longer starts with a
    redundant space. The leading space in every comment line is now stripped
    while reading the PO file.
  - Conversely, when you pass a multiline string to the function
    po_message_set_comments or po_message_set_extracted_comments, you normally
    don't pass a space at the beginning of each line, because such spaces are
    no longer trimmed during output.
  * Documentation:
  - The "Users" chapter has been completely rewritten.
  - New section "Highlighting parts of PO files".
  - A complete example showing the use of GNU gettext in Java with the Qt/Jambi
  GUI toolkit has been added.
- Add tcl and perl-libintl-perl to BuildRequires (testsuite needs
  them).
- Remove call to gl_AC_TYPE_LONG_LONG from libasprintf's
  configure.ac
* Mon Nov  5 2007 rguenther@suse.de
- Fix ordering of gettext.changes entries.
* Wed Oct 31 2007 mrueckert@suse.de
- renamed rpmlintrc to gettext-rpmlintrc and added it to the spec
  as source 1
* Mon Sep  3 2007 pth@suse.de
- Incorporate upstream patch that correctly fixes the expat
  dynloading code (http://savannah.gnu.org/bugs/?19585).
* Wed Aug 15 2007 coolo@suse.de
- do not set the version to 0.16.1
* Fri Aug 10 2007 bk@suse.de
- Update to gettext 0.16.1, required by GnuPG 2.0.5
* Thu Aug  9 2007 bk@suse.de
- apply the fixes from gettext-0.16.1, noticeable changes:
  * gettext.m4: changequote instead of pairs of brackets
  * add a few function protoypes and update polish translations
- extract missing ycp comments (fix from upstream maintainer, #287150)
- re-enable make check to identify possible toolchain bugs
- move java and csharp documentation to gettext-{java,csharp}
- hardlink duplicate example files in documentation
* Fri May 25 2007 ro@suse.de
- added rpmlintrc for gettext-devel (examples executable)
* Fri Apr 20 2007 pth@suse.de
- Make inclusion of expat.h independent of dynamic loading so
  that XML_MAJOR_VERSION is actually defined (#264110).
* Fri Mar 30 2007 pth@suse.de
- Fix use of uninitialized variables.
- Set CXXFLAGS to get C++ code compiled with RPM_BUILD_OPTS
- sync .spec files
* Thu Mar 29 2007 rguenther@suse.de
- Add site-lisp directories to package.
* Tue Mar 20 2007 rguenther@suse.de
- Remove unused expat BuildRequires.
* Wed Mar  7 2007 rguenther@suse.de
- Add cvs Requires to gettext-devel as autopoint requires it.
* Tue Jan 16 2007 pth@suse.de
- Update to gettext 0.16
  * Interoperability with automake-1.10.
  * msgmerge has a new option --previous that has the effect of saving the
    previous msgid of message when making them fuzzy.
  * msgcmp now ignores fuzzy and untranslated messages in the PO file.
  * gettextize, when invoked without --intl option, now installs only the .m4
    files that are needed.
  * gettextize no longer creates symbolic links by default; it makes file copies
    instead.
  * Autoconf macros:
  - The gettext autoconf macros now require autoconf 2.52 or newer.
  - New autoconf macro AM_GNU_GETTEXT_INTL_SUBDIR
  - A new autoconf macro AM_GNU_GETTEXT_NEED is added.
  * The libgettextpo library no longer exports symbols that could clash with
    symbols of the application that uses it.
* Mon Sep 18 2006 rguenther@suse.de
- Build java tools from a separate spec file gettext-java.
- Remove gcc-java and gcc-objc build dependencies.
* Tue Sep  5 2006 rguenther@suse.de
- Remove build dependency on emacs.
- Remove install dependency on libstdc++-devel for gettext-devel.
* Wed Jul 26 2006 ke@suse.de
- Version 0.15:
  * Enhance PO file format.  Messages constrained to a certain context
    are possible.  The syntax is:
    msgctxt "context"
    msgid "original"
    msgstr "translation"
    The xgettext program can be told through the --keyword flag which
    function/macro argument has the role of a context.  It also supports
    the GNOME glib convention to specify the context and original string
    in the same string literal: "context|original".
    The (non-public) include file gettext.h defines macros pgettext, dpgettext
    etc. that take a context argument.
    For more information, see the node "Contexts" in the manual.
  * msgfmt's format string checking is now stricter in the presence of plural
    forms.
  * Enhancements to msggrep, xgettext, msgmerge (much faster now!).
  * New program recode-sr-latin, that converts Serbian text from
    the Cyrillic script to the Latin script.
  * Programming languages support:
  - C++ with Boost:
  - Python: xgettext now recognizes the source encoding from a
    "coding:" comment among the first two lines.  The default encoding
    is now ASCII, no longer ISO-8859-1.
  * libgettextpo library: Incompatible change with the error handler
    type passed to functions.
- Remove strict aliasing patch which seems to be obsolete because of
  code changes.
- Require expat, but still no-op?
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Tue Jan  3 2006 sbrabec@suse.cz
- Fixed info installation scriptlets (#141183).
- Use %%doc, where appropriate.
- Moved autosprintf.info to devel subpackage.
- Move emacs-lisp files to main package.
- Fixed devel splitting and requirements.
* Mon Sep 19 2005 mmj@suse.de
- Update to 0.14.5
- Fix strict aliasing issues
* Sat Apr 16 2005 schwab@suse.de
- Move libgettextsrc-*.so and libgettextlib-*.so to main package as needed
  by msgfmt.
* Thu Apr 14 2005 kukuk@suse.de
- Move msgfmt into main package for LSB support
* Tue Apr  5 2005 mmj@suse.de
- Fix documentation packaging
* Mon Apr  4 2005 schwab@suse.de
- Remove the stupid casts.
* Mon Apr  4 2005 mmj@suse.de
- Introduce incredibly gross hack to make sure (int) casts are
  changed to (long)
- Update to gettext-0.14.3
- Move many files to the -devel package, trying to conform with
  gettext authors recommendation of split runtime/tools [#66614]
* Wed Feb  9 2005 mmj@suse.de
- Revise the tmp file race patch:
  - Make umask not so strict [#50437]
  - Use mktemp in more places
* Tue Jan 11 2005 schwab@suse.de
- Fix placement of po-mode-line-entry in mode-line-format for CVS Emacs.
* Thu Nov 25 2004 mmj@suse.de
- add fixes for tmp file races [#47724]
* Mon Oct 18 2004 ro@suse.de
- locale-rename: no -> nb
* Tue Apr 20 2004 mmj@suse.de
- Add autoreconf -fi
* Tue Mar  2 2004 mmj@suse.de
- Update to 0.14.1 [#34491] including:
  - C#: xgettext now also supports C#.
  - Bugfixes
* Sat Jan 10 2004 adrian@suse.de
- add %%run_ldconfig
* Fri Jan  9 2004 schwab@suse.de
- Fix makefiles.
* Fri Dec 19 2003 pthomas@suse.de
- Update to 0.13
  - New languages support: shell, Perl, PHP ObjectiveC,
    the special format strings used in the gcc sources and
    C++ with Qt.
  - Complete examples for all supported programing languages
    added to the documentation.
* Tue Dec  9 2003 kukuk@suse.de
- Don't build PDF docu
- Remove lots of obsolete packages from neededforbuild
* Tue Jun 17 2003 pthomas@suse.de
- Update to 0.12.1
* Thu Apr 24 2003 ro@suse.de
- fix install_info --delete call and move from preun to postun
* Thu Feb  6 2003 kukuk@suse.de
- Use install-info macros
* Thu Aug  8 2002 pthomas@suse.de
- Update to 0.11.5
  From NEWS: Bug fixes in the gettext.m4 autoconf macros.
- Remove patches obsoleted by the update and adapt those
  still needed.
* Fri Jul 26 2002 schwab@suse.de
- Fix filelist.
- Install missing m4 macros.
- Remove interaction in gettextize.
- Fix unwanted expansion in AM_PO_SUBDIRS.
* Fri Jul 26 2002 pthomas@suse.de
- Update to gettext 0.11.4
  - The tools now know about the ISO C 99 <inttypes.h> format
    string directive macros PRId64, PRIxMAX etc.
  - remove patches obsoleted by this new version
* Wed Jul 24 2002 ke@suse.de
- Remove texinfo.tex from source files and make use of texinfo.tex
  provided by the system.
- Install gettext.pdf under $RPM_BUILD_ROOT.
* Tue Jul 23 2002 schwab@suse.de
- Update to gettext 0.11.3.
- Force checking for division by zero.
* Tue Jul  9 2002 schwab@suse.de
- Fix autoload for po-mode.
* Thu Jun 13 2002 meissner@suse.de
- mark msgfmt-6 as SKIP, division by 0 is not exactly well defined.
* Tue May 21 2002 ke@suse.de
- suse-start-po-mode.el: Load po-compat if "po-find-file-coding-system"
  doesn't come with stock Emacs.
* Thu Apr 25 2002 pthomas@suse.de
- Update to 0.11.2.
  From NEWS:
  - Bug fixes in the gettext.m4 autoconf macros.
  - New documentation section: Preparing Translatable Strings.
  - xgettext now also supports Python, Tcl, Awk and Glade.
  - msgfmt can create (and msgunfmt can dump) Tcl message catalogs.
  - msggrep has a new option -C that allows to search for strings
    in translator comments.
- Run gettext testsuite.
* Wed Apr  3 2002 schwab@suse.de
- Move suse-start-po-mode.el here from po-utils.
- Remove ia64 workaround.
* Thu Mar 28 2002 pthomas@suse.de
- Use %%{_libdir}
* Mon Feb 18 2002 pthomas@suse.de
- Update %%files.
* Mon Feb  4 2002 pthomas@suse.de
- Update to 0.11
  This is a major update with lots of new features and new tools.
- Integrate a patch from Bruno Haible to make libtool regard
  DESTDIR when installing.
- Don't use the included libintl but rather the one in libc.
- Build dynamically linked binaries.
- Added the current texinfo.tex as otherwise gettext.pdf won't build.
* Fri Feb  1 2002 ro@suse.de
- changed neededforbuild <libpng> to <libpng-devel-packages>
* Wed Oct 31 2001 kukuk@suse.de
- Include manual pages
* Tue Oct 30 2001 kukuk@suse.de
- Update to 0.10.40
* Mon Aug 27 2001 ke@suse.de
- Update German translation from UMontreal Translation Project.
- Make sure to compile and install 'po-mode'.
* Fri May 11 2001 pthomas@suse.de
- Update to 0.10.37.
  Remove manual.diff as most of the fixes have been incorporated.
* Wed May  9 2001 cstein@suse.de
- repacked sources with bzip2
* Thu Apr 12 2001 pthomas@suse.de
- Don't list directories shared with other packages in
  spec file.
* Mon Apr  9 2001 pthomas@suse.de
- Update to 0.10.36
- Drop msghack patch
- Improve gettext manual ( hopefully :)
- Now provides po-mode.el
* Thu Mar  8 2001 ke@suse.de
- Use more rpm macros.
- Build and install a printable manual (PDF).
* Fri Mar  2 2001 schwab@suse.de
- Compile with -O1 on ia64 to work around compiler bug.
* Tue Sep 19 2000 pthomas@suse.de
- add patch from Bruno Haible. This allows statically linking
  programs with libintl.a on glibc systems.
* Tue Jun 20 2000 pthomas@suse.de
- xgettext.c: format YCP automatically set for .ycp extension
- gettext.spec: allow building on systems where gettext.m4 etc.
  are installed.
* Thu Jun 15 2000 pthomas@suse.de
- add patches from Paul Eggert needed for NLS in gcc
- add patch from Martin v. Loewis to allow searching
  inside of #define
* Fri May  5 2000 kukuk@suse.de
- Fix Bug 2812
- Add DESTDIR to intl/Makefile.in and po/Makefile.in.in
- Use BuildRoot
* Mon May  1 2000 ke@suse.de
- Add msghack from RH's package: gettext-0.10.35-hacks.patch
* Wed Apr 26 2000 kukuk@suse.de
- Fix configure call (add %%{_target_cpu} macro)
* Thu Apr  6 2000 bk@suse.de
- replace config.{guess,sub} against config update macro for s390
* Thu Feb  3 2000 schwab@suse.de
- Update config.{guess,sub} to latest version.
* Fri Jan 28 2000 schwab@suse.de
- Do not even try to install po-mode.el.
* Tue Jan 25 2000 kukuk@suse.de
- Fix permissions of locale dirs.
- Move /usr/info -> /usr/share/info.
- Remove po-mode, now in extra package.
* Mon Dec 13 1999 schwab@suse.de
- Remove libintl.a from file list, everything is in libc.
* Tue Nov 30 1999 schwab@suse.de
- Add format checking for YCP strings.
- Don't declare getline and getdelim.
* Sat Nov 13 1999 kukuk@suse.de
- Clean up spec file and old, obsolete patches
* Fri Oct 15 1999 aj@suse.de
- Handle \v.
* Tue Oct 12 1999 kettner@suse.de
- patched for use with YaST2 YCP scripts, new option
  - -language=YCP
* Sat Oct  9 1999 ro@suse.de
- fixed to build on any arch
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Sun Aug 15 1999 ke@suse.de
- update po-mode.el.
* Thu Mar 11 1999 kukuk@suse.de
- don't link against libintl.a on glibc systems
* Sun Feb 14 1999 ke@suse.de
- update po-mode.el.
* Thu Jan  7 1999 ro@suse.de
- respect alpha in specfile
* Thu Jan  7 1999 ro@suse.de
- don't redeclare getline
* Mon Dec  7 1998 florian@suse.de
- update to gettext 0.10.35
* Mon Dec  7 1998 bs@suse.de
- added locale.alias to file list for libc5 systems.
* Thu Nov 26 1998 bs@suse.de
- skipped /usr/share/locale/locale.alias from file list (is in localedb)
* Fri Sep 11 1998 ro@suse.de
- switch detection of GLIBC to automake
* Thu Aug 13 1998 bs@suse.de
- added export LC_CTYPE to build an install section in spec file.
* Wed Aug 12 1998 ke@suse.de
- new po-mode.el from
  http://www.iro.umontreal.ca/contrib/po/po-mode/po-mode.el
- and install po-mode.el.
* Fri Jun 19 1998 ro@suse.de
- dirty hack should at least work now
* Fri Jun 19 1998 bs@suse.de
- don't include libintl.h if glibc is used.
  did it with a dirty hack.  Will be done better in a while.
* Mon Mar  9 1998 ro@suse.de
- added some documentation
* Thu Feb  5 1998 florian@suse.de
- add missing m4 macro files in /usr/share/aclocal
* Fri Oct 10 1997 florian@suse.de
- update to version 0.10.32
* Wed Jan 22 1997 florian@suse.de
- update to version 0.10.26
