#
# spec file for package libnettle
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define soname 8
%define hogweed_soname 6
Name:           libnettle
Version:        3.9.1
Release:        150600.3.2.1
Summary:        Cryptographic Library
License:        GPL-2.0-or-later AND LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
URL:            https://www.lysator.liu.se/~nisse/nettle/
Source0:        https://ftp.gnu.org/gnu/nettle/nettle-%{version}.tar.gz
Source1:        https://ftp.gnu.org/gnu/nettle/nettle-%{version}.tar.gz.sig
Source2:        %{name}.keyring
Source3:        baselibs.conf
Source4:        %{name}-rpmlintrc
BuildRequires:  autoconf
BuildRequires:  fipscheck
BuildRequires:  gmp-devel >= 6.1.0
BuildRequires:  m4
BuildRequires:  makeinfo
BuildRequires:  pkgconfig
%{?suse_build_hwcaps_libs}

%description
Nettle is a cryptographic library that is designed to fit easily in more or
less any context: In crypto toolkits for object-oriented languages (C++,
Python, Pike, ...), in applications like LSH or GNUPG, or even in kernel space.

%package -n libnettle%{soname}
Summary:        Cryptographic Library
License:        LGPL-2.1-or-later
Group:          System/Libraries

%description -n libnettle%{soname}
Nettle is a cryptographic library that is designed to fit easily in more or
less any context: In crypto toolkits for object-oriented languages (C++,
Python, Pike, ...), in applications like LSH or GNUPG, or even in kernel space.

%package -n libhogweed%{hogweed_soname}
Summary:        Cryptographic Library for Public Key Algorithms
License:        LGPL-2.1-or-later
Group:          System/Libraries

%description -n libhogweed%{hogweed_soname}
Nettle is a cryptographic library that is designed to fit easily in more or
less any context: In crypto toolkits for object-oriented languages (C++,
Python, Pike, ...), in applications like LSH or GNUPG, or even in kernel space.

The libhogweed library contains public key algorithms to use with libnettle.

%package -n libnettle-devel
Summary:        Cryptographic Library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       glibc-devel
Requires:       gmp-devel
Requires:       libhogweed%{hogweed_soname} = %{version}
Requires:       libnettle%{soname} = %{version}

%description -n libnettle-devel
Nettle is a cryptographic library that is designed to fit easily in more or
less any context: In crypto toolkits for object-oriented languages (C++,
Python, Pike, ...), in applications like LSH or GNUPG, or even in kernel space.

%package -n nettle
Summary:        Cryptographic Tools
License:        GPL-2.0-or-later AND LGPL-2.1-or-later
Group:          Productivity/Security

%description -n nettle
Nettle is a cryptographic library that is designed to fit easily in more or
less any context: In crypto toolkits for object-oriented languages (C++,
Python, Pike, ...), in applications like LSH or GNUPG, or even in kernel space.

This package contains a few command-line tools to perform cryptographic
operations using the nettle library.

%prep
%autosetup -p1 -n nettle-%{version}

%build
autoreconf -fiv
%configure \
    --disable-static \
    --enable-shared \
    --enable-fat \
%ifarch s390x
    --enable-s390x-vf \
    --enable-s390x-msa \
%endif
    %{nil}

%make_build

%install
%make_install
chmod 0755 %{buildroot}%{_libdir}/libnettle.so.%{soname}
chmod 0755 %{buildroot}%{_libdir}/libhogweed.so.%{hogweed_soname}

for arch in x86_64 s390x powerpc64 arm arm64 ; do
    cp ${arch}/README ${arch}.README
done

# the hmac hashes:
#
# this is a hack that re-defines the __os_install_post macro
# for a simple reason: the macro strips the binaries and thereby
# invalidates a HMAC that may have been created earlier.
# solution: create the hashes _after_ the macro runs.
#
# this shows up earlier because otherwise the %%expand of
# the macro is too late.
# remark: This is the same as running
#   openssl dgst -sha256 -hmac 'orboDeJITITejsirpADONivirpUkvarP'
%{expand:%%global __os_install_post {%__os_install_post
%{_bindir}/fipshmac %{buildroot}%{_libdir}/libnettle.so.%{soname}
%{_bindir}/fipshmac %{buildroot}%{_libdir}/libhogweed.so.%{hogweed_soname}
}}

%post   -n libnettle%{soname} -p /sbin/ldconfig
%postun -n libnettle%{soname} -p /sbin/ldconfig
%post   -n libhogweed%{hogweed_soname} -p /sbin/ldconfig
%postun -n libhogweed%{hogweed_soname} -p /sbin/ldconfig

%check
%make_build check

%files -n libnettle%{soname}
%license COPYING*
%{_libdir}/libnettle.so.%{soname}
%{_libdir}/libnettle.so.%{soname}.*
%{_libdir}/.libnettle.so.%{soname}.hmac

%files -n libhogweed%{hogweed_soname}
%license COPYING*
%{_libdir}/libhogweed.so.%{hogweed_soname}
%{_libdir}/libhogweed.so.%{hogweed_soname}.*
%{_libdir}/.libhogweed.so.%{hogweed_soname}.hmac

%files -n libnettle-devel
%license COPYING*
%doc AUTHORS ChangeLog NEWS README *.README nettle.html nettle.pdf
%{_includedir}/nettle
%{_libdir}/libnettle.so
%{_libdir}/libhogweed.so
%{_infodir}/nettle.info%{?ext_info}
%{_libdir}/pkgconfig/hogweed.pc
%{_libdir}/pkgconfig/nettle.pc

%files -n nettle
%license COPYING*
%doc AUTHORS ChangeLog NEWS README
%{_bindir}/nettle-lfib-stream
%{_bindir}/nettle-pbkdf2
%{_bindir}/pkcs1-conv
%{_bindir}/sexp-conv
%{_bindir}/nettle-hash

%changelog
* Fri Jun  9 2023 pmonreal@suse.com
- Add the architecture specific READMEs as provided by upstream.
* Thu Jun  8 2023 pmonreal@suse.com
- Include the nettle library manual in HTML and PDF formats in
  the devel package.
* Wed Jun  7 2023 andreas.stieger@gmx.de
- update to 3.9.1: [bsc#1212112, CVE-2023-36660]
  * Fix bug in the new OCB code may be exploitable for denial of
    service or worse due to memory corruption
* Mon May 15 2023 andreas.stieger@gmx.de
- update to 3.9
  * rewrite of the C and plain x86_64 assembly implementations of
    GHASH to use precomputed tables in a different way, with tables
    always accessed in the same sequential manner. This should make
    Nettle's GHASH implementation side-channel silent on all
    platforms, but considerably slower on platforms without carry-
    less mul instructions. E.g., benchmarks of the C implementation
    on x86_64 showed a slowdown of 3 times.
  * Fix bug in ecdsa and gostdsa signature verify operation, for
    the unlikely corner case that point addition really is point
    duplication.
  * Fix for chacha on Power7, nettle's assembly used an instruction
    only available on later processors
  * Add support for the SM4 block cipher
  * Add support for the Balloon password hash
  * Add support for SIV-GCM authenticated encryption mode
  * Add support for OCB authenticated encryption mode.
  * New exported functions md5_compress, sha1_compress,
    sha256_compress, sha512_compress
  * multiple performance optimizations
  * Delete all arcfour assembly code. Affects 32-bit x86, 32-bit
    and 64-bit sparc
* Wed Mar  8 2023 mpluskal@suse.com
- Build AVX2 enabled hwcaps library for x86_64-v3
* Thu Jul 28 2022 dmueller@suse.com
- update to 3.8.1:
  * Avoid non-posix m4 argument references in the chacha
    implementation for arm64, powerpc64 and s390x. Reported by
    Christian Weisgerber, fix contributed by Mamone Tarsha.
  * Use explicit .machine pseudo-ops where needed in s390x
    assembly files. Bug report by Andreas K. Huettel, fix
    contributed by Mamone Tarsha.
* Mon Jul 11 2022 dmueller@suse.com
- update to 3.8:
  This release includes a couple of new features, and many
  performance improvements. It adds assembly code for two more
  architectures: ARM64 and S390x.
  The new version is intended to be fully source and binary
  compatible with Nettle-3.6. The shared library names are
  libnettle.so.8.5 and libhogweed.so.6.5, with sonames
  libnettle.so.8 and libhogweed.so.6.
  New features:
  * AES keywrap (RFC 3394), contributed by Nicolas Mora.
  * SM3 hash function, contributed by Tianjia Zhang.
  * New functions cbc_aes128_encrypt, cbc_aes192_encrypt,
    cbc_aes256_encrypt.
    On processors where AES is fast enough, e.g., x86_64 with
    aesni instructions, the overhead of using Nettle's general
    cbc_encrypt can be significant. The new functions can be
    implemented in assembly, to do multiple blocks with reduced
    per-block overhead.
    Note that there's no corresponding new decrypt functions,
    since the general cbc_decrypt doesn't suffer from the same
    performance problem.
  Bug fixes:
  * Fix fat builds for x86_64 windows, these appear to never
    have worked.
  Optimizations:
  * New ARM64 implementation of AES, GCM, Chacha, SHA1 and
    SHA256, for processors supporting crypto extensions. Great
    speedups, and fat builds are supported. Contributed by
    Mamone Tarsha.
  * New s390x implementation of AES, GCM, Chacha, memxor, SHA1,
    SHA256, SHA512 and SHA3. Great speedups, and fat builds are
    supported. Contributed by Mamone Tarsha.
  * New PPC64 assembly for ecc modulo/redc operations,
    contributed by Amitay Isaacs, Martin Schwenke and Alastair
    D´Silva.
  * The x86_64 AES implementation using aesni instructions has
    been reorganized with one separate function per key size,
    each interleaving the processing of two blocks at a time
    (when the caller processes multiple blocks with each call).
    This gives a modest performance improvement on some
    processors.
  * Rewritten and faster x86_64 poly1305 assembly.
- drop libnettle-s390x-CPACF-SHA-AES-support.patch (included in 3.8)
* Wed Jun 15 2022 gmbr3@opensuse.org
- Make shared libraries executable
* Mon Jan 17 2022 pmonreal@suse.com
- Provide s390x CPACF/SHA/AES Support for Crypto Libraries
  * Add libnettle-s390x-CPACF-SHA-AES-support.patch [jsc#SLE-20733]
* Wed Jun  9 2021 info@paolostivanin.com
- GNU Nettle 3.7.3: [CVE-2021-3580, bsc#1187060]
  * Fix crash for zero input to rsa_sec_decrypt and
    rsa_decrypt_tr. Potential denial of service vector.
  * Ensure that all of rsa_decrypt_tr and rsa_sec_decrypt return
    failure for out of range inputs, instead of either crashing,
    or silently reducing input modulo n. Potential denial of
    service vector.
  * Ensure that rsa_decrypt returns failure for out of range
    inputs, instead of silently reducing input modulo n.
  * Ensure that rsa_sec_decrypt returns failure if the message
    size is too large for the given key. Unlike the other bugs,
    this would typically be triggered by invalid local
    configuration, rather than by processing untrusted remote
    data.
* Sun Mar 21 2021 andreas.stieger@gmx.de
- GNU Nettle 3.7.2:
  * fix a bug in ECDSA signature verification that could lead to a
    denial of service attack (via an assertion failure) or possibly
    incorrect results (CVE-2021-20305, boo#1184401)
  * fix a few related problems where scalars are required to be
    canonically reduced modulo the ECC group order, but in fact may
    be slightly larger
* Thu Feb 18 2021 andreas.stieger@gmx.de
- GNU Nettle 3.7.1:
  * Fix bug in chacha counter update logic (ppc64 and ppc64el)
  * Restore support for big-endian ARM platforms
  * Fix corner case bug in ECDSA verify, it would produce incorrect
    result in the unlikely case of an all-zero message hash
  * Support for pbkdf2_hmac_sha384 and pbkdf2_hmac_sha512
  * Remove poorly performing ARM Neon code for doing single-block
    Salsa20 and Chacha
* Mon Jan  4 2021 andreas.stieger@gmx.de
- GNU Nettle 3.7:
  * add bcrypt password hashing
  * add optimizations: PowerPC64 assembly
- remove deprecated texinfo packaing macros
* Sun May 10 2020 andreas.stieger@gmx.de
- GNU Nettle 3.6:
  * removal of internal and undocumented poly1305 functions
  * Support for Curve448 and ED448 signatures
  * Support for SHAKE256, SIV-CMAC, CMAC64, "CryptoPro" variant of
    the GOST hash (as gosthash94cp), GOST DSA signatures, including
    GOST curves gc256b and gc512a
  * Support for Intel CET in x86 and x86_64 assembly files, if
    enabled via CFLAGS (gcc --fcf-protection=full)
  * A few new functions to improve support for the Chacha
    variant with 96-bit nonce and 32-bit block counter (the
    existing functions use nonce and counter of 64-bit each),
    and functions to set the counter.
  * New interface, struct nettle_mac, for MAC (message
    authentication code) algorithms. This abstraction is only
    for MACs that don't require a per-message nonce. For HMAC,
    the key size is fixed, and equal the digest size of the
    underlying hash function
  * multiple bug fixes
- drop nettle-respect-cflags.patch
- silence packaging warning raised by HMAC files
  (bsc#1152692, jsc#SLE-9518)
* Tue Oct  1 2019 vcizek@suse.com
- Install checksums for binary integrity verification which are
  required when running in FIPS mode (bsc#1152692, jsc#SLE-9518)
* Thu Aug  1 2019 andreas.stieger@gmx.de
- update to 3.5.1:
  * correct upstream source packaging problems
- new in 3.5:
  * gcm_crypt will now call the underlying block cipher to process
    more than one block at a time
  * Support for CFB8 (Cipher Feedback Mode, processing a single
    octet per block cipher operation)
  * Support for CMAC (RFC 4493)
  * Support for XTS mode
  * various improvements
* Wed Jan  2 2019 vcizek@suse.com
- Update to 3.4.1 release
  * Fix CVE-2018-16869 (bsc#1118086)
    All functions using RSA private keys are now side-channel
    silent, meaning that they try hard to avoid any branches or
    memory accesses depending on secret data. This applies both to
    the bignum calculations, which now use GMP's mpn_sec_* family
    of functions, and the processing of PKCS#1 padding needed for
    RSA decryption.
  * Changes in behavior:
    The functions rsa_decrypt and rsa_decrypt_tr may now clobber
    all of the provided message buffer, independent of the
    actual message length. They are side-channel silent, in that
    branches and memory accesses don't depend on the validity or
    length of the message. Side-channel leakage from the
    caller's use of length and return value may still provide an
    oracle useable for a Bleichenbacher-style chosen ciphertext
    attack. Which is why the new function rsa_sec_decrypt is
    recommended.
  * New features:
    A new function rsa_sec_decrypt.
  * Bug fixes:
  - Fix bug in pkcs1-conv, missing break statements in the
    parsing of PEM input files.
  - Fix link error on the pss-mgf1-test test, affecting builds
    without public key support.
* Thu Dec  6 2018 jengelh@inai.de
- Adjust SRPM group.
* Tue Dec  4 2018 pmonrealgonzalez@suse.com
- libnettle 3.4.1rc1: [bsc#1118086, CVE-2018-16869]
  * pkcs1-decrypt.c (pkcs1_decrypt): Rewrite as a wrapper around
    _pkcs1_sec_decrypt_variable. Improves side-channel silence of the
    only caller, rsa_decrypt.
  * rsa-sec-compute-root.c (sec_mul, sec_mod_mul, sec_powm): New
    local helper functions, with their own itch functions.
    (_rsa_sec_compute_root_itch, _rsa_sec_compute_root): Rewrote to
    use helpers, for clarity.
  * rsa-decrypt-tr.c (rsa_decrypt_tr): Use NETTLE_OCTET_SIZE_TO_LIMB_SIZE.
  * rsa-sec-compute-root.c (_rsa_sec_compute_root): Avoid calls to
    mpz_sizeinbase, since that potentially leaks most significant bits
    of private key parameters a and b.
  * rsa-sign.c (rsa_compute_root) [!NETTLE_USE_MINI_GMP]: Use
    _rsa_sec_compute_root.
  * testsuite/rsa-sec-compute-root-test.c: Add more tests for new
    side-channel silent functions.
  * rsa-sign.c (rsa_private_key_prepare): Check that qn + cn >= pn,
    since that is required for one of the GMP calls in
    _rsa_sec_compute_root.
  * rsa-decrypt-tr.c: Switch to use side-channel silent functions.
  * pkcs1-sec-decrypt.c (_pkcs1_sec_decrypt_variable): New private
    function. Variable size version for backwards compatibility.
  * testsuite/rsa-sec-decrypt-test.c: Adds more tests.
  * rsa-sec-decrypt.c (rsa_sec_decrypt): New function.
    Fixed length side-channel silent version of rsa-decrypt.
  * testsuite/rsa-encrypt-test.c: add tests for the new fucntion.
  * testsuite/pkcs1-sec-decrypt-test.c: Adds tests for _pkcs1_sec_decrypt.
  * gmp-glue.c (mpn_get_base256): New function.
  * pkcs1-sec-decrypt.c (_pkcs1_sec_decrypt): New private function.
    Fixed length side-channel silent version of pkcs1-decrypt.
  * cnd-memcpy.c (cnd_memcpy): New function.
  * testsuite/cnd-memcpy-test.c: New test case.
  * rsa-sign-tr.c (rsa_sec_compute_root_tr): New function that uses
    _rsa_sec_compute_root, as well as side-channel silent RSA blinding.
    (rsa_compute_root_tr) Rewritten as a wrapper around	rsa_sec_compute_root_tr.
    (rsa_sec_blind, rsa_sec_unblind, sec_equal, rsa_sec_check_root)
    (cnd_mpn_zero): New helper functions.
    (rsa_sec_compute_root_tr) [NETTLE_USE_MINI_GMP]: Defined as a not
    side-channel silent wrapper around rsa_compute_root_tr, and the
    latter function left unchanged.
  * rsa-sec-compute-root.c (_rsa_sec_compute_root_itch)
    (_rsa_sec_compute_root): New file, new private functions.
    Side-channel silent version of rsa_compute_root.
  * rsa-internal.h: New header file with declarations.
  * gmp-glue.h (NETTLE_OCTET_SIZE_TO_LIMB_SIZE): New macro.
  * tools/pkcs1-conv.c (convert_file): Add missing break statements.
  * nettle-internal.c (des_set_key_wrapper, des3_set_key_wrapper)
    (blowfish128_set_key_wrapper): Wrapper functions, to avoid cast
    between incompatible function types (which gcc-8 warns about).
    Wrappers are expected to compile to a single jmp instruction.
  * des-compat.c (des_compat_des3_decrypt): Change length argument type to size_t.
* Thu Feb 22 2018 fvogt@suse.com
- Use %%license (boo#1082318)
* Sun Nov 19 2017 astieger@suse.com
- libnettle 3.4:
  * Fixed an improper use of GMP mpn_mul, breaking curve2559 and
    eddsa on certain platforms
  * Fixed memory leak when handling invalid signatures in
    ecdsa_verify. Fix contributed by Nikos Mavrogiannopoulos.
  * Reorganized the way certain data items are made available:
    Nettle header files now define the symbols
    nettle_hashes, nettle_ciphers, and nettle_aeads, as
    preprocessor macros invoking a corresponding accessor
    function. For backwards ABI compatibility, the symbols are
    still present in the compiled libraries, and with the same
    sizes as in nettle-3.3.
  * Support for RSA-PSS signatures
  * Support for the HKDF key derivation function, defined by RFC
    5869
  * Support for the Cipher Feedback Mode (CFB)
  * New accessor functions: nettle_get_hashes,
    nettle_get_ciphers, nettle_get_aeads, nettle_get_secp_192r1,
    nettle_get_secp_224r1, nettle_get_secp_256r1,
    nettle_get_secp_384r1, nettle_get_secp_521r1.
    Direct access to data items is deprecated going forward.
  * The base16 and base64 functions now use the type char * for
    ascii data, rather than uint8_t *. This eliminates the last
    pointer-signedness warnings when building Nettle
  * The contents of the header file nettle/version.h is now
    architecture independent, except in --enable-mini-gmp
  * Prevent data sizes from leaking into the ABI
- Fixes previously carried as patches:
  * Fix compilation error with --enable-fat om ARM
    Drop nettle-3.3-fix-fat-arm.patch
* Mon Sep  4 2017 asn@cryptomilk.org
- Add patch to fix build of fat-arm:
  * nettle-3.3-fix-fat-arm.patch
* Sun Sep  3 2017 asn@cryptomilk.org
- Build nettle with AES-NI support (bsc#1056980)
* Thu Feb  9 2017 dimstar@opensuse.org
- Explicitly BuildRequire m4
* Fri Oct 28 2016 astieger@suse.com
- libnettle 3.3:
  * Invalid private RSA keys, with an even modulo, are now
    rejected by rsa_private_key_prepare. (Earlier versions
    allowed such keys, even if results of using them were bogus).
    Nettle applications are required to call
    rsa_private_key_prepare and check the return value, before
    using any other RSA private key functions; failing to do so
    may result in crashes for invalid private keys.
  * Ignore bit 255 of the x coordinate of the input point to
    curve25519_mul, as required by RFC 7748. To differentiate at
    compile time, curve25519.h defines the constant
    NETTLE_CURVE25519_RFC7748.
  * RSA and DSA now use side-channel silent modular
    exponentiation, to defend against attacks on the private key
    from evil processes sharing the same processor cache. This
    attack scenario is of particular relevance when running an
    HTTPS server on a virtual machine, where you don't know who
    you share the cache hardware with.
    bsc#991464 CVE-2016-6489
  * Fix sexp-conv crashes on invalid input
  * Fix out-of-bounds read in des_weak_p
  * Fix a couple of formally undefined shift operations
  * Fix compilation with c89
  * New function memeql_sec, for side-channel silent comparison
    of two memory areas.
  * Building the public key support of nettle now requires GMP
    version 5.0 or later (unless --enable-mini-gmp is used).
* Tue Feb 23 2016 tchvatal@suse.com
- Fix postun->preun on info packages regenerating
* Thu Jan 28 2016 tchvatal@suse.com
- Version update to 3.2 release bnc#964849 CVE-2015-8805 bnc#964847
  CVE-2015-8804 bnc#964845 CVE-2015-8803:
  * New functions for RSA private key operations, identified by
    the "_tr" suffix, with better resistance to side channel
    attacks and to hardware or software failures which could
    break the CRT optimization
  * SHA3 implementation is updated according to the FIPS 202 standard
  * New ARM Neon implementation of the chacha stream cipher
  * Should be compatible binary with 3.1 series
- Add patch to fix build with cflags:
  * nettle-respect-cflags.patch
* Mon Jun 22 2015 tchvatal@suse.com
- Remove off-by-one-test-suite.patch as it was fixed by upstream
  differently
* Sun Apr 26 2015 astieger@suse.com
- nettle 3.1.1
  Non-critical bugfix release, binary compatible to 3.1
  * By accident, nettle-3.1 disabled the assembly code for the
    secp_224r1 and secp_521r1 elliptic curves on all x86_64
    configurations, making signature operations on those curves
    10%%-30%% slower. This code is now re-enabled.
  * The x86_64 assembly implementation of gcm hashing has been
    fixed to work with the Sun/Oracle assembler.
* Thu Apr 23 2015 vpereira@suse.com
  added patch: off-by-one-test-suite.patch
- Address Sanitizer, found a off-by-one error in the test suite (bnc#928328)
* Sat Apr 11 2015 astieger@suse.com
- nettle 3.1 (libnettle6, libhogweed4)
- bug fixes in 3.1:
  * Fixed a missing include of <limits.h>, which made the camellia
    implementation fail on all 64-bit non-x86 platforms.
  * Eliminate out-of-bounds reads in the C implementation of memxor
  (related to valgrind's --partial-loads-ok flag). [bso#926745)
- interface changes in 3.1:
  * Declarations of many internal functions are moved from ecc.h to
    ecc-internal.h.
- interface changes in 3.0:
  * contains developer relevant incompatible interface changes
- Removed features:
  * nettle_next_prime, use GMP's mpz_nextprime
  * Deleted the RSAREF compatibility
- New features in 3.1:
  * Support for curve25519 and for EdDSA25519 signatures.
  * Support for "fat builds" on x86_64 and arm (not enabled)
  * Support for building the hogweed library (public key support)
    using "mini-gmp" (not enabled)
  * The shared libraries are now built with versioned symbols.
  * Support for "URL-safe" base64 encoding and decoding
- New features in 3.0:
  * new DSA, AES, Camellia interfaces
  * Support for Poly1305-AES MAC.
  * Support for the ChaCha stream cipher and EXPERIMENTAL
    support for the ChaCha-Poly1305 AEAD mode.
  * Support for EAX mode.
  * Support for CCM mode.
  * Additional variants of SHA512 with output size of 224 and 256 bits
  * New interface, struct nettle_aead, for mechanisms providing
    authenticated encryption with associated data (AEAD).
  * DSA: Support a wider range for the size of q and a wider
    range for the digest size.
  * New command line tool nettle-pbkdf2.
- Optimizations in 3.1:
  * New x86_64 implementation of AES, using the "aesni" instructions
- Optimizations in 3.0:
  * New x86_64 assembly for GCM and MD5. Modest speedups on the
    order of 10%%-20%%.
* Fri Mar 13 2015 tchvatal@suse.com
- Add url to the spec
* Thu Mar  5 2015 mpluskal@suse.com
- Revert back to 2.7
* Tue May 13 2014 tchvatal@suse.com
- Cleanup with spec-cleaner
- Paralelize test run
* Thu Dec 19 2013 meissner@suse.com
- also build baselibs for libnettle-devel (for wine 32bit development)
* Tue Jun 25 2013 meissner@suse.com
- Update to version 2.7.1
  * Fixed ecc_modp_mul call, to avoid invalid overlap of arguments to
    mpn_mul_n. Problem tracked down by Magnus Holmgren.
  * ARM fixes.
- reference gpg signatures and keyring. checking not enabled as to
  avoid cycles.
* Thu May 16 2013 idonmez@suse.com
- Update to version 2.7
  * Support for the GOST R 34.11-94 hash algorithm
  * Support for SHA3
  * Support for PKCS #5 PBKDF2
  * Fixed a small memory leak in nettle_realloc and
    nettle_xrealloc.
  * x86_64 assembly for SHA256, SHA512, and SHA3
  * ARM assembly code for several additional algorithms,
    including AES, Salsa20, and the SHA family of hash
    functions.
  * Support for 12-round salsa20, "salsa20r12", as specified by
    eSTREAM.
  * Support for UMAC, including x86_64 and ARM assembly.
  * Support for ECDSA signatures. Elliptic curve operations over
    the following curves: secp192r1, secp224r1, secp256r1,
    secp384r1 and secp521r1, including x86_64 and ARM assembly
    for the most important primitives.
- Depend on makeinfo for info file generation.
- Don't disable static libs, they are needed at build time.
* Sun Nov 25 2012 andreas.stieger@gmx.de
- upgrade to 2.5:
  * removed some internal undocumented functions
  * pkcs1_signature_prefix renamed to _pkcs1_signature_prefix
    with slightly different behavior
  * nettle-internal.c is no longer included
  * Support for the salsa20 block cipher
  * Tentative interface for timing-resistant RSA functions
  * A more general interface for PKCS#1 signatures
  * Documentation, example programs for the base16 and base64
  * Use an additional table to avoid GF2^8 multiplications in
    aes_invert_key (mainly used by aes_set_decrypt_key). Also
    tabulate round constants in aes_set_encrypt_key.
- configure --enable-shared now default, no longer required
* Tue Jan 31 2012 jengelh@medozas.de
- Remove redundant tags/sections per specfile guideline suggestions
* Sat Sep 24 2011 crrodriguez@opensuse.org
- BuildRequire pkgconfig to fix rpmlint warning
* Mon Sep 19 2011 crrodriguez@opensuse.org
- Update to version 2.4 only two important changes
  * ripemd160 was broken on all big endian machines
  * add pkgconfig files
* Mon Aug 29 2011 coolo@novell.com
- use original source
- add baselibs.conf
- drop licenses
* Wed Aug 17 2011 crrodriguez@opensuse.org
- Fix licenses [bnc#712616]
- run make check
* Tue Aug 16 2011 crrodriguez@opensuse.org
- Update to version 2.2, bump sonames accordingly
- Fix build in factory
- Fix -devel package dependencies
- Tune up spec file in order to submit package to factory
  as is needed for gnutls version 3.x
* Tue Jan  5 2010 pascal.bleser@opensuse.org
- initial package (2.0)
