#
# spec file for package dmidecode
#
# Copyright (c) 2019 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


Name:           dmidecode
Version:        3.6
Release:        150400.16.11.2
Summary:        DMI table decoder
License:        GPL-2.0-or-later
Group:          System/Console
Url:            http://www.nongnu.org/dmidecode/
Source0:        http://download.savannah.gnu.org/releases/%{name}/%{name}-%{version}.tar.xz
Source1:        http://download.savannah.gnu.org/releases/%{name}/%{name}-%{version}.tar.xz.sig
# https://savannah.nongnu.org/project/memberlist-gpgkeys.php?group=dmidecode
Source2:        %{name}.keyring
Patch1:         dmioem-update-hpe-oem-type-238.patch
Provides:       pmtools:%{_sbindir}/dmidecode
Obsoletes:      pmtools < 20071117
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:  xz
ExclusiveArch:  %ix86 ia64 x86_64 %arm aarch64

%description
Dmidecode reports information about your system's hardware as described
in your system BIOS according to the SMBIOS/DMI standard. This
information typically includes system manufacturer, model name, serial
number, BIOS version, asset tag as well as a lot of other details of
varying level of interest and reliability depending on the
manufacturer. This will often include usage status for the CPU sockets,
expansion slots (e.g. AGP, PCI, ISA) and memory module slots, and the
list of I/O ports (e.g. serial, parallel, USB).

Beware that DMI data have proven to be too unreliable to be blindly
trusted. Dmidecode does not scan your hardware, it only reports what
the BIOS told it to.

%prep
%setup -q
%patch1 -p1

%build
make CFLAGS="%{optflags}" %{?_smp_mflags}

%install
install -dm 755 %{buildroot}%{_sbindir}
install -dm 755 %{buildroot}%{_mandir}/man8
install -dm 755 %{buildroot}%{_docdir}/%{name}
install -dm 755 %{buildroot}%{_datadir}/bash-completion/completions/
%ifarch ia64 %arm aarch64
for i in dmidecode ; do
%else
for i in dmidecode vpddecode ownership biosdecode ; do
%endif
install -m 755 $i %{buildroot}%{_sbindir}/
install -m 644 man/$i.8 %{buildroot}%{_mandir}/man8/
install -m 644 completion/$i.bash %{buildroot}%{_datadir}/bash-completion/completions/$i
done

%files
%defattr(-,root,root)
%{_sbindir}/*
%dir %{_docdir}/%{name}
%doc AUTHORS NEWS README
%{_mandir}/man8/*
%{_datadir}/bash-completion/completions/*
%license LICENSE

%changelog
* Fri Jul 19 2024 jdelvare@suse.de
- Update to upstream version 3.6 (jsc#PED-8574):
  * Support for SMBIOS 3.6.0. This includes new memory device types, new
    processor upgrades, and Loongarch support.
  * Support for SMBIOS 3.7.0. This includes new port types, new processor
    upgrades, new slot characteristics and new fields for memory modules.
  * Add bash completion.
  * Decode HPE OEM records 197, 216, 224, 230, 238, 239, 242 and 245.
  * Implement options --list-strings and --list-types.
  * Update HPE OEM records 203, 212, 216, 221, 233 and 236.
  * Update Redfish support.
  * Bug fixes:
    Fix enabled slot characteristics not being printed
  * Minor improvements:
    Print slot width on its own line
    Use standard strings for slot width
  * Add a --no-quirks option.
  * Drop the CPUID exception list.
  * Obsoletes dmidecode-do-not-let-dump-bin-overwrite-an-existing-file.patch,
    dmidecode-fortify-entry-point-length-checks.patch,
    dmidecode-split-table-fetching-from-decoding.patch,
    dmidecode-write-the-whole-dump-file-at-once.patch,
    dmioem-fix-segmentation-fault-in-dmi_hp_240_attr.patch,
    dmioem-hpe-oem-record-237-firmware-change.patch,
    dmioem-typo-fix-virutal-virtual.patch,
    ensure-dev-mem-is-a-character-device-file.patch,
    news-fix-typo.patch and
    use-read_file-to-read-from-dump.patch.
  Update for HPE servers from upstream:
- dmioem-update-hpe-oem-type-238.patch: Decode PCI bus segment in
  HPE type 238 records.
* Wed Apr 19 2023 jdelvare@suse.de
- use-read_file-to-read-from-dump.patch: Fix an old harmless bug
  which would prevent root from using the --from-dump option since
  the latest security fixes (bsc#1210418).
* Fri Apr 14 2023 jdelvare@suse.de
  Security fixes (CVE-2023-30630)
- dmidecode-split-table-fetching-from-decoding.patch: dmidecode:
  Clean up function dmi_table so that it does only one thing
  (bsc#1210418).
- dmidecode-write-the-whole-dump-file-at-once.patch: When option
  - -dump-bin is used, write the whole dump file at once, instead of
  opening and closing the file separately for the table and then
  for the entry point (bsc#1210418).
- dmidecode-do-not-let-dump-bin-overwrite-an-existing-file.patch:
  Make sure that the file passed to option --dump-bin does not
  already exist (bsc#1210418).
- ensure-dev-mem-is-a-character-device-file.patch: Add a safety
  check on the type of the mem device file we are asked to read
  from, if we are root (bsc#1210418).
  3 recommended fixes from upstream:
- dmioem-typo-fix-virutal-virtual.patch: Simple typo fix in a
  user-visible string.
- dmidecode-fortify-entry-point-length-checks.patch: Ensure that
  the SMBIOS entry point is long enough to include all the fields
  we need.
- dmioem-hpe-oem-record-237-firmware-change.patch: Properly decode
  the last field of HPE OEM record type 237.
* Tue Sep 13 2022 jdelvare@suse.de
  2 recommended fixes from upstream:
- news-fix-typo.patch: We ship the NEWS file so avoid including a
  typo in it.
- dmioem-fix-segmentation-fault-in-dmi_hp_240_attr.patch: Passing
  NULL to a %%s printf conversion specifier is illegal, and can
  result in a segmentation fault. Current version of glibc doesn't
  mind, but alternative, past or future libc implementations could
  crash, so let's fix it.
* Tue Sep 13 2022 jdelvare@suse.de
- Update to upstream version 3.4:
  * This update implements jsc#SLE-24502 and jsc#PED-1466.
  * [COMPATIBILITY] Document how the UUID fields are interpreted.
  * [PORTABILITY] Don't use memcpy on /dev/mem on arm64.
  * Support for SMBIOS 3.4.0. This includes new memory device types, new
    processor upgrades, new slot types and characteristics, decoding of memory
    module extended speed, new system slot types, new processor characteristics
    and new format of Processor ID.
  * Support for SMBIOS 3.5.0. This includes new processor upgrades, BIOS
    characteristics, new slot characteristics, new on-board device types, new
    pointing device interface types, and a new record type (type 45 -
    Firmware Inventory Information).
  * Decode HPE OEM records 194, 199, 203, 236, 237, 238 ans 240.
  * Bug fixes:
    Fix OEM vendor name matching
  * Minor improvements:
    Add bios-revision, firmware-revision and system-sku-number to -s option
    Use the most appropriate unit for cache size
    Decode system slot base bus width and peers
    Skip details of uninstalled memory modules
    Don't display the raw CPU ID in quiet mode
    Improve the formatting of the manual pages
  * Obsoletes dmidecode-add-enumerated-values-from-smbios-3.3.0.patch,
    dmidecode-add-logical-non-volatile-device.patch,
    dmidecode-add-memory-device-types-from-smbios-3.4.0.patch,
    dmidecode-add-processor-characteristics-bits-from-smbios-3.4.0.patch,
    dmidecode-add-processor-upgrades-from-smbios-3.4.0.patch,
    dmidecode-add-slot-characteristics2-from-smbios-3.4.0.patch,
    dmidecode-add-system-slot-types-from-smbios-3.4.0.patch,
    dmidecode-fix-formatting-of-tpm-table-output.patch,
    dmidecode-fix-redfish-hostname-print-length.patch,
    dmidecode-fix-system-slot-information-for-pcie-ssd.patch,
    dmidecode-missing-commas.patch,
    dmidecode-only-scan-dev-mem-for-entry-point-on-x86.patch and
    dmidecode-skip-details-of-uninstalled-memory-modules.patch.
* Thu Dec 10 2020 jdelvare@suse.de
  1 recommended fix from upstream:
- dmidecode-missing-commas.patch: Two missing commas in data arrays
  cause off-by-one or mangling during index resolution
  (bsc#1174257).
* Fri Oct 30 2020 jdelvare@suse.de
  Partial support for SMBIOS 3.4.0:
- dmidecode-add-memory-device-types-from-smbios-3.4.0.patch,
  dmidecode-add-processor-characteristics-bits-from-smbios-3.4.0.patch,
  dmidecode-add-processor-upgrades-from-smbios-3.4.0.patch,
  dmidecode-add-slot-characteristics2-from-smbios-3.4.0.patch,
  dmidecode-add-system-slot-types-from-smbios-3.4.0.patch: Add
  enumerated values from SMBIOS 3.4.0 (bsc#1174257).
  1 presentation fix from upstream:
- dmidecode-skip-details-of-uninstalled-memory-modules.patch:
  Skip details of uninstalled memory modules (bsc#1174257).
* Wed Dec 18 2019 jdelvare@suse.de
  Partial support for SMBIOS 3.3.0:
- dmidecode-add-enumerated-values-from-smbios-3.3.0.patch: Add
  enumerated values from SMBIOS 3.3.0 (bsc#1153533 bsc#1158833
  jsc#SLE-10875).
  3 recommended fixes from upstream:
- dmidecode-only-scan-dev-mem-for-entry-point-on-x86.patch: Only
  scan /dev/mem for entry point on x86 (fixes reboot on ARM64).
- dmidecode-fix-formatting-of-tpm-table-output.patch: Fix
  formatting of TPM table output (missing newlines).
- dmidecode-fix-system-slot-information-for-pcie-ssd.patch: Fix
  System Slot Information for PCIe SSD.
* Wed Jan 16 2019 jdelvare@suse.de
- dmidecode-add-logical-non-volatile-device.patch: Add "Logical
  non-volatile device" to the memory device types (bsc#1120149).
- Use %%doc directly on files instead of installing them explicitly.
* Mon Jan 14 2019 jdelvare@suse.de
- Don't overwrite the path of license (boo#1121851).
* Mon Oct 22 2018 jdelvare@suse.de
- dmidecode-fix-redfish-hostname-print-length.patch: Fix Redfish
  Hostname print length (bsc#1112755).
* Mon Sep 17 2018 jdelvare@suse.de
- Update to upstream version 3.2 (FATE#326044):
  * [COMPATIBILITY] The UUID is now displayed using lowercase
    letters, per RFC 4122 (#53569). You must ensure that any code
    parsing it is case-insensitive.
  * Support for SMBIOS 3.2.0. This includes new processor names,
    new socket and port connector types, new system slot state and
    property, and support for non-volatile memory (NVDIMM).
  * Support for Redfish management controllers.
  * A new command line option to query a specific structure by its
    handle.
  * A new command line option to query the system family string.
  * Support for 3 ThinkPad-specific structures (patch #9642).
  * Support for HPE's new company name.
  * Support UEFI on FreeBSD.
  * Important bug fixes:
    Fix firmware version of TPM device
    Fix the HPE UEFI feature flag check
  * (biosdecode) A new command line option to fully decode PIR
    information (support request #109339).
  * Obsoletes dmioem-reflect-hpe-new-company-name.patch,
    dmidecode-fix-tpm-device-firmware-version.patch, and
    dmioem-fix-hpe-type-219-uefi-flag.patch.
  * CHANGELOG is gone, package more compact NEWS file instead.
- Reenable signature checking.
- Use %%license for LICENSE file.
* Tue Apr 17 2018 jdelvare@suse.de
- dmioem-reflect-hpe-new-company-name.patch: Reflect HPE's new
  company name.
- dmidecode-fix-tpm-device-firmware-version.patch: Fix firmware
  version of TPM device.
- dmioem-fix-hpe-type-219-uefi-flag.patch: Fix the reporting of
  HP/HPE UEFI feature.
* Mon Jul 17 2017 jdelvare@suse.de
- Add missing bug numbers and FATE references in changes file
  (bsc#1041670).
* Wed May 24 2017 jdelvare@suse.de
- Update to upstream version 3.1:
  * Support for SMBIOS 3.1.0 and 3.1.1. This includes new chassis
    types, new processor family names, new processor family upgrade
    names, and new slot types, as well as support of larger BIOS
    ROM sizes and cache sizes, and a new structure type (43, TPM
    Device.)
  * A new command line option to query OEM strings.
  * All error messages are now printed on stderr (#47274, #48158.)
  * Fixes a crash with SIGBUS (#46066.)
  * Various minor fixes, improvements and cleanups.
  * Obsoletes dmidecode-01-add-no-sysfs-option-description-to-h-output.patch,
    dmidecode-02-fix-no-smbios-nor-dmi-entry-point-found-on-smbios3.patch,
    dmidecode-03-let-read_file-return-the-actual-data-size.patch,
    dmidecode-04-use-read_file-to-read-the-dmi-table-from-sysfs.patch,
    dmidecode-05-use-dword-for-structure-table-maximum-size-in-smbios3.patch,
    dmidecode-06-hide-irrelevant-fixup-message.patch, and
    dmidecode-07-only-decode-one-dmi-table.patch.
* Fri Jan 20 2017 jdelvare@suse.de
- dmidecode-07-only-decode-one-dmi-table.patch: Only decode one
  DMI table.
  https://savannah.nongnu.org/bugs/?50022
* Tue May  3 2016 jdelvare@suse.de
- dmidecode-01-add-no-sysfs-option-description-to-h-output.patch:
  Add "--no-sysfs" option description to -h output.
- dmidecode-02-fix-no-smbios-nor-dmi-entry-point-found-on-smbios3.patch:
  Fix 'No SMBIOS nor DMI entry point found' on SMBIOS3.
- dmidecode-03-let-read_file-return-the-actual-data-size.patch:
  Let read_file return the actual data size.
- dmidecode-04-use-read_file-to-read-the-dmi-table-from-sysfs.patch:
  Use read_file() to read the DMI table from sysfs.
  https://savannah.nongnu.org/bugs/?46176
- dmidecode-05-use-dword-for-structure-table-maximum-size-in-smbios3.patch:
  Use DWORD for Structure table maximum size in SMBIOS3.
- dmidecode-06-hide-irrelevant-fixup-message.patch:
  Hide irrelevant fixup message.
  http://savannah.nongnu.org/support/?109024
* Thu Sep  3 2015 jdelvare@suse.de
- Update to upstream version 3.0 (FATE#320746, FATE#320773):
  * Adds support for SMBIOS 3.0. This includes a new (64-bit) entry
    point format and new enumerated values for recent hardware.
  * Adds support for the new kernel interface (as of Linux v4.2) as
    an alternative to relying on /dev/mem to access the entry point
    and DMI table.
  * Adds decoding of Acer-specific DMI type 170 and HP-specific DMI
    types 212, 219 and 233.
  * Obsoletes dmidecode-1.173-drop-cast.patch,
    dmidecode-1.175-fix-SMBIOS-2.8.0.patch,
    dmidecode-1.176-SMBIOS-2.8-is-supported.patch,
    dmidecode-1.177-decode-pcie3-slot-id.patch,
    dmidecode-1.181-decode-CPUID-recent-AMD.patch, and
    dmidecode-1.182-decode-ddr4-memory-type.patch.
  * Various minor fixes and clean-ups.
  * Skip the SMBIOS version comparison in quiet mode (bsc#974862).
* Sun Feb 22 2015 meissner@suse.com
- dmidecode.keyring was empty, reference the savannah keyring.
  but the tarball is signed by someone unknown without gpg signatures,
  so no keyring for now.
* Fri Feb 20 2015 mpluskal@suse.com
- Cleanup spec file with spec-cleaner
- Add gpg signature
* Mon Oct 13 2014 jdelvare@suse.de
- dmidecode-1.181-decode-CPUID-recent-AMD.patch: Decode the CPUID
  of recent AMD processors (DMI type 4).
- dmidecode-1.182-decode-ddr4-memory-type.patch: Add support for
  DDR4 memory type (DMI type 17) (bsc#955705).
  https://savannah.nongnu.org/bugs/?43370
* Mon Jan 13 2014 jdelvare@suse.de
- dmidecode-1.176-SMBIOS-2.8-is-supported.patch: Bump
  SUPPORTED_SMBIOS_VER so that SMBIOS 2.8 implementations don't
  trigger a warning.
- dmidecode-1.177-decode-pcie3-slot-id.patch: Decode ID of PCI
  Express 3 slots (DMI type 9.)
  https://savannah.nongnu.org/bugs/?40178
* Fri Apr 26 2013 guillaume@opensuse.org
- Enable build for ARM
* Wed Apr 24 2013 jdelvare@suse.de
- Update to upstream version 2.12:
  * Adds support for SMBIOS 2.8. This includes new enumerated
    values for recent hardware.
  * Obsoletes dmidecode-add-SMBIOS-2_7_1-support.patch and
    dmidecode-fix-memory-array-location-overrun.patch.
  * Various minor fixes and clean-ups.
- dmidecode-1.173-drop-cast.patch: Drop unneeded and possibly
  dangerous cast.
- dmidecode-1.175-fix-SMBIOS-2.8.0.patch: Fix support for new
  processor upgrade types (DMI type 4) and new memory device type
  (DMI type 17.)
* Mon Mar 25 2013 mmeister@suse.com
- Added url as source.
  Please see http://en.opensuse.org/SourceUrls
* Sun Sep 18 2011 jengelh@medozas.de
- Remove redundant tags/sections from specfile
  (cf. packaging guidelines)
- Use %%_smp_mflags for parallel build
* Wed Apr 13 2011 jdelvare@suse.de
- dmidecode-add-SMBIOS-2_7_1-support.patch: Add enumerated values
  from SMBIOS 2.7.1.
* Tue Jan 25 2011 jdelvare@suse.de
- dmidecode-fix-memory-array-location-overrun.patch: Fix boundary
  checks of memory array location codes (DMI type 16).
* Thu Jan 20 2011 jdelvare@suse.de
- Update to upstream version 2.11:
  * Adds support for SMBIOS 2.6.1 and 2.7. This includes new
    enumerated values for recent hardware.
  * Obsoletes dmidecode-fix-makefile-for-GNU-make-3.82.patch.
  * Various minor fixes and clean-ups.
* Wed Sep  8 2010 jdelvare@suse.de
- dmidecode-fix-makefile-for-GNU-make-3.82.patch: Drop BSD make
  command in Makefile, as GNU make 3.82 chokes on it.
* Tue May  5 2009 coolo@suse.de
- obsolete pmtools, but do not provide it as it's not a rename
* Wed Mar 25 2009 jdelvare@suse.de
- Initial packaging. Historically, dmidecode had been part of the
  pmtools package, but it didn't make that much sense so it now has
  its own package.
- Initial version: 2.10.
