#
# spec file for package perl-Term-ReadKey
#
# Copyright (c) 2017 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           perl-Term-ReadKey
Version:        2.37
Release:        150000.3.2.1
Summary:        Module for Simple Terminal Control
License:        GPL-1.0+ or Artistic-1.0
Group:          Development/Libraries/Perl
Url:            http://search.cpan.org/dist/Term-ReadKey
Source:         http://search.cpan.org/CPAN/authors/id/J/JS/JSTOWE/TermReadKey-%{version}.tar.gz
BuildRequires:  make
BuildRequires:  perl-macros
BuildRequires:  perl(ExtUtils::MakeMaker)
Requires:       /bin/stty
Provides:       perl-TermReadKey = %{version}
Obsoletes:      perl-TermReadKey <= 2.30
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%{perl_requires}

%description
This module, ReadKey, provides ioctl control for terminals and Win32 consoles
so the input modes can be changed (thus allowing reads of a single character at
a time), and also provides non-blocking reads of stdin, as well as several
other terminal related features, including retrieval/modification of the screen
size, and retrieval/modification of the control characters.

%prep
%setup -q -n "TermReadKey-%{version}"
sed -i '/^auto_install/d' Makefile.PL

%build
perl Makefile.PL PREFIX="%{_prefix}"
make %{?_smp_flags}

%install
%perl_make_install
%perl_process_packlist

%check
# s390/s390x don't have /dev/tty
%ifnarch s390 s390x
make test
%endif

%files
%defattr(-,root,root)
%doc README
%dir %{perl_vendorarch}/Term
%{perl_vendorarch}/Term/ReadKey.pm
%dir %{perl_vendorarch}/auto/Term
%{perl_vendorarch}/auto/Term/ReadKey
%doc %{perl_man3dir}/Term::ReadKey.%{perl_man3ext}%{ext_man}

%changelog
* Sun Sep 24 2017 coolo@suse.com
- update to 2.37
  * Better support parallel builds by making 'dynamic' a dependency of the ReadKey.pm
  * Add a package declaration to the ReadKey_pm.PL to aid indexing
  * Use FULLPERLRUNINST to run the ReadKey_pm.PL to get the 'blib'
  * Fix GetTerminalSize() argument handling
  * Fix miniperl build on Win32
  * Remove unused Cwd
  * Fix TAP output
  * Fix warnings in XS file
  * Don't attempt some tests if STDIN is not a terminal
  * Generate ReadKey.pm from  ReadKey_pm.PL to expand blockoptions
  * demand-load Carp,
  * remove unneeded AutoLoader,
  * Improve genchars.pl, support make -s silence.
  * Improve Makefile.PL add SIGN, fix pure_site_install, support dual-life, fix realclean
* Thu May 29 2014 stephan.barth@suse.com
- Update to version 2.32 from 2.31
  Upstream changes:
  2014-05-10  Jonathan Stowe
  * Makefile.PL: Makefile.PL more specific
  2014-05-10  Jonathan Stowe <jns+git@gellyfish.co.uk>
  * : Merge pull request #2 from jacquesg/warnings Fix some warnings
  2014-03-09  Jonathan Stowe <jns+git@gellyfish.co.uk>
  * Configure.pm, META.yml, Makefile.PL: Don't index Configure.pm
  2014-03-03  Jonathan Stowe <jns+git@gellyfish.co.uk>
  * Changes, README, ReadKey.pm: Added documentation patch as per
    Chris Marshall Bumped version
* Tue Nov 26 2013 coolo@suse.com
- update to 2.31, new author, a more clearer license, no changelog
* Wed Oct  5 2011 lars@linux-schulserver.de
- also obsolete perl-TermReadKey 2.30
* Wed Sep 28 2011 pascal.bleser@opensuse.org
- renamed to perl-Term-ReadKey
* Tue Nov 30 2010 coolo@novell.com
- switch to perl_requires macro
* Mon Nov 29 2010 coolo@novell.com
- remove /var/adm/perl-modules
* Tue Oct 19 2010 coolo@novell.com
- add perl as explicit buildrequire
* Sun Dec 20 2009 jengelh@medozas.de
- enable parallel build
- enable testsuite on SPARC (there is a /dev/tty)
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Mon Aug  1 2005 mjancar@suse.cz
- update to 2.30
* Fri Mar 26 2004 kukuk@suse.de
- Fix Requires (/bin/stty is needed, not XFree86)
* Wed Feb 18 2004 kukuk@suse.de
- Remove unused packages from neededforbuild
- Don't run test suite on machines without /dev/tty
* Sat Jan 10 2004 adrian@suse.de
- build as user
* Fri Aug 22 2003 mjancar@suse.cz
- require the perl version we build with
* Tue Jul 15 2003 mjancar@suse.cz
- adapt to perl-5.8.1
- use %%perl_process_packlist
* Wed Jun 18 2003 coolo@suse.de
- package directories
* Tue May 20 2003 mjancar@suse.cz
- remove unpackaged files
* Tue Nov 12 2002 prehak@suse.cz
- updated to version 2.21
- updated neededforbuild after xf86-rename
* Mon Jul 22 2002 prehak@suse.cz
- update to version 2.20
- enabled make test
* Tue Jul  2 2002 mls@suse.de
- remove race in .packlist generation
* Thu Jan 17 2002 rvasice@suse.cz
- update to version 2.16
* Fri Nov  2 2001 rvasice@suse.cz
- initial package release (version 2.14)
