#
# spec file for package openssl-1_1
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define ssletcdir %{_sysconfdir}/ssl
%define maj_min 1.1
%define _rname  openssl
%global sslengcnf %{ssletcdir}/engines1.1.d
%global sslengdef %{ssletcdir}/engdef1.1.d
%if 0%{?sle_version} >= 150400 || 0%{?suse_version} >= 1550
# Enable livepatching support for SLE15-SP4 onwards. It requires
# compiler support introduced there.
%define livepatchable 1
# Set variables for livepatching.
%define _other %{_topdir}/OTHER
%define tar_basename %{_rname}-livepatch-%{version}-%{release}
%define tar_package_name %{tar_basename}.%{_arch}.tar.xz
%define clones_dest_dir %{tar_basename}/%{_arch}
%else
# Unsupported operating system.
%define livepatchable 0
%endif
%ifnarch x86_64
# Unsupported architectures must have livepatch disabled.
%define livepatchable 0
%endif
Name:           openssl-1_1
# Don't forget to update the version in the "openssl" meta-package!
Version:        1.1.1w
Release:        150600.5.18.1
Summary:        Secure Sockets and Transport Layer Security
License:        OpenSSL
Group:          Productivity/Networking/Security
URL:            https://www.openssl.org/
Source:         https://www.%{_rname}.org/source/%{_rname}-%{version}.tar.gz
# to get mtime of file:
Source1:        %{name}.changes
Source2:        baselibs.conf
Source3:        https://www.%{_rname}.org/source/%{_rname}-%{version}.tar.gz.asc
# https://www.openssl.org/about/
# http://pgp.mit.edu:11371/pks/lookup?op=get&search=0xA2D29B7BF295C759#/openssl.keyring
Source4:        %{_rname}.keyring
Source5:        showciphers.c
# PATCH-FIX-OPENSUSE: do not install html mans it takes ages
Patch1:         openssl-1.1.0-no-html.patch
Patch2:         openssl-truststore.patch
Patch3:         openssl-pkgconfig.patch
Patch4:         openssl-DEFAULT_SUSE_cipher.patch
Patch5:         openssl-ppc64-config.patch
Patch6:         openssl-riscv64-config.patch
# PATCH-FIX-UPSTREAM jsc#SLE-6126 and jsc#SLE-6129
Patch8:         0001-s390x-assembly-pack-perlasm-support.patch
Patch9:         0002-crypto-chacha-asm-chacha-s390x.pl-add-vx-code-path.patch
Patch10:        0003-crypto-poly1305-asm-poly1305-s390x.pl-add-vx-code-pa.patch
Patch11:        0004-s390x-assembly-pack-fix-formal-interface-bug-in-chac.patch
Patch12:        0005-s390x-assembly-pack-import-chacha-from-cryptogams-re.patch
Patch13:        0006-s390x-assembly-pack-import-poly-from-cryptogams-repo.patch
# PATCH-FIX-UPSTREAM bsc#1152695 jsc#SLE-7861 Support for CPACF enhancements - part 1 (crypto)
Patch16:        openssl-s390x-assembly-pack-add-OPENSSL_s390xcap-environment.patch
Patch17:        openssl-s390x-assembly-pack-add-support-for-pcc-and-kma-inst.patch
Patch18:        openssl-s390x-assembly-pack-add-OPENSSL_s390xcap-man-page.patch
Patch19:        openssl-s390x-assembly-pack-update-OPENSSL_s390xcap-3.patch
Patch20:        openssl-s390xcpuid.pl-fix-comment.patch
Patch21:        openssl-assembly-pack-accelerate-scalar-multiplication.patch
Patch22:        openssl-Enable-curve-spefific-ECDSA-implementations-via-EC_M.patch
Patch23:        openssl-s390x-assembly-pack-accelerate-ECDSA.patch
Patch24:        openssl-OPENSSL_s390xcap.pod-list-msa9-facility-bit-155.patch
Patch25:        openssl-s390x-assembly-pack-cleanse-only-sensitive-fields.patch
Patch26:        openssl-s390x-assembly-pack-fix-OPENSSL_s390xcap-z15-cpu-mas.patch
Patch27:        openssl-s390x-assembly-pack-fix-msa3-stfle-bit-detection.patch
Patch28:        openssl-Fix-9bf682f-which-broke-nistp224_method.patch
# FIPS patches
Patch30:        openssl-1.1.1-fips.patch
Patch31:        openssl-1.1.1-fips-post-rand.patch
Patch32:        openssl-1.1.1-fips-crng-test.patch
Patch33:        openssl-1.1.0-issuer-hash.patch
Patch34:        openssl-fips-run_selftests_only_when_module_is_complete.patch
Patch35:        openssl-ship_fips_standalone_hmac.patch
Patch36:        openssl-fips_mode.patch
Patch37:        openssl-1.1.1-evp-kdf.patch
Patch38:        openssl-1.1.1-ssh-kdf.patch
Patch40:        openssl-fips-selftests_in_nonfips_mode.patch
Patch41:        openssl-fips-clearerror.patch
Patch42:        openssl-fips-ignore_broken_atexit_test.patch
Patch45:        openssl-fips-add-SHA3-selftest.patch
Patch46:        openssl-fips_selftest_upstream_drbg.patch
Patch47:        openssl-unknown_dgst.patch
# PATCH-FIX-UPSTREAM jsc#SLE-7403 Support for CPACF enhancements - part 2 (crypto)
Patch50:        openssl-s390x-assembly-pack-accelerate-X25519-X448-Ed25519-and-Ed448.patch
Patch51:        openssl-s390x-fix-x448-and-x448-test-vector-ctime-for-x25519-and-x448.patch
# PATCH-FIX-UPSTREAM bsc#1175844 FIPS: (EC)Diffie-Hellman requirements
# from SP800-56Arev3 SLE-15-SP2
Patch52:        openssl-DH.patch
Patch53:        openssl-kdf-selftest.patch
Patch54:        openssl-kdf-tls-selftest.patch
Patch55:        openssl-kdf-ssh-selftest.patch
Patch56:        openssl-fips-DH_selftest_shared_secret_KAT.patch
# PATCH-FIX-UPSTREAM bsc#1192442 FIPS: missing KAT for HKDF/TLS 1.3/IPSEC IKEv2
Patch57:        openssl-fips-kdf-hkdf-selftest.patch
Patch58:        openssl-1.1.1-system-cipherlist.patch
# PATCH-FIX-OPENSUSE jsc#SLE-15832 Centralized Crypto Compliance Configuration
Patch59:        openssl-1_1-seclevel.patch
Patch60:        openssl-1_1-use-seclevel2-in-tests.patch
Patch61:        openssl-1_1-disable-test_srp-sslapi.patch
# PATCH-FIX-UPSTREAM jsc#SLE-18136 POWER10 performance enhancements for cryptography
Patch69:        openssl-1_1-Optimize-ppc64.patch
# PATCH-FIX-UPSTREAM jsc#SLE-19742 Backport Arm improvements from OpenSSL 3
Patch70:        openssl-1_1-Optimize-RSA-armv8.patch
Patch71:        openssl-1_1-Optimize-AES-XTS-aarch64.patch
Patch72:        openssl-1_1-Optimize-AES-GCM-uarchs.patch
# PATCH-FIX-SUSE bsc#1185320 FIPS: move the HMAC-SHA2-256 used for integrity test
Patch73:        openssl-FIPS-KAT-before-integrity-tests.patch
# PATCH-FIX-SUSE bsc#1182959 FIPS: Fix function and reason error codes
Patch74:        openssl-1_1-FIPS-fix-error-reason-codes.patch
#PATCH-FIX-SUSE bsc#1190652 FIPS: Add release number to version string
Patch75:        openssl-1_1-fips-bsc1190652_release_num_in_version_string.patch
# PATCH-FIX-SUSE bsc#1180995 Default to RFC7919 groups in FIPS mode
Patch76:        openssl-1_1-paramgen-default_to_rfc7919.patch
# PATCH-FIX-SUSE bsc#1194187 bsc#1004463 Add engines section in openssl.cnf
Patch77:        openssl-1_1-use-include-directive.patch
# PATCH-FIX-SUSE bsc#1197280 FIPS: Additional PBKDF2 requirements for KAT
Patch78:        openssl-1_1-FIPS-PBKDF2-KAT-requirements.patch
Patch79:        bsc1185319-FIPS-KAT-for-ECDSA.patch
Patch80:        bsc1198207-FIPS-add-hash_hmac-drbg-kat.patch
Patch82:        openssl-1_1-shortcut-test_afalg_aes_cbc.patch
# PATCH-FIX-SUSE bsc#1190653 FIPS: Provide methods to zeroize all unprotected SSPs and key components
Patch84:        openssl-1_1-Zeroization.patch
# PATCH-FIX-SUSE bsc#1190651 FIPS: Provide a service-level indicator
Patch85:        openssl-1_1-ossl-sli-000-fix-build-error.patch
Patch86:        openssl-1_1-ossl-sli-001-fix-faults-preventing-make-update.patch
Patch87:        openssl-1_1-ossl-sli-002-ran-make-update.patch
Patch88:        openssl-1_1-ossl-sli-003-add-sli.patch
# PATCH-FIX-SUSE bsc#1202148 FIPS: Port openssl to use jitterentropy
Patch89:        openssl-1_1-jitterentropy-3.4.0.patch
# PATCH-FIX-SUSE bsc#1203046 FIPS: Fix memory leak when FIPS mode is enabled
Patch90:        openssl-1.1.1-fips-fix-memory-leaks.patch
# PATCH-FIX-FEDORA bsc#1201293 FIPS: RAND api should call into FIPS DRBG
Patch91:        openssl-1_1-FIPS_drbg-rewire.patch
# PATCH-FIX-FEDORA bsc#1203069 FIPS: Add KAT for the RAND_DRBG implementation
Patch92:        openssl-1_1-fips-drbg-selftest.patch
# PATCH-FIX-SUSE bsc#1121365, bsc#1190888, bsc#1193859, bsc#1198471, bsc#1198472
# FIPS: List only approved digest and pubkey algorithms
Patch93:        openssl-1_1-fips-list-only-approved-digest-and-pubkey-algorithms.patch
# PATCH-FIX-SUSE bsc#1190651 FIPS: Provide a service-level indicator
Patch94:        openssl-1_1-ossl-sli-004-allow-aes-xts-256.patch
Patch95:        openssl-1_1-ossl-sli-005-EC_group_order_bits.patch
Patch96:        openssl-1_1-ossl-sli-006-rsa_pkcs1_padding.patch
Patch97:        openssl-1_1-ossl-sli-007-pbkdf2-keylen.patch
# PATCH-FIX-UPSTREAM jsc#PED-512
# POWER10 performance enhancements for cryptography
Patch98:        openssl-1_1-AES-GCM-performance-optimzation-with-stitched-method.patch
Patch99:        openssl-1_1-Fixed-counter-overflow.patch
Patch100:       openssl-1_1-chacha20-performance-optimizations-for-ppc64le-with-.patch
Patch101:       openssl-1_1-Fixed-conditional-statement-testing-64-and-256-bytes.patch
Patch102:       openssl-1_1-Fix-AES-GCM-on-Power-8-CPUs.patch
# PATCH-FIX-OPENSUSE bsc#1205042 Set OpenSSL 3.0 as the default openssl
Patch103:       openssl-1_1-openssl-config.patch
# PATCH-FIX-SUSE bsc#1207994 FIPS Make jitterentropy calls thread-safe
Patch104:       openssl-1_1-serialize-jitterentropy-calls.patch
# PATCH-FIX-SUSE bsc#1208998 FIPS: PBKDF2 requirements for openssl
Patch105:       openssl-1_1-ossl-sli-008-pbkdf2-salt_pass_iteration.patch
# PATCH-FIX-SUSE bsc#1212623 openssl s_client does not honor ocsp revocation status
Patch106:       openssl-s_client-check-ocsp-status.patch
# PATCH-FIX-SUSE bsc#1213517 Dont pass zero length input to EVP_Cipher
Patch107:       openssl-dont-pass-zero-length-input-to-EVP_Cipher.patch
#PATCH-FIX-SUSE bsc#1215215 FIPS: Add "fips" to version string
Patch108:       openssl-1_1-fips-bsc1215215_fips_in_version_string.patch
# PATCH-FIX-UPSTREAM jsc#PED-5086, jsc#PED-3514
# POWER10 performance enhancements for cryptography
Patch109:       openssl-ec-Use-static-linkage-on-nistp521-felem_-square-mul-.patch
Patch110:       openssl-ec-56-bit-Limb-Solinas-Strategy-for-secp384r1.patch
Patch111:       openssl-ec-powerpc64le-Add-asm-implementation-of-felem_-squa.patch
Patch112:       openssl-ecc-Remove-extraneous-parentheses-in-secp384r1.patch
Patch113:       openssl-powerpc-ecc-Fix-stack-allocation-secp384r1-asm.patch
Patch114:       openssl-Improve-performance-for-6x-unrolling-with-vpermxor-i.patch
# PATCH-FIX-UPSTREAM: bsc#1216922 CVE-2023-5678 Generating excessively long X9.42 DH keys or
# checking excessively long X9.42 DH keys or parameters may be very slow
Patch115:       openssl-CVE-2023-5678.patch
# PATCH-FIX-OPENSUSE skip SHA1 test in FIPS mode
Patch116:       openssl-Skip_SHA1-test-in-FIPS-mode.patch
# PATCH-FIX-UPSTREAM: bsc#1219243 CVE-2024-0727: denial of service via null dereference
Patch117:       openssl-CVE-2024-0727.patch
# PATCH-FIX-UPSTREAM: bsc#1222548 CVE-2024-2511: Unbounded memory growth with session handling in TLSv1.3
Patch118:       openssl-CVE-2024-2511.patch
# PATCH-FIX-UPSTREAM bsc#1225551 CVE-2024-4741: use After Free with SSL_free_buffers
Patch119:       openssl-CVE-2024-4741.patch
# PATCH-FIX-SUSE bsc#1224260 FIPS: Align CRNGT_BUFSIZ with Jitter RNG output size
Patch120:       openssl-1_1-FIPS-CRNGT_BUFSIZ.patch
# PATCH-FIX-SUSE bsc#1224258 FIPS: DRBG component chaining
Patch121:       openssl-1_1-FIPS-140-3-DRBG-prediction-resistance.patch
Patch122:       openssl-1_1-FIPS-140-3-DRBG-oversampling.patch
Patch123:       openssl-1_1-jitterentropy-error-state.patch
# PATCH-FIX-SUSE bsc#1224273 FIPS: Disallow RSA sigVER with 1024 and ECDSA sigVer/keyVer P-192
Patch124:       openssl-1_1-ossl-sli-009-RSA-sigver.patch
Patch125:       openssl-1_1-ossl-sli-010-ECDSA-sigver-keyver.patch
# PATCH-FIX-SUSE bsc#1224267 FIPS: Disallow non-approved KDF types
Patch126:       openssl-1_1-ossl-sli-011-SSHKDF.patch
# PATCH-FIX-SUSE bsc#1224265 FIPS: Add PCT in DH keygen
Patch127:       openssl-fips-DH-Pair-wise-Consistency.patch
# PATCH-FIX-UPSTREAM: bsc#1227138 CVE-2024-5535: SSL_select_next_proto buffer overread
Patch128:       openssl-CVE-2024-5535.patch
# PATCH-FIX-SUSE bsc#1224264 FIPS: DH FIPS selftest and safe prime group
Patch129:       openssl-1_1-ossl-sli-012-DH-selftest-and-safe-prime-group.patch
# PATCH-FIX-SUSE bsc#1224266 FIPS: Consider deprecating sha1
Patch130:       openssl-1_1-ossl-sli-013-Mark-SHA1-unapproved.patch
# PATCH-FIX-SUSE bsc#1224271 FIPS: PKCSv1.5 and shake
Patch131:       openssl-1_1-ossl-sli-014-PKCSv1.5-and-shake.patch
# PATCH-FIX-SUSE bsc#1224272 FIPS: Signature procedures regarding hashing and sign/verify
Patch132:       openssl-1_1-ossl-sli-015-sigver-hashing.patch
# PATCH-FIX-SUSE bsc#1224275 FIPS: PSS length
Patch133:       openssl-1_1-ossl-sli-016-PSS-length.patch
# PATCH-FIX-SUSE bsc#1224269 FIPS: X9.31 scheme is not approved for signatures
Patch134:       openssl-1_1-ossl-sli-017-X9.31-sign.patch
# PATCH-FIX-SUSE bsc#1228619 FIPS: Mark HKDF and TLSv1.3 KDF as approved in the SLI
Patch135:       openssl-1_1-ossl-sli-018-TLS13-HKDF.patch
# PATCH-FIX-SUSE bsc#1224270 FIPS: Enforce KDF in FIPS style
Patch136:       openssl-1_1-ossl-sli-019-Enforce-KDF.patch
# PATCH-FIX-SUSE bsc#1228623 FIPS: Mark HMAC input keys with >= 112 bits as approved
Patch137:       openssl-1_1-ossl-sli-020-PBKDF2-HMAC-size-SLI.patch
# PATCH-FIX-SUSE bsc#1228618 FIPS: AES GCM external IV
Patch138:       openssl-1_1-ossl-sli-021-AES-GCM-external-IV.patch
# PATCH-FIX-SUSE bsc#1220262 CVE-2023-50782: Implicit rejection in PKCS#1 v1.5
Patch139:       openssl-CVE-2023-50782.patch
# PATCH-FIX-UPSTREAM: bsc#1236136 CVE-2024-13176: timing side-channel in the ECDSA signature computation
Patch140:       openssl-CVE-2024-13176.patch
# PATCH-FIX-SUSE bsc#1236771 FIPS: Non approved PBKDF parameters wrongly resulting as approved 
Patch141:	openssl-FIPS-PBKDF-params.patch
# PATCH-FIX-SUSE bsc#1246697 FIPS: Use the NID_X9_62_prime256v1 curve in ECDSA KAT test
Patch142:       openssl-fips-ECDSA-KAT.patch
# PATCH-FIX-UPSTREAM bsc#1250232 CVE-2025-9230: Fix out-of-bounds read & write in RFC 3211 KEK Unwrap
Patch143:       openssl3-CVE-2025-9230.patch

BuildRequires:  jitterentropy-devel >= 3.4.0
BuildRequires:  pkgconfig
BuildRequires:  pkgconfig(zlib)
Requires:       libjitterentropy3 >= 3.4.0
Provides:       ssl
Requires:       libopenssl1_1 = %{version}-%{release}
# Needed for clean upgrade path, boo#1070003
Obsoletes:      openssl-1_0_0
# Needed for clean upgrade from former openssl-1_1_0, boo#1081335
Obsoletes:      openssl-1_1_0
%if 0%{?sle_version} >= 150400 || 0%{?suse_version} >= 1550
Requires:       crypto-policies
%endif

%description
OpenSSL is a software library to be used in applications that need to
secure communications over computer networks against eavesdropping or
need to ascertain the identity of the party at the other end.
OpenSSL contains an implementation of the SSL and TLS protocols.

%package -n libopenssl1_1
Summary:        Secure Sockets and Transport Layer Security
Group:          Productivity/Networking/Security
Recommends:     ca-certificates-mozilla
# Needed for clean upgrade from former openssl-1_1_0, boo#1081335
Obsoletes:      libopenssl1_1_0
%if 0%{?sle_version} >= 150400 || 0%{?suse_version} >= 1550
Requires:       crypto-policies
%endif
Conflicts:      %{name} < %{version}-%{release}
# Merge back the hmac files bsc#1185116
Provides:       libopenssl1_1-hmac = %{version}-%{release}
Obsoletes:      libopenssl1_1-hmac < %{version}-%{release}
# Needed for clean upgrade from former openssl-1_1_0, boo#1081335
Obsoletes:      libopenssl1_1_0-hmac
# Needed for clean upgrade from SLE-12 openssl-1_0_0, bsc#1158499
Obsoletes:      libopenssl-1_0_0-hmac

%description -n libopenssl1_1
OpenSSL is a software library to be used in applications that need to
secure communications over computer networks against eavesdropping or
need to ascertain the identity of the party at the other end.
OpenSSL contains an implementation of the SSL and TLS protocols.

%package -n libopenssl-1_1-devel
Summary:        Development files for OpenSSL
Group:          Development/Libraries/C and C++
Requires:       jitterentropy-devel >= 3.4.0
Requires:       libopenssl1_1 = %{version}
Requires:       pkgconfig(zlib)
Recommends:     %{name} = %{version}
# we need to have around only the exact version we are able to operate with
Conflicts:      libopenssl-devel < %{version}
Conflicts:      libopenssl-devel > %{version}
# Conflicting names with libopenssl-3-devel
Conflicts:      libopenssl-3-devel
Conflicts:      ssl-devel
Provides:       ssl-devel
# Needed for clean upgrade from former openssl-1_1_0, boo#1081335
Obsoletes:      libopenssl-1_1_0-devel
# Needed for clean upgrade from SLE-12 openssl-1_0_0, bsc#1158499
Obsoletes:      libopenssl-1_0_0-devel

%description -n libopenssl-1_1-devel
This subpackage contains header files for developing applications
that want to make use of the OpenSSL C API.

%package doc
Summary:        Additional Package Documentation
Group:          Productivity/Networking/Security
Conflicts:      openssl-doc
Provides:       openssl-doc = %{version}
Obsoletes:      openssl-doc < %{version}
BuildArch:      noarch

%description doc
This package contains optional documentation provided in addition to
this package's base documentation.

%prep
%autosetup -p1 -n %{_rname}-%{version}

cp apps/openssl.cnf apps/openssl-1_1.cnf

%build
%ifarch armv5el armv5tel
export MACHINE=armv5el
%endif
%ifarch armv6l armv6hl
export MACHINE=armv6l
%endif

./config \
    no-idea \
    no-afalgeng \
    enable-rfc3779 \
%ifarch x86_64 aarch64 ppc64le
    enable-ec_nistp_64_gcc_128 \
%endif
    enable-camellia \
    zlib \
    no-ec2m \
    --prefix=%{_prefix} \
    --libdir=%{_lib} \
    --openssldir=%{ssletcdir} \
    %{optflags} \
%if %{livepatchable}
    -fpatchable-function-entry=16,14 -fdump-ipa-clones \
%endif
    -Wa,--noexecstack \
    -Wl,-z,relro,-z,now \
    -fno-common \
    -DTERMIO \
    -DPURIFY \
    -D_GNU_SOURCE \
    -DSUSE_OPENSSL_RELEASE=%{release} \
    -DOPENSSL_NO_BUF_FREELISTS \
    $(getconf LFS_CFLAGS) \
    -Wall \
    --with-rand-seed=getrandom \
    --system-ciphers-file=%{_sysconfdir}/crypto-policies/back-ends/openssl.config

# Show build configuration
perl configdata.pm --dump

# Remove not needed FIPS DRBG files [bsc#1224268]
find crypto/fips -type f -name fips_drbg_ctr.c
find crypto/fips -type f -name fips_drbg_hash.c
find crypto/fips -type f -name fips_drbg_hmac.c
find crypto/fips -type f -name fips_drbg_lib.c
find crypto/fips -type f -name fips_drbg_rand.c
find crypto/fips -type f -name fips_drbg_selftest.c
find crypto/fips -type f -name fips_drbg_selftest.h

util/mkdef.pl crypto update
%make_build depend
%make_build all

%check
export MALLOC_CHECK_=3
export MALLOC_PERTURB_=$(($RANDOM % 255 + 1))
# export HARNESS_VERBOSE=yes
LD_LIBRARY_PATH=`pwd` make test -j1

# Create the hmac files required to run the regression tests in FIPS mode
LD_LIBRARY_PATH=`pwd` %{buildroot}%{_bindir}/fips_standalone_hmac \
 libssl.so.%{maj_min} > .libssl.so.%{maj_min}.hmac
LD_LIBRARY_PATH=`pwd` %{buildroot}%{_bindir}/fips_standalone_hmac \
 libcrypto.so.%{maj_min} > .libcrypto.so.%{maj_min}.hmac
OPENSSL_FORCE_FIPS_MODE=1 LD_LIBRARY_PATH=`pwd` make TESTS='-test_pem \
		       -test_hmac -test_mdc2 -test_dh -test_dsa -test_genrsa \
		       -test_mp_rsa -test_enc -test_enc_more -test_passwd -test_req \
		       -test_verify -test_evp -test_evp_extra -test_pkey_meth_kdf \
		       -test_bad_dtls -test_comp -test_key_share -test_renegotiation \
		       -test_sslcbcpadding -test_sslcertstatus -test_sslextension \
		       -test_sslmessages -test_sslrecords -test_sslsessiontick \
		       -test_sslsigalgs -test_sslsignature -test_sslskewith0p \
		       -test_sslversions -test_sslvertol -test_tls13alerts \
		       -test_tls13cookie -test_tls13downgrade -test_tls13hrr \
		       -test_tls13kexmodes -test_tls13messages -test_tls13psk \
		       -test_tlsextms -test_ca -test_cipherlist -test_cms \
		       -test_dtls_mtu -test_ssl_new -test_ssl_old -test_bio_enc \
		       -test_sslapi -test_tls13ccs -test_ec' test -j1

# show ciphers
gcc -o showciphers %{optflags} -I%{buildroot}%{_includedir} %{SOURCE5} -L%{buildroot}%{_libdir} -lssl -lcrypto
LD_LIBRARY_PATH=%{buildroot}%{_libdir} ./showciphers

%install

%if %{livepatchable}

# Ipa-clones are files generated by gcc which logs changes made across
# functions, and we need to know such changes to build livepatches
# correctly. These files are intended to be used by the livepatch
# developers and may be retrieved by using `osc getbinaries`.
#
# Create list of ipa-clones.
find . -name "*.ipa-clones" ! -empty | sed 's/^\.\///g' | sort > ipa-clones.list

# Create ipa-clones destination folder and move clones there.
mkdir -p ipa-clones/%{clones_dest_dir}
while read f; do
  _dest=ipa-clones/%{clones_dest_dir}/$f
  mkdir -p ${_dest%/*}
  cp $f $_dest
done < ipa-clones.list

# Create tar package with the clone files.
tar cfJ %{tar_package_name} -C ipa-clones %{tar_basename}

# Copy tar package to the OTHERS folder
cp %{tar_package_name} %{_other}

%endif # livepatchable

%make_install %{?_smp_mflags}
# kill static libs
rm -f %{buildroot}%{_libdir}/lib*.a

# Rename the openssl CLI to openssl-1_1
mv %{buildroot}%{_bindir}/openssl %{buildroot}%{_bindir}/openssl-1_1

# Install the openssl-1_1.cnf config file
install -m 644 apps/openssl-1_1.cnf %{buildroot}%{_sysconfdir}/ssl/openssl-1_1.cnf

# remove the cnf.dist
rm -f %{buildroot}%{_sysconfdir}/ssl/openssl.cnf.dist
rm -f %{buildroot}%{_sysconfdir}/ssl/openssl-1_1.cnf.dist
rm -f %{buildroot}%{_sysconfdir}/ssl/ct_log_list.cnf
rm -f %{buildroot}%{_sysconfdir}/ssl/ct_log_list.cnf.dist
ln -sf ./%{_rname} %{buildroot}/%{_includedir}/ssl

mkdir %{buildroot}/%{_datadir}/ssl
mv %{buildroot}/%{ssletcdir}/misc %{buildroot}/%{_datadir}/ssl/
# Create the two directories into which packages will drop their configuration
# files.
mkdir %{buildroot}/%{sslengcnf}
mkdir %{buildroot}/%{sslengdef}

# avoid file conflicts with man pages from other packages
#
pushd %{buildroot}/%{_mandir}
# some man pages now contain spaces. This makes several scripts go havoc, among them /usr/sbin/Check.
# replace spaces by underscores
#for i in man?/*\ *; do mv -v "$i" "${i// /_}"; done
which readlink &>/dev/null || function readlink { ( set +x; target=$(file $1 2>/dev/null); target=${target//* }; test -f $target && echo $target; ) }
for i in man?/*; do
    if test -L $i ; then
        LDEST=`readlink $i`
        rm -f $i ${i}ssl
        ln -sf ${LDEST}ssl ${i}ssl
    else
        mv $i ${i}ssl
        fi
    case "$i" in
        *.1)
        # these are the pages mentioned in openssl(1). They go into the main package.
        echo %doc %{_mandir}/${i}ssl%{?ext_man} >> $OLDPWD/filelist;;
        *)
        # the rest goes into the openssl-doc package.
        echo %doc %{_mandir}/${i}ssl%{?ext_man} >> $OLDPWD/filelist.doc;;
    esac
done
popd

# Do not install demo scripts executable under /usr/share/doc
find demos -type f -perm /111 -exec chmod 644 {} \;

# Place showciphers.c for %%doc macro
cp %{SOURCE5} .

# the hmac hashes:
#
# this is a hack that re-defines the __os_install_post macro
# for a simple reason: the macro strips the binaries and thereby
# invalidates a HMAC that may have been created earlier.
# solution: create the hashes _after_ the macro runs.
#
# this shows up earlier because otherwise the expand of
# the macro is too late.
# remark: This is the same as running
#   openssl dgst -sha256 -hmac 'ppaksykemnsecgtsttplmamstKMEs'
%{expand:%%global __os_install_post {%__os_install_post

# Point linker to the newly installed libcrypto in order to avoid BuildRequiring itself (libopenssl1_1)
export LD_LIBRARY_PATH="%{buildroot}%{_libdir}"

%{buildroot}%{_bindir}/fips_standalone_hmac \
  %{buildroot}%{_libdir}/libssl.so.%{maj_min} > \
    %{buildroot}%{_libdir}/.libssl.so.%{maj_min}.hmac

# As fips_standalone_hmac now uses the very same library it checksums,
# the libcrypto hmac needs to be saved to a temporary file, otherwise
# the library will detect the empty hmac and abort due to a wrong checksum
%{buildroot}%{_bindir}/fips_standalone_hmac \
  %{buildroot}%{_libdir}/libcrypto.so.%{maj_min} > \
    %{buildroot}%{_libdir}/.libcrypto.so.%{maj_min}.temphmac

# rename the temporary checksum to its proper name
mv %{buildroot}%{_libdir}/.libcrypto.so.%{maj_min}.temphmac %{buildroot}%{_libdir}/.libcrypto.so.%{maj_min}.hmac
unset LD_LIBRARY_PATH

}}

%pre
# Migrate old engines.d to engines1.1.d.rpmsave
if [ ! -L %{ssletcdir}/engines.d ] && [ -d %{ssletcdir}/engines.d ]; then
    mkdir %{ssletcdir}/engines1.1.d.rpmsave ||:
    mv -v %{ssletcdir}/engines.d/* %{ssletcdir}/engines1.1.d.rpmsave ||:
    rmdir %{ssletcdir}/engines.d ||:
fi

# Migrate old engdef.d to engdef1.1.d.rpmsave
if [ ! -L %{ssletcdir}/engdef.d ] && [ -d %{ssletcdir}/engdef.d ]; then
    mkdir %{ssletcdir}/engdef1.1.d.rpmsave ||:
    mv -v %{ssletcdir}/engdef.d/* %{ssletcdir}/engdef1.1.d.rpmsave ||:
    rmdir %{ssletcdir}/engdef.d ||:
fi

%posttrans
# Restore engines1.1.d.rpmsave to engines1.1.d
if [ -d %{ssletcdir}/engines1.1.d.rpmsave ]; then
    mv -v %{ssletcdir}/engines1.1.d.rpmsave/* %{ssletcdir}/engines1.1.d ||:
    rmdir %{ssletcdir}/engines1.1.d.rpmsave ||:
fi

# Restore engdef1.1.d.rpmsave to engdef1.1.d
if [ -d %{ssletcdir}/engdef1.1.d.rpmsave ]; then
    mv -v %{ssletcdir}/engdef1.1.d.rpmsave/* %{ssletcdir}/engdef1.1.d ||:
    rmdir %{ssletcdir}/engdef1.1.d.rpmsave ||:
fi

%post -n libopenssl1_1 -p /sbin/ldconfig
%postun -n libopenssl1_1 -p /sbin/ldconfig

%files -n libopenssl1_1
%license LICENSE
%{_libdir}/libssl.so.%{maj_min}
%{_libdir}/libcrypto.so.%{maj_min}
%{_libdir}/.libssl.so.%{maj_min}.hmac
%{_libdir}/.libcrypto.so.%{maj_min}.hmac
%{_libdir}/engines-%{maj_min}

%files -n libopenssl-1_1-devel
%{_includedir}/%{_rname}/
%{_includedir}/ssl
%{_libdir}/libssl.so
%{_libdir}/libcrypto.so
%{_libdir}/pkgconfig/libcrypto.pc
%{_libdir}/pkgconfig/libssl.pc
%{_libdir}/pkgconfig/openssl.pc

%files doc -f filelist.doc
%doc doc/* demos
%doc showciphers.c

%files -f filelist
%doc CHANGE* NEWS README
%dir %{ssletcdir}
%config (noreplace) %{ssletcdir}/openssl-1_1.cnf
%attr(700,root,root) %{ssletcdir}/private
%dir %{sslengcnf}
%dir %{sslengdef}

%dir %{_datadir}/ssl
%{_datadir}/ssl/misc
%{_bindir}/c_rehash-1_1
%{_bindir}/fips_standalone_hmac
%{_bindir}/openssl-1_1

%changelog
* Thu Sep 25 2025 lucas.mulling@suse.com
- Security fix: [bsc#1250232 CVE-2025-9230]
  * Fix out-of-bounds read & write in RFC 3211 KEK unwrap
  * Add patch openssl3-CVE-2025-9230.patch
* Tue Jul 22 2025 pmonreal@suse.com
- FIPS: Use the NID_X9_62_prime256v1 curve in ECDSA KAT test
  instead of NID_secp256k1. [bsc#1246697]
  * Add openssl-fips-ECDSA-KAT.patch
* Fri Feb 14 2025 angel.yankov@suse.com
- Fix bsc#1236771 - Non approved PBKDF parameters wrongly resulting as approved
  * Add openssl-FIPS-PBKDF-params.patch
* Thu Jan 30 2025 angel.yankov@suse.com
- Security fix: [bsc#1236136, CVE-2024-13176]
  * timing side-channel in the ECDSA signature computation
  * Add openssl-CVE-2024-13176.patch
* Thu Oct 17 2024 pmonreal@suse.com
- Security fix: [bsc#1220262, CVE-2023-50782]
  * Implicit rejection in PKCS#1 v1.5
  * Add openssl-CVE-2023-50782.patch
* Sat Oct 12 2024 pmonreal@suse.com
- FIPS: AES GCM external IV implementation [bsc#1228618]
  * Mark the standalone AES-GCM encryption with external IV
    as non-approved in the SLI.
  * Add openssl-1_1-ossl-sli-021-AES-GCM-external-IV.patch
* Mon Sep 16 2024 pmonreal@suse.com
- FIPS: Mark PBKDF2 and HKDF HMAC input keys with size >= 112 bits
  as approved in the SLI. [bsc#1228623]
  * openssl-1_1-ossl-sli-020-PBKDF2-HMAC-size-SLI.patch
* Mon Sep 16 2024 pmonreal@suse.com
- FIPS: Enforce KDF in FIPS style [bsc#1224270]
  * Add openssl-1_1-ossl-sli-019-Enforce-KDF.patch
* Fri Sep 13 2024 pmonreal@suse.com
- FIPS: Mark HKDF and TLSv1.3 KDF as approved in the SLI [bsc#1228619]
  * Add openssl-1_1-ossl-sli-018-TLS13-HKDF.patch
* Tue Sep  3 2024 pmonreal@suse.com
- FIPS: The X9.31 scheme is not approved for RSA signature
  operations in FIPS 186-5. [bsc#1224269]
  * Add openssl-1_1-ossl-sli-017-X9.31-sign.patch
* Fri Aug 16 2024 pmonreal@suse.com
- FIPS: Differentiate the PSS length requirements [bsc#1224275]
  * Add openssl-1_1-ossl-sli-016-PSS-length.patch
* Fri Aug 16 2024 pmonreal@suse.com
- FIPS: Mark sigGen and sigVer primitives as non-approved [bsc#1224272]
  * Add openssl-1_1-ossl-sli-015-sigver-hashing.patch
* Fri Aug 16 2024 pmonreal@suse.com
- FIPS: Disable PKCSv1.5 and shake in FIPS mode [bsc#1224271]
  * FIPS 186-5 Section 5.4 disallows RSA PKCSv1.5 signature
    operations with XOF.
  * Add openssl-1_1-ossl-sli-014-PKCSv1.5-and-shake.patch
* Fri Aug 16 2024 pmonreal@suse.com
- FIPS: Mark SHA1 as non-approved in the SLI [bsc#1224266]
  * Add openssl-1_1-ossl-sli-013-Mark-SHA1-unapproved.patch
* Fri Aug 16 2024 pmonreal@suse.com
- FIPS: DH FIPS selftest and safe prime group [bsc#1224264]
  * Add openssl-1_1-ossl-sli-012-DH-selftest-and-safe-prime-group.patch
* Mon Jul 22 2024 pmonreal@suse.com
- Build with no-afalgeng [bsc#1226463]
* Mon Jul 22 2024 pmonreal@suse.com
- Security fix: [bsc#1227138, CVE-2024-5535]
  * SSL_select_next_proto buffer overread
  * Add openssl-CVE-2024-5535.patch
* Fri Jun 28 2024 pmonreal@suse.com
- FIPS: Remove not needed FIPS DRBG files [bsc#1224268]
* Fri Jun 28 2024 pmonreal@suse.com
- FIPS: Add Pair-wise Consistency Test when generating DH key [bsc#1224265]
  * Add PCT in function crypto/dh/dh_key.c:generate_key() to meet
    assurance 5.6.2.1.4 of SP 800-56Arev3.
  * Add openssl-fips-DH-Pair-wise-Consistency.patch
* Fri Jun 28 2024 pmonreal@suse.com
- FIPS: Disallow non-approved KDF types [bsc#1224267]
  * Add openssl-1_1-ossl-sli-011-SSHKDF.patch
* Fri Jun 28 2024 pmonreal@suse.com
- FIPS: Disallow RSA sigVer with 1024 and ECDSA sigVer/keyVer P-192 [bsc#1224273]
  * Add openssl-1_1-ossl-sli-009-RSA-sigver.patch
  * Add openssl-1_1-ossl-sli-010-ECDSA-sigver-keyver.patch
* Wed Jun 26 2024 pmonreal@suse.com
- FIPS: DRBG component chaining [bsc#1224258]
  * Add prediction resistance and oversampling of the noise source.
  * Allow setting the FIPS error state if jitterentropy fails the
    health-tests.
  * Add patches:
  - openssl-1_1-FIPS-140-3-DRBG-prediction-resistance.patch
  - openssl-1_1-FIPS-140-3-DRBG-oversampling.patch
  - openssl-1_1-jitterentropy-error-state.patch
* Fri Jun 21 2024 pmonreal@suse.com
- FIPS: Align CRNGT_BUFSIZ with Jitter RNG output size [bsc#1224260]
  * Add openssl-1_1-FIPS-CRNGT_BUFSIZ.patch
* Thu Jun 20 2024 pmonreal@suse.com
- FIPS: Fix build warnings.
  * Rebase patches:
  - openssl-1.1.1-fips.patch
  - openssl-fips_selftest_upstream_drbg.patch
* Tue Jun 18 2024 mjambor@suse.com
- Fixed C99 violations in patches bsc1185319-FIPS-KAT-for-ECDSA.patch
  (need to for explicity typecast) and
  openssl-1_1-fips-list-only-approved-digest-and-pubkey-algorithms.patch
  (missing include) to allow the package to build with GCC 14.
  [boo#1225907]
* Thu Jun  6 2024 psimons@suse.com
- Apply "openssl-CVE-2024-4741.patch" to fix a use-after-free
  security vulnerability. Calling the function SSL_free_buffers()
  potentially caused memory to be accessed that was previously
  freed in some situations and a malicious attacker could attempt
  to engineer a stituation where this occurs to facilitate a
  denial-of-service attack. [CVE-2024-4741, bsc#1225551]
* Mon May  6 2024 otto.hollmann@suse.com
- Security fix: [bsc#1222548, CVE-2024-2511]
  * Fix unconstrained session cache growth in TLSv1.3
  * Add openssl-CVE-2024-2511.patch
* Mon Feb 12 2024 otto.hollmann@suse.com
- openssl-riscv64-config.patch: backport of riscv64 config support
* Wed Feb  7 2024 pmonreal@suse.com
- Enable running the regression tests in FIPS mode.
* Tue Jan 30 2024 otto.hollmann@suse.com
- Security fix: [bsc#1219243, CVE-2024-0727]
  * Add NULL checks where ContentInfo data can be NULL
  * Add openssl-CVE-2024-0727.patch
* Tue Jan 30 2024 otto.hollmann@suse.com
- Remove "Provides: openssl(cli)" because the executable has been renamed
  to openssl-1_1.
* Mon Jan 22 2024 otto.hollmann@suse.com
- Because OpenSSL 1.1.1 is no longer default, let's rename engine
  directories to contain version of OpenSSL and let unversioned for
  the default OpenSSL. [bsc#1194187, bsc#1207472, bsc#1218933]
  * /etc/ssl/engines.d ->  /etc/ssl/engines1.1.d
  * /etc/ssl/engdef.d -> /etc/ssl/engdef1.1.d
  * Update patches:
  - openssl-1_1-ossl-sli-002-ran-make-update.patch
  - openssl-1_1-use-include-directive.patch
* Wed Dec  6 2023 otto.hollmann@suse.com
- Set OpenSSL 3.0 as the default openssl [jsc#PED-6570]
  * For compatibility with OpenSSL 3.0, the OpenSSL master
    configuration file openssl.cnf has been renamed to
    openssl-1_1.cnf. The executables openssl, c_rehash, CA.pl and
    tsget.pl have been also renamed to openssl-1_1, c_rehash-1_1,
    CA-1_1.pl and tsget-1_1.pl, respectively.
  * Add openssl-1_1-devel as conflicting with libopenssl-3-devel
  * Add openssl-1_1-openssl-config.patch
* Thu Nov 23 2023 otto.hollmann@suse.com
- Skip SHA1 test in 20-test_dgst.t when in FIPS mode
  * Add openssl-Skip_SHA1-test-in-FIPS-mode.patch
* Mon Nov 13 2023 otto.hollmann@suse.com
- Security fix: [bsc#1216922, CVE-2023-5678]
  * Fix excessive time spent in DH check / generation with large Q
    parameter value.
  * Applications that use the functions DH_generate_key() to generate
    an X9.42 DH key may experience long delays. Likewise,
    applications that use DH_check_pub_key(), DH_check_pub_key_ex
    () or EVP_PKEY_public_check() to check an X9.42 DH key or X9.42
    DH parameters may experience long delays. Where the key or
    parameters that are being checked have been obtained from an
    untrusted source this may lead to a Denial of Service.
  * Add openssl-CVE-2023-5678.patch
* Thu Oct 19 2023 otto.hollmann@suse.com
- Performance enhancements for cryptography from OpenSSL 3.x
  [jsc#PED-5086, jsc#PED-3514]
  * Add patches:
  - openssl-ec-Use-static-linkage-on-nistp521-felem_-square-mul-.patch
  - openssl-ec-56-bit-Limb-Solinas-Strategy-for-secp384r1.patch
  - openssl-ec-powerpc64le-Add-asm-implementation-of-felem_-squa.patch
  - openssl-ecc-Remove-extraneous-parentheses-in-secp384r1.patch
  - openssl-powerpc-ecc-Fix-stack-allocation-secp384r1-asm.patch
  - openssl-Improve-performance-for-6x-unrolling-with-vpermxor-i.patch
* Wed Oct  4 2023 otto.hollmann@suse.com
- Displays "fips" in the version string (bsc#1215215)
  * Add openssl-1_1-fips-bsc1215215_fips_in_version_string.patch
* Tue Sep 12 2023 otto.hollmann@suse.com
- Update to 1.1.1w: (jsc#PED-6559)
  * Fix POLY1305 MAC implementation corrupting XMM registers on Windows.
  The POLY1305 MAC (message authentication code) implementation in OpenSSL
  does not save the contents of non-volatile XMM registers on Windows 64
  platform when calculating the MAC of data larger than 64 bytes. Before
  returning to the caller all the XMM registers are set to zero rather than
  restoring their previous content. The vulnerable code is used only on newer
  x86_64 processors supporting the AVX512-IFMA instructions.
  The consequences of this kind of internal application state corruption can
  be various - from no consequences, if the calling application does not
  depend on the contents of non-volatile XMM registers at all, to the worst
  consequences, where the attacker could get complete control of the
  application process. However given the contents of the registers are just
  zeroized so the attacker cannot put arbitrary values inside, the most likely
  consequence, if any, would be an incorrect result of some application
  dependent calculations or a crash leading to a denial of service.
  (CVE-2023-4807)
- Removed patches, already upstream
  * openssl-1_1-Fix-file-operations-in-c_rehash.patch
  * openssl-CVE-2022-0778-tests.patch
  * openssl-CVE-2022-0778.patch
  * openssl-CVE-2022-1292.patch
  * openssl-CVE-2022-2097.patch
  * openssl-CVE-2022-4304.patch
  * openssl-CVE-2022-4450-1of2.patch
  * openssl-CVE-2022-4450-2of2.patch
  * openssl-CVE-2023-0215-1of4.patch
  * openssl-CVE-2023-0215-2of4.patch
  * openssl-CVE-2023-0215-3of4.patch
  * openssl-CVE-2023-0215-4of4.patch
  * openssl-CVE-2023-0286.patch
  * openssl-CVE-2023-2650.patch
  * openssl-1_1-CVE-2023-3817.patch
  * openssl-Update-further-expiring-certificates.patch
- Renamed openssl-1_1-FIPS-default-RFC7919.patch
  to openssl-1_1-paramgen-default_to_rfc7919.patch
* Tue Aug  8 2023 otto.hollmann@suse.com
- Add missing FIPS patches from SLE:
  * Add patches:
  - bsc1185319-FIPS-KAT-for-ECDSA.patch
  - bsc1198207-FIPS-add-hash_hmac-drbg-kat.patch
  - openssl-1.1.1-fips-fix-memory-leaks.patch
  - openssl-1_1-FIPS-PBKDF2-KAT-requirements.patch
  - openssl-1_1-FIPS_drbg-rewire.patch
  - openssl-1_1-Zeroization.patch
  - openssl-1_1-fips-drbg-selftest.patch
  - openssl-1_1-fips-list-only-approved-digest-and-pubkey-algorithms.patch
  - openssl-1_1-jitterentropy-3.4.0.patch
  - openssl-1_1-ossl-sli-000-fix-build-error.patch
  - openssl-1_1-ossl-sli-001-fix-faults-preventing-make-update.patch
  - openssl-1_1-ossl-sli-002-ran-make-update.patch
  - openssl-1_1-ossl-sli-003-add-sli.patch
  - openssl-1_1-ossl-sli-004-allow-aes-xts-256.patch
  - openssl-1_1-ossl-sli-005-EC_group_order_bits.patch
  - openssl-1_1-ossl-sli-006-rsa_pkcs1_padding.patch
  - openssl-1_1-ossl-sli-007-pbkdf2-keylen.patch
  - openssl-1_1-ossl-sli-008-pbkdf2-salt_pass_iteration.patch
  - openssl-1_1-serialize-jitterentropy-calls.patch
  - openssl-1_1-shortcut-test_afalg_aes_cbc.patch
  - openssl-DH.patch
  - openssl-FIPS-KAT-before-integrity-tests.patch
  - openssl-fips-DH_selftest_shared_secret_KAT.patch
  - openssl-fips-kdf-hkdf-selftest.patch
  - openssl-kdf-selftest.patch
  - openssl-kdf-ssh-selftest.patch
  - openssl-kdf-tls-selftest.patch
  - openssl-s_client-check-ocsp-status.patch
  * Modify patches:
  - openssl-1.1.1-fips.patch
  - openssl-1_1-FIPS-fix-error-reason-codes.patch
  * Remove patches:
  - openssl-add_rfc3526_rfc7919.patch
  - openssl-fips-dont_run_FIPS_module_installed.patch
  - openssl-fips_fix_selftests_return_value.patch
  * Add build and runtime dependency on jitterentropy
- Pass over with spec-cleaner
* Tue Aug  1 2023 pmonreal@suse.com
- Security fix: (bsc#1213853, CVE-2023-3817)
  * Fix excessive time spent checking DH q parameter value
    (bsc#1213853, CVE-2023-3817). The function DH_check() performs
    various checks on DH parameters. After fixing CVE-2023-3446 it
    was discovered that a large q parameter value can also trigger
    an overly long computation during some of these checks. A
    correct q value, if present, cannot be larger than the modulus
    p parameter, thus it is unnecessary to perform these checks if
    q is larger than p. If DH_check() is called with such q parameter
    value, DH_CHECK_INVALID_Q_VALUE return flag is set and the
    computationally intensive checks are skipped.
  * Add openssl-1_1-CVE-2023-3817.patch
- Update to 1.1.1v:
  * Fix DH_check() excessive time with over sized modulus
    (bsc#1213487, CVE-2023-3446). The function DH_check() performs
    various checks on DH parameters. One of those checks confirms
    that the modulus ("p" parameter) is not too large. Trying to use
    a very large modulus is slow and OpenSSL will not normally use
    a modulus which is over 10,000 bits in length. However the
    DH_check() function checks numerous aspects of the key or
    parameters that have been supplied. Some of those checks use the
    supplied modulus value even if it has already been found to be
    too large. A new limit has been added to DH_check of 32,768 bits.
    Supplying a key/parameters with a modulus over this size will
    simply cause DH_check() to fail.
  * Update openssl.keyring with the OTC members that sign releases
  * Rebase openssl-1_1-openssl-config.patch
  * Remove security patches fixed upstream:
  - openssl-CVE-2023-3446.patch
  - openssl-CVE-2023-3446-test.patch
* Mon Jul 24 2023 otto.hollmann@suse.com
- Dont pass zero length input to EVP_Cipher because assembler
  optimized AES cannot handle zero size. [bsc#1213517]
  * Add openssl-dont-pass-zero-length-input-to-EVP_Cipher.patch
* Thu Jul 20 2023 pmonreal@suse.com
- Security fix: [bsc#1213487, CVE-2023-3446]
  * Fix DH_check() excessive time with over sized modulus.
  * The function DH_check() performs various checks on DH parameters.
    One of those checks confirms that the modulus ("p" parameter) is
    not too large. Trying to use a very large modulus is slow and
    OpenSSL will not normally use a modulus which is over 10,000 bits
    in length.
    However the DH_check() function checks numerous aspects of the
    key or parameters that have been supplied. Some of those checks
    use the supplied modulus value even if it has already been found
    to be too large.
    A new limit has been added to DH_check of 32,768 bits. Supplying
    a key/parameters with a modulus over this size will simply cause
    DH_check() to fail.
  * Add openssl-CVE-2023-3446.patch openssl-CVE-2023-3446-test.patch
* Wed Jun 14 2023 otto.hollmann@suse.com
- Security Fix: [bsc#1207534, CVE-2022-4304]
  * Reworked the Fix for the Timing Oracle in RSA Decryption
    The previous fix for this timing side channel turned out to cause
    a severe 2-3x performance regression in the typical use case
    compared to 1.1.1s.
  * Add openssl-CVE-2022-4304.patch
  * Removed patches:
  - openssl-CVE-2022-4304-1of2.patch
  - openssl-CVE-2022-4304-2of2.patch
  * Refreshed patches:
  - openssl-CVE-2023-0464.patch
  - openssl-CVE-2023-0465.patch
* Wed May 31 2023 otto.hollmann@suse.com
- Update to 1.1.1u:
  * Mitigate for the time it takes for `OBJ_obj2txt` to translate gigantic
    OBJECT IDENTIFIER sub-identifiers to canonical numeric text form.
    OBJ_obj2txt() would translate any size OBJECT IDENTIFIER to canonical
    numeric text form.  For gigantic sub-identifiers, this would take a very
    long time, the time complexity being O(n^2) where n is the size of that
    sub-identifier.  (CVE-2023-2650, bsc#1211430)
    To mitigitate this, `OBJ_obj2txt()` will only translate an OBJECT
    IDENTIFIER to canonical numeric text form if the size of that OBJECT
    IDENTIFIER is 586 bytes or less, and fail otherwise.
    The basis for this restriction is RFC 2578 (STD 58), section 3.5. OBJECT
    IDENTIFIER values, which stipulates that OBJECT IDENTIFIERS may have at
    most 128 sub-identifiers, and that the maximum value that each sub-
    identifier may have is 2^32-1 (4294967295 decimal).
    For each byte of every sub-identifier, only the 7 lower bits are part of
    the value, so the maximum amount of bytes that an OBJECT IDENTIFIER with
    these restrictions may occupy is 32 * 128 / 7, which is approximately 586
    bytes.
    Ref: https://datatracker.ietf.org/doc/html/rfc2578#section-3.5
  * Reworked the Fix for the Timing Oracle in RSA Decryption
    (CVE-2022-4304, bsc#1207534). The previous fix for this timing side
    channel turned out to cause a severe 2-3x performance regression in the
    typical use case compared to 1.1.1s. The new fix uses existing constant
    time code paths, and restores the previous performance level while fully
    eliminating all existing timing side channels. The fix was developed by
    Bernd Edlinger with testing support by Hubert Kario.
  * Corrected documentation of X509_VERIFY_PARAM_add0_policy() to mention that
    it does not enable policy checking. Thanks to David Benjamin for
    discovering this issue. (CVE-2023-0466, bsc#1209873)
  * Corrected documentation of X509_VERIFY_PARAM_add0_policy() to mention that
    it does not enable policy checking. Thanks to David Benjamin for
    discovering this issue. (CVE-2023-0466, bsc#1209873)
  * Fixed an issue where invalid certificate policies in leaf certificates are
    silently ignored by OpenSSL and other certificate policy checks are
    skipped for that certificate. A malicious CA could use this to
    deliberately assert invalid certificate policies in order to circumvent
    policy checking on the certificate altogether.
    (CVE-2023-0465, bsc#1209878)
  * Limited the number of nodes created in a policy tree to mitigate against
    CVE-2023-0464.  The default limit is set to 1000 nodes, which should be
    sufficient for most installations.  If required, the limit can be
    adjusted by setting the OPENSSL_POLICY_TREE_NODES_MAX build time define
    to a desired maximum number of nodes or zero to allow unlimited growth.
    (CVE-2023-0464, bsc#1209624)
  * Rebased patch openssl-1_1-openssl-config.patch
  * Removed patches:
  - openssl-CVE-2023-0464.patch
  - openssl-CVE-2023-0465.patch
  - openssl-CVE-2023-0466.patch
  * Update openssl.keyring with key
    A21F AB74 B008 8AA3 6115 2586 B8EF 1A6B A9DA 2D5C (Tomas Mraz)
* Wed May 31 2023 otto.hollmann@suse.com
- Update further expiring certificates that affect tests [bsc#1201627]
  * Add openssl-Update-further-expiring-certificates.patch
* Mon May 29 2023 pmonreal@suse.com
- FIPS: Merge libopenssl1_1-hmac package into the library [bsc#1185116]
* Mon May 22 2023 otto.hollmann@suse.com
- Security Fix: [CVE-2023-2650, bsc#1211430]
  * Possible DoS translating ASN.1 object identifiers
  * Add openssl-CVE-2023-2650.patch
* Mon Apr  3 2023 otto.hollmann@suse.com
- Security Fix: [CVE-2023-0465, bsc#1209878]
  * Invalid certificate policies in leaf certificates are silently ignored
  * Add openssl-CVE-2023-0465.patch
- Security Fix: [CVE-2023-0466, bsc#1209873]
  * Certificate policy check not enabled
  * Add openssl-CVE-2023-0466.patch
* Fri Mar 24 2023 otto.hollmann@suse.com
- Security Fix: [CVE-2023-0464, bsc#1209624]
  * Excessive Resource Usage Verifying X.509 Policy Constraints
  * Add openssl-CVE-2023-0464.patch
* Tue Mar  7 2023 otto.hollmann@suse.com
- FIPS: Service-level indicator [bsc#1208998]
  * Add additional check required by FIPS 140-3. Minimum values for
    PBKDF2 are: 112 bits for key, 128 bits for salt, 1000 for
    iteration count and 20 characters for password.
  * Add openssl-1_1-ossl-sli-008-pbkdf2-salt_pass_iteration.patch
* Wed Feb  8 2023 otto.hollmann@suse.com
- FIPS: Serialize jitterentropy calls [bsc#1207994]
  * Add openssl-1_1-serialize-jitterentropy-calls.patch
* Tue Feb  7 2023 otto.hollmann@suse.com
- Update to 1.1.1t:
  * Fixed X.400 address type confusion in X.509 GeneralName.
    There is a type confusion vulnerability relating to X.400 address processing
    inside an X.509 GeneralName. X.400 addresses were parsed as an ASN1_STRING
    but subsequently interpreted by GENERAL_NAME_cmp as an ASN1_TYPE. This
    vulnerability may allow an attacker who can provide a certificate chain and
    CRL (neither of which need have a valid signature) to pass arbitrary
    pointers to a memcmp call, creating a possible read primitive, subject to
    some constraints. Refer to the advisory for more information. Thanks to
    David Benjamin for discovering this issue. [bsc#1207533, CVE-2023-0286]
    This issue has been fixed by changing the public header file definition of
    GENERAL_NAME so that x400Address reflects the implementation. It was not
    possible for any existing application to successfully use the existing
    definition; however, if any application references the x400Address field
    (e.g. in dead code), note that the type of this field has changed. There is
    no ABI change.
  * Fixed Use-after-free following BIO_new_NDEF.
    The public API function BIO_new_NDEF is a helper function used for
    streaming ASN.1 data via a BIO. It is primarily used internally to OpenSSL
    to support the SMIME, CMS and PKCS7 streaming capabilities, but may also
    be called directly by end user applications.
    The function receives a BIO from the caller, prepends a new BIO_f_asn1
    filter BIO onto the front of it to form a BIO chain, and then returns
    the new head of the BIO chain to the caller. Under certain conditions,
    for example if a CMS recipient public key is invalid, the new filter BIO
    is freed and the function returns a NULL result indicating a failure.
    However, in this case, the BIO chain is not properly cleaned up and the
    BIO passed by the caller still retains internal pointers to the previously
    freed filter BIO. If the caller then goes on to call BIO_pop() on the BIO
    then a use-after-free will occur. This will most likely result in a crash.
    [bsc#1207536, CVE-2023-0215]
  * Fixed Double free after calling PEM_read_bio_ex.
    The function PEM_read_bio_ex() reads a PEM file from a BIO and parses and
    decodes the "name" (e.g. "CERTIFICATE"), any header data and the payload
    data. If the function succeeds then the "name_out", "header" and "data"
    arguments are populated with pointers to buffers containing the relevant
    decoded data. The caller is responsible for freeing those buffers. It is
    possible to construct a PEM file that results in 0 bytes of payload data.
    In this case PEM_read_bio_ex() will return a failure code but will populate
    the header argument with a pointer to a buffer that has already been freed.
    If the caller also frees this buffer then a double free will occur. This
    will most likely lead to a crash.
    The functions PEM_read_bio() and PEM_read() are simple wrappers around
    PEM_read_bio_ex() and therefore these functions are also directly affected.
    These functions are also called indirectly by a number of other OpenSSL
    functions including PEM_X509_INFO_read_bio_ex() and
    SSL_CTX_use_serverinfo_file() which are also vulnerable. Some OpenSSL
    internal uses of these functions are not vulnerable because the caller does
    not free the header argument if PEM_read_bio_ex() returns a failure code.
    [bsc#1207538, CVE-2022-4450]
    [Kurt Roeckx, Matt Caswell]
  * Fixed Timing Oracle in RSA Decryption.
    A timing based side channel exists in the OpenSSL RSA Decryption
    implementation which could be sufficient to recover a plaintext across
    a network in a Bleichenbacher style attack. To achieve a successful
    decryption an attacker would have to be able to send a very large number
    of trial messages for decryption. The vulnerability affects all RSA padding
    modes: PKCS#1 v1.5, RSA-OEAP and RSASVE.
    [bsc#1207534, CVE-2022-4304]
  * Rebased openssl-1_1-openssl-config.patch
  * Update openssl.keyring with key
    7953 AC1F BC3D C8B3 B292 393E D5E9 E43F 7DF9 EE8C (Richard Levitte)
* Wed Jan 25 2023 pmonreal@suse.com
- Security Fix: [bsc#1207533, CVE-2023-0286]
  * Fix X.400 address type confusion in X.509 GENERAL_NAME_cmp
    for x400Address
  * Add openssl-CVE-2023-0286.patch
* Wed Jan 25 2023 pmonreal@suse.com
- Security Fix: [bsc#1207536, CVE-2023-0215]
  * Use-after-free following BIO_new_NDEF()
  * Add patches:
  - openssl-CVE-2023-0215-1of4.patch
  - openssl-CVE-2023-0215-2of4.patch
  - openssl-CVE-2023-0215-3of4.patch
  - openssl-CVE-2023-0215-4of4.patch
* Wed Jan 25 2023 pmonreal@suse.com
- Security Fix: [bsc#1207538, CVE-2022-4450]
  * Double free after calling PEM_read_bio_ex()
  * Add patches:
  - openssl-CVE-2022-4450-1of2.patch
  - openssl-CVE-2022-4450-2of2.patch
* Wed Jan 25 2023 pmonreal@suse.com
- Security Fix: [bsc#1207534, CVE-2022-4304]
  * Timing Oracle in RSA Decryption
  * Add patches:
  - openssl-CVE-2022-4304-1of2.patch
  - openssl-CVE-2022-4304-2of2.patch
* Fri Dec  2 2022 otto.hollmann@suse.com
- POWER10 performance enhancements for cryptography [jsc#PED-512]
  * openssl-1_1-AES-GCM-performance-optimzation-with-stitched-method.patch
  * openssl-1_1-Fixed-counter-overflow.patch
  * openssl-1_1-chacha20-performance-optimizations-for-ppc64le-with-.patch
  * openssl-1_1-Fixed-conditional-statement-testing-64-and-256-bytes.patch
  * openssl-1_1-Fix-AES-GCM-on-Power-8-CPUs.patch
* Mon Nov 21 2022 pmonreal@suse.com
- FIPS: Service-level indicator [bsc#1190651]
  * Mark PBKDF2 with key shorter than 112 bits as non-approved
  * Add openssl-1_1-ossl-sli-007-pbkdf2-keylen.patch
* Wed Nov 16 2022 pmonreal@suse.com
- FIPS: Service-level indicator [bsc#1190651]
  * Consider RSA siggen/sigver with PKCS1 padding also approved
  * Add openssl-1_1-ossl-sli-006-rsa_pkcs1_padding.patch
* Wed Nov 16 2022 pmonreal@suse.com
- FIPS: Service-level indicator [bsc#1190651]
  * Return the correct indicator for a given EC group order bits
  * Add openssl-1_1-ossl-sli-005-EC_group_order_bits.patch
* Wed Nov  2 2022 otto.hollmann@suse.com
- Updated openssl.keyring with key A21FAB74B0088AA361152586B8EF1A6BA9DA2D5C
- Update to 1.1.1s:
  * Fixed a regression introduced in 1.1.1r version not refreshing the
    certificate data to be signed before signing the certificate.
- Update to 1.1.1r:
  * Fixed the linux-mips64 Configure target which was missing the
    SIXTY_FOUR_BIT bn_ops flag. This was causing heap corruption on that
    platform.
  * Fixed a strict aliasing problem in bn_nist. Clang-14 optimisation was
    causing incorrect results in some cases as a result.
  * Fixed SSL_pending() and SSL_has_pending() with DTLS which were failing to
    report correct results in some cases
  * Fixed a regression introduced in 1.1.1o for re-signing certificates with
    different key sizes
  * Added the loongarch64 target
  * Fixed a DRBG seed propagation thread safety issue
  * Fixed a memory leak in tls13_generate_secret
  * Fixed reported performance degradation on aarch64. Restored the
    implementation prior to commit 2621751 ("aes/asm/aesv8-armx.pl: avoid
    32-bit lane assignment in CTR mode") for 64bit targets only, since it is
    reportedly 2-17%% slower and the silicon errata only affects 32bit targets.
    The new algorithm is still used for 32 bit targets.
  * Added a missing header for memcmp that caused compilation failure on some
    platforms
* Fri Oct 28 2022 pmonreal@suse.com
- FIPS: Add a missing dependency on jitterentropy-devel for
  libopenssl-1_1-devel [bsc#1202148]
* Wed Oct  5 2022 otto.hollmann@suse.com
- FIPS: OpenSSL service-level indicator - Allow AES XTS 256 [bsc#1190651]
  * Add patches: openssl-1_1-ossl-sli-004-allow-aes-xts-256.patch
* Fri Sep 16 2022 pmonreal@suse.com
- FIPS: Default to RFC-7919 groups for genparam and dhparam
  * Add openssl-1_1-FIPS-default-RFC7919.patch [bsc#1180995]
* Fri Sep  9 2022 otto.hollmann@suse.com
- FIPS: list only FIPS approved digest and public key algorithms
  [bsc#1121365, bsc#1190888, bsc#1193859, bsc#1198471, bsc#1198472]
  * Add openssl-1_1-fips-list-only-approved-digest-and-pubkey-algorithms.patch
  * Disabled test 15-test_ec.t in FIPS mode
* Fri Sep  2 2022 pmonreal@suse.com
- FIPS: Add KAT for the RAND_DRBG implementation [bsc#1203069]
  * Add openssl-1_1-fips-drbg-selftest.patch
* Fri Sep  2 2022 pmonreal@suse.com
- FIPS: openssl: RAND api should call into FIPS DRBG [bsc#1201293]
  * The FIPS_drbg implementation is not FIPS validated anymore. To
    provide backwards compatibility for applications that need FIPS
    compliant RNG number generation and use FIPS_drbg_generate,
    this function was re-wired to call the FIPS validated DRBG
    instance instead through the RAND_bytes() call.
  * Add openssl-1_1-FIPS_drbg-rewire.patch
* Thu Sep  1 2022 otto.hollmann@suse.com
- Fix memory leaks introduced by openssl-1.1.1-fips.patch [bsc#1203046]
  * Add patch openssl-1.1.1-fips-fix-memory-leaks.patch
* Tue Aug 30 2022 otto.hollmann@suse.com
- FIPS: OpenSSL: Port openssl to use jitterentropy
  [bsc#1202148, jsc#SLE-24941]
  * Add openssl-1_1-jitterentropy-3.4.0.patch
  * Add build dependency on jitterentropy-devel >= 3.4.0 and
    libjitterentropy3 >= 3.4.0
* Thu Jul 21 2022 pmonreal@suse.com
- FIPS: OpenSSL Provide a service-level indicator [bsc#1190651]
  * Add patches:
  - openssl-1_1-ossl-sli-000-fix-build-error.patch
  - openssl-1_1-ossl-sli-001-fix-faults-preventing-make-update.patch
  - openssl-1_1-ossl-sli-002-ran-make-update.patch
  - openssl-1_1-ossl-sli-003-add-sli.patch
* Thu Jul 21 2022 pmonreal@suse.com
- FIPS: Add zeroization of temporary variables to the hmac integrity
  function FIPSCHECK_verify(). [bsc#1190653]
  * Add openssl-1_1-Zeroization.patch
* Thu Jul  7 2022 jsikes@suse.com
- update to 1.1.1q:
  * [CVE-2022-2097, bsc#1201099]
  * Addresses situations where AES OCB fails to encrypt some bytes
* Sun Jul  3 2022 jsikes@suse.com
- Encrypt the sixteen bytes that were unencrypted in some circumstances
  on 32-bit x86 platforms.
  * [bsc#1201099, CVE-2022-2097]
  * added openssl-CVE-2022-2097.patch
* Thu Jun 23 2022 jsikes@suse.com
- Update to 1.1.1p:
  * bsc#1185637 - updated certificates required for testing that failed
    when date is later than 1 June 2022
  - removed openssl-update_expired_certificates.patch
  * [bsc#1200550, CVE-2022-2068] - more shell code injection issues in c_rehash
* Fri Jun 17 2022 jsikes@suse.com
- Added openssl-1_1-Fix-file-operations-in-c_rehash.patch
  * bsc#1200550
  * CVE-2022-2068
  * Fixed more shell code injection issues in c_rehash
* Thu Jun  2 2022 jsikes@suse.com
- Update to 1.1.1o: [CVE-2022-1292, bsc#1199166]
  * Fixed a bug in the c_rehash script which was not properly sanitising
    shell metacharacters to prevent command injection.
  * Rebased openssl-s390x-assembly-pack-add-OPENSSL_s390xcap-environment.patch
  * Rebased openssl-s390x-assembly-pack-add-support-for-pcc-and-kma-inst.patch
- Added openssl-update_expired_certificates.patch
  * Openssl failed tests because of expired certificates.
  * bsc#1185637
  * Sourced from https://github.com/openssl/openssl/pull/18446/commits
* Thu Jun  2 2022 jsikes@suse.com
- Added openssl-update_expired_certificates.patch
  * Openssl failed tests because of expired certificates.
  * bsc#1185637
  * Sourced from https://github.com/openssl/openssl/pull/18446/commits
* Mon May 30 2022 jsikes@suse.com
- Security fix: [bsc#1199166, CVE-2022-1292]
  * Added: openssl-CVE-2022-1292.patch
  * properly sanitise shell metacharacters in c_rehash script.
* Mon May  2 2022 jsikes@suse.com
- FIPS: Added signature verification test to
    bsc1185319-FIPS-KAT-for-ECDSA.patch
* Thu Apr 21 2022 jsikes@suse.com
- FIPS: add bsc1185319-FIPS-KAT-for-ECDSA.patch
  * Known answer test for ECDSA
  * bsc#1185319
- FIPS: add bsc1198207-FIPS-add-hash_hmac-drbg-kat.patch
  * Enable tests for Deterministic Random Bit Generator
  * bsc#1198207
- Bypass a regression test that fails in FIPS mode.
  * [openssl-1_1-shortcut-test_afalg_aes_cbc.patch]
* Fri Mar 18 2022 pmonreal@suse.com
- FIPS: Additional PBKDF2 requirements for KAT [bsc#1197280]
  * The IG 10.3.A and SP800-132 require some minimum parameters for
    the salt length, password length and iteration count. These
    parameters should be also used in the KAT.
  * Add openssl-1_1-FIPS-PBKDF2-KAT-requirements.patch
* Tue Mar 15 2022 pmonreal@suse.com
- Security Fix: [bsc#1196877, CVE-2022-0778]
  * Infinite loop in BN_mod_sqrt() reachable when parsing certificates
  * Add openssl-CVE-2022-0778.patch openssl-CVE-2022-0778-tests.patch
* Tue Mar 15 2022 pmonreal@suse.com
- Added openssl-1_1-use-include-directive.patch so that the default
  /etc/ssl/openssl.cnf file will include any configuration files that
  other packages might place into /etc/ssl/engines.d/ and
  /etc/ssl/engdef.d/ This is a fix for bsc#1004463 where scripting was
  being used to modify the openssl.cnf file. The scripting would fail
  if either the default openssl.cnf file, or the sample openssl-ibmca
  configuration file would be changed by upstream.
- Updated spec file to create the two new necessary directores for
  the above patch. [bsc#1194187, bsc#1004463]
* Thu Mar 10 2022 jsikes@suse.com
- FIPS: add openssl-1_1-fips-bsc1190652_release_num_in_version_string.patch
  * bsc#1190652 - Provide a service to output module name/identifier
    and version
* Fri Mar  4 2022 pmonreal@suse.com
- Security fix: [bsc#1192820, CVE-2002-20001]
  * Fix DHEATER: The Diffie-Hellman Key Agreement Protocol allows
    remote attackers (from the client side) to send arbitrary
    numbers that are actually not public keys, and trigger
    expensive server-side DHE calculation.
  * Stop recommending the DHE in SSL_DEFAULT_SUSE_CIPHER_LIST
  * Rebase openssl-DEFAULT_SUSE_cipher.patch
* Tue Mar  1 2022 pmonreal@suse.com
- FIPS: Reintroduce the FFC and ECC checks in openssl-DH.patch
  that were removed in the update to 1.1.1l [bsc#1185313]
* Tue Mar  1 2022 pmonreal@suse.com
- FIPS: Fix sn_objs and ln_objs in crypto/objects/obj_mac.num
  * Rebase openssl-DH.patch [bsc#1194327]
- Merge openssl-keep_EVP_KDF_functions_version.patch into
  openssl-1.1.1-evp-kdf.patch
- Add function codes for pbkdf2, hkdf, tls and ssh selftests.
  Rebase patches:
  * openssl-fips-kdf-hkdf-selftest.patch
  * openssl-kdf-selftest.patch
  * openssl-kdf-ssh-selftest.patch
  * openssl-kdf-tls-selftest.patch
* Fri Feb 11 2022 pmonreal@suse.com
- Pull libopenssl-1_1 when updating openssl-1_1 with the same
  version. [bsc#1195792]
* Fri Feb  4 2022 pmonreal@suse.com
- FIPS: Fix function and reason error codes [bsc#1182959]
  * Add openssl-1_1-FIPS-fix-error-reason-codes.patch
* Thu Feb  3 2022 pmonreal@suse.com
- Enable zlib compression support [bsc#1195149]
* Thu Feb  3 2022 pmonreal@suse.com
- Remove the openssl-has-RSA_get0_pss_params provides as it is
  now fixed in the nodejs16 side [bsc#1192489]
* Wed Feb  2 2022 pmonreal@suse.com
- FIPS: Move the HMAC-SHA2-256 used for integrity test [bsc#1185320]
  * Add openssl-FIPS-KAT-before-integrity-tests.patch
* Wed Feb  2 2022 pmonreal@suse.com
- FIPS: Add missing KAT for HKDF/TLS 1.3/IPSEC IKEv2 [bsc#1192442]
  * Add openssl-fips-kdf-hkdf-selftest.patch
* Fri Jan 28 2022 pmonreal@suse.com
- Add a provides for openssl-has-RSA_get0_pss_params as required by
  nodejs16. [bsc#1192489]
* Thu Jan 13 2022 pmonreal@suse.com
- Backport cryptographic improvements from OpenSSL 3 [jsc#SLE-19742]
  * Optimize RSA on armv8: openssl-1_1-Optimize-RSA-armv8.patch
  * Optimize AES-XTS mode for aarch64:
    openssl-1_1-Optimize-AES-XTS-aarch64.patch
  * Optimize AES-GCM for uarchs with unroll and new instructions:
    openssl-1_1-Optimize-AES-GCM-uarchs.patch
* Tue Dec 28 2021 pmonreal@suse.com
- Update to 1.1.1m:
  * Avoid loading of a dynamic engine twice.
  * Prioritise DANE TLSA issuer certs over peer certs
- Rebased patches:
  * openssl-1.1.1-evp-kdf.patch
  * openssl-1.1.1-system-cipherlist.patch
* Thu Dec 16 2021 pmonreal@suse.com
- Add support for livepatches (jsc#SLE-20049).
- Generate ipa-clones tarball artifact when livepatching is enabled.
* Wed Nov 24 2021 pmonreal@suse.com
- POWER10 performance enhancements for cryptography [jsc#SLE-18136]
  * openssl-1_1-Optimize-ppc64.patch
* Mon Nov  1 2021 dcermak@suse.com
- Drop openssl-no-date.patch
  Upstream added support for reproducible builds via SOURCE_DATE_EPOCH in
  https://github.com/openssl/openssl/commit/8a8d9e190533ee41e8b231b18c7837f98f1ae231
  thereby making this patch obsolete as builds *should* still be reproducible.
* Wed Oct 20 2021 jsikes@suse.com
- Import centralized crypto policy profile from Factory [jsc#SLE-15832]
  * openssl-1.1.1-system-cipherlist.patch
  * openssl-1_1-disable-test_srp-sslapi.patch
  * openssl-1_1-seclevel.patch
  * openssl-1_1-use-seclevel2-in-tests.patch
* Sun Sep 12 2021 jsikes@suse.com
- Update to openssl-1.1.1l ('L' as in 'Lima') for SUSE-SLE-15-SP4
  * jsc#SLE-19640, jsc#PM-2816
- Changes in 1.1.1l:
  * [bsc#1189520, CVE-2021-3711] Fixed an SM2 Decryption Buffer Overflow.
  * [bsc#1189521, CVE-2021-3712] Fixed various read buffer overruns
    processing ASN.1 strings
- Changes in 1.1.1k
  * Fixed a problem with verifying a certificate chain when using
    the X509_V_FLAG_X509_STRICT flag. This flag enables additional
    security checks of the certificates present in a certificate
    chain. It is not set by default. ([CVE-2021-3450])
    [bsc#1183851]
  * Fixed an issue where an OpenSSL TLS server may crash if sent a
    maliciously crafted renegotiation ClientHello message from a
    client. If a TLSv1.2 renegotiation ClientHello omits the
    signature_algorithms extension (where it was present in the
    initial ClientHello), but includes a signature_algorithms_cert
    extension then a NULL pointer dereference will result, leading
    to a crash and a denial of service attack.
    A server is only vulnerable if it has TLSv1.2 and renegotiation
    enabled (which is the default configuration). OpenSSL TLS
    clients are not impacted by this issue. ([CVE-2021-3449])
    [bsc#1183852]
- Changes in 1.1.1j
  * Fixed the X509_issuer_and_serial_hash() function. It attempts
    to create a unique hash value based on the issuer and serial
    number data contained within an X509 certificate. However it
    was failing to correctly handle any errors that may occur
    while parsing the issuer field [bsc#1182331, CVE-2021-23841]
  * Fixed the RSA_padding_check_SSLv23() function and the
    RSA_SSLV23_PADDING padding mode to correctly check for
    rollback attacks.
  * Fixed the EVP_CipherUpdate, EVP_EncryptUpdate and
    EVP_DecryptUpdate functions. Previously they could overflow the
    output length argument in some cases where the input length is
    close to the maximum permissable length for an integer on the
    platform. In such cases the return value from the function call
    would be 1 (indicating success), but the output length value
    would be negative. This could cause applications to behave
    incorrectly or crash. [bsc#1182333, CVE-2021-23840]
  * Fixed SRP_Calc_client_key so that it runs in constant time.
    The previous implementation called BN_mod_exp without setting
    BN_FLG_CONSTTIME. This could be exploited in a side channel
    attack to recover the password. Since the attack is local host
    only this is outside of the current OpenSSL threat model and
    therefore no CVE is assigned.
- Changes in 1.1.1i
  * Fixed NULL pointer deref in GENERAL_NAME_cmp
  * bsc#1179491, CVE-2020-1971
- Changes in 1.1.1h
  * Disallow explicit curve parameters in verifications chains when X509_V_FLAG_X509_STRICT is used
  * Enable 'MinProtocol' and 'MaxProtocol' to configure both TLS and DTLS contexts
- Changes in 1.1.1g
  * Fixed segmentation fault in SSL_check_chain (CVE-2020-1967, bsc#1169407)
    Server or client applications that call the SSL_check_chain() function
    during or after a TLS 1.3 handshake may crash due to a NULL pointer
    dereference as a result of incorrect handling of the
    "signature_algorithms_cert" TLS extension. The crash occurs if an invalid
    or unrecognised signature algorithm is received from the peer. This could
    be exploited by a malicious peer in a Denial of Service attack.
  * Added AES consttime code for no-asm configurations
    an optional constant time support for AES was added
    when building openssl for no-asm.
- Changes in 1.1.1f
  * Revert the unexpected EOF reporting via SSL_ERROR_SSL
- Changes in 1.1.1e
  * Properly detect EOF while reading in libssl. Previously if we hit an EOF
    while reading in libssl then we would report an error back to the
    application (SSL_ERROR_SYSCALL) but errno would be 0. We now add
    an error to the stack (which means we instead return SSL_ERROR_SSL) and
    therefore give a hint as to what went wrong.
  * Check that ed25519 and ed448 are allowed by the security level. Previously
    signature algorithms not using an MD were not being checked that they were
    allowed by the security level.
  * Fixed SSL_get_servername() behaviour. The behaviour of SSL_get_servername()
    was not quite right. The behaviour was not consistent between resumption
    and normal handshakes, and also not quite consistent with historical
    behaviour. The behaviour in various scenarios has been clarified and
    it has been updated to make it match historical behaviour as closely as
    possible.
  * Corrected the documentation of the return values from the EVP_DigestSign*
    set of functions.  The documentation mentioned negative values for some
    errors, but this was never the case, so the mention of negative values
    was removed.
  * Added a new method to gather entropy on VMS, based on SYS$GET_ENTROPY.
    The presence of this system service is determined at run-time.
  * Added newline escaping functionality to a filename when using openssl dgst.
    This output format is to replicate the output format found in the '*sum'
    checksum programs. This aims to preserve backward compatibility.
  * Print all values for a PKCS#12 attribute with 'openssl pkcs12', not just
    the first value.
- Dropped the following patches:
  * openssl-1_1-CVE-2019-1551.patch
  * openssl-fips-dont_run_FIPS_module_installed.patch
  * openssl-fips_fix_selftests_return_value.patch
  * openssl-CVE-2020-1967.patch
  * openssl-CVE-2020-1967-test1.patch
  * openssl-CVE-2020-1967-test2.patch
  * openssl-CVE-2020-1967-test3.patch
  * openssl-CVE-2020-1971.patch
  * openssl-CVE-2021-23840.patch
  * openssl-CVE-2021-23841.patch
  * openssl-1_1-CVE-2021-3449-NULL_pointer_deref_in_signature_algorithms.patch
  * openssl-1.1.1-fips_list_ciphers.patch
  * CVE-2021-3711-1-Correctly-calculate-the-length-of-SM2-plaintext-give.patch
  * CVE-2021-3711-2-Extend-tests-for-SM2-decryption.patch
  * CVE-2021-3711-3-Check-the-plaintext-buffer-is-large-enough-when-decr.patch
  * CVE-2021-3712-Fix-read-buffer-overrun-in-X509_aux_print.patch
  * CVE-2021-3712-other-ASN1_STRING-issues.patch
- Rebased the following patches:
  * 0002-crypto-chacha-asm-chacha-s390x.pl-add-vx-code-path.patch
  * 0003-crypto-poly1305-asm-poly1305-s390x.pl-add-vx-code-pa.patch
  * openssl-1.1.0-issuer-hash.patch
  * openssl-1.1.0-no-html.patch
  * openssl-1.1.1-evp-kdf.patch
  * openssl-1.1.1-fips-crng-test.patch
  * openssl-1.1.1-fips-post-rand.patch
  * openssl-1.1.1-fips.patch
  * openssl-1.1.1-ssh-kdf.patch
  * openssl-DH.patch
  * openssl-Enable-curve-spefific-ECDSA-implementations-via-EC_M.patch
  * openssl-assembly-pack-accelerate-scalar-multiplication.patch
  * openssl-fips_selftest_upstream_drbg.patch
  * openssl-kdf-selftest.patch
  * openssl-kdf-ssh-selftest.patch
  * openssl-kdf-tls-selftest.patch
  * openssl-s390x-assembly-pack-accelerate-ECDSA.patch
  * openssl-s390x-assembly-pack-accelerate-X25519-X448-Ed25519-and-Ed448.patch
  * openssl-s390x-assembly-pack-add-OPENSSL_s390xcap-environment.patch
  * openssl-s390x-fix-x448-and-x448-test-vector-ctime-for-x25519-and-x448.patch
* Sun Aug 29 2021 jsikes@suse.com
- Other OpenSSL functions that print ASN.1 data have been found to assume that
  the ASN1_STRING byte array will be NUL terminated, even though this is not
  guaranteed for strings that have been directly constructed. Where an application
  requests an ASN.1 structure to be printed, and where that ASN.1 structure
  contains ASN1_STRINGs that have been directly constructed by the application
  without NUL terminating the "data" field, then a read buffer overrun can occur.
  * CVE-2021-3712 continued
  * bsc#1189521
  * Add CVE-2021-3712-other-ASN1_STRING-issues.patch
  * Sourced from openssl-CVE-2021-3712.tar.bz2 posted on bsc-1189521
    2021-08-24 00:47 PDT by Marcus Meissner
* Wed Aug 18 2021 jsikes@suse.com
- A bug in the implementation of the SM2 decryption code means that the
  calculation of the buffer size required to hold the plaintext returned by the
  first call to EVP_PKEY_decrypt() can be smaller than the actual size required by
  the second call. This can lead to a buffer overflow when EVP_PKEY_decrypt() is
  called by the application a second time with a buffer that is too small.
  * CVE-2021-3711
  * bsc#1189520
  * Add:
    CVE-2021-3711-1-Correctly-calculate-the-length-of-SM2-plaintext-give.patch
    CVE-2021-3711-2-Extend-tests-for-SM2-decryption.patch
    CVE-2021-3711-3-Check-the-plaintext-buffer-is-large-enough-when-decr.patch
- The function X509_aux_print() has a bug which may cause a read buffer overrun
  when printing certificate details. A malicious actor could construct a
  certificate to deliberately hit this bug, which may result in a crash of the
  application (causing a Denial of Service attack).
  * CVE-2021-3712
  * bsc#1189521
  * Add CVE-2021-3712-Fix-read-buffer-overrun-in-X509_aux_print.patch
* Wed Apr  7 2021 jsikes@suse.com
- Don't list disapproved cipher algorithms while in FIPS mode
  * openssl-1.1.1-fips_list_ciphers.patch
  * bsc#1161276
* Tue Mar 23 2021 jsikes@suse.com
- Fix NULL pointer deref in signature_algorithms
  * CVE-2021-3449
  * bsc#1183852
  * Add openssl-1_1-CVE-2021-3449-NULL_pointer_deref_in_signature_algorithms.patch
* Wed Mar  3 2021 pmonreal@suse.com
- Security fixes:
  * Integer overflow in CipherUpdate: Incorrect SSLv2 rollback
    protection [bsc#1182333, CVE-2021-23840]
  * Null pointer deref in X509_issuer_and_serial_hash()
    [bsc#1182331, CVE-2021-23841]
- Add openssl-CVE-2021-23840.patch openssl-CVE-2021-23841.patch
* Tue Mar  2 2021 pmonreal@suse.com
- Fix unresolved error codes [bsc#1182959]
- Update openssl-1.1.1-fips.patch
* Tue Dec  8 2020 vcizek@suse.com
- Fix EDIPARTYNAME NULL pointer dereference
  (CVE-2020-1971, bsc#1179491)
  * add openssl-CVE-2020-1971.patch
* Thu Oct  8 2020 pmonreal@suse.com
- Restore private key check in EC_KEY_check_key [bsc#1177479]
  * Update openssl-DH.patch
* Tue Sep  8 2020 vcizek@suse.com
- Add shared secret KAT to FIPS DH selftest [bsc#1175844]
  * add openssl-fips-DH_selftest_shared_secret_KAT.patch
* Thu Aug 27 2020 pmonreal@suse.com
- Include ECDH/DH Requirements from SP800-56Arev3 [bsc#1175844, bsc#1173470]
- Add patches:
  * openssl-DH.patch
  * openssl-kdf-selftest.patch
  * openssl-kdf-tls-selftest.patch
  * openssl-kdf-ssh-selftest.patch
* Mon Apr 20 2020 pmonrealgonzalez@suse.com
- Security fix: [bsc#1169407, CVE-2020-1967]
  * Segmentation fault in SSL_check_chain: Server applications that
    call the SSL_check_chain() function during or after a TLS handshake
    may crash due to a NULL pointer dereference as a result of incorrect
    handling of the signature_algorithms_cert TLS extension.
- Add patches:
  * openssl-CVE-2020-1967.patch
  * openssl-CVE-2020-1967-test1.patch
  * openssl-CVE-2020-1967-test2.patch
  * openssl-CVE-2020-1967-test3.patch
* Fri Mar 20 2020 vcizek@suse.com
- openssl dgst: default to SHA256 only when called without a digest,
  not when it couldn't be found (bsc#1166189)
  * add openssl-unknown_dgst.patch
* Wed Mar  4 2020 vcizek@suse.com
- Limit the DRBG selftests to not deplete entropy (bsc#1165274)
  * update openssl-fips_selftest_upstream_drbg.patch
* Wed Feb 26 2020 vcizek@suse.com
- Run FIPS DRBG selftests against the crypto/rand DRBG implementation
  (bsc#1164557)
  * add openssl-fips_selftest_upstream_drbg.patch
* Fri Feb 21 2020 vcizek@suse.com
- Use the newly build libcrypto shared library when computing the hmac
  checksums in order to avoid a bootstrapping issue by BuildRequiring
  libopenssl1_1 (bsc#1164102)
* Thu Feb 13 2020 vcizek@suse.com
- Fix wrong return values of FIPS DSA and ECDH selftests (bsc#1163569)
  * add openssl-fips_fix_selftests_return_value.patch
* Wed Feb 12 2020 jsikes@suse.com
- Added SHA3 FIPS self-tests bsc#1155345
  * openssl-fips-add-SHA3-selftest.patch
* Tue Jan 28 2020 pmonrealgonzalez@suse.com
- Support for CPACF enhancements - part 2 (crypto) [jsc#SLE-7403]
- Add patches:
  * openssl-s390x-assembly-pack-accelerate-X25519-X448-Ed25519-and-Ed448.patch
  * openssl-s390x-fix-x448-and-x448-test-vector-ctime-for-x25519-and-x448.patch
* Thu Jan 23 2020 vcizek@suse.com
- Temporarily ignore broken OPENSSL_INIT_NO_ATEXIT due to our
  layered FIPS initialization (bsc#1161789)
  * openssl-fips-ignore_broken_atexit_test.patch
* Wed Jan 22 2020 vcizek@suse.com
- Import FIPS patches from SLE-15
  * openssl-fips-dont_run_FIPS_module_installed.patch
  * openssl-fips_mode.patch
  * openssl-ship_fips_standalone_hmac.patch
  * openssl-fips-clearerror.patch
  * openssl-fips-selftests_in_nonfips_mode.patch
* Tue Jan 21 2020 vcizek@suse.com
- Don't run FIPS power-up self-tests when the checksum files aren't
  installed (bsc#1042392)
  * add openssl-fips-run_selftests_only_when_module_is_complete.patch
* Tue Jan 21 2020 vcizek@suse.com
- Import FIPS patches from Fedora (bsc#1157702, jsc#SLE-9553)
  * openssl-1.1.1-fips-crng-test.patch
  * openssl-1.1.1-fips-post-rand.patch
  * openssl-1.1.1-fips.patch
  * openssl-1.1.0-issuer-hash.patch
  * openssl-1.1.1-evp-kdf.patch
  * openssl-1.1.1-ssh-kdf.patch replaces openssl-jsc-SLE-8789-backport_KDF.patch
- keep EVP_KDF functions at version 1.1.1d for backward compatibility
  * add openssl-keep_EVP_KDF_functions_version.patch
* Fri Dec 20 2019 pmonrealgonzalez@suse.com
- Support for CPACF enhancements - part 1 (crypto) [bsc#1152695, jsc#SLE-7861]
- Add patches:
  * openssl-s390x-assembly-pack-add-OPENSSL_s390xcap-environment.patch
  * openssl-s390x-assembly-pack-add-support-for-pcc-and-kma-inst.patch
  * openssl-s390x-assembly-pack-add-OPENSSL_s390xcap-man-page.patch
  * openssl-s390x-assembly-pack-update-OPENSSL_s390xcap-3.patch
  * openssl-s390xcpuid.pl-fix-comment.patch
  * openssl-assembly-pack-accelerate-scalar-multiplication.patch
  * openssl-Enable-curve-spefific-ECDSA-implementations-via-EC_M.patch
  * openssl-s390x-assembly-pack-accelerate-ECDSA.patch
  * openssl-OPENSSL_s390xcap.pod-list-msa9-facility-bit-155.patch
  * openssl-s390x-assembly-pack-cleanse-only-sensitive-fields.patch
  * openssl-s390x-assembly-pack-fix-OPENSSL_s390xcap-z15-cpu-mas.patch
  * openssl-s390x-assembly-pack-fix-msa3-stfle-bit-detection.patch
  * openssl-Fix-9bf682f-which-broke-nistp224_method.patch
* Wed Dec 18 2019 vcizek@suse.com
- Obsolete libopenssl-1_0_0-devel and libopenssl-1_0_0-hmac in order
  to avoid conflict upon upgrade from SLE-12 (bsc#1158499)
* Tue Dec 10 2019 pmonrealgonzalez@suse.com
- Security fix: [bsc#1158809, CVE-2019-1551]
  * Overflow bug in the x64_64 Montgomery squaring procedure used
    in exponentiation with 512-bit moduli
- Add openssl-1_1-CVE-2019-1551.patch
* Fri Oct 11 2019 jsikes@suse.com
- Fixed EVP_PBE_scrypt() to allow NULL salt values.
  * Revealed by nodejs12 during bsc#1149572.
  * Modified openssl-jsc-SLE-8789-backport_KDF.patch
* Wed Sep 11 2019 vcizek@suse.com
- Update to 1.1.1d (bsc#1133925, jsc#SLE-6430)
  * Fixed a fork protection issue. OpenSSL 1.1.1 introduced a rewritten random
    number generator (RNG). This was intended to include protection in the
    event of a fork() system call in order to ensure that the parent and child
    processes did not share the same RNG state. However this protection was not
    being used in the default case.
    (bsc#1150247, CVE-2019-1549)
  * Compute ECC cofactors if not provided during EC_GROUP construction. Before
    this change, EC_GROUP_set_generator would accept order and/or cofactor as
    NULL. After this change, only the cofactor parameter can be NULL.
    (bsc#1150003, CVE-2019-1547)
  * Fixed a padding oracle in PKCS7_dataDecode and CMS_decrypt_set1_pkey.
    (bsc#1150250, CVE-2019-1563)
  * For built-in EC curves, ensure an EC_GROUP built from the curve name is
    used even when parsing explicit parameters, when loading a serialized key
    or calling EC_GROUP_new_from_ecpkparameters()/EC_GROUP_new_from_ecparameters().
  * Early start up entropy quality from the DEVRANDOM seed source has been
    improved for older Linux systems.
  * Changed DH_check to accept parameters with order q and 2q subgroups.
    With order 2q subgroups the bit 0 of the private key is not secret
    but DH_generate_key works around that by clearing bit 0 of the
    private key for those. This avoids leaking bit 0 of the private key.
  * Significantly reduce secure memory usage by the randomness pools.
  * Revert the DEVRANDOM_WAIT feature for Linux systems
- drop 0001-build_SYS_str_reasons-Fix-a-crash-caused-by-overlong.patch (upstream)
- refresh patches
  * openssl-1.1.0-no-html.patch
  * openssl-jsc-SLE-8789-backport_KDF.patch
* Mon Sep  9 2019 jsikes@suse.com
- To avoid seperate certification of openssh server / client
  move the SSH KDF (Key Derivation Function) into openssl.
  * jsc#SLE-8789
  * Sourced from commit
    8d76481b189b7195ef932e0fb8f0e23ab0120771#diff-a9562bc75317360a2e6b8b0748956e34
    in openssl master (introduce the SSH KDF)
    and commit 5a285addbf39f91d567f95f04b2b41764127950d
    in openssl master (backport EVP/KDF API framework)
  * added openssl-jsc-SLE-8789-backport_KDF.patch
* Thu Aug 29 2019 vcizek@suse.com
- Upgrade to 1.1.1c (jsc#SLE-9135, bsc#1148799)
  * Support for TLSv1.3 added
  * Allow GNU style "make variables" to be used with Configure.
  * Add a STORE module (OSSL_STORE)
  * Claim the namespaces OSSL and OPENSSL, represented as symbol prefixes
  * Add multi-prime RSA (RFC 8017) support
  * Add SM3 implemented according to GB/T 32905-2016
  * Add SM4 implemented according to GB/T 32907-2016.
  * Add 'Maximum Fragment Length' TLS extension negotiation and support
  * Add ARIA support
  * Add SHA3
  * Rewrite of devcrypto engine
  * Add support for SipHash
  * Grand redesign of the OpenSSL random generator
- drop FIPS support
  * don't build with FIPS mode (not supported in 1.1.1)
  - drop FIPS patches
  * openssl-fips-clearerror.patch
  * openssl-fips_disallow_ENGINE_loading.patch
  * openssl-fips-dont-fall-back-to-default-digest.patch
  * openssl-fips-dont_run_FIPS_module_installed.patch
  * openssl-fips-fix-odd-rsakeybits.patch
  * openssl-fips-rsagen-d-bits.patch
  * openssl-fips-selftests_in_nonfips_mode.patch
  * openssl-rsakeygen-minimum-distance.patch
  * openssl-1.1.0-fips.patch
- add TLS 1.3 ciphers to DEFAULT_SUSE
- merge openssl-1.0.1e-add-suse-default-cipher.patch and
  openssl-1.0.1e-add-test-suse-default-cipher-suite.patch to
  openssl-DEFAULT_SUSE_cipher.patch
- Use upstream patch for the locale crash (bsc#1135550)
  * https://github.com/openssl/openssl/pull/8966
  * add 0001-build_SYS_str_reasons-Fix-a-crash-caused-by-overlong.patch
- drop patches (upstream):
  * openssl-Bleichenbachers_CAT.patch
  * openssl-CVE-2018-0734.patch
  * openssl-CVE-2018-0735.patch
  * openssl-CVE-2019-1543.patch
  * openssl-disable_rsa_keygen_tests_with_small_modulus.patch
  * openssl-dsa_paramgen2_check.patch
  * openssl-One_and_Done.patch
  * openssl-speed_skip_binary_curves_NO_EC2M.patch
  * openssl-static-deps.patch
  * openssl-urandom-reseeding.patch
  * 0001-Add-a-constant-time-flag-to-one-of-the-bignums-to-av.patch
  * 0001-Axe-builtin-printf-implementation-use-glibc-instead.patch
  * 0001-DSA-mod-inverse-fix.patch
  * 0001-Resume-reading-from-randfile-when-interrupted-by-a-s.patch
  * 0001-apps-speed-fix-segfault-while-looking-up-algorithm-n.patch
- drop s390x patches (rebased):
  * 0002-s390x-assembly-pack-add-KMA-code-path-for-aes-ctr.patch
  * 0003-crypto-aes-asm-aes-s390x.pl-replace-decrypt-flag-by-.patch
  * 0004-s390x-assembly-pack-add-KMA-code-path-for-aes-gcm.patch
  * 0005-s390x-assembly-pack-add-KMAC-code-path-for-aes-ccm.patch
  * 0006-s390x-assembly-pack-add-KM-code-path-for-aes-ecb.patch
  * 0007-s390x-assembly-pack-add-KMO-code-path-for-aes-ofb.patch
  * 0008-s390x-assembly-pack-add-KMF-code-path-for-aes-cfb-cf.patch
  * 0009-Fix-undefined-behavior-in-s390x-aes-gcm-ccm.patch
  * 0001-crypto-poly1305-asm-poly1305-s390x.pl-add-vx-code-pa.patch
  * 0001-s390x-assembly-pack-extend-s390x-capability-vector.patch
- add s390x patches:
  * 0001-s390x-assembly-pack-perlasm-support.patch
  * 0002-crypto-chacha-asm-chacha-s390x.pl-add-vx-code-path.patch
  * 0003-crypto-poly1305-asm-poly1305-s390x.pl-add-vx-code-pa.patch
  * 0004-s390x-assembly-pack-fix-formal-interface-bug-in-chac.patch
  * 0005-s390x-assembly-pack-import-chacha-from-cryptogams-re.patch
  * 0006-s390x-assembly-pack-import-poly-from-cryptogams-repo.patch
* Tue Mar 12 2019 vcizek@suse.com
- Fix segfault in openssl speed when an unknown algorithm is passed
  (bsc#1125494)
  * add 0001-apps-speed-fix-segfault-while-looking-up-algorithm-n.patch
- Correctly skip binary curves in openssl speed to avoid spitting
  errors (bsc#1116833)
  * add openssl-speed_skip_binary_curves_NO_EC2M.patch
* Thu Mar  7 2019 vcizek@suse.com
- OpenSSL Security Advisory [6 March 2019]
  * Prevent long nonces in ChaCha20-Poly1305 (bsc#1128189, CVE-2019-1543)
  * add openssl-CVE-2019-1543.patch
* Mon Feb 11 2019 vcizek@suse.com
- Add s390x poly1305 vectorized implementation (fate#326351)
  * https://github.com/openssl/openssl/pull/7991
- add 0001-crypto-poly1305-asm-poly1305-s390x.pl-add-vx-code-pa.patch
* Tue Jan 22 2019 vcizek@suse.com
- Add vectorized chacha20 implementation for s390x (fate#326561)
  * https://github.com/openssl/openssl/pull/6919
- add patches:
  0001-s390x-assembly-pack-perlasm-support.patch
  0002-crypto-chacha-asm-chacha-s390x.pl-add-vx-code-path.patch
* Tue Jan 22 2019 vcizek@suse.com
- Replace fate#321518 s390x patches from closed pull request
  https://github.com/openssl/openssl/pull/2859 with patches from
  openssl git master (bsc#1122984)
- add patches:
  0001-s390x-assembly-pack-extend-s390x-capability-vector.patch
  0002-s390x-assembly-pack-add-KMA-code-path-for-aes-ctr.patch
  0003-crypto-aes-asm-aes-s390x.pl-replace-decrypt-flag-by-.patch
  0004-s390x-assembly-pack-add-KMA-code-path-for-aes-gcm.patch
  0005-s390x-assembly-pack-add-KMAC-code-path-for-aes-ccm.patch
  0006-s390x-assembly-pack-add-KM-code-path-for-aes-ecb.patch
  0007-s390x-assembly-pack-add-KMO-code-path-for-aes-ofb.patch
  0008-s390x-assembly-pack-add-KMF-code-path-for-aes-cfb-cf.patch
  0009-Fix-undefined-behavior-in-s390x-aes-gcm-ccm.patch
- drop patches:
  0002-crypto-modes-asm-ghash-s390x.pl-fix-gcm_gmult_4bit-K.patch
  0004-s390x-assembly-pack-add-OPENSSL_s390xcap-environment.patch
  0005-s390x-assembly-pack-add-OPENSSL_s390xcap-man-page.patch
  0006-s390x-assembly-pack-extended-s390x-capability-vector.patch
  0007-crypto-evp-e_aes.c-add-foundations-for-extended-s390.patch
  0008-s390x-assembly-pack-extended-s390x-capability-vector.patch
  0009-crypto-aes-asm-aes-s390x.pl-add-KMA-code-path.patch
  0010-doc-man3-OPENSSL_s390xcap.pod-update-KMA.patch
  0011-crypto-aes-asm-aes-s390x.pl-add-CFI-annotations-KMA-.patch
  0012-s390x-assembly-pack-add-KMA-code-path-for-aes-gcm.patch
  0013-crypto-aes-asm-aes-s390x.pl-add-CFI-annotations-KMA-.patch
* Fri Jan 18 2019 vcizek@suse.com
- Fix FIPS RSA generator (bsc#1118913)
  * import fixed openssl-1.1.0-fips.patch from Fedora
  * drop openssl-CVE-2018-0737-fips.patch which got merged into
    openssl-1.1.0-fips.patch
  * refresh openssl-fips-rsagen-d-bits.patch
* Thu Dec 20 2018 vcizek@suse.com
- The 9 Lives of Bleichenbacher's CAT: Cache ATtacks on TLS
  Implementations (bsc#1117951)
  * https://github.com/openssl/openssl/issues/7739
  * add patch openssl-Bleichenbachers_CAT.patch
* Mon Nov  5 2018 vcizek@suse.com
- OpenSSL Security Advisory [30 October 2018]
  * Timing vulnerability in ECDSA signature generation
    (bsc#1113651, CVE-2018-0735)
  * Timing vulnerability in DSA signature generation
    (bsc#1113652, CVE-2018-0734)
  * And more timing fixes
- Add patches:
  * openssl-CVE-2018-0734.patch
  * openssl-CVE-2018-0735.patch
  * 0001-DSA-mod-inverse-fix.patch
  * 0001-Add-a-constant-time-flag-to-one-of-the-bignums-to-av.patch
* Tue Oct 23 2018 vcizek@suse.com
- Obsolete libopenssl-1_0_0-devel by libopenssl-1_1-devel to avoid
  conflicts when updating from older distributions (bsc#1106180)
* Thu Oct 18 2018 vcizek@suse.com
- Fix infinite loop in DSA generation with incorrect parameters
  (bsc#1112209)
  * add openssl-dsa_paramgen2_check.patch
* Thu Oct 18 2018 vcizek@suse.com
- Fix One&Done side-channel attack on RSA (bsc#1104789)
  * add openssl-One_and_Done.patch
* Tue Aug 14 2018 vcizek@suse.com
- Update to 1.1.0i
  - Align with SLE-12-SP4
  OpenSSL Security Advisory [12 June 2018]
  * Reject excessively large primes in DH key generation
    (bsc#1097158, CVE-2018-0732)
  * Make EVP_PKEY_asn1_new() a bit stricter about its input
  * Revert blinding in ECDSA sign and instead make problematic addition
    length-invariant. Switch even to fixed-length Montgomery multiplication.
  * Change generating and checking of primes so that the error rate of not
    being prime depends on the intended use based on the size of the input.
  * Increase the number of Miller-Rabin rounds for DSA key generating to 64.
  * Add blinding to ECDSA and DSA signatures to protect against side channel
    attacks
  * When unlocking a pass phrase protected PEM file or PKCS#8 container, we
    now allow empty (zero character) pass phrases.
  * Certificate time validation (X509_cmp_time) enforces stricter
    compliance with RFC 5280. Fractional seconds and timezone offsets
    are no longer allowed.
  * Fixed a text canonicalisation bug in CMS
- drop patches (upstream):
  * 0001-Limit-scope-of-CN-name-constraints.patch
  * 0001-Revert-util-dofile.pl-only-quote-stuff-that-actually.patch
  * 0001-Tolerate-a-Certificate-using-a-non-supported-group-o.patch
  * 0002-Skip-CN-DNS-name-constraint-checks-when-not-needed.patch
  * openssl-add-blinding-to-dsa.patch
  * openssl-add-blinding-to-ecdsa.patch
  * openssl-CVE-2018-0732.patch
- refresh patches:
  * openssl-1.1.0-fips.patch
  * openssl-disable_rsa_keygen_tests_with_small_modulus.patch
- rename openssl-CVE-2018-0737.patch to openssl-CVE-2018-0737-fips.patch
  as it now only includes changes to the fips code
* Thu Aug  2 2018 vcizek@suse.com
- Add openssl(cli) Provide so the packages that require the openssl
  binary can require this instead of the new openssl meta package
  (bsc#1101470)
- Don't Require openssl-1_1 from the devel package, just Recommend it
* Wed Jul 25 2018 vcizek@suse.com
- Suggest libopenssl1_1-hmac from libopenssl1_1 package to avoid
  dependency issues during updates (bsc#1090765)
* Wed Jul 25 2018 vcizek@suse.com
- Relax CN name restrictions (bsc#1084011)
  * added patches:
    0001-Limit-scope-of-CN-name-constraints.patch
    0002-Skip-CN-DNS-name-constraint-checks-when-not-needed.patch
* Tue Jun 26 2018 sflees@suse.de
- Reject excessively large primes in DH key generation (bsc#1097158,
  CVE-2018-0732)
  * openssl-CVE-2018-0732.patch
- blinding enhancements for ECDSA and DSA (bsc#1097624, bsc#1098592)
  * openssl-add-blinding-to-ecdsa.patch
  * openssl-add-blinding-to-dsa.patch
* Thu May 10 2018 vcizek@suse.com
- OpenSSL Security Advisory [16 Apr 2018]
  * Cache timing vulnerability in RSA Key Generation
    (CVE-2018-0737, bsc#1089039)
  * add openssl-CVE-2018-0737.patch
* Thu May 10 2018 vcizek@suse.com
- Fix escaping in c_rehash (boo#1091961, bsc#1091963)
  * add 0001-Revert-util-dofile.pl-only-quote-stuff-that-actually.patch
* Wed Mar 28 2018 vcizek@suse.com
- Tolerate a Certificate using a non-supported group on server side
  (boo#1084651)
  * https://github.com/openssl/openssl/pull/5607
  * add 0001-Tolerate-a-Certificate-using-a-non-supported-group-o.patch
* Tue Mar 27 2018 vcizek@suse.com
- Update to 1.1.0h
  OpenSSL Security Advisory [27 Mar 2018]
  * Constructed ASN.1 types with a recursive definition could exceed
    the stack (CVE-2018-0739) (bsc#1087102)
  * rsaz_1024_mul_avx2 overflow bug on x86_64 (CVE-2017-3738)
    (bsc#1071906)
- refresh patches:
  * 0001-Axe-builtin-printf-implementation-use-glibc-instead.patch
  * openssl-1.1.0-fips.patch
  * openssl-pkgconfig.patch
  * openssl-rsakeygen-minimum-distance.patch
  * openssl-static-deps.patch
* Tue Feb 27 2018 dimstar@opensuse.org
- Move the libopenssl1_1_0-32bit obsoletes in baselibs.conf to the
  new libopenssl1_1-32bit: it does not belong to the devel
  package.
* Fri Feb 16 2018 vcizek@suse.com
- Renamed from openssl-1_1_0 (bsc#1081335)
  * All the minor versions of the 1.1.x openssl branch have the same
    sonum and keep ABI compatibility
  * obsolete the 1_1_0 packages
- update baselibs.conf with the new version names
* Thu Feb 15 2018 tchvatal@suse.com
- Remove bit obsolete syntax
- Use %%license macro
* Mon Jan 22 2018 schwab@suse.de
- Don't disable afalgeng on aarch64
* Tue Jan  9 2018 vcizek@suse.com
- Add support for s390x CPACF enhancements (fate#321518)
  patches taken from https://github.com/openssl/openssl/pull/2859:
  * 0002-crypto-modes-asm-ghash-s390x.pl-fix-gcm_gmult_4bit-K.patch
  * 0004-s390x-assembly-pack-add-OPENSSL_s390xcap-environment.patch
  * 0005-s390x-assembly-pack-add-OPENSSL_s390xcap-man-page.patch
  * 0006-s390x-assembly-pack-extended-s390x-capability-vector.patch
  * 0007-crypto-evp-e_aes.c-add-foundations-for-extended-s390.patch
  * 0008-s390x-assembly-pack-extended-s390x-capability-vector.patch
  * 0009-crypto-aes-asm-aes-s390x.pl-add-KMA-code-path.patch
  * 0010-doc-man3-OPENSSL_s390xcap.pod-update-KMA.patch
  * 0011-crypto-aes-asm-aes-s390x.pl-add-CFI-annotations-KMA-.patch
  * 0012-s390x-assembly-pack-add-KMA-code-path-for-aes-gcm.patch
  * 0013-crypto-aes-asm-aes-s390x.pl-add-CFI-annotations-KMA-.patch
* Tue Nov 28 2017 dimstar@opensuse.org
- Do not filter pkgconfig() provides/requires.
* Tue Nov 28 2017 dimstar@opensuse.org
- Obsolete openssl-1_0_0 by openssl-1_1_0: this is required for a
  clean upgrade path as an aid to zypp (boo#1070003).
* Thu Nov  2 2017 vcizek@suse.com
- Update to 1.1.0g
  OpenSSL Security Advisory [02 Nov 2017]
  * bn_sqrx8x_internal carry bug on x86_64
    (CVE-2017-3736) (bsc#1066242)
  * Malformed X.509 IPAddressFamily could cause OOB read
    (CVE-2017-3735) (bsc#1056058)
- drop 0001-Fix-a-TLSProxy-race-condition.patch (upstream)
- refresh 0001-Axe-builtin-printf-implementation-use-glibc-instead.patch
* Fri Sep  1 2017 vcizek@suse.com
- update DEFAULT_SUSE cipher list (bsc#1055825)
  * add CHACHA20-POLY1305
  * add ECDSA ciphers
  * remove 3DES
- modified openssl-1.0.1e-add-suse-default-cipher.patch
* Tue Aug 15 2017 meissner@suse.com
- do not require openssl1_1_0-targettype in devel-targettype, as it
  is not built (it has no libraries)
* Mon Aug  7 2017 jengelh@inai.de
- The description is supposed to describe the package, not the
  development process or history. (Synchronize with the
  already-updates descriptions in openssl-1_0_0.)
- Update historic copypasted boilerplate summaries
  ("include files mandatory for development")
* Thu Aug  3 2017 tchvatal@suse.com
- Disable the verbosity of the tests as we expose yet another race
  condition in that
* Tue Jul 18 2017 vcizek@suse.com
- Fix a race condition in tests to make the package build reliably
  * https://github.com/openssl/openssl/issues/3562
  * 0001-Fix-a-TLSProxy-race-condition.patch
* Tue Jul 18 2017 jimmy@boombatower.com
- Add Provides and Conflicts for -devel package in baselibs.conf.
* Sun Jun 25 2017 tchvatal@suse.com
- Add patch openssl-no-date.patch to disable date inclusion in most
  of the binaries
- Use autopatch to make things smaller
- Enable verbose output on the tests
- Paralelize depmod
* Mon May 29 2017 vcizek@suse.com
- update to 1.1.0f
  * bugfix only release
- disable RSA keygen tests, because they use too small modulus, which
  is rejected by our CC/FIPS hardening patches
  * added openssl-disable_rsa_keygen_tests_with_small_modulus.patch
- refreshed openssl-rsakeygen-minimum-distance.patch and
  0001-Axe-builtin-printf-implementation-use-glibc-instead.patch
* Wed May 10 2017 tchvatal@suse.com
- Add conflict for any libopenssl-devel that is not in our version
* Wed May 10 2017 tchvatal@suse.com
- Avoid the requires conflict between 1.1 and 1.0 openssl
* Fri May  5 2017 tchvatal@suse.com
- Add conflict on docu packages
* Wed May  3 2017 vcizek@suse.com
- drop unnecessary README.SUSE
* Wed May  3 2017 vcizek@suse.com
- add openssl-1.1-fix-ppc64.patch from Marcus Meissner to fix build
  on ppc64
* Wed May  3 2017 tchvatal@suse.com
- Fix build on aarch64
* Wed May  3 2017 tchvatal@suse.com
- Remove libpadlock conditional, no longer present
* Tue May  2 2017 tchvatal@suse.com
- Update baselibs.conf to contain all the renamed packages
* Wed Apr 26 2017 vcizek@suse.com
- re-enable tests on SLE-12 and below despite current failure, so
  they are automatically run once the issue is resolved
* Wed Apr 26 2017 tchvatal@suse.com
- Filter out the pkgconfig provides to force usage of the main
  openssl package provides
* Fri Apr 21 2017 vcizek@suse.com
- disable tests on SLE-12 and its derivates
  * they fail because of glibc bug bsc#1035445
- remove README-FIPS.txt (outdated)
* Thu Apr 20 2017 vcizek@suse.com
- drop openssl-fipslocking.patch
  The locking in 1.1.0 has been rewritten and converted to the new
  threading API. The fips deadlock (at least bsc#991193) can't be
  reproduced anymore.
- don't ship useless INSTALL* files
* Thu Apr 20 2017 vcizek@suse.com
- simplify openssl-fips-dont-fall-back-to-default-digest.patch
  The -non-fips-allow option was dropped in OpenSSL 1.1.0
- drop openssl-no-egd.patch as OpenSSL 1.1.0 disables EGD at compile
  time by default
- renumber the patches so the numbers are consequent
* Tue Apr 18 2017 tchvatal@suse.com
- Update showciphers.c to work with new openssl
* Tue Apr 18 2017 tchvatal@suse.com
- Add patch openssl-static-deps.patch to allow dependencies on
  statically build libraries
- Refresh openssl-1-1.0-fips.patch to take in use the above approach
- Silence the install manpage rename phase
* Thu Apr 13 2017 tchvatal@suse.com
- Start update to 1.1.0e basing of the 1.0.0 split release
- Drop patch merge_from_0.9.8k.patch the ppc64 should work out of the
  box
- Drop patch openssl-engines-path.patch converted to configure option
- Drop patch openssl-1.0.2a-padlock64.patch code behind was redone
  does not apply at all
- Drop patch openssl-fix-pod-syntax.diff mostly merged upstream or
  not applicable
- Drop patch compression_methods_switch.patch as we do not need
  to keep the compat on this release anymore
- Drop patch openssl-1.0.2a-ipv6-apps.patch which was upstreamed
- Drop upstreamed patch openssl-1.0.2a-default-paths.patch
- Drop obsolete patch openssl-1.0.0-c_rehash-compat.diff
- Drop obsolete patch openssl-missing_FIPS_ec_group_new_by_curve_name.patch
- Drop obsolete patch openssl-print_notice-NULL_crash.patch
- Drop obsolete patch openssl-randfile_fread_interrupt.patch
- Refresh patch openssl-truststore.patch
- Refresh baselibs.conf to correctly reflect soname
- Add patch openssl-1.1.0-fips.patch obsoleting bunch of older:
  * openssl-1.0.2i-fips.patch
  * openssl-1.0.2a-fips-ec.patch
  * openssl-1.0.2a-fips-ctor.patch
  * openssl-1.0.2i-new-fips-reqs.patch
  * openssl-fips_disallow_x931_rand_method.patch
- Add new patch for upstream:
  * 0001-Resume-reading-from-randfile-when-interrupted-by-a-s.patch
- Refresh patch openssl-pkgconfig.patch
- Drop patch openssl-gcc-attributes.patch as the code was redone
- Rebase patch 0001-Axe-builtin-printf-implementation-use-glibc-instead.patch
- Rebase patch openssl-no-egd.patch
- Rebase patch openssl-1.0.1e-add-suse-default-cipher.patch and
  openssl-1.0.1e-add-test-suse-default-cipher-suite.patch
- Rebase patch openssl-fips_disallow_ENGINE_loading.patch
- Rebase patch openssl-urandom-reseeding.patch
- Rebase patch openssl-fips-rsagen-d-bits.patch
- Rebase patch openssl-fips-selftests_in_nonfips_mode.patch
- Remove switch for ssl2 - no longer present
- Remve the buildinf.h parsing, should no longer be needed
- Drop the rehash in build, no longer needed
- Drop openssl-fips-hidden.patch as it is not really needed
- Do not sed in secure_getenv upstream does it in code on their own
- Do not install html converted manpages
  * openssl-1.1.0-no-html.patch
* Thu Apr 13 2017 tchvatal@suse.com
- Drop the symbol hiding patches to ease maintenance updates:
  * 0005-libssl-Hide-library-private-symbols.patch
  * 0001-libcrypto-Hide-library-private-symbols.patch
* Thu Apr 13 2017 tchvatal@suse.com
- Add new patch for engines folders to allow co-installation
  * openssl-engines-path.patch
* Thu Apr 13 2017 tchvatal@suse.com
- Drop openssl-ocloexec.patch as it causes additional maintenance
  burden we would like to avoid
* Thu Apr 13 2017 tchvatal@suse.com
- Drop bug610223.patch as we moved to libdir
* Thu Apr 13 2017 tchvatal@suse.com
- Move check to %%check phase
- Split showciphers to separate file
* Wed Apr 12 2017 tchvatal@suse.com
- Move openssl to /usr/lib64 from /lib64
* Wed Apr 12 2017 tchvatal@suse.com
- Remove some of the DSO setting code that is not needed
- Fix the showciphers binary
* Wed Apr 12 2017 tchvatal@suse.com
- Rename to openssl-1_0_0 to allow instalation of multiple versions
* Tue Apr  4 2017 tchvatal@suse.com
- Remove O3 from optflags, no need to not rely on distro wide settings
- Remove conditions for sle10 and sle11, we care only about sle12+
- USE SUSE instead of SuSE in readme
- Pass over with spec-cleaner
* Thu Feb  2 2017 vcizek@suse.com
- fix X509_CERT_FILE path (bsc#1022271) and rename
  updated openssl-1.0.1e-truststore.diff to openssl-truststore.patch
* Fri Jan 27 2017 meissner@suse.com
- Updated to openssl 1.0.2k
  - bsc#1009528 / CVE-2016-7055: openssl: Montgomery multiplication may produce incorrect results
  - bsc#1019334 / CVE-2016-7056: openssl: ECSDA P-256 timing attack key recovery
  - bsc#1022085 / CVE-2017-3731: openssl: Truncated packet could crash via OOB read
  - bsc#1022086 / CVE-2017-3732: openssl: BN_mod_exp may produce incorrect results on x86_64
* Fri Sep 30 2016 vcizek@suse.com
- resume reading from /dev/urandom when interrupted by a signal
  (bsc#995075)
  * add openssl-randfile_fread_interrupt.patch
* Fri Sep 30 2016 vcizek@suse.com
- add FIPS changes from SP2:
- fix problems with locking in FIPS mode (bsc#992120)
  * duplicates: bsc#991877, bsc#991193, bsc#990392, bsc#990428
    and bsc#990207
  * bring back openssl-fipslocking.patch
- drop openssl-fips_RSA_compute_d_with_lcm.patch (upstream)
  (bsc#984323)
- don't check for /etc/system-fips (bsc#982268)
  * add openssl-fips-dont_run_FIPS_module_installed.patch
- refresh openssl-fips-rsagen-d-bits.patch
* Tue Sep 27 2016 michael@stroeder.com
- update to openssl-1.0.2j
  * Missing CRL sanity check (CVE-2016-7052 bsc#1001148)
* Fri Sep 23 2016 vcizek@suse.com
- OpenSSL Security Advisory [22 Sep 2016] (bsc#999665)
  Severity: High
  * OCSP Status Request extension unbounded memory growth
    (CVE-2016-6304) (bsc#999666)
  Severity: Low
  * Pointer arithmetic undefined behaviour (CVE-2016-2177) (bsc#982575)
  * Constant time flag not preserved in DSA signing (CVE-2016-2178) (bsc#983249)
  * DTLS buffered message DoS (CVE-2016-2179) (bsc#994844)
  * OOB read in TS_OBJ_print_bio() (CVE-2016-2180) (bsc#990419)
  * DTLS replay protection DoS (CVE-2016-2181) (bsc#994749)
  * OOB write in BN_bn2dec() (CVE-2016-2182) (bsc#993819)
  * Birthday attack against 64-bit block ciphers (SWEET32)
    (CVE-2016-2183) (bsc#995359)
  * Malformed SHA512 ticket DoS (CVE-2016-6302) (bsc#995324)
  * OOB write in MDC2_Update() (CVE-2016-6303) (bsc#995377)
  * Certificate message OOB reads (CVE-2016-6306) (bsc#999668)
- update to openssl-1.0.2i
  * remove patches:
    openssl-1.0.2a-new-fips-reqs.patch
    openssl-1.0.2e-fips.patch
  * add patches:
    openssl-1.0.2i-fips.patch
    openssl-1.0.2i-new-fips-reqs.patch
* Wed Aug  3 2016 vcizek@suse.com
- fix crash in print_notice (bsc#998190)
  * add openssl-print_notice-NULL_crash.patch
* Tue May  3 2016 vcizek@suse.com
- OpenSSL Security Advisory [3rd May 2016]
- update to 1.0.2h (boo#977584, boo#977663)
  * Prevent padding oracle in AES-NI CBC MAC check
    A MITM attacker can use a padding oracle attack to decrypt traffic
    when the connection uses an AES CBC cipher and the server support
    AES-NI.
    (CVE-2016-2107, boo#977616)
  * Fix EVP_EncodeUpdate overflow
    An overflow can occur in the EVP_EncodeUpdate() function which is used for
    Base64 encoding of binary data. If an attacker is able to supply very large
    amounts of input data then a length check can overflow resulting in a heap
    corruption.
    (CVE-2016-2105, boo#977614)
  * Fix EVP_EncryptUpdate overflow
    An overflow can occur in the EVP_EncryptUpdate() function. If an attacker
    is able to supply very large amounts of input data after a previous call to
    EVP_EncryptUpdate() with a partial block then a length check can overflow
    resulting in a heap corruption.
    (CVE-2016-2106, boo#977615)
  * Prevent ASN.1 BIO excessive memory allocation
    When ASN.1 data is read from a BIO using functions such as d2i_CMS_bio()
    a short invalid encoding can casuse allocation of large amounts of memory
    potentially consuming excessive resources or exhausting memory.
    (CVE-2016-2109, boo#976942)
  * EBCDIC overread
    ASN1 Strings that are over 1024 bytes can cause an overread in applications
    using the X509_NAME_oneline() function on EBCDIC systems. This could result
    in arbitrary stack data being returned in the buffer.
    (CVE-2016-2176, boo#978224)
  * Modify behavior of ALPN to invoke callback after SNI/servername
    callback, such that updates to the SSL_CTX affect ALPN.
  * Remove LOW from the DEFAULT cipher list.  This removes singles DES from the
    default.
  * Only remove the SSLv2 methods with the no-ssl2-method option. When the
    methods are enabled and ssl2 is disabled the methods return NULL.
* Fri Apr 15 2016 dvaleev@suse.com
- Remove a hack for bsc#936563
- Drop bsc936563_hack.patch
* Fri Apr 15 2016 vcizek@suse.com
- import fips patches from SLE-12
  * openssl-fips-clearerror.patch
  * openssl-fips-dont-fall-back-to-default-digest.patch
  * openssl-fips-fix-odd-rsakeybits.patch
  * openssl-fips-rsagen-d-bits.patch
  * openssl-fips-selftests_in_nonfips_mode.patch
  * openssl-fips_RSA_compute_d_with_lcm.patch
  * openssl-fips_disallow_ENGINE_loading.patch
  * openssl-fips_disallow_x931_rand_method.patch
  * openssl-rsakeygen-minimum-distance.patch
  * openssl-urandom-reseeding.patch
* Tue Mar  8 2016 vcizek@suse.com
- add support for "ciphers" providing no encryption (bsc#937085)
  * don't build with -DSSL_FORBID_ENULL
* Tue Mar  1 2016 vcizek@suse.com
- update to 1.0.2g (bsc#968044)
  * Disable weak ciphers in SSLv3 and up in default builds of OpenSSL.
    Builds that are not configured with "enable-weak-ssl-ciphers" will not
    provide any "EXPORT" or "LOW" strength ciphers.
  * Disable SSLv2 default build, default negotiation and weak ciphers.  SSLv2
    is by default disabled at build-time.  Builds that are not configured with
    "enable-ssl2" will not support SSLv2.  Even if "enable-ssl2" is used,
    users who want to negotiate SSLv2 via the version-flexible SSLv23_method()
    will need to explicitly call either of:
    SSL_CTX_clear_options(ctx, SSL_OP_NO_SSLv2);
    or
    SSL_clear_options(ssl, SSL_OP_NO_SSLv2);
    (CVE-2016-0800)
  * Fix a double-free in DSA code
    (CVE-2016-0705)
  * Disable SRP fake user seed to address a server memory leak.
    Add a new method SRP_VBASE_get1_by_user that handles the seed properly.
    (CVE-2016-0798)
  * Fix BN_hex2bn/BN_dec2bn NULL pointer deref/heap corruption
    (CVE-2016-0797)
  * ) Side channel attack on modular exponentiation
    http://cachebleed.info.
    (CVE-2016-0702)
  * ) Change the req app to generate a 2048-bit RSA/DSA key by default,
    if no keysize is specified with default_bits. This fixes an
    omission in an earlier change that changed all RSA/DSA key generation
    apps to use 2048 bits by default.
* Thu Jan 28 2016 vcizek@suse.com
- update to 1.0.2f (boo#963410)
  * ) DH small subgroups (boo#963413)
    Historically OpenSSL only ever generated DH parameters based on "safe"
    primes. More recently (in version 1.0.2) support was provided for
    generating X9.42 style parameter files such as those required for RFC 5114
    support. The primes used in such files may not be "safe". Where an
    application is using DH configured with parameters based on primes that are
    not "safe" then an attacker could use this fact to find a peer's private
    DH exponent. This attack requires that the attacker complete multiple
    handshakes in which the peer uses the same private DH exponent. For example
    this could be used to discover a TLS server's private DH exponent if it's
    reusing the private DH exponent or it's using a static DH ciphersuite.
    (CVE-2016-0701)
  * ) SSLv2 doesn't block disabled ciphers (boo#963415)
    A malicious client can negotiate SSLv2 ciphers that have been disabled on
    the server and complete SSLv2 handshakes even if all SSLv2 ciphers have
    been disabled, provided that the SSLv2 protocol was not also disabled via
    SSL_OP_NO_SSLv2.
    (CVE-2015-3197)
  * ) Reject DH handshakes with parameters shorter than 1024 bits.
* Fri Dec  4 2015 vcizek@suse.com
- update to 1.0.2e
  * fixes five security vulnerabilities
  * Anon DH ServerKeyExchange with 0 p parameter
    (CVE-2015-1794) (bsc#957984)
  * BN_mod_exp may produce incorrect results on x86_64
    (CVE-2015-3193) (bsc#957814)
  * Certificate verify crash with missing PSS parameter
    (CVE-2015-3194) (bsc#957815)
  * X509_ATTRIBUTE memory leak
    (CVE-2015-3195) (bsc#957812)
  * Race condition handling PSK identify hint
    (CVE-2015-3196) (bsc#957813)
- pulled a refreshed fips patch from Fedora
  * openssl-1.0.2a-fips.patch was replaced by
    openssl-1.0.2e-fips.patch
- refresh openssl-ocloexec.patch
* Thu Jul  9 2015 vcizek@suse.com
- update to 1.0.2d
  * fixes CVE-2015-1793 (bsc#936746)
  Alternate chains certificate forgery
    During certificate verfification, OpenSSL will attempt to find an
    alternative certificate chain if the first attempt to build such a chain
    fails. An error in the implementation of this logic can mean that an
    attacker could cause certain checks on untrusted certificates to be
    bypassed, such as the CA flag, enabling them to use a valid leaf
    certificate to act as a CA and "issue" an invalid certificate.
- drop openssl-fix_invalid_manpage_name.patch (upstream)
* Thu Jul  2 2015 dvaleev@suse.com
- Workaround debugit crash on ppc64le with gcc5
  bsc936563_hack.patch (bsc#936563)
* Wed Jul  1 2015 normand@linux.vnet.ibm.com
- update merge_from_0.9.8k.patch replacing __LP64__ by __LP64
  this is a change versus previous request 309611
  required to avoid build error for ppc64
* Fri Jun 26 2015 crrodriguez@opensuse.org
- Build with no-ssl3, for details on why this is needed read
  rfc7568. Contrary to the "no-ssl2" option, this does not
  require us to patch dependant packages as the relevant
  functions are still available (SSLv3_(client|server)_method)
  but will fail to negotiate. if removing SSL3 methods is desired
  at a later time, option "no-ssl3-method" needs to be used.
* Fri Jun 12 2015 vcizek@suse.com
- update to 1.0.2c
  * Fix HMAC ABI incompatibility
- refreshed openssl-1.0.2a-fips.patch
* Thu Jun 11 2015 vcizek@suse.com
- update to 1.0.2b
  * Malformed ECParameters causes infinite loop (CVE-2015-1788)
  * Exploitable out-of-bounds read in X509_cmp_time (CVE-2015-1789)
  * PKCS7 crash with missing EnvelopedContent (CVE-2015-1790)
  * CMS verify infinite loop with unknown hash function (CVE-2015-1792)
  * Race condition handling NewSessionTicket (CVE-2015-1791)
- refreshed patches:
  * 0001-Axe-builtin-printf-implementation-use-glibc-instead.patch
  * 0001-libcrypto-Hide-library-private-symbols.patch
  * openssl-1.0.2a-default-paths.patch
  * openssl-1.0.2a-fips.patch
  * compression_methods_switch.patch
  * openssl-1.0.1e-add-test-suse-default-cipher-suite.patch
* Sun May 24 2015 vcizek@suse.com
- update to 1.0.2a
  * Major changes since 1.0.1:
  - Suite B support for TLS 1.2 and DTLS 1.2
  - Support for DTLS 1.2
  - TLS automatic EC curve selection.
  - API to set TLS supported signature algorithms and curves
  - SSL_CONF configuration API.
  - TLS Brainpool support.
  - ALPN support.
  - CMS support for RSA-PSS, RSA-OAEP, ECDH and X9.42 DH.
- packaging changes:
  * merged patches modifying CIPHER_LIST into one, dropping:
  - openssl-1.0.1e-add-suse-default-cipher-header.patch
  - openssl-libssl-noweakciphers.patch
  * fix a manpage with invalid name
  - added openssl-fix_invalid_manpage_name.patch
  * remove a missing fips function
  - openssl-missing_FIPS_ec_group_new_by_curve_name.patch
  * reimported patches from Fedora
    dropped patches:
  - openssl-1.0.1c-default-paths.patch
  - openssl-1.0.1c-ipv6-apps.patch
  - openssl-1.0.1e-fips-ctor.patch
  - openssl-1.0.1e-fips-ec.patch
  - openssl-1.0.1e-fips.patch
  - openssl-1.0.1e-new-fips-reqs.patch
  - VIA_padlock_support_on_64systems.patch
    added patches:
  - openssl-1.0.2a-default-paths.patch
  - openssl-1.0.2a-fips-ctor.patch
  - openssl-1.0.2a-fips-ec.patch
  - openssl-1.0.2a-fips.patch
  - openssl-1.0.2a-ipv6-apps.patch
  - openssl-1.0.2a-new-fips-reqs.patch
  - openssl-1.0.2a-padlock64.patch
  * dropped security fixes (upstream)
  - openssl-CVE-2015-0209.patch
  - openssl-CVE-2015-0286.patch
  - openssl-CVE-2015-0287.patch
  - openssl-CVE-2015-0288.patch
  - openssl-CVE-2015-0289.patch
  - openssl-CVE-2015-0293.patch
  * upstream reformatted the sources, so all the patches have to
    be refreshed
* Thu Mar 19 2015 vcizek@suse.com
- security update:
  * CVE-2015-0209 (bnc#919648)
  - Fix a failure to NULL a pointer freed on error
  * CVE-2015-0286 (bnc#922496)
  - Segmentation fault in ASN1_TYPE_cmp
  * CVE-2015-0287 (bnc#922499)
  - ASN.1 structure reuse memory corruption
  * CVE-2015-0288 x509: (bnc#920236)
  - added missing public key is not NULL check
  * CVE-2015-0289 (bnc#922500)
  - PKCS7 NULL pointer dereferences
  * CVE-2015-0293 (bnc#922488)
  - Fix reachable assert in SSLv2 servers
  * added patches:
  openssl-CVE-2015-0209.patch
  openssl-CVE-2015-0286.patch
  openssl-CVE-2015-0287.patch
  openssl-CVE-2015-0288.patch
  openssl-CVE-2015-0289.patch
  openssl-CVE-2015-0293.patch
* Wed Feb  4 2015 meissner@suse.com
- The DATE stamp moved from crypto/Makefile to crypto/buildinf.h,
  replace it there (bsc#915947)
* Fri Jan  9 2015 meissner@suse.com
- openssl 1.0.1k release
  bsc#912294 CVE-2014-3571: Fix DTLS segmentation fault in dtls1_get_record.
  bsc#912292 CVE-2015-0206: Fix DTLS memory leak in dtls1_buffer_record.
  bsc#911399 CVE-2014-3569: Fix issue where no-ssl3 configuration sets method to NULL.
  bsc#912015 CVE-2014-3572: Abort handshake if server key exchange
    message is omitted for ephemeral ECDH ciphersuites.
  bsc#912014 CVE-2015-0204: Remove non-export ephemeral RSA code on client and server.
  bsc#912293 CVE-2015-0205: Fixed issue where DH client certificates are accepted without verification.
  bsc#912018 CVE-2014-8275: Fix various certificate fingerprint issues.
  bsc#912296 CVE-2014-3570: Correct Bignum squaring.
  and other bugfixes.
- openssl.keyring: use Matt Caswells current key.
  pub  2048R/0E604491 2013-04-30
  uid                            Matt Caswell <frodo@baggins.org>
  uid                            Matt Caswell <matt@openssl.org>
  sub  2048R/E3C21B70 2013-04-30
- openssl-1.0.1e-fips.patch: rediffed
- openssl-1.0.1i-noec2m-fix.patch: removed (upstream)
- openssl-ocloexec.patch: rediffed
* Tue Nov 18 2014 brian@aljex.com
- suse_version 10.1 & 10.2 x86_64 can not enable-ec_nistp_64_gcc_128
* Mon Nov 17 2014 meissner@suse.com
- openssl-1.0.1i-noec2m-fix.patch: only report the Elliptic Curves
  we actually support (not the binary ones) (bnc#905037)
* Fri Nov  7 2014 brian@aljex.com
- openSUSE < 11.2 doesn't have accept4()
* Tue Oct 21 2014 crrodriguez@opensuse.org
- openSSL 1.0.1j
  * Fix SRTP Memory Leak (CVE-2014-3513)
  * Session Ticket Memory Leak (CVE-2014-3567)
  * Add SSL 3.0 Fallback protection (TLS_FALLBACK_SCSV)
  * Build option no-ssl3 is incomplete (CVE-2014-3568)
* Thu Aug 21 2014 meissner@suse.com
- openssl.keyring: the 1.0.1i release was done by
  Matt Caswell <matt@openssl.org> UK 0E604491
* Thu Aug 14 2014 vcizek@suse.com
- rename README.SuSE (old spelling) to README.SUSE (bnc#889013)
* Wed Aug 13 2014 vcizek@suse.com
- update to 1.0.1i
  * Fix SRP buffer overrun vulnerability. Invalid parameters passed to the
    SRP code can be overrun an internal buffer. Add sanity check that
    g, A, B < N to SRP code.
    (CVE-2014-3512)
  * A flaw in the OpenSSL SSL/TLS server code causes the server to negotiate
    TLS 1.0 instead of higher protocol versions when the ClientHello message
    is badly fragmented. This allows a man-in-the-middle attacker to force a
    downgrade to TLS 1.0 even if both the server and the client support a
    higher protocol version, by modifying the client's TLS records.
    (CVE-2014-3511)
  * OpenSSL DTLS clients enabling anonymous (EC)DH ciphersuites are subject
    to a denial of service attack. A malicious server can crash the client
    with a null pointer dereference (read) by specifying an anonymous (EC)DH
    ciphersuite and sending carefully crafted handshake messages.
    (CVE-2014-3510)
  * By sending carefully crafted DTLS packets an attacker could cause openssl
    to leak memory. This can be exploited through a Denial of Service attack.
    (CVE-2014-3507)
  * An attacker can force openssl to consume large amounts of memory whilst
    processing DTLS handshake messages. This can be exploited through a
    Denial of Service attack.
    (CVE-2014-3506)
  * An attacker can force an error condition which causes openssl to crash
    whilst processing DTLS packets due to memory being freed twice. This
    can be exploited through a Denial of Service attack.
    (CVE-2014-3505)
  * If a multithreaded client connects to a malicious server using a resumed
    session and the server sends an ec point format extension it could write
    up to 255 bytes to freed memory.
    (CVE-2014-3509)
  * A malicious server can crash an OpenSSL client with a null pointer
    dereference (read) by specifying an SRP ciphersuite even though it was not
    properly negotiated with the client. This can be exploited through a
    Denial of Service attack.
    (CVE-2014-5139)
  * A flaw in OBJ_obj2txt may cause pretty printing functions such as
    X509_name_oneline, X509_name_print_ex et al. to leak some information
    from the stack. Applications may be affected if they echo pretty printing
    output to the attacker.
    (CVE-2014-3508)
  * Fix ec_GFp_simple_points_make_affine (thus, EC_POINTs_mul etc.)
    for corner cases. (Certain input points at infinity could lead to
    bogus results, with non-infinity inputs mapped to infinity too.)
- refreshed patches:
  * openssl-1.0.1e-new-fips-reqs.patch
  * 0005-libssl-Hide-library-private-symbols.patch
    (thanks to Marcus Meissner)
* Mon Jul 21 2014 jengelh@inai.de
- Move manpages around: *.1ssl should be in openssl
  (e.g. ciphers(1ssl) is also referenced by openssl(1)),
  and *.3ssl should be in openssl-doc.
* Tue Jun 24 2014 meissner@suse.com
- recommend: ca-certificates-mozilla instead of openssl-certs
* Thu Jun  5 2014 meissner@suse.com
- updated openssl to 1.0.1h (bnc#880891):
  - CVE-2014-0224: Fix for SSL/TLS MITM flaw. An attacker using a carefully crafted
    handshake can force the use of weak keying material in OpenSSL
    SSL/TLS clients and servers.
  - CVE-2014-0221: Fix DTLS recursion flaw. By sending an invalid DTLS handshake to an
    OpenSSL DTLS client the code can be made to recurse eventually crashing
    in a DoS attack.
  - CVE-2014-0195: Fix DTLS invalid fragment vulnerability. A buffer
    overrun attack can be triggered by sending invalid DTLS fragments to
    an OpenSSL DTLS client or server. This is potentially exploitable to
    run arbitrary code on a vulnerable client or server.
  - CVE-2014-3470: Fix bug in TLS code where clients enable anonymous
    ECDH ciphersuites are subject to a denial of service attack.
- openssl-buffreelistbug-aka-CVE-2010-5298.patch: removed, upstream
- CVE-2014-0198.patch: removed, upstream
- 0009-Fix-double-frees.patch: removed, upstream
- 0012-Fix-eckey_priv_encode.patch: removed, upstream
- 0017-Double-free-in-i2o_ECPublicKey.patch: removed, upstream
- 0018-fix-coverity-issues-966593-966596.patch: removed, upstream
- 0020-Initialize-num-properly.patch: removed, upstream
- 0022-bignum-allow-concurrent-BN_MONT_CTX_set_locked.patch: removed, upstream
- 0023-evp-prevent-underflow-in-base64-decoding.patch: removed, upstream
- 0024-Fixed-NULL-pointer-dereference-in-PKCS7_dataDecode-r.patch: removed, upstream
- 0025-fix-coverity-issue-966597-error-line-is-not-always-i.patch: removed, upstream
- 0001-libcrypto-Hide-library-private-symbols.patch: disabled heartbeat testcase
- openssl-1.0.1c-ipv6-apps.patch: refreshed
- openssl-fix-pod-syntax.diff: some stuff merged upstream, refreshed
* Wed May 21 2014 vpereira@novell.com
- Added new SUSE default cipher suite
  openssl-1.0.1e-add-suse-default-cipher.patch
  openssl-1.0.1e-add-suse-default-cipher-header.patch
  openssl-1.0.1e-add-test-suse-default-cipher-suite.patch
* Fri May  9 2014 crrodriguez@opensuse.org
- Add upstream patches fixing coverity scan issues:
  * 0018-fix-coverity-issues-966593-966596.patch
  * 0020-Initialize-num-properly.patch
  * 0022-bignum-allow-concurrent-BN_MONT_CTX_set_locked.patch
  * 0023-evp-prevent-underflow-in-base64-decoding.patch
  * 0024-Fixed-NULL-pointer-dereference-in-PKCS7_dataDecode-r.patch
  * 0025-fix-coverity-issue-966597-error-line-is-not-always-i.patch
- Update 0001-libcrypto-Hide-library-private-symbols.patch
  to cover more private symbols, now 98%% complete and probably
  not much more can be done to fix the rest of the ill-defined API.
- openssl-fips-hidden.patch new, hides private symbols added by the
  FIPS patches.
- openssl-no-egd.patch disable the EGD (entropy gathering daemon)
  interface, we have no EGD in the distro and obtaining entropy from
  a place other than /dev/*random, the hardware rng or the openSSL
  internal PRNG is an extremely bad & dangerous idea.
- use secure_getenv instead of getenv everywhere.
* Mon May  5 2014 crrodriguez@opensuse.org
-  0005-libssl-Hide-library-private-symbols.patch
  Update to hide more symbols that are not part of
  the public API
- openssl-gcc-attributes.patch BUF_memdup also
  needs attribute alloc_size as it returns memory
  of size of the second parameter.
- openssl-ocloexec.patch Update, accept()
  also needs O_CLOEXEC.
- 0009-Fix-double-frees.patch, 0017-Double-free-in-i2o_ECPublicKey.patch
  fix various double frees (from upstream)
- 012-Fix-eckey_priv_encode.patch eckey_priv_encode should
  return an error inmediately on failure of i2d_ECPrivateKey (from upstream)
- 0001-Axe-builtin-printf-implementation-use-glibc-instead.patch
  From libressl, modified to work on linux systems that do not have
  funopen() but fopencookie() instead.
  Once upon a time, OS didn't have snprintf, which caused openssl to
  bundle a *printf implementation. We know better nowadays, the glibc
  implementation has buffer overflow checking, has sane failure modes
  deal properly with threads, signals..etc..
- build with -fno-common as well.
* Mon May  5 2014 citypw@gmail.com
- Fixed bug[ bnc#876282], CVE-2014-0198 openssl: OpenSSL NULL pointer dereference in do_ssl3_write
  Add file: CVE-2014-0198.patch
* Sun Apr 20 2014 crrodriguez@opensuse.org
- Build everything with full RELRO (-Wl,-z,relro,-z,now)
- Remove -fstack-protector from the hardcoded build options
  it is already in RPM_OPT_FLAGS and is replaced by
  - fstack-protector-strong with gcc 4.9
* Sun Apr 20 2014 crrodriguez@opensuse.org
- Remove the "gmp" and "capi" shared engines, nobody noticed
  but they are just dummies that do nothing.
* Sat Apr 19 2014 crrodriguez@opensuse.org
- Use enable-rfc3779 to allow projects such as rpki.net
  to work in openSUSE and match the functionality
  available in Debian/Fedora/etc
* Sat Apr 19 2014 crrodriguez@opensuse.org
- openssl-buffreelistbug-aka-CVE-2010-5298.patch fix
  CVE-2010-5298 and disable the internal BUF_FREELISTS
  functionality. it hides bugs like heartbleed and is
  there only for systems on which malloc() free() are slow.
- ensure we export MALLOC_CHECK and PERTURB during the test
  suite, now that the freelist functionality is disabled it
  will help to catch bugs before they hit users.
* Sat Apr 19 2014 crrodriguez@opensuse.org
- openssl-libssl-noweakciphers.patch do not offer "export"
  or "low" quality ciphers by default. using such ciphers
  is not forbidden but requires an explicit request
* Fri Apr 18 2014 crrodriguez@opensuse.org
- openssl-gcc-attributes.patch: fix thinko, CRYPTO_realloc_clean does
  not return memory of "num * old_num" but only "num" size
  fortunately this function is currently unused.
* Fri Apr 11 2014 crrodriguez@opensuse.org
- openssl-gcc-attributes.patch
  * annotate memory allocation wrappers with attribute(alloc_size)
    so the compiler can tell us if it knows they are being misused
  * OPENSSL_showfatal is annotated with attribute printf to detect
    format string problems.
- It is time to try to disable SSLv2 again, it was tried a while
  ago but broke too many things, nowadays Debian, Ubuntu, the BSDs
  all have disabled it, most components are already fixed.
  I will fix the remaining fallout if any. (email me)
* Tue Apr  8 2014 dmueller@suse.com
- update to 1.0.1g:
  * fix for critical TLS heartbeat read overrun (CVE-2014-0160) (bnc#872299)
  * Fix for Recovering OpenSSL ECDSA Nonces (CVE-2014-0076) (bnc#869945)
  * Workaround for the "TLS hang bug" (see FAQ and PR#2771)
- remove CVE-2014-0076.patch
- openssl.keyring: upstream changed to:
  pub  4096R/FA40E9E2 2005-03-19 Dr Stephen N Henson <steve@openssl.org>
  uid                            Dr Stephen Henson <shenson@drh-consultancy.co.uk>
  uid                            Dr Stephen Henson <shenson@opensslfoundation.com>
* Tue Mar 25 2014 shchang@suse.com
- Fix bug[ bnc#869945] CVE-2014-0076: openssl: Recovering OpenSSL ECDSA Nonces Using the FLUSH+RELOAD Cache Side-channel Attack
  Add file: CVE-2014-0076.patch
* Mon Mar  3 2014 shchang@suse.com
- additional changes required for FIPS validation( from Fedora repo)
  Add patch file: openssl-1.0.1e-new-fips-reqs.patch
* Sat Jan 11 2014 shchang@suse.com
- Remove GCC option "-O3" for compiliation issue of ARM version
  Modify: openssl.spec
* Fri Jan 10 2014 shchang@suse.com
- Adjust the installation path( libopenssl/hmac into /lib or /lib64)
  Modify files: README-FIPS.txt openssl.spec
* Thu Jan  9 2014 andreas.stieger@gmx.de
- 1.0.1f:
  * Fix for TLS record tampering bug CVE-2013-4353
- already included:
  * Fix for TLS version checking bug CVE-2013-6449
  * Fix for DTLS retransmission bug CVE-2013-6450
- removed patches:
  * CVE-2013-6449.patch, committed upstream
  * CVE-2013-6450.patch, committed upstream
  * SSL_get_certificate-broken.patch, committed upstream
  * openssl-1.0.1e-bnc822642.patch, committed upstream
- modified patches:
  * openssl-1.0.1e-fips.patch, adjust for upstream changes
  * openssl-fix-pod-syntax.diff, adjust for upstream changes
* Wed Jan  8 2014 andreas.stieger@gmx.de
- add a gpg keyring for source tarball
* Wed Jan  8 2014 shchang@suse.com
- Fixed bnc#857850, openssl doesn't load engine
  Modify file: openssl.spec
* Thu Jan  2 2014 shchang@suse.com
- Fixed bnc#857203, openssl: crash in DTLS renegotiation after packet loss
  Add file: CVE-2013-6450.patch
* Sun Dec 22 2013 shchang@suse.com
- Fixed bnc#856687, openssl: crash when using TLS 1.2
  Add file: CVE-2013-6449.patch
* Tue Dec 17 2013 meissner@suse.com
- compression_methods_switch.patch: setenv might not be successful
  if a surrounding library or application filters it, like e.g. sudo.
  As setenv() does not seem to be useful anyway, remove it.
  bnc#849377
* Mon Dec 16 2013 shchang@suse.com
- Adjust the installation path.
  Modify files: README-FIPS.txt openssl.spec
* Fri Dec  6 2013 lnussel@suse.de
- don't own /etc/ssl/certs, it's owned by ca-certificates
* Tue Dec  3 2013 meissner@suse.com
- Actually enable it (in a building way) for openSUSE and SLES,
  as we intended.
- Add README-FIPS.txt from SLE 11.
* Mon Dec  2 2013 crrodriguez@opensuse.org
- Restrict the (broken beyond build) FIPS certification code
  to SLE releases only, it has no value in openSUSE at all.
* Sat Nov 23 2013 shchang@suse.com
- Patches for OpenSSL FIPS-140-2/3 certification
  Add patch files: openssl-1.0.1e-fips.patch, openssl-1.0.1e-fips-ec.patch,
  openssl-1.0.1e-fips-ctor.patch
* Wed Oct 23 2013 crrodriguez@opensuse.org
- 0001-libcrypto-Hide-library-private-symbols.patch
  This patch implements the libcrpto part complimentary to
  0005-libssl-Hide-library-private-symbols.patch.
  This patch is however not 100%% complete, as some private library
  symbols are declared in public headers that shall not be touched
  or are defined/declared in "perlasm". (tested in 13.1, 12.3, factory)
- openSSL defaults to -O3 optimization level but we override
  it with RPM_OPT_FLAGS, ensure we use -O3 like upstream.
* Fri Oct 11 2013 meissner@suse.com
- openssl-1.0.1c-ipv6-apps.patch:
  Support ipv6 in the openssl s_client / s_server commandline app.
* Fri Sep 27 2013 dmacvicar@suse.de
- VPN openconnect problem (DTLS handshake failed)
  (git 9fe4603b8, bnc#822642, openssl ticket#2984)
* Wed Sep  4 2013 guillaume@opensuse.org
- Fix armv6l arch (armv7 was previously used to build armv6 which
  lead to illegal instruction when used)
* Mon Aug 12 2013 shchang@suse.com
- Fix bug[ bnc#832833] openssl ssl_set_cert_masks() is broken
  modify patch file: SSL_get_certificate-broken.patch
* Fri Aug  9 2013 crrodriguez@opensuse.org
- Via padlock is only found in x86 and x86_64 CPUs, remove
  the shared module for other archs.
* Wed Aug  7 2013 crrodriguez@opensuse.org
- Cleanup engines that are of no use in a modern linux distro
- The following engines stay:
  * libcapi.so --> usable in case you have third party /dev/crypto
  * libgmp.so --> may help to doing some maths using GMP
  * libgost.so --> implements the GOST block cipher
  * libpadlock.so --> VIA padlock support
- Al other are removed because they require third party propietary
  shared libraries nowhere to be found or that we can test.
* Wed Aug  7 2013 crrodriguez@opensuse.org
- openssl-pkgconfig.patch: Here we go.. For applications
  to benefit fully of features provided by openSSL engines
  (rdrand, aes-ni..etc) either builtin or in DSO form applications
  have to call ENGINE_load_builtin_engines() or OPENSSL_config()
  unfortunately from a total of 68 apps/libraries linked to libcrypto
  in a desktop system, only 4 do so, and there is a sea of buggy
  code that I dont feel like fixing.
  Instead we can pass -DOPENSSL_LOAD_CONF in the pkgconfig files
  so the needed operation becomes implicit the next time such apps
  are recompiled, see OPENSSL_config(3)
  Unfortunately this does not fix everything, because there are apps
  not using pkgconfig or using it incorrectly, but it is a good start.
* Wed Aug  7 2013 dmueller@suse.com
- add openssl-1.0.1c-default-paths.patch:
  Fix from Fedora for openssl s_client not setting
  CApath by default
* Sat Aug  3 2013 crrodriguez@opensuse.org
- 0005-libssl-Hide-library-private-symbols.patch: hide
  private symbols, this *only* applies to libssl where
  it is straightforward to do so as applications should
  not be using any of the symbols declared/defined in headers
  that the library does not install.
  A separate patch MAY be provided in the future for libcrypto
  where things are much more complicated and threfore requires
  careful testing.
* Mon Jul 29 2013 meissner@suse.com
- compression_methods_switch.patch: Disable compression by default to
  avoid the CRIME attack (CVE-2012-4929 bnc#793420)
  Can be override by setting environment variable
    OPENSSL_NO_DEFAULT_ZLIB=no
* Tue Jul  2 2013 lnussel@suse.de
- Don't use the legacy /etc/ssl/certs directory anymore but rather
  the p11-kit generated /var/lib/ca-certificates/openssl one
  (fate#314991, openssl-1.0.1e-truststore.diff)
* Sat Jun 29 2013 crrodriguez@opensuse.org
- Build enable-ec_nistp_64_gcc_128, ecdh is many times faster
  but only works in x86_64.
  According to the openSSL team
  "it is superior to the default in multiple regards (speed, and also
  security as the new implementations are secure against timing
  attacks)"
  It is not enabled by default due to the build system being unable
  to detect if the compiler supports __uint128_t.
* Thu Jun 20 2013 coolo@suse.com
- pick openssl-fix-pod-syntax.diff out of the upstream RT to fix
  build with perl 5.18
* Sat May 25 2013 i@marguerite.su
- add %%if tag for BuildArch. sles may also need latest openssl.
* Fri Feb 22 2013 dmueller@suse.com
- disable fstack-protector on aarch64
* Tue Feb 12 2013 hrvoje.senjan@gmail.com
- Update to 1.0.1e
  o Bugfix release (bnc#803004)
- Drop openssl-1.0.1d-s3-packet.patch, included upstream
* Sun Feb 10 2013 hrvoje.senjan@gmail.com
- Added openssl-1.0.1d-s3-packet.patch from upstream, fixes
  bnc#803004, openssl ticket#2975
* Tue Feb  5 2013 meissner@suse.com
- update to version 1.0.1d, fixing security issues
  o Fix renegotiation in TLS 1.1, 1.2 by using the correct TLS version.
  o Include the fips configuration module.
  o Fix OCSP bad key DoS attack CVE-2013-0166
  o Fix for SSL/TLS/DTLS CBC plaintext recovery attack CVE-2013-0169
    bnc#802184
  o Fix for TLS AESNI record handling flaw CVE-2012-2686
* Mon Nov 12 2012 gjhe@suse.com
- fix bug[bnc#784994] - VIA padlock support on 64 systems
  e_padlock: add support for x86_64 gcc
* Sun Aug 19 2012 crrodriguez@opensuse.org
- Open Internal file descriptors with O_CLOEXEC, leaving
  those open across fork()..execve() makes a perfect
  vector for a side-channel attack...
* Tue Aug  7 2012 dmueller@suse.com
- fix build on armv5 (bnc#774710)
* Thu May 10 2012 crrodriguez@opensuse.org
- Update to version 1.0.1c for the complete list of changes see
  NEWS, this only list packaging changes.
- Drop aes-ni patch, no longer needed as it is builtin in openssl
  now.
- Define GNU_SOURCE and use -std=gnu99 to build the package.
- Use LFS_CFLAGS in platforms where it matters.
* Fri May  4 2012 lnussel@suse.de
- don't install any demo or expired certs at all
* Mon Apr 23 2012 gjhe@suse.com
- update to latest stable verison 1.0.0i
  including the following patches:
  CVE-2012-2110.path
  Bug748738_Tolerate_bad_MIME_headers.patch
  bug749213-Free-headers-after-use.patch
  bug749210-Symmetric-crypto-errors-in-PKCS7_decrypt.patch
  CVE-2012-1165.patch
  CVE-2012-0884.patch
  bug749735.patch
* Tue Mar 27 2012 gjhe@suse.com
- fix bug[bnc#749735] - Memory leak when creating public keys.
  fix bug[bnc#751977] - CMS and S/MIME Bleichenbacher attack
  CVE-2012-0884
* Thu Mar 22 2012 gjhe@suse.com
- fix bug[bnc#751946] - S/MIME verification may erroneously fail
  CVE-2012-1165
* Wed Mar 21 2012 gjhe@suse.com
- fix bug[bnc#749213]-Free headers after use in error message
  and bug[bnc#749210]-Symmetric crypto errors in PKCS7_decrypt
* Tue Mar 20 2012 cfarrell@suse.com
- license update: OpenSSL
* Fri Feb 24 2012 gjhe@suse.com
- fix bug[bnc#748738] - Tolerate bad MIME headers in openssl's
  asn1 parser.
  CVE-2006-7250
* Thu Feb  2 2012 gjhe@suse.com
- Update to version 1.0.0g fix the following:
  DTLS DoS attack (CVE-2012-0050)
* Wed Jan 11 2012 gjhe@suse.com
- Update to version 1.0.0f fix the following:
  DTLS Plaintext Recovery Attack (CVE-2011-4108)
  Uninitialized SSL 3.0 Padding (CVE-2011-4576)
  Malformed RFC 3779 Data Can Cause Assertion Failures (CVE-2011-4577)
  SGC Restart DoS Attack (CVE-2011-4619)
  Invalid GOST parameters DoS Attack (CVE-2012-0027)
* Tue Oct 18 2011 crrodriguez@opensuse.org
- AES-NI: Check the return value of Engine_add()
  if the ENGINE_add() call fails: it ends up adding a reference
  to a freed up ENGINE which is likely to subsequently contain garbage
  This will happen if an ENGINE with the same name is added multiple
  times,for example different libraries. [bnc#720601]
* Sat Oct  8 2011 crrodriguez@opensuse.org
- Build with -DSSL_FORBID_ENULL so servers are not
  able to use the NULL encryption ciphers (Those offering no
  encryption whatsoever).
* Wed Sep  7 2011 crrodriguez@opensuse.org
- Update to openssl 1.0.0e fixes CVE-2011-3207 and CVE-2011-3210
  see http://openssl.org/news/secadv_20110906.txt for details.
* Sat Aug  6 2011 crrodriguez@opensuse.org
- Add upstream patch that calls ENGINE_register_all_complete()
  in ENGINE_load_builtin_engines() saving us from adding dozens
  of calls to such function to calling applications.
* Fri Aug  5 2011 crrodriguez@opensuse.org
- remove -fno-strict-aliasing from CFLAGS no longer needed
  and is likely to slow down stuff.
* Mon Jul 25 2011 jengelh@medozas.de
- Edit baselibs.conf to provide libopenssl-devel-32bit too
* Fri Jun 24 2011 gjhe@novell.com
- update to latest stable version 1.0.0d.
  patch removed(already in the new package):
  CVE-2011-0014
  patch added:
  ECDSA_signatures_timing_attack.patch
* Tue May 31 2011 gjhe@novell.com
- fix bug[bnc#693027].
  Add protection against ECDSA timing attacks as mentioned in the paper
  by Billy Bob Brumley and Nicola Tuveri, see:
  http://eprint.iacr.org/2011/232.pdf
  [Billy Bob Brumley and Nicola Tuveri]
* Mon May 16 2011 andrea@opensuse.org
- added openssl as dependency in the devel package
* Thu Feb 10 2011 gjhe@novell.com
- fix bug [bnc#670526]
  CVE-2011-0014,OCSP stapling vulnerability
* Sat Jan 15 2011 cristian.rodriguez@opensuse.org
- Add patch from upstream in order to support AES-NI instruction
  set present on current Intel and AMD processors
* Mon Jan 10 2011 meissner@suse.de
- enable -DPURIFY to avoid valgrind errors.
* Thu Dec  9 2010 gjhe@novell.com
- update to stable version 1.0.0c.
  patch included:
  CVE-2010-1633_and_CVE-2010-0742.patch
  patchset-19727.diff
  CVE-2010-2939.patch
  CVE-2010-3864.patch
* Thu Nov 18 2010 gjhe@novell.com
- fix bug [bnc#651003]
  CVE-2010-3864
* Sat Sep 25 2010 gjhe@novell.com
- fix bug [bnc#629905]
  CVE-2010-2939
* Wed Jul 28 2010 cristian.rodriguez@opensuse.org
- Exclude static libraries, see what breaks and fix that
  instead
* Wed Jun 30 2010 jengelh@medozas.de
- fix two compile errors on SPARC
* Tue Jun 15 2010 bg@novell.com
- -fstack-protector is not supported on hppa
* Fri Jun  4 2010 gjhe@novell.com
- fix bnc #610642
  CVE-2010-0742
  CVE-2010-1633
* Mon May 31 2010 gjhe@novell.com
- fix bnc #610223,change Configure to tell openssl to load engines
  from /%%{_lib} instead of %%{_libdir}
* Mon May 10 2010 aj@suse.de
- Do not compile in build time but use mtime of changes file instead.
  This allows build-compare to identify that no changes have happened.
* Tue May  4 2010 gjhe@novell.com
- build libopenssl to /%%{_lib} dir,and keep only one
  libopenssl-devel for new developping programs.
* Tue Apr 27 2010 gjhe@novell.com
- build libopenssl and libopenssl-devel to a version directory
* Sat Apr 24 2010 coolo@novell.com
- buildrequire pkg-config to fix provides
* Wed Apr 21 2010 lnussel@suse.de
- also create old certificate hash in /etc/ssl/certs for
  compatibility with applications that still link against 0.9.8
* Mon Apr 12 2010 meissner@suse.de
- Disable our own build targets, instead use the openSSL provided ones
  as they are now good (or should be good at least).
- add -Wa,--noexecstack to the Configure call, this is the upstream
  approved way to avoid exec-stack marking
* Mon Apr 12 2010 gjhe@novell.com
- update to 1.0.0
  Merge the following patches from 0.9.8k:
  openssl-0.9.6g-alpha.diff
  openssl-0.9.7f-ppc64.diff
  openssl-0.9.8-flags-priority.dif
  openssl-0.9.8-sparc.dif
  openssl-allow-arch.diff
  openssl-hppa-config.diff
* Fri Apr  9 2010 meissner@suse.de
- fixed "exectuable stack" for libcrypto.so issue on i586 by
  adjusting the assembler output during MMX builds.
* Wed Apr  7 2010 meissner@suse.de
- Openssl is now partially converted to libdir usage upstream,
  merge that in to fix lib64 builds.
* Thu Mar 25 2010 gjhe@novell.com
- fix security bug [bnc#590833]
  CVE-2010-0740
* Mon Mar 22 2010 gjhe@novell.com
- update to version 0.9.8m
  Merge the following patches from 0.9.8k:
  bswap.diff
  non-exec-stack.diff
  openssl-0.9.6g-alpha.diff
  openssl-0.9.7f-ppc64.diff
  openssl-0.9.8-flags-priority.dif
  openssl-0.9.8-sparc.dif
  openssl-allow-arch.diff
  openssl-hppa-config.diff
* Fri Feb  5 2010 jengelh@medozas.de
- build openssl for sparc64
* Mon Dec 14 2009 jengelh@medozas.de
- add baselibs.conf as a source
- package documentation as noarch
* Tue Nov  3 2009 coolo@novell.com
- updated patches to apply with fuzz=0
* Tue Sep  1 2009 gjhe@novell.com
- fix Bug [bnc#526319]
* Wed Aug 26 2009 coolo@novell.com
- use %%patch0 for Patch0
* Fri Jul  3 2009 gjhe@novell.com
- update to version 0.9.8k
- patches merged upstream:
  openssl-CVE-2008-5077.patch
  openssl-CVE-2009-0590.patch
  openssl-CVE-2009-0591.patch
  openssl-CVE-2009-0789.patch
  openssl-CVE-2009-1377.patch
  openssl-CVE-2009-1378.patch
  openssl-CVE-2009-1379.patch
  openssl-CVE-2009-1386.patch
  openssl-CVE-2009-1387.patch
* Tue Jun 30 2009 gjhe@novell.com
- fix security bug [bnc#509031]
  CVE-2009-1386
  CVE-2009-1387
* Tue Jun 30 2009 gjhe@novell.com
- fix security bug [bnc#504687]
  CVE-2009-1377
  CVE-2009-1378
  CVE-2009-1379
* Wed Apr 15 2009 gjhe@suse.de
- fix security bug [bnc#489641]
  CVE-2009-0590
  CVE-2009-0591
  CVE-2009-0789
* Wed Jan  7 2009 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Thu Dec 18 2008 jshi@suse.de
- fix security bug [bnc#459468]
  CVE-2008-5077
* Tue Dec  9 2008 xwhu@suse.de
- Disable optimization for s390x
* Mon Dec  8 2008 xwhu@suse.de
- Disable optimization of md4
* Mon Nov 10 2008 xwhu@suse.de
- Disable optimization of ripemd [bnc#442740]
* Tue Oct 14 2008 xwhu@suse.de
- Passing string as struct cause openssl segment-fault [bnc#430141]
* Wed Jul 16 2008 mkoenig@suse.de
- do not require openssl-certs, but rather recommend it
  to avoid dependency cycle [bnc#408865]
* Wed Jul  9 2008 mkoenig@suse.de
- remove the certs subpackage from the openssl package
  and move the CA root certificates into a package of its own
* Tue Jun 24 2008 mkoenig@suse.de
- update to version 0.9.8h
- openssl does not ship CA root certificates anymore
  keep certificates that SuSE is already shipping
- resolves bad array index (function has been removed) [bnc#356549]
- removed patches
  openssl-0.9.8g-fix_dh_for_certain_moduli.patch
  openssl-CVE-2008-0891.patch
  openssl-CVE-2008-1672.patch
* Wed May 28 2008 mkoenig@suse.de
- fix OpenSSL Server Name extension crash (CVE-2008-0891)
  and OpenSSL Omit Server Key Exchange message crash (CVE-2008-1672)
  [bnc#394317]
* Wed May 21 2008 cthiel@suse.de
- fix baselibs.conf
* Tue Apr 22 2008 mkoenig@suse.de
- add -DMD32_REG_T=int for x86_64 and ia64 [bnc#381844]
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Mon Nov  5 2007 mkoenig@suse.de
- fix Diffie-Hellman failure with certain prime lengths
* Mon Oct 22 2007 mkoenig@suse.de
- update to version 0.9.8g:
  * fix some bugs introduced with 0.9.8f
* Mon Oct 15 2007 mkoenig@suse.de
- update to version 0.9.8f:
  * fixes CVE-2007-3108, CVE-2007-5135, CVE-2007-4995
- patches merged upstream:
  openssl-0.9.8-key_length.patch
  openssl-CVE-2007-3108-bug296511
  openssl-CVE-2007-5135.patch
  openssl-gcc42.patch
  openssl-gcc42_b.patch
  openssl-s390-config.diff
* Mon Oct  1 2007 mkoenig@suse.de
- fix buffer overflow CVE-2007-5135 [#329208]
* Wed Sep  5 2007 mkoenig@suse.de
- fix another gcc 4.2 build problem [#307669]
* Fri Aug  3 2007 coolo@suse.de
- provide the version obsoleted (#293401)
* Wed Aug  1 2007 werner@suse.de
- Add patch from CVS for RSA key reconstruction vulnerability
  (CVE-2007-3108, VU#724968, bug #296511)
* Thu May 24 2007 mkoenig@suse.de
- fix build with gcc-4.2
  openssl-gcc42.patch
- do not install example scripts with executable permissions
* Sun Apr 29 2007 ro@suse.de
- adapt requires
* Fri Apr 27 2007 mkoenig@suse.de
- Do not use dots in package name
- explicitly build with gcc-4.1 because of currently unresolved
  failures with gcc-4.2
* Wed Apr 25 2007 mkoenig@suse.de
- Split/rename package to follow library packaging policy [#260219]
  New package libopenssl0.9.8 containing shared libs
  openssl-devel package renamed to libopenssl-devel
  New package openssl-certs containing certificates
- add zlib-devel to Requires of devel package
- remove old Obsoletes and Conflicts
  openssls (Last used Nov 2000)
  ssleay (Last used 6.2)
* Mon Apr 23 2007 mkoenig@suse.de
- Fix key length [#254905,#262477]
* Tue Mar  6 2007 mkoenig@suse.de
- update to version 0.9.8e:
  * patches merged upstream:
    openssl-CVE-2006-2940-fixup.patch
    openssl-0.9.8d-padlock-static.patch
* Tue Jan  9 2007 mkoenig@suse.de
- fix PadLock support [#230823]
* Thu Nov 30 2006 mkoenig@suse.de
- enable fix for CVE-2006-2940 [#223040], SWAMP-ID 7198
* Mon Nov  6 2006 poeml@suse.de
- configure with 'zlib' instead of 'zlib-dynamic'. Build with the
  latter, there are problems opening the libz when running on the
  Via Epia or vmware platforms. [#213305]
* Wed Oct  4 2006 poeml@suse.de
- add patch for the CVE-2006-2940 fix: the newly introduced limit
  on DH modulus size could lead to a crash when exerted. [#208971]
  Discovered and fixed after the 0.9.8d release.
* Fri Sep 29 2006 poeml@suse.de
- update to 0.9.8d
  * ) Introduce limits to prevent malicious keys being able to
    cause a denial of service.  (CVE-2006-2940)
  * ) Fix ASN.1 parsing of certain invalid structures that can result
    in a denial of service.  (CVE-2006-2937)
  * ) Fix buffer overflow in SSL_get_shared_ciphers() function.
    (CVE-2006-3738)
  * ) Fix SSL client code which could crash if connecting to a
    malicious SSLv2 server.  (CVE-2006-4343)
  * ) Since 0.9.8b, ciphersuite strings naming explicit ciphersuites
    match only those.  Before that, "AES256-SHA" would be interpreted
    as a pattern and match "AES128-SHA" too (since AES128-SHA got
    the same strength classification in 0.9.7h) as we currently only
    have a single AES bit in the ciphersuite description bitmap.
    That change, however, also applied to ciphersuite strings such as
    "RC4-MD5" that intentionally matched multiple ciphersuites --
    namely, SSL 2.0 ciphersuites in addition to the more common ones
    from SSL 3.0/TLS 1.0.
    So we change the selection algorithm again: Naming an explicit
    ciphersuite selects this one ciphersuite, and any other similar
    ciphersuite (same bitmap) from *other* protocol versions.
    Thus, "RC4-MD5" again will properly select both the SSL 2.0
    ciphersuite and the SSL 3.0/TLS 1.0 ciphersuite.
    Since SSL 2.0 does not have any ciphersuites for which the
    128/256 bit distinction would be relevant, this works for now.
    The proper fix will be to use different bits for AES128 and
    AES256, which would have avoided the problems from the beginning;
    however, bits are scarce, so we can only do this in a new release
    (not just a patchlevel) when we can change the SSL_CIPHER
    definition to split the single 'unsigned long mask' bitmap into
    multiple values to extend the available space.
- not in mentioned in CHANGES: patch for CVE-2006-4339 corrected
  [openssl.org #1397]
* Fri Sep  8 2006 schwab@suse.de
- Fix inverted logic.
* Wed Sep  6 2006 poeml@suse.de
- update to 0.9.8c
  Changes between 0.9.8b and 0.9.8c  [05 Sep 2006]
  * ) Avoid PKCS #1 v1.5 signature attack discovered by Daniel Bleichenbacher
    (CVE-2006-4339)  [Ben Laurie and Google Security Team]
  * ) Add AES IGE and biIGE modes.  [Ben Laurie]
  * ) Change the Unix randomness entropy gathering to use poll() when
    possible instead of select(), since the latter has some
    undesirable limitations.  [Darryl Miles via Richard Levitte and Bodo Moeller]
  * ) Disable "ECCdraft" ciphersuites more thoroughly.  Now special
    treatment in ssl/ssl_ciph.s makes sure that these ciphersuites
    cannot be implicitly activated as part of, e.g., the "AES" alias.
    However, please upgrade to OpenSSL 0.9.9[-dev] for
    non-experimental use of the ECC ciphersuites to get TLS extension
    support, which is required for curve and point format negotiation
    to avoid potential handshake problems.  [Bodo Moeller]
  * ) Disable rogue ciphersuites:
  - SSLv2 0x08 0x00 0x80 ("RC4-64-MD5")
  - SSLv3/TLSv1 0x00 0x61 ("EXP1024-RC2-CBC-MD5")
  - SSLv3/TLSv1 0x00 0x60 ("EXP1024-RC4-MD5")
    The latter two were purportedly from
    draft-ietf-tls-56-bit-ciphersuites-0[01].txt, but do not really
    appear there.
    Also deactive the remaining ciphersuites from
    draft-ietf-tls-56-bit-ciphersuites-01.txt.  These are just as
    unofficial, and the ID has long expired.  [Bodo Moeller]
  * ) Fix RSA blinding Heisenbug (problems sometimes occured on
    dual-core machines) and other potential thread-safety issues.
    [Bodo Moeller]
  * ) Add the symmetric cipher Camellia (128-bit, 192-bit, 256-bit key
    versions), which is now available for royalty-free use
    (see http://info.isl.ntt.co.jp/crypt/eng/info/chiteki.html).
    Also, add Camellia TLS ciphersuites from RFC 4132.
    To minimize changes between patchlevels in the OpenSSL 0.9.8
    series, Camellia remains excluded from compilation unless OpenSSL
    is configured with 'enable-camellia'.  [NTT]
  * ) Disable the padding bug check when compression is in use. The padding
    bug check assumes the first packet is of even length, this is not
    necessarily true if compresssion is enabled and can result in false
    positives causing handshake failure. The actual bug test is ancient
    code so it is hoped that implementations will either have fixed it by
    now or any which still have the bug do not support compression.
    [Steve Henson]
  Changes between 0.9.8a and 0.9.8b  [04 May 2006]
  * ) When applying a cipher rule check to see if string match is an explicit
    cipher suite and only match that one cipher suite if it is.  [Steve Henson]
  * ) Link in manifests for VC++ if needed.  [Austin Ziegler <halostatue@gmail.com>]
  * ) Update support for ECC-based TLS ciphersuites according to
    draft-ietf-tls-ecc-12.txt with proposed changes (but without
    TLS extensions, which are supported starting with the 0.9.9
    branch, not in the OpenSSL 0.9.8 branch).  [Douglas Stebila]
  * ) New functions EVP_CIPHER_CTX_new() and EVP_CIPHER_CTX_free() to support
    opaque EVP_CIPHER_CTX handling.  [Steve Henson]
  * ) Fixes and enhancements to zlib compression code. We now only use
    "zlib1.dll" and use the default __cdecl calling convention on Win32
    to conform with the standards mentioned here:
    http://www.zlib.net/DLL_FAQ.txt
    Static zlib linking now works on Windows and the new --with-zlib-include
  - -with-zlib-lib options to Configure can be used to supply the location
    of the headers and library. Gracefully handle case where zlib library
    can't be loaded.  [Steve Henson]
  * ) Several fixes and enhancements to the OID generation code. The old code
    sometimes allowed invalid OIDs (1.X for X >= 40 for example), couldn't
    handle numbers larger than ULONG_MAX, truncated printing and had a
    non standard OBJ_obj2txt() behaviour.  [Steve Henson]
  * ) Add support for building of engines under engine/ as shared libraries
    under VC++ build system.  [Steve Henson]
  * ) Corrected the numerous bugs in the Win32 path splitter in DSO.
    Hopefully, we will not see any false combination of paths any more.
    [Richard Levitte]
- enable Camellia cipher. There is a royalty free license to the
  patents, see http://info.isl.ntt.co.jp/crypt/eng/info/chiteki.html.
  NOTE: the license forbids patches to the cipher.
- build with zlib-dynamic and add zlib-devel to BuildRequires.
  Allows compression of data in TLS, although few application would
  actually use it since there is no standard for negotiating the
  compression method. The only one I know if is stunnel.
* Fri Jun  2 2006 poeml@suse.de
- fix built-in ENGINESDIR for 64 bit architectures. We change only
  the builtin search path for engines, not the path where engines
  are packaged. Path can be overridden with the OPENSSL_ENGINES
  environment variable. [#179094]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Mon Jan 16 2006 mc@suse.de
- fix build problems on s390x (openssl-s390-config.diff)
- build with -fstack-protector
* Mon Nov  7 2005 dmueller@suse.de
- build with non-executable stack
* Thu Oct 20 2005 poeml@suse.de
- fix unguarded free() which can cause a segfault in the ca
  commandline app [#128655]
* Thu Oct 13 2005 poeml@suse.de
- add Geotrusts Equifax Root1 CA certificate, which needed to
  verify the authenticity of you.novell.com [#121966]
* Tue Oct 11 2005 poeml@suse.de
- update to 0.9.8a
  * ) Remove the functionality of SSL_OP_MSIE_SSLV2_RSA_PADDING
    (part of SSL_OP_ALL).  This option used to disable the
    countermeasure against man-in-the-middle protocol-version
    rollback in the SSL 2.0 server implementation, which is a bad
    idea.  (CAN-2005-2969)
  * ) Add two function to clear and return the verify parameter flags.
  * ) Keep cipherlists sorted in the source instead of sorting them at
    runtime, thus removing the need for a lock.
  * ) Avoid some small subgroup attacks in Diffie-Hellman.
  * ) Add functions for well-known primes.
  * ) Extended Windows CE support.
  * ) Initialize SSL_METHOD structures at compile time instead of during
    runtime, thus removing the need for a lock.
  * ) Make PKCS7_decrypt() work even if no certificate is supplied by
    attempting to decrypt each encrypted key in turn. Add support to
    smime utility.
* Thu Sep 29 2005 poeml@suse.de
- update to 0.9.8
  see CHANGES file or http://www.openssl.org/news/changelog.html
- adjust patches
- drop obsolete openssl-no-libc.diff
- disable libica patch until it has been ported
* Fri May 20 2005 poeml@suse.de
- update to 0.9.7g. The significant changes are:
  * ) Fixes for newer kerberos headers. NB: the casts are needed because
    the 'length' field is signed on one version and unsigned on another
    with no (?) obvious way to tell the difference, without these VC++
    complains. Also the "definition" of FAR (blank) is no longer included
    nor is the error ENOMEM. KRB5_PRIVATE has to be set to 1 to pick up
    some needed definitions.
  * ) Added support for proxy certificates according to RFC 3820.
    Because they may be a security thread to unaware applications,
    they must be explicitely allowed in run-time.  See
    docs/HOWTO/proxy_certificates.txt for further information.
* Tue May 17 2005 schwab@suse.de
- Include %%cflags_profile_generate in ${CC} since it is required for
  linking as well.
- Remove explicit reference to libc.
* Fri Apr  8 2005 poeml@suse.de
- update to 0.9.7f. The most significant changes are:
    o Several compilation issues fixed.
    o Many memory allocation failure checks added.
    o Improved comparison of X509 Name type.
    o Mandatory basic checks on certificates.
    o Performance improvements.
  (for a complete list see http://www.openssl.org/source/exp/CHANGES)
- adjust openssl-0.9.7f-ppc64.diff
- drop obsolete openssl-0.9.7d-crl-default_md.dif [#55435]
* Tue Jan  4 2005 poeml@suse.de
- update to 0.9.7e
  * ) Avoid a race condition when CRLs are checked in a multi
    threaded environment. This would happen due to the reordering
    of the revoked entries during signature checking and serial
    number lookup. Now the encoding is cached and the serial
    number sort performed under a lock.  Add new STACK function
    sk_is_sorted().
  * ) Add Delta CRL to the extension code.
  * ) Various fixes to s3_pkt.c so alerts are sent properly.
  * ) Reduce the chances of duplicate issuer name and serial numbers
    (in violation of RFC3280) using the OpenSSL certificate
    creation utilities.  This is done by creating a random 64 bit
    value for the initial serial number when a serial number file
    is created or when a self signed certificate is created using
    'openssl req -x509'. The initial serial number file is created
    using 'openssl x509 -next_serial' in CA.pl rather than being
    initialized to 1.
- remove obsolete patches
- fix openssl-0.9.7d-padlock-glue.diff and ICA patch to patch
  Makefile, not Makefile.ssl
- fixup for spaces in names of man pages not needed now
- pack /usr/bin/openssl_fips_fingerprint
- in rpm post/postun script, run /sbin/ldconfig directly (the macro
  is deprecated)
* Mon Oct 18 2004 poeml@suse.de
- don't install openssl.doxy file [#45210]
* Thu Jul 29 2004 poeml@suse.de
- apply patch from CVS to fix segfault in S/MIME encryption
  (http://cvs.openssl.org/chngview?cn=12081, regression in
  openssl-0.9.7d) [#43386]
* Mon Jul 12 2004 mludvig@suse.cz
- Updated VIA PadLock engine.
* Wed Jun 30 2004 mludvig@suse.cz
- Updated openssl-0.9.7d-padlock-engine.diff with support for
  AES192, AES256 and RNG.
* Tue Jun 15 2004 poeml@suse.de
- update IBM ICA patch to last night's version. Fixes ibmca_init()
  to reset ibmca_dso=NULL after calling DSO_free(), if the device
  driver could not be loaded. The bug lead to a segfault triggered
  by stunnel, which does autoload available engines [#41874]
- patch from CVS: make stack API more robust (return NULL for
  out-of-range indexes). Fixes another possible segfault during
  engine detection (could also triggered by stunnel)
- add patch from Michal Ludvig for VIA PadLock support
* Wed Jun  2 2004 poeml@suse.de
- add root certificate for the ICP-Brasil CA [#41546]
* Thu May 13 2004 poeml@suse.de
- add patch to use default_md for CRLs too [#40435]
* Tue May  4 2004 poeml@suse.de
- update ICA patch to apr292004 release [#39695]
* Thu Mar 18 2004 poeml@suse.de
- update to 0.9.7d
  o Security: Fix Kerberos ciphersuite SSL/TLS handshaking bug
    (CAN-2004-0112)
  o Security: Fix null-pointer assignment in do_change_cipher_spec()
    (CAN-2004-0079)
  o Allow multiple active certificates with same subject in CA index
  o Multiple X590 verification fixes
  o Speed up HMAC and other operations
- remove the hunk from openssl-0.9.6d.dif that added NO_IDEA around
  IDEA_128_CBC_WITH_MD5 in the global cipher list. Upstream now has
  OPENSSL_NO_IDEA around it
- [#36386] fixed (broken generation of EVP_BytesToKey.3ssl from the
  pod file)
- permissions of lib/pkgconfig fixed
* Wed Feb 25 2004 poeml@suse.de
- update to 0.9.7c
  * ) Fix various bugs revealed by running the NISCC test suite:
    Stop out of bounds reads in the ASN1 code when presented with
    invalid tags (CAN-2003-0543 and CAN-2003-0544).
    Free up ASN1_TYPE correctly if ANY type is invalid (CAN-2003-0545).
    If verify callback ignores invalid public key errors don't try to check
    certificate signature with the NULL public key.
  * ) New -ignore_err option in ocsp application to stop the server
    exiting on the first error in a request.
  * ) In ssl3_accept() (ssl/s3_srvr.c) only accept a client certificate
    if the server requested one: as stated in TLS 1.0 and SSL 3.0
    specifications.
  * ) In ssl3_get_client_hello() (ssl/s3_srvr.c), tolerate additional
    extra data after the compression methods not only for TLS 1.0
    but also for SSL 3.0 (as required by the specification).
  * ) Change X509_certificate_type() to mark the key as exported/exportable
    when it's 512 *bits* long, not 512 bytes.
  * ) Change AES_cbc_encrypt() so it outputs exact multiple of
    blocks during encryption.
  * ) Various fixes to base64 BIO and non blocking I/O. On write
    flushes were not handled properly if the BIO retried. On read
    data was not being buffered properly and had various logic bugs.
    This also affects blocking I/O when the data being decoded is a
    certain size.
  * ) Various S/MIME bugfixes and compatibility changes:
    output correct application/pkcs7 MIME type if
    PKCS7_NOOLDMIMETYPE is set. Tolerate some broken signatures.
    Output CR+LF for EOL if PKCS7_CRLFEOL is set (this makes opening
    of files as .eml work). Correctly handle very long lines in MIME
    parser.
- update ICA patch
  quote: This version of the engine patch has updated error handling in
  the DES/SHA code, and turns RSA blinding off for hardware
  accelerated RSA ops.
- filenames of some man pages contain spaces now. Replace them with
  underscores
- fix compiler warnings in showciphers.c
- fix permissions of /usr/%%_lib/pkgconfig
* Sat Jan 10 2004 adrian@suse.de
- add %%run_ldconfig
- remove unneeded PreRequires
* Tue Nov 18 2003 poeml@suse.de
- ditch annoying mail to root about moved locations [#31969]
* Wed Aug 13 2003 poeml@suse.de
- enable profile feedback based optimizations (except AES which
  becomes slower)
- add -fno-strict-aliasing, due to warnings about code where
  dereferencing type-punned pointers will break strict aliasing
- make a readlink function if readlink is not available
* Mon Aug  4 2003 ro@suse.de
- fixed manpages symlinks
* Wed Jul 30 2003 meissner@suse.de
- Fix Makefile to create pkgconfig file with lib64 on lib64 systems.
* Sun Jul 27 2003 poeml@suse.de
- don't explicitely strip binaries since RPM handles it, and may
  keep the stripped information somewhere
* Tue Jul 15 2003 meissner@suse.de
- -DMD32_REG_T=int for ppc64 and s390x.
* Thu Jul 10 2003 poeml@suse.de
- update ibm ICA patch to 20030708 release (libica-1.3)
* Mon May 12 2003 poeml@suse.de
- package the openssl.pc file for pkgconfig
* Wed Apr 16 2003 poeml@suse.de
- update to 0.9.7b. The most significant changes are:
  o New library section OCSP.
  o Complete rewrite of ASN1 code.
  o CRL checking in verify code and openssl utility.
  o Extension copying in 'ca' utility.
  o Flexible display options in 'ca' utility.
  o Provisional support for international characters with UTF8.
  o Support for external crypto devices ('engine') is no longer
    a separate distribution.
  o New elliptic curve library section.
  o New AES (Rijndael) library section.
  o Support for new platforms: Windows CE, Tandem OSS, A/UX, AIX 64-bit,
    Linux x86_64, Linux 64-bit on Sparc v9
  o Extended support for some platforms: VxWorks
  o Enhanced support for shared libraries.
  o Now only builds PIC code when shared library support is requested.
  o Support for pkg-config.
  o Lots of new manuals.
  o Makes symbolic links to or copies of manuals to cover all described
    functions.
  o Change DES API to clean up the namespace (some applications link also
    against libdes providing similar functions having the same name).
    Provide macros for backward compatibility (will be removed in the
    future).
  o Unify handling of cryptographic algorithms (software and engine)
    to be available via EVP routines for asymmetric and symmetric ciphers.
  o NCONF: new configuration handling routines.
  o Change API to use more 'const' modifiers to improve error checking
    and help optimizers.
  o Finally remove references to RSAref.
  o Reworked parts of the BIGNUM code.
  o Support for new engines: Broadcom ubsec, Accelerated Encryption
    Processing, IBM 4758.
  o A few new engines added in the demos area.
  o Extended and corrected OID (object identifier) table.
  o PRNG: query at more locations for a random device, automatic query for
    EGD style random sources at several locations.
  o SSL/TLS: allow optional cipher choice according to server's preference.
  o SSL/TLS: allow server to explicitly set new session ids.
  o SSL/TLS: support Kerberos cipher suites (RFC2712).
    Only supports MIT Kerberos for now.
  o SSL/TLS: allow more precise control of renegotiations and sessions.
  o SSL/TLS: add callback to retrieve SSL/TLS messages.
  o SSL/TLS: support AES cipher suites (RFC3268).
- adapt the ibmca patch
- remove openssl-nocrypt.diff, openssl's crypt() vanished
- configuration syntax has changed ($sys_id added before $lflags)
* Thu Feb 20 2003 poeml@suse.de
- update to bugfix release 0.9.6i:
  - security fix: In ssl3_get_record (ssl/s3_pkt.c), minimize
    information leaked via timing by performing a MAC computation
    even if incorrrect block cipher padding has been found.  This
    is a countermeasure against active attacks where the attacker
    has to distinguish between bad padding and a MAC verification
    error.  (CAN-2003-0078)
  - a few more small bugfixes (mainly missing assertions)
* Fri Dec  6 2002 poeml@suse.de
- update to 0.9.6h (last release in the 0.9.6 series)
  o New configuration targets for Tandem OSS and A/UX.
  o New OIDs for Microsoft attributes.
  o Better handling of SSL session caching.
  o Better comparison of distinguished names.
  o Better handling of shared libraries in a mixed GNU/non-GNU environment.
  o Support assembler code with Borland C.
  o Fixes for length problems.
  o Fixes for uninitialised variables.
  o Fixes for memory leaks, some unusual crashes and some race conditions.
  o Fixes for smaller building problems.
  o Updates of manuals, FAQ and other instructive documents.
- add a call to make depend
- fix sed expression (lib -> lib64) to replace multiple occurences
  on one line
* Mon Nov  4 2002 stepan@suse.de
- fix openssl for alpha ev56 cpus
* Thu Oct 24 2002 poeml@suse.de
- own the /usr/share/ssl directory [#20849]
- openssl-hppa-config.diff can be applied on all architectures
* Mon Sep 30 2002 bg@suse.de
- enable hppa distribution; use only pa1.1 architecture.
* Tue Sep 17 2002 froh@suse.de
- update ibm-hardware-crypto-patch to ibmca.patch-0.96e-2 (#18953)
* Mon Aug 12 2002 poeml@suse.de
- update to 0.9.6g and drop the now included ASN1 check patch.
  Other change:
  - Use proper error handling instead of 'assertions' in buffer
    overflow checks added in 0.9.6e.  This prevents DoS (the
    assertions could call abort()).
* Fri Aug  9 2002 kukuk@suse.de
- Fix requires of openssl-devel subpackage
* Tue Aug  6 2002 draht@suse.de
- Correction for changes in the ASN1 code, assembled in
  openssl-0.9.6e-cvs-20020802-asn1_lib.diff
* Wed Jul 31 2002 poeml@suse.de
- update to 0.9.6e. Major changes:
  o Various security fixes (sanity checks to asn1_get_length(),
    various remote buffer overflows)
  o new option SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS, disabling the
    countermeasure against a vulnerability in the CBC ciphersuites
    in SSL 3.0/TLS 1.0 that was added in 0.9.6d which turned out to
    be incompatible with buggy SSL implementations
- update ibmca crypto hardware patch (security issues fixed)
- gcc 3.1 version detection is fixed, we can drop the patch
- move the most used man pages from the -doc to the main package
  [#9913] and resolve man page conflicts by putting them into ssl
  sections [#17239]
- spec file: use PreReq for %%post script
* Fri Jul 12 2002 poeml@suse.de
- update to 0.9.6d. Major changes:
  o Various SSL/TLS library bugfixes.
  o Fix DH parameter generation for 'non-standard' generators.
  Complete Changelog: http://www.openssl.org/news/changelog.html
- supposed to fix a session caching failure occuring with postfix
- simplify local configuration for the architectures
- there's a new config variable: $shared_ldflag
- use RPM_OPT_FLAGS in favor of predifined cflags by appending them
  at the end
- validate config data (config --check-sanity)
- resolve file conflict of /usr/share/man/man1/openssl.1.gz [#15982]
- move configuration to /etc/ssl [#14387]
- mark openssl.cnf %%config (noreplace)
* Sat Jul  6 2002 schwab@suse.de
- Include <crypt.h> to get crypt prototype.
* Fri Jul  5 2002 kukuk@suse.de
- Remove crypt prototype from des.h header file, too.
* Mon Jun 10 2002 meissner@suse.de
- enhanced ppc64 support (needs seperate config), reenabled make check
* Fri May 31 2002 olh@suse.de
- add ppc64 support, temporary disable make check
* Thu Apr 18 2002 meissner@suse.de
- fixed x86_64 build, added bc to needed_for_build (used by tests)
* Wed Apr 17 2002 ro@suse.de
- fixed gcc version determination
- drop sun4c support/always use sparcv8
- ignore return code from showciphers
* Fri Mar 15 2002 poeml@suse.de
- add settings for sparc to build shared objects. Note that all
  sparcs (sun4[mdu]) are recognized as linux-sparcv7
* Wed Feb  6 2002 kukuk@suse.de
- Remove crypt function from libcrypto.so.0 [Bug #13056]
* Sun Feb  3 2002 poeml@suse.de
- add settings for mips to build shared objects
- print out all settings to the build log
* Tue Jan 29 2002 poeml@suse.de
- update to 0.9.6c:
  o bug fixes
  o support for hardware crypto devices (Cryptographic Appliances,
  Broadcom, and Accelerated Encryption Processing)
- add IBMCA patch for IBM eServer Cryptographic Accelerator Device
  Driver (#12565) (forward ported from 0.9.6b)
  (http://www-124.ibm.com/developerworks/projects/libica/)
- tell Configure how to build shared libs for s390 and s390x
- tweak Makefile.org to use %%_libdir
- clean up spec file
- add README.SuSE as source file instead of in a patch
* Wed Dec  5 2001 uli@suse.de
- disabled "make test" for ARM (destest segfaults, the other tests
  seem to succeed)
* Wed Dec  5 2001 ro@suse.de
- removed subpackage src
* Wed Nov 28 2001 uli@suse.de
- needs -ldl on ARM, too
* Mon Nov 19 2001 mls@suse.de
- made mips big endian, fixed shared library creation for mips
* Fri Aug 31 2001 rolf@suse.de
- added root certificates [BUG#9913]
- move from /usr/ssh to /usr/share/ssl
* Wed Jul 18 2001 rolf@suse.de
- update to 0.9.6b
- switch to engine version of openssl, which supports hardware
  encryption for a few popular devices
- check wether shared libraries have been generated
* Thu Jul  5 2001 rolf@suse.de
- appliy PRNG security patch
* Tue Jun 12 2001 bk@suse.de
- added support for s390x
* Mon May  7 2001 kukuk@suse.de
- Fix building of shared libraries on SPARC, too.
* Mon May  7 2001 rolf@suse.de
- Fix ppc and s390 shared library builds
- resolved conflict in manpage naming:
  rand.3 is now sslrand.3 [BUG#7643]
* Tue May  1 2001 schwab@suse.de
- Fix ia64 configuration.
- Fix link command.
* Thu Apr 26 2001 bjacke@suse.de
- updated to 0.96a
* Wed Apr 18 2001 kkaempf@suse.de
- provide .so files in -devel package only
* Tue Apr 17 2001 bjacke@suse.de
- resolve file name conflict (#6966)
* Wed Mar 21 2001 rolf@suse.de
- new subpackage openssl-src [BUG#6383]
- added README.SuSE which explains where to find the man pages [BUG#6717]
* Fri Dec 15 2000 sf@suse.de
- changed CFLAG to -O1 to make the tests run successfully
* Mon Dec 11 2000 rolf@suse.de
- build openssl with no-idea and no-rc5 to meet US & RSA regulations
- build with -fPIC on all platforms (especially IA64)
* Wed Nov 22 2000 rolf@suse.de
- rename openssls to openssl-devel and add shared libs and header files
- new subpackge openssl-doc for manpages and documentation
- use BuildRoot
* Fri Oct 27 2000 schwab@suse.de
- Add link-time links for libcrypto and libssl.
- Make sure that LD_LIBRARY_PATH is passed down to sub-makes.
* Mon Oct  2 2000 rolf@suse.de
- update to 0.9.6
* Mon Apr 10 2000 bk@suse.de
- fix support for s390-linux
* Mon Apr 10 2000 rolf@suse.de
- new version 0.9.5a
* Sun Apr  9 2000 bk@suse.de
- add support for s390-linux
* Mon Mar 27 2000 kukuk@suse.de
- Use sparcv7 for SPARC
* Wed Mar  1 2000 rolf@suse.de
- move manpages back, as too many conflict with system manuals
* Wed Mar  1 2000 rolf@suse.de
- move manpages to %%{_mandir}
- include static libraries
* Wed Mar  1 2000 bk@suse.de
- added subpackage source openssls, needed for ppp_ssl
* Tue Feb 29 2000 rolf@suse.de
- new version 0.9.5
* Thu Feb 24 2000 schwab@suse.de
- add support for ia64-linux
* Mon Jan 31 2000 kukuk@suse.de
- Create and add libcrypto.so.0 and libssl.so.0
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Wed Sep  1 1999 rolf@suse.de
- new version 0.9.4
* Wed May 26 1999 rolf@suse.de
- new version 0.9.3 with new layout
- alpha asm disabled by default now, no patch needed
* Thu May 20 1999 ro@suse.de
- disable asm for alpha: seems incomplete
* Mon May 17 1999 rolf@suse.de
- don't use -DNO_IDEA
* Wed May 12 1999 rolf@suse.de
- first version 0.9.2b
