#
# spec file for package iproute2
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

# ---------------------------------------------------------------------------
# Contents of this package is exported from git repository; please submit
# your changes via https://gitlab.suse.de/mkubecek/iproute2-source or
# gitlab@gitlab.suse.de:mkubecek/iproute2-source.git rather than to IBS.
# ---------------------------------------------------------------------------

%define _buildshell /bin/bash
Name:           iproute2
Version:        6.4
Release:        150600.7.9.1
Summary:        Linux network configuration utilities
License:        GPL-2.0-only
Group:          Productivity/Networking/Routing
URL:            https://wiki.linuxfoundation.org/networking/iproute2
# Using GPL-2.0 instead of GPL-2.0+ because of tc_skbedit.h and tc/q_multiq.c

#DL-URL:	https://kernel.org/pub/linux/utils/net/iproute2/
#Git-Clone: https://git.kernel.org/pub/scm/network/iproute2/iproute2.git/
#Git-Mirror:    https://github.com/shemminger/iproute2 ## not regularly updated
Source:         https://kernel.org/pub/linux/utils/net/iproute2/%name-%version.0.tar.xz
Source2:        https://kernel.org/pub/linux/utils/net/iproute2/%name-%version.0.tar.sign
Source3:        %name.tmpfiles
Source9:        %name.keyring
Source11:       patches.tar.xz
Source12:       series.conf
Source13:       guards
Source14:       apply-patches
BuildRequires:  bison
BuildRequires:  db-devel
BuildRequires:  fdupes
BuildRequires:  flex
BuildRequires:  libbpf-devel
BuildRequires:  libelf-devel
BuildRequires:  pkgconfig >= 0.21
BuildRequires:  xz
BuildRequires:  pkgconfig(libmnl)
BuildRequires:  pkgconfig(libselinux)
BuildRequires:  pkgconfig(xtables) >= 1.4.11
Provides:       %name-doc = %version
Provides:       iproute = %version-%release
Provides:       %name(xfrm6_raw) = %version-%release
Obsoletes:      %name-doc < 4.15.0

%description
iproute2 is a collection of user-space utilities to set up networking
under Linux from the command-line. It can inspect and configure,
among other things: interface paramters, IP addresses, routing,
tunnels, bridges, packet transformations (IPsec, etc.), and Quality
of Service.

%package -n libnetlink-devel
Summary:        A Higher Level Interface to the Netlink Service
License:        GPL-2.0-or-later
Group:          Development/Libraries/C and C++
Provides:       libnetlink = %version-%release

%description -n libnetlink-devel
libnetlink provides a higher-level interface to rtnetlink(7).
New programs should use libmnl-devel instead.

%package bash-completion
Summary:        Bash completion for iproute
License:        GPL-2.0-or-later
Group:          System/Shells
Requires:       %{name}
Requires:       bash-completion
Supplements:    (%{name} and bash-completion)

%description bash-completion
bash command line completion support for iproute.

%package arpd
Summary:        Userspace ARP daemon
License:        GPL-2.0-only
Group:          Productivity/Networking/Routing
Provides:       iproute2:/usr/sbin/arpd

%description arpd
The arpd daemon collects gratuitous ARP information, saving it on
local disk and feeding it to the kernel on demand to avoid redundant
broadcasting due to limited standard size (512..1024 entries,
depending on type) of the kernel ARP cache.

%prep
%setup -n %{name}-%{version}.0 -a 11
chmod a+rx %{SOURCE13} %{SOURCE14}
%{SOURCE13} <%{SOURCE12} | %{SOURCE14} && rm -rf patches

find . -name *.orig -delete

%build
%global _lto_cflags %_lto_cflags -ffat-lto-objects
# build with -fPIC. For details see
# https://bugzilla.novell.com/show_bug.cgi?id=388021
xt_libdir="$(pkg-config xtables --variable=xtlibdir)"
xt_cflags="$(pkg-config xtables --cflags)"
%if 0%{!?make_build:1}
%define make_build make %{?_smp_mflags}
%endif
%make_build CCOPTS="-D_GNU_SOURCE %optflags -Wstrict-prototypes -Wno-error -fPIC -DXT_LIB_DIR=\\\"$xt_libdir\\\" $xt_cflags"

%install
b="%buildroot"
mkdir -p "$b/usr/bin" "$b/usr/sbin" "$b/sbin"
%make_install MODDESTDIR="$b/%_libdir/tc"

# We have m_xt instead
rm -f "$b/%_libdir/tc/m_ipt.so"

install -pm0644 "lib/libnetlink.a" "$b/%_libdir/"
chmod -x "$b/%_libdir/libnetlink.a"
install -pm0644 "include/libnetlink.h" "$b/%_includedir/"
chmod -x "$b/%_includedir/libnetlink.h"
install -Dm0644 "%SOURCE3" "$b/%_tmpfilesdir/%name.conf"
%if 0%{?usrmerged} || (0%{?suse_version} >= 1550)
ln -sf "%_sbindir/ip" "$b/%_bindir/ip"
%else
ln -s "%_sbindir/ip" "$b/sbin/"
mkdir -p "$b/bin"
ln -sf "%_sbindir/ip" "$b/bin/ip"
%endif
for BIN in lnstat nstat routel ss; do
	ln -sf "%_sbindir/$BIN" "$b/%_bindir/$BIN"
done
mkdir -p "$b/%_docdir/%name"
cp -an README* examples/bpf "$b/%_docdir/%name/"

# bugzilla.opensuse.org/1205632
# You can't parse routel output anyway so it does not matter what we output
rm -v "$b/%_mandir/man8/routel.8"
cat >"$b/%_sbindir/routel" <<-EOF
	#!/bin/sh
	exec ip r l table all
EOF

%fdupes %buildroot/%_prefix

%post
%tmpfiles_create %_tmpfilesdir/%name.conf

%files
%_bindir/lnstat
%_bindir/nstat
%_bindir/routel
%_bindir/ss
%_sbindir/*
%_tmpfilesdir/%name.conf
%ghost %dir %_rundir/netns
%exclude %_sbindir/arpd
%if 0%{?usrmerged} || (0%{?suse_version} >= 1550)
%_bindir/ip
%else
/sbin/*
/bin/ip
%endif
%_mandir/man7/*
%_mandir/man8/*
%exclude %_mandir/man8/arpd.8*
%dir %_sysconfdir/iproute2
%config(noreplace) %_sysconfdir/iproute2/*
%_libdir/tc/
%_datadir/tc/
%_docdir/%name/
%license COPYING

%files -n libnetlink-devel
%_includedir/*
%_mandir/man3/libnetlink*
%_libdir/lib*

%files bash-completion
%_datadir/bash-completion/

%files arpd
%_sbindir/arpd
%_mandir/man8/arpd.8*

%changelog
* Thu Sep 11 2025 mkubecek@suse.cz
- add post-6.4 follow-up fixes (bsc#1243005)
  * patches/bond-fix-stack-smash-in-xstats.patch
  * patches/tc-gred-fix-debug-print.patch
* Thu Sep 11 2025 mkubecek@suse.cz
- sync UAPI header copies with SLE15-SP6 kernel
  * sync-UAPI-header-copies-with-SLE15-SP6.patch
- drop Update-kernel-headers.patch
  (no longer needed with full UAPI sync)
* Wed Aug 27 2025 sjaeckel@suse.de
- devlink: support ipsec_crypto and ipsec_packet cap (bsc#1248660)
  * add Update-kernel-headers.patch
  * add devlink-Support-setting-port-function-ipsec_crypto-c.patch
  * add devlink-Support-setting-port-function-ipsec_packet-c.patch
  * refresh ss-Tone-down-cgroup-path-resolution.patch
* Sat May 10 2025 mkubecek@suse.cz
- add post-6.4 follow-up fix (bsc#1243005)
  * ss-show-extra-info-when-processes-is-not-used.patch
* Fri May  9 2025 mkubecek@suse.cz
- add post-6.4 follow-up fixes (bsc#1243005):
  * bpf-fix-warning-from-basename.patch
  * bridge-fdb-add-an-error-print-for-unknown-command.patch
  * bridge-vni-Accept-del-command.patch
  * bridge-vni-Fix-duplicate-group-and-remote-error-mess.patch
  * bridge-vni-Fix-vni-filter-help-strings.patch
  * bridge-vni-Remove-dead-code-in-group-argument-parsin.patch
  * bridge-vni-Report-duplicate-vni-argument-using-dupar.patch
  * f_flower-Treat-port-0-as-valid.patch
  * genl-ctrl.c-spelling-fix-in-error-message.patch
  * ip-Add-missing-echo-option-to-usage.patch
  * ip-Add-missing-stats-command-to-usage.patch
  * ip-ipmroute-use-preferred_family-to-get-prefix.patch
  * ip-remove-non-existent-amt-subcommand-from-usage.patch
  * iplink-fix-fd-leak-when-playing-with-netns.patch
  * iplink_bridge-fix-incorrect-root-id-dump.patch
  * iplink_xstats-spelling-fix-in-error-message.patch
  * iproute2-fix-type-incompatibility-in-ifstat.c.patch
  * iproute2-prevent-memory-leak.patch
  * libnetlink-validate-nlmsg-header-length-first.patch
  * man-devlink-resource-add-missing-words-in-the-exampl.patch
  * mnl_utils-sanitize-incoming-netlink-payload-size-in-.patch
  * rdma-Fix-help-information-of-rdma-resource.patch
  * rdma-Fix-the-error-of-accessing-string-variable-outs.patch
  * rdma-use-print_XXX-instead-of-COLOR_NONE.patch
  * ss-Fix-socket-type-check-in-packet_show_line.patch
  * ss-fix-directory-leak-when-T-option-is-used.patch
  * ss-mptcp-display-info-counters-as-unsigned.patch
  * ss-prevent-Process-column-from-being-printed-unless-.patch
  * tc-taprio-don-t-print-netlink-attributes-which-weren.patch
  * tc-taprio-fix-JSON-output-when-TCA_TAPRIO_ATTR_ADMIN.patch
  * tc-taprio-fix-parsing-of-fp-option-when-it-doesn-t-a.patch
  * vdpa-consume-device_features-parameter.patch
- add to blacklist:
  * af0ea2cd0b9e (duplicate of 92eac7e4bf14)
- refresh:
  * ss-Add-support-for-dumping-TCP-bound-inactive-socket.patch
  * add-explicit-typecast-to-avoid-gcc-warning.patch
  * use-sysconf-_SC_CLK_TCK-if-HZ-undefined.patch
* Wed Mar 19 2025 mkubecek@suse.cz
- avoid spurious cgroup warning (bsc#1234383):
  - ss-Tone-down-cgroup-path-resolution.patch
* Tue Apr 23 2024 mkubecek@suse.cz
- support display of bound but unconnected sockets (bsc#1204562)
  * ss-Add-support-for-dumping-TCP-bound-inactive-socket.patch
* Tue Apr 23 2024 mkubecek@suse.cz
- iproute2.spec: ensure execute permissions of supplied scripts
  (fixes IBS build failure)
* Wed Jan 17 2024 mkubecek@suse.cz
- upgrade to upstream version 6.4 (jsc#PED-6820 jsc#PED-6844)
  * for detailed list of changes between 5.14 and 6.4, see Factory
    package changelog
  * replace upstream tarball and signature
  * update specfile with changes from Factory package
  * drop mainline backports contained in 6.4:
  - tree-wide-fix-some-typos-found-by-Lintian.patch
  - configure-restore-backward-compatibility.patch
  - man-ip-link-remove-double-of.patch
  - iptuntap-fix-multi-queue-flag-display.patch
  - tc-f_flower-fix-port-range-parsing.patch
  - lib-bpf_legacy-fix-bpffs-mount-when-sys-fs-bpf-exist.patch
  - mptcp-unbreak-JSON-endpoint-list.patch
  * drop non-upstream patch obsoleted by rebase to 6.4:
  - xfrm-support-displaying-transformations-used-for-Mob.patch
  * refresh remaining patches:
  - adjust-installation-directories-for-openSUSE-SLE.patch
  - use-sysconf-_SC_CLK_TCK-if-HZ-undefined.patch
  - add-explicit-typecast-to-avoid-gcc-warning.patch
  - split-link-and-compile-steps-for-binaries.patch
* Tue Oct  5 2021 mkubecek@suse.cz
- follow-up fixes backported from upstream (bsc#1191316):
  tree-wide-fix-some-typos-found-by-Lintian.patch
  configure-restore-backward-compatibility.patch
  man-ip-link-remove-double-of.patch
  mptcp-unbreak-JSON-endpoint-list.patch
* Tue Oct  5 2021 mkubecek@suse.cz
- upgrade to upstream version 5.14 (jsc#SLE-17360 jsc#SLE-18994
  jsc#SLE-19271)
  * replace upstream tarball and signature
  * update specfile with changes from Factory package
  * drop mainline backports contained in 5.14:
  - Revert-bpf-replace-snprintf-with-asprintf-when-deali.patch
  - bpf-Fixes-a-snprintf-truncation-warning.patch
  - bpf-replace-snprintf-with-asprintf-when-dealing-with.patch
  - bridge-Deduplicate-vlan-show-functions.patch
  - bridge-Fix-BRIDGE_VLAN_TUNNEL-attribute-sizes.patch
  - bridge-Fix-output-with-empty-vlan-lists.patch
  - bridge-Fix-src_vni-argument-in-man-page.patch
  - bridge-Fix-tunnelshow-json-output.patch
  - bridge-Fix-typo-in-error-messages.patch
  - bridge-Fix-typo.patch
  - bridge-Fix-vni-printing.patch
  - bridge-fdb-show-fix-fdb-entry-state-output-for-json-.patch
  - bridge-fix-string-length-warning.patch
  - devlink-Add-a-new-time-stamp-format-for-health-repor.patch
  - devlink-Add-helper-for-left-justification-print.patch
  - devlink-Fix-fmsg-nesting-in-non-JSON-output.patch
  - devlink-Fix-inconsistency-between-command-input-and-.patch
  - devlink-Left-justification-on-FMSG-output.patch
  - devlink-Print-health-reporter-s-dump-time-stamp-in-a.patch
  - devlink-allow-full-range-of-resource-sizes.patch
  - devlink-always-check-strslashrsplit-return-value.patch
  - devlink-fix-uninitialized-warning.patch
  - devlink-require-resource-parameters.patch
  - erspan-fix-JSON-output.patch
  - erspan-set-erspan_ver-to-1-by-default.patch
  - f_u32-fix-compiler-gcc-10-compiler-warning.patch
  - introduce-print_masked_u16-and-print_masked_u32.patch
  - ip-add-support-for-alternative-name-addition-deletio.patch
  - ip-allow-to-use-alternative-names-as-handle.patch
  - ip-drop-2-char-command-assumption.patch
  - ip-fix-ip-route-show-json-output-for-multipath-nexth.patch
  - ip-fix-link-type-and-vlan-oneline-output.patch
  - ip-fix-oneline-output.patch
  - ip-iplink_ipoib.c-Remove-extra-spaces.patch
  - ip-link-Fix-indenting-in-help-text.patch
  - ip-link-xstats-fix-TX-IGMP-reports-string.patch
  - ip-link_gre-Do-not-send-ERSPAN-attributes-to-GRE-tun.patch
  - ip-route-ignore-ENOENT-during-save-if-RT_TABLE_MAIN-.patch
  - ip-xfrm-Fix-help-messages.patch
  - ip-xfrm-if_id-ve-value-is-error.patch
  - ip-xfrm-limit-the-length-of-the-security-context-nam.patch
  - ip-xfrm-update-man-page-on-setting-printing-XFRMA_IF.patch
  - ipmonitor-Fix-recvmsg-with-ancillary-data.patch
  - json_print-Remove-declaration-without-implementation.patch
  - lib-bpf-Fix-and-simplify-bpf_mnt_check_target.patch
  - lib-bpf_legacy-avoid-to-pass-invalid-argument-to-clo.patch
  - lib-bpf_legacy-fix-missing-socket-close-when-connect.patch
  - lib-bpf_legacy-treat-0-as-a-valid-file-descriptor.patch
  - lib-fs-avoid-double-call-to-mkdir-on-make_path.patch
  - lib-ll_map-cache-alternative-names.patch
  - lib-namespace-fix-ip-all-netns-return-code.patch
  - libnetlink-check-error-handler-is-present-before-a-c.patch
  - man-bridge-fix-the-typo-to-change-c-lor-into-c-olor-.patch
  - man-fix-syntax-for-ip-link-property.patch
  - nexthop-fix-error-reporting-in-filter-dump.patch
  - nexthop-fix-memory-leak-in-add_nh_group_attr.patch
  - q_cake-Fix-incorrect-printing-of-signed-values-in-cl.patch
  - rdma-Fix-statistics-bind-unbing-argument-handling.patch
  - rdma-stat-fix-return-code.patch
  - rdma-stat-initialize-ret-in-stat_qp_show_parse_cb.patch
  - ss-fix-end-of-line-printing-in-misc-ss.c.patch
  - ss-fix-fallback-to-procfs-for-raw-sockets.patch
  - tc-action-fix-time-values-output-in-JSON-format.patch
  - tc-fix-segmentation-fault-on-gact-action.patch
  - tc-fix-warning-in-tc-q_pie.c.patch
  - tc-flower-fix-output-for-ip-tos-and-ttl.patch
  - tc-fq_codel-fix-class-stat-deficit-is-signed-int.patch
  - tc-fq_codel-fix-missing-statistic-in-JSON-output.patch
  - tc-pie-add-dq_rate_estimator-option.patch
  - tc-u32-Fix-key-folding-in-sample-option.patch
  - tc_util-add-an-option-to-print-masked-numbers-with-w.patch
  - tc_util-add-functions-for-big-endian-masked-numbers.patch
  - tc_util-introduce-a-function-to-print-JSON-non-JSON-.patch
  - testsuite-Fix-line-count-test.patch
  - tipc-fixed-a-compile-warning-in-tipc-link.c.patch
  - xfrm-also-check-for-ipv6-state-in-xfrm_state_keep.patch
  - xfrm-not-try-to-delete-ipcomp-states-when-using-dele.patch
  * drop non-upstream patches obsoleted by rebase to 5.14:
  - sync-UAPI-header-copies-with-SLE15-SP2.patch
  - examples-fix-bashisms-in-example-script.patch
  * refresh remaining patches:
  - lib-bpf_legacy-fix-bpffs-mount-when-sys-fs-bpf-exist.patch
  - split-link-and-compile-steps-for-binaries.patch
  - tc-f_flower-fix-port-range-parsing.patch
  - xfrm-support-displaying-transformations-used-for-Mob.patch
* Mon Oct  4 2021 mkubecek@suse.cz
- follow-up fixes backported from upstream (bsc#1160242):
  ss-fix-end-of-line-printing-in-misc-ss.c.patch
  xfrm-also-check-for-ipv6-state-in-xfrm_state_keep.patch
  bridge-Fix-typo.patch
  bridge-Fix-output-with-empty-vlan-lists.patch
  tc-action-fix-time-values-output-in-JSON-format.patch
  Revert-bpf-replace-snprintf-with-asprintf-when-deali.patch
  bpf-Fixes-a-snprintf-truncation-warning.patch
  tipc-fixed-a-compile-warning-in-tipc-link.c.patch
  ip-xfrm-update-man-page-on-setting-printing-XFRMA_IF.patch
  bridge-fdb-show-fix-fdb-entry-state-output-for-json-.patch
  ip-link-Fix-indenting-in-help-text.patch
  ip-iplink_ipoib.c-Remove-extra-spaces.patch
  devlink-fix-uninitialized-warning.patch
  bridge-fix-string-length-warning.patch
  f_u32-fix-compiler-gcc-10-compiler-warning.patch
  rdma-Fix-statistics-bind-unbing-argument-handling.patch
  lib-namespace-fix-ip-all-netns-return-code.patch
  lib-bpf-Fix-and-simplify-bpf_mnt_check_target.patch
  lib-fs-avoid-double-call-to-mkdir-on-make_path.patch
  q_cake-Fix-incorrect-printing-of-signed-values-in-cl.patch
  ip-xfrm-limit-the-length-of-the-security-context-nam.patch
  erspan-fix-JSON-output.patch
  devlink-always-check-strslashrsplit-return-value.patch
  nexthop-fix-memory-leak-in-add_nh_group_attr.patch
  rdma-stat-initialize-ret-in-stat_qp_show_parse_cb.patch
  rdma-stat-fix-return-code.patch
  lib-bpf_legacy-treat-0-as-a-valid-file-descriptor.patch
  lib-bpf_legacy-fix-missing-socket-close-when-connect.patch
  ip-drop-2-char-command-assumption.patch
  man-fix-syntax-for-ip-link-property.patch
  lib-bpf_legacy-avoid-to-pass-invalid-argument-to-clo.patch
  ip-route-ignore-ENOENT-during-save-if-RT_TABLE_MAIN-.patch
  libnetlink-check-error-handler-is-present-before-a-c.patch
  ipmonitor-Fix-recvmsg-with-ancillary-data.patch
  tc-u32-Fix-key-folding-in-sample-option.patch
  man-bridge-fix-the-typo-to-change-c-lor-into-c-olor-.patch
  ss-fix-fallback-to-procfs-for-raw-sockets.patch
  iptuntap-fix-multi-queue-flag-display.patch
  tc-f_flower-fix-port-range-parsing.patch
  lib-bpf_legacy-fix-bpffs-mount-when-sys-fs-bpf-exist.patch
- refresh:
  ip-link_gre-Do-not-send-ERSPAN-attributes-to-GRE-tun.patch
  tc-fq_codel-fix-class-stat-deficit-is-signed-int.patch
* Fri Oct  1 2021 mkubecek@suse.cz
- follow-up fixes backported from upstream (bsc#1160242):
  ip-link_gre-Do-not-send-ERSPAN-attributes-to-GRE-tun.patch
  tc-fq_codel-fix-class-stat-deficit-is-signed-int.patch
* Fri Apr 24 2020 mkubecek@suse.cz
- follow-up fixes backported from upstream (bsc#1160242):
  ip-fix-link-type-and-vlan-oneline-output.patch
  ip-xfrm-Fix-help-messages.patch
  ip-link-xstats-fix-TX-IGMP-reports-string.patch
  erspan-set-erspan_ver-to-1-by-default.patch
  xfrm-not-try-to-delete-ipcomp-states-when-using-dele.patch
  nexthop-fix-error-reporting-in-filter-dump.patch
- refresh:
  xfrm-support-displaying-transformations-used-for-Mob.patch
- fix duplicated patch metadata:
  introduce-print_masked_u16-and-print_masked_u32.patch
* Wed Apr  8 2020 kukuk@suse.com
- Move arpd into own subpackage to avoid libdb dependency
  [jsc#SLE-12189]
* Wed Jan  8 2020 mkubecek@suse.cz
- support alternative names as we already support them in SLE15-SP2
  kernel (jsc#SLE-7290):
  lib-ll_map-cache-alternative-names.patch
  ip-add-support-for-alternative-name-addition-deletio.patch
  ip-allow-to-use-alternative-names-as-handle.patch
  ip-fix-oneline-output.patch
* Wed Jan  8 2020 mkubecek@suse.cz
- follow-up fixes backported from upstream (bsc#1160242):
  bpf-replace-snprintf-with-asprintf-when-dealing-with.patch
  bridge-Deduplicate-vlan-show-functions.patch
  bridge-Fix-BRIDGE_VLAN_TUNNEL-attribute-sizes.patch
  bridge-Fix-src_vni-argument-in-man-page.patch
  bridge-Fix-tunnelshow-json-output.patch
  bridge-Fix-typo-in-error-messages.patch
  bridge-Fix-vni-printing.patch
  devlink-Add-a-new-time-stamp-format-for-health-repor.patch
  devlink-Add-helper-for-left-justification-print.patch
  devlink-Fix-fmsg-nesting-in-non-JSON-output.patch
  devlink-Fix-inconsistency-between-command-input-and-.patch
  devlink-Left-justification-on-FMSG-output.patch
  devlink-Print-health-reporter-s-dump-time-stamp-in-a.patch
  devlink-allow-full-range-of-resource-sizes.patch
  devlink-require-resource-parameters.patch
  introduce-print_masked_u16-and-print_masked_u32.patch
  ip-fix-ip-route-show-json-output-for-multipath-nexth.patch
  ip-xfrm-if_id-ve-value-is-error.patch
  json_print-Remove-declaration-without-implementation.patch
  sync-UAPI-header-copies-with-SLE15-SP2.patch
  tc-fix-segmentation-fault-on-gact-action.patch
  tc-fix-warning-in-tc-q_pie.c.patch
  tc-flower-fix-output-for-ip-tos-and-ttl.patch
  tc-fq_codel-fix-missing-statistic-in-JSON-output.patch
  tc-pie-add-dq_rate_estimator-option.patch
  tc_util-add-an-option-to-print-masked-numbers-with-w.patch
  tc_util-add-functions-for-big-endian-masked-numbers.patch
  tc_util-introduce-a-function-to-print-JSON-non-JSON-.patch
  testsuite-Fix-line-count-test.patch
* Thu Sep 26 2019 mkubecek@suse.cz
- upgrade to upstream version 5.3 (jsc#SLE-7290)
  * replace upstream tarball and signature
  * import specfile updates from Factory package
  * drop mainline backports contained in 5.3:
  - bpf-remove-obsolete-samples.patch
  - utils-return-default-family-when-rtm_family-is-not-R.patch
  - Really-fix-get_addr-and-get_prefix-error-messages.patch
  - iproute-Add-support-for-extended-ack-to-rtnl_talk.patch
  - ss-enclose-IPv6-address-in-brackets.patch
  - lib-fix-extended-ack-with-and-without-libmnl.patch
  - lib-need-to-pass-LIBMNL-flag.patch
  - tc-ip-more-Makefile-updates-for-LIBMNL.patch
  - change-how-Config-is-used-in-Makefile-s.patch
  - lib-Dump-ext-ack-string-by-default.patch
  - bpf-unbreak-libelf-linkage-for-bpf-obj-loader.patch
  - libnetlink-Fix-extack-attribute-parsing.patch
  - ifstat-Fix-memleak-in-dump_kern_db-for-json-output.patch
  - ss-Fix-potential-memleak-in-unix_stats_print.patch
  - utils-Move-BIT-macro-to-common-header.patch
  - rdma-Add-basic-infrastructure-for-RDMA-tool.patch
  - rdma-Add-dev-object.patch
  - rdma-Add-link-object.patch
  - rdma-Add-json-and-pretty-outputs.patch
  - rdma-Implement-json-output-for-dev-object.patch
  - rdma-Add-json-output-to-link-object.patch
  - rdma-Add-initial-manual-for-the-tool.patch
  - iproute-Fix-for-missing-Oifs-display.patch
  - ipmaddr-Avoid-accessing-uninitialized-data.patch
  - rdma-fix-duplicate-initialization-in-port_names.patch
  - ss-Fix-for-added-diag-support-check.patch
  - link_gre6-Fix-for-changing-tclass-flowlabel.patch
  - iplink-check-for-message-truncation-in-iplink_get.patch
  - iplink-double-the-buffer-size-also-in-iplink_get.patch
  - tc-actions-store-and-dump-correct-length-of-user-coo.patch
  - json_writer-add-new-json-handlers-null-float-with-fo.patch
  - doc-remove-obsolete-ip-tunnels-documentation.patch
  - doc-remove-outdated-ss-documentation.patch
  - doc-remove-outdated-arpd-documentation.patch
  - doc-remove-outdated-nstat-rtstat-documentation.patch
  - doc-remove-outdated-tc-filters-documentation.patch
  - doc-remove-outdated-IPv6-flow-label-document.patch
  - doc-drop-old-ip-command-documentation.patch
  - ss-Distinguish-between-IPv4-and-IPv6-wildcard-socket.patch
  - ip-maddr-fix-filtering-by-device.patch
  - man-add-additional-explainations-for-ss.patch
  - lib-libnetlink-re-malloc-buff-if-size-is-not-enough.patch
  - lib-libnetlink-update-rtnl_talk-to-support-malloc-bu.patch
  - tc-move-action-cookie-print-out-of-the-stats-if.patch
  - tc-remove-action-cookie-len-from-printout.patch
  - link_gre6-Detect-invalid-encaplimit-values.patch
  - man-tc-csum.8-Fix-inconsistency-in-example-descripti.patch
  - tc-bash-completion-add-missing-classid-keyword.patch
  - tc-fix-command-tc-actions-del-hang-issue.patch
  - gre-ip6tnl-tunnel-Fix-noencap-support.patch
  - Restore-no-print-directory-option-for-silent-builds.patch
  - iplink-Validate-minimum-tx-rate-is-less-than-maximum.patch
  - ipaddress-Make-sure-VF-min-max-rate-API-is-supported.patch
  - rdma-Reduce-scope-of-_dev_map_lookup-call.patch
  - rdma-Protect-dev_map_lookup-from-wrong-input.patch
  - rdma-Move-per-device-handler-function-to-generic-cod.patch
  - rdma-Fix-misspelled-SYS_IMAGE_GUID.patch
  - rdma-Check-that-port-index-exists-before-operate-on-.patch
  - rdma-Rename-free-function-to-be-rd_cleanup.patch
  - rdma-Rename-rd_free_devmap-to-be-rd_free.patch
  - rdma-Move-link-execution-logic-to-common-code.patch
  - rdma-Add-option-to-provide-sign-for-the-port-number.patch
  - rdma-Make-visible-the-number-of-arguments.patch
  - rdma-Add-filtering-infrastructure.patch
  - rdma-Set-pointer-to-device-name-position.patch
  - rdma-Add-resource-tracking-summary.patch
  - rdma-Add-QP-resource-tracking-information.patch
  - rdma-Check-return-value-of-strdup-call.patch
  - README-update-location-of-git-repositories-remove-br.patch
  - Remove-leftovers-from-removed-Latex-documentation.patch
  - README-re-add-updated-information-link.patch
  - rdma-Avoid-memory-leak-for-skipper-resource.patch
  - ip-link-Fix-use-after-free-in-nl_get_ll_addr_len.patch
  - ip-address-Fix-negative-prints-of-large-TX-rate-limi.patch
  - devlink-fix-port-new-monitoring-message-typo.patch
  - rdma-Add-CM_ID-resource-tracking-information.patch
  - rdma-Add-CQ-resource-tracking-information.patch
  - rdma-Add-MR-resource-tracking-information.patch
  - rdma-Add-PD-resource-tracking-information.patch
  - rdma-Ignore-unknown-netlink-attributes.patch
  - bridge-fix-typo-in-hairpin-error-message.patch
  - iproute-Abort-if-nexthop-cannot-be-parsed.patch
  - iplink_vrf-Save-device-index-from-response-for-retur.patch
  - rdma-Print-net-device-name-and-index-for-RDMA-device.patch
  - rdma-print-driver-resource-attributes.patch
  - rdma-sync-some-IP-headers-with-glibc.patch
  - devlink-CTRL_ATTR_FAMILY_ID-is-a-u16.patch
  - ip-Add-violation-counters-to-VF-statisctics.patch
  - ip-route-Fix-segfault-with-many-nexthops.patch
  - rdma-Fix-representation-of-PortInfo-CapabilityMask.patch
  - macsec-fix-off-by-one-when-parsing-attributes.patch
  - rdma-Fix-for-ineffective-check-in-add_filter.patch
  - ip-route-Fix-for-memleak-in-error-path.patch
  - rdma-Don-t-pass-garbage-to-rd_check_is_filtered.patch
  - ip-route-Fix-parse_encap_seg6-srh-parsing.patch
  - rdma-Refresh-help-section-of-resource-information.patch
  - tc-f_u32-allow-skip_hw-and-skip_sw-flags-to-be-last.patch
  - ip-route-Fix-nexthop-encap-parsing.patch
  - rdma-Fix-broken-32-bit-compilation.patch
  - rdma-Fix-incorrectly-handled-NLA-validation.patch
  - rdma-Introduce-command-execution-helper-with-require.patch
  - rdma-Add-an-option-to-rename-IB-device-interface.patch
  - rdma-Add-print-of-link-CapabilityMask2-flags.patch
  * drop non-upstream patches obsoleted by rebase to 5.3:
  - sync-UAPI-header-copies-with-SLE15-SP1.patch
  - man-fix-documentation-references-in-manual-pages.patch
  * refresh remaining patches:
  - adjust-installation-directories-for-openSUSE-SLE.patch
  - use-sysconf-_SC_CLK_TCK-if-HZ-undefined.patch
  - add-explicit-typecast-to-avoid-gcc-warning.patch
  - xfrm-support-displaying-transformations-used-for-Mob.patch
  - split-link-and-compile-steps-for-binaries.patch
  - examples-fix-bashisms-in-example-script.patch
* Thu Jan 17 2019 mkubecek@suse.cz
- VF stats backport for SLE15-SP1 (fate#326021 bsc#1104003):
  ip-Add-violation-counters-to-VF-statisctics.patch
* Thu Jan 17 2019 mkubecek@suse.cz
- RDMA backport for SLE15-SP1 (fate#326021 bsc#1104003):
  sync-UAPI-header-copies-with-SLE15-SP1.patch
  bpf-remove-obsolete-samples.patch
  json_writer-add-new-json-handlers-null-float-with-fo.patch
  rdma-Move-per-device-handler-function-to-generic-cod.patch
  rdma-Rename-free-function-to-be-rd_cleanup.patch
  rdma-Rename-rd_free_devmap-to-be-rd_free.patch
  rdma-Move-link-execution-logic-to-common-code.patch
  rdma-Add-option-to-provide-sign-for-the-port-number.patch
  rdma-Make-visible-the-number-of-arguments.patch
  rdma-Set-pointer-to-device-name-position.patch
  rdma-Add-filtering-infrastructure.patch
  rdma-Add-resource-tracking-summary.patch
  rdma-Add-QP-resource-tracking-information.patch
  rdma-Avoid-memory-leak-for-skipper-resource.patch
  rdma-Add-CM_ID-resource-tracking-information.patch
  rdma-Add-CQ-resource-tracking-information.patch
  rdma-Add-MR-resource-tracking-information.patch
  rdma-Add-PD-resource-tracking-information.patch
  rdma-Print-net-device-name-and-index-for-RDMA-device.patch
  rdma-print-driver-resource-attributes.patch
  rdma-sync-some-IP-headers-with-glibc.patch
  rdma-Fix-for-ineffective-check-in-add_filter.patch
  rdma-Don-t-pass-garbage-to-rd_check_is_filtered.patch
  rdma-Refresh-help-section-of-resource-information.patch
  rdma-Introduce-command-execution-helper-with-require.patch
  rdma-Add-an-option-to-rename-IB-device-interface.patch
  rdma-Add-print-of-link-CapabilityMask2-flags.patch
* Thu Jan 17 2019 mkubecek@suse.cz
- add more follow-up fixes up to upstream 4.20 (bsc#1085669)
  bridge-fix-typo-in-hairpin-error-message.patch
  iproute-Abort-if-nexthop-cannot-be-parsed.patch
  iplink_vrf-Save-device-index-from-response-for-retur.patch
  devlink-CTRL_ATTR_FAMILY_ID-is-a-u16.patch
  ip-route-Fix-segfault-with-many-nexthops.patch
  rdma-Fix-representation-of-PortInfo-CapabilityMask.patch
  macsec-fix-off-by-one-when-parsing-attributes.patch
  ip-route-Fix-for-memleak-in-error-path.patch
  ip-route-Fix-parse_encap_seg6-srh-parsing.patch
  tc-f_u32-allow-skip_hw-and-skip_sw-flags-to-be-last.patch
  ip-route-Fix-nexthop-encap-parsing.patch
  rdma-Fix-broken-32-bit-compilation.patch
  rdma-Fix-incorrectly-handled-NLA-validation.patch
* Wed Jan 16 2019 mkubecek@suse.cz
- refresh all patches
* Mon Jan 14 2019 mkubecek@suse.cz
- spec file cleanup
* Mon Jan 14 2019 mkubecek@suse.cz
- fix misplaced patch tags:
  patches/lib-libnetlink-update-rtnl_talk-to-support-malloc-bu.patch
  patches/rdma-Ignore-unknown-netlink-attributes.patch
  patches/tc-fix-command-tc-actions-del-hang-issue.patch
* Mon Jan 14 2019 mkubecek@suse.cz
- normalize patches: remove git specific artefacts to reduce noise
  on future refreshes and updates
* Fri Apr  6 2018 mkubecek@suse.cz
- list of patches packed into patches.tar.xz on its creation (this
  is a fake changelog entry added to silence factory-auto bot):
  adjust-installation-directories-for-openSUSE-SLE.patch
  use-sysconf-_SC_CLK_TCK-if-HZ-undefined.patch
  add-explicit-typecast-to-avoid-gcc-warning.patch
  xfrm-support-displaying-transformations-used-for-Mob.patch
  man-fix-documentation-references-in-manual-pages.patch
  split-link-and-compile-steps-for-binaries.patch
  examples-fix-bashisms-in-example-script.patch
  utils-Move-BIT-macro-to-common-header.patch
  rdma-Add-basic-infrastructure-for-RDMA-tool.patch
  rdma-Add-dev-object.patch
  rdma-Add-link-object.patch
  rdma-Add-json-and-pretty-outputs.patch
  rdma-Implement-json-output-for-dev-object.patch
  rdma-Add-json-output-to-link-object.patch
  rdma-Add-initial-manual-for-the-tool.patch
  rdma-fix-duplicate-initialization-in-port_names.patch
  iplink-check-for-message-truncation-in-iplink_get.patch
  iplink-double-the-buffer-size-also-in-iplink_get.patch
  utils-return-default-family-when-rtm_family-is-not-R.patch
  Really-fix-get_addr-and-get_prefix-error-messages.patch
  iproute-Add-support-for-extended-ack-to-rtnl_talk.patch
  ss-enclose-IPv6-address-in-brackets.patch
  lib-fix-extended-ack-with-and-without-libmnl.patch
  lib-need-to-pass-LIBMNL-flag.patch
  change-how-Config-is-used-in-Makefile-s.patch
  tc-ip-more-Makefile-updates-for-LIBMNL.patch
  lib-Dump-ext-ack-string-by-default.patch
  bpf-unbreak-libelf-linkage-for-bpf-obj-loader.patch
  libnetlink-Fix-extack-attribute-parsing.patch
  ifstat-Fix-memleak-in-dump_kern_db-for-json-output.patch
  ss-Fix-potential-memleak-in-unix_stats_print.patch
  iproute-Fix-for-missing-Oifs-display.patch
  ipmaddr-Avoid-accessing-uninitialized-data.patch
  ss-Fix-for-added-diag-support-check.patch
  link_gre6-Fix-for-changing-tclass-flowlabel.patch
  tc-actions-store-and-dump-correct-length-of-user-coo.patch
  ss-Distinguish-between-IPv4-and-IPv6-wildcard-socket.patch
  ip-maddr-fix-filtering-by-device.patch
  man-add-additional-explainations-for-ss.patch
  tc-move-action-cookie-print-out-of-the-stats-if.patch
  tc-remove-action-cookie-len-from-printout.patch
  link_gre6-Detect-invalid-encaplimit-values.patch
  man-tc-csum.8-Fix-inconsistency-in-example-descripti.patch
  tc-bash-completion-add-missing-classid-keyword.patch
  gre-ip6tnl-tunnel-Fix-noencap-support.patch
  Restore-no-print-directory-option-for-silent-builds.patch
  iplink-Validate-minimum-tx-rate-is-less-than-maximum.patch
  ipaddress-Make-sure-VF-min-max-rate-API-is-supported.patch
* Thu Apr  5 2018 mkubecek@suse.cz
- add Provides and Obsoletes for removed iproute2-doc
* Thu Apr  5 2018 mkubecek@suse.cz
- use fdupes to avoid OBS warnings (and unlinked duplicate files)
* Thu Apr  5 2018 mkubecek@suse.cz
- use %%license for license file (bsc#1082318)
* Thu Apr  5 2018 mkubecek@suse.cz
- drop outdated sgml/tex/pdf documentation:
  patches/README-re-add-updated-information-link.patch
  patches/README-update-location-of-git-repositories-remove-br.patch
  patches/Remove-leftovers-from-removed-Latex-documentation.patch
  patches/doc-drop-old-ip-command-documentation.patch
  patches/doc-remove-obsolete-ip-tunnels-documentation.patch
  patches/doc-remove-outdated-IPv6-flow-label-document.patch
  patches/doc-remove-outdated-arpd-documentation.patch
  patches/doc-remove-outdated-nstat-rtstat-documentation.patch
  patches/doc-remove-outdated-ss-documentation.patch
  patches/doc-remove-outdated-tc-filters-documentation.patch
- move remaining files from iproute2-doc (which are fairly small)
  into the main package and drop iproute2-doc completely
* Thu Apr  5 2018 mkubecek@suse.cz
- make guards and apply-patches scripts executable in prep phase
  (needed to fix build in IBS)
* Thu Apr  5 2018 mkubecek@suse.cz
- add more post-4.12 fixes (bsc#1085669):
  devlink-fix-port-new-monitoring-message-typo.patch
  ip-address-Fix-negative-prints-of-large-TX-rate-limi.patch
  ip-link-Fix-use-after-free-in-nl_get_ll_addr_len.patch
  lib-libnetlink-re-malloc-buff-if-size-is-not-enough.patch
  lib-libnetlink-update-rtnl_talk-to-support-malloc-bu.patch
  rdma-Check-return-value-of-strdup-call.patch
  rdma-Check-that-port-index-exists-before-operate-on-.patch
  rdma-Fix-misspelled-SYS_IMAGE_GUID.patch
  rdma-Ignore-unknown-netlink-attributes.patch
  rdma-Protect-dev_map_lookup-from-wrong-input.patch
  rdma-Reduce-scope-of-_dev_map_lookup-call.patch
  tc-fix-command-tc-actions-del-hang-issue.patch
* Thu Apr  5 2018 mkubecek@suse.cz
- add warning that changes should be submitted via git (i.e. not
  directly to IBS) to both specfiles
* Wed Apr  4 2018 mkubecek@suse.cz
- reorder patches into upstream order (and move SUSE specific ones
  to the end); this allows fewer modifications compared to original
  upstream commits and makes future backports easier (no effect
  on expanded source tree)
* Wed Apr  4 2018 mkubecek@suse.cz
- transform the package to patches tarball and series.conf for
  easier maintenance (no effect on expanded source tree)
  * pack all patches into a tarball
  * list them in series.conf
  * apply patches in a loop using guard utility
* Fri Mar 16 2018 mkubecek@suse.cz
- ss-Fix-for-added-diag-support-check.patch:
  fix ss showing TCP sockets twice (bsc#1081093)
- proactively add post-4.12 fixes (bsc#1085669):
  utils-return-default-family-when-rtm_family-is-not-R.patch
  Really-fix-get_addr-and-get_prefix-error-messages.patch
  iproute-Add-support-for-extended-ack-to-rtnl_talk.patch
  ss-enclose-IPv6-address-in-brackets.patch
  lib-fix-extended-ack-with-and-without-libmnl.patch
  lib-need-to-pass-LIBMNL-flag.patch
  change-how-Config-is-used-in-Makefile-s.patch
  tc-ip-more-Makefile-updates-for-LIBMNL.patch
  lib-Dump-ext-ack-string-by-default.patch
  bpf-unbreak-libelf-linkage-for-bpf-obj-loader.patch
  libnetlink-Fix-extack-attribute-parsing.patch
  ifstat-Fix-memleak-in-dump_kern_db-for-json-output.patch
  ss-Fix-potential-memleak-in-unix_stats_print.patch
  iproute-Fix-for-missing-Oifs-display.patch
  ipmaddr-Avoid-accessing-uninitialized-data.patch
  link_gre6-Fix-for-changing-tclass-flowlabel.patch
  tc-actions-store-and-dump-correct-length-of-user-coo.patch
  ss-Distinguish-between-IPv4-and-IPv6-wildcard-socket.patch
  ip-maddr-fix-filtering-by-device.patch
  man-add-additional-explainations-for-ss.patch
  tc-move-action-cookie-print-out-of-the-stats-if.patch
  tc-remove-action-cookie-len-from-printout.patch
  link_gre6-Detect-invalid-encaplimit-values.patch
  man-tc-csum.8-Fix-inconsistency-in-example-descripti.patch
  tc-bash-completion-add-missing-classid-keyword.patch
  gre-ip6tnl-tunnel-Fix-noencap-support.patch
  Restore-no-print-directory-option-for-silent-builds.patch
  iplink-Validate-minimum-tx-rate-is-less-than-maximum.patch
  ipaddress-Make-sure-VF-min-max-rate-API-is-supported.patch
* Wed Sep  6 2017 mkubecek@suse.cz
- fix "ip link show dev ..." for NICs with many virtual functions
  (bsc#1056261):
  iplink-check-for-message-truncation-in-iplink_get.patch
  iplink-double-the-buffer-size-also-in-iplink_get.patch
* Wed Sep  6 2017 mkubecek@suse.cz
- rdma-fix-duplicate-initialization-in-port_names.patch:
  a follow-up fix for rdma tool series
* Fri Aug 25 2017 mkubecek@suse.cz
- add rdma tool, backport from upcoming upstream version 4.13
  (bsc#1050695):
  utils-Move-BIT-macro-to-common-header.patch
  rdma-Add-basic-infrastructure-for-RDMA-tool.patch
  rdma-Add-dev-object.patch
  rdma-Add-link-object.patch
  rdma-Add-json-and-pretty-outputs.patch
  rdma-Implement-json-output-for-dev-object.patch
  rdma-Add-json-output-to-link-object.patch
  rdma-Add-initial-manual-for-the-tool.patch
* Fri Aug 25 2017 mkubecek@suse.cz
- drop patches conditionally applied on SLE11 and older:
  Revert-emp-fix-warning-on-deprecated-bison-directive.patch
  doc-revert-PDF-creation.patch
* Tue Aug 22 2017 mkubecek@suse.cz
- patch cleanup for SLE15 package:
  * rename iproute2-dirs.diff
  - > adjust-installation-directories-for-openSUSE-SLE.patch
  * split iproute2-HZ.diff into
    use-sysconf-_SC_CLK_TCK-if-HZ-undefined.patch and
    add-explicit-typecast-to-avoid-gcc-warning.patch
  * rename revert-pdf-creation.diff
  - > doc-revert-PDF-creation.patch
  * rename revert-bison-fix.diff
  - > Revert-emp-fix-warning-on-deprecated-bison-directive.patch
  * rename kernel_xfrm6_raw.patch
  - > xfrm-support-displaying-transformations-used-for-Mob.patch
  * refresh man-fix-documentation-references-in-manual-pages.patch
  * rename iproute2-split-make.patch
  - > split-link-and-compile-steps-for-binaries.patch
  * rename iproute2-3.16.0-fix-bashisms.patch
  - > examples-fix-bashisms-in-example-script.patch
- apply all patches in both specfiles to make sure everything is
  built from fully patched sources
- move SLE11 workarounds to the end of the series
* Tue Jul 11 2017 mkubecek@suse.cz
- Update to new upstream release 4.12
  * tc: add support for invisible qdisc dumping
  * ip route: support ttl-propagation attribute
  * ip route: support for MPLS LWT ttl attribute
  * libnetlink: add flag to suppress print of nlmsg error
  * ip netconf: show all address families by default
  * ip vrf: show command name next to pid
  * ip: add ip sr command to control SR-IPv6 internal structures
  * ip route: add support for SR-IPv6 lwtunnel encapsulation
  * ip link: expose packet marking atribute of tunnels
  * bpf: add support for generic xdp
  * ip xfrm: add xfrm state crypto offload
  * devlink: add support for pipeline debug (dpipe)
  * tc: reflect HW offload status
  * vxlan: add support for modifying vxlan device attributes
  * pedit: introduce IPv6 support
  * ip: add support for more MPLS labels
  * devlink: add option to set and show eswitch encapsulation support
  * ip: add handling for new CAN netlink interface
  * ip vrf: Add show command
  * ip link: add vxcan support
  * ip link: support gre6 encaplimit option
  * ip mroute: add table output to show command
  * ip neigh: allow flush FAILED neighbour entry
  * ip tunnel: add support for mpls/ip to ipip and sit tunnels
* Thu Jun 29 2017 jengelh@inai.de
- Update to new upstream release 4.11
  * ip: support UID range routing.
  * ss: Add inet raw sockets information gathering via netlink diag interface
  * ss: print new tcp_info fields: delivery_rate and app_limited
  * ss: print new tcp_info fields: busy, rwnd-limited, sndbuf-limited times
  * tc: flower: support matching on ICMP type and code
  * lwt: BPF support for LWT
  * Introduce ip vrf command
  * iplink: bridge: add support for displaying xstats
  * iplink: bridge_slave: add support for displaying xstats
  * ip: Add support for MPLS netconf
* Sat Jun 10 2017 meissner@suse.com
- split link and compile steps for binaries, so LDFLAGS and CFLAGS
  are not mixed so the the PIE default build work.
- Add iproute2-split-make.patch
* Tue Dec 13 2016 jengelh@inai.de
- Update to new upstream release 4.9
  * bridge: vlan: add support to display per-vlan statistics
  * tipc: add the ability to get UDP bearer options
  * tc: flower: Introduce vlan support
  * ss: output TCP BBR diag information
  * iptnl: add support for collect_md flag in IPv4 and IPv6 tunnels
  * ss: Support displaying and filtering on socket marks.
  * tc: fq: display unthrottle latency
  * ip link: Add support to configure SR-IOV VF to vlan protocol
    802.1ad (VST QinQ)
  * ip rule: add selector support
  * bridge: add support for the multicast flood flag
  * ip: update link types to show 6lowpan and ieee802.15.4 monitor
  * ss: Add support for SCTP protocol
  * iproute2: macvlan: add "source" mode
* Wed Nov 16 2016 jslaby@suse.com
- put lnstat nstat routef routel ss into /usr/bin so that users can
  actually run them
* Wed Nov 16 2016 glin@suse.com
- Add libelf-devel to BuildRequires to enable bpf object loading
* Mon Oct 17 2016 jengelh@inai.de
- Update to new upstream release 4.7
  * add support for VXLAN-GPE
  * ss: add SK_MEMINFO_DROPS display
  * devlink: implement shared buffer support
  * devlink: implement shared buffer occupancy control
  * ip, token: add del command
  * fq_codel: add per queue memory limit
  * ip: add MACsec support
  * ipaddress: Allow listing addresses by type
  * ip rule: Add support for l3mdev rules
  * ss: Add support to filter on device
  * ip link/addr/route: Add support for vrf keyword
  * bridge: add json support for bridge fdb/vlan show
- Update to new upstream release 4.8
  * ip: report IFLA_GSO_MAX_SIZE and IFLA_GSO_MAX_SEGS
  * tc: Add support for the matchall traffic classifier.
  * iptuntap: show processes using tuntap interface
* Sat May 21 2016 jengelh@inai.de
- Update to new upstream release 4.6
  * vxlan: add support to set flow label
  * tc, bpf: add new csum and tunnel signatures
  * tc, bpf: further improve error reporting
  * tc, bpf: add support for map pre/allocation
  * ip link: Add support for kernel side filtering
  * tc: introduce IFE action
  * add devlink tool
  * iplink: display IFLA_PHYS_PORT_NAME
* Sat Mar 26 2016 jengelh@inai.de
- Update to new upstream release 4.5
  * {f,m}_bpf: allow for sharing maps
  * geneve: add support for IPv6 link partners
  * geneve: add support for lwt tunnel creation and dst port selection
  * route: allow routes to be configured with expire values
  * iplink: support setting addrgenmode stable_secret
  * tipc: add peer remove functionality
  * tc, clsact: add clsact frontend
  * ss: support closing inet sockets via SOCK_DESTROY.
  * bridge: support for static and dynamic fdb entries
  * iplink: Support VF Trust
* Thu Jan 14 2016 mkubecek@suse.cz
- Update to new upstream release 4.4
  * tunnel code rework
  * add VRF support
  * add lightweight tunnel support
  * ila: Add support for ILA lwtunnels
  * f_bpf: allow for optional classid and add flags
  * m_bpf: don't require default opcode on ebpf actions
  * route: Add RTM_F_LOOKUP_TABLE flag and show table id
  * neigh: Add support for filtering dumps by master device
  * route: print addrgenmode stable_secret and fallback otherwise
  * tc: flower no need to specify the ethertype
  * geneve: add support for IPv6 link partners
  * neigh: device is optional for proxy entries
  * tunnel: determine tunnel address family from the tunnel type
  * addr: ignore EADDRNOTAVAIL errors during address flush operation
  * vxlan, gre: add support for collect metadata flag
  * route: ignore RTAX_HOPLIMIT of value -1
  * route: fix printing of locked entries
  * vxlan: Add support for remote checksum offload
  * documentation improvements
- man-fix-documentation-references-in-manual-pages.patch:
  replace Debian specific paths and package names with SUSE ones
* Wed Nov 11 2015 jengelh@inai.de
- Update to new upstream release 4.3
  * route: filter routes by family if so specified
  * ip: add `ip rule save/restore`
  * Manpage additions for tc filters
* Thu Sep 10 2015 jengelh@inai.de
- Update to new upstream release 4.2
  * route: add support to print 'linkdown' nexthop flag
  * addr: add support for brief output
  * ss: add support for segs_in and segs_out
  * ss: add support for bytes_acked & bytes_received
  * Add displaying VF traffic statistics
  * tc: add support for Flower classifier
  * GENEVE support
  * link: add ageing_time, stp_state and priority for bridge
  * bridge: mdb: add support for router add/del notifications
  monitoring
  * ss: print value of IPV6_V6ONLY socket option if set
* Wed Jul 15 2015 dimstar@opensuse.org
- Update to version 4.1.1:
  * tipc: make build conditional on having libmnl.
  * build: must honor pkg-config flags for libmnl.
  * include: add copy of tipc.h.
  * Fix MPLS support.
- Drop iproute2-tipc-headers.patch, iproute2-pkgconfig.diff
  (fixed upstream)
* Mon Jun 29 2015 mkubecek@suse.cz
- iproute2-tipc-headers.patch:
  fix build on systems with pre-3.16 kernel headers
- apply build fixes also in iproute2-doc.spec
* Sun Jun 28 2015 jengelh@inai.de
- Update to new upstream release 4.1
  * ip: support RFC4191 router preference
  * xfrm: add command for configuring SPD hash table
  * tipc: add new TIPC configuration tool
  * BPF support in tc
  * Lots of RED (tc scheduler) cleanup work
  * color option to ip command
- Add iproute2-pkgconfig.diff: work around continued ignorance of
  pkg-config
* Tue Jun 16 2015 jengelh@inai.de
- Update iproute2-dirs.diff to respect /usr/share/tc [bnc#934828]
* Mon Apr 13 2015 jengelh@inai.de
- Update to new upstream release 4.0
  * ip: route: add congestion control metric
  * vxlan: Group policy extension
  * tc: add support for BPF based actions
  * iproute2: bridge: support vlan range adds
  * ip xfrm: Allow to specify "all" option for monitor
  * ipnetns: allow to get and set netns ids
  * iplink: add support of IFLA_LINK_NETNSID attribute
  * Allow specifying bridge port STP state by name rather than number.
  * ip-monitor: allow to monitor ip rules
  * bridge link: add support to specify master
* Sun Feb 22 2015 jengelh@inai.de
- Update to new upstream release 3.19
  * ip link: Add support for remote checksum offload to IP tunnels
  * can: Add support for CAN FD non-ISO feature
  * ss: Filter inet dgram sockets with established state by default
  * ip link: Fix crash on older kernels when showing VF devices
  * ss: Unify packet stats output from netlink and proc
  * ss: Unify unix stats output from netlink and proc
  * tc class: Show classes as ASCII graph
  * ip link: Add ipvlan support to the iproute2/ip util
- Add kernel_xfrm6_raw.patch to recognize more XFRM types
* Wed Jan  7 2015 jengelh@inai.de
- Update to new upstream release 3.18
  * Human readable output for `ip -s link` (ip -s -h link)
  * Permit filtering `ip monitor` events by device per "dev NAME".
  * Permit filtering `ip link` output by device per "master NAME",
  and by type per `type T` (e.g. type vlan).
  * Permit filtering `ip addr` output by flags like "tentative" and
  "-tentative".
* Sun Dec 28 2014 ledest@gmail.com
- fix bashisms in gaiconf script
- add patches:
  * iproute2-3.16.0-fix-bashisms.patch
* Tue Nov 25 2014 mkubecek@suse.cz
- Update to new upstream release 3.17
  * ip: allow to set ipv6 address generation mode
  * nstat: 64bit support on 32bit architectures
  * ip: don't require "name" keyword when adding device
  (3.16 regression)
  * ip: support of usec rtt in tcp_metrics
  * ip: allow to change slave options via type_slave
  * ip: add support for IPv6 VTI tunnels
  * tc: rsvp/tcindex/route classifier support for multiple actions
  * ip: print stats with "ip -s addr show"
- Add revert-bison-fix.diff:
  fix build on SLE11
* Sun Aug 10 2014 jengelh@inai.de
- Update to new upstream release 3.16
  * bridge: Add master device name to bridge fdb show
  * ip: check for missing dev arg when doing VF rate
  * Add support to configure SR-IOV VF minimum and maximum Tx rate
  through ip tool
* Wed Jul 16 2014 jengelh@inai.de
- Update to new upstream release 3.15
  * Support for HHF qdisc
  * Updates to bridge command
  * Lots of vxlan related changes
  * Details at http://lwn.net/Articles/601909/
* Fri Apr 25 2014 dmueller@suse.com
- split iproute2-doc subpackage into a separate spec to reduce
  rebuild times
- add pre_checkin.sh to sync version number between iproute2 and
  iproute2-doc
* Wed Apr 16 2014 jengelh@inai.de
- Update to new upstream release 3.14
  * ip link: support for High Availability Seamless Redundancy
  (HSR) network devices.
  * ip link: support for creating/deleting bonding devices
  * ip link: support for specifying interface indexes during
  creation of devices
  * tc/pkt_sched: add support for the "FQ" Fair Queue packet scheduler
  * tc: support for the BPF-based traffic classifier
  * tc, netem: support 64-bit quantity rate speeds
  * tc: support for the new "PIE" Proportional Integral controller
  Enhanced scheduler
  * ss: display PF_LOCAL-SOCK_SEQPACKET sockets as such rather than
  SOCK_DGRAM
  * ss: display zone names when so needed
  * ss: add support for retrieving SELinux contexts
* Mon Dec  9 2013 jengelh@inai.de
- Update to new upstream release 3.12
  * ip rule: add route suppression options
  * tc: support for the "fq" Fair Queue packet scheduler
  * tc: support 64-bit rate estimator statistics
  * GRE-over-IPv6 tunnel support
  * VXLAN IPV6 support
* Thu Sep 12 2013 jengelh@inai.de
- Update to new upstream release 3.11
  * Support for Linux 3.11
  * iptunnel: check SIT_ISATAP flag only for SIT tunnel
  * ss: show destination address for netlink sockets
  * ss: Get netlink sockets info via sock_diag
  * vxlan: Allow setting destination to unicast address
  * ss: add fastopen support
  * htb: report overhead attribute
  * ip: allow to specify mode for sit tunnels
  * ip: iplink_vlan: add 802.1ad support
  * iptuntap: allow creation of multi-queue tun/tap device
* Wed Sep 11 2013 werner@suse.de
- Make it build with latest TeXLive 2013
* Wed Jun  5 2013 jengelh@inai.de
- Update to new upstream release 3.9.0
  * Support for managing the forwarding tables in Bridge and VXLAN.
- Remove 0001-build-resolve-compile-error-due-to-missing-include.patch
  (merged upstream)
- Signature verification for the package
* Mon Apr 15 2013 jengelh@inai.de
- Update to new upstream release 3.8.0
  * implement bridge mdb commands
  * add DOVE extensions
  * add `ip netns pids` and `ip netns identify`
  * tc netem: allow negative packet/cell overhead
  * support tunnels in `ip link type ipip|sit|ip6tnl`
- Add 0001-build-resolve-compile-error-due-to-missing-include.patch
* Thu Dec 13 2012 jengelh@inai.de
- Update to new upstream release 3.7.0
  * add support for tcp_metrics
  * iplink: Added support for the kernel IPoIB RTNL ops
  * ss: Get udp sockets info via sock-diag
  * tc: add canid ematch to ematch_map
  * vxlan support
* Tue Oct  9 2012 jengelh@inai.de
- Update to new upstream release 3.6.0
  * ss: report SK_MEMINFO_BACKLOG
  * tc: add ipset ematch
  * iplink: add support for num[tr]xqueues
  * iproute2: Add FDB print and update cmds for self and master
  * iproute: Add ability to save, restore and show the interfaces'
  addresses
  * iproute2: VTI support for ip link command
- Rename iproute2-libdir-1.diff to iproute2-dirs.diff, as it does
  more than just changing LIBDIR.
- Add revert-pdf-creation.diff, as the new PDF creation commands
  do not want to work with openSUSE 12.2 and before.
* Tue Sep 18 2012 werner@suse.de
- Make it build even without pdflatex, use latex+dvips, beside this
  iproute2-pdflatex.diff was documented, see my last entry from
  Jul 30 14:33:58 UTC 2012.
* Mon Sep 17 2012 idonmez@suse.com
- Add BuildRequires on texlive-dvips for openSUSE > 12.2 to fix
  Factory builds.
* Sat Sep  8 2012 jengelh@inai.de
- Update to new upstream release 3.5.1
  * ss: Report MSS from internal TCP information
  * ip: allow IPv6 addresses for l2tp local and remote parameters
  * tc: Support for tc_codel - Controlled Delay AQM
  * tc: Support for fq_codel - Fair Queue Codel AQM
  * tc-netem: Add support for ECN packet marking
- Remove undocumented iproute2-pdflatex.diff which breaks the
  build since using the iproute2-3.5.1 tarball
* Mon Jul 30 2012 werner@suse.de
- Make it build with modern pdflatex and TeXLive 2012 ... for this
  also sgmltools has to know about correct babel style usage
* Thu May 24 2012 jengelh@inai.de
- Update to new upstream release 3.4.0
  * for kernel 3.4
  * ss: use new INET_DIAG_SKMEMINFO option to get more memory
  information for tcp socket
  * ip: add ability to set link state
* Sat Mar 31 2012 bili@suse.com
- Distribute COPYING file for rpm(bnc#745225).
* Fri Mar 30 2012 jengelh@medozas.de
- Update to new upstream release 3.3.0
  * This release updates qdisc parameters in sfq and red, adds Netem
  extensions for shaping and for loss models, adds lots of manual
  page corrections, adds the QFQ scheduler and the LLDP-to-ethernet
  type table (along with support for processless network namespaces
  and L2TPv3 plus L2TP tunneling), improves RED options, and adds
  assorted bugfixes.
* Thu Mar  8 2012 rschweikert@suse.com
- Place ip binary in /usr tree (UsrMerge project)
- Fix permissions to eliminate rpmlint errors
* Sat Jan 14 2012 jengelh@medozas.de
- Update to new upstream release 3.2.0
  * L2TPv3 support
  * netem additions for loss models, improved RED options
* Sat Dec 31 2011 jengelh@medozas.de
- Update to new upstream release 3.1.0
  * ip: Add processless network namespace support
  * tc: Add QFQ scheduler
  * ss: display closed UDP sockets on `ss -ul`
  * ss: report ecnseen
  * Add L2TP support
* Fri Oct 21 2011 jengelh@medozas.de
- Clarify license for iproute2.spec (bnc#720282)
* Sat Sep 24 2011 jengelh@medozas.de
- Add patch iproute2-xt-detect.diff to address shipped Makefiles'
  failure to use pkg-config to locate libxtables, and thus
  reenable m_xt
* Fri Jul  8 2011 jengelh@medozas.de
- Update to new upstream release 2.6.39
  * support device group semantics
  * support listing devices by group
  * parse flag XFRM_POLICY_ICMP
  * CHOKe scheduler
  * macvlan/macvtap: support 'passthru' mode
  * tc: SFB flow scheduler
  * tc add mqprio qdisc support
  * xfrm security context support
  * allow to specify truncation bits on auth algo
  * fix unit conversion of rtt/rttvar/rto_min
  * support IFLA_TXQLEN in ip link command
- Remove iproute2-pdfdoc.diff: merged upstream
- Remove iproute2-memleak.diff: merged upstream
* Tue May 31 2011 jengelh@medozas.de
- Correct installation path of tc modules
- Restore symbol lookup in m_xt.so (bnc#679172)
- Add patches to make m_xt build with libxtables6
- Restore m_xt's module lookup (bnc#660554)
- Run spec-beautifier
* Mon May 30 2011 jengelh@medozas.de
- Disable building m_xt.so which has not been updated for
  iptables 1.4.11
* Wed Mar 23 2011 bphilips@novell.com
  Remove unneeded patches:
  * iproute2-warnings.diff bnc#34714
  Warnings no longer exist
  * iproute2-iptunnel-fclose.diff
  Process is dying no need to close file pointers
  * iproute2-ss-pclose.diff
  Process is dying no need to close file pointers
  * iproute2-flushcheckuid.diff
  Fixed upstream
  * iproute2-skbedit-memset.diff
  Fixed upstream 46a6573259f46f86eb0048a2c805b24ff4183fa6
* Tue Mar 22 2011 ms@suse.de
- Update to 2.6.38, fix for options process with ipt (bnc #679172)
- tidy up the package, spec file names, patch names, etc
* Wed Jan 12 2011 mt@suse.de
- Adopted ip route rtt,rttvar,rto_min metrics time unit to
  milliseconds as required by recent kernels (bnc#659746).
* Tue Jan 11 2011 jengelh@medozas.de
- Update to iproute2-2.6.37
  * Support for iptables >= 1.4.9
  * Support for GRE in XFRM
  * tc f_flow now knows rxhash
  * Support for macvtap "mode" parameter
  * tc ACT_CSUM support
  * added `ip route save` and `ip route restore` commands
- Spec file updates
  * Remove pointless AutoReqProv:on (that's the default)
  * Enable tc's m_xt
* Fri Dec  3 2010 ms@suse.de
- removed the fragtimeout patch because it breaks the rto_min
  setup. The fragtimeout patch also requires a kernel side
  modification which we don't ship since SLES9 (bnc #656667)
* Mon Nov 15 2010 jengelh@medozas.de
- Split documentation into its own subpackage, reducing the size
  of the main package by ~500K
* Wed Nov  3 2010 jengelh@medozas.de
- Update to iproute2-2.6.35+git9 for obtaining
  Linux 2.6.36-introduced features (no iproute2-2.6.36 tag yet)
  * Added RTA_MARK support (e.g. `ip route get ::1 mark 2`)
  * 64-bit interface statistics
* Tue Nov  2 2010 jengelh@medozas.de
- Update to iproute2-2.6.35
  * Added support for multicast iprules
  * Speed up `ss -p`
  * Update ARP header type table
* Tue Nov  2 2010 jengelh@medozas.de
- Update to iproute2-2.6.34
  * Fix build issues with flex 2.5
  * Detect 6rd tunnel scope
  * Added `ip tuntap` support (this practically obsoletes the
  "tunctl" package)
  * Added support for XFRM/SA by fwmark
  * Added initrwnd
- 2 patches integrated, thus dropped
* Tue Nov  2 2010 jengelh@medozas.de
- Update to iproute2-2.6.33
  * Added 6rd support
  * Added macvlan options for bridge mode
  * Added support to mark packets in skbedit
  * Added oif classification support in iprule
* Tue Nov  2 2010 jengelh@medozas.de
- Update to iproute2-2.6.31
  * Dropped equalize support
  * Fixed segfault when using garbage lladdr
  * Added new m_xt module for iptables-1.4.5
  * Added support for CAN
  * Allow ISATAP with stateless autoconfiguration
  * Added support for cgroup
  * Added support for monitoring neigh table activities
- 3 patches integrated, thus dropped
* Tue Feb 23 2010 jengelh@medozas.de
- add a patch to avoid tun tunnels being shown as "link/65534"
* Sat Dec 19 2009 jengelh@medozas.de
- enable parallel build
* Wed Nov 11 2009 ms@suse.de
- check effective UID instead of real UID in the flush
  permissions coding (bnc #554419)
* Fri Oct  9 2009 ms@suse.de
- added missing fclose to ss utility (bnc #543986)
* Wed Sep 16 2009 ms@suse.de
- fixed memory leak in read_igmp() function ip/ipmaddr.c (bnc #538996)
* Thu Sep 10 2009 ms@suse.de
- added support for monitoring neighbour tables (bnc #537906)
- added support for displaying type labels (bnc #537906)
* Fri Aug 28 2009 ms@suse.de
- added missing pclose (bnc #534912)
* Wed Aug 26 2009 mls@suse.de
- make patch0 usage consistent
* Wed Aug 12 2009 adrian@suse.de
- update to version 2.6.29-1
  * Support for lxc
* Tue Jul 28 2009 ms@suse.de
- make sure do_tunnels_list proc file descriptor will be
  closed after use or on proc read error (bnc #525834)
* Thu Feb 19 2009 ms@suse.de
- fixed ss utility to display inet6 addresses if requested
  with -6 or -f inet6 (bnc #473156)
* Tue Jan 27 2009 ms@suse.de
- fixed a bug in which the memory for the tc_skbedit struct was
  being used uninitialized to 0.  This patch corrects the issue
  by using a memset to 0 out the memory of the
  structure (bnc #438950)
* Thu Dec 11 2008 agruen@suse.de
- Change max length of the MAC address from 16 bytes to 32 bytes
  to accommodate infiniband (bnc#445014).
* Mon Oct 13 2008 ms@suse.de
- fixed compiler warnings (bnc #434714)
* Thu Sep 18 2008 hare@suse.de
- Add skbedit support for FCoE (FATE#303914)
- Add multiqueue support for FCoE (FATE#303914)
- Rename libnl to libnetlink-devel
- Fix IPPROTO_DCCP redefine
- rpmlint fixes
* Mon Jul 14 2008 ms@suse.de
- update to version 2.6.25
  * Fix off by one in nested attribute management.
  * netem potential dist table overflow
  * rto_min value display overflow
  * Overhead calculation is now done in the kernel.
  * libnetlink: don't spin forever on receive error
  * Protocol field on tc_filter is required by the kernel, provide it
  * Add missing prefix bit length for addrlabel
  * Do not strip binaries with `install`
  * In police, fix uninitialized "overhead" variable.
  * lots of documentation fixes
* Fri Jul 11 2008 ms@suse.de
- fixed RTM_NEWLINK check for older kernels (bnc #407954)
* Mon Jun 30 2008 ms@suse.de
- fixed 'tc qdisc' segmentation fault (bnc #404755)
* Thu May  8 2008 ms@suse.de
- compile libnetlink with -fPIC (bnc #388021)
* Wed Apr 16 2008 schwab@suse.de
- Don't strip binaries.
* Thu Oct 25 2007 ms@suse.de
- update to version 2.6.23, fixed (#336488)
  Reason for update:
  * The macvlan module, which got added to the kernel in version
    2.6.23, needs the new "ip link add" feature
  These patches add a rewritten version of Ben's macvlan driver, which
  allows to create virtual ethernet devices. The underlying device is
  put in promiscous mode and packets are demuxed based on MAC address.
  It behaves similar to bridge devices in that packets are visible on
  the real device before delivery to the macvlan driver. The driver
  supports all features of the underlying device except VLAN
  acceleration, this is currently very hard to support. I might look
  into this in the future.
  The main downside of this driver is that it adds another hook in
  netif_receive_skb, unfortunately that is unavoidable. When not
  compiled in the hook vanishes of course.
  Usage is simple:
    ip link add link eth0 type macvlan
  Will create a macvlan0 device with a random MAC address on top of
  eth0. No iproute patches are required.
* Tue Oct 16 2007 jdelvare@suse.de
- libnetlink.3 is now part of the upstream package, no need to
  include our own copy.
* Wed Jul 11 2007 ms@suse.de
- update to version 2.6.22, fixed (#288551)
  * Kim Woelders <kim@woelders.dk>, various useful fixups: compilation
  with old kernels, cross-compiling, "all" == "any" in prefix spec.
  * Collected from my disk, cleaned and packed to directory iproute2/misc/
    several utilities: ss, nstat, ifstat, rtacct, arpd and module tcp_diag.
    Writing some docs. me.
  * prepared patchlet for pidentd to use tcp_diag.
  * David Miller: 64bit (and even worse 64bit kernel/32 bit user :-) fixes
    to above. tcp_diag is merged to main tree.
  * Alexandr D. Kanevskiy <kad@blackcatlinux.com>: various flaws in ss
  * Alexandr D. Kanevskiy <kad@blackcatlinux.com>: oops, more aggressive caching
    of names opened old bugs: ip started to print garbage in some places.
  * Robert Olsson, rt_cache_stat. Renamed to rtstat.
  * An old bug in "ip maddr ls": reduntant empty lines in output.
    Seeing this crap for ages but lucky match of desire/ability to repair
    and a huff about this happened only today. :-)
  * "Mr. James W. Laferriere" <babydr@baby-dragons.com>
    doc: option to produce ps output for non-a4 and not only 2 pages/sheet.
  * Jamal's patch for ingres qdisc.
  * Bernd Eckenfels <ecki@lina.inka.de>: deleted orphaned bogus #include
    in include/utils.h.
  * Julian Anastasov <ja@ssi.bg>: uninitialized fields in nexthop
    producing funny "dead" nexthops in multipath routes.
    Stupid me, look at the first line in [010803]... Was it difficult to guess
    this that time? People blame for several months. :-)
    Special thanks to bert hubert <ahu@ds9a.nl> who raised the issue in netdev.
    Thanks and apologies to Terry Schmidt <terry@nycwireless.net>,
    Ruben Puettmann <ruben.puettmann@freenet-ag.de>,
    Mark Ivens <mivens@clara.net>.
  * willy tarreau <wtarreau@yahoo.fr>: "make install" target.
  * Tunable limit for sch_sfq. Patch to kernel activating this
    is about to be submitted. Reminded by Adi Nugroho <Adi@iNterNUX.co.id>
* Fri Apr 20 2007 aj@suse.de
- Use texlive for building.
* Mon Apr  2 2007 rguenther@suse.de
- add bison and flex BuildRequires
* Thu Feb  8 2007 ms@suse.de
- fixed array size of name string in iptables.h (#243281)
  array of size IPT_FUNCTION_MAXNAMELEN - 1 is referenced
  at element IPT_FUNCTION_MAXNAMELEN - 1 which is outside the
  array bounds
* Mon Jan 29 2007 ms@suse.de
- fixed wrong IPT_LIB_DIR value and replaced the code by a
  dynamic check for the /usr/%%lib/iptables directory (#238886)
* Tue Nov  7 2006 ro@suse.de
- fix permissions for manpage
* Thu Jul 20 2006 ms@suse.de
- replaced static HZ define to dynamic:
  [#]ifndef HZ
  [#]define HZ sysconf(_SC_CLK_TCK)
  [#]endif
* Thu May 25 2006 schwab@suse.de
- Fix crash while resolving addresses.
* Mon Apr  3 2006 hvogel@suse.de
- fix flex input file to use uppercase STR to avoid conflicts.
  This prevented tc from being build [#162931]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Tue Jan 17 2006 mrueckert@suse.de
- update to version 2.6.15-060110
* Tue Nov  8 2005 mmj@suse.de
- update to version 051107
* Sun Oct 23 2005 ro@suse.de
- fix filelist for libnlink
* Thu Oct 20 2005 mmj@suse.de
- update to version 051007
- fix buffer overflow in iproute.c [#129415] (thanks Richard, Marcus)
- don't strip stuff
* Wed Aug 17 2005 cthiel@suse.de
- update to version 050816 [#105087]
* Sat Aug  6 2005 dmueller@suse.de
- add /bin/ip symlink (#102513)
* Wed Jun 15 2005 meissner@suse.de
- use RPM_OPT_FLAGS
* Mon May  9 2005 mmj@suse.de
- Update to 2.6.11-050330
* Thu Feb 10 2005 ro@suse.de
- remove dropped tetex subpackages from nfb
* Fri Feb  4 2005 mmj@suse.de
- Update to 2.6.10-ss050124
* Tue Dec  7 2004 mmj@suse.de
- Don't trust that the kernel and do our own family check [#48600]
* Sun Oct 24 2004 mmj@suse.de
- Clean up spec file a bit
- Update to new snapshot including even more of our patches
* Tue Oct 12 2004 mmj@suse.de
- Update to 2.6.9 including some of our patches
* Tue Aug 17 2004 mmj@suse.de
- Make ip print correct type when printing stats [#42589]
* Wed Apr 21 2004 mmj@suse.de
- Fix bufferoverflow in nstat [#39179]
* Fri Apr 16 2004 kukuk@suse.de
- Fix compiling with 2.6.5 kernel headers
- Remove backup files
* Wed Apr 14 2004 mmj@suse.de
- Don't remove buildroot before install
* Wed Mar 17 2004 mmj@suse.de
- No executables below /usr/include [#36342]
* Wed Mar 10 2004 mmj@suse.de
- Olaf Kirch fixed the kernel, so remove the fix for [#35288]
* Wed Mar  3 2004 ak@suse.de
- Fix hang in ip addr flush (#35288)
* Wed Jan  7 2004 mmj@suse.de
- ifstat should store it's history in /var/tmp not /tmp
* Mon Nov 10 2003 mmj@suse.de
- Add more man-pages [#32981]
* Wed Oct 15 2003 mmj@suse.de
- Don't build as root
* Mon Aug 11 2003 mmj@suse.de
- Add all the pdf documentation [#28637]
* Thu Jun 12 2003 kukuk@suse.de
- Fix filelist
* Wed Jun  4 2003 kukuk@suse.de
- Don't use include-glibc directory
- Fix arpd to compile with db4
* Tue May 13 2003 mmj@suse.de
- Remove files we don't package
* Mon May 12 2003 mmj@suse.de
- Add glib-include from newer iputils, and change a kernel-include
  to make it build
* Tue Feb 11 2003 ug@suse.de
- patch for HTB support applied since 2.4.20 supports it
* Fri Feb  7 2003 mmj@suse.de
- Make the man tar-ball not contain gzipped man-pages, it's already
  compressed once.
- Apply patch from Andi Kleen for fragtimeout functionality
* Mon Nov 11 2002 ro@suse.de
- changed neededforbuild <xshared> to <x-devel-packages>
* Mon Nov 11 2002 ro@suse.de
- changed neededforbuild <sp> to <opensp>
* Sun Oct 20 2002 mmj@suse.de
- Add manpages, thanks to ASPLinux [#21115]
* Wed Aug 21 2002 mmj@suse.de
- Added a patch to exit when regular user tries to flush routes or
  addresses. [#16000]
* Sun Aug 18 2002 ro@suse.de
- added ghostscript-x11-packages to neededforbuild (for gs)
* Mon Apr  8 2002 postadal@suse.cz
- updated to ss020116
  * added several utilities several utilities: ss, nstat, ifstat,
    rtacct, arpd and module tcp_diag
* Thu Jan 31 2002 ro@suse.de
- changed neededforbuild <libpng> to <libpng-devel-packages>
* Thu Jan 31 2002 ro@suse.de
- added libgimpprint to neededforbuild
* Tue Jan 29 2002 vinil@suse.cz
- /usr/lib -> %%_libdir
* Sun Jan 20 2002 vinil@suse.cz
- new version ss010824
- spec file cleanup
* Mon Nov 19 2001 bjacke@suse.de
- move ip to /sbin
- add iproute2 config files to /etc/
* Wed Oct 10 2001 stepan@suse.de
- fix compilation on ia64
* Tue Sep 18 2001 pthomas@suse.de
- Correct spelling in libnetlink.3
- Add both German and English descriptions for libnlink
* Mon Aug 27 2001 kukuk@suse.de
- Fix compiling on SPARC
* Tue Aug 21 2001 vinil@suse.cz
- new version ss010803
- get rid of kernel 2.2 patches
* Thu Jul 26 2001 kukuk@suse.de
- add glib to needed for build
* Fri Jul 20 2001 kukuk@suse.de
- changed neededforbuild <gs_fonts> to <ghostscript-fonts-std>
- changed neededforbuild <gs_lib> to <ghostscript-library>
- changed neededforbuild <gs_x11> to <ghostscript-x11>
* Tue Jun 26 2001 ro@suse.de
- ETH_P_ECHO is apparently no longer defined
* Thu Mar  8 2001 uli@suse.de
- added xshared to neededforbuild
* Mon Mar  5 2001 kukuk@suse.de
- Remove bogus check for kernel header
* Fri Dec  1 2000 kukuk@suse.de
- Update to iproute2-2.2.4-now-ss001007 to fix compile problems
  with new kernel and glibc
* Mon Aug 28 2000 ak@suse.de
- fix permissions
- fix advmss/mtu confusion between 2.2 and 2.4 (advmss now works with 2.2
  kernels and is always enabled)
- add a new subrpm for libnetlink
- add libnetlink man page
* Tue Jul  4 2000 mha@suse.de
- new version (2.2.4-now-ss000305)
- new README.SuSE
- use ps2pdf instead of pdflatex, because the latter produces
  unusable pdf files for some reason
* Thu Jun  1 2000 vinil@suse.cz
- documentation enhancement
* Fri May 26 2000 vinil@suse.cz
- new version (ss000225)
- buildroot added
- sorted in group
* Thu Feb 17 2000 mha@suse.de
- new version (ss991023)
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Thu Jul 22 1999 mha@suse.de
- new version
- renamed package iproute->iproute2, because that's how the author
  calls it
* Tue Jul 13 1999 ro@suse.de
- added psutils to neededforbuild
* Sun Jul 11 1999 mha@suse.de
- new package: iproute (tools for using the advanced routing options
    in kernel 2.2)
