#
# spec file for package chrony
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%if 0%{?suse_version} < 1500
# As of 2021 we still need to be able to build this on SLE12
%bcond_with pools
%bcond_with sysusers
%bcond_with pps
%else
%bcond_without pools
%bcond_without sysusers
%bcond_without pps
%endif

%bcond_without testsuite

%define _systemdutildir %(pkg-config --variable systemdutildir systemd)
%global clknetsim_ver f89702d
#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir %{_localstatedir}/adm/fillup-templates
%endif
%define chrony_helper %{_libexecdir}/chrony/helper
Name:           chrony
Version:        4.1
Release:        150400.21.8.1
Summary:        System Clock Synchronization Client and Server
License:        GPL-2.0-only
Group:          Productivity/Networking/Other
URL:            https://chrony.tuxfamily.org/
Source:         https://download.tuxfamily.org/chrony/chrony-%{version}.tar.gz
Source2:        chronyd.sysconfig
Source3:        chrony.dhclient
Source4:        chrony.helper
Source5:        chrony-dnssrv@.service
Source6:        chrony-dnssrv@.timer
Source7:        https://download.tuxfamily.org/chrony/chrony-%{version}-tar-gz-asc.txt#/chrony-%{version}.tar.gz.sig
Source8:        chrony.keyring
# Simulator for test suite
Source10:       https://github.com/mlichvar/clknetsim/archive/%{clknetsim_ver}/clknetsim-%{clknetsim_ver}.tar.gz
Source11:       chrony-tmpfiles
Source12:       pool.conf.suse
Source13:       pool.conf.opensuse
Source14:       system-user-chrony.conf
Source99:       series
# PATCH-MISSING-TAG -- See http://wiki.opensuse.org/openSUSE:Packaging_Patches_guidelines
Patch0:         chrony-config.patch
# Add NTP servers from DHCP when starting service
Patch1:         chrony-service-helper.patch
Patch2:         chrony-logrotate.patch
Patch3:         chrony-service-ordering.patch
Patch4:         chrony-refid-internal-md5.patch
Patch5:         harden_chrony-wait.service.patch
Patch6:         harden_chronyd.service.patch
Patch7:         chrony-htonl.patch
Patch8:         chrony-burst_total_samples_to_go.patch
Patch9:         chrony-retry_interval_ke_start.patch
Patch10:        chrony-unix-socket.patch
Patch11:        chrony-remove-chmod.patch

BuildRequires:  NetworkManager-devel
BuildRequires:  bison
BuildRequires:  findutils
BuildRequires:  gcc-c++
BuildRequires:  gnutls-devel
BuildRequires:  libcap-devel
BuildRequires:  libedit-devel
BuildRequires:  pkgconfig
%if %{with pps}
BuildRequires:  pps-tools-devel
%endif
# The timezone package is needed for the "make check" tests. It can be
# removed if the call to make check is ever deleted.
BuildRequires:  sysuser-tools
BuildRequires:  timezone
BuildRequires:  pkgconfig(systemd)
Recommends:     logrotate
Requires(post): %fillup_prereq
%if %{with sysusers}
%sysusers_requires
%else
Requires(pre):  %{_sbindir}/useradd
%endif
%if %{with pools}
Requires:       %name-pool
Recommends:     %name-pool-nonempty
%endif
Provides:       ntp-daemon
%ifarch s390 s390x ppc64le
BuildRequires:  libseccomp-devel >= 2.2.0
%else
BuildRequires:  libseccomp-devel
%endif

%description
Chrony is an implementation of the Network Time Protocol (NTP). It can
synchronize the system clock with NTP servers, reference clocks (e.g. a
GPS receiver), and manual input using wristwatch and keyboard. It can
also operate as an NTPv4 (RFC 5905) server and peer to provide a time
service to other computers in the network.

Chrony consists of two programs: chronyd and chronyc.

Chronyd is a daemon which runs in the background on the system. It
obtains measurements of the system clock’s offset relative to time
servers on other systems via the network and adjusts the system time
accordingly. For isolated systems, the user can periodically enter the
correct time by hand (using chronyc). In either case, chronyd
determines the rate at which the computer gains or loses time, and
compensates for this. Chronyd can act as either a client or a server.

Chronyc provides a user interface to chronyd for monitoring its
performance and configuring various settings. It can do so while
running on the same computer as the chronyd instance it is controlling
or a different computer.

%if %{with pools}
%package pool-suse
Summary:        Chrony preconfiguration for SUSE
Group:          Productivity/Networking/Other
Provides:       %name-pool = %version
Provides:       %name-pool-nonempty
Conflicts:      %name-pool
Requires:       %name = %version
BuildArch:      noarch
Supplements:    (chrony and branding-SLE)
RemovePathPostfixes: .suse

%description pool-suse
This package configures chrony to use the SUSE NTP server pool by
default.

%package pool-openSUSE
Summary:        Chrony preconfiguration for openSUSE
Group:          Productivity/Networking/Other
Provides:       %name-pool = %version
Provides:       %name-pool-nonempty
Conflicts:      %name-pool
Requires:       %name = %version
BuildArch:      noarch
Supplements:    (chrony and branding-openSUSE)
RemovePathPostfixes: .opensuse

%description pool-openSUSE
This package configures chrony to use the openSUSE NTP server pool by
default.

%package pool-empty
Summary:        Empty pool preconfiguration for chrony
Group:          Productivity/Networking/Other
Provides:       %name-pool = %version
Conflicts:      %name-pool
Requires:       %name = %version
BuildArch:      noarch
RemovePathPostfixes: .empty

%description pool-empty
This package provides an empty /etc/chrony.d/pool.conf file for
situations when having servers preconfigured in chrony is undesirable,
e.g. because the servers will be set via DHCP.

%endif

%prep
%setup -q -a 10
%patch -P 0
%patch -P 1 -p1
%patch -P 2 -p1
%patch -P 3
%patch -P 4
%patch -P 5 -p1
%patch -P 6
%patch -P 7
%patch -P 8 -p1
%patch -P 9 -p1
%patch -P 10
%patch -P 11

# regenerate the file from getdate.y
rm -f getdate.c

mv clknetsim-%{clknetsim_ver}* test/simulation/clknetsim

%build
# not autoconf:
export CFLAGS="%{optflags} -Wall -fpic -DPIC $(pkg-config --cflags libseccomp)"
export LDFLAGS="-pie -Wl,-z,relro,-z,now"
%configure                                  \
  --docdir="%{_docdir}/%{name}"             \
  --enable-scfilter                         \
  --with-user=chrony                        \
  --with-hwclockfile=%{_sysconfdir}/adjtime \
  --with-sendmail=%{_sbindir}/sendmail      \
  --enable-ntp-signd
make %{?_smp_mflags} all
%if %{with sysusers}
%sysusers_generate_pre %{SOURCE14} chrony system-user-chrony.conf
%else
cat > chrony.pre <<EOF
%{_sbindir}/groupadd -r chrony >/dev/null 2>&1 || :
%{_sbindir}/useradd -g chrony -s /bin/false -r -c "Chrony Daemon" \
	-d "%{_localstatedir}/lib/chrony" chrony >/dev/null 2>&1 || :
EOF
%endif

%install
%make_install
install -Dpm 0644 examples/chrony.conf.example2 \
  %{buildroot}%{_sysconfdir}/chrony.conf
mkdir %{buildroot}%{_sysconfdir}/chrony.d
install -Dpm 0640 examples/chrony.keys.example \
  %{buildroot}%{_sysconfdir}/chrony.keys
install -Dpm 0755 examples/chrony.nm-dispatcher.onoffline \
  %{buildroot}%{_sysconfdir}/NetworkManager/dispatcher.d/20-chrony
install -Dpm 0755 %{SOURCE3} \
  %{buildroot}%{_sysconfdir}/dhcp/dhclient.d/chrony.sh
install -Dpm 0644 examples/chrony.logrotate \
  %{buildroot}%{_sysconfdir}/logrotate.d/chrony
install -Dpm 0644 examples/chronyd.service \
  %{buildroot}%{_unitdir}/chronyd.service
install -Dpm 0644 examples/chrony-wait.service \
  %{buildroot}%{_unitdir}/chrony-wait.service
install -Dpm 0644 %{SOURCE5} \
  %{buildroot}%{_unitdir}/chrony-dnssrv@.service
install -Dpm 0644 %{SOURCE6} \
  %{buildroot}%{_unitdir}/chrony-dnssrv@.timer
install -Dpm 0644 %{SOURCE11} \
  %{buildroot}%{_tmpfilesdir}/%{name}.conf

install -d %{buildroot}%{_sbindir}
ln -s %{_sbindir}/service %{buildroot}%{_sbindir}/rcchronyd
ln -s %{_sbindir}/service %{buildroot}%{_sbindir}/rcchrony-wait

install -d %{buildroot}%{_systemdutildir}/ntp-units.d
echo 'chronyd.service' > \
        %{buildroot}%{_systemdutildir}/ntp-units.d/50-chronyd.list

install -Dpm 0644 %{SOURCE2} \
  %{buildroot}%{_fillupdir}/sysconfig.chronyd
install -Dpm 755 %{SOURCE4} %{buildroot}%{chrony_helper}

install -d %{buildroot}%{_localstatedir}/log/chrony
touch %{buildroot}%{_localstatedir}/lib/chrony/{drift,rtc}

%if %{with pools}
# Install the NTP pool files
install -Dpm 644 %{SOURCE12} %{SOURCE13} %{buildroot}/etc/chrony.d
echo '# Add ntp pools here' > %{buildroot}/etc/chrony.d/pool.conf.empty
%endif

mkdir -p %{buildroot}%{_sysusersdir}
install -m 0644 %{SOURCE14} %{buildroot}%{_sysusersdir}/

find %{buildroot} -type f | xargs sed -i 's-@CHRONY_HELPER@-%{chrony_helper}-g'

%if %{with testsuite}
%ifnarch %ix86
%check
# Set random seed to get deterministic results
export CLKNETSIM_RANDOM_SEED=24501
export CFLAGS="%{optflags}"
make %{?_smp_mflags} -C test/simulation/clknetsim
make %{?_smp_mflags} quickcheck
%endif
%endif

%pre -f chrony.pre
%service_add_pre chronyd.service chrony-wait.service

%preun
%service_del_preun chronyd.service chrony-wait.service

%post
%fillup_only -n chronyd
%tmpfiles_create %{name}.conf
%service_add_post chronyd.service chrony-wait.service

%postun
%service_del_postun chronyd.service chrony-wait.service

%files
%defattr(-,root,root)
%if 0%{?suse_version} >= 1500
%license COPYING
%else
%doc COPYING
%endif
%doc FAQ NEWS README
%doc examples
%config(noreplace) %attr(0640,root,%{name}) %{_sysconfdir}/chrony.conf
%config(noreplace) %attr(0640,root,%{name}) %verify(not md5 size mtime) %{_sysconfdir}/chrony.keys
%config(noreplace) %{_sysconfdir}/logrotate.d/chrony
%{_sysconfdir}/NetworkManager/dispatcher.d/20-chrony
%dir %{_sysconfdir}/chrony.d/
%dir %{_sysconfdir}/dhcp/
%dir %{_sysconfdir}/dhcp/dhclient.d/
%{_sysconfdir}/dhcp/dhclient.d/chrony.sh
%{_sysusersdir}/system-user-chrony.conf
%{_bindir}/chronyc
%{_sbindir}/chronyd
%{_libexecdir}/%name
%{_mandir}/man1/chronyc.1%{?ext_man}
%{_mandir}/man5/chrony.conf.5%{?ext_man}
%{_mandir}/man8/chronyd.8%{?ext_man}
%{_systemdutildir}/ntp-units.d/*.list
%{_unitdir}/chrony*.service
%{_unitdir}/chrony*.timer
%{_sbindir}/rcchrony*
%{_tmpfilesdir}/%{name}.conf
%{_fillupdir}/sysconfig.chronyd
%dir %attr(750,chrony,chrony) %{_localstatedir}/lib/chrony
%ghost %attr(640,chrony,chrony) %{_localstatedir}/lib/chrony/drift
%ghost %attr(640,chrony,chrony) %{_localstatedir}/lib/chrony/rtc
%dir %attr(750,chrony,chrony) %{_localstatedir}/log/chrony
%ghost %attr(0750, %{name}, %{name}) %{_rundir}/%{name}

%if %{with pools}
%files pool-empty
%attr(-,root,root)%config (noreplace) /etc/chrony.d/pool.conf.empty

%files pool-suse
%attr(-,root,root)%config (noreplace) /etc/chrony.d/pool.conf.suse

%files pool-openSUSE
%attr(-,root,root)%config (noreplace) /etc/chrony.d/pool.conf.opensuse
%endif

%changelog
* Thu Sep 11 2025 max@suse.com
- bsc#1246544: Fix racy socket creation
  * Add chrony-unix-socket.patch
  * Add chrony-remove-chmod.patch
- Use make quickcheck to speedup build.
* Wed Apr 10 2024 max@suse.com
- Use make quickcheck instead of make check to avoid >1h build
  times and failures due to timeouts. This was the default before
  3.2 but it changed to make tests more reliable. Here a seed is
  already set to get deterministic execution.
* Fri Mar 15 2024 max@suse.com
- Use shorter NTS-KE retry interval when network is down
  (bsc#1213551, chrony-burst_total_samples_to_go.patch,
  chrony-retry_interval_ke_start.patch).
* Thu Mar 24 2022 max@suse.com
- Fix config file handling in the spec file and remove "ntsdumpdir"
  from default config, because augeas-lenses cannot parse it during
  installation of SLE Micro on SLE-15-SP3 (bsc#1194220).
* Mon Jan 10 2022 max@suse.com
- bsc#1194229: Fix pool package dependencies, so that SLE actually
  prefers chrony-pool-suse over chrony-pool-empty.
* Tue Dec  7 2021 max@suse.com
- Add chrony-htonl.patch to work around undocumented behaviour of
  htonl() in older glibc versions (SLE-12) on 64 bit big endian
  architectures (s390x).
* Fri Nov 19 2021 max@suse.com
- SLE bugs that have been fixed in openSUSE up to this point
  without explicit references: bsc#1183783, bsc#1184400,
  bsc#1171806, bsc#1161119, bsc#1159840.
- Obsoleted SLE patches:
  * chrony-fix-open.patch
  * chrony-gettimeofday.patch
  * chrony-ntp-era-split.patch
  * chrony-pidfile.patch
  * chrony-select-timeout.patch
  * chrony-urandom.patch
  * chrony.sysconfig
  * clknetsim-glibc-2.31.patch
* Fri Oct  8 2021 max@suse.com
- boo#1190926: PrivateDevices is too strict, we might need to
  access the rtc and ptp devices.
- Add back support to build chrony on SLE12.
- Drop dependency on asciidoctor. It is only needed for building
  the HTML documentation which we don't package anyway.
* Mon Aug 30 2021 jsegitz@suse.com
- Added hardening to systemd service(s). Added patch(es):
  * harden_chrony-wait.service.patch
  * harden_chronyd.service.patch
* Thu Jul  1 2021 max@suse.com
- boo#1187906: Consolidate all references to the helper script.
- bsc#1173760: MD5 is not available from mozilla-nss in FIPS mode,
  but needed for calculating refids from IPv6 addresses as part of
  the NTP protocol (rfc5905). As this is a non-cryptographic use of
  MD5 we can use our own implementation without violating FIPS
  rules: chrony-refid-internal-md5.patch .
* Sun Jun 13 2021 gmbr3@opensuse.org
- Add now working CONFIG parameter to sysusers generator
* Wed Jun  2 2021 gmbr3@opensuse.org
- Change to using systemd-sysusers
- Remove otherproviders, not needed anymore
* Tue Jun  1 2021 max@suse.com
- Update to 4.1
  * Add support for NTS servers specified by IP address (matching
    Subject Alternative Name in server certificate)
  * Add source-specific configuration of trusted certificates
  * Allow multiple files and directories with trusted certificates
  * Allow multiple pairs of server keys and certificates
  * Add copy option to server/pool directive
  * Increase PPS lock limit to 40%% of pulse interval
  * Perform source selection immediately after loading dump files
  * Reload dump files for addresses negotiated by NTS-KE server
  * Update seccomp filter and add less restrictive level
  * Restart ongoing name resolution on online command
  * Fix dump files to not include uncorrected offset
  * Fix initstepslew to accept time from own NTP clients
  * Reset NTP address and port when no longer negotiated by NTS-KE
    server
- Update clknetsim to snapshot f89702d.
- Refresh chrony.keyring from
  https://chrony.tuxfamily.org/gpgkey-8F375C7E8D0EE125A3D3BD51537E2B76F7680DAC.asc
- Ensure the correct pool packages are installed for openSUSE
  and SLE (bsc#1180689).
* Fri Feb  5 2021 max@suse.com
- Enable syscallfilter unconditionally [boo#1181826].
* Mon Dec  7 2020 mrueckert@suse.de
- drop buildrequires on NSS. We need gnutls for NTS anyway and we
  can do all the other required crypto via nettle+gnutls. no need
  for another crypto library.
* Sun Nov  1 2020 mrueckert@suse.de
- Update to 4.0
  - Enhancements
  - Add support for Network Time Security (NTS) authentication
  - Add support for AES-CMAC keys (AES128, AES256) with Nettle
  - Add authselectmode directive to control selection of
    unauthenticated sources
  - Add binddevice, bindacqdevice, bindcmddevice directives
  - Add confdir directive to better support fragmented
    configuration
  - Add sourcedir directive and "reload sources" command to
    support dynamic NTP sources specified in files
  - Add clockprecision directive
  - Add dscp directive to set Differentiated Services Code Point
    (DSCP)
  - Add -L option to limit log messages by severity
  - Add -p option to print whole configuration with included
    files
  - Add -U option to allow start under non-root user
  - Allow maxsamples to be set to 1 for faster update with -q/-Q
    option
  - Avoid replacing NTP sources with sources that have
    unreachable address
  - Improve pools to repeat name resolution to get "maxsources"
    sources
  - Improve source selection with trusted sources
  - Improve NTP loop test to prevent synchronisation to itself
  - Repeat iburst when NTP source is switched from offline state
    to online
  - Update clock synchronisation status and leap status more
    frequently
  - Update seccomp filter
  - Add "add pool" command
  - Add "reset sources" command to drop all measurements
  - Add authdata command to print details about NTP
    authentication
  - Add selectdata command to print details about source
    selection
  - Add -N option and sourcename command to print original names
    of sources
  - Add -a option to some commands to print also unresolved
    sources
  - Add -k, -p, -r options to clients command to select, limit,
    reset data
  - Bug fixes
  - Don’t set interface for NTP responses to allow asymmetric
    routing
  - Handle RTCs that don’t support interrupts
  - Respond to command requests with correct address on
    multihomed hosts
  - Removed features
  - Drop support for RIPEMD keys (RMD128, RMD160, RMD256, RMD320)
  - Drop support for long (non-standard) MACs in NTPv4 packets
    (chrony 2.x clients using non-MD5/SHA1 keys need to use
    option "version 3")
  - Drop support for line editing with GNU Readline
- add BuildRequires for gnutls-devel (which also pulls nettle to
  enable the new features)
- drop patches which are included in the update:
  chrony-test-update-processing-of-packet-log.patch
  chrony-test-fix-util-unit-test-for-NTP-era-split.patch
- refreshed chrony-config.patch
- track series file for easier quilt setup
- added option to turn off testsuite with
  osc build --without=testsuite
  testsuite still runs by default
* Wed Oct 28 2020 kukuk@suse.com
- By default we don't write log files but log to journald, so
  only recommend logrotate.
* Mon Sep 14 2020 max@suse.com
- Adjust and rename the sysconfig file, so that it matches the
  expectations of chronyd.service (bsc#1173277).
* Sun Sep 13 2020 elimat@opensuse.org
- Update to 3.5.1:
  * Create new file when writing pidfile (CVE-2020-14367, bsc#1174911)
* Sun Aug  2 2020 callumjfarmer13@gmail.com
- Fixes for %%_libexecdir changing to /usr/libexec (bsc#1174075)
* Thu Jun  4 2020 max@suse.com
- Add chrony-pool-suse and chrony-pool-openSUSE subpackages that
  preconfigure chrony to use NTP servers from the  respective
  pools for SUSE and openSUSE (bsc#1156884, SLE-11424).
- Add chrony-pool-empty to still allow installing chrony without
  preconfigured servers.
- Use iburst in the default pool statements to speed up initial
  synchronisation (bsc#1172113).
* Thu Apr 30 2020 dimstar@opensuse.org
- Use _systemdutildir instead of _libexecdir/systemd: systemd does
  not actually live below libexecdir.
* Thu Feb 13 2020 mliska@suse.cz
- Add chrony-test-update-processing-of-packet-log.patch in order
  to fix test-suite failure.
* Wed Feb 12 2020 mliska@suse.cz
- Update clknetsim to version 79ffe44 (fixes boo#1162964).
- Backport chrony-test-fix-util-unit-test-for-NTP-era-split.patch.
* Sat Oct 26 2019 suse+build@de-korte.org
- Change to BuildRequires: rubygem(asciidoctor) and remove conditional
  (is available in SLE12-SP4 and SLE15* as well)
- Fix typo in %%install
* Tue Oct 22 2019 suse+build@de-korte.org
- Fix asciidoc in Tumbleweed
- Revert clknetsim to version 58c5e8b
* Tue Oct 22 2019 suse+build@de-korte.org
- Fix incorrect download link for package signature
* Mon Oct 21 2019 mpluskal@suse.com
- Temporarily disable signature usage as its expired
- Update clknetsim to version ac3c832
* Sat Oct 19 2019 Mathias.Homann@opensuse.org
- fix chrony-service-helper.patch
* Sat Oct 19 2019 Mathias.Homann@opensuse.org
- Update to 3.5:
  + Add support for more accurate reading of PHC on Linux 5.0
  + Add support for hardware timestamping on interfaces with read-only timestamping configuration
  + Add support for memory locking and real-time priority on FreeBSD, NetBSD, Solaris
  + Update seccomp filter to work on more architectures
  + Validate refclock driver options
  + Fix bindaddress directive on FreeBSD
  + Fix transposition of hardware RX timestamp on Linux 4.13 and later
  + Fix building on non-glibc systems
* Thu Mar 21 2019 max@suse.com
- Fix ordering and dependencies of chronyd.service, so that it is
  started after name resolution is up (bsc#1129914).
- Add chrony-service-ordering.patch
- Fix location of helper script in chrony-dnssrv@.service
  (bsc#1128846).
* Wed Mar  6 2019 mpluskal@suse.com
- Update testsuite to version 58c5e8b
* Thu Dec 20 2018 max@suse.com
- Read runtime servers from /var/run/netconfig/chrony.servers to
  fix bsc#1099272.
- Move chrony-helper to /usr/lib/chrony/helper, because there
  should be no executables in /usr/share.
* Fri Dec 14 2018 mpluskal@suse.com
- Make sure to generate correct sysconfig file (boo#1117147)
- Update clknetsim to revision 8b48422
* Thu Nov 22 2018 mpluskal@suse.com
- Remove discrepancies between spec file and chrony-tmpfiles (boo#1115529)
* Thu Oct 18 2018 idonmez@suse.com
- Update the keyring and uncomment it in the spec file
* Thu Oct 18 2018 mpluskal@suse.com
- Comment out bad signature
* Wed Sep 19 2018 michael@stroeder.com
- Added %%{_tmpfilesdir}/%%{name}.conf
- Updated clknetsim
- Update to version 3.4
  * Enhancements
    + Add filter option to server/pool/peer directive
    + Add minsamples and maxsamples options to hwtimestamp directive
    + Add support for faster frequency adjustments in Linux 4.19
    + Change default pidfile to /var/run/chrony/chronyd.pid to allow chronyd
    without root privileges to remove it on exit
    + Disable sub-second polling intervals for distant NTP sources
    + Extend range of supported sub-second polling intervals
    + Get/set IPv4 destination/source address of NTP packets on FreeBSD
    + Make burst options and command useful with short polling intervals
    + Modify auto_offline option to activate when sending request failed
    + Respond from interface that received NTP request if possible
    + Add onoffline command to switch between online and offline state
    according to current system network configuration
    + Improve example NetworkManager dispatcher script
  * Bug fixes
    + Avoid waiting in Linux getrandom system call
    + Fix PPS support on FreeBSD and NetBSD
* Fri Aug  3 2018 mpluskal@suse.com
- Update clknetsim to revision 42b693b
  * Drop not needed chrony-fix-open.patch
- Build tests with optflags as well
- Do not run tests on i586
- Enable signd
* Thu Aug  2 2018 mpluskal@suse.com
- Mention all sources as such in spec file
- Fix formatting of changelog
- Drop reference to change is not present
* Wed Aug  1 2018 bwiedemann@suse.com
- Update to version 3.3
  * Enhancements:
    + Add burst option to server/pool directive
    + Add stratum and tai options to refclock directive
    + Add support for Nettle crypto library
    + Add workaround for missing kernel receive timestamps on Linux
    + Wait for late hardware transmit timestamps
    + Improve source selection with unreachable sources
    + Improve protection against replay attacks on symmetric mode
    + Allow PHC refclock to use socket in /var/run/chrony
    + Add shutdown command to stop chronyd
    + Simplify format of response to manual list command
    + Improve handling of unknown responses in chronyc
  * Bug fixes:
    + Respond to NTPv1 client requests with zero mode
    + Fix -x option to not require CAP_SYS_TIME under non-root user
    + Fix acquisitionport directive to work with privilege separation
    + Fix handling of socket errors on Linux to avoid high CPU usage
    + Fix chronyc to not get stuck in infinite loop after clock step
* Wed Apr 18 2018 mpost@suse.com
- Added /etc/chrony.d/ directory to the package (bsc#1083597)
  Modifed default chrony.conf to add "include /etc/chrony.d/*"
* Mon Mar 26 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Wed Mar 14 2018 kukuk@suse.de
- Fix name of fillup template (was never installed before)
- Fix Requires for fillup, it's used in post, not pre.
* Fri Feb  9 2018 mpluskal@suse.com
- Enable pps support
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Thu Oct 26 2017 mpluskal@suse.com
- Cleanup spec file:
  * Drop pre systemd support
  * Run spec-cleaner
* Tue Oct 24 2017 mpost@suse.com
- Modified the spec file to comment out the pool statement
  in chrony.conf if _not_ building for openSUSE. (bsc#1063704).
* Thu Sep 28 2017 mrueckert@suse.de
- refresh patches to apply cleanly again
  - chrony-config.patch
  - chrony-fix-open.patch
* Wed Sep 20 2017 mpost@suse.com
- Upgraded to version 3.2:
  Enhancements
  * Improve stability with NTP sources and reference clocks
  * Improve stability with hardware timestamping
  * Improve support for NTP interleaved modes
  * Control frequency of system clock on macOS 10.13 and later
  * Set TAI-UTC offset of system clock with leapsectz directive
  * Minimise data in client requests to improve privacy
  * Allow transmit-only hardware timestamping
  * Add support for new timestamping options introduced in Linux 4.13
  * Add root delay, root dispersion and maximum error to tracking log
  * Add mindelay and asymmetry options to server/peer/pool directive
  * Add extpps option to PHC refclock to timestamp external PPS signal
  * Add pps option to refclock directive to treat any refclock as PPS
  * Add width option to refclock directive to filter wrong pulse edges
  * Add rxfilter option to hwtimestamp directive
  * Add -x option to disable control of system clock
  * Add -l option to log to specified file instead of syslog
  * Allow multiple command-line options to be specified together
  * Allow starting without root privileges with -Q option
  * Update seccomp filter for new glibc versions
  * Dump history on exit by default with dumpdir directive
  * Use hardening compiler options by default
  Bug fixes
  * Don't drop PHC samples with low-resolution system clock
  * Ignore outliers in PHC tracking, RTC tracking, manual input
  * Increase polling interval when peer is not responding
  * Exit with error message when include directive fails
  * Don't allow slash after hostname in allow/deny directive/command
  * Try to connect to all addresses in chronyc before giving up
- Upgraded clknetsim to version 71dbbc5.
- Reworked chrony-fix-open.patch to fit the new version
* Tue Jan 31 2017 mpost@suse.com
- Upgraded to version 3.1:
  - Enhancements
  - Add support for precise cross timestamping of PHC on Linux
  - Add minpoll, precision, nocrossts options to hwtimestamp directive
  - Add rawmeasurements option to log directive and modify measurements
    option to log only valid measurements from synchronised sources
  - Allow sub-second polling interval with NTP sources
  - Bug fixes
  - Fix time smoothing in interleaved mode
- Upgraded clknetsim to version ce89a1b.
- Reworked the following patches to fit the new versions
  - chrony-config.patch
  - chrony-service-helper.patch
  - chrony-fix-open.patch
* Mon Jan 16 2017 mpost@suse.com
- Upgraded to version 3.0:
  - Enhancements
  - Add support for software and hardware timestamping on Linux
  - Add support for client/server and symmetric interleaved modes
  - Add support for MS-SNTP authentication in Samba
  - Add support for truncated MACs in NTPv4 packets
  - Estimate and correct for asymmetric network jitter
  - Increase default minsamples and polltarget to improve stability with very low jitter
  - Add maxjitter directive to limit source selection by jitter
  - Add offset option to server/pool/peer directive
  - Add maxlockage option to refclock directive
  - Add -t option to chronyd to exit after specified time
  - Add partial protection against replay attacks on symmetric mode
  - Don't reset polling interval when switching sources to online state
  - Allow rate limiting with very short intervals
  - Improve maximum server throughput on Linux and NetBSD
  - Remove dump files after start
  - Add tab-completion to chronyc with libedit/readline
  - Add ntpdata command to print details about NTP measurements
  - Allow all source options to be set in add server/peer command
  - Indicate truncated addresses/hostnames in chronyc output
  - Print reference IDs as hexadecimal numbers to avoid confusion with IPv4 addresses
  - Bug fixes
  - Fix crash with disabled asynchronous name resolving
- Upgraded clknetsim to version 6bb6519.
* Tue Nov 29 2016 mpost@suse.com
- Upgraded to version 2.4.1:
  - Bug fixes
  - Fix processing of kernel timestamps on non-Linux systems
  - Fix crash with smoothtime directive
  - Fix validation of refclock sample times
  - Fix parsing of refclock directive
* Wed Jun  8 2016 mrueckert@suse.de
- update to 2.4:
  - Enhancements
  - Add orphan option to local directive for orphan mode
    compatible with ntpd
  - Add distance option to local directive to set activation
    threshold (1 second by default)
  - Add maxdrift directive to set maximum allowed drift of system
    clock
  - Try to replace NTP sources exceeding maximum distance
  - Randomise source replacement to avoid getting stuck with bad
    sources
  - Randomise selection of sources from pools on start
  - Ignore reference timestamp as ntpd doesn't always set it
    correctly
  - Modify tracking report to use same values as seen by NTP
    clients
  - Add -c option to chronyc to write reports in CSV format
  - Provide detailed manual pages
  - Bug fixes
  - Fix SOCK refclock to work correctly when not specified as
    last refclock
  - Fix initstepslew and -q/-Q options to accept time from own
    NTP clients
  - Fix authentication with keys using 512-bit hash functions
  - Fix crash on exit when multiple signals are received
  - Fix conversion of very small floating-point numbers in
    command packets
  - Removed features
  - Drop documentation in Texinfo format
- update clknetsim to a5949fe for fixing a testsuite failure:
  - add IP_PKTINFO socket option
  - accept environment variables in make
  - fix building with FORTIFY_SOURCE
  - fix compiler warning
  - support multiple SHM refclocks
  - fix recv functions with new glibc headers
- refreshed chrony-fix-open.patch: to apply cleanly after clknetsim
  update
- drop patches:
  - chrony-include-termios.patch
  - make-105-ntpauth-more-reliable.patch
- drop buildrequires for texinfo and pre requires on the install
  info packages
- no longer use make install-docs: it only installed 0 byte html
  files.
* Wed Apr 13 2016 mpluskal@suse.com
- Provide ntp-daemon (bsc#973981)
* Mon Apr 11 2016 meissner@suse.com
- chrony-fix-open.patch: make sure _open and _close are initialized
  in open()/close() override, as libfreebl3 also calls from the
  the ELF constructor. FATE#319508
- enable mozilla-nss
* Fri Apr  8 2016 mpluskal@suse.com
- Use correct license
- Drop hardcoded dependency on libseccomp, it is detected during
  build
* Fri Apr  8 2016 mpluskal@suse.com
- Undo reference to chrony-dnssrv@.service in %%pre, %%preun, %%post,
  and %%postun as it would lead to error.
- Change conditions for libseccom, we can use any version on SLE-12
  x86_64
* Tue Apr  5 2016 mpost@suse.com
- Removed %%if for distributions that aren't building chrony.
- Renamed chrony-2.2_logrotate.patch to chrony-logrotate.patch since
  the patch is not particularly version-dependent.
- Added clknetsim for "make check" processing.
- Added Buildrequires for gcc-c++ and timezone for building clknetsim
  and running "make check".
- Changed Buildrequires and Requires to specify the minimum level of
  libseccomp needed to build on s390x and ppc64le.
- Removed "-Recommends: timedatex" since I couldn't find any instance
  of it anywhere in the build service.
- Modified the description to use some of the information from the
  chrony web site.
- Added chrony-include-termios.patch so that it will build on ppc64le.
- Added make-105-ntpauth-more-reliable.patch so that "make check"
  will not report a non-failure as a failure.
- Added --without-nss to ./configure to avoid "interruption code
  0x2003B in chronyd" errors.
- Changed the symbolic links for rcchronyd and rcchronyd-wait to
  point to the actual location of the service command, not the symlink
  in /sbin.
- Added reference to chrony-dnssrv@.service in %%pre, %%preun, %%post,
  and %%postun.
* Mon Mar 28 2016 mpluskal@suse.com
- Cleanup spec file with spec-cleaner
- Prepare for submission to Factory (see fate#319508)
* Thu Feb 18 2016 mrueckert@suse.de
- update to 2.3
  - Enhancements
  - Add support for NTP and command response rate limiting
  - Add support for dropping root privileges on Mac OS X,
    FreeBSD, Solaris
  - Add require and trust options for source selection
  - Enable logchange by default (1 second threshold)
  - Set RTC on Mac OS X with rtcsync directive
  - Allow binding to NTP port after dropping root privileges on
    NetBSD
  - Drop CAP_NET_BIND_SERVICE capability on Linux when NTP port
    is disabled
  - Resolve names in separate process when seccomp filter is
    enabled
  - Replace old records in client log when memory limit is
    reached
  - Don't reveal local time and synchronisation state in client
    packets
  - Don't keep client sockets open for longer than necessary
  - Ignore poll in KoD RATE packets as ntpd doesn't always set it
    correctly
  - Warn when using keys shorter than 80 bits
  - Add keygen command to generate random keys easily
  - Add serverstats command to report NTP and command packet
    statistics
  - Bug fixes
  - Fix clock correction after making step on Mac OS X
  - Fix building on Solaris
- refreshed patches to apply cleanly again:
  chrony-2.2_logrotate.patch
  chrony-config.patch
  chrony-service-helper.patch
* Fri Jan 29 2016 mrueckert@suse.de
- update to 2.2.1
  Restrict authentication of NTP server/peer to specified key
  (CVE-2016-1567)
* Thu Nov 26 2015 mrueckert@suse.de
- silence groupadd/useradd call and drop the shell from the user.
* Thu Nov 26 2015 mrueckert@suse.de
- update to 2.2
  see /usr/share/doc/packages/chrony/NEWS
- sync with fedora spec and add systemd support
- refreshed chrony-config.patch to apply cleanly again
- added chrony-2.2_logrotate.patch: add missing su option as we no
  longer have the daemon run as root.
- added chrony-service-helper.patch: imported from fedora with a
  changed path for moving from libexecdir to datadir
- only use syscall filters on 12.3 and newer
- move helper from libexecdir to datadir
* Mon Feb 24 2014 mrueckert@suse.de
- clean up build section
  - the configure script can actually import CC/CFLAGS from the
    environment. no need to break any CFLAGS it might set in the
    configure script.
  - remove unneeded prefix from the make calls.
  - enable building the binaries with PIE/relro now
* Mon Feb 24 2014 mrueckert@suse.de
- Update to version 1.29.1:
  * Modify chronyc protocol to prevent amplification attacks
    (CVE-2014-0021) (incompatible with previous protocol version,
    chronyc supports both)
- Additional changes from 1.29
  * Fix crash when processing crafted commands (CVE-2012-4502)
    (possible with IP addresses allowed by cmdallow and localhost)
  * Don't send uninitialized data in SUBNETS_ACCESSED and
    CLIENT_ACCESSES replies (CVE-2012-4503) (not used by chronyc)
  * Drop support for SUBNETS_ACCESSED and CLIENT_ACCESSES commands
- Additional changes from 1.28
  * Combine sources to improve accuracy
  * Make config and command parser strict
  * Add -a option to chronyc to authenticate automatically
  * Add -R option to ignore initstepslew and makestep directives
  * Add generatecommandkey, minsamples, maxsamples and user
    directives
  * Improve compatibility with NTPv1 and NTPv2 clients
  * Create sockets only in selected family with -4/-6 option
  * Treat address bind errors as non-fatal
  * Extend tracking log
  * Accept float values as initstepslew threshold
  * Allow hostnames in offline, online and burst commands
  * Fix and improve peer polling
  * Fix crash in config parsing with too many servers
  * Fix crash with duplicated initstepslew address
  * Fix delta calculation with extreme frequency offsets
  * Set local stratum correctly
  * Remove unnecessary adjtimex calls
  * Set paths in documentation by configure
  * Update chrony.spec
- Updated chrony-config.patch:
  - lots of config values were fixed upstream already
  - key file patching is unnecessary
* Sat Jul 13 2013 zaitor@opensuse.org
- Update to version 1.27:
  + Added support for stronger authentication keys via NSS or
    libtomcrypt library.
  + Extended tracking, sources and activity reports printed by
    chronyc.
  + The daemon now waits in foreground until it is fully
    initialized.
  + Other bug fixes and improvements.
- Add mozilla-nss-devel & pkg-config BuildRequires, new optional
  dependencys.
* Fri Jan 11 2013 mrdocs@opensuse.org
-run spec-cleaner on the spec file, fix license and remove cruft
* Tue Nov 29 2011 aj@suse.de
- Update to version 1.26:
  * Added compatibility with Linux 3.0 and later
  * Fixed replying on multihomed IPv6 hosts
  * Other minor bug fixes and improvements
- Cleanup package a bit.
