/*
 * Copyright 2013-2024 The OpenZipkin Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package brave.propagation;

import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig.SingleBaggageField;
import brave.internal.Nullable;
import brave.propagation.TraceContext.Extractor;
import brave.propagation.TraceContext.Injector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import static java.util.Collections.unmodifiableList;

/** @deprecated Since 5.11 use {@link BaggagePropagation} */
@Deprecated public class ExtraFieldPropagation<K> implements Propagation<K> {
  /** @deprecated Since 5.11 use {@link BaggagePropagation#newFactoryBuilder(Propagation.Factory)} */
  @Deprecated public static Factory newFactory(Propagation.Factory delegate, String... names) {
    if (delegate == null) throw new NullPointerException("delegate == null");
    if (names == null) throw new NullPointerException("names == null");
    return newFactory(delegate, Arrays.asList(names));
  }

  /** @deprecated Since 5.11 use {@link BaggagePropagation#newFactoryBuilder(Propagation.Factory)} */
  @Deprecated public static Factory newFactory(Propagation.Factory delegate,
    Collection<String> names) {
    if (delegate == null) throw new NullPointerException("delegate == null");
    if (names == null) throw new NullPointerException("field names == null");
    if (names.isEmpty()) throw new IllegalArgumentException("no field names");
    FactoryBuilder builder = new FactoryBuilder(delegate);
    for (String name : names) builder.addField(name);
    return builder.build();
  }

  /** @deprecated Since 5.11 use {@link BaggagePropagation#newFactoryBuilder(Propagation.Factory)} */
  @Deprecated public static FactoryBuilder newFactoryBuilder(Propagation.Factory delegate) {
    return new FactoryBuilder(delegate);
  }

  /** @deprecated Since 5.11 use {@link BaggagePropagation.FactoryBuilder} */
  @Deprecated public static final class FactoryBuilder {
    final Propagation.Factory delegate;
    final BaggagePropagation.FactoryBuilder baggageFactory;
    // Updates could be out-of-order in the old impl, so we track everything until build()
    final Set<String> redactedNames = new LinkedHashSet<String>();
    final Map<String, Set<String>> nameToKeyNames = new LinkedHashMap<String, Set<String>>();

    FactoryBuilder(Propagation.Factory delegate) {
      this.delegate = delegate;
      this.baggageFactory = BaggagePropagation.newFactoryBuilder(delegate);
    }

    /** @deprecated Since 5.11, use {@link SingleBaggageField#local(BaggageField)} */
    @Deprecated public FactoryBuilder addRedactedField(String fieldName) {
      fieldName = validateFieldName(fieldName);
      redactedNames.add(fieldName);
      nameToKeyNames.put(fieldName, Collections.<String>emptySet());
      return this;
    }

    /** @deprecated Since 5.11, use {@link SingleBaggageField#remote(BaggageField)} */
    @Deprecated public FactoryBuilder addField(String fieldName) {
      fieldName = validateFieldName(fieldName);
      addKeyName(fieldName, fieldName);
      return this;
    }

    /** @deprecated Since 5.11, use {@link SingleBaggageField.Builder#addKeyName(String)} */
    @Deprecated public FactoryBuilder addPrefixedFields(String prefix, Collection<String> names) {
      if (prefix == null) throw new NullPointerException("prefix == null");
      prefix = validateFieldName(prefix);
      if (names == null) throw new NullPointerException("names == null");
      for (String name : names) {
        name = validateFieldName(name);
        addKeyName(name, prefix + name);
      }
      return this;
    }

    void addKeyName(String name, String keyName) {
      Set<String> keyNames = nameToKeyNames.get(name);
      if (keyNames == null) nameToKeyNames.put(name, keyNames = new LinkedHashSet<String>());
      keyNames.add(keyName);
    }

    /** Returns a wrapper of the delegate if there are no fields to propagate. */
    public Factory build() {
      Set<String> extraKeyNames = new LinkedHashSet<String>();
      for (Map.Entry<String, Set<String>> entry : nameToKeyNames.entrySet()) {
        BaggageField field = BaggageField.create(entry.getKey());
        if (redactedNames.contains(field.name())) {
          baggageFactory.add(SingleBaggageField.local(field));
        } else {
          extraKeyNames.addAll(entry.getValue());
          SingleBaggageField.Builder builder = SingleBaggageField.newBuilder(field);
          for (String keyName : entry.getValue()) {
            builder.addKeyName(keyName);
          }
          baggageFactory.add(builder.build());
        }
      }
      return new Factory(baggageFactory.build(), extraKeyNames.toArray(new String[0]));
    }
  }

  /**
   * @deprecated Since 5.11 use {@link BaggageField#getByName(String)} and {@link
   * BaggageField#getValue()}
   */
  @Deprecated @Nullable public static String current(String name) {
    return get(name);
  }

  /**
   * @deprecated Since 5.11 use {@link BaggageField#getByName(String)} and {@link
   * BaggageField#getValue()}
   */
  @Deprecated @Nullable public static String get(String name) {
    BaggageField field = BaggageField.getByName(validateFieldName(name));
    if (field == null) return null;
    return field.getValue();
  }

  /**
   * @deprecated Since 5.11 use {@link BaggageField#getByName(String)} and {@link
   * BaggageField#updateValue(String)}
   */
  @Deprecated public static void set(String name, String value) {
    BaggageField field = BaggageField.getByName(validateFieldName(name));
    if (field == null) return;
    field.updateValue(value);
  }

  /** @deprecated Since 5.11 use {@link BaggageField#getAll()} */
  @Deprecated public static Map<String, String> getAll() {
    return BaggageField.getAllValues();
  }

  /** @deprecated Since 5.11 use {@link BaggageField#getAll(TraceContextOrSamplingFlags)} */
  @Deprecated public static Map<String, String> getAll(TraceContextOrSamplingFlags extracted) {
    if (extracted.context() != null) return getAll(extracted.context());
    return BaggageField.getAllValues(extracted);
  }

  /** @deprecated Since 5.11 use {@link BaggageField#getAll(TraceContext)} */
  @Deprecated public static Map<String, String> getAll(TraceContext context) {
    return BaggageField.getAllValues(context);
  }

  /**
   * @deprecated Since 5.11 use {@link BaggageField#getByName(TraceContext, String)} and {@link
   * BaggageField#getValue(TraceContext)}
   */
  @Deprecated @Nullable public static String get(TraceContext context, String name) {
    BaggageField field = BaggageField.getByName(context, validateFieldName(name));
    if (field == null) return null;
    return field.getValue(context);
  }

  /**
   * @deprecated Since 5.11 use {@link BaggageField#getByName(TraceContext, String)} and {@link
   * BaggageField#updateValue(String)}
   */
  @Deprecated public static void set(TraceContext context, String name, String value) {
    BaggageField field = BaggageField.getByName(context, validateFieldName(name));
    if (field == null) return;
    field.updateValue(context, value);
  }

  /** @deprecated Since 5.11 use {@link Propagation.Factory} */
  public static class Factory extends Propagation.Factory {
    final Propagation.Factory delegate;
    final List<String> extraKeyNames;

    Factory(Propagation.Factory delegate, String[] extraKeyNames) {
      this.delegate = delegate;
      this.extraKeyNames = unmodifiableList(Arrays.asList(extraKeyNames));
    }

    /** {@inheritDoc} */
    @Override public ExtraFieldPropagation<String> get() {
      return new ExtraFieldPropagation<String>(delegate.get(), extraKeyNames);
    }

    @Override public boolean supportsJoin() {
      return delegate.supportsJoin();
    }

    @Override public boolean requires128BitTraceId() {
      return delegate.requires128BitTraceId();
    }

    @Override public TraceContext decorate(TraceContext context) {
      return delegate.decorate(context);
    }
  }

  final Propagation<K> delegate;
  final List<K> extraKeys;

  ExtraFieldPropagation(Propagation<K> delegate, List<K> extraKeys) {
    this.delegate = delegate;
    this.extraKeys = extraKeys;
  }

  /** @deprecated Since 5.12 use {@link BaggagePropagation#allKeyNames(Propagation)} instead. */
  @Deprecated public List<K> extraKeys() {
    return extraKeys;
  }

  /**
   * Only returns trace context keys. Extra field names are not returned to ensure tools don't
   * delete them. This is to support users accessing extra fields without Brave apis (ex via
   * headers).
   */
  @Override public List<K> keys() {
    return delegate.keys();
  }

  @Override public <R> Injector<R> injector(Setter<R, K> setter) {
    return delegate.injector(setter);
  }

  @Override public <R> Extractor<R> extractor(Getter<R, K> getter) {
    return delegate.extractor(getter);
  }

  static String validateFieldName(String fieldName) {
    if (fieldName == null) throw new NullPointerException("fieldName == null");
    fieldName = fieldName.toLowerCase(Locale.ROOT).trim();
    if (fieldName.isEmpty()) throw new IllegalArgumentException("fieldName is empty");
    return fieldName;
  }
}
