#
# spec file for package libproxy
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define flavor client%nil
%if "%{flavor}" == ""
ExclusiveArch:  do-not-build
%else
%if "%{flavor}" == "client"
  %define name_suffix %{flavor}
  %define dash -
  %define mini -mini
%else
  %define name_suffix %{flavor}
  %define dash -
%endif
%endif

%define _name   libproxy
Name:           libproxy%{?dash}%{?name_suffix}
Version:        0.5.3
Release:        150600.4.6.2
Summary:        Automatic proxy configuration management for applications
License:        GPL-2.0-or-later AND LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
URL:            http://libproxy.github.io/libproxy/
Source:         https://github.com/libproxy/libproxy/archive/refs/tags/%{version}.tar.gz
Source99:       baselibs.conf

# PATCH-FIX-UPSTREAM libproxy-sysconfig-Remove-white-space.patch bsc#1228999 xwang@suse.com -- Remove white space in key value
Patch1:         libproxy-sysconfig-Remove-white-space.patch
# PATCH-FIX-UPSTREAM libproxy-ignore-invalid-uri.patch bsc#1235097 alynx.zhou@suse.com -- Ignore invalid proxy URIs
Patch2:         libproxy-ignore-invalid-uri.patch
# PATCH-FIX-UPSTREAM libproxy-handle-empty-proxy-ignore-entry.patch bsc#1234940 xwang@suse.com -- Properly handle empty proxy ignore entry
Patch3:         libproxy-handle-empty-proxy-ignore-entry.patch

BuildRequires:  meson
BuildRequires:  sysuser-tools
BuildRequires:  vala
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gobject-introspection-1.0)
%if "%{flavor}" == "backend"
BuildRequires:  pkgconfig(duktape)
BuildRequires:  pkgconfig(gi-docgen)
BuildRequires:  pkgconfig(gsettings-desktop-schemas)
BuildRequires:  pkgconfig(libcurl)
#!BuildIgnore:  libproxy1
# We require a config module, at worst the env reader
Requires:       PxPlugin(config)
# the env reader is part of this package
Provides:       PxPlugin(config)
# If pac/wpad is used, we need to interpret it
Recommends:     PxPlugin(pacrunner)
# config plugins envvar and sysconfig are shipped with the daemon
Provides:       PxPlugin(config)
%endif

%description
libproxy is a library that provides automatic proxy configuration
management.

%package -n libproxy-tools
Summary:        An example application using libproxy
Group:          System/Libraries
Requires:       libproxy1 = %{version}

%description -n libproxy-tools
An example application that will use libproxy to give the results that can
be expected from other applications. It can be used to debug what would
happen in various cases.

%package -n libproxy-devel
Summary:        Development files for libproxy, a library to do PAC/WPAD
Group:          Development/Libraries/C and C++
Requires:       libproxy1 = %{version}

%description -n libproxy-devel
libproxy is a library that provides automatic proxy configuration
management.

This subpackage contains header files for developing applications
that want to make use of libproxy.

%package -n libproxy-devel-doc
Summary:        Libproxy developers documentation
BuildArch:      noarch

%description -n libproxy-devel-doc
The developers documentation to libproxy (consumer library)

%package -n libproxy1
Summary:        Automatic proxy configuration management for applications
Group:          System/Libraries
# Starting with version 0.5.0, libproxy, the client library, has no plugins
# all plugins are moved to the backend
Obsoletes:      libproxy1-config-gnome3 < 0.5
Obsoletes:      libproxy1-config-kde < 0.5
Obsoletes:      libproxy1-networkmanager < 0.5
Obsoletes:      libproxy1-pacrunner-duktape < 0.5
Obsoletes:      libproxy1-pacrunner-webkit < 0.5

%description -n libproxy1
libproxy is a library that provides automatic proxy configuration
management.

Proxy autoconfiguration (PAC) requires JavaScript (which most
applications do not have), and determing the PAC script location
requires a WPAD protocol implementation, which complicates proxy
support. libproxy exists to abstract this issue and provides
an answer how to reach a certain network resource.

%package -n libpxbackend-1_0%{?mini}
Summary:        Backend library for libproxy, handles plugin loading
Group:          System/Libraries
%if "%{flavor}" == "client"
Conflicts:      libpxbackend-1_0
Requires:       this-is-only-for-build-envs
%endif

%description -n libpxbackend-1_0%{?mini}
libproxy is a library that provides automatic proxy configuration
management.

Proxy autoconfiguration (PAC) requires JavaScript (which most
applications do not have), and determing the PAC script location
requires a WPAD protocol implementation, which complicates proxy
support. libproxy exists to abstract this issue and provides
an answer how to reach a certain network resource.

%package -n typelib-1_0-Libproxy-1_0
Summary:        Gobject introspected access to libproxy

%description -n typelib-1_0-Libproxy-1_0
Libproxy is using gobject-introspection and is thus usable
from a wide range of programming languages.

%prep
%autosetup -p1 -n %{_name}-%{version}

%build
%meson \
%if "%{flavor}" == "client"
  -Dcurl=false \
  -Dconfig-gnome=false \
  -Dpacrunner-duktape=false \
  -Ddocs=false \
  -Dtests=false \
%endif
%nil
%meson_build

%install
%meson_install

%if "%{flavor}" == "backend"
# this stuff is already shipped as part of the client library (built without cURL to break cycles)
rm      %{buildroot}%{_bindir}/proxy
rm      %{buildroot}%{_mandir}/man8/proxy*
rm      %{buildroot}%{_libdir}/libproxy.so*
rm      %{buildroot}%{_libdir}/girepository-1.0/Libproxy*.typelib
rm -rf  %{buildroot}%{_includedir}/libproxy
rm -rf  %{buildroot}%{_datadir}/gir-1.0
rm -rf  %{buildroot}%{_datadir}/vala
rm      %{buildroot}%{_libdir}/pkgconfig/libproxy-1.0.pc
%endif

%if "%{flavor}" == "backend"
%check
%meson_test ||:
%endif

%ldconfig_scriptlets -n libpxbackend-1_0%{?mini}

%if "%{flavor}" == "client"
%ldconfig_scriptlets -n libproxy1
%endif

%if "%{flavor}" == "client"
%files -n libproxy1
%{_libdir}/libproxy.so.1

%files -n libpxbackend-1_0%{?mini}
%dir %{_libdir}/libproxy
%{_libdir}/libproxy/libpxbackend-1.0.so

%files -n libproxy-tools
%{_bindir}/proxy
%{_mandir}/man8/proxy.8%{?ext_man}

%files -n typelib-1_0-Libproxy-1_0
%{_libdir}/girepository-1.0/Libproxy-1.0.typelib

%files -n libproxy-devel
%{_datadir}/gir-1.0/Libproxy-1.0.gir
%dir %{_datadir}/vala/vapi
%{_datadir}/vala/vapi/libproxy-1.0.*
%{_includedir}/libproxy/
%{_libdir}/libproxy.so
%{_libdir}/pkgconfig/libproxy-1.0.pc
%endif

%if "%{flavor}" == "backend"
%files -n libpxbackend-1_0
%dir %{_libdir}/libproxy
%{_libdir}/libproxy/libpxbackend-1.0.so

%files -n libproxy-devel-doc
%{_datadir}/doc/libproxy-1.0
%endif

%changelog
* Tue Jan 14 2025 xiaoguang.wang@suse.com
- Add libproxy-handle-empty-proxy-ignore-entry.patch: Properly
  handle empty proxy ignore entry (bsc#1234940).
* Fri Jan 10 2025 alynx.zhou@suse.com
- Add libproxy-ignore-invalid-uri.patch: Ignore invalid proxy URI
  to suppress GUri warnings (bsc#1235097).
* Thu Oct 31 2024 xiaoguang.wang@suse.com
- Add libproxy-sysconfig-Remove-white-space.patch: Remove white
  space in key value, backport upstream commit cf2b232c
  (bsc#1228999).
* Tue Mar 19 2024 yfjiang@suse.com
- Do not use %%elif by now since SLE, Leap does not have an rpm
  supporting the tag.
* Wed Feb 28 2024 dimstar@opensuse.org
- Drop pkgconfig(libsoup-3.0) BuildRequires: no longer needed.
* Wed Sep 13 2023 dimstar@opensuse.org
- Add libpxbackend-1_0 to baselibs.conf: required by libproxy.so.1.
* Wed Aug 16 2023 dimstar@opensuse.org
- Generate libpxbackend-1_0-mini to be used inside OBS: the backend
  is built without additional dependencies like cURL. So there is
  no wpad/pac support in this variant. Helps break a build cycle.
* Thu Jul 13 2023 dimstar@opensuse.org
- Update to version 0.5.3:
  + Fix crash querying URLs without a host.
  + Web: Update application page.
  + Add appplication info about apt and python requests.
* Fri Jun 16 2023 dimstar@opensuse.org
- Update to version 0.5.2:
  + Link with libsocket where needed.
  + Remove libsoup from doc and CI.
  + Fix coverity findings.
  + Add a comment that docs option needs introspection.
  + Set pac data after download only.
  + Fix race condition in px_manager_get_proxies_sync.
  + Update gobject dependency in pkgconfig file.
  + Reread env variables in each get_config call.
* Fri Jun  2 2023 dimstar@opensuse.org
- Update to version 0.5.1:
  + Guard PxManager test with pacrunner-duktape option.
  + Install libpxbackend into pkglibdir.
  + Move glib2 inclusion out of c++ protection.
  + Replace libsoup with glib socket service functions.
  + Use glib-object header instead of gio.
  + Fix libproxy rpath.
  + Draft: Improve ignore checks.
- Drop pkgconfig(libpeas-1.0) BuildRequires: libpeas is no longer
  needed.
- Add pkgconfig(gobject-introspection-1.0) BuildRequires: this was
  used before, but pulled in by libpeas.
* Fri Jun  2 2023 dimstar@opensuse.org
- Update to version 0.5.0:
  + Complete rewrite, now actively maintained by Volkswagen.
- Drop libproxy-perl-cflags.patch: no longer applicable as the
  bindings were ported to gobject-introspection.
- Adjusted build dependencies:
  + Dropped cmake, gcc-c++, netcfg, pkgconfig, zlib-devel,
    NetworkManager-devel, dbus-1-devel, perl, python-rpm-macros,
    python3-devel, python-devel, pkgconfig(gio-2.0) >= 2.26,
    pkgconfig(gobject-2.0), pkgconfig(javascriptcoregtk-4.0),
    libKF5ConfigCore5, pkgconfig(mozjs-38), mono-devel.
  + Added meson, sysuser-tools, vala, pkgconfig(glib-2.0),
    pkgconfig(libpeas-1.0), pkgconfig(gi-docgen),
    pkgconfig(gsettings-desktop-schemas), pkgconfig(libcurl),
    pkgconfig(libsoup-3.0).
- Change multibuild flavors to build a client library
  (libproxy.so.1 plus consumer include files) and a backend flavor
  (pxbackend, linked against cURL, duktape; the lib doing the
  actual work. The split is needed to break up build cycles with
  curl).
- Drop no longer existing subpackages libproxy1-config-kde,
  libproxy1-config-gnome3, libproxy1-config-pacrunner,
  libproxy1-networkmanager, libproxy1-pacrunner-duktape,
  libproxy1-pacrunner-webkit, libproxy1-pacrunner-mozjs,
  python-libproxy, python3-libproxy, perl-Net-Libproxy,
  libproxy-sharp. All the language bindings are now handled by
  gobject-introspection.
- Introduce the new sub packages typelib-1_0-Libproxy-1_0,
  libpxbackend-1_0, and libproxy-devel-doc.
* Thu Jun  1 2023 fcrozat@suse.com
- Only build mono support on openSUSE, not SLE nor SUSE ALP.
* Tue Jun 21 2022 dimstar@opensuse.org
- Add libproxy-perl-cflags.patch: perl: Use ccflags from %%Config
  for libproxy module compilation; fixes perl test suite on i586.
* Mon Jun 20 2022 dimstar@opensuse.org
- Update to version 0.4.18:
  + build: Allow configuration of sysconfig module.
  + config_envvar: Add environment variable for pacrunner
    debugging.
  + build: disable mozjs by default.
  + python: Support Python 3.10 and above.
  + Add Duktape pacrunner module.
  + config_kde: Compute list of config file locations ourselves.
  + cpmfog_gnome3: Add gnome-wayland to permitted DESKTOP_SESSION.
- Drop libproxy-python-310.patch: fixed upstream.
- Build duktape pacrunner module:
  + Add pkgconfig(duktape): new dependency.
  + Split new subpackage libproxy1-pacrunner-duktape.
  + Suggest duktape pacrunner for config modules recommending a
    pacrunner.
* Mon May 16 2022 dimstar@opensuse.org
- Add libproxy-python-310.patch: Detect python 3.10.
* Thu Feb 10 2022 bjorn.lie@gmail.com
- Drop gconf2-devel BuildRequires: libproxy was ported to gsettings
  quite some time ago.
- Update our Supplements to current standard.
* Tue Jul 13 2021 dimstar@opensuse.org
- Do no longer BuildRequire libmodman-devel: libproxy 0.4.17 was
  changed upstream to only support to internal version (no other
  consumer of libmodman exists).
- No longer pass -DFORCE_SYSTEM_LIBMODMAN=ON to cmake: not
  understood anymore (boo#1188265).
* Tue Dec 29 2020 dimstar@opensuse.org
- Update to version 0.4.17:
  + python bindings: fix "TypeError: argtypes must be a sequence of
    types".
- Drop 147.patch: fixed upstream.
* Mon Dec 14 2020 dimstar@opensuse.org
- Add 147.patch: python bindings: fix "TypeError: _argtypes_ must
  be a sequence of types".
* Fri Dec  4 2020 dimstar@opensuse.org
- Update to version 0.4.16:
  + Port to, and require, SpiderMonkey 6.
  + Use closesocket() instead of close() on Windows.
  + Add symbol versions - be ready to introduce new APIs as needed.
  + Add public px_proxy_factory_free_proxies function.
  + Add PacRunner config backend (largely untested; feedback
    welcome!).
  + Small performance improvements.
  + pxgsettings: use the correct syntax to connect to the changed
    signal (silences annoying output on console).
  + Support python3 up to version 3.9.
  + Fix buffer overflow when PAC is enabled (CVE-2020-26154).
  + Rewrite url::recvline to be nonrecursive (CVE-2020-25219).
  + Remove nonfunctional and crashy pacrunner caching.
  + Never use system libmodman (no other consumers, not
    maintained).
- Drop upstream merged patches:
  + libproxy-python3.7.patch
  + libproxy-pxgsettings.patch
  + libproxy-CVE-2020-25219.patch
  libproxy-fix-pac-buffer-overflow.patch
- Create new sub-package libproxy1-config-pacrunner.
* Wed Sep 30 2020 mgorse@suse.com
- Add libproxy-CVE-2020-25219.patch: Rewrite url::recvline to be
  nonrecursive (boo#1176410 CVE-2020-25219).
- Add libproxy-fix-pac-buffer-overflow.patch: fix buffer overflow
  when PAC is enabled (boo#1177143 CVE-2020-26154).
* Mon Sep 14 2020 yfjiang@suse.com
- Build with KDE on Tumbleweed, Leap and SLE releases greater than
  SLE-15-SP2 (jsc#SLE-12256).
* Mon Apr 27 2020 dimstar@opensuse.org
- Add libproxy-pxgsettings.patch: pxgsettings: use the correct
  syntax to connect to the changed signal.
* Thu Mar 12 2020 tchvatal@suse.com
- Remove few SLE11 conditions
- Fix build without python2 available
* Wed Dec 12 2018 dimstar@opensuse.org
- Convert package from multispec to multibuild.
* Fri Oct  5 2018 dimstar@opensuse.org
- Update Url tag to point to http://libproxy.github.io/libproxy/
- Add libproxy-python3.7.patch: Support python 3.7 and 3.8.
- Drop py_requires: no longer needed.
* Sat Jul  7 2018 bjorn.lie@gmail.com
- Drop favor_gtk2 conditional.
* Thu Feb 22 2018 fvogt@suse.com
- Use %%license (boo#1082318)
* Thu Sep  7 2017 jengelh@inai.de
- Update descriptions and RPM categories.
* Thu May 11 2017 dimstar@opensuse.org
- Update to version 0.4.15:
  + Port to, and require, SpiderMonkey 38.
  + Fix "NetworkManager plugin not being built"
    (gh#libproxy/libproxy#53).
  + Fix "networkmanager plugin not working
    (gh#libproxy/libproxy#58).
  + Fix "Invalid read after free" (gh#libproxy/libproxy#59).
  + Fix intermittent unit test failures.
- Replace pkgconfig(mozjs185) buildRequires with
  pkgconfig(mozjs-38), following upstream.
* Mon Feb  6 2017 dimstar@opensuse.org
- Have libproxy1-config-kde require libqt5-qtpaths instead of
  libqt5-qttools on openSUSE > 13.2 / openSUSE > Leap 42.x
  (boo#988808).
* Mon Jan  9 2017 dimstar@opensuse.org
- Update to version 0.4.14:
  + Parallel build support for python2 and python3.
  - DWITH_PYTHON has been replaced with -DWITH_PYTHON2 and
  - DWITH_PYTHON3 to have full control over this. Default is
    ON for both (gh#libproxy/libproxy#22).
  + Minor fixes to the PAC retriever code
    (gh#libproxy/libproxy#40).
  + Fallback to mcs instead of gmcs for the mono bindings
    (gh#libproxy/libproxy#37).
  + Fix build using cmake 3.7.
  + Fix deprecation warnings of pxgsettings with glib 2.46.
  + Improve the get-pac test suite (gh#libproxy/libproxy#47).
- Drop update-from-svn.sh: The script has not been usable for
  years, since libproxy is no longer hosted in this svn repo.
- Drop upstream merged patches:
  + libproxy-cmake-3.7.patch
  + libproxy-FindMono-4.6.patch
  + libproxy-gnome-waitpid.patch
  + libproxy-python3-support.patch
- Re-enable the test suite: with the upstream changes this should
  now be more reliable.
* Tue Nov 22 2016 dimstar@opensuse.org
- Add libproxy-cmake-3.7.patch: Fix build with cmake 3.7.
* Thu Sep 29 2016 dimstar@opensuse.org
- Add libproxy-FindMono-4.6.patch: Fall back to mcs if gmcs cannot
  be found. Fixes issues with mono 4.6, which no longer ships the
  wrapper by default.
* Mon Aug  8 2016 dimstar@opensuse.org
- Add libproxy-python3-support.patch: Allow to build PYTHON2 and
  PYTHON3 bindings during the same build phase.
- Create new subpackage python3-libproxy.
- Add python3-devel BuildRequires when not building core.
* Fri Jul 22 2016 dimstar@opensuse.org
- Add libproxy-gnome-waitpid.patch: GNOME3: Wait for pxgsettings to
  vanish while destroying the plugin (boo#967601).
* Fri May 20 2016 alarrosa@suse.com
- Update to GNOME 3.20.2 (Fate#318572, bnc#980527)
* Tue May 10 2016 dimstar@opensuse.org
- Require libqt5-qttools by libproxy1-config-kde: the plugin spawns
  qtpaths to find the right config files (boo#979232).
- Trigger libproxy1-config-kde for installation when
  plasma5-session and libproxy1 are installed.
* Mon May  9 2016 dimstar@opensuse.org
- Fix condition to not build KDE plugin for SLE.
* Thu Apr 28 2016 dimstar@opensuse.org
- Update to version 0.4.13:
  + Allow linking webkit pacrunner against javascriptcore-4.0
    (webkit2).
  + Allow to disable building of the KDE module
    (-DWITH_KDE=ON/OFF).
  + Fix compilation errors with CLang on MacOSX.
  + bindings: perl: Add an option to explicitly link against
    libperl.so. Some distributions want to do it, other prefer not
    to, the library is anyway in context of perl.
  + config_kde: Add a basic cache and invalidation: performance
    improvement for the KDE module.
- Pass -DWITH_KDE=OFF to cmake when building core.
- Replace pkgconfig(webkitgtk-3.0) BuildRequires with
  pkgconfig(javascriptcoregtk-4.0): make use of the WebKit2 port.
* Fri Apr 15 2016 mgorse@suse.com
- Update to GNOME 3.20  Fate#318572
* Thu Jan 14 2016 fcrozat@suse.com
- Disable building libproxy-config-kde on SLE.
* Tue Jan 12 2016 dimstar@opensuse.org
- Update to version 0.4.12:
  + Move development to github.com/libproxy/libproxy.
  + Fix fd leak in get_pac (Bug #185).
  + Detect running MATE session (Bug #186, Part1).
  + Fix linking of perl bindings to pthread (Bug #182).
  + Correctly detect spidermonky (mozjs185) (Bug #188).
  + Stop pxgsettings from segfaulting on exit (Bug #192).
  + Fix test #10 (Bug #189).
  + Fix build on Mac OS X (Bug #183).
  + Add a generic KDE Config module (fix crashes of Qt5 based
    apps) (issue#4).
- Drop upstream fixed patches:
  + libproxy-pxgsettings-crash.patch
  + libproxy-no-libperl.patch
  + libproxy-pxgsettings-signals.patch
- Rename libproxy1-config-kde4 subpackage to libproxy-config-kde,
  following upstreams introduction of the generic config loader.
- Require libKF5ConfigCore5 from libproxy1-config-kde (we don't
  really need the library, but kreadconfig5 in this package).
- Replace libkde4-devel and libqt4-devel BuildRequires with
  libKF5ConfigCore5: the new KDE config parser interacts directly
  with kreadconfig5 and does not link to Qt.
* Fri May 15 2015 dimstar@opensuse.org
- Add libproxy-pxgsettings-signals.patch: Fix for pxgsettins not
  actively monitoring gsetting changes. Due to recent changes in
  GLib, only values are being monitored, that are read AFTER the
  signal handler is attached.
- Adjust baselibs.conf to match what is currenly being built.
* Wed Aug  6 2014 fcrozat@suse.com
- Change Supplements to install libproxy1-config-gnome3 only if
  gnome-session-core is installed to reduce minimal install size
  (bnc#885455).
* Thu Sep  5 2013 mls@suse.de
- Add libproxy-no-libperl.patch: do not link the perl module
  against libperl. We do not want a dependency on the libperl
  library, as that would make as depend on the specific version of
  perl. As the bindings are running in perl context, libperl can
  be assumed to be loaded by that time.
- Use perl_requires if it is defined.
* Mon Aug 26 2013 dimstar@opensuse.org
- Add libproxy-pxgsettings-crash.patch: fix crash in pxgsettings
  when it's closing down (bnc#836576).
* Fri Aug  2 2013 dimstar@opensuse.org
- Build mono, perl and python sub package while building -plugins
  instead of the main package. This helps keeping the build deps
  for the main package minimal.
* Thu Jul 11 2013 dmueller@suse.com
- Use build conditional (gcond) for enabling/disabling mono
  bindings instead of static defines. This allows for osc build
  and rpmbuild to be used more flexible.
* Thu Feb 28 2013 dmueller@suse.com
- Remove mono support for aarch64 for now.
* Sun Dec  2 2012 dimstar@opensuse.org
- Update to version 0.4.11:
  + Build fixes with cmake 2.8.10+.
  + Quick release without built binaries / files (bug#184).
- Drop cmake-2.8.10-compat.diff: fixed upstream.
* Mon Nov 12 2012 cgiboudeaux@gmx.com
- Add cmake-2.8.10-compat.diff: fixes a CMake error with
  CMake >= 2.8.10 (bnc#789219).
* Tue Oct 16 2012 dimstar@opensuse.org
- Update to version 0.4.10:
  + Fix http chunk encoded PAC that was broken in previous release.
  + Add HTTP client unit test.
  + Fix more coding style issues.
- Disable test suite for now: the new http client test fails for
  weird reasons in the build bot (but works locally).
* Thu Oct 11 2012 coolo@suse.com
- Add explicit netcfg BuildRequires for the test suite.
* Wed Oct 10 2012 dimstar@opensuse.org
- Update to version 0.4.9:
  + Fixed buffer overflow when downloading PAC (CVE-2012-4504).
  + Fix infinite loop uppon network errors.
* Tue Oct  2 2012 dimstar@opensuse.org
- Update to version 0.4.8:
  + Only support standalone mozjs185 as mozilla js engine.
  + Support building with javascritpcoregtk 1.5
  + Support sending multiple results.
  * Issues fixed:
  - #166: Libproxy does not parse NO_PROXY correct when the line
    contains spaces
  - #164: If gconf's value is an empty list, pxgconf will make
    /usr/bin/proxy wait forever
  - #60: use lib js for embedded solutions
  - #160: strdup and gethostbyname not declared on OSX 10.7
  - #168: .pc file should be installed under OSX as well.
  - #170: Also check for "Transfer-Encoding: chunked".
  - #171: mozjs pacrunner: Fix parameters of dnsResolve_()
  - #172: Allow to forcibly build pacrunner as module
  - #173: Libproxy doesn't build with gcc 4.7
  - #147: Use ${CMAKE_DL_LIBS} instead of assuming libdl is correct.
  - #176: python bindings: guard the destructor.
  - #177: Speed up importing of libproxy in python.
- Drop upstream fixed patches:
  + libproxy-javascriptcoregtk.patch
  + libproxy-mozjs185.patch
  + libproxy-trim-ignores.patch
  + libproxy-gcc47.patch
  + libproxy-force-bipr.patch
* Sat Jun  9 2012 dimstar@opensuse.org
- Add libproxy-force-bipr.patch: Force building pacrunner as module
  This is required as libproxy, when building only one pacrunner,
  links the module internal. But as we only temporarly disable
  the mozjs, we do need to keep the webkit runner as an external
  module.
- Also pass -DBIPR=0 to cmake, to enable the patch above.
* Wed Jun  6 2012 dimstar@opensuse.org
- Temporaryly disable the mozjs pacrunner: it casues crashes due
  to symbol conflicts in Firefox (bnc#759123):
  + Introduce build_mozjs defines, currently set to 0
  + Conditionally build the pacrunner-mozjs package
  + Conditionally buildrequire pkgconfig(mozjs185)
  + When not building mozjs pacrunner, obsolete the package by
    libproxy1.
* Tue Mar 13 2012 dimstar@opensuse.org
- Add libproxy-gcc47.patch: Fix build with gcc 4.7.
* Wed Feb  1 2012 dimstar@opensuse.org
- Add libproxy-trim-ignores.patch: Trim strings in ignore list.
  Fix bnc#739069.
* Mon Nov  7 2011 meissner@suse.de
- remove mono dependency also for ppc64
* Fri Oct  7 2011 dmueller@suse.de
- remove mono dependency for %%%%arm
* Wed Jul 27 2011 vuntz@opensuse.org
- Build against js instead of xulrunner:
  + Add libproxy-mozjs185.patch: taken from upstream, detect
    mozjs185 instead of xulrunner in the build system.
  + Add pkgconfig(mozjs185) BuildRequires and remove
    mozilla-xulrunner-devel BuildRequires.
  + Change Supplements of libproxy1-pacrunner-mozjs to use
    libmozjs185-1_0 instead of mozilla-xulrunner.
- Change Supplements of libproxy1-pacrunner-webkit to appropriately
  use libjavascriptcoregtk-1_0-0/libjavascriptcoregtk-3_0-0
  (depending on %%favor_gtk2) instead of libwebkitgtk-0.
* Mon Jun 20 2011 dimstar@opensuse.org
- Add libproxy-javascriptcoregtk.patch: Fix build with
  webkitgtk-3.0 version 1.5.1: javascriptcoregtk became independent
  and can be used on it's own now and is actually what libproxy
  depends on. Patch taken from upstream svn, r816.
* Mon Jun  6 2011 dimstar@opensuse.org
- Update to version 0.4.7:
  + Support/require xulrunner 2.0+
  + Support linking againgst libwebkit-gtk3 (-DWITH_WEBKIT3=ON)
  + Port to gsettings for gnome3. (-DWITH_GNOME3=ON[default])
  + Issues closed:
  - #149: always test for the right python noarch module path
  - #155: Cannot compile with Firefox 4
  - #156: libproxy should build against webkitgtk-3.0
  - #158: Won't compile w/ xulrunner 2.0 final
  - #159: libproxy fails with autoconfiguration
    "http://proxy.domain.com"
  - #131: GSettings-based GNOME plugin
  - #150: SUSE sysconfig/proxy config support
- Drop patches included upstream:
  + libproxy-sysconfig-support.patch
  + libproxy-xul2.patch
  + libproxy-backports.patch
- Package gnome3 module instead of gnome module, if favor_gtk2 is
  not set (in the project metadata).
- Add gnome3 module to baselibs.conf and fixup the various
  Supplements in baselibs.conf (pointed to the pre -config names).
- When building for gnome3 (favor_gtk2 = 0), add BuildRequires:
  pkgconfig(gio-2.0) >= 2.26, pkgconfig(gobject-2.0) and
  pkgconfig(webkitgtk-3.0)
- When building for gnome2, add BuildRequires:
  pkgconfig(gconf-2.0), pkgconfig(gobject-2.0) and replace
  libwebkit-devel with pkgconfig(webkit-1.0).
* Mon Apr 18 2011 ro@suse.de
- Update baselibs.conf.
* Tue Feb 15 2011 dimstar@opensuse.org
- Add libproxy-backports.patch: Backport critical fixes from
  upstream codestream.
* Mon Feb 14 2011 dimstar@opensuse.org
- Add libproxy-xul2.patch: Add compatibility to build against
  xulrunner 2.0. Patch submitted upstream, issue#155.
- Use xulrunner 2.0 on openSUSE 11.4.
* Mon Dec  6 2010 vuntz@opensuse.org
- Add libproxy-sysconfig-support.patch, to support the proxy
  configuration from sysconfig. Part of bnc#655483.
  Patch written by Duncan Mac-Vicar <dmacvicar@novell.com>.
* Thu Sep  2 2010 dimstar@opensuse.org
- Update to version 0.4.6:
  + Fixed a crash in the URL parser
  + Fixed build issues with Visual Studio
  + Updated the INSTALL file
  + Install Python binding in prefix path if site-packages exists
* Fri Aug 20 2010 dimstar@opensuse.org
- Mono bindings are not available for all supported platforms,
  thus wrapping it in a if have_mono [...] endif.
* Thu Aug 19 2010 dimstar@opensuse.org
- Check for build_snapshot: the svn snapshot project contains
  unversioned tarballs.
* Thu Aug 19 2010 dimstar@opensuse.org
- Update to version 0.4.5:
  + C# bindings are installable (-DWITH_DOTNET=ON)
  + C# bindings installation path can be changed using -DGAC_DIR=
  + Internal libmodman build fixed
  + Installation dirs are now all relative to CMAKE_INSTALL_PREFIX
  + Fixed test while using --as-needed linker flag
  + Fixed generation of libproxy-1.0.pc
  + Basic support for Mingw added (not yet 100%% functional)
  + Ruby binding implemented (not yet in the build system)
  + Fixed modules not being found caused by relative
    LIBEXEC_INSTALL_DIR
  + Fixed bug with builtin plugins (Issue 133)
  + Vala bindings installation path can be changed using
  - DVAPI_DIR=
  + Python bindings installation path can be changed using
  - DPYTHON_SITEPKG_DIR=
  + Perl bindings can be installed in vendor directory
    (-DPERL_VENDORARCH=ON)
  + Perl bindings installation path can be change using
  - DPX_PERL_ARCH=
  + Unit test now builds on OSX
- Changes from version 0.4.4:
  + Add support for optionally building using a system libmodman
  + Rework build system to be cleaner
  + Fix two major build system bugs: 127, 128
* Mon Jul  5 2010 dimstar@opensuse.org
- Add mono-devel BuildRequires to install the csharp bindings.
* Tue Jun 22 2010 dimstar@opensuse.org
- Initial work to support win32 cross building.
* Mon Jun 14 2010 dimstar@opensuse.org
- Use external libmodman: add libmodman-devel BuildRequires.
- Drop libmodman0 subpackage
* Wed Jun  9 2010 dimstar@opensuse.org
- Enable build on other distributions than openSUSE, wrapping
  openSUSE rpm tags like Recommends and Supplements in %%if
  statements.
* Mon Jun  7 2010 dimstar@opensuse.org
- Update to version 0.4.3:
  + Test can now be out-compiled using BUILD_TESTING=OFF
  + Fixed python binding not handling NULL pointer
  + Pyhton binding now support Python version 3
  + Rewrote URL parser to comply with unit test (bnc#612007)
  + Username and password are now URL encoded
  + Scheme comparison is now non-case sensitive
  + Fixed deadlock using WebKit as PAC runner
  + Fixed OS X compilation of Perl bindings
- libmodman0_0_0 is now correctly called libmodman0, follow this
  change also in baselibs.conf
* Tue May 25 2010 dimstar@opensuse.org
- Update to version 0.4.2:
  + Fixed python bindings
  + Workaround cmake bug with dynamic libraries in non-standard
    folders.
* Tue May 18 2010 dimstar@opensuse.org
- Update to version 0.4.1:
  + Improved cross-platform build
  + Added Perl and Vala bindings
  + Fix multiple infinite loop bugs
  + Fix random crash with Gnome backend
  + Standardized Gnome backend based on Mozilla and Chrome behavior
  + Removed dependency to X11 in Gnome backend
  + Allow disabling features at build time using WITH_* cmake
    options
  + Module path can now be altered using PX_MODULE_PATH environment
  + pxgconf helper location can be altered using PX_GCONF
    environment
  + Removed proxy scheme filtering, we now trust config modules
  + socks5:// and socks4:// is now allowed
  + Fix crash when password is empty string
  + Complete list of bug fixes:
  - #19, #59, #65, #86, #87, #88, #89, #90, #91, #92, #93, #97,
    [#98], #99, #100, #101, #102, #103, #106, #108, #110
  + Known issues:
    + #109 - Scheme comparison is case sensitive
    + #112 - Username and password are not URI encoded
* Mon Mar 29 2010 dimstar@opensuse.org
- Update to svn snapshot 626
  + No longer require xlib to detect session.
- Remove xorg-x11-libXmu-devel BuildRequires.
* Fri Mar 26 2010 vuntz@opensuse.org
- Build against mozilla-xulrunner192-devel on openSUSE > 11.2.
* Mon Mar 15 2010 dimstar@opensuse.org
- Update to svn snapshot 621 in order to fix some serious crashes
  in config_gnome. This is close to what will be the 0.4.1 release.
- Drop all patches as they came from upstream and are included
  in this snapshot already.
* Wed Mar 10 2010 dimstar@opensuse.org
- Do not forcibly require libmodman from the tools package. It's
  pulled in by library dependencies.
* Wed Mar 10 2010 coolo@novell.com
- add libmodman0_0_0 to baselibs.conf
* Sat Mar  6 2010 dimstar@opensuse.org
- Add libproxy-gcc45.patch to fix build with gcc 4.5. Patch comes
  from upstream svn, rev 599.
* Fri Feb 26 2010 dimstar@opensuse.org
- Update to version 0.4.0:
  + C++ rewrite
  + Small API change (px_proxy_factory_get_proxy() can now return
    NULL)
  + SOVERSION bump
  + libmodman is now a separate library
  + Migrate to cmake
  + Windows support (config_w32reg, ignore_hostname; VC++ support)
  + MacOSX support (config_macosx, ignore_hostname)
  + Built-in modules support
  + Support for chunked encoding
  + Move to hidden visibility by default
  + KDE's KConfig semantics are fully supported
  + Removeal of all PX_* env variables (no longer needed)
  + Symbol based detection of relevant pacrunner
  + Reworked config_gnome to not suck (its *much* faster)
  + Many other things I can't remember
- BuildRequire cmake, gccc-++ and zlib-devel
- Add libproxy-pysitelib.patch, as the python bindings are are
  arch-independent
- Add libproxy-libexecpatch.patch to move library helpers to proper
  libexecdir.
- Build the python-package as noarch
- sonum bump to 1, thus changing name to libproxy1
- Split out libmodman (will not follow the versioning of libproxy
  in the long run).
- Add libproxy-pkgconfig.patch to also install the .pc file.
* Tue Jan  5 2010 jengelh@medozas.de
- Package baselibs.conf
* Thu Oct  8 2009 dimstar@opensuse.org
- Update to version 0.3.1
  + Bugfixes
  - config file parser reads all sections
  - KDE session detection based on environment varibales,
    as suggested by KDE upstream.
  + KDE configuration module is the first module in C++ and
    now links to libkdecore4 in order to properly detect the
    configuration folder for kde.
  + At the moment we're not compatible with KDE3. Sorry.
  + .NET bindings can now properly be installed and it should
    be possible for packagers to provide them.
- Add gcc-c++, libkde4-devel and libqt4-devel for updated kde mod.
- This update solves bnc#546199.
* Sun Aug 16 2009 dominique-obs@leuenberger.net
- Update to version 0.3.0
  + WARNING!!! Slight API change!!! see docs for
    px_proxy_factory_get_proxies()
  + Credentials support (see API change above)
  + A complete rewrite of the module manager
  + file:// as valid PAC URLs
  + Sample Mono application
  + Automake 1.11 shaved output
  + gnome backend rewrite (now w/o thread issues)
  + Test suite base functionality exists
  + Many solaris build fixes
  + Seamonkey support as JS pacrunner
  + Bugfixes
  + Compiles for MS Windows using Mingw
- Split additional modules out in separate packages.
* Wed Aug 12 2009 dominique-obs@leuenberger.net
- Use new python macros on openSUSE <= 11.1
* Sun Aug  9 2009 coolo@novell.com
- use new python macros
* Mon Jun 22 2009 dominique-obs@leuenberger.net
- Add libproxy-svn-303_as-needed.patch to successfully build with
  - -as-needed
* Tue Jun 16 2009 dominique-obs@leuenberger.net
- Extend baselibs.conf
  We also need the plugins 32bit. The 32bit plugin get's installed
  as soon as the 32bit librarz is installed. Same featureset is
  recommended, bnc#485543
* Wed May 13 2009 vuntz@novell.com
- Tag patches.
* Wed May  6 2009 vuntz@novell.com
- Build libproxy-plugins against mozilla-xulrunner191 on
  openSUSE > 11.1.
* Thu Apr 23 2009 vuntz@novell.com
- Change Name to libproxy-plugins in libproxy-plugins.spec.
* Thu Apr 16 2009 vuntz@novell.com
- Split the build in two steps, libproxy and libproxy-plugins, to
  avoid a build loop: libproxy depends on libwebkit which depends
  on libsoup which depends on libproxy. So we now have a new spec
  file for libproxy-plugins where the libwebkit dependency is.
* Sat Mar 14 2009 vuntz@novell.com
- Review changes.
* Sat Mar 14 2009 wr@rosenauer.org
- use correct mozilla/xulrunner dependencies
* Mon Feb 23 2009 vuntz@novell.com
- Revert the use of %%{libproxy_shnum}: there are places where the
  macro cannot be used (%%files, eg), and we want don't want to mix
  libproxy0 and libproxy%%{libproxy_shnum} -- too likely to forget
  to update one of the two instances.
* Sun Feb 22 2009 vuntz@novell.com
- Review changes.
- Add Provides/Obsoletes after plugin packages renaming.
- Don't use %%{name} everywhere: in some places, it doesn't help
  with clarity; in some others, it could be wrong in the future (in
  Supplements).
* Tue Feb 17 2009 domninique-obs@leuenberger.net
- Replace the %%{name}0 all over by %%{name}%%{libproxy_shnum}, makes
  it easier for future updates by linking to variables.
* Tue Feb 17 2009 vuntz@novell.com
- Review changes.
* Tue Feb 17 2009 dominique-obs@leuenberger.net
- Have the plugin sub-packages follow the shlib name. The plugins
  are depending on a specific version of the lib and should be
  installable in parallel together with multiple libs.
  The plugins live in a versioned directory, so no conflicts can
  happen.
* Mon Feb 16 2009 ro@suse.de
- added baselibs.conf
  (libproxy0-32bit needed by libsoup-2_4-1-32bit)
* Fri Feb  6 2009 vuntz@novell.com
- Add missing Requires on libproxy0 for the subpackages.
* Tue Feb  3 2009 hfiguiere@suse.de
- Initial packaging.
