#
# spec file for package java-11-openjdk
#
# Copyright (c) 2025 SUSE LLC and contributors
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%{!?aarch64:%global aarch64 aarch64 arm64 armv8}
%{!?arm6:%global arm6 armv3l armv4b armv4l armv4tl armv5b armv5l armv5teb armv5tel armv5tejl armv6l armv6hl}
%global jit_arches %{ix86} x86_64 ppc64 ppc64le %{aarch64} %{arm} s390x
%global debug 0
%global make make
%if 0%{?suse_version} > 1500
%global add_back_javaee_modules 0
%else
%global add_back_javaee_modules 1
%endif
%global is_release 1
%global buildoutputdir build
# Convert an absolute path to a relative path.  Each symbolic link is
# specified relative to the directory in which it is installed so that
# it will resolve properly within chrooted installations.
%global script 'use File::Spec; print File::Spec->abs2rel($ARGV[0], $ARGV[1])'
%global abs2rel perl -e %{script}
%global syslibdir       %{_libdir}
%global archname        %{name}
# Standard JPackage naming and versioning defines.
%global featurever      11
%global interimver      0
%global updatever       29
%global buildver        7
%global openjdk_repo    jdk11u
%global openjdk_tag     jdk-%{featurever}.%{interimver}.%{updatever}%{?patchver:.%{patchver}}+%{buildver}
%global openjdk_dir     %{openjdk_repo}-jdk-%{featurever}.%{interimver}.%{updatever}%{?patchver:.%{patchver}}-%{buildver}
# JavaEE modules
%global java_atk_wrapper_version 0.33.2
%global java_activation_repository activation
%global java_activation_tag JAF-1_2_0
%global java_xml_bind_repository jaxb-spec
%global java_xml_bind_tag 2.4.0
%global java_xml_soap_repository javax.xml.soap
%global java_xml_soap_tag 1.4.0
%global java_annotation_repository javax.annotation
%global java_annotation_tag 1.3.2
%global java_xml_ws_repository jax-ws-spec
%global java_xml_ws_tag 2.4.0
%global com_sun_xml_fastinfoset_repository metro-fi
%global com_sun_xml_fastinfoset_tag 1.2.15-RELEASE
%global org_jvnet_staxex_repository metro-stax-ex
%global org_jvnet_staxex_tag 1.8
%global com_sun_istack_runtime_repository jaxb-istack-commons
%global com_sun_istack_runtime_tag 3.0.7-RELEASE
%global jaxb_ri_repository jaxb-v2
%global jaxb_ri_tag 2.3.1
# priority must be 6 digits in total
%if 0%{?suse_version} <= 1315 && ! 0%{?java_bootstrap}
%global priority        0
%else
%global priority        2105
%endif
%global javaver         %{featurever}
# Standard JPackage directories and symbolic links.
%global sdklnk          java-%{javaver}-openjdk
%global archname        %{sdklnk}
%global jrelnk          jre-%{javaver}-openjdk
%global jrebindir       %{_jvmdir}/%{jrelnk}/bin
%global sdkdir          %{sdklnk}-%{javaver}
%global sdkbindir       %{_jvmdir}/%{sdklnk}/bin
# Prevent brp-java-repack-jars from being run.
%global __jar_repack 0
# cacert symlink
%global cacerts  %{_jvmdir}/%{sdkdir}/lib/security/cacerts
# real file made by update-ca-certificates
%global javacacerts %{_var}/lib/ca-certificates/java-cacerts
%global bootcycle 1
# turn zero on non jit arches by default
%ifnarch %{jit_arches}
%global _with_zero 1
%endif
%if %{debug}
%global debugbuild slowdebug
%else
%global debugbuild release
%endif
%if %{bootcycle}
%global imagesdir bootcycle-build/images
%global imagestarget bootcycle-images all
%else
%global imagesdir images
%global imagestarget all
%endif
# bnc#542545
# 32-bit versus 64-bit specific provides:
%ifarch %{ix86} ppc s390
%global bits 32
%endif
%ifarch x86_64 ia64 s390x
%global bits 64
%endif
%if 0%{?__isa_bits}
%global bits %{__isa_bits}
%endif
# Turn on/off some features depending on openSUSE version
%if 0%{?suse_version} > 1320
%global with_system_pcsc 1
%else
%global with_system_pcsc 0
%endif
%global with_system_harfbuzz 1
%if %{is_release}
%global package_version %{featurever}.%{interimver}.%{updatever}.%{?patchver:%{patchver}}%{!?patchver:0}
%else
%global package_version %{featurever}.%{interimver}.%{updatever}.%{?patchver:%{patchver}}%{!?patchver:0}~%{buildver}
%endif
%global NSS_LIBDIR %(pkg-config --variable=libdir nss)
%bcond_with zero
%bcond_with aot
%if ! %{with zero}
%ifarch x86_64 %{aarch64}
%global _with_aot 1
%endif
%endif
%if ! %{with zero}
%global with_systemtap 1
%else
%global with_systemtap 0
%endif
%if %{with_systemtap}
%global tapsetroot      %{_datadir}/systemtap
%global tapsetdir %{tapsetroot}/tapset/%{_build_cpu}
%endif
%if %{with_systemtap}
# Where to install systemtap tapset (links)
# We would like these to be in a package specific subdir,
# but currently systemtap doesn't support that, so we have to
# use the root tapset dir for now. To distinquish between 64
# and 32 bit architectures we place the tapsets under the arch
# specific dir (note that systemtap will only pickup the tapset
# for the primary arch for now). Systemtap uses the machine name
# aka build_cpu as architecture specific directory name.
%global tapsetroot %{_datadir}/systemtap
%global tapsetdir %{tapsetroot}/tapset/%{_build_cpu}
%endif
Name:           java-%{featurever}-openjdk
Version:        %{package_version}
Release:        150000.3.132.2
Summary:        OpenJDK %{featurever} Runtime Environment
License:        Apache-1.1 AND Apache-2.0 AND GPL-1.0-or-later AND GPL-2.0-only AND GPL-2.0-only WITH Classpath-exception-2.0 AND LGPL-2.0-only AND MPL-1.0 AND MPL-1.1 AND SUSE-Public-Domain AND W3C
Group:          Development/Languages/Java
URL:            https://openjdk.java.net/
# Sources from upstream OpenJDK project.
Source0:        https://github.com/openjdk/%{openjdk_repo}/archive/%{openjdk_tag}.tar.gz
# Systemtap tapsets. Zipped up to keep it small.
Source10:       systemtap-tapset.tar.xz
# Desktop files. Adapted from IcedTea.
Source11:       jconsole.desktop.in
# nss configuration file
Source12:       nss.cfg.in
# nss fips configuration file
Source13:       nss.fips.cfg.in
# Ensure we aren't using the limited crypto policy
Source14:       TestCryptoLevel.java
# Ensure ECDSA is working
Source15:       TestECDSA.java
# https://codeload.github.com/javaee/%{java_activation_repository}/tar.gz/%{java_activation_tag}
Source20:       %{java_activation_repository}-%{java_activation_tag}.tar.gz
# https://codeload.github.com/javaee/%{java_xml_bind_repository}/tar.gz/%{java_xml_bind_tag}
Source21:       %{java_xml_bind_repository}-%{java_xml_bind_tag}.tar.gz
# https://codeload.github.com/javaee/%{java_xml_soap_repository}/tar.gz/%{java_xml_soap_tag}
Source22:       %{java_xml_soap_repository}-%{java_xml_soap_tag}.tar.gz
# https://codeload.github.com/javaee/%{java_annotation_repository}/tar.gz/%{java_annotation_tag}
Source23:       %{java_annotation_repository}-%{java_annotation_tag}.tar.gz
# https://codeload.github.com/javaee/%{java_xml_ws_repository}/tar.gz/%{java_xml_ws_tag}
Source24:       %{java_xml_ws_repository}-%{java_xml_ws_tag}.tar.gz
# https://codeload.github.com/javaee/%{com_sun_xml_fastinfoset_repository}/tar.gz/%{com_sun_xml_fastinfoset_tag}
Source25:       %{com_sun_xml_fastinfoset_repository}-%{com_sun_xml_fastinfoset_tag}.tar.gz
# https://codeload.github.com/javaee/%{org_jvnet_staxex_repository}/tar.gz/%{org_jvnet_staxex_tag}
Source26:       %{org_jvnet_staxex_repository}-%{org_jvnet_staxex_tag}.tar.gz
# https://codeload.github.com/javaee/%{com_sun_istack_runtime_repository}/tar.gz/%{com_sun_istack_runtime_tag}
Source27:       %{com_sun_istack_runtime_repository}-%{com_sun_istack_runtime_tag}.tar.gz
# https://codeload.github.com/javaee/%{jaxb_ri_repository}/tar.gz/%{jaxb_ri_tag}
Source28:       %{jaxb_ri_repository}-%{jaxb_ri_tag}.tar.gz
# Fresh config.guess and config.sub files
# wget -O config.guess 'http://git.savannah.gnu.org/gitweb/?p=config.git;a=blob_plain;f=config.guess;hb=HEAD'
Source100:      config.guess
# wget -O config.sub 'http://git.savannah.gnu.org/gitweb/?p=config.git;a=blob_plain;f=config.sub;hb=HEAD'
Source101:      config.sub
# Restrict access to java-atk-wrapper classes
Patch3:         java-atk-wrapper-security.patch
# RHBZ 808293
Patch4:         PStack-808293.patch
# Allow multiple initialization of PKCS11 libraries
Patch5:         multiple-pkcs11-library-init.patch
# Fix instantiation of VM on ZERO
Patch8:         zero-ranges.patch
# From icedtea: Increase default memory limits
Patch10:        memory-limits.patch
# Fix use of unintialized memory in adlc parser
Patch12:        adlc-parser.patch
# Fix: implicit-pointer-decl
Patch13:        implicit-pointer-decl.patch
# Use SOURCE_DATE_EPOCH in timestamp when writing properties
Patch14:        reproducible-properties.patch
Patch15:        system-pcsclite.patch
Patch16:        missing-return.patch
Patch17:        nss-security-provider.patch
Patch18:        keytool-default-rsa.patch
Patch19:        fips.patch
#
Patch20:        loadAssistiveTechnologies.patch
#
Patch21:        reproducible-javadoc-timestamp.patch
Patch22:        reproducible-jlink.patch
Patch23:        reproducible-directory-mtime.patch
Patch24:        reproducible-search-index-files.patch
#
Patch30:        JDK-8208602.patch
#
# OpenJDK specific patches
#
Patch100:       s390-java-opts.patch
Patch101:       s390-size_t.patch
#
Patch200:       ppc_stack_overflow_fix.patch
Patch201:       fix_armv6_build.patch
#
Patch302:       disable-doclint-by-default.patch
Patch304:       jdk-8354941.patch
#
Patch500:       activation-module.patch
Patch501:       annotation-module.patch
BuildRequires:  alsa-lib-devel
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  bc
BuildRequires:  binutils
BuildRequires:  cups-devel
BuildRequires:  desktop-file-utils
BuildRequires:  fdupes
BuildRequires:  fontconfig-devel
BuildRequires:  freetype2-devel
BuildRequires:  gcc-c++
BuildRequires:  giflib-devel
BuildRequires:  hicolor-icon-theme
BuildRequires:  java-ca-certificates
BuildRequires:  libX11-devel
BuildRequires:  libXi-devel
BuildRequires:  libXinerama-devel
BuildRequires:  libXrandr-devel
BuildRequires:  libXrender-devel
BuildRequires:  libXt-devel
BuildRequires:  libXtst-devel
BuildRequires:  libjpeg-devel
BuildRequires:  liblcms2-devel
BuildRequires:  libpng-devel
BuildRequires:  libtool
BuildRequires:  libxslt
BuildRequires:  mozilla-nss-devel >= 3.53
BuildRequires:  pkgconfig
BuildRequires:  unzip
BuildRequires:  update-desktop-files
BuildRequires:  xorg-x11-proto-devel
BuildRequires:  xprop
BuildRequires:  zip
# Requires rest of java
Requires:       %{name}-headless = %{version}-%{release}
Requires:       fontconfig
Requires(post): file
ExcludeArch:    s390
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
# Standard JPackage base provides.
Provides:       java = %{javaver}
Provides:       java-%{javaver} = %{version}-%{release}
Provides:       java-openjdk = %{version}-%{release}
Provides:       jre = %{javaver}
Provides:       jre-%{javaver} = %{version}-%{release}
Provides:       jre-%{javaver}-openjdk = %{version}-%{release}
Provides:       jre-openjdk = %{version}-%{release}
# Standard JPackage extensions provides.
Provides:       java-fonts = %{version}
# Required at least by fop
Provides:       java-%{bits} = %{javaver}
Provides:       java-%{javaver}-%{bits}
Provides:       java-openjdk-%{bits} = %{version}-%{release}
Provides:       jre-%{bits} = %{javaver}
Provides:       jre-%{javaver}-%{bits}
Provides:       jre-%{javaver}-openjdk-%{bits} = %{version}-%{release}
Provides:       jre-openjdk-%{bits} = %{version}-%{release}
Provides:       jre1.10.x
Provides:       jre1.3.x
Provides:       jre1.4.x
Provides:       jre1.5.x
Provides:       jre1.6.x
Provides:       jre1.7.x
Provides:       jre1.8.x
Provides:       jre1.9.x
%if 0%{?suse_version} <= 1500
Provides:       java-10-openjdk = %{version}-%{release}
Obsoletes:      java-10-openjdk < %{version}-%{release}
%endif
%endif
%if %{bootcycle}
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
BuildRequires:  java-devel >= 10
BuildConflicts: java-devel >= 12
%else
BuildRequires:  %{name}-devel
%endif
%else
BuildRequires:  %{name}-devel
%endif
# Zero-assembler build requirement.
%if %{with zero}
BuildRequires:  libffi-devel
%endif
%if %{with_systemtap}
BuildRequires:  systemtap-sdt-devel
%endif
%if %{with_system_pcsc}
BuildRequires:  pcsc-lite-devel
%endif
%if %{with_system_harfbuzz}
BuildRequires:  harfbuzz-devel
%endif
%if %{with aot}
BuildRequires:  libelf-devel
%endif

%description
The OpenJDK %{featurever} runtime environment.

%package headless
Summary:        OpenJDK %{featurever} Runtime Environment
Group:          Development/Languages/Java
Requires:       jpackage-utils
# mozilla-nss has to be installed to prevent
# java.security.ProviderException: Could not initialize NSS
# ...
# java.io.FileNotFoundException: /usr/lib64/libnss3.so
#was bnc#634793
Requires:       mozilla-nss
# Post requires update-alternatives to install tool update-alternatives.
Requires(post): update-alternatives
Requires(posttrans): file
Requires(posttrans): java-ca-certificates
# Postun requires update-alternatives to uninstall tool update-alternatives.
Requires(postun): update-alternatives
Obsoletes:      %{name}-accessibility
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
# Standard JPackage base provides.
Provides:       java-%{javaver}-headless = %{version}-%{release}
Provides:       java-headless = %{javaver}
Provides:       java-openjdk-headless = %{version}-%{release}
Provides:       jre-%{javaver}-headless = %{version}-%{release}
Provides:       jre-%{javaver}-openjdk-headless = %{version}-%{release}
Provides:       jre-headless = %{javaver}
Provides:       jre-openjdk-headless = %{version}-%{release}
# Standard JPackage extensions provides.
Provides:       jaas = %{version}
Provides:       java-sasl = %{version}
Provides:       jce = %{version}
Provides:       jdbc-stdext = 4.3
Provides:       jndi = %{version}
Provides:       jndi-cos = %{version}
Provides:       jndi-dns = %{version}
Provides:       jndi-ldap = %{version}
Provides:       jndi-rmi = %{version}
Provides:       jsse = %{version}
%if 0%{?suse_version} <= 1500
Provides:       java-10-openjdk-headless = %{version}-%{release}
Obsoletes:      java-10-openjdk-headless < %{version}-%{release}
%endif
%endif

%description headless
The OpenJDK %{featurever} runtime environment without audio and video support.

%package devel
Summary:        OpenJDK %{featurever} Development Environment
# Require base package.
Group:          Development/Languages/Java
Requires:       %{name} = %{version}-%{release}
# Post requires update-alternatives to install tool update-alternatives.
Requires(post): update-alternatives
# Postun requires update-alternatives to uninstall tool update-alternatives.
Requires(postun): update-alternatives
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
# Standard JPackage devel provides.
Provides:       java-%{javaver}-devel = %{version}
Provides:       java-devel = %{javaver}
Provides:       java-devel-openjdk = %{version}
Provides:       java-sdk = %{javaver}
Provides:       java-sdk-%{javaver} = %{version}
Provides:       java-sdk-%{javaver}-openjdk = %{version}
Provides:       java-sdk-openjdk = %{version}
%if 0%{?suse_version} <= 1500
Provides:       java-10-openjdk-devel = %{version}-%{release}
Obsoletes:      java-10-openjdk-devel < %{version}-%{release}
%endif
%endif

%description devel
The OpenJDK %{featurever} development tools.

%package jmods
Summary:        JMods for OpenJDK %{featurever}
Group:          Development/Languages/Java
Requires:       %{name}-devel = %{version}-%{release}
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
%if 0%{?suse_version} <= 1500
Provides:       java-10-openjdk-jmods = %{version}-%{release}
Obsoletes:      java-10-openjdk-jmods < %{version}-%{release}
%endif
%endif

%description jmods
The JMods for OpenJDK %{featurever}.

%package demo
Summary:        OpenJDK %{featurever} Demos
Group:          Development/Languages/Java
Requires:       %{name} = %{version}-%{release}
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
%if 0%{?suse_version} <= 1500
Provides:       java-10-openjdk-demo = %{version}-%{release}
Obsoletes:      java-10-openjdk-demo < %{version}-%{release}
%endif
%endif

%description demo
The OpenJDK %{featurever} demos.

%package src
Summary:        OpenJDK %{featurever} Source Bundle
Group:          Development/Languages/Java
Requires:       %{name} = %{version}-%{release}
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
%if 0%{?suse_version} <= 1500
Provides:       java-10-openjdk-src = %{version}-%{release}
Obsoletes:      java-10-openjdk-src < %{version}-%{release}
%endif
%endif

%description src
The OpenJDK %{featurever} source bundle.

%package javadoc
Summary:        OpenJDK %{featurever} API Documentation
Group:          Development/Languages/Java
Requires:       jpackage-utils
# Post requires update-alternatives to install javadoc alternative.
Requires(post): update-alternatives
# Postun requires update-alternatives to uninstall javadoc alternative.
Requires(postun): update-alternatives
BuildArch:      noarch
%if 0%{?suse_version} > 1315 || 0%{?java_bootstrap}
# Standard JPackage javadoc provides.
Provides:       java-%{javaver}-javadoc = %{version}-%{release}
Provides:       java-javadoc = %{version}-%{release}
%if 0%{?suse_version} <= 1500
Provides:       java-10-openjdk-javadoc = %{version}-%{release}
Obsoletes:      java-10-openjdk-javadoc < %{version}-%{release}
%endif
%endif

%description javadoc
The OpenJDK %{featurever} API documentation.

%prep
%setup -q -n %{openjdk_dir}
%setup -q -D -n %{openjdk_dir} -T -a 20
%setup -q -D -n %{openjdk_dir} -T -a 21
%setup -q -D -n %{openjdk_dir} -T -a 22
%setup -q -D -n %{openjdk_dir} -T -a 23
%setup -q -D -n %{openjdk_dir} -T -a 24
%setup -q -D -n %{openjdk_dir} -T -a 25
%setup -q -D -n %{openjdk_dir} -T -a 26
%setup -q -D -n %{openjdk_dir} -T -a 27
%setup -q -D -n %{openjdk_dir} -T -a 28

# Replace config.sub and config.guess with fresh versions
cp %{SOURCE100} make/autoconf/build-aux/
cp %{SOURCE101} make/autoconf/build-aux/

# Remove libraries that are linked
rm -rvf src/java.base/share/native/libzip/zlib-*
find src/java.desktop/share/native/libjavajpeg ! -name imageioJPEG.c ! -name jpegdecoder.c -type f -delete
rm -rvf src/java.desktop/share/native/libsplashscreen/libpng
rm -rvf src/java.desktop/share/native/libsplashscreen/giflib
rm -rvf src/java.desktop/share/native/liblcms/cms*
rm -rvf src/java.desktop/share/native/liblcms/lcms2*

%patch -P 3 -p1
%patch -P 4 -p1
%patch -P 5 -p1
%patch -P 8 -p1
%patch -P 10 -p1
%patch -P 12 -p1
%patch -P 13 -p1
%patch -P 14 -p1

%if %{with_system_pcsc}
%patch -P 15 -p1
%endif

%patch -P 16 -p1
%patch -P 17 -p1
%patch -P 18 -p1

%patch -P 19 -p1

%patch -P 20 -p1

%patch -P 21 -p1
%patch -P 22 -p1
%patch -P 23 -p1
%patch -P 24 -p1

%patch -P 30 -p1

# s390 build fixes

%ifarch s390
%patch -P 100 -p1
%patch -P 101 -p1
%endif

%patch -P 200 -p1

%ifarch %{arm6}
%patch -P 201
%endif

%patch -P 302 -p1
%patch -P 304 -p1

%patch -P 500
%patch -P 501

# Extract systemtap tapsets

%if %{with_systemtap}

tar -x -I xz -f %{SOURCE10}

for file in tapset/*.in; do

    OUTPUT_FILE=`echo $file | sed -e s:\.in$::g`
    sed -e s:@ABS_SERVER_LIBJVM_SO@:%{_jvmdir}/%{sdkdir}/lib/server/libjvm.so:g $file > $file.1
# TODO find out which architectures other than ix86 have a client vm

%ifarch %{ix86}
    sed -e s:@ABS_CLIENT_LIBJVM_SO@:%{_jvmdir}/%{sdkdir}/lib/client/libjvm.so:g $file.1 > $OUTPUT_FILE
%else
    sed -e '/@ABS_CLIENT_LIBJVM_SO@/d' $file.1 > $OUTPUT_FILE
%endif
    sed -i -e s:@ABS_JAVA_HOME_DIR@:%{_jvmdir}/%{sdkdir}:g $OUTPUT_FILE

done

%endif

# Prepare desktop files
for file in %{SOURCE11} ; do
    OUTPUT_FILE=`basename $file | sed -e s:\.in$::g`
    sed -e s:@JAVA_HOME@:%{_jvmdir}/%{sdkdir}:g $file > $OUTPUT_FILE
    sed -i -e s:@VERSION@:%{javaver}:g $OUTPUT_FILE
done

# Setup nss.cfg
sed -e "s:@NSS_LIBDIR@:%{NSS_LIBDIR}:g" %{SOURCE12} > nss.cfg

# Setup nss.fips.cfg
sed -e "s:@NSS_LIBDIR@:%{NSS_LIBDIR}:g" %{SOURCE13} > nss.fips.cfg
sed -i -e "s:@NSS_SECMOD@:sql\:%{_sysconfdir}/pki/nssdb:g" nss.fips.cfg

%build

%ifarch s390x sparc64 alpha ppc64 ppc64le %{aarch64}
export ARCH_DATA_MODEL=64
%endif

%ifarch alpha
export CFLAGS="$CFLAGS -mieee"
%endif

EXTRA_CFLAGS="-Wno-error"
EXTRA_CPP_FLAGS="-Wno-error"

%ifarch ppc64 ppc64le ppc
EXTRA_CFLAGS="${EXTRA_CFLAGS} -fno-strict-aliasing"
%endif

%if 0%{?suse_version} >= 1330
EXTRA_CFLAGS="${EXTRA_CFLAGS} -std=gnu11 -fno-delete-null-pointer-checks -fno-lifetime-dse -fpermissive"
EXTRA_CPP_FLAGS="${EXTRA_CPP_FLAGS} -std=gnu++98 -fno-delete-null-pointer-checks -fno-lifetime-dse"
%endif

%ifarch %{ix86}
EXTRA_CFLAGS="${EXTRA_CFLAGS} -mstackrealign -mincoming-stack-boundary=2 -mpreferred-stack-boundary=4"
EXTRA_CPP_FLAGS="${EXTRA_CPP_FLAGS} -mstackrealign -mincoming-stack-boundary=2 -mpreferred-stack-boundary=4"
%endif

mkdir -p %{buildoutputdir}

pushd %{buildoutputdir}

bash ../configure \
%if %{is_release}
    --with-version-pre="" \
%endif
    --with-version-build="%{buildver}" \
    --with-version-opt="suse-%{suse_version}-%{_arch}" \
    --disable-warnings-as-errors \
%if %{with zero}
    --with-jvm-variants=zero \
%else
%ifarch %{arm6}
    --with-jvm-variants=client \
%endif
%endif
%if %{with aot}
    --enable-aot \
%else
    --disable-aot \
%endif
    --disable-keep-packaged-modules \
    --with-debug-level=%{debugbuild} \
    --with-native-debug-symbols=internal \
    --enable-sysconf-nss \
    --with-zlib=system \
    --with-libjpeg=system \
    --with-giflib=system \
    --with-libpng=system \
    --with-lcms=system \
%if %{with_system_pcsc}
    --with-pcsclite=system \
%endif
%if %{with_system_harfbuzz}
    --with-harfbuzz=system \
%endif
    --with-stdc++lib=dynamic \
%ifarch s390
    --with-boot-jdk-jvmargs="-Xms256M -Xmx768M" \
%endif
%ifarch x86_64
    --with-jvm-features=zgc,shenandoahgc \
%endif
    --with-extra-cxxflags="${EXTRA_CPP_FLAGS}" \
    --with-extra-cflags="${EXTRA_CFLAGS}" \
    --disable-javac-server

# The combination of FULL_DEBUG_SYMBOLS=0 and ALT_OBJCOPY=/does_not_exist
# disables FDS for all build configs and reverts to pre-FDS make %{?_smp_mflags} logic.
# STRIP_POLICY=none says don't do any stripping. DEBUG_BINARIES=true says
# ignore all the other logic about which debug options and just do '-g'.

%{make} \
    JAVAC_FLAGS=-g \
    LOG=trace \
    DEBUG_BINARIES=true \
    STRIP_POLICY=no_strip \
    POST_STRIP_CMD="" \
    WARNINGS_ARE_ERRORS="-Wno-error" \
    CFLAGS_WARNINGS_ARE_ERRORS="-Wno-error" \
    %{imagestarget} docs

# remove redundant *diz and *debuginfo files
find %{imagesdir}/jdk -iname '*.diz' -exec rm {} \;
find %{imagesdir}/jdk -iname '*.debuginfo' -exec rm {} \;

popd >& /dev/null

export JAVA_HOME=$(pwd)/%{buildoutputdir}/%{imagesdir}/jdk

# Install nss.cfg right away as we will be using the JRE above
install -m 644 nss.cfg $JAVA_HOME/conf/security/

# Install nss.fips.cfg: NSS configuration for global FIPS mode (crypto-policies)
install -m 644 nss.fips.cfg $JAVA_HOME/conf/security/

%if %{add_back_javaee_modules}

# Merge back some Java EE modules removed in OpenJDK 11 by JEP 320

# Build the java.activation framework

pushd %{java_activation_repository}-%{java_activation_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find activation -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build:activation/src/main/resources $JAVA_HOME/../jmods/java.activation.jmod
popd
# Merge the java activation framework into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "java.activation,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the java.xml.bind

pushd %{java_xml_bind_repository}-%{java_xml_bind_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find jaxb-api/src/main/java/ -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build:jaxb-api/src/main/resources $JAVA_HOME/../jmods/java.xml.bind.jmod
popd
# Merge java.xml.bind into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "java.xml.bind,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the java.xml.soap

pushd %{java_xml_soap_repository}-%{java_xml_soap_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find src/main/ -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build $JAVA_HOME/../jmods/java.xml.soap.jmod
popd
# Merge java.xml.soap into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "java.xml.soap,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the java.annotation

pushd %{java_annotation_repository}-%{java_annotation_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find src/main/java -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build $JAVA_HOME/../jmods/java.annotation.jmod
popd
# Merge java.annotation into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "java.annotation,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the java.xml.ws

pushd %{java_xml_ws_repository}-%{java_xml_ws_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find api/src/main -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build:api/src/main/resources $JAVA_HOME/../jmods/java.xml.ws.jmod
popd
# Merge java.xml.ws into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "java.xml.ws,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the com.sum.xml.fastinfoset

pushd %{com_sun_xml_fastinfoset_repository}-%{com_sun_xml_fastinfoset_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find code/fastinfoset/src/main/java -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build:code/fastinfoset/src/main/resources $JAVA_HOME/../jmods/com.sun.xml.fastinfoset.jmod
popd
# Merge com.sun.xml.fastinfoset into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "com.sun.xml.fastinfoset,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the org.jvnet.staxex

pushd %{org_jvnet_staxex_repository}-%{org_jvnet_staxex_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find stax-ex/src/java -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build $JAVA_HOME/../jmods/org.jvnet.staxex.jmod
popd
# Merge org.jvnet.staxex into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "org.jvnet.staxex,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the com.sun.istack.runtime

pushd %{com_sun_istack_runtime_repository}-%{com_sun_istack_runtime_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find istack-commons/runtime/src/main/java -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build $JAVA_HOME/../jmods/com.sun.istack.runtime.jmod
popd
# Merge com.sun.istack into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "com.sun.istack.runtime,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the com.sun.xml.txw2

pushd %{jaxb_ri_repository}-%{jaxb_ri_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find jaxb-ri/txw/runtime/src/main/java -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build $JAVA_HOME/../jmods/com.sun.xml.txw2.jmod
popd
# Merge org.jvnet.staxex into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "com.sun.xml.txw2,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

# Build the com.sun.xml.bind

pushd %{jaxb_ri_repository}-%{jaxb_ri_tag}
if [ -e build ]; then rm -rf build; fi
mkdir -p build
$JAVA_HOME/bin/javac -d build `find jaxb-ri/runtime/impl/src/main/java -name \*.java | xargs`
$JAVA_HOME/bin/jmod create --do-not-resolve-by-default --class-path=build:jaxb-ri/runtime/impl/src/main/resources $JAVA_HOME/../jmods/com.sun.xml.bind.jmod
popd
# Merge org.jvnet.staxex into the JDK
source $JAVA_HOME/release; export MODULES
$JAVA_HOME/bin/jlink --module-path $JAVA_HOME/../jmods --add-modules "com.sun.xml.bind,${MODULES//\ /,}" --release-info $JAVA_HOME/release --output $JAVA_HOME/../newjdk
cp -rf $JAVA_HOME/../newjdk/* $JAVA_HOME/
rm -rf $JAVA_HOME/../newjdk

%endif # add_back_javaee_modules

# cacerts are generated in runtime in openSUSE
if [ -f %{buildoutputdir}/%{imagesdir}/jdk/lib/security/cacerts ]; then
        rm %{buildoutputdir}/%{imagesdir}/jdk/lib/security/cacerts
fi

# Check debug symbols are present and can identify code
SERVER_JVM="$JAVA_HOME/lib/server/libjvm.so"
if [ -f "$SERVER_JVM" ] ; then
  nm -aCl "$SERVER_JVM" | grep javaCalls.cpp
fi
CLIENT_JVM="$JAVA_HOME/lib/client/libjvm.so"
if [ -f "$CLIENT_JVM" ] ; then
  nm -aCl "$CLIENT_JVM" | grep javaCalls.cpp
fi
ZERO_JVM="$JAVA_HOME/lib/zero/libjvm.so"
if [ -f "$ZERO_JVM" ] ; then
  nm -aCl "$ZERO_JVM" | grep javaCalls.cpp
fi

# Check unlimited policy has been used
$JAVA_HOME/bin/javac -d . %{SOURCE14}
$JAVA_HOME/bin/java --add-opens java.base/javax.crypto=ALL-UNNAMED TestCryptoLevel

# Check ECC is working
$JAVA_HOME/bin/javac -d . %{SOURCE15}
#FIXME make it run after system NSS support?
$JAVA_HOME/bin/java $(echo $(basename %{SOURCE15})|sed "s|\.java||") || true

%install
export LANG=en_US.UTF-8
#bnc#530046
export STRIP_KEEP_SYMTAB=libjvm*
# skip /usr/lib/rpm/brp-check-bytecode-version:
export NO_BRP_CHECK_BYTECODE_VERSION=true

%if %{with_systemtap}
  # Install systemtap support files.
  install -dm 755 %{buildroot}%{_jvmdir}/%{sdkdir}/tapset
  cp -a tapset/*.stp %{buildroot}%{_jvmdir}/%{sdkdir}/tapset/
  install -d -m 755 %{buildroot}%{tapsetdir}
  pushd %{buildroot}%{tapsetdir}
    RELATIVE=$(%{abs2rel} %{_jvmdir}/%{sdkdir}/tapset %{tapsetdir})
    ln -sf $RELATIVE/*.stp .
  popd
%endif

pushd %{buildoutputdir}/%{imagesdir}/jdk

  # Install main files.
  install -d -m 755 %{buildroot}%{_jvmdir}/%{sdkdir}
  cp -a bin include lib conf release %{buildroot}%{_jvmdir}/%{sdkdir}

  # Install JCE policy symlinks.
  install -d -m 755 %{buildroot}%{_jvmprivdir}/%{archname}/jce/vanilla

  # Install versionless symlinks.
  pushd %{buildroot}%{_jvmdir}
    ln -sf %{sdkdir} %{jrelnk}
    ln -sf %{sdkdir} %{sdklnk}
  popd

  # Remove javaws man page
  rm -f man/man1/javaws*

  # Install man pages.
  install -d -m 755 %{buildroot}%{_mandir}/man1
  rm -f man/man1/javah*.1
  for manpage in man/man1/*
  do
    # Convert man pages to UTF8 encoding.
    iconv -f ISO_8859-1 -t UTF8 $manpage -o $manpage.tmp
    mv -f $manpage.tmp $manpage
    install -m 644 -p $manpage %{buildroot}%{_mandir}/man1/$(basename \
      $manpage .1)-%{sdklnk}.1
  done

  # Install demos and samples.
  cp -a demo %{buildroot}%{_jvmdir}/%{sdkdir}
  # enable short-circuit
  mkdir -p sample/rmi
  [ -f bin/java-rmi.cgi ] && mv bin/java-rmi.cgi sample/rmi
  cp -a sample %{buildroot}%{_jvmdir}/%{sdkdir}

popd

pushd %{buildoutputdir}/%{imagesdir}

  # Install jmods
  cp -a jmods %{buildroot}%{_jvmdir}/%{sdkdir}

popd

# Install Javadoc documentation.
install -d -m 755 %{buildroot}%{_javadocdir}
cp -a %{buildoutputdir}/images/docs %{buildroot}%{_javadocdir}/%{sdklnk}

# Install icons and menu entries.
for s in 16 24 32 48 ; do
  install -D -p -m 644 \
    src/java.desktop/unix/classes/sun/awt/X11/java-icon${s}.png \
    %{buildroot}%{_datadir}/icons/hicolor/${s}x${s}/apps/java-%{javaver}-openjdk.png
done

# Install desktop file.
install -d -m 0755 %{buildroot}%{_datadir}/{applications,pixmaps}
install -d -m 0755 %{buildroot}/%{_jvmdir}/%{sdkdir}/lib/desktop/
install -m 0644 jconsole.desktop %{buildroot}/%{_jvmdir}/%{sdkdir}/lib/desktop/
%suse_update_desktop_file %{buildroot}/%{_jvmdir}/%{sdkdir}/lib/desktop/jconsole.desktop

# Find demo directories.
find %{buildroot}%{_jvmdir}/%{sdkdir}/demo \
  %{buildroot}%{_jvmdir}/%{sdkdir}/sample -type d \
  | sed 's|'%{buildroot}'|%dir |' \
  > %{name}-demo.files

# FIXME: remove SONAME entries from demo DSOs.  See
# https://bugzilla.redhat.com/show_bug.cgi?id=436497

# Find non-documentation demo files.
find %{buildroot}%{_jvmdir}/%{sdkdir}/demo \
  %{buildroot}%{_jvmdir}/%{sdkdir}/sample \
  -type f -o -type l | sort \
  | grep -v README \
  | sed 's|'%{buildroot}'||' \
  >> %{name}-demo.files
# Find documentation demo files.
find %{buildroot}%{_jvmdir}/%{sdkdir}/demo \
  %{buildroot}%{_jvmdir}/%{sdkdir}/sample \
  -type f -o -type l | sort \
  | grep README \
  | sed 's|'%{buildroot}'||' \
  | sed 's|^|%doc |' \
  >> %{name}-demo.files

# fdupes links the files from JDK to JRE, so it breaks a JRE
# use it carefully :))
%fdupes -s %{buildroot}/%{_jvmdir}/%{sdkdir}/
%fdupes -s %{buildroot}/%{_jvmdir}/%{sdkdir}/demo
%fdupes -s %{buildroot}%{_javadocdir}/%{sdklnk}

%post headless
ext=.gz
update-alternatives \
  --install %{_bindir}/java java %{jrebindir}/java %{priority} \
  --slave %{_jvmdir}/jre jre %{_jvmdir}/%{jrelnk} \
  --slave %{_bindir}/jjs jjs %{jrebindir}/jjs \
  --slave %{_bindir}/keytool keytool %{jrebindir}/keytool \
  --slave %{_bindir}/rmid rmid %{jrebindir}/rmid \
  --slave %{_bindir}/rmiregistry rmiregistry %{jrebindir}/rmiregistry \
  --slave %{_mandir}/man1/java.1$ext java.1$ext \
  %{_mandir}/man1/java-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jjs.1$ext jjs.1$ext \
  %{_mandir}/man1/jjs-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/keytool.1$ext keytool.1$ext \
  %{_mandir}/man1/keytool-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/rmid.1$ext rmid.1$ext \
  %{_mandir}/man1/rmid-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/rmiregistry.1$ext rmiregistry.1$ext \
  %{_mandir}/man1/rmiregistry-%{sdklnk}.1$ext \
  || :

update-alternatives \
  --install %{_jvmdir}/jre-openjdk \
  jre_openjdk %{_jvmdir}/%{jrelnk} %{priority}
update-alternatives \
  --install %{_jvmdir}/jre-%{javaver} \
  jre_%{javaver} %{_jvmdir}/%{jrelnk} %{priority}

%postun headless
if [ $1 -eq 0 ]
then
  if test -f /proc/sys/fs/binfmt_misc/jarexec
  then
    echo '-1' > /proc/sys/fs/binfmt_misc/jarexec
  fi
  update-alternatives --remove java %{jrebindir}/java
  update-alternatives --remove jre_openjdk %{_jvmdir}/%{jrelnk}
  update-alternatives --remove jre_%{javaver} %{_jvmdir}/%{jrelnk}
fi

%posttrans headless
# bnc#781690#c11: don't trust user defined JAVA_HOME and use the current VM
# XXX: this might conflict between various versions of openjdk
export JAVA_HOME=%{_jvmdir}/%{jrelnk}

# check if the java-cacerts is a valid keystore (bnc#781690)
if [ X"`%{_bindir}/file --mime-type -b %{javacacerts}`" \
    != "Xapplication/x-java-keystore;" ]; then
%if 0%{?suse_version} <= 1310
    # workaround for bnc#847952 - pre 13.1 keyring.jar attempts to load invalid keystore and fail on it
    rm -f "%{javacacerts}"
%endif
    %{_sbindir}/update-ca-certificates
fi

# remove the default empty cacert file, if it's installed
if [ 0`stat -c "%%s" %{cacerts} 2>/dev/null` = "032" ] ; then
    rm -f %{cacerts}
fi

# if cacerts does exists, neither does not contain/point to a
# valid keystore (bnc#781690) ...
if [ X"`%{_bindir}/file --mime-type -b -L %{cacerts}`" \
    != "Xapplication/x-java-keystore;" ]; then
    # bnc#727223
    rm -f %{cacerts}
    ln -s %{javacacerts} %{cacerts}
fi

%post devel
ext=.gz
update-alternatives \
  --install %{_bindir}/javac javac %{sdkbindir}/javac %{priority} \
  --slave %{_jvmdir}/java java_sdk %{_jvmdir}/%{sdklnk} \
%if %{with aot}
  --slave %{_bindir}/jaotc jaotc %{sdkbindir}/jaotc \
%endif
  --slave %{_bindir}/jar jar %{sdkbindir}/jar \
  --slave %{_bindir}/jarsigner jarsigner %{sdkbindir}/jarsigner \
  --slave %{_bindir}/javadoc javadoc %{sdkbindir}/javadoc \
  --slave %{_bindir}/javap javap %{sdkbindir}/javap \
  --slave %{_bindir}/jcmd jcmd %{sdkbindir}/jcmd \
  --slave %{_bindir}/jconsole jconsole %{sdkbindir}/jconsole \
  --slave %{_bindir}/jdb jdb %{sdkbindir}/jdb \
  --slave %{_bindir}/jdeprscan jdeprscan %{sdkbindir}/jdeprscan \
  --slave %{_bindir}/jdeps jdeps %{sdkbindir}/jdeps \
%if ! %{with zero}
%ifnarch s390x
  --slave %{_bindir}/jhsdb jhsdb %{sdkbindir}/jhsdb \
%endif
%endif
  --slave %{_bindir}/jimage jimage %{sdkbindir}/jimage \
  --slave %{_bindir}/jinfo jinfo %{sdkbindir}/jinfo \
  --slave %{_bindir}/jlink jlink %{sdkbindir}/jlink \
  --slave %{_bindir}/jmap jmap %{sdkbindir}/jmap \
  --slave %{_bindir}/jmod jmod %{sdkbindir}/jmod \
  --slave %{_bindir}/jps jps %{sdkbindir}/jps \
  --slave %{_bindir}/jrunscript jrunscript %{sdkbindir}/jrunscript \
  --slave %{_bindir}/jshell jshell %{sdkbindir}/jshell \
  --slave %{_bindir}/jstack jstack %{sdkbindir}/jstack \
  --slave %{_bindir}/jstat jstat %{sdkbindir}/jstat \
  --slave %{_bindir}/jstatd jstatd %{sdkbindir}/jstatd \
  --slave %{_bindir}/rmic rmic %{sdkbindir}/rmic \
  --slave %{_bindir}/serialver serialver %{sdkbindir}/serialver \
  --slave %{_mandir}/man1/jar.1$ext jar.1$ext \
  %{_mandir}/man1/jar-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jarsigner.1$ext jarsigner.1$ext \
  %{_mandir}/man1/jarsigner-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/javac.1$ext javac.1$ext \
  %{_mandir}/man1/javac-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/javadoc.1$ext javadoc.1$ext \
  %{_mandir}/man1/javadoc-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/javap.1$ext javap.1$ext \
  %{_mandir}/man1/javap-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jcmd.1$ext jcmd.1$ext \
  %{_mandir}/man1/jcmd-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jconsole.1$ext jconsole.1$ext \
  %{_mandir}/man1/jconsole-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jdb.1$ext jdb.1$ext \
  %{_mandir}/man1/jdb-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jdeps.1$ext jdeps.1$ext \
  %{_mandir}/man1/jdeps-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jinfo.1$ext jinfo.1$ext \
  %{_mandir}/man1/jinfo-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jmap.1$ext jmap.1$ext \
  %{_mandir}/man1/jmap-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jps.1$ext jps.1$ext \
  %{_mandir}/man1/jps-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jrunscript.1$ext jrunscript.1$ext \
  %{_mandir}/man1/jrunscript-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jstack.1$ext jstack.1$ext \
  %{_mandir}/man1/jstack-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jstat.1$ext jstat.1$ext \
  %{_mandir}/man1/jstat-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/jstatd.1$ext jstatd.1$ext \
  %{_mandir}/man1/jstatd-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/rmic.1$ext rmic.1$ext \
  %{_mandir}/man1/rmic-%{sdklnk}.1$ext \
  --slave %{_mandir}/man1/serialver.1$ext serialver.1$ext \
  %{_mandir}/man1/serialver-%{sdklnk}.1$ext \
  --slave %{_datadir}/applications/jconsole.desktop jconsole.desktop \
  %{_jvmdir}/%{sdkdir}/lib/desktop/jconsole.desktop \
  || :

update-alternatives \
  --install %{_jvmdir}/java-openjdk \
  java_sdk_openjdk %{_jvmdir}/%{sdklnk} %{priority}
update-alternatives \
  --install %{_jvmdir}/java-%{javaver} \
  java_sdk_%{javaver} %{_jvmdir}/%{sdklnk} %{priority}

%postun devel
if [ $1 -eq 0 ]
then
  update-alternatives --remove javac %{sdkbindir}/javac
  update-alternatives --remove java_sdk_openjdk %{_jvmdir}/%{sdklnk}
  update-alternatives --remove java_sdk_%{javaver} %{_jvmdir}/%{sdklnk}
fi

%post javadoc
# in some settings, the %{_javadocdir}/%{sdklnk}/api does not exist
# and the update-alternatives call ends up in error. So, filter this
# cases out.
if [ -d %{_javadocdir}/%{sdklnk}/api ]
then
  update-alternatives \
    --install %{_javadocdir}/java javadocdir %{_javadocdir}/%{sdklnk}/api \
    %{priority}
fi

%postun javadoc
if [ $1 -eq 0 ]
then
# in some settings, the %{_javadocdir}/%{sdklnk}/api does not exist
# and the update-alternatives call ends up in error. So, filter this
# cases out.
  if [ -d %{_javadocdir}/%{sdklnk}/api ]
  then
    update-alternatives --remove javadocdir %{_javadocdir}/%{sdklnk}/api
  fi
fi

%files
%dir %{_jvmdir}/%{sdkdir}/lib
%{_jvmdir}/%{sdkdir}/lib/libawt_xawt.so
%{_jvmdir}/%{sdkdir}/lib/libjawt.so
%{_jvmdir}/%{sdkdir}/lib/libsplashscreen.so
%dir %{_datadir}/icons/hicolor
%{_datadir}/icons/hicolor/*x*/apps/java-%{javaver}-openjdk.png

%files headless
%dir %{_jvmdir}
%dir %{_jvmdir}/%{sdkdir}/
%dir %{_jvmdir}/%{sdkdir}/bin
%dir %{_jvmdir}/%{sdkdir}/lib
%dir %{_jvmdir}/%{sdkdir}/lib/jfr
%dir %{_jvmdir}/%{sdkdir}/lib/jli
%ifarch %{arm6}
%dir %{_jvmdir}/%{sdkdir}/lib/client
%else
%dir %{_jvmdir}/%{sdkdir}/lib/server
%endif
%dir %{_jvmdir}/%{sdkdir}/lib/desktop
%dir %{_jvmdir}/%{sdkdir}/lib/security

%dir %{_jvmdir}/%{sdkdir}/conf
%dir %{_jvmdir}/%{sdkdir}/conf/security
%dir %{_jvmdir}/%{sdkdir}/conf/security/policy
%dir %{_jvmdir}/%{sdkdir}/conf/security/policy/unlimited
%dir %{_jvmdir}/%{sdkdir}/conf/security/policy/limited
%dir %{_jvmdir}/%{sdkdir}/conf/management

%dir %{_jvmdir}/%{sdkdir}
%{_jvmdir}/%{jrelnk}
%{_jvmprivdir}/*

%{_jvmdir}/%{sdkdir}/release
%{_jvmdir}/%{sdkdir}/bin/java
%{_jvmdir}/%{sdkdir}/bin/jfr
%{_jvmdir}/%{sdkdir}/bin/jjs
%{_jvmdir}/%{sdkdir}/bin/keytool
%{_jvmdir}/%{sdkdir}/bin/pack200
%{_jvmdir}/%{sdkdir}/bin/rmid
%{_jvmdir}/%{sdkdir}/bin/rmiregistry
%{_jvmdir}/%{sdkdir}/bin/unpack200
%{_jvmdir}/%{sdkdir}/conf/logging.properties
%{_jvmdir}/%{sdkdir}/conf/management/jmxremote.access
%{_jvmdir}/%{sdkdir}/conf/management/jmxremote.password.template
%{_jvmdir}/%{sdkdir}/conf/management/management.properties
%{_jvmdir}/%{sdkdir}/conf/net.properties
%{_jvmdir}/%{sdkdir}/conf/security/java.policy
%{_jvmdir}/%{sdkdir}/conf/security/java.security
%{_jvmdir}/%{sdkdir}/conf/security/policy/limited/default_local.policy
%{_jvmdir}/%{sdkdir}/conf/security/policy/limited/default_US_export.policy
%{_jvmdir}/%{sdkdir}/conf/security/policy/limited/exempt_local.policy
%{_jvmdir}/%{sdkdir}/conf/security/policy/README.txt
%{_jvmdir}/%{sdkdir}/conf/security/policy/unlimited/default_local.policy
%{_jvmdir}/%{sdkdir}/conf/security/policy/unlimited/default_US_export.policy
%{_jvmdir}/%{sdkdir}/conf/sound.properties
%if ! %{with zero}
%{_jvmdir}/%{sdkdir}/lib/classlist
%endif
%{_jvmdir}/%{sdkdir}/lib/desktop/jconsole.desktop
%{_jvmdir}/%{sdkdir}/lib/jexec
%{_jvmdir}/%{sdkdir}/lib/jfr/default.jfc
%{_jvmdir}/%{sdkdir}/lib/jfr/profile.jfc
%{_jvmdir}/%{sdkdir}/lib/jli/libjli.so
%{_jvmdir}/%{sdkdir}/lib/jrt-fs.jar
%{_jvmdir}/%{sdkdir}/lib/jspawnhelper
%{_jvmdir}/%{sdkdir}/lib/jvm.cfg
%{_jvmdir}/%{sdkdir}/lib/libawt_headless.so
%{_jvmdir}/%{sdkdir}/lib/libawt.so
%{_jvmdir}/%{sdkdir}/lib/libdt_socket.so
%{_jvmdir}/%{sdkdir}/lib/libextnet.so
%{_jvmdir}/%{sdkdir}/lib/libfontmanager.so
%if ! %{with_system_harfbuzz}
%{_jvmdir}/%{sdkdir}/lib/libharfbuzz.so
%endif
%{_jvmdir}/%{sdkdir}/lib/libinstrument.so
%{_jvmdir}/%{sdkdir}/lib/libj2gss.so
%{_jvmdir}/%{sdkdir}/lib/libj2pcsc.so
%{_jvmdir}/%{sdkdir}/lib/libj2pkcs11.so
%{_jvmdir}/%{sdkdir}/lib/libjaas.so
%{_jvmdir}/%{sdkdir}/lib/libjavajpeg.so
%{_jvmdir}/%{sdkdir}/lib/libjava.so
%{_jvmdir}/%{sdkdir}/lib/libjdwp.so
%{_jvmdir}/%{sdkdir}/lib/libjimage.so
%{_jvmdir}/%{sdkdir}/lib/libjsig.so
%{_jvmdir}/%{sdkdir}/lib/libjsound.so
%{_jvmdir}/%{sdkdir}/lib/liblcms.so
%{_jvmdir}/%{sdkdir}/lib/libmanagement_agent.so
%{_jvmdir}/%{sdkdir}/lib/libmanagement_ext.so
%{_jvmdir}/%{sdkdir}/lib/libmanagement.so
%{_jvmdir}/%{sdkdir}/lib/libmlib_image.so
%{_jvmdir}/%{sdkdir}/lib/libnet.so
%{_jvmdir}/%{sdkdir}/lib/libnio.so
%{_jvmdir}/%{sdkdir}/lib/libprefs.so
%{_jvmdir}/%{sdkdir}/lib/librmi.so
%{_jvmdir}/%{sdkdir}/lib/libsctp.so
%{_jvmdir}/%{sdkdir}/lib/libsunec.so
%{_jvmdir}/%{sdkdir}/lib/libsystemconf.so
%{_jvmdir}/%{sdkdir}/lib/libunpack.so
%{_jvmdir}/%{sdkdir}/lib/libverify.so
%{_jvmdir}/%{sdkdir}/lib/libzip.so
%{_jvmdir}/%{sdkdir}/lib/modules
%{_jvmdir}/%{sdkdir}/lib/psfontj2d.properties
%{_jvmdir}/%{sdkdir}/lib/psfont.properties.ja
%{_jvmdir}/%{sdkdir}/lib/tzdb.dat
%{_jvmdir}/%{sdkdir}/lib/*/libjsig.so
%{_jvmdir}/%{sdkdir}/lib/*/libjvm.so
%{_jvmdir}/%{sdkdir}/lib/*/Xusage.txt

%config(noreplace) %{_jvmdir}/%{sdkdir}/lib/security/blocked.certs
%config(noreplace) %{_jvmdir}/%{sdkdir}/conf/security/nss.cfg
%config(noreplace) %{_jvmdir}/%{sdkdir}/conf/security/nss.fips.cfg
%{_jvmdir}/%{sdkdir}/lib/security/default.policy
%{_jvmdir}/%{sdkdir}/lib/security/public_suffix_list.dat

%{_mandir}/man1/java-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jjs-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/keytool-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/pack200-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/rmid-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/rmiregistry-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/unpack200-%{sdklnk}.1%{?ext_man}

%files devel
%dir %{_jvmdir}/%{sdkdir}/bin
%dir %{_jvmdir}/%{sdkdir}/include
%dir %{_jvmdir}/%{sdkdir}/include/linux
%dir %{_jvmdir}/%{sdkdir}/lib

%if %{with_systemtap}
%dir %{_jvmdir}/%{sdkdir}/tapset
%endif
%if %{with aot}
%{_jvmdir}/%{sdkdir}/bin/jaotc
%endif
%{_jvmdir}/%{sdkdir}/bin/jar
%{_jvmdir}/%{sdkdir}/bin/jarsigner
%{_jvmdir}/%{sdkdir}/bin/javac
%{_jvmdir}/%{sdkdir}/bin/javadoc
%{_jvmdir}/%{sdkdir}/bin/javap
%{_jvmdir}/%{sdkdir}/bin/jcmd
%{_jvmdir}/%{sdkdir}/bin/jconsole
%{_jvmdir}/%{sdkdir}/bin/jdb
%{_jvmdir}/%{sdkdir}/bin/jdeprscan
%{_jvmdir}/%{sdkdir}/bin/jdeps
%if ! %{with zero}
%ifnarch s390x
%{_jvmdir}/%{sdkdir}/bin/jhsdb
%endif
%endif
%{_jvmdir}/%{sdkdir}/bin/jimage
%{_jvmdir}/%{sdkdir}/bin/jinfo
%{_jvmdir}/%{sdkdir}/bin/jlink
%{_jvmdir}/%{sdkdir}/bin/jmap
%{_jvmdir}/%{sdkdir}/bin/jmod
%{_jvmdir}/%{sdkdir}/bin/jps
%{_jvmdir}/%{sdkdir}/bin/jrunscript
%{_jvmdir}/%{sdkdir}/bin/jshell
%{_jvmdir}/%{sdkdir}/bin/jstack
%{_jvmdir}/%{sdkdir}/bin/jstat
%{_jvmdir}/%{sdkdir}/bin/jstatd
%{_jvmdir}/%{sdkdir}/bin/rmic
%{_jvmdir}/%{sdkdir}/bin/serialver
%{_jvmdir}/%{sdkdir}/include/classfile_constants.h
%{_jvmdir}/%{sdkdir}/include/jawt.h
%{_jvmdir}/%{sdkdir}/include/jdwpTransport.h
%{_jvmdir}/%{sdkdir}/include/jni.h
%{_jvmdir}/%{sdkdir}/include/jvmticmlr.h
%{_jvmdir}/%{sdkdir}/include/jvmti.h
%{_jvmdir}/%{sdkdir}/lib/ct.sym
%{_jvmdir}/%{sdkdir}/lib/libattach.so
%if ! %{with zero}
%ifnarch s390x
%{_jvmdir}/%{sdkdir}/lib/libsaproc.so
%endif
%endif
%{_jvmdir}/%{sdkdir}/include/linux/jawt_md.h
%{_jvmdir}/%{sdkdir}/include/linux/jni_md.h

%if %{with_systemtap}
%{_jvmdir}/%{sdkdir}/tapset/*.stp
%endif
%{_jvmdir}/%{sdklnk}
%{_mandir}/man1/jar-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jarsigner-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/javac-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/javadoc-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/javap-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jcmd-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jconsole-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jdb-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jdeps-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jinfo-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jmap-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jps-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jrunscript-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jstack-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jstat-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/jstatd-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/rmic-%{sdklnk}.1%{?ext_man}
%{_mandir}/man1/serialver-%{sdklnk}.1%{?ext_man}

%if %{with_systemtap}
%{tapsetroot}
%endif

%files jmods
%dir %{_jvmdir}/%{sdkdir}/jmods
%{_jvmdir}/%{sdkdir}/jmods/*.jmod

%files demo -f %{name}-demo.files

%files src
%{_jvmdir}/%{sdkdir}/lib/src.zip

%files javadoc
%dir %{_javadocdir}
%dir %{_javadocdir}/%{sdklnk}
%{_javadocdir}/%{sdklnk}/*

%changelog
* Wed Oct 22 2025 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.29+7 (October 2025 CPU)
  * Security fixes:
    + JDK-8360937, CVE-2025-53057, bsc#1252414: Enhance certificate
    handling
    + JDK-8356294, CVE-2025-53066, bsc#1252417: Enhance Path
    Factories
    + JDK-8352637: Enhance bytecode verification
  * Other fixes:
    + JDK-8365389: Remove static color fields from SwingUtilities3
    and WindowsMenuItemUI
    + JDK-8368308: ISO 4217 Amendment 180 Update
    + JDK-8348760: RadioButton is not shown if JRadioButtonMenuItem
    is rendered with ImageIcon in WindowsLookAndFeel
    + JDK-8365375: Method SU3.setAcceleratorSelectionForeground
    assigns to acceleratorForeground
    + JDK-8348328: Update IANA Language Subtag Registry to Version
    2025-05-15
    + JDK-8348597: Update HarfBuzz to 10.4.0
    + JDK-8319197: Exclude hb-subset and hb-style from compilation
    + JDK-8312518: [macos13] setFullScreenWindow() shows black
    screen on macOS 13 & above
    + JDK-8361212: Remove AffirmTrust root CAs
    + JDK-8365811: test/jdk/java/net/CookieHandler/B6644726.java
    failure - "Should have 5 cookies. Got only 4, expires probably
    didn't parse correctly"
    + JDK-8350540: [17u,11u] B8312065.java fails Network is
    unreachable
    + JDK-8316497: ColorConvertOp - typo for non-ICC conversions
    needs one-line fix
    + JDK-8356053: Test java/awt/Toolkit/Headless/
    /HeadlessToolkit.java fails by timeout
    + JDK-8211804: Constant AO_UNUSED_MBZ uses left shift of
    negative value
    + JDK-8355051: Problemlist java/awt/Graphics2D/CopyAreaOOB.java
    on macosx-aarch64
    + JDK-8355249: Remove the use of WMIC from the entire source
    code
    + JDK-8343618: Stack smashing in awt_InputMethod.c on Linux
    s390x
    + JDK-8274453: (sctp) com/sun/nio/sctp/SctpChannel/
    /CloseDescriptors.java test should be resilient to lsof
    warnings
    + JDK-8318605: Enable parallelism in vmTestbase/nsk/stress/stack
    tests
    + JDK-8315774: Enable parallelism in vmTestbase/gc/g1/unloading
    tests
    + JDK-8322920: Some ProcessTools.execute* functions are declared
    to throw Throwable
    + JDK-8231943: ZGC: Enable serviceability/dcmd/gc/RunGCTest
    + JDK-8247362: HeapDumpCompressedTest.java#id0 fails due to
    "Multiple garbage collectors selected"
    + JDK-8340185: Use make -k on GHA to catch more build errors
    + JDK-8363965: GHA: Switch cross-compiling sysroots to Debian
    bookworm
    + JDK-8268463: Windows 32bit build fails in
    DynamicCodeGenerated\libDynamicCodeGenerated.cpp
    + JDK-8212155: Race condition when posting
    dynamic_code_generated event leads to JVM crash
    + JDK-8352942: jdk/jfr/startupargs/TestMemoryOptions.java fails
    with 32-bit build
    + JDK-8211328: Different declaration and definition of
    ClassLoaderData::classes_do() leads to build failures
    + JDK-8360816: [11u] Use default value for ProgramFiles(x86) in
    GHA
    + JDK-8358538: Update GHA Windows runner to 2025
    + JDK-8360042: GHA: Bump MSVC to 14.44
    + JDK-8357193: [VS 2022 17.14] Warning C5287 in debugInit.c:
    enum type mismatch during build
    + JDK-8345414: Google CAInterop test failures
    + JDK-8358325: Bump update version of OpenJDK: 11.0.29
* Sat Aug 30 2025 fstrba@suse.com
- Remove pack200 and unpack200 from alternatives
* Fri Aug 22 2025 fstrba@suse.com
- jdk-8354941.patch: JDK-8354941: Build failure with glibc 2.42 due to
  uabs() name collision
* Mon Jul 21 2025 fstrba@suse.com
- Do not embed rebuild counter (bsc#1246806)
* Fri Jul 18 2025 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.28+6 (July 2025 CPU)
  * CVEs
    + CVE-2025-30749, bsc#1246595
    + CVE-2025-30754, bsc#1246598
    + CVE-2025-30761, bsc#1246580
    + CVE-2025-50059, bsc#1246575
    + CVE-2025-50106, bsc#1246584
  * Changes
    + JDK-8026976: ECParameters, Point does not match field size
    + JDK-8211400: nsk.share.gc.Memory::getArrayLength returns wrong
    value
    + JDK-8231058: VerifyOops crashes with assert(_offset >= 0)
    failed: offset for non comment?
    + JDK-8232625: HttpClient redirect policy should be more
    conservative
    + JDK-8258483: [TESTBUG] gtest
    CollectorPolicy.young_scaled_initial_ergo_vm fails if heap is
    too small
    + JDK-8293345: SunPKCS11 provider checks on PKCS11 Mechanism are
    problematic
    + JDK-8296631: NSS tests failing on OL9 linux-aarch64 hosts
    + JDK-8301753: AppendFile/WriteFile has differences between make
    3.81 and 4+
    + JDK-8303770: Remove Baltimore root certificate expiring in May
    2025
    + JDK-8315380: AsyncGetCallTrace crash in frame::safe_for_sender
    + JDK-8327476: Upgrade JLine to 3.26.1
    + JDK-8328957: Update PKCS11Test.java to not use hardcoded path
    + JDK-8331959: Update PKCS#11 Cryptographic Token Interface to
    v3.1
    + JDK-8339300: CollectorPolicy.young_scaled_initial_ergo_vm
    gtest fails on ppc64 based platforms
    + JDK-8339728: [Accessibility,Windows,JAWS] Bug in the
    getKeyChar method of the AccessBridge class
    + JDK-8345133: Test sun/security/tools/jarsigner/
    /TsacertOptionTest.java failed: Warning found in stdout
    + JDK-8345625: Better HTTP connections
    + JDK-8346887: DrawFocusRect() may cause an assertion failure
    + JDK-8347629: Test FailOverDirectExecutionControlTest.java
    fails with -Xcomp
    + JDK-8348110: Update LCMS to 2.17
    + JDK-8348596: Update FreeType to 2.13.3
    + JDK-8348598: Update Libpng to 1.6.47
    + JDK-8348989: Better Glyph drawing
    + JDK-8349111: Enhance Swing supports
    + JDK-8349594: Enhance TLS protocol support
    + JDK-8350469: [11u] Test AbsPathsInImage.java fails
  - JDK-8239429 public clone
    + JDK-8350498: Remove two Camerfirma root CA certificates
    + JDK-8350991: Improve HTTP client header handling
    + JDK-8351099: Bump update version of OpenJDK: 11.0.28
    + JDK-8351422: Improve scripting supports
    + JDK-8352302: Test sun/security/tools/jarsigner/
    /TimestampCheck.java is failing
    + JDK-8352716: (tz) Update Timezone Data to 2025b
    + JDK-8356096: ISO 4217 Amendment 179 Update
    + JDK-8356571: Re-enable -Wtype-limits for GCC in LCMS
    + JDK-8359170: Add 2 TLS and 2 CS Sectigo roots
    + JDK-8360147: Better Glyph drawing redux
* Thu Apr 24 2025 hsk17@mail.de
- add -std=gnu11 to CFLAGS to fix gcc15 compile time error, and to
  still allow build on Leap 15.6
* Thu Apr 24 2025 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.27+6 (April 2025 CPU)
  * CVEs
    + CVE-2025-21587, bsc#1241274
    + CVE-2025-30691, bsc#1241275
    + CVE-2025-30698, bsc#1241276
  * Changes
    + JDK-8195675: Call to insertText with single character
    from custom Input Method ignored
    + JDK-8202926: Test java/awt/Focus/
    /WindowUpdateFocusabilityTest/
    /WindowUpdateFocusabilityTest.html fails
    + JDK-8216539: tools/jar/modularJar/Basic.java timed out
    + JDK-8268364: jmethod clearing should be done during
    unloading
    + JDK-8273914: Indy string concat changes order of
    operations
    + JDK-8294316: SA core file support is broken on macosx-x64
    starting with macOS 12.x
    + JDK-8306408: Fix the format of several tables in
    building.md
    + JDK-8309841: Jarsigner should print a warning if an entry
    is removed
    + JDK-8312049: runtime/logging/ClassLoadUnloadTest can be
    improved
    + JDK-8320916: jdk/jfr/event/gc/stacktrace/
    /TestParallelMarkSweepAllocationPendingStackTrace.java failed
    with "OutOfMemoryError: GC overhead limit exceeded"
    + JDK-8327650: Test java/nio/channels/DatagramChannel/
    /StressNativeSignal.java timed out
    + JDK-8328242: Add a log area to the PassFailJFrame
    + JDK-8331863: DUIterator_Fast used before it is constructed
    + JDK-8336012: Fix usages of jtreg-reserved properties
    + JDK-8337494: Clarify JarInputStream behavior
    + JDK-8337692: Better TLS connection support
    + JDK-8338430: Improve compiler transformations
    + JDK-8339560: Unaddressed comments during code review of
    JDK-8337664
    + JDK-8339810: Clean up the code in sun.tools.jar.Main to
    properly close resources and use ZipFile during extract
    + JDK-8339931: Update problem list for
    WindowUpdateFocusabilityTest.java
    + JDK-8340387: Update OS detection code to recognize
    Windows Server 2025
    + JDK-8341424: GHA: Collect hs_errs from build time failures
    + JDK-8342562: Enhance Deflater operations
    + JDK-8342704: GHA: Report truncation is broken after
    JDK-8341424
    + JDK-8343007: Enhance Buffered Image handling
    + JDK-8343474: [updates] Customize README.md to specifics
    of update project
    + JDK-8343599: Kmem limit and max values swapped when
    printing container information
    + JDK-8343786: [11u] GHA: Bump macOS and Xcode versions to
    macos-13 and XCode 14.3.1
    + JDK-8344589: Update IANA Language Subtag Registry to
    Version 2024-11-19
    + JDK-8345509: Bump update version of OpenJDK: 11.0.27
    + JDK-8346587: Distrust TLS server certificates anchored by
    Camerfirma Root CAs
    + JDK-8347427: JTabbedPane/8134116/Bug8134116.java has no
    license header
    + JDK-8347847: Enhance jar file support
    + JDK-8347965: (tz) Update Timezone Data to 2025a
    + JDK-8349603: [21u, 17u, 11u] Update GHA JDKs after Jan/25
    updates
    + JDK-8352097: (tz) zone.tab update missed in 2025a backport
    + JDK-8354087: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.27
* Wed Jan 22 2025 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.26+4 (January 2025 CPU)
  * Security fix
    + JDK-8330045, CVE-2025-21502, bsc#1236278: Enhance array
    handling
  * Changes
    + JDK-8224624: Inefficiencies in CodeStrings::add_comment cause
    timeouts
    + JDK-8225045: javax/swing/JInternalFrame/8146321/
    /JInternalFrameIconTest.java fails on linux-x64
    + JDK-8232367: Update Reactive Streams to 1.0.3 -- tests only
    + JDK-8247706: Unintentional use of new Date(year...) with
    absolute year
    + JDK-8299254: Support dealing with standard assert macro
    + JDK-8303920: Avoid calling out to python in
    DataDescriptorSignatureMissing test
    + JDK-8315936: Parallelize gc/stress/TestStressG1Humongous.java
    test
    + JDK-8316193: jdk/jfr/event/oldobject/TestListenerLeak.java
    java.lang.Exception: Could not find leak
    + JDK-8328300: Convert PrintDialogsTest.java from Applet to
    main program
    + JDK-8328642: Convert applet test
    MouseDraggedOutCauseScrollingTest.html to main
    + JDK-8334332: TestIOException.java fails if run by root
    + JDK-8335428: Enhanced Building of Processes
    + JDK-8335801: [11u] Backport of 8210988 to 11u removes gcc
    warnings
    + JDK-8335912, JDK-8337499: Add an operation mode to the jar
    command when extracting to not overwriting existing files
    + JDK-8336564: Enhance mask blit functionality redux
    + JDK-8338402: GHA: some of bundles may not get removed
    + JDK-8339082: Bump update version for OpenJDK: jdk-11.0.26
    + JDK-8339180: Enhanced Building of Processes: Follow-on Issue
    + JDK-8339470: [17u] More defensive fix for 8163921
    + JDK-8339637: (tz) Update Timezone Data to 2024b
    + JDK-8339644: Improve parsing of Day/Month in tzdata rules
    + JDK-8339803: Acknowledge case insensitive unambiguous
    keywords in tzdata files
    + JDK-8340552: Harden TzdbZoneRulesCompiler against missing
    zone names
    + JDK-8340671: GHA: Bump macOS and Xcode versions to macos-12
    and XCode 13.4.1
    + JDK-8340815: Add SECURITY.md file
    + JDK-8342426: [11u] javax/naming/module/RunBasic.java javac
    compile fails
    + JDK-8342629: [11u] Properly message out that shenandoah is
    disabled
    + JDK-8347483: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.26
* Mon Oct 28 2024 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.25+9 (October 2024 CPU)
  * Security fixes
    + JDK-8290367, JDK-8332643: Update default value and extend the
    scope of com.sun.jndi.ldap.object.trustSerialData system
    property
    + JDK-8307383: Enhance DTLS connections
    + JDK-8328286, CVE-2024-21208, bsc#1231702: Enhance HTTP client
    + JDK-8328544, CVE-2024-21210, bsc#1231711: Improve handling of
    vectorization
    + JDK-8328726: Better Kerberos support
    + JDK-8331446, CVE-2024-21217, bsc#1231716: Improve
    deserialization support
    + JDK-8332644, CVE-2024-21235, bsc#1231719: Improve graph
    optimizations
    + JDK-8335713: Enhance vectorization analysis
  * Other changes
    + JDK-7124313: [macosx] Swing Popups should overlap taskbar
    + JDK-7156347: javax/swing/JList/6462008/bug6462008.java fails
    + JDK-8078725: method adjustments can be done just once for all
    classes involved into redefinition
    + JDK-8205076: [17u] Inet6AddressImpl.c: 'lookupIfLocalHost'
    accesses 'int InetAddress.preferIPv6Address' as a boolean
    + JDK-8206440: Remove javac -source/-target 6 from jdk
    regression tests
    + JDK-8210338: Better output for GenerationTests.java
    + JDK-8211920: Close server socket and cleanups in
    test/jdk/javax/naming/module/RunBasic.java
    + JDK-8222005: ClassRedefinition crashes with: guarantee(false)
    failed: OLD and/or OBSOLETE method(s) found
    + JDK-8222884: ConcurrentClassDescLookup.java times out
    intermittently
    + JDK-8224081: SOCKS v4 tests require IPv4
    + JDK-8227122: [TESTBUG] Create Docker sidecar test cases
    + JDK-8229822: ThrowingPushPromises tests sometimes fail due to
    EOF
    + JDK-8231427: Warning cleanup in tests of java.io.Serializable
    + JDK-8236917: TestInstanceKlassSize.java fails with "The size
    computed by SA for java.lang.Object does not match"
    + JDK-8238169: BasicDirectoryModel getDirectories and
    DoChangeContents.run can deadlock
    + JDK-8240226: DeflateIn_InflateOut.java test incorrectly
    assumes size of compressed file
    + JDK-8242999: HTTP/2 client may not handle CONTINUATION frames
    correctly
    + JDK-8244966: Add .vscode to .hgignore and .gitignore
    + JDK-8249097: test/lib/jdk/test/lib/util/JarBuilder.java has a
    bad copyright
    + JDK-8249772: (ch) Improve
    sun/nio/ch/TestMaxCachedBufferSize.java
    + JDK-8249826: 5 javax/net/ssl/SSLEngine tests use @ignore w/o
    bug-id
    + JDK-8251188: Update LDAP tests not to use wildcard addresses
    + JDK-8253207: enable problemlists jcheck's check
    + JDK-8255898: Test java/awt/FileDialog/FilenameFilterTest/
    /FilenameFilterTest.java fails on Mac OS
    + JDK-8255913: Decrease number of iterations in
    TestMaxCachedBufferSize
    + JDK-8255969: Improve java/io/BufferedInputStream/
    /LargeCopyWithMark.java using jtreg tags
    + JDK-8259274: Increase timeout duration in
    sun/nio/ch/TestMaxCachedBufferSize.java
    + JDK-8260633: [macos] java/awt/dnd/MouseEventAfterStartDragTest/
    /MouseEventAfterStartDragTest.html test failed
    + JDK-8261433: Better pkcs11 performance for
    libpkcs11:C_EncryptInit/libpkcs11:C_DecryptInit
    + JDK-8263031: HttpClient throws Exception if it receives a
    Push Promise that is too large
    + JDK-8266149: mark hotspot compiler/startup tests which ignore
    VM flags
    + JDK-8266150: mark hotspot compiler/arguments tests which
    ignore VM flags
    + JDK-8266153: mark hotspot compiler/onSpinWait tests which
    ignore VM flags
    + JDK-8266154: mark hotspot compiler/oracle tests which ignore
    VM flags
    + JDK-8268906: gc/g1/mixedgc/TestOldGenCollectionUsage.java
    assumes that GCs take 1ms minimum
    + JDK-8269428: java/util/concurrent/ConcurrentHashMap/
    /ToArray.java timed out
    + JDK-8269616: serviceability/dcmd/framework/VMVersionTest.java
    fails with Address already in use error
    + JDK-8273135: java/awt/color/ICC_ColorSpace/
    /MTTransformReplacedProfile.java crashes in liblcms.dylib with
    NULLSeek+0x7
    + JDK-8275851: Deproblemlist open/test/jdk/javax/swing/
    /JComponent/6683775/bug6683775.java
    + JDK-8276036: The value of full_count in the message of
    insufficient codecache is wrong
    + JDK-8276306: jdk/jshell/CustomInputToolBuilder.java fails
    intermittently on storage acquisition
    + JDK-8276819: javax/print/PrintServiceLookup/
    /FlushCustomClassLoader.java fails to free
    + JDK-8279164: Disable TLS_ECDH_* cipher suites
    + JDK-8279337: The MToolkit is still referenced in a few places
    + JDK-8280392: java/awt/Focus/NonFocusableWindowTest/
    /NonfocusableOwnerTest.java failed with "RuntimeException:
    Test failed."
    + JDK-8284585: PushPromiseContinuation test fails
    intermittently in timeout
    + JDK-8286601: Mac Aarch: Excessive warnings to be ignored for
    build jdk
    + JDK-8286781: Replace the deprecated/obsolete gethostbyname
    and inet_addr calls
    + JDK-8292044: HttpClient doesn't handle 102 or 103 properly
    + JDK-8294148: Support JSplitPane for instructions and test UI
    + JDK-8294310: compare.sh fails on macos after JDK-8293550
    + JDK-8296410: HttpClient throws java.io.IOException: no
    statuscode in response for HTTP2
    + JDK-8298873: Update IllegalRecordVersion.java for changes to
    TLS implementation
    + JDK-8299058: AssertionError in sun.net.httpserver.ServerImpl
    when connection is idle
    + JDK-8299487: Test
    java/net/httpclient/whitebox/SSLTubeTestDriver.java timed out
    + JDK-8301189: validate-source fails after JDK-8298873
    + JDK-8303216: Prefer ArrayList to LinkedList in
    sun.net.httpserver.ServerImpl
    + JDK-8303965: java.net.http.HttpClient should reset the stream
    if response headers contain malformed header fields
    + JDK-8305072: Win32ShellFolder2.compareTo is inconsistent
    + JDK-8305079: Remove finalize() from compiler/c2/Test719030
    + JDK-8305081: Remove finalize() from
    test/hotspot/jtreg/compiler/runtime/Test8168712
    + JDK-8305825: getBounds API returns wrong value resulting in
    multiple Regression Test Failures on Ubuntu 23.04
    + JDK-8305906: HttpClient may use incorrect key when finding
    pooled HTTP/2 connection for IPv6 address
    + JDK-8306060: Open source few AWT Insets related tests
    + JDK-8306432: Open source several AWT Text Component related
    tests
    + JDK-8306466: Open source more AWT Drag & Drop related tests
    + JDK-8306489: Open source AWT List related tests
    + JDK-8306566: Open source several clipboard AWT tests
    + JDK-8306850: Open source AWT Modal related tests
    + JDK-8307091: A few client tests intermittently throw
    ConcurrentModificationException
    + JDK-8307779: Relax the java.awt.Robot specification
    + JDK-8308184: Launching java with large number of jars in
    classpath with java.protocol.handler.pkgs system property set
    can lead to StackOverflowError
    + JDK-8309934: Update GitHub Actions to use JDK 17 for building
    jtreg
    + JDK-8310201: Reduce verbose locale output in -XshowSettings
    launcher option
    + JDK-8311666: Disabled tests in test/jdk/sun/java2d/marlin
    + JDK-8312140: jdk/jshell tests failed with JDI socket timeouts
    + JDK-8314614: jdk/jshell/ImportTest.java failed with
    "InternalError: Failed remote listen"
    + JDK-8315422: getSoTimeout() would be in try block in
    SSLSocketImpl
    + JDK-8315437: Enable parallelism in
    vmTestbase/nsk/monitoring/stress/classload tests
    + JDK-8315442: Enable parallelism in
    vmTestbase/nsk/monitoring/stress/thread tests
    + JDK-8315804: Open source several Swing JTabbedPane JTextArea
    JTextField tests
    + JDK-8315898: Open source swing JMenu tests
    + JDK-8315965: Open source various AWT applet tests
    + JDK-8316104: Open source several Swing SplitPane and
    RadioButton related tests
    + JDK-8316211: Open source several manual applet tests
    + JDK-8316240: Open source several add/remove MenuBar manual
    tests
    + JDK-8316285: Opensource JButton manual tests
    + JDK-8316306: Open source and convert manual Swing test
    + JDK-8316328: Test jdk/jfr/event/oldobject/
    /TestSanityDefault.java times out for some heap sizes
    + JDK-8316462: sun/jvmstat/monitor/MonitoredVm/
    /MonitorVmStartTerminate.java ignores VM flags
    + JDK-8316973: GC: Make TestDisableDefaultGC use createTestJvm
    + JDK-8317039: Enable specifying the JDK used to run jtreg
    + JDK-8317228: GC: Make TestXXXHeapSizeFlags use createTestJvm
    + JDK-8317288: [macos] java/awt/Window/Grab/GrabTest.java:
    Press on the outside area didn't cause ungrab
    + JDK-8317316: G1: Make TestG1PercentageOptions use
    createTestJvm
    + JDK-8317343: GC: Make TestHeapFreeRatio use createTestJvm
    + JDK-8317358: G1: Make TestMaxNewSize use createTestJvm
    + JDK-8317807: JAVA_FLAGS removed from jtreg running in
    JDK-8317039
    + JDK-8318039: GHA: Bump macOS and Xcode versions
    + JDK-8320079: The ArabicBox.java test has no control buttons
    + JDK-8320570: NegativeArraySizeException decoding >1G UTF8
    bytes with non-ascii characters
    + JDK-8320602: Lock contention in SchemaDVFactory.getInstance()
    + JDK-8320945: problemlist tests failing on latest Windows 11
    update
    + JDK-8322330: JavadocHelperTest.java OOMEs with Parallel GC
    and ZGC
    + JDK-8323670: A few client tests intermittently throw
    ConcurrentModificationException
    + JDK-8324755: Enable parallelism in
    vmTestbase/gc/gctests/LargeObjects tests
    + JDK-8325022: Incorrect error message on client authentication
    + JDK-8325179: Race in BasicDirectoryModel.validateFileCache
    + JDK-8325862: set -XX:+ErrorFileToStderr when executing java
    in containers for some container related jtreg tests
    + JDK-8325876: crashes in docker container tests on
    Linuxppc64le Power8 machines
    + JDK-8326140: src/jdk.accessibility/windows/native/
    /libjavaaccessbridge/AccessBridgeJavaEntryPoints.cpp
    ReleaseStringChars might be missing in early returns
    + JDK-8327007: javax/swing/JSpinner/8008657/bug8008657.java
    fails
    + JDK-8327137: Add test for ConcurrentModificationException in
    BasicDirectoryModel
    + JDK-8327631: Update IANA Language Subtag Registry to Version
    2024-03-07
    + JDK-8327787: Convert javax/swing/border/Test4129681.java
    applet test to main
    + JDK-8327840: Automate javax/swing/border/Test4129681.java
    + JDK-8328011: Convert java/awt/Frame/GetBoundsResizeTest/
    /GetBoundsResizeTest.java applet test to main
    + JDK-8328110: Allow simultaneous use of PassFailJFrame with
    split UI and additional windows
    + JDK-8328115: Convert java/awt/font/TextLayout/
    /TestJustification.html applet test to main
    + JDK-8328158: Convert java/awt/Choice/NonFocusablePopupMenuTest
    to automatic main test
    + JDK-8328218: Delete test
    java/awt/Window/FindOwner/FindOwner.html
    + JDK-8328234: Remove unused nativeUtils files
    + JDK-8328238: Convert few closed manual applet tests to main
    + JDK-8328269: NonFocusablePopupMenuTest.java should be marked
    as headful
    + JDK-8328273: sun/management/jmxremote/bootstrap/
    /RmiRegistrySslTest.java failed with
    java.rmi.server.ExportException: Port already in use
    + JDK-8328560: java/awt/event/MouseEvent/ClickDuringKeypress/
    /ClickDuringKeypress.java imports Applet
    + JDK-8328561: test java/awt/Robot/ManualInstructions/
    /ManualInstructions.java isn't used
    + JDK-8328953: JEditorPane.read throws ChangedCharSetException
    + JDK-8328999: Update GIFlib to 5.2.2
    + JDK-8329004: Update Libpng to 1.6.43
    + JDK-8329013: StackOverflowError when starting Apache Tomcat
    with signed jar
    + JDK-8329103: assert(!thread->in_asgct()) failed during
    multi-mode profiling
    + JDK-8329510: Update ProblemList for
    JFileChooser/8194044/FileSystemRootTest.java
    + JDK-8329559: Test javax/swing/JFrame/bug4419914.java failed
    because The End and Start buttons are not placed correctly and
    Tab focus does not move as expected
    + JDK-8329995: Restricted access to '/proc' can cause JFR
    initialization to crash
    + JDK-8330063: Upgrade jQuery to 3.7.1
    + JDK-8330416: Update system property for Java SE specification
    maintenance version
    + JDK-8330523: Reduce runtime and improve efficiency of
    KeepAliveTest
    + JDK-8331063: Some HttpClient tests don't report leaks
    + JDK-8331263: Bump update version for OpenJDK: jdk-11.0.25
    + JDK-8331466: Problemlist serviceability/dcmd/gc/
    /RunFinalizationTest.java on generic-all
    + JDK-8331746: Create a test to verify that the cmm id is not
    ignored
    + JDK-8331798: Remove unused arg of checkErgonomics() in
    TestMaxHeapSizeTools.java
    + JDK-8332008: Enable issuestitle check
    + JDK-8332113: Update nsk.share.Log to be always verbose
    + JDK-8332424: Update IANA Language Subtag Registry to Version
    2024-05-16
    + JDK-8332524: Instead of printing "TLSv1.3," it is showing
    "TLS13"
    + JDK-8332898: failure_handler: log directory of commands
    + JDK-8332936: Test vmTestbase/metaspace/gc/watermark_70_80/
    /TestDescription.java fails with no GC's recorded
    + JDK-8333724: Problem list security/infra/java/security/cert/
    /CertPathValidator/certification/CAInterop.java
    [#]teliasonerarootcav1
    + JDK-8333804: java/net/httpclient/ForbiddenHeadTest.java threw
    an exception with 0 failures
    + JDK-8333837: [11u] HexPrinterTest.java javac compile fails
    illegal start of expression
    + JDK-8333839: [11u] LingeredAppTest.java fails Can't find
    source file: LingeredApp.java
    + JDK-8334166: Enable binary check
    + JDK-8334335: [TESTBUG] Backport of 8279164 to 11u & 17u
    includes elements of JDK-8163327
    + JDK-8334418: Update IANA Language Subtag Registry to Version
    2024-06-14
    + JDK-8334653: ISO 4217 Amendment 177 Update
    + JDK-8334711: [TEST_BUG] Compilation failed of
    MimeFormatsTest/MimeFormatsTest.java
    + JDK-8335803: SunJCE cipher throws NPE for un-extractable RSA
    keys
    + JDK-8336301: test/jdk/java/nio/channels/
    /AsyncCloseAndInterrupt.java leaves around a FIFO file upon
    test completion
    + JDK-8336928: GHA: Bundle artifacts removal broken
    + JDK-8337664: Distrust TLS server certificates issued after
    Oct 2024 and anchored by Entrust Root CAs
    + JDK-8338139: {ClassLoading,Memory}MXBean::isVerbose methods
    are inconsistent with their setVerbose methods
    + JDK-8341057: Add 2 SSL.com TLS roots
    + JDK-8341059: Change Entrust TLS distrust date to November 12,
    2024
    + JDK-8341675: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.25
- Added patches:
  * reproducible-directory-mtime.patch
    + if present, use SOURCE_DATE_EPOCH as timestamp for newly
    created directories
  * reproducible-search-index-files.patch
    + if present, use SOURCE_DATE_EPOCH as timestamp for the search
    index zip files created by javadoc
* Thu Jul 18 2024 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.24+8 (July 2024 CPU)
  * Security fixes:
    + JDK-8314794, CVE-2024-21131, bsc#1228046: Improve UTF8 String
    supports
    + JDK-8319859, CVE-2024-21138, bsc#1228047: Better symbol
    storage
    + JDK-8320097: Improve Image transformations
    + JDK-8320548, CVE-2024-21140, bsc#1228048: Improved loop
    handling
    + JDK-8322106, CVE-2024-21144, bsc#1228050: Enhance Pack 200
    loading
    + JDK-8323231, CVE-2024-21147, bsc#1228052: Improve array
    management
    + JDK-8323390: Enhance mask blit functionality
    + JDK-8324559, CVE-2024-21145, bsc#1228051: Improve 2D image
    handling
    + JDK-8325600: Better symbol storage
    + JDK-8327413: Enhance compilation efficiency
  * Other changes:
    + JDK-8015739: Background of JInternalFrame is located out of
    JInternalFrame
    + JDK-8042380: Test javax/swing/JFileChooser/4524490/
    /bug4524490.java fails with InvocationTargetException
    + JDK-8061729: Update java/net tests to eliminate dependency on
    sun.net.www.MessageHeader and some other internal APIs
    + JDK-8158048: Fix failure message from jtreg gtest wrapper
    + JDK-8159927: Add a test to verify JMOD files created in the
    images do not have debug symbols
    + JDK-8163921: HttpURLConnection default Accept header is
    malformed according to HTTP/1.1 RFC
    + JDK-8187759: Background not refreshed when painting over a
    transparent JFrame
    + JDK-8210988: Improved handling of compiler warnings in the
    build
    + JDK-8214400: Update hotspot application/jcstress jtreg tests
    wrappers to use jcstress 0.5
    + JDK-8218917: KeyEvent.getModifiers() returns inconsistent
    values for ALT keys
    + JDK-8220202: Simplify/standardize method naming for HtmlTree
    + JDK-8231351: Add notes for PKCS11 tests in the test doc
    + JDK-8241951: SA core file tests failed to find core file for
    signed binaries on OSX 10.15
    + JDK-8243010: Test support: Customizable Hex Printer
    + JDK-8248194: Need better support for running SA tests on core
    files
    + JDK-8248667: Need support for building native libraries
    located in the test/lib directory
    + JDK-8253980: javax/swing/plaf/synth/7158712/bug7158712.java
    fails on windows
    + JDK-8255031: Update java/util/prefs/AddNodeChangeListener.java
    to report more failure info
    + JDK-8256660: Disable DTLS 1.0
    + JDK-8261404: Class.getReflectionFactory() is not thread-safe
    + JDK-8263659: Reflow GTestResultParser for better readability
    + JDK-8263940: NPE when creating default file system when
    default file system provider is packaged as JAR file on class
    path
    + JDK-8264152: javax/net/ssl/DTLS/RespondToRetransmit.java
    timed out
    + JDK-8267796: vmTestbase/nsk/jvmti/scenarios/hotswap/HS201/
    /hs201t002/TestDescription.java fails with NoClassDefFoundError
    + JDK-8267938: (sctp) SCTP channel factory methods should check
    platform support
    + JDK-8268974: GetJREPath() JLI function fails to locate
    libjava.so if not standard Java launcher is used
    + JDK-8269258: java/net/httpclient/ManyRequestsLegacy.java
    failed with connection timeout
    + JDK-8270199: Most SA tests are skipped on macosx-aarch64
    because all executables are signed
    + JDK-8271142: package help is not displayed for missing
    X11/extensions/Xrandr.h
    + JDK-8273153: Consolidate file_exists into os:file_exists
    + JDK-8273831: PrintServiceLookup spawns 2 threads in the
    current classloader, getting orphaned
    + JDK-8276125: RunThese24H.java SIGSEGV in
    JfrThreadGroup::thread_group_id
    + JDK-8280546: Remove hard-coded 127.0.0.1 loopback address
    + JDK-8281507: Two javac tests have bad jtreg `@clean` tags
    + JDK-8282017: sun/net/www/protocol/https/HttpsURLConnection/
    /B6216082.java fails with "SocketException: Unexpected end of
    file from server"
    + JDK-8283349: Robustness improvements to
    java/util/prefs/AddNodeChangeListener.jar
    + JDK-8286705: GCC 12 reports use-after-free potential bugs
    + JDK-8290203: ProblemList vmTestbase/nsk/jvmti/scenarios/
    /capability/CM03/cm03t001/TestDescription.java on linux-all
    + JDK-8292716: Configure should check that jtreg is of the
    required version
    + JDK-8292717: Clean up checking of testing requirements in
    configure
    + JDK-8292763: JDK-8292716 breaks configure without jtreg
    + JDK-8293563: [macos-aarch64] SA core file tests failing with
    sun.jvm.hotspot.oops.UnknownOopException
    + JDK-8293887: AArch64 build failure with GCC 12 due to
    maybe-uninitialized warning in libfdlibm k_rem_pio2.c
    + JDK-8293965: Code signing warnings after JDK-8293550
    + JDK-8294137: Review running times of java.math tests
    + JDK-8294156: Allow PassFailJFrame.Builder to create test UI
    + JDK-8295343: sun/security/pkcs11 tests fail on Linux RHEL 8.6
    and newer
    + JDK-8297082: Remove sun/tools/jhsdb/BasicLauncherTest.java
    from problem list
    + JDK-8297449: Update JInternalFrame Metal Border code
    + JDK-8297798: Timeout with DTLSOverDatagram test template
    + JDK-8299023: TestPLABResize.java and TestPLABPromotion.java
    are failing intermittently
    + JDK-8299677: Formatter.format might take a long time to
    format an integer or floating-point
    + JDK-8299858: [Metrics] Swap memory limit reported incorrectly
    when too large
    + JDK-8302069: javax/management/remote/mandatory/notif/
    /NotifReconnectDeadlockTest.java update
    + JDK-8302512: Update IANA Language Subtag Registry to Version
    2023-02-14
    + JDK-8303466: C2: failed: malformed control flow. Limit type
    made precise with MaxL/MinL
    + JDK-8304761: Update IANA Language Subtag Registry to Version
    2023-03-22
    + JDK-8305645: System Tray icons get corrupted when Windows
    primary monitor changes
    + JDK-8305874: Open source AWT Key, Text Event related tests
    + JDK-8305931: jdk/jfr/jcmd/TestJcmdDumpPathToGCRoots.java
    failed with "Expected chains but found none"
    + JDK-8305942: Open source several AWT Focus related tests
    + JDK-8305943: Open source few AWT Focus related tests
    + JDK-8305962: update jcstress to 0.16
    + JDK-8306031: Update IANA Language Subtag Registry to Version
    2023-04-13
    + JDK-8306067: Open source AWT Graphics,GridBagLayout related
    tests
    + JDK-8306634: Open source AWT Event related tests
    + JDK-8306714: Open source few Swing event and AbstractAction
    tests
    + JDK-8306838: GetGraphicsTest needs to be headful
    + JDK-8306941: Open source several datatransfer and dnd AWT
    tests
    + JDK-8307083: Open source some drag and drop tests 3
    + JDK-8307955: Prefer to PTRACE_GETREGSET instead of
    PTRACE_GETREGS in method 'ps_proc.c::process_get_lwp_regs'
    + JDK-8308021: Update IANA Language Subtag Registry to Version
    2023-05-11
    + JDK-8310380: Handle problems in core-related tests on macOS
    when codesign tool does not work
    + JDK-8310818: Refactor more Locale tests to use JUnit
    + JDK-8310923: Refactor Currency tests to use JUnit
    + JDK-8312194: test/hotspot/jtreg/applications/ctw/modules/
    /jdk_crypto_ec.java cannot handle empty modules
    + JDK-8312383: Log X509ExtendedKeyManager implementation class
    name in TLS/SSL connection
    + JDK-8313206: PKCS11 tests silently skip execution
    + JDK-8313702: Update IANA Language Subtag Registry to Version
    2023-08-02
    + JDK-8314220: Configurable InlineCacheBuffer size
    + JDK-8314283: Support for NSS tests on aarch64 platforms
    + JDK-8314495: Update to use jtreg 7.3.1
    + JDK-8314552: Fix javadoc tests to work with jtreg 7
    + JDK-8314830: runtime/ErrorHandling/ tests ignore external VM
    flags
    + JDK-8315071: Modify TrayIconScalingTest.java,
    PrintLatinCJKTest.java to use new PassFailJFrame's builder
    pattern usage
    + JDK-8315117: Update Zlib Data Compression Library to Version
    1.3
    + JDK-8315609: Open source few more swing text/html tests
    + JDK-8315663: Open source misc awt tests
    + JDK-8315677: Open source few swing JFileChooser and other
    tests
    + JDK-8315726: Open source several AWT applet tests
    + JDK-8315741: Open source few swing JFormattedTextField and
    JPopupMenu tests
    + JDK-8315824: Open source several Swing Text/HTML related tests
    + JDK-8315834: Open source several Swing JSpinner related tests
    + JDK-8315889: Open source several Swing HTMLDocument  related
    tests
    + JDK-8316017: Refactor timeout handler in PassFailJFrame
    + JDK-8316053: Open some swing tests 3
    + JDK-8316138: Add GlobalSign 2 TLS root certificates
    + JDK-8316142: Enable parallelism in
    vmTestbase/nsk/monitoring/stress/lowmem tests
    + JDK-8316154: Opensource JTextArea manual tests
    + JDK-8316164: Opensource JMenuBar manual test
    + JDK-8316242: Opensource SwingGraphics manual test
    + JDK-8316608: Enable parallelism in vmTestbase/gc/vector tests
    + JDK-8317287: [macos14] InterJVMGetDropSuccessTest.java: Child
    VM: abnormal termination
    + JDK-8317507: C2 compilation fails with "Exceeded _node_regs
    array"
    + JDK-8318322: Update IANA Language Subtag Registry to Version
    2023-10-16
    + JDK-8318580: "javax/swing/MultiMonitor/MultimonVImage.java
    failing with Error. Can't find library:
    /open/test/jdk/java/awt/regtesthelpers" after JDK-8316053
    + JDK-8318599: HttpURLConnection cache issues leading to
    crashes in JGSS w/ native GSS introduced by 8303809
    + JDK-8318727: Enable parallelism in
    vmTestbase/vm/gc/concurrent tests
    + JDK-8318809: java/util/concurrent/ConcurrentLinkedQueue/
    /WhiteBox.java shows intermittent failures on linux ppc64le
    and aarch64
    + JDK-8318854: [macos14] Running any AWT app prints Secure
    coding warning
    + JDK-8319128: sun/security/pkcs11 tests fail on OL 7.9 aarch64
    + JDK-8319136: Skip pkcs11 tests on linux-aarch64
    + JDK-8319436: Proxy.newProxyInstance throws NPE if loader is
    null and interface not visible from class loader
    + JDK-8320005: Allow loading of shared objects with .a
    extension on AIX
    + JDK-8320113: [macos14] : ShapeNotSetSometimes.java fails
    intermittently on macOS 14
    + JDK-8320129: "top" command during jtreg failure handler does
    not display CPU usage on OSX
    + JDK-8320303: Allow PassFailJFrame to accept single window
    creator
    + JDK-8320342: Use PassFailJFrame for
    TruncatedPopupMenuTest.java
    + JDK-8320943: Files/probeContentType/Basic.java fails on
    latest Windows 11 - content type mismatch
    + JDK-8321489: Update LCMS to 2.16
    + JDK-8321925: sun/security/mscapi/KeytoolChangeAlias.java
    fails with "Alias <246810> does not exist"
    + JDK-8322239: [macos] a11y : java.lang.NullPointerException is
    thrown when focus is moved on the JTabbedPane
    + JDK-8322511: [11u] JfrCheckpointThreadClosure::do_thread
    crashes when fetching thread_id
    + JDK-8322783: prioritize /etc/os-release over
    /etc/SuSE-release in hs_err/info output
    + JDK-8323717: Introduce test keyword for tests that need
    external dependencies
    + JDK-8323994: gtest runner repeats test name for every single
    gtest assertion
    + JDK-8324238: [macOS] java/awt/Frame/ShapeNotSetSometimes/
    /ShapeNotSetSometimes.java fails with the shape has not been
    applied msg
    + JDK-8324598: use mem_unit when working with sysinfo memory
    and swap related information
    + JDK-8324632: Update Zlib Data Compression Library to Version
    1.3.1
    + JDK-8324723: GHA: Upgrade some actions to avoid deprecated
    Node 16
    + JDK-8324733: [macos14] Problem list tests which fail due to
    macOS bug described in JDK-8322653
    + JDK-8325137: com/sun/management/ThreadMXBean/
    /ThreadCpuTimeArray.java can fail in Xcomp with out of
    expected range
    + JDK-8325326: [PPC64] Don't relocate in case of allocation
    failure
    + JDK-8325579: Inconsistent behavior in
    com.sun.jndi.ldap.Connection::createSocket
    + JDK-8325972: Add -x to bash for building with LOG=debug
    + JDK-8326006: Allow TEST_VM_FLAGLESS to set flagless mode
    + JDK-8326101: [PPC64] Need to bailout cleanly if creation of
    stubs fails when code cache is out of space
    + JDK-8326201: [S390] Need to bailout cleanly if creation of
    stubs fails when code cache is out of space
    + JDK-8326351: Update the Zlib version in
    open/src/java.base/share/legal/zlib.md to 1.3.1
    + JDK-8326521: JFR: CompilerPhase event test fails on windows
    32 bit
    + JDK-8326529: JFR: Test for CompilerCompile events fails due
    to time out
    + JDK-8326591: New test JmodExcludedFiles.java fails on Windows
    when --with-external-symbols-in-bundles=public is used
    + JDK-8326638: Crash in
    PhaseIdealLoop::remix_address_expressions due to unexpected
    Region instead of Loop
    + JDK-8326643: JDK server does not send a dummy
    change_cipher_spec record after HelloRetryRequest message
    + JDK-8326661: sun/java2d/cmm/ColorConvertOp/ColConvTest.java
    assumes profiles were generated by LCMS
    + JDK-8326801: Bump update version for OpenJDK: jdk-11.0.24
    + JDK-8326891: Prefer RPATH over RUNPATH for $ORIGIN rpaths in
    internal JDK binaries
    + JDK-8326938: [11u] JDK-8214908 broke two CTW tests
    + JDK-8327136: javax/management/remote/mandatory/notif/
    /NotifReconnectDeadlockTest.java fails on libgraal
    + JDK-8328194: Add a test to check default rendering engine
    + JDK-8328524: [x86] StringRepeat.java failure on linux-x86:
    Could not reserve enough space for 2097152KB object heap
    + JDK-8328540: test javax/swing/JSplitPane/4885629/
    /bug4885629.java fails on windows hidpi
    + JDK-8328705: GHA: Cross-compilation jobs do not require build
    JDK
    + JDK-8328812: Update and move siphash license
    + JDK-8328825: Google CAInterop test failures
    + JDK-8331643: [11u]: Bump GHA bootstrap JDK to 11.0.23
    + JDK-8331750: [11u] JDK-8259530 is not backported correctly to
    11u
    + JDK-8331790: [11u] Remove problemlist entries after backport
    of JDK-8228649
    + JDK-8334441: Mark tests in jdk_security_infra group as manual
    + JDK-8335973: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.24
- Modified patch:
  * reproducible-javadoc-timestamp.patch
    + rediff to changed context
* Thu Jul  4 2024 fstrba@suse.com
- Require file for posttrans phase of the headless subpackage
  (bsc#1227298)
* Thu Jun  6 2024 fstrba@suse.com
- Added patch:
  * reproducible-jlink.patch
    + make the timestamp in jmods reproducible
* Thu Apr 18 2024 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.23+9 (April 2024 CPU)
  * Security fixes
    + JDK-8315708, CVE-2024-21012, bsc#1222987: Enhance HTTP/2
    client usage
    + JDK-8317507, JDK-8325348, CVE-2024-21094, bsc#1222986: C2
    compilation fails with "Exceeded _node_regs array"
    + JDK-8318340: Improve RSA key implementations
    + JDK-8319851, CVE-2024-21011, bsc#1222979: Improve exception
    logging
    + JDK-8322114, CVE-2024-21085, bsc#1222984: Improve Pack 200
    handling
    + JDK-8322122, CVE-2024-21068, bsc#1222983: Enhance generation
    of addresses
  * Other changes
    + JDK-6928542: Chinese characters in RTF are not decoded
    + JDK-7132796: [macosx] closed/javax/swing/JComboBox/4517214/
    /bug4517214.java fails on MacOS
    + JDK-7148092: [macosx] When Alt+down arrow key is pressed,
    the combobox popup does not appear.
    + JDK-8054022: HttpURLConnection timeouts with Expect:
    100-Continue and no chunking
    + JDK-8054572: [macosx] JComboBox paints the border incorrectly
    + JDK-8058176: [mlvm] tests should not allow code cache
    exhaustion
    + JDK-8067651: LevelTransitionTest.java, fix trivial methods
    levels logic
    + JDK-8068225: nsk/jdi/EventQueue/remove_l/remove_l005
    intermittently times out
    + JDK-8156889: ListKeychainStore.sh fails in some virtualized
    environments
    + JDK-8166275: vm/mlvm/meth/stress/compiler/deoptimize keeps
    timeouting
    + JDK-8166554: Avoid compilation blocking in
    OverloadCompileQueueTest.java
    + JDK-8169475: WheelModifier.java fails by timeout
    + JDK-8180266: Convert sun/security/provider/KeyStore/DKSTest.sh
    to Java Jtreg Test
    + JDK-8186610: move ModuleUtils to top-level testlibrary
    + JDK-8192864: defmeth tests can hide failures
    + JDK-8193543: Regression automated test '/open/test/jdk/java/
    /awt/TrayIcon/SystemTrayInstance/SystemTrayInstanceTest.java'
    fails
    + JDK-8198668: MemoryPoolMBean/isUsageThresholdExceeded/
    /isexceeded001/TestDescription.java still failing
    + JDK-8202282: [TESTBUG] appcds TestCommon
    .makeCommandLineForAppCDS() can be removed
    + JDK-8202790: DnD test DisposeFrameOnDragTest.java does not
    clean up
    + JDK-8202931: [macos] java/awt/Choice/ChoicePopupLocation/
    /ChoicePopupLocation.java fails
    + JDK-8207211: [TESTBUG] Remove excessive output from
    CDS/AppCDS tests
    + JDK-8207214: Broken links in JDK API serialized-form page
    + JDK-8207855: Make applications/jcstress invoke tests in
    batches
    + JDK-8208243: vmTestbase/gc/lock/jni/jnilock002/
    /TestDescription.java fails in jdk/hs nightly
    + JDK-8208278: [mlvm] [TESTBUG] vm.mlvm.mixed.stress.java
    .findDeadlock.INDIFY_Test Deadlocked threads are not always
    detected
    + JDK-8208623: [TESTBUG] runtime/LoadClass/LongBCP.java fails
    in AUFS file system
    + JDK-8208699: remove unneeded imports from runtime tests
    + JDK-8208704: runtime/appcds/MultiReleaseJars.java timed out
    often in hs-tier7 testing
    + JDK-8208705: [TESTBUG] The -Xlog:cds,cds+hashtables vm option
    is not always required for appcds tests
    + JDK-8209549: remove VMPropsExt from TEST.ROOT
    + JDK-8209595: MonitorVmStartTerminate.java timed out
    + JDK-8209946: [TESTBUG] CDS tests should use "@run driver"
    + JDK-8211438: [Testbug] runtime/XCheckJniJsig/XCheckJSig.java
    looks for libjsig in wrong location
    + JDK-8211978: Move  testlibrary/jdk/testlibrary/
    /SimpleSSLContext.java and testkeys to network testlibrary
    + JDK-8213622: Windows VS2013 build failure - "'snprintf':
    identifier not found"
    + JDK-8213926: WB_EnqueueInitializerForCompilation requests
    compilation for NULL
    + JDK-8213927: G1 ignores AlwaysPreTouch when
    UseTransparentHugePages is enabled
    + JDK-8214908: add ctw tests for jdk.jfr and jdk.management.jfr
    modules
    + JDK-8214915: CtwRunner misses export for jdk.internal.access
    + JDK-8216408: XMLStreamWriter setDefaultNamespace(null) throws
    NullPointerException
    + JDK-8217475: Unexpected StackOverflowError in "process
    reaper" thread
    + JDK-8218754: JDK-8068225 regression in JDIBreakpointTest
    + JDK-8219475: javap man page needs to be updated
    + JDK-8219585: [TESTBUG] sun/management/jmxremote/bootstrap/
    /JMXInterfaceBindingTest.java passes trivially when it
    shouldn't
    + JDK-8219612: [TESTBUG] compiler.codecache.stress.Helper
    .TestCaseImpl can't be defined in different runtime package as
    its nest host
    + JDK-8225471: Test utility  jdk.test.lib.util.FileUtils
    .areAllMountPointsAccessible needs to tolerate duplicates
    + JDK-8226706: (se) Reduce the number of outer loop iterations
    on Windows in java/nio/channels/Selector/RacyDeregister.java
    + JDK-8226905: unproblem list applications/ctw/modules/* tests
    on windows
    + JDK-8226910: make it possible to use jtreg's -match via
    run-test framework
    + JDK-8227438: [TESTLIB] Determine if file exists by
    Files.exists in function FileUtils.deleteFileIfExistsWithRetry
    + JDK-8231585: java/lang/management/ThreadMXBean/
    /MaxDepthForThreadInfoTest.java fails with
    java.lang.NullPointerException
    + JDK-8232839: JDI AfterThreadDeathTest.java failed due to
    "FAILED: Did not get expected IllegalThreadStateException on a
    StepRequest.enable()"
    + JDK-8233453: MLVM deoptimize stress test timed out
    + JDK-8234309: LFGarbageCollectedTest.java fails with parse
    Exception
    + JDK-8237222: [macos] java/awt/Focus/UnaccessibleChoice/
    /AccessibleChoiceTest.java fails
    + JDK-8237777: "Dumping core ..." is shown despite claiming
    that "# No core dump will be written."
    + JDK-8237834: com/sun/jndi/ldap/LdapDnsProviderTest.java
    failing with LDAP response read timeout
    + JDK-8238274: (sctp) JDK-7118373 is not fixed for SctpChannel
    + JDK-8239801: [macos] java/awt/Focus/UnaccessibleChoice/
    /AccessibleChoiceTest.java fails
    + JDK-8244679: JVM/TI GetCurrentContendedMonitor/contmon001
    failed due to "(IsSameObject#3) unexpected monitor object:
    0x000000562336DBA8"
    + JDK-8246222: Rename javac test T6395981.java to be more
    informative
    + JDK-8247818: GCC 10 warning stringop-overflow with symbol code
    + JDK-8249087: Always initialize _body[0..1] in Symbol
    constructor
    + JDK-8251349: Add TestCaseImpl to
    OverloadCompileQueueTest.java's build dependencies
    + JDK-8251904: vmTestbase/nsk/sysdict/vm/stress/btree/btree010/
    /btree010.java fails with ClassNotFoundException:
    nsk.sysdict.share.BTree0LLRLRLRRLR
    + JDK-8253543: sanity/client/SwingSet/src/
    /ButtonDemoScreenshotTest.java failed with "AssertionError:
    All pixels are not black"
    + JDK-8253739: java/awt/image/MultiResolutionImage/
    /MultiResolutionImageObserverTest.java fails
    + JDK-8253820: Save test images and dumps with timestamps from
    client sanity suite
    + JDK-8255277: randomDelay in DrainDeadlockT and
    LoggingDeadlock do not randomly delay
    + JDK-8255546: Missing coverage for
    javax.smartcardio.CardPermission and ResponseAPDU
    + JDK-8255743: Relax SIGFPE match in in
    runtime/ErrorHandling/SecondaryErrorTest.java
    + JDK-8257505: nsk/share/test/StressOptions stressTime is
    scaled in getter but not when printed
    + JDK-8259801: Enable XML Signature secure validation mode by
    default
    + JDK-8264135: UnsafeGetStableArrayElement should account for
    different JIT implementation details
    + JDK-8265349: vmTestbase/../stress/compiler/deoptimize/
    /Test.java fails with OOME due to CodeCache exhaustion.
    + JDK-8269025: jsig/Testjsig.java doesn't check exit code
    + JDK-8269077: TestSystemGC uses "require vm.gc.G1" for large
    pages subtest
    + JDK-8271094: runtime/duplAttributes/DuplAttributesTest.java
    doesn't check exit code
    + JDK-8271224: runtime/EnclosingMethodAttr/EnclMethodAttr.java
    doesn't check exit code
    + JDK-8271828: mark hotspot runtime/classFileParserBug tests
    which ignore external VM flags
    + JDK-8271829: mark hotspot runtime/Throwable tests which
    ignore external VM flags
    + JDK-8271890: mark hotspot runtime/Dictionary tests which
    ignore external VM flags
    + JDK-8272291: mark hotspot runtime/logging tests which ignore
    external VM flags
    + JDK-8272335: runtime/cds/appcds/MoveJDKTest.java doesn't
    check exit codes
    + JDK-8272551: mark hotspot runtime/modules tests which ignore
    external VM flags
    + JDK-8272552: mark hotspot runtime/cds tests which ignore
    external VM flags
    + JDK-8273803: Zero: Handle "zero" variant in
    CommandLineOptionTest.java
    + JDK-8274122: java/io/File/createTempFile/SpecialTempFile.java
    fails in Windows 11
    + JDK-8274621: NullPointerException because listenAddress[0] is
    null
    + JDK-8276796: gc/TestSystemGC.java large pages subtest fails
    with ZGC
    + JDK-8280007: Enable Neoverse N1 optimizations for Arm
    Neoverse V1 & N2
    + JDK-8281149: (fs) java/nio/file/FileStore/Basic.java  fails
    with java.lang.RuntimeException: values differ by more than
    1GB
    + JDK-8281377: Remove vmTestbase/nsk/monitoring/ThreadMXBean/
    /ThreadInfo/Deadlock/JavaDeadlock001/TestDescription.java
    from problemlist.
    + JDK-8281717: Cover logout method for several LoginModule
    + JDK-8282665: [REDO] ByteBufferTest.java: replace endless
    recursion with RuntimeException in void ck(double x, double y)
    + JDK-8284090: com/sun/security/auth/module/AllPlatforms.java
    fails to compile
    + JDK-8285756: clean up use of bad arguments for `@clean` in
    langtools tests
    + JDK-8285785: CheckCleanerBound test fails with
    PasswordCallback object is not released
    + JDK-8285867: Convert applet manual tests
    SelectionVisible.java to Frame and automate
    + JDK-8286846: test/jdk/javax/swing/plaf/aqua/
    /CustomComboBoxFocusTest.java fails on mac aarch64
    + JDK-8286969: Add a new test library API to execute kinit in
    SecurityTools.java
    + JDK-8287113: JFR: Periodic task thread uses period for method
    sampling events
    + JDK-8289511: Improve test coverage for XPath Axes: child
    + JDK-8289764: gc/lock tests failed with "OutOfMemoryError:
    Java heap space: failed reallocation of scalar replaced
    objects"
    + JDK-8289948: Improve test coverage for XPath functions: Node
    Set Functions
    + JDK-8290399: [macos] Aqua LAF does not fire an action event
    if combo box menu is displayed
    + JDK-8290909: MemoryPoolMBean/isUsageThresholdExceeded tests
    failed with "isUsageThresholdExceeded() returned false, and is
    still false, while threshold = MMMMMMM and used peak = NNNNNNN"
    + JDK-8292182: [TESTLIB] Enhance JAXPPolicyManager to setup
    required permissions for jtreg version 7 jar
    + JDK-8292946: GC lock/jni/jnilock001 test failed
    "assert(gch->gc_cause() == GCCause::_scavenge_alot ||
    !gch->incremental_collection_failed()) failed: Twice in a row"
    + JDK-8293819: sun/util/logging/PlatformLoggerTest.java failed
    with "RuntimeException: Retrieved backing PlatformLogger level
    null is not the expected CONFIG"
    + JDK-8294158: HTML formatting for PassFailJFrame instructions
    + JDK-8294254: [macOS] javax/swing/plaf/aqua/
    /CustomComboBoxFocusTest.java failure
    + JDK-8294402: Add diagnostic logging to
    VMProps.checkDockerSupport
    + JDK-8294535: Add screen capture functionality to
    PassFailJFrame
    + JDK-8296083: javax/swing/JTree/6263446/bug6263446.java fails
    intermittently on a VM
    + JDK-8296384: [TESTBUG] sun/security/provider/SecureRandom/
    /AbstractDrbg/SpecTest.java intermittently timeout
    + JDK-8299494: Test vmTestbase/nsk/stress/except/except011.java
    failed: ExceptionInInitializerError: target class not found
    + JDK-8300269: The selected item in an editable JComboBox with
    titled border is not visible in Aqua LAF
    + JDK-8300727: java/awt/List/ListGarbageCollectionTest/
    /AwtListGarbageCollectionTest.java failed with "List wasn't
    garbage collected"
    + JDK-8301310: The SendRawSysexMessage test may cause a JVM
    crash
    + JDK-8301377: adjust timeout for JLI
    GetObjectSizeIntrinsicsTest.java subtest again
    + JDK-8301846: Invalid TargetDataLine after screen lock when
    using JFileChooser or COM library
    + JDK-8302017: Allocate BadPaddingException only if it will be
    thrown
    + JDK-8302109: Trivial fixes to btree tests
    + JDK-8302149: Speed up
    compiler/jsr292/methodHandleExceptions/TestAMEnotNPE.java
    + JDK-8302607: increase timeout for
    ContinuousCallSiteTargetChange.java
    + JDK-8304074: [JMX] Add an approximation of total bytes
    allocated on the Java heap by the JVM
    + JDK-8304314: StackWalkTest.java fails after CODETOOLS-7903373
    + JDK-8304725: AsyncGetCallTrace can cause SIGBUS on M1
    + JDK-8305502: adjust timeouts in three more M&M tests
    + JDK-8305505: NPE in javazic compiler
    + JDK-8305972: Update XML Security for Java to 3.0.2
    + JDK-8306072: Open source several AWT MouseInfo related tests
    + JDK-8306076: Open source AWT misc tests
    + JDK-8306409: Open source AWT KeyBoardFocusManger,
    LightWeightComponent related tests
    + JDK-8306640: Open source several AWT TextArea related tests
    + JDK-8306652: Open source AWT MenuItem related tests
    + JDK-8306681: Open source more AWT DnD related tests
    + JDK-8306683: Open source several clipboard and color AWT tests
    + JDK-8306752: Open source several container and component AWT
    tests
    + JDK-8306753: Open source several container AWT tests
    + JDK-8306755: Open source few Swing JComponent and
    AbstractButton tests
    + JDK-8306812: Open source several AWT Miscellaneous tests
    + JDK-8306871: Open source more AWT Drag & Drop tests
    + JDK-8306996: Open source Swing MenuItem related tests
    + JDK-8307123: Fix deprecation warnings in DPrinter
    + JDK-8307130: Open source few Swing JMenu tests
    + JDK-8307299: Move more DnD tests to open
    + JDK-8307311: Timeouts on one macOS 12.6.1 host of two Swing
    JTableHeader tests
    + JDK-8307381: Open Source JFrame, JIF related Swing Tests
    + JDK-8307683: Loop Predication should not hoist range checks
    with trap on success projection by negating their condition
    + JDK-8308043: Deadlock in TestCSLocker.java due to blocking GC
    while allocating
    + JDK-8308116: jdk.test.lib.compiler.InMemoryJavaCompiler
    .compile does not close files
    + JDK-8308223: failure handler missed jcmd.vm.info command
    + JDK-8308232: nsk/jdb tests don't pass -verbose flag to the
    debuggee
    + JDK-8308245: Add -proc:full to describe current default
    annotation processing policy
    + JDK-8308336: Test java/net/HttpURLConnection/
    /HttpURLConnectionExpectContinueTest.java failed:
    java.net.BindException: Address already in use
    + JDK-8309104: [JVMCI] compiler/unsafe/
    /UnsafeGetStableArrayElement test asserts wrong values with
    Graal
    + JDK-8309119: [17u/11u] Redo JDK-8297951: C2: Create skeleton
    predicates for all If nodes in loop predication
    + JDK-8309462: [AIX] vmTestbase/nsk/jvmti/RunAgentThread/
    /agentthr001/TestDescription.java crashing due to empty while
    loop
    + JDK-8309778: java/nio/file/Files/CopyAndMove.java fails when
    using second test directory
    + JDK-8309870: Using -proc:full should be considered requesting
    explicit annotation processing
    + JDK-8310106: sun.security.ssl.SSLHandshake
    .getHandshakeProducer() incorrectly checks handshakeConsumers
    + JDK-8310238: [test bug] javax/swing/JTableHeader/6889007/
    /bug6889007.java fails
    + JDK-8310551: vmTestbase/nsk/jdb/interrupt/interrupt001/
    /interrupt001.java timed out due to missing prompt
    + JDK-8310807: java/nio/channels/DatagramChannel/Connect.java
    timed out
    + JDK-8311081: KeytoolReaderP12Test.java fail on localized
    Windows platform
    + JDK-8311511: Improve description of NativeLibrary JFR event
    + JDK-8311585: Add JRadioButtonMenuItem to bug8031573.java
    + JDK-8313081: MonitoringSupport_lock should be unconditionally
    initialized after 8304074
    + JDK-8313082: Enable CreateCoredumpOnCrash for testing in
    makefiles
    + JDK-8313164: src/java.desktop/windows/native/libawt/windows/
    /awt_Robot.cpp GetRGBPixels adjust releasing of resources
    + JDK-8313252: Java_sun_awt_windows_ThemeReader_paintBackground
    release resources in early returns
    + JDK-8313643: Update HarfBuzz to 8.2.2
    + JDK-8313816: Accessing jmethodID might lead to spurious
    crashes
    + JDK-8314144: gc/g1/ihop/TestIHOPStatic.java fails due to
    extra concurrent mark with -Xcomp
    + JDK-8314164: java/net/HttpURLConnection/
    /HttpURLConnectionExpectContinueTest.java fails intermittently
    in timeout
    + JDK-8314883:
    Java_java_util_prefs_FileSystemPreferences_lockFile0 write
    result errno in missing case
    + JDK-8315034: File.mkdirs() occasionally fails to create
    folders on Windows shared folder
    + JDK-8315042: NPE in PKCS7.parseOldSignedData
    + JDK-8315415: OutputAnalyzer.shouldMatchByLine() fails in some
    cases
    + JDK-8315499: build using devkit on Linux ppc64le RHEL puts
    path to devkit into libsplashscreen
    + JDK-8315594: Open source few headless Swing misc tests
    + JDK-8315600: Open source few more headless Swing misc tests
    + JDK-8315602: Open source swing security manager test
    + JDK-8315606: Open source few swing text/html tests
    + JDK-8315611: Open source swing text/html and tree test
    + JDK-8315680: java/lang/ref/ReachabilityFenceTest.java should
    run with -Xbatch
    + JDK-8315731: Open source several Swing Text related tests
    + JDK-8315761: Open source few swing JList and JMenuBar tests
    + JDK-8315986: [macos14] javax/swing/JMenuItem/4654927/
    /bug4654927.java: component must be showing on the screen to
    determine its location
    + JDK-8316001: GC: Make TestArrayAllocatorMallocLimit use
    createTestJvm
    + JDK-8316028: Update FreeType to 2.13.2
    + JDK-8316030: Update Libpng to 1.6.40
    + JDK-8316106: Open source few swing JInternalFrame and
    JMenuBar tests
    + JDK-8316461: Fix: make test outputs TEST SUCCESS after
    unsuccessful exit
    + JDK-8316947: Write a test to check textArea triggers
    MouseEntered/MouseExited events properly
    + JDK-8317307: test/jdk/com/sun/jndi/ldap/
    /LdapPoolTimeoutTest.java fails with ConnectException:
    Connection timed out: no further information
    + JDK-8317327: Remove JT_JAVA dead code in jib-profiles.js
    + JDK-8318154: Improve stability of WheelModifier.java test
    + JDK-8318410: jdk/java/lang/instrument/BootClassPath/
    /BootClassPathTest.sh fails on Japanese Windows
    + JDK-8318468: compiler/tiered/LevelTransitionTest.java fails
    with -XX:CompileThreshold=100 -XX:TieredStopAtLevel=1
    + JDK-8318603: Parallelize sun/java2d/marlin/ClipShapeTest.java
    + JDK-8318607: Enable parallelism in vmTestbase/nsk/stress/jni
    tests
    + JDK-8318608: Enable parallelism in
    vmTestbase/nsk/stress/threads tests
    + JDK-8318736: com/sun/jdi/JdwpOnThrowTest.java failed with
    "transport error 202: bind failed: Address already in use"
    + JDK-8318889: C2: add bailout after assert Bad graph detected
    in build_loop_late
    + JDK-8318951: Additional negative value check in JPEG decoding
    + JDK-8318955: Add ReleaseIntArrayElements in
    Java_sun_awt_X11_XlibWrapper_SetBitmapShape XlbWrapper.c to
    early return
    + JDK-8318971: Better Error Handling for Jar Tool When
    Processing Non-existent Files
    + JDK-8318983: Fix comment typo in PKCS12Passwd.java
    + JDK-8319124: Update XML Security for Java to 3.0.3
    + JDK-8319456: jdk/jfr/event/gc/collection/
    /TestGCCauseWith[Serial|Parallel].java : GC cause 'GCLocker
    Initiated GC' not in the valid causes
    + JDK-8319668: Fixup of jar filename typo in BadFactoryTest.sh
    + JDK-8320001: javac crashes while adding type annotations to
    the return type of a constructor
    + JDK-8320208: Update Public Suffix List to b5bf572
    + JDK-8320363: ppc64 TypeEntries::type_unknown logic looks
    wrong, missed optimization opportunity
    + JDK-8320597: RSA signature verification fails on signed data
    that does not encode params correctly
    + JDK-8320798: Console read line with zero out should zero out
    underlying buffer
    + JDK-8320884: Bump update version for OpenJDK: jdk-11.0.23
    + JDK-8320937: support latest VS2022 MSC_VER in
    abstract_vm_version.cpp
    + JDK-8321151: JDK-8294427 breaks Windows L&F on all older
    Windows versions
    + JDK-8321215: Incorrect x86 instruction encoding for VSIB
    addressing mode
    + JDK-8321408: Add Certainly roots R1 and E1
    + JDK-8321480: ISO 4217 Amendment 176 Update
    + JDK-8322178: Error. can't find jdk.testlibrary
    .SimpleSSLContext in test directory or libraries
    + JDK-8322417: Console read line with zero out should zero out
    when throwing exception
    + JDK-8322725: (tz) Update Timezone Data to 2023d
    + JDK-8322750: Test "api/java_awt/interactive/
    /SystemTrayTests.html" failed because A blue ball icon is
    added outside of the system tray
    + JDK-8322752: [11u] GetStackTraceAndRetransformTest.java is
    failing assert
    + JDK-8322772: Clean up code after JDK-8322417
    + JDK-8323008: filter out harmful -std* flags added by autoconf
    from CXX
    + JDK-8323243: JNI invocation of an abstract instance method
    corrupts the stack
    + JDK-8323515: Create test alias "all" for all test roots
    + JDK-8323640: [TESTBUG]testMemoryFailCount in jdk/internal/
    /platform/docker/TestDockerMemoryMetrics.java always fail
    because OOM killed
    + JDK-8324184: Windows VS2010 build failed with "error C2275:
    'int64_t'"
    + JDK-8324307: [11u] hotspot fails to build with GCC 12 and
    newer (non-static data member initializers)
    + JDK-8324347: Enable "maybe-uninitialized" warning for
    FreeType 2.13.1
    + JDK-8324659: GHA: Generic jtreg errors are not reported
    + JDK-8325096: Test java/security/cert/CertPathBuilder/akiExt/
    /AKISerialNumber.java is failing
    + JDK-8325150: (tz) Update Timezone Data to 2024a
    + JDK-8326109: GCC 13 reports maybe-uninitialized warnings for
    jni.cpp with dtrace enabled
    + JDK-8326503: [11u] java/net/HttpURLConnection/
    /HttpURLConnectionExpectContinueTest.java fail because of
    package org.junit.jupiter.api does not exist
    + JDK-8327391: Add SipHash attribution file
    + JDK-8329837: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.23
* Thu Mar  7 2024 fstrba@suse.com
- Removed patch:
  * alternative-tzdb_dat.patch
    + Remove the possibility to use the system timezone-java. It
    creates more problems then it solves (bsc#1213470)
* Tue Feb 20 2024 fstrba@suse.com
- Use %%patch -P N instead of deprecated %%patchN.
* Thu Jan 18 2024 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.22+7 (January 2024 CPU)
  * Security fixes
    + JDK-8308204: Enhanced certificate processing
    + JDK-8314295, CVE-2024-20919, bsc#1218903: Enhance
    verification of verifier
    + JDK-8314284, CVE-2024-20926, bsc#1218906: Enhance Nashorn
    performance
    + JDK-8314307, CVE-2024-20921, bsc#1218905: Improve loop
    handling
    + JDK-8314468, CVE-2024-20918, bsc#1218907: Improve Compiler
    loops
    + JDK-8316976, CVE-2024-20945, bsc#1218909: Improve signature
    handling
    + JDK-8317547, CVE-2024-20952, bsc#1218911: Enhance TLS
    connection support
  * Other fixes
    + JDK-6381945: (cal) Japanese calendar unit test system should
    avoid multiple static imports
    + JDK-6445283: ProgressMonitorInputStream not large file aware
    (>2GB)
    + JDK-8026393: jarsigner never shows a warning in badKeyUsage
    case
    + JDK-8041447: Test javax/swing/dnd/7171812/bug7171812.java
    fails with java.lang.RuntimeException: Test failed, scroll on
    drag doesn't work
    + JDK-8053479: (dc) DatagramChannel.read() throws exception
    instead of discarding data when buffer too small
    + JDK-8067250: [mlvm] vm/mlvm/mixed/stress/regression/b6969574
    fails and perf regression
    + JDK-8153090: TAB key cannot change input focus after the
    radio button in the Color Selection dialog
    + JDK-8168408: Test java/awt/Focus/ActualFocusedWindowTest/
    /ActualFocusedWindowBlockingTest.java fails intermittentently
    on windows
    + JDK-8183374: Refactor java/lang/Runtime shell tests to java
    + JDK-8185531: [TESTBUG] Improve test configuration for shared
    strings
    + JDK-8195589: T6587786.java failed after JDK-8189997
    + JDK-8197825: [Test] Intermittent timeout with javax/swing
    JColorChooser Test
    + JDK-8205467: javax/management/remote/mandatory/connection/
    /MultiThreadDeadLockTest.java possible deadlock
    + JDK-8207166: jdk/jshell/
    /JdiHangingLaunchExecutionControlTest.java - launch timeout
    + JDK-8210168: JCK test .vm.classfmt.ins.code__002.code__00201m1
    .code__00201m1 hangs with -noverify
    + JDK-8210265: Crash in HSpaceCounters::update_used()
    + JDK-8211045: [Testbug] Fix for 8144279 didn't define a test
    case!
    + JDK-8212997: [TESTBUG] Remove defmeth tests for class file
    versions 50 and 51
    + JDK-8213898: CDS dumping of springboot asserts in
    G1ArchiveAllocator::alloc_new_region
    + JDK-8214694: cleanup rawtypes warnings in open jndi tests
    + JDK-8217329: JTREG: Clean up, remove unused imports in gc
    folder
    + JDK-8218178: vmTestbase/vm/mlvm/mixed/stress/regression/
    /b6969574/INDIFY_Test.java fails with -Xcomp
    + JDK-8220083: Remove hard-coded 127.0.0.1 loopback address in
    JDK networking tests
    + JDK-8221396: Clean up serviceability/sa/TestUniverse.java
    + JDK-8223145: Replace wildcard address with loopback or local
    host in tests - part 1
    + JDK-8223788: [macos] JSpinner buttons in JColorChooser dialog
    may capture focus using TAB Key.
    + JDK-8224035: Replace wildcard address with loopback or local
    host in tests - part 9
    + JDK-8224204: Replace wildcard address with loopback or local
    host in tests - part 10
    + JDK-8226825: Replace wildcard address with loopback or local
    host in tests - part 19
    + JDK-8230435: Replace wildcard address with loopback or local
    host in tests - part 22
    + JDK-8230858: Replace wildcard address with loopback or local
    host in tests - part 23
    + JDK-8231556: Wrong font ligatures used when 2 versions of
    same font used
    + JDK-8231931: [TESTBUG] serviceability/sa/TestUniverse.java
    looks for wrong string with Shenandoah
    + JDK-8232135: Add diagnostic output to test
    java/util/ProcessBuilder/Basic.java
    + JDK-8232513: java/net/DatagramSocket/PortUnreachable.java
    still fails intermittently with BindException
    + JDK-8232933: Javac inferred type does not conform to equality
    constraint
    + JDK-8233000: Mark vmTestbase/vm/mlvm/meth/stress/compiler/
    /deoptimize test as stress test
    + JDK-8233847: (sctp) Flx link-local IPv6 scope handling and
    test cleanup.
    + JDK-8237858: PlainSocketImpl.socketAccept() handles EINTR
    incorrectly
    + JDK-8238740: java/net/httpclient/whitebox/FlowTestDriver.java
    should not specify a TLS protocol
    + JDK-8240235: jdk.test.lib.util.JarUtils updates jar files
    incorrectly
    + JDK-8240604: Rewrite sun/management/jmxremote/bootstrap/
    /CustomLauncherTest.java test to make binaries from source
    file
    + JDK-8240754: Instrument FlowTest.java to provide more debug
    traces.
    + JDK-8242330: Arrays should be cloned in several JAAS Callback
    classes
    + JDK-8244508: JFR: FlightRecorderOptions reset date format
    + JDK-8249812: java/net/DatagramSocket/PortUnreachable.java
    still fails intermittently with SocketTimeoutException
    + JDK-8251177: [macosx] The text "big" is truncated in
    JTabbedPane
    + JDK-8252713: jtreg time out of CtrlASCII.java seems to hang
    the Xserver.
    + JDK-8254711: Add java.security.Provider.getService JFR Event
    + JDK-8255548: Missing coverage for
    javax.xml.crypto.dom.DOMCryptoContext
    + JDK-8258914: javax/net/ssl/DTLS/RespondToRetransmit.java
    timed out
    + JDK-8259266: com/sun/jdi/JdbOptions.java failed with
    "RuntimeException: 'prop[boo] = >foo 2<' missing from
    stdout/stderr"
    + JDK-8260035: Deproblemlist few problemlisted test
    + JDK-8260431: com/sun/jdi/JdbOptions.java failed with
    "RuntimeException: 'prop[boo] = >foo<' missing from
    stdout/stderr"
    + JDK-8263530: sun.awt.X11.ListHelper.removeAll() should use
    clear()
    + JDK-8265586: [windows] last button is not shown in AWT Frame
    with BorderLayout and MenuBar set.
    + JDK-8265678: Test java/awt/Focus/ActualFocusedWindowTest/
    /ActualFocusedWindowBlockingTest.java fails intermittentently
    on windows
    + JDK-8266249: javax/swing/JPopupMenu/7156657/bug7156657.java
    fails on macOS
    + JDK-8267860: Off-by-one bug when searching arrays in
    AlpnGreaseTest
    + JDK-8268916: Tests for AffirmTrust roots
    + JDK-8271519: java/awt/event/SequencedEvent/
    /MultipleContextsFunctionalTest.java failed with
    "Total [200] - Expected [400]"
    + JDK-8273804: Platform.isTieredSupported should handle the
    no-compiler case
    + JDK-8275329: ZGC: vmTestbase/gc/gctests/SoftReference/soft004/
    /soft004.java fails with assert(_phases->length() <= 1000)
    failed: Too many recored phases?
    + JDK-8275333: Print count in "Too many recored phases?" assert
    + JDK-8278456: Define jtreg jdk_desktop test group time-based
    sub-tasks for use by headful testing.
    + JDK-8280004: DCmdArgument<jlong>::parse_value() should handle
    NULL input
    + JDK-8282143: Objects.requireNonNull should be ForceInline
    + JDK-8282404: DrawStringWithInfiniteXform.java failed with
    "RuntimeException: drawString with InfiniteXform transform
    takes long time"
    + JDK-8284331: Add sanity check for signal handler modification
    warning.
    + JDK-8285612: Remove jtreg tag manual=yesno for
    java/awt/print/PrinterJob/ImagePrinting/ClippedImages.java
    + JDK-8285687: Remove jtreg tag manual=yesno for
    java/awt/print/PrinterJob/PageRangesDlgTest.java
    + JDK-8286707: JFR: Don't commit JFR internal
    jdk.JavaMonitorWait events
    + JDK-8288325: [windows] Actual and Preferred Size of AWT
    Non-resizable frame are different
    + JDK-8288415: java/awt/PopupMenu/PopupMenuLocation.java is
    unstable in MacOS machines
    + JDK-8288993: Make AwtFramePackTest generic by removing
    @requires tag
    + JDK-8289077: Add manual tests to open
    + JDK-8289238: Refactoring changes to PassFailJFrame Test
    Framework
    + JDK-8289547: Update javax/swing/Popup/TaskbarPositionTest.java
    + JDK-8289584: (fs) Print size values in
    java/nio/file/FileStore/Basic.java when they differ by > 1GiB
    + JDK-8289745: JfrStructCopyFailed uses heap words instead of
    bytes for object sizes
    + JDK-8289917: Metadata for regionsRefilled of
    G1EvacuationStatistics event is wrong
    + JDK-8290067: Show stack dimensions in UL logging when
    attaching threads
    + JDK-8290469: Add new positioning options to PassFailJFrame
    test framework
    + JDK-8292407: Improve Weak CAS VarHandle/Unsafe tests
    resilience under spurious failures
    + JDK-8292683: Remove BadKeyUsageTest.java from Problem List
    + JDK-8292713: Unsafe.allocateInstance should be intrinsified
    without UseUnalignedAccesses
    + JDK-8293098: GHA: Harmonize GCC version handling for host and
    cross builds
    + JDK-8293107: GHA: Bump to Ubuntu 22.04
    + JDK-8293166: jdk/jfr/jvm/TestDumpOnCrash.java fails on Linux
    ppc64le and Linux aarch64
    + JDK-8293361: GHA: dump config.log in case of configure failure
    + JDK-8293466: libjsig should ignore non-modifying sigaction
    calls
    + JDK-8293811: Provide a reason for PassFailJFrame.forceFail
    + JDK-8294281: Allow warnings to be disabled on a per-file basis
    + JDK-8294427: Check boxes and radio buttons have rendering
    issues on Windows in High DPI env
    + JDK-8294673: JFR: Add SecurityProviderService#threshold to
    TestActiveSettingEvent.java
    + JDK-8294941: GHA: Cut down cross-compilation sysroots
    + JDK-8294956: GHA: qemu-debootstrap is deprecated, use the
    regular one
    + JDK-8295213: Run GHA manually with user-specified make and
    configure arguments
    + JDK-8295885: GHA: Bump gcc versions 8313428: GHA: Bump GCC
    versions for July 2023 updates
    + JDK-8296275: Write a test to verify setAccelerator  method of
    JMenuItem
    + JDK-8297296: java/awt/Mouse/EnterExitEvents/
    /DragWindowTest.java fails with "No MouseReleased event on
    label!"
    + JDK-8297640: Increase buffer size for buf
    (insert_features_names) in
    Abstract_VM_Version::insert_features_names
    + JDK-8298905: Test "java/awt/print/PrinterJob/ImagePrinting/
    /PrintARGBImage.java" fails because the frames of instruction
    does not display
    + JDK-8299255: Unexpected round errors in FreetypeFontScaler
    + JDK-8299330: Minor improvements in MSYS2 Workflow handling
    + JDK-8300259: Add test coverage for processing of pending
    block files in signed JARs
    + JDK-8300272: Improve readability of the test
    JarWithOneNonDisabledDigestAlg
    + JDK-8300405: Screen capture for test
    JFileChooserSetLocationTest.java, failure case
    + JDK-8301065: Handle control characters in
    java_lang_String::print
    + JDK-8301167: Update VerifySignedJar to actually exercise and
    test verification
    + JDK-8301570: Test  runtime/jni/nativeStack/ needs to detach
    the native thread
    + JDK-8302017: Allocate BadPaddingException only if it will be
    thrown
    + JDK-8302525: Write a test to check various components send
    Events while mouse and key are used simultaneously
    + JDK-8303607: SunMSCAPI provider leaks memory and keys
    + JDK-8306134: Open source some AWT tests relating to Button
    and a few other classes
    + JDK-8306135: Clean up and open source some AWT tests
    + JDK-8306280: Open source several choice AWT tests
    + JDK-8306372: Open source AWT CardLayout and Checkbox tests
    + JDK-8306430: Open source some AWT tests related to
    TextComponent and Toolkit
    + JDK-8306575: Clean up and open source four Dialog related
    tests
    + JDK-8306765: Some client related jtreg problem list entries
    are malformed
    + JDK-8306883: Thread stacksize is reported with wrong units in
    os::create_thread logging
    + JDK-8307079: Update test java/awt/Choice/DragOffNoSelect.java
    + JDK-8307165: java/awt/dnd/NoFormatsDropTest/
    /NoFormatsDropTest.java timed out
    + JDK-8308592: Framework for CA interoperability testing
    + JDK-8308910: Allow executeAndLog to accept running process
    + JDK-8309095: Remove UTF-8 character from
    TaskbarPositionTest.java
    + JDK-8310265: (process) jspawnhelper should not use argv[0]
    + JDK-8310549: avoid potential leaks in KeystoreImpl.m related
    to JNU_CHECK_EXCEPTION early returns
    + JDK-8311285: report some fontconfig related environment
    variables in hs_err file
    + JDK-8311813: C1: Uninitialized PhiResolver::_loop field
    + JDK-8312065: Socket.connect does not timeout when profiling
    + JDK-8312126: NullPointerException in CertStore.getCRLs after
    8297955
    + JDK-8312489: Increase jdk.jar.maxSignatureFileSize default
    which is too low for JARs such as WhiteSource/Mend unified
    agent jar
    + JDK-8312535: MidiSystem.getSoundbank() throws unexpected
    SecurityException
    + JDK-8312573: Failure during CompileOnly parsing leads to
    ShouldNotReachHere
    + JDK-8312972: Bump update version for OpenJDK: jdk-11.0.22
    + JDK-8313576: GCC 7 reports compiler warning in bundled
    freetype 2.13.0
    + JDK-8313626: C2 crash due to unexpected exception control flow
    + JDK-8313657: com.sun.jndi.ldap.Connection.cleanup does not
    close connections on SocketTimeoutErrors
    + JDK-8313691: use close after failing os::fdopen in vmError
    and ciEnv
    + JDK-8313707: GHA: Bootstrap sysroots with --variant=minbase
    + JDK-8313792: Verify 4th party information in
    src/jdk.internal.le/share/legal/jline.md
    + JDK-8313815: The exception messages printed by jcmd
    ManagementAgent.start are corrupted on Japanese Windows
    + JDK-8314063: The socket is not closed in
    Connection::createSocket when the handshake failed for LDAP
    connection
    + JDK-8314094: java/lang/ProcessHandle/InfoTest.java fails on
    Windows when run as user with Administrator privileges
    + JDK-8314242: Update applications/scimark/Scimark.java to
    accept VM flags
    + JDK-8314262: GHA: Cut down cross-compilation sysroots deeper
    + JDK-8314263: Signed jars triggering Logger finder recursion
    and StackOverflowError
    + JDK-8314730: GHA: Drop libfreetype6-dev transitional package
    in favor of libfreetype-dev
    + JDK-8315020: The macro definition for LoongArch64 zero build
    is not accurate.
    + JDK-8315062: [GHA] get-bootjdk action should return the
    abolute path
    + JDK-8315135: Memory leak in the native implementation of
    Pack200.Unpacker.unpack()
    + JDK-8315214: Do not run sun/tools/jhsdb tests concurrently
    + JDK-8315480: [11u] Harmonize GHA cross-compilation block with
    mainline
    + JDK-8315683: Parallelize java/util/concurrent/tck/
    /JSR166TestCase.java
    + JDK-8315692: Parallelize
    gc/stress/TestStressRSetCoarsening.java test
    + JDK-8315696: SignedLoggerFinderTest.java test failed
    + JDK-8315766: Parallelize gc/stress/
    /TestStressIHOPMultiThread.java test
    + JDK-8315770: serviceability/sa/TestJmapCoreMetaspace.java
    should run with -XX:-VerifyDependencies
    + JDK-8315862: [11u] Backport 8227337: javax/management/remote/
    /mandatory/connection/ReconnectTest.java NoSuchObjectException
    no such object in table
    + JDK-8315863: [GHA] Update checkout action to use v4
    + JDK-8315937: Enable parallelism in
    vmTestbase/nsk/stress/numeric tests
    + JDK-8316087: Test SignedLoggerFinderTest.java is still failing
    + JDK-8316178: Better diagnostic header for CodeBlobs
    + JDK-8316206: Test StretchedFontTest.java fails for Baekmuk
    font
    + JDK-8316380: [11u] Backport 8170089:
    nsk/jdi/EventSet/resume/resume008: ERROR: suspendCounts don't
    match for : Common-Cleaner
    + JDK-8316514: Better diagnostic header for VtableStub
    + JDK-8316710: Exclude java/awt/font/Rotate/RotatedTextTest.java
    + JDK-8316746: Top of lock-stack does not match the unlocked
    object
    + JDK-8316906: Clarify TLABWasteTargetPercent flag
    + JDK-8317373: Add Telia Root CA v2
    + JDK-8317374: Add Let's Encrypt ISRG Root X2
    + JDK-8317920: JDWP-agent sends broken exception event with
    onthrow option
    + JDK-8317967: Enhance test/jdk/javax/net/ssl/TLSCommon/
    /SSLEngineTestCase.java to handle default cases
    + JDK-8318669: Target OS detection in 'test-prebuilt' makefile
    target is incorrect when running on MSYS2
    + JDK-8318705: [macos] ProblemList
    java/rmi/registry/multipleRegistries/MultipleRegistries.java
    + JDK-8318759: Add four DigiCert root certificates
    + JDK-8319187: Add three eMudhra emSign roots
    + JDK-8320597: RSA signature verification fails on signed data
    that does not encode params correctly
    + JDK-8323423: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.22
* Wed Oct 18 2023 schwab@suse.de
- Configure with --with-native-debug-symbols=internal to enable
  generation of debuginfo packages
* Wed Oct 18 2023 fstrba@suse.com
- Upgrade to upstrem tag jdk-11.0.21+9 (October 2023 CPU)
  * Security fixes:
    + JDK-8242330: Arrays should be cloned in several JAAS Callback
    classes
    + JDK-8284910: Buffer clean in PasswordCallback
    + JDK-8286503: Enhance security classes
    + JDK-8296581: Better system proxy support
    + JDK-8297856: Improve handling of Bidi characters
    + JDK-8309966, CVE-2023-22081, bsc#1216374: Enhanced TLS
    connections
    + JDK-8305815: Update Libpng to 1.6.39
    + JDK-8306881: Update FreeType to 2.13.0
  * Other fixes:
    + JDK-6176679: Application freezes when copying an animated gif
    image to the system clipboard
    + JDK-8023980: JCE doesn't provide any class to handle RSA
    private key in PKCS#1
    + JDK-8155246: Throw error if default java.security file is
    missing
    + JDK-8158880: test/java/time/tck/java/time/format/
    /TCKDateTimeFormatterBuilder.java fail with zh_CN locale
    + JDK-8168261: Use server cipher suites preference by default
    + JDK-8181383: com/sun/jdi/OptionTest.java fails intermittently
    with bind failed: Address already in use
    + JDK-8201516: DebugNonSafepoints generates incorrect
    information
    + JDK-8209398: sun/security/pkcs11/KeyStore/SecretKeysBasic.sh
    failed with "PKCS11Exception: CKR_ATTRIBUTE_SENSITIVE"
    + JDK-8211343: nsk_jvmti_parseoptions should handle multiple
    suboptions
    + JDK-8212045: Add back the tests that were removed from
    HashesTest.java and AddExportsTest.java
    + JDK-8216059: nsk_jvmti_parseoptions still has dependency on
    tilde separator
    + JDK-8217237: HttpClient does not deal well with multi-valued
    WWW-Authenticate challenge headers
    + JDK-8217395: Update langtools shell tests to use ${EXE_SUFFIX}
    + JDK-8217612: (CL)HSDB cannot show some JVM flags
    + JDK-8217850: CompressedClassSpaceSizeInJmapHeap fails after
    JDK-8217612
    + JDK-8218471: generate-unsafe-access-tests.sh does not
    correctly invoke build.tools.spp.Spp
    + JDK-8219628: [TESTBUG] javadoc/doclet/InheritDocForUserTags
    fails with -othervm
    + JDK-8220410: sun/security/tools/jarsigner/warnings/
    /NoTimestampTest.java failed with missing expected output
    + JDK-8221372: Test vmTestbase/nsk/jvmti/GetThreadState/
    /thrstat001/TestDescription.java times out
    + JDK-8222323: ChildAlwaysOnTopTest.java fails with
    "RuntimeException: Failed to unset alwaysOnTop"
    + JDK-8223573: Replace wildcard address with loopback or local
    host in tests - part 4
    + JDK-8223714: HTTPSetAuthenticatorTest could be made more
    resilient
    + JDK-8223783: sun/net/www/http/HttpClient/MultiThreadTest.java
    sometimes detect threads+1 connections
    + JDK-8223856: Replace wildcard address with loopback or local
    host in tests - part 8
    + JDK-8224617: (fs) java/nio/file/FileStore/Basic.java found
    filesystem twice
    + JDK-8224729: Cleanups in sun/security/provider/certpath/ldap/
    /LDAPCertStoreImpl.java
    + JDK-8224768: Test ActalisCA.java fails
    + JDK-8225012: sanity/client/SwingSet/src/ToolTipDemoTest.java
    fails on Windows
    + JDK-8226221: Update PKCS11 tests to use NSS 3.46 libs
    + JDK-8228341: SignTwice.java fails intermittently on Windows
    + JDK-8228403: SignTwice.java failed with
    java.io.FileNotFoundException: File name too long
    + JDK-8229147: Linux os::create_thread() overcounts guardpage
    size with newer glibc (>=2.27)
    + JDK-8229333: java/io/File/SetLastModified.java timed out
    + JDK-8229338: clean up
    test/jdk/java/util/RandomAccess/Basic.java
    + JDK-8229348: java/net/DatagramSocket/
    /UnreferencedDatagramSockets.java fails intermittently
    + JDK-8229481: sun/net/www/protocol/https/
    /ChunkedOutputStream.java failed with a SSLException
    + JDK-8229912: [TESTBUG] java/net/Socks/SocksIPv6Test fails
    without IPv6
    + JDK-8230132: java/net/NetworkInterface/
    /NetworkInterfaceRetrievalTests.java to skip Teredo Tunneling
    Pseudo-Interface
    + JDK-8231037: java/net/InetAddress/ptr/Lookup.java fails
    intermittently due to reverse lookup failed
    + JDK-8231357: sun/security/pkcs11/Cipher/TestKATForGCM.java
    fails on SLES11 using mozilla-nss-3.14
    + JDK-8231516: network QuickAckTest.java failed due to
    "SocketException: maximum number of DatagramSockets reached"
    + JDK-8232101: (sctp) Add minimal sanity tests for SCTP
    + JDK-8232195: Enable BigInteger tests: DivisionOverflow,
    SymmetricRangeTests and StringConstructorOverflow
    + JDK-8232840: java/math/BigInteger/largeMemory/
    /SymmetricRangeTests.java fails due to "OutOfMemoryError:
    Requested array size exceeds VM limit"
    + JDK-8232922: Add java/math/BigInteger/largeMemory/
    /SymmetricRangeTests.java to ProblemList-Xcomp
    + JDK-8234808: jdb quoted option parsing broken
    + JDK-8236045: [TESTBUG] MismatchedWhiteBox test fails with
    missing WhiteBox$WhiteBoxPermission.class
    + JDK-8237183: Bug ID missing for test in patch which fixed
    JDK-8230665
    + JDK-8238157: security/infra/java/security/cert/
    /CertPathValidator/certification/AmazonCA.java test failures
    because of revocation date
    + JDK-8239007: java/math/BigInteger/largeMemory/ tests should
    be disabled on 32-bit platforms
    + JDK-8239264: Clearup the legacy ObjectIdentifier constructor
    from int array
    + JDK-8239333: Mark test AmazonCA.java with intermittent key
    + JDK-8239537: cgroup MetricsTester testMemorySubsystem fails
    sometimes when testing memory.kmem.tcp.usage_in_bytes
    + JDK-8240193: loadLibrary("osxsecurity") should not be removed
    + JDK-8241097: java/math/BigInteger/largeMemory/
    /SymmetricRangeTests.java requires -XX:+CompactStrings
    + JDK-8242151: Improve OID mapping and reuse among JDK security
    providers for aliases registration
    + JDK-8242897: KeyFactory.generatePublic( x509Spec ) failed
    with java.security.InvalidKeyException
    + JDK-8243210: ClhsdbScanOops fails with NullPointerException
    in FileMapHeader.inCopiedVtableSpace
    + JDK-8244078: ProcessTools executeTestJvm and
    createJavaProcessBuilder have inconsistent handling of
    test.*.opts
    + JDK-8247895: SHA1PRNGReseed.java is calling setSeed(0)
    + JDK-8247968: test/jdk/javax/crypto/SecretKeyFactory/
    /security.properties has wrong header
    + JDK-8248001: javadoc generates invalid HTML pages whose
    ftp:// links are broken
    + JDK-8249699: java/io/ByteArrayOutputStream/MaxCapacity.java
    should use @requires instead of @ignore
    + JDK-8251517: [TESTBUG] com/sun/net/httpserver/bugs/
    /B6393710.java does not scale socket timeout
    + JDK-8252530: Fix inconsistencies in hotspot whitebox
    + JDK-8254350: CompletableFuture.get may swallow
    InterruptedException
    + JDK-8255348: NPE in PKIXCertPathValidator event logging code
    + JDK-8257993: vmTestbase/nsk/jvmti/RedefineClasses/
    /StressRedefine/TestDescription.java crash intermittently
    + JDK-8259796: timed CompletableFuture.get may swallow
    InterruptedException
    + JDK-8260274: Cipher.init(int, key) does not use highest
    priority provider for random bytes
    + JDK-8260878: com/sun/jdi/JdbOptions.java fails without jfr
    + JDK-8260934: java/lang/StringBuilder/HugeCapacity.java fails
    without Compact Strings
    + JDK-8263970: Manual test javax/swing/JTextField/
    /JapaneseReadingAttributes/JapaneseReadingAttributes.java
    failed
    + JDK-8265980: Fix systemDictionary and loaderConstraints
    printing
    + JDK-8268457: XML Transformer outputs Unicode supplementary
    character incorrectly to HTML
    + JDK-8268464: Remove dependancy of TestHttpsServer,
    HttpTransaction, HttpCallback from
    open/test/jdk/sun/net/www/protocol/https/ tests
    + JDK-8269091: javax/sound/sampled/Clip/SetPositionHang.java
    failed with ArrayIndexOutOfBoundsException: Array index out of
    range: -4
    + JDK-8270331: [TESTBUG] Error: Not a test or directory
    containing tests: java/awt/print/PrinterJob/InitToBlack.java
    + JDK-8271838: AmazonCA.java interop test fails
    + JDK-8273807: Zero: Drop incorrect test block from
    compiler/startup/NumCompilerThreadsCheck.java
    + JDK-8274205: Handle KDC_ERR_SVC_UNAVAILABLE error code from
    KDC
    + JDK-8274606: Fix jaxp/javax/xml/jaxp/unittest/transform/
    /SurrogateTest.java test
    + JDK-8275234: java/awt/GraphicsDevice/DisplayModes/
    /CycleDMImage.java is entered twice in ProblemList
    + JDK-8275303: sun/java2d/pipe/InterpolationQualityTest.java
    fails with D3D basic render driver
    + JDK-8276651: java/lang/ProcessHandle tests fail with
    "RuntimeException: Input/output error" in
    java.lang.ProcessHandleImpl$Info.info0
    + JDK-8277353: java/security/MessageDigest/
    /ThreadSafetyTest.java test times out
    + JDK-8279536: jdk/nio/zipfs/ZipFSOutputStreamTest.java timed
    out
    + JDK-8283756: (zipfs) ZipFSOutputStreamTest.testOutputStream
    should only check inflated bytes
    + JDK-8284524: Create an automated test for JDK-4422362
    + JDK-8284767: Create an automated test for JDK-4422535
    + JDK-8284772: GHA: Use GCC Major Version Dependencies Only
    + JDK-8285635: javax/swing/JRootPane/DefaultButtonTest.java
    failed with Default Button not pressed for L&F:
    com.sun.java.swing.plaf.motif.MotifLookAndFeel
    + JDK-8286172: Create an automated test for JDK-4516019
    + JDK-8286481: Exception printed to stdout on Windows when
    storing transparent image in clipboard
    + JDK-8286620: Create regression test for verifying setMargin()
    of JRadioButton
    + JDK-8289508: Improve test coverage for XPath Axes: ancestor,
    ancestor-or-self, preceding, and preceding-sibling
    + JDK-8289748: C2 compiled code crashes with SIGFPE with
  - XX:+StressLCM and -XX:+StressGCM
    + JDK-8291444: GHA builds/tests won't run manually if disabled
    from automatic running
    + JDK-8291830: jvmti/RedefineClasses/StressRedefine failed:
    assert(!is_null(v)) failed: narrow klass value can never be
    zero
    + JDK-8292033: Move jdk.X509Certificate event logic to JCA layer
    + JDK-8292297: Fix up loading of override java.security
    properties file
    + JDK-8292443: Weak CAS VarHandle/Unsafe tests should test
    always-failing cases
    + JDK-8293180: JQuery UI license file not updated
    + JDK-8293562: KeepAliveCache Blocks Threads while Closing
    Connections
    + JDK-8293657: sun/management/jmxremote/bootstrap/
    /RmiBootstrapTest.java#id1 failed with "SSLHandshakeException:
    Remote host terminated the handshake"
    + JDK-8293858: Change PKCS7 code to use default SecureRandom
    impl instead of SHA1PRNG
    + JDK-8295737: macOS: Print content cut off when width > height
    with portrait orientation
    + JDK-8295894: Remove SECOM certificate that is expiring in
    September 2023
    + JDK-8296084: javax/swing/JSpinner/4788637/bug4788637.java
    fails intermittently on a VM
    + JDK-8297437: javadoc cannot link to old docs (with old style
    anchors)
    + JDK-8297523: Various GetPrimitiveArrayCritical miss result -
    NULL check
    + JDK-8297587: Upgrade JLine to 3.22.0
    + JDK-8297681: Unnecessary color conversion during
    4BYTE_ABGR_PRE to INT_ARGB_PRE blit
    + JDK-8297730: C2: Arraycopy intrinsic throws incorrect
    exception
    + JDK-8297887: Update Siphash
    + JDK-8297923: java.awt.ScrollPane broken after multiple scroll
    up/down
    + JDK-8297955: LDAP CertStore should use LdapName and not
    String for DNs
    + JDK-8298921: Create a regression test for JDK-8139581
    + JDK-8298974: Add ftcolor.c to imported freetype sources
    + JDK-8299424: containers/docker/TestMemoryWithCgroupV1.java
    fails on SLES12 ppc64le when testing Memory and Swap Limit
    + JDK-8299658: C1 compilation crashes in
    LinearScan::resolve_exception_edge
    + JDK-8299713: Test javax/swing/JTableHeader/6889007/
    /bug6889007.java failed: Wrong type of cursor
    + JDK-8300098: java/util/concurrent/ConcurrentHashMap/
    /ConcurrentAssociateTest.java fails with internal timeout when
    executed with TieredCompilation1/3
    + JDK-8300659: Refactor TestMemoryAwareness to use WhiteBox api
    for host values
    + JDK-8300751: [17u] Remove duplicate entry in javac.properties
    + JDK-8301269: Update Commons BCEL to Version 6.7.0
    + JDK-8301491: C2: java.lang.StringUTF16::indexOfChar intrinsic
    called with negative character argument
    + JDK-8301700: Increase the default TLS Diffie-Hellman group
    size from 1024-bit to 2048-bit
    + JDK-8301959: Compile command in
    compiler.loopopts.TestRemoveEmptyCountedLoop does not work
    + JDK-8302161: Upgrade jQuery UI to version 1.13.2
    + JDK-8302182: Update Public Suffix List to 88467c9
    + JDK-8303511: C2: assert(get_ctrl(n) == cle_out) during
    unrolling
    + JDK-8303809: Dispose context in SPNEGO NegotiatorImpl
    + JDK-8304054: Linux: NullPointerException from
    FontConfiguration.getVersion in case no fonts are installed
    + JDK-8304498: JShell does not switch to raw mode when there is
    no /bin/test
    + JDK-8304867: Explicitly disable dtrace for ppc builds
    + JDK-8305074: ProblemList
    javax/net/ssl/DTLS/RespondToRetransmit.java
    + JDK-8305421: Work around JDK-8305420 in CDSJDITest.java
    + JDK-8305763: Parsing a URI with an underscore goes through a
    silent exception, negatively impacting performance
    + JDK-8305766: ProblemList runtime/CompressedOops/
    /CompressedClassPointers.java
    + JDK-8305950: Have -XshowSettings option display tzdata version
    + JDK-8306133: Open source few AWT Drag & Drop related tests
    + JDK-8306137: Open source several AWT ScrollPane related tests
    + JDK-8306484: Open source several AWT Choice jtreg tests
    + JDK-8306636: Disable compiler/c2/Test6905845.java with
  - XX:TieredStopAtLevel=3
    + JDK-8306638: Open source some AWT tests related to
    datatransfer and Toolkit
    + JDK-8306682: Open source a few more AWT Choice tests
    + JDK-8306718: Optimize and opensource some old AWT tests
    + JDK-8306954: Open source five Focus related tests
    + JDK-8306955: Open source several JComboBox jtreg tests
    + JDK-8307078: Opensource and clean up five more AWT Focus
    related tests
    + JDK-8307080: Open source some more JComboBox jtreg tests
    + JDK-8307128: Open source some drag and drop tests 4
    + JDK-8307133: Open source some JTable jtreg tests
    + JDK-8307135: java/awt/dnd/NotReallySerializableTest/
    /NotReallySerializableTest.java failed
    + JDK-8307301: Update HarfBuzz to 7.2.0
    + JDK-8307569: Build with gcc8 is broken after JDK-8307301
    + JDK-8307572: AArch64: Vector registers are clobbered by some
    macroassemblers
    + JDK-8307603: [AIX] Broken build after JDK-8307301
    + JDK-8307604: gcc12 based Alpine build broken build after
    JDK-8307301
    + JDK-8307799: Newly added java/awt/dnd/MozillaDnDTest.java has
    invalid jtreg `@requires` clause
    + JDK-8308156: VerifyCACerts.java misses blank in error output
    + JDK-8309088: security/infra/java/security/cert/
    /CertPathValidator/certification/AmazonCA.java fails
    + JDK-8309108: Bump update version for OpenJDK: jdk-11.0.21
    + JDK-8309138: Fix container tests for jdks with symlinked conf
    dir
    + JDK-8310054: ScrollPane insets are incorrect
    + JDK-8310176: JDK 11 G1 crash during full GC with
    +UseStringDeduplication
    + JDK-8310620: [11u] Problemlist failing aot tests on macos x64
    + JDK-8311033: [macos] PrinterJob does not take into account
    Sides attribute
    + JDK-8311689: Wrong visible amount in Adjustable of ScrollPane
    + JDK-8312138: jcmd VM.metaspace vslist has no newline
    character before the Class: label.
    + JDK-8312555: Ideographic characters aren't stretched by
    AffineTransform.scale(2, 1)
    + JDK-8313159: [11u] Fix test SSLEngineKeyLimit.java after
    Merge error
    + JDK-8313765: Invalid CEN header (invalid zip64 extra data
    field size)
    + JDK-8313796: AsyncGetCallTrace crash on unreadable
    interpreter method pointer
    + JDK-8313803: [11u] Exclude jdk/jfr/event/sampling/
    /TestStackFrameLineNumbers.java
    + JDK-8313878: Exclude two compiler/rtm/locking tests on ppc64le
    + JDK-8314086: [11u] A typo in the fix for JDK-8312462 is
    causing test failure in ChildAlwaysOnTopTest.java
    + JDK-8314950: CMS may miss NMT tag after mark stack expansion
    + JDK-8314960: Add Certigna Root CA - 2
    + JDK-8315135: Memory leak in the native implementation of
    Pack200.Unpacker.unpack()
    + JDK-8315529: [11u] Exclude some failing Z-GC tests
    + JDK-8317040: Exclude cleaner test failing on older releases
    + JDK-8317644: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.21
- Modified patches:
  * adlc-parser.patch
    + extend to initialize all the members to NULL
  * fips.patch
  * nss-security-provider.patch
  * reproducible-javadoc-timestamp.patch
    + rediff
* Wed Oct 18 2023 fstrba@suse.com
- Compiler flags to realign stack on ix86 (bsc#1214790)
* Thu Sep 14 2023 fstrba@suse.com
- Added patch:
  * reproducible-properties.patch
    + use SOURCE_DATE_EPOCH for timestamp in the generated
    properties files
* Wed Aug 23 2023 fstrba@suse.com
- Update to upstream tag jdk-11.0.20.1+1 (August 2023 emergency
  release fixing a regression in July 2023 CPU)
  * Changes:
    + JDK-8313765: Invalid CEN header (invalid zip64 extra data
    field size)
    + JDK-8314678: Bump update version for OpenJDK: jdk-11.0.20.1
* Fri Aug  4 2023 fstrba@suse.com
- Added patch:
  * reproducible-javadoc-timestamp.patch
    + use SOURCE_DATE_EPOCH in javadoc and make the javadoc
    generation more reproducible
* Tue Jul 25 2023 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.20+8 (July 2023 CPU)
  * CVEs
    + CVE-2023-22006, bsc#1213473
    + CVE-2023-22036, bsc#1213474
    + CVE-2023-22041, bsc#1213475
    + CVE-2023-22044, bsc#1213479
    + CVE-2023-22045, bsc#1213481
    + CVE-2023-22049, bsc#1213482
    + CVE-2023-25193, bsc#1207922
  * Security fixes
    + JDK-8298676: Enhanced Look and Feel
    + JDK-8300285: Enhance TLS data handling
    + JDK-8300596: Enhance Jar Signature validation
    + JDK-8301998, JDK-8302084: Update HarfBuzz to 7.0.1
    + JDK-8302475: Enhance HTTP client file downloading
    + JDK-8302483: Enhance ZIP performance
    + JDK-8303376: Better launching of JDI
    + JDK-8304468: Better array usages
    + JDK-8305312: Enhanced path handling
    + JDK-8308682: Enhance AES performance
  * Other changes
    + JDK-8171426: java/lang/ProcessBuilder/Basic.java failed with
    Stream closed
    + JDK-8178806: Better exception logging in crypto code
    + JDK-8187522: test/sun/net/ftp/FtpURLConnectionLeak.java timed
    out
    + JDK-8209167: Use CLDR's time zone mappings for Windows
    + JDK-8209546: Make sun/security/tools/keytool/autotest.sh to
    support macosx
    + JDK-8209880: tzdb.dat is not reproducibly built
    + JDK-8213531: Test javax/swing/border/TestTitledBorderLeak.java
    fails
    + JDK-8214459: NSS source should be removed
    + JDK-8214807: Improve handling of very old class files
    + JDK-8215015: [TESTBUG] remove unneeded -Xfuture option from
    tests
    + JDK-8215575: C2 crash: assert(get_instanceKlass()->is_loaded())
    failed: must be at least loaded
    + JDK-8220093: Change to GCC 8.2 for building on Linux at Oracle
    + JDK-8227257: javax/swing/JFileChooser/4847375/bug4847375.java
    fails with AssertionError
    + JDK-8232853: AuthenticationFilter.Cache::remove may throw
    ConcurrentModificationException
    + JDK-8243936: NonWriteable system properties are actually
    writeable
    + JDK-8246383: NullPointerException in
    JceSecurity.getVerificationResult when using Entrust provider
    + JDK-8248701: On Windows generated modules-deps.gmk can
    contain backslash-r (CR) characters
    + JDK-8257856: Make ClassFileVersionsTest.java robust to JDK
    version updates
    + JDK-8259530: Generated docs contain MIT/GPL-licenced works
    without reproducing the licence
    + JDK-8263420: Incorrect function name in
    NSAccessibilityStaticText native peer implementation
    + JDK-8264290: Create implementation for
    NSAccessibilityComponentGroup protocol peer
    + JDK-8264304: Create implementation for NSAccessibilityToolbar
    protocol peer
    + JDK-8265486: ProblemList javax/sound/midi/Sequencer/
    /Recording.java on macosx-aarch64
    + JDK-8268558: [TESTBUG] Case 2 in
    TestP11KeyFactoryGetRSAKeySpec is skipped
    + JDK-8269746: C2: assert(!in->is_CFG()) failed: CFG Node with
    no controlling input?
    + JDK-8274864: Remove Amman/Cairo hacks in ZoneInfoFile
    + JDK-8275233: Incorrect line number reported in exception
    stack trace thrown from a lambda expression
    + JDK-8275721: Name of UTC timezone in a locale changes
    depending on previous code
    + JDK-8275735: [linux] Remove deprecated Metrics api (kernel
    memory limit)
    + JDK-8276880: Remove java/lang/RuntimeTests/exec/ExecWithDir
    as unnecessary
    + JDK-8277775: Fixup bugids in RemoveDropTargetCrashTest.java -
    add 4357905
    + JDK-8278434: timeouts in test java/time/test/java/time/format/
    /TestZoneTextPrinterParser.java
    + JDK-8280703: CipherCore.doFinal(...) causes potentially
    massive byte[] allocations during decryption
    + JDK-8282077: PKCS11 provider C_sign() impl should handle
    CKR_BUFFER_TOO_SMALL error
    + JDK-8282201: Consider removal of expiry check in
    VerifyCACerts.java test
    + JDK-8282467: add extra diagnostics for JDK-8268184
    + JDK-8282600: SSLSocketImpl should not use user_canceled
    workaround when not necessary
    + JDK-8283059: Uninitialized warning in check_code.c with GCC
    11.2
    + JDK-8285497: Add system property for Java SE specification
    maintenance version
    + JDK-8286398: Address possibly lossy conversions in
    jdk.internal.le
    + JDK-8287007: [cgroups] Consistently use stringStream
    throughout parsing code
    + JDK-8287246: DSAKeyValue should check for missing params
    instead of relying on KeyFactory provider
    + JDK-8287876: The recently de-problemlisted
    TestTitledBorderLeak test is unstable
    + JDK-8287897: Augment src/jdk.internal.le/share/legal/jline.md
    with information on 4th party dependencies
    + JDK-8289301: P11Cipher should not throw out of bounds
    exception during padding
    + JDK-8289735: UTIL_LOOKUP_PROGS fails on pathes with space
    + JDK-8291226: Create Test Cases to cover scenarios for
    JDK-8278067
    + JDK-8291637: HttpClient default keep alive timeout not
    followed if server sends invalid value
    + JDK-8291638: Keep-Alive timeout of 0 should close connection
    immediately
    + JDK-8292206: TestCgroupMetrics.java fails as getMemoryUsage()
    is lower than expected
    + JDK-8293232: Fix race condition in pkcs11 SessionManager
    + JDK-8293815: P11PSSSignature.engineUpdate should not print
    debug messages during normal operation
    + JDK-8294548: Problem list SA core file tests on macosx-x64
    due to JDK-8294316
    + JDK-8294906: Memory leak in PKCS11 NSS TLS server
    + JDK-8295974: jni_FatalError and Xcheck:jni warnings should
    print the native stack when there are no Java frames
    + JDK-8296934: Write a test to verify whether Undecorated Frame
    can be iconified or not
    + JDK-8297000: [jib] Add more friendly warning for proxy issues
    + JDK-8297450: ScaledTextFieldBorderTest.java fails when run
    with -show parameter
    + JDK-8298887: On the latest macOS+XCode the Robot API may
    report wrong colors
    + JDK-8299259: C2: Div/Mod nodes without zero check could be
    split through iv phi of loop resulting in SIGFPE
    + JDK-8300079: SIGSEGV in LibraryCallKit::inline_string_copy
    due to constant NULL src argument
    + JDK-8300205: Swing test bug8078268 make latch timeout
    configurable
    + JDK-8300490: Spaces in name of MacOS Code Signing Identity
    are not correctly handled after JDK-8293550
    + JDK-8301119: Support for GB18030-2022
    + JDK-8301170: perfMemory_windows.cpp add free_security_attr to
    early returns
    + JDK-8301401: Allow additional characters for GB18030-2022
    support
    + JDK-8302151: BMPImageReader throws an exception reading BMP
    images
    + JDK-8302791: Add specific ClassLoader object to Proxy
    IllegalArgumentException message
    + JDK-8303102: jcmd: ManagementAgent.status truncates the text
    longer than O_BUFLEN
    + JDK-8303354: addCertificatesToKeystore in KeystoreImpl.m
    needs CFRelease call in early potential CHECK_NULL return
    + JDK-8303432: Bump update version for OpenJDK: jdk-11.0.20
    + JDK-8303440: The "ZonedDateTime.parse" may not accept the
    "UTC+XX" zone id
    + JDK-8303465: KeyStore of type KeychainStore, provider Apple
    does not show all trusted certificates
    + JDK-8303476: Add the runtime version in the release file of a
    JDK image
    + JDK-8303482: Update LCMS to 2.15
    + JDK-8303564: C2: "Bad graph detected in build_loop_late"
    after a CMove is wrongly split thru phi
    + JDK-8303576: addIdentitiesToKeystore in KeystoreImpl.m needs
    CFRelease call in early potential CHECK_NULL return
    + JDK-8303822: gtestMain should give more helpful output
    + JDK-8303861: Error handling step timeouts should never be
    blocked by OnError and others
    + JDK-8303937: Corrupted heap dumps due to missing retries for
    os::write()
    + JDK-8304134: jib bootstrapper fails to quote filename when
    checking download filetype
    + JDK-8304291: [AIX] Broken build after JDK-8301998
    + JDK-8304295: harfbuzz build fails with GCC 7 after JDK-8301998
    + JDK-8304350: Font.getStringBounds calculates wrong width for
    TextAttribute.TRACKING other than 0.0
    + JDK-8304760: Add 2 Microsoft TLS roots
    + JDK-8305113: (tz) Update Timezone Data to 2023c
    + JDK-8305400: ISO 4217 Amendment 175 Update
    + JDK-8305528: [11u] Backport of JDK-8259530 breaks build with
    JDK10 bootstrap VM
    + JDK-8305682: Update the javadoc in the Character class to
    state support for GB 18030-2022 Implementation Level 2
    + JDK-8305711: Arm: C2 always enters slowpath for monitorexit
    + JDK-8305721: add `make compile-commands` artifacts to
    .gitignore
    + JDK-8305975: Add TWCA Global Root CA
    + JDK-8306543: GHA: MSVC installation is failing
    + JDK-8306658: GHA: MSVC installation could be optional since
    it might already be pre-installed
    + JDK-8306664: GHA: Update MSVC version to latest stepping
    + JDK-8306768: CodeCache Analytics reports wrong threshold
    + JDK-8306976: UTIL_REQUIRE_SPECIAL warning on grep
    + JDK-8307134: Add GTS root CAs
    + JDK-8307811: [TEST] compilation of TimeoutInErrorHandlingTest
    fails after backport of JDK-8303861
    + JDK-8308006: Missing NMT memory tagging in CMS
    + JDK-8308884: [17u/11u] Backout JDK-8297951
    + JDK-8309476: [11u] tools/jmod/hashes/HashesOrderTest.java
    fails intermittently
    + JDK-8311465: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.20
- Removed patch:
  * system-crypto-policy.patch
    + folded into modified fips.patch
- Modified patch:
  * fips.patch
    + fold in the system-crypto-policy.patch
    + regenerate to changed context
* Wed Apr 26 2023 fstrba@suse.com
- Upgrade to upsteam tag jdk-11.0.19+7 (April 2023 CPU)
  * Security fixes:
    + JDK-8287404: Improve ping times
    + JDK-8288436: Improve Xalan supports
    + JDK-8294474, CVE-2023-21930, bsc#1210628: Better AES support
    + JDK-8295304, CVE-2023-21938, bsc#1210632: Runtime support
    improvements
    + JDK-8296676, CVE-2023-21937, bsc#1210631: Improve String
    platform support
    + JDK-8296684, CVE-2023-21937, bsc#1210631: Improve String
    platform support
    + JDK-8296692, CVE-2023-21937, bsc#1210631: Improve String
    platform support
    + JDK-8296832, CVE-2023-21939, bsc#1210634: Improve Swing
    platform support
    + JDK-8297371: Improve UTF8 representation redux
    + JDK-8298191, CVE-2023-21954, bsc#1210635: Enhance object
    reclamation process
    + JDK-8298310, CVE-2023-21967, bsc#1210636: Enhance TLS session
    negotiation
    + JDK-8298667, CVE-2023-21968, bsc#1210637: Improved path
    handling
    + JDK-8299129: Enhance NameService lookups
  * Fixes:
    + JDK-6528710: sRGB-ColorSpace to sRGB-ColorSpace Conversion
    + JDK-7188098: TEST_BUG: closed/javax/sound/midi/Synthesizer/
    /Receiver/bug6186488.java fails
    + JDK-8035787: SourcePositions are wrong for Strings
    concatenated with '+' operator
    + JDK-8065097: [macosx] javax/swing/Popup/
    /TaskbarPositionTest.java fails because Popup is one pixel off
    + JDK-8065422: Trailing dot in hostname causes TLS handshake to
    fail with SNI disabled
    + JDK-8129315: java/net/Socket/LingerTest.java and
    java/net/Socket/ShutdownBoth.java timeout intermittently
    + JDK-8144030: [macosx] test java/awt/Frame/
    /ShapeNotSetSometimes/ShapeNotSetSometimes.java fails (again)
    + JDK-8170705: sun/net/www/protocol/http/StackTraceTest.java
    fails intermittently with Invalid Http response
    + JDK-8171405: java/net/URLConnection/ResendPostBody.java
    failed with "Error while cleaning up threads after test"
    + JDK-8179317: [TESTBUG] rewrite runtime shell tests in java
    + JDK-8247741: Test  test/hotspot/jtreg/runtime/7162488/
    /TestUnrecognizedVmOption.java fails when
  - XX:+IgnoreUnrecognizedVMOptions is set
    + JDK-8190492: Remove SSLv2Hello and SSLv3 from default enabled
    TLS protocols
    + JDK-8192931: Regression test java/awt/font/TextLayout/
    /CombiningPerf.java fails
    + JDK-8195057: java/util/concurrent/CountDownLatch/Basic.java
    failed w/ Xcomp
    + JDK-8195716: BootstrapLoggerTest : Executor still alive
    + JDK-8202621: bad test with broken links needs to be updated
    + JDK-8207248: Reduce incidence of
    compiler.warn.source.no.bootclasspath in javac tests
    + JDK-8208077: File.listRoots performance degradation
    + JDK-8209023: fix 2 compiler tests to avoid JDK-8208690
    + JDK-8209115: adjust libsplashscreen linux ppc64le builds for
    easier libpng update
    + JDK-8209774: Refactor shell test
    javax/xml/jaxp/common/8035437/run.sh to java
    + JDK-8209935: Test to cover CodeSource.getCodeSigners()
    + JDK-8210373: Deadlock in libj2gss.so when loading "j2gss" and
    "net" libraries in parallel.
    + JDK-8212165: JGSS: Fix cut/paste error in NativeUtil.c
    + JDK-8212216: JGSS: Fix leak in exception cases in getJavaOID()
    + JDK-8213130: Update ProblemList after verification of jtreg
    tests in Win 7
    + JDK-8213265: fix missing newlines at end of files
    + JDK-8213932: [TESTBUG] assertEquals is invoked with the
    arguments in the wrong order
    + JDK-8214445: [test] java/net/URL/HandlerLoop has illegal
    reflective access
    + JDK-8215372: test/jdk/java/nio/file/DirectoryStream/Basic.java
    not correct when using a glob
    + JDK-8215759: [test] java/math/BigInteger/ModPow.java can
    throw an ArithmeticException
    + JDK-8217353: java/util/logging/LogManager/Configuration/
    /updateConfiguration/HandlersOnComplexResetUpdate.java fails
    with Unexpected reference: java.lang.ref.WeakReference
    + JDK-8217730: Split up MakeBase.gmk
    + JDK-8218133: sun/net/www/protocol/http/ProtocolRedirect.java
    failed with "java.net.ConnectException"
    + JDK-8218431: Improved platform checking in makefiles
    + JDK-8221098: Run java/net/URL/HandlerLoop.java in othervm mode
    + JDK-8221168: java/util/concurrent/CountDownLatch/Basic.java
    fails
    + JDK-8221351: Crash in
    KlassFactory::check_shared_class_file_load_hook
    + JDK-8221621: FindTests.gmk cannot handle "=" in TEST.groups
    comments
    + JDK-8222430: Add tests for ElementKind predicates
    + JDK-8223463: Replace wildcard address with loopback or local
    host in tests - part 2
    + JDK-8223716: sun/net/www/http/HttpClient/MultiThreadTest.java
    should be more resilient to unexpected traffic
    + JDK-8223736: jvmti/scenarios/contention/TC04/tc04t001/
    /TestDescription.java fails due to wrong number of
    MonitorContendedEntered events
    + JDK-8224024: java/util/concurrent/BlockingQueue/
    /DrainToFails.java testBounded fails intermittently
    + JDK-8226595: jvmti/scenarios/contention/TC04/tc04t001/
    /TestDescription.java still fails due to wrong number of
    MonitorContendedEntered events
    + JDK-8226917: jvmti/scenarios/contention/TC04/tc04t001/
    /TestDescription.java fails on jvmti->InterruptThread
    (JVMTI_ERROR_THREAD_NOT_ALIVE)
    + JDK-8227422: sun/net/www/protocol/file/
    /DirPermissionDenied.java failed on Windows 2016 because
    DirPermissionDenied directory has no read permission
    + JDK-8230374: maxOutputSize, instead of
    javatest.maxOutputSize, should be used in TEST.properties
    + JDK-8230731: SA tests fail with "Windbg Error: ReadVirtual
    failed"
    + JDK-8231595: [TEST] develop a test case for SuspendThreadList
    including current thread
    + JDK-8233462: serviceability/tmtools/jstat tests times out
    with -Xcomp
    + JDK-8235448: code cleanup in SSLContextImpl.java
    + JDK-8238936: The crash in XRobotPeer when the custom
    GraphicsDevice is used
    + JDK-8241806: The sun/awt/shell/FileSystemViewMemoryLeak.java
    is unstable
    + JDK-8244592: Start supporting SOURCE_DATE_EPOCH
    + JDK-8245245: WebSocket can lose the URL encoding of URI query
    parameters
    + JDK-8298588: WebSockets: HandshakeUrlEncodingTest
    unnecessarily depends on a response body
    + JDK-8245654: Add Certigna Root CA
    + JDK-8248306: gc/stress/gclocker/
    /TestExcessGCLockerCollections.java does not compile
    + JDK-8249691: jdk/lambda/vm/StrictfpDefault.java file can be
    removed
    + JDK-8252401: Introduce Utils.TEST_NATIVE_PATH
    + JDK-8252532: use Utils.TEST_NATIVE_PATH instead of
    System.getProperty("test.nativepath")
    + JDK-8252715: Problem list java/awt/event/KeyEvent/KeyTyped/
    /CtrlASCII.java on Linux
    + JDK-8254267: javax/xml/crypto/dsig/LogParameters.java failed
    with "RuntimeException: Unexpected log output:"
    + JDK-8255710: Opensource unit/regression tests for CMM
    + JDK-8256110: Create implementation for NSAccessibilityStepper
    protocol
    + JDK-8256111: Create implementation for
    NSAccessibilityStaticText protocol
    + JDK-8256126: Create implementation for NSAccessibilityImage
    protocol peer
    + JDK-8256240: Reproducible builds should turn on the
    "deterministic" flag for Visual Studio
    + JDK-8281262: Windows builds in different directories are not
    fully reproducible
    + JDK-8256934: C2: assert(C->live_nodes() <=
    C->max_node_limit()) failed: Live Node limit exceeded limit
    + JDK-8257928: Test image build failure with clang-10 due to
  - Wmisleading-indentation
    + JDK-8258005: JDK build fails with incorrect fixpath script
    + JDK-8259265: Refactor UncaughtExceptions shell test as java
    test.
    + JDK-8259267: Refactor LoaderLeak shell test as java test.
    + JDK-8225648: [TESTBUG] java/lang/annotation/loaderLeak/
    /Main.java fails with -Xcomp
    + JDK-8260576: Typo in compiler/runtime/safepoints/
    /TestRegisterRestoring.java
    + JDK-8261270: MakeMethodNotCompilableTest fails with
  - XX:TieredStopAtLevel={1,2,3}
    + JDK-8261279: sun/util/resources/cldr/TimeZoneNamesTest.java
    timed out
    + JDK-8261350: Create implementation for
    NSAccessibilityCheckBox protocol peer
    + JDK-8261351: Create implementation for
    NSAccessibilityRadioButton protocol
    + JDK-8261352: Create implementation for component peer for all
    the components who should be ignored in a11y interactions
    + JDK-8262060: compiler/whitebox/BlockingCompilation.java timed
    out
    + JDK-8264200: java/nio/channels/DatagramChannel/SRTest.java
    fails intermittently
    + JDK-8264299: Create implementation of native accessibility
    peer for ScrollPane and ScrollBar Java Accessibility roles
    + JDK-8264512: jdk/test/jdk/java/util/prefs/ExportNode.java
    relies on default platform encoding
    + JDK-8266974: duplicate property key in java.sql.rowset
    resource bundle
    + JDK-8267038: Update IANA Language Subtag Registry to Version
    2022-03-02
    + JDK-8270609: [TESTBUG] java/awt/print/Dialog/DialogCopies.java
    does not show instruction
    + JDK-8271323: [TESTBUG] serviceability/sa/ClhsdbCDSCore.java
    fails with -XX:TieredStopAtLevel=1
    + JDK-8271506: Add ResourceHashtable support for deleting
    selected entries
    + JDK-8272985: Reference discovery is confused about atomicity
    and degree of parallelism
    + JDK-8273497: building.md should link to both md and html
    + JDK-8273806: compiler/cpuflags/TestSSE4Disabled.java should
    test for CPU feature explicitly
    + JDK-8273895: compiler/ciReplay/TestVMNoCompLevel.java fails
    due to wrong data size with TieredStopAtLevel=2,3
    + JDK-8274939: Incorrect size of the pixel storage is used by
    the robot on macOS
    + JDK-8277346: ProblemList 7 serviceability/sa tests on
    macosx-x64
    + JDK-8277351: ProblemList runtime/jni/checked/
    /TestPrimitiveArrayCriticalWithBadParam.java on macosx-x64
    + JDK-8279614: The left line of the TitledBorder is not painted
    on 150 scale factor
    + JDK-8279662: serviceability/sa/ClhsdbScanOops.java can fail
    due to unexpected GC
    + JDK-8279941: sun/security/pkcs11/Signature/
    /TestDSAKeyLength.java fails when NSS version detection fails
    + JDK-8280048: Missing comma in copyright header
    + JDK-8280391: NMT: Correct NMT tag on CollectedHeap
    + JDK-8280401: [sspi] gss_accept_sec_context leaves
    output_token uninitialized
    + JDK-8280896: java/nio/file/Files/probeContentType/Basic.java
    fails on Windows 11
    + JDK-8282036: Change java/util/zip/ZipFile/DeleteTempJar.java
    to stop HttpServer cleanly in case of exceptions
    + JDK-8282219: jdk/java/lang/ProcessBuilder/Basic.java fails on
    AIX
    + JDK-8282398: EndingDotHostname.java test fails because SSL
    cert expired
    + JDK-8282511: Use fixed certificate validation date in
    SSLExampleCert template
    + JDK-8282958: Rendering Issues with Borders on Windows
    High-DPI systems
    + JDK-8283606: Tests may fail with zh locale on MacOS
    + JDK-8283717: vmTestbase/nsk/jdi/ThreadStartEvent/thread/
    /thread001 failed due to SocketTimeoutException
    + JDK-8283719: java/util/logging/CheckZombieLockTest.java
    failing intermittently
    + JDK-8283870: jdeprscan --help causes an exception when the
    locale is ja, zh_CN or de
    + JDK-8284023: java.sun.awt.X11GraphicsDevice
    .getDoubleBufferVisuals() leaks XdbeScreenVisualInfo
    + JDK-8284165: Add pid to process reaper thread name
    + JDK-8285093: Introduce UTIL_ARG_WITH
    + JDK-8285755: JDK-8285093 changed the default for
  - -with-output-sync
    + JDK-8285919: Remove debug printout from JDK-8285093
    + JDK-8285399: JNI exception pending in awt_GraphicsEnv.c:1432
    + JDK-8285690: CloneableReference subtest should not throw
    CloneNotSupportedException
    + JDK-8285835: SIGSEGV in
    PhaseIdealLoop::build_loop_late_post_work
    + JDK-8286030: Avoid JVM crash when containers share the same
    /tmp dir
    + JDK-8286800: Assert in PhaseIdealLoop::dump_real_LCA is too
    strong
    + JDK-8286962: java/net/httpclient/ServerCloseTest.java failed
    once with ConnectException
    + JDK-8287011: Improve container information
    + JDK-8287180: Update IANA Language Subtag Registry to Version
    2022-08-08
    + JDK-8287906: Rewrite of GitHub Actions (GHA) sanity tests
    + JDK-8288499: Restore cancel-in-progress in GHA
    + JDK-8288332: Tier1 validate-source fails after 8279614
    + JDK-8289562: Change bugs.java.com and bugreport.java.com
    URL's to https
    + JDK-8289695: [TESTBUG] TestMemoryAwareness.java fails on
    cgroups v2 and crun
    + JDK-8290197: test/jdk/java/nio/file/Files/probeContentType/
    /Basic.java fails on some systems for the ".rar" extension
    + JDK-8290899: java/lang/String/StringRepeat.java test requests
    too much heap on windows x86
    + JDK-8290920: sspi_bridge.dll not built if BUILD_CRYPTO is
    false
    + JDK-8290964: C2 compilation fails with assert "non-reduction
    loop contains reduction nodes"
    + JDK-8292863: assert(_print_inlining_stream->size() > 0)
    failed: missing inlining msg
    + JDK-8292877: java/util/concurrent/atomic/Serial.java uses
    {Double,Long}Accumulator incorrectly
    + JDK-8293550: Optionally add get-task-allow entitlement to
    macos binaries
    + JDK-8293767: AWT test TestSinhalaChar.java has old SCCS
    markings
    + JDK-8293996: C2: fix and simplify
    IdealLoopTree::do_remove_empty_loop
    + JDK-8294378: URLPermission constructor exception when using
    tr locale
    + JDK-8294580: frame::interpreter_frame_print_on() crashes if
    free BasicObjectLock exists in frame
    + JDK-8294705: Disable an assertion in
    test/jdk/java/util/DoubleStreamSums/CompensatedSums.java
    + JDK-8294947: Use 64bit atomics in patch_verified_entry on
    x86_64
    + JDK-8295116: C2: assert(dead->outcnt() == 0 &&
    !dead->is_top()) failed: node must be dead
    + JDK-8295211: Fix autoconf 2.71 warning "AC_CHECK_HEADERS: you
    should use literals"
    + JDK-8295405: Add cause in a couple of
    IllegalArgumentException and InvalidParameterException shown
    by sun/security/pkcs11 tests
    + JDK-8295412: support latest VS2022 MSC_VER in
    abstract_vm_version.cpp
    + JDK-8295530: Update Zlib Data Compression Library to Version
    1.2.13
    + JDK-8295685: Update Libpng to 1.6.38
    + JDK-8295774: Write a test to verify List sends
    ItemEvent/ActionEvent
    + JDK-8295777: java/net/httpclient/ConnectExceptionTest.java
    should not rely on system resolver
    + JDK-8295788: C2 compilation hits "assert((mode ==
    ControlAroundStripMined && use == sfpt) ||
    !use->is_reachable_from_root()) failed: missed a node"
    + JDK-8296239: ISO 4217 Amendment 174 Update
    + JDK-8296611: Problemlist several sun/security tests until
    + JDK-8295343 is resolved
    + JDK-8296619: Upgrade jQuery to 3.6.1
    + JDK-8296675: Exclude linux-aarch64 in NSS tests
    + JDK-8296878: Document Filter attached to JPasswordField and
    setText("") is not cleared instead inserted characters
    replaced with unicode null characters
    + JDK-8296904: Improve handling of macos xcode toolchain
    + JDK-8296912: C2: CreateExNode::Identity fails with assert(i <
    _max) failed: oob: i=1, _max=1
    + JDK-8296924: C2:
    assert(is_valid_AArch64_address(dest.target())) failed: bad
    address
    + JDK-8297088: Update LCMS to 2.14
    + JDK-8297257: Bump update version for OpenJDK: jdk-11.0.19
    + JDK-8297264: C2: Cast node is not processed again in CCP and
    keeps a wrong too narrow type which is later replaced by top
    + JDK-8297480: GetPrimitiveArrayCritical in imageioJPEG misses
    result - NULL check
    + JDK-8297489: Modify TextAreaTextEventTest.java as to verify
    the content change of TextComponent sends TextEvent
    + JDK-8297569: URLPermission constructor throws
    IllegalArgumentException: Invalid characters in hostname
    after JDK-8294378
    + JDK-8297951: C2: Create skeleton predicates for all If nodes
    in loop predication
    + JDK-8297963: Partially fix string expansion issues in
    UTIL_DEFUN_NAMED and related macros
    + JDK-8298027: Remove SCCS id's from awt jtreg tests
    + JDK-8298073: gc/metaspace/
    /CompressedClassSpaceSizeInJmapHeap.java causes test task
    timeout on macosx
    + JDK-8241293: CompressedClassSpaceSizeInJmapHeap.java time out
    after 8 minutes
    + JDK-8298093: improve cleanup and error handling of
    awt_parseColorModel in awt_parseImage.c
    + JDK-8298108: Add a regression test for JDK-8297684
    + JDK-8298129: Let checkpoint event sizes grow beyond u4 limit
    + JDK-8298271: java/security/SignedJar/spi-calendar-provider/
    /TestSPISigned.java failing on Windows
    + JDK-8298459: Fix msys2 linking and handling out of tree build
    directory for source zip creation
    + JDK-8298527: Cygwin's uname -m returns different string than
    before
    + JDK-8299194: CustomTzIDCheckDST.java may fail at future date
    + JDK-8299296: Write a test to verify the components selection
    sends ItemEvent
    + JDK-8299439: java/text/Format/NumberFormat/CurrencyFormat.java
    fails for hr_HR
    + JDK-8299483: ProblemList java/text/Format/NumberFormat/
    /CurrencyFormat.java
    + JDK-8299445: EndingDotHostname.java fails because of
    compilation errors
    + JDK-8299520: TestPrintXML.java output error messages in case
    compare fails
    + JDK-8299596: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.19
    + JDK-8299616: [11u] Bootcycle build fails after JDK-8257679
    backport
    + JDK-8299789: Compilation of gtest causes build to fail if
    runtime libraries are in different dirs
    + JDK-8300119: CgroupMetrics.getTotalMemorySize0() can report
    invalid results on 32 bit systems
    + JDK-8300424: [11u] Chunk lost in backport of 8297569
    + JDK-8300642: [17u,11u] Fix DEFAULT_PROMOTED_VERSION_PRE=ea
    for -dev
    + JDK-8300742: jstat's CGCT is 5 percent higher than the pause
    time in -Xlog:gc.
    + JDK-8300773: Address the inconsistency between the constant
    array and pool size
    + JDK-8301397: [11u, 17u] Bump jtreg to fix issue with build
    JDK 11.0.18
    + JDK-8301760: Fix possible leak in SpNegoContext dispose
    + JDK-8301842: JFR: increase checkpoint event size for
    stacktrace and string pool
    + JDK-8302000: [11u] A subtle race condition during jdk11u
    build
    + JDK-8218460: Test generation scripts do not invoke stream
    preprocessor correctly
    + JDK-8302657: [11u] Add missing '(' in makefile after backport
    of 8218431
    + JDK-8302694: [11u] Update GHA Boot JDK to 11.0.18
    + JDK-8302903: [11u] Add modified test snippet after backport
    of JDK-8221871
    + JDK-8303075: [11u] Add CompileClassWithDebugTest to
    ProblemList for 8303074
    + JDK-8304389: [11u] Crash on Windows in C2 compiled code after
    8248238 and 8218431
- Modified patch:
  * fips.patch
    + adapt to changed context
* Fri Feb 17 2023 fstrba@suse.com
- Remove the accessibility sub-package, since it was never really
  working and creates another problems (bsc#1206549). It can
  eventually be built as standalone if needed
- Removed patches:
  * jaw-jdk10.patch
  * jaw-misc.patch
  * jaw-nogtk.patch
    + not needed after the removal of the accessibility sub-package
* Tue Feb  7 2023 fstrba@suse.com
- Upgrade to upstream tag jdk-11.0.18+10 (January 2023 CPU)
  * CVEs
    + CVE-2023-21835, bsc#1207246
    + CVE-2023-21843, bsc#1207248
  * Security fixes
    + JDK-8286070: Improve UTF8 representation
    + JDK-8286496: Improve Thread labels
    + JDK-8287411: Enhance DTLS performance
    + JDK-8288516: Enhance font creation
    + JDK-8289350: Better media supports
    + JDK-8293554: Enhanced DH Key Exchanges
    + JDK-8293598: Enhance InetAddress address handling
    + JDK-8293717: Objective view of ObjectView
    + JDK-8293734: Improve BMP image handling
    + JDK-8293742: Better Banking of Sounds
    + JDK-8295687: Better BMP bounds
  * Other changes
    + JDK-4819544: SwingSet2 JTable Demo throws NullPointerException
    + JDK-6782021: It is not possible to read local computer
    certificates with the SunMSCAPI provider
    + JDK-6829250: Reg test:
    java/awt/Toolkit/ScreenInsetsTest/ScreenInsetsTest.java fails
    in Windows
    + JDK-7001973: java/awt/Graphics2D/CopyAreaOOB.java fails
    + JDK-8022403: sun/java2d/DirectX/OnScreenRenderingResizeTest/
    /OnScreenRenderingResizeTest.java fails
    + JDK-8028998: [TEST_BUG] [macosx] java/awt/dnd/
    /DropTargetEnterExitTest/MissedDragExitTest.java failed
    + JDK-8029633: Raw inner class constructor ref should not
    perform diamond inference
    + JDK-8030121: java/awt/dnd/MissingDragExitEventTest/
    /MissingDragExitEventTest.java fails
    + JDK-8079267: [TEST_BUG] Test java/awt/Frame/MiscUndecorated/
    /RepaintTest.java fails
    + JDK-8129827: [TEST_BUG] Test java/awt/Robot/RobotWheelTest/
    /RobotWheelTest.java fails
    + JDK-8159599: [TEST_BUG] java/awt/Modal/
    /ModalInternalFrameTest/ModalInternalFrameTest.java
    + JDK-8169187: [macosx] Aqua: java/awt/image/multiresolution/
    /MultiresolutionIconTest.java
    + JDK-8172269: When checking the default behaviour for a scroll
    tab layout and checking the 'opaque' checkbox, the area behind
    tabs is not red.
    + JDK-8178698: javax/sound/midi/Sequencer/MetaCallback.java
    failed with timeout
    + JDK-8193942: Regression automated test '/open/test/jdk/javax/
    /swing/JFrame/8175301/ScaledFrameBackgroundTest.java' fails
    + JDK-8194126: Regression automated Test '/open/test/jdk/javax/
    /swing/JColorChooser/Test7194184.java' fails
    + JDK-8198343: Test java/awt/print/PrinterJob/
    /TestPgfmtSetMPA.java may fail w/o printer
    + JDK-8199290: [TESTBUG]
    sun.hotspot.WhiteBox$WhiteBoxPermission is not copied
    + JDK-8202836: [macosx] test
    java/awt/Graphics/TextAAHintsTest.java fails
    + JDK-8206125: [windows] cannot pass relative path to
  - -with-boot-jdk
    + JDK-8210047: some pages contain content outside of landmark
    region
    + JDK-8211002: test/jdk/java/lang/Math/PowTests.java skips
    testing for non-corner-case values
    + JDK-8212096: javax/net/ssl/ServerName/
    /SSLEngineExplorerMatchedSNI.java failed intermittently due
    to SSLException: Tag mismatch
    + JDK-8213239: Configure cannot handle command overrides with
    arguments
    + JDK-8215571: jdb does not include jdk.* in the default class
    filter
    + JDK-8217032: Check pandoc capabilities in configure
    + JDK-8222091: Javadoc does not handle package annotations
    correctly on package-info.java
    + JDK-8222251: preflow visitor is not visiting lambda
    expressions
    + JDK-8226236: win32: gc/metaspace/
    /TestCapacityUntilGCWrapAround.java fails
    + JDK-8227179: Test for new gc+metaspace=info output format
    + JDK-8227651: Tests fail with SSLProtocolException: Input
    record too big
    + JDK-8228672: [TESTBUG] gc/metaspace/TestSizeTransitions.java
    fails on 32-bit platforms
    + JDK-8233557: [TESTBUG] DoubleClickTitleBarTest.java fails on
    macOs
    + JDK-8233558: [TESTBUG] WindowOwnedByEmbeddedFrameTest.java
    fails on macos
    + JDK-8233565: [TESTBUG] NullModalityDialogTest.java fails on
    MacOS
    + JDK-8233648: [TESTBUG] DefaultMenuBarTest.java failing on
    macos
    + JDK-8239708: Split basics.m4 into basic.m4 and util.m4
    + JDK-8240281: Remove failing assertion code when selecting
    first memory state in SuperWord::co_locate_pack
    + JDK-8242468: VS2019 build missing vcruntime140_1.dll
    + JDK-8243565: some gc tests use 'test.java.opts' and not
    'test.vm.opts'
    + JDK-8243568: serviceability/logging/TestLogRotation.java uses
    'test.java.opts' and not 'test.vm.opts'
    + JDK-8244010: Simplify usages of
    ProcessTools.createJavaProcessBuilder in our tests
    + JDK-8244557: test/jdk/javax/swing/JTabbedPane/
    /TestBackgroundScrollPolicy.java failed
    + JDK-8247676: vcruntime140_1.dll is not needed on 32-bit
    Windows
    + JDK-8249694: java/lang/StringBuffer/HugeCapacity.java and
    j/l/StringBuilder/HugeCapacity.java tests shouldn't be
    @ignore-d
    + JDK-8253877: gc/g1/TestGCLogMessages.java fails - missing
    "Evacuation failure" message
    + JDK-8254874: ZGC: JNIHandleBlock verification failure in
    stack watermark processing
    + JDK-8254976: Re-enable swing jtreg tests which were broken
    due to samevm mode
    + JDK-8255439: System Tray icons get corrupted when Windows
    scaling changes
    + JDK-8256109: Create implementation for NSAccessibilityButton
    protocol
    + JDK-8257679: Improved unix compatibility layer in Windows
    build (winenv)
    + JDK-8257722: Improve "keytool -printcert -jarfile" output
    + JDK-8258005: JDK build fails with incorrect fixpath script
    + JDK-8259485: Document need for short paths when building on
    Windows
    + JDK-8260272: bash configure --prefix does not work after
    JDK-8257679
    + JDK-8261336: IGV: enhance default filters
    + JDK-8261445: Use memory_order_relaxed for os::random().
    + JDK-8261758: [TESTBUG] gc/g1/TestGCLogMessages.java fails if
    ergonomics detect too small InitialHeapSize
    + JDK-8263326: Remove ReceiverTypeData check from
    serviceability/sa/TestPrintMdo.java
    + JDK-8263871: On sem_destroy() failing we should assert
    + JDK-8264593: debug.cpp utilities should be available in
    product builds.
    + JDK-8264666: Change implementation of safeAdd/safeMult in the
    LCMSImageLayout class
    + JDK-8266082: AssertionError in Annotate.fromAnnotations with
  - Xdoclint
    + JDK-8266967: debug.cpp utility find() should print Java
    Object fields.
    + JDK-8268361: Fix the infinite loop in next_line
    + JDK-8268860: Windows-Aarch64 build is failing in GitHub
    actions
    + JDK-8268893: jcmd to trim the glibc heap
    + JDK-8269029: compiler/codegen/TestCharVect2.java fails for
    client VMs
    + JDK-8269873: serviceability/sa/Clhsdb tests are using a C2
    specific VMStruct field
    + JDK-8272123: Problem list 4 jtreg tests which regularly fail
    on macos-aarch64
    + JDK-8273236: keytool does not accurately warn about
    algorithms that are disabled but have additional constraints
    + JDK-8273553: sun.security.ssl.SSLEngineImpl.closeInbound also
    has similar error of JDK-8253368
    + JDK-8273578: javax/swing/JMenu/4515762/bug4515762.java fails
    on macOS 12
    + JDK-8273685: Remove jtreg tag manual=yesno for
    java/awt/Graphics/LCDTextAndGraphicsState.java & show test
    instruction
    + JDK-8274029: Remove jtreg tag manual=yesno for  java/awt/
    /print/Dialog/DialogOrient.java
    + JDK-8274032: Remove jtreg tag manual=yesno for java/awt/print/
    /PrinterJob/ImagePrinting/ImageTypes.java & show test UI
    + JDK-8274296: Update or Problem List tests which may fail with
    uiScale=2 on macOS
    + JDK-8274456: Remove jtreg tag manual=yesno
    java/awt/print/PrinterJob/PageDialogTest.java
    + JDK-8274563: jfr/event/oldobject/TestClassLoaderLeak.java
    fails when GC cycles are not happening
    + JDK-8274597: Some of the dnd tests time out and fail
    intermittently
    + JDK-8275170: Some jtreg sound tests should be marked with
    sound keyword
    + JDK-8275535: Retrying a failed authentication on multiple
    LDAP servers can lead to users blocked
    + JDK-8276841: Add support for Visual Studio 2022
    + JDK-8277159: Fix java/nio/file/FileStore/Basic.java test by
    ignoring /run/user/* mount points
    + JDK-8277497: Last column cell in the JTable row is read as
    empty cell
    + JDK-8277881: Missing SessionID in TLS1.3 resumption in
    compatibility mode
    + JDK-8277970: Test jdk/sun/security/ssl/SSLSessionImpl/
    /NoInvalidateSocketException.java fails with "tag mismatch"
    + JDK-8279066: entries.remove(entry) is useless in
    PKCS12KeyStore
    + JDK-8279695: [TESTBUG] modify compiler/loopopts/
    /TestSkeletonPredicateNegation.java to run on C1 also
    + JDK-8280158: New test from JDK-8274736 failed with/without
    patch in JDK11u
    + JDK-8280550: SplittableRandom#nextDouble(double,double) can
    return result >= bound
    + JDK-8280863: Update build README to reflect that MSYS2 is
    supported
    + JDK-8280890: Cannot use '-Djava.system.class.loader' with
    class loader in signed JAR
    + JDK-8280948: Write a regression test for JDK-4659800
    + JDK-8280950: RandomGenerator:NextDouble() default behavior
    non conformant after JDK-8280550 fix
    + JDK-8281183: RandomGenerator:NextDouble() default behavior
    partially fixed by JDK-8280950
    + JDK-8281296: Create a regression test for JDK-4515999
    + JDK-8281297: TestStressG1Humongous fails with
    guarantee(is_range_uncommitted)
    + JDK-8282046: Create a regression test for JDK-8000326
    + JDK-8282276: Problem list failing two Robot Screen Capture
    tests
    + JDK-8282306: os::is_first_C_frame(frame*) crashes on invalid
    link access
    + JDK-8282345: handle latest VS2022 in abstract_vm_version
    + JDK-8282402: Create a regression test for JDK-4666101
    + JDK-8282640: Create a test for JDK-4740761
    + JDK-8282642: vmTestbase/gc/gctests/LoadUnloadGC2/
    /LoadUnloadGC2.java fails intermittently with exit code 1
    + JDK-8282730: LdapLoginModule throw NPE from logout method
    after login failure
    + JDK-8282777: Create a Regression test for JDK-4515031
    + JDK-8282778: Create a regression test for JDK-4699544
    + JDK-8282857: Create a regression test for JDK-4702690
    + JDK-8282936: Write a regression test for JDK-4615365
    + JDK-8282937: Write a regression test for JDK-4820080
    + JDK-8283199: Linux os::cpu_microcode_revision() stalls cold
    startup
    + JDK-8283422: Create a new test for JDK-8254790
    + JDK-8284294: Create an automated regression test for RFE
    4138746
    + JDK-8284358: Unreachable loop is not removed from C2 IR,
    leading to a broken graph
    + JDK-8284521: Write an automated regression test for RFE
    4371575
    + JDK-8284690: [macos] VoiceOver : Getting
    java.lang.IllegalArgumentException: Invalid location on
    Editable JComboBox
    + JDK-8284732: FFI_GO_CLOSURES macro not defined but required
    for zero build on Mac OS X
    + JDK-8284752: Zero does not build on Mac OS X due to missing
    os::current_thread_enable_wx implementation
    + JDK-8284771: java/util/zip/CloseInflaterDeflaterTest.java
    failed with "AssertionError: Expected IOException to be
    thrown, but nothing was thrown"
    + JDK-8284884: Replace polling with waiting in
    javax/swing/text/html/parser/Parser/8078268/bug8078268.java
    + JDK-8284977: MetricsTesterCgroupV2.getLongValueEntryFromFile
    fails when named value doesn't exist
    + JDK-8285305: Create an automated test for JDK-4495286
    + JDK-8285373: Create an automated test for JDK-4702233
    + JDK-8285604: closed sun/java2d/GdiRendering/
    /ClipShapeRendering.java failed with "Incorrect color ffeeeeee
    instead of ff0000ff in pixel (100, 100)"
    + JDK-8285617: Fix java/awt/print/PrinterJob/ImagePrinting/
    /PrintARGBImage.java manual test
    + JDK-8285698: Create a test to check the focus stealing of
    JPopupMenu from JComboBox
    + JDK-8285794: AsyncGetCallTrace might acquire a lock via
    JavaThread::thread_from_jni_environment
    + JDK-8285836: sun/net/www/http/KeepAliveCache/
    /KeepAliveProperty.java failed with "RuntimeException: Failed
    in server"
    + JDK-8285921: serviceability/dcmd/jvmti/AttachFailed/
    /AttachReturnError.java fails on Alpine
    + JDK-8286624: Regression Test CoordinateTruncationBug.java
    fails on OL8.3
    + JDK-8286663: Resolve IDE warnings in WTrayIconPeer and
    SystemTray
    + JDK-8286772: java/awt/dnd/DropTargetInInternalFrameTest/
    /DropTargetInInternalFrameTest.html times out and fails in
    Windows
    + JDK-8286872: Refactor add/modify notification icon (TrayIcon)
    + JDK-8287076: Document.normalizeDocument() produces different
    results
    + JDK-8287091: aarch64 : guarantee(val < (1ULL << nbits))
    failed: Field too big for insn
    + JDK-8287425: Remove unnecessary register push for
    MacroAssembler::check_klass_subtype_slow_path
    + JDK-8287609: macOS: SIGSEGV at [CoreFoundation]
    CFArrayGetCount / sun.font.CFont.getTableBytesNative
    + JDK-8287724: Fix various issues with msys2
    + JDK-8287826: javax/accessibility/4702233/
    /AccessiblePropertiesTest.java fails to compile
    + JDK-8287895: Some langtools tests fail on msys2
    + JDK-8287896: PropertiesTest.sh fail on msys2
    + JDK-8287902: UnreadableRB case in MissingResourceCauseTest is
    not working reliably on Windows
    + JDK-8287917: System.loadLibrary does not work on Big Sur if
    JDK is built with macOS SDK 10.15 and earlier
    + JDK-8288132: Update test artifacts in QuoVadis CA interop
    tests
    + JDK-8288302: Shenandoah: SIGSEGV in vm maybe related to jit
    compiling xerces
    + JDK-8288377: [REDO] DST not applying properly with zone id
    offset set with TZ env variable
    + JDK-8288445: AArch64: C2 compilation fails with
    guarantee(!true || (true && (shift != 0))) failed: impossible
    encoding
    + JDK-8288599: com/sun/management/OperatingSystemMXBean/
    /TestTotalSwap.java: Expected total swap size ... but
    getTotalSwapSpaceSize returned ...
    + JDK-8288985: P11TlsKeyMaterialGenerator should work with
    ChaCha20-Poly1305
    + JDK-8289043: C2: Vector constant materialization attempt
    + JDK-8289146: containers/docker/TestMemoryWithCgroupV1.java
    fails on linux ppc64le machine with missing Memory and Swap
    Limit output
    + JDK-8290207: Missing notice in dom.md
    + JDK-8290209: jcup.md missing additional text
    + JDK-8290451: Incorrect result when switching to C2 OSR
    compilation from C1
    + JDK-8290529: C2: assert(BoolTest(btest).is_canonical())
    failure
    + JDK-8290705: StringConcat::validate_mem_flow asserts with
    "unexpected user: StoreI"
    + JDK-8290711: assert(false) failed: infinite loop in
    PhaseIterGVN::optimize
    + JDK-8290781: Segfault at
    PhaseIdealLoop::clone_loop_handle_data_uses
    + JDK-8291459: JVM crash with GenerateOopMap::error_work(char
    const*, __va_list_tag*)
    + JDK-8291461: assert(false) failed: bad AD file
    + JDK-8292083: Detected container memory limit may exceed
    physical machine memory
    + JDK-8292158: AES-CTR cipher state corruption with AVX-512
    + JDK-8292541: [Metrics] Reported memory limit may exceed
    physical machine memory
    + JDK-8292682: Code change of JDK-8282730 not updated to
    reflect CSR update
    + JDK-8292778: EncodingSupport_md.c convertUtf8ToPlatformString
    wrong placing of free
    + JDK-8292866:
    Java_sun_awt_shell_Win32ShellFolder2_getLinkLocation check
    MultiByteToWideChar return value for failures
    + JDK-8292887: Bump update version for OpenJDK: jdk-11.0.18
    + JDK-8292899: CustomTzIDCheckDST.java testcase failed on AIX
    platform
    + JDK-8293044: C1: Missing access check on non-accessible class
    + JDK-8293472: Incorrect container resource limit detection if
    manual cgroup fs mounts present
    + JDK-8293540: [Metrics] Incorrectly detected resource limits
    with additional cgroup fs mounts
    + JDK-8293578: Duplicate ldc generated by javac
    + JDK-8293672: Update freetype md file
    + JDK-8293816: CI: ciBytecodeStream::get_klass() is not
    consistent
    + JDK-8293826: Closed test fails after JDK-8276108 on aarch64
    + JDK-8293828: JFR: jfr/event/oldobject/TestClassLoaderLeak.java
    still fails when GC cycles are not happening
    + JDK-8293834: Update CLDR data following tzdata 2022c update
    + JDK-8293998: [PPC64] JfrGetCallTrace: assert(_pc != nullptr)
    failed: must have PC
    + JDK-8294138: [11u] Revert change from JDK-8210962 in basic.m4
    + JDK-8294307: ISO 4217 Amendment 173 Update
    + JDK-8294357: (tz) Update Timezone Data to 2022d
    + JDK-8294578: [PPC64] C2: Missing is_oop information when
    using disjoint compressed oops mode
    + JDK-8294740: Add cgroups keyword to TestDockerBasic.java
    + JDK-8295173: (tz) Update Timezone Data to 2022e
    + JDK-8295288: Some vm_flags tests associate with a wrong BugID
    + JDK-8295322: Tests for JDK-8271459 were not backported to 11u
    + JDK-8295429: Update harfbuzz md file
    + JDK-8295469: S390X: Optimized builds are broken
    + JDK-8295554: Move the "sizecalc.h" to the correct location
    + JDK-8295641: Fix DEFAULT_PROMOTED_VERSION_PRE=ea for -dev
    + JDK-8295714: GHA ::set-output is deprecated and will be
    removed
    + JDK-8295723: security/infra/wycheproof/RunWycheproof.java
    fails with Assertion Error
    + JDK-8295872: [PPC64] JfrGetCallTrace: Need pc == nullptr
    check before frame constructor
    + JDK-8295952: Problemlist existing compiler/rtm tests also on
    x86
    + JDK-8296108: (tz) Update Timezone Data to 2022f
    + JDK-8296239: ISO 4217 Amendment 174 Update
    + JDK-8296480: java/security/cert/pkix/policyChanges/
    /TestPolicy.java is failing
    + JDK-8296485: BuildEEBasicConstraints.java test fails with
    SunCertPathBuilderException
    + JDK-8296496: Overzealous check in sizecalc.h prevents large
    memory allocation
    + JDK-8296632: Write a test to verify the content change of
    TextArea sends TextEvent
    + JDK-8296652: Restore windows aarch64 fixpath patch that was
    removed in 8239708
    + JDK-8296715: CLDR v42 update for tzdata 2022f
    + JDK-8296957: One more cast in SAFE_SIZE_NEW_ARRAY2
    + JDK-8297147: UnexpectedSourceImageSize test times out on slow
    machines when fastdebug is used
    + JDK-8297153: sun/java2d/DirectX/OnScreenRenderingResizeTest/
    /OnScreenRenderingResizeTest.java fails again
    + JDK-8297241: Update sun/java2d/DirectX/
    /OnScreenRenderingResizeTest/OnScreenRenderingResizeTest.java
    + JDK-8297481: Create a regression test for JDK-4424517
    + JDK-8297656: AArch64: Enable AES/GCM Intrinsics
    + JDK-8297804: (tz) Update Timezone Data to 2022g
    + JDK-8298737: 8296772 backport to jdk11u caused build error on
    sparc
    + JDK-8299393: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.18
    + JDK-8299439: java/text/Format/NumberFormat/CurrencyFormat.java
    fails for hr_HR
    + JDK-8299483: ProblemList java/text/Format/NumberFormat/
    /CurrencyFormat.java
    + JDK-8299616: [11u] Bootcycle build fails after JDK-8257679
    backport
* Tue Nov  8 2022 javier@opensuse.org
- Fix jconsole.desktop icon
* Fri Oct 21 2022 fstrba@suse.com
- Update to upstream tag jdk-11.0.17+8 (October 2022 CPU)
  * Security fixes:
    + JDK-8289366, bsc#1204480, CVE-2022-39399: Improve HTTP/2
    client usage
    + JDK-8288508: Enhance ECDSA usage
    + JDK-8286918, bsc#1204472, CVE-2022-21628: Better HttpServer
    service
    + JDK-8287446, bsc#1204475, CVE-2022-21624: Enhance icon
    presentations
    + JDK-8286910: Improve JNDI lookups
    + JDK-8286511: Improve macro allocation
    + JDK-8286526, bsc#1204473, CVE-2022-21619: Improve NTLM support
    + JDK-8286533, bsc#1204471, CVE-2022-21626: Key X509 usages
    + JDK-8286077, bsc#1204468, CVE-2022-21618: Wider MultiByte
    conversions
    + JDK-8286519: Better memory handling
    + JDK-8285662: Better permission resolution
    + JDK-8282252: Improve BigInteger/Decimal validation
    + JDK-8289853: Update HarfBuzz to 4.4.1
    + JDK-8290334: Update FreeType to 2.12.1
    + JDK-8293429: [11u] minor update in attribute style
  * Other fixes:
    + JDK-6606767: resexhausted00[34] fail
    assert(!thread->owns_locks(), "must release all locks when
    leaving VM")
    + JDK-6854300: [TEST_BUG] java/awt/event/MouseEvent/
    /SpuriousExitEnter/SpuriousExitEnter_3.java fails in jdk6u14
    & jdk7
    + JDK-7131823: bug in GIFImageReader
    + JDK-8017175: [TESTBUG] javax/swing/JPopupMenu/4634626/
    /bug4634626.java sometimes failed on mac
    + JDK-8028265: Add legacy tz tests to OpenJDK
    + JDK-8069343: Improve gc/g1/TestHumongousCodeCacheRoots.java
    to use jtreg @requires
    + JDK-8139348: Deprecate 3DES and RC4 in Kerberos
    + JDK-8159694: HiDPI, Unity,
    java/awt/dnd/DropTargetEnterExitTest/MissedDragExitTest.java
    + JDK-8164804: sun/security/ssl/SSLSocketImpl/CloseSocket.java
    makes not reliable time assumption
    + JDK-8169468: NoResizeEventOnDMChangeTest.java fails because
    FS Window didn't receive all resizes!
    + JDK-8172065: javax/swing/JTree/4908142/bug4908142.java The
    selected index should be "aad"
    + JDK-8183372: Refactor java/lang/Class shell tests to java
    + JDK-8186143: keytool -ext option doesn't accept wildcards for
    DNS subject alternative names
    + JDK-8193462: Fix Filer handling of package-info initial
    elements
    + JDK-8203277: preflow visitor used during lambda attribution
    shouldn't visit class definitions inside the lambda body
    + JDK-8208471: nsk/jdb/unwatch/unwatch002/unwatch002.java fails
    with "Prompt is not received during 300200 milliseconds"
    + JDK-8209052: Low contrast in docs/api/constant-values.html
    + JDK-8209736: runtime/RedefineTests/ModifyAnonymous.java fails
    with NullPointerException when running in CDS mode
    + JDK-8210107: vmTestbase/nsk/stress/network tests fail with
    Cannot assign requested address (Bind failed)
    + JDK-8210722: JAXP Tests: CatalogSupport2 and CatalogSupport3
    generate incorrect messages upon failure
    + JDK-8210960: Allow --with-boot-jdk-jvmargs to work during
    configure
    + JDK-8212904: JTextArea line wrapping incorrect when using UI
    scale
    + JDK-8213695: gc/TestAllocateHeapAtMultiple.java is slow in
    some configs
    + JDK-8214078: (fs) SecureDirectoryStream not supported on arm32
    + JDK-8214427: probable bug in logic of
    ConcurrentHashMap.addCount()
    + JDK-8215291: Broken links when generating from project
    without modules
    + JDK-8217170: gc/arguments/TestUseCompressedOopsErgo.java
    timed out
    + JDK-8217332: JTREG: Clean up, use generics instead of raw
    types
    + JDK-8218128: vmTestbase/nsk/jvmti/ResourceExhausted/
    /resexhausted003 and 004 use wrong path to test classes
    + JDK-8218413: make reconfigure ignores configure-time AUTOCONF
    environment variable
    + JDK-8219074: [TESTBUG] runtime/containers/docker/
    /TestCPUAwareness.java typo of printing parameters (period
    should be shares)
    + JDK-8219149: ProcessTools.ProcessBuilder should print timing
    info for subprocesses
    + JDK-8220744: [TESTBUG] Move RedefineTests from runtime to
    serviceability
    + JDK-8221871: javadoc should not set role=region on <section>
    elements
    + JDK-8221907: make reconfigure breaks when configured with
    relative paths
    + JDK-8223543: [TESTBUG] Regression test java/awt/Graphics2D/
    /DrawString/LCDTextSrcEa.java has issues
    + JDK-8223575: add subspace transitions to gc+metaspace=info
    log lines
    + JDK-8225122: Test AncestorResized.java fails when Windows
    desktop is scaled.
    + JDK-8226976: SessionTimeOutTests uses == operator for String
    value check
    + JDK-8230708: Hotspot fails to build on linux-sparc with gcc-9
    + JDK-8233712: Limit default tests jobs based on ulimit -u
    setting
    + JDK-8235870: C2 crashes in
    IdealLoopTree::est_loop_flow_merge_sz()
    + JDK-8236490: Compiler bug relating to @NonNull annotation
    + JDK-8236823: Ensure that API documentation uses minified
    libraries
    + JDK-8238203: Return value of GetUserDefaultUILanguage()
    should be handled as LANGID
    + JDK-8238268: Many SA tests are not running on OSX because
    they do not attempt to use sudo when available
    + JDK-8238196: tests that use SA Attach should not be allowed
    to run against signed binaries on Mac OS X 10.14.5 and later
    + JDK-8238586: [TESTBUG] vmTestbase/jit/tiered/Test.java failed
    when TieredCompilation is disabled
    + JDK-8239265: JFR: Test cleanup of jdk.jfr.api.consumer package
    + JDK-8239379: ProblemList
    serviceability/sa/sadebugd/DebugdConnectTest.java on OSX
    + JDK-8271512: ProblemList serviceability/sa/sadebugd/
    /DebugdConnectTest.java due to 8270326
    + JDK-8239423: jdk/jfr/jvm/TestJFRIntrinsic.java failed with
  - XX:-TieredCompilation
    + JDK-8239902: [macos] Remove direct usage of JSlider,
    JProgressBar classes in CAccessible class
    + JDK-8240903: Add test to check that jmod hashes are
    reproducible
    + JDK-8242188: error in jtreg test jdk/jfr/api/consumer/
    /TestRecordedFrame.java on linux-aarch64
    + JDK-8247546: Pattern matching does not skip correctly over
    supplementary characters
    + JDK-8247907: XMLDsig logging does not work
    + JDK-8247964: All log0() in
    com/sun/org/slf4j/internal/Logger.java should be private
    + JDK-8249623: test @ignore-d due to 7013634 should be returned
    back to execution
    + JDK-8251152: ARM32: jtreg c2 Test8202414 test crash
    + JDK-8251551: Use .md filename extension for README
    + JDK-8252145: Unify Info.plist files with correct version
    strings
    + JDK-8253829: Wrong length compared in SSPI bridge
    + JDK-8253916: ResourceExhausted/resexhausted001 crashes on
    Linux-x64
    + JDK-8254178: Remove .hgignore
    + JDK-8254318: Remove .hgtags
    + JDK-8255724: [XRender] the BlitRotateClippedArea test fails
    on Linux in the XR pipeline
    + JDK-8255729: com.sun.tools.javac.processing.JavacFiler
    .FilerOutputStream  is inefficient
    + JDK-8257623: vmTestbase/nsk/jvmti/ResourceExhausted/
    /resexhausted001/TestDescription.java shouldn't use timeout
    + JDK-8258946: Fix optimization-unstable code involving signed
    integer overflow
    + JDK-8261160: Add a deserialization JFR event
    + JDK-8262085: Hovering Metal HTML Tooltips in different
    windows cause IllegalArgExc on Linux
    + JDK-8264400: (fs) WindowsFileStore equality depends on how
    the FileStore was constructed
    + JDK-8264792: The NumberFormat for locale sq_XK formats price
    incorrectly.
    + JDK-8265100: (fs) WindowsFileStore.hashCode() should read
    cached hash code once
    + JDK-8265531: doc/building.md should mention homebrew install
    freetype
    + JDK-8266250: WebSocketTest and WebSocketProxyTest call
    assertEquals(List<byte[]>, List<byte[]>)
    + JDK-8266254: Update to use jtreg 6 8265020: tests must be
    updated for new TestNG module name
    + JDK-8266460: java.io tests fail on null stream with upgraded
    jtreg/TestNG
    + JDK-8266461: tools/jmod/hashes/HashesTest.java fails: static
    @Test methods 8267180: Typo in copyright header  for
    HashesTest
    + JDK-8266490: Extend the OSContainer API to support the pids
    controller of cgroups
    + JDK-8266675: Optimize IntHashTable for encapsulation and ease
    of use
    + JDK-8266774: System property values for stdout/err on Windows
    UTF-8
    + JDK-8266881: Enable debug log for
    SSLEngineExplorerMatchedSNI.java
    + JDK-8267271: Fix gc/arguments/TestNewRatioFlag.java
    expectedNewSize calculation
    + JDK-8267880: Upgrade the default PKCS12 MAC algorithm
    + JDK-8268185: Update GitHub Actions for jtreg 6
    + JDK-8269039: Disable SHA-1 Signed JARs
    + JDK-8269517: compiler/loopopts/
    /TestPartialPeelingSinkNodes.java crashes with
  - XX:+VerifyGraphEdges
    + JDK-8270090: C2: LCM may prioritize CheckCastPP nodes over
    projections
    + JDK-8270312: Error: Not a test or directory containing tests:
    java/awt/print/PrinterJob/XparColor.java
    + JDK-8271010: vmTestbase/gc/lock/malloc/malloclock04/
    /TestDescription.java crashes intermittently
    + JDK-8271078: jdk/incubator/vector/Float128VectorTests.java
    failed a subtest
    + JDK-8272352: Java launcher can not parse Chinese character
    when system locale is set to UTF-8
    + JDK-8272398: Update DockerTestUtils.buildJdkDockerImage()
    + JDK-8273526: Extend the OSContainer API  pids controller with
    pids.current
    + JDK-8274506: TestPids.java and TestPidsLimit.java fail with
    podman run as root
    + JDK-8274517: java/util/DoubleStreamSums/CompensatedSums.java
    fails with expected [true] but found [false]
    + JDK-8274687: JDWP deadlocks if some Java thread reaches wait
    in blockOnDebuggerSuspend
    + JDK-8275008: gtest build failure due to stringop-overflow
    warning with gcc11
    + JDK-8275689: [TESTBUG] Use color tolerance only for XRender
    in BlitRotateClippedArea test
    + JDK-8275887: jarsigner prints invalid digest/signature
    algorithm warnings if keysize is weak/disabled
    + JDK-8277893: Arraycopy stress tests
    + JDK-8278067: Make HttpURLConnection default keep alive
    timeout configurable
    + JDK-8278344: sun/security/pkcs12/
    /KeytoolOpensslInteropTest.java test fails because of
    different openssl output
    + JDK-8278519: serviceability/jvmti/FieldAccessWatch/
    /FieldAccessWatch.java failed "assert(handle != __null)
    failed: JNI handle should not be null"
    + JDK-8279032: compiler/loopopts/
    /TestSkeletonPredicateNegation.java times out with
  - XX:TieredStopAtLevel < 4
    + JDK-8279385: [test]  Adjust sun/security/pkcs12/
    /KeytoolOpensslInteropTest.java after 8278344
    + JDK-8279622: C2: miscompilation of map pattern as a vector
    reduction
    + JDK-8280913: Create a regression test for
    JRootPane.setDefaultButton() method
    + JDK-8281181: Do not use CPU Shares to compute active
    processor count
    + JDK-8281535: Create a regression test for JDK-4670051
    + JDK-8281569: Create tests for Frame.setMinimumSize() method
    + JDK-8281628: KeyAgreement : generateSecret intermittently not
    resetting
    + JDK-8281738: Create a regression test for checking the
    'Space' key activation of focused Button
    + JDK-8281745: Create a regression test for JDK-4514331
    + JDK-8281988: Create a regression test for JDK-4618767
    + JDK-8282214: Upgrade JQuery to version 3.6.0
    + JDK-8282234: Create a regression test for JDK-4532513
    + JDK-8282280: Update Xerces to Version 2.12.2
    + JDK-8282343: Create a regression test for JDK-4518432
    + JDK-8282538: PKCS11 tests fail on CentOS Stream 9
    + JDK-8282548: Create a regression test for JDK-4330998
    + JDK-8282555: Missing memory edge when spilling MoveF2I,
    MoveD2L etc
    + JDK-8282789: Create a regression test for the JTree usecase
    of JDK-4618767
    + JDK-8282860: Write a regression test for JDK-4164779
    + JDK-8282933: Create a test for JDK-4529616
    + JDK-8282947: JFR: Dump on shutdown live-locks in some
    conditions
    + JDK-8283015: Create a test for JDK-4715496
    + JDK-8283017: GHA: Workflows break with update release versions
    + JDK-8283087: Create a test or JDK-4715503
    + JDK-8283245: Create a test for JDK-4670319
    + JDK-8283277: ISO 4217 Amendment 171 Update
    + JDK-8283441: C2: segmentation fault in
    ciMethodBlocks::make_block_at(int)
    + JDK-8283493: Create an automated regression test for RFE
    4231298
    + JDK-8283507: Create a regression test for RFE 4287690
    + JDK-8283621: Write a regression test for CCC4400728
    + JDK-8283623: Create an automated regression test for
    JDK-4525475
    + JDK-8283624: Create an automated regression test for
    RFE-4390885
    + JDK-8283803: Remove jtreg tag manual=yesno for
    java/awt/print/PrinterJob/PrintGlyphVectorTest.java and fix
    test
    + JDK-8284898: Enhance PassFailJFrame
    + JDK-8283849: AsyncGetCallTrace may crash JVM on guarantee
    + JDK-8283903: GetContainerCpuLoad does not return the correct
    result in share mode
    + JDK-8284077: Create an automated test for JDK-4170173
    + JDK-8284367: JQuery UI upgrade from 1.12.1 to 1.13.1
    + JDK-8284535: Fix PrintLatinCJKTest.java test that is failing
    with Parse Exception
    + JDK-8283712: Create a manual test framework class
    + JDK-8284680: sun.font.FontConfigManager.getFontConfig() leaks
    charset
    + JDK-8284694: Avoid evaluating SSLAlgorithmConstraints twice
    + JDK-8284754: print more interesting env variables in hs_err
    and VM.info
    + JDK-8284758: [linux] improve print_container_info
    + JDK-8284882: SIGSEGV in Node::verify_edges due to compilation
    bailout
    + JDK-8284944: assert(cnt++ < 40) failed: infinite cycle in
    loop optimization
    + JDK-8284950: CgroupV1 detection code should consider
    memory.swappiness
    + JDK-8284956: Potential leak awtImageData/color_data when
    initializes X11GraphicsEnvironment
    + JDK-8285081: Improve XPath operators count accuracy
    + JDK-8285097: Duplicate XML keys in XPATHErrorResources.java
    and XSLTErrorResources.java
    + JDK-8285380: Fix typos in security
    + JDK-8285398: Cache the results of constraint checks
    + JDK-8285693: Create an automated test for JDK-4702199
    + JDK-8285696: AlgorithmConstraints:permits not throwing
    IllegalArgumentException when 'alg'  is null
    + JDK-8285728: Alpine Linux build fails with busybox tar
    + JDK-8285820: C2: LCM prioritizes locally dependent CreateEx
    nodes over projections after 8270090
    + JDK-8286114: [test] show real exception in bomb call in
    sun/rmi/runtime/Log/checkLogging/CheckLogging.java
    + JDK-8286177: C2: "failed: non-reduction loop contains
    reduction nodes" assert failure
    + JDK-8286211: Update PCSC-Lite for Suse Linux to 1.9.5
    + JDK-8286314: Trampoline not created for far runtime targets
    outside small CodeCache
    + JDK-8286582: Build fails on macos aarch64 when using
  - -with-zlib=bundled
    + JDK-8287017: Bump update version for OpenJDK: jdk-11.0.17
    + JDK-8287073: NPE from CgroupV2Subsystem.getInstance()
    + JDK-8287107: CgroupSubsystemFactory.setCgroupV2Path asserts
    with freezer controller
    + JDK-8287202: GHA: Add macOS aarch64 to the list of default
    platforms for workflow_dispatch event
    + JDK-8287223: C1: Inlining attempt through MH::invokeBasic()
    with null receiver
    + JDK-8287336: GHA: Workflows break on patch versions
    + JDK-8287366: Improve test failure reporting in GHA
    + JDK-8287432: C2: assert(tn->in(0) != __null) failed: must
    have live top node
    + JDK-8287463: JFR: Disable TestDevNull.java on Windows
    + JDK-8287663: Add a regression test for JDK-8287073
    + JDK-8287672: jtreg test com/sun/jndi/ldap/
    /LdapPoolTimeoutTest.java fails intermittently in nightly run
    + JDK-8287741: Fix of JDK-8287107 (unused cgv1 freezer
    controller) was incomplete
    + JDK-8288360: CI: ciInstanceKlass::implementor() is not
    consistent for well-known classes
    + JDK-8288467: remove memory_operand assert for spilled
    instructions
    + JDK-8288754: GCC 12 fails to build zReferenceProcessor.cpp
    + JDK-8288763: Pack200 extraction failure with invalid size
    + JDK-8288781: C1: LIR_OpVisitState::maxNumberOfOperands too
    small
    + JDK-8288865: [aarch64] LDR instructions must use legitimized
    addresses
    + JDK-8288928: Incorrect GPL header in pnglibconf.h (backport
    of JDK-8185041)
    + JDK-8289471: Issue in Initialization of keys in ErrorMsg.java
    and XPATHErrorResources.java
    + JDK-8289477: Memory corruption with CPU_ALLOC, CPU_FREE on
    muslc
    + JDK-8289486: Improve XSLT XPath operators count efficiency
    + JDK-8289549: ISO 4217 Amendment 172 Update
    + JDK-8289569: [test] java/lang/ProcessBuilder/Basic.java fails
    on Alpine/musl
    + JDK-8289799: Build warning in methodData.cpp memset
    zero-length parameter
    + JDK-8289856: [PPC64] SIGSEGV in C2Compiler::init_c2_runtime()
    after JDK-8289060
    + JDK-8290000: Bump macOS GitHub actions to macOS 11
    + JDK-8290004: [PPC64] JfrGetCallTrace: assert(_pc != nullptr)
    failed: must have PC
    + JDK-8290198: Shenandoah: a few Shenandoah tests failure after
    JDK-8214799 11u backport
    + JDK-8290246: test fails "assert(init != __null) failed:
    initialization not found"
    + JDK-8290813: jdk/nashorn/api/scripting/test/
    /ScriptObjectMirrorTest.java fails: assertEquals is ambiguous
    + JDK-8290886: [11u]: Backport of JDK-8266250 introduced test
    failures
    + JDK-8291570: [TESTBUG] Part of JDK-8250984 absent from 11u
    + JDK-8291713: assert(!phase->exceeding_node_budget()) failed:
    sanity after JDK-8223389
    + JDK-8291794: [11u] Corrections after backport of JDK-8212028
    + JDK-8292255: Bump update version for OpenJDK: jdk-11.0.16.1
    + JDK-8292260: [BACKOUT] JDK-8279219: [REDO] C2 crash when
    allocating array of size too large (bsc#1204523)
    + JDK-8292579: (tz) Update Timezone Data to 2022c
    + JDK-8292852: [11u] TestMemoryWithCgroupV1 fails after
    JDK-8292768
    + JDK-8295057: [11u] Remove designator
    DEFAULT_PROMOTED_VERSION_PRE=ea for release 11.0.17
- Modified patch:
  * fips.patch
    + sync with newest RedHat version
* Sat Sep 17 2022 fstrba@suse.com
- Package the JAVA_HOME/release files in *-headless package
  * fixes boo#1203476
* Thu Jul 21 2022 fstrba@suse.com
- Update to upstream tag jdk-11.0.16+8 (July 2022 CPU)
  * Security fixes:
    + JDK-8272243: Improve DER parsing
    + JDK-8272249: Better properties of loaded Properties
    + JDK-8277608: Address IP Addressing
    + JDK-8281859, CVE-2022-21540, bsc#1201694: Improve class
    compilation
    + JDK-8281866, CVE-2022-21541, bsc#1201692: Enhance
    MethodHandle invocations
    + JDK-8283190: Improve MIDI processing
    + JDK-8284370: Improve zlib usage
    + JDK-8285407, CVE-2022-34169, bsc#1201684: Improve Xalan
    supports
  * Other fixes:
    + JDK-6986863: ProfileDeferralMgr throwing
    ConcurrentModificationException
    + JDK-7124293: [macosx] VoiceOver reads percentages rather than
    the actual values for sliders.
    + JDK-7124301: [macosx] When in a tab group if you arrow
    between tabs there are no VoiceOver announcements.
    + JDK-8133713: [macosx] Accessible JTables always reported as
    empty
    + JDK-8139046: Compiler Control: IGVPrintLevel directive should
    set PrintIdealGraph
    + JDK-8139173: [macosx] JInternalFrame shadow is not properly
    drawn
    + JDK-8163498: Many long-running security libs tests
    + JDK-8166727: javac crashed: [jimage.dll+0x1942]
    ImageStrings::find+0x28
    + JDK-8169004: Fix redundant @requires tags in tests
    + JDK-8181571: printing to CUPS fails on mac sandbox app
    + JDK-8182404: remove jdk.testlibrary.JDKToolFinder and
    JDKToolLauncher
    + JDK-8186548: move jdk.testlibrary.JcmdBase closer to tests
    + JDK-8192057: com/sun/jdi/BadHandshakeTest.java fails with
    java.net.ConnectException
    + JDK-8193682: Infinite loop in ZipOutputStream.close()
    + JDK-8199874: [TESTBUG] runtime/Thread/ThreadPriorities.java
    fails with "expected 0 to equal 10"
    + JDK-8202886: [macos] Test java/awt/MenuBar/8007006/
    /bug8007006.java fails on MacOS
    + JDK-8203238: [TESTBUG] rewrite MemOptions shell test in Java
    + JDK-8203239: [TESTBUG] remove vmTestbase/vm/gc/kind/parOld
    test
    + JDK-8206187: javax/management/remote/mandatory/connection/
    /DefaultAgentFilterTest.java fails with Port already in use
    + JDK-8206330: Revisit com/sun/jdi/RedefineCrossEvent.java
    + JDK-8207364: nsk/jvmti/ResourceExhausted/resexhausted003
    fails to start
    + JDK-8208207: Test nsk/stress/jni/gclocker/gcl001 fails after
    co-location
    + JDK-8208246: flags duplications in
    vmTestbase_vm_g1classunloading tests
    + JDK-8208249: TriggerUnloadingByFillingMetaspace generates
    garbage class names
    + JDK-8208697: vmTestbase/metaspace/stressHierarchy/
    /stressHierarchy012/TestDescription.java fails with
    OutOfMemoryError: Metaspace
    + JDK-8209150: [TESTBUG] Add logging to verify JDK-8197901 to a
    different test
    + JDK-8209776: Refactor jdk/security/JavaDotSecurity/ifdefs.sh
    to plain java test
    + JDK-8209883: ZGC: Compile without C1 broken
    + JDK-8209920: runtime/logging/RedefineClasses.java fail with
    OOME with ZGC
    + JDK-8210022: remove jdk.testlibrary.ProcessThread, TestThread
    and XRun
    + JDK-8210039: move OSInfo to top level testlibrary
    + JDK-8210108: sun/tools/jstatd test build failures after
    JDK-8210022
    + JDK-8210112: remove jdk.testlibrary.ProcessTools
    + JDK-8210649: AssertionError @
    jdk.compiler/com.sun.tools.javac.comp.Modules.enter
    (Modules.java:244)
    + JDK-8210732: remove jdk.testlibrary.Utils
    + JDK-8211795: ArrayIndexOutOfBoundsException in PNGImageReader
    after JDK-6788458
    + JDK-8211822: Some tests fail after JDK-8210039
    + JDK-8211962: Implicit narrowing in MacOSX java.desktop jsound
    + JDK-8212151: jdi/ExclusiveBind.java times out due to "bind
    failed: Address already in use" on Solaris-X64
    + JDK-8213440: Lingering INCLUDE_ALL_GCS in
    test_oopStorage_parperf.cpp
    + JDK-8214275: CondyRepeatFailedResolution asserts "Dynamic
    constant has no fixed basic type"
    + JDK-8214799: Add package declaration to each JTREG test case
    in the gc folder
    + JDK-8215544: SA: Modify ClhsdbLauncher to add sudo privileges
    to enable MacOS tests on Mach5
    + JDK-8216137: assert(Compile::current()->live_nodes() <
    Compile::current()->max_node_limit()) failed: Live Node limit
    exceeded limit
    + JDK-8216265: [testbug] Introduce
    Platform.sharedLibraryPathVariableName() and adapt all tests.
    + JDK-8217017: [TESTBUG] Tests fail to compile after JDK-8216265
    + JDK-8217233: Update build settings for AIX/xlc
    + JDK-8217340: Compilation failed:
    tools/launcher/Test7029048.java
    + JDK-8217473: SA: Tests using ClhsdbLauncher fail on SAP
    docker containers
    + JDK-8218136: minor hotspot adjustments for xlclang++ from
    xlc16 on AIX
    + JDK-8218751: Do not store original classfiles inside the CDS
    archive
    + JDK-8218965: aix:  support xlclang++ in the compiler detection
    + JDK-8220658: Improve the readability of container information
    in the error log
    + JDK-8220813: update hotspot tier1_gc tests depending on GC to
    use @requires vm.gc.X
    + JDK-8222799: java.beans.Introspector uses an obsolete methods
    cache
    + JDK-8222926: Shenandoah build fails with
  - -with-jvm-features=-compiler1
    + JDK-8223143: Restructure/clean-up for 'loopexit_or_null()'.
    + JDK-8223363: Bad node estimate assertion failure
    + JDK-8223502: Node estimate for loop unswitching is not
    correct: assert(delta <= 2 * required) failed: Bad node estimate
    + JDK-8224648: assert(!exceeding_node_budget()) failed: Too
    many NODES required! failure with ctw
    + JDK-8223389: Shenandoah optimizations fail with
    assert(!phase->exceeding_node_budget())
    + JDK-8223396: [TESTBUG] several jfr tests do not clean up
    files created in /tmp
    + JDK-8225475: Node budget asserts on x86_32/64
    + JDK-8227171: provide function names in native stack trace on
    aix with xlc16
    + JDK-8227389: Remove unsupported xlc16 compile options on aix
    + JDK-8229210: [TESTBUG] Move gc stress tests from JFR
    directory tree to gc/stress
    + JDK-8229486: Replace wildcard address with loopback or local
    host in tests - part 21
    + JDK-8229499: Node budget assert in fuzzed test
    + JDK-8230305: Cgroups v2: Container awareness
    + JDK-8229202: Docker reporting causes secondary crashes in
    error handling
    + JDK-8216366: Add rationale to PER_CPU_SHARES define
    + JDK-8230865: [TESTBUG] jdk/jfr/event/io/EvilInstrument.java
    fails at-run shell MakeJAR.sh target
    + JDK-8231111: Cgroups v2: Rework Metrics in java.base so as to
    recognize unified hierarchy
    + JDK-8231454: File lock in Windows on a loaded jar due to a
    leak in Introspector::getBeanInfo
    + JDK-8231489: GC watermark_0_1 failed due to
    "metaspace.gc.Fault: GC has happened too rare"
    + JDK-8231565: More node budget asserts in fuzzed tests
    + JDK-8233551: [TESTBUG] SelectEditTableCell.java fails on MacOS
    + JDK-8234382: Test tools/javac/processing/model/
    /testgetallmembers/Main.java using too small heap
    + JDK-8234605: C2 failed "assert(C->live_nodes() -
    live_at_begin <= 2 * _nodes_required) failed: Bad node
    estimate: actual = 208 >> request = 101"
    + JDK-8234608: [TESTBUG] Fix G1 redefineClasses tests and a
    memory leak
    + JDK-8235220: ClhsdbScanOops.java fails with
    sun.jvm.hotspot.types.WrongTypeException
    + JDK-8235385: Crash on aarch64 JDK due to long offset
    + JDK-8237479: 8230305 causes slowdebug build failure
    + JDK-8239559: Cgroups: Incorrect detection logic on some
    systems
    + JDK-8239785: Cgroups: Incorrect detection logic on old
    systems in hotspot
    + JDK-8240132: ProblemList com/sun/jdi/InvokeHangTest.java
    + JDK-8240189: [TESTBUG] Some cgroup tests are failing after
    JDK-8231111
    + JDK-8240335: C2: assert(found_sfpt) failed: no node in loop
    that's not input to safepoint
    + JDK-8240734: ModuleHashes attribute not reproducible between
    builds
    + JDK-8240756: [macos] SwingSet2:TableDemo:Printed Japanese
    characters were garbled
    + JDK-8241707: introduce randomness k/w to hotspot test suite
    + JDK-8242310: use reproducible random in hotspot compiler tests
    + JDK-8242311: use reproducible random in hotspot runtime tests
    + JDK-8242312: use reproducible random in hotspot gc tests
    + JDK-8242313: use reproducible random in hotspot svc tests
    + JDK-8242538: java/security/SecureRandom/ThreadSafe.java
    failed on windows
    + JDK-8243429: use reproducible random in :vmTestbase_nsk_stress
    + JDK-8243666: ModuleHashes attribute generated for JMOD and
    JAR files depends on timestamps
    + JDK-8244500: jtreg test error in test/hotspot/jtreg/
    /containers/docker/TestMemoryAwareness.java
    + JDK-8244602: Add JTREG_REPEAT_COUNT to repeat execution of a
    test
    + JDK-8245543: Cgroups: Incorrect detection logic on some
    systems (still reproducible)
    + JDK-8245938: Remove unused print_stack(void) method from
    XToolkit.c
    + JDK-8246494: introduce vm.flagless at-requires property
    + JDK-8246741: NetworkInterface/UniqueMacAddressesTest: mac
    address uniqueness test failed
    + JDK-8247589: Implementation of Alpine Linux/x64 Port
    + JDK-8247591: Document Alpine Linux build steps in OpenJDK
    build guide
    + JDK-8247592: refactor test/jdk/tools/launcher/Test7029048.java
    + JDK-8247614: java/nio/channels/DatagramChannel/Connect.java
    timed out
    + JDK-8248876: LoadObject with bad base address created for
    exec file on linux
    + JDK-8249592: Robot.mouseMove moves cursor to incorrect
    location when display scale varies and Java runs in DPI
    Unaware mode
    + JDK-8252117: com/sun/jdi/BadHandshakeTest.java failed with
    "ConnectException: Connection refused: connect"
    + JDK-8252248: __SIGRTMAX is not declared in musl libc
    + JDK-8252250: isnanf is obsolete
    + JDK-8252359: HotSpot Not Identifying it is Running in a
    Container
    + JDK-8252957: Wrong comment in CgroupV1Subsystem::cpu_quota
    + JDK-8253435: Cgroup: 'stomping of _mount_path' crash if
    manually mounted cpusets exist
    + JDK-8253714: [cgroups v2] Soft memory limit incorrectly using
    memory.high
    + JDK-8253727: [cgroups v2] Memory and swap limits reported
    incorrectly
    + JDK-8253797: [cgroups v2] Account for the fact that swap
    accounting is disabled on some systems
    + JDK-8253872: ArgumentHandler must use the same delimiters as
    in jvmti_tools.cpp
    + JDK-8253939: [TESTBUG] Increase coverage of the cgroups
    detection code
    + JDK-8254001: [Metrics] Enhance parsing of cgroup interface
    files for version detection
    + JDK-8254887: C2: assert(cl->trip_count() > 0) failed: peeling
    a fully unrolled loop
    + JDK-8254997: Remove unimplemented
    OSContainer::read_memory_limit_in_bytes
    + JDK-8255266: Update Public Suffix List to 3c213aa
    + JDK-8255604: java/nio/channels/DatagramChannel/Connect.java
    fails with java.net.BindException: Cannot assign requested
    address: connect
    + JDK-8255787: Tag container tests that use cGroups with
    cgroups keyword
    + JDK-8256146: Cleanup test/jdk/java/nio/channels/
    /DatagramChannel/Connect.java
    + JDK-8256722: handle VC++:1927 VS2019 in  abstract_vm_version
    + JDK-8257794: Zero: assert(istate->_stack_limit ==
    istate->_thread->last_Java_sp() + 1) failed: wrong on
    Linux/x86_32
    + JDK-8258795: Update IANA Language Subtag Registry to Version
    2021-05-11
    + JDK-8258956: Memory Leak in StringCoding on ThreadLocal
    resultCached StringCoding.Result
    + JDK-8259517: Incorrect test path in test cases
    + JDK-8260518: Change default -mmacosx-version-min to 10.12
    + JDK-8261169: Upgrade HarfBuzz to the latest 2.8.0
    + JDK-8262379: Add regression test for JDK-8257746
    + JDK-8263364: sun/net/www/http/KeepAliveStream/
    /KeepAliveStreamCloseWithWrongContentLength.java wedged in
    getInputStream
    + JDK-8263718: unused-result warning happens at os_linux.cpp
    + JDK-8263856: Github Actions for macos/aarch64 cross-build
    + JDK-8264179: [TESTBUG] Some compiler tests fail when running
    without C2
    + JDK-8265261: java/nio/file/Files/InterruptCopy.java fails
    with java.lang.RuntimeException: Copy was not interrupted
    + JDK-8265297: javax/net/ssl/SSLSession/
    /TestEnabledProtocols.java failed with "RuntimeException:
    java.net.SocketException: Connection reset"
    + JDK-8265343: Update Debian-based cross-compilation recipes
    + JDK-8266251: compiler.inlining.InlineAccessors shouldn't do
    testing in driver VM
    + JDK-8266318: Switch to macos prefix for macOS bundles
    + JDK-8266391: Replace use of reflection in
    jdk.internal.platform.Metrics
    + JDK-8266545: 8261169 broke Harfbuzz build with gcc 7 and 8
    + JDK-8268773: Improvements related to: Failed to start thread
  - pthread_create failed (EAGAIN)
    + JDK-8269772: [macos-aarch64] test compilation failed with
    "SocketException: No buffer space available"
    + JDK-8269933: test/jdk/javax/net/ssl/compatibility/JdkInfo
    incorrect verification of protocol and cipher support
    + JDK-8270797: ShortECDSA.java test is not complete
    + JDK-8271055: Crash during deoptimization with
    "assert(bb->is_reachable()) failed: getting result from
    unreachable basicblock" with -XX:+VerifyStack
    + JDK-8271199: Mutual TLS handshake fails signing client
    certificate with custom sensitive PKCS11 key
    + JDK-8272167: AbsPathsInImage.java should skip *.dSYM
    directories
    + JDK-8272358: Some tests may fail when executed with other
    locales than the US
    + JDK-8272493: Suboptimal code generation around
    Preconditions.checkIndex intrinsic with AVX2
    + JDK-8272908: Missing coverage for certain classes in
    com.sun.org.apache.xml.internal.security
    + JDK-8272964: java/nio/file/Files/InterruptCopy.java fails
    with java.lang.RuntimeException: Copy was not interrupted
    + JDK-8273176: handle latest VS2019 in abstract_vm_version
    + JDK-8273655: content-types.properties files are missing some
    common types
    + JDK-8274171: java/nio/file/Files/probeContentType/Basic.java
    failed on "Content type" mismatches
    + JDK-8274233: Minor cleanup for ToolBox
    + JDK-8274735: javax.imageio.IIOException: Unsupported Image
    Type while processing a valid JPEG image
    + JDK-8274751: Drag And Drop hangs on Windows
    + JDK-8275082: Update XML Security for Java to 2.3.0
    + JDK-8275330: C2:  assert(n->is_Root() || n->is_Region() ||
    n->is_Phi() || n->is_MachMerge() ||
    def_block->dominates(block)) failed: uses must be dominated
    by definitions
    + JDK-8275337: C1: assert(false) failed: live_in set of first
    block must be empty
    + JDK-8276657: XSLT compiler tries to define a class with empty
    name
    + JDK-8276990: Memory leak in invoker.c fillInvokeRequest()
    during JDI operations
    + JDK-8277072: ObjectStreamClass caches keep ClassLoaders alive
    + JDK-8277093: Vector should throw ClassNotFoundException for a
    missing class of an element
    + JDK-8277396: [TESTBUG] In DefaultButtonModelCrashTest.java,
    frame is accessed from main thread
    + JDK-8277422: tools/jar/JarEntryTime.java fails with modified
    time mismatch
    + JDK-8277922: Unable to click JCheckBox in JTable through Java
    Access Bridge
    + JDK-8278065: Refactor subclassAudits to use ClassValue
    + JDK-8278186: org.jcp.xml.dsig.internal.dom.Utils
    .parseIdFromSameDocumentURI throws
    StringIndexOutOfBoundsException when calling substring method
    + JDK-8278346: java/nio/file/Files/probeContentType/Basic.java
    fails on Linux SLES15 machine
    + JDK-8278472: Invalid value set to CANDIDATEFORM structure
    + JDK-8278794: Infinite loop in DeflaterOutputStream.finish()
    + JDK-8278851: Correct signer logic for jars signed with
    multiple digestalgs
    + JDK-8278951: containers/cgroup/PlainRead.java fails on Ubuntu
    21.10
    + JDK-8279219: [REDO] C2 crash when allocating array of size
    too large
    + JDK-8279356: Method linking fails with
    guarantee(mh->adapter() != NULL) failed: Adapter blob must
    already exist!
    + JDK-8279505: Update documentation for RETRY_COUNT and
    REPEAT_COUNT
    + JDK-8279520: SPNEGO has not passed channel binding info into
    the underlying mechanism
    + JDK-8279529: ProblemList java/nio/channels/DatagramChannel/
    /ManySourcesAndTargets.java on macosx-aarch64
    + JDK-8279532: ProblemList sun/security/ssl/SSLSessionImpl/
    /NoInvalidateSocketException.java
    + JDK-8279668: x86: AVX2 versions of vpxor should be asserted
    + JDK-8279837: C2: assert(is_Loop()) failed: invalid node
    class: Region
    + JDK-8279842: HTTPS Channel Binding support for Java
    GSS/Kerberos
    + JDK-8279958: Provide configure hints for Alpine/apk package
    managers
    + JDK-8280041: Retry loop issues in java.io.ClassCache
    + JDK-8280373: Update Xalan serializer / SystemIDResolver to
    align with JDK-8270492
    + JDK-8280476: [macOS] : hotspot arm64 bug exposed by latest
    clang
    + JDK-8280684: JfrRecorderService failes with
    guarantee(num_written > 0) when no space left on device.
    + JDK-8280799: С2: assert(false) failed: cyclic dependency
    prevents range check elimination
    + JDK-8280867: Cpuid1Ecx feature parsing is incorrect for AMD
    CPUs
    + JDK-8280964: [Linux aarch64] : drawImage dithers
    TYPE_BYTE_INDEXED images incorrectly
    + JDK-8281274: deal with ActiveProcessorCount in
    os::Linux::print_container_info
    + JDK-8281275: Upgrading from 8 to 11 no longer accepts '/' as
    filepath separator in gc paths
    + JDK-8281615: Deadlock caused by jdwp agent
    + JDK-8281811: assert(_base == Tuple) failed: Not a Tuple after
    JDK-8280799
    + JDK-8282008: Incorrect handling of quoted arguments in
    ProcessBuilder
    + JDK-8282172: CompileBroker::log_metaspace_failure is called
    from non-Java/compiler threads
    + JDK-8282225: GHA: Allow one concurrent run per PR only
    + JDK-8282231: x86-32: runtime call to SharedRuntime::ldiv
    corrupts registers
    + JDK-8282293: Domain value for system property
    jdk.https.negotiate.cbt should be case-insensitive
    + JDK-8282312: Minor corrections to evbroadcasti32x4 intrinsic
    on x86
    + JDK-8282382: Report glibc malloc tunables in error reports
    + JDK-8282422: JTable.print() failed with
    UnsupportedCharsetException on AIX ko_KR locale
    + JDK-8282501: Bump update version for OpenJDK: jdk-11.0.16
    + JDK-8282583: Update BCEL md to include the copyright notice
    + JDK-8282588: [11] set harfbuzz compilation flag to -std=c++11
    + JDK-8282589: runtime/ErrorHandling/ErrorHandler.java fails on
    MacOS aarch64 in jdk 11
    + JDK-8282887: Potential memory leak in sun.util.locale.provider
    .HostLocaleProviderAdapterImpl.getNumberPattern() on Windows
    + JDK-8283018: 11u GHA: Update GCC 9 minor versions
    + JDK-8283217: Leak FcObjectSet in getFontConfigLocations() in
    fontpath.c
    + JDK-8283323: libharfbuzz optimization level results in
    extreme build times
    + JDK-8283350: (tz) Update Timezone Data to 2022a
    + JDK-8283408: Fix a C2 crash when filling arrays with unsafe
    + JDK-8283420: [AOT] Exclude TrackedFlagTest/NotTrackedFlagTest
    in 11u because of intermittent java.lang.AssertionError:
    duplicate classes for name Ljava/lang/Boolean;
    + JDK-8283424: compiler/loopopts/
    /LoopUnswitchingBadNodeBudget.java fails with release VMs due
    to lack of -XX:+UnlockDiagnosticVMOptions
    + JDK-8283451: C2: assert(_base == Long) failed: Not a Long
    + JDK-8283469: Don't use memset to initialize members in
    FileMapInfo and fix memory leak
    + JDK-8283497: [windows] print TMP and TEMP in hs_err and
    VM.info
    + JDK-8283614: [11] Repair compiler versions handling after
    8233787
    + JDK-8283641: Large value for CompileThresholdScaling causes
    assert
    + JDK-8283834: Unmappable character for US-ASCII encoding in
    TestPredicateInputBelowLoopPredicate
    + JDK-8284033: Leak XVisualInfo in getAllConfigs in
    awt_GraphicsEnv.c
    + JDK-8284094: Memory leak in invoker_completeInvokeRequest()
    + JDK-8284102: [TESTBUG] [11u] Retroactively add regression
    test for JDK-8272124
    + JDK-8284369: TestFailedAllocationBadGraph fails with
  - XX:TieredStopAtLevel < 4
    + JDK-8284389: Improve stability of GHA Pre-submit testing by
    caching cygwin installer
    + JDK-8284458: CodeHeapState::aggregate() leaks blob_name
    + JDK-8284507: GHA: Only check test results if testing was not
    skipped
    + JDK-8284549: JFR: FieldTable leaks FieldInfoTable member
    + JDK-8284573: [11u] ProblemList TestBubbleUpRef.java and
    TestGCOldWithCMS.java because of 8272195
    + JDK-8284604: [11u] Update Boot JDK used in GHA to 11.0.14.1
    + JDK-8284620: CodeBuffer may leak _overflow_arena
    + JDK-8284622: Update versions of some Github Actions used in
    JDK workflow
    + JDK-8284756: [11u] Remove unused isUseContainerSupport in
    CgroupV1Subsystem
    + JDK-8285395: [JVMCI] [11u] Partial backport of JDK-8220623:
    InstalledCode
    + JDK-8285397: JNI exception pending in CUPSfuncs.c:250
    + JDK-8285445: cannot open file "NUL:"
    + JDK-8285515: (dc) DatagramChannel.disconnect fails with
    "Invalid argument" on macOS 12.4
    + JDK-8285523: Improve test
    java/io/FileOutputStream/OpenNUL.java
    + JDK-8285591: [11] add signum checks in DSA.java engineVerify
    + JDK-8285686: Update FreeType to 2.12.0
    + JDK-8285720: test/jdk/java/nio/file/Files/probeContentType/
    /Basic.java fails to compile after backport of 8273655
    + JDK-8285726: [11u, 17u] Unify fix for JDK-8284548 with
    version from head
    + JDK-8285727: [11u, 17u] Unify fix for JDK-8284920 with
    version from head
    + JDK-8285828: runtime/execstack/TestCheckJDK.java fails with
    zipped debug symbols
    + JDK-8286013: Incorrect test configurations for
    compiler/stable/TestStableShort.java
    + JDK-8286198: [linux] Fix process-memory information
    + JDK-8286293: Tests ShortResponseBody and
    ShortResponseBodyWithRetry should use less resources
    + JDK-8286444: javac errors after JDK-8251329 are not helpful
    enough to find root cause
    + JDK-8286594: (zipfs) Mention paths with dot elements in
    ZipException and cleanups
    + JDK-8286630: [11] avoid -std=c++11 CXX harfbuzz buildflag on
    Windows
    + JDK-8286855: javac error on invalid jar should only print
    filename
    + JDK-8287109: Distrust.java failed with
    CertificateExpiredException
    + JDK-8287119: Add Distrust.java to ProblemList
    + JDK-8287362: FieldAccessWatch testcase failed on AIX platform
    + JDK-8287378: GHA: Update cygwin to fix issues in langtools
    tests on Windows
    + JDK-8287739: [11u] ProblemList sun/security/ssl/
    /SSLSessionImpl/NoInvalidateSocketException.java
* Wed Apr 20 2022 fstrba@suse.com
- Update to upstream tag jdk-11.0.15+10 (April 2022 CPU)
  * Security fixes:
    + JDK-8284920: Incorrect Token type causes XPath expression to
    return empty result
    + JDK-8284548: Invalid XPath expression causes
    StringIndexOutOfBoundsException
    + JDK-8281388: Change wrapping of EncryptedPrivateKeyInfo
    + JDK-8282397: createTempFile method of java.io.File is failing
    when called with suffix of spaces character
    + JDK-8278356: Improve file creation
    + JDK-8270504, bsc#1198672, CVE-2022-21426: Better Xpath
    expression handling
    + JDK-8272594: Better record of recordings
    + JDK-8277672, bsc#1198674, CVE-2022-21434: Better invocation
    handler handling
    + JDK-8282300: Throws NamingException instead of
    InvalidNameException after JDK-8278972
    + JDK-8278972, bsc#1198673, CVE-2022-21496: Improve URL supports
    + JDK-8272261: Improve JFR recording file processing
    + JDK-8269938: Enhance XML processing passes redux
    + JDK-8272255: Completely handle MIDI files
    + JDK-8278805: Enhance BMP image loading
    + JDK-8278449: Improve keychain support
    + JDK-8277227: Better identification of OIDs
    + JDK-8275151, bsc#1198675, CVE-2022-21443: Improved Object
    Identification
    + JDK-8274221: More definite BER encodings
    + JDK-8278798: Improve supported intrinsic
  * Other changes:
    + JDK-8283778: 11u GHA: Fix GCC 9 ubuntu package names
    + JDK-8283018: 11u GHA: Update GCC 9 minor versions
    + JDK-8275082, bsc#1198671, CVE-2022-21476: Update XML Security
    for Java to 2.3.0
    + JDK-8282761: XPathFactoryImpl remove setProperty and
    getProperty methods
    + JDK-8283270: [11u] broken JRT_ENTRY_NO_ASYNC after Backport
    of JDK-8253795
    + JDK-8275703: System.loadLibrary fails on Big Sur for
    libraries hidden from filesystem
    + JDK-8277795: ldap connection timeout not honoured under
    contention
    + JDK-8276141: XPathFactory set/getProperty method
    + JDK-8255410: Add ChaCha20 and Poly1305 support to SunPKCS11
    provider
    + JDK-8211333: AArch64: Fix another build failure after
    JDK-8211029
    + JDK-8279669: test/jdk/com/sun/jdi/TestScaffold.java uses
    wrong condition
    + JDK-8261107: ArrayIndexOutOfBoundsException in the
    ICC_Profile.getInstance(InputStream)
    + JDK-8282372: [11] build issue on MacOS/aarch64 12.2.1 using
    Xcode 13.1: call to 'log2_intptr' is ambiguous
    + JDK-8214004: Missing space between compiler thread name and
    task info in hs_err
    + JDK-8250750: JDK-8247515 fix for OSX pc_to_symbol() lookup
    fails with some symbols
    + JDK-8277488: Add expiry exception for Digicert
    (geotrustglobalca) expiring in May 2022
    + JDK-8247515: OSX pc_to_symbol() lookup does not work with
    core files
    + JDK-8254085: javax/swing/text/Caret/
    /TestCaretPositionJTextPane.java failed with
    "RuntimeException: Wrong caret position"
    + JDK-8247272: SA ELF file support has never worked for 64-bit
    causing address to symbol name mapping to fail
    + JDK-8233986: ProblemList javax/swing/plaf/basic/BasicTextUI/
    /8001470/bug8001470.java for windows-x64
    + JDK-8274524: SSLSocket.close() hangs if it is called during
    the ssl handshake
    + JDK-8255239: The timezone of the hs_err_pid log file is
    corrupted in Japanese locale
    + JDK-8272541: Incorrect overflow test in Toom-Cook branch of
    BigInteger multiplication
    + JDK-8254072: AArch64: Get rid of --disable-warnings-as-errors
    on Windows+ARM64 build
    + JDK-8262894: [macos_aarch64] SIGBUS in Assembler::ld_st2
    + JDK-8266889: [macosx-aarch64] Crash with SIGBUS in
    MarkActivationClosure::do_code_blob during
    vmTestbase/nsk/jvmti/.../bi04t002 test run
    + JDK-8241004: NMT tests fail on unaligned thread size with
    debug build
    + JDK-8253795: Implementation of JEP 391: macOS/AArch64 Port
    + JDK-8280414: Memory leak in DefaultProxySelector
    + JDK-8280526: x86_32 Math.sqrt performance regression with
  - XX:UseSSE={0,1}
    + JDK-8279076: C2: Bad AD file when matching SqrtF with UseSSE=0
    + JDK-8281520: JFR: A wrong parameter is passed to the
    constructor of LeakKlassWriter
    + JDK-8281599: test/lib/jdk/test/lib/KnownOIDs.java is
    redundant since JDK-8268801
    + JDK-8190748: java/text/Format/DateFormat/DateFormatTest.java
    and NonGregorianFormatTest fail intermittently
    + JDK-8281061: [s390] JFR runs into assertions while validating
    interpreter frames
    + JDK-8280155: [PPC64, s390] frame size checks are not yet
    correct
    + JDK-8279924: [PPC64, s390] implement
    frame::is_interpreted_frame_valid checks
    + JDK-8261205: AssertionError: Cannot add metadata to an
    intersection type
    + JDK-8277992: Add fast jdk_svc subtests to jdk:tier3
    + JDK-8216969: ParseException thrown for certain months with
    russian locale
    + JDK-8278381: [GCC 11] Address::make_raw() does not initialize
    rspec
    + JDK-8264650: Cross-compilation to macos/aarch64
    + JDK-8256321: Some "inactive" color profiles use the wrong
    profile class
    + JDK-8280999: array_bounds should be array-bounds after 8278507
    + JDK-8177814: jdk/editpad is not in jdk TEST.groups
    + JDK-8279702: [macosx] ignore xcodebuild warnings on M1
    + JDK-8280786: Build failure on Solaris after 8262392
    + JDK-8218546: Unable to connect to https://google.com using
    java.net.HttpClient
    + JDK-8278758: runtime/BootstrapMethod/BSMCalledTwice.java
    fails with release VMs after JDK-8262134
    + JDK-8279833: Loop optimization issue in
    String.encodeUTF8_UTF16
    + JDK-8273277: C2: Move conditional negation into rc_predicate
    + JDK-8253197: vmTestbase/nsk/jvmti/StopThread/stopthrd007/
    /TestDescription.java fails with "ERROR:
    DebuggeeSleepingThread: ThreadDeath lost"
    + JDK-8236210: javac generates wrong annotation for fields
    generated from record components
    + JDK-8236505: Mark jdk/editpad/EditPadTest.java as @headful
    + JDK-8270874: JFrame paint artifacts when dragged from
    standard monitor to HiDPI monitor
    + JDK-8271202: C1: assert(false) failed: live_in set of first
    block must be empty
    + JDK-8277447: Hotspot C1 compiler crashes on Kotlin suspend
    fun with loop
    + JDK-8275610: C2: Object field load floats above its null
    check resulting in a segfault
    + JDK-8266421: Deadlock in Sound System
    + JDK-8274795: AArch64: avoid spilling and restoring r18 in
    macro assembler
    + JDK-8232533: G1 uses only a single thread for pretouching the
    java heap
    + JDK-8273933: [TESTBUG] Test must run without preallocated
    exceptions
    + JDK-8268542: serviceability/logging/TestFullNames.java tests
    only 1st test case
    + JDK-8251998: remove usage of PropertyResolvingWrapper in
    vmTestbase/jit/t
    + JDK-8273438: Enable parallelism in
    vmTestbase/metaspace/stressHierarchy tests
    + JDK-8273433: Enable parallelism in vmTestbase_nsk_sysdict
    tests
    + JDK-8273341: Update Siphash to version 1.0
    + JDK-8278871: [JVMCI] assert((uint)reason < 2*
    _trap_hist_limit) failed: oob
    + JDK-8275326: C2: assert(no_dead_loop) failed: dead loop
    detected
    + JDK-8251127: clean up FileInstaller $test.src $cwd in
    remaining vmTestbase_vm_compiler tests
    + JDK-8252005: narrow disabling of allowSmartActionArgs in
    vmTestbase
    + JDK-8279998: PPC64 debug builds fail with "untested:
    RangeCheckStub: predicate_failed_trap_id"
    + JDK-8193277: SimpleFileObject inconsistency between getName
    and getShortName
    + JDK-8225559: assertion error at TransTypes.visitApply
    + JDK-8220634: SymLinkArchiveTest should handle not being able
    to create symlinks
    + JDK-8214026: Canonicalized archive paths appearing in
    diagnostics
    + JDK-8251126: nsk.share.GoldChecker should read golden file
    from ${test.src}
    + JDK-8237798: rewrite vmTestbase/jit/tiered from shell to java
    + JDK-8262134: compiler/uncommontrap/TestDeoptOOM.java failed
    with "guarantee(false) failed: wrong number of expression
    stack elements during deopt"
    + JDK-8210194: [TESTBUG] jvmti_FollowRefObjects.cpp missing
    initializer for member
    _jvmtiHeapCallbacks::heap_reference_callback
    + JDK-8277441: CompileQueue::add fails with
    assert(_last->next() == __null) failed: not last
    + JDK-8273704: DrawStringWithInfiniteXform.java failed :
    drawString with InfiniteXform transform takes long time
    + JDK-8277328: jdk/jshell/CommandCompletionTest.java failures
    on Windows
    + JDK-8251132: make main classes public in vmTestbase/jit tests
    + JDK-8274465: Fix javax/swing/text/ParagraphView/6364882/
    /bug6364882.java failures
    + JDK-8273634: [TEST_BUG] Improve javax/swing/text/
    /ParagraphView/6364882/bug6364882.java
    + JDK-8249019: clean up FileInstaller $test.src $cwd in
    vmTestbase_vm_compiler tests
    + JDK-8274338: com/sun/jdi/RedefineCrossEvent.java failed
    "assert(m != __null) failed: NULL mirror"
    + JDK-8279300: [arm32] SIGILL when running
    GetObjectSizeIntrinsicsTest
    + JDK-8273682: Upgrade Jline to 3.20.0
    + JDK-8256154: Some TestNG tests require default constructors
    + JDK-8237787: rewrite vmTestbase/vm/compiler/CodeCacheInfo*
    from shell to java
    + JDK-8223142: Clean-up WS and CB.
    + JDK-8278384: Bytecodes::result_type() for arraylength returns
    T_VOID instead of T_INT
    + JDK-8278172: java/nio/channels/FileChannel/
    /BlockDeviceSize.java should only run on Linux
    + JDK-8279077: JFR crashes on Linux ppc due to missing crash
    protector in signal handler
    + JDK-8279225: [arm32] C1 longs comparison operation destroys
    argument registers
    + JDK-8276623: JDK-8275650 accidentally pushed "out" file
    + JDK-8279379: GHA: Print tests that are in error
    + JDK-8275536: Add test to check that File::lastModified
    returns same time stamp as Files.getLastModifiedTime
    + JDK-8274658: ISO 4217 Amendment 170 Update
    + JDK-8239502: [TEST_BUG] Test javax/swing/text/FlowView/
    /6318524/bug6318524.java never fails
    + JDK-8277342: vmTestbase/nsk/stress/strace/strace004.java
    fails with SIGSEGV in InstanceKlass::jni_id_for
    + JDK-8275650: Problemlist java/io/File/createTempFile/
    /SpecialTempFile.java for Windows 11
    + JDK-8268014: Build failure on SUSE Linux Enterprise Server
    11.4 (s390x) due to 'SYS_get_mempolicy' was not declared
    + JDK-8241423: NUMA APIs fail to work in dockers due to
    dependent syscalls are disabled by default
    + JDK-8065704: Set LC_ALL=C for all relevant commands in the
    build system
    + JDK-8254827: JVMCI: Enable it for Windows+AArch64
    + JDK-8276314: [JVMCI] check alignment of call displacement
    during code installation
    + JDK-8265150: AsyncGetCallTrace crashes on ResourceMark
    + JDK-8276177: nsk/jvmti/RedefineClasses/
    /StressRedefineWithoutBytecodeCorruption failed with
    "assert(def_ik->is_being_redefined()) failed: should be
    being redefined to get here"
    + JDK-8273638: javax/swing/JTable/4235420/bug4235420.java fails
    in GTK L&F
    + JDK-8258554: javax/swing/JTable/4235420/bug4235420.java fails
    in GTK L&F
    + JDK-8277385: Zero: Enable CompactStrings support
    + JDK-8278116: runtime/modules/LoadUnloadModuleStress.java has
    duplicate -Xmx
    + JDK-8278115: gc/stress/gclocker/TestGCLockerWithSerial.java
    has duplicate -Xmx
    + JDK-8274736: Concurrent read/close of SSLSockets causes
    SSLSessions to be invalidated unnecessarily
    + JDK-8278309: [windows] use of uninitialized OSThread::_state
    + JDK-8202142: jfr/event/io/TestInstrumentation is unstable
    + JDK-8207793: [TESTBUG] runtime/Metaspace/
    /FragmentMetaspace.java fails: heap needs to be increased
    + JDK-8211170: AArch64: Warnings in C1 and template interpreter
    + JDK-8273575: memory leak in appendBootClassPath(), paths must
    be deallocated
    + JDK-8266187: Memory leak in appendBootClassPath()
    + JDK-8240904: Screen flashes on test failures when running
    tests from make
    + JDK-8234930: Use MAP_JIT when allocating pages for code cache
    on macOS
    + JDK-8275811: Incorrect instance to dispose
    + JDK-8186780: clang fastdebug assertion failure in
    os_linux_x86:os::verify_stack_alignment()
    + JDK-8266171: -Warray-bounds happens in imageioJPEG.c
    + JDK-8266170: -Wnonnull happens in classLoaderData.inline.hpp
    + JDK-8207011: Remove uses of the register storage class
    specifier
    + JDK-8266172: -Wstringop-overflow happens in vmError.cpp
    + JDK-8274714: Incorrect verifier protected access error message
    + JDK-8273514: java/util/DoubleStreamSums/CompensatedSums.java
    failure
    + JDK-8214761: Bug in parallel Kahan summation implementation
    + JDK-8272473: Parsing epoch seconds at a DST transition with a
    non-UTC parser is wrong
    + JDK-8255035: Update BCEL to Version 6.5.0
    + JDK-8257769: Cipher.getParameters() throws NPE for
    ChaCha20-Poly1305
    + JDK-8233827: Enable screenshots in the enhanced failure
    handler on Linux/macOS
    + JDK-8210236: Prepare
    ciReceiverTypeData::translate_receiver_data_from for
    concurrent class unloading
    + JDK-8273366: [testbug] javax/swing/UIDefaults/6302464/
    /bug6302464.java fails on macOS12
    + JDK-8199079: Test javax/swing/UIDefaults/6302464/
    /bug6302464.java is unstable
    + JDK-8256373: [Windows/HiDPI] The Frame#setBounds does not
    work in a minimized state
    + JDK-8274523:  java/lang/management/MemoryMXBean/
    /MemoryTest.java test should handle Shenandoah
    + JDK-8208074: [TESTBUG] vmTestbase/nsk/jvmti/RedefineClasses/
    /StressRedefineWithoutBytecodeCorruption/TestDescription.java
    failed with NullPointerException
    + JDK-8266168: -Wmaybe-uninitialized happens in check_code.c
    + JDK-8266174: -Wmisleading-indentation happens in
    libmlib_image sources
    + JDK-8251558: J2DBench should support shaped and translucent
    windows
    + JDK-8254940: AArch64: Cleanup non-product thread members
    + JDK-8266173: -Wmaybe-uninitialized happens in jni_util.c
    + JDK-8263185: Mallinfo deprecated in glibc 2.33
    + JDK-8257467: [TESTBUG] -Wdeprecated-declarations is reported
    at sigset() in exesigtest.c
    + JDK-8266176: -Wmaybe-uninitialized happens in
    libArrayIndexOutOfBoundsExceptionTest.c
    + JDK-8274265: Suspicious string concatenation in
    logTestUtils.inline.hpp
    + JDK-8222825: ARM32 SIGILL issue on single core CPU (not
    supported PLDW instruction)
    + JDK-8276105: C2: Conv(D|F)2(I|L)Nodes::Ideal should handle
    rounding correctly
    + JDK-8268882: C2: assert(n->outcnt() != 0 || C->top() == n ||
    n->is_Proj()) failed: No dead instructions after post-alloc
    + JDK-8272345: macos doesn't check `os::set_boot_path()` result
    + JDK-8277796: Bump update version for OpenJDK: jdk-11.0.15
- Modified patch:
  * fips.patch
    + rediff to changed context
* Thu Mar 17 2022 fstrba@suse.com
- Stop adding the JavaEE modules when building for Factory
* Tue Feb 15 2022 fstrba@suse.com
- Update to upstream tag jdk-11.0.14.1+1
  * Changes:
    + JDK-8280786: Build failure on Solaris after 8262392
    + JDK-8218546: Unable to connect to https://google.com using
    java.net.HttpClient
    + JDK-8281324: Bump update version for OpenJDK: jdk-11.0.14.1
* Mon Jan 31 2022 fstrba@suse.com
- Update to upstream tag jdk-11.0.14+9 (January 2022 CPU)
  * New features
    + JDK-8248238: Implementation: JEP 388: Windows AArch64 Support
  * Security fixes
    + JDK-8217375: jarsigner breaks old signature with long lines
    in manifest
    + JDK-8251329: (zipfs) Files.walkFileTree walks infinitely if
    zip has dir named "." inside
    + JDK-8264934, CVE-2022-21248, bnc#1194926: Enhance cross VM serialization
    + JDK-8268488: More valuable DerValues
    + JDK-8268494: Better inlining of inlined interfaces
    + JDK-8268512: More content for ContentInfo
    + JDK-8268795: Enhance digests of Jar files
    + JDK-8268801: Improve PKCS attribute handling
    + JDK-8268813, CVE-2022-21283, bnc#1194937: Better String matching
    + JDK-8269151: Better construction of EncryptedPrivateKeyInfo
    + JDK-8269944: Better HTTP transport redux
    + JDK-8270386, CVE-2022-21291, bsc#1194925: Better verification
    of scan methods
    + JDK-8270392, CVE-2022-21293, bsc#1194935: Improve String
    constructions
    + JDK-8270416, CVE-2022-21294, bsc#1194934: Enhance construction
    of Identity maps
    + JDK-8270492, CVE-2022-21282, bsc#1194933: Better resolution of
    URIs
    + JDK-8270498, CVE-2022-21296, bsc#1194932: Improve SAX Parser
    configuration management
    + JDK-8270646, CVE-2022-21299, bsc#1194931: Improved scanning of
    XML entities
    + JDK-8270952, CVE-2022-21277, bsc#1194930: Improve TIFF file
    handling
    + JDK-8271962: Better TrueType font loading
    + JDK-8271968: Better canonical naming
    + JDK-8271987: Manifest improved manifest entries
    + JDK-8272014, CVE-2022-21305, bsc#1194939: Better array
    indexing
    + JDK-8272026, CVE-2022-21340, bsc#1194940: Verify Jar
    Verification
    + JDK-8272236, CVE-2022-21341, bsc#1194941: Improve serial forms
    for transport
    + JDK-8272272: Enhance jcmd communication
    + JDK-8272462: Enhance image handling
    + JDK-8273290: Enhance sound handling
    + JDK-8273756, CVE-2022-21360, bsc#1194929: Enhance BMP image
    support
    + JDK-8273838, CVE-2022-21365, bsc#1194928: Enhanced BMP
    processing
    + JDK-8274096, CVE-2022-21366, bsc#1194927: Improve decoding of
    image files
    + JDK-8279541: Improve HarfBuzz
  * Other changes
    + JDK-6849922: java/awt/Choice/ChoiceKeyEventReaction/
    /ChoiceKeyEventReaction.html fails
    + JDK-7105119: [TEST_BUG] [macosx] In test
    UIDefaults.toString() must be called with the invokeLater()
    + JDK-7151826: [TEST_BUG] [macosx] The test
    javax/swing/JPopupMenu/4966112/bug4966112.java not for mac
    + JDK-7179006: [macosx] Print-to-file doesn't work: printing to
    the default printer instead
    + JDK-8015602: [macosx] Test javax/swing/SpringLayout/4726194/
    /bug4726194.java fails on MacOSX
    + JDK-8034084: nsk.nsk/jvmti/ThreadStart/threadstart003 Wrong
    number of thread end events
    + JDK-8039261: [TEST_BUG]: There is not a minimal security
    level in Java Preferences and the TestApplet.html is blocked.
    + JDK-8047218: [TEST_BUG] java/awt/FullScreen/AltTabCrashTest/
    /AltTabCrashTest.java fails with exception
    + JDK-8075909: [TEST_BUG] The regression-swing case failed as
    it does not have the 'Open' button when select 'subdir' folder
    with NimbusLAF
    + JDK-8078219: Verify lack of @test tag in files in java/net
    test directory
    + JDK-8080569: java/lang/ProcessBuilder/DestroyTest.java fails
    with "RuntimeException: Process terminated prematurely"
    + JDK-8081652: [TESTBUG] java/lang/management/ThreadMXBean/
    /ThreadMXBeanStateTest.java timed out intermittently
    + JDK-8129310: java/net/Socket/asyncClose/AsyncClose.java fails
    intermittently
    + JDK-8131745: java/lang/management/ThreadMXBean/
    /AllThreadIds.java still fails intermittently
    + JDK-8136517: [macosx] Test java/awt/Focus/8073453/
    /AWTFocusTransitionTest.java fails on MacOSX
    + JDK-8137101: [TEST_BUG] javax/swing/plaf/basic/BasicHTML/
    /4251579/bug4251579.java failure due to timing
    + JDK-8143021: [TEST_BUG] Test javax/swing/JColorChooser/
    /Test6541987.java fails
    + JDK-8159597: [TEST_BUG] closed/javax/swing/JPopupMenu/4760494/
    /bug4760494.java leaves key pressed
    + JDK-8159904: [TEST_BUG] Failure on solaris of
    java/awt/Window/MultiWindowApp/MultiWindowAppTest.java
    + JDK-8163086: java/awt/Window/TranslucentJAppletTest/
    /TranslucentJAppletTest.java fails
    + JDK-8165828: [TEST_BUG] The reg case: javax/swing/plaf/metal/
    /MetalIcons/MetalHiDPIIconsTest.java failed as No Metal Look
    and Feel
    + JDK-8169953: JComboBox/8057893: ComboBoxEdited event is not
    fired! on Windows
    + JDK-8169954: JFileChooser/8021253: java.lang.RuntimeException:
    Default button is not pressed
    + JDK-8169959: javax/swing/JTable/6263446/bug6263446.java:
    Table should be editing
    + JDK-8171381: [TEST_BUG] [macos] javax/swing/JPopupMenu/
    /7156657/bug7156657.java fails on OS X
    + JDK-8171998: javax/swing/JMenu/4692443/bug4692443.java fails
    on Windows
    + JDK-8174819: java/nio/file/WatchService/LotsOfEvents.java
    fails intermittently
    + JDK-8179880: Refactor javax/security shell tests to plain
    java tests
    + JDK-8180568: Refactor javax/crypto shell tests to plain java
    tests
    + JDK-8180569: Refactor sun/security/krb5/ shell tests to plain
    java tests
    + JDK-8180571: Refactor sun/security/pkcs11 shell tests to
    plain java tests and fix failures
    + JDK-8180573: Refactor sun/security/tools shell tests to plain
    java tests
    + JDK-8187649: ArrayIndexOutOfBoundsException in
    java.util.JapaneseImperialCalendar
    + JDK-8190753: (zipfs): Accessing a large entry (> 2^31 bytes)
    leads to a negative initial size for ByteArrayOutputStream
    + JDK-8195703: BasicJDWPConnectionTest.java: 'App exited
    unexpectedly with 2'
    + JDK-8196096: javax/swing/JPopupMenu/6580930/bug6580930.java
    fails
    + JDK-8197560: test javax/swing/JTree/8003400/Test8003400.java
    fails
    + JDK-8197800: Test java/awt/Focus/NonFocusableWindowTest/
    /NoEventsTest.java fails on Windows
    + JDK-8197811: Test java/awt/Choice/PopupPosTest/
    /PopupPosTest.java fails on Windows
    + JDK-8198616: java/awt/Focus/6378278/InputVerifierTest.java
    fails on mac
    + JDK-8198617: java/awt/Focus/6382144/EndlessLoopTest.java
    fails on mac
    + JDK-8198619: java/awt/Focus/FocusTraversalPolicy/
    /ButtonGroupLayoutTraversal/ButtonGroupLayoutTraversalTest.java
    fails on mac
    + JDK-8198623: java/awt/KeyboardFocusmanager/TypeAhead/
    /EnqueueWithDialogButtonTest/EnqueueWithDialogButtonTest.java
    fails on mac
    + JDK-8198624: java/awt/KeyboardFocusmanager/TypeAhead/
    /SubMenuShowTest/SubMenuShowTest.html fails on mac
    + JDK-8199138: Add RISC-V support to Zero
    + JDK-8199529: javax/swing/text/Utilities/8142966/
    /SwingFontMetricsTest.java fails on windows
    + JDK-8201224: Make string buffer size dynamic in
    mlvmJvmtiUtils.c
    + JDK-8202342: [Graal] fromTonga/nsk/jvmti/unit/
    /FollowReferences/followref003/TestDescription.java fails with
    "Location mismatch" errors
    + JDK-8204161: [TESTBUG] auto failed with the "Applet thread
    threw exception: java.lang.UnsupportedOperationException"
    exception
    + JDK-8206085: Refactor
    langtools/tools/javac/versions/Versions.java
    + JDK-8207936: TestZipFile failed with java.lang.AssertionError
    exception
    + JDK-8208242: Add @requires to vmTestbase/gc/g1 tests
    + JDK-8209611: use C++ compiler for hotspot tests
    + JDK-8210182: Remove macros for C compilation from vmTestBase
    but non jvmti
    + JDK-8210198: Clean up JNI_ENV_ARG for
    vmTestbase/jvmti/Get[A-F] tests
    + JDK-8210205: build fails on AIX in hotspot cpp tests (for
    example getstacktr001.cpp)
    + JDK-8210242: [TESTBUG] vmTestbase/nsk/stress/jni/
    /jnistress001.java crashes with EXCEPTION_ACCESS_VIOLATION
    on windows-x86
    + JDK-8210353: Move java/util/Arrays/TimSortStackSize2.java
    back to tier1
    + JDK-8210385: Clean up JNI_ENV_ARG and factorize the macros
    for vmTestbase/jvmti[A-N] tests
    + JDK-8210392: assert(Compile::current()->live_nodes() <
    Compile::current()->max_node_limit()) failed: Live Node limit
    exceeded limit
    + JDK-8210395: Add doc to SecurityTools.java
    + JDK-8210429: Clean up JNI_ENV_ARG for
    vmTestbase/jvmti/Get[G-Z] tests
    + JDK-8210481: Remove #ifdef cplusplus from vmTestbase
    + JDK-8210593: Clean up JNI_ENV_ARG and factorize the macros
    for vmTestbase/jvmti[N-R] tests
    + JDK-8210665: Clean up JNI_ENV_ARG and factorize the macros
    for vmTestbase/jvmti[R-U] tests
    + JDK-8210689: Remove the multi-line old C style for string
    literals
    + JDK-8210700: Clean up JNI_ENV_ARG and factorize the macros
    for vmTestbase/jvmti/unit tests
    + JDK-8210726: Fix up a few minor nits forgotten by JDK-8210665
    + JDK-8210920: Native C++ tests are not using CXXFLAGS
    + JDK-8210984: [TESTBUG] hs203t003 fails with "# ERROR:
    hs203t003.cpp, 218: NSK_CPP_STUB2 ( ResumeThread, jvmti,
    thread)"
    + JDK-8211036: Remove the NSK_STUB macros from vmTestbase for
    non jvmti
    + JDK-8211131: Remove the NSK_CPP_STUB macros from vmTestbase
    for jvmti/[G-I]*
    + JDK-8211148: var in implicit lambdas shouldn't be accepted
    for source < 11
    + JDK-8211171: move JarUtils to top-level testlibrary
    + JDK-8211227: Inconsistent TLS protocol version in debug output
    + JDK-8211261: Remove the NSK_CPP_STUB macros from vmTestbase
    for jvmti/[A-G]*
    + JDK-8211432: [REDO] Handle JNIGlobalRefLocker.cpp
    + JDK-8211782: Remove the NSK_CPP_STUB macros from vmTestbase
    for jvmti/[I-S]*
    + JDK-8211801: Remove the NSK_CPP_STUB macros from vmTestbase
    for jvmti/scenarios/[A-E]
    + JDK-8211899: Remove the NSK_CPP_STUB macros from vmTestbase
    for jvmti/scenarios/[E-M]
    + JDK-8211905: Remove multiple casts for EM06 file
    + JDK-8211999: Window positioning bugs due to overlapping
    GraphicsDevice bounds (Windows/HiDPI)
    + JDK-8212082: Remove the NSK_CPP_STUB macros for remaining
    vmTestbase/jvmti/[sS]*
    + JDK-8212083: Handle remaining gc/lock native code and fix two
    strings
    + JDK-8212148: Remove remaining NSK_CPP_STUBs
    + JDK-8213110: Remove the use of applets in automatic tests
    + JDK-8213189: Make restricted headers in HTTP Client
    configurable and remove Date by default
    + JDK-8213263: fix legal headers in test/langtools
    + JDK-8213296: Fix legal headers in test/jdk/java/net
    + JDK-8213301: Fix legal headers in jdk logging tests
    + JDK-8213305: Fix legal headers in test/java/math
    + JDK-8213306: Fix legal headers in test/java/nio
    + JDK-8213328: Update test copyrights in test/java/util/zip and
    test/jdk/tools
    + JDK-8213330: Fix legal headers in i18n tests
    + JDK-8213707: [TEST] vmTestbase/nsk/stress/except/
    /except011.java failed due to wrong class name
    + JDK-8214469: [macos] PIT: java/awt/Choice/
    /ChoiceKeyEventReaction/ChoiceKeyEventReaction.java fails
    + JDK-8215410: Regression test for JDK-8214994
    + JDK-8215568: Refactor SA clhsdb tests to use ClhsdbLauncher
    + JDK-8215624: Add parallel heap iteration for jmap \u2013histo
    + JDK-8215889: assert(!_unloading) failed: This oop is not
    available to unloading class loader data with ZGC
    + JDK-8216318: The usage of Disposer in the java.awt.Robot can
    be deleted
    + JDK-8216417: cleanup of IPv6 scope-id handling
    + JDK-8217377: javax/swing/JPopupMenu/6583251/bug6583251.java
    failed with UnsupportedOperation exception
    + JDK-8217438: Adapt tools//launcher/Test7029048.java for AIX
    + JDK-8217633: Configurable extensions with system properties
    + JDK-8217882: java/net/httpclient/MaxStreams.java failed once
    + JDK-8217903: java/net/httpclient/Response204.java fails with
    404
    + JDK-8218483: Crash in
    "assert(_daemon_threads_count->get_value() > daemon_count)
    failed: thread count mismatch 5 : 5"
    + JDK-8219986: Change to Xcode 10.1 for building on Macosx at
    Oracle
    + JDK-8220575: Correctly format test URI's that contain a
    retrieved IPv6 address
    + JDK-8221259: New tests for java.net.Socket to exercise long
    standing behavior
    + JDK-8221305: java/awt/FontMetrics/MaxAdvanceIsMax.java fails
    on MacOS + Solaris
    + JDK-8221902: PIT: javax/swing/JRadioButton/FocusTraversal/
    /FocusTraversal.java fails on ubuntu
    + JDK-8221903: PIT: javax/swing/RepaintManager/IconifyTest/
    /IconifyTest.java fails on ubuntu18.04
    + JDK-8222446: assert(C->env()->system_dictionary_modification_counter_changed())
    failed: Must invalidate if TypeFuncs differ
    + JDK-8223137: Rename predicate 'do_unroll_only()' to
    'is_unroll_only()'.
    + JDK-8223138: Small clean-up in loop-tree support.
    + JDK-8223139: Rename mandatory policy-do routines.
    + JDK-8223140: Clean-up in 'ok_to_convert()'
    + JDK-8223141: Change (count) suffix _ct into _cnt.
    + JDK-8223400: Replace some enums with static const members in
    hotspot/runtime
    + JDK-8223658: Performance regression of XML.validation in
    13-b19
    + JDK-8223923: C2: Missing interference with mismatched unsafe
    accesses
    + JDK-8224829: AsyncSSLSocketClose.java has timing issue
    + JDK-8225083: Remove Google certificate that is expiring in
    December 2021
    + JDK-8226514: Replace wildcard address with loopback or local
    host in tests - part 17
    + JDK-8226943: compile error in libfollowref003.cpp  with XCode
    10.2 on macosx
    + JDK-8228442: DHKeyExchange/LegacyDHEKeyExchange.java failed
    due to "SSLException: An established connection was aborted by
    the software in your host machine"
    + JDK-8228508: [TESTBUG] java/net/httpclient/SmokeTest.java
    fails on Windows7
    + JDK-8229935: [TEST_BUG]: bug8132119.java inconsistently
    positions text
    + JDK-8230019: [REDO] compiler/types/correctness/* tests fail
    with "assert(recv == __null || recv->is_klass()) failed: wrong
    type"
    + JDK-8230067: Add optional automatic retry when running jtreg
    tests
    + JDK-8230228: [TESTBUG] Several runtime/ErrorHandling tests
    may fail on some platforms
    + JDK-8231501: VM crash in
    MethodData::clean_extra_data(CleanExtraDataClosure*):
    fatal error: unexpected tag 99
    + JDK-8233403: Improve verbosity of some httpclient tests
    + JDK-8233550: [TESTBUG] JTree tests fail regularly on MacOS
    + JDK-8233552: [TESTBUG] JTable Test bug7068740.java fails on
    MacOS
    + JDK-8233553: [TESTBUG] JSpinner test bug4973721.java fails on
    MacOS
    + JDK-8233555: [TESTBUG] JRadioButton tests failing on MacoS
    + JDK-8233556: [TESTBUG] JPopupMenu tests fail on MacOS
    + JDK-8233559: [TESTBUG] TestNimbusOverride.java is failing on
    macos
    + JDK-8233560: [TESTBUG] ToolTipManager/Test6256140.java  is
    failing on macos
    + JDK-8233561: [TESTBUG] Swing text test bug8014863.java fails
    on macos
    + JDK-8233562: [TESTBUG] Swing StyledEditorKit test
    bug4506788.java fails on MacOS
    + JDK-8233564: [TESTBUG] MouseComboBoxTest.java is failing
    + JDK-8233566: [TESTBUG] KeyboardFocusManager tests failing on
    MacoS
    + JDK-8233567: [TESTBUG] FocusSubRequestTest.java fails on macos
    + JDK-8233569: [TESTBUG] JTextComponent test bug6361367.java
    fails on macos
    + JDK-8233570: [TESTBUG] HTMLEditorKit test bug5043626.java is
    failing on macos
    + JDK-8233634: [TESTBUG] Swing text test bug4278839.java fails
    on macos
    + JDK-8233635: [TESTBUG] ProgressMonitorEscapeKeyPress.java
    fails on macos
    + JDK-8233637: [TESTBUG] Swing
    ActionListenerCalledTwiceTest.java fails on macos
    + JDK-8233638: [TESTBUG] Swing test
    ScreenMenuBarInputTwice.java fails on macos
    + JDK-8233641: [TESTBUG] JMenuItem test bug4171437.java fails
    on macos
    + JDK-8233642: [TESTBUG] JMenuBar test bug 4750590.java  fails
    on macos
    + JDK-8233643: [TESTBUG] JMenu test bug4515762.java fails on
    macos
    + JDK-8233644: [TESTBUG] JInternalFrame test bug8020708.java is
    failing on macos
    + JDK-8233647: [TESTBUG] JColorChooser/Test8051548.java is
    failing on macos
    + JDK-8234802: [TESTBUG] Test Right Mouse Button Drag Gesture
    Recognition in all the platforms
    + JDK-8234823: java/net/Socket/Timeouts.java testcase
    testTimedConnect2() fails on Windows 10
    + JDK-8235784: java/lang/invoke/VarHandles/
    /VarHandleTestByteArrayAsInt.java fails due to timeout with
    fastdebug bits
    + JDK-8236042: [TESTBUG] serviceability/sa/ClhsdbCDSCore.java
    fails with -Xcomp -XX:TieredStopAtLevel=1
    + JDK-8236177: assert(status == 0) failed: error ETIMEDOUT(60),
    cond_wait
    + JDK-8236596: HttpClient leaves HTTP/2 sockets in CLOSE_WAIT,
    when using proxy tunnel
    + JDK-8237354: Add option to jcmd to write a gzipped heap dump
    + JDK-8237589: Fix copyright header formatting
    + JDK-8238677: java/net/httpclient/ssltest/CertificateTest.java
    should not specify TLS version
    + JDK-8239334: Tab Size does not work correctly in JTextArea
    with setLineWrap on
    + JDK-8239422: [TESTBUG]
    compiler/c1/TestPrintIRDuringConstruction.java failed when C1
    is disabled
    + JDK-8239827: The test OpenByUNCPathNameTest.java should be
    changed to be manual
    + JDK-8240256: Better resource cleaning for SunPKCS11 Provider
    + JDK-8242044: Add basic HTTP/1.1 support to the HTTP/2 Test
    Server
    + JDK-8242526: PIT: javax/swing/JInternalFrame/8020708/
    /bug8020708.java fails in mach5 ubuntu system
    + JDK-8242793: Incorrect copyright header in
    ContinuousCallSiteTargetChange.java
    + JDK-8243543: jtreg test security/infra/java/security/cert/
    /CertPathValidator/certification/BuypassCA.java fails
    + JDK-8244292: Headful clients failing with
  - -illegal-access=deny
    + JDK-8245147: Refactor and improve utility of
    test/langtools/tools/javac/versions/Versions.java
    + JDK-8245165: Update bug id for
    javax/swing/text/StyledEditorKit/4506788/bug4506788.java in
    ProblemList
    + JDK-8245665: Test WeakAlg.java should only make sure no
    warning for weak signature algorithms by keytool on root CA
    + JDK-8246114: java/net/MulticastSocket/Promiscuous.java fails
    after 8241072 (multi-homed systems)
    + JDK-8246807: Incorrect copyright header in
    TimeZoneDatePermissionCheck.sh
    + JDK-8247403: JShell: No custom input (e.g. from GUI) possible
    with JavaShellToolBuilder
    + JDK-8247510: typo in IllegalHandshakeMessage
    + JDK-8248187: [TESTBUG] javax/swing/plaf/basic/
    /BasicGraphicsUtils/8132119/bug8132119.java fails with String
    is not properly drawn
    + JDK-8248341: ProblemList java/lang/management/ThreadMXBean/
    /ThreadMXBeanStateTest.java
    + JDK-8248500: AArch64: Remove the r18 dependency on Windows
    AArch64
    + JDK-8248899: security/infra/java/security/cert/
    /CertPathValidator/certification/QuoVadisCA.java fails,
    Certificate has been revoked
    + JDK-8249195: Change to Xcode 11.3.1 for building on Macos at
    Oracle
    + JDK-8250521: Configure initial RTO to use minimal retry for
    loopback connections on Windows
    + JDK-8250810: Push missing parts of JDK-8248817
    + JDK-8250839: Improve test template SSLEngineTemplate with
    SSLContextTemplate
    + JDK-8250863: Build error with GCC 10 in NetworkInterface.c
    and k_standard.c
    + JDK-8250888: nsk/jvmti/scenarios/general_functions/GF08/
    /gf08t001/TestDriver.java fails
    + JDK-8251155: HostIdentifier fails to canonicalize hostnames
    starting with digits
    + JDK-8251377: [macos11] JTabbedPane selected tab text is
    barely legible
    + JDK-8251570: JDK-8215624 causes assert(worker_id <
    _n_workers) failed: Invalid worker_id
    + JDK-8251930: AArch64: Native types mismatch in hotspot
    + JDK-8252049: Native memory leak in ciMethodData ctor
    + JDK-8252051: Make mlvmJvmtiUtils strncpy uses GCC 10.x
    friendly
    + JDK-8252114: Windows-AArch64: Enable and test ZGC and
    ShenandoahGC
    + JDK-8253015: Aarch64: Move linux code out from generic CPU
    feature detection
    + JDK-8253147: The javax/swing/JPopupMenu/7154841/bug7154841.java
    fail on big screens
    + JDK-8253497: Core Libs Terminology Refresh
    + JDK-8253682: The AppletInitialFocusTest1.java is unstable
    + JDK-8253763: ParallelObjectIterator should have virtual
    destructor
    + JDK-8253866: Security Libs Terminology Refresh
    + JDK-8254802: ThrowingPushPromisesAsStringCustom.java fails in
    "try throwing in GET_BODY"
    + JDK-8255227: java/net/httpclient/FlowAdapterPublisherTest.java
    intermittently failing with TestServer: start exception:
    java.io.IOException: Invalid preface
    + JDK-8255264: Support for identifying the full range of IPv4
    localhost addresses on Windows
    + JDK-8255716: AArch64: Regression: JVM crashes if manually
    offline a core
    + JDK-8255722: Create a new test for rotated blit
    + JDK-8256009: Remove src/hotspot/share/adlc/Test/i486.ad
    + JDK-8256066: Tests use deprecated TestNG API that is no
    longer available in new versions
    + JDK-8256152: tests fail because of ambiguous method resolution
    + JDK-8256182: Update qemu-debootstrap cross-compilation recipe
    + JDK-8256201: java/awt/FullScreen/FullscreenWindowProps/
    /FullscreenWindowProps.java failed
    + JDK-8256202: Some tweaks for jarsigner tests
    PosixPermissionsTest and SymLinkTest
    + JDK-8256372: [macos] Unexpected symbol was displayed on
    JTextField with Monospaced font
    + JDK-8256956: RegisterImpl::max_slots_per_register is
    incorrect on AMD64
    + JDK-8258457: testlibrary_tests/ctw/JarDirTest.java fails with
    InvalidPathException on windows
    + JDK-8258855: Two tests sun/security/krb5/auto/
    /ReplayCacheTestProc.java and ReplayCacheTestProcWithMD5.java
    failed on OL8.3
    + JDK-8259237: Demo selection changes with left/right arrow
    key. No need to press space for selection.
    + JDK-8260571: Add PrintMetaspaceStatistics to print metaspace
    statistics upon VM exit
    + JDK-8260690: JConsole User Guide Link from the Help menu is
    not accessible by keyboard
    + JDK-8261036: Reduce classes loaded by CleanerFactory
    initialization
    + JDK-8261071: AArch64: Refactor interpreter native wrappers
    + JDK-8261075: Create stubRoutines.inline.hpp with SafeFetch
    implementation
    + JDK-8261236: C2: ClhsdbJstackXcompStress test fails when
    StressGCM is enabled
    + JDK-8261297: NMT: Final report should use scale 1
    + JDK-8261661: gc/stress/TestReclaimStringsLeaksMemory.java
    fails because Reserved memory size is too big
    + JDK-8261916: gtest/GTestWrapper.java
    vmErrorTest.unimplemented1_vm_assert failed
    + JDK-8262438: sun/security/ssl/SSLLogger/
    /LoggingFormatConsistency.java failed with "SocketException:
    Socket is closed"
    + JDK-8262731: [macOS] Exception from "Printable.print" is
    swallowed during "PrinterJob.print"
    + JDK-8262844: (fs) FileStore.supportsFileAttributeView might
    return false negative in case of ext3
    + JDK-8263059: security/infra/java/security/cert/
    /CertPathValidator/certification/ComodoCA.java fails due to
    revoked cert
    + JDK-8263068: Rename safefetch.hpp to safefetch.inline.hpp
    + JDK-8263303: C2 compilation fails with assert(found_sfpt)
    failed: no node in loop that's not input to safepoint
    + JDK-8263362: Avoid division by 0 in
    java/awt/font/TextJustifier.java justify
    + JDK-8263773: Reenable German localization for builds at Oracle
    + JDK-8263897: compiler/c2/aarch64/TestVolatilesSerial.java
    failed with "java.lang.RuntimeException: Wrong method"
    + JDK-8264526: javax/swing/text/html/parser/Parser/8078268/
    /bug8078268.java timeout
    + JDK-8264824: java/net/Inet6Address/B6206527.java doesn't
    close ServerSocket properly
    + JDK-8265019: Update tests for additional TestNG test
    permissions
    + JDK-8265173: [test] divert spurious log output away from
    stream under test in ProcessBuilder Basic test
    + JDK-8265524: Upgrading JSZip from v3.2.2 to v3.6.0
    + JDK-8266182: Automate manual steps listed in the test
    jdk/sun/security/pkcs12/ParamsTest.java
    + JDK-8266579: Update test/jdk/java/lang/ProcessHandle/
    /PermissionTest.java & test/jdk/java/sql/testng/util/
    /TestPolicy.java
    + JDK-8266949: Check possibility to disable OperationTimedOut
    on Unix
    + JDK-8267246: -XX:MaxRAMPercentage=0 is unreasonable for jtreg
    tests on many-core machines
    + JDK-8267256: Extend minimal retry for loopback connections on
    Windows to PlainSocketImpl
    + JDK-8267304: Bump global JTReg memory limit to 768m
    + JDK-8267652: c2 loop unrolling by 8 results in reading memory
    past array
    + JDK-8268019: C2: assert(no_dead_loop) failed: dead loop
    detected
    + JDK-8268093: Manual Testcase: "sun/security/krb5/config/
    /native/TestDynamicStore.java" Fails with NPE
    + JDK-8268555: Update HttpClient tests that use ITestContext to
    jtreg 6+1
    + JDK-8268672: C2: assert(!loop->is_member(u_loop)) failed: can
    be in outer loop or out of both loops only
    + JDK-8269034: AccessControlException for SunPKCS11 daemon
    threads
    + JDK-8269426: Rename test/jdk/java/lang/invoke/t8150782 to
    accessClassAndFindClass
    + JDK-8269574: C2: Avoid redundant uncommon traps in
    GraphKit::builtin_throw() for JVMTI exception events
    + JDK-8269656: The test test/langtools/tools/javac/versions/
    /Versions.java has duplicate test cycles
    + JDK-8269768: JFR Terminology Refresh
    + JDK-8269951: [macos] Focus not painted in JButton when
    setBorderPainted(false) is invoked
    + JDK-8269984: [macos] JTabbedPane title looks like  disabled
    + JDK-8269993: [Test]: java/net/httpclient/
    /DigestEchoClientSSL.java contains redundant @run tags
    + JDK-8270116: Expand ButtonGroupLayoutTraversalTest.java to
    run in all LaFs, including Aqua on macOS
    + JDK-8270216: [macOS] Update named used for Java run loop mode
    + JDK-8270280: security/infra/java/security/cert/
    /CertPathValidator/certification/LetsEncryptCA.java OCSP
    response error
    + JDK-8270290: NTLM authentication fails if HEAD request is used
    + JDK-8270317: Large Allocation in CipherSuite
    + JDK-8270344: Session resumption errors
    + JDK-8270517: Add Zero support for LoongArch
    + JDK-8270533: AArch64: size_fits_all_mem_uses should return
    false if its output is a CAS
    + JDK-8270886: Crash in
    PhaseIdealLoop::verify_strip_mined_scheduling
    + JDK-8271287: jdk/jshell/CommandCompletionTest.java fails with
    "lists don't have the same size expected"
    + JDK-8271340: Crash PhaseIdealLoop::clone_outer_loop
    + JDK-8271341: Opcode() != Op_If && Opcode() != Op_RangeCheck)
    || outcnt() == 2 assert failure with Test7179138_1.java
    + JDK-8271459: C2: Missing NegativeArraySizeException when
    creating StringBuilder with negative capacity
    + JDK-8271490: [ppc] [s390]: Crash in
    JavaThread::pd_get_top_frame_for_profiling
    + JDK-8271560: sun/security/ssl/DHKeyExchange/
    /LegacyDHEKeyExchange.java still fails due to "An established
    connection was aborted by the software in your host machine"
    + JDK-8271567: AArch64: AES Galois CounterMode (GCM)
    interleaved implementation using vector instructions
    + JDK-8272180: Upgrade JSZip from v3.6.0 to v3.7.1
    + JDK-8272181: Windows-AArch64:Backport fix of `Backtracing
    broken on PAC enabled systems`
    + JDK-8272316: Wrong Boot JDK help message in 11
    + JDK-8272318: Improve performance of HeapDumpAllTest
    + JDK-8272342: [TEST_BUG] java/awt/print/PrinterJob/
    /PageDialogMarginTest.java catches all exceptions
    + JDK-8272570: C2: crash in PhaseCFG::global_code_motion
    + JDK-8272574: C2: assert(false) failed: Bad graph detected in
    build_loop_late
    + JDK-8272581: sun/security/pkcs11/Provider/MultipleLogins.sh
    fails after JDK-8266182
    + JDK-8272708: [Test]: Cleanup: test/jdk/security/infra/java/
    /security/cert/CertPathValidator/certification/BuypassCA.java
    no longer needs ocspEnabled
    + JDK-8272720: Fix the implementation of loop unrolling
    heuristic with LoopPercentProfileLimit
    + JDK-8272783: Epsilon: Refactor tests to improve performance
    + JDK-8272806: [macOS] "Apple AWT Internal Exception" when
    input method is changed
    + JDK-8272828: Add correct licenses to jszip.md
    + JDK-8272836: Limit run time for java/lang/invoke/LFCaching
    tests
    + JDK-8272850: Drop zapping values in the Zap* option
    descriptions
    + JDK-8272902: Bump update version for OpenJDK: jdk-11.0.14
    + JDK-8272914: Create hotspot:tier2 and hotspot:tier3 test
    groups
    + JDK-8272966: test/jdk/java/awt/Robot/FlushCurrentEvent.java
    fails by timeout
    + JDK-8273026: Slow LoginContext.login() on multi threading
    application
    + JDK-8273229: Update OS detection code to recognize Windows
    Server 2022
    + JDK-8273235: tools/launcher/HelpFlagsTest.java Fails on
    Windows 32bit
    + JDK-8273308: PatternMatchTest.java fails on CI
    + JDK-8273314: Add tier4 test groups
    + JDK-8273342: Null pointer dereference in
    classFileParser.cpp:2817
    + JDK-8273358: macOS Monterey does not have the font Times
    needed by Serif
    + JDK-8273373: Zero: Cannot invoke JVM in primordial threads on
    Zero
    + JDK-8273498: compiler/c2/Test7179138_1.java timed out
    + JDK-8273541: Cleaner Thread creates with normal priority
    instead of MAX_PRIORITY - 2
    + JDK-8273547: [11u] [JVMCI] Partial module-info.java backport
    of JDK-8223332
    + JDK-8273606: Zero: SPARC64 build fails with si_band type
    mismatch
    + JDK-8273646: Add openssl from path variable also in to
    Default System Openssl Path in OpensslArtifactFetcher
    + JDK-8273671: Backport of 8260616 misses one JNF header
    inclusion removal
    + JDK-8273790: Potential cyclic dependencies between Gregorian
    and CalendarSystem
    + JDK-8273795: Zero SPARC64 debug builds fail due to missing
    interpreter fields
    + JDK-8273826: Correct Manifest file name and NPE checks
    + JDK-8273894: ConcurrentModificationException raised every
    time ReferralsCache drops referral
    + JDK-8273924: ArrayIndexOutOfBoundsException thrown in
    java.util.JapaneseImperialCalendar.add()
    + JDK-8273961: jdk/nio/zipfs/ZipFSTester.java fails if file
    path contains '+' character
    + JDK-8273968: JCK javax_xml tests fail in CI
    + JDK-8274056: JavaAccessibilityUtilities leaks JNI objects
    + JDK-8274083: Update testing docs to mention tiered testing
    + JDK-8274293: Build failure on macOS with Xcode 13.0 as vfork
    is deprecated
    + JDK-8274326: [macos] Ensure initialisation of sun/lwawt/
    /macosx/CAccessibility in JavaComponentAccessibility.m
    + JDK-8274329: Fix non-portable HotSpot code in
    MethodMatcher::parse_method_pattern
    + JDK-8274381: missing CAccessibility definitions in JNI code
    + JDK-8274407: (tz) Update Timezone Data to 2021c
    + JDK-8274467: TestZoneInfo310.java fails with tzdata2021b
    + JDK-8274468: TimeZoneTest.java fails with tzdata2021b
    + JDK-8274522: java/lang/management/ManagementFactory/
    /MXBeanException.java test fails with Shenandoah
    + JDK-8274642: jdk/jshell/CommandCompletionTest.java fails with
    NoSuchElementException after JDK-8271287
    + JDK-8274773: [TESTBUG] UnsafeIntrinsicsTest intermittently
    fails on weak memory model platform
    + JDK-8274779: HttpURLConnection: HttpClient and HttpsClient
    incorrectly check request method when set to POST
    + JDK-8274840: Update OS detection code to recognize Windows 11
    + JDK-8274860: gcc 10.2.1 produces an uninitialized warning in
    sharedRuntimeTrig.cpp
    + JDK-8275051: Shenandoah: Correct ordering of requested gc
    cause and gc request flag
    + JDK-8275131: Exceptions after a touchpad gesture on macOS
    + JDK-8275713: TestDockerMemoryMetrics test fails on recent runc
    + JDK-8275766: (tz) Update Timezone Data to 2021e
    + JDK-8275849: TestZoneInfo310.java fails with tzdata2021e
    + JDK-8276066: Reset LoopPercentProfileLimit for x86 due to
    suboptimal performance
    + JDK-8276139: TestJpsHostName.java not reliable, better to
    expand HostIdentifierCreate.java test
    + JDK-8276157: C2: Compiler stack overflow during escape
    analysis on Linux x86_32
    + JDK-8276201: Shenandoah: Race results degenerated GC to enter
    wrong entry point
    + JDK-8276536: Update TimeZoneNames files to follow the changes
    made by JDK-8275766
    + JDK-8276550: Use SHA256 hash in build.tools.depend.Depend
    + JDK-8276774: Cookie stored in CookieHandler not sent if user
    headers contain cookie
    + JDK-8276854: Windows GHA builds fail due to broken Cygwin
    + JDK-8277029: JMM GetDiagnosticXXXInfo APIs should verify
    output array sizes
    + JDK-8277224: sun.security.pkcs.PKCS9Attributes.toString()
    throws NPE
    + JDK-8277529: SIGSEGV in C2 CompilerThread
    Node::rematerialize() compiling Packet::readUnsignedTrint
    + JDK-8277815: Fix mistakes in legal header backports
- Removed patch:
  * riscv64-zero.patch
    + integrated upstream
- Modified patch:
  * fips.patch
    + rediff to changed context
* Fri Nov  5 2021 fstrba@suse.com
- Modified patch:
  * fips.patch
    + return in native code after generating java.io.IOException
* Wed Nov  3 2021 fstrba@suse.com
- Modified patches:
  * system-crypto-policy.patch
    + rediff to changed context
  * fips.patch
    + Allow plain key import in fips mode unless
    com.suse.fips.plainKeySupport is set to false
* Thu Oct 21 2021 fstrba@suse.com
- Update to upstream tag jdk-11.0.13+8 (October 2021 CPU)
  * Security fixes
    + JDK-8163326, CVE-2021-35550, bsc#1191901: Update the default
    enabled cipher suites preference
    + JDK-8254967, CVE-2021-35565, bsc#1191909:
    com.sun.net.HttpsServer spins on TLS session close
    + JDK-8263314: Enhance XML Dsig modes
    + JDK-8265167, CVE-2021-35556, bsc#1191910: Richer Text Editors
    + JDK-8265574: Improve handling of sheets
    + JDK-8265580, CVE-2021-35559, bsc#1191911: Enhanced style for
    RTF kit
    + JDK-8265776: Improve Stream handling for SSL
    + JDK-8266097, CVE-2021-35561, bsc#1191912: Better hashing
    support
    + JDK-8266103: Better specified spec values
    + JDK-8266109: More Resilient Classloading
    + JDK-8266115: More Manifest Jar Loading
    + JDK-8266137, CVE-2021-35564, bsc#1191913: Improve Keystore
    integrity
    + JDK-8266689, CVE-2021-35567, bsc#1191903: More Constrained
    Delegation
    + JDK-8267086: ArrayIndexOutOfBoundsException in
    java.security.KeyFactory.generatePublic
    + JDK-8267712: Better LDAP reference processing
    + JDK-8267729, CVE-2021-35578, bsc#1191904: Improve TLS client
    handshaking
    + JDK-8267735, CVE-2021-35586, bsc#1191914: Better BMP support
    + JDK-8268193: Improve requests of certificates
    + JDK-8268199: Correct certificate requests
    + JDK-8268205: Enhance DTLS client handshake
    + JDK-8268506: More Manifest Digests
    + JDK-8269618, CVE-2021-35603, bsc#1191906: Better session
    identification
    + JDK-8269624: Enhance method selection support
    + JDK-8270398: Enhance canonicalization
    + JDK-8270404: Better canonicalization
  * Other changes
    + JDK-8024368: private methods are allocated vtable indices
    + JDK-8042902: Test java/net/Inet6Address/serialize/
    /Inet6AddressSerializationTest.java fails intermittently
    + JDK-8140466: ChaCha20 and Poly1305 TLS Cipher Suites
    + JDK-8157404: Unable to read certain PKCS12 keystores from
    SequenceInputStream
    + JDK-8158066: SourceDebugExtensionTest fails to rename file
    + JDK-8168304: Make all of DependencyContext_test available in
    product mode
    + JDK-8169246: java/net/DatagramSocket/ReportSocketClosed.java
    fails intermittently with BindException
    + JDK-8181313: SA: Remove libthread_db dependency on Linux
    + JDK-8193214: Incorrect annotations.without.processors
    warnings with JDK 9
    + JDK-8194230: jdk/internal/jrtfs/remote/
    /RemoteRuntimeImageTest.java fails with
    java.lang.NullPointerException
    + JDK-8196092: javax/swing/JComboBox/8032878/bug8032878.java
    fails
    + JDK-8199931: java/net/MulticastSocket/
    /UnreferencedMulticastSockets.java fails with "incorrect data
    received"
    + JDK-8206083: Make tools/javac/api/T6265137.java robust to JDK
    version changes
    + JDK-8206350: java/util/Locale/bcp47u/SystemPropertyTests.java
    failed on Mac 10.13 with zh_CN and zh_TW locales.
    + JDK-8207316: java/nio/channels/spi/SelectorProvider/
    /inheritedChannel/InheritedChannelTest.java failed
    + JDK-8208227: tools/jdeps/DotFileTest.java fails on Win-X64
    + JDK-8208363: test/jdk/java/lang/Package/
    /PackageFromManifest.java missing module dependencies
    declaration
    + JDK-8209380: ARM: cleanup maybe-uninitialized and reorder
    compiler warnings
    + JDK-8209768: Refactor java/util/prefs/CheckUserPrefsStorage.sh
    to plain java test
    + JDK-8209772: Refactor shell test java/util/ServiceLoader/
    /basic/basic.sh to java
    + JDK-8209773: Refactor shell test javax/naming/module/basic.sh
    to java
    + JDK-8209832: Refactor jdk/internal/reflect/Reflection/
    /GetCallerClassTest.sh to plain java test
    + JDK-8209930: Refactor java/util/zip/ZipFile/deletetempjar.sh
    to plain java test
    + JDK-8210406: Refactor java.util.PluggableLocale:i18n shell
    tests to plain java tests
    + JDK-8210407: Refactor java.util.Calendar:i18n shell tests to
    plain java tests
    + JDK-8210495: compiler crashes because of illegal signature in
    otherwise legal code
    + JDK-8210669: Some launcher tests assume a pre-JDK 9 run-time
    image layout
    + JDK-8210802: temp files left by tests in
    jdk/java/net/httpclient
    + JDK-8210819: Update the host name in CNameTest.java
    + JDK-8210908: Refactor java/util/prefs/PrefsSpi.sh to plain
    java test
    + JDK-8210934: Move sun/net/www/protocol/http/
    /GetErrorStream.java to OpenJDK
    + JDK-8210959: JShell fails and exits when statement throws an
    exception whose message contains a '%%'.
    + JDK-8211055: Provide print to a file (PDF) feature even when
    printer was not connected
    + JDK-8211092: test/jdk/sun/net/www/http/HttpClient/
    /MultiThreadTest.java fails intermittently when cleaning up
    + JDK-8211296: Remove HotSpot deprecation warning suppression
    for Mac/clang
    + JDK-8211325: test/jdk/java/net/Socket/LingerTest.java fails
    with cleaning up
    + JDK-8212040: Compilation error due to wrong usage of
    NSPrintJobDispositionValue in mac10.12
    + JDK-8212695: Add explicit timeout to several HTTP Client tests
    + JDK-8212718: Refactor some annotation processor tests to
    better use collections
    + JDK-8213007: Update the link in test/jdk/sun/security/
    /provider/SecureRandom/DrbgCavp.java
    + JDK-8213137: Remove static initialization of monitor/mutex
    instances
    + JDK-8213235: java/nio/channels/SocketChannel/
    /AsyncCloseChannel.java fails with threads that didn't exit
    + JDK-8213409: Refactor sun.text.IntHashtable:i18n shell tests
    to plain java tests
    + JDK-8213576: Make test AsyncCloseChannel.java run in othervm
    + JDK-8213694: Test Timeout.java should run in othervm mode
    + JDK-8213718: [TEST] Wrong classname in vmTestbase/nsk/stress/
    /except/except002 and except003
    + JDK-8213922: fix ctw stand-alone build
    + JDK-8214195: Align stdout messages in
    test/jdk/java/math/BigInteger/PrimitiveConversionTests.java
    + JDK-8214520: [TEST_BUG] sun/security/mscapi/nonUniqueAliases/
    /NonUniqueAliases.java failed with incorrect jtreg tags order
    + JDK-8214937: sun/security/tools/jarsigner/warnings/
    /NoTimestampTest.java failed due to unexpected expiration date
    + JDK-8216532: tools/launcher/Test7029048.java fails (Solaris)
    + JDK-8217825: Verify @AfterTest is used correctly in WebSocket
    tests
    + JDK-8218145: block_if_requested is not proper inlined due to
    size
    + JDK-8219417: bump jtreg requiredVersion to b14
    + JDK-8219552: bump jtreg requiredVersion to b14 in
    test/jdk/sanity/client/
    + JDK-8219804: java/net/MulticastSocket/Promiscuous.java fails
    intermittently due to NumberFormatException
    + JDK-8220445: Support for side by side MSVC Toolset versions
    + JDK-8221988: add possibility to build with Visual Studio 2019
    + JDK-8222751: closed/test/jdk/sun/security/util/
    /DerIndefLenConverter/IndefBerPkcs12.java fail
    + JDK-8223050: JVMCI: findUniqueConcreteMethod() should not use
    Dependencies::find_unique_concrete_method() for non-virtual
    methods
    + JDK-8224853: CDS address sanitizer errors
    + JDK-8225082: Remove IdenTrust certificate that is expiring in
    September 2021
    + JDK-8225583: Examine the HttpResponse.BodySubscribers for
    null handling and multiple subscriptions
    + JDK-8225690: Multiple AttachListener threads can be created
    + JDK-8225790: Two NestedDialogs tests fail on Ubuntu
    + JDK-8226319: Add forgotten test/jdk/java/net/httpclient/
    /BodySubscribersTest.java
    + JDK-8226533: JVMCI: findUniqueConcreteMethod should handle
    statically bindable methods directly
    + JDK-8226602: Test convenience reactive primitives from
    java.net.http with RS TCK
    + JDK-8226683: Remove review suggestion from fix to 8219804
    + JDK-8227738: jvmti/DataDumpRequest/datadumpreq001 failed due
    to "exit code is 134"
    + JDK-8227766: CheckUnhandledOops is broken in MemAllocator
    + JDK-8227815: Minimal VM: set_state is not a member of
    AttachListener
    + JDK-8230674: Heap dumps should exclude dormant CDS archived
    objects of unloaded classes
    + JDK-8230808: Remove Access::equals()
    + JDK-8230841: Remove oopDesc::equals()
    + JDK-8231717: Improve performance of charset decoding when
    charset is always compactable
    + JDK-8232243: Wrong caret position in JTextPane on Windows
    with a screen resolution > 100%%
    + JDK-8232782: Shenandoah: streamline post-LRB CAS barrier
    (aarch64)
    + JDK-8233790: Forward output from heap dumper to jcmd/jmap
    + JDK-8233989: Create an IPv4 version of
    java/net/MulticastSocket/SetLoopbackMode.java
    + JDK-8234510: Remove file seeking requirement for writing a
    heap dump
    + JDK-8235211: serviceability/attach/
    /RemovingUnixDomainSocketTest.java fails with
    AttachNotSupportedException: Unable to open socket file
    + JDK-8235216: typo in test filename
    + JDK-8235866: bump jtreg requiredVersion to 4.2b16
    + JDK-8236111: narrow allowSmartActionArgs disabling
    + JDK-8236413: AbstractConnectTimeout should tolerate both
    NoRouteToHostException and UnresolvedAddressException
    + JDK-8236671: NullPointerException in JKS keystore
    + JDK-8238930: problem list compiler/c2/Test8004741.java
    + JDK-8238943: switch to jtreg 5.0
    + JDK-8240555: Using env of JAVA_TOOL_OPTIONS and _JAVA_OPTIONS
    breaks QuietOption.java test
    + JDK-8240983: Incorrect copyright header in Apache Santuario
    2.1.3 files
    + JDK-8241336: Some java.net tests failed with
    NoRouteToHostException on MacOS with special network
    configuration
    + JDK-8241353: NPE in ToolProvider.getSystemJavaCompiler
    + JDK-8241768: git needs .gitattributes
    + JDK-8242882: opening jar file with large manifest might throw
    NegativeArraySizeException
    + JDK-8244973: serviceability/attach/
    /RemovingUnixDomainSocketTest.java fails "stderr was not
    empty"
    + JDK-8245134: test/lib/jdk/test/lib/security/
    /KeyStoreUtils.java should allow to specify aliases
    + JDK-8246261: TCKLocalTime.java failed due to "AssertionError:
    expected [18:14:22] but found [18:14:23]"
    + JDK-8246387: switch to jtreg 5.1
    + JDK-8247421: [TESTBUG] ReturnBlobToWrongHeapTest.java failed
    allocating blob
    + JDK-8247469: getSystemCpuLoad() returns -1 on linux when some
    offline cpus are present and cpusets.effective_cpus is not
    available
    + JDK-8248352: [TEST_BUG] Test test/jdk/java/awt/font/
    /TextLayout/ArabicDiacriticTest.java can leave frame open
    + JDK-8248403: AArch64: Remove uses of kernel integer types
    + JDK-8248414: AArch64: Remove uses of long and unsigned long
    ints
    + JDK-8248657: Windows: strengthening in ThreadCritical
    regarding memory model
    + JDK-8248666: AArch64: Use THREAD_LOCAL instead of __thread
    + JDK-8248668: AArch64: Avoid MIN/MAX macros when using MSVC
    + JDK-8248671: AArch64: Remove unused variables
    + JDK-8248682: AArch64: Use ATTRIBUTE_ALIGNED helper
    + JDK-8248816: C1: Fix signature conflict in
    LIRGenerator::strength_reduce_multiply
    + JDK-8249095: tools/javac/launcher/SourceLauncherTest.java
    fails on Windows
    + JDK-8249548: backward focus traversal gets stuck in button
    group
    + JDK-8249773: Upgrade ReceiveISA.java test to be resilient to
    failure due to stray packets and interference
    + JDK-8249897: jdk/javadoc/tool/LangVers.java uses @ignore w/o
    bug-id
    + JDK-8249898: jdk/javadoc/tool/6176978/T6176978.java uses
    @ignore w/o bug-id
    + JDK-8249899: jdk/javadoc/tool/InlineTagsWithBraces.java uses
    @ignore w/o bug-id
    + JDK-8250588: Shenandoah: LRB needs to save/restore fp
    registers for runtime call
    + JDK-8250824: AArch64: follow up for JDK-8248414
    + JDK-8251166: Add automated testcases for changes done in
    JDK-8214112
    + JDK-8251252: Add automated testcase for fix done in
    JDK-8214253
    + JDK-8251254: Add automated test for fix done in JDK-8218472
    + JDK-8251361: Potential race between Logger configuration and
    GCs in HttpURLConWithProxy test
    + JDK-8251549: Update docs on building for Git
    + JDK-8251945: SIGSEGV in
    PackageEntry::purge_qualified_exports()
    + JDK-8252194: Add automated test for fix done in JDK-8218469
    + JDK-8252648: Shenandoah: name gang tasks consistently
    + JDK-8252825: Add automated test for fix done in JDK-8218479
    + JDK-8252853: AArch64: gc/shenandoah/TestVerifyJCStress.java
    fails intermittently with C1
    + JDK-8252857: AArch64: Shenandoah C1 CAS is not sequentially
    consistent
    + JDK-8253048: AArch64: When CallLeaf, no need to preserve
    callee-saved registers in caller
    + JDK-8253424: Add support for running pre-submit testing using
    GitHub Actions
    + JDK-8253631: Remove unimplemented CompileBroker methods after
    JEP-165
    + JDK-8253865: Pre-submit testing using GitHub Actions does not
    detect failures reliably
    + JDK-8253899: Make IsClassUnloadingEnabled signature match
    specification
    + JDK-8254024: Enhance native libs for AWT and Swing to work
    with GraalVM Native Image
    + JDK-8254054: Pre-submit testing using GitHub Actions should
    not use the deprecated set-env command
    + JDK-8254173: Add Zero, Minimal hotspot targets to submit
    workflow
    + JDK-8254175: Build no-pch configuration in debug mode for
    submit checks
    + JDK-8254244: Some code emitted by TemplateTable::branch is
    unused when running TieredCompilation
    + JDK-8254270: linux 32 bit build doesn't compile
    libjdwp/log_messages.c
    + JDK-8254282: Add Linux x86_32 builds to submit workflow
    + JDK-8254850: Update terminology in java.awt.GridBagLayout
    source code comments
    + JDK-8255255: Update Apache Santuario (XML Signature) to
    version 2.2.1
    + JDK-8255305: Add Linux x86_32 tier1 to submit workflow
    + JDK-8255352: Archive important test outputs in submit workflow
    + JDK-8255373: Submit workflow artifact name is always
    "test-results_.zip"
    + JDK-8255452: Doing GC during JVMTI MethodExit event posting
    breaks return oop
    + JDK-8255718: Zero: VM should know it runs in interpreter-only
    mode
    + JDK-8255790: GTKL&F: Java 16 crashes on initialising GTKL&F
    on Manjaro Linux
    + JDK-8255810: Zero: build fails without JVMTI
    + JDK-8255895: Submit workflow artifacts miss hs_errs/replays
    due to ZIP include mismatch
    + JDK-8256127: Add cross-compiled foreign architectures builds
    to submit workflow
    + JDK-8256215: Shenandoah: re-organize saving/restoring machine
    state in assembler code
    + JDK-8256267: Relax compiler/floatingpoint/NaNTest.java for
    x86_32 and lower -XX:+UseSSE
    + JDK-8256277: Github Action build on macOS should define OS
    and Xcode versions
    + JDK-8256354: Github Action build on Windows should define OS
    and MSVC versions
    + JDK-8256393: Github Actions build on Linux should define OS
    and GCC versions
    + JDK-8256414: add optimized build to submit workflow
    + JDK-8256747: GitHub Actions: decouple the hotspot build-only
    jobs from Linux x64 testing
    + JDK-8257056: Submit workflow should apt-get update to avoid
    package installation errors
    + JDK-8257148: Remove obsolete code in AWTView.m
    + JDK-8257497: Update keytool to create AKID from the SKID of
    the issuing certificate as specified by RFC 5280
    + JDK-8257620: Do not use objc_msgSend_stret to get macOS
    version
    + JDK-8257913: Add more known library locations to simplify
    Linux cross-compilation
    + JDK-8258703: Incorrect 512-bit vector registers restore on
    x86_32
    + JDK-8259338: Add expiry exception for identrustdstx3 alias to
    VerifyCACerts.java test
    + JDK-8259535: ECDSA SignatureValue do not always have the
    specified length
    + JDK-8259679: GitHub actions should use MSVC 14.28
    + JDK-8259924: GitHub actions fail on Linux x86_32 with "Could
    not configure libc6:i386"
    + JDK-8260460: GitHub actions still fail on Linux x86_32 with
    "Could not configure libc6:i386"
    + JDK-8260589: Crash in JfrTraceIdLoadBarrier::load(_jclass*)
    + JDK-8260923: Add more tests for SSLSocket input/output
    shutdown
    + JDK-8261072: AArch64: Fix MacroAssembler::get_thread
    convention
    + JDK-8261147: C2: Node is wrongly marked as reduction
    resulting in a wrong execution due to wrong vector instructions
    + JDK-8261238: NMT should not limit baselining by size threshold
    + JDK-8261496: Shenandoah: reconsider pacing updates memory
    ordering
    + JDK-8261652: Remove some dead comments from os_bsd_x86
    + JDK-8261846: [JVMCI] c2v_iterateFrames can get out of sync
    with the StackFrameStream
    + JDK-8262000: jdk/jfr/event/gc/detailed/
    /TestPromotionFailedEventWithParallelScavenge.java failed with
    "OutOfMemoryError: Java heap space"
    + JDK-8262017: C2: assert(n != __null) failed: Bad immediate
    dominator info.
    + JDK-8262392: Update Mesa 3-D Headers to version 21.0.3
    + JDK-8262409: sun/security/ssl/SSLSocketImpl/
    /SSLSocketImplThrowsWrongExceptions. SSL test failures caused
    by java failed with "Server reported the wrong exception"
    + JDK-8262470: Printed GlyphVector outline with low DPI has bad
    quality on Windows
    + JDK-8262862: Harden tests sun/security/x509/URICertStore/
    /ExtensionsWithLDAP.java and krb5/canonicalize/Test.java
    + JDK-8263136: C4530 was reported from VS 2019 at access bridge
    + JDK-8263227: C2: inconsistent spilling due to dead nodes in
    exception block
    + JDK-8263382: java/util/logging/ParentLoggersTest.java failed
    with "checkLoggers: getLoggerNames() returned unexpected
    loggers"
    + JDK-8263407: SPARC64 detection fails on Athena (SPARC64-X)
    + JDK-8263432: javac may report an invalid package/class clash
    on case insensitive filesystems
    + JDK-8263490: [macos] Crash occurs on JPasswordField with
    activated InputMethod
    + JDK-8263531: Remove unused buffer int
    + JDK-8263667: Avoid running GitHub actions on branches named
    pr/*
    + JDK-8263776: [JVMCI] add helper to perform Java upcalls
    + JDK-8264016: [JVMCI] add some thread local fields for use by
    JVMCI
    + JDK-8264752: SIGFPE crash with option
    FlightRecorderOptions:threadbuffersize=30M
    + JDK-8265132: C2 compilation fails with assert "missing
    precedence edge"
    + JDK-8265231: (fc) ReadDirect and WriteDirect tests fail after
    fix for JDK-8264821
    + JDK-8265335: Epsilon: Minor typo in EpsilonElasticTLABDecay
    description
    + JDK-8265756: AArch64: initialize memory allocated for locals
    according to Windows AArch64 stack page growth requirement in
    template interpreter
    + JDK-8265761: Font with missed font family name is not
    properly printed on Windows
    + JDK-8265773: incorrect jdeps message "jdk8internals" to
    describe a removed JDK internal API
    + JDK-8265836: OperatingSystemImpl.getCpuLoad() returns
    incorrect CPU load inside a container
    + JDK-8266018: Shenandoah: fix an incorrect assert
    + JDK-8266206: Build failure after JDK-8264752 with older GCCs
    + JDK-8266248: Compilation failure in
    PLATFORM_API_MacOSX_MidiUtils.c with Xcode 12.5
    + JDK-8266288: assert root method not found in
    witnessed_reabstraction_in_supers is too strong
    + JDK-8266404: Fatal error report generated with
  - XX:+CrashOnOutOfMemoryError should not contain suggestion to
    submit a bug report
    + JDK-8266480: Implicit null check optimization does not update
    control of hoisted memory operation
    + JDK-8266615: C2 incorrectly folds subtype checks involving an
    interface array
    + JDK-8266642: Improve ResolvedMethodTable hash function
    + JDK-8266749: AArch64: Backtracing broken on PAC enabled
    systems
    + JDK-8266761: AssertionError in
    sun.net.httpserver.ServerImpl.responseCompleted
    + JDK-8266813: Shenandoah: Use shorter instruction sequence for
    checking if marking in progress
    + JDK-8267042: bug in monitor locking/unlocking on ARM32 C1 due
    to uninitialized BasicObjectLock::_displaced_header
    + JDK-8267348: Rewrite gc/epsilon/TestClasses.java to use
    Metaspace with less classes
    + JDK-8267396: Avoid recording "pc" in unhandled oops detector
    for better performance
    + JDK-8267399: C2: java/text/Normalizer/ConformanceTest.java
    test failed with assertion
    + JDK-8267424: CTW: C1 fails with "State must not be null"
    + JDK-8267459: Pasting Unicode characters into JShell does not
    work.
    + JDK-8267625: AARCH64: typo in LIR_Assembler::emit_profile_type
    + JDK-8267666: Add option to jcmd GC.heap_dump to use existing
    file
    + JDK-8267695: Bump update version for OpenJDK: jdk-11.0.13
    + JDK-8267751: (test) jtreg.SkippedException has no serial
    VersionUID
    + JDK-8267773: PhaseStringOpts::int_stringSize doesn't handle
    min_jint correctly
    + JDK-8268103: JNI functions incorrectly return a double after
    JDK-8265836
    + JDK-8268127: Shenandoah: Heap size may be too small for
    region to align to large page size
    + JDK-8268261: C2: assert(n != __null) failed: Bad immediate
    dominator info.
    + JDK-8268347: C2: nested locks optimization may create
    unbalanced monitor enter/exit code
    + JDK-8268360: Missing check for infinite loop during node
    placement
    + JDK-8268362: [REDO] C2 crash when compile negative
    Arrays.copyOf length after loop
    + JDK-8268366: Incorrect calculation of has_fpu_registers in C1
    linear scan
    + JDK-8268369: SIGSEGV in PhaseCFG::implicit_null_check due to
    missing null check
    + JDK-8268417: Add test from JDK-8268360
    + JDK-8268427: Improve AlgorithmConstraints:checkAlgorithm
    performance
    + JDK-8268617: [11u REDO] - WebSocket over authenticating proxy
    fails with NPE
    + JDK-8268620: InfiniteLoopException test may fail on x86
    platforms
    + JDK-8268635: Corrupt oop in ClassLoaderData
    + JDK-8268699: Shenandoah: Add test for JDK-8268127
    + JDK-8268771: javadoc -notimestamp option does not work on
    index.html
    + JDK-8268775: Password is being converted to String in
    AccessibleJPasswordField
    + JDK-8268776: Test `ADatagramSocket.java` missing /othervm
    from @run tag
    + JDK-8268965: TCP Connection Reset when connecting simple
    socket to SSL server
    + JDK-8269304: Regression ~5%% in 2005 in b27
    + JDK-8269415: [11u] Remove ea from
    DEFAULT_PROMOTED_VERSION_PRE in OpenJDK 11u
    + JDK-8269478: Shenandoah: gc/shenandoah/mxbeans tests should
    be more resilient
    + JDK-8269529: javax/swing/reliability/
    /HangDuringStaticInitialization.java fails in Windows debug
    build
    + JDK-8269594: assert(_handle_mark_nesting > 1) failed: memory
    leak: allocating handle outside HandleMark
    + JDK-8269614: [s390] Interpreter checks wrong bit for slow
    path instance allocation
    + JDK-8269650: Optimize gc-locker in
    [Get|Release]StringCritical for latin string
    + JDK-8269661: JNI_GetStringCritical does not lock char array
    + JDK-8269668: [aarch64] java.library.path not including
    /usr/lib64
    + JDK-8269763: The JEditorPane is blank after JDK-8265167
    + JDK-8269795: C2: Out of bounds array load floats above its
    range check in loop peeling resulting in SEGV
    + JDK-8269847: JDK-8269594 backport breaks 11u builds
    + JDK-8269850: Most JDK releases report macOS version 12 as
    10.16 instead of 12.0
    + JDK-8269851: OperatingSystemMXBean getProcessCpuLoad reports
    incorrect process cpu usage in containers
    + JDK-8269882: stack-use-after-scope in NewObjectA
    + JDK-8269934: RunThese24H.java failed with
    EXCEPTION_ACCESS_VIOLATION in
    java_lang_Thread::get_thread_status
    + JDK-8270096: Shenandoah: Optimize gc/shenandoah/
    /TestRefprocSanity.java for interpreter mode
    + JDK-8270137: Kerberos Credential Retrieval from Cache not
    Working in Cross-Realm Setup
    + JDK-8270184: [TESTBUG] Add coverage for jvmci
    ResolvedJavaType.toJavaName() for lambdas
    + JDK-8270196: [11u] [JVMCI] JavaType.toJavaName() returns
    incorrect type name for lambdas
    + JDK-8270556: Exclude security/infra/java/security/cert/
    /CertPathValidator/certification/LetsEncryptCA
    + JDK-8270893: IndexOutOfBoundsException while reading large
    TIFF file
    + JDK-8272078: Wrong Checksums in Temurin BootJDK dependencies
    + JDK-8272124: Cgroup v1 initialization causes
    NullPointerException when cgroup path contains colon
    + JDK-8272131: PhaseMacroExpand::generate_slow_arraycopy crash
    when clone null CallProjections.fallthrough_ioproj
    + JDK-8272197: Update 11u GHA workflow with Shenandoah
    configurations
    + JDK-8272332: --with-harfbuzz=system doesn't add -lharfbuzz
    after JDK-8255790
    + JDK-8272472: StackGuardPages test doesn't build with glibc
    2.34
    + JDK-8272602: [macos] not all KEY_PRESSED events sent when
    control modifier is used
    + JDK-8272628: Problemlist gc/stress/gcbasher/
    /TestGCBasherWithCMS.java for x86_32
    + JDK-8272700: [macos] Build failure with Xcode 13.0 after
    JDK-8264848
    + JDK-8272772: Shenandoah: compiler/c2/aarch64/
    /TestVolatilesShenandoah.java fails in 11u
    + JDK-8273939: Backport of 8248414 to JDK11 breaks
    MacroAssembler::adrp
- Remove the unneeded icedtea-sound provider
- Removed patches:
  * icedtea-sound-1.0.1-jdk9.patch
  * icedtea-sound-soundproperties.patch
    + not needed since the icedtea-sound provider is removed
  * jdk11-glibc234.patch
    + integrated upstream
* Thu Sep 16 2021 fstrba@suse.com
- Added patch:
  * fips.patch
    + implement FIPS support in OpenJDK
* Mon Sep 13 2021 fstrba@suse.com
- Modified patch:
  * nss-security-provider.patch
    + revert recent changes making NSS provider the default one
    + fixes bsc#1190252
* Thu Aug 26 2021 fstrba@suse.com
- Added patch:
  * jdk11-glibc234.patch
    + fix build with glibc-2.34 (bsc#1189201)
* Wed Aug  4 2021 schwab@suse.de
- riscv64-zero.patch: Add support for riscv64 (zero VM)
* Wed Jul 21 2021 fstrba@suse.com
- Update to upstream tag jdk-11.0.12+7 (July 2021, CPU)
  * Security fixes
    + JDK-8256157: Improve bytecode assembly
    + JDK-8256491: Better HTTP transport
    + JDK-8258432, CVE-2021-2341, bsc#1188564: Improve file
    transfers
    + JDK-8260453: Improve Font Bounding
    + JDK-8260960: Signs of jarsigner signing
    + JDK-8260967, CVE-2021-2369, bsc#1188565: Better jar file
    validation
    + JDK-8262380: Enhance XML processing passes
    + JDK-8262403: Enhanced data transfer
    + JDK-8262410: Enhanced rules for zones
    + JDK-8262477: Enhance String Conclusions
    + JDK-8262967: Improve Zip file support
    + JDK-8264066, CVE-2021-2388, bsc#1188566: Enhance compiler
    validation
    + JDK-8264079: Improve abstractions
    + JDK-8264460: Improve NTLM support
  * Other changes
    + JDK-6847157: java.lang.NullPointerException: HDC for
    component at sun.java2d.loops.Blit.Blit
    + JDK-7106851: Test should not use System.exit
    + JDK-8073446: TimeZone getOffset API does not  return a dst
    offset between years 2038-2137
    + JDK-8076190: Customizing the generation of a PKCS12 keystore
    + JDK-8153005: Upgrade the default PKCS12 encryption/MAC
    algorithms
    + JDK-8171303: sun/java2d/pipe/InterpolationQualityTest.java
    fails on Windows & Linux
    + JDK-8177068: incomplete classpath causes NPE in Flow
    + JDK-8185734: [Windows] Structured Exception Catcher missing
    around gtest execution
    + JDK-8187450: JNI local refs exceeds capacity warning in
    NetworkInterface::getAll
    + JDK-8190763: Class cast exception on (CompoundEdit)
    UndoableEditEvent.getEdit()
    + JDK-8195841: PNGImageReader.readNullTerminatedString() doesnt
    check for non-null terminated strings with length equal to
    maxLen
    + JDK-8196100: javax/swing/text/JTextComponent/5074573/
    /bug5074573.java fails
    + JDK-8199646: JShell tests: jdk/jshell/
    /FailOverDirectExecutionControlTest.java failed with
    java.lang.UnsupportedOperationException
    + JDK-8206925: Support the certificate_authorities extension
    + JDK-8207160: ClassReader::adjustMethodParams can potentially
    return null if the args list is empty
    + JDK-8207247: AARCH64: Enable Minimal and Client VM builds
    + JDK-8207404: MulticastSocket tests failing on AIX
    + JDK-8207779: Method::is_valid_method() compares 'this' with
    NULL
    + JDK-8208061: runtime/LoadClass/TestResize.java fails with
    "Load factor too high" when running in CDS mode.
    + JDK-8209459: TestSHA512MultiBlockIntrinsics failed on AArch64
    + JDK-8210443: Migrate Locale matching tests to JDK Repo.
    + JDK-8213231: ThreadSnapshot::_threadObj can become stale
    + JDK-8213483: ARM32: runtime/ErrorHandling/
    /ShowRegistersOnAssertTest.java jtreg test fail
    + JDK-8213725: JShell NullPointerException due to class file
    with unexpected package
    + JDK-8213794: ARM32: disable TypeProfiling,
    CriticalJNINatives, Serviceablity tests for ARM32
    + JDK-8213845: ARM32: Interpreter doesn't call result handler
    after native calls
    + JDK-8214128: ARM32: wrong stack alignment on
    Deoptimization::unpack_frames
    + JDK-8214512: ARM32: Jtreg test compiler/c2/Test8062950.java
    fails on ARM
    + JDK-8214854: JDWP: Unforseen output truncation in logging
    + JDK-8214922: Add vectorization support for fmin/fmax
    + JDK-8215009: GCC 8 compilation error in libjli
    + JDK-8216184: CDS/appCDS tests failed on Windows due to long
    path to a classlist file
    + JDK-8216259: AArch64: Vectorize Adler32 intrinsics
    + JDK-8216314: SIGILL in CodeHeapState::print_names()
    + JDK-8217348: assert(thread->is_Java_thread()) failed: just
    checking
    + JDK-8217465: [REDO] - Optimize CodeHeap Analytics
    + JDK-8217561: X86: Add floating-point Math.min/max intrinsics
    + JDK-8217918: C2: -XX:+AggressiveUnboxing is broken
    + JDK-8218458: [TESTBUG] runtime/NMT/
    /CheckForProperDetailStackTrace.java fails with Expected
    stack trace missing from output
    + JDK-8219142: Remove unused JIMAGE_ResourcePath
    + JDK-8219586: CodeHeap State Analytics processes dead nmethods
    + JDK-8220074: Clean up GCC 8.3 errors in LittleCMS
    + JDK-8220407: compiler/intrinsics/math/
    /TestFpMinMaxIntrinsics.java timedout
    + JDK-8222302: [TESTBUG] test/hotspot/jtreg/compiler/intrinsics/
    /sha/cli/TestUseSHAOptionOnUnsupportedCPU.java fails on any
    other CPU
    + JDK-8222412: AARCH64: multiple instructions encoding issues
    + JDK-8223020: aarch64: expand minI_rReg and maxI_rReg patterns
    into separate instructions
    + JDK-8223444: Improve CodeHeap Free Space Management
    + JDK-8223504: Improve performance of forall loops by better
    inlining of "iterator()" methods
    + JDK-8223667: ASAN build broken
    + JDK-8225081: Remove Telia Company CA certificate expiring in
    April 2021
    + JDK-8225116: Test OwnedWindowsLeak.java intermittently fails
    + JDK-8225438: javax/net/ssl/TLSCommon/
    /TestSessionLocalPrincipal.java failed with Read timed out
    + JDK-8225756: [testbug] compiler/loopstripmining/
    /CheckLoopStripMining.java sets too short a
    SafepointTimeoutDelay
    + JDK-8226374: Restrict TLS signature schemes and named groups
    + JDK-8226627: assert(t->singleton()) failed: must be a constant
    + JDK-8226721: Missing intrinsics for Math.ceil, floor, rint
    + JDK-8227080: (fs) Files.newInputStream(...).skip(n) is slow
    + JDK-8227222: vmTestbase/jit/FloatingPoint/gen_math/Loops04/
    /Loops04.java failed XMM register should be 0-15
    + JDK-8227609: (fs) Files.newInputStream(...).skip(n) should
    allow skipping beyond file size
    + JDK-8230428: Cleanup dead CastIP node code in formssel.cpp
    + JDK-8231460: Performance issue (CodeHeap) with large free
    blocks
    + JDK-8231713: x86_32 build failures after JDK-8226721 (Missing
    intrinsics for Math.ceil, floor, rint)
    + JDK-8231841: AArch64: debug.cpp help() is missing an AArch64
    line for pns
    + JDK-8232084: HotSpot build failed with GCC 9.2.1
    + JDK-8232591: AArch64: Add missing match rules for smaddl,
    smsubl and smnegl
    + JDK-8233185: HttpServer.stop() blocks indefinitely when
    called on dispatch thread
    + JDK-8233787: Break cycle in vm_version* includes
    + JDK-8233948: AArch64: Incorrect mapping between OptoReg and
    VMReg for high 64 bits of Vector Register
    + JDK-8234355: Buffer overflow in jcmd GC.class_stats due to
    too many classes
    + JDK-8235368: Update BCEL to Version 6.4.1
    + JDK-8236859: WebSocket over authenticating proxy fails with
    NPE
    + JDK-8236992: AArch64: remove redundant load_klass in itable
    stub
    + JDK-8237743: test/langtools/jdk/jshell/
    /FailOverExecutionControlTest.java fails No
    ExecutionControlProvider with name 'nonExistent' and parameter
    keys: []
    + JDK-8237804: sun/security/mscapi tests fail with "Key pair
    not generated, alias <nnnnnn> already exists"
    + JDK-8238175: CTW: Class.getDeclaredMethods fails with
    assert(k->is_subclass_of(SystemDictionary::Throwable_klass()))
    failed: invalid exception class
    + JDK-8238567: SoftMainMixer.processAudioBuffers(): Wrong
    handling of stoppedMixers
    + JDK-8238812: assert(false) failed: bad AD file
    + JDK-8239312: [macos] javax/swing/JFrame/NSTexturedJFrame/
    /NSTexturedJFrame.java
    + JDK-8239386: handle ContendedPaddingWidth in
    vm_version_aarch64
    + JDK-8239536: Can't use 'java.util.List' object after
    importing 'java.awt.List'
    + JDK-8240487: Cleanup whitespace in .cc, .hh, .m, and .mm files
    + JDK-8240848: ArrayIndexOutOfBoundsException buf for
    TextCallbackHandler
    + JDK-8241082: Upgrade IANA Language Subtag Registry data to
    03-16-2020 version
    + JDK-8241087: Build failure with VS 2019 (16.5.0) due to C2039
    and C2873
    + JDK-8241101: [s390] jtreg test failure after JDK-8238696: not
    conformant features string
    + JDK-8241248: NullPointerException in
    sun.security.ssl.HKDF.extract(HKDF.java:93)
    + JDK-8241372: Several test failures due to
    javax.net.ssl.SSLException: Connection reset
    + JDK-8241475: AArch64: Add missing support for PopCountVI node
    + JDK-8241829: Cleanup the code for PrinterJob on windows
    + JDK-8241960: The SHA3 message digests impl of SUN provider
    are not thread safe after cloned
    + JDK-8242010: Upgrade IANA Language Subtag Registry to Version
    2020-04-01
    + JDK-8242429: Better implementation for sign extract
    + JDK-8242557: Add length limit for strings in PNGImageWriter
    + JDK-8242919: Paste locks up jshell
    + JDK-8243155: AArch64: Add support for SqrtVF
    + JDK-8243240: AArch64: Add support for MulVB
    + JDK-8243452: JFR: Could not create chunk in repository with
    over 200 recordings
    + JDK-8243559: Remove root certificates with 1024-bit keys
    + JDK-8243597: AArch64: Add support for integer vector abs
    + JDK-8244031: HttpClient should have more tests for HEAD
    requests
    + JDK-8244205: HTTP/2 tunnel connections through proxy may be
    reused regardless of which proxy is selected
    + JDK-8244847: Linux/PPC: runtime/CompressedOops/
    /CompressedClassPointers: smallHeapTest fails
    + JDK-8245511: G1 adaptive IHOP does not account for
    reclamation of humongous objects by young GC
    + JDK-8246274: G1 old gen allocation tracking is not in a
    separate class
    + JDK-8247354: [aarch64] PopFrame causes
    assert(oopDesc::is_oop(obj)) failed: not an oop
    + JDK-8247408: IdealGraph bit check expression canonicalization
    + JDK-8247432: Update IANA Language Subtag Registry to Version
    2020-09-29
    + JDK-8247438: JShell: When FailOverExecutionControlProvider
    fails the proximal cause is not shown
    + JDK-8247753: UIManager.getSytemLookAndFeelClassName() returns
    wrong value on Fedora 32
    + JDK-8248043: Need to eliminate excessive i2l conversions
    + JDK-8248411: [aarch64] Insufficient error handling when
    CodeBuffer is exhausted
    + JDK-8248568: compiler/c2/TestBit.java failed: test missing
    from stdout/stderr
    + JDK-8248870: AARCH64: I2L/L2I conversions can be skipped for
    masked positive values
    + JDK-8249142: java/awt/FontClass/CreateFont/DeleteFont.sh is
    unstable
    + JDK-8249189: AARCH64: more L2I conversions can be skipped
    + JDK-8249719: MethodHandle performance suffers from bad
    ResolvedMethodTable hash function
    + JDK-8249875: GCC 10 warnings -Wtype-limits with JFR code
    + JDK-8250635: MethodArityHistogram should use Compile_lock in
    favour of fancy checks
    + JDK-8250876: Fix issues with cross-compile on macos
    + JDK-8251031: Some vmTestbase/nsk/monitoring/RuntimeMXBean
    tests fail with hostnames starting from digits
    + JDK-8251525: AARCH64: Faster Math.signum(fp)
    + JDK-8252259: AArch64: Adjust default value of FLOATPRESSURE
    + JDK-8252311: AArch64: save two words in itable lookup stub
    + JDK-8252779: compiler/graalunit/HotspotTest.java failed after
    8251525
    + JDK-8252883: AccessDeniedException caused by delayed file
    deletion on Windows
    + JDK-8253167: ARM32 builds fail after JDK-8247910
    + JDK-8253572: [windows] CDS archive may fail to open with long
    file names
    + JDK-8253923: C2 doesn't always run loop opts for compilations
    that include loops
    + JDK-8253948: Memory leak in ImageFileReader
    + JDK-8254631: Better support ALPN byte wire values in SunJSSE
    + JDK-8254717: isAssignableFrom checks in
    KeyFactorySpi.engineGetKeySpec appear to be backwards
    + JDK-8255086: Update the root locale display names
    + JDK-8255625: AArch64: Implement Base64.encodeBlock
    accelerator/intrinsic
    + JDK-8255763: C2: OSR miscompilation caused by invalid memory
    instruction placement
    + JDK-8255992: JFR EventWriter does not use first string from
    StringPool with id 0
    + JDK-8256037: [TESTBUG] com/sun/jndi/dns/ConfigTests/
    /PortUnreachable.java fails due to the hard coded threshold
    is small
    + JDK-8256244: java/lang/ProcessHandle/PermissionTest.java
    fails with TestNG 7.1
    + JDK-8256287: [windows] add loop fuse to
    map_or_reserve_memory_aligned
    + JDK-8256523: Streamline Java SHA2 implementation
    + JDK-8257414: Drag n Drop target area is wrong on high DPI
    systems
    + JDK-8257569: Failure observed with
    JfrVirtualMemory::initialize
    + JDK-8257574: C2: "failed: parsing found no loops but there
    are some" assert failure
    + JDK-8257580: Bump update version for OpenJDK: jdk-11.0.12
    + JDK-8257604: JNI_ArgumentPusherVaArg leaks valist
    + JDK-8257621: JFR StringPool misses cached items across
    consecutive recordings
    + JDK-8257796: [TESTBUG]
    TestUseSHA512IntrinsicsOptionOnSupportedCPU.java fails
    on x86_32
    + JDK-8257822: C2 crashes with SIGFPE due to a division that
    floats above its zero check
    + JDK-8257828: SafeFetch may crash if invoked in non-JavaThreads
    + JDK-8257853: Remove dependencies on JNF's JNI utility
    functions in AWT and 2D code
    + JDK-8257858: [macOS]: Remove JNF dependency from
    libosxsecurity/KeystoreImpl.m
    + JDK-8257860: [macOS]: Remove JNF dependency from
    libosxkrb5/SCDynamicStoreConfig.m
    + JDK-8257988: Remove JNF dependency from
    libsaproc/MacosxDebuggerLocal.m
    + JDK-8258414: OldObjectSample events too expensive
    + JDK-8258505: [TESTBUG] TestDivZeroWithSplitIf.java fails due
    to missing UnlockDiagnosticVMOptions
    + JDK-8258753: StartTlsResponse.close() hangs due to
    synchronization issues
    + JDK-8259061: C2: assert(found) failed: memory-writing node is
    not placed in its original loop or an ancestor of it
    + JDK-8259227: C2 crashes with SIGFPE due to a division that
    floats above its zero check
    + JDK-8259232: Bad JNI lookup during printing
    + JDK-8259276: C2: Empty expression stack when reexecuting
    tableswitch/lookupswitch instructions after deoptimization
    + JDK-8259343: [macOS] Update JNI error handling in Cocoa code.
    + JDK-8259585: Accessible actions do not work on mac os x
    + JDK-8259651: [macOS] Replace JNF_COCOA_ENTER/EXIT macros
    + JDK-8259662: Don't wrap SocketExceptions into SSLExceptions
    in SSLSocketImpl
    + JDK-8259710: Inlining trace leaks memory
    + JDK-8259729: Missed JNFInstanceOf -> IsInstanceOf conversion
    + JDK-8259777: Incorrect predication condition generated by ADLC
    + JDK-8259786: initialize last parameter of getpwuid_r
    + JDK-8259843: initialize dli_fname array before calling
    dll_address_to_library_name
    + JDK-8259869: [macOS] Remove desktop module dependencies on
    JNF Reference APIs
    + JDK-8259886: Improve SSL session cache performance and
    scalability
    + JDK-8259983: do not use uninitialized expand_ms value in
    G1CollectedHeap::expand_heap_after_young_collection
    + JDK-8260030: Improve stringStream buffer handling
    + JDK-8260236: better init AnnotationCollector _contended_group
    + JDK-8260255: C1: LoopInvariantCodeMotion constructor can
    leave some fields uninitialized
    + JDK-8260284: C2: assert(_base == Int) failed: Not an Int
    + JDK-8260380: Upgrade to LittleCMS 2.12
    + JDK-8260420: C2 compilation fails with assert(found_sfpt)
    failed: no node in loop that's not input to safepoint
    + JDK-8260426: awt debug_mem.c DMem_AllocateBlock might leak
    memory
    + JDK-8260432: allocateSpaceForGP in freetypeScaler.c might
    leak memory
    + JDK-8260616: Removing remaining JNF dependencies in the
    java.desktop module
    + JDK-8260653: Unreachable nodes keep speculative types alive
    + JDK-8260707: java/lang/instrument/PremainClass/
    /InheritAgent0100.java times out
    + JDK-8260925: HttpsURLConnection does not work  with other
    JSSE provider.
    + JDK-8260926: Trace resource exhausted events unconditionally
    + JDK-8261020: Wrong format parameter in
    create_emergency_chunk_path
    + JDK-8261027: AArch64: Support for LSE atomics C++ HotSpot code
    + JDK-8261167: print_process_memory_info add a close call after
    fopen
    + JDK-8261170: Upgrade to freetype 2.10.4
    + JDK-8261198: [macOS] Incorrect JNI parameters in number
    conversion in A11Y code
    + JDK-8261235: C1 compilation fails with
    assert(res->vreg_number() == index) failed: conversion check
    + JDK-8261261: The version extra fields needs to be overridable
    in jib-profiles.js
    + JDK-8261262: Kitchensink24HStress.java crashed with
    EXCEPTION_ACCESS_VIOLATION
    + JDK-8261354: SIGSEGV at MethodIteratorHost
    + JDK-8261355: No data buffering in SunPKCS11 Cipher encryption
    when the underlying mechanism has no padding
    + JDK-8261397: try catch Method failing to work when dividing
    an integer by 0
    + JDK-8261422: Adjust problematic String.format calls in
    jdk/internal/util/Preconditions.java outOfBoundsMessage
    + JDK-8261447: MethodInvocationCounters frequently run into
    overflow
    + JDK-8261481: Cannot read Kerberos settings in dynamic store
    on macOS Big Sur
    + JDK-8261505: Test test/hotspot/jtreg/gc/parallel/
    /TestDynShrinkHeap.java killed by Linux OOM Killer
    + JDK-8261601: free memory in early return in
    Java_sun_nio_ch_sctp_SctpChannelImpl_receive0
    + JDK-8261649: AArch64: Optimize LSE atomics in C++ code
    + JDK-8261730: C2 compilation fails with
    assert(store->find_edge(load) != -1) failed: missing
    precedence edge
    + JDK-8261752: Multiple GC test are missing memory requirements
    + JDK-8261791: (sctp) handleSendFailed in SctpChannelImpl.c
    potential leaks
    + JDK-8261812: C2 compilation fails with assert(!had_error)
    failed: bad dominance
    + JDK-8261914: IfNode::fold_compares_helper faces
    non-canonicalized bool when running JRuby JSON workload
    + JDK-8262093: java/util/concurrent/tck/JSR166TestCase.java
    failed "assert(false) failed: unexpected node"
    + JDK-8262110: DST starts from incorrect time in 2038
    + JDK-8262121: [11u] Redo 8244287: JFR: Methods samples have
    line number 0
    + JDK-8262163: Extend settings printout in jcmd VM.metaspace
    + JDK-8262295: C2: Out-of-Bounds Array Load from Clone Source
    + JDK-8262298: G1BarrierSetC2::step_over_gc_barrier fails with
    assert "bad barrier shape"
    + JDK-8262446: DragAndDrop hangs on Windows
    + JDK-8262461: handle wcstombsdmp return value correctly in
    unix awt_InputMethod.c
    + JDK-8262465: Very long compilation times and high memory
    consumption in C2 debug builds
    + JDK-8262726: AArch64: C1 StubAssembler::call_RT can corrupt
    stack
    + JDK-8262739: String inflation C2 intrinsic prevents insertion
    of anti-dependencies
    + JDK-8262829: Native crash in
    Win32PrintServiceLookup.getAllPrinterNames()
    + JDK-8262837: handle split_USE correctly
    + JDK-8262900: ToolBasicTest fails to access HTTP server it
    starts
    + JDK-8263260: [s390] Support latest hardware (z14 and z15)
    + JDK-8263311: Watch registry changes for remote printers
    update instead of polling
    + JDK-8263361: Incorrect arraycopy stub selected by C2 for SATB
    collectors
    + JDK-8263404: RsaPrivateKeySpec is always recognized as
    RSAPrivateCrtKeySpec in RSAKeyFactory.engineGetKeySpec
    + JDK-8263425: AArch64: two potential bugs in C1
    LIRGenerator::generate_address()
    + JDK-8263448: CTW: fatal error: meet not symmetric
    + JDK-8263504: Some OutputMachOpcodes fields are uninitialized
    + JDK-8263557: Possible NULL dereference in
    Arena::destruct_contents()
    + JDK-8263558: Possible NULL dereference in fast path arena
    free if ZapResourceArea is true
    + JDK-8263676: AArch64: one potential bug in C1
    LIRGenerator::generate_address()
    + JDK-8263729: [test] divert spurious output away from stream
    under test in ProcessBuilder Basic test
    + JDK-8263846: Bad JNI lookup getFocusOwner in accessibility
    code on Mac OS X
    + JDK-8264047: Duplicate global variable 'jvm' in libjavajpeg
    and libawt
    + JDK-8264096: slowdebug jvm crashes when StrInflatedCopy match
    rule is not supported
    + JDK-8264151: ciMethod::ensure_method_data() should return
    false is loading resulted in empty state
    + JDK-8264173: [s390] Improve Hardware Feature Detection And
    Reporting
    + JDK-8264190: Harden TLS interop tests
    + JDK-8264223: CodeHeap::verify fails extra_hops assertion in
    fastdebug test
    + JDK-8264328: Broken license in
    javax/swing/JComboBox/8072767/bug8072767.java
    + JDK-8264360: Loop strip mining verification fails with
    "should be on the backedge"
    + JDK-8264626: C1 should be able to inline excluded methods
    + JDK-8264640: CMS ParScanClosure misses a barrier
    + JDK-8264786: [macos] All Swing/AWT apps cause Allow
    Notifications prompt to appear when app is launched
    + JDK-8264821: DirectIOTest fails on a system with large block
    size
    + JDK-8264848: [macos] libjvm.dylib linker warning due to macOS
    version mismatch
    + JDK-8264923: PNGImageWriter.write_zTXt throws Exception with
    a typo
    + JDK-8264958: C2 compilation fails with assert "n is later
    than its clone"
    + JDK-8265099: Revert backport to 11u of 8236859: WebSocket
    over authenticating proxy fails with NPE
    + JDK-8265154: vinserti128 operand mix up for KNL platforms
    + JDK-8265239: Shenandoah: Shenandoah heap region count could
    be off by 1
    + JDK-8265417: Backport of JDK-8249672 breaks Solaris x86 build
    + JDK-8265421: java/lang/String/StringRepeat.java test is
    missing a memory requirement
    + JDK-8265462: Handle multiple slots in the NSS Internal Module
    from SunPKCS11's Secmod
    + JDK-8265537: x86 version string truncated after JDK-8249672
    11u backport
    + JDK-8265666: Enable AIX build platform to make external debug
    symbols
    + JDK-8265677: CMS: CardTableBarrierSet::write_ref_array_work()
    lacks storestore barrier
    + JDK-8265690: Use the latest Ubuntu base image version in
    Docker testing
    + JDK-8265718: Build failure after JDK-8258414 11u backport
    + JDK-8265750: Fatal error in safepoint.cpp after backport of
    8258414
    + JDK-8265784: [C2] Hoisting of DecodeN leaves MachTemp inputs
    behind
    + JDK-8265938: C2's conditional move optimization does not
    handle top Phi
    + JDK-8266220: keytool still prompt for store password on a
    password-less pkcs12 file if -storetype pkcs12 is specified
    + JDK-8266293: Key protection using PBEWithMD5AndDES fails with
    "java.security.InvalidAlgorithmParameterException: Salt must
    be 8 bytes long"
    + JDK-8266713: [AIX] Build failure after 11u backport of
    JDK-8247753
    + JDK-8266802: Shenandoah: Round up region size to page size
    unconditionally
    + JDK-8266892: avoid maybe-uninitialized gcc warnings on linux
    s390x
    + JDK-8266929: Unable to use algorithms from 3p providers
    + JDK-8267235: [macos_aarch64]
    InterpreterRuntime::throw_pending_exception messing up LR
    results in crash
    + JDK-8267561: Shenandoah: Reference processing not properly
    setup for outside of cycle degenerated GC
    + JDK-8267599: Revert the change to the default PKCS12
    macAlgorithm and macIterationCount props for 11u/8u/7u
    + JDK-8267641: [11u] 8227609 backport typo
    + JDK-8267721: Enable sun/security/pkcs11 tests for Amazon
    Linux 2 AArch64
    + JDK-8268678: LetsEncryptCA.java test fails as Let's Encrypt
    Authority X3 is retired
* Thu May 20 2021 fstrba@suse.com
- Modified patch:
  * nss-security-provider.patch
    + make the NSS provider first in the list
* Mon May  3 2021 fstrba@suse.com
- Remove all Jpackage provides for SLE12 in order to avoid
  installing this package as default Java on SLE12-SP5
  (bsc#1185476)
* Wed Apr 21 2021 fstrba@suse.com
- Update to upstream tag jdk-11.0.11+9 (April 2021, CPU)
  * Security fixes
    + JDK-8244473: Contextualize registration for JNDI
    + JDK-8244543: Enhanced handling of abstract classes
    + JDK-8249906, CVE-2021-2163, bsc#1185055: Enhance opening JARs
    + JDK-8250568, CVE-2021-2161, bsc#1185056: Less ambiguous
    processing
    + JDK-8253799: Make lists of normal filenames
    + JDK-8257001: Improve Http Client Support
  * Other changes
    + JDK-7107012: sun.jvm.hotspot.code.CompressedReadStream
    readDouble() conversion to long mishandled
    + JDK-7146776: deadlock between URLStreamHandler.getHostAddress
    and file.Handler.openconnection
    + JDK-8086003: Test fails on OSX with java.lang.RuntimeException
    'Narrow klass base: 0x0000000000000000, Narrow klass shift: 3'
    missing
    + JDK-8168869: jdeps: localized messages don't use proper line
    breaks
    + JDK-8180837: SunPKCS11-NSS tests failing with
    CKR_ATTRIBUTE_READ_ONLY and CKR_MECHANISM_PARAM_INVALID
    + JDK-8202343: Disable TLS 1.0 and 1.1
    + JDK-8205992: jhsdb cannot attach to Java processes running in
    Docker containers
    + JDK-8209193: Fix aarch64-linux compilation after -Wreorder
    changes
    + JDK-8210413: AArch64: Optimize div/rem by constant in C1
    + JDK-8210578: AArch64: Invalid encoding for fmlsvs instruction
    + JDK-8211051: jdeps usage of --dot-output doesn't provide
    valid output for modular jar
    + JDK-8211057: Gensrc step CompileProperties generates unstable
    CompilerProperties output
    + JDK-8211150: G1 Full GC not purging code root memory and
    hence causing memory leak
    + JDK-8211825: ModuleLayer.defineModulesWithXXX does not setup
    delegation when module reads automatic module
    + JDK-8212043: Add floating-point Math.min/max intrinsics
    + JDK-8212218: [TESTBUG] runtime/ErrorHandling/
    /TestHeapDumpOnOutOfMemoryErrorInMetaspace.java timed out
    + JDK-8213116: javax/swing/JComboBox/WindowsComboBoxSize/
    /WindowsComboBoxSizeTest.java fails in Windows
    + JDK-8213909: jdeps --print-module-deps should report missing
    dependences
    + JDK-8214180: Need better granularity for sleeping
    + JDK-8214223: tools/jdeps/listdeps/ListModuleDeps.java failed
    due to missing Lib2 file
    + JDK-8214230: Classes generated by SystemModulesPlugin.java
    are not reproducable
    + JDK-8214741: docs/index.html has no title or copyright
    + JDK-8215687: [Graal] unit test CheckGraalIntrinsics failed
    after 8212043
    + JDK-8217848: [Graal] vmTestbase/nsk/jvmti/ResourceExhausted/
    /resexhausted003/TestDescription.java fails
    + JDK-8218482: sun/security/krb5/auto/ReplayCachePrecise.java
    failed - no KrbException thrown
    + JDK-8218550: Add test omitted from JDK-8212043
    + JDK-8221584: SIGSEGV in os::PlatformEvent::unpark() in
    JvmtiRawMonitor::raw_exit while posting method exit event
    + JDK-8221995: AARCH64: problems with CAS instructions encoding
    + JDK-8222518: Remove unnecessary caching of Parker object in
    java.lang.Thread
    + JDK-8222785: aarch64: add necessary masking for immediate
    shift counts
    + JDK-8223186: HotSpot compile warnings from GCC 9
    + JDK-8225773: jdeps --check produces NPE if there are missing
    module dependences
    + JDK-8225805: Java Access Bridge does not close the logger
    + JDK-8226810: Failed to launch JVM because of
    NullPointerException occured on System.props
    + JDK-8229396: jdeps ignores multi-release when
    generate-module-info used on command line
    + JDK-8229474: Shenandoah: Cleanup CM::update_roots()
    + JDK-8232225: Rework the fix for JDK-8071483
    + JDK-8232905: JFR fails with assertion:
    assert(t->unflushed_size() == 0) failed: invariant
    + JDK-8233164: C2 fails with assert(phase->C->get_alias_index(t)
    == phase->C->get_alias_index(t_adr)) failed: correct memory
    chain
    + JDK-8233910: java/awt/ColorClass/AlphaColorTest.java is
    failing  intermittently in nightly lnux-x64 system
    + JDK-8233912: aarch64: minor improvements of atomic operations
    + JDK-8234508: VM_HeapWalkOperation::iterate_over_object reads
    non-strong fields with an on-strong load barrier
    + JDK-8234742: Improve handshake logging
    + JDK-8234796: Refactor Handshake::execute to take a more
    complex type than ThreadClosure
    + JDK-8235324: Dying objects are published from users of
    CollectedHeap::object_iterate
    + JDK-8235351: Lookup::unreflect should bind with the original
    caller independent of Method's accessible flag
    + JDK-8237369: Shenandoah: failed vmTestbase/nsk/jvmti/
    /AttachOnDemand/attach021/TestDescription.java test
    + JDK-8237392: Shenandoah: Remove unreliable assertion
    + JDK-8237483: AArch64 C1 OopMap inserted twice fatal error
    + JDK-8237495: Java MIDI fails with a dereferenced memory error
    when asked to send a raw 0xF7
    + JDK-8239355: (dc) Initial value of SO_SNDBUF should allow
    sending large datagrams (macOS)
    + JDK-8240353: AArch64: missing support for
  - XX:+ExtendedDTraceProbes in C1
    + JDK-8240704: CheckHandles.java failed "AssertionError: Handle
    use increased by more than 10 percent."
    + JDK-8240751: Shenandoah: fold ShenandoahTracer definition
    + JDK-8240795: [REDO] 8238384 CTW: C2 compilation fails with
    "assert(store != load->find_exact_control(load->in(0)))
    failed: dependence cycle found"
    + JDK-8241598: Upgrade JLine to 3.14.0
    + JDK-8241649: Optimize Character.toString
    + JDK-8241770: Module xxxAnnotation() methods throw NCDFE if
    module-info.class found as resource in unnamed module
    + JDK-8241911: AArch64: Fix a potential register clash issue in
    reduce_add2I
    + JDK-8242030: Wrong package declarations in jline classes after
    JDK-8241598
    + JDK-8242565: Policy initialization issues when the denyAfter
    constraint is enabled
    + JDK-8243618: compiler/rtm/cli tests can be run w/o WhiteBox
    + JDK-8243670: Unexpected test result caused by C2
    MergeMemNode::Ideal
    + JDK-8244088: [Regression] Switch of Gnome theme ends up in
    deadlocked UI
    + JDK-8244154: Update SunPKCS11 provider with PKCS11 v3.0 header
    files
    + JDK-8244340: Handshake processing thread lacks yielding
    + JDK-8244573: java.lang.ArrayIndexOutOfBoundsException thrown
    for malformed class file
    + JDK-8244683: A TSA server used by tests
    + JDK-8245005: javax/net/ssl/compatibility/BasicConnectTest.java
    failed with No enum constant
    + JDK-8245026: PsAdaptiveSizePolicy::_old_gen_policy_is_ready is
    unused
    + JDK-8245283: JFR: Can't handle constant dynamic used by Jacoco
    agent
    + JDK-8245512: CRC32 optimization using AVX512 instructions
    + JDK-8245527: LDAP Channel Binding support for Java
    GSS/Kerberos
    + JDK-8246707: (sc) SocketChannel.read/write throws
    AsynchronousCloseException on closed channel
    + JDK-8246709: sun/security/tools/jarsigner/
    /TsacertOptionTest.java compilation failed after JDK-8244683
    + JDK-8247200: assert((unsigned)fpargs < 32)
    + JDK-8247766: [aarch64] guarantee(val < (1U << nbits))
    failed: Field too big for insn.
    + JDK-8248336: AArch64: C2: offset overflow in
    BoxLockNode::emit
    + JDK-8248865: Document JNDI/LDAP timeout properties
    + JDK-8248901: Signed immediate support in
    .../share/assembler.hpp is broken.
    + JDK-8249543: Force DirectBufferAllocTest to run with
  - ExplicitGCInvokesConcurrent
    + JDK-8249588: libwindowsaccessbridge issues on 64bit Windows
    + JDK-8249749: modify a primitive array through a stream and a
    for cycle causes jre crash
    + JDK-8249787: Make TestGCLocker more resilient with concurrent
    GCs
    + JDK-8249867: xml declaration is not followed by a newline
    + JDK-8250911: [windows] os::pd_map_memory() error detection
    broken
    + JDK-8251255: [linux] Add process-memory information to hs-err
    and VM.info
    + JDK-8251359: Shenandoah: filter null oops before calling
    enqueue/SATB barrier
    + JDK-8251925: C2: RenaissanceStressTest fails with
    assert(!had_error): bad dominance
    + JDK-8251944: Add Shenandoah test config to
    compiler/gcbarriers/UnsafeIntrinsicsTest.java
    + JDK-8251992: VM crashed running TestComplexAddrExpr.java test
    with -XX:UseAVX=X
    + JDK-8253220: Epsilon: clean up unused code/declarations
    + JDK-8253274: The CycleDMImagetest brokes the system
    + JDK-8253353: Crash in C2: guarantee(n != NULL) failed: No Node
    + JDK-8253368: TLS connection always receives close_notify
    exception
    + JDK-8253404: C2: assert(C->live_nodes() <=
    C->max_node_limit()) failed: Live Node limit exceeded limit
    + JDK-8253409: Double-rounding possibility in float fma
    + JDK-8253476: TestUseContainerSupport.java fails on some Linux
    kernels w/o swap limit capabilities
    + JDK-8253524: C2: Refactor code that clones predicates during
    loop unswitching
    + JDK-8253644: C2: assert(skeleton_predicate_has_opaque(iff))
    failed: unexpected
    + JDK-8253681: closed java/awt/dnd/MouseEventAfterStartDragTest/
    /MouseEventAfterStartDragTest.html test failed
    + JDK-8253702: BigSur version number reported as 10.16, should
    be 11.nn
    + JDK-8253756: C2 CompilerThread0 crash in Node::add_req(Node*)
    + JDK-8254104: MethodCounters must exist before nmethod is
    installed
    + JDK-8254734: "dead loop detected" assert failure with patch
    from 8223051
    + JDK-8254748: Bad Copyright header format after JDK-8212218
    + JDK-8254799: runtime/ErrorHandling/
    /TestHeapDumpOnOutOfMemoryError.java fails with release VMs
    + JDK-8255058: C1: assert(is_virtual()) failed: type check
    + JDK-8255351: Add detection for Graviton 2 CPUs
    + JDK-8255368: Math.exp() gives wrong result for large values on
    x86 32-bit platforms
    + JDK-8255387: Japanese characters were printed upside down on
    AIX
    + JDK-8255401: Shenandoah: Allow oldval and newval registers to
    overlap in cmpxchg_oop()
    + JDK-8255479: [aarch64] assert(src->section_index_of(target) ==
    CodeBuffer::SECT_NONE) failed: sanity
    + JDK-8255544: Create a checked cast
    + JDK-8255559: Leak File Descriptors Because of
    ResolverLocalFilesystem#engineResolveURI()
    + JDK-8255681: print callstack in error case in
    runAWTLoopWithApp
    + JDK-8255734: VM should ignore SIGXFSZ on ppc64, s390 too
    + JDK-8255742: PrintInlining as compiler directive doesn't print
    virtual calls
    + JDK-8255845: Memory leak in imageFile.cpp
    + JDK-8255880: UI of Swing components is not redrawn after their
    internal state changed
    + JDK-8255908: ExceptionInInitializerError due to
    UncheckedIOException while initializing cgroupv1 subsystem
    + JDK-8256025: AArch64: MachCallRuntimeNode::ret_addr_offset()
    is incorrect for stub calls
    + JDK-8256056: Deoptimization stub doesn't save vector registers
    on x86
    + JDK-8256061: RegisterSaver::save_live_registers() omits upper
    halves of ZMM0-15 registers
    + JDK-8256187: [TEST_BUG] Automate bug4275046.java test
    + JDK-8256220: C1: x86_32 fails with -XX:UseSSE=1 after
    JDK-8210764 due to mishandled lir_neg
    + JDK-8256258: some missing NULL checks or asserts after
    CodeCache::find_blob_unsafe
    + JDK-8256264: Printed GlyphVector outline with low DPI has bad
    quality on Windows
    + JDK-8256290: javac/lambda/T8031967.java fails with
    StackOverflowError on x86_32
    + JDK-8256359: AArch64: runtime/ReservedStack/
    /ReservedStackTestCompiler.java fails
    + JDK-8256387: Unexpected result if patching an entire
    instruction on AArch64
    + JDK-8256421: Add 2 HARICA roots to cacerts truststore
    + JDK-8256488: [aarch64] Use ldpq/stpq instead of ld4/st4 for
    small copies in StubGenerator::copy_memory
    + JDK-8256489: Make gtest for long path names on Windows more
    resilient in the presence of virus scanners
    + JDK-8256501: libTestMainKeyWindow fails to build with Xcode
    12.2
    + JDK-8256633: Fix product build on Windows+Arm64
    + JDK-8256682: JDK-8202343 is incomplete
    + JDK-8256751: Incremental rebuild with precompiled header fails
    when touching a header file
    + JDK-8256757: Incorrect MachCallRuntimeNode::ret_addr_offset()
    for CallLeafNoFP on x86_32
    + JDK-8256806: Shenandoah: optimize shenandoah/jni/
    /TestPinnedGarbage.java test
    + JDK-8256807: C2: Not marking stores correctly as mismatched
    in string opts
    + JDK-8256810: Incremental rebuild broken on Macosx
    + JDK-8256818: SSLSocket that is never bound or connected leaks
    socket resources
    + JDK-8256888: Client manual test problem list update
    + JDK-8257083: Security infra test failures caused by
    JDK-8202343
    + JDK-8257408: Bump update version for OpenJDK: jdk-11.0.11
    + JDK-8257423: [PPC64] Support -XX:-UseInlineCaches
    + JDK-8257436: [aarch64] Regressions in ArrayCopyUnalignedDst
    .testByte/testChar for 65-78 bytes when UseSIMDForMemoryOps
    is on
    + JDK-8257513: C2: assert((constant_addr -
    _masm.code()->consts()->start()) == con.offset())
    + JDK-8257547: Handle multiple prereqs on the same line in deps
    files
    + JDK-8257561: Some code is not vectorized after 8251925 and
    8250607
    + JDK-8257565: epsilonBarrierSet.hpp should not include
    barrierSetAssembler
    + JDK-8257575: C2: "failed: only phis" assert failure in loop
    strip mining verification
    + JDK-8257594: C2 compiled checkcast of non-null object triggers
    endless deoptimization/recompilation cycle
    + JDK-8257633: Missing -mmacosx-version-min=X flag when linking
    libjvm
    + JDK-8257670: sun/security/ssl/SSLSocketImpl/SSLSocketLeak.java
    reports leaks
    + JDK-8257707: Fix incorrect format string in Http1HeaderParser
    + JDK-8257746: Regression introduced with JDK-8250984 - memory
    might be null in some machines
    + JDK-8257798: [PPC64] undefined reference to
    Klass::vtable_start_offset()
    + JDK-8257884: Re-enable sun/security/ssl/SSLSocketImpl/
    /SSLSocketLeak.java as automatic test
    + JDK-8257910: [JVMCI] Set exception_seen accordingly in the
    runtime.
    + JDK-8257997: sun/security/ssl/SSLSocketImpl/SSLSocketLeak.java
    again reports leaks after JDK-8257884
    + JDK-8257999: Parallel GC crash in gc/parallel/
    /TestDynShrinkHeap.java: new region is not in covered_region
    + JDK-8258077: Using -Xcheck:jni can lead to a double-free after
    JDK-8193234
    + JDK-8258247: Couple of issues in fix for JDK-8249906
    + JDK-8258373: Update the text handling in the JPasswordField
    + JDK-8258396: SIGILL in jdk.jfr.internal.PlatformRecorder
    .rotateDisk()
    + JDK-8258419: RSA cipher buffer cleanup
    + JDK-8258471: "search codecache" clhsdb command does not work
    + JDK-8258534: Epsilon: clean up unused includes
    + JDK-8258805: Japanese characters not entered by mouse click
    on Windows 10
    + JDK-8258833: Cancel multi-part cipher operations in SunPKCS11
    after failures
    + JDK-8258836: JNI local refs exceed capacity
    getDiagnosticCommandInfo
    + JDK-8258884: [TEST_BUG] Convert applet-based test
    open/test/jdk/javax/swing/JMenuItem/8031573/bug8031573.java
    to a regular java test
    + JDK-8259007: This test printed a blank page
    + JDK-8259048: (tz) Upgrade time-zone data to tzdata2020f
    + JDK-8259049: Uninitialized variable after JDK-8257513
    + JDK-8259231: Epsilon: improve performance under contention
    during virtual space expansion
    + JDK-8259271: gc/parallel/TestDynShrinkHeap.java still fails
    "assert(covered_region.contains(new_memregion)) failed: new
    region is not in covered_region"
    + JDK-8259312: VerifyCACerts.java fails as soneraclass2ca cert
    will expire in 90 days
    + JDK-8259319: Illegal package access when SunPKCS11 requires
    SunJCE's classes
    + JDK-8259339: AllocateUninitializedArray C2 intrinsic fails
    with void.class input
    + JDK-8259428: AlgorithmId.getEncodedParams() should return copy
    + JDK-8259446: runtime/jni/checked/
    /TestCheckedReleaseArrayElements.java fails with stderr not
    empty
    + JDK-8259451: Zero: skip serviceability/sa tests, set vm.hasSA
    to false
    + JDK-8259580: Shenandoah: uninitialized label in
    VerifyThreadGCState
    + JDK-8259619: C1: 3-arg StubAssembler::call_RT stack-use
    condition is incorrect
    + JDK-8259633: compiler/graalunit/CoreTest.java fails with NPE
    after JDK-8244543
    + JDK-8259706: C2 compilation fails with assert(vtable_index ==
    Method::invalid_vtable_index) failed: correct sentinel value
    + JDK-8259707: LDAP channel binding does not work with StartTLS
    extension
    + JDK-8259773: Incorrect encoding of AVX-512 kmovq instruction
    + JDK-8259849: Shenandoah: Rename store-val to IU-barrier
    + JDK-8259949: x86 32-bit build fails when -fcf-protection is
    passed in the compiler flags
    + JDK-8259954: gc/shenandoah/mxbeans tests fail with -Xcomp
    + JDK-8260029: aarch64: fix typo in verify_oop_array
    + JDK-8260308: Update LogCompilation junit to 4.13.1
    + JDK-8260338: Some fields in HaltNode is not cloned
    + JDK-8260349: Cannot programmatically retrieve Metaspace max
    set via JAVA_TOOL_OPTIONS
    + JDK-8260356: (tz) Upgrade time-zone data to tzdata2021a
    + JDK-8260378: [TESTBUG] DcmdMBeanTestCheckJni.java reports
    false positive
    + JDK-8260497: Shenandoah: Improve SATB flushing
    + JDK-8260502: [s390] NativeMovRegMem::verify() fails because
    it's too strict
    + JDK-8260632: Build failures after JDK-8253353
    + JDK-8260704: ParallelGC: oldgen expansion needs release-store
    for _end
    + JDK-8261022: Fix incorrect result of Math.abs() with char type
    + JDK-8261089: [TESTBUG] native library of test
    TestCheckedReleaseCriticalArray.java fails to compile with
    gcc 4.x
    + JDK-8261183: Follow on to Make lists of normal filenames
    + JDK-8261209: isStandalone property: remove dependency on
    pretty-print
    + JDK-8261231: Windows IME was disabled after DnD operation
    + JDK-8261251: Shenandoah: Use object size for full GC
    humongous compaction
    + JDK-8261310: PPC64 Zero build fails with
    'VMError::controlled_crash(int)::FunctionDescriptor
    functionDescriptor' has incomplete type and cannot be defined
    + JDK-8261334: NMT: tuning statistic shows incorrect hash
    distribution
    + JDK-8261413: Shenandoah: Disable class-unloading in I-U mode
    + JDK-8261522: [PPC64] AES intrinsics write beyond the
    destination array
    + JDK-8261534: Test sun/security/pkcs11/KeyAgreement/
    /IllegalPackageAccess.java fails on platforms where no nsslib
    artifacts are defined
    + JDK-8261585: Restore HandleArea used in
    Deoptimization::uncommon_trap
    + JDK-8261753: Test java/lang/System/OsVersionTest.java still
    failing on BigSur patch versions after JDK-8253702
    + JDK-8261829: Exclude tools/jlink/JLinkReproducibleTest.java
    in 11u
    + JDK-8261912: Code IfNode::fold_compares_helper more
    defensively
    + JDK-8261920: [AIX] jshell command throws java.io.IOError on
    non English locales
    + JDK-8262018: Wrong format in SAP copyright header of
    OsVersionTest
    + JDK-8263069: Exclude some failing tests from
    security/infra/java/security/cert/CertPathValidator
* Thu Apr 15 2021 pujos.michael@gmail.com
- moved mozilla-nss dependency to java-11-openjdk-headless package
  This is necessary to be able to do crypto with just
  java-11-openjdk-headless installed. Fixes boo#1184606
* Fri Mar 19 2021 fstrba@suse.com
- Added patches:
  * system-crypto-policy.patch
    + Let OpenJDK use system crypto policies unless explicitely told
    not to
  * nss-security-provider.patch
    + Add the NSS security provider with configuration in generated
    nss.cfg file
  * keytool-default-rsa.patch
    + Make keytool generate RSA keys by default, since only the
    LEGACY system crypto policy allows DSA
* Thu Jan 21 2021 fstrba@suse.com
- Update to upstream tag jdk-11.0.10+9 (January 2021 CPU,
  bsc#1181239)
  * Security fixes
    + JDK-8247619: Improve Direct Buffering of Characters
  * Other changes
    + JDK-6722928: Support SSPI as a native GSS-API provider
    + JDK-7185258: [macosx] Deadlock in SunToolKit.realSync()
    + JDK-8152332: [macosx] JFileChooser cannot be serialized on
    Mac OS X
    + JDK-8161684: [testconf] Add VerifyOops' testing into compiler
    tiers
    + JDK-8171279: Support X25519 and X448 in TLS
    + JDK-8173361: various crashes in
    JvmtiExport::post_compiled_method_load
    + JDK-8173658: JvmtiExport::post_class_unload() is broken for
    non-JavaThread initiators
    + JDK-8191006: hsdis disassembler plugin does not compile with
    binutils 2.29+
    + JDK-8197981: Missing return statement in
    __sync_val_compare_and_swap_8
    + JDK-8198334: java/awt/FileDialog/8003399/bug8003399.java
    fails in headless mode
    + JDK-8200151: Add 8 JNDI tests to com/sun/jndi/dns/ConfigTests/
    + JDK-8208279: Add 8 JNDI tests to com/sun/jndi/dns/EnvTests/
    + JDK-8208483: Add 5 JNDI tests to
    com/sun/jndi/dns/FactoryTests/
    + JDK-8208542: Add 4 JNDI tests to com/sun/jndi/dns/ListTests/
    + JDK-8208665: Amend cross-compilation docs with
    qemu-debootstrap recipe
    + JDK-8210088: ProblemList gc/epsilon/TestMemoryMXBeans.java
    + JDK-8210339: Add 10 JNDI tests to com/sun/jndi/dns/FedTests/
    + JDK-8211450: UndetVar::dup is not copying the kind field to
    the duplicated instance
    + JDK-8212160: JVMTI agent crashes with "assert(_value != 0LL)
    failed: resolving NULL _value"
    + JDK-8212226: SurfaceManager throws "Invalid Image variant"
    for MultiResolutionImage (Windows)
    + JDK-8213400: Support choosing group name in keytool keypair
    generation
    + JDK-8213535: Windows HiDPI html lightweight tooltips are
    truncated
    + JDK-8213698: Improve devkit creation and add support for
    linux/ppc64/ppc64le/s390x
    + JDK-8214025: assert(t->singleton()) failed: must be a
    constant when ScavengeRootsInCode < 2
    + JDK-8214242: compiler/arguments/TestScavengeRootsInCode.java
    fails because of missing UnlockDiagnosticVMOptions
    + JDK-8214787: Zero builds fail with "undefined
    JavaThread::thread_state()"
    + JDK-8215583: Exclude
    runtime/handshake/HandshakeWalkSuspendExitTest.java
    + JDK-8216012: Infinite loop in RSA KeyPairGenerator
    + JDK-8216324: GetClassMethods is confused by the presence of
    default methods in super interfaces
    + JDK-8217429: WebSocket over authenticating proxy fails to
    send Upgrade headers
    + JDK-8217976: test/jdk/java/net/httpclient/websocket/
    /WebSocketProxyTest.java fails intermittently
    + JDK-8218021: Have jarsigner preserve posix permission
    attributes
    + JDK-8218287: jshell tool: input behavior unstable after
    12-ea+24 on Windows
    + JDK-8218851: JVM crash in custom classloader stress test, JDK
    12 & 13
    + JDK-8220420: Cleanup c1_LinearScan
    + JDK-8222072: JVMTI GenerateEvents() sends CompiledMethodLoad
    events to wrong jvmtiEnv
    + JDK-8222286: Fix for JDK-8213419 is broken on s390
    + JDK-8222527: HttpClient doesn't send HOST header when
    tunelling HTTP/1.1 through http proxy
    + JDK-8222533: jtreg test jdk/internal/platform/cgroup/
    /TestCgroupMetrics.java fails on SLES12.3 linux ppc64le
    machine
    + JDK-8224506: [TESTBUG] TestDockerMemoryMetrics.java fails
    with exitValue = 137
    + JDK-8224555: vmTestbase/nsk/jvmti/scenarios/contention/TC02/
    /tc02t001/TestDescription.java failed
    + JDK-8224650: Add tests to support X25519 and X448 in TLS
    + JDK-8225072: Add LuxTrust certificate that is expiring in
    March 2021 to list of allowed but expired certs
    + JDK-8225329: -XX:+PrintBiasedLockingStatistics causes crash
    during initialization on Windows platforms
    + JDK-8225687: Newly added sspi.cpp in JDK-6722928 still
    contains some small errors
    + JDK-8227006: [linux] Runtime.availableProcessors execution
    time increased by factor of 100
    + JDK-8227275: Within native OOM error handling, assertions may
    hang the process
    + JDK-8227647: [Graal] Test8009761.java fails due to
    "RuntimeException: static java.lang.Object
    compiler.uncommontrap.Test8009761.m3(boolean,boolean) not
    compiled"
    + JDK-8229495: SIGILL in C2 generated OSR compilation
    + JDK-8230910: libsspi_bridge does not build on Windows 32bit
    + JDK-8232114: JVM crashed at imjpapi.dll in native code
    + JDK-8234147: Avoid looking up standard charsets in core
    libraries
    + JDK-8234393: [macos] printing ignores printer tray
    + JDK-8234863: Increase default value of MaxInlineLevel
    + JDK-8235218: Minimal VM is broken after JDK-8173361
    + JDK-8235456: Minimal VM is broken after JDK-8212160
    + JDK-8235829: graal crashes with Zombie.java test
    + JDK-8236124: Minimal VM slowdebug build failed after
    JDK-8212160
    + JDK-8236512: PKCS11 Connection closed after Cipher.doFinal
    and NoPadding
    + JDK-8236944: The legVecZ operand should be limited to
    zmm0-zmm15 registers
    + JDK-8237186: Fix typo in copyright header of
    java/io/Reader/TransferTo.java
    + JDK-8237499: JFR: Include stack trace in the ThreadStart event
    + JDK-8237512: AArch64: aarch64TestHook leaks a BufferBlob
    + JDK-8237524: AArch64: String.compareTo() may return incorrect
    result
    + JDK-8237950: C2 compilation fails with "Live Node limit
    exceeded limit" during ConvI2L::Ideal optimization
    + JDK-8238579: HttpsURLConnection drops the timeout and hangs
    forever in read
    + JDK-8239105: Add exception for expiring Digicert root
    certificates to VerifyCACerts test
    + JDK-8239477: jdk/jfr/jcmd/TestJcmdStartStopDefault.java fails
  - XX:+VerifyOops with "verify_oop: rsi: broken oop"
    + JDK-8239497: SEGV in EdgeUtils::field_name_symbol(Edge const&)
    + JDK-8239886: Minimal VM build fails after JDK-8237499
    + JDK-8240633: Memory leaks in the implementations of
    FileChooserUI
    + JDK-8240690: Race condition between EDT and
    BasicDirectoryModel.FilesLoader.run0()
    + JDK-8241234: Unify monitor enter/exit runtime entries.
    + JDK-8241311: Move some charset mapping tests from closed to
    open
    + JDK-8241797: Add some tests to the problem list
    + JDK-8242029: AArch64: skip G1 array copy pre-barrier if
    marking not active
    + JDK-8242335: Additional Tests for RSASSA-PSS
    + JDK-8242480: Negative value may be returned by
    getFreeSwapSpaceSize() in the docker
    + JDK-8242614: cleanup duplicated test ldap server in some
    com/sun/jndi/ldap/ tests
    + JDK-8242846: Bring back test/jdk/tools/jlink/plugins/
    /OrderResourcesPluginTest.java
    + JDK-8243114: Implement montgomery{Multiply,Square}intrinsics
    on Windows
    + JDK-8243290: Improve diagnostic messages for class
    verification and redefinition failures
    + JDK-8243488: Add tests for set/get SendBufferSize and
    getReceiveBufferSize in DatagramSocket
    + JDK-8243549: sun/security/ssl/CipherSuite/
    /NamedGroupsWithCipherSuite.java failed with Unsupported
    signature algorithm: DSA
    + JDK-8243617: compiler/onSpinWait/TestOnSpinWaitC1.java test
    uses wrong class
    + JDK-8243619: compiler/codecache/CheckSegmentedCodeCache.java
    test misses -version
    + JDK-8244142: some hotspot/runtime tests don't check exit code
    of forked JVM
    + JDK-8244278: Excessive code cache flushes and sweeps
    + JDK-8244282: test/hotspot/jtreg/compiler/intrinsics/
    /Test8237524.java fails with --illegal-access=deny
    + JDK-8244621: [macos10.15] Garbled FX printing plus CoreText
    warnings on Catalina when building with Xcode 11
    + JDK-8244819: hsdis does not compile with binutils 2.34+
    + JDK-8245051: c1 is broken if it is compiled by gcc without
  - fno-lifetime-dse
    + JDK-8245168: jlink should not be treated as a "small" tool
    + JDK-8245400: Upgrade to LittleCMS 2.11
    + JDK-8246381: VM crashes with "Current BasicObjectLock* below
    than low_mark"
    + JDK-8246434: Threads::print_on_error assumes that the heap
    has been set up
    + JDK-8246648: issue with OperatingSystemImpl
    getFreeSwapSpaceSize in docker after 8242480
    + JDK-8247201: Print potential pointer value of readable stack
    memory in hs_err file
    + JDK-8247763: assert(outer->outcnt() == 2) failed: 'only phis'
    failure in LoopNode::verify_strip_mined()
    + JDK-8247867: Upgrade to freetype 2.10.2
    + JDK-8248190: Enable Power10 system and implement new
    byte-reverse instructions
    + JDK-8248226: TestCloneAccessStressGCM fails with
  - XX:-ReduceBulkZeroing
    + JDK-8248347: windows build broken by JDK-8243114
    + JDK-8248532: Every time I change keyboard language at my
    MacBook, Java crashes
    + JDK-8248552: C2 crashes with SIGFPE due to division by zero
    + JDK-8248596: [TESTBUG] compiler/loopopts/
    /PartialPeelingUnswitch.java times out with Graal enabled
    + JDK-8248745: Add jarsigner and keytool tests for restricted
    algorithms
    + JDK-8248791: sun/util/resources/cldr/TimeZoneNamesTest.java
    fails with -XX:-ReduceInitialCardMarks -XX:-ReduceBulkZeroing
    + JDK-8248845: AArch64: stack corruption after spilling vector
    register
    + JDK-8249176: Update GlobalSignR6CA test certificates
    + JDK-8249183: JVM crash in "AwtFrame::WmSize" method
    + JDK-8249192: MonitorInfo stores raw oops across safepoints
    + JDK-8249602: C2: assert(cnt == _outcnt) failed: no insertions
    allowed
    + JDK-8249603: C1: assert(has_error == false) failed: register
    allocation invalid
    + JDK-8249605: C2: assert(no_dead_loop) failed: dead loop
    detected
    + JDK-8249607: C2: assert(!had_error) failed: bad dominance
    + JDK-8249608: Vector register used by C2 compiled method
    corrupted at safepoint
    + JDK-8249672: Include microcode revision in features_string on
    x86
    + JDK-8249748: gtest silently ignores bad jvm arguments
    + JDK-8249821: Separate libharfbuzz from libfontmanager
    + JDK-8250598: Hyper-V is detected in spite of running on host
    OS
    + JDK-8250605: Linux x86_32 builds fail after JDK-8249821
    + JDK-8250636: iso8601_time returns incorrect offset part on
    MacOS
    + JDK-8250665: Wrong translation for the month name of May in
    ar_JO,LB,SY
    + JDK-8250772: Test com/sun/jndi/ldap/
    /NamingExceptionMessageTest.java fails intermittently with
    javax.naming.ServiceUnavailableException
    + JDK-8250825: C2 crashes with assert(field != __null) failed:
    missing field
    + JDK-8250894: Provide a configure option to build and run
    against the platform libharfbuzz
    + JDK-8250928: JFR: Improve hash algorithm for stack traces
    + JDK-8250968: Symlinks attributes not preserved when using
    jarsigner on zip files
    + JDK-8250984: Memory Docker tests fail on some Linux kernels
    w/o cgroupv1 swap limit capabilities
    + JDK-8251118: BiasedLocking::preserve_marks should not have a
    HandleMark
    + JDK-8251189: com/sun/jndi/ldap/LdapDnsProviderTest.java
    failed due to timeout
    + JDK-8251257: NMT: jcmd VM.native_memory scale=1 crashes
    target VM
    + JDK-8251365: Build failure on AIX after 8250636
    + JDK-8251397: NPE on ClassValue.ClassValueMap.cacheArray
    + JDK-8251456: [TESTBUG] compiler/vectorization/
    /TestVectorsNotSavedAtSafepoint.java failed OutOfMemoryError
    + JDK-8251458: Parse::do_lookupswitch fails with "assert(_cnt
    >= 0) failed"
    + JDK-8251535: Partial peeling at unsigned test adds incorrect
    loop exit check
    + JDK-8251949: ZGC: Set explicit heap size for
    compiler/gcbarriers tests
    + JDK-8252090: JFR: StreamWriterHost::write_unbuffered() stucks
    in an infinite loop OpenJDK (build 13.0.1+9)
    + JDK-8252415: Bump update version for OpenJDK: jdk-11.0.10
    + JDK-8252470: java/awt/dnd/DisposeFrameOnDragCrash/
    /DisposeFrameOnDragTest.java fails on Windows
    + JDK-8252497: Incorrect numeric currency code for ROL
    + JDK-8252660: Shenandoah: support manageable SoftMaxHeapSize
    option
    + JDK-8252679: Two windows specific FileDIalog tests may fail
    on some Windows_Server_2016_Standard
    + JDK-8252696: Loop unswitching may cause out of bound array
    load to be executed
    + JDK-8252754: Hash code calculation of JfrStackTrace is
    inconsistent
    + JDK-8253219: Epsilon: clean up unnecessary includes
    + JDK-8253224: Shenandoah: ShenandoahStrDedupQueue destructor
    calls virtual num_queues()
    + JDK-8253226: Shenandoah: remove unimplemented
    ShenandoahStrDedupQueue::verify
    + JDK-8253269: The CheckCommonColors test should provide more
    info on failure
    + JDK-8253284: Zero OrderAccess barrier mappings are incorrect
    + JDK-8253375: OSX build fails with Xcode 12.0 (12A7209)
    + JDK-8253778: ShenandoahSafepoint::is_at_shenandoah_safepoint
    should not access VMThread state from other threads
    + JDK-8253791: Issue with useAppleColor check in CSystemColors.m
    + JDK-8254016: Test8237524 fails with -XX:-CompactStrings option
    + JDK-8254081: java/security/cert/PolicyNode/
    /GetPolicyQualifiers.java fails due to an expired certificate
    + JDK-8254144: Non-x86 Zero builds fail with return-type
    warning in os_linux_zero.cpp
    + JDK-8254166: Zero: return-type warning in
    zeroInterpreter_zero.cpp
    + JDK-8254177: (tz) Upgrade time-zone data to tzdata2020b
    + JDK-8254185: Fix Code cache sweeper heuristics for JDK 11
    + JDK-8254190: [s390] interpreter misses exception check after
    calling monitorenter
    + JDK-8254790: SIGSEGV in string_indexof_char and
    stringL_indexof_char intrinsics
    + JDK-8254854: [cgroups v1] Metric limits not properly detected
    on some join controller combinations
    + JDK-8254982: (tz) Upgrade time-zone data to tzdata2020c
    + JDK-8255050: Add pkcs11/KeyStore/ClientAuth.sh to Problem list
    + JDK-8255065: Zero: accessor_entry misses the IRIW case
    + JDK-8255226: (tz) Upgrade time-zone data to tzdata2020d
    + JDK-8255269: Unsigned overflow in g1Policy.cpp
    + JDK-8255365: Problem list failing client manual tests
    + JDK-8255457: Shenandoah: cleanup ShenandoahMarkTask
    + JDK-8255466: C2 crashes at ciObject::get_oop() const+0x0
    + JDK-8255550: x86: Assembler::cmpq(Address dst, Register src)
    encoding is incorrect
    + JDK-8255603: Memory/Performance regression after JDK-8210985
    + JDK-8255760: Shenandoah: match constants style in
    ShenandoahMarkTask fallback
    + JDK-8255781: Bump patch update version for OpenJDK:
    jdk-11.0.9.1
    + JDK-8255937: Better cleanup for
    test/jdk/javax/imageio/stream/StreamFlush.java
    + JDK-8256427: Test com/sun/jndi/dns/ConfigTests/
    /PortUnreachable.java does not work on AIX
    + JDK-8256452: Integrate missing part of JDK-8232370 to 11u
    + JDK-8256483: [TESTBUG] serviceability/jvmti/GetClassMethods/
    /libOverpassMethods.c fails to compile on gcc 4.4.x
    + JDK-8256557: libharfbuzz fails to link on gcc 4.4.x due to
  - Wl,-z,defs
    + JDK-8256618: Zero: Linux x86_32 build still fails
    + JDK-8256736: Zero: GTest tests fail with "unsuppported vm
    variant"
    + JDK-8256809: Annotation processing causes NPE during flow
    analysis
    + JDK-8257181: s390x builds are very noisy with gc-sections
    messages
    + JDK-8257242: [macOS] Java app crashes while switching input
    methods
    + JDK-8257545: SunJSSE FIPS regression in key exchange after
    JDK-8171279 11u backport
    + JDK-8257641: Shenandoah: Query is_at_shenandoah_safepoint()
    from control thread should return false
    + JDK-8257701: Shenandoah: objArrayKlass metadata is not marked
    with chunked arrays
    + JDK-8258630: Add expiry exception for QuoVadis root
    certificate
- New upstream dependency on libharfbuzz
- Regenerated patches: missing-return.patch system-pcsclite.patch
* Mon Nov 16 2020 fstrba@suse.com
- Update to upstream tag jdk-11.0.9.1-1
  * Fix:
    + JDK-8250861: Crash in MinINode::Ideal(PhaseGVN*, bool)
- Removed patch:
  * JDK-8250861.patch
    + Integrated upstream
* Wed Nov  4 2020 fstrba@suse.com
- Enable Sheandoah GC for x86_64 (jsc#ECO-3171)
* Mon Nov  2 2020 fstrba@suse.com
- Update to upstream tag jdk-11.0.9-11 (October 2020 CPU,
  bsc#1177943)
  * New features
    + JDK-8250784: Shenandoah: A Low-Pause-Time Garbage Collector
  * Security fixes
    + JDK-8233624: Enhance JNI linkage
    + JDK-8236196: Improve string pooling
    + JDK-8236862, CVE-2020-14779: Enhance support of Proxy class
    + JDK-8237990, CVE-2020-14781: Enhanced LDAP contexts
    + JDK-8237995, CVE-2020-14782: Enhance certificate processing
    + JDK-8240124: Better VM Interning
    + JDK-8241114, CVE-2020-14792: Better range handling
    + JDK-8242680, CVE-2020-14796: Improved URI Support
    + JDK-8242685, CVE-2020-14797: Better Path Validation
    + JDK-8242695, CVE-2020-14798: Enhanced buffer support
    + JDK-8243302: Advanced class supports
    + JDK-8244136, CVE-2020-14803: Improved Buffer supports
    + JDK-8244479: Further constrain certificates
    + JDK-8244955: Additional Fix for JDK-8240124
    + JDK-8245407: Enhance zoning of times
    + JDK-8245412: Better class definitions
    + JDK-8245417: Improve certificate chain handling
    + JDK-8248574: Improve jpeg processing
    + JDK-8249927: Specify limits of jdk.serialProxyInterfaceLimit
    + JDK-8253019: Enhanced JPEG decoding
  * Other changes
    + JDK-6532025: GIF reader throws misleading exception with
    truncated images
    + JDK-6949753: [TEST BUG]: java/awt/print/PageFormat/
    /PDialogTest.java needs update by removing an infinite loop
    + JDK-8022535: [TEST BUG] javax/swing/text/html/parser/
    /Test8017492.java fails
    + JDK-8062947: Fix exception message to correctly represent
    LDAP connection failure
    + JDK-8067354: com/sun/jdi/GetLocalVariables4Test.sh failed
    + JDK-8134599: TEST_BUG: java/rmi/transport/closeServerSocket/
    /CloseServerSocket.java fails intermittently with Address
    already in use
    + JDK-8151678: com/sun/jndi/ldap/LdapTimeoutTest.java failed
    due to timeout on DeadServerNoTimeoutTest is incorrect
    + JDK-8160768: Add capability to custom resolve host/domain
    names within the default JNDI LDAP provider
    + JDK-8172404: Tools should warn if weak algorithms are used
    before restricting them
    + JDK-8193367: Annotated type variable bounds crash javac
    + JDK-8202117: com/sun/jndi/ldap/RemoveNamingListenerTest.java
    fails intermittently: Connection reset
    + JDK-8203026: java.rmi.NoSuchObjectException: no such object
    in table
    + JDK-8203281: [Windows] JComboBox change in ui when
    editor.setBorder() is called
    + JDK-8203382: Rename SystemDictionary::initialize_wk_klass to
    resolve_wk_klass
    + JDK-8203393: com/sun/jdi/JdbMethodExitTest.sh and
    JdbExprTest.sh fail due to timeout
    + JDK-8203928: [Test] Convert non-JDB scaffolding
    serviceability shell script tests to java
    + JDK-8204963: javax.swing.border.TitledBorder has a memory leak
    + JDK-8204994: SA might fail to attach to process with "Windbg
    Error: WaitForEvent failed"
    + JDK-8205534: Remove SymbolTable dependency from
    serviceability agent
    + JDK-8206309: Tier1 SA tests fail
    + JDK-8208281: java/nio/channels/
    /AsynchronousSocketChannel/Basic.java timed out
    + JDK-8209109: [TEST] rewrite com/sun/jdi shell tests to java
    version - step1
    + JDK-8209332: [TEST] test/jdk/com/sun/jdi/CatchPatternTest.sh
    is incorrect
    + JDK-8209342: Problemlist SA tests on Solaris due to Error
    attaching to process: Can't create thread_db agent!
    + JDK-8209343: Test javax/swing/border/TestTitledBorderLeak.java
    should be marked as headful
    + JDK-8209517: com/sun/jdi/BreakpointWithFullGC.java fails with
    timeout
    + JDK-8209604: [TEST] rewrite com/sun/jdi shell tests to java
    version - step2
    + JDK-8209605: com/sun/jdi/BreakpointWithFullGC.java fails with
    ZGC
    + JDK-8209608: Problem list com/sun/jdi/BreakpointWithFullGC.java
    + JDK-8210131: vmTestbase/nsk/jvmti/scenarios/allocation/AP10/
    /ap10t001/TestDescription.java failed with ObjectFree:
    GetCurrentThreadCpuTimerInfo returned unexpected error code
    + JDK-8210243: [TEST] rewrite com/sun/jdi shell tests to java
    version - step3
    + JDK-8210527: JShell: NullPointerException in
    jdk.jshell.Eval.translateExceptionStack
    + JDK-8210560: [TEST] convert com/sun/jdi redefineClass-related
    tests
    + JDK-8210725: com/sun/jdi/RedefineClearBreakpoint.java fails
    with waitForPrompt timed out after 60 seconds
    + JDK-8210748: [TESTBUG] lib.jdb.Jdb.waitForPrompt() should
    clarify which output is the pending reply after a timeout
    + JDK-8210760: [TEST] rewrite com/sun/jdi shell tests to java
    version - step4
    + JDK-8210977: jdk/jfr/event/oldobject/TestThreadLocalLeak.java
    fails to find ThreadLocalObject
    + JDK-8211292: [TEST] convert com/sun/jdi/DeferredStepTest.sh
    test
    + JDK-8211694: JShell: Redeclared variable should be reset
    + JDK-8212200: assert when shared java.lang.Object is redefined
    by JVMTI agent
    + JDK-8212629: [TEST] wrong breakpoint in
    test/jdk/com/sun/jdi/DeferredStepTest
    + JDK-8212665: com/sun/jdi/DeferredStepTest.java: jj1 (line 57)
  - unexpected. lastLine=52, minLine=52, maxLine=55
    + JDK-8212807: tools/jar/multiRelease/Basic.java times out
    + JDK-8213182: Minimal VM build failure after JDK-8212200
    (assert when shared java.lang.Object is redefined by JVMTI
    agent)
    + JDK-8213214: Set -Djava.io.tmpdir= when running tests
    + JDK-8213275: ReplaceCriticalClasses.java fails with
    jdk.internal.vm.PostVMInitHook not found
    + JDK-8213574: Deadlock in string table expansion when dumping
    lots of CDS classes
    + JDK-8213703: LambdaConversionException: Invalid receiver type
    not a subtype of implementation type interface
    + JDK-8214074: Ghash optimization using AVX instructions
    + JDK-8214491: Upgrade to JLine 3.9.0
    + JDK-8214797: TestJmapCoreMetaspace.java timed out
    + JDK-8215243: JShell tests failing intermitently with
    "Problem cleaning up the following threads:"
    + JDK-8215244: jdk/jshell/ToolBasicTest.java
    testHistoryReference failed
    + JDK-8215354: x86_32 build failures after JDK-8214074 (Ghash
    optimization using AVX instructions)
    + JDK-8215438: jshell tool: Ctrl-D causes EOF
    + JDK-8216021: RunTest.gmk might set concurrency level to 1 on
    Windows
    + JDK-8216974: HttpConnection not returned to the pool after
    204 response
    + JDK-8218948: SimpleDateFormat :: format - Zone Names are not
    reflected correctly during run time
    + JDK-8219712: code_size2 (defined in stub_routines_x86.hpp) is
    too small on new Skylake CPUs
    + JDK-8220150: macos10.14 Mojave returns anti-aliased glyphs
    instead of aliased B&W glyphs
    + JDK-8221658: aarch64: add necessary predicate for ubfx
    patterns
    + JDK-8221759: Crash when completing "java.io.File.path"
    + JDK-8221918: runtime/SharedArchiveFile/serviceability/
    /ReplaceCriticalClasses.java fails: Shared archive not found
    + JDK-8222074: Enhance auto vectorization for x86
    + JDK-8222079: Don't use memset to initialize fields decode_env
    constructor in disassembler.cpp
    + JDK-8222769: [TESTBUG] TestJFRNetworkEvents should not rely
    on hostname command
    + JDK-8223688: JShell: crash on the instantiation of raw
    anonymous class
    + JDK-8223777: In posix_spawn mode, failing to exec()
    jspawnhelper does not result in an error
    + JDK-8223940: Private key not supported by chosen signature
    algorithm
    + JDK-8224184: jshell got IOException at exiting with AIX
    + JDK-8224234: compiler/codegen/TestCharVect2.java fails in
    test_mulc
    + JDK-8225037: java.net.JarURLConnection::getJarEntry() throws
    NullPointerException
    + JDK-8225625: AES Electronic Codebook (ECB) encryption and
    decryption optimization using AVX512 + VAES instructions
    + JDK-8226536: Catch OOM from deopt that fails rematerializing
    objects
    + JDK-8226575: OperatingSystemMXBean should be made container
    aware
    + JDK-8226697: Several tests which need the @key headful
    keyword are missing it.
    + JDK-8226809: Circular reference in printed stack trace is not
    correctly indented & ambiguous
    + JDK-8227059: sun/security/tools/keytool/
    /DefaultSignatureAlgorithm.java timed out
    + JDK-8227269: Slow class loading when running with JDWP
    + JDK-8227595: keytool/fakegen/DefaultSignatureAlgorithm.java
    fails due to "exitValue = 6"
    + JDK-8228448: Jconsole can't connect to itself
    + JDK-8228967: Trust/Key store and SSL context utilities for
    tests
    + JDK-8229378: jdwp library loader in linker_md.c quietly
    truncates on buffer overflow
    + JDK-8229815: Upgrade Jline to 3.12.1
    + JDK-8230000: some httpclients testng tests run zero test
    + JDK-8230002: javax/xml/jaxp/unittest/transform/
    /SecureProcessingTest.java runs zero test
    + JDK-8230010: Remove jdk8037819/BasicTest1.java
    + JDK-8230094: CCE in createXMLEventWriter(Result) over an
    arbitrary XMLStreamWriter
    + JDK-8230402: Allocation of compile task fails with assert:
    "Leaking compilation tasks?"
    + JDK-8230767: FlightRecorderListener returns null recording
    + JDK-8230870: (zipfs) Add a ZIP FS test that is similar to
    test/jdk/java/util/zip/EntryCount64k.java
    + JDK-8231209: [REDO] ThreadMXBean::getThreadAllocatedBytes()
    can be quicker for self thread
    + JDK-8231586: enlarge encoding space for OopMapValue offsets
    + JDK-8231953: Wrong assumption in assertion in
    oop::register_oop
    + JDK-8231968: getCurrentThreadAllocatedBytes default
    implementation s/b getThreadAllocatedBytes
    + JDK-8232083: Minimal VM is broken after JDK-8231586
    + JDK-8232161: Align some one-way conversion in MS950 charset
    with Windows
    + JDK-8232855: jshell missing word in /help help
    + JDK-8233027: OopMapSet::all_do does oms.next() twice during
    iteration
    + JDK-8233228: Disable weak named curves by default in TLS,
    CertPath, and Signed JAR
    + JDK-8233386: Initialize NULL fields for unused decorations
    + JDK-8233452: java.math.BigDecimal.sqrt() with
    RoundingMode.FLOOR results in incorrect result
    + JDK-8233686: XML transformer uses excessive amount of memory
    + JDK-8233741: AES Countermode (AES-CTR) optimization using
    AVX512 + VAES instructions
    + JDK-8233829: javac cannot find non-ASCII module name under
    non-UTF8 environment
    + JDK-8233958: Memory retention due to HttpsURLConnection
    finalizer that serves no purpose
    + JDK-8234011: (zipfs) Memory leak in
    ZipFileSystem.releaseDeflater()
    + JDK-8234058: runtime/CompressedOops/
    /CompressedClassPointers.java fails with 'Narrow klass base:
    0x0000000000000000' missing from stdout/stderr
    + JDK-8234149: Several regression tests do not dispose Frame at
    end
    + JDK-8234347: "Turkey" meta time zone does not generate
    composed localized names
    + JDK-8234385: [TESTBUG] java/awt/EventQueue/6980209/
    /bug6980209.java fails in linux nightly
    + JDK-8234535: Cross compilation fails due to missing CFLAGS
    for the BUILD_CC
    + JDK-8234541: C1 emits an empty message when it inlines
    successfully
    + JDK-8234687: change javap reporting on unknown attributes
    + JDK-8236464: SO_LINGER option is ignored by SSLSocket in JDK
    11
    + JDK-8236548: Localized time zone name inconsistency between
    English and other locales
    + JDK-8236617: jtreg test containers/docker/
    /TestMemoryAwareness.java fails after 8226575
    + JDK-8237182: Update copyright header for shenandoah and
    epsilon files
    + JDK-8237888: security/infra/java/security/cert/
    /CertPathValidator/certification/LuxTrustCA.java fails when
    checking validity interval
    + JDK-8237977: Further update
    javax/net/ssl/compatibility/Compatibility.java
    + JDK-8238270: java.net HTTP/2 client does not decrease stream
    count when receives 204 response
    + JDK-8238284: [macos] Zero VM build fails due to an obvious
    typo
    + JDK-8238380: java.base/unix/native/libjava/childproc.c
    "multiple definition" link errors with GCC10
    + JDK-8238386: (sctp) jdk.sctp/unix/native/libsctp/SctpNet.c
    "multiple definition" link errors with GCC10
    + JDK-8238388: libj2gss/NativeFunc.o "multiple definition" link
    errors with GCC10
    + JDK-8238448: RSASSA-PSS signature verification fail when
    using certain odd key sizes
    + JDK-8238710: LingeredApp doesn't log stdout/stderr if exits
    with non-zero code
    + JDK-8239083: C1 assert(known_holder == NULL ||
    (known_holder->is_instance_klass() &&
    (!known_holder->is_interface() ||
    ((ciInstanceKlass*)known_holder)->has_nonstatic_concrete_methods())),
    "should be non-static concrete method");
    + JDK-8239385: KerberosTicket client name refers wrongly to
    sAMAccountName in AD
    + JDK-8240169: javadoc fails to link to non-modular api docs
    + JDK-8240295: hs_err elapsed time in seconds is not accurate
    enough
    + JDK-8240360: NativeLibraryEvent has wrong library name on
    Linux
    + JDK-8240676: Meet not symmetric failure when running lucene
    on jdk8
    + JDK-8241007: Shenandoah: remove
    ShenandoahCriticalControlThreadPriority support
    + JDK-8241065: Shenandoah: remove leftover code after
    JDK-8231086
    + JDK-8241086: Test runtime/NMT/HugeArenaTracking.java is
    failing on 32bit Windows
    + JDK-8241130: com.sun.jndi.ldap.EventSupport.removeDeadNotifier:
    java.lang.NullPointerException
    + JDK-8241138: http.nonProxyHosts=* causes
    StringIndexOutOfBoundsException in DefaultProxySelector
    + JDK-8241319: WB_GetCodeBlob doesn't have ResourceMark
    + JDK-8241478: vmTestbase/gc/gctests/Steal/steal001/steal001.java
    fails with OOME
    + JDK-8241574: Shenandoah: remove ShenandoahAssertToSpaceClosure
    + JDK-8241750: x86_32 build failure after JDK-8227269
    + JDK-8242184: CRL generation error with RSASSA-PSS
    + JDK-8242283: Can't start JVM when java home path includes
    non-ASCII character
    + JDK-8242556: Cannot load RSASSA-PSS public key with non-null
    params from byte array
    + JDK-8243029: Rewrite javax/net/ssl/compatibility/
    /Compatibility.java with a flexible interop test framework
    + JDK-8243138: Enhance BaseLdapServer to support starttls
    extended request
    + JDK-8243320: Add SSL root certificates to Oracle Root CA
    program
    + JDK-8243321: Add Entrust root CA - G4 to Oracle Root CA
    program
    + JDK-8243389: enhance os::pd_print_cpu_info on linux
    + JDK-8243453: java --describe-module failed with non-ASCII
    module name under non-UTF8 environment
    + JDK-8243470: [macos] bring back O2 opt level for unsafe.cpp
    + JDK-8243489: Thread CPU Load event may contain wrong data for
    CPU time under certain conditions
    + JDK-8243925: Toolkit#getScreenInsets() returns wrong value on
    HiDPI screens (Windows)
    + JDK-8244087: 2020-04-24 public suffix list update
    + JDK-8244151: Update MUSCLE PC/SC-Lite headers to the latest
    release 1.8.26
    + JDK-8244164: AArch64: jaotc generates incorrect code for
    compressed OOPs with non-zero heap base
    + JDK-8244196: adjust output in os_linux
    + JDK-8244225: stringop-overflow warning on strncpy call from
    compile_the_world_in
    + JDK-8244287: JFR: Methods samples have line number 0
    + JDK-8244703: "platform encoding not initialized" exceptions
    with debugger, JNI
    + JDK-8244719: CTW: C2 compilation fails with
    "assert(!VerifyHashTableKeys || _hash_lock == 0) failed:
    remove node from hash table before modifying it"
    + JDK-8244729: Shenandoah: remove resolve paths from
    SBSA::generate_shenandoah_lrb
    + JDK-8244763: Update --release 8 symbol information after JSR
    337 MR3
    + JDK-8244818: Java2D Queue Flusher crash while moving
    application window to external monitor
    + JDK-8245151: jarsigner should not raise duplicate warnings on
    verification
    + JDK-8245616: Bump update version for OpenJDK: jdk-11.0.9
    + JDK-8245714: "Bad graph detected in build_loop_late" when
    loads are pinned on loop limit check uncommon branch
    + JDK-8245801: StressRecompilation triggers assert "redundunt
    OSR recompilation detected. memory leak in CodeCache!"
    + JDK-8245832: JDK build make-static-libs should build all JDK
    libraries
    + JDK-8245880: Shenandoah: check class unloading flag early in
    concurrent code root scan
    + JDK-8245981: Upgrade to jQuery 3.5.1
    + JDK-8246027: Minimal fastdebug build broken after JDK-8245801
    + JDK-8246094: [macos] Sound Recording and playback is not
    working
    + JDK-8246153: TestEliminateArrayCopy fails with
  - XX:+StressReflectiveCode
    + JDK-8246193: Possible NPE in ENC-PA-REP search in AS-REQ
    + JDK-8246196: javax/management/MBeanServer/OldMBeanServerTest
    fails with AssertionError
    + JDK-8246203: Segmentation fault in verification due to stack
    overflow with -XX:+VerifyIterativeGVN
    + JDK-8246330: Add TLS Tests for Legacy ECDSA curves
    + JDK-8246453: TestClone crashes with "all collected exceptions
    must come from the same place"
    + JDK-8247246: Add explicit ResolvedJavaType.link and expose
    presence of default methods
    + JDK-8247350: [aarch64] assert(false) failed: wrong size of
    mach node
    + JDK-8247502: PhaseStringOpts crashes while optimising
    effectively dead code
    + JDK-8247615: Initialize the bytes left for the heap sampler
    + JDK-8247824: CTW: C2 (Shenandoah) compilation fails with SEGV
    in SBC2Support::pin_and_expand
    + JDK-8247874: Replacement in VersionProps.java.template not
    working when --with-vendor-bug-url contains '&'
    + JDK-8247979: aarch64: missing side effect of killing flags
    for clearArray_reg_reg
    + JDK-8248214: Add paddings for TaskQueueSuper to reduce
    false-sharing cache contention
    + JDK-8248219: aarch64: missing memory barrier in
    fast_storefield and fast_accessfield
    + JDK-8248348: Regression caused by the update to BCEL 6.0
    + JDK-8248385: [testbug][11u] Adapt TestInitiExceptions to
    jtreg 5.1
    + JDK-8248495: [macos] zerovm is broken due to libffi headers
    location
    + JDK-8248851: CMS: Missing memory fences between free chunk
    check and klass read
    + JDK-8248987: AOT's Linker.java seems to eagerly fail-fast on
    Windows
    + JDK-8249159: Downport test rework for SSLSocketTemplate from
    8224650
    + JDK-8249215: JFrame::setVisible crashed with
  - Dfile.encoding=UTF-8 on Japanese Windows.
    + JDK-8249251: [dark_mode ubuntu 20.04] The selected menu is
    not highlighted in GTKLookAndFeel
    + JDK-8249255: Build fails if source code in cygwin home dir
    + JDK-8249277: TestVerifyIterativeGVN.java is failing with
    timeout in OpenJDK 11
    + JDK-8249278: Revert JDK-8226253 which breaks the spec of
    AccessibleState.SHOWING for JList
    + JDK-8249560: Shenandoah: Fix racy GC request handling
    + JDK-8249801: Shenandoah: Clear soft-refs on requested GC cycle
    + JDK-8249953: Shenandoah: gc/shenandoah/mxbeans tests should
    account for corner cases
    + JDK-8250582: Revert Principal Name type to NT-UNKNOWN when
    requesting TGS Kerberos tickets
    + JDK-8250609: C2 crash in IfNode::fold_compares
    + JDK-8250627: Use -XX:+/-UseContainerSupport for
    enabling/disabling Java container metrics
    + JDK-8250755: Better cleanup for
    jdk/test/javax/imageio/plugins/shared/CanWriteSequence.java
    + JDK-8250787: Provider.put no longer registering aliases in
    FIPS env
    + JDK-8250826: jhsdb does not work with coredump which comes
    from Substrate VM
    + JDK-8250827: Shenandoah: needs to reset/finish StringTable's
    dead count before/after parallel walk
    + JDK-8250844: Make sure {type,obj}ArrayOopDesc accessors check
    the bounds
    + JDK-8251117: Cannot check P11Key size in P11Cipher and
    P11AEADCipher
    + JDK-8251354: Shenandoah: Fix jdk/jfr/tool/TestPrintJSON.java
    test failure
    + JDK-8251451: Shenandoah: Remark ObjectSynchronizer roots with
    I-U
    + JDK-8251469: Better cleanup for
    test/jdk/javax/imageio/SetOutput.java
    + JDK-8251487: Shenandoah: missing detail timing tracking for
    final mark cleaning phase
    + JDK-8252120: compiler/oracle/TestCompileCommand.java
    misspells "occured"
    + JDK-8252157: JDK-8231209 11u backport breaks jmm binary
    compatibility
    + JDK-8252258: [11u] JDK-8242154 changes the default vendor
    + JDK-8252804: [test] Fix 'ReleaseDeflater.java' test after
    downport of 8234011
    + JDK-8253134: JMM_VERSION should remain at 0x20020000 (JDK 10)
    in JDK 11
    + JDK-8253283: [11u] Test build/translations/
    /VerifyTranslations.java failing after JDK-8252258
    + JDK-8253813: Backout JDK-8244287 from 11u: it causes several
    crashes
- Removed patch:
  * gcc-fno-common-fix.patch
    + not needed any more with this version
- Added patch:
  * JDK-8250861.patch
    + Fix regression "8250861: Crash in MinINode::Ideal(PhaseGVN*,
    bool)" introduced in jdk 11.0.9
* Thu Jul 16 2020 fstrba@suse.com
- Update to upstream tag jdk-11.0.8+10 (July 2020 CPU, bsc#1174157)
  * Security fixes:
    + JDK-8230613: Better ASCII conversions
    + JDK-8231800: Better listing of arrays
    + JDK-8232014: Expand DTD support
    + JDK-8233234: Better Zip Naming
    + JDK-8233239, CVE-2020-14562: Enhance TIFF support
    + JDK-8233255: Better Swing Buttons
    + JDK-8234032: Improve basic calendar services
    + JDK-8234042: Better factory production of certificates
    + JDK-8234418: Better parsing with CertificateFactory
    + JDK-8234836: Improve serialization handling
    + JDK-8236191: Enhance OID processing
    + JDK-8236867, CVE-2020-14573: Enhance Graal interface handling
    + JDK-8237117, CVE-2020-14556: Better ForkJoinPool behavior
    + JDK-8237592, CVE-2020-14577: Enhance certificate verification
    + JDK-8238002, CVE-2020-14581: Better matrix operations
    + JDK-8238013: Enhance String writing
    + JDK-8238804: Enhance key handling process
    + JDK-8238842: AIOOBE in GIFImageReader.initializeStringTable
    + JDK-8238843: Enhanced font handing
    + JDK-8238920, CVE-2020-14583: Better Buffer support
    + JDK-8238925: Enhance WAV file playback
    + JDK-8240119, CVE-2020-14593: Less Affine Transformations
    + JDK-8240482: Improved WAV file playback
    + JDK-8241379: Update JCEKS support
    + JDK-8241522: Manifest improved jar headers redux
    + JDK-8242136, CVE-2020-14621: Better XML namespace handling
  * Other changes:
    + JDK-6933331: (d3d/ogl) java.lang.IllegalStateException:
    Buffers have not been created
    + JDK-7124307: JSpinner and changing value by mouse
    + JDK-8022574: remove HaltNode code after uncommon trap calls
    + JDK-8039082: [TEST_BUG] Test
    java/awt/dnd/BadSerializationTest/BadSerializationTest.java
    fails
    + JDK-8040630: Popup menus and tooltips flicker with previous
    popup contents when first shown
    + JDK-8044365: (dc) MulticastSendReceiveTests.java failing with
    ENOMEM when joining group (OS X 10.9)
    + JDK-8048215: [TESTBUG]
    java/lang/management/ManagementFactory/ThreadMXBeanProxy.java
    Expected non-null LockInfo
    + JDK-8051349: nsk/jvmti/scenarios/sampling/SP06/sp06t003 fails
    in nightly
    + JDK-8080353: JShell: Better error message on attempting to
    add default method
    + JDK-8139876: Exclude hanging nsk/stress/stack from execution
    with deoptimization enabled
    + JDK-8146090: java/lang/ref/ReachabilityFenceTest.java fails
    with -XX:+DeoptimizeALot
    + JDK-8153430: jdk regression test MletParserLocaleTest,
    ParserInfiniteLoopTest reduce default timeout
    + JDK-8156207: Resource allocated BitMaps are often cleared
    unnecessarily
    + JDK-8159740: JShell: corralled declarations do not have
    correct source to wrapper mapping
    + JDK-8175984: ICC_Profile has un-needed, not-empty finalize
    method
    + JDK-8176359: Frame#setMaximizedbounds not working properly in
    multi screen environments
    + JDK-8183369: RFC unconformity of HttpURLConnection with proxy
    + JDK-8187078: -XX:+VerifyOops finds numerous problems when
    running JPRT
    + JDK-8189861: Refactor CacheFind
    + JDK-8191169: java/net/Authenticator/B4769350.java failed
    intermittently
    + JDK-8191930: [Graal] emits unparseable XML into compile log
    + JDK-8193879: Java debugger hangs on method invocation
    + JDK-8196019: java/awt/Window/Grab/GrabTest.java fails on
    Windows
    + JDK-8196181: sun/java2d/GdiRendering/InsetClipping.java fails
    + JDK-8198000:
    java/awt/List/EmptyListEventTest/EmptyListEventTest.java
    debug assert on Windows
    + JDK-8198001: java/awt/Menu/WrongParentAfterRemoveMenu/
    /WrongParentAfterRemoveMenu.java debug assert on Windows
    + JDK-8198339: Test javax/swing/border/Test6981576.java is
    unstable
    + JDK-8200701: jdk/jshell/ExceptionsTest.java fails on Windows,
    after JDK-8198801
    + JDK-8203264: JNI exception pending in
    PlainDatagramSocketImpl.c:740
    + JDK-8203672: JNI exception pending in PlainSocketImpl.c
    + JDK-8203673: JNI exception pending in
    DualStackPlainDatagramSocketImpl.c:398
    + JDK-8204834: Fix confusing "allocate" naming in OopStorage
    + JDK-8205399: Set node color on pinned HashMap.TreeNode
    deletion
    + JDK-8205653: test/jdk/sun/management/jmxremote/bootstrap/
    /RmiRegistrySslTest.java and RmiSslBootstrapTest.sh fail with
    handshake_failure
    + JDK-8206179: com/sun/management/OperatingSystemMXBean/
    /GetCommittedVirtualMemorySize.java fails with Committed
    virtual memory size illegal value
    + JDK-8207334: VM times out in VM_HandshakeAllThreads::doit()
    with RunThese30M
    + JDK-8208277: Code cache heap (-XX:ReservedCodeCacheSize)
    doesn't work with 1GB LargePages
    + JDK-8209113: Use WeakReference for lastFontStrike for created
    Fonts
    + JDK-8209333: Socket reset issue for TLS 1.3 socket close
    + JDK-8209439: C2 library_call can potentially ignore Math.pow
    intrinsic or use null pointer
    + JDK-8209534: [TESTBUG]runtime/appcds/cacheObject/
    /ArchivedModuleCompareTest.java fails with EnableJVMCI.
    + JDK-8210147: adjust some WSAGetLastError usages in windows
    network coding
    + JDK-8210284: "assert((av & 0x00000001) == 0) failed:
    unsupported V8" on Solaris 11.4
    + JDK-8210303: VM_HandshakeAllThreads fails assert with
    "failed: blocked and not walkable"
    + JDK-8210459: Add support for generating compile_commands.json
    + JDK-8210515: [TESTBUG]CheckArchivedModuleApp.java needs to
    check if EnableJVMCI is set.
    + JDK-8210788: Javadoc for Thread.join(long, int) should
    specify that it waits forever when both arguments are zero
    + JDK-8211301: [macos] support full window content options
    + JDK-8211332: Space for stub routines (code_size2) is too
    small on new Skylake CPUs
    + JDK-8211339: NPE during SSL handshake caused by
    HostnameChecker
    + JDK-8211392: compiler/profiling/
    /spectrapredefineclass_classloaders/Launcher.java times out
    in JDK12 CI
    + JDK-8211743: [AOT] crash in ScopeDesc::decode_body() when
    JVMTI walks AOT frames
    + JDK-8212154: [TESTBUG] CheckArchivedModuleApp fails with NPE
    when JVMCI is absent
    + JDK-8212167: JShell : Stack trace of exception has wrong line
    number
    + JDK-8212933: Thread-SMR: requesting a VM operation whilst
    holding a ThreadsListHandle can cause deadlocks
    + JDK-8212986: Make Visual Studio compiler check less strict
    + JDK-8213250: CDS archive creation aborts due to metaspace
    object allocation failure
    + JDK-8213516: jck test api/javax_accessibility/AccessibleState/
    /fields.html fails intermittent
    + JDK-8213947: ARM32: failed check_simd should set
    UsePopCountInstruction to false
    + JDK-8214418: half-closed SSLEngine status may cause
    application dead loop
    + JDK-8214440: ldap over a TLS connection negotiate failed with
    "javax.net.ssl.SSLPeerUnverifiedException: hostname of the
    server does not match the hostname in the server's
    certificate"
    + JDK-8214444: Wrong strncat limits in dfa.cpp
    + JDK-8214481: freetype path does not disable TrueType hinting
    with AA+FM hints
    + JDK-8214571: -Xdoclint of array serialField gives "error:
    array type not allowed here"
    + JDK-8214856: Errors with JSZip in web console after upgrade
    to 3.1.5
    + JDK-8214862: assert(proj != __null) at compile.cpp:3251
    + JDK-8215369: Jcstress pollute /var/tmp with temporary files.
    + JDK-8215551: Missing case label in nmethod::reloc_string_for()
    + JDK-8215555: TieredCompilation C2 threads can excessively
    block handshakes
    + JDK-8215711: Missing key_share extension for (EC)DHE key
    exchange should alert missing_extension
    + JDK-8216151: [Graal] Module
    jdk.internal.vm.compiler.management has not been granted
    accessClassInPackage.org.graalvm.compiler.debug
    + JDK-8216154: C4819 warnings at HotSpot sources on Windows
    + JDK-8216541: CompiledICHolders of VM locked unloaded nmethods
    are released too late
    + JDK-8217230: assert(t == t_no_spec) failure in
    NodeHash::check_no_speculative_types()
    + JDK-8217404: --with-jvm-features doesn't work when multiple
    features are explicitly disabled
    + JDK-8217447: Develop flag TraceICs is broken
    + JDK-8217606: LdapContext#reconnect always opens a new
    connection
    + JDK-8218807: Compilation database (compile_commands.json) may
    contain obsolete items
    + JDK-8219214: Infinite Loop in CodeSection::dump()
    + JDK-8219904: ClassCastException when calling
    FlightRecorderMXBean#getRecordings()
    + JDK-8219991: New fix of the deadlock in
    sun.security.ssl.SSLSocketImpl
    + JDK-8221121: applications/microbenchmarks are encountering
    crashes in tier5
    + JDK-8221445: FastSysexMessage constructor crashes MIDI
    receiption thread
    + JDK-8221482: Initialize VMRegImpl::regName[] earlier to
    prevent assert during PrintStubCode
    + JDK-8221741: ClassCastException can happen when
    fontconfig.properties is used
    + JDK-8221823: Requested JDialog width is ignored
    + JDK-8223108: Test java/awt/EventQueue/
    /NonComponentSourcePost.java is unstable
    + JDK-8223678: Add Visual Studio Code workspace generation
    support (for native code)
    + JDK-8223935: PIT: java/awt/font/WindowsIndicFonts.java fails
    on windows10
    + JDK-8224109: Text spaced incorrectly by drawString under
    rotation with fractional metric
    + JDK-8224632: testbug: java/awt/dnd/RemoveDropTargetCrashTest/
    /RemoveDropTargetCrashTest.java fails on MacOS
    + JDK-8224793: os::die() does not honor CreateCoredumpOnCrash
    option
    + JDK-8224847: gc/stress/TestReclaimStringsLeaksMemory.java
    fails with reserved greater than expected
    + JDK-8224931: disable JAOTC invokedynamic support until
    8223533 is fixed
    + JDK-8224997: ChaCha20-Poly1305 TLS cipher suite decryption
    throws ShortBufferException
    + JDK-8225068: Remove DocuSign root certificate that is
    expiring in May 2020
    + JDK-8225069: Remove Comodo root certificate that is expiring
    in May 2020
    + JDK-8225126: Test SetBoundsPaintTest.html faild on Windows
    when desktop is scaled
    + JDK-8225325: Add tests for redefining a class' private method
    during resolution of the bootstrap specifier
    + JDK-8225622: [AOT] runtime/SharedArchiveFile/
    /TestInterpreterMethodEntries.java crashed with AOTed
    java.base
    + JDK-8225653: Provide more information when hitting SIGILL
    from HaltNode
    + JDK-8225783: Incorrect use of binary operators on booleans in
    type.cpp
    + JDK-8225789: Empty method parameter type should generate
    ClassFormatError
    + JDK-8226198: use of & instead of && in
    LibraryCallKit::arraycopy_restore_alloc_state
    + JDK-8226253: JAWS reports wrong number of radio buttons when
    buttons are hidden.
    + JDK-8226653: [accessibility] Can edit text cell correctly,
    but Accessibility Tool reads nothing about editor
    + JDK-8226806: [macOS 10.14] Methods of Java Robot should be
    called from appropriate thread
    + JDK-8226879: Memory leak in Type::hashcons
    + JDK-8227632: Incorrect PrintCompilation message: made not
    compilable on levels 0 1 2 3 4
    + JDK-8228407: JVM crashes with shared archive file mismatch
    + JDK-8228482: fix xlc16/xlclang comparison of distinct pointer
    types and string literal conversion warnings
    + JDK-8228757: Fail fast if the handshake type is unknown
    + JDK-8229158: make UseSwitchProfiling non-experimental or
    false by-default
    + JDK-8229421: The logic of java/net/ipv6tests/TcpTest.java is
    flawed
    + JDK-8229855: C2 fails with assert(false) failed: bad AD file
    + JDK-8230591: AArch64: Missing intrinsics for Math.ceil,
    floor, rint
    + JDK-8231118: ARM32: Math tests failures
    + JDK-8231213: Migrate SimpleDateFormatConstTest to JDK Repo
    + JDK-8231243: [TESTBUG] CustomFont.java cannot find font file
    + JDK-8231438: [macOS] Dark mode for the desktop is not
    supported
    + JDK-8231550: C2: ShouldNotReachHere() in
    verify_strip_mined_scheduling
    + JDK-8231564: setMaximizedBounds is broken with large display
    scale and multiple monitors
    + JDK-8231572: Use -lobjc instead of -fobjc-link-runtime in
    libosxsecurity
    + JDK-8231631: sun/net/ftp/FtpURLConnectionLeak.java fails
    intermittently with NPE
    + JDK-8231671: Fix copyright headers in hotspot (missing comma
    after year)
    + JDK-8231720: Some perf regressions after 8225653
    + JDK-8231779: crash
    HeapWord*ParallelScavengeHeap::failed_mem_allocate
    + JDK-8231863: Crash if classpath is read from @argument file
    and the main gets option argument
    + JDK-8232080: jlink plugins for vendor information and
    run-time options
    + JDK-8232106: [x86] C2: SIGILL due to usage of SSSE3
    instructions on processors which don't support it
    + JDK-8232134: Change to Visual Studio 2017 15.9.16 for
    building on Windows at Oracle
    + JDK-8232226: [macos 10.15] test/jdk/java/awt/color/
    /EqualityTest/EqualityTest.java may fail
    + JDK-8232357: Compare version info of Santuario to legal notice
    + JDK-8232572: Add hooks for custom output dir in Bundles.gmk
    + JDK-8232634: Problem List ICMColorDataTest.java
    + JDK-8232748: Build static versions of certain JDK libraries
    + JDK-8232846: ProcessHandle.Info command with non-English
    shows question marks
    + JDK-8232880: Update test documentation with additional
    settings for client UI tooltip tests
    + JDK-8233033: C2 produces wrong result while unswitching a
    loop due to lost control dependencies
    + JDK-8233137: runtime/ErrorHandling/VeryEarlyAssertTest.java
    fails after 8232080
    + JDK-8233197: Invert JvmtiExport::post_vm_initialized() and
    Jfr:on_vm_start() start-up order for correct option parsing
    + JDK-8233291: [TESTBUG] tools/jlink/plugins/
    /VendorInfoPluginsTest.java fails with debug or non-server VMs
    + JDK-8233364: Fix undefined behavior in
    Canonicalizer::do_ShiftOp
    + JDK-8233494: Avoid calling MallocTracker::record_malloc and
    record_free when NMT is off
    + JDK-8233573: Toolkit.getScreenInsets(GraphicsConfiguration)
    may throw ClassCastException
    + JDK-8233608: Minimal build broken after JDK-8233494
    + JDK-8233621: Mismatch in jsse.enableMFLNExtension property
    name
    + JDK-8233696: [TESTBUG]Some jtreg tests fail when CAPS_LOCK is
    ON
    + JDK-8233707: systemScale.cpp could not compile with VS2019
    + JDK-8233801: GCMEmptyIv.java test fails on Solaris 11.4
    + JDK-8233880: Support compilers with multi-digit major version
    numbers
    + JDK-8233920: MethodHandles::tryFinally generates illegal
    bytecode for long/double return type
    + JDK-8234137: The "AutoTestOnTop.java" test may run external
    applications
    + JDK-8234146: compiler/jsr292/
    /ContinuousCallSiteTargetChange.java times out on SPARC
    + JDK-8234184: [TESTBUG] java/awt/Mouse/EnterExitEvents/
    /ModalDialogEnterExitEventsTest.java fails in Windows
    + JDK-8234270: [REDO] JDK-8204128 NMT might report incorrect
    numbers for Compiler area
    + JDK-8234332: [TESTBUG] java/awt/Focus/DisposedWindow/
    /DisposeDialogNotActivateOwnerTest/
    /DisposeDialogNotActivateOwnerTest.java fails on linux-x64
    nightly
    + JDK-8234398: Replace ID2D1Factory::GetDesktopDpi with
    GetDeviceCaps
    + JDK-8234522: [macos] Crash with use of native file dialog
    + JDK-8234691: Potential double-free in ParallelSPCleanupTask
    constructor
    + JDK-8234696: tools/jlink/plugins/VendorInfoPluginsTest.java
    times out
    + JDK-8234727: sun/security/ssl/X509TrustManagerImpl tests
    support TLSv1.3
    + JDK-8234728: Some security tests should support TLSv1.3
    + JDK-8234779: Provide idiom for declaring classes noncopyable
    + JDK-8234824: java/nio/channels/SocketChannel/AdaptSocket.java
    fails on Windows 10
    + JDK-8234968: check calloc rv in libinstrument
    InvocationAdapter
    + JDK-8235153: [TESTBUG] [macos 10.15] java/awt/Graphics/
    /DrawImageBG/SystemBgColorTest.java fails
    + JDK-8235183: Remove the "HACK CODE" in comment
    + JDK-8235263: Revert TLS 1.3 change that wrapped IOExceptions
    + JDK-8235311: Tag mismatch may alert bad_record_mac
    + JDK-8235332: TestInstanceCloneAsLoadsStores.java fails with
  - XX:+StressGCM
    + JDK-8235452: Strip mined loop verification fails with
    assert(is_OuterStripMinedLoop()) failed: invalid node class
    + JDK-8235584: UseProfiledLoopPredicate fails with
    assert(_phase->get_loop(c) == loop) failed: have to be in the
    same loop
    + JDK-8235620: Broken merge between JDK-8006406 and JDK-8003559
    + JDK-8235638: NPE in LWWindowPeer.getOnscreenGraphics()
    + JDK-8235686: Add more custom hooks in Bundles.gmk
    + JDK-8235739: Rare NPE at WComponentPeer.getGraphics()
    + JDK-8235762: JVM crash in SWPointer during C2 compilation
    + JDK-8235834: IBM-943 charset encoder needs updating
    + JDK-8235874: The ordering of Cipher Suites is not maintained
    provided through jdk.tls.client.cipherSuites and
    jdk.tls.server.cipherSuites system property.
    + JDK-8235908: omit ThreadPriorityPolicy warning when value is
    set from image
    + JDK-8235984: C2: assert(out->in(PhiNode::Region) == head ||
    out->in(PhiNode::Region) == slow_head) failed: phi must be
    either part of the slow or the fast loop
    + JDK-8236211: [Graal] compiler/graalunit/GraphTest.java is
    skipped in all testing
    + JDK-8236470: Deal with ECDSA using ecdsa-with-SHA2 plus hash
    algorithm as AlgorithmId
    + JDK-8236545: Compilation error in mach5
    java/awt/FileDialog/MacOSGoToFolderCrash.java
    + JDK-8236700: Upgrading JSZip from v3.1.5 to v3.2.2
    + JDK-8236759: ShouldNotReachHere in
    PhaseIdealLoop::verify_strip_mined_scheduling
    + JDK-8236897: Fix the copyright header for pkcs11gcm2.h
    + JDK-8236921: Add build target to produce a JDK image suitable
    for a Graal/SVM build
    + JDK-8236953: [macos] JavaFX SwingNode is not rendered on macOS
    + JDK-8236996: Incorrect Roboto font rendering on Windows with
    subpixel antialiasing
    + JDK-8237045: JVM uses excessive memory with -XX:+EnableJVMCI
  - XX:JVMCICounterSize=2147483648
    + JDK-8237055: [TESTBUG] compiler/c2/TestJumpTable.java fails
    with release VMs
    + JDK-8237086: assert(is_MachReturn()) running CTW with fix for
    JDK-8231291
    + JDK-8237192: Generate stripped/public pdbs on Windows for jdk
    images
    + JDK-8237396: JvmtiTagMap::weak_oops_do() should not trigger
    barriers
    + JDK-8237474: Default SSLEngine should create in server role
    + JDK-8237859: C2: Crash when loads float above range check
    + JDK-8237879: make 4.3 breaks build
    + JDK-8237951: CTW: C2 compilation fails with "malformed
    control flow"
    + JDK-8237962: give better error output for invalid OCSP
    response intervals in CertPathValidator checks
    + JDK-8238190: [JVMCI] Fix single implementor speculation for
    diamond shapes.
    + JDK-8238356: CodeHeap::blob_count() overestimates the number
    of blobs
    + JDK-8238452: Keytool generates wrong expiration date if
    validity is set to 2050/01/01
    + JDK-8238555: Allow Initialization of SunPKCS11 with NSS when
    there are external FIPS modules in the NSSDB
    + JDK-8238575: DragSourceEvent.getLocation() returns wrong
    value on HiDPI screens (Windows)
    + JDK-8238676: jni crashes on accessing it from process exit
    hook
    + JDK-8238721: Add failing client jtreg tests to the Problem
    List
    + JDK-8238738: AudioSystem.getMixerInfo() takes about 30 sec to
    report a gone audio device
    + JDK-8238756: C2: assert(((n) == __null || !VerifyIterativeGVN
    || !((n)->is_dead()))) failed: can not use dead node
    + JDK-8238765: PhaseCFG::schedule_pinned_nodes cannot handle
    precedence edges from unmatched CFG nodes correctly
    + JDK-8238898: Missing hash characters for header on license
    file
    + JDK-8238942: Rendering artifacts with LCD text and fractional
    metrics
    + JDK-8238985: [TESTBUG] The arrow image is blue instead of
    green
    + JDK-8239000: handle ContendedPaddingWidth in vm_version_ppc
    + JDK-8239055: Wrong implementation of VMState.hasListener
    + JDK-8239091: Reversed arguments in call to strstr in freetype
    "debug" code.
    + JDK-8239142: C2's UseUniqueSubclasses optimization is broken
    for array accesses
    + JDK-8239224: libproc_impl.c previous_thr may be used
    uninitialized warning
    + JDK-8239351: Give more meaningful InternalError messages in
    Deflater.c
    + JDK-8239365: ProcessBuilder test modifications for AIX
    execution
    + JDK-8239456: vtable stub generation: assert failure (code
    size estimate)
    + JDK-8239457: call ReleaseStringUTFChars before early returns
    in Java_sun_security_pkcs11_wrapper_PKCS11_connect
    + JDK-8239462: jdk.hotspot.agent misses some
    ReleaseStringUTFChars calls in case of early returns
    + JDK-8239557: [TESTBUG] VeryEarlyAssertTest.java validating
    "END." marker at lastline is not always true
    + JDK-8239787: AArch64: String.indexOf may incorrectly handle
    empty strings
    + JDK-8239792: Bump update version for OpenJDK: jdk-11.0.8
    + JDK-8239798: SSLSocket closes socket both socket endpoints on
    a SocketTimeoutException
    + JDK-8239819: XToolkit: Misread of screen information memory
    + JDK-8239852: java/util/concurrent tests fail with
  - XX:+VerifyGraphEdges: assert(!VerifyGraphEdges) failed:
    verification should have failed
    + JDK-8239893: Windows handle Leak when starting processes
    using ProcessBuilder
    + JDK-8239915: Zero VM crashes when handling dynamic constant
    + JDK-8239931: [win][x86] vtable stub generation: assert
    failure (code size estimate) follow-up
    + JDK-8239965: XMLEncoder/Test4625418.java fails due to "Error:
    Cp943 - can't read properly"
    + JDK-8239976: Put JDK-8239965 on the ProblemList.txt
    + JDK-8240073: Fix 'test-make' build target in 11u
    + JDK-8240197: Cannot start JVM when $JAVA_HOME includes CJK
    characters
    + JDK-8240202: A few client tests leave mouse buttons pressed
    + JDK-8240220: IdealLoopTree::dump_head predicate printing is
    broken
    + JDK-8240223: Use consistent predicate order in and with
    PhaseIdealLoop::find_predicate
    + JDK-8240227: Loop predicates should be copied to unswitched
    loops
    + JDK-8240286: [TESTBUG] Test command error in hotspot/jtreg/
    /compiler/loopopts/superword/SumRedAbsNeg_Float.java
    + JDK-8240518: Incorrect JNU_ReleaseStringPlatformChars in
    Windows Print
    + JDK-8240529: CheckUnhandledOops breaks NULL check in
    Modules::define_module
    + JDK-8240576: JVM crashes after transformation in C2
    IdealLoopTree::merge_many_backedges
    + JDK-8240603: Windows 32bit compile error after 8238676
    + JDK-8240629: argfiles parsing broken for argfiles with
    comment cross 4096 bytes chunk
    + JDK-8240711: TestJstatdPort.java failed due to
    "ExportException: Port already in use:"
    + JDK-8240786: [TESTBUG] The test java/awt/Window/
    /GetScreenLocation/GetScreenLocationTest.java fails on HiDPI
    screen
    + JDK-8240824: enhance print_full_memory_info on Linux by THP
    related information
    + JDK-8240827: Downport SSLSocketImpl.java from "8221882: Use
    fiber-friendly java.util.concurrent.locks in JSSE"
    + JDK-8240905: assert(mem == (Node*)1 || mem == mem2) failed:
    multiple Memories being matched at once?
    + JDK-8240972: macOS codesign fail on macOS 10.13.5 or older
    + JDK-8241445: Fix copyright in
    test/jdk/tools/launcher/ArgFileSyntax.java
    + JDK-8241458: [JVMCI] add mark value to expose
    CodeOffsets::Frame_Complete
    + JDK-8241464: [11u] Backport: make rehashing be a needed
    guaranteed safepoint cleanup action
    + JDK-8241556: Memory leak if -XX:CompileCommand is set
    + JDK-8241568: (fs) UserPrincipalLookupService.lookupXXX
    failure with IOE "Operation not permitted"
    + JDK-8241586: compiler/cpuflags/
    /TestAESIntrinsicsOnUnsupportedConfig.java fails on aarch64
    + JDK-8241638: launcher time metrics always report 1 on Linux
    when _JAVA_LAUNCHER_DEBUG set
    + JDK-8241660: Add virtualization information output to hs_err
    file on macOS
    + JDK-8241808: [TESTBUG] The JDK-8039467 bug appeared on macOS
    + JDK-8241888: Mirror jdk.security.allowNonCaAnchor system
    property with a security one
    + JDK-8241900: Loop unswitching may cause dependence on null
    check to be lost
    + JDK-8241948: enhance list of environment variables printed in
    hs_err file
    + JDK-8241996: on linux set full relro in the linker flags
    + JDK-8242108: Performance regression after fix for JDK-8229496
    + JDK-8242141: New System Properties to configure the TLS
    signature schemes
    + JDK-8242154: Backport parts of JDK-4947890 to OpenJDK 11u
    + JDK-8242174: [macos] The NestedModelessDialogTest test make
    the macOS unstable
    + JDK-8242239: [Graal] javax/management/generified/
    /GenericTest.java fails: FAILED: queryMBeans sets same
    + JDK-8242294: JSSE Client does not throw SSLException when an
    alert occurs during handshaking
    + JDK-8242379: [TESTBUG] compiler/loopopts/
    /TestLoopUnswitchingLostCastDependency.java fails with
    release VMs
    + JDK-8242470: Update Xerces to Version 2.12.1
    + JDK-8242498: Invalid "sun.awt.TimedWindowEvent" object leads
    to JVM crash
    + JDK-8242541: Small charset issues (ISO8859-16, x-eucJP-Open,
    x-IBM834 and x-IBM949C)
    + JDK-8242626: enhance posix print_rlimit_info
    + JDK-8243059: Build fails when --with-vendor-name contains a
    comma
    + JDK-8243539: Copyright info (Year) should be updated for fix
    of 8241638
    + JDK-8243541: (tz) Upgrade time-zone data to tzdata2020a
    + JDK-8244407: JVM crashes after transformation in C2
    IdealLoopTree::split_fall_in
    + JDK-8244520: problemlist
    java/awt/font/Rotate/RotatedFontTest.java on linux
    + JDK-8244777: ClassLoaderStats VM Op uses constant hash value
    + JDK-8244853: The static build of libextnet is missing the
    JNI_OnLoad_extnet function
    + JDK-8244951: Missing entitlements for hardened runtime
    + JDK-8245047: [PPC64] C2: ReverseBytes + Load always match to
    unordered Load (acquire semantics missing)
    + JDK-8245649: Revert 8245397 backport of 8230591
    + JDK-8246031: SSLSocket.getSession() doesn't close connection
    for timeout/ interrupts
    + JDK-8246613: Choose the default SecureRandom algo based on
    registration ordering
    + JDK-8248505: Unexpected NoSuchAlgorithmException when using
    secure random impl from BCFIPS provider
- Removed patch:
  * JDK-8228407.patch
    + integrated upstream
* Tue Apr 21 2020 fstrba@suse.com
- Update to upstream tag jdk-11.0.7+10 (April 2020 CPU,
  bsc#1169511)
  * Security fixes:
    + S8223898, CVE-2020-2754: Forward references to Nashorn
    + S8223904, CVE-2020-2755: Improve Nashorn matching
    + S8224541, CVE-2020-2756: Better mapping of serial ENUMs
    + S8224549, CVE-2020-2757: Less Blocking Array Queues
    + S8225603: Enhancement for big integers
    + S8226346: Build better binary builders
    + S8227467: Better class method invocations
    + S8227542: Manifest improved jar headers
    + S8229733: TLS message handling improvements
    + S8231415, CVE-2020-2773: Better signatures in XML
    + S8231785: Improved socket permissions
    + S8232424, CVE-2020-2778: More constrained algorithms
    + S8232581, CVE-2020-2767: Improve TLS verification
    + S8233250: Better X11 rendering
    + S8233410: Better Build Scripting
    + S8234027: Better JCEKS key support
    + S8234408, CVE-2020-2781: Improve TLS session handling
    + S8234825, CVE-2020-2800: Better Headings for HTTP Servers
    + S8234841, CVE-2020-2803: Enhance buffering of byte buffers
    + S8235274, CVE-2020-2805: Enhance typing of methods
    + S8235691, CVE-2020-2816: Enhance TLS connectivity
    + S8236201, CVE-2020-2830: Better Scanner conversions
    + S8238960: linux-i586 builds are inconsistent as the newly
    built jdk is not able to reserve enough space for object heap
  * Other changes:
    + S4919790: Errors in alert ssl message does not reflect the
    actual certificate status
    + S4949105: Access Bridge lacks html tags parsing
    + S7092821: java.security.Provider.getService() is synchronized
    and became scalability bottleneck
    + S7143743: Potential memory leak with zip provider
    + S8005819: Support cross-realm MSSFU
    + S8042383: [TEST_BUG] Test javax/swing/plaf/basic/BasicMenuUI/
    /4983388/bug4983388.java fails with shortcuts on menus do not
    work
    + S8068184: Fix for JDK-8032832 caused a deadlock
    + S8145845: [AOT] NullPointerException in
    compiler/whitebox/GetCodeHeapEntriesTest.java
    + S8152988: [AOT] Update test batch definitions to include
    aot-ed java.base module mode into hs-comp testing
    + S8160926: FLAGS_COMPILER_CHECK_ARGUMENTS doesn't handle
    cross-compilation
    + S8163083: SocketListeningConnector does not allow invocations
    with port 0
    + S8163251: Hard coded loop limit prevents reading of smart
    card data greater than 8k
    + S8167276: jvmci/compilerToVM/MaterializeVirtualObjectTest.java
    fails with -XX:-EliminateAllocations
    + S8169718: nsk/jdb/locals/locals002: ERROR: Cannot find
    boolVar with expected value: false
    + S8176556:
    java/awt/dnd/ImageTransferTest/ImageTransferTest.java fails
    for JFIF
    + S8178798: Two compiler/aot/verification/vmflags tests fail by
    timeout with UseAVX=3
    + S8183107: PKCS11 regression regarding checkKeySize
    + S8185005: Improve performance of
    ThreadMXBean.getThreadInfo(long ids[], int maxDepth)
    + S8189633: Missing -Xcheck:jni checking for DeleteWeakGlobalRef
    + S8189861: Refactor CacheFind
    + S8193042: NativeLookup::lookup_critical_entry() should only
    load shared library once
    + S8193596: java/net/DatagramPacket/ReuseBuf.java failed due to
    timeout
    + S8194944: Regression automated test 'open/test/jdk/javax/
    /swing/JInternalFrame/8145896/TestJInternalFrameMaximize.java'
    fails
    + S8196467: javax/swing/JInternalFrame/Test6325652.java fails
    + S8196969: JTreg Failure: serviceability/sa/ClhsdbJstack.java
    causes NPE
    + S8198321: javax/swing/JEditorPane/5076514/bug5076514.java
    fails
    + S8198398: Test javax/swing/JColorChooser/Test6199676.java
    fails in mach5
    + S8199072: Test javax/swing/GroupLayout/6613904/
    /bug6613904.java is unstable
    + S8200432: javadoc fails with ClassCastException on {@link
    byte[]}
    + S8201349: build broken when configured with
  - -with-zlib=bundled on gcc 7.3
    + S8201355: Avoid native memory allocation in
    sun.security.mscapi.PRNG.generateSeed
    + S8201513: nsk/jvmti/IterateThroughHeap/filter-* are broken
    + S8203364: Some serviceability/sa/ tests intermittently fail
    with java.io.IOException: LingeredApp terminated with non-zero
    exit code 3
    + S8203687: javax/net/ssl/compatibility/Compatibility.java
    supports TLS 1.3
    + S8203904: javax/swing/JSplitPane/4816114/bug4816114.java: The
    divider location is wrong
    + S8203911: Test runtime/modules/getModuleJNI/GetModule fails
    with -Xcheck:jni
    + S8204525: [TESTBUG] runtime/NMT/MallocStressTest.java ran out
    of java heap
    + S8204529: gc/TestAllocateHeapAtMultiple.java fail with Agent
    7 timed out
    + S8204551: Event descriptions are truncated in logs
    + S8206963: [AOT] bug with multiple class loaders
    + S8207367: 10 vmTestbase/nsk/jdi tests timed out when running
    with jtreg
    + S8207832: serviceability/sa/ClhsdbCDSCore.java failed with
    "Couldn't find core file location"
    + S8207938: At step6,Click Add button,case failed automatically.
    + S8208157: requires.VMProps throws NPE for missing properties
    in "release" file
    + S8208379: compiler/jvmci/events/
    /JvmciNotifyInstallEventTest.java failed with "Got unexpected
    event count after 2nd install attempt: expected 9 to equal 2"
    + S8208658: Make CDS archived heap regions usable even if
    compressed oop encoding has changed
    + S8208715: Conversion of milliseconds to nanoseconds in
    UNIXProcess contains bug
    + S8209361: [AOT] Unexpected number of references for
    JVMTI_HEAP_REFERENCE_CONSTANT_POOL [111-->111]: 0 (expected
    at least 1)
    + S8209385: CDS runtime classpath checking is too strict when
    only classes from the system modules are archived
    + S8209389: SIGSEGV in WalkOopAndArchiveClosure::do_oop_work.
    + S8209418: Synchronize test/jdk/sanity/client/lib/jemmy with
    code-tools/jemmy/v2
    + S8209494: Create a test for SwingSet InternalFrameDemo
    + S8209499: Create test for SwingSet EditorPaneDemo
    + S8209574: [AOT] breakpoint events are generated in different
    threads does not meet expected count
    + S8209686: cleanup arguments to PhaseIdealLoop() constructor
    + S8209789: Synchronize test/jdk/sanity/client/lib/jemmy with
    code-tools/jemmy/v2
    + S8209802: Garbage collectors should register JFR types
    themselves to avoid build errors.
    + S8209807: improve handling exception in requires.VMProps
    + S8209817: stack is executable when building with Clang on
    Linux
    + S8209824: Improve the code coverage for ThreadLocal
    + S8209826: Undefined reference to os::write after JDK-8209657
    (filemap.hpp cleanup)
    + S8209850: Allow NamedThreads to use GlobalCounter critical
    sections
    + S8209976: Improve iteration over non-JavaThreads
    + S8209993: Create a test for SwingSet3 ToolTipDemo
    + S8210024: JFR calls virtual is_Java_thread from ~Thread()
    + S8210052: Enable testing for all the available look and feels
    in SwingSet3 demo tests
    + S8210055: Enable different look and feel tests in SwingSet3
    demo tests
    + S8210057: Enable different look and feels in SwingSet3 demo
    test InternalFrameDemoTest
    + S8210058: Algorithmic Italic font leans opposite angle in
    Printing
    + S8210220: [AOT] jdwp test cases are failing with error #
    ERROR: TEST FAILED: Cought IOException while receiving event
    packet
    + S8210289: ArchivedKlassSubGraphInfoRecord is incomplete
    + S8210459: Add support for generating compile_commands.json
    + S8210476: sun/security/mscapi/PrngSlow.java fails with Still
    too slow
    + S8210512: [Testbug] vmTestbase/nsk/jdi/ObjectReference/
    /referringObjects/referringObjects002/referringObjects002.java
    fails with unexpected size of
    ClassLoaderReference.referringObjects
    + S8210523: runtime/appcds/cacheObject/DifferentHeapSizes.java
    crash
    + S8210632: Add key exchange algorithm to
    javax/net/ssl/TLSCommon/CipherSuite.java
    + S8210699: Problem list tests which times out in Xcomp mode
    + S8210793: [JVMCI] AllocateCompileIdTest.java failed to find
    DiagnosticCommand.class
    + S8210910: Create test for FileChooserDemo
    + S8210994: Create test for SwingSet3 FrameDemo
    + S8211139: Increase timeout value in all tests under
    jdk/sanity/client/SwingSet/src
    + S8211160: Handle different look and feels in
    JInternalFrameOperator
    + S8211211: vmTestbase/metaspace/stressDictionary/
    /StressDictionary.java timeout
    + S8211322: Reduce the timeout of tooltip in SwingSet2DemoTest
    + S8211443: Enable different look and feels in SwingSet3 demo
    test SplitPaneDemoTest
    + S8211703: JInternalFrame : java.lang.AssertionError: cannot
    find the internal frame
    + S8211781: re-building fails after changing Graal sources
    + S8212897: Some improvements in the EditorPaneDemotest
    + S8212903: [TestBug] Tests test/jdk/javax/swing/LookAndFeel/
    /8145547/DemandGTK2.sh and DemandGTK3.sh fail on Ubuntu 18.04
    LTS
    + S8213009: Refactoring existing SunMSCAPI classes
    + S8213010: Supporting keys created with certmgr.exe
    + S8213168: Enable different look and feel tests in SwingSet3
    demo test FileChooserDemoTest
    + S8213348: jdk.internal.vm.compiler.management service
    providers missing in module descriptor
    + S8213906: Update arm devkits with libXrandr headers
    + S8213908: AssertionError in DeferredAttr at setOverloadKind
    + S8214124: [TESTBUG] Bugs in runtime/NMT/MallocStressTest.java
    + S8214344: C2: assert(con.basic_type() != T_ILLEGAL) failed:
    elembt=byte; loadbt=void; unsigned=0
    + S8214345: infinite recursion while checking super class
    + S8214471: Enable different look and feel tests in SwingSet3
    demo test ToolTipDemoTest
    + S8214534: Setting of THIS_FILE in the build is broken
    + S8214557: Filter out VM flags which don't affect AOT code
    generation
    + S8214578: [macos] Problem with backslashes on macOS/JIS
    keyboard: Java ignores system settings
    + S8214840: runtime/NMT/MallocStressTest.java timed out
    + S8214850: Rename vm_operations.?pp files to vmOperations.?pp
    files
    + S8214904: Test8004741.java failed due to "Too few ThreadDeath
    hits; expected at least 6 but saw only 5"
    + S8215322: add @file support to jaotc
    + S8215355: Object monitor deadlock with no threads holding the
    monitor (using jemalloc 5.1)
    + S8215396: JTabbedPane preferred size calculation is wrong for
    SCROLL_TAB_LAYOUT
    + S8216180: [AOT] compiler/intrinsics/bigInteger/TestMulAdd.java
    crashed with AOT enabled
    + S8216353: Use utility APIs introduced in org/netbeans/jemmy/
    /util/LookAndFeel class in client sanity test cases
    + S8216354: Syntax error in toolchain_windows.m4
    + S8216472: (se) Stack overflow during selection operation
    leads to crash (win)
    + S8216535: tools/jimage/JImageExtractTest.java timed out
    + S8217235: Create automated test for SwingSet
    ColorChooserDemoTest
    + S8217297: Add support for multiple look and feel for SwingSet
    SliderDemoTest
    + S8217338: [Containers] Improve systemd slice memory limit
    support
    + S8217613: [AOT] TEST_OPTS_AOT_MODULES doesn't work on mac
    + S8217634: RunTest documentation and usability update
    + S8217717: ZGC: Broken oop map in C1 load barrier stub
    + S8217728: Speed up incremental rerun of "make hotspot"
    + S8218268: Javac treats Manifest Class-Path entries as Paths
    instead of URLs
    + S8218662: Allow 204 responses with Content-Length:0
    + S8218882: NET_Writev is declared, NET_WriteV is defined
    + S8218889: Improperly use of the Optional API
    + S8219205: JFR file without license header
    + S8219597: (bf) Heap buffer state changes could provoke
    unexpected exceptions
    + S8219723: javax/net/ssl/compatibility/Compatibility.java
    failed on some SNI cases
    + S8220348: [ntintel] asserts about copying unaligned array
    + S8220451: jdi/EventQueue/remove/remove004 failed due to
    "ERROR: thread2 is not alive"
    + S8220456: jdi/EventQueue/remove_l/remove_l004 failed due to
    "TIMEOUT while waiting for event"
    + S8220479: java/nio/channels/Selector/SelectWithConsumer.java
    failed at testTwoChannels()
    + S8220613: java/util/Arrays/TimSortStackSize2.java times out
    with fastdebug build
    + S8220688: [TESTBUG] runtime/NMT/MallocStressTest.java timed
    out
    + S8220786: Create new switch to redirect error reporting
    output to stdout or stderr
    + S8221270: Duplicated synchronized keywords in SSLSocketImpl
    + S8221312: test/jdk/sanity/client/SwingSet/src/
    /ColorChooserDemoTest.java failed
    + S8221851: Use of THIS_FILE in hotspot invalidates precompiled
    header on Linux/GCC
    + S8221885: Add intermittent test in the JavaSound to the
    ProblemList
    + S8222264: Windows incremental build is broken with JDK-8217728
    + S8222391: javax/net/ssl/compatibility/Compatibility.java
    should be more flexible
    + S8222448: java/lang/reflect/PublicMethods/
    /PublicMethodsTest.java times out
    + S8222519: ButtonDemoScreenshotTest fails randomly with "still
    state to be reached"
    + S8222741: jdi/EventQueue/remove/remove004 fails due to
    VMDisconnectedException
    + S8223003: SunMSCAPI keys are not cleaned up
    + S8223063: Support CNG RSA keys
    + S8223158: Docked MacBook cannot start any Java Swing
    applications
    + S8223260: NamingManager should cache InitialContextFactory
    + S8223464: Improve version string for Oracle CI builds
    + S8223558: Java does not render Myanmar script correctly
    + S8223627: jdk-13+20 bundle name contains null instead of ea
    + S8223638: Replace wildcard address with loopback or local
    host in tests - part 6
    + S8223678: Add Visual Studio Code workspace generation support
    (for native code)
    + S8223727: com/sun/jndi/ldap/privconn/RunTest.java failed due
    to hang in LdapRequest.getReplyBer
    + S8223769: Assert triggers with -XX:+StressReflectiveCode
    + S8224187: Refactor arraycopy_prologue to allow ZGC read
    barriers on arraycopy
    + S8224475: JTextPane does not show images in HTML rendering
    + S8224673: Adjust permission for delayed starting of debugging
    + S8224705: Tests that need to be problem-listed or have
    printer resources
    + S8224778: test/jdk/demo/jfc/J2Ddemo/J2DdemoTest.java cannot
    find J2Ddemo.jar
    + S8224821: java/awt/Focus/NoAutotransferToDisabledCompTest/
    /NoAutotransferToDisabledCompTest.java fails linux-x64
    + S8224830: test/jdk/java/awt/Focus/
    /ModalExcludedWindowClickTest/
    /ModalExcludedWindowClickTest.java fails on linux-x64
    + S8224851: AArch64: fix warnings and errors with Clang and GCC
    8.3
    + S8224905: java/lang/ProcessBuilder/Basic.java#id1 failed with
    stream closed
    + S8225007: java/awt/print/PrinterJob/
    /LandscapeStackOverflow.java may hang
    + S8225105: java/awt/Focus/ShowFrameCheckForegroundTest/
    /ShowFrameCheckForegroundTest.java fails in Windows 10
    + S8225117: java/math/BigInteger/SymmetricRangeTests.java fails
    with ParseException
    + S8225128: Add exception for expiring DocuSign root to
    VerifyCACerts test
    + S8225130: Add exception for expiring Comodo roots to
    VerifyCACerts test
    + S8225144: [macos] In Aqua L&F backspace key does not delete
    when Shift is pressed
    + S8225180: SignedObject with invalid Key not throwing the
    InvalidKeyException in Windows
    + S8225182: JNI exception pending in DestroyXIMCallback of
    awt_InputMethod.c:1327
    + S8225199: [Graal] compiler/jvmci/compilerToVM/
    /IsMatureVsReprofileTest.java fails with
  - XX:CompileThresholdScaling=0.1
    + S8225305: ProblemList java/lang/invoke/VarHandles tests
    + S8225350: compiler/jvmci/compilerToVM/IsCompilableTest.java
    timed out
    + S8225430: Replace wildcard address with loopback or local
    host in tests - part 14
    + S8225435: Upgrade IANA Language Subtag Registry to the latest
    for JDK14
    + S8225487: giflib legal file is missing attribution for
    openbsd-reallocarray.c
    + S8225567: Wrong file headers with 8202414 fix changeset
    + S8225684: [AOT] vmTestbase/vm/oom/production/
    /AlwaysOOMProduction tests fail with AOTed java.base
    + S8225766: Curve in certificate should not affect signature
    scheme when using TLSv1.3
    + S8225797: OldObjectSample event creates unexpected amount of
    checkpoint data
    + S8226381: ProblemList java/lang/reflect/PublicMethods/
    /PublicMethodsTest.java
    + S8226406: JVM fails to detect mismatched or corrupt CDS
    archive
    + S8226608: Hide the onjcmd option from the help output
    + S8226892: ActionListeners on JRadioButtons don't get notified
    when selection is changed with arrow keys
    + S8227112: exclude compiler/intrinsics/sha/sanity tests from
    AOT runs
    + S8227324: Upgrade to freetype 2.10.1
    + S8227528: TestAbortVMOnSafepointTimeout.java failed due to
    "RuntimeException: 'Safepoint sync time longer than' missing
    from stdout/stderr"
    + S8227645: Some tests in serviceability/sa run with fixed -Xmx
    values and risk running out of memory
    + S8227646: [TESTBUG] appcds/SharedArchiveConsistency timed out
    + S8227662: freetype seeks to index at the end of the font data
    + S8228479: Correct the format of ColorChooserDemoTest
    + S8228613: java.security.Provider#getServices order is no
    longer deterministic
    + S8228969: 2019-09-28 public suffix list update
    + S8229236: CriticalJNINatives: dll handling should be done in
    native thread state
    + S8229345: Memory leak due to vtable stubs not being shared on
    SPARC
    + S8229888: (zipfs) Updating an existing zip file does not
    preserve original permissions
    + S8229994: assert(false) failed: Bad graph detected in
    get_early_ctrl_for_expensive
    + S8230004: jdk/internal/jimage/JImageOpenTest.java runs no test
    + S8230235: Rendering HTML with empty img attribute and
    documentBaseKey cause Exception
    + S8230390: Problemlist SA tests with AOT
    + S8230400: Missing constant pool entry for a method in
    stacktrace
    + S8230459: Test failed to resume JVMCI CompilerThread
    + S8230480: check malloc/calloc results in java.desktop
    + S8230597: Update GIFlib library to the 5.2.1
    + S8230611: infinite loop in
    LogOutputList::wait_until_no_readers()
    + S8230624: [TESTBUG] Problemlist JFR
    compiler/TestCodeSweeper.java
    + S8230677: Should disable Escape Analysis if JVMTI capability
    can_get_owned_monitor_info was taken
    + S8230926: [macosx] Two apostrophes are entered instead of one
    with "U.S. International - PC" layout
    + S8231025: Incorrect method tag offset for big endian platform
    + S8231081: TestMetadataRetention fails due to missing symbol id
    + S8231387: java.security.Provider.getService returns random
    result due to race condition with mutating methods in the same
    class
    + S8231430: C2: Memory stomp in max_array_length() for
    T_ILLEGAL type
    + S8231445: check ZALLOC return values in awt coding
    + S8231507: Update Apache Santuario (XML Signature) to version
    2.1.4
    + S8231584: Deadlock with ClassLoader.findLibrary and
    System.loadLibrary call
    + S8231753: use more Posix functionality in aix
    os::print_os_info
    + S8231810: javax/net/ssl/templates/
    /SSLSocketSSLEngineTemplate.java fails intermittently with
    "java.lang.Exception: Unexpected EOF"
    + S8232003: (fs) Files.write can leak file descriptor in the
    exception case
    + S8232056: GetOwnedMonitorInfoWithEATest.java fails with ZGC:
    Heap too small
    + S8232060: add some initializations using sigemptyset in
    os_aix.cpp
    + S8232154: Update Mesa 3-D Headers to version 19.2.1
    + S8232167: Visual Studio install found through
  - -with-tools-dir value is discarded
    + S8232170: FSInfo#getJarClassPath throws an exception not
    declared in its throws clause
    + S8232200: [macos 10.15] Windows in fullscreen tests jumps
    around the screen
    + S8232207: Linux os::available_memory re-reads cgroup
    configuration on every invocation
    + S8232224: [TESTBUG] problemlist JFR TestLargeRootSet.java
    + S8232370: Refactor some com.sun.jdi tests to enable IDE
    integration
    + S8232433: [macos 10.15] java/awt/Window/
    /LocationAtScreenCorner/LocationAtScreenCorner.java may fail
    + S8232571: Add missing SIGINFO signal
    + S8232692: [TESTBUG] compiler/aot/fingerprint/
    /SelfChangedCDS.java fails when cds is disabled
    + S8232713: Update BCEL version to 6.3.1 in license file
    + S8232806: Introduce a system property to disable eager lambda
    initialization
    + S8232834: RunTest sometimes fails to produce valid
    exitcode.txt
    + S8232880: Update test documentation with additional settings
    for client UI tooltip tests
    + S8232950: SUNPKCS11 Provider incorrectly check key length for
    PSS Signatures.
    + S8233018: Add a new test to verify that DatagramSocket is not
    interruptible
    + S8233019: java.lang.Class.isPrimitive() (C1) returns wrong
    result if Klass* is aligned to 32bit
    + S8233032: assert(in_bb(n)) failed: must be
    + S8233078: fix minimal VM build on Linux ppc64(le)
    + S8233328: fix minimal VM build on Linux s390x
    + S8233383: Various minor fixes
    + S8233466: aarch64: remove unnecessary load of mdo when
    profiling return and parameters type
    + S8233491: Crash in AdapterHandlerLibrary::get_adapter with
    CDS due to code cache exhaustion
    + S8233529: loopTransform.cpp:2984: Error: assert(p_f->Opcode()
    == Op_IfFalse) failed
    + S8233548: Update CUP to v0.11b
    + S8233649: Update ProblemList.txt to exclude failing headful
    tests on macos
    + S8233656: assert(d->is_CFG() && n->is_CFG()) failed: must
    have CFG nodes
    + S8233657: Intermittent NPE in Component.validate()
    + S8234288: Turkey Time Zone returns incorrect time zone name
    + S8234323: NULL-check return value of SurfaceData_InitOps on
    macosx
    + S8234339: replace JLI_StrTok in java_md_solinux.c
    + S8234340: Bump update version for OpenJDK: jdk-11.0.7
    + S8234350: assert(mode == ControlAroundStripMined && (use ==
    sfpt || !use->is_reachable_from_root())) failed: missed a node
    + S8234386: [macos] NPE was thrown at expanding Choice from
    maximized frame
    + S8234397: add OS uptime information to os::print_os_info
    output
    + S8234423: Modifying ArrayList.subList().subList() resets
    modCount of subList
    + S8234466: Class loading deadlock involving
    X509Factory#commitEvent()
    + S8234501: remove obsolete NET_ReadV
    + S8234525: enable link-time section-gc for linux s390x to
    remove unused code
    + S8234610: MaxVectorSize set wrongly when UseAVX=3 is
    specified after JDK-8221092
    + S8234617: C1: Incorrect result of field load due to missing
    narrowing conversion
    + S8234723: javax/net/ssl/TLS tests support TLSv1.3
    + S8234724: javax/net/ssl/templates/
    /SSLSocketSSLEngineTemplate.java supports TLSv1.3
    + S8234741: enhance os::get_core_path on macOS
    + S8234769: Duplicate attribution in freetype.md
    + S8234786: Fix for JDK-8214578 breaks OS X 10.12 compatibility
    + S8234809: set relro in linker flags when building with gcc
    + S8234824: java/nio/channels/SocketChannel/AdaptSocket.java
    fails on Windows 10
    + S8235243: handle VS2017 15.9 and VS2019 in abstract_vm_version
    + S8235288: AVX 512 instructions inadvertently used on Xeon for
    small vector width operations
    + S8235325: build failure on Linux after 8235243
    + S8235383: C1 compilation fails with
  - XX:+PrintIRDuringConstruction -XX:+Verbose
    + S8235489: handle return values of sscanf calls in hotspot
    + S8235509: Backport for JDK-8209657 Refactor filemap.hpp to
    simplify integration with Serviceability Agent.
    + S8235510: java.util.zip.CRC32 performance drop after 8200067
    + S8235563: [TESTBUG] appcds/CommandLineFlagComboNegative.java
    does not handle archive mapping failure
    + S8235637: jhsdb jmap from OpenJDK 11.0.5 doesn't work if
    prelink is enabled
    + S8235671: enhance print_rlimit_info in os_posix
    + S8235744: PIT: test/jdk/javax/swing/text/html/
    /TestJLabelWithHTMLText.java times out in linux-x64
    + S8235904: Infinite loop when rendering huge lines
    + S8235998: [c2] Memory leaks during tracing after '8224193:
    stringStream should not use Resource Area'.
    + S8236039: JSSE Client does not accept status_request
    extension in CertificateRequest messages for TLS 1.3
    + S8236140: assert(!VerifyHashTableKeys || _hash_lock == 0)
    failed: remove node from hash table before modifying it
    + S8236179: C1 register allocation error with T_ADDRESS
    + S8236488: Support for configure option
  - -with-native-debug-symbols=internal is impossible on Windows
    + S8236500: Windows ucrt.dll should be looked up in versioned
    WINSDK subdirectory
    + S8236709: struct SwitchRange in HS violates C++ One
    Definition Rule
    + S8236848: [JDK 11u] make run-test-tier1 fails after backport
    of JDK-8232834
    + S8236873: Worker has a deadlock bug
    + S8237217: Incorrect G1StringDedupEntry type used in
    StringDedupTable destructor
    + S8237368: Problem with NullPointerException in RMI
    TCPEndpoint.read
    + S8237375: SimpleThresholdPolicy misses CounterDecay timestamp
    initialization
    + S8237508: Simplify JarFile.isInitializing
    + S8237540: Missing files in backport of JDK-8210910
    + S8237541: Missing files in backport of JDK-8236528
    + S8237600: Test SunJSSEFIPSInit fails on Ubuntu
    + S8237819: s390x - remove unused pd_zero_to_words_large
    + S8237869: exclude jtreg test security/infra/java/security/
    /cert/CertPathValidator/certification/LuxTrustCA.java because
    of instabilities
    + S8237879: make 4.3 breaks build
    + S8237945: CTW: C2 compilation fails with
    assert(just_allocated_object(alloc_ctl) == ptr) failed: most
    recent allo...
    + S8238225: Issues reported after replacing symlink at
    Contents/MacOS/libjli.dylib with binary
    + S8238247: CTW runner should sweep nmethods more aggressively
    + S8238366: CTW runner closes standard output on exit
    + S8238438: SuperWord::co_locate_pack picks memory state of
    first instead of last load
    + S8238502: sunmscapi.dll causing EXCEPTION_ACCESS_VIOLATION
    + S8238534: Deep sign macOS bundles before bundle archive is
    being created
    + S8238591: CTW: Split
    applications/ctw/modules/jdk_localedata.java
    + S8238596: AVX enabled by default for Skylake even when
    unsupported
    + S8238811: C2: assert(i >= req() || i == 0 || is_Region() ||
    is_Phi()) with -XX:+VerifyGraphEdges
    + S8239005: [TESTBUG] test/hotspot/jtreg/runtime/
    /StackGuardPages/TestStackGuardPages.java: exeinvoke.c: must
    initialize static state before calling do_overflow()
    + S8239466: Loss of precision in counter decay calculation in
    11u backport of JDK-8237375
    + S8239856: [ntintel] asserts about copying unaligned array
    element
    + S8240724: [test] jdk11 downport of 8224475 misses binary file
    test/jdk/javax/swing/JTextPane/arrow.png
    + S8241296: Segfault in JNIHandleBlock::oops_do()
- Removed patch:
  * DependOnVariableHelper.patch
    + fixed upstream
- Added patch:
  * JDK-8228407.patch
    + fix crashes due to shared archive file mismatch
* Wed Apr 15 2020 fstrba@suse.com
- The pack200 and unpack200 alternatives should be slaves of java
  and not of javac, since they are part of JRE.
* Wed Mar 25 2020 mliska@suse.cz
- Add gcc-fno-common-fix.patch in order to fix
  boo#1167462.
* Thu Feb 13 2020 schwab@suse.de
- DependOnVariableHelper.patch: Fix DependOnVariableHelper for make 4.3
* Sun Feb  2 2020 fstrba@suse.com
- Install java icons not only versioned, but also postfixed by the
  "openjdk", in order to prevent install conflicts with other
  jdk 11 flavours.
* Wed Jan 15 2020 fstrba@suse.com
- Update to upstream tag jdk-11.0.6+10 (January 2020 CPU,
  bsc#1160968)
  * Security fixes
    + S8224909, CVE-2020-2583: Unlink Set of LinkedHashSets
    + S8225261: Better method resolutions
    + S8225279: Better XRender interpolation
    + S8226352, CVE-2020-2590: Improve Kerberos interop capabilities
    + S8227758: More valid PKIX processing
    + S8227816: More Colorful ICC profiles
    + S8228548, CVE-2020-2593: Normalize normalization for all
    + S8229728: Implement negotiation parameters
    + S8229951, CVE-2020-2601: Better Ticket Granting Services
    + S8230279: Improve Pack200 file reading
    + S8230318: Better trust store usage
    + S8230967: Improve Registry support of clients
    + S8231139: Improved keystore support
    + S8231422, CVE-2020-2604: Better serial filter handling
    + S8231780, CVE-2020-2655: Better TLS messaging support
    + S8231790: Provide better FileSystemProviders
    + S8232419: Improve Registry registration
    + S8234037, CVE-2020-2654: Improve Object Identifier Processing
  * Other changes
    + S8016914: CoreDocumentImpl.setXmlVersion NPE
    + S8048556: Unnecessary GCLocker-initiated young GCs
    + S8080462: Update SunPKCS11 provider with PKCS11 v2.40 support
    + S8134672: [TEST_BUG] Some tests should check
    isDisplayChangeSupported
    + S8144125: [macOS] java/awt/event/ComponentEvent/
    /MovedResizedTwiceTest/MovedResizedTwiceTest.java failed
    automatically
    + S8146238: [macosx] Java2D Queue Flusher crash on OSX after
    switching between user accounts
    + S8176837: SunPKCS11 provider needs to check more details on
    PKCS11 Mechanism
    + S8185898: setRequestProperty(key, null) results in HTTP header
    without colon in request
    + S8190737: use unicode version of the canonicalize() function
    to handle long path on windows
    + S8191521: handle long relative path specified in
  - Xbootclasspath/a on windows
    + S8193255: Root Certificates should be stored in text format
    and assembled at build time
    + S8193325: StackFrameInfo::getByteCodeIndex returns wrong value
    if bci > 32767
    + S8198882: Add 10 JNDI tests to com/sun/jndi/dns/AttributeTests
    + S8200381: Typos in javadoc - missing verb "be" and alike
    + S8202359: [GRAAL] compiler/uncommontrap/TestDeoptOOM.java
    failed with OutOfMemoryError
    + S8205516: JFR tool
    + S8206115: Use shared macros for JavaClasses::compute_offsets
    and MetaspaceShared::serialize_well_known_classes
    + S8207263: Store the Configuration for system modules into CDS
    archive.
    + S8207922: ctw of jdk.security.auth failed with "Unexpected
    zero exit codebefore finishing all compilations"
    + S8208179: Devanagari not shown with logical fonts on Windows
    after removal of Lucida Sans from JDK
    + S8208236: [TESTBUG] vmTestbase/nsk/stress/stack tests fail by
    timeout
    + S8208364: java/lang/reflect/callerCache/
    /ReflectionCallerCacheTest.java missing module dependencies
    declaration
    + S8208582: Introduce native oop barriers in C1 for OopHandle
    + S8208601: Introduce native oop barriers in C2 for OopHandle
    + S8209003: Consolidate use of empty collections in
    java.lang.module
    + S8209120: Archive the Integer.IntegerCache
    + S8209178: Proxied HttpsURLConnection doesn't send BODY when
    retrying POST request
    + S8209545: Simplify HeapShared::archive_module_graph_objects
    + S8209647: constantPoolHandle::constantPoolHandle(ConstantPool*)
    when precompiled header is disabled
    + S8209691: Allow MemBar on single memory slice
    + S8209771: jdk.test.lib.Utils::runAndCheckException error
    + S8209790: SA tools not providing option to connect to debug
    server
    + S8209833: C2 compilation fails with
    "assert(ex_map->jvms()->same_calls_as(_exceptions->jvms()))
    failed: all collected exceptions must come from the same
    place"
    + S8209835: Aarch64: elide barriers on all volatile operations
    + S8209972: [GRAAL] Don't run RTM tests with Graal
    + S8210158: Accessorize JFR getEventWriter() intrinsics
    + S8210384: SunLayoutEngine.isAAT() font is expensive on MacOS
    + S8210387: C2 compilation fails with
    "assert(node->_last_del == _last) failed: must have deleted
    the edge just produced"
    + S8210403: Refactor java.util.Locale:i18n shell tests to plain
    java tests
    + S8210559: ClassLoaderData Symbols can leak
    + S8210776: Upgrade X Window System 6.8.2 to the latest
    XWD 1.0.7
    + S8210789: langtools/tools/javac/T8152616.java missing @modules
    + S8211037: Load jib jars dynamically from JibArtifactManager
    + S8211147: Incorrect comparator
    com.sun.beans.introspect.MethodInfo.MethodOrder
    + S8211385: (zipfs) ZipDirectoryStream yields a stream of
    absolute paths when directory is relative
    + S8211740: [AOT] -XX:AOTLibrary doesn't accept windows path
    + S8211866: TLS 1.3 CertificateRequest message sometimes offers
    disallowed signature algorithms
    + S8211919: ZipDirectoryStream should provide a stream of paths
    that are relative to the directory
    + S8211992: GraphicsConfiguration.getDevice().getDisplayMode()
    causes JVM crash on Mac
    + S8212028: Use run-test makefile framework for testing in
    Oracle's Mach5
    + S8212071: Need to set the FreeType LCD Filter to reduce
    fringing.
    + S8212627: [TESTBUG] runtime/CreateMirror/
    /ArraysNewInstanceBug.java timed out
    + S8212673: jtreg/applications/runthese/RunThese30M.java fails
    in C2 with "assert(!had_error) failed: bad dominance"
    + S8212738: Incorrectly named signature scheme
    ecdsa_secp512r1_sha512
    + S8212752: Typo in SSL log message related to inactive/disabled
    signature scheme
    + S8213005: Missing symbols in hs_err files on Windows after
    JDK-8212028
    + S8213008: Cipher with UNWRAP_MODE should support the
    generation of an AES key type
    + S8213014: Crash in CompileBroker::make_thread due to OOM
    + S8213119: [macos] java/awt/GraphicsDevice/
    /CheckDisplayModes.java fails
    + S8213381: Hook to allow GC to inject Node::Ideal() calls
    + S8213448: [TESTBUG] enhance jfr/jvm/TestDumpOnCrash
    + S8213568: Typo in java/awt/GraphicsEnvironment/LoadLock/
    /GE_init5.java
    + S8213604: Fix missing includes after JDK-8212673
    + S8214046: [macosx] Undecorated Frame does not Iconify when
    set to
    + S8214052: [testbug] vmTestbase/vm/compiler/
    /CodeCacheInfoOnCompilation - wrong shell used
    + S8214098: sun.security.ssl.HandshakeHash.T12HandshakeHash
    constructor check backwards.
    + S8214311: dtrace gensrc has missing dependencies
    + S8214315: G1: fatal error: acquiring lock SATB_Q_FL_lock/1 out
    of order with lock tty_lock/0
    + S8214321: Misleading code in SSLCipher
    + S8214542: JFR: Old Object Sample event slow on a deep heap in
    debug builds
    + S8214750: Unnecessary <p> tags in jfr classes
    + S8214773: Replace use of thread unsafe strtok
    + S8214896: JFR Tool left files behind
    + S8214925: JFR tool fails to execute
    + S8214975: No hs-err file if fatal error is raised during
    dynamic initialization
    + S8215032: Support Kerberos cross-realm referrals (RFC 6806)
    + S8215105: java/awt/Robot/HiDPIScreenCapture/
    /ScreenCaptureTest.java: Wrong Pixel Color
    + S8215200: IllegalArgumentException in
    sun.lwawt.macosx.CPlatformWindow
    + S8215411: some GetByteArrayElements calls miss corresponding
    Release
    + S8215449: Several tests failing when jtreg run with
  - vmoption:--illegal-access=deny
    + S8215524: Finished message validation failure should be
    decrypt_error alert
    + S8215699: -Xlog::file cannot be used with named pipe
    + S8215708: ZGC: Add missing LoadBarrierNode::size_of()
    + S8215755: ZGC: split_barrier_thru_phi: check number of inputs
    of phi
    + S8215771: The jfr tool should pretty print reference chains
    + S8215913: [Test_bug]java/util/Locale/LocaleProvidersRun.java
    failed on de_DE and ja_JP locale.
    + S8216064: -XX:StartFlightRecording:settings= doesn't work
    properly
    + S8216135: C2 assert(!had_error) failed: bad dominance
    + S8216283: Allow shorter method sampling interval than 10 ms
    + S8216363: NullPointerException in
    java.util.logging.Handler#isLoggable
    + S8216426: Usage of array placement new may lead to memory
    corruption
    + S8216561: HttpClient: The logic of retry on connect exception
    is inverted
    + S8216977: ShowHiddenFrames use in
    java_lang_StackTraceElement::fill_in appears broken
    + S8217362: Emergency dump does not work when disk=false is set
    + S8217610: TLSv1.3 fail with ClassException when EC keys are
    stored in PKCS11
    + S8217731: Font rendering and glyph spacing changed from jdk-8
    to jdk-11
    + S8218468: Load barrier slow path node should be MachTypeNode
    + S8218580: endpoint identification algorithm should be
    case-insensitive
    + S8218935: Make jfr strncpy uses GCC 8.x friendly
    + S8219504: Test for JDK-8211435 can be run on all platforms
    + S8219914: Change the environment variable for Java Access
    Bridge logging to have a directory.
    + S8220175: serviceability/dcmd/framework/VMVersionTest.java
    fails with a timeout
    + S8220231: Cache HarfBuzz face object for same font's text
    layout calls
    + S8220352: Crash with assert(external_guard || result != __null)
    failed: Invalid JNI handle
    + S8220394: bufferedStream does not honor size limit
    + S8220474: Incorrect GPL header in src/java.instrument/share/
    /classes/java/lang/instrument/package-info.java
    + S8220476: Incorrect GPL header in src/jdk.internal.jvmstat/
    /share/classes/sun/jvmstat/perfdata/monitor/protocol/local/
    /PerfDataFile.java
    + S8220528: [AIX] Fix basic Xinerama and Xrender functionality
    + S8220555: JFR tool shows potentially misleading message when
    it cannot access a file
    + S8220598: Malformed copyright year range in a few files in
    java.base
    + S8221092: UseAVX=3 has performance degredation on Skylake (X7)
    processors
    + S8221172: SunEC specific test is not limited to SunEC
    + S8221246: NullPointerException within Win32ShellFolder2
    + S8221395: HttpClient leaving connections in CLOSE_WAIT state
    until Java process ends
    + S8221406: Windows 32bit build error in
    NetworkInterface_winXP.c
    + S8221456: nmethod::make_unloaded() clears _method member too
    early
    + S8221532: Incorrect copyright header in FileSystemSupport_md.c
    + S8221539: [metaspace] Improve MetaspaceObj::is_metaspace_obj()
    and friends
    + S8221569: JFR tool produces incorrect output when both
  - -categories and --events are specified
    + S8221711: [TESTBUG] create more tests for JFR in container
    environment
    + S8221913: Add GC.selected() jtreg-ext function
    + S8222015: Small VM.metaspace improvements
    + S8222440: (zipfs) JarFileSystem does not correctly handle
    versioned entries if no root entry is present
    + S8222529: sun.jdwp.listenerAddress agent property uses wrong
    encoding
    + S8222807: Address iteration with invalid ZIP header entries
    + S8222888: [TESTBUG] docker/TestJFREvents.java fails due to
    "RuntimeException: JAVA_MAIN_CLASS_ is not defined"
    + S8223438: add VirtualizationInformation JFR event
    + S8223490: Optimize search algorithm for determining default
    time zone
    + S8223697: jfr tool can't format duration values greater than
    minute
    + S8223869: Problem list java/awt/FontMetrics/
    /MaxAdvanceIsMax.java on more platforms
    + S8224152: [macOS] ProblemList tests that leave rubbish on the
    screen
    + S8224157: BCEL: update to version 6.3.1
    + S8224172: assert(jfr_is_event_enabled(id)) failed: invariant
    + S8224193: stringStream should not use Resouce Area
    + S8224217: RecordingInfo should use textual representation of
    path
    + S8224502: [TESTBUG] JDK docker test TestSystemMetrics.java
    fails with access issues and OOM
    + S8224505: TestQuotedLogOutput failure after ProcessBuilder
    changes
    + S8224538: LoadBarrierNode::common_barrier must check address
    + S8224958: add os::dll_load calls to event log
    + S8225101: Crash at sun.awt.X11.XlibWrapper.XkbGetUpdatedMap
    when change keybord map
    + S8225225: stringStream internal buffer should always be zero
    terminated
    + S8225392: Comparison builds are failing due to cacerts file
    + S8225505: ctrl-F1 does not show the tooltip of a menu item
    (JMenuItems)
    + S8225694: Destination option missing in
    FlightRecorderMXBeanImpl
    + S8225695: 32-bitbuild failures after JDK-8080462 (Update
    SunPKCS11 provider with PKCS11 v2.40 support)
    + S8225745: NoSuchAlgorithmException exception for
    SHA256withECDSA with RSASSA-PSS support
    + S8226513: JEditorPane is shown with incorrect size
    + S8226651: Setting the mgfHash in CK_RSA_PKCS_PSS_PARAMS has no
    effect
    + S8226719: Kerberos login to Windows 2000 failed with
    "Inappropriate type of checksum in message"
    + S8226779: [TESTBUG] Test JFR API from Java agent
    + S8226869: Testjava/util/Locale/LocaleProvidersRun.java should
    enable assertions
    + S8226899: Problemlist compiler/rtm tests
    + S8227031: Print NMT statistics on fatal errors
    + S8227032: MetaspaceUtils::print_report crashes when called
    before initialization
    + S8227035: JVM::printFlags fails in native OOM situations
    + S8227061: KDC.java test behaves incorrectly when AS-REQ
    contains a PAData not PA-ENC-TS-ENC
    + S8227086: Use AS_NO_KEEPALIVE loads in HeapDumper
    + S8227127: Era designator not displayed correctly using the
    COMPAT provider
    + S8227338: templateInterpreter.cpp: copy_table() needs to be
    safer
    + S8227368: EnumSet.class serialization broken in JDK 9+
    + S8227381: GSS login fails with PREAUTH_FAILED
    + S8227391: Update double-conversion to version 3.1.5
    + S8227397: Add --with-extra-asflags configure option
    + S8227411: TestTimeMultiple.java failed "assert(!lease())
    failed: invariant"
    + S8227435: Perf::attach() should not throw a java.lang.Exception
    + S8227437: S4U2proxy cannot continue because server's TGT
    cannot be found
    + S8227439: Turn off AOT by default
    + S8227605: Kitchensink fails "assert((((klass)->trace_id() &
    (JfrTraceIdEpoch::leakp_in_use_this_epoch_bit())) != 0))
    failed: invariant"
    + S8227642: [TESTBUG] Make docker tests podman compatible
    + S8228368: avoid incompatible pointer to integer conversion
    initializing gint in gtk2_interface
    + S8228434: jdk/net/Sockets/Test.java fails after JDK-8227642
    + S8228465: HOST locale provider holds wrong era name for
    GregorianCalendar in US locale
    + S8228625: [TESTBUG] sun/tools/jhsdb/JShellHeapDumpTest.java
    fails with RuntimeException 'JShellToolProvider' missing from
    stdout/stderr
    + S8228645: Don't run sun/security/pkcs11/Cipher/
    /TestKATForGCM.java on buggy NSS solaris versions
    + S8228687: [TESTBUG] exclude Container tests from hotspot_misc
    group
    + S8228772: C2 compilation fails due to unschedulable graph if
    DominatorSearchLimit is reached
    + S8228834: Regression caused by JDK-8214542 not installing
    complete checkpoint data to candidates
    + S8228835: Memory leak in PKCS11 provider when using AES GCM
    + S8228888: C2 compilation fails with assert "m has strange
    control"
    + S8228902: add os::dll_load to the unified logging os category
    + S8229016: C2 scalarization crashes with assert(node->Opcode()
    == Op_CastP2X) failed: ConvP2XNode required
    + S8229020: Failure on CPUs allowing loads reordering:
    assert(_tasks[t] == 1) failed: What else?
    + S8229022: BufferedReader performance can be improved by using
    StringBuilder
    + S8229156: ProblemList gc/stress/gclocker/
    /TestExcessGCLockerCollections.java
    + S8229169: False failure of GenericTaskQueue::pop_local on
    architectures with weak memory model
    + S8229182: runtime/containers/docker/TestMemoryAwareness.java
    test fails on SLES12
    + S8229243: SunPKCS11-Solaris provider tests failing on
    Solaris 11.4
    + S8229284: jdk/internal/platform/cgroup/TestCgroupMetrics.java
    fails for - memory:getMemoryUsage
    + S8229408: Bump update version for OpenJDK: jdk-11.0.6
    + S8229420: [Redo] jstat reports incorrect values for OU for
    CMS GC
    + S8229437: assert(is_aligned(ref, HeapWordSize)) failed:
    invariant
    + S8229450: C2 compilation fails with assert(found_sfpt) failed
    + S8229483: Sinking load out of loop may trigger:
    assert(found_sfpt) failed: no node in loop that's not input to
    safepoint
    + S8229496: SIGFPE (division by zero) in C2 OSR compiled method
    + S8229515: [macos] access to window property of NSView on wrong
    thread
    + S8229701: aarch64: C2 OSR compilation fails with "shouldn't
    process one node several times" in final graph reshaping
    + S8229800: WindowsServerCore 1809 does not provide d2d1.dll
    library required by awt.dll
    + S8229810: [macos] NullPointerException getting bounds of
    GraphicsConfiguration
    + S8229872: (fs) Increase buffer size used with getmntent
    + S8229899: Make java.io.File.isInvalid() less racy
    + S8230061: # assert(mode == ControlAroundStripMined
    && use == sfpt) failed: missed a node
    + S8230062: assert(i == p->size()-1) failed: must be last
    element of the pack
    + S8230110: TestLinkageErrorInGenerateOopMap times out
    + S8230115: Problemlist JFR TestNetworkUtilization test
    + S8230238: Add another regression test for JDK-8134739
    + S8230303: JDB hangs when running monitor command
    + S8230363:C2: Let ConnectionGraph::not_global_escape(Node* n)
    return false if n is not in the CG
    + S8230376: [TESTBUG] runtime/StackTrace/HiddenFrameTest.java
    fails with release VM
    + S8230388: Problemlist additional compiler/rtm tests
    + S8230466: check malloc/calloc results in jdk.hotspot.agent
    + S8230646: Epsilon does not extend TLABs to max size
    + S8230669: [s390] C1: assert(is_bound() || is_unused()) failed:
    Label was never bound to a location, but it was used as a jmp
    target
    + S8230671: x86_32 build failures after JDK-8229496
    + S8230711: ConnectionGraph::unique_java_object(Node* N) return
    NULL if n is not in the CG
    + S8230728: Thin stroked shapes are not rendered if affine
    transform has flip bit
    + S8230769: BufImg_SetupICM add ReleasePrimitiveArrayCritical
    call in early return
    + S8230782: Robot.createScreenCapture() fails if "awt.robot.gtk"
    is set to false
    + S8230813: Add JDK-8010500 to compiler/loopopts/superword/
    /TestFuzzPreLoop.java bug list
    + S8230856: Java_java_net_NetworkInterface_getByName0 on unix
    misses ReleaseStringUTFChars in early return
    + S8230861: missing ReleaseStringUTFChars in
    Java_sun_security_pkcs11_wrapper_PKCS11_connect
    + S8230873: [AIX] GUI app does not work with UTF-8 locale on
    minimum software requirements
    + S8230881: serviceability/sa/TestJmapCore tests fail with
    java.lang.RuntimeException: Could not find dump file
    + S8230900: missing ReleaseStringUTFChars in java.desktop native
    code
    + S8230901: missing ReleaseStringUTFChars in serviceability
    native code
    + S8230923: SunJSSE is not properly initialized in FIPS mode
    from a configuration file
    + S8230943: False deadlock detection with
  - XX:+CIPrintCompileQueue after JDK-8163511
    + S8231055: C2: arraycopy with same non escaping src and dest
    but different positions causes wrong execution
    + S8231084: Large performance regression in SwingMark TextArea
    in 14-b13
    + S8231085: C2/GC: Better GC-interface for expanding clone
    + S8231098: (tz) Upgrade time-zone data to tzdata2019c
    + S8231124: Missing closedir call with JDK-8223490
    + S8231201: hs_err should print coalesced safepoint operations
    in Events section
    + S8231222: fix pkcs11 P11_DEBUG guarded native traces
    + S8231223: C2's conditional move optimization fails with
    assert(bol->Opcode() == Op_Bool) failed
    + S8231247: (zipfs) Test failure in jdk/nio/zipfs/
    /InvalidZipHeaderTests.java after backport of JDK-8222807
    + S8231254: (fs) Add test for macOS Catalina changes to protect
    system software
    + S8231294: ZGC: vmTestbase/nsk/jvmti/ResourceExhausted/
    /resexhausted002 fails
    + S8231296: ZGC: vmTestbase/nsk/jvmti/Allocate/alloc001/ fails
    + S8231318: Several compiler/aot tests fail for JDK11 on Windows
    when only MSVC 2017 is installed
    + S8231336: Corrupted option dialog in JTHarness with JDK14b13
    + S8231403: [ppc]: Align ReservedCodeCacheSize default value
    with other platforms
    + S8231457: Asserts on AIX because os::elapsed_counter() is not
    monotonic
    + S8231503: [TESTBUG] compiler/{jvmci,aot} tests should not run
    with GCs that do not support JVMCI/AOT
    + S8231620: assert(bol->is_Bool()) crash during split if due to
    FastLockNode
    + S8231665: 8231055 broke escapeAnalysis/TestSelfArrayCopy.java
    + S8231693: Backout "8230728: Thin stroked shapes are not
    rendered if affine transform has flip bit" from jdk11u
    + S8231751: on aix handle Power 9 in os::get_summary_cpu_info
    + S8231770: Test java/util/zip/FlaterTest.java fails with
  - Xcheck:jni
    + S8231885: Fix/remove malformed assert in os_windows.cpp
    + S8231887: ComodoCA.java fails because certificate was revoked
    + S8231930: Windows build fails after JDK-8191521
    + S8231949: [PPC64, s390]: Make async profiling more reliable
    + S8231988: Unexpected test result caused by C2
    IdealLoopTree::do_remove_empty_loop
    + S8231991: Mouse wheel change focus on awt/swing windows
    + S8232005: [s390, PPC64] More exception checks missing in
    interpreter
    + S8232019: Add LuxTrust certificate updates to the existing
    root program
    + S8232051: Epsilon should warn about Xms/Xmx/AlwaysPreTouch
    configuration
    + S8232052: use string literal for format string when handling
    PauseAtStartupFile
    + S8232178: MacVolumesTest failed after upgrade to MacOS
    Catalina
    + S8232381: add result NULL-checking to freetypeScaler.c
    + S8232539: SIGSEGV in C2 Node::unique_ctrl_out
    + S8232592: <Unknown compiled code> is shown in jstack mixed
    mode
    + S8232874: Add missing test for 8230062
    + S8232879: Writing out data with the Zip File System leads to
    a CRC failure
    + S8232984: Upgrading Joni License version to 2.1.16
    + S8233075: JFR - nmetods - misspelled in several places
    + S8233081: C1: PatchingStub for field access copies too much
    + S8233097: Fontmetrics for large Fonts has zero width
    + S8233202: exclude javax/swing/plaf/basic/BasicGraphicsUtils/
    /8132119/bug8132119.java
    + S8233203: fix non-product build on AIX when compiling with
    xlc16/legacy-xlc
    + S8233223: Add Amazon Root CA certificates
    + S8233404: System property to set the number of PBE iterations
    in JCEKS keystores
    + S8233820: Test crashed with assert(phi->operand_count() != 1
    || phi->subst() != phi) failed: missed trivial simplification
    + S8233839: aarch64: missing memory barrier in
    NewObjectArrayStub and NewTypeArrayStub
    + S8233886: TEST_BUG jdk/java/net/CookieHandler/B6791927.java
    hit hardcoded expiration date
    + S8233944: Make KerberosPrincipal.KRB_NT_ENTERPRISE field
    package private
    + S8233954: UnsatisfiedLinkError or NoSuchAlgorithmException
    after removing sunec.dll
    + S8234080: jdk/nio/zipfs/CRCWriteTest.java fails
    + S8234107: Several AWT modal dialog tests failing on Linux
    after JDK-8231991
    + S8234245: sun/security/lib/cacerts/VerifyCACerts.java fails
    due to wrong checksum
    + S8234321: Call cache flush after generating trampoline.
    + S8234591: [11u] Build with old C compiler broken by 8223490
    + S8234625: hs test serviceability/sa/ClhsdbCDSCore.java fails
    on macOS 10.15
    + S8234645: ARM32: C1: PatchingStub for field access: not enough
    bytes
    + S8234906: [TESTBUG] TestDivZeroCheckControl fails for client
    VMs due to Unrecognized VM option LoopUnrollLimit
    + S8235142: JDK-8193255 backport broke bootstrap with JDK 10
    + S8235403: Further cleanup to test
    serviceability/sa/ClhsdbCDSCore.java
    + S8235585: Enable macOS codesigning for all libraries and
    executables
    + S8235687: Contents/MacOS/libjli.dylib cannot be a symlink
* Tue Dec 17 2019 guillaume.gardet@opensuse.org
- Switch back armv6 from zero platform to client JVM
* Wed Oct 23 2019 fstrba@suse.com
- Update to upstream tag jdk-11.0.5-10 (October 2019 CPU,
  bsc#1154212)
  * Security fixes:
    + S8209901: Canonical file handling
    + S8213429, CVE-2019-2933: Windows file handling redux
    + S8218573, CVE-2019-2945: Better socket support
    + S8218877: Help transform transformers
    + S8219914: Change the environment variable for Java Access
    Bridge logging to have a directory.
    + S8220186: Improve use of font temporary files
    + S8220302, CVE-2019-2949: Better Kerberos ccache handling
    + S8221497: Optional Panes in Swing
    + S8221858, CVE-2019-2958: Build Better Processes
    + S8222684, CVE-2019-2964: Better support for patterns
    + S8222690, CVE-2019-2962: Better Glyph Images
    + S8223163: Better pattern recognition
    + S8223505, CVE-2019-2973: Better pattern compilation
    + S8223518, CVE-2019-2975: Unexpected exception in jjs
    + S8223886: Add in font table referene
    + S8223892, CVE-2019-2978: Improved handling of jar files
    + S8224025: Fix for JDK-8220302 is not complete
    + S8224062, CVE-2019-2977: Improve String index handling
    + S8224532, CVE-2019-2981: Better Path supports
    + S8224915, CVE-2019-2983: Better serial attributes
    + S8225286, CVE-2019-2987: Better rendering of native glyphs
    + S8225292, CVE-2019-2988: Better Graphics2D drawing
    + S8225298, CVE-2019-2989: Improve TLS connection support
    + S8225597, CVE-2019-2992: Enhance font glyph mapping
    + S8226765, CVE-2019-2999: Commentary on Javadoc comments
    + S8227601: Better collection of references
    + S8228825, CVE-2019-2894, bsc#1152856: Enhance ECDSA operations
  * Other fixes:
    + S6996807: FieldReflectorKey hash code computation can be
    improved
    + S8076988: reevaluate trivial method policy
    + S8087128: C2: Disallow definition split on MachCopySpill nodes
    + S8133489: Better messaging for PKIX path validation matching
    + S8139965: Hang seen when using
    com.sun.jndi.ldap.search.replyQueueSize
    + S8147502: Digest is incorrectly truncated for ECDSA
    signatures when the bit length of n is less than the field
    size
    + S8148188: Enhance the security libraries to record events of
    interest
    + S8163363: AArch64: Stack size in tools/launcher/Settings.java
    needs to be adjusted
    + S8163511: Allocation of compile task fails with assert:
    "Leaking compilation tasks?"
    + S8170639: [Linux] jsig is limited to a maximum of 64 signals
    + S8177899: Tests fail due to code cache exhaustion on machines
    with many cores
    + S8180901: Transformer.reset() resets the state only once
    + S8193234: When using -Xcheck:jni an internally allocated
    buffer can leak
    + S8194231: java/net/DatagramSocket/ReuseAddressTest.java
    failed with java.net.BindException: Address already in use:
    Cannot bind
    + S8196681: Java Access Bridge logging and debug flags
    dynamically controlled
    + S8198411: [TEST_BUG] Two java2d tests are unstable in mach5
    + S8200365: TestOptionsWithRanges.java of
    '-XX:TLABWasteTargetPercent=100' fails intermittently
    + S8200400: Restrict Sasl mechanisms
    + S8202035: Archive the set of ModuleDescriptor and
    ModuleReference objects for observable system modules with
    unnamed initial module.
    + S8202252: (aio) Closed AsynchronousSocketChannel keeps
    completion handler alive
    + S8202952: C2: Unexpected dead nodes after matching
    + S8203629: Produce events in the JDK without a dependency on
    jdk.jfr
    + S8204203: Many pkcs11 tests failed in Provider
    initialization, after compiler on Windows changed
    + S8204521: compiler/jsr292/
    /RedefineMethodUsedByMultipleMethodHandles.java fails trying
    to delete temp file
    + S8205421: AARCH64: StubCodeMark should be placed after
    alignment
    + S8205654: serviceability/dcmd/framework/HelpTest.java timed
    out
    + S8206074: nsk/jdi/EventRequestManager/createStepRequest/
    /crstepreq001/TestDescription.java is timing out
    + S8206879: Currency decimal marker incorrect for Peru
    + S8207965: C2-only debug build fails
    + S8208269: Javadoc does not support module-info in a
    multi-release jar
    + S8208499: NMT: Missing memory tag for Safepoint polling page
    + S8208655: use JTreg skipped status in hotspot tests
    + S8208701: Fix for JDK-8208655 causes test failures in CI tier1
    + S8208706: compiler/tiered/ConstantGettersTransitionsTest.java
    fails to compile
    + S8208780: (se) test
    SelectWithConsumer.testReadableAndWriteable(): failure
    + S8209186: Rename SimpleThresholdPolicy to
    TieredThresholdPolicy
    + S8209413: AArch64: NPE in clhsdb jstack command
    + S8209420: Track membars for volatile accesses so they can be
    properly optimized
    + S8209684: Intrinsics that assume some input non null should
    use GraphKit::must_be_not_null()
    + S8209939: [testbug][ppc] Test SafepointPollingPages fails
    after 8208499 with UseSIGTRAP on.
    + S8210063: ZGC: Enable load barriers for IN_NATIVE runtime
    barriers
    + S8210130: java/net/httpclient/UnknownBodyLengthTest.java
    failed
    + S8210314: [aix] NMT does not show "Safepoint" memory type
    + S8210389: C2: assert(n->outcnt() != 0 || C->top() == n ||
    n->is_Proj()) failed: No dead instructions after post-alloc
    + S8210390: C2 still crashes with "assert(mode ==
    ControlAroundStripMined && use == sfpt) failed: missed a node"
    + S8210408: Refactor java.util.ResourceBundle:i18n shell tests
    to plain java tests
    + S8210729: Clean up macosx static library handling
    + S8210919: Remove statically linked libjli on Windows
    + S8210926: vmTestbase/nsk/jvmti/scenarios/allocation/AP11/
    /ap11t001/TestDescription.java failed with
    JVMTI_ERROR_INVALID_CLASS in CDS mode
    + S8210985: Update the default SSL session cache size to 20480
    + S8211097: aix: fix build after JDK-8210919
    + S8211232: GraphKit::make_runtime_call() sometimes attaches
    wrong memory state to call
    + S8211233: MemBarNode::trailing_membar() and
    MemBarNode::leading_membar() need to handle dying subgraphs
    better
    + S8211727: Adjust default concurrency settings for running
    tests on Sparc
    + S8212528: Wrong cgroup subsystem being used for some CPU
    Container Metrics
    + S8212970: TZ database in "vanguard" format support
    + S8212992: Change mirror accessor in Klass::verify_on() to use
    AS_NO_KEEPALIVE
    + S8213017: jspawnhelper: need to handle pipe write failure
    when sending return code
    + S8213117: adoptNode corrupts attribute values
    + S8213134: AArch64: vector shift failed with MaxVectorSize=8
    + S8213172: CDS and JFR tests fail with
    assert(JdkJfrEvent::is(klass)) failed: invariant
    + S8213325: (props) Properties.loadFromXML does not fully
    comply with the spec
    + S8213406: (fs) More than one instance of built-in FileSystem
    observed in heap
    + S8213561: ZipFile/MultiThreadedReadTest.java timed out in
    tier1
    + S8213734: SAXParser.parse(File, ..) does not close resources
    when Exception occurs.
    + S8214003: Limit default test jobs based on memory size
    + S8214096: sun.security.util.SignatureUtil passes null
    parameter, so JCE validation fails
    + S8214161: java.lang.IllegalAccessError: class
    jdk.internal.event.X509CertificateEvent (in module java.base)
    cannot access class jdk.jfr.internal.handlers.EventHandler
    (in module jdk.jfr) because module java.base does not read
    module jdk.jfr
    + S8214287: SpecJbb2005StressModule got uncaught exception
    + S8214579: JFrame does not paint content in XVFB / X11vnc
    environment
    + S8214687: Optimize Collections.nCopies().hashCode() and
    equals()
    + S8214702: Wrong text position for whitespaced string in
    printing Swing text
    + S8214770: java/time/test/java/time/format/
    /TestNonIsoFormatter.java failed in non-english locales.
    + S8214777: Avoid some GCC 8.X strncpy() errors in HotSpot
    + S8214857: "bad trailing membar" assert failure at
    memnode.cpp:3220
    + S8215044: C2 crash in loopTransform.cpp with
    assert(cl->trip_count() > 0) failed: peeling a fully unrolled
    loop
    + S8215130: Fix errors in LittleCMS 2.9 reported by GCC 8
    + S8215265: C2: range check elimination may allow illegal out
    of bound access
    + S8215281: Use String.isEmpty() when applicable in java.base
    + S8215380: Backout accidental change to String::length
    + S8215451: JNI IsSameObject should not keep objects alive
    + S8215483: Off heap memory accesses should be vectorized
    + S8215505: Cleanup jvm.cpp obsolete code after JDK-8210094:
    Better loading of classloader classes
    + S8215534: [testbug] some jfr test don't check @requires
    vm.hasJFR
    + S8215694: keytool cannot generate RSASSA-PSS certificates
    + S8215756: Memory leaks in the AWT on macOS
    + S8215792: AArch64: String.indexOf generates incorrect result
    + S8215879: AArch64: ReservedStackAccess may leave stack guard
    in inconsistent state
    + S8215901: [TESTBUG] TestCheckedEnsureLocalCapacity.java fails
    intermittently
    + S8215961: jdk/jfr/event/os/TestCPUInformation.java fails on
    AArch64
    + S8215982: (tz) Upgrade time-zone data to tzdata2018i
    + S8216039: TLS with BC and RSASSA-PSS breaks
    ECDHServerKeyExchange
    + S8216046: test/jdk/java/beans/PropertyEditor/Test6397609.java
    failing
    + S8216155: C4819 warning at libfreetype sources on Windows
    + S8216199: Local variable arg defined but never used in
    BCEscapeAnalyzer::compute_escape_for_intrinsic()
    + S8216205: Java API documentation formatting error in
    System.getEnv
    + S8216261: Javap ignores default modifier on interfaces
    + S8216326: SSLSocket stream close() does not close the
    associated socket
    + S8216375: Revert JDK-8145579 after JDK-8076988 is resolved
    + S8216401: Allow "file:" URLs in Class-Path of local JARs
    + S8216427: ciMethodData::load_extra_data() does not always
    unpack the last entry
    + S8216528: test/jdk/java/rmi/transport/
    /runtimeThreadInheritanceLeak/
    /RuntimeThreadInheritanceLeak.java failing with Xcomp
    + S8216549: Mismatched unsafe access to non escaping object
    fails
    + S8216562: UnknownBodyLength sometimes fails due to
    "Connection reset by peer"
    + S8216987: ciMethodData::load_data() unpacks MDOs with
    non-atomic copy
    + S8216989: CardTableBarrierSetAssembler::gen_write_ref_array_post_barrier()
    does not check for zero length on AARCH64
    + S8217093: Support extended-length paths in parse_manifest.c
    on windows
    + S8217344: Make comparison overflow-aware in
    ECDHKeyAgreement.engineGenerateSecret()
    + S8217359: C2 compiler triggers SIGSEGV after transformation
    in ConvI2LNode::Ideal
    + S8217364: Custom URLStreamHandler for jrt or file protocol
    can override default handler
    + S8217366: ZoneStrings are not populated for all the Locales
    + S8217368: AArch64: C2 recursive stack locking optimisation
    not triggered
    + S8217371: Incorrect LP64 guard in x86.ad after JDK-8210764
    (Update avx512 implementation)
    + S8217576: C1 atomic access handlers use incorrect decorators
    + S8217676: Upgrade libpng to 1.6.37
    + S8217760: C2: Missing symbolic info on a call from intrinsics
    when invoked through MethodHandle
    + S8217766: Container Support doesn't work for some Join
    Controllers combinations
    + S8217785: Padding
    ParallelTaskTerminator::_offered_termination variable
    + S8217896: Make better use of LCPUs when building on AIX
    + S8217990: C2 UseOptoBiasInlining: load of markword optimized
    to 0 if running with -XX:-EliminateLocks
    + S8218163: C2: Continuous deoptimization w/
    Reason_speculate_class_check and Action_none
    + S8218185: aarch64: missing LoadStore barrier in
    TemplateTable::putfield_or_static
    + S8218201: Failures when vmIntrinsics::_getClass is not inlined
    + S8218280: LineNumberReader throws "Mark invalid" exception if
    CRLF straddles buffer.
    + S8218553: Enhance keystore load debug output
    + S8218558: NMT stack traces in output should show mt component
    for virtual memory allocations
    + S8218566: NMT: missing memory tag for assert poison page
    + S8218581: Incorrect exception message generation
    + S8218682: [TEST_BUG] DashOffset fails in mach5
    + S8218705: Test sun/tools/jcmd/TestJcmdDefaults.java fails on
    Linux
    + S8218715: [TESTBUG]
    TestUseOptoBiasInliningWithoutEliminateLocks needs to unlock
    WhiteBoxAPI
    + S8218721: C1's CEE optimization produces safepoint poll with
    invalid debug information
    + S8218723: Use SunJCE Mac in SecretKeyFactory PBKDF2
    implementation
    + S8218780: Update MUSCLE PCSC-Lite header files
    + S8218879: Keep track of memory accesses originated from Unsafe
    + S8218966: AArch64: String.compareTo() can read memory after
    string
    + S8219013: Update Apache Santuario (XML Signature) to version
    2.1.3
    + S8219241: Provide basic virtualization related info in the
    hs_error file on linux/windows x86_64
    + S8219244: NMT: Change ThreadSafepointState's allocation type
    from mtInternal to mtThread
    + S8219370: NMT: Move synchronization primitives from
    mtInternal to mtSynchronizer
    + S8219513: compiler/codegen/aes/
    /TestCipherBlockChainingEncrypt.java timeout on Solaris-sparc
    + S8219517: assert(false) failed: infinite loop in
    PhaseIterGVN::optimize
    + S8219562: Line of code in osContainer_linux.cpp L102 appears
    unreachable
    + S8219583: Windows build failure after JDK-8214777 (Avoid some
    GCC 8.X strncpy() errors in HotSpot)
    + S8219635: aarch64: missing LoadStore barrier in
    TemplateTable::fast_storefield
    + S8219807: C2 crash in IfNode::up_one_dom(Node*, bool)
    + S8219919: RuntimeStub name lost with
    PrintFrameConverterAssembly
    + S8219993: AArch64: Compiled CI stubs are unsafely modified
    + S8219997: [TESTBUG] Create test for JFR events in Docker
    container: CPU, Memory and Process Info
    + S8220037: Inconsistencies of generated timezone files between
    Windows and Linux
    + S8220072: GCC 8.3 reports errors in java.base
    + S8220173: assert(_handle_mark_nesting > 1) failed: memory
    leak: allocating handle outside HandleMark
    + S8220227: Host Locale Provider getDisplayCountry returns
    error message under non-English Win10
    + S8220313: [TESTBUG] Update base image for Docker testing to
    OL 7.6
    + S8220341: Class redefinition fails with
    assert(!is_unloaded()) failed: unloaded method on the stack
    + S8220355: Improve assertion texts and exception messages in
    eventHandlerVMInit
    + S8220570: Additonal trace when native thread creation fails
    + S8220579: [Containers] SubSystem.java out of sync with
    osContainer_linux.cpp
    + S8220657: JFR.dump does not work when filename is set
    + S8220672: [TESTBUG] TestCPUSets should check that cpuset does
    not exceed available cores
    + S8220674: [TESTBUG] MetricsMemoryTester failcount test in
    docker container only works with debug JVMs
    + S8220682: Heap dumping and inspection fails with JDK-8214712
    + S8220690: ATTRIBUTE_ALIGNED requires GNU extensions enabled
    + S8221120: CopyOnWriteArrayList.set should always have
    volatile write semantics
    + S8221220: AArch64: Add StoreStore membar explicitly for
    Volatile Writes in TemplateTable
    + S8221253: TLSv1.3 may generate TLSInnerPlainText longer than
    2^14+1 bytes
    + S8221325: Add information about swap space to
    print_memory_info() on MacOS
    + S8221340: [TESTBUG] TestCgroupMetrics.java fails after fix
    for JDK-8219562
    + S8221342: [TESTBUG] Generate Dockerfile for docker testing
    + S8221407: Windows 32bit build error in
    libsunmscapi/security.cpp
    + S8221408: Windows 32bit build build errors/warnings in hotspot
    + S8221411: NullPointerException in RasterPrinterJob without
    PrinterResolution
    + S8221434: Fix typo in lib-x11 autoconf error message about
    missing headers
    + S8221480: jcmd VM.metaspace shall print limits in basic mode
    + S8221497: Optional Panes in Swing
    + S8221527: [TESTBUG] DockerBasicTest.java contains hard-coded
    reference to JDK 10
    + S8221529: [TESTBUG] Docker tests use old/deprecated image on
    AArch64
    + S8221710: [TESTBUG] more configurable parameters for docker
    testing
    + S8221725: AArch64 build failures after JDK-8221408 (Windows
    32bit build build errors/warnings in hotspot)
    + S8221730: jcmd process name matching broken
    + S8221801: Update src/java.base/share/legal/public_suffix.md
    + S8221892: ThreadPoolExecutor: Thread.isAlive() is not
    equivalent to not being startable
    + S8221894: Add comments for docker tests in the test doc
    + S8222108: Reduce minRefreshTime for updating remote printer
    list on Windows
    + S8222154: upgrade gtest to 1.8.1
    + S8222280: Provide virtualization related info in the hs_error
    file on AIX
    + S8222299: [TESTBUG] move hotspot container tests to
    hotspot/containers
    + S8222362: Upgrade to Freetype 2.10.0
    + S8222387: Out-of-bounds access to CPU _family_id_xxx array
    + S8222415: Xerces 2.12.0: Parsing Configuration
    + S8222670: pathological case of JIT recompilation and code
    cache bloat
    + S8222720: Provide extended VMWare/vSphere virtualization
    related info in the hs_error file on linux/windows x86_64
    + S8222743: Xerces 2.12.0: DOM Implementation
    + S8222914: Partial backport of JDK-8218266
    + S8222968: ByteArrayPublisher is not thread-safe resulting in
    broken re-use of HttpRequests
    + S8222980: Upgrade IANA Language Subtag Registry to Version
    2019-04-03
    + S8222987: sun/security/tools/keytool/PSS.java times out on
    Solaris-SPARC
    + S8222991: Xerces 2.12.0: Validation
    + S8223177: Data race on JvmtiEnvBase::_tag_map in
    double-checked locking
    + S8223227: Rename acquire_tag_map() to tag_map_acquire() in
    jvmtiEnvBase
    + S8223244: Fix usage of ARRAYCOPY_DISJOINT decorator
    + S8223336: Assert in
    VirtualMemoryTracker::remove_released_region when running the
    SharedArchiveConsistency.java test with
  - XX:NativeMemoryTracking=detail
    + S8223482: Unsupported ciphersuites may be offered by a TLS
    client
    + S8223518: Unexpected exception in jjs
    + S8223537: testlibrary_tests/ctw/ClassesListTest.java fails
    with Agent timeout frequently
    + S8223553: Fix code constructs that do not compile with the
    Eclipse Java Compiler
    + S8223572: ~ThreadInVMForHandshake() should call
    handle_special_runtime_exit_condition()
    + S8223574: add more thread-related system settings info to
    hs_error file on AIX
    + S8223660: jtreg: Decouple Unsafe from RTM tests
    + S8223814: SA: jhsdb common help needs to be more detailed
    + S8223886: Add in font table referene
    + S8224033: os::snprintf should be used in
    virtualizationSupport.cpp
    + S8224034: [TESTBUG] runtime/ErrorHandlerTest/ErrorHandler
    fails intermittently for case 13 on Windows
    + S8224090: [PPC64] Fix SLP patterns for filling an array with
    double float literals
    + S8224165: [TESTBUG] Docker tests produce excessive output
    + S8224181: On child process spawn, child may write to random
    file descriptor instead of the fail pipe
    + S8224202: Speed up Properties.load
    + S8224221: add memprotect calls to event log
    + S8224230: [PPC64, s390] Support AsyncGetCallTrace
    + S8224252: [TESTBUG]
    hotspot/test/serviceability/sa/sadebugd/SADebugDTest.java is
    timing out again after fix for JDK-8163805
    + S8224487: outputStream should not be copyable
    + S8224531: SEGV while collecting Klass statistics
    + S8224558: Fix replicateB encoding
    + S8224560: (tz) Upgrade time-zone data to tzdata2019a
    + S8224580: Matcher can cause oop field/array element to be
    reloaded
    + S8224589: Improve startup behavior of SecurityProperties
    + S8224658: Unsafe access C2 compile fails with assert(flat !=
    TypePtr::BOTTOM) failed: cannot alias-analyze an untyped ptr:
    adr_type = NULL
    + S8224698: ConcurrentSkipListMap.java does not compile with
    the Eclipse Java Compiler
    + S8224825: java/awt/Color/AlphaColorTest.java fails in
    linux-x64 system
    + S8224838: Bump update version for OpenJDK: jdk-11.0.5
    + S8224991: Problemlist
    javax/net/ssl/ServerName/SSLEngineExplorerMatchedSNI.java
    + S8225005: Xerces 2.12.0: License file
    + S8225141: Better handling of classes in error state in fast
    class initialization checks
    + S8225178: [Solaris] os::signal() should call sigaction() with
    SA_SIGINFO
    + S8225189: Multiple JNI calls within critical region in ZIP
    Library
    + S8225257: sun/security/tools/keytool/PSS.java timed out
    + S8225286: Better rendering of native glyphs
    + S8225298: Improve TLS connection support
    + S8225347: [s390] Unexpected exit from stack overflow test
    + S8225386: test for JDK-8216261 fails in Windows
    + S8225388: Running jcmd Compiler.CodeHeap_Analytics all 0
    cause crash.
    + S8225390: ProblemList sun/security/pkcs11/sslecc/
    /ClientJSSEServerJSSE.java due to JDK-8161536
    + S8225423: GTK L&F: JSplitPane: There is no divider shown
    + S8225425: java.lang.UnsatisfiedLinkError: net.dll: Can't find
    dependent libraries
    + S8225543: Jcmd fails to attach to the Java process on Linux
    using the main class name if whitespace options were used to
    launch the process
    + S8225580: tzdata2018i integration causes test failures on
    jdk-13
    + S8225636: SA can't handle prelinked libraries
    + S8225644: C1 dumps incorrect class name in ClassCastException
    message
    + S8225663: [testbug] Missing JNIEXPORT in XAbortProvoker
    native function
    + S8225715: jhsdb jmap fails to write binary heap dump of a
    jshell process
    + S8226409: Enable argument profiling for
    sun.misc.Unsafe.put*/get*
    + S8226468: [aix] loadquery failed error message displayed
    + S8226530: ZipFile reads wrong entry size from ZIP64 entries
    + S8226543: Reduce GC pressure during message digest
    calculations in password-based encryption
    + S8226607: Inconsistent info between pcsclite.md and MUSCLE
    headers
    + S8226798: JVM crash in
    klassItable::initialize_itable_for_interface(int,
    InstanceKlass*, bool, Thread*)
    + S8226964: [Yaru] GTK L&F: There is no difference between menu
    selected and de-selected
    + S8227011: Starting a JFR recording in response to JVMTI
    VMInit and / or Java agent premain corrupts memory
    + S8227041: runtime/memory/RunUnitTestsConcurrently.java has a
    memory leak
    + S8227117: normal interpreter table is not restored after
    single stepping with TLH
    + S8227247: tools/sjavac/IdleShutdown.java fails with
    AssertionError: Error too big on windows
    + S8227277: HeapInspection::find_instances_at_safepoint walks
    dead objects
    + S8227392: Colors with alpha are painted incorrectly on Linux,
    after JDK-8214579
    + S8227594: sadebugd/DebugdConnectTest.java fails due to
    "java.rmi.NotBoundException: SARemoteDebugger"
    + S8227630: adjust format specifiers in loadlib_aix.cpp
    + S8227834: build.log output from failing commands : include
    the hs_error file path in case of crashes in build
    + S8227869: fix wrong format specifiers in os_aix.cpp
    + S8227919: 8213232 causes crashes on solaris sparc64
    + S8228337: problemList failing/ignored manual tests in
    security-libs
    + S8228400: Remove built-in AArch64 simulator
    + S8228469: (tz) Upgrade time-zone data to tzdata2019b
    + S8228485: JVM crashes when bootstrap method for condy
    triggers loading of class whose static initializer throws
    ve thread creation fails
    + S8220579: [Containers] SubSystem.ja  exception
    + S8228501: java_props_macosx.c - provide missing CFRelease for
    CFLocaleCopyCurrent
    + S8228578: fix CFData object leak in macosx KeystoreImpl.m
    + S8228585: jdk/internal/platform/cgroup/TestCgroupMetrics.java
  - NumberFormatException because of large long values (memory
    limit_in_bytes)
    + S8228596: Class redefinition fails when condy instructions
    are removed
    + S8228601: AArch64: Fix interpreter code at JVMCI
    deoptimization entry
    + S8228618: s390: c1/c2 fail to add a metadata relocation in
    the static call stub.
    + S8228649: [PPC64] SA reads wrong slots from interpreter frames
    + S8228658: test GetTotalSafepointTime.java fails on fast Linux
    machines with Total safepoint time 0 ms
    + S8228711: Path rendered incorrectly when it goes outside the
    clipping region
    + S8228725: AArch64: Purge method call format support
    + S8228764: New library dependencies due to JDK-8222720
    + S8229118: [TESTBUG] serviceability/sa/ClhsdbFindPC fails on
    AArch64
    + S8229352: Use of an uninitialized register in 32-bit ARM
    template interpreter
    + S8229406: ZGC: Fix incorrect statistics
    + S8229767: Typo in java.security: Sasl.createClient and
    Sasl.createServer
    + S8229773: Resolve permissions for code source URLs lazily
    + S8229887: (zipfs) zip file corruption when replacing an
    existing STORED entry
    + S8229925: [s390, PPC64] Exception check missing in interpreter
    + S8230085: (fs) FileStore::isReadOnly is always true on macOS
    Catalina
    + S8230099: Prepare for backport of JDK-8217368
    + S8230728: Thin stroked shapes are not rendered if affine
    transform has flip bit
    + S8230850: Test sun/tools/jcmd/TestProcessHelper.java fails
    intermittently
    + S8231693: Backout "8230728: Thin stroked shapes are not
    rendered if affine transform has flip bit" from jdk11u
- Modified patch:
  * system-pcsclite.patch
    + adapt to changed context
* Wed Jul 17 2019 fstrba@suse.com
- Update to upstream tag jdk-11.0.4+11 (July 2019 CPU)
  * Security fixes
    + S8208698, CVE-2019-2745, bsc#1141784: Improved ECC
    Implementation
    + S8212328, CVE-2019-2762, bsc#1141782: Exceptional throw cases
    + S8213431, CVE-2019-2766, bsc#1141789: Improve file protocol
    handling
    + S8213432, CVE-2019-2769, bsc#1141783: Better copies of
    CopiesList
    + S8216381, CVE-2019-2786, bsc#1141787: More limited privilege
    usage
    + S8217563: Improve realm maintenance
    + S8218863: Better endpoint checks
    + S8218873: Improve JSSE endpoint checking
    + S8218876, CVE-2019-7317, bsc#1141780: Improve PNG support
    options
    + S8219775: Certificate validation improvements
    + S8220517: Enhanced GIF support
    + S8221345, CVE-2019-2818, bsc#1141788: Better Poly1305 support
    + S8221518, CVE-2019-2816, bsc#1141785: Normalize normalization
    + S8222678, CVE-2019-2821, bsc#1141781: Improve TLS negotiation
  * Other fixes
    + S6913047: Long term memory leak when using PKCS11 and JCE
    exceeds 32 bit process address space
    + S8139178: Wrong fontMetrics when printing in Landscape
    (OpenJDK)
    + S8163805: hotspot/test/serviceability/sa/sadebugd/
    /SADebugDTest.java failed with timed out
    + S8170494: JNI exception pending in PlainDatagramSocketImpl.c
    + S8174691: [TESTBUG] A number of native hotspot unit tests
    fail when executed in stand-alone mode
    + S8179098: Crypto AES/ECB encryption/decryption performance
    regression (introduced in jdk9b73)
    + S8181143: Introduce diagnostic flag to abort VM on too long
    VM operations
    + S8188133: C2: Static field accesses in clinit can trigger
    deoptimizations
    + S8190361: Incorrect version info in jaccessinspector.exe and
    jaccesswalker.exe
    + S8195793: Remove GTE CyberTrust Global Root
    + S8200286: (testbug) MOptionTest test fails with
    java.lang.AssertionError: Classfiles too old!
    + S8200613: SA: jstack throws UnmappedAddressException with a
    CDS core file
    + S8201317: X25519/X448 code improvements
    + S8201633: Problems with AES-GCM native acceleration
    + S8202353: os::readdir should use readdir instead of readdir_r
    + S8202414: Unsafe write after primitive array creation may
    result in array length change
    + S8202651: Test ComodoCA.java fails
    + S8202794: Native Unix code should use readdir rather than
    readdir_r
    + S8202884: SA: Attach/detach might fail on Linux if debugee
    application create/destroy threads during attaching
    + S8203627: Swing applications with JRadioButton and JCheckbox
    fail to render correctly when using GTK3 and the GTK L&F
    + S8204308: SA: serviceability/sa/TestInstanceKlassSize*.java
    fails when running in CDS mode
    + S8205574: Loop predication "assert(f <= 1 && f >= 0) failed
    Incorrect frequency"
    + S8205611: Improve the wording of LinkageErrors to include
    module and class loader information
    + S8206955: MethodHandleProxies.asInterfaceInstance does not
    support default methods
    + S8207340: (fs) UnixNativeDispatcher close and readdir usages
    should be fixed
    + S8207748: Fix for 8202794 breaks tier1 builds
    + S8207760: SAXException: Invalid UTF-16 surrogate detected:
    d83c ?
    + S8208634: Add x-IBM-1129 charset
    + S8208648: ECC Field Arithmetic Enhancements
    + S8208702: javax/swing/reliability/
    /HangDuringStaticInitialization.java may hang on macos
    + S8208996: X11 icon window color handing bug
    + S8209055: c.s.t.javac.code.DeferredCompletionFailureHandler
    seems to use WeakHashMap incorrectly
    + S8209414: AArch64: method handle invocation does not respect
    JVMTI interp_only mode
    + S8209415: Fix JVMTI test failure HS202
    + S8209573: [TESTBUG] gc/epsilon/TestMemoryMXBeans should retry
    on failure
    + S8209914: javadoc search sometimes generates bad URIs
    + S8209951: Problematic sparc intrinsic:
    com.sun.crypto.provider.CipherBlockChaining
    + S8210008: custom extension for make/SourceRevision.gmk
    + S8210197: javac can't tell during speculative attribution if
    a diamond expression is creating an anonymous inner class or
    not
    + S8210283: Support git as an SCM alternative in the build
    + S8210320: PPC64: Fix uninitialized variable in C1 LIR
    assembler code
    + S8210457: JVM crash in ResolvedMethodTable::add_method(Handle)
    + S8210483: AssertionError in DeferredAttr at setOverloadKind
    caused by JDK-8203679
    + S8210519: build/releaseFile/CheckSource.java failed additional
    sources found
    + S8210739: Calling JSpinner's setFont with null throws
    NullPointerException
    + S8210782: Upgrade HarfBuzz to the latest 2.3.1
    + S8210803: Compilation failure in codeBlob.cpp for Windows
    32-bit
    + S8210837: Add libXrandr-devel to the Linux devkits
    + S8210863: Remove Xrandr include files from JDK sources
    + S8210880: Remove HPKeysym.h from JDK sources
    + S8210886: Remove references in xwindows.md to non-existent
    files.
    + S8210899: (zipfs) ZipFileSystem.EntryOutputStreamCRC32
    mistakenly set the crc32 value into size field
    + S8211266: [TESTBUG] ZipFSTester.java failed intermittently in
    ZipFSTester.checkRead(): bound must be positive
    + S8211350: Remove jprt support
    + S8211393: Memory leak issue on awt_InputMethod.c
    + S8211435: Exception in thread "AWT-EventQueue-1"
    java.lang.IllegalArgumentException: null source
    + S8211698: Crash in C2 compiled code during execution of
    double array heavy processing code
    + S8211810: X11 Time stamp data should be unsigned
    + S8211826: StringIndexOutOfBoundsException happens via
    GetStringUTFRegion()
    + S8211841: [testbug] sun/nio/cs/OLD/TestIBMDB.java does not
    compile (aix)
    + S8211969: test/jdk/lib/security/CheckBlacklistedCerts.java
    searching for wrong paths
    + S8211971: Move security/cacerts/VerifyCACerts.java and
    security/CheckBlacklistedCerts.java
    + S8212202: [Windows] Exception if no printers are installed.
    + S8212205: VM asserts after CDS archive has been unmapped
    + S8212562: To remove lib/security from test/jdk/TEST.groups
    + S8212676: AWT SystemColor setting on CDE
    + S8212677: X11 default visual support for IM status window on
    VNC
    + S8212678: Windows IME related patch
    + S8212794: IBM-964 is required for AIX default charset
    + S8212828: (process) Provide a way for Runtime.exec to use
    posix_spawn on linux
    + S8213015: Inconsistent settings between JFR.configure and
  - XX:FlightRecorderOptions
    + S8213213: Remove src/java.desktop/unix/classes/sun/awt/
    /X11/keysym2ucs.h
    + S8213232: Unix/X11 setCompositionEnableNative issue
    + S8213292: Input freezes after MacOS key-selector (press&hold)
    usage on macOS Mojave
    + S8213294: Upgrade IANA LSR data
    + S8213515: Improve freetype detection on linux/ppc64/ppc64le/
    /s390x
    + S8213614: DnD operation change feature does not work with
    64bit big endian CPU
    + S8213617: JFR should record the PID of the recorded process
    + S8213618: IBM970 charset has missing entry and remove
    unexpected entries
    + S8213825: assert(false) failed: Non-balanced monitor
    enter/exit! Likely JNI locking
    + S8213944: Fix AIX build after the removal of Xrandr.h and add
    a configure check for it
    + S8214002: Cannot use italic font style if the font has
    embedded bitmap
    + S8214109: XToolkit is not correctly displayed color on 16-bit
    high color setting
    + S8214111: There is no icon in all JOptionPane target image
    + S8214112: The whole text in target JPasswordField image are
    not selected
    + S8214252: Expanded & Collapsed nodes of a JTree look the same
    on GTK3
    + S8214253: Tooltip is transparent rather than having a black
    background
    + S8214468: jQuery UI upgrade from 1.11.4 to 1.12.1
    + S8214533: IBM-29626C is required for AIX default charset
    + S8214765: All TrayIcon MessageType icons does not show up
    with gtk3 option set
    + S8214935: Upgrade IANA LSR data
    + S8215026: Incorrect amount of memory unmapped with
    ImageFileReader::close()
    + S8215123: Crash in runtime image built with jlink --compress=2
    + S8215284: Reduce noise induced by periodic task getFileSize()
    + S8215296: do not disable c99 on Solaris
    + S8215342: [Zero] Build fails after JDK-8200613
    + S8215364: JavaFX crashes on Ubuntu 18.04 with Wayland while
    using Swing-FX interop
    + S8215374: 32-bit build failures after JDK-8181143 (Introduce
    diagnostic flag to abort VM on too long VM operations)
    + S8215398: -Xlog option usage => Invalid decorator
    '\temp\app_cds.log'.
    + S8215443: The use of TransportContext.fatal() leads to bad
    coding style
    + S8215472: (zipfs) Cleanups in implementation classes of
    jdk.zipfs and tests
    + S8215707: [macosx] fix pthread_getschedparam and
    pthread_setschedparam calls
    + S8215757: C2: PhaseIdealLoop::create_new_if_for_predicate()
    computes wrong IDOM
    + S8215790: Delegated task created by SSLEngine throws
    java.nio.BufferUnderflowException
    + S8216045: The size of key_exchange may be wrong on FFDHE
    + S8216355: missing NULL checks in libnet in interface iteration
    and potential resource leak in getMacAddress
    + S8216556: Unnecessary liveness computation with JVMTI
    + S8216577: Add GlobalSign's R6 Root certificate
    + S8216597: SIGBUS in
    Java_sun_security_pkcs11_wrapper_PKCS11_getNativeKeyInfo
    after JDK-6913047
    + S8216970: condy causes JVM crash
    + S8217088: Disable JDK-6913047 fix (SunPKCS11 memory leak)
    after JDK-8216597 (SIGBUS error in getNativeKeyInfo)
    + S8217094: HttpClient SSL race if a socket IOException is
    raised before ALPN is available
    + S8217263: Automate DashOffset test
    + S8217311: Improve Exception thrown when
    MulticastSocket.setInterface fails on AIX(Unix)
    + S8217564: idempotent protection missing in crc32c.h
    + S8217647: JFR: recordings on 32-bit systems unreadable
    + S8217690: Update public suffix version
    + S8217707: JNICALL declaration breaks Splash screen functions
    + S8217765: Internal Error (javaCalls.cpp:61)
    guarantee(thread->can_call_java()) failed
    + S8217786: Provide virtualization related info in the hs_error
    file on linux s390x
    + S8217878: ENVELOPING XML signature no longer works in JDK 11
    + S8217879: hs_err should print more instructions in hex dump
    + S8217880: AIX build issue after JDK-8214533
    + S8218020: Fix version number in mesa.md 3rd party legal file
    + S8218060: JDK-8217786 breaks build due to remaining unused
    function
    + S8218063: JDK-8218060 breaks build for S390
    + S8218152: [javac] fails and exits with no error if a bad
    annotation processor provided
    + S8218469: JSlider display issue with slider for GTKLookAndFeel
    + S8218470: JScrollBar display issue with GTKLookAndFeel
    + S8218472: JProgressBar display issue with GTKLookAndFeel
    + S8218473: JOptionPane display issue with GTKLookAndFeel
    + S8218479: JTextPane display issue with GTKLookAndFeel
    + S8218618: Program fails when using JDK addressed by UNC path
    and using Security Manager
    + S8218629: XML Digital Signature throws NAMESPACE_ERR exception
    on OpenJDK 11, works 8/9/10
    + S8218674: HTML Tooltip with "img=src" on component doesn't
    show
    + S8218733: SA: CollectedHeap provides broken implementation for
    used() and capacity()
    + S8218781: Localized names for Japanese era Reiwa in COMPAT
    provider
    + S8218811: replace open by os::open in hotspot coding
    + S8218854: FontMetrics.getMaxAdvance may be less than the
    maximum FontMetrics.charWidth
    + S8218960: CONFIG level logging statements printed in
    CLDRCalendarDataProviderImpl.java even when default log Level
    is INFO
    + S8218991: s390: Add intrinsic for GHASH algorithm
    + S8219006: AArch64: Register corruption in slow subtype check
    + S8219011: Implement MacroAssembler::warn method on AArch64
    + S8219112: name_and_sig_as_C_string usages in frame_s390 miss
    ResourceMark
    + S8219335: "failed: unexpected type" assert failure in
    ConnectionGraph::split_unique_types() with unsafe accesses
    + S8219389: Delegated task created by SSLEngine throws
    BufferUnderflowException
    + S8219414: SA: jhsdb jsnap throws UnmappedAddressException with
    core generated by gcore
    + S8219448: split-if update_uses accesses stale idom data
    + S8219460: ppc: adjust NativeGeneralJump::insert_unconditional
    to stack allocated MacroAssembler
    + S8219566: JFR did not collect call stacks when
    MaxJavaStackTraceDepth is set to zero
    + S8219574: Minimal VM build failure after JDK-8219414
    + S8219582: PPC: Crash after C1 checkcast patched and GC
    + S8219584: Try to dump error file by thread which causes
    safepoint timeout
    + S8219698: aarch64: SIGILL triggered when specifying
    unsupported hardware features
    + S8219710: Bump update version for OpenJDK: jdk11.0.4
    + S8219746: Provide virtualization related info in the hs_error
    file on linux ppc64 / ppc64le
    + S8219915: [TESTBUG] Fix test langtools/tools/javac/processing/
    /model/completionfailure/SymbolsDontCumulate.java in
    Standalone mode
    + S8219918: ProblemList hotspot tests failing in SAP testing.
    + S8220165: Encryption using GCM results in RuntimeException-
    input length out of bound
    + S8220166: Performance regression in deserialization (4-6%% in
    SPECjbb)
    + S8220198: Lots of com/sun/crypto/provider/Cipher tests fail
    on x86_32 due to missing SHA512 stubs
    + S8220281: IBM-858 alias name is missing on IBM00858 charset
    + S8220293: Deadlock in JFR string pool
    + S8220349: The fix done for JDK-8214253 have caused issues in
    JTree behaviour
    + S8220353: [TESTBUG] TestRegisterRestoring uses SafepointALot
    without UnlockDiagnosticVMOptions
    + S8220374: C2: LoopStripMining doesn't strip as expected
    + S8220441: [PPC64] Clobber memory effect missing for memory
    barriers in atomics
    + S8220495: Update GIFlib library to the 5.1.8
    + S8220513: Wrapper Key may get deleted when closing sessions in
    SunPKCS11 crypto provider
    + S8220625: tools/javac/classreader/8171132/
    /BadConstantValue.java failed with "did not see expected
    error"
    + S8220707: [TESTBUG] serviceability/sa/
    /TestHeapDumpForLargeArray.java fails with jtreg
  - vmoption:-Xmx < 8g
    + S8220714: C2 Compilation failure when accessing off-heap
    memory using Unsafe
    + S8220718: Missing ResourceMark in nmethod::metadata_do
    + S8220781: linux-s390 : os::get_summary_cpu_info gives bad
    output
    + S8220794: PPC64: Fix signal handler for SIGSEGV on branch to
    illegal address
    + S8221083: [ppc64] Wrong oop compare in C1-generated code
    + S8221175: Fix bad function case for controlled JVM crash on
    PPC64 big-endian
    + S8221244: Unexpected behavior of
    PropertyDescription.getReadMethod for boolean properties
    + S8221263: [TEST_BUG] RemotePrinterStatusRefresh test is hard
    to use
    + S8221304: Problem list java/awt/FontMetrics/
    /MaxAdvanceIsMax.java
    + S8221400: java/lang/String/StringRepeat.java test requests
    too much heap
    + S8221401: java/math/BigInteger/LargeValueExceptions.java test
    should be disabled on 32-bit platforms
    + S8221412: lookupPrintServices() does not always update the
    list of Windows remote printers
    + S8221437:
    assert(java_lang_invoke_ResolvedMethodName::vmtarget(resolved_method())
    == m()) failed: Should not change after link resolution
    + S8221470: Print methods in exception messages in java-like
    Syntax.
    + S8221479: Fix JFR profiling on s390
    + S8221483: TestOopCmp.java fails due to "Multiple garbage
    collectors selected"
    + S8221535: add steal tick related information to hs_error file
    [linux]
    + S8221610: Resurrect (legacy) JRE bundle target
    + S8221639: [i386] expand_exec_shield_cs_limit workaround is
    undefined code after JDK-8199717
    + S8221833: Readability check in Symbol::is_valid not performed
    for some addresses
    + S8221870: use driver to run CtwRunner in applications/ctw
    tests
    + S8221880: Better customization for Windows RC properties
    FileDescription and ProductName
    + S8221915: cleanup ticks related coding in os_perf_aix.cpp
    [aix]
    + S8221917: serviceability/sa/TestPrintMdo.java fails on 32-bit
    platforms
    + S8221924: get(null) on single-entry unmodifiable Map returns
    null instead of throwing NPE
    + S8222027: java/util/logging/LogManager/TestLoggerNames.java
    generates intermittent ClassCastException
    + S8222032: x86_32 fails with "wrong size of mach node" on
    AVX-512 machine
    + S8222089: [TESTBUG] sun/security/lib/cacerts/
    /VerifyCACerts.java fails due to cert within 90-day expiry
    window
    + S8222133: Add temporary exceptions for root certs that are
    due to expire soon
    + S8222136: Remove two Comodo root CA certificates that are
    expiring
    + S8222137: Remove T-Systems root CA certificate
    + S8222397: x86_32 tests with UseSHA1Intrinsics SEGV due to
    garbled registers
    + S8222410: java/nio/file/attribute/BasicFileAttributeView/
    /UnixSocketFile hangs when "nc" does not accept "-U"
    + S8222522: Add configure options for Mac Bundle creation
    + S8222532: (zipfs) Performance regression when writing
    ZipFileSystem entries in parallel
    + S8222913: Add Jib support for VERSION_EXTRA*
    + S8222930: ConcurrentSkipListMap.clone() shares size variable
    between original and clone
    + S8223266: PPC64: Check for branch to illegal address before
    checking for mem serialization
    + S8223395: PPC64: Improve comments in the JVM signal handler
    to match ISA text
    + S8223499: Remove two DocuSign root certificates that are
    expiring
    + S8223555: Cleanups in cacerts tests
    + S8223597: jdk/nio/zipfs/ZipFSTester.java RuntimeException:
    CHECK_FAILED! (getAttribute.crc <entries20> failed 6af4413c
    vs 0 ...)
    + S8223665: SA: debugd options should follow jhsdb style
    + S8224474: harfbuzz 2.3.1 code fails to compile with gcc
    4.4.7
    + S8224671: AArch64: mauve System.arraycopy test failure
    + S8224727: Problem list test security/infra/java/security/cert/
    /CertPathValidator/certification/ActalisCA.java
    + S8224828: aarch64: rflags is not correct after safepoint poll
    + S8224880: AArch64: java/javac error with
    AllocatePrefetchDistance
    + S8225402: events logging in deoptimization.cpp should go to
    deopt-log
    + S8225716: G1 GC: Undefined behaviour in
    G1BlockOffsetTablePart::block_at_or_preceding
    + S8226876: Assertion in sun/util/locale/provider/
    /CalendarDataUtility on Windows after JDK-8218960
    + S8226880: Backport of JDK-8208698 (Improved ECC
    Implementation) should not bring parts of JDK-8205476
    (KeyAgreement#generateSecret is not reset for ECDH based
    algorithm)
* Fri Jul  5 2019 fstrba@suse.com
- Do not fail installation when the manpages are not present
  (bsc#1115375)
* Fri Jul  5 2019 fstrba@suse.com
- Added patch:
  * JDK-8208602.patch
    + Backport upstream fix for JDK-8208602: Cannot read PEM X.509
    cert if there is whitespace after the header or footer
    (bsc#1140461)
* Tue Jun  4 2019 fstrba@suse.com
- Provide and Obsolete the corresponding java-10-openjdk-<sub>
  packages to assure smooth upgrade (fate#326347, bsc#1137264)
* Mon May 27 2019 fstrba@suse.com
- Set alternative priority in SLE12 to 0 in order to be able to
  push to SLE12-SP5 (fate#326790, jsc#SLE-5715)
* Tue Apr 23 2019 fstrba@suse.com
- Require update-ca-certificates by the headless subpackage
  (bsc#1131378)
- Removed patch:
  * java11-improved-fonts.patch
    + broken with the recent changes in font rendering
* Wed Apr 17 2019 fstrba@suse.com
- Update to upstream tag jdk-11.0.3+7 (April 2019 CPU)
  * Security fixes
    + S8211936, CVE-2019-2602, bsc#1132728: Better String parsing
    + S8214809: CDS storage improvements
    + S8218453, CVE-2019-2684, bsc#1132732: More dynamic RMI
    interactions
  * Other changes
    + S8034802: (zipfs) newFileSystem throws UOE when the zip file
    is located in a custom file system
    + S8165675: Trace event for thread park has incorrect unit for
    timeout
    + S8172695: (scanner) java/util/Scanner/ScanTest.java fails
    + S8187364: Unable to enter zero width non-joiner (ZWNJ) symbol
    in Swing text component
    + S8197398: (zipfs) Files.walkFileTree walk indefinitelly while
    processing JAR file with "/" as a directory inside.
    + S8200109: NMT: diff_malloc_site assert(early->flags() ==
    current->flags(), "Must be the same memory type")
    + S8201818: [macosx] Printing attributes break page size set via
    "java.awt.print.Book" object
    + S8204142: AWT hang occurs when sequenced events arrive out of
    sequence in multiple AppContexts
    + S8205432: Replace the placeholder Japanese era name
    + S8206120: Add test cases for lenient Japanese era parsing
    + S8207070: Webstart app popup on wrong screen in a one-screen
    setup changing to multi-monitor
    + S8207258: Distrust TLS server certificates anchored by
    Symantec Root CAs
    + S8207760: SAXException: Invalid UTF-16 surrogate detected:
    d83c ?
    + S8207829: FlightRecorderMXBeanImpl is leaking the first
    classloader which calls it
    + S8207849: Allow the addition of more number to the Java
    version string
    + S8208275: C2 crash in Node::add_req(Node*)
    + S8208656: Move java/util/Calendar/CalendarTestScripts tests
    into OpenJDK
    + S8209615: ParseError in XMLEventReader on a valid input
    + S8209758: 2 classes with same name G1PrintCollectionSetClosure
    cause crash when logging is enabled
    + S8209960: -Xlog:jfr* doesn't work with the JFR
    + S8210192: Hsperf counter ParNew::CMS should be ParNew:CMS
    + S8210394: (zipfs) jdk/nio/zipfs/ZFSTests.java rootdir.zip: The
    process cannot access the file because it is being used by
    another process
    + S8210633: Cannot parse JapaneseDate string with
    DateTimeFormatterBuilder Mapped-values
    + S8210874: Test for JDK-8209615
    + S8210974: No extensions debug log for ClientHello
    + S8210989: RSASSA-PSS certificate cannot be selected for client
    auth on TLSv1.2
    + S8211049: Second parameter of "initialize" method is not used
    + S8211064: [AArch64] Interpreter and c1 don't correctly handle
    jboolean results in native calls
    + S8211100: hotspot C1 issue with comparing long numbers on x86
    32-bit
    + S8211163: UNIX version of Java_java_io_Console_echo does not
    return a clean boolean
    + S8211267: StackOverflowError happened by
    TextField.setFont(...)
    + S8211295: DriverManager.getConnection fails when called from
    com.sun.rowset.JdbcRowSetImpl
    + S8211320: Aarch64: unsafe.compareAndSetByte() and
    unsafe.compareAndSetShort() c2 intrinsics broken with negative
    expected value
    + S8211382: ISO2022JP and GB18030 NIO converter issues
    + S8211398: Square character support for the Japanese new era
    + S8211698: Crash in C2 compiled code during execution of double
    array heavy processing code
    + S8211765: JarFile constructor throws undocumented exception
    + S8211787: javax/net/ssl/TLSCommon/TLSTest.java throws
    java.net.SocketTimeoutException: Read timed out
    + S8211821: PrintStringTableStatistics crashes JVM
    + S8212173: Thread._stack_base/_stack_size initialized too late
    for new threads
    + S8212232: Wrong metadata for the configuration of the cutoff
    for old object sample events
    + S8212233: javadoc fails on jdk12 with "The code being
    documented uses modules but the packages defined in $URL are
    in the unnamed module."
    + S8212885: TLS 1.3 resumed session does not retain peer
    certificate chain
    + S8212941: Support new Japanese era in
    java.time.chrono.JapaneseEra
    + S8213183: InputMethod cannot be used after its restarting
    + S8213202: Possible race condition in TLS 1.3 session resumption
    + S8213419: C2 may hang in MulLNode::Ideal()/MulINode::Ideal()
    with gcc 8.2.1
    + S8213421: Line number information for execution samples
    always 0
    + S8213583: Error while opening the JFileChooser when desktop
    contains shortcuts pointing to deleted files
    + S8213754: PPC64: Add Intrinsics for
    isDigit/isLowerCase/isUpperCase/isWhitespace
    + S8213782: NullPointerException in
    sun.security.ssl.OutputRecord.changeWriteCiphers
    + S8213829: Remove circular dependency between g1CollectedHeap
    and g1ConcurrentMark
    + S8213952: Relax DNSName restriction as per RFC 1123
    + S8213966: The ZGC JFR events should be marked as experimental
    + S8213983: [macosx] Keyboard shortcut ?cmd +`? stops working
    properly if popup window is displayed
    + S8214063: OpenJDK will not build on AIX while using the xlc
    13.1 compiler
    + S8214100: use of keystore probing results in unnecessary
    exception thrown
    + S8214118: HeapRegions marked as archive even if CDS mapping
    fails
    + S8214122: JDWP is broken on 32 bit Windows: transport library
    missing onLoad entry
    + S8214129: SSL session resumption/SNI with TLS1.2 causes
    StackOverflowError
    + S8214189: test/hotspot/jtreg/compiler/intrinsics/mathexact/
    /MulExactLConstantTest.java fails on Windows x64 when run with
  - XX:-TieredCompilation
    + S8214206: Fix for JDK-8213419 is broken on 32-bit
    + S8214339: SSLSocketImpl erroneously wraps SocketException
    + S8214352: C1: Unnecessary "compilation bailout: block join
    failed" with JVMTI
    + S8214451: PPC64/s390: Clean up unused CRC32 prototype and
    function
    + S8214513: A PKCS12 keystore from Java 8 using custom PBE
    parameters cannot be read in Java 11
    + S8214688: TLS 1.3 session resumption with hello retry request
    failed with "illegal_parameter"
    + S8214827: Incorrect call
    ClassLoaders.toFileURL("jrt:/java.compiler")
    + S8215100: AArch64: fix compareTo intrinsic with four-character
    Latin/Unicode
    + S8215175: Inconsistencies in JFR event metadata
    + S8215202: AArch64: jtreg test
    test/jdk/sun/nio/cs/FindEncoderBugs.java fails
    + S8215317: [GRAAL] unit test CheckGraalIntrinsics failed after
    8213754
    + S8215330: javax.xml.catalog.CatalogResolverImpl:
    GroupEntry.matchURI fails to match
    + S8215362: JFR GTest JfrTestNetworkUtilization fails
    + S8215397: jsig.c missing classpath exception
    + S8215727: Restore JFR thread sampler loop to old / previous
    behavior
    + S8215947: JVM crash with -XX:+DumpSharedSpaces
    + S8215951: AArch64: jtreg test
    vmTestbase/nsk/jvmti/PopFrame/popframe005 segfaults
    + S8215962: Support ThreadPriorityPolicy mode 1 for non-root
    users on linux/bsd
    + S8216049: stringTable::intern creates redundant String when
    looking up existing one
    + S8216060: [PPC64] Vector CRC implementation should be used by
    interpreter and be faster for short arrays
    + S8216280: Allow later Symantec Policy distrust date for two
    Apple SubCAs
    + S8216302: StackTraceElement::fill_in can use cached Class.name
    + S8216308: StackTraceElement::fill_in can use injected Class
    source-file
    + S8216350: AArch64: monitor unlock fast path not called
    + S8216546: Support new Japanese era in java.lang.Character for
    Java SE 11
    + S8216578: Remove unused/obsolete method in JFR code
    + S8216965: crash in freetypeScaler.c CopyBW2Grey8
    + S8217014: Epsilon should not ignore Metadata GC causes
    + S8217315: Proper units should print more significant digits
    + S8217321: [TESTBUG] utilities/test_globalDefinitions.cpp
    should use _LP64, not LP64
    + S8217342: Build failed with excluding JFR
    + S8217378: UseCriticalCMSThreadPriority is broken
    + S8217427: (dc) nio/channels/DatagramChannel/UseDGWithIPv6.java
    fails without IPv6
    + S8217432: MetaspaceGC::_capacity_until_GC exceeds
    MaxMetaspaceSize
    + S8217459: [PPC64] Cleanup non-vector version of CRC32
    + S8217471: [TESTBUG] gc/epsilon/TestClasses.java fails on some
    platforms - OOME Metaspace
    + S8217520: Remove vm.opt.MaxGCPauseMillis == "null" from
    TestOldGenCollectionUsage.java
    + S8217579: TLS_EMPTY_RENEGOTIATION_INFO_SCSV is disabled after
    8211883
    + S8217597: [TESTBUG] old version docker does not support --cpus
    + S8217609: New era placeholder not recognized by
    java.text.SimpleDateFormat
    + S8217628: Verbose ArrayIndexOutOfBoundsException message also
    in JNI calls.
    + S8217657: Move the test for default value of
    jdk.includeInExceptions into own test
    + S8217994: os::print_hex_dump should be more resilient against
    unreadable memory
    + S8218156: "jcmd VM.metaspace basic" misreports free chunk
    space
    + S8218192: Remove copy constructor for MemRegion
    + S8218915: Change isJavaIdentifierStart and
    isJavaIdentifierPart to handle new code points
    + S8219251: Langtools tests default memory size needs to be 768m
    + S8219260: Default number of test jobs needs to be consistently
    calculated
    + S8219461: Bump update version for OpenJDK jdk11.0.3
    + S8219650: [Testbug] Fix potential crashes in new test hotspot
    gtest "test_print_hex_dump"
    + S8219651: compiler/ciReplay/TestServerVM.java is failing on
    windows
    + S8219714: [testbug] com/sun/jdi/RedefineNestmateAttr/
    /TestNestmateAttr.java must pass classpath to subprocess
    + S8219789: [TESTBUG] TestOptionsWithRanges.java produces
    hs_err_pidXXXXX.log file for
    VMThreadStackSize=9007199254740991
    + S8219890: Calendar.getDisplayName() returns empty string for
    new Japanese Era on some locales
    + S8220283: ZGC fails to build on GCC 4.4.7: ATTRIBUTE_ALIGNED
    compatibility issue
    + S8220294: ZGC fails to build on GCC 4.4.7: Type parameter
    issue
    + S8221769: Revert JDK-8221767 mistakenly pushed to jdk11u
    11.0.3
- Modified patch:
  * java11-improved-fonts.patch
    + Adapted to changed context
* Wed Jan 16 2019 fstrba@suse.com
- Update to upstream tag jdk-11.0.2+7 (Oracle January 2019 CPU)
  * Security fixes:
    + S8206290, CVE-2019-2422, bsc#1122293: Better FileChannel
    transfer performance
    + S8209094, CVE-2019-2426: Improve web server connections
    + S8210866, CVE-2018-11212, bsc#1122299: Improve JPEG
    processing
  * Security-In-Depth fixes:
    + S8199156: Better route routing
    + S8199161: Better interface enumeration
    + S8199166: Better interface lists
    + S8199552: Update to build scripts
    + S8200659: Improve BigDecimal support
    + S8203955: Improve robot support
    + S8204895: Better icon support
    + S8205356: Choose printer defaults
    + S8205709: Proper allocation handling
    + S8205714: Initial class initialization
    + S8206295: More reliable p11 transactions
    + S8206301: Improve NIO stability
    + S8210094: Better loading of classloader classes
    + S8210598: Strengthen Windows Access Bridge Support
    + S8210606: Improved data set handling
    + S8210610: Improved LSA authentication
    + S8210870: Libsunmscapi improved interactions
  * Fixes
    + S8021335: Missing synchronization when reading counters for
    live threads and peak thread count
    + S8027434: "-XX:OnOutOfMemoryError" uses fork instead of vfork
    + S8029661: Support TLS v1.2 algorithm in SunPKCS11 provider
    + S8170937: Swing apps are slow if displaying from a remote
    source to many local displays
    + S8196902: Better HTTP Redirection
    + S8203688: [testbug] Nashorn test
    test/nashorn/script/nosecurity/treeapi/diagnostic.js fails
    + S8203850: java.net.http HTTP client should allow specifying
    Origin and Referer headers
    + S8205330: InitialDirContext ctor sometimes throws NPE if the
    server has sent a disconnection
    + S8205507: jdk/javax/xml/crypto/dsig/GenerationTests.java
    timed out
    + S8205633: TestOptionsWithRanges.java of
    '-XX:TLABSize=2147483648' fails intermittently
    + S8206075: On x86, assert on unbound assembler Labels used as
    branch targets
    + S8206107: [x86_32] jck tests for ldc2_w bytecode fail
    + S8207059: Update test certificates in QuoVadisCA.java test
    + S8207150: Clip.isRunning() may return true after Clip.stop()
    was called
    + S8207343: Automate vtable/itable stub size calculation
    + S8207395: jar has issues with UNC-path arguments for the jar
  - C parameter [windows]
    + S8207810: Remove jdk-11.0.1+2 tag from source repository
    + S8207924: serviceability/sa/TestUniverse.java#id0
    intermittently fails with
    assert(get_instanceKlass()->is_loaded()) failed: must be at
    least loaded
    + S8208209: Improve TLS connection stability again
    + S8208350: Disable all DES cipher suites
    + S8208480: Test failure: assert(is_bound() || is_unused())
    after JDK-8206075 in C1
    + S8208638: Instead of circle rendered in appl window, but
    ellipse is produced JEditor Pane
    + S8208647: switch jtreg to 4.2b13
    + S8208661: JDK 11.0.1 l10n resource file update
    + S8208754: The fix for JDK-8194534 needs updates
    + S8209357: [PPC64] Fix build which was broken by 8208672
    (Enable -Wreorder)
    + S8209433: [s390] Fix build, broken by 8208672 (Enable
  - Wreorder)
    + S8209511: C2 asserts with UseSSE < 4 and AVX enabled: "Label
    was never bound to a location, but it was used as a jmp target'
    + S8209544: AES encrypt performance regression in jdk11b11
    + S8209576: java.nio.file.Files.writeString writes garbled
    UTF-16 instead of UTF-8
    + S8209588: SIGSEGV in MethodArityHistogram() with
  - XX:+CountCompiledCalls
    + S8209916: NPE in SupportedGroupsExtension
    + S8209950: SIGBUS in CodeHeapState::print_names()
    + S8209965: The "supported_groups" extension in ServerHellos
    + S8210040: TestOptionsWithRanges.java is very slow
    + S8210043: Invalid assert(HeapBaseMinAddress > 0) in
    ReservedHeapSpace::initialize_compressed_heap
    + S8210319: [s390]: Use of shift operators not covered by cpp
    standard
    + S8210334: TLS 1.3 server fails if ClientHello doesn't have
    pre_shared_key and psk_key_exchange_modes
    + S8210345: The Japanese message of FileNotFoundException
    garbled
    + S8210355: Minimal and Zero non-PCH builds fail after
    JDK-8207343 (Automate vtable/itable stub size calculation)
    + S8210357: Zero builds fail after JDK-8207343 (Automate
    vtable/itable stub size calculation)
    + S8210416: [linux] Poor StrictMath performance due to
    non-optimized compilation
    + S8210425: [x86] sharedRuntimeTrig/sharedRuntimeTrans compiled
    without optimization
    + S8210432: Add additional TeliaSonera root certificate
    + S8210490: TimeZone.getDisplayName given Locale.US doesn't
    always honor the Locale.
    + S8210695: Create test to cover JDK-8205330 InitialDirContext
    ctor sometimes throws NPE if the server has sent a disconnection
    + S8210754: print_location is not reliable enough (printing
    register info)
    + S8210764: Update avx512 implementation
    + S8210846: TLSv.1.3 interop problems with OpenSSL 1.1.1 when
    used on the client side with mutual auth
    + S8210912: Build error in src/jdk.crypto.cryptoki/share/native/
    /libj2pkcs11/p11_convert.c after JDK-8029661
    + S8210918: Add test to exercise server-side client hello
    processing
    + S8210964: add more ld preloading related info to hs_error
    file on Linux
    + S8211061: Tests fail with
    assert(VM_Version::supports_sse4_1()) on ThreadRipper CPU
    + S8211106: [windows] Update OS detection code to recognize
    Windows Server 2019
    + S8211107: LDAPS communication failure with jdk 1.8.0_181
    + S8211124: HotSpot update for vm_version.cpp to recognise
    updated VS2017
    + S8211231: BarrierSetC1::generate_referent_check() confuses
    register allocator
    + S8211251: Default mask register for avx512 instructions
    + S8211268: Disable unsupported GCs for Zero
    + S8211272: x86_32 build failures after JDK-8210764 (Update
    avx512 implementation)
    + S8211375: Minimal VM build failures after JDK-8211251
    (Default mask register for avx512 instructions)
    + S8211420: com.sun.net.httpserver.HttpServer returns
    Content-length header for 204 response code
    + S8211437: 8211437 java.net.http.HttpClient hangs on 204 reply
    without Content-length 0
    + S8211451: ~2.5%% regression on compression benchmark starting
    with 12-b11
    + S8211714: Need to update vm_version.cpp to recognise VS2017
    minor versions
    + S8211731: Reconsider default option for ClassPathURLCheck
    change done in JDK-8195874
    + S8211806: TLS 1.3 handshake server name indication is missing
    on a session resume
    + S8211844: [aix] ProcessBuilder: Piping between created
    processes does not work.
    + S8211852: inspect stack during error reporting
    + S8211883: Disable anon and NULL cipher suites
    + S8211909: JDWP Transport Listener: dt_socket thread crash
    + S8211926: Catastrophic size_t underflow in BitMap::*_large
    methods
    + S8211931: [ppc][testbug] runtime/jni/terminatedThread/
    /TestTerminatedThread.java fails as threads don't terminate
    immediately
    + S8212005: Epsilon elastic TLAB sizing may cause misalignment
    + S8212070: Introduce diagnostic flag to abort VM on failed JIT
    compilation
    + S8212100: AppCDS crashes for some uses with JRuby
    + S8212116: IIOException "tEXt chunk length is not proper" on
    opening png file
    + S8212177: Epsilon alignment adjustments can overflow max TLAB
    size
    + S8212178: Soft reference reclamation race in
    com.sun.xml.internal.stream.util.ThreadLocalBufferAllocator
    + S8212197: OpenDataException thrown when constructing
    CompositeData for StackTraceElement
    + S8212481: PPC64: Enable POWER9 CPU detection
    + S8212613: Bump update version for jdk11.0.2 cpu forest
    + S8212645: Need change jdk 11.0.2 milestone to ea
    + S8212754: Build failure: undefined
    JvmtiSampledObjectAllocEventCollector::object_alloc_is_safe_to_sample
    + S8212795: ThreadInfoCompositeData.toCompositeData fails to
    map ThreadInfo to CompositeData
    + S8212926: HttpClient does not retrieve files with large sizes
    over HTTP/1.1
    + S8212937: Parent class loader may not have a referred
    ClassLoaderData instance when obtained in
    Klass::class_in_module_of_loader
    + S8213085: (tz) Upgrade time-zone data to tzdata2018g
    + S8213086: Compiler thread creation should be bounded by
    available space in memory and Code Cache
    + S8213151: [AIX] Some class library files are missing the
    Classpath exception
    + S8213154: Update copyright headers of files in src tree that
    are missing Classpath exception
    + S8213367: JDK 11.0.2 l10n resource file update
    + S8213410: UseCompressedOops requirement check fails fails on
    32-bit system
    + S8213527: [testbug] Fix PrintMetaspaceDcmd test using
    UseCompressedOops for 32-bit.
    + S8213763: Need change jdk 11.0.2 milestone to fcs
    + S8213834: JVMTI ResourceExhausted should not be posted in
    CompilerThread
    + S8213942: URLStreamHandler initialization race
    + S8213992: Rename and make DieOnSafepointTimeout the
    diagnostic option
    + S8214059: Undefined behaviour in ADLC
    + S8214061: Buffer written into itself
    + S8214105: [TESTBUG] Bit test is always false in
    serviceability/jvmti/StartPhase/AllowedFunctions
    + S8214108: [TESTBUG] Incorrect Function parameter lists in
    vmTestbase/nsk/jvmti/scenarios/extension/EX03/ex03t001
    + S8214295: Populate handlers while holding streamHandlerLock
    + S8214476: ZGC: Build ZGC by default
    + S8214892: Delayed starting of debugging via jcmd
    + S8215128: Test library OSInfo.getSolarisVersion cannot
    determine Solaris version
    + S8215637: client VM variant build error: zgc (enabled)
    depends on opto (disabled)
    + S8215975: [testbug] Adapt nsk tests to the PPC, S390 and AIX
    platforms.
    + S8216290: Register to register spill may use AVX 512 move
    instruction on unsupported platform.
* Thu Jan 10 2019 fstrba@suse.com
- Added patch:
  * loadAssistiveTechnologies.patch
    + Do not crash the whole JVM if assistive technologies crash
* Thu Jan 10 2019 fstrba@suse.com
- Do not resolve by default the added JavaEE modules (fixes
  bsc#1120431)
* Thu Oct 25 2018 antoine.belvire@opensuse.org
- Remove hardcoded Java version in jconsole desktop file.
* Tue Oct 23 2018 fstrba@suse.com
- Merge into the JDK following modules from github.com/javaee:
  * com.sum.xml.fastinfoset
  * org.jvnet.staxex
  * com.sun.istack.runtime
  * com.sun.xml.txw2
  * com.sun.xml.bind
    + This provides a default implementation of JAXB-API that
    existed in JDK before Java 11 and that some applications
    depend on.
* Wed Oct 17 2018 fstrba@suse.com
- Update to upstream tag jdk-11.0.1+13 (Oracle October 2018 CPU)
  * Security fixes:
    + S8202936, CVE-2018-3183, bsc#1112148: Improve script engine
    support
    + S8199226, CVE-2018-3169, bsc#1112146: Improve field accesses
    + S8199177, CVE-2018-3149, bsc#1112144: Enhance JNDI lookups
    + S8202613, CVE-2018-3180, bsc#1112147: Improve TLS connections
    stability
    + S8208209, CVE-2018-3180, bsc#1112147: Improve TLS connection
    stability again
    + S8199172, CVE-2018-3150, bsc#1112145: Improve jar attribute
    checks
    + S8200648, CVE-2018-3157, bsc#1112149: Make midi code more
    sound
    + S8194534, CVE-2018-3136, bsc#1112142: Manifest better support
    + S8208754, CVE-2018-3136, bsc#1112142: The fix for JDK-8194534
    needs updates
    + S8196902, CVE-2018-3139, bsc#1112143: Better HTTP Redirection
  * Security-In-Depth fixes:
    + S8194546: Choosier FileManagers
    + S8195874: Improve jar specification adherence
    + S8196897: Improve PRNG support
    + S8197881: Better StringBuilder support
    + S8201756: Improve cipher inputs
    + S8203654: Improve cypher state updates
    + S8204497: Better formatting of decimals
    + S8200666: Improve LDAP support
    + S8199110: Address Internet Addresses
  * Fixes
    + S7017058: Malayalam glyph substitution is failing for
    Malayalam with Windows Kartika font.
    + S8130655: OS X: keyboard input in textfield is not possible
    if the window contained textfield is owned by EmbeddedFrame
    + S8160104: CORBA communication improvements
    + S8163237: Restrict the use of EXPORT cipher suites
    + S8172525: Improve key keying case
    + S8174756: Extra validation for public keys
    + S8174962: Better interface invocations
    + S8175075: Add 3DES to the default disabled algorithm security
    property
    + S8175932: Improve host instance supports
    + S8176450: Revise default document styling
    + S8178449: Improve LDAP logins
    + S8178458: Better use of certificates in LDAP
    + S8178466: Better RSA parameters
    + S8179533: Cleaner print job handling
    + S8179990: Cleaner palette entry handling
    + S8180011: Cleaner native graphics device handling
    + S8180015: Cleaner AWT robot handling
    + S8180020: Improve SymbolHashMap entry handling
    + S8180869: Cleaner image file reading handling
    + S8180877: More deeply colored ICC spaces
    + S8181664: Improve JVM UTF String handling
    + S8181670: Improve implementation of keystores
    + S8182125: Improve reliability of DNS lookups
    + S8182362: Update CipherOutputStream Usage
    + S8182387: Improve PKCS usage
    + S8182601: Improve usage messages
    + S8183032: Upgrade to LittleCMS 2.9
    + S8185292: Stricter key generation
    + S8185325: Improve GTK initialization
    + S8186032: Disable XML Signatures signed with EC keys less
    than 224 bits
    + S8186080: Transform XML interfaces
    + S8186212: Improve GSS handling
    + S8186600: Improve property negotiations
    + S8186606: Improve LDAP lookup robustness
    + S8186998: Improve JMX supportive features
    + S8187496: Possible memory leak in
    java.apple.security.KeychainStore.addItemToKeychain
    + S8189123: More consistent classloading
    + S8189284: More refactoring for deserialization cases
    + S8189969: Manifest better manifest entries
    + S8189977: Improve permission portability
    + S8189981: Improve queuing portability
    + S8189985: Improve tabular data portability
    + S8189989: Improve container portability
    + S8189993: Improve document portability
    + S8189997: Enhance keystore mechanisms
    + S8190227: Forward port 8188880 to JDK10CPU
    + S8190289: More refactoring for client deserialization cases
    + S8190478: Improved interface method selection
    + S8190789: sun/security/provider/certpath/LDAPCertStore/
    /TestURICertStoreParameters.java fails after JDK-8186606
    + S8190877: Better handling of abstract classes
    + S8191130: Sinhala text rendering problem with
    C+VIRAMA+ZWJ+RA/YA+V
    + S8191142: More refactoring for naming deserialization cases
    + S8191178: [macos] Problem with input of yen symbol
    + S8191239: Improve desktop file usage
    + S8191358: Restore TSA certificate expiration check
    + S8191696: Better mouse positioning
    + S8191907: PPC64 and s390 parts of JDK-8174962: Better
    interface invocations
    + S8192025: Less referential references
    + S8192030: Better MTSchema support
    + S8192757: Improve stub classes implementation
    + S8192789: Avoid using AtomicReference in
    sun.security.provider.PolicyFile
    + S8193409: Improve AES supporting classes
    + S8193414: Improvements in MethodType lookups
    + S8193419: Better Internet address support
    + S8194233: Improve support for array handles
    + S8194238: Trying exceptions in MethodHandles
    + S8194259: keytool error: java.io.IOException: Invalid secret
    key format
    + S8195662: Add T6587786.java to problem list before
    JDK-8195589 is resolved
    + S8195836: opentype:Bengali: "Khanda Ta" shaping issue with
    U+09A4 TA, U+09CD virama, U+200D ZWJ
    + S8196224: Even better Internet address support
    + S8196289: Update src/java.desktop/share/legal/lcms.md for
    LCMS 2.9
    + S8197443: ArrayIndexOutOfBoundsException in
    UcryptoException.getError
    + S8197925: Better stack walking
    + S8199547: Exception to Pattern Syntax
    + S8200332: Improve GCM counting
    + S8204667: Resources not freed on exception
    + S8205479: OS X: requestFocus() does not work properly for
    embedded frame
    + S8205491: adjust reflective access checks
    + S8206389: JarEntry.setCreation/LastAccessTime without
    setLastModifiedTime causes Invalid CEN header
    + S8206392: [macosx] Cycling through windows (JFrames) does not
    work with keyboard shortcut
    + S8206473: Revert changes of JDK-8202613 in jdk-cpu and
    jdk11u-cpu
    + S8206884: Bump update version for jdk11.0.1 cpu forest
    + S8207057: No debug info for assembler files
    + S8207153: Some intrinsic tests take long time to run
    + S8207745: serviceability/sa/TestJmapCore.java times out
    parsing a 4GB hprof file
    + S8207775: Better management of CipherCore buffers
    + S8207941: javax/swing/plaf/basic/BasicGraphicsUtils/8132119/
    /bug8132119.java fails on machines without Arial font
    [testbug]
    + S8207948: JDK 11 L10n resource file update msg drop 10
    + S8208091: SA: jhsdb jstack --mixed throws
    UnmappedAddressException on i686
    + S8208268: 11.0.1 b03 java.net bundles - Release Date is wrong
    + S8208350: Disable all DES cipher suites
    + S8208583: Better management of internal KeyStore buffers
    + S8208595: [parfait] Better X11 font support
    + S8208654: Please change jdk 11.0.1 milestone to FCS
    + S8208661: JDK 11.0.1 l10n resource file update
    + S8208746: ISO 4217 Amendment #168 update
    + S8209129: Further improvements to cipher buffer management
    + S8209639: assert failure in coalesce.cpp: attempted to spill
    a non-spillable item
    + S8209775: ISO 4217 Amendment #169 update
    + S8209786: JDK12 fails to build on s390x with gcc 7.3
    + S8209862: CipherCore performance improvement
    + S8209889: RedefineStress tests crash
    + S8209916: NPE in SupportedGroupsExtension
    + S8209942: [epsilon] range function for EpsilonTLABElasticity
    causes compiler warning
    + S8209996: [PPC64] Fix JFR profiling
    + S8210153: localized currency symbol of VES
    + S8210259: [testbug] IncompatibleOptions.java fails if VM
    configured without ZGC
    + S8210335: Clipping problems with complex affine transforms:
    negative scaling factors or small scaling factors
    + S8210345: The Japanese message of FileNotFoundException
    garbled
    + S8210432: Add additional TeliaSonera root certificate
    + S8210497: [PPC64] Vector registers not saved across safepoint
    + S8210502: jdeps does not handle properly on analyzing a
    mixture of MR JARs and non-MR JARs
    + S8210647: libsaproc is being compiled without optimization.
    + S8210703: vmStructs.cpp compiled with -O0
    + S8210736: jdk/javax/xml/crypto/dsig/GenerationTests.java slow
    on linux
    + S8210761: libjsig is being compiled without optimization
    + S8210775: JVM TI Spec missing copyright
    + S8210810: Escaped character at specific position in argument
    file is not handled properly
    + S8210836: Build fails with warn_unused_result in
    openjdk/src/jdk.hotspot.agent/linux/native/libsaproc/ps_core.c
    + S8210846: TLSv.1.3 interop problems with OpenSSL 1.1.1 when
    used on the client side with mutual auth
    + S8211065: Private method check in linkResolver is incorrect
    + S8211105: AArch64: Disable cos/sin and log intrinsics in
    jdk11u pending fix
    + S8211107: LDAPS communication failure with jdk 1.8.0_181
    + S8211165: License header is absent in a few J2Ddemo source
    code files
    + S8211208: make AllocateHeapAt an unsupported option on AIX
    + S8211387: [Zero] atomic_copy64: Use ldrexd for atomic reads
    on ARMv7
    + S8211731: Reconsider default option for ClassPathURLCheck
    change done in JDK-8195874
    + S8211768: [s390] Implement JFR profiling
    + S8211856: [ppc, s390] ProblemList some failing tests.
    + S8211916: Javadoc -link makes broken links if module name
    matches package name
    + S8212110: Build of saproc.dll broken on Windows 32 bit after
    JDK-8210647
    + S8212204: [TESTBUG] test/hotspot/jtreg/compiler/intrinsics/
    /base64/TestBase64.java fails
- Removed patches:
  * RHBZ-1628612-JDK-8210461-workaround-disable-aarch64-intrinsic.patch
  * RHBZ-1630996-JDK-8210858-workaround-disable-aarch64-intrinsic-log.patch
    + Integrated upstream
* Wed Oct  3 2018 guillaume.gardet@opensuse.org
- Add patches to workaround aarch64 critical bugs:
  * RHBZ-1628612-JDK-8210461-workaround-disable-aarch64-intrinsic.patch
  * RHBZ-1630996-JDK-8210858-workaround-disable-aarch64-intrinsic-log.patch
* Tue Sep 25 2018 fstrba@suse.com
- Official OpenJDK 11 release (fate#324453, fate#323970, bsc#1111162)
  * Pull the sources from the jdk-updates/jdk11u repository from
    now on.
  * Remove the buildver from the rpm version string
* Tue Sep 11 2018 fstrba@suse.com
- Update jax-ws-spec and jaxb-spec tarball to the latest versions
- Modified patch:
  * annotation-module.patch
    + module name change from java.xml.ws.annotation to
    java.annotation
* Mon Sep 10 2018 markehammons@gmail.com
- Update configuration flags to enable ZGC on x86_64 platforms
* Thu Aug 23 2018 fstrba@suse.com
- Update to upstream tag jdk-11+28 (OpenJDK 11 rc1)
  * Fixes:
    + S8207317: SSLEngine negotiation fail exception behavior
    changed from fail-fast to fail-lazy
    + S8207838: AArch64: Float registers incorrectly restored in
    JNI call
    + S8209637: [s390x] Interpreter doesn't call result handler
    after native calls
    + S8209670: CompilerThread releasing code buffer in destructor
    is unsafe
    + S8209735: Disable avx512 by default
    + S8209806: API docs should be updated to refer to javase11
- Report version without the "-internal" postfix
* Tue Aug 21 2018 fstrba@suse.com
- Added patch:
  * jaw-nogtk.patch
    + Don't build against gdk making the accessibility depend on a
    particular version of gtk.
* Mon Aug 20 2018 fstrba@suse.com
- Update to upstream tag jdk-11+27
  * Fixes:
    + S8031761: [TESTBUG] Add a regression test for JDK-8026328
    + S8151259: [TESTBUG] nsk/jvmti/RedefineClasses/redefclass030
    fails with "unexpected values of outer fields of the class"
    when running with -Xcomp
    + S8164639: Configure PKCS11 tests to use user-supplied NSS
    libraries
    + S8189667: Desktop#moveToTrash expects incorrect "<<ALL
    FILES>>" FilePermission
    + S8194949: [Graal] gc/TestNUMAPageSize.java fail with OOM in
  - Xcomp
    + S8195156: [Graal] serviceability/jvmti/GetModulesInfo/
    /JvmtiGetAllModulesTest.java fails with Graal in Xcomp mode
    + S8199081: [Testbug] compiler/linkage/LinkageErrors.java fails
    if run twice
    + S8201394: Update java.se module summary to reflect removal of
    java.se.ee module
    + S8204931: Colors with alpha are painted incorrectly on Linux
    + S8204966: [TESTBUG] hotspot/test/compiler/whitebox/
    /IsMethodCompilableTest.java test fails with
  - XX:CompileThreshold=1
    + S8205608: Fix 'frames()' in ThreadReferenceImpl.c to prevent
    quadratic runtime behavior
    + S8205687: TimeoutHandler generates huge core files
    + S8206176: Remove the temporary tls13VN field
    + S8206258: [Test Error] sun/security/pkcs11 tests fail if NSS
    libs not found
    + S8206965: java/util/TimeZone/Bug8149452.java failed on de_DE
    and ja_JP locale.
    + S8207009: TLS 1.3 half-close and synchronization issues
    + S8207046: arm32 vm crash: C1 arm32 platform functions
    parameters type mismatch
    + S8207139: NMT is not enabled on Windows 2016/10
    + S8207237: SSLSocket#setEnabledCipherSuites is accepting empty
    string
    + S8207355: C1 compilation hangs in
    ComputeLinearScanOrder::compute_dominator
    + S8207746: C2: Lucene crashes on AVX512 instruction
    + S8207765: HeapMonitorTest.java intermittent failure
    + S8207944: java.lang.ClassFormatError: Extra bytes at the end
    of class file test" possibly violation of JVMS 4.7.1
    + S8207948: JDK 11 L10n resource file update msg drop 10
    + S8207966: HttpClient response without content-length does not
    return body
    + S8208125: Cannot input text into JOptionPane Text Input Dialog
    + S8208164: (str) improve specification of String::lines
    + S8208166: Still unable to use custom SSLEngine with default
    TrustManagerFactory after JDK-8207029
    + S8208189: ProblemList compiler/graalunit/JttThreadsTest.java
    + S8208205: ProblemList tests that fail due to 'Error attaching
    to process: Can't create thread_db agent!'
    + S8208226: ProblemList com/sun/jdi/BasicJDWPConnectionTest.java
    + S8208251: serviceability/jvmti/HeapMonitor/MyPackage/
    /HeapMonitorGCCMSTest.java fails intermittently on Linux-X64
    + S8208305: ProblemList
    compiler/jvmci/compilerToVM/GetFlagValueTest.java
    + S8208347: ProblemList
    compiler/cpuflags/TestAESIntrinsicsOnSupportedConfig.java
    + S8208353: Upgrade JDK 11 to libpng 1.6.35
    + S8208358: update bug ids mentioned in tests
    + S8208370: fix typo in ReservedStack tests' @requires
    + S8208391: Differentiate response and connect timeouts in HTTP
    Client API
    + S8208466: Fix potential memory leak in harfbuzz shaping.
    + S8208496: New Test to verify concurrent behavior of TLS.
    + S8208521: ProblemList more tests that fail due to 'Error
    attaching to process: Can't create thread_db agent!'
    + S8208640: [a11y] [macos] Unable to navigate between
    Radiobuttons in Radio group using keyboard.
    + S8208663: JDK 11 L10n resource file update msg drop 20
    + S8208676: Missing NULL check and resource leak in
    NetworkPerformanceInterface::NetworkPerformance::network_utilization
    + S8208691: Tighten up jdk.includeInExceptions security property
    + S8209011: [TESTBUG] AArch64: sun/security/pkcs11/Secmod/
    /TestNssDbSqlite.java fails in aarch64 platforms
    + S8209029: ProblemList tests that fail due to 'Error attaching
    to process: Can't create thread_db agent!' in jdk-11+25
    testing
    + S8209149: [TESTBUG] runtime/RedefineTests/
    /RedefineRunningMethods.java needs a longer timeout
    + S8209451: Please change jdk 11 milestone to FCS
    + S8209452: VerifyCACerts.java failed with "At least one cacert
    test failed"
    + S8209506: Add Google Trust Services GlobalSign root
    certificates
    + S8209537: Two security tests failed after JDK-8164639 due to
    dependency was missed
* Thu Jul 26 2018 fstrba@suse.com
- Update to upstream tag jdk-11+24 (Oracle July 2018 CPU)
  * Security fixes:
    + S8197925: Better stack walking (CVE-2018-2940, bsc#1101645)
    + S8199547: Exception to Pattern Syntax (CVE-2018-2952,
    bsc#1101651)
    + S8200332: Improve GCM counting (CVE-2018-2972, bsc#1101655)
    + S8200666: Improve LDAP support (CVE-2018-2973, bsc#1101656)
  * Security-In-Depth fixes:
    + S8191239: Improve desktop file usage
    + S8193419: Better Internet address support
  * Fixes:
    + S8189922: UseNUMA memory interleaving vs membind
    + S8196224: Even better Internet address support
    + S8202837: PBES2 AlgorithmId encoding error in PKCS12 KeyStore
    + S8203230: update VerifyCACerts test
    + S8203504: [Graal]
    org.graalvm.compiler.debug.test.DebugContextTest fails with
    java.util.ServiceConfigurationError
    + S8203820: [TESTBUG]
    vmTestbase/metaspace/staticReferences/StaticReferences.java
    timed out
    + S8204196: integer cleanup
    + S8205390: jtreg: Fix failing TestRTMSpinLoopCount on PPC64
    + S8205491: adjust reflective access checks
    + S8205578: jtreg: Fix failing TestRTMAbortRatio on PPC64
    + S8205580: PPC64: RTM: Don't retry lock on abort if abort was
    intentional
    + S8205581: PPC64: RTM: Fix abort on native calls
    + S8205582: PPC64: RTM: Fix counter for aborts on nested
    transactions
    + S8206171: Signature#getParameters for RSASSA-PSS throws
    ProviderException when not initialized
    + S8206241: compiler/graalunit/PhasesCommonTest.java fails with
    java.lang.Error: TESTBUG: no tests found for prefix
    org.graalvm.compiler.phases.common.test
    + S8206445: JImageListTest.java failed in Windows
    + S8206456: [TESTBUG] docker jtreg tests fail on systems
    without cpuset.effective_cpus / cpuset.effective_mem
    + S8206865: RMI activation tests fail with InvalidClassException
    + S8206886: Java does not set the default format locale
    correctly on mac10.13
    + S8206931: Misleading "COMPILE SKIPPED: invalid non-klass
    dependency" compile log
    + S8207056: Epsilon GC to support object pinning
    + S8207069: [AOT] we should check that VM uses the same GC as
    one used for AOT library generation.
    + S8207223: SSL Handshake failures are reported with more
    generic SSLException
    + S8207243: Fix translation filtering to also support zh_HK and
    zh_TW
    + S8207244: java/nio/channels/Selector/SelectWithConsumer.java
    testInterruptDuringSelect() fails intermittently
    + S8207250: setUseClientMode post handshake with the same value
    as before does not throw IAE
    + S8207252: C1 still does eden allocations when TLAB is enabled
    + S8207365: Make man pages optional
    + S8207380: compiler/graalunit/JttLangMTest.java timeout
    + S8207383: [Graal] SelfChangedCDS.java fails with
    "guarantee(disp == (intptr_t)(jint)disp) failed: must be
    32-bit offset"
    + S8207392: [PPC64] Implement JFR profiling.
    + S8207584: ARM32: ShouldNotReachHere assertion on Test8168712
    jtreg test
    + S8207761: Split compiler/graalunit/JttReflectFTest.java
    + S8207765: HeapMonitorStatIntervalTest.java fails with ZGC
    + S8207766: [testbug] Adapt tests for Aix.
    + S8207818: Problem list several rmi tests
    + S8207819: Problem list serviceability/jvmti/HeapMonitor/
    /MyPackage/HeapMonitorStatRateTest.java
    + S8207830: [aix] disable jfr in build and tests
    + S8207833: java/nio/channels/Selector/SelectWithConsumer.java
    testCancel() fails intermittently
    + S8207846: Generalize the jdk.net.includeInExceptions security
    property
    + S8207915: [AOT] jaotc w/ '--ignore-errors' should ignore
    illegal class files
    + S8207952: Problem-list 3 sctp tests
    + S8207959: The initial value of
    SETTINGS_MAX_CONCURRENT_STREAMS should have no limit
    + S8207960: Non-negative WINDOW_UPDATE increments may leave the
    stream window size negative
    + S8208075: Quarantine vmTestbase/nsk/jvmti/RedefineClasses/
    /StressRedefineWithoutBytecodeCorruption/TestDescription.java
    + S8208092: ProblemList serviceability/sa/ClhsdbCDSCore.java
    + S8208096: Update build documentation to reflect compiler
    upgrades at Oracle
    + S8208111: Problem list
    java/nio/channels/Selector/RacyDeregister.java
* Fri Jul 20 2018 fstrba@suse.com
- Update to upstream tag jdk-11+23
  * Fixes
    + S8181855: [Graal]
    runtime/ReservedStack/ReservedStackTest.java triggers:
    assert(thread->deopt_mark() == __null) failed: no stack
    overflow from deopt blob/uncommon trap
    + S8189747: JDK9 javax.lang.model.util.Elements#getTypeElement
    regressed 1000x in performance.
    + S8191948: db error: InvalidTypeException: Can't assign
    double[][][] to double[][][]
    + S8199779: Add T-Systems, GlobalSign and Starfield services
    root certificates
    + S8200282: Serializing non-zero byte as zero to ByteBuffer
    + S8202481: RegisterDuringSelect.java fails with
    java.util.concurrent.ExecutionException:
    java.nio.channels.ClosedSelectorException
    + S8204860: The frame could be resized by dragging a corner of
    the frame with the mouse
    + S8205541: serviceability/jvmti/HeapMonitor/MyPackage/
    /HeapMonitorStatArrayCorrectnessTest.java fails with Should
    not have any events stored yet.
    + S8205576: forkjoin/FJExceptionTableLeak.java fails
    "AssertionError: failed to satisfy condition"
    + S8205643: HeapMonitorGCCMSTest fails with Graal
    + S8205652: serviceability/jvmti/HeapMonitor/MyPackage/
    /HeapMonitorStatRateTest.java fails
    + S8205725: Update the JVMTI Spec for Heap Sampling
    + S8205967: Remove sun/security/krb5/auto/UnboundSSL.java from
    ProblemList.txt
    + S8206189: sun/security/pkcs12/EmptyPassword.java fails with
    Sequence tag error
    + S8206238: Aspect ratio is not maintained when Image is scaled
    in JEditorPane
    + S8206265: aarch64 jtreg: assert in TestOptionsWithRanges.jtr
    + S8206271: CodeHeap State Analytics must digest new method
    state
    + S8206448: (fs) Extended attributes assumed to be enabled on
    ext3 (lnx)
    + S8206471: Race with ConcurrentHashTable deleting items on
    insert with cleanup thread
    + S8206873: 2 Null pointer dereference defect groups in
    LIRGenerator
    + S8206903: Unable to build Client VM with JVMCI
    + S8206915: XDH TCK issues
    + S8206929: Check session context for TLS 1.3 session resumption
    + S8206953: compiler/profiling/TestTypeProfiling.java fails
    when JVMCI build disabled
    + S8206960: HeapMonitor tests fail with Graal
    + S8206975: AArch64: Fix CompareAndSwapOp when useLSE is
    enabled in Graal
    + S8206977: Minor improvements of runtime code.
    + S8206980: ZonedDateTime could not parse timezone name with
    zh_CN locale correctly.
    + S8206998: [test] runtime/ElfDecoder/TestElfDirectRead.java
    requires longer timeout on ppc64
    + S8207001: *.obj.log files get truncated causing unreliable
    incremental builds on Windows
    + S8207006: serviceability/sa/TestUniverse.java#id0 crashes
    with EpsilonGC and AOT
    + S8207023: Add trace info to
    java/nio/channels/Selector/RegisterDuringSelect.java
    + S8207027: Lookup.accessClass fails for an array type in the
    same package when assertions are enabled
    + S8207029: Unable to use custom SSLEngine with default
    TrustManagerFactory after updating to JDK 11 b21
    + S8207032: Compilation succeeds without checking readability
    when --add-exports used
    + S8207044: minimal vm build fail: missing #include
    + S8207047: Multiple VM variants build fail
    + S8207049: Minor improvements of compiler code.
    + S8207065: Cleanup compiler tests for Client VM
    + S8207067: [test] prevent timeouts in
    serviceability/tmtools/jstat/{GcTest02,GcCauseTest02}.java
    + S8207068: Add Entrust root certificates
    + S8207152: Placeholder for Japanese new era should be two
    characters
    + S8207190: JDK 11 javadoc generates bad code example
    + S8207210: Problem list
    javax/sound/sampled/Clip/AutoCloseTimeCheck.java
    + S8207213: The help-doc.html generated by the doclet is
    incomplete
    + S8207217: Problem list
    java/lang/management/ThreadMXBean/AllThreadIds.java
    + S8207233: Minor improvements of jdk C-coding
    + S8207235:
    ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)
    throws NPE
    + S8207240: AARCH64: C2-only VM does not build
    + S8207261: [Graal] JDI and JDWP tests that consume all memory
    should be filtered out to not run with Graal
    + S8207265: Bad HTML in {@link} in
    HttpResponse.BodySubscribers.ofPublisher
    + S8207318: KeyStore#getInstance(File, LoadStoreParameter) does
    not load the keystore
    + S8207342: error occurred during error reporting (printing
    register info)
    + S8207345: AArch64: Trampoline generation code reads from
    unitialized memory
    + S8207763: serviceability/jvmti/HeapMonitor/MyPackage/
    /HeapMonitorStatRateTest.java failed with Error. Parse
    Exception: Can't find source file:
    HeapMonitorStatIntervalTest.java
* Sat Jul 14 2018 fstrba@suse.com
- Merge standalone modules java.activation, java.xml.bind,
  java.xml.soap, java.xml.ws.annotation and java.xml.ws into the
  OpenJDK
- Added patches:
  * activation-module.patch
    + add module-info.java file for java.activation module
  * annotation-module.patch
    + add module-info.java file for java.xml.ws.annotation
* Thu Jul 12 2018 fstrba@suse.com
- Update to upstream tag jdk-11+22
  * Fixes
    + S8185740: The help-doc.html generated by the doclet is
    outdated
    + S8187069: The case auto failed with the
    java.lang.ClassNotFoundException:
    IPv6NameserverPlatformParsingTest exception
    + S8189604: possible hang in
    sun.awt.shell.Win32ShellFolder2$KnownFolderDefinition::<clinit>
    + S8193126: Incorrect setting of MetaspaceSize and
    NewSizeThreadIncrease when using JVMCI compiler
    + S8194740: UseSubwordForMaxVector causes performance regression
    + S8198346: assert(!_cld->claimed()) failed in
    TestObjectDescription.java
    + S8198352: java.util.MissingResourceException:
    sun.security.util.AuthResources when trying to use
    com.sun.security.auth.module.UnixLoginModule
    + S8198405: JImageExtractTest.java & JImageListTest.java failed
    in Windows.
    + S8198819: tools/jimage/JImageExtractTest.java, fails
    intermittently at testExtract (macos)
    + S8199645: javax/net/ssl/SSLSession/TestEnabledProtocols.java
    failed with Connection reset
    + S8201611: Broken links in java.desktop javadoc
    + S8202123: C2 Crash in Node::in(unsigned int) const+0x14
    + S8202264: Race condition in AudioClip.loop()
    + S8202329: [AIX] Fix codepage mappings for IBM-943 and Big5
    + S8202561: clean up TEST.groups file
    + S8202769: jck test fails with C2:
    vm/jvmti/FollowReferences/fref001/fref00113/fref00113.html
    + S8203007: Address missing block coverage for ChaCha20 and
    Poly1305 algorithms
    + S8203943: eventThreadGroup was null in
    TestJavaBlockedEvent.java
    + S8204603: Short week days, NaN value and timezone name are
    inconsistent between CLDR and Java in zh_CN, zh_TW locales.
    + S8204630: Generating an anonymous class with
    Filer#createClassFile causes an NPE in
    JavacProcessingEnvironment
    + S8204691: HeapRegion.apply_to_marked_objects_other_vm_test
    fails with assert(!hr->is_free() || hr->is_empty()) failed:
    Free region 0 is not empty for set Free list #
    + S8205426: Humongous continues remembered set does not match
    humongous start region one after Remark
    + S8205454: &amp; is displayed in some Swing docs
    + S8205472: Deadlock in Kitchensink when trying to print
    compile queues causing timeout
    + S8205588: Deprecate for removal com.sun.awt.SecurityWarning
    + S8205646: Broken link in jdk.jsobject
    + S8205878: pthread_getcpuclockid is expected to return 0 code
    + S8205924: ZGC: Premature OOME due to failure to expand
    backing file
    + S8205928: [TESTBUG]
    jdk/internal/platform/docker/TestDockerMemoryMetrics
    + S8205966: [testbug] New Nestmates JDI test times out with
    Xcomp on sparc
    + S8205973: Client jtreg ProblemList cleanup
    + S8205999: C2 compilation fails with
    "assert(store->find_edge(load) != -1) failed: missing
    precedence edge"
    + S8206001: Enable TLS1.3 by default in Http Client
    + S8206106: [solaris sparc] jck tests
    api/javax_print/PrintService failing
    + S8206135: Building jvm with AOT but without JVMCI should fail
    at configure time
    + S8206145: dbgsysSocketClose - do not restart close if errno
    is EINTR [linux]
    + S8206163: AArch64: incorrect code generation for StoreCM
    + S8206173: MallocSiteTable::initialize() doesn't take function
    descriptors into account
    + S8206184: docs-reference build fails due to
    extlink.spec.version property not set
    + S8206243: java -XshowSettings fails if memory.limit_in_bytes
    overflows LONG.max
    + S8206254: Unable to complete emergency dump during safepoint
    + S8206255: fix compiler/intrinsics/sha/cli/
    /TestUseSHAOptionOnSupportedCPU.java jtreg test on linux s390x
    + S8206287: fix legal notice in hotspot tests
    + S8206316: ZGC: Preferred tmpfs mount point not found on Debian
    + S8206322: ZGC: Incorrect license header in gtests
    + S8206323: Missing some legal notices in docs bundle
    + S8206324: compiler/whitebox/DeoptimizeFramesTest.java to
    ProblemList-graal.txt
    + S8206355: SSLSessionImpl.getLocalPrincipal() throws NPE
    + S8206375: ProblemList update of bug ID for
    SwingFontMetricsTest
    + S8206378: Backout JDK-8202561
    + S8206394: missing ResourceMark in
    AOTCompiledMethod::metadata_do,
    AOTCompiledMethod::clear_inline_caches,
    CompiledMethod::clear_ic_stubs,
    CompiledMethod::cleanup_inline_caches_impl
    + S8206408: Add missing CPU/system info to vm_version_ext on
    PPC64
    + S8206428: Upgrade JDK11 to harfbuzz 1.8.2
    + S8206429: [REDO] 8202561 clean up TEST.groups
    + S8206433: Several jib profiles missing autoconf dependency
    + S8206436: sun/nio/cs/TestIBMBugs.java no longer compiles
    + S8206450: Add JImageListTest.java to ProblemList.txt
    + S8206459: [s390] Prevent restoring incorrect bcp and locals
    in interpreter and avoid incorrect size of
    partialSubtypeCheckNode in C2
    + S8206476: Wrong assert in phase_enum_2_phase_string() in
    referenceProcessorPhaseTimes.cpp
    + S8206919: s390: add missing info to vm_version_ext_s390
    + S8206951: [Graal]
    org.graalvm.compiler.hotspot.test.GraalOSRTest to
    ProblemList-graal.txt
    + S8206952: java/lang/Class/GetPackageBootLoaderChildLayer.java
    fails with Graal
    + S8206954: Test runtime/Thread/ThreadPriorities.java crashes
    with SEGV in pthread_getcpuclockid
    + S8207007: Add missing license header to zHash.inline.hpp
* Thu Jul 12 2018 guillaume.gardet@opensuse.org
- Switch armv6 to zero JVM variant (without JIT) since client and
  server JVM do not build for armv6 ATM
* Thu Jul  5 2018 fstrba@suse.com
- Update to upstream tag jdk-11+21
  * Fixes:
    + S8201552: Ellipsis in "Classical" label in SwingSet2 demo
    with Windows L&F at Hidpi
    + S8203848: Missing remembered set entry in j.l.ref.references
    after JDK-8203028
    + S8204355: [Graal] org.graalvm.compiler.debug.test.CSVUtilTest
    fails on Windows due to improper line separator used
    + S8204517: [Graal]
    org.graalvm.compiler.debug.test.VersionsTest fails with
    InvalidPathException on windows
    + S8205515: assert(opcode == Op_RangeCheck) failed: no other if
    variant here
    + S8205563: modules/AnnotationProcessing.java failed
    testGenerateSingleModule
    + S8205720: KeyFactory#getKeySpec and translateKey throws
    NullPointerException with Invalid key
    + S8205965: SIGSEGV on write to NativeCallStack::EMPTY_STACK
    + S8205984: javax/net/ssl/compatibility/Compatibility.java
    failed to access port log file
    + S8206003: SafepointSynchronize with TLH: StoreStore barriers
    should be moved out of the loop
    + S8206093: compiler/graalunit/HotspotTest.java fails in
    CheckGraalIntrinsics
    + S8206117: failed to get JDK properties for JVM w/o JVMCI
* Mon Jul  2 2018 fstrba@suse.com
- Update to upstream tag jdk-11+20 (rampdown phase 1)
  * Fixes:
    + S4475138: getBestCursorSize and XFree86 4.1.0
    + S7007966: Add Brainpool ECC support (RFC 5639)
    + S8003209: JFR events for network utilization
    + S8010319: Implementation of JEP 181: Nest-Based Access Control
    + S8060192: Add default method <A> A[]
    Collection.toArray(IntFunction<A[]> generator)
    + S8066709: Make some JDK system properties read only
    + S8137164: Include PID in the JFR jcmd hint
    + S8144992: Remove OopIterateClosure::idempotent
    + S8149729: [jittester] Replace all 'path1 +"/" + path2' with
    Paths::get
    + S8153732: Windows remote printer changes do not reflect in
    lookupPrintServices()
    + S8155192: [TESTBUG] SHA tests assumes that x86 does not have
    SHA intrinsics
    + S8160673: Jittester: investigate bytecode generation hangs
    during bytecode tests generation
    + S8169559: Add class loader names to relevant VM messages
    + S8172854: [TESTBUG] Exclude
    runtime/ReservedStack/ReservedStackTest.java from being run
    with DeoptimizeALot option
    + S8185927: create regression test for 8062950
    + S8187100: Support Unicode Variation Selectors
    + S8187218: GSSCredential.getRemainingLifetime() returns
    negative value for TTL > 24 days.
    + S8187288: bad (no) wrapping for modifier and type column
    + S8189103: AARCH64: optimize String indexOf intrinsic
    + S8189105: AARCH64: create intrinsic for sin and cos
    + S8189112: AARCH64: optimize StringUTF16 compress intrinsic
    + S8189113: AARCH64: StringLatin1 inflate intrinsic doesn't use
    prefetch instruction
    + S8189429: SA: MacOSX: Replace the deprecated PT_ATTACH with
    PT_ATTACHEXC
    + S8190876: javadoc search on "java.se" shows "java.se" the
    last one among other modules
    + S8192953: sun/management/jmxremote/bootstrap/*.sh tests fail
    with error : revokeall.exe: Permission denied
    + S8194152: sun/security/tools/jarsigner/AltProvider.java
    failed on de-DE locale
    + S8194873: right ALT key hotkeys no longer work in Swing
    components
    + S8194937: Inconsistent behavior of --validate-modules when
    combined with -m and other options
    + S8195077: [Testbug] tools/javac/processing/model/
    /completionfailure/NoAbortForBadClassFile.java -
    AccessDeniedException
    + S8195607: sun/security/pkcs11/Secmod/TestNssDbSqlite.java
    failed with "NSS initialization failed" on NSS 3.34.1
    + S8195630: [Graal] vmTestbase/nsk/jvmti/AttachOnDemand/
    /attach024/TestDescription.java fails with Graal
    + S8195650: Method references to VarHandle accessors
    + S8195986: Incorrect javac -h output with annotation
    processing and missing classes
    + S8196213: sun/security/tools/jarsigner/warnings/
    /NoTimestampTest.java test fails on ar_SA locale.
    + S8196402: AARCH64: create intrinsic for Math.log
    + S8196425: tools/javac/modules/AnnotationProcessing.java failed
    + S8196584: TLS 1.3 Implementation
    + S8197425: Liveset information for Old Object sample event
    + S8197532: Re-examine policy for the default set of modules
    when compiling or running code on the class path
    + S8198372: API to create a SelectableChannel to a
    FileDescriptor
    + S8198909: [Graal] compiler/codecache/stress/
    /UnexpectedDeoptimizationTest.java crashed with SIGSEGV
    + S8199124: (fs) Reduce allocation for file system methods that
    are invoked with no open options
    + S8199265: java/util/Arrays/TimSortStackSize2.java fails with
    OOM
    + S8199580: [TESTBUG] Un-quarantine vm/mlvm/indy/func/jdi/
    /breakpointOtherStratum and breakpoint
    + S8199940: Print more information about class loaders in
    IllegalAccessErrors.
    + S8200243: System error message is decoded as invalid encoding
    in Windows.
    + S8200720: Print additional information in thread dump (times,
    allocated bytes etc.)
    + S8201610: Broken link on the page
    api/java.rmi/java/rmi/server/UnicastRemoteObject.html
    + S8201815: Use Mozilla Public Suffix List
    + S8202292: java/io/FileOutputStream/UnreferencedFOSClosesFd.java
    fails with "raw fd count wrong"
    + S8202299: Java Keystore fails to load PKCS12/PFX certificates
    created in WindowsServer2016
    + S8202326: AARCH64: optimize string compare intrinsic
    + S8202331: Obsolete support for commercial features
    + S8202422: value of 'sizeCtl' in ConcurrentHashMap varies with
    the constructor called
    + S8202554: Remove hotspot tests for javafx.* modules
    + S8202608: CommonSeeder test needs a white-box testing
    mechanism to replace the default entropy source
    + S8202615: Remove NativeMonitorSpinLimit, NativeMonitorFlags
    and NativeMonitorTimeout experimental flags
    + S8202696: Remove exclusion range for phonetic chars in
    windows fontconfig.properties
    + S8202698: Update Graal for JEP 181 - Nest-based access control
    + S8202788: Explicitly reclaim cached thread-local direct
    buffers at thread exit
    + S8202922: Method reference identity is broken by serialization
    + S8203003: Several FileDialog Modality Tests fail on Linux due
    to X errors
    + S8203184: List.copyOf() fails to copy sublists
    + S8203188: Add JEP-181 support to the Zero interpreter
    + S8203228: Branch-free output conversion for X25519 and X448
    + S8203299: StringPoolBuffer access covered by exclusive access
    invariant, remove (problematic) cas operations
    + S8203481: Incorrect constraint for unextended_sp in
    frame:safe_for_sender
    + S8203664: JFR start failure after AppCDS archive created with
    JFR StartFlightRecording
    + S8203670: unmodifiable List iterator() implementations should
    not be ListIterators
    + S8203681: Miscellaneous changes imported from jsr166 CVS
    2018-06
    + S8203814: javac --release=8 "cannot find symbol" for
    NashornException.getEcmaError()
    + S8203864: Execution error in Java's Timsort
    + S8203929: Limit amount of data for JFR.dump
    + S8204082: Make names of Young GCs more uniform in logs
    + S8204157: Compiler.sunflow hangs after JDK-8192992
    + S8204209: [Graal] Compilation fails during nmethod printing
    with "assert(bci == 0 || 0 <= bci && bci < code_size())
    failed: illegal bci"
    + S8204233: Add configurable option for enhanced socket
    IOException messages
    + S8204289: AARCH64: enable math intrinsics usage in
    interpreter and C1
    + S8204331: AArch64: fix CAS not embedded in normal graph error
    + S8204492: Add deprecation annotation to Nashorn APIs and
    warning to nashorn, jjs
    + S8204524: Unnecessary memory barriers in
    G1ParScanThreadState::copy_to_survivor_space
    + S8204540: Automatic oop closure devirtualization
    + S8204661: Show error 'Port already in use' in
    HashedPasswordFileTest.java
    + S8204930: Reader:nullReader() spec does not match the behavior
    + S8204946: Clean-up problem list for JDK-8202933 and
    JDK-8202934
    + S8204967: Resolve disabled warnings for libunpack
    + S8205004: AArch64: fix failures in jtreg ArraysEqCmpTest
    + S8205053: Decouple type registration from framework lifecycle
    + S8205058: (fs) Files read/writeString should throw
    CharacterCodingException instead of IOException with an
    IllegalArgumentException as cause
    + S8205107: assert(c->Opcode() == Op_SafePoint) failed: broken
    outer loop
    + S8205111: Develop new Test to verify different key types for
    supported TLS protocols.
    + S8205113: Update JVMTI doc references to object allocation
    tracking
    + S8205119: SwingApplet demo should be removed
    + S8205136: Move StylePad demo to the open repository
    + S8205144: JSpinner may change the font after became visible
    + S8205153: Delete "standard instructions" machinery in the
    open automated tests
    + S8205158: Update the .md files for 3rd party software Unicode
    10.0, ICU 60.2, and CLDR v33.
    + S8205160: jQuery UI, jQuery-migrate, and jQuery license file
    to be updated to the revision present.
    + S8205175: Deprecate UnlinkSymbolsALot debugging option.
    + S8205184: Delegating Iterator implementations that don't
    delegate forEachRemaining()
    + S8205194: Improve the Array Comparison when there is mismatch
    at first element.
    + S8205195: NestedThreadsListHandleInErrorHandlingTest fails
    because hs_err doesn't contain _nested_thread_list_max
    + S8205197: Never default to using libc++ on Linux
    + S8205199: more Linux clang compile failures
    + S8205207: Port Graal unit tests under jtreg
    + S8205324: Part of java.awt.Desktop.browse(URI) spec is
    outdated after support of applets was removed
    + S8205342: windows : potential memleaks in getAdapter(s) in
    NetworkInterface_winXP.c
    + S8205397: InetAddress has wrong declaration for
    readObjectNoData
    + S8205398: AES-CBC decryption algorithm using AVX512
    instructions
    + S8205400: [Graal]
    compiler/jvmci/compilerToVM/DisassembleCodeBlobTest.java fails with
    can't be enqueued for compilation on level 4
    + S8205405: ZGC: Decouple JFR type registration
    + S8205416: windows: fix checking of CloseHandle return code in
    Java_java_io_FileCleanable_cleanupClose0
    + S8205419: [testbug] TestJmapCore failing without SA:
    introduce @requires vm.hasSAandCanAttach
    + S8205422: assert(false) failed: Bad verification_type_info
    + S8205424: Change to Xcode 9.4 for building on Macosx at Oracle
    + S8205438: Re-enable shebang tests in
    test/jdk/tools/launchers/SourceMode.java
    + S8205441: Upgrade to harfbuzz 1.8.1
    + S8205442: Avoid hard-coding --source value in
    SourceLauncherTest.java
    + S8205445: Add RSASSA-PSS Signature support to SunMSCAPI
    + S8205455: jdeprscan issues annotation processor warning
    regarding RELEASE_10
    + S8205456: Unification of iterations over arrays
    + S8205459: Rename Access API flag decorators
    + S8205474: AARCH64: wrong zr encoding for ccmp instruction
    + S8205475: AARCH64: optimize FPU loads and stores in
    C1_Runtime1_aarch64.cpp
    + S8205490: update ProblemList-graal
    + S8205494: Convert or remove all AWT applet demos
    + S8205498: Typo in fix for 8205119 breaks Solaris demo build
    + S8205499: C1 temporary code buffers are not removed with
  - XX:+UseDynamicNumberOfCompilerThreads
    + S8205508: hotspot/jtreg/vmTestbase/nsk/jdb/exclude/exclude001/
    /exclude001.java fails with Prompt is not received during
    300200 milliseconds.
    + S8205509: assert(_name_and_id != 0LL) failed: encountered a
    class loader null name and id
    + S8205528: Base64 encoding algorithm using AVX512 instructions
    + S8205531: jcmd VM.classloaders should fold similar loaders
    + S8205533: Class.getPackage() fails with InternalError if
    class is defined to the bootstrap class loader but module is
    not in the boot layer
    + S8205540: test/hotspot/jtreg/vmTestbase/nsk/jdb/trace/
    /trace001/trace001.java fails with Debuggee did not exit
    after 15 <cont> commands
    + S8205547: FileChannel/CleanerTest.java fails due to expected
    FD count
    + S8205559: Remove IN_CONCURRENT_ROOT Access decorator
    + S8205570: fix a number of typos in the JVMTI spec
    + S8205577: parallel/TestPrintGCDetailsVerbose.java fails
    assertion
    + S8205583: Crash in ConcurrentHashTable
    do_bulk_delete_locked_for
    + S8205605: [testbug][aix] Various test adaption to aix
    pecularities.
    + S8205607: Use oop_iterate instead of oop_iterate_no_header
    + S8205609: [PPC64] Fix PPC64 part of 8010319 and TLH without
    UseSIGTRAP on AIX
    + S8205612: (fc) Files.readAllBytes fails with
    ClosedByInterruptException when interrupt status set
    + S8205614: NestMates tests failing in CI jdk11-jdk.931
    + S8205616: Build fails with system headers after 8204572
    + S8205623: Replace use of Class::getPackage with
    Class::getPackageName
    + S8205625: linux-aarch64-cmp-baseline fails builds-tier5
    + S8205627: Replace hardcoded spec version value in
    build.tools.ExtLink taglet
    + S8205632: Include stack.inline.hpp in markSweep.inline.hpp
    + S8205641: Make java/nio/channels/Selector/RacyDeregister.java
    noisier and flush after prints
    + S8205648: fix for 8205195 breaks secondary error handling
    + S8205649: Make clang stack flags independent of OS
    + S8205663: ZGC: Log metaspace used/capacity/committed/reserved
    + S8205664: Move detailed metaspace logging from debug to trace
    + S8205671: Remove HTTP Client tests erroneously problem listed
    by the TLS 1.3 integration
    + S8205673: Problem list RmiRegistrySslTest.java and
    RmiSslBootstrapTest.sh
    + S8205676: ZGC: Remove TLAB allocations in relocation path
    + S8205678: ZGC: Remove unused ZAllocationFlags::java_thread()
    + S8205679: Remove unused
    ThreadLocalAllocBuffer::undo_allocate()
    + S8205681: [TEST_BUG] vmTestbase/nsk/jvmti/Allocate/alloc001/
    /TestDescription.java fails with exit code 98
    + S8205683: Refactor heap allocation to separate concerns
    + S8205694: AArch64: Add test to validate volatile load, store
    and CAS code generation
    + S8205696: Undo licence.md
    + S8205699: assert(_owner_offset != 0) failed in javaClasses.cpp
    + S8205701: Problem list serviceability/jvmti/HeapMonitor/
    /MyPackage/HeapMonitorGCCMSTest.java
    + S8205702: assert(UseCompressedClassPointers) failed in
    universe.hpp
    + S8205703: [JVMCI] Expose all GC selection flags
    + S8205719: Windows
    Java_sun_tools_attach_VirtualMachineImpl_enqueue() method
    should include exitCode in exception message
    + S8205721: Problem list serviceability/jvmti/HeapMonitor/
    /MyPackage/HeapMonitorStatArrayCorrectnessTest.java
    + S8205723: Problem list serviceability/jvmti/HeapMonitor/
    /MyPackage/HeapMonitorStatRateTest.java
    + S8205824: Update Graal
    + S8205906: jdk.jfr.jcmd.TestJcmdDumpLimited fails due to
    erronous processing of -XX:FlightRecorderOptions
    + S8205913: Inconsistent source code model
    + S8205916: [test] Fix jdk/tools/launcher/RunpathTest to handle
    both, RPATH and RUNPATH
    + S8205923: ZGC: Verification applies load barrier before
    verification
    + S8205923: ZGC: Verification applies load barriers before
    verification
    + S8205925: Print correct and more information about secondary
    errors
    + S8205926: Support invokeSpecialIFC in GenerateJLIClassesPlugin
    + S8205927: Update src/java.base/share/legal/public_suffix.md
    to match the actual file version
    + S8205940: LoadNode::find_previous_arraycopy fails with
    "broken allocation" assert
    + S8205942: Build failure on macosx after JDK-8189429
    + S8205945: Revert unintended changes to
    make/gensrc/Gensrc-jdk.hotspot.agent.gmk
    + S8205954: clean up hotspot ProblemList
    + S8205956: Fix usage of "OpenJDK" in build and test
    instructions
    + S8205959: Do not restart close if errno is EINTR
    + S8205985: Remove tools/javac/options/release/
    /ReleaseOptionUnsupported.java from problem list
    + S8205993: ZGC: Fix typos and incorrect indentations
    + S8205996: JDK-8205906 broke the build on Mac
    + S8206004: [BACKOUT] errant changeset for JDK-8137164
    + S8206006: Build failed on Windows
    + S8206088: 8205207 broke builds
- Removed patch:
  * generated-headers.patch
    + Integrated upstream
- Modified patch:
  * alternative-tzdb_dat.patch
    + Modify to upstream changes in the context
* Fri Jun 22 2018 fstrba@suse.com
- Added patch:
  * missing-return.patch
    + fix no-return-in-nonvoid-function
* Thu Jun 21 2018 fstrba@suse.com
- Update to upstream tag jdk-11+19
  * Fixes:
    + S6545967: sp05t003 failed ResumeThread() due to
    THREAD_NOT_SUSPENDED
    + S6608234: SwingWorker.get throws CancellationException
    + S7183985: (ann) Class.getAnnotation() throws an
    ArrayStoreException when the annotation class not present
    + S8029250: [macosx] There is no tray icon shown in the system
    tray area when case starts
    + S8042131: DateTimeFormatterBuilder Mapped-values do not work
    for JapaneseDate
    + S8043575: Dynamically parallelize reference processing work
    + S8149565: -locale option issues
    + S8153107: enabling ObjectSynchronizer::quick_enter() on ARM64
    causes hangs
    + S8170159: Improve the performance of BitSet traversal
    + S8177334: Update xmldsig implementation to Apache Santuario
    2.1.1
    + S8178150: Regression in logic for handling inference stuck
    constraints
    + S8184349: There should be some verification that EnableJVMCI
    is disabled if a GC not supporting JVMCI is selected
    + S8191512: T2K font rasterizer code removal
    + S8193302: Javac AssertionError: typeSig ERROR on usage of
    @Generated
    + S8194308: jdeprscan will need updates to deal with the
    removal of the Java EE modules
    + S8195115: G1 Old Gen MemoryPool CollectionUsage.used values
    don't reflect mixed GC results
    + S8195293: Issue more comprehensive warnings for use of
    \"var\" in earlier source versions
    + S8196618: Create API to list supported values for javac
  - -release option
    + S8196988: Resolve disabled warnings for libjimage
    + S8198669: Refactor annotation array value parsing to reduce
    duplication
    + S8198719: MethodHandleHelper.linkToStatic should drop MH arg
    + S8199433: (se) select(Consumer<SelectionKey> action) as
    alternative to selected-key set
    + S8199435: Unsafe publication of java.util.Properties.map
    + S8199441: Wrong caret position in multiline text components
    on Windows with a screen resolution higher than 100%%
    + S8199871: Deprecate pack200 and unpack200 tools
    + S8200115: System property java.vm.vendor value includes
    quotation marks
    + S8200121: Remove unused qualified exports in java.base
    + S8200353: Shift or Capslock not working in Textfield after
    accented keystrokes
    + S8200605: Create test for GridBagLayoutDemo
    + S8200867: Remove references to "jdk 9" in build system
    + S8201276: (fs) Add methods to Files for reading/writing a
    string from/to a file
    + S8202199: Provide public, unsupported JDK API for
    JavaFX/Swing interop
    + S8202216: Add Buffer mismatch methods
    + S8202537: CLDR33
    + S8202559: Tests which start VM using JNI start failing after
    compile upgrade to VC 2017
    + S8202605: Standardize on ClassLoaderData::loader_name()
    throughout the VM to obtain a class loader's name
    + S8202624: javadoc generates references to enum constructors,
    which are not documented
    + S8202740: runtime/8176717/TestInheritFD.java fails with
    java.lang.RuntimeException: could not match:
    VM RESULT => RETAINS FD
    + S8202768: [macos] Appkit thread slows when any Window Manager
    active
    + S8202845: Refactor reference processing for improved
    parallelism
    + S8202948: C2: assert(init_offset >= 0) failed: positive
    offset from object start
    + S8203030: Zero s390 31 bit size_t type conflicts in shared
    code
    + S8203157: Object equals abstraction for BarrierSetAssembler
    + S8203197: C2: consider all paths in loop body for loop
    predication
    + S8203301: Linux-sparc fails to build after JDK-8199712
    (Flight Recorder)
    + S8203338: Unboxing in return from lambda miscompiled to throw
    ClassCastException
    + S8203343: VM.{metaspace|classloaders|classhierarchy...} jcmd
    should show invocation targets for
    Generated{Method|Constructor}AccessorImpl classes
    + S8203344: Make C1 leal patchable on SPARC
    + S8203357: Container Metrics
    + S8203394: Implementation of JEP 331: Low-Overhead Heap
    Profiling
    + S8203479: JFR enabled ARM32 build assertion failure
    + S8203491: [TESTBUG] Port heapdump tests into java
    + S8203641: Refactor String Deduplication into shared
    + S8203667: Platform specific include files in jdk image in
    wrong sub directory
    + S8203680: os::stat() on Posix platform does not need to copy
    input path
    + S8203691: Test /runtime/containers/cgroup/PlainRead.java fails
    + S8203809: [Graal] JDI tests fail with:
    JDITestRuntimeException : ** event IS NOT a breakpoint **
    + S8203813: javac accepts an illegal name as a receiver
    parameter name
    + S8203838: javac performance regression in 11+11
    + S8203915: Induction variable of over-unrolled loop conflicts
    with range checks
    + S8204152: SignedObject throws NullPointerException for null
    keys with an initialized Signature object
    + S8204166: TLH: Semaphore may not be destroy until signal have
    returned.
    + S8204169: Humongous continues region remembered set states do
    not match the one from the corresponding humongous start
    region
    + S8204172: Predicate::not should explicitly mention
    "NullPointerException - if target is null"
    + S8204231: Update Graal
    + S8204236: JFR unit test of thread CPU load should be enabled
    + S8204240: Extend MDO to allow more reasons to be recorded per
    bci
    + S8204268: Improve some IncompatibleClassChangeError messages.
    + S8204330: Javadoc IllegalArgumentException: HTML special
    chars in constant value
    + S8204342: methods in java.time s TCKZoneRules OpenJDK test
    miss Test annotation
    + S8204353: AARCH64: optimize FPU load and stores in
    macroAssembler
    + S8204454: Remove of sun.applet.AppletAudioClip
    + S8204473: AARCH64: register post-index addressing mode is not
    supported directly
    + S8204509: Fix compilation error in harfbuzz 1.7.6 for Solaris
    Developer Studio 12.6
    + S8204531: Remove unused chars following '\0'
    + S8204538: Split ScanClosure and ScanClosureWithParBarrier
    + S8204571: Add support for launching multiple startup
    recordings
    + S8204613: StringTable: Calculates wrong number of uncleaned
    items.
    + S8204620: ModuleEntry::is_non_jdk_module() determination for
    what is a jdk module is incorrect
    + S8204654: [testbug] Fix pattern matching in jstat tests.
    + S8204663: clean up remaining native parts after JDK-8187631
    + S8204664: PrepareFailureLogs should be done after sequential
    make targets
    + S8204666: javadoc should be updated to use jQuery 3.3.1
    + S8204668: Cleanup management of the java.vm.info System
    property
    + S8204679: HTTP Client refresh
    + S8204685: Abstraction for TLAB dummy object
    + S8204701: [TESTBUG] runtime/SharedArchiveFile/
    /BootAppendTests.java should handle mapping failure
    + S8204857: ConcurrentHashTable: Fix parallel processing
    + S8204859: [macosx] Remove javax/swing/plaf/nimbus/8057791/
    /bug8057791.java from the ProblemList.txt
    + S8204915: (fs) Add some print diagnostics to
    java/nio/file/Files/CopyAndMove.java
    + S8204922: Create bootcycle jib profiles
    + S8204923: Restore Symantec root verisignclass2g2ca
    + S8204927: ZGC: assert(phase->idom(head) ==
    head->in(LoopNode::EntryControl)) failed
    + S8204929: Fonts with embedded bitmaps are not always rotated
    + S8204935: [aix] TOC overflow in libjvm.so (release build)
    + S8204939: Change Access nomenclature: root to native
    + S8204941: Refactor TemplateTable::_new to use MacroAssembler
    helpers for tlab and eden
    + S8204943: Improve message of ArrayStoreException.
    + S8204944: Remove java/util/Map/InPlaceOpsCollisions.java from
    ProblemList
    + S8204957: Remove TestBiasedLockRevocationEvents from
    ProblemList.txt
    + S8204958: Minor cleanups for the diagnostic framework
    + S8204961: JVMTI jtreg tests build warnings on 32-bit platforms
    + S8204965: Fix '--disable-cds' and disable CDS on AIX by
    default
    + S8204973: Add build support for filtering translations
    + S8204978: [Graal] Disable Epsilon GC tests from running with
    Graal
    + S8205003: Replace selected link tags with linkplain in
    java.lang.Class
    + S8205006: Assertion failure when rehashing stringtable
    + S8205020: ZGC: Apply workaround for buggy sem_post() in glibc
    < 2.21
    + S8205022: ZGC: SoftReferences not always cleared before
    throwing OOME
    + S8205024: ZGC: Worker threads boost mode not always enabled
    when is should be
    + S8205025: [AOT] make jdk.aot module upgradeable
    + S8205028: ZGC: Remove incorrect comment in
    ZHeap::object_iterate()
    + S8205033: [REDO] Induction variable of over-unrolled loop
    conflicts with range checks
    + S8205034: [BACKOUT] Induction variable of over-unrolled loop
    conflicts with range checks
    + S8205043: Make parallel reference processing default for G1
    + S8205050: ZGC: Incorrect use of RootAccess in ZHeapIterator
    + S8205052: No compilation error thrown when no valid
    parameterization exists for functional interface type
    + S8205054: Could not find "lsof" on test machine
    + S8205055: Fix compilation optimization errors with new
    Solaris toolchain
    + S8205062: (fs) Improve some print diagnostics in
    java/nio/file/Files/CopyAndMove.java
    + S8205064: Fail immediately if an unavailable GC is selected
    + S8205074: [Graal] Add rest of compiler/stable tests into
    ProblemList-graal.txt
    + S8205091: AIX: build errors in hotspot after 8203641:
    Refactor String Deduplication into shared
    + S8205096: Add missing files for 8203394
    + S8205108: [testbug] Fix pattern matching in jstatd tests.
    + S8205110: Fix xchip warnings with new Solaris toolchain
    + S8205112: Remove non-existent modules from
    test/jdk/jdk/modules/etc/UpgradeableModules.java
    + S8205116: jdeps --system $java.home fails with IAE
    + S8205141: runtime/exceptionMsgs/ArrayStoreException/
    /ArrayStoreExceptionTest.java failed with
    "assert(k->is_objArray_klass()) failed: cast to ObjArrayKlass
    + S8205148: Turn off logging in jQuery-migrate
    + S8205149: hs201t002 should be put on the problem list
    + S8205163: ZGC: Keeps finalizable marked PhantomReference
    referents strongly alive
    + S8205172: 32 bit build broken
    + S8205181: ProblemList
    applications/ctw/modules/java_desktop_2.java
    + S8205183: Warning about using VS2017 should be removed
    + S8205338: ZGC: LeakProfiler not yet supported
    + S8205339: ZGC: VerifyBeforeIteration not yet supported
    + S8205341: AARCH64: Clean up duplicate uzp1 & uzp2 instruction
    definition
    + S8205344: TraceMemoryManagerStats changes in JDK-8195115
    broke ZGC
    + S8205407: [windows, vs<2017] C4800 after 8203197
- Modified patches:
  * generated-headers.patch
    + Better version resulting from discussion with upstream
  * java11-improved-fonts.patch
    + Rediff to changed context
* Thu Jun 14 2018 fstrba@suse.com
- Update to upstream tag jdk-11+18
  * Fixes:
    + S6350055: (se) SelectionKey.interestOps variants to
    atomically update interest ops
    + S8174734: Safepoint sync time did not increase
    + S8178374: Problematic ByteBuffer handling in
    CipherSpi.bufferCrypt method
    + S8190326: Robot.mouseMove uses scaling factor of main display
    on unscaled second display
    + S8194073: Invalid SunNativeProvider.INSTANCE initialization
    + S8195097: Make it possible to process StringTable outside
    safepoint
    + S8196030: AWT Robot mouseMove fails on Windows 10 1709 with
    HiDPI
    + S8196141: Add GoDaddy root certificates
    + S8196990: Resolve disabled warnings for libjli
    + S8196993: Resolve disabled warnings for libunpack
    + S8197930: JNI exception pending in initializeEncoding of
    jni_util.c
    + S8200132: Remove jre images and bundles
    + S8200387: [Graal] fromTonga/nsk/jdi tests hang with Graal as
    JIT
    + S8201193: Use XMM/YMM for objects initialization
    + S8201274: Launch Single-File Source-Code Programs
    + S8201407: Files.move throws DirectoryNonEmptyException when
    moving directory across file system
    + S8201528: Add new test to check for package versioning
    information in OpenJDK
    + S8201608: fix broken links in javax/sql/rowset/package.html
    and javax/sql/rowset/spi/package.html
    + S8202049: G1: ReferenceProcessor doesn't handle mark stack
    overflow
    + S8202088: Japanese new era implementation
    + S8202611: [GRAAL] Exclude CMS GC testing from runs with Graal
    + S8202705: ARM32 build crashes on long JavaThread offsets
    + S8202747: C2: assert(mode == ControlAroundStripMined && use
    == sfpt) failed: missed a node
    + S8202772: NMT thread stack tracking causes crashes on AIX
    + S8202864: [TESTBUG] Need to replace the image used in two
    Swing tests
    + S8203033: [Testbug] vmTestbase/nsk/jdi/TypeComponent/
    /isSynthetic/issynthetic002/TestDescription.java fails with
    nestmates
    + S8203172: Primitive heap access for interpreter
    BarrierSetAssembler/aarch64
    + S8203224: java.awt.desktop.*Event classes could not be
    instantiated if Desktop feature is not supported
    + S8203308: Remove the appletviewer classes
    + S8203329: JDWP/JDI VM information string is incorrect
    + S8203353: Fixup inferred decorators in the interpreter
    + S8203367: Upgrade to freetype 2.9.1
    + S8203425: assert(is_Loop()) failed: invalid node class
    + S8203480: IncompatibleClassChangeError thrown at sites linked
    to default interface methods
    + S8203499: Uninitialised memory in WinAccessBridge.cpp
    + S8203679: AssertionError in DeferredAttr with parenthesized
    method reference
    + S8203682: Add jcmd "VM.classloaders" command to print out
    class loader hierarchy, details
    + S8203796: Define API to support specifying ownership of print
    dialogs
    + S8203822: AIX version of jsig.c was not removed in JDK-8200298
    + S8203839: API clarification: versioned jar entry verification
    in multi-release jar file
    + S8204081: Mismatch in rebuild policy and collection set
    chooser causes remembered sets to be kept errorneously
    + S8204084: Remove the G1RSBarrierRegionFilter develop flag
    + S8204097: Simplify OopStorage::AllocateList block entry access
    + S8204110: serviceability/sa/ClhsdbSymbol.java and
    ClhsdbInspect.java failed when running in CDS mode
    + S8204113: Upgrade linker used in AOT tests to be same version
    as build toolchain
    + S8204118: [macos] Nonsensical self == [super init] in
    CFileDialog.m
    + S8204126: MonospacedGlyphWidthTest.java failed again
    + S8204127: Change bundle format on Windows to zip
    + S8204180: Implementation: JEP 318: Epsilon, A No-Op Garbage
    Collector
    + S8204187: Remove proprietary JPEG code from javax.imageio
    + S8204210: Implementation: JEP 333: ZGC: A Scalable
    Low-Latency Garbage Collector (Experimental)
    + S8204211: windows : handle potential C++ exception in
    GDIRenderer
    + S8204229: Formatter and String.format ignore the width with
    the percent modifier (%%5%%)
    + S8204243: remove Thread.destroy() and Thread.stop(Throwable)
    + S8204287: Phase timings not updated correctly after
    JDK-6672778
    + S8204288: Matching the end of a string followed by an empty
    greedy regex and a word boundary fails
    + S8204290: Add check to limit number of capture groups
    + S8204303: Add redirect for overview-summary.html
    + S8204335: [ppc] Assembler::add_const_optimized incorrect for
    some inputs
    + S8204375: Add TimeUnit#convert(Duration)
    + S8204377: Rename Object#wait parameter name from "timeout" to
    "timeoutMillis"
    + S8204444: java.time cleanup
    + S8204474: Have instanceRefKlass use HeapAccess when loading
    the referent
    + S8204476: Add additional statistics to
    CodeCache::print_summary
    + S8204477: Count linkage errors and print in
    Exceptions::print_exception_counts_on_error
    + S8204479: Bitwise AND on byte value sometimes produces wrong
    result
    + S8204494: Fix for 8200530 triggered regression,
    closed/test/jdk/security/infra/java/security/KeyStore/
    /BouncyCastleInterop.java failed
    + S8204496: backout fix for 8203796 which was pushed under
    another ID
    + S8204504: Fix for 8198285 breaks slowdebug builds
    + S8204539: improve error messages in matchJavaTZ [windows]
    + S8204549: [aix][testbug] signal tests fail because vm can not
    start in primordial thread.
    + S8204554: JFR TLAB tracing broken after 8202776
    + S8204557: NMT: Linux os::committed_in_range() does not break
    out outer loop when contiguous region is found
    + S8204561: JVM_GetClassSigners: wrap signers oop in an
    objArrayHandle for subsequent safepoint
    + S8204563: UseAppCDS obsolete message confusing
    + S8204565: (spec) Document java.{vm.}?specification.version
    system properties' relation to $FEATURE
    + S8204572: SetupJdkLibrary should setup SRC and -I flags
    automatically
    + S8204576: (fs) java/nio/file/Files/CopyAndMove.java does not
    set isUnix = true on macOS
    + S8204577: jittester generator doesn't kill processes on
    timeout
    + S8204584: jdeps generates illegal dot file containing
    ranksep=0,600000
    + S8204585: Remove IN_ARCHIVE_ROOT from Access API
    + S8204588: Test failures after "Launch Single-File Source-Code
    Programs"
    + S8204589: ProblemList failing launcher tests
    + S8204598: add more thread-related system settings info to
    hs_error file on Linux
    + S8204602: Add devkit for linux-arm32
    + S8204606: [Aarch64] SIGSEGVs caused by C1 because of improper
    register usage
    + S8204610: Compiler confused by parenthesized "this" in final
    fields assignments
    + S8204617: ParallelGC parallel reference processing does not
    set MT degree in reference processor
    + S8204618: The parallel GC reference processing task executor
    enqueues a wrong number of tasks into the queue
    + S8204628: [AArch64] Assertion failure in
    BarrierSetAssembler::load_at
    + S8204648: test/jdk/tools/launchers/SourceMode.java fails with
    long shebang line
    + S8204652: [aix] fix thread stack allocation, too big stack
    sizes not recognized
    + S8204674: Inconsistent lambda parameter span
    + S8204680: Disassembly does not display code strings in stubs
    + S8204682: Parsing for LOG=report=none is broken when combined
    with other keywords
    + S8204684: [AIX] Build of libjli_static broken after change
    8204572 (SetupJdkLibrary)
    + S8204694: Add failed compiler/stable tests into
    ProblemList-graal.txt
    + S8204850: BarrierSet::make_* should be static
    + S8204861: fix for 8196993 has broken the build on linux
- Modified patch:
  * system-pcsclite.patch
    + rediff to changed context
- Added patch:
  * generated-headers.patch
    + fix a regression after JDK-8204572
* Thu Jun  7 2018 fstrba@suse.com
- Update tu upstream tag jdk-11+17
  * Fixes:
    + S5109146: PNGMetadata Background color initialization from
    standard metadata is incomplete
    + S8050818: Predicate::not - provide an easier way to negate a
    predicate
    + S8072996: Deprecate stream-based GSSContext methods
    + S8150156: Update bugs.sun.com references to bugs.java.com
    + S8153029: ChaCha20 Cipher Implementation
    + S8154736: enhancement of cmpxchg and copy_to_survivor for
    ppc64
    + S8177276: MethodHandles.insertArguments doesn't specify
    IllegalArgumentException on index mismatch
    + S8187289: NotifyFramePop request is not cleared if
    JVMTI_EVENT_FRAME_POP is disabled
    + S8189335: javac exception when referencing private inner
    class with same name as normal class with dollar_1
    + S8189949: Remove Baltimore Cybertrust Code Signing CA
    + S8190417: javadoc updates to java.util.regex.Matcher
    + S8190875: modules not listed in overview/index page
    + S8191031: Remove several Symantec Root CAs
    + S8191522: Remove Bigelow&Holmes Lucida fonts from JDK sources
    + S8193552: ISO 4217 amendment 165
    + S8194327: [macos] AWT windows have incorrect main/key window
    behaviors
    + S8195624: Desktop API cannot be used without permission to
    read "os.version"
    + S8196373: Introspector does not see overridden generic setter
    method
    + S8197387: jcmd started by "root" must be allowed to access
    all VM processes
    + S8197989: java/util/zip/ZipFile/TestCleaner.java failed with
    "cleaner failed to clean zipfile
    + S8198285: More consistent Access API for arraycopy
    + S8198378: javac crash when checking imports and a broken
    class is present
    + S8199150: Accessibility issues in java.desktop
    + S8199268:
    docs/api/jdk.javadoc/com/sun/javadoc/package-summary.html
    contain low contrast text
    + S8199371: [TESTBUG] Open source vm testbase JDWP tests
    + S8199380: [TESTBUG] Open source VM testbase AOD tests
    + S8199388: Test development for ChaCha20 and Poly1305
    algorithms
    + S8199530: Upgrade to harfbuzz 1.7.6
    + S8199723: Test java/awt/TextComponent/
    /DeselectionDuringDoSelectionNonVisibleTest/
    /DeselectionDuringDoSelectionNonVisibleTest.java fails
    + S8199882: compiler/uncommontrap/TestDeoptOOM.java failed w/
    fatal error: ExceptionMark constructor expects no pending
    exceptions
    + S8199893: the javadoc tool generates pages with a low
    constrast
    + S8200052: libjavajpeg: Fix compile warning in jchuff.c
    + S8200166: Repeating annotations refering to to-be-generated
    classes don't work.
    + S8200288: [SPARC] "assert(!(is_cti(prev) && is_cti(insn)))
    failed: CTI-CTI not allowed"
    + S8200530: '\r' is not supported as "newline" in
    java.util.jar.Manifest
    + S8200623: Primitive heap access for interpreter
    BarrierSetAssembler/x86
    + S8201279: javax.sound tests should not set java.home system
    property
    + S8201364: [macosx] Component.getLocation() gives inconsistent
    coordinate for a component at (0,0)
    + S8201429: Support AIX Input Method Editor (IME) for AWT Input
    Method Framework (IMF)
    + S8202026: ISO 4217 amendment 166
    + S8202051: Address compilation warnings in libawt with VS2017
    + S8202094: jdk/jfr/api/recording/event/TestEventTime.java
    intermittently times out
    + S8202095: JFR TestBiasedLockRevocationEvents should cope with
    multiple events during a single safepoint
    + S8202360: [TESTBUG] runtime/LoadClass/TestResize.java needs
    to print output when it fails
    + S8202547: Move G1 runtime calls used by generated code to
    G1BarrierSetRuntime
    + S8202627: javadoc generates broken links to deprecated items
    when -nodeprecated is used
    + S8202670: Update Graal
    + S8202758: SIGSEGV calling
    Class.forName(String,Boolean,ClassLoader) with mocked loader
    + S8202776: Modularize GC allocations in runtime
    + S8202812: [TESTBUG] Open source VM testbase compiler tests
    + S8202913: loader constraint message for fields specifies
    incorrect referring class
    + S8203027: Open source tests for "java.awt.geom"
    + S8203031: segfaults from jvmti_AddToBootstrapClassLoaderSearch
    + S8203182: Release session if initialization of SunPKCS11
    Signature fails
    + S8203219: VM.metaspace jcmd should optionally show loaded
    classes for loaders
    + S8203237: JFR TestBiasedLockRevocationEvents should ignore
    events unrelated to the test
    + S8203319: JDK-8201487 disabled too much queue balancing
    + S8203321: assert(current_query_index <
    process_query_set->size) failed: invariant
    + S8203324: Use out of scope in getMacOSXLocale of
    java_props_macosx.c:120
    + S8203380: Missing platform and bug information for
    MouseModifiersInKeyEvent test
    + S8203435: Circular nested dynamic constant test needed to
    confirm JVMS resolution behavior
    + S8203445: [TESTBUG] Remove
    appcds/jigsaw/limitmods/LimitModsTests.java
    + S8203474: Update description of "Cyrillic Supplementary"
    block name in Character.UnicodeBlock class.
    + S8203485: [freetype] text rotated on 180 degrees is too narrow
    + S8203498: The specification for java.applet package should be
    updated
    + S8203669: PPC64: Fix jtreg RTM tests after "8203305: Improve
    TM detection for enabling RTM on Linux / POWER9"
    + S8203765: java/nio/channels/Selector/SelectAndClose: add some
    prints and @intermittent tag
    + S8203780: javadoc should be updated to use jquery 1.12.4,
    jquery-ui 1.12.1 and jszip v3.1.5
    + S8203787: Hotspot build broken on linux-sparc after 8202377
    + S8203802: Jvmti test fails to build with VS2017
    + S8203827: Upgrade JLine to 2.14.6
    + S8203837: Split nmethod unloading from inline cache cleaning
    + S8203872: Upgrading JDK with latest available LSR data from
    IANA.
    + S8203891: Upgrade JOpt Simple to 5.0.4
    + S8203919: Remove "-add-modules" hint from error message
    + S8203921: JFR thread sampling is missing fixes from
    JDK-8194552
    + S8203923: Add @requires feature to check flag values for the
    running JVM
    + S8203924: Zero: bootcycle-images build fails on x86_64
    + S8203937: Not possible to read data from socket after write
    detects connection reset
    + S8203939: JVMFlag::printError missing ATTRIBUTE_PRINTF
    + S8203945: Cleanup nashorn build
    + S8203946: Move UnpackSecurity.gmk to closed
    + S8203948: Expand JVMTI callback notion of "internal threads"
    + S8203960: [TESTBUG] runtime/logging/DefaultMethodsTest.java
    failed when running in CDS mode
    + S8204055: SIGSEGV in java -XX:
    + S8204085: avoid printing uninitialized pointer in
    java.desktop/windows/native/libawt/java2d/windows/
    /GDIWindowSurfaceData.cpp
    + S8204087: C++ Interpreter code left over in MethodData
    + S8204091: Configure broken on MIPS when uname returns mipsel
    or mips64el
    + S8204094: assert(worker_i < _length) failed: Worker 15 is
    greater than max: 11 at ReferenceProcessorPhaseTimes
    + S8204095: [TESTBUG] TestPrintReferences.java fails if
    multiple concurrent mark happens
    + S8204103: Mark test
    serviceability/dcmd/compiler/CompilerQueueTest.java as
    intermittent and exclude it from tier1
    + S8204109: JDK-8203945 broke nashorn
    + S8204122: Update harfbuzz.md
    + S8204134: jtreg: Fix RTM abort provoker for various tests
    after "8149159: Clean up Unsafe"
    + S8204136: jtreg: Fix failing RTM test RTMSpinLoopCount
    + S8204160: BiasedLockingTest needs -XX:+UseBiasedLocking
    + S8204162: TestG1HeapRegion needs @requires vm.gc.G1
    + S8204163: Also detect concurrent GCs in MetaspaceBaseGC.java
    + S8204164: OOM-only logging in Metaspace
    + S8204165: Filter out tests requiring class unloading when
    ClassUnloading is disabled
    + S8204167: Filter out tests requiring compressed oops when
    CompressedOops is disabled
    + S8204168: Increase small heap sizes in tests to accommodate
    ZGC
    + S8204173: Lower the minimum number of heap memory pools in
    MemoryTest.java
    + S8204179: [BACKOUT] OopStorage should use GlobalCounter
    + S8204194: Lazily create
    MethodHandleImpl$AsVarargsCollector.asCollectorCache
    + S8204195: Clean up macroAssembler.inline.hpp and other
    inline.hpp files included in .hpp files
    + S8204199: Test fails after 8202670 Graal update
    + S8204237: Clean up incorrectly included .inline.hpp files
    from jvmciJavaClasses.hpp
    + S8204250: Problem list pkcs11 tests on windows
    + S8204269: ISO 4217 amendment 167
    + S8204277: [testbug] fix DisassembleCodeBlobTest.
    + S8204292: PPC64: Fix missing includes after 8204195
    + S8204295: [BACKOUT] - JVMFlag::printError missing
    ATTRIBUTE_PRINTF
    + S8204301: Make OrderAccess functions available to hpp rather
    than inline.hpp files
    + S8204321: javadoc tests fail after JDK-8203780
    + S8204322: "+=" applied to String operands can provoke side
    effects
    + S8204341: AArch64: AOT runtime does not need a workaround for
    far calls
    + S8204345: [s390]: no precompiled headers build broken
    + S8204348: AArch64: Remove C2 address reshaping code
* Tue Jun  5 2018 fstrba@suse.com
- Change the alternatives priority from 0 to 2105, since OpenJDK 11
  should now be in a shape to be able to be used.
* Tue Jun  5 2018 fstrba@suse.com
- Change build requirement to Java 10 or 11, since Java 9 cannot
  build OpenJDK 11 any more.
* Thu May 31 2018 fstrba@suse.com
- Update to upstream tag jdk-11+16
  * Fixes:
    + S8133564: Runtime - 2nd followup to Validate JVM Command-Line
    Flag Arguments
    + S8184030: TestUseRTMLockingOptionOnUnsupportedVM - RTM
    locking optimization not supported is missing
    + S8188248: NullPointerException on generic methods
    + S8189766: whitebox failure with -Xcheck:jni
    + S8191844: Remove SECOM root (secomevrootca1)
    + S8193717: Import resolution performance regression in JDK 9
    + S8194298: Add support for per Socket configuration of TCP
    keepalive
    + S8194630: Uninitialized initiator_address in native GSS
    + S8196202: Javadoc should not generate frames by default
    + S8196913: javadoc does not (over)write stylesheet.css
    + S8198323: testing.md not updated for repository layout change
    + S8199255: [TESTBUG] Open source VM testbase default methods
    tests
    + S8199307: NPE in
    jdk.javadoc.internal.doclets.toolkit.util.Utils.getLineNumber
    + S8199383: [TESTBUG] Open source VM testbase JVMTI tests
    + S8200172: String.split non-positive term incorrect use
    + S8200266: [Graal] Update ProblemList-graal.txt files
    + S8201518: add test for randomized iteration order of
    unmodifiable Set and Map
    + S8202178: type.getKind() for var is None instead of Error
    + S8202290: AtomicAppend tests fail on macOS 10.13 ("High
    Sierra")
    + S8202813: Move vm_weak processing from SystemDictionary to
    WeakProcessor
    + S8202832: cycle detection depends on ordering of requires
    directives
    + S8202842: G1 footprint regressions in jdk11+10
    + S8202945: OopStorage should use GlobalCounter
    + S8202947: Fix minor issues with taglets
    + S8202949: C2: assert(false) failed: Bad graph detected in
    build_loop_late
    + S8202950: C2: assert(found_sfpt) failed: no node in loop
    that's not input to safepoint
    + S8203014: jcmd should output command list if no command is
    given
    + S8203028: Simplify reference processing in light of
    JDK-8175797
    + S8203041: AArch64: fix overflow in immediate cmp/cmn
    instruction
    + S8203183:
    vmTestbase/vm/mlvm/anonloader/stress/oome/heap/Test.java times
    out
    + S8203221: Makefile fixes after Flight Recorder
    + S8203225: Fix of redefining a method that removes 1 or more
    lambda expressions failed to commit test cases
    + S8203233: (tz) Upgrade time-zone data to tzdata2018e
    + S8203262: Incorrect cmpxchg usage in
    MetaspaceGC::inc_capacity_until_GC
    + S8203297: java/net/URL/OpenStream.java fails intermittently
    + S8203327: Small cleanups in java.lang.ref
    + S8203328: Rename EFS in java.util.zip internals to something
    meaningful
    + S8203354: assert in
    ClassLoader::update_module_path_entry_list() could have
    incorrect message
    + S8203366: Tag added wrongly in Docs.gmk
    + S8203368: ObjectInputStream filterCheck method throws
    NullPointerException
    + S8203369: Check for both EAGAIN and EWOULDBLOCK error codes
    + S8203370: [JVMCI] UseJVMCICompiler should imply EnableJVMCI
    + S8203455: jcmd: VM.metaspace: print loader name for anonymous
    CLDs
    + S8203488: Remove error generation from TransTypes
    + S8203497: Bump Jib format version to 1.2
    + S8203628: Optimize (masked) byte memory comparisons on x86
    + S8203686: Add JDK 11 major version to
    javax/net/ssl/compatibility/JdkRelease.java
    + S8203689: Add failure code to threaddb exception messages`
    + S8203699: java/lang/invoke/SpecialInterfaceCall fails with
    SIGILL on aarch64
    + S8203766: Add some instrumentation to
    jdk/java/nio/channels/Selector/RacyDeregister.java
    + S8203769: ProblemList
    test/jdk/java/util/Map/InPlaceOpsCollisions.java
    + S8203774: jdk/jfr/api/recorder/TestStartStopRecording.java
    failed due to compilation failed
    + S8203793: cacerts/VerifyCACerts.java fails with
    java.lang.Exception: At least one cacert test failed
    + S8203795: Change default compiler on Windows to VS2017
    + S8203815: add tests failed because of 8203809 to the
    ProblemList-graal
    + S8203816: add tests failed because of 8203174 to the
    ProblemList-graal
    + S8203817: Monitor::try_lock() should not call
    check_prelock_state()
    + S8203843: BasicParState::default_estimated_thread_count(false)
    can return 0 in gtest
    + S8203865: Metaspace cleanup: Remove unused MemRegion in
    VirtualSpaceNode
    + S8203881: Print erroneous size in NegativeArraySizeException
    + S8203885: ConcurrentLocksDump::dump_at_safepoint() should not
    allocate array in resource area
    + S8203886: Invoke LambdaMetafactory::altMetafactory exactly
    from the BootstrapMethodInvoker
    + S8203892: Target interface added as marker interface in calls
    to altMetafactory
    + S8203926: Problem list
    test/langtools/tools/javac/importscope/T8193717.java
    + S8203932: Windows devkit has wrong dlls in 32 bit tools dir
    + S8203938: Fix build failures from JDK-8133564
* Fri May 25 2018 fstrba@suse.com
- Update to upstream tag jdk-11+15
  * Fixes:
    + S8027760: JFC schema condition should not have defaults
    + S8134537: Much nearly duplicated code for sun.misc.Signal
    support
    + S8146293: Add support for RSASSA-PSS Signature algorithm
    + S8148354: Errors targeting functional interface intersection
    types
    + S8176808: Split up metaspace.cpp
    + S8185803: JdbExprTest.sh fails in JDK10-hs nightly due to
    "Name unknown: java.lang.Long.MAX_VALUE "
    + S8192992: Test8007294.java failed: attempted to spill a
    non-spillable item
    + S8193332: MetaspaceShared::check_shared_class_loader_type is
    not used during archive creation
    + S8195098: Low latency hashtable for read-mostly scenarios
    + S8195817: JFR.stop should require name of recording
    + S8195818: JFR.start should increase autogenerated name by one
    + S8195819: Remove recording=x from jcmd JFR.check output
    + S8196048: thrown type variables should be roots in the
    minimum inference graph
    + S8196201: Generate pages to list all classes and all packages
    in javadoc output
    + S8196619: [TESTBUG] restore current version check in
    runtime/appcds/MultiReleaseJars.java
    + S8196987: Resolve disabled warnings for libzip
    + S8198315: Incomplete classpath causes NPE in TransTypes
    + S8198337: -XX:StartFlightRecording=dumponexit=true,disk=false
    doesn't work
    + S8198548: Initialization race in
    com.sun.org.apache.xerces.internal.impl.xpath.regex.Token.getRange()
    on Token.categories
    + S8199064: Test applications/jcstress/other/Test.java#id1108
    fails on Sparc
    + S8199257: [TESTBUG] Open source VM testbase metaspace tests
    + S8199271: [TESTBUG] open source VM testbase stress tests
    + S8199370: [TESTBUG] Open source vm testbase GC tests
    + S8199379: [TESTBUG] Open source vm testbase JDB tests
    + S8199384: [TESTBUG] Open source VM testbase MLVM tests
    + S8199807: AppCDS performs overly restrictive path matching
    check.
    + S8200380: String::lines
    + S8200436: String::isBlank
    + S8201331: Better test cleanup for
    jdk/jfr/api/consumer/TestRecordingFile.java
    + S8201386: Miscellaneous changes imported from jsr166 CVS
    2018-05
    + S8201627: Kerberos sequence number issues
    + S8201867: Kerberos keytabs with holes in certain places are
    parsed incorrectly
    + S8202014: Possible to receive signal before signal semaphore
    created
    + S8202076: test/jdk/java/io/File/WinSpecialFiles.java on
    windows with VS2017
    + S8202305: [Graal] org.graalvm.compiler.core.test.GraphResetDebugTest
    fails with java.util.ServiceConfigurationError
    + S8202377: Modularize C2 GC barriers
    + S8202427: Enhance os::print_memory_info on Windows
    + S8202466: Test serviceability/tmtools/jstat/GcTest01.java
    fails: Number of concurrent GC events is 1, but CGCT is 0
    + S8202479: Add missing try_resolve_jobject_in_native calls
    + S8202669: Intermittent crash in
    ClassLoadingService::compute_class_size()
    + S8202685: Optimize ArrayList subList replaceAll
    + S8202710: AARCH64: sporadic jtreg test fail
    + S8202713: Create a MacroAssembler::access_load/store_at
    wrapper for S390 and PPC
    + S8202771: Migrate Unicode character tests to JDK Repo
    + S8202848: -XX:+ExecuteInternalVMTests asserts with
    "assert(cd.valid() == true) failed: failed on a valid
    DirectivesParser string"
    + S8202853: NotifyCount is not initialized
    + S8202863: Rename OopStorage inner collection classes
    + S8202978: Incorrect tmp register passed to
    MacroAssembler::load_mirror()
    + S8202989: Add missing decorators in calls to to
    arraycopy_prologue/epilogue
    + S8203196: C1 emits incorrect code due to integer overflow in
    _tableswitch keys
    + S8203215: IdealLoopTree::split_outer_loop leaves phi-nodes
    with only one input
    + S8203227: Introduce os::processor_id() for Linux and Solaris
    + S8203279: Faster rounding up to nearest power of two
    + S8203287: Zero fails to build after JDK-8199712 (Flight
    Recorder)
    + S8203288: PPC64 and s390 fail to build after JDK-8199712
    (Flight Recorder)
    + S8203292: Print complete set of flags in the hs_err file
    + S8203305: PPC64: Improve TM detection for enabling RTM on
    Linux / POWER9
    + S8203318: compiler/stable/TestStableShort.java is broken
    + S8203339: Add oopDesc::field_offset()
    + S8203341: Add a safepoint-aware Semaphore
    + S8203346: JFR: Inconsistent signature of
    jfr_add_string_constant
    + S8203352: Improve java implementation of
    Integer/Long.numberOfLeadingZeros
    + S8203355: MITSHM define guarding missing
    + S8203377: Cleanup the usage of os::file_name_strcmp() in
    SharedPathsMiscInfo::check().
    + S8203381: Replace InstanceKlass::allocate_instance_handle
    with JavaCalls::construct_new_instance
    + S8203391: Update com/sun/jdi/JdbMethodExitTest.sh to pass
    valid URL[]
    + S8203398: Test test/langtools/tools/javac/options/release/
    /ReleaseOptionCurrent.java writes into the source directory
    + S8203400: Fix issue with "8199852: Print more information
    about class loaders in LinkageErrors."
    + S8203410: Zero: Disable jfr feature by default
    + S8203431: TestFloatsOnStackDeopt.java throws
    java.lang.LinkageError: loader <bootstrap> attempted duplicate
    class definition for
    java.lang.invoke.BoundMethodHandle$Species_LLL
    + S8203436: javac should fail early when emitting illegal
    signature attributes
    + S8203437: 8199370 broke build on linux-ppc64le (w/ GCC 4.8.5.)
    + S8203454: Minimal, Zero builds fail after JDK-8202377
    (Modularize C2 barriers)
    + S8203457: Add back missing full buffer notification
    + S8203486: skip type inference for non functional interface
    components of intersection types
    + S8203487: Typo in ICUBinary.java: s/Magin/Magic/
    + S8203490: StringTable::dump lacks a load barrier
    + S8203500: Fix broken links to Specification in "specs"
    directory
    + S8203626: ProblemList
    compiler/runtime/TestFloatsOnStackDeopt.java
    + S8203635: JFR sampler thread does not record stack info
    + S8203694: Add a safepoint-aware Semaphore - part 2
- Removed patch:
  * fix-s390x-and-ppc64-builds.patch
    + integrated upstream
* Tue May 22 2018 fstrba@suse.com
- Added patch:
  * fix-s390x-and-ppc64-builds.patch
    + upstream fix for broken s390x and ppc64/ppc64le builds
* Thu May 17 2018 fstrba@suse.com
- Update to upstream tag jdk-11+14
  * Fixes:
    + S8132287: obsolete the "InlineNotify" flag option
    + S8174995: SA: clhsdb 'where -a' throws Assertion Failure with
    illegal code 236 when CDS is used
    + S8176510: java/awt/font/GlyphVector/TestLayoutFlags.java
    fails with OpenJDK
    + S8183910: gc/arguments/TestAggressiveHeap.java fails
    intermittently
    + S8185505: AArch64: Port AOT to AArch64
    + S8189140: SystemDictionaryShared::initialize() should be
    renamed to be more meaningful
    + S8189271: Metaspace::_capacity_until_GC should be size_t
    + S8191533: jar --describe-module prints service provider class
    names in lower case
    + S8193935: Illegal countedLoops transformation
    + S8194998: broken error message for subclass of interface with
    private method
    + S8195613: [SA] HotSpotTypeDataBase.readVMLongConstants
    truncates values to int
    + S8196340: (coll) Examine overriding inherited methods in
    ArrayList and ArrayList.SubList
    + S8196360: java/awt/Dialog/SiblingChildOrder/
    /SiblingChildOrderTest.java fails
    + S8196616: java/awt/GraphicsDevice/DisplayModes/
    /CompareToXrandrTest.java fails
    + S8197948: Create test for SwingSet2 main window
    + S8198412: MonospacedGlyphWidthTest.java may fail on Solaris
    + S8198991: Move Java2D demo to the open repository
    + S8199252: [TESTBUG] Open source VM testbase system dictionary
    tests
    + S8199712: Flight Recorder
    + S8200377: String::strip, String::stripLeading,
    String::stripTrailing
    + S8201447: C1 does backedge profiling incorrectly
    + S8201491: G1 support for java.lang.ref.Reference precleaning
    + S8201532: Update idom to get correct dom depth calculation
    + S8201593: Print array length in
    ArrayIndexOutOfBoundsException.
    + S8201604: ARM64 - Build failure after JDK-8193260
    + S8202016: Use obj+offset in interpreter array access
    + S8202064: Jemmy JInternalFrameOperator: Add wait for close(),
    activate(), resize() and move() operations
    + S8202113: Reflection API is causing caller classes to leak
    + S8202289: Non-empty directory in module path is not handled
    properly at CDS/AppCDS dump time
    + S8202322: AIX: symbol visibility flags not support on xlc 12.1
    + S8202392: [TESTBUG] open source vm testbase heapdump tests
    + S8202395: AARCH64: wrong encoding for SIMD instructions zip,
    trn, uzp
    + S8202426: NPE thrown by Transformer when XMLStreamReader
    reports no xml attribute type
    + S8202476: ImageLib is broken in 32 bit Windows
    + S8202519: Crash during large AppCDS dump
    + S8202544: Hide unused exports in libzip
    + S8202553: Update FXLauncherTest as part of removing JavaFX
    from JDK
    + S8202557: OpenJDK fails to start in Windows 7 and 8.1 after
    upgrading compiler to VC 2017
    + S8202580: Dashed BasicStroke randomly painted incorrectly,
    may freeze application
    + S8202614: Add ability to validate links in JavadocTester
    + S8202679: Updates on windows failures in the problem list
    + S8202683: Minimal VM should build cleanly on 64-bit platforms
    + S8202708: Add a check of opening stream for not-existing UNC
    url
    + S8202714: Create a MacroAssembler::access_load/store_at
    wrapper for AArch64
    + S8202718: Jemmy JInternalFrameOperator: Dependency with
    orders of Minimize, Maximize and Close buttons
    + S8202738: vm_version Abstract_VM_Version::internal_vm_info_string()
    returns same string for different incremental builds
    + S8202745: Remove hyphens from "out-of-bounds".
    + S8202748: jtreg :hotspot_misc group shouldn't include
    vmTestbase tests
    + S8202756: move FilterUSRTest.java to openJDK
    + S8202763: failure_handler: list open files for macOS
    + S8202764: api/java_text/SimpleDateFormat/index.html#Format
    testcases started to fail with JDK11 b12
    + S8202767: java/awt/font/GlyphVector/TestLayoutFlags.java is
    missing null check
    + S8202773: Unhandled oop in JavaThread::collect_counters
    + S8202811: Problem List some tests that leave windows open on
    the desktop
    + S8202822: Add .git to .hgignore
    + S8202824: Cleanup discrepancies in ProblemList for java_awt
    jtreg tests
    + S8202829: Implement CollectedHeap::get_safepoint_workers()
    for G1
    + S8202843: langtools ant build fails
    + S8202878:
    com/apple/laf/ScreenMenu/ScreenMenuMemoryLeakTest.java fails
    + S8202889: Remove trailing LF from perf log
    + S8202914: Let custom makefile override jmod intput dir
    locations
    + S8202915: [JAXP] Performance enhancements and cleanups in
    com.sun.org.apache.xerces.internal.impl.dtd.XMLDTDValidator
    + S8202919: JDK-8202683 broke macosx build
    + S8202920: jvm.cfg generation incorrect
    + S8202974: Backout JDK-8202683
    + S8202976: Add C1 lea patching support for x86
    + S8202993: Add support for x86 testptr/testq with register and
    address
    + S8202994: Add support for undoing last TLAB allocation
    + S8202997: Split test/jdk/:tier1 to enable better parallel
    execution
    + S8203032: PrintMetaspaceDcmd fails: Non-Class: missing from
    stdout/stderr
    + S8203059: (so) Closing a socket channel registered with
    Selector and with SO_LINGER set to 0 does not reset connection
    + S8203176: javadoc handles non-ASCII characters incorrectly.
    + S8203220: Introduce ATTRIBUTE_ALIGNED macro
    + S8203223: Signed integer overflow in ImageStrings::hash_code
    (libjimage.so)
    + S8203250: runtime/LoadClass/test-classes/Hello.java has wrong
    legal notice
    + S8203251: Non-PCH build failed after JDK-8199712 (Flight
    Recorder)
    + S8203274: 32-bit build failures after JDK-8199712 (Flight
    Recorder)
    + S8203278: AArch64/PPC64 build failures after JDK-8199712
    (Flight Recorder)
    + S8203285: Minimal VM fails to build after JDK-8199712 (Flight
    Recorder)
* Mon May 14 2018 fstrba@suse.com
- s390x: avoid packaging files that are not present on this
  architecture
* Fri May 11 2018 fstrba@suse.com
- Update to ustream tag jdk-11+13
  * Fixes:
    + S4842658: DefaultListModel and DefaultComboBoxModel should
    support addAll (Collection c)
    + S6574555: PNGImageWriter incorrectly sets bKGD chunk
    + S6788458: PNGImageReader ignores tRNS chunk while reading
    non-indexed RGB/Gray images
    + S8153532: Add @throws NPE javadoc to
    UIManager.setLookAndFeel(String) method description
    + S8154463: New failure of
    closed/java/awt/font/Outline/OutlineInvarianceTest.java
    + S8171277: Elliptic Curves for Security in Crypto
    + S8176717: GC log file handle leaked to child processes
    + S8181594: Efficient and constant-time modular arithmetic
    + S8181910: [macos] Support dark title bars on macOS
    + S8185034: Cleanup and consolidate Metaspace coding
    + S8187123: (reflect) Class#getCanonicalName and
    Class#getSimpleName is a part of performance issue
    + S8187392: Deprecated methods in the peers can be removed
    + S8189687: Swing: Invalid position of candidate pop-up of
    InputMethod in Hi-DPI on Windows
    + S8189916: Dynamic Constant support for Sparc
    + S8191410: Unicode 10
    + S8194968: problem list actions for
    tools/javac/jvm/VerboseOutTest
    + S8195002: Fix test/hotspot/jtreg/gtest/GTestWrapper.java on
    Alpine/Musl
    + S8195717: test java/lang/invoke/MethodHandlesTest timed out
    running testAsCollector1
    + S8196113: Remove the Compact Profile builds
    + S8196572: Tests ColConvCCMTest.java and MTColConvTest.java
    fail
    + S8197388: Added not existing bug id in jdk/ProblemList.txt
    + S8197447: LogCompilation throws "couldn't find bytecode"
    + S8197954: Remove unnecessary intermediary APIs from AppCDS
    implementation
    + S8198342: Test FileSystemViewListenerLeak.java is unstable
    + S8199067: [REDO] NMT: Enhance thread stack tracking
    + S8199196: Add javadoc support for preview features
    + S8199382: [TESTBUG] Open source VM testbase JDI tests
    + S8199748: Touch keyboard is not shown, if text component gets
    focus from other text component
    + S8199852: Print more information about class loaders in
    LinkageErrors.
    + S8199912: jshell tool: /open from URI
    + S8199932: Missing copyright header in AWT source code
    + S8200083: Bump bootjdk requirement for JDK 11 to JDK 10
    + S8200094: Turkish locale reports NPE No enum constant
    com.sun.source.doctree.DocTree.Kind.SİNCE
    + S8200146: Remove the appletviewer launcher
    + S8200313: java/awt/Gtk/GtkVersionTest/GtkVersionTest.java
    fails
    + S8200372: String::trim JavaDoc should clarify meaning of space
    + S8200557: OopStorage parallel iteration scales poorly
    + S8200716: Object propertyIsEnumerable buggy behavior on short
    integer-string key
    + S8200729: Conditional compilation of GCs
    + S8201138: Defect in XMLEventReader.getElementText() may cause
    data to be skipped, duplicated or otherwise result in a
    ClassCastException
    + S8201433: Fix potential crash in BufImg_SetupICM
    + S8201492: Properly implement non-contiguous generations for
    Reference discovery
    + S8201524: [AIX] Don't link libfontmanager against
    libawt_headless
    + S8201572: Improve Metaspace Statistics
    + S8201598: Fix for 8181910: Support dark title bars on macOS
    broke the MacOS build
    + S8201602: ARM32 - Minimal Dynamic Constant support
    + S8201626: Typo in MakeWindowAlwaysOnTop test
    + S8201640: Use _ref_processor_* member variables directly in
    G1CollectedHeap
    + S8201793: (ref) Reference object should not support cloning
    + S8202017: Merge Reference Enqueuing phase with phase 3 of
    Reference processing
    + S8202018: Move card table clear before enqueuing pending
    references
    + S8202021: Improve variable naming in ReferenceProcesso
    + S8202050: Add javax/sound/midi/Sequencer/Recording.java to
    the problemList
    + S8202080: Introduce ordering semantics for Atomic::add and
    other RMW atomics
    + S8202083: Remove explicit CMS checks in CardTableBarrierSet
    + S8202143: Parts of 8193435 added in merge change set.
    + S8202181: Correctly specify size of hostname buffer in Unix
    Inet*AddressImpl_getLocalHostName implementations
    + S8202291: java/rmi/Naming/LookupIPv6.java failed with
    Connection refused
    + S8202301: Add tests related to JDK-8196572 to the ProblemList
    + S8202303: LogStream should autoflush on destruction
    + S8202319: Fix compilation warnings in Solaris debug builds
    for DevStudio 12.6
    + S8202387: javac --release 11 not supported
    + S8202424: Metaspace: on chunk retirement, use correct lower
    limit on chunksize when adding blocks to free blocks list
    + S8202435: [aix] print program break as part of memory info
    into hs-err file
    + S8202447: Fix unloading_occurred to mean unloading_occurred
    + S8202465: [C1] casts should not be eliminated for interface
    types
    + S8202548: Use reservation Object when creating SpeciesData
    + S8202552: [AOT][JVMCI] Incorrect usage of INCLUDE_JVMCI and
    INCLUDE_AOT
    + S8202563: BigInteger/BigDecimal not immune to overflow,
    contrary to spec
    + S8202564: java/lang/management/ThreadMXBean/ThreadCounts.java
    fails
    + S8202565: C1 compilation crashes with
    "assert(is_double_stack() && !is_virtual()) failed: type check"
    + S8202575: Remove java/lang/String/nativeEncoding/
    /StringPlatformChars.java from ProblemList
    + S8202581: failure_handler: gather more environment
    information on macOS
    + S8202582: DateTimeFormatterBuilder.parseOffsetBased
    unnecessarily calls toString()
    + S8202583: Remove experimental ClassForNamePlugin
    + S8202584: de-problem list tools/javac/jvm/VerboseOutTest
    + S8202591: Remove usage of CMSEdenChunksRecordAlways in
    defNewGeneration.cpp
    + S8202592: Remove unused EvacuateFollowersClosure
    + S8202597: javac is not inducing a notional interface if
    Object appears in an intersection type
    + S8202599: Mark intermittently failing jshell tests
    + S8202606: Deprecate AllowNonVirtualCalls option
    + S8202631: JVM_Clone to throw CloneNotSupportException for
    Reference object
    + S8202634: Metaspace: simplify SpaceManager lists
    + S8202639: Use concrete Generation classes in SerialHeap and
    CMSHeap
    + S8202640: Small C1 cleanups for BarrierSetC1
    + S8202641: Replace OOP_SINCE_SAVE_MARKS with templates
    + S8202642: Replace PAR_OOP_ITERATE with templates
    + S8202647: Add deduplicate_string function to CollectedHeap
    + S8202649: Move the Parallel GC specific task creation
    functions out of Threads
    + S8202650: Enforce group for attach listener file
    + S8202662: JFR tests fails: Could not find leak with class
    + S8202672: Build failed in metaspace.cpp with VS2017
    + S8202676: AArch64: Missing enter/leave around barrier leads
    to infinite loop
    + S8202684: Minimal VM build is broken after JDK-8199067,
    JDK-8202638
    + S8202686: Missing test case for 8200167 - final Object methods
    + S8202690: jdk/jshell/ToolBasicTest.java failed in
    testOpenFileOverHttp() and testOpenLocalFileUrl()
    + S8202709: Move oopDesc::is_archive_object to
    MetaspaceShared::is_archive_object
    + S8202711: Merge tiered compilation policies
    + S8202719: Use Collections.emptyEnumeration where possible
    + S8202722: Move marksweep_init into GC code
    + S8202744: Expired flag removal for JDK 11
    + S8202780: Remove EnqueueTask related code from
    ReferenceProcessor after JDK-8202017
    + S8202781: Fix typo in DiscoveredListIterator::complete_enqeue
    + S8202810: Remove class-for-name test
    + S8202816: Update JarSigning.keystore
- Removed patch:
  * aarch64-infinite-loop.patch
  - Integrated upstream
- Modified patch:
  * java11-improved-fonts.patch
  - Rediff to changed context
* Thu May 10 2018 fstrba@suse.com
- Fix s390x build, since INCLUDE_SA is false by default on this
  architecture
* Tue May  8 2018 fstrba@suse.com
- Added patch:
  * aarch64-infinite-loop.patch
    + Fix inifinite loop in aarch64 build
* Mon May  7 2018 guillaume.gardet@opensuse.org
- Update fix_armv6_build.patch
* Mon May  7 2018 fstrba@suse.com
- Update to upstream tag jdk-11+12
  * Fixes:
    + S6672778: G1 should trim task queues more aggressively during
    evacuation pauses
    + S8154204: [TESTBUG] Update DefaultUseWithClient test to
    handle client-less builds
    + S8174994: SA: clhsdb printmdo throws WrongTypeException when
    attached to a process with CDS
    + S8179071: Month value is inconsistent between CLDR and Java
    in some locales
    + S8179887: Build failure with glibc >= 2.24: error: 'int
    readdir_r(DIR*, dirent*, dirent**)' is deprecated
    + S8181157: CLDR Timezone name fallback implementation
    + S8182731: Odd handling of -XX:-UseAppCDS and
  - XX:SharedArchiveFile.
    + S8191471: Elastic TLABs for G1
    + S8191798: redo nested ThreadsListHandle to drop Threads_lock
    + S8193213: Make the UseAppCDS option obsolete.
    + S8197959: [TESTBUG] Some (App)CDS tests require modification
    due to the removal of the Java EE and CORBA modules
    + S8197960: [TESTBUG] remove/modify runtime tests which use
    java ee or corba modules
    + S8199375: [TESTBUG] Open source vm testbase monitoring tests
    + S8199643: [TESTBUG] Open source common VM testbase code
    + S8200167: Validate more special case invocations
    + S8200235: Generalize jniFastGetField jobject/jweak resolve
    + S8200466: Revisit the setting of _transitive_interfaces in
    InstanceKlass
    + S8200478: For boxing conversion javac uses Long.valueOf which
    does not guarantee caching according to its javadoc
    + S8201367: assert(current != first_mem) failed: corrupted
    memory graph in superword code
    + S8201509: Zero: S390 31bit atomic_copy64 inline assembler is
    wrong
    + S8201542: Remove unused _gc_timer field in GCMemoryManager
    + S8201543: Modularize C1 GC barriers
    + S8201545: InetAddress.getByName/getAllByName should clarify
    empty String behavior
    + S8201622: Reduce unnecessary Package.complete() calls in
    javadoc
    + S8201634: Random seedUniquifier uses incorrect LCG
    + S8201650: Move iteration order randomization of unmodifiable
    Set and Map to iterators
    + S8201786: Modularize interpreter GC barriers: leftovers for
    ARM32
    + S8201817: Taglet.init should be called with the "primary"
    doclet
    + S8202082: Remove explicit CMS checks in
    CardTableBarrierSetAssembler
    + S8202105: Console echo is disabled when exiting jshell
    + S8202130: [TESTBUG] Some appcds regression test cases fail
    with "Error: VM option 'PrintSystemDictionaryAtExit' is
    notproduct and is available only in debug version of VM"
    + S8202140: TLAB logging is not correct for G1
    + S8202150: [REDO] Split globals.hpp to factor out the Flag
    class
    + S8202179: Compilation fails with assert(n->is_expensive())
    failed: expensive nodes with non-null control here only
    + S8202186: AArch64: Debug build VM crashes with
    PrintC1Statistics option
    + S8202200: set INCLUDE_SA to false on s390x by default
    + S8202204: Rename hotspot runtime jtreg constantPool
    ConstantPool directories
    + S8202230: Provide accessors for JNIHandles storage objects
    + S8202261: (fc) FileChannel.map and RandomAccessFile.setLength
    should not preallocate space
    + S8202273: [AOT] Graal does not support the CMS collector
    + S8202284: FileChannel and FileOutpuStream variants of
    AtomicAppend should fail silently on macOS >= 10.13
    + S8202324: Avoid loading FileInput-/OutputStream$AltFinalizer
    + S8202325: [aix] disable warnings-as-errors by default
    + S8202330: Add Unreferenced{FOS,FIS,RAF}ClosesFd to problem
    list
    + S8202334: Update javax.lang.model.util visitors for 11
    + S8202364: Add GCConfig::hs_err_name() to avoid GC-specific
    code in error reporting
    + S8202366: Add macro for common loop in GCConfig
    + S8202367: AIX build broken after JDK-8201543
    + S8202372: Diagnostic with incorrect line info generated when
    compiling lambda expression
    + S8202373: Forcing eager initialization of CHM$ReservationNode
    avoids deoptimization
    + S8202379: ARM32 is broken after JDK-8201543 (Modularize C1 GC
    barriers)
    + S8202381: (Solaris) SIGBUS in # V [libjvm.so+0xcee494]
    jni_GetIntField+0x224
    + S8202382: Filter docs modules
    + S8202383: Custom extensions for jvmti doc
    + S8202397: Typo in X-Buffer javadoc
    + S8202398: Optimize Arrays.deepHashCode
    + S8202399: [C1] LIRGenerator::do_CheckCast needs to exclude
    is_invokespecial_receiver_check() when using PatchAlot
    + S8202417: [TESTBUG] Broken hard-coded dependency in
    serviceability/sa/ClhsdbJhisto.java
    + S8202418: Remove explicit CMS checks in
    CardTableBarrierSetAssembler: ARM32 leftovers
    + S8202419: Avoid creating Permission constants early
    + S8202423: Small HTTP Client refresh
    + S8202425: [s390] C2: Wrong unsigned comparison with 0
    + S8202452: Delete test files missed from commit for
    8193213 & 8182731.
    + S8202484: Unused field in TimeZone
    + S8202505: ctw2 tasks are timing out in hs-tier3
    + S8202507: Remove IO and NIO AtomicAppend tests from problem
    list
    + S8202520: JShell tests: move intermittently failing tests to
    tier2
* Mon May  7 2018 guillaume.gardet@opensuse.org
- Remove armv6 and armv7 overwrite conditions in _constraints to
  avoid OOM errors
* Fri Apr 27 2018 fstrba@suse.com
- Update to upstream tag jdk-11+11
  * Fixes:
    + S6341887: java.util.zip: Add ByteBuffer methods to
    Inflater/Deflater
    + S6805750: Improve handling of Attributes.Name
    + S8025091: VisibleMemberMap.java possible performance
    improvements
    + S8081519: Split globals.hpp to factor out the Flag class
    + S8144806: sun/security/tools/keytool/standard.sh fails
    intermittently at deleting x.jks
    + S8154528: Reclaim regions emptied by marking in Remark pause
    + S8157543: java/nio/channels/Selector/SelectAndCancel.java
    fails intermittently
    + S8161991: java/nio/channels/AsynchronousSocketChannel/Basic.java
    failed due to RuntimeException: WritePendingException expected
    + S8171404: java/nio/channels/AsynchronousSocketChannel/Basic.java
    failed with "AsynchronousCloseException expected"
    + S8178105: Switch mark bitmaps during Remark
    + S8178825: unused variable threadObj in jvmci_counters_include
    + S8184693: add Pattern.isEmpty
    + S8187490: HotSpotGraalMBean should be moved to Graal
    management module
    + S8187496: Possible memory leak in
    java.apple.security.KeychainStore.addItemToKeychain
    + S8188105: Make -Xshare:auto the default for server VM
    + S8190227: Forward port 8188880 to JDK10CPU
    + S8192789: Avoid using AtomicReference in
    sun.security.provider.PolicyFile
    + S8193524: Redefining a method that removes use of 1 or more
    lambda expressions causes the JVM to hang
    + S8196071: Change G1 Full GC heap and thread sizing ergonomics
    + S8196325: GarbageCollectionNotificationInfo has same
    information for before and after
    + S8196433: use the new error diagnostic approach at javac.Main
    + S8196540: [Testbug] java/security/AccessController/
    /DoPrivAccompliceTest.java doesn't handle unrelated warnings
    + S8198756: Lazy allocation of compiler threads
    + S8198793: Add launcher support for preview features
    + S8198816: AbstractScriptEngine.getScriptContext creation of
    SimpleScriptContext is inefficient
    + S8198890: The standard doclet incorrectly produces wrong
    method signatures in certain cases.
    + S8199193: jshell tool: Add support for preview features
    + S8199519: Several GC tests fails with:
    java.lang.NumberFormatException: Unparseable number: "-"
    + S8199755: Update Graal
    + S8200101: sun/security/krb5/auto/Renewal.java fails
    intermittently
    + S8200196: [Graal] implement Object.notify/notifyAll intrinsics
    + S8200303: C2 should leverage profiling for
    lookupswitch/tableswitch
    + S8200426: Make G1 code use _g1h members
    + S8200450: Root cause analysis for JDK-8200366
    + S8200477: Integer dot product no longer autovectorised
    + S8200555: OopHandle should use Access API
    + S8200556: AArch64: assertion failure in slowdebug builds
    + S8200723: Suppress rs_length and predicted_cards sampling
    during mixed gcs
    + S8200730: Fix debug=gc+phases time tracking in Remark and
    Cleanup
    + S8201172: Parallelize Remset Tracking Update Before Rebuild
    phase
    + S8201226: missing JNIEXPORT / JNICALL at some places in
    function declarations/implementations
    + S8201259: Fix warning with VS2017 in jdk.pack
    + S8201281: Truncated error message with Incompatible : null
    + S8201315: (se) Allow SelectableChannel.register to be invoked
    while selection operation is in progress
    + S8201368: IfNode::fold_compares() may lead to incorrect
    execution
    + S8201369: Inet4AddressImpl_getLocalHostName reverse lookup on
    Solaris only
    + S8201466: Nashorn: defineProperty setters/getters on
    prototype object ignored with numeric property names
    + S8201487: Do not rebalance reference processing queues if not
    doing parallel reference processing
    + S8201490: Improve concurrent mark keep alive closure
    performance
    + S8201505: Use WeakHandle for ProtectionDomainCacheTable and
    ResolvedMethodTable
    + S8201510: Merge TwoStacksPlainSocketImpl into
    DualStackPlainSocketImpl [win]
    + S8201520: AsynchronousSocketChannel/Basic.java timeout
    intermitently
    + S8201527: Bump default value of G1RefProcDrainInterval
    + S8201536: configure fails compiler check due to bad -m32 flag
    + S8201537: Remove is_alive closure from
    Klass::is_loader_alive()
    + S8201540: [AIX] Extend the set of supported charsets in
    java.base
    + S8201556: Disallow reading oops in ClassLoaderData if
    unloading
    + S8201596: java.lang.ref.Reference processing total time
    logging broken
    + S8201597: AArch64: Update relocs for CompiledDirectStaticCall
    + S8201616: Hotspot crashes on linux-sparc after 8189941
    + S8201646: Introduce ReferenceDiscoverer interface
    + S8201647: Make initial clearing of CHeapBitMap optional
    + S8201649: Remove dubious call_jio_print in ostream.cpp
    + S8201766: Mark TimSortStackSize2.java as intermittently
    failing
    + S8201785: Make ModRefBarrierSetAssembler abstract on all
    platforms
    + S8201788: Number of make jobs wrong for bootcycle-images
    target
    + S8201794: [Graal] fix regressions from JDK-8187490
    + S8201799: Build failures after JDK-8195099 (Concurrent
    safe-memory-reclamation mechanism)
    + S8201800: Add support for adjusting heap addresses in a TLAB
    + S8201826: G1: Don't invoke WeakProcessor if mark stack has
    overflowed
    + S8201850: [AOT] vm crash when run test
    compiler/aot/fingerprint/SelfChangedCDS.java
    + S8202000: AIX build broken after JDK-8195099
    + S8202037: Split slow ctw_1 tests
    + S8202052: Disable warnings when building libawt with VS2017
    + S8202060: Add javax/net/ssl/DTLS/CipherSuite.java to
    ProblemList
    + S8202062: Put FileChannel and FileOutpuStream variants of
    AtomicAppend on problem list
    + S8202070: Cleanup code after JDK-8200450, JDK-8200366
    + S8202073: MetaspaceAllocationTest gtest shall lock during
    space creation
    + S8202074: Metaspace: If humongous chunk is added to
    SpaceManager, previous current chunk may not get retired correctly.
    + S8202075: Crash when running
    compiler/codecache/OverflowCodeCacheTest.java
    + S8202079: [s390]: Build failure w/o precompiled headers
    + S8202081: Introduce CollectedHeap::is_oop()
    + S8202091: Rename DualStackPlainSocketImpl to PlainSocketImpl
    [win]
    + S8202134: Non-PCH build for arm32 fails
    + S8202141: Unique symbols for .class
    + S8202151: [BACKOUT] Split globals.hpp to factor out the Flag
    class
    + S8202152: test/hotspot/jtreg/runtime/whitebox/WBStackSize.java
    fails
    + S8202154: Remove unused code in
    java.base/windows/native/libnet
    + S8202155: quarantine test com/sun/jdi/JdbExprTest.sh on all
    platforms
    + S8202157: remove the use of string keys at
    InapplicableMethodException
    + S8202164: Remove some unneeded BoolObjectClosure* is_alive
    parameters
    + S8202169: Reduce ctw_2 duration by parallelizing CtwRunner
    invocations
    + S8202184: Reduce time blocking the ClassSpecializer cache
    creating SpeciesData
    + S8202210: jlink uses little-endian for big-endian
    cross-compilation targets
    + S8202276: Update test/hotspot/jtreg/ProblemList-graal.txt
- Removed patch:
  * bootcycle_jobs.patch
    + Integrated upsteam
* Fri Apr 20 2018 fstrba@suse.com
- Update to upstream tag jdk-11+10 (April 2018 CPU)
  * Security fixes:
    + S8194238: Trying exceptions in MethodHandles (CVE-2018-2826,
    bsc#1090197)
    + S8194233: Improve support for array handles (CVE-2018-2825,
    bsc#1090196)
    + S8192025: Less referential references (CVE-2018-2814,
    bsc#1090032)
    + S8189997: Enhance keystore mechanisms (CVE-2018-2794,
    bsc#1090024)
    + S8189977: Improve permission portability (CVE-2018-2795,
    bsc#1090025)
    + S8189993: Improve document portability (CVE-2018-2799,
    bsc#1090029)
    + S8189989: Improve container portability (CVE-2018-2798,
    bsc#1090028)
    + S8189985: Improve tabular data portability (CVE-2018-2797,
    bsc#1090027)
    + S8189981: Improve queuing portability (CVE-2018-2796,
    bsc#1090026)
    + S8189969: Manifest better manifest entries (CVE-2018-2790,
    bsc#1090023)
  * Security-In-Depth fixes:
    + S8182362: Update CipherOutputStream Usage
    + S8183032: Upgrade to LittleCMS 2.9
    + S8189123: More consistent classloading
    + S8190478: Improved interface method selection
    + S8190877: Better handling of abstract classes
    + S8191696: Better mouse positioning
    + S8192030: Better MTSchema support
    + S8193409: Improve AES supporting classes
    + S8193414: Improvements in MethodType lookups
  * Fixes:
    + S8009632: (fs) FileStore.supportsFileAttributeView does not
    detect user_xattr enabled on ext4
    + S8049695: nsk/jdb/options/connect/connect003 fails with
    "Launched jdb could not attach to debuggee during 300000
    milliseconds"
    + S8057732: sun/jvmstat/monitor/MonitoredVm/
    /MonitorVmStartTerminate.java: Invalid PerfMemory size
    + S8078221: java/rmi/Naming/DefaultRegistryPort.java fails
    intermittently
    + S8151171: Bring g1ConcurrentMark files up to current coding
    conventions
    + S8152821: Merge jdk.internal.misc.JavaSecurityAccess and
    jdk.internal.misc.JavaSecurityProtectionDomainAccess shared
    secrets
    + S8175075: Add 3DES to the default disabled algorithm security
    property
    + S8180415: Rebuild remembered sets during the concurrent cycle
    + S8183238: Obsolete CheckEndorsedAndExtDirs and remove checks
    for lib/endorsed and lib/ext
    + S8184692: add Pattern.asMatchPredicate
    + S8186032: Disable XML Signatures signed with EC keys less
    than 224 bits
    + S8187472: AARCH64: array_equals intrinsic doesn't use
    prefetch for large arrays
    + S8189101: AARCH32 - 'minimal' build fails because CMS bits
    are referred unconditionally
    + S8189765: Improve error reporting for compiling against
    package not visible due to modules
    + S8191101: Show register content in hs-err file on assert
    + S8191358: Restore TSA certificate expiration check
    + S8193067: gc/g1/TestVerifyGCType.java still unstable
    + S8194259: keytool error: java.io.IOException: Invalid secret
    key format
    + S8194260: Point-to-point interface should be excluded from
    java/net/ipv6tests/*
    + S8194734: Handle to jimage file inherited into child
    processes (win)
    + S8194750: Console.readPassword does not save/restore tty
    settings
    + S8194812: Extend class-data sharing to support the module path
    + S8195099: Concurrent safe-memory-reclamation mechanism
    + S8195662: Add T6587786.java to problem list before
    JDK-8195589 is resolved
    + S8195972: Refactor oops in JNI to use the Access API
    + S8196289: Update src/java.desktop/share/legal/lcms.md for
    LCMS 2.9
    + S8196485: FromCardCache default card index can cause crashes
    + S8196516: libfontmanager must be built with LDFLAGS allowing
    unresolved symbols
    + S8196865: G1 log for active workers is wrong
    + S8197441: Signature#initSign/initVerify for an invalid
    private/public key fails with ClassCastException for SunPKCS11
    provider
    + S8197443: ArrayIndexOutOfBoundsException in
    UcryptoException.getError
    + S8197564: HTTP Client implementation
    + S8197569: Refactor eager reclaim for concurrent remembered
    set rebuilding
    + S8197570: Make rules for choosing collection set candidates
    more explicit
    + S8197573: Remove concurrent cleanup and secondary free list
    handling
    + S8197850: Calculate liveness in regions during marking
    + S8197928: Only enqueue deferred cards with references into
    regions that have a tracked remembered set during GC
    + S8197931: Null pointer dereference in Unique_Node_List::push
    of node.hpp:1510
    + S8197932: Better split work in rebuild remembered sets phase
    + S8197972: Always verify non-system classes during CDS dump
    time
    + S8198240: Allow cacerts test to pass when GTECyberTrust root
    expires
    + S8198313: Wrap holder object for ClassLoaderData in a
    WeakHandle
    + S8198335: java/awt/FullScreen/UninitializedDisplayModeChangeTest/
    /UninitializedDisplayModeChangeTest.java fails in headless mode
    + S8198393: Instrumentation.retransformClasses() throws
    NullPointerException when handling a zero-length array
    + S8198655: test/lib/jdk/test/lib/apps/LingeredApp shouldn't
    inherit cout/cerr
    + S8198691: CodeHeap State Analytics
    + S8198760: Move global lock SpaceManager::_expand_lock to
    MutexLocker.cpp
    + S8198908: Add JVM support for preview features
    + S8198915: [Graal] 3rd testcase of compiler/types/
    /TestMeetIncompatibleInterfaceArrays.java takes more than 10
    mins
    + S8198950: AArch64:
    org.openjdk.jcstress.tests.varhandles.DekkerTest fails
    + S8199007: ClassLoaderDataGraph::unload_list_contains() is
    wrong
    + S8199194: Add javac support for preview features
    + S8199326: Remove G1 gc time stamp logic
    + S8199360: Rework the support for the 'ignored' module options
    in CDS
    + S8199406: Performance drop with Java JDK 1.8.0_162-b32
    + S8199417: Modularize interpreter GC barriers
    + S8199619: Building HotSpot on Windows should define NOMINMAX
    + S8199627: Use "Per-Monitor V2" High DPI awareness for Windows
    10 v1703
    + S8199717: Avoid calculating primordial thread stack bounds on
    VM startup
    + S8199735: Mark word updates need to use Access API
    + S8199736: Define WIN32_LEAN_AND_MEAN before including
    windows.h
    + S8199742: Clean up state flags in G1CollectorState
    + S8199780: SetMemory0 and CopyMemory0 in unsafe.cpp need to
    resolve their operands
    + S8199781: Don't use naked == for comparing oops
    + S8199782: Fix compilation warnings detected by Solaris
    Developer Studio 12.6
    + S8199793: [Graal] runtime/CommandLine/
    /PrintTouchedMethods.java crashes with assertion "reference
    count underflow for symbol"
    + S8199813: SIGSEGV in ThreadsList::includes()
    + S8199850: Move parsing of VerifyGCType to G1
    + S8199918: Shorten names of CollectedHeap::Name members
    + S8199925: Break out GC selection logic from GCArguments to
    GCConfig
    + S8199927: Make WhiteBox more GC agnostic
    + S8199946: Move load/store and encode/decode out of oopDesc
    + S8200067: Add support for vpclmulqdq for crc32
    + S8200074: Remove
    G1ConcurrentMark::_concurrent_marking_in_progress
    + S8200078: [Graal] runtime/appcds/GraalWithLimitedMetaspace.java
    crashes in visit_all_interfaces
    + S8200091: [TESTBUG] Update jittester for jdk11
    + S8200105: Remove cyclic dependency between oop.inline.hpp and
    collectedHeap.inline.hpp
    + S8200106: Move NoSafepointVerifier out from gcLocker.hpp
    + S8200111: MallocArrayAllocator::free should not take a length
    parameter
    + S8200113: Make Access load proxys smarter
    + S8200126: [TESTBUG] Open source VM runtime signal tests
    + S8200149: The "com.sun.awt.AWTUtilities" class can be dropped
    + S8200168: Remove DONT_USE_REGISTER_DEFINES on Sparc
    + S8200169: Flatten G1Allocator class hierarchy
    + S8200187: Exclude 3 long-running tests from tier1
    + S8200195: serviceability/jvmti/FieldAccessWatch/
    /FieldAccessWatch.java crashes with
    "assert(thread->thread_state() == _thread_in_native) failed:
    coming from wrong thread state"
    + S8200197: Zero fails to build after 8200105
    + S8200202: Remove unused _boot_modules_array and
    _platform_modules_array from classLoader.*.
    + S8200203: Missing platform definitions for ia64
    + S8200227: [Graal] Test times out with Graal due to low
    compile threshold
    + S8200228: Change default value of HeapSizePerGCThread
    + S8200230: [Graal] Compilations should not be enqueued before
    Graal is initialized
    + S8200232: Build failures after JDK-8200106 (Move
    NoSafepointVerifier out from gcLocker.hpp)
    + S8200233: Simple G1 evacuation path performance enhancements
    + S8200234: Cleanup Remark and Cleanup pause code
    + S8200238: Reduce number of exceptions created when calling
    MemberName$Factory::resolveOrNull
    + S8200245: Zero fails to build on linux-ia64 due to
    ia64-specific cruft
    + S8200246: AIX build fails after adjustments of
    src/hotspot/share/trace/traceEventClasses.xsl
    + S8200251: AArch64::CPUFeature out of sync with
    VM_Version::Feature_Flag
    + S8200255: Remove G1CMTask::_concurrent
    + S8200261: Regression with JVM anonymous class
    + S8200276: Cleanup allocation.hpp includes
    + S8200290: Scratch buffer creation fails with
    "assert(!current_thread_in_native()) failed: must not be in
    native" on SPARC
    + S8200292: Move PushAndMarkVerifyClosure::do_oop_work to
    concurrentMarkSweepGeneration.cpp
    + S8200297: Build failures after JDK-8198691 (CodeHeap State
    Analytics)
    + S8200299: Non-PCH build for aarch64 fails
    + S8200302: ppc, s390 (non-pch) build errors
    + S8200305: Update gc,liveness output with remset state after
    rebuild remset concurrently changes
    + S8200343: Minor JViewport documentation typo
    + S8200360: MeetIncompatibleInterfaceArrays fails with
    "MeetIncompatibleInterfaceArrays0ASM.run() must be compiled at
    tier 0 !"
    + S8200362: G1Mux2Closure should disable implicit oop
    verification
    + S8200366: SIGSEGV in CodeHeapState::print_names()
    + S8200371: In g1, rename ConcurrentMarkThread to
    G1ConcurrentMarkThread
    + S8200374: Add
    ThreadsSMRSupport::verify_hazard_pointer_scanned() to verify
    threads_do().
    + S8200383: Can't build on SPARC Hotspot with code which use
    math functions
    + S8200384: jcmd help output should be sorted
    + S8200385: Eagerly reclaimed humongous objects leave mark in
    prev bitmap
    + S8200391: clean up test/hotspot/jtreg/ProblemList.txt
    (compiler related)
    + S8200423: Non-PCH build for x86_32 fails
    + S8200424: Windows build fails due to implicit jboolean to
    bool conversion
    + S8200429: Adjust object pinning interface on CollectedHeap
    + S8200438: Non-PCH x86_32 build failure: err_msg is not defined
    + S8200461: MeetIncompatibleInterfaceArrays test fails with
  - Xcomp
    + S8200468: Port the native GSS-API bridge to Windows
    + S8200524: AArch64: CPUFeature and Flag enums are not passed
    through JVMCI
    + S8200525: test java/awt/event/SequencedEvent/SequencedEventTest.java
    fails to compile
    + S8200526: Test sun/java2d/marlin/ClipShapeTest.java times out
    + S8200550: Xcode 9.3 produce warning -Wexpansion-to-defined
    + S8200607: Add missing include dependency in bitMap.hpp
    + S8200608: Build failures after JDK-8191101 (Show register
    content in hs-err file on assert)
    + S8200626: Restore history for g1ConcurrentMarkThread.*
    + S8200627: aarch32 - Broken build after JDK-8198949
    + S8200628: aarch32 - Broken build after JDK-8199809
    + S8200630: Globally suppress Visual Studio warning C4351
    + S8200697: Add utility for spin wait with fallback to
    yield/sleep
    + S8200719: Cannot connect to IPv6 host when exists any active
    network interface without IPv6 address
    + S8200735: Move CMS specific code from binaryTreeDictionary
    and freeList to CMS files
    + S8200736: Move CMSGCStats to the cms directory
    + S8200737: Move GC code out of
    Arguments::check_vm_args_consistency into GCArguments
    + S8200759: Move GC entries in vmStructs.cpp to GC specific
    files
    + S8201136: Move GC flags from globals.hpp to GC specific files
    + S8201167: Remove MacroAssembler::cmp_heap_oop on x86
    + S8201168: Move GC command line constraint functions to GC
    specific files
    + S8201171: Cleanup in g1CollectedHeap, change CamelCase to
    snake_case
    + S8201175: Move FilteringClosure::do_oop to genOopClosures
    + S8201185: AARCH64: bfm instruction encoding hits assert on
    zero register
    + S8201209: Separate out CMS specific functions into
    CMSCardTable
    + S8201212: Remove INCLUDE_ALL_GCS from OopStorage files
    + S8201213: Remove INCLUDE_ALL_GCS from
    memset_with_concurrent_readers
    + S8201217: Split specialized_oop_closures.hpp into GC specific
    files
    + S8201218: PPC64: Avoid use of yield instruction on spinlock
    + S8201227: Add ALL_GCS_ONLY
    + S8201240: Improve releasing native resources of
    BufImgSurfaceData.ICMColorData
    + S8201242: Include source file/line number when reporting
    native call stack on supported platforms
    + S8201244: Clean out unnecessary includes of heap headers
    + S8201247: Various cleanups in the attach framework
    + S8201265: Native memory leak in
    ClassLoader::add_to_exploded_build_list
    + S8201316: Move G1-related static members from JavaThread to
    G1BarrierSet
    + S8201318: Introduce GCThreadLocalData to abstract GC-specific
    data belonging to a thread
    + S8201321: NMT: Unnecessary re-recording thread stack and size
    when attaching listener to JavaThread
    + S8201330: Add java/lang/management/ThreadMXBean/
    /ThreadMXBeanStateTest.java to the ProblemList
    + S8201334: Move runtime/NMT/MallocStressTest.java to
    hotspot_tier3_runtime
    + S8201359: Incorrect header guards after JDK-8198949
    (Modularize arraycopy stub routine GC barriers)
    + S8201362: Remove CollectedHeap::barrier_set()
    + S8201365: Remove G1Policy::should_process_references()
    + S8201370: GC specific data is referred from common
    precompiled headers and defNewGeneration.cpp
    + S8201427: Fix Minimal VM builds on Linux x64
    + S8201430: [TESTBUG] Remove script from runtime/6626217
    + S8201442: objArrayOopDesc::atomic_compare_exchange_oop() must
    use obj+offset in HeapAccess call
    + S8201443: NoSuchMethodException JarFile.open when jar file is
    used in classpath
    + S8201450: Provide access to LogHandle tagset
    + S8201474: (so) Socket adaptor connect(InetAddress, timeout)
    succeeds when connection fails
    + S8201475: 8199417 breaks AIX and non-pch on s390 (and
    presumably aarch64)
    + S8201480: ISA/CPU feature detection code crashes on
    linux-sparc
    + S8201483: Make it possible to disable JVM features
    + S8201494: Avoid early initialization of java.nio.Bits
    + S8201495: [Zero] Reduce limits of max heap size for boot JDK
    on s390
    + S8201498: test/langtools/tools/javac/diags/CheckExamples.java
    6 errors occurred
    + S8201507: Generate alias entries in j.t.f.ZoneName from tzdb
    at build time
    + S8201508: Macosx builds fail in GenerateLinkOptData.gmk
    + S8201554: Disable failing tier1 test for JDK-8201498
    + S8201584: Fix configure on SLES 11 after 8201483
    + S8201591: JVM features with "-" in name is not correctly
    handled
    + S8201609: Split test/jdk/:tier2 to enable better parallel
    execution
- Removed patch
  * fix-arm-build.patch
    + Integrated upstream
- Modified patch:
  * memory-limits.patch
    + Rediff with changes in the right files
* Thu Apr 19 2018 guillaume.gardet@opensuse.org
- Fix armv6 build with fix_armv6_build.patch
* Fri Apr 13 2018 fstrba@suse.com
- Update to upstream tag jdk-11+9
  * Fixes
    + S8071367: JMX: Remove SNMP support
    + S8164781: Pattern.asPredicate specification is incomplete
    + S8178867: tools/jlink/multireleasejar/
    /JLinkMultiReleaseJarTest.java failed to clean up files
    + S8180570: Refactor sun/security/mscapi shell tests to plain
    java tests
    + S8188897: java/rmi/registry/reexport/Reexport.java failed
    with Port already in use
    + S8189784: Parsing with Java 9 AKST timezone returns the
    SystemV variant of the timezone
    + S8190333: sun/security/ssl/X509KeyManager/PreferredKey.java
    failed with "Failed to get the preferable key aliases"
    + S8196200: Implement a navigation builder in javadoc
    + S8196724: Change macosx deployment target to 10.9
    + S8196750: [Testbug] tools/launcher tests need to tolerate
    unrelated warnings
    + S8196775: java/net/Socket/asyncClose/Race.java failed
    intermittently on Windows with ConnectException: Connection
    refused
    + S8197418: Move java/util/RandomAccess/ tests into OpenJDK
    + S8197531: Miscellaneous changes imported from jsr166 CVS
    2018-04
    + S8199539: Provide a standard way for the build to filter
    un-needed legal .md files
    + S8199608: Clean up LDFLAGS for libfontmanager
    + S8199744: Incorrect compiler message for ReceiverParameter in
    inner class constructor
    + S8199875: Require first parameter type of a condy bootstrap
    to be Lookup
    + S8200125: Fix some classloader/module typos
    + S8200127: Replace collection.stream().forEach() with
    collection.forEach()
    + S8200128: Fix some "annoations" typos
    + S8200131: Improve lazy init of InetAddress.canonicalHostName
    and NativeObject.pageSize
    + S8200134: Improve ModuleHashesBuilder
    + S8200152: KerberosString should use UTF-8 by default
    + S8200258: Improve CopyOnWriteArrayList subList code
    + S8200298: Unify all unix versions of libjsig/jsig.c
    + S8200358: Remove mapfiles for JDK executables
    + S8200359: (tz) Upgrade time-zone data to tzdata2018d
    + S8200458: (se) Readiness information previously recorded in
    the ready set not preserved
    + S8200520: forkjoin tasks interrupted after shutdown
    + S8200583: (se) Selector clean-up, part 4
    + S8200664: fix broken links in java.base docs
    + S8200706: Better cleanup for open/test/jdk/java/lang/
    /ProcessBuilder/DestroyTest.java
    + S8200727: linux-aarch64 profile should use bundled freetype
    + S8200728: Docs (Comparison of Stack and Deque methods) for
    Deque is not correct
    + S8200788: Optimal initial capacity of
    java.lang.VarHandle.AccessMode.methodNameToAccessMode
    + S8200792: PKCS12Attribute#hashCode is always constant -1
    + S8200888: typo in name of exception in @throws
    + S8201178: Remove sun.nio.cs.FastCharsetProvider
    + S8201179: Regression due loading
    java.nio.charset.StandardCharsets during bootstrap
    + S8201194: Handle local variable declarations in lambda
    deduplication
    + S8201221: JDK-8199608 introduced a build race on macosx
    + S8201222: JDK-8199539 broke the OpenJDK build
    + S8201236: Straighten out dtrace build logic
    + S8201246: Export native function to set platform encoding
    + S8201251: The tests for JDK-8187247 should be under
    test/langtools
    + S8201263: Trailing backslash in VS120COMNTOOLS leads to ugly
    error message when running tests
    + S8201267: Disable warnings for VS2017 to enable building
    + S8201320: Allow PrintFailureReports to be turned off
    + S8201327: Make Sensor deeply immutably thread safe
    + S8201328: SynthParser should use Boolean.parseBoolean
    + S8201348: ProblemList update for bugid associated with
    SSLSocketParametersTest.sh
    + S8201357: ALSA_CFLAGS is needed; was dropped in JDK-8071469
    + S8201396: fix broken links generated by javadoc doclet
    + S8201439: Enable linux-arm-vfp-hflt profile to be configured
    with jib again
    + S8201440: javac should create unique DynamicMethodSymbols at
    LambdaToMethod
- Modified patches:
  * java11-improved-fonts.patch
    + Rediff to changed context
  * fix-arm-build.patch
    + Use upstream fixes
* Wed Apr 11 2018 fstrba@suse.com
- Modified patch:
  * fix-arm-build.patch
    + fix more duplicate commas in headers
* Fri Apr  6 2018 fstrba@suse.com
- Update to upstream tag jdk-11+8
  * Fixes
    + S4954348: JPGWriter.getNumThumbnailsSupported does not return
  - 1 when passing null values
    + S8074286: Add getSelectedIndices() to ListSelectionModel
    + S8178370: [TEST_BUG]
    java/security/Signature/SignatureLength.java fails
    + S8191957: JFileChooser shows empty name for external drives
    shown under Desktop
    + S8193032: Remove terminally deprecated SecurityManager APIs
    + S8195649: reorganize tests for java.util.Optional
    + S8198314: javac hidden options violate standard syntax for
    options
    + S8198801: JShell: user exception chained cause not retained
    + S8198885: upgrade Marlin (java2d) to 0.9.1
    + S8198990: Move SwingSet2 from closed to OpenJDK
    + S8199176: Accessibility issues in java.base docs
    + S8199800: Optimize Boolean.parseBoolean(String)
    + S8199947: Rename HTML element id in ClassLoader javadoc to
    avoid name conflict with private elements
    + S8200200: test java/awt/image/ColorModel/Non_sRGBCMTest.java
    fails with open profiles
    + S8200257: (se) More Selector cleanup
    + S8200267: a.out created at top dir by Solaris build
    + S8200364: Remove unnecessary boxing via primitive wrapper
    valueOf(String) methods
    + S8200375: Change to GCC 7.3.0 for building Linux at Oracle
    + S8200469: Update link to license in Docs.gmk
    + S8200538: cl : Command line warning D9014 : invalid value
    '2220' for '/wd'
    + S8200586: Update JDK11 release date to 2018-09-25
    + S8200658: Fix incremental builds of hotspot on solaris
    + S8200696: Optimal initial capacity of
    java.lang.Class.enumConstantDirectory
    + S8200703: Problem list jdk/jshell/ExceptionsTest.java fails
    on windows
* Thu Apr  5 2018 fstrba@suse.com
- Added patch:
  * fix-arm-build.patch
    + fix a duplicate comma in a header
* Tue Apr  3 2018 fstrba@suse.com
- Update to upstream tag jdk-11+7
  * Fixes:
    + S4912693: Behavior of null arguments not specified in Java
    Sound
    + S6686236: GIF native IIOMetadata assumes
    characterCellWidth/Height as 2bytes
    + S7031957: DIB header of type BITMAPV2INFOHEADER &
    BITMAPV3INFOHEADER is not supported in BMPImageReader
    + S7108280: JList.getSelectedValuesList fails if
    JList.setSelectionInterval larger than list
    + S7158623: Should an unfocusable maximized Frame be resizable
    + S8071282: remove misc dead code
    + S8071469: Cleanup include and exclude of sound native
    libraries
    + S8140359: get_locked_message_ext() should return Flag::MsgType
    + S8144300: http.nonProxyHosts value having wildcard * both at
    end and start are not honored
    + S8146201: [AOT] Class static initializers that are not pure
    should not be executed during static compilation
    + S8152974: AWT hang occurrs when sequenced events arrive out
    of sequence
    + S8153333: [REDO] STW phases at Concurrent GC should count in
    PerfCounte
    + S8159850: Remove unneeded parsing of optional-size when
    parsing array types
    + S8166642: serviceability/dcmd/framework/* timeout
    + S8170541: serviceability/jdwp/AllModulesCommandTest.java
    fails intermittently on Windows and Solaris
    + S8173070: Remove ValueObj class for allocation subclassing
    for runtime code
    + S8173100: AArch64: -XX:-UseOnStackReplacement does not work
    together with -XX:+TieredCompilation
    + S8175312: SA: clhsdb: Provide an improved heap summary for
    'universe' for G1GC
    + S8180410: ByteArrayOutputStream should not throw IOExceptions
    + S8180451: ByteArrayInputStream should override readAllBytes,
    readNBytes, and transferTo
    + S8191102: Incorrect include file use in classLoader.hpp
    + S8191418: List.of().indexOf(null) doesn't throw
    NullPointerException
    + S8191585: VM anonymous classes created during CDS dump time
    cause crash
    + S8191924: Adjust DelegatingClassLoader's metadata space
    sizing algorithm
    + S8191954: AArch64: disable UseCISCSpill in C2
    + S8193128: Reduce number of implementation classes returned by
    List/Set/Map.of()
    + S8193130: Bad graph when unrolled loop bounds conflicts with
    range checks
    + S8193266: AArch64: TestOptionsWithRanges.java SIGSEGV
    + S8193369: post_field_access does not work for some functions,
    possibly related to fast_getfield
    + S8193429: "assert(false) failed: GetModuleFileName failed
    (126)" in symbolengine.cpp
    + S8193434: [GRAAL] Graal classes are not loaded with
  - Xshare:dump
    + S8194054: [TESTBUG] Test runtime/CommandLine/
    /OptionsValidation/TestOptionsWithRanges.java failed with
  - 1073740940 (FFFFFFFFC0000374)
    + S8194490: [JVMCI] Move `iterateFrames` to C++
    + S8194746: (fs) Add equivalents of Paths.get to Path interface
    + S8194759: Support caching class mirror objects.
    + S8194978: Javac produces dead code for try-with-resource
    + S8195095: Images are not scaled correctly in JEditorPane
    + S8195109: ServiceUtil::visible_oop is not needed anymore
    + S8195148: Collapse G1SATBCardTableModRefBS and
    G1SATBCardTableLoggingModRefBS into a single G1BarrierSet
    + S8196028: JMX: Not enough JDP packets received before timeout
    + S8196121: runtime/appcds/ClassLoaderTest.java fails silently
    + S8196294: LoopStripMiningIterShortLoop is set to zero by
    default
    + S8196337: Add commit methods that take all event properties
    as argument
    + S8196399: Formatting a decimal using locale-specific grouping
    separators causes ArithmeticException (division by zero).
    + S8196519: Incomplete classpath causes infinite recursion in
    Resolve.isAccessible
    + S8196590: Enable docker container related tests for linux
    AARCH64
    + S8196626: [Graal] runtime/appcds/UseAppCDS.java crashes with
    "VM thread using lock Heap_lock (not allowed to block on)"
    + S8196668: revisit test SunPackageAccess and
    GrantedSunPackageAccess
    + S8196876: OopStorage::assert_at_safepoint clashes with
    assert_at_safepoint macros in g1CollectedHeap.hpp
    + S8197235: src/hotspot/share/jvmci/jvmciCompilerToVM.cpp takes
    4 minutes to compile on windows
    + S8197405: Improve messages of AbstractMethodErrors and
    IncompatibleClassChangeErrors.
    + S8197429: Increased stack guard causes segfaults on x86-32
    + S8197554: Create test for SwingSet TableDemo
    + S8197595: Serialization javadoc should link to security best
    practices
    + S8197842: Remove unused macros VM_STRUCTS_EXT and VM_TYPES_EXT
    + S8197843: Remove unused method
    G1EvacuationRootClosures::create_root_closures_ext
    + S8197844: JVMTI GetLoadedClasses should use the Access API
    + S8197845: Remove unnecessary method
    G1CollectedHeap::create_g1_policy
    + S8197847: Remove unused file g1ParScanThreadState_ext.cpp
    + S8197852: Move G1DefaultPolicy into G1Policy
    + S8197944: Condy tests fails on Windows
    + S8198243: Add build time check for global operator new/delete
    in object files
    + S8198358: Align organization of TwoStacksPlainSocketImp with
    DualStackPlainSocketImpl [win]
    + S8198423: Improve metaspace chunk allocation
    + S8198424: Remove G1AllocationContext
    + S8198430: Remove G1Allocator extension point
    + S8198431: Remove G1FullCollector extension point
    + S8198432: Remove Thread extension point
    + S8198433: Remove WhiteBox extension point
    + S8198445: Access API for primitive/native arraycopy
    + S8198447: Remove ClassLoaderExt::check().
    + S8198510: Enable UseDynamicNumberOfGCThreads by default
    + S8198546: [Redo] JDK-8196883 G1RemSet::refine_card_concurrently
    doesn't need to check for cards in collection set
    + S8198552: Multiple javac plugins do not work at the same time.
    + S8198571: [JVMCI] must not install wide vector code unless
    runtime supports it
    + S8198591: compiler/aot/fingerprint tests should be moved to
    open
    + S8198608: Improvements to command-line flags printing
    + S8198649: Switch AWT/Swing's default GTK version to 3
    + S8198652: Stop linking with -base:0x8000000 on Windows
    + S8198753: (dc) DatagramChannel throws unspecified exceptions
    + S8198789: [TESTBUG] CTW of java.base and java.desktop takes
    long time
    + S8198794: Hotspot crash on Cassandra 3.11.1 startup with
    libnuma 2.0.3
    + S8198796: Create test case for CDS + condy
    + S8198826: -XX:+VerifyStack fails with fatal error:
    ExceptionMark constructor expects no pending exceptions
    + S8198833: TestMemoryAwareness Docker container fails with too
    small maximum heap
    + S8198845: Missing resource mark results disassembling
    generated code failure in hs error report
    + S8198894: [PPC64] More generic vector CRC implementation
    + S8198895: Compilation errors in java.desktop with VS 2017
    + S8198896: Remove dead code: cardTableModRefBSForCTRS.hpp
    + S8198897: Compilation errors in jdk.accessibility with VS 2017
    + S8198906: JDK-8196882 breaks VS2013 Win32 builds
    + S8198924: [Graal] java/lang/StackWalker/LocalsAndOperands.java
    timeouts with Graal
    + S8198926: Move ClassLoaderData::_dependencies to
    ClassLoaderData::_handles
    + S8198948: Remove unused parameter evacuation_info from
    G1CollectedHeap::evacuate_collection_set
    + S8198949: Modularize arraycopy stub routine GC barriers
    + S8198950: AArch64:
    org.openjdk.jcstress.tests.varhandles.DekkerTest fails
    + S8198957: Remove unused function
    ArgumentsExt::set_gc_specific_flags
    + S8198969: Update Graal
    + S8198987: [Graal] compiler/intrinsics/sha/sanity tests fail
    on macos with Graal as JIT
    + S8198997: Cache normalized/resolved user.dir property
    + S8199010: attachListener.hpp: Fix potential null termination
    issue found by coverity scans
    + S8199012: SEGV in jni_DetachCurrentThread during VM shutdown
    + S8199024: Remove unneccessary protected and virtual modifiers
    from G1CollectedHeap
    + S8199027: Make protected members private in G1Policy
    + S8199050: reenable concurrent execution of compiler tests
    + S8199066: [JVMCI] EagerJVMCI option should also initialize
    the JVMCI compiler
    + S8199133: [BACKOUT] NMT: Enhance thread stack tracking
    + S8199137: StringInternSync test crashes in exit verification
    + S8199212: [TESTBUG] don't run compiler/aot tests with -Xcomp
    + S8199219: Build failures after JDK-8195148 (Collapse
    G1SATBCardTableModRefBS and G1SATBCardTableLoggingModRefBS
    into a single G1BarrierSet)
    + S8199220: Zero build broken after 8195103, 8191102 and 8189871
    + S8199243: aarch32: ARM 32 build broken after 8165929
    + S8199263: Split interfaceSupport.hpp to not require including
    .inline.hpp files
    + S8199264: Remove universe.inline.hpp to simplify include
    dependencies
    + S8199272: Broken assertion in ClassLoaderData::remove_handle
    + S8199275: Fix inclusions of allocation.inline.hpp
    + S8199278: Javadoc search results does not link to anchors on
    a page
    + S8199282: Remove ValueObj class for allocation subclassing
    for gc code
    + S8199283: Remove ValueObj class for allocation subclassing
    for compiler code
    + S8199319: Remove handles.inline.hpp include from
    reflectionUtils.hpp
    + S8199323: hsdis could not be loaded which are located on long
    path
    + S8199328: Fix unsafe field accesses in heap dumper
    + S8199342: The constant pool forgets it has a Dynamic entry if
    there are overpass methods
    + S8199356: Fix hotspot to allow stdlib to use libc++ and to
    allow changing the deployment target to 10.9
    + S8199421: Add support for vector popcount
    + S8199422: Hotspot build is broken after push of 8197235
    + S8199425: JTReg failure:
    runtime/stringtable/StringTableVerifyTest.java
    + S8199430: Rename MetaspaceAux to something more meaningful
    + S8199431: Split up class Metaspace into a static and a
    non-static part
    + S8199432: metaspace: fix wrong comment and condition in
    SpaceManager::verify()
    + S8199465: {@docRoot} references need to be updated to reflect
    new module/package structure
    + S8199467: Compilation Errors in libinstrument Reentrancy.c
    with VS2017
    + S8199472: Fix non-PCH build after JDK-8199319
    + S8199489: [TESTBUG] don't run CTW tests with -Xcomp
    + S8199511: Do not generate g1_{pre|post}_barrier_slow_id
    without CardTable-enabled barrier set
    + S8199516: Remove dead code overlooked during Full GC work
    + S8199518: test/hotspot/jtreg/runtime/SelectionResolution
    tests take a lot longer to run with fastdebug after JDK-8198423
    + S8199532: [TESTBUG] AbstractMethodErrorTest.java test failed
    with -Xcomp
    + S8199533: ProblemList tests failing after JDK-8153333
    + S8199557: Assert in fromTonga/vm/runtime/defmeth/scenarios/
    /Stress_noredefine/TestDescription.java
    + S8199559: objArrayKlass::oop_iterate() and friends must use
    base_raw() instead of base()
    + S8199561: Fix two typos in the JVMTI documentation
    + S8199603: Build failures after JDK-8199421 "Add support for
    vector popcount"
    + S8199604: Rename CardTableModRefBS to CardTableBarrierSet
    + S8199620: Support for JNI object pinning
    + S8199624: [Graal] Blocking jvmci compilations time out
    + S8199656: Make slow metaspace verifications switchable in
    debug builds
    + S8199667: Unify metaspace list index handling and
    reinstantiate ChunkManager listindex gtest
    + S8199672: ClassCastException is thrown by java.util.Formatter
    when an NumberFormatProvider SPI is used.
    + S8199674: Improve G1 Full GC array marking
    + S8199685: Access arraycopy build failure with GCC 7.3.1
    + S8199696: Remove Runtime1::arraycopy
    + S8199698: Change 8199275 breaks template instantiation for
    xlC (and potentially other compliers)
    + S8199705: Docs.gmk needs to be updated to remove the -html5
    option
    + S8199716: Unused AdjustKlassClosure in psParallelCompact.hpp
    + S8199728: Remove oopDesc::is_scavengable
    + S8199739: Use HeapAccess when loading oops from static fields
    in javaClasses.cpp
    + S8199741: NMT: Tag safepoint polling pages
    + S8199752: NMT: Memory allocated by Unsafe.allocateMemory
    should be tagged as mtOther
    + S8199756: Simplify language, country, script, and variant
    property initialization
    + S8199762: JShell API: Failed to detect override when snippet
    to be overridden has been changed before
    + S8199773: (bf) XXXBuffer:compareTo method is not working as
    expected
    + S8199777: Deprecate -XX:+AggressiveOpts
    + S8199784: PhaseIdealLoop::place_near_use() might return wrong
    control with loop strip mining
    + S8199789: Emit a warning message when t2k is selected via
    system property
    + S8199791: (se) More Selector cleanup
    + S8199809: Don't include frame.inline.hpp and other.inline.hpp
    from .hpp files
    + S8199843: Optimize Integer/Long.highestOneBit()
    + S8199870: colorimaging.md needs to remove mention of KCMS
    + S8199880: runtime/appcds/condy/CondyHelloTest.java missing at
    requires vm.cds
    + S8199886: gc/cslocker/TestCSLocker.java crashes
    + S8199896: [Graal] build Graal on all x86 platforms
    + S8199902: {@docRoot} references need to be updated to reflect
    new module/package structure
    + S8199910: Compiler crashes with -g option and variables of
    intersection type inferred by `var`
    + S8199924: Solaris: Correctly enqueue null arguments of attach
    operations
    + S8200071: Fix test/hotspot/jtreg/ProblemList-graal.txt
    + S8200072: Remove un-needed qualified export from java.base to
    java.desktop
    + S8200116: ConstructInflaterOutput, ConstructDeflaterInput
    still spamming test logs
    + S8200118: [TESTBUG] String concat tests should test
    toString() application order
    + S8200122: Remove unused field Thread.threadQ
    + S8200123: Replace Thread.init with telescoping constructor
    + S8200124: Various cleanups in jar/zip
    + S8200129: Remove D3D Performance Counter.
    + S8200135: test/hotspot/jtreg/compiler/jvmci/compilerToVM/
    /GetExceptionTableTest.java is failing after JDK-8194978
    + S8200136: Problem list test/hotspot/jtreg/compiler/jvmci/
    /compilerToVM/GetExceptionTableTest.java
    + S8200174: compare.sh improvements
    + S8200178: Remove mapfiles for JDK native libraries
    + S8200179: (se) More Selector cleanup
    + S8200180: fix a typo in run-test framework documentation
    + S8200181: Remove superflous non-IPv4 code from
    Java_java_net_TwoStacksPlainSocketImpl_socketListen
    + S8200198: javah man pages were not removed by JDK-8191054
    + S8200199: javac suggests to use var even when var is used
    + S8200213: Configure broken on MIPS
    + S8200215: 17th loop of "let foo = ''"; throws ReferenceError
    + S8200229: Simplify building of libjsig
    + S8200241: [TESTBUG] java/lang/String/concat/ tests should not
    force source/target = 9 anymore
    + S8200256: java/nio/channels/AsynchronousChannelGroup/Basic.java
    fails intermittently
    + S8200289: Reduce number of exceptions created when calling
    Lookup::canBeCached
    + S8200301: deduplicate lambda methods
    + S8200304: TwoStacksPlainDatagramSocketImpl and socket cleaner
    + S8200310: Avoid charset lookup machinery in
    java.nio.charset.StandardCharsets
    + S8200355: local variable inference regression test generates
    classfile in test folder
    + S8200357: Inline SoundLibraries.gmk into Lib-java.desktop.gmk
    + S8200409: jdk11 nightly solaris sparc build failure
    + S8200449: ReadAllReadNTransferTo fails occasionally
- Modified patch:
  * system-pcsclite.patch
    + Rediff to changed context
* Fri Mar 23 2018 fstrba@suse.com
- Update to upstream tag jdk-11+6
  * Fixes:
    + S8186228: sun/security/krb5/auto/KdcPolicy.java fails with
    "java.lang.Exception: Does not match. Output is
    c30000c30000c30000"
    + S8193033: remove terminally deprecated
    sun.misc.Unsafe.defineClass
    + S8196298: Add null Reader and Writer
    + S8199437: Improve diagnostic system assertion message in
    com.sun.net.httpserver impl
    + S8199682: Clean up building the saproc library
    + S8199749: Debug symbols are not copied to exploded image on
    Mac
    + S8199768: jdk/test/lib/compiler/CompilerUtils.java needs to
    provide more control over compilation
    + S8199792: Wrong license header in XMLLimitAnalyzer.java
    + S8199858: solaris-x86_64 : unpack200 fails linking with SS12u4
    + S8199862: Examine ProxyBuilder::referencedTypes startup cost
    + S8199865: Avoid initializing ShortCache in ProxyGenerator
    + S8199869: Missing copyright headers in nashorn source code
    + S8199884: JDK-8199749 broke build with make 3.81
* Tue Mar 20 2018 fstrba@suse.com
- Update to upstream tag jdk-11+5
  * Fixes:
    + S8160767: [TEST_BUG]
    java/awt/Frame/MaximizedToIconified/MaximizedToIconified.java
    + S8182684: Further clarify InputStream#available()
    + S8183554: Add constructors with Charset parameter for
    FileReader and FileWriter
    + S8187635: On Windows Swing changes keyboard layout on a
    window activation
    + S8188240: Reflection Proxy should skip static methods
    + S8189230: JDK method:
    java.lang.Integer.numberOfLeadingZeros(int) can be optimized
    + S8190347: [TESTBUG] Test javax/swing/JWindow/
    /ShapedAndTranslucentWindows/TranslucentJComboBox.java fails
    + S8190767: if JFrame is maximized on OS X, all new JFrames
    will be maximized by default
    + S8193017: Import freetype sources into OpenJDK source tree
    + S8193584: (testbug) TestSocketFactory fails intermittently
    with ConcurrentModificationException
    + S8194767: Regression automated Test
    'javax/swing/JEditorPane/6917744/bug6917744.java' fails
    + S8194943: Regression automated test 'open/test/jdk/javax/
    /swing/JInternalFrame/8020708/bug8020708.java' fails
    + S8195738: scroll poistion in ScrollPane is reset after
    calling validate()
    + S8196435: Regression automated Test 'java/awt/Mouse/
    /GetMousePositionTest/GetMousePositionWithOverlay.java' fails
    + S8196748: tools/jar tests need to tolerate unrelated warnings
    + S8197785: javax.accessibility.AccessibleBundle will reload
    the ResourceBundle for every call to toDisplayString
    + S8198406: Test TestAATMorxFont is unstable
    + S8198605: Touch keyboard is shown for a non-focusable text
    component
    + S8198606: Touch keyboard does not hide, when a text component
    looses focus
    + S8198613: Test cases result in failure or timeout when run
    with OpenGL backend
    + S8198777: JList.getPreferredScrollableViewportSize(): fix
    mistake in doc for height calc
    + S8198889: Clarify the throwing of exceptions from
    ConstantBootstraps.invoke
    + S8198922: Provide instrumentation for
    sanity/client/SwingSet/src/ButtonDemoScreenshotTest.java
    + S8198989: Provide more diagnostic IAE messages
    + S8199009: test/jdk/java/util/Locale/SoftKeys.java fails with
    OutOfMemoryError
    + S8199022: New failures should be added to ProblemList
    + S8199215: Re-examine getFreePort method in test
    infrastructure library
    + S8199258: BigInteger.bitLength() should explicitly specify
    behavior when the value is zero
    + S8199329: Remove code that attempts to read bytes after
    connection reset reported
    + S8199420: Update javadoc tags in java.lang.System and related
    + S8199423: Create builds-infra Mach5 job
    + S8199428: install-file macro fails on filenames with space on
    Solaris
    + S8199443: Nashorn multithread bottleneck with "use strict"
    + S8199451: Create linux-aarch64 cross-compilation devkit, and
    fix cross-compilation
    + S8199453: Enable link-time generation of constructor forms
    + S8199462: Use Reference.reachabilityFence in direct
    ByteBuffer methods
    + S8199464: Remove remaining vestiges of
    Java_sun_reflect_Reflection_getCallerClass
    + S8199469: Disable generate-jli-classes when building
    interim-image
    + S8199470: Remove unused property file.encoding.pkg
    + S8199471: Enable generation of callSiteForms at link time
    + S8199473: Support Visual Studio BuildTools with VS2017
    + S8199483: Clean up some non-standard LDFLAGS usage
    + S8199606: Set -lc as global LIBS on solstudio
    + S8199611: (se) Minor selector implementation clean-up
    + S8199616: Fix @module declarations in tier1 tests
    + S8199636: Unify naming for jaas_unix and jaas_nt
    + S8199639: Introduce SetupJdkLibrary and SetupJdkExecutable
    + S8199640: Split up BUILD_LIBKRB5 into the two, unrelated
    compilations it consists of
    + S8199647: java/util/Locale/SoftKeys.java fails with
    OutOfMemoryError again
    + S8199668: make/lib cleanup
    + S8199681: Remove boilerplate code from creating native jtreg
    tests
    + S8199745: JDK-8199668 introduced a build race on macosx
- Modified patches:
  * system-pcsclite.patch
  * java10-improved-fonts.patch -> java11-improved-fonts.patch
    + Rediff to changed context
* Tue Mar 13 2018 fstrba@suse.com
- Update to upstream tag jdk-11+4
  * Fixes:
    + S4993841: (str) java.lang.Character should have a
    toString(int) method
    + S5076761: JList.setSelectedValue(null, ...) doesn't do
    anything
    + S6372077: JarFile.getManifest() should handle manifest
    attribute name 70 bytes
    + S8041626: Shutdown tracing event
    + S8129569: [TEST_BUG] Test java/awt/Frame/
    /MaximizedToUnmaximized/MaximizedToUnmaximized.java fails
    + S8137326: Methods for comparing CharSequence, StringBuilder,
    and StringBuffer
    + S8148871: Possible wrong expression stack depth at deopt point
    + S8153945: Track if log configuration has changed during
    runtime
    + S8168722: Unified Logging configuration output needs
    simplifying
    + S8169358: httpserver does not close connections when
    RejectedExecutionException occurs
    + S8170976: [TESTBUG] LogTestFixture does not restore previous
    logging state
    + S8171000: Robot.createScreenCapture() crashes in wayland mode
    + S8182765: HTML5 must be the default javadoc codegen mode in
    the near future
    + S8186513: [TESTBUG] javax/swing/JInternalFrame/8160248/
    /JInternalFrameDraggingTest.java
    + S8187066: -Xlog:help "=debug" example is not quite accurate
    + S8187653: Lock in CoderResult.Cache becomes performance
    bottleneck
    + S8187950: javax.lang.model APIs throws CompletionFailure or a
    subtype of CompletionFailure.
    + S8190346: improve unified JVM logging help message and
    warnings
    + S8190679: java/util/Arrays/TimSortStackSize2.java fails with
    "Initial heap size set to a larger value than the maximum heap
    size"
    + S8191139: Remove deprecated javax.security.auth.Policy API
    + S8191369: NMT: Enhance thread stack tracking
    + S8191421: Deprecate PrintSafepointStatistics,
    PrintSafepointStatisticsTimeout and
    PrintSafepointStatisticsCount options
    + S8193262: JNI array not released in libsunmscapi
    convertToLittleEndian
    + S8193660: Check SOURCE line in "release" file for closedjdk
    + S8194085: Obsolete the deprecated SafepointSynchronize flags
    and remove related code
    + S8194296: Check copyright of files in make/langtools/tools
    + S8194870: Some regression tests throw NPE exception on a
    specific Solaris 11.2 sun4v sparc machine
    + S8195065: runtime/appcds/ProhibitedPackage.java intermittent
    failure
    + S8195131: Dead code removal for changes present in JDK-8176795
    + S8195142: Refactor out card table from CardTableModRefBS to
    flatten the BarrierSet hierarchy
    + S8195632: [Graal] Introduce EagerJVMCI flag to force eager
    JVMCI initialization
    + S8196064: AArch64: Merging ld/st into ldp/stp in
    macro-assembler
    + S8196133: JShell crashes when attempting to use bad source
    file in class path
    + S8196196: Headful tests should not be run in headless mode
    + S8196322: [macosx] When the screen menu bar is used, clearing
    the default menu bar should permit AWT shutdown
    + S8196338: [TEST_BUG] sanity/client/SwingSet/src/
    /TextFieldDemoTest.java Failed with timeout
    + S8196868: AARCH64: ld/st instructions hit guarantee assert
    while using sp
    + S8196882: VS2017 Hotspot Defined vsnprintf Function Causes
    C2084 Already Defined Compilation Error
    + S8197408: Bad pointer comparison and small cleanup in
    os_linux.cpp
    + S8197453: Add support of extra problem list
    + S8197482: Make Jemmy ComponentChooser lambda friendly
    + S8197499: RepaintManager does not increase double buffer
    after attaching a device with higher resolution
    + S8197533: Move javax.transaction.xa  to its own module
    + S8197538: Remove mention of hotjava paths in MimeTable.java
    + S8197546: Fix for 8171000 breaks Solaris + Linux builds
    + S8197549: Implement a new method similar to waitState() on
    Operator which run the check on event queue
    + S8197594: String#repeat
    + S8197808: Test java/awt/Dialog/MakeWindowAlwaysOnTop/
    /MakeWindowAlwaysOnTop.java fails on Windows
    + S8197841: Remove unused function Universe::create_heap_ext
    + S8197864: VS2017 (C4334) Result of 32-bit Shift Implicitly
    Converted to 64 bits
    + S8197926: java/awt/dnd/ImageTransferTest/ImageTransferTest.java
    doesnt close the windows in HiDPI setting
    + S8198004: javax/swing/JFileChooser/6868611/bug6868611.java
    throws error
    + S8198005: javax/swing/JFileChooser/7199708/bug7199708.java
    throws error
    + S8198252: Null pointer dereference in fold_compares_helper
    + S8198253: ThreadInfo.from(CompositeData) incorrectly accepts
    CompositeData with missing JDK 6 attributes
    + S8198293: AARCH64 - Add CPU detection code for Cavium Thunder
    X2
    + S8198302: VS2017 (C4477) java.base/windows/native/libnet/
    /NetworkInterface_winXP.c incorrect printf format strings
    + S8198304: VS2017 (C4838, C4312) Various conversion issues
    with gtest tests
    + S8198312: VS2017: Upgrade HOTSPOT_BUILD_COMPILER in
    vm_version.cpp
    + S8198333: ProblemList should be updated for headless mode
    + S8198474: Move JNIHandles::resolve into jniHandles.inline.hpp
    + S8198554: Add fuzzy matching for log levels and tags when
    parsing -Xlog
    + S8198628: further simplifications to lambda classification at
    JavacParser
    + S8198640: VS2017 (LNK4281) Link Warning Against Missed ASLR
    Optimization
    + S8198693: Update ProblemsList for mac
    + S8198697: Simplify initialization of platform encoding
    + S8198703: Missing #include "gc/shared/cardTableModRefBS.hpp"
    in graphKit.hpp
    + S8198724: Refactor FLAGS handling in configure
    + S8198750: [s390+x86_32+aarch64] Fix build after jdk-8195142
    + S8198810: URLClassLoader does not specify behavior when URL
    array contains null
    + S8198821: fix test methods access for test
    java/text/Normalizer/NormalizerAPITest.java
    + S8198825: Resolve missing review feedback for JDK-8170976
    + S8198833: TestMemoryAwareness Docker container fails with too
    small maximum heap
    + S8198834: (ch) Enable java/nio/channels/spi/SelectorProvider/
    /inheritedChannel/InheritedChannelTest.java on linux-x64
    + S8198841: Thread.interrupt should set interrupt status while
    holding blockerLock
    + S8198844: Clean up GensrcX11Wrappers
    + S8198859: Use elfedit to silence linker warnings on solaris
    + S8198862: Stop doing funky compilation stuff for dtrace
    + S8198887: JDK-8168722 broke the build on macosx
    + S8198888: Reduce string allocation churn in
    InvokerBytecodeGenerator
    + S8198898: Compilation errors in jdk.crypto.mscapi with VS 2017
    + S8198899: Compilation errors in java.prefs with VS 2017
    + S8198928: (so) SocketChannel connect may deadlock if closed
    at around same time that connect fails
    + S8198931: remove java.xml.bind module dependency for
    com/sun/jndi tests
    + S8198933: Update JDI tests to pass valid URL[]
    + S8198955: String#repeat loop optimization
    + S8198966: To make CoderResult.Cache.cache final and allocate
    it eagerly
    + S8198970: jnu_util.c compilation error on Solaris
    + S8199015: (se) SocketChannelImpl.translateXXXOps access
    channel state without synchronization
    + S8199018: Test crypto provider not registering
    + S8199052: Configure broken on aarch64
    + S8199103: Can't use COMPARE_BUILD with PATCH from custom root
    + S8199118: Filtering of filename for microsoft CL broken on
    newer Cygwin
    + S8199120: (so) SocketChannelImpl read/write don't need
    stateLock when channel is configured non-blocking
    + S8199125: --disable-warnings-as-errors does not work for
    native jtreg test code
    + S8199152: Configure broken on arm32
    + S8199154: Accessibility issues in jdk.security.auth
    + S8199197: Set _NT_SYMBOL_PATH when running tests on windows
    + S8199198: Remove unused functions in jdk.crypto.mscapi native
    code
    + S8199224: Refactor add_native_source in SetupNativeCompilation
    + S8199236: Nashorn uses deprecated HTML tags in Javadoc
    + S8199266: Update boot and build jdk requirements in configure
    + S8199327: nuke var type name after a lambda has been accepted
    + S8199331: Don't limit debug information for fastdebug JDK
    native libraries
    + S8199338: Use -g0 on solstudio also for compiling C programs
    + S8199339: JDK-8198859 broke solaris x64
    + S8199347: Always use -Z7 for debug symbols when compiling on
    Windows
    + S8199352: The Jib artifact resolver in test lib needs to
    print better error messages
    + S8199403: Require binutils 2.18 or newer
    + S8199405: Bump lowest supported gcc to 4.8
    + S8199416: Remove debug output left over since JDK-8198844
- Removed patches:
  * sorted-diff.patch
    + context changed completely
  * jdk10-gcc6.patch
    + not needed
  * boot_jdk_version.patch
    + correct boot versions handled upsteam
- Changed patch:
  * java10-improved-fonts.patch
    + rediffed to changed context
* Fri Mar  2 2018 fstrba@suse.com
- Update to upstream tag jdk-11+3
  * Fixes:
    + S4916621: Update those still using JDIScaffold to use
    TestScaffold instead.
    + S7127700: G1: Replace G1PLAB with PLAB
    + S8038043: Xerces Update: XInclude update
    + S8060094: java/util/Formatter/Basic.java failed in tr locale
    + S8068593: Remove or repurpose unused PerfCounters from
    objectMonitor
    + S8165929: Constify arguments of Copy methods
    + S8166232: jshell tool: cannot access previous history
    + S8175384: SA: clhsdb 'printall' throws ClassCastException
    while printing out the bytecodes
    + S8176298: Log tags in -Xlog:help not sorted
    + S8179249: Improve process output analysis in CDS tests
    + S8182847: Copy class should use assert macros
    + S8184289: Obsolete -XX:+UnsyncloadClass and
  - XX:+MustCallLoadClassInternal options
    + S8186211: Negative tests for CONSTANT_Dynamic
    + S8186688: javax.lang.model.util.Elements.hides does not work
    correctly with interfaces
    + S8189330: Cleanup FileDescriptor implementation
    + S8190428: Minimal Dynamic Constant support for AArch64
    + S8191375: Add high-level jtreg VMProps to filter out CDS tests
    + S8193056: Title from build failure with Xcode 9.1
    + S8193150: Create a jtreg version of the test from JDK-8187143.
    + S8193373: Cleanup ElfFile and family
    + S8193846: Obsolete the VM option UseUTCFileTimestamp
    + S8193892: Impact of noncloneable MessageDigest implementation
    + S8193909: Obsolete(remove) Co-operative Memory Management (CMM)
    + S8194084: Obsolete FastTLABRefill and remove the related code
    + S8194691: Cleanup unnecessary casts in Atomic/OrderAccess uses
    + S8194994: Remove redundant string streams used for logging
    + S8195103: Refactor out card table from CardTableModRefBS to
    flatten the BarrierSet hierarchy
    + S8195112: x86 (32 bit): implementation for Thread-local
    handshakes
    + S8196308: Update tests AllLineLocations and ClassesByName to
    use TestScaffold instead of JDIScaffold.
    + S8196324: Update tests FilterMatch and FilterNoMatch to use
    TestScaffold.
    + S8196405: [REDO] NMT: add_committed_regions doesn't merge
    succeeding regions
    + S8196602: Change HeapRegionClosure to comply to naming
    conventions
    + S8196759: Move two java/text/Normalizer tests into OpenJDK
    + S8196783: Refactor LogTagLevelExpression into separate classes
    + S8196786: [PPC64+s390] ConstantDynamic support
    + S8196830: publicLookup().findVirtual should not return method
    handle to AccessibleObject.setAccessible
    + S8196880: VS2017 Addition of Global Delete Operator with Size
    Parameter Conflicts with Arena's Chunk Provided One
    + S8196884: VS2017 Multiple Type Cast Conversion Compilation
    Errors
    + S8196889: VS2017 Unable to Instantiate
    OrderAccess::release_store with an Incomplete Class Within an
    Inlined Method
    + S8196909: gcc 7.2.1 compiler warning in libdt_socket
    + S8196920: VerifierTest_1A.java and VerifierTest_1B.java fail:
    assert(receiver_klass->is_subtype_of(static_receiver_klass))
    failed: actual receiver must be subclass of static receiver
    klass
    + S8196930: [Testbug] serviceability/sa/ClhsdbFindPC.java fails
    to find expected output
    + S8196992: Resolve disabled warnings for libdt_socket
    + S8196997: VS2017 The non-Standard std::tr1 namespace and
    TR1-only machinery are deprecated and will be removed
    + S8197412: Enable docker container related tests for linux
    s390x
    + S8197454: Need Access decorator for storing oop into
    uninitialized location
    + S8197518: Kerberos krb5 authentication: AuthList's put method
    leads to performance issue
    + S8197563: assert(is_Loop()) crash in
    PhaseIdealLoop::try_move_store_before_loop()
    + S8197572: s390 build broken after 8165929
    + S8197589: Update CPU count algorithm when both cpu shares and
    quotas are used
    + S8197608: MacroAssembler::unimplemented calls global operator
    new[]
    + S8197772: metaspace uses global operator new/delete for gtest
    testing
    + S8197780: Null pointer dereference in
    Klass::is_instance_klass of klass.hpp:532
    + S8197789: os::SuspendedThreadTask causes references to global
    operator delete
    + S8197827: [windows] Small cleanups after JDK-8185712
    + S8197828: Null pointer dereference in
    MultiNode::proj_out_or_null
    + S8197857: fieldDescriptor prints incorrect 32-bit
    representation of compressed oops
    + S8197859: VS2017 Complains about UINTPTR_MAX definition in
    globalDefinitions_VisCPP.hpp
    + S8197868: VS2017 (C2065) 'timezone': Undeclared Identifier in
    share/runtime/os.cpp
    + S8197901: Crash during GC when logging level is debug
    + S8197906: Enable CDS mode execution of jtreg tests via make
    + S8197945: Qurarantine failing condy tests
    + S8197956: VS2017 (C4838) Narrowing conversion required from
    __int64 to julong
    + S8197968: [Backout] JDK-8196883
    G1RemSet::refine_card_concurrently doesn't need to check for
    cards in collection set
    + S8197992: Move the OopStorage::ParState type out of inline.hpp
    + S8197993: Remove last use of
    JavaThread::flush_barrier_queues()
    + S8197994: Move JavaThread::initialize_queues() logic to
    G1SATBCardTableLoggingModRefBS
    + S8197999: Accessors in typeArrayOopDesc should use new Access
    API
    + S8198225: os::attempt_reserve_memory_at records memory as
    committed
    + S8198249: Remove deprecated Runtime::runFinalizersOnExit and
    System::runFinalizersOnExit
    + S8198251: [Graal] compiler/intrinsics/bmi/verifycode tests
    fail with Graal on macos
    + S8198265: Make
    CollectorPolicy::satisfy_failed_metadata_allocation() virtual
    + S8198267: Allow GCId::current_raw() calls from
    non-NamedThreads
    + S8198268: Add time argument to
    ConcurrentGCTimer::register_gc_pause_start/_end
    + S8198269: Allow GCCauseSetter to be used outside of safepoints
    + S8198270: Remove dangerous assert in HandleArea::oops_do()
    + S8198271: Make CollectedHeap::create_heap_space_summary()
    virtual
    + S8198275: AIX build broken after latest whitebox.cpp changes
    + S8198286: Direct memory accessors in typeArrayOop.hpp should
    use Access API
    + S8198287: Cleanup ElfFile usage in whitebox.cpp
    + S8198311: Avoid uses of global malloc and free
    + S8198341: Build failures after 8194084 (Obsolete
    FastTLABRefill and remove the related code)
    + S8198369: Clean up GCId and GCIdMark
    + S8198373: Remove CollectorPolicy::is/as functions
    + S8198375: Passing 'null' value to lookup param of
    ConstantBootstraps.invoke does not throw NullPointerException
    + S8198420: Remove unused extension point AllocationContextStats
    + S8198439: Fix aarch64 code for handling generate_code_for
    after FastTLABFill obsolete code
    + S8198480: Improve ClassLoaders static init block
    + S8198481: Coding style cleanups for
    src/java.base/share/classes/jdk/internal/loader
    + S8198482: The URLClassPath field "urls" should be renamed to
    "unopenedUrls"
    + S8198484: URLClassPath should use an ArrayDeque instead of a
    Stack
    + S8198485: Simplify a URLClassPath constructor
    + S8198490: java/util/logging/TestLogConfigurationDeadLock.java
    timed out.
    + S8198492: Bootstrapping java.lang.invoke can cause deadlock
    after JDK-8198418
    + S8198507: Remove CollectorPolicy::create_rem_set
    + S8198509: Move satisfy_failed_metadata_allocation out from
    CollectorPolicy
    + S8198511: Move allocation functions from GenCollectorPolicy
    to GenCollectedHeap
    + S8198515: Extract SoftReferencePolicy code out of
    CollectorPolicy
    + S8198522: Javadoc search broken after output files
    organization for modules
    + S8198525: Move _size_policy out of GenCollectorPolicy into
    GenCollectedHeap
    + S8198528: Move GenerationSpecs from GenCollectorPolicy to
    GenCollectedHeap
    + S8198530: Move _gc_policy_counters from GenCollectorPolicy to
    GenCollectedHeap
    + S8198533: Remove obsolete JDIScaffold class from repo.
    + S8198539: Cleanup of unused imports in
    java/util/jar/Attributes.java (java.base) and
    JdpController.java (jdk.management.agent)
    + S8198551: Rename hotspot_tier1 test group to tier1
    + S8198553: jcmd: separate Metaspace statistics from NMT
    + S8198558: Windows does not build without precompiled headers
    + S8198560: Remove implicit casts from oop to JavaThread* and
    jlong*
    + S8198562: (ch) Separate blocking and non-blocking code paths
    (part 1)
    + S8198564: Multiple crashes on SPARC
    + S8198568: clean up test/hotspot/jtreg/ProblemList.txt
    + S8198569: SetupTextFileProcessing should use sed with 'g'
    + S8198573: JShell: class replace loses instances
    + S8198585: add asserts to verify that ServiceUtil::visible_oop
    is not needed
    + S8198627: JDK-8198318 broke readlink testing
    + S8198635: Remove unused safepoint message functions and
    ShowSafepointMsgs
    + S8198645: Use System.lineSeparator() instead of
    getProperty("line.separator")
    + S8198653: ClassLoader::getSystemClassLoader throws
    InternalError when called after shutdown
    + S8198656: Update copyright to 2018
    + S8198658: Docs still point to JDK 9 docs
    + S8198670: [testbug] Test
    jdk/internal/jline/extra/HistoryTest.java is broken after
    8166232
    + S8198726: Quarantine SADebugDTest.java again
    + S8198751: Refactor SetupNativeCompilation to take NAME and
    TYPE
    + S8198754: (ch) Separate blocking and non-blocking code paths
    (part 2)
    + S8198755: Reduce cost of
    InvokerBytecodeGenerator::isStaticallyInvocable/-Nameable
    + S8198808: jdi tests failing after JDK-8198484
    + S8198820: Problem list tools/jimage/JImageExtractTest.java
    + S8198831: Lazy initialization of ValueConversions
    MethodHandles
- Modified patch:
  * system-pcsclite.patch
    + Fix merge error in the patch
* Mon Feb 26 2018 fstrba@suse.com
- Update to upstream tag jdk-11+2
  * Fixes:
    + S8058965: Remove IPv6 support from TwoStacksPlainSocketImpl
    [win]
    + S8153294: Solaris devkit uses linker from system instead of
    in devkit
    + S8170120: jimage throws IOException when the given file is
    not a jimage file
    + S8176474: test/jdk/jshell/JdiBogusHostListenExecutionControlTest.java
    fails with java.net.BindException
    + S8190904: Incorrect currency instance returned by
    java.util.Currency.getInstance()
    + S8194154: System property user.dir should not be changed
    + S8194892: add compiler support for local-variable syntax for
    lambda parameters
    + S8194922: jlink --exclude-resources should never exclude
    module-info.class
    + S8196959: NullPointerException in discovery003.java
    + S8197439: Crash with -XDfind=lambda for anonymous class in
    anonymous class.
    + S8197812: (ref) Data race in Finalizer
    + S8198227: Fix COMPARE_BUILD after forest consolidation
    + S8198228: Spec clarification: j.u.Locale.getDisplayName()
    + S8198301: jdk11+1 was built as 'fcs' instead of 'ea'
    + S8198303: jdk11+1 was build with incorrect GA date as
    2018-03-20
    + S8198306: Add post custom extension hooks to two launchers
    + S8198318: Make build comparisons clean again
    + S8198328: Create devkit for Solaris with developer studio
    12.6 and Solaris11.3
    + S8198379: tools/jimage/JImageListTest.java failing
    + S8198380: tools/jimage/JImageExtractTest.java failing
    + S8198385: Remove property sun.locale.formatasdefault
    + S8198417: Exclude tools/jimage/JImageExtractTest.java and
    tools/jimage/JImageListTest.java on Windows
    + S8198418: Invoke LambdaMetafactory::metafactory exactly from
    the BootstrapMethodInvoker
    + S8198425: make/Main.gmk Add extra extension/override points
    to the make file
    + S8198441: Replace native Runtime::runFinalization0 method
    with shared secrets
    + S8198450: Make jdk.internal.vm.compiler/module-info.java.extra
    reproducable
    + S8198479: JDK build is broken by 8194892
    + S8198502: Exception at runtime due to lambda analyzer
    reattributes live AST
    + S8198512: compiler support for local-variable syntax for
    lambda parameters
    + S8198523: Refactor BootstrapMethodInvoker to further avoid
    runtime type checks
    + S8198563: Test langtools/tools/javac/analyzer/AnonymousInAnonymous.java
    failing after JDK-8198502
* Mon Feb 19 2018 fstrba@suse.com
- Update to upstream tag jdk-11+1
- Removed patches:
  * JDK-8194739-zero.patch
  * aarch64-form_address.patch
    + Integrated upstream
- Modified patch:
  * system-pcsclite.patch
    + Rediff to changed context
* Mon Jan 29 2018 fstrba@suse.com
- Added patch:
  * aarch64-form_address.patch
  - Fix crash due to mistake in committed patch for JDK-8195859
* Fri Jan 26 2018 fstrba@suse.com
- Upgrade to the tip of jdk repository of January 26th, 2018
- Modified patches:
  * disable-doclint-by-default.patch
  * jdk10-gcc6.patch
    + Rediffed to a changed context
- Removed patches:
  * java-10-openjdk-linuxfilestore.patch
  * remove_javah_for_real.patch
    + Integrated upstream
- Added patch:
  * JDK-8194739-zero.patch
    + S8194739: Zero port of 8174962: Better interface invocations
* Tue Jan 16 2018 fstrba@suse.com
- Recommend tzdata-java8 instead of depending on it. This fixes
  build cycles.
* Fri Dec 15 2017 fstrba@suse.com
- Initial package of jdk-11+0
  * java-11-openjdk technology preview
