/*_############################################################################
  _## 
  _##  SNMP4J - SnmpEngineIdProvider.java  
  _## 
  _##  Copyright (C) 2003-2022  Frank Fock (SNMP4J.org)
  _##  
  _##  Licensed under the Apache License, Version 2.0 (the "License");
  _##  you may not use this file except in compliance with the License.
  _##  You may obtain a copy of the License at
  _##  
  _##      http://www.apache.org/licenses/LICENSE-2.0
  _##  
  _##  Unless required by applicable law or agreed to in writing, software
  _##  distributed under the License is distributed on an "AS IS" BASIS,
  _##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  _##  See the License for the specific language governing permissions and
  _##  limitations under the License.
  _##  
  _##########################################################################*/

package org.snmp4j.cfg;

/**
 * The {@link SnmpEngineIdProvider} interface combines {@link EngineIdProvider} and
 * {@link EngineBootsProvider} to provide all persistently held information for a SNMP engine ID,
 * i.e. snmpEngineID and snmpEngineBoots as defined by RFC 3414.
 *
 * @author Frank Fock
 * @since 3.5.0
 */
public interface SnmpEngineIdProvider extends EngineIdProvider, EngineBootsProvider {
}
